<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   badges
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Акције';
$string['activate'] = 'Омогући приступ';
$string['activatesuccess'] = 'Приступ беџевима је успешно омогућен';
$string['addbadgecriteria'] = 'Додај критеријум за беџ';
$string['addcourse'] = 'Додај курсеве';
$string['addcourse_help'] = 'Изаберите све курсеве који треба додати у услове за добијање овог беџа. Држите тастер CTRL да бисте одабрали више курсева.';
$string['addcriteria'] = 'Додај критеријум';
$string['addcriteriatext'] = 'Да бисте започели додавање критеријума изаберите једну од опција из падајућег менија.';
$string['addtobackpack'] = 'Додај у албум';
$string['adminonly'] = 'Ова страница је ограничена само на администраторе сајта.';
$string['after'] = 'након датума издавања.';
$string['aggregationmethod'] = 'Метод агрегације';
$string['all'] = 'Сви';
$string['allmethod'] = 'Сви изабрани услови си испуњени';
$string['allmethodactivity'] = 'Све изабрани активности су завршене';
$string['allmethodcourseset'] = 'Сви изабрани курсеви су завршени';
$string['allmethodmanual'] = 'Све изабране улоге додељују беџ';
$string['allmethodprofile'] = 'Сва изабрана поља профила су комплетирана';
$string['allowcoursebadges'] = 'Омогући беџеве на курсу';
$string['allowcoursebadges_desc'] = 'Дозволите да се беџеви креирају и додељују у контексту курса.';
$string['allowexternalbackpack'] = 'Омогући везу са спољним албумима';
$string['allowexternalbackpack_desc'] = 'Дозволите корисницима да подесе везу и прикажу беџева са својих спољних албума беџева.

Напомена: Препоручује се да ову опцију оставите искључену ако веб сајту не може да се приступи са интернета (нпр. због заштитног зида).';
$string['any'] = 'Било која/е/и/у';
$string['anymethod'] = 'Било који од изабраних услова је испуњен';
$string['anymethodactivity'] = 'Било која од изабраних активности је завршена';
$string['anymethodcourseset'] = 'Било који од изабраних курсева је завршен';
$string['anymethodmanual'] = 'Било која од изабраних улога додељује беџ';
$string['anymethodprofile'] = 'Било које од изабраних поља профила је попуњено.';
$string['attachment'] = 'Приложи беџ уз поруку';
$string['attachment_help'] = 'Ако је ова опција омогућена, датотека издатог беџа биће приложена уз е-поруку добитнику, како би он могао да је преузме. (да би ова опција могла да се користи, додавање датотека уз е-поруке мора бити омогућено у подешавањима сајта – Администрација сајта > Додаци > Излази порука > Електронска пошта).';
$string['award'] = 'Додели беџ';
$string['awardedtoyou'] = 'Беџеви издати мени';
$string['awardoncron'] = 'Приступ беџу је успешно омогућен. Велики број корисника може одмах освојити овај беџ. Да би се осигурало ефикасно функционисање сајта, биће потребно неко време да ова акција буде процесирана.';
$string['awards'] = 'Добитници беџа';
$string['backpackavailability'] = 'Провера екстерног беџа';
$string['backpackavailability_help'] = 'Како би добитници беџева могли да докажу да су своје беџеве добили од вас, потребно је да спољни сервис за албум има могућност приступа вашем сајту и провери беџева које сте издали.
Изгледа да ваш сајт тренутно није доступан, што значи да беџеви које сте већ издали или ће тек бити издати, не могу бити проверени.

**Зашто видим ову поруку?**

Постоји могућност да ваш заштитни зид спречава приступ корисницима изван ваше мреже, да је ваш сајт заштићен лозинком, или да се сајт налази на рачунару који није доступан на интернету (као што су локални рачунари који служе за тестирање и развој).

**Да ли ово представља проблем?**

Овај проблем треба решити на сваком продукционом серверу/сајту на којем се планира издавање беџева, иначе добитници неће моћи да докажу да су добили своје беџеве од вас. Ако ваш сајт још није активан, можете да креирате и издате пробне беџеве док је сајт доступан, а пре него што га ставите у функцију.

**Шта ако не могу читав свој сајт да учиним јавно доступним?**

Једина URL адреса која је неопходна за проверу је [url-мог-сајта]/badges/assertion.php, тако да, уколико сте у могућности да промените подешавања вашег заштитног зида и омогућите приступ овој датотеци, провера беџева ће и даље функционисати без проблема.';
$string['backpackbadges'] = 'Имате укупно {$a->totalbadges} беџ(ев)а који су приказани у {$a->totalcollections} колекције/а, <a href="mybackpack.php">Промените подешавања албума са беџевима</a>.';
$string['backpackconnection'] = 'Веза са албумом';
$string['backpackconnection_help'] = 'Ова страница вам омогућава да подесите везу са спољним албумом беџева. То допушта да се на овом сајту прикажу спољни беџеви, као и да се беџеви овде освојени пребаце у ваш албум.

Тренутно је подржан само <a href="http://backpack.openbadges.org">Mozilla OpenBadges Backpack</a>. Потребно је да отворите налог и пријавите се за албум беџева, пре него што покушате да подесите везу са њим на овој страници.';
$string['backpackdetails'] = 'Подешавања албума беџева';
$string['backpackemail'] = 'Е-адреса';
$string['backpackemail_help'] = 'Е-адреса повезана са вашим албумом беџева. Док сте повезани, сви беџеви који сте освојили на овом сајту биће придружени уз ову е-адресу.';
$string['backpackimport'] = 'Подешавања за увоз беџева';
$string['backpackimport_help'] = 'Након што се веза са албумом беџева успешно успостави, беџеви из вашег албума могу да се прикажу на страници "Моји беџеви", као и на страници вашег профила.

Овде можете да изаберете колекције беџева из свог албума које желите да прикажете у свом профилу.';
$string['badgedetails'] = 'Подаци о беџу';
$string['badgeimage'] = 'Слика';
$string['badgeimage_help'] = 'Ово је слика која ће се користити када се изда беџ.

Да бисте додали нову слике пронађите и изаберите слику (у JPG или PNG формату), а затим кликните на "Сачувај промене". Слика ће бити исечена у облику квадрата а њена величина промењена тако да одговара захтевима слике беџа.';
$string['badgeprivacysetting'] = 'Подешавања приватности беџева';
$string['badgeprivacysetting_help'] = 'Беџеви које сте освојили могу бити приказани на вашој страници профила. Ово подешавање вам омогућава да подесите видљивост новоосвојених беџева.

Подешавања приватности појединачних беџева и даље можете да контролишете на својој страници "Моји беџеви".';
$string['badgeprivacysetting_str'] = 'Аутоматски прикажи беџеве које сам освојио/ла на страници мог профила';
$string['badgesalt'] = 'Насумични стринг (salt) за хеширање е-адреса добитника беџева';
$string['badgesalt_desc'] = 'Коришћење хеш фукнције омогућава албумима да потврде носиоце беџева без откривања њихових е-адреса. Ово подешавање треба да користи само бројеве и слова.

Напомена: Ради успешне провере прималаца молимо избегавајте измене овог подешавања једном кад сте почели са издавањем беџева.';
$string['badgesdisabled'] = 'Беџеви нису омогућени на овом сајту';
$string['badgesearned'] = 'Број освојених беџева: {$a}';
$string['badgesettings'] = 'Подешавања беџева';
$string['badgestatus_0'] = 'Није доступан корисницима';
$string['badgestatus_1'] = 'Доступан корисницима';
$string['badgestatus_2'] = 'Није доступан корисницима';
$string['badgestatus_3'] = 'Доступан корисницима';
$string['badgestatus_4'] = 'Архивиран';
$string['badgestoearn'] = 'Број доступних беџева: {$a}';
$string['badgesview'] = 'Беџеви курса';
$string['badgeurl'] = 'Линк за издати беџ';
$string['bawards'] = 'Добитници ({$a})';
$string['bcriteria'] = 'Критеријум';
$string['bdetails'] = 'Уреди податке';
$string['bmessage'] = 'Порука';
$string['boverview'] = 'Преглед';
$string['bydate'] = 'завршити до';
$string['clearsettings'] = 'Уклони подешавања';
$string['completioninfo'] = 'Овај беџ је издат за завршетак:';
$string['completionnotenabled'] = 'Праћење завршетка није омогућен за овај курс, тако да он не може бити укључен у критеријуме за добијање беџа.Праћење завршетка курса може се омогућити у подешавањима курса.';
$string['configenablebadges'] = 'Када је омогућена, ова функција вам даје могућност да креирате беџеве и да их додељујете корисницима сајта.';
$string['configuremessage'] = 'Порука о беџу';
$string['connect'] = 'Успостави везу';
$string['connected'] = 'Веза успостављена';
$string['connecting'] = 'Повезивање ...';
$string['contact'] = 'Контакт';
$string['contact_help'] = 'Е-адреса издавачa беџа.';
$string['copyof'] = 'Копија {$a}';
$string['coursebadges'] = 'Беџеви';
$string['coursebadgesdisabled'] = 'Беџеви курса нису омогућени на овом сајту.';
$string['coursecompletion'] = 'Студенти морају да заврше овај курс.';
$string['create'] = 'Нови беџ';
$string['createbutton'] = 'Креирај беџ';
$string['creatorbody'] = '<p>{$a->user} је испунио/ла све услове и освојио/ла је беџ. Погледајте издати беџ на {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' је награђен/а!';
$string['criteria_0'] = 'Овај беџ се додељује када...';
$string['criteria_1'] = 'Завршетак активности';
$string['criteria_1_help'] = 'Омогућава да беџ буде додељен корисницима на основу завршетка скупа активности у оквиру курса.';
$string['criteria_2'] = 'Ручно издавања од стране улоге';
$string['criteria_2_help'] = 'Омогућава да беџ буде ручно додељен корисницима од стране корисника са одговарајућом улогом у оквиру сајта или курса.';
$string['criteria_3'] = 'Друштвено учешће';
$string['criteria_3_help'] = 'Друштвено';
$string['criteria_4'] = 'Завршетак курса';
$string['criteria_4_help'] = 'Омогућава да беџ буде додељен корисницима који су завршили курс. Овај критеријум може имати додатне параметре, као што су минимална оцена и датум завршетка курса.';
$string['criteria_5'] = 'Завршетак скупа курсева';
$string['criteria_5_help'] = 'Омогућава да беџ буде додељен корисницима који су завршили скуп курсева. Сваки курс може имати додатне параметре, као што су минимална оцена и датум завршетка курса.';
$string['criteria_6'] = 'Попуњавање профила';
$string['criteria_6_help'] = 'Омогућава да беџ буде додељен корисницима који су попунили одређена поља у свом профилу. Можете да изаберете стандардна и прилагођена поља профила која су доступна корисницима.';
$string['criteriacreated'] = 'Критеријуми за беџ успешно су креирани';
$string['criteriadeleted'] = 'Критеријуми за беџ успешно су обрисани';
$string['criteria_descr'] = 'Студентима ће овај беџ бити додељен када испуне следећи услов:';
$string['criteria_descr_0'] = 'Студентима ће овај беџ бити додељен када испуне <strong>{$a}</strong> од наведених услова.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> од следећих активности је завршена:';
$string['criteria_descr_2'] = 'Овај беџ мора да буде додељен од стране корисника који има <strong>{$a}</strong> од следећих улога:';
$string['criteria_descr_4'] = 'Студенти морају да заврше курс';
$string['criteria_descr_5'] = '<strong>{$a}</strong> од следећих курсева мора да буде завршен:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> од следећих поља корисничког профила мора да буду попуњена:';
$string['criteria_descr_bydate'] = 'до <em>{$a}</em>';
$string['criteria_descr_grade'] = 'са минималном оценом <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Заврши <strong>{$a}</strong> од:';
$string['criteria_descr_short1'] = 'Заврши <strong>{$a}</strong> од:';
$string['criteria_descr_short2'] = 'Беџ је доделио <strong>{$a}</strong> од:';
$string['criteria_descr_short4'] = 'Завршити курс';
$string['criteria_descr_short5'] = 'Заврши <strong>{$a}</strong> од:';
$string['criteria_descr_short6'] = 'Заврши <strong>{$a}</strong> од:';
$string['criteria_descr_single_1'] = 'Следећа активност мора бити завршена:';
$string['criteria_descr_single_2'] = 'Овај беџ мора да додели корисник са следећом улогом:';
$string['criteria_descr_single_4'] = 'Студенти морају да заврше курс';
$string['criteria_descr_single_5'] = 'Следећи курс мора да буде завршен:';
$string['criteria_descr_single_6'] = 'Следећи поље корисничког профила мора да буде попуњено:';
$string['criteria_descr_single_short1'] = 'Завршити:';
$string['criteria_descr_single_short2'] = 'Доделио/ла:';
$string['criteria_descr_single_short4'] = 'Завршити курс';
$string['criteria_descr_single_short5'] = 'Завршити:';
$string['criteria_descr_single_short6'] = 'Завршити:';
$string['criteriasummary'] = 'Резиме критеријума';
$string['criteriaupdated'] = 'Критеријуми за беџ успешно су ажурирани';
$string['criterror'] = 'Тренутни параметри за издавање беџа';
$string['criterror_help'] = 'Овај скуп поља приказује све параметре који су иницајлно додати међу услове за овај беџ. Препоручује се да искључите такве параметре како би осигурали да студенти могу у будућности да добију овај беџ.';
$string['currentimage'] = 'Тренутна слика';
$string['currentstatus'] = 'Тренутни статус:';
$string['dateawarded'] = 'Датум издавања';
$string['dateearned'] = 'Датум: {$a}';
$string['day'] = 'Дан(и)';
$string['deactivate'] = 'Онемогући приступ';
$string['deactivatesuccess'] = 'Приступ беџевима је успешно онемогућен.';
$string['defaultissuercontact'] = 'Подразумевани контакт подаци о издавачу беџа';
$string['defaultissuercontact_desc'] = 'Е-адреса издавачa беџа.';
$string['defaultissuername'] = 'Подразумевано име/назив издавача беџа';
$string['defaultissuername_desc'] = 'Име особе/назив институције надлежне за издавање беџева.';
$string['delbadge'] = 'Обриши беџ';
$string['delconfirm'] = 'Да ли сте сигурни да желите да обришете \'{$a}\'?';
$string['delcritconfirm'] = 'Да ли сте сигурни да желите да обришете овај критеријум?';
$string['delparamconfirm'] = 'Да ли сте сигурни да желите да обришете овај параметар?';
$string['description'] = 'Опис';
$string['disconnect'] = 'Прекини везу';
$string['donotaward'] = 'Тренутно, овај беџ није активан, тако да не може бити додељен студентима. Ако желите да доделите овај беџ активирајте његов статус.';
$string['editsettings'] = 'Уреди подешавања';
$string['enablebadges'] = 'Омогући беџеве';
$string['error:backpackdatainvalid'] = 'Подаци добијени од албума беџева били су неисправни';
$string['error:backpackemailnotfound'] = 'Е-адреса \'{$a}\' није повезана са албумом беџева. Потребно је да <a href="http://backpack.openbadges.org">креирате албум</a> за тај налог или да се пријавите са другом е-адресом.';
$string['error:backpackloginfailed'] = 'Нисте могли бити повезани са спољним албумом беџева из следећег разлога: {$a}';
$string['error:backpacknotavailable'] = 'Ваш сајт није доступан са интернета, тако да ниједан беџ издат на овом сајту не може да буде проверен од стране спољних албума беџева.';
$string['error:backpackproblem'] = 'Дошло је до проблема у повезивању са Вашим пружаоцем услуга. Молимо покушајте касније.';
$string['error:badjson'] = 'Покушај успостављања везе је вратио неисправне податке.';
$string['error:cannotact'] = 'Није могуће активирати беџ.';
$string['error:cannotawardbadge'] = 'Није могуће доделити беџ кориснику';
$string['error:clone'] = 'Није могуће клонирати беџ.';
$string['error:connectionunknownreason'] = 'Повезивање је било неуспешно из непознатог разлога';
$string['error:duplicatename'] = 'Беџ са таквим називом већ постоји у систему';
$string['error:externalbadgedoesntexist'] = 'Беџ није пронађен';
$string['error:guestuseraccess'] = 'Тренутно приступате систему као гост. Да бисте видели беџеве потребно ја да се пријавите помоћу свог корисничког налога..';
$string['error:invalidbadgeurl'] = 'Неисправан формат URL адресе издавача беџа.';
$string['error:invalidcriteriatype'] = 'Неважећи тип критеријум';
$string['error:invalidexpiredate'] = 'Датум истека мора да буде у будућности.';
$string['error:invalidexpireperiod'] = 'Датум истека не може бити негативан или једнак 0.';
$string['error:noactivities'] = 'На овом курсу не постоје активности са омогућеним критеријумом за завршетак.';
$string['error:noassertion'] = 'Од систем за проверу идентитета Persona није добијена никаква потврда. Можда сте затворили оквир за дијалог пре него што се процес пријављивања завршио.';
$string['error:nocourses'] = 'Праћење завршетка курса није омогућено ни за један од курсева на овом сајту, тако да нема курса који би могао бити приказан. Праћење завршетка курса може се омогућити у подешавањима курса.';
$string['error:nogroups'] = '<p>У вашем албуму нема доступних јавних колекција беџева </p>
<p>Приказане су само јавне колекције. <a href="http://backpack.openbadges.org">Посетите свој албум</a> како бисте креирали јавне колекције беџева.</p>';
$string['error:nopermissiontoview'] = 'Немате дозволу да видите добитнике беџева';
$string['error:nosuchbadge'] = 'Беџ са id бројем {$a} не постоји.';
$string['error:nosuchcourse'] = 'Упозорење! Ова активност више није доступна.';
$string['error:nosuchfield'] = 'Упозорење! Ово корисничко поље више није доступно.';
$string['error:nosuchmod'] = 'Упозорење! Ова активност више није доступна.';
$string['error:nosuchrole'] = 'Упозорење! Ова улога више није доступна.';
$string['error:nosuchuser'] = 'Корисник са овом е-адресом нема налог код текућег провајдера албума беџева.';
$string['error:notifycoursedate'] = 'Упозорење! Беџеви повезани са  завршетком курса и активности неће бити издати до датума почетка курса.';
$string['error:parameter'] = 'Упозорење: Најмање један параметар треба да буде изабран како би се обезбедио исправан процес издавања беџева.';
$string['error:personaneedsjs'] = 'Тренутно, Javascript је неопходан за повезивање са вашим албумом беџева. Ако можете, омогућите Javascript и поново учитајте страницу.';
$string['error:requesterror'] = 'Захтев за успоставу везе није успео (кôд грешке {$a}).';
$string['error:requesttimeout'] = 'Захтев за успоставу везе је истекао пре него што је могао да се заврши.';
$string['error:save'] = 'Није могуће сачувати беџ.';
$string['error:userdeleted'] = '{$a->user} (Овај корисник више не постоји на сајту {$a->site})';
$string['evidence'] = 'Доказ';
$string['existingrecipients'] = 'Постојећи добитници беџа';
$string['expired'] = 'Истекло';
$string['expiredate'] = 'Овај беџ истиче {$a}.';
$string['expireddate'] = 'Овај беџ је истекао {$a}.';
$string['expireperiod'] = 'Овај беџ истиче {$a} дан(а) након што је издат.';
$string['expireperiodh'] = 'Овај беџ истиче {$a} час(ов)а након што је издат.';
$string['expireperiodm'] = 'Овај беџ истиче {$a} минут(а) након што је издат.';
$string['expireperiods'] = 'Овај беџ истиче {$a} секунду/е/и након што је издат.';
$string['expirydate'] = 'Датум истека';
$string['expirydate_help'] = 'Опционо, беџеви могу истећи одређеног датума, или се датум може израчунати на основу датума када је беџ издат кориснику.';
$string['externalbadges'] = 'Моји беџеви са других сајтова';
$string['externalbadges_help'] = 'Овде су приказани беџеви уз ваших спољних албума.';
$string['externalbadgesp'] = 'Беџеви са других сајтова';
$string['externalconnectto'] = 'Да бисте приказали спољне беџеве потребно је да <a href="{$a}">успоставите везу са албумом</a>.';
$string['fixed'] = 'Фиксни датум';
$string['hidden'] = 'Скривено';
$string['hiddenbadge'] = 'Нажалост, власник беџа није учинио ове информације доступним.';
$string['issuancedetails'] = 'Беџ истиче';
$string['issuedbadge'] = 'Информације о издатаом беџу';
$string['issuerdetails'] = 'Подаци о издавачу';
$string['issuername'] = 'Име/назив издавача беџа';
$string['issuername_help'] = 'Име особе/назив институције надлежне за издавање беџева.';
$string['issuerurl'] = 'URL адреса издавача';
$string['localbadges'] = 'Моји беџеви са веб сајта {$a}';
$string['localbadgesh'] = 'Моји беџеви са овога сајта';
$string['localbadgesh_help'] = 'Сви беџеви у оквиру овог сајта, добијени на основу завршетка курсева и активности унутар курсева, као и испуњавањем других услова.

Овде можете управљати својим беџевима тако што ћете их учинити јавним или приватним за свој страницу профила.

Можете да преузмете све своје беџеве или сваки беџ засебно, и сачувате их на свом компјутеру. Преузете беџеви можете да додајете у своје спољне албуме беџева.';
$string['localbadgesp'] = 'Беџеви са {$a}:';
$string['localconnectto'] = 'Да бисте делили беџеве ван овог сајта потребно је да <a href="{$a}">успоставите везу са албумом</a>.';
$string['makeprivate'] = 'Учини приватним';
$string['makepublic'] = 'Учини јавним';
$string['managebadges'] = 'Управљање беџевима';
$string['message'] = 'Тело поруке';
$string['messagebody'] = '<p>Додељен вам је беџ "%badgename%"!</p>
<p>Више информација о овом беџу можете наћи на %badgelink%.</p>
<p>Беџ можете преузети са странице {$a}.</p>';
$string['messagesubject'] = 'Честитамо! Освојили сте беџ!';
$string['method'] = 'Овај критеријум је испуњен када...';
$string['mingrade'] = 'Неопходна је минимална оцена';
$string['month'] = 'Месец(и)';
$string['mybackpack'] = 'Подешавања мог албума беџева';
$string['mybadges'] = 'Моји беџеви';
$string['never'] = 'Никад';
$string['newbadge'] = 'Додај нови беџ';
$string['newimage'] = 'Нова слика';
$string['noawards'] = 'Овај беџ још нико није добио.';
$string['nobackpack'] = 'Не постоји албум беџева који је повезан са овим налогом.<br/>';
$string['nobackpackbadges'] = 'Не постоје беџеви у колекцији коју сте израбрали. <a href="mybackpack.php">Додај још колекција</a>.';
$string['nobackpackcollections'] = 'Није изабрана ниједна колекција беџева. <a href="mybackpack.php">Додај колекције</a>.';
$string['nobadges'] = 'Нема доступних беџева';
$string['nocriteria'] = 'Критеријуми за овај беџ још нису подешени';
$string['noexpiry'] = 'Овај беџ нема датум истека';
$string['noparamstoadd'] = 'Нема додатних параметара доступних за додавање услова за добијање овог беџа';
$string['notacceptedrole'] = 'Ваша тренутна улога се не налази међу улогама које могу ручно да издају овај беџ.<br/>
Ако желите да видите кориснике који су већ освојили овај беџ , можете да посетите страницу {$a}.';
$string['notconnected'] = 'Веза није успостављена';
$string['nothingtoadd'] = 'Не постоје доступни критеријуми за додавање.';
$string['notification'] = 'Обавести креатора беџа';
$string['notification_help'] = 'Ово подешавање управља обавештењима која се шаљу креаторима беџева како би знали да је беџ издата.

Доступне су следеће опције:

* **НИКАД** – Обавештења се не шаљу.

* **СВАКИ ПУТ** – Обавештење се шаље сваки пута када је беџ додељен.

* **ДНЕВНО** – Обавештење се шаље једном дневно.

* **СЕДМИЧНО** – Обавештење се шаље једном седмично.

* **МЕСЕЧНО** – Обавештење се шаље једном месечно.';
$string['notifydaily'] = 'Дневно';
$string['notifyevery'] = 'Сваки пут';
$string['notifymonthly'] = 'Месечно';
$string['notifyweekly'] = 'Седмично';
$string['numawards'] = 'Број корисника којима је издат овај беџ: <a href="{$a->link}">{$a->count}</a>..';
$string['numawardstat'] = 'Број корисника којима је издат овај беџ: {$a}';
$string['overallcrit'] = 'од изабраних критеријума су испуњени';
$string['personaconnection'] = 'Пријавите се са својом е-адресом';
$string['personaconnection_help'] = 'Persona је систем који вам омогућава да се идентификујете широм интернете, помоћу адресе е-поште коју користите. Албум Отворених Беџева (Open Badges backpack) користи систем Persona као систем за пријављивање, тако да можете да повежете албум који вам је потребан са Persona налогом.

За више информација о систему Persona погледајте на <a href="https://login.persona.org/about">https://login.persona.org/about</a>.';
$string['potentialrecipients'] = 'Потенцијални добитници беџева';
$string['recipientdetails'] = 'Детаљи о примаоцу';
$string['recipientidentificationproblem'] = 'Није могуће наћи примаоца овог беџа међу постојећим корисницима.';
$string['recipients'] = 'Добитници беџа';
$string['recipientvalidationproblem'] = 'Тренутни корисник не може бити потврђен као прималац овог беџа.';
$string['relative'] = 'Релативни датум';
$string['requiredcourse'] = 'Најмање један курс треба додати у критеријум за скуп курсева.';
$string['reviewbadge'] = 'Промене у приступ беџу';
$string['reviewconfirm'] = '<p>Ово ће учинити да ваш беџ буде видљив корисницима и омогућити им да га освоје.</p>

<p>Постоји могућност да неки корисници већ испуњавају критеријуме за добијање овог беџа. Њима ће беџ бити додељен одмах након што га учините доступним.</p>

<p>Једном када је беџ додељен он ће бити <strong>закључан</strong> - одређена подешавања, укључујући критеријуме и време истека, више неће моћи да се мењају.</p>

<p>Да ли сте сигутни да желите да омогућите приступ беџу \'{$a}\'?</p>';
$string['save'] = 'Сачувај';
$string['searchname'] = 'Претражи по имену';
$string['selectaward'] = 'Изаберите улогу коју желите да користите за додељивање овог беџа:';
$string['selectgroup_end'] = 'Приказна се у само јавне колеккције. <a href="http://backpack.openbadges.org">Посетите свој албум</a> како бисте креирали јавне колекције беџева.';
$string['selectgroup_start'] = 'Изаберите колекције беџева из свог албума за приказ на овом сајту:';
$string['selecting'] = 'Са изабраним беџевима...';
$string['setup'] = 'Подеси везу';
$string['signinwithyouremail'] = 'Пријавите се са својом е-адресом';
$string['sitebadges'] = 'Беџеви сајта';
$string['sitebadges_help'] = 'Беџеви на нивоу сајта се могу доделити корисницима само за активности који су вези са сајтом. Ово укључује завршетак скупа курсева или делова корисничких профила. Беџеви сајта могу се, такође, ручно доделити од стране једног корисника другом кориснику.

Беџеви за курсеве морају да се креирају на нивоу курса. Беџеви курса могу да се пронађу под Администрација курса> Беџеви.';
$string['status'] = 'Статус беџа';
$string['status_help'] = 'Статус беџа одређује његова понашање у систему

* **ДОСТУПАН** – значи да корисници могу да зараде овај беџ. Док је беџ доступан корисницима, критеријум за његово добијање не могу да се мењају.

* **НИЈЕ ДОСТУПАН** – значи да беџ није доступан корисницима и да не може бити добијен или ручно додељен. Ако овај беџ претходно уопште није издаван, критеријуми за његово добијање могу да се мењају.

Једном када је беџ додељен барем једном кориснику, он аутоматски постаје **ЗАКЉУЧАН**. Корисници и даље могу добијају закључане беџеве, али критеријуми за добијање тих беџева више не могу да се мењају. Ако желите да мењате податке или критеријуме закључаног беџа, можете направити његову копију и унети све неопходне промене.

*Зашто закључавамо беџеве?*

Желимо да се уверимо да су сви корисници испунили исте услове за добијање беџа. Тренутно, није могуће да се беџ опозове. Уколико бисмо дозволили да се услови за добијање беџа мењају у сваком тренутку, то би на крају, највероватније, довело до тога да имамо кориснике који су исти беџ добили за испуњавање потпуно различитих услова.';
$string['statusmessage_0'] = 'Овај беџ тренутно није доступан корисницима. Омогућите пристуо ако желите да корисници освоје овај беџ.';
$string['statusmessage_1'] = 'Овај беџ је тренутно доступан корисницима. Онемогућите приступ како бисте направили промене.';
$string['statusmessage_2'] = 'Овај беџ тренутно није доступан корисницима. а његови критеријум су закључани. Омогућите приступ ако желите да корисници освоје овај беџ.';
$string['statusmessage_3'] = 'Овај беџ је тренутно доступан корисницима, а његови критеријуми су закључани.';
$string['statusmessage_4'] = 'Овај беџ је тренутно архивиран.';
$string['subject'] = 'Тема поруке';
$string['variablesubstitution'] = 'Замена променљивих у порукама.';
$string['variablesubstitution_help'] = 'У поруку о беџу, могу да се убаце одређене променљиве у тему и/или тело поруке, тако да, када се шаље порука, променљиве буду замењене са реалним вредностима. Променљиве треба убацити у текст тачно онако како је доле приказано. Могу се користити следеће променљиве:

%badgename%
: Ово ће бити замењено пуним називом беџа.

%username%
: Ово ће бити замењено именом и презименом добитника беџа.

%badgelink%
: Ово ће бити замењено јавном URL адресом са информацијама о издатом беџу.';
$string['viewbadge'] = 'Погледај издате беџеве';
$string['visible'] = 'Видљиво';
$string['warnexpired'] = '(Овај беџ је истекао!)';
$string['year'] = 'Година(е)';
