<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'ko', branch 'MOODLE_26_STABLE'
 *
 * @package   role
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = '역할 추가하기';
$string['addrole'] = '역할 추가';
$string['advancedoverride'] = '고급 역할 덮어쓰기';
$string['allow'] = '허용';
$string['allowassign'] = '역할 부여 허용';
$string['allowed'] = '허용됨';
$string['allowoverride'] = '역할 덮어쓰기 허용';
$string['allowroletoassign'] = '{$a->fromrole} 역할을 지닌 사용자에게 {$a->targetrole} 역할 부여 허용';
$string['allowroletooverride'] = '{$a->fromrole} 역할을 지닌 사용자에게 {$a->targetrole} 역할 덮어쓰기 허용';
$string['allowroletoswitch'] = '{$a->fromrole} 역할을 지닌 사용자에게 {$a->targetrole} 역할 교환 허용';
$string['allowswitch'] = '역활 교환 허용';
$string['allsiteusers'] = '사이트의 모든 사용자';
$string['archetype'] = '역할 원형';
$string['archetypecoursecreator'] = '원형: 강좌 생성자';
$string['archetypeeditingteacher'] = '원형: 선생님';
$string['archetypefrontpage'] = '원형: 시작 페이지 인증 사용자';
$string['archetypeguest'] = '원형: 방문객';
$string['archetype_help'] = '역할 원형은 역할을 기본으로 되돌릴 때 사용권한를 결정합니다. 또한 사이트가 업그레이드 될 때 새로운 사용 권한을 결정합니다.';
$string['archetypemanager'] = '원형: 관리자';
$string['archetypestudent'] = '원형: 학생';
$string['archetypeteacher'] = '원형: 선생님(편집권한 없는)';
$string['archetypeuser'] = '원형: 인증된 사용자';
$string['assignanotherrole'] = '다른 역할 부여';
$string['assignedroles'] = '부여된 역할';
$string['assignerror'] = '사용자 {$a->user} 에게  {$a->role} 역할을 부여하던 중 오류';
$string['assignglobalroles'] = '시스템 역할 부여';
$string['assignmentcontext'] = '부여 문맥';
$string['assignmentoptions'] = '부여 조건';
$string['assignrole'] = '역할 부여';
$string['assignrolenameincontext'] = '{$a->context} 에서 \'{$a->role}\' 역할 부여';
$string['assignroles'] = '역할 부여';
$string['assignroles_help'] = '문맥영역(contexts)에서 사용자에게 역할을 부여하면 현 문맥영역 및 그 하위 문맥영역에 대한 역할에 포함된 권한을 부여하게 됩니다.

예로서 만일 사용자가 강좌에서 학생 역할을 부여받는다면, 그들은 강좌안의 모든 활동과 블록안에서 학생의 역할을 갖게 됩니다. 
';
$string['assignrolesin'] = '{$a} 에서 역할 부여';
$string['assignrolesrelativetothisuser'] = '이 사용자와 관련된 역할 부여';
$string['backtoallroles'] = '역할 목록으로 되돌아 가기';
$string['backup:anonymise'] = '백업시 사용자 데이터 익명화';
$string['backup:backupactivity'] = '활동 백업';
$string['backup:backupcourse'] = '강좌 백업';
$string['backup:backupsection'] = '영역 백업';
$string['backup:backuptargethub'] = '허브 백업';
$string['backup:backuptargetimport'] = '목적지 백업';
$string['backup:configure'] = '백업 설정';
$string['backup:downloadfile'] = '백업 영역에서 파일 내려받기';
$string['backup:userinfo'] = '사용자 정보 백업';
$string['badges:awardbadge'] = '사용자에게 뱃지 수여';
$string['badges:configurecriteria'] = '뱃지 획득 기준 설정/편집';
$string['badges:configuredetails'] = '뱃지 세부사항 설정/편집';
$string['badges:configuremessages'] = '뱃지 메세지 구성';
$string['badges:createbadge'] = '뱃지 생성/복제';
$string['badges:deletebadge'] = '뱃지 삭제';
$string['badges:earnbadge'] = '뱃지 획득';
$string['badges:manageglobalsettings'] = '뱃지 전역 설정 관리';
$string['badges:manageownbadges'] = '획득한 뱃지 보기 및 관리';
$string['badges:viewotherbadges'] = '다른 사용자 개인정보에서 공개된 뱃지 보기';
$string['block:edit'] = '블록 설정';
$string['block:view'] = '블록 보기';
$string['blog:associatecourse'] = '이 능력은 사용되지 않으며 아무것도 하지 않습니다.';
$string['blog:associatemodule'] = '이 능력은 사용되지 않으며 아무것도 하지 않습니다.';
$string['blog:create'] = '블로그 항목 생성';
$string['blog:manageentries'] = '입력내용 관리';
$string['blog:manageexternal'] = '외부 블로그 편집 및 관리';
$string['blog:manageofficialtags'] = '태그 관리';
$string['blog:managepersonaltags'] = '개인태그 관리';
$string['blog:search'] = '블로그 검색';
$string['blog:view'] = '블로그 보기';
$string['blog:viewdrafts'] = '블로그 초안 보기';
$string['calendar:manageentries'] = '일정 관리';
$string['calendar:managegroupentries'] = '모둠일정 관리';
$string['calendar:manageownentries'] = '개인 일정 관리';
$string['capabilities'] = '권한';
$string['capability'] = '능력';
$string['category:create'] = '범주 만들기';
$string['category:delete'] = '범주 삭제';
$string['category:manage'] = '범주 관리';
$string['category:update'] = '범주 업데이트';
$string['category:viewhiddencategories'] = '비공개 범주 보기';
$string['category:visibility'] = '비공개 범주 보기';
$string['checkglobalpermissions'] = '시스템 권한 점검';
$string['checkpermissions'] = '권한 점검';
$string['checkpermissionsin'] = '{$a} 의 권한 점검';
$string['checksystempermissionsfor'] = '{$a->fullname} 에 대한 시스템 역활 점검';
$string['checkuserspermissionshere'] = '{$a->contextlevel} 문맥에서 {$a->fullname} 가 지닌 권한 점검';
$string['chooseroletoassign'] = '부여할 역할을 선택';
$string['cohort:assign'] = '수업집단 구성원 추가/제거';
$string['cohort:manage'] = '수업집단 생성, 삭제 및 이동';
$string['cohort:view'] = '강좌의 수업집단 보기';
$string['comment:delete'] = '덧글 삭제';
$string['comment:post'] = '덧글 게시';
$string['comment:view'] = '덧글 보기';
$string['community:add'] = '허브를 검색하여 강좌를 찾으려면 커뮤니티 블록을 사용하세요.';
$string['community:download'] = '커뮤니티 블록에서 강좌 다운로드';
$string['confirmaddadmin'] = '사용자 <strong>{$a}</strong>를 새 사이트 관리자로 추가하기를 원하십니까?';
$string['confirmdeladmin'] = '사용자 <strong>{$a}</strong>를 사이트 관리자 목록에서 제거하기를 원하십니까?';
$string['confirmroleprevent'] = '정말 {$a->context}  문맥에서 능력 {$a->cap} 에 대한 허용된 역할 목록에서 <strong>{$a->role}</strong> 역할을 제거하기를 원하십니까?';
$string['confirmroleunprohibit'] = '정말 {$a->context}  문맥에서 능력 {$a->cap} 에 대한 금지된 역할 목록에서 <strong>{$a->role}</strong> 역할을 제거하기를 원하십니까?';
$string['confirmunassign'] = '이 사용자로부터 이 역할을 제거하기를 원하십니까?';
$string['confirmunassignno'] = '취소';
$string['confirmunassigntitle'] = '역할 변경 학인';
$string['confirmunassignyes'] = '제거';
$string['context'] = '문맥';
$string['course:activityvisibility'] = '활동 공개/비공개';
$string['course:bulkmessaging'] = '여러 사람에게 메시지 발송';
$string['course:changecategory'] = '강좌 범주 변경';
$string['course:changefullname'] = '강좌명 변경';
$string['course:changeidnumber'] = '강좌 식별번호 변경';
$string['course:changeshortname'] = '강좌 단축명 변경';
$string['course:changesummary'] = '강좌 요약 변경';
$string['course:create'] = '강좌 생성';
$string['course:delete'] = '강좌 삭제';
$string['course:enrolconfig'] = '강좌 등록방법 설정';
$string['course:enrolreview'] = '강좌 등록 검토';
$string['course:manageactivities'] = '활동 관리';
$string['course:managefiles'] = '파일 관리';
$string['course:managegrades'] = '성적 관리';
$string['course:managegroups'] = '모둠 관리';
$string['course:managescales'] = '척도 관리';
$string['course:markcomplete'] = '강좌이수완료에 사용자를 완료한 것으로 표기';
$string['course:movesections'] = '섹션 이동';
$string['course:publish'] = '허브에 강좌 공개';
$string['course:request'] = '강좌 개설 요청';
$string['course:reset'] = '강좌 초기화';
$string['course:sectionvisibility'] = '영역 보기 조정';
$string['course:setcurrentsection'] = '현재 영역 설정';
$string['course:update'] = '강좌 설정 업데이트';
$string['course:useremail'] = '이메일 활성화';
$string['course:view'] = '참여하지 않고 강좌 보기';
$string['course:viewcoursegrades'] = '강좌 성적 보기';
$string['course:viewhiddenactivities'] = '비공개 활동 보기';
$string['course:viewhiddencourses'] = '비공개 강좌 보기';
$string['course:viewhiddensections'] = '비공개 영역 보기';
$string['course:viewhiddenuserfields'] = '비공개 사용자항목 보기';
$string['course:viewparticipants'] = '참여자 보기';
$string['course:viewscales'] = '척도 보기';
$string['course:viewsuspendedusers'] = '유보된 사용자들을 볼 수 있습니다.';
$string['course:visibility'] = '강좌 공개/비공개';
$string['createrolebycopying'] = '{$a} 를 복사하여 새 역할 생성';
$string['createthisrole'] = '역할 생성';
$string['currentcontext'] = '현재의 문맥';
$string['currentrole'] = '현재 역할';
$string['customroledescription'] = '맞춤 설명';
$string['customrolename'] = '맞춤 전체 이름';
$string['defaultrole'] = '기본 역할';
$string['defaultx'] = '기본: {$a}';
$string['defineroles'] = '역할 정의';
$string['deletecourseoverrides'] = '강좌내 모든 재설정된 역할 삭제';
$string['deletelocalroles'] = '영역에서 부여한 모든 역할 삭제';
$string['deleterolesure'] = '"{$a->name} ({$a->shortname})" 역할을 삭제하는 것이 확실합니까? </p><p> 현재 이 역할은 {$a->count} 명에게 부여되어 있습니다.';
$string['deletexrole'] = '{$a} 역할 삭제';
$string['duplicaterole'] = '역할 복제';
$string['duplicaterolesure'] = '정말 "{$a->name} ({$a->shortname})" 역할을 복제하겠습니까?</p>';
$string['editingrolex'] = '{$a} 역할 수정하기';
$string['editrole'] = '역할 편집';
$string['editxrole'] = '{$a} 역할 수정';
$string['errorbadrolename'] = '잘못된 역할명';
$string['errorbadroleshortname'] = '잘못된 역할 단축 이름';
$string['errorexistsrolename'] = '이미 역할명이 존재함';
$string['errorexistsroleshortname'] = '이미 단축역할명이 존재함';
$string['eventroleallowassignupdated'] = '역할 부여 허용';
$string['eventroleallowoverrideupdated'] = '역할 덮어쓰기 허용';
$string['eventroleallowswitchupdated'] = '역할 바꿈 허용';
$string['eventroleassigned'] = '부여된 역할';
$string['eventrolecapabilitiesupdated'] = '업데이트된 역할 능력';
$string['eventroledeleted'] = '삭제된 역할';
$string['eventroleunassigned'] = '부여되지 않은 역할';
$string['existingadmins'] = '기존 사이트 관리자';
$string['existingusers'] = '{$a} 기존 사용자';
$string['explanation'] = '설명';
$string['export'] = '내보내기';
$string['extusers'] = '기존 사용자들';
$string['extusersmatching'] = '\'{$a}\' 와 일치하는 기존 사용자';
$string['filter:manage'] = '필터설정 관리';
$string['frontpageuser'] = '시작 페이지의 인증 사용자';
$string['frontpageuserdescription'] = '시작 페이지 강좌에 로그인한 모든 사용자';
$string['globalrole'] = '시스템 역할';
$string['globalroleswarning'] = '경고! 이 페이지에서 사용자에게 부여한 역할은 시작 페이지와 모든 강좌를 포함하는 사이트 전체 시스템에 적용됩니다.';
$string['gotoassignroles'] = '{$a->contextlevel} 문맥에 대해 역할 부여로 가기';
$string['gotoassignsystemroles'] = '시스템 역활 부여로 가기';
$string['grade:edit'] = '성적 편집';
$string['grade:export'] = '성적 내보냄';
$string['grade:hide'] = '성적 또는 항목을 숨김/숨기지 않음';
$string['grade:import'] = '성적 가져옴';
$string['grade:lock'] = '성적 또는 항목 잠금';
$string['grade:manage'] = '성적 항목 관리';
$string['grade:managegradingforms'] = '고급 채점 방법 관리';
$string['grade:manageletters'] = '문자 성적 관리';
$string['grade:manageoutcomes'] = '문자 학습성과 관리';
$string['grade:managesharedforms'] = '고급 채점 양식 템플릿 관리';
$string['grade:override'] = '성적 덮어쓰기';
$string['grade:sharegradingforms'] = '고급 채점 양식을 템플릿으로 공유';
$string['grade:unlock'] = '성적 혹은 항목 잠금해제';
$string['grade:view'] = '내 성적 보기';
$string['grade:viewall'] = '다른 사람 성적 보기';
$string['grade:viewhidden'] = '숨겨진 성적 보기';
$string['hidden'] = '비공개';
$string['highlightedcellsshowdefault'] = '아래 표의 강조된 칸은 \'정규 역할 유형\'에 기반한 표준 권한을 보여줍니다.';
$string['highlightedcellsshowinherit'] = '아래 표의 강조된 칸은 상속될 수 있는 권한을 보여줍니다. 실제 변경하고자 하는 권한과는 별개로, 모든 것을 상속으로 두어야 합니다.';
$string['inactiveformorethan'] = '{$a->timeperiod} 이상 비활동';
$string['ingroup'] = '모둠 "{$a->group}" 속';
$string['inherit'] = '따름';
$string['legacy:admin'] = '정규 역할 : 관리자';
$string['legacy:coursecreator'] = '정규 역할 : 강좌 생성자';
$string['legacy:editingteacher'] = '정규 역할 : 선생님(편집가능)';
$string['legacy:guest'] = '정규 역할 : 손님';
$string['legacy:student'] = '정규 역할 : 학생';
$string['legacy:teacher'] = '정규 역할 : 선생님(편집기능 없음)';
$string['legacytype'] = '정규 역할 유형';
$string['legacy:user'] = '정규 역할 : 인증된 사용자';
$string['listallroles'] = '역할 목록';
$string['localroles'] = '영역 역할';
$string['mainadmin'] = '주 관리자';
$string['mainadminset'] = '주 관리자 설정';
$string['manageadmins'] = '사이트 관리자 관리';
$string['manager'] = '관리자';
$string['managerdescription'] = '관리자는 강좌에 접속하여 변경할 수 있지만 보통 강좌에 참여하지는 않습니다.';
$string['manageroles'] = '역할 관리';
$string['maybeassignedin'] = '이 역할을 부여받을 수 있는 문맥 유형';
$string['morethan'] = '{$a} 보다 많이';
$string['multipleroles'] = '복수 역할';
$string['my:configsyspages'] = '내 공부방 페이지를 위한 시스템 템플릿 구성';
$string['my:manageblocks'] = '내 공부방 블록 관리';
$string['neededroles'] = '권한을 가진 역할';
$string['nocapabilitiesincontext'] = '이 문맥에서는 아무 권한이 없음';
$string['noneinthisx'] = '이 {$a} 에는 아무것도 없음';
$string['noneinthisxmatching'] = '{$a->contexttype} 에 \'{$a->search}\'와 일치하는 사용자 없음';
$string['norole'] = '역할 없음';
$string['noroleassignments'] = '본 사용자는 이곳의 어느 영역에서도 부여받은 역할이 없습니다.';
$string['noroles'] = '역할 없음';
$string['notabletoassignroleshere'] = '여기에서는 어떤 역할도 부여할 수 없음';
$string['notabletooverrideroleshere'] = '여기에서는 어떤 역할의 권한도덮어쓰기할 수 없음';
$string['notes:manage'] = '알림 관리';
$string['notes:view'] = '알림 보기';
$string['notset'] = '상속';
$string['overrideanotherrole'] = '다른 역할 덮어쓰기';
$string['overridecontext'] = '문맥 덮어쓰기';
$string['overridepermissions'] = '권한 덮어쓰기';
$string['overridepermissionsforrole'] = '{$a->context} 의 \'{$a->role}\' 역할에 대한 권한 덮어쓰기';
$string['overridepermissions_help'] = '권한 덮어쓰기는 특정 문맥 영역에서  선택된 능력들이 허용되거나 방지될 수 있게 합니다.';
$string['overridepermissionsin'] = '{$a} 에서 권한 덮어쓰기';
$string['overrideroles'] = '역할 덮어쓰기';
$string['overriderolesin'] = '{$a} 에서 역할 덮어쓰기';
$string['overrides'] = '덮어쓰기';
$string['overridesbycontext'] = '덮어쓰기(문맥)';
$string['permission'] = '권한';
$string['permission_help'] = '사용권한은 능력 설정입니다. 4가지 옵션이 있습니다.

* 설정 안됨
* 허용 - 능력에 대해 사용권한이 주어짐
* 방지 - 높은 문맥에서는 허용되었다 하더라도 능력에 대한 사용권한이 제거됨
* 금지 - 사용권한이 완전히 거절됨. 낮은 (더 특수한) 문맥에 의해 덮어쓰여질 수 없다.
';
$string['permissions'] = '사용권한';
$string['permissionsforuser'] = '사용자 {$a} 의 권한';
$string['permissionsincontext'] = '{$a} 에서의 권한';
$string['portfolio:export'] = '포트폴리오로 내보내기';
$string['potentialusers'] = '{$a} 이용 후보자';
$string['potusers'] = '이용 후보자';
$string['potusersmatching'] = '\'{$a}\' 와 일치하는 이용 후보자';
$string['prevent'] = '제한';
$string['prohibit'] = '금지';
$string['prohibitedroles'] = '금지됨';
$string['question:add'] = '새 질문 추가';
$string['question:config'] = '질문 유형 설정';
$string['question:editall'] = '모든 질문 편집';
$string['question:editmine'] = '자신의 질문 편집';
$string['question:flag'] = '풀려는 질문 기표';
$string['question:managecategory'] = '질문 범주 관리';
$string['question:moveall'] = '모든 질문 이동';
$string['question:movemine'] = '자신의 질문 이동';
$string['question:useall'] = '모든 질문 사용';
$string['question:usemine'] = '자신의 질문 사용';
$string['question:viewall'] = '모든 질문 보기';
$string['question:viewmine'] = '자신의 질문 보기';
$string['rating:rate'] = '항목 추천';
$string['rating:view'] = '얻은 총점 보기';
$string['rating:viewall'] = '개인들이 부여한 점수 보기';
$string['rating:viewany'] = '추천내역 보기';
$string['resetrole'] = '역할 초기화';
$string['restore:configure'] = '복구 설정';
$string['restore:createuser'] = '복구시 사용자 생성';
$string['restore:restoreactivity'] = '활동 복구';
$string['restore:restorecourse'] = '강좌 복구';
$string['restore:restoresection'] = '영역 복구';
$string['restore:restoretargethub'] = '허브에서 파일 복구';
$string['restore:restoretargetimport'] = '목적지에서 파일 복구';
$string['restore:rolldates'] = '복원시에 활동 구성 일자를 회전 하는 것을 허용';
$string['restore:uploadfile'] = '백업 영역에서 파일 올리기';
$string['restore:userinfo'] = '사용자 정보 복구';
$string['restore:viewautomatedfilearea'] = '자동 백업으로부터 강좌 복구';
$string['risks'] = '위험부담';
$string['roleallowheader'] = '허용 역할:';
$string['roleallowinfo'] = '문맥 {$a->context}, 능력 {$a->cap} 에서 허용된 역할 목록에 추가될 역할을 선택하십시요.';
$string['role:assign'] = '사용자에게 역할 부여';
$string['roleassignments'] = '역할 부여';
$string['roledefinitions'] = '역할 정의';
$string['rolefullname'] = '이름';
$string['roleincontext'] = '{$a->context}에서 {$a->role}';
$string['role:manage'] = '역할을 생성하고 관리';
$string['role:override'] = '타인에 대한 권한 덮어쓰기';
$string['roleprohibitheader'] = '금지 역할';
$string['roleprohibitinfo'] = '문맥 {$a->context}, 능력 {$a->cap} 에서 금지된 역할 목록에 추가될 역할을 선택하십시요.';
$string['role:review'] = '다른 사람에 대한 권한 검토';
$string['rolerisks'] = '역할 위험';
$string['roles'] = '역할들';
$string['role:safeoverride'] = '타인에 대한 안전한 권한 덮어쓰기';
$string['roleselect'] = '역할 선택';
$string['rolesforuser'] = '사용자 {$a}에 대한 역할';
$string['roles_help'] = '역할은 특정 문맥에서 특정 사용자에게 부여할 수 있는 사이트 전체에 대하여 정의된 권한의 모음입니다.
';
$string['roleshortname'] = '짧은 이름';
$string['role:switchroles'] = '다른 역할과 맞바꿈';
$string['roletoassign'] = '부여할 역할';
$string['roletooverride'] = '덮어쓰기 할 역할';
$string['safeoverridenotice'] = '노트: 당신은 안전한 능력을 덮어쓰기 하도록 허용받았으므로 위험이 큰 능력은 잠겨있습니다.';
$string['selectanotheruser'] = '또 다른 사용자 선택';
$string['selectauser'] = '사용자 선택';
$string['selectrole'] = '역할 선택';
$string['showallroles'] = '모든 역할 보이기';
$string['showthisuserspermissions'] = '이 사용자의 권한 보이기';
$string['site:accessallgroups'] = '모든 모둠에 접속 기능';
$string['siteadministrators'] = '사이트 관리자';
$string['site:approvecourse'] = '강좌 만들기 승인';
$string['site:backup'] = '강좌 백업';
$string['site:config'] = '사이트 설정을 변경';
$string['site:doanything'] = '모든 일을 할 수 있도록 허용';
$string['site:doclinks'] = '외부 문서 링크를 보여줌';
$string['site:import'] = '다른 강좌를 가져옴';
$string['site:manageblocks'] = '한 페이지에서 블록 관리';
$string['site:mnetloginfromremote'] = 'MNET으로 원격 어플리케이션에서 로그인';
$string['site:mnetlogintoremote'] = 'MNET으로 원격 어플리케이션으로 로밍';
$string['site:readallmessages'] = '사이트의 모든 메세지 읽음';
$string['site:restore'] = '강좌 복구';
$string['site:sendmessage'] = '어떤 사용자에게든 메세지 보냄';
$string['site:trustcontent'] = '내용 안전성 인증';
$string['site:uploadusers'] = '파일로 새 사용자 올림';
$string['site:viewfullnames'] = '언제나 사용자의 성명을 볼 수 있음';
$string['site:viewparticipants'] = '참여자 보기';
$string['site:viewreports'] = '보고서 보기';
$string['site:viewuseridentity'] = '전체 사용자 아이덴티티를 목록으로 봄';
$string['tag:create'] = '새 태그 생성';
$string['tag:edit'] = '기존 태그 수정';
$string['tag:editblocks'] = '태그 페이지에서 블록 편집';
$string['tag:flag'] = '태그를 부적절한 것으로 표식';
$string['tag:manage'] = '태그 관리';
$string['thisusersroles'] = '당사자의 역할';
$string['unassignarole'] = '역할 {$a}을 해지';
$string['unassignconfirm'] = '정말 {$a->user} 사용자로부터 {$a->role} 역할을 해지하고자 합니까?';
$string['unassignerror'] = '{$a->user} 사용자로부터 {$a->role} 역할을  해지하는 중 오류';
$string['user:changeownpassword'] = '내 비밀번호 변경';
$string['user:create'] = '사용자 생성';
$string['user:delete'] = '사용자 삭제';
$string['user:editmessageprofile'] = '사용자 메세지 편집';
$string['user:editownmessageprofile'] = '내 메세지 편집';
$string['user:editownprofile'] = '내 개인정보 편집';
$string['user:editprofile'] = '사용자 개인정보 편집';
$string['user:ignoreuserquota'] = '사용자 할당 한계 무시';
$string['user:loginas'] = '다른 사용자로 로그인';
$string['user:manageblocks'] = '타 사용자의 개인정보 블록을 관리';
$string['user:manageownblocks'] = '자신의 개인정보 블록을 관리';
$string['user:manageownfiles'] = '개인 파일 관리';
$string['user:managesyspages'] = '공용 사용자 개인정보 페이지 레이아웃 설정';
$string['user:readuserblogs'] = '사용자 블로그 보기';
$string['user:readuserposts'] = '모든 게시물 보기';
$string['usersfrom'] = '{$a} 사용자들';
$string['usersfrommatching'] = '{$a->contextname} 중 \'{$a->search}\' 와 일치하는 사용자';
$string['usersinthisx'] = '{$a} 사용자들';
$string['usersinthisxmatching'] = '{$a->contexttype} 에서 \'{$a->search}\' 와 일치하는 사용자';
$string['userswithrole'] = '역할을 지닌 모든 사용자';
$string['userswiththisrole'] = '본 역할을 소지한 사용자들';
$string['user:update'] = '사용자 개인정보 새로고침';
$string['user:viewalldetails'] = '사용자의 전체 정보 보기';
$string['user:viewdetails'] = '사용자 개인정보를 봄';
$string['user:viewhiddendetails'] = '사용자의 비공개 세부사항 보기';
$string['user:viewuseractivitiesreport'] = '활동 보고서 보기';
$string['user:viewusergrades'] = '사용자 성적 보기';
$string['useshowadvancedtochange'] = '변경하려면 \'고급 보기\'를 사용';
$string['viewingdefinitionofrolex'] = '\'{$a}\' 역할 정의 보기';
$string['viewrole'] = '역할 자세히 보기';
$string['webservice:createmobiletoken'] = '모바일 접속을 위한 웹서비스 토큰 생성';
$string['webservice:createtoken'] = '웹서비스 토큰 생성';
$string['whydoesuserhavecap'] = '왜 {$a->fullname} 가 {$a->context} 문맥에서{$a->capability} 능력을 갖습니까?';
$string['whydoesusernothavecap'] = '왜 {$a->fullname} 가 {$a->context} 문맥에서{$a->capability} 능력을 갖지 못합니까?';
$string['xroleassignments'] = '{$a} 의 역할';
$string['xuserswiththerole'] = '"{$a->role}" 역할을 지닌 사용자';
