<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'ko', branch 'MOODLE_26_STABLE'
 *
 * @package   glossary
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = '덧글 쓰기';
$string['addentry'] = '새 항목 쓰기';
$string['addingcomment'] = '덧글 쓰기';
$string['alias'] = '검색어';
$string['aliases'] = '검색어';
$string['aliases_help'] = '용어집 항목들은 연관된 키워드(별칭)목록을 가질 수 있습니다. 항목이 자동 링크되면 키워드도 자동 링크 될 것입니다.

한 줄에 한개의 키워드를 입력하세요. (콤마로 구분되지 않습니다) ';
$string['allcategories'] = '모든 범주';
$string['allentries'] = '전체보기';
$string['allowcomments'] = '덧글 허용';
$string['allowcomments_help'] = '활성화되면 댓글을 쓸 권한이 있는 모든 사용자는 용어집 항목에 댓글을 추가할 수 있습니다.';
$string['allowduplicatedentries'] = '중복입력 허용';
$string['allowduplicatedentries_help'] = '<p>이 옵션을 "예"로 놓으면, 동일한 개념명칭에 대해 복수 입력을 할 수 있게 된다.</p>';
$string['allowprintview'] = '인쇄 보기 허용';
$string['allowprintview_help'] = '활성화되면 학생들에게 용어집의 인쇄용 버전에 대한 링크가 제공됩니다. 선생님은
링크를 항상 사용할 수 있습니다.';
$string['andmorenewentries'] = '추가 {$a} 항목들';
$string['answer'] = '대답';
$string['approvaldisplayformat'] = '승인 표시 포맷';
$string['approvaldisplayformat_help'] = '용어집 항목을 승인할 때 다른 표시 형식을 사용하기를 원할 수도 있습니다.';
$string['approve'] = '승인';
$string['areaattachment'] = '첨부물';
$string['areaentry'] = '정의';
$string['areyousuredelete'] = '이 항목을 지울까요?';
$string['areyousuredeletecomment'] = '이 덧글을 지울까요?';
$string['areyousureexport'] = '이 항목을 다음으로 내보낼까요?';
$string['ascending'] = '오름차순으로';
$string['attachment'] = '붙임파일';
$string['attachment_help'] = '용어집 항목에 선택적으로 한 개 이상의 파일을 첨부할 수 있습니다.
 ';
$string['author'] = '작성자';
$string['authorview'] = '집필자순으로 보기';
$string['back'] = '뒤로';
$string['cantinsertcat'] = '범주를 추가할 수 없음';
$string['cantinsertrec'] = '자료를 추가할 수 없음';
$string['cantinsertrel'] = '범주 항목의 관계를 설정할 수 없음';
$string['casesensitive'] = '대,소문자 구분';
$string['casesensitive_help'] = '<p>이 기능은 (영문의) 대소 문자가 정확히 일치 하는지를 비교하여 자동으로 연결할 수 있도록 설정하는 것입니다.</p>

<p>예를 들어 이 기능을 켜놓으면 "html"처럼 영문 소문자로 작성된 문서는 자료집에 "HTML" 또는 "Html" 등으로 등록된 목록에 연결되지 않습니다.</p>';
$string['cat'] = '범주';
$string['categories'] = '범주';
$string['category'] = '범주';
$string['categorydeleted'] = '범주 삭제';
$string['categoryview'] = '범주별로 보기';
$string['changeto'] = '{$a} 로 변경';
$string['cnfallowcomments'] = '용어집 항목에 댓글 달기 허용을 기본으로 할 것인지 정의합니다.';
$string['cnfallowdupentries'] = '용어집에 중복 항목 허용을 기본으로 할 것인지 정의합니다.';
$string['cnfapprovalstatus'] = '올린 항목 승인을 초기값으로 할 것인지 설정';
$string['cnfcasesensitive'] = '링크된 항목에 대한 대,소문자 구분을 초기값으로 할 것인지 설정';
$string['cnfdefaulthook'] = '용어집 초기화면의  기본 선택을 선택하십시요';
$string['cnfdefaultmode'] = '용어집 초기화면의 기본 프레임을 선택하십시요';
$string['cnffullmatch'] = '링크된 항목에 대한 대소문자 일치를 초기값으로 할 것인지 설정';
$string['cnflinkentry'] = '항목의 자동링크를 초기값으로 할 것인지 설정';
$string['cnflinkglossaries'] = '용어집의 자동 링크를 기본으로 할 것인지 정의합니다.';
$string['cnfrelatedview'] = '자동 링크와 항목 보기에 사용되는 디스플레이 형식을 선택하십시요';
$string['cnfshowgroup'] = '모둠 구분 공개 여부 지정';
$string['cnfsortkey'] = '초기 정렬 키 선택';
$string['cnfsortorder'] = '기본 정렬 순서 선택';
$string['cnfstudentcanpost'] = '학생 게시 허용 여부 초기값 선택';
$string['comment'] = '덧글';
$string['commentdeleted'] = '덧글이 삭제되었습니다.';
$string['comments'] = '덧글';
$string['commentson'] = '덧글';
$string['commentupdated'] = '덧글이 업데이트되었습니다.';
$string['completionentries'] = '학생들은 항목들을 만들어야 합니다.';
$string['completionentriesgroup'] = '항목들이 필요합니다.';
$string['concept'] = '개념';
$string['concepts'] = '개념';
$string['configenablerssfeeds'] = '이 스위치는 모든 용어집에 대해 RSS로 송신할 수 있게 합니다. 하지만 각 용어집에 대해서는 여전히 수동으로 개별적인 내보냄 설정을 해 주어야만 합니다.';
$string['current'] = '현재 정렬된 {$a}';
$string['currentglossary'] = '현재 용어집';
$string['date'] = '날자';
$string['dateview'] = '날짜순으로 보기';
$string['defaultapproval'] = '승인';
$string['defaultapproval_help'] = '<p>이 옵션은 기본적으로 학생들이 새로운 항목을 추가할 수 있도록 허용합니다. 추가한 항목들은 모든 사람들이 사용할 수 있게되며, 이 옵션을 선택하지 않으면 선생님은 학생 개개인에게 승인을 해 주어야 합니다.</p>';
$string['defaulthook'] = '기본 고리';
$string['defaultmode'] = '기본 모드';
$string['defaultsortkey'] = '기본 정렬 키';
$string['defaultsortorder'] = '기본 정렬 순서';
$string['definition'] = '정의';
$string['definitions'] = '정의';
$string['deleteentry'] = '항목 삭제';
$string['deletenotenrolled'] = '등록되지 않은 사용자들에 의한 입력항목 삭제';
$string['deletingcomment'] = '덧글 삭제';
$string['deletingnoneemptycategory'] = '이 범주를 삭제해도 범주내의 글들은 삭제되지 않습니다. 그 글들은 범주 없음으로 표시될 것입니다.';
$string['descending'] = '내림차순으로';
$string['destination'] = '가져온 항목들의 목적지';
$string['destination_help'] = '항목들은 현재의 용어집 혹은 새 용어집으로 가져오기 하거나 추가될 수 있습니다. 후자의 경우 XML파일의 정보를 기반으로 새로운 용어집이 만들어 질 것입니다.';
$string['disapprove'] = '승인 취소';
$string['displayformat'] = '출력 양식';
$string['displayformatcontinuous'] = '저자없이 이어보기';
$string['displayformatdefault'] = '표시 포맷으로 같은 것을 기본으로';
$string['displayformatdictionary'] = '단순 사전 형태';
$string['displayformatencyclopedia'] = '백과사전 형태';
$string['displayformatentrylist'] = '입력목록만 나열';
$string['displayformatfaq'] = '질의응답 형태';
$string['displayformatfullwithauthor'] = '본인 것만 전부';
$string['displayformatfullwithoutauthor'] = '남의 것만 전부';
$string['displayformat_help'] = '7 가지 표시 형식이 있습니다.

* 간단한 사전 스타일 - 저자는 표시되지 않고 첨부는 링크로 표시됩니다.
* 저자 없이 이어보기 - 항목들이 연속적으로 표시되며 항목간 편집 아이콘으로 구분됩니다.
* 저자 포함 전체 - 저자의 자료와 링크로 표시된 첨부를 보여주는 포럼스타일 표시 형식
* 저자 없이 전체 - 저자없이 링크로 표시된 첨부를 보여주는 포럼스타일 표시 형식

* 백과사전 - 저자포함 전체와 같으나 첨부된 그림이 인라인으로 보여집니다.

* 항목 목록 - 링크로 된 개념 목록

* 빈번한 질문 - 질문과 답변이라는 단어가 개념과 정의에 각각 추가됩니다.';
$string['displayformats'] = '출력 양식';
$string['displayformatssetup'] = '표시 형식 설정';
$string['duplicatecategory'] = '범주 복제';
$string['duplicateentry'] = '항목 복사';
$string['editalways'] = '언제나 수정가능';
$string['editalways_help'] = '<p>이 옵션은 학생들이 언제 교정을 하게 할 것인지를 정하는 것이다.</p>

<p>다음 중에서 선택할 수 있다:</p>

<ul>
<li><b>예:</b> 언제나 입력내용을 고칠 수 있게 허용함</li>

<li><b>아니오:</b> 미리 지정한 시간에만 고칠 수 있게 함</li>
</ul>';
$string['editcategories'] = '범주 편집';
$string['editentry'] = '항목 편집';
$string['editingcomment'] = '덧글 편집';
$string['entbypage'] = '페이지당 항목 수';
$string['entries'] = '항목들';
$string['entrieswithoutcategory'] = '범주 없는 항목';
$string['entry'] = '항목';
$string['entryalreadyexist'] = '이미 존재하는 항목';
$string['entryapproved'] = '항목 승인됨';
$string['entrydeleted'] = '항목 삭제';
$string['entryexported'] = '항목 내보내기 성공함';
$string['entryishidden'] = '(이 항목은 볼 수 없음)';
$string['entryleveldefaultsettings'] = '항목 수준 초기설정';
$string['entrysaved'] = '이미 저장되어있음';
$string['entryupdated'] = '이 항목은 업데이트 되었습니다.';
$string['entryusedynalink'] = '이 항목은 자동적으로 링크됨';
$string['entryusedynalink_help'] = '관리자에 의해 전역 용어집 자동 링크 기능이 활성화되고, 이 체크박스가 체크되면 강좌내에서 개념어나 구문이 나타나면 항목이 자동으로 링크되게 됩니다.';
$string['errcannoteditothers'] = '다른 사람의 항목은 편집할 수 없습니다.';
$string['errconceptalreadyexists'] = '이미 있는 내용입니다. 이 용어집에서는 중복입력을 허용하지 않습니다.';
$string['errdeltimeexpired'] = '이것을 삭제할 수 없습니다. 시간이 지났습니다!';
$string['erredittimeexpired'] = '이 항목에 대한 편집 시간이 종료되었습니다.';
$string['errorparsingxml'] = '파일을 해석하는 중에 오류가 발생하였습니다. 유효한 XML 문법인지 확인하세요.';
$string['explainaddentry'] = '현재의 용어집에 새 항목을 추가합니다.';
$string['explainall'] = '한  페이지에 모든 항목 보기';
$string['explainalphabet'] = '색인을 사용하여 용어집 보기';
$string['explainexport'] = '용어집 항목을 내보내려면 아래 버튼을 클릭하세요.<br />이 강좌 혹은 다른 강좌에서 언제든지 가져오기할 수 있습니다.<p>첨부물(예: 이미지)과 저자명 등은 내보내지 않음에 유의하세요.</p>';
$string['explainimport'] = '가져오기 할 파일을 구체적으로 적고, 과정의 기준을 명시해야 합니다.<p>요청을 제출하고 결과를 검토하세요';
$string['explainspecial'] = '문자로 시작하지 않는 항목 보기';
$string['exportedentry'] = '내보낸 항목';
$string['exportentries'] = '항목 내보내기';
$string['exportentriestoxml'] = '항목을  XML파일로 내보내기';
$string['exportfile'] = '항목을 파일로 내보내기';
$string['exportglossary'] = '용어집 내보내기';
$string['exporttomainglossary'] = '주 용어집으로 내보내기';
$string['filetoimport'] = '가져올 파일';
$string['filetoimport_help'] = '<p>내 컴퓨터 안의 가져오고자 하는 자료 항목이 들어있는 XML 파일을 선택합니다.</p>';
$string['fillfields'] = '필수적으로 채워넣어야 하는 항목';
$string['filtername'] = '용어집 자동 링크';
$string['fullmatch'] = '완전히 일치하는 단어만';
$string['fullmatch_help'] = '이 설정은 완전한 단어만 링크될지를 명시합니다. 예를 들어 용어집 항목 "construct"는 "constructivism"단어안에 링크를 만들지 않을 것입니다.';
$string['glossary:addinstance'] = '새 용어집 추가';
$string['glossary:approve'] = '승인받지 못했던 내용 승인';
$string['glossary:comment'] = '덧글 생성';
$string['glossary:export'] = '입력내용 내보내기';
$string['glossary:exportentry'] = '한 항목 내보내기';
$string['glossary:exportownentry'] = '내 입력 내보내기';
$string['glossary:import'] = '입력내용 가져오기';
$string['glossaryleveldefaultsettings'] = '용어집 레벨 기본 설정';
$string['glossary:managecategories'] = '범주 관리';
$string['glossary:managecomments'] = '덧글 관리';
$string['glossary:manageentries'] = '입력내용 관리';
$string['glossary:rate'] = '입력내용 등수 매기기';
$string['glossarytype'] = '용어집 유형';
$string['glossarytype_help'] = '주 용어집은 보조 용어집의 항목들을 가져올 할 수 있는 용어집입니다. 강좌에 오직 한개의 주 용어집이 있을 수 있습니다. 용어집 항목 가져오기가 필요하지 않으면 강좌내의 모든 용어집은 보조 용어집입니다.';
$string['glossary:view'] = '용어집 보기';
$string['glossary:viewallratings'] = '원점수 보기';
$string['glossary:viewanyrating'] = '총 득점 보기';
$string['glossary:viewrating'] = '받은 전체 등급 보기';
$string['glossary:write'] = '새로 입력';
$string['guestnoedit'] = '손님은 용어집 수정 권한이 없음';
$string['importcategories'] = '범주 가져오기';
$string['importedcategories'] = '가져온 범주';
$string['importedentries'] = '가져온 항목';
$string['importentries'] = '항목 가져오기';
$string['importentriesfromxml'] = 'XML파일에서 내용 가져옴';
$string['includegroupbreaks'] = '모둠 해체 포함';
$string['isglobal'] = '이 용어집이 전역 용어집입니까?';
$string['isglobal_help'] = '전역 용어집은 용어집이 있는 강좌뿐만 아니라 사이트 전체에서 링크된 입력항목을 가지고 있습니다. 오직 관리자만이 용어집을 전역로 설정할 수 있습니다.';
$string['letter'] = '문자';
$string['linkcategory'] = '이 범주로 자동 링크됨';
$string['linkcategory_help'] = '용어집 자동 연결이 활성화되고 이 설정이 활성화되면 범주 이름이 강좌에서 나타날때마다 자동으로 링크될 것입니다. 참여자가 범주 이름 링크를 따라가면 용어집을 "범주별로 보기" 페이지에 가게 될 것입니다.';
$string['linking'] = '자동 연결';
$string['mainglossary'] = '주 용어집';
$string['maxtimehaspassed'] = '죄송합니다만, 수정할 수 있는 횟수({$a})를 초과하였습니다!';
$string['modulename'] = '용어집';
$string['modulename_help'] = '용어집 모듈은 참여자들이 사전과 같은 정의 목록을 만들고 관리하는 것을 가능하게 해 줍니다. 용어집의 항목은 강좌 전반에 거쳐 그 단어나 문구와 관련된 내용이 노출될 때 자동적으로 연결될 수도 있습니다.';
$string['modulenameplural'] = '용어활용';
$string['newentries'] = '새 자료 항목';
$string['newglossary'] = '새 용어집';
$string['newglossarycreated'] = '용어집이 생성됨';
$string['newglossaryentries'] = '새 용어집 입력항목들:';
$string['nocomment'] = '덧글 없음';
$string['nocomments'] = '(이 항목에 대한 덧글없음)';
$string['noconceptfound'] = '정의되지 않음';
$string['noentries'] = '이 영역에는 찾는 항목이 없음';
$string['noentry'] = '항목 없음';
$string['nopermissiontodelcomment'] = '타인의 덧글을 삭제할 수 없음!';
$string['nopermissiontodelinglossary'] = '본 용어집에 덧글을 쓸 수 없습니다!';
$string['nopermissiontoviewresult'] = '자신의 입력 내용만 살펴볼 수 있음';
$string['notapproved'] = '용어집 항목이 아직 승인되지 않았습니다.';
$string['notcategorised'] = '분류되지 않았음';
$string['numberofentries'] = '항목의 수';
$string['onebyline'] = '(한 줄에 하나)';
$string['page-mod-glossary-edit'] = '용어집 항목 추가/편집 페이지';
$string['page-mod-glossary-view'] = '용어집 편집 페이지 보기';
$string['page-mod-glossary-x'] = '모든 용어집 모듈 페이지';
$string['pluginadministration'] = '용어집 관리';
$string['pluginname'] = '용어집';
$string['popupformat'] = '팝업 포맷';
$string['print'] = '인쇄';
$string['printerfriendly'] = '인쇄용 버전';
$string['printviewnotallowed'] = '출력미리보기가 허용되지않음';
$string['question'] = '질문';
$string['rejectedentries'] = '반송된 항목';
$string['rejectionrpt'] = '거절 보고서';
$string['resetglossaries'] = '다음으로부터 입력항목 삭제';
$string['resetglossariesall'] = '모든 용어집에서 입력항목 삭제';
$string['rssarticles'] = '최신 RSS 기사 수';
$string['rssarticles_help'] = '이 설정은 RSS Feed에 포함될 용어집 항목 수를 명시합니다. 5-20 사이가 적당합니다';
$string['rsssubscriberss'] = '\'{$a}\'개념에 대한 RSS 전송사항 표시';
$string['rsstype'] = '이 활동에 대한 RSS 피드';
$string['rsstype_help'] = '<p>용어집을 RSS로 내보낼 수 있도록 허용하는 기능이다.</p>

<p>선택할 수 있는 자료 전송 유형에는 다음과 같은 두 방법있다:</p>

<ul>
<li><b>저자 목록과 함께:</b> 모든 문서에 저자의 이름을 붙여서 함께 전송한다.</li>

<li><b>저자 목록 없이:</b> 모든 전송된 문서에는 저자의 이름이 생략된다.</li>
</ul>';
$string['searchindefinition'] = '본문에서 검색';
$string['secondaryglossary'] = '보조 용어집';
$string['showall'] = '\'모든\'링크 보기';
$string['showall_help'] = '<p>사용자가 용어집을 이용하는 것을 조정할 수 있습니다. 용어집을 열고 검색하는 것은 항상 가능하지만 다음의 세 옵션을 더 지정해 줄 수 있습니다.</p>

<p><b>특수문자 보기</b> @ 나 # 같은 특수 문자를 볼 수 있게 하거나 볼 수 없게 하기</p>

<p><b>철자순 보기</b> 철자순으로 볼 수 있게 하거나 볼 수 없게 하기</p>

<p><b>모두 보기</b> 한꺼번에 모든 내용을 볼 수 있게 하거나 볼 수 없게 하기</p>';
$string['showalphabet'] = '철자순으로 보기';
$string['showalphabet_help'] = '활성화되면 참여자들은 알파벳별로 용어집을 살펴 볼 수 있습니다. ';
$string['showspecial'] = '\'특집\' 링크 보기';
$string['showspecial_help'] = '활성화되면 참여자들은 @ 나 # 같은 특수 문자별로 용어집을 살펴 볼 수 있습니다. ';
$string['sortby'] = '정렬 방법';
$string['sortbycreation'] = '생성일 순으로';
$string['sortbylastupdate'] = '마지막 수정 순으로';
$string['sortchronogically'] = '연대표 순으로 정렬';
$string['special'] = '특집';
$string['standardview'] = '철자순으로 보기';
$string['studentcanpost'] = '학생들이 항목을 추가할 수 있음';
$string['totalentries'] = '전체 항목';
$string['usedynalink'] = '용어집 입력항목으로 자동 링크';
$string['usedynalink_help'] = '만일 관리자에 의해 전역 용어집 자동 링크가 활성화되고 이 설정이 활성화되면, "새 입력항목 추가" 양식에 강좌에서 개념 단어와 구문이 나타날 때마다 자동으로 항목을 링크 걸 수 있는 옵션이 포함됩니다.';
$string['waitingapproval'] = '승인  대기중';
$string['warningstudentcapost'] = '(용어집이 주 자료집이 아닐때만 적용됩니다)';
$string['withauthor'] = '저자명과 함께';
$string['withoutauthor'] = '저자 생략';
$string['writtenby'] = '올린이:';
$string['youarenottheauthor'] = '글 쓴 사람만 내용을 고칠 수 있습니다.';
