<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'ko', branch 'MOODLE_26_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = '주소';
$string['advanced:anchor_desc'] = '엥커 삽입/편집';
$string['advanced:backcolor_desc'] = '배경색';
$string['advanced:block'] = '포맷';
$string['advanced:blockquote'] = '인용문';
$string['advanced:blockquote_desc'] = '인용문';
$string['advanced:bold_desc'] = '굵은 글씨(Ctrl+B)';
$string['advanced:bullist_desc'] = '비순차목록';
$string['advanced:charmap_desc'] = '특수 문자';
$string['advanced:cleanup_desc'] = '지저분한 코드 삭제';
$string['advanced:clipboard_msg'] = '복사/잘라내기/붙이기는 Mozilla 및Firefox 에서 사용되지 않습니다.n상세정보를 표시합니까?';
$string['advanced:code'] = '코드';
$string['advanced:code_desc'] = 'HTML 편집';
$string['advanced:copy_desc'] = '복사';
$string['advanced:custom1_desc'] = '커스텀 설명';
$string['advanced:cut_desc'] = '잘라내기';
$string['advanced:dd'] = '정의 설명';
$string['advanced:div'] = 'Div';
$string['advanced_dlg:about_author'] = '제작자';
$string['advanced_dlg:about_general'] = 'About';
$string['advanced_dlg:about_help'] = '도움말';
$string['advanced_dlg:about_license'] = '사용허가';
$string['advanced_dlg:about_loaded'] = '실행된 플러그인';
$string['advanced_dlg:about_plugin'] = '플러그인';
$string['advanced_dlg:about_plugins'] = '플러그인';
$string['advanced_dlg:about_title'] = 'TinyMCE에 대하여';
$string['advanced_dlg:about_version'] = '버젼';
$string['advanced_dlg:accessibility_help'] = '접근성 도움말';
$string['advanced_dlg:accessibility_usage_title'] = '일반적인 사용법';
$string['advanced_dlg:anchor_invalid'] = '유효한 앵커 이름을 지정하십시오.';
$string['advanced_dlg:anchor_name'] = '엥커명';
$string['advanced_dlg:anchor_title'] = '엥커 삽입/편집';
$string['advanced_dlg:charmap_title'] = '특수 문자';
$string['advanced_dlg:charmap_usage'] = '찾아가기 위해 왼쪽 및 오른쪽 화살표를 사용하세요.';
$string['advanced_dlg:code_title'] = '소스 편집';
$string['advanced_dlg:code_wordwrap'] = '워드랩';
$string['advanced_dlg:colorpicker_color'] = 'Color:';
$string['advanced_dlg:colorpicker_name'] = '색 이름:';
$string['advanced_dlg:colorpicker_named_tab'] = '색 이름';
$string['advanced_dlg:colorpicker_named_title'] = '색';
$string['advanced_dlg:colorpicker_palette_tab'] = '팔레트';
$string['advanced_dlg:colorpicker_palette_title'] = '팔레트 색';
$string['advanced_dlg:colorpicker_picker_tab'] = '픽커';
$string['advanced_dlg:colorpicker_picker_title'] = '컬러 픽커';
$string['advanced_dlg:colorpicker_title'] = '색을 선택';
$string['advanced_dlg:image_align'] = '정렬';
$string['advanced_dlg:image_align_baseline'] = '기준선';
$string['advanced_dlg:image_align_bottom'] = 'Bottom';
$string['advanced_dlg:image_align_left'] = 'Left';
$string['advanced_dlg:image_align_middle'] = 'Middle';
$string['advanced_dlg:image_align_right'] = 'Right';
$string['advanced_dlg:image_align_textbottom'] = 'Text bottom';
$string['advanced_dlg:image_align_texttop'] = 'Text top';
$string['advanced_dlg:image_align_top'] = 'Top';
$string['advanced_dlg:image_alt'] = '이미지 설명';
$string['advanced_dlg:image_border'] = '테두리선';
$string['advanced_dlg:image_dimensions'] = '크기';
$string['advanced_dlg:image_hspace'] = '좌우 여백';
$string['advanced_dlg:image_list'] = '이미지 목록';
$string['advanced_dlg:image_src'] = '이미지 URL';
$string['advanced_dlg:image_title'] = '이미지의 삽입/편집';
$string['advanced_dlg:image_vspace'] = '상하 여백';
$string['advanced_dlg:invalid_color_value'] = '못된 색상 값';
$string['advanced_dlg:link_is_email'] = '메일주소가 입력되었습니다.n메일주소의 앞에 mailto:를 붙입니까?';
$string['advanced_dlg:link_is_external'] = '외부URL이 입력되었습니다.nURL의 앞에 http://를 붙입니까?';
$string['advanced_dlg:link_list'] = '링크 목록';
$string['advanced_dlg:link_target'] = 'Target';
$string['advanced_dlg:link_target_blank'] = '새창';
$string['advanced_dlg:link_target_same'] = '같은창';
$string['advanced_dlg:link_title'] = '링크의 삽입/편집';
$string['advanced_dlg:link_titlefield'] = '제목';
$string['advanced_dlg:link_url'] = '링크 URL';
$string['advanced:dt'] = '어구 정의';
$string['advanced:fontdefault'] = '글꼴';
$string['advanced:font_size'] = '글꼴 크기';
$string['advanced:forecolor_desc'] = '글자색';
$string['advanced:h1'] = '표제1';
$string['advanced:h2'] = '표제2';
$string['advanced:h3'] = '표제3';
$string['advanced:h4'] = '표제4';
$string['advanced:h5'] = '표제5';
$string['advanced:h6'] = '표제6';
$string['advanced:help_desc'] = '도움말';
$string['advanced:help_shortcut'] = '도구 모음은 ALT-F10.  도움말은 ALT-0 를 클릭하세요';
$string['advanced:hr_desc'] = '구분선';
$string['advanced:image_desc'] = '이미지 삽입/편집';
$string['advanced:image_props_desc'] = '이미지속성';
$string['advanced:indent_desc'] = '들여쓰기';
$string['advanced:italic_desc'] = '이탤릭(Ctrl+I)';
$string['advanced:justifycenter_desc'] = '가운데 정렬';
$string['advanced:justifyfull_desc'] = '배분 정렬';
$string['advanced:justifyleft_desc'] = '왼쪽 정렬';
$string['advanced:justifyright_desc'] = '오른쪽 정렬';
$string['advanced:link_desc'] = '링크의 삽입/편집';
$string['advanced:more_colors'] = '그 외의 색';
$string['advanced:newdocument'] = '편집중의 데이터를 모두 잃어도 괜찮습니까?';
$string['advanced:newdocument_desc'] = '신규글 작성';
$string['advanced:numlist_desc'] = '순차목록';
$string['advanced:outdent_desc'] = '내어쓰기';
$string['advanced:paragraph'] = '단락';
$string['advanced:paste_desc'] = '붙이기';
$string['advanced:path'] = 'Path';
$string['advanced:pre'] = 'pre';
$string['advanced:redo_desc'] = '다시실행(Ctrl+Y)';
$string['advanced:removeformat_desc'] = '서식 해제';
$string['advanced:rich_text_area'] = '리치 텍스트 영역';
$string['advanced:samp'] = '샘플코드';
$string['advanced:shortcuts_desc'] = '접근성 도움말';
$string['advanced:striketrough_desc'] = '취소선';
$string['advanced:style_select'] = '스타일';
$string['advanced:sub_desc'] = '아래첨자';
$string['advanced:sup_desc'] = '위첨자';
$string['advanced:toolbar'] = '도구바';
$string['advanced:toolbar_focus'] = '버튼으로 점프 - Alt+Q, 에디터로 점프 - Alt-Z, Jump to element path - Alt-X';
$string['advanced:underline_desc'] = '밑줄(Ctrl+U)';
$string['advanced:undo_desc'] = '실행취소(Ctrl+Z)';
$string['advanced:unlink_desc'] = '링크 삭제';
$string['advanced:visualaid_desc'] = '가이드라인 표시/비표시';
$string['advhr:advhr_desc'] = '구분선';
$string['advhr_dlg:normal'] = '정상';
$string['advhr_dlg:noshade'] = '그림자없음';
$string['advhr_dlg:size'] = '높이';
$string['advhr_dlg:width'] = '폭';
$string['advhr_dlg:widthunits'] = '단위';
$string['advimage_dlg:align'] = '정렬';
$string['advimage_dlg:align_baseline'] = '기준선';
$string['advimage_dlg:align_bottom'] = '하';
$string['advimage_dlg:align_left'] = '좌';
$string['advimage_dlg:align_middle'] = '중앙';
$string['advimage_dlg:align_right'] = '우';
$string['advimage_dlg:align_textbottom'] = '문자열 아래로';
$string['advimage_dlg:align_texttop'] = '문자열 위로';
$string['advimage_dlg:align_top'] = '상';
$string['advimage_dlg:alt'] = '이미지 설명';
$string['advimage_dlg:alt_image'] = '대체 이미지';
$string['advimage_dlg:border'] = '테두리선';
$string['advimage_dlg:classes'] = '클래스';
$string['advimage_dlg:constrain_proportions'] = '종횡비 보존';
$string['advimage_dlg:dialog_title'] = '이미지의 삽입/편집';
$string['advimage_dlg:dimensions'] = '크기';
$string['advimage_dlg:example_img'] = '미리보기 이미지';
$string['advimage_dlg:general'] = '일반';
$string['advimage_dlg:height'] = '높이';
$string['advimage_dlg:hspace'] = '좌우 여백';
$string['advimage_dlg:id'] = 'Id';
$string['advimage_dlg:image_list'] = '이미지 목록';
$string['advimage_dlg:langcode'] = '언어 코드';
$string['advimage_dlg:langdir'] = '문자 방향';
$string['advimage_dlg:list'] = '이미지 목록';
$string['advimage_dlg:long_desc'] = '설명 링크';
$string['advimage_dlg:ltr'] = '왼쪽에서 오른쪽';
$string['advimage_dlg:map'] = '이미지 맵';
$string['advimage_dlg:misc'] = '그 외';
$string['advimage_dlg:missing_alt'] = '이미지 설명이 없습니다만 좋습니까? 이미지 설명이 없는 경우, 맹인이나 텍스트 브라우저를 이용하고 있는 분, 또 이미지 표시를 OFF(으)로 하고 있는 유저의 접근성이 저하됩니다.';
$string['advimage_dlg:mouseout'] = '마우스 아웃 이미지';
$string['advimage_dlg:mouseover'] = '마우스 오버 이미지';
$string['advimage_dlg:preview'] = '미리보기';
$string['advimage_dlg:rtl'] = '오른쪽에서 왼쪽';
$string['advimage_dlg:src'] = '이미지 URL';
$string['advimage_dlg:style'] = '스타일';
$string['advimage_dlg:swap_image'] = '롤 오버 효과';
$string['advimage_dlg:tab_advanced'] = '고급';
$string['advimage_dlg:tab_appearance'] = '표시';
$string['advimage_dlg:tab_general'] = '일반';
$string['advimage_dlg:title'] = '제목';
$string['advimage_dlg:vspace'] = '상하 여백';
$string['advimage_dlg:width'] = '폭';
$string['advimage:image_desc'] = '이미지의 삽입/편집';
$string['advlink_dlg:accesskey'] = '액세스 키';
$string['advlink_dlg:advanced_props'] = '고급의 설정';
$string['advlink_dlg:advanced_tab'] = '고급';
$string['advlink_dlg:anchor_names'] = '엥커';
$string['advlink_dlg:classes'] = '클래스';
$string['advlink_dlg:encoding'] = '문자 인코딩';
$string['advlink_dlg:event_props'] = '이벤트';
$string['advlink_dlg:events_tab'] = '이벤트';
$string['advlink_dlg:general_props'] = '일반 설정';
$string['advlink_dlg:general_tab'] = '일반';
$string['advlink_dlg:height'] = '높이';
$string['advlink_dlg:id'] = 'Id';
$string['advlink_dlg:is_email'] = '메일주소가 입력되었습니다. 메일주소의 앞에 mailto:를 붙입니까?';
$string['advlink_dlg:is_external'] = '외부URL이 입력되었습니다.URL의 앞에http://를 붙입니까?';
$string['advlink_dlg:langcode'] = '언어 코드';
$string['advlink_dlg:langdir'] = '페이지 문자 방향';
$string['advlink_dlg:link_list'] = '링크 목록';
$string['advlink_dlg:list'] = '링크 목록';
$string['advlink_dlg:ltr'] = '왼쪽에서 오른쪽';
$string['advlink_dlg:mime'] = 'MIME타입';
$string['advlink_dlg:popup'] = 'Javascript 팝업';
$string['advlink_dlg:popup_dependent'] = '연동 (Mozilla/Firefox만)';
$string['advlink_dlg:popup_location'] = '주소바를 표시';
$string['advlink_dlg:popup_menubar'] = '메뉴를 표시';
$string['advlink_dlg:popup_name'] = 'Window 이름';
$string['advlink_dlg:popup_opts'] = '옵션';
$string['advlink_dlg:popup_position'] = '위치(X/Y)';
$string['advlink_dlg:popup_props'] = '팝업 설정';
$string['advlink_dlg:popup_resizable'] = '크기변경 가능';
$string['advlink_dlg:popup_return'] = '\'return false\'를 삽입';
$string['advlink_dlg:popup_scrollbars'] = '스크롤바를 표시';
$string['advlink_dlg:popup_size'] = '크기';
$string['advlink_dlg:popup_statusbar'] = '상태줄을 표시';
$string['advlink_dlg:popup_tab'] = '팝업';
$string['advlink_dlg:popup_toolbar'] = '툴바를 표시';
$string['advlink_dlg:popup_url'] = '팝업 URL';
$string['advlink_dlg:rel'] = '링크에 관계';
$string['advlink_dlg:rev'] = '링크로부터의 관계';
$string['advlink_dlg:rtl'] = '오른쪽에서 왼쪽';
$string['advlink_dlg:style'] = '스타일';
$string['advlink_dlg:tabindex'] = '탭 인덱스';
$string['advlink_dlg:target'] = 'Target';
$string['advlink_dlg:target_blank'] = '새창으로 열린다';
$string['advlink_dlg:target_langcode'] = '페이지 언어';
$string['advlink_dlg:target_name'] = 'Target 이름';
$string['advlink_dlg:target_parent'] = '부모창/프레임으로 열린다';
$string['advlink_dlg:target_same'] = '이 창/프레임으로 열린다';
$string['advlink_dlg:target_top'] = '최상위 프레임으로 열린다 (모든 프레임 변경)';
$string['advlink_dlg:title'] = '링크의 삽입/편집';
$string['advlink_dlg:titlefield'] = '제목';
$string['advlink_dlg:url'] = '링크 URL';
$string['advlink_dlg:width'] = '폭';
$string['advlink:link_desc'] = '링크의 삽입/편집';
$string['advlist:circle'] = '원';
$string['advlist:def'] = '기본';
$string['advlist:disc'] = '설명';
$string['advlist:lower_alpha'] = '소문자';
$string['advlist:lower_greek'] = '그리스 소문자';
$string['advlist:lower_roman'] = '로마 소문자';
$string['advlist:square'] = '사각';
$string['advlist:types'] = '타입';
$string['advlist:upper_alpha'] = '대문자';
$string['advlist:upper_roman'] = '로마 대문자';
$string['aria:rich_text_area'] = '리치 텍스트 영역';
$string['autosave:restore_content'] = '자동 저장된 내용 복구';
$string['autosave:unload_msg'] = '다른 페이지로 이동하면 편집한 내용이 취소됩니다.';
$string['autosave:warning_message'] = '저장된 콘텐츠를 복구하면, 현재 편집기에 있는 내용을 잃어버리게 될 것입니다. 저장된 콘텐츠를 복구하시겠습니까?';
$string['availablebuttons'] = '사용 가능한 버튼';
$string['colors:000000'] = '검정';
$string['colors:000080'] = '연한 파랑';
$string['colors:0000FF'] = '파랑';
$string['colors:003300'] = '진한 녹색';
$string['colors:003366'] = '어두운 푸른 하늘';
$string['colors:008000'] = '녹색';
$string['colors:008080'] = '물오리색';
$string['colors:00CCFF'] = '하늘 파란색';
$string['colors:00FF00'] = '석회색';
$string['colors:00FFFF'] = '아쿠아';
$string['colors:333300'] = '어두운 올리브색';
$string['colors:333333'] = '매우 어두운 회색';
$string['colors:333399'] = '남색';
$string['colors:3366FF'] = '로열 블루';
$string['colors:339966'] = '바다 녹색';
$string['colors:33CCCC'] = '터키색';
$string['colors:666699'] = '잿빛 파랑';
$string['colors:800000'] = '적갈색';
$string['colors:800080'] = '보라색';
$string['colors:808000'] = '올리브색';
$string['colors:808080'] = '회색';
$string['colors:993300'] = '번트 오렌지색';
$string['colors:993366'] = '갈색';
$string['colors:999999'] = '중간 회색';
$string['colors:99CC00'] = '연두색';
$string['colors:99CCFF'] = '옅은 하늘 색';
$string['colors:C0C0C0'] = '은색';
$string['colors:CC99FF'] = '자두색';
$string['colors:CCFFCC'] = '옅은 녹색';
$string['colors:CCFFFF'] = '옅은 시안';
$string['colors:FF0000'] = '빨강색';
$string['colors:FF00FF'] = '마젠타';
$string['colors:FF6600'] = '주황색';
$string['colors:FF9900'] = '호박색';
$string['colors:FF99CC'] = '분홍색';
$string['colors:FFCC00'] = '금색';
$string['colors:FFCC99'] = '복숭아색';
$string['colors:FFFF00'] = '노란색';
$string['colors:FFFF99'] = '밝은 노란색';
$string['colors:FFFFFF'] = '흰색';
$string['common:apply'] = '적용';
$string['common:browse'] = '브라우즈';
$string['common:cancel'] = '취소';
$string['common:class_name'] = '클래스';
$string['common:clipboard_msg'] = '복사/잘라내기/붙이기는 Mozilla 및Firefox 에서 사용되지 않습니다. 이 문제에 대해 상세정보를 원하십니까?';
$string['common:clipboard_no_support'] = '이 기능은 브라우저에 의해 제한되고 있습니다. 단축키을 이용하십시오.';
$string['common:close'] = '닫기';
$string['common:edit_confirm'] = 'WYSIWYG모드로 전환합니까?';
$string['common:insert'] = '삽입';
$string['common:invalid_data'] = '에러: 유효하지 않는 글자가 있습니다. 빨간색으로 표시됩니다.';
$string['common:invalid_data_min'] = '{#field}는  {#min} 보다 커야 합니다.';
$string['common:invalid_data_number'] = '{#field} 는 수 이어야 합니다.';
$string['common:invalid_data_size'] = '{#field}는 수이거나 퍼센트이어야 합니다.';
$string['common:more_colors'] = '그 외의 색';
$string['common:not_set'] = '-- 없음 --';
$string['common:popup_blocked'] = '팝업이 차단되었습니다. 모든 기능을 이용하시기 위해서는 팝업차단을 해제해 주세요.';
$string['common:update'] = '업데이트';
$string['common:value'] = '(값)';
$string['contextmenu:align'] = '정렬';
$string['contextmenu:center'] = '가운데 정렬';
$string['contextmenu:full'] = '배분 정렬';
$string['contextmenu:left'] = '왼쪽 정렬';
$string['contextmenu:right'] = '오른쪽 정렬';
$string['customconfig'] = '맞춤 구성';
$string['customtoolbar'] = '편집기 툴바';
$string['directionality:ltr_desc'] = '문자방향을 왼쪽에서 오른쪽으로';
$string['directionality:rtl_desc'] = '문자방향을 오른쪽에서 왼쪽으로';
$string['emotions_dlg:cool'] = '쿨';
$string['emotions_dlg:cry'] = '울음';
$string['emotions_dlg:desc'] = '이모티콘';
$string['emotions_dlg:embarassed'] = '부끄러움';
$string['emotions_dlg:foot_in_mouth'] = '실언';
$string['emotions_dlg:frown'] = '찡그린 얼굴';
$string['emotions_dlg:innocent'] = '천진난만';
$string['emotions_dlg:kiss'] = 'Kiss';
$string['emotions_dlg:laughing'] = '웃음';
$string['emotions_dlg:money_mouth'] = '돈';
$string['emotions_dlg:sealed'] = '봉인';
$string['emotions_dlg:smile'] = '스마일';
$string['emotions_dlg:surprised'] = '놀라움';
$string['emotions_dlg:title'] = '이모티콘 삽입';
$string['emotions_dlg:tongue_out'] = '메롱';
$string['emotions_dlg:undecided'] = '고민한다';
$string['emotions_dlg:usage'] = '찾아가기 위해 왼쪽 및 오른쪽 화살표를 사용하세요.';
$string['emotions_dlg:wink'] = '윙크';
$string['emotions_dlg:yell'] = '외친다';
$string['emotions:emotions_desc'] = '이모티콘';
$string['fontselectlist'] = '사용가능한 폰트 목록';
$string['fullpage:desc'] = '페이지의 속성';
$string['fullpage_dlg:active_color'] = '링크색(active)';
$string['fullpage_dlg:add'] = '요소 추가';
$string['fullpage_dlg:add_base'] = 'Base element';
$string['fullpage_dlg:add_comment'] = '덧글 마디';
$string['fullpage_dlg:add_link'] = 'Link element';
$string['fullpage_dlg:add_meta'] = 'Meta element';
$string['fullpage_dlg:add_script'] = 'Script element';
$string['fullpage_dlg:add_style'] = 'Style element';
$string['fullpage_dlg:add_title'] = 'Title element';
$string['fullpage_dlg:advanced_props'] = 'Advanced';
$string['fullpage_dlg:advanced_tab'] = '고급';
$string['fullpage_dlg:appearance_bgprops'] = '배경 설정';
$string['fullpage_dlg:appearance_linkprops'] = '링크색';
$string['fullpage_dlg:appearance_marginprops'] = 'Body 마진';
$string['fullpage_dlg:appearance_style'] = '스타일시트 설정';
$string['fullpage_dlg:appearance_tab'] = '표시';
$string['fullpage_dlg:appearance_textprops'] = '텍스트 설정';
$string['fullpage_dlg:author'] = '필자';
$string['fullpage_dlg:base_element'] = 'Base element';
$string['fullpage_dlg:bgcolor'] = '배경색';
$string['fullpage_dlg:bgimage'] = '배경 이미지';
$string['fullpage_dlg:bottom_margin'] = '아래 마진';
$string['fullpage_dlg:charset'] = 'Charset';
$string['fullpage_dlg:comment_element'] = '덧글';
$string['fullpage_dlg:content'] = 'Content';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = '문자 인코딩';
$string['fullpage_dlg:fontface'] = '폰트';
$string['fullpage_dlg:font_face'] = '글꼴';
$string['fullpage_dlg:fontsize'] = '문자 크기';
$string['fullpage_dlg:font_size'] = '문자 크기';
$string['fullpage_dlg:general_props'] = 'General';
$string['fullpage_dlg:head_elements'] = 'Head elements';
$string['fullpage_dlg:hover_color'] = '링크색(hover)';
$string['fullpage_dlg:href'] = 'Href';
$string['fullpage_dlg:hreflang'] = 'Href lang';
$string['fullpage_dlg:info'] = 'Information';
$string['fullpage_dlg:langcode'] = '언어 코드';
$string['fullpage_dlg:langdir'] = '문자 방향';
$string['fullpage_dlg:langprops'] = '언어와 인코딩';
$string['fullpage_dlg:language'] = 'Language';
$string['fullpage_dlg:left_margin'] = '왼쪽 마진';
$string['fullpage_dlg:link_color'] = '링크색';
$string['fullpage_dlg:link_element'] = 'Link element';
$string['fullpage_dlg:ltr'] = '왼쪽에서 오른쪽';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Description';
$string['fullpage_dlg:meta_element'] = 'Meta element';
$string['fullpage_dlg:meta_index_follow'] = '모두 허가';
$string['fullpage_dlg:meta_index_nofollow'] = '페이지를 허가하지만 링크 금지';
$string['fullpage_dlg:meta_keywords'] = 'Keywords';
$string['fullpage_dlg:meta_noindex_follow'] = '페이지를 금지하고 링크 허가';
$string['fullpage_dlg:meta_noindex_nofollow'] = '모두 금지';
$string['fullpage_dlg:meta_props'] = '메타 정보';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = '일반';
$string['fullpage_dlg:meta_title'] = 'Title';
$string['fullpage_dlg:movedown'] = '선택 요소를 아래에 이동';
$string['fullpage_dlg:moveup'] = '선택 요소를 위에 이동';
$string['fullpage_dlg:name'] = 'Name';
$string['fullpage_dlg:properties'] = 'Properties';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = '선택 요소를 삭제';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = '오른쪽 마진';
$string['fullpage_dlg:rtl'] = '오른쪽에서 왼쪽';
$string['fullpage_dlg:script_element'] = 'Script element';
$string['fullpage_dlg:src'] = 'Src';
$string['fullpage_dlg:style'] = '스타일';
$string['fullpage_dlg:style_element'] = 'Style element';
$string['fullpage_dlg:stylesheet'] = '스타일시트';
$string['fullpage_dlg:target'] = 'Target';
$string['fullpage_dlg:textcolor'] = '색';
$string['fullpage_dlg:text_color'] = '문자색';
$string['fullpage_dlg:title'] = '페이지의 속성';
$string['fullpage_dlg:title_element'] = 'Title element';
$string['fullpage_dlg:top_margin'] = '위 마진';
$string['fullpage_dlg:type'] = 'Type';
$string['fullpage_dlg:value'] = 'Value';
$string['fullpage_dlg:visited_color'] = '링크색(visited)';
$string['fullpage_dlg:xml_pi'] = 'XML선언';
$string['fullscreen:desc'] = '전체화면';
$string['iespell:download'] = 'ieSpell이 발견되지 않았습니다.n인스톨 하시겠습니까?';
$string['iespell:iespell_desc'] = '철자 검사';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = '일요일,월요일,화요일,수요일,목요일,금요일,토요일,일요일';
$string['insertdatetime:day_short'] = '일,월,화,수,목,금,토,일';
$string['insertdatetime:insertdate_desc'] = '날짜 삽입';
$string['insertdatetime:inserttime_desc'] = '시간 삽입';
$string['insertdatetime:months_long'] = '1월,2월,3월,4월,5월,6월,7월,8월,9월,10월,11월,12월';
$string['insertdatetime:months_short'] = '1,2,3,4,5,6,7,8,9,10,11,12';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = '절대위치로 전환';
$string['layer:backward_desc'] = '뒤로 이동';
$string['layer:content'] = '새 레이어...';
$string['layer:forward_desc'] = '앞으로 이동';
$string['layer:insertlayer_desc'] = '새 레이어';
$string['media:desc'] = '미디어의 삽입/편집';
$string['media_dlg:advanced'] = '고급';
$string['media_dlg:align'] = 'Align';
$string['media_dlg:align_bottom'] = 'Bottom';
$string['media_dlg:align_bottom_left'] = 'Bottom left';
$string['media_dlg:align_bottom_right'] = 'Bottom right';
$string['media_dlg:align_center'] = 'Center';
$string['media_dlg:align_left'] = 'Left';
$string['media_dlg:align_right'] = 'Right';
$string['media_dlg:align_top'] = 'Top';
$string['media_dlg:align_top_left'] = 'Top left';
$string['media_dlg:align_top_right'] = 'Top right';
$string['media_dlg:altsource1'] = '대체 소스 1';
$string['media_dlg:altsource2'] = '대체 소스 2';
$string['media_dlg:audio'] = 'HTML5 오디오';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'AutoHREF';
$string['media_dlg:autostart'] = 'Auto start';
$string['media_dlg:balance'] = 'Balance';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'Base URL';
$string['media_dlg:bgcolor'] = 'Background';
$string['media_dlg:cache'] = '캐시';
$string['media_dlg:captioningid'] = 'Captioning id';
$string['media_dlg:center'] = 'Center';
$string['media_dlg:class_name'] = 'Class';
$string['media_dlg:console'] = 'Console';
$string['media_dlg:constrain_proportions'] = '종횡비 유지';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Controls';
$string['media_dlg:correction'] = 'No correction';
$string['media_dlg:currentmarker'] = 'Current marker';
$string['media_dlg:currentposition'] = 'Current position';
$string['media_dlg:defaultframe'] = 'Default frame';
$string['media_dlg:embeddedaudio'] = '임베디드 오디오';
$string['media_dlg:embedded_audio_options'] = '임베디드 오이오 옵션';
$string['media_dlg:enabled'] = 'Enabled';
$string['media_dlg:enablejavascript'] = 'JavaScript를 허가';
$string['media_dlg:endtime'] = 'End time';
$string['media_dlg:file'] = '파일/URL';
$string['media_dlg:flash'] = '플래시';
$string['media_dlg:flash_options'] = 'Flash options';
$string['media_dlg:flashvars'] = 'Flashvars';
$string['media_dlg:fullscreen'] = 'Fullscreen';
$string['media_dlg:general'] = '일반';
$string['media_dlg:hidden'] = 'Hidden';
$string['media_dlg:href'] = 'Href';
$string['media_dlg:hspace'] = '좌우 여백';
$string['media_dlg:html5_audio_options'] = '오디오 옵션';
$string['media_dlg:html5_video_options'] = 'HTML5 비디오 옵션';
$string['media_dlg:id'] = 'Id';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Image status';
$string['media_dlg:invokeurls'] = 'Invoke URLs';
$string['media_dlg:kioskmode'] = 'Kiosk mode';
$string['media_dlg:list'] = '목록';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = '연속 재생';
$string['media_dlg:maintainaspect'] = 'Maintain aspect';
$string['media_dlg:menu'] = '메뉴 표시';
$string['media_dlg:mute'] = 'Mute';
$string['media_dlg:name'] = 'Name';
$string['media_dlg:nojava'] = 'No java';
$string['media_dlg:numloop'] = 'Num loops';
$string['media_dlg:play'] = '자동 재생';
$string['media_dlg:playcount'] = 'Play count';
$string['media_dlg:playeveryframe'] = 'Play every frame';
$string['media_dlg:poster'] = '포스터';
$string['media_dlg:prefetch'] = 'Prefetch';
$string['media_dlg:preload'] = '프리로드';
$string['media_dlg:preload_auto'] = '사용자의 브라우저가 결정하도록 함';
$string['media_dlg:preload_metadata'] = '비디오 메타데이터를 미리 로드';
$string['media_dlg:preload_none'] = '미리 로드하지 않음';
$string['media_dlg:preview'] = '미리보기';
$string['media_dlg:progress'] = 'Progress';
$string['media_dlg:qt_options'] = 'Quicktime options';
$string['media_dlg:qtsrc'] = 'QT Src';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:qt_stream_warn'] = '고급탭에 있는 QT Src 필드에 스트림되는 rtsp 자원이 추가되어야 합니다.  Src 필드에 스트림되지 않는 버전도 추가 해야합니다.';
$string['media_dlg:quality'] = '품질';
$string['media_dlg:quicktime'] = '퀵타임';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:realmedia'] = '리얼미디어';
$string['media_dlg:rmp_options'] = 'Real media player options';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = '스케일';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave options';
$string['media_dlg:shuffle'] = 'Shuffle';
$string['media_dlg:size'] = '크기';
$string['media_dlg:sound'] = 'Sound';
$string['media_dlg:source'] = '소스';
$string['media_dlg:starttime'] = 'Start time';
$string['media_dlg:stretchtofit'] = 'Stretch to fit';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Align';
$string['media_dlg:swstretchstyle'] = 'Stretch style';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Align';
$string['media_dlg:target'] = 'Target';
$string['media_dlg:targetcache'] = 'Target cache';
$string['media_dlg:title'] = '미디어의 삽입/편집';
$string['media_dlg:type'] = '타입';
$string['media_dlg:uimode'] = 'UI Mode';
$string['media_dlg:video'] = 'HTML% 비디오';
$string['media_dlg:volume'] = 'Volume';
$string['media_dlg:vspace'] = '상하 여백';
$string['media_dlg:windowlessvideo'] = 'Windowless video';
$string['media_dlg:windowsmedia'] = '윈도우 미디어';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Windows media player options';
$string['media:edit'] = '미디어의 편집';
$string['nonbreaking:nonbreaking_desc'] = '빈칸 삽입';
$string['pagebreak:desc'] = '새페이지 삽입';
$string['paste_dlg:text_linebreaks'] = '개행을 보관 유지';
$string['paste_dlg:text_title'] = '윈도우에 텍스트를 붙이려면 키보드로 Ctrl+V를 입력해 주세요.';
$string['paste_dlg:word_title'] = '윈도우에 텍스트를 붙이려면 키보드로Ctrl+V를 입력해 주세요.';
$string['paste:paste_text_desc'] = '텍스트처럼 붙여넣기';
$string['paste:paste_word_desc'] = 'Word로부터 붙여넣기';
$string['paste:plaintext_mode'] = '붙여넣기는 평문 모드입니다. 일반적인 붙여넣기 모드로 돌아가려면 클릭하세요.';
$string['paste:selectall_desc'] = '모두 선택';
$string['pluginname'] = 'TinyMCE HTML 에디터';
$string['preview:preview_desc'] = '미리보기';
$string['print:print_desc'] = '인쇄';
$string['save:cancel_desc'] = '모두 취소';
$string['save:save_desc'] = '저장';
$string['searchreplace_dlg:allreplaced'] = '모두 치환되었습니다.';
$string['searchreplace_dlg:direction'] = '방향';
$string['searchreplace_dlg:down'] = '아래에';
$string['searchreplace_dlg:findnext'] = '검색';
$string['searchreplace_dlg:findwhat'] = '검색 문자열';
$string['searchreplace_dlg:mcase'] = '대문자/소문자를 구별';
$string['searchreplace_dlg:notfound'] = '검색이 완료했습니다. 검색 문자열은 발견되지 않았습니다.';
$string['searchreplace_dlg:replace'] = '치환';
$string['searchreplace_dlg:replaceall'] = '모두 치환';
$string['searchreplace_dlg:replace_title'] = '검색/치환';
$string['searchreplace_dlg:replacewith'] = '치환 문자열';
$string['searchreplace_dlg:searchnext_desc'] = '재검색';
$string['searchreplace_dlg:search_title'] = '검색';
$string['searchreplace_dlg:up'] = '위에';
$string['searchreplace:replace_desc'] = '검색/치환';
$string['searchreplace:search_desc'] = '검색';
$string['settings'] = '일반 설정';
$string['simple:bold_desc'] = '굵은 글씨(Ctrl+B)';
$string['simple:bullist_desc'] = '비순차목록';
$string['simple:cleanup_desc'] = '지저분한 코드 삭제';
$string['simple:italic_desc'] = '이탤릭(Ctrl+I)';
$string['simple:numlist_desc'] = '순차목록';
$string['simple:redo_desc'] = '다시실행(Ctrl+Y)';
$string['simple:striketrough_desc'] = '취소선';
$string['simple:underline_desc'] = '밑줄(Ctrl+U)';
$string['simple:undo_desc'] = '실행취소(Ctrl+Z)';
$string['spellchecker:desc'] = '스펠링 전환';
$string['spellchecker:ignore_word'] = '이 어구를 무시';
$string['spellchecker:ignore_words'] = '모두 무시';
$string['spellchecker:langs'] = '언어';
$string['spellchecker:learn_word'] = '단어 배우기';
$string['spellchecker:menu'] = '스펠링 설정';
$string['spellchecker:no_mpell'] = '오탈자가 발견되지 않았습니다.';
$string['spellchecker:no_sug'] = '후보 없음';
$string['spellchecker:sug'] = '후보';
$string['spellchecker:wait'] = '기다려 주세요...';
$string['style:desc'] = 'CSS편집';
$string['style_dlg:apply'] = '적용';
$string['style_dlg:background'] = '배경';
$string['style_dlg:background_attachment'] = '첨부';
$string['style_dlg:background_color'] = '배경색';
$string['style_dlg:background_hpos'] = '수평 위치';
$string['style_dlg:background_image'] = '배경 이미지';
$string['style_dlg:background_repeat'] = '반복';
$string['style_dlg:background_tab'] = '배경';
$string['style_dlg:background_vpos'] = '수직 위치';
$string['style_dlg:block'] = '블록';
$string['style_dlg:block_display'] = '표시';
$string['style_dlg:block_letterspacing'] = '문자 간격';
$string['style_dlg:block_tab'] = '블록';
$string['style_dlg:block_text_align'] = '텍스트 정렬';
$string['style_dlg:block_text_indent'] = '들여쓰기';
$string['style_dlg:block_vertical_alignment'] = '수직 위치';
$string['style_dlg:block_whitespace'] = '공백 문자';
$string['style_dlg:block_wordspacing'] = '단어 간격';
$string['style_dlg:border'] = '경계';
$string['style_dlg:border_tab'] = '테두리선';
$string['style_dlg:bottom'] = '하';
$string['style_dlg:box'] = '박스';
$string['style_dlg:box_clear'] = 'Clear';
$string['style_dlg:box_float'] = 'float';
$string['style_dlg:box_height'] = '높이';
$string['style_dlg:box_tab'] = '박스';
$string['style_dlg:box_width'] = '폭';
$string['style_dlg:bullet_image'] = '블릿 이미지';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = '색';
$string['style_dlg:height'] = '높이';
$string['style_dlg:left'] = '좌';
$string['style_dlg:list'] = '목록';
$string['style_dlg:list_tab'] = '리스트';
$string['style_dlg:list_type'] = '목록종류';
$string['style_dlg:margin'] = '마진';
$string['style_dlg:overflow'] = '오버플로우';
$string['style_dlg:padding'] = 'padding';
$string['style_dlg:placement'] = '위치(placement)';
$string['style_dlg:position'] = '위치';
$string['style_dlg:positioning_tab'] = '위치';
$string['style_dlg:positioning_type'] = '타입';
$string['style_dlg:right'] = '우';
$string['style_dlg:same'] = '모두 똑같이';
$string['style_dlg:style'] = '스타일';
$string['style_dlg:text'] = '텍스트';
$string['style_dlg:text_blink'] = '점멸';
$string['style_dlg:text_case'] = '대/소문자';
$string['style_dlg:text_color'] = '색';
$string['style_dlg:text_decoration'] = '장식';
$string['style_dlg:text_font'] = '폰트';
$string['style_dlg:text_lineheight'] = '행 높이';
$string['style_dlg:text_none'] = '없음';
$string['style_dlg:text_overline'] = '윗줄';
$string['style_dlg:text_props'] = '텍스트';
$string['style_dlg:text_size'] = '크기';
$string['style_dlg:text_striketrough'] = '취소선';
$string['style_dlg:text_style'] = '스타일';
$string['style_dlg:text_tab'] = '텍스트';
$string['style_dlg:text_underline'] = '밑줄';
$string['style_dlg:text_variant'] = 'Variant';
$string['style_dlg:text_weight'] = '굵기';
$string['style_dlg:title'] = 'CSS편집';
$string['style_dlg:toggle_insert_span'] = '선택한 것에 스팬 삽입';
$string['style_dlg:top'] = '상';
$string['style_dlg:visibility'] = '가시성';
$string['style_dlg:width'] = '폭';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = '플러그인';
$string['subplugintype_tinymce_plural'] = '플러그인';
$string['table:cell'] = '셀';
$string['table:cell_desc'] = '셀의 속성';
$string['table:col'] = '열';
$string['table:col_after_desc'] = '뒤에 열삽입';
$string['table:col_before_desc'] = '앞에 열삽입';
$string['table:copy_row_desc'] = '행을 복사';
$string['table:cut_row_desc'] = '행을 잘라내기';
$string['table:del'] = '테이블 삭제';
$string['table:delete_col_desc'] = '열삭제';
$string['table:delete_row_desc'] = '행 삭제';
$string['table:desc'] = '새 테이블 삽입';
$string['table_dlg:advanced_props'] = '고급 설정';
$string['table_dlg:advanced_tab'] = '고급';
$string['table_dlg:align'] = '정렬';
$string['table_dlg:align_bottom'] = '하';
$string['table_dlg:align_default'] = '기본값';
$string['table_dlg:align_left'] = '왼쪽 맞춤';
$string['table_dlg:align_middle'] = '가운데 맞춤';
$string['table_dlg:align_right'] = '오른쪽 맞춤';
$string['table_dlg:align_top'] = '상';
$string['table_dlg:bgcolor'] = '배경색';
$string['table_dlg:bgimage'] = '배경 이미지';
$string['table_dlg:border'] = '테두리선';
$string['table_dlg:bordercolor'] = '테두리선색';
$string['table_dlg:caption'] = '표제';
$string['table_dlg:cell_all'] = '테이블의 모든 셀을 업데이트';
$string['table_dlg:cell_cell'] = '현재의 셀을 업데이트';
$string['table_dlg:cell_col'] = '열에 있는 모든 셀 업데이트';
$string['table_dlg:cell_limit'] = '셀수의 상한{$cells}를 넘었습니다.';
$string['table_dlg:cellpadding'] = '셀내 여백';
$string['table_dlg:cell_row'] = '행의 모든 셀을 업데이트';
$string['table_dlg:cellspacing'] = '셀 간격';
$string['table_dlg:cell_title'] = '셀 설정';
$string['table_dlg:cell_type'] = '셀 종류';
$string['table_dlg:colgroup'] = '열그룹';
$string['table_dlg:col_limit'] = '렬수의 상한{$cols}를 넘었습니다.';
$string['table_dlg:cols'] = '렬';
$string['table_dlg:frame'] = 'Frame';
$string['table_dlg:frame_all'] = '모두';
$string['table_dlg:frame_cols'] = '열';
$string['table_dlg:frame_groups'] = '그룹';
$string['table_dlg:frame_none'] = '없음';
$string['table_dlg:frame_rows'] = '행';
$string['table_dlg:general_props'] = '일반 설정';
$string['table_dlg:general_tab'] = '일반';
$string['table_dlg:height'] = '높이';
$string['table_dlg:id'] = 'Id';
$string['table_dlg:langcode'] = '언어 코드';
$string['table_dlg:langdir'] = '문자 방향';
$string['table_dlg:ltr'] = '왼쪽에서 오른쪽';
$string['table_dlg:merge_cells_title'] = '셀 결합';
$string['table_dlg:mime'] = 'Target MIME 타입';
$string['table_dlg:missing_scope'] = '이 표 헤더셀에 scope속성을 지정하지않아도 괜찮습니까? 지정하지 않는 경우, 시간적으로 테이블의 구조를 파악하는 것이 어려운 분의 접근성이 저하합니다.';
$string['table_dlg:row_all'] = '모든 행을 업데이트';
$string['table_dlg:row_even'] = '짝수행을 업데이트';
$string['table_dlg:rowgroup'] = '행그룹';
$string['table_dlg:row_limit'] = '행수의 상한{$rows}를 넘었습니다.';
$string['table_dlg:row_odd'] = '홀수행을 업데이트';
$string['table_dlg:row_row'] = '현재의 행을 업데이트';
$string['table_dlg:rows'] = '행';
$string['table_dlg:row_title'] = '행 설정';
$string['table_dlg:rowtype'] = '행';
$string['table_dlg:rtl'] = '오른쪽에서 왼쪽';
$string['table_dlg:rules'] = 'Rules';
$string['table_dlg:rules_above'] = '위';
$string['table_dlg:rules_below'] = '아래';
$string['table_dlg:rules_border'] = 'border';
$string['table_dlg:rules_box'] = 'box';
$string['table_dlg:rules_hsides'] = '상하범위만';
$string['table_dlg:rules_lhs'] = '좌측 범위만';
$string['table_dlg:rules_rhs'] = '우측 범위만';
$string['table_dlg:rules_void'] = 'Void';
$string['table_dlg:rules_vsides'] = '좌우범위만';
$string['table_dlg:scope'] = 'Scope';
$string['table_dlg:style'] = '스타일';
$string['table_dlg:summary'] = '요약';
$string['table_dlg:tbody'] = 'Table Body';
$string['table_dlg:td'] = 'Data';
$string['table_dlg:tfoot'] = '테이블 풋터';
$string['table_dlg:th'] = 'Header';
$string['table_dlg:thead'] = 'Table Head';
$string['table_dlg:title'] = '테이블의 삽입/편집';
$string['table_dlg:valign'] = '수직 위치';
$string['table_dlg:width'] = '폭';
$string['table:merge_cells_desc'] = '셀을 결합';
$string['table:paste_row_after_desc'] = '뒤로 행을 붙여넣기';
$string['table:paste_row_before_desc'] = '앞에 행을 붙여넣기';
$string['table:props_desc'] = '테이블 속성';
$string['table:row'] = '행';
$string['table:row_after_desc'] = '뒤에 행 삽입';
$string['table:row_before_desc'] = '앞에 행 삽입';
$string['table:row_desc'] = '행의 속성';
$string['table:split_cells_desc'] = '결합된 셀을 분할';
$string['template:desc'] = '정의가 끝난 템플릿의 삽입';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = '일요일,월요일,화요일,수요일,목요일,금요일,토요일,일요일';
$string['template_dlg:day_short'] = '일,월,화,수,목,금,토,일';
$string['template_dlg:desc'] = '템플릿의 삽입';
$string['template_dlg:desc_label'] = '설명';
$string['template_dlg:label'] = '템플릿';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = '1월,2월,3월,4월,5월,6월,7월,8월,9월,10월,11월,12월';
$string['template_dlg:months_short'] = '1,2,3,4,5,6,7,8,9,10,11,12';
$string['template_dlg:preview'] = '미리보기';
$string['template_dlg:select'] = '템플릿 선택';
$string['template_dlg:title'] = '템플릿';
$string['template_dlg:warning'] = '경고: 템플릿을 업데이트하면 이전의 데이터는 없어집니다.';
$string['visualblocks:desc'] = '블록 요소 표시/감추기';
$string['visualchars:desc'] = '제어 문자의 표시 전환';
$string['wordcount:words'] = '단어들:';
$string['xhtmlxtras:abbr_desc'] = '약기';
$string['xhtmlxtras:acronym_desc'] = '머리 글자어';
$string['xhtmlxtras:attribs_desc'] = '속성 삽입/편집';
$string['xhtmlxtras:cite_desc'] = '인용처';
$string['xhtmlxtras:del_desc'] = '삭제';
$string['xhtmlxtras_dlg:attribs_title'] = '속성의 삽입/편집';
$string['xhtmlxtras_dlg:attrib_tab'] = '속성';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = '속성';
$string['xhtmlxtras_dlg:attribute_events_tab'] = '이벤트';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = '액세스 키';
$string['xhtmlxtras_dlg:attribute_label_cite'] = '인용';
$string['xhtmlxtras_dlg:attribute_label_class'] = '클래스';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = '날짜/시간';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = '언어';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = '문자 방향';
$string['xhtmlxtras_dlg:attribute_label_style'] = '스타일';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = '탭 인덱스';
$string['xhtmlxtras_dlg:attribute_label_title'] = '제목';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = '왼쪽에서 오른쪽';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = '오른쪽에서 왼쪽';
$string['xhtmlxtras_dlg:events_tab'] = '이벤트';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = '요소의 속성';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = '요소의 이벤트';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = '일반 설정';
$string['xhtmlxtras_dlg:general_tab'] = '일반';
$string['xhtmlxtras_dlg:insert_date'] = '현재의 날짜/시간을 삽입';
$string['xhtmlxtras_dlg:option_ltr'] = '왼쪽에서 오른쪽';
$string['xhtmlxtras_dlg:option_rtl'] = '오른쪽에서 왼쪽';
$string['xhtmlxtras_dlg:remove'] = '삭제';
$string['xhtmlxtras_dlg:title_abbr_element'] = '약기 요소';
$string['xhtmlxtras_dlg:title_acronym_element'] = '머리 글자어 요소';
$string['xhtmlxtras_dlg:title_cite_element'] = '인용 요소';
$string['xhtmlxtras_dlg:title_del_element'] = '요소의 삭제';
$string['xhtmlxtras_dlg:title_ins_element'] = '요소의 삽입';
$string['xhtmlxtras:ins_desc'] = '삽입';
