<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'fr', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'prêt à être installé';
$string['action'] = 'Action';
$string['actionchoice'] = 'Que voulez-vous faire avec le fichier « {$a} »?';
$string['actions'] = 'Actions';
$string['active'] = 'Actif';
$string['activeusers'] = 'Utilisateurs actifs';
$string['activities'] = 'Activités';
$string['activities_help'] = 'Vous pouvez ajouter à votre cours des activités (forums, tests, wikis, etc.) pour le rendre interactif.';
$string['activity'] = 'Activité';
$string['activityclipboard'] = 'Déplacement de l\'activité {$a}';
$string['activityiscurrentlyhidden'] = 'Désolé, cette activité n\'est pas visible actuellement';
$string['activitymodule'] = 'Module d\'activité';
$string['activitymodules'] = 'Modules d\'activité';
$string['activityreport'] = 'Rapport d\'activité';
$string['activityreports'] = 'Rapports d\'activité';
$string['activityselect'] = 'Sélectionner cette activité pour la déplacer';
$string['activitysince'] = 'Activité depuis le {$a}';
$string['activityweighted'] = 'Activité par utilisateur';
$string['add'] = 'Ajouter';
$string['addactivity'] = 'Ajouter une activité...';
$string['addactivitytosection'] = 'Ajouter une activité à la section « {$a} »';
$string['addadmin'] = 'Désigner comme administrateur';
$string['addblock'] = 'Ajouter un bloc';
$string['addcomment'] = 'Ajouter un commentaire...';
$string['addcountertousername'] = 'Créer un utilisateur en ajoutant un nombre au nom d\'utilisateur';
$string['addcreator'] = 'Désigner comme créateur de cours';
$string['adddots'] = 'Ajouter...';
$string['added'] = '{$a} ajouté(e)';
$string['addedrecip'] = '{$a} nouveau destinataire ajouté';
$string['addedrecips'] = '{$a} nouveaux destinataires ajoutés';
$string['addedtogroup'] = 'Ajouté au groupe « {$a} »';
$string['addedtogroupnot'] = 'Non ajouté au groupe « {$a} »';
$string['addedtogroupnotenrolled'] = 'Non ajouté au groupe « {$a} », parce que non inscrit au cours';
$string['addfilehere'] = 'Ajouter ici un ou des fichiers';
$string['addinganew'] = 'Ajout {$a}';
$string['addinganewto'] = 'Ajout {$a->what} à {$a->to}';
$string['addingdatatoexisting'] = 'Ajout à des données existantes';
$string['additionalnames'] = 'Noms supplémentaires';
$string['addlinkhere'] = 'Ajouter ici un lien';
$string['addnewcategory'] = 'Ajouter une catégorie de cours';
$string['addnewcourse'] = 'Ajouter un cours';
$string['addnewuser'] = 'Ajouter un utilisateur';
$string['addnousersrecip'] = 'Ajouter à la liste des destinataires les utilisateurs n\'ayant pas encore accédé à ce {$a}';
$string['addpagehere'] = 'Ajouter du texte ici';
$string['addresource'] = 'Ajouter une ressource...';
$string['addresourceoractivity'] = 'Ajouter une activité ou une ressource';
$string['addresourcetosection'] = 'Ajouter une ressource à la section « {$a} »';
$string['address'] = 'Adresse';
$string['addstudent'] = 'Ajouter un étudiant';
$string['addsubcategory'] = 'Ajouter une sous-catégorie';
$string['addteacher'] = 'Désigner comme enseignant';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'Créer manuellement un nouveau compte d\'utilisateur';
$string['adminhelpassignadmins'] = 'Les administrateurs peuvent tout faire et aller partout dans le site';
$string['adminhelpassigncreators'] = 'Les créateurs de cours peuvent créer de nouveaux cours';
$string['adminhelpassignsiteroles'] = 'Attribuer des rôles du site à des utilisateurs';
$string['adminhelpassignstudents'] = 'Choisissez un cours et ajoutez des étudiants (menu Administration)';
$string['adminhelpauthentication'] = 'Il est possible d\'utiliser des comptes internes ou ceux d\'une base de données externe';
$string['adminhelpbackup'] = 'Configurer les sauvegardes';
$string['adminhelpconfiguration'] = 'Configurer l\'aspect et le fonctionnement du site';
$string['adminhelpconfigvariables'] = 'Configurer les paramètres réglant le fonctionnement général du site';
$string['adminhelpcourses'] = 'Définir les cours et les catégories, inscrire des utilisateurs à ces cours, gérer les demandes de cours';
$string['adminhelpeditorsettings'] = 'Définir la configuration de base de l\'éditeur WYSIWYG';
$string['adminhelpedituser'] = 'Consulter la liste des comptes des utilisateurs et les modifier';
$string['adminhelpenvironment'] = 'Vérifier que votre serveur possède les spécifications d\'une installation actuelle et future';
$string['adminhelpfailurelogs'] = 'Consulter les historiques des tentatives de connexion';
$string['adminhelplanguage'] = 'Vérifier ou modifier le paquetage de la langue en cours';
$string['adminhelplogs'] = 'Consulter les historiques de toutes les activités de ce site';
$string['adminhelpmanageblocks'] = 'Gérer les blocs installés et leurs paramètres';
$string['adminhelpmanagedatabase'] = 'Accéder directement à la base de données (DANGER !)';
$string['adminhelpmanagefilters'] = 'Choisir les filtres de texte et leurs paramètres';
$string['adminhelpmanagemodules'] = 'Gérer les modules installés et leurs paramètres';
$string['adminhelpmanageroles'] = 'Créer et définir les rôles pouvant être assigné aux utilisateurs';
$string['adminhelpmymoodle'] = 'Configurer les blocs de Ma page pour les utilisateurs';
$string['adminhelpreports'] = 'Rapports du site';
$string['adminhelpsitefiles'] = 'Publier des fichiers ou télécharger des copies de sauvegarde externes';
$string['adminhelpsitesettings'] = 'Définir l\'aspect de la page d\'accueil de ce site';
$string['adminhelpstickyblocks'] = 'Configurer les blocs fixes pour tout ce serveur Moodle';
$string['adminhelpthemes'] = 'Choisir une interface graphique pour le site (couleurs, polices, etc.)';
$string['adminhelpuploadusers'] = 'Importer de nouveaux comptes utilisateurs';
$string['adminhelpusers'] = 'Définir vos utilisateurs et l\'authentification';
$string['adminhelpxmldbeditor'] = 'Interface pour la modification des fichiers XMLDB. Seulement pour les développeurs.';
$string['administration'] = 'Administration';
$string['administrationsite'] = 'Administration du site';
$string['administrator'] = 'Administrateur';
$string['administratordescription'] = 'Les administrateurs peuvent tout faire sur le site, dans tous les cours.';
$string['administrators'] = 'Administrateurs';
$string['administratorsall'] = 'Tous les administrateurs';
$string['administratorsandteachers'] = 'Administrateurs et enseignants';
$string['advanced'] = 'Avancé';
$string['advancedfilter'] = 'Plus de critères';
$string['advancedsettings'] = 'Réglages avancés';
$string['afterresource'] = 'Après la ressource « {$a} »';
$string['aftersection'] = 'Après la section « {$a} »';
$string['again'] = 'à nouveau';
$string['aimid'] = 'Identifiant AIM';
$string['ajaxuse'] = 'AJAX et Javascript';
$string['all'] = 'Tout';
$string['allactions'] = 'Toutes les actions';
$string['allactivities'] = 'Toutes les activités';
$string['allcategories'] = 'Toutes les catégories';
$string['allchanges'] = 'Toutes les modifications';
$string['alldays'] = 'Tous les jours';
$string['allfieldsrequired'] = 'Tous les champs sont requis';
$string['allfiles'] = 'Tous les fichiers';
$string['allgroups'] = 'Tous les groupes';
$string['alllogs'] = 'Tous les historiques';
$string['allmods'] = 'Tous les {$a}';
$string['allow'] = 'Autoriser';
$string['allowinternal'] = 'Permettre aussi les méthodes internes';
$string['allownone'] = 'Aucun';
$string['allownot'] = 'Interdire';
$string['allparticipants'] = 'Tous les participants';
$string['allteachers'] = 'Tous les enseignants';
$string['alphanumerical'] = 'Seuls les lettres, chiffres, tiret (-) et point (.) sont autorisés';
$string['alreadyconfirmed'] = 'L\'enregistrement a déjà été confirmé';
$string['alternatename'] = 'Autre nom';
$string['always'] = 'Toujours';
$string['and'] = '{$a->one} et {$a->two}';
$string['answer'] = 'Réponse';
$string['any'] = 'Tout';
$string['appearance'] = 'Apparence';
$string['approve'] = 'Approuver';
$string['areyousure'] = 'En êtes-vous bien sûr ?';
$string['areyousuretorestorethis'] = 'Voulez-vous vraiment restaurer cette sauvegarde ?';
$string['areyousuretorestorethisinfo'] = 'Vous aurez plus tard la possibilité d\'ajouter cette sauvegarde à un cours existant ou de créer un nouveau cours avec ces données.';
$string['asc'] = 'Ascendant';
$string['assessment'] = 'Évaluation';
$string['assignadmins'] = 'Choisir les administrateurs';
$string['assigncreators'] = 'Choisir les créateurs de cours';
$string['assignedrolecount'] = '{$a->role} : {$a->count}';
$string['assignsiteroles'] = 'Attribuer les rôles globaux du site';
$string['authenticateduser'] = 'Utilisateur authentifié';
$string['authenticateduserdescription'] = 'Tous les utilisateurs connectés.';
$string['authentication'] = 'Authentification';
$string['authenticationplugins'] = 'Plugins d\'authentification';
$string['autosubscribe'] = 'Auto-abonnement aux forums';
$string['autosubscribeno'] = 'Non, ne pas m\'abonner automatiquement aux forums';
$string['autosubscribeyes'] = 'Oui, m\'abonner à un forum si j\'y écris un message';
$string['availability'] = 'Disponibilité';
$string['availablecourses'] = 'Cours disponibles';
$string['back'] = 'Retour';
$string['backto'] = 'Retour à {$a}';
$string['backtocourselisting'] = 'Retour à la liste des cours';
$string['backtopageyouwereon'] = 'Retour à la page d\'où vous venez';
$string['backtoparticipants'] = 'Retour à la liste des participants';
$string['backup'] = 'Sauvegarde';
$string['backupactivehelp'] = 'Choisissez d\'activer ou non les sauvegardes automatiques.';
$string['backupcancelled'] = 'Sauvegarde annulée';
$string['backupcoursefileshelp'] = 'Une fois cette option activée, les fichiers des cours seront inclus dans les sauvegardes automatiques';
$string['backupdate'] = 'Date de la sauvegarde';
$string['backupdatenew'] = '  {$a->TAG} est maintenant {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} était {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Détails de la sauvegarde';
$string['backupexecuteathelp'] = 'Choisissez l\'heure à laquelle les sauvegardes automatiques doivent être lancées.';
$string['backupfailed'] = 'Certains de vos cours n\'ont pas été sauvegardés !';
$string['backupfilename'] = 'sauvegarde';
$string['backupfinished'] = 'La sauvegarde s\'est déroulée sans erreur';
$string['backupfromthissite'] = 'La sauvegarde a-t-elle été effectuée sur ce site ?';
$string['backupgradebookhistoryhelp'] = 'Ce réglage indique si l\'historique du carnet de notes sera inclus dans les sauvegardes automatiques. Veuillez noter que l\'historique des notes ne doit pas être désactivé dans les réglages serveur (disablegradehistory) pour que ceci fonctionne';
$string['backupincludemoduleshelp'] = 'Choisissez si vous désirez inclure dans les sauvegardes automatiques les modules de cours, avec ou sans les données des utilisateurs';
$string['backupincludemoduleuserdatahelp'] = 'Choisissez si vous désirez inclure dans les sauvegardes automatiques les données utilisateur des modules.';
$string['backupkeephelp'] = 'Combien de sauvegardes de chaque cours désirez-vous conserver (les anciennes seront effacées automatiquement) ?';
$string['backuplogdetailed'] = 'Rapport détaillé des exécutions';
$string['backuploglaststatus'] = 'Rapport de la dernière exécution';
$string['backupmissinguserinfoperms'] = 'Remarque : cette sauvegarde ne contient aucune donnée d\'utilisateur. Les activités Exercice et Atelier ne seront pas incluses dans la sauvegarde, puisque ces modules ne sont pas compatibles avec de type de sauvegarde.';
$string['backupnext'] = 'Prochaine sauvegarde';
$string['backupnonisowarning'] = 'Attention ! Cette sauvegarde provient d\'une version non Unicode de Moodle (antérieure à la version 1.6). Si elle contient des textes en caractères non ISO-8859-1, ceux-ci pourront être ENDOMMAGÉS si vous la restaurez dans cette version Unicode de Moodle. Veuillez consulter la <a href="http://docs.moodle.org/fr/FAQ_de_sauvegarde">FAQ de sauvegarde</a> pour plus d\'informations sur la façon de restaurer correctement cette sauvegarde.';
$string['backupnotyetrun'] = 'Sauvegarde automatique en attente';
$string['backuporiginalname'] = 'Nom de la sauvegarde';
$string['backuproleassignments'] = 'Sauvegarder les attributions de rôles pour ces rôles';
$string['backupsavetohelp'] = 'Chemin d\'accès complet du dossier où vous voulez enregistrer les sauvegardes<br />(laissez vide pour enregistrer dans le dossier par défaut)';
$string['backupsitefileshelp'] = 'Cochez cette option si vous voulez que les fichiers du site utilisés dans les cours soient inclus dans les sauvegardes automatiques';
$string['backuptakealook'] = 'Veuillez consulter les historiques des sauvegardes : {$a}';
$string['backupuserfileshelp'] = 'Choisissez si vous désirez inclure les fichiers des utilisateurs (par exemple l\'image du profil) dans les sauvegardes automatiques';
$string['backupversion'] = 'Version de la sauvegarde';
$string['badges'] = 'Badges';
$string['block'] = 'Bloc';
$string['blockconfiga'] = 'Configuration du bloc « {$a} »';
$string['blockconfigbad'] = 'Ce bloc n\'a pas été implémenté correctement et ne fournit donc pas d\'interface de configuration.';
$string['blocks'] = 'Blocs';
$string['blocksaddedit'] = 'Ajouter/Modifier des blocs';
$string['blockseditoff'] = 'Désactiver l\'édition des blocs';
$string['blocksediton'] = 'Activer l\'édition des blocs';
$string['blocksetup'] = 'Installation des tables de blocs';
$string['blocksuccess'] = 'Les tables {$a} ont été installées correctement';
$string['brief'] = 'Résumé';
$string['bulkactions'] = 'Actions en lots';
$string['bulkactionselect'] = 'Sélection d\'actions en lots pour {$a}';
$string['bulkmovecoursessuccess'] = '{$a->courses} cours déplacés dans {$a->category}';
$string['bycourseorder'] = 'Ordre dans le cours';
$string['byname'] = 'par {$a}';
$string['bypassed'] = 'Court-circuité';
$string['cachecontrols'] = 'Réglages du cache';
$string['cancel'] = 'Annuler';
$string['cancelled'] = 'Annulé';
$string['categories'] = 'Catégories de cours';
$string['categoriesandcoures'] = 'Catégories de cours et cours';
$string['category'] = 'Catégorie';
$string['categoryadded'] = 'La catégorie « {$a} » a été ajoutée';
$string['categorybulkaction'] = 'Actions en lots pour les catégories sélectionnées';
$string['categorycontents'] = 'Sous-catégories et cours';
$string['categorycurrentcontents'] = 'Contenu de {$a}';
$string['categorydeleted'] = 'La catégorie « {$a} » a été supprimée';
$string['categoryduplicate'] = 'Une catégorie de ce nom (« {$a} ») existe déjà';
$string['categorymodifiedcancel'] = 'La catégorie a été modifiée ! Veuillez annuler et essayer encore.';
$string['categoryname'] = 'Nom de catégorie';
$string['categorysubcategoryof'] = '{$a->category} - sous-catégorie de {$a->parentcategory}';
$string['categoryupdated'] = 'La catégorie « {$a} » a été modifiée';
$string['changedpassword'] = 'Mot de passe modifié';
$string['changepassword'] = 'Changer mon mot de passe';
$string['changesmadereallygoaway'] = 'Vous avez effectué des modifications. Voulez-vous vraiment quitter cette page et perdre vos modifications ?';
$string['changessaved'] = 'Modifications enregistrées';
$string['check'] = 'Vérifier';
$string['checkall'] = 'Tout vérifier';
$string['checkingbackup'] = 'Vérification de la sauvegarde';
$string['checkingcourse'] = 'Vérification du cours';
$string['checkingforbbexport'] = 'Vérification pour exportation BlackBoard';
$string['checkinginstances'] = 'Verification des instances';
$string['checkingsections'] = 'Vérification des sections';
$string['checklanguage'] = 'Tester la langue';
$string['checknone'] = 'Ne rien vérifier';
$string['childcoursenotfound'] = 'Le cours descendant n\'a pas été trouvé !';
$string['childcourses'] = 'Cours descendants';
$string['choose'] = 'Choisir';
$string['choosecourse'] = 'Choisir un cours';
$string['choosedots'] = 'Choisir...';
$string['chooselivelogs'] = 'Observer les activités en cours';
$string['chooselogs'] = 'Choisir l\'historique que vous souhaitez consulter';
$string['choosereportfilter'] = 'Choisir un filtre pour le rapport';
$string['choosetheme'] = 'Choisir un thème';
$string['chooseuser'] = 'Choisir un utilisateur';
$string['city'] = 'Ville';
$string['clambroken'] = 'L\'administrateur du site a activé l\'antivirus des fichiers déposés, mais il y a un problème de configuration.<br />Votre fichier n\'a pas pu être déposé. L\'administrateur a été averti afin qu\'il puisse corriger le problème.<br />Essayez de nouveau plus tard !';
$string['clamdeletedfile'] = 'Le fichier a été supprimé';
$string['clamdeletedfilefailed'] = 'Le fichier n\'a pas pu être supprimé';
$string['clamemailsubject'] = '{$a} :: Notification Clam AV';
$string['clamfailed'] = 'Clam AV n\'a pas pu être lancé. Le message d\'erreur était {$a}. Voici la sortie du programme Clam :';
$string['clamlost'] = 'Moodle est configuré pour lancer clam lors du dépôt de fichiers, mais le chemin pointant vers Clam AV, {$a}, n\'est pas correct.';
$string['clamlostandactinglikevirus'] = 'En outre, Moodle est configuré de telle sorte que si clam ne peut pas être lancé, les fichiers sont traités comme des virus. Cela signifie qu\'aucun étudiant ne pourra déposer de fichier tant que ce problème n\'est pas corrigé.';
$string['clammovedfile'] = 'Le fichier a été déplacé dans le dossier de quarantaine que vous avez spécifié. Son nouvel emplacement est {$a}';
$string['clammovedfilebasic'] = 'Le fichier a été déplacé dans un dossier de quarantaine.';
$string['clamquarantinedirfailed'] = 'Impossible de déplacer le fichier dans le dossier de quarantaine spécifié {$a}. Il est impératif de corriger ce problème, car sans cela les fichiers contenant des virus seront détruits.';
$string['clamunknownerror'] = 'Une erreur inconnue est survenue avec clam.';
$string['cleaningtempdata'] = 'Suppression des données temporaires';
$string['clear'] = 'Effacer';
$string['clickhelpiconformoreinfo'] = '... suite ... Cliquer sur l\'icône d\'aide pour lire la totalité de l\'article';
$string['clickhere'] = 'Cliquer ici...';
$string['clicktochangeinbrackets'] = '{$a} (Cliquer pour modifier)';
$string['clicktohideshow'] = 'Cliquer pour déplier ou replier';
$string['closebuttontitle'] = 'Fermer';
$string['closewindow'] = 'Fermer cette fenêtre';
$string['collapse'] = 'Replier';
$string['collapseall'] = 'Tout réduire';
$string['collapsecategory'] = 'Réduire {$a}';
$string['commentincontext'] = 'Chercher ce commentaire dans le contexte';
$string['comments'] = 'Commentaires';
$string['commentsnotenabled'] = 'La fonctionnalité de commentaires n\'est pas activée.';
$string['commentsrequirelogin'] = 'Vous devez être authentifié pour voir les commentaires';
$string['comparelanguage'] = 'Comparer et modifier la langue active';
$string['complete'] = 'Complet';
$string['completereport'] = 'Rapport complet';
$string['configuration'] = 'Configuration';
$string['confirm'] = 'Confirmer';
$string['confirmcheckfull'] = 'Voulez-vous vraiment confirmer {$a} ?';
$string['confirmcoursemove'] = 'Voulez-vous vraiment déplacer ce cours ({$a->course}) dans cette catégorie ({$a->category}) ?';
$string['confirmed'] = 'Votre enregistrement a été confirmé';
$string['confirmednot'] = 'Votre enregistrement n\'a pas encore été confirmé';
$string['content'] = 'Contenu';
$string['continue'] = 'Continuer';
$string['continuetocourse'] = 'Cliquer ici pour accéder à votre cours';
$string['convertingwikitomarkdown'] = 'Conversion du format Wiki au Markdown';
$string['cookiesenabled'] = 'Votre navigateur doit supporter les cookies';
$string['cookiesenabled_help'] = 'Ce site utilise deux cookies.

Un cookie (essentiel) est utilisé pour la session de travail. Il est habituellement appelé <strong>MoodleSession</strong>. Vous devez autoriser son utilisation par le navigateur pour pouvoir ouvrir de nouvelles fenêtres sans avoir à vous reconnecter chaque fois. Le cookie est effacé lorsque vous vous déconnectez ou si vous quittez le navigateur.</p>

L\'autre cookie n\'est pas essentiel, mais rend la connexion à Moodle plus facile en mémorisant votre nom d\'utilisateur dans le navigateur. Vous n\'aurez donc pas à remplir ce champ lors de la prochaine visite. Il porte habituellement le nom <strong>MOODLEID</strong>. Il n\'y a toutefois pas de problème à refuser ce cookie.';
$string['cookiesnotenabled'] = 'La gestion des cookies n\'est malheureusement pas activée actuellement dans votre navigateur';
$string['copy'] = 'copie';
$string['copyasnoun'] = 'copie';
$string['copyingcoursefiles'] = 'Copie des fichiers du cours';
$string['copyingsitefiles'] = 'Copie des fichiers du site utilisés dans les cours';
$string['copyinguserfiles'] = 'Copie des fichiers utilisateurs';
$string['copyingzipfile'] = 'Copie du fichier compacté (zip)';
$string['copyrightnotice'] = 'Copyright';
$string['coresystem'] = 'Système';
$string['cost'] = 'Coût';
$string['costdefault'] = 'Coût par défaut';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Pays';
$string['course'] = 'Cours';
$string['courseadministration'] = 'Administration du cours';
$string['courseapprovedemail'] = 'Le cours que vous avez demandé, {$a->name}, a été approuvé et vous y êtes maintenant {$a->teacher}. Pour accéder à ce nouveau cours, visitez {$a->url}';
$string['courseapprovedemail2'] = 'Le cours que vous avez demandé, {$a->name}, a été approuvé. Pour y accéder, suivez le lien {$a->url}';
$string['courseapprovedfailed'] = 'La création de ce cours comme approuvé a échoué !';
$string['courseapprovedsubject'] = 'Votre cours a été approuvé !';
$string['courseavailable'] = 'Ce cours est ouvert aux étudiants';
$string['courseavailablenot'] = 'Ce cours n\'est pas ouvert aux étudiants';
$string['coursebackup'] = 'Sauvegarde du cours';
$string['coursebulkaction'] = 'Actions en lots pour les cours sélectionnés';
$string['coursecategories'] = 'Catégories de cours';
$string['coursecategory'] = 'Catégorie de cours';
$string['coursecategorydeleted'] = 'Catégorie de cours {$a} supprimée';
$string['coursecategory_help'] = 'Ce réglage détermine la catégorie dans laquelle le cours apparaîtra dans la liste des cours.';
$string['coursecatmanagement'] = 'Gestion des cours et catégories';
$string['coursecompletion'] = 'Achèvement de cours';
$string['coursecompletions'] = 'Achèvements de cours';
$string['coursecreators'] = 'Créateur de cours';
$string['coursecreatorsdescription'] = 'Les créateurs des cours peuvent créer de nouveaux cours.';
$string['coursedeleted'] = 'Cours {$a} supprimé';
$string['coursedisplay'] = 'Mise en page du cours';
$string['coursedisplay_help'] = 'Ce réglage détermine si la totalité du cours est affiché sur une seule page ou sur plusieurs pages.';
$string['coursedisplay_multi'] = 'Afficher une section par page';
$string['coursedisplay_single'] = 'Afficher toutes les sections sur une même page';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Fichiers du cours (obsolète)';
$string['coursefilesedit'] = 'Modifier les fichiers du cours';
$string['coursefileswarning'] = 'Les fichiers du cours sont obsolètes';
$string['coursefileswarning_help'] = 'Les fichiers du cours sont obsolètes à partir de la version 2.0 de Moodle. Veuillez utiliser des dépôts externes autant que faire se peut.';
$string['courseformatdata'] = 'Données du format de cours';
$string['courseformatoptions'] = 'Options du format {$a}';
$string['courseformats'] = 'Formats de cours';
$string['courseformatudpate'] = 'Modifier format';
$string['coursegrades'] = 'Notes du cours';
$string['coursehelpcategory'] = 'Positionne le cours dans la liste des cours et le rend plus simple à trouver pour les étudiants.';
$string['coursehelpforce'] = 'Imposer le type de groupe pour chaque activité du cours.';
$string['coursehelpformat'] = 'La page principale du cours sera affichée dans ce format.';
$string['coursehelphiddensections'] = 'Comment les sections cachées du cours seront affichées pour les étudiants.';
$string['coursehelpmaximumupload'] = 'Définit la taille maximale de chaque fichier pouvant être déposé dans le cours. Le maximum est limité par un réglage analogue au niveau du site.';
$string['coursehelpnewsitemsnumber'] = 'Nombre d\'éléments récents affichés sur la page du cours, dans le bloc des nouveautés. Si 0 est indiqué, le bloc ne sera pas affiché.';
$string['coursehelpnumberweeks'] = 'Nombre de sections du cours (n\'est valable que pour certains formats de cours).';
$string['coursehelpshowgrades'] = 'Active l\'affichage du carnet de note. Ce réglage n\'a pas d\'influence sur l\'affichage des notes dans les diverses activités du cours.';
$string['coursehidden'] = 'Ce cours n\'est actuellement pas disponible pour les étudiants';
$string['courseinfo'] = 'Informations du cours';
$string['courselegacyfiles'] = 'Fichiers du cours (obsolète)';
$string['courselegacyfiles_help'] = 'La zone des fichiers du cours fournit une compatibilité descendante avec Moodle versions 1.9 et antérieures. Tous les fichiers de cette zone sont toujours accessibles par tous les participants du cours, qu\'ils soient liés ou non. Il n\'y a aucun moyen de savoir si ces fichiers sont utilisés dans Moodle.

Si vous utilisez cette zone pour stocker des fichiers, vous risquez de vous exposer à des questions de protection des données et de sécurité, ainsi que des fichiers manquants dans les sauvegardes, lors d\'importations de cours et chaque fois qu\'un contenu est partagé ou réutilisé. Il est donc recommandé de ne pas utiliser cette zone, à moins que vous ne sachiez vraiment ce que vous faites.';
$string['courselegacyfilesofcourse'] = 'Fichiers de cours obsolètes : {$a}';
$string['coursemessage'] = 'Message aux participants du cours';
$string['coursenotaccessible'] = 'Ce cours n\'est pas accessible au public';
$string['courseoverview'] = 'Aperçu du cours';
$string['courseoverviewfiles'] = 'Fichiers de résumé des cours';
$string['courseoverviewfilesext'] = 'Extensions des fichiers de résumé des cours';
$string['courseoverviewfiles_help'] = 'Les fichiers de résumé des cours (habituellement des images) sont affichés dans la liste des cours avec le résumé du cours.';
$string['courseoverviewfileslimit'] = 'Limite du nombre de fichiers de résumé des cours';
$string['courseoverviewgraph'] = 'Graphique de l\'aperçu du cours';
$string['courseprofiles'] = 'Profils de cours';
$string['coursereasonforrejecting'] = 'Vos raisons de rejeter cette demande';
$string['coursereasonforrejectingemail'] = 'Ceci sera envoyé au demandeur';
$string['coursereject'] = 'Rejeter une demande de cours';
$string['courserejected'] = 'La demande de cours a été rejetée et le requérant en a été notifié.';
$string['courserejectemail'] = 'Désolé, le cours que vous avez demandé n\'a pas été créé. Voici la raison pour laquelle votre demande a été rejetée :

{$a}';
$string['courserejectreason'] = 'Résumez vos raisons de rejeter ce cours<br />(ce message sera envoyé au requérant)';
$string['courserejectsubject'] = 'Votre demande d\'ouverture de cours a été rejetée';
$string['coursereport'] = 'Rapport de cours';
$string['coursereports'] = 'Rapports du cours';
$string['courserequest'] = 'Demande de création de cours';
$string['courserequestdetails'] = 'Informations du cours que vous demandez';
$string['courserequestfailed'] = 'Votre demande n\'a pas pu être enregistrée pour une raison inconnue';
$string['courserequestintro'] = 'Utiliser ce formulaire pour demander l\'ouverture d\'un cours pour vous.<br />Veuillez remplir toutes les informations possibles pour permettre aux<br />administrateurs de comprendre les raisons de votre demande.';
$string['courserequestreason'] = 'Pourquoi voulez-vous créer ce cours ?';
$string['courserequestsuccess'] = 'Votre requête a été enregistrée. Vous recevrez prochainement un courriel pour vous informer du résultat de votre demande.';
$string['courserequestsupport'] = 'Informations supplémentaires pour aider l\'administrateur à évaluer cette demande';
$string['courserestore'] = 'Restauration du cours';
$string['courses'] = 'Cours';
$string['coursesectionsummaries'] = 'Résumés des sections de cours';
$string['coursesettings'] = 'Réglages par défaut des cours';
$string['coursesmovedout'] = 'Cours déplacés hors de {$a}';
$string['coursespending'] = 'Cours en attente d\'approbation';
$string['coursestart'] = 'Début du cours';
$string['coursesummary'] = 'Résumé du cours';
$string['coursesummary_help'] = 'Le résumé du cours est affiché sur la liste des cours. Une recherche de cours comprendra le résumé du cours ainsi que le nom du cours.';
$string['courseupdates'] = 'Modifications du cours';
$string['create'] = 'Créer';
$string['createaccount'] = 'Créer mon compte';
$string['createcategory'] = 'Créer catégorie';
$string['createfolder'] = 'Créer un dossier dans {$a}';
$string['createnew'] = 'Nouvelle catégorie';
$string['createnewcategory'] = 'Créer une catégorie';
$string['createnewcourse'] = 'Créer un cours';
$string['createnewsubcategory'] = 'Créer une sous-catégorie';
$string['createsubcategoryof'] = 'Créer une sous-catégorie de {$a}';
$string['createuser'] = 'Créer utilisateur';
$string['createuserandpass'] = 'Créer un compte';
$string['createziparchive'] = 'Créer une archive compactée zip';
$string['creatingblocks'] = 'Création des blocs';
$string['creatingblocksroles'] = 'Création des attributions de rôles et des dérogations pour les blocs';
$string['creatingblogsinfo'] = 'Création des informations des blogs';
$string['creatingcategoriesandquestions'] = 'Création des catégories et des questions';
$string['creatingcoursemodules'] = 'Création des modules de cours';
$string['creatingcourseroles'] = 'Création des attributions de rôles et des dérogations pour les cours';
$string['creatingevents'] = 'Création du calendrier';
$string['creatinggradebook'] = 'Création du carnet de notes';
$string['creatinggroupings'] = 'Création des groupements';
$string['creatinggroupingsgroups'] = 'Ajout des groupes dans les groupements';
$string['creatinggroups'] = 'Création des groupes';
$string['creatinglogentries'] = 'Création des historiques';
$string['creatingmessagesinfo'] = 'Création des informations des messages';
$string['creatingmodroles'] = 'Création des attributions de rôles et des dérogations pour les modules';
$string['creatingnewcourse'] = 'Création d\'un nouveau cours';
$string['creatingrolesdefinitions'] = 'Création des définitions des rôles';
$string['creatingscales'] = 'Création des barèmes';
$string['creatingsections'] = 'Création des sections';
$string['creatingtemporarystructures'] = 'Création des structures temporaires';
$string['creatinguserroles'] = 'Création des attributions de rôles et des dérogations pour les utilisateurs';
$string['creatingusers'] = 'Création des utilisateurs';
$string['creatingxmlfile'] = 'Création du fichier XML';
$string['currency'] = 'Monnaie';
$string['currentcourse'] = 'Cours actuel';
$string['currentcourseadding'] = 'Cours actuel, en y ajoutant les données';
$string['currentcoursedeleting'] = 'Cours actuel, en le supprimant d\'abord';
$string['currentlanguage'] = 'Langue active';
$string['currentlocaltime'] = 'l\'heure à l\'endroit où vous êtes';
$string['currentlyselectedusers'] = 'Utilisateurs actuellement sélectionnés';
$string['currentpicture'] = 'Image actuelle';
$string['currentrelease'] = 'Information sur la version actuelle';
$string['currentversion'] = 'Version actuelle';
$string['databasechecking'] = 'Mise à jour de la base de données Moodle de la version {$a->oldversion} vers la version {$a->newversion}';
$string['databaseperformance'] = 'Performance de la base de données';
$string['databasesetup'] = 'Installation de la base de données';
$string['databasesuccess'] = 'La base de données a été correctement mise à jour';
$string['databaseupgradebackups'] = 'La version du logiciel de sauvegarde est maintenant {$a}';
$string['databaseupgradeblocks'] = 'La version du logiciel des blocs est maintenant {$a}';
$string['databaseupgradegroups'] = 'La version du logiciel des groupes est maintenant {$a}';
$string['databaseupgradelocal'] = 'La version des modifications locales de la base de données est maintenant {$a}';
$string['databaseupgrades'] = 'Mise à jour de la base de données';
$string['date'] = 'Date';
$string['datechanged'] = 'Date de modification';
$string['datemostrecentfirst'] = 'Date - la plus récente en premier';
$string['datemostrecentlast'] = 'Date - la plus récente en dernier';
$string['day'] = 'jour';
$string['days'] = 'jours';
$string['decodinginternallinks'] = 'Décodage des liens internes';
$string['default'] = 'Défaut';
$string['defaultcoursestudent'] = 'Étudiant';
$string['defaultcoursestudentdescription'] = 'Les étudiants ont en général moins de privilèges dans un cours.';
$string['defaultcoursestudents'] = 'Étudiants';
$string['defaultcoursesummary'] = 'Écrire un paragraphe concis et précis qui expose le contenu du cours';
$string['defaultcourseteacher'] = 'Enseignant';
$string['defaultcourseteacherdescription'] = 'Les enseignants peuvent tout faire dans un cours, y compris ajouter et modifier les activités et donner des notes aux étudiants.';
$string['defaultcourseteachers'] = 'Enseignants';
$string['defaulteditor'] = 'Éditeur par défaut';
$string['delete'] = 'Supprimer';
$string['deleteablock'] = 'Supprimer un bloc';
$string['deleteall'] = 'Tout supprimer';
$string['deleteallcannotundo'] = 'Tout supprimer - ne peut pas être annulé';
$string['deleteallcomments'] = 'Supprimer tous les commentaires';
$string['deleteallratings'] = 'Supprimer toutes les évaluations';
$string['deletecategory'] = 'Supprimer la catégorie {$a}';
$string['deletecategorycheck'] = 'Voulez-vous vraiment supprimer la catégorie <strong>« {$a} »</strong>?<br />Tous les cours de cette catégorie seront déplacés la catégorie mère, si elle existe, ou à défaut dans la catégorie Divers.';
$string['deletecategorycheck2'] = 'Si vous supprimez cette catégorie, vous devez choisir que faire avec les cours et sous-catégories qu\'elle contient.';
$string['deletecategoryempty'] = 'Cette catégorie est vide.';
$string['deletecheck'] = 'Supprimer {$a} ?';
$string['deletecheckfiles'] = 'Voulez-vous vraiment supprimer ces fichiers ?';
$string['deletecheckfull'] = 'Voulez-vous vraiment supprimer {$a} ?';
$string['deletechecktype'] = 'Voulez-vous vraiment supprimer ce {$a->type} ?';
$string['deletechecktypename'] = 'Voulez-vous vraiment supprimer le {$a->type} « {$a->name} »?';
$string['deletecheckwarning'] = 'Vous allez supprimer ces fichiers';
$string['deletecomment'] = 'Supprimer ce commentaire';
$string['deletecompletely'] = 'Supprimer entièrement';
$string['deletecourse'] = 'Supprimer un cours';
$string['deletecoursecheck'] = 'Voulez-vous vraiment supprimer ce cours ainsi que toutes les données qu\'il contient ?';
$string['deleted'] = 'Supprimé';
$string['deletedactivity'] = '{$a} supprimé';
$string['deletedcourse'] = '{$a} a été entièrement supprimé';
$string['deletednot'] = 'Impossible de supprimer {$a} !';
$string['deletelogs'] = 'Supprimer les historiques';
$string['deleteselected'] = 'Supprimer les éléments sélectionnés';
$string['deleteselectedkey'] = 'Supprimer la clef sélectionnée';
$string['deletingcourse'] = 'Suppression de {$a}';
$string['deletingexistingcoursedata'] = 'Suppression des données d\'un cours existant';
$string['deletingolddata'] = 'Suppression des anciennes données';
$string['department'] = 'Département';
$string['desc'] = 'Descendant';
$string['description'] = 'Description';
$string['deselectall'] = 'Annuler la sélection';
$string['detailedless'] = 'Moins de détails';
$string['detailedmore'] = 'Plus de détails';
$string['directory'] = 'Dossier';
$string['disable'] = 'Désactiver';
$string['disabledcomments'] = 'Les commentaires sont désactivés';
$string['displayingfirst'] = 'Seules les {$a->count} premier(ère)s {$a->things} sont affiché(e)s';
$string['displayingrecords'] = '{$a} enregistrements affichés';
$string['displayingusers'] = 'Affichage des utilisateurs de {$a->start} à {$a->end}';
$string['displayonpage'] = 'Affichage sur la page';
$string['dndcourse'] = 'Vous pouvez glisser-déplacer ce cours pour modifier son ordre de tri ou le déplacer dans une autre catégorie';
$string['dndenabled_inbox'] = 'Vous pouvez glisser des fichiers ici pour les ajouter.';
$string['dndnotsupported'] = 'Le dépôt de fichiers par glisser-déposer n\'est pas supporté.';
$string['dndnotsupported_help'] = 'Votre navigateur ne supporte pas le dépôt de fichiers par glisser-déposer.<br />Cette fonctionnalité est disponibles dans les versions récentes de Chrome, Firefox et Safari, ainsi que dans Internet Explorer 10 et versions ultérieures.';
$string['dndnotsupported_insentence'] = 'Glisser-déposer non supporté';
$string['dnduploadwithoutcontent'] = 'Ce fichier n\'a pas de contenu';
$string['dndworkingfile'] = 'Glisser et déposer des fichiers pour les placer dans les sections du cours';
$string['dndworkingfilelink'] = 'Glisser et déposer des fichiers ou des liens pour les déposer dans les sections du cours';
$string['dndworkingfiletext'] = 'Glisser et déposer des fichiers ou des textes pour les déposer dans les sections du cours';
$string['dndworkingfiletextlink'] = 'Glisser et déposer des fichiers, des textes ou des liens pour les déposer dans les sections du cours';
$string['dndworkinglink'] = 'Glisser et déposer des liens pour les déposer dans les sections du cours';
$string['dndworkingtext'] = 'Glisser et déposer des textes pour les déposer dans les sections du cours';
$string['dndworkingtextlink'] = 'Glisser et déposer des textes ou des liens pour les déposer dans les sections du cours';
$string['documentation'] = 'Documentation de Moodle';
$string['dontsortcategories'] = 'Ne pas trier les catégories';
$string['dontsortcourses'] = 'Ne pas trier les cours';
$string['down'] = 'Vers le bas';
$string['download'] = 'Télécharger';
$string['downloadall'] = 'Tout télécharger';
$string['downloadexcel'] = 'Télécharger en format Excel';
$string['downloadfile'] = 'Télécharger le fichier';
$string['downloadods'] = 'Télécharger en format ODS';
$string['downloadtext'] = 'Télécharger en format texte';
$string['doyouagree'] = 'Avez-vous lu et compris ces conditions ?';
$string['droptoupload'] = 'Lâcher les fichiers ici pour les envoyer';
$string['duplicate'] = 'Dupliquer';
$string['duplicateconfirm'] = 'Voulez-vous vraiment dupliquer {$a->modtype} « {$a->modname} »?';
$string['duplicatecontcourse'] = 'Retour au cours';
$string['duplicatecontedit'] = 'Modifier la copie créée';
$string['duplicatesuccess'] = '{$a->modtype} « {$a->modname} » a été dupliqué correctement';
$string['duplicatinga'] = 'Duplication de {$a}';
$string['edhelpaspellpath'] = 'Pour utiliser le correcteur orthographique dans l\'éditeur WYSIWYG, le logiciel <strong>aspell</strong> version <strong>0.50</strong> ou ultérieure doit être installé sur le serveur, et son chemin d\'accès doit être configuré correctement. Sur les systèmes Unix/Linux, ce chemin d\'accès est en règle générale <strong>/usr/bin/aspell</strong>.';
$string['edhelpbgcolor'] = 'Couleur de fond de l\'éditeur.<br />Des valeurs correctes sont par exemple : #ffffff ou white';
$string['edhelpcleanword'] = 'Ce réglage permet l\'activation du filtre spécifique au format Word.';
$string['edhelpenablespelling'] = 'Activation du correcteur orthographique. S\'il est activé, le programme <strong>aspell</strong> doit être installé sur le serveur. La seconde valeur est le <strong>dictionnaire par défaut</strong>. Cette valeur sera utilisée si aspell n\'a pas de dictionnaire pour la langue de l\'utilisateur.';
$string['edhelpfontfamily'] = 'Police ou famille de polices utilisée par défaut dans l\'éditeur. Les noms doivent être séparés par des virgules.';
$string['edhelpfontlist'] = 'Définition des polices disponible dans le menu de l\'éditeur.';
$string['edhelpfontsize'] = 'Corps par défaut (taille de la police) utilisé dans l\'éditeur.<br />Des valeurs correctes sont par exemple : medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Modifier';
$string['edita'] = 'Modifier {$a}';
$string['editcategorysettings'] = 'Modifier les paramètres de la catégorie';
$string['editcategorythis'] = 'Modifier cette catégorie';
$string['editcoursesettings'] = 'Modifier les paramètres du cours';
$string['editfiles'] = 'Modifier les fichiers';
$string['editgroupprofile'] = 'Modifier le profil du groupe';
$string['editinga'] = 'Modification {$a}';
$string['editingteachershort'] = 'Éditeur';
$string['editlock'] = 'Cette valeur ne peut pas être modifiée !';
$string['editmyprofile'] = 'Modifier mon profil';
$string['editorbgcolor'] = 'Couleur de fond';
$string['editorcleanonpaste'] = 'Nettoyage du HTML de Word lors du collage';
$string['editorcommonsettings'] = 'Réglages habituels';
$string['editordefaultfont'] = 'Police par défaut';
$string['editorenablespelling'] = 'Activer le correcteur orthographique';
$string['editorfontlist'] = 'Liste des polices';
$string['editorfontsize'] = 'Corps par défaut';
$string['editorresettodefaults'] = 'Rétablir les valeurs par défaut de l\'éditeur';
$string['editorsettings'] = 'Éditeur WYSIWYG';
$string['editorshortcutkeys'] = 'Raccourcis clavier éditeur';
$string['editsettings'] = 'Paramètres';
$string['editsummary'] = 'Modifier le résumé';
$string['editthisactivity'] = 'Modifier cette activité';
$string['editthiscategory'] = 'Modifier cette catégorie de cours';
$string['edittitle'] = 'Modifier le titre';
$string['edittitleinstructions'] = 'Esc pour annuler, Entrée pour terminer';
$string['edituser'] = 'Comptes des utilisateurs';
$string['email'] = 'Adresse de courriel';
$string['emailactive'] = 'Adresse de courriel activée';
$string['emailagain'] = 'Courriel (confirmation)';
$string['emailalreadysent'] = 'Un message de réinitialisation du mot de passe a déjà été envoyé. Veuillez consulter votre boîte de courriel.';
$string['emailcharset'] = 'Encodage des courriels';
$string['emailconfirm'] = 'Confirmer votre enregistrement';
$string['emailconfirmation'] = 'Bonjour,

La création d\'un compte pour {$a->sitename} a été demandée en utilisant votre adresse de courriel. Pour confirmer votre enregistrement, veuillez visiter la page web suivante :

    {$a->link}

Dans la plupart des logiciels de courriel, cette adresse est un lien actif qu\'il vous suffit de cliquer. Si cela ne fonctionne pas, copiez ce lien (qui peut être coupé sur deux lignes) et collez-le dans la barre d\'adresse de votre navigateur web.

Si vous avez besoin d\'aide, veuillez contacter l\'administrateur du site.
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a} : confirmation de l\'ouverture du compte';
$string['emailconfirmsent'] = '<p>Un message vous a été envoyé à l\'adresse de courriel <strong>{$a}</strong>.</p><p>Il contient les instructions pour terminer votre enregistrement.</p><p>Si vous rencontrez des difficultés, veuillez contacter l\'administrateur du site.</p>';
$string['emaildigest'] = 'Forme du courriel quotidien';
$string['emaildigestcomplete'] = 'Complet (courriel quotidien avec l\'intégralité des messages)';
$string['emaildigest_help'] = 'Le type de notification que les forums utiliseront par défaut pour le courriel quotidien.

* Pas de courriel quotidien – vous ne recevrez pas de courriel quotidien.
* Messages complets – vous recevrez un courriel quotidien contenant la totalité du contenu de chaque message de forum.
* Objets seulement – vous recevrez un courriel quotidien ne contenant que l\'objet de chaque message de forum.

Ce réglage peut être modifié au besoin pour chaque forum.';
$string['emaildigestoff'] = 'Pas de courriel quotidien (un courriel par message)';
$string['emaildigestsubjects'] = 'Objets (courriel quotidien avec les objets des messages uniquement)';
$string['emaildisable'] = 'Cette adresse de courriel est désactivée';
$string['emaildisableclick'] = 'Cliquez ici pour désactiver l\'envoi de courriels à cette adresse';
$string['emaildisplay'] = 'Affichage de l\'adresse de courriel';
$string['emaildisplaycourse'] = 'Seuls les membres du cours sont autorisés à voir mon adresse de courriel';
$string['emaildisplayhidden'] = 'Adresse de courriel cachée';
$string['emaildisplayno'] = 'Cacher à tous mon adresse de courriel';
$string['emaildisplayyes'] = 'Autoriser tout le monde à voir mon adresse de courriel';
$string['emailenable'] = 'Cette adresse de courriel est activée';
$string['emailenableclick'] = 'Cliquez ici pour ré-activer l\'envoi de courriels à cette adresse';
$string['emailexists'] = 'Cette adresse est déjà enregistrée.';
$string['emailformat'] = 'Format des courriels';
$string['emailmustbereal'] = 'Remarque : votre adresse de courriel doit être valide';
$string['emailnotallowed'] = 'Les adresses de courriel de ce domaine ne sont pas autorisées ({$a})';
$string['emailnotfound'] = 'Cette adresse de courriel n\'a pas été trouvée dans la base de données';
$string['emailonlyallowed'] = 'Cette adresse de courriel ne fait pas partie de celles qui sont autorisées ({$a})';
$string['emailpasswordchangeinfo'] = 'Bonjour,

Quelqu\'un (probablement vous) a demandé un nouveau mot de passe pour votre compte sur « {$a->sitename} ».

Pour modifier votre mot de passe, visitez la page web suivante :

{$a->link}

Dans la plupart des logiciels de messagerie, cette adresse devrait apparaître comme un lien de couleur bleue qu\'il vous suffit de cliquer. Si cela ne fonctionne pas, copiez ce lien et collez-le dans la barre d\'adresse de votre navigateur web.

Si vous avez besoin d\'aide, veuillez contacter l\'administrateur du site, {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Bonjour,

Quelqu\'un (probablement vous) a demandé un nouveau mot de passe pour votre compte sur « {$a->sitename} ».

Malheureusement, votre compte sur ce site est désactivé et ne peut pas être réinitialisé.  Veuillez contacter l\'administrateur du site, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Bonjour,

Quelqu\'un (probablement vous) a demandé un nouveau mot de passe pour votre compte sur « {$a->sitename} ».

Malheureusement, les mots de passe ne peuvent pas être modifiés ainsi sur ce site. Veuillez contacter l\'administrateur du site, {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a} : information sur le changement de mot de passe';
$string['emailpasswordconfirmation'] = 'Bonjour,

Quelqu\'un (probablement vous) a demandé un nouveau mot de passe pour votre compte sur « {$a->sitename} ».

Pour confirmer cette demande et recevoir votre nouveau mot de passe par courriel, visitez la page web suivante :

{$a->link}

Dans la plupart des logiciels de messagerie, cette adresse devrait apparaître comme un lien de couleur bleue qu\'il vous suffit de cliquer. Si cela ne fonctionne pas, copiez ce lien et collez-le dans la barre d\'adresse de votre navigateur web.

Si vous avez besoin d\'aide, veuillez contacter l\'administrateur du site, {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a} : confirmation du changement de mot de passe';
$string['emailpasswordconfirmmaybesent'] = '<p>Si vous avez fourni un nom d\'utilisateur ou une adresse de courriel corrects, un message vous a été envoyé par courriel.</p> <p>Ce message contient de simples instructions pour confirmer et terminer cette procédure de modification de mot de passe. Si vous n\'arrivez toujours pas à vous connecter, veuillez contacter l\'administrateur du site.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Le compte utilisateur indiqué n\'a pas d\'adresse de courriel.</p>
<p>Veuillez contacter l\'administrateur du site.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Les informations fournies ne correspondent pas à un compte utilisateur existant.</p>
<p>Veuillez vérifier les informations saisies et essayer à nouveau. Si cela ne fonctionne toujours pas, veuillez contacter l\'administrateur du site.</p>';
$string['emailpasswordconfirmsent'] = '<p>Un message a été envoyé à votre adresse de courriel <strong>{$a}</strong>.</p><p>Ce message décrit la marche à suivre pour confirmer et terminer le changement de mot de passe.</p><p>En cas de difficulté, veuillez contacter l\'administrateur du site.</p>';
$string['emailpasswordsent'] = '<p>Merci pour votre confirmation de changement de mot de passe.</p><p>Un message avec votre nouveau mot de passe a été envoyé à votre adresse <strong>{$a->email}</strong>.</p><p>Le nouveau mot de passe a été généré automatiquement. Vous pouvez <a href="{$a->link}">le modifier</a> pour le rendre plus facile à mémoriser.</p>';
$string['emailresetconfirmation'] = 'Bonjour {$a->firstname},

Une demande de réinitialisation de mot de passe a été demandée pour votre compte utilisateur « {$a->username} » sur {$a->sitename}.

Pour confirmer cette demande et définir un nouveau mot de passe, veuillez cliquer sur le lien ci-dessous :

{$a->link}
(ce lien est valable durant {$a->resetminutes} minutes à partir de la demande de réinitialisation)

Si cette demande de réinitialisation n\'a pas été effectuée par vous-même, aucune action n\'est nécessaire et vous pouvez ignorer ce message.

Si vous avez besoin d\'aide, veuillez contacter l\'administrateur du site,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a} : demande de réinitialisation de mot de passe';
$string['emailresetconfirmsent'] = 'Un courriel vous a été envoyé à l\'adresse <b>{$a}</b>.<br />Il contient des instructions simple vous permettant de confirmer et d\'effectuer le changement de votre mot de passe.
En cas de difficulté, veuillez contacter l\'administrateur du site.';
$string['emptydragdropregion'] = 'région vide';
$string['enable'] = 'Activer';
$string['encryptedcode'] = 'Code chiffré';
$string['english'] = 'Anglais';
$string['enrolmentmethods'] = 'Méthodes d\'inscription';
$string['entercourse'] = 'Cliquer pour entrer dans le cours';
$string['enteremail'] = 'Tapez votre adresse de courriel';
$string['enteremailaddress'] = 'Tapez votre adresse de courriel afin qu\'un nouveau mot de passe vous soit envoyé par courriel';
$string['enterusername'] = 'Tapez votre nom d\'utilisateur';
$string['entries'] = 'Article';
$string['error'] = 'Erreur';
$string['errorcreatingactivity'] = 'Impossible de créer une instance de l\'activité « {$a} »';
$string['errorfiletoobig'] = 'La taille du fichier dépasse la limite de {$a} octets';
$string['errornouploadrepo'] = 'Aucun dépôt n\'est défini pour déposer des fichiers dans ce site';
$string['errorwhenconfirming'] = 'Votre compte n\'a pas pu être confirmé en raison d\'une erreur. Si vous avez cliqué sur un lien dans un courriel pour parvenir à cette page, assurez-vous que la ligne de ce message n\'a pas été coupée. Il vous sera peut-être nécessaire de couper et coller pour reconstruire correctement le lien.';
$string['eventcontentviewed'] = 'Contenu consulté';
$string['eventcoursecategorydeleted'] = 'Catégorie supprimée';
$string['eventcoursecontentdeleted'] = 'Contenu de cours supprimé';
$string['eventcoursecreated'] = 'Cours créé';
$string['eventcoursedeleted'] = 'Cours supprimé';
$string['eventcoursemodulecreated'] = 'Module de cours créé';
$string['eventcoursemoduledeleted'] = 'Module de cours supprimé';
$string['eventcoursemoduleupdated'] = 'Module de cours modifié';
$string['eventcourseresetended'] = 'Réinitialisation de cours terminée';
$string['eventcourseresetstarted'] = 'Réinitialisation de cours commencée';
$string['eventcourserestored'] = 'Cours restauré';
$string['eventcoursesectionupdated'] = 'Section de cours modifiée';
$string['eventcourseupdated'] = 'Cours modifié';
$string['eventusercreated'] = 'Utilisateur créé';
$string['eventuserdeleted'] = 'Utilisateur supprimé';
$string['eventuserlistviewed'] = 'Liste d\'utilisateurs consultée';
$string['eventuserloggedout'] = 'Utilisateur déconnecté';
$string['eventuserprofileviewed'] = 'Profil utilisateur consulté';
$string['eventuserupdated'] = 'Utilisateur modifié';
$string['everybody'] = 'Tout le monde';
$string['executeat'] = 'Lancer à';
$string['existing'] = 'Existant';
$string['existingadmins'] = 'Administrateurs existants';
$string['existingcourse'] = 'Cours existant';
$string['existingcourseadding'] = 'Cours existant, en y ajoutant les données';
$string['existingcoursedeleting'] = 'Cours existant, en le supprimant d\'abord';
$string['existingcreators'] = 'Créateurs de cours existants';
$string['existingstudents'] = 'Étudiants inscrits';
$string['existingteachers'] = 'Enseignants existants';
$string['expand'] = 'Déplier';
$string['expandall'] = 'Tout déplier';
$string['expandcategory'] = 'Déplier {$a}';
$string['explanation'] = 'Explication';
$string['extendenrol'] = 'Étendre la période d\'inscription (individuelle)';
$string['extendperiod'] = 'Extension de la période d\'inscription';
$string['failedloginattempts'] = '{$a->attempts} tentatives de connexion depuis votre dernière connexion';
$string['failedloginattemptsall'] = '{$a->attempts} tentatives de connexion pour {$a->accounts} comptes';
$string['feedback'] = 'Feedback';
$string['file'] = 'Fichier';
$string['fileexists'] = 'Un fichier de nom {$a} existe déjà';
$string['filemissing'] = '{$a} n\'existe pas';
$string['files'] = 'Fichiers';
$string['filesanduploads'] = 'Fichiers et dépôts';
$string['filesfolders'] = 'Fichiers/dossiers';
$string['filetoolarge'] = 'est trop gros pour être déposé';
$string['fileuploadwithcontent'] = 'Lors du dépôt d\'un fichier, le paramètre content ne doit pas être inclus';
$string['filloutallfields'] = 'Merci de remplir tous les champs de ce formulaire';
$string['filter'] = 'Filtre';
$string['findmorecourses'] = 'Rechercher d\'autres cours...';
$string['first'] = 'Premier';
$string['firstaccess'] = 'Premier accès';
$string['firstname'] = 'Prénom';
$string['firstnamephonetic'] = 'Prénom – phonétique';
$string['firstsiteaccess'] = 'Premier accès au site';
$string['firsttime'] = 'Première visite sur ce site ?';
$string['folder'] = 'Dossier';
$string['folderclosed'] = 'Dossier fermé';
$string['folderopened'] = 'Dossier ouvert';
$string['followingoptional'] = 'Les éléments suivants sont facultatifs';
$string['followingrequired'] = 'Les éléments suivants sont requis';
$string['for'] = 'Pour';
$string['force'] = 'Imposer';
$string['forcelanguage'] = 'Imposer la langue';
$string['forceno'] = 'Ne pas imposer';
$string['forcepasswordchange'] = 'Imposer le changement du mot de passe';
$string['forcepasswordchangecheckfull'] = 'Voulez-vous vraiment imposer un changement de mot de passe à {$a} ?';
$string['forcepasswordchange_help'] = 'Si ce réglage est activé, l\'utilisateur sera invité à changer son mot de passe lors de la connexion suivante.';
$string['forcepasswordchangenot'] = 'Impossible d\'imposer un changement de mot de passe à {$a}';
$string['forcepasswordchangenotice'] = 'Vous devez changer votre mot de passe pour continuer.';
$string['forcetheme'] = 'Imposer le thème';
$string['forgotaccount'] = 'Mot de passe perdu ?';
$string['forgotten'] = 'Vous avez oublié votre nom d\'utilisateur et/ou votre mot de passe ?';
$string['forgottenduplicate'] = 'Cette adresse de courriel est utilisée dans plusieurs comptes. Veuillez indiquer le nom d\'utilisateur en lieu et place';
$string['forgotteninvalidurl'] = 'URL de récupération de mot de passe non valable';
$string['format'] = 'Format';
$string['format_help'] = 'Le format de cours détermine comment est affichée la page de cours.

* Format activité unique - une activité ou une ressource unique (comme par exemple un test ou un paquetage SCORM) est affichée sur la page de cours.
* Format informel – un forum public est affiché sur la page de cours.
* Format thématique – la page de cours est organisée en sections thématiques.
* Format hebdomadaire – la page de cours est organisée en sections hebdomadaires, la première d\'entre elle commençant à la date de début du cours.';
$string['formathtml'] = 'Format HTML';
$string['formatmarkdown'] = 'Format Markdown';
$string['formatplain'] = 'Format texte';
$string['formattext'] = 'Format Moodle';
$string['formattexttype'] = 'Mise au format';
$string['framesetinfo'] = 'Ce jeu de cadres contient :';
$string['from'] = 'De';
$string['frontpagecategorycombo'] = 'Liste combinée';
$string['frontpagecategorynames'] = 'Liste des catégories de cours';
$string['frontpagecourselist'] = 'Liste des cours';
$string['frontpagecoursesearch'] = 'Zone de recherche de cours';
$string['frontpagedescription'] = 'Résumé sur la page d\'accueil';
$string['frontpagedescriptionhelp'] = 'Ce résumé sera affiché sur la page d\'accueil dans le bloc résumé du cours/du site ou en ajouter une section thématique sur la page d\'accueil.';
$string['frontpageenrolledcourselist'] = 'Cours de l\'utilisateur';
$string['frontpageformat'] = 'Format de la page d\'accueil';
$string['frontpageformatloggedin'] = 'Format une fois connecté';
$string['frontpagenews'] = 'Brèves';
$string['frontpagesettings'] = 'Réglages page d\'accueil';
$string['fulllistofcourses'] = 'Tous les cours';
$string['fullname'] = 'Nom complet';
$string['fullnamecourse'] = 'Nom complet du cours';
$string['fullnamecourse_help'] = 'Le nom complet du cours est affiché en haut de chacune des pages du cours et sur la liste des cours.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nom complet';
$string['fullprofile'] = 'Profil complet';
$string['fullsitename'] = 'Nom complet du site';
$string['functiondisabled'] = 'Cette fonction est actuellement désactivée';
$string['general'] = 'Général';
$string['geolocation'] = 'latitude - longitude';
$string['gettheselogs'] = 'Télécharger ces historiques';
$string['go'] = 'Valider';
$string['gpl'] = 'Copyright (C) 1999 et années ultérieures, Martin Dougiamas (http://moodle.com/).

Ce programme est libre, vous pouvez le redistribuer et/ou le modifier selon les termes de la Licence Publique Générale GNU publiée par la Free Software Foundation (version 2 ou bien toute autre version
ultérieure choisie par vous).

Ce programme est distribué car potentiellement utile, mais SANS AUCUNE GARANTIE : sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.

Pour plus de détails, reportez-vous à la page d\'information sur la Licence Moodle : http://docs.moodle.org/fr/Licence';
$string['gpl3'] = 'Copyright (C) 1999 et années ultérieures, Martin Dougiamas (http://moodle.com/)

Ce programme est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes de la “GNU General Public License” telle que publiée par la Free Software Foundation : soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.

Ce programme est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE : sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.

Pour plus de détails, reportez-vous à la page d\'information sur la Licence Moodle : http://docs.moodle.org/fr/Licence';
$string['gpllicense'] = 'Licence GPL';
$string['grade'] = 'Note';
$string['grades'] = 'Notes';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/"> Gravatar</a> a été activé sur ce site. Si vous ne déposez pas d\'image de profil, Moodle essaiera d\'afficher pour vous un avatar à partir de Gravatar.';
$string['group'] = 'Groupe';
$string['groupadd'] = 'Ajouter un nouveau groupe';
$string['groupaddusers'] = 'Ajouter les utilisateurs sélectionnés au groupe';
$string['groupextendenrol'] = 'Étendre la période d\'inscription (commune)';
$string['groupfor'] = 'pour le groupe';
$string['groupinfo'] = 'Information sur le groupe sélectionné';
$string['groupinfoedit'] = 'Modifier les réglages du groupe';
$string['groupinfomembers'] = 'Information sur les membres sélectionnés';
$string['groupinfopeople'] = 'Information sur les personnes sélectionnées';
$string['groupmembers'] = 'Membres du groupe';
$string['groupmemberssee'] = 'Afficher les membres du groupe';
$string['groupmembersselected'] = 'Membres du groupe sélectionné';
$string['groupmode'] = 'Type des groupes';
$string['groupmodeforce'] = 'Imposer le type des groupes';
$string['groupmy'] = 'Mon groupe';
$string['groupnonmembers'] = 'Personnes n\'appartenant à aucun groupe';
$string['groupnotamember'] = 'Désolé, vous n\'êtes pas membre de ce groupe';
$string['grouprandomassign'] = 'Inscrire aléatoirement tout le monde aux groupes';
$string['groupremove'] = 'Supprimer le groupe sélectionné';
$string['groupremovemembers'] = 'Retirer du groupe les membres sélectionnés';
$string['groups'] = 'Groupes';
$string['groupsnone'] = 'Aucun groupe';
$string['groupsseparate'] = 'Groupes séparés';
$string['groupsvisible'] = 'Groupes visibles';
$string['guest'] = 'Visiteur anonyme';
$string['guestdescription'] = 'Les visiteurs anonymes ont très peu de privilèges et ne peuvent normalement saisir de texte à aucun endroit.';
$string['guestskey'] = 'Autoriser l\'accès anonyme avec clef';
$string['guestsno'] = 'Ne pas autoriser l\'accès anonyme';
$string['guestsnotallowed'] = 'Désolé, le cours « {$a} » n\'autorise pas l\'accès anonyme.';
$string['guestsyes'] = 'Autoriser l\'accès anonyme sans clef';
$string['guestuser'] = 'Visiteur anonyme';
$string['guestuserinfo'] = 'Cet utilisateur spécial a accès en lecture seule à certains cours.';
$string['help'] = 'Aide';
$string['helpprefix2'] = 'Aide sur {$a}';
$string['helpwiththis'] = 'Aide sur ceci';
$string['hiddenassign'] = 'Attribution cachée';
$string['hiddenfromstudents'] = 'Caché pour les participants';
$string['hiddensections'] = 'Sections cachées';
$string['hiddensectionscollapsed'] = 'Sections cachées affichées sous forme condensée';
$string['hiddensections_help'] = 'Ce réglage détermine si les sections cachées de votre cours sont affichées sous forme condensée (par exemple en format hebdomadaire pour indiquer clairement les semaines où le cours n\'a pas lieu) ou si elles sont complètement invisibles.';
$string['hiddensectionsinvisible'] = 'Sections cachées invisibles';
$string['hide'] = 'Cacher';
$string['hideadvancedsettings'] = 'Cacher les réglages avancés';
$string['hidepicture'] = 'Cacher l\'image';
$string['hidesection'] = 'Cacher section {$a}';
$string['hidesettings'] = 'Cacher les réglages';
$string['hideshowblocks'] = 'Cacher ou afficher les blocs';
$string['hits'] = 'Requêtes';
$string['hitsoncourse'] = 'Nombre de requêtes de {$a->username} sur {$a->coursename}';
$string['hitsoncoursetoday'] = 'Nombre de requêtes de {$a->username} sur {$a->coursename} pour aujourd\'hui';
$string['home'] = 'Accueil';
$string['hour'] = 'heure';
$string['hours'] = 'heures';
$string['howtomakethemes'] = 'Comment créer de nouveaux thèmes';
$string['htmleditor'] = 'Utiliser l\'éditeur WYSIWYG';
$string['htmleditoravailable'] = 'L\'éditeur WYSIWYG est disponible';
$string['htmleditordisabled'] = 'Vous avez désactivé l\'utilisation de l\'éditeur WYSIWYG dans votre profil utilisateur';
$string['htmleditordisabledadmin'] = 'L\'administrateur a désactivé l\'utilisation de l\'éditeur WYSIWYG sur ce site';
$string['htmleditordisabledbrowser'] = 'L\'éditeur WYSIWYG n\'est pas disponible car vous n\'utilisez pas un navigateur compatible';
$string['htmlfilesonly'] = 'Fichiers HTML seulement';
$string['htmlformat'] = 'Format HTML';
$string['icon'] = 'Icône';
$string['icqnumber'] = 'Identifiant ICQ';
$string['idnumber'] = 'Numéro d\'identification';
$string['idnumbercourse'] = 'N° d\'identification du cours';
$string['idnumbercoursecategory'] = 'Numéro d\'identifiant de catégorie';
$string['idnumbercoursecategory_help'] = 'L\'identifiant de catégorie de cours n\'est utilisé que lors de la vérification de correspondance avec des systèmes externes et n\'est affiché nulle part sur le site. Si la catégorie est codée de manière officielle, celui-ce devrait être renseigné ici. Sinon, le champ peut être laissé vide.';
$string['idnumbercourse_help'] = 'Le numéro d\'identification (ID) du cours n\'est utilisé que lorsque les cours sont mis en relation avec des systèmes externes. Il n\'est jamais affiché nulle part. Si vous avez un numéro de code officiel pour ce cours, utilisez-le. Sinon, vous pouvez laisser ce champ vide.';
$string['idnumbergroup'] = 'Identifiant de groupe';
$string['idnumbergroup_help'] = 'L\'identifiant d\'un groupe n\'est utilisé que lors de l\'utilisation de systèmes externes et n\'est jamais affiché. On renseigne ce champ si le groupe a un code officiel. Sinon, le champ peut être laissé vide.';
$string['idnumbergrouping'] = 'Identifiant de groupement';
$string['idnumbergrouping_help'] = 'L\'identifiant d\'un groupement n\'est utilisé que lors de l\'utilisation de systèmes externes et n\'est jamais affiché. On renseigne ce champ si le groupement a un code officiel. Sinon, le champ peut être laissé vide.';
$string['idnumbermod'] = 'Numéro d\'identification';
$string['idnumbermod_help'] = 'En définissant un numéro d\'identification (ID number), vous fournissez un moyen d\'identifier une activité, si vous voulez effectuer des calculs avec les notes. Si l\'activité n\'est utilisée dans aucun calcul de note, le numéro d\'identification peut être laissé vide.

Ce numéro d\'identification peut aussi être renseigné dans le carnet de notes. Il ne peut cependant être modifié que sur la page de modification de l\'activité.';
$string['idnumbertaken'] = 'Ce n° d\'identification est déjà utilisé';
$string['imagealt'] = 'Description de l\'image';
$string['import'] = 'Importation';
$string['importdata'] = 'Importer les données d\'un cours';
$string['importdataexported'] = 'Les données du cours d\'origine ont été exportées correctement.<br />Voulez-vous les importer dans le cours de destination ?';
$string['importdatafinished'] = 'Importation terminée ! Vous pouvez vous rendre sur votre cours';
$string['importdatafrom'] = 'Rechercher un cours à partir duquel importer des données :';
$string['inactive'] = 'Inactif';
$string['include'] = 'Inclure';
$string['includeallusers'] = 'Inclure tous les utilisateurs';
$string['includecoursefiles'] = 'Inclure les fichiers du cours';
$string['includecourseusers'] = 'Inclure les utilisateurs du cours';
$string['included'] = 'Inclus';
$string['includelogentries'] = 'Inclure les historiques';
$string['includemodules'] = 'Inclure les modules';
$string['includemoduleuserdata'] = 'Inclure les données utilisateur des modules';
$string['includeneededusers'] = 'Inclure les utilisateurs s\'il y a lieu';
$string['includenoneusers'] = 'Ne pas inclure les utilisateurs';
$string['includeroleassignments'] = 'Inclure les attributions de rôles';
$string['includesitefiles'] = 'Inclure les fichiers du site utilisés dans ce cours';
$string['includeuserfiles'] = 'Inclure les fichiers des utilisateurs';
$string['increasesections'] = 'Augmenter le nombre des sections';
$string['info'] = 'Information';
$string['institution'] = 'Institution';
$string['instudentview'] = 'en affichage « étudiant »';
$string['interests'] = 'Centres d\'intérêt';
$string['interestslist'] = 'Liste des centres d\'intérêt';
$string['interestslist_help'] = 'Veuillez saisir ici la liste de vos centres d\'intérêt, séparés par des virgules. Vos centres d\'intérêt sont affichés sur votre page de profil.';
$string['invalidemail'] = 'Adresse de courriel incorrecte';
$string['invalidlogin'] = 'La connexion a échoué, veuillez réessayer';
$string['invalidusername'] = 'Le nom d\'utilisateur ne peut comporter que des lettre bas de casse, les caractères souligné (_), tiret (-), point (.) ou arobase (@).';
$string['invalidusernameupload'] = 'Nom d\'utilisateur non valide';
$string['ip_address'] = 'Adresse IP';
$string['jump'] = 'Sauter';
$string['jumpto'] = 'Aller à...';
$string['keep'] = 'Conserver';
$string['keepsearching'] = 'Continuer à chercher';
$string['langltr'] = 'La langue est écrite de gauche à droite';
$string['langrtl'] = 'La langue est écrite de droite à gauche';
$string['language'] = 'Langue';
$string['languagegood'] = 'Le paquetage de langue est à jour ! :-)<br />Merci à tous les contributeurs !';
$string['last'] = 'Dernier';
$string['lastaccess'] = 'Dernier accès';
$string['lastcourseaccess'] = 'Dernier accès au cours';
$string['lastedited'] = 'Modifié le';
$string['lastlogin'] = 'Dernière connexion';
$string['lastmodified'] = 'Modifié le';
$string['lastname'] = 'Nom';
$string['lastnamephonetic'] = 'Nom – phonétique';
$string['lastsiteaccess'] = 'Dernier accès au site';
$string['lastyear'] = 'Année passée';
$string['latestlanguagepack'] = 'Chercher les derniers paquetages de langue sur moodle.org';
$string['layouttable'] = 'Tableau pour mise en page';
$string['leavetokeep'] = 'Laisser vide pour ne pas changer le mot de passe';
$string['legacythemeinuse'] = 'Ce site vous est affiché en mode dégradé, car votre navigateur est trop ancien,';
$string['license'] = 'Licence';
$string['licenses'] = 'Licences';
$string['liketologin'] = 'Voulez-vous vous connecter avec un compte utilisateur ?';
$string['list'] = 'Liste';
$string['listfiles'] = 'Liste des fichiers dans {$a}';
$string['listofallpeople'] = 'Liste de tous les utilisateurs';
$string['listofcourses'] = 'Liste des cours';
$string['loadinghelp'] = 'Chargement...';
$string['local'] = 'Local';
$string['localplugins'] = 'Plugins locaux';
$string['localpluginsmanage'] = 'Gestion des plugins locaux';
$string['location'] = 'Emplacement';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Connecté sous le nom « {$a} »';
$string['loggedinasguest'] = 'Vous êtes connecté anonymement';
$string['loggedinnot'] = 'Non connecté.';
$string['login'] = 'Connexion';
$string['loginalready'] = 'Vous êtes déjà connecté';
$string['loginas'] = 'Se connecter sous ce nom';
$string['loginaspasswordexplain'] = '<p>Pour utiliser cette fonction, vous devez saisir un mot de passe spécial « connecté en tant que ».<br />Si vous ne connaissez pas ce mot de passe, prenez contact avec l\'administrateur de ce moodle.</p>';
$string['login_failure_logs'] = 'Historique des tentatives de connexion';
$string['loginguest'] = 'Connexion anonyme';
$string['loginsite'] = 'Se connecter sur le site';
$string['loginsteps'] = '<p>Bonjour. Pour un accès complet aux cours, prenez une minute pour vous créer un compte personnel sur ce site.<br />
Chaque cours peut également nécessiter une clef d\'inscription à usage unique dont vous n\'avez pas besoin pour l\'instant.</p>
<p>Voici les étapes à suivre :</p>
   <ol>
   <li>Remplir le formulaire <a href="{$a}">nouveau compte</a>.</li>
   <li>Un message vous sera immédiatement adressé par courriel.</li>
   <li>Récupérer ce message et cliquer sur le lien Web qu\'il contient.</li>
   <li>Votre inscription sera alors confirmée et vous serez connecté.</li>
   <li>Vous pourrez ensuite choisir le cours auquel vous souhaitez vous inscrire.</li>
   <li>Si une clef d\'inscription vous est demandée, utilisez celle que votre enseignant vous aura communiquée.</li>
   <li>Vous aurez alors un accès au cours complet. À votre prochaine visite il vous suffira d\'entrer votre nom d\'utilisateur et mot de passe (dans le formulaire ci-contre) afin de vous connecter et d\'accéder à tous les cours auxquels vous serez inscrit.</li>
   </ol>';
$string['loginstepsnone'] = '<p>Bonjour !</p><p>Pour un accès complet aux cours vous devez vous créer un compte.</p><p>Pour cela, vous avez seulement besoin de choisir un nom d\'utilisateur et un mot de passe à entrer dans le formulaire de cette page.</p><p>Si ce nom d\'utilisateur est déjà utilisé, il vous sera demandé d\'en choisir un autre.</p>';
$string['loginto'] = 'S\'inscrire à {$a}';
$string['logout'] = 'Déconnexion';
$string['logoutconfirm'] = 'Voulez-vous vraiment vous déconnecter ?';
$string['logs'] = 'Historiques';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">suite</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">suite</a> ]';
$string['lookback'] = 'Remonter';
$string['mailadmins'] = 'Informer les administrateurs';
$string['mailstudents'] = 'Informer les étudiants';
$string['mailteachers'] = 'Informer les enseignants';
$string['maincoursepage'] = 'Page d\'accueil du cours';
$string['makeafolder'] = 'Créer un dossier';
$string['makeeditable'] = 'Si le serveur Web (par exemple Apache) possède un accès en écriture au fichier « {$a} », alors il sera possible de modifier ce fichier directement depuis cette page';
$string['makethismyhome'] = 'Faire de cette page ma page d\'accueil par défaut';
$string['manageblocks'] = 'Blocs';
$string['managecategorythis'] = 'Gérer cette catégorie';
$string['managecourses'] = 'Gestion des cours';
$string['managedatabase'] = 'Base de données';
$string['manageeditorfiles'] = 'Gérer les fichiers utilisés par l\'éditeur';
$string['managefilters'] = 'Filtres';
$string['managemodules'] = 'Modules';
$string['manageroles'] = 'Rôles et permissions';
$string['markedthistopic'] = 'Cette section est en évidence (section en cours)';
$string['markthistopic'] = 'Marquer cette section comme section en cours';
$string['matchingsearchandrole'] = 'Correspondant à « {$a->search} » et {$a->role}';
$string['maxareabytesreached'] = 'Le fichier (ou la taille totale de plusieurs fichiers) dépasse l\'espace disponible dans cette zone.';
$string['maxbytesforfile'] = 'Le fichier {$a} dépasse l\'espace disponible dans cette zone.';
$string['maxfilesize'] = 'Taille maximale des nouveaux fichiers : {$a}';
$string['maxfilesreached'] = 'Vous pouvez joindre un maximum de {$a} fichier(s) à cet élément';
$string['maximumchars'] = '{$a} caractères maximum';
$string['maximumgrade'] = 'Note maximale';
$string['maximumgradex'] = 'Note maximale : {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Taille maximale des fichiers déposés';
$string['maximumupload_help'] = 'Ce réglage détermine la taille maximale des fichiers pouvant être déposés dans le cours ; cette taille ne peut pas dépasser celle prévue par l\'administrateur de la plateforme. Chaque activité comprend également un tel réglage permettant de fixer des valeurs particulières pour certaines activités.';
$string['maxnumberweeks'] = 'Nombre maximum de sections';
$string['maxnumberweeks_desc'] = 'La valeur maximum du nombre de sections apparaissant dans le menu déroulant (n\'est valable que pour certains formats de cours).';
$string['maxnumcoursesincombo'] = 'Consultez <a href="{$a->link}">{$a->numberofcourses} cours</a>.';
$string['maxsize'] = 'Taille maximale : {$a}';
$string['maxsizeandareasize'] = 'Taille maximale pour les nouveaux fichiers : {$a->size}, limite globale : {$a->areasize}';
$string['maxsizeandattachments'] = 'Taille maximale des nouveaux fichiers : {$a->size}. Nombre maximal d\'annexes : {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Taille maximale pour les nouveaux fichiers : {$a->size}, nombre maximal d\'annexes : {$a->attachments}, limite globale : {$a->areasize}';
$string['memberincourse'] = 'Personnes dans le cours';
$string['messagebody'] = 'Texte du message';
$string['messagedselectedusers'] = 'Le message a été envoyé aux utilisateurs sélectionnés et la liste des destinataires réinitialisée.';
$string['messagedselectedusersfailed'] = 'Une erreur est survenue lors de l\'envoi du message aux utilisateurs sélectionnés. Certains d\'entre eux ont peut-être reçu le message.';
$string['messageprovider:availableupdate'] = 'Notifications de mises à jour disponibles';
$string['messageprovider:backup'] = 'Notifications de sauvegarde';
$string['messageprovider:badgecreatornotice'] = 'Notifications au créateur du badge';
$string['messageprovider:badgerecipientnotice'] = 'Notifications au détenteur du badge';
$string['messageprovider:courserequestapproved'] = 'Notification de demande d\'approbation de création de cours';
$string['messageprovider:courserequested'] = 'Notification de demande de création de cours';
$string['messageprovider:courserequestrejected'] = 'Notification de rejet de création de cours';
$string['messageprovider:errors'] = 'Importantes erreurs avec le site';
$string['messageprovider:errors_help'] = 'Ces erreurs sont graves et devraient être annoncées à un administrateur.';
$string['messageprovider:instantmessage'] = 'Messages personnels entre utilisateurs';
$string['messageprovider:instantmessage_help'] = 'Cette section permet de configurer ce qui se passe avec les messages personnels qui vous sont envoyés par d\'autres utilisateurs de ce site.';
$string['messageprovider:notices'] = 'Avertissement de problèmes mineurs';
$string['messageprovider:notices_help'] = 'Ces informations pourraient être intéressantes pour un administrateur.';
$string['messageselect'] = 'Sélectionner cet utilisateur comme destinataire';
$string['messageselectadd'] = 'Envoyer un message';
$string['middlename'] = 'Second prénom';
$string['migratinggrades'] = 'Migration des notes';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minute';
$string['minutes'] = 'minutes';
$string['miscellaneous'] = 'Divers';
$string['missingcategory'] = 'Veuillez choisir une catégorie';
$string['missingcity'] = 'Veuillez renseigner la ville';
$string['missingcountry'] = 'Le pays ne peut pas être vide';
$string['missingdescription'] = 'La description ne peut pas être vide';
$string['missingemail'] = 'L\'adresse de courriel ne peut pas être vide';
$string['missingfirstname'] = 'Le prénom ne peut pas être vide';
$string['missingfromdisk'] = 'absent du disque dur';
$string['missingfullname'] = 'Le nom complet ne peut pas être vide';
$string['missinglastname'] = 'Le nom ne peut pas être vide';
$string['missingname'] = 'Le nom ne peut pas être vide';
$string['missingnewpassword'] = 'Le nouveau mot de passe ne peut pas être vide';
$string['missingpassword'] = 'Le mot de passe ne peut pas être vide';
$string['missingrecaptchachallengefield'] = 'Le champ reCAPTCHA est manquant';
$string['missingreqreason'] = 'Veuillez renseigner la raison';
$string['missingshortname'] = 'Le nom abrégé ne peut pas être vide';
$string['missingshortsitename'] = 'Le nom abrégé du site ne peut pas être vide';
$string['missingsitedescription'] = 'La description du site ne peut pas être vide';
$string['missingsitename'] = 'Le nom du site ne peut pas être vide';
$string['missingstrings'] = 'Chaînes non traduites';
$string['missingstudent'] = 'Vous devez choisir un étudiant';
$string['missingsummary'] = 'Résumé non renseigné';
$string['missingteacher'] = 'Vous devez choisir un enseignant';
$string['missingurl'] = 'L\'URL ne peut pas être vide';
$string['missingusername'] = 'Le nom d\'utilisateur ne peut pas être vide';
$string['modchooserdisable'] = 'Désactiver le sélecteur de ressources ou d\'activités';
$string['modchooserenable'] = 'Activer le sélecteur de ressources ou d\'activités';
$string['moddoesnotsupporttype'] = 'Le module {$a->modname} ne permet pas le dépôt de fichiers de type {$a->type}';
$string['modified'] = 'Modifié';
$string['moduleintro'] = 'Description';
$string['modulesetup'] = 'Installation des tables des modules';
$string['modulesuccess'] = 'Les tables du module {$a} ont été installées correctement';
$string['modulesused'] = 'Modules utilisés';
$string['month'] = 'mois';
$string['months'] = 'mois';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Documentation Moodle pour cette page';
$string['moodlerelease'] = 'Version de Moodle';
$string['moodleversion'] = 'Version de Moodle';
$string['more'] = 'suite';
$string['morehelp'] = 'Plus d\'aide';
$string['moreinformation'] = 'Plus d\'informations sur cette erreur';
$string['moreprofileinfoneeded'] = 'Veuillez nous en dire plus sur vous-même';
$string['mostrecently'] = 'le plus récemment';
$string['move'] = 'Déplacer';
$string['movecategoriessuccess'] = 'Déplacement de {$a->count} catégories vers la catégorie « {$a->to} » terminé';
$string['movecategoriestotopsuccess'] = '{$a->count} catégories déplacées au niveau racine';
$string['movecategorycontentto'] = 'Déplacer dans';
$string['movecategorysuccess'] = 'Déplacement de la catégorie « {$a->moved} » dans la catégorie « {$a->to} » terminé';
$string['movecategoryto'] = 'Déplacer la catégorie vers :';
$string['movecategorytotopsuccess'] = 'La catégorie « {$a->moved} » a été déplacée au niveau racine';
$string['movecontent'] = 'Déplacer {$a}';
$string['movecontentstoanothercategory'] = 'Déplacer le contenu vers une autre catégorie';
$string['movecoursemodule'] = 'Déplacer la ressource';
$string['movecoursesection'] = 'Déplacer la section';
$string['movecourseto'] = 'Déplacer le cours vers :';
$string['movedown'] = 'Descendre';
$string['movefilestohere'] = 'Déplacer les fichiers ici';
$string['movefull'] = 'Déplacer {$a} à cet endroit';
$string['movehere'] = 'Déplacer ici';
$string['moveleft'] = 'Déplacer à gauche';
$string['moveright'] = 'Déplacer à droite';
$string['movesection'] = 'Déplacer section {$a}';
$string['moveselectedcategoriesto'] = 'Déplacer les catégories sélectionnées vers...';
$string['moveselectedcoursesto'] = 'Déplacer les cours sélectionnés vers...';
$string['movetoanotherfolder'] = 'Déplacer vers un autre dossier';
$string['moveup'] = 'Monter';
$string['msnid'] = 'Identifiant MSN';
$string['mustchangepassword'] = 'Le nouveau mot de passe doit être différent du mot de passe actuel';
$string['mustconfirm'] = 'Vous devez confirmer votre enregistrement';
$string['mycourses'] = 'Mes cours';
$string['myfiles'] = 'Fichiers personnels';
$string['myfilesmanage'] = 'Gérer mes fichiers personnels';
$string['myhome'] = 'Ma page';
$string['mymoodledashboard'] = 'Mon tableau de bord Moodle';
$string['myprofile'] = 'Mon profil';
$string['name'] = 'Nom';
$string['nameforlink'] = 'Comment voulez-vous dénommer ce lien ?';
$string['nameforpage'] = 'Nom';
$string['navigation'] = 'Navigation';
$string['needed'] = 'Nécessaire';
$string['never'] = 'Jamais';
$string['neverdeletelogs'] = 'Ne jamais effacer les historiques';
$string['new'] = 'Nouveau';
$string['newaccount'] = 'Nouveau compte';
$string['newcourse'] = 'Nouveau cours';
$string['newpassword'] = 'Nouveau mot de passe';
$string['newpasswordfromlost'] = '<strong>Attention !</strong> Votre <strong>Mot de passe actuel</strong> vous a été envoyé dans le <strong>deuxième</strong> des deux courriels envoyés durant le processus de récupération de mot de passe. Veuillez vous assurer que vous avez bien reçu votre mot de passe de remplacement avant de continuer sur cette page.';
$string['newpassword_help'] = 'Saisissez un nouveau mot de passe ou laissez vide pour conserver le mot de passe actuel.';
$string['newpasswordtext'] = 'Bonjour {$a->firstname},

Le mot de passe de votre compte sur « {$a->sitename} » a été remplacé par un nouveau mot de passe temporaire.

Les informations pour vous connecter sont désormais :

    nom d\'utilisateur : {$a->username}
    mot de passe : {$a->newpassword}

Merci de visiter cette page afin de changer de mot de passe :
    {$a->link}

Dans la plupart des logiciels de messagerie, cette adresse devrait apparaître comme un lien de couleur bleue qu\'il vous suffit de cliquer. Si cela ne fonctionne pas, copiez ce lien et collez-le dans la barre d\'adresse de votre navigateur web.

Si vous avez besoin d\'aide, veuillez contacter l\'administrateur du site {$a->sitename},
{$a->signoff}';
$string['newpicture'] = 'Nouvelle image';
$string['newpicture_help'] = 'Pour ajouter une image, sélectionnez-en une en format JPG ou PNG, puis cliquez sur « Enregistrer mon profil ».  L\'image sera redimensionnée en un carré de 100x100 pixels.';
$string['newsitem'] = 'article';
$string['newsitems'] = 'articles';
$string['newsitemsnumber'] = 'Nouvelles à afficher';
$string['newsitemsnumber_help'] = 'Ce réglage détermine le nombre d\'éléments à afficher dans le bloc des dernières nouvelles, sur la page du cours. S\'il est réglé à « 0 article », le bloc des dernières nouvelles ne sera pas affiché.';
$string['newuser'] = 'Nouvel utilisateur';
$string['newusernewpasswordsubj'] = 'Nouveau compte utilisateur';
$string['newusernewpasswordtext'] = 'Bonjour,

Un nouveau compte a été créé pour vous sur le site « {$a->sitename} » et un mot de passe temporaire vous a été délivré.

Les informations nécessaires à votre connexion sont maintenant :
   nom d\'utilisateur : {$a->username}
   mot de passe       : {$a->newpassword}

Vous devrez changer votre mot de passe lors de votre première connexion.

Pour commencer à travailler sur « {$a->sitename} », veuillez vous connecter en cliquant sur le lien ci-dessous.
   {$a->link}

Dans la plupart des logiciels de messagerie, cette adresse devrait apparaître comme un lien de couleur bleue qu\'il vous suffit de cliquer. Si cela ne fonctionne pas, copiez ce lien et collez-le dans la barre d\'adresse de votre navigateur web.

Si vous avez besoin d\'aide, veuillez contacter l\'administrateur du site {$a->sitename},
{$a->signoff}';
$string['newusers'] = 'Nouveaux utilisateurs';
$string['newwindow'] = 'Nouvelle fenêtre';
$string['next'] = 'Suivant';
$string['nextsection'] = 'Section suivante';
$string['no'] = 'Non';
$string['noblockstoaddhere'] = 'Il n\'y a pas de bloc que vous puissiez ajouter à cette page.';
$string['nobody'] = 'Personne';
$string['nochange'] = 'Aucun changement';
$string['nocomments'] = 'Pas de commentaire';
$string['nocourses'] = 'Aucun cours';
$string['nocoursesfound'] = 'Aucun cours contenant les mots « {$a} » n\'a été trouvé';
$string['nocoursesyet'] = 'Il n\'y a pas encore de cours';
$string['nodstpresets'] = 'L\'administrateur n\'a pas activé le support de l\'heure d\'été.';
$string['nofilesselected'] = 'Aucun fichier n\'a encore été choisi pour être restauré';
$string['nofilesyet'] = 'Aucun fichier n\'a encore été déposé dans ce cours';
$string['nograde'] = 'Pas de note';
$string['nohelpforactivityorresource'] = 'Il n\'y a actuellement pas d\'aide associée à cette ressource ou activité.';
$string['noimagesyet'] = 'Aucune image n\'a encore été déposée dans ce cours';
$string['nologsfound'] = 'Aucun historique n\'a été trouvé';
$string['nomatchingusers'] = 'Aucun utilisateur correspondant à « {$a} »';
$string['nomorecourses'] = 'Aucun cours n\'a été trouvé';
$string['nomoreidnumber'] = 'N\'utilise pas de numéro idnumber pour éviter les collisions';
$string['none'] = 'Aucun';
$string['noneditingteacher'] = 'Enseignant non éditeur';
$string['noneditingteacherdescription'] = 'Les enseignants non éditeurs peuvent enseigner dans leur cours et donner des notes aux étudiants, mais ne peuvent ni ajouter, ni modifier des activités.';
$string['nonstandard'] = 'Non standard';
$string['nopendingcourses'] = 'Il n\'y a aucun cours en attente d\'approbation';
$string['nopotentialadmins'] = 'Aucun administrateur potentiel';
$string['nopotentialcreators'] = 'Aucun créateur de cours potentiel';
$string['nopotentialstudents'] = 'Aucun étudiant potentiel';
$string['nopotentialteachers'] = 'Aucun enseignant potentiel';
$string['norecentactivity'] = 'Aucune activité récente';
$string['noreplybouncemessage'] = 'Vous avez répondu à une adresse de courriel sans réponse. Si vous essayiez de répondre à un message d\'un forum, essayez plutôt d\'y répondre dans les forums de {$a}.

Voici une copie de votre message :';
$string['noreplybouncesubject'] = '{$a} - message de rebond.';
$string['noreplyname'] = 'Merci de ne pas répondre à ce courriel';
$string['noresetrecord'] = 'Il n\'y a pas de trace de cette requête de réinitialisation. Veuillez effectuer une nouvelle demande de réinitialisation de mot de passe.';
$string['noresults'] = 'Aucun résultat';
$string['normal'] = 'Normale';
$string['normalfilter'] = 'Moins de critères';
$string['nosite'] = 'Impossible de trouver le cours de site';
$string['nostudentsfound'] = 'Aucun {$a} trouvé';
$string['nostudentsingroup'] = 'Il n\'y a pas encore d\'étudiant dans ce groupe';
$string['nostudentsyet'] = 'Pas encore d\'étudiant inscrit à ce cours';
$string['nosuchemail'] = 'Adresse de courriel inconnue';
$string['notavailable'] = 'Non disponible';
$string['noteachersyet'] = 'Pas encore d\'enseignant dans ce cours';
$string['notenrolled'] = '{$a} n\'est pas inscrit à ce cours.';
$string['notenrolledprofile'] = 'Ce profil n\'est pas accessible, car cet utilisateur n\'est pas inscrit à ce cours.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Remarque :</strong> la possibilité de modifier les dates des activités lors de la restauration a été désactivée, car vous ne possèdez pas les autorisations requises.';
$string['noteuserschangednonetocourse'] = '<strong>Remarque :</strong> les utilisateurs du cours doivent être restaurés lors de la restauration de données utilisateur (fichiers ou messages, dans les activités). Ce paramètre a été modifié pour vous.';
$string['nothingnew'] = 'Rien de nouveau depuis votre dernière visite';
$string['nothingtodisplay'] = 'Rien à afficher';
$string['notice'] = 'Remarque';
$string['noticenewerbackup'] = 'Ce fichier de sauvegarde a été créé avec la version {$a->backuprelease} ({$a->backupversion}) de Moodle, qui est plus récente que votre installation actuelle de Moodle {$a->serverrelease} ({$a->serverversion}). Ceci peut causer des incohérences, car la compatibilité des fichiers de sauvegarde ne peut dans ce cas pas être garantie.';
$string['notifications'] = 'Notifications';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP : {$a->ip}, Utilisateur : {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Vous pouvez consulter l\'historique de ces tentatives à l\'adresse {$a}/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Voici une liste des tentatives de connexion au site {$a} depuis la dernière notification';
$string['notifyloginfailuressubject'] = '{$a} :: notification de tentatives de connexion';
$string['notincluded'] = 'Pas inclus';
$string['notingroup'] = 'Désolé, vous devez faire partie d\'un groupe pour participer à cette activité.';
$string['notpublic'] = 'Non public !';
$string['nousersfound'] = 'Aucun utilisateur n\'a été trouvé';
$string['nousersmatching'] = 'Aucun utilisateur n\'a été trouvé contenant le texte « {$a} ».';
$string['nousersyet'] = 'Il n\'y pas encore d\'utilisateur';
$string['novalidcourses'] = 'Aucun cours valable à afficher';
$string['now'] = 'maintenant';
$string['numattempts'] = '{$a} tentatives de connexions infructueuses';
$string['numberofcourses'] = 'Nombre de cours';
$string['numberweeks'] = 'Nombre de sections';
$string['numdays'] = '{$a} jours';
$string['numhours'] = '{$a} heures';
$string['numletters'] = '{$a} caractères';
$string['numminutes'] = '{$a} minutes';
$string['nummonths'] = '{$a} mois';
$string['numseconds'] = '{$a} secondes';
$string['numviews'] = '{$a} vues';
$string['numweeks'] = '{$a} semaines';
$string['numwords'] = '{$a} mots';
$string['numyears'] = '{$a} ans';
$string['ok'] = 'Ok';
$string['oldpassword'] = 'Mot de passe actuel';
$string['olduserdirectory'] = 'Ceci est l\'ancien dossier utilisateur. Il n\'est plus utilisé. Vous pouvez le supprimer sans conséquence. Les fichiers qu\'il contient ont été copiés dans le nouveau dossier utilisateur.';
$string['opentoguests'] = 'Accès anonyme';
$string['optional'] = 'Facultatif';
$string['options'] = 'options';
$string['order'] = 'Ordre';
$string['originalpath'] = 'Chemin original';
$string['orphanedactivitiesinsectionno'] = 'Activités orphelines (section {$a})';
$string['other'] = 'Autre';
$string['outline'] = 'Résumé';
$string['outlinereport'] = 'Rapport résumé';
$string['page'] = 'Page';
$string['pagea'] = 'Page {$a}';
$string['pageheaderconfigablock'] = 'Configuration d\'un bloc dans {$a->fullname}';
$string['pagepath'] = 'Chemin de la page';
$string['pageshouldredirect'] = 'Cette page va vous rediriger automatiquement. Si cela n\'arrive pas, veuillez utiliser le lien Continuer ci-dessous.';
$string['parentcategory'] = 'Catégorie supérieure';
$string['parentcoursenotfound'] = 'Le cours parent n\'a pas été trouvé !';
$string['parentfolder'] = 'Dossier parent';
$string['participants'] = 'Participants';
$string['participantslist'] = 'Liste des participants';
$string['participationratio'] = 'Proportion de participation';
$string['participationreport'] = 'Rapport de participation';
$string['password'] = 'Mot de passe';
$string['passwordchanged'] = 'Le mot de passe a été changé';
$string['passwordconfirmchange'] = 'Confirmer le changement de mot de passe';
$string['passwordextlink'] = 'Le lien ci-dessous a été mis en place pour vous permettre de retrouver votre mot de passe perdu. En suivant ce lien, vous allez vous déconnecter de Moodle.';
$string['passwordforgotten'] = 'Mot de passe oublié';
$string['passwordforgotteninstructions'] = 'Les informations vous concernant doivent d\'abord être trouvées dans la base de données. Veuillez saisir <strong>soit</strong> votre nom d\'utilisateur, soit votre adresse de courriel dans le champ adéquat. Il n\'est pas nécessaire de saisir les deux.';
$string['passwordforgotteninstructions2'] = 'Pour recevoir un nouveau mot de passe, veuillez indiquer ci-dessous votre adresse de courriel ou votre nom d\'utilisateur. Si les données correspondantes se trouvent dans la base de données, un message vous sera envoyé par courriel, avec des instructions vous permettant de vous connecter.';
$string['passwordnohelp'] = 'Aucune aide n\'est disponible pour retrouver votre mot de passe perdu. Veuillez contacter l\'administrateur de ce Moodle.';
$string['passwordrecovery'] = 'Récupération de votre mot de passe';
$string['passwordsdiffer'] = 'Les mots de passe ne correspondent pas';
$string['passwordsent'] = 'Le mot de passe a été envoyé';
$string['passwordsenttext'] = '<p>Un message vous a été envoyé à cette adresse : {$a->email}.</p><p><strong>Merci de lire ce message afin de connaître votre nouveau mot de passe</strong></p><p>Ce nouveau mot de passe a été généré automatiquement. Vous voudrez sans doute le <a href="{$a->link}">modifier</a> afin qu\'il vous soit plus facile de vous en souvenir.</p>';
$string['passwordset'] = 'Votre mot de passe a été changé.';
$string['path'] = 'Chemin';
$string['pathnotexists'] = 'Ce chemin n\'existe pas sur votre serveur !';
$string['pathslasherror'] = 'Le chemin ne doit pas se terminer par une barre oblique !';
$string['paymentinstant'] = 'Le bouton ci-dessous vous permet de payer et de vous inscrire en quelques minutes !';
$string['paymentpending'] = '(<small><b>{$a}</b> en attente</small>)';
$string['paymentrequired'] = 'Un paiement est requis pour accéder à ce cours.';
$string['payments'] = 'Paiements';
$string['paymentsorry'] = 'Merci pour votre paiement ! Malheureusement, votre paiement n\'a pas encore été comptabilisé, et vous ne pouvez pas encore accéder au cours « {$a->fullname} ». Veuillez essayer d\'accéder au cours dans quelques secondes. Si vous n\'arrivez toujours pas à y accéder, merci de contacter l\'enseignant ou l\'administrateur du site';
$string['paymentthanks'] = 'Merci pour votre paiement ! Vous êtes dès maintenant inscrit à votre cours :<br />« {$a} »';
$string['pendingrequests'] = 'Demandes en attente';
$string['periodending'] = 'Fin de la période ({$a})';
$string['perpage'] = 'Par page';
$string['perpagea'] = 'Par page : {$a}';
$string['personal'] = 'Personnel';
$string['personalprofile'] = 'Fiche personnelle';
$string['phone'] = 'Téléphone';
$string['phone2'] = 'Téléphone mobile';
$string['phpinfo'] = 'Info PHP';
$string['pictureof'] = 'Avatar {$a}';
$string['pictureofuser'] = 'Avatar utilisateur';
$string['pleaseclose'] = 'Veuillez maintenant fermer cette fenêtre.';
$string['pleasesearchmore'] = 'Veuillez rechercher plus';
$string['pleaseusesearch'] = 'Veuillez utiliser la recherche';
$string['plugin'] = 'Plugin';
$string['plugincheck'] = 'Vérifications plugins';
$string['plugindeletefiles'] = 'Toutes les données associées au plugin « {$a->name} » ont été supprimées de la base de données. Pour empêcher que le plugin ne se réinstalle, veuillez supprimer le dossier « {$a->directory} » de votre serveur.';
$string['pluginsetup'] = 'Mise en place des tables de plug-ins';
$string['policyaccept'] = 'Je comprends et je me déclare d\'accord';
$string['policyagree'] = 'Vous devez accepter de vous conformer à ce règlement pour continuer à utiliser ce site. Acceptez-vous le règlement ?';
$string['policyagreement'] = 'Règlement du site';
$string['policyagreementclick'] = 'Lien vers le règlement du site';
$string['popup'] = 'Fenêtre surgissante';
$string['popupwindow'] = 'Ouvrir le fichier dans une nouvelle fenêtre';
$string['popupwindowname'] = 'Nouvelle fenêtre';
$string['post'] = 'Message';
$string['posts'] = 'Messages';
$string['potentialadmins'] = 'Administrateurs potentiels';
$string['potentialcreators'] = 'Créateurs de cours potentiels';
$string['potentialstudents'] = 'Étudiants potentiels';
$string['potentialteachers'] = 'Enseignants potentiels';
$string['preferences'] = 'Préférences';
$string['preferredlanguage'] = 'Langue préférée';
$string['preferredtheme'] = 'Thème préféré';
$string['preprocessingbackupfile'] = 'Prétraitement du fichier de sauvegarde';
$string['prev'] = 'Précédent';
$string['preview'] = 'Aperçu';
$string['previewhtml'] = 'Aperçu en format HTML';
$string['previeworchoose'] = 'Aperçu ou choix d\'un thème';
$string['previous'] = 'Précédent';
$string['previouslyselectedusers'] = 'Utilisateurs sélectionnés précédemment ne correspondant pas à « {$a} »';
$string['previoussection'] = 'Section précédente';
$string['primaryadminsetup'] = 'Mise en place du compte de l\'administrateur';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'La description de ce profil ne s\'affichera que lorsque cet utilisateur sera inscrit dans au moins un cours.';
$string['publicprofile'] = 'Profil public';
$string['publicsitefileswarning'] = 'Remarque : les fichiers déposés ici sont accessibles par tout le monde';
$string['publicsitefileswarning2'] = 'Remarque : les fichiers déposés ici sont accessibles par tous ceux qui connaissent (ou devinent) l\'URL. Pour des raisons de sécurité, il est recommandé que tous les fichiers de sauvegarde soient supprimés immédiatement après que la restauration a été effectuée.';
$string['publicsitefileswarning3'] = 'Remarque : les fichiers déposés ici sont accessibles par tous ceux qui connaissent (ou devinent) l\'URL. Pour des raisons de sécurité, les fichiers de sauvegarde ne doivent être enregistrés que dans le dossier sécurisé « backupdata ».';
$string['publish'] = 'Publier';
$string['question'] = 'Question';
$string['questionsinthequestionbank'] = 'Questions dans la banque de questions';
$string['readinginfofrombackup'] = 'Lecture des informations de la sauvegarde';
$string['readme'] = 'LISEZMOI';
$string['recentactivity'] = 'Activité récente';
$string['recentactivityreport'] = 'Rapport complet des activités récentes...';
$string['recipientslist'] = 'Liste des destinataires';
$string['recreatedcategory'] = 'Catégorie {$a} recréée';
$string['redirect'] = 'Redirection';
$string['reducesections'] = 'Réduire le nombre des sections';
$string['refresh'] = 'Actualiser';
$string['refreshingevents'] = 'Actualisation du calendrier';
$string['registration'] = 'Enregistrement de Moodle';
$string['registrationcontact'] = 'Contact pour le public';
$string['registrationcontactno'] = 'Non, je ne désire pas de formulaire de contact dans la liste des sites';
$string['registrationcontactyes'] = 'Oui, j\'aimerais qu\'un formulaire de contact permette aux éventuels Moodleurs de me contacter';
$string['registrationemail'] = 'Notifications par courriel';
$string['registrationinfo'] = '<p>Cette page vous permet d\'enregistrer votre site Moodle sur moodle.org. L\'enregistrement est gratuit. Le principal avantage de l\'enregistrement est l\'inscription à une liste de distribution courriel utilisée pour d\'importantes informations telles que des alertes de sécurité et des mises à jour de Moodle.</p><p>Vos données seront conservées confidentiellement, et ne seront jamais vendues ou divulguées à quiconque. Ces informations ne sont recueillies que pour l\'assistance technique et à des fins de statistiques sur la communauté Moodle.</p><p>Si vous le désirez, le nom et l\'URL de votre site, ainsi que votre pays peuvent être ajoutés à la liste publique des sites Moodle.</p><p>Les nouveaux enregistrements sont vérifiés manuellement avant d\'être ajoutés à la liste. En revanche, une fois dans cette liste, vous pouvez modifier votre enregistrement en tout temps en remplissant et validant à nouveau ce formulaire.</p>';
$string['registrationinfotitle'] = 'Informations d\'enregistrement';
$string['registrationno'] = 'Non, je ne désire pas recevoir de courriel';
$string['registrationsend'] = 'Envoyer les informations d\'enregistrement à moodle.org';
$string['registrationyes'] = 'Oui, envoyez-moi les informations importantes';
$string['reject'] = 'Rejeter';
$string['rejectdots'] = 'Rejeter...';
$string['reload'] = 'Actualiser';
$string['remoteappuser'] = 'Utilisateur distant de {$a}';
$string['remove'] = 'Supprimer';
$string['removeadmin'] = 'Supprimer cet administrateur';
$string['removecreator'] = 'Supprimer ce créateur de cours';
$string['removestudent'] = 'Supprimer cet étudiant';
$string['removeteacher'] = 'Supprimer cet enseignant';
$string['rename'] = 'Renommer';
$string['renamefileto'] = 'Renommer <strong>{$a}</strong> en';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapports';
$string['repositories'] = 'Dépôts';
$string['requestcourse'] = 'Demander la création d\'un cours';
$string['requestedby'] = 'Demandé par';
$string['requestedcourses'] = 'Cours demandés';
$string['requestreason'] = 'Raison de la demande de création';
$string['required'] = 'Requis';
$string['requirespayment'] = 'Un paiement est requis pour accéder à ce cours';
$string['reset'] = 'Réinitialiser';
$string['resetcomponent'] = 'Composant';
$string['resetcourse'] = 'Réinitialiser le cours';
$string['resetinfo'] = 'Cette page vous permet de retirer du cours les données des utilisateurs, tout en conservant les activités et les autres réglages du cours. Veuillez remarquer qu\'en choisissant des éléments ci-dessous et après validation de cette page, les données que vous aurez choisies seront supprimées du cours sans aucun moyen de les restaurer !';
$string['resetnotimplemented'] = 'Réinitialisation pas implémentée';
$string['resetrecordexpired'] = 'Le lien de réinitialisation de mot de passe que vous avez utilisé a été généré il y a {$a} minutes et est désormais échu. Veuillez effectuer une nouvelle demande de réinitialisation de mot de passe.';
$string['resetstartdate'] = 'Réinitialiser la date de début';
$string['resetstatus'] = 'État';
$string['resettask'] = 'Tâche';
$string['resettodefaults'] = 'Retour aux réglages par défaut';
$string['resortbyfullname'] = 'Par nom complet';
$string['resortbyidnumber'] = 'Par identifiant';
$string['resortbyshortname'] = 'Par nom abrégé';
$string['resortcourses'] = 'Trier les cours';
$string['resortsubcategoriesbyidnumber'] = 'Trier les sous-catégories par identifiant';
$string['resortsubcategoriesbyname'] = 'Trier les sous-catégories par nom';
$string['resource'] = 'Ressource';
$string['resourcedisplayauto'] = 'Automatique';
$string['resourcedisplaydownload'] = 'Forcer le téléchargement';
$string['resourcedisplayembed'] = 'Intégrer';
$string['resourcedisplayframe'] = 'Dans un cadre';
$string['resourcedisplaynew'] = 'Nouvelle fenêtre';
$string['resourcedisplayopen'] = 'Ouvrir';
$string['resourcedisplaypopup'] = 'Dans une fenêtre surgissante';
$string['resources'] = 'Ressources';
$string['resources_help'] = 'Les différents types de ressource vous permettent d\'insérer dans le cours pratiquement n\'importe quelle sorte de contenu.';
$string['restore'] = 'Restauration';
$string['restorecancelled'] = 'Restauration annulée';
$string['restorecannotassignroles'] = 'La restauration nécessite l\'attribution de rôles et vous n\'êtes pas autorisé à le faire';
$string['restorecannotcreateorassignroles'] = 'La restauration nécessite la création ou l\'attribution de rôles et vous n\'êtes pas autorisé à le faire';
$string['restorecannotcreateuser'] = 'La restauration nécessite la création de l\'utilisateur « {$a} » à partir du fichier de sauvegarde et vous n\'êtes pas autorisé à le faire';
$string['restorecannotoverrideperms'] = 'La restauration nécessite la définition de dérogation aux rôles et vous n\'êtes pas autorisé à le faire';
$string['restorecoursenow'] = 'Restaurer ce cours maintenant!';
$string['restoredaccount'] = 'Compte restauré';
$string['restoredaccountinfo'] = 'Ce compte a été importé d\'un autre serveur et son mot de passe a été perdu. Pour définir un nouveau mot de passe par courriel, veuillez cliquer sur « Continuer »';
$string['restorefinished'] = 'Restauration réussie';
$string['restoreto'] = 'Restaurer vers';
$string['restoretositeadding'] = 'Attention ! Vous allez restaurer des données en les ajoutant à la page d\'accueil du site !';
$string['restoretositedeleting'] = 'Attention ! Vous allez restaurer des données sur la page d\'accueil du site, en supprimant certaines données existantes !';
$string['restoreuserconflict'] = 'Une tentative de restaurer l\'utilisateur « {$a} » à partir du fichier de sauvegarde sera la cause d\'un conflit';
$string['restoreuserinfofailed'] = 'La restauration a été interrompue, car vous ne disposez pas des autorisations requises pour la restauration des données des utilisateurs.';
$string['restoreusersprecheck'] = 'Vérification des données utilisateur';
$string['restoreusersprecheckerror'] = 'Des problèmes ont été détectés lors de la vérification des données utilisateur';
$string['restricted'] = 'Interdit';
$string['returningtosite'] = 'Vous possédez déjà un compte ?';
$string['returntooriginaluser'] = 'Retour à {$a}';
$string['revert'] = 'Version précédente';
$string['role'] = 'Rôle';
$string['roleassignments'] = 'Attributions de rôle';
$string['rolemappings'] = 'Application des rôles';
$string['rolerenaming'] = 'Renommer les rôles';
$string['rolerenaming_help'] = 'Ce réglage permet de modifier les noms des rôles utilisés dans votre cours. Seul l\'affichage du nom du rôle est modifié. Les permissions associées au rôle ne sont pas affectées. Ces nouveaux noms des rôles seront affichés sur la page des participants au cours et partout ailleurs dans le cours. Si le rôle renommé est l\'un des rôles désignés par l\'administrateur de votre Moodle comme celui d\'un gestionnaire de cours, le nouveau nom sera également affiché dans la liste des cours.';
$string['roles'] = 'Rôles';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Nombre d\'articles RSS récents';
$string['rsserror'] = 'Erreur lors de la lecture de données RSS';
$string['rsserrorauth'] = 'Votre lien RSS ne contient pas de jeton d\'authentification valide.';
$string['rsserrorguest'] = 'Ce flux utilise l\'accès « Utilisateur anonyme » pour accéder aux données, mais ce rôle n\'a pas les droits d\'accès requis pour lire les données. Veuillez visiter l\'URL de provenance de ce flux en tant qu\'utilisateur connecté et obtenir un lien RSS.';
$string['rsskeyshelp'] = 'Pour assurer la sécurité et la confidentialité, les URLs des flux RSS contiennent une clef identifiant leur utilisateur. Ceci empêche d\'autres utilisateurs d\'accéder à des zones de Moodle auxquelles ils ne doivent pas avoir accès au moyen des flux RSS.</p><p>Cette clef est créée automatiquement la première fois que vous accédez à une zone de Moodle qui produit un flux RSS. Si vous avez des raisons de penser que votre clef de flux RSS a été compromise, vous pouvez en générer une nouvelle en cliquant le lien Réinitialiser. Veuillez prendre note que les URLs actuels de vos flux RSS ne seront alors plus valides.';
$string['rsstype'] = 'Flux RSS de cette activité';
$string['saveandnext'] = 'Enregistrer et afficher la suite';
$string['savechanges'] = 'Enregistrer';
$string['savechangesanddisplay'] = 'Enregistrer et afficher';
$string['savechangesandreturntocourse'] = 'Enregistrer et revenir au cours';
$string['savecomment'] = 'Enregistrer le commentaire';
$string['savedat'] = 'Enregistré à';
$string['savepreferences'] = 'Enregistrer les préférences';
$string['saveto'] = 'Enregistrer sous';
$string['scale'] = 'Barème';
$string['scale_help'] = 'Un barème est une échelle d\'évaluation ou de la notation du travail fourni dans une activité. Il est défini au moyen d\'une liste ordonnées de valeurs, séparées par des virgules, s\'étendant du négatif au positif. Par exemple : « Décevant, Pas assez bon, Moyen, Bon, Très bon, Excellent ».';
$string['scales'] = 'Barèmes';
$string['scalescustom'] = 'Barèmes personnalisés';
$string['scalescustomcreate'] = 'Ajouter un nouveau barème';
$string['scalescustomno'] = 'Aucun barème personnalisé n\'a été encore créé';
$string['scalesstandard'] = 'Barèmes standards';
$string['scalestandard'] = 'Barème standard';
$string['scalestandard_help'] = 'Un barème standard est disponible dans tout le site, pour tous les cours.';
$string['scalestip'] = 'Pour créer des barêmes personnalisés, utilisez le liens « Barêmes... » dans le menu d\'administration de votre cours.';
$string['scalestip2'] = 'Pour créer des barêmes personnalisés, cliquez sur le lien Notes dans le menu d\'administration du cours, puis sélectionnez Modifier > Barêmes dans le menu déroulant.';
$string['schedule'] = 'Planification';
$string['screenshot'] = 'Copie d\'écran';
$string['search'] = 'Rechercher';
$string['searchagain'] = 'Rechercher de nouveau';
$string['searchbyemail'] = 'Récupération par adresse de courriel';
$string['searchbyusername'] = 'Récupération par nom d\'utilisateur';
$string['searchcourses'] = 'Rechercher des cours';
$string['searchhelp'] = '<p>Vous pouvez saisir plusieurs termes comme critères et affiner votre recherche de la façon suivante.<p>
<ul>
<li>terme : rechercher toutes les occurrences du terme dans le texte.</li>
<li>+terme : seules les correspondances exactes du terme (mot entier) seront trouvées.</li>
<li>-terme : ne pas inclure les résultats contenant ce terme.</li>
</ul>';
$string['search_help'] = 'Pour une recherche simple d\'un ou de plusieurs mots n\'importe où dans le texte, il suffit de les taper, en les séparant par des espaces. Les mots de moins de 3 caractères sont ignorés.

Pour des critères de recherche plus pointus, cliquez sur le bouton sans taper quoi que ce soit dans les différents champs. Un formulaire complet s\'affichera, vous permettant de spécifier plus précisément votre recherche.';
$string['searchoptions'] = 'Options de recherche';
$string['searchresults'] = 'Résultats de la recherche';
$string['sec'] = 's';
$string['seconds'] = 'secondes';
$string['secondstotime172800'] = '2 jours';
$string['secondstotime259200'] = '3 jours';
$string['secondstotime345600'] = '4 jours';
$string['secondstotime432000'] = '5 jours';
$string['secondstotime518400'] = '6 jours';
$string['secondstotime604800'] = '1 semaine';
$string['secondstotime86400'] = '1 jour';
$string['secretalreadyused'] = 'Le lien de confirmation du changement de mot de passe a déjà été utilisé. Le mot de passe n\'a pas été modifié.';
$string['secs'] = 's';
$string['section'] = 'Section';
$string['sectionname'] = 'Nom de section';
$string['sections'] = 'Sections';
$string['sectionusedefaultname'] = 'Utiliser le nom de section par défaut';
$string['seealsostats'] = 'Voir aussi les statistiques';
$string['selctauser'] = 'Sélectionner un utilisateur';
$string['select'] = 'Sélectionner';
$string['selectacategory'] = 'Veuillez sélectionner une catégorie';
$string['selectacountry'] = 'Choisir un pays';
$string['selectacourse'] = 'Sélectionner un cours';
$string['selectacoursesite'] = 'Sélectionner un cours ou un site';
$string['selectagroup'] = 'Sélectionner un groupe';
$string['selectall'] = 'Tout sélectionner';
$string['selectamodule'] = 'Veuillez choisir un module d\'activité';
$string['selectanaction'] = 'Sélectionner une action';
$string['selectanoptions'] = 'Sélectionner une option';
$string['selectaregion'] = 'Sélectionner une zone';
$string['selectcategorysort'] = 'Quelles catégories voulez-vous trier ?';
$string['selectcategorysortby'] = 'Choisissez comment vous voulez trier les catégories';
$string['selectcoursesortby'] = 'Choisissez comment vous voulez trier les cours';
$string['selectdefault'] = 'Sélection par défaut';
$string['selectedcategories'] = 'Catégories sélectionnées';
$string['selectedfile'] = 'Fichier sélectionné';
$string['selectednowmove'] = '{$a} fichiers sélectionnés pour déplacement. Allez maintenant dans le dossier de destination désiré et cliquez sur « Déplacer les fichiers ici »';
$string['selectfiles'] = 'Sélectionner des fichiers';
$string['selectmoduletoviewhelp'] = 'Sélectionnez une activité ou une ressource pour afficher l\'aide à son sujet.

Double-cliquez sur le nom d\'une activité ou d\'une ressource pour l\'ajouter rapidement.';
$string['selectnos'] = 'Sélectionner tous les « Non »';
$string['selectperiod'] = 'Sélectionner une période';
$string['senddetails'] = 'Envoyer un nouveau mot de passe par courriel';
$string['separate'] = 'Séparer';
$string['separateandconnected'] = 'Appropriation du savoir liée ou détachée';
$string['separateandconnectedinfo'] = 'Ce barème est fondé sur une théorie qui traite de la relation que l\'apprenant entretient avec son entourage et ce qu\'il doit apprendre : il peut adopter une attitude empathique ou objective (<strong>Theory of separate and connected knowing</strong>).<ul>
<li><strong>Un apprenant « détaché »</strong> reste aussi objectif que possible, ne faisant pas intervenir ses émotions et ses sensations. Dans une discussion avec des interlocuteurs d\'avis différents, il préfère défendre ses propres idées, cherchant les failles des arguments de son adversaire à l\'aide de la logique.</li>
<li><strong>Un apprenant « lié »</strong> est plus empathique. Il est sensible et tend à écouter et poser des questions aux gens jusqu\'à ce qu\'il sente qu\'il peut être en connexion avec eux et comprendre les choses de leur point de vue. Il apprend en essayant de partager les expériences qui conduisent au savoir qu\'elle trouve chez les autres.</li></ul>';
$string['servererror'] = 'Une erreur est survenue lors de la communication avec le serveur';
$string['serverlocaltime'] = 'Heure locale du serveur';
$string['setcategorytheme'] = 'Choisir le thème de la catégorie';
$string['setpassword'] = 'Définir mot de passe';
$string['setpasswordinstructions'] = 'Veuillez saisir et répéter votre nouveau mot de passe ci-dessous, puis cliquer sur « Enregistrer ».<br />Votre nouveau mot de passe sera alors enregistré et vous serez connecté.';
$string['settings'] = 'Paramètres';
$string['shortname'] = 'Nom abrégé';
$string['shortnamecollisionwarning'] = '[*] = Un cours avec ce nom abrégé existe déjà et devra être modifié lors de l\'approbation';
$string['shortnamecourse'] = 'Nom abrégé du cours';
$string['shortnamecourse_help'] = 'Le nom abrégé du cours est affiché dans la piste de navigation et est utilisé dans l\'objet des messages de courriel du cours.';
$string['shortnametaken'] = 'Ce nom abrégé est déjà utilisé pour un autre cours ({$a})';
$string['shortnameuser'] = 'Nom abrégé';
$string['shortsitename'] = 'Nom abrégé du site (p. ex. un mot)';
$string['show'] = 'Afficher';
$string['showactions'] = 'Afficher les actions';
$string['showadvancedsettings'] = 'Afficher les réglages avancés';
$string['showall'] = 'Afficher tous les {$a}';
$string['showallcourses'] = 'Afficher tous les cours';
$string['showallusers'] = 'Afficher tous les utilisateurs';
$string['showblockcourse'] = 'Afficher les cours contenant le bloc';
$string['showcategory'] = 'Afficher {$a}';
$string['showcomments'] = 'Afficher/cacher les commentaires';
$string['showcommentsnonjs'] = 'Afficher les commentaires';
$string['showdescription'] = 'Afficher la description sur la page de cours';
$string['showdescription_help'] = 'Si ce réglage est activé, la description ci-dessus sera affichée sur la page du cours, juste au-dessous du lien vers l\'activité ou la ressource.';
$string['showgrades'] = 'Afficher le carnet de notes aux étudiants';
$string['showgrades_help'] = 'Plusieurs activités d\'un cours peuvent être évaluées au moyen de notes. Ce réglage détermine si un étudiant peut voir une liste de toutes ses notes données dans ce cours, en cliquant sur le lien « Notes » dans le bloc d\'administration du cours.';
$string['showingacourses'] = 'Affichage de tous les {$a} cours';
$string['showingxofycourses'] = 'Affichage des cours {$a->start} à {$a->end} sur un total de {$a->total} cours';
$string['showlistofcourses'] = 'Afficher la liste des cours';
$string['showmodulecourse'] = 'Afficher les cours contenant l\'activité';
$string['showonly'] = 'Afficher uniquement';
$string['showperpage'] = 'Afficher {$a} par page';
$string['showrecent'] = 'Afficher les événements récents';
$string['showreports'] = 'Afficher les rapports d\'activités';
$string['showreports_help'] = 'Les rapports d\'activité sont disponibles pour chaque participant qui affiche ses activités dans le cours. En plus d\'une liste de ses contributions, comme les messages d\'un forum ou les soumissions d\'un devoir, ces rapports incluent également des journaux d\'accès. Ce paramètre détermine si un étudiant peut consulter ses propres rapports d\'activité via sa page de profil.';
$string['showsettings'] = 'Afficher les réglages';
$string['showtheselogs'] = 'Afficher cet historique';
$string['showthishelpinlanguage'] = 'Afficher cette aide dans la langue : {$a}';
$string['since'] = 'Depuis';
$string['sincelast'] = 'depuis la dernière connexion';
$string['site'] = 'Site';
$string['sitedefault'] = 'Réglages par défaut du site';
$string['siteerrors'] = 'Erreurs du site';
$string['sitefiles'] = 'Fichiers du site';
$string['sitefilesused'] = 'Fichiers du site utilisés dans ce cours';
$string['sitehome'] = 'Accueil du site';
$string['sitelegacyfiles'] = 'Fichiers de site obsolètes';
$string['sitelogs'] = 'Historiques du site';
$string['sitemessage'] = 'Envoyer un message aux utilisateurs';
$string['sitenews'] = 'Brèves';
$string['sitepages'] = 'Pages du site';
$string['sitepartlist'] = 'Vous n\'avez pas les autorisations nécessaires pour voir la liste des participants';
$string['sitepartlist0'] = 'Vous devez être enseignant du site pour voir la liste des participants du site';
$string['sitepartlist1'] = 'Vous devez être enseignant pour voir la liste des participants';
$string['sites'] = 'Sites';
$string['sitesection'] = 'Inclure une section descriptive';
$string['sitesettings'] = 'Page d\'accueil';
$string['siteteachers'] = 'Enseignants de la page d\'accueil';
$string['size'] = 'Taille';
$string['sizeb'] = 'octets';
$string['sizegb'] = 'Go';
$string['sizekb'] = 'Ko';
$string['sizemb'] = 'Mo';
$string['skipped'] = 'Sauté';
$string['skiptocategorylisting'] = 'Passer à la liste des catégories';
$string['skiptocoursedetails'] = 'Passer aux informations détaillées des cours';
$string['skiptocourselisting'] = 'Passer à la liste des cours';
$string['skypeid'] = 'Identifiant Skype';
$string['socialheadline'] = 'Forum public - derniers sujets';
$string['someallowguest'] = 'Les visiteurs anonymes peuvent accéder à<br />certains cours';
$string['someerrorswerefound'] = 'Certaines informations manquent ou sont incorrectes. Voir ci-dessous.';
$string['sort'] = 'Trier';
$string['sortby'] = 'Trier par';
$string['sortbyx'] = 'Tri croissant par {$a}';
$string['sortbyxreverse'] = 'Tri décroissant par {$a}';
$string['sortcategoriesbyidnumber'] = 'Trier les catégories par identifiant';
$string['sortcategoriesbyname'] = 'Trier les catégories par nom';
$string['sortcoursesbyfullname'] = 'Trier les cours par nom complet';
$string['sortcoursesbyidnumber'] = 'Trier les cours par identifiant';
$string['sortcoursesbyshortname'] = 'Trier les cours par nom abrégé';
$string['sorting'] = 'Tri';
$string['sourcerole'] = 'Rôle source';
$string['specifyname'] = 'Vous devez indiquer un nom.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = cours en attente d\'approbation)';
$string['startdate'] = 'Date de début du cours';
$string['startdate_help'] = 'Ce réglage indique le début de la première semaine d\'un cours en format hebdomadaire. Il spécifie aussi la plus ancienne date pouvant être affichée dans le journal des événements.';
$string['startingfrom'] = 'À partir de';
$string['startsignup'] = 'Créer un compte';
$string['state'] = 'Canton, département';
$string['statistics'] = 'Statistiques';
$string['statisticsgraph'] = 'Graphique des statistiques';
$string['stats'] = 'Statistiques';
$string['statslogins'] = 'Connexions';
$string['statsmodedetailed'] = 'Vue détaillée';
$string['statsmodegeneral'] = 'Vue d\'ensemble';
$string['statsnodata'] = 'Aucune donnée disponible pour ce cours et cette période.';
$string['statsnodatauser'] = 'Aucune donnée disponible pour ce cours, cet utilisateur et cette période.';
$string['statsoff'] = 'Les statistiques ne sont actuellement pas activées';
$string['statsreads'] = 'Affichages';
$string['statsreport1'] = 'Connexions';
$string['statsreport10'] = 'Activités des utilisateurs';
$string['statsreport11'] = 'Cours les plus actifs';
$string['statsreport12'] = 'Cours les plus actifs (pondérés)';
$string['statsreport13'] = 'Cours avec le plus de participation (inscriptions)';
$string['statsreport14'] = 'Cours avec le plus de participation (affichages/messages)';
$string['statsreport2'] = 'Affichages (tous les rôles)';
$string['statsreport3'] = 'Messages (tous les rôles)';
$string['statsreport4'] = 'Toutes les activités (tous les rôles)';
$string['statsreport5'] = 'Toutes les activités (consultations et messages)';
$string['statsreport7'] = 'Activités des utilisateurs (consultations et messages)';
$string['statsreport8'] = 'Toutes les activités';
$string['statsreport9'] = 'Connexion (cours de site)';
$string['statsreportactivity'] = 'Toutes les activités (tous les rôles)';
$string['statsreportactivitybyrole'] = 'Toutes les activités (affichages et messages)';
$string['statsreportforuser'] = 'pour';
$string['statsreportlogins'] = 'Connexions';
$string['statsreportreads'] = 'Affichages (tous les rôles)';
$string['statsreporttype'] = 'Type de rapport';
$string['statsreportwrites'] = 'Messages (tous les rôles)';
$string['statsstudentactivity'] = 'Activité des étudiants';
$string['statsstudentreads'] = 'Consultations des étudiants';
$string['statsstudentwrites'] = 'Messages des étudiants';
$string['statsteacheractivity'] = 'Activité des enseignants';
$string['statsteacherreads'] = 'Consultations des enseignants';
$string['statsteacherwrites'] = 'Messages des enseignants';
$string['statstimeperiod'] = 'Période :';
$string['statsuniquelogins'] = 'Connexions distinctes';
$string['statsuseractivity'] = 'Toutes activités';
$string['statsuserlogins'] = 'Connexions';
$string['statsuserreads'] = 'Consultations';
$string['statsuserwrites'] = 'Messages';
$string['statswrites'] = 'Messages';
$string['status'] = 'Statut';
$string['stringsnotset'] = 'Les textes suivants ne sont pas définis dans {$a}';
$string['studentnotallowed'] = 'Désolé, mais vous ne pouvez entrer dans ce cours en tant que « {$a} »';
$string['students'] = 'Étudiants';
$string['studentsandteachers'] = 'Étudiants et enseignants';
$string['subcategories'] = 'Sous-catégories';
$string['subcategory'] = 'Sous-catégorie';
$string['subcategoryof'] = 'Sous-catégorie de {$a}';
$string['submit'] = 'Envoyer';
$string['success'] = 'Succès';
$string['summary'] = 'Résumé';
$string['summary_help'] = 'Le résumé de section est un texte assez bref destiné à préparer les étudiants aux activités présentées dans la section (thématique ou hebdomadaire). Le texte est affiché sur la page du cours, au-dessous du titre de la section.';
$string['summaryof'] = 'Résumé de {$a}';
$string['supplyinfo'] = 'Plus de détails';
$string['suspended'] = 'Suspendu';
$string['suspendedusers'] = 'Utilisateurs suspendus';
$string['switchdevicedefault'] = 'Passer au thème standard';
$string['switchdevicerecommended'] = 'Passer au thème recommandé pour votre appareil';
$string['switchrolereturn'] = 'Retour à mon rôle normal';
$string['switchroleto'] = 'Prendre le rôle...';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Ce tag existe déjà';
$string['tagmanagement'] = 'Ajouter/supprimer des tags...';
$string['tags'] = 'Tags';
$string['targetrole'] = 'Rôle cible';
$string['teacheronly'] = 'pour {$a} uniquement';
$string['teacherroles'] = 'Rôles de {$a}';
$string['teachers'] = 'Enseignants';
$string['textediting'] = 'Éditeur de texte';
$string['texteditor'] = 'Utiliser les formulaires HTML standard';
$string['textformat'] = 'Format texte';
$string['thanks'] = 'Merci';
$string['theme'] = 'Thème';
$string['themes'] = 'Thèmes';
$string['themesaved'] = 'Nouveau thème enregistré';
$string['therearecourses'] = 'Il y a {$a} cours';
$string['thereareno'] = 'Il n\'y a pas de {$a} dans ce cours';
$string['thiscategory'] = 'Cette catégorie';
$string['thiscategorycontains'] = 'Cette catégorie contient';
$string['time'] = 'Heure';
$string['timezone'] = 'Fuseau horaire';
$string['to'] = 'À';
$string['tocontent'] = 'Vers l\'élément « {$a} »';
$string['tocreatenewaccount'] = 'Procédure de création de compte';
$string['today'] = 'Aujourd\'hui';
$string['todaylogs'] = 'Historique d\'aujourd\'hui';
$string['toeveryone'] = 'Pour tout le monde';
$string['toomanybounces'] = 'Cette adresse de courriel a généré trop de rebonds. Vous <b>devez</b> la changer pour continuer.';
$string['toomanytoshow'] = 'Trop d\'utilisateurs pour les afficher tous.';
$string['toomanyusersmatchsearch'] = 'Trop d\'utilisateurs ({$a->count}) correspondent à « {$a->search} »';
$string['toomanyuserstoshow'] = 'Trop d\'utilisateurs ({$a}) à afficher';
$string['toonly'] = 'Seulement pour les {$a}';
$string['top'] = 'Niveau supérieur';
$string['topic'] = 'Section';
$string['topichide'] = 'Cacher cette section pour {$a}';
$string['topicoutline'] = 'Aperçu des sections';
$string['topicshow'] = 'Afficher cette section pour {$a}';
$string['toplevelcategory'] = 'Catégorie racine';
$string['total'] = 'Total';
$string['totopofsection'] = 'En haut de la section « {$a} »';
$string['trackforums'] = 'Suivi des forums';
$string['trackforumsno'] = 'Non, ne pas signaler les messages non lus';
$string['trackforumsyes'] = 'Oui, me signaler les nouveaux messages';
$string['trysearching'] = 'Essayez plutôt la recherche.';
$string['turneditingoff'] = 'Quitter le mode édition';
$string['turneditingon'] = 'Activer le mode édition';
$string['undecided'] = 'Pas d\'avis';
$string['unfinished'] = 'Pas terminé';
$string['unknowncategory'] = 'Catégorie de cours inconnue';
$string['unknownerror'] = 'Erreur inconnue';
$string['unlimited'] = 'Illimité';
$string['unpacking'] = 'Décompactage de {$a}';
$string['unsafepassword'] = 'Ce mot de passe n\'est pas sûr. Essayez-en un autre.';
$string['untilcomplete'] = 'Jusqu\'à la fin du traitement';
$string['unusedaccounts'] = 'Les comptes qui n\'ont pas été utilisés depuis {$a} jours sont automatiquement désinscrits.';
$string['unzip'] = 'Décompacter (zip)';
$string['unzippingbackup'] = 'Décompactage (zip) de la sauvegarde';
$string['up'] = 'Vers le haut';
$string['update'] = 'Modifier';
$string['updated'] = '{$a} modifié(e)';
$string['updatemymoodleoff'] = 'Quitter le mode édition';
$string['updatemymoodleon'] = 'Modifier cette page';
$string['updatemyprofile'] = 'Enregistrer le profil';
$string['updatesevery'] = 'Mise à jour toutes les {$a} secondes';
$string['updatethis'] = 'Modifier {$a}';
$string['updatethiscourse'] = 'Modifier ce cours';
$string['updatinga'] = 'Modification {$a}';
$string['updatingain'] = 'Modification {$a->what} dans {$a->in}';
$string['upload'] = 'Déposer';
$string['uploadafile'] = 'Déposer un fichier';
$string['uploadcantwrite'] = 'Échec de l\'écriture du fichier';
$string['uploadedfile'] = 'Le fichier a été déposé avec succès';
$string['uploadedfileto'] = 'Le fichier « {$a->file} » a été déposé dans le dossier « {$a->directory} »';
$string['uploadedfiletoobig'] = 'Ce fichier dépasse la taille maximale (fixée à {$a} octets)';
$string['uploadextension'] = 'Dépôt du fichier arrêté par une extension PHP';
$string['uploadfailednotrecovering'] = 'Le dépôt de votre fichier a échoué car un des fichiers, {$a->name}, a posé problème.<br />Voici une liste des problèmes rencontrés :<br />{$a->problem}<br />Impossible de rattraper l\'erreur.';
$string['uploadfilelog'] = 'Historique du dépôt du fichier {$a}';
$string['uploadformlimit'] = 'La taille du fichier déposé {$a} dépasse la limite fixée par le formulaire';
$string['uploadlabel'] = 'Titre :';
$string['uploadlimitwithsize'] = 'Taille limite de dépôt {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Déposer un fichier';
$string['uploadnofilefound'] = 'Aucun fichier trouvé. En avez-vous vraiment choisi un à déposer ?';
$string['uploadnotallowed'] = 'Il n\'est pas permis de déposer des fichiers';
$string['uploadnotempdir'] = 'Dossier temporaire manquant';
$string['uploadoldfilesdeleted'] = 'Les anciens fichiers de votre zone de dépôt ont été supprimés';
$string['uploadpartialfile'] = 'Le fichier n\'a été que partiellement transféré';
$string['uploadproblem'] = 'Un problème inconnu est survenu lors du dépôt du fichier « {$a} » (peut-être est-il trop gros ?)';
$string['uploadrenamedchars'] = 'Le nom du fichier a été changé de {$a->oldname} à {$a->newname} à cause de caractères non valides.';
$string['uploadrenamedcollision'] = 'Le nom du fichier a été changé de {$a->oldname} à {$a->newname} en raison d\'un conflit de nom.';
$string['uploadserverlimit'] = 'La taille du fichier déposé dépasse la taille maximale fixée par le serveur';
$string['uploadthisfile'] = 'Déposer ce fichier';
$string['url'] = 'URL';
$string['used'] = 'Utilisé';
$string['usedinnplaces'] = 'Utilisé à {$a} endroits';
$string['usemessageform'] = 'ou utiliser le formulaire ci-dessous pour envoyer un message aux étudiants sélectionnés';
$string['user'] = 'Utilisateur';
$string['userconfirmed'] = 'L\'utilisateur {$a} a été confirmé';
$string['usercurrentsettings'] = 'Réglages de mon profil';
$string['userdata'] = 'Données utilisateurs';
$string['userdeleted'] = 'Le compte de cet utilisateur a été supprimé';
$string['userdescription'] = 'Description';
$string['userdescription_help'] = 'Ce champ vous permet d\'écrire quelques mots sur vous-même. Le texte sera affiché sur votre page de profil.';
$string['userdetails'] = 'Informations détaillées';
$string['userfiles'] = 'Fichiers utilisateur';
$string['userlist'] = 'Liste des utilisateurs';
$string['username'] = 'Nom d\'utilisateur';
$string['usernameemailmatch'] = 'Le nom d\'utilisateur et l\'adresse de courriel données ne correspondent pas au même utilisateur';
$string['usernameexists'] = 'Ce nom d\'utilisateur existe déjà, veuillez en choisir un autre';
$string['usernamelowercase'] = 'Seules les minuscules sont autorisées';
$string['usernamenotfound'] = 'Ce nom d\'utilisateur n\'a pas été trouvé dans la base de données';
$string['usernameoremail'] = 'Veuillez indiquer soit le nom d\'utilisateur, soit l\'adresse de courriel';
$string['usernotconfirmed'] = 'L\'utilisateur {$a} n\'a pas pu être confirmé';
$string['userpic'] = 'Image de l\'utilisateur';
$string['users'] = 'Utilisateurs';
$string['userselectorautoselectunique'] = 'Si un seul utilisateur correspond à la recherche, le sélectionner automatiquement';
$string['userselectorpreserveselected'] = 'Conserver les utilisateurs sélectionnés, même s\'ils ne correspondent plus à la recherche';
$string['userselectorsearchanywhere'] = 'Le critère de recherche peut apparaître n\'importe où dans les champs affichés';
$string['usersnew'] = 'Nouveaux utilisateurs';
$string['usersnoaccesssince'] = 'Inactifs depuis plus de';
$string['userswithfiles'] = 'Utilisateurs avec fichiers';
$string['useruploadtype'] = 'Type de téléchargement d\'utilisateurs : {$a}';
$string['userviewingsettings'] = 'Profil de {$a}';
$string['userzones'] = 'Zones de l\'utilisateur';
$string['usetheme'] = 'Utiliser le thème';
$string['usingexistingcourse'] = 'Avec un cours existant';
$string['valuealreadyused'] = 'Cette valeur est déjà utilisée.';
$string['version'] = 'Version';
$string['view'] = 'Affichage';
$string['viewallcourses'] = 'Afficher tous les cours';
$string['viewallcoursescategories'] = 'Afficher tous les cours et catégories';
$string['viewallsubcategories'] = 'Voir toutes les sous-catégories';
$string['viewfileinpopup'] = 'Afficher dans une fenêtre surgissante';
$string['viewing'] = 'Affichage :';
$string['viewmore'] = 'Voir plus';
$string['viewprofile'] = 'Consulter le profil';
$string['views'] = 'Affichages';
$string['viewsolution'] = 'Afficher la solution';
$string['virusfound'] = 'Attention ! Clam AV a détecté un virus dans un fichier déposé par {$a->user} dans le cours {$a->course}. Voici la sortie du programme clamscan :';
$string['virusfoundlater'] = 'Le fichier que vous avez déposé le {$a->date}, dont le nom est {$a->filename} (dans le cours {$a->course}) contient un virus. Voici un résumé de ce qui est arrivé à votre fichier :

{$a->action}

S\'il s\'agissait d\'un devoir rendu (ou de tout autre document), vous devez le déposer à nouveau afin que l\'enseignant puisse le consulter.';
$string['virusfoundlateradmin'] = 'Attention ! Un fichier déposé par l\'utilisateur {$a->user} le {$a->date}, dont le nom est {$a->filename} (dans le cours {$a->course}) contient un virus. Voici un résumé de ce qui est arrivé à ce fichier :

{$a->action}

L\'utilisateur en a été informé.';
$string['virusfoundlateradminnolog'] = 'Attention ! Un fichier de nom {$a->filename} contient un virus. Moodle n\'a pas été capable de déterminer l\'utilisateur qui l\'avait déposé.

Voici un résumé de ce qui est arrivé à ce fichier :

{$a->action}';
$string['virusfoundsubject'] = '{$a} : Virus détecté !';
$string['virusfounduser'] = 'Le fichier que vous avez déposé, {$a->filename}, a été inspecté par un anti-virus et un virus y a été découvert ! Votre fichier n\'a donc pas été déposé.';
$string['virusplaceholder'] = 'Un virus a été détecté dans ce fichier déposé. Il a été déplacé ou détruit, et l\'utilisateur en a été informé.';
$string['visible'] = 'Visible';
$string['visible_help'] = 'Cette option détermine si le cours apparaît ou non dans la liste des cours. Si le cours n\'est pas disponible, seuls les enseignants de ce cours et les administrateurs peuvent y entrer.';
$string['visibletostudents'] = 'Visible pour les étudiants';
$string['warning'] = 'Avertissement';
$string['warningdeleteresource'] = 'Attention ! {$a} est référencé dans une ressource. Voulez-vous mettre à jour la ressource ?';
$string['webpage'] = 'Page Web';
$string['week'] = 'Semaine';
$string['weekhide'] = 'Cacher cette semaine pour {$a}';
$string['weeklyoutline'] = 'Aperçu des semaines';
$string['weeks'] = 'semaines';
$string['weekshow'] = 'Afficher cette semaine pour {$a}';
$string['welcometocourse'] = 'Bienvenue sur {$a}';
$string['welcometocoursetext'] = 'Bienvenue au cours « {$a->coursename} » !

Pour commencer, nous vous invitons à modifier et compléter votre profil :
{$a->profileurl}

Bon travail dans ce cours !';
$string['whatforlink'] = 'Que voulez-vous faire avec ce lien ?';
$string['whatforpage'] = 'Que voulez-vous faire avec ce texte ?';
$string['whattocallzip'] = 'Quel nom voulez-vous donner au fichier compacté (zip) ?';
$string['whattodo'] = 'Action à effectuer';
$string['windowclosing'] = 'Cette fenêtre se fermera automatiquement. Sinon, fermez-la maintenant.';
$string['withchosenfiles'] = 'Avec les fichiers choisis';
$string['withdisablednote'] = '{$a} (désactivé)';
$string['withoutuserdata'] = 'sans les données des utilisateurs';
$string['withselectedusers'] = 'Pour les utilisateurs sélectionnés...';
$string['withselectedusers_help'] = '* Envoyer un message : pour envoyer un message à un ou plusieurs participants
* Ajouter une annotation : pour ajouter une annotation sur le participant sélectionné
* Ajouter une annotation commune : pour ajouter une même annotation sur plusieurs participants';
$string['withuserdata'] = 'avec les données des utilisateurs';
$string['wordforstudent'] = 'Votre terme pour « étudiant »';
$string['wordforstudenteg'] = 'exemples : étudiant, apprenti, participant, ...';
$string['wordforstudents'] = 'Votre terme pour « étudiants »';
$string['wordforstudentseg'] = 'exemples : étudiants, apprentis, participants, ...';
$string['wordforteacher'] = 'Votre terme pour « enseignant »';
$string['wordforteachereg'] = 'exemples : enseignant, professeur, gourou, ...';
$string['wordforteachers'] = 'Votre terme pour « enseignants »';
$string['wordforteacherseg'] = 'exemples : enseignants, professeurs, gourous, ...';
$string['writingblogsinfo'] = 'Écriture des informations de blogs';
$string['writingcategoriesandquestions'] = 'Écriture des catégories et questions';
$string['writingcoursedata'] = 'Écriture des données du cours';
$string['writingeventsinfo'] = 'Écriture du calendrier';
$string['writinggeneralinfo'] = 'Écriture des informations générales';
$string['writinggradebookinfo'] = 'Écriture des carnets de notes';
$string['writinggroupingsgroupsinfo'] = 'Écriture des infos groupements-groupes';
$string['writinggroupingsinfo'] = 'Écriture des groupements';
$string['writinggroupsinfo'] = 'Écriture des groupes';
$string['writingheader'] = 'Écriture de l\'entête';
$string['writingloginfo'] = 'Écriture des historiques';
$string['writingmessagesinfo'] = 'Écriture des informations des messages';
$string['writingmoduleinfo'] = 'Écriture des modules';
$string['writingscalesinfo'] = 'Écriture des barèmes';
$string['writinguserinfo'] = 'Écriture des utilisateurs';
$string['wrongpassword'] = 'Mot de passe incorrect pour cet utilisateur';
$string['yahooid'] = 'Identifiant Yahoo';
$string['year'] = 'année';
$string['years'] = 'années';
$string['yes'] = 'Oui';
$string['youareabouttocreatezip'] = 'Vous allez créer un fichier compacté (zip) contenant';
$string['youaregoingtorestorefrom'] = 'Vous allez restaurer depuis';
$string['youneedtoenrol'] = 'Vous devez vous inscrire à ce cours pour effectuer cette action.';
$string['yourlastlogin'] = 'Votre dernière connexion';
$string['yourself'] = 'vous';
$string['yourteacher'] = 'votre {$a}';
$string['yourwordforx'] = 'Votre terme pour « {$a} »';
$string['zippingbackup'] = 'Compactage (zip) de la sauvegarde';
