<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'fr', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Accès refusé';
$string['accounts'] = 'Comptes';
$string['addcategory'] = 'Ajouter une catégorie';
$string['additionalhtml'] = 'HTML additionnel';
$string['additionalhtml_desc'] = 'Ces réglages vous permettent de spécifier du code HTML que vous voulez ajouter à chaque page. Cette possibilité existe pour du code à ajouter dans la balise HEAD de la page, ou immédiatement après l\'ouverture de la balise BODY, ou juste avant la fermeture de la balise BODY.<br />Cela vous permet d\'ajouter à chaque page une entête ou un pied de page personnalisé, ou d\'appeler des scripts pour des services tels que Google Analytics, indépendamment du thème choisi pour l\'affichage de votre site.';
$string['additionalhtmlfooter'] = 'Avant la fermeture de BODY';
$string['additionalhtmlfooter_desc'] = 'Ce contenu sera ajouté à chaque page, juste avant la fermeture de la balise BODY.';
$string['additionalhtmlhead'] = 'Dans HEAD';
$string['additionalhtmlhead_desc'] = 'Ce contenu sera ajouté à chaque page, en bas de la balise HEAD.';
$string['additionalhtml_heading'] = 'HTML additionnel à ajouter à chaque page';
$string['additionalhtmltopofbody'] = 'Lorsque BODY est ouvert';
$string['additionalhtmltopofbody_desc'] = 'Ce contenu sera ajouté à chaque page, juste après l\'ouverture de la balise BODY.';
$string['admincategory'] = 'Catégorie {$a}';
$string['adminseesall'] = 'Les administrateurs voient tout';
$string['adminseesallevents'] = 'Les administrateurs voient tous les événements';
$string['adminseesownevents'] = 'Les administrateurs sont comme tous les autres utilisateurs';
$string['advancedfeatures'] = 'Fonctions avancées';
$string['allcountrycodes'] = 'Tous les codes de pays';
$string['allowbeforeblock'] = 'La liste des adresses IP permises est traitée en premier';
$string['allowbeforeblockdesc'] = 'Par défaut, la liste des adresses IP bloquées est traitée en premier. Lorsque cette option est activée, la liste des adresses IP autorisées sera traitée en premier.';
$string['allowblockstodock'] = 'Permettre aux blocs d\'utiliser le dock';
$string['allowcategorythemes'] = 'Autoriser les thèmes de catégories';
$string['allowcoursethemes'] = 'Autoriser les thèmes de cours';
$string['allowediplist'] = 'Liste des IP autorisées';
$string['allowemailaddresses'] = 'Domaines courriel autorisés';
$string['allowframembedding'] = 'Autoriser l\'intégration dans un cadre';
$string['allowframembedding_help'] = 'Permet l\'intégration de ce site dans un cadre sur des sites externes. L\'activation de cette fonctionnalité n\'est pas recommandée, pour des raisons de sécurité.';
$string['allowguestmymoodle'] = 'Permettre aux utilisateurs anonymes d\'accéder à Ma page';
$string['allowobjectembed'] = 'Autoriser les balises EMBED et OBJECT';
$string['allowthemechangeonurl'] = 'Autoriser le changement du thème dans l\'URL';
$string['allowuserblockhiding'] = 'Autoriser les utilisateurs à cacher les blocs';
$string['allowuserswitchrolestheycantassign'] = 'Autoriser les utilisateurs à basculer vers des rôles qu\'ils ne peuvent pas attribuer';
$string['allowuserthemes'] = 'Autoriser les thèmes utilisateur';
$string['antivirus'] = 'Anti-virus';
$string['appearance'] = 'Présentation';
$string['aspellpath'] = 'Chemin d\'accès du logiciel <i>aspell</i>';
$string['authentication'] = 'Authentification';
$string['authpreventaccountcreation'] = 'Empêcher la création de compte lors de l\'authentification';
$string['authpreventaccountcreation_help'] = 'Lorsqu\'un utilisateur s\'authentifie, un compte est créé automatiquement sur le site s\'il n\'existe pas encore. Si une base externe, par exemple LDAP, est utilisée pour l\'authentification et que vous désirez restreindre l\'accès à votre site aux seuls utilisateurs avec un compte existant, vous devez activer cette option. Les nouveaux comptes devront alors être créés manuellement ou importés via un fichier. Ce réglage ne s\'applique pas à l\'authentification MNet.';
$string['authsettings'] = 'Gestion de l\'authentification';
$string['autolang'] = 'Détection automatique de langue';
$string['autologinguests'] = 'Connecter automatiquement les visiteurs anonymes';
$string['availablelicenses'] = 'Licences disponibles';
$string['availableto'] = 'Disponible pour';
$string['backgroundcolour'] = 'Couleur transparente';
$string['backups'] = 'Sauvegardes';
$string['backup_shortname'] = 'Utiliser le nom du cours dans le nom du fichier de sauvegarde';
$string['backup_shortnamehelp'] = 'Utiliser le nom du cours dans le nom du fichier de sauvegarde';
$string['badwordsconfig'] = 'Taper ici votre liste de mots à censurer, séparés par des virgules.';
$string['badwordsdefault'] = 'Si votre liste de mots à censurer est vide, une liste de mots tirée du paquetage de langue sera utilisée.';
$string['badwordslist'] = 'Votre liste de mots à censurer';
$string['blockediplist'] = 'Liste des IP bloquées';
$string['blockeditingmenu'] = 'Menus d\'édition des blocs';
$string['blockeditingmenu_desc'] = 'Si ce réglage est activé, certaines icônes d\'édition des blocs seront affichées dans un menu déroulant, ce qui réduit l\'encombrement de l\'affichage en cachant les icônes tant qu\'elles ne sont pas utilisées.';
$string['blockinstances'] = 'Instances';
$string['blockmultiple'] = 'Multiple';
$string['blockprotect'] = 'Protéger les instances';
$string['blockprotect_help'] = 'Si vous verrouillez un type de bloc, personne ne pourra plus ajouter ni supprimer ce type de bloc. Il est bien sûr possible de déverrouiller si vous devez modifier certains blocs.

Ce réglage est destiné à protéger les blocs Navigation et Réglages, qui sont difficiles à récupérer lorsqu\'ils sont supprimés par inadvertance.';
$string['blocksettings'] = 'Gestion des blocs';
$string['blockunprotect'] = 'Déprotéger';
$string['bloglevel'] = 'Visibilité des blogs';
$string['bookmarkadded'] = 'Marque-page ajouté.';
$string['bookmarkalreadyexists'] = 'Vous avez déjà marqué cette page.';
$string['bookmarkdeleted'] = 'Marque-page supprimé.';
$string['bookmarkthispage'] = 'Marquer cette page';
$string['cacheapplication'] = 'Cache de l\'application';
$string['cacheapplicationhelp'] = 'Les éléments en cache sont partagés par tous les utilisateurs et arrivent à échéance après une durée déterminée (TTL).';
$string['cachejs'] = 'Mettre en cache le Javascript';
$string['cachejs_help'] = 'La mise en cache et compression du Javascript améliore de façon importante la performance de chargement des pages. Elle est vivement recommandée sur les sites en production. La désactivation de cette mise en page sera utile aux développeurs.';
$string['cacherequest'] = 'Requête cache';
$string['cacherequesthelp'] = 'Cache utilisateur qui arrive à échéance lorsque la requête est terminée. Destinée à remplacer les zones où des entrepôts statiques sont utilisés.';
$string['cachesession'] = 'Cache de session';
$string['cachesessionhelp'] = 'Cache utilisateur qui arrive à échéance lorsque la session se termine. Destinée à remédier aux problèmes de session.';
$string['cachesettings'] = 'Réglage de cache';
$string['cachetext'] = 'Durée de vie du cache texte';
$string['caching'] = 'Cache';
$string['calendarexportsalt'] = 'Sel de l\'exportation des calendriers';
$string['calendarsettings'] = 'Calendrier';
$string['calendartype'] = 'Type de calendrier';
$string['calendartype_desc'] = 'Sélectionner un type de calendrier par défaut pour tout le site. Ce réglage peut être court-circuité dans les réglages de chaque cours ou par les utilisateurs dans leur profil personnel.';
$string['calendar_weekend'] = 'Jours du week-end';
$string['cannotdeletemodfilter'] = 'Vous ne pouvez pas désinstaller « {$a->filter} », car il fait partie du module « {$a->module} ».';
$string['cannotuninstall'] = 'Désinstallation de {$a} impossible.';
$string['cfgwwwrootslashwarning'] = 'Le paramètre $CFG->wwwroot est défini incorrectement dans votre fichier config.php. Vous y avez placé une barre oblique « / » à la fin. Veuillez la retirer, sans quoi vous souffrirez de bogues bizarres, comme celui décrit ici : <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Le paramètre $CFG->wwwroot est défini incorrectement dans votre fichier config.php. Il ne correspond pas à l\'URL que vous utilisez pour accéder à cette page. Veuillez le corriger, sans quoi vous souffrirez de bogues bizarres, comme celui décrit ici : <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'Changer';
$string['checkboxno'] = 'Non';
$string['checkboxyes'] = 'Oui';
$string['choosefiletoedit'] = 'Sélectionnez le fichier à modifier';
$string['clamfailureonupload'] = 'Lors d\'un échec de clam AV';
$string['cleanup'] = 'Nettoyage';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'Erreur, valeur incorrecte « {$a->value} » pour le paramètre « {$a->option} »';
$string['cliincorrectvalueretry'] = 'Valeur incorrecte, veuillez réessayer';
$string['clistatusdisabled'] = 'Statut : désactivé';
$string['clistatusenabled'] = 'Statut : activé';
$string['clistatusenabledlater'] = 'Statut : le mode de maintenance CLI sera activé à {$a}';
$string['clitypevalue'] = 'type valeur';
$string['clitypevaluedefault'] = 'type valeur, tapez Entrée pour utiliser la valeur par défaut ({$a})';
$string['cliunknowoption'] = 'Options non reconnues :
 {$a}.
Utilisez l\'option --help.';
$string['cliupgradefinished'] = 'Mise à jour terminée avec succès.';
$string['cliupgradenoneed'] = 'Aucune mise à jour nécessaire pour la version installée {$a}. C\'était quand même sympa de venir !';
$string['cliyesnoprompt'] = 'Tapez y (pour oui) ou n (pour non)';
$string['commentsperpage'] = 'Commentaires affichés par page';
$string['commonfiltersettings'] = 'Réglages communs aux filtres';
$string['commonsettings'] = 'Réglages communs';
$string['componentinstalled'] = 'Composant installé';
$string['computedfromlogs'] = 'Calculé à partir des historiques depuis {$a}.';
$string['condifmodeditdefaults'] = 'Les valeurs par défaut sont utilisées dans les réglages des nouvelles activités ou ressources créées.';
$string['confeditorhidebuttons'] = 'Sélectionner les boutons ne devant pas apparaître dans la barre de l\'éditeur.';
$string['configallcountrycodes'] = 'La liste des codes des pays pouvant être choisis par les utilisateurs, par exemple dans le profil. Veuillez indiquer une liste des codes à deux caractères des pays désirés, séparés par des virgules, par exemple « GB,FR,ES ». Si ce champ n\'est pas renseigné (réglage par défaut), la liste standard du fichier « countries.php » du paquetage de langue francophone est utilisée. Cette liste est conforme au standard ISO 3166-1. Si vous indiquez dans ce champ d\'autres codes non standards, vous devrez les ajouter manuellement dans le fichier « countries.php » du paquetage « en » ainsi que dans celui de votre langue.';
$string['configallowassign'] = 'Vous pouvez permettre aux utilisateurs ayant un rôle de la colonne de gauche d\'attribuer certains rôles de chaque colonne à d\'autres utilisateurs';
$string['configallowblockstodock'] = 'Si ce réglage est activé et si le thème utilisé le supporte, les utilisateurs peuvent ranger les blocs dans un dock.';
$string['configallowcategorythemes'] = 'Si vous activez ce réglage, les thèmes pourront être définis au niveau des catégories. Le thème défini pour la catégorie sera hérité par toutes les sous-catégories et tous les cours qui s\'y trouvent, à moins qu\'un thème propre n\'y soit défini spécifiquement. ATTENTION ! L\'activation de cette option pourrait affecter la performance de votre site.';
$string['configallowcoursethemes'] = 'Si vous activez ce réglage, les thèmes pourront être définis au niveau des cours. Les thèmes de cours auront priorité sur tous les autres réglages de thème (thème du site, de la catégorie, de l\'utilisateur ou de la session).';
$string['configallowemailaddresses'] = 'Pour restreindre les adresses de courriel des nouveaux utilisateurs à certains domaines déterminés, saisissez ici les domaines autorisés, séparés par des espaces. Pour autoriser des sous-domaines, indiquez-les en les préfixant d\'un point, par exemple <strong>monecole.fr.ch .ecole.com</strong>. Les adresses de tous les autres domaines et sous-domaines seront rejetées.';
$string['configallowguestmymoodle'] = 'Si ce réglage est activé, les utilisateurs anonymes peuvent accéder à Ma page. Dans le cas contraire, les utilisateurs anonymes sont dirigés vers la page d\'accueil du site.';
$string['configallowobjectembed'] = 'Par mesure de sécurité, les utilisateurs normaux n\'ont pas la permission d\'inclure explicitement à l\'intérieur de textes des fichiers multimédias (par exemple Flash) à l\'aide de balises EMBED et OBJECT dans le code HTML. Ils peuvent cependant le faire de manière sûre avec le filtre multimédia. Si vous voulez autoriser l\'utilisation de ces balises, activez cette option.';
$string['configallowoverride'] = 'Vous pouvez permettre aux utilisateurs ayant un rôle de la colonne de gauche de définir pour d\'autres utilisateurs des dérogations aux rôles de chaque colonne';
$string['configallowoverride2'] = 'Sélectionnez les rôles pour lesquels les rôles de la colonne de gauche peuvent définir des dérogations.<br />Ce réglage ne s\'applique qu\'aux utilisateurs possédant la capacité moodle/role:override ou la capacité moodle/role:safeoverride.';
$string['configallowswitch'] = 'Sélectionnez les rôles vers lesquels un utilisateur pourra changer de rôle, sur la base des rôles qu\'il possède déjà. En plus d\'une indication dans ce tableau, l\'utilisateur doit également avoir la capacité moodle/role:switchroles pour pouvoir changer de rôle.<br />Il n\'est possible de changer de rôle que vers des rôles ayant la capacité moodle/course:view et n\'ayant pas la capacité moodle/site:doanything. C\'est pourquoi certaines colonnes de ce tableau sont inactives.';
$string['configallowthemechangeonurl'] = 'Si ce réglage est activé, le thème pourra être changé en ajoutant soit<br />theme=NomTheme à une URL de Moodle (par exemple : http://monsitemoodle.fr/?theme=afterburner), ou <br />&theme=themename à une URL  Moodle interne (par exemple : http://monsitemoodle.fr/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Voulez-vous autoriser les utilisateurs à cacher/afficher les blocs latéraux de ce site ? Cette fonctionnalité utilise Javascript et les cookies pour se souvenir de l\'état d\'affichage de chaque bloc. Elle n\'affecte que l\'affichage du site pour l\'utilisateur.';
$string['configallowuserswitchrolestheycantassign'] = 'Par défaut, la capacité moodle/role:assign est requise pour qu\'un utilisateur puisse basculer vers un autre rôle. L\'activation de ce réglage supprime cette condition, ce qui a pour résultat que le basculement vers d\'autres rôles n\'est déterminé que par le tableau « Autoriser les attributions de rôles ». Il est recommandé que la configuration de ce tableau ne permette pas de basculer vers un rôle comportant plus d\'autorisations que le rôle existant.';
$string['configallowuserthemes'] = 'Si vous activez ce réglage, les utilisateurs pourront choisir leur propre thème. Le thème choisi par l\'utilisateur aura priorité sur le thème du site (mais pas sur les thèmes des cours).';
$string['configallusersaresitestudents'] = 'Pour les activités affichées sur la page d\'accueil du site, TOUS les utilisateurs doivent-ils être considérés comme des étudiants ? Si vous choisissez « Oui », tout utilisateur possédant un compte confirmé pourra participer à ces activités en tant qu\'étudiant. Si vous choisissez « Non », seuls les participants d\'au moins un cours pourront accéder aux activités de la page d\'accueil.';
$string['configauthenticationplugins'] = 'Veuillez choisir les plugins d\'authentification que vous voulez utiliser et les arranger dans l\'ordre de vérification désiré.';
$string['configautolang'] = 'Détecter automatiquement la langue par défaut d\'après les réglages du navigateur, si la langue par défaut du site est désactivée.';
$string['configautologinguests'] = 'Connecter automatiquement en tant que visiteur anonyme les utilisateurs accédant directement à un cours ouvert aux visiteurs anonymes.';
$string['configbloglevel'] = 'Ce réglage permet de restreindre le niveau auquel les blogs des utilisateurs peuvent être consultés sur ce site. Veuillez remarquer que ce réglage indique le contexte maximal de la personne qui <em>consulte</em> le blog, et non l\'auteur, ni le type des messages de blog. Les blogs peuvent également être désactivés, si vous ne les voulez pas du tout.';
$string['configcachetext'] = 'Ce réglage permet d\'accélérer le temps de réponse des grands sites ou de ceux qui utilisent les filtres. Des copies des textes sont mémorisés pour la durée spécifiée ici. Une valeur trop petite peut allonger légèrement le temps de réponse, mais une valeur trop élevée pourrait engendrer une actualisation pas assez fréquente des textes (avec de nouveaux liens, par exemple).';
$string['configcalendarcustomexport'] = 'Activer intervalle de dates personnalisé dans l\'exportation des calendriers';
$string['configcalendarexportsalt'] = 'Ce texte aléatoire est utilisé pour améliorer la sécurité des jetons d\'authentification utilisés pour l\'exportation des calendriers. Si vous modifiez ce texte, tous les jetons en cours seront rendus non valides.';
$string['configclamactlikevirus'] = 'Traiter les fichiers comme des virus';
$string['configclamdonothing'] = 'Ne pas traiter les fichiers';
$string['configclamfailureonupload'] = 'Si vous avez configuré clam pour l\'inspection des fichiers déposés et que la configuration n\'est pas correcte ou que clam ne peut être lancé pour une autre raison, quel doit être le comportement ? Si vous indiquez « Traiter les fichiers comme des virus », ils seront déplacés vers un dossier de quarantaine ou détruits. Si vous indiquez « Ne pas traiter les fichiers », les fichiers seront déposés vers leur dossier de destination, sans être inspectés. Dans tous les cas, les administrateurs seront avertis que clam n\'a pas fonctionné. En outre, si vous indiquez « Traiter les fichiers comme des virus » et que clam ne peut pas fonctionner (d\'habitude parce que le chemin « pathtoclam » n\'est pas correct), TOUS les fichiers déposés seront déplacés vers le dossier de quarantaine ou détruits. Soyez prudent avec ce réglage !';
$string['configconvertformat'] = 'Si les exécutables <i>latex</i>, <i>dvips</i> et <i>convert</i> sont disponibles, les images seront créées en utilisant le format indiqué. Dans le cas contraire, mimeTeX sera utilisé pour créer des images en format GIF.';
$string['configcookiehttponly'] = 'Active une nouvelle fonctionnalité de PHP 5.2.0. Les navigateurs doivent envoyer les cookies en utilisant uniquement des requêtes http réelles. Les cookies ne devraient pas être accessibles des langues de script. Ce réglage n\'est pas supporté par tous les navigateurs et n\'est peut-être pas totalement compatible avec le code actuel. Il permet d\'éviter certains types d\'attaques XSS.';
$string['configcookiesecure'] = 'Si le serveur accepte uniquement des connexions https, il est recommandé d\'activer l\'envoi sécurisé des cookies. Une fois activé, assurez-vous que le serveur web n\'accepte pas http:// ou fournit une redirection permanente vers une adresse https://. Si l\'adresse <em>wwwroot</em> ne commence pas par https://, ce réglage est désactivé automatiquement.';
$string['configcountry'] = 'Si vous choisissez un pays ici, il sera sélectionné par défaut lors de la création de nouveaux comptes. Si vous souhaitez forcer les utilisateurs à choisir un pays, laissez ce champ vide.';
$string['configcourseoverviewfilesext'] = 'Une liste d\'extensions de nom de fichiers autorisées dans le résumé des cours (séparées par des virgules)';
$string['configcourseoverviewfileslimit'] = 'Le nombre maximal de fichiers pouvant être ajouté à un résumé de cours.';
$string['configcourserequestnotify'] = 'Indiquez le nom d\'utilisateur de la personne devant être informée lors de la demande de nouveaux cours.';
$string['configcourserequestnotify2'] = 'Les utilisateurs qui seront avertis lors d\'une demande de cours. Seuls les utilisateurs ayant le droit d\'approuver des demandes de cours sont affichés.';
$string['configcoursesperpage'] = 'Saisissez le nombre de cours à afficher par page dans la liste des cours.';
$string['configcourseswithsummarieslimit'] = 'Le nombre maximum de cours à afficher dans les listes des cours, y compris les résumés, avant de passer à une liste plus simple, sans les résumés.';
$string['configcronclionly'] = 'Lorsque ce réglage est activé, le script de cron ne peut être lancé que depuis un terminal, plutôt que par l\'intermédiaire d\'un navigateur web. Ce réglage ne tient pas compte du mot de passe de cron indiqué ci-dessous.';
$string['configcronremotepassword'] = 'Si un mot de passe est spécifié dans ce champ, le script de cron ne pourra être lancé depuis un navigateur web qu\'en fournissant ce mot de passe, suivant la syntaxe d\'URL :<pre>
http://site.exemple.fr/admin/cron.php?password=lemotdepasse
</pre>Si le champ n\'est pas renseigné, aucun mot de passe n\'est nécessaire.';
$string['configcurlcache'] = 'Durée de vie du cache cURL, en secondes.';
$string['configcustommenuitems'] = 'Vous pouvez définir ici un menu personnalisé qui sera affiché par les thèmes. Chaque ligne décrit un élément de menu, et est constituée du texte du menu, d\'une URL (optionnelle) et d\'un texte (optionnel) à afficher dans une infobulle et d\'un code de langue ou d\'une liste de tels codes séparés par des virgules (optionnel, pour permettre l\'affichage d\'éléments en fonction de la langue). Ces éléments sont séparés par des caractères « trait vertical » (|). Une structure hiérarchique peut être définie à l\'aide de tirets au début des lignes. Exemple :
<pre>
Communauté Moodle|https://moodle.org|Le site de la communauté Moodle
-Moodle en français|https://moodle.org/course/view.php?id=20
-Assistance gratuite Moodle|https://moodle.org/support
-Développement de Moodle|https://moodle.org/development
--Traqueur Moodle|http://tracker.moodle.org|Le traqueur de bogues de Moodle
--Moodle Docs|http://docs.moodle.org|La documentation de Moodle
--Moodle Docs en français|http://docs.moodle.org/fr|La documentation en français|fr
-Nouveautés Moodle|http://moodle.org/news
Entreprise Moodle
-Hébergement commercial Moodle|http://moodle.com/hosting
-Assistance commerciale Moodle|http://moodle.com/support
</pre>';
$string['configdbsessions'] = 'Si ce réglage est activé, les informations sur les sessions en cours seront enregistrées dans la base de données. Attention ! si vous changez ce réglage, tous les utilisateurs seront immédiatement déconnectés, vous y compris ! Si vous utilisez une base de données MySQL, assurez-vous que la variable « max_allowed_packet » dans <em>my.cnf</em> (ou <em>my.ini</em>) ait au moins une valeur de 4M. D\'autres pilotes de sessions peuvent être configurés directement dans le fichier config.php. Veuillez consulter le fichier config-dist.php pour plus d\'information. Ce réglage n\'est plus affiché si un tel pilote de session est configuré dans le fichier config.php.';
$string['configdebug'] = 'Si vous activez cette option, le paramètre PHP « error_reporting » sera augmenté afin que les avertissements soient affichés. Ceci est utile essentiellement pour les développeurs.';
$string['configdebugdisplay'] = 'Une fois ce réglage activé, les rapports d\'erreur seront affichés sur la page HTML. C\'est pratique, mais cela rend non conforme le XHTML, le JS, les cookies et les entêtes HTTP en général. Si le réglage est désactivé, les rapports sont écrits dans les historiques du serveur, permettant un meilleur débogage. Le réglage error_log de PHP contrôle dans quel fichier les rapports sont écrits.';
$string['configdebugpageinfo'] = 'Activer cette option pour afficher des informations concernant la page dans le pied de page.';
$string['configdebugsmtp'] = 'Activer le débogage des informations d\'envoi des messages courriel vers le serveur SMTP.';
$string['configdebugvalidators'] = 'Activer cette option si vous voulez que les liens vers des serveurs de validation soient visibles dans le pied de page. Il vous sera peut-être nécessaire de créer dans votre Moodle un nouvel utilisateur dont le nom d\'utilisateur est <em>w3cvalidator</em> et d\'activer l\'accès aux visiteurs anonymes. Ces modifications peuvent ouvrir l\'accès à votre serveur par des personnes non autorisées. Ne les activez pas sur des serveurs en production !';
$string['configdefaulthomepage'] = 'Ce réglage permet de déterminer la page d\'accueil des utilisateurs connectés';
$string['configdefaultrequestcategory'] = 'Les cours demandés par les utilisateurs seront automatiquement classés dans cette catégorie.';
$string['configdefaultrequestedcategory'] = 'Catégorie par défaut où placer les cours dont la demande a été approuvée.';
$string['configdefaultuserroleid'] = 'Tous les utilisateurs connectés auront les capacités du rôle spécifié ici, au niveau du site, EN PLUS de celles de tous les autres rôles qu\'ils ont déjà. Par défaut, il s\'agit du rôle « Utilisateur authentifié ». Il est à remarquer que cela n\'entrera pas en conflit avec les autres rôles disponibles, à moins que vous n\'interdisiez des capacités : cela permet simplement de s\'assurer que tous les utilisateurs possèdent les capacités qui ne peuvent être attribuées au niveau des cours (par exemple écrire des articles de blog, gérer son calendrier, etc.).';
$string['configdeleteincompleteusers'] = 'Après ce laps de temps, les anciens comptes dont la configuration n\'est pas terminée sont supprimés.';
$string['configdeleteunconfirmed'] = 'Si vous utilisez l\'authentification par courriel, c\'est la période pendant laquelle les confirmations des utilisateurs sont acceptées. À l\'échéance de cette période, les comptes non-confirmés sont supprimés.';
$string['configdenyemailaddresses'] = 'Pour interdire les adresses de courriel de certains domaines pour les nouveaux utilisateurs, saisissez ici les domaines rejetés, séparés par des espaces. Pour interdire des sous-domaines, indiquez-les en les préfixant d\'un point, par exemple <strong>hotmail.com yahoo.fr .live.com</strong>. Les adresses de tous les autres domaines seront acceptées.';
$string['configdisableuserimages'] = 'Désactiver la modification de l\'image des utilisateurs dans leur profil.';
$string['configdisplayloginfailures'] = 'Permet de proposer aux utilisateurs sélectionnés l\'affichage d\'informations sur les tentatives de connexion.';
$string['configdndallowtextandlinks'] = 'Activer ou désactiver le glisser-déposer de textes et de liens sur la page du cours, en plus du glisser-déposer des fichiers. Le glisser-déposer de textes avec Firefox ou entre différents navigateurs ne fonctionne pas de manière fiable et pourra avoir comme conséquence le dépôt de textes corrompus ou pas de dépôt du tout.';
$string['configdocroot'] = 'Définit l\'URL du site de documentation Moodle pour la documentation contextuelle signalée par « Documentation Moodle pour cette page » dans le bas de chaque page du site. Si le champ n\'est pas renseigné, les liens ne seront pas affichés.';
$string['configdoctonewwindow'] = 'Après activation de ce réglage, les liens vers Moodle Docs s\'ouvriront dans une nouvelle fenêtre.';
$string['configeditordictionary'] = 'Cette valeur sera utilisée si aucun dictionnaire dans la langue de l\'utilisateur n\'est disponible pour aspell.';
$string['configeditorfontlist'] = 'Sélectionner les polices à afficher dans le menu déroulant de l\'éditeur.';
$string['configemailchangeconfirmation'] = 'Exiger une confirmation par courriel lors du changement d\'adresse de courriel par les utilisateurs.';
$string['configenableajax'] = 'Ce réglage contrôle l\'utilisation d\'AJAX sur tout le site. AJAX est requis pour certaines fonctionnalités, comme le glisser-déposer.';
$string['configenableblogs'] = 'Ce réglage permet de fournir à tous les utilisateurs du site leur propre blog.';
$string['configenablecalendarexport'] = 'Activer l\'exportation et l\'abonnement aux calendriers.';
$string['configenablecomments'] = 'Activer les commentaires';
$string['configenablecourserequests'] = 'Vous permettrez ainsi à tous les utilisateurs de faire des demandes de création de cours.';
$string['configenabledevicedetection'] = 'Active la détection des types d\'appareils utilisés pour accéder au serveur (téléphone mobile, tablette, ordinateur portable ou de bureau, etc.) pour l\'application de réglages spécifiques (thème, etc.)';
$string['configenablegroupmembersonly'] = 'Si ce réglage est activé, l\'accès aux activités peut être limité aux membres de groupes. Cela peut se traduire par une augmentation de la charge du serveur. En outre, les catégories de carnet de notes doivent être configurées de façon à s\'assurer que les activités sont cachées aux participants ne faisant pas partie du groupe.';
$string['configenablemobilewebservice'] = 'Active le service mobile pour l\'application officielle Moodle ou d\'autres applications le demandant. Pour plus d\'information, lire {$a}';
$string['configenablerssfeeds'] = 'Si ce réglage est activé, des flux RSS seront générés pour diverses fonctionnalités sur tout le site, par exemple les blogs, forums, bases de données et glossaires. Il sera également nécessaire d\'activer les flux RSS pour chacun des différents modules d’activité.';
$string['configenablerssfeedsdisabled'] = 'Non disponible, car les flux RSS ne sont pas activés pour le site. Pour les activer, voyez l\'option Paramètres techniques sous Administration -> Configuration.';
$string['configenablerssfeedsdisabled2'] = 'Les flux RSS sont désactivés au niveau du site. Vous devez d\'abord les activer sous Serveur > RSS.';
$string['configenablesafebrowserintegration'] = 'Ce réglage permet d\'ajouter l\'option « Nécessite l\'utilisation de Safe Exam Browser » au champ « Sécurité du navigateur » dans les réglages des tests. Voir http://www.safeexambrowser.org/ (en anglais) pour plus d\'informations.';
$string['configenablestats'] = 'Si vous activez ce réglage, le cron automatique de Moodle traitera les historiques et produira quelques statistiques. Suivant la quantité de trafic sur votre site, le traitement peut prendre du temps. Les statistiques vous fourniront d\'intéressants graphiques et des statistiques sur chaque cours ou sur la totalité du site.';
$string['configenabletrusttext'] = 'Par défaut, Moodle nettoie soigneusement tous les fichiers déposés et textes saisis par les utilisateurs, afin d\'en retirer les éventuels scripts, médias, etc. pouvant constituer une faille de sécurité. Le système « Contenu fiable » vous permet de donner à certains utilisateurs en qui vous avez confiance la capacité d\'inclure sans interférence de tels éléments dans leurs ressources. Pour faire fonctionner ce système, veuillez d\'abord l\'activer ici, puis accorder la capacité « Se fier aux contenus » à un rôle spécifique. Les textes créés ou déposés par des utilisateurs ayant ce rôle seront marqués comme fiables et ne seront alors pas nettoyés avant leur affichage.';
$string['configenablewebservices'] = 'Les services web permettent à d\'autres systèmes de se connecter à ce Moodle et y effectuer des opérations. Pour plus de sécurité, cette fonctionnalité doit être désactivée, sauf si vous l\'utilisez réellement.';
$string['configenablewsdocumentation'] = 'Ce réglage active la génération automatique de la documentation des services web. L\'utilisateur d\'un service web peut accéder à sa propre documentation sur sa page de clefs de sécurité {$a}. Seule la documentation sur les protocoles activés est affichée.';
$string['configerrorlevel'] = 'Choisir la quantité d\'avertissement PHP que vous souhaitez voir afficher. « Normal » est généralement le meilleur choix.';
$string['configexportlookahead'] = 'Nombre de jours suivants à exporter';
$string['configexportlookback'] = 'Nombre de jours précédents à exporter';
$string['configextendedusernamechars'] = 'Activez cette option pour permettre aux étudiants d\'utiliser n\'importe quel caractère dans leur nom d\'utilisateur (cette option n\'a aucun effet sur leur nom d\'utilisateur actuel). Par défaut, cette option est désactivée, ce qui restreint les noms d\'utilisateur aux caractères alphanumériques bas de casse et aux caractères sous-ligné (_), tiret (-), point (.) et arobase (@).';
$string['configextramemorylimit'] = 'Certains scripts, par exemple pour rechercher, sauvegarder/restaurer ou le cron nécessitent plus de mémoire. Ce réglage spécifie la taille maximale de la mémoire supplémentaire. Indiquez des valeurs plus élevées pour de gros sites.';
$string['configfilterall'] = 'Filtrer toutes les chaînes, y compris les entêtes, titres, barre de navigation, etc. Ce réglage n\'est utile qu\'en combinaison avec l\'utilisation du filtre « Contenus multilingues ». Utilisé seul, il ne fera que charger inutilement votre serveur.';
$string['configfiltermatchoneperpage'] = 'Un seul lien automatique par page sera généré par les filtres de liaison automatique, pour chaque première apparition du texte. Toutes les autres occurrences seront ignorées.';
$string['configfiltermatchonepertext'] = 'Un seul lien automatique par élément de texte (par exemple bloc, ressource, etc.) sera généré par les filtres de liaison automatique sur une page. Toutes les autres occurrences seront ignorées. Ce réglage n\'est actif que si le réglage « Filtrer une occurrence par page » est désactivé.';
$string['configfilteruploadedfiles'] = 'Filtrer les fichiers HTML et fichiers texte déposés avant de les afficher, ne filtrer que les fichiers HTML déposés ou ne filtrer aucun fichier.';
$string['configforcelogin'] = 'Habituellement, la page d\'accueil du site et la liste des cours (mais pas les cours eux-mêmes) peuvent être consultés sans se connecter au site. Si vous désirez forcer les visiteurs à se connecter avant de faire <strong>quoi que ce soit</strong> dans le site, veuillez activer cette option.';
$string['configforceloginforprofiles'] = 'L\'activation de ce réglage impose aux visiteurs de se connecter en tant qu\'utilisateur réel (authentifié) pour pouvoir consulter les profils des autres utilisateurs. Si vous le désactivez, il pourra arriver que certains utilisateurs utilisent leur profil pour y inclure de la publicité (spam) ou d\'autres contenus inadéquats, qui seront alors visibles par tout le monde.';
$string['configfrontpage'] = 'Les éléments ci-dessus seront affichés sur la page d\'accueil.';
$string['configfrontpagecourselimit'] = 'Nombre maximal de cours';
$string['configfrontpagecourselimithelp'] = 'Ce réglage détermine le nombre maximal de cours à afficher dans les listes de cours sur la page d\'accueil du site.';
$string['configfrontpageloggedin'] = 'Les éléments sélectionnés seront affichés sur la page d\'accueil pour les utilisateurs connectés.';
$string['configfullnamedisplay'] = 'Ce réglage définit comment les noms sont affichés en format complet. La valeur par défaut, « language », conserve le réglage défini en fonction de votre paquetage de langue (les diverses langues ont des conventions différentes).

Pour la plupart des sites monolingues, le réglage le plus efficace est le réglage « Prénom Nom », mais vous pouvez choisir par exemple de cacher les noms de familles. Vous pouvez utiliser ici les variables prédéfinies suivantes : firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, et alternatename.';
$string['configgeoipfile'] = 'Emplacement du fichier binaire GeoIP City. Ce fichier ne fait pas partie de la distribution de Moodle. Il doit être obtenu séparément chez <a href="http://www.maxmind.com/">MaxMind</a>. Vous pouvez soit en acheter une version commerciale, soit utiliser la version gratuite. Téléchargez simplement le fichier <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> et décompressez-le dans le dossier « {$a} » sur votre serveur.';
$string['configgetremoteaddrconf'] = 'Si votre serveur est situé derrière un proxy inverse, vous pouvez utiliser ce réglage pour indiquer les entêtes HTTP dont on peut être sûr qu\'ils contiennent l\'adresse IP distante. Les entêtes sont lues dans l\'ordre indiqué, la première disponible étant utilisée.';
$string['configgradebookroles'] = 'Ce réglage permet de configurer les rôles apparaissant dans le carnet de notes. Pour être mentionnés dans le carnet de notes d\'un cours, les utilisateurs doivent avoir au moins l\'un de ces rôles dans ce cours.';
$string['configgradeexport'] = 'Sélectionnez les formats d\'exportation privilégiés du carnet de notes. Les sélections mettront en place et utiliseront ensuite un champ « dernière exportation » pour chaque note. Par exemple, cela permettra d\'identifier des notes exportées comme « nouvelles » ou « modifiées ». Si vous n\'êtes pas sûr à ce sujet, ne cochez rien.';
$string['confighiddenuserfields'] = 'Veuillez sélectionner quelles informations vous désirez cacher aux autres utilisateurs du cours que les administrateurs/enseignants. Vous pourrez ainsi améliorer la protection des données des étudiants. Il est possible de sélectionner plusieurs champs.';
$string['configidnumber'] = 'Cette option précise si (a) les utilisateurs doivent indiquer un numéro d\'identification non vide ; (b) les utilisateurs doivent indiquer un numéro d\'identification qui peut être vide ; (c) les utilisateurs n\'ont pas besoin d\'indiquer de numéro d\'identification. Le cas échéant, le numéro d\'identification est affiché dans le profil de l\'utilisateur.';
$string['configintro'] = 'Cette page permet de configurer un certain nombre de variables de configuration permettront à Moodle de fonctionner correctement sur ce serveur. Inutile de trop s\'en inquiéter, les paramètres par défaut devraient, la plupart du temps, convenir et il est toujours possible de revenir plus tard sur cette page pour les modifier.';
$string['configintroadmin'] = 'Cette page permet de configurer votre compte administrateur principal qui aura le contrôle total du site. Assurez-vous de lui donner un nom et un mot de passe sûrs, ainsi qu\'une adresse de courriel valable. Vous pourrez créer plus tard d\'autres comptes administrateur.';
$string['configintrosite'] = 'Cette page permet définir l\'aspect de la page d\'accueil et le nom de votre site. Vous pourrez modifier ces paramètres en tout temps en utilisant les menus d\'administration.';
$string['configiplookup'] = 'Lorsque que vous cliquez sur une adresse IP (par exemple 34.12.222.93) notamment dans les historiques, une carte de monde vous est affichée, avec une estimation la meilleure possible de la localisation de cette adresse IP. Diverses extensions sont disponibles pour effectuer cette tâche, ayant chacune ses avantages et inconvénients.';
$string['configkeeptagnamecase'] = 'Cocher cette option si vous désirez que les noms des tags conservent leur casse originale, telle que saisie par les utilisateurs qui les créent.';
$string['configlang'] = 'Choisir une langue par défaut pour l\'ensemble du site. Les utilisateurs ont la possibilité de la modifier à l\'aide du menu de langue ou en modifiant le réglage de leur profil personnel.';
$string['configlanglist'] = 'Laisser ce champ vide pour permettre le choix d\'une langue parmi toutes celles disponibles dans cette installation de Moodle. Vous pouvez restreindre le menu des langues en spécifiant une liste de codes des langues désirées, par exemple : fr,es_es,de,en,it';
$string['configlangmenu'] = 'Déterminer si vous voulez afficher ou non le menu du choix de la langue sur la page d\'accueil, la page de connexion, etc. Les utilisateurs peuvent sélectionner leur langue préférée dans leur propre profil indépendamment de ce réglage.';
$string['configlangstringcache'] = 'Ce réglage active la mise en cache des chaînes de caractères des paquetages de langues dans le dossier de données. Si vous traduisez Moodle ou modifiez des chaînes dans le code source de Moodle, il pourrait être utile de désactiver ce réglage. Sinon, laissez-le activé pour bénéficier d\'une meilleure performance.';
$string['configlatinexcelexport'] = 'Choisir l\'encodage des caractères pour les exportations en format Excel.';
$string['configlocale'] = 'Indiquer un environnement <em>locale</em> pour l\'affichage des dates. <strong>Laissez ce champ vide</strong>, sauf si vous avez une très bonne raison de faire autrement. Si le champ est renseigné, l\'environnement spécifié sera utilisé pour toutes les langues du site et empêchera l\'adaptation automatique de l\'affichage des dates en fonction de la langue choisie par l\'utilisateur.';
$string['configloginhttps'] = 'Cette option permet à Moodle d\'utiliser le protocole https sécurisé uniquement pour la page de connexion, ce qui fournit une connexion sécurisée. Moodle revient ensuite au protocole normal http pour gagner en vitesse. ATTENTION ! Ce réglage requiert l\'activation du protocole https sur le serveur web. Sans cela, vous risquez de NE PLUS POUVOIR ACCÉDER À VOTRE SITE.';
$string['configloglifetime'] = 'Ce champ permet de spécifier la durée de conservation des historiques des utilisateurs. Il est conseillé de choisir une durée aussi longue que possible. Si votre serveur est très fréquenté et que la performance se dégrade, il peut être judicieux de diminuer cette durée. Les valeurs inférieures à 30 ne sont pas recommandées, car les statistiques ne fonctionneraient alors pas correctement.';
$string['configlookahead'] = 'Jours à anticiper';
$string['configmaxbytes'] = 'Taille maximale des fichiers déposés dans le site, en octets. Cette valeur est limitée par les réglages PHP post_max_size et upload_max_filesize, ainsi que par le réglage Apache LimitRequestBody. Le réglage maxbytes limite quant à lui la taille au niveau des cours. Si vous choisissez « Limite serveur », le maximum alloué par le serveur sera utilisé.';
$string['configmaxconsecutiveidentchars'] = 'Les mots de passe ne doivent pas comporter plus que ce nombre de caractères identiques consécutifs. Indiquez 0 pour désactiver ce contrôle.';
$string['configmaxeditingtime'] = 'Ce paramètre indique la durée pendant laquelle les utilisateurs ont la possibilité de modifier un message, un article de glossaire, etc. qu\'ils ont écrit. Habituellement, 30 minutes est une bonne valeur.';
$string['configmaxevents'] = 'Nombre d\'événements à anticiper';
$string['configmaxusersperpage'] = 'Nombre maximum d\'utilisateurs affichés dans les champs de sélection d\'utilisateurs des cours, groupes, cohortes, services web, etc.';
$string['configmessaging'] = 'Le système de messagerie instantanée entre les utilisateurs du site doit-il être activé ?';
$string['configmessagingallowemailoverride'] = 'Permet aux utilisateurs de recevoir les notifications par courriel à une autre adresse que celle de leur profil';
$string['configmessagingdeletereadnotificationsdelay'] = 'Les notifications de lecture peuvent être supprimées pour gagner de l\'espace. Après combien de temps une telle notification doit être supprimée ?';
$string['configmessaginghidereadnotifications'] = 'Cacher les notifications de lecture d\'événements (telles que les messages des forums) lors de l\'affichage de l\'historique des messages';
$string['configminpassworddigits'] = 'Les mots de passe doivent comporter au moins ce nombre de chiffres.';
$string['configminpasswordlength'] = 'Les mots de passe doivent comporter au moins ce nombre de caractères.';
$string['configminpasswordlower'] = 'Les mots de passe doivent comporter au moins ce nombre de lettres minuscules.';
$string['configminpasswordnonalphanum'] = 'Les mots de passe doivent comporter au moins ce nombre de caractères non alphanumériques.';
$string['configminpasswordupper'] = 'Les mots de passe doivent comporter au moins ce nombre de lettres majuscules.';
$string['configmobilecssurl'] = 'Fichier CSS pour personnaliser votre interface mobile.';
$string['configmodchooserdefault'] = 'Présenter par défaut le sélecteur d\'activités ?';
$string['configmycoursesperpage'] = 'Nombre maximal de cours à afficher dans les listes des cours propres à un utilisateur';
$string['configmymoodleredirect'] = 'Ce réglage active la redirection vers le dossier /my lors de la connexion des non-administrateurs et remplace le premier niveau de la barre de navigation du site par /my';
$string['configmypagelocked'] = 'Ce réglage permet d\'éviter la modification de la page par défaut par des non administrateurs';
$string['confignavcourselimit'] = 'Nombre maximum de cours affichés pour des utilisateurs non connectés ou inscrits à aucun cours.';
$string['confignavshowallcourses'] = 'Ce réglage détermine si les utilisateurs inscrits dans des cours peuvent voir les Cours (la liste de tous les cours) dans la navigation, en plus de Mes cours (la liste des cours dans lesquels ils sont inscrits).';
$string['confignavshowcategories'] = 'Affiche les catégories de cours dans la barre de navigation et dans le bloc de navigation. Cela n\'est pas le cas avec les cours dans lesquels l\'utilisateur est inscrit, qui seront listés sans catégories sous Mes cours.';
$string['confignotifyloginfailures'] = 'Lorsque les tentatives de connexion sont enregistrées, des notifications peuvent être envoyées par courriel. Qui doit recevoir ces notifications ?';
$string['confignotifyloginthreshold'] = 'Lorsque les notifications des tentatives de connexion sont activées, combien de tentatives (provenant du même utilisateur ou de la même adresse IP) doivent être notifiées ?';
$string['confignotloggedinroleid'] = 'Les utilisateurs non connectés dans le site seront traités comme si ce rôle leur était accordé au niveau du contexte du site. Le rôle « Visiteur anonyme » est presque toujours ce dont vous aurez besoin ; il se peut toutefois que vous vouliez créer des rôles plus ou moins restrictifs. Les actions telles qu\'écrire des messages dans les forums requièrent toujours une véritable connexion.';
$string['configopentogoogle'] = 'Si vous activez cette option, Google pourra entrer dans votre site en tant qu\'utilisateur anonyme. En outre, les internautes arrivant sur votre site depuis une recherche Google seront automatiquement connectés en tant qu\'utilisateur anonyme. Cependant, cela ne permet un accès transparent qu\'aux cours déjà ouverts aux visiteurs anonymes.';
$string['configoverride'] = 'Défini dans config.php';
$string['configpasswordpolicy'] = 'Après activation de ce réglage, Moodle vérifiera la qualité des mots de passe (longueur, types des caractères, etc.). Utilisez les réglages ci-dessous pour fixer les critères minimaux des mots de passe (ils seront ignorés si ce réglage est désactivé).';
$string['configpasswordresettime'] = 'Ce réglage spécifie le temps à disposition des utilisateurs pour valider une demande de réinitialisation de mot de passe avant son échéance.
Une durée de 30 minutes est adéquate.';
$string['configpathtoclam'] = 'Chemin d\'accès du programme « clam AV ». En général quelque chose comme « /usr/bin/clamscan » ou « /usr/bin/clamdscan ». Cette valeur est indispensable au fonctionnement de clam AV.';
$string['configpathtodu'] = 'Chemin d\'accès du programme « du » (disk usage). En général quelque chose comme « /usr/bin/du ». Si vous spécifiez ce chemin, les pages affichant le contenu de dossiers contenant beaucoup de fichiers se chargeront beaucoup plus vite.';
$string['configperfdebug'] = 'L\'activation de cette option a pour effet l\'affichage d\'informations de performance dans le pied de page du thème standard.';
$string['configprofileroles'] = 'Liste des rôles affichés sur les profils utilisateurs et la page de participation.';
$string['configprofilesforenrolledusersonly'] = 'Afin de prévenir les abus de spammeurs, le profil des utilisateurs qui ne sont inscrits à aucun cours sont cachés. Les nouveaux utilisateurs doivent s\'inscrire au moins à un cours pour pouvoir ajouter une description à leur profil.';
$string['configprotectusernames'] = 'Si ce réglage est activé, la routine de récupération de mot de passe n\'affiche aucun indice pouvant permettre de deviner les noms d\'utilisateurs ou les adresses de courriel.';
$string['configproxybypass'] = 'Liste séparée par des virgules de noms de domaines ou d\'adresses IP (éventuellement partiels) ne devant pas passer par le proxy (par exemple : 192.168., .mondomaine.com)';
$string['configproxyhost'] = 'Si le serveur qui héberge le site Moodle a besoin d\'utiliser un proxy (dans le cas, par exemple, où il existe un firewall sur le réseau), indiquer ici le nom de ce proxy. Sinon laisser vide.';
$string['configproxypassword'] = 'Mot de passe requis pour accéder à Internet au travers du proxy, si nécessaire. Laisser vide dans le cas contraire (l\'extension cURL de PHP est requise).';
$string['configproxyport'] = 'Si le serveur requiert l\'utilisation d\'un proxy, indiquez ici le port du proxy.';
$string['configproxytype'] = 'Type de proxy web (PHP5 et son extension cURL sont requis pour le support de SOCKS5).';
$string['configproxyuser'] = 'Nom d\'utilisateur requis pour accéder à Internet au travers du proxy, si nécessaire. Laisser vide dans le cas contraire (l\'extension cURL de PHP est requise).';
$string['configquarantinedir'] = 'Si vous désirez que clam AV déplace les fichiers infectés vers un dossier de quarantaine, spécifiez ici son chemin d\'accès. Le serveur web doit pouvoir écrire dans ce dossier. Si vous laissez ce champ vide ou si vous spécifiez un dossier inexistant ou sans droit d\'écriture, les fichiers infectés seront détruits. Ne pas écrire la barre oblique finale.';
$string['configrecaptchaprivatekey'] = 'Chaîne de caractères utilisée pour communiquer entre votre serveur Moodle et le serveur recaptcha.net. Vous pouvez obtenir une telle clef pour votre site en visitant http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Chaîne de caractères utilisée pour afficher l\'élément reCAPTCHA dans le formulaire d\'enregistrement. Cette chaîne est générée par http://www.google.com/recaptcha';
$string['configrequestcategoryselection'] = 'Permettre le choix d\'une catégorie lors de la demande d\'un cours';
$string['configrequestedstudentname'] = 'Terme utilisé pour « étudiant » dans les cours demandés';
$string['configrequestedstudentsname'] = 'Terme utilisé pour « étudiants » dans les cours demandés';
$string['configrequestedteachername'] = 'Terme utilisé pour « enseignant » dans les cours demandés';
$string['configrequestedteachersname'] = 'Terme utilisé pour « enseignants » dans les cours demandés';
$string['configrequiremodintro'] = 'Cette option définit si vous désirez que les utilisateurs doivent écrire une description pour chaque activité créée.';
$string['configrunclamavonupload'] = 'Une fois ce réglage activé, le logiciel anti-virus clam AV vérifiera tous les fichiers déposés.';
$string['configrunclamonupload'] = 'Lancer clam AV lors du dépôt de fichiers ? Il est indispensable d\'indiquer en outre le chemin d\'accès correct dans le champ « pathtoclam » pour un fonctionnement correct. (Clam AV est un antivirus libre et gratuit que vous pouvez obtenir ici : http://www.clamav.net/)';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'Courriel';
$string['configsectionmaintenance'] = 'Maintenance';
$string['configsectionmisc'] = 'Divers';
$string['configsectionoperatingsystem'] = 'Système d\'exploitation';
$string['configsectionpermissions'] = 'Autorisations';
$string['configsectionrequestedcourse'] = 'Demande de cours';
$string['configsectionsecurity'] = 'Sécurité';
$string['configsectionstats'] = 'Statistiques';
$string['configsectionuser'] = 'Utilisateur';
$string['configsecureforms'] = 'Moodle peut utiliser un niveau additionnel de sécurité pour la gestion des formulaires web. Si cette option est activée, la variable HTTP_REFERRER du navigateur est comparée à l\'adresse du formulaire. Cela peut poser des problèmes lors de l\'utilisation d\'un firewall (p. ex. Zonealarm) configuré pour ôter HTTP_REFERRER de leur trafic web. Le symptôme est alors le « gel » du formulaire. Si vos utilisateurs ont des problèmes de connexion, par exemple sur la page de connexion, désactiver cette option. Dans le doute, réglez cette option sur « Oui ».';
$string['configsessioncookie'] = 'Ce réglage permet de changer le nom du cookie utilisé pour les sessions de Moodle. Il est optionnel et uniquement utile pour éviter les confusions entre cookies sur un site web où tournent plusieurs Moodle.';
$string['configsessioncookiedomain'] = 'Ce réglage vous permet de modifier le domaine depuis lequel les cookies de Moodle sont disponibles. Ceci est utile pour les modifications locales de Moodle (par exemple les plugins d\'authentification ou d\'inscription) nécessitant de partager les informations de session Moodle avec une application web dans un autre sous-domaine. <strong>ATTENTION ! il est vivement recommandé de ne pas modifier ce réglage et de le laisser vide. Une valeur incorrecte empêchera toute connexion au site.</strong>';
$string['configsessioncookiepath'] = 'Si vous voulez modifier l\'endroit où les navigateurs envoient les cookies, vous pouvez changer ce réglage en indiquant un sous-dossier de votre site web. Dans le cas contraire, le réglage par défaut « / » sera adéquat.';
$string['configsessiontimeout'] = 'Les utilisateurs connectés seront automatiquement déconnectés (leur session sera terminée) après le laps de temps d\'inactivité spécifié dans ce champ.';
$string['configshowcommentscount'] = 'Affiche le nombre de commentaires. Ceci coûte une requête supplémentaire dans la base de données lors de l\'affichage du lien vers les commentaires';
$string['configshowicalsource'] = 'Afficher les informations de la source des événements de calendriers abonnés.';
$string['configshowsiteparticipantslist'] = 'Tous les étudiants et les enseignants de la page d\'accueil de ce site seront affichés dans la liste des participants du site. Qui doit avoir l\'autorisation de voir cette liste des participants de la page d\'accueil ?';
$string['configsitedefaultlicense'] = 'Licence par défaut du site';
$string['configsitedefaultlicensehelp'] = 'La licence par défaut sera utilisée pour publier les contenus sur ce site';
$string['configsitemaxcategorydepth'] = 'Nombre maximum de niveaux de catégories';
$string['configsitemaxcategorydepthhelp'] = 'Ce réglage détermine le nombre maximal de niveaux de catégories filles affichés dans les listes de catégories ou listes combinées. Les niveaux de catégories plus profonds apparaîtront sous forme de liens et pourront être dépliés par l\'utilisateur.';
$string['configslasharguments'] = 'Les fichiers (images, fichiers téléchargés, etc.) sont transmis via un script qui utilise les « slash arguments ». Cette méthode permet à ces fichiers d\'être plus facilement pris en compte par le système de cache des navigateurs web, les proxy, etc. Cependant certains serveurs PHP n\'autorisent pas cette méthode. Par conséquent veuillez désactiver ce réglage si des problèmes d\'affichage des fichiers ou images téléchargés sont rencontrés.';
$string['configsmartpix'] = 'Lorsque ce réglage est activé, les icônes sont affichées via un script PHP, qui les cherche dans le thème actuel, puis dans tous les thèmes parents, et finalement dans le dossier /pix de Moodle. Ainsi il n\'est plus nécessaire de dupliquer les images dans les thèmes, pour un léger coût de performance.';
$string['configstartwday'] = 'Début de la semaine';
$string['configstatsfirstrun'] = 'Ce réglage permet de spécifier jusqu\'à quelle date dans le passé les historiques doivent être traités lors de la <b>première fois</b> que le cron traite les statistiques. Si vous avez beaucoup de trafic ou si vous partagez un hébergement, il vous est déconseillé de remonter trop loin dans le temps, car le processus peut prendre beaucoup de temps et nécessite beaucoup de ressources processeur. (Pour ce réglage, veuillez remarquer que 1 mois = 28 jours. Dans les graphiques et statistiques générées, 1 mois = 1 mois du calendrier.)';
$string['configstatsmaxruntime'] = 'Le traitement des statistiques peut être très intensif. Nous vous conseillons d\'utiliser une combinaison de ce champ et du champ suivant pour spécifier quand le traitement sera lancé et durant combien de temps il tournera.';
$string['configstatsmaxruntime2'] = 'Le traitement des statistiques peut être très intensif. Veuillez indiquer la durée maximale permise pour la récolte des statistiques d\'une journée. Le nombre maximum de jours traités durant l\'exécution d\'un cron est 31.';
$string['configstatsmaxruntime3'] = 'Ce réglage spécifie la durée maximale allouée pour le calcul des statistiques d\'une journée. Les statistiques peuvent être très gourmandes et peuvent fortement charger votre serveur. Le nombre maximum de jours à traiter lors d\'une exécution du cron peut être indiqué ci-dessous.';
$string['configstatsruntimedays'] = 'Ce réglage spécifie le nombre maximal de jours traités lors d\'une même exécution des statistiques. Lorsque les statistiques sont à jour, un seul jour sera traité. Veuillez donc ajuster cette valeur en tenant compte de la capacité de calcul de votre serveur, en la réduisant si le cron doit être exécuté plus rapidement.';
$string['configstatsruntimestart'] = 'Spécifie l\'heure à laquelle le cron lançant le traitement des statistiques doit démarrer. Il est conseillé d\'indiquer des heures différentes si plusieurs instances de Moodle sont installées sur le même serveur.';
$string['configstatsuserthreshold'] = 'Ce réglage spécifie le nombre minimum d\'utilisateurs inscrits dans un cours pour que celui-ci soit inclus dans les statistiques.';
$string['configstrictformsrequired'] = 'Si ce réglage est activé, les utilisateurs ne pourront pas ne saisir qu\'un espace et un saut de ligne dans les champs requis.';
$string['configstripalltitletags'] = 'Désactivez cette option si vous voulez autoriser les balises HTML dans le nom des activités et des ressources.';
$string['configsupportemail'] = 'Cette adresse de courriel sera publiée pour les utilisateurs du site comme une adresse où ils peuvent obtenir de l\'assistance (par exemple lors de la création des comptes des nouveaux utilisateurs). Si le champ n\'est pas renseigné, aucune adresse de courriel ne sera publiée à cet effet.';
$string['configsupportname'] = 'Le nom de la personne ou du service fournissant de l\'assistance par courriel ou sur un site web.';
$string['configsupportpage'] = 'Cette adresse sera publiée pour les utilisateurs du site comme le site web où ils peuvent obtenir de l\'assistance (par exemple lors de la création des comptes des nouveaux utilisateurs). Si le champ n\'est pas renseigné, aucun lien ne sera publié à cet effet.';
$string['configthemedesignermode'] = 'Normalement, toutes les images et feuilles de styles des thèmes sont mises en cache par les navigateurs pour une longue durée, afin d\'améliorer les performances. Si vous concevez des thèmes ou développez du code, ce réglage vous permet de ne pas faire afficher les versions stockées en cache. Attention ! Ce réglage rend votre site plus lent pour tous les utilisateurs ! Une alternative est de réinitialiser manuellement les caches de thèmes dans la page de sélection de thèmes.';
$string['configthemelist'] = 'Laissez ce champ vide si vous voulez permettre l\'utilisation de n\'importe quel thème. Si vous voulez raccourcir le menu des thèmes, vous pouvez spécifier ici une liste de noms de thèmes autorisés, séparés par des virgules. Par exemple : « standard,orangewhite ». N\'utilisez pas d\'espaces !';
$string['configtimezone'] = 'Le fuseau horaire par défaut. Chaque utilisateur peut modifier ce réglage dans son propre profil. Si vous choisissez « Heure locale du serveur », Moodle utilisera le réglage par défaut du serveur où il est installé. Si l\'utilisateur choisit « Heure locale du serveur » dans son profil, le réglage spécifié ici sera alors utilisé pour lui. Il est recommandé de mettre à jour les fuseaux horaires, puis de sélectionner le fuseau correspondant à votre région.';
$string['configuseblogassociations'] = 'Ce réglage détermine si les utilisateurs peuvent organiser leur blog en associant des articles à des cours ou des modules de cours.';
$string['configuseexternalyui'] = 'Utiliser les fichiers en ligne sur les serveurs de Yahoo au lieu des fichiers installés sur votre serveur. Attention ! Sans connexion internet, les fonctionnalités AJAX ne fonctionneront pas sur votre site. Ce réglage n\'est pas compatible avec les sites utilisant https.';
$string['configuserquota'] = 'Le nombre maximal d\'octets qu\'un utilisateur a à sa disposition pour stocker des fichiers dans sa zone de fichiers personnels. {$a->bytes} octets == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Quand ce réglage est activé, le nom abrégé du site est utilisé dans la barre de navigation pour les pages du site, au lieu de la chaîne « Pages du site ».';
$string['configusetags'] = 'La fonctionnalité des tags doit-elle être activée sur tout le site ?';
$string['configvariables'] = 'Paramètres techniques';
$string['configverifychangedemail'] = 'Active la vérification des adresses de courriel lorsqu\'elles sont modifiées, en utilisant les réglages des domaines autorisés et interdits. Si ce réglage est désactivé, les restrictions de domaines ne sont appliquées que lors de la création des nouveaux comptes.';
$string['configvisiblecourses'] = 'Afficher normalement les cours placés dans des catégories cachées';
$string['configwarning'] = 'Attention ! Des valeurs inadaptées pour ces paramètres peuvent engendrer des problèmes.';
$string['configyuicomboloading'] = 'Cette option permet un chargement combiné des bibliothèques YUI pour améliorer la performance. Ce réglage devrait être activé sur des sites en production.';
$string['confirmation'] = 'Confirmation';
$string['confirmdeletecomments'] = 'Voulez-vous vraiment supprimer des commentaires ?';
$string['confirmed'] = 'Confirmé';
$string['convertformat'] = 'Format de sortie de <i>convert</i>';
$string['cookiehttponly'] = 'Cookies http uniquement';
$string['cookiesecure'] = 'Cookies sécurisé uniquement';
$string['country'] = 'Pays par défaut';
$string['coursecontact'] = 'Contacts de cours';
$string['coursecontact_desc'] = 'Ce réglage permet de choisir les utilisateurs apparaissant dans la description du cours. Pour être affichés dans la description d\'un cours, les utilisateurs doivent avoir au moins l\'un de ces rôles dans ce cours.';
$string['courselistshortnames'] = 'Afficher les noms de cours étendus';
$string['courselistshortnames_desc'] = 'Si ce réglage est activé, le nom abrégé des cours est affiché en plus du nom complet du cours dans les listes de cours. Si nécessaire, il est possible de modifier le nom étendu des cours en modifiant la chaîne de caractères « courseextendednamedisplay » dans le paquetage de langue.';
$string['coursemgmt'] = 'Gestion des cours et catégories';
$string['courseoverview'] = 'Vue d\'ensemble cours';
$string['courserequestnotify'] = 'Notification des demandes de cours';
$string['courserequestnotifyemail'] = 'L\'utilisateur {$a->user} a demandé un nouveau cours sur {$a->link}';
$string['courserequests'] = 'Demandes de cours';
$string['courserequestspending'] = 'Demandes de création de cours en attente';
$string['courses'] = 'Cours';
$string['coursesperpage'] = 'Cours par page';
$string['courseswithsummarieslimit'] = 'Limite des cours avec résumé';
$string['creatornewroleid'] = 'Rôle des créateurs de cours dans les nouveaux cours';
$string['creatornewroleid_help'] = 'Si l\'utilisateur n\'a pas déjà les autorisations de gérer le nouveau cours, il y sera automatiquement inscrit avec ce rôle.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Exécution du cron uniquement en mode terminal';
$string['cronerrorclionly'] = 'Désolé, l\'accès à cette page depuis le web a été désactivé par l\'administrateur';
$string['cronerrorpassword'] = 'Désolé, vous n\'avez pas fourni un mot de passe valide pour accéder à cette page';
$string['cron_help'] = 'Le script de maintenance cron.php permet d\'effectuer des tâches programmées à intervalle régulier pour des modules de Moodle, comme l\'envoi par courriel des copies des messages de forums. Un mécanisme est nécessaire pour lancer ce script de façon régulière, par exemple toutes les 15 minutes.';
$string['cronremotepassword'] = 'Mot de passe pour lancer le cron à distance';
$string['cronwarning'] = 'Le <a href="cron.php">script de maintenance cron.php</a> n\'a pas été lancé depuis au moins 24 heures.';
$string['ctyperecommended'] = 'L\'installation de l\'extension optionnelle ctype de PHP est vivement recommandée afin d\'améliorer les performances du site, en particulier si votre site utilise des caractères non-latins.';
$string['ctyperequired'] = 'L\'installation de l\'extension ctype de PHP est maintenant requise par Moodle, afin d\'améliorer les performances du site et d\'offrir la compatibilité multilingue.';
$string['curlcache'] = 'Durée du cache cURL';
$string['curlrecommended'] = 'L\'installation de l\'extension optionnelle cURL de PHP est vivement recommandée afin de pouvoir utiliser la fonctionnalité Réseau Moodle.';
$string['curlrequired'] = 'L\'installation de l\'extension cURL de PHP est maintenant requise par Moodle, afin de pouvoir communiquer avec les dépôts de documents de Moodle.';
$string['curltimeoutkbitrate'] = 'Bande passante à utiliser pour le calcul des timeout de cURL (kbps)';
$string['curltimeoutkbitrate_help'] = 'Ce réglage est utilisé pour calculer un timeout adéquat durant les grosses requêtes cURL. Pour ce calcul, une requête HTTP HEAD est effectuée pour déterminer la taille du téléchargement. La valeur 0 désactive cette requête.';
$string['currenttheme'] = 'Thème actuel';
$string['customcheck'] = 'Autres contrôles';
$string['custommenu'] = 'Menu personnalisé';
$string['custommenuitems'] = 'Éléments du menu personnalisé';
$string['datarootsecurityerror'] = '<p><strong>NOTIFICATION DE SÉCURITÉ !</strong></p><p>Votre dossier de données n\'est pas placé au bon endroit. Il est directement exposé au web. Ceci signifie que tous les fichiers privés de votre Moodle sont accessibles pour n\'importe qui et que certains d\'entre eux peuvent être utilisés par des pirates pour accéder de façon non autorisée à l\'administration de votre site !</p><p>Vous <em>devez</em> déplacer votre dossier de données ({$a}) en dehors de votre dossier web public et mettre à jour le réglage <code>$CFG->dataroot</code> de votre fichier config.php de façon adéquate.</p>';
$string['datarootsecuritywarning'] = 'La configuration de votre site semble ne pas être sûre. Veuillez vous assurer que le dossier des données de Moodle ({$a}) ne soit pas directement accessible depuis le web.';
$string['dbmigrate'] = 'Migration de la base de données de Moodle';
$string['dbmigrateconnecerror'] = 'Impossible de se connecter à la base de données spécifiée.';
$string['dbmigrateencodingerror'] = 'La base de données spécifiée a l\'encodage {$a} au lieu de l\'encodage requis UNICODE/UTF8.<br />Veuillez en sélectionner une autre.';
$string['dbmigratepostgres'] = 'Il semble que vous utilisez PostgreSQL comme serveur de base de données. Pour continuer le processus de migration, vous devez créer manuellement une nouvelle base de données avec l\'encodage « UNICODE » (PostgreSQL 7) ou « UTF8 » (PostgreSQL 8) pour stocker les données converties. Veuillez saisir les nouvelles données de connexion de base de données ci-dessous pour continuer :';
$string['dbmigratewarning'] = 'Veuillez vous assurer de bien avoir effectué une copie de sauvegarde de votre base de données Moodle avant de commencer cette procédure. Si vous n\'êtes pas sûr de la façon de le faire, veuillez contacter votre administrateur système. Votre site Moodle sera placé en mode de maintenance mode après le début du processus de migration.';
$string['dbmigratewarning2'] = '<b>Attention ! Vous êtes sur le point de commencer le processus de migration de la base de données de Moodle. Veuillez vous assurez de manière certaine que votre base de données Moodle est sauvegardée.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Cette base de données a été convertie en une nouvelle base de données UTF8. Elle n\'est plus utilisable avec cette version de Moodle. Veuillez modifier votre fichier config.php et utiliser la nouvelle base de données pour ce moodle.</font>';
$string['dbmigrationdupfailed'] = 'La duplication de la base de données a échoué. L\'erreur est vraisemblablement : <font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Stocker les informations de session dans la base de données';
$string['debug'] = 'Messages de débogage';
$string['debugall'] = 'Tout : afficher tous les messages de débogage de PHP';
$string['debugdeveloper'] = 'Développeur : afficher tous les messages de débogage de Moodle';
$string['debugdisplay'] = 'Afficher les informations de débogage';
$string['debugging'] = 'Débogage';
$string['debugminimal'] = 'Minimal : n\'afficher que les erreurs fatales';
$string['debugnone'] = 'Aucun : n\'afficher aucune erreur, ni avertissement';
$string['debugnormal'] = 'Normal : afficher les erreurs, avertissements et notices';
$string['debugpageinfo'] = 'Afficher les informations concernant la page';
$string['debugsmtp'] = 'Débogage de l\'envoi des courriels';
$string['debugstringids'] = 'Afficher l\'origine des chaînes de caractères';
$string['debugstringids_desc'] = 'Ce réglage est destiné à faciliter le travail des traducteurs de Moodle. S\'il est activé, en ajoutant le paramètre « strings=1 » à une URL de Moodle, la page affichée indiquera le nom du fichier de langue ainsi que l\'identifiant de chaque chaîne de caractères.';
$string['debugvalidators'] = 'Afficher les liens de validation W3C';
$string['defaultcity'] = 'Localité par défaut';
$string['defaultcity_help'] = 'La localité saisie ici sera la ville par défaut lors de la création de nouveaux comptes utilisateurs.';
$string['defaultformatnotset'] = 'Erreur de détection du format de cours. Veuillez vérifier les réglages du site.';
$string['defaulthomepage'] = 'Page d\'accueil par défaut pour les utilisateurs';
$string['defaultrequestcategory'] = 'Catégorie par défaut des demandes de cours';
$string['defaultsettinginfo'] = 'Défaut : {$a}';
$string['defaultuserroleid'] = 'Rôle par défaut des utilisateurs';
$string['deleteincompleteusers'] = 'Supprimer les utilisateurs incomplets après';
$string['deleteunconfirmed'] = 'Supprimer les utilisateurs non confirmés après';
$string['deleteuser'] = 'Supprimer l\'utilisateur';
$string['density'] = 'Densité';
$string['denyemailaddresses'] = 'Domaines courriel interdits';
$string['development'] = 'Développement';
$string['devicedetectregex'] = 'Expressions régulières de détection d\'appareils';
$string['devicedetectregex_desc'] = '<p>Par défaut, Moodle est capable de détecter des appareils de type standard (ordinateurs de bureau, ordinateurs portables, etc.), mobiles (téléphones et appareils de petite taille), tablettes (iPads, tablettes Android) et obsolètes (utilisateurs d\'Internet Explorer 6). Le sélecteur de thème peut être utilisé pour appliquer des thèmes distincts pour ces différents appareils. Ce réglage comprend les expressions régulières pour détecter des types de périphériques supplémentaires (ces types ont priorité sur les types par défaut).</p>
<p>Par exemple, vous pouvez entrer l\'expression régulière « /(MIDP-1.0|Maemo|Windows CE)/ » pour détecter certains téléphones, et ajouter la valeur de retour « FeaturePhone ». Cela ajoute l\'option « FeaturePhone » dans le sélecteur de thème, vous permettant d\'ajouter un thème qui serait utilisé sur ces appareils. D\'autres téléphones utiliseraient toujours le thème choisi pour le type de périphérique mobile.</p>';
$string['devicedetectregexexpression'] = 'Expression régulière';
$string['devicedetectregexvalue'] = 'Valeur retournée';
$string['devicetype'] = 'Type d\'appareil';
$string['disableuserimages'] = 'Désactiver les images des utilisateurs';
$string['displayerrorswarning'] = 'L\'activation du réglage PHP <em>display_errors</em> n\'est pas recommandée sur des sites en production, car certains messages d\'erreur peuvent révéler des informations sensibles au sujet de votre serveur.';
$string['displayloginfailures'] = 'Afficher les erreurs de connexion à';
$string['dndallowtextandlinks'] = 'Dépôt de textes/liens par glisser-déposer';
$string['docroot'] = 'URL du site Moodle Docs';
$string['doctonewwindow'] = 'Ouvrir dans une nouvelle fenêtre';
$string['download'] = 'Télécharger';
$string['edithelpdocs'] = 'Modifier les fichiers d\'aide';
$string['editingnoncorelangfile'] = 'Vous essayez de modifier la traduction d\'un module additionnel. Vous ne pouvez enregistrer cette traduction que dans votre dossier _local. Vous pouvez déplacer le fichier contenant la traduction dans le dossier lang du module et/ou l\'envoyer au responsable du module additionnel.';
$string['editlang'] = '<b>Modifier</b>';
$string['editorbackgroundcolor'] = 'Couleur de fond';
$string['editordictionary'] = 'Dictionnaire de l\'éditeur';
$string['editorfontfamily'] = 'Famille de police';
$string['editorfontlist'] = 'Liste des polices';
$string['editorfontsize'] = 'Corps de police';
$string['editorhidebuttons'] = 'Boutons cachés';
$string['editorkillword'] = 'Filtre Word';
$string['editorspelling'] = 'Correction orthographique de l\'éditeur';
$string['editorspellinghelp'] = 'Activer ou désactiver la correction orthographique. Une fois activée, le programme <strong>aspell</strong> doit être installé sur le serveur.';
$string['editstrings'] = 'Modifier les chaînes de caractères';
$string['emailchangeconfirmation'] = 'Confirmation de modification de courriel';
$string['emoticonalt'] = 'Texte alternatif';
$string['emoticoncomponent'] = 'Composant de l\'image';
$string['emoticonimagename'] = 'Nom de l\'image';
$string['emoticons'] = 'Binettes';
$string['emoticons_desc'] = 'Ce formulaire définit les binettes (ou émoticônes) utilisées sur votre site. Pour définir une nouvelle binette, renseignez les champs de la dernière rangée. Pour supprimer une rangée, effacez son contenu et enregistrez le formulaire. Pour réinitialiser tous les champs à leur valeur par défaut, cliquez sur le lien au-dessous de la table

* Texte (requis) : ce texte sera remplacé par l\'image de la binette. Il doit comporter au moins deux caractères.
* Nom de l\'image (requis) : le nom du fichier de l\'image de la binette, sans extension, relativement au dossier pix du composant.
* Composant de l\'image (requis) : le composant fournissant l\'image.
* Texte alternatif (optionnel) : chaîne de caractères utilisée comme texte alternatif de la binette.';
$string['emoticonsreset'] = 'Réinitialiser les binettes aux valeurs par défaut';
$string['emoticontext'] = 'Texte';
$string['emptysettingvalue'] = 'Vide';
$string['enableajax'] = 'Activer AJAX';
$string['enableblogs'] = 'Activer les blogs';
$string['enablecalendarexport'] = 'Activer l\'exportation des calendriers';
$string['enablecomments'] = 'Activer les commentaires';
$string['enablecourserequests'] = 'Activer les demandes de création de cours';
$string['enablecssoptimiser'] = 'Activer l\'optimiseur CSS';
$string['enablecssoptimiser_desc'] = 'Si ce réglage est activé, les CSS seront optimisés avant d\'être mis en cache. L\'optimisation retire les styles et règles en double, ainsi que les espaces superflus. L\'activation de cette option et du mode développeur de thème occasionnera de grosses pertes de performances, mais permettra au concepteur la réalisation de CSS optimisés.';
$string['enabled'] = 'Activé';
$string['enabledevicedetection'] = 'Activer la détection des appareils';
$string['enablegravatar'] = 'Activer Gravatar';
$string['enablegravatar_help'] = 'Quand ce réglage est activé, Moodle essaiera d\'afficher un avatar à partir de Gravatar, si l\'utilisateur n\'a pas déposé d\'image.';
$string['enablegroupmembersonly'] = 'Activer la restriction aux membres de groupes';
$string['enablemobilewebservice'] = 'Activer les services web pour appareils mobiles';
$string['enablerecordcache'] = 'Activer le cache des enregistrements';
$string['enablerssfeeds'] = 'Activer les RSS';
$string['enablesafebrowserintegration'] = 'Activer l\'intégration de « Safe Exam Browser »';
$string['enablestats'] = 'Activer les statistiques';
$string['enabletgzbackups'] = 'Activer le nouveau format de sauvegarde';
$string['enabletgzbackups_desc'] = 'Si ce réglage est activé, les sauvegardes seront créées dans un nouveau format de compression pour les fichiers .mbz (format .tar.gz). Ceci permet de retirer la restriction de taille maximale de 4 Go pour les sauvegardes et d\'améliorer la performance. La restauration supporte les deux formats et aucune différence ne sera perceptible pour les utilisateurs.';
$string['enabletgzbackups_nozlib'] = 'L\'extension « zlib » de PHP n\'est pas disponible. Le nouveau format de sauvegarde requiert cette extension. Il sera donc désactivé en attendant que zlib soit installé et activé.';
$string['enabletrusttext'] = 'Activer le système Contenu fiable';
$string['enablewebservices'] = 'Activer les services web';
$string['enablewsdocumentation'] = 'Documentation services web';
$string['enrolinstancedefaults'] = 'Réglages par défaut des instances d\'inscription';
$string['enrolinstancedefaults_desc'] = 'Réglages par défaut de l\'inscription dans les nouveaux cours.';
$string['enrolmultipleusers'] = 'Inscrire les utilisateurs';
$string['environment'] = 'Environnement';
$string['environmenterrortodo'] = 'Vous devez résoudre tous les problèmes liés à l\'environnement (erreurs) décrits ci-dessus avant de continuer l\'installation de cette version de Moodle !';
$string['environmenterrorupgrade'] = 'Attention ! Veuillez résoudre tous les problèmes d\'environnement (erreurs) mentionnés ci-dessus avant de continuer la mise à jour vers cette version de Moodle ! La mise à jour sans correction de ces problèmes causera vraisemblablement des problèmes, par exemple des pertes de données. Voulez-vous vraiment continuer maintenant la mise à jour ?';
$string['environmentmustfixsetting'] = 'Le réglage PHP doit être modifié.';
$string['environmentok'] = 'Votre environnement serveur possède les modules requis.';
$string['environmentrecommendcustomcheck'] = 'l\'échec de ce test indique un problème potentiel';
$string['environmentrecommendinstall'] = 'devrait être installé et activé pour une fonctionnalité optimale';
$string['environmentrecommendversion'] = 'la version {$a->needed} est recommandée ; vous utilisez actuellement la version {$a->current}';
$string['environmentrequirecustomcheck'] = 'ce test doit réussir';
$string['environmentrequireinstall'] = 'doit être installé et activé';
$string['environmentrequireversion'] = 'la version {$a->needed} est requise ; vous utilisez actuellement la version {$a->current}';
$string['environmentsettingok'] = 'Réglage recommandé détecté';
$string['environmentshouldfixsetting'] = 'Le réglage PHP devrait être modifié.';
$string['environmentxmlerror'] = 'Erreur lors de la lecture des données d\'environnement ({$a->error_code})';
$string['errordeletingconfig'] = 'Une erreur est survenue lors de la suppression des enregistrements de configuration du plugin « {$a} ».';
$string['errorsetting'] = 'Impossible d\'enregistrer le réglage';
$string['errorwithsettings'] = 'Certains réglages n\'ont pas pu être modifiés en raison d\'une erreur.';
$string['everyonewhocan'] = 'Tous les utilisateurs pouvant « {$a} »';
$string['exceptions'] = 'Exceptions';
$string['execpathnotallowed'] = 'Le réglage des chemins d\'exécutables et chemins locaux est désactivé dans config.php';
$string['experimental'] = 'Expérimental';
$string['experimentalsettings'] = 'Réglages expérimentaux';
$string['extendedusernamechars'] = 'Autoriser les caractères spéciaux dans les noms d\'utilisateur';
$string['extramemorylimit'] = 'Limite supplémentaire de mémoire PHP';
$string['fatalmagicquotesruntime'] = '<p>Grave erreur de configuration détectée. Veuillez en informer l\'administrateur du serveur.</p><p>Pour fonctionner correctement, Moodle nécessite la modification de certains réglages PHP par l\'administrateur.</p><p><code>magic_quotes_runtime</code> doit être réglé sur <code>off</code>.</p><p>Ce paramètre se règle en modifiant le fichier <code>php.ini</code>, la configuration de<br />Apache/IIS ou le fichier <code>.htaccess</code> sur le serveur.</p>';
$string['fatalsessionautostart'] = '<p>Grave erreur de configuration détectée. Veuillez en informer l\'administrateur du serveur.</p><p>Pour fonctionner correctement, Moodle nécessite la modification de certains réglages PHP par l\'administrateur.</p><p><code>session.auto_start</code> doit être réglé sur <code>off</code>.</p><p>Ce paramètre se règle en modifiant le fichier <code>php.ini</code>, la configuration de<br />Apache/IIS ou le fichier <code>.htaccess</code> sur le serveur.</p>';
$string['filecreated'] = 'Nouveau fichier créé';
$string['filestoredin'] = 'Enregistre le fichier dans le dossier :';
$string['filestoredinhelp'] = 'Où le fichier doit être stocké';
$string['filterall'] = 'Filtrer toutes les chaînes de caractères';
$string['filtermatchoneperpage'] = 'Filtrer une occurrence par page';
$string['filtermatchonepertext'] = 'Filtrer une occurrence par élément';
$string['filters'] = 'Filtres';
$string['filtersettings'] = 'Gestion des filtres';
$string['filtersettingsgeneral'] = 'Réglages généraux des filtres';
$string['filteruploadedfiles'] = 'Filtrer les fichiers déposés';
$string['forcelogin'] = 'Imposer la connexion';
$string['forceloginforprofileimage'] = 'Imposer la connexion pour voir les avatars';
$string['forceloginforprofileimage_help'] = 'Si ce réglage est activé, les utilisateurs doivent se connecter afin de voir les images des profils des utilisateurs (avatars). L\'avatar générique sera utilisé pour toutes les notifications par courriel.';
$string['forceloginforprofiles'] = 'Imposer la connexion pour voir les profils';
$string['forcetimezone'] = 'Imposer un fuseau horaire';
$string['formatuninstallwithcourses'] = 'Le format de cours {$a->format} est utilisé dans {$a->count} cours. Après sa suppression, ces cours auront le format {$a->defaultformat} (format par défaut). Certaines données spécifiques au format pourraient être perdues. Voulez-vous vraiment continuer ?';
$string['frontpage'] = 'Page d\'accueil';
$string['frontpagebackup'] = 'Sauvegarde page d\'accueil';
$string['frontpagedefaultrole'] = 'Rôle par défaut sur la page d\'accueil';
$string['frontpagefilters'] = 'Filtres de la page d\'accueil';
$string['frontpageloggedin'] = 'Éléments de la page d\'accueil, une fois connecté';
$string['frontpageoverrides'] = 'Dérogations aux permissions de la page d\'accueil';
$string['frontpagequestions'] = 'Questions de la page d\'accueil';
$string['frontpagerestore'] = 'Restauration page d\'accueil';
$string['frontpageroles'] = 'Rôles page d\'accueil';
$string['frontpagesettings'] = 'Réglages page d\'accueil';
$string['fullnamedisplay'] = 'Format d\'affichage des noms complets';
$string['fullnamedisplayprivate'] = 'Format d\'affichage des noms complets – privé';
$string['gdrecommended'] = 'L\'extension GD est utilisée pour convertir les images. Certaines fonctionnalités, par exemple les avatars des profils, ne seront pas disponibles si GD est manquant.';
$string['gdrequired'] = 'L\'extension GD est désormais requise par Moodle pour modifier les images.';
$string['generalsettings'] = 'Réglages généraux';
$string['geoipfile'] = 'Fichier des données GeoIP City';
$string['getremoteaddrconf'] = 'Source de l\'adresse IP enregistrée';
$string['globalswarning'] = '<p><strong>NOTIFICATION DE SÉCURITÉ !</strong></p><p>Pour fonctionner correctement, Moodle nécessite <br />certaines modifications de vos réglages PHP actuels.<p/><p>Vous <em>devez</em> spécifier le réglage <code>register_globals=off</code>.<p>Ce réglage s\'effectue en modifiant le fichier <code>php.ini</code>, la configuration <br />de Apache/IIS ou le fichier <code>.htaccess</code>.</p>';
$string['googlemapkey3'] = 'Clef de Google Maps API v3';
$string['googlemapkey3_help'] = 'Vous devez saisir une clef spéciale pour utiliser Google Maps pour la localisation des adresses IP. Vous pouvez obtenir gratuitement une telle clef sur <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>.';
$string['gotofirst'] = 'Afficher la première chaîne manquante';
$string['gradebook'] = 'Carnet de notes';
$string['gradebookroles'] = 'Rôles évalués';
$string['gradeexport'] = 'Modules principaux d\'exportation des notes';
$string['gravatardefaulturl'] = 'URL de l\'image Gravatar par défaut';
$string['gravatardefaulturl_help'] = 'Gravatar a besoin d\'une image à afficher par défaut s\'il n\'arrive pas à trouver d\'image pour un utilisateur donné. Veuillez indiquer une URL complète. Si vous laissez vide ce réglage, Moodle tentera d\'utiliser une image la plus adéquate possible selon la page consultée. Gravatar permet d\'utiliser divers codes pouvant être utilisés pour <a href="https://en.gravatar.com/site/implement/images/#default-image">générer des images par défaut</a>.';
$string['groupenrolmentkeypolicy'] = 'Règles pour les clefs d\'inscription aux groupes';
$string['groupenrolmentkeypolicy_desc'] = 'L\'activation de ce réglage permet d\'imposer aux clefs d\'inscription aux groupes les règles définies pour les mots de passe.';
$string['guestroleid'] = 'Rôle du compte « Visiteur anonyme »';
$string['guestroleid_help'] = 'Ce rôle est automatiquement attribué au compte Utilisateur anonyme. Il est également attribué temporairement aux utilisateurs qui entrent dans un cours via le plugin d\'inscription des utilisateurs anonymes.';
$string['helpadminseesall'] = 'Les administrateurs voient-ils tous les événements du calendrier ou seulement leurs propres événements ?';
$string['helpcalendarcustomexport'] = 'Activer des intervalles de dates personnalisés dans l\'exportation des calendriers. L\'exportation des calendriers doit être activée pour que ce réglage soit utilisé.';
$string['helpexportlookahead'] = 'Le nombre de jours après la date d\'aujourd\'hui durant lesquels des événements doivent être recherchés afin de les exporter lors des exportations personnalisées.';
$string['helpexportlookback'] = 'Le nombre de jours avant la date d\'aujourd\'hui durant lesquels des événements doivent être recherchés afin de les exporter lors des exportations personnalisées.';
$string['helpforcetimezone'] = 'Vous pouvez autoriser les utilisateurs à choisir leur fuseau horaire ou imposer le même fuseau horaire pour tous.';
$string['helpshowicalsource'] = 'Si vous activez ce réglage, le nom et le lien du calendrier abonné seront affichés pour les événements importés.';
$string['helpsitemaintenance'] = 'Activer le mode de maintenance';
$string['helpstartofweek'] = 'Quel est le premier jour de la semaine dans le calendrier ?';
$string['helpupcominglookahead'] = 'Par défaut, combien de jours dans le futur le calendrier considère-t-il les événements à venir ?';
$string['helpupcomingmaxevents'] = 'Par défaut, quel est le nombre maximum d\'événements à venir affichés ?';
$string['helpweekenddays'] = 'Quel jours sont traités comme jours du « week-end » et affichés d\'une couleur différente ?';
$string['hiddenuserfields'] = 'Masquer les champs des utilisateurs';
$string['hidefromall'] = 'Cacher pour tous les utilisateurs';
$string['hidefromnone'] = 'Ne pas cacher';
$string['hidefromstudents'] = 'Cacher pour les étudiants';
$string['htmleditor'] = 'Éditeur WYSIWYG';
$string['htmleditorsettings'] = 'Réglages éditeur';
$string['htmlsettings'] = 'Réglages HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Sécurité HTTP';
$string['hubs'] = 'Serveurs d\'échange';
$string['iconvrecommended'] = 'Bien que l\'extension ICONV de PHP soit facultative, il est vivement recommandé de l\'installer sur le serveur pour de meilleures performances, notamment si votre site supporte des caractères non latins.';
$string['iconvrequired'] = 'L\'installation de l\'extension ICONV de PHP est requise.';
$string['ignore'] = 'Ignorer';
$string['includemoduleuserdata'] = 'Inclure les données utilisateurs des modules';
$string['incompatibleblocks'] = 'Blocs incompatibles';
$string['installhijacked'] = 'L\'installation doit être terminée depuis la même adresse IP.';
$string['installsessionerror'] = 'Impossible d\'initialiser la session PHP. Veuillez vérifier que votre navigateur accepte les cookies.';
$string['intlrecommended'] = 'L\'installation de l\'extension optionnelle Intl de PHP est utilisée pour améliorer le support de l\'internationalisation, par exemple pour les tris alphabétiques.';
$string['invalidsection'] = 'Section non valide.';
$string['invaliduserchangeme'] = 'Le nom d\'utilisateur « changeme » est réservé. Il n\'est pas permis de créer un compte de ce nom.';
$string['ipblocked'] = 'Ce site n\'est actuellement pas accessible.';
$string['ipblocker'] = 'Blocage IP';
$string['ipblockersyntax'] = 'Indiquer une adresse (complète ou partielle) ou une plage d\'adresses par ligne. Des entrées valides sont soit une adresse IP complète (par exemple <b>192.168.10.1</b>), qui correspond à un seul serveur, soit une adresse IP partielle, (par exemple <b>192.168.</b>), qui correspond à la plage des adresses commençant par ces nombres, ou une adresse en format CIDR (par exemple <b>231.54.211.0/20</b>), ou encore une plage d\'adresses IP (par exemple <b>231.3.56.10-20</b>) dans laquelle la plage est indiquée sur la dernière partie de l\'adresse. Les noms de domaines (comme « exemple.fr ») ne sont pas autorisés. Les lignes vides sont ignorées.';
$string['iplookup'] = 'Recherche d\'adresse IP';
$string['iplookupgeoplugin'] = 'Le service <a href="http://www.geoplugin.com">geoPlugin</a> est actuellement utilisé pour obtenir les informations géographiques. Pour des résultats plus précis, l\'installation d\'une copie locale de la base de données MaxMind GeoLite est recommandée.';
$string['iplookupinfo'] = 'Par défaut, Moodle utilise le service en ligne gratuit NetGeo (Internet Geographic Database) pour afficher la localisation des adresses IP. Malheureusement cette base de données n\'est plus entretenue et peut fournir des résultats <em>totalement faux</em>. Il est recommandé d\'installer sur votre serveur une copie gratuite de la base de données GeoLite City de MaxMind.<br />La localisation des adresses IP est affichée sur une simple carte ou à l\'aide de Google Maps. Veuillez remarquer que vous aurez besoin d\'un compte Google et de demander une clef gratuite pour l\'utilisation de l\'API de Google Maps API pour activer les cartes interactives.';
$string['iplookupmaxmindnote'] = 'Ce produit comprend les données GeoLite créées par MaxMind, disponibles gratuitement chez <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Conserver la casse des tags';
$string['lang'] = 'Langue par défaut';
$string['langcache'] = 'Cache du menu des langues';
$string['langcache_desc'] = 'Mettre en cache le menu des langues. L\'activation de cette option met en cache la liste des langues disponibles. Le cache est automatiquement reconstruit lors de l\'installation ou de la suppression d\'une langue par le gestionnaire des langues de Moodle. Si vous installez une langue manuellement, veuillez utiliser la fonction de purge des caches pour actualiser la liste.';
$string['langlist'] = 'Langues du menu des langues';
$string['langmenu'] = 'Afficher le menu des langues';
$string['langpackwillbeupdated'] = 'Au cours de la mise à jour, Moodle mettra également à jour les paquetages de langue installés.';
$string['langstringcache'] = 'Mettre en cache toutes les chaînes de langue';
$string['languagesettings'] = 'Réglages langue';
$string['latexpreamble'] = 'Préambule LaTeX';
$string['latexsettings'] = 'Réglages de LaTeX Renderer';
$string['latinexcelexport'] = 'Encodage Excel';
$string['legacyfilesaddallowed'] = 'Permettre l\'ajout de fichiers aux fichiers de cours obsolètes';
$string['legacyfilesaddallowed_help'] = 'Si un cours contient des fichiers de cours obsolètes, permettre d\'y ajouter de nouveaux fichiers et dossiers.';
$string['legacyfilesinnewcourses'] = 'Fichiers du cours (obsolète) dans les nouveaux cours';
$string['legacyfilesinnewcourses_help'] = 'Par défaut, les zones de fichiers du cours (obsolètes) ne sont disponibles que dans les cours provenant de mises à jour de versions antérieures. Veuillez prendre note que certaines fonctionnalités, notamment la sauvegarde et la restauration d\'une activité unique, ne sont pas compatibles avec ce réglage.';
$string['licensesettings'] = 'Réglages de licence';
$string['linkadmincategories'] = 'Lier les catégories de l\'administration';
$string['linkadmincategories_help'] = 'Si ce réglage est activé, les catégories des paramètres de l\'administration seront affichées dans la navigation comme des liens menant aux pages des diverses catégories.';
$string['loading'] = 'Chargement';
$string['localetext'] = 'Locale du site';
$string['localstringcustomization'] = 'Modification locale des chaînes de caractères';
$string['location'] = 'Lieu';
$string['locationsettings'] = 'Réglages lieu';
$string['locked'] = 'Verrouillé';
$string['lockoutduration'] = 'Durée de blocage du compte';
$string['lockoutduration_desc'] = 'Les comptes bloqués seront automatiquement débloqués une fois cette durée écoulée';
$string['lockoutemailbody'] = 'Votre compte utilisateur « {$a->username} » sur le serveur « {$a->sitename} » a été bloqué suite à plusieurs tentatives de connexion non valides.

Pour débloquer votre compte immédiatement, veuillez consulter la page à l\'adresse

{$a->link}

Ce lien devrait être affiché sous la forme d\'un lien en bleu que vous pouvez cliquer directement. Si cela ne fonctionne pas, copiez l\'adresse et collez-la dans le champ de l\'URL en haut de la fenêtre de votre navigateur.

Si vous avez besoin d\'aide, veuillez contacter l\'administrateur du serveur {$a->admin}.';
$string['lockoutemailsubject'] = 'Votre compte sur {$a} a été bloqué';
$string['lockouterrorunlock'] = 'Information de déblocage du compte non valide.';
$string['lockoutthreshold'] = 'Limite pour blocage de compte';
$string['lockoutthreshold_desc'] = 'Indiquer le nombre de tentatives infructueuses successives de connexion déclenchant le blocage du compte. Cette fonctionnalité peut être utilisée lors d\'attaques en déni de service.';
$string['lockoutwindow'] = 'Période d\'observation pour blocage des comptes';
$string['lockoutwindow_desc'] = 'Période durant laquelle le nombre de tentatives infructueuses successives de connexion est contrôlé. Si aucune nouvelle tentative infructueuse n\'a lieu durant cette période, le compteur est remis à zéro.';
$string['log'] = 'Historiques';
$string['logguests'] = 'Enregistrer les historiques de l\'utilisateur anonyme';
$string['logguests_help'] = 'Ce réglage permet d\'enregistrer les actions du compte utilisateur anonyme et des utilisateurs non authentifiés. Les sites avec un grand trafic de visiteurs anonymes devraient désactiver cette option en cas de baisse de performance. Il est recommandé d\'activer ce réglage sur les sites en production.';
$string['loginhttps'] = 'Utiliser HTTPS pour les connexions';
$string['loginpageautofocus'] = 'Curseur automatique dans les champs du formulaire de connexion';
$string['loginpageautofocus_help'] = 'L\'activation de ce réglage améliore l\'ergonomie de la page de connexion, au prix d\'une accessibilité diminuée (car le placement automatique du curseur dans les champs de saisie n\'est pas toujours accessible).';
$string['loginpasswordautocomplete'] = 'Empêcher l\'auto-complétion du mot de passe sur le formulaire de connexion';
$string['loginpasswordautocomplete_help'] = 'Si ce réglage est activé, les utilisateurs ne peuvent pas enregistrer le mot de passe de leur compte dans leur navigateur.';
$string['loglifetime'] = 'Conserver les historiques durant';
$string['longtimewarning'] = '<b>Veuillez remarquer que ce processus peut prendre beaucoup de temps.</b>';
$string['maintenancemode'] = 'En mode de maintenance';
$string['maintenancemodeisscheduled'] = 'Le site passera en mode de maintenance dans {$a} minutes';
$string['maintfileopenerror'] = 'Erreur lors de l\'ouverture des fichiers de maintenance !';
$string['maintinprogress'] = 'Opérations de maintenance en cours...';
$string['manageformats'] = 'Gérer les formats de cours';
$string['manageformatsgotosettings'] = 'Le format par défaut peut être changé dans {$a}';
$string['managelang'] = 'Gérer';
$string['managelicenses'] = 'Gérer les licences';
$string['manageqbehaviours'] = 'Gérer les comportements de question';
$string['manageqtypes'] = 'Gérer les types de question';
$string['maturity100'] = 'Bêta';
$string['maturity150'] = 'Version candidate';
$string['maturity200'] = 'Version stable';
$string['maturity50'] = 'Alpha';
$string['maturityallowunstable'] = 'Conseil : lancer ce script avec l\'option --allow-unstable';
$string['maturitycoreinfo'] = 'Votre site utilise actuellement du code de développement instable « {$a} ».';
$string['maturitycorewarning'] = 'Vous êtes sur le point d\'installer une version ou de mettre à jour Moodle vers un version marquée comme « {$a} », qui n\'est pas considérée comme prête pour la production. Veuillez vous assurer que cette action est intentionnelle et que vous utilisez la version voulue de Moodle.';
$string['maxbytes'] = 'Taille maximale des fichiers déposés';
$string['maxconsecutiveidentchars'] = 'Caractères identiques consecutifs';
$string['maxeditingtime'] = 'Durée maximale de modification des messages';
$string['maxusersperpage'] = 'Nombre maximum d\'utilisateurs par page';
$string['mbstringrecommended'] = 'Bien que la bibliothèque MBSTRING soit facultative, il est vivement recommandé de l\'installer sur le serveur pour de meilleures performances, notamment si votre site supporte des caractères non latins.';
$string['mediapluginavi'] = 'Activer le filtre .avi';
$string['mediapluginflv'] = 'Activer le filtre .flv';
$string['mediapluginimg'] = 'Activer l\'intégration automatique d\'images liées';
$string['mediapluginmov'] = 'Activer le filtre .mov';
$string['mediapluginmp3'] = 'Activer le filtre .mp3';
$string['mediapluginmpg'] = 'Activer le filtre .mpg';
$string['mediapluginogg'] = 'Autoriser le filtre .ogg';
$string['mediapluginogv'] = 'Autoriser le filtre .ogv';
$string['mediapluginram'] = 'Activer le filtre .ram';
$string['mediapluginrm'] = 'Activer le filtre .rm';
$string['mediapluginrpm'] = 'Activer le filtre .rpm';
$string['mediapluginswf'] = 'Activer le filtre .swf';
$string['mediapluginswfnote'] = 'Par mesure de sécurité, les utilisateurs normaux ne devraient pas avoir l\'autorisation d\'intégrer des fichiers flash au format swf.';
$string['mediapluginwmv'] = 'Activer le filtre .wmv';
$string['mediapluginyoutube'] = 'Activer le filtre YouTube';
$string['messaging'] = 'Activer la messagerie';
$string['messagingallowemailoverride'] = 'Adresse de notification de remplacement';
$string['messagingdeletereadnotificationsdelay'] = 'Supprimer les notifications de lecture';
$string['messaginghidereadnotifications'] = 'Cacher les notifications de lecture';
$string['minpassworddigits'] = 'Chiffres';
$string['minpasswordlength'] = 'Longueur du mot de passe';
$string['minpasswordlower'] = 'Lettres minuscules';
$string['minpasswordnonalphanum'] = 'Caractères non alphanumériques';
$string['minpasswordupper'] = 'Lettres majuscules';
$string['misc'] = 'Divers';
$string['mnetrestore_extusers'] = '<strong>Remarque :</strong> ce fichier de sauvegarde contient des comptes utilisateurs distants provenant d\'un réseau Moodle, qui seront restaurés au cours du processus.';
$string['mnetrestore_extusers_admin'] = '<strong>Remarque :</strong> ce fichier de sauvegarde semble provenir d\'une installation de Moodle différente et contient des comptes utilisateurs distants du Réseau Moodle. Le processus de restauration tentera de faire correspondre les serveur Réseau Moodle pour tous les utilisateurs créés. Ceux qui n\'auront pas de correspondance seront automatiquement basculés en mode d\'authentification interne (au lieu de mnet). L\'historique de restauration vous informera à ce sujet.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Remarque :</strong> ce fichier de sauvegarde semble provenir d\'une installation de Moodle différente. Il contient des comptes utilisateurs distants provenant d\'un réseau Moodle dont la restauration pourrait échouer. Cette opération n\'est pas supportée. Si vous êtes vraiment certain que ce fichier a été créé sur ce Moodle, ou si vous pouvez vous assurer que tous les serveurs du réseau Moodle sont configurés correctement, vous pouvez malgré tout tenter la restauration.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Remarque :</strong> ce fichier de sauvegarde semble provenir d\'une installation de Moodle différente et contient des comptes utilisateurs distants du Réseau Moodle. Vous n\'êtes pas autorisé à effectuer ce type de restauration. Veuillez contacter l\'administrateur du site ou restaurer le cours sans les informations des utilisateurs (modules, fichiers, etc.)';
$string['mnetrestore_extusers_switchuserauth'] = 'Authentification de l\'utilisateur {$a->username} du Réseau Moodle distant (provenant de {$a->mnethosturl}) basculée vers utilisateur authentifié localement {$a->auth}.';
$string['mobile'] = 'Mobile';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Utiliser le sélecteur d\'activités';
$string['modeditdefaults'] = 'Valeurs par défaut des réglages des activités';
$string['modeditingmenu'] = 'Menus d\'édition des activités';
$string['modeditingmenu_desc'] = 'Si ce réglage est activé, certaines icônes d\'édition des activités seront affichées dans un menu déroulant, ce qui réduit l\'encombrement de l\'affichage en cachant les icônes tant qu\'elles ne sont pas utilisées.';
$string['modsettings'] = 'Gestion des activités';
$string['modulesecurity'] = 'Sécurité modules';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Imposer l\'ancienne syntaxe du filtre multilingue : &lt;span&gt; sans class="multilang" et &lt;lang&gt;';
$string['mustenablestats'] = 'Les statistiques n\'ont pas encore été activées sur ce site.';
$string['mycoursesperpage'] = 'Nombre de cours';
$string['mydashboard'] = 'Tableau de bord par défaut';
$string['mymoodle'] = 'Ma page';
$string['mymoodleredirect'] = 'Imposer aux utilisateurs l\'utilisation de Ma page';
$string['mypage'] = 'Ma page d\'accueil par défaut';
$string['mypagelocked'] = 'Verrouiller la page par défaut';
$string['myprofile'] = 'Page de profil par défaut';
$string['mysql416bypassed'] = 'Toutefois, si votre site utilise UNIQUEMENT des langues encodées en iso-8859-1 (latin), vous pouvez continuer à utiliser votre version actuelle de MySQL 4.1.12 (ou ultérieure).';
$string['mysql416required'] = 'MySQL 4.1.16 est la version minimale requise pour Moodle 1.6, afin de garantir que toutes les données pourront à l\'avenir être converties en encodage UTF-8.';
$string['navadduserpostslinks'] = 'Ajouter des liens permettant d\'afficher les messages postés par l\'utilisateur';
$string['navadduserpostslinks_help'] = 'Quand ce réglage est activé, deux liens seront affichés dans le bloc de navigation, permettant de consulter les discussions lancées par l\'utilisateur et les messages qu\'il a postés sur les forums du site ou de cours spécifiques.';
$string['navcourselimit'] = 'Limite de cours';
$string['navigationupgrade'] = 'Cette mise à jour introduit deux nouveaux blocs de navigation destinés à remplacer les blocs suivants : Administration, Cours, Activités et Participants. Si vous avez défini des droits d\'accès particuliers pour ces blocs, veuillez vérifier que tout fonctionne comme vous le désirez.';
$string['navshowallcourses'] = 'Afficher tous les cours';
$string['navshowcategories'] = 'Afficher les catégories de cours';
$string['navshowfrontpagemods'] = 'Afficher les activités de la page d\'accueil dans la navigation';
$string['navshowfrontpagemods_help'] = 'Si ce réglage est activé, les activités de la page d\'accueil seront affichées dans la navigation, au-dessous des pages de site.';
$string['navshowfullcoursenames'] = 'Afficher les noms complets des cours';
$string['navshowfullcoursenames_help'] = 'Si ce réglage est activé, les noms complets des cours seront utilisés dans la navigation, au lieu des noms abrégés.';
$string['navshowmycoursecategories'] = 'Afficher mes catégories de cours';
$string['navshowmycoursecategories_help'] = 'Si ce réglage est activé, les cours seront affichés dans leur catégorie, dans les listes des cours des utilisateurs.';
$string['navsortmycoursessort'] = 'Trier mes cours';
$string['navsortmycoursessort_help'] = 'Détermine si les cours dans Mes cours sont listés dans l\'ordre de tri actif (l\'ordre de tri indiqué dans Administration du site > Cours > Gestion des cours) ou suivant l\'ordre alphabétique.';
$string['neverdeleteruns'] = 'Ne jamais supprimer les profilages';
$string['nobookmarksforuser'] = 'Vous n\'avez pas de marque-page.';
$string['nodatabase'] = 'Pas de base de données';
$string['nohttpsformobilewarning'] = 'Il est recommande d\'activer HTTPS avec un certificat valide. L\'app Moodle tentera toujours d\'utiliser en premier une connexion sécurisée.';
$string['nomissingstrings'] = 'Aucune chaîne manquante';
$string['nonewsettings'] = 'Aucun nouveau réglage n\'a été ajouté lors de cette mise à jour.';
$string['nonexistentbookmark'] = 'Le marque-page demandé n\'existe pas.';
$string['noresults'] = 'Aucun résultat trouvé.';
$string['noroles'] = 'Pas de rôle';
$string['notifications'] = 'Notifications';
$string['notifyloginfailures'] = 'Envoyer les erreurs de connexion à';
$string['notifyloginthreshold'] = 'Seuil pour les notifications par courriel';
$string['notloggedinroleid'] = 'Rôle des utilisateurs non connectés';
$string['numberofmissingstrings'] = 'Nombre de chaînes de caractères manquantes : {$a}';
$string['numberofstrings'] = 'Nombre total de  chaînes de caractères : {$a->strings}<br />Manquantes : {$a->missing} ({$a->missingpercent} %)';
$string['opcacherecommended'] = 'La mise en cache PHP opcode améliore les performances et diminue les besoins en mémoire. L\'extension OPcache de PHP est recommandée et totalement supportée.';
$string['opensslrecommended'] = 'L\'installation de la bibliothèque optionnelle OpenSSL est vivement recommandée, afin de pouvoir utiliser la fonctionnalité Réseau Moodle.';
$string['opentogoogle'] = 'Ouvert à Google';
$string['optionalmaintenancemessage'] = 'Message de maintenance facultatif';
$string['order1'] = 'Premier';
$string['order2'] = 'Deuxième';
$string['order3'] = 'Troisième';
$string['order4'] = 'Quatrième';
$string['passwordpolicy'] = 'Règles pour les mots de passe';
$string['passwordresettime'] = 'Durée maximale pour valider la demande de réinitialisation du mot de passe';
$string['pathconvert'] = 'Chemin d\'accès du logiciel <i>convert</i>';
$string['pathdvips'] = 'Chemin d\'accès du logiciel <i>dvips</i>';
$string['pathlatex'] = 'Chemin d\'accès du logiciel <i>latex</i>';
$string['pathtoclam'] = 'Chemin d\'accès du logiciel <i>clam AV</i>';
$string['pathtodot'] = 'Chemin d\'accès du logiciel <i>dot</i>';
$string['pathtodot_help'] = 'En principe /usr/bin/dot. Pour permettre de générer des fichiers graphiques à partir de fichiers DOT, vous devez installer l’exécutable dot et indiquer ici son chemin d\'accès. Ceci n\'est pour l\'instant utilisé que dans les fonctions de profilage de Moodle (Développement -> Profilage).';
$string['pathtodu'] = 'Chemin d\'accès du logiciel <i>du</i>';
$string['pathtopgdump'] = 'Chemin d\'accès du logiciel <i>pg_dump</i>';
$string['pathtopgdumpdesc'] = 'Il n\'est nécessaire de renseigner ce champ que si vous avez plus d\'un programme <i>pg_dump</i> sur votre serveur (par exemple si plus d\'une version de postgresql est installée)';
$string['pathtopgdumpinvalid'] = 'Chemin d\'accès à <i>pg_dump</i> non valide. Le chemin est incorrect ou le programme n\'est pas exécutable';
$string['pathtopsql'] = 'Chemin d\'accès du logiciel <i>psql</i>';
$string['pathtopsqldesc'] = 'Il n\'est nécessaire de renseigner ce champ que si vous avez plus d\'un programme <i>psql</i> sur votre serveur (par exemple si plus d\'une version de postgresql est installée)';
$string['pathtopsqlinvalid'] = 'Chemin d\'accès à <i>psql</i> non valide. Le chemin est incorrect ou le programme n\'est pas exécutable';
$string['pcreunicodewarning'] = 'Il est vivement recommandé d\'utiliser l\'extension PCRE de PHP, qui est compatible avec les caractères Unicode.';
$string['perfdebug'] = 'Informations de performance';
$string['performance'] = 'Performance';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'Paramètre de version/cluster de PostgreSQL pour les opérations en ligne de commande. Si vous n\'avez qu\'un seul postgresql sur votre serveur ou n\'êtes pas sûr de ce dont il s\'agit, laissez ce champ vide.';
$string['php50restricted'] = 'Les versions 5.0.x de PHP ont plusieurs problèmes connus. Veuillez mettre à jour PHP à la version 5.1.x ou revenir à une version 4.3.x ou 4.4.x';
$string['php533warning'] = 'PHP 5.3.3 ou ultérieur est recommandé';
$string['phpfloatproblem'] = 'Un problème a été détecté dans le traitement des nombres par PHP : {$a}';
$string['pleaserefreshregistration'] = 'Votre site a été enregistré sur moodle.org. Veuillez envisager de mettre à jour cet enregistrement si des modifications importantes sont survenues depuis votre dernière mise à jour, le {$a}';
$string['pleaseregister'] = 'Pour enlever ce bouton, veuillez enregistrer votre site';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Plugins';
$string['pluginscheck'] = 'Vérification des dépendances des plugins';
$string['pluginscheckfailed'] = 'La vérification des dépendances des plugins a échoué pour {$a->pluginslist}';
$string['pluginschecktodo'] = 'Toutes les exigences nécessaires pour les plugins doivent être satisfaites avant d\'installer cette version de Moodle !';
$string['pluginsoverview'] = 'Vue d\'ensemble des plugins';
$string['pluginsoverviewsee'] = 'Voir <a href="{$a->url}">la vue d\'ensemble des plugins</a> pour plus de détails.';
$string['profilecategory'] = 'Catégorie';
$string['profilecategoryname'] = 'Nom de catégorie (doit être unique)';
$string['profilecategorynamenotunique'] = 'Ce nom de catégorie est déjà utilisé';
$string['profilecommonsettings'] = 'Réglages communs';
$string['profileconfirmcategorydeletion'] = 'Le(s) {$a} champ(s) de cette catégorie seront déplacés dans la catégorie ci-dessus (ou ci-dessous s\'ils sont dans la catégorie racine).<br />Voulez-vous vraiment supprimer cette catégorie ?';
$string['profileconfirmfielddeletion'] = 'Les {$a} enregistrement(s) de ce champ seront supprimés.<br />Voulez-vous vraiment supprimer ce champ ?';
$string['profilecreatecategory'] = 'Créer une nouvelle catégorie de profil';
$string['profilecreatefield'] = 'Créer un nouveau champ de profil :';
$string['profilecreatenewcategory'] = 'Création d\'une catégorie';
$string['profilecreatenewfield'] = 'Création d\'un nouveau champ de profil « {$a} »';
$string['profiledefaultcategory'] = 'Autres champs';
$string['profiledefaultchecked'] = 'Cochée par défaut';
$string['profiledefaultdata'] = 'Valeur par défaut';
$string['profiledeletecategory'] = 'Suppression d\'une catégorie';
$string['profiledeletefield'] = 'Suppression du champ « {$a} »';
$string['profiledescription'] = 'Description du champ';
$string['profiledscript'] = 'Ce script a été profilé';
$string['profiledscriptview'] = 'Afficher l\'information de profilage de ce script';
$string['profileeditcategory'] = 'Modification de la catégorie&nbsp;: {$a}';
$string['profileeditfield'] = 'Modification du champ&nbsp;: {$a}';
$string['profilefield'] = 'Champ de profil';
$string['profilefieldcolumns'] = 'Colonnes';
$string['profilefieldispassword'] = 'Champ mot de passe';
$string['profilefieldlink'] = 'Lien';
$string['profilefieldlink_help'] = 'Pour transformer un texte en lien, tapez une URL contenant $$. Les $$ seront remplacés par le texte. Par exemple pour transformer un identifiant Twitter en lien, tapez http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Cible du lien';
$string['profilefieldmaxlength'] = 'Longueur maximale';
$string['profilefieldrows'] = 'Lignes';
$string['profilefields'] = 'Champs du profil';
$string['profilefieldsize'] = 'Taille d\'affichage';
$string['profileforceunique'] = 'Les données du champ doivent-elles être uniques ?';
$string['profileinvaliddata'] = 'Valeur incorrecte';
$string['profilelocked'] = 'Ce champ est-il verrouillé ?';
$string['profilemenudefaultnotinoptions'] = 'La valeur par défaut n\'est pas une des options';
$string['profilemenunooptions'] = 'Aucune option de menu n\'est donnée';
$string['profilemenuoptions'] = 'Options de menu (une par ligne)';
$string['profilemenutoofewoptions'] = 'Vous devez fournir au moins 2 options';
$string['profilename'] = 'Nom';
$string['profilenofieldsdefined'] = 'Aucun champ n\'a été défini';
$string['profilerequired'] = 'Ce champ est-il requis ?';
$string['profileroles'] = 'Rôles affichés dans les profils';
$string['profilesforenrolledusersonly'] = 'Affichage du profil des utilisateurs inscrits à des cours uniquement';
$string['profileshortname'] = 'Nom abrégé (doit être unique)';
$string['profileshortnamenotunique'] = 'Ce nom abrégé est déjà utilisé';
$string['profilesignup'] = 'Afficher sur la page de création de compte ?';
$string['profilespecificsettings'] = 'Réglages spécifiques';
$string['profilevisible'] = 'Pour qui ce champ est-il visible ?';
$string['profilevisibleall'] = 'Visible pour tous';
$string['profilevisible_help'] = '* caché : pour les données privées, uniquement visible pour les administrateurs
* visible pour l\'utilisateur : pour les données personnelles, visibles par l\'utilisateur et les administrateurs
* visible pour tous';
$string['profilevisiblenone'] = 'Caché';
$string['profilevisibleprivate'] = 'Visible pour l\'utilisateur';
$string['profiling'] = 'Profilage';
$string['profilingallowall'] = 'Profilage en continu';
$string['profilingallowall_help'] = 'Si vous activez ce réglage, vous pourrez utiliser à tout moment le paramètre PROFILEALL pour activer le profilage de tous les scripts exécutés au cours d\'une session Moodle. De façon analogue, vous pourrez utiliser le paramètre PROFILEALLSTOP pour stopper le profilage.';
$string['profilingallowme'] = 'Profilage sélectif';
$string['profilingallowme_help'] = 'Si vous activez ce réglage, vous pourrez utiliser sélectivement le paramètre PROFILEME et le profilage du script concerné aura lieu. De façon analogue, vous pourrez utiliser le paramètre DONTPROFILEME pour éviter le profilage.';
$string['profilingautofrec'] = 'Profilage automatique';
$string['profilingautofrec_help'] = 'Après configuration de ce réglage, certaines requêtes (aléatoires, sur la base de la fréquence spécifiée, 1 sur N) seront choisies et profilées automatiquement, et les résultats du profilage seront stockés pour analyse ultérieure. Ce type de profilage respecte les réglages d\'inclusion/exclusion. Une valeur 0 désactive le profilage automatique.';
$string['profilingenabled'] = 'Activer le profilage';
$string['profilingenabled_help'] = 'Ce réglage permet d\'activer le profilage pour votre site. Vous pourrez alors définir comment le profilage se déroule à l\'aide des options ci-dessous.';
$string['profilingexcluded'] = 'Exclure du profilage';
$string['profilingexcluded_help'] = 'Liste d\'URLs (séparés par des virgules) qui seront exclus du profilage.';
$string['profilingimportprefix'] = 'Préfixe d\'importation de profilage';
$string['profilingimportprefix_desc'] = 'Pour faciliter la détection, toutes les exécutions de profilage importées seront préfixées avec le texte renseigné ici.';
$string['profilingincluded'] = 'Scripts à profiler';
$string['profilingincluded_help'] = 'Liste d\'URLs (séparés par des virgules) qui seront automatiquement profilés. Exemples : /index.php, /course/view.php. Ce champ accepte le caractère joker * à n\'importe quel endroit, par exemple /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Conserver les profilages';
$string['profilinglifetime_help'] = 'Veuillez indiquer le laps de temps durant lequel vous désirez conserver les informations d\'anciens profilages. Les plus anciens seront supprimés périodiquement. Les profilages marqués comme « profilage de référence » ne sont pas concernés par ce réglage et seront de toute manière conservés.';
$string['protectusernames'] = 'Protéger les noms d\'utilisateur';
$string['proxybypass'] = 'Exceptions du proxy';
$string['proxyhost'] = 'Hôte du proxy';
$string['proxypassword'] = 'Mot de passe du proxy';
$string['proxyport'] = 'Port du proxy';
$string['proxytype'] = 'Type de proxy';
$string['proxyuser'] = 'Nom d\'utilisateur du proxy';
$string['purgecaches'] = 'Vider tous les caches';
$string['purgecachesconfirm'] = 'Moodle peut placer en cache les thèmes, le code Javascript, les chaînes de caractères traduites, le texte filtré, les flux RSS et beaucoup d\'autres données calculées. En effaçant ces caches, des données seront supprimées du serveur et forceront les navigateurs à recalculer les données pour être sûr que les données affichées sont bien celles qui sont à jour. L\'effacement des caches ne cause aucun problème, mais votre site semblera plus lent durant un certain temps, car le serveur et les clients devront calculer les nouvelles données et les placer en cache.';
$string['purgecachesfinished'] = 'Tous les caches ont été vidés.';
$string['qtyperqpwillberemoved'] = 'Au cours de cette mise à jour, le type de question RQP sera supprimé. Vous n\'utilisiez pas ce type de question, et ne souffrirez donc d\'aucun problème.';
$string['qtyperqpwillberemovedanyway'] = 'Au cours de cette mise à jour, le type de question RQP sera supprimé. Votre base de données comporte des questions RQP, qui ne fonctionneront plus, à moins que vous ne réinstalliez le code disponible sur http://moodle.org/mod/data/view.php?d=13&amp;rid=797 avant de continuer la mise à jour.';
$string['quarantinedir'] = 'Dossier de quarantaine';
$string['question'] = 'Question';
$string['questionbehaviours'] = 'Comportements de question';
$string['questioncwqpfscheck'] = 'Une ou plusieurs questions aléatoires d\'un test tire ses questions de catégories partagées et de catégories non partagées. Un rapport plus détaillé est visible <a href="{$a->reporturl}">ici</a>. Veuillez consulter Moodle Docs sur <a href="{$a->docsurl}">cette page</a>.';
$string['questioncwqpfsok'] = 'Il n\'y a dans vos tests aucune question aléatoire tirant ses questions de catégories partagées et de catégories non partagées.';
$string['questiontype'] = 'Type de question';
$string['questiontypes'] = 'Types de question';
$string['quizattemptsupgradedmessage'] = 'Une mise à jour majeure des questions était comprise dans Moodle 2.1. Il était alors possible de retarder cette mise à niveau. Avant de passer à Moodle 2.7, cette mise à jour est désormais obligatoire.';
$string['recaptchaprivatekey'] = 'Clef privée ReCAPTCHA';
$string['recaptchapublickey'] = 'Clef publique ReCAPTCHA';
$string['register'] = 'Enregistrer votre site';
$string['registermoodleorg'] = 'Lors de l\'enregistrement de votre site avec {$a}';
$string['registermoodleorgli1'] = 'Vous êtes inscrit à une liste de diffusion à bas trafic diffusant des notifications importantes, comme des alertes de sécurité et les nouvelles versions de Moodle.';
$string['registermoodleorgli2'] = 'Des statistiques sur votre site sont ajoutées aux {$a} de la communauté mondiale de Moodle.';
$string['registermoodleorgli3'] = 'Vous êtes aussi enregistré sur Moodle.net ({$a}), ce qui permet aux utilisateurs avec la capacité de publier des cours (par défaut, seulement les gestionnaires) de publier des cours sur Moodle.net.';
$string['registerwithmoodleorg'] = 'Enregistrer sur Moodle.org';
$string['registration'] = 'Enregistrement';
$string['registration_help'] = 'L\'enregistrement de votre site sur Moodle.org est recommandé, afin de recevoir les alertes de sécurité par courriel, de contribuer aux <a href="http://moodle.org/stats">statistiques d\'usage de Moodle</a> ou pour partager des cours sur <a href="http://moodle.net/">Moodle.net</a>.';
$string['registrationwarning'] = 'Votre site n\'est pas encore enregistré.';
$string['releasenoteslink'] = 'Pour des informations sur cette version de Moodle, veuillez consulter les <a target="_blank" href="{$a}">Notes de mise à jour</a> en ligne.';
$string['rememberusername'] = 'Se souvenir du nom de l\'utilisateur';
$string['rememberusername_desc'] = 'Activez ce réglage si vous voulez stocker de façon permanente dans un cookie le nom de l\'utilisateur, lors de la connexion. Les cookies permanent peuvent soulever des questions de protection des données personnelles, s\'ils sont utilisés sans le consentement de l\'utilisateur.';
$string['reportsmanage'] = 'Gérer les rapports';
$string['requestcategoryselection'] = 'Activer le choix de catégorie';
$string['requiredentrieschanged'] = '<strong>IMPORTANT !<br />(Ce message d\'avertissement ne sera affiché que durant cette mise à jour.)</strong><br/>En raison de la correction d\'un bogue, le comportement des bases de données qui utilisent les réglages « Fiches requises » et « Fiches requises avant consultation » est modifié. Une explication détaillée des changements peut être lue dans le <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">forum dédié au module Base de données (en anglais)</a> et <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs (en anglais pour l\'instant)</a>.<br/><br/>Cette modification a un impact sur les bases de données suivantes de votre Moodle : (veuillez enregistrer cette liste maintenant et, une fois la mise à jour effectuée, vérifier que ces activités continuent de fonctionner de la façon désirée par l\'enseignant.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Exiger une description';
$string['requires'] = 'Requiert';
$string['restorernewroleid'] = 'Rôle de l\'utilisateur qui restaure un cours';
$string['restorernewroleid_help'] = 'Si l\'utilisateur qui restaure un cours n\'a pas l\'autorisation de gérer le cours nouvellement restauré, il est au besoin automatiquement inscrit au cours et ce rôle lui est attribué. Choisir « Aucun » si vous ne voulez pas que les utilisateurs qui restaurent des cours puissent gérer les cours restaurés.';
$string['reverseproxy'] = 'Proxy inverse';
$string['riskconfig'] = 'Les utilisateurs pourraient modifier la configuration et le comportement du site';
$string['riskconfigshort'] = 'Configuration des risques';
$string['riskdataloss'] = 'Les utilisateurs pourraient détruire une grande quantité de contenus ou d\'informations';
$string['riskdatalossshort'] = 'Risque de perte de données';
$string['riskmanagetrust'] = 'Les utilisateurs pourraient modifier les réglages de confiance d\'autres utilisateurs';
$string['riskmanagetrustshort'] = 'Gestion des réglages de confiance';
$string['riskpersonal'] = 'Les utilisateurs pourraient avoir accès aux informations personnelles d\'autres utilisateurs';
$string['riskpersonalshort'] = 'Risque lié à la protection des données';
$string['riskspam'] = 'Les utilisateurs pourraient envoyer du spam à des utilisateurs du site ou d\'autres personnes';
$string['riskspamshort'] = 'Risque de spam';
$string['riskxss'] = 'Les utilisateurs pourraient déposer des fichiers ou écrire des textes permettant le « cross-site scripting » (XSS)';
$string['riskxssshort'] = 'Risque XSS';
$string['roleswithexceptions'] = '{$a->roles}, avec {$a->exceptions}';
$string['rssglobaldisabled'] = 'Désactivé au niveau du site';
$string['runclamavonupload'] = 'Vérifier les fichiers déposés avec clam AV';
$string['save'] = 'Enregistrer';
$string['savechanges'] = 'Enregistrer les modifications';
$string['search'] = 'Recherche';
$string['searchinsettings'] = 'Recherche dans les paramètres';
$string['searchresults'] = 'Résultats';
$string['sectionerror'] = 'Erreur de section !';
$string['secureforms'] = 'Utiliser une meilleure sécurité pour les formulaires';
$string['security'] = 'Sécurité';
$string['selectdevice'] = 'Choisir un appareil';
$string['selecttheme'] = 'Choisir un thème pour l\'appareil {$a}';
$string['server'] = 'Serveur';
$string['serverchecks'] = 'Contrôles serveur';
$string['serverlimit'] = 'Limite serveur';
$string['sessionautostartwarning'] = '<p>Une grave erreur de configuration a été détectée. Veuillez en informer l\'administrateur du serveur.</p><p>Pour fonctionner correctement, Moodle a besoin que cet administrateur change les réglages PHP.</p><p>Le réglage <code>session.auto_start</code> doit être désactivé (<code>off</code>).</p><p>Ce réglage peut être modifié sur le serveur dans le fichier <code>php.ini</code>, dans la <br />configuration de Apache/IIS ou dans le fichier <code>.htaccess</code>.</p>';
$string['sessioncookie'] = 'Préfixe du cookie';
$string['sessioncookiedomain'] = 'Domaine du cookie';
$string['sessioncookiepath'] = 'Chemin d\'accès au cookie';
$string['sessionhandling'] = 'Gestion des sessions';
$string['sessiontimeout'] = 'Délai d\'attente';
$string['settingfileuploads'] = 'Le dépôt de fichiers est nécessaire pour un fonctionnement normal. Veuillez l\'activer dans la configuration de PHP.';
$string['settingmemorylimit'] = 'Mémoire insuffisante détectée. Veuillez fixer une limite de mémoire plus élevée dans la configuration de PHP.';
$string['settingsafemode'] = 'Moodle n\'est pas totalement compatible avec le <i>safe mode</i>. Veuillez demander à l\'administrateur du serveur de le désactiver. Le fonctionnement de Moodle avec le <i>safe mode</i> actif n\'est pas supporté. Vous rencontrerez vraisemblablement des problèmes si vous essayez.';
$string['showcommentscount'] = 'Afficher le nombre des commentaires';
$string['showdetails'] = 'Afficher les détails';
$string['showuseridentity'] = 'Afficher l\'identité de l\'utilisateur';
$string['showuseridentity_desc'] = 'Lors de la recherche ou de la sélection d\'utilisateurs, ainsi que lors de l\'affichage de listes d\'utilisateurs, ces champs peuvent être affichés en plus du nom complet. Ils ne sont montrés qu\'aux utilisateurs ayant la capacité moodle/site:viewuseridentity capability (par défaut, les gestionnaires et les enseignants). Ce réglage a plus de sens si vous imposez un ou deux champs obligatoires dans votre institution.';
$string['simplexmlrequired'] = 'L\'installation de l\'extension SimpleXML de PHP est maintenant requise par Moodle.';
$string['sitemaintenance'] = 'Ce site est actuellement en maintenance. Il est donc temporairement non disponible';
$string['sitemaintenancemode'] = 'Mode de maintenance';
$string['sitemaintenanceoff'] = 'Le mode de maintenance a été désactivé et le site fonctionne à nouveau normalement';
$string['sitemaintenanceon'] = 'Votre site est actuellement en mode maintenance (seuls les administrateurs peuvent se connecter et utiliser le site).';
$string['sitemaintenanceoncli'] = 'Votre site est actuellement en mode de maintenance CLI. Aucun accès web n\'est autorisé.';
$string['sitemaintenancewarning'] = 'Votre site est actuellement en mode de maintenance (seuls les administrateurs peuvent s\'y connecter). Pour revenir à un fonctionnement normal du site, veuillez <a href="maintenance.php">désactiver le mode de maintenance</a>.';
$string['sitemaintenancewarning2'] = 'Votre site est actuellement en mode de maintenance (seuls les administrateurs peuvent s\'y connecter). Pour revenir à un fonctionnement normal du site, veuillez <a href="{$a}">désactiver le mode de maintenance</a>.';
$string['sitepolicies'] = 'Règles site';
$string['sitepolicy'] = 'URL du règlement de site';
$string['sitepolicyguest'] = 'URL du règlement de site pour visiteurs anonymes';
$string['sitepolicyguest_help'] = 'Si vous voulez imposer aux visiteurs anonymes la lecture et l\'acceptation d\'un règlement avant d\'utiliser ce site, veuillez indiquer ici l\'URL de ce règlement. Dans le cas contraire, laissez le champ vide. N\'importe quelle URL publique peut être spécifiée. Vous pouvez empêcher l\'accès des visiteurs anonymes à votre site à l\'aide du réglage « Imposer la connexion ».';
$string['sitepolicy_help'] = 'Si vous voulez imposer à vos utilisateurs enregistrés la lecture et l\'acceptation d\'un règlement avant d\'utiliser ce site, veuillez indiquer ici l\'URL de ce règlement. Dans le cas contraire, laissez le champ vide. N\'importe quelle URL publique peut être spécifiée.';
$string['sitesectionhelp'] = 'Si cette option est activée, une section sera affichée sur la page d\'accueil du site.';
$string['slasharguments'] = 'Utiliser les « slash arguments »';
$string['smartpix'] = 'Recherche intelligente des icônes';
$string['soaprecommended'] = 'L\'installation de l\'extension optionnelle soap de PHP est utile pour les services web et d\'autres plugins tiers.';
$string['sort_fullname'] = 'Nom complet du cours';
$string['sort_idnumber'] = 'No identifiant du cours';
$string['sort_shortname'] = 'Nom abrégé du cours';
$string['sort_sortorder'] = 'Ordre de tri';
$string['spellengine'] = 'Vérificateur orthographique';
$string['spelllanguagelist'] = 'Liste des langues à vérifier orthographiquement';
$string['splrequired'] = 'L\'installation de l\'extension SPL de PHP est maintenant requise par Moodle.';
$string['stats'] = 'Statistiques';
$string['statsfirstrun'] = 'Intervalle maximal de traitement';
$string['statsmaxruntime'] = 'Temps maximal de traitement';
$string['statsmoodleorg'] = 'statistiques';
$string['statsruntimedays'] = 'Jours à traiter';
$string['statsruntimestart'] = 'Lancer à';
$string['statsuserthreshold'] = 'Seuil utilisateurs';
$string['stickyblocks'] = 'Blocs fixes';
$string['stickyblockscourseview'] = 'Page de cours';
$string['stickyblocksduplicatenotice'] = 'Si l\'un des blocs que vous ajoutez ici existe déjà sur une page, il y aura alors un doublon.<br />Seul celui qui est fixe ne sera pas modifiable. Le doublon pourra encore être modifié.';
$string['stickyblocksmymoodle'] = 'Ma page';
$string['stickyblockspagetype'] = 'Type de page à configurer';
$string['strictformsrequired'] = 'Validation stricte des champs requis';
$string['stripalltitletags'] = 'Retirer les balises HTML du nom des activités';
$string['supportcontact'] = 'Contact d\'assistance';
$string['supportemail'] = 'Courriel d\'assistance';
$string['supportname'] = 'Nom d\'assistance';
$string['supportpage'] = 'Page d\'assistance';
$string['suspenduser'] = 'Suspendre le compte utilisateur';
$string['switchlang'] = 'Changer de dossier de langue';
$string['systempaths'] = 'Chemins système';
$string['tablenosave'] = 'Les modifications dans la table ci-dessus sont enregistrées automatiquement.';
$string['tablesnosave'] = 'Les modifications dans les tables ci-dessus sont enregistrées automatiquement.';
$string['tabselectedtofront'] = 'Dans les tables avec onglets, la rangée contenant l\'onglet sélectionné doit-elle être ramenée au premier plan ?';
$string['tabselectedtofronttext'] = 'Ramener au premier plan la rangée de l\'onglet sélectionné';
$string['testsiteupgradewarning'] = 'Vous utilisez actuellement le site de test {$a}. Pour e mettre à jour correctement, veuillez utiliser l\'outil de mise à jour en ligne de commande.';
$string['themedesignermode'] = 'Mode concepteur de thème';
$string['themelist'] = 'Liste des thèmes';
$string['themenoselected'] = 'Aucun thème sélectionné';
$string['themeresetcaches'] = 'Vider les caches de thème';
$string['themeselect'] = 'Changer de thème';
$string['themeselector'] = 'Sélecteur de thème';
$string['themesettings'] = 'Réglages thème';
$string['therewereerrors'] = 'Des erreurs sont présentes dans vos données';
$string['thirdpartylibrary'] = 'Bibliothèque';
$string['thirdpartylibrarylocation'] = 'Emplacement';
$string['thirdpartylibs'] = 'Bibliothèques additionnelles';
$string['timezone'] = 'Fuseau horaire par défaut';
$string['timezoneforced'] = 'Ce réglage est imposé par l\'administrateur du site';
$string['timezoneisforcedto'] = 'Imposer à tous les utilisateurs l\'utilisation du fuseau horaire';
$string['timezonenotforced'] = 'Les utilisateurs peuvent choisir leur fuseau horaire';
$string['tokenizerrecommended'] = 'L\'installation de l\'extension Tokenizer de PHP est recommandée. Elle améliore les fonctionnalités du Réseau Moodle.';
$string['tools'] = 'Outils d\'administration';
$string['toolsmanage'] = 'Gérer les outils d\'administration';
$string['unattendedoperation'] = 'Opération sans surveillance';
$string['unbookmarkthispage'] = 'Retirer cette page des marque-pages';
$string['unicoderecommended'] = 'Il est recommandé de stocker toutes vos données en Unicode (UTF-8). Toute nouvelle installation de Moodle devrait être effectuée dans une base de données ayant comme jeu de caractères par défaut Unicode (UTF-8). Si vous effectuez une mise à jour de Moodle, veuillez procéder à la migration de votre base de données en Unicode (voir la page d\'administration).';
$string['unicoderequired'] = 'Le stockage des données en format Unicode (UTF-8) est requis.  Toute nouvelle installation de Moodle doit être effectuée dans une base de données ayant comme jeu de caractères par défaut Unicode (UTF-8). Si vous effectuez une mise à jour de Moodle, veuillez procéder à la migration de votre base de données en Unicode (voir la page d\'administration).';
$string['uninstallplugin'] = 'Désinstaller';
$string['unlockaccount'] = 'Débloquer ce compte';
$string['unsettheme'] = 'Ne pas définir de thème';
$string['unsupported'] = 'Non supporté';
$string['unsuspenduser'] = 'Activez le compte utilisateur';
$string['updateaccounts'] = 'Modifier des comptes existants';
$string['updateautocheck'] = 'Chercher automatiquement les mises à jour disponibles';
$string['updateautocheck_desc'] = 'Si ce réglage est activé, votre site cherchera automatiquement si des mises à jour sont disponibles pour votre site Moodle et pour tous les plugins additionnels. Si une mise à jour est disponible, une notification sera envoyée aux administrateurs du site.';
$string['updateautodeploy'] = 'Activer le déploiement des mises à jour';
$string['updateautodeploy_desc'] = 'Si ce réglage est activé, vous pourrez télécharger et installer les mises à jour disponibles à partir des pages d\'administration de Moodle. Pour que ceci fonctionne, votre serveur web doit avoir accès en écriture aux dossiers dans lesquels est installé votre Moodle. Cela peut être considéré comme une faille de sécurité potentielle.';
$string['updateavailable'] = 'Une nouvelle version de Moodle est disponible !';
$string['updateavailabledetailslink'] = 'Voir {$a->url} pour plus d\'informations';
$string['updateavailableforplugin'] = 'Une nouvelle version de certains de vos plugins est disponible !';
$string['updateavailableinstall'] = 'Installer cette mise à jour';
$string['updateavailable_moreinfo'] = 'Plus d\'info...';
$string['updateavailablenot'] = 'Votre Moodle est à jour !';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Version {$a}';
$string['updatecomponent'] = 'Mettre à jour le composant';
$string['updateminmaturity'] = 'Maturité de code requise';
$string['updateminmaturity_desc'] = 'Ne notifier les mises à jour disponibles que si la nouvelle version a au moins le niveau de maturité sélectionné. Les nouvelles versions des plugins qui ne déclarent pas leur niveau de maturité seront annoncées quel que soit ce réglage.';
$string['updatenotificationfooter'] = 'Votre site Moodle {$a->siteurl} est configuré pour vérifier automatiquement si des mises à jours sont disponibles. Vous recevez ce message en tant qu\'administrateur du site. Vous pouvez désactiver ces vérifications automatiques dans l\'administration du site, sous la rubrique Serveur. Vous pouvez également personnaliser la façon dont le message vous est adressé (messagerie personnelle) dans les réglages de votre profil.';
$string['updatenotifications'] = 'Notifications de mises à jour';
$string['updatenotificationsubject'] = 'Des mises à jour de Moodle sont disponibles ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Notifier les nouvelles microversions';
$string['updatenotifybuilds_desc'] = 'Si ce réglage est activé, les mises à jour du code de Moodle sont aussi notifiées lorsqu\'une nouvelle microversion est disponible. Les microversions sont des améliorations continues apportées à une version de Moodle. Elles sont en principe publiées chaque semaine. Si le réglage est désactivé, les mises à jour disponibles seront notifiées seulement lorsqu\'une nouvelle version est publiée. La vérification des plugins n\'est pas affectée par ce réglage.';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 comporte un certain nombre de correctifs de sécurité pour les mots de passe et le processus de sauvegarde et restauration, afin de protéger les informations des utilisateurs sur votre site. En conséquence, certains de vos réglages et droits d\'accès en lien avec les sauvegardes peuvent avoir été modifiés.<br />Veuillez consulter les <a href="http://docs.moodle.org/fr/Notes_de_mise_%C3%A0_jour_de_Moodle_1.9.7" target="_blank">Notes de mise à jour à Moodle 1.9.7</a> pour plus de détails.</p>';
$string['upgrade197noticesubject'] = 'Notes de sécurité liées à la mise à jour à Moodle 1.9.7';
$string['upgrade197salt'] = 'Afin de réduire de façon importante le risque de vol de mot de passe, il vous est fortement recommandé de définir un sel de mot de passe.<br />Veuillez consulter la <a href="{$a}" target="_blank">documentation sur le sel de mot de passe</a> pour plus d\'informations à ce sujet.';
$string['upgradeerror'] = 'Erreur lors de la mise à jour de {$a->plugin} à la version {$a->version}. Impossible de continuer.';
$string['upgradeforumread'] = 'Moodle 1.5 possède une nouvelle fonctionnalité permettant de signaler quels messages des forums ont été lus.<br />Pour profiter de cette fonctionnalité, les tables de la base de données <a href="{$a}">doivent être mises à jour</a>.';
$string['upgradeforumreadinfo'] = 'Moodle 1.5 possède une nouvelle fonctionnalité permettant de signaler quels messages des forums ont été lus. Pour profiter de cette fonctionnalité, les tables de la base de données doivent être complétées avec le statut de lecture pour les messages existants. Suivant la taille de votre site, cette mise à jour peut prendre beaucoup de temps (quelques heures) et risque de surcharger la base de données. Nous vous conseillons donc de l\'effectuer lors d\'une période creuse. Durant cette mise à jour, votre site continuera à fonctionner et les utilisateurs n\'en seront pas affectés. Une fois l\'opération démarrée, vous devez la laisser se terminer (en laissant ouverte la fenêtre du navigateur). Si par inadvertance vous interrompez le processus, par exemple en fermant la fenêtre, vous pourrez le recommencer sans dommage.<br /><br />Voulez-vous commencer maintenant cette opération ?';
$string['upgradelogs'] = 'Pour profiter de toutes les fonctionnalités, les historiques (logs) doivent être mis à jour. <a href="{$a}">Plus d\'informations</a>';
$string['upgradelogsinfo'] = 'Récemment, des changements ont eu lieu dans la façon de conserver les historiques. Afin de pouvoir profiter de l\'affichage des anciens historiques par activité, ceux-ci doivent être mis à jour. Selon la taille de votre site, cette opération peut durer assez longtemps (c\'est-à-dire plusieurs heures) et peut ralentir les bases de données des sites complexes et très actifs. Une fois l\'opération démarrée, vous devez la laisser se terminer (en laissant ouverte la fenêtre du navigateur). N\'ayez crainte, votre site continuera à très bien fonctionner pour les autres utilisateurs durant la mise à jour des historiques.<br /><br />Voulez-vous mettre à jour maintenant vos historique ?';
$string['upgradepluginsfirst'] = 'Il est recommandé d\'installer avant tout toutes les mises à jour disponibles';
$string['upgradepluginsinfo'] = 'Mise à jour des plugins';
$string['upgradepluginsinfo_help'] = 'Des mises à jour sont disponibles pour certains de vos plugins. Veuillez les installer avant d\'effectuer la mise à jour de la base de données de Moodle. Si votre site ne permet pas le déploiement automatique des mises à jour, veuillez télécharger et installer manuellement sur votre serveur les nouvelles versions disponibles des plugins.';
$string['upgradesettings'] = 'Nouveaux réglages';
$string['upgradesettingsintro'] = 'Les réglages ci-dessous ont été ajoutés lors de la dernière mise à jour de votre Moodle. Effectuez les modifications nécessaires et cliquez ensuite sur « Enregistrer les modifications » au bas de cette page.';
$string['upgradestalefiles'] = 'Mélange de versions de Moodle détectées. La mise à jour ne peut pas être poursuivie';
$string['upgradestalefilesinfo'] = 'La mise à jour de Moodle a été interrompue, car des fichiers PHP d\'au moins deux versions majeures différentes de Moodle ont été détectés dans le dossier Moodle.

Cette situation pourrait causer ultérieurement de graves problèmes. Pour cette raison, afin de continuer la mise à jour, vous devez vous assurer que le dossier Moodle ne contient que des fichiers d\'une seule version de Moodle.

Pour nettoyer votre dossier Moodle, il est recommandé d\'agir ainsi :

* renommer votre dossier Moodle en « moodle_old »;
* créer un nouveau dossier Moodle ne contenant que les fichiers provenant soit de la distribution standard de Moodle préalablement téléchargée, soit du dépôt Git de Moodle ;
* déplacer le fichier config.php et tous les plugins non-standards du dossier « moodle_old » vers le nouveau dossier Moodle.

Une fois votre dossier Moodle nettoyé, rafraîchissez l\'affichage de cette page pour reprendre le processus de mise à jour de Moodle.

Cet avertissement s\'affiche le plus souvent suite au dé-compactage d\'une archive ZIP standard de Moodle par-dessus une version existante de Moodle. Ce procédé est valable pour les mises à jour mineures. Il est en revanche vigoureusement déconseillé pour les mises à jour majeures de Moodle.

L\'avertissement peut également être causé par la mise à jour incomplète d\'un dépôt Git. Dans ce cas, attendez la fin de la mise à jour, lancez une commande adéquate pour nettoyer le dossier et réessayez l\'opération.

Vous trouverez plus d\'informations à ce sujet dans la documentation de mise à jour ici : <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Mettre à jour la base de données maintenant';
$string['upgradesure'] = '<p>Certains fichiers de votre Moodle ont été modifiés, et vous êtes sur le point de lancer la procédure automatique de mise à jour de votre serveur vers cette version :</p>
<p><strong>{$a}</strong></p>
<p>Une fois cette mise à jour effectuée, il sera impossible de revenir en arrière ! Veuillez remarquer que le processus peut durer assez longtemps.</p>
<p>Voulez-vous vraiment mettre à jour ce Moodle vers cette version ?</p>';
$string['upgradetimedout'] = 'La mise à jour a dépassé le temps imparti. Veuillez recommencer la mise à jour.';
$string['upgradingdata'] = 'Mise à jour des données';
$string['upgradinglogs'] = 'Mise à jour des fichiers d\'historique (logs)';
$string['upgradingversion'] = 'Mise à jour vers une nouvelle version';
$string['upwards'] = 'et ultérieures';
$string['useblogassociations'] = 'Activer les associations';
$string['useexternalyui'] = 'Utiliser les bibliothèques YUI en ligne';
$string['user'] = 'Utilisateur';
$string['userbulk'] = 'Actions en lots sur les utilisateurs';
$string['userlist'] = 'Liste des utilisateurs';
$string['userpolicies'] = 'Règles utilisateurs';
$string['userpreference'] = 'Préférence utilisateur';
$string['userquota'] = 'Quota utilisateur';
$string['users'] = 'Utilisateurs';
$string['usesitenameforsitepages'] = 'Utiliser le nom du site pour les pages du site';
$string['usetags'] = 'Activer les tags';
$string['validateerror'] = 'Cette valeur n\'est pas valide :';
$string['verifychangedemail'] = 'Appliquer les restrictions de domaines lors des modifications d\'adresse de courriel';
$string['warningcurrentsetting'] = 'Valeur actuelle non valide : {$a}';
$string['warningiconvbuggy'] = 'Votre version de la bibliothèque iconv ne supporte pas le mot clef //IGNORE. Veuillez installer l\'extension mbstring qui peut être utilisée pour nettoyer les chaînes de caractères contenant des caractères UTF-8 non valides.';
$string['webproxy'] = 'Proxy web';
$string['webproxyinfo'] = 'Renseignez les options suivantes si votre serveur Moodle n\'a pas un accès direct à Internet. L\'accès direct à Internet est requis pour le téléchargement des données de l\'environnement, les paquetages de langue, les flux RSS, les fuseaux horaires, etc.<br /><em>L\'extension cURL de PHP est vivement recommandée.</em>';
$string['xmlrpcrecommended'] = 'L\'installation de l\'extension xmlrpc de PHP est requise pour l\'utilisation du Réseau Moodle.';
$string['yuicomboloading'] = 'Chargement du combo YUI';
$string['ziprequired'] = 'L\'extension Zip de PHP est maintenant requise par Moodle. Les exécutables info-ZIP et la bibliothèque PclZip ne sont plus utilisés.';
$string['zlibenabled'] = 'zlib activé';
