<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'pt', branch 'MOODLE_26_STABLE'
 *
 * @package   data
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ação';
$string['add'] = 'Adicionar registo';
$string['addcomment'] = 'Adicionar comentário';
$string['addentries'] = 'Adicionar registos';
$string['addtemplate'] = 'Adicionar registo';
$string['advancedsearch'] = 'Pesquisa avançada';
$string['allowcomments'] = 'Permitir comentários aos termos';
$string['alttext'] = 'Texto alternativo';
$string['approve'] = 'Aprovar';
$string['approved'] = 'Aprovado';
$string['areacontent'] = 'Campos';
$string['ascending'] = 'Ascendente';
$string['asearchtemplate'] = 'Pesquisa avançada';
$string['atmaxentry'] = 'Já introduziu o número máximo de registos permitido!';
$string['authorfirstname'] = 'Primeiro nome do autor';
$string['authorlastname'] = 'Apelido do autor';
$string['autogenallforms'] = 'Gerar todos os formulários predefinidos.';
$string['autolinkurl'] = 'Criar link para o URL';
$string['availablefromdate'] = 'Disponível a partir de';
$string['availabletags'] = 'Marcadores disponíveis';
$string['availabletags_help'] = 'Os marcadores são espaços reservados no modelo que serão substituídos por dados ou outros itens quando os registos forem editados ou visualizados (ex: ícone de edição, valor de um campo, etc.).

Os marcadores para os campos são definidos no formato <b>[[nomedocampo]]</b>. Todos os outros marcadores possuem o formato <b>##marcadorexemplo##</b>.

Apenas os marcadores que estão na lista <b>Marcadores disponíveis</b> podem ser usados no modelo atual.';
$string['availabletodate'] = 'Disponível até';
$string['blank'] = 'Vazio';
$string['buttons'] = 'Botões';
$string['bynameondate'] = 'por  {$a->name} - {$a->date}';
$string['cancel'] = 'Cancelar';
$string['cannotaccesspresentsother'] = 'Não tem permissão para aceder a protótipos de outros utilizadores';
$string['cannotadd'] = 'Não foi possível adicionar registos!';
$string['cannotdeletepreset'] = 'Ocorreu um erro ao apagar o protótipo!';
$string['cannotoverwritepreset'] = 'Ocorreu um erro ao criar o protótipo!';
$string['cannotunziptopreset'] = 'Não foi possível descompactar o ficheiro para a diretoria definida.';
$string['checkbox'] = 'Caixas de verificação';
$string['chooseexportfields'] = 'Escolha os campos que deseja exportar:';
$string['chooseexportformat'] = 'Escolha o formato de exportação:';
$string['chooseorupload'] = 'Selecionar ficheiro';
$string['columns'] = 'Colunas';
$string['comment'] = 'Comentar';
$string['commentdeleted'] = 'O comentário foi apagado';
$string['commentempty'] = 'O comentário estava vazio';
$string['comments'] = 'Comentários';
$string['commentsaved'] = 'O comentário foi gravado';
$string['commentsn'] = '{$a} comentário(s)';
$string['commentsoff'] = 'A opção de comentários não está ativa';
$string['configenablerssfeeds'] = 'A ativação desta configuração permite a geração de listas RSS em todas as bases de dados, ao nível do site. Para utilizar esta funcionalidade numa base de dados específica deve ainda ativar a mesma na respectiva página de configuração.';
$string['confirmdeletefield'] = 'Tem a certeza de que deseja apagar este campo?';
$string['confirmdeleterecord'] = 'Tem a certeza de que deseja apagar este registo?';
$string['confirmdeleterecords'] = 'Tem a certeza de que pretende apagar estes registos?';
$string['csstemplate'] = 'CSS';
$string['csvfailed'] = 'Não foi possível ler a informação existente no ficheiro CSV';
$string['csvfile'] = 'Ficheiro CSV';
$string['csvimport'] = 'Importação de ficheiro CSV';
$string['csvimport_help'] = 'Os registos podem ser importados através de um ficheiro de texto, indicando na primeira linha os nomes dos campos e nas linhas seguintes a respetiva informação, com um registo por linha.';
$string['csvwithselecteddelimiter'] = 'Ficheiro <acronym title="Comma Separated Values">CSV</acronym> com delimitador';
$string['data:addinstance'] = 'Adicionar nova Base de Dados';
$string['data:approve'] = 'Aprovar e cancelar registos já aprovados';
$string['data:comment'] = 'Escrever comentários';
$string['data:exportallentries'] = 'Exportar todos os registos';
$string['data:exportentry'] = 'Exportar um registo';
$string['data:exportownentry'] = 'Exportar registo do próprio';
$string['data:exportuserinfo'] = 'Exportar informação do utilizador';
$string['data:managecomments'] = 'Gerir comentários';
$string['data:manageentries'] = 'Gerir registos';
$string['data:managetemplates'] = 'Gerir modelos';
$string['data:manageuserpresets'] = 'Gerir todos os protótipos';
$string['data:rate'] = 'Avaliar registos';
$string['data:readentry'] = 'Ler registos';
$string['data:viewallratings'] = 'Ver todas as avaliações atribuídas pelos utilizadores';
$string['data:viewalluserpresets'] = 'Ver protótipos de todos os utilizadores';
$string['data:viewanyrating'] = 'Ver as avaliações totais que todos obtiveram';
$string['data:viewentry'] = 'Ver registos';
$string['data:viewrating'] = 'Ver a avaliação que recebeu';
$string['data:writeentry'] = 'Escrever registos';
$string['date'] = 'Data';
$string['dateentered'] = 'Data de criação';
$string['defaultfielddelimiter'] = '(o valor predefinido é a vírgula)';
$string['defaultfieldenclosure'] = '(não existe valor predefinido)';
$string['defaultsortfield'] = 'Campo de ordenação predefinido';
$string['delcheck'] = 'Caixa de verificação de exclusão em massa';
$string['delete'] = 'Apagar';
$string['deleteallentries'] = 'Apagar todos os registos';
$string['deletecomment'] = 'Tem a certeza de que quer apagar este comentário?';
$string['deleted'] = 'apagado(s)';
$string['deletefield'] = 'Apagar um campo existente';
$string['deletenotenrolled'] = 'Apagar registos criados por utilizadores que não estão inscritos';
$string['deletewarning'] = 'Tem a certeza de que quer apagar este protótipo?';
$string['descending'] = 'Descendente';
$string['directorynotapreset'] = '{$a->directory} Não é um protótipo: faltam os ficheiros: {$a->missing_files}';
$string['disapprove'] = 'Anular aprovação';
$string['download'] = 'Descarregar';
$string['edit'] = 'Editar';
$string['editcomment'] = 'Editar comentário';
$string['editentry'] = 'Editar registo';
$string['editordisable'] = 'Desativar editor';
$string['editorenable'] = 'Ativar editor';
$string['emptyadd'] = 'O modelo <b>Adicionar</b> está vazio, a gerar o formulário predefinido';
$string['emptyaddform'] = 'Não preencheu nenhum campo!';
$string['entries'] = 'Registos';
$string['entrieslefttoadd'] = 'Tem que adicionar mais {$a->entriesleft} registo(s) para completar esta atividade';
$string['entrieslefttoaddtoview'] = 'Tem que adicionar mais {$a->entrieslefttoview} registos para conseguir visualizar as entradas dos outros participantes.';
$string['entry'] = 'Registo';
$string['entrysaved'] = 'O seu registo foi gravado';
$string['errormustbeteacher'] = 'Apenas os professores podem usar esta página!';
$string['errorpresetexists'] = 'Já existe um protótipo com o nome indicado';
$string['example'] = 'Exemplo de módulo de <b>Base de dados</b>';
$string['excel'] = 'Ficheiro Excel';
$string['expired'] = 'A atividade terminou em <b>{$a}</b> e não se encontra disponível';
$string['export'] = 'Exportar';
$string['exportaszip'] = 'Exportar como ficheiro ZIP';
$string['exportaszip_help'] = 'A exportação para ficheiro ZIP permite o armazenamento dos modelos e campos num ficheiro zip protótipo que pode ser descarregado. Este ficheiro pode depois ser importado para outra disciplina.';
$string['exportedtozip'] = 'Exportado para ficheiro ZIP temporário...';
$string['exportentries'] = 'Exportar registos';
$string['exportownentries'] = 'Exportar apenas os seus registos? ({$a->mine} / {$a->all})';
$string['failedpresetdelete'] = 'Ocorreu um erro durante a eliminação do protótipo!';
$string['fieldadded'] = 'O campo foi adicionado';
$string['fieldallowautolink'] = 'Permitir hiperligações automáticas';
$string['fielddeleted'] = 'O campo foi apagado';
$string['fielddelimiter'] = 'Delimitador de campo';
$string['fielddescription'] = 'Descrição do campo';
$string['fieldenclosure'] = 'Limites do campo';
$string['fieldheight'] = 'Altura';
$string['fieldheightlistview'] = 'Altura no modo de lista';
$string['fieldheightsingleview'] = 'Altura no modo registo';
$string['fieldids'] = 'Identificadores de campo';
$string['fieldmappings'] = 'Mapeamentos dos campos';
$string['fieldmappings_help'] = 'Este menu permite-lhe manter os dados da base de dados existente.Para preservar os dados de um campo, este deverá ser mapeado para um novo campo. Os campos podem ser deixados em branco, caso em que não será copiada informação. Todos os campos que não sejam mapeados para novos campos serão apagados e a sua informação perdida. Apenas podem ser mapeados campos do mesmo tipo, pelo que cada menu de seleção apresentará os tipos permitidos. Não é permitido o mapeamento de um campo para mais do que um novo campo.';
$string['fieldname'] = 'Nome do campo';
$string['fieldnotmatched'] = 'Os seguintes campos presentes no ficheiro não existem nesta base de dados: {$a}';
$string['fieldoptions'] = 'Opções (uma por linha)';
$string['fields'] = 'Campos';
$string['fieldupdated'] = 'O campo foi atualizado';
$string['fieldwidth'] = 'Largura';
$string['fieldwidthlistview'] = 'Largura no modo de lista';
$string['fieldwidthsingleview'] = 'Largura no modo registo';
$string['file'] = 'Ficheiro';
$string['fileencoding'] = 'Código';
$string['filesnotgenerated'] = 'Não foi possível gerar todos os ficheiros: {$a}';
$string['filtername'] = 'Hiperligações automáticas à base de dados';
$string['footer'] = 'Rodapé';
$string['forcelinkname'] = 'Texto do link';
$string['foundnorecords'] = 'Não foram encontrados registos (<a href="{$a->reseturl}">Nova pesquisa</a>)';
$string['foundrecords'] = 'Registos encontrados: {$a->num}/{$a->max} (<a href="{$a->reseturl}">Nova pesquisa</a>)';
$string['fromfile'] = 'Importar ficheiro ZIP';
$string['fromfile_help'] = 'Esta configuração permite consultar e importar um zip protótipo de modelos e campos de base de dados.';
$string['generateerror'] = 'Não foi possível gerar todos os ficheiros!';
$string['header'] = 'Cabeçalho';
$string['headeraddtemplate'] = 'Define a aparência da página de edição de registos';
$string['headerasearchtemplate'] = 'Define a aparência da página de pesquisas avançadas';
$string['headercsstemplate'] = 'Define os estilos CSS locais a aplicar aos outros modelos';
$string['headerjstemplate'] = 'Define o código Javascript específico a aplicar aos outros formatos';
$string['headerlisttemplate'] = 'Define a aparência da página da lista de registos';
$string['headerrsstemplate'] = 'Define a aparência dos registos nas listas RSS';
$string['headersingletemplate'] = 'Define a aparência da página de registos individuais';
$string['importentries'] = 'Importar registos';
$string['importsuccess'] = 'O protótipo foi aplicado com sucesso.';
$string['includeapproval'] = 'Incluir estado de aprovação';
$string['includetime'] = 'Incluir data de criação/modificação';
$string['includeuserdetails'] = 'Incluir detalhes do utilizador';
$string['insufficiententries'] = 'são necessários mais registos para ver esta base de dados';
$string['intro'] = 'Descrição';
$string['invalidaccess'] = 'Esta página não foi acedida corretamente';
$string['invalidfieldid'] = 'O identificador do campo não está correto';
$string['invalidfieldname'] = 'Deve ser indicado outro nome para este campo';
$string['invalidfieldtype'] = 'O tipo de campo não está correto';
$string['invalidid'] = 'O identificador da informação não está correto';
$string['invalidpreset'] = '<b>{$a}</b> não é um protótipo.';
$string['invalidrecord'] = 'Registo incorreto';
$string['invalidurl'] = 'O URL que introduziu não é válido';
$string['jstemplate'] = 'Javascript';
$string['latitude'] = 'Latitude';
$string['latlong'] = 'Latitude/Longitude';
$string['latlongdownloadallhint'] = 'Link para descarregar todos os registos como KML';
$string['latlongkmllabelling'] = 'Como classificar itens em ficheiros KML (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Mapas externos a mostrar';
$string['latlongotherfields'] = 'Outros campos';
$string['list'] = 'Ver lista';
$string['listtemplate'] = 'Lista';
$string['longitude'] = 'Longitude';
$string['mapexistingfield'] = 'Mapear para {$a}';
$string['mapnewfield'] = 'Criar novo campo';
$string['mappingwarning'] = 'Todos os campos que não forem mapeados para novos campos serão apagados e a sua informação removida.';
$string['maxentries'] = 'Número máximo de entradas';
$string['maxentries_help'] = 'Número máximo de registos que um utilizador pode submeter nesta atividade.';
$string['maxsize'] = 'Tamanho máximo';
$string['menu'] = 'Menu';
$string['menuchoose'] = 'Selecione...';
$string['missingdata'] = 'Deve ser indicado um identificador de informação ou um objeto para a classe do campo';
$string['missingfield'] = 'Erro de programação: Deve especificar um campo e/ou dados na definição da classe do campo.';
$string['modulename'] = 'Base de dados';
$string['modulename_help'] = 'A atividade Base de dados permite aos participantes criar, gerir e procurar informação numa base de dados. O formato e estrutura dos registos da base de dados pode ser quase ilimitado, podendo incluir imagens, ficheiros, URL, números, texto, etc.

A aparência dos ecrãs de visualização, criação e edição da base de dados pode ser definidas através de modelos. As base de dados podem ser partilhadas entre disciplinas e um professor também pode importar e exportar registos da base de dados.

Se a opção de hiperligação dos registos estiver ativa, é possível criar automaticamente links entre os termos inseridos e essas palavras, sempre que aparecerem noutros locais da disciplina.

Um professor pode permitir comentários aos registos. Estes também podem ser avaliados por professores ou alunos (avaliação pelos pares). As avaliações são ajustadas a uma única nota final que é registada no relatório de avaliação.

A base de dados pode ser usada para:

* Criar um repositório colaborativo de links/ livros/ referências a jornais;
* Para exibir trabalhos realizados pelos alunos (como fotos, cartazes, sites, poemas, etc.) e disponibilizá-los para que os colegas possam comentar.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Bases de dados';
$string['more'] = 'Mais';
$string['moreurl'] = 'Mais URL';
$string['movezipfailed'] = 'Não é possível mover o ficheiro ZIP';
$string['multientry'] = 'Registo repetido';
$string['multimenu'] = 'Menu (seleção múltipla)';
$string['multipletags'] = 'Foram encontrados múltiplos marcadores! O modelo não foi guardado';
$string['namecheckbox'] = 'Campo caixa de verificação';
$string['namedate'] = 'Campo data';
$string['namefile'] = 'Campo ficheiro';
$string['namelatlong'] = 'Campo latitude/longitude';
$string['namemenu'] = 'Campo menu';
$string['namemultimenu'] = 'Campo menu de seleção múltipla';
$string['namenumber'] = 'Campo numérico';
$string['namepicture'] = 'Campo imagem';
$string['nameradiobutton'] = 'Campo botões de rádio';
$string['nametext'] = 'Campo texto';
$string['nametextarea'] = 'Campo área de texto';
$string['nameurl'] = 'Campo URL';
$string['newentry'] = 'Novo registo';
$string['newfield'] = 'Criar novo campo';
$string['newfield_help'] = 'Um campo permite a inserção de um determinado tipo de informação nos registos de dados. Cada registo da base de dados pode ter diversos campos, de vários tipos. Ex: Um campo <b>Data</b> permite aos participantes escolher um dia, mês e ano a partir de uma lista; um campo <b>Imagem</b> permite aos participantes enviar um ficheiro de imagem; um campo <b>Menu (seleção múltipla)</b> permite aos participantes selecionar uma ou mais opções.

Cada campo deve ter um nome único na estrutura do registo. A descrição do campo é opcional.';
$string['noaccess'] = 'Não tem permissão para aceder a esta página';
$string['nodefinedfields'] = 'Não existem campos definidos no novo protótipo!';
$string['nofieldcontent'] = 'O conteúdo do campo não foi encontrado';
$string['nofieldindatabase'] = 'Não existem campos definidos para esta base de dados';
$string['nolisttemplate'] = 'O modelo de lista ainda não foi definido';
$string['nomatch'] = 'Não foram encontrados registos correspondentes!';
$string['nomaximum'] = 'Não existe máximo';
$string['norecords'] = 'Não existem registos na base de dados';
$string['nosingletemplate'] = 'O modelo <b>Registo</b> ainda não foi definido';
$string['notapproved'] = 'O registo ainda não foi aprovado.';
$string['notinjectivemap'] = 'Não é um mapa injetivo';
$string['notopenyet'] = 'A atividade apenas será disponibilizada em <b>{$a}</b>';
$string['number'] = 'Número';
$string['numberrssarticles'] = 'Entradas na Listagem de RSS';
$string['numnotapproved'] = 'Pendente(s)';
$string['numrecords'] = '<b>{$a}</b> registos';
$string['ods'] = 'Ficheiro <acronym title="OpenDocument Spreadsheet">ODS</acronym> (OpenOffice)';
$string['optionaldescription'] = 'Descrição resumida (opcional)';
$string['optionalfilename'] = 'Nome do ficheiro (opcional)';
$string['other'] = 'Outro';
$string['overrwritedesc'] = 'Se ativar esta opção este protótipo substituirá o existente (se existir).';
$string['overwrite'] = 'Substituir';
$string['overwritesettings'] = 'Substituir configurações atuais';
$string['page-mod-data-x'] = 'Qualquer página da Base de Dados';
$string['pagesize'] = 'Registos por página';
$string['participants'] = 'Utilizadores';
$string['picture'] = 'Imagem';
$string['pleaseaddsome'] = 'Crie campos abaixo ou <a href="{$a}">escolha um protótipo</a> para definir a estrutura da base de dados.';
$string['pluginadministration'] = 'Administração da base de dados';
$string['pluginname'] = 'Base de dados';
$string['portfolionotfile'] = 'Exportar para portefólio em vez de ficheiro (apenas CSV e Leap2a)';
$string['presetinfo'] = 'A gravação como protótipo permite a outros utilizadores usar o mesmo nas suas bases de dados.';
$string['presets'] = 'Protótipos';
$string['radiobutton'] = 'Botões de rádio';
$string['recordapproved'] = 'Registo aprovado';
$string['recorddeleted'] = 'Registo apagado';
$string['recorddisapproved'] = 'Entrada não aprovada';
$string['recordsnotsaved'] = 'Não foram gravados registos. Verifique o formato do ficheiro enviado.';
$string['recordssaved'] = 'os registos foram gravados';
$string['requireapproval'] = 'Requer aprovação';
$string['requireapproval_help'] = 'Se ativar esta opção os registos necessitam de aprovação do professor antes de ficarem visíveis para todos os utilizadores.';
$string['requiredentries'] = 'Registos requeridos para conclusão';
$string['requiredentries_help'] = 'Número de registos que o aluno tem que submeter antes que a atividade seja considerada completa.';
$string['requiredentriestoview'] = 'Registos requeridos antes de ser permitida a visualização';
$string['requiredentriestoview_help'] = 'Número de registos que o aluno tem que submeter antes de poder ver os registos dos outros participantes.

Nota: Se for necessário submeter registos antes de poder ver a base de dados, o filtro <b>links automáticos à base de dados</b> tem que ser desativado pois este filtro não consegue determinar se um utilizador já submeteu o número de registos requerido.';
$string['resetsettings'] = 'Reiniciar filtros';
$string['resettemplate'] = 'Reiniciar modelo';
$string['resizingimages'] = 'A redimensionar imagens...';
$string['rows'] = 'linhas';
$string['rssglobaldisabled'] = 'Desativado. Consulte as variáveis de configuração do site.';
$string['rsstemplate'] = 'Modelo para Listas RSS';
$string['rsstitletemplate'] = 'Listas RSS';
$string['save'] = 'Gravar';
$string['saveandadd'] = 'Gravar e adicionar outro';
$string['saveandview'] = 'Gravar e visualizar';
$string['saveaspreset'] = 'Gravar como protótipo';
$string['saveaspreset_help'] = 'Gravar como protótipo permite gravar os modelos existentes e os campos da base de dados como um protótipo que os outros utilizadores podem usar. Poderá apagar o protótipo da lista de protótipos em qualquer momento.';
$string['savesettings'] = 'Gravar configurações';
$string['savesuccess'] = 'Gravado com sucesso. Este protótipo será disponibilizado em todo o site.';
$string['savetemplate'] = 'Gravar modelo';
$string['search'] = 'Pesquisar';
$string['selectedrequired'] = 'Todos os selecionados são obrigatórios';
$string['showall'] = 'Mostrar todos os registos';
$string['single'] = 'Ver registo';
$string['singletemplate'] = 'Registo';
$string['subplugintype_datafield'] = 'Tipo de campo da Base de Dados';
$string['subplugintype_datafield_plural'] = 'Tipos de campos da Base de Dados';
$string['subplugintype_datapreset'] = 'Protótipo';
$string['subplugintype_datapreset_plural'] = 'Protótipos';
$string['teachersandstudents'] = '{$a->teachers} e {$a->students}';
$string['templates'] = 'Modelos';
$string['templatesaved'] = 'O modelo foi gravado';
$string['text'] = 'Texto';
$string['textarea'] = 'Área de texto';
$string['timeadded'] = 'Data de criação';
$string['timemodified'] = 'Data da última edição';
$string['todatabase'] = 'para esta base de dados.';
$string['type'] = 'Tipo de campo';
$string['undefinedprocessactionmethod'] = 'Não foi definido nenhum método de ação em Data_Preset para executar a ação "{$a}".';
$string['unsupportedexport'] = 'O tipo de campo <b>{$a->fieldtype}</b> não pode ser exportado.';
$string['updatefield'] = 'Atualizar um campo existente';
$string['uploadfile'] = 'Enviar ficheiro';
$string['uploadrecords'] = 'Importar registos a partir de ficheiro';
$string['uploadrecords_help'] = 'Os registos podem ser inseridos através de um ficheiro de texto. O formato do ficheiro deve respeitar as seguintes regras:

* Cada linha do ficheiro corresponde a um registo
* Cada registo tem um conjunto de valores para os diferentes campos, separados por vírgulas (ou outros caracteres)
* A primeira linha do ficheiro contém os nomes dos campos, definindo a ordem pela qual os mesmos são apresentados em todo o ficheiro

O delimitador dos valores dos campos é um carácter que marca o início e fim do valor de cada campo. Em geral pode deixar indefinido.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Incluir na pesquisa.';
$string['usestandard'] = 'Usar um protótipo';
$string['usestandard_help'] = 'Para criar a base de dados a partir de protótipo, selecione um da lista. (Se adicionou um protótipo através da função <b>Gravar como protótipo</b> pode remover o mesmo em qualquer momento).';
$string['viewfromdate'] = 'Visível a partir de';
$string['viewtodate'] = 'Visível até';
$string['wrongdataid'] = 'O identificador dos dados fornecido é inválido';
