<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'de', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Es gibt neue Forumsbeiträge';
$string['addanewdiscussion'] = 'Neues Thema hinzufügen';
$string['addanewquestion'] = 'Neue Frage hinzufügen';
$string['addanewtopic'] = 'Neues Thema hinzufügen';
$string['advancedsearch'] = 'Erweiterte Suche';
$string['allforums'] = 'Alle Foren';
$string['allowdiscussions'] = 'Darf \'{$a}\' in diesem Forum schreiben?';
$string['allowsallsubscribe'] = 'Alle dürfen im Forum über ihr Abonnement entscheiden';
$string['allowsdiscussions'] = 'Alle dürfen im Forum ein neues Thema beginnen';
$string['allsubscribe'] = 'Alle Foren abonnieren';
$string['allunsubscribe'] = 'Alle Foren abbestellen';
$string['alreadyfirstpost'] = 'Dies ist der erste Beitrag zu diesem Thema';
$string['anyfile'] = 'Jede Datei';
$string['areaattachment'] = 'Anhänge';
$string['areapost'] = 'Nachrichten';
$string['attachment'] = 'Anhang';
$string['attachment_help'] = 'Sie dürfen eine oder mehrere Dateien an einen Beitrag anhängen. Ein angehängtes Bild wird am Ende des Beitrags angezeigt.';
$string['attachmentnopost'] = 'Ohne Nachrichten-ID können Anhänge nicht exportiert werden';
$string['attachments'] = 'Anhänge';
$string['attachmentswordcount'] = 'Anhänge und Wortzahl';
$string['blockafter'] = 'Sperre';
$string['blockafter_help'] = 'Diese Zahl legt fest, wie viele Beiträge pro Nutzer/in im angegebenen Zeitfenster maximal ins Forum eingetragen werden dürfen. Nutzer/innen mit der Berechtigung mod/forum:postwithoutthrottling sind von einer Sperre ausgenommen.';
$string['blockperiod'] = 'Zeitfenster';
$string['blockperioddisabled'] = 'Nicht sperren';
$string['blockperiod_help'] = 'In diesem Zeitfenster dürfen maximal so viele Beiträge pro Nutzer/in ins Forum eingetragen werden, wie mit der Zahl \'Sperre\' festgelegt sind. Nutzer/innen mit der Berechtigung mod/forum:postwithoutthrottling sind von einer Sperre ausgenommen.';
$string['blogforum'] = 'Standardforum in blog-ähnlicher Anzeige';
$string['bynameondate'] = 'von {$a->name} - {$a->date}';
$string['cannotadd'] = 'Der Beitrag konnte nicht zum Forum hingefügt werden';
$string['cannotadddiscussion'] = 'Nur Gruppenmitglieder dürfen Beiträge zum Forum hinzufügen.';
$string['cannotadddiscussionall'] = 'Sie dürfen kein neues Diskussionsthema für alle Teilnehmer/innen hinzufügen.';
$string['cannotaddsubscriber'] = 'Die ID {$a} konnte nicht zur Abonnentenliste hinzugefügt werden!';
$string['cannotaddteacherforumto'] = 'Das konvertierte Trainerforum konnte nicht im Kursabschnitt 0 eingefügt werden.';
$string['cannotcreatediscussion'] = 'Das neue Thema wurde leider nicht gespeichert.';
$string['cannotcreateinstanceforteacher'] = 'Das neue Kursmodul für das Trainerforum konnte nicht erstellt werden.';
$string['cannotdeletepost'] = 'Sie dürfen diesen Beitrag nicht löschen!';
$string['cannoteditposts'] = 'Sie dürfen keine Beiträge anderer Nutzer/innen ändern!';
$string['cannotfinddiscussion'] = 'Das Thema konnte im Forum nicht gefunden werden';
$string['cannotfindfirstpost'] = 'Der erste Beitrag konnte im Forum nicht gefunden werden';
$string['cannotfindorcreateforum'] = 'Das Nachrichtenforum wurde nicht gefunden oder konnte nicht angelegt werden';
$string['cannotfindparentpost'] = 'Der erste Beitrag in diesem Thema {$a} konnte nicht gefunden werden';
$string['cannotmovefromsingleforum'] = 'Das Thema kann nicht aus einem Einzeldiskussionsforum verschoben werden';
$string['cannotmovenotvisible'] = 'Forum unsichtbar';
$string['cannotmovetonotexist'] = 'Sie können nicht in dieses Forum wechseln - es existiert nicht!';
$string['cannotmovetonotfound'] = 'Das Zielforum wurde nicht im Kurs gefunden.';
$string['cannotmovetosingleforum'] = 'Das Thema kann nicht ein Einzeldiskussionsforum verschoben werden';
$string['cannotpurgecachedrss'] = 'Die zwischengespeicherten RSS-Feeds für die Quell- und/oder Ziel-Foren können nicht beseitigt werden - überprüfen Sie Ihre Forenberechtigungen.';
$string['cannotremovesubscriber'] = 'Die ID {$a} konnte nicht aus der Abonnentenliste entfernt werden!';
$string['cannotreply'] = 'Sie dürfen nicht auf diesen Beitrag antworten.';
$string['cannotsplit'] = 'Diskussionsthemen können in diesem Forum nicht geteilt werden';
$string['cannotsubscribe'] = 'Für ein Abonnement müssen Sie Gruppenmitglied sein';
$string['cannottrack'] = 'Das Tracking des Forums konnte nicht beendet werden';
$string['cannotunsubscribe'] = 'Sie konnten nicht aus dem Forum abgemeldet werden';
$string['cannotupdatepost'] = 'Sie können den Beitrag nicht aktualisieren.';
$string['cannotviewpostyet'] = 'Sie können die Beiträge anderer Personen erst lesen, wenn Sie selber einen Beitrag geschrieben haben.';
$string['cannotviewusersposts'] = 'Von dieser Person gibt es keine Beiträge, die Sie sehen könnten.';
$string['cleanreadtime'] = '\'Gelesen\' zu diesen Zeitpunkt markieren';
$string['completiondiscussions'] = 'Teilnehmer/in muss ein Thema neu beginnen:';
$string['completiondiscussionsgroup'] = 'Themen erforderlich';
$string['completiondiscussionshelp'] = 'Zum Beenden sind Themen erforderlich';
$string['completionposts'] = 'Teilnehmer/in muss ein Thema neu beginnen oder Antworten verfassen:';
$string['completionpostsgroup'] = 'Forumsbeiträge erforderlich';
$string['completionpostshelp'] = 'Zum Beenden sind Themen oder Antworten erforderlich';
$string['completionreplies'] = 'Teilnehmer/in muss Antworten verfassen:';
$string['completionrepliesgroup'] = 'Antworten erforderlich';
$string['completionreplieshelp'] = 'Zum Beenden sind Antworten erforderlich';
$string['configcleanreadtime'] = 'Ältere Beiträge werden täglich zu dieser Zeit (Stunde) als \'gelesen\' markiert.';
$string['configdigestmailtime'] = 'Diese Option legt fest, wann die tägliche Zusammenfassung neuer Forumsbeiträge (Digest) erstellt und versendet wird.';
$string['configdisplaymode'] = 'Standardanzeige für Themen, falls nichts eingestellt wurde.';
$string['configenablerssfeeds'] = 'Diese Option aktiviert die Einstellmöglichkeit von RSS Feeds für alle Foren. Jedes Forum muss einzeln für RSS Feeds freigegeben werden.';
$string['configenabletimedposts'] = 'Wenn diese Option aktiviert ist, dann lässt sich ein Zeitraum für Sichtbarkeit eines Forumsbeitrags festzulegen (experimentell und noch nicht umfassend getestet).';
$string['configlongpost'] = 'Jeder Beitrag wird als lang eingestuft, wenn er länger als diese Zeichenzahl ist (ohne Berücksichtigung der HTML-Codierung).';
$string['configmanydiscussions'] = 'Anzahl von Themen pro Seite';
$string['configmaxattachments'] = 'Voreinstellung für die Anzahl von Anhängen, die pro Beitrag in einem Forum erlaubt sind';
$string['configmaxbytes'] = 'Voreinstellung für die Dateigröße von Anhängen in Foren auf dieser Website (je nach Kurs oder durch andere lokale Einstellungen weiter eingeschränkt)';
$string['configoldpostdays'] = 'Anzahl der Tage, nach denen eine neue Nachricht automatisch als gelesen gilt.';
$string['configreplytouser'] = 'Wenn ein Forumsbeitrag per E-Mail verschickt wird, soll er die Teilnehmeradresse enthalten, damit der Empfänger persönlich antworten kann (statt über das Forum)? Wenn Sie "Ja" auswählen, können die Teilnehmer/innen in ihrem Profil festlegen, ob die E-Mail-Adresse veröffentlicht werden soll oder nicht.';
$string['configshortpost'] = 'Jeder Beitrag wird als kurz eingestuft, wenn er kürzer als diese Zeichenzahl ist (ohne Berücksichtigung der HTML-Codierung).';
$string['configtrackingtype'] = 'Standardeinstellung zum Lesetracking';
$string['configtrackreadposts'] = 'Wenn diese Option aktiviert ist, steht die Markierung gelesen/ungelesen für alle zur Verfügung.';
$string['configusermarksread'] = 'Wenn diese Option aktiviert ist, müssen neue Nachrichten manuell als gelesen markiert werden. Andernfalls gilt eine Nachricht automatisch als gelesen, sobald sie einmal aufgerufen wurde.';
$string['confirmsubscribe'] = 'Möchten Sie wirklich das Forum \'{$a}\' abonnieren?';
$string['confirmunsubscribe'] = 'Möchten Sie wirklich das Forum \'{$a}\' abbestellen?';
$string['couldnotadd'] = 'Der Beitrag wurde wegen eines Fehlers nicht hinzugefügt.';
$string['couldnotdeletereplies'] = 'Der Beitrag darf nicht gelöscht werden, weil es dazu bereits Antworten gibt.';
$string['couldnotupdate'] = 'Der Beitrag wurde wegen eines Fehlers nicht aktualisiert.';
$string['delete'] = 'Löschen';
$string['deleteddiscussion'] = 'Das Thema wurde gelöscht.';
$string['deletedpost'] = 'Der Beitrag wurde gelöscht.';
$string['deletedposts'] = 'Diese Beiträge wurden gelöscht.';
$string['deletesure'] = 'Möchten Sie diesen Beitrag wirklich löschen?';
$string['deletesureplural'] = 'Möchten Sie diesen Beitrag und alle Antworten wirklich löschen? ({$a} Beiträge)';
$string['digestmailheader'] = 'Sie erhalten die tägliche Zusammenfassung neuer Forumsbeiträge (Digest) von {$a->sitename}. Die Einstellungen zu den E-Mails aus Foren können Sie über {$a->userprefs} ändern.';
$string['digestmailpost'] = 'Einstellungen zur Zusammenfassung (Digest) neuer Forenbeiträge ändern';
$string['digestmailprefs'] = 'Ihr Profil';
$string['digestmailsubject'] = '{$a}: Zusammenfassung des Forums';
$string['digestmailtime'] = 'Termin für Foren- Zusammenfassungen';
$string['digestsentusers'] = 'Die E-Mail-Zusammenfassung wurde erfolgreich an {$a} Teilnehmer/innen versandt.';
$string['disallowsubscribe'] = 'Das Forum kann nicht abonniert werden';
$string['disallowsubscribeteacher'] = 'Das Forum kann nicht abonniert werden (nur Trainer/innen)';
$string['discussion'] = 'Thema';
$string['discussionmoved'] = 'Dieses Thema wurde verschoben nach \'{$a}\'.';
$string['discussionmovedpost'] = 'Dieses Thema wurde verschoben nach <a href="{$a->discusshref}">hier</a> ins Forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Thema';
$string['discussions'] = 'Themen';
$string['discussionsstartedby'] = 'Themen begonnen von {$a}';
$string['discussionsstartedbyrecent'] = 'Themen kürzlich begonnen von {$a}';
$string['discussionsstartedbyuserincourse'] = 'Themen begonnen von {$a->fullname} in {$a->coursename}';
$string['discussthistopic'] = 'Thema diskutieren';
$string['displayend'] = 'Anzeigeende';
$string['displayend_help'] = 'Die Einstellung legt fest, ob ein Forumsbeitrag nach einem bestimmten Datum verborgen werden soll. Beachten Sie, dass Admins die Beiträge immer sehen dürfen.';
$string['displaymode'] = 'Anzeigemodus';
$string['displayperiod'] = 'Anzeigeperiode';
$string['displaystart'] = 'Anzeigebeginn';
$string['displaystart_help'] = 'Die Option legt fest, ob ein Forumsbeitrag erst ab einem bestimmten Datum angezeigt werden soll. Administrator/innen dürfen immer alle Beiträge sehen.';
$string['displaywordcount'] = 'Wortzahl anzeigen';
$string['displaywordcount_help'] = 'Die Einstellung legt fest, ob die Zahl der Worte für jeden Forenbeitrag angezeigt werden soll.';
$string['eachuserforum'] = 'Jede Person darf genau ein Thema anlegen';
$string['edit'] = 'Bearbeiten';
$string['editedby'] = 'Bearbeitet von {$a->name} - Originaleintrag am {$a->date}';
$string['editedpostupdated'] = 'Beitrag von {$a} wurde aktualisiert';
$string['editing'] = 'Wird bearbeitet';
$string['emaildigest_0'] = 'Sie erhalten zu jedem Foreneintrag eine E-Mail';
$string['emaildigest_1'] = 'Sie werden eine tägliche E-Mail-Zusammenfassung gesendet bekommen, die den vollständigen Inhalt aller Forumsbeiträge enthält.';
$string['emaildigest_2'] = 'Sie werden eine tägliche E-Mail-Zusammenfassung gesendet bekommen, die das Thema aller Forumsbeiträge enthält.';
$string['emaildigestcompleteshort'] = 'Vollständige Beiträge';
$string['emaildigestdefault'] = 'Standardmäßig ({$a})';
$string['emaildigestoffshort'] = 'Keine Zusammenfassung';
$string['emaildigestsubjectsshort'] = 'Nur die Themen';
$string['emaildigesttype'] = 'Optionen für die E-Mail-Zusammenfassung';
$string['emaildigesttype_help'] = 'Folgende Einstellungen stehen für die Benachrichtigung aus Foren zur Verfügung:

* Standard - Es wird die Einstellung im individuellen Nutzerprofil verwandt. Eine Änderung im eigenen Profil wird auch hier angezeigt.
* Keine Zusammenfassung - Sie erhalten für jeden Forenbeitrag eine E-Mail.
- Zusammenfassung - vollständige Beiträge - Sie erhalten täglich eine E-Mail. Diese enthält alle Beiträge der Foren mit ihrem gesamten Inahalt.
- Zusammenfassung - nur Überschriften - Sie erhalten tägliche eine E-Mail. Diese enthält nur die Themenüberschriften der Forenbeiträge.';
$string['emaildigestupdated'] = 'Die E-Mail Option für Zusammenfassungen wurde geändert zu \'{$a->maildigesttitle}\' für das Forum \'{$a->forum}\'. {$a->maildigestdescription}';
$string['emaildigestupdated_default'] = 'Ihr Standard Profilwert von \'{$a->maildigesttitle}\' wird für das Forum \'{$a->forum}\' verwendet. {$a->maildigestdescription}';
$string['emptymessage'] = 'Bei Ihrem Beitrag ist ein Fehler aufgetreten. Eventuell haben Sie keinen Text eingegeben oder der Anhang war zu groß. Die Änderungen wurden nicht gespeichert.';
$string['erroremptymessage'] = 'Die Mitteilung darf nicht leer sein.';
$string['erroremptysubject'] = 'Der Betreff darf nicht leer sein.';
$string['errorenrolmentrequired'] = 'Sie müssen in den Kurs eingeschrieben sein, um auf diesen Inhalt zugreifen zu können';
$string['errorwhiledelete'] = 'Beim Löschen des Beitrags ist ein Fehler aufgetreten.';
$string['event_assessable_uploaded'] = 'Inhalte wurden bereitgestellt';
$string['everyonecanchoose'] = 'Alle dürfen entscheiden, ob sie das Forum abonnieren';
$string['everyonecannowchoose'] = 'Alle dürfen jetzt entscheiden, ob sie das Forum abonnieren';
$string['everyoneisnowsubscribed'] = 'Alle haben jetzt dieses Forum abonniert';
$string['everyoneissubscribed'] = 'Alle haben dieses Forum abonniert';
$string['existingsubscribers'] = 'Derzeitige Abonnenten';
$string['exportdiscussion'] = 'Gesamte Diskussion exportieren';
$string['forcedreadtracking'] = 'Vorgabe des Lesetrackings erlauben';
$string['forcedreadtracking_desc'] = 'Diese Option ermöglicht es in Foren, das Lesetracking für alle Nutzer/innen zu erzwingen. In Kursen mit vielen Foren und Beiträgen könnte sich die Ladezeit der Seite deutlich erhöhen. Wenn diese Option deaktiviert wird, wird ein vorher erzwungenes Lesetracking zu einer optionalen Einstellung.';
$string['forcessubscribe'] = 'Dieses Forum muss von allen abonniert werden';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Forum hinzufügen';
$string['forum:addnews'] = 'Nachrichten hinzufügen';
$string['forum:addquestion'] = 'Frage hinzufügen';
$string['forum:allowforcesubscribe'] = 'Einschreibung erzwingen zulassen';
$string['forumauthorhidden'] = 'Autor/in (verborgen)';
$string['forumblockingalmosttoomanyposts'] = 'Sie erreichen bald die Höchstzahl der zulässigen Beiträge. Sie haben {$a->numposts} Beiträge im Zeitraum {$a->blockperiod} veröffentlicht. Die Grenze ist bei {$a->blockafter} Beiträgen erreicht.';
$string['forumbodyhidden'] = 'Sie können diesen Beitrag nicht ansehen. Entweder haben Sie selbst in dieser Diskussion noch nichts geschrieben oder die Bearbeitungszeit für den Beitrag läuft noch. Eventuell ist die Diskussion auch noch nicht begonnen oder bereits vorbei.';
$string['forum:createattachment'] = 'Anhänge hinzufügen';
$string['forum:deleteanypost'] = 'Alle Beiträge löschen (jederzeit)';
$string['forum:deleteownpost'] = 'Eigene Beiträge löschen (mit Zeitbegrenzung)';
$string['forum:editanypost'] = 'Alle Beiträge bearbeiten';
$string['forum:exportdiscussion'] = 'Gesamtes Thema exportieren';
$string['forum:exportownpost'] = 'Eigenen Beitrag exportieren';
$string['forum:exportpost'] = 'Beitrag exportieren';
$string['forumintro'] = 'Beschreibung';
$string['forum:managesubscriptions'] = 'Abonnent/innen verwalten';
$string['forum:movediscussions'] = 'Themen verschieben';
$string['forumname'] = 'Forumsname';
$string['forumposts'] = 'Forumsbeiträge';
$string['forum:postwithoutthrottling'] = 'Keine Sperre bei zu vielen Beiträgen';
$string['forum:rate'] = 'Beiträge bewerten';
$string['forum:replynews'] = 'Auf Nachrichten antworten';
$string['forum:replypost'] = 'Auf Beiträge antworten';
$string['forums'] = 'Foren';
$string['forum:splitdiscussions'] = 'Themen aufteilen';
$string['forum:startdiscussion'] = 'Neue Themen beginnen';
$string['forumsubjecthidden'] = 'Betreff (verborgen)';
$string['forumtracked'] = 'Ungelesene Beiträge werden verfolgt';
$string['forumtrackednot'] = 'Ungelesene Beiträge werden nicht verfolgt';
$string['forumtype'] = 'Forumstyp';
$string['forumtype_help'] = 'Es gibt fünf verschiedene Forentypen:

* Diskussion zu einem Thema - Forum zu einem einzigen Thema, zu dem alle antworten dürfen. Dieser Typ funktioniert nicht mit separaten Gruppen.
* Jede Person darf genau ein Thema anlegen - Forum, in dem jede Person genau ein Thema beginnen darf. Alle Personen dürfen dann zu allen Themen antworten.
* Frage-Antwort-Forum - Forum, bei dem alle Personen zuerst einem eigenen Beitrag schreiben müssen, bevor sie die Beiträge der anderen sehen und darauf antworten können.
* Standardforum in blog-ähnlicher Anzeige - offenes Forum, in dem jeder zu jeder Zeit ein neues Thema beginnen und auf alle Beiträge antworten kann. In einer Übersicht sind Betreffzeilen und die Beitragsanfänge sichtbar, zum jeweiligen Gesamtbeitrag und zu dessen Antworten führt ein Link.
* Standardforum - offenes Forum, in dem jeder zu jeder Zeit ein neues Thema eröffnen und auf alle Beiträge antworten kann. In einer Übersicht sind alle Betreffzeilen zu sehen.';
$string['forum:viewallratings'] = 'Alle Teilwertungen sehen';
$string['forum:viewanyrating'] = 'Alle Gesamtwertungen sehen';
$string['forum:viewdiscussion'] = 'Themen sehen';
$string['forum:viewhiddentimedposts'] = 'Verborgene zeitliche Beiträge sehen';
$string['forum:viewqandawithoutposting'] = 'Frage- und Antwortbeiträge immer sehen';
$string['forum:viewrating'] = 'Eigene Gesamtwertung sehen';
$string['forum:viewsubscribers'] = 'Abonnentenliste sehen';
$string['generalforum'] = 'Standardforum';
$string['generalforums'] = 'Allgemeines Forum';
$string['hiddenforumpost'] = 'Verborgener Forumsbeitrag';
$string['inforum'] = 'in {$a}';
$string['introblog'] = 'Die Beiträge in diesem Forum wurden automatisch aus Teilnehmerblogs des Kurses erstellt, weil die Blogeinträge nicht mehr verfügbar sind';
$string['intronews'] = 'Nachrichten und Ankündigungen';
$string['introsocial'] = 'Offenes Forum ohne Themeneinschränkung';
$string['introteacher'] = 'Forum für Traineranmerkungen und -diskussionen';
$string['invalidaccess'] = 'Seitenzugriff war nicht korrekt';
$string['invaliddigestsetting'] = 'Eine ungültige Einstellung für Mail-Zusammenfassungen wurde bereitgestellt.';
$string['invaliddiscussionid'] = 'Falsche Themen-ID';
$string['invalidforcesubscribe'] = 'Falscher Modus beim Abonnement ';
$string['invalidforumid'] = 'Falsche Foren-ID';
$string['invalidparentpostid'] = 'Vorgänger Beitrags-ID war ungültig.';
$string['invalidpostid'] = 'Ungültige Beitrags-ID {$a}';
$string['lastpost'] = 'Letzter Beitrag';
$string['learningforums'] = 'Lernforen';
$string['longpost'] = 'Langer Beitrag';
$string['mailnow'] = 'Sofort als E-Mail';
$string['manydiscussions'] = 'Themen pro Seite';
$string['markalldread'] = 'Alle Beiträge dieser Diskussion als gelesen markieren';
$string['markallread'] = 'Alle Beiträge in diesem Forum als gelesen markieren';
$string['markread'] = 'Als gelesen markieren';
$string['markreadbutton'] = 'Als gelesen<br />markieren';
$string['markunread'] = 'Als ungelesen markieren';
$string['markunreadbutton'] = 'Als ungelesen<br /> markieren';
$string['maxattachments'] = 'Anhänge (max.)';
$string['maxattachments_help'] = 'Diese Einstellung legt fest, wie viele Anhänge maximal pro Beitrag in diesem Forum erlaubt sind.';
$string['maxattachmentsize'] = 'Maximale Dateigröße';
$string['maxattachmentsize_help'] = 'Diese Einstellung legt fest, welche maximale Dateigröße pro Anhang in diesem Forum erlaubt ist.';
$string['maxtimehaspassed'] = 'Die Höchstdauer für die Bearbeitung dieses Eintrags ({$a}) ist überschritten!';
$string['message'] = 'Mitteilung';
$string['messageprovider:digests'] = 'Abonnierte Forenzusammenfassungen';
$string['messageprovider:posts'] = 'Abonnierte Forenbeiträge';
$string['missingsearchterms'] = 'Die folgenden Suchbegriffe tauchen lediglich in den HTML-Formatierungen dieser Mitteilung auf:';
$string['modeflatnewestfirst'] = 'Anzeige nach Zeit (neu > alt)';
$string['modeflatoldestfirst'] = 'Anzeige nach Zeit (alt > neu)';
$string['modenested'] = 'Anzeige geschachtelt';
$string['modethreaded'] = 'Anzeige hierarchisch';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Richten Sie ein Forum ein, um den Teilnehmer/innen Ihres Kurses die Gelegenheit zur Diskussion zu geben.

Weitere Möglichkeiten:
* Verschiedene Forentypen
* Dateianhänge
* Bilder einbinden
* Foren abonnieren
* Forumsbeiträge bewerten
* Gruppenarbeit.

Hinweis: Im Nachrichtenforum können ausschließlich Trainer/innen eines Kurse Beiträge schreiben. Teilnehmer/innen dürfen im Nachrichtenforum weder eigene Beiträge schreiben noch andere beantworten.';
$string['modulenameplural'] = 'Foren';
$string['more'] = 'weiter';
$string['movedmarker'] = '(Verschoben)';
$string['movethisdiscussionto'] = 'Das Thema verschieben nach ...';
$string['mustprovidediscussionorpost'] = 'Für den Export müssen Sie entweder eine Themen-ID oder eine Nachrichten-ID angeben';
$string['namenews'] = 'Nachrichtenforum';
$string['namenews_help'] = 'Das Nachrichtenforum ist ein spezielles Forum für Ankündigungen, welches automatisch von Moodle in jedem Kurs und auch der Startseite generiert wird. Ausschließlich Trainer/innen und Administrator/innen dürfen im Nachrichtenforum schreiben. Pro Kurs kann es nur ein Nachrichtenforum geben. Im Block "Neue Nachrichten" werden die aktuelle Beiträge angezeigt. ';
$string['namesocial'] = 'Soziales Forum';
$string['nameteacher'] = 'Trainerforum';
$string['newforumposts'] = 'Neue Forumsbeiträge';
$string['noattachments'] = 'Die Nachricht hat keine Anhänge';
$string['nodiscussions'] = 'Keine Themen im Forum';
$string['nodiscussionsstartedby'] = '\'{$a}\' hat noch kein Thema begonnen';
$string['nodiscussionsstartedbyyou'] = 'Sie haben noch kein Thema begonnen';
$string['noguestpost'] = 'Gäste dürfen keine Beiträge schreiben';
$string['noguesttracking'] = 'Gäste dürfen keine Einstellungen vornehmen';
$string['nomorepostscontaining'] = 'Es wurden keine weiteren Beiträge mit \'{$a}\' gefunden.';
$string['nonews'] = 'Keine Nachrichten im Forum';
$string['noonecansubscribenow'] = 'Abonnements sind jetzt nicht erlaubt';
$string['nopermissiontosubscribe'] = 'Sie haben nicht das Recht, die Liste der Abonnenten im Forum anzuzeigen.';
$string['nopermissiontoview'] = 'Sie haben nicht das Recht, diesen Beitrag anzuzeigen.';
$string['nopostforum'] = 'Sie dürfen in diesem Forum keine Beiträge schreiben';
$string['noposts'] = 'Keine Beiträge';
$string['nopostsmadebyuser'] = '\'{$a}\' hat keine Beiträge geschrieben';
$string['nopostsmadebyyou'] = 'Sie haben noch keine Beiträge geschrieben';
$string['noquestions'] = 'Keine Beiträge im Forum';
$string['nosubscribers'] = 'Keine Abonnent/innen im Forum';
$string['notexists'] = 'Diskussion existiert nicht länger';
$string['nothingnew'] = 'Nichts Neues für {$a}';
$string['notingroup'] = 'Das Forum steht nur für Mitglieder der Gruppe zur Verfügung';
$string['notinstalled'] = 'Das Modul \'Forum\' ist nicht installiert.';
$string['notpartofdiscussion'] = 'Dieser Beitrag ist nicht Teil einer Diskussion!';
$string['notrackforum'] = 'Ungelesene Beiträge nicht markieren';
$string['noviewdiscussionspermission'] = 'Sie dürfen die Themen in diesem Forum nicht sehen';
$string['nowallsubscribed'] = 'Sie haben alle Foren von {$a} abonniert';
$string['nowallunsubscribed'] = 'Sie haben kein Forum von {$a} abonniert';
$string['nownotsubscribed'] = '{$a->name} wird künftig KEINE Kopien von \'{$a->forum}\' per E-Mail erhalten.';
$string['nownottracking'] = '{$a->name} will \'{$a->forum}\' nicht weiter verfolgen.';
$string['nowsubscribed'] = '{$a->name} wird künftig Kopien von \'{$a->forum}\'  per E-Mail erhalten.';
$string['nowtracking'] = '{$a->name} verfolgt nun das \'{$a->forum}\'.';
$string['numposts'] = '{$a} Beiträge';
$string['olderdiscussions'] = 'Ältere Diskussionen';
$string['oldertopics'] = 'Ältere Beiträge';
$string['oldpostdays'] = '\'Gelesen\' nach x Tagen';
$string['openmode0'] = 'Keine neuen Themen, keine Antworten';
$string['openmode1'] = 'Keine neuen Themen, aber Antworten erlaubt';
$string['openmode2'] = 'Neue Themen und Antworten erlaubt';
$string['overviewnumpostssince'] = 'Beiträge seit dem letzten Besuch: {$a}';
$string['overviewnumunread'] = 'Ungelesene Beiträge: {$a}';
$string['page-mod-forum-discuss'] = 'Forumsdiskussionsseite
';
$string['page-mod-forum-view'] = 'Forumshauptseite';
$string['page-mod-forum-x'] = 'Jede Forumsseite';
$string['parent'] = 'Ursprungsbeitrag';
$string['parentofthispost'] = 'Ursprungsbeitrag zum Beitrag';
$string['pluginadministration'] = 'Forum-Administration';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Ihr Beitrag wurde erfolgreich hinzugefügt. </p><p>Wenn Sie etwas ändern möchten, haben Sie {$a} Zeit dafür.</p>';
$string['postaddedsuccess'] = 'Der Beitrag wurde erfolgreich eingefügt.';
$string['postaddedtimeleft'] = 'Wenn Sie etwas korrigieren möchten, haben Sie {$a} Zeit für diese Änderungen.';
$string['postbyuser'] = '{$a->post} von {$a->user}';
$string['postincontext'] = 'Diskussion im Forum zeigen';
$string['postmailinfo'] = 'Diese Mitteilung wurde auf der Webseite \'{$a}\' eingetragen.

Über diesen Link können Sie eine Antwort schreiben:';
$string['postmailnow'] = 'Dieser Beitrag wird direkt als E-Mail an alle Abonnent/innen des Forums versendet.';
$string['postrating1'] = 'Nutzt Wissen über einzelne Fakten';
$string['postrating2'] = 'Reflektiert das Wissen in Einzelfällen';
$string['postrating3'] = 'Berücksichtigt den Gesamtzusammenhang und wägt Fakten ab';
$string['posts'] = 'Beiträge';
$string['postsmadebyuser'] = 'Beiträge von {$a}';
$string['postsmadebyuserincourse'] = 'Beiträge von {$a->fullname} in {$a->coursename}';
$string['posttoforum'] = 'Beitrag absenden';
$string['postupdated'] = 'Der Beitrag wurde aktualisiert';
$string['potentialsubscribers'] = 'Mögliche Abonnent/innen';
$string['processingdigest'] = 'Verarbeitung der E-Mail-Zusammenfassung für {$a}';
$string['processingpost'] = 'Beitrag {$a} wird bearbeitet';
$string['prune'] = 'Thema teilen';
$string['prunedpost'] = 'Mit diesem Beitrag wurde ein neues Thema begonnen';
$string['pruneheading'] = 'Das Thema teilen und mit diesem Beitrag ein neues Thema beginnen';
$string['qandaforum'] = 'Frage-Antwort-Forum';
$string['qandanotify'] = 'In diesem Frage-Antwort-Forum müssen Sie zuerst eine eigene Antwort eintragen, bevor Sie die Antworten anderer Personen sehen können';
$string['re'] = 'Re:';
$string['readtherest'] = 'Thema vollständig anzeigen ';
$string['replies'] = 'Antworten';
$string['repliesmany'] = '{$a} Antworten';
$string['repliesone'] = '{$a} Antwort bis jetzt';
$string['reply'] = 'Antworten';
$string['replyforum'] = 'Im Forum antworten';
$string['replytouser'] = 'E-Mail-Adresse in Antwort nutzen';
$string['resetdigests'] = 'Alle nutzerspezifischen Einstellungen für Forenzusammenfassungen löschen.';
$string['resetforums'] = 'Beiträge entfernen von';
$string['resetforumsall'] = 'Alle Beiträge löschen';
$string['resetsubscriptions'] = 'Alle Forumsabonnements entfernen';
$string['resettrackprefs'] = 'Alle Einstellungen zu Forenmarkierungen löschen';
$string['rssarticles'] = 'Anzahl der neuen RSS-Artikel';
$string['rssarticles_help'] = 'Diese Einstellung legt die Anzahl der Beiträge fest, die als aktuell in
den RSS Feed übernommen werden. Eine Zahl zwischen 5 und 20 sollte bei den meisten Foren angemessen sein. Eine höhere Zahl ist erforderlich, wenn das Forum sehr aktiv ist.';
$string['rsssubscriberssdiscussions'] = 'RSS Feed für Themen';
$string['rsssubscriberssposts'] = 'RSS-Feed für Beiträge';
$string['rsstype'] = 'RSS Feed für dieses Forum';
$string['rsstype_help'] = 'Um RSS Feeds für diese Aktivität zu aktivieren, wählen SIe entweder Themen oder Beiträge für diesen Feed aus.';
$string['search'] = 'Suche';
$string['searchdatefrom'] = 'Beiträge müssen neuer sein als';
$string['searchdateto'] = 'Beiträge müssen älter sein als';
$string['searchforumintro'] = 'Tragen Sie die Suchbegriffe in einem oder mehreren Feldern ein:';
$string['searchforums'] = 'Suche in Foren';
$string['searchfullwords'] = 'Als vollständige Worte suchen';
$string['searchnotwords'] = 'Diese Worte sollen NICHT im Suchergebnis vorkommen';
$string['searcholderposts'] = 'Ältere Beiträge suchen...';
$string['searchphrase'] = 'Dieser Text muss genau so im Beitrag vorkommen';
$string['searchresults'] = 'Suchergebnisse';
$string['searchsubject'] = 'Diese Worte sollen im Betreff vorkommen';
$string['searchuser'] = 'Name des Autors/der Autorin';
$string['searchuserid'] = 'Moodle-ID des Autors/der Autorin';
$string['searchwhichforums'] = 'Forum für Suche auswählen';
$string['searchwords'] = 'Alle Worte können an jeder Stelle des Beitrags auftauchen';
$string['seeallposts'] = 'Alle Beiträge dieser Person ansehen';
$string['shortpost'] = 'Kurzer Beitrag';
$string['showsubscribers'] = 'Abonnentenliste';
$string['singleforum'] = 'Diskussion zu einzelnem Thema';
$string['smallmessage'] = '{$a->user} schrieb in {$a->forumname}';
$string['startedby'] = 'Begonnen von';
$string['subject'] = 'Betreff';
$string['subscribe'] = 'Ich möchte das Forum abonnieren';
$string['subscribeall'] = 'Alle Teilnehmer/innen haben in dieses Forum abonniert';
$string['subscribed'] = 'Abonniert';
$string['subscribeenrolledonly'] = 'Nur eingeschriebene Nutzer/innen dürfen Forenbeiträge per E-Mail abonnieren.';
$string['subscribenone'] = 'Forum für alle Teilnehmer/innen abbestellen';
$string['subscribers'] = 'Abonnent/innen';
$string['subscribersto'] = 'Abonnent/innen für \'{$a}\'';
$string['subscribestart'] = 'Beiträge per E-Mail an mich senden';
$string['subscribestop'] = 'Keine Beiträge als E-Mail an mich senden';
$string['subscription'] = 'Abonnement';
$string['subscriptionandtracking'] = 'Abonnement';
$string['subscriptionauto'] = 'Automatisch';
$string['subscriptiondisabled'] = 'Deaktiviert';
$string['subscriptionforced'] = 'Verpflichtend';
$string['subscription_help'] = 'Wenn Sie ein Forum abonniert haben, werden alle neuen Beiträge des Forums per E-Mail an Sie gesandt.

Normalerweise dürfen Sie auswählen, ob Sie die Beiträge bekommen möchten. Manche Foren sind aber so eingestellt, dass das Abonnement verpflichtend ist und jeder alle Beiträge bekommt.';
$string['subscriptionmode'] = 'Abonnement';
$string['subscriptionmode_help'] = 'Alle Abonnent/innen dieses Forums bekommen die Beiträge per E-Mail zugesandt. Es gibt unterschiedliche Modi für ein Abonnement:

* Optional - alle dürfen auswählen, ob sie das Forum abonnieren möchten oder nicht
* Verpflichtend - alle haben das Forum abonniert und niemand kann es abbestellen
* Automatisch - alle haben das Forum abonniert, dürfen es aber jederzeit abbestellen
* Deaktiviert - Das Forum kann von niemandem abonniert werden

Änderungen des Abonnements haben nur Einfluss auf Nutzer/innen, die zukünftig in den Kurs eingeschrieben werden. Für bestehende Nutzer/innen muss die Abonnementliste manuell angepasst werden.';
$string['subscriptionoptional'] = 'Optional';
$string['subscriptions'] = 'Abonnements';
$string['thisforumisthrottled'] = 'Für dieses Forum ist eine Höchstzahl von Beiträgen innerhalb eines bestimmten Zeitraums festgelegt worden. Dies gilt nach {$a->blockafter} Beiträgen innerhalb von {$a->blockperiod}';
$string['timedposts'] = 'Zeitgesteuerte Beiträge';
$string['timestartenderror'] = 'Der Endtermin kann nicht vor dem Starttermin liegen.';
$string['trackforum'] = 'Ungelesene Beiträge markieren';
$string['tracking'] = 'Markieren?';
$string['trackingoff'] = 'Aus';
$string['trackingon'] = 'Vorgegeben';
$string['trackingoptional'] = 'Optional';
$string['trackingtype'] = 'Lesetracking';
$string['trackingtype_help'] = 'Wenn diese Option aktiviert ist, sehen Teilnehmer/innen gelesene und ungelesene Beiträge unterschiedlich markiert im Forum. Es stehen drei Optionen zur Verfügung:

* Optional - Die Markierung ist ein- und ausschaltbar mit einem Link im Block Administration.
* Verpflichtend/Erzwungen - Die Markierung ist immer an
* Aus - Die Markierung ist immer aus. Gelesene und ungelesene Beiträge werden nicht erfasst.';
$string['unread'] = 'Ungelesen';
$string['unreadposts'] = 'Ungelesene Beiträge';
$string['unreadpostsnumber'] = '{$a} ungelesene Beiträge';
$string['unreadpostsone'] = '1 ungelesener Beitrag';
$string['unsubscribe'] = 'Ich möchte das Forum abbestellen';
$string['unsubscribeall'] = 'Ich möchte alle Foren abbestellen';
$string['unsubscribeallconfirm'] = 'Zahl der aktuell abonnierten Foren: {$a}. Möchten Sie wirklich alle Foren abbestellen und die automatische Anmeldung ausschalten?';
$string['unsubscribealldone'] = 'Sie haben alle Abonnements abbestellt. Trotzdem werden Sie Beiträge aus Foren erhalten, in die Personen zwingend eingetragen sind. Falls Sie gar keine E-Mails von diesem Server erhalten möchten, deaktivieren Sie bitte Ihre E-Mail-Adresse im Nutzerprofil oder unter Mitteilungen.';
$string['unsubscribeallempty'] = 'Sie haben kein Forum abonniert. Falls Sie gar keine E-Mails von diesem Server erhalten möchten, deaktivieren Sie Ihre E-Mail-Adresse im Nutzerprofil.';
$string['unsubscribed'] = 'Abgemeldet';
$string['unsubscribeshort'] = 'Abmelden';
$string['usermarksread'] = '\'Gelesen\' manuell markieren';
$string['viewalldiscussions'] = 'Alle Themen anzeigen';
$string['warnafter'] = 'Warnung';
$string['warnafter_help'] = 'Vor dem Erreichen der Beitragshöchstzahl innerhalb des Zeitfensters können die Nutzer/innen gewarnt werden. Die Einstellung legt fest, nach wie vielen Beiträgen die Warnung gezeigt wird. Nutzer/innen mit der Berechtigung mod/forum:postwithoutthrottling sind von einer Sperre ausgenommen.';
$string['warnformorepost'] = 'Warnung! Es gibt mehr als eine Diskussion in diesem Forum. Es wird die Aktuellste genutzt.';
$string['yournewquestion'] = 'Neue Frage';
$string['yournewtopic'] = 'Neues Thema';
$string['yourreply'] = 'Antwort';
