<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'ru', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alert1'] = 'Первое уведомление';
$string['alert2'] = 'Второе уведомление';
$string['alert3'] = 'Третье уведомление';
$string['alert_general'] = 'Объявление';
$string['alert_info'] = 'Информация';
$string['alertsdesc'] = 'На главной странице сайта появится уведомление (или несколько) в трех различных стилях. Пожалуйста, не забудьте отключить их, когда они будут больше не нужны.';
$string['alertsheading'] = 'Уведомления пользователям';
$string['alertsheadingsub'] = 'Показать важные объявления для пользователей на главной странице';
$string['alerttext'] = 'Текст уведомления';
$string['alerttextdesc'] = 'Текст, который будет отображаться в вашем уведомлении.';
$string['alerttitle'] = 'Название';
$string['alerttitledesc'] = 'Главное название/заголовок для вашего уведомления';
$string['alerttype'] = 'Уровень';
$string['alerttypedesc'] = 'Установите соответствующий уровень/тип уведомления для лучшего информирования пользователей';
$string['alert_warning'] = 'Предупреждение';
$string['allclasses'] = 'Все классы';
$string['allcourses'] = 'Все курсы';
$string['allmodules'] = 'Все модули';
$string['allunits'] = 'Все задания';
$string['alternativecolors'] = 'Альтернативная цветовая схема {$a}';
$string['alternativethemecolor'] = 'Альтернативный цвет темы {$a}';
$string['alternativethemecolordesc'] = 'Цвет темы, который будет использоваться в альтернативной цветовой схеме {$a}.';
$string['alternativethemecolorname'] = 'Название альтернативной цветовой схемы {$a}';
$string['alternativethemecolornamedesc'] = 'Задайте запоминающееся название для этого набора цветов альтернативной темы';
$string['alternativethemecolors'] = 'Альтернативные цветовые схемы';
$string['alternativethemecolorsdesc'] = 'Определяет альтернативные цвета темы, которые может выбрать пользователь.';
$string['alternativethemehovercolor'] = 'Альтернативный цвет при наведении  {$a}';
$string['alternativethemehovercolordesc'] = 'Какого цвета должны быть ссылки при наведении на них курсора в альтернативной цветовой схеме {$a}.';
$string['alternativethemename'] = 'Название цветовой схемы';
$string['alternativethemenamedesc'] = 'Укажите название для альтернативной цветовой схемы';
$string['alternativethemetextcolor'] = 'Альтернативный цвет текста {$a}';
$string['alternativethemetextcolordesc'] = 'Задайте альтернативный цвет для текста в схеме  {$a}.';
$string['alternativethemeurlcolor'] = 'Альтернативный цвет ссылки {$a}';
$string['alternativethemeurlcolordesc'] = 'Задайте альтернативный цвет для ссылки в схеме  {$a}.';
$string['alwaysdisplay'] = 'Всегда показывать';
$string['analytics'] = 'Аналитика';
$string['analyticscleanurl'] = 'Чистые URL-адреса';
$string['analyticscleanurldesc'] = 'Генерировать чистый URL-адрес для детального отслеживания';
$string['analyticsdesc'] = 'Выберите тип аналитики, которую вы хотите вставить, и нажмите на кнопку «Сохранить», чтобы включить другие настройки.';
$string['analyticsenabled'] = 'Включено';
$string['analyticsenableddesc'] = 'Включить аналитику для Moodle';
$string['analyticsguniversal'] = 'Универсальная аналитика Google';
$string['analyticsheadingsub'] = 'Мощная аналитика от Google';
$string['analyticsimagetrack'] = 'Отслеживание изображений';
$string['analyticsimagetrackdesc'] = 'Включить отслеживание изображений для браузеров с отключенным JavaScript';
$string['analyticspiwik'] = 'Веб-аналитика Piwik';
$string['analyticssiteid'] = 'ID сайта';
$string['analyticssiteiddesc'] = 'Введите ID своего сайта (Site ID)';
$string['analyticssiteurl'] = 'Аналитика URL-адреса';
$string['analyticssiteurldesc'] = 'Для аналитики Piwik введите свой URL-адрес без http(s) и слэша в конце. Например: «mysite.com/analytics».';
$string['analyticstrackadmin'] = 'Отслеживать администраторов';
$string['analyticstrackadmindesc'] = 'Включить отслеживание пользователей с правами администратора (не рекомендуется)';
$string['analyticstrackingid'] = 'ID сайта';
$string['analyticstrackingiddesc'] = 'Введите свой ID для отслеживания (Tracking ID)';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Введите URL своего мобильного приложения в магазине Google Play. Если у Вас нет своего приложения, то Вы можете ввести в это поле ссылку на официальное мобильное приложение Moodle (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile).';
$string['backgroundstylefixed'] = 'Фиксированный';
$string['backgroundstylestretch'] = 'Растягивающийся';
$string['backgroundstyletiled'] = 'Мозаичный';
$string['backtotop'] = 'К началу';
$string['badgepreferences'] = 'Настройки значков';
$string['blogpreferences'] = 'Настройки блога';
$string['bootstrapcdn'] = 'FontAwesome из CDN';
$string['bootstrapcdndesc'] = 'Если параметр включен, то загрузка FontAwesome происходит из онлайн-источника Bootstrap CDN. Включите этот параметр, если Вы испытываете проблемы с получением значков Font Awesome для отображения на своем сайте.';
$string['breadcrumbsimple'] = 'Простой';
$string['breadcrumbstyle'] = 'Стиль иерархической навигации';
$string['breadcrumbstyled'] = 'Причудливый';
$string['breadcrumbstyledesc'] = 'Здесь Вы можете изменить стиль иерархической навигации';
$string['breadcrumbstylednocollapse'] = 'Причудливый без сворачивания';
$string['breadcrumbthin'] = 'Узкий';
$string['cachesused'] = 'Использованные кэши';
$string['categoryiconcategory'] = 'Значок для категории: {$a->category}.';
$string['categoryicondesc'] = 'При включенном параметре Вы сможете задавать значки для каждой категории курсов';
$string['categoryiconheading'] = 'Значки категорий';
$string['categoryiconheadingsub'] = 'Использовать значки для представления категорий';
$string['categoryiconinfo'] = 'Использовать пользовательский набор значков для категорий';
$string['categoryiconinfodesc'] = 'Введите имя значка, который Вы хотите использовать.  Список есть <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">здесь</a>. Просто введите то, что стоит после «fa-».';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>О теме Essential</h3>
<p>Essential основана на теме Bootstrap, которая была создана для Moodle 2.5 с помощью:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Разработчики темы</h3>
<p>Автор исходнй версии : Джулиан Ридден (Julian Ridden)<br>
С июля 2014 года работу продолжили:<br>
Гарет Барнард (Gareth J. Barnard)<br>
Дэвид Беземер (David Bezemer)<br>
</p>
<h3>Пожертвования</h3>
<p>Эта тема предоставляется бесплатно. Если Вы хотите выразить свою благодарность за использование этой темы, пожалуйста, поддержите нас,
<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=themmai%40gmail%2ecom&lc=GB&item_name=Essential%20Theme%20Fund¤cy_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_LG%2egif%3aNonHosted" target="_blank">
     пройдя по этой ссылке для пожертвования.
</a><br>Пожертвования могут позволить нам быстрее предоставить новые возможности и улучшения  темы.</p>
</div></div>';
$string['colordesc'] = 'Здесь можно найти различные настройки для изменения многих цветов этой темы.';
$string['colorheading'] = 'Цвет';
$string['colorheadingsub'] = 'Задать цвета, используемые в этой теме';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Контактная информация';
$string['contactinfodesc'] = 'Введите свою контактную информацию';
$string['copyright'] = 'Авторские права';
$string['copyrightdesc'] = 'Название вашей организации.';
$string['coursegrades'] = 'Оценки по курсам';
$string['customcss'] = 'Пользовательский CSS';
$string['customcssdesc'] = 'Любые добавленные здесь правила CSS будут учитываться на всех страницах сайта, что облегчает настройку этой темы.';
$string['dbqueries'] = 'Чтение/Запись БД';
$string['defaultcategoryicon'] = 'Значки для категорий по умолчанию';
$string['defaultcategoryicondesc'] = 'Задайте значок, который по умолчанию будет использоваться для категорий';
$string['defaultcolors'] = 'Цвета по умолчанию';
$string['displayafterlogin'] = 'Показывать только после входа в систему';
$string['displaybeforelogin'] = 'Показывать только до входа в систему';
$string['displaymycourses'] = 'Отображать изучаемые курсы';
$string['displaymycoursesdesc'] = 'Отображать изучаемые курсы в пользовательском меню';
$string['donate_desc'] = 'Пожалуйста, {$a->url}, чтобы поддержать разработку темы Essential или просто выразить свою благодарность.';
$string['donate_desc2'] = ', чтобы поддержать разработку темы Essential или просто выразить свою благодарность.';
$string['donate_title'] = 'Поддержка Essential';
$string['dontdisplay'] = 'Не отображать';
$string['enablealert'] = 'Включить предупреждения';
$string['enablealertdesc'] = 'Включить или отключить предупреждения';
$string['enablealternativethemecolors'] = 'Включить альтернативную цветовую схему {$a}';
$string['enablealternativethemecolorsdesc'] = 'При включенном параметре пользователь сможет выбрать альтернативную цветовую схему  {$a}.';
$string['enablecategoryicon'] = 'Включить значки категорий';
$string['enablecategoryicondesc'] = 'Если параметр включен, то Вы сможете выбирать значки для категорий после нажатия «Сохранить изменения».';
$string['enablecustomcategoryicon'] = 'Включить пользовательские значки категорий';
$string['enablecustomcategoryicondesc'] = 'Если параметр включен, то ниже этого раздела Вы увидите все категории с параметром настройки рядом с их названием. Нажмите «Сохранить изменения» после включения или выключения этого параметра.';
$string['extperfinfoheading'] = 'Расширенная информация о производительности';
$string['facebook'] = 'URL-адрес Facebook';
$string['facebookdesc'] = 'Введите адрес своей страницы в Facebook. (Например, https://www.facebook.com/mycollege)';
$string['few'] = 'Несколько';
$string['fitvids'] = 'Использовать FitVids';
$string['fitvidsdesc'] = 'Включите FitVids (fitvidsjs.com), чтобы встроенные видео подстраивались под ширину окна браузера, стали «отзывчивыми» (responsive).  Если FitVids включен и вы хотите, чтобы он не использовался для конкретного видео, добавьте class="fitvidsignore" к тегу iframe в HTML-режиме редактора.  Например: «iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe».';
$string['fixedwidthnarrow'] = 'Фиксированная ширина - Узкий';
$string['fixedwidthnormal'] = 'Фиксированная ширина - Нормальный';
$string['fixedwidthwide'] = 'Фиксированная ширина - Широкий';
$string['flattr_click'] = 'пожертвовать через Flattr';
$string['flattr_desc'] = '{$a->url}';
$string['flickr'] = 'URL-адрес Flickr';
$string['flickrdesc'] = 'Введите адрес своей страницы в Flickr. (Например, http://www.flickr.com/mycollege)';
$string['fontcharacterset'] = 'Дополнительный набор символов для шрифтов Google';
$string['fontcharactersetcyrillic'] = 'Кириллица (Cyrillic)';
$string['fontcharactersetcyrillicext'] = 'Кириллица расширенная (Cyrillic Extended)';
$string['fontcharactersetdesc'] = 'Выберите дополнительные наборы символов для разных языков.
Использование нескольких наборов символов может замедлить загрузку веб-страницы, поэтому выбирайте только те наборы символов, которые действительно необходимы на странице.';
$string['fontcharactersetgreek'] = 'Греческий (Greek)';
$string['fontcharactersetgreekext'] = 'Греческий расширенный (Greek Extended)';
$string['fontcharactersetlatinext'] = 'Латиница  расширенная (Latin Extended)';
$string['fontcharactersetvietnamese'] = 'Вьетнамский (Vietnamese)';
$string['fontfileeotbody'] = 'Файл EOT-шрифта для основного текста';
$string['fontfileeotheading'] = 'Файл EOT-шрифта для заголовков';
$string['fontfileotfbody'] = 'Файл OTF-шрифта для основного текста';
$string['fontfileotfheading'] = 'Файл OTF-шрифта для заголовков';
$string['fontfiles'] = 'Файлы шрифтов';
$string['fontfilesdesc'] = 'Загрузите сюда свои файлы шрифтов (поддерживаются только файлы формата TTF).';
$string['fontfilesvgbody'] = 'Файл SVG-шрифта для основного текста';
$string['fontfilesvgheading'] = 'Файл SVG-шрифта для заголовков';
$string['fontfilettfbody'] = 'Файл шрифта TTF для основого текста';
$string['fontfilettfheading'] = 'Файл шрифта TTF для заголовков';
$string['fontfilewoffbody'] = 'Файл WOFF-шрифта для основного текста';
$string['fontfilewoffheading'] = 'Файл WOFF-шрифта для заголовков';
$string['fontfilewofftwobody'] = 'Файл WOFF2-шрифта для основного текста';
$string['fontfilewofftwoheading'] = 'Файл WOFF2-шрифта для заголовков';
$string['fontheadingdesc'] = 'Выберите и введите шрифты, которые Вы хотите использовать в своей среде Moodle.';
$string['fontheadingsub'] = 'Настройки шрифтов';
$string['fontnamebody'] = 'Шрифт текста';
$string['fontnamebodydesc'] = 'Введите точное имя шрифта, используемого для всего остального текста.';
$string['fontnameheading'] = 'Шрифт заголовка';
$string['fontnameheadingdesc'] = 'Введите точное имя шрифта, используемого для всех заголовков.';
$string['fontselect'] = 'Выбор шрифта';
$string['fontselectdesc'] = 'Выберите шрифт из списка доступных сочетаний. Нажмите на кнопку «Сохранить», чтобы увидеть настройки для выбранного вами варианта.';
$string['fontsettings'] = 'Шрифт';
$string['fonttypecustom'] = 'Шрифт пользователя';
$string['fonttypegoogle'] = 'Веб-шрифты Google';
$string['fonttypestandard'] = 'Стандартные шрифты';
$string['footercolor'] = 'Фон нижнего колонтитула';
$string['footercolordesc'] = 'Задайте цвет фона нижнего колонтитула.';
$string['footercolors'] = 'Цвета нижнего колонтитула';
$string['footercolorsdesc'] = 'Изменить цвета для нижних колонтитулов страниц';
$string['footerheading'] = 'Нижний колонтитул';
$string['footerheadingcolor'] = 'Цвет заголовка нижнего колонтитула';
$string['footerheadingcolordesc'] = 'Задайте цвет для заголовков блоков в нижнем колонтитуле.';
$string['footerhovercolor'] = 'Цвет ссылки при наведении курсора в нижнем колонтитуле';
$string['footerhovercolordesc'] = 'Задайте цвет ссылки при наведении курсора в нижнем колонтитуле.';
$string['footersepcolor'] = 'Цвет разделителя нижнего колонтитула';
$string['footersepcolordesc'] = 'Разделители и линии используются для разделения содержимого. Задайте их цвет здесь.';
$string['footertextcolor'] = 'Цвет текста в нижнем колонтитуле';
$string['footertextcolordesc'] = 'Задайте цвет текста для нижнего колонтитула.';
$string['footerurlcolor'] = 'Цвет ссылки в нижнем колонтитуле';
$string['footerurlcolordesc'] = 'Задайте цвет ссылок в нижнем колонтитуле.';
$string['footnote'] = 'Сноска';
$string['footnotedesc'] = 'Всё, что Вы добавите в это поле, будет отображаться в нижнем колонтитуле каждой страницы Вашего сайта.';
$string['frontcontent'] = 'Включить область контента на главной странице';
$string['frontcontentarea'] = 'Содержимое области контента главной страницы';
$string['frontcontentareadesc'] = 'Всё, что Вы введете в это поле, будет отображаться на всю ширину страницы между слайд-шоу и рекламными блоками.';
$string['frontcontentdesc'] = 'Если данный параметр включен, пользовательская область контента будет добавлена между слайд-шоу и рекламными блоками.';
$string['frontcontentheading'] = 'Область контента главной страницы';
$string['frontpageblocks'] = 'Выравнивание блоков главной страницы';
$string['frontpageblocksdesc'] = 'Здесь можно определить, как будут выравниваться стандартные блоки Moodle на главной странице: по левому или по правому краю.';
$string['frontpageblocksheading'] = 'Блоки главной страницы';
$string['frontpageheading'] = 'Главная страница';
$string['frontpageheadingdesc'] = 'Настройте, какие дополнительные элементы Вы хотите показывать на главной странице.';
$string['frontpagemiddleblocks'] = 'Включить дополнительные блоки по центру главной страницы';
$string['frontpagemiddleblocksdesc'] = 'Если данный параметр включен, то три дополнительных блока будут показываться прямо под рекламными блоками.';
$string['fullname'] = 'Полное название сайта';
$string['fullnamesummary'] = 'Полное название сайта и описание';
$string['generalheadingdesc'] = 'Настройте здесь глобальные параметры для темы.  Здесь Вы найдете настройки для макета и визуального представления.';
$string['generalheadingsub'] = 'Общие настройки';
$string['genericsettings'] = 'Общие';
$string['googleplus'] = 'URL-адрес Google+';
$string['googleplusdesc'] = 'Введите адрес своего профиля на Google+. (Например, https://plus.google.com/+mycollege)';
$string['headerheading'] = 'Верхний колонтитул';
$string['headertitle'] = 'Заголовок в верхнем колонтитуле';
$string['headertitledesc'] = 'Настройте здесь заголовок для вывода в верхнем колонтитуле.';
$string['helplink'] = 'Ссылка на помощь';
$string['helplinkdesc'] = 'Если Вы выбрали «URL», то введите выше полный URL-адрес своего сайта помощи (он должен содержать http:// или https://). Если Вы выбрали «адрес E-mail», то введите свой адрес электронной почты.';
$string['helplinktype'] = 'Включить в меню ссылку на помощь';
$string['helplinktypedesc'] = 'Выберите, хотите ли Вы включить в меню пользователя возможность получения помощи. Вы можете задать URL-адрес, который будет открыт в новом окне, или указать адрес электронной почты.';
$string['hideonphone'] = 'Скрыть слайд-шоу на мобильных';
$string['hideonphonedesc'] = 'Выберите, если хотите отключить слайд-шоу на мобильных.';
$string['hideontablet'] = 'Скрыть слайд-шоу на планшетах';
$string['hideontabletdesc'] = 'Выберите, если хотите отключить слайд-шоу на планшетах.';
$string['included'] = 'Включенные файлы';
$string['instagram'] = 'URL-адрес Instagram';
$string['instagramdesc'] = 'Введите адрес своей страницы в Instagram. (Например, http://instagram.com/mycollege)';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Введите адрес своего мобильного приложения в магазине App Store. Если у Вас нет своего приложения, Вы можете ввести в это поле ссылку на официальное мобильное приложение Moodle (https://itunes.apple.com/en/app/moodle-mobile/id633359593).';
$string['iosicon'] = 'Иконки домашней страницы для iOS';
$string['iosicondesc'] = 'Тема задает значок по умолчанию для домашних экранов iOS и android. При желании Вы можете загрузить свои значки.';
$string['ipadicon'] = 'Значок для iPad (Не Retina)';
$string['ipadicondesc'] = 'Значок должен быть в виде PNG-файла размером 72px на 72px.';
$string['ipadretinaicon'] = 'Значок для  iPad (Retina)';
$string['ipadretinaicondesc'] = 'Значок должен быть в виде PNG-файла размером 144px на 144px.';
$string['iphoneicon'] = 'Значок для iPhone/iPod Touch (Не Retina)';
$string['iphoneicondesc'] = 'Значок должен быть в виде PNG-файла размером 57px на 57px.';
$string['iphoneretinaicon'] = 'Значок для iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'Значок должен быть в виде PNG-файла размером 114px на 114px.';
$string['layout'] = 'Использовать стандартный вид курса';
$string['layoutdesc'] = 'Эта тема создана для размещения обоих колонок блоков с одной стороны. Если Вы предпочитаете стандартную раскладку Moodle, то можете включить этот параметр и вернуться к привычному старому виду в три колонки.';
$string['left'] = 'Слева';
$string['linkedin'] = 'URL-адрес LinkedIn';
$string['linkedindesc'] = 'Введите адрес своего профиля в LinkedIn. (Например, https://www.linkedin.com/company/mycollege)';
$string['loadtime'] = 'Время загрузки';
$string['loggedinas'] = 'вошел как';
$string['loggedinfrom'] = 'Вошел с';
$string['logo'] = 'Логотип';
$string['logodesc'] = 'Загрузите свой логотип, если Вы хотите добавить его в заголовок сайта.<br>Изображение должно быть высотой 65px и любой подходящей ширины.<br>При этом загруженный логотип заменит стандартный значок и название сайта, отображаемые по умолчанию.';
$string['marketing1'] = 'Первый рекламный блок';
$string['marketing2'] = 'Второй рекламный блок';
$string['marketing3'] = 'Третий рекламный блок';
$string['marketingbuttontext'] = 'Текст ссылки';
$string['marketingbuttontextdesc'] = 'Текст, отображаемый на кнопке.';
$string['marketingbuttonurl'] = 'URL-адрес ссылки';
$string['marketingbuttonurldesc'] = 'URL-адрес, на который перейдет пользователь, нажав на кнопку рекламного блока.';
$string['marketingcontent'] = 'Содержимое блока';
$string['marketingcontentdesc'] = 'Содержимое, отображаемое в окне рекламного блока. Оно должно быть коротким и привлекательным.';
$string['marketingdesc'] = 'Эта тема дает возможность включить три «рекламных» или «маркетинговых» блока, размещенных под слайд-шоу. Это позволит Вам легко представить основную информацию для пользователей и дать им прямые ссылки на нужный контент.';
$string['marketingheading'] = 'Рекламные блоки';
$string['marketingheadingsub'] = 'Три блока на главной странице для добавления информации и ссылок';
$string['marketingheight'] = 'Высота изображений в рекламных блоках';
$string['marketingheightdesc'] = 'Если Вы хотите показывать изображения в рекламных блоках, то в этом поле можно задать их высоту.';
$string['marketingicon'] = 'Значок';
$string['marketingicondesc'] = 'Название значка, который Вы хотите использовать. Список значков <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">здесь</a>. Просто введите то, что после «fa-», например, «star».';
$string['marketingimage'] = 'Изображение';
$string['marketingimagedesc'] = 'Дает возможность отображать изображение над текстом в рекламном блоке';
$string['marketinginfodesc'] = 'Задайте настройки своего рекламного блока.';
$string['marketingtitle'] = 'Название';
$string['marketingtitledesc'] = 'Введите название этого рекламного блока';
$string['marketingurltarget'] = 'Где открывать';
$string['marketingurltargetdesc'] = 'Выберите, как ссылка будет открываться';
$string['marketingurltargetnew'] = 'Новая страница';
$string['marketingurltargetparent'] = 'Родительский фрейм';
$string['marketingurltargetself'] = 'Текущая страница';
$string['memused'] = 'Использованная память';
$string['messagepreferences'] = 'Настройки сообщений';
$string['mobileappsdesc'] = 'У вас есть веб-приложение в магазинах App Store или Google Play? Укажите здесь ссылки на эти приложения, чтобы пользователи смогли получить к ним доступ онлайн.';
$string['mobileappsheading'] = 'Мобильные приложения';
$string['mobileappsheadingsub'] = 'Ссылка на Ваше приложение для студентов, использующих мобильные устройства';
$string['myclasses'] = 'Мои классы';
$string['mycourses'] = 'Мои курсы';
$string['mycoursesinfo'] = 'Меню курсов пользователя';
$string['mycoursesinfodesc'] = 'Отображать пользователю динамический список курсов, на которые он подписан.';
$string['mycoursetitle'] = 'Терминология';
$string['mycoursetitledesc'] = 'Измените терминологию для ссылки «Мои курсы» в выпадающем меню';
$string['mygrades'] = 'Мои оценки';
$string['mymodules'] = 'Мои модули';
$string['myunits'] = 'Мои задания';
$string['navbartitle'] = 'Заголовок навигационной панели';
$string['navbartitledesc'] = 'Настройте здесь заголовок для вывода в навигационной панели.';
$string['nextsection'] = 'Следующий раздел';
$string['nobreadcrumb'] = 'Скрыть';
$string['noenrolments'] = 'Вы не записаны ни на один курс';
$string['nomessagesfound'] = 'Сообщения не найдены';
$string['noslidetitle'] = 'Нет названия для слайда {$a->slide}';
$string['notitle'] = 'Без заголовка';
$string['numberofslides'] = 'Количество слайдов';
$string['numberofslides_desc'] = 'Число слайдов в слайд-шоу.';
$string['oldnavbar'] = 'Использовать старое расположение навигационной панели';
$string['oldnavbardesc'] = 'Включите этот параметр для использования старого расположения навигационной панели.';
$string['pagebackground'] = 'Изображение для фона страницы';
$string['pagebackgrounddesc'] = 'Загрузите свое изображение для фона страницы. Ниже выберите стиль изображения.';
$string['pagebackgroundstyle'] = 'Стиль фона страницы';
$string['pagebackgroundstyledesc'] = 'Выберите стиль для загруженного изображения.';
$string['pagewidth'] = 'Задать ширину страницы';
$string['pagewidthdesc'] = 'Выберите из списка доступные варианты ширины для своего сайта.';
$string['peakmem'] = 'Пиковая память';
$string['perfinfo'] = 'Режим информации о производительности';
$string['perfinfodesc'] = 'Многие сайты не нуждаются в подробной информации о производительности. Особенно, когда они просматриваются пользователями. При включенном параметре отображается сокращенная минимальная форма с базовой информацией о загрузке страницы.';
$string['perfinfoheading'] = 'Информация о производительности';
$string['perf_max'] = 'Детально';
$string['perf_min'] = 'Минимально';
$string['pinterest'] = 'URL-адрес Pinterest';
$string['pinterestdesc'] = 'Введите адрес своей страницы в Pinterest. (Например, http://pinterest.com/mycollege/mypinboard)';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Предыдущий раздел';
$string['profilebarcustomtitle'] = 'Заголовок пользовательского блока профиля';
$string['profilebarcustomtitledesc'] = 'Задайте название для пользовательского блока профиля.';
$string['readme_click'] = 'щелкните для чтения README.txt';
$string['readme_desc'] = 'Пожалуйста, {$a->url}, содержащего подробную информацию о теме Essential.';
$string['readme_title'] = 'Информация о теме Essential';
$string['readmore'] = 'Подробнее';
$string['region-footer-left'] = 'Нижний колонтитул (Слева)';
$string['region-footer-middle'] = 'Нижний колонтитул (По середине)';
$string['region-footer-right'] = 'Нижний колонтитул (Справа)';
$string['region-hidden-dock'] = 'Скрыть от пользователей';
$string['region-home-left'] = 'Главная страница (Слева)';
$string['region-home-middle'] = 'Главная страница (По середине)';
$string['region-home-right'] = 'Главная страница (Справа)';
$string['region-side-post'] = 'Справа';
$string['region-side-pre'] = 'Слева';
$string['right'] = 'Справа';
$string['serverload'] = 'Загрузка сервера';
$string['sessionsize'] = 'Размер сессии';
$string['shortname'] = 'Краткое название сайта';
$string['shortnamesummary'] = 'Краткое название сайта и описание';
$string['siteicon'] = 'Значок сайта';
$string['siteicondesc'] = 'У вашего сайта нет логотипа? Введите название значка, который Вы хотите использовать. Список значков <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">здесь</a>. Просто введите то, что после «fa-».';
$string['skype'] = 'Аккаунт Skype';
$string['skypedesc'] = 'Введите имя пользователя Skype из профиля Skype своей организации. (Например, my.college).';
$string['slidebuttoncolor'] = 'Цвет кнопки слайда';
$string['slidebuttoncolordesc'] = 'Цвет кнопки навигации на слайде';
$string['slidebuttonhovercolor'] = 'Цвет кнопки навигации на слайде при наведении';
$string['slidebuttonhovercolordesc'] = 'Цвет кнопки навигации на слайде при наведении курсора на кнопку';
$string['slidecaption'] = 'Подпись слайда';
$string['slidecaptionbelow'] = 'Подпись слайда под изображением';
$string['slidecaptionbelowdesc'] = 'Если под изображением должна быть подпись слайда.';
$string['slidecaptioncentred'] = 'Выравнивать подпись слайда по центру';
$string['slidecaptioncentreddesc'] = 'Включите, если подпись слайда должна быть выровнена по центру.';
$string['slidecaptiondesc'] = 'Введите текст подписи для использования на слайде';
$string['slidecolor'] = 'Цвет текста слайда';
$string['slidecolordesc'] = 'Цвет текста подписи слайда';
$string['slideimage'] = 'Изображение слайда';
$string['slideimagedesc'] = 'Лучше использовать изображение с прозрачностью.';
$string['slideinterval'] = 'Интервал между слайдами';
$string['slideintervaldesc'] = 'Интервал между сменой слайдов в миллисекундах.';
$string['slideno'] = 'Слайд {$a->slide}';
$string['slidenodesc'] = 'Задайте настройки для слайда {$a->slide}.';
$string['slideshowdesc'] = 'С помощью этих настроек создается динамическое слайд-шоу, состоящее максимум из 16 слайдов, предназначенных для продвижения важных элементов вашего сайта. Слайд-шоу может изменять свои размеры: высота изображения задается исходя из размера экрана. Рекомендуемая высота — 300px. Ширина задается как 100%, поэтому фактическая высота будет меньше, если ширина больше, чем размер экрана. На экранах меньшего размера высота динамически уменьшается без использования дополнительных изображений.  Используемые размеры: ширина экрана < 767px = высота 165px, ширина от 768px до 979px = высота 225px и ширина > 980px = высота 300px.  Если изображение для слайда не выбрано, то будет использоваться изображение default_slide из папки pix.';
$string['slideshowheading'] = 'Слайд-шоу';
$string['slideshowheadingsub'] = 'Динамическое слайд-шоу на главной странице';
$string['slidetitle'] = 'Заголовок слайда';
$string['slidetitledesc'] = 'Введите заголовок для Вашего слайда';
$string['slideurl'] = 'Ссылка для слайда';
$string['slideurldesc'] = 'Введите ссылку, на которую указывает изображение слайда';
$string['slideurltarget'] = 'Где открывать';
$string['slideurltargetdesc'] = 'Выберите, как ссылка должна будет открываться';
$string['slideurltargetnew'] = 'Новая страница';
$string['slideurltargetparent'] = 'Родительский фрейм';
$string['slideurltargetself'] = 'Текущая страница';
$string['socialdesc'] = 'Задайте прямые ссылки на основные социальные сети, продвигающие Ваш бренд. Они будут отображаться в верхнем колонтитуле каждой страницы.';
$string['socialheading'] = 'Социальные сети';
$string['socialheadingsub'] = 'Привлекайте своих пользователей в социальные сети';
$string['socialnetworks'] = 'Социальные сети';
$string['themecolor'] = 'Цвет темы';
$string['themecolordesc'] = 'Основной цвет темы. Это изменит цвет многих компонентов, для создания желаемого цвета на вашем сайте Moodle.';
$string['themecolors'] = 'Цвета темы';
$string['themehovercolor'] = 'Цвет темы при наведении';
$string['themehovercolordesc'] = 'Какого цвета должны быть элементы темы при наведении на них курсора. Этот цвет используется для ссылок, меню и т.д.';
$string['themeiconcolor'] = 'Цвет значка';
$string['themeiconcolordesc'] = 'Задайте цвет для всех значков.';
$string['themenavcolor'] = 'Цвет навигации';
$string['themenavcolordesc'] = 'Задайте цвет для навигации. Будет использоваться навигационной панелью и стилем «Причудливый» иерархической навигации.';
$string['themetextcolor'] = 'Цвет текста';
$string['themetextcolordesc'] = 'Задайте цвет для текста.';
$string['themeurlcolor'] = 'Цвет ссылки';
$string['themeurlcolordesc'] = 'Задайте цвет для текста ссылки.';
$string['togglemarketing'] = 'Показывать рекламные блоки';
$string['togglemarketingdesc'] = 'Выберите, показывать или нет три рекламных блока на сайте.';
$string['toggleslideshow'] = 'Показывать слайд-шоу';
$string['toggleslideshowdesc'] = 'Выберите, показывать или нет слайд-шоу на сайте.';
$string['twitter'] = 'URL-адрес Twitter';
$string['twitterdesc'] = 'Введите адрес своей ленты в Twitter. (Например, https://www.twitter.com/mycollege)';
$string['unreadnewnotification'] = 'Новое сообщение';
$string['usecategoryicon'] = 'Включить значки категорий';
$string['usecategoryicondesc'] = 'Использовать пользовательские значки для категорий';
$string['variablewidth'] = 'Переменная ширина';
$string['visibleadminonly'] = 'Блоки, размещенные в области ниже, доступны только администраторам';
$string['vk'] = 'URL-адрес ВКонтакте';
$string['vkdesc'] = 'Введите адрес своей страницы ВКонтакте. (Например, http://www.vk.com/mycollege)';
$string['website'] = 'URL-адрес веб-сайта';
$string['websitedesc'] = 'Введите адрес своего сайта. (Например, http://www.pupkin.com)';
$string['windows'] = 'Windows (для ПК)';
$string['windowsdesc'] = 'Введите URL-адрес своего мобильного приложения в Windows Store. Если у Вас нет своего приложения, то Вы можете ввести в это поле ссылку на официальное мобильное приложение Moodle (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc).';
$string['winphone'] = 'Windows (для мобильных устройств)';
$string['winphonedesc'] = 'Введите URL-адрес своего мобильного приложения в магазине Windows Phone Store. Если у Вас нет своего приложения, то Вы можете ввести в это поле ссылку на официальное мобильное приложение Moodle (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc).';
$string['youtube'] = 'URL-адрес YouTube';
$string['youtubedesc'] = 'Введите адрес своего канала в YouTube. (Например, https://www.youtube.com/mycollege)';
