<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'ru', branch 'MOODLE_26_STABLE'
 *
 * @package   lti
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Принимать';
$string['accept_grades'] = 'Принимать оценки от приложения';
$string['accept_grades_admin'] = 'Принимать оценки от приложения';
$string['accept_grades_admin_help'] = 'Определите, может ли поставляемое приложение добавлять, обновлять, считывать и удалять оценки, связанные с экземплярами этого типа приложения.

Некоторые поставляемые приложения поддерживают внесение в Moodle оценок, основанных на действиях с данным приложением, что способствует их интеграции.';
$string['accept_grades_help'] = 'Определите, может ли поставляемое приложение добавлять, обновлять, считывать и удалять оценки, связанные с экземплярами этого типа приложения.

Некоторые поставляемые приложения поддерживают внесение в Moodle оценок, основанных на действиях с данным приложением, что способствует их интеграции.

Обратите внимание, что этот параметр может быть переопределен в настройках приложения.';
$string['action'] = 'Действие';
$string['active'] = 'Активные';
$string['activity'] = 'Активный элемент';
$string['addnewapp'] = 'Разрешить внешнее приложение';
$string['addserver'] = 'Добавить новый доверенный сервер';
$string['addtype'] = 'Добавить настройки внешнего приложения';
$string['allow'] = 'Разрешить';
$string['allowinstructorcustom'] = 'Разрешить инструкторам добавлять свои параметры';
$string['allowsetting'] = 'Разрешить приложению хранить в Moodle настройки - 8К';
$string['always'] = 'Всегда';
$string['automatic'] = 'Автоматически, на основе запускающего URL';
$string['baseurl'] = 'Основной URL';
$string['basiclti'] = 'LTI';
$string['basicltiactivities'] = 'Активные элементы LTI';
$string['basiclti_base_string'] = 'Основная строка аутентификации LTI';
$string['basiclti_endpoint'] = 'Конечный пункт запуска LTI';
$string['basicltifieldset'] = 'Пример пользовательского набора полей';
$string['basiclti_in_new_window'] = 'Активный элемент будет открыт в новом окне';
$string['basicltiintro'] = 'Описание активного элемента';
$string['basicltiname'] = 'Название активного элемента';
$string['basiclti_parameters'] = 'Параметры запуска LTI';
$string['basicltisettings'] = 'Основные настройки Обучающего взаимодействующего приложения (LTI)';
$string['cannot_delete'] = 'Вы не можете удалить настройки этого приложения.';
$string['cannot_edit'] = 'Вы не можете изменять настройки этого приложения';
$string['comment'] = 'Комментарий';
$string['configpassword'] = 'Пароль Отдаленного приложения по умолчанию';
$string['configpreferheight'] = 'Предпочтительная высота по умолчанию';
$string['configpreferwidget'] = 'Установить как запуск по умолчанию';
$string['configpreferwidth'] = 'Предпочтительная ширина по умолчанию';
$string['configresourceurl'] = 'URL-адрес ресурса по умолчанию';
$string['configtoolurl'] = 'URL-адрес Отдаленного приложения по умолчанию';
$string['configtypes'] = 'Разрешить использование LTI';
$string['courseid'] = 'Идентификатор курса';
$string['coursemisconf'] = 'Курс не настроен';
$string['course_tool_types'] = 'Типы приложений курса';
$string['createdon'] = 'Дата создания';
$string['curllibrarymissing'] = 'Для использования LTI должна быть установлена библиотека PHP Curl';
$string['custom'] = 'Пользовательские параметры';
$string['custom_config'] = 'Использовать пользовательские настройки приложения.';
$string['custom_help'] = 'Пользовательские параметры настройки, используемые поставляемым приложением. Например, пользовательский параметр может быть использован для отображения определенного поставляемого ресурса. Можно оставить это поле без изменений, если приложение управляется поставщиком.';
$string['custominstr'] = 'Пользовательские параметры';
$string['debuglaunch'] = 'Варианты отладки';
$string['debuglaunchoff'] = 'Нормальный запуск';
$string['debuglaunchon'] = 'Запуск отладки';
$string['default'] = 'По умолчанию';
$string['default_launch_container'] = 'Запуск приложения по умолчанию';
$string['default_launch_container_help'] = 'Запуск приложения влияет на его отображение при запуске из курса. Некоторые запуски обеспечивают более реальное отображение состояния приложения, а другие обеспечивают большее объединение с интерфейсом Moodle.

* **По умолчанию** - используется вид запуска, указанный в настройках приложения.

* **Вставленное** - приложение отображается в существующем окне Moodle, подобно большинству другим активным элементам.

* **Вставленное, без блоков** - приложение отображается в существующем окне Moodle с управлением навигацией в верхней части страницы.

* **В новом окне** - приложение открывается в новом окне, занимая все свободное пространство. В зависимости от браузера, оно откроется в новой вкладке или новом окне. Вполне возможно, что браузер будет препятствовать открытию нового окна.';
$string['delegate'] = 'Делегировать преподавателю';
$string['delete'] = 'Удалить';
$string['delete_confirmation'] = 'Вы действительно хотите удалить настройки внешнего приложения?';
$string['deletetype'] = 'Удалить настройки внешнего приложения';
$string['display_description'] = 'Отображать описание активного элемента при запуске';
$string['display_description_help'] = 'При выбранном параметре описание активного элемента (указанное выше), будет отображаться над содержимым поставляемого приложения. Это описание может быть использовано для предоставления дополнительных инструкций при запуске приложения, но это не обязательно. Описание никогда не отображается при запуске приложения в новом окне.';
$string['display_name'] = 'Отображать название активного элемента при запуске';
$string['display_name_help'] = 'При выбранном параметре название активного элемента (указанное выше), будет отображаться над содержимым поставляемого приложения. Вполне возможно, что у поставляемого приложения тоже может отображаться название. Этот параметр может предотвратить повторное отображение названия активного элемента. Название никогда не отображается при запуске приложения в новом окне.';
$string['domain_mismatch'] = 'Домен запускающего URL-адреса  не соответствует настройкам приложения.';
$string['donot'] = 'Не отправлено';
$string['donotaccept'] = 'Не принято';
$string['donotallow'] = 'Не разрешено';
$string['edittype'] = 'Изменить настройки внешнего приложения';
$string['embed'] = 'Вставленное';
$string['embed_no_blocks'] = 'Вставленное, без блоков';
$string['enableemailnotification'] = 'Отправлять уведомления по электронной почте';
$string['enableemailnotification_help'] = 'При включенном параметре студенты будут получать уведомление по электронной почте при оценивании их работ.';
$string['errormisconfig'] = 'Приложение не настроено. Пожалуйста, обратитесь к администратору Moodle, чтобы исправить настройки приложения.';
$string['extensions'] = 'Расширения LTI';
$string['external_tool_type'] = 'Тип внешнего приложения';
$string['external_tool_type_help'] = 'Основной целью настроек приложения является создание безопасного канала связи между Moodle и поставляемым приложением. Также предоставляется возможность конфигурации по умолчанию и настройки дополнительных служб, предоставляемых с помощью приложения.

* **Автоматически, на основе запускающего URL-адреса** - этот параметр следует использовать почти во всех случаях. Moodle будет выбирать наиболее подходящие настройки приложения на основе запускающего URL-адреса. Приложение настраивается или администратором или в этом курсе при использовании. Когда указан запускающий URL-адрес, Moodle будет обеспечивать обратную связь независимо от того, признает он или нет запускающий URL-адрес. Если Moodle не признает запускающий URL-адрес, Вы можете вручную ввести настройки приложения.

* **Определенный тип приложения** - При выборе определенного типа приложения Вы можете заставить Moodle использовать эти настройки при общении с внешним поставляемым приложением. Если запускающий URL-адрес не принадлежит к поставляемому приложению, то отображается предупреждение. В некоторых случаях не нужно вводить запускающий URL-адрес при предоставлении определенного типа приложения (если не запускается конкретный ресурс в поставляемом приложении).

* **Пользовательские настройки** - при пользовательских настройках только для этого экземпляра приложения показаны дополнительные параметры, а также ввод абонентского ключа и общий секретный ключ. Если у Вас нет абонентского ключа или общего секретного ключа, то Вы можете запросить их из поставляемого приложения. Не все приложения требуют абонентский ключ и общий секретный ключ - в этом случае поля можно оставить пустыми.

 # # # Редактирование типа приложения

Вам доступны три значка рядом с выпадающим списком Тип внешнего приложения:

* **Добавить** - создать настройки приложения на уровне курса. Все внешние приложения в этом курсе могут использовать эти настройки.

* **Редактировать** - Выберите тип приложения уровня курса из выпадающего списка, а затем щелкните этот значок. Параметры настроек приложения могут быть изменены.

* **Удалить** - удаление выбранного типа приложения на уровне курса.';
$string['external_tool_types'] = 'Типы внешнего приложения';
$string['failedtoconnect'] = 'Moodle не может общаться с системой «{$a}»';
$string['filter_basiclti_configlink'] = 'Настройка предпочтительных сайтов и их паролей';
$string['filter_basiclti_password'] = 'Пароль обязателен';
$string['filterconfig'] = 'Управление LTI';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Использовать существующие настройки для не настроенных приложений.';
$string['fixnew'] = 'Новые настройки';
$string['fixnewconf'] = 'Определить новые настройки для не настроенных приложений.';
$string['fixold'] = 'Использовать существующие';
$string['forced_help'] = 'Эти настройки приложений являются принудительными в курсе или на уровне сайта. Вы не можете изменить их в этом интерфейсе.';
$string['force_ssl'] = 'Принудительно использовать SSL';
$string['force_ssl_help'] = 'Выбор этого параметра принуждает использовать SSL при всех запусках поставляемых приложений. Кроме того, все запросы веб-служб от поставщика приложений будут использовать SSL. При использовании этого параметра убедитесь, что этот сайт Moodle и поставщик приложений поддерживают SSL.';
$string['generaltool'] = 'Общий инструмент';
$string['global_tool_types'] = 'Типы глобальных приложений';
$string['grading'] = 'Передача оценки';
$string['icon_url'] = 'URL-адрес значка';
$string['icon_url_help'] = 'Этот параметр позволяет использовать значок, который отображается в перечне курса и может быть изменен для этого активного элемента. Вместо используемого по умолчанию значка внешнего приложения может быть задан значок, который отображает вид активного элемента.';
$string['id'] = 'Идентификатор';
$string['invalidid'] = 'Некорректный ID LTI';
$string['launch_in_moodle'] = 'Запускать приложение в Moodle';
$string['launchinpopup'] = 'Запуск приложения';
$string['launch_in_popup'] = 'Запускать приложение в всплывающем окне';
$string['launchinpopup_help'] = 'Вид запуска влияет на отображение приложения при запуске из курса. Некоторые виды запуска обеспечивают на экране более реальное состояние для приложения, а другие обеспечивают более комплексную интеграцию с окружением Moodle.

* **По умолчанию** - используется вид запуска, указанный в настройках приложения.

* **Вставленное** - приложение отображается в существующем окне Moodle, подобно большинству других типов активных элементов
.
* **Вставленное, без блоков** - приложение отображается в существующем окне Moodle с управлением навигацией в верхней части страницы.

* **В новом окне** - приложение открывается в новом окне, занимая все свободное пространство.
В зависимости от используемого браузера, оно откроется в новой вкладке или новом окне.
Вполне возможно, что браузер будет препятствовать открытию нового окна.';
$string['launchoptions'] = 'Варианты запуска';
$string['launch_url'] = 'Запускающий URL-адрес';
$string['launch_url_help'] = 'Запускающий URL указывает на веб-адрес внешнего приложения и может содержать дополнительные сведения об отображении ресурса. Если Вы не уверены в запускающем URL, то свяжитесь с поставщиком приложения для получения дополнительной информации. При выборе определенного типа приложения ввод запускающего URL не требуется. Если ссылка используется только для запуска приложения в системе поставщика, а не ведет к определенному ресурсу, то параметр, вероятно, может быть пустым.';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Добавлять конфигурации приложений конкретного курса';
$string['lti:addinstance'] = 'Добавлять элементы курса для внешних приложений';
$string['lti_administration'] = 'Управление LTI';
$string['lti_errormsg'] = 'Приложение вернуло следующее сообщение об ошибке: «{$a}»';
$string['lti:grade'] = 'Просматривать оценки, возвращенные внешним приложением';
$string['lti_launch_error'] = 'При запуске внешнего приложения произошла ошибка:';
$string['lti_launch_error_tool_request'] = '<p>Чтобы подать заявку администратору для завершения настройки приложения, <a href="{$a->admin_request_url}" target="_top">щелкните здесь</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p>Эта ошибка может быть следствием отсутствия абонентского ключа и общего ключа для поставляемого приложения. </p> <p> Если у Вас есть абонентский ключ и общий секретный ключ, то Вы можете ввести его при редактировании внешнего приложения (убедитесь, что дополнительные параметры отображаются). <br /> Кроме того, Вы можете <a href="{$a->course_tool_editor}">создать конфигурацию поставляемого приложения на уровне курса</a>. </p>';
$string['lti:manage'] = 'Быть преподавателем выпущенного приложения';
$string['lti:requesttooladd'] = 'Запрашивать инструменты для конфигурации сайта';
$string['lti_tool_request_added'] = 'Запрос на конфигурацию приложения отправлен. Возможно, Вам придется обратиться к администратору для завершения конфигурации приложения.';
$string['lti_tool_request_existing'] = 'Конфигурация приложения для  домена уже представлена.';
$string['lti:view'] = 'Выпускать внешнее приложение';
$string['main_admin'] = 'Общая справка';
$string['main_admin_help'] = 'Внешние приложения позволяют пользователям Moodle легко взаимодействовать с отдаленными принимаемыми учебными ресурсами. Через специальный протокол запуска, отдаленные приложения будут иметь доступ к некоторой общей информации о запускающем пользователе.
Например, название учреждения, идентификатор курса, идентификатор пользователя, имя пользователя или адрес электронной почты.

Виды приложений, перечисленные на этой странице, разделены на три категории:

* **Активные** - эти поставляемые приложения были одобрены и настроены администратором. Они могут быть использованы в любом курсе этого сайта Moodle. Если вводятся абонентский ключ и общий секретный ключ, то между сайтом Moodle и отдаленным приложением по защищенному каналу связи устанавливаются доверительные отношения.
* **Ожидаемые** - эти поставляемые приложения импортированы, но не были настроены администратором. Преподаватели могут использовать эти поставляемые приложения, если они знают абонентский ключ и общий секретный ключ или если ключи не требуются.
* **Отклоненные** - так помечаются те поставляемые приложения, которые администратор не намерен делать доступными для всего сайта Moodle. Преподаватели могут по-прежнему использовать эти поставляемые приложения, если они знают абонентский ключ и общий секретный ключ или если ключи не требуются.';
$string['miscellaneous'] = 'Разное';
$string['misconfiguredtools'] = 'Обнаружены не настроенные экземпляры приложения';
$string['missingparameterserror'] = 'Страница не настроена: «{$a}»';
$string['module_class_type'] = 'Тип модуля Moodle';
$string['modulename'] = 'Внешнее приложение';
$string['modulename_help'] = 'Активный модуль «Внешнее приложение» позволяет студентам взаимодействовать с обучающими ресурсами и активными элементами на других веб-сайтах. Например, внешнее приложение может обеспечить доступ к новому типу деятельности или учебным материалам.

Для создания элемента «Внешнее приложение» требуется приложение поставщика, которое поддерживает LTI (Learning Tools Interoperability - Взаимодействующие средства обучения) . Преподаватель может создать активный элемент внешнее приложение или использовать приложение, настроенное администратором сайта.

Активный элемент «Внешнее приложение» отличается от ресурсов «Гиперссылка» несколькими особенностями:

* Внешние приложения контекстные, то есть им доступна информация о запустившем приложение пользователе - такие как организация, курс, имя.
* Внешние приложения поддерживают чтение, обновление и удаление оценок, связанных с экземпляром приложения.
* Конфигурация внешних приложений создает доверительные отношения между Вашим сайтом и поставщиком приложения, что обеспечивает безопасную связь между ними.';
$string['modulenameplural'] = 'Внешние приложения';
$string['modulenamepluralformatted'] = 'Используемые LTI';
$string['never'] = 'Никогда';
$string['new_window'] = 'В новом окне';
$string['noattempts'] = 'Нет попыток с использованием этого приложения';
$string['no_lti_configured'] = 'Нет настроенных активных  внешних приложений.';
$string['no_lti_pending'] = 'Нет ожидаемых внешних приложений.';
$string['no_lti_rejected'] = 'Нет отклоненных внешних приложений.';
$string['noltis'] = 'Нет используемых внешних приложений';
$string['noservers'] = 'Сервер не найден';
$string['notypes'] = 'В настоящее время в Moodle не установлены приложения LTI. Чтобы добавить их, нажмите выше ссылку Установить.';
$string['noviewusers'] = 'Нет пользователей с правом использовать это приложение.';
$string['optionalsettings'] = 'Дополнительные настройки';
$string['organization'] = 'Подробности организации';
$string['organizationdescr'] = 'Описание организации';
$string['organizationid'] = 'Идентификатор организации';
$string['organizationid_help'] = 'Уникальный идентификатор этого сайта Moodle. Обычно используется доменное имя организации. Если это поле оставить пустым, то имя этого сайта Moodle будет использоваться как значение по умолчанию.';
$string['organizationurl'] = 'URL-адрес организации';
$string['organizationurl_help'] = 'Основной URL-адрес этого сайта Moodle. Если оставить это поле пустым, то по умолчанию будет использоваться значение конфигурации сайта.';
$string['pagesize'] = 'Представлений на странице';
$string['password'] = 'Общий секретный ключ';
$string['password_admin'] = 'Общий секретный ключ';
$string['password_admin_help'] = 'Общий секретный ключ можно рассматривать как пароль для доступа к приложению. Он должен быть предоставлен поставщиком приложения вместе с абонентским ключом. Приложения, которые не требуют безопасной связи с Moodle и не предоставляют дополнительные услуги (такие, как отчеты об оценках) могут не требовать общий ключ.';
$string['password_help'] = 'Для предварительно настроенных приложений не стоит вводить здесь общий секретный ключ. Он будет задан в процессе настройки. Это поле должно быть заполнено, если создается ссылка на поставляемое приложение, которое еще не настроено. Если поставляемое приложение будет использоваться более одного раза в этом курсе, то имеет смысл добавить в курс конфигурацию этого приложения. Общий ключ можно рассматривать как пароль для доступа к приложению. Он должен быть предоставлен поставщиком приложения вместе с абонентским ключом. Приложения, которые не требуют безопасной связи с Moodle и не предоставляют дополнительные услуги (такие, как отчеты об оценках) могут не требовать общий ключ.';
$string['pending'] = 'Ожидаемые';
$string['pluginadministration'] = 'Управление LTI';
$string['pluginname'] = 'LTI';
$string['preferheight'] = 'Предпочтительная высота';
$string['preferwidget'] = 'Предпочитаемый запуск';
$string['preferwidth'] = 'Предпочтительная ширина';
$string['press_to_submit'] = 'Нажмите, чтобы запустить этот элемент';
$string['privacy'] = 'Секретность';
$string['quickgrade'] = 'Разрешить быстрое оценивание';
$string['quickgrade_help'] = 'При включенном параметре несколько средств могут быть оценены на одной странице. Добавив оценки и комментарии, нажмите кнопку «Сохранить все мои отзывы» для сохранения всех изменений.';
$string['redirect'] = 'Вы будете перенаправлены через несколько секунд. Если этого не происходит, то нажмите кнопку..';
$string['reject'] = 'Отклонить';
$string['rejected'] = 'Отклоненные';
$string['resource'] = 'Ресурс';
$string['resourcekey'] = 'Абонентский ключ';
$string['resourcekey_admin'] = 'Абонентский ключ';
$string['resourcekey_admin_help'] = 'Абонентский ключ можно рассматривать в качестве имени пользователя, использующегося для аутентификации доступа к приложению.
Он может быть использован поставщиком приложения для однозначной идентификации сайта Moodle, с которого пользователь запускает приложение.

Абонентский ключ должен быть представлен поставщиком приложения. Способ получения абонентского ключа зависит от поставщика приложения. Это может быть автоматизированный процесс, или он может потребовать диалога с поставщиком приложения.

Приложения, которые не требуют безопасной связи с Moodle и не предоставляют дополнительные услуги (такие, как отчеты об оценках) могут не требовать ключ ресурса.';
$string['resourcekey_help'] = 'Для предварительно настроенных приложений не стоит вводить здесь ключ ресурса. Он будет задан в процессе настройки как абонентский ключ.

Это поле должно быть заполнено, если создается ссылка на поставляемое приложение, которое еще не настроено. Если поставляемое приложение будет использоваться более одного раза в этом курсе, то имеет смысл добавить в курс конфигурацию этого приложения.
Абонентский ключ можно рассматривать как имя пользователя, использующееся для аутентификации доступа к приложению.
Он может быть использован поставщиком приложения для однозначной идентификации сайта Moodle, с которого пользователь запускает приложение.

Абонентский ключ должен быть представлен поставщиком приложения. Способ получения абонентского ключа зависит от поставщика приложения. Это может быть автоматизированный процесс, или он может потребовать диалога с поставщиком приложения.

Приложения, которые не требуют безопасной связи с Moodle и не предоставляют дополнительные услуги (такие, как отчеты об оценках) могут не требовать ключ ресурса.';
$string['resourceurl'] = 'URL-адрес ресурса';
$string['return_to_course'] = 'Щелкните<a href="{$a->link}" target="_top">здесь</a> для возвращения в курс.';
$string['saveallfeedback'] = 'Сохранить все мои отзывы';
$string['secure_icon_url'] = 'Безопасный URL-адрес значка';
$string['secure_icon_url_help'] = 'Подобен URL-адресу значка, но используется в случае доступа пользователя к Moodle через защищенное соединение SSL. Основное предназначение этого адреса - предотвратить появление предупреждения браузера при запросе показа незащищенного изображения, когда базовая страница доступна через SSL.';
$string['secure_launch_url'] = 'Безопасный запускающий URL-адрес';
$string['secure_launch_url_help'] = 'Подобен запускающему URL-адресу, но используется вместо него при необходимости высокого уровня безопасности. Moodle будет использовать безопасный запускающий URL-адрес вместо запускающего URL-адреса, если сайт Moodle доступен через SSL или если в конфигурации приложения задано - всегда запускать через SSL.

Запускающий URL-адрес также может быть задан через адрес HTTPS для принудительного запуска через SSL, тогда это поле может быть пустым.';
$string['send'] = 'Отправить';
$string['setupoptions'] = 'Параметры настройки';
$string['share_email'] = 'Определять адрес электронной почты пользователя, запускающего приложение';
$string['share_email_admin'] = 'Определять адрес электронной почты пользователя, запускающего приложение';
$string['share_email_admin_help'] = 'Определять ли адрес электронной почты пользователя, запускающего приложение? Он будет использоваться поставщиком приложения. Поставщику приложения может понадобиться электронная почта запускающего адреса, чтобы различать пользователей с одинаковым именем, или отправить пользователю по электронной почте инструкцию по работе с этим приложением.';
$string['share_email_help'] = 'Определять ли адрес электронной почты пользователя, запускающего приложение? Он будет использоваться поставщиком приложения.Поставщику приложения может понадобиться электронная почта запускающего адреса, чтобы различать пользователей с одинаковым именем, или отправить пользователю по электронной почте инструкцию по работе с этим приложением.

Обратите внимание, что этот параметр может быть переопределен в конфигурации приложения.';
$string['share_name'] = 'Определять полное имя пользователя, запускающего приложение';
$string['share_name_admin'] = 'Определять полное имя пользователя, запускающего приложение';
$string['share_name_admin_help'] = 'Определять ли полное имя пользователя, запускающего приложение? Оно будет использоваться поставщиком приложения. Поставщику могут потребоваться имена запускающих приложение, чтобы отобразить в нём содержательную информацию.';
$string['share_name_help'] = 'Определять ли полное имя пользователя, запускающего приложение? Оно будет использоваться поставщиком приложения. Поставщику могут потребоваться имена запускающих приложение, чтобы отобразить в нём содержательную информацию.

Обратите внимание, что этот параметр может быть переопределен в конфигурации приложения.';
$string['share_roster'] = 'Разрешить приложению доступ к спискам участников курсов.';
$string['share_roster_admin'] = 'Приложение имеет доступ к спискам участников курсов.';
$string['share_roster_admin_help'] = 'Определите, будет ли это приложение иметь доступ к списку пользователей, записанных на курсы, из которых этот тип приложения может запускаться.';
$string['share_roster_help'] = 'Определите, будет ли это приложение иметь доступ к списку пользователей, записанных на курсы, из которых этот тип приложения может запускаться.

Обратите внимание, что этот параметр может быть переопределен в конфигурации приложения.';
$string['show_in_course'] = 'Отобразить тип приложения в списке приложений';
$string['show_in_course_help'] = 'Если параметр выбран, то конфигурация этого приложения появится в выпадающем меню «Тип внешнего приложения» когда преподаватели настраивают внешние приложения в курсах.

В большинстве случаев этот параметр не должен быть выбран. Преподаватели могут использовать конфигурацию этого приложения на основе запускающего URL-адреса соответствующему основному URL-адресу приложения, что является предпочтительным методом.

Единственный случай, когда этот параметр должен быть выбран - если приложение просто предназначено для единого входа в систему.
Например, если все запуски поставляемого приложения просто приводят пользователей на целевую страницу, а не к конкретному ресурсу.';
$string['size'] = 'Параметры размера';
$string['submission'] = 'Представление';
$string['submissions'] = 'Представления';
$string['subplugintype_ltisource'] = 'Источник LTI';
$string['subplugintype_ltisource_plural'] = 'Источники LTI';
$string['toggle_debug_data'] = 'Переключить данные отладки';
$string['tool_config_not_found'] = 'Конфигурация приложения не найдена по этому адресу';
$string['tool_settings'] = 'Настройки приложения';
$string['toolsetup'] = 'Конфигурация внешнего приложения';
$string['toolurl'] = 'Базовый URL-адрес приложения';
$string['toolurl_help'] = 'Базовый URL-адрес приложения используется для сопоставления запускающих URL-адресов к правильной конфигурации приложения. Задание префиксов http(s) не обязательно.

Кроме того, базовый URL-адрес используется как запускающий адрес, если запускающий URL-адрес не указан в примере внешнего приложения.

Например, базовому URL-адресу *tool.com* будут соответствовать следующие:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Базовому URL-адресу *www.tool.com/quizzes* будут соответствовать следующие:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Базовому URL-адресу *quiz.tool.com* будут соответствовать следующие:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Если две различные конфигурации приложения указаны для одного и того же домена, то будет использоваться самое определенное соответствие.';
$string['typename'] = 'Название приложения';
$string['typename_help'] = 'Название приложения используется для идентификации в Moodle поставляемого приложения. Введенное название будет видно преподавателям при добавлении внешних приложений в курсы.';
$string['types'] = 'Типы';
$string['update'] = 'Обновить';
$string['using_tool_configuration'] = 'Использовать конфигурацию приложения:';
$string['validurl'] = 'Правильный адрес должен начинаться с http(s)://';
$string['viewsubmissions'] = 'Экран просмотра представлений и оценок';
