<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'ru', branch 'MOODLE_24_STABLE'
 *
 * @package   local_amos
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '<p>AMOS предназначен для Автоматического Манипулирования Строками. AMOS - это центральный репозиторий строк Moodle и истории их изменения. AMOS отслеживает добавление английских строк в исходный код Moodle, собирает переводы, обслуживает типовые задачи управления переводом и генерирует языковые пакеты для развёртывания на серверах c Moodle.</p>
<p>Дополнительную информацию можно найти в <a href="http://docs.moodle.org/en/AMOS">английской документации по AMOS</a>.</p>';
$string['amos'] = 'AMOS - Инструмент для перевода Moodle';
$string['amos:commit'] = 'Фиксировать строки этапа перевода в основном репозитории.';
$string['amos:execute'] = 'Выполнять AMOScript';
$string['amos:importfile'] = 'Импортировать в этап переведенные строки из загружаемого файла';
$string['amos:importstrings'] = 'Импортировать строки (включая английский) непосредственно в основной репозиторий';
$string['amos:manage'] = 'Управлять порталом AMOS';
$string['amos:stage'] = 'Использовать инструмент перевода AMOS и собирать переведенные строки в виде этапа перевода.';
$string['amos:stash'] = 'Сохранять текущий этап перевода в постоянные копилки';
$string['amos:usegoogle'] = 'Использовать сервисы «Переводчика Google»';
$string['commitbutton'] = 'Зафиксировать и очистить этап';
$string['commitbutton2'] = 'Зафиксировать и оставить строки в этапе';
$string['commitmessage'] = 'Сообщение о фиксации';
$string['commitstage'] = 'Зафиксировать строки этапа';
$string['commitstage_help'] = 'Зафиксировать весь этап перевода в репозитории AMOS. Перед фиксацией этапа автоматически выполняются команды «Убрать нефиксируемые строки» и «Обновить». Сохраняются только строки, подлежащие фиксации. Это значит, что будут сохранены только те переводы, которые ниже отмечены зеленым. После фиксации, этап будет очищен.';
$string['committableall'] = 'все языки';
$string['committablenone'] = 'ни один язык не разрешен - свяжитесь с администратором AMOS';
$string['componentsall'] = 'Выбрать все';
$string['componentsenlarge'] = 'Расширить';
$string['componentsnone'] = 'Очистить выделение';
$string['componentsstandard'] = 'Выбрать стандартные';
$string['confirmaction'] = 'Это действие нельзя будет отменить? Вы уверены?';
$string['contribaccept'] = 'Принять';
$string['contribactions'] = 'Действия со вкладом в перевод';
$string['contribactions_help'] = 'В зависимости от Ваших прав и организации процесса приема вклада в перевод, Вам будут доступны некоторые из следующих действий:

* Применить - скопировать внесенный перевод в свой этап и не изменять рассматриваемую запись.
* Поручить мне - назначить самого себя в качестве ответственного за рассмотрение этого вклада и его интеграцию.
* Отказаться - освободить место ответственного за рассмотрение этого вклада.
* Начать рассмотрение - назначить себя ответственным, установить статус «На рассмотрении» и скопировать внесенный перевод в свой этап.
* Принять - отметить вклад как принятый.
* Отклонить - отметить вклад как отклоненный. Пожалуйста, укажите причины в комментарии.

Внесший вклад пользователь информируется по электронной почте при любых изменениях статуса вклада.';
$string['contribapply'] = 'Применить';
$string['contribassignee'] = 'Ответственный';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'Поручить мне';
$string['contribauthor'] = 'Автор';
$string['contribclosedno'] = 'Скрыть рассмотренный вклад';
$string['contribclosedyes'] = 'Показать рассмотренный вклад';
$string['contribcomponents'] = 'Компоненты';
$string['contribid'] = 'Идентификатор';
$string['contribincomingnone'] = 'Входящих предложений о вкладе нет';
$string['contribincomingsome'] = 'Входящие предложения о вкладе ({$a})';
$string['contriblanguage'] = 'Язык';
$string['contribreject'] = 'Отклонить';
$string['contribresign'] = 'Отказаться';
$string['contribstaged'] = 'Этап содержит вклад <a href="contrib.php?id={$a->id}">№{$a->id}</a> пользователя {$a->author}';
$string['contribstagedinfo'] = 'Этап содержит вклад';
$string['contribstagedinfo_help'] = 'Этап содержит строки, являющиеся присланным членом сообщества вкладом в перевод. Предполагается, что ответственный за языковой пакет просмотрит их, после чего установит соответствующий статус вклада: «Принят» (если строки были зафиксированы) или «Отклонен» (если по какой-то причине строки не могут быть включены в официальный языковой пакет).';
$string['contribstartreview'] = 'Начать рассмотрение';
$string['contribstatus'] = 'Статус';
$string['contribstatus0'] = 'Новый';
$string['contribstatus10'] = 'На рассмотрении';
$string['contribstatus20'] = 'Отклонен';
$string['contribstatus30'] = 'Принят';
$string['contribstatus_help'] = 'Процесс обработки внесенных переводов состоит из следующих этапов:

* Новый - вклад был представлен, но еще не был рассмотрен
* На рассмотрении - рассмотрение вклада было поручено ответственному за языковой пакет
* Отклонен - ответственный за языковой пакет отклонил вклад и, возможно, оставил объяснение в виде комментария
* Принят - вклад был принят ответственным за языковой пакет';
$string['contribstrings'] = 'Строки';
$string['contribstringseq'] = '{$a->orig} - новая(ые)';
$string['contribstringsnone'] = '{$a->orig} (все строки уже переведены в языковом пакете)';
$string['contribstringssome'] = '{$a->orig} ({$a->same} из них были переведены ранее)';
$string['contribsubject'] = 'Тема';
$string['contribsubmittednone'] = 'Нет представленных предложений о вкладе';
$string['contribsubmittedsome'] = 'Ваши предложения о вкладе ({$a})';
$string['contribtimemodified'] = 'Изменен';
$string['contributions'] = 'Вклады';
$string['creditscontact'] = 'Отправить сообщение';
$string['creditscontributors'] = 'Другие участники';
$string['creditsmaintainedby'] = 'Ответственные';
$string['creditsnomaintainer'] = 'Пока нет ответственных. <a href="{$a->url}">Станьте первым!</a>';
$string['creditsthanks'] = 'На этой странице мы хотели бы поблагодарить всех, кто внес свой вклад в перевод Moodle. Их работа сделала возможным распространение Moodle во всем мире.';
$string['creditstitlelong'] = 'Ответственные за языковые пакеты и участники';
$string['creditstitleshort'] = 'Участники';
$string['diff'] = 'Сравнить';
$string['diffaction'] = 'При обнаружении различий поместить в этап перевода';
$string['diffaction1'] = 'существующий перевод для каждой ветки';
$string['diffaction2'] = 'наиболее новый перевод в обе ветки';
$string['diffmode'] = 'Помещать строки в этап перевода, если';
$string['diffmode1'] = 'Изменилась английская строка, а переведенная еще не изменилась';
$string['diffmode2'] = 'Английская строка не изменялась, а переведенная изменилась';
$string['diffmode3'] = 'Изменилась или английская строка, или переведенная (но не обе одновременно)';
$string['diffmode4'] = 'Изменилась как английская строка, так и ее перевод.';
$string['diffprogress'] = 'Сравнение выбранных веток';
$string['diffprogressdone'] = 'Всего найдено различий: {$a}';
$string['diffstaged'] = 'разл.';
$string['diffstrings'] = 'Сравнение строк из двух веток';
$string['diffstrings_help'] = 'При этом действии будут сравнены все строки из двух выбранных веток. Если будет найдено различие между строками в разных ветках, обе версии строки будут помещены в этап перевода. Затем Вы сможете воспользоваться функцией «Редактировать строки этого этапа», чтобы просмотреть строки и сделать необходимые изменения.';
$string['diffversions'] = 'Версии';
$string['emailacceptbody'] = 'Ответственный за языковой пакет {$a->assignee} принял Ваш вклад в перевод №{$a->id} {$a->subject}.

Подробности можно узнать по ссылке {$a->url}.';
$string['emailacceptsubject'] = '[Вклад в AMOS] Принят';
$string['emailcontributionbody'] = 'Пользователь {$a->author} представил новый перевод №{$a->id} {$a->subject}.

Подробности можно узнать по ссылке {$a->url}.';
$string['emailcontributionsubject'] = '[Вклад в AMOS] Представлен новый перевод';
$string['emailrejectbody'] = 'Ответственный за языковой пакет {$a->assignee} отклонил Ваш вклад в перевод №{$a->id} {$a->subject}.

Подробности можно узнать по ссылке {$a->url}.';
$string['emailrejectsubject'] = '[Вклад в AMOS] Отклонён';
$string['emailreviewbody'] = 'Ответственный за языковой пакет {$a->assignee} начал рассмотрение Вашего вклада в перевод №{$a->id} {$a->subject}.

Подробности можно узнать по ссылке {$a->url}.';
$string['emailreviewsubject'] = '[Вклад в AMOS] Начато рассмотрение';
$string['err_exception'] = 'Ошибка: {$a}';
$string['err_invalidlangcode'] = 'Некорректный код языка';
$string['err_parser'] = 'Ошибка синтаксического анализа: {$a}';
$string['filtercmp'] = 'Компоненты';
$string['filtercmp_desc'] = 'Выводить строки, относящиеся к следующим компонентам';
$string['filtercmpnothingselected'] = 'Выберите один или несколько компонентов';
$string['filterlng'] = 'Языки';
$string['filterlng_desc'] = 'Выводить переводы на следующие языки';
$string['filterlngnothingselected'] = 'Выберите язык(и)';
$string['filtermis'] = 'Прочее';
$string['filtermis_desc'] = 'Дополнительные условия для отбора выводимых строк';
$string['filtermisfglo'] = 'только строки из «серого списка»';
$string['filtermisfhlp'] = 'только строки справки';
$string['filtermisfmis'] = 'только еще не переведенные и устаревшие строки';
$string['filtermisfstg'] = 'только строки этого этапа';
$string['filtermisfwog'] = 'без строк из «серого списка»';
$string['filtersid'] = 'Идентификатор строки';
$string['filtersid_desc'] = 'Индекс строки в массиве';
$string['filtersidpartial'] = 'совпадение с частью строки';
$string['filtertxt'] = 'Подстрока';
$string['filtertxtcasesensitive'] = 'с учетом регистра';
$string['filtertxt_desc'] = 'Строка должна содержать указанный текст';
$string['filtertxtregex'] = 'регулярное выражение';
$string['filterver'] = 'Версии';
$string['filterver_desc'] = 'Выводить строки из этих версий Moodle';
$string['filtervernothingselected'] = 'Выберите версию(и)';
$string['found'] = 'Найдено: {$a->found}     Не переведено: {$a->missing} (на этой странице: {$a->missingonpage})';
$string['foundinfo'] = 'Количество найденных строк';
$string['foundinfo_help'] = 'Выводит общее число строк в таблице перевода, число еще не переведенных строк и число еще не переведенных строк на текущей странице.';
$string['gotofirst'] = 'перейти на первую страницу';
$string['gotoprevious'] = 'перейти на предыдущую страницу';
$string['greylisted'] = 'Строки из «серого списка»';
$string['greylisted_help'] = 'На всякий случай, языковой пакет Moodle может содержать строки, которые больше не используются, но еще не были удалены. Эти строки занесены в «серый список». Как только будет подтверждено, что сроки из серого списка более не используются, они будут удалены из языкового пакета.

Если Вы обнаружили, что серый список попала строка, которая еще используется в Moodle, сообщите нам об этом в сообщении на форуме в курсе «Translating Moodle» на этом сайте. В противном случае, вы можете сэкономить драгоценное время, переводя строки, которые скорее всего используются и пропускать строки из серого списка.';
$string['greylistedwarning'] = 'строка из «серого списка»';
$string['importfile'] = 'Импортировать переведенные строки из файла';
$string['importfile_help'] = 'Если у Вас есть строки, переведенные оффлайн, Вы можете загрузить их в текущий этап с помощью этой формы.

* Файл должен быть корректным языковым PHP файлом Moodle. Примеры можно увидеть в каталоге «/lang/en/» Вашей установки Moodle.
* Имя файла должно соответствовать одной из английских строк, определяющих нужный компонент (например, «moodle.php», «assignment.php» или «enrol_manual.php»).

Все найденные в файле строки будут добавлены в этап перевода для выбранных версии и языка.

Несколько файлов PHP могут быть обработаны одновременно, если Вы поместите их в ZIP-файл.';
$string['language'] = 'Язык';
$string['languages'] = 'Языки';
$string['languagesall'] = 'Выбрать все';
$string['languagesnone'] = 'Очистить выделение';
$string['log'] = 'Журнал';
$string['logfilterbranch'] = 'Версии';
$string['logfiltercommithash'] = 'Хэш git';
$string['logfiltercommitmsg'] = 'Сообщение о фиксации содержит';
$string['logfiltercommits'] = 'Фильтр фиксаций';
$string['logfiltercommittedafter'] = 'Представленные после';
$string['logfiltercommittedbefore'] = 'Представленные до';
$string['logfiltercomponent'] = 'Компоненты';
$string['logfilterlang'] = 'Языки';
$string['logfiltershow'] = 'Вывести отфильтрованные фиксации и строки';
$string['logfiltersource'] = 'Источник';
$string['logfiltersourceamos'] = 'amos (переводчик с веб-интерфейсом)';
$string['logfiltersourceautomerge'] = 'automerge (перевод скопированный из другой ветви)';
$string['logfiltersourcebot'] = 'bot (операции по пакетной обработке, выполненные скриптом)';
$string['logfiltersourcecommitscript'] = 'commitscript (AMOScript в сообщениях о фиксациях)';
$string['logfiltersourcefixdrift'] = 'fixdrift (исправленный перенос между AMOS и git)';
$string['logfiltersourcegit'] = 'git (зеркало в git исходного кода Moodle и языковых пакетов для версий 1.x)';
$string['logfiltersourceimport'] = 'import (строки, импортированные из плагинов)';
$string['logfiltersourcerevclean'] = 'revclean (процесс обратной чистки)';
$string['logfilterstringid'] = 'Идентификатор строки';
$string['logfilterstrings'] = 'Фильтр строк';
$string['logfilterusergrp'] = 'Зафиксировавший';
$string['logfilterusergrpor'] = 'или';
$string['maintainers'] = 'Ответственные';
$string['markuptodate'] = 'Пометить перевод как актуальный';
$string['markuptodate_help'] = 'AMOS определил, что некоторые строки перевода могут устареть, так как после перевода произошли изменения в английской версии. Проверьте перевод. Если Вы сочтете его актуальным, поставьте соответствующую отметку, в противном случае отредактируйте.';
$string['merge'] = 'Объединить';
$string['mergestrings'] = 'Объединить со строками из другой ветки';
$string['mergestrings_help'] = 'При этом действии все строки из исходной ветви, которые еще не были переведены в конечной ветви, будут собраны в этап перевода. Вы можете использовать этот инструмент, чтобы скопировать переведенные строки во все версии языкового пакета. Этим инструментом может пользоваться только ответственный за языковой пакет.';
$string['newlanguage'] = 'Новый язык';
$string['nodiffs'] = 'Различий не найдено';
$string['nofiletoimport'] = 'Пожалуйста, укажите файл в форме импорта.';
$string['nologsfound'] = 'Ни одной строки не найдено. Пожалуйста, измените настройки фильтра.';
$string['nostringsfound'] = 'Ни одной строки не найдено.';
$string['nostringsfoundonpage'] = 'На странице {$a} не найдено ни одной строки.';
$string['nostringtoimport'] = 'В файле не найдено корректных строк. Убедитесь в корректности имени файла и в том, что он правильно отформатирован.';
$string['nothingtomerge'] = 'В исходной ветви нет новых строк, отсутствующих в конечной ветви. Объединять нечего.';
$string['nothingtostage'] = 'В результате операции не найдено сток, которые можно было бы поместить в этап перевода.';
$string['novalidzip'] = 'Не удается извлечь архив.';
$string['numofcommitsabovelimit'] = 'Найдено {$a->found} фиксаций, соответствующих фильтру, используются {$a->limit} наиболее свежих.';
$string['numofcommitsunderlimit'] = 'Найдено {$a->found} фиксаций, соответствующих фильтру';
$string['numofmatchingstrings'] = 'Фильтру строк соответствуют {$a->strings} изменения(ий) строк в {$a->commits} фиксации(ях).';
$string['outdatednotcommitted'] = 'Устаревшая строка';
$string['outdatednotcommitted_help'] = 'AMOS определил, что строка может устареть, так как после перевода произошли изменения в английской версии. Проверьте перевод.';
$string['outdatednotcommittedwarning'] = 'устарела';
$string['ownstashactions'] = 'Действия с копилкой';
$string['ownstashactions_help'] = '* Применить - скопировать переведенные строки из копилки в текущий этап и не изменять копилку. Если строка уже присутствует в текущем этапе, она будет перезаписана строкой из копилки.
* Вытряхнуть - переместить переведенные строки из копилки в текущий этап и опустошить копилку. (То есть Применить и Выбросить).
* Выбросить - выбросить все накопленные строки.
* Представить на рассмотрение - открывает форму для отправки копилки на рассмотрение официальным ответственным за языковой пакет, чтобы они могли внести Ваш вклад в официальный языковой пакет.';
$string['ownstashes'] = 'Ваши копилки';
$string['ownstashes_help'] = 'Это список всех Ваших копилок.';
$string['ownstashesnone'] = 'У Вас не найдено копилок';
$string['permalink'] = 'постоянная ссылка';
$string['placeholder'] = 'Подстановки';
$string['placeholder_help'] = 'Подстановки - это специальные выражения вида «{$a}» или «{$a->something}» в строке. Когда строка выводится они заменяются конкретными значениями.

Очень важно сохранять их в переводе в точно таком же виде, как в исходной строке. Не переводите их и не меняйте направление текста в них.';
$string['placeholderwarning'] = 'строка содержит подстановку';
$string['pluginclasscore'] = 'Подсистемы ядра';
$string['pluginclassnonstandard'] = 'Нестандартные плагины';
$string['pluginclassstandard'] = 'Стандартные плагины';
$string['pluginname'] = 'AMOS';
$string['presetcommitmessage'] = '{$a->author} - вклад в перевод №{$a->id}';
$string['presetcommitmessage2'] = 'В ветку {$a->target} добавлены недостающие строки из ветки {$a->source}';
$string['presetcommitmessage3'] = 'Исправление различий между {$a->versiona} и {$a->versionb}';
$string['privileges'] = 'Ваши привилегии';
$string['privilegesnone'] = 'Вы не можете редактировать публичную информацию.';
$string['propagate'] = 'Распространение перевода на другие ветки';
$string['propagatednone'] = 'В результате распространения перевода над другие ветки не добавлено ни одной строки';
$string['propagatedsome'] = 'В результате распространения перевода на другие ветки добавлено {$a} строк(и)';
$string['propagate_help'] = 'Можно распространить перевод строк этого этапа перевода на другие ветки. В этом случае AMOS будет просматривать все строки этого этапа и пробовать копировать их во все указанные ветки перевода. При этом строки не будет скопированы в следующих случаях:

* Английские версии строк различаются в исходной и конечной ветках
* строка присутствует в этапе перевода несколько раз с различным переводом';
$string['propagaterun'] = 'Скопировать';
$string['requestactions'] = 'Действие';
$string['requestactions_help'] = '* Применить - скопировать переведенный строки из запроса на добавление в Вашу этап. Если строка уже есть в текущем этапе, она будет заменена строкой из копилки.
* Скрыть - заблокировать запрос на добавление, чтобы он больше не отображался.';
$string['savefilter'] = 'Сохранить настройки фильтра';
$string['script'] = 'AMOScript';
$string['scriptexecute'] = 'Выполнить и поместить результат в этап перевода';
$string['script_help'] = 'AMOScript - это набор команд для управления репозиторием AMOS.';
$string['sourceversion'] = 'Исходная версия';
$string['stage'] = 'Этап';
$string['stageactions'] = 'Действия над этапом';
$string['stageactions_help'] = '* Редактировать строки этого этапа - устанавливает настройки фильтра перевода так, чтобы отображались только строки текущего этапа.
* Убрать нефиксируемые строки - из этапа убираются все строки, которые не разрешено фиксировать. Это действие автоматически выполняется перед фиксацией.
* Обновить - из этапа удаляются все переводы, которые или не изменяют текущий перевод, или старше, чем наиболее свежие переводы в репозитории. Это действие автоматически выполняется перед фиксацией.
* Очистить этап - этап очищается, при этом все сделанные переводы пропадают.';
$string['stageedit'] = 'Редактировать строки этого этапа';
$string['stagelang'] = 'Язык';
$string['stageoriginal'] = 'Исходное значение';
$string['stageprune'] = 'Убрать нефиксируемые строки';
$string['stagerebase'] = 'Обновить';
$string['stagestring'] = 'Строка';
$string['stagestringsnocommit'] = 'Строк в этапе: {$a->staged}';
$string['stagestringsnone'] = 'В этапе нет ни одной строки';
$string['stagestringssome'] = 'Строк в этапе: {$a->staged}. Из них может быть зафиксировано: {$a->committable}.';
$string['stagesubmit'] = 'Направить ответственным';
$string['stagetranslation'] = 'Перевод';
$string['stagetranslation_help'] = 'Отображаются строки перевода этого этапа, предназначенные для фиксации. Цвет фона ячейки обозначает следующее:

* Зеленый - Вы добавили недостающий перевод строки и Вам разрешено зафиксировать перевод.
* Желтый - Вы изменили строку перевода и Вам разрешено зафиксировать перевод.
* Голубой -  Вы изменили строки перевода или добавили недостающие, но Вам не разрешено зафиксировать перевод для данного языка.
* Бесцветный - перевод в этом этапе совпадает с текущим переводом, поэтому его не нужно фиксировать.';
$string['stageunstageall'] = 'Очистить этап';
$string['stashactions'] = 'Действия с копилкой';
$string['stashactions_help'] = 'Копилка - это снимок текущего этапа перевода. Копилки могут быть направлены официальным ответственным за языковой пакет для включения в языковой пакет.';
$string['stashapply'] = 'Применить';
$string['stashautosave'] = 'Копилка с автоматически сохраненной резервной копией';
$string['stashautosave_help'] = 'Эта копилка содержит наиболее свежий снимок Вашего этапа. Ее можно использовать, например, как резервную копию, в том случае, когда все строки были случайно очищены.
Используйте команду «Применить», чтобы скопировать все строки из копилки обратно в этап (при этом соответствующие строки этого этапа будут заменены).';
$string['stashcomponents'] = '<span>Компоненты:</span> {$a}';
$string['stashdrop'] = 'Выбросить';
$string['stashes'] = 'Копилки';
$string['stashlanguages'] = '<span>Языки:</span> {$a}';
$string['stashpop'] = 'Вытряхнуть';
$string['stashpush'] = 'Сложить все строки этого этапа в новую копилку';
$string['stashstrings'] = '<span>Число строк:</span> {$a}';
$string['stashsubmit'] = 'Направить ответственным';
$string['stashsubmitdetails'] = 'Подробности вклада';
$string['stashsubmitmessage'] = 'Сообщение';
$string['stashsubmitsubject'] = 'Тема';
$string['stashtitle'] = 'Название копилки';
$string['stashtitledefault'] = 'Идёт работа - {$a->time}';
$string['stringhistory'] = 'История';
$string['strings'] = 'Строки';
$string['submitting'] = 'Отправка вклада на рассмотрение';
$string['submitting_help'] = 'Это действие приведет к отправке строк официальным ответственным за языковой пакет. У ответственных будет возможность добавить результаты Вашего труда к своему этапу перевода, рассмотреть их и, в конце концов, зафиксировать изменения. Пожалуйста, расскажите в сообщении для них о своей работе и о том, почему же Вы хотите, чтобы ваш вклад был учтен.';
$string['targetversion'] = 'Конечная версия';
$string['translatorlang'] = 'Язык';
$string['translatorlang_help'] = 'Выводится код языка, на который нужно перевести строку. Чтобы просмотреть историю изменений строки, нажмите <strong>+-</strong>.';
$string['translatororiginal'] = 'Исходное значение';
$string['translatororiginal_help'] = 'Выводится исходная английская строка текста. Под ней находится ссылка для автоматического перевода с помощью «Переводчика Google» (если этот язык поддерживается и в браузере включен Javascript). Также выводится некоторая дополнительная информация, например о том, содержит ли строка подстановки.';
$string['translatorstring'] = 'Строка';
$string['translatorstring_help'] = 'Выводится ветвь (версию) Moodle, идентификатор строки и компонент, к которому относится эта строка.';
$string['translatortool'] = 'Переводчик';
$string['translatortranslation'] = 'Перевод';
$string['translatortranslation_help'] = 'Щелкните на ячейке, чтобы превратить ее в поле для редактирования. Введите перевод и щелкните вне ячейки, чтобы добавить перевод в текущий этап.
Цвет фона ячейки обозначает следующее:

* Зеленый - строка уже переведена и Вам разрешено изменить перевод.
* Желтый - Возможно, что строка устарела. Английская версия строки могла измениться после перевода.
* Красный - Строка не переведена.
* Голубой - Вы изменили перевод и он сохранен в текущем этапе.
* Серый - эту строку нельзя перевести с помощью AMOS. Например, строки для Moodle 1.9 можно редактировать только устаревшим способом, работая напрямую с CVS.

У ответственных за перевод отображается красная отметка в правом верхнем углу тех ячеек, которые им разрешено зафиксировать.';
$string['typecontrib'] = 'Нестандартные плагины';
$string['typecore'] = 'Подсистемы ядра';
$string['typestandard'] = 'Стандартные плагины';
$string['unableenfixaddon'] = 'Исправления английских строк разрешены только для стандартных плагинов';
$string['unableenfixcountries'] = 'Названия стран скопированы из ISO 3166-1';
$string['unstage'] = 'Убрать из этапа';
$string['unstageconfirm'] = 'Вы уверены?';
$string['unstaging'] = 'Удаление из этапа';
$string['version'] = 'Версия';
