<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'fi', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Pääsy kielletty';
$string['accounts'] = 'Käyttäjätilit';
$string['addcategory'] = 'Lisää kategoria';
$string['additionalhtml'] = 'Lisä-HTML';
$string['additionalhtml_desc'] = 'Nämä asetukset mahdollistavat HTML:n lisäämisen jokaiselle sivulle. Voit lisätä HTML:ää, joka tulee HEAD-tagin sisään, heti BODY:n alkuun tai sen loppuun.<br />Tämä mahdollistaa omien headerien tai footereiden lisäämisen jokaiselle sivulle, tai esimerkiksi Google Analyticsin tai vastaavien palveluiden käyttöönottamisen.';
$string['additionalhtmlfooter'] = 'Ennen BODY:n sulkemista';
$string['additionalhtmlfooter_desc'] = 'Tämä sisältö lisätään joka sivulle juuri ennen BODY-tagin sulkemista.';
$string['additionalhtmlhead'] = 'HEAD:issa';
$string['additionalhtmlhead_desc'] = 'Tämä sisältö lisätään joka sivulle HEAD-tagin loppuun.';
$string['additionalhtml_heading'] = 'Lisä-HTML, joka lisätään jokaiselle sivulle.';
$string['additionalhtmltopofbody'] = 'Kun BODY-tagi avataan';
$string['additionalhtmltopofbody_desc'] = 'Tämä sisältö lisätään joka sivulle heti BODY-tagin avaamisen jälkeen.';
$string['admincategory'] = 'Kategoria: {$a}';
$string['adminseesall'] = 'Ylläpitäjät näkevät kaiken';
$string['adminseesallevents'] = 'Ylläpitäjät näkevät kaikki tapahtumat';
$string['adminseesownevents'] = 'Ylläpitäjät ovat tavallisia käyttäjiä';
$string['advancedfeatures'] = 'Lisäasetukset';
$string['allcountrycodes'] = 'Kaikki maakoodit';
$string['allowbeforeblock'] = 'Sallittujen lista käsitellään ensin';
$string['allowbeforeblockdesc'] = 'Oletuksena estetyt IP-osoitteet tarkistetaan ensin. Jos tämä asetus on käytössä, sallitut IP-osoitteet tarkistetaan ennen estettyjä osoitteita.';
$string['allowblockstodock'] = 'Salli lohkojen käyttää telakkaa';
$string['allowcategorythemes'] = 'Salli kategorioiden teemat';
$string['allowcoursethemes'] = 'Salli kurssien teemat';
$string['allowediplist'] = 'Sallittujen IP:iden lista';
$string['allowemailaddresses'] = 'Sallitut email-toimialueet';
$string['allowframembedding'] = 'Salli kehyksen upottaminen';
$string['allowframembedding_help'] = 'Sallii tämän sivuston upottamisen erilliseen kehykseen ulkoisilla sivustoilla. Tämän toiminnon ottaminen käyttöön ei ole suositeltavaa tietoturvasyistä.';
$string['allowguestmymoodle'] = 'Salli vieraiden pääsy kotinäkymään';
$string['allowobjectembed'] = 'Salli EMBED- ja OBJECT-merkinnät';
$string['allowthemechangeonurl'] = 'Salli teemanvaihdos URL:ssa';
$string['allowuserblockhiding'] = 'Salli käyttäjien piilottaa lohkoja';
$string['allowuserswitchrolestheycantassign'] = 'Salli käyttäjien, joilla ei ole roolien nimeämisoikeuksia, vaihtaa omaa rooliaan';
$string['allowuserthemes'] = 'Salli käyttäjien teemat';
$string['antivirus'] = 'Antivirus';
$string['appearance'] = 'Ulkoasu';
$string['aspellpath'] = 'Polku aspell-ohjelmaan';
$string['authentication'] = 'Käyttäjäntunnistus';
$string['authpreventaccountcreation'] = 'Estä tunnuksen luonti autentikoitaessa';
$string['authpreventaccountcreation_help'] = 'Käyttäjän tunnustautuessa hänelle luodaan automaattisesti käyttäjätunnus jos sitä ei jo ole olemassa. Jos ulkoista käyttäjän tunnistautumistietokantaa käytetään (esim. LDAP) tunnistautumisessa ja haluat sallia pääsyn vain niille käyttäjille, joilla on olemassa oleva tunnus niin tämä asetus tulee olla valittuna. Tällöin uudet käyttäjätunnukset tulee luoda käsin tai käyttämällä lataa käyttäjälista- toimintoa. Huomaa, että tämä asetus ei koske MNet-tunnistautumista.';
$string['authsettings'] = 'Käyttäjäntunnistuksen hallinta';
$string['autolang'] = 'Kielen automaattitunnistus';
$string['autologinguests'] = 'Vieraiden automaattikirjaus';
$string['availablelicenses'] = 'Saatavilla olevat lisenssit';
$string['availableto'] = 'Saatavilla';
$string['backgroundcolour'] = 'Läpikuultava väri';
$string['backups'] = 'Varmuuskopiot';
$string['backup_shortname'] = 'Käytä kurssin nimeä varmuuskopiotiedoston nimenä';
$string['backup_shortnamehelp'] = 'Käytä kurssin nimeä varmuuskopiotiedoston nimen osana.';
$string['badwordsconfig'] = 'Kirjoita kiellettyjen sanojen lista pilkuin erotettuna.';
$string['badwordsdefault'] = 'Jos oma kiellettyjen sanojen lista on tyhjä, käytetään kielipaketissa olevaa oletussanalistaa.';
$string['badwordslist'] = 'Oma kiellettyjen sanojen lista';
$string['blockediplist'] = 'Kiellettyjen IP:iden lista';
$string['blockinstances'] = 'Ilmentymät';
$string['blockmultiple'] = 'Monenkertainen';
$string['blockprotect'] = 'Suojaa lohkot';
$string['blockprotect_help'] = 'Jos lukitset tietyntyyppisen lohkon, siihen ei voi lisätä eikä siitä voi poistaa instansseja. Voit tietysti avata lukituksen, jos instanssia tarvitsee muokata.

Lukituksella suojataan lohkoja, kuten Navigointi ja Asetukset, joita on vaikea palauttaa, jos ne vahingossa poistaa.';
$string['blocksettings'] = 'Lohkojen hallinta';
$string['blockunprotect'] = 'Poista suojaus';
$string['bloglevel'] = 'Blogin näkyvyys';
$string['bookmarkadded'] = 'Suosikki lisätty.';
$string['bookmarkalreadyexists'] = 'Olet jo merkinnyt tämän sivun suosikkeihin';
$string['bookmarkdeleted'] = 'Suosikki poistettu';
$string['bookmarkthispage'] = 'Lisää sivu suosikkeihin';
$string['cachejs'] = 'Javascript välimuistiin';
$string['cachejs_help'] = 'Javascriptin ajaminen välimuistiin ja sen pakkaaminen lisää sivujen latautumisnopeutta. Tätä suositellaan vahvasti tuotantokäytössä oleville sivustoille. Kehittäjät haluavat luultavasti poistaa tämän ominaisuuden käytöstä.';
$string['cachetext'] = 'Tekstivälimuistin kesto';
$string['calendarexportsalt'] = 'Kalenterin viennin suolaus';
$string['calendarsettings'] = 'Kalenteri';
$string['calendar_weekend'] = 'Viikonlopun päivät';
$string['cannotdeletemodfilter'] = 'Et voi perua asennusta \'{$a->filter}\' koska se on osa \'{$a->module}\' moduulia.';
$string['cfgwwwrootslashwarning'] = 'Olet määritellyt väärin www-juuren config.php tiedostoon. Sinulla on väärä merkki lopussa. Korjaa se tai saatat saada virheitä.';
$string['cfgwwwrootwarning'] = 'Olet määritellyt väärin www-juuren config.php tiedostoon. Se ei vastaa URL:iin, jolla yrität päästä tälle sivulle. Korjaa se tai saatat saada virheitä.';
$string['change'] = 'muutos';
$string['checkboxno'] = 'Ei';
$string['checkboxyes'] = 'Kyllä';
$string['choosefiletoedit'] = 'Valitse muokattava tiedosto';
$string['clamfailureonupload'] = 'Clam AV -virheen sattuessa';
$string['cleanup'] = 'Puhdista';
$string['clianswerno'] = 'e';
$string['cliansweryes'] = 'k';
$string['cliincorrectvalueerror'] = 'Virhe, epäkelpo arvo "{$a->value}" "{$a->option}":ssa';
$string['cliincorrectvalueretry'] = 'Epäkelpo arvo, syötä uudelleen';
$string['clistatusdisabled'] = 'Status: pois käytöstä';
$string['clistatusenabled'] = 'Status: käytössä';
$string['clitypevalue'] = 'syötä arvo';
$string['clitypevaluedefault'] = 'syötä arvo, paina Enteriä käyttääksesi oletusarvoa ({$a})';
$string['cliunknowoption'] = 'Tunnistamaton valinta: {$a} Ole hyvä ja käytä --help -valintaa.';
$string['cliupgradefinished'] = 'Komentorivin päivitys tehty onnistuneesti.';
$string['cliupgradenoneed'] = 'Ei tarvetta päivittää asennettua versiota {$a}.';
$string['cliyesnoprompt'] = 'syötä y (kyllä) tai n (ei)';
$string['commentsperpage'] = 'Näytettäviä kommentteja per sivu';
$string['commonfiltersettings'] = 'Yleiset suodatinasetukset';
$string['commonsettings'] = 'Yleiset asetukset';
$string['componentinstalled'] = 'Komponentti asennettu';
$string['computedfromlogs'] = 'Laskettu lokeista';
$string['condifmodeditdefaults'] = 'Tässä määrittelemiäsi arvoja käytetään oletusarvoina aktiviteettien asetuksissa kun luot uutta aktiviteettia. Voit myös määritellä mitkä aktiviteettiasetukset ovat lisäasetuksia.';
$string['confeditorhidebuttons'] = 'Valitse napit, jotka pitäisivät piilottaa HTML:editorissa.';
$string['configallcountrycodes'] = 'Tämö on lista maista joista voi valita eri sivuilla, esimerkiksi profiilisivulla. Jos tyhjä (oletusasetus) niin käytetään listaa tiedostossa countries.php englannin kielipaketista. Kyseessä on standardin ISO 3166-1 mukainen lista. Muussa tapauksessa voit määritellä pilkulla erotellun listan maakoodeista, esimerkiksi \'GB,FI,SV\'. Jos lisäät uusia jotka eivät ole standardin mukaisia maakoodeja, sinun pitää lisätä ne myös countries.php -tiedostoon \'en\' -kielipaketissa sekä käyttämässäsi kielipaketissa.';
$string['configallowassign'] = 'Salli käyttäjien, joilla on vasemmassa reunassa listatut roolit, jakaa sarakkeessa mainittuja rooleja muille käyttäjille';
$string['configallowblockstodock'] = 'Jos käytössä ja valitun teeman tukema, käyttäjät voivat siirtää lohkoja erityiseen telakointipalkkiin.';
$string['configallowcategorythemes'] = 'Salli kategoriakohtaiset teemat. Tämä saattaa vaikuttaa sivuston suorituskykyyn.';
$string['configallowcoursethemes'] = 'Tämä asetus sallii kurssien käyttää omia teemojaan.';
$string['configallowemailaddresses'] = 'Jos haluat rajoittaa uudet sallitut sähköpostiosoitteet tiettyihin toimialueisiin, listaa ne välilyönnein erotettuna. Kaikki muut toimialueet hylätään. Salli aliverkot liittämällä verkko-osoitteen eteen piste (.). Esim: <strong>meidan.koulu.fi joku.muu.com .fi .org</strong>';
$string['configallowobjectembed'] = 'Turvallisuuden tähden eivät tavalliset käyttäjät oletusarvoisesti saa sisällyttää HTML-teksteihinsä multimediaa (kuten Flash-animaatioita) käyttämällä  EMBED- ja OBJECT-merkintöjä (vaikka näin voidaan tehdä turvallisesti, jos käytetään medialaajennus-suodatinta). Laita tämä asetus päälle, jos haluat sallia näiden merkintöjen käytön.';
$string['configallowoverride'] = 'Salli vasemmalla listattujen roolien ohittaa roolit kussakin sarakkeessa';
$string['configallowoverride2'] = 'Valitse mitkä roolit voidaan kumota vasemmalla palstalla olevilla rooleilla. Huomaa että nämä asetukset soveltuvat vain käyttäjille, joilla ovat joko roolien ohitus tai turvaohitus sallittu.';
$string['configallowswitch'] = 'Valitse roolit johon käyttäjät voivat vaihtaa, perustuen siihen mitä rooleja heillä jo on. Sen lisäksi että se on määritelty tähän taulukkoon, käyttäjällä pitää olla moodle/role:switchroles -kyky voidakseen vaihtaa roolia.<br />Huomaa että on mahdollista ainoastaan vaihtaa rooliin joilla on moodle/course:view -kyky, ja joilla ei ole moodle/site:doanything -kykyä, joten jotkin tämän taulukon sarakkeista on pois käytöstä.';
$string['configallowthemechangeonurl'] = 'Jos asetus on käytössä voidaan teemaa muuttaa lisäämällä joko:<br/>?theme=themename mihin tahansa Moodle-osoitteeseen (esim.: mymoodlesite.com/?theme=afterburner ) tai <br />&theme=themename mihin tahansa Moodlen sisäiseen osoitteeseen (esim.: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Voivatko käyttäjät piilottaa lohkoja?';
$string['configallowuserthemes'] = 'Voivatko käyttäjät valita omia teemojaan?';
$string['configallusersaresitestudents'] = 'Pitäisikö KAIKKIA käyttäjiä käsitellä etusivun toiminnoissa opiskelijoina? Jos vastaat "Kyllä" kaikki hyväksytyn käyttäjätilin luoneet käyttäjät voivat osallistua näihin toimintoihin oppilaina. Jos vastaat "Ei", niin tällöin vain käyttäjät jotka ovat jo osanottajana vähintään yhdellä kurssilla voivat osallistua etusivun toimintoihin. Vain ylläpitäjät ja erityisesti määrätyt opettajat voivat toimia opettajina etusivun toiminnoissa.';
$string['configauthenticationplugins'] = 'Valitse ja järjestä ne käyttäjäntunnistuksen lisäosat joita haluat käyttää. Itserekisteröinnin hoitaa lisäosa joka on valittu "Rekisteröinti" sarakkeeseen.';
$string['configautolang'] = 'Tunnista kieli selaimen asetuksista, jos asetus ei ole käytössä käytetään sivuston oletuskieltä.';
$string['configautologinguests'] = 'Pitäisikö vierailijat kirjata automaattisesti sisään vierailija-tunnuksilla, kun he menevät kurssille, joka sallii vieraiden osallistua?';
$string['configbloglevel'] = 'Nämä asetukset sallivat sinun rajoittaa tasoa, miten käyttäjien blogeja voidaan katsella tällä sivustolla. Huomaa, että ne määrittelevät KATSOJAN enimmäiskontekstin, eivät blogin tyyppiä tai merkintöjen tyyppiä. Blogit voidaan myös passivoida täydellisesti, jos niille ei ole käyttöä lainkaan.';
$string['configcachetext'] = 'Tämän asetuksen käyttö voi nopeuttaa toimintaa huomattavasti laajemmilla sivustoilla sekä sivustoilla, jotka käyttävät tekstisuotimia. Teksteistä säilytetään kopio käsitellyssä muodossa tässä määritellyn ajan. Tämän asetuksen asettaminen liian pieneksi voi itseasiassa hidastaa sivuston toimintaa hieman, mutta liian suuri arvo voi tehdä tekstien päivittämisen hitaaksi (esimerkiksi uusien linkkien kanssa).';
$string['configcalendarexportsalt'] = 'Tätä satunnaista tekstiä käytetään tietoturvan parantamiseen kalenteriin vientiin tarkoituetuilla todennetuilla avaimilla. Huomaa että kaikki nykyiset avaimet muuttuvat epävalideiksi jos muutat tätä tarkistetta.';
$string['configclamactlikevirus'] = 'Käsittele tiedostoja viruksina';
$string['configclamdonothing'] = 'Käsittele tiedostoja viruksettomina';
$string['configclamfailureonupload'] = 'Mitä clamin pitäisi tehdä, jos olet asettanut sen tarkastamaan palvelimelle kopioidut tiedostot, mutta jos clamin asetukset ovat virheelliset tai se ei jostain syystä käynnistykään? Jos valitset ´Käsittele tiedostoja viruksina´, tiedostot siirretään karanteenialueelle tai tuhotaan. Jos valitset ´Käsittele tiedostoja viruksettomina´, tiedostot siirretään normaalisti kohdehakemistoonsa. Kummassakin tapauksessa ylläpitäjille ilmoitetaan, jos clam ei ole toiminnassa. Jos valitset ´Käsittele tiedostoja viruksina´ ja jostain syystä clam ei käynnistykään (johtuen yleensä väärin määritellystä polusta clam-ohjelmaan) KAIKKI tiedostot, jotka kopioidaan palvelimelle, siirretään karanteenialueelle tai tuhotaan. Ole varovainen käyttäessäsi tätä asetusta.';
$string['configconvertformat'] = 'Jos <i>latex</i>, <i>dvips</i> ja <i>convert</i> ovat saatavilla, kuvat luodaan käyttäen määriteltyä formaattia. Jos ei, käytetään mimeTeX:iä joka luo GIF kuvia.';
$string['configcookiehttponly'] = 'Mahdollistaa uusi PHP 5.2.0 ominaisuus - selaimet ovat ohjattu lähettämään eväste oikeiden http-pyyntöjen mukana. Evästeiden ei pitäisi olla skripti-kielien saavutettavissa. Tätä ei ole tuettu kaikissa selaimissa ja se ei välttämättä sovellu yhteen nykyisen koodin kanssa. Se auttaa ehkäisemään joitakin XSS-hyökkäyksiä.';
$string['configcountry'] = 'Jos asetat oletusmaan tähän, niin tämä asetus tulee voimaan kaikille luoduille uusille käyttäjätileille. Jos haluat käyttäjien valitsevan itse maan, jätä vain tämä kohta tyhjäksi.';
$string['configcourserequestnotify'] = 'Kirjoita sen käyttäjän käyttäjätunnus, jolle ilmoitetaan kurssipyynnöistä.';
$string['configcourserequestnotify2'] = 'Käyttäjät, joille ilmoitetaan kurssipyynnöistä. Listalla näkyvät vain käyttäjät, jotka voivat hyväksyä kurssipyyntöjä.';
$string['configcoursesperpage'] = 'Kurssien lukumäärä sivua kohden kurssilistassa';
$string['configcronclionly'] = 'Jos tämä on päällä, cron skripti voidaan ajaa ainoastaan komentoriviltä, eikä verkon kautta. Tämä ohittaa alla olevan cron salasana-asetuksen.';
$string['configcronremotepassword'] = 'Tämä tarkoittaa sitä, että cron.php skriptiä ei voida ajaa selaimesta ilman että salasana syötetään seuraavanlaista URL:ia: <pre>
http://site.example.com/admin/cron.php?password=opensesame
</pre>Jos tämä on jätetty tyhjäksi, salasanaa ei tarvita.';
$string['configcurlcache'] = 'Time-to-live cURL-välimuistille sekunteina.';
$string['configdbsessions'] = 'Jos tämä asetus on päällä, avoimista istunnoista tallennetaan tietoja tietokantaan. Tästä on hyötyä erityisesti laajoilla, runsaasti käytetyillä tai palvelinklustereille asennetuilla sivustoilla. Useimmilla sivustoilla tämä asetus pitäisi asettaa pois päältä, jolloin tiedot tallennetaan palvelimen kiintolevylle. Huomio, että tämän asetuksen muuttaminen kirjaa ulos kaikki sen hetkiset käyttäjät (mukaan lukien sinut). Jos käytät MySQL-tietokantaa, varmista että \'max_allowed_packet\' -asetus my.cnf (tai my.ini) -tiedostossa on vähintään 4M.';
$string['configdebug'] = 'Jos tämä asetus on päällä, niin PHPn virheiden ilmoittaminen asetetaan tasolle, jolla enemmän virheitä näytetään. Tämä asetus on käytännöllinen vain kehittäjille.';
$string['configdebugdisplay'] = 'Jos asetettu päälle, virheraportointi menee HTML-sivulle. Tämä on käytännöllistä mutta rikkoo XHTML:n, JS:n, evästeet ja HTTP-ylätunnisteet yleisesti. Jos asetettu pois päältä, raportointi lähetetään palvelimen lokeihin, mikä mahdollistaa paremman virheiden etsinnän. PHP-asetus error_log hallitsee mihin lokiin mihin lokiin raportointi menee.';
$string['configdebugpageinfo'] = 'Ota käyttöön jos haluat että sivun tiedot näytetään sivun alareunassa.';
$string['configdebugsmtp'] = 'Salli monisanainen virheenpoistoinformaatio sähköpostien lähetyksen aikana (SMTP-serverille).';
$string['configdebugvalidators'] = 'Salli jos haluat saada alatunnisteeseen linkit ulkoiseen validointipalveluun. Sinun täytyy ehkä luoda uusi käyttäjä käyttäjätunnuksella <em>w3cvalidator</em> ja sallia vierailijapääsy. Nämä muutokset saattavat mahdollistaa valtuuttamattoman pääsyn palvelimelle, älä salli tuotantosivustoilla!';
$string['configdefaulthomepage'] = 'Tämä määrittelee kirjautuneiden käyttäjien kotisivun';
$string['configdefaultrequestcategory'] = 'Kurssit, joita käyttäjät pyysivät, sijaitsevat automaattisesti tässä kategoriassa';
$string['configdefaultrequestedcategory'] = 'Toivottujen kurssien oletuskategoria, johon ne sijoitetaan jos kurssi hyväksytään.';
$string['configdefaultuserroleid'] = 'Kaikille Moodleen kirjautuneille käyttäjille annetaan tässä määriteltyjen roolin kyvyt Moodlen tasolla, niiden roolien lisäksi, joita muualla (kuten kurssialueilla) on saatettu antaa. Oletusrooli on Tunnistettu käyttäjä (Authenticated user). Huomaa, että tämä ei ole ristiriidassa muiden annettujen roolien kanssa; tällä vain varmistetaan, että kaikki käyttäjät saavat oikeudet (kuten oman kalenterin muokkaus), joita ei voi jakaa kurssitasolla.';
$string['configdeleteincompleteusers'] = 'Tämän jakson jälkeen, vanhat asentamattomat tilit poistetaan.';
$string['configdeleteunconfirmed'] = 'Jos käytät sähköpostivahvistusta, tässä määritellään ajanjakso, jonka aikana vastaukset käyttäjiltä hyväksytään. Tämän ajanjakson jälkeen vanhat vahvistamattomat käyttäjätilit poistetaan.';
$string['configdenyemailaddresses'] = 'Jos haluat estää sähköpostit tietyiltä verkkoalueilta, kirjoita ne tähän. Kaikilta muilta verkkoalueilta olevat sähköpostiosoitteet hyväksytään. Esim. <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Kytke pois päältä käyttäjien kyky vaihtaa profiilikuvia.';
$string['configdisplayloginfailures'] = 'Tämä näyttää valituille käyttäjille tietoja tapahtuneista epäonnistuneista sisäänkirjautumisyrityksistä.';
$string['configdocroot'] = 'Määrittelee polun Moodle Docsiin. Voit muuttaa tätä, jos haluat linkittää omiin ohjeisiinne. Jos muutat tätä, varmista että polut ohjeissa noudattavat samaa muotoa kuin http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Jos valitset tämän, linkit Moodle Docsiin avautuvat uudessa selainikkunassa.';
$string['configeditordictionary'] = 'Tätä arvoa käytetään jos tavauksella ei ole sanastoa käyttäjän omalle kielelle.';
$string['configeditorfontlist'] = 'Valitse fontit, joiden pitäisi ilmestyä HTML-editorin valikkoon.';
$string['configemailchangeconfirmation'] = 'Vaadi sähköpostivarmennus, kun käyttäjät vaihtavat sähköpostiosoitteitaan profiileihinsa.';
$string['configenableajax'] = 'Tämä asetus sallii kontrolloida AJAXin käyttöä koko sivustolla. AJAX-ominaisuuksia käytetään muun muassa vedä&pudota -toiminnoissa.';
$string['configenablecalendarexport'] = 'Salli kalenterimerkintöjen tilaus ja merkintöjen vieminen ulkopuolisiin kalentereihin.';
$string['configenablecomments'] = 'Salli kommentit';
$string['configenablecourserequests'] = 'Tässä voit antaa kaikille käyttäjille mahdollisuuden toivoa uuden kurssin luomista.';
$string['configenabledevicedetection'] = 'Mahdollistaa mobiililaitteiden, älypuhelinten, tablettien tai oletuslaitteiden (pöytätietokoneet, läppärit, jne.) tunnistamisen teeman sovelluksille ja muille ominaisuuksille.';
$string['configenablegroupmembersonly'] = 'Jos käytössä, aktiviteetteihin pääsy voidaan rajoittaa ainoastaan ryhmän jäsenille. Tämä saattaa johtaa lisääntyneeseen palvelimen kuormitukseen. Lisäksi, arviointien kategoriat täytyy olla asetettu tietyllä tavalla, jotta aktiviteetit ovat piilotettuina ei-ryhmän jäseniltä.';
$string['configenablemobilewebservice'] = 'Salli mobiilipalvelu viralliselle Moodle-sovellukselle tai muille sovelluksille jotka pyytävät sitä. Lisätietoa: {$a}';
$string['configenablerssfeeds'] = 'Tämä asetus antaa mahdollisuuden RSS-syötteisiin kaikkialla sivustolla. Jotta asetus tulisi voimaan on yksittäisissä moduuleissa myös aktivoitava RSS-syötteet - tämä tapahtuu moduulin asetuksista .';
$string['configenablerssfeedsdisabled'] = 'Ei ole mahdollista, koska RSS-syötteet on otettu pois käytöstä koko sivustolla. Ottaaksesi ne käyttöön, pitää sinun muuttaa sivuston asetuksia.';
$string['configenablerssfeedsdisabled2'] = 'RSS-syötteet ovat poissa käytöstä palvelintasolla. Sinun täytyy ottaa käyttöön ne Server/RSS.';
$string['configenablesafebrowserintegration'] = 'Tämä lisää valinnan \'Vaadi Turvallinen Tenttiselain\' \'Selaimen turvallisuus\' -kenttään asetuslomakkeella. Lisätietoa osoitteesta http://www.safeexambrowser.org/';
$string['configenablestats'] = 'Jos valitset \'kyllä\' tässä, Moodlen cronjob käsittelee lokeja ja kerää joitakin tilastoja. Riippuen liikenteen määrästä sivustolla tämä voi ottaa hetken. Jos  mahdollistat tämän, voit nähdä joitakin mielenkiintoisia kaavioita ja tilastoja kustakin teidän kursseistanne tai sivustostanne.';
$string['configenabletrusttext'] = 'Oletusarvoisesti Moodle puhdistaa perusteellisesti tekstin joka tulee käyttäjiltä poistaakseen mahdolliset komennot, skriptit, upotetut objektit yms. jotka voisivat olla turvallisuusriskijä. Luotettu sisältö on tapa määritellä käyttäjiä joiden tekemiä sisältöjä ei suodateta.
Käyttääksesi tätä järjestelmää, ota tämä asetus käyttöön ja liitä sitten "Luotetut sisällöt" kyky haluamaasi rooliin ja tämä rooli haluamillesi henkilöille. Näiden käyttäjien tuottama teksti katsotaan luotetuksi eikä sisältöä siivota.';
$string['configenablewebservices'] = 'Verkkopalvelut mahdollistavat muiden järjestelmien kirjautumisen tähän Moodleen suorittamaan tiettyjä toimintoja. Lisäturvan vuoksi tämän ominaisuuden ei pitäisi olla päällä jos et todella käytä sitä.';
$string['configenablewsdocumentation'] = 'Salli verkkopalveludokumentaation automaattinen generointi. Käyttäjä pääsee omaan dokumentaatioonsa omalla turva-avaimet -sivullaan {$a}. Sivu näyttää vain sallittujen protokollien dokumentaation.';
$string['configerrorlevel'] = 'Valitse kuinka paljon PHP-varoituksia haluat näytettävän. Normaali on yleensä paras vaihtoehto.';
$string['configextendedusernamechars'] = 'Tätä asetusta käyttämällä voit antaa oppilaille oikeuden käyttää käyttäjänimissään mitä tahansa merkkejä (tämä ei kuitenkaan koske heidän oikeita nimiään). Oletusarvo asetukselle on "false", joka rajoittaa käytettävissä olevat merkit aakkosnumeerisiin merkkeihin, alaviivaan (_), väliviivaan (-), pisteeseen (.) sekä ät-merkkiin (@).';
$string['configextramemorylimit'] = 'Jotkut ohjelmistokoodit tarvitsevat lisää muistia. Tällaisia ovat mm. varmuuskopiointi/palautus ja ajastus. Aseta isompi oletusmuisti laajoille sivustoille.';
$string['configfilterall'] = 'Suodata kaikki merkkijonot, mukaan lukien otsikot, navigaatiopalkki, jne. Tämä on hyödyllistä lähinnä käytettäessä monikielistä suodatinta, muuten tämä vain kuormittaa palvelinta turhaan, tuottamatta merkittävää hyötyä.';
$string['configfiltermatchoneperpage'] = 'Automaattisesti linkittävä suodatin tekee linkin vain ensimmäiseen sivulta löytyvään ja yhteensopivaan tekstikohtaan. Muita kohtia ei huomioida.';
$string['configfiltermatchonepertext'] = 'Automaattisesti linkittävä suodatin tekee linkin vain ensimmäiseen sivulta löytyvään ja yhteensopivaan tekstikohtaan kussakin sisältöelementissä (esim. aineisto, lohko). Muita kohtia ei huomioida.

Tätä asetusta ei huomioida jos "Suodatin osuu kerran sivussa" asetus on päällä.';
$string['configfilteruploadedfiles'] = 'Tämän asetuksen valinta käskee Moodlen käsitellä kaikki palvelimelle kopioidut HTML- ja tekstitiedostot suotimilla ennen kuin ne näytetään.';
$string['configforcelogin'] = 'Yleensä sivuston etusivu ja kurssilista (muttei kurssien sisältö) on kaikkien sivustolle saapuneiden nähtävillä ilman sisäänkirjautumista. Jos haluat, että käyttäjien on kirjauduttava sisään ennen kuin he voivat tehdä MITÄÄN sivustolla, laita tämä asetus päälle.';
$string['configforceloginforprofiles'] = 'Ota tämä asetus käyttöön, jos haluat että käyttäjät kirjautuvat sisään (eivät siis ole vierailijoita) ennen kuin he voivat nähdä tietoja toisista käyttäjistä. Jos tämä asetus on pois päältä, käyttäjien on mahdollista lisätä koko maailmalle näkyvää mainostusta tai muuta epäsopivaa sisältöä profiileihinsa.';
$string['configfrontpage'] = 'Valitut kohteet näytetään sivuston etusivulla.';
$string['configfrontpageloggedin'] = 'Valitut kohteet näytetään sivuston etusivulla, kun käyttäjä on kirjautunut sisään.';
$string['configfullnamedisplay'] = 'Tämä määrittää kuinka nimet näytetään silloin, kun ne näytetään kokonaisuudessaan. Useimmille vain yhtä kieltä käyttäville sivustoille toimii asetus "Etunimi + Sukunimi", mutta voit myös kätkeä sukunimet kokonaan, tai antaa valitun kielipaketin päättää muodosta (eri kielissä on eri tapoja).';
$string['configgetremoteaddrconf'] = 'Jos palvelimesi on käänteisen välityspalvelimen takana, voit käyttää tätä asetusta määrittääksesi mihin HTTP-ylätunnisteisiin voidaan luottaa, että ne sisältävät etä-IP-osoitteen. Ylätunnisteet luetaan järjestyksessä käyttäen ensimmäistä saatavilla olevaa.';
$string['configgradebookroles'] = 'Tämä asetus sallii sinun kontrolloida kuka näkyy arviointikirjassa. Käyttäjällä tulee olla vähintään yksi näistä rooleista kurssilla näkyäkseen kyseisen kurssin arviointikirjassa.';
$string['confighiddenuserfields'] = 'Valitse käyttäjätiedot, jotka haluat piilottaa muilta käyttäjiltä kuin kurssin opettajilta ja ylläpitäjiltä. Tämä lisää opiskelijan yksityisyyttä. Valitse useita kohtia käyttämällä CTRL-näppäintä.';
$string['configidnumber'] = 'Tämä asetus määrittää (a) kysytäänkö käyttäjiltä ollenkaan ID:tä, (b) käyttäjiltä kysytään ID-numeroa, mutta he voivat jättää kentän tyhjäksi, (c) käyttäjiltä kysytään ID-numeroa, eivätkä he voi jättää kohtaa tyhjäksi. Jos ID-numero annetaan, se näytetään käyttäjätiedoissa.';
$string['configintro'] = 'Tällä sivulla voit määritellä useita asetuksia, jotta Moodle toimisi oikein palvelimellasi. Älä turhaan kanna huolta näistä - oletusarvot toimivat yleensä hyvin ja voit aina myöhemmin palata tälle sivulle ja muuttaa näitä asetuksia.';
$string['configintroadmin'] = 'Tällä sivulla sinun pitää määritellä pääasiallinen ylläpitäjä sivustollesi, jolla on täydet valtuudet koko sivustolla. Huolehdi siitä että käyttäjänimi ja salasana ovat turvallisia ja että sähköpostiosoite on toimiva. Voit luoda lisää ylläpitäjäkäyttäjiä myöhemmin.';
$string['configintrosite'] = 'Tällä sivulla määritellään etusivu ja uuden sivuston nimi. Voit palata tälle sivulle myöhemmin Sivuston hallinta -valikon kautta.';
$string['configiplookup'] = 'Kun napsautat IP-osoitetta (kuten 34.12.222.93), esim. lokeissa teille näytetään kartta  siitä, missä tuo IP sijaitsee. Tätä ominaisuutta  varten on olemassa erilaisia lisäosia, joista voit valita, kullakin on etuja ja haittoja.';
$string['configkeeptagnamecase'] = 'Valitse tämä jos haluat tunnisteiden nimien säilyttävän alkuperäisen kirjainkokonsa, eli kuten käyttäjät ovat ne lisänneet.';
$string['configlang'] = 'Valitse oletuskieli koko sivustolle. Käyttäjät voivat muuttaa myöhemmin omaa kieliasetustaan kieli-valikon tai omien profiiliasetustensa kautta.';
$string['configlanglist'] = 'Jätä tämä tyhjäksi antaaksesi käyttäjien kaikista Moodleen asentamistasi kielistä. Voit lyhentää kielivalikkoa kirjoittamalla halutut kielet tähän pilkulla erottuina. Esimerkki: fi,en,es_es,fr,it';
$string['configlangmenu'] = 'Valitse näytetäänkö kielivalikko kotisivulla, kirjautumissivulla, jne. Tämä ei vaikuta käyttäjien kykyyn valita haluamansa kielen käyttäjätiedoissa.';
$string['configlatinexcelexport'] = 'Valitse Excel-tiedostoviennin merkistökoodaus.';
$string['configlocale'] = 'Valitse koko sivustoa koskeva maa-asetus, joka vaikuttaa päivämäärien muotoon ja kieleen. Maa-asetuksen vaatimien tietojen täytyy olla asennettuna (esim.  fi_FI tai en_US). Jos et osaa valita, jätä tyhjäksi.';
$string['configloginhttps'] = 'Kun tämä asetus on asetettu päälle, Moodle käyttää suojattua https-yhteyttä vain kirjautumissivulle (mahdollistaen turvallisen kirjautumisen) ja tämän jälkeen palaa käyttämään tavallista http:tä lisänopeuden saavuttamiseksi. HUOMIOI: tätä asetusta käytettäessä https:n TÄYTYY olla valittuna palvelimen asetuksissa - jos näin ei ole, SAATAT LUKITA ITSESI SIVUSTOLTASI.';
$string['configloglifetime'] = 'Tässä määritellään kuinka kauan haluat säilyttää lokitiedostoja käyttäjien toimista. Tätä asetusta vanhemmat lokitiedostot poistetaan automaattisesti. On parasta säilyttää lokitiedostot mahdollisimman kauan, koska saatat tarvita niitä. Mutta jos palvelimesi liikenne on erittäin vilkasta ja sillä esiintyy suorituskykyyn liittyviä ongelmia, kannattaa todennäköisesti vähentää lokien säilytysaikaa. Alle 30 päivän asetusta ei suositella, koska raportit eivät välttämättä tällöin toimi oikein.';
$string['configlookahead'] = 'Eteenpäin katsottavien päivien määrä';
$string['configmaxbytes'] = 'Tämä asetus määrittelee palvelimelle kopioitavien tiedostojen suurimman koon koko sivustolle. Tämän asetuksen yläraja riippuu PHP:n upload_max_filesize-asetuksesta ja Apachen LimitRequestBody-asetuksesta. Tämä asetus taas määrittelee kokoluokat, jotka voidaan valita kurssi- tai moduulitasolla. Jos \'Palvelimen rajoitus\' on valittuna, käytetään palvelimelle määriteltyä maksimikokoa.';
$string['configmaxconsecutiveidentchars'] = 'Salasanoissa ei saa olla tätä lukua enempää perättäisiä identtisiä merkkejä. Käytä arvoa 0 estääksesi tämän asetuksen.';
$string['configmaxeditingtime'] = 'Tässä määritellään kuinka kauan käyttäjät voivat muokata kirjoittamiaan keskustelualueen viestejä, sanakirjan huomautuksia, jne. Yleensä 30 minuuttia on hyvä arvo asetukselle.';
$string['configmaxevents'] = 'Eteenpäin katsottavien tapahtumien määrä';
$string['configmessaging'] = 'Käytetäänkö sivuston käyttäjien välistä viestintäjärjestelmää?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Luetut ilmoitukset voidaan poistaa tilan säästämiseksi. Kuinka pitkän ajan päästä ilmoituksen lukemisesta ilmoitus voidaan poistaa?';
$string['configmessaginghidereadnotifications'] = 'Piilota luetut ilmoitukset tapahtumista, kuten keskustelualueen viesteistä, kun katsellaan viestihistoriaa';
$string['configminpassworddigits'] = 'Salasanoissa pitää olla vähintään näin monta numeroa.';
$string['configminpasswordlength'] = 'Salasanojen pitää olla vähintään näin monta merkkiä pitkä.';
$string['configminpasswordlower'] = 'Salasanoissa pitää olla vähintään näin monta pientä kirjainta.';
$string['configminpasswordnonalphanum'] = 'Salasanoissa pitää olla vähintään näin monta erikoismerkkiä.';
$string['configminpasswordupper'] = 'Salasanoissa pitää olla vähintään näin monta isoa kirjainta.';
$string['configmycoursesperpage'] = 'Kurssien maksimimäärä joka näytetään käyttäjän omat kurssit -listalla';
$string['configmymoodleredirect'] = 'Tämä ohjaa muut kuin pääkäyttäjät kirjautumisen jälkeen /my -sivulle ja korvaa navigointipalkin etusivulinkin linkillä /my -sivulle';
$string['configmypagelocked'] = 'Tämä asetus estää oletussivun muokkaamisen muilta kuin pääkäyttäjiltä';
$string['confignavcourselimit'] = 'Rajoittaa käyttäjälle näytettävien kurssien määrää, kun he eivät ole kirjautuneena tai eivät ole rekisteröityneenä yhdellekään kurssille.';
$string['confignavshowallcourses'] = 'Tällä asetuksella määritellään näkeekö käyttäjä omat kurssinsa Navigointi-valikossa sekä Omat kurssini että Kurssit -kohdassa. Jos pois käytöstä, käyttäjät näkevät ainoastaan Omat kurssini -valikon.';
$string['confignavshowcategories'] = 'Näytä kurssikategoriat navigointipalkissa ja navigointilohkoissa. Tätä ei tapahdu kursseilla, joille käyttäjä on rekisteröitynyt. Ne listataan edelleen omat kurssini -kohdassa ilman kategorioita.';
$string['confignotifyloginfailures'] = 'Jos havaitaan epäonnistuneita kirjautumisyrityksiä, voidaan lähettää ilmoitus sähköpostitse. Kenelle ilmoitukset lähetetään?';
$string['confignotifyloginthreshold'] = 'Jos lähetetään ilmoitukset epäonnistuneista kirjautumisyrityksistä, kuinka monesta yrityksestä yhden käyttäjän tai IP:n osalta lähetetään ilmoitus?';
$string['confignotloggedinroleid'] = 'Kaikille Moodleen kirjautuneille käyttäjille annetaan tässä määriteltyjen roolin kyvyt Moodlen tasolla, niiden roolien lisäksi, joita muualla (kuten kurssialueilla) on saatettu antaa. Oletusrooli on vierailija. Huomaa, että tämä ei ole ristiriidassa muiden annettujen roolien kanssa; tällä vain varmistetaan, että kaikki käyttäjät saavat oikeudet (kuten oman kalenterin muokkaus), joita ei voi jakaa kurssitasolla.';
$string['configopentogoogle'] = 'Jos tämä asetus on käytössä, Googlelle sallitaan vierailijaoikeus sivustolla. Lisäksi käyttäjät, jotka tulevat sivustolle Googlen kautta, kirjataan automaattisesti vierailijoiksi. Tämä tarjoaa kuitenkin avoimen pääsyn vain kurssialueille, joille jo sallitaan vierailijoiden pääsy.';
$string['configoverride'] = 'Määritelty config.php:ssä';
$string['configpasswordpolicy'] = 'Tämän asetuksen ottaminen käyttöön määrittelee Moodlen tarkistamaan salasanojen kelvollisuuden. Käytä alla olevia asetuksia määritelläksesi salasanojen vaatimukset (nämä jätetään huomioimatta jos valitset vaihtoehdon \'Ei\').';
$string['configpathtoclam'] = 'Polku clam AV-ohjelmaan. Todennäköisesti /usr/bin/clamscan tai /usr/bin/clamdscan. Tämä polku täytyy olla asetettu, että voit käyttää clam AV-virustutkaa.';
$string['configpathtodu'] = 'Polku du-ohjelmaan. Todennäköisesti  /usr/bin/du. Tämä nopeuttaa hakemistojen kokoja näyttävien sivujen toimintaa.';
$string['configperfdebug'] = 'Jos kytket tämän päälle, suorittamistietoa näytetään normaalin teeman alatunnisteessa';
$string['configprofileroles'] = 'Lista rooleista, jotka ovat näkyvissä käyttäjäprofiileissa ja osallistujat-sivulla.';
$string['configprofilesforenrolledusersonly'] = 'Jotta roskapostittajien väärinkäytöksiä voitaisiin estää, käyttäjien, jotka eivät vielä ole kirjautuneena yhdelläkään kurssilla, profiilien kuvaukset on piilotettu. Uusien käyttäjien täytyy kirjautua ainakin yhdelle kurssille ennen kuin he voivat lisätä kuvauksen profiiliinsa.';
$string['configprotectusernames'] = 'Oletusarvoisesti forget_password.php ei näytä mitään vihjeitä, jotka auttaisivat käyttäjätunnuksien tai sähköpostiosoitteiden arvailua.';
$string['configproxybypass'] = 'Pilkulla erotettu lista (osittaisista) verkko- tai IP-osoitteista, joiden pitäisi ohittaa välityspalvelin (esim., 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Jos tämän <b>palvelimen</b> tarvitsee käyttää välityspalvelinta (esim. palomuuria) Internet-yhteyksiin, määritä välityspalvelimen palvelinnimi tähän. Muuten jätä tyhjäksi.';
$string['configproxypassword'] = 'Jos vaadittu, tarvittava salasana internetiin pääsyyn välityspalvelimen kautta. Jätä tyhjäksi jos ei vaadittu (PHP cURL -lisäosa vaadittu).';
$string['configproxyport'] = 'jos tämän palvelimen tarvitsee käyttää välityspalvelinta, silloin antakaa välityspalvelimen portti tässä.';
$string['configproxytype'] = 'Verkon välityspalvelimen tyyppi (PHP5 ja cURL lisäosat vadittu SOCKS5 -tukea varten).';
$string['configproxyuser'] = 'Jos vaadittu, tarvittava käyttäjätunnus internetiin pääsyyn välityspalvelimen kautta. Jätä tyhjäksi jos ei vaadittu (PHP cURL -lisäosa vaadittu).';
$string['configquarantinedir'] = 'Jos haluat clam AV:n siirtävän viruksen saastuttamat tiedostot karanteenihakemistoon, kirjoita hakemiston nimi tähän. Verkkopalvelimen täytyy voida kirjoittaa hakemistoon. Jos jätät tämän kohdan tyhjäksi, tai jos määrität hakemiston, jota ei ole tai johon ei voida kirjoittaa, tiedostot tuhotaan. Älä kirjoita hakemistopolun perään viimeiseksi merkiksi vinoviivaa ´/´.';
$string['configrecaptchaprivatekey'] = 'Merkkijono, jota käytetään kommunikoinnissa Moodle-palvelimesi ja recaptcha-palvelimen välillä. Hanki merkkijono osoitteesta http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Merkkijono, jota käytetään näyttämään reCAPTCHA-elementti kirjautumislomakkeella. Generoitu osoitteessa http://www.google.com/recaptcha';
$string['configrequestedstudentname'] = 'Käytettävä sana oppilaalle toivotuilla kursseilla';
$string['configrequestedstudentsname'] = 'Käytettävä sana oppilaille toivotuilla kursseilla';
$string['configrequestedteachername'] = 'Käytettävä sana opettajalle toivotuilla kursseilla';
$string['configrequestedteachersname'] = 'Käytettävä sana opettajille toivotuilla kursseilla';
$string['configrequiremodintro'] = 'Estä tämä valinta jos et halua pakottaa käyttäjiä kirjoittamaan kuvausta jokaiselle aktiviteetille.';
$string['configrunclamavonupload'] = 'Määritä, käytetäänkö clamAV:ta tutkimaan kaikkia sivustolle lähetettyjä tiedostoja.';
$string['configrunclamonupload'] = 'Käynnistetäänkö clam AV kun tiedostoja kopioidaan palvelimelle? Sinun tarvitsee olla määrittänyt oikea polku clam AV-ohjelmaan, jotta tämä toimisi. (Clam AV on ilmainen ja GPL-lisensoitu virustutka, jonka voit ladata osoitteesta http://www.clamav.net/)';
$string['configsectioninterface'] = 'Käyttöliittymä';
$string['configsectionmail'] = 'Sähköposti';
$string['configsectionmaintenance'] = 'Huolto';
$string['configsectionmisc'] = 'Muut asetukset';
$string['configsectionoperatingsystem'] = 'Käyttöjärjestelmä';
$string['configsectionpermissions'] = 'Oikeudet';
$string['configsectionrequestedcourse'] = 'Kurssi toiveet';
$string['configsectionsecurity'] = 'Turvallisuus';
$string['configsectionstats'] = 'Tilastot';
$string['configsectionuser'] = 'Käyttäjä';
$string['configsecureforms'] = 'Moodle voi käyttää korkeampaa turvallisuustasoa ottaessaan vastaan tietoa verkkolomakkeista. Jos asetus asetetaan päälle selaimen HTTP_REFERER-muuttujaa verrataan lomakkeen osoitteeseen. Harvoissa tapauksissa tämä aiheuttaa ongelmia, kun käyttäjän palomuuri (esim. ZoneAlarm) on asetettu poistamaan HTTP_REFERER-muuttuja lähtevästä verkkoliikenteestä. Oireena on ´juuttuminen´ lomakkeeseen. Jos käyttäjilläsi on ongelmia esimerkiksi kirjautumissivun kanssa, kannattaa mahdollisesti ottaa tämä asetus pois käytöstä, vaikkakin tämä saattaa altistaa raakaan laskentatehoon perustuville salasanahyökkäyksille. Jos olet epävarma, jätä asetukseksi ´Yes´.';
$string['configsessioncookie'] = 'Tämä asetus muokkaa Moodle-istunnoissa käytettävän cookien nimeä. Tämä on valinnanvaraista ja hyödyllistä vain, kun halutaan välttää cookieiden sekaantuminen kun käytössä enemmän kuin yksi Moodle-istunto samalla sivustolla.';
$string['configsessioncookiepath'] = 'Jos haluat muuttaa minne selaimet selaimet lähettävät Moodlen evästeet, voit muuttaa tämän viittaamaan  sivuston alihakemistoon. Muuten oletuksen \'/\' pitäisi toimia hyvin.';
$string['configsessiontimeout'] = 'Jos sivustolle kirjautuvat ihmiset eivät tee mitään toimintoa pitkään aikaan (eivät lataa sivuja), silloin heidät kirjataan ulos automaattisesti (heidän istuntonsa lopetetaan). Tämä asetus määrää kuinka pitkä toimettomana olon on oltava ennen kuin käyttäjä kirjataan ulos.';
$string['configshowcommentscount'] = 'Näytä kommenttien määrä, tämä aiheuttaa yhden lisäkyselyn kun näytä kommentit -linkkiä on painettu';
$string['configshowsiteparticipantslist'] = 'Kaikki nämä sivuston opiskelijat ja sivuston opettajat listataan sivuston osanottajalistaan. Kenelle osallistumislista näytetään?';
$string['configsitedefaultlicense'] = 'Sivuston oletuslisenssi';
$string['configsitedefaultlicensehelp'] = 'Oletuslisenssi jota käytetään julkaistaessa sisältöjä sivustolla';
$string['configsitemaxcategorydepth'] = 'Alakategorioiden maksimimäärä';
$string['configsitemaxcategorydepthhelp'] = 'Tämä määrittelee näytettävien alakategorioiden maksimimäärän';
$string['configslasharguments'] = 'Tiedostoihin (kuviin ja muihin palvelimelle kopioituihin) viitataan skriptillä, joka käyttää ´kauttaviiva-argumentteja´. Tällä menetelmällä tiedostojen säilyttäminen verkkopalvelinten, välityspalvelinten tms. välimuistissa helpottuu. Valitettavasti jotkin PHP-palvelimet eivät salli tätä menetelmää, joten jos palvelimelle kopioitujen tiedostojen käytössä on ongelmia (esim. käyttäjäkuvat eivät näy), ota tämä asetus pois käytöstä.';
$string['configsmartpix'] = 'Kun tämä on päällä, ikonit tarjoillaan PHP-skriptillä, joka etsii ensin nykyisen teeman, sitten kaikki yläteemat ja lopuksi Moodlen /pix -kansion. Tämä vähentää tarvetta kopioida kuvatiedostoja teemojen sisällä, mutta aiheuttaa pienen suorituskyvyn alenemisen.';
$string['configstartwday'] = 'Viikon aloituspäivä';
$string['configstatsfirstrun'] = 'Tämä määrittelee, miten kauas taaksepäin lokeja pitäisi käsitellä  <b>ensimmäisen kerralla</b>, kun cron haluaa käsitellä tilastoja. Jos sivustolla on paljon liikennettä tai sivusto on jaetulla palvelimella, ei ole hyvä mennä liian pitkälle taaksepäin. Sillä tämä voi viedä pitkän aikaa  ja olla vaatia paljon resursseja.';
$string['configstatsmaxruntime'] = 'Tilastotiedonkäsittely voi olla melko intensiivistä. Käytä yhdistelmänä tätä asetusta ja seuraavaa määritelläkseen, kuinka käsittely toimii, ja miten kauan.';
$string['configstatsmaxruntime2'] = 'Tilastojen prosessointi saattaa olla hyvin intensiivistä, määrittele sallittu maksimiaika yhden päivän tilastojen keräämiseen. Yhden cron-ajon aikana käsiteltävien päivien maksimimäärä on 31.';
$string['configstatsmaxruntime3'] = 'Määrittele yhden päivän tilastojen laskemiseen käytettävä maksimiaika, pitäen mielessä että tilastojen laskeminen voi kuormittaa palvelinta huomattavasti. Yhden cron-ajon aikana käsiteltävien päivien maksimimäärä voidaan määritellä alla.';
$string['configstatsruntimedays'] = 'Määrittele jokaisessa tilastosuorituksessa käsiteltävien päivien maksimimäärä. Kun tilastot ovat ajantasalla, vain yksi päivä käsitellään, joten aseta tämä arvo riippuen palvelimesi kuormituksesta, vähentäen sitä jos tarvitaan lyhyempiä cron-ajoja.';
$string['configstatsruntimestart'] = 'Mihin aikaan cronjob, joka tekee tilastotiedonkäsittelyä, pitäisi <b>alkaa</b>? Määrittele eri ajankohdat mikäli samalla palvelimella on useita Moodle-asennuksia.';
$string['configstatsuserthreshold'] = 'Tällä asetuksella määritellään tilastoissa huomioitavien kurssien vähimmäisosallistujamäärä.';
$string['configstrictformsrequired'] = 'Jos sallittu, käyttäjiä estetään syöttämästä välilyöntiä tai rivin vaihtoa vain vaadittuihin kenttiin lomakkeissa.';
$string['configstripalltitletags'] = 'Poista tämä valinta salliaksesi HTML-tunnisteet aktiviteettien ja aineistojen nimissä.';
$string['configsupportname'] = 'Tämä on henkilön tai entiteetin nimi, joka tarjoaa yleistä apua tukisähköpostin tai verkko-osoitteen kautta.';
$string['configthemelist'] = 'Jätä tyhjäksi salliaksesi minkä tahansa kelvollisen teeman käytön. Jos haluat lyhentää teema-valikkoa, voit määrittää tähän pilkulla erotellun listan sallituista teemoista (älä käytä välilyöntiä!). Esim: standard,orangewhite.';
$string['configtimezone'] = 'Voit määrittää oletusaikavyöhykkeen tähän. Tämä on vain OLETUSaikavyöhyke ajan näyttämiseksi, jokainen käyttäjä voi määrittää oman aikavyöhykkeensä. Jos kirjoitat tähän "Server time", käyttää Moodle palvelimen käyttöjärjestelmän  ilmoittamaa aikaa, kun taas käyttäjätiedoissa "Server time" hakee aikavyöhykkeen nyt määriteltävästä asetuksesta.';
$string['configuseblogassociations'] = 'Pitäisikö käyttäjien pystyä järjestämään bloginsa assosioimalla kirjoituksia kurssien ja kurssimoduulien kanssa?';
$string['configuseexternalyui'] = 'Paikallisten tiedostojen käytön sijaan käytä verkossa saatavilla olevia tiedostoja Yahoo:n palvelimilta. VAROITUS: Tämä vaatii verkkoyhteyden tai AJAX ei toimi sivustollasi. Tämä ei ole yhteensopiva sivustoilla joilla käytetään https-yhteyksiä.';
$string['configuserquota'] = 'Bittien maksimimäärä, jonka käyttäjä voi tallentaa yksityiselle tiedostoalueelleen. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Jos käytössä, sivuston lyhennettä käytetään navigoinnissa tekstin \'Omat sivuni\' tilalla.';
$string['configusetags'] = 'Laitetaanko tagien toimivuus päälle koko sivustolle?';
$string['configvariables'] = 'Asetukset';
$string['configvisiblecourses'] = 'Piilotetuissa kategorioissa olevat kurssit näytetään normaalisti';
$string['configwarning'] = 'Ole varovainen muuttaessasi näitä asetuksia, väärät arvot voivat aiheuttaa ongelmia.';
$string['confirmation'] = 'Vahvistus';
$string['confirmdeletecomments'] = 'Haluatko varmasti poistaa kommentit?';
$string['confirmed'] = 'Vahvistettu';
$string['convertformat'] = '<i>konvertoi</i> tulostusformaatti';
$string['cookiehttponly'] = 'Vain HTTP-evästeet';
$string['cookiesecure'] = 'vain varmiste-evästeet';
$string['country'] = 'Oletusmaa';
$string['coursecontact'] = 'Kurssimanagerit';
$string['coursecontact_desc'] = 'Tämä asetus auttaa sinua kontrolloimaan ketkä näkyvät kurssin kuvauksessa. Käyttäjillä pitää olla ainakin yksi näistä rooleista näkyäkseen kurssin kuvauksessa.';
$string['courselistshortnames'] = 'Näytä kurssien koko nimet';
$string['courselistshortnames_desc'] = 'Näytettäessä lista kursseista, tai viitattaessa kurssiin ylläpitonäkymässä, näytetäänkö sekä kurssin lyhenne etttä koko nimi. Jos tämä asetus on päällä, käytetään \'courseextendednamedisplay\' -kieliasetusta, joten voit muuttaa sitä Kielen muokkaus -kohdasta.';
$string['coursemgmt'] = 'Lisää/muokkaa kursseja';
$string['courseoverview'] = 'Kurssin yleiskatsaus';
$string['courserequestnotify'] = 'Kurssipyynnön ilmoitus';
$string['courserequestnotifyemail'] = 'Käyttäjä {$a->user} pyysi uutta kurssia {$a->link}';
$string['courserequests'] = 'Kurssipyynnöt';
$string['courserequestspending'] = 'Odottavat kurssipyynnöt';
$string['courses'] = 'Kurssit';
$string['coursesperpage'] = 'Kursseja sivulla';
$string['creatornewroleid'] = 'Kurssin luojan rooli uusissa kursseissa.';
$string['creatornewroleid_help'] = 'Jos käyttäjällä ei ole vielä oikeuksia ylläpitää uutta kurssia lisätään käyttäjä automaattisesti kurssille käyttämällä tätä roolia.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Cron toteuttaminen pelkästään komentorivin kautta.';
$string['cronerrorclionly'] = 'Pahoittelut, ylläpitäjä on estänyt internet-yhteyden tälle sivulle.';
$string['cronerrorpassword'] = 'Pahoittelut, sinulla ei ole käypää salasanaa tälle sivulle.';
$string['cron_help'] = 'Cron-php ylläpito-scripti auttaa muutamia Moodlen moduleita suorittamaan ajastettuja tehtäviä. Tällaisia ovat mm. keskustelufoorumien kirjoitusten välittäminen sähköpostiin. Tämä vaatii scriptin säännöllistä ajamista säännöllisesti esim. 5 minuutin välein.';
$string['cronremotepassword'] = 'Cron-salasana etäkäytölle';
$string['cronwarning'] = '<a href="cron.php">cron.php-huoltoscriptiä</a> ei ole ajettu viimeisen 24. tunnin sisällä.';
$string['ctyperequired'] = 'ctype -PHP-laajennus on nykyään vaadittu Moodlessa, jotta voidaan parantaa sivuston suorituskykyä ja tarjota monikielisyyden tuki.';
$string['curlcache'] = 'cURL välimuisti TTL';
$string['curlrecommended'] = 'Moodlen verkkotyöskentelytoiminnallisuuden käyttämiseen on hyvin suositeltua asentaa valinnainen cURL-kirjasto.';
$string['curlrequired'] = 'Moodle vaatii nykyään cURL PHP-lisäosan, jotta voitaisiin kommunikoida Moodlen tiedostopankkien kanssa.';
$string['curltimeoutkbitrate'] = 'Käytettävä bittinopeus kun lasketaan cURL aikakatkaisu (Kbps)';
$string['currenttheme'] = 'Nykyinen teema';
$string['customcheck'] = 'Muut tarkistukset';
$string['custommenu'] = 'Mukautettu valikko';
$string['custommenuitems'] = 'Mukautetun valikon kohteet';
$string['datarootsecuritywarning'] = 'Sivustonne asetukset eivät saata olla turvallisia. Ole hyvä ja varmista, että teidän dataroot?hakemistonne ({$a}) ei ole suoraan lähestyttävissä webin kautta.';
$string['dbmigrate'] = 'Tietokannan muuntaminen';
$string['dbmigrateconnecerror'] = 'Ei voinut yhdistää tietokantaan, joka on määritelty.';
$string['dbmigrateencodingerror'] = 'Määritellyllä tietokannalla on koodaus, {$a}, vaadittu koodaus on UNICODE/UTF8.<br />Ole hyvä ja määrittele toinen kanta.';
$string['dbmigratepostgres'] = 'Nähtävästi käytät  PostgreSQLia tietokantapalvelimena. Jatkaakseen muuttoprosessia, tee uusi tietokanta käsin "UNICODE:n" tai "UTF8:n" koodattuna. Ole hyvä ja kirjoita uuden tietokantayhteyden tiedot ala puolelle jatkaaksesi:';
$string['dbmigratewarning'] = 'Varmistathan, että olet varmuukopioinut Moodle-tietokannan ennen tämän toiminnon aloittamista. Jos olet epävarma siitä miten se tapahtuu, ota yhteyttä järjestelmän ylläpitäjään. Moodle-sivusto asetetaan  huoltotilaan kun aloitat muuntoprosessin';
$string['dbmigratewarning2'] = '<b>-Varoitus: Tulet pian aloittamaan tietokantamuuttoprosessin. Ole hyvä ja varmista, että koko Moodlen tietokanta on varmuuskopioitu.</b>';
$string['dbmigrationdeprecateddb'] = '<font-color="#ff0000">Tämä tietokanta ei ole enää käytössä. Tiedot on  siirretty uuteen UTF8:n tietokantaan. Ole hyvä ja muokkaa config.php:ianne käyttäkääksesi uutta tietokantaa tämän  moodlen kanssa.</font>';
$string['dbmigrationdupfailed'] = 'Tietokannan monistaminen epäonnistui mahdollisesti virheeseen:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Käyttäkää tietokantaa istuntoon tietoihin';
$string['debug'] = 'Virheenetsintäviestit';
$string['debugall'] = 'KAIKKI: Näytä kaikki  PHP virheenetsintäviestit';
$string['debugdeveloper'] = 'KEHITTÄJÄ: tarkempia Moodle virheenetsintäviestejä kehittäjille';
$string['debugdisplay'] = 'Näytä virheenjäljitysviestit';
$string['debugging'] = 'Virheenjäljitys';
$string['debugminimal'] = 'MINIMAALINEN: Näytä vain vakavat virheet';
$string['debugnone'] = 'EI MITÄÄN: Älä näytä mitään virheitä tai varoituksia';
$string['debugnormal'] = 'NORMAALITILA: Näytä virheet, varoitukset ja ilmoitukset';
$string['debugpageinfo'] = 'Näytä sivun tiedot';
$string['debugsmtp'] = 'Virheenjäljitysviestien lähettäminen sähköpostiin';
$string['debugstringids'] = 'Näytä kielikäännösten alkuperä';
$string['debugvalidators'] = 'Näytä validointilinkit';
$string['defaultcity'] = 'Oletuskaupunki';
$string['defaultcity_help'] = 'Se kaupunki mikä laitetaan tähän määritellään oletuskaupungiksi myös kun luodaan uusia käyttäjätilejä.';
$string['defaulthomepage'] = 'Käyttäjien oletuskotisivu';
$string['defaultrequestcategory'] = 'Oletuskategoria anotuille kursseille';
$string['defaultsettinginfo'] = 'Oletus: {$a}';
$string['defaultuserroleid'] = 'Oletusrooli kaikille käyttäjille';
$string['deleteincompleteusers'] = 'Poista keskeneräiset käyttäjätunnukset jälkeen';
$string['deleteunconfirmed'] = 'Poista vahvistamattomat tunnukset jälkeen';
$string['deleteuser'] = 'Poista käyttäjä';
$string['density'] = 'Tiheys';
$string['denyemailaddresses'] = 'Estetyt sähköposti-verkkoalueet';
$string['development'] = 'Kehitys';
$string['devicedetectregex'] = 'Laitteen tunnistamisen säännöllinen lauseke';
$string['devicedetectregexexpression'] = 'Säännöllinen lauseke';
$string['devicedetectregexvalue'] = 'Palautettava arvo';
$string['devicetype'] = 'Laitteen tyyppi';
$string['disableuserimages'] = 'Poista käyttäjäprofiilien kuvat käytöstä';
$string['displayerrorswarning'] = 'PHP-asetuksen <em>display_errors</em> salliminen tuotantosivustoilla ei ole suositeltavaa, koska jotkin virheilmoitukset voivat paljastaa arkaluontoista tietoa palvelimestasi.';
$string['displayloginfailures'] = 'Näytä kirjautumisvirheet';
$string['dndallowtextandlinks'] = 'Tekstien ja linkkien lataaminen vedä&pudota -tekniikalla';
$string['docroot'] = 'Moodle Docs ohjeen sijainti';
$string['doctonewwindow'] = 'Avaa uudessa ikkunassa';
$string['download'] = 'Lataa';
$string['edithelpdocs'] = 'Muokkaa ohjetiedostoja';
$string['editlang'] = '<b>Muokkaa</b>';
$string['editorbackgroundcolor'] = 'Taustaväri';
$string['editordictionary'] = 'Editorin sanasto';
$string['editorfontfamily'] = 'Kirjasinperhe';
$string['editorfontlist'] = 'Kirjasinlista';
$string['editorfontsize'] = 'Kirjasimen koko';
$string['editorhidebuttons'] = 'Piilotetut painikkeet';
$string['editorkillword'] = 'Word-muotoilujen suodatin';
$string['editorspelling'] = 'Editorin oikoluku';
$string['editorspellinghelp'] = 'Salli tai estä oikeinkirjoitus. Kun sallittu, <strong>aspell</strong> täytyy olla asennettu palvelimelle.';
$string['editstrings'] = 'Muokkaa merkkijonoja';
$string['emailchangeconfirmation'] = 'Sähköpostiosoitteen muuttamisen varmistus';
$string['emoticonalt'] = 'Vaihtoehtoinen teksti';
$string['emoticoncomponent'] = 'Kuvan komponentti';
$string['emoticonimagename'] = 'Kuvan nimi';
$string['emoticons'] = 'Hymiöt';
$string['emoticonsreset'] = 'Palauta hymiöasetukset oletusarvoihin';
$string['emoticontext'] = 'Teksti';
$string['emptysettingvalue'] = 'Tyhjä';
$string['enableajax'] = 'Mahdollista AJAX';
$string['enablecalendarexport'] = 'Salli kalenterin vienti';
$string['enablecomments'] = 'Salli kommentointi';
$string['enablecourserequests'] = 'Salli kurssien anominen';
$string['enabledevicedetection'] = 'Ota käyttöön laitteiden tunnistus';
$string['enablegravatar'] = 'Salli Gravatarit';
$string['enablegravatar_help'] = 'Jos käytössä, Moodle yrittää ladata käyttäjän profiilikuvan Gravatarista ellei käyttäjä ole ladannut profiilikuvaa.';
$string['enablegroupmembersonly'] = 'Salli vain ryhmän jäsenet';
$string['enablemobilewebservice'] = 'Ota käyttöön mobiililaitteiden verkkopalvelut';
$string['enablerecordcache'] = 'Mahdollista tietue-välimuisti';
$string['enablerssfeeds'] = 'Mahdollista RSS-syötteet';
$string['enablesafebrowserintegration'] = 'Salli Turvallisen Tenttiselaimen integrointi';
$string['enablestats'] = 'Mahdollista tilastot';
$string['enabletrusttext'] = 'Salli luotettu sisältö';
$string['enablewebservices'] = 'Salli web-palvelut';
$string['enablewsdocumentation'] = 'Web-palvelujen dokumentaatio';
$string['enrolinstancedefaults'] = 'Ilmoittautumisinstanssin oletukset';
$string['enrolinstancedefaults_desc'] = 'Ilmoittaumisten oletusasetukset uusilla kursseilla';
$string['enrolmultipleusers'] = 'Liitä käyttäjät kurssille';
$string['environment'] = 'Ympäristö';
$string['environmenterrortodo'] = 'Sinun pitää ratkaista kaikki käyttöympäristön ongelmat ennen kuin voit asentaa tämän version Moodlesta.';
$string['environmentmustfixsetting'] = 'PHP-asetuksia on muutettava.';
$string['environmentok'] = 'Palvelinympäristösi täyttää kaikki vähimmäisvaatimukset.';
$string['environmentrecommendcustomcheck'] = 'jos tämä testi epäonnistuu, on se merkki mahdollisesta ongelmasta';
$string['environmentrecommendinstall'] = 'suositellaan asennettavaksi/käyttöönotettavaksi';
$string['environmentrecommendversion'] = 'pitäisi käyttää versiota {$a->needed} mutta käytössä on versio {$a->current}';
$string['environmentrequirecustomcheck'] = 'tämän testin on mentävä läpi';
$string['environmentrequireinstall'] = 'pitää olla asennettuna ja käytössä';
$string['environmentrequireversion'] = 'versio {$a->needed} vaaditaan ja käytössä on versio {$a->current}';
$string['environmentsettingok'] = 'suositusasetukset havaittu';
$string['environmentshouldfixsetting'] = 'PHP-asetuksia pitäisi muuttaa.';
$string['environmentxmlerror'] = 'Virhe luettaessa ympäristötietoja ({$a->error_code})';
$string['errordeletingconfig'] = 'Tapahtui virhe poistettaessa konfiguraatiomerkintöjä pluginille \'{$a}\'.';
$string['errorsetting'] = 'Muutoksia ei voitu tallentaa:';
$string['errorwithsettings'] = 'Joitakin asetuksia ei muutettu virheen takia.';
$string['everyonewhocan'] = 'Kaikki jotka voivat {$a}';
$string['exceptions'] = 'poikkeukset';
$string['experimental'] = 'Testausvaiheessa';
$string['experimentalsettings'] = 'Testausvaiheen asetukset';
$string['extendedusernamechars'] = 'Salli erikoismerkit käyttäjätunnuksissa';
$string['extramemorylimit'] = 'Ylimääräinen PHP-muistiraja';
$string['filecreated'] = 'Uusi tiedosto luotu';
$string['filestoredin'] = 'Tallenna tiedosto kansioon:';
$string['filestoredinhelp'] = 'Minne tiedosto tallennetaan';
$string['filterall'] = 'Suodata kaikki merkkijonot';
$string['filtermatchoneperpage'] = 'Suodatin osuu kerran sivulla';
$string['filtermatchonepertext'] = 'Suodatin osuu kerran kohteessa';
$string['filters'] = 'Suodattimet';
$string['filtersettings'] = 'Suodatinasetukset';
$string['filtersettingsgeneral'] = 'Yleiset suotimen asetukset';
$string['filteruploadedfiles'] = 'Suodata lähetettyjä tiedostoja';
$string['forcelogin'] = 'Vaadi käyttäjiä kirjautumaan';
$string['forceloginforprofileimage'] = 'Pakota kirjautuminen käyttäjien kuvien näkymiseksi';
$string['forceloginforprofileimage_help'] = 'Jos käytössä, käyttäjien pitää kirjautua sisään nähdäkseen muiden käyttäjien profiilikuvat ja oletuskuvaa käytetään kaikissa ilmoitusviesteissä.';
$string['forceloginforprofiles'] = 'Vaadi kirjautuminen ennen käyttäjätietoja';
$string['forcetimezone'] = 'Määritä oletusaikavyöhyke';
$string['frontpage'] = 'Etusivu';
$string['frontpagebackup'] = 'Etusivun varmuuskopiointi';
$string['frontpagedefaultrole'] = 'Etusivulla käytettävä oletusrooli';
$string['frontpagefilters'] = 'Etusivun suodattimet';
$string['frontpageloggedin'] = 'Etusivun kohteet kun on kirjauduttu sisään';
$string['frontpageoverrides'] = 'Etusivun roolien kumoaminen';
$string['frontpagequestions'] = 'Etusivun kysymykset';
$string['frontpagerestore'] = 'Etusivun palautus';
$string['frontpageroles'] = 'Etusivun roolit';
$string['frontpagesettings'] = 'Etusivun asetukset';
$string['fullnamedisplay'] = 'Koko nimen muoto';
$string['gdrecommended'] = 'GD-lisäosaa käytetään kuvien konvertoimiseen, jos se puuttuu, jotkin ominaisuudet, kuten käyttäjien profiilikuvat, eivät ole käytettävissä.';
$string['generalsettings'] = 'Yleisasetukset';
$string['geoipfile'] = 'GeoIP kaupunki -datatiedosto';
$string['getremoteaddrconf'] = 'Lokissa olevan IP-osoitteen lähde';
$string['googlemapkey3'] = 'Google Maps -API V2 -avain';
$string['gotofirst'] = 'Siirry ensimmäiseen puuttuvaan merkkijonoon';
$string['gradebook'] = 'Arviointikirja';
$string['gradebookroles'] = 'Arvioitavat roolit';
$string['gradeexport'] = 'Ensisijaiset arvosanojen vientimetodit';
$string['groupenrolmentkeypolicy'] = 'Ryhmäkirjautumisavaimen käytäntö';
$string['groupenrolmentkeypolicy_desc'] = 'Tämän päälle laittaminen pistää Moodlen vertaamaan ryhmäkirjautumisavaimia kelvolliseen salasanakäytäntöön.';
$string['guestroleid'] = 'Rooli vierailijalle';
$string['guestroleid_help'] = 'Tätä roolia sovelletaan automaattisesti vierailija-käyttäjäryhmään. Sitä käytetään väliaikaisesti myös kurssialueelle kirjautumattomiin käyttäjiin, jotka tulevat kurssialueelle vierailijoille tarkoitetun lisäosan kautta.';
$string['helpadminseesall'] = 'Näkevätkö ylläpitäjät kaikki kalenterimerkinnät, vaiko vain heitä itseään koskevat?';
$string['helpforcetimezone'] = 'Voit antaa käyttäjien valita aikavyöhykkeensä otse, tai voit valita aikavyöhykkeen, joka koskee kaikkia.';
$string['helpsitemaintenance'] = 'Päivityksille ja muulle työlle';
$string['helpstartofweek'] = 'Mikä on viikon ensimmäinen päivä?';
$string['helpupcominglookahead'] = 'Kuinka monen päivän päähän tulevaisuuteen kalenteri etsii tapahtumia?';
$string['helpupcomingmaxevents'] = 'Mikä on oletuksena suurin määrä tapahtumia, joka näytetään käyttäjille?';
$string['helpweekenddays'] = 'Mitä päiviä pidetään "viikonloppuna" ja näytetään eri värillä?';
$string['hiddenuserfields'] = 'Piilota käyttäjätietokentät';
$string['hidefromall'] = 'Piilota kaikilta käyttäjiltä';
$string['hidefromnone'] = 'Älä piilota keneltäkään';
$string['hidefromstudents'] = 'Piilota opiskelijoilta';
$string['htmleditor'] = 'HTML-editori';
$string['htmleditorsettings'] = 'HTML-editorin asetukset';
$string['htmlsettings'] = 'HTML-asetukset';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP-tietoturva';
$string['iconvrecommended'] = 'Valinnaisen ICONV-kirjaston asentamista suositellaan suorituskyvyn parantamiseksi erityisesti silloin jos sivustolla käytetään useita eri kieliä ja kieliä joilla käytetään muita kun latinalaisia merkkejä.';
$string['iconvrequired'] = 'ICONV-laajennuksen asennusta vaaditaan.';
$string['ignore'] = 'Ohita';
$string['includemoduleuserdata'] = 'Ota mukaan moduulien käyttäjädata.';
$string['incompatibleblocks'] = 'Yhteensopimattomia lohkoja';
$string['installhijacked'] = 'Valitettavasti asennus täytyy suorittaa loppuun alkuperäisestä IP-osoitteesta.';
$string['installsessionerror'] = 'Ei voida aloittaa PHP-sessiota, ole hyvä ja varmista että selaimesi hyväksyy evästeet.';
$string['intlrecommended'] = 'Intl -lisäosaa käytetään parantamaan kansainvälisyyden tukea, kuten järjestämistä sijainnin mukaan.';
$string['invalidsection'] = 'Virheellinen valinta';
$string['invaliduserchangeme'] = 'Käyttäjänimi "changeme" on varattu. Et voi käyttää sitä tunnuksen luontiin.';
$string['ipblocked'] = 'Sivusto ei ole tällä hetkellä saatavissa.';
$string['ipblocker'] = 'IP-rajoitus';
$string['iplookup'] = 'IP-osoitteiden tarkistus';
$string['iplookupmaxmindnote'] = 'Tämä tuote sisältää GeoLite-tiedot, jotka on luonut MaxMind. Ne ovat saatavilla osoitteesta <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Säilytä tunnisteiden nimien isot kirjaimet';
$string['lang'] = 'Oletuskieli';
$string['langcache'] = 'Puskuroi kielivalikko';
$string['langlist'] = 'Kielivalikon kielet';
$string['langmenu'] = 'Näytä kielivalikko';
$string['langpackwillbeupdated'] = 'HUOMAA: Moodle yrittää ladata päivityksiä kielipaketteihisi päivityksen aikana.';
$string['langstringcache'] = 'Sijoita kaikki merkkijonot välimuistiin';
$string['languagesettings'] = 'Kieliasetukset';
$string['latexpreamble'] = 'LaTeX-esikomennot';
$string['latexsettings'] = 'LaTeX-piirtoasetukset';
$string['latinexcelexport'] = 'Excel-merkistö';
$string['legacyfilesinnewcourses'] = 'Perinteiset kurssitiedostot uusilla kursseilla';
$string['legacyfilesinnewcourses_help'] = 'Oletuksena perinteiset kurssien tiedostoalueet ovat saatavilla vain päivitetyillä kursseilla. Ole hyvä ja huomaa että jotkin ominaisuudet, kuten yksittäisen aktiviteetin varmuuskopiointi/palauttaminen ei ole yhteensopiva tämän asetuksen kanssa.';
$string['licensesettings'] = 'Lisenssiasetukset';
$string['loading'] = 'Ladataan';
$string['localetext'] = 'Sivuston maa-asetus';
$string['localstringcustomization'] = 'Paikalliset kielimuokkaukset';
$string['location'] = 'Sijainti';
$string['locationsettings'] = 'Sijaintiasetukset';
$string['locked'] = 'lukittu';
$string['log'] = 'Lokit';
$string['logguests'] = 'Kirjaa vierailijatunnuksen käyttö lokiin';
$string['loginhttps'] = 'Käytä HTTPS:ssää kirjautumiseen';
$string['loginpageautofocus'] = 'Valitse kirjautumiskenttä automaattisesti';
$string['loginpageautofocus_help'] = 'Tämän asetuksen ottaminen käyttöön parantaa kirjautumissivun käytettävyyttä, mutta kentän automaattinen valinta saattaa myös vaikuttaa saavutettavuuteen.';
$string['loginpasswordautocomplete'] = 'Estä salasanan automaattinen täydentäminen kirjautumislomakkeella.';
$string['loginpasswordautocomplete_help'] = 'Jos tämä asetus ei ole päällä, käyttäjät voivat tallentaa tilinsä salasanan selaimiinsa. Asetuksen päälle pistäminen johtaa siihen, ettei sivustosi enää noudata XHTML-strict validointisääntöjä.';
$string['loglifetime'] = 'Säilytä lokeja';
$string['longtimewarning'] = '<b>Tämä toiminto saattaa kestää pitkään.</b>';
$string['maintenancemode'] = 'Huoltotilassa';
$string['maintfileopenerror'] = 'Virhe avattaessa huoltotiedostoja';
$string['maintinprogress'] = 'Huoltotoimet ovat käynnissä...';
$string['managelang'] = 'Hallitse';
$string['managelicenses'] = 'Hallitse lisenssejä';
$string['manageqbehaviours'] = 'Hallitse kysymysten käyttäytymisiä';
$string['manageqtypes'] = 'Hallitse kysymystyyppejä';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Julkaisukandidaatti';
$string['maturity200'] = 'Vakaa versio';
$string['maturity50'] = 'Alpha';
$string['maturitycoreinfo'] = 'Sivustosi suorittaa tällä hetkellä epävakaata "{$a}" kehityskoodia.';
$string['maxbytes'] = 'Lähetetyn tiedoston suurin koko';
$string['maxconsecutiveidentchars'] = 'Perättäiset identtiset merkit';
$string['maxeditingtime'] = 'Viestien pisin muokkausaika';
$string['mbstringrecommended'] = 'Valinnaisen MBSTRING-kirjaston asentamista suositellaan suorituskyvyn parantamiseksi erityisesti silloin jos sivustolla käytetään useita eri kieliä.';
$string['mediapluginavi'] = 'Käytä .avi-suodatinta';
$string['mediapluginflv'] = 'Käytä .flv-suodatinta';
$string['mediapluginimg'] = 'Salli linkitettyjen kuvien automaattinen upotus';
$string['mediapluginmov'] = 'Käytä .mov-suodatinta';
$string['mediapluginmp3'] = 'Käytä .mp3-suodatinta';
$string['mediapluginmpg'] = 'Käytä .mpg-suodatinta';
$string['mediapluginogg'] = 'Ota käyttöön .ogg -suodatin';
$string['mediapluginogv'] = 'Ota käyttöön .ogv -suodatin';
$string['mediapluginram'] = 'Käytä .ram-suodatinta';
$string['mediapluginrm'] = 'Käytä .rm-suodatinta';
$string['mediapluginrpm'] = 'Käytä .rpm-suodatinta';
$string['mediapluginswf'] = 'Käytä .swf-suodatinta';
$string['mediapluginswfnote'] = 'Oletusarvoisena varotoimenpiteenä peruskäyttäjien ei pitäisi antaa upottaa swf- tai flash-tiedostoja.';
$string['mediapluginwmv'] = 'Käytä .wmv-suodatinta';
$string['mediapluginyoutube'] = 'Käytä YouTube-linkkien filtteriä';
$string['messaging'] = 'Käytä viestijärjestelmää';
$string['messagingdeletereadnotificationsdelay'] = 'Poista luetut ilmoitukset';
$string['messaginghidereadnotifications'] = 'Piilota luetut ilmoitukset';
$string['minpassworddigits'] = 'Numerot';
$string['minpasswordlength'] = 'Salasanan pituus';
$string['minpasswordlower'] = 'Pienet kirjaimet';
$string['minpasswordnonalphanum'] = 'Muut kuin aakkosnumeeriset merkit';
$string['minpasswordupper'] = 'Isot kirjaimet';
$string['misc'] = 'Muut';
$string['mnetrestore_extusers'] = '<strong>Huomaa:</strong> Tämä varmuuskopiotiedosto sisältää etä-Moodleverkon käyttäjätilejä, jotka palautetaan osana prosessia.';
$string['modeditdefaults'] = 'Aktiviteettiasetusten oletusarvot';
$string['modsettings'] = 'Aktiviteettien hallinta';
$string['modulesecurity'] = 'Moodlen tietoturva';
$string['multilangforceold'] = 'Pakota vanha multilang -syntaksi: &lt;span&gt; ilman class="multilang" sekä &lt;lang&gt;';
$string['mustenablestats'] = 'Sivustolla ei ole otettu käyttöön tietojentilastointia';
$string['mycoursesperpage'] = 'Kurssien määrä';
$string['mydashboard'] = 'Järjestelmän oletuskojelauta';
$string['mymoodle'] = 'Oma Moodle';
$string['mymoodleredirect'] = 'Pakota käyttäjät käyttämään Oma Moodle -sivua';
$string['mypage'] = 'Oma Moodle -oletussivu';
$string['mypagelocked'] = 'Lukitse oletussivu';
$string['myprofile'] = 'Profiilin oletussivu';
$string['mysql416bypassed'] = 'Kuitenkin jos teidän sivustonne käyttää vain iso-8859-1 merkistöä, te voitte jatkaa nykyisen mySQL 4.1.12 käyttöä.';
$string['mysql416required'] = 'MySQL 4.1.16 on  vähimmäisversio joka vaaditaan Moodle1.6:lle, jotta takaa, että kaikki data voidaan muuntaa UTF-8:ksi tulevaisuudessa';
$string['navadduserpostslinks'] = 'Lisää linkit käyttäjän viestien näyttämiseen';
$string['navadduserpostslinks_help'] = 'Jos käytössä, kaksi linkkiä lisätään jokaisen käyttäjän kohdalle joista pääsee näkemään käyttäjän aloittamat keskustelut sekä vastaukset viesteihin sivuston keskustelualueilla tai tiettyjen kurssien keskustelualueilla.';
$string['navcourselimit'] = 'Kurssin rajoitus';
$string['navshowallcourses'] = 'Näytä kaikki kurssit';
$string['navshowcategories'] = 'Näytä kurssikategoriat';
$string['neverdeleteruns'] = 'Älä koskaan poista ajoja';
$string['nobookmarksforuser'] = 'Sinulla ei ole suosikkeja';
$string['nodatabase'] = 'Ei tietokantaa';
$string['nohttpsformobilewarning'] = 'On suositeltavaa käyttää HTTPS:ää kelvollisen sertifikaatin kanssa. Moodle-sovellus yrittää aina ensin käyttää turvattua yhteyttä.';
$string['nomissingstrings'] = 'Ei puuttuvia merkkijonoja';
$string['nonewsettings'] = 'Päivityksessä ei tullut uusia asetuksia';
$string['nonexistentbookmark'] = 'Haluttua suosikkia ei ole';
$string['noresults'] = 'Ei tuloksia';
$string['noroles'] = 'Ei rooleja';
$string['notifications'] = 'Ilmoitukset';
$string['notifyloginfailures'] = 'Lähetä virheelliset kirjautumiset osoitteeseen';
$string['notifyloginthreshold'] = 'Raja-arvo email-ilmoituksille';
$string['notloggedinroleid'] = 'Rooli vierailijoille';
$string['numberofmissingstrings'] = 'Puuttuvien merkkijonojen määrä: {$a}';
$string['numberofstrings'] = 'Merkkijonojen kokonaismäärä: {$a->strings}<br />Puuttuu: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = 'Valinnaisen OpenSSL-kirjaston asennus on hyvin suositeltua -- se mahdollistaa Moodlen Verkkotyöskentelyn.';
$string['opentogoogle'] = 'Avoin Googlelle';
$string['optionalmaintenancemessage'] = 'Valinnainen huoltoviesti';
$string['order1'] = 'Ensimmäinen';
$string['order2'] = 'Toinen';
$string['order3'] = 'Kolmas';
$string['order4'] = 'Neljäs';
$string['passwordpolicy'] = 'Salasana-vaatimukset';
$string['pathconvert'] = '<i>convert</i> ohjelman sijainti';
$string['pathdvips'] = '<i>dvips</i>ohjelman sijainti';
$string['pathlatex'] = '<i>latex</i>  ohjelman sijainti';
$string['pathtoclam'] = 'clamav-ohjelman sijainti';
$string['pathtodot'] = 'Polku kohteeseen dot';
$string['pathtodu'] = 'su-ohjelman sijainti';
$string['pathtopgdump'] = 'pg_dump ohjelman sijainti';
$string['pathtopgdumpdesc'] = 'Tätä tarvitaan vain jos järjestelmässä on useita pg_dump työkaluja  asennettuna.';
$string['pathtopgdumpinvalid'] = 'Virheellinen pg_dump ohjelman sijainti';
$string['pathtopsql'] = 'Psql-ohjelman sijainti';
$string['pathtopsqldesc'] = 'Tätä tarvitaan vain jos järjestelmässä on useita postgresql asennuksia.';
$string['pathtopsqlinvalid'] = 'Polku psql on väärin';
$string['perfdebug'] = 'Suorituskykytiedot';
$string['performance'] = 'Suorituskyky';
$string['pgcluster'] = 'Postgresql ryväs';
$string['pgclusterdescription'] = 'Postgresql versio/ryväs parametri komentorivi toimintoihin. Jos järjestelmässä on vain yksi postgresql-palvelin tai olet epävarma asetuksesta jätä se tyhjäksi.';
$string['php50restricted'] = 'PHP 5.0.x versiossa on tunnettuja ongelmia, päivitä versioon 5.1.x tai palaa versioihin 4.3.x - 4.4.x';
$string['php533warning'] = 'PHP 5.3.3 tai uudempi on suositeltu';
$string['phpfloatproblem'] = 'Odottamaton virhe PHP-liukulukujen käsittelyssä - {$a}';
$string['pleaseregister'] = 'Ole hyvä ja rekisteröi sivustosi ja tämä painike poistuu';
$string['plugin'] = 'Moduuli';
$string['plugins'] = 'Moduulit';
$string['pluginschecktodo'] = 'Sinun pitää ensin ratkaista moduulin vaatimukset ennen sen asentamista tähän Moodle-versioon!';
$string['pluginsoverview'] = 'Moduulien yhteenveto';
$string['profilecategory'] = 'Kategoria';
$string['profilecategoryname'] = 'Kategorian nimi (oltava uniikki)';
$string['profilecategorynamenotunique'] = 'Tämä kategorian nimi on jo käytössä';
$string['profilecommonsettings'] = 'Yleiset asetukset';
$string['profilecreatecategory'] = 'Luo uusi profiilikategoria';
$string['profilecreatefield'] = 'Luo uusi profiilialue:';
$string['profilecreatenewcategory'] = 'Luodaan uutta kategoriaa';
$string['profilecreatenewfield'] = 'Luodaan uutta profiilialuetta {$a}';
$string['profiledefaultcategory'] = 'Muut kentät';
$string['profiledefaultchecked'] = 'Valittu oletuksena';
$string['profiledefaultdata'] = 'Oletusarvo';
$string['profiledeletecategory'] = 'Kategorian poistaminen';
$string['profiledeletefield'] = 'Kentän \'{$a}\' poistaminen';
$string['profiledescription'] = 'Kentän kuvaus';
$string['profiledscript'] = 'Skripti on profiloitu';
$string['profiledscriptview'] = 'Näytä profilointitiedot tälle skriptille';
$string['profileeditcategory'] = 'Muokataan kategoriaa {$a}';
$string['profileeditfield'] = 'Muokataan kenttää {$a}';
$string['profilefield'] = 'Profiilikenttä';
$string['profilefieldcolumns'] = 'Kolumnit';
$string['profilefieldispassword'] = 'Onko tämä salasanakenttä?';
$string['profilefieldlink'] = 'Linkki';
$string['profilefieldlinktarget'] = 'Linkin kohde';
$string['profilefieldmaxlength'] = 'Maksimipituus';
$string['profilefieldrows'] = 'Rivit';
$string['profilefields'] = 'Käyttäjäprofiilin kentät';
$string['profilefieldsize'] = 'Näytä koko';
$string['profileforceunique'] = 'Pitäisikö datan olla uniikkia?';
$string['profileinvaliddata'] = 'Epäkelpo arvo';
$string['profilelocked'] = 'Onko tämä kenttä lukittu?';
$string['profilemenudefaultnotinoptions'] = 'Oletusarvo ei ole yksi vaihtoehdoista';
$string['profilemenunooptions'] = 'Ei valikon vaihtoehtoja tarjolla';
$string['profilemenuoptions'] = 'Valikon vaihtoehdot (yksi per rivi)';
$string['profilemenutoofewoptions'] = 'Sinun pitää syöttää vähintään 2 vaihtoehtoa';
$string['profilename'] = 'Nimi';
$string['profilenofieldsdefined'] = 'Kenttiä ei ole määritelty';
$string['profilerequired'] = 'Onko tämä kenttä pakollinen?';
$string['profileroles'] = 'Profiilin näkyvät roolit';
$string['profilesforenrolledusersonly'] = 'Profiilit vain kurssille kirjautuneille käyttäjille';
$string['profileshortname'] = 'Lyhytnimi (pitää olla yksilöllinen)';
$string['profileshortnamenotunique'] = 'Tämä lyhytnimi on jo käytössä';
$string['profilesignup'] = 'Näytetäänkö rekisteröitymissivulla?';
$string['profilespecificsettings'] = 'Yksityiskohtaiset asetukset';
$string['profilevisible'] = 'Kenelle tämä kenttä on näkyvissä?';
$string['profilevisibleall'] = 'Näkyvissä kaikille';
$string['profilevisible_help'] = '* Ei näkyvissä - Yksityiset tiedot näkyvät ainoastaan ylläpitäjälle
* Näkyy käyttäjälle - Yksityiset tiedot näkyvät ainoastaan käyttäjälle ja ylläpitäjälle
* Näkyy kaikille';
$string['profilevisiblenone'] = 'Ei näkyvissä';
$string['profilevisibleprivate'] = 'Näkyvissä käyttäjälle';
$string['profiling'] = 'Profilointi';
$string['profilingallowall'] = 'Jatkuva profilointi';
$string['profilingallowme'] = 'Valikoiva profilointi';
$string['profilingautofrec'] = 'Automaattinen profilointi';
$string['profilingenabled'] = 'Salli profilointi';
$string['profilingexcluded'] = 'Pois sulje profilointi';
$string['profilingincluded'] = 'Profiloi nämä';
$string['profilinglifetime'] = 'Säilytä profilointiajot';
$string['protectusernames'] = 'Suojaa käyttäjätunnukset';
$string['proxybypass'] = 'Välityspalvelimen ohittavat isäntäpalvelimet';
$string['proxyhost'] = 'Välityspalvelin';
$string['proxypassword'] = 'Proxy-salasana';
$string['proxyport'] = 'Välityspalvelimen portti';
$string['proxytype'] = 'Välityspalvelimen tyyppi';
$string['proxyuser'] = 'Välityspalvelimen käyttäjänimi';
$string['purgecaches'] = 'Tyhjennä kaikki välimuistit';
$string['purgecachesfinished'] = 'Kaikki välimuistit tyhjennettiin.';
$string['quarantinedir'] = 'Karanteenihakemisto';
$string['question'] = 'Kysymys';
$string['questionbehaviours'] = 'Kysymysten käyttäytymiset';
$string['questiontype'] = 'Kysymystyyppi';
$string['questiontypes'] = 'Kysymystyypit';
$string['recaptchaprivatekey'] = 'Yksityinen reCAPTCHA-avain';
$string['recaptchapublickey'] = 'Julkinen reCAPTCHA-avain';
$string['register'] = 'Rekisteröi sivustosi';
$string['registerwithmoodleorg'] = 'Rekisteröi Moodle.orgiin';
$string['registration'] = 'Rekisteröinti';
$string['releasenoteslink'] = 'Lisätietoa tästä Moodlen versiosta löydät <a target="_new" href="{$a}">julkaisutiedoista</a>';
$string['rememberusername'] = 'Muista käyttäjänimi';
$string['reportsmanage'] = 'Hallinnoi raportteja';
$string['requiremodintro'] = 'Vaaditaan aktiviteetin kuvaus';
$string['requires'] = 'Vaaditaan';
$string['restorernewroleid'] = 'Palauttajan rooli kurssilla';
$string['restorernewroleid_help'] = 'Ellei käyttäjällä ole oikeuksia hallinnoida palautettua kurssia, hänet lisätään automaattisesti tähän rooliin. Valitse "Ei mitään" mikäli et halua lisätä käyttäjälle oikeuksia hallinnoida palautettua kurssia.';
$string['reverseproxy'] = 'Käännetty välityspalvelin';
$string['riskconfig'] = 'Käyttäjät voivat muuttaa sivuston asetuksia ja toimintaa';
$string['riskconfigshort'] = 'Konfiguraatioriski';
$string['riskdataloss'] = 'Käyttäjät voisivat tuhota suuria määriä sisältöä tai tietoa';
$string['riskdatalossshort'] = 'Tiedonhäviämisriski';
$string['riskmanagetrust'] = 'Käyttäjät voivat muuttaa käyttäjien asetuksia';
$string['riskmanagetrustshort'] = 'Hallitse luotettuja';
$string['riskpersonal'] = 'Käyttäjät voivat päästä muiden käyttäjien yksityiseen tietoon';
$string['riskpersonalshort'] = 'Yksityisyysriski';
$string['riskspam'] = 'Käyttäjät voivat lähettää roskapostia sivuston käyttäjille tai muille';
$string['riskspamshort'] = 'Roskapostiriski';
$string['riskxss'] = 'Käyttäjät voivat lisätä tiedostoja ja tekstejä, jotka sallivat cross-site-scripting hyökkäykset(XSS)';
$string['riskxssshort'] = 'XSS-riski';
$string['roleswithexceptions'] = '{$a->roles}, joissa {$a->exceptions}';
$string['rssglobaldisabled'] = 'Estetty palvelimen tasolta';
$string['runclamavonupload'] = 'Käytä clamAV:ta lähetettyihin tiedostoihin';
$string['save'] = 'Tallenna';
$string['savechanges'] = 'Tallenna muutokset';
$string['search'] = 'Hae';
$string['searchinsettings'] = 'Hae asetuksista';
$string['searchresults'] = 'Hakutulokset';
$string['sectionerror'] = 'Osiovirhe!';
$string['secureforms'] = 'Lomaketietojen turvallisuuskäsittely';
$string['security'] = 'Tietoturva';
$string['selectdevice'] = 'Valitse laite';
$string['selecttheme'] = 'Valitse teema laitteelle {$a}';
$string['server'] = 'Palvelin';
$string['serverchecks'] = 'Palvelimen tarkistukset';
$string['serverlimit'] = 'Palvelimen rajoitus';
$string['sessioncookie'] = 'Evästeen etuliite';
$string['sessioncookiedomain'] = 'Evästeen domain';
$string['sessioncookiepath'] = 'Evästeen polku';
$string['sessionhandling'] = 'Istunnonhallinta';
$string['sessiontimeout'] = 'Aikaraja';
$string['settingfileuploads'] = 'Tiedoston lähettäminen vaaditaan normaaliin toimintaan, ole hyvä ja salli se PHP-asetuksista.';
$string['settingmemorylimit'] = 'Havaittiin riittämätön muisti, ole hyvä ja aseta korkeampi muistiraja PHP-asetuksista.';
$string['settingsafemode'] = 'Moodle ei ole täysin yhteensopiva turvamoodin kanssa, ole hyvä ja pyydä palvelimen ylläpitäjää ottamaan se pois käytöstä. Moodlen ajamista turvamoodissa ei tueta ja tämä aiheuttaa useita ongelmia.';
$string['showcommentscount'] = 'Näytä kommenttien määrä';
$string['showdetails'] = 'Näytä yksityiskohdat';
$string['showuseridentity'] = 'Näytä käyttäjän identiteetti';
$string['showuseridentity_desc'] = 'Valittaessa tai etsittäessä käyttäjiä ja näytettäessä listaa käyttäjistä, nämä kentät näytetään käyttäjän nimen lisäksi. Tiedot näytetään ainoastaan käyttäjille joilla on kyky moodle/site:viewuseridentity; oletuksena opettajat ja hallinnoijat (tämä asetus on hyödyllisin jos valitset yksi tai kaksi organisaatiossasi pakolliseksi määriteltyä kenttää).';
$string['simplexmlrequired'] = 'Moodle vaatii nyt SimpleXML PHP -lisäosan.';
$string['sitemaintenance'] = 'Sivusto on huoltotilassa eikä se ole nyt saatavilla';
$string['sitemaintenancemode'] = 'Huoltotila';
$string['sitemaintenanceoff'] = 'Huoltotila on kytketty pois ja sivusto toimii taas normaalisti';
$string['sitemaintenanceon'] = 'Sivustosi on parhaimmillaan huoltotilassa (vain ylläpitäjät voivat kirjautua sisään tai käyttää sivustoa).';
$string['sitemaintenancewarning'] = 'Sivustosi on parhaillaan huoltotilassa (vain ylläpitäjät voivat kirjautua sisään). Palauttaaksesi sivuston takaisin normaaliin tilaan <a href="maintenance.php">kytke ylläpitotila pois päältä</a>.';
$string['sitemaintenancewarning2'] = 'Sivustosi on parhaillaan huoltotilassa (vain ylläpitäjät voivat kirjautua sisään). Palauttaaksesi sivuston takaisin normaaliin tilaan <a href="{$a}">kytke ylläpitotila pois päältä</a>.';
$string['sitepolicies'] = 'Sivuston käyttöehdot';
$string['sitepolicy'] = 'Sivuston käyttöehtojen osoite';
$string['sitepolicyguest'] = 'Sivuston käyttösopimuksen web-osoite vierailijoille';
$string['sitepolicyguest_help'] = 'Jos sinulla on sivuston käyttöehdot, jotka kaikkien täytyy nähdä ja hyväksyä ennen sivuston käyttämistä, määritä niiden URL-osoite tässä, muussa tapauksessa jätä kenttä tyhjäksi. Tämä asetus voi sisältää minkä tahansa julkisen URL-osoitteen. Huomaa: ei-kirjautuneiden käyttäjien pääsy voidaan estää forcelogin -asetuksella.';
$string['sitepolicy_help'] = 'Jos sivustollasi on käyttösopimus, joka käyttäjien pitää lukea ja hyväksyä, määritä tuon sopimuksen osoite tähän, muutoin voit jättää kohdan tyhjäksi. Osoite voi viitata mihin vain - yksi ratkaisu on tiedosto sivuston tiedostoissa, esim. ´http://sivustosi.php/policy.html´';
$string['sitesectionhelp'] = 'Valittaessa aihealue näytetään sivuston etusivulla.';
$string['slasharguments'] = 'Käytä \'/\'-eroteltuja argumentteja';
$string['smartpix'] = 'Smart pix -haku';
$string['soaprecommended'] = 'Tämän valinnaisen soap-laajennuksen asentaminen on hyödyllinen web services -palvelujen ja joidenkin lisämoduulien osalta.';
$string['spellengine'] = 'Tavauskone';
$string['spelllanguagelist'] = 'Tavutuksen kielten lista';
$string['splrequired'] = 'Moodle vaatii nyt SPL PHP -lisäosan.';
$string['stats'] = 'Tilastot';
$string['statsfirstrun'] = 'Enimmäiskäsittelyaika';
$string['statsmaxruntime'] = 'Maksimi suoritusaika';
$string['statsmoodleorg'] = 'tilastot';
$string['statsruntimedays'] = 'Käsiteltäviä päiviä';
$string['statsruntimestart'] = 'Suorita';
$string['statsuserthreshold'] = 'Käyttäjäraja';
$string['stickyblocks'] = 'Pysyvät lohkot';
$string['stickyblockscourseview'] = 'Kurssi sivu';
$string['stickyblocksduplicatenotice'] = 'Jos joku lohkoista jonka lisäät,on ennestään jollakin sivulla, näkyy lohko kahtena.<br? /> , Aikaisempi versio lohkosta pysyy käyttäjän muokattavissa.';
$string['stickyblocksmymoodle'] = 'Oma Moodle';
$string['stickyblockspagetype'] = 'Sivu jota määritellään';
$string['strictformsrequired'] = 'Vaadittujen kenttien tiukka validointi';
$string['stripalltitletags'] = 'Poista HTML-tagit kaikista aktiviteettien nimistä';
$string['supportcontact'] = 'Tuen yhteyshenkilö';
$string['supportemail'] = 'Tuen sähköpostiosoite';
$string['supportname'] = 'Tuen nimi';
$string['supportpage'] = 'Tuen sivu';
$string['suspenduser'] = 'Estä käyttäjätilin käyttö';
$string['switchlang'] = 'Vaihda lang-kansio';
$string['systempaths'] = 'Järjestelmän polut';
$string['tablenosave'] = 'Muutokset yläpuolisessa taulussa tallennetaan automaattisesti.';
$string['tablesnosave'] = 'Muutokset yläpuolisissa tauluissa tallennetaan automaattisesti.';
$string['tabselectedtofront'] = 'Taulukoissa, joissa on välilehtiä, pitäisikö valittuna oleva väliehti sijoittaa päällimmäiseksi?';
$string['tabselectedtofronttext'] = 'Tuo valittu välilehti eteen';
$string['themedesignermode'] = 'Teemasuunnittelijan moodi';
$string['themelist'] = 'Teemalista';
$string['themenoselected'] = 'Ei teemoja valittuna';
$string['themeresetcaches'] = 'Tyhjennä teemojen välimuisti';
$string['themeselect'] = 'Vaihda teema';
$string['themeselector'] = 'Teeman valinta';
$string['themesettings'] = 'Teeman asetukset';
$string['therewereerrors'] = 'Tiedoissasi oli virheitä';
$string['timezone'] = 'Oletusaikavyöhyke';
$string['timezoneforced'] = 'Tämän on valinnut sivuston ylläpitäjä';
$string['timezoneisforcedto'] = 'Pakota kaikki käyttäjät käyttämään';
$string['timezonenotforced'] = 'Käyttäjät voivat oman aikavyöhykkeensä';
$string['tokenizerrecommended'] = 'Valinnaisen PHP Tokenizer -lisäosan asennus on suositeltua -- se parantaa Moodlen Verkkotyöskentelytoiminnallisuutta.';
$string['tools'] = 'Ylläpitäjän työkalut';
$string['toolsmanage'] = 'Hallinnoi ylläpitäjän työkaluja';
$string['unattendedoperation'] = 'Vahtimaton toiminta';
$string['unbookmarkthispage'] = 'Poista suosikeista';
$string['uninstallplugin'] = 'Poista';
$string['unsettheme'] = 'Poista teema käytöstä';
$string['unsupported'] = 'Ei tuettu';
$string['unsuspenduser'] = 'Aktivoi käyttäjätili';
$string['updateaccounts'] = 'Päivitä olemassa olevat tilit';
$string['updateavailable_moreinfo'] = 'Lisää tietoa...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versio {$a}';
$string['updatecomponent'] = 'Päivitä komponentti';
$string['updatenotifications'] = 'Päivitysilmoitukset';
$string['updatenotificationsubject'] = 'Moodle-sivustollesi on saatavilla päivityksiä';
$string['upgrade197noticesubject'] = 'Moodle 1.9.7 päivityksen tietoturvahuomiot';
$string['upgradeerror'] = 'Tuntematon virhe päivitettäessä {$a->plugin} versioon {$a->version}, ei voida jatkaa.';
$string['upgradeforumread'] = 'Moodle 1.5een on lisätty uusi ominaisuus, jolla voidaan seurata luettuja ja lukemattomia viestejä keskustelupalstoilla. .<br />Käyttääksesi tätä ominaisuutta sinun pitää <a href="{$a}">päivittää taulukkosi</a>.';
$string['upgradeforumreadinfo'] = 'Moodle 1.5een on lisätty uusi ominaisuus, jolla voidaan seurata luettuja ja lukemattomia viestejä keskustelupalstoilla. Käyttääksesi tätä ominaisuutta sinun pitää päivittää taulukkosi kaikella seurantatiedolla, joka liittyy olemassa oleviin viesteihin. Riippuen sivustosi koosta tähän voi mennä kauan (tunteja) ja olla varsin vaativaa tietokannallesi, joten päivittäminen on parasta tehdä hiljaisena aikana. Päivitys ei kuitenkaan vaikuta sivustosi toimintaan, eikä sillä ole vaikutuksia käyttäjiisi. Kun aloitat päivityksen, anna sen tulla valmiiksi, äläkä siis sulje selaimen ikkunaa. Jos kuitenkin pysäytät päivityksen sulkemalla selainikkunan, älä huolehdi, päivityksen voi aloittaa uudelleen. <br /><br />Haluatko aloittaa päivityksen nyt?';
$string['upgradelogs'] = 'Tapahtumalokien sisällöt pitää päivittää uuteen muotoon. <a href="{$a}">Lisätietoja</a>';
$string['upgradelogsinfo'] = 'Tapahtumalokien tallennuksessa on tapahtunut muutoksia. Jotta voisit tarkastella lokeja uudella tavalla, vanhat lokimerkinnät pitää päivittää uuteen muotoon. Tämä tapahtuu automaattisesti eikä häiritse sivustosi muuta käyttöä. Riippuen sivustosi koosta tähän saattaa kuitenkin mennä aikaa jopa useita tunteja. Kun aloitat päivityksen, pitää sen antaa mennä loppuun asti keskeyttämättä.
<br /><br />
Haluatko päivittää lokit nyt?';
$string['upgradepluginsinfo'] = 'Päivitetään moduuleja';
$string['upgradesettings'] = 'Uudet asetukset';
$string['upgradesettingsintro'] = 'Alla olevat asetukset lisättiin Moodlen päivityksen aikana. Tee haluamasi muutokset oletuksiin ja klikkaa <strong>Tallenna muutokset</strong> sivun alareunasta.';
$string['upgradestart'] = 'Päivitä Moodlen tietokanta nyt';
$string['upgradesure'] = 'Moodlen asennustiedostot ovat muuttuneet, järjestelmä tullaan päivittämään uuteen versioon automaattisesti. Uusi versio on:
 <p><b>{$a}</b></p>
<p>Kun aloitat päivittämisen, et voi enää palata takaisin aiempaan versioon.</p>
<p>Oletko varma, että haluat päivittää palvelimen?</p>';
$string['upgradetimedout'] = 'Päivitys aikakatkaistiin, aloita päivitys uudelleen.';
$string['upgradingdata'] = 'Päivitetään tietoja';
$string['upgradinglogs'] = 'Päivitetään tapahtumalokeja';
$string['upgradingversion'] = 'Päivitetään uuteen versioon';
$string['upwards'] = 'ylöspäin';
$string['useblogassociations'] = 'Salli assosiaatiot';
$string['useexternalyui'] = 'Käytä verkossa olevia YUI-kirjastoja';
$string['user'] = 'Käyttäjä';
$string['userbulk'] = 'Useiden käyttäjätietojen muokkaus';
$string['userlist'] = 'Selaa käyttäjiä';
$string['userpolicies'] = 'Käytännöt';
$string['userpreference'] = 'Käyttäjän valinnat';
$string['userquota'] = 'Käyttäjäkiintiö';
$string['users'] = 'Käyttäjät';
$string['usesitenameforsitepages'] = 'Käytä sivuston nimeä sivuston sivuilla';
$string['usetags'] = 'Salli tunnisteet -toiminnallisuus';
$string['validateerror'] = 'Tämä arvo ei kelvannut:';
$string['verifychangedemail'] = 'Rajoita domaineja vaihdettaessa sähköpostia';
$string['warningcurrentsetting'] = 'Virheellinen nykyinen arvo: {$a}';
$string['webproxy'] = 'Verkon vältyspalvelin';
$string['xmlrpcrecommended'] = 'xmlrpc-lisäosa tarvitaan hubien kanssa kommunikointiin. Se on myös käytännöllinen verkkopalveluissa ja Moodlen verkkotyöskentelyssä';
$string['yuicomboloading'] = 'YUI combo lataa';
$string['ziprequired'] = 'Moodle vaatii nyt Zip PHP -lisäosan, info-ZIP binääreitä tai PclZip:iä ei enää käytetä.';
