<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_uploaduser', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   tool_uploaduser
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allowdeletes'] = 'Tillat slettinger';
$string['allowrenames'] = 'Tillat omdøpning';
$string['allowsuspends'] = 'Tillater utkobling og aktivering av kontoer';
$string['csvdelimiter'] = 'CSV skilletegn';
$string['defaultvalues'] = 'Standard verdier';
$string['deleteerrors'] = 'Slett feil';
$string['encoding'] = 'Koding';
$string['errormnetadd'] = 'Kan ikke legge til eksterne brukere';
$string['errors'] = 'Feil';
$string['nochanges'] = 'Ingen endringer';
$string['pluginname'] = 'Brukeropplasting';
$string['renameerrors'] = 'Feil ved endring av navn';
$string['requiredtemplate'] = 'Nødvendig. Du kan bruke malsyntaks her (%l = etternavn, %f = fornavn, %u = brukernavn).';
$string['rowpreviewnum'] = 'Antall rader i forhåndsvisning';
$string['uploadpicture_baduserfield'] = 'Brukerattributten du spesifiserte er ikke gyldig. Vennligst prøv igjen.';
$string['uploadpicture_cannotmovezip'] = 'Kan ikke flytte zipfil til midlertid kontroll.';
$string['uploadpicture_cannotprocessdir'] = 'Kan ikke behandle uzippede filer.';
$string['uploadpicture_cannotsave'] = 'Kan ikke lagre bilde av brukeren {$a}. Sjekk orginalbildet.';
$string['uploadpicture_cannotunzip'] = 'Can ikke pakke opp bildefil.';
$string['uploadpicture_invalidfilename'] = 'Bildefila {$a} har ulovlige tegn i filnavnet. Hopper over.';
$string['uploadpicture_overwrite'] = 'Skriv over eksisterende brukerbilder?';
$string['uploadpictures'] = 'Last opp brukerbilder.';
$string['uploadpictures_help'] = '<p>Brukerbilder til profilene kan lastes opp som en zip-fil med bildefiler. Hvert bilde må navnes som <i>valgt-brukervariabel.filendelse</i>. F.eks. dersom en valgt brukervariabel er brukernavnet og brukernavnet er nilalf45, vil filnavnet på bildet bli "nilalf45.jpg".</p>
<p>Bildeformatene som støttes er gif, jpg og png.</p>
<p>Filnavn for bilder er ikke sensitive for store/små bokstaver.</p>';
$string['uploadpicture_userfield'] = 'Brukeregenskaper som brukes for å matche bilder:';
$string['uploadpicture_usernotfound'] = 'Bruker med \'{$a->userfield}\' verdi av \'{$a->uservalue}\' eksisterer ikke. Hopper over.';
$string['uploadpicture_userskipped'] = 'Hopper over brukeren {$a} (har allerede bilde).';
$string['uploadpicture_userupdated'] = 'Bilde lastet opp for brukeren {$a}.';
$string['uploadusers'] = 'Last opp brukere';
$string['uploadusers_help'] = '<p>Aller  først: Merk at <strong>det vanligvis ikke er nødvendig å importere brukere fra fil</strong>. Hvis du kan unngå det sparer du mye manuelt arbeid med brukerhåndtering. Sjekk først om en av autentiseringsmodulene kan være det du trenger, f.eks. modulen for tilkobling til ekstern brukerdatabase.</p>
<p>Dersom du er sikker på at du vil importere mange brukere fra en tekstfil, må du passe på å formatere tekstfilen slik: </p>

<ul>
  <li>Hver linje skal bare ha data for en bruker</li>
  <li>Hver rad er en serie data atskilt med kommategn (eller andre skilletegn)</li>
  <li>Den første raden er spesiell siden den inneholder alle feltnavnene. Denne raden definerer formatet for resten av fila.
    <blockquote>
      <p><strong>Obligatoriske feltnavn:</strong> disse feltene må være med i første rad og definert for hver bruker:</p>
      <p><code class="example1">username, password, firstname, lastname, email</code></p>

      <p><strong>Standard feltnavn:</strong> disse er valgfrie. Dersom de ikke er med tas verdien fra hovedadministratorkontoen.</p>
      <p><code class="example1">institution, department, city, country, lang, auth, timezone</code> </p>
      <p><strong>Valgfrie feltnavn: </strong> alle disse feltnavnene er helt valgfrie. Kursnavnet skal være kortnavnet på kurset. Dersom det tas med vil brukerne bli påmeldt som studenter i de kursene. Gruppenavn må kobles til kurs;  group1 til course1, etc.</p>
      <p> <code class="example1">idnumber,
icq, phone1, phone2, address, url, description, mailformat,
maildisplay, htmleditor, autosubscribe, course1, course2, course3,
course4, course5, group1, group2, group3, group4, group5, type1, type2,
type3, type4, type5, role1, role2, role3, role4, role5, emailstop</code></p>
    </blockquote>
    </li>
  <li>Kommategn i dataene skal kodes som  &amp;#44 - skriptet vil konvertere dette automatisk tilbake til kommategn.</li>
  <li>For Booleanske felt, bruk 0 for usant og 1 for sant. </li>
  <li>"Types" brukes til å fortelle Moodle om brukeren er en student eller en lærer, dersom samsvarende kurs finnes. (type1 hører til course1 osv.) 1 =
Student, 2 = Lærer, og 3 = Gjestelærer. Hvis Type-feltet er tomt eller det ikke er angitt et kurs, blir brukeren tildelt standardrollen "Student".</li>
  <li>Bruk kortnavn for kurs, for grupper skal gruppenavn brukes, for roller skal rolleID brukes.</li>
  <li>Merk: Dersom en bruker allerede finnes i Moodle database vil skriptet returnere brukerID for brukeren og vil melde brukeren inn som student i alle angitte kurs UTEN å oppdatere med angitte data forøvrig.</li>
</ul>

<p>Her er et eksempel på en gyldig importfil:</p>
<p><code>username, password, firstname, lastname, email, lang, idnumber, maildisplay, course1, group1, type1<br>
jonest, verysecret, Tom, Jones, jonest@someplace.edu, en, 3663737, 1, Intro101, Section 1, 1<br>
reznort, somesecret, Trent, Reznor, reznort@someplace.edu, en_us, 6736733, 0, Advanced202, Section 3, 3
</code></p>

<h2>Maler</h2>
<p>Standardverdier blir behandlet som maler hvor følgende koder er tillatt:</p>
<ul>
<li><code>%l</code> - vil bli erstattet med etternavn</li>
<li><code>%f</code> - vil bli erstattet med fornavn</li>
<li><code>%u</code> - vil bli erstattet med brukernavn</li>
<li><code>%%</code> - vil bli erstattet med %</li>
</ul>
<p>Mellom prosenttegnet  (%) og en kodebokstav (l, f eller u) er følgende modifikatorer tillatt:</p>
<ul>
<li>(-) minustegn - informasjonen som angis via kodebokstaven blir konvertert til små bokstaver</li>
<li>(+) plusstegn - informasjonen som angis via kodebokstaven blir konvertert til STORE BOKSTAVER</li>
<li>(~) tildetegn - informasjonen som angis via kodebokstaven blir formatert som tittel</li>
<li>et desimaltall - informasjonen som angis via kodebokstaven vil bli avkortet til angitt antall tegn</li>
</ul>

<p>F.eks. dersom fornavnet er "John" og etternavnet er "Doe", vil følgende malvariabler gi resultatene:</p>
<ul>
<li>%l%f = DoeJohn</li>
<li>%l%1f = DoeJ</li>
<li>%-l%+f = doeJOHN</li>
<li>%-f_%-l = john_doe</li>
<li>http://www.example.com/~%u/ = http://www.example.com/~jdoe/ (dersom brukernavnet er jdoe eller %-1f%-l)</li>
</ul>

<p>Kjøring som mal gjøres kun med standard verdier og ikke på basis av verdiene som mottas fra CSV-fila.</p>
<p>For å kunne opprette korrekte Moodle brukernavn, bli brukernavnet alltid konvertert til små bokstaver. Så sant "TIllat utvidet karaktersett i brukernavn" er deaktivert vil alle tegn som ikke er bokstaver, tall, bindestrek og punktum bli fjernet. Hvis f.eks. fornavnet er John Jr. og etternavnet Doe, vil brukernavnformelen  %-f_%-l gi som resultat:  "john jr._doe" når utvidede brukernavn er tillatt og  "johnjr.doe" når det ikke er tillatt.</p>

<p>Dersom håndtering av duplikate brukernavn er aktivert, vil stigende nummer bli lagt til brukernavnet for å gjøre det unikt. Hvis f.eks. CSV-fila inneholder brukere med navnene John Doe, Jane Doe and Jenny Doe uten dedikerte brukernavn vil %-1f%-l og aktivert duplikathåndtering med stigende teller gi brukernavnene: jdoe, jdoe2 and jdoe3.</p>

<h2>Oppdatering av eksisterende kontoer</h2>

<p>Som standard antar Moodle at du bare vil opprette nye kontoer og beholde eksisterende. Du kan likevel sette "Oppdater eksisterende kontoer" til "Ja" for også å oppdatere alle brukerkontoer som allerede eksisterte.</p>

<p>Når eksisterende brukerkontoer endres, kan du også endre brukernavnet. Sett "Tillat endre navn" til "Ja" og ta med feltet <code class="example1">oldusername</code> i importfila .</p>

<p><b>Advarsel:</b> Vær forsiktig når du oppdaterer eksisterende brukere på denne måten. Du risikerer i verste fall å ødelegge brukerkontoer fullstendig.</p>

<h2>Slette kontoer</h2>
<p>Dersom feltet <code>deleted</code> tas med i CSV-fila vil brukere med verdien "1" bli slettet. I slike tilfeller kan alle andre felt på raden utelates, unntatt  <code>username</code>.</p>
<p>Sletting og import av brukerkontoer kan gjøres i samme CSV-fil. F.eks. vil følgende kode legge til brukeren Tom Jones og slette brukeren reznort:</p>
<p><code>username, firstname, lastname, deleted<br />
jonest, Tom, Jones, 0<br />
reznort, , , 1
</code></p>';
$string['uploaduserspreview'] = 'Last opp brukernes forhåndsvisning.';
$string['uploadusersresult'] = 'Last opp brukerresultater';
$string['uploaduser:uploaduserpictures'] = 'Last opp brukerbilder';
$string['useraccountupdated'] = 'Oppdaterte bruker';
$string['useraccountuptodate'] = 'Brukeren er oppdatert';
$string['userdeleted'] = 'Bruker slettet';
$string['userrenamed'] = 'Bruker er omdøpt';
$string['userscreated'] = 'Opprettet brukere';
$string['usersdeleted'] = 'Brukere slettet';
$string['usersrenamed'] = 'Brukere er omdøpt';
$string['usersskipped'] = 'Bruker hoppet over';
$string['usersupdated'] = 'Oppdaterte brukere';
$string['usersweakpassword'] = 'Brukere med for svakt passord';
$string['uubulk'] = 'Velg for massehandlinger';
$string['uubulkall'] = 'Alle brukere';
$string['uubulknew'] = 'Nye brukere';
$string['uubulkupdated'] = 'Oppdaterte brukere';
$string['uucsvline'] = 'CSV linje';
$string['uulegacy1role'] = '(Original Student) typeN=1';
$string['uulegacy2role'] = '(Original Lærer) typeN=2';
$string['uulegacy3role'] = '(Original Ikkeredigerende lærer) typeN=3';
$string['uunoemailduplicates'] = 'Forhindre duplikate epostadresser';
$string['uuoptype'] = 'Last opp type';
$string['uuoptype_addinc'] = 'Legg til alle, legg til nummer til brukernavn hvis det trengs.';
$string['uuoptype_addnew'] = 'Bare legg til nye, hopp over eksisterende brukere';
$string['uuoptype_addupdate'] = 'Legg til nye og oppdater eksisterende brukere';
$string['uuoptype_update'] = 'Bare oppdater eksisterende brukere';
$string['uupasswordcron'] = 'Generert i cron';
$string['uupasswordnew'] = 'Nytt brukerpassord';
$string['uupasswordold'] = 'Eksisterende brukerpasord';
$string['uustandardusernames'] = 'Standardiser brukernavn';
$string['uuupdateall'] = 'Overstyr med fil og standarder';
$string['uuupdatefromfile'] = 'Overstyr med fil';
$string['uuupdatemissing'] = 'Fyll inn det som mangler fra fil og standarder';
$string['uuupdatetype'] = 'Eksisterende brukerdetaljer';
$string['uuusernametemplate'] = 'Mal for brukernavn';
