<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_arialist', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_arialist
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
	<div class="theme_screenshot">

		<h2>Arialist</h2>
		<img src="arialist/pix/screenshot.png" />

		<h3>Designets diskusjonsforum:</h3>
		<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

		<h3>Designkreditering</h3>
		<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>

		<h3>Designdokumentasjon:</h3>
		<p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>

		<h3>Rapporter en feil:</h3>
		<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
	</div>

	<div class="theme_description">
		<h2>About</h2>
		<p>Arialist er et meget rent og enkelt to-kolonners design med fleksibel bredde for Moodle 2.0.</p>

		<h2>Tilpasninger</h2>
		<p>Dette designet er bygd på Basic- og Canvasdesignene, to overordnede design i Moodlekjernen. Dersom du ønsker å tilpasse dette designet, anbefaler vi at du dupliserer og endrer navn på det før du gjør noen endringer. Dette vil forhindre at ditt tilpassede design blir overskrevet av fremtidige Moodleoppgraderinger, og du vil fremdeles ha originaldesignet dersom du roter det skikkelig til. Mer informasjon om skreddersøm av design kan du finne i <a href="http://docs.moodle.org/en/Theme">MoodleDocs</a>.</p>

	<h2>Kreditering</h2>
	<p>Dette designet er utviklet og vedlikeholdes av Patrick Malley ved NewSchool Learning. Han kan kontaktes på contact@newschoollearning.com. </p>

		<h2>Lisens</h2>
		<p>Dette og alle andre design inkludert i Moodlekjernen er lisensiert under <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.
	</div>
</div>';
$string['configtitle'] = 'Arialist innstillinger';
$string['customcss'] = 'Egendefinert CSS';
$string['customcssdesc'] = 'All CSS-kode du skriver inn her blir lagt til alle sider. Dette gjør det enkelt å tilpasse dette designet.';
$string['linkcolor'] = 'Lenkefarge';
$string['linkcolordesc'] = 'Dette angir lenkefargen i designet.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Skriv inn en URL til bildet som skal brukes som logo for denne portalen. Den skrive inn på formen: http://www.yoursite.com/path/to/logo.png';
$string['pluginname'] = 'Arialist';
$string['region-side-post'] = 'Høyre';
$string['region-side-pre'] = 'Venstre';
$string['regionwidth'] = 'Kolonnebredde';
$string['regionwidthdesc'] = 'Dette angir bredden på de to blokk-områdene som utgjør høyre og venstre kolonner.';
$string['tagline'] = 'Tagglinje';
$string['taglinedesc'] = 'En kort tagglinje som vises under  portalnavnet på hovedsiden.<br ><em>(Vil ikke vises når det brukes logo</em>';
