<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'vil bli installert';
$string['action'] = 'Handling';
$string['actionchoice'] = 'Hva ønsker du å gjøre med fila \'{$a}\'?';
$string['actions'] = 'Handlinger';
$string['active'] = 'Aktiv';
$string['activeusers'] = 'Aktive brukere';
$string['activities'] = 'Aktiviteter';
$string['activities_help'] = 'Aktiviterer som forum, quiz og wikier - aktiverer at interaktivt innhold kan legges til i kurset.';
$string['activity'] = 'Aktivitet';
$string['activityclipboard'] = 'Flytter denne aktiviteten: {$a}';
$string['activityiscurrentlyhidden'] = 'Beklager, denne aktiviteten er ikke tilgjjengelig akkurat nå.';
$string['activitymodule'] = 'Aktivitetsmodul';
$string['activitymodules'] = 'Aktivitetsmoduler';
$string['activityreport'] = 'Aktivitetsrapport';
$string['activityreports'] = 'Aktivitetsrapporter';
$string['activityselect'] = 'Velg denne aktiviteten til å flyttes et annet sted';
$string['activitysince'] = 'Aktivitet siden {$a}';
$string['activityweighted'] = 'Aktivitet pr bruker';
$string['add'] = 'Legg til';
$string['addactivity'] = 'Legg til en aktivitet ...';
$string['addactivitytosection'] = 'Legg til en aktivitet til seksjonen \'{$a}\'';
$string['addadmin'] = 'Legg til administrator';
$string['addblock'] = 'Legg til en blokk';
$string['addcomment'] = 'Legg til en kommentar ...';
$string['addcountertousername'] = 'Opprett brukere ved å legge til tall til brukernavnet';
$string['addcreator'] = 'Legg til kursprodusent';
$string['adddots'] = 'Legg til...';
$string['added'] = 'La til {$a}';
$string['addedrecip'] = 'La til {$a} ny mottaker';
$string['addedrecips'] = 'La til {$a} nye mottakere';
$string['addedtogroup'] = 'Lagt til gruppe {$a}';
$string['addedtogroupnot'] = 'Ikke lagt til gruppe {$a}';
$string['addedtogroupnotenrolled'] = 'Ble ikke lagt til gruppe {$a} fordi brukeren ikke er påmeldt kurset';
$string['addfilehere'] = 'Legg til fil(er) her';
$string['addinganew'] = 'Legger til {$a}';
$string['addinganewto'] = 'Legger til {$a->what} til {$a->to}';
$string['addingdatatoexisting'] = 'Legger data til eksisterende';
$string['additionalnames'] = 'Ekstra navn';
$string['addlinkhere'] = 'Legg til lenke her';
$string['addnewcategory'] = 'Legg til ny kategori';
$string['addnewcourse'] = 'Legg til nytt kurs';
$string['addnewuser'] = 'Legg til ny bruker';
$string['addnousersrecip'] = 'Legg til brukere som ikke har aksessert denne {$a} til mottakerlisten';
$string['addpagehere'] = 'Legg til tekst her';
$string['addresource'] = 'Legg til en ressurs ...';
$string['addresourceoractivity'] = 'Legg til en aktivitet eller en ressurs';
$string['addresourcetosection'] = 'Legg til en ressurs til emnet \'{$a}\'';
$string['address'] = 'Adresse';
$string['addstudent'] = 'Legg til student';
$string['addsubcategory'] = 'Legg til en underkategori';
$string['addteacher'] = 'Legg til lærer';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'For manuelt å opprette en ny brukerkonto';
$string['adminhelpassignadmins'] = 'Administratorer kan gjøre alt og bevege seg overalt på nettstedet';
$string['adminhelpassigncreators'] = 'Produsenter kan opprette nye kurs';
$string['adminhelpassignsiteroles'] = 'Tildel angitte brukere den definerte site-rollen';
$string['adminhelpassignstudents'] = 'Gå til et kurs og legg til studenter fra Admin-menyen';
$string['adminhelpauthentication'] = 'Du kan bruke interne brukerkonti eller eksterne databaser';
$string['adminhelpbackup'] = 'Sett opp automatiske sikkerhetskopier og når de skal lages';
$string['adminhelpconfiguration'] = 'Angi nettstedets utseende og oppførsel';
$string['adminhelpconfigvariables'] = 'Innstilling for nettstedets generelle funksjonalitet';
$string['adminhelpcourses'] = 'Sett opp kurs og kategorier, og meld inn lærere og studenter, editer forestående kurs';
$string['adminhelpeditorsettings'] = 'Innstillinger for HTML-redigering';
$string['adminhelpedituser'] = 'Bla gjennom listen av brukerkonti og rediger hvilke som helst av dem';
$string['adminhelpenvironment'] = 'Sjekk hvor godt tjenermaskinen tilfredstiller installasjonskravene til gjeldende og framtidige versjoner';
$string['adminhelpfailurelogs'] = 'Se gjennom logger for mislykket innlogging';
$string['adminhelplanguage'] = 'For å sjekke og redigere språkpakken som er i bruk';
$string['adminhelplogs'] = 'Bla gjennom aktivitetsloggene på nettstedet';
$string['adminhelpmanageblocks'] = 'Administrer installerte blokker og deres innstillinger';
$string['adminhelpmanagedatabase'] = 'Direkte tilgang til databasen (Vær forsiktig!)';
$string['adminhelpmanagefilters'] = 'Velg tekstfilter og relaterte innstillinger';
$string['adminhelpmanagemodules'] = 'Kontroller installerte moduler og deres innstillinger';
$string['adminhelpmanageroles'] = 'Opprett og definer roller som kan tildeles brukere';
$string['adminhelpmymoodle'] = 'Konfigurer Mine moodle blokker for brukerne';
$string['adminhelpreports'] = 'Rapporter på nettstedsnivå';
$string['adminhelpsitefiles'] = 'For å publiser generelle filer eller laste opp eksterne sikkerhetskopier';
$string['adminhelpsitesettings'] = 'Angi utseende på startsiden';
$string['adminhelpstickyblocks'] = 'Konfigurer Moodle med klistreblokker';
$string['adminhelpthemes'] = 'Velg utseende på nettstedet (farger, skrifttyper etc.)';
$string['adminhelpuploadusers'] = 'Hent inn nye brukerkonti fra en tekstfil';
$string['adminhelpusers'] = 'Angi brukere og godkjenningsmetoder';
$string['adminhelpxmldbeditor'] = 'Grensesnitt for å editere XMLDB-filer. Bare for utviklere.';
$string['administration'] = 'Administrasjon';
$string['administrationsite'] = 'Portalen';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administratorer kan vanligvis gjøre alt på denne portalen, og i alle kurs.';
$string['administrators'] = 'Administratorer';
$string['administratorsall'] = 'Alle administratorer';
$string['administratorsandteachers'] = 'Administratorer og lærere';
$string['advanced'] = 'Avansert';
$string['advancedfilter'] = 'Avansert søk';
$string['advancedsettings'] = 'Avanserte innstillinger';
$string['afterresource'] = 'Etter ressurs "{$a}"';
$string['aftersection'] = 'Etter emne "{$a}"';
$string['again'] = 'igjen';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX og Javascript';
$string['all'] = 'Alle';
$string['allactions'] = 'Alle handlinger';
$string['allactivities'] = 'Alle aktiviteter';
$string['allcategories'] = 'Alle kategorier';
$string['allchanges'] = 'Alle forandringer';
$string['alldays'] = 'Alle dager';
$string['allfieldsrequired'] = 'Alle felt må fylles ut';
$string['allfiles'] = 'Alle filer';
$string['allgroups'] = 'Alle grupper';
$string['alllogs'] = 'Alle logger';
$string['allmods'] = 'Alle {$a}';
$string['allow'] = 'Tillat';
$string['allowinternal'] = 'Tillat også interne metoder';
$string['allownone'] = 'Ikke tillat noen';
$string['allownot'] = 'Ikke tillat';
$string['allparticipants'] = 'Alle deltakere';
$string['allteachers'] = 'Alle lærere';
$string['alphanumerical'] = 'Kan bare inneholde tall, bokstaver, bindestrek (-) og punktum (.)';
$string['alreadyconfirmed'] = 'Registreringen er allerede godkjent';
$string['alternatename'] = 'Alternativt navn';
$string['always'] = 'Alltid';
$string['and'] = '{$a->one} og {$a->two}';
$string['answer'] = 'Svar';
$string['any'] = 'Alle';
$string['appearance'] = 'Utseende';
$string['approve'] = 'Godkjenn';
$string['areyousure'] = 'Er du sikker?';
$string['areyousuretorestorethis'] = 'Ønsker du å fortsette?';
$string['areyousuretorestorethisinfo'] = 'Senere i denne prosessen vil du ha mulighet til å legge denne sikkerhetskopien til en eksisterende kurs eller å lage et helt nytt kurs.';
$string['asc'] = 'Stigende';
$string['assessment'] = 'Vurdering';
$string['assignadmins'] = 'Legg til administrator';
$string['assigncreators'] = 'Legg til kursprodusenter';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Tildel roller for hele portalen';
$string['authenticateduser'] = 'Godkjent bruker';
$string['authenticateduserdescription'] = 'Innloggede brukere';
$string['authentication'] = 'Godkjenning';
$string['authenticationplugins'] = 'Autentiseringsmoduler';
$string['autosubscribe'] = 'Automatisk abonnement på forum';
$string['autosubscribeno'] = 'Nei, jeg ønsker ikke å automatisk abonnere på fora';
$string['autosubscribeyes'] = 'Ja, når jeg skriver innlegg, kan jeg føres opp som abonnent på det forum';
$string['availability'] = 'Tilgjengelighet';
$string['availablecourses'] = 'Tilgjengelige kurs';
$string['back'] = 'Tilbake';
$string['backto'] = 'Tilbake til {$a}';
$string['backtocourselisting'] = 'Tilbake til kurslisten';
$string['backtopageyouwereon'] = 'Tilbake tl forrige besøkte side';
$string['backtoparticipants'] = 'Tilbake til deltakerlisten';
$string['backup'] = 'Sikkerhetskopiering';
$string['backupactivehelp'] = 'Velg om automatisk sikkerhetskopiering skal kjøre';
$string['backupcancelled'] = 'Sikkerhetskopieringen ble avbrutt';
$string['backupcoursefileshelp'] = 'Dersom dette slåes på, blir kursfiler automatisk tatt med i sikkerhetskopier';
$string['backupdate'] = 'Dato for sikkerhetskopiering';
$string['backupdatenew'] = '{$a->TAG} er nå {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} var {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detaljer om sikkerhetskopiering';
$string['backupexecuteathelp'] = 'Angi når automatisk sikkerhetskopiering skal kjøre.';
$string['backupfailed'] = 'Noen av kursene dine ble ikke lagret.';
$string['backupfilename'] = 'Sikkerhetskopi';
$string['backupfinished'] = 'Sikkerhetskopiering fullført';
$string['backupfromthissite'] = 'Ble denne sikkerhetskopien tatt på denne portalen?';
$string['backupgradebookhistoryhelp'] = 'Dersom aktivert vil karakterhistorien tas med i automatiske sikkerhetskopier. Merk at karakterhistorie må være aktivert i serverinnstillingene for at dette skal fungere.';
$string['backupincludemoduleshelp'] = 'Velg om du vil inkludere kursmoduler (med eller uten brukerdata) i automatiske sikkerhetskopier';
$string['backupincludemoduleuserdatahelp'] = 'Velg om du ønsker at modulenes brukerdata skal være med i sikkerhetskopiene.';
$string['backupkeephelp'] = 'Hvor mange av de siste sikkerhetskopiene for hvert kurs vil du beholde? (Eldre sikkerhetskopier slettes automatisk)';
$string['backuplogdetailed'] = 'Detaljert logg for sikkerhetskopiering';
$string['backuploglaststatus'] = 'Logg for siste sikkerhetkopiering';
$string['backupmissinguserinfoperms'] = 'MERK: Denne sikkerhetskopien inneholder ingen brukerdata. Øvelse og Workshop aktiviteter vil ikke tas med i sikkerhetskopien, siden disse to modulene ikke er kompatible med denne typen sikkerhetskopi.';
$string['backupnext'] = 'Neste sikkerhetskopiering';
$string['backupnonisowarning'] = 'OBS: denne sikkerhetskopien er fra en versjon som ikke er Unicode (før 1.6). Hvis denne sikkerhetskopien inneholder noen tekster som ikke er ISO-8859-1, kan de bli ØDELAGT hvis du forsøker å gjenopprette dem til denne Unicode-versjonen av Moodle. See <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> for mer informasjon om hvordan du kan gjenopprette denne sikkerhetskopien korrekt.';
$string['backupnotyetrun'] = 'Automatisk sikkerhetskopiering er satt på vent';
$string['backuporiginalname'] = 'Navn på sikkerhetskopi';
$string['backuproleassignments'] = 'Backuprolleoppgaaver for disse rollene';
$string['backupsavetohelp'] = 'Fullstendig adresse til katalogen der du vil lagre filene til sikkerhetskopien<br />(La denne stå tom for å lagre i kursets standardkatalog)';
$string['backupsitefileshelp'] = 'Hvis denne er slått på vil nettstedsfiler brukt i kurs bli inkludert i automatiserte sikkerhetskopier.';
$string['backuptakealook'] = 'Du bør ta en titt på loggene for sikkerhetskopiering i {$a}';
$string['backupuserfileshelp'] = 'Velg om brukerfiler (f.eks. bilder i profiler) skal være med i automatiske sikkerhetskopier';
$string['backupversion'] = 'Versjon av sikkerhetskopi';
$string['badges'] = 'Utmerkelser';
$string['block'] = 'Blokk';
$string['blockconfiga'] = 'Setter innstillinger for boksen {$a}';
$string['blockconfigbad'] = 'Denne boksen er ikke riktig innstallert og det kan derfor ikke vises et innstillingspanel.';
$string['blocks'] = 'Blokker';
$string['blocksaddedit'] = 'Legg til/ Endre blokker';
$string['blockseditoff'] = 'Slå av boksredigering';
$string['blocksediton'] = 'Slå på boksredigering';
$string['blocksetup'] = 'Setter opp bokstabeller';
$string['blocksuccess'] = '{$a} tabeller ble satt opp korrekt';
$string['brief'] = 'Kort';
$string['bulkactions'] = 'Massehandlinger';
$string['bulkactionselect'] = '{$} valg for massehandlinger';
$string['bulkmovecoursessuccess'] = 'Vellykket flytting av {$a->courses} kurs til {$a->category}';
$string['bycourseorder'] = 'Etter kursrekkefølge';
$string['byname'] = 'etter {$a}';
$string['bypassed'] = 'Utelatt';
$string['cachecontrols'] = 'Kontroll av mellomlager';
$string['cancel'] = 'Avbryt';
$string['cancelled'] = 'Avbrutt';
$string['categories'] = 'Kurskategorier';
$string['categoriesandcoures'] = 'Kurskategorier og kurs';
$string['category'] = 'Kategori';
$string['categoryadded'] = 'Kategorien \'{$a}\' ble lagt til';
$string['categorybulkaction'] = 'Massehandlinger for valgte kategorier';
$string['categorycontents'] = 'Underkategorier og kurs';
$string['categorycurrentcontents'] = 'Innhold av {$a}';
$string['categorydeleted'] = 'Kategorien \'{$a}\' ble slettet';
$string['categoryduplicate'] = 'Kategorien \'{$a}\' eksisterer allerede!';
$string['categorymodifiedcancel'] = 'Kategorien ble endret! Avbryt og prøv igjen.';
$string['categoryname'] = 'Kategorinavn';
$string['categorysubcategoryof'] = '{$a->category} - underkategori tip {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorien \'{$a}\' ble oppdatert';
$string['changedpassword'] = 'Passordet er endret';
$string['changepassword'] = 'Endre passord';
$string['changesmadereallygoaway'] = 'Du har gjort endringer. Er du sikker på at du vil forlate denne siden og miste alle endringene du har gjort?';
$string['changessaved'] = 'Endringer lagret';
$string['check'] = 'Sjekk';
$string['checkall'] = 'Sjekk alle';
$string['checkingbackup'] = 'Sjekker sikkerhetskopi';
$string['checkingcourse'] = 'Sjekker kurs';
$string['checkingforbbexport'] = 'Ser etter BlackBoard eksport';
$string['checkinginstances'] = 'Sjekker eksempler';
$string['checkingsections'] = 'Sjekker seksjoner';
$string['checklanguage'] = 'Sjekk språk';
$string['checknone'] = 'Ikke sjekk noen';
$string['childcoursenotfound'] = 'Fant ikke underkurs!';
$string['childcourses'] = 'Underkurs';
$string['choose'] = 'Velg';
$string['choosecourse'] = 'Velg et kurs';
$string['choosedots'] = 'Velg...';
$string['chooselivelogs'] = 'Eller overvåk gjeldende aktivitet';
$string['chooselogs'] = 'Velg hvilke logger du vil se';
$string['choosereportfilter'] = 'Velg rapportfilter';
$string['choosetheme'] = 'Velg sidetema';
$string['chooseuser'] = 'Velg en bruker';
$string['city'] = 'Sted';
$string['clambroken'] = 'Administratoren din har satt på viruskontroll av opplastede filer, men det er gjort en eller annen feil. <br />Filen din ble ikke lastet opp. Administratoren din har fått en e-post om problemet slik at det kan fikses. <br />Prøv å laste opp fila litt senere.';
$string['clamdeletedfile'] = 'Filen er slettet';
$string['clamdeletedfilefailed'] = 'Filen kunne ikke slettes';
$string['clamemailsubject'] = '{$a} :: Clam antivirus-melding';
$string['clamfailed'] = 'Kjøring av virusprogrammet var mislykket. Feilmeldingen var {$a}. Clam sier:';
$string['clamlost'] = 'Moodle er programmert til å kjøre Clam ved filopplasting, men filbanen til Clam antivirus, {$a}, er ugyldig.';
$string['clamlostandactinglikevirus'] = 'Moodle er programmert til å behandle alle opplastede filer som virussmittet når Clam ikke virker. Det betyr at studentene ikke kan laste opp filer før du fikser dette problemet.';
$string['clammovedfile'] = 'Filen ble flyttet til karantenemappen som du tidligere har angitt. Den nye plasseringen er {$a}';
$string['clammovedfilebasic'] = 'Filen ble flyttet til en karantenemappe.';
$string['clamquarantinedirfailed'] = 'Kunne ikke flytte filen til den angitte karantenemappen, {$a}. Du må fikse dette, siden filer blir slettet ved mistanke om infeksjon.';
$string['clamunknownerror'] = 'Det var en ukjent feil i Clam';
$string['cleaningtempdata'] = 'Sletter midlertidige data';
$string['clear'] = 'Tøm';
$string['clickhelpiconformoreinfo'] = '... fortsetter ... Klikk på hjelp-ikonet for å lese hele artikkelen';
$string['clickhere'] = 'Klikk her...';
$string['clicktochangeinbrackets'] = '{$a} (Klikk for å endre)';
$string['clicktohideshow'] = 'Klikk for å utvide/skjule';
$string['closebuttontitle'] = 'Lukk';
$string['closewindow'] = 'Lukk dette vinduet';
$string['collapse'] = 'Skjul';
$string['collapseall'] = 'Skjul alle';
$string['collapsecategory'] = 'Skjul {$a}';
$string['commentincontext'] = 'Finn denne kommentaren i konteksten';
$string['comments'] = 'Kommentarer';
$string['commentsnotenabled'] = 'Kommentarfunksjonen er ikke aktivert';
$string['commentsrequirelogin'] = 'Du må logge inn for å se kommentarer';
$string['comparelanguage'] = 'Sammenlign og rediger gjeldende språk';
$string['complete'] = 'Fullført';
$string['completereport'] = 'Fullstendig rapport';
$string['configuration'] = 'Oppsett';
$string['confirm'] = 'Bekreft';
$string['confirmcheckfull'] = 'Er du helt sikker på at du vil bekrefte {$a} ?';
$string['confirmcoursemove'] = 'Er du sikker på at du ønsker å flytte dette kurset ({$a->course}) til denne kategorien ({$a->category})?';
$string['confirmed'] = 'Registreringen din er godkjent.';
$string['confirmednot'] = 'Registreringen er enda ikke bekreftet.';
$string['content'] = 'Innhold';
$string['continue'] = 'Fortsett';
$string['continuetocourse'] = 'Klikk her for å gå til kurset ditt';
$string['convertingwikitomarkdown'] = 'Konverterer wikien til Markdown-format';
$string['cookiesenabled'] = 'Informasjonskapsler (Cookies) må være satt på i nettleseren din.';
$string['cookiesenabled_help'] = '<p>Denne siden benytter to informasjonskapsler.</p>

<p>(Informasjonskapsler er små filer som kan inneholde en kort tekst. Serveren
kan lagre slike filer på harddisken din. Når du vender tilbake til samme server
så kan den huske deg. Bare den serveren som har lagt inn informasjonskapselen
kan lese den. Informasjonskapsler er ikke en inngangsport for datavirus. Du kan
bestemme selv om du vil tillate informasjonskapsler eller ikke via nettleserens
innstillinger. ) </p>

<p>Den viktigste informasjonskapselen er den for sesjoner kalt <b>MoodleSession</b>.
Du må tillate denne i nettleseren for å beholde innloggingsinformasjonen om deg
fra side til side i Moodle. (Du får med andre ord ikke logget på dersom denne
ikke tillates.) Når du logger ut eller lukker nettleseren slettes
informasjonskapselen&nbsp; automatisk, både fra harddisken din og fra serveren.
</p>
<p>Den andre informasjonskapselen er bare til for bekvemmelighet. Den kalles
oftest noe som <b>MOODLEID</b>. Det den gjør er å huske brukernavnet ditt i
nettleseren. Dette betyr at neste gang du besøker samme nettside blir dette
feltet ferdigutfylt. Det er trygt å avvise denne informasjonskapselen, det betyr
i praksis bare at du må taste inn brukernavnet manuelt hver gang du skal logge
inn. </p>';
$string['cookiesnotenabled'] = 'Informasjonskapsler er dessverre ikke slått på i nettleseren din';
$string['copy'] = 'kopier';
$string['copyasnoun'] = 'kopi';
$string['copyingcoursefiles'] = 'Kopierer kursfiler';
$string['copyingsitefiles'] = 'Kopierer nettstedsfiler som brukes i kurs';
$string['copyinguserfiles'] = 'Kopierer brukerfiler';
$string['copyingzipfile'] = 'Kopierer zip-fil';
$string['copyrightnotice'] = 'Kopibeskyttelse';
$string['coresystem'] = 'Globalt nivå';
$string['cost'] = 'Pris';
$string['costdefault'] = 'Standardpris';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Land';
$string['course'] = 'Kurs';
$string['courseadministration'] = 'Kursadministrasjon';
$string['courseapprovedemail'] = 'Kurset du ba om, {$a->name}, er godkjent, og du er nå en {$a->teacher}. Det nye kurset ditt finner du her: {$a->url}';
$string['courseapprovedemail2'] = 'Kurset du ba om, {$a->name}, er godkjent. For å få tilgang til ditt nye kurs, gå til {$a->url}';
$string['courseapprovedfailed'] = 'Kurset ditt er ikke godkjent!';
$string['courseapprovedsubject'] = 'Kurset ditt har blitt godkjent!';
$string['courseavailable'] = 'Dette kurset er tilgjengelig for studenter';
$string['courseavailablenot'] = 'Dette kurset er ikke tilgjengelig for studenter';
$string['coursebackup'] = 'Sikkerhetskopi av kurs';
$string['coursebulkaction'] = 'Massehandlinger for valgte kurs';
$string['coursecategories'] = 'Kurskategorier';
$string['coursecategory'] = 'Studiekategori';
$string['coursecategorydeleted'] = 'Slett kurskategori {$a}';
$string['coursecategory_help'] = '<P>Administratoren har satt opp forskjellige
   kategorier for sidene.

<P>F.eks. &quot;Yrkesutdanninger&quot;, &quot;Oppdragsstudier&quot;, &quot;Grunnkurs&quot;, &quot;VK1&quot;, &quot;VK2&quot; eller
lignende.

<P>Velg den kategorien ditt fag/din side tilhører.
   Dette vil gjøre det enklere for elevene/studentene å
   finne sin klasseside.';
$string['coursecatmanagement'] = 'Kurs-og kategoriadministrasjon';
$string['coursecompletion'] = 'Kursfullføring';
$string['coursecompletions'] = 'Kursfullføringer';
$string['coursecreators'] = 'Kursprodusenter';
$string['coursecreatorsdescription'] = 'Kursopprettere kan opprette nye kurs og undervise i dem.';
$string['coursedeleted'] = 'Slett kurs {$a}';
$string['coursedisplay'] = 'Kurslayout';
$string['coursedisplay_help'] = 'Denne innstillingen bestemmer hvorvidt hele kurset skal vises på en side eller fordeles over flere sider.';
$string['coursedisplay_multi'] = 'Vis ett emne pr. side';
$string['coursedisplay_single'] = 'Vis alle emnene på en side';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Arvede kursfiler';
$string['coursefilesedit'] = 'Endre arvede kursfiler';
$string['coursefileswarning'] = 'Lokale kursfiler i hvert kurs er utdatert fra Moodle 2.0. ';
$string['coursefileswarning_help'] = 'Lokale kursfiler i hvert kurs er utdatert fra Moodle 2.0. Vennligst benytt eksterne fillagre så mye som mulig i stedet.';
$string['courseformatdata'] = 'Kursformat data';
$string['courseformatoptions'] = 'Formatinnstillinger for {$a}';
$string['courseformats'] = 'Kursformat';
$string['courseformatudpate'] = 'Oppdater format';
$string['coursegrades'] = 'Kurskarakterer';
$string['coursehelpcategory'] = 'Plasser kurset i kursoversikten og gjør det enklere for brukerne å finne det.';
$string['coursehelpforce'] = 'Tving kursets gruppemodus på alle aktiviteter i kurset.';
$string['coursehelpformat'] = 'Kursets hovedside vil vises i dette formatet.';
$string['coursehelphiddensections'] = 'Hvordan skjulte deler av kurset vises for studentene.';
$string['coursehelpmaximumupload'] = 'Angi største filstørrelse som kan lastes opp i dette kurset. Filstørrelsen er begrenset av de globale innstillingene.';
$string['coursehelpnewsitemsnumber'] = 'Antall nyheter som skal vises i nyhetsblokken på kursets hovedside. Settes til "0" hvis du ikke vil vise nyhetsblokken når du lager nye kurs.';
$string['coursehelpnumberweeks'] = 'Antall uker/emner i kurset (gjelder kun bestemte kursformater)';
$string['coursehelpshowgrades'] = 'Aktiverer visning av karakterboka. Hindrer ikke at karakterer vises i de enkelte aktivitetene.';
$string['coursehidden'] = 'Dette kurset er for tiden ikke tilgjengelig for studenter';
$string['courseinfo'] = 'Kursinformasjon';
$string['courselegacyfiles'] = 'Arvede kursfiler';
$string['courselegacyfiles_help'] = 'Det kursbaserte filområdet er med for å gi bakoverkompatibilitet med tidligere versjoner av Moodle. (1.9 og tidligere)
Alle filer i dette filområdet er alltid tilgjengelig for kursdeltakerne (om de er lenket eller ikke), og det finnes ingen måte å avgjøre om disse filene er i bruk eller ikke.

Dersom du bruker dette filområdet til å lagre kursfiler, kan du få noen sikkerhets- og begrensningsproblemer, likeså må du forvente å miste filer ved sikkerhetskopiering, kursimport og hver gang innhold deles eller blir gjenbrukt. Vi anbefaler derfor at du IKKE benytter dette filområdet - så fremt du virkelig vet hva du holder på med.';
$string['courselegacyfilesofcourse'] = 'Arvede kursfiler: {$a}';
$string['coursemessage'] = 'Melding til kursbrukere';
$string['coursenotaccessible'] = 'Dette kurset er ikke åpent for allmenheten';
$string['courseoverview'] = 'Kursoversikt';
$string['courseoverviewfiles'] = 'Kursoversiktsfiler';
$string['courseoverviewfilesext'] = 'Filtyper for kursoversikt';
$string['courseoverviewfiles_help'] = 'Kursoversiktsfilene (vanligvis bilder) vises i listen over kurs sammen med kursbeskrivelsen.';
$string['courseoverviewfileslimit'] = 'Grense for kursoversiktsfiler';
$string['courseoverviewgraph'] = 'Kursoversikt graf';
$string['courseprofiles'] = 'Kurs';
$string['coursereasonforrejecting'] = 'Hva er årsaken til at du ikke godtar dette';
$string['coursereasonforrejectingemail'] = 'Dette vil bli sendt på mail til den som har foreslått det';
$string['coursereject'] = 'Avslå søknad om ny kurs';
$string['courserejected'] = 'Søknad om ny kurs ble avslått og søkeren har fått beskjed.';
$string['courserejectemail'] = 'Beklager, men søknaden om å opprette et nytt kurs ble ikke innvilget. Begrunnelsen for avslaget er som følger: {$a}';
$string['courserejectreason'] = 'Skisser opp hovedgrunnene til at kurset ble avvist<br />(Dette blir sendt til søkeren)';
$string['courserejectsubject'] = 'Søknaden om å få opprette et kurs bla avsått';
$string['coursereport'] = 'Kursrapporter';
$string['coursereports'] = 'Kursrapporter';
$string['courserequest'] = 'Kurssøknad';
$string['courserequestdetails'] = 'Detaljer for kurset du vil melde deg på';
$string['courserequestfailed'] = 'Av en eller annen grunn ble ikke kurssøknaden lagret';
$string['courserequestintro'] = 'Bruk dette skjemaet for å søke om å få opprettet et kurs. <br /> Fyll inn så mye informasjon som mulig, <br /> slik at administratorene kan forstå hvorfor du ønsker dette kurset.';
$string['courserequestreason'] = 'Grunner til å ha et slikt kurs';
$string['courserequestsuccess'] = 'Kurssøknaden ble lagret uten feil. Du vil få svar på e-post når søknaden er behandlet.';
$string['courserequestsupport'] = 'Utfyllende informasjon for å hjelpe administratoren å vurdere søknaden.';
$string['courserestore'] = 'Gjenopprett kurs';
$string['courses'] = 'Kurs';
$string['coursesectionsummaries'] = 'Sammendrag av kursseksjoner';
$string['coursesettings'] = 'Standard kursinnstillinger';
$string['coursesmovedout'] = 'Kursene ble flyttet fra {$a}';
$string['coursespending'] = 'Kurs som venter på godkjenning';
$string['coursestart'] = 'Kursstart';
$string['coursesummary'] = 'Kurssammendrag';
$string['coursesummary_help'] = 'Kursets sammendrag vises i kursoversikten. Et søk etter kurs omfatter også teksten i disse sammedragene.';
$string['courseupdates'] = 'Oppdateringer i kurset';
$string['create'] = 'Lag';
$string['createaccount'] = 'Lag en ny brukerkonto';
$string['createcategory'] = 'Lag kategori';
$string['createfolder'] = 'Lag en mappe i {$a}';
$string['createnew'] = 'Lag ny';
$string['createnewcategory'] = 'Opprett ny kategori';
$string['createnewcourse'] = 'Opprett nytt kurs';
$string['createnewsubcategory'] = 'Opprett ny underkategori';
$string['createsubcategoryof'] = 'Lag en underkategori til {$a}';
$string['createuser'] = 'Opprett bruker';
$string['createuserandpass'] = 'Lag et brukernavn og passord for innlogging';
$string['createziparchive'] = 'Lag ziparkiv';
$string['creatingblocks'] = 'Lager blokker';
$string['creatingblocksroles'] = 'Oppretter blokknivå rolle-rettigheter og overstyringer';
$string['creatingblogsinfo'] = 'Lager blogginfo';
$string['creatingcategoriesandquestions'] = 'Lager kategorier og spørsmål';
$string['creatingcoursemodules'] = 'Lager kursmoduler';
$string['creatingcourseroles'] = 'Oppretter kursnivå rolle-rettigheter og overstyringer';
$string['creatingevents'] = 'Lager hendelser';
$string['creatinggradebook'] = 'Lager karakterbok';
$string['creatinggroupings'] = 'Oppretter tilgangsgrupper';
$string['creatinggroupingsgroups'] = 'Legger til grupper i tilgangsgrupper';
$string['creatinggroups'] = 'Lager grupper';
$string['creatinglogentries'] = 'Lager loggoppføringer';
$string['creatingmessagesinfo'] = 'Lager meldingsinfo';
$string['creatingmodroles'] = 'Oppretter modulnivå rolle-rettigheter og overstyringer';
$string['creatingnewcourse'] = 'Lager nytt kurs';
$string['creatingrolesdefinitions'] = 'Oppretter rolledefinisjoner';
$string['creatingscales'] = 'Lager karakterskalaer';
$string['creatingsections'] = 'Lager seksjoner';
$string['creatingtemporarystructures'] = 'Lager midlertidige strukturer';
$string['creatinguserroles'] = 'Oppretter brukernivå rolle-rettigheter og overstyringer';
$string['creatingusers'] = 'Lager brukere';
$string['creatingxmlfile'] = 'Lager XML-fil';
$string['currency'] = 'Valuta';
$string['currentcourse'] = 'Gjeldende kurs';
$string['currentcourseadding'] = 'Legger data til gjeldende kurs';
$string['currentcoursedeleting'] = 'Sletter gjeldende kurs først';
$string['currentlanguage'] = 'Gjeldende språk';
$string['currentlocaltime'] = 'din lokale tid';
$string['currentlyselectedusers'] = 'Valgte brukere';
$string['currentpicture'] = 'Bildet du bruker nå';
$string['currentrelease'] = 'Informasjon om denne versjonen av Moodle';
$string['currentversion'] = 'Gjeldende versjon';
$string['databasechecking'] = 'Oppgraderer Moodles database fra versjon {$a->oldversion} til {$a->newversion}';
$string['databaseperformance'] = 'Databaseytelse';
$string['databasesetup'] = 'Setter opp database';
$string['databasesuccess'] = 'Databasen ble oppgradert';
$string['databaseupgradebackups'] = 'Versjon av sikkerhetskopi er nå {$a}';
$string['databaseupgradeblocks'] = 'Boksversjon er nå {$a}';
$string['databaseupgradegroups'] = 'Gruppeversjonen er nå {$a}';
$string['databaseupgradelocal'] = 'Lokal versjon for databasetilpasninger er nå {$a}';
$string['databaseupgrades'] = 'Oppgraderer database';
$string['date'] = 'Dato';
$string['datechanged'] = 'Datoen er endret';
$string['datemostrecentfirst'] = 'Dato - nyeste først';
$string['datemostrecentlast'] = 'Dato - nyeste sist';
$string['day'] = 'dag';
$string['days'] = 'dager';
$string['decodinginternallinks'] = 'Omtolker interne lenker';
$string['default'] = 'Standard';
$string['defaultcoursestudent'] = 'Student';
$string['defaultcoursestudentdescription'] = 'Studenter har generelt mindre privilegier i et kurs.';
$string['defaultcoursestudents'] = 'Studenter';
$string['defaultcoursesummary'] = 'Skriv et kort og relevant avsnitt her';
$string['defaultcourseteacher'] = 'Lærer';
$string['defaultcourseteacherdescription'] = 'Lærere kan gjøre hva som helst i et kurs, inkludert endre aktiviteter og vurdere studenter.';
$string['defaultcourseteachers'] = 'Lærere';
$string['defaulteditor'] = 'Standard redigeringsverktøy';
$string['delete'] = 'Slett';
$string['deleteablock'] = 'Slett en blokk';
$string['deleteall'] = 'Slett alle';
$string['deleteallcannotundo'] = 'Slette alle - kan ikke angres';
$string['deleteallcomments'] = 'Slett alle kommentarer';
$string['deleteallratings'] = 'Slett alle vurderinger';
$string['deletecategory'] = 'Slett kategori: {$a}';
$string['deletecategorycheck'] = 'Er du helt sikker på at du vil slette denne kategorien, <b>\'{$a}\'</b>?<br /> Dette vil flytte alle alle kurs til kategorien over hvis det er noen, eller til kategorien "Diverse".';
$string['deletecategorycheck2'] = 'Hvis du sletter denne kategorien, må du bestemme hva du vil gjøre med underkategorier og kurs den inneholder.';
$string['deletecategoryempty'] = 'Denne kategorien er tom.';
$string['deletecheck'] = 'Slett {$a} ?';
$string['deletecheckfiles'] = 'Er du helt sikker på at du vil slette disse filene?';
$string['deletecheckfull'] = 'Er du sikker på at du vil slette {$a} ?';
$string['deletechecktype'] = 'Er du sikker på at du vil slette {$a->type}?';
$string['deletechecktypename'] = 'Er du sikker på at du vil slette {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Du holder på å slette disse filene';
$string['deletecomment'] = 'Slett denne kommentaren';
$string['deletecompletely'] = 'Slett fullstendig';
$string['deletecourse'] = 'Slett et kurs';
$string['deletecoursecheck'] = 'Er du sikker på at du vil slette dette kurset og alt den inneholder?';
$string['deleted'] = 'Slettet';
$string['deletedactivity'] = 'Slettet {$a}';
$string['deletedcourse'] = '{$a} er fullstendig slettet';
$string['deletednot'] = 'Kunne ikke slette {$a} !';
$string['deletelogs'] = 'Slett logger';
$string['deleteselected'] = 'Slett valgte';
$string['deleteselectedkey'] = 'Slett valgte nøkkel';
$string['deletingcourse'] = 'Sletter {$a}';
$string['deletingexistingcoursedata'] = 'Sletter eksisterende kursdata';
$string['deletingolddata'] = 'Sletter gamle data';
$string['department'] = 'Avdeling';
$string['desc'] = 'Synkende';
$string['description'] = 'Beskrivelse';
$string['deselectall'] = 'Opphev valg';
$string['detailedless'] = 'Mindre detaljert';
$string['detailedmore'] = 'Mer detaljert';
$string['directory'] = 'Katalog';
$string['disable'] = 'Slå av';
$string['disabledcomments'] = 'Kommentarer er deaktivert';
$string['displayingfirst'] = 'Kun de første {$a->count} {$a->things} vises';
$string['displayingrecords'] = 'Viser {$a} poster';
$string['displayingusers'] = 'Viser brukere {$a->start} til {$a->end}';
$string['displayonpage'] = 'Vis på siden';
$string['dndcourse'] = 'Du kan dra og slippe dette kurset for å endre på dets posisjon i listen eller flytte det til en annen kategori.';
$string['dndenabled_inbox'] = 'Du kan dra og slippe filer her for å legge dem til.';
$string['dndnotsupported'] = 'Dra og slipp-opplasting støttes ikke';
$string['dndnotsupported_help'] = 'Nettleseren din støtter ikke Dra og slipp.<br />Dette er en funksjon som støttes i alle nyere versjoner av Chrome, Firefox og Safari samt Internet Explorer 10 og nyere.';
$string['dndnotsupported_insentence'] = 'dra og slipp støttes ikke';
$string['dnduploadwithoutcontent'] = 'Denne opplastingen har ikke noe innhold';
$string['dndworkingfile'] = 'Dra og slipp filer inn i kursets emneseksjoner for å laste dem opp.';
$string['dndworkingfilelink'] = 'Dra og slipp filer eller lenker inn i kursets emneseksjoner for å laste dem opp.';
$string['dndworkingfiletext'] = 'Dra og slipp fller eller tekst inn i kursets emneseksjoner for å laste dem opp.';
$string['dndworkingfiletextlink'] = 'Dra og slipp filer, tekster og lenker inn i kursets emneseksjoner for å laste dem opp.';
$string['dndworkinglink'] = 'Dra og slipp lenker inn i kursets emneseksjoner for å legge den til.';
$string['dndworkingtext'] = 'Dra og slipp tekst inn i kursseksjoner for å legge den til.';
$string['dndworkingtextlink'] = 'Dra og slipp tekst eller lenker inn i kursseksjoner for å laste dem opp.';
$string['documentation'] = 'Moodledokumentasjon';
$string['dontsortcategories'] = 'Ikke sorter kategorier';
$string['dontsortcourses'] = 'Ikke sorter kurs';
$string['down'] = 'Ned';
$string['download'] = 'Last ned';
$string['downloadall'] = 'Last ned alle';
$string['downloadexcel'] = 'Last ned i MS Excel-format';
$string['downloadfile'] = 'Last ned fil';
$string['downloadods'] = 'Last ned i ODS format';
$string['downloadtext'] = 'Last ned i tekstformat';
$string['doyouagree'] = 'Har du lest og forstått disse betingelsene?';
$string['droptoupload'] = 'Her slipper du filen/filene du vil laste opp.';
$string['duplicate'] = 'Dupliser';
$string['duplicateconfirm'] = 'Er du sikker på at du vil duplisere {$a->modtype} \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Gå tilbake til kurset';
$string['duplicatecontedit'] = 'Endre den nye kopien';
$string['duplicatesuccess'] = 'Dupliseringen av {$a->modtype} \'{$a->modname}\'  var vellykket.';
$string['duplicatinga'] = 'Dupliserer: {$a}';
$string['edhelpaspellpath'] = 'For å bruke stavekontroll i redigeringsprogammet må du ha <strong>aspell 0.50</strong> eller nyere installert på tjenermaskinen din, og du må angi riktig filbane til programmet. På Unix/Linux-systemer ligger programmet vanligvis på <strong>/usr/bin/aspell</strong>, men det kan også ligge et annet sted.';
$string['edhelpbgcolor'] = 'Bestem bakgrunnsfarge for redigeringsfeltet. <br /> Gyldige verdier er for eksempel <I> #FFFFFF </i>eller <i>white</>.';
$string['edhelpcleanword'] = 'Denne innstillingen slår <i>Word</i>-spesifikk formatering av eller på.';
$string['edhelpenablespelling'] = 'Skru stavekontrollen av eller på. Når den står på, må <strong>aspell</strong> være installert på tjenermaskinen. Du kan også sette denne innstillingen på <strong>default dicionary</strong>. Denne innstillingen brukes når det ikke finnes stavekontroll for brukerens språk.';
$string['edhelpfontfamily'] = 'Egenskapen fontfamilie er en liste med navn på fontfamilier. Familienavn må skilles med komma.';
$string['edhelpfontlist'] = 'Angi fontene som brukes i rullemenyen ved tekst- og HTML-redigering.';
$string['edhelpfontsize'] = 'Standard fontstørrelse bestemmer størrelsen på en font. <br />Gyldige verdier er for eksempel: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Rediger';
$string['edita'] = 'Rediger {$a}';
$string['editcategorysettings'] = 'Rediger kategori-innstillinger';
$string['editcategorythis'] = 'Rediger denne kategorien';
$string['editcoursesettings'] = 'Rediger kursinnstillinger';
$string['editfiles'] = 'Rediger filer';
$string['editgroupprofile'] = 'Rediger gruppeprofil';
$string['editinga'] = 'Redigerer {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Denne verdien kan ikke endres!';
$string['editmyprofile'] = 'Endre profil';
$string['editorbgcolor'] = 'Bakgrunnsfarge';
$string['editorcleanonpaste'] = 'Rensk opp i Word-HTML ved klipp-og-lim';
$string['editorcommonsettings'] = 'Standardinnstillinger';
$string['editordefaultfont'] = 'Standardfont';
$string['editorenablespelling'] = 'Slå på stavekontroll';
$string['editorfontlist'] = 'Fontliste';
$string['editorfontsize'] = 'Standard fontstørrelse';
$string['editorresettodefaults'] = 'Bruk standardverdiene';
$string['editorsettings'] = 'Redigering';
$string['editorshortcutkeys'] = 'Editor snarveier';
$string['editsettings'] = 'Endre innstillinger';
$string['editsummary'] = 'Rediger overskrift';
$string['editthisactivity'] = 'Rediger denne aktiviteten';
$string['editthiscategory'] = 'Rediger denne kategorien';
$string['edittitle'] = 'Endre tittel';
$string['edittitleinstructions'] = 'Klikk på ESC for å avbryte eller ENTER-tasten når du er ferdig.';
$string['edituser'] = 'Rediger brukerkontoer';
$string['email'] = 'E-postadresse';
$string['emailactive'] = 'E-post aktivert';
$string['emailagain'] = 'E-post (igjen)';
$string['emailalreadysent'] = 'En epost med nytt passord har alt blitt sendt. Vennligst sjekk epostkontoen din.';
$string['emailcharset'] = 'Karaktersett i e-post';
$string['emailconfirm'] = 'Godkjenn kontoen din';
$string['emailconfirmation'] = 'Hei {$a->firstname},
En forespørsel om at det opprettes en brukerkonto på \'{$a->sitename}\' er mottatt fra din epostadresse.
Gå til denne nettadressen for å bekrefte kontoen:
  {$a->link}
<br />I de fleste e-postlesere vil denne vises som en blå lenke som du kan klikke på. Hvis dette ikke virker, kan du kopiere adressen og lime den inn i adressefeiltet på nettleseren din.
OBS: Bekreft ved å klikke på denne lenken straks du har fått e-posten. Går det for lang tid vil bekreftelsesprosessen bli annulert automatisk og du må begynne på nytt!

Hvis du trenger hjelp, ta kontakt med nettstedets administrator, {$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: kontobekreftelse';
$string['emailconfirmsent'] = '<p>En e-post er nå sendt til adressen <b>{$a}</b></p>
<p>Den inneholder informasjon om hvordan du fullfører registreringen.</p><br />
<strong>OBS!</strong> Bekreft via URL straks du har fått e-posten. Går det for lang tid vil bekreftelsesprosessen bli automatisk annulert og du må begynne på nytt.
<p>Hvis du fortsatt har problemer, vennligst ta kontakt med administrator for portalen.</p>';
$string['emaildigest'] = 'Type samlepost';
$string['emaildigestcomplete'] = 'Komplett (daglig epost-utsendelse med hele innlegg)';
$string['emaildigest_help'] = 'Dette er standardinnstillingen for den daglige oppsummering i forumene.

* Ingen opppsummering - Du vil motta en epost for hvert foruminnlegg;
* Oppsummering - hele innlegg - Du vil motta en epost hver dag som inneholder alle foruminnleggene;
* Oppsummering - kun emnefelt - Du vil motta en epost hver dag som inneholder emnefeltene fra hvert foruminnlegg.

Du kan endre disse innstillingene for hvert forum etter eget ønske.';
$string['emaildigestoff'] = 'Ingen oppsamling (en e-post per foruminnlegg)';
$string['emaildigestsubjects'] = 'Tema (daglig epost-utsendelse med bare tema)';
$string['emaildisable'] = 'Denne e-postadressen er koblet ut';
$string['emaildisableclick'] = 'Klikk her for å hindre all epost i å bli sendt til denne adressen.';
$string['emaildisplay'] = 'E-postvisning';
$string['emaildisplaycourse'] = 'Kun medstudenter og -lærere kan se min e-postadresse';
$string['emaildisplayhidden'] = 'Skjult e-postadresse';
$string['emaildisplayno'] = 'Skjul min e-postadresse for alle';
$string['emaildisplayyes'] = 'La alle se min e-postadresse';
$string['emailenable'] = 'Denne e-postadressen er i bruk';
$string['emailenableclick'] = 'Klikk her for å aktivere denne adressen igjen.';
$string['emailexists'] = 'Denne e-posten er allerede registrert.';
$string['emailformat'] = 'E-postformat';
$string['emailmustbereal'] = 'Merk: E-postadressen din må være en virkelig e-postadresse. Har du skrevet den riktig?';
$string['emailnotallowed'] = 'E-postadresser fra disse domenene er ikke tillatt:({$a})';
$string['emailnotfound'] = 'Fant ikke e-postadressen i databasen';
$string['emailonlyallowed'] = 'Denne e-postadressen har en adresse som ikke er tillatt.';
$string['emailpasswordchangeinfo'] = 'Hei {$a->firstname},
Noen (antakelig deg) har bedt om nytt passord for din brukerkonto på \'{$a->sitename}\'.
For å endre passordet ditt ber vi deg går til følgende adresse:
{$a->link}
I de fleste e-post programmer burde lenken over fremkomme som en internett-lenke du kan klikke på. Hvis dette ikke ser ut til å virke kan du kopiere lenken til adressefeltet i nettleseren din og klikke "Gå til".
Trenger du mer hjelp kan du kontakte {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Hei {$a->firstname},
Noen (antakeligvis deg) har bedt om et nytt passord for kontoen din på \'{$a->sitename}\'.
Kontoen din er sperret og kan passord kan ikke settes på nytt, vennligst ta kontakt med administrator,
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Hei {$a->firstname},
Noen (antakelig deg) har bedt om nytt passord for din brukerkonto på \'{$a->sitename}\'.
Muligheten for å endre passord er slått av på denne siten, siden dette styres av andre systemer.
Trenger du mer hjelp kan du kontakte {$a->admin}';
$string['emailpasswordchangeinfosubject'] = 'Informasjon for passordbytte';
$string['emailpasswordconfirmation'] = 'Hei {$a->firstname},
Noen (sannsynligvis du) har bedt om et nytt passord for kontoen din på \'{$a->sitename}\'.
For å bekrefte dette og få et nytt passord sendt til din e-post, må du gå til følgende adresse:
{$a->link}
I de fleste e-postlesere vil denne vises som en blå lenke som du kan klikke på. Hvis dette ikke virker kan du kopiere adressen og lime den inn i nettleseren din.  Bekreft via URL straks du har fått e-posten. Går det for lang tid vil bekreftelsesprosessen bli annulert automatisk og du må begynne på nytt.
Hvis du trenger hjelp, kan du ta kontakt med administrator
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: bytt passord - bekreftelse';
$string['emailpasswordconfirmmaybesent'] = '<p>Hvis du la inn korrekt informasjon vil du straks motta en e-post. </p>
<p>Den inneholder enkle instruksjoner for å bekrefte og fullføre endring av passord.
Hvis du fortsatt har problemer, vær vennlig og ta kontakt med administrator.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Denne brukerkontoen er ikke registrert med en epostadresse.</p>
   <p>Vennligst kontakt portaladministratoren.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Brukerinformasjonen du bidro med stemmer ikke med noen eksisterende brukerkontoer.</p>
   <p>Vennligst se over informasjonen du skrev inn, og prøv på nytt.
Dersom problemene fortsetter, vennligst kontakt portaladministratoren.</p>';
$string['emailpasswordconfirmsent'] = 'En e-post skal være sendt til din adresse <b>{$a}</b>.
<br />Den inneholder enkle instruksjoner for åbekrefte og fullføre endringen av passord.
Hvis du fortsatt har problemer, kan du ta kontakt med administrator';
$string['emailpasswordsent'] = '<p>Takk for bekreftelse av passordbytte.</p>
<p>En e-post med brukernavnet og ditt midlertidige passord er sendt til din adresse <br /><b>{$a->email}</b>.<br />
Det nye passordet ble automatisk generert og du vil måtte bytte passordet straks etter innlogging.</p>';
$string['emailresetconfirmation'] = 'Hei {$a->firstname},

Det har kommet en forspørsel om nytt passord for din konto \'{$a->username}\' på {$a->sitename}.

For å bekrefte forespørselen, og sette et nytt passord for kontoen din, vennligst gå til følgende nettsted:

{$a->link}
(Denne lenken er gyldig for {$a->resetminutes} minutter fra da forespørselen ble sendt første gang)

Hvis du ikke ønsker et nytt passord, trenger du ikke gjøre noe.

Hvis du trenger hjelp, vennligst kontakt portaladministratoren,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Forespørsel om nytt passord';
$string['emailresetconfirmsent'] = 'En epost har blitt sendt til din adresse <b>{$a}</b>
<br/>Den inneholder instruksjoner for hvordan du kan bekrefte og fullføre endringen av passord. Hvis du fortsetter å oppleve vanskeligheter, kontakt portaladministratoren.';
$string['emptydragdropregion'] = 'Tomt område';
$string['enable'] = 'Slå på';
$string['encryptedcode'] = 'Kryptert kode';
$string['english'] = 'Engelsk';
$string['enrolmentmethods'] = 'Innmeldingsmetoder';
$string['entercourse'] = 'Klikk her for å gå til kurset';
$string['enteremail'] = 'Skriv inn e-postadressen din';
$string['enteremailaddress'] = 'Skriv inn din e-postadresse for å slette det gamle passordet og få et nytt tilsendt på e-post.';
$string['enterusername'] = 'Skriv inn brukernavnet ditt';
$string['entries'] = 'Oppføringer';
$string['error'] = 'Feil';
$string['errorcreatingactivity'] = 'Kunne ikke opprette en instans av aktiviteten \'{$a}\'';
$string['errorfiletoobig'] = 'Kunne ikke opprette en instans av aktiviteten \'{$a}\'';
$string['errornouploadrepo'] = 'Det er ikke opprettet noe filområde for denne kursportalen.';
$string['errorwhenconfirming'] = 'Kontoen er ikke bekreftet enda pga. en feil. Hvis du klikket på en lenke i en e-post for å komme hit, var den ubrutt? Du må kanskje skrive inn lenken manuelt eller kopiere og lime den inn i nettleserens adresselinje.';
$string['eventcontentviewed'] = 'Innhold sett';
$string['eventcoursecategorydeleted'] = 'Kategori slettet';
$string['eventcoursecontentdeleted'] = 'Kursinnhold slettet';
$string['eventcoursecreated'] = 'Kurs opprettet';
$string['eventcoursedeleted'] = 'Kurs slettet';
$string['eventcoursemodulecreated'] = 'Kursmodul opprettet';
$string['eventcoursemoduledeleted'] = 'Kursmodul slettet';
$string['eventcoursemoduleupdated'] = 'Kursmodul oppdatert';
$string['eventcourseresetended'] = 'Tilbakestillingen av kurset er avsluttet';
$string['eventcourseresetstarted'] = 'Tilbakestillingen av kurset har startet';
$string['eventcourserestored'] = 'Kurs gjenopprettet';
$string['eventcoursesectionupdated'] = 'Kursseksjon oppdatert';
$string['eventcourseupdated'] = 'Kurs oppdatert';
$string['eventusercreated'] = 'Bruker opprettet';
$string['eventuserdeleted'] = 'Bruker slettet';
$string['eventuserlistviewed'] = 'Brukerliste sett';
$string['eventuserloggedout'] = 'Bruker logget ut';
$string['eventuserprofileviewed'] = 'Brukerprofil sett';
$string['eventuserupdated'] = 'Bruker oppdatert';
$string['everybody'] = 'Alle';
$string['executeat'] = 'Kjør ved';
$string['existing'] = 'Eksisterende';
$string['existingadmins'] = 'Eksisterende administratorer';
$string['existingcourse'] = 'Eksisterende kurs';
$string['existingcourseadding'] = 'Eksisterende kurs, legger data til den';
$string['existingcoursedeleting'] = 'Eksisterende kurs, sletter det først';
$string['existingcreators'] = 'Eksisterende kursprodusenter';
$string['existingstudents'] = 'Innmeldte studenter';
$string['existingteachers'] = 'Eksisterende lærere';
$string['expand'] = 'Utvid';
$string['expandall'] = 'Utvid alt';
$string['expandcategory'] = 'Utvid {$a}';
$string['explanation'] = 'Forklaring';
$string['extendenrol'] = 'Forleng innmeldingsperioden (individuelt)';
$string['extendperiod'] = 'Utvidet periode';
$string['failedloginattempts'] = '{$a->attempts} mislykkede innlogginger siden forrige din innlogging';
$string['failedloginattemptsall'] = '{$a->attempts} mislykkede innlogginger for {$a->accounts} brukerkonti';
$string['feedback'] = 'Tilbakemelding';
$string['file'] = 'Fil';
$string['fileexists'] = 'Det eksisterer allerede en fil med navnet {$a}';
$string['filemissing'] = '{$a} mangler';
$string['files'] = 'Filer';
$string['filesanduploads'] = 'Filer og opplastinger';
$string['filesfolders'] = 'Filer/mapper';
$string['filetoolarge'] = 'er for stor til å bli lastet opp';
$string['fileuploadwithcontent'] = 'Filopplastinger skal ikke inneholde noen innholdsparametre';
$string['filloutallfields'] = 'Vennligst fyll ut alle feltene i skjemaet';
$string['filter'] = 'Filter';
$string['findmorecourses'] = 'Finn flere kurs ...';
$string['first'] = 'Første';
$string['firstaccess'] = 'Første innlogging';
$string['firstname'] = 'Fornavn';
$string['firstnamephonetic'] = 'Fornavn - fonetisk';
$string['firstsiteaccess'] = 'Første innlogging';
$string['firsttime'] = 'Er det første gang du er her?';
$string['folder'] = 'Mappe';
$string['folderclosed'] = 'Lukket mappe';
$string['folderopened'] = 'Åpen mappe';
$string['followingoptional'] = 'Følgende er valgfritt å fylle ut';
$string['followingrequired'] = 'Følgende må fylles ut';
$string['for'] = 'For';
$string['force'] = 'Tving';
$string['forcelanguage'] = 'Tving språk';
$string['forceno'] = 'Ikke tving';
$string['forcepasswordchange'] = 'Tving passordbytte';
$string['forcepasswordchangecheckfull'] = 'Er du sikker på at du vil tvinge passordskifte til {$a} ?';
$string['forcepasswordchange_help'] = 'Dette valget tvinger brukeren til å bytte passord ved neste innlogging.';
$string['forcepasswordchangenot'] = 'Ikke mulig å tvinge passordskifte for {$a}';
$string['forcepasswordchangenotice'] = 'Du må endre passordet for å fortsette';
$string['forcetheme'] = 'Tving utseende';
$string['forgotaccount'] = 'Glemt passordet?';
$string['forgotten'] = 'Har du glemt brukernavn eller passord?';
$string['forgottenduplicate'] = 'E-postadressen deles av flere kontoer, vennligst skriv inn brukernavnet i stedet.';
$string['forgotteninvalidurl'] = 'Tilbakestillings-URL for ugyldig passord';
$string['format'] = 'Format';
$string['format_help'] = '<P><B>Ukeformat</B></P>
<UL>
Faget blir organisert uke etter uke, med nøyaktig start- og avslutningsdato.
Hver uke består av aktiviteter som lærerne legger til. (Forum, journal, oppgave, chat, ressurser osv.)
Noen av dem, f.eks. journaler, kan ha en &quot;tidslomme&quot; de er åpne for redigering.
Før og etter blir de skjult for studentene/elevene.
</UL>

<P><B>Emneformat</B></P>
<UL>
Veldig lik ukeformat, bortsett fra at &quot;ukeboksene&quot; kalles &quot;emnebokser&quot;. Et "emne" har ingen tidsbegrensning. Du trenger ikke spesifisere noen datoer.
Det mest brukte formatet.
</UL>

<P><B>Sosialt format</B></P>
<UL>
Dette format er basert rundt et hovedforum, det sosiale forum, som vises
på hovedsiden. Det er nyttig når siden skal organiseres  friere.
Dette må ikke engang være et fag, f.eks. kan det bli brukt til grupperom eller en avdelings
oppslagstavle.
</UL>';
$string['formathtml'] = 'HTML-format';
$string['formatmarkdown'] = 'Markdown-format';
$string['formatplain'] = 'Ren tekst';
$string['formattext'] = 'Autoformat';
$string['formattexttype'] = 'Formattering';
$string['framesetinfo'] = 'Dette rammesett-dokumentet inneholder:';
$string['from'] = 'Fra';
$string['frontpagecategorycombo'] = 'Kombiliste';
$string['frontpagecategorynames'] = 'Vis en liste over kategorier';
$string['frontpagecourselist'] = 'Vis en liste over kurs';
$string['frontpagecoursesearch'] = 'Kurs søkeblokk';
$string['frontpagedescription'] = 'Forsidesammendrag';
$string['frontpagedescriptionhelp'] = 'Denne beskrivelsen kan vises på forsiden ved hjelp av kurs/portalbeskrivelsesblokken eller ved å inkludere et emneavsnitt på forsiden.';
$string['frontpageenrolledcourselist'] = 'Påmeldte kurs';
$string['frontpageformat'] = 'Forsideformat';
$string['frontpageformatloggedin'] = 'Format på forsiden når en er logget på';
$string['frontpagenews'] = 'Vis nye meldinger';
$string['frontpagesettings'] = 'Forside innstillinger';
$string['fulllistofcourses'] = 'Alle kurs';
$string['fullname'] = 'Fullt navn';
$string['fullnamecourse'] = 'Fullt navn';
$string['fullnamecourse_help'] = 'Kursets fulle navn vises i toppen av hver side og i kursoversikten.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Fullt navn';
$string['fullprofile'] = 'Full profil';
$string['fullsitename'] = 'Nettstedets navn';
$string['functiondisabled'] = 'Den funksjonen er for tiden ikke tilgjengelig';
$string['general'] = 'Generell';
$string['geolocation'] = 'bredde- og lengdegrad';
$string['gettheselogs'] = 'Hent disse loggene';
$string['go'] = 'Kjør';
$string['gpl'] = 'Copyright (C) 1999-2004  Martin Dougiamas  (http://dougiamas.com)
Dette programmet er fri programvare; du kan videreformidle det og/eller forandre det i henhold til betingelsene til "GNU General Public License" som publisert av "Free Software Foundation"; enten versjon 2 av lisensen eller (etter ditt valg) en senere versjon.
Dette programmet distribueres med håp om at det blir nyttig, men UTEN NOEN GARANTIER; også uten "the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE". Se "GNU General Public License" for flere detaljer:
http://www.gnu.org/copyleft/gpl.html';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

Dette programmet er fri programvare; du kan videreformidle det og/eller forandre det i henhold til betingelsene til "GNU General Public License" som publisert av "Free Software Foundation"; enten versjon 3 av lisensen eller (etter ditt valg) en senere versjon.

Dette programmet distribueres med håp om at det kan være til nytte, men UTEN NOEN GARANTIER; også uten det implisitt garanti av
SALGBARHET eller FOR ET SPESIELT FORMÅL.

Gå til "Moodles lisensinformasjon" for flere detaljer:
http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL lisens';
$string['grade'] = 'Karakter';
$string['grades'] = 'Karakterbok';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> er aktivert på denne portalen. Dersom du ikke laster opp profilbilder vil Moodle forsøke å hente et bilde fra Gravatar.';
$string['group'] = 'Gruppe';
$string['groupadd'] = 'Legg til ny gruppe';
$string['groupaddusers'] = 'Legg den/de valgte til gruppen';
$string['groupextendenrol'] = 'Utvid påmelding for alle';
$string['groupfor'] = 'For gruppe';
$string['groupinfo'] = 'Info om valgt gruppe';
$string['groupinfoedit'] = 'Rediger gruppeinstillinger';
$string['groupinfomembers'] = 'Info om valgte medlemmer';
$string['groupinfopeople'] = 'Info om valgte personer';
$string['groupmembers'] = 'Gruppemedlemmer';
$string['groupmemberssee'] = 'Se gruppemedlemmer';
$string['groupmembersselected'] = 'Medlemmer i valgt gruppe';
$string['groupmode'] = 'Gruppemodus';
$string['groupmodeforce'] = 'Tving gruppemodus';
$string['groupmy'] = 'Min gruppe';
$string['groupnonmembers'] = 'Brukere uten gruppe';
$string['groupnotamember'] = 'Beklager, du er ikke medlem av gruppen';
$string['grouprandomassign'] = 'Fordel alle til grupper automatisk';
$string['groupremove'] = 'Fjern valgt gruppe';
$string['groupremovemembers'] = 'Fjern valgte medlemmer';
$string['groups'] = 'Grupper';
$string['groupsnone'] = 'Ingen grupper';
$string['groupsseparate'] = 'Separate grupper';
$string['groupsvisible'] = 'Synlige grupper';
$string['guest'] = 'Gjest';
$string['guestdescription'] = 'Gjester har minimale rettigheter og kan vanligvis ikke skrive inn tekst noe sted.';
$string['guestskey'] = 'Tillat gjester som har påmeldingsnøkkel';
$string['guestsno'] = 'Ikke tillat gjester';
$string['guestsnotallowed'] = 'Beklager, \'{$a}\' er ikke åpen for gjester.';
$string['guestsyes'] = 'Tillat gjester uten påmeldingsnøkkel';
$string['guestuser'] = 'Gjestebruker';
$string['guestuserinfo'] = 'Denne brukeren er en spesialbruker som har lesetilgang til noen kurs.';
$string['help'] = 'Hjelp';
$string['helpprefix2'] = 'Hjelp med {$a}';
$string['helpwiththis'] = 'Hjelp med dette';
$string['hiddenassign'] = 'Skjult vurdering';
$string['hiddenfromstudents'] = 'Skjult for studenter';
$string['hiddensections'] = 'Skjulte seksjoner';
$string['hiddensectionscollapsed'] = 'Skjulte seksjoner vises i komprimert form';
$string['hiddensections_help'] = '<p>Dette valget lar deg bestemme hvordan skjulte emner skal vises for deltakerne.
</p>

<p>Som standard vises et smalt emnefelt hvor selve innholdet er skjult. Da ser deltakeren at det er et emnefelt der, men det er ikke tilgjengelig for øyeblikket. Denne visningformen er spesielt nyttig i kurs med uke-oppsett, slik at uker inn i fremtiden ikke vises før tiden er inne.
</p>

<p>Dersom du vil kan emnefelt skjules helt, slik at deltakere ikke engang ser at det skulle vært noe der.
</p>';
$string['hiddensectionsinvisible'] = 'Skjulte seksjoner er helt usynlige';
$string['hide'] = 'Skjul';
$string['hideadvancedsettings'] = 'Skjul avanserte innstillinger';
$string['hidepicture'] = 'Skjul bilde';
$string['hidesection'] = 'Skjul sekjson {$a}';
$string['hidesettings'] = 'Skjul innstillinger';
$string['hideshowblocks'] = 'Skjul eller vis blokker';
$string['hits'] = 'Treff';
$string['hitsoncourse'] = 'Treff på {$a->coursename} av {$a->username}';
$string['hitsoncoursetoday'] = 'Dagens treff på {$a->coursename} av {$a->username}';
$string['home'] = 'Hjem';
$string['hour'] = 'time';
$string['hours'] = 'timer';
$string['howtomakethemes'] = 'Lage nye tema';
$string['htmleditor'] = 'Bruk HTML-editoren';
$string['htmleditoravailable'] = 'HTML-editoren er tilgjengelig';
$string['htmleditordisabled'] = 'Du har koblet ut HTML-editoren i din profil';
$string['htmleditordisabledadmin'] = 'Administratoren har koblet ut HTML-editoren på denne siden.';
$string['htmleditordisabledbrowser'] = 'HTML-editoren er ikke tilgjengelig fordi den ikke blir støttet av nettleseren din.';
$string['htmlfilesonly'] = 'Bare HTML-filer';
$string['htmlformat'] = 'HTML-format';
$string['icon'] = 'Ikon';
$string['icqnumber'] = 'ICQ-nummer';
$string['idnumber'] = 'ID-nummer';
$string['idnumbercourse'] = 'Kurs IDnummer';
$string['idnumbercoursecategory'] = 'Kategori ID-nummer';
$string['idnumbercoursecategory_help'] = 'ID-nummeret til en kurskategori brukes bare når kurskategorien skal matches mot eksterne systemer og blir ikke vist andre steder på kursportalen. Dersom kategorien har et offisielt kodenavn kan det legges inn, i alle andre situasjoner kan du la feltet stå tomt.';
$string['idnumbercourse_help'] = '<p>ID-nummer på kurs brukes bare når det skal kobles mot eksterne systemer - det vil aldri vises i Moodle. Dersom du har en offisiell kode for kurset kan du bruke denne her. I alle andre tilfeller kan du la feltet være tomt.</p>';
$string['idnumbergroup'] = 'Gruppe ID-nummer';
$string['idnumbergroup_help'] = 'ID-nummeret til en gruppe brukes bare når det skal matches med eksterne systemer og blir ikke vist andre steder på kursportalen. Dersom gruppen har en offisiell gruppekode kan du skrive den inn her, ellers kan du la feltet stå tomt.';
$string['idnumbergrouping'] = 'Tilgangsgruppe ID-nummer';
$string['idnumbergrouping_help'] = 'ID-nummeret til en tilgangsgruppe brukes bare når det skal matches mot eksterne systemer og blir ikke vist andre steder på kursportalen. Dersom en tilgangsgruppe har en offisiell kode kan du skrive den inn her, ellers kan du la feltet stå tomt.';
$string['idnumbermod'] = 'ID-nummer';
$string['idnumbermod_help'] = 'ID-numre er en måte å identifisere aktiviteten dersom du trenger å gjøre beregninger i karakterboka. Dersom en aktivitet ikke er inkludert i noen karakterberegning av denne typen kan du trygt la være å fylle ut dette feltet.

Manglende ID-nummer kan også angis i skjermbildet for redigering av karakterer, men er det satt i aktiviteten kan det bare endres der.';
$string['idnumbertaken'] = 'Dette ID-nummeret er allerede brukt';
$string['imagealt'] = 'Bildebeskrivelse';
$string['import'] = 'Hent';
$string['importdata'] = 'Hent inn kursdata';
$string['importdataexported'] = 'Data er hentet fra \'kildekurset\'.<br /> Fortsett med å importere til \'målkurset\'.';
$string['importdatafinished'] = 'Importen er ferdig! Gå videre til kurset ditt';
$string['importdatafrom'] = 'Finn et kurs å hente data fra';
$string['inactive'] = 'Inaktiv';
$string['include'] = 'Ta med';
$string['includeallusers'] = 'Ta med alle brukere';
$string['includecoursefiles'] = 'Ta med kursfiler';
$string['includecourseusers'] = 'Ta med deltakere i kurset';
$string['included'] = 'Tatt med';
$string['includelogentries'] = 'Ta med loggoppføringer';
$string['includemodules'] = 'Ta med moduler';
$string['includemoduleuserdata'] = 'Ta med modulens brukerdata';
$string['includeneededusers'] = 'Ta med nødvendige brukere';
$string['includenoneusers'] = 'Ikke ta med brukere';
$string['includeroleassignments'] = 'Inkluder rolleoppgaver';
$string['includesitefiles'] = 'Inkluder nettstedfiler brukt i dette kurset';
$string['includeuserfiles'] = 'Ta med brukerfiler';
$string['increasesections'] = 'Øk antall emner';
$string['info'] = 'Informasjon';
$string['institution'] = 'Institusjon';
$string['instudentview'] = 'i studentvisning';
$string['interests'] = 'Interesser';
$string['interestslist'] = 'Liste med interesser';
$string['interestslist_help'] = 'Skriv inn dine interesser separert med komma.';
$string['invalidemail'] = 'Feil e-postadresse';
$string['invalidlogin'] = 'Feil under innlogging. Prøv på nytt';
$string['invalidusername'] = 'Brukernavnet kan bare inneholde tall og bokstaver, underscore, bindestrek eller @';
$string['invalidusernameupload'] = 'Ugyldig brukernavn';
$string['ip_address'] = 'IP-adresse';
$string['jump'] = 'Hopp';
$string['jumpto'] = 'Hopp til...';
$string['keep'] = 'Behold';
$string['keepsearching'] = 'Fortsett å lete';
$string['langltr'] = 'Skriftretning fra venstre til høyre';
$string['langrtl'] = 'Skriftretning fra høyre til venstre';
$string['language'] = 'Språk';
$string['languagegood'] = 'Denne språkpakken er oppdatert!   :-)';
$string['last'] = 'Siste';
$string['lastaccess'] = 'Sist innlogget';
$string['lastcourseaccess'] = 'Siste innlogging i kurset';
$string['lastedited'] = 'Sist redigert';
$string['lastlogin'] = 'Siste innlogging';
$string['lastmodified'] = 'Sist endret';
$string['lastname'] = 'Etternavn';
$string['lastnamephonetic'] = 'Etternavn - fonetisk';
$string['lastsiteaccess'] = 'Siste innlogging på portalen';
$string['lastyear'] = 'I fjor';
$string['latestlanguagepack'] = 'Se etter siste versjon språkfil på moodle.org';
$string['layouttable'] = 'Layout tabell';
$string['leavetokeep'] = 'La denne stå blank for å beholde gjeldende passord';
$string['legacythemeinuse'] = 'Denne portalen vises nå i kompatibilitetsmodus fordi nettleseren din er for gammel.';
$string['license'] = '(C) Lisens';
$string['licenses'] = 'Lisenser';
$string['liketologin'] = 'Har du lyst til å logge inn med en komplett brukerkonto?';
$string['list'] = 'Liste';
$string['listfiles'] = 'Liste over filer i {$a}';
$string['listofallpeople'] = 'Vis alle';
$string['listofcourses'] = 'Kursliste';
$string['loadinghelp'] = 'Laster...';
$string['local'] = 'Lokal';
$string['localplugins'] = 'Lokale moduler';
$string['localpluginsmanage'] = 'Administrere lokale moduler';
$string['location'] = 'Sted';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Du er logget inn som {$a}';
$string['loggedinasguest'] = 'Du er nå inne som gjest';
$string['loggedinnot'] = 'Du er ikke logget inn.';
$string['login'] = 'Logg inn';
$string['loginalready'] = 'Du er allerede innlogget';
$string['loginas'] = 'Logg inn som';
$string['loginaspasswordexplain'] = '<p>Du må skrive inn det spesielle "logg inn som passord" for å bruke denne tjenesten.<br />Hvis du ikke kjenner til det, spør administrator for nettjeneren.';
$string['login_failure_logs'] = 'Logg over mislykkede innlogginger';
$string['loginguest'] = 'Logg inn som gjest';
$string['loginsite'] = 'Logg inn på portalen';
$string['loginsteps'] = 'Hei! For å få full tilgang til kursene må du bruke litt tid til å opprette en ny konto til deg selv på dette nettstedet.
Hvert av kursene kan også ha en påmeldingssnøkkel, men den trenger du ikke før senere. Gjør som følger:
<ol>
<li>Registrer deg som <a href="{$a}">ny bruker</a>. Du må ha en gyldig e-postadresse for å få gjort dette.</li>
<li>En e-post blir med en gang sendt til din e-postadresse.</li>
<li>Les denne e-posten og klikk på lenken som følger med.</li>
<li>Kontoen din vil bli godkjent og du kan logge deg inn.</li>
<li>Velg kurs du skal melde deg på.</li>
<li>Hvis du blir bedt om en \'påmedingssnøkkel\', skriver du inn den som du har fått av læreren din.
Dette vil melde deg på kurset.</li>
<li>Fra nå av trenger du bare å logge deg på med ditt brukernavn og passord for å få tilgang til kurset. NB! Du bruker samme brukerkonto selv om du deltar på flere kurs!</li>
</ol>';
$string['loginstepsnone'] = '<p>Hei!</p><p>For å få full tilgang til kurs må du
opprette en konto.</p><p> Du må skrive et brukernavn og passord i dette skjemaet.</p><p>Hvis noen allerede har valgt brukernavnet du oppgir, må du prøve på nytt med et annet.</p>';
$string['loginto'] = 'Logg inn på {$a}';
$string['logout'] = 'Logg ut';
$string['logoutconfirm'] = 'Ønsker du virkelig å logge ut?';
$string['logs'] = 'Logger';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">mer</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">mer</a> ]';
$string['lookback'] = 'Se tilbake';
$string['mailadmins'] = 'Meld fra til administratorene';
$string['mailstudents'] = 'Meld fra til studentene';
$string['mailteachers'] = 'Meld fra til lærerne';
$string['maincoursepage'] = 'Kursets hovedside';
$string['makeafolder'] = 'Lag ei mappe';
$string['makeeditable'] = 'Hvis du gjør \'{$a}\' skrivbar av tjeneren (f.eks. apache) kan du redigere denne fila direkte fra denne siden';
$string['makethismyhome'] = 'Gjør dette til min standard startside';
$string['manageblocks'] = 'Blokker';
$string['managecategorythis'] = 'Administrer denne kategorien';
$string['managecourses'] = 'Administrer kurs';
$string['managedatabase'] = 'Behandle database';
$string['manageeditorfiles'] = 'Administrer filer brukt av forfatteren';
$string['managefilters'] = 'Filtre';
$string['managemodules'] = 'Moduler';
$string['manageroles'] = 'Roller og tillatelser';
$string['markedthistopic'] = 'Dette emnet er markert som det mest aktuelle emnet nå';
$string['markthistopic'] = 'Uthev denne emneboksen som mest aktuell';
$string['matchingsearchandrole'] = 'Finn samsvar mellom \'{$a->search}\' og  {$a->role}';
$string['maxareabytesreached'] = 'Denne filen (eller den sammenlagte størrelsen av flere filer) er større enn plassen som er igjen i dette området.';
$string['maxbytesforfile'] = 'Filen {$a} er større enn den tillatte maksstørrelsen.';
$string['maxfilesize'] = 'Maks størrelse for nye filer: {$a}';
$string['maxfilesreached'] = 'Du har tillatelse til å legge til maksimum {$a} fil(er) til dette elementet.';
$string['maximumchars'] = 'Maks {$a} tegn';
$string['maximumgrade'] = 'Høyeste karakter';
$string['maximumgradex'] = 'Høyeste karakter: {$a}';
$string['maximumshort'] = 'Maks';
$string['maximumupload'] = 'Maksimum opplastningsstørrelse';
$string['maximumupload_help'] = '<p>
Denne innstillingen bestemmer maksimum størrelse på filene som studentene får
laste opp til denne klassen. Det fins også en overordnet maksimumsverdi for hele
nettstedet satt av administrator.&nbsp;
</p>
<p>
Du kan begrense denne størrelse ytterligere gjennom innstillingene for hver
aktivitet.&nbsp;
</p>';
$string['maxnumberweeks'] = 'Maximum antall uker/emner';
$string['maxnumberweeks_desc'] = 'Dette styrer maksvalget som skal vises i "Antall uker/emner"-innstillingen for kurs (gjelder kun bestemte kursformat).';
$string['maxnumcoursesincombo'] = 'Vis <a href="{$a->link}">{$a->numberofcourses} kurs</a>.';
$string['maxsize'] = 'Maks størrelse: {$a}';
$string['maxsizeandareasize'] = 'Maks størrelse for nye filer: {$a->size}, samlet grense: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maks størrelse for nye filer: {$a->size}, maks antall vedlegg: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maks størrelse for nye filer: {$a->size}, maks antall vedlegg: {$a->attachments}, samlet grense: {$a->areasize}';
$string['memberincourse'] = 'Deltakere i kurs';
$string['messagebody'] = 'Meldingskropp';
$string['messagedselectedusers'] = 'De valgte brukerne har mottatt meldinger og mottakerlisten har blitt tilbakestilt.';
$string['messagedselectedusersfailed'] = 'Noe gikk galt da melding ble sendt til utvalgte brukere. Noen har kanskje mottatt meldingen.';
$string['messageprovider:availableupdate'] = 'Tilgjengelige varslinger om oppdateringer';
$string['messageprovider:backup'] = 'Sikkerhetskopimeldinger';
$string['messageprovider:badgecreatornotice'] = 'Meldinger til utstederen av utmerkelsen';
$string['messageprovider:badgerecipientnotice'] = 'Meldinger til mottakere av utmerkelsen';
$string['messageprovider:courserequestapproved'] = 'Melding om godkjenning av kursønske';
$string['messageprovider:courserequested'] = 'Melding om kursønske';
$string['messageprovider:courserequestrejected'] = 'Melding om avslag på kursønske';
$string['messageprovider:errors'] = 'Viktige feilmeldinger på denne portalen';
$string['messageprovider:errors_help'] = 'Dette er viktige feilmeldinger som en administrator bør kjenne til.';
$string['messageprovider:instantmessage'] = 'Personlige meldinger mellom brukere';
$string['messageprovider:instantmessage_help'] = 'Denne seksjonen konfigurerer hva som skal skje med meldinger som sendes rett til deg fra andre brukere på portalen.';
$string['messageprovider:notices'] = 'Melding om mindre problemer';
$string['messageprovider:notices_help'] = 'Dette er meldinger som en administrator kan være interessert i å se.';
$string['messageselect'] = 'Velg denne brukeren som meldingsmottaker';
$string['messageselectadd'] = 'Send en melding';
$string['middlename'] = 'Mellomnavn';
$string['migratinggrades'] = 'Slår sammen karakterer';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minutt';
$string['minutes'] = 'minutter';
$string['miscellaneous'] = 'Diverse';
$string['missingcategory'] = 'Du må velge en kategori';
$string['missingcity'] = 'Mangler sted';
$string['missingcountry'] = 'Mangler land';
$string['missingdescription'] = 'Mangler beskrivelse';
$string['missingemail'] = 'Mangler e-postadresse';
$string['missingfirstname'] = 'Mangler fornavn';
$string['missingfromdisk'] = 'Mangler fra disk';
$string['missingfullname'] = 'Mangler fullt navn';
$string['missinglastname'] = 'Mangler etternavn';
$string['missingname'] = 'Mangler navn';
$string['missingnewpassword'] = 'Mangler nytt passord';
$string['missingpassword'] = 'Mangler passord';
$string['missingrecaptchachallengefield'] = 'Mangler reCAPTCHA utfyllingsfelt';
$string['missingreqreason'] = 'Mangler grunn';
$string['missingshortname'] = 'Mangler kort navn';
$string['missingshortsitename'] = 'Mangler kort kursnavn';
$string['missingsitedescription'] = 'Mangler kursbeskrivelse';
$string['missingsitename'] = 'Mangler kursnavn';
$string['missingstrings'] = 'Se etter manglende oversettelser';
$string['missingstudent'] = 'Du må velge noe';
$string['missingsummary'] = 'Mangler sammendrag';
$string['missingteacher'] = 'Du må velge noe';
$string['missingurl'] = 'Manglende URL';
$string['missingusername'] = 'Mangler brukernavn';
$string['modchooserdisable'] = 'Aktivitetsvelger AV';
$string['modchooserenable'] = 'Aktivitetsvelger PÅ';
$string['moddoesnotsupporttype'] = 'Modulen {$a->modname} støtter ikke opplastinger av typen {$a->type}';
$string['modified'] = 'Endret';
$string['moduleintro'] = 'Beskrivelse';
$string['modulesetup'] = 'Setter opp modultabell';
$string['modulesuccess'] = '{$a} tabeller opprettet';
$string['modulesused'] = 'Moduler brukt';
$string['month'] = 'Måned';
$string['months'] = 'Måneder';
$string['moodledocs'] = 'Moodle dokumentasjon';
$string['moodledocslink'] = 'Moodledokumentasjon for denne siden';
$string['moodlerelease'] = 'Moodle utgivelse';
$string['moodleversion'] = 'Moodle versjon';
$string['more'] = 'mer';
$string['morehelp'] = 'Mer hjelp';
$string['moreinformation'] = 'Mer informasjon...';
$string['moreprofileinfoneeded'] = 'Fortell oss mer om deg selv';
$string['mostrecently'] = 'siste';
$string['move'] = 'Flytt';
$string['movecategoriessuccess'] = 'Flyttingen av {$a->count} kategorier til kategorien \'{$a->to}\' var vellykket.';
$string['movecategoriestotopsuccess'] = 'Flyttingen av {$a->count} kategorier til toppnivået var vellykket.';
$string['movecategorycontentto'] = 'Flytt til';
$string['movecategorysuccess'] = 'Flyttingen av kategorien \'{$a->moved}\' til kategorien \'{$a->to}\' var vellykket';
$string['movecategoryto'] = 'Flytt kategori til:';
$string['movecategorytotopsuccess'] = 'Flyttingen av kategorien \'{$a->moved}\' til toppnivået var vellykket';
$string['movecontent'] = 'Flytt {$a}';
$string['movecontentstoanothercategory'] = 'Flytt innholdet til en annen kategori';
$string['movecoursemodule'] = 'Flytt ressurs';
$string['movecoursesection'] = 'Flytt emne';
$string['movecourseto'] = 'Flytt kurs til:';
$string['movedown'] = 'Flytt ned';
$string['movefilestohere'] = 'Flytt filer hit';
$string['movefull'] = 'Flytt {$a} til denne plasseringen';
$string['movehere'] = 'Flytt hit';
$string['moveleft'] = 'Flytt til venstre';
$string['moveright'] = 'Flytt til høyre';
$string['movesection'] = 'Flytt seksjon {$a}';
$string['moveselectedcategoriesto'] = 'Flytt valgte kategorier til';
$string['moveselectedcoursesto'] = 'Flytt valgte kurs til...';
$string['movetoanotherfolder'] = 'Flytt til ei annen mappe';
$string['moveup'] = 'Flytt opp';
$string['msnid'] = 'MSN-ID';
$string['mustchangepassword'] = 'Det nye passordet må være forskjellig fra det forrige';
$string['mustconfirm'] = 'Du må godkjenne innloggingen din';
$string['mycourses'] = 'Mine kurs';
$string['myfiles'] = 'Mine private filer';
$string['myfilesmanage'] = 'Adminstrere mine private filer';
$string['myhome'] = 'Min startside';
$string['mymoodledashboard'] = 'Min Moodle kontrollpanel';
$string['myprofile'] = 'Min profil';
$string['name'] = 'Navn';
$string['nameforlink'] = 'Hva ønsker du å kalle denne lenken?';
$string['nameforpage'] = 'Navn';
$string['navigation'] = 'Navigering';
$string['needed'] = 'Nødvendig';
$string['never'] = 'Aldri';
$string['neverdeletelogs'] = 'Slett aldri logger';
$string['new'] = 'Ny';
$string['newaccount'] = 'Ny brukerkonto';
$string['newcourse'] = 'Nytt kurs';
$string['newpassword'] = 'Ditt ønskede passord';
$string['newpasswordfromlost'] = '<strong>NB:</strong> Ditt <strong>nåværende passord</strong> har blitt sendt til deg i den<strong>andre</strong> av de to meldinger sendt til deg i forbindelse med prosessen for å gjenopprette passordet. Pass på at du har mottatt erstatningspassordet før du fortsetter med dette skjermbildet.';
$string['newpassword_help'] = '<p>La feltet stå tomt for å beholde gjeldende passord.</p>';
$string['newpasswordtext'] = 'Hei {$a->firstname},
Ditt passord på \'{$a->sitename}\' er slettet og du har fått et midlertidig passord.
Din innloggingsinformasjon er nå:
   brukernavn: {$a->username}
      passord: {$a->newpassword}

Med vennlig hilsen
{$a->signoff}';
$string['newpicture'] = 'Nytt bilde';
$string['newpicture_help'] = '<P>Du kan laste opp et bilde fra datamaskinen din serveren. Dette bildet blir
brukt flere steder i systemet for å representere deg, blant annet i din profil.
<P>Det anbefales at du laster opp et bilde av deg selv. Bildet bør være et
nærbilde av ansiktet ditt, ettersom det ikke blir vist særlig stort i Moodle.
<P>Merk at bildet bør være kvadratisk, ellers blir det automatisk beskjært.<p>
Dersom du har et bilde av deg f.eks. på en nettside (hjemmeside) kan du først
høyreklikke på bildet, velg &quot;Lagre bilde som...&quot; og deretter lagre det på
harddisken eller diskett. Når du har gjort dette kan du bla bildet fram i Moodle
og laste det opp (kopiere) til serveren. </p>
<p>Bildet må være i JPG- eller PNG-format (dvs. filnavnet slutter vanligvis på .jpg
eller .png). </p>
<p>Du kan lage en helt ny bildefil med en av metodene nedenfor: </p>
<ol>
  <li>Du kan bruke et digitalt kamera. Dette innebærer at bildet lett kan hentes
  fra din datamaskin og i riktig format. dator och i rätt format. </li>
  <li>Du kan bruke en skanner for å skanne et papirbilde. Sørg for å lagre
  bildet i JPG- eller PNG-format. </li>
  <li>Du kan hente det fra Internett. Høyreklikk på bildet og velg &quot;Lagre bilde
  som&quot;. </li>
</ol>
<p>For å laste opp bildet til Moodle klikker du på knappen &quot;Bla gjennom...&quot; på
denne siden og velger bildet fra harddisken din (eller CD-ROM, diskett etc.) </p>
<p>OBS! Pass på at bildet ikke er større enn angitt maks størrelse, ellers blir
det ikke lastet opp.&nbsp; </p>
<p>Klikk deretter på &quot;Lagre endringer i min profil&quot; nederst til høyre - bildet beskjæres til
et kvadrat og skaleres ned til en størrelse på 100x100 piksler. </p>
<p>Når du kommer til din profil vises kanskje ikke det nye bildet. Dersom dette
skjer, må du klikke på &quot;Oppdater&quot; (F5) i nettleseren din. </p>';
$string['newsitem'] = 'nyhet';
$string['newsitems'] = 'nyheter';
$string['newsitemsnumber'] = 'Antall nyheter som skal vises';
$string['newsitemsnumber_help'] = '<P>Dette er et spesielt forum som ofte heter &quot;Oppslagstavle&quot; eller "Nyhetsforum". Det vises i uke- og
emneformat. Dette egner seg godt til å skrive beskjeder til studentene i
klassen. (Læreren kan avgjøre om alle skal motta e-poster
   fra dette forumet eller om studentene velger dette selv.)

<P>Nyhetene i dette forumet (nyhetsforumet) kommer i en boks øverst til høyre på
skjermen i Moodle. Du bestemmer her hvor mange nyheter som skal
   vises i denne (på fagets forside). Alle nyhetene kan leses fra selve forumet,
men bare det antallet du setter her vil vises under &quot;Siste nyheter&quot; til høyre på
skjermen.

<P>Setter du denne  til "0 nyheter" vil ikke
   nyhetsboksen bli vist.';
$string['newuser'] = 'Ny bruker';
$string['newusernewpasswordsubj'] = 'Ny brukerkonto';
$string['newusernewpasswordtext'] = 'Hei {$a->firstname},
En ny konto er opprettet for deg på \'{$a->sitename}\' og du har fått et nytt midlertidig passord.
Din aktuelle innloggingsinformasjon er nå:
brukernavn: {$a->username}
passord: {$a->newpassword}
(må må forandre passordet når du logger inn første gang)
For å begynne å bruker \'{$a->sitename}\', logger du inn på {$a->link}
I de fleste e-postprogrammer vil det være en blå lenke som du kan klikke på. Hvis det ikke virker, kan du klippe og lime adressen inn i adressefeiltet på toppen av nettleservinduet ditt.
Vennlig hilsen fra administrator på \'{$a->sitename}\',
{$a->signoff}';
$string['newusers'] = 'Nye brukere';
$string['newwindow'] = 'Nytt vindu';
$string['next'] = 'Neste';
$string['nextsection'] = 'Neste seksjon';
$string['no'] = 'Nei';
$string['noblockstoaddhere'] = 'Det finnes ingen blokker å legge til på denne siden.';
$string['nobody'] = 'Ingen';
$string['nochange'] = 'Ingen endring';
$string['nocomments'] = 'Ingen kommentarer';
$string['nocourses'] = 'Ingen kurs';
$string['nocoursesfound'] = 'Ingen kurs med ordene \'{$a}\' ble funnet';
$string['nocoursesyet'] = 'Ingen kurs i denne kategorien';
$string['nodstpresets'] = 'Administratoren har ikke skrudd på støtte for sommertid.';
$string['nofilesselected'] = 'Ingen filer valgt for tilbakeføring';
$string['nofilesyet'] = 'Ingen filer er lastet opp til siden ennå';
$string['nograde'] = 'Ingen karakter';
$string['nohelpforactivityorresource'] = 'Det er for tiden ingen hjelp assosiert med denne ressursen eller aktiviteten';
$string['noimagesyet'] = 'Ingen bilder er lastet opp til siden ennå';
$string['nologsfound'] = 'Ingen logger er funnet';
$string['nomatchingusers'] = 'Ingen brukere samsvarte med \'{$a}\'';
$string['nomorecourses'] = 'Ingen flere sider ble funnet';
$string['nomoreidnumber'] = 'For å unngå kollisjoner brukes ikke id-nummer';
$string['none'] = 'Ingen';
$string['noneditingteacher'] = 'Lærer  uten editor-rettigheter';
$string['noneditingteacherdescription'] = 'Gjestelærere kan undervise i et kurs og evaluere studenter, men ikke endre aktiviteter';
$string['nonstandard'] = 'Ikke-standard';
$string['nopendingcourses'] = 'Det er ingen kurs som venter på godkjenning';
$string['nopotentialadmins'] = 'Ingen potensielle adminer';
$string['nopotentialcreators'] = 'Ingen potensielle kursprodusenter';
$string['nopotentialstudents'] = 'Ingen potensielle studenter';
$string['nopotentialteachers'] = 'Ingen potensielle lærere';
$string['norecentactivity'] = 'Ingen nylig aktivitet';
$string['noreplybouncemessage'] = 'Du har svart på en e-post som ikke kan besvares. Hvis du prøvde å svare på et foruminnlegg, ber vi deg om å heller bruke forumene på {$a} .

Under vises e-posten du sendte:';
$string['noreplybouncesubject'] = '{$a} - returnert e-post';
$string['noreplyname'] = 'Ikke svar på denne e-posten';
$string['noresetrecord'] = 'Det er ingen oppføringer om denne forespørselen om nytt passord. Vennligst start en ny prosess for å få nytt passord.';
$string['noresults'] = 'Ingen resultater';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Normalt søk';
$string['nosite'] = 'Fant ikke kurset på site-nivå';
$string['nostudentsfound'] = 'Ingen {$a} funnet';
$string['nostudentsingroup'] = 'Det er ingen studenter på dette kurset ennå';
$string['nostudentsyet'] = 'Ingen studenterer i dette kurset  ennå';
$string['nosuchemail'] = 'E-postadressen finnes ikke';
$string['notavailable'] = 'Ikke tilgjengelig';
$string['noteachersyet'] = 'Ingen lærere i dette kurset ennå';
$string['notenrolled'] = '{$a} er ikke meldt på dette kurset enda.';
$string['notenrolledprofile'] = 'Denne profilen er ikke tilgjengelig siden aktuell bruker ikke er påmeldt i dette kurset.';
$string['noteusercannotrolldatesoncontext'] = '<strong>MERK:</strong> Muligheten til å rullere datoer ved gjenoppretting fra denne sikkerhetskopien er deaktivert siden du ikke har tilstrekkelig rettigheter.';
$string['noteuserschangednonetocourse'] = 'OBS: Brukerkontoene må også gjenopprettes når du gjenoppretter brukerdata. Denne innstillingen er endret for deg.';
$string['nothingnew'] = 'Ingenting nytt siden sist du var her';
$string['nothingtodisplay'] = 'Ingenting å vise';
$string['notice'] = 'Merknad';
$string['noticenewerbackup'] = 'Denne sikkerhetskopien er laget med Moodle {$a->backuprelease} ({$a->backupversion}) og den er nyere enn den versjonen av Moodle du har installert, $a-<serverrelease ({$a->serverversion}). Siden nye moduler ikke alltid kan brukes på eldre versjoner, kan dette føre til problemer.';
$string['notifications'] = 'Meldinger';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Bruker: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Du kan se disse loggene på {$a}/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Her er en liste over mislykkede innlogginger på {$a} siden sist du ble varslet.';
$string['notifyloginfailuressubject'] = '{$a}:: Varsel om mislykkede innlogginger';
$string['notincluded'] = 'Ikke inkludert';
$string['notingroup'] = 'Beklager, du må være med i en gruppe for å se denne aktiviteten.';
$string['notpublic'] = 'Ikke offentlig!';
$string['nousersfound'] = 'Ingen brukere funnet';
$string['nousersmatching'] = 'Ingen treff på bruker \'{$a}\' ble funnet';
$string['nousersyet'] = 'Det finnes ingen brukere ennå';
$string['novalidcourses'] = 'Ingen gyldige kurs å vise';
$string['now'] = 'nå';
$string['numattempts'] = '{$a} mislykkede innloggingsforsøk';
$string['numberofcourses'] = 'Antall kurs';
$string['numberweeks'] = 'Antall uker/emner';
$string['numdays'] = '{$a} dager';
$string['numhours'] = '{$a} timer';
$string['numletters'] = '{$a} bokstaver';
$string['numminutes'] = '{$a} minutter';
$string['nummonths'] = '{$a} måneder';
$string['numseconds'] = '{$a} sekunder';
$string['numviews'] = '{$a} visninger';
$string['numweeks'] = '{$a} uker';
$string['numwords'] = '{$a} ord';
$string['numyears'] = '{$a} år';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Gjeldende passord <br />(eller nettopp tilsendt på e-post)';
$string['olduserdirectory'] = 'Dette er den GAMLE brukerkatalogen og trengs ikke lenger. Du kan trygt fjerne den. Filene den inneholder har blitt kopiert til den NYE brukerkatalogen.';
$string['opentoguests'] = 'Gjestetilgang';
$string['optional'] = 'valgfri';
$string['options'] = 'alternativer';
$string['order'] = 'Sortering';
$string['originalpath'] = 'Original sti';
$string['orphanedactivitiesinsectionno'] = 'Aktiviteter uten tilknytning (emne {$a})';
$string['other'] = 'Andre';
$string['outline'] = 'Oversikt';
$string['outlinereport'] = 'Oversiktsrapport';
$string['page'] = 'Side';
$string['pagea'] = 'Side {$a}';
$string['pageheaderconfigablock'] = 'Setter opp en boks i {$a->fullname}';
$string['pagepath'] = 'Sti til siden';
$string['pageshouldredirect'] = 'Denne siden skal automatisk videresende. Dersom ingenting skjer kan du bruke lenken under.';
$string['parentcategory'] = 'Overordnet kategori';
$string['parentcoursenotfound'] = 'Overordnet kurs ble ikke funnet.';
$string['parentfolder'] = 'Overordnet mappe';
$string['participants'] = 'Deltagere';
$string['participantslist'] = 'Deltakerliste';
$string['participationratio'] = 'Forberedelsesforholdstall';
$string['participationreport'] = 'Deltakerrapport';
$string['password'] = 'Passord';
$string['passwordchanged'] = 'Passordet er endret';
$string['passwordconfirmchange'] = 'Bekreft passordbytte';
$string['passwordextlink'] = 'Følgende lenke tilbyes for at du kan gjenopprette ditt tapte passord. Dette vil ta deg ut av Moodle.';
$string['passwordforgotten'] = 'Glemt passord';
$string['passwordforgotteninstructions'] = 'Brukerinformasjonen din må først finnes fram fra Moodle databasen. Vær vennlig å legge inn <strong>enten</strong> ditt Moodle brukernavn eller den registerte epost-adressen i passende felt. Det er ikke behov for at du legger inn begge deler.';
$string['passwordforgotteninstructions2'] = 'For å tilbakestille passordet må du fylle inn ENTEN brukernavnet ELLER passordet ditt.

Dersom vi finner deg i databasen får du en e-post med instruksjoner om hvordan du skal få logget inn.

Får du ingen e-post innen rimelig tid betyr det at e-informasjonen du skrev inn var feil. Har du flere e-postadresser bør du sjekke alle før du kontakter Support.';
$string['passwordnohelp'] = 'Ingen hjelp tilgjengelig for å finne ditt tapte passord. Vær vennlig kontakt din Moodle administrator.';
$string['passwordrecovery'] = 'Ja, hjelp meg å logge inn';
$string['passwordsdiffer'] = 'Passordene stemmer ikke overens';
$string['passwordsent'] = 'Passordet er sendt';
$string['passwordsenttext'] = '<p>En e-post er sendt til deg på {$a->email}.</p>
   <p><b>Vennligst sjekk e-posten din for nytt passord</b></p>
   <p>Det nye passordet er laget automatisk, så du burde
   <a href="{$a->link}">endre det til noe enklere</a>.</p>
   <p>Slett denne e-posten når du er ferdig med å bytte passord.</p>';
$string['passwordset'] = 'Passordet ditt har blitt satt.';
$string['path'] = 'Sti';
$string['pathnotexists'] = 'Filbanen finnes ikke på tjeneren!';
$string['pathslasherror'] = 'Filbanen kan ikke ende med en skråstrek.';
$string['paymentinstant'] = 'Bruk knappen under for å betale og melde deg på kurset.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pågående </small>)';
$string['paymentrequired'] = 'Dette er et kurs som krever betaling';
$string['payments'] = 'Innbetalinger';
$string['paymentsorry'] = 'Takk for betalingen! Dessverre er ikke innbetalingen ferdigbehandlet, så du har ennå ikke blitt registrert som student på kurset "{$a->fullname}".
Prøv å gå videre til kurset om noen sekunder. Hvis problemene fortsetter kan du ta kontakt med {$a->teacher} eller nettstedets administrator.';
$string['paymentthanks'] = 'Takk for betalingen! Du er nå påmeldt kurset: >br/> "{$a}"';
$string['pendingrequests'] = 'Forespørselen er under vurdering';
$string['periodending'] = 'Peridoen slutter ({$a})';
$string['perpage'] = 'Per side';
$string['perpagea'] = 'Per side: {$a}';
$string['personal'] = 'Personlig';
$string['personalprofile'] = 'Personlig profil';
$string['phone'] = 'Telefon';
$string['phone2'] = 'Mobiltelefon';
$string['phpinfo'] = 'PHP-info';
$string['pictureof'] = 'Bilde av {$a}';
$string['pictureofuser'] = 'Profilbilde';
$string['pleaseclose'] = 'Vennligst lukk dette vinduet';
$string['pleasesearchmore'] = 'Vennligst forsøk flere søk';
$string['pleaseusesearch'] = 'Vennligst prøv søkefunksjonen';
$string['plugin'] = 'Modul';
$string['plugincheck'] = 'Sjekk plugins';
$string['plugindeletefiles'] = 'Alle data assossiert med modulen  \'{$a->name}\'  er nå slettet fra databasen. For å forhindre at modulen reinstallerer seg selv må du slette modulen fra serveren: {$a->directory} ';
$string['pluginsetup'] = 'Setter opp pluggbare tabeller';
$string['policyaccept'] = 'Jeg forstår og godtar';
$string['policyagree'] = 'Du må godta avtalen for å bruke dette nettstedet. Godtar du den?';
$string['policyagreement'] = 'Avtale for bruk av portalen';
$string['policyagreementclick'] = 'Klikk her for å lese bruksavtalen';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Åpne fila i et nytt vindu';
$string['popupwindowname'] = 'Popup-vindu';
$string['post'] = 'Innlegg';
$string['posts'] = 'Innlegg';
$string['potentialadmins'] = 'Mulige administratorer';
$string['potentialcreators'] = 'Mulige kursprodusenter';
$string['potentialstudents'] = 'Mulige studenter';
$string['potentialteachers'] = 'Mulige lærere';
$string['preferences'] = 'Preferanser';
$string['preferredlanguage'] = 'Språk';
$string['preferredtheme'] = 'Foretrukket utseende';
$string['preprocessingbackupfile'] = 'Forbereder sikkerhetskopifilen';
$string['prev'] = 'Forrige';
$string['preview'] = 'Forhåndsvis';
$string['previewhtml'] = 'Forhåndsvisning av HTML-format';
$string['previeworchoose'] = 'Forhåndsvis eller endre tema';
$string['previous'] = 'Forrige';
$string['previouslyselectedusers'] = 'Tidligere valgte brukere som ikke samsvarer med \'{$a}\'';
$string['previoussection'] = 'Forrige seksjon';
$string['primaryadminsetup'] = 'Setup administrator konto';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Denne profilbeskrivelsen vil ikke vises før en bruker er påmeldt i minst ett kurs.';
$string['publicprofile'] = 'Offentlig profil';
$string['publicsitefileswarning'] = 'Merk: Filer plassert her vil hvem som helst ha tilgang til';
$string['publicsitefileswarning2'] = '<strong>MERK:</strong> Filer du plasserer her er fritt tilgjengelig for alle som vet (eller kan gjette) URL-en. Av sikkerhetshensyn anbefales det at alle sikkerhetskopifiler slettes straks de er benyttet.';
$string['publicsitefileswarning3'] = 'MERK: Filer du laster opp her kan nås av alle som vet (eller kan gjette) URL-en. Av sikkerhetsgrunner bør du alltid lagre backupfiler i den sikre mappen "backupdata".';
$string['publish'] = 'Publisér';
$string['question'] = 'Spørsmål';
$string['questionsinthequestionbank'] = 'Spørsmål i testbanken';
$string['readinginfofrombackup'] = 'Leser informasjon fra sikkerhetskopi';
$string['readme'] = 'LES MEG';
$string['recentactivity'] = 'Siste aktiviteter';
$string['recentactivityreport'] = 'Full rapport over nylige aktiviteter';
$string['recipientslist'] = 'Mottakerliste';
$string['recreatedcategory'] = 'Gjenopprettet kategori {$a}';
$string['redirect'] = 'Videresend';
$string['reducesections'] = 'Minske antall uker/emner';
$string['refresh'] = 'Oppdatér';
$string['refreshingevents'] = 'Oppdaterer tilstelninger';
$string['registration'] = 'Moodleregistrering';
$string['registrationcontact'] = 'Kontakt med offentligheten';
$string['registrationcontactno'] = 'Nei, jeg ønsker ikke et kontaktskjema på lista over nettsteder';
$string['registrationcontactyes'] = 'Ja, sørg for at potensielle moodlere kan komme i kontakt med meg.';
$string['registrationemail'] = 'E-postmeldinger';
$string['registrationinfo'] = '<p>Denne siden lar deg registrere din Moodleside hos moodle.org. Registrering er gratis. Hovedfordelen med dette er at du blir lagt til en e-postliste med lite trafikk med viktige beskjeder som sikkerhetsadvarsler og nye versjoner av Moodle.</p> <p>Standard er at din informasjon holdes privat og vil aldri bli videreformidlet til andre. Den eneste årsaken til at vi samler inn denne informasjonen er for brukerstøtte og å lage et statistisk, helhetlig bilde av bruken av Moodle.<p>Hvis du velger dette kan du la navnet på siden, land og adresse bli lagt til listen over Moodlesider.</p> <p>Alle nyregistreringer bekreftes manuelt før de legges ut på listen, men du kan også endre denne informasjonen (og oppføringen på listen over Moodlesider) senere ved å fylle ut dette skjemaet på nytt.</p>';
$string['registrationinfotitle'] = 'Registreringsinformasjon';
$string['registrationno'] = 'Nei, jeg vil ikke motta e-post';
$string['registrationsend'] = 'Send informasjon til moodle.org';
$string['registrationyes'] = 'Ja, gi meg beskjed om viktige tema';
$string['reject'] = 'Avvis';
$string['rejectdots'] = 'Avvis...';
$string['reload'] = 'Last på nytt';
$string['remoteappuser'] = 'Ekstern {$a} Bruker';
$string['remove'] = 'Fjern';
$string['removeadmin'] = 'Fjern admin';
$string['removecreator'] = 'Fjern kursprodusent';
$string['removestudent'] = 'Fjern student';
$string['removeteacher'] = 'Fjern lærer';
$string['rename'] = 'Gi nytt navn';
$string['renamefileto'] = 'Gi <b>{$a}</b> nytt navn til';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapporter';
$string['repositories'] = 'Filarkiver';
$string['requestcourse'] = 'Søk om oppretting av kurs';
$string['requestedby'] = 'Søknad fra';
$string['requestedcourses'] = 'Ønskede kurs';
$string['requestreason'] = 'Grunn for kurssøknaden';
$string['required'] = 'Obligatorisk';
$string['requirespayment'] = 'Dette kurset krever innbetaling for å gi tilgang';
$string['reset'] = 'Tilbakestill';
$string['resetcomponent'] = 'Komponent';
$string['resetcourse'] = 'Tilbakestill kurset';
$string['resetinfo'] = 'Denne siden lar deg tømme et kurs for brukerdata, men beholder aktiviteten og andre innstillinger. Vær oppmerksom på at hvis du velger punkter under og sender inn siden, så vil du slette de valgte brukerdata fra dette kurset for alltid!';
$string['resetnotimplemented'] = 'Resetting ikke implementert';
$string['resetrecordexpired'] = 'Lenken for nytt passord som du benyttet er mer enn {$a} minutter gammel og har utløpt. Vennligst be om nytt passord på nytt.';
$string['resetstartdate'] = 'Tilbakestill startdato';
$string['resetstatus'] = 'Status';
$string['resettask'] = 'Oppgave';
$string['resettodefaults'] = 'Tilbakestill til standarsinnstillinger';
$string['resortbyfullname'] = 'Fullt navn';
$string['resortbyidnumber'] = 'Etter ID-nummer';
$string['resortbyshortname'] = 'Kortnavn';
$string['resortcourses'] = 'Sorter kurs';
$string['resortsubcategoriesbyidnumber'] = 'Sorter underkategorier på ID-nummer';
$string['resortsubcategoriesbyname'] = 'Sorter underkategorier på navn';
$string['resource'] = 'Ressurs';
$string['resourcedisplayauto'] = 'Automatisk';
$string['resourcedisplaydownload'] = 'Tving nedlasting';
$string['resourcedisplayembed'] = 'Inkludér';
$string['resourcedisplayframe'] = 'I ramme';
$string['resourcedisplaynew'] = 'Nytt vindu';
$string['resourcedisplayopen'] = 'Åpne';
$string['resourcedisplaypopup'] = 'I et popup-vindu';
$string['resources'] = 'Ressurser';
$string['resources_help'] = 'Ressurstyper aktiverer neste all slags webinnhold for bruk i kurs.';
$string['restore'] = 'Gjenoppretting';
$string['restorecancelled'] = 'Gjenoppretting avbrutt';
$string['restorecannotassignroles'] = 'Gjenopprettingen medfører rolletildelinger og du har ikke tillatelse til å gjøre dette';
$string['restorecannotcreateorassignroles'] = 'Gjenopprettingen medfører oppretting eller tildeling av roller og du har ikke tillatelse til å gjøre dette';
$string['restorecannotcreateuser'] = 'Gjenopprettingsmodulen har behov for å opprette brukeren  \'{$a}\'  fra sikkherhetskopien og du har ikke rett til å opprette brukere.';
$string['restorecannotoverrideperms'] = 'Gjenopprettingen medfører at tillatelser må overstyres og du har ikke tillatelse til å gjøre dette';
$string['restorecoursenow'] = 'Gjennopprett denne siden nå.';
$string['restoredaccount'] = 'Gjenopprettet brukerkonto';
$string['restoredaccountinfo'] = 'Denne brukerkontoen ble importert fra en annen installasjon og passorder er gått tapt. Klikk på "Fortsett" for å angi nytt passord via e-post';
$string['restorefinished'] = 'Gjenoppretting fullført';
$string['restoreto'] = 'Gjenopprett til';
$string['restoretositeadding'] = 'Advarsel: Du er i ferd med å gjenopprette hovedsiden ved å legge til data til den!';
$string['restoretositedeleting'] = 'Advarsel: Du er i ferd med å gjenopprette/erstatte hovedsiden ved å først slette eksisterende!';
$string['restoreuserconflict'] = 'Dersom du gjenopprette bruker \'{$a}\' fra sikkerhetskopien vil det gi konflikt med eksisterende bruker.';
$string['restoreuserinfofailed'] = '<strong>ADVARSEL:</strong> For å kunne gjenopprette brukerdata (i aktiviteter, filer, meldinger osv...) må rettigheten "moodle/restore:userinfo" være på "Tillat" og denne rettigheten er ikke satt. Gjenopprettingsprosessen er derfor stoppet.';
$string['restoreusersprecheck'] = 'Sjekker brukerdata';
$string['restoreusersprecheckerror'] = 'Det ble oppdaget noen problemer under sjekk av brukerdata.';
$string['restricted'] = 'Begrenset';
$string['returningtosite'] = 'Registrert bruker?';
$string['returntooriginaluser'] = 'Tilbake til {$a}';
$string['revert'] = 'Tilbakestill';
$string['role'] = 'Rolle';
$string['roleassignments'] = 'Rolletildelinger';
$string['rolemappings'] = 'Rolletildelinger';
$string['rolerenaming'] = 'Gi rolle nytt navn';
$string['rolerenaming_help'] = '<p>Dette valget lar deg endre navnet som skal vises for en eller flere roller i kurset ditt. F.eks. kan det være at du vil at "Lærer" i stedet skal hete "Veileder" eller "Instruktør". Bare visningen av rollenavnet endres - de underliggende rollerettighetene berøres ikke.</p>

<p>Disse endrede rollenavnene vil vises i kursets deltakerliste og andre steder i kurset. Endres "Lærer" til et annet rollenavn, vil dette rollenavnet synes i kursbeskrivelsen i kurskatalogen.</p>

<p>Nye rollenavn blir bare tatt med i kursbackup dersom de er tildelt brukere.</p>';
$string['roles'] = 'Roller';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Antall nye RSS-utsendinger';
$string['rsserror'] = 'Feil ved lesing av RSS-data';
$string['rsserrorauth'] = 'RSS-lenken din inneholder ingen gyldig kodestreng.';
$string['rsserrorguest'] = 'Denne feeden bruker gjestetilgang til å hente data, men gjester har ikke tilgang til å lese data. Gå til orginalinnstillingene hvor denne feeden kommer fra (URL\'en) som gyldig bruker og hent en ny RSS lenke der.';
$string['rsskeyshelp'] = 'For å styrke sikkerheten og personvernet, inneholder RSS-strømmer en spesiell token som identifiserer brukeren de sendes til. Dette forhindrer andre brukere å få tilgang til områder i Moodle de ikke skal ha adgang til via RSS-strømmer. </p><p>Dette tokenet opprettes automatisk første gangen du går inn på et område i Moodle som genererer en RSS-strøm. Dersom du tror at noen har fått rede på din RSS-token kan du resette den her. Merk at dine tidligere lagrede RSS-strømmer fra Moodle da blir ugyldige og må legges inn på nytt.';
$string['rsstype'] = 'RSS-utsending for denne aktiviteten';
$string['saveandnext'] = 'Lagre og vis neste';
$string['savechanges'] = 'Lagre endringer';
$string['savechangesanddisplay'] = 'Lagre og vis';
$string['savechangesandreturntocourse'] = 'Lagre og gå tilbake til kurset';
$string['savecomment'] = 'Lagre kommentar';
$string['savedat'] = 'Lagret:';
$string['savepreferences'] = 'Lagre preferanser';
$string['saveto'] = 'Lagre til';
$string['scale'] = 'Skala';
$string['scale_help'] = '<p>
Lærere kan lage nye standardskalaer som de kan bruke i et kurs for alle typer
vurdering.&nbsp;
</p>

<p>
Navnet på skalaen børe være en gjenkjennelig frase. Den vises i listen over
skalaer man kan velge mellom og på hjelpeknapper som dukker opp i riktig
sammenheng.
</p>

<p>
Selve skalaen består av en kommaseparert liste i en viss rekkefølge som går fra
det negative til det positive. Eksempel:&nbsp;
</p>

<blockquote><i>Ikke godkjent, Dårlig, Midt på tre, Bra, Veldig bra, Utmerket </i></blockquote>

<p>
Skalaen bør også inneholde en bra beskrivelse av hva den betyr og hvordan man
forventer at den brukes. Denne beskrivelsen vises på hjelpesider som både
studenter og lærere kan se.
</p>

<p>
I tillegg kan det være en eller flere standardskalaer på nettstedet som
administrator har definert. Disse blir tilgjengelig for alle klasser.
</p>';
$string['scales'] = 'Skalaer';
$string['scalescustom'] = 'Egendefinerte skalaer';
$string['scalescustomcreate'] = 'Legg til ny skala';
$string['scalescustomno'] = 'Ingen egendefinerte skalaer er laget enda';
$string['scalesstandard'] = 'Standardskalaer';
$string['scalestandard'] = 'Standard skala';
$string['scalestandard_help'] = '<p>En standard skala er en som er tilgjengelig for alle kurs på portalen.</p>';
$string['scalestip'] = 'Bruk Skala-lenken i kursets administrasjonsmeny for å lage egne karakterskalaer.';
$string['scalestip2'] = 'Du oppretter egne karakterskaler slik: Administrasjon > Karakterer og velg Endre skalaer.';
$string['schedule'] = 'Planlegg';
$string['screenshot'] = 'Skjermbilde';
$string['search'] = 'Søk';
$string['searchagain'] = 'Søk på nytt';
$string['searchbyemail'] = 'Søk via e-postadressen';
$string['searchbyusername'] = 'Søk via brukernavn';
$string['searchcourses'] = 'Søk etter studiesider';
$string['searchhelp'] = '<p>Du kan søke etter flere ord samtidig.</p><ul><li>ord : finn alle treff på dette ordet i teksten.</li>
<li>+ord : bare nøyaktige treff vil vises-</li><li>-ord : ikke inkluder sider som inneholder dette ordet.</li></ul>';
$string['search_help'] = 'For standard søk med ett eller flere ord hvor som helst i teksten - bare skriv dem inn med mellomrom. Alle ord med mer enn to bokstaver kan brukes.';
$string['searchoptions'] = 'Søkevalg';
$string['searchresults'] = 'Søkeresultater';
$string['sec'] = 'sek';
$string['seconds'] = 'sekunder';
$string['secondstotime172800'] = '2 dager';
$string['secondstotime259200'] = '3 dager';
$string['secondstotime345600'] = '4 dager';
$string['secondstotime432000'] = '5 dager';
$string['secondstotime518400'] = '6 dager';
$string['secondstotime604800'] = '1 uke';
$string['secondstotime86400'] = '1 dag';
$string['secretalreadyused'] = 'Lenken for godkjenning av passordendring er allerede benyttet, passordet ble ikke endret.<p>Denne feilmeldingen kommer som regel fordi du har prøvd å klikke enda en gang på lenken i tilsendt e-post for passordskifte - en prosess du har fullført allerede. Slike lenker er bare for engangs bruk. Prøv heller å logge inn på vanlig måte.</p>';
$string['secs'] = 'sek';
$string['section'] = 'Kategori';
$string['sectionname'] = 'Seksjonsnavn';
$string['sections'] = 'Kategorier';
$string['sectionusedefaultname'] = 'Bruk standard seksjonsnavn';
$string['seealsostats'] = 'Se også: statistikk';
$string['selctauser'] = 'Velg en bruker';
$string['select'] = 'Velg';
$string['selectacategory'] = 'Vennligst velg en kategori';
$string['selectacountry'] = 'Velg et land';
$string['selectacourse'] = 'Velg et kurs';
$string['selectacoursesite'] = 'Velg et kurs eller nettsted';
$string['selectagroup'] = 'Velg en gruppe';
$string['selectall'] = 'Velg alle';
$string['selectamodule'] = 'Vennligst velg en aktivitetsmodul';
$string['selectanaction'] = 'Velg en handling';
$string['selectanoptions'] = 'Velgl et alternativ';
$string['selectaregion'] = 'Velg en region';
$string['selectcategorysort'] = 'Hvilke kategorier du ønsker å sortere?';
$string['selectcategorysortby'] = 'Velg hvordan du ønsker å sortere kategorier';
$string['selectcoursesortby'] = 'Velg hvordan du ønsker å sortere kurs';
$string['selectdefault'] = 'Velg standard';
$string['selectedcategories'] = 'Valgte kategorier';
$string['selectedfile'] = 'Valgt fil';
$string['selectednowmove'] = '{$a} filer er valgt for flytting. Gå dit du vil ha dem og klikk "Flytt filer hit"';
$string['selectfiles'] = 'Valgte filer';
$string['selectmoduletoviewhelp'] = 'Velg en modul for å se hjelpen som er tilknyttet.

Dobbelklikk p en aktivitet eller ressurs for å legge det til raskt.';
$string['selectnos'] = 'Velg alle \'nei\'';
$string['selectperiod'] = 'Velg periode';
$string['senddetails'] = 'Send mine detaljer via e-post';
$string['separate'] = 'Adskilt';
$string['separateandconnected'] = 'Individuell (rasjonell) og sosial (empatisk) måte å lære på';
$string['separateandconnectedinfo'] = 'Skalaen er basert på teorien om separat eller koblet kunnskap. Denne teorien beskriver to forskjellige måter å lære på om det vi ser og hører.<ul><li><Strong>Separat kunnskap</strong> fremstår som mest mulig objektiv uten følelser og emosjoner. I en diskusjon med andre vil personer med separat kunnskap ha en tendens til å forsvare egne idéer og bruke logikk for å finne hull i andres oppfatninger.</li><li><strong>Personer med koblet kunnskap</strong> er mer sensitive overfor andre mennesker. De har gode empatiske ferdigheter og har en tendens til å lytte og stille spørsmål helt til de har etablert en felles forståelse og kan se det fra sitt ståsted. De lærer ved å dele erfaringene som leder til kunnskap de finner hos andre. </li></ul>';
$string['servererror'] = 'Det oppstod en feil i kommunikasjonen med serveren.';
$string['serverlocaltime'] = 'Tjenerens lokale tid';
$string['setcategorytheme'] = 'Angi eget design for kategorien';
$string['setpassword'] = 'Sett passord';
$string['setpasswordinstructions'] = 'Vennligst legg inn og gjenta ditt nye passord før du klikker på "Sett passord". <br/> Ditt nye passord vil bli lagret, og du vil være innlogget.';
$string['settings'] = 'Innstillinger';
$string['shortname'] = 'Kort navn';
$string['shortnamecollisionwarning'] = '[*]= Kortnavnet er allerede brukt av et annet kurs og må endres når/hvis kurset godkjennes';
$string['shortnamecourse'] = 'Kursets kortnavn';
$string['shortnamecourse_help'] = '<P>Fagets kortnavn er den blå linken brukerne klikker i navigeringslinjen i
systemet for å finne tilbake til fagets hovedside. Denne brukes også andre
steder, f.eks. i emnet på e-poster. Eksempler på kortnavn: Eng GK, Matte VK1, No
3&quot; osv. Dersom faget har et forholdsvis kort navn er det ikke noe i veien for å
skrive hele navnet her, mens fag med lange navn absolutt bør forkortes her.</P>

<P>Det vil bli brukt flere steder der det lange navnet ikke passer (som f.eks i
emnet på e-poster).</P>';
$string['shortnametaken'] = 'Kortnavnet er allerede brukt av et annet kurs ({$a})';
$string['shortnameuser'] = 'Brukerens kortnavn';
$string['shortsitename'] = 'Kort navn på kurset (ett enkelt ord)';
$string['show'] = 'Vis';
$string['showactions'] = 'Vis handlinger';
$string['showadvancedsettings'] = 'Vis avanserte innstillinger';
$string['showall'] = 'Vis alle {$a}';
$string['showallcourses'] = 'Vis alle kurs';
$string['showallusers'] = 'Vis alle brukere';
$string['showblockcourse'] = 'Vis kurs med blokker';
$string['showcategory'] = 'Vis {$a}';
$string['showcomments'] = 'Vis/skjul kommentarer';
$string['showcommentsnonjs'] = 'Vis kommentarer';
$string['showdescription'] = 'Vis beskrivelsen på kurssiden';
$string['showdescription_help'] = 'Hvis aktivert, vil beskrivelsen over vises på kurssiden rett under lenken til aktiviteten eller ressursen.';
$string['showgrades'] = 'Vis karakterbok til studentene';
$string['showgrades_help'] = '<p>
Mange av aktivitetene tillater vurdering/karakterer.</p>

<p>
Standardvalget er at en oversikt over alle karakterer/vurderinger vises i menyen
&quot;Karakterer...&quot; på hver klasseside.&nbsp;
</p>

<p>
Dersom læreren ikke vil bruke vurderinger/karakterer på en klasse eller bare vil
skjule denne informasjonen for studentene kan læren velge dette i menyen
&quot;Innstillinger...&quot; på klassesiden. Dette hindrer ikke at man kan sette
karakterer på individuelle aktiviteter. Det innebærer bare at studentene ikke
får se denne informasjonen. (Studentene får i alle tilfeller bare se informasjon
om sine egne karakterer.)</p>';
$string['showingacourses'] = 'Viser alle {$a} kursene';
$string['showingxofycourses'] = 'Viser kurs {$a->start} til {$a->end} av {$a->total} kurs';
$string['showlistofcourses'] = 'Vis liste over kurs';
$string['showmodulecourse'] = 'Vis kurs med aktivitet';
$string['showonly'] = 'Vis bare';
$string['showperpage'] = 'Vis {$a} pr side';
$string['showrecent'] = 'Vis siste aktivitet';
$string['showreports'] = 'Vis aktivitetsrapport';
$string['showreports_help'] = '<p>
Hver aktive deltaker får se rapporter over egne aktiviteter i hver klasse de
deltar i. Det fins både lister over innleverte bidrag til siden og detaljerte
logger over når deltakeren har logget seg inn.&nbsp;
</p>

<p>
Lærerne har alltid tilgang til disse loggene med knappen &quot;Aktivitetsrapport&quot; på
hver deltakers profilside.
</p>

<p>
Studentenes tilgang til sine egne logger kontrolleres av læreren via en
innstilling på siden. I noen klasser kan dette være et nyttig verktøy for å få
studentene til å reflektere over sin innsats og hvordan de framstår i denne
klassen. Det er likevel kanskje ikke alltid nødvendig.&nbsp;
</p>

<p>
En annen grunn til å deaktivere dette er at loggene kan komme til å belaste
serveren unødvendig. For klasser med mange deltakere eller klasser som varer
lenge kan det være mer effektivt å slå av denne funksjonen.
<p>';
$string['showsettings'] = 'Vis innstillinger';
$string['showtheselogs'] = 'Vis disse loggene';
$string['showthishelpinlanguage'] = 'Vis hjelp i språket: {$a}';
$string['since'] = 'Siden';
$string['sincelast'] = 'siden siste innlogging';
$string['site'] = 'Nettsted';
$string['sitedefault'] = 'Portalstandard';
$string['siteerrors'] = 'Nettstedfeil';
$string['sitefiles'] = 'Nettstedfiler';
$string['sitefilesused'] = 'Nettstedsfiler brukt i dette kurset';
$string['sitehome'] = 'Portalens startside';
$string['sitelegacyfiles'] = 'Arvede portalfiler';
$string['sitelogs'] = 'Logger for nettstedet';
$string['sitemessage'] = 'Send melding til brukere';
$string['sitenews'] = 'Oppslagstavle';
$string['sitepages'] = 'Portalsider';
$string['sitepartlist'] = 'Du har ikke nødvendig tillatelse til å se deltakerlista.';
$string['sitepartlist0'] = 'Du må være lærer på nettstedet for å få se deltakerlisten';
$string['sitepartlist1'] = 'Du må være lærer for å få se deltakerlista';
$string['sites'] = 'Nettsteder';
$string['sitesection'] = 'Legg til temaseksjon';
$string['sitesettings'] = 'Innstillinger for nettstedet';
$string['siteteachers'] = 'Lærere på nettstedet';
$string['size'] = 'Størrelse';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'Gb';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'Mb';
$string['skipped'] = 'Hoppet over';
$string['skiptocategorylisting'] = 'Hopp over kategorivisninger';
$string['skiptocoursedetails'] = 'Hopp over detaljert kursinformasjon';
$string['skiptocourselisting'] = 'Hopp over kursvisninger';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Sosialt forum - nyeste emner';
$string['someallowguest'] = 'Noen kurs kan tillate gjestebesøk';
$string['someerrorswerefound'] = 'Noe informasjon manglet eller var feil. Se nedenfor for detaljer.';
$string['sort'] = 'Sorter';
$string['sortby'] = 'Sorter etter';
$string['sortbyx'] = 'Sorter stigende etter {$a}';
$string['sortbyxreverse'] = 'Sorter synkende etter {$a}';
$string['sortcategoriesbyidnumber'] = 'Sorter kategorier etter ID-nummer';
$string['sortcategoriesbyname'] = 'Sorter kategorier etter navn';
$string['sortcoursesbyfullname'] = 'Sorter kurs etter fullt navn';
$string['sortcoursesbyidnumber'] = 'Sorter kurs etter ID-nummer';
$string['sortcoursesbyshortname'] = 'Sorter kurs etter kortnavn';
$string['sorting'] = 'Sorterer';
$string['sourcerole'] = 'Opprinnelig rolle';
$string['specifyname'] = 'Du må oppgi et navn';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] =kurs som venter på godkjenning)';
$string['startdate'] = 'Dato for studiestart';
$string['startdate_help'] = 'Her setter du startdatoen for første uke i et kurs med ukeformat. Datoen bestemmer også tidligste dato det vises logger fra kursaktiviteter.
';
$string['startingfrom'] = 'Starter fra';
$string['startsignup'] = 'Registrer deg';
$string['state'] = 'Fylke';
$string['statistics'] = 'Statistikk';
$string['statisticsgraph'] = 'Statistikk graf';
$string['stats'] = 'Statistikk';
$string['statslogins'] = 'Innlogginger';
$string['statsmodedetailed'] = 'Detaljert visning (bruker)';
$string['statsmodegeneral'] = 'Generell visning';
$string['statsnodata'] = 'Det er ingen tilgjengelige data for den kombinasjon av kurs- og tidsperiode.';
$string['statsnodatauser'] = 'Det er ingen tilgjengelige data for den kombinasjon av kurs, bruker og tidsperiode.';
$string['statsoff'] = 'Statistikk er ikke slått på nå';
$string['statsreads'] = 'Visninger';
$string['statsreport1'] = 'Innlogginger';
$string['statsreport10'] = 'Brukeraktivitet';
$string['statsreport11'] = 'Mest aktive kurs';
$string['statsreport12'] = 'Mest aktive kurs (vektet)';
$string['statsreport13'] = 'Kurs med flest deltakere';
$string['statsreport14'] = 'Kurs med flest visninger og innlegg';
$string['statsreport2'] = 'Visninger (alle roller)';
$string['statsreport3'] = 'Innlegg (alle roller)';
$string['statsreport4'] = 'All aktivitet (alle roller)';
$string['statsreport5'] = 'All aktivitet (visninger og innlegg)';
$string['statsreport7'] = 'Brukeraktivitet (visninger og innlegg)';
$string['statsreport8'] = 'All brukeraktivitet';
$string['statsreport9'] = 'Innlogginger (nettstedet)';
$string['statsreportactivity'] = 'All aktivitet (alle roller)';
$string['statsreportactivitybyrole'] = 'All aktivitet (visninger og innlegg)';
$string['statsreportforuser'] = 'for';
$string['statsreportlogins'] = 'Innlogginger';
$string['statsreportreads'] = 'Oversikt (lærer og student)';
$string['statsreporttype'] = 'Rapporttype';
$string['statsreportwrites'] = 'Bidrag (lærer og student)';
$string['statsstudentactivity'] = 'Studentaktivitet';
$string['statsstudentreads'] = 'Studentsidevisninger';
$string['statsstudentwrites'] = 'Studentbidrag';
$string['statsteacheractivity'] = 'Læreraktivitet';
$string['statsteacherreads'] = 'Læreroversikt';
$string['statsteacherwrites'] = 'Lærerbidrag';
$string['statstimeperiod'] = 'Tidsperiode - siste:';
$string['statsuniquelogins'] = 'Unike innlogginger';
$string['statsuseractivity'] = 'All aktivitet';
$string['statsuserlogins'] = 'Innlogginger';
$string['statsuserreads'] = 'Sidevisninger';
$string['statsuserwrites'] = 'Bidrag';
$string['statswrites'] = 'Innlegg';
$string['status'] = 'Status';
$string['stringsnotset'] = 'Følgende er ikke definert i {$a}';
$string['studentnotallowed'] = 'Beklager, men du har ikke tilgang til dette kurset som \'{$a}\'';
$string['students'] = 'Studenter';
$string['studentsandteachers'] = 'Studenter og lærere';
$string['subcategories'] = 'Underkategorier';
$string['subcategory'] = 'Underkategori';
$string['subcategoryof'] = 'Underkategori til {$a}';
$string['submit'] = 'Send';
$string['success'] = 'Vellykket';
$string['summary'] = 'Sammendrag';
$string['summary_help'] = '<p>Tanken med sammendrag til hvert emne på siden er en svært kort tekst som
forteller studenten hva som er innholdet i uke- eller emneboksen under. Den kan
godt fungere som en overskrift. </p>

<p>Hver overskrift bør være kort, ellers blir studiesiden lang. Det er i tillegg
unødvendig at studentene får lange tekster opp på skjermen hver gang. Har du
bruk for å gi studentene et større sammendrag bør du heller legge dette som en
tekstressurs øverst i emneboksen. Eksempel: Den øverste ressursen kan f.eks.
hete &quot;<b>Om dette emnet</b>&quot; og inneholde mer utfyllende informasjon.</p>';
$string['summaryof'] = 'Sammendrag av {$a}';
$string['supplyinfo'] = 'Fortell litt om deg selv';
$string['suspended'] = 'Utestengt';
$string['suspendedusers'] = 'Utestengte brukere';
$string['switchdevicedefault'] = 'Bytt til standard design';
$string['switchdevicerecommended'] = 'Bytt til anbefalt design for din enhet';
$string['switchrolereturn'] = 'Returner til min vanlige rolle';
$string['switchroleto'] = 'Bytt rolle til ...';
$string['tag'] = 'Tagg';
$string['tagalready'] = 'Denne taggen eksisterer fra før';
$string['tagmanagement'] = 'Legg til/slett tagger';
$string['tags'] = 'Tagger';
$string['targetrole'] = 'Målrolle';
$string['teacheronly'] = 'kun synlig for {$a}';
$string['teacherroles'] = '{$a} roller';
$string['teachers'] = 'Lærere';
$string['textediting'] = 'Teksteditor';
$string['texteditor'] = 'Bruk standard nettskjema';
$string['textformat'] = 'Rent tekstformat';
$string['thanks'] = 'Takk';
$string['theme'] = 'Tema';
$string['themes'] = 'Tema';
$string['themesaved'] = 'Nytt tema lagret';
$string['therearecourses'] = 'Det er {$a} kurs';
$string['thereareno'] = 'Det er ingen {$a} i dette kurset.';
$string['thiscategory'] = 'Denne kategorien';
$string['thiscategorycontains'] = 'Denne kategorien inneholder';
$string['time'] = 'Tid';
$string['timezone'] = 'Tidssone';
$string['to'] = 'Til';
$string['tocontent'] = 'Til element "{$a}"';
$string['tocreatenewaccount'] = 'Hopp over å lage ny brukerkonto';
$string['today'] = 'I dag';
$string['todaylogs'] = 'Dagens logger';
$string['toeveryone'] = 'til alle';
$string['toomanybounces'] = 'Post til den e-postadressen har kommet i retur så mange ganger at du <b>må</> skifte til en annen for å få fortsette.';
$string['toomanytoshow'] = 'Det er for mange brukere til at alle kan vises';
$string['toomanyusersmatchsearch'] = 'For mange brukere ({$a->count}) samsvarte med  \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'For mange brukere ({$a}) som kan vises';
$string['toonly'] = 'bare til {$a}';
$string['top'] = 'Topp';
$string['topic'] = 'Emne';
$string['topichide'] = 'Gjem dette emnet for {$a}';
$string['topicoutline'] = 'Emnevisning';
$string['topicshow'] = 'Vis dette emnet til {$a}';
$string['toplevelcategory'] = 'Kategori på toppnivå';
$string['total'] = 'Totalt';
$string['totopofsection'] = 'Til toppen av emnet "{$a}"';
$string['trackforums'] = 'Hold orden på foruminnlegg';
$string['trackforumsno'] = 'Nei: Ikke hold styring på innleggene jeg har sett';
$string['trackforumsyes'] = 'Ja: Marker nye innlegg for meg';
$string['trysearching'] = 'Prøv å søke isteden';
$string['turneditingoff'] = 'Slå redigering av';
$string['turneditingon'] = 'Slå redigering på';
$string['undecided'] = 'Ubestemt';
$string['unfinished'] = 'Uavsluttet';
$string['unknowncategory'] = 'Ukjent kategori';
$string['unknownerror'] = 'Ukjent feil';
$string['unlimited'] = 'Ubegrenset';
$string['unpacking'] = 'Pakker ut {$a}';
$string['unsafepassword'] = 'Usikkert passord - prøv et annet';
$string['untilcomplete'] = 'Til den er ferdig';
$string['unusedaccounts'] = 'Kontoer som ikke er tatt i bruk innen {$a} dager blir automatisk slettet';
$string['unzip'] = 'Pakk opp zip-fil';
$string['unzippingbackup'] = 'Pakker opp sikkerhetskopi';
$string['up'] = 'Opp';
$string['update'] = 'Oppdater';
$string['updated'] = 'Oppdatert {$a}';
$string['updatemymoodleoff'] = 'Avslutt redigering av denne siden';
$string['updatemymoodleon'] = 'Rediger denne siden';
$string['updatemyprofile'] = 'Oppdater profilen';
$string['updatesevery'] = 'Oppdaterer hvert {$a} sekund';
$string['updatethis'] = 'Oppdater {$a}';
$string['updatethiscourse'] = 'Oppdater dette kurset';
$string['updatinga'] = 'Oppdaterer {$a}';
$string['updatingain'] = 'Oppdaterer {$a->what} i {$a->in}';
$string['upload'] = 'Laste opp';
$string['uploadafile'] = 'Laste opp ei fil';
$string['uploadcantwrite'] = 'Fillagringen mislykkes';
$string['uploadedfile'] = 'Fila ble lastet opp uten feil';
$string['uploadedfileto'] = 'Lastet opp {$a->file} til {$a->directory}';
$string['uploadedfiletoobig'] = 'Beklager, men den fila er for stor(grensen er på {$a} bytes)';
$string['uploadextension'] = 'Filopplastingen ble stoppet på grunn av PHP-filtypen.';
$string['uploadfailednotrecovering'] = 'Filopplastingen var mislykka fordi det var et problem med en av filene, {$a->name}.<br />Her finner du en logg over problemene: <br />{$a->problem}</br>';
$string['uploadfilelog'] = 'Last opp logg for fila {$a}';
$string['uploadformlimit'] = 'Den opplastede fila {$a} var større enn maksimumsgrensen som ble satt i skjemaet.';
$string['uploadlabel'] = 'Tittel:';
$string['uploadlimitwithsize'] = '{$a->contextname} opplastingsgrense ({$a->displaysize})';
$string['uploadnewfile'] = 'Last opp ny fil';
$string['uploadnofilefound'] = 'Fant ingen filer. Er du sikker på at du valgte ei?';
$string['uploadnotallowed'] = 'Det er ikke lov å laste opp';
$string['uploadnotempdir'] = 'Mangler tilgang til midlertidig mappe.';
$string['uploadoldfilesdeleted'] = 'Den gamle filen i opplastingsområdet ditt ble slettet/De gamle filene i opplastingsområdet ditt ble slettet.';
$string['uploadpartialfile'] = 'Filen ble bare delvis lastet opp.';
$string['uploadproblem'] = 'Det oppstod et problem under opplasting av filen \'{$a}\'  (kanskje den var for stor?)';
$string['uploadrenamedchars'] = 'Filen ble døpt om fra {$a->oldname} til {$a->newname} på grunn av ugyldige tegn.';
$string['uploadrenamedcollision'] = 'Filen ble døpt om fra {$a->oldname} til {$a->newname} fordi det allerede fantes en fil med det navnet.';
$string['uploadserverlimit'] = 'Den opplastede filen var større enn maksimal  størrelse for opplasting på denne tjenermaskina.';
$string['uploadthisfile'] = 'Last opp denne filen';
$string['url'] = 'URL';
$string['used'] = 'Brukt';
$string['usedinnplaces'] = 'Brukt {$a} steder';
$string['usemessageform'] = 'eller bruk skjemaet under for å sende ei melding til de valgte studentene';
$string['user'] = 'Bruker';
$string['userconfirmed'] = 'Bekreftet {$a}';
$string['usercurrentsettings'] = 'Mine profilinnstillinger';
$string['userdata'] = 'Brukerdata';
$string['userdeleted'] = 'Denne brukeren er slettet';
$string['userdescription'] = 'Skriv litt om deg selv';
$string['userdescription_help'] = 'Denne boksen lar deg skrive inn noe tekst om deg selv. Andre kan se hva du skriver inn her.';
$string['userdetails'] = 'Brukerdetaljer';
$string['userfiles'] = 'Brukerfiler';
$string['userlist'] = 'Brukerliste';
$string['username'] = 'Brukernavn';
$string['usernameemailmatch'] = 'Brukernavnet og pasordet tilhører ikke samme bruker';
$string['usernameexists'] = 'Dette brukernavnet finnes allerede, vennligst velg et annet';
$string['usernamelowercase'] = 'Kun små bokstaver tillatt';
$string['usernamenotfound'] = 'Fant ikke brukernavnet i databasen';
$string['usernameoremail'] = 'Enten brukernavn eller e-postadresse';
$string['usernotconfirmed'] = 'Kunne ikke bekrefte {$a}';
$string['userpic'] = 'Brukerbilde';
$string['users'] = 'Brukere';
$string['userselectorautoselectunique'] = 'Dersom bare ett treff, velg treffet automatisk';
$string['userselectorpreserveselected'] = 'Behold valgte brukere, selv om de ikke lenger samsvarer med søket';
$string['userselectorsearchanywhere'] = 'Let etter søketeksten hvor som helst i de viste feltene';
$string['usersnew'] = 'Nye brukere';
$string['usersnoaccesssince'] = 'Inaktive i mer enn';
$string['userswithfiles'] = 'Brukerfiler';
$string['useruploadtype'] = 'Opplastingstype for brukere: {$a}';
$string['userviewingsettings'] = 'Profilinnstillinger for {$a}';
$string['userzones'] = 'Brukersoner';
$string['usetheme'] = 'Bruk design';
$string['usingexistingcourse'] = 'Bruker eksisterende kurs';
$string['valuealreadyused'] = 'Denne verdien er allerede i bruk';
$string['version'] = 'Versjon';
$string['view'] = 'Visning';
$string['viewallcourses'] = 'Vis alle kurs';
$string['viewallcoursescategories'] = 'Vis alle kurs og kategorier';
$string['viewallsubcategories'] = 'Vis alle underkategorier';
$string['viewfileinpopup'] = 'Vis filen i et popup-vindu';
$string['viewing'] = 'Visning';
$string['viewmore'] = 'Vis flere';
$string['viewprofile'] = 'Vis profilen';
$string['views'] = 'Visninger';
$string['viewsolution'] = 'vis løsning';
$string['virusfound'] = 'Alarm! Clam Antivirus har funnet et virus i en fil lastet opp av {$a->user} på kurset {$a->course}. Clamscan sier:';
$string['virusfoundlater'] = 'En fil du lastet opp den {$a->date} med filnavnet {$a->filename} i kurset {$a->course} viste seg å inneholde et virus. Her er en oppsummering av hva som skjedde med filen din:
{$a->action}
Hvis dette var en innlevering, vil du kanskje levere den på nytt, slik at læreren din får se den.';
$string['virusfoundlateradmin'] = 'Administrator, vær oppmerksom! En fil som ble lastet opp den {$a->date} med filnavnet {$a->filename} på kurset {$a->course} av brukeren {$a->user}, viste seg å inneholde et virus.Her er en oppsummering av hva som skjedde med filen:
{$a->action}
Brukeren har også fått beskjed.';
$string['virusfoundlateradminnolog'] = 'Alarm!Ei fil som ble lastet opp med filnavnet {$a->filename} viste seg å inneholde et virus. Moodle var ikke i stand til spore den til en bruker.
Her er en oppsummering av hva som skjedde med fila:
{$a->action}';
$string['virusfoundsubject'] = '{$a}: Et virus er oppdaget!';
$string['virusfounduser'] = 'Fila du lastet opp, {$a->filename} , ble sjekket av et virusprogram, og det viste seg at den var infisert! Opplastinga di ble ikke fullført.';
$string['virusplaceholder'] = 'Denne fila, som har blitt lastet opp, viste seg å inneholde et virus og har blitt flyttet eller slettet. Brukeren har fått beskjed.';
$string['visible'] = 'Synlig';
$string['visible_help'] = 'Dette alternativet lar deg skjule studiesidene dine fullstendig.

Siden blir ikke vist i kursoversikten (bortsett fra for lærere og
administratorer på portalen).

Selv om studenter eller andre prøver å finne siden direkte via dens nettadresse (URL) får de likevel ikke tilgang.';
$string['visibletostudents'] = 'Synlig for {$a}';
$string['warning'] = 'Advarsel';
$string['warningdeleteresource'] = 'Advarsel: {$a} blir referert til i en ressurs. Vil du oppdatere ressursen?';
$string['webpage'] = 'Nettside';
$string['week'] = 'Uke';
$string['weekhide'] = 'Gjem denne uken for {$a}';
$string['weeklyoutline'] = 'Ukeformat';
$string['weeks'] = 'uker';
$string['weekshow'] = 'Vis denne uken til {$a}';
$string['welcometocourse'] = 'Velkommen til {$a}';
$string['welcometocoursetext'] = 'Velkommen til {$a->coursename}!

Hvis du ikke har gjort det enda bør du redigere profilen din (informasjon om deg selv) slik at vi kan bli bedre kjent med deg:

  {$a->profileurl}';
$string['whatforlink'] = 'Hva vil du gjøre med lenken?';
$string['whatforpage'] = 'Hva vil du gjøre med teksten?';
$string['whattocallzip'] = 'Hva vil du kalle zip-fila?';
$string['whattodo'] = 'Hva skal du gjøre';
$string['windowclosing'] = 'Dette vinduet skulle stenges automatisk. Dersom ikke, steng det nå.';
$string['withchosenfiles'] = 'Med valgte filer';
$string['withdisablednote'] = '{$a} (deaktivert)';
$string['withoutuserdata'] = 'uten brukerdata';
$string['withselectedusers'] = 'Med valgte brukere';
$string['withselectedusers_help'] = '* Send melding - For å sende meldinger til en eller flere deltakere
* Legg til nytt notat - For å legge til et notat på valgte deltaker
* Legg til et felles notat - For å legge til samme notat på mer enn en deltaker';
$string['withuserdata'] = 'med brukerdata';
$string['wordforstudent'] = 'Ditt ord for student';
$string['wordforstudenteg'] = 'eks. student, elev osv.';
$string['wordforstudents'] = 'Ditt ord for studenter';
$string['wordforstudentseg'] = 'eks. studenter, elever osv.';
$string['wordforteacher'] = 'Ditt ord for lærer';
$string['wordforteachereg'] = 'eks. lærer, veileder, professor osv.';
$string['wordforteachers'] = 'Ditt ord for lærere';
$string['wordforteacherseg'] = 'eks. lærere, veileder, professorer osv.';
$string['writingblogsinfo'] = 'Skriver blogginfo';
$string['writingcategoriesandquestions'] = 'Skriver kategorier og spørsmål';
$string['writingcoursedata'] = 'Skriver kursdata';
$string['writingeventsinfo'] = 'Skriver info om hendelser';
$string['writinggeneralinfo'] = 'Skriver generell info';
$string['writinggradebookinfo'] = 'Skriver karakterbokinfo';
$string['writinggroupingsgroupsinfo'] = 'Skriver info om tilgangsgrupper - grupper';
$string['writinggroupingsinfo'] = 'Skriver info om tilgangsgrupper';
$string['writinggroupsinfo'] = 'Skriver gruppeinfo';
$string['writingheader'] = 'Skriver overskrift';
$string['writingloginfo'] = 'Skriver logginfo';
$string['writingmessagesinfo'] = 'Skriver meldingsinfo';
$string['writingmoduleinfo'] = 'Skriver modulinfo';
$string['writingscalesinfo'] = 'Skriver info om skalaer';
$string['writinguserinfo'] = 'Skriver brukerinfo';
$string['wrongpassword'] = 'Feil passord til dette brukernavnet';
$string['yahooid'] = 'Yahoo-ID';
$string['year'] = 'år';
$string['years'] = 'år';
$string['yes'] = 'Ja';
$string['youareabouttocreatezip'] = 'Du holder på å lage ei zip-fil som inneholder';
$string['youaregoingtorestorefrom'] = 'Du tilbakefører fra';
$string['youneedtoenrol'] = 'For å utføre denne handlingen må du være påmeldt i dette kurset.';
$string['yourlastlogin'] = 'Du var sist innlogget';
$string['yourself'] = 'deg selv';
$string['yourteacher'] = 'din {$a}';
$string['yourwordforx'] = 'Ditt ord for \'{$a}\'';
$string['zippingbackup'] = 'Pakker sikkerhetskopi';
