<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'mnet', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   mnet
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutyourhost'] = 'Om din server';
$string['accesslevel'] = 'Tilgangsnivå';
$string['addhost'] = 'Legg til vert';
$string['addnewhost'] = 'Legg til ny vert';
$string['addtoacl'] = 'Legg til i tilgangskontroll';
$string['allhosts'] = 'Alle verter';
$string['allhosts_no_options'] = 'Ingen valg er tilgjengelige når de ser mer enn en vert.';
$string['allow'] = 'Tillat';
$string['applicationtype'] = 'Applikasjonstype';
$string['authfail_nosessionexists'] = 'Autorisasjonen mislykkes: mnet-sesjonen eksisterer ikke.';
$string['authfail_sessiontimedout'] = 'Autorisasjonen mislykkes: mnet-sesjonen måtte vente for lenge.';
$string['authfail_usermismatch'] = 'Autorisasjonen mislykkes: Brukeren er ukjent.';
$string['authmnetdisabled'] = 'Moodle Nettverk <em>autentiseringsmodul</em> er <strong>slått av</strong>.';
$string['badcert'] = 'Sertifikatet er ugyldig';
$string['certdetails'] = 'CERT detaljer';
$string['configmnet'] = 'MNET tillater at denne serveren kobler seg opp mot andre servere eller tjenester.';
$string['couldnotgetcert'] = 'Fant ikke sertifikatet på <br />{$a}. <br />Verten kan være nede eller feil konfigurert.';
$string['couldnotmatchcert'] = 'Dette samsvarer ikke med sertifikatet som ble publisert av webserveren.';
$string['courses'] = 'kurs';
$string['courseson'] = 'kurs på';
$string['currentkey'] = 'Gjeldende offentlig nøkkel';
$string['current_transport'] = 'Gjeldende transport';
$string['databaseerror'] = 'Lagringen i databasen mislykkes';
$string['deleteaserver'] = 'Sletter en server';
$string['deletedhostinfo'] = 'Denne verten er blitt slettet. Bytt slettetstatusen tilbake til \'Nei\' hvis du vil angre slettingen.';
$string['deletedhosts'] = 'Slettede verter: {$a}';
$string['deletehost'] = 'Slett tjener';
$string['deletekeycheck'] = 'Er du absolutt sikker på at du vil slette denne nøkkelen?';
$string['deleteoutoftime'] = 'Du hadde 60 sekunder på deg til å slette nøkkelen og tiden er utløpt. Vennligst prøv en gang til.';
$string['deleteuserrecord'] = 'SSO ACL: slett rad for brukeren \'{$a->user}\' fra {$a->host}.';
$string['deletewrongkeyvalue'] = 'En feil har oppstått. Hvis du ikke prøvde å slette serverens SSL-nøkkel, er det mulig du er blitt utsatt for et fiendtlig angrep. Handlingen ble derfor stoppet.';
$string['deny'] = 'Nekt';
$string['description'] = 'Beskrivelse';
$string['duplicate_usernames'] = 'Vi mislykkes i å opprette en indeks på kolonnen "mnethostid" og "username" i brukertabellen.<br />Dette kan skje når d har <a href="{$a}" target="_blank">like brukernavn i brukertabellen</a>.<br />Oppgraderingen burde likevel fullføres. Klikk på lenken over, og vi viser deg i eget vindu hvordan du fikser dette problemet. Det er tidsnok å gjøre dette etter oppgraderingen.<br />';
$string['enabled_for_all'] = '(Denne tjenesten er slått på for alle verter.)';
$string['enterausername'] = 'Vennligst skriv inn et brukernavn, eller en liste med brukernavn adskilt av komma.';
$string['error7020'] = 'Denne feilen oppstår normalt hvis den andre portalen har opprettet en oppføring til deg med feil wwwroot, f.eks. glemt \'www\' i adressen. Du bør kontakte administratoren på den andre siten med info om korrekt adresse (den i config.php).';
$string['error7022'] = 'Meldingen du sendte til den andre portalen var kryptert, men ikke signert. Dette er ganske  uvanlig; du bør melde dette som en bug - vennligst ta med så mye informasjon som mulig.';
$string['error7023'] = 'Den andre poprtalen har forsøkt å dekryptere meldingen med nøkkelinformasjonen fra din portal - men mislykkes. Dette kan trolig fikses ved å manuelt endre nøkkel på begge portalene. Dette bør ikke skje så sant dere ikke har  hatt noen kommunikasjon mellom portalene på noen måneder.';
$string['error7024'] = 'Du sendte en ukryptert melding til den andre portalen, men dette ble ikke akseptert. Dette er ganske uvanlig - vennligst rapporter dette som en bug til Moodle.org. Ta med så mye info som mulig.';
$string['error7026'] = 'Nøkkelen du signerte meldingen med er forskjellig fra nøkkelen den andre serveren har fått fra deg tidligere. Vennligst endre nøkkelen manuelt på begge portalene.';
$string['error709'] = 'Den andre portalen mislykkes i å motta en SSL-nøkkel fra deg.';
$string['expired'] = 'Denne nøkkelen utløp';
$string['expires'] = 'Gyldig til';
$string['expireyourkey'] = 'Slett denne nøkkelen';
$string['expireyourkeyexplain'] = 'Moodle roterer automatisk dine nøkler hver 28.dag (standard), men du har muligheten til å <em>manuelt</em> skifte ut nøkkelen når som helst. Dette er først og fremst nyttig når nøkkelen er blitt kjent for uvedkommende. En erstatningsnøkkel blir generert umiddelbart. <br/>Hvis du sletter denne nøkkelen blir det umulig for andre Moodle-verter å kommunisere med deg, inntil du kontakter hver enkelt administrator og gir dem den nye nøkkelen.';
$string['exportfields'] = 'Felter å eksportere';
$string['failedaclwrite'] = 'Oppdatering av MNET tilgangskontroll mislykkes for brukeren \'{$a}\'.';
$string['findlogin'] = 'Finn Login';
$string['forbidden-function'] = 'Denne funksjonen er ikke aktivert for RPC.';
$string['forbidden-transport'] = 'Transportmetoden du prøver å bruke er ikke tillatt.';
$string['forcesavechanges'] = 'Tving lagre endringer';
$string['helpnetworksettings'] = 'Sett opp MNet kommunikasjon';
$string['hidelocal'] = 'Skjul lokale brukere';
$string['hideremote'] = 'Skjul fjernbrukere';
$string['host'] = 'vert';
$string['hostcoursenotfound'] = 'Vert eller kurs ikke funnet';
$string['hostdeleted'] = 'Verten er slettet';
$string['hostexists'] = 'En post finnes allerede for verten med det navnet (den kan slettes). <a href="{$a}">klikk her</a> for å redigere posten.';
$string['hostlist'] = 'Liste over nettverksverter.';
$string['hostname'] = 'Vertsnavn';
$string['hostnamehelp'] = 'Et gyldig domenenavn for fjernverten, eks. www.eksempel.no';
$string['hostnotconfiguredforsso'] = 'Den andre Moodle-verten er ikke konfigurert for fjernpålogging.';
$string['hostsettings'] = 'Vertsinnstillinger';
$string['http_self_signed_help'] = 'Tillat oppkoblinger med egensignert DIY SSL sertifikat fra fjernvert.';
$string['https_self_signed_help'] = 'Tillat oppkoblinger med et egensignert DIY SSL i PHP på fjernverten via http.';
$string['https_verified_help'] = 'Tillat oppkoblinger med et godkjent SSL sertifikat på fjernverten.';
$string['http_verified_help'] = 'Tillat oppkoblinger med et gyldig SSL-sertifikat i PHP på fjernverten, men via http (ikke https).';
$string['id'] = 'ID';
$string['idhelp'] = 'Denne verdien tildeles automatisk og kan ikke endres.';
$string['importfields'] = 'Felter å importere';
$string['inspect'] = 'Inspiser';
$string['installnosuchfunction'] = 'Kodefeil! Noe(n) forsøker å installere en mnet xmlrpc-funksjon
({$a->method}) fra filen ({$a->file}) og den finnes ikke!';
$string['installnosuchmethod'] = 'Kodefeil! Noe(n) forsøker å installere en mnet xmlrpc-metode
({$a->method}) fra filen ({$a->file}) og den finnes ikke!';
$string['installreflectionclasserror'] = 'Kodefeil! MNet introspeksjon mislykkes for metoden \'{$a->method}\' i klassen \'{$a->class}\'. Den originale feilmeldingen, hvis det hjelper, er: \'{$a->error}\'';
$string['installreflectionfunctionerror'] = 'Kodefeil! MNet introspeksjon mislykkes for funksjonen \'{$a->method}\' i filen \'{$a->file}\'. Den originale feilmeldingen, hvis det hjelper, er: \'{$a->error}\'';
$string['invalidaccessparam'] = 'Ulovlig tilgangsparameter';
$string['invalidactionparam'] = 'Ulovlig handlingsparameter';
$string['invalidhost'] = 'Du må skrive inn en gyldig vertsidentifikasjon';
$string['invalidpubkey'] = 'Nøkkelen er ingen gyldig SSL-nøkkel.';
$string['invalidurl'] = 'Ugyldig URL parameter';
$string['ipaddress'] = 'IP-adresse';
$string['is_in_range'] = 'IP-adressen  <code>{$a}</code>  er godkjent som en gyldig vert.';
$string['ispublished'] = '{$a} har aktivisert denne tjenesten for deg.';
$string['issubscribed'] = '{$a} abonnerer på denne tjenesten på din server.';
$string['keydeleted'] = 'Nøkkelen er bekreftet slettet og erstattet med en ny.';
$string['keymismatch'] = 'Nøkkelen du bruker på denne verten er forskjellig fra den offentlige nøkkelen du publiserer i øyeblikket. Gjeldende nøkkel er:';
$string['last_connect_time'] = 'Sist oppkoblet';
$string['last_connect_time_help'] = 'Tidspunktet du sist kontaktet denne verten.';
$string['last_transport_help'] = 'Transporten du benyttet for den siste oppkoblingen til denne verten.';
$string['leavedefault'] = 'Bruk standardinnstillinger istedet';
$string['listservices'] = 'Liste over tjenster';
$string['loginlinkmnetuser'] = '<br/>Dersom du er en Moodle Nettverk fjernbruker og kan <a href="{$a}">bekrefte e-postadressen din her</a>, kan du omdirigeres til din egen innloggingsside<br />';
$string['logs'] = 'logger';
$string['managemnetpeers'] = 'Administrere eksterne servere';
$string['method'] = 'Metode';
$string['methodhelp'] = 'Metodehjelp for {$a}';
$string['methodsavailableonhost'] = 'Metoder som er tilgjengelige på {$a}';
$string['methodsavailableonhostinservice'] = 'Metoder tilgjengelig for {$a->service} på {$a->host}';
$string['methodsignature'] = 'Metodesignatur for {$a}';
$string['mnet'] = 'Moodle Nettverk (MNet)';
$string['mnet_concatenate_strings'] = 'Bearbeid (opptil) 3 strenger og returner resultatet.';
$string['mnetdisabled'] = 'Moodle Nettverk er <strong>slått av</strong>.';
$string['mnetidprovider'] = 'MNET ID-tilbyder';
$string['mnetidproviderdesc'] = 'Du kan bruke denne funksjonen til å motta en lenke som logger deg inn hvis e-postadressen du skriver inn stemmer med tilhørende brukernavn.';
$string['mnetidprovidermsg'] = 'Du bør nå kunne logge inn hos din {$a} tilbyder.';
$string['mnetidprovidernotfound'] = 'Beklager, men vi finner ikke mer informasjon.';
$string['mnetlog'] = 'Logger';
$string['mnetpeers'] = 'Andre verter';
$string['mnetservices'] = 'Tjenester';
$string['mnet_session_prohibited'] = 'Brukere fra din hjemmeserver har ikke adgang til å koble opp mot {$a}.';
$string['mnetsettings'] = 'Moodle Nettverk (MNet) innstillinger';
$string['moodle_home_help'] = 'Stien til Moodles startside på fjernverten, f.eks. www.eksempel.no/moodle';
$string['name'] = 'Navn';
$string['net'] = 'Nettverk';
$string['networksettings'] = 'Nettverksinnstillinger';
$string['never'] = 'Aldri';
$string['noaclentries'] = 'Det er ingen oppføringer i SSO tilgangslista.';
$string['noaddressforhost'] = 'Beklager, men det vertsnavnet ({$a}) kunne ikke nås!';
$string['nocurl'] = 'PHP cURL-biblioteket er ikke installert';
$string['nolocaluser'] = 'Det finnes ingen lokal oppføring for fjernbrukeren og den kunne ikke opprettes siden denne serveren ikke autooppretter fjernbrukere. Vennligst kontakt administrator!';
$string['nomodifyacl'] = 'Du har ikke tillatelse til å redigere MNET tilgangslista.';
$string['nonmatchingcert'] = 'Emnefeltet på sertifikatet: <br /><em>{$a}[0]</em><br />samsvarer ikke med verten det kommer fra:<br /><em>{$a}[1]</em>.';
$string['nopubkey'] = 'Det oppstod et problem under mottakelsen av offentlig nøkkel.<br/> Kan hende verten ikke tillater Moodle Nettverk eller at nøkkelen er ugyldig.';
$string['nosite'] = 'Fant ikke kurset på site-nivå';
$string['nosuchfile'] = 'Filen/funksjonen {$a} eksisterer ikke.';
$string['nosuchfunction'] = 'Finner ikke funksjonen, eller det kan hende funksjonen er stengt for RPC.';
$string['nosuchmodule'] = 'Funksjonen har feil i oppsettet og kunne ikke finnes. Vennligst bruk formatet mod/modulname/lib/functionname.';
$string['nosuchpublickey'] = 'Fikk ingen offentlig nøkkel til å verifisere signaturen.';
$string['nosuchservice'] = 'RPC-tjenesten kjører ikke på denne verten.';
$string['nosuchtransport'] = 'Det finnes ingen transport med denne ID-en.';
$string['notBASE64'] = 'Strengen er ikke i Base64 format. Er derfor ingen gyldig nøkkel.';
$string['notenoughidpinfo'] = 'Identitetstilbyderen din sender oss ikke nok informasjon til at vi kan opprette eller oppdatere brukerkontoen din. Beklager!';
$string['not_in_range'] = 'IP-adressen <code>{$a}</code> representerer ingen gyldig vert.';
$string['notinxmlrpcserver'] = 'Forsøker å nå den eksterne MNET klienten utenom XMLRPC serverprosessen';
$string['notmoodleapplication'] = 'ADVARSEL: Dette er ingen Moodle-applikasjon, så noen av inspeksjonsmetodene vil ikke virke som forventet.';
$string['notPEM'] = 'Nøkkelen er ikke i PEM format. Dette vil ikke fungere...';
$string['notpermittedtojump'] = 'Du har ikke tillatelse til å starte en fjernsesjon fra denne Moodle-serveren.';
$string['notpermittedtojumpas'] = 'Du kan ikke starte en fjernøkt mens du er logget inn som en annen bruker.';
$string['notpermittedtoland'] = 'Du har ikke tillatelse til å starte en fjernsesjon.';
$string['off'] = 'Av';
$string['on'] = 'På';
$string['options'] = 'Valg';
$string['peerprofilefielddesc'] = 'Her kan du overstyre de globale innstillingene';
$string['permittedtransports'] = 'Gyldige transporter';
$string['phperror'] = 'En intern feil stoppet henvendelsen din.';
$string['position'] = 'Posisjon';
$string['postrequired'] = 'Slettefunksjonen krever en POST-forespørsel.';
$string['profileexportfields'] = 'Felter å sende';
$string['profilefielddesc'] = 'Her kan du sette opp en liste over profilfelt som skal sendes og mottas via MNET når en brukerkonto blir opprettet eller oppdatert. Du kan også overstyre dette individuelt for hver MNET server. Merk at følgende obligatoriske felter alltid blir sendt og ikke kan velges bort: {$a}';
$string['profilefields'] = 'Profilfelter';
$string['profileimportfields'] = 'Felter å importere';
$string['promiscuous'] = 'Upålitelig';
$string['publickey'] = 'Offentlig nøkkel';
$string['publickey_help'] = 'Den offentlige nøkkelen fanges automatisk opp av andre servere.';
$string['publickeyrequired'] = 'Du må oppgi en fellesnøkkel.';
$string['publish'] = 'Publiser';
$string['reallydeleteserver'] = 'Er du sikker på at du vil slette serveren';
$string['receivedwarnings'] = 'Følgende advarsler er mottatt';
$string['recordnoexists'] = 'Oppføringen eksisterer ikke.';
$string['reenableserver'] = 'Nei - velg denne for å reetablere denne serveren.';
$string['registerallhosts'] = 'Registrér alle vertene (<em>Node-modus</em>)';
$string['registerallhostsexplain'] = 'Du kan velge å automatisk registrere alle verter som kontakter deg. Dette betyr at en ny oppføring vil fremkomme i vertslista for alle Moodle-siter som kontakter deg og ber om den offentlige nøkkelen.<br/>Du har mulighet under til å sette opp tjenester for alle verter og ved å aktivere tjenester her kan du tilby tjenester til alle Moodle-servere.';
$string['registerhostsoff'] = 'Registrer alle eksterne servere er for tiden <b>deaktivert</b>';
$string['registerhostson'] = 'Registrer alle eksterne servere er for tiden <b>aktivert</b>';
$string['remotecourses'] = 'Fjernkurs';
$string['remotehost'] = 'Fjernnode';
$string['remotehosts'] = 'Fjernnoder';
$string['remoteuserinfo'] = 'Den eksterne brukerens {$a->remotetype} brukerprofil er hentet fra <a href="{$a->remoteurl}">{$a->remotename}</a>';
$string['requiresopenssl'] = 'Moodle Nettverk krever at PHP-tillegget OpenSSL er installert.';
$string['restore'] = 'Gjenoppretting';
$string['returnvalue'] = 'Returnert verdi';
$string['reviewhostdetails'] = 'Vis vertsinformasjon';
$string['reviewhostservices'] = 'Vis vertstjenestene';
$string['RPC_HTTP_PLAINTEXT'] = 'HTTP ukryptert';
$string['RPC_HTTP_SELF_SIGNED'] = 'HTTP (egensignert)';
$string['RPC_HTTPS_SELF_SIGNED'] = 'HTTPS (egensignert)';
$string['RPC_HTTPS_VERIFIED'] = 'HTTPS (signert)';
$string['RPC_HTTP_VERIFIED'] = 'HTTP (signert)';
$string['selectaccesslevel'] = 'Vennligst velg et tilgangsnivå fra listen.';
$string['selectahost'] = 'Vennligst velg en Moodle vert.';
$string['service'] = 'Tjenestenavn';
$string['serviceid'] = 'Tjeneste ID';
$string['servicesavailableonhost'] = 'Tjenester som er tilgjengelige på {$a}';
$string['serviceswepublish'] = 'Tjenester vi publiserer til {$a}.';
$string['serviceswesubscribeto'] = 'Tjenester på {$a} vi abonnerer på.';
$string['settings'] = 'Innstillinger';
$string['showlocal'] = 'Vis lokale brukere';
$string['showremote'] = 'Vis fjernbrukere';
$string['ssl_acl_allow'] = 'SSO ACL: Tillat bruker {$a->user} fra {$a->host}';
$string['ssl_acl_deny'] = 'SSO ACL: Nekt bruker {$a->user} fra {$a->host}';
$string['ssoaccesscontrol'] = 'SSO tilgangskontroll';
$string['ssoacldescr'] = 'Bruk denne siden til å tildele/nekte tilgang til bestemte brukere fra andre Moodle verter. Dette er nyttig når du tilbyr SSO (Singel Sign On) tjenester til fjernbrukere. For å styre dine <em>lokale</em> brukeres oppkobling mot andre Moodle verter kan du bruke rollestyringen til å tildele dem <em>mnetcanroam</em>-rettigheten.';
$string['ssoaclneeds'] = 'For at denne funksjonen skal fungere, må du først slå på Moodle Nettverk. Deretter må du slå på Moodle Nettverk autentiseringsmodul og aktivisere automatisk godkjenning av brukere.';
$string['strict'] = 'Streng';
$string['subscribe'] = 'Abonner';
$string['system'] = 'System';
$string['testclient'] = 'MNET testklient';
$string['testtrustedhosts'] = 'Sjekk en adresse';
$string['testtrustedhostsexplain'] = 'Skriv inn en IP-adresse for å sjekke om dette er en godkjent vert.';
$string['theypublish'] = 'De publiserer';
$string['theysubscribe'] = 'De abbonnerer på';
$string['transport_help'] = 'Disse innstillingene er resiproke, du kan derfor kun tvinge en fjernvert til å benytte et signert SSL sertifikat dersom din egen server har det samme.';
$string['trustedhosts'] = 'XML-RPC verter';
$string['trustedhostsexplain'] = '<p>Oppsettet med godkjente verter tillater valgte servere å utføre kall via XML-RPC til alle deler av din Moodle-API. Dette gjør at egne script kan styre din Moodles oppførsel og kan derfor være meget risikabelt å aktivisere. Er du i tvil - la den være av.</p>
<p>Du trenger <strong>IKKE</strong> denne funksjonen for at Moodle Nettverk skal fungere.</p>
<p>HVIS du vil slå funksjonen på, må du legge inn en liste med IP-adresser eller nettverk - ett på hver linje.
Noen eksempler:</p>Din lokale server:<br />127.0.0.1<br />Din lokale server (med et adresseområde):<br />127.0.0.1/32<br />Bare en vert med IP-adressen 192.168.0.7:<br />192.168.0.7/32<br />Alle verter med IP-adresse mellom 192.168.0.1 og 192.168.0.255:<br />192.168.0.0/24<br />Hvilken som helst server:<br />192.168.0.0/0<br />Det er vel åpenbart at det siste eksempelet <strong>IKKE</strong> anbefales.';
$string['turnitoff'] = 'Slå av';
$string['turniton'] = 'Slå på';
$string['type'] = 'Type';
$string['unknown'] = 'Ukjent';
$string['unknownerror'] = 'Ukjent feil oppsto under godkjenningen.';
$string['usercannotchangepassword'] = 'Du kan ikke bytte passord her siden du er en fjernbruker.';
$string['userchangepasswordlink'] = '<br /> Du kan bytte passordet (hvis det tillates) på Moodle portalen du hører til: <a href="{$a->wwwroot}/login/change_password.php">{$a->description}</a> provider.';
$string['usernotfullysetup'] = 'Brukerkontoen er ufullstendig. Du må derfor returnere til <a href="{$a}">der du kom fra</a> og fullføre profilen din der. Det kan også hende at du må logge ut og inn igjen for at endringene skal komme med.';
$string['usersareonline'] = 'Advarsel: {$a} brukere fra denne serveren er innlogget på din Moodle-server.';
$string['validated_by'] = 'Godkjent via nettverket: <code>{$a}</code>';
$string['verifysignature-error'] = 'Godkjenningen av signaturen mislykkes. En feil har oppstått.';
$string['verifysignature-invalid'] = 'Godkjenning av signaturen mislykkes. Det ser ut til at innholdet ikke var signert av deg.';
$string['version'] = 'Versjon';
$string['warning'] = 'Advarsel';
$string['wrong-ip'] = 'IP-adressen din samsvarer ikke med den adressen vi har i oppføringen.';
$string['xmlrpc-missing'] = 'Du må ha XML-RPC installert i PHP for å kunne bruke denne funksjonaliteten.';
$string['yourhost'] = 'Din vert';
$string['yourpeers'] = 'Andre Moodle- verter';
