<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'completion', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   completion
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['achievinggrade'] = 'Endelig karakter';
$string['activities'] = 'Aktiviteter';
$string['activitiescompleted'] = 'Aktiviteter fullført';
$string['activitiescompletednote'] = 'Merk: Du må slå på aktivitetsfullføring for aktiviteten for at den skal vises i listen over.';
$string['activityaggregation'] = 'Betingelsen krever';
$string['activityaggregation_all'] = 'ALLE valgte aktiviteter må fullføres';
$string['activityaggregation_any'] = 'NOEN av aktivitetene må fullføres';
$string['activitycompletion'] = 'Aktivitet fullført';
$string['aggregationmethod'] = 'Hvilke aktiviteter som skal telle med';
$string['all'] = 'Alle';
$string['any'] = 'Noen';
$string['approval'] = 'Godkjennelse';
$string['badautocompletion'] = 'Når du velger automatisk fullføring må du også velge minst ett fullføringskrav (under).';
$string['completed'] = 'Fullført';
$string['completedunlocked'] = 'Fullføringsvalgene er ikke låst';
$string['completedunlockedtext'] = 'Når du lagrer endringer vil fullføringsstatus for alle studenter bli slettet. Dersom du angrer - ikke lagre dette skjemaet.';
$string['completedwarning'] = 'Fullføringsvalgeneer låst.';
$string['completedwarningtext'] = 'En eller flere studenter ({$a}) har allerede merket denne aktiviteten som fullført. Endring av fullføringsvalgene for denne aktiviteten vil derfor slette studentenes fullførtstatus og skape forvirring. Fullføringsvalget burde vært låst og bør ikke endres uten at det er absolutt nødvendig.';
$string['completion'] = 'Fullførtsporing';
$string['completionactivitydefault'] = 'Bruk standard for denne aktiviteten';
$string['completion-alt-auto-enabled'] = 'Systemet merker dette elementet som fullført i henhold til betingelsene: {$a}';
$string['completion-alt-auto-fail'] = 'Fullført: {$a} (uten god nok karakter)';
$string['completion-alt-auto-n'] = 'Ikke fullført: {$a}';
$string['completion-alt-auto-pass'] = 'Fullført: {$a} (med godkjent karakter)';
$string['completion-alt-auto-y'] = 'Fullført: {$a}';
$string['completion-alt-manual-enabled'] = 'Studenter kan selv merke dette elementet som fullført: {$a}';
$string['completion-alt-manual-n'] = 'Ikke fullført: {$a} Velg for å merke som fullført';
$string['completion-alt-manual-y'] = 'Fullført: {$a} Velg for å merke som ikke fullført.';
$string['completion_automatic'] = 'Merk aktiviteten som fullført når betingelsene er oppfylt';
$string['completiondefault'] = 'Standard fullførtsporing';
$string['completiondisabled'] = 'Deaktivert, vises ikke i aktivitetsinnstillingene';
$string['completionduration'] = 'Påmelding';
$string['completionenabled'] = 'Aktivert og styres via fullført- og aktivitetsinnstillingene';
$string['completionexpected'] = 'Forventet fullført innen';
$string['completionexpected_help'] = 'Denne innstillingene angir datoen for når aktiviteten forventes fullført. Datoen vises ikke til studentene og vises kun i fremdriftsrapporten.';
$string['completion-fail'] = 'Fullført (uten god nok karakter)';
$string['completion_help'] = 'Dersom aktivert vil fullføringsgrad spores, enten manuelt eller automatisk, basert på bestemte betingelser. En kan om ønskelig sette flere betingelser. Dersom det er gjort vil aktiviteten kun bli registrert som fullført når alle betingelsene er oppfylt.

Et merke ved aktivitetsnavnet på kurssiden indikerer om aktiviteten er fullført.';
$string['completionicons'] = 'Merkebokser for fullført';
$string['completionicons_help'] = 'En avmerkingsboks ved aktivitetsnavnet kan brukes til å vise om aktiviteten er fullført.

Dersom en boks med en prikkete ramme vises, vil en hake fremkomme automatisk straks du har fullført aktiviteten i tråd med de betingelsene som er satt for denne aktiviteten. Det er læreren som styrer dette.

Dersom en boks med en hel ramme vises, kan du klikke på den når du mener at du har fullført aktiviteten. (Et nytt klikk fjerner avmerkingen dersom du angrer.) Avmerkingen er frivilling og en mulighet til å få oversikt over egen fremdrift i kurset.';
$string['completion_manual'] = 'Studenter kan manuelt merke aktiviteten som fullført';
$string['completionmenuitem'] = 'Fullføring';
$string['completion-n'] = 'Ikke fullført';
$string['completion_none'] = 'Ikke bruk aktivitetsfullføring';
$string['completionnotenabled'] = 'Fullføring er ikke aktivert';
$string['completionnotenabledforcourse'] = 'Fullføring er ikke aktivert i dette kurset';
$string['completionnotenabledforsite'] = 'Fullføring er ikke aktivert på denne kursportalen';
$string['completionondate'] = 'Dato';
$string['completionondatevalue'] = 'Brukeren må være pålogget inntil';
$string['completion-pass'] = 'Fullført (med godkjent karakter)';
$string['completionsettingslocked'] = 'Innstillinger for fullføring er låst';
$string['completion-title-manual-n'] = 'Merk som fullført: {$a}';
$string['completion-title-manual-y'] = 'Merk som ikke fullført: {$a}';
$string['completionusegrade'] = 'Trenger karakter';
$string['completionusegrade_desc'] = 'Studenten må få en karakter for å fullføre denne aktiviteten';
$string['completionusegrade_help'] = 'Dersom aktivert vil aktiviteten regnes som fullført når studenten mottar en karakter. Godkjent/Underkjent ikoner kan vises når en angir et minimumsnivå for prestasjonen.';
$string['completionview'] = 'Visning påkrevet';
$string['completionview_desc'] = 'Studenten må se denne aktiviteten for å fullføre den.';
$string['completion-y'] = 'Fullført';
$string['configcompletiondefault'] = 'Standardinnstilling for fullførtsporing når nye aktiviteter opprettes.';
$string['configenablecompletion'] = 'Når aktivert vil dette tillate at sporing av fremdrift slås på i kurset.';
$string['confirmselfcompletion'] = 'Bekreft egenregistrering av fullføring';
$string['courseaggregation'] = 'Betingelsen krever';
$string['courseaggregation_all'] = 'ALLE valgte kurs må fullføres';
$string['courseaggregation_any'] = 'NOEN kurs må fullføres';
$string['coursealreadycompleted'] = 'Du har allerede fullført dette kurset';
$string['coursecomplete'] = 'Kurs gjennomført';
$string['coursecompleted'] = 'Fullførte kurs';
$string['coursecompletion'] = 'Kursfullføring';
$string['coursecompletioncondition'] = 'Betingelse: {$a}';
$string['coursegrade'] = 'Kurskarakter';
$string['coursesavailable'] = 'Kurs tilgjengelig';
$string['coursesavailableexplaination'] = '<i>Kriterier for registrering av fullført må angis for at kurset skal fremkomme i denne listen</i>';
$string['criteria'] = 'Kriterie';
$string['criteriagroup'] = 'Kriteriegruppe';
$string['criteriarequiredall'] = 'Alle kriteriene under er obligatoriske';
$string['criteriarequiredany'] = 'Ethvert kriterium under er obligatorisk';
$string['csvdownload'] = 'Last ned som regneark (utf-8.csv)';
$string['datepassed'] = 'Data godkjent';
$string['days'] = 'Dager';
$string['daysoftotal'] = '{$a->days} av {$a->total}';
$string['deletecompletiondata'] = 'Siste fullføringsdata';
$string['dependencies'] = 'Avhengigheter';
$string['dependenciescompleted'] = 'Fullføring av andre kurs';
$string['editcoursecompletionsettings'] = 'Endre innstillinger for kursfullføring';
$string['enablecompletion'] = 'Aktiver fremdriftssporing';
$string['enablecompletion_help'] = 'Når du aktiverer denne innstillingen vil menyelementet "Kursfullføring" vises under "Innstillinger" og fullføringsinnstillingene vises for hver aktivitet.';
$string['enrolmentduration'] = 'Dager igjen';
$string['enrolmentdurationlength'] = 'Bruker må være innlogget i';
$string['err_noactivities'] = 'Fullføringssporing er ikke aktivert for noen aktiviteter og kan derfor ikke vises. Du kan aktivere fullføringsinformasjon ved å redigere innstillingene for en aktivitet.';
$string['err_nocourses'] = 'Sporing av kursfullføring er ikke aktivert for noen andre kurs, og kan derfor ikke vises. Du kan aktivere kursfullføring ved å redigere kursinnstillingene.';
$string['err_nograde'] = 'Det er ikke satt noen minstekrav for fullføring av kurset. For å aktivere dette kriteriet må du angi et minstekrav (karakter) for dette kurset.';
$string['err_noroles'] = 'Det er ingen roller med rettigheten \'moodle/course:markcomplete\' i dette kurset.';
$string['err_nousers'] = 'Det er ingen studenter i dette kurset eller gruppen som det kan vises fremdriftsinformasjon for. (Som standard vises fremdriftsinformasjon bare for studenter. Hvis det ikke er lagt inn studenter vil du derfor få denne feilmeldingen. Administrator kan endre dette valget i det administrative oppsettet.)';
$string['err_settingslocked'] = 'En eller flere studenter har allerede fullført et kritium, så innstillingene er låst. Dersom du låser opp kriterieinnstillingene vil eksisterende brukerdata slettes og det kan skape forvirring.';
$string['err_system'] = 'Det oppstod en intern feil i fremdriftssystemet. (Systemadministrator kan slå på debugging for å få mer detaljert informasjon om feilen.)';
$string['eventcoursecompleted'] = 'Fullført kurs';
$string['eventcoursecompletionupdated'] = 'Fullførtsporing oppdatert';
$string['eventcoursemodulecompletionupdated'] = 'Aktivitetens fullførtsporing er oppdatert';
$string['excelcsvdownload'] = 'Last ned i Excel-kompatibelt format. (.csv)';
$string['fraction'] = 'Fraksjon';
$string['graderequired'] = 'Karakter påkrevd';
$string['gradexrequired'] = '{$a} påkrevd';
$string['inprogress'] = 'Pågår';
$string['manualcompletionby'] = 'Manuell fullføring av andre';
$string['manualcompletionbynote'] = 'Merk: Rettigheten moodle/course:markcomplete må være tillatt for at rollen skal fremkomme i listen.';
$string['manualselfcompletion'] = 'Manuell egenregistrering av fullføring';
$string['manualselfcompletionnote'] = 'Merk: Blokken for egenfullføring må legges til i kurset hvis du aktiverer manuell egenfullføring.';
$string['markcomplete'] = 'Merk som fullført';
$string['markedcompleteby'] = 'Merket som fullført av {$a}';
$string['markingyourselfcomplete'] = 'Merk deg selv som fullført';
$string['moredetails'] = 'Flere detaljer';
$string['nocriteriaset'] = 'Det er ikke satt noen fullførtkriterier for dette kurset';
$string['notcompleted'] = 'Ikke fullført';
$string['notenroled'] = 'Du er ikke påmeldt dette kurset';
$string['nottracked'] = 'For øyeblikket blir ikke din progresjon registrert av fullførtsporingen i dette kurset';
$string['notyetstarted'] = 'Ikke startet ennå';
$string['overallaggregation'] = 'Fullføringsbetingelser';
$string['overallaggregation_all'] = 'Kurset er fullført når ALLE vilkår er oppfylt';
$string['overallaggregation_any'] = 'Kurset er fullført når NOEN av vilkårene er oppfylt';
$string['pending'] = 'Behandles';
$string['periodpostenrolment'] = 'Periode etter innmelding';
$string['progress'] = 'Studentens fremdrift';
$string['progress-title'] = '{$a->user}, {$a->activity}: {$a->state} {$a->date}';
$string['progresstotal'] = 'Fremdrift: {$a->complete} / {$a->total}';
$string['recognitionofpriorlearning'] = 'Anerkjennelse av tidligere lært';
$string['remainingenroledfortime'] = 'Forbli innmeldt i en angitt periode';
$string['remainingenroleduntildate'] = 'Forbli innmeldt inntil en angitt dato';
$string['reportpage'] = 'Viser brukerne {$a->from} to {$a->to} of {$a->total}.';
$string['requiredcriteria'] = 'Påkrevde kritier';
$string['restoringcompletiondata'] = 'Skriver fullføringsdata';
$string['roleaggregation'] = 'Vilkår som må oppfylles';
$string['roleaggregation_all'] = 'Alle valgte roller som kan markere når betingelsen er oppfylt';
$string['roleaggregation_any'] = 'Noen valgte roller som kan markere når betingelsen er oppfylt';
$string['saved'] = 'Lagret';
$string['seedetails'] = 'Se detaljer';
$string['self'] = 'Egen';
$string['selfcompletion'] = 'Egenregistrering av fullføring';
$string['showinguser'] = 'Viser brukeren';
$string['unenrolingfromcourse'] = 'Melder ut fra kurset';
$string['unenrolment'] = 'Utmelding';
$string['unit'] = 'Enhet';
$string['unlockcompletion'] = 'Lås opp innstillinger for fullføring';
$string['unlockcompletiondelete'] = 'Lås opp innstillinger for fullføring og slett brukernes fullføringsdata';
$string['usealternateselector'] = 'Bruk den alternative kursvelgeren';
$string['usernotenroled'] = 'Brukeren er ikke påmeldt i dette kurset';
$string['viewcoursereport'] = 'Vis kursrapport';
$string['viewingactivity'] = 'Viser {$a}';
$string['writingcompletiondata'] = 'Skriver fullføringsdata';
$string['xdays'] = '{$a} dager';
$string['yourprogress'] = 'Din fremdrift';
