<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Máte jeden alebo viac nových zadaní (kliknite sem na ich zobrazenie).';
$string['addattempt'] = 'Povoliť ďalší pokus';
$string['addnewattempt'] = 'Pridať nový pokus';
$string['addnewattemptfromprevious'] = 'Pridať nový pokus na základe posledného odovzdania';
$string['addsubmission'] = 'Odovzdať zadanie';
$string['allocatedmarker'] = 'Pridelený hodnotiteľ';
$string['allocatedmarker_help'] = 'Hodnotiteľ pridelený tomuto vypracovanému zadaniu';
$string['allowsubmissions'] = 'Povoliť používateľovi pokračovať v hodnotení odovzdaného zadania';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Detaily zadania a formulár pre odovzdanie bude dostupný od <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Povoliť odovzdanie zadaní od';
$string['allowsubmissionsfromdate_help'] = 'Ak je povolené, študenti nebudú môcť pred týmto termínom odovzdať zadanie. Ak nie je povolené, študenti budú môcť odovzdávať zadania okamžite.';
$string['allowsubmissionsfromdatesummary'] = 'Odovzdať zadanie bude možné od <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Povoliť zmeny odovzdaného zadania';
$string['alwaysshowdescription'] = 'Povoliť zobrazenie opisu zadania';
$string['alwaysshowdescription_help'] = 'Ak nie je povolené, opis zadania zobrazený vyššie bude študentom zobrazený iba po dátume, od ktorého možno vkladať odovzdané zadania.';
$string['applytoteam'] = 'Použiť známky a komentáre pre celú skupinu';
$string['assign:addinstance'] = 'Pridať nové zadanie';
$string['assign:exportownsubmission'] = 'Exportovať vlastné odovzdané zadanie';
$string['assignfeedback'] = 'Rozšírenie typu dotazník';
$string['assignfeedbackpluginname'] = 'Rozšírenie typu dotazník';
$string['assign:grade'] = 'Ohodnotiť zadanie';
$string['assign:grantextension'] = 'Poskytnúť predĺženie';
$string['assign:manageallocations'] = 'Spravovať hodnotiteľov pridelených k zadaniam';
$string['assign:managegrades'] = 'Revízia a zverejnenie známok';
$string['assignmentisdue'] = 'Zadanie treba odovzdať k dátumu';
$string['assignmentmail'] = '{$a->grader} okomentoval  vaše riešenie zadania \'{$a->assignment}\'.

Hodnotenie nájdete pri svojom vypracovanom zadaní na adrese:
{$a->url}.';
$string['assignmentmailhtml'] = '<p>{$a->grader} okomentoval  vaše riešenie zadania  \'<i>{$a->assignment}</i>\'. </p><p>Hodnotenie zájdete pri svojom <a href="{$a->url}">vypracovanom zadaní</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} okomentoval vaše riešenie zadania "{$a->assignment}". Hodnotenie nájdete pri svojom vypracovanom zadaní.';
$string['assignmentname'] = 'Názov zadania';
$string['assignmentplugins'] = 'Zásuvné moduly aktivity Zadanie';
$string['assignmentsperpage'] = 'Zadaní na stránku';
$string['assign:releasegrades'] = 'Zverejnenie známok';
$string['assign:revealidentities'] = 'Ukázať identitu študentov';
$string['assign:reviewgrades'] = 'Preskúmanie známok';
$string['assignsubmission'] = 'Zásuvný modul typu odovzdané zadanie';
$string['assignsubmissionpluginname'] = 'Zásuvný modul typu odovzdané zadanie';
$string['assign:submit'] = 'Odoslať zadanie';
$string['assign:view'] = 'Prezrieť zadanie';
$string['attemptheading'] = 'Pokus č. {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Predchodzie pokusy';
$string['attemptnumber'] = 'Číslo pokusu';
$string['attemptreopenmethod'] = 'Opätovné otvorenie pokusov';
$string['attemptreopenmethod_manual'] = 'Ručne';
$string['attemptreopenmethod_none'] = 'Nikdy';
$string['attemptreopenmethod_untilpass'] = 'Automaticky kým neuspeje';
$string['attemptsettings'] = 'Nastavenie pokusov';
$string['availability'] = 'Dostupnosť';
$string['backtoassignment'] = 'Späť k zadaniu';
$string['batchoperationconfirmaddattempt'] = 'Povoliť ďalší pokus pre označené odovzdané riešenia?';
$string['batchoperationconfirmgrantextension'] = 'Poskytnúť predĺženie pre všetky vybrané odovzdané zadania?';
$string['batchoperationconfirmlock'] = 'Zamknúť všetky vybrané odovzdané zadania?';
$string['batchoperationconfirmreverttodraft'] = 'Vrátiť všetky vybrané vypracované zadania do stavu pracovnej verzie?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Nastaviť pridelenie známok pre všetky vybrané odovzdané zadania?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Nastaviť spracovanie známok pre všetky vybrané odovzdané zadania?';
$string['batchoperationconfirmunlock'] = 'Odomknúť všetky vybrané vypracované zadania?';
$string['batchoperationlock'] = 'zamknúť vypracované zadania';
$string['batchoperationreverttodraft'] = 'vrátiť odovzdané zadanie do stavu pracovnej verzie';
$string['batchoperationsdescription'] = 'S vybranými ...';
$string['batchoperationunlock'] = 'odomknúť vypracované zadania';
$string['batchsetallocatedmarker'] = 'Nastaviť pridelenie hodnotiteľa pre {$a} vybraných používateľov.';
$string['batchsetmarkingworkflowstateforusers'] = 'Nastaviť spracovanie známky pre {$a} vybraných používateľov.';
$string['blindmarking'] = 'Známkovanie naslepo';
$string['blindmarking_help'] = 'Hodnotenie naslepo skryje pre hodnotiteľov identitu študentov. Nastavenie anonymného hodnotenia bude zamknuté po odovzdaní zadania alebo hodnotenia zadania.';
$string['choosegradingaction'] = 'Akcia hodnotenia';
$string['choosemarker'] = 'Vybrať ...';
$string['chooseoperation'] = 'Vybrať operáciu';
$string['comment'] = 'Komentár';
$string['completionsubmit'] = 'Pre dokončenie tejto činnosti musí študent odovzdať zadanie';
$string['configshowrecentsubmissions'] = 'Zobrazovať každému informáciu o odovzdaných zadaniach v bloku prehľadu nedávnej činnosti.';
$string['confirmbatchgradingoperation'] = 'Naozaj chcete {$a->operation} pre {$a->count} študentov?';
$string['confirmsubmission'] = 'Naozaj chcete odoslať svoju prácu na hodnotenie. Nebudete môcť urobiť žiadne ďalšie zmeny.';
$string['conversionexception'] = 'Nebolo možné konvertovať zadanie. Výnimka je: {$a}.';
$string['couldnotconvertgrade'] = 'Nebolo možné konvertovať hodnotenie zadania pre používateľa {$a}.';
$string['couldnotconvertsubmission'] = 'Nebolo možné konvertovať odovzdané zadania pre používateľa {$a}.';
$string['couldnotcreatecoursemodule'] = 'Nebolo možné vytvoriť modul kurzu.';
$string['couldnotcreatenewassignmentinstance'] = 'Nebolo možné vytvoriť novú inštanciu zadania.';
$string['couldnotfindassignmenttoupgrade'] = 'Nebolo možné nájsť staré inštancie modulov zadanie pre aktualizáciu.';
$string['currentattempt'] = 'Toto je pokus č. {$a}.';
$string['currentattemptof'] = 'Toto je pokus č. {$a->attemptnumber} (celkom je povolené {$a->maxattempts} pokusov).';
$string['currentgrade'] = 'Súčasné hodnotenie vo výkaze známok';
$string['cutoffdate'] = 'Dátum ukončenia';
$string['cutoffdatefromdatevalidation'] = 'Dátum ukončenia musí byť po dátume, ktorým bolo umožnené odovzdávať zadania';
$string['cutoffdate_help'] = 'Ak je nastavené, nebude povolené odovzdávanie zadania po tomto dátume bez predĺženia termínu.';
$string['cutoffdatevalidation'] = 'Dátum ukončenia nemôže byť skôr ako dátum odovzdania.';
$string['defaultsettings'] = 'Východzie nastavenia zadania';
$string['defaultsettings_help'] = 'Tieto nastavenia definujú východzie hodnoty pre všetky nové zadania.';
$string['defaultteam'] = 'Východzia skupina';
$string['deleteallsubmissions'] = 'Vymazať všetky odovzdané zadania';
$string['description'] = 'Opis';
$string['downloadall'] = 'Stiahnuť všetky odovzdané zadania';
$string['duedate'] = 'Dátum, do ktorého treba zaslať vypracované zadanie';
$string['duedate_help'] = 'Toto určuje dátum, do ktorého je potrebné vypracovať zadanie. Ak sú povolené oneskorené odovzdávania, bude každé zadanie vložené po tomto dátume ako oneskorené.';
$string['duedateno'] = 'Bez uzávierky zasielania vypracovaných zadaní';
$string['duedatereached'] = 'Termín pre odovzdanie tohto zadania už uplynul';
$string['duedatevalidation'] = 'Termín ukončenia musí byť po termíne povoľujúcom odovzdanie zadaní.';
$string['editaction'] = 'Akcie ...';
$string['editattemptfeedback'] = 'Upraviť hodnotenie pre pokus č. {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Upravujete hodnotenie k odovzdanému riešeniu, ktoré nie je najnovšie. Toto je pokus č. {$a->attemptnumber} z celkového počtu {$a->totalattempts}.';
$string['editingstatus'] = 'Stav úprav';
$string['editsubmission'] = 'Upraviť moje vypracované zadanie';
$string['editsubmission_help'] = 'Urobte zmeny vo vašom zadaní';
$string['enabled'] = 'Povolené';
$string['errornosubmissions'] = 'Nie sú žiadne odovzdané zadania na stiahnutie';
$string['errorquickgradingvsadvancedgrading'] = 'Hodnotenia neboli uložené, pretože zadanie v súčasnosti využíva pokročilé hodnotenie.';
$string['errorrecordmodified'] = 'Hodnotenia neboli uložené, pretože niekto iný upravil jeden alebo viacero záznamov potom, ako ste načítali túto stránku.';
$string['event_all_submissions_downloaded'] = 'Všetky odovzdané zadania sú sťahované.';
$string['event_assessable_submitted'] = 'Zadanie bolo odoslané.';
$string['event_extension_granted'] = 'Bolo poskytnuté predĺženie termínu.';
$string['event_identities_revealed'] = 'Identita študentov bola odhalená.';
$string['event_marker_updated'] = 'Pridelený hodnotiteľ bol aktualizovaný.';
$string['event_statement_accepted'] = 'Používateľ prijal prehlásenie o odovzdanom zadaní.';
$string['event_submission_duplicated'] = 'Používateľ zopakoval svoje riešenie zadania.';
$string['event_submission_graded'] = 'Odovzdané zadanie bolo ohodnotené.';
$string['event_submission_locked'] = 'Odovzdané zadanie bolo pre používateľa zamknuté.';
$string['event_submission_status_updated'] = 'Stav odovzdaného zadania bol aktualizovaný.';
$string['event_submission_unlocked'] = 'Odovzdané zadanie bolo pre používateľa odomknuté.';
$string['event_submission_updated'] = 'Používateľ uložil svoje zadanie.';
$string['event_workflow_state_updated'] = 'Stav spracovania bol aktualizovaný.';
$string['extensionduedate'] = 'Predĺžený termín odovzdania';
$string['extensionnotafterduedate'] = 'Predĺžený termín odovzdania musí byť po termíne odovzdania';
$string['extensionnotafterfromdate'] = 'Predĺžený termín odovzdania musí byť po dátume umožňujúcom odovzdanie zadania';
$string['feedback'] = 'Komentár';
$string['feedbackavailablehtml'] = '{$a->username} vložil komentáre na vaše odovzdané zadanie \'<i>{$a->assignment}</i>\'<br /><br /> Môžete si ho prezrieť pripojené k vášmu <a href="{$a->url}">odovzdanému zadaniu</a>.';
$string['feedbackavailablesmall'] = '{$a->username} vložil komentáre k zadaniu {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} vložil komentáre na vaše odovzdané zadanie  \'{$a->assignment}\' Môžete si ho prezrieť pripojené k vášmu zadaniu: {$a->url}';
$string['feedbackplugin'] = 'Zásuvný modul pre komentár';
$string['feedbackpluginforgradebook'] = 'Zásuvný modul pre komentáre bude zapisovať komentáre k hodnoteniu';
$string['feedbackpluginforgradebook_help'] = 'Iba jeden zo zásuvných modulov komentárov k zadaniu môže vložiť komentár do výkazu známok.';
$string['feedbackplugins'] = 'Moduly komentárov';
$string['feedbacksettings'] = 'Nastavenia komentára';
$string['feedbacktypes'] = 'Typy hodnotenia';
$string['filesubmissions'] = 'Súbory odovzdaných zadaní';
$string['filter'] = 'Filter';
$string['filternone'] = 'Bez filtru';
$string['filterrequiregrading'] = 'Vyžaduje hodnotenie';
$string['filtersubmitted'] = 'Zadanie bolo odovzdané';
$string['gradeabovemaximum'] = 'Hodnotenie musí byť menšie alebo rovné ako {$a}.';
$string['gradebelowzero'] = 'Hodnotenie musí byť väčšie alebo rovné ako nule.';
$string['gradecanbechanged'] = 'Známka môže byť zmenená';
$string['graded'] = 'Hodnotené';
$string['gradedby'] = 'Hodnotené kým:';
$string['gradedon'] = 'Hodnotené na';
$string['gradelocked'] = 'Táto známka je vo výkaze známok zamknutá alebo prepísaná.';
$string['gradeoutof'] = 'Hodnotené z {$a}';
$string['gradeoutofhelp'] = 'Hodnotenie';
$string['gradeoutofhelp_help'] = 'Sem zadajte známku za vypracované zadanie študenta. Môžete použiť desatinné miesta.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} aktualizoval  vypracované zadanie pre <i>\'{$a->assignment}\' dňa {$a->timeupdated}</i><br /><br />Je <a href="{$a->url}">dostupné na web portáli</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} aktualizoval svoje odovzdan zadanie {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} aktualizoval svoje vypracované zadanie pre \'{$a->assignment}\' dňa {$a->timeupdated}

Je dostupné tu:

{$a->url}';
$string['gradestudent'] = 'Hodnotenie študenta: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Známka {$a}';
$string['grading'] = 'Hodnotenie';
$string['gradingchangessaved'] = 'Zmeny vo známkach boli uložené';
$string['gradingmethodpreview'] = 'Kritériá hodnotenia';
$string['gradingoptions'] = 'Voľby';
$string['gradingstatus'] = 'Stav hodnotenia';
$string['gradingstudent'] = 'Hodnotený študent';
$string['gradingsummary'] = 'Sumár hodnotenia';
$string['grantextension'] = 'Poskytnúť predĺženie';
$string['grantextensionforusers'] = 'Poskytnúť predĺženie pre {$a} študentov';
$string['groupsubmissionsettings'] = 'Nastavenie skupinového riešenia';
$string['hiddenuser'] = 'Účastník';
$string['hideshow'] = 'Skryť/zobraziť.';
$string['instructionfiles'] = 'Súbory s návodmi';
$string['invalidfloatforgrade'] = 'Neplatné hodnotenie: {$a}';
$string['invalidgradeforscale'] = 'Poskytnuté hodnotenie nie je správne pre súčasnú stupnicu';
$string['lastmodifiedgrade'] = 'Posledná zmena (hodnotenie)';
$string['lastmodifiedsubmission'] = 'Posledná zmena (odovzdané hodnotenie)';
$string['latesubmissions'] = 'Oneskorené odovzdané zadania';
$string['latesubmissionsaccepted'] = 'Iba študenti, ktorým bol predĺžený termín, môžu stále odovzdať zadanie';
$string['locksubmissionforstudent'] = 'Zabrániť odovzdaniu hodnotenia študenta: (id={$a->id}, celé meno={$a->fullname}).';
$string['locksubmissions'] = 'Zamknúť odovzdávanie zadaní';
$string['manageassignfeedbackplugins'] = 'Spravovať zásuvné moduly pre komentovanie zadaní';
$string['manageassignsubmissionplugins'] = 'Spravovať zásuvné moduly pre odovzdanie zadaní';
$string['marker'] = 'Hodnotiteľ';
$string['markerfilter'] = 'Filter hodnotiteľa';
$string['markingallocation'] = 'Použiť prideľovanie hodnotiteľov';
$string['markingworkflow'] = 'Použiť postup známkovania';
$string['markingworkflowstate'] = 'Stav postupu známkovania';
$string['markingworkflowstateinmarking'] = 'Známkované';
$string['markingworkflowstateinreview'] = 'Revidované';
$string['markingworkflowstatenotmarked'] = 'Bez známky';
$string['markingworkflowstatereadyforrelease'] = 'Pripravené na zverejnenie';
$string['markingworkflowstatereadyforreview'] = 'Známkovanie ukončené';
$string['markingworkflowstatereleased'] = 'Zverejnené';
$string['maxattempts'] = 'Maximálny počet pokusov';
$string['maxattempts_help'] = 'Najvyšší možný počet pokusov na odovzdanie zadania pre každého študenta. Po dosiahnutí tohto počtu už nebude možné opätovne otvoriť odovzdané zadanie pre ďalšie úpravy.';
$string['maxgrade'] = 'Maximálna známka';
$string['messageprovider:assign_notification'] = 'Notifikácie zadaní';
$string['modulename'] = 'Zadanie';
$string['modulenameplural'] = 'Zadania';
$string['moreusers'] = '{$a} viac ...';
$string['mysubmission'] = 'Moje odovzdané zadanie';
$string['newsubmissions'] = 'Odovzdané zadania';
$string['noattempt'] = 'Neodovzdané';
$string['nofiles'] = 'Žiadne súbory';
$string['nograde'] = 'Žiadne hodnotenie.';
$string['nolatesubmissions'] = 'Odovzdávanie oneskorených zadaní nie je umožnené.';
$string['nomoresubmissionsaccepted'] = 'Nie je možné odovzdať žiadne zadania';
$string['noonlinesubmissions'] = 'Toto zadanie nevyžaduje odpovedať online';
$string['nosavebutnext'] = 'Ďalší';
$string['nosubmission'] = 'V tomto zadaní nebolo nič odovzdané';
$string['nosubmissionsacceptedafter'] = 'Ukončenie odovzdávania';
$string['notgraded'] = 'Nehodnotené';
$string['notgradedyet'] = 'Ešte neoznámkované';
$string['notifications'] = 'Oznámenia';
$string['notsubmittedyet'] = 'Ešte neodovzdané';
$string['nousersselected'] = 'Neboli vybraní používatelia';
$string['numberofdraftsubmissions'] = 'Pracovné verzie';
$string['numberofparticipants'] = 'Účastníci';
$string['numberofsubmissionsneedgrading'] = 'Je potrebné ohodnotiť';
$string['numberofsubmittedassignments'] = 'Odovzdané';
$string['numberofteams'] = 'Skupiny';
$string['offline'] = 'Nie sú požadované online odpovede';
$string['open'] = 'Otvorené';
$string['outlinegrade'] = 'Hodnotenie: {$a}';
$string['outof'] = '{$a->current} z {$a->total}';
$string['overdue'] = '<font color="red">Zadanie je oneskorené o: {$a}</font>';
$string['page-mod-assign-view'] = 'Hlavná stránka modulu zadanie';
$string['page-mod-assign-x'] = 'Ľubovoľná stránka modulu zadanie';
$string['participant'] = 'Účastník';
$string['pluginadministration'] = 'Administratíva zadania';
$string['pluginname'] = 'Zadanie';
$string['preventsubmissions'] = 'Zabrániť používateľovi odoslať ďalšie odovzdanie zadania';
$string['preventsubmissionsshort'] = 'Zabrániť zmenám v odovzdaných zadaniach';
$string['previous'] = 'Predchádzajúci';
$string['quickgrading'] = 'Rýchle hodnotenie';
$string['quickgradingchangessaved'] = 'Zmeny hodnotenia boli uložené';
$string['quickgradingresult'] = 'Rýchle hodnotenie';
$string['recordid'] = 'Identifikátor';
$string['requireallteammemberssubmit'] = 'Vyžaduje sa potvrdenie všetkých členov skupiny';
$string['requireallteammemberssubmit_help'] = 'Ak je povolené, všetci členovia skupiny musia kliknúť na odovzdávacie tlačidlo - až potom bude práca odovzdaná. Ak nie je povolené, potom ľubovoľný z členov skupiny môže zadanie odovzdať.';
$string['requiresubmissionstatement'] = 'Požadovať, aby študenti potvrdili predložené vyhlásenie';
$string['requiresubmissionstatement_help'] = 'Požadovať, aby študenti potvrdili predložené vyhlásenie pre všetky dokumenty a texty tohto zadania';
$string['revealidentities'] = 'Odhaliť identitu študentov';
$string['reverttodraft'] = 'Vrátiť zadanie do stavu pracovnej verzie.';
$string['reverttodraftforstudent'] = 'Vrátiť zadanie do stavu pracovnej verzie pre študenta: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Vrátiť zadanie do stavu pracovnej verzie.';
$string['reviewed'] = 'Kontrolované';
$string['saveallquickgradingchanges'] = 'Uložiť všetky zmeny v rýchlom hodnotení';
$string['savechanges'] = 'Uložiť zmeny';
$string['savegradingresult'] = 'Známka';
$string['savenext'] = 'Uložiť a zobraziť ďalší';
$string['scale'] = 'Mierka';
$string['selectedusers'] = 'Vybraní používatelia';
$string['selectlink'] = 'Vybrať ...';
$string['selectuser'] = 'Vybrať  {$a}';
$string['sendlatenotifications'] = 'Poslať oznámenie hodnotiteľom o oneskorených zadaniach';
$string['sendlatenotifications_help'] = 'Ak je povolené, hodnotiteľom (obvykle učiteľom) bude zaslané správa vždy, keď nejaký študent vypracuje zadanie oneskorene. Spôsoby zasielania správ sú konfigurovateľné.';
$string['sendnotifications'] = 'Poslať oznámenie hodnotiteľom';
$string['sendnotifications_help'] = 'Ak je povolené, hodnotiteľom (obvykle učiteľom) bude zaslané správa vždy, keď nejaký študent vypracuje zadanie (načas alebo oneskorene). Spôsoby zasielania správ sú konfigurovateľné.';
$string['sendstudentnotifications'] = 'Upozorniť študentov';
$string['sendsubmissionreceipts'] = 'Poslať potvrdenie o odovzdaní zadania študentom';
$string['sendsubmissionreceipts_help'] = 'Tento prepínač umožní povolenie zasielania potvrdení o odovzdaní zadania študentom. Študenti dostanú správu vždy, keď úspešne odovzdajú zadanie.';
$string['setmarkerallocationforlog'] = 'Nastaviť pridelenie hodnotiteľov: (id = {$a->id}, meno = {$a->fullname}, hodnotiteľ = {$a->marker}).';
$string['setmarkingallocation'] = 'Nastaviť hodnotiteľa';
$string['setmarkingworkflowstate'] = 'Nastaviť stav známkovania';
$string['setmarkingworkflowstateforlog'] = 'Nastavenie postupu známkovania: (id = {$a->id}, meno = {$a->fullname}, stav = {$a->state}).';
$string['settings'] = 'Nastavenia zadania';
$string['showrecentsubmissions'] = 'Zobrazovať nedávno odovzdané zadania';
$string['status'] = 'Status';
$string['submission'] = 'Odovzdané zadanie';
$string['submissiondrafts'] = 'Požadovať, aby študenti klikli na tlačidlo Odoslať';
$string['submissiondrafts_help'] = 'Ak je povolené, študenti budú musieť kliknúť na tlačidlo Odoslať, aby deklarovali, že toto je finálna verzia. Toto umožní študentom držať pracovnú verziu zadania v systéme. Ak sa toto nastavenie zmení z "Nie" na "Áno" potom, ako študenti už odovzdali svoje zadania, tieto budú chápané ako finálne.';
$string['submissioneditable'] = 'Študent môže upraviť toto zadanie';
$string['submissionempty'] = 'Nič nebolo odovzdané';
$string['submissionnoteditable'] = 'Študent nemôže upravovať toto zadanie';
$string['submissionnotready'] = 'Toto zadanie nie je pripravené k odovzdaniu:';
$string['submissionplugins'] = 'Zásuvné moduly odovzdávania zadania';
$string['submissionreceipthtml'] = 'Odoslali ste vypracované zadanie \'<i>{$a->assignment}</i>\'<br /><br /> Jeho stav môžete vidieť na stránke <a href="{$a->url}">vášho zadania</a>.';
$string['submissionreceipts'] = 'Odoslať potvrdenie o odovzdaní zadania';
$string['submissionreceiptsmall'] = 'Odovzdali ste svoje vypracované zadanie pre zadanie {$a->assignment}';
$string['submissionreceipttext'] = 'Odovzdali ste svoje vypracované zadanie pre zadanie {$a->assignment}

Stav svojho zadania môžete vidieť na tomto odkaze: {$a->url}';
$string['submissions'] = 'Odovzdané zadania';
$string['submissionsclosed'] = 'Odovzdávanie bolo uzavreté';
$string['submissionsettings'] = 'Nastavenie odovzdávania zadaní';
$string['submissionslocked'] = 'Toto zadanie neumožňuje odovzdávať vypracované zadanie';
$string['submissionslockedshort'] = 'Zmeny odovzdaných zadaní nie sú povolené';
$string['submissionsnotgraded'] = 'Nehodnotené odpovede: {a$}';
$string['submissionstatement'] = 'Vyhlásenie';
$string['submissionstatementacceptedlog'] = 'Vyhlásenie prijaté používateľom {$a}';
$string['submissionstatementdefault'] = 'Toto zadanie je mojou vlastnou prácou okrem častí, kde som uznal použitie prác iných ľudí';
$string['submissionstatement_help'] = 'Potvrdené vyhlásenie zadania';
$string['submissionstatus'] = 'Stav odovzdávania zadania';
$string['submissionstatus_'] = 'Žiadne odovzdané zadanie';
$string['submissionstatus_draft'] = 'Pracovná verzia (neodovzdaná)';
$string['submissionstatusheading'] = 'Stav odovzdávania zadania';
$string['submissionstatus_marked'] = 'Hodnotené';
$string['submissionstatus_new'] = 'Novo odovzdané vypracované zadania';
$string['submissionstatus_reopened'] = 'Znovu otvorené';
$string['submissionstatus_submitted'] = 'Odoslané na hodnotenie';
$string['submissionsummary'] = '{$a->status}. Posledná zmena {$a->timemodified}';
$string['submissionteam'] = 'Skupina';
$string['submissiontypes'] = 'Typy zadaní';
$string['submitaction'] = 'Odoslať';
$string['submitassignment'] = 'Odoslať zadanie';
$string['submitassignment_help'] = 'Ak odošlete toto zadanie, už ho nebudete môcť upravovať.';
$string['submitted'] = 'Zadanie bolo odovzdané';
$string['submittedearly'] = 'Zadanie bolo odovzdané {$a} včas';
$string['submittedlate'] = 'Zadanie bolo odovzdané {$a} po termíne';
$string['submittedlateshort'] = '{$a} neskoro';
$string['subplugintype_assignfeedback'] = 'Zásuvný modul spätnej väzby';
$string['subplugintype_assignfeedback_plural'] = 'Zásuvné moduly spätnej väzby';
$string['subplugintype_assignsubmission'] = 'Zásuvný modul vkladania zadania';
$string['subplugintype_assignsubmission_plural'] = 'Zásuvné moduly vkladania zadania';
$string['teamsubmission'] = 'Študenti odovzdávajú zadanie po skupinách';
$string['teamsubmissiongroupingid'] = 'Zoskupenia pre študentské skupiny';
$string['teamsubmission_help'] = 'Ak je povolené, študenti budú rozdelení do skupín podľa aktuálnych skupín alebo zoskupení. Skupinové zadanie je zdieľané medzi členmi skupiny a všetci jej členovia budú vidieť zmeny od každého.';
$string['teamsubmissionstatus'] = 'Stav skupinového odovzdávania';
$string['textinstructions'] = 'Inštrukcie k zadaniu';
$string['timemodified'] = 'Naposledy upravované';
$string['timeremaining'] = 'Ostáva';
$string['unlimitedattempts'] = 'Bez obmedzenia';
$string['unlimitedattemptsallowed'] = 'Počet pokusov nie je obmedzený';
$string['unlocksubmissionforstudent'] = 'Povoliť odovzdanie študentom: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Odomknúť odovzdané zadania';
$string['updategrade'] = 'Aktualizovať hodnotenie';
$string['updatetable'] = 'Uložiť a aktualizovať tabuľku';
$string['upgradenotimplemented'] = 'Aktualizácia nie je implementovaná pre zásuvný modul ({$a->type} {$a->subtype})';
$string['userextensiondate'] = 'Predĺženie bolo poskytnuté do: {$a}';
$string['usergrade'] = 'Známka používateľa';
$string['userswhoneedtosubmit'] = 'Používatelia, ktorí potrebujú odovzdať zadanie: {$a}';
$string['validmarkingworkflowstates'] = 'Platné stavy postupu známkovania';
$string['viewfeedback'] = 'Zobraziť komentár';
$string['viewfeedbackforuser'] = 'Zobraziť komentár pre používateľa {$a}';
$string['viewfull'] = 'Kompletné zobrazenie';
$string['viewfullgradingpage'] = 'Otvoriť stránku so všetkými údajmi k hodnoteniu a pre poskytnutie komentárov';
$string['viewgradebook'] = 'Zobraziť známky';
$string['viewgrading'] = 'Zobraziť/hodnotiť všetky odovzdané zadania';
$string['viewgradingformforstudent'] = 'Zobraziť známky študenta: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Zobraziť stránku s vlastním odovzdaným zadaním';
$string['viewownsubmissionstatus'] = 'Zobraziť stránku so stavom vlastného odovzdaného zadania.';
$string['viewrevealidentitiesconfirm'] = 'Zobraziť stránku s potvrdením odhalenej identity študentov.';
$string['viewsubmission'] = 'Zobraziť odovzdané zadania';
$string['viewsubmissionforuser'] = 'Zobraziť odovzdané zadania používateľe: {$a}';
$string['viewsubmissiongradingtable'] = 'Zobraziť tabuľku hodnotenia odovzdaných zadaní.';
$string['viewsummary'] = 'Zobraziť prehľad';
$string['workflowfilter'] = 'Filter postupu';
