<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktivnosti';
$string['addcategory'] = 'Dodaj kategoriju';
$string['addcategoryerror'] = 'Kategoriju nije moguće dodati';
$string['addexceptionerror'] = 'Došlo je do greške prilikom dodavanja izuzetka userid:gradeitem';
$string['addfeedback'] = 'Dodaj povratnu informaciju';
$string['addgradeletter'] = 'Dodaj slovnu ocjenu';
$string['addidnumbers'] = 'Dodaj ID brojeve';
$string['additem'] = 'Dodaj stavku za ocjenjivanje';
$string['addoutcome'] = 'Dodaj ishod učenja';
$string['addoutcomeitem'] = 'Dodaj stavku ishoda učenja';
$string['addscale'] = 'Dodaj skalu';
$string['aggregateextracreditmean'] = 'Srednja vrijednost ocjena (s dodatnim bodovima)';
$string['aggregatemax'] = 'Najviša ocjena';
$string['aggregatemean'] = 'Srednja vrijednost ocjena';
$string['aggregatemedian'] = 'Srednja vrijednost ocjena';
$string['aggregatemin'] = 'Najniža ocjena';
$string['aggregatemode'] = 'Najčešća ocjena';
$string['aggregateonlygraded'] = 'Zbroji samo upisane ocjene';
$string['aggregateonlygraded_help'] = 'Prazno polje je ono u koje još nije upisana ocjena. Npr. ocjena za zadaću koja još nije predana ili test koji još nije riješen i sl. Ova postavka određuje hoće li se prazna polja isključiti iz izračuna ocjena ili će se za njih uzeti najmanja ocjena koju je moguće dobiti sukladno postavkama te aktivnosti. (npr. ako se zadaća ocjenjuje bodovima od 0 do 100 u izračun će se staviti 0 bodova).';
$string['aggregateoutcomes'] = 'Uključi ishode učenja u izračun';
$string['aggregateoutcomes_help'] = 'Ako su omogućeni, ishodi učenja su obuhvaćeni izračunom. Ovo može prouzročiti neočekivanu ukupnu ocjenu za kolegij.';
$string['aggregatesonly'] = 'Samo zbrojeni podaci';
$string['aggregatesubcats'] = 'Zbroji podatke uključujući potkategorije';
$string['aggregatesubcats_help'] = 'Ova postavka određuje koriste li se podaci iz potkategorija u zbrajanju.';
$string['aggregatesum'] = 'Zbroj ocjena';
$string['aggregateweightedmean'] = 'Ponderirana srednja vrijednost ocjena';
$string['aggregateweightedmean2'] = 'Jednostavna ponderirana srednja vrijednost ocjena';
$string['aggregation'] = 'Izračun';
$string['aggregationcoef'] = 'Koeficijent izračuna';
$string['aggregationcoefextra'] = 'Dodatni bodovi';
$string['aggregationcoefextra_help'] = 'Ako je odabran način izračuna Zbroj ocjena ili Jednostavna ponderirana vrijednost i obuhvaćeni su dodatni bodovi, najveća ocjena za tu stavku neće biti dodana ukupnoj ocjeni za pripadajuću kategoriju zbog mogućeg postizanja (ili prekoračenja) najveće ocjene u kategoriji bez da su postignuti takvi rezultati i u ostalim stavkama koje se ocjenjuju.

Ako je način izračuna postavljen na Srednju vrijednost ( sa dodatnim bodovima) i dodatni bodovi su veći od nula, dodatni bodovi postaju faktor kojim se ocjena množi prije nego se pribroji ukupnoj ocjeni nakon izračuna srednje vrijednosti.';
$string['aggregationcoefextrasum'] = 'Dodatni bodovi';
$string['aggregationcoefextrasum_help'] = 'Ako su omogućeni dodatni bodovi, najveća ocjena za stavku neće se dodati najvećoj ocjeni za kategoriju kako ne bi došlo do postizanja (ili prekoračenja) najveće ocjene za kategoriju bez da su i ostale stavke koje se ocjenjujuju ocijenjene najvećom ocjenom.';
$string['aggregationcoefextraweight'] = 'Vrijednost dodatnih bodova';
$string['aggregationcoefextraweight_help'] = 'Ako je ponder dodatnih bodova veći od nula, ocjena će se računati kao dodatni bodovi u ukupnom izračunu.
Broj je faktor kojim će se ocjena množiti prije dodavanja u konačni izračun srednje vrijednosti.';
$string['aggregationcoefweight'] = 'Vrijednost stavke';
$string['aggregationcoefweight_help'] = 'Ponder stavke koja se ocjenjuje predstavlja važnost i udio te stavke  u izračunu za kategoriju u odnosu na druge stavke koje se ocjenjuju.';
$string['aggregation_help'] = 'Način izračuna određuje kako će se ocjene u pojedinoj kategoriji spojiti, a mogući su načini:
* Srednja vrijednost ocjena - Zbroj svih ocjena podijeljen brojem ocjena obuhvaćenih izračunom
* Srednja ocjena u nizu - Srednja ocjena u rasponu od najveće do najmanje ocjene
* Najniža ocjena
* Najviša ocjena
* Najčešća ocjena - Ocjena koja se najčešće pojavljuje
* Zbroj ocjena - Zbroj svih vrijednosti neovisno o skali';
$string['aggregationposition'] = 'Položaj zbroja';
$string['aggregationposition_help'] = 'Ova postavka određuje hoće li se stupci sa ukupnim ocjenama za kategorije i kolegij biti prikazani na početku ili na kraju prikaza svih ocjena. ';
$string['aggregationsvisible'] = 'Dostupne vrste izračuna';
$string['aggregationsvisiblehelp'] = 'Izaberite vrste zbrajanja koje bi trebale biti dostupne. Držite CTRL za izbor više stavki.';
$string['allgrades'] = 'Sve ocjene po kategorijama';
$string['allstudents'] = 'Svi studenti';
$string['allusers'] = 'Svi korisnici';
$string['autosort'] = 'Automatsko razvrstavanje';
$string['availableidnumbers'] = 'Dostupni ID brojevi';
$string['average'] = 'Prosjek';
$string['averagesdecimalpoints'] = 'Broj decimala u stupcu sa srednjim ocjenama';
$string['averagesdecimalpoints_help'] = 'Ova postavka određuje broj decimalnih mjesta koji će biti prikazan za svaki prosjek ili u slučajevima kada se koristi prikaz decimalnih mjesta za kategoriju ocjena. ';
$string['averagesdisplaytype'] = 'Vrsta prikaza stupac srednjih ocjena';
$string['averagesdisplaytype_help'] = 'Ova postavka određuje hoće li se prosjek prikazati kao broj, postotak ili slovo, ili će se koristiti postavka za prikaz ocjene za cijelu kategoriju.';
$string['backupwithoutgradebook'] = 'Backup ne sadrži postavke Ocjena';
$string['badgrade'] = 'Upisana ocjena nije ispravna';
$string['badlyformattedscale'] = 'Unesite listu vrijednosti odvojenih zarezom (potrebne su najmanje dvije vrijednosti).';
$string['baduser'] = 'Navedeni korisnik nije ispravan';
$string['bonuspoints'] = 'Dodatni bodovi';
$string['bulkcheckboxes'] = 'Bulk polja za označivanje';
$string['calculatedgrade'] = 'Izračunata ocjena';
$string['calculation'] = 'Izračun';
$string['calculationadd'] = 'Dodaj izračun';
$string['calculationedit'] = 'Uredi izračun';
$string['calculation_help'] = 'Za izračun ocjena koristi se formula koja počinje znakom jednakosti (=) i može sadržavati uobičajene matematičke operatore, kao što su max, min i zbroj. Stavke za ocjenjivanje mogu biti obuhvaćene izračunom upisivanjem njihovog ID broja u dvostrukim uglatim zagradama.';
$string['calculationsaved'] = 'Izračun spremljen';
$string['calculationview'] = 'Pregledaj izračun';
$string['cannotaccessgroup'] = 'Nemate prava pristupa ocjenama odabrane skupine.';
$string['categories'] = 'Kategorije';
$string['categoriesanditems'] = 'Kategorije i stavke';
$string['categoriesedit'] = 'Uredi kategorije i stavke';
$string['category'] = 'Kategorija';
$string['categoryedit'] = 'Uredi kategoriju';
$string['categoryname'] = 'Naziv kategorije';
$string['categorytotal'] = 'Ukupna ocjena kolegija';
$string['categorytotalfull'] = '{$a->category} ukupno';
$string['categorytotalname'] = 'Naziv ukupne ocjene kolegija';
$string['changedefaults'] = 'Promijeni zadane postavke';
$string['changereportdefaults'] = 'Promijeni zadane postavke izvještaja';
$string['chooseaction'] = 'Odaberi operaciju...';
$string['choosecategory'] = 'Odaberite kategoriju';
$string['combo'] = 'Tabovi i padajući izbornici';
$string['compact'] = 'Sažeto';
$string['componentcontrolsvisibility'] = 'Određuju li postavke aktivnosti vidljivost ove ocjene.';
$string['contract'] = 'Smanji kategoriju';
$string['controls'] = 'Kontrole';
$string['courseavg'] = 'Prosjek kolegija';
$string['coursegradecategory'] = 'Kategorija ocjena kolegija';
$string['coursegradedisplaytype'] = 'Vrsta prikaza ocjena kolegija';
$string['coursegradedisplayupdated'] = 'Vrsta prikaza ocjena kolegija je osvježena.';
$string['coursegradesettings'] = 'Postavke ocjena kolegija';
$string['coursename'] = 'Naziv kolegija';
$string['coursescales'] = 'Skale kolegija';
$string['coursesettings'] = 'Postavke kolegija';
$string['coursesettingsexplanation'] = 'Postavke kolegija određuju način na koji će se ocjene prikazivati sudionicima.';
$string['coursetotal'] = 'Ukupna ocjena za kolegij';
$string['createcategory'] = 'Stvori kategoriju';
$string['createcategoryerror'] = 'Nije moguće stvoriti novu kategoriju';
$string['creatinggradebooksettings'] = 'Postavke za izradu prikaza ocjena';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Trenutno nadređeno agregiranje';
$string['curveto'] = 'Prilagodi na';
$string['decimalpoints'] = 'Broj decimala';
$string['decimalpoints_help'] = 'Ova postavka određuje broj decimalnih mjesta koja će se prikazati za svaku ocjenu. Nema utjecaja na izračun ocjena koji se radi s pet decimala.';
$string['default'] = 'Zadano';
$string['defaultprev'] = 'Zadano ({$a})';
$string['deletecategory'] = 'Izbriši kategoriju';
$string['disablegradehistory'] = 'Onemogući povijest ocjena';
$string['disablegradehistory_help'] = 'Isključi zapisivanje promjena u tablicima koje se odnose na ocjene. Ovo može u manjoj mjeri ubrzati rad servera i sačuvati prostor u bazi podataka.';
$string['displaylettergrade'] = 'Prikaži slovne ocjene';
$string['displaypercent'] = 'Prikaži postotke';
$string['displaypoints'] = 'Prikaži bodove';
$string['displayweighted'] = 'Prikaži ponderirane ocjene';
$string['dropdown'] = 'Padajući izbornik';
$string['droplow'] = 'Zanemari najniže';
$string['droplowestvalue'] = 'Postavi vrijednost za zanemarivanje najniže ocjene';
$string['droplow_help'] = 'Ova postavka omogućuje određivanje broja najnižih ocjena koje neće ući u izračun.';
$string['dropped'] = 'Zanemareno';
$string['dropxlowest'] = 'Zanemari X najnižih';
$string['dropxlowestwarning'] = 'Napomena: Ako koristite zanemarite X najnižih, ocjenjivanje pretpostavlja da sve stavke unutar kategorije imaju istu vrijednost bodova. Ukoliko je broj bodova različit, rezultati će biti nepredvidivi';
$string['duplicatescale'] = 'Dupliraj skalu';
$string['edit'] = 'Uredi';
$string['editcalculation'] = 'Uredi izračun';
$string['editcalculationverbose'] = 'Uredi izračun za {$a->category}{$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Uredi povratnu informaciju';
$string['editgrade'] = 'Uredi ocjenu';
$string['editgradeletters'] = 'Uredi slovne ocjene';
$string['editoutcome'] = 'Uredi ishod učenja';
$string['editoutcomes'] = 'Uredi ishode učenja';
$string['editscale'] = 'Uredi skalu';
$string['edittree'] = 'Kategorije i stavke';
$string['editverbose'] = 'Uredi {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Omogući AJAX';
$string['enableajax_help'] = 'Dodaje AJAX funkcionalnosti izvještaju o ocjenama, pojednostavljući i ubrzavajući uobičajene operacije. Ovisi o postavkama uključivanja JavaScripta na razini korisnikovog preglednika.';
$string['enableoutcomes'] = 'Omogući ishode učenja';
$string['enableoutcomes_help'] = 'Podrška za ishode učenja (tj. kompetencije, ciljeve, standarde ili kriterije) znači da se aktivnosti mogu ocjenjivati uporabom jedne ili više skala povezanih s ishodima učenja. Uporaba ishoda učenja omogućava takvo posebno ocjenjivanje na razini cijelog sustava.';
$string['encoding'] = 'Kodna stranica';
$string['errorcalculationnoequal'] = 'Formula mora započinjati znakom jednakosti (=1+2)';
$string['errorcalculationunknown'] = 'Neispravna formula';
$string['errorgradevaluenonnumeric'] = 'Dobivena ne-numerička vrijednost visoke ili niske ocjene za ';
$string['errornocalculationallowed'] = 'Izračuni nisu dopušteni za ovu stavku';
$string['errornocategorisedid'] = 'Nije moguće dohvatiti nekategorizirani ID!';
$string['errornocourse'] = 'Nije moguće dohvatiti informacije kolegija';
$string['errorreprintheadersnonnumeric'] = 'Dobivena ne-numerička vrijednost za ponovni ispis zaglavlja';
$string['errorsavegrade'] = 'Nije moguće spremiti ocjenu.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Greška osvježavanja "Zbroji samo upisane ocjene" postavke za kategoriju ocjena ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Greška osvježavanja "Uključi ishode učenja u agregiranje" postavke za kategoriju ocjena ID {$a->id}';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'Greška osvježavanja "Zbroji podatke uključujući podkategorije" postavke za kategoriju ocjena ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Greška osvježavanja vrste agregiranja za kategoriju ocjena ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Greška prilikom osvježavanja koeficijenta izračuna (težina ili dodatni bodovi) stavke koja se ocjenjuje ID {$a->id}';
$string['excluded'] = 'Onemogućeni';
$string['excluded_help'] = 'Ako je omogućeno, ocjena neće biti obuhvaćena niti u jedan izračun.';
$string['expand'] = 'Proširi kategoriju';
$string['export'] = 'Izvoz';
$string['exportalloutcomes'] = 'Izvezi sve ishode učenja';
$string['exportfeedback'] = 'Izvezi i povratnu informaciju';
$string['exportonlyactive'] = 'Zahtijevaj aktivni upis';
$string['exportonlyactive_help'] = 'U izvoz uključi samo studente koji nemaju suspendirani upis na kolegij';
$string['exportplugins'] = 'Izvezi dodatke';
$string['exportsettings'] = 'Izvezi postavke';
$string['exportto'] = 'Izvezi u';
$string['extracreditvalue'] = 'Dodatni bodovi za {$a}';
$string['feedback'] = 'Povratna informacija';
$string['feedbackadd'] = 'Dodaj povratnu informaciju';
$string['feedbackedit'] = 'Uredi povratnu informaciju';
$string['feedbackforgradeitems'] = 'Povratna informacija za {$a}';
$string['feedback_help'] = 'Ovaj okvir omogućava upis komentara o ocjeni.';
$string['feedbacks'] = 'Povratne informacije';
$string['feedbacksaved'] = 'Povratna informacija spremljena';
$string['feedbackview'] = 'Pregledaj povratnu informaciju';
$string['finalgrade'] = 'Završna ocjena';
$string['finalgrade_help'] = 'Ako je omogućena mogućnost poništavanja, ocjena može dodana ili mijenjana.';
$string['fixedstudents'] = 'Statična kolumna studenata';
$string['fixedstudents_help'] = 'Omogućava da se ocjene pregledavaju po stupcima, a da stupac s imenima studenata bude stalno vidljiv postavljajući ga statičnim.';
$string['forceoff'] = 'Obvezno: Isključeno';
$string['forceon'] = 'Obvezno: Uključeno';
$string['forelementtypes'] = 's odabranim(a) {$a}';
$string['forstudents'] = 'Za studente';
$string['full'] = 'Potpuno';
$string['fullmode'] = 'Puni prikaz';
$string['fullview'] = 'Puni prikaz';
$string['generalsettings'] = 'Opće postavke';
$string['grade'] = 'Ocjena';
$string['gradeadministration'] = 'Administracija ocjena';
$string['gradeanalysis'] = 'Analiza ocjena';
$string['gradebook'] = 'Popis ocjena';
$string['gradebookhiddenerror'] = 'Ovaj popis ocjena je postavljen tako da skriva sve podatke od studenata';
$string['gradebookhistories'] = 'Povijest ocjena';
$string['gradeboundary'] = 'Granice slovnih ocjena';
$string['gradeboundary_help'] = 'Ova postavka određuje najmanji postotak nakon kojeg će biti dodijeljena slovna ocjena. ';
$string['gradecategories'] = 'Kategorije ocjena';
$string['gradecategory'] = 'Kategorija ocjena';
$string['gradecategoryonmodform'] = 'Kategorija ocjena';
$string['gradecategoryonmodform_help'] = 'Ova postavka određuje kategoriju unutar popisa ocjena u koju će biti smještene ocjene aktivnosti.';
$string['gradecategorysettings'] = 'Postavke kategorije ocjena';
$string['gradedisplay'] = 'Prikaz ocjena';
$string['gradedisplaytype'] = 'Vrsta prikaza ocjena';
$string['gradedisplaytype_help'] = 'Ova postavka određuje način na koji će ocjene biti prikazane u izvještajima ocjenjivača i korisnika.
* Broj
* Postotak
* Slovo - Slova ili riječi koriste se za prikaz raspona ocjena';
$string['gradedon'] = 'Ocijenjeno: {$a}';
$string['gradeexport'] = 'Izvoz ocjena';
$string['gradeexportcustomprofilefields'] = 'Prilagođena polja profila obuhvaćena u izvozu ocjena';
$string['gradeexportcustomprofilefields_desc'] = 'Obuhvaćanje ovih prilagođenih polja profila u izvozu ocjena, razdvojena zarezima.';
$string['gradeexportdecimalpoints'] = 'Decimalna mjesta pri izvozu ocjena';
$string['gradeexportdecimalpoints_desc'] = 'Broj decimalnih mjesta za prikaz pri izvozu. Može biti promijenjeno prilikom izvoza.';
$string['gradeexportdisplaytype'] = 'Vrsta prikaza izvoza ocjena';
$string['gradeexportdisplaytype_desc'] = 'Ocjene mogu biti prikazane kao cijeli brojevi, kao postotci (u odnosu na najmanje i najveće ocjene) ili kao slova (A, B, C itd.). Može biti promijenjeno prilikom izvoza.';
$string['gradeexportuserprofilefields'] = 'Polja korisničkog profila obuhvaćena u izvozu ocjena';
$string['gradeexportuserprofilefields_desc'] = 'Obuhvatite ova polja korisničkog profila u izvozu ocjena';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradehelp'] = 'Pomoć vezana uz ocjenjivanje';
$string['gradehistorylifetime'] = 'Trajanje povijesti ocjena';
$string['gradehistorylifetime_help'] = 'Ova vrijednost određuje koliko će se dugo čuvati zapisi o promjenama u tablicama povezanim s ocjenjivanjem. Preporučeno je da se zapisi čuvaju što je duže moguće. U slučaju problema sa radom sustava ili ograničenim prostorom baze, postavite neku nižu vrijednost.';
$string['gradeimport'] = 'Uvoz ocjena';
$string['gradeitem'] = 'Stavka ocjena';
$string['gradeitemaddusers'] = 'Izuzmi iz ocjenjivanja';
$string['gradeitemadvanced'] = 'Postavke naprednih stavki ocjenjivanja';
$string['gradeitemadvanced_help'] = 'Odaberite sve elemente koje treba prikazati kao napredne prilikom uređivanja stavki ocjenjivanja.';
$string['gradeitemislocked'] = 'Ova aktivnost je zaključana u popisu ocjena. Promjene na ocjenama u ovoj aktivnosti neće se zapisati u popis ocjena dok se aktivnost ne otključa. ';
$string['gradeitemlocked'] = 'Ocjenjivanje zaključano';
$string['gradeitemmembersselected'] = 'Izuzeto iz ocjenjivanje';
$string['gradeitemnonmembers'] = 'Uključeno u ocjenjivanje';
$string['gradeitemremovemembers'] = 'Uključi u ocjenjivanje';
$string['gradeitems'] = 'Stavke ocjenjivanja';
$string['gradeitemsettings'] = 'Postavke stavki ocjenjivanja';
$string['gradeitemsinc'] = 'Stavke ocjenjivanja za uključiti';
$string['gradeletter'] = 'Slovna ocjena';
$string['gradeletter_help'] = 'Slovne ocjene su slova (A, B, C...) ili riječi (Izvrstan, Dovoljan...) koje se koriste za raspon ocjena.';
$string['gradeletternote'] = 'Da bi izbrisali slovnu ocjenu potrebno je obrisati bilo koje od <br />tri tekstualna polja za to slovo te klinuti na gumb Predaj.';
$string['gradeletters'] = 'Slovne ocjene';
$string['gradelocked'] = 'Ocjena je zaključana';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Najveća ocjena';
$string['grademax_help'] = 'Postavka određuje najveću ocjenu koristeći vrstu vrijednost ocjene. Najveća ocjena za ocjenu za aktivnost se određuje u postavkama te aktivnosti.';
$string['grademin'] = 'Najmanja ocjena';
$string['grademin_help'] = 'Postavka određuje najmanju ocjenu koristeći vrstu vrijednost ocjene.';
$string['gradeoutcomeitem'] = 'Ocijeni stavku ishoda učenja';
$string['gradeoutcomes'] = 'Ishodi učenja';
$string['gradeoutcomescourses'] = 'Ishodi učenja kolegija';
$string['gradepass'] = 'Ocjena za prolaz';
$string['gradepass_help'] = 'Ova postavka određuje najmanju ocjenu potrebnu za prolaz. Vrijednost se upotrebljava za prolaz aktivnosti i kolegija, te u popisu ocjena gdje su prolazne ocjene istaknute zelenom, a neprolazne crvenom bojom.';
$string['gradepreferences'] = 'Postavke ocjene';
$string['gradepreferenceshelp'] = 'Pomoć za Postavka ocjene';
$string['gradepublishing'] = 'Omogući objavljivanje';
$string['gradepublishing_help'] = 'Omogućite objavljivanje u uvozima i izvozima podataka: Izvezenim ocjenama može se pristupiti putem URL adrese, bez obvezne prijave Moodle sustavu. Ocjene se mogu uvesti pristupom navedenoj URL adresi (to znači da se na jednom Moodle sustavu mogu uvesti ocjene s drugog Moodle sustava). Prema zadanim postavkama samo administrator sustava može koristiti ovu mogućnost. Stoga je potrebno educirati korisnike prije nego se ova mogućnost dodijeli nekoj drugoj ulozi jer postoji opasnost od podjele označenih (bookmark) stranica, ograničenja IP adresa, uporabe programa koji ubrzavaju preuzimanje datoteka itd.';
$string['gradereport'] = 'Popis ocjena';
$string['graderreport'] = 'Izvještaj ocjenjivača';
$string['grades'] = 'Ocjene';
$string['gradesforuser'] = 'Ocjene za {$a->user}';
$string['gradesonly'] = 'Samo ocjene';
$string['gradessettings'] = 'Postavke ocjena';
$string['gradetype'] = 'Vrste ocjena';
$string['gradetype_help'] = 'Postoje 4 vrste ocjena: * Ništa - Nije moguće ocjenjivanje * Vrijednost - brojčna vrijednost sa najmanjom i najvećom vrijednošću * Skala - Popis stavki * Tekst - Samo povratna informacija

Samo vrijednosti i skale mogu se koristiti u izračunima. Vrsta ocjena za pojedinu aktivnost određuje se u postavkama te aktivnosti.';
$string['gradeview'] = 'Pogledaj ocjenu';
$string['gradeweighthelp'] = 'Pomoć za ponder ocjena';
$string['groupavg'] = 'Prosjek grupe';
$string['hidden'] = 'Skriveno';
$string['hiddenasdate'] = 'Prikaži datum za skrivene ocjene';
$string['hiddenasdate_help'] = 'Ako studentu nije omogućen uvid u skrivene ocjene, prikaži datum umjesto \'-\'.';
$string['hidden_help'] = 'Ako je omogućeno, ocjene će biti skrivene od studenata. Moguće je postaviti da su skrivene samo do određenog datuma, kako bi se omogućio prikaz ocjena tek kad je završeno ocjenjivanje.';
$string['hiddenuntil'] = 'Skriveno do';
$string['hiddenuntildate'] = 'Skriveno do: {$a}';
$string['hideadvanced'] = 'Skrij napredne postavke';
$string['hideaverages'] = 'Skrij prosjek';
$string['hidecalculations'] = 'Skrij izračune';
$string['hidecategory'] = 'Skriveno';
$string['hideeyecons'] = 'Skrij ikone prikaži/skrij';
$string['hidefeedback'] = 'Skrij povratnu informaciju';
$string['hideforcedsettings'] = 'Skrij obvezne postavke';
$string['hideforcedsettings_help'] = 'Ne prikazuj obvezne postavke u sučelju ocjenjivanja.';
$string['hidegroups'] = 'Skrij grupe';
$string['hidelocks'] = 'Skrij zaključavanja';
$string['hidenooutcomes'] = 'Prikaži ishode učenja';
$string['hidequickfeedback'] = 'Skrij brzu povratnu informaciju';
$string['hideranges'] = 'Skrij raspone';
$string['hidetotalifhiddenitems'] = 'Potpuno skrij ako sadrži skrivene stavke';
$string['hidetotalifhiddenitems_help'] = 'Ova postavka određuje hoće li se ukupna ocjena koja sadrži skrivene stavke biti prikazan studentima ili zamijenjena znakom minusa (-). Ako će biti prikazana, moguće je odrediti hoće li u izračun biti uključene ili isključene skrivene stavke.

Ako su skrivene stavke isključene iz izračuna, ukupna ocjena bit će drugačija od one koju vidi nastavnik u popisu ocjena jer su njemu vidljive i skrivene stavke. Ako su skrivene stavke prikazane, studenti će moći izračunati ocjenu za skrivenu stavku.';
$string['hidetotalshowexhiddenitems'] = 'Prikaži ukupno izuzimajući skrivene stavke';
$string['hidetotalshowinchiddenitems'] = 'Prikaži ukupno uključujući skrivene stavke';
$string['hideverbose'] = 'Skrij {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Presloži rastuće po visini ocjena';
$string['highgradedescending'] = 'Presloži padajuće po visini ocjena';
$string['highgradeletter'] = 'Najviša';
$string['identifier'] = 'Prepoznaj korisnika prema';
$string['idnumbers'] = 'ID brojevi';
$string['import'] = 'Uvezi';
$string['importcsv'] = 'Uvezi CSV';
$string['importcustom'] = 'Uvezi kao prilagođene ishode učenja (samo za ovaj kolegij)';
$string['importerror'] = 'Došlo je do greške jer skripta nije pokrenuta s ispravnim parametrima.';
$string['importfailed'] = 'Uvoz podataka neuspješan. Ništa nije uvezeno.';
$string['importfeedback'] = 'Uvezi povratnu informaciju';
$string['importfile'] = 'Uvezi datoteku';
$string['importfilemissing'] = 'Datoteka nije prihvaćena. Morate se vratiti na obrazac i koristiti ispravnu datoteku.';
$string['importfrom'] = 'Uvezi iz';
$string['importoutcomenofile'] = 'Prenešena datoteka je prazna ili oštećena. Molimo provjerite ispravnost datoteke. Problem je otkriven u redu {$a}; proces je pokrenut zbog redova podataka koji nisu imali jednak broj stupaca kao naslovni red ili su nedostajali naslovi stupaca u uvezenoj datoteci. Potražite primjer ispravnih naslova u uvezenoj datoteci.';
$string['importoutcomes'] = 'Uvezi ishode učenja';
$string['importoutcomes_help'] = 'Ishodi učenja mogu biti uveženi iz CSV datoteke koja ima oblik kao i datoteka za izvoz podataka o ishodima učenja u CSV.';
$string['importoutcomesuccess'] = 'Uvezen ishod "{$a->name}" s ID #{$a->id}';
$string['importplugins'] = 'Uvezi dodatke';
$string['importpreview'] = 'Uvezi prikaz';
$string['importsettings'] = 'Uvezi postavke';
$string['importskippednomanagescale'] = 'Nemate prava za dodavanje nove skale za ocjenjivanje, ishod "{$a}" je izuzet jer zahtijeva izradu nove skale.';
$string['importskippedoutcome'] = 'Ishod s kraticom "{$a}" već postoji u ovom kontekstu, izuzet je uvoz istoga iz datoteke.';
$string['importstandard'] = 'Uvezi kao standardne ishode učenja';
$string['importsuccess'] = 'Uvoz ocjena je uspješan';
$string['importxml'] = 'Uvezi XML';
$string['includescalesinaggregation'] = 'Uključi skale u agregaciju';
$string['includescalesinaggregation_help'] = 'Moguće je promijeniti da se skale za ocjenjivanje uključe kao brojevi u sve izračune u svim popisima ocjena u svim kolegijima. UPOZORENJE: promjena ove postavke uzrokovat će ponovni izračun svih ocjena.';
$string['incorrectcourseid'] = 'ID broj kolegija nije ispravan';
$string['incorrectcustomscale'] = '(Neispravna prilagođena skala, potrebno prmijeniti.)';
$string['incorrectminmax'] = 'Najmanja vrijednost mora biti manja od najveće.';
$string['inherit'] = 'Naslijeđeno';
$string['intersectioninfo'] = 'Student/Ocjena info';
$string['item'] = 'Stavka';
$string['iteminfo'] = 'Informacija o stavci';
$string['iteminfo_help'] = 'Ova postavka omogućava prostor ua unos informacija o stavci. Ove informacije nisu nigdje drugo prikazane.';
$string['itemname'] = 'Naziv stavke';
$string['itemnamehelp'] = 'Naziv stavke dobiven od modula.';
$string['items'] = 'Stavke';
$string['itemsedit'] = 'Uredi element ocjenjivanja';
$string['keephigh'] = 'Zadrži najveće';
$string['keephigh_help'] = 'Ako je upisana neka vrijednost X, samo će X najvećih ocjena biti sačuvano.';
$string['keymanager'] = 'Upravljanje ključevima';
$string['lessthanmin'] = 'Ocjena unešena za {$a->itemname} for {$a->username} je manja od dopuštenog minimuma';
$string['letter'] = 'Slovo';
$string['lettergrade'] = 'Slovna ocjena';
$string['letterpercentage'] = 'Slovo (postotak)';
$string['letterreal'] = 'Slovo (realna vrijednost)';
$string['letters'] = 'Slova';
$string['linkedactivity'] = 'Povezana aktivnost';
$string['linkedactivity_help'] = 'Ova postavka određuje aktivnost s kojom je ishod učenja povezan. Koristi se za procjenu kompetencija studenata koje nisu obuhvaćene u ocjenu za tu aktivnost.';
$string['linktoactivity'] = 'Poveznica na aktivnost {$a->name}';
$string['lock'] = 'Zaključaj';
$string['locked'] = 'Zaključano';
$string['locked_help'] = 'Ako je omogućeno, ocjene se ne mogu automatski osvježavati promjenama u pripadajućoj aktivnosti.';
$string['locktime'] = 'Zaključano nakon';
$string['locktimedate'] = 'Zaključano nakon: {$a}';
$string['lockverbose'] = 'Zakključaj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Najniže';
$string['lowgradeletter'] = 'Najniža';
$string['manualitem'] = 'Ručno unesene stavke';
$string['mapfrom'] = 'Preslikaj iz';
$string['mappings'] = 'Preslikavanje stavki za ocjenjivanje';
$string['mapto'] = 'Preslikaj u';
$string['max'] = 'Najviše';
$string['maxgrade'] = 'Najviša ocjena';
$string['meanall'] = 'Sve ocjene';
$string['meangraded'] = 'Polja sa upisanim ocjenama';
$string['meanselection'] = 'Ocjene odabrane za računanje prosjeka';
$string['meanselection_help'] = 'Ova postavka određuje hoće li polja bez upisanih ocjena biti obuhvaćena u izračun prosjeka za svaku kategoriju odnosno stavku koja se ocjenjuje.';
$string['median'] = 'Sredina';
$string['min'] = 'Najniže';
$string['missingscale'] = 'Skala mora biti odabrana';
$string['mode'] = 'Način';
$string['morethanmax'] = 'Ocjena unešena za  {$a->itemname} for {$a->username} je veća od najviše dopuštene';
$string['moveselectedto'] = 'Premjesti odabrane objekte u';
$string['movingelement'] = 'Premještanje {$a}';
$string['multfactor'] = 'Množitelj';
$string['multfactor_help'] = 'Množitelj je faktor kojim će sve ocjene za ovu stavku biti pomnožene, s najvećom vrijednosti najviše ocjene. Na primjer, ako je množitelj 2, a najveća ocjena je 100, tada će sve ocjene manje od 50 biti pomnožene sa 2, a sve ocjene iznad 50 promijenjene u 100.';
$string['multfactorvalue'] = 'Vrijednost množitelja za {$a}';
$string['mypreferences'] = 'Moje postavke';
$string['myreportpreferences'] = 'Moje postavke izvještaja';
$string['navmethod'] = 'Način navigacije';
$string['neverdeletehistory'] = 'Nikad ne briši zapise';
$string['newcategory'] = 'Nova kategorija';
$string['newitem'] = 'Nova stavka za ocjenjivanje';
$string['newoutcomeitem'] = 'Novi ishod učenja';
$string['no'] = 'Ne';
$string['nocategories'] = 'Kategorije ocjena za ovaj kolegij ne mogu se dodati ili pronaći.';
$string['nocategoryname'] = 'Nema imena kategorije.';
$string['nocategoryview'] = 'Nema kategorije za prikaz';
$string['nocourses'] = 'Nema nijednog kolegija';
$string['noforce'] = 'Ne obvezuj';
$string['nogradeletters'] = 'Slovne ocjene nisu određene';
$string['nogradesreturned'] = 'Nema ocjena';
$string['noidnumber'] = 'Nema ID broja';
$string['nolettergrade'] = 'Nema slovne ocjene za';
$string['nomode'] = 'Nema';
$string['nonnumericweight'] = 'Dobivena ne-numerička vrijednost za';
$string['nonunlockableverbose'] = 'Ocjena ne može biti otključana prije nego se otključa {$a->itemname}.';
$string['nonweightedpct'] = 'ne-ponderirano %';
$string['nooutcome'] = 'Bez ishoda učenja';
$string['nooutcomes'] = 'Stavke ishoda učenja moraju biti povezane s ishodom učenja cijelog kolegija, ali za ovaj kolegij nema upisanih ishoda učenja. Želite li dodati novi ishod učenja?';
$string['nopublish'] = 'Ne objavljivati';
$string['norolesdefined'] = 'Nijedna uloga nije određena u Administracija > Ocjene >Opće postavke > Uloge koje se ocjenjuju';
$string['noscales'] = 'Ishodi učenja moraju biti povezani sa skalom u kolegiju ili sustavu, no trenutno ne postoji niti jedna. Želite dodati novu skalu?';
$string['noselectedcategories'] = 'nijedna kategorija nije odabrana.';
$string['noselecteditems'] = 'nijedna stavka nije odabrana.';
$string['notteachererror'] = 'Morate biti nastavnik kako bi koristili ovu značajku.';
$string['nousersloaded'] = 'Nema učitanih korisnika';
$string['numberofgrades'] = 'Broj ocjena';
$string['onascaleof'] = 'na skali od {$a->grademin} do {$a->grademax}';
$string['operations'] = 'Operacije';
$string['options'] = 'Opcije';
$string['outcome'] = 'Ishod učenja';
$string['outcomeassigntocourse'] = 'Dodijeli drugi ishod učenja ovom kolegiju';
$string['outcomecategory'] = 'Stvori ishode u kategoriji';
$string['outcomecategorynew'] = 'Nova kategorija';
$string['outcomeconfirmdelete'] = 'Želite li izbrisati ishod učenja "{$a}"?';
$string['outcomecreate'] = 'Dodaj novi ishod učenja';
$string['outcomedelete'] = 'Izbriši ishod učenja';
$string['outcomefullname'] = 'Puno ime';
$string['outcome_help'] = 'Ova postavka određuje ishod učenja kojeg će ova ocjena predstavljati u popisu ocjena.';
$string['outcomeitem'] = 'Stavka ishoda učenja';
$string['outcomeitemsedit'] = 'Dodaj novi ishod učenja';
$string['outcomereport'] = 'Izvještaj ishoda učenja';
$string['outcomes'] = 'Ishodi učenja';
$string['outcomescourse'] = 'Ishodi učenja korišteni na kolegiju';
$string['outcomescoursecustom'] = 'Koriste se nestandardni ishodi (ne mogu se ukloniti)';
$string['outcomescoursenotused'] = 'Ne koriste se standardni ishodi';
$string['outcomescourseused'] = 'Koriste se standardni ishodi (ne mogu se ukloniti)';
$string['outcomescustom'] = 'Nestandardni ishodi učenja';
$string['outcomeshortname'] = 'Kratica';
$string['outcomesstandard'] = 'Standardni ishodi učenja';
$string['outcomesstandardavailable'] = 'Raspoloživi standardni ishodi učenja';
$string['outcomestandard'] = 'Standardni ishod učenja';
$string['outcomestandard_help'] = 'Standardni ishod učenja dostupan je u svim kolegijima na sustavu';
$string['overallaverage'] = 'Ukupni prosjek';
$string['overridden'] = 'Poništeno';
$string['overridden_help'] = 'Ako je omogućeno, ocjene unutar te aktivnosti ne mogu se više mijenjati.

Ako se ocjena mijenja u popisu ocjena, okvir za poništavanje se automatski uključuje. Može ga se isključiti i ručno promijeniti ocjenu kroz pripadajuću aktivnost.';
$string['overriddennotice'] = 'Konačna ocjena za ovu aktivnost ručno je podešena.';
$string['overridesitedefaultgradedisplaytype'] = 'Poništi zadane vrijednosti na razini sustava';
$string['overridesitedefaultgradedisplaytype_help'] = 'Ako je oomogućeno, mogu se podešavati slovne ocjene i ograničenja u kolegiju umjesto korištenja zadanih postavki za sustav.';
$string['parentcategory'] = 'Nadređena kategorija';
$string['pctoftotalgrade'] = '% ukupne ocjene';
$string['percent'] = 'Posto';
$string['percentage'] = 'Postotak';
$string['percentageletter'] = 'Postotak (slovo)';
$string['percentagereal'] = 'Postotak (broj)';
$string['percentascending'] = 'Sortiraj po rastućem postotku';
$string['percentdescending'] = 'Sortiraj po silaznom postotku';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Pomak';
$string['plusfactor_help'] = 'Pomak je broj dodan svakoj ocjeni za ovu stavku nakon primjene multiplikatora.';
$string['plusfactorvalue'] = 'Offset vrijednost za {$a}';
$string['points'] = 'bodova';
$string['pointsascending'] = 'Sortiraj po rastućem broju bodova';
$string['pointsdescending'] = 'Sortiraj po silaznom broju bodova';
$string['positionfirst'] = 'Prvi';
$string['positionlast'] = 'Zadnji';
$string['preferences'] = 'Postavke';
$string['prefgeneral'] = 'Opći';
$string['prefletters'] = 'Ocjene i ograničenja';
$string['prefrows'] = 'Posebni redovi';
$string['prefshow'] = 'Izmjena pokaži/skrij';
$string['previewrows'] = 'Pregled redova';
$string['profilereport'] = 'Izvještaj za korisnički profil';
$string['profilereport_help'] = 'Prikaz ocjena korišten na stranici profila korisnika ';
$string['publishing'] = 'Objavljivanje';
$string['quickfeedback'] = 'Brza povratna informacija';
$string['quickgrading'] = 'Brzo ocjenjivanje';
$string['quickgrading_help'] = 'Ako je omogućeno, dok su omogućene izmjene, uz svaku se ocjenu pojavljuje okvir za unos teksta omogućavajući da više ocjena bude uređeno u isto vrijeme. Nakon odabira gumba za spremanje promijenjene ocjene bit će istaknute drugom bojom. Kada se ocjena mijenja u popisu ocjena, uključuje se okvir za poništavanje, te više nije moguće mijenjati ocjenu u pripadajućoj aktivnosti.';
$string['range'] = 'Opseg';
$string['rangedecimals'] = 'Decimalne točke opsega';
$string['rangedecimals_help'] = 'Koliki broj decimalnih točaka opsega treba prikazati.';
$string['rangesdecimalpoints'] = 'Broj decimala prikazan u opsegu';
$string['rangesdecimalpoints_help'] = 'Ova postavka određuje broj decimalnih mjesta koji će se prikazati za svaki raspon ili da se primijene zadane vrijednosti za prikaz u svakoj kategoriji i stavki koja se ocjenjuje. ';
$string['rangesdisplaytype'] = 'Vrsta prikazanog raspona';
$string['rangesdisplaytype_help'] = 'Ova postavka određuje hoće li raspon biti prikazan kao brojevi, postotci ili slova, ili je način prikaza za kategoriju ili stavku već određen (naslijeđen).';
$string['rank'] = 'Rang';
$string['rawpct'] = 'Neobrađeno %';
$string['real'] = 'Vrijednost';
$string['realletter'] = 'Vrijednost (slovo)';
$string['realpercentage'] = 'Vrijednost (postotak)';
$string['recovergradesdefault'] = 'Vrati zadane ocjene';
$string['recovergradesdefault_help'] = 'Zadano vrati stare ocjene kada se korisnik ponovno upisuje na kolegij.';
$string['regradeanyway'] = 'Svejedno ponovno ocijeni ';
$string['removeallcoursegrades'] = 'Izbriši sve ocjene';
$string['removeallcourseitems'] = 'Izbriši sve stavke i kategorije';
$string['report'] = 'Izvještaj';
$string['reportdefault'] = 'Zadani izvještaj ({$a})';
$string['reportplugins'] = 'Dodaci za izradu izvještaja';
$string['reportsettings'] = 'Podešavanje izvještaja';
$string['reprintheaders'] = 'Ponovni ispis zaglavlja';
$string['respectingcurrentdata'] = 'ostavljanje trenutne konfiguracije neizmjenjenom';
$string['rowpreviewnum'] = 'Broj redova za pregled';
$string['savechanges'] = 'Spremi izmjene';
$string['savepreferences'] = 'Spremi postavke';
$string['scaleconfirmdelete'] = 'Želite li izbrisati skalu "{$a}"?';
$string['scaledpct'] = 'Skalirano %';
$string['seeallcoursegrades'] = 'Pogledaj sve ocjene na kolegiju';
$string['select'] = 'Odaberite {$a}';
$string['selectalloroneuser'] = 'Odaberi jednog ili sve korisnike';
$string['selectauser'] = 'Odaberi korisnika';
$string['selectdestination'] = 'Odaberi odredište za {$a}';
$string['separator'] = 'Separator';
$string['sepcolon'] = 'Zarez';
$string['sepcomma'] = 'Zarez';
$string['sepsemicolon'] = 'Točka sa zarezom';
$string['septab'] = 'Tabulator';
$string['setcategories'] = 'Podesi kategorije';
$string['setcategorieserror'] = 'Prvo morate podesiti kategorije na vašem kolegiju kako biste im mogli zadavati pondere.';
$string['setgradeletters'] = 'Podesi slovne ocjene';
$string['setpreferences'] = 'Podesi postavke';
$string['setting'] = 'Postavka';
$string['settings'] = 'Postavke';
$string['setweights'] = 'Podesi težinu';
$string['showactivityicons'] = 'Prikaži ikone aktivnosti';
$string['showactivityicons_help'] = 'Ako je omogućeno, ikona aktivnosti prikazana je pored naziva aktivnosti';
$string['showallhidden'] = 'Prikaži sve skrivene';
$string['showallstudents'] = 'Prikaži sve studente';
$string['showanalysisicon'] = 'Prikaži ikonu za analizu ocjena';
$string['showanalysisicon_desc'] = 'Prikazati zadano ikonu za analizu ocjena. Ako aktivnost to podržava, ikona za analizu ocjena vodi na stranicu s detaljnijim objašnjenjem ocjene i postupka ocjenjivanja.';
$string['showanalysisicon_help'] = 'Ako aktivnost to podržava, ikona za analizu ocjena vodi na stranicu s detaljnijim objašnjenjem ocjene i postupka ocjenjivanja.';
$string['showaverage'] = 'Prikaži prosjek';
$string['showaverage_help'] = 'Prikazati stupac s prosjekom? Studenti mogu pretpostaviti ocjene drugih studenata ako se prosjek računa temeljem manjeg broja ocjena. Zbog brzine izvođenja, prosjek je približan ako ovisi i o skrivenim stavkama.';
$string['showaverages'] = 'Prikaži stupac s prosjekom';
$string['showaverages_help'] = 'Ako je omogućeno, izvještaj ocjenjivača sadržavat će dodatni red s prikazanim prosjekom za svaku kategoriju i svaku stavku koja se ocjenjuje.';
$string['showcalculations'] = 'Prikaži izračun';
$string['showcalculations_help'] = 'Ako je omogućeno dok su omogućene izmjene, ikona kalkulatora prikazuje se uz svaku stavku i kategoriju, s uputama kad se mišem prijeđe preko izračunatih stavki i vizualnim pokazateljem da je stupac izračunat.';
$string['showeyecons'] = 'Prikaži ikone pokaži/skrij';
$string['showeyecons_help'] = 'Ako je omogućeno, prilikom uređivanja ocjena, bit će prikazana ikona prikaži/sakrij pored svake ocjene čime se podešava vidljivost studentima';
$string['showfeedback'] = 'Prikaži povratne informacije';
$string['showfeedback_help'] = 'Prikaži stupac s povratnom informacijom?';
$string['showgrade'] = 'Prikaži ocjene';
$string['showgrade_help'] = 'Prikaži stupac s ocjenama?';
$string['showgroups'] = 'Prikaži grupe';
$string['showhiddenitems'] = 'Prikaži skrivene elemente';
$string['showhiddenitems_help'] = 'Je li skrivena stavka koja se ocjenjuje skrivena u potpunosti ili je naziv te stavke vidljiv studentima.

* Prikaži skriveno - Nazivi skrivenih stavki su prikazani, ali ocjene nisu
* Skrivene do - Stavke su potpuno skrivene do postavljenog datuma nakon čega je stavka vidljiva u potpunosti
* Ne prikazuj - Skrivene stavke koje se ocjenjuju skrivene su u potpunosti';
$string['showhiddenuntilonly'] = 'Skriveno do';
$string['showlettergrade'] = 'Prikaži slovne oznake';
$string['showlettergrade_help'] = 'Prikaži stupac sa slovnim oznakama?';
$string['showlocks'] = 'Prikaži ikone lokota';
$string['showlocks_help'] = 'Ako je omogućeno dok su omogućene izmjene, ikona za zaključavanje/otključavanje ocjena je prikazana. Na ovaj način može se kontrolirati hoće li ocjena automastki biti promijenjena ako se promijeni u pripadajućoj aktivnosti.';
$string['shownohidden'] = 'Bez skrivenih';
$string['shownooutcomes'] = 'Skrij ishode učenja';
$string['shownumberofgrades'] = 'Prikaži broj ocjena u prosjecima';
$string['shownumberofgrades_help'] = 'Ako je omogućeno, broj ocjena upotrijebljenih u izračunu srednje vrijednosti prikazan je u zagradama za svaku srednju vrijednost.';
$string['showpercentage'] = 'Prikaži postotak';
$string['showpercentage_help'] = 'Ova postavka određuje je li prikazana postotna vrijednost svake stavke koja se ocjenjuje.';
$string['showquickfeedback'] = 'Prikaži brzu povratnu informaciju';
$string['showquickfeedback_help'] = 'Ako je omogućeno dok su omogućene izmjene, pored svake ocjene prikazuje se okvir s točkastim rubom za unos povratne informacije kako bi se više ocjena moglo editirati u isto vrijeme. Nakon odabira gumba za spremanje promjene su i vizualno istaknute. Kada se povratna informacija uređuje u popisu ocjena, uključuje se okvir za poništavanje i tada nije moguće mijenjati povratnu informaciju u pripadajućoj aktivnosti.';
$string['showrange'] = 'Prikaži opsege';
$string['showrange_help'] = 'Prikaži stupac s opsezima?';
$string['showranges'] = 'Prikaži raspone';
$string['showranges_help'] = 'Ako je omogućeno, izvještaj ocjenjivača sadržavat će i dodatni red s prikazanim rasponom za svaku kategoriju i svaku stavku koja se ocjenjuje.';
$string['showrank'] = 'Prikaži rang';
$string['showrank_help'] = 'Ova postavka određuje hoće li odnost studenta u odnosu na ostatak polaznika biti prikazan pored svake stavke koja se ocjenjuje.';
$string['showuserimage'] = 'Prikaži profilnu sliku korisnika';
$string['showuserimage_help'] = 'Mogućnost prikaza slike korisnika uz ime izvještaju ocjenjivača';
$string['showverbose'] = 'Prikaži {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Prikaži pondere';
$string['showweight_help'] = 'Prikaži stupac s ponderima?';
$string['simpleview'] = 'Jednostavni prikaz';
$string['sitewide'] = 'Na razini cijelog sustava';
$string['sort'] = 'sortiraj';
$string['sortasc'] = 'Sortiraj uzlaznim redoslijedom';
$string['sortbyfirstname'] = 'Sortiraj po imenu';
$string['sortbylastname'] = 'Sortiraj po prezimenu';
$string['sortdesc'] = 'Sortiraj silaznim redoslijedom';
$string['standarddeviation'] = 'Standardna devijacija';
$string['stats'] = 'Statistika';
$string['statslink'] = 'Statistika';
$string['student'] = 'Student';
$string['studentsperpage'] = 'Broj studenata po stranici';
$string['studentsperpage_help'] = 'Ova mogućnost određuje broj prikazanih studenata na pojedinoj stranici u izvještaju ocjenjivača.';
$string['studentsperpagereduced'] = 'Najveći dopušteni broj studenata po stranici je smanjen s {$a->originalstudentsperpage} na {$a->studentsperpage}. Razmislite o povećanju vrijednosti za PHP postavku max_input_vars iz {$a->maxinputvars}.';
$string['subcategory'] = 'Normalna kategorija';
$string['submissions'] = 'Predano';
$string['submittedon'] = 'Predano: {$a}';
$string['switchtofullview'] = 'Prebaci u puni prikaz';
$string['switchtosimpleview'] = 'Prebaci u jednostavni prikaz';
$string['tabs'] = 'Tabulatori';
$string['topcategory'] = 'Nadkategorija';
$string['total'] = 'Ukupno';
$string['totalweight100'] = 'Ukupni ponder je jednak 100';
$string['totalweightnot100'] = 'Ukupni ponder nije jednak 100';
$string['turnfeedbackoff'] = 'Isključi povratne informacije';
$string['turnfeedbackon'] = 'Uključi povratne informacije';
$string['typenone'] = 'Nema ocjena';
$string['typescale'] = 'Skala';
$string['typescale_help'] = 'Ova mogućnost određuje zadanu skalu prilikom izbora ocjenjivanja pomoću skala.Skala za ocjenu iz aktivnosti podešava se unutar postavki te aktivnosti.';
$string['typetext'] = 'Tekst';
$string['typevalue'] = 'Vrijednost';
$string['uncategorised'] = 'Nekategorizirano';
$string['unchangedgrade'] = 'Ocjena nepromijenjena';
$string['unenrolledusersinimport'] = 'Uvoz podataka uključuje i sljedeće ocjene za korisnike koji trenutno nisu upisani u kolegij: {$a}';
$string['unlimitedgrades'] = 'Ocjene bez graničnih vrijednosti';
$string['unlimitedgrades_help'] = 'Prema zadanim postavkama ocjene su ograničene najvećom i najmanjom vrijednosti stavke koja se ocjenjuje. Omogućavanjem ove postavke uklanja se ograničenje i dopušta da ocjene bez ograničenja budu unesene izravno u popis ocjena. preporuča se da se ova postavka uključuje kada na sustavu nema puno korisnika s obzirom da će biti potrebno ponovno izračunati sve ocjene, a to bi moglo opteretiti poslužitelj.';
$string['unlock'] = 'Otključaj';
$string['unlockverbose'] = 'Otključaj{$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Ne koristi se';
$string['updatedgradesonly'] = 'Izvezi samo nove ili promijenjene ocjene';
$string['uploadgrades'] = 'Prenesi ocjene na sustav';
$string['useadvanced'] = 'Koristi napredne postavke';
$string['usedcourses'] = 'Korišteni kolegiji';
$string['usedgradeitem'] = 'Korištena stavka za ocjenjivanje';
$string['usenooutcome'] = 'Ne koristi ishode učenja';
$string['usenoscale'] = 'Bez skala';
$string['usepercent'] = 'Koristi postotke';
$string['user'] = 'Korisnik';
$string['userenrolmentsuspended'] = 'Upis korisnika je onemogućen';
$string['usergrade'] = 'Korisnik {$a->fullname} ({$a->useridnumber}) za stavku {$a->gradeidnumber}';
$string['userid'] = 'ID korisnika';
$string['userpreferences'] = 'Korisničke postavke';
$string['useweighted'] = 'Koristi ponderirane vrijednosti';
$string['verbosescales'] = 'Detaljne skale';
$string['viewbygroup'] = 'Skupina';
$string['viewgrades'] = 'Vidi ocjene';
$string['warningexcludedsum'] = 'Upozorenje: isključivanje ocjena nije sukladno zbirnom izračunu ';
$string['weight'] = 'ponder';
$string['weightcourse'] = 'Koristi ponderirane ocjene za ovaj kolegij';
$string['weightedascending'] = 'Poredaj po ponderiranom postotku uzlazno';
$string['weighteddescending'] = 'Poredaj po ponderiranom postotku silazno';
$string['weightedpct'] = 'ponderirani %';
$string['weightedpctcontribution'] = 'ponderirani % doprinos';
$string['weightorextracredit'] = 'Ponder ili dodatni bodovi';
$string['weights'] = 'Ponderi';
$string['weightsedit'] = 'Dodaj ponder ili dodatne bodove';
$string['weightuc'] = 'Ponder';
$string['writinggradebookinfo'] = 'Zapisivanje postavki popisa ocjena';
$string['xml'] = 'XML';
$string['yes'] = 'Da';
$string['yourgrade'] = 'Vaša ocjena';
