<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_ldap', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   enrol_ldap
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignrole'] = 'Dodjeljivanje uloge \'{$a->role_shortname}\' korisniku \'{$a->user_username}\' u kolegiju \'{$a->course_shortname}\' (id {$a->course_id})';
$string['assignrolefailed'] = 'Neuspješno dodjeljivanje uloge \'{$a->role_shortname}\' korisniku \'{$a->user_username}\' na kolegiju \'{$a->course_shortname}\' (id {$a->course_id})';
$string['autocreate'] = '<p>Kolegije možete stvarati automatski ako postoji informacija o upisanim kolegijima koji još ne postoje u Moodle-u.</p><p>Ako koristite automatsko stvaranje kolegija, preporučljivo je da prije toga uklonite ove sposobnosti iz uloga: moodle/course:changeidnumber, moodle/course:changeshortname, moodle/course:changefullname and moodle/course:changesummary (kako bi spriječili izmjene 4 polja kolegija koja su navedena gore (ID broj, kratica, naziv kolegija i sažetak).</p>';
$string['autocreate_key'] = 'Automatsko stvaranje';
$string['autocreation_settings'] = 'Postavke automatskog stvaranja kolegija';
$string['bind_dn'] = 'Ako želite koristiti bind korisnika za pretraživanje korisnika, navedite to ovdje. Nešto poput \'cn=ldapuser,ou=public,o=org\'';
$string['bind_dn_key'] = 'DN bind korisnika';
$string['bind_pw'] = 'Lozinka bind-korisnika.';
$string['bind_pw_key'] = 'Lozinka';
$string['bind_settings'] = 'Bind postavke';
$string['cannotcreatecourse'] = 'Nije moguće stvoriti kolegij: nedostaju potrebi podaci u LDAP zapisu!';
$string['category'] = 'Kategorija u kojoj će biti smješteni automatski stvoreni kolegiji';
$string['category_key'] = 'Kategorija';
$string['contexts'] = 'LDAP konteksti';
$string['couldnotfinduser'] = 'Nije bilo moguće pronaći korisnika \'{$a}\', preskačem';
$string['course_fullname'] = 'Opcionalno: LDAP atribut iz kojeg će biti preuzeto puni naziv kolegija';
$string['course_fullname_key'] = 'Puno ime';
$string['course_idnumber'] = 'LDAP atribut iz kojeg će biti preuzet ID broj kolegija. Obično \'cn\' ili \'uid\'.';
$string['course_idnumber_key'] = 'ID broj';
$string['coursenotexistskip'] = 'Kolegij \'{$a}\' ne postoji, a automatsko stvaranje kolegija je isključeno, preskače se';
$string['course_search_sub'] = 'Traži članstvo u grupama u podkontekstima';
$string['course_search_sub_key'] = 'Traži u podkontekstima';
$string['course_settings'] = 'Postavke upisa na kolegij';
$string['course_shortname'] = 'Opcionalno: LDAP atribut iz kojeg će biti preuzeta kratica kolegija';
$string['course_shortname_key'] = 'Kratica';
$string['course_summary'] = 'Opcionalno: LDAP atribut iz kojeg će biti preuzet sažetak kolegija';
$string['course_summary_key'] = 'Sažetak';
$string['createcourseextid'] = 'STVORI korisnika upisanog u nepostojeći kolegij \'{$a->courseextid}\'';
$string['createnotcourseextid'] = 'Korisnik je upisan u nepostojeći kolegij \'{$a->courseextid}\'';
$string['creatingcourse'] = 'Stvaranje kolegija \'{$a}\'...';
$string['editlock'] = 'Zaključaj vrijednost';
$string['emptyenrolment'] = 'Prazno polje za ulogu \'{$a->role_shortname}\' u kolegiju \'{$a->course_shortname}\'';
$string['enrolname'] = 'LDAP';
$string['enroluser'] = 'Upiši korisnika \'{$a->user_username}\' u kolegij \'{$a->course_shortname}\' (id {$a->course_id})';
$string['enroluserenable'] = 'Omogućen upis korisnika \'{$a->user_username}\' u kolegij \'{$a->course_shortname}\' (id {$a->course_id})';
$string['explodegroupusertypenotsupported'] = 'ldap_explode_group() ne podržava odabranu vrstu korisnika: {$a}';
$string['extcourseidinvalid'] = 'Vanjski ID kolegija nije valjan!';
$string['extremovedsuspend'] = 'Onemogućen upis korisnika \'{$a->user_username}\' u kolegij \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedsuspendnoroles'] = 'Onemogućen upis korisnika i uklonjene uloge za korisnika \'{$a->user_username}\' u kolegiju \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedunenrol'] = 'Ispiši korisnika \'{$a->user_username}\' iz kolegija \'{$a->course_shortname}\' (id {$a->course_id})';
$string['failed'] = 'Neuspješno!';
$string['general_options'] = 'Opće postavke';
$string['group_memberofattribute'] = 'Naziv atributa koji određuje kojoj grupi pripada određeni korisnik ili grupa (npr. memberOf, groupMembership i slično)';
$string['group_memberofattribute_key'] = 'Atribut "Član grupe"';
$string['host_url'] = 'Navedite naziv LDAP poslužitelja u obliku URL-a, npr. \'ldap://ldap.domena.hr/\' or \'ldaps://ldap.domena.hr/\'';
$string['host_url_key'] = 'URL poslužitelja';
$string['idnumber_attribute'] = 'Ako članstvo u grupi sadrži razlikovna imena, zadajte isti atribut koji ste zadali za mapiranje korisničkog \'ID broja\' u postavkama LDAP autentikacije';
$string['idnumber_attribute_key'] = 'Atribut ID broj';
$string['ldap_encoding'] = 'Navedite kodnu stranicu koju koristi vaš LDAP poslužitelj. Obično je to utf-8, dok MS AD v2 ovično koristi cp1252, cp1250 i slične.';
$string['ldap_encoding_key'] = 'Kodna stranica LDAP-a';
$string['ldap:manage'] = 'Uredi LDAP instance upisa';
$string['memberattribute'] = 'LDAP atribut člana';
$string['memberattribute_isdn'] = 'Ako članstvo u grupi sadrži DN, morate to ovdje zadati. Ako je to točno, morate također podesiti i postavke koje slijede.';
$string['memberattribute_isdn_key'] = 'Atribut člana koristi DN';
$string['nested_groups'] = 'Želite li koristiti ugniježđene grupe (grupe koje sadrže druge grupe) za upis?';
$string['nested_groups_key'] = 'Ugniježđene grupe';
$string['nested_groups_settings'] = 'Postavke ugniježđenih grupa';
$string['nosuchrole'] = 'Nema takve uloge: \'{$a}\'';
$string['objectclass'] = 'objectClass koja se koristi za traženje kolegija. Obično \'posixGroup\'.';
$string['objectclass_key'] = 'Razred objekta';
$string['ok'] = 'OK!';
$string['opt_deref'] = 'Ako članstvo u grupi sadrži DN, odredite kako će se rukovati s aliasima pri traženju. Odaberite jednu od slijedećih vrijednosti: \'Ne\' (LDAP_DEREF_NEVER) ili \'Da\' (LDAP_DEREF_ALWAYS)';
$string['opt_deref_key'] = 'Dereferencirajući aliasi';
$string['phpldap_noextension'] = '<em>PHP LDAP modul izgleda nije prisutan na vašem poslužitelju. Molimo provjerite je li instaliran i omogućen ako želite koristiti ovaj dodatak za upis.</em>';
$string['pluginname'] = 'LDAP upisi';
$string['pluginname_desc'] = '<p>Možete koristiti LDAP poslužitelj kako bi nadzirali upis. Pretpostavljeno je da vaša LDAP hijerarhija sadržava grupe koje se preslikavaju na kolegije, i da svaka od tih grupa/kolegija ima zapise o članstvu preslikane na studente.</p> <p>Pretpostavlja se da su kolegiji zadani kao grupe u LDAP-u, pri čemu svaka grupa ima višestruka polja za članstvo (<em>member</em> or <em>memberUid</em>) koja sadržavaju uniqueidentification korisnika.</p><p>Kako bi koristili LDAP upis, vaši korisnici <strong>moraju</strong> imati važeće polje idnumber. LDAP grupe moraju sadržavati taj idnumber u poljima članstva kako bi korisnik mogao biti upisan u kolegij. Ovo će uobičajeno raditi ako već otprije koristite LDAP autentikaciju.</p><p>Upisi će biti osvježeni kad se korisnik prijavi na Moodle. Možete također pokrenuti skriptu kako bi sinkronizirali podatke o upisu. Ista se nalazi na <em>enrol/ldap/cli/sync.php</em>.</p><p>Ovaj dodatak također može automatski stvarati nove kolegije kad se nove grupe pojave u LDAP-u.</p>';
$string['pluginnotenabled'] = 'Dodatak nije omogućen!';
$string['role_mapping'] = '<p>Za svaku ulogu koju želite dodijeliti iz LDAP-a, morate navesti popis konteksta u kojima se nalaze grupe kolegija za tu ulogu. Odvojite različite kontekste s \';\'</p><p>Također trebate odrediti atribut koji vaš LDAP poslužitelj koristi za pohranu članova grupe. Obično \'member\' ili \'memberUid\'.</p>';
$string['role_mapping_attribute'] = 'Korisnički LDAP atributi za {$a}';
$string['role_mapping_context'] = 'LDAP konteksti za {$a}';
$string['role_mapping_key'] = 'Prenesi uloge iz LDAP-a';
$string['roles'] = 'Mapiranje uloga';
$string['server_settings'] = 'Postavke LDAP poslužitelja';
$string['synccourserole'] = '== Sinkroniziranje kolegija \'{$a->idnumber}\' za ulogu \'{$a->role_shortname}\'';
$string['template'] = 'Opcionalno: automatski stvoreni kolegiji mogu kopirati svoje postavke iz predloška za kolegije';
$string['template_key'] = 'Predložak';
$string['unassignrole'] = 'Neuspješno uklanjanje uloge \'{$a->role_shortname}\' korisniku \'{$a->user_username}\' s kolegija \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignrolefailed'] = 'Nije moguće ukloniti ulogu \'{$a->role_shortname}\' za korisnika \'{$a->user_username}\' na kolegiju \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignroleid'] = 'Uklanjanje ID uloge \'{$a->role_id}\' korisniku koji ima ID \'{$a->user_id}\'';
$string['updatelocal'] = 'Nadogradi lokalne podatke';
$string['user_attribute'] = 'Ako članstvo u grupi sadrži DN, odredite koji se atribut koristi pri imenovanju/traženju korisnika. Ako koristite LDAP autentikaciju, ova vrijednost bi se trebala podudarati s atributom zadanim u \'ID broj\' mapiranju u LDAP autentikacijskom dodatku';
$string['user_attribute_key'] = 'Atribut ID broja';
$string['user_contexts'] = 'Ako članstvo u grupi sadrži DN, odredite u kojim se kontekstima traže korisnici. Odvojite višestruke kontekste s \';\'. Npr: \'ou=korisnici,o=org; ou=ostali,o=org\'';
$string['user_contexts_key'] = 'Konteksti';
$string['user_search_sub'] = 'Ako atribut članstva u grupi sadržava razlikovna imena, odredite traže li se korisnici i u podkontekstima';
$string['user_search_sub_key'] = 'Pretraži kontekste';
$string['user_settings'] = 'Postavke pretraživanja korisnika';
$string['user_type'] = 'Ako atribut članstva u grupi sadržava razlikovna imena, odredite kako se korisnici pohranjuju u LDAP';
$string['user_type_key'] = 'Vrsta korisnika';
$string['version'] = 'Inačica protokola LDAP koju koristi vaš poslužitelj.';
$string['version_key'] = 'Inačica';
