<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adresa';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Umetni/uredi sidro';
$string['advanced:backcolor_desc'] = 'Odaberite boju pozadine';
$string['advanced:block'] = 'Oblik';
$string['advanced:blockquote'] = 'Citat';
$string['advanced:blockquote_desc'] = 'Citiraj';
$string['advanced:bold_desc'] = 'Podebljaj (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Neuređena lista';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Umetni posebni znak';
$string['advanced:cleanup_desc'] = 'Počisti kod';
$string['advanced:clipboard_msg'] = 'Kopiraj/Izreži/Zalijepi nije dostupno u Mozilla i Firefox preglednicima. Više informacija?';
$string['advanced:code'] = 'Kod';
$string['advanced:code_desc'] = 'Uredi HTML izvorni kôd';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopiraj';
$string['advanced:custom1_desc'] = 'Vlastiti opis ovdje';
$string['advanced:cut_desc'] = 'Izreži';
$string['advanced:dd'] = 'Opis definicije';
$string['advanced:div'] = 'DIV';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Autor';
$string['advanced_dlg:about_general'] = 'O programu';
$string['advanced_dlg:about_help'] = 'Pomoć';
$string['advanced_dlg:about_license'] = 'Licenca';
$string['advanced_dlg:about_loaded'] = 'Postojeći dodaci';
$string['advanced_dlg:about_plugin'] = 'Dodatak';
$string['advanced_dlg:about_plugins'] = 'Dodaci';
$string['advanced_dlg:about_title'] = 'TinyMCE';
$string['advanced_dlg:about_version'] = 'Inačica';
$string['advanced_dlg:accessibility_help'] = 'Pomoć za pristupačnost';
$string['advanced_dlg:accessibility_usage_title'] = 'Općenita uporaba';
$string['advanced_dlg:anchor_invalid'] = 'Molimo, navedite ispravan naziv sidra';
$string['advanced_dlg:anchor_name'] = 'Naziv sidra';
$string['advanced_dlg:anchor_title'] = 'Umetni/uredi sidro';
$string['advanced_dlg:charmap_title'] = 'Odaberite znak';
$string['advanced_dlg:charmap_usage'] = 'Za navigaciju koristite strelice lijevo i desno.';
$string['advanced_dlg:code_title'] = 'HTML uređivač';
$string['advanced_dlg:code_wordwrap'] = 'Omatanje teksta';
$string['advanced_dlg:colorpicker_color'] = 'Boja:';
$string['advanced_dlg:colorpicker_name'] = 'Naziv:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Imenovano';
$string['advanced_dlg:colorpicker_named_title'] = 'Imenovane boje';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paleta';
$string['advanced_dlg:colorpicker_palette_title'] = 'Paleta boja';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Odabir';
$string['advanced_dlg:colorpicker_picker_title'] = 'Odabir boje';
$string['advanced_dlg:colorpicker_title'] = 'Odabir boje';
$string['advanced_dlg:image_align'] = 'Poravnavanje';
$string['advanced_dlg:image_align_baseline'] = 'Osnovna linija';
$string['advanced_dlg:image_align_bottom'] = 'Dno';
$string['advanced_dlg:image_align_left'] = 'Lijevo';
$string['advanced_dlg:image_align_middle'] = 'Sredina';
$string['advanced_dlg:image_align_right'] = 'Desno';
$string['advanced_dlg:image_align_textbottom'] = 'Dno teksta';
$string['advanced_dlg:image_align_texttop'] = 'Vrh teksta';
$string['advanced_dlg:image_align_top'] = 'Vrh';
$string['advanced_dlg:image_alt'] = 'Opis slike';
$string['advanced_dlg:image_border'] = 'Obrub';
$string['advanced_dlg:image_dimensions'] = 'Dimenzije';
$string['advanced_dlg:image_hspace'] = 'Vodoravni razmak';
$string['advanced_dlg:image_list'] = 'Lista slika';
$string['advanced_dlg:image_src'] = 'URL slike';
$string['advanced_dlg:image_title'] = 'Umetni/uredi sliku';
$string['advanced_dlg:image_vspace'] = 'Okomiti razmak';
$string['advanced_dlg:invalid_color_value'] = 'Neispravna vrijednost za boju';
$string['advanced_dlg:link_is_email'] = 'URL koji ste unijeli izgleda kao adresa e-pošte, želite li dodati potrebni mailto: prefiks?';
$string['advanced_dlg:link_is_external'] = 'URL koji ste unijeli izgleda kao vanjska poveznica, želite li dodati potrebni http:// prefiks?';
$string['advanced_dlg:link_list'] = 'Lista poveznica';
$string['advanced_dlg:link_target'] = 'Meta';
$string['advanced_dlg:link_target_blank'] = 'Otvori poveznicu u novom prozoru';
$string['advanced_dlg:link_target_same'] = 'Otvori poveznicu u istom prozoru';
$string['advanced_dlg:link_title'] = 'Umetni/uredi poveznicu';
$string['advanced_dlg:link_titlefield'] = 'Naslov';
$string['advanced_dlg:link_url'] = 'URL poveznice';
$string['advanced:dt'] = 'Definicija pojma';
$string['advanced:fontdefault'] = 'Vrsta pisma';
$string['advanced:font_size'] = 'Veličina pisma';
$string['advanced:forecolor_desc'] = 'Odaberite boju teksta';
$string['advanced:h1'] = 'Naslov 1';
$string['advanced:h2'] = 'Naslov 2';
$string['advanced:h3'] = 'Naslov 3';
$string['advanced:h4'] = 'Naslov 4';
$string['advanced:h5'] = 'Naslov 5';
$string['advanced:h6'] = 'Naslov 6';
$string['advanced:help_desc'] = 'Pomoć';
$string['advanced:help_shortcut'] = 'Pritisni ALT-F10 za traku s alatima. Pritisni ALT-0 za pomoć';
$string['advanced:hr_desc'] = 'Umetni vodoravnu crtu';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Umetni/uredi sliku';
$string['advanced:image_props_desc'] = 'Svojstva slike';
$string['advanced:indent_desc'] = 'Izvuci';
$string['advanced:italic_desc'] = 'Kurziv (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Centriraj';
$string['advanced:justifyfull_desc'] = 'Poravnaj potpuno';
$string['advanced:justifyleft_desc'] = 'Poravnaj lijevo';
$string['advanced:justifyright_desc'] = 'Poravnaj desno';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Umetni/uredi poveznicu';
$string['advanced:more_colors'] = 'Više boja...';
$string['advanced:newdocument'] = 'Želite li uistinu izbrisati cijeli sadržaj?';
$string['advanced:newdocument_desc'] = 'Novi dokument';
$string['advanced:numlist_desc'] = 'Uređena lista';
$string['advanced:outdent_desc'] = 'Uvuci';
$string['advanced:paragraph'] = 'Paragraf';
$string['advanced:paste_desc'] = 'Zalijepi';
$string['advanced:path'] = 'Staza';
$string['advanced:pre'] = 'Oblikovano';
$string['advanced:redo_desc'] = 'Ponovi (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Poništi oblikovanje';
$string['advanced:rich_text_area'] = 'Polje oblikovanog teksta';
$string['advanced:samp'] = 'Primjer koda';
$string['advanced:shortcuts_desc'] = 'Pomoć za pristupačnost';
$string['advanced:striketrough_desc'] = 'Precrtaj';
$string['advanced:style_select'] = 'Stilovi';
$string['advanced:sub_desc'] = 'Indeks';
$string['advanced:sup_desc'] = 'Eksponent';
$string['advanced:toolbar'] = 'Alatna traka';
$string['advanced:toolbar_focus'] = 'Prijeđi na alatnu traku - Alt+Q, prijeđi na uređivač - Alt-Z, prijeđi na element path - Alt-X';
$string['advanced:underline_desc'] = 'Podcrtaj (Ctrl+U)';
$string['advanced:undo_desc'] = 'Poništi (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Poništi poveznicu';
$string['advanced:visualaid_desc'] = 'Prikaži/skrij vodilice/nevidljive elemente';
$string['advhr:advhr_desc'] = 'Vodoravna crta';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'Bez sjene';
$string['advhr_dlg:size'] = 'Visina';
$string['advhr_dlg:width'] = 'Širina';
$string['advhr_dlg:widthunits'] = 'Jedinice';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage_dlg:align'] = 'Poravnavanje';
$string['advimage_dlg:align_baseline'] = 'Osnovna linija';
$string['advimage_dlg:align_bottom'] = 'Dno';
$string['advimage_dlg:align_left'] = 'Lijevo';
$string['advimage_dlg:align_middle'] = 'Sredina';
$string['advimage_dlg:align_right'] = 'Desno';
$string['advimage_dlg:align_textbottom'] = 'Dno teksta';
$string['advimage_dlg:align_texttop'] = 'Vrh teksta';
$string['advimage_dlg:align_top'] = 'Vrh';
$string['advimage_dlg:alt'] = 'Opis slike';
$string['advimage_dlg:alt_image'] = 'Alternativna slika';
$string['advimage_dlg:border'] = 'Obrub';
$string['advimage_dlg:classes'] = 'Klase';
$string['advimage_dlg:constrain_proportions'] = 'Zadrži proporcije';
$string['advimage_dlg:dialog_title'] = 'Umetni/uredi sliku';
$string['advimage_dlg:dimensions'] = 'Dimenzije';
$string['advimage_dlg:example_img'] = 'Prikaz slike';
$string['advimage_dlg:general'] = 'Osnovno';
$string['advimage_dlg:height'] = 'Visina';
$string['advimage_dlg:hspace'] = 'Vodoravni razmak';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Lista slika';
$string['advimage_dlg:langcode'] = 'Kod jezika';
$string['advimage_dlg:langdir'] = 'Smjer jezika';
$string['advimage_dlg:list'] = 'Lista slika';
$string['advimage_dlg:long_desc'] = 'Poveznica dugog opisa';
$string['advimage_dlg:ltr'] = 'S lijeva na desno';
$string['advimage_dlg:map'] = 'Karta slike';
$string['advimage_dlg:misc'] = 'Razno';
$string['advimage_dlg:missing_alt'] = 'Jeste li sigurni da želite izostaviti opis slike? Slika može biti nedostupna ljudima s poteškoćama ili onima koji koriste preglednike bez prikaza slika.';
$string['advimage_dlg:mouseout'] = 'za izlazak miša van slike';
$string['advimage_dlg:mouseover'] = 'za prelazak miša preko slike';
$string['advimage_dlg:preview'] = 'Prikaz';
$string['advimage_dlg:rtl'] = 'S desna na lijevo';
$string['advimage_dlg:src'] = 'URL slike';
$string['advimage_dlg:style'] = 'Stil';
$string['advimage_dlg:swap_image'] = 'Izmjenjiva slika';
$string['advimage_dlg:tab_advanced'] = 'Napredno';
$string['advimage_dlg:tab_appearance'] = 'Izgled';
$string['advimage_dlg:tab_general'] = 'Osnovno';
$string['advimage_dlg:title'] = 'Naslov';
$string['advimage_dlg:vspace'] = 'Okomiti razmak';
$string['advimage_dlg:width'] = 'Širina';
$string['advimage:image_desc'] = 'Umetni/uredi sliku';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink_dlg:accesskey'] = 'Accesskey';
$string['advlink_dlg:advanced_props'] = 'Napredna svojstva';
$string['advlink_dlg:advanced_tab'] = 'Napredno';
$string['advlink_dlg:anchor_names'] = 'Sidra';
$string['advlink_dlg:classes'] = 'Klasa';
$string['advlink_dlg:encoding'] = 'Kodiranje znakova';
$string['advlink_dlg:event_props'] = 'Događaji';
$string['advlink_dlg:events_tab'] = 'Događaj';
$string['advlink_dlg:general_props'] = 'Osnovna svojstva';
$string['advlink_dlg:general_tab'] = 'Osnovno';
$string['advlink_dlg:height'] = 'Visina';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'URL koji ste unijeli izgleda kao adresa e-pošte, želite li dodati potrebni mailto: prefiks?';
$string['advlink_dlg:is_external'] = 'URL koji ste unijeli izgleda kao vanjska poveznica, želite li dodati potrebni http:// prefiks?';
$string['advlink_dlg:langcode'] = 'Kod jezika';
$string['advlink_dlg:langdir'] = 'Smjer jezika';
$string['advlink_dlg:link_list'] = 'Lista poveznica';
$string['advlink_dlg:list'] = 'Lista poveznica';
$string['advlink_dlg:ltr'] = 'S lijeva na desno';
$string['advlink_dlg:mime'] = 'MIME tip';
$string['advlink_dlg:popup'] = 'Javascript popup';
$string['advlink_dlg:popup_dependent'] = 'Ovisan (samo za Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Pokaži traku lokacije';
$string['advlink_dlg:popup_menubar'] = 'Pokaži izbornik';
$string['advlink_dlg:popup_name'] = 'Ime prozora';
$string['advlink_dlg:popup_opts'] = 'Opcije';
$string['advlink_dlg:popup_position'] = 'Pozicija (X/Y)';
$string['advlink_dlg:popup_props'] = 'Svojstva popup prozora';
$string['advlink_dlg:popup_resizable'] = 'Prozor promjenjive veličine';
$string['advlink_dlg:popup_return'] = 'Umetni \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Pokaži klizače';
$string['advlink_dlg:popup_size'] = 'Veličina';
$string['advlink_dlg:popup_statusbar'] = 'Pokaži statusnu traku';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Pokaži alatne trake';
$string['advlink_dlg:popup_url'] = 'Popup URL';
$string['advlink_dlg:rel'] = 'Odnos stranice prema meti';
$string['advlink_dlg:rev'] = 'Odnos mete prema stranici';
$string['advlink_dlg:rtl'] = 'S desna na lijevo';
$string['advlink_dlg:style'] = 'Stil';
$string['advlink_dlg:tabindex'] = 'Tabindex';
$string['advlink_dlg:target'] = 'Meta';
$string['advlink_dlg:target_blank'] = 'Otvori u novom prozoru';
$string['advlink_dlg:target_langcode'] = 'Jezik';
$string['advlink_dlg:target_name'] = 'Ime mete';
$string['advlink_dlg:target_parent'] = 'Otvori u izvornom prozoru / okvir';
$string['advlink_dlg:target_same'] = 'Otvori u novom prozoru / okviru';
$string['advlink_dlg:target_top'] = 'Otvori u gornjem okviru (zamjenjuje sve okvire)';
$string['advlink_dlg:title'] = 'Umetni/uredi poveznicu';
$string['advlink_dlg:titlefield'] = 'Naslov';
$string['advlink_dlg:url'] = 'URL poveznice';
$string['advlink_dlg:width'] = 'Širina';
$string['advlink:link_desc'] = 'Umetni/uredi poveznicu';
$string['advlist:circle'] = 'Kružić';
$string['advlist:def'] = 'Zadano';
$string['advlist:disc'] = 'Disc';
$string['advlist:lower_alpha'] = 'Lower alpha';
$string['advlist:lower_greek'] = 'Lower greek';
$string['advlist:lower_roman'] = 'Lower roman';
$string['advlist:square'] = 'Kvadrat';
$string['advlist:types'] = 'Types';
$string['advlist:upper_alpha'] = 'Velika slova abecede';
$string['advlist:upper_roman'] = 'Rimski brojevi velikim slovima';
$string['aria:rich_text_area'] = 'Polje oblikovanog teksta';
$string['autosave:restore_content'] = 'Vrati automatski pohranjeni tekst';
$string['autosave:unload_msg'] = 'Promjene će biti izgubljene ako odete s ove stranice.';
$string['autosave:warning_message'] = 'Ako vratite već pohranjeni sadržaj, izgubit ćete sav sadržaj kojeg trenutno uređujete.

Jeste li sigurni da želite vratiti pohranjeni sadržaj?';
$string['availablebuttons'] = 'Dostupni gumbi';
$string['colors:000000'] = 'Crna';
$string['colors:000080'] = 'Tamno plava';
$string['colors:0000FF'] = 'Plava';
$string['colors:003300'] = 'Tamnozelena';
$string['colors:003366'] = 'Tamnoplavo';
$string['colors:008000'] = 'Zelena';
$string['colors:008080'] = 'Plavozelena';
$string['colors:00CCFF'] = 'Nebesko plava';
$string['colors:00FF00'] = 'Limeta';
$string['colors:00FFFF'] = 'Akva';
$string['colors:333300'] = 'Tamna maslinasta';
$string['colors:333333'] = 'Jako tamnosiva';
$string['colors:333399'] = 'Indigo';
$string['colors:3366FF'] = 'Kraljevski plava';
$string['colors:339966'] = 'Morski zelena';
$string['colors:33CCCC'] = 'Tirkizna';
$string['colors:666699'] = 'Sivo-plava';
$string['colors:800000'] = 'Kestenjasta';
$string['colors:800080'] = 'Ljubičasta';
$string['colors:808000'] = 'Maslinasta';
$string['colors:808080'] = 'Siva';
$string['colors:993300'] = 'Tamno narančasta';
$string['colors:993366'] = 'Smeđa';
$string['colors:999999'] = 'Srednje siva';
$string['colors:99CC00'] = 'Žuto-zelena';
$string['colors:99CCFF'] = 'Nebeskoplava svijetla';
$string['colors:C0C0C0'] = 'Srebrna';
$string['colors:CC99FF'] = 'Tamnoljubičasta';
$string['colors:CCFFCC'] = 'Svjetlo-zelena';
$string['colors:CCFFFF'] = 'Svjetloplavozelena';
$string['colors:FF0000'] = 'Crvena';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Narančasta';
$string['colors:FF9900'] = 'Jantarna';
$string['colors:FF99CC'] = 'Roza';
$string['colors:FFCC00'] = 'Zlatna';
$string['colors:FFCC99'] = 'Breskva';
$string['colors:FFFF00'] = 'Žuta';
$string['colors:FFFF99'] = 'Svjetložuta';
$string['colors:FFFFFF'] = 'Bijela';
$string['common:apply'] = 'Primijeni';
$string['common:browse'] = 'Pregled';
$string['common:cancel'] = 'Odustanite';
$string['common:class_name'] = 'Klasa';
$string['common:clipboard_msg'] = 'Kopiraj/Izreži/Zalijepi nije dostupno u Mozilla i Firefox preglednicima.
Više informacija?';
$string['common:clipboard_no_support'] = 'Trenutačno vaš preglednik ne podržava ovu opciju, pokušajte koristiti tipkovničku kraticu.';
$string['common:close'] = 'Zatvori';
$string['common:edit_confirm'] = 'Želite li koristiti WYSIWYG način rada za ovo tekstualno polje?';
$string['common:insert'] = 'Umetni';
$string['common:invalid_data'] = 'Greška: Unešene su nevaljane vrijednosti, označene su crvenom bojom.';
$string['common:invalid_data_min'] = '{#field} mora biti broj veći od {#min}';
$string['common:invalid_data_number'] = '{#field} mora biti broj';
$string['common:invalid_data_size'] = '{#field} mora biti broj ili postotak';
$string['common:more_colors'] = 'Više boja';
$string['common:not_set'] = '-- Nije postavljeno --';
$string['common:popup_blocked'] = 'Oprostite, izgleda da je vaš popup-blocker onemogućio prozor u sklopu ovog programa. Morate onemogućiti blokiranje popup prozora da bi u potpunosti iskoristili ovaj alat.';
$string['common:update'] = 'Obnovi';
$string['common:value'] = '(vrijednost)';
$string['contextmenu:align'] = 'Poravnavanje';
$string['contextmenu:center'] = 'Sredina';
$string['contextmenu:full'] = 'Puno';
$string['contextmenu:left'] = 'Lijevo';
$string['contextmenu:right'] = 'Desno';
$string['customconfig'] = 'Prilagođene postavke';
$string['customconfig_desc'] = 'Prilagođena napredna TinyMCE konfiguracija u JSON obliku, npr. {"opcija 1" : "vrijednost 1", "opcija 2" : "vrijednost 2"}. Sve postavke navedene ovdje će nadjačati standardne i postavke dodataka.';
$string['customtoolbar'] = 'Traka s alatima';
$string['customtoolbar_desc'] = 'Svaki red sadrži popis zarezima odvojenih gumba, pri čemu se znak "|" koristi kao separator grupa, a prazne linije se ignoriraju. Pogledajte <a href="{$a}" target="_blank">{$a}</a> za cijeli popis zadanih TinyMCE gumba.';
$string['directionality:ltr_desc'] = 'S lijeva na desno';
$string['directionality:rtl_desc'] = 'S desna na lijevo';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Plač';
$string['emotions_dlg:desc'] = 'Emocije';
$string['emotions_dlg:embarassed'] = 'Sramim se';
$string['emotions_dlg:foot_in_mouth'] = 'Izlanuo se';
$string['emotions_dlg:frown'] = 'Mršti se';
$string['emotions_dlg:innocent'] = 'Nevinašce';
$string['emotions_dlg:kiss'] = 'Poljubac';
$string['emotions_dlg:laughing'] = 'Smijeh';
$string['emotions_dlg:money_mouth'] = 'Bogataš';
$string['emotions_dlg:sealed'] = 'Šutim';
$string['emotions_dlg:smile'] = 'Osmijeh';
$string['emotions_dlg:surprised'] = 'Iznenađen';
$string['emotions_dlg:title'] = 'Umetni emociju';
$string['emotions_dlg:tongue_out'] = 'Belji se';
$string['emotions_dlg:undecided'] = 'Neodlučan';
$string['emotions_dlg:usage'] = 'Koristite lijevu i desnu strelicu za navigaciju.';
$string['emotions_dlg:wink'] = 'Namigiva';
$string['emotions_dlg:yell'] = 'Viče';
$string['emotions:emotions_desc'] = 'Emocije';
$string['fontselectlist'] = 'Popis dostupnih fontova';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Svojstva dokumenta';
$string['fullpage_dlg:active_color'] = 'Boja aktivne poveznice';
$string['fullpage_dlg:add'] = 'Dodaj novi element';
$string['fullpage_dlg:add_base'] = 'Osnovni element';
$string['fullpage_dlg:add_comment'] = 'Komentar';
$string['fullpage_dlg:add_link'] = 'Element poveznice';
$string['fullpage_dlg:add_meta'] = 'Meta element';
$string['fullpage_dlg:add_script'] = 'Skriptni element';
$string['fullpage_dlg:add_style'] = 'Sitlski element';
$string['fullpage_dlg:add_title'] = 'Naslovni element';
$string['fullpage_dlg:advanced_props'] = 'Napredno';
$string['fullpage_dlg:advanced_tab'] = 'Napredno';
$string['fullpage_dlg:appearance_bgprops'] = 'Svojstva pozadine';
$string['fullpage_dlg:appearance_linkprops'] = 'Boja poveznica';
$string['fullpage_dlg:appearance_marginprops'] = 'Margina';
$string['fullpage_dlg:appearance_style'] = 'CSS i svojstva stila';
$string['fullpage_dlg:appearance_tab'] = 'Izgled';
$string['fullpage_dlg:appearance_textprops'] = 'Svojstva teksta';
$string['fullpage_dlg:author'] = 'Autor';
$string['fullpage_dlg:base_element'] = 'Osnovni element';
$string['fullpage_dlg:bgcolor'] = 'Boja pozadine';
$string['fullpage_dlg:bgimage'] = 'Pozadinska slika';
$string['fullpage_dlg:bottom_margin'] = 'Donja margina';
$string['fullpage_dlg:charset'] = 'Charset';
$string['fullpage_dlg:comment_element'] = 'Komentar';
$string['fullpage_dlg:content'] = 'Sadržaj';
$string['fullpage_dlg:copyright'] = 'Autorska prava';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Kodiranje znakova';
$string['fullpage_dlg:fontface'] = 'Skupina pisama';
$string['fullpage_dlg:font_face'] = 'Pismo';
$string['fullpage_dlg:fontsize'] = 'Veličina pisma';
$string['fullpage_dlg:font_size'] = 'Veličina pisma';
$string['fullpage_dlg:general_props'] = 'Osnovno';
$string['fullpage_dlg:head_elements'] = 'Zaglavni elementi';
$string['fullpage_dlg:hover_color'] = 'Boja poveznice ispod miša';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Informacije';
$string['fullpage_dlg:langcode'] = 'Kod jezika';
$string['fullpage_dlg:langdir'] = 'Smjer jezika';
$string['fullpage_dlg:langprops'] = 'Jezik i kodiranje';
$string['fullpage_dlg:language'] = 'Jezik';
$string['fullpage_dlg:left_margin'] = 'Lijeva margina';
$string['fullpage_dlg:link_color'] = 'Boja poveznice';
$string['fullpage_dlg:link_element'] = 'Element poveznice';
$string['fullpage_dlg:ltr'] = 'S lijeva na desno';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Opis';
$string['fullpage_dlg:meta_element'] = 'Meta element';
$string['fullpage_dlg:meta_index_follow'] = 'Indeksiraj i slijedi poveznice';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indeksiraj i ne slijedi poveznice';
$string['fullpage_dlg:meta_keywords'] = 'Ključne riječi';
$string['fullpage_dlg:meta_noindex_follow'] = 'Ne indeksiraj i slijedi poveznice';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Ne indeksiraj i ne slijedi poveznice';
$string['fullpage_dlg:meta_props'] = 'Meta informacije';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'Osnovno';
$string['fullpage_dlg:meta_title'] = 'Naslov';
$string['fullpage_dlg:movedown'] = 'Pomakni odabrani element prema dolje';
$string['fullpage_dlg:moveup'] = 'Pomakni odabrani element prema gore';
$string['fullpage_dlg:name'] = 'Ime';
$string['fullpage_dlg:properties'] = 'Svojstva';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Ukloni odabrani element';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Desna margina';
$string['fullpage_dlg:rtl'] = 'S desna na lijevo';
$string['fullpage_dlg:script_element'] = 'Skriptni element';
$string['fullpage_dlg:src'] = 'Src';
$string['fullpage_dlg:style'] = 'Stil';
$string['fullpage_dlg:style_element'] = 'Stilski element';
$string['fullpage_dlg:stylesheet'] = 'CSS';
$string['fullpage_dlg:target'] = 'Meta';
$string['fullpage_dlg:textcolor'] = 'Boja';
$string['fullpage_dlg:text_color'] = 'Boja teksta';
$string['fullpage_dlg:title'] = 'Svojstva dokumenta';
$string['fullpage_dlg:title_element'] = 'Naslovni element';
$string['fullpage_dlg:top_margin'] = 'Gornja margina';
$string['fullpage_dlg:type'] = 'Type';
$string['fullpage_dlg:value'] = 'Vrijednost';
$string['fullpage_dlg:visited_color'] = 'Boja posjećene poveznice';
$string['fullpage_dlg:xml_pi'] = 'XML deklaracija';
$string['fullscreen:desc'] = 'Uključi/isključi prikaz preko cijelog ekrana';
$string['iespell:download'] = 'Provjera pravopisa nije postaljena. Postaviti sada?';
$string['iespell:iespell_desc'] = 'Pokreni provjeru pravopisa';
$string['insertdatetime:date_fmt'] = '%d.%m.%Y.';
$string['insertdatetime:day_long'] = 'nedjelja,ponedjeljak,utorak,srijeda,četvrtak,petak,subota,nedjelja';
$string['insertdatetime:day_short'] = 'ned,pon,uto,sri,čet,pet,sub,ned';
$string['insertdatetime:insertdate_desc'] = 'Umetni datum';
$string['insertdatetime:inserttime_desc'] = 'Umetni vrijeme';
$string['insertdatetime:months_long'] = 'siječanj,veljača,ožujak,travanj,svibanj,lipanj,srpanj,kolovoz,rujan,listopad,studeni,prosinac';
$string['insertdatetime:months_short'] = 'sij,velj,ožu,tra,svi,lip,srp,kol,ruj,lis,stu,pro';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Uključi/isključi apsolutno pozicioniranje';
$string['layer:backward_desc'] = 'Pomakni natrag';
$string['layer:content'] = 'Novi sloj...';
$string['layer:forward_desc'] = 'Pomakni naprijed';
$string['layer:insertlayer_desc'] = 'Umetni novi sloj';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Umetni/uredi ugrađenu medijsku datoteku';
$string['media_dlg:advanced'] = 'Advanced';
$string['media_dlg:align'] = 'Align';
$string['media_dlg:align_bottom'] = 'Bottom';
$string['media_dlg:align_bottom_left'] = 'Bottom left';
$string['media_dlg:align_bottom_right'] = 'Bottom right';
$string['media_dlg:align_center'] = 'Center';
$string['media_dlg:align_left'] = 'Left';
$string['media_dlg:align_right'] = 'Right';
$string['media_dlg:align_top'] = 'Top';
$string['media_dlg:align_top_left'] = 'Top left';
$string['media_dlg:align_top_right'] = 'Top right';
$string['media_dlg:altsource1'] = 'Alternativni izvor 1';
$string['media_dlg:altsource2'] = 'Alternativni izvor 2';
$string['media_dlg:audio'] = 'HTML5 zvuk';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Auto start';
$string['media_dlg:balance'] = 'Balance';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'Base URL';
$string['media_dlg:bgcolor'] = 'Background';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'Captioning ID';
$string['media_dlg:center'] = 'Center';
$string['media_dlg:class_name'] = 'Class';
$string['media_dlg:console'] = 'Console';
$string['media_dlg:constrain_proportions'] = 'Constrain proportions';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Controls';
$string['media_dlg:correction'] = 'Bez korekcije';
$string['media_dlg:currentmarker'] = 'Trenutna oznaka';
$string['media_dlg:currentposition'] = 'Trenutna pozicija';
$string['media_dlg:defaultframe'] = 'Default frame';
$string['media_dlg:embeddedaudio'] = 'Ugrađeni zvuk';
$string['media_dlg:embedded_audio_options'] = 'Postavke za ugrađeni zvuk';
$string['media_dlg:enabled'] = 'Omogućeno';
$string['media_dlg:enablejavascript'] = 'Omogući JavaScript';
$string['media_dlg:endtime'] = 'Vrijeme završetka';
$string['media_dlg:file'] = 'Datoteka/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Postavke za flash';
$string['media_dlg:flashvars'] = 'Flash vars';
$string['media_dlg:fullscreen'] = 'Preko cijelog ekrana';
$string['media_dlg:general'] = 'General';
$string['media_dlg:hidden'] = 'Hidden';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'H-Space';
$string['media_dlg:html5_audio_options'] = 'Postavke zvuka';
$string['media_dlg:html5_video_options'] = 'Postavke HTML5 videa';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Image status';
$string['media_dlg:invokeurls'] = 'Invoke URLs';
$string['media_dlg:kioskmode'] = 'Kiosk mode';
$string['media_dlg:list'] = 'List';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Loop';
$string['media_dlg:maintainaspect'] = 'Maintain aspect';
$string['media_dlg:menu'] = 'Show menu';
$string['media_dlg:mute'] = 'Mute';
$string['media_dlg:name'] = 'Name';
$string['media_dlg:nojava'] = 'No Java';
$string['media_dlg:numloop'] = 'Num loops';
$string['media_dlg:play'] = 'Auto play';
$string['media_dlg:playcount'] = 'Play count';
$string['media_dlg:playeveryframe'] = 'Play every frame';
$string['media_dlg:poster'] = 'Poster';
$string['media_dlg:prefetch'] = 'Prefetch';
$string['media_dlg:preload'] = 'Prethodno učitavanje';
$string['media_dlg:preload_auto'] = 'Ostavite odabir korisničkom web pregledniku';
$string['media_dlg:preload_metadata'] = 'Prethodno učitavanje video meta-podataka';
$string['media_dlg:preload_none'] = 'Bez prethodnog učitavanja video meta-podataka';
$string['media_dlg:preview'] = 'Pregled';
$string['media_dlg:progress'] = 'Progress';
$string['media_dlg:qt_options'] = 'Quicktime postavke';
$string['media_dlg:qtsrc'] = 'QT Src';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:qt_stream_warn'] = 'RTSP resurse treba dodati u QT polje izvora u okviru kartice Napredno. Trebate dodati i ne-stream inačicu u polje izvora.';
$string['media_dlg:quality'] = 'Kvaliteta';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Real media player postavke';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Skala';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Postavke za Shockwave';
$string['media_dlg:shuffle'] = 'Shuffle';
$string['media_dlg:size'] = 'Dimenzije';
$string['media_dlg:sound'] = 'Sound';
$string['media_dlg:source'] = 'Izvor';
$string['media_dlg:starttime'] = 'Vrijeme početka';
$string['media_dlg:stretchtofit'] = 'Stretch to fit';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Align';
$string['media_dlg:swstretchstyle'] = 'Način razvlačenja';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Align';
$string['media_dlg:target'] = 'Cilj';
$string['media_dlg:targetcache'] = 'Target cache';
$string['media_dlg:title'] = 'Umetni / uredi ugrađenu medijsku datoteku';
$string['media_dlg:type'] = 'Vrste';
$string['media_dlg:uimode'] = 'UI način';
$string['media_dlg:video'] = 'HTML5 video';
$string['media_dlg:volume'] = 'Volume';
$string['media_dlg:vspace'] = 'V-Space';
$string['media_dlg:windowlessvideo'] = 'Windowless video';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Windows media player postavke';
$string['media:edit'] = 'Edit embedded media';
$string['nonbreaking:nonbreaking_desc'] = 'Umetni razmak';
$string['pagebreak:desc'] = 'Umetni prijelom';
$string['paste_dlg:text_linebreaks'] = 'Zadrži prijelome';
$string['paste_dlg:text_title'] = 'Koristite CTRL+V na tipkovnici kako bi zalijepili tekst u prozor.';
$string['paste_dlg:word_title'] = 'Koristite CTRL+V na tipkovnici kako bi zalijepili tekst u prozor.';
$string['paste:paste_text_desc'] = 'Zalijepi kao obični tekst';
$string['paste:paste_word_desc'] = 'Zalijepi iz Worda';
$string['paste:plaintext_mode'] = '';
$string['paste:selectall_desc'] = 'Odaberi sve';
$string['pluginname'] = 'TinyMCE HTML uređivač';
$string['preview:preview_desc'] = 'Prikaz';
$string['print:print_desc'] = 'Ispis';
$string['save:cancel_desc'] = 'Odustani od svih promjena';
$string['save:save_desc'] = 'Spremi';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace_dlg:allreplaced'] = 'Sva pojavljivanja traženog teksta su zamijenjena.';
$string['searchreplace_dlg:direction'] = 'Smjer';
$string['searchreplace_dlg:down'] = 'Dolje';
$string['searchreplace_dlg:findnext'] = 'Pronađi sljedeće';
$string['searchreplace_dlg:findwhat'] = 'Pronađi tekst';
$string['searchreplace_dlg:mcase'] = 'Match case';
$string['searchreplace_dlg:notfound'] = 'Pretraživanje je završeno. Traženi tekst nije pronađen.';
$string['searchreplace_dlg:replace'] = 'Zamijeni';
$string['searchreplace_dlg:replaceall'] = 'Zamijeni sve';
$string['searchreplace_dlg:replace_title'] = 'Pronađi/Zamijeni';
$string['searchreplace_dlg:replacewith'] = 'Zamijeni sa';
$string['searchreplace_dlg:searchnext_desc'] = 'Pronađi opet';
$string['searchreplace_dlg:search_title'] = 'Pronađi';
$string['searchreplace_dlg:up'] = 'Gore';
$string['searchreplace:replace_desc'] = 'Pronađi/Zamijeni';
$string['searchreplace:search_desc'] = 'Pronađi';
$string['settings'] = 'Opće postavke';
$string['simple:bold_desc'] = 'Podebljaj (Ctrl+B)';
$string['simple:bullist_desc'] = 'Popis s natuknicama';
$string['simple:cleanup_desc'] = 'Počisti kod';
$string['simple:italic_desc'] = 'Kurziv (Ctrl+I)';
$string['simple:numlist_desc'] = 'Brojčani popis';
$string['simple:redo_desc'] = 'Ponovi (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Precrtaj';
$string['simple:underline_desc'] = 'Podcrtaj (Ctrl+U)';
$string['simple:undo_desc'] = 'Poništi (Ctrl+Z)';
$string['spellchecker:desc'] = 'Uključi/isključi provjeru pravopisa';
$string['spellchecker:ignore_word'] = 'Zanemari riječ';
$string['spellchecker:ignore_words'] = 'Zanemari sver';
$string['spellchecker:langs'] = 'Jezici';
$string['spellchecker:learn_word'] = 'Nauči riječ';
$string['spellchecker:menu'] = 'Postavke provjere pravopisa';
$string['spellchecker:no_mpell'] = 'Nije pronađena nijedna pravopisna greške.';
$string['spellchecker:no_sug'] = 'Nema prijedloga';
$string['spellchecker:sug'] = 'Prijedlozi';
$string['spellchecker:wait'] = 'Pričekajte...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Uredi CSS';
$string['style_dlg:apply'] = 'Primjeni';
$string['style_dlg:background'] = 'Pozadina';
$string['style_dlg:background_attachment'] = 'Attachment';
$string['style_dlg:background_color'] = 'Background color';
$string['style_dlg:background_hpos'] = 'Vodoravna pozicija';
$string['style_dlg:background_image'] = 'Background image';
$string['style_dlg:background_repeat'] = 'Repeat';
$string['style_dlg:background_tab'] = 'Background';
$string['style_dlg:background_vpos'] = 'Vertical position';
$string['style_dlg:block'] = 'Blok';
$string['style_dlg:block_display'] = 'Display';
$string['style_dlg:block_letterspacing'] = 'Razmak između slova';
$string['style_dlg:block_tab'] = 'Block';
$string['style_dlg:block_text_align'] = 'Poravnanje teksta';
$string['style_dlg:block_text_indent'] = 'Uvlačenje teksta';
$string['style_dlg:block_vertical_alignment'] = 'Vertikalno poravnanje';
$string['style_dlg:block_whitespace'] = 'Whitespace';
$string['style_dlg:block_wordspacing'] = 'Razmak između riječi';
$string['style_dlg:border'] = 'Rub';
$string['style_dlg:border_tab'] = 'Rub';
$string['style_dlg:bottom'] = 'Bottom';
$string['style_dlg:box'] = 'Okvir';
$string['style_dlg:box_clear'] = 'Clear';
$string['style_dlg:box_float'] = 'Float';
$string['style_dlg:box_height'] = 'Visina';
$string['style_dlg:box_tab'] = 'Box';
$string['style_dlg:box_width'] = 'Širina';
$string['style_dlg:bullet_image'] = 'Bullet image';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Color';
$string['style_dlg:height'] = 'Visina';
$string['style_dlg:left'] = 'Lijevo';
$string['style_dlg:list'] = 'Popis';
$string['style_dlg:list_tab'] = 'Popis';
$string['style_dlg:list_type'] = 'Vrsta';
$string['style_dlg:margin'] = 'Margina';
$string['style_dlg:overflow'] = 'Prekoračenje';
$string['style_dlg:padding'] = 'Udaljenost od ruba';
$string['style_dlg:placement'] = 'Postavljanje';
$string['style_dlg:position'] = 'Pozicija';
$string['style_dlg:positioning_tab'] = 'Pozicioniranje';
$string['style_dlg:positioning_type'] = 'Vrsta';
$string['style_dlg:right'] = 'Desno';
$string['style_dlg:same'] = 'Same for all';
$string['style_dlg:style'] = 'Stil';
$string['style_dlg:text'] = 'Tekst';
$string['style_dlg:text_blink'] = 'Blink';
$string['style_dlg:text_case'] = 'Case';
$string['style_dlg:text_color'] = 'Boja';
$string['style_dlg:text_decoration'] = 'Dekoracija';
$string['style_dlg:text_font'] = 'Font';
$string['style_dlg:text_lineheight'] = 'Visina reda';
$string['style_dlg:text_none'] = 'Ništa';
$string['style_dlg:text_overline'] = 'Nadcrta';
$string['style_dlg:text_props'] = 'Tekst';
$string['style_dlg:text_size'] = 'Veličina';
$string['style_dlg:text_striketrough'] = 'Prekriženo';
$string['style_dlg:text_style'] = 'Stil';
$string['style_dlg:text_tab'] = 'Tekst';
$string['style_dlg:text_underline'] = 'Podvučeno';
$string['style_dlg:text_variant'] = 'Varijanta';
$string['style_dlg:text_weight'] = 'Debljina';
$string['style_dlg:title'] = 'Uredi CSS';
$string['style_dlg:toggle_insert_span'] = 'Umetni SPAN u odabir';
$string['style_dlg:top'] = 'Gore';
$string['style_dlg:visibility'] = 'Vidljivost';
$string['style_dlg:width'] = 'Širina';
$string['style_dlg:zindex'] = 'Z-indeks';
$string['subplugintype_tinymce'] = 'Dodatak';
$string['subplugintype_tinymce_plural'] = 'Dodaci';
$string['table:cell'] = 'Polje';
$string['table:cell_desc'] = 'Svojstva polja';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Stupac';
$string['table:col_after_desc'] = 'Umetni stupac desno';
$string['table:col_before_desc'] = 'Umetni stupac lijevo';
$string['table:copy_row_desc'] = 'Kopiraj redak';
$string['table:cut_row_desc'] = 'Izreži redak';
$string['table:del'] = 'Izbriši tablicu';
$string['table:delete_col_desc'] = 'Ukloni stupac';
$string['table:delete_row_desc'] = 'Izbriši redak';
$string['table:desc'] = 'Nova tablica';
$string['table_dlg:advanced_props'] = 'Napredna svojstva';
$string['table_dlg:advanced_tab'] = 'Napredno';
$string['table_dlg:align'] = 'Poravnavanje';
$string['table_dlg:align_bottom'] = 'Dno';
$string['table_dlg:align_default'] = 'Zadano';
$string['table_dlg:align_left'] = 'Lijevo';
$string['table_dlg:align_middle'] = 'Sredina';
$string['table_dlg:align_right'] = 'Desno';
$string['table_dlg:align_top'] = 'Vrh';
$string['table_dlg:bgcolor'] = 'Boja pozadine';
$string['table_dlg:bgimage'] = 'Slika pozadine';
$string['table_dlg:border'] = 'Obrub';
$string['table_dlg:bordercolor'] = 'Boja obruba';
$string['table_dlg:caption'] = 'Opis tablice';
$string['table_dlg:cell_all'] = 'Primjeni na sve ćelije u tablici';
$string['table_dlg:cell_cell'] = 'Primjeni na odabranu ćeliju';
$string['table_dlg:cell_col'] = 'Primjeni na sve ćelije u stupcu';
$string['table_dlg:cell_limit'] = 'Premašili ste najveći dopušteni broj polja ({$cells}).';
$string['table_dlg:cellpadding'] = 'Dopuna polja';
$string['table_dlg:cell_row'] = 'Primjeni na sva polja u retku';
$string['table_dlg:cellspacing'] = 'Razmak polja';
$string['table_dlg:cell_title'] = 'Svojstva ćelije';
$string['table_dlg:cell_type'] = 'Vrsta polja';
$string['table_dlg:colgroup'] = 'Grupa stupaca';
$string['table_dlg:col_limit'] = 'Premašili ste najveći dopušteni broj stupaca ({$cols}).';
$string['table_dlg:cols'] = 'Stupaca';
$string['table_dlg:frame'] = 'Okvir';
$string['table_dlg:frame_all'] = 'sve';
$string['table_dlg:frame_cols'] = 'kolone';
$string['table_dlg:frame_groups'] = 'grupe';
$string['table_dlg:frame_none'] = 'ništa';
$string['table_dlg:frame_rows'] = 'redovi';
$string['table_dlg:general_props'] = 'Opća svojstva';
$string['table_dlg:general_tab'] = 'Opće';
$string['table_dlg:height'] = 'Visina';
$string['table_dlg:id'] = 'Id';
$string['table_dlg:langcode'] = 'Kod jezika';
$string['table_dlg:langdir'] = 'Smjer jezika';
$string['table_dlg:ltr'] = 'S lijeva na desno';
$string['table_dlg:merge_cells_title'] = 'Spoji polja';
$string['table_dlg:mime'] = 'MIME vrsta';
$string['table_dlg:missing_scope'] = '';
$string['table_dlg:row_all'] = 'Primijeni na sve retke u tablici';
$string['table_dlg:row_even'] = 'Primijeni na parne retke u tablici';
$string['table_dlg:rowgroup'] = 'Grupa redaka';
$string['table_dlg:row_limit'] = 'Premašili ste maksimalni broj redaka ({$rows}).';
$string['table_dlg:row_odd'] = 'Primijeni na neparne retke u tablici';
$string['table_dlg:row_row'] = 'Primijeni na odabrani redak';
$string['table_dlg:rows'] = 'Redaka';
$string['table_dlg:row_title'] = 'Svojstva retka';
$string['table_dlg:rowtype'] = 'Vrsta redova';
$string['table_dlg:rtl'] = 'S desna na lijevo';
$string['table_dlg:rules'] = '';
$string['table_dlg:rules_above'] = 'iznad';
$string['table_dlg:rules_below'] = 'ispod';
$string['table_dlg:rules_border'] = 'rub';
$string['table_dlg:rules_box'] = 'okvir';
$string['table_dlg:rules_hsides'] = 'gore i dolje';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'ni s jedne strane';
$string['table_dlg:rules_vsides'] = 'lijevo i desno';
$string['table_dlg:scope'] = 'Domet';
$string['table_dlg:style'] = 'Stil';
$string['table_dlg:summary'] = 'Sažetak';
$string['table_dlg:tbody'] = 'Tijelo tablice';
$string['table_dlg:td'] = 'Podatkovna';
$string['table_dlg:tfoot'] = 'Podnožje tablice';
$string['table_dlg:th'] = 'Zaglavlje';
$string['table_dlg:thead'] = 'Zaglavlje tablice';
$string['table_dlg:title'] = 'Umetni/uredi tablicu';
$string['table_dlg:valign'] = 'Okomito poravnavanje';
$string['table_dlg:width'] = 'Širina';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Spoji polja';
$string['table:paste_row_after_desc'] = 'Zalijepi redak ispod';
$string['table:paste_row_before_desc'] = 'Zalijepi redak iznad';
$string['table:props_desc'] = 'Svojstva tablice';
$string['table:row'] = 'Redak';
$string['table:row_after_desc'] = 'Umetni redak ispod';
$string['table:row_before_desc'] = 'Umetni redak iznad';
$string['table:row_desc'] = 'Svojstva retka';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Razdvoji spojene ćelije';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['template:desc'] = 'Umetni sadržaj iz predloška';
$string['template_dlg:cdate_format'] = '%d.%m.%Y %H:%M:%S';
$string['template_dlg:day_long'] = 'nedjelja,ponedjeljak,utorak,srijeda,četvrtak,petak,subota,nedjelja';
$string['template_dlg:day_short'] = 'ned,pon,uto,sri,čet,pet,sub,ned';
$string['template_dlg:desc'] = 'Umetni sadržaj predloška';
$string['template_dlg:desc_label'] = 'Opis';
$string['template_dlg:label'] = 'Predložak';
$string['template_dlg:mdate_format'] = '%d.%m.%Y %H:%M:%S';
$string['template_dlg:months_long'] = 'siječanj,veljača,ožujak,travanj,svibanj,lipanj,srpanj,kolovoz,rujan,listopad,studeni,prosinac';
$string['template_dlg:months_short'] = 'sij,velj,ožu,tra,svi,lip,srp,kol,ruj,lis,stu,pro';
$string['template_dlg:preview'] = 'Prikaz';
$string['template_dlg:select'] = 'Odaberite predložak';
$string['template_dlg:title'] = 'Predlošci';
$string['template_dlg:warning'] = 'Upozorenje: Nadopuna predloška novim može uzrokovati gubitak podataka.';
$string['visualblocks:desc'] = 'Skrij/prikaži elemente bloka';
$string['visualchars:desc'] = 'Vizualni kontrolni znakovi omogućeni/onemogućeni.';
$string['wordcount:words'] = 'Riječi:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Kratica';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Akronim';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Umetni/uredi atribute';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citat';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Brisanje';
$string['xhtmlxtras_dlg:attribs_title'] = 'Umetni/uredi atribute';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atributi';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atributi';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Događaji';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'AccessKey';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citat';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klasa';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Datum/vrijeme';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Jezik';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Smjer teksta';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stil';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Naslov';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'S lijeva na desno';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'S desna na lijevo';
$string['xhtmlxtras_dlg:events_tab'] = 'Događaji';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atributi elemenata';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Događaji elemenata';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Osnovne postavke';
$string['xhtmlxtras_dlg:general_tab'] = 'Osnovno';
$string['xhtmlxtras_dlg:insert_date'] = 'Umetni trenutačni datum/vrijeme';
$string['xhtmlxtras_dlg:option_ltr'] = 'S lijeva na desno';
$string['xhtmlxtras_dlg:option_rtl'] = 'S desna na lijevo';
$string['xhtmlxtras_dlg:remove'] = 'Ukloni';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Element kratice';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Element akronima';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Element citata';
$string['xhtmlxtras_dlg:title_del_element'] = 'Element za brisanje';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Element za unos';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Unos';
