<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   auth
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Dostupni autentikacijski dodaci (plugins)';
$string['alternatelogin'] = 'Ako unesete URL ovdje, onda će isti biti korišten kao stranica za prijavu na sjedište. Ta stranica bi trebala sadržavati obrazac koja ima zadnu postavku akcije na  <strong>\'{$a}\'</strong> i vraćati polja <strong>username</strong> i <strong>password</strong>.<br/>Budite oprezni, jer unošenje pogrešnog URL-a može rezultirati time da blokirate pristup sjedištu svima, pa i sebi.<br/>Ostavite ovo praznim ako želite koristiti zadanu stranicu za prijavu.';
$string['alternateloginurl'] = 'Alternativni URL za prijavu na sustav';
$string['auth_changepasswordhelp'] = 'Pomoć pri promjeni lozinke';
$string['auth_changepasswordurl'] = 'URL za promjenu lozinke';
$string['auth_changingemailaddress'] = 'Zatražili ste promjenu adrese e-pošte iz {$a->oldemail} u {$a->newemail}. Zbog sigurnosnih razloga vam šaljemo poruku e-poštom na novu adresu kako bi potvrdili da vam ista doista pripada. Vaša adresa e-pošte će biti osvježena čim posjetite URL koji vam je poslan u toj poruci.';
$string['auth_common_settings'] = 'Zajedničke postavke';
$string['auth_data_mapping'] = 'Mapiranje podataka';
$string['authenticationoptions'] = 'Opcije za autentikaciju';
$string['auth_fieldlock'] = 'Zaključaj vrijednost';
$string['auth_fieldlock_expl'] = '<p><b>Zaključaj vrijednost:</b> Ako je omogućeno, onemogućava Moodle korisnicima i administratorima direktno uređivanje sadržaja polja. Koristite ovu mogućnost ako te podatke održavate u vanjskom autentikacijskom sustavu.</p>>';
$string['auth_fieldlocks'] = 'Zaključaj korisnička polja';
$string['auth_fieldlocks_help'] = '<p>Možete zaključati polja s korisničkim podacima. Ovo je korisno za sustave na kojima korisničke podatke ručno održavaju administratori (ili ih postavljaju kroz \'Prijenos korisnika\' (upload)). Ako zaključate polja koja su potrebna Moodle sustavu, provjerite pri stvaranju korisničkih računa da su ista popunjena, jer će u suprotnom te korisničke račune biti nemoguće koristiti.</p><p>Postavite vrijednost zaključavanja na \'Otključano ako je prazno\' kako bi izbjegli navedeni problem.</p>';
$string['authinstructions'] = 'Ovdje možete pružiti upute za prijavu na sustav, koja će se prikazivati na stranici za prijavu. Ako želite koristiti prilagođene upute za prijavu, unesite ih ovdje.';
$string['auth_invalidnewemailkey'] = 'Pogreška: ako pokušavate potvrditi promjenu adrese e-pošte, postoji mogućnost da ste načinili nenamjernu pogrešku prilikom kopiranja URL-a koji vam je došao u e-pošti. Ponovno kopirajte adresu i pokušajte još jednom.';
$string['auth_multiplehosts'] = 'Višestruki poslužitelji ILI adrese mogu biti navedeni (npr. posluzitelj1.com;posluzitelj2.com;posluzitelj3.com) ili (npr. xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_outofnewemailupdateattempts'] = 'Potrošili ste sve dopuštene pokušaje za promjenu adrese e-pošte. Vaš zahjtev za promjenu adrese je odbijen.';
$string['auth_passwordisexpired'] = 'Vaša lozinka je istekla. Želite li je promijeniti sada?';
$string['auth_passwordwillexpire'] = 'Vaša lozinka će isteći za {$a} dana. Želite li je promijeniti sada?';
$string['auth_remove_delete'] = 'Potpuno brisanje internih podataka';
$string['auth_remove_keep'] = 'Zadržavanje internih podataka';
$string['auth_remove_suspend'] = 'Zaključaj interno';
$string['auth_remove_user'] = 'Odredite što učiniti s unutarnjim korisničkim računom tijekom masovne sinkronizacije kada je korisnik uklonjen iz vanjskog izvora. Samo će suspendirani korisnici biti automatski oživljeni ako se ponovo pojave u vanjskom izvoru.';
$string['auth_remove_user_key'] = 'Uklonjen vanjski korisnik';
$string['auth_sync_script'] = 'Cron skripta za sinkronizaciju';
$string['auth_updatelocal'] = 'Nadogradnja lokalnih podataka';
$string['auth_updatelocal_expl'] = '<p><b>Osvježi lokalno</b> Ako je omogućeno, polje će biti osvježeno (iz vanjskog izvora) svaki puta kad se korisnik prijavi ili kad se izvrši sinkronizacija korisničkih računa. Polja koja se osvježavaju lokalno trebaju biti zaključana.</p>';
$string['auth_updateremote'] = 'Nadogradnja udaljenih podataka';
$string['auth_updateremote_expl'] = '<p><b>Osvježi udaljeno</b> Ako je omogućeno, udaljeni zapis će biti osvježen svaki puta kad se promijene podaci o korisniku. Polja trebaju biti otključana kako bi se omogućilo uređivanje.</p>';
$string['auth_updateremote_ldap'] = '<p><b>Napomena:</b> Osvježavanje vanjskih LDAP podataka zahtijeva da podesite binddn i bindpw za bind-korisnika s ovlastima uređivanja svih korisničkih zapisa. Trenutno ne pohranjuje atribute s višestrukim vrijednostima i uklonit će prekobrojne vrijednosti pri osvježavanju.</p>';
$string['auth_user_create'] = 'Dopusti stvaranje novih korisnika';
$string['auth_user_creation'] = 'Novi (anonimni) korisnici mogu stvoriti korisnički račun na vanjskom autentikacijskom izvoru i potvrditi ga putem e-pošte. Ako ovo omogućite, zapamtite da morate postaviti i specifične opcije modula za stvaranje korisnika.';
$string['auth_usernameexists'] = 'Odabrano korisničko ime već postoji. Molimo odaberite drugo korisničko ime.';
$string['auto_add_remote_users'] = 'Automatski dodaj korisnike s udaljenih lokacija';
$string['changepassword'] = 'URL za promjenu lozinke';
$string['changepasswordhelp'] = 'Ovdje možete zadati lokaciju na kojoj vaši korisnici mogu dobiti zagubljenu ili promijeniti postojeće korisničko ime/lozinku ako su iste zagubili/zaboravili. To će omogućiti prikaz gumba na stranici za prijavu korisnika i na stranici njihovog profila. Ako ovo ostavite praznim, navedeni gumb se neće prikazivati.';
$string['chooseauthmethod'] = 'Odaberite način autentikacije:';
$string['chooseauthmethod_help'] = 'Ova postavka određuje način autentikacije koji se koristi za prijavu korisnika. Možete odabrati samo omogućene autentikacijske dodatke, u suprotnome se korisnici neće više moći prijaviti. Kako bi blokirali buduće prijave nekog korisnika, zadajte mu autentikacijski dodatak \'Nema prijave\'.';
$string['createpasswordifneeded'] = 'Stvori lozinku po potrebi';
$string['emailchangecancel'] = 'Odustani od promjene adrese e-pošte';
$string['emailchangepending'] = 'Promjena u tijeku. Otvorite poveznicu koja vam je poslana na {$a->preference_newemail}.';
$string['emailnowexists'] = 'Adresa e-pošte koju ste pokušali dodijeliti vašem profilu je već dodijeljena drugom profilu u međuvremenu. Vaš zahtjev za promjenu adrese elektroničke pošte se stoga odbija, no možete pokušati zamjenu s nekom drugom adresom e-pošte.';
$string['emailupdate'] = 'Promjena adrese e-pošte';
$string['emailupdatemessage'] = 'Postovana/i {$a->fullname},

zatrazili ste promjenu adrese e-poste za vas korisnicki racun koji koristite za {$a->site}. Molimo otvorite ovu poveznicu (URL) u vasem internet pregledniku kako bi potvrdili ovu promjenu:

{$a->url}';
$string['emailupdatesuccess'] = 'Adresa e-pošte korisnika <em>{$a->fullname}</em> je uspješno promijenjena u <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Potvrda izmjene adrese e-pošte za {$a->site}';
$string['enterthenumbersyouhear'] = 'Unesite brojeve koje čujete';
$string['enterthewordsabove'] = 'Unesite riječi ispisane iznad';
$string['errormaxconsecutiveidentchars'] = 'Lozinke moraju imati barem {$a} uzastopnih identičnih znakova.';
$string['errorminpassworddigits'] = 'Lozinka mora sadržavati barem ovoliko znamenki: {$a}.';
$string['errorminpasswordlength'] = 'Lozinka mora biti dugačka barem ovoliko znakova: {$a}';
$string['errorminpasswordlower'] = 'Lozinka mora sadržavati barem ovoliko malih slova: {$a}';
$string['errorminpasswordnonalphanum'] = 'Lozinka mora sadržavati barem ovoliko ne-alfanumeričkih znakova (npr. znakova interpunkcije): {$a}';
$string['errorminpasswordupper'] = 'Lozinka mora sadržavati barem ovoliko velikih slova: {$a}';
$string['errorpasswordupdate'] = 'Pogreška pri osvježavanju lozinke, lozinka nije promijenjena.';
$string['forcechangepassword'] = 'Obveži na promjenu lozinke';
$string['forcechangepasswordfirst_help'] = 'Obvezna promjena lozinke za sve korisnike pri prvoj prijavi sustavu';
$string['forcechangepassword_help'] = 'Obvezna promjena lozinke za sve korisnike pri sljedećoj prijavi sustavu';
$string['forgottenpassword'] = 'Ako ovdje unesete URL, isti će biti korišten za dohvat stranice za povrat izgubljenih/zaboravljenih lozinki za ovo sjedište. Ovo je namijenjeno za sjedište gdje se lozinkama upravlja u potpunosti van Moodle-a. Ostavite ovo praznim kako bi koristili zadani način vraćanja lozinki.';
$string['forgottenpasswordurl'] = 'URL za vraćanje zaboravljene lozinke';
$string['getanaudiocaptcha'] = 'Koristi zvučnu CAPTCHA';
$string['getanimagecaptcha'] = 'Koristi slikovnu CAPTCHA';
$string['getanothercaptcha'] = 'Koristi drugu CAPTCHA';
$string['guestloginbutton'] = 'Gumb za prijavu kao gost';
$string['incorrectpleasetryagain'] = 'Netočno. Pokušajte ponovno.';
$string['infilefield'] = 'Obvezno polje u datoteci';
$string['informminpassworddigits'] = 'bar {$a} znamenki';
$string['informminpasswordlength'] = 'bar {$a} znakova';
$string['informminpasswordlower'] = 'bar {$a} malih slova';
$string['informminpasswordnonalphanum'] = 'najmanji broj ne-alfanumeričkih znakova: {$a} ';
$string['informminpasswordupper'] = 'bar {$a} velikih štampanih slova';
$string['informpasswordpolicy'] = 'Lozinka mora imati {$a}';
$string['instructions'] = 'Upute';
$string['internal'] = 'Interno';
$string['locked'] = 'Zaključano';
$string['md5'] = 'MD 5 hash';
$string['nopasswordchange'] = 'Lozinku nije moguće promijeniti';
$string['nopasswordchangeforced'] = 'Ne možete nastaviti bez promjene lozinke, međutim, ne postoji stranicu za promjenu iste. Kontaktirajte administratora.';
$string['noprofileedit'] = 'Ovaj profil nije moguće uređivati';
$string['ntlmsso_attempting'] = 'Pokušavam ostvariti SSO preko NTLM ...';
$string['ntlmsso_failed'] = 'Automatska prijava nije uspjela, pokušajte prijavu na uobičajenoj stranici za prijavu...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO je onemogućen.';
$string['passwordhandling'] = 'Upravljenje poljem lozinke';
$string['plaintext'] = 'Obični tekst';
$string['pluginnotenabled'] = 'Autentikacijski dodatak (plugin) \'{$a}\' nije aktiviran.';
$string['pluginnotinstalled'] = 'Autentikacijski dodatak (plugin) \'{$a}\' nije instaliran.';
$string['potentialidps'] = 'Prijavite se koristeći svoj korisnički račun koji imate na:';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = 'CAPTCHA služi za spriječavanje zloporabe od strane automatiziranih programa. Samo unesite riječi koje vidite u okviru, redom kojim su napisane i odvojite ih razmakom.

Ako niste sigurni koje su to riječi, možete zatražiti novi CAPTCHA ili poslušati zvučni CAPTCHA.';
$string['selfregistration'] = 'Samo-registracija';
$string['selfregistration_help'] = 'Ako je odabran autentikacijski dodatak, poput na e-pošti zasnovanog dodatka za samostalnu registraciju, onda će ovo omogućiti potencijalnim korisnicima registraciju i stvaranje korisničkih računa. Ovo rezultira mogućnošću da spameri stvaraju korisničke račune kako bi koristili forume, blog članke i slično za slanje spama. Kako bi izbjegli ovaj rizik, samostalna registracija treba biti onemogućena ili ograničena putem postavke <em>Dopuštene domene e-pošte</em>.';
$string['sha1'] = 'SHA-1 hash';
$string['showguestlogin'] = 'Možete prikazati ili skriti gumb za prijavu gosta na stranici za prijavu.';
$string['stdchangepassword'] = 'Upotreba standardne stranice za promjenu lozinke';
$string['stdchangepassword_expl'] = 'Ako vanjski sustav autentikacije dopušta promjenu lozinke kroz Moodle, postavite vrijednost na \'Da\'. Ova postavka ima prednost nad postavkom \'URL za promjenu lozinke\'.';
$string['stdchangepassword_explldap'] = 'NAPOMENA: Preporučljivo je koristiti LDAP kroz SSL enkriptirani tunel (ldaps://) ako se radi o vanjskom LDAP poslužitelju.';
$string['suspended'] = 'Zaključani račun';
$string['suspended_help'] = 'Zaključani korisnički računi se ne mogu prijaviti niti koristiti web servise, a sve odlazne poruke se brišu.';
$string['unlocked'] = 'Otključano';
$string['unlockedifempty'] = 'Otključano ako je prazno';
$string['update_never'] = 'Nikad';
$string['update_oncreate'] = 'Pri stvaranju';
$string['update_onlogin'] = 'Pri svakoj prijavi sustavu';
$string['update_onupdate'] = 'Pri osvježavanju';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ne podržava odabranu vrstu korisnika: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() ne podržava odabranu vrstu korisnika (...za sada)';
