<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Postoje zadaće koje zahtijevaju vašu pažnju';
$string['addattempt'] = 'Predajte drugu zadaću';
$string['addnewattempt'] = 'Predajte novu zadaću';
$string['addnewattemptfromprevious'] = 'Dopusti novi pokušaj zasnovan na prethodno predanoj zadaći';
$string['addsubmission'] = 'Predajte zadaću';
$string['allocatedmarker'] = 'Dodijeljeni nastavnik';
$string['allocatedmarker_help'] = 'Nastavnik je dodijeljen za ovu zadaću';
$string['allowsubmissions'] = 'Omogućuje da korisnik i dalje ima mogućnost predavati zadaću.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Detaljnije informacije o zadaći i obrazac za predaju zadaće bit će dostupni od <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Dopusti predavanje zadaće od';
$string['allowsubmissionsfromdate_help'] = 'Ako je omogućeno, studenti neće moći predati zadaću prije ovog datuma. Ako je onemogućeno, studenti će moći predati zadaću odmah.';
$string['allowsubmissionsfromdatesummary'] = 'Ova zadaća dopušta predavanje vaših radova od <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Dopusti izmjene predane zadaće';
$string['alwaysshowdescription'] = 'Uvijek prikaži upute';
$string['alwaysshowdescription_help'] = 'Ako je onemogućeno, upute za zadaću postat će vidljive tek na datum naveden u "Dopusti predavanje zadaće od"';
$string['applytoteam'] = 'Primijeni ocjene i povratnu informaciju na cijelu grupu';
$string['assign:addinstance'] = 'Dodajte novu zadaću';
$string['assign:exportownsubmission'] = 'Izvoz vlastite zadaće';
$string['assignfeedback'] = 'Dodatak za povratnu informaciju';
$string['assignfeedbackpluginname'] = 'Dodatak za povratnu informaciju';
$string['assign:grade'] = 'Ocijenite zadaću';
$string['assign:grantextension'] = 'Davanje dopuštenja za produljenje roka';
$string['assign:manageallocations'] = 'Uredi raspodjelu nastavnika po predanim zadaćama';
$string['assign:managegrades'] = 'Pregledaj i objavi ocjene';
$string['assignmentisdue'] = 'Rok za predaju zadaće';
$string['assignmentmail'] = '{$a->grader} je predao povratnu informaciju vezano uz vasu predanu zadacu \'{$a->assignment}\'

Povratnu informaciju mozete vidjeti ovdje:

    {$a->url}';
$string['assignmentmailhtml'] = '{$a->grader} je predao povratnu informaciju vezano uz vasu predanu zadacu \'<i>{$a->assignment}</i>\'<br /><br />

Povratnu informaciju mozete vidjeti ovdje: <a href="{$a->url}">{$a->url}</a>.';
$string['assignmentmailsmall'] = '{$a->grader} je predao povratnu informaciju vezano uz vasu predanu zadacu \'{$a->assignment}\' Povratnu informaciju mozete vidjeti na kraju svoje zadace';
$string['assignmentname'] = 'Naziv zadaće';
$string['assignmentplugins'] = 'Dodaci za zadaće';
$string['assignmentsperpage'] = 'Zadaća po stranici';
$string['assign:releasegrades'] = 'Objavi ocjene';
$string['assign:revealidentities'] = 'Otkrivanje identiteta studenata';
$string['assign:reviewgrades'] = 'Pregledaj ocjene';
$string['assignsubmission'] = 'Dodatak za predavanje zadaće';
$string['assignsubmissionpluginname'] = 'Dodatak za predavanje zadaće';
$string['assign:submit'] = 'Predajte zadaću';
$string['assign:view'] = 'Pregledavanje zadaće';
$string['attemptheading'] = 'Predana zadaća {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Prethodno predane zadaće';
$string['attemptnumber'] = 'Broj predanih zadaća';
$string['attemptreopenmethod'] = 'Ponovno otvoreni pokušaji';
$string['attemptreopenmethod_manual'] = 'Ručno';
$string['attemptreopenmethod_none'] = 'Nikad';
$string['attemptreopenmethod_untilpass'] = 'Automatski do prolazne';
$string['attemptsettings'] = 'Postavke predavanja zadaće';
$string['availability'] = 'Dostupnost';
$string['backtoassignment'] = 'Natrag na zadaću';
$string['batchoperationconfirmaddattempt'] = 'Treba li dopustiti dodatno predavanje zadaće za odabrane pokušaje?';
$string['batchoperationconfirmgrantextension'] = 'Dopusti produljenje krajnjeg roka za predaju za sve odabrane zadaće?';
$string['batchoperationconfirmlock'] = 'Zaključati sve odabrane zadaće?';
$string['batchoperationconfirmreverttodraft'] = 'Vrati sve odabrane zadaće u nacrte?';
$string['batchoperationconfirmunlock'] = 'Otključati sve odabrane zadaće?';
$string['batchoperationlock'] = 'Zaključaj predane zadaće';
$string['batchoperationreverttodraft'] = 'Vrati predane zadaće u nacrte';
$string['batchoperationsdescription'] = 'S odabranim...';
$string['batchoperationunlock'] = 'Otključaj predane zadaće';
$string['batchsetallocatedmarker'] = 'Odredi nastavnika za {$a} odabranih korisnika.';
$string['batchsetmarkingworkflowstateforusers'] = 'Odredi proceduru ocjenjivanja za {$a} odabranih korisnika.';
$string['blindmarking'] = 'Ocjenjivanje naslijepo (anonimno)';
$string['blindmarking_help'] = 'Ocjenjivanje naslijepo (anonimno) ocjenjivačima skriva identitet studenata. Nakon što je predana ili ocijenjena jedna zadaća, nije moguće promijeniti postavke vezane za ocjenjivanje naslijepo.';
$string['changegradewarning'] = 'Ova zadaća već ima ocijenjene zadaće i promjena ocjene neće automatski preračunati postojeće ocjene. Morate ponovno ocijeniti sve zadaće, ako želite promijeniti ocjenu.';
$string['choosegradingaction'] = 'Operacija ocjenjivanja';
$string['choosemarker'] = 'Odaberite...';
$string['chooseoperation'] = 'Odaberite operaciju';
$string['comment'] = 'Komentar';
$string['completionsubmit'] = 'Student mora predati ovu aktivnost kako bi je završio';
$string['configshowrecentsubmissions'] = 'Svi mogu vidjeti obavijesti o predanim zadaćama u izvještaju o nedavnim aktivnostima.';
$string['confirmbatchgradingoperation'] = 'Želite li uistinu provesti operaciju {$a->operation} za ovaj broj studenata: {$a->count}?';
$string['confirmsubmission'] = 'Želite li uistinu predati vašu zadaću na ocjenjivanje? Više nećete moći raditi ikakve izmjene nad zadaćom.';
$string['conversionexception'] = 'Nije bilo moguće nadograditi zadaću. Iznimka glasi: {$a}.';
$string['couldnotconvertgrade'] = 'Nije bilo moguće nadograditi ocjenu zadaće za korisnika {$a}.';
$string['couldnotconvertsubmission'] = 'Nije bilo moguće nadograditi predanu zadaću korisnika {$a}.';
$string['couldnotcreatecoursemodule'] = 'Nije bilo moguće stvoriti modul kolegija.';
$string['couldnotcreatenewassignmentinstance'] = 'Nije bilo moguće stvoriti novu instancu zadaće.';
$string['couldnotfindassignmenttoupgrade'] = 'Nije bilo moguće pronaći instancu stare zadaće za nadogradnju';
$string['currentattempt'] = 'Ovo je predana zadaća broj {$a}.';
$string['currentattemptof'] = 'Ovo je predana zadaća broj {$a->attemptnumber} (od dopuštenih {$a->maxattempts}).';
$string['currentgrade'] = 'Trenutno pohranjena ocjena';
$string['cutoffdate'] = 'Krajnji rok predaje';
$string['cutoffdatefromdatevalidation'] = 'Krajnji rok predaje mora biti nakon datuma početka predaje';
$string['cutoffdate_help'] = 'Ako je omogućeno, zadaću neće biti moguće predati nakon ovog datuma, bez davanja produženja.';
$string['cutoffdatevalidation'] = 'Krajnji rok predaje ne može biti prije roka predaje.';
$string['defaultsettings'] = 'Zadane postavke zadaće';
$string['defaultsettings_help'] = 'Ove postavke definiraju zadane vrijednosti za sve nove zadaće';
$string['defaultteam'] = 'Zadana grupa';
$string['deleteallsubmissions'] = 'Izbriši sve predane zadaće';
$string['description'] = 'Upute';
$string['downloadall'] = 'Preuzmi sve predane zadaće';
$string['duedate'] = 'Rok predaje';
$string['duedate_help'] = 'Datum kada zadaću treba predati. Nakon ovog datuma zadaće će se i dalje moći predati, ali će takve zadaće biti označene kao zakašnjele. Ako želite spriječiti predaju nakon nekog datuma - postavite krajnji rok predaje.';
$string['duedateno'] = 'Bez roka predaje';
$string['duedatereached'] = 'Rok za predaju ove zadaće je istekao';
$string['duedatevalidation'] = 'Rok za predaju zadaće mora biti iza početnog datuma zadaće';
$string['editaction'] = 'Operacije...';
$string['editattemptfeedback'] = 'Uredi ocjenu i povratnu informaciju za predanu zadaću broj {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Uređujete povratnu informaciju za prethodno predanu zadaću. Ovo je predana zadaća broj {$a->attemptnumber} od {$a->totalattempts}.';
$string['editingstatus'] = 'Status uređivanja';
$string['editsubmission'] = 'Uredi moju zadaću';
$string['editsubmission_help'] = 'Izmjenite svoju predanu zadaću';
$string['enabled'] = 'Omogućeno';
$string['errornosubmissions'] = 'Nema predanih zadaća za preuzimanje';
$string['errorquickgradingvsadvancedgrading'] = 'Ocjene nisu pohranjene jer ova zadaća trenutno koristi napredno ocjenjivanje.';
$string['errorrecordmodified'] = 'Ocjene nisu pohranjene jer je netko promijenu jedan ili više zapisa nakon što ste učitali stranicu.';
$string['extensionduedate'] = 'Produljeni krajnji rok';
$string['extensionnotafterduedate'] = 'Datum produljenog krajnjeg roka mora biti iza izvornog datuma roka predaje';
$string['extensionnotafterfromdate'] = 'Datum produljenog krajnjeg roka mora biti iza datuma od kojeg počinje predaja zadaće';
$string['feedback'] = 'Povratna informacija';
$string['feedbackavailablehtml'] = '{$a->username} je poslao/la povratnu informaciju vezano uz zadacu \'<i>{$a->assignment}</i>\'<br /><br />

Mozete je pogledati <a href="{$a->url}">ovdje</a>.';
$string['feedbackavailablesmall'] = '{$a->username} je poslao/la povratnu informaciju vezano uz zadacu {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} je poslao/la povratnu informaciju vezano uz zadacu {$a->assignment}

Mozete je pogledati ovdje:

   {$a->url}';
$string['feedbackplugin'] = 'Dodatak za povratnu informaciju';
$string['feedbackpluginforgradebook'] = 'Dodatak za povratnu informaciju koji će zapisati komentare u popis ocjena';
$string['feedbackpluginforgradebook_help'] = 'Samo jedan dodatak za povratnu informaciju može zapisivati komentare u popis ocjena';
$string['feedbackplugins'] = 'Dodaci za povratnu informaciju';
$string['feedbacksettings'] = 'Postavke povratne informacije';
$string['feedbacktypes'] = 'Vrste povratnih informacija';
$string['filesubmissions'] = 'Postavljanje datoteke';
$string['filter'] = 'Filtriranje';
$string['filternone'] = 'Nema filtra';
$string['filterrequiregrading'] = 'Potrebno ocijeniti';
$string['filtersubmitted'] = 'Predano';
$string['gradeabovemaximum'] = 'Ocjena mora biti manja ili jednaka {$a}.';
$string['gradebelowzero'] = 'Ocjena mora biti veća ili jednaka nuli.';
$string['gradecanbechanged'] = 'Ocjenu je moguće promijeniti';
$string['graded'] = 'Ocijenjeno';
$string['gradedby'] = 'Ocijenjeno od';
$string['gradedon'] = 'Datum ocjene';
$string['gradeoutof'] = 'Ocjena od ukupno {$a}';
$string['gradeoutofhelp'] = 'Ocjena';
$string['gradeoutofhelp_help'] = 'Ovdje unesite ocjenu za studentsku zadaću. Možete unijeti i decimale.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} je izmijenio/predao svoju zadacu vezanu uz zadatak pod nazivom <i>\'{$a->assignment}\'</i> u {$a->timeupdated}</i><br /><br />Ista je dostupna na <a href="{$a->url}">ovoj adresi</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} je osvjezio/la svoj rad za zadacu {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} je izmijenio/predao svoju zadacu vezanu uz zadatak pod nazivom \'{$a->assignment}\' u {$a->timeupdated}

Ista je dostupna ovdje:
{$a->url}';
$string['gradestudent'] = 'Ocjena studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Ocjena {$a}';
$string['grading'] = 'Ocjenjivanje';
$string['gradingchangessaved'] = 'Izmjene ocjena su pohranjene';
$string['gradingmethodpreview'] = 'Kriterij ocjenjivanja';
$string['gradingoptions'] = 'Opcije';
$string['gradingstatus'] = 'Ocjena';
$string['gradingsummary'] = 'Informacije o ocjenjivanju';
$string['grantextension'] = 'Dopusti produljenje krajnjeg roka';
$string['grantextensionforusers'] = 'Dopusti produljenje krajnjeg roka za ovoliko studenata: {$a}';
$string['groupsubmissionsettings'] = 'Postavke za grupnu predaju zadaće';
$string['hiddenuser'] = 'Sudionik';
$string['hideshow'] = 'Skrij/prikaži';
$string['instructionfiles'] = 'Datoteke s uputama';
$string['invalidfloatforgrade'] = 'Upisana ocjena nije dobro napisana: {$a}';
$string['invalidgradeforscale'] = 'Ocjena nije valjana prema trenutno važećoj skali';
$string['lastmodifiedgrade'] = 'Zadnja izmjena (ocjena)';
$string['lastmodifiedsubmission'] = 'Zadnja izmjena (zadaća)';
$string['latesubmissions'] = 'Kasnija predaja zadaće';
$string['latesubmissionsaccepted'] = 'Zadaću mogu predati samo oni studenti koji imaju dopuštenje za produljenje roka';
$string['locksubmissionforstudent'] = 'Zabrani daljnju predaju zadaća studentu: (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Zaključati zadaće';
$string['manageassignfeedbackplugins'] = 'Uredi dodatke za povratnu informaciju';
$string['manageassignsubmissionplugins'] = 'Uredi dodatke za predaju';
$string['marker'] = 'Ocjenjivač';
$string['markingallocation'] = 'Dodijeli ocjenjivače';
$string['markingworkflow'] = 'Koristi proceduru za ocjenjivanje';
$string['markingworkflowstate'] = 'Stanje procedure za ocjenjivanje';
$string['markingworkflowstateinmarking'] = 'U postupku ocjenjivanja';
$string['markingworkflowstateinreview'] = 'U postupku pregledavanja';
$string['markingworkflowstatenotmarked'] = 'Nije ocijenjeno';
$string['markingworkflowstatereadyforrelease'] = 'Spremno za objavu';
$string['markingworkflowstatereadyforreview'] = 'Ocjenjivanje dovršeno';
$string['markingworkflowstatereleased'] = 'Objavljeno';
$string['maxattempts'] = 'Najveći dopušteni broj predanih zadaća';
$string['maxattempts_help'] = 'Najveći dopušteni broj predanih zadaća po studentu. Nakon ovog broja, neće biti moguće ponovno otvaranje zadaće za predaju.';
$string['maxgrade'] = 'Najviša ocjena';
$string['messageprovider:assign_notification'] = 'Obavijesti o zadaći';
$string['modulename'] = 'Zadaća';
$string['modulename_help'] = 'Zadaća omogućava nastavniku zadavanje, zaprimanje, ocjenjivanje i davanje povratne informacije o studentskim radovima (zadaćama).

Studenti mogu predati bilo koji digitalni sadržaj (datoteke), poput tekstualnih datoteka, tablica ili slika, a mogu i unijeti tekst izravno u polje za unos koristeći online obrazac. Zadaća može poslužiti i kao podsjetnik studentima na seminare/zadatke koji se ne predaju online, već u "stvarnom" okruženju i papirnatom obliku (no takve se zadaće i dalje mogu ocijeniti i takva ocjena se bilježi u sustavu). Studenti mogu zadaću predati individualno ili kao član grupe.

Pri ocjenjivanju zadaća nastavnici mogu ostaviti povratnu informaciju za studente ili prenijeti nove datoteke (npr. ocijenjene zadaće, dokumente s komentarima ili povratnu informaciju u zvučnom obliku). Zadaće je moguće ocjenjivati korištenjem brojčane ili prilagođene skale ili korištenjem naprednih načina ocjenjivanja kao što je to rubric. Završne ocjene se bilježe u sustavu.';
$string['modulenameplural'] = 'Zadaće';
$string['mysubmission'] = 'Moja zadaća:';
$string['newsubmissions'] = 'Predane zadaće';
$string['noattempt'] = 'Zadaća nije predana';
$string['nofiles'] = 'Nema datoteka.';
$string['nograde'] = 'Nema ocjene.';
$string['nolatesubmissions'] = 'Kasnija predaja zadaće nije dopuštena.';
$string['nomoresubmissionsaccepted'] = 'Daljnja predaja zadaća nije dopuštena';
$string['noonlinesubmissions'] = 'Za ovu zadaću ne morate ništa predavati online';
$string['nosavebutnext'] = 'Nastavi';
$string['nosubmission'] = 'Nije predana nijedna zadaća';
$string['nosubmissionsacceptedafter'] = 'Nijedna zadaća neće biti zaprimljena nakon';
$string['notgraded'] = 'Nije ocijenjeno';
$string['notgradedyet'] = 'Nije još ocijenjeno';
$string['notifications'] = 'Obavijesti';
$string['notsubmittedyet'] = 'Zadaća jos nije predana';
$string['nousersselected'] = 'Nijedan korisnik nije odabran';
$string['numberofdraftsubmissions'] = 'Nacrti';
$string['numberofparticipants'] = 'Sudionici';
$string['numberofsubmissionsneedgrading'] = 'Potrebno ocijeniti';
$string['numberofsubmittedassignments'] = 'Predano';
$string['numberofteams'] = 'Grupe';
$string['offline'] = 'Ne treba ništa predati online';
$string['open'] = 'Otvoreno';
$string['outlinegrade'] = 'Ocjena: {$a}';
$string['outof'] = '{$a->current} od {$a->total}';
$string['overdue'] = '<font color="red">Zadaća je predana prekasno za: {$a}</font>';
$string['page-mod-assign-view'] = 'Glavna stranica modula zadaća';
$string['page-mod-assign-x'] = 'Bilo koja stranica modula zadaća';
$string['participant'] = 'Sudionik';
$string['pluginadministration'] = 'Upravljanje zadaćom';
$string['pluginname'] = 'Zadaća';
$string['preventsubmissions'] = 'Zabrani korisniku nove predaje u ovoj zadaći.';
$string['preventsubmissionsshort'] = 'Spriječi izmjene predane zadaće';
$string['previous'] = 'Prethodni';
$string['quickgrading'] = 'Brzo ocjenjivanje';
$string['quickgradingchangessaved'] = 'Izmjene ocjena su pohranjene';
$string['quickgrading_help'] = 'Brzo ocjenjivanje omogućuje upisivanje ocjena (i ishoda) izravno u tablicu s predanim zadaćama. Brzo ocjenjivanje nije kompatibilno s naprednim ocjenjivanjem i nije preporučljivo ako više osoba ocjenjuje.';
$string['quickgradingresult'] = 'Brzo ocjenjivanje';
$string['recordid'] = 'Identifikator';
$string['requireallteammemberssubmit'] = 'Zahtijevaj predaju zadaće za sve članove grupe';
$string['requireallteammemberssubmit_help'] = 'Ako je omogućeno, svi članovi studentske grupe moraju kliknuti gumb za predaju, kako bi zadaća doista bila predana. Ako je onemogućeno, zadaća će se smatrati predanom čim bilo koji član grupe klikne gumb za predaju.';
$string['requiresubmissionstatement'] = 'Studenti moraju prihvatiti izjavu';
$string['requiresubmissionstatement_help'] = 'Zahtijeva od studenata prihvaćanje izjave prije predavanja zadaće (zadane na razini cijelog sjedišta). Ako ova postavka nije omogućena na razini sjedišta, onda se to može omogućiti / onemogućiti za svaku pojedinu zadaću.';
$string['revealidentities'] = 'Otkrij identitet studenata';
$string['revealidentitiesconfirm'] = 'Želite li uistinu otkriti identitet studenata za ovu zadaću? Ova operacija je nepovratna. Jednom kada otkrijete identitet studenata, ocjene će biti upisane u popis ocjena.';
$string['reverttodraft'] = 'Pretvori predanu zadaću u nacrt';
$string['reverttodraftforstudent'] = 'Pretvori predanu zadaću u nacrt za studenta: (id={$a->id}, puno ime={$a->fullname}).';
$string['reverttodraftshort'] = 'Pretvori u nacrt';
$string['reviewed'] = 'Pregledano';
$string['saveallquickgradingchanges'] = 'Pohrani sve promjene u brzom ocjenjivanju';
$string['savechanges'] = 'Pohrani promjene';
$string['savegradingresult'] = 'Ocjena';
$string['savenext'] = 'Pohrani i prikaži sljedeću';
$string['scale'] = 'Skala';
$string['selectedusers'] = 'Odabrani korisnici';
$string['selectlink'] = 'Odaberite...';
$string['selectuser'] = 'Odaberite {$a}';
$string['sendlatenotifications'] = 'Obavijesti nastavnike o kasnije predanim zadaćama';
$string['sendlatenotifications_help'] = 'Ako je omogućeno, ocjenjivači (obično nastavnici) će primiti poruku svaki puta kada student preda zadaću nakon roka predaje. Metode za isporuku poruka su promjenjive.';
$string['sendnotifications'] = 'Obavijesti nastavnike o predanim zadaćama';
$string['sendnotifications_help'] = 'Ako je omogućeno, ocjenjivači (obično nastavnici) će primiti poruku svaki puta kada student preda zadaću, u bilo koje vrijeme. Metode za isporuku poruka su promjenjive.';
$string['sendstudentnotifications'] = 'Obavijesti studente';
$string['sendsubmissionreceipts'] = 'Pošalji potvrdu o predanoj zadaći studentima';
$string['sendsubmissionreceipts_help'] = 'Ovo omogućuje da studenti prime obavijest o predanoj zadaći. Studenti će primiti poruku svaki puta kada uspješno predaju zadaću';
$string['settings'] = 'Postavke zadaće';
$string['showrecentsubmissions'] = 'Prikaži nedavno predane zadaće';
$string['status'] = 'Status';
$string['submission'] = 'Predaja';
$string['submissiondrafts'] = 'Zahtijevaj od studenata klik na gumb za predavanje zadaće';
$string['submissiondrafts_help'] = 'Ako je omogućeno, studenti trebaju kliknuti gumb za predaju, kako bi predaju proglasili konačnom. Ovo omogućuje studentima predati nacrt zadaće. Ako se postavka promijeni s "Ne" na "Da" nakon što su studenti zadaću predali, zadaće će biti smatrane konačnima.';
$string['submissioneditable'] = 'Studenti mogu nadograđivati zadaću';
$string['submissionempty'] = 'Ništa nije predano';
$string['submissionnoteditable'] = 'Studenti ne mogu nadograđivati zadaću';
$string['submissionnotready'] = 'Još nije omogućeno predavanje ove zadaće::';
$string['submissionplugins'] = 'Dodaci za predaju zadaće';
$string['submissionreceipthtml'] = 'Predali ste zadaću \'<i>{$a->assignment}</i>\'<br /><br /> Ovdje možete vidjeti <a href="{$a->url}">status predane zadaće</a>.';
$string['submissionreceipts'] = 'Pošalji potvrde o predanoj zadaći';
$string['submissionreceiptsmall'] = 'Predali ste zadacu - {$a->assignment}';
$string['submissionreceipttext'] = 'Predali ste zadacu - \'{$a->assignment}\'

Mozete ju pogledati ovdje:

     {$a->url}';
$string['submissions'] = 'Predane zadaće';
$string['submissionsclosed'] = 'Predaja zadaća je zatvorena';
$string['submissionsettings'] = 'Postavke predavanja zadaće';
$string['submissionslocked'] = 'Ova zadaća ne dopušta predavanje rada';
$string['submissionslockedshort'] = 'Izmjene zadaće nisu dopuštene';
$string['submissionsnotgraded'] = 'Neocijenjene zadaće: {$a}';
$string['submissionstatement'] = 'Izjava o zadaći';
$string['submissionstatementacceptedlog'] = 'Izjava o zadaći prihvaćena od korisnika {$a}';
$string['submissionstatementdefault'] = 'Izjavljujem da je ova zadaća moje djelo, osim u dijelovima gdje sam koristio i naveo reference na radove drugih osoba.';
$string['submissionstatement_help'] = 'Izjava o predanoj zadaći';
$string['submissionstatus'] = 'Stanje predane zadaće';
$string['submissionstatus_'] = 'Nema predanih zadaća';
$string['submissionstatus_draft'] = 'Nacrt (nije predano)';
$string['submissionstatusheading'] = 'Stanje predane zadaće';
$string['submissionstatus_marked'] = 'Ocijenjeno';
$string['submissionstatus_new'] = 'Nova zadaća';
$string['submissionstatus_reopened'] = 'Ponovno otvoreno';
$string['submissionstatus_submitted'] = 'Predano na ocjenjivanje';
$string['submissionsummary'] = '{$a->status}. Zadnja izmjena: {$a->timemodified}';
$string['submissionteam'] = 'Grupa';
$string['submissiontypes'] = 'Vrste zadaće';
$string['submitaction'] = 'Predaj';
$string['submitassignment'] = 'Predaj zadaću';
$string['submitassignment_help'] = 'Jednom kada predate zadaću, daljnje izmjene nisu moguće';
$string['submitted'] = 'Predano';
$string['submittedearly'] = 'Ranija predaja zadaće: {$a}';
$string['submittedlate'] = 'Zakašnjela predaja zadaće: {$a}';
$string['submittedlateshort'] = '{$a} kasnije';
$string['subplugintype_assignfeedback'] = 'Dodatak za povratne informacije';
$string['subplugintype_assignfeedback_plural'] = 'Dodaci za povratne informacije';
$string['subplugintype_assignsubmission'] = 'Dodatak za predaju zadaće';
$string['subplugintype_assignsubmission_plural'] = 'Dodaci za predaju zadaće';
$string['teamsubmission'] = 'Studenti predaju u grupama';
$string['teamsubmissiongroupingid'] = 'Grupacije za studentske grupe';
$string['teamsubmissiongroupingid_help'] = 'Ova će se grupacija koristiti za stvaranje studentskih grupa. Ako nije postavljeno, koristit će se zadani skup grupa.';
$string['teamsubmission_help'] = 'Ako je omogućeno, studenti će biti podijeljeni u grupe po zadanom skupu grupa, ili prilagođenoj grupaciji. Grupa studenata zajedno će predati zadaću, a svi članovi grupe će vidjeti sve promjene u zadaći.';
$string['teamsubmissionstatus'] = 'Stanje grupne predaje zadaće';
$string['textinstructions'] = 'Upute za zadaću';
$string['timemodified'] = 'Zadnja izmjena';
$string['timeremaining'] = 'Preostalo vrijeme';
$string['unlimitedattempts'] = 'Neograničeno';
$string['unlimitedattemptsallowed'] = 'Dopušten je neograničeni broj pokušaja predavanja.';
$string['unlocksubmissionforstudent'] = 'Dopusti predaju za studenta: (id={$a->id}, puno ime={$a->fullname}).';
$string['unlocksubmissions'] = 'Otključati zadaće';
$string['updategrade'] = 'Nadogradnja ocjene';
$string['updatetable'] = 'Pohrani i osvježi tablicu';
$string['upgradenotimplemented'] = 'Nadogradnja nije implementirana u dodatku ({$a->type} {$a->subtype})';
$string['userextensiondate'] = 'Produljenje roka do: {$a}';
$string['usergrade'] = 'Ocjena korisnika';
$string['userswhoneedtosubmit'] = 'Korisnici koji moraju predati zadaću: {$a}';
$string['viewfeedback'] = 'Pregled povratne informacije';
$string['viewfeedbackforuser'] = 'Pregled povratne informacije za korisnika: {$a}';
$string['viewfull'] = 'Pogledaj stranicu za ocjenjivanje';
$string['viewfullgradingpage'] = 'Otvori stranicu za ocjenjivanje radi upisa povratne informacije';
$string['viewgradebook'] = 'Prikaz ocjena';
$string['viewgrading'] = 'Prikaži/ocijeni sve predane zadaće';
$string['viewgradingformforstudent'] = 'Pregled stranice s ocjenama za studenta: (id={$a->id}, puno ime={$a->fullname}).';
$string['viewownsubmissionform'] = 'Pregled stranice s vlastitom predanom zadaćom';
$string['viewownsubmissionstatus'] = 'Pregled stranice s vlastitom predanom zadaćom';
$string['viewrevealidentitiesconfirm'] = 'Pregled stranice za otkrivanje identiteta studenata';
$string['viewsubmission'] = 'Prikaz predane zadaće';
$string['viewsubmissionforuser'] = 'Prikaz predane zadaće za korisnika: {$a}';
$string['viewsubmissiongradingtable'] = 'Prikaz tablice za ocjenjivanje predanih zadaća';
$string['viewsummary'] = 'Prikaz sažetka';
