<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Pristup zabranjen';
$string['accounts'] = 'Korisnički računi';
$string['addcategory'] = 'Dodaj kategoriju';
$string['additionalhtml'] = 'Dodatni HTML';
$string['additionalhtml_desc'] = 'Ove postavke vam omogućavaju određivanje HTML kôda koji želite dodati na svaku stranicu. HTML kôd koji dodate može biti dodan unutar oznake HEAD za svaku stranicu, odmah nakon otvaranja oznake BODY ili neposredno prije zatvaranja oznake BODY.<br />
Na ovaj način možete imati prilagođeno zaglavlje ili podnožje za svaku stranicu ili možete dodati podršku za usluge poput Google Analytics na jednostavan način, neovisno o temi koju trenutno koristite.';
$string['additionalhtmlfooter'] = 'Prije nego se zatvori BODY';
$string['additionalhtmlfooter_desc'] = 'Ovdje prikazani sadržaj će biti dodan na svaku stranicu neposredno prije zatvaranja oznake BODY.';
$string['additionalhtmlhead'] = 'Unutar HEAD';
$string['additionalhtmlhead_desc'] = 'Sadržaj prikazan ovdje će biti dodan na kraju HEAD-a na svakoj stranici.';
$string['additionalhtml_heading'] = 'Dodatni HTML k&#244;d koji će biti dodan na svaku stranicu.';
$string['additionalhtmltopofbody'] = 'Kad se otvori BODY';
$string['additionalhtmltopofbody_desc'] = 'Ovdje prikazani sadržaj će biti dodan na svaku stranicu odmah nakon otvaranja oznake BODY.';
$string['admincategory'] = 'Kategorija: {$a}';
$string['adminseesall'] = 'Administratori vide _SVE_';
$string['adminseesallevents'] = 'Administratori vide sve događaje (event)';
$string['adminseesownevents'] = 'Administratori su poput drugih korisnika';
$string['advancedfeatures'] = 'Napredne mogućnosti';
$string['allcountrycodes'] = 'Oznake svih zemalja';
$string['allowbeforeblock'] = 'Prvo će biti obrađen popis dopuštenih adresa';
$string['allowbeforeblockdesc'] = 'Uobičajeno je da se popis blokiranih IP adresa obrađuje prvi, no ako je omogućena ova opcija, onda se popis dopuštenih IP adresa obrađuje prije popisa blokiranih adresa.';
$string['allowblockstodock'] = 'Dopusti blokovima korištenje doka';
$string['allowcategorythemes'] = 'Dopusti odabir teme na razini kategorije';
$string['allowcoursethemes'] = 'Dopusti odabir teme na razini kolegija';
$string['allowediplist'] = 'Popis dopuštenih IP adresa';
$string['allowemailaddresses'] = 'Dopuštene domene e-pošte';
$string['allowframembedding'] = 'Dopusti umetanje okvira';
$string['allowframembedding_help'] = 'Dopusti ugradnju ovog sjedišta u okvire (frame) vanjskih sjedišta. Omogućavanje ove opcije se ne preporučuje iz sigurnosnih razloga.';
$string['allowguestmymoodle'] = 'Dopusti gostima pristup stranici Moja naslovnica';
$string['allowobjectembed'] = 'Dopusti EMBED i OBJECT tagove';
$string['allowthemechangeonurl'] = 'Dopusti promjenu teme u URL adresi';
$string['allowuserblockhiding'] = 'Dopusti korisnicima skrivanje blokova';
$string['allowuserswitchrolestheycantassign'] = 'Dopusti korisnicima koji inače nemaju mogućnost dodijeljivanja uloga pravo prebacivanja u druge uloge';
$string['allowuserthemes'] = 'Dopusti korisnicima odabir teme (izgleda sučelja)';
$string['antivirus'] = 'Anti-Virus';
$string['appearance'] = 'Izgled';
$string['aspellpath'] = 'Putanja do aspell';
$string['authentication'] = 'Autentikacija';
$string['authpreventaccountcreation'] = 'Spriječi stvaranje računa pri autentikaciji';
$string['authpreventaccountcreation_help'] = 'Kod autentikacije korisnika, korisnički račun se automatski stvara, ako još ne postoji. Ako se za autentikaciju koristi vanjska baza podataka, poput LDAP-a, ali želite omogućiti pristup sjedištu samo korisnicima koji već imaju korisničke račune, potrebno je omogućiti ovu opciju. Nove korisničke račune treba otvoriti ručno ili masovnim unosom korisnika. Napomena: ova se postavka ne odnosi na MNet autentikaciju.';
$string['authsettings'] = 'Uredi postavke autentikacije';
$string['autolang'] = 'Automatsko prepoznavanje jezika';
$string['autologinguests'] = 'Automatski prijavi goste';
$string['availablelicenses'] = 'Dostupne licence';
$string['availableto'] = 'Dostupno';
$string['backgroundcolour'] = 'Prozirna boja';
$string['backups'] = 'Backup datoteke';
$string['backup_shortname'] = 'Koristi naziv kolegija u nazivu backup datoteke';
$string['backup_shortnamehelp'] = 'Koristi naziv kolegija u nazivu backup datoteke';
$string['badwordsconfig'] = 'Unesite svoj popis nepristojnih/nepoželjnih riječi odvojenih zarezima.';
$string['badwordsdefault'] = 'Ako je vaš popis nepristojnih/nepoželjnih riječi prazna, koristit će se zadani popis za vaš jezik.';
$string['badwordslist'] = 'Popis nepristojnih/nepoželjnih riječi';
$string['blockediplist'] = 'Popis blokiranih IP adresa';
$string['blockinstances'] = 'Instance';
$string['blockmultiple'] = 'Višestruki';
$string['blockprotect'] = 'Zaštiti od brisanja';
$string['blockprotect_help'] = 'Ako zaključate određenu vrstu bloka, onda nitko neće moći dodati ili brisati instance tog bloka.(Blok možete, naravno, ponovno otključati ako je potrebno urediti njegove instance.

Svrha ovoga je zaštita bitnih blokova poput navigacije i postavki koje je jako teško ponovo vratiti ako ih netko slučajno izbriše.';
$string['blocksettings'] = 'Uredi blokove';
$string['blockunprotect'] = 'Ukloni zaštitu';
$string['bloglevel'] = 'Vidljivost bloga';
$string['bookmarkadded'] = 'Bookmark dodan.';
$string['bookmarkalreadyexists'] = 'Već ste spremili ovu stranicu u omiljene stranice..';
$string['bookmarkdeleted'] = 'Bookmark izbrisan.';
$string['bookmarkthispage'] = 'Pohrani u omiljene stranice';
$string['cacheapplication'] = 'Cache aplikacije';
$string['cacheapplicationhelp'] = 'Spremljene stavke (cached) dijele svi korisnici; one vrijede do definiranog datuma (ttl).';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'Javascript caching i kompresija uvelike poboljšavaju performanse pri učitavanju stranica. Preporučuje se za produkcijske poslužitelje. Programeri će za potrebe razvoja najvjerojatnije željeti onemogućiti ovu značajku.';
$string['cacherequest'] = 'Cache zahtjeva';
$string['cacherequesthelp'] = 'Posebni korisnicki cache koji istječe kad je zahtjev ispunjen. Namjena mu je da zamijeni područja gdje koristimo statičke spremnike.';
$string['cachesession'] = 'Cache sesije';
$string['cachesessionhelp'] = 'Spremište prilagođeno svakom korisniku, koje vrijedi dok ne završi korisnička sesija. Služi kako bi se spriječilo gomilanje sesija.';
$string['cachesettings'] = 'Cache postavke';
$string['cachetext'] = 'Text cache lifetime';
$string['caching'] = 'Caching';
$string['calendarexportsalt'] = 'Hash vrijednost za izvoz kalendara';
$string['calendarsettings'] = 'Kalendar';
$string['calendartype'] = 'Vrsta kalendara';
$string['calendar_weekend'] = 'Dani vikenda';
$string['cannotdeletemodfilter'] = 'Ne možete deinstalirati filtar \'{$a->filter}\' zato što je on dio modula \'{$a->module}\'.';
$string['cannotuninstall'] = '{$a} nije moguće deinstalirati.';
$string['cfgwwwrootslashwarning'] = 'Neispravno ste podesili $CFG->wwwroot u vašoj config.php datoteci. Unijeli ste i znak \'/\' na kraju adrese. Ispravite to ili možete očekivati čudne pogreške poput ove: <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Neispravno ste podesili $CFG->wwwroot u vašoj config.php datoteci. Ne podudara se sa URL-om stranice kojom pristupate ovoj stranici. Ispravite to ili možete očekivati čudne pogreške poput ove:
<a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'izmijeni';
$string['checkboxno'] = 'Ne';
$string['checkboxyes'] = 'Da';
$string['choosefiletoedit'] = 'Odabir datoteke za uređivanje';
$string['clamfailureonupload'] = 'U slučaju pogreške ClamAV';
$string['cleanup'] = 'Čišćenje';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'Pogreška, netočna vrijednost "{$a->value}" za "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Netočna vrijednost, pokušajte ponovno';
$string['clistatusdisabled'] = 'Status: onemogućeno';
$string['clistatusenabled'] = 'Status: omogućeno';
$string['clitypevalue'] = 'unesite vrijednost';
$string['clitypevaluedefault'] = 'unesite vrijednost ili pritisnite Enter za korištenje zadane vrijednosti ({$a})';
$string['cliunknowoption'] = 'Nepoznate opcije: {$a} Molimo koristite --help opciju.';
$string['cliupgradefinished'] = 'Nadogradnja putem naredbenog retka je uspješno provedena.';
$string['cliupgradenoneed'] = 'Nema potrebe za nadogradnjom instalirane inačice: {$a}. No, hvala na posjeti!';
$string['cliyesnoprompt'] = 'unesite y (znači da) ili n (znači ne)';
$string['commentsperpage'] = 'Broj komentara prikazanih po stranici';
$string['commonfiltersettings'] = 'Zajedničke postavke filtra';
$string['commonsettings'] = 'Zajedničke postavke';
$string['componentinstalled'] = 'Komponenta instalirana';
$string['computedfromlogs'] = 'Izračunato prema zapisima od {$a}.';
$string['condifmodeditdefaults'] = 'Vrijednosti koje postavite ovdje će biti zadane vrijednosti koje se koriste u postavkama aktivnosti pri stvaranju novih aktivnosti. Možete postaviti i koje se od postavki smatraju naprednima.';
$string['confeditorhidebuttons'] = 'Odaberite gumbe koji bi trebali biti skriveni u HTML uređivaču.';
$string['configallcountrycodes'] = 'Ovo je popis zemalja koje mogu biti odabrane na raznim mjestima, recimo na korisničkom profilu. Ako je prazan (zadano), koristit će se popis iz countries.php koji je dio standardnog engleskog jezičnog paketa. Taj popis je preuzet iz ISO 3166-1. U suprotnome trebate zadati dvoslovne vrijednosti odvojene zarezima, npr. \'HR,GB,ES\'. Ako dodate nove, nestandardne vrijednosti, morete ćete ih dodati i u countries.php datoteku, kako u \'en\' mapi, tako i u svoj jezični paket.';
$string['configallowassign'] = 'Možete dopustiti korisnicima koji imaju uloge s lijeve strane da dodijele neke od uloga ostalim korisnicima.';
$string['configallowblockstodock'] = 'Ako je omogućeno i podržano od odabrane tema, korisnici mogu premjestati blokove u posebni dok (desno).';
$string['configallowcategorythemes'] = 'Ako omogućite ovu opciju, onda će biti moguće zadati teme na razini kategorija. To će utjecati na sve podređene kategorije i kolegije sadržane u istima, osim ako ste za iste izričito zadali teme. UPOZORENJE: Omogućavanje ove opcije može utjecati na performanse (brzinu izvođenja).';
$string['configallowcoursethemes'] = 'Ako uključite ovu opciju, svaki kolegij može koristiti svoju vlastitu temu. Teme kolegija imaju prednost pred svim ostalim odabirima tema (na razini sitea, korisnika ili sesije).';
$string['configallowemailaddresses'] = 'Ako želite ograničiti unos adresa e-pošte samo s određenih domena, navedite ih ovdje, odvojene razmakom. Sve ostale domene bit će odbijene. Primjer: <strong>moj-fakultet.hr</strong>';
$string['configallowguestmymoodle'] = 'Ako je omogućeno, gosti će moći pristupiti stranici Moja naslovnica, u suprotnom bit će preusmjereni na naslovnicu sjedišta.';
$string['configallowobjectembed'] = 'U sklopu mjera sigurnosti, krajnjim korisnicima nije dopušteno umetanje multimedijalnih sadržaja (poput Flash sadržaja) unutar teksta korištenjem eksplicitnih tagova EMBED i OBJECT unutar HTML koda (iako je to i dalje moguće izvesti na sigurniji način putem mediaplugins filtera). Želite li ipak dopustiti uporabu ovih tagova, uključite ovu opciju.';
$string['configallowoverride'] = 'Možete dopustiti korisnicima s ulogama na lijevoj strani izmjenu ovlasti nekih od uloga u stupcu';
$string['configallowoverride2'] = 'Odaberite koje uloge mogu biti nadjačane od strane uloga u lijevom stupcu.<br/>Uzmite u obzir da se ove postavke primjenjuju samo na korisnika koji imaju omogućenu bilo spospobnost moodle/role:override ili moodle/role:safeoverride.';
$string['configallowswitch'] = 'Odaberite uloge u koje se korisnik može privremeno prebaciti, zasnovano na tome koju trajnu ulogu ima. Uz postavke u ovoj tablici, korisnik mora također imati sposobnost moodle/role:switchroles.<br/>Uzmite u obzir i da je moguće prebacivanje samo u uloge koje imaju sposobnost moodle/course:view i koje nemaju sposobnost moodle/site:doanything, te su zato neki o stupaca u ovoj tablici onemogućeni.';
$string['configallowthemechangeonurl'] = 'Ako je omogućeno, izmjena teme je moguća dodavanjem theme={themename} na bilo koji Moodle URL (npr: mymoodlesite.com/?theme=afterburner ) ili <br />&theme=themename na bilo koji interni Moodle URL (npr: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Želite li dopustiti korisnicima mogućnost prikazivanja/skrivanja blokova (s lijeve i desne strane sučelja) na ovom siteu? Ova opcija koristi Javascript i "cookies" za pamćenje stanja svakog bloka koji se može minimizirati, i utječe jedino na navedenog korisnika.';
$string['configallowuserthemes'] = 'Uključite li ovu opciju, korisnicima će biti dopušteno podešavanje vlastitih tema. Korisničke teme imaju prioritet nad temama na razini cijelog sitea (ali ne i nad temama na razini pojedinog kolegija)';
$string['configallusersaresitestudents'] = 'Vezano uz aktivnosti na naslovnici sitea, trebaju li SVI korisnici biti tretirani kao studenti? Ako odgovorite sa \'DA\', onda će svakom korisničkom računu biti dopušteno sudjelovanje u navedenim aktivnostima u ulozi studenta. Ako odgovorite sa \'NE\', jedino korisnici koji su polaznici barem JEDNOG kolegija će biti u stanju sudjelovati u aktivnostima na naslovnici sitea. Samo administratori i nastavnici s posebnim ovlastima mogu biti u ulozi nastavnika na razini naslovnice.';
$string['configauthenticationplugins'] = 'Molimo odaberite dodatke za autentikaciju koje želite koristiti i poredajte ih u redoslijedu koji osigurava prijavu, čak i u slučaju ne-funkcioniranja nekih od njih.';
$string['configautolang'] = 'Preuzmi zadani jezik iz postavki korisnikovog internet preglednika, ako je ova postavka onemogućena, bit će odabran jezik zadan na razini sustava.';
$string['configautologinguests'] = 'Trebaju li anonimni korisnici biti automatski prijavljeni sustavu kao gosti prilikom pokušaja pristupa kolegijima koji dopuštaju pristup gostima (anonimnim korisnicima)?';
$string['configbloglevel'] = 'Ova postavka vam omogućava ograničavanje razinu na kojoj se može vidjeti korisnički blog. Uzmite u obzir da to određuje najširi kontekst ČITATELJA, a ne autor ili vrsta blog članaka. Ako to želite, blogove možete isključiti u potpunosti.';
$string['configcachetext'] = 'Za veća sjedišta ili sjedišta koja koriste tekstualne filtre, ova postavka može značajno ubrzati rad. Kopije tekstova će biti zadržane u njihovom obrađenom obliku u vremenskom periodu zadanom ovdje (odnosno, tekstovi će biti privremeno pohranjeni sa linkovima koji su rezultat filtriranja). Zadavanje premale vrijednosti ovoj postavci bi moglo donekle usporiti rad, a zadavanje prevelike vrijednosti bi moglo rezultirati time da tekstovima treba previše vremena za osvježenje (npr. s novim poveznicama).';
$string['configcalendarcustomexport'] = 'Omogući izvoz kalendara s prilagođenim vremenskim rasponom';
$string['configcalendarexportsalt'] = 'Ovaj slučajno stvoreni tekst se koristi za poboljšanje sigurnosti autentikacijskih tokena koji se koriste za izvoz kalendara. Uzmite u obzir da svi dosad stvoreni tokeni postaju nevažeći ako promijenite ovu vrijednost.';
$string['configclamactlikevirus'] = 'Smatraj datoteke zaraženima';
$string['configclamdonothing'] = 'Smatraj datoteke čistima od virusa';
$string['configclamfailureonupload'] = 'Ako ste podesili ClamAV skeniranje prenešenih datoteka, ali je isti podešen neispravno ili ne uspijeva se izvršiti zbog nekog nepoznatog razloga, što bi se trebalo dogoditi? Ako odaberete \'Smatraj datoteke zaraženima\', one će biti ili premještene u karantenu ili izbrisane. Ako odaberete \'Smatraj datoteke čistima od virusa\', one će biti premještene u odredišnu mapu prema uobičajenoj proceduri. U oba slučaja će administratori dobiti obavijest da je ClamAV naišao na pogrešku. Ako odaberete  \'Smatraj datoteke zaraženima\' i zbog nekog se razloga ClamAV ne uspije izvršiti (obično jer je zadana pogrešna putanju - pathtoclam), SVE prenešene datoteke koje netko pokuša postaviti će biti ili premještene u karantenu ili izbrisane. Budite pažljivi s ovom postavkom.';
$string['configconvertformat'] = 'Ako su dostupni <i>latex</i>, <i>dvips</i> i <i>convert</i>, slike će biti stvorene u navedenom obliku. U suprotnome, bit će korišten mimeTeX koji će stvoriti GIF slike.';
$string['configcookiehttponly'] = 'Omogućava novu značajku PHP 5.2.0 - preglednici trebaju slati cookie datoteku samo s pravim HTTP zahtjevima, a cookie datoteke ne bi trebale biti dostupne skriptnim jezicima. Ovo nije podržano od strane svih preglednika i možda nije u potpunosti sukladno postojećem kodu. Pomaže u sprečavanju nekih vrsta XSS napada.';
$string['configcookiesecure'] = 'Ako poslužitelj prihvaća samo HTTPS veze, preporučljivo je da omogućite sigurne cookies datoteke. Ako ih omogućite, provjerite da poslužitelj ne prihvaća http:// ili podesite trajnu redirekciju na https:// adresu. Ako <em>wwwroot</em> ne počinje s https:// ova postavka je automatski onemogućena.';
$string['configcountry'] = 'Ako ovdje zadate državu, ista će biti standardno ponuđena za SVE nove korisničke račune. Kako bi obvezali korisnike na davanje informacije o državi iz koje dolaze, ostavite ovo polje praznim.';
$string['configcourseoverviewfileslimit'] = 'Najveći dopušteni broj datoteka koje mogu biti dodane u sažetak kolegija.';
$string['configcourserequestnotify'] = 'Upišite korisničko ime korisnika koji će biti obaviješten kada netko zatraži otvaranje novog kolegija.';
$string['configcourserequestnotify2'] = 'Korisnici koji će biti obaviješteni kada netko zatraži otvaranje novog kolegija. Ovdje su navedeni samo korisnici koji mogu odobravati zahtjev za otvaranjem novog kolegija.';
$string['configcoursesperpage'] = 'Odredite koliko kolegija će biti prikazano po stranici na popisu kolegija.';
$string['configcourseswithsummarieslimit'] = 'Najveći broj kolegija koji će biti prikazan na popisu kolegija s prikazom sažetka/opisa za svaki od njih. Kada se premaši taj broj, prikaz će se prebaciti na jednostavniji prikaz popisa.';
$string['configcronclionly'] = 'Ako je omogućeno, onda se cron skripta može pokrenuti samo iz naredbenog retka umjesto preko weba. Ova postavka ima prednost u odnosu na postavku lozinke za cron (dolje).';
$string['configcronremotepassword'] = 'Ovo znači da se cron.php skripta ne može pokrenuti kroz web preglednik bez pružanja lozinke u obliku URL: <pre>  http://site.example.com/admin/cron.php?password=opensesame </pre> Ako je ovo polje ostavljeno prazno, lozinka nije potrebna.';
$string['configcurlcache'] = 'Vrijeme trajanja za cURL CACHE, u sekundama.';
$string['configcustommenuitems'] = 'Ovdje možete podesiti prilagođeni izbornik koji će biti prikazan korisnicima. Svaki redak se sastoji od teksta poveznice, URL-a poveznice (opcionalno) i naslova tooltipa (opcionalno), odvojeno znakom \'pipe\'. Možete zadati i strukturu korištenjem znaka -. Npr:

<pre> Moodle community|http://moodle.org -Moodle free support|http://moodle.org/support -Moodle development|http://moodle.org/development --Moodle Tracker|http://tracker.moodle.org --Moodle Docs|http://docs.moodle.org -Moodle News|http://moodle.org/news Moodle company -Moodle commercial hosting|http://moodle.com/hosting -Moodle commercial support|http://moodle.com/support </pre>';
$string['configdbsessions'] = 'Ako je omogućeno, tada će se informacije o trenutnim sesijama pohranjivati u bazu podataka. Ovo je posebno korisno kod velikih/prometnih sjedišta smještenih na više poslužitelja. Za većinu sjedišta bi ova opcija trebala biti onemogućena kako bi se umjesto toga koristio diskovni prostor. Uzmite u obzir da promjena ove postavke automatski odjavljuje sve trenutno prijavljene korisnike (uključujući i vas). Ako koristite MySQL, osigurajte da je postavka \'max_allowed_packet\' u my.cnf (ili my.ini) podešena na barem 4M.';
$string['configdebug'] = 'Ako uključite ovu opciju, PHP error_reporting će prikazati više upozorenja no inače. Ova opcija je jedino korisna razvojnim timovima (programerima).';
$string['configdebugdisplay'] = 'Ako ovo uključite, izvještaji o pogreškama će biti zapisana u HTML stranicu. Ovo je praktično, ali nije kompatibilno s XHTML-om, JS-om i HTTP zaglavljima općenito. Ako ovo isključite, podaci će se zapisivati u zapise poslužitelja, omogućavajući bolji i lakši debug. Postavka PHP-a error_log uređuje u koji zapis se ovi podaci zapisuju.';
$string['configdebugpageinfo'] = 'Uključite ako želite da se informacije o stranici prikazuju u njenom podnožju.';
$string['configdebugsmtp'] = 'Uključivanje detaljnih informacija o uklanjanju pogrešaka prilikom slanja poruka e-pošte prema SMTP poslužitelju.';
$string['configdebugvalidators'] = 'Omogućite ovo ako želite imati poveznice na vanjske servere za validaciju u podnožju stranice. Možda ćete morati napraviti novi korisnički račun s imenom <em>w3cvalidator</em>, i omogućiti mu pristup kao gostu. Ove promjene mogu dopustiti neovlašteni pristup poslužitelju, nemojte ovo omogućavati na produkcijskim poslužiteljima!';
$string['configdefaulthomepage'] = 'Određuje početnu stranicu za prijavljene korisnike';
$string['configdefaultrequestcategory'] = 'Novi kolegiji čije otvaranje zatraže korisnici će biti automatski smješteni u ovu kategoriju.';
$string['configdefaultrequestedcategory'] = 'Zadana kategorija u koju će biti pohranjeni novootvoreni kolegiji (za koje je postavljen zahtjev za otvaranjem).';
$string['configdefaultuserroleid'] = 'Svi prijavljeni korisnici će na razini sjedišta dobiti sposobnosti uloga koje navedete ovdje, uz DODATAK ostalih sposobnosti koje su im dodijeljene kroz njihove uloge. Zadana vrijednost je uloga prijavljenog korisnika. Imajte na umu da ovo neće uzrokovati koliziju s drugim ulogama koje korisnici imaju (osim ako zabranite neke sposobnosti uloge), nego samo osigurava da svi korisnici imaju sposobnosti koje nije moguće dodijeliti na razini kolegija (npr. pisanje blog članaka, uređivanje vlastitog kalendara i slično).';
$string['configdeleteincompleteusers'] = 'Po isteku ovog roka, brišu se stari, nepopuni korisnički računi.';
$string['configdeleteunconfirmed'] = 'Ako koristite autentikaciju putem e-pošte, ovo je period unutar kojeg će korisnički odgovor biti prihvaćen. Nakon isteka ovog perioda, stari nepotvrđeni korisnički računi bit će izbrisani.';
$string['configdenyemailaddresses'] = 'Kako biste zabranili registraciju adresa e-pošte sa određenih domena, navedite ih ovdje razdvojene razmacima. Sve ostale domene bit će prihvaćene. Primjer: <strong>hotmail.com yahoo.com</strong>';
$string['configdisableuserimages'] = 'Onemogućavanje korisnika u mijenjanju izgleda slike u korisničkom profilu.';
$string['configdisplayloginfailures'] = 'Ova opcija omogućava prikaz informacije o pogreškama pri prijavljivanju sustavu korisnicima (failed logins).';
$string['configdndallowtextandlinks'] = 'Omogućavanje drag&drop metode za dodavanje teksta i poveznica na stranicu kolegija, uz dodavanje datoteka. Pazite, prijenos teksta u preglednik Firefox ili među različitim preglednicima nije pouzdan, pa se može dogoditi da se podaci ne prenesu, ili da se pogrešno prenesu.';
$string['configdocroot'] = 'Zadaje putanju do Moodle dokumentacije. Možete ju promijeniti ako želite koristiti vlastitu online dokumentaciju. Međutim, ako to učinite, morate osigurati da putanja u vašoj dokumentaciji podržava isti oblik kao na http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Ako ovo omogućite, poveznice na Moodle dokumentaciju će biti prikazane u novom prozoru.';
$string['configeditordictionary'] = 'Ova vrijednost se koristi ako aspell nema rječnik za jezik korisnika.';
$string['configeditorfontlist'] = 'Odaberite fontove koji će se pojaviti na popisu raspoloživih u uređivaču.';
$string['configemailchangeconfirmation'] = 'Zahtijevaj korak s potvrdom adrese e-pošte  kada korisnici izmjene adresu u svom profilu.';
$string['configenableajax'] = 'Ova postavka omogućuje kontrolu korištenja AJAX-a (napredno klijentsko/poslužiteljsko sučelje koje koristi JavaScript) na cijelom sustavu. AJAX je neophodan za drag and drop.';
$string['configenableblogs'] = 'Ako je omogućeno, svi korisnici na sjedištu mogu imati svoje vlastite blogove.';
$string['configenablecalendarexport'] = 'Omogući izvoz ili pretplatu na kalendare';
$string['configenablecomments'] = 'Omogući komentare';
$string['configenablecourserequests'] = 'Dopusti svim korisnicima podnošenje zahtjeva za otvaranjem novog kolegija.';
$string['configenabledevicedetection'] = 'Omogućava prepoznavanje pristupa putem mobitela, pametnih telefona, tableta ili standardnih uređaja (stolnih ili prijenosnih računala) - korisno za teme i druge značajke.';
$string['configenablegroupmembersonly'] = 'Ako je omogućeno, pristup aktivnostima može biti ograničen samo na članove grupe. Ovo može rezultirati povećanim opterećenjem poslužitelja. Dodatno, kategorije popisa ocjena moraju biti zadane na određen način kako bi se osiguralo da su aktivnosti skrivene od onih koji nisu članovi grupe.';
$string['configenablemobilewebservice'] = 'Uključite mobilni servis neophodan za službenu Moodle mobilnu aplikaciju ili neku drugu aplikaciju koja zahtijeva takav pristup. Za više informacije, posjetite {$a}';
$string['configenablerssfeeds'] = 'Uključuje RSS kanale na razini cijelog sustava (za blogove, forume, baze podataka i rječnike). Kako biste mogli vidjeti RSS kanale, morate osim ove opcije uključiti i RSS kanale na razini individualnih modula.';
$string['configenablerssfeedsdisabled'] = 'Nije dostupno jer su RSS kanali onemogućeni na razini sjedišta. Ako ih želite omogućiti, idite na Varijable u Admin podešavanjima.';
$string['configenablerssfeedsdisabled2'] = 'RSS kanali su onemogućeni na razini poslužitelja. Morate ih prethodno uključiti u Poslužitelj/RSS.';
$string['configenablesafebrowserintegration'] = 'Ovo dodaje opciju "Zahtijevaj Safe Exam Browser" u polje "Sigurnost preglednika" na obrascu za podešavanje postavki testa. Posjetite http://www.safeexambrowser.org/ za više informacija.';
$string['configenablestats'] = 'Ako odaberete \'da\', Moodle cronjob će obraditi zapise aktivnosti i prikupiti statistiku iz istih. Ovisno o količini prometa na vašem poslužitelju, to može potrajati. Ako ovo omogućite, vidjet ćete neke zanimljive grafove i statistiku za svaki od kolegija, kao i na razini cijelog sustava.';
$string['configenabletrusttext'] = 'Prema zadanim postavkama Moodle će uvijek temeljito očistiti tekst koji dolazi od korisnika kako bi uklonio sve moguće sigurnosne rizike poput zloćudnih skripti, multimedije i slično. Sustav pouzdanog sadržaja je način davanja mogućnosti postavljanja naprednih materijala bez dodatne provjere pojedinim korisnicima kojima vjerujete. Kako bi omogućili ovaj sustav, morate prvo omogućiti ovu postavku i onda dodijeliti sposobnost Pouzdani sadržaj određenoj Moodle ulozi. Tekstovi stvoreni ili prenešeni na poslužitelj od strane tih korisnika će biti označeni kao pouzdani i neće biti čišćeni prije prikaza.';
$string['configenablewebservices'] = 'Web servisi omogućuju drugim sustavima prijavu na vaš Moodle sustav i obavljanje određenih operacija. Za dodatnu sigurnost bi ova značajka trebala biti onemogućena osim ako ju uistinu ne koristite.';
$string['configenablewsdocumentation'] = 'Omogući automatsko stvaranje dokumentacije za web servise. Korisnik onda može pristupiti vlastitoj dokumentaciji na stranici sa sigurnosnim ključevima {$a}. Ista prikazuje samo dokumentaciju za omogućene protokole.';
$string['configerrorlevel'] = 'Odaberite razinu PHP upozorenja koja će vam se prikazivati na ekranu. Postavka Normal je obično najbolji odabir.';
$string['configexportlookahead'] = 'Koliko dana unaprijed se gleda prilikom izvoza';
$string['configexportlookback'] = 'Koliko dana unatrag se gleda prilikom izvoza';
$string['configextendedusernamechars'] = 'Uključite ovu opciju kako biste omogućili studentima uporabu SVIH znakova u njihovim korisničkim imenima (napomena: ovo se NE ODNOSI na njihova prava imena). Zadano je postavljena opcija \'netočno\' koja u korisničkim imenima isključivo dopušta uporabu alfanumeričkih znakova, podrcte (_), crtice (-), točke (.) ili AT (@).';
$string['configextramemorylimit'] = 'Neke skripte, kao što su one za pretraživanje, backup/vraćanje podataka ili cron zahtijevaju više memorije. Na velikim sustavima zadajte veće vrijednosti.';
$string['configfilterall'] = 'Filtriranje svih nizova (strings), uključujući naslove, nazive, navigacijske elemente i slično. Ovo je jedino korisno kod korištenja Višejezičnog filtera, u suprotnom previše opterećuje poslužitelj uz malu ili nikakvu korist.';
$string['configfiltermatchoneperpage'] = 'Filtri za automatsko stvaranje poveznica će stvoriti samo jednu poveznicu na prvoj odgovarajućoj instanci teksta koju pronađe na cijeloj stranici. Sve ostale identične instance na istoj stranici će biti zanemarene.';
$string['configfiltermatchonepertext'] = 'Filtri za automatsko stvaranje poveznica će stvoriti samo jednu poveznicu za prvu instancu teksta koju pronađe u nekom tekstu (npr. resursu, bloku) na nekoj stranici. Sve ostale instance su tada zanemarene. Ova postavka je zanemarena ako je postavka o automatskom stvaranju poveznice za cijelu stranicu podešena na <i>da</i>.';
$string['configfilteruploadedfiles'] = 'Uključivanje ove opcije će "natjerati" Moodle na filtriranje svih prenešenih HTML i tekstualnih datoteka prije samog prikaza.';
$string['configforcelogin'] = 'Uobičajeno su naslovnica i popis kolegija na njoj vidljivi anonimnim korisnicima (bez prijave sustavu). Ako želite obvezati korisnike da se prijave sustavu prije BILO KAKVOG PRIKAZA SADRŽAJA na siteu, onda uključite ovu opciju.';
$string['configforceloginforprofiles'] = 'Uključite ovu postavku kako bi obvezali korisnike da se prijave kao pravi korisnici (ne gosti) prije nego što mogu vidjeti stranice s osobnim podacima. Zadano je ova postavka onemogućena (postavljena na "netočno") kako bi potencijalni studenti mogli saznati informacije o nastavniku na pojedinom kolegiju, no ovo također znači kako ih mogu vidjeti i pretraživači (search-engine).';
$string['configfrontpage'] = 'Gore odabrani objekti bit će prikazani na naslovnici sustava.';
$string['configfrontpagecourselimit'] = 'Najveći dopušteni broj kolegija';
$string['configfrontpageloggedin'] = 'Gore odabrane stavke će biti prikazane na naslovnici kada korisnik bude prijavljen.';
$string['configfullnamedisplay'] = 'Ova postavka definira način prikazivanja punih imena korisnika. Zadana postavka "Ime + Prezime" je odgovarajuća za većinu jedno-jezičnih sjedišta, ali postoji i mogućnost skrivanja prezimena u potpunosti, kao i mogućnost zadavanja ove postavke putem pojedinog jezičnog paketa (neki od jezika preferiraju druge oblike pisanja).';
$string['configgeoipfile'] = 'Lokacija GeoIP City binarne datoteke. Ova datoteka nije dio Moodle distribucije i mora biti preuzeta odvojeno s adrese <a href="http://www.maxmind.com/">MaxMind</a>. Možete kupiti komercijalnu inačicu ili koristiti besplatnu.<br />Preuzmite datoteku s <a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a>  i otpakirajte u mapu "{$a}" na svom poslužitelju.';
$string['configgetremoteaddrconf'] = 'Ako je vaš poslužitelj iza tzv.reverse proxy-a, onda možete koristiti ovu postavku za određivanje kojim HTTP zaglavljima se može vjerovati da sadrže udaljene IP adrese. Zaglavlja se čitaju redom, koristeći prvi koji je dostupan.';
$string['configgradebookroles'] = 'Ova postavka vam omogućuje kontrolu nad time tko će se pojaviti na popisu ocjena (gradebook). Korisnici trebaju imati barem jednu od ovih uloga kako bi se na razini kolegija pojavili među korisnicima na popisu ocjena za taj kolegij.';
$string['configgradeexport'] = 'Odaberite koji će oblici za izvoz podataka iz popisa ocjena biti primarni načini izvoza podataka. Odabrani dodaci će onda podesiti i koristiti "zadnje izveženo" polje za svaku ocjenu. Npr. ovo može rezultirati time da se izveženi zapisi identificiraju kao \'novi\' ili \'osvježeni\'. Ako niste sigurni što biste podesili ovdje, ostavite onda ovo neoznačenim.';
$string['confighiddenuserfields'] = 'Odaberite koja polja s podacim želite skriti od ostalih korisnika (osim administratora i nastavnika). Ovo će povećati zaštitu privatnosti studenta. Držite CTRL za odabir više polja.';
$string['configidnumber'] = 'Ova postavka određuje (a) hoće li korisnici uopće biti pitani za ID broj, (b) hoće li korisnici biti pitani za ID broj, ali će navedeno polje moći ostaviti prazno ili (c) hoće li korisnicima unos u polje ID broj biti obavezan. Ako je ID broj unešen, isti se prikazuje u njihovom profilu.';
$string['configintro'] = 'Putem ove stranice moguće je podesiti veći broj konfiguracijskih varijabli koje bi trebale osigurati  nesmetan rad Moodle sustava na vašem poslužitelju. Nemojte se previše brinuti oko ovih postavki - zadane postavke (default) su obično dovoljne za ugodan i nesmetan rad sustava, a i uvijek možete ponovno otvoriti ovu stranicu i promijeniti neke od varijabli po potrebi.';
$string['configintroadmin'] = 'Putem ove stranice moguće je podesiti administratorski korisnički račun koji ima potpunu kontrolu nad cijelim sjedištem. Pobrinite se da date SIGURNO korisničko ime i lozinku, kao i VALJANU adresu e-pošte (prejednostavne lozinke, lozinke koje su iste kao i korisničko ime, kao i PRAZNA lozinka su OGROMNA sigurnosna rupa, pa navedeno izbjegnite pod svaku cijenu). Naknadno možete napraviti veći broj administratorskih korisničkih računa.';
$string['configintrosite'] = 'Putem ove stranice možete podesiti izgled naslovnice i naziv poslužitelja. Uvijek se možete naknadno vratiti na ovu stranicu i izmjeniti zadane postavke koristeći poveznicu "Postavke sjedišta" na naslovnici (ako ste prijavljeni kao administrator ili korisnik s posebnim pravima).';
$string['configiplookup'] = 'Kada kliknete na IP adresu (kao što je 34.12.222.93), npr. u zapisima o aktivnosti, prikazat će vam se karta na kojoj će biti prikazano gdje se taj IP otprilike nalazi. Postoje različiti dodaci, tako da možete odabrati onaj koji želite, a svaki ima svoje prednosti i nedostatke.';
$string['configkeeptagnamecase'] = 'Odaberite ove ako želite da imena oznaka zadrže  izvorna VELIKA i mala slova';
$string['configlang'] = 'Odaberite zadani jezik za cijeli poslužitelj. Korisnici mogu zadati vlastite postavke za svoj korisnički račun naknadno.';
$string['configlanglist'] = 'Ostavite ovu opciju praznom ako želite dati vašim korisnicima pravo na odabir BILO KOJEG jezičnog paketa kojeg imate instaliranog na razini Moodle sustava. Međutim, možete skratiti padajući jezični izbornik unošenjem željenih jezičnih kodova odvojenih zarezima. Primjer: en,hr,de,fr,it';
$string['configlangmenu'] = 'Odaberite želite li prikazati padajući izbornik za odabir jezika sučelja na naslovnici, stranici za prijavu sustavu, itd. Ova postavka ne onemogućava korisnika u odabiru željenog jezika sučelja putem opcije željenog jezika u njihovom osobnom profilu.';
$string['configlangstringcache'] = 'Pohrani sve jezične nizove kompajlirane datoteke u cache koji se nalazi u mapi s podacima. Ako prevodite Moodle ili mijenjate nizove u Moodle izvornom kôdu, tada ovo isključite. U suprotnome ostavite omogućeno zbog brzine izvršavanja.';
$string['configlatinexcelexport'] = 'Odaberite kodnu stranicu za izvoz podataka u Excel.';
$string['configlocale'] = 'Odaberite lokalne postavke na razini cijelog sustava Moodle, što će utjecati na oblik prikaza i jezik na kojem se ispisuju datumi. Navedene lokalne postavke morate prethodno imati instalirane unutar operativnog sustava poslužitelja. (primjer en_US). Ako ne znate što biste odabrali, ostavite ovo polje praznim.';
$string['configloginhttps'] = 'Uključivanjem ove postavke, Moodle će koristiti protokol HTTPS isključivo za stranicu prijave na sustav (login page), a nakon toga će se koristiti protokol HTTP, povećavajući time brzinu rada. OPREZ: ova postavka ZAHTJEVA da HTTPS bude omogućen i na vašem web poslužitelju - ako HTTPS nije podešen na poslužitelju, UKLJUČIVANJEM OVE POSTAVKE MOŽETE ONEMOGUĆITI PRISTUP Moodle sustavu SEBI I DRUGIMA!!';
$string['configloglifetime'] = 'Ovom postavkom možete zadati koliko dugo želite čuvati logove o korisničkoj aktivnosti. Logovi koji su stariji od zadanog roka će biti automatski izbrisani. Dobro je čuvati logove što je dulje moguće, u slučaju da vam zatrebaju, ali ako imate poslužitelj sa većim brojem korisnika i/ili imate zbog toga probleme s performansama, možda bi bilo bolje podesiti kraći vijek logova. Vrijednosti manje od 30 nisu preporučene jer tada neće raditi statistika.';
$string['configlookahead'] = 'Koliko dana unaprijed će biti prikazano';
$string['configmaxbytes'] = 'Ova postavka određuje maksimalnu veličinu prenešenih datoteka na razini cijelog poslužitelja. Vrijednosti ove postavke su ograničene PHP specifičnom postavkom upload_max_filesize i Apache postavkom LimitRequestBody.';
$string['configmaxconsecutiveidentchars'] = 'Lozinke ne smiju imati više od ovog broja uzastopnih identičnih znakova. Unesite 0 za onemogućavanje ove provjere.';
$string['configmaxeditingtime'] = 'Određuje količinu vremena koje korisnici imaju na raspolaganju za nakndano uređivanje forum poruka, rječničkih komentara i sličnih operacija. Uobičajena vrijednost od 30 minuta je obično zadovoljavajuća.';
$string['configmaxevents'] = 'Broj događaja koji se prate unaprijed';
$string['configmessaging'] = 'Treba li sustav instant poruka (messaging system) za komunikaciju među korisnicima sustava biti omogućen?';
$string['configmessagingallowemailoverride'] = 'Dopusti slanje poruka korisnicima i na adrese koje su različite od zadanih u njihovom profilu';
$string['configmessagingdeletereadnotificationsdelay'] = 'Obavijesti mogu biti izbrisane kako bi se oslobodio prostor na disku. Koliko dugo nakon što je obavijest pročitana se ista može izbrisati?';
$string['configmessaginghidereadnotifications'] = 'Skrij pročitane obavijesti o događajima poput poruka na forumu kod pregledavanja povijesti poruka';
$string['configminpassworddigits'] = 'Lozinka mora sadržavati barem ovoliko znamenki.';
$string['configminpasswordlength'] = 'Lozinka mora biti dugačka barem ovoliko znakova.';
$string['configminpasswordlower'] = 'Lozinka mora sadržavati barem ovoliko malih slova.';
$string['configminpasswordnonalphanum'] = 'Lozinka mora sadržavati barem ovoliko ne-alfanumeričkih znakova (npr. znakova interpunkcije).';
$string['configminpasswordupper'] = 'Lozinka mora sadržavati barem ovoliko velikih slova.';
$string['configmobilecssurl'] = 'CSS datoteka za prilagodbu sučelja za mobilnu aplikaciju.';
$string['configmodchooserdefault'] = 'Trebaju li odvojeni izbornici biti onemogućeni?';
$string['configmycoursesperpage'] = 'Najveći broj kolegija koji će biti prikazani na popisu korisnikovih kolegija';
$string['configmymoodleredirect'] = 'Ova postavka radi obveznu redirekciju na /my nakon prijave sustavu za ne-administratorske korisničke račune i mijenja početnu navigacijsku točku u /my';
$string['configmypagelocked'] = 'Onemogućava ne-administratore u uređivanju naslovnice';
$string['confignavcourselimit'] = 'Ograničava broj kolegija vidljiv korisniku kada nije prijavljen sustavu ili nije upisan na nijedan kolegij.';
$string['confignavshowallcourses'] = 'Ako je ovo omogućeno, korisnici će vidjeti kolegije na koje su prijavljeni i unutar navigacije "Moji kolegiji" i unutar stranice kolegija. Ako je ovo onemogućeno, korisnici koji su prijavljeni će vidjeti samo dio u navigaciji "Moji kolegiji". Broj prikazanih kolegija je i dalje ograničen postavkom "Course limit(navcourselimit)" kada korisnik nije prijavljen na sustav niti na kolegij.';
$string['confignavshowcategories'] = 'Prikaži kategorije kolegija u navigacijskoj traci i u navigacijskim blokovima. Ovo se ne odnosi na kolegije u koje je korisnik trenutno upisan, jer će se oni prikazati u dijelu mycourses bez kategorija.';
$string['confignotifyloginfailures'] = 'Ako postoji log o pogreškama pri prijavi sustavu (login failures), sustav može poslati poruku e-pošte o tome. Tko bi trebao dobiti navedenu poruku?';
$string['confignotifyloginthreshold'] = 'Ako su omogućene obavijesti o neuspjelim prijavama sustavu, koliko neuspjelih prijava pojedinačnog korisnika s određene IP adrese je potrebno za slanje obavijesti?';
$string['confignotloggedinroleid'] = 'Korisnici koji nisu prijavljeni na sjedište će biti tretirani kao da imaju ovu ulogu na razini cijelog sjedišta. Uloga gosta je ono što obično želite postaviti na ovom mjestu, ali možda želite stvoriti uloge koje su manje ili više restriktivne od iste. Akcije poput pisanja poruka će i dalje zahtijevati prijavu korisnika na sustav.';
$string['configopentogoogle'] = 'Ako ovo omogućite, tada će Google moći ući na vaše sjedište kao korisnik gost. Dodatno, svi posjetitelji koji dolaze na vaše sjedište kroz Google pretraživanje će automatski biti prijavljeni kao gosti. Uzmite u obzir da ovo pruža transparentni pristup samo onim kolegijima koji i sami pružaju pristup gostima.';
$string['configoverride'] = 'Zadano u config.php';
$string['configpasswordpolicy'] = 'Ako ovo omogućite, Moodle će provjeravati korisničke lozinke u skladu sa valjanim pravilima za lozinke. Upotrijebite postavke ispod kako bi odredili vaša pravila za lozinke (iste će biti zanemarene ako ovo postavite na \'Ne\').';
$string['configpathtoclam'] = 'Putanja do ClamAV alata. Vjerojatno nešto poput /usr/bin/clamscan ili /usr/bin/clamdscan. Ovu vrijednost je potrebno unijeti ako želite koristiti ClamAV.';
$string['configpathtodu'] = 'Putanja do du. Vjerojatno nešto poput /usr/bin/du. Ako ovo unesete, stranice koje prikazuju sadržaj mapa će se izvršavati puno brže za mape s puno datoteka.';
$string['configperfdebug'] = 'Ako ovo uključite, informacije o performansama će biti prikazaane u podnožju standardne teme';
$string['configprofileroles'] = 'Popis uloga koje su vidljive na korisničkim profilima i stranicama sudionika/polaznika.';
$string['configprofilesforenrolledusersonly'] = 'Kako bi onemogućili SPAM, opisi na korisničkim profilima onih korisnika koji nisu upisani ni u jedan kolegij su skriveni. Novi korisnici se moraju upisati na barem jedan kolegij prije nego mogu dodati navedeni opis.';
$string['configprotectusernames'] = 'Zadana je postavka da forget_password.php ne prikazuje nikakve savjete kojima bi omogućio lakše pogađanje korisničkih imena ili adresa e-pošte.';
$string['configproxybypass'] = 'Zarezima odvojeni popis (djelomičnih) naziva poslužitelja ili IP adresa koje mogu zaobići proxy (npr. 192.168., .domena.hr)';
$string['configproxyhost'] = 'Ako ovaj <b>poslužitelj</b> koristi proxy poslužitelj (ili vatrozid) kako bi pristupio Internetu, molimo unesite ime proxy poslužitelja u polje. U suprotnom, ostavite navedeno polje prazno.';
$string['configproxypassword'] = 'Lozinka koja je potrebna za korištenje proxy poslužitelja, prazno ako lozinka nije potrebna (PHP cURL ekstenzija je neophodna).';
$string['configproxyport'] = 'Ako ovaj poslužitelj mora koristiti PROXY poslužitelj, navedite PROXY port.';
$string['configproxytype'] = 'Vrsta proxy poslužitelja (PHP5 i cURL ekstenzija su neophodni za SOCKS5 podršku).';
$string['configproxyuser'] = 'Korisničko ime potrebno za pristup Internetu putem proxy poslužitelja ako je to neophodno, prazno ako korisničko ime nije potrebno (neophodna je PHP cURL ekstenzija).';
$string['configquarantinedir'] = 'Ako želite da ClamAV smjesti zaražene datoteke u mapu karantene, istu zadajte ovdje. Nad istom web poslužitelj mora imati ovlasti pisanja. Ako ovo ostavite praznim, ili ako zadate mapu koja ne postoji ili u koju ne može pisati, zaražene datoteke će biti izbrisane. Nemojte upisivati kosu crtu (slash) na kraju.';
$string['configrecaptchaprivatekey'] = 'Niz znakova koji služi za komunikaciju između vašeg Moodle poslužitelja i recaptcha.net poslužitelja. Možete ga dobiti posjetite li http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Niz znakova koji se koristi za prikaz reCAPTCHA elementa na obrascu za prijavu. Stvaraju se na http://www.google.com/recaptcha';
$string['configrequestcategoryselection'] = 'Dopusti odabir kategorije pri podnošenju zahtjeva za otvaranje novog kolegija';
$string['configrequestedstudentname'] = 'Naziv za studenta u zahtjevanim kolegijima';
$string['configrequestedstudentsname'] = 'Naziv za studente (množinu) u zahtjevanim kolegijima';
$string['configrequestedteachername'] = 'Naziv za nastavnika u zahtjevanim kolegijima';
$string['configrequestedteachersname'] = 'Naziv za nastavnike (množinu) u zahtjevanim kolegijima';
$string['configrequiremodintro'] = 'Isključite ovu opciju ako ne želite obvezati korisnike da unose opis za svaku aktivnost.';
$string['configrunclamavonupload'] = 'Kada je omogućeno, ClamAV će biti korišten za skeniranje svih prenešenih datoteka.';
$string['configrunclamonupload'] = 'Koristi ClamAV pri uploadu datoteka? Da bi ova postavka uspješno radila, morate navesti točno putanju u varijabli \'pathtoclam\'. (ClamAV je BESPLATAN antivirusni alat kojeg možete pronaći na http://www.clamav.net/)';
$string['configsectioninterface'] = 'Sučelje';
$string['configsectionmail'] = 'Mail';
$string['configsectionmaintenance'] = 'Održavanje';
$string['configsectionmisc'] = 'Razno';
$string['configsectionoperatingsystem'] = 'Operativni sustav';
$string['configsectionpermissions'] = 'Ovlasti';
$string['configsectionrequestedcourse'] = 'Zahtjevi za otvaranje novih kolegija';
$string['configsectionsecurity'] = 'Sigurnost';
$string['configsectionstats'] = 'Statistika';
$string['configsectionuser'] = 'Korisnik';
$string['configsessioncookie'] = 'Ova postavka prilagođava naziv cookie datotekte koju koriste Moodle sesije. Ovo je opcionalno, i jedino je korisno kako bi se lakše razlikovalo cookie datoteke kada postoji više od jedne instance Moodle-a na istome fizičkom poslužitelju.';
$string['configsessioncookiedomain'] = 'Ovo vam dopušta promjenu domene s koje su Moodle cookies datoteke dostupne. To je korisno za razne prilagodbe Moodle-a (npt. dodatke za autentikaciju ili upis) koji moraju dijeliti informacije o Moodle sesiji s web aplikacijom na drugoj poddomeni. <strong>UPOZORENJE: toplo preporučujemo da ostavite ovu postavku na zadanoj vrijednosti (prazno) - neispravna vrijednost može spriječiti bilo kakvu prijavu na sjedište.</strong>';
$string['configsessioncookiepath'] = 'Ako trebate promjeniti gdje će internet preglednici slati Moodle cookie datoteke, možete promijeniti postavke kako bi odredili mapu na vašem poslužitelju. U suprotnome, zadana postavka \'/\' je dovoljna.';
$string['configsessiontimeout'] = 'Ako korisnici na ovom sustavu miruju dulje vrijeme (bez učitavanja novih stranica), onda su automatski odjavljeni (tj. završava im sesija). Ova varijabla određuje koliko bi dugo to razdoblje trebalo biti.';
$string['configshowcommentscount'] = 'Prikaži broj komentara, trebat će izvršiti samo jedan upit više pri prikazu poveznice komentara';
$string['configshowicalsource'] = 'Prikaži informaciju o izvoru za ical događaje.';
$string['configshowsiteparticipantslist'] = 'Svi ovi studenti i nastavnici će biti navedeni na popisu sudionika. Tko će moći vidjeti taj popis?';
$string['configsitedefaultlicense'] = 'Zadana licenca sustava';
$string['configsitedefaultlicensehelp'] = 'Licenca za objavljivanje sadržaja zadana na razini sustava.';
$string['configsitemaxcategorydepth'] = 'Najveća dopuštena dubina kategorija';
$string['configsitemaxcategorydepthhelp'] = 'Određuje maksimalan broj potkategorija koji će biti prikazan.';
$string['configslasharguments'] = 'Datoteke (slike, prenešene datoteke i slično) se pružaju kroz skripte korištenjem tzv. \'slash argumenata\'. Ova metoda dopušta lakše smještanje datoteka u cache internet preglednika, proxy poslužitelja, i sl. Nažalost, neki PHP poslužitelji ne dopuštaju korištenje ovog načina, tako da ako imate problema s pregledom prenešenih datoteka ili slika (npr. slika korisnika), onda onemogućite ovu postavku.';
$string['configsmartpix'] = 'Ako je ovo uključeno, ikone se poslužuju kroz PHP skriptu koja pretražuje postojeću temu, pa nadređene teme i naposljetku Moodle /pix mapu. Ovo smanjuje potrebu za dupliciranjem slikovnih datoteka unutar tema, ali i ponešto povećava opterećenje poslužitelja.';
$string['configstartwday'] = 'Početak tjedna';
$string['configstatsfirstrun'] = 'Ovo određuje koliko daleko unatrag trebaju biti obrađivani zapisi kad cronjob <b>prvi put</b> pokrene statističku obradu. Ako imate puno prometa i nalazite se na dijeljenom poslužitelju, vjerojatno nije najbolja ideja ići predaleko u prošlost (jer bi navedena operacija mogla potrajati dugo i biti predstavljati prilično opterećenje za poslužitelj). (Imajte na umu da je za ovu postavku, 1 mjesec = 28 dana. U stvorenim grafikonima i izvještajima, 1 mjesec = 1 kalendarski mjesec.)';
$string['configstatsmaxruntime'] = 'Statistička obrada može biti razmjerno opterećujuća za vaš poslužitelj, tako da je preporučeno da koristite kombinaciju ovog polja i polja do istoga kako bi odredili kad se ista treba pokrenuti i koliko bi se dugo trebala izvršavati.';
$string['configstatsmaxruntime2'] = 'Statistička obrada može biti vrlo intenzivna, odredite najdulje vrijeme dopušteno za obradu jednog dana statistike. Maksimalni broj dana koje će cron obraditi u jednom izvršenju je 31.';
$string['configstatsmaxruntime3'] = 'Zadajte najdulje dopušteno vrijeme za izračun statistike za jedan dan, vodeći računa da statistička obrada može predstavljati veće opterećenje na poslužitelj. Najveći broj obrađenih dana u jednom pokretanju cron skripte može biti zadan dolje.';
$string['configstatsruntimedays'] = 'Odredite najveći broj dana koji će biti obrađeni pri svakom izvršavanju statističkog izračuna. Kada je statistika ažurna, bit će obrađivani samo dan za danom, tako da trebate podesiti ovu vrijednost ovisno o opterećenju vašeg poslužitelja, skraćujući interval ako je potrebno češće izvođenje cron-a.';
$string['configstatsruntimestart'] = 'Kada bi trebala započeti obrada statistike? Odredite različita vremena ako imate višestruke Moodle sustave na jednom fizičkom poslužitelju.';
$string['configstatsuserthreshold'] = 'Ova postavka određuje najmanji broj upisanih korisnika tečaja koji će biti obuhvaćeni u statistički izračun.';
$string['configstrictformsrequired'] = 'Ako je omogućeno, korisnici neće moći unositi znak razmaka ili prelaska u novi red - ali samo u traženim poljima u obrascu.';
$string['configstripalltitletags'] = 'Isključite ovu postavku kako bi dopustili uporabu HTML oznaka u nazivima aktivnosti i resursa.';
$string['configsupportemail'] = 'Ova adresa e-pošte će biti objavljena svim korisnicima na ovom sjedištu kao ona na kojoj mogu pronaći općenitu pomoć (npr. pri stvaranju novih korisničkih računa). Ako je ova adresa ostavljena prazna, tada poveznica na adresu e-pošte neće biti prikazana.';
$string['configsupportname'] = 'Ovo je ime osobe ili službe koja pruža pomoć / potporu korisnicima putem e-pošte ili web sučelja.';
$string['configsupportpage'] = 'Ova web adresa će biti objavljena svim korisnicima na ovom sjedištu kao ona na kojoj mogu pronaći općenitu pomoć (npr. pri stvaranju novih korisničkih računa). Ako je ova adresa ostavljena prazna, tada poveznica neće biti prikazana.';
$string['configthemedesignermode'] = 'Uobičajeno je da se sve slike teme kao i CSS pohranjuju u cache preglednika i na poslužitelju, zbog brzine izvršavanja. Ako dizajnirate temu ili razvijate izvorni k&#244;d onda vjerojatno želite uključiti ovaj način rada tako da svaki puta dobijete inačicu koja nije iz cache-a. Upozorenje: ovo će usporiti rad vašeg sjedišta za sve korisnike! Alternativno, možete postaviti pohranu teme u cache ručno na stranici za odabir teme.';
$string['configthemelist'] = 'Ostavite ovo praznim ako želite omogućiti korištenje BILO koje valjane teme. Ako želite skratiti izbornik s temama, možete ovdje zadati zarezima odvojena imena (Nemojte koristiti razmake!). Npr: standard,orangewhite.';
$string['configtimezone'] = 'Ovdje možete podesiti zadanu vremensku zonu. Ovo je samo ZADANA vremenska zona za prikaz datuma - svaki korisnik može na svojoj stranici promijeniti ovu postavku na svom profilu. "Vrijeme poslužitelja" zadano ovdje će postaviti vrijeme operativnog sustava na kojem se Moodle izvršava, a "Vrijeme poslužitelja" na korisničkom profilu će podesiti zadano vrijeme korisnika. Cronjob koji ovisi o dijelu dana (dan/noć) će koristiti informaciju iz ove vremenske zone.';
$string['configuseblogassociations'] = 'Trebaju li korisnici biti u mogućnosti organizirati svoj blog povezivanjem članaka s kolegijima i modulima kolegija?';
$string['configuseexternalyui'] = 'Koristi online datoteke dostupne na Yahoo poslužiteljima umjesto lokalnih datoteka. UPOZORENJE: Ovo zahtijeva internet pristup, inače na vašem poslužitelju neće raditi nijedna instanca AJAX-a. Ova postavka nije kompatibilna sa sjedištima koja koriste https.';
$string['configuserquota'] = 'Najveća količina bajtova koje korisnik može pohraniti u prostoru za osobne datoteke. {$a->bytes} bajtova == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Ako je omogućeno, u navigaciji će se koristiti kratki naziv sjedišta umjesto niza "Stranice sjedišta"';
$string['configusetags'] = 'Trebaju li oznake biti omogućene na cijelom poslužitelju?';
$string['configvariables'] = 'Varijable';
$string['configverifychangedemail'] = 'Omogućuje provjeru promijenjenih adresa e-pošte korištenjem postavke o dopuštenim i nedopuštenim domenama e-pošte. Ako je ova postavka onemogućena, postavka o domenama se koristi jedino pri stvaranju novih korisnika.';
$string['configvisiblecourses'] = 'Prikaži tečajeve u skrivenim kategorijama normalno';
$string['configwarning'] = 'Pažljivo mijenjajte ove postavke - neobične vrijednosti mogu uzrokovati probleme.';
$string['configyuicomboloading'] = 'Ova opcija omogućava optimizaciju učitavanja kombiniranih datoteka YUI biblioteka. Ova postavka treba biti omogućena na produkcijskim poslužiteljima zbog boljih performansi.';
$string['confirmation'] = 'Potvrda';
$string['confirmdeletecomments'] = 'Izbrisati ćete komentare, jeste li sigurni?';
$string['confirmed'] = 'Potvrđeno';
$string['convertformat'] = '<i>convert</i> izlazni oblik';
$string['cookiehttponly'] = 'Samo HTTP cookies';
$string['cookiesecure'] = 'Samo sigurni cookies (HTTPS)';
$string['country'] = 'Zadana država';
$string['coursecontact'] = 'Kontakti - kolegij';
$string['coursecontact_desc'] = 'Ova postavka vam omogućava kontrolu nad time tko se pojavljuje na stranici s opisom kolegija. Korisnici moraju imati barem jednu od ovih uloga na dotičnom kolegiju kako bi bili prikazani na stranici s opisom kolegija.';
$string['courselistshortnames'] = 'Prikaži pune naslove kolegija';
$string['courselistshortnames_desc'] = 'Prilikom prikazivanja popisa kolegija ili prilikom referiranja na kolegije na stranici za administraciju, prikaži kratki, kao i puni naslov kolegija. U stvari, kada omogućite ovu postavku, koristi se jezični niz \'courseextendednamedisplay\', te ga možete promijeniti u željeni oblik korištenjem prilagodbe jezičnog paketa.';
$string['coursemgmt'] = 'Dodaj/uredi kolegije';
$string['courseoverview'] = 'Pregled kolegija';
$string['courserequestnotify'] = 'Obavijest o zahtjevu za otvaranje novog kolegija';
$string['courserequestnotifyemail'] = 'Korisnik {$a->user} je zatrazio novi kolegij na {$a->link}';
$string['courserequests'] = 'Zahtjevi za otvaranjem novog kolegija';
$string['courserequestspending'] = 'Zahtjevi na čekanju';
$string['courses'] = 'Kolegiji';
$string['coursesperpage'] = 'Broj kolegija po stranici';
$string['courseswithsummarieslimit'] = 'Broj kolegija sa sažetkom/opisom';
$string['creatornewroleid'] = 'Uloga autora u novim kolegijima';
$string['creatornewroleid_help'] = 'Ako korisnik nema otprije ovlasti za uređivanje i vođenje novog kolegija, onda se automatski upisuje korištenjem ove uloge.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Pokretanje Crona isključivo preko naredbenog retka';
$string['cronerrorclionly'] = 'Nažalost, internet pristup ovoj stranici je onemogućen od strane administratora.';
$string['cronerrorpassword'] = 'Nažalost, niste unijeli valjanu lozinku za pristup ovoj stranici';
$string['cron_help'] = 'Cron.php pomaže nekima od Moodle modula u obavljanju zadaća na redovnoj bazi, kao što je slanje e-pošte o novim porukama na forumu. Potrebno je redovito pokretati skriptu, npr. svakih 5 minuta.';
$string['cronremotepassword'] = 'Cron lozinka za udaljeni pristup i pokretanje';
$string['cronwarning'] = '<a href="cron.php">cron.php skripta za održavanje</a> nije pokrenuta barem zadnjih 24 sata.';
$string['ctyperecommended'] = 'Instalacija opcionalne PHP ekstenzije ctype je biblioteke je toplo preporučena kako bi unaprijedili funkcioniranje sustava, posebno ako koristite ne-latinične jezike.';
$string['ctyperequired'] = 'ctype PHP ekstenzija je sada neophodna za rad Moodle-a, kako bi se unaprijedila brzina izvršavanja i pružila višejezična kompatibilnost.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrecommended'] = 'Instalacija opcionalne cURL biblioteke je toplo preporučena ako želite koristiti MNet funkcionalnost.';
$string['curlrequired'] = 'PHP ekstenzija cURL je sada obvezna zbog komunikacije Moodle poslužitelja i Moodle repozitorija.';
$string['curltimeoutkbitrate'] = 'Brzina protoka u bitovima koja se koristi prilikom izračuna cURL timeout-a (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Ova postavka se koristi za računanje prikladnog vremena isteka tijekom dugih cURL poziva. Kao dio ovog proračuna, šalje se HTTP HEAD zahtjev kako bi se utvrdila veličina sadržaja. Postavljanje na 0 onemogućuje slanje ovog zahtjeva.';
$string['currenttheme'] = 'Trenutna tema';
$string['customcheck'] = 'Ostale provjere';
$string['custommenu'] = 'Prilagođeni izbornik';
$string['custommenuitems'] = 'Stavke na prilagođenom izborniku';
$string['datarootsecurityerror'] = '<p><strong>SIGURNOSNO UPOZORENJE!</strong></p><p>Vaša dataroot mapa se nalazi na krivoj lokaciji i dostupna je putem weba. Ovo znači da su sve vaše privatne datoteke dostupne svima u svijetu, i da neke od njih mogu biti iskorištene od strane hakera kako bi neovlašteno pristupili vašem poslužitelju!</p>
<p><em>MORATE</em> premjestiti dataroot mapu ({$a}) na novu lokaciju koja nije unutar vaše javno dostupne web mape i potom promijeniti postavku <code>$CFG->dataroot</code> u vašoj config.php datoteci.</p>';
$string['datarootsecuritywarning'] = 'Konfiguracija vašeg poslužitelja možda nije sigurna. Molimo provjerite da se vašoj osnovnoj mapi s podacima ({$a}) ne može pristupiti direktno preko weba.';
$string['dbmigrate'] = 'Migracija Moodle baze podataka';
$string['dbmigrateconnecerror'] = 'Nije moguće povezivanje na tu bazu podataka.';
$string['dbmigrateencodingerror'] = 'Navedena baza podataka ima kodnu stranicu {$a} umjesto tražene UNICODE/UTF8.<br/>Odaberite neku drugu.';
$string['dbmigratewarning'] = 'Molimo provjerite jeste li napravili backup svoje Moodle baze podataka prije početka ovog postupka. Ako niste sigurni kako to učiniti, obratite se vašem administratoru. Vaš Moodle sustav će biti stavljen u stanje održavanja sustava nakon pokretanja procesa migracije';
$string['dbmigratewarning2'] = '<b>Upozorenje: Pokrenut ćete migraciju baze podataka. Provjerite jeste li prije toga napravili backup cijele baze podataka.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Ova baza je premještena u novu UTF8 bazu podataka i zastarjela. Uredite config.php i koristite novu bazu podataka za ovaj Moodle sustav.</font>';
$string['dbmigrationdupfailed'] = 'Duplikacija baze podataka nije uspjela uz moguću pogrešku: <font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Koristi bazu podataka za informacije o sesiji';
$string['debug'] = 'Debug poruke';
$string['debugall'] = 'SVE: Prikaz svih razumljivih PHP poruka o pogreškama';
$string['debugdeveloper'] = 'RAZVOJNE: Prikaz dodatnih Moodle poruka o pogreškama i njihovom otklanjanju, namijenjenih samo onima koji razvijaju ovaj softver.';
$string['debugdisplay'] = 'Prikaži debug poruke';
$string['debugging'] = 'Otklanjanje pogrešaka';
$string['debugminimal'] = 'MINIMALNO: Prikaz samo kritičnih pogrešaka';
$string['debugnone'] = 'BEZ OTKLANJANJA: Bez prikaza bilo kakvih pogrešaka ili upozorenja';
$string['debugnormal'] = 'NORMALNO: Prikaz pogrešaka, upozorenja i obavijesti';
$string['debugpageinfo'] = 'Prikaži informaciju o stranici';
$string['debugsmtp'] = 'Provjeri (debug) slanje e-pošte';
$string['debugstringids'] = 'Prikaži porijeklo jezičnih nizova';
$string['debugstringids_desc'] = 'Ova opcija je namijenjena kao pomoć prevoditeljima. Kada je omogućena, ako dodate parametar strings=1, to će prikazati jezičnu datoteku i ID niza pored svakog niza.';
$string['debugvalidators'] = 'Prikaži poveznice na validatore (servise za provjeru sukladnosti standardima)';
$string['defaultcity'] = 'Zadani grad';
$string['defaultcity_help'] = 'Grad koji ovdje unesete će biti zadan za sve novostvorene korisničke račune.';
$string['defaultformatnotset'] = 'Pogreška pri određivanju zadanog oblika kolegija. Molimo provjerite postavke sjedišta.';
$string['defaulthomepage'] = 'Zadana naslovnica za korisnike';
$string['defaultrequestcategory'] = 'Zadana kategorija za nove kolegije';
$string['defaultsettinginfo'] = 'Zadano: {$a}';
$string['defaultuserroleid'] = 'Zadana uloga za sve korisnike';
$string['deleteincompleteusers'] = 'Izbriši nedovršene korisničke račune nakon';
$string['deleteunconfirmed'] = 'Izbrisati nepotvrđene korisnike nakon';
$string['deleteuser'] = 'Izbriši korisnika';
$string['density'] = 'Gustoća';
$string['denyemailaddresses'] = 'Zabranjene domene e-pošte';
$string['development'] = 'Razvoj';
$string['devicedetectregex'] = 'Regularni izrazi za otkrivanje uređaja';
$string['devicedetectregex_desc'] = '<p>Zadano, Moodle može prepoznati sljedeće vrste uređaja: default (osobna računala, laptopi...), mobile (mobiteli), tablet (iPadi, Android tableti) i legacy (korisnici IE 6). Alat za odabir teme se može koristiti da se pojedinačne teme primijene na svaki od ovih tipova. Ova postavka omogućuje korištenje regularnih izraza za prepoznavanje dodatnih vrsta uređaja (koje imaju prednost nad zadanim vrstama). </p>
<p>Na primjer, možete unijeti regularni izraz \'/(MIDP-1.0|Maemo|Windows CE)/\' kako biste prepoznali često korištene mobitele s dodatnim mogućnostima (featurephone), uz dodavanje povratne vrijednosti \'featurephone\'. Ovo dodaje \'featurephone\' u alat za odabir teme, kako biste odabrali temu koja će biti korištena na tim uređajima. Drugi telefoni će i dalje koristiti temu odabranu za vrstu uređaja mobile.</p>';
$string['devicedetectregexexpression'] = 'Regularni izraz';
$string['devicedetectregexvalue'] = 'Povratna vrijednost';
$string['devicetype'] = 'Vrsta uređaja';
$string['disableuserimages'] = 'Isključi slike u korisničkom profilu';
$string['displayerrorswarning'] = 'Omogućavanje PHP postavke <em>display_errors</em> nije preporučljivo na produkcijskim poslužiteljima jer neke od poruka o pogrešci mogu otkriti osjetljive informacije o vašem poslužitelju.';
$string['displayloginfailures'] = 'Prikaži pogreške o prijavi na sustav';
$string['dndallowtextandlinks'] = 'Prijenos teksta/poveznica "dovlačenjem mišem" (drag&drop)';
$string['docroot'] = 'Moodle Docs korijenska mapa';
$string['doctonewwindow'] = 'Otvori u novom prozoru';
$string['download'] = 'Preuzimanje';
$string['edithelpdocs'] = 'Uredi dokumente s pomoći';
$string['editingnoncorelangfile'] = 'Pokušavate izmijeniti prijevod za dodatni modul/dodatak. Prijevod vanjskih modula možete pohraniti samo u vašoj _local mapi. Možda želite premjestiti datoteku s prijevodom u jezičnu mapu dotičnog modula i/ili ga poslati razvijatelju istoga.';
$string['editlang'] = '<b>Uređivanje</b>';
$string['editorbackgroundcolor'] = 'Pozadinska boja';
$string['editordictionary'] = 'Rječnik uređivača';
$string['editorfontfamily'] = 'Obitelj fontova';
$string['editorfontlist'] = 'Popis pisama (fontova)';
$string['editorfontsize'] = 'Veličina pisma';
$string['editorhidebuttons'] = 'Skriveni gumbi';
$string['editorkillword'] = 'Filtar Word oblika';
$string['editorspelling'] = 'Provjera pravopisa u uređivaču';
$string['editorspellinghelp'] = 'Uključi/isključi provjeru pravopisa. Kad je uključeno, <strong>aspell</strong> mora biti instaliran na poslužitelju.';
$string['editstrings'] = 'Uredi riječi ili fraze';
$string['emailchangeconfirmation'] = 'Potvrda izmjene adrese e-pošte';
$string['emoticonalt'] = 'Alternativni tekst';
$string['emoticoncomponent'] = 'Slikovna komponenta';
$string['emoticonimagename'] = 'Naziv slike';
$string['emoticons'] = 'Emotikoni';
$string['emoticons_desc'] = 'Na ovoj stranici možete podesiti emotikone koji će se koristiti na vašem sjedištu. Kako bi uklonili red iz tablice, pohranite obrazac s praznim vrijednostima. Kako bi zadali novi emotikon, popunite polja u zadnjem praznom redu. Kako bi sve vrijednosti vratili na inicijalno zadane vrijednosti, kliknite na poveznicu prikazanu gore.

* Tekst (obvezno) - Ovaj tekst će biti zamijenjen sa slikom emotikona. Mora sadržavati barem 2 znaka.
* Naziv slike (obvezno) - Slika emotikona bez ekstenzije, relativno u odnosu na pix mapu komponente.
* Komponenta slike (obvezno) - Komponenta koja pruža ikonu.
* Alternativni tekst (opcionalno) - Identifikator niza i komponente alternativnog teksta emotikona.';
$string['emoticonsreset'] = 'Vrati postavke emotikona na zadane vrijednosti';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Prazno';
$string['enableajax'] = 'Omogući AJAX';
$string['enableblogs'] = 'Omogući blogove';
$string['enablecalendarexport'] = 'Omogući izvoz kalendara';
$string['enablecomments'] = 'Omogući komentare';
$string['enablecourserequests'] = 'Omogući postavljanje zahtjeva za otvaranje novih kolegija';
$string['enablecssoptimiser'] = 'Omogući CSS optimiziranje';
$string['enablecssoptimiser_desc'] = 'Kada je ovo omogućeno, CSS će prije spremanja biti optimiziran. U tom procesu uklonit će se duplo unesena pravila i stilove, kao i višak praznih mjesta, te će se datoteka preoblikovati. Napomena: ako ovo omogućite u isto vrijeme kada je omogućen dizajnerski način rada, performanse će biti vrlo loše, no to će pomoći dizajnerima tema da stvore optimizirani CSS.';
$string['enabledevicedetection'] = 'Omogući prepoznavanje uređaja';
$string['enablegravatar'] = 'Omogući Gravatar';
$string['enablegravatar_help'] = 'Kada je ova opcija omogućena, Moodle će pokušati preuzeti profilnu sliku s Gravatara ako korisnik nije sam postavio svoju profilnu sliku.';
$string['enablegroupmembersonly'] = 'Omogući samo za članove grupe';
$string['enablemobilewebservice'] = 'Omogući mobilne web servise';
$string['enablerecordcache'] = 'Uključi CACHE za zapise';
$string['enablerssfeeds'] = 'Omogući RSS kanale';
$string['enablesafebrowserintegration'] = 'Omogući Safe Exam Browser integraciju';
$string['enablestats'] = 'Omogući statistiku';
$string['enabletrusttext'] = 'Omogući pouzdani sadržaj';
$string['enablewebservices'] = 'Omogući web servise';
$string['enablewsdocumentation'] = 'Dokumentacija web servisa';
$string['enrolinstancedefaults'] = 'Zadane vrijednosti instanci upisa';
$string['enrolinstancedefaults_desc'] = 'Zadane postavke upisa na nove kolegije.';
$string['enrolmultipleusers'] = 'Upiši korisnike';
$string['environment'] = 'Okruženje';
$string['environmenterrortodo'] = 'Morate riješiti probleme/pogreške u vašem poslužiteljskom okružejnu (environment) prije započinjanja instalacije ove inačice Moodle-a!';
$string['environmenterrorupgrade'] = 'Upozorenje: trebalo bi razriješiti sve pronađene pogreške u okruženju (environment) prije nastavka nadogradnje ove inačice Moodle-a! Nadogradnja bez rješavanja tih problema može prouzrokovati ozbiljne probleme kao što je, npr. gubitak podataka. Jeste li sigurni da želite nastaviti s nadogradnjom?';
$string['environmentmustfixsetting'] = 'Postavke PHP-a moraju biti promijenjene.';
$string['environmentok'] = 'Vaše poslužiteljsko okruženje zadovoljilo je sve minimalne zahtjeve.';
$string['environmentrecommendcustomcheck'] = 'ako se ovaj test ne izvrši uspješno, postoji mogućnost pojavljivanja potencijalnog problema';
$string['environmentrecommendinstall'] = 'je preporučljivo instalirati/omogućiti';
$string['environmentrecommendversion'] = 'preporučena inačica je {$a->needed}, a vi trenutno koristite inačicu {$a->current}';
$string['environmentrequirecustomcheck'] = 'ovaj test se mora proći';
$string['environmentrequireinstall'] = 'je neophodno instalirati/omogućiti';
$string['environmentrequireversion'] = 'neophodna inačica je {$a->needed}, a vi trenutno koristite inačicu {$a->current}';
$string['environmentsettingok'] = 'preporučene postavke su pronađene';
$string['environmentshouldfixsetting'] = 'Postavka PHP-a mora biti promijenjena.';
$string['environmentxmlerror'] = 'Pogreška u čitanju podataka okruženja ({$a->error_code})';
$string['errordeletingconfig'] = 'Dogodila se pogreška pri brisanju zapisa o konfiguraciji za dodatak \'{$a}\'.';
$string['errorsetting'] = 'Nije bio moguće pohraniti postavke:';
$string['errorwithsettings'] = 'Neke postavke nisu promijenjene uslijed pogreške.';
$string['everyonewhocan'] = 'Svi koji mogu \'{$a}\'';
$string['exceptions'] = 'iznimke';
$string['experimental'] = 'Eksperimentalno';
$string['experimentalsettings'] = 'Eksperimentalne postavke';
$string['extendedusernamechars'] = 'Dopusti prošireni skup znakova u korisničkim imenima';
$string['extramemorylimit'] = 'Dodatno PHP memorijsko ograničenje';
$string['fatalmagicquotesruntime'] = '<p>Pronađena je ozbiljna pogreška u postavkama, obavijestite administratora poslužitelja.</p><p> Kako bi uspješno radio, Moodle zahtijeva promjenu u PHP postavkama od strane administratora.</p><p><code>magic_quotes_runtime</code> mora biti postavljeno na <code>off</code>.</p><p>Ova postavka se mijenja u <code>php.ini</code>, Apache/IIS <br />postavkama ili <code>.htaccess</code> datoteci na poslužitelju.</p>';
$string['filecreated'] = 'Stvorena je nova datoteka';
$string['filestoredin'] = 'Pohrani datoteku u mapu :';
$string['filestoredinhelp'] = 'Gdje će biti pohranjene datoteke';
$string['filterall'] = 'Filtriraj sve nizove (strings)';
$string['filtermatchoneperpage'] = 'Podudaranje filtra jednom po stranici';
$string['filtermatchonepertext'] = 'Podudaranje filtra jednom u cijelom tekstu';
$string['filters'] = 'Filtri';
$string['filtersettings'] = 'Uredi filtre';
$string['filtersettingsgeneral'] = 'Općenite postavke filtra';
$string['filteruploadedfiles'] = 'Filtar prenešenih datoteka';
$string['forcelogin'] = 'Obvezno prijavljivanje korisnika na sustav';
$string['forceloginforprofileimage'] = 'Obveži korisnike na prijavu ako žele gledati korisničke slike (profil)';
$string['forceloginforprofileimage_help'] = 'Ako je omogućeno, korisnici se moraju prijaviti sustavu kako bi vidjeli profilne slike drugih korisnika, a zadana korisnicka slika ce biti korištena u svim porukama e-pošte.';
$string['forceloginforprofiles'] = 'Obvezno prijavljivanje korisnika za pregled profila';
$string['forcetimezone'] = 'Obvezna zadana vremenska zona';
$string['formatuninstallwithcourses'] = 'Postoji {$a->count} kolegij(a) za koje se koristi oblik {$a->format}. Njihov oblik će biti pretvoren u {$a->defaultformat} (što je zadani oblik na ovom sjedištu). Neki podaci koji su specifični za oblik koji brišete će biti izgubljeni. Želite li uistinu nastaviti?';
$string['frontpage'] = 'Naslovnica';
$string['frontpagebackup'] = 'Backup naslovnice';
$string['frontpagedefaultrole'] = 'Zadana uloga za naslovnicu';
$string['frontpagefilters'] = 'Filtri na naslovnici';
$string['frontpageloggedin'] = 'Objekti naslovnice kad je korisnik prijavljen sustavu';
$string['frontpageoverrides'] = 'Izmjene ovlasti na naslovnici';
$string['frontpagequestions'] = 'Pitanja na naslovnici';
$string['frontpagerestore'] = 'Vraćanje naslovnice';
$string['frontpageroles'] = 'Uloge na razini naslovnice';
$string['frontpagesettings'] = 'Postavke naslovnice';
$string['fullnamedisplay'] = 'Oblik punog imena';
$string['gdrecommended'] = 'GD ekstenzija se koristi za konverziju slika i neke značajke kao što je to prikaz slika na korisničkom profilu neće biti dostupne ako ista nedostaje.';
$string['gdrequired'] = 'GD ekstenzija je od sada neophodna za konverziju slika u Moodle sustavu.';
$string['generalsettings'] = 'Općenite postavke';
$string['geoipfile'] = 'GeoIP City datoteka';
$string['getremoteaddrconf'] = 'Izvor zabilježene IP adrese';
$string['globalswarning'] = '<p><strong>SIGURNOSNO UPOZORENJE!</strong></p><p>Kako bi mogao uspješno funkcionirati, Moodle zahtijeva <br />određene izmjene u vašim PHP postavkama.</p><p><em>Morate</em> postaviti <code>register_globals=off</code>.</p><p>Ovu postavku možete promijeniti uređivanjem vaše <code>php.ini</code> datoteke, Apache/IIS <br />konfiguracije ili <code>.htaccess</code> datoteke.</p>';
$string['googlemapkey3'] = 'Google Maps API V3 ključ';
$string['googlemapkey3_help'] = 'Za korištenje alata Google Maps za vizualizaciju pretrage IP adresa, potrebno je unijeti poseban ključ. Možete ga besplatno dobiti na <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Idi na prvi nedostajući niz';
$string['gradebook'] = 'Ocjene';
$string['gradebookroles'] = 'Uloge koje mogu biti ocjenjivane';
$string['gradeexport'] = 'Primarni načini izvoza ocjena';
$string['gravatardefaulturl'] = 'Zadani URL za Gravatar slike';
$string['gravatardefaulturl_help'] = 'Ako Gravatar ne može pronaći sliku pojedinog korisnika, prikazat će zadanu sliku. Unesite URL do takve slike. Ako ovu postavku ostavite praznom, Moodle će pokušati koristiti najprikladniju sliku za stranicu koju trenutno gledate. Gravatar također ima i nekoliko načina da <a href="https://en.gravatar.com/site/implement/images/#default-image">generirate zadanu sliku</a>.';
$string['groupenrolmentkeypolicy'] = 'Pravila za lozinke za upis u grupu';
$string['groupenrolmentkeypolicy_desc'] = 'Omogućavanje ove opcije će prisiliti Moodle na provjeru lozinke za upis grupe prema važećima pravilima o lozinkama.';
$string['guestroleid'] = 'Uloga za gosta (anonimnog korisnika)';
$string['guestroleid_help'] = 'Ova uloga se automatski dodjeljuje gostu. Privremeno se dodjeljuje i korisnicima koji nisu upisani, a pristupe kolegiju preko dodatka za upis gostiju.';
$string['helpadminseesall'] = 'Vide li administratori sve događaje u kalendaru ili samo one koji se odnose na njih osobno?';
$string['helpexportlookahead'] = 'Koliko dana unaprijed u budućnost treba kalendar gledati prilikom prilagođenog izvoza?';
$string['helpexportlookback'] = 'Koliko dana unatrag u povijest treba kalendar gledati prilikom prilagođenog izvoza?';
$string['helpforcetimezone'] = 'Možete dopustiti korisnicima odabir vremenske zone ili obvezati sve na korištenje iste vremenske zone.';
$string['helpshowicalsource'] = 'Ako je omogućeno, naziv pretplate i poveznica će biti prikazani za događaje uvežene iz iCal.';
$string['helpsitemaintenance'] = 'Za upgrade i ostale poslove održavanja';
$string['helpstartofweek'] = 'Početni dan u tjednu (kalendar)?';
$string['helpupcominglookahead'] = 'Najveći zadani broj dana za koji će kalendar prikazivati buduće događaje ?';
$string['helpupcomingmaxevents'] = 'Najveći zadani broj budućih događaja koji se prikazuju korisnicima?';
$string['helpweekenddays'] = 'Koji dani u tjednu se vode kao "vikend" i bit će prikazani drugom bojom?';
$string['hiddenuserfields'] = 'Skrij korisnička polja';
$string['hidefromall'] = 'Skrij od svih korisnika';
$string['hidefromnone'] = 'Nemoj skrivati od nikoga';
$string['hidefromstudents'] = 'Skrij od studenata';
$string['htmleditor'] = 'HTML uređivač';
$string['htmleditorsettings'] = 'Postavke HTML uređivača';
$string['htmlsettings'] = 'HTML postavke';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP sigurnost';
$string['hubs'] = 'Čvorišta';
$string['iconvrecommended'] = 'Instalacija opcionalne ICONV biblioteke je toplo preporučena kako bi unaprijedili funkcioniranje sustava, posebno ako koristite ne-latinične jezike.';
$string['iconvrequired'] = 'Neophodno je instalirati ICONV ekstenziju.';
$string['ignore'] = 'Ignoriraj';
$string['includemoduleuserdata'] = 'Obuhvati korisničke podatke u modulu';
$string['incompatibleblocks'] = 'Nekompatibilni blokovi';
$string['installhijacked'] = 'Instalacija mora biti dovršena s izvorne IP adrese.';
$string['installsessionerror'] = 'Nije moguće pokrenuti PHP sesiju, provjerite prihvaća li vaš internet preglednik cookie datoteke.';
$string['intlrecommended'] = 'Intl ekstenzija se koristi za unaprijeđenje podrške za međunarodne značajke, kao što je regionalno svjesno sortiranje.';
$string['invalidsection'] = 'Neispravna sekcija.';
$string['invaliduserchangeme'] = 'Korisničko ime "changeme" je rezervirano, ne možete stvoriti korisnički račun s tim nazivom.';
$string['ipblocked'] = 'Ovaj poslužitelj nije trenutno dostupan.';
$string['ipblocker'] = 'Blokiranje IP adresa';
$string['ipblockersyntax'] = 'Jedan zapis po retku. Valjani zapisi su ili pune IP adrese (npr. <b>192.168.10.1</b>), koje identificiraju pojedinačni poslužitelj; ili djelomične adrese (npr. <b>192.168.</b>), koje označavaju sva računala čija IP adresa počinje tim znamenkama; ili CIDR notaciju (npr. <b>231.54.211.0/20</b>); ili rang IP adresa (npr. <b>231.3.56.10-20</b>). Slovima napisane domene (npr. \'example.com\') nisu podržane. Prazne linije će biti zanemarene. ';
$string['iplookup'] = 'Traženje IP adrese';
$string['iplookupgeoplugin'] = 'Trenutno se koristi servis <a href="http://www.geoplugin.com">geoPlugin</a> za pronalaženje geografskih informacija. Za preciznije rezultata vam predlažemo da instalirate lokalnu kopiju MaxMind GeoLite baze podataka.';
$string['iplookupinfo'] = 'Moodle uobičajeno koristi besplatni poslužitelj NetGeo (The Internet Geographic Database) kako bi pronašao informacije o IP adresama, no kako se ta baza podataka više ne održava, može vam vratiti <em>urnebesno pogrešne podatke</em>. Preporučujemo da instalirate lokalnu kopiju besplatne baze podataka GeoLite City koju održava MaxMind. Lokacije IP adresa se prikazuju na Google Maps. Uzmite u obzir da trebate imati Google korisnički račun i prijaviti se za besplatni Google Maps API ključ kako bi koristili interaktivne karte.';
$string['iplookupmaxmindnote'] = 'Ovaj proizvod sadrži GeoLite podatke stvorene od strane MaxMind, dostupne na <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Zadrži veličinu slova kod oznaka';
$string['lang'] = 'Zadani jezik';
$string['langcache'] = 'Aktiviraj CACHE za jezični izbornik';
$string['langcache_desc'] = 'Pohrani jezični izbornik u cache. Ako je omogućeno, popis dostupnih prijevoda se pohranjuje u cache. Cache se povremeno osvježava kada instalirate ili izbrišete jezične pakete putem ugrađenog alata za upravljanje jezičnim paketima. Ako želite instalirati novi jezični paket ručno, morate koristiti naredbu "Izbriši cijeli cache" kako bi osvježili popis pohranjen u cache.';
$string['langlist'] = 'Jezici u jezičnom izborniku';
$string['langmenu'] = 'Prikaži jezični izbornik';
$string['langpackwillbeupdated'] = 'Tijekom nadogradnje će Moodle pokušati nadograditi i vaš jezični paket.';
$string['langstringcache'] = 'Pohrani sve jezične stringove u CACHE';
$string['languagesettings'] = 'Jezične postavke';
$string['latexpreamble'] = 'LaTeX preambula';
$string['latexsettings'] = 'Postavke LaTeX renderer';
$string['latinexcelexport'] = 'Kodna stranica za Excel';
$string['legacyfilesinnewcourses'] = 'Naslijeđene datoteke u novim kolegijima';
$string['legacyfilesinnewcourses_help'] = 'Zadana je vrijednost da se naslijeđene datoteke kolegija prikazuju samo na nadograđenim kolegijima. Uzmite u obzir da neke značajke poput backupa/vraćanja pojedinih aktivnosti nisu kompatibilne s ovom postavkom.';
$string['licensesettings'] = 'Postavke licence';
$string['linkadmincategories'] = 'Poveznica na admin kategorije';
$string['linkadmincategories_help'] = 'Ako je omogućeno, kategorije administratorskih postavki će biti prikazane kao poveznice u navigaciji, i vodit će na stranice administratorskih kategorija.';
$string['loading'] = 'Učitavanje';
$string['localetext'] = 'Regionalne postavke na razini sustava';
$string['localstringcustomization'] = 'Prilagođavanje lokalnih stringova';
$string['location'] = 'Lokacija';
$string['locationsettings'] = 'Postavke lokacije';
$string['locked'] = 'zaključano';
$string['lockoutduration'] = 'Trajanje zaključavanja korisničkog računa';
$string['lockoutduration_desc'] = 'Zaključani korisnički računi se automatski otključavaju nakon isteka ovog roka.';
$string['lockoutemailsubject'] = 'Vaš račun na {$a} je zaključan';
$string['lockoutthreshold'] = 'Prag (granica) za zaključavanje korisničkog računa';
$string['lockoutthreshold_desc'] = 'Odaberite koliko pogrešnih pokušaja prijave sustavu će rezultirati zaključavanjem računa. Ova mogućnost može se zlonamjerno koristiti za DOS napade.';
$string['log'] = 'Zapisi';
$string['logguests'] = 'Bilježi pristup gostiju u zapise';
$string['logguests_help'] = 'Ova postavka omogućava bilježenje aktivnosti od strane gosta, a ne prijavljenih korisnika. Sjedišta se velikim brojem korisnika bi možda trebala isključiti ovu postavku zbog performansi. Preporučljivo je imati ovu postavku omogućenom na produkcijskim poslužiteljtima.';
$string['loginhttps'] = 'Koristi HTTPS za prijavu na sustav';
$string['loginpageautofocus'] = 'Obrazac s automatskim fokusom na poljima za unos na stranici za prijavu na sustav';
$string['loginpageautofocus_help'] = 'Ova opcija poboljšava uporabljivost stranice za prijavu na sustav, ali polja s automatskim fokusom mogu učiniti stranicu manje pristupačnom nekim korisnicima.';
$string['loginpasswordautocomplete'] = 'Spriječi automatsko popunjavanje lozinke na obrascu za prijavu na sustav';
$string['loginpasswordautocomplete_help'] = 'Ako je onemogućeno, korisnici će moći pohraniti svoje lozinke u web pregledniku. Omogućivanje ove postavke će rezultirati time da vaše sjedište više neće slijediti striktna pravila XHTML validacije.';
$string['loglifetime'] = 'Čuvaj zapise';
$string['longtimewarning'] = '<b>Uzmite u obzir da ovaj proces može dugo trajati.</b>';
$string['maintenancemode'] = 'Održavanje sustava u tijeku';
$string['maintenancemodeisscheduled'] = 'Sjedište će prijeći u stanje održavanja i radova na sustavu za {$a} minuta/e';
$string['maintfileopenerror'] = 'Pogreška pri otvaranju datoteka za održavanje!';
$string['maintinprogress'] = 'Održavanje sustava je u toku...';
$string['manageformats'] = 'Uredi oblike kolegija';
$string['manageformatsgotosettings'] = 'Zadani oblik može biti promijenjen u {$a}';
$string['managelang'] = '<b>Upravljanje</b>';
$string['managelicenses'] = 'Uredi licence';
$string['manageqbehaviours'] = 'Uredi ponašanje pitanja';
$string['manageqtypes'] = 'Upravljanje vrstama pitanja';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'RC';
$string['maturity200'] = 'Stabilna inačica';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Napomena: Možda želite pokrenuti ovu skriptu s opcijom --allow-unstable';
$string['maturitycoreinfo'] = 'Vaše sjedište trenutno pokreće nestabilni razvojni kôd "{$a}".';
$string['maturitycorewarning'] = 'Instalirat ćete ili nadograditi Moodle na inačicu označenu kao "{$a}" (što znači da nije namijenjena za produkcijske uvjete/poslužitelje). Molimo provjerite želite li uistinu to napraviti, a ako nije, provjerite koristite li STABLE granu Moodle kôda. Pogledajte Moodle Docs za opširnije informacije.';
$string['maxbytes'] = 'Najveća veličina prenešene datoteke';
$string['maxconsecutiveidentchars'] = 'Konsekutivni identični znakovi';
$string['maxeditingtime'] = 'Najdulje vrijeme za uređivanje poruka';
$string['maxusersperpage'] = 'Najveći dopušteni broj korisnika po stranici';
$string['mbstringrecommended'] = 'Instalacija opcionalne MBSTRING biblioteke je toplo preporučena kako bi unaprijedili funkcioniranje sustava, posebno ako koristite ne-latinične jezike.';
$string['mediapluginavi'] = 'Omogući .avi filtar';
$string['mediapluginflv'] = 'Omogući .flv filtar';
$string['mediapluginimg'] = 'Omogući automatsku ugradnju (embedding) povezanih slika';
$string['mediapluginmov'] = 'Omogući .mov filtar';
$string['mediapluginmp3'] = 'Omogući .mp3 filtar';
$string['mediapluginmpg'] = 'Omogući .mpg filtar';
$string['mediapluginogg'] = 'Omogući .ogg filtar';
$string['mediapluginogv'] = 'Omogući .ogv filtar';
$string['mediapluginram'] = 'Omogući .ram filtar';
$string['mediapluginrm'] = 'Omogući .rm filtar';
$string['mediapluginrpm'] = 'Omogući .rpm filtar';
$string['mediapluginswf'] = 'Omogući .swf filtar';
$string['mediapluginswfnote'] = 'Kao zadana mjera sigurnosti, obični korisnici ne bi trebali imati ovasti ugradnje swf flash datoteka.';
$string['mediapluginwmv'] = 'Omogući .wmv filtar';
$string['mediapluginyoutube'] = 'Omogući filtar za YouTube poveznice';
$string['messaging'] = 'Omogući sustav poruka';
$string['messagingallowemailoverride'] = 'Izmjena adrese za slanje obavijesti';
$string['messagingdeletereadnotificationsdelay'] = 'Brisanje obavijesti o porukama';
$string['messaginghidereadnotifications'] = 'Skrivanje obavijesti o porukama';
$string['minpassworddigits'] = 'Znamenke';
$string['minpasswordlength'] = 'Duljina lozinke';
$string['minpasswordlower'] = 'Mala slova';
$string['minpasswordnonalphanum'] = 'Ne-alfanumerički znakovi';
$string['minpasswordupper'] = 'VELIKA slova';
$string['misc'] = 'Razno';
$string['mnetrestore_extusers'] = '<strong>Napomena:</strong> Ova backup datoteka sadrži udaljene MNet korisničke račune koji će biti vraćeni kao dio procesa.';
$string['mnetrestore_extusers_admin'] = '<strong>Napomena:</strong> Ova backup datoteka izgleda dolazi s drugačije Moodle instalacije i sadrži udaljene MNet korisničke račune. Postupak vraćanja će pokušati pronaći sve MNet poslužitelje za stvorene korisnike. Oni koje nije moguće upariti će automatski biti prebačeni na internu autentikaciju (umjesto mnet-a). Detaljnije informacije ćete moći pronaći u zapisima o vraćanju.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Napomena:</strong> Ova backup datoteka izgleda je napravljena na drugačijoj Moodle instalaciji i sadrži udaljene MNet korisničke račune. Nemate ovlasti za izvršavanje ove vrste vraćanja podataka. Kontaktirajte administratora sjedišta ili pokušajte vratiti ovaj tečaj bez korisničkih informacija (moduli, slika ...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Udaljeni MNet korisnik {$a->username} (koji dolazi s {$a->mnethosturl}) prebačen u lokalnog {$a->auth} prijavljenog korisnika.';
$string['mobile'] = 'Mobilni';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Zadana vrijednost za odvojene izbornike';
$string['modeditdefaults'] = 'Zadane vrijednosti za postavke aktivnosti';
$string['modsettings'] = 'Uredi aktivnosti';
$string['modulesecurity'] = 'Sigurnost modula';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Obvezna uporaba stare multilang sintakse: &lt;span&gt; bez class="multilang" i &lt;lang&gt;';
$string['mustenablestats'] = 'Statistika nije omogućena na ovom poslužitelju.';
$string['mycoursesperpage'] = 'Broj kolegija';
$string['mydashboard'] = 'Zadana kontrolna ploča sustava';
$string['mymoodle'] = 'Moja naslovnica';
$string['mymoodleredirect'] = 'Prisili korisnike na uporabu Moj Moodle stranice';
$string['mypage'] = 'Zadana stranica za Moja naslovnica';
$string['mypagelocked'] = 'Zaključaj zadanu stranicu';
$string['myprofile'] = 'Zadana stranica profila';
$string['mysql416bypassed'] = 'Međutim, ako vaše sjedište koristi iso-8859-1 (latin) jezike, možete nastaviti s korištenjem vaše trenutno instalirane MySQL inačice 4.1.12 (ili više).';
$string['mysql416required'] = 'MySQL 4.1.16 je minimalna inačica potrebna za Moodle 1.6 kako bi se osigualo da se svi podaci mogu pretvoriti u UTF-8 u budućnosti.';
$string['navadduserpostslinks'] = 'Dodaj poveznice za pregled korisničkih rasprava';
$string['navadduserpostslinks_help'] = 'Ako je omogućeno, svakom će korisniku u navigaciji biti dodane dvije poveznice: pregled rasprava koje je korisnik započeo i pregled poruka koje je korisnik poslao u forume, kroz cijelo sjedište ili pojedine kolegije.';
$string['navcourselimit'] = 'Broj kolegija';
$string['navigationupgrade'] = 'Ova nadogradnja uvodi dva nova bloka navigacije koji će zamijeniti sljedeće blokove: Administracija, Kolegiji, Aktivnosti i Sudionici. Ako ste prije postavili neke posebne ovlasti za ove blokove, provjerite ponaša li se sve kako želite.';
$string['navshowallcourses'] = 'Prikaži sve kolegije';
$string['navshowcategories'] = 'Prikaži kategorije kolegija';
$string['navshowfrontpagemods'] = 'Prikaži aktivnosti na naslovnici sjedišta';
$string['navshowfrontpagemods_help'] = 'Ako je omogućeno, aktivnosti na naslovnici sjedišta će biti prikazane u bloku navigacije pod "Stranice sjedišta".';
$string['navshowfullcoursenames'] = 'Prikaži pune nazive kolegija';
$string['navshowfullcoursenames_help'] = 'Ako je omogućeno, kolegiji će u popisu biti prikazani korištenjem punog naziva kolegija umjesto kratice.';
$string['navshowmycoursecategories'] = 'Prikaži kategorije mojih kolegija';
$string['navshowmycoursecategories_help'] = 'Ako je omogućeno, upisani kolegiji će korisnicima biti prikazani u svojim kategorijama.';
$string['navsortmycoursessort'] = 'Sortiraj moje kolegije';
$string['neverdeleteruns'] = 'Nemoj nikada brisati pokretanja';
$string['nobookmarksforuser'] = 'Nemate omiljenih stranica.';
$string['nodatabase'] = 'Nema baze podataka';
$string['nohttpsformobilewarning'] = 'Preporučuje se omogućavanje HTTPS s valjanim certifikatom. Moodle aplikacija će se uvijek prvo pokušati spojiti na sigurnu vezu.';
$string['nomissingstrings'] = 'Nema nedostajućih nizova (missing strings)';
$string['nonewsettings'] = 'Nijedna nova postavka nije dodana pri ovoj nadogradnji.';
$string['nonexistentbookmark'] = 'Omiljena stranica koju ste zatražili ne postoji.';
$string['noresults'] = 'Nema rezultata.';
$string['noroles'] = 'Nema uloga';
$string['notifications'] = 'Obavijesti';
$string['notifyloginfailures'] = 'Kome poslati e-poštu o pogreškama pri prijavi';
$string['notifyloginthreshold'] = 'Granica za slanje obavijesti e-poštom';
$string['notloggedinroleid'] = 'Uloga za posjetitelje';
$string['numberofmissingstrings'] = 'Broj nedostajućih nizova: {$a}';
$string['numberofstrings'] = 'Ukupan broj stringova: {$a->strings}<br /> Nedostaje: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = 'Instalacija opcionalne OpenSSL biblioteke je jako preporučeno -- ista vam omogućava MNet funkcionalnost.';
$string['opentogoogle'] = 'Otvoren za Google pretraživanje';
$string['optionalmaintenancemessage'] = 'Opcionalna poruka prilikom održavanja i radova na sustavu';
$string['order1'] = 'Prvi';
$string['order2'] = 'Drugi';
$string['order3'] = 'Treći';
$string['order4'] = 'Četvrti';
$string['passwordpolicy'] = 'Pravila za lozinke';
$string['pathconvert'] = 'Putanja (PATH) do <i>convert</i> binarnih datoteka';
$string['pathdvips'] = 'Putanja (PATH) do <i>dvips</i> binarnih datoteka';
$string['pathlatex'] = 'Putanja (PATH) do <i>latex</i> binarnih datoteka';
$string['pathtoclam'] = 'ClamAV putanja (PATH)';
$string['pathtodot'] = 'Putanja do dot';
$string['pathtodot_help'] = 'Putanja do dot. Nešto poput /usr/bin/dot. Kako biste mogli stvarati grafičke elemente iz DOT datoteka, morate imati instaliran dot i podešenu ispravnu putanju do istoga. Za sada se isti koristi samo za značajku profiliranja (Razvoj->Profiliranje).';
$string['pathtodu'] = 'Putanja (PATH) do du';
$string['pathtopgdump'] = 'Putanja (PATH) do pg_dump';
$string['pathtopgdumpdesc'] = 'Ovo je potrebno unijeti samo ako imate više od jednog pg_dump na vašem sustavu (npr. ako imate instalirano više od jedne inačice postresql)';
$string['pathtopgdumpinvalid'] = 'Netočna putanja do pg_dump - ili neispravna putanja ili nije moguće izvršiti';
$string['pathtopsql'] = 'Putanja (PATH) do psql';
$string['pathtopsqldesc'] = 'Ovo je potrebno unijeti samo ako imate više od jednog psql na vašem sustavu (npr. ako imate instalirano više od jedne inačice postresql)';
$string['pathtopsqlinvalid'] = 'Netočna putanja do psql - ili neispravna putanja ili nije moguće izvršiti';
$string['pcreunicodewarning'] = 'Strogo se preporučuje korištenje PCRE PHP ekstenzije koja je kompatibilna s Unicode kôdnom stranicom.';
$string['perfdebug'] = 'Informacija o performansama';
$string['performance'] = 'Performanse';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'Parametar PostgreSQL verzije/klastera za operacije komandne linije. Ako imate samo jedan postgresql na svom sustavu ili niste sigurni što ova postavka predstavlja, ostavite polje prazno.';
$string['php50restricted'] = 'PHP 5.0.x ima brojne poznate probleme, molimo nadogradite ga na 5.1.x ili snizite inačicu na 4.3.x ili 4.4.x.';
$string['php533warning'] = 'Preporučeno je koristiti PHP 5.3.3 ili noviji';
$string['phpfloatproblem'] = 'Otkriven je neočekivan problem u rukovanju PHP float brojevima - {$a}';
$string['pleaserefreshregistration'] = 'Vaše web sjedište je registrirano na moodle.org, molimo vas da razmislite o ažuriranju registracije ako su se dogodile značajne promjene od vašeg zadnjeg ažuriranja, na {$}';
$string['pleaseregister'] = 'Molimo registrirajte vaš site kako biste maknuli ovu poruku';
$string['plugin'] = 'Dodatak (plugin)';
$string['plugins'] = 'Dodaci';
$string['pluginscheck'] = 'Provjera ovisnosti datoteka';
$string['pluginscheckfailed'] = 'Provjera ovisnosti nije uspjela za {$a->pluginslist}';
$string['pluginschecktodo'] = 'Morate riješiti ove zahtjeve dodataka prije nego nastavite s instalacijom ove inačice Moodle sustava!';
$string['pluginsoverview'] = 'Pregled dodataka';
$string['pluginsoverviewsee'] = 'Za više informacija pogledajte stranicu <a href="{$a->url}">Pregled dodataka</a>.';
$string['profilecategory'] = 'Kategorija';
$string['profilecategoryname'] = 'Naziv kategorije (mora biti jedinstven)';
$string['profilecategorynamenotunique'] = 'Naziv kategorije je već u uporabi otprije';
$string['profilecommonsettings'] = 'Zajedničke postavke';
$string['profileconfirmcategorydeletion'] = 'Postoji/e polje/a {$a} u ovoj kategoriji koja će biti premještena u kategoriju iznad (ili ispod ako se radi o nadređenoj kategoriji). br /> Želite li i dalje obrisati ovu kategoriju?';
$string['profileconfirmfielddeletion'] = 'Postoji barem {$a} zapis(a) o korisnicima za ovo polje koji će biti izbrisan(i).<br/>Želite li i dalje izbrisati ovo polje?';
$string['profilecreatecategory'] = 'Stvori novu kategoriju profila';
$string['profilecreatefield'] = 'Stvori novo polje profila:';
$string['profilecreatenewcategory'] = 'Stvori novu kategoriju';
$string['profilecreatenewfield'] = 'Stvaranje novog polja profila: \'{$a}\'';
$string['profiledefaultcategory'] = 'Ostala polja';
$string['profiledefaultchecked'] = 'Zadano je označeno';
$string['profiledefaultdata'] = 'Zadana vrijednost';
$string['profiledeletecategory'] = 'Brisanje kategorije';
$string['profiledeletefield'] = 'Brisanje polja \'{$a}\'';
$string['profiledescription'] = 'Opis polja';
$string['profiledscript'] = 'Skripta je profilirana';
$string['profiledscriptview'] = 'Vidi informacije o profiliranju za ovu skriptu';
$string['profileeditcategory'] = 'Uređivanje kategorije: {$a}';
$string['profileeditfield'] = 'Uređivanje polja profila: {$a}';
$string['profilefield'] = 'Polje profila';
$string['profilefieldcolumns'] = 'Stupci';
$string['profilefieldispassword'] = 'Je li ovo polje za lozinku?';
$string['profilefieldlink'] = 'Poveznica';
$string['profilefieldlink_help'] = 'Za pretvaranje teksta u poveznicu, unesite URL koja sadrži $$, gdje će se $$ zamijeniti tekstom. Na primjer, za pretvaranje Twitter ID-ja u poveznicu, upišite http://twitter.com/$$';
$string['profilefieldlinktarget'] = 'Adresa na koju vodi poveznica';
$string['profilefieldmaxlength'] = 'Najveća duljina';
$string['profilefieldrows'] = 'Redovi';
$string['profilefields'] = 'Polja korisničkih profila';
$string['profilefieldsize'] = 'Veličina polja';
$string['profileforceunique'] = 'Trebaju li podaci biti jedinstveni?';
$string['profileinvaliddata'] = 'Netočna vrijednost';
$string['profilelocked'] = 'Je li ovo polje zaključano?';
$string['profilemenudefaultnotinoptions'] = 'Zadana vrijednost nije jedna od opcija';
$string['profilemenunooptions'] = 'Nisu pružene opcije izbornika';
$string['profilemenuoptions'] = 'Opcije izbornika (jedna po retku)';
$string['profilemenutoofewoptions'] = 'Morate pružiti barem 2 opcije';
$string['profilename'] = 'Naziv';
$string['profilenofieldsdefined'] = 'Nijedno polje nije definirano';
$string['profilerequired'] = 'Je li ovo polje obvezno?';
$string['profileroles'] = 'Vidljive uloge na profilu';
$string['profilesforenrolledusersonly'] = 'Profil samo za prijavljene korisnike';
$string['profileshortname'] = 'Kratica (mora biti jedinstvena)';
$string['profileshortnamenotunique'] = 'Kratica je već u uporabi';
$string['profilesignup'] = 'Prikaži na stranici za prijavu?';
$string['profilespecificsettings'] = 'Posebne postavke';
$string['profilevisible'] = 'Kome je vidljivo ovo polje?';
$string['profilevisibleall'] = 'Vidljivo svima';
$string['profilevisible_help'] = '* Nije vidljivo - Vide samo administratori
* Vidljivo korisniku - Vide samo administratori i korisnik na kojeg se odnosi
* Vidljivo svima';
$string['profilevisiblenone'] = 'Nije vidljivo';
$string['profilevisibleprivate'] = 'Vidljivo korisniku';
$string['profiling'] = 'Profiliranje';
$string['profilingallowall'] = 'Trajno profiliranje';
$string['profilingallowall_help'] = 'Ako omogućite ovu postavku, onda ćete moći koristiti parametar PROFILEALL bilo gdje (PGC) za sve izvršene skripte. Identično tomu, možete koristiti parametar PROFILEALLSTOP kako bi to spriječili.';
$string['profilingallowme'] = 'Selektivno profiliranje';
$string['profilingallowme_help'] = 'Ako omogućite ovu postavku, onda ćete moći koristiti parametar PROFILEME bilo gdje (PGC) i ta skripta će biti profilirana. Identično tomu, možete koristiti parametar DONTPROFILEME kako bi spriječili profiliranje.';
$string['profilingautofrec'] = 'Automatsko profiliranje';
$string['profilingautofrec_help'] = 'Podešavanjem ove postavke, neki zahtjevi (slučajnim odabirom, zasnovano na frekvenciji određenoj kao 1 od XXX) će biti odabrani i automatski profilirani, pohranjujući rezultate za buduću analizu. Uzmite u obzir da ovaj način profiliranja promatra postavke include/exclude. Postavite vrijednost na 0 kako bi onemogućili automatsko profiliranje.';
$string['profilingenabled'] = 'Omogući profiliranje';
$string['profilingenabled_help'] = 'Ako omogućite ovu postavku, onda će profiliranje biti dostupno na ovom poslužitelju i moći ćete odrediti način ponašanja istih putem postavki koje slijede dolje.';
$string['profilingexcluded'] = 'Isključi profiliranje';
$string['profilingexcluded_help'] = 'Popis URL-ova (odvojenih zarezima, apsolutnih, preskačući wwwroot, s mogućnošću pokretanja) koji neće biti obuhvaćeni profiliranjem.';
$string['profilingincluded'] = 'Profiliraj ovo';
$string['profilingincluded_help'] = 'Popis URL-ova (odvojenih zarezima, apsolutnih, preskačući wwwroot, s mogućnošću pokretanja) koji će biti automatski profilirani. Na primjer: /course/view.php. Može se koristiti i * kao zamjena. Na primjer: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Sačuvaj podatke o prethodnim profiliranjima';
$string['profilinglifetime_help'] = 'Odredite koliko dugo želite čuvati informacije o prethodnim pokretanjima profiliranja. Uzmite u obzir da ovo ne obuhvaća ona pokretanja profiliranja koja su označena kao "referentno pokretanje".';
$string['protectusernames'] = 'Zaštiti korisnička imena';
$string['proxybypass'] = 'Poslužitelji koji mogu zaobići proxy';
$string['proxyhost'] = 'Proxy poslužitelj';
$string['proxypassword'] = 'Proxy lozinka';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Vrsta proxy poslužitelja';
$string['proxyuser'] = 'Proxy korisničko ime';
$string['purgecaches'] = 'Izbriši sve CACHE zapise';
$string['purgecachesconfirm'] = 'Moodle može u cache pohraniti teme, javascript, jezične nizove, filtrirane tekstove, rss kanale i dosta drugih obrađenih podataka. Brisanje cache spremnika će izbrisati te privremeno pohranjene podatke na poslužitelju i time obvezati internet preglednike da ponovno preuzmu podatke, tako da možete biti sigurni da gledate najsvježije vrijednosti koje je proizveo trenutni kôd. Nema nikakve opasnosti pri brisanju cache spremnika, ali vaše sjedište će krajnjim korisnicima izgledati sporije sve dok poslužitelj i klijenti ne proračunaju nove informacije i pohrane ih nanovo u cache.';
$string['purgecachesfinished'] = 'Svi CACHE zapisi su izbrisani.';
$string['qtyperqpwillberemoved'] = 'Tijekom nadogradnje će vrsta pitanja RQP biti uklonjena. Prije niste koristili ovu vrstu pitanja, pa ne biste trebali iskusiti nikakve probleme u radu.';
$string['qtyperqpwillberemovedanyway'] = 'Tijekom nadogradnje, vrsta pitanja RQP će biti uklonjena. Imate nekoliko RQP pitanja u vašoj bazi podataka, i ista će prestati raditi, osim ako ponovno instalirate k&#244;d iz http://moodle.org/mod/data/view.php?d=13&rid=797 prije nastavka nadogradnje.';
$string['quarantinedir'] = 'Mapa za karantenu';
$string['question'] = 'Pitanje';
$string['questionbehaviours'] = 'Ponašanje pitanja';
$string['questioncwqpfsok'] = 'OK. U vašim testovima nema \'slučajnih\' pitanja koja su podešena tako da odabiru pitanja iz miješanih dijeljenih i nedijeljenih kategorija pitanja.';
$string['questiontype'] = 'Vrsta pitanja';
$string['questiontypes'] = 'Vrste pitanja';
$string['recaptchaprivatekey'] = 'ReCAPTCHA privatni ključ';
$string['recaptchapublickey'] = 'ReCAPTCHA javni ključ';
$string['register'] = 'Registrirajte svoje sjedište';
$string['registermoodleorg'] = 'Kada registrirate svoje sjedište na {$a}';
$string['registermoodleorgli1'] = 'Bit ćete dodatni na mailing listu za slanje važnih obavijesti kao što su sigurnosna upozorenja i informacije o novim inačicama Moodle sustava.';
$string['registermoodleorgli2'] = 'Statistički podaci o vašem sjedištu će biti dodani u statistiku svjetske Moodle zajednice - {$a}';
$string['registermoodleorgli3'] = 'Vaše sjedište će također biti registrirano pri Moodle.org Open Community Hub ({$a}), omogućavajući korisnicima objavu svojih kolegija na Moodle.net (zadano je da to samo mogu korisnici s ulogom menadžera).';
$string['registerwithmoodleorg'] = 'Registracija na sjedištu Moodle.org';
$string['registration'] = 'Registracija';
$string['registration_help'] = 'Registracija na Moodle.org se preporučuje iz više razloga - dobijanja obavijesti o sigurnosnim problemima, rastu i <a href="http://moodle.org/stats">statistici javno poznate Moodle zajednice</a>, kao i mogućnosti dodavanja kolegija na <a href="http://moodle.net/">Moodle.net</a>.';
$string['registrationwarning'] = 'Vaše sjedište još nije registrirano.';
$string['releasenoteslink'] = 'Za informacije o ovoj inačici Moodle-a, posjetite <a target="_blank" href="{$a}">Obavijest o izdanju (Release Notes)</a>';
$string['rememberusername'] = 'Zapamti korisničko ime';
$string['rememberusername_desc'] = 'Omogućite ovu opciju ako tijekom prijave korisnika na sustav želite pohraniti trajne kolačiće (cookije) zajedno s korisničkim imenima. Ovakvi kolačići se mogu smatrati narušavanjem privatnosti ako se pohranjuju bez dopuštenja korisnika.';
$string['reportsmanage'] = 'Upravljanje izvještajima';
$string['requestcategoryselection'] = 'Omogući odabir kategorije';
$string['requiredentrieschanged'] = '<strong>VAŽNO - OBVEZNO PROČITAJTE<br/>(Ovo upozorenje će biti prikazano samo pri ovoj nadogradnji)</strong><br/>Zbog rješavanja bug-a, ponašanje aktivnosti baze podataka koje koriste postavke \'Required entries\' i \'Required entries before viewing settings\' će biti promijenjene. Opširnije pojašnjenje možete pročitati na <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">forumu modula baze podataka</a>. Očekivano ponašanje i vrijednosti navedene postavke pogledajte na pripadajućoj stranici na <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>. <br/><br/>Ova promjena utječe na slijedeće baze podataka na vašem sustavu: (Pohranite sada ovaj popis i pregledajte te baze podataka nakon završetka nadogradnje kako bi se uvjerili da navedene aktivnosti i dalje rade na način na koji su nastavnici koji ih koriste i zamislili.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Zahtijevaj opis aktivnosti';
$string['requires'] = 'Neophodno';
$string['restorernewroleid'] = 'Uloga za resetiranje kolegija';
$string['restorernewroleid_help'] = 'Ako korisnik već nema ovlasti za upravljanje kolegijem koji je resetiran, korisniku će se ova uloga automatski dodijeliti, ako je to potrebno. Odaberite "Ništa" ako ne želite da korisnici s tom ulogom mogu upravljati svakim resetiranim kolegijem.';
$string['reverseproxy'] = 'Reverse proxy';
$string['riskconfig'] = 'Korisnik može promijeniti postavke i utjecati na funkcioniranje sustava';
$string['riskconfigshort'] = 'Konfiguracijski rizik';
$string['riskdataloss'] = 'Korisnici mogu uništiti veću količinu podataka ili informacija';
$string['riskdatalossshort'] = 'Rizik od gubitka informacija';
$string['riskmanagetrust'] = 'Korisnici bi mogli promjeniti postavke pouzdanosti drugih korisnika';
$string['riskmanagetrustshort'] = 'Uredi pouzdanost';
$string['riskpersonal'] = 'Korisnici mogu ostvariti pristup osobnim informacijama drugih korisnika';
$string['riskpersonalshort'] = 'Rizik privatnosti';
$string['riskspam'] = 'Korisnici mogu slati SPAM drugim korisnicima (a i šire)';
$string['riskspamshort'] = 'SPAM rizik';
$string['riskxss'] = 'Korisnici mogu dodati datoteke i tekstualne dokumente koji omogućavaju cross-stie scripting (XSS)';
$string['riskxssshort'] = 'XSS rizik';
$string['roleswithexceptions'] = '{$a->roles}, uz {$a->exceptions}';
$string['rssglobaldisabled'] = 'Onemogućeno na razini poslužitelja';
$string['runclamavonupload'] = 'Koristi ClamAV na prenešenim datotekama';
$string['save'] = 'Pohrani';
$string['savechanges'] = 'Pohrani promjene';
$string['search'] = 'Pretraživanje';
$string['searchinsettings'] = 'Pretraži postavke';
$string['searchresults'] = 'Rezultati pretraživanja';
$string['sectionerror'] = 'Pogreška sekcije!';
$string['secureforms'] = 'Koristi dodatne sigurnosne mjere na obrascima';
$string['security'] = 'Sigurnost';
$string['selectdevice'] = 'Odaberite uređaj';
$string['selecttheme'] = 'Odaberite temu za uređaj {$a}';
$string['server'] = 'Poslužitelj';
$string['serverchecks'] = 'Provjera poslužitelja';
$string['serverlimit'] = 'Poslužiteljsko ograničenje';
$string['sessionautostartwarning'] = '<p>Otkrivena je ozbiljna pogreška pri konfiguraciji, obavijestite administratora sjedišta</p><p> Za ispravan rad, administrator treba promijeniti postavke PHP-a.</p>
<p><code>session.auto_start</code> mora biti postavljeno na <code>off</code>.</p><p>
Ova se postavka mijenja uređivanjem datoteke <code>php.ini</code>, Apache/IIS <br />konfiguracijom ili u datoteci <code>.htaccess</code> na poslužitelju.</p>';
$string['sessioncookie'] = 'Cookie prefiks';
$string['sessioncookiedomain'] = 'Cookie domena';
$string['sessioncookiepath'] = 'Cookie putanja';
$string['sessionhandling'] = 'Upravljanje sesijama';
$string['sessiontimeout'] = 'Istek vremena';
$string['settingfileuploads'] = 'Prenošenje datoteka je neophodno za normalno funkcioniranje, omogućite ga u postavkama PHP-a.';
$string['settingmemorylimit'] = 'Nedovoljna memorija, molimo podesite veću vrijednost memorijskog ograničenja u PHP postavkama.';
$string['settingsafemode'] = 'Moodle nije u potpunosti kompatibilan sa sigurnim načinom rada (safe mod), tražite od administratora da ga isključi. Rad Moodle-a u sigurnom načinu rada nije podržan, očekujte razne probleme ako to nastavite činiti.';
$string['showcommentscount'] = 'Prikaži broj komentara';
$string['showdetails'] = 'Prikaži detalje';
$string['showuseridentity'] = 'Prikaži identitet korisnika';
$string['showuseridentity_desc'] = 'Kada označavate ili tražite korisnike, te kada pregledavate popis korisnika, ova polja mogu biti prikazana uz njihovo puno ime. Ta su polja prikazana samo korisnicima s pravom moodle/site:viewuseridentity; zadano su to nastavnici i studenti. (Ova opcija ima najviše smisla ako odaberete jedno ili dva polja koja su obvezna na vašoj instituciji).';
$string['simplexmlrequired'] = 'Moodle zahtijeva instaliranje SimpleXML PHP ekstenzije.';
$string['sitemaintenance'] = 'Sustav je trenutno nedostupan zbog održavanja i radova.';
$string['sitemaintenancemode'] = 'Stanje održavanja i radova na sustavu';
$string['sitemaintenanceoff'] = 'Način rada za održavanje je onemogućen i sjedište ponovno uobičajeno radi';
$string['sitemaintenanceon'] = 'Vaš sustav je trenutno u stanju održavanja i radova na sustavu (prijaviti se mogu samo administratori)';
$string['sitemaintenancewarning'] = 'Vaše sjedište je trenutno u stanju održavanja i radova na sustavu (sjedištu mogu pristupiti samo administratori). Kako bi se vratili u normalni način rada, <a href="maintenance.php">isključite stanje održavanja i radova na sustavu</a>.';
$string['sitemaintenancewarning2'] = 'Sjedište je trenutno u načinu rada za održavanje (samo se administratori mogu prijaviti). Za povratak u uobičajeni način rada, <a href="{$a}">onemogućite način rada za održavanja</a>.';
$string['sitepolicies'] = 'Pravilnici o korištenju sustava';
$string['sitepolicy'] = 'URL pravilnika o ponašanju na sustavu';
$string['sitepolicyguest'] = 'URL pravilnika o ponašanju na sustavu za goste';
$string['sitepolicyguest_help'] = 'Ako imate pravilnik o ponašanju na sustavu koji svi gosti moraju pročitati i prihvatiti, ovdje možete zadati URL istoga, u suprotnome ostavite ovo polje praznim. Ova postavka može sadržavati bilo koji javno dostupni URL. Napomena: pristup neprijavljenim korisnicima može biti onemogućen korištenjem postavke forcelogin.';
$string['sitepolicy_help'] = 'Ako imate pravilnik o ponašanju na sustavu koji svi prijavljeni korisnici moraju pročitati i prihvatiti, ovdje možete zadati URL istoga, u suprotnome ostavite ovo polje praznim. Ova postavka može sadržavati bilo koji javno dostupni URL.';
$string['sitesectionhelp'] = 'Ako je odabrano, tematski dio će biti prikazan na naslovnici sustava.';
$string['slasharguments'] = 'Koristi slash argumente';
$string['smartpix'] = 'Pametno pretraživanje slika';
$string['soaprecommended'] = 'Instalacija opcionalne SOAP ekstenzije je korisna za web servise i neke contrib module.';
$string['sort_fullname'] = 'Puni naziv kolegija';
$string['sort_idnumber'] = 'ID broj kolegija';
$string['sort_shortname'] = 'Kratica kolegija';
$string['sort_sortorder'] = 'Redoslijed sortiranja';
$string['spellengine'] = 'Sustav provjere pravopisa';
$string['spelllanguagelist'] = 'Popis jezika za provjeru pravopisa';
$string['splrequired'] = 'Moodle zahtijeva instaliranje SPL PHP ekstenzije.';
$string['stats'] = 'Statistika';
$string['statsfirstrun'] = 'Najdulji interval obrade';
$string['statsmaxruntime'] = 'Najdulje vrijeme izvršavanja';
$string['statsmoodleorg'] = 'statistika';
$string['statsruntimedays'] = 'Broj dana za obraditi';
$string['statsruntimestart'] = 'Pokreni u';
$string['statsuserthreshold'] = 'Korisnički prag';
$string['stickyblocks'] = 'Ljepljivi blokovi';
$string['stickyblockscourseview'] = 'Stranica kolegija';
$string['stickyblocksduplicatenotice'] = 'Ako je bilo koji blok koji ovdje dodate već prisutan na nekoj konkretnoj stranici, bit će prikazana i njegova kopija.<br/>Jedino što se ljepljivi blok neće moći mijenjati, dok ćete kopiju moći mijenjati.';
$string['stickyblocksmymoodle'] = 'Moj Moodle';
$string['stickyblockspagetype'] = 'Vrsta stranice koja se uređuje';
$string['strictformsrequired'] = 'Striktna provjera obveznih polja';
$string['stripalltitletags'] = 'Ukloni HTML oznake iz naziva aktivnosti';
$string['supportcontact'] = 'Kontakt za podršku';
$string['supportemail'] = 'E-pošta osobe zadužene za podršku';
$string['supportname'] = 'Ime osobe zadužene za podršku';
$string['supportpage'] = 'Adresa stranice za podršku';
$string['suspenduser'] = 'Zaključani korisnički račun';
$string['switchlang'] = 'Promijeni lang mapu';
$string['systempaths'] = 'Putanje sustava';
$string['tablenosave'] = 'Promjene u gornjoj tablici se automatski pohranjuju.';
$string['tablesnosave'] = 'Promjene u gornjoj tablici se automatski pohranjuju.';
$string['tabselectedtofront'] = 'Na tablicama s tabovima, treba li red s trenutno odabranim tabom biti smješten u prvi plan';
$string['tabselectedtofronttext'] = 'Prebaci odabrani red u prvi plan';
$string['themedesignermode'] = 'Način - dizajniranje teme';
$string['themelist'] = 'Popis tema';
$string['themenoselected'] = 'Nijedna tema nije odabrana';
$string['themeresetcaches'] = 'Očisti CACHE s temama';
$string['themeselect'] = 'Odabir teme';
$string['themeselector'] = 'Odabir teme';
$string['themesettings'] = 'Postavke teme';
$string['therewereerrors'] = 'Pronađene su pogreške u vašim podacima';
$string['thirdpartylibrarylocation'] = 'Lokacija';
$string['timezone'] = 'Zadana vremenska zona';
$string['timezoneforced'] = 'Obvezno prema administratoru sjedišta';
$string['timezoneisforcedto'] = 'Prisili sve korisnike na uporabu';
$string['timezonenotforced'] = 'Korisnici mogu odabrati vlastitu vremensku zonu';
$string['tokenizerrecommended'] = 'Instalacija opcionalne PHP Tokenizer ekstenzije je preporučena -- ona unapređuje MNet funkcionalnost.';
$string['tools'] = 'Admin alati';
$string['toolsmanage'] = 'Uređivanje admin alata';
$string['unattendedoperation'] = 'Neinteraktivni način rada';
$string['unbookmarkthispage'] = 'Ukloni stranicu iz omiljenih stranica';
$string['unicoderecommended'] = 'Preporučljivo je da svi podaci budu u Unicode obliku (UTF-8). Nove instalacije se trebaju obaviti u bazi čiji je zadani skup znakova postavljen na Unicode. Ako nadograđujete sustav, trebali biste obaviti migraciju na UTF-8 (pogledajte Admin stranicu).';
$string['unicoderequired'] = 'Svi podaci moraju biti u Unicode obliku (UTF-8). Nove instalacije se trebaju obaviti u bazi čiji je zadani skup znakova postavljen na Unicode. Ako nadograđujete sustav, obavite migraciju na UTF-8 (pogledajte Admin stranicu)';
$string['uninstallplugin'] = 'Deinstaliraj';
$string['unlockaccount'] = 'Otključaj korisnički račun';
$string['unsettheme'] = 'Prestani koristiti temu';
$string['unsupported'] = 'Nije podržano';
$string['unsuspenduser'] = 'Aktiviranje korisničkog računa';
$string['updateaccounts'] = 'Osvježi postojeće korisničke račune';
$string['updateautocheck'] = 'Automatska provjera raspoloživih nadogradnji';
$string['updateautocheck_desc'] = 'Ako je omogućeno, Moodle će automatski potražiti nadogradnje za osnovni Moodle kôd, kao i za sve dodatke. Ako su nadogradnje dostupne, administratori sjedišta bit će obaviješteni.';
$string['updateautodeploy'] = 'Omogući primjenu nadogradnji';
$string['updateautodeploy_desc'] = 'Ako je omogućeno, moći ćete preuzeti i instalirati dostupna nadogradnje direktno iz stranica administracije sustava Moodle. Napomena: web poslužitelj mora imati pravo pisanja u mape s Moodle instalacijom. Ovo se može smatrati potencijalnim sigurnosnim rizikom.';
$string['updateavailable'] = 'Postoji novija inačica Moodle sustava!';
$string['updateavailabledetailslink'] = 'Posjetite {$a->url} za više detalja';
$string['updateavailableforplugin'] = 'Dostupna je novija inačica/nadogradnja za neke od vaših dodataka.';
$string['updateavailableinstall'] = 'Instaliraj ovu nadogradnju';
$string['updateavailable_moreinfo'] = 'Opširnije...';
$string['updateavailablenot'] = 'Vaša Moodle instalacija je ažurna!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Inačica {$a}';
$string['updatecomponent'] = 'Osvježi komponentu';
$string['updateminmaturity'] = 'Zahtijevana starost/stabilnost kôda';
$string['updateminmaturity_desc'] = 'Slanje obavijesti o dostupnim nadogradnjama samo ako dostupna nadogradnja ima barem ovu razinu "zrelosti". O nadogradnjama za dodatke koji nemaju postavljenu razinu zrelosti ćete uvijek biti obaviješteni, unatoč ovoj postavci.';
$string['updatenotifications'] = 'Obavijesti o nadogradnji';
$string['updatenotificationsubject'] = 'Dostupne su nove inačice Moodlea ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Obavijesti o novim pod-inačicama';
$string['updatenotifybuilds_desc'] = 'Ako je omogućeno, bit ćete obaviješteni o dostupnoj nadogradnji za novu "build" podinačicu inačice koju trenutno koristite. "Build" inačice sadrže kontinuirana poboljšanja postojeće inačice sustava. Obično se pojavljuju svakoga tjedna. Ako ovo onemogućite, bit ćete obaviješteni o nadogradnji samo u slučaju nove inačice sustava Moodle. Provjera nadogradnji dodataka nije obuhvaćena ovom postavkom.';
$string['upgrade197noticesubject'] = 'Obavijesti o Moodle 1.9.7 sigurnosnoj nadogradnji';
$string['upgrade197salt'] = 'Kako biste umanjili rizik od krađe lozinki, strogo se preporučuje podešavanje tzv. password salt.<br/>Pogledajte <a href="{$a}" target="_blank">password salt dokumentaciju</a> za opširnije informacije.';
$string['upgradeerror'] = 'Nepoznata pogreška pri nadogradnji dodatka {$a->plugin} na inačicu {$a->version}, nije moguće nastaviti.';
$string['upgradeforumread'] = 'Nova značajka za praćenje pročitanih / nepročitanih postova je dodana u Moodle 1.5. <br />Kako bi koristili ovu funkcionalnost <a href="{$a}">osvježite svoje tablice</a>.';
$string['upgradelogs'] = 'Za punu funkcionalnost, vaši zapisi moraju biti osvježeni.  <a href="{$a}">Opširnije</a>';
$string['upgradelogsinfo'] = 'Some changes have recently been made in the way logs are stored.  To be able to view all of your old logs on a per-activity basis, your old logs need to be upgraded.  Depending on your site this can take a long time (eg several hours) and can be quite taxing on the database for large sites.  Once you start this process you should let it finish (by keeping the browser window open).  Don\'t worry - your site will work fine for other people while the logs are being upgraded.<br /><br />Do you want to upgrade your logs now?';
$string['upgradepluginsfirst'] = '';
$string['upgradepluginsinfo'] = 'Nadogradnja dodataka';
$string['upgradepluginsinfo_help'] = 'Dostupne su nove inačice za neke od vaših dodataka. Moodle ih za sada ne može automatski nadograditi. Morate ih ručno preuzeti, postaviti na poslužitelj i instalirati.';
$string['upgradesettings'] = 'Nove postavke';
$string['upgradesettingsintro'] = 'Dolje navedene postavke su dodane tijekom zadnje Moodle nadogradnje. Promijenie sve zadane vrijednosti koje vam ne odgovaraju i nakon toga kliknite gumb &quot;Spremi promjene&quot; na dnu stranice.';
$string['upgradestalefiles'] = 'Otkrivene miješane Moodle inačice, nadogradnja se ne može nastaviti';
$string['upgradestalefilesinfo'] = 'Proces nadogradnje sustava pauziran je jer su u Moodle mapi pronađene PHP skripte napisane za Moodle barem dvije verzije stariji od ove.

Ovo može prouzročiti značajne probleme, stoga, prije nego nastavite, morate osigurati da su Moodle mapi nalaze samo datoteke jedne inačice sustava.

Preporučeni način čiščenja Moodle mape je ovaj:

* preimenujte trenutnu Moodle mapu u "moodle_old"
* stvorite novu Moodle mapu koja sadrži samo datoteke iz standardnog Moodle paketa, ili iz Moodle CVS/GIT repozitorija
* premjestite originalnu datoteku config.php i sve nestandardne dodatke iz mape "moodle_old" u novu mapu

Kada imate čistu Moodle mapu, osvježite ovu stranicu kako biste nastavili s procesom nadogradnje.

Ovo upozorenje se često pojavljuje nakon otpakiravanja standardnog Moodle paketa preko prošle inačice sustava. Ovo je u redu za manje nadogradnje, ali se nikako ne preporučuje za velike nadogradnje sustava.

Ovo upozorenje također može biti uzrokovano nepotpunom nadogradnjom iz CVS, SVN ili GIT repozitorija. U tom slučaju pričekajte da se započeta operacija završi, ili pokrenite operaciju čišćenja, pa pokušajte ponovno. Više informacija možete pronaći u dokumentaciji za nadogradnje na <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Nadogradnja';
$string['upgradesure'] = 'Moodle datoteke su promijenjene, automatski ćete nadograditi poslužitelj na ovu inačicu <br /><br /> <strong>{$a}</strong> <br /><br /> Nakon promjene, inačica se ne može vratiti na prethodnu. <br /><br /> Imajte na umu da proces može potrajati dulje vrijeme. <br /><br /> Želite li uistinu nadograditi poslužitelj na ovu inačicu?';
$string['upgradetimedout'] = 'Isteklo je vrijeme za nadogradnju, molimo ponovno pokrenite istu.';
$string['upgradingdata'] = 'Nadograđujem podatke';
$string['upgradinglogs'] = 'Nadograđujem zapise';
$string['upgradingversion'] = 'Nadogradnja na novu inačicu';
$string['upwards'] = 'prema gore';
$string['useblogassociations'] = 'Omogući povezivanje';
$string['useexternalyui'] = 'Koristi online YUI biblioteke';
$string['user'] = 'Korisnik';
$string['userbulk'] = 'Masovne operacije nad korisnicima';
$string['userlist'] = 'Pregled popisa korisnika';
$string['userpolicies'] = 'Pravila za korisnike';
$string['userpreference'] = 'Korisničke postavke';
$string['userquota'] = 'Korisnička kvota';
$string['users'] = 'Korisnici';
$string['usesitenameforsitepages'] = 'Koristi naziv sjedišta za stranice sjedišta';
$string['usetags'] = 'Omogući oznake';
$string['validateerror'] = 'Ova vrijednost nije valjana:';
$string['verifychangedemail'] = 'Ograniči domenu pri promjeni adrese e-pošte';
$string['warningcurrentsetting'] = 'Neispravna trenutna vrijednost: {$a}';
$string['warningiconvbuggy'] = 'Vaša inačica iconv biblioteke ne podržava //IGNORE modifikator. Trebate instalirati ekstenziju mbstring koja se može, umesto iconv biblioteke, koristiti za čišćenje nizova koji sadrže neispravne UTF-8 znakove.';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Unesite sljedeće opcije ako Moodle poslužitelj ne može izravno pristupiti internetu. Pristup internetu je potreban za preuzimanje podataka o okolini, jezičnih paketa, RSS kanala, vremenskih zona, itd. <br />
<em>Toplo se preporuča instalacija PHP cURL dodatka.</em>';
$string['xmlrpcrecommended'] = 'xmlrpc ekstenzija je potrebna za komunikaciju s čvorištem, a korisna je i za web servise, kao i MNet.';
$string['yuicomboloading'] = 'YUI combo se učitava';
$string['ziprequired'] = 'Moodle sada zahtijeva Zip PHP dodatak. info-ZIP i PclZip se više ne koriste.';
