<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'zh_cn', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = '新讨论区帖子';
$string['addanewdiscussion'] = '开启一个新话题';
$string['addanewquestion'] = '添加一个新问题';
$string['addanewtopic'] = '添加一个新话题';
$string['advancedsearch'] = '高级搜索';
$string['allforums'] = '全部讨论区';
$string['allowdiscussions'] = '允许 {$a} 在此讨论区发帖吗?';
$string['allowsallsubscribe'] = '每个人可以选择是否订阅该讨论区帖子';
$string['allowsdiscussions'] = '该讨论区允许每个人发起新话题。';
$string['allsubscribe'] = '订阅所有讨论区';
$string['allunsubscribe'] = '退订所有讨论区';
$string['alreadyfirstpost'] = '这已经是本话题的第一帖';
$string['anyfile'] = '任何文件';
$string['areaattachment'] = '附件';
$string['areapost'] = '消息';
$string['attachment'] = '附件';
$string['attachment_help'] = '您可以向一个帖子附加一个或多个文件。图片附件会在正文后显示。';
$string['attachmentnopost'] = '您不能导出没有帖子id的附件';
$string['attachments'] = '附件';
$string['attachmentswordcount'] = '附件数和字数';
$string['blockafter'] = '被阻塞前帖数极限';
$string['blockafter_help'] = '此项设置决定用户在指定的时长内最多允许发几个帖子。有mod/forum:postwithoutthrottling权限的用户不受此限。';
$string['blockperiod'] = '阻塞统计周期';
$string['blockperioddisabled'] = '不阻塞';
$string['blockperiod_help'] = '学生如果在指定的时长内发了达到指定数量的帖子，会被阻止继续发帖。有mod/forum:postwithoutthrottling权限的用户不受此限。';
$string['blogforum'] = '博客形式的标准讨论区';
$string['bynameondate'] = '由 {$a->name} 发表于 {$a->date}';
$string['cannotadd'] = '不能向此讨论区添加此话题';
$string['cannotadddiscussion'] = '在此讨论区新建话题必须是组内成员。';
$string['cannotadddiscussionall'] = '您没有向所有人添加新话题的权限';
$string['cannotaddsubscriber'] = '不能向此讨论区添加id为{$a}的订阅人！';
$string['cannotaddteacherforumto'] = '不能在课程的第0节添加转换过的教师讨论区';
$string['cannotcreatediscussion'] = '不能建立新话题';
$string['cannotcreateinstanceforteacher'] = '不能建立新的教师讨论区模块实例';
$string['cannotdeletepost'] = '您不能删除此帖！';
$string['cannoteditposts'] = '您不能编辑他人的帖子！';
$string['cannotfinddiscussion'] = '本讨论区中找不到这个话题';
$string['cannotfindfirstpost'] = '找不到讨论区的第一个帖子';
$string['cannotfindorcreateforum'] = '无法找到或建立网站的主新闻讨论区';
$string['cannotfindparentpost'] = '无法找到帖子{$a}的祖先';
$string['cannotmovefromsingleforum'] = '不能从单个话题讨论区移动话题';
$string['cannotmovenotvisible'] = '讨论区不可见';
$string['cannotmovetonotexist'] = '您不能移动到那个讨论区 - 它不存在';
$string['cannotmovetonotfound'] = '课程中找不到目标讨论区';
$string['cannotmovetosingleforum'] = '不能将话题移动到单个简单话题讨论区';
$string['cannotpurgecachedrss'] = '无法清理目标或源讨论区的RSS种子缓存 - 检查你的文件permissionsforums';
$string['cannotremovesubscriber'] = '不能从此讨论区删除id为{$a}的订阅人！';
$string['cannotreply'] = '您不能回复此帖';
$string['cannotsplit'] = '此讨论区的话题不能被分割';
$string['cannotsubscribe'] = '抱歉，您必须是小组成员才能订阅。';
$string['cannottrack'] = '无法停止对该讨论区的跟踪';
$string['cannotunsubscribe'] = '不能取消您对该讨论区的订阅';
$string['cannotupdatepost'] = '您不能更新这个帖子';
$string['cannotviewpostyet'] = '在这个讨论中您不能阅读别的同学的问题因为您没有权限';
$string['cannotviewusersposts'] = '您能查看的帖子里没有此用户发表的。';
$string['cleanreadtime'] = '标记旧帖为已读的时间';
$string['completiondiscussions'] = '学生必须开启话题：';
$string['completiondiscussionsgroup'] = '必须开话题';
$string['completiondiscussionshelp'] = '开新话题后才算完成';
$string['completionposts'] = '学生必须发布话题或回帖：';
$string['completionpostsgroup'] = '必须发帖';
$string['completionpostshelp'] = '开新话题或回帖后才算完成';
$string['completionreplies'] = '学生必须回帖：';
$string['completionrepliesgroup'] = '必须回帖';
$string['completionreplieshelp'] = '回帖后才算完成';
$string['configcleanreadtime'] = '在几点清理“read”表中的旧帖子。';
$string['configdigestmailtime'] = '系统每天会给那些希望以文摘形式接受邮件的人发送文摘。这个选项控制着每日发送文摘邮件的时间(下一个在此时间后运行的cron程序将会发出这些信件)。';
$string['configdisplaymode'] = '讨论的缺省显示模式';
$string['configenablerssfeeds'] = '这个选项使所有讨论区支持 RSS 种子。您仍需手工激活每一个讨论区配置中的 RSS 种子选项。';
$string['configenabletimedposts'] = '如果您想在讨论区发帖时可以设置显示周期，将此设置为“是”（试验性，未完全测试）';
$string['configlongpost'] = '超过该长度(字符个数，不含 HTML)的帖子被认为是长帖子。在网站首页、社区格式的课程页或用户资料显示的帖子会被精简到一个自然的中断位置，其长度在 forum_shortpost 和 forum_longpost 之间。';
$string['configmanydiscussions'] = '每页显示的讨论主题数';
$string['configmaxattachments'] = '每个帖子缺省允许的最大附件数。';
$string['configmaxbytes'] = '缺省的所有讨论区最大附件尺寸(受课程设置和本地配置的限制)';
$string['configoldpostdays'] = '帖子在多少天后应当被视为已读。';
$string['configreplytouser'] = '当通过email发送讨论区中的帖子时，是否可以包含用户的email地址，以便收信人可以直接而不是通过讨论区回复发帖人？即使设置为“是”，用户仍可以在他们的个人资料里设置email地址为保密。';
$string['configshortpost'] = '少于该长度(字符个数，不含 HTML)的帖子被认为是短的（见下一项）。';
$string['configtrackingtype'] = '阅读跟踪信息的默认设置';
$string['configtrackreadposts'] = '如果希望跟踪每一个用户的已读/未读信息则设定为“是”。';
$string['configusermarksread'] = '若设定为“是”则用户必须手动将帖子标记为已读。如果设定为“否”，则帖子被浏览时自动标记为已读。';
$string['confirmsubscribe'] = '您确定要订阅讨论区“{$a}”吗？';
$string['confirmunsubscribe'] = '您确定要取消订阅讨论区“{$a}”吗？';
$string['couldnotadd'] = '由于一个未知的错误，您的帖子无法发表';
$string['couldnotdeletereplies'] = '很抱歉，已经有跟帖的帖子不能删除';
$string['couldnotupdate'] = '由于一个未知的错误，您的帖子无法更新';
$string['delete'] = '删除';
$string['deleteddiscussion'] = '讨论话题已被删除';
$string['deletedpost'] = '帖子已删除';
$string['deletedposts'] = '那些帖子已删除';
$string['deletesure'] = '您确定要删除该帖吗?';
$string['deletesureplural'] = '您确定要删除这个帖子及其回复吗？({$a} 个帖子)';
$string['digestmailheader'] = '这是 {$a->sitename} 讨论区的每日新帖摘要。要修改您的关于讨论区的偏好，请访问 {$a->userprefs}。';
$string['digestmailpost'] = '更改讨论区摘要的默认设置';
$string['digestmailprefs'] = '您的用户信息';
$string['digestmailsubject'] = '{$a}: 讨论区摘要';
$string['digestmailtime'] = '发送邮件摘要的时间（整点）';
$string['digestsentusers'] = '已经成功地向 {$a} 位用户发送了Email摘要。';
$string['disallowsubscribe'] = '不允许订阅';
$string['disallowsubscribeteacher'] = '不允许订阅(教师除外)';
$string['discussion'] = '话题';
$string['discussionmoved'] = '该讨论已被移到“{$a}”。';
$string['discussionmovedpost'] = '此话题已经移到</a>讨论区<a href="{$a->forumhref}">{$a->forumname}</a>中的<a href="{$a->discusshref}">这里了</a>';
$string['discussionname'] = '话题名称';
$string['discussions'] = '话题';
$string['discussionsstartedby'] = '由 {$a} 发起的话题';
$string['discussionsstartedbyrecent'] = '最近由 {$a} 发起的话题';
$string['discussionsstartedbyuserincourse'] = '{$a->fullname}在{$a->coursename}中发起的话题';
$string['discussthistopic'] = '讨论这个话题';
$string['displayend'] = '结束时间';
$string['displayend_help'] = '<p align="center"><b>讨论区显示时期</b></p>

<p>可以选择是否将讨论区帖子在一定的时间显示。</p>

<p>激活选项后可以选择开始和结束的日期。</p>

<p>注意：管理员用户可以看到所有帖子，无论是在开始前还是过期后。</p>
<span style="font-weight: bold;">翻译者：况亮</span><br style="font-weight: bold;" /><span style="font-weight: bold;">Email：kuangliang12345@163.com</span><br style="font-weight: bold;" /><span style="font-weight: bold;">翻译日期：2007年3月4日</span><br />';
$string['displaymode'] = '显示模式';
$string['displayperiod'] = '可视时段';
$string['displaystart'] = '开始时间';
$string['displaystart_help'] = '<p align="center"><b>讨论区显示时期</b></p>

<p>可以选择是否将讨论区帖子在一定的时间显示。</p>

<p>激活选项后可以选择开始和结束的日期。</p>

<p>注意：管理员用户可以看到所有帖子，无论是在开始前还是过期后。</p>
<span style="font-weight: bold;">翻译者：况亮</span><br style="font-weight: bold;" /><span style="font-weight: bold;">Email：kuangliang12345@163.com</span><br style="font-weight: bold;" /><span style="font-weight: bold;">翻译日期：2007年3月4日</span><br />';
$string['displaywordcount'] = '显示字数';
$string['displaywordcount_help'] = '是否需要显示每个帖子的总字数？';
$string['eachuserforum'] = '每个人发表一个话题';
$string['edit'] = '编辑';
$string['editedby'] = '由 {$a->name} 修改 - 原提交时间 {$a->date}';
$string['editedpostupdated'] = '{$a}的帖子已更新';
$string['editing'] = '正在编辑';
$string['emaildigest_0'] = '每个帖子你都会收到一封邮件';
$string['emaildigest_1'] = '每天都会收到一封包含完整帖子内容的邮件';
$string['emaildigest_2'] = '每天都会收到一封只包含帖子主题的邮件';
$string['emaildigestcompleteshort'] = '完整帖子';
$string['emaildigestdefault'] = '默认 {$a}';
$string['emaildigestoffshort'] = '没有摘要';
$string['emaildigestsubjectsshort'] = '只有主题';
$string['emaildigesttype'] = '发送邮件摘要的选项';
$string['emaildigesttype_help'] = '你从讨论区收到的通知，可分成四种类型：
*默认 -- 会根据你在个人资料中关于帖子摘要的设定；
*没有摘要 -- 每个新帖子，你都会收到一封邮件；
*摘要/内容 -- 每个新帖子，你都会收到一封包含帖子全文的邮件；
*摘要/主题 -- 每个新帖子，你都会收到一封含摘要和主题的邮件。';
$string['emaildigestupdated'] = '这是发送帖子摘要的选项，已经把 \'{$a->forum}\'更改为 \'{$a->maildigesttitle}\' 。 {$a->maildigestdescription}';
$string['emaildigestupdated_default'] = '\'{$a->forum}\'讨论区将使用你在资料中的\'{$a->maildigesttitle}\'默认设置。{$a->maildigestdescription}';
$string['emptymessage'] = '您的帖子有些问题。可能这是个空帖子，或者附件太大了。您的更改<strong>没有</strong>被保存。';
$string['erroremptymessage'] = '帖子正文不能为空';
$string['erroremptysubject'] = '帖子标题不能为空。';
$string['errorenrolmentrequired'] = '您必须先选修此课才能访问此内容';
$string['errorwhiledelete'] = '删除记录时发生错误。';
$string['event_assessable_uploaded'] = '某些已经发到讨论区';
$string['everyonecanchoose'] = '任何人均可选择订阅';
$string['everyonecannowchoose'] = '现在任何人均可选择订阅';
$string['everyoneisnowsubscribed'] = '现在所有人都订阅了该讨论区';
$string['everyoneissubscribed'] = '所有人都订阅了该讨论区';
$string['existingsubscribers'] = '个订阅者';
$string['exportdiscussion'] = '导出整个话题';
$string['forcedreadtracking'] = '强制阅读跟踪';
$string['forcedreadtracking_desc'] = '允许讨论区设置为“强制阅读跟踪”，可能导致某些课程运行效能降低，特别是在含有多个讨论区和帖子的课程中。若以后关闭此选项，以前的设置为“强制的”都会更改为“自行选择”。';
$string['forcessubscribe'] = '该讨论区强制每个人都订阅';
$string['forum'] = '讨论区';
$string['forum:addinstance'] = '添加新讨论区';
$string['forum:addnews'] = '发布新闻';
$string['forum:addquestion'] = '提问';
$string['forum:allowforcesubscribe'] = '允许强制订阅';
$string['forumauthorhidden'] = '作者(隐藏)';
$string['forumblockingalmosttoomanyposts'] = '您已经达到发帖的极限。在过去的 {$a->blockperiod} 里，您已经发表了 {$a->numposts} 个帖子。这个极限是 {$a->blockafter} 个帖子。';
$string['forumbodyhidden'] = '您不能看这个帖子，可能因为您还没有参与到这个话题中，或者还未达到帖子的最长编辑时限，或者讨论还未开始或已经结束。';
$string['forum:createattachment'] = '上传附件';
$string['forum:deleteanypost'] = '删除任何帖子（任何时间）';
$string['forum:deleteownpost'] = '删除自己的帖子（在截止时间之内）';
$string['forum:editanypost'] = '编辑任何帖子';
$string['forum:exportdiscussion'] = '导出整个话题';
$string['forum:exportownpost'] = '导出自己的帖子';
$string['forum:exportpost'] = '导出帖子';
$string['forumintro'] = '讨论区简介';
$string['forum:managesubscriptions'] = '管理订阅';
$string['forum:movediscussions'] = '移动话题';
$string['forumname'] = '讨论区名称';
$string['forumposts'] = '讨论区帖子';
$string['forum:postwithoutthrottling'] = '不受发帖阈值限制';
$string['forum:rate'] = '评价帖子';
$string['forum:replynews'] = '回复新闻';
$string['forum:replypost'] = '回复帖子';
$string['forums'] = '讨论区';
$string['forum:splitdiscussions'] = '分割话题';
$string['forum:startdiscussion'] = '开启新的话题';
$string['forumsubjecthidden'] = '主题(隐藏)';
$string['forumtracked'] = '跟踪未读帖子';
$string['forumtrackednot'] = '不跟踪未读帖子';
$string['forumtype'] = '讨论区类型';
$string['forumtype_help'] = '有5种讨论区类型：

* 单个简单话题 - 一个简单的话题，每个人都可以回复
* 每人发布一个话题 - 每名学生都可以发布一个（也只能一个）新话题，所有人都可以回复。
* 提问与回答讨论区 - 学生必须先发表他的见解，才能看到别人的帖子。
* 博客形式的标准讨论区 - 一个开放的讨论区，任何人在任何时间都可以发起一个新话题。所有话题都显示在一个页面中。每个话题都有一个“讨论此话题”的链接
* 一般用途的标准讨论区 - 一个开放的讨论区，任何人在任何时间都可以发起一个新话题。';
$string['forum:viewallratings'] = '查看所有由个人给出的原始评分';
$string['forum:viewanyrating'] = '查看任何人的总分';
$string['forum:viewdiscussion'] = '阅读话题';
$string['forum:viewhiddentimedposts'] = '阅读隐藏的定时帖子';
$string['forum:viewqandawithoutposting'] = '始终可看提问帖和回答帖';
$string['forum:viewrating'] = '查看自己的总分';
$string['forum:viewsubscribers'] = '查看订阅者';
$string['generalforum'] = '一般用途的标准讨论区';
$string['generalforums'] = '普通讨论区';
$string['hiddenforumpost'] = '隐藏讨论区帖子内容';
$string['inforum'] = '在 {$a} 里';
$string['introblog'] = '本讨论区的帖子自动拷贝自课程的博客用户。那些博客将不能再使用。';
$string['intronews'] = '普通新闻与通告';
$string['introsocial'] = '开放的讨论区，可以随便聊聊';
$string['introteacher'] = '教师专用讨论区';
$string['invalidaccess'] = '本页面没有被正确访问';
$string['invaliddigestsetting'] = '邮件摘要设置无效';
$string['invaliddiscussionid'] = '话题ID不正确或不再存在';
$string['invalidforcesubscribe'] = '无效的强制订阅模式';
$string['invalidforumid'] = '讨论区ID错误';
$string['invalidparentpostid'] = '父帖子的ID错误';
$string['invalidpostid'] = '无效的帖子ID - {$a}';
$string['lastpost'] = '最后回帖';
$string['learningforums'] = '学习讨论区';
$string['longpost'] = '长帖';
$string['mailnow'] = '立刻发送邮件';
$string['manydiscussions'] = '每页讨论的话题数';
$string['markalldread'] = '将此话题中的所有帖子标记为已读';
$string['markallread'] = '将此讨论区中的所有帖子标记为已读';
$string['markread'] = '标记为已读';
$string['markreadbutton'] = '标记<br />已读';
$string['markunread'] = '标记为未读';
$string['markunreadbutton'] = '标记<br />未读';
$string['maxattachments'] = '附件个数上限';
$string['maxattachments_help'] = '此项设置决定了一个帖子可以拥有的最大附件数。';
$string['maxattachmentsize'] = '允许上传的附件大小';
$string['maxattachmentsize_help'] = '<p align="center"><b>最大附件尺寸</b></p>

<p>附件的文件尺寸是可以限制的，创建讨论区的人可以设置它。</p>

<p>有时，您可以提交一个比这个尺寸大的文件，但这个文件不会被保存下来，且您会看到一个错误信息。</p>';
$string['maxtimehaspassed'] = '很抱歉，编辑该帖的时间限制({$a})已过！';
$string['message'] = '正文';
$string['messageprovider:digests'] = '订阅讨论区摘要';
$string['messageprovider:posts'] = '订阅的讨论区帖子';
$string['missingsearchterms'] = '下列搜索词只出现在正文的 HTML 标记中：';
$string['modeflatnewestfirst'] = '列表显示回帖内容，新帖在前';
$string['modeflatoldestfirst'] = '列表显示回帖内容，旧帖在前';
$string['modenested'] = '嵌套显示回帖内容';
$string['modethreaded'] = '树状显示回帖标题';
$string['modulename'] = '讨论区';
$string['modulename_help'] = '在讨论区模块用户可以进行异步的讨论。';
$string['modulenameplural'] = '讨论区';
$string['more'] = '更多';
$string['movedmarker'] = '（移动）';
$string['movethisdiscussionto'] = '将此论题移至...';
$string['mustprovidediscussionorpost'] = '导出时，您必须提供一个话题id或帖子id';
$string['namenews'] = '新闻讨论区';
$string['namenews_help'] = '新闻讨论区，是一个用来发布消息的特别讨论区，在课程建立时会被自动创建。每门课程只能有一个新闻讨论区。只有教师和管理员可以在新闻讨论区发帖。“最近新闻”版块会显示新闻讨论区最近的讨论。';
$string['namesocial'] = '公众讨论区';
$string['nameteacher'] = '教师讨论区';
$string['newforumposts'] = '新帖子';
$string['noattachments'] = '此帖没有附件';
$string['nodiscussions'] = '该讨论区尚无讨论话题';
$string['nodiscussionsstartedby'] = '{$a}未发起任何话题';
$string['nodiscussionsstartedbyyou'] = '您还没有发起任何话题';
$string['noguestpost'] = '很抱歉，访客不允许发帖';
$string['noguesttracking'] = '很抱歉，访客不能设定跟踪选项。';
$string['nomorepostscontaining'] = '未找到关键词是“{$a}”的帖子';
$string['nonews'] = '尚无消息发布';
$string['noonecansubscribenow'] = '现在开始禁止订阅';
$string['nopermissiontosubscribe'] = '您没有查看讨论区订阅者的权限';
$string['nopermissiontoview'] = '您没有查看此帖子的权限';
$string['nopostforum'] = '很抱歉，您不能在此讨论区发帖';
$string['noposts'] = '没有帖子';
$string['nopostsmadebyuser'] = '{$a}没有发过贴';
$string['nopostsmadebyyou'] = '您还没发过任何帖子';
$string['noquestions'] = '此讨论区尚无人提问';
$string['nosubscribers'] = '尚无人订阅此讨论区';
$string['notexists'] = '话题已不存在';
$string['nothingnew'] = '{$a} 中没有什么新东西';
$string['notingroup'] = '很抱歉, 您需要是一个组的成员才能浏览这个讨论区。';
$string['notinstalled'] = '讨论区模块没有被安装';
$string['notpartofdiscussion'] = '此帖不是话题的一部分';
$string['notrackforum'] = '不跟踪未读帖子';
$string['noviewdiscussionspermission'] = '您无权查看这个讨论区的话题';
$string['nowallsubscribed'] = '已订阅 {$a} 中的所有讨论区。';
$string['nowallunsubscribed'] = '已退订 {$a} 中的所有讨论区';
$string['nownotsubscribed'] = '{$a->name}将不再收到“{$a->forum}”新帖子的通知';
$string['nownottracking'] = '{$a->name} 不再跟踪“{$a->forum}”了。';
$string['nowsubscribed'] = '“{$a->forum}”有新帖子会通知{$a->name}';
$string['nowtracking'] = '{$a->name} 现在跟踪“{$a->forum}”。';
$string['numposts'] = '{$a} 个帖子';
$string['olderdiscussions'] = '旧的讨论话题';
$string['oldertopics'] = '旧话题';
$string['oldpostdays'] = '多少天后标为已读';
$string['openmode0'] = '不能发起新话题，也不能回帖';
$string['openmode1'] = '不能发起新话题，但允许回复';
$string['openmode2'] = '发起新话题和回帖均允许';
$string['overviewnumpostssince'] = '上次登录后有 {$a} 个新帖子';
$string['overviewnumunread'] = '共 {$a} 个未阅读';
$string['page-mod-forum-discuss'] = '讨论区模块话题页';
$string['page-mod-forum-view'] = '讨论区模块主页';
$string['page-mod-forum-x'] = '任意讨论区模块页面';
$string['parent'] = '显示父帖子';
$string['parentofthispost'] = '该帖的父帖';
$string['pluginadministration'] = '讨论区管理';
$string['pluginname'] = '讨论区';
$string['postadded'] = '<p>您的帖子已经成功发表。</p>
<p>如果需要，可以在 {$a} 内修改它。</p>';
$string['postaddedsuccess'] = '您的帖子已成功发布';
$string['postaddedtimeleft'] = '{$a}内您可以继续编辑它，如果您想修改的话。';
$string['postbyuser'] = '{$a->post} 由 {$a->user} 所发';
$string['postincontext'] = '在上下文中看此帖';
$string['postmailinfo'] = '这是一份来自网站 {$a} 的帖子。

点击此链接回复：';
$string['postmailnow'] = '<p>这个帖子将会被立即发给所有讨论订阅者。</p>';
$string['postrating1'] = '极端独立型';
$string['postrating2'] = '独立型与情景型兼备';
$string['postrating3'] = '极端情景型';
$string['posts'] = '帖子';
$string['postsmadebyuser'] = '{$a}的帖子';
$string['postsmadebyuserincourse'] = '{$a->fullname}在{$a->coursename}中的帖子';
$string['posttoforum'] = '发到讨论区上';
$string['postupdated'] = '您的帖子已经更新';
$string['potentialsubscribers'] = '潜在订阅者';
$string['processingdigest'] = '正在为用户 {$a} 处理邮件摘要';
$string['processingpost'] = '正在处理帖子 {$a}';
$string['prune'] = '分割';
$string['prunedpost'] = '从该帖子创建了新的论题';
$string['pruneheading'] = '分割此话题并将此帖移到一个新话题中';
$string['qandaforum'] = '问题及解答讨论区';
$string['qandanotify'] = '这是一个问题和解答讨论区。为了能看到其他人的回应，您首先需要发表您的解答';
$string['re'] = '回复:';
$string['readtherest'] = '阅读剩余部分';
$string['replies'] = '回帖';
$string['repliesmany'] = '迄今有 {$a} 个回帖';
$string['repliesone'] = '迄今有 {$a} 个回帖';
$string['reply'] = '回复';
$string['replyforum'] = '回复到讨论区上';
$string['replytouser'] = '在回复中使用Email地址';
$string['resetforums'] = '删除哪类讨论区类型中帖子';
$string['resetforumsall'] = '删除所有的帖子';
$string['resetsubscriptions'] = '删除所有讨论区订阅';
$string['resettrackprefs'] = '删除讨论区中的所有跟踪参数';
$string['rssarticles'] = 'RSS最近文章数';
$string['rssarticles_help'] = '<p align="center"><b>在RSS中包含的文章数目</b></p>

<p>这个选项允许您设置在RSS种子中包含的文章数目。</p>

<p>对于大多数讨论区来说，5至20之间就可以了，如果您的讨论区用户真的很多，可以设大一些。</p>';
$string['rsssubscriberssdiscussions'] = '话题的RSS种子';
$string['rsssubscriberssposts'] = '帖子的RSS种子';
$string['rsstype'] = '本活动的RSS种子';
$string['rsstype_help'] = '<p align="center"><b>讨论区的RSS种子</b></p>

<p>这个选项允许您开启这个讨论区的RSS种子。</p>

<p>您可以选择两种类型：</p>

<ul>
<li><b>话题：</b>在这种情况下，RSS种子中会包括新的话题。</li>

<li><b>帖子：</b>在这种情况下，RSS种子中会包含每一篇新的帖子。</li>
</ul>';
$string['search'] = '搜索';
$string['searchdatefrom'] = '帖子必须在此时间之后发布';
$string['searchdateto'] = '帖子必须在此时间之前发布';
$string['searchforumintro'] = '请在下面的一个或多个项目中输入搜索词条：';
$string['searchforums'] = '搜索讨论区';
$string['searchfullwords'] = '这些词应当作为完整的词出现';
$string['searchnotwords'] = '这些词应当不包含在其中';
$string['searcholderposts'] = '搜索旧帖子...';
$string['searchphrase'] = '这个词组必须出现在帖子中';
$string['searchresults'] = '搜索结果';
$string['searchsubject'] = '这些文字应当出现在标题中';
$string['searchuser'] = '此名字要和作者匹配';
$string['searchuserid'] = '作者的Moodle ID';
$string['searchwhichforums'] = '选择要搜索哪个讨论区';
$string['searchwords'] = '这些文字可以在帖子的任何位置出现';
$string['seeallposts'] = '查看此用户发表的全部帖子';
$string['shortpost'] = '短帖';
$string['showsubscribers'] = '显示/修改订阅者';
$string['singleforum'] = '单个简单话题';
$string['smallmessage'] = '{$a->user}在{$a->forumname}发帖';
$string['startedby'] = '发起人';
$string['subject'] = '主题';
$string['subscribe'] = '订阅此讨论区';
$string['subscribeall'] = '为所有人订阅此讨论区';
$string['subscribed'] = '订阅';
$string['subscribeenrolledonly'] = '抱歉，只有已选课用户才能订阅讨论区帖子通知。';
$string['subscribenone'] = '让所有人退订此讨论区';
$string['subscribers'] = '订阅者';
$string['subscribersto'] = '订阅“{$a}”的用户';
$string['subscribestart'] = '通过email发讨论区帖子给我';
$string['subscribestop'] = '我不想通过email接收讨论区帖子';
$string['subscription'] = '订阅';
$string['subscriptionauto'] = '自动订阅';
$string['subscriptiondisabled'] = '禁止订阅';
$string['subscriptionforced'] = '强制订阅';
$string['subscription_help'] = '如果您订阅了一个讨论区，那意味着您将通过email收到讨论区里每个帖子的拷贝。通常您可以自己选择是否订阅。但是，有时订阅是强制性的，使每个人都必须收到帖子的email拷贝。';
$string['subscriptionmode'] = '订阅模式';
$string['subscriptionmode_help'] = '当用户订阅了讨论区时，他们会通过email收到帖子的拷贝。

有四种订阅模式选项：

* 可选订阅 - 用户可以选择设法订阅
* 强制订阅 - 每个人都被订阅，而且不能取消订阅
* 自动订阅 - 每个人最初都被订阅，但是随时可以选择是否退订
* 禁止订阅 - 不允许订阅';
$string['subscriptionoptional'] = '可选订阅';
$string['subscriptions'] = '订阅';
$string['thisforumisthrottled'] = '这个讨论区有规定周期内发帖数的限制，它被设置为 {$a->blockperiod} 内最多发 {$a->blockafter} 个帖子。';
$string['timedposts'] = '定时帖子';
$string['timestartenderror'] = '可视时段的结束时间不能早于开始时间。';
$string['trackforum'] = '跟踪未读帖子';
$string['tracking'] = '跟踪';
$string['trackingoff'] = '关闭';
$string['trackingon'] = '开启';
$string['trackingoptional'] = '可选';
$string['trackingtype'] = '是否跟踪此讨论区的阅读情况';
$string['trackingtype_help'] = '如果激活，用户可以跟踪讨论区和话题里已阅读和没阅读的消息。

有三个选项：

* 可选 - 用户可以自行决定跟踪或不跟踪
* 开启 - 跟踪永远打开
* 关闭 - 跟踪永远关闭';
$string['unread'] = '未读';
$string['unreadposts'] = '未读帖子';
$string['unreadpostsnumber'] = '{$a} 条未读帖子';
$string['unreadpostsone'] = '1 条未读帖子';
$string['unsubscribe'] = '不再订阅该讨论区';
$string['unsubscribeall'] = '取消所有讨论区订阅';
$string['unsubscribeallconfirm'] = '您目前订阅了{$a}。您确认要取消所有讨论区的订阅，并禁止自动订阅吗？';
$string['unsubscribealldone'] = '已为您取消所有可选的订阅，但仍能收到强制订阅的通知。到“我的个人资料”设置中的消息页面管理讨论区通知。';
$string['unsubscribeallempty'] = '您没有订阅任何讨论区。到“我的个人资料”设置中的消息页面可以设置不接收本站的任何通知。';
$string['unsubscribed'] = '未订阅';
$string['unsubscribeshort'] = '退订';
$string['usermarksread'] = '手动标记阅读消息';
$string['viewalldiscussions'] = '查看所有话题';
$string['warnafter'] = '发多少帖后警告';
$string['warnafter_help'] = '当学生将达到某一时长内允许的最大发帖数时，会被警告。此项设置决定了发多少个帖子后会被警告。有mod/forum:postwithoutthrottling权限的用户不受此限。';
$string['warnformorepost'] = '警告！此讨论区有不只一个话题——正使用最新话题';
$string['yournewquestion'] = '您的新问题';
$string['yournewtopic'] = '您的新讨论话题';
$string['yourreply'] = '您的回复';
