<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'webservice', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   webservice
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessexception'] = 'Izuzetak kontrole pristupa';
$string['actwebserviceshhdr'] = 'Aktivni protokoli Web servisa';
$string['addaservice'] = 'Dodaj servis';
$string['addcapabilitytousers'] = 'Provjeri sposobnosti korisnika';
$string['addcapabilitytousersdescription'] = 'Korisnici treba da imaju dvije sposobnosti - webservice:createtoken i sposobnost koja odgovara protokolu koji se koristi, npr. webservice/rest:use, webservice/soap:use. Da biste to postigli kreirajte ulogu za Web servis sa dopuštenim odgovorajućim sposobnostima i dodijelite je korisniku Web servisa kao sistemsku ulogu.';
$string['addfunction'] = 'Dodaj funkciju';
$string['addfunctionhelp'] = 'Izaberite funkciju koju želite da dodate servisu.';
$string['addfunctions'] = 'Dodaj funkcije';
$string['addfunctionsdescription'] = 'Izaberi neophodne funkcije za novokreirani servis';
$string['addrequiredcapability'] = 'Dodijeli/ukloni potrebnu sposobnost';
$string['addservice'] = 'Dodaj novi servis: {$a->name} (id: {$a->id})';
$string['addservicefunction'] = 'Dodaj funkcije servisu "{$a}"';
$string['allusers'] = 'Svi korisnici';
$string['amftestclient'] = 'AMF test klijent';
$string['apiexplorer'] = 'API istraživač';
$string['apiexplorernotavalaible'] = 'API istraživač još nije dostupan.';
$string['arguments'] = 'Argumenti';
$string['authmethod'] = 'Način provjere identiteta';
$string['cannotcreatetoken'] = 'Nema dozvola za kreiranje tokena web servisa za servis {$a}.';
$string['cannotgetcoursecontents'] = 'Nije moguće dobiti sadržaj kurseva';
$string['checkusercapability'] = 'Provjeri sposobnosti korisnika';
$string['checkusercapabilitydescription'] = 'Korisnik treba da ima odgovorajuće sposobnosti shodno protokolu koji se koristi, npr. webservice/rest:use, webservice/soap:use. Da biste to postigli kreirajte ulogu za Web servis sa dopuštenim sposobnostima za izvršenje protokola i dodijelite je korisniku Web servisa kao sistemsku ulogu.';
$string['configwebserviceplugins'] = 'Iz razloga sigurnosti treba da budu uključeni samo protokoli koji se koriste.';
$string['context'] = 'Kontekst';
$string['createservicedescription'] = 'Servis predstavlja skup funkcija Web servisa. Da bi korisnik mogao da pristupi novom servisu dozvolićete njegovu upotrebu. Na stranici <strong>Dodaj servis </strong> označite opcije Omogući\' i \'Autorizovani korisnik\'. Izaberite i \'Nema zahtjevane sposobnosti\'.';
$string['createserviceforusersdescription'] = 'Servis predstavlja skup funkcija Web servisa. Da bi korisnik mogao da pristupi novom servisu dozvolićete njegovu upotrebu. Na stranici <strong>Dodaj servis </strong> označite opcije Omogući\' i uklonite oznaku sa opcije \'Autorizovani korisnik\'. Izaberite i \'Nema zahtjevane sposobnosti\'.';
$string['createtoken'] = 'Kreiraj token';
$string['createtokenforuser'] = 'Kreiraj token za korisnika';
$string['createtokenforuserdescription'] = 'Kreiraj token za korisnika Web servisa';
$string['createuser'] = 'Kreiraj specifičnog korisnika';
$string['createuserdescription'] = 'Korisnik Web servisa je neophodan kako bi predstavljao sistem koji kontroliše Moodle.';
$string['criteriaerror'] = 'Nedostaju dozvole za pretragu prema kriterijima';
$string['default'] = 'Zadano za "{$a}"';
$string['deleteaservice'] = 'Obriši servis';
$string['deleteservice'] = 'Obriši servis: {$a->name} (id: {$a->id})';
$string['deleteserviceconfirm'] = 'Brisanjem servisa biće također obrisan tokeni koji se odnose na taj servis. Da li stvarno želite da obrišete vanjski servis "{$a}"?';
$string['deletetokenconfirm'] = 'Da li stvarno želite da obrišete ovaj token Web servisa za <strong>{$a->user}</strong> na servis <strong>{$a->service}</strong>?';
$string['disabledwarning'] = 'Svi protokoli Web servisa su onemogućeni. Podešavanje "Omogući Web servise" možete naći među naprednim funkcijama.';
$string['doc'] = 'Dokumentacija';
$string['docaccessrefused'] = 'Nije Vam dozvoljeno da vidite dokumentaciju za ovaj token';
$string['documentation'] = 'dokumentacija Web servisa';
$string['downloadfiles'] = 'Moguće je preuzimanje datoteka';
$string['downloadfiles_help'] = 'Ako je ova opcija omogućena, bilo koji korisnik može da preuzme datoteke sa njihovim sigurnosnim ključevima. Naravno, ovo se odnosi samo na one datoteke na sajtu za koje postoji dozvola za preuzimanje.';
$string['editaservice'] = 'Uredi servis';
$string['editservice'] = 'Uredi servis: {$a->name} (id: {$a->id})';
$string['enabled'] = 'Omogućeno';
$string['enabledocumentation'] = 'Omogući dokumentaciju za razvojne programere';
$string['enabledocumentationdescription'] = 'Detaljna dokumentacija Web servisa je dostupna za omogućene protokole.';
$string['enablemobilewsoverview'] = 'Idite na {$a->manageservicelink} stranicu za administraciju, provjerite podešavanje "{$a->enablemobileservice}" i sačuvajte. Sve će biti podešeno za vas i svi korisnici sajta će moći da koriste zvaničnu Moodle aplikaciju. Trenutni status: {$a->wsmobilestatus}';
$string['enableprotocols'] = 'Omogući protokole';
$string['enableprotocolsdescription'] = 'Najmanje jedan protokol mora biti uključen. Iz razloga sigurnosti, treba omogućite samo one protokole koji će se koristiti.';
$string['enablews'] = 'Omogući Web servise';
$string['enablewsdescription'] = 'Web servisi moraju da budu omogućeni u naprednim funkcijama.';
$string['entertoken'] = 'Unesite sigurnosni ključ (token)';
$string['error'] = 'Greška: {$a}';
$string['errorcatcontextnotvalid'] = 'Ne možete da izvršite funkciju u kontekstu kategorije (category id:{$a->catid}). Poruka o grešci konteksta glasi: {$a->message}';
$string['errorcodes'] = 'Poruka o grešci';
$string['errorcoursecontextnotvalid'] = 'Ne možete da izvršite funkciju u kontekstu kursa (course id:{$a->courseid}). Poruka o grešci konteksta glasi: {$a->message}';
$string['errorinvalidparam'] = 'Parametar "{$a}" nije ispravan.';
$string['errornotemptydefaultparamarray'] = 'Parametar opisa Web servisa koji se naziva \'{$a}\' je jednostavna ili višestruka struktura. Zadana vrijednost je da on može biti samo prazan niz. Provjerite opis Web servisa.';
$string['erroroptionalparamarray'] = 'Parametar opisa Web servisa koji se naziva \'{$a}\' je jednostavna ili višestruka struktura. Ne može biti podešen kao VALUE_OPTIONAL. Provjerite opis Web servisa.';
$string['event_webservice_function_called'] = 'Funkcija web servisa je pozvana';
$string['event_webservice_login_failed'] = 'Prijava na web servis nije uspjela';
$string['event_webservice_service_created'] = 'Usluga web servisa je kreirana';
$string['event_webservice_service_updated'] = 'Web servis je ažuriran';
$string['event_webservice_service_user_added'] = 'Servis korisnika web servisa dodan';
$string['event_webservice_service_user_removed'] = 'Servis korisnika web servisa uklonjen';
$string['event_webservice_token_created'] = 'Token web servisa kreiran';
$string['event_webservice_token_sent'] = 'Token web servisa poslan';
$string['execute'] = 'Izvrši';
$string['executewarnign'] = 'UPOZORENJE: Ako pokrenete izvršavanje Vaša baza podataka će biti izmijenjena a promjene ne mogu biti automatski poništene!';
$string['externalservice'] = 'Vanjski servis';
$string['externalservicefunctions'] = 'Funkcije vanjskog servisa';
$string['externalservices'] = 'Vanjski servisi';
$string['externalserviceusers'] = 'Korisnici vanjskog servisa';
$string['failedtolog'] = 'Neuspješna prijava';
$string['filenameexist'] = 'Naziv datoteke već postoji: {$a}';
$string['forbiddenwsuser'] = 'Nije moguće kreirati token za nepotvrđenog, obrisanog, suspendovanog ili korisnika u ulozi gosta.';
$string['function'] = 'Funkcija';
$string['functions'] = 'Funkcije';
$string['generalstructure'] = 'Opća struktura';
$string['information'] = 'Informacija';
$string['installexistingserviceshortnameerror'] = 'Web servis sa skraćenim nazivom "{$a}" već postoji. Nije moguće instalirati/ažurirati različite Web servise sa ovim skraćenim nazivom.';
$string['installserviceshortnameerror'] = 'Programska greška: skraćeni naziv servisa "{$a}" treba da sadrži samo brojeve, slova i _-..';
$string['invalidextparam'] = 'Neispravan parametar vanjskog API-ja: {$a}';
$string['invalidextresponse'] = 'Neispravan odgovor vanjskog API-ja: {$a}';
$string['invalidiptoken'] = 'Neispravan token - Vaša IP adresa nije podržana';
$string['invalidtimedtoken'] = 'Neispravan token - token je istekao';
$string['invalidtoken'] = 'Neispravan token - token nije pronađen';
$string['iprestriction'] = 'IP ograničenje';
$string['iprestriction_help'] = 'Korisnik će morati da pozove Web servis sa neke od navedenih IP adresa';
$string['key'] = 'Ključ';
$string['keyshelp'] = 'Ključevi se koriste za pristup Vašem Moodle korisničkom računu iz vanjskih aplikacija.';
$string['manageprotocols'] = 'Upravljanje protokolima';
$string['managetokens'] = 'Upravljanje tokenima';
$string['missingcaps'] = 'Nedostaju sposobnosti';
$string['missingcaps_help'] = 'Popis neophodnih sposobnosti za servis, koje izabrani korisnik nema. Sposobnosti koje nedostaju moraju biti dodane korisnikovoj ulozi kako bi on mogao da koristi taj servis.';
$string['missingpassword'] = 'Nedostaje lozinka';
$string['missingrequiredcapability'] = 'Mogućnost {$a} je neophodna.';
$string['missingusername'] = 'Nedostaje korisničko ime';
$string['missingversionfile'] = 'Programska greška: nedostaje datoteka version.php za komponentu {$a}';
$string['mobilewsdisabled'] = 'Onemogućeno';
$string['mobilewsenabled'] = 'Omogućeno';
$string['nocapabilitytouseparameter'] = 'Programska greška: nedostaje datoteka version.php za komponentu {$a}';
$string['nofunctions'] = 'Ovaj servis nema funkcije.';
$string['norequiredcapability'] = 'Nema potrebnih sposobnosti';
$string['notoken'] = 'Popis tokena je prazan.';
$string['onesystemcontrolling'] = 'Dozvoli vanjskom sistemu da kontroliše Moodle';
$string['onesystemcontrollingdescription'] = 'Sljedeći koraci vam pomažu da podesite Moodle web servis kao sistem koji kontroliše Moodle. Ovo uključuje podešavanje tokena (sigurnosnog ključa) kao metoda za provjeru identiteta.';
$string['operation'] = 'Operacija';
$string['optional'] = 'Opciono';
$string['passwordisexpired'] = 'Lozinka je istekla';
$string['phpparam'] = 'XML-RPC (PHP struktura)';
$string['phpresponse'] = 'XML-RPC (PHP struktura)';
$string['postrestparam'] = 'PHP kod za REST (POST zahtjev)';
$string['potusers'] = 'Nema autorizovanih korisnika';
$string['potusersmatching'] = 'Nijedan ovlašteni korisnik ne odgovara';
$string['print'] = 'Štampaj sve';
$string['protocol'] = 'Protokol';
$string['removefunction'] = 'Ukloni';
$string['removefunctionconfirm'] = 'Da li stvarno želite da uklonite funkciju "{$a->function}" iz servisa "{$a->service}"?';
$string['requireauthentication'] = 'Ovaj metod zahtjeva provjeru identiteta sa xxx ovlaštenjem.';
$string['required'] = 'Obavezno';
$string['requiredcapability'] = 'Potrebna sposobnost';
$string['requiredcapability_help'] = 'Ako je podešeno, servisu će moći da pristupe samo korisnici sa potrebnim sposobnostima.';
$string['requiredcaps'] = 'Potrebne sposobnosti';
$string['resettokenconfirm'] = 'Da li stvarno želite da resetujete ovaj ključ Web servisa za korisnika: <strong>{$a->user}</strong>, na servisu: <strong>{$a->service}</strong>?';
$string['resettokenconfirmsimple'] = 'Da li stvarno želite da resetujete ovaj ključ? Bilo koji sačuvani link koji sadrži stari ključ neće više raditi.';
$string['response'] = 'Odgovor';
$string['restcode'] = 'REST';
$string['restexception'] = 'REST';
$string['restoredaccountresetpassword'] = 'Prije dobijanja tokena za obnovljeni korisnički račun neophodno je resetiranje lozinke.';
$string['restparam'] = 'REST (POST parametri)';
$string['restrictedusers'] = 'Samo autorizovani korisnici';
$string['restrictedusers_help'] = 'Ovo podešavanje određuje da li će korisnici sa ovlaštenjem da kreiraju token Web servisa, moći da generiršu token za ovaj Web servis preko svojih stranica sa sigurnosnim ključem ili će to moći da urade samo ovlašteni, autorizovani korisnici.';
$string['securitykey'] = 'Sigurnosni ključ (token)';
$string['securitykeys'] = 'Sigurnosni ključevi';
$string['selectauthorisedusers'] = 'Odaberi autorizovane korisnike';
$string['selectedcapability'] = 'Odabrane sposobnosti';
$string['selectedcapabilitydoesntexit'] = 'Trenutno podešena potrebna sposobnost ({$a}) više ne postoji. Promijenite je i sačuvajte promjene.';
$string['selectservice'] = 'Izaberi servis';
$string['selectspecificuser'] = 'Odaberi određenog korisnika';
$string['selectspecificuserdescription'] = 'Dodaj korisnika Web servisa kao ovlaštenog korisnika';
$string['service'] = 'Servis';
$string['servicehelpexplanation'] = 'Servis predstavlja skup funckija. Servisu mogu pristupiti svi ili samo određeni korisnici.';
$string['servicename'] = 'Naziv servisa';
$string['servicenotavailable'] = 'Web servis nije dostupan (ne postoji ili je možda onemogućen)';
$string['servicesbuiltin'] = 'Ugrađeni servisi';
$string['servicescustom'] = 'Prilagođeni servisi';
$string['serviceusers'] = 'Autorizovani korisnici';
$string['serviceusersettings'] = 'Korisnička podešavanja';
$string['serviceusersmatching'] = 'Autorizovani korisnici se poklapaju';
$string['serviceuserssettings'] = 'Promjeni podešavanja za autorizovane korisnike';
$string['simpleauthlog'] = 'Prijava pomoću jednostavne provjere identiteta';
$string['step'] = 'Korak';
$string['supplyinfo'] = 'Više detalja';
$string['testauserwithtestclientdescription'] = 'Simulirajte vanjski pristup servisu koristeći probni klijent Web servisa. Prije toga, prijavite se kao korisnik koji ima sposobnost moodle/webservice:createtoken i preuzmite sigurnosni ključ na odgovarajućoj stranici u okviru \'Podešavanja mog profila\'. Ovaj token ćete koristiti u probnom klijentu. U klijentu, također, odaberite omogućeni protokol sa tokenom za provjeru ideniteta. <strong>UPOZORNJE: funkcije koje testirate BIĆE IZVRŠENE za ovog korisnika, pa budite pažljivi prilikom izbora onoga što želite da testirate!</strong>';
$string['testclient'] = 'Test klijent Web servisa';
$string['testclientdescription'] = '* Probni klijent Web servisa <strong>izvršava</strong> funkcije <strong>STVARNO</strong>. Nemojte da testirate funkcije koje ne poznajete. <br/> * Sve postojeće funkcije Web servisa nisu još implementirane u probnom klijentu. <br/> * Kako biste provjerili da korisnik ne može da pristupi nekim funkcijama možete da testirate funkcije koje niste odobrili.<br/> * Da biste vidjeli jasnije poruke o greškama podesite sistem za otklanjanje grešaka (debugging) na <strong>{$a->mode}</strong> u {$a->atag}<br/>* Pristupite {$a->amfatag}.';
$string['testwithtestclient'] = 'Testiraj servis';
$string['testwithtestclientdescription'] = 'Simulirajte vanjski pristup servisu koristeći probni klijent Web servisa. Upotrijebite omogućeni protokol sa tokenom za provjeru ideniteta. <strong>UPOZORENJE: funkcije koje testirate BIĆE IZVRŠENE, pa budite pažljivi prilikom izbora onoga što želite da testirate!</strong>';
$string['token'] = 'Token';
$string['tokenauthlog'] = 'Provjera identiteta putem tokena';
$string['tokencreatedbyadmin'] = 'Može biti resetovano od strane administratora (*)';
$string['tokencreator'] = 'Autor';
$string['unknownoptionkey'] = 'Nepoznat ključ opcije ({$a})';
$string['unnamedstringparam'] = 'Niz parametra je neimenovan.';
$string['updateusersettings'] = 'Ažuriraj';
$string['uploadfiles'] = 'Može da učita datoteke';
$string['uploadfiles_help'] = 'Ako je ovo podešavanje omogućeno, svaki korisnik može da učita datoteke sa svojim sigurnosnim ključem u svoj privatni prostor za datoteke ili prostor za radne verzije datoteka. Primjenjuju se korisničke kvote koje su postavljene.';
$string['userasclients'] = 'Korisnici kao klijenti sa tokenom';
$string['userasclientsdescription'] = 'Sljedeći koraci Vam pomažu da podesite Moodle Web servise za korisnike kao klijente. Ovi koraci također pomažu da podesite preporučene tokene (sigurnosne ključeve) za provjeru identiteta. U tom slučaju korisnik će generisati svoj token na stranici \'Sigurnosni ključevi\' u okviru \'Podešavanja mog profila\'.';
$string['usermissingcaps'] = 'Nedostaju sposobnosti: {$a}';
$string['usernameorid'] = 'Korisničko ime/korisnički ID';
$string['usernameorid_help'] = 'Upiši korisničko ime ili korisnički ID';
$string['usernameoridnousererror'] = 'Nije pronađen nijedan korisnik sa ovim korisničkim imenom/korisnički ID';
$string['usernameoridoccurenceerror'] = 'Pronađen više od jednog korisnika sa ovim korisničkim imenom. Molimo, unesite korisnički ID';
$string['usernotallowed'] = 'Korisniku nije dozvoljeno da koristi ovaj servis. Prvo morate da mu dozvolite korištenje na stranici za administraciju {$a}.';
$string['usersettingssaved'] = 'Korisnička podešavanja su sačuvana';
$string['validuntil'] = 'Važi do';
$string['validuntil_help'] = 'Ako je podešeno, servis će nakon ovog datuma biti deaktivisan za ovog korisnika.';
$string['webservice'] = 'Web servis';
$string['webservices'] = 'Web servisi';
$string['webservicesoverview'] = 'Pregled';
$string['webservicetokens'] = 'Tokeni za Web servise';
$string['wrongusernamepassword'] = 'Pogrešno korisničko ime ili lozinka';
$string['wsaccessuserdeleted'] = 'Odbijen je pristup web servisu za obrisano korisničko ime: {$a}';
$string['wsaccessuserexpired'] = 'Odbijen je pristup web servisu za korisničko ime: {$a} kojem je istekla lozinka';
$string['wsaccessusernologin'] = 'Odbijen je pristup web servisu za korisničko ime: {$a} kojem je kao metod provjere identiteta podešeno \'Bez prijave na sistem';
$string['wsaccessusersuspended'] = 'Odbijen je pristup web servisu za suspendovano korisničko ime: {$a}';
$string['wsaccessuserunconfirmed'] = 'Odbijen je pristup web servisu za nepotvrđeno korisničko ime: {$a}';
$string['wsclientdoc'] = 'Dokumentacija Moodle Web servis klijenta';
$string['wsdocapi'] = 'API Dokumentacija';
$string['wsdocumentation'] = 'Dokumentacija Web servisa';
$string['wsdocumentationdisable'] = 'Dokumentacija Web servisa je onemogućena';
$string['wsdocumentationintro'] = 'Za kreiranje klijenta preporučujemo Vam da pročitate {$a->doclink}';
$string['wsdocumentationlogin'] = 'ili unesite korisničko ime i lozinku Vašeg Web servisa:';
$string['wspassword'] = 'Lozinka za Web servis';
$string['wsusername'] = 'Korisničko ime za Web servis';
