<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   role
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Dodavanje nove uloge';
$string['addrole'] = 'Dodaj novu ulogu';
$string['advancedoverride'] = 'Napredna izmjena uloga';
$string['allow'] = 'Dozvoli';
$string['allowassign'] = 'Dozvoli dodjeljivanje uloga';
$string['allowed'] = 'Dozvoljeno';
$string['allowoverride'] = 'Dozvoli mjenjanje uloga';
$string['allowroletoassign'] = 'Dozvoli korisniku sa ulogom {$a->fromrole} da dodjeli ulogu {$a->targetrole}';
$string['allowroletooverride'] = 'Dozvoli korisniku sa ulogom {$a->fromrole} da izmjeni ulogu {$a->targetrole}';
$string['allowroletoswitch'] = 'Dozvoli korisniku sa ulogom {$a->fromrole} da mjenja uloge u ulogu {$a->targetrole}';
$string['allowswitch'] = 'Dozvoli mjenjanje uloga';
$string['allsiteusers'] = 'Svi korisnici na stranici';
$string['archetype'] = 'Arhetipska uloga';
$string['archetypecoursecreator'] = 'ARHETIP: Kreator kursa';
$string['archetypeeditingteacher'] = 'ARHETIP: Predavač (sa uređivačkim pravima)';
$string['archetypefrontpage'] = 'ARHETIP: Autorizovani korisnik na naslovnoj stranici';
$string['archetypeguest'] = 'ARHETIP: Gost';
$string['archetype_help'] = 'Arhetipska uloga određuje ovlaštenja koja uloga ima kada se resetuje na zadane vrijednosti. Ona, također, određuje eventualna nova ovlaštenja za ulogu prilikom nadogradnje stranice.';
$string['archetypemanager'] = 'ARHETIP: Menadžer';
$string['archetypestudent'] = 'ARHETIP: Student';
$string['archetypeteacher'] = 'ARHETIP: Nastavnik (bez uređivačkih prava)';
$string['archetypeuser'] = 'ARHETIP: Autorizovani korisnik';
$string['assignanotherrole'] = 'Dodjeli još jednu ulogu';
$string['assignedroles'] = 'Dodjeljene uloge';
$string['assignerror'] = 'Greška prilikom dodjeljivanja uloge {$a->role} korisniku {$a->user}.';
$string['assignglobalroles'] = 'Dodjeli globalne uloge';
$string['assignmentcontext'] = 'Kontekst dodjeljivanja uloga';
$string['assignmentoptions'] = 'Opcije dodjeljivanja uloga';
$string['assignrole'] = 'Dodjeli ulogu';
$string['assignrolenameincontext'] = 'Dodjeli ulogu \'{$a->role}\' u {$a->context}';
$string['assignroles'] = 'Dodjeli uloge';
$string['assignroles_help'] = 'Dodjeljivanjem neke uloge korisniku u konkretnom kontekstu odobravate mu ovlaštenja koja ta uloga podrazumjeva, i to za tekući kontekst i sve njemu podređene. Na primjer, ako dodjelite ulogu studenta korisniku u okviru nekog kursa, on će tu ulogu imati ne samo na nivou kursa, već i na nivou svih blokova i aktivnosti u okviru tog kursa.';
$string['assignrolesin'] = 'Dodjeli uloge u {$a}';
$string['assignrolesrelativetothisuser'] = 'Dodjeli uloge u odnosu na ovog korisnika';
$string['backtoallroles'] = 'Povratak na popis svih uloga';
$string['backup:anonymise'] = 'Sakrij korisničke podatke prilikom kreiranja rezervne kopije podataka';
$string['backup:backupactivity'] = 'Rezervna kopija aktivnosti';
$string['backup:backupcourse'] = 'Rezervna kopija kurseva';
$string['backup:backupsection'] = 'Rezervna kopija sekcija';
$string['backup:backuptargethub'] = 'Rezervna kopija za čvorište';
$string['backup:backuptargetimport'] = 'Rezervna kopija za unos';
$string['backup:configure'] = 'Uređivanje opcija rezervne kopije';
$string['backup:downloadfile'] = 'Preuzimanje datoteka iz područja rezervnih kopija';
$string['backup:userinfo'] = 'Kreiraj rezervnu kopiju korisničkih podataka';
$string['badges:awardbadge'] = 'Dodijeli bedž korisniku';
$string['badges:configurecriteria'] = 'Podesi/uredi kriterijume za dobijanje bedža';
$string['badges:configuredetails'] = 'Podesi/uredi informacije o bedžu';
$string['badges:configuremessages'] = 'Konfiguriši poruke bedževa';
$string['badges:createbadge'] = 'Kreiraj/kopiraj bedževe';
$string['badges:deletebadge'] = 'Obriši bedževe';
$string['badges:earnbadge'] = 'Zaradite bedž';
$string['badges:manageglobalsettings'] = 'Upravljanje globalnim podešavanjima za bedževe';
$string['badges:manageownbadges'] = 'Pregled i upravljanje svojim dobijenim bedževima';
$string['badges:viewawarded'] = 'Pregled korisnika koji su zaradili određeni bedž bez mogućnosti dodijele bedža';
$string['badges:viewbadges'] = 'Pregled dostupnih bedževa bez mogućnosti da se zarade';
$string['badges:viewotherbadges'] = 'Pregled javnih bedževa u profilima drugih korisnika';
$string['block:edit'] = 'Uredi podešavanja bloka';
$string['block:view'] = 'Pregled bloka';
$string['blog:associatecourse'] = 'Poveži unose u blog sa kursevima';
$string['blog:associatemodule'] = 'Poveži unose u blog sa aktivnostima';
$string['blog:create'] = 'Kreiranje novih blog unosa';
$string['blog:manageentries'] = 'Uređivanje i upravljanje unosima';
$string['blog:manageexternal'] = 'Uređivanje i upravljanje vanjskim blogovima';
$string['blog:manageofficialtags'] = 'Upravljanje zvaničnim oznakama';
$string['blog:managepersonaltags'] = 'Upravljanje ličnim oznakama';
$string['blog:search'] = 'Pretraži unose u blog';
$string['blog:view'] = 'Pogledaj unose bloga';
$string['blog:viewdrafts'] = 'Pogledaj nacrte blog članaka';
$string['calendar:manageentries'] = 'Upravljanje proizvoljnim unosima u kalendar';
$string['calendar:managegroupentries'] = 'Upravljanje stavkama vezanim za grupe';
$string['calendar:manageownentries'] = 'Upravljanje vlastitim unosima u kalendar';
$string['capabilities'] = 'Sposobnosti';
$string['capability'] = 'Sposobnost';
$string['category:create'] = 'Kreiranje kategorija';
$string['category:delete'] = 'Obriši kategorije';
$string['category:manage'] = 'Upravljanje kategorijama';
$string['category:update'] = 'Ažuriraj kategorije';
$string['category:viewhiddencategories'] = 'Vidi skrivene kategorije';
$string['category:visibility'] = 'Vidi skrivene kategorije';
$string['checkglobalpermissions'] = 'Provjeri globalna ovlaštenja';
$string['checkpermissions'] = 'Provjeri ovlaštenja';
$string['checkpermissionsin'] = 'Provjeri ovlaštenja u {$a}';
$string['checksystempermissionsfor'] = 'Provjeri globalna ovlaštenja za {$a->fullname}';
$string['checkuserspermissionshere'] = 'Proveri globalna ovlaštenja za {$a->fullname} koje ima u ovom {$a->contextlevel}';
$string['chooseroletoassign'] = 'Molimo da izaberete ulogu za dodjeljivanje';
$string['cohort:assign'] = 'Dodaj i ukloni članove kohorte';
$string['cohort:manage'] = 'Kreiraj, obriši i premjesti kohorte';
$string['cohort:view'] = 'Pogledaj kohorte na nivou stranice';
$string['comment:delete'] = 'Obriši komentare';
$string['comment:post'] = 'Objavi komentare';
$string['comment:view'] = 'Čitaj komentare';
$string['community:add'] = 'Koristi blok zajednice za pretraživanje čvorišta i pronalaženje kurseva';
$string['community:download'] = 'Preuzmi kurs iz bloka zajednice';
$string['confirmaddadmin'] = 'Da li stvarno želite da dodate korisnika <strong>{$a}</strong> kao novog administratora stranice?';
$string['confirmdeladmin'] = 'Da li stvarno želite da uklonite korisnika <strong>{$a}</strong> sa popisa administratora stranice?';
$string['confirmroleprevent'] = 'Da li stvarno želite da uklonite <strong>{$a->role}</strong> sa popisa dozvoljenih uloga za sposobnost {$a->cap} u kontekstu {$a->context}?';
$string['confirmroleunprohibit'] = 'Da li stvarno želite da uklonite <strong>{$a->role}</strong> sa popisa zabranjenih uloga za sposobnost {$a->cap} u kontekstu {$a->context}?';
$string['confirmunassign'] = 'Da li ste sigurni da želite da uklonite ovu ulogu ovom korisniku?';
$string['confirmunassignno'] = 'Poništi';
$string['confirmunassigntitle'] = 'Potvrdi promjenu uloge';
$string['confirmunassignyes'] = 'Ukloni';
$string['context'] = 'Kontekst';
$string['course:activityvisibility'] = 'Sakrij/prikaži aktivnosti';
$string['course:bulkmessaging'] = 'Pošalji poruku većem broju ljudi';
$string['course:changecategory'] = 'Promjeni kategoriju kursa';
$string['course:changefullname'] = 'Izmjeni pun naziv kursa';
$string['course:changeidnumber'] = 'Izmjeni ID broj kursa';
$string['course:changeshortname'] = 'Izmjeni kraći naziv kursa';
$string['course:changesummary'] = 'Promjeni sažetak kursa';
$string['course:create'] = 'Kreiraj kurseve';
$string['course:delete'] = 'Obriši kurseve';
$string['course:enrolconfig'] = 'Konfiguši instance upisa na kurseve';
$string['course:enrolreview'] = 'Pregled upisa na kurseve';
$string['course:ignorefilesizelimits'] = 'Koristi datoteke veće od bilo kog ograničenja za veličinu datoteke';
$string['course:isincompletionreports'] = 'Biće prikazano na završnim izvještajima';
$string['course:manageactivities'] = 'Upravljanje aktivnostima';
$string['course:managefiles'] = 'Upravljanje datotekama';
$string['course:managegrades'] = 'Upravljanje ocjenama';
$string['course:managegroups'] = 'Upravljanje grupama';
$string['course:managescales'] = 'Upravljanje skalama za ocjenjivanje';
$string['course:markcomplete'] = 'Označi kod korisnika da su završili kurs';
$string['course:movesections'] = 'Premještanje sekcije';
$string['course:publish'] = 'Objavi kurs na čvorište';
$string['course:request'] = 'Zahtjev za otvaranje novog kursa';
$string['course:reset'] = 'Ponovno postavljanje kursa';
$string['course:sectionvisibility'] = 'Kontrola vidljivosti sekcije';
$string['course:setcurrentsection'] = 'Postavi tekuću sekciju';
$string['course:update'] = 'Ažuriranje podešavanja kursa';
$string['course:useremail'] = 'Omogući/onemogući e-mail adresu';
$string['course:view'] = 'Pregled kurseva bez učesnika';
$string['course:viewcoursegrades'] = 'Pregled ocjena na kursevima';
$string['course:viewhiddenactivities'] = 'Pregled skrivenih aktivnosti';
$string['course:viewhiddencourses'] = 'Pregled skrivenih kurseva';
$string['course:viewhiddensections'] = 'Pogledaj skrivene sekcije';
$string['course:viewhiddenuserfields'] = 'Pregled skrivenih korisničkih polja';
$string['course:viewparticipants'] = 'Pregled učesnika';
$string['course:viewscales'] = 'Pregled skala za ocjenjivanje';
$string['course:visibility'] = 'Skrivanje/prikazivanje kurseva';
$string['createrolebycopying'] = 'Kreiranje novih uloga preuzimanje od  {$a}';
$string['createthisrole'] = 'Kreiranje ovih uloga';
$string['currentcontext'] = 'Trenutni kontekst';
$string['currentrole'] = 'Trenutna uloga';
$string['customroledescription'] = 'Prilagođeni opis';
$string['customroledescription_help'] = 'Opisi standardnih uloga su lokalizirani automatski ako je prilagođeni opis prazan.';
$string['customrolename'] = 'Prilagođeno puno ime';
$string['customrolename_help'] = 'Imena standardnih uloga su lokalizirana automatski ako je prilagođeno ime prazno. Morate osigurati puni naziv za sve prilagođene uloge.';
$string['defaultrole'] = 'Zadana uloga';
$string['defaultx'] = 'Zadano {$a}';
$string['defineroles'] = 'Definiši uloge';
$string['deletecourseoverrides'] = 'Obriši sve izmjene uloga na kursu';
$string['deletelocalroles'] = 'Obriši sve lokalno dodjeljene uloge';
$string['deleterolesure'] = '<p>Da li ste sigurni da želite da obrišete ulogu "{$a->name} ({$a->shortname})"?</p><p>Broj korisnika kojima je ova uloga trenutno dodjeljena je: {$a->count}.</p>';
$string['deletexrole'] = 'Obriši {$a} ulogu';
$string['duplicaterole'] = 'Kopiraj ulogu';
$string['duplicaterolesure'] = 'Da li ste sigurni da želite da kopirate ulogu "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Uređivanje uloge \'{$a}';
$string['editrole'] = 'Uredi ulogu';
$string['editxrole'] = 'Uredi {$a} ulogu';
$string['errorbadrolename'] = 'Pogrešan naziv uloge';
$string['errorbadroleshortname'] = 'Pogrešan skraćeni naziv uloge';
$string['errorexistsrolename'] = 'Naziv uloge već postoji';
$string['errorexistsroleshortname'] = 'Naziv uloge već postoji';
$string['eventroleallowassignupdated'] = 'Dozvoli dodeljivanje uloge';
$string['eventroleallowoverrideupdated'] = 'Dozvoli prepisivanje uloge';
$string['eventroleallowswitchupdated'] = 'Dozvoli menjanje uloge';
$string['eventroleassigned'] = 'Uloga je dodeljena';
$string['eventrolecapabilitiesupdated'] = 'Ažurirane su sposobnosti uloge';
$string['eventroledeleted'] = 'Uloga je obrisana';
$string['eventroleunassigned'] = 'Uloga je povučena';
$string['existingadmins'] = 'Trenutni adimistratori sajta';
$string['existingusers'] = '{$a} postojećih korisnika';
$string['explanation'] = 'Objašnjenje';
$string['export'] = 'Izvezi';
$string['extusers'] = 'Postojeći korisnici';
$string['extusersmatching'] = 'Postojeći korisnici koji odgovaraju \'{$a}';
$string['filter:manage'] = 'Upravljanje podešavanjima lokalnih filtera';
$string['frontpageuser'] = 'Autorizovani korisnik na naslovnoj stranici';
$string['frontpageuserdescription'] = 'Svi prijavljeni korisnici na naslovnoj stranici kursa';
$string['globalrole'] = 'Globalna uloga';
$string['globalroleswarning'] = 'UPOZORENjE! Svaka uloga koju dodjelite na ovoj stranici primjenjivaće se na korisnike kojima je dodjeljena na čitavoj stranici, uključujući i naslovnu stranicu i sve kurseve.';
$string['gotoassignroles'] = 'Idi na "Dodjeli uloge" za ovaj kontekst {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Idi na "Dodjeli globalne uloge"';
$string['grade:edit'] = 'Edituj ocjene';
$string['grade:export'] = 'Prenos ocjena';
$string['grade:hide'] = 'Sakrij/otkrij ocjene ili stavke';
$string['grade:import'] = 'Unos ocjena';
$string['grade:lock'] = 'Zaključaj ocjene ili stavke';
$string['grade:manage'] = 'Upravljanje stavkama za ocjenjivanje';
$string['grade:managegradingforms'] = 'Upravljanje naprednim metodama ocjenjivanja';
$string['grade:manageletters'] = 'Upravljanje slovnim ocjenama';
$string['grade:manageoutcomes'] = 'Upravljanje ishodima ocjena';
$string['grade:managesharedforms'] = 'Upravljanje šablonima obrazaca za napredno ocjenjivanje';
$string['grade:override'] = 'Izmjeni ocjene';
$string['grade:sharegradingforms'] = 'Djeljenje obrasca za napredno ocjenjivanje kao šablona';
$string['grade:unlock'] = 'Otključavanje ocjena ili stavki';
$string['grade:view'] = 'Pregled vlastitih ocjena';
$string['grade:viewall'] = 'Pregled ocjena drugih korisnika';
$string['grade:viewhidden'] = 'Pregled vlastitih sakrivenih ocjena';
$string['hidden'] = 'Sakriveno';
$string['highlightedcellsshowdefault'] = 'Ovlaštenja izabrana u donjoj tabeli su zadana ovlaštenja za arhetipsku ulogu izabranu gore.';
$string['highlightedcellsshowinherit'] = 'Označene ćelije u donjoj tabeli pokazuju dozvole koje će biti naslijeđene. Osim sposobnosti, čija ovlaštenja zapravo želite da promjenite, trebalo bi sve ostaviti podešeno na \'Naslijeđeno\'.';
$string['inactiveformorethan'] = 'neaktivan više od {$a->timeperiod}';
$string['ingroup'] = 'u grupi "{$a->group}"';
$string['inherit'] = 'Naslijeđivanje';
$string['legacy:admin'] = 'NASLIJEĐENA ULOGA: Administrator';
$string['legacy:coursecreator'] = 'NASLIJEĐENA ULOGA: Kreator kursa';
$string['legacy:editingteacher'] = 'NASLIJEĐENA ULOGA: Predavač (sa uređivačkim pravima)';
$string['legacy:guest'] = 'NASLIJEĐENA ULOGA: Gost';
$string['legacy:student'] = 'NASLIJEĐENA ULOGA: Student';
$string['legacy:teacher'] = 'NASLIJEĐENA ULOGA: Predavač (bez uređivačkih prava)';
$string['legacytype'] = 'Tip naslijeđene uloge';
$string['legacy:user'] = 'NASLIJEĐENA ULOGA: Identifikovan korisnik';
$string['listallroles'] = 'Popis svih uloga';
$string['localroles'] = 'Lokalno dodjeljene uloge';
$string['mainadmin'] = 'Glavni administrator';
$string['mainadminset'] = 'Postavi glavnog administratora';
$string['manageadmins'] = 'Upravljanje administratorima sajta';
$string['manager'] = 'Menadžer';
$string['managerdescription'] = 'Menadžeri mogu da pristupe kursevima i da ih mjenjaju. Oni obično ne učestvuju na kursevima.';
$string['manageroles'] = 'Upravljanje ulogama';
$string['maybeassignedin'] = 'Vrsta konteksta u kojem ova uloga može biti dodjeljena';
$string['morethan'] = 'Više od {$a}';
$string['multipleroles'] = 'Višestruke uloge';
$string['my:configsyspages'] = 'Konfiguriši globalne šablone za My Moodle stranice';
$string['my:manageblocks'] = 'Uredi blokove na stranici \'Moj Moodle';
$string['neededroles'] = 'Uloge sa ovlaštenjem';
$string['nocapabilitiesincontext'] = 'Nema sposobnosti raspoloživih u ovom kontekstu';
$string['noneinthisx'] = 'Ništa u ovoj {$a}';
$string['noneinthisxmatching'] = 'Nijedan korisnik ne odgovara \'{$a->search}\' u ovom {$a->contexttype}';
$string['noroleassignments'] = 'Ovaj korisnik nema dodjeljenu nijednu ulogu bilo gdje na ovoj stranici.';
$string['noroles'] = 'Nema uloga';
$string['notabletoassignroleshere'] = 'Niste u mogućnosti da ovdje dodjelite bilo koju ulogu';
$string['notabletooverrideroleshere'] = 'Niste u mogućnosti da ovde mjenjate ovlaštenja bilo koje uloge';
$string['notes:manage'] = 'Uređivanje bilješki';
$string['notes:view'] = 'Vidi bilješke';
$string['notset'] = 'Nije postavljeno';
$string['overrideanotherrole'] = 'Izmjeni drugu ulogu';
$string['overridecontext'] = 'Izmjeni kontekst';
$string['overridepermissions'] = 'Izmjeni ovlaštenja';
$string['overridepermissionsforrole'] = 'Izmjeni ovlaštenja uloge \'{$a->role}\' u {$a->context}';
$string['overridepermissions_help'] = 'Izmjena ovlaštenja omogućava da dozvolu odnosno zabranu odabranih sposobnosti u određenom kontekstu';
$string['overridepermissionsin'] = 'Izmjeni ovlaštenja u {$a}';
$string['overrideroles'] = 'Izmjeni uloge';
$string['overriderolesin'] = 'Izmjeni uloge u {$a}';
$string['overrides'] = 'Izmjene';
$string['overridesbycontext'] = 'Izmjene (prema kontekstu)';
$string['permission'] = 'Ovlaštenje';
$string['permission_help'] = 'Ovlaštenja predstavljaju podešavanja odgovarajućih sposobnosti. Postoje 4 opcije: * Nije postavljeno * Dozvoli - daje se dozvola za izvršavanje određene sposobnosti * Spriječi - Ovlaštenje se uklanja, čak i ako je dopušteno u širem kontekstu * Zabrani - ovlaštenje se u potpunosti ukida i ne može se promjeniti na bilo kojem užem (specifičnijem) kontekstu';
$string['permissions'] = 'Ovlaštenja';
$string['permissionsforuser'] = 'Ovlaštenja za korisnika {$a}';
$string['permissionsincontext'] = 'Dozvole u {$a}';
$string['portfolio:export'] = 'Prenesi u portfolio';
$string['potentialusers'] = '{$a} potencijalnih korisnika';
$string['potusers'] = 'Potencijalni korisnici';
$string['potusersmatching'] = 'Potencijalni korisnici koji odgovaraju \'{$a}';
$string['prevent'] = 'Spriječi';
$string['prohibit'] = 'Zabrani';
$string['prohibitedroles'] = 'Zabranjeno';
$string['question:add'] = 'Dodavanje novih pitanja';
$string['question:config'] = 'Kofigurisanje tipova pitanja';
$string['question:editall'] = 'Uredi sva pitanja';
$string['question:editmine'] = 'Uredi svoja pitanja';
$string['question:flag'] = 'Obilježi (zastavicom) pitanja u toku davanja odgovora na njih';
$string['question:managecategory'] = 'Uredi kategorije pitanja';
$string['question:moveall'] = 'Premjesti sva pitanja';
$string['question:movemine'] = 'Premjesti svoja pitanja';
$string['question:useall'] = 'Koristi sva pitanja';
$string['question:usemine'] = 'Koristi svoja pitanja';
$string['question:viewall'] = 'Pogledaj sva pitanja';
$string['question:viewmine'] = 'Pogledaj svoja pitanja';
$string['rating:rate'] = 'Dodaj ocjene stavkama';
$string['rating:view'] = 'Pogledaj ukupnu ocjenu koju si dobio/la';
$string['rating:viewall'] = 'Pogledaj sve neobrađene ocjene koje su dali pojedinci';
$string['rating:viewany'] = 'Pogledaj ukupne ocjene koje su svi dobili';
$string['resetrole'] = 'Vrati na zadanu vrijednosti';
$string['restore:configure'] = 'Konfiguriši opcije za restauraciju';
$string['restore:createuser'] = 'Kreiraj korisnike prilikom vraćanja';
$string['restore:restoreactivity'] = 'Vrati aktivnosti';
$string['restore:restorecourse'] = 'Vrati kurseve';
$string['restore:restoresection'] = 'Vrati sekcije';
$string['restore:restoretargethub'] = 'Vrati iz datoteka namenjenih čvorištu';
$string['restore:restoretargetimport'] = 'Vrati iz datoteka namjenjenih unosu';
$string['restore:rolldates'] = 'Dozvoljeno je promjeniti konfiguraciju datuma aktivnosti prilikom vraćanja';
$string['restore:uploadfile'] = 'Postavi datoteke u područje za rezervne kopije';
$string['restore:userinfo'] = 'Vrati korisničke podatke';
$string['restore:viewautomatedfilearea'] = 'Vrati kurseve iz automatski kreiranih rezervnih kopija';
$string['risks'] = 'Rizici';
$string['roleallowheader'] = 'Dozvoli ulogu:';
$string['roleallowinfo'] = 'Izaberite ulogu koja će biti dodata popisu dozvoljenih uloga u kontekstu {$a->context}, i sposobnosti {$a->cap}:';
$string['role:assign'] = 'Dodjeljivanje uloga korisnicima';
$string['roleassignments'] = 'Dodjeljivanje uloga';
$string['roledefinitions'] = 'Definicija uloga';
$string['rolefullname'] = 'Ime';
$string['roleincontext'] = '{$a->role} u {$a->context}';
$string['role:manage'] = 'Kreiranje i upravljanje ulogama';
$string['role:override'] = 'Izmjeni ovlaštenja za druge';
$string['roleprohibitheader'] = 'Zabranjena uloga';
$string['roleprohibitinfo'] = 'Izaberite ulogu koja će biti dodata popisu zabranjenih uloga u kontekstu {$a->context}, i sposobnosti {$a->cap}:';
$string['rolerepreset'] = 'Koristi predefinisanu ulogu';
$string['roleresetdefaults'] = 'Podrazumjevane vrijednosti';
$string['roleresetrole'] = 'Koristi ulogu ili arehetip';
$string['role:review'] = 'Pregledaj ovlaštenja drugih korisnika';
$string['rolerisks'] = 'Rizici uloge';
$string['roles'] = 'Uloge';
$string['role:safeoverride'] = 'Prepravi sigurnosne dozvole za ostale';
$string['roleselect'] = 'Odaberi ulogu';
$string['rolesforuser'] = 'Uloge za korisnika {$a}';
$string['roles_help'] = 'Uloga predstavlja skup ovlaštenja definisanih na nivou čitavog sistema koje možete da dodjelite određenim korisnicima u određenom kontekstu.';
$string['roleshortname'] = 'Skraćeni naziv';
$string['roleshortname_help'] = 'Skraćeno ime uloge je nizak nivo uloge identifikatora u kojem su samo ASCII alfanumerički znakovi dozvoljeni. Ne mijenjajte kratka imena standardnih uloga.';
$string['role:switchroles'] = 'Prebacivanje na druge uloge';
$string['roletoassign'] = 'Uloga koja se dodjeljuje';
$string['roletooverride'] = 'Uloga koja se mjenja';
$string['safeoverridenotice'] = 'Napomena: Mogućnosti sa više rizika su zaključane jer Vam je dopušteno da prepravljate jedino sigurnosne mogućnosti ovlaštenja.';
$string['selectanotheruser'] = 'Izaberi drugog korisnika';
$string['selectauser'] = 'Izaberi korisnika';
$string['selectrole'] = 'Izaberite ulogu';
$string['showallroles'] = 'Prikaz svih uloga';
$string['showthisuserspermissions'] = 'Prikaži ovlaštenja ovog korisnika';
$string['site:accessallgroups'] = 'Pristup svim grupama';
$string['siteadministrators'] = 'Administratori stranice';
$string['site:approvecourse'] = 'Odobravanje kreiranja kursa';
$string['site:backup'] = 'Kreiranje rezervnih kopija kurseva';
$string['site:config'] = 'Promjena konfiguracije stranice';
$string['site:doanything'] = 'Dozvoljeno da radi bilo šta';
$string['site:doclinks'] = 'Prikaz linkova ka dokumentima van stranice';
$string['site:import'] = 'Unos drugih kurseva u tekući kurs';
$string['site:manageblocks'] = 'Upravljaj blokovima na strani';
$string['site:mnetloginfromremote'] = 'Pristup sa udaljene Moodle lokacije';
$string['site:mnetlogintoremote'] = 'Prelaz na udaljenu Moodle lokaciju';
$string['site:readallmessages'] = 'Pročitaj sve poruke na stranici';
$string['site:restore'] = 'Vraćanje kurseva';
$string['site:sendmessage'] = 'Pošalji poruku bilo kojem korisniku';
$string['site:trustcontent'] = 'Povjerenje u sigurnost predatog sadržaja';
$string['site:uploadusers'] = 'Postavi nove korisnike iz datoteke';
$string['site:viewfullnames'] = 'Uvijek vidjeti puna imena korisnika';
$string['site:viewparticipants'] = 'Pregled učesnika';
$string['site:viewreports'] = 'Pregled izvještaja';
$string['site:viewuseridentity'] = 'Pogledaj pun identitet korisnika na popisu';
$string['tag:create'] = 'Kreiranje novih oznaka';
$string['tag:edit'] = 'Uređivanje postojećih oznaka';
$string['tag:editblocks'] = 'Uređivanje blokova na stranicama oznaka';
$string['tag:flag'] = 'Označi oznake kao neprimjerene.';
$string['tag:manage'] = 'Upravljanje svim oznakama';
$string['thisusersroles'] = 'Uloge dodjeljene ovom korisniku';
$string['unassignarole'] = 'Nedodjeljena uloga {$a}';
$string['unassignconfirm'] = 'Da li stvarno želite da uklonite ulogu "{$a->role}" korisniku "{$a->user}"?';
$string['unassignerror'] = 'Greška prilikom odzimanja uloge {$a->role} korisniku {$a->user}.';
$string['user:changeownpassword'] = 'Izmjeni vlastitu lozinku';
$string['user:create'] = 'Kreiraj korisnike';
$string['user:delete'] = 'Obriši korisnike';
$string['user:editmessageprofile'] = 'Uredi korisnički profil za slanje poruka';
$string['user:editownmessageprofile'] = 'Uredi vlastiti profil za slanje poruka';
$string['user:editownprofile'] = 'Uredi svoj korisnički profil';
$string['user:editprofile'] = 'Uređivanje korisničkog profila';
$string['user:ignoreuserquota'] = 'Zanemari korisničko ograničenje';
$string['user:loginas'] = 'Prijavite se kao drugi korisnik';
$string['user:manageblocks'] = 'Upravljanje blokovima na korisničkim profilima drugih korisnika';
$string['user:manageownblocks'] = 'Upravljanje blokovima na vlastitom javnom korisničkom profilu';
$string['user:manageownfiles'] = 'Upravljanje datotekama u vlastitom prostoru za privatne datoteke';
$string['user:managesyspages'] = 'Konfiguriši zadani izgled stranice za javne korisničke profile';
$string['user:readuserblogs'] = 'Vidi sve korisničke blogove';
$string['user:readuserposts'] = 'Vidi sve korisničke poruke';
$string['usersfrom'] = 'Korisnik iz {$a}';
$string['usersfrommatching'] = 'Korisnici iz {$a->contextname} koji odgovaraju \'{$a->search}';
$string['usersinthisx'] = 'Korisnici u ovom {$a}';
$string['usersinthisxmatching'] = 'Korisnici u ovom {$a->contexttype} koji odgovaraju \'{$a->search}';
$string['userswithrole'] = 'Svi korisnici sa ulogom';
$string['userswiththisrole'] = 'Korisnici sa ulogom';
$string['user:update'] = 'Ažuriranje korisničkih profila';
$string['user:viewalldetails'] = 'Pregled svih podataka o korisniku';
$string['user:viewdetails'] = 'Pregled korisničkih profila';
$string['user:viewhiddendetails'] = 'Pregled skrivenih detalja o korisnicima';
$string['user:viewuseractivitiesreport'] = 'Vidjeti izvještaje o aktivnostima korisnika';
$string['user:viewusergrades'] = 'Pregled korisničkih ocjena';
$string['useshowadvancedtochange'] = 'Upotrijebi \'Prikaži napredno\' za promjenu';
$string['viewingdefinitionofrolex'] = 'Pregled definicije uloge \'{$a}';
$string['viewrole'] = 'Pregled detalja o ulogama';
$string['webservice:createmobiletoken'] = 'Kreiraj token za pristup Web servisu putem mobilnih uređaja';
$string['webservice:createtoken'] = 'Kreiranje tokena za Web servis';
$string['whydoesuserhavecap'] = 'Zašto {$a->fullname} ima mogućnost {$a->capability} u kontekstu {$a->context}?';
$string['whydoesusernothavecap'] = 'Zašto {$a->fullname} nema mogućnost {$a->capability} u kontekstu {$a->context}?';
$string['xroleassignments'] = 'Dodjeljene uloge za {$a}';
$string['xuserswiththerole'] = 'Korisnici sa ulogom "{$a->role}"';
