<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktivnosti';
$string['addcategory'] = 'Dodaj kategoriju';
$string['addcategoryerror'] = 'Nije moguće dodati kategoriju';
$string['addexceptionerror'] = 'Došlo je do greške tokom dodavanja izuzetka za userid:gradeitem';
$string['addfeedback'] = 'Dodaj povratnu informaciju';
$string['addgradeletter'] = 'Dodaj slovnu ocjenu';
$string['addidnumbers'] = 'Dodaj ID brojeve';
$string['additem'] = 'Dodaj stavku za ocjenjivanje';
$string['addoutcome'] = 'Dodaj ishod';
$string['addoutcomeitem'] = 'Dodaj stavku ishoda';
$string['addscale'] = 'Dodaj skalu';
$string['aggregateextracreditmean'] = 'Srednja vrijednost ocjena (sa dodatnim objašnjenjima)';
$string['aggregatemax'] = 'Najveća ocjena';
$string['aggregatemean'] = 'Srednja vrijednost ocjena';
$string['aggregatemedian'] = 'Srednja vrijednost ocjena';
$string['aggregatemin'] = 'Najniža ocjena';
$string['aggregatemode'] = 'Oscilovanje ocjena';
$string['aggregateonlygraded'] = 'Sumirati samo date ocjene';
$string['aggregateonlygraded_help'] = '"Prazna" ocjena je ocjena koja nedostaje u knjizi ocjena. To može biti predati zadatak koji još nije ocijenjen ili kviz koji student još uvijek nije pokušao da riješi itd. Ovo podešavanje određuje da li će ove "prazne" ocjene biti uključene u zbirnu ocjenu ili će se računati kao minimalna ocjena, na primjer 0 za zadatak koji se ocjenjuje od 0 do 100.';
$string['aggregateoutcomes'] = 'Uključi ishode u sumirane podatke';
$string['aggregateoutcomes_help'] = 'Ako je omogućeno, ishodi učenja su uključeni u agregaciju. Ovo može da rezultira neočekivanom ukupnom ocjenom.';
$string['aggregatesonly'] = 'Samo sumirani podaci';
$string['aggregatesubcats'] = 'Sumirati podatke uključujući podkategorije';
$string['aggregatesubcats_help'] = 'Ovo podešavanje određuje da li su ocjene u podkategorijama uključene u agregaciju.';
$string['aggregatesum'] = 'Zbir ocjena';
$string['aggregateweightedmean'] = 'Ponderisana srednja vrijednost ocjena';
$string['aggregateweightedmean2'] = 'Prosta ponderisana srednja vrijednost ocjena';
$string['aggregation'] = 'Sumiranje podataka';
$string['aggregationcoef'] = 'Koeficijent sumiranja podataka';
$string['aggregationcoefextra'] = 'Dodatni bodovi';
$string['aggregationcoefextra_help'] = 'Ako je metod agregacije \'Zbir ocjena\' ili \'Jednostavna ponderisana srednja vrijednost\' i ako je označeno polje za dodatne bodove, maksimalna ocjena stavke se ne dodaje najvećoj ukupnoj ocjeni kategorije, što rezultira mogućnošću da maksimalna ocjena u kategoriji bude dostignuta (ili čak prekoračena, ako je tu opciju administrator sajta omogućio), a da pri tome nema nijedne maksimalne ocjene za bilo koju od stavki. Ako je metod agregacije ‘Srednja vrijednost ocjena’ (sa dodatnim bodovima) i ako je vrijednost za dodatne bodove veća od nule, onda dodatni bodovi postaju faktor kojim se ocjena množi prije njenog dodavanja ukupnoj ocjeni nakon izračunavanja srednje vrijednosti.';
$string['aggregationcoefextrasum'] = 'Dodatni bodovi';
$string['aggregationcoefextrasum_help'] = 'Ako je polje za dodatne bodove označeno, maksimalna ocjena za stavku se ne dodaje maksimalnoj ocjeni kategorije, što rezultira mogućnošću da maksimalna ocjena u kategoriji bude dostignuta (ili čak prekoračena, ako je tu opciju administrator sajta omogućio) a da pri tome nema nijedne maksimalne ocjene za bilo koju od stavki.';
$string['aggregationcoefextraweight'] = 'Ponder dodatnih bodova';
$string['aggregationcoefextraweight_help'] = 'Ako je ponder dodatnih bodova postavljen tako da bude veći od 0, onda se ocjena ponaša kao dodatni kredit u toku agreagacije. Broj je faktor kojim se ocjena množi prije nego što se doda ukupnoj vrijednosti za izračunavanje srednje vrijednosti.';
$string['aggregationcoefweight'] = 'Težina stavke';
$string['aggregationcoefweight_help'] = 'Ponder stavke se koristi u agregaciji kategorije kako bi odredio važnost stavke, u poređenju sa drugim stavkama iste kategorije.';
$string['aggregation_help'] = 'Agregacija određuje kako se kombinuju ocjene u pojedinoj kategoriji, a mogući načini su: * Srednja vrijednost ocjena - zbir svih ocjena podijeljen sa ukupnim brojem ocjena * Medijan ocjena - središnja ocjena u rasponu od najveće do najmanje ocjene * Najniža ocjena * Najviša ocjena * Mod ocjena - ocjena koja se najčešće pojavljuje * Zbir ocjena - zbir svih vrijednosti ocjena, nezavisno od skala ocjena';
$string['aggregationposition'] = 'Pozicija sumarnih podataka';
$string['aggregationposition_help'] = 'Ovo podešavanje određuje da li će kolone sa ocjenama za kategorije i kolona sa ukupnom ocjenom na kursu biti prikazane prve ili posljednje u izvještajima iz knjige ocjena.';
$string['aggregationsvisible'] = 'Dostupni tipovi sumiranja';
$string['aggregationsvisiblehelp'] = 'Odaberite sve tipove sumiranja koji bi trebalo da su dostupni. Držite CTRL tipku da odaberete više stavki.';
$string['allgrades'] = 'Sve ocjene po kategorijama';
$string['allstudents'] = 'Svi studenti';
$string['allusers'] = 'Svi korisnici';
$string['autosort'] = 'Automatsko sortiranje';
$string['availableidnumbers'] = 'Raspoloživi ID brojevi';
$string['average'] = 'Prosjek';
$string['averagesdecimalpoints'] = 'Decimale u koloni sa srednjim ocjenama';
$string['averagesdecimalpoints_help'] = 'Ovo podešavanje određuje broj decimalnih mjesta koja će biti prikazana za svaku srednju vrijednost ili, da li će se koristiti podešavanje decimalnih mjesta za kategoriju ili za ocjenu stavke (naslijeđeno).';
$string['averagesdisplaytype'] = 'Tip prikaza kolone sa srednjim ocjenama';
$string['averagesdisplaytype_help'] = 'Ovo podešavanje određuje da li se srednja ocjena prikazuje kao broj, procenat ili slovo, ili, da li će se koristiti tip prikaza za kategoriju ili za ocjenu stavke (naslijeđeno)';
$string['backupwithoutgradebook'] = 'Rezervna kopija ne sadrži podatke o konfiguraciji knjige ocjena';
$string['badgrade'] = 'Data ocjena je neispravna';
$string['badlyformattedscale'] = 'Molim Vas, unesite listu vrijednosti razdvojene zarezom (neophodne su najmanje dvije vrijednosti)';
$string['baduser'] = 'Dati korisnik je neispravan';
$string['bonuspoints'] = 'Dodatni bodovi';
$string['bulkcheckboxes'] = 'Opsežna polja za potvrdu';
$string['calculatedgrade'] = 'Izračunata ocjena';
$string['calculation'] = 'Proračun';
$string['calculationadd'] = 'Dodaj proračun';
$string['calculationedit'] = 'Uredi proračun';
$string['calculation_help'] = 'Izračunavanje ocjene predstavlja formulu koja se koristi kako bi se odredile ocjene. Formula treba da počinje znakom jednakosti (=), i može da koristi uobičajene matematičke operatore, kao što su max, min i sum. Ako želite, druge stavke za ocjenjivanje mogu biti uključene u izračunavanje tako što ćete upisati ID brojeva tih stavki unutar dvostrukih uglastih zagrada.';
$string['calculationsaved'] = 'Proračun sačuvan';
$string['calculationview'] = 'Pogledaj proračun';
$string['cannotaccessgroup'] = 'Oprostite, ali ne možete da pristupite ocjenama odabrane grupe.';
$string['categories'] = 'Kategorije';
$string['categoriesanditems'] = 'Kategorije i stavke';
$string['categoriesedit'] = 'Uredi kategorije i stavke';
$string['category'] = 'Kategorija';
$string['categoryedit'] = 'Uredi kategoriju';
$string['categoryname'] = 'Ime kategorije';
$string['categorytotal'] = 'Ukupno kategorija';
$string['categorytotalfull'] = '{$a->category} ukupno';
$string['categorytotalname'] = 'Naziv za ukupnu ocjenu svih kategorija tj. kursa';
$string['changedefaults'] = 'Promijeni zadano';
$string['changereportdefaults'] = 'Promijeni zadano podešavanja izvještaja';
$string['chooseaction'] = 'Izaberi akciju...';
$string['choosecategory'] = 'Izaberi kategoriju';
$string['combo'] = 'Tabovi i Padajući meni';
$string['compact'] = 'Kompaktno';
$string['componentcontrolsvisibility'] = 'Da li vidljivost ove stavke ocjene kontrolišu podešavanja aktivnosti.';
$string['contract'] = 'Skupi kategoriju';
$string['controls'] = 'Kontrole';
$string['courseavg'] = 'Prosjek na nivou kursa';
$string['coursegradecategory'] = 'Kategorije ocjene sa datog kursa';
$string['coursegradedisplaytype'] = 'Tip prikazivanja ocjena na kursu';
$string['coursegradedisplayupdated'] = 'Tip prikaza ocjena na kursu je ažuriran.';
$string['coursegradesettings'] = 'Podešavanje ocjena kursa';
$string['coursename'] = 'Naziv kursa';
$string['coursescales'] = 'Skale kursa';
$string['coursesettings'] = 'Postavke kursa';
$string['coursesettingsexplanation'] = 'Postavke kursa odeređuju kako će se dnevnik sa ocjenama prikazivati svim učesnicima kursa.';
$string['coursetotal'] = 'Ukupno za kurs';
$string['createcategory'] = 'Kreiraj kategoriju';
$string['createcategoryerror'] = 'Kreiranje nove kategorije nemoguće';
$string['creatinggradebooksettings'] = 'Kreiranje postavki knjige ocjena';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Trenutno nadređeno sumiranje';
$string['curveto'] = 'Prilagodi';
$string['decimalpoints'] = 'Decimale';
$string['decimalpoints_help'] = 'Ovo podešavanje određuje broj decimalnih mjesta koja će biti prikazana za svaku ocjenu. Ono ne utiče na izračunavanja ocjena, koja se vrše sa preciznošću od 5 decimalnih mjesta.';
$string['default'] = 'Zadano';
$string['defaultprev'] = 'Zadano ({$a})';
$string['deletecategory'] = 'Obriši kategoriju';
$string['disablegradehistory'] = 'Isključi historiju ocjena';
$string['disablegradehistory_help'] = 'Isključi praćenje historije promjena u tabelama koje se odnose na ocjenjivanje. Ovo može da malo ubrza server i sačuva prostor u bazi podataka.';
$string['displaylettergrade'] = 'Prikaži slovne ocjene (A, B, C...)';
$string['displaypercent'] = 'Prikaži procente';
$string['displaypoints'] = 'Prikaži bodove';
$string['displayweighted'] = 'Prikaži ponderisane ocjene';
$string['dropdown'] = 'Padajući meni';
$string['droplow'] = 'Odbaci najniže';
$string['droplowestvalue'] = 'Podesi najnižu vrijednost ocjene pri kojoj će se odbaciti';
$string['droplow_help'] = 'Ovo podešavanje omogućuje da određeni broj najnižih ocjena bude isključen iz agregacije';
$string['dropped'] = 'Odbačeno';
$string['dropxlowest'] = 'Odbaci X najnižih';
$string['dropxlowestwarning'] = 'Napomena: Ako odbacite X najnižih ocjena biće pretpostavljeno da sve stavke unutar kategorije imaju istu vrijednost u bodovima. Ukoliko različite stavke nose različit broj bodova rezultati će biti nepredvidljivi';
$string['duplicatescale'] = 'Duplirajte skalu';
$string['edit'] = 'Uredi';
$string['editcalculation'] = 'Uredi proračun';
$string['editcalculationverbose'] = 'Uredi proračun za {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Uredi povratnu informaciju';
$string['editgrade'] = 'Uredi ocjenu';
$string['editgradeletters'] = 'Uredi slovne ocjene';
$string['editoutcome'] = 'Uredi ishod';
$string['editoutcomes'] = 'Uredi ishode';
$string['editscale'] = 'Uredi skalu';
$string['edittree'] = 'Kategorije';
$string['editverbose'] = 'Uredi {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Omogući AJAX';
$string['enableajax_help'] = 'Dodaje AJAX funkcionalnosti izvještaju ocjenjivača, čime pojednostavljuje i ubrzava uobičajene operacije. Zavisi od toga da li je korisnik uključio Javascript na svom pretraživaču.';
$string['enableoutcomes'] = 'Omogući ishode';
$string['enableoutcomes_help'] = 'Podrška za ishode (tj. kompetencije, ciljeve, standarde, iliti kriterije) znači da se aktivnosti mogu ocjenjivati korištenjem jedne ili više skala koje su povezane sa iskazima ishoda. Korištenje ishoda tako omogućava specifično ocjenjivanje na nivou čitavog sajta.';
$string['encoding'] = 'Kodiranje';
$string['errorcalculationbroken'] = 'Vjerovatno kružna referenca ili neispravna proračunska formula';
$string['errorcalculationnoequal'] = 'Formula mora početi znakom jednakosti (=1+2)';
$string['errorcalculationunknown'] = 'Neispravna formula';
$string['errorgradevaluenonnumeric'] = 'Dobijena je nenumerička vrijednost za visoku ili nisku ocjenu za';
$string['errornocalculationallowed'] = 'Izračunavanja nisu dozvoljena za ovu stavku';
$string['errornocategorisedid'] = 'Nije moguće dobiti nekategorisan id broj!';
$string['errornocourse'] = 'Nije moguće dobiti informacije o kursu';
$string['errorreprintheadersnonnumeric'] = 'Dobijena je nenumerička vrijednost za ponovni ispis zaglavlja';
$string['errorsavegrade'] = 'Žao nam je, nije moguće sačuvati ocjenu.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Greška pri ažuriranju podešavanja "Sumiraj samo ocijenjene stavke" za kategoriju ocjena sa identifikatorom {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Greška pri ažuriranju podešavanja "Uključi ishode učenja u agregaciju" za kategoriju ocjena sa identifikatorom {$a->id}';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'Greška pri ažuriranju podešavanja "Sumiraj ocjene uključujući podkategorije" za kategoriju ocjena sa identifikatorom {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Greška pri ažuriranju tipa sumiranja za kategoriju ocjena sa ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Greška pri ažuriranju koeficijenta sumiranja (težinskog ili dodatnog kredita) za kategoriju ocjena sa ID {$a->id}';
$string['excluded'] = 'Isključeno';
$string['excluded_help'] = 'Ako je označeno, ocjena neće biti uključena u bilo koju agregaciju.';
$string['expand'] = 'Proširi kategoriju';
$string['export'] = 'Prenos';
$string['exportalloutcomes'] = 'Prenesi sve ishode';
$string['exportfeedback'] = 'Uključi povratnu informaciju u izvještaj';
$string['exportonlyactive'] = 'Zahtijevajte aktivni upis';
$string['exportonlyactive_help'] = 'Prilikom prenosa biće uključeni samo studenti čiji upisi na kurs nisu suspendovani';
$string['exportplugins'] = 'Prenesi dodatke';
$string['exportsettings'] = 'Prenesi podešavanja';
$string['exportto'] = 'Prenesi u';
$string['extracreditvalue'] = 'Dodatni bodovi za {$a}';
$string['extracreditwarning'] = 'Napomena: Podešavanje dodatnih bodova za sve stavke u kategoriji će ih ukloniti iz proračuna ocjene, te neće biti ukupnog broja bodova';
$string['feedback'] = 'Povratna informacija';
$string['feedbackadd'] = 'Dodaj povratnu informaciju';
$string['feedbackedit'] = 'Uredi povratnu informaciju';
$string['feedbackforgradeitems'] = 'Povratna informacija za {$a}';
$string['feedback_help'] = 'Ovo polje omogućava dodavanje bilo kakvog komentara o ocjeni.';
$string['feedbacks'] = 'Povratne informacije';
$string['feedbacksaved'] = 'Povratna informacija snimljena';
$string['feedbackview'] = 'Pogledaj povratnu informaciju';
$string['finalgrade'] = 'Konačna ocjena';
$string['finalgrade_help'] = 'Ako je polje za izmjenu označeno, ocjena može da bude dodana ili izmijenjena.';
$string['fixedstudents'] = 'Statična kolona sa studentima';
$string['fixedstudents_help'] = 'Omogućava da se ocjene skroluju horizontalno bez gubitka uvida u kolonu studenata (čini je statičnom)';
$string['forceoff'] = 'Forsiraj: Isključeno';
$string['forceon'] = 'Forsiraj: Uključeno';
$string['forelementtypes'] = 'za izabrani {$a}';
$string['forstudents'] = 'Za studente';
$string['full'] = 'Pun';
$string['fullmode'] = 'Kompletan prikaz';
$string['fullview'] = 'Puni prikaz';
$string['generalsettings'] = 'Opšta podešavanja';
$string['grade'] = 'Ocjena';
$string['gradeadministration'] = 'Administracija ocjena';
$string['gradeanalysis'] = 'Analiza ocjena';
$string['gradebook'] = 'Knjiga ocjena';
$string['gradebookhiddenerror'] = 'Knjiga ocjena je trenutno podešena tako da sve skriva od studenata';
$string['gradebookhistories'] = 'Historije ocjena';
$string['gradeboundary'] = 'Granice slovnih ocjena';
$string['gradeboundary_help'] = 'Ovo podešavanje određuje minimalni procenat iznad kojeg će biti dodijeljena slovna ocjena.';
$string['gradecategories'] = 'Kategorije ocjena';
$string['gradecategory'] = 'Kategorija ocjena';
$string['gradecategoryonmodform'] = 'Kategorija ocjena';
$string['gradecategoryonmodform_help'] = 'Ovo podešavanje kontroliše u koju kategoriju u knjizi ocjena će biti smještena ocjena za ovu aktivnost.';
$string['gradecategorysettings'] = 'Postavke kategorija ocjena';
$string['gradedisplay'] = 'Prikaz ocjena';
$string['gradedisplaytype'] = 'Tip prikaza ocjena';
$string['gradedisplaytype_help'] = 'Ovo podešavanje određuje način na koji će ocjene biti prikazane u izvještajima ocjenjivača i korisnika. * Broj - prave ocjene * Procenat * Slovo - slova ili riječi se koriste za prikaz raspona ocjena';
$string['gradedon'] = 'Ocijenjenih: $a';
$string['gradeexport'] = 'Prenos ocjena';
$string['gradeexportcustomprofilefields'] = 'Prenos ocjena prilagođenih profilnih polja';
$string['gradeexportcustomprofilefields_desc'] = 'Uključite ova prilagođena profilna polja u prenosu ocjena, odvojena zarezima.';
$string['gradeexportdecimalpoints'] = 'Decimale za prenos ocjena';
$string['gradeexportdecimalpoints_desc'] = 'Broj decimala koje treba prikazati za prenos. Ova vrijednost može biti prepisana tokom prenosa.';
$string['gradeexportdisplaytype'] = 'Tip prikaza za prenos ocjena';
$string['gradeexportdisplaytype_desc'] = 'Ocjene mogu biti prikazane kao cijeli brojevi, kao procenti (u odnosu na najmanje i najveće ocjene) ili kao slova (A, B, C itd.). Ovo može biti promijenjeno tokom eksportovanja.';
$string['gradeexportuserprofilefields'] = 'Prenos ocjena polja korisničkih profila';
$string['gradeexportuserprofilefields_desc'] = 'Uključite ova polja korisničkih profila u prenos ocjena, odvojena zarezima.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradehelp'] = 'Pomoć za ocjene';
$string['gradehistorylifetime'] = 'Trajanje historije ocjena';
$string['gradehistorylifetime_help'] = 'Ovo određuje koliko dugo želite da čuvate historiju promjena u tabelama koje se odnose na ocjenjivanje. Preporučeno je da historiju čuvate što je duže moguće. Ukoliko budete imali problema sa performansama sistema ili ako imate ograničen prostor za bazu podataka, pokušajte da postavite manju vrijednost.';
$string['gradeimport'] = 'Unos ocjena';
$string['gradeitem'] = 'Moguća ocjena';
$string['gradeitemaddusers'] = 'Isključi iz ocjenjivanja';
$string['gradeitemadvanced'] = 'Napredne opcije za stavke ocjenjivanja';
$string['gradeitemadvanced_help'] = 'Izaberi sve elemente koje treba prikazati kao napredne kada se uređuju stavke ocjenjivanja.';
$string['gradeitemislocked'] = 'Ova aktivnost je zaključana u knjizi ocjena. Promjene koje su načinjene u okviru ove aktivnosti neće biti kopirane u knjigu ocjena sve dok se ista ne otključa.';
$string['gradeitemlocked'] = 'Ocjenjivanje zaključano';
$string['gradeitemmembersselected'] = 'Isključeno iz ocjenjivanja';
$string['gradeitemnonmembers'] = 'Uključeno u ocjenjivanje';
$string['gradeitemremovemembers'] = 'Uključi u ocjenjivanje';
$string['gradeitems'] = 'Elementi ocjene';
$string['gradeitemsettings'] = 'Podešavanja stavki za ocjenjivanje';
$string['gradeitemsinc'] = 'Moguće ocjene koje treba uključiti';
$string['gradeletter'] = 'Slovna ocjena';
$string['gradeletter_help'] = 'Slovne ocjene su A, B, C... ili riječi, npr. odličan, dobar, dovoljan,... koje se koriste da predstave raspon ocjena.';
$string['gradeletternote'] = 'Da biste izbrisali slovnu ocjenu samo izbrišite bilo koje od <br /> tri tekstualna polja za dato slovo i pritisnite tipku za čuvanje podešavanja.';
$string['gradeletters'] = 'Slovne ocjene';
$string['gradelocked'] = 'Ocjena je zaključana za izmene';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Najveća ocjena';
$string['grademax_help'] = 'Ovo podešavanje određuje maksimalnu ocjenu kada se kao tip ocjenjivanja koristi vrijednost ocjene. Maksimalna ocjena za aktivnost se određuje na stranici za podešavanje te aktivnosti.';
$string['grademin'] = 'Najmanja ocjena';
$string['grademin_help'] = 'Ovo podešavanje određuje minimalnu ocjenu kada se kao tip ocjenjivanja koristi vrijednost ocjene.';
$string['gradeoutcomeitem'] = 'Ocijeni stavku ishoda';
$string['gradeoutcomes'] = 'Rezultati';
$string['gradeoutcomescourses'] = 'Rezultati kursa';
$string['gradepass'] = 'Ocjena za prolaz';
$string['gradepass_help'] = 'Ovo podešavanje određuje minimalnu ocjenu potrebnu za prolaz. Vrijednost se koristi za procjenu završenosti aktivnosti i kursa, kao i u knjizi ocjena gdje su prelazne ocjene označene zelenom, a neprelazne crvenom bojom.';
$string['gradepreferences'] = 'Svojstva ocjene';
$string['gradepreferenceshelp'] = 'Pomoć za svojstva ocjene';
$string['gradepublishing'] = 'Omogući objavljivanje';
$string['gradepublishing_help'] = 'Omogućite objavljivanje u prenosima i unosima podataka: Prenesenim ocjenama može se pristupiti preko URL-a, bez obavezne prijave na Moodle sajt. Ocjene se mogu unositi pristupom takvom URL-u (što znači da se na Moodle sajt mogu unositi ocjene objavljene na drugoj stranici). Podrazumijeva se da samo administratori mogu koristiti ovo svojstvo. Molimo vas da detaljno obavijestite korisnike prije nego što ovu mogućnost dozvolite i drugim ulogama tj. korisnicima - upozorite ih na opasnost dijeljenja obilježenih ("bookmarkovanih") stranica, korištenje programa za preuzimanje (Flash Get i sličnih) itd.';
$string['gradereport'] = 'Izvještaj sa ocjenama';
$string['graderreport'] = 'Izvještaj ocjenjivača';
$string['grades'] = 'Ocjene';
$string['gradesforuser'] = 'Ocjene za {$a->user}';
$string['gradesonly'] = 'Samo ocjene';
$string['gradessettings'] = 'Postavke ocjena';
$string['gradetype'] = 'Tip ocjene';
$string['gradetype_help'] = 'Postoje 4 tipa ocjena: * Ništa - ocjenjivanje nije moguće * Vrijednost - brojčana vrijednost sa maksimalnom i minimalnom vrijednošću * Skala - stavka na popisu* Tekst - samo povratne informacije Samo vrijednosti i skale mogu da se agregiraju. Tip ocjene za pojedinu aktivnost se određuje na stranici za podešavanja te aktivnosti.';
$string['gradeview'] = 'Pogledaj ocjenu';
$string['gradeweighthelp'] = 'Pomoć za težinsku vrijednost ocjena';
$string['groupavg'] = 'Prosjek grupe';
$string['hidden'] = 'Sakriveno';
$string['hiddenasdate'] = 'Prikaži datum za skrivene ocjene';
$string['hiddenasdate_help'] = 'Ukoliko korisnik ne može da vidi sakrivene ocjene prikaži datum umjesto \'-\'.';
$string['hidden_help'] = 'Ako je označeno, ocjene su sakrivene od studentata. Ako želite možete postaviti opciju \'sakriveno do dana\' kako bi se ocjene objavile nakon što je ocjenjivanje završeno.';
$string['hiddenuntil'] = 'Sakriven do';
$string['hiddenuntildate'] = 'Sakriven do: {$a}';
$string['hideadvanced'] = 'Sakrij napredne opcije';
$string['hideaverages'] = 'Sakrij prosjeke';
$string['hidecalculations'] = 'Sakrij proračune';
$string['hidecategory'] = 'Sakriveno';
$string['hideeyecons'] = 'Sakrij ikonice prikaži/sakrij';
$string['hidefeedback'] = 'Sakrij povratne informacije';
$string['hideforcedsettings'] = 'Sakrij prinudna podešavanja';
$string['hideforcedsettings_help'] = 'Ne prikazuj prinudna podešavanja u korisničkom interface-u sa ocjenama';
$string['hidegroups'] = 'Sakrij grupe';
$string['hidelocks'] = 'Sakrij zaključavanja';
$string['hidenooutcomes'] = 'Prikaži ishode';
$string['hidequickfeedback'] = 'Sakrij brzu povratnu informaciju';
$string['hideranges'] = 'Sakrij opsege';
$string['hidetotalifhiddenitems'] = 'Sakrij sume ako sadrže skrivene stavke';
$string['hidetotalifhiddenitems_help'] = 'Ovo podešavanje određuje da li se ukupne ocjene koje sadrže sakrivene stavke prikazuju studentima ili se zamjenjuju crticom (-). Ako se prikazuju, ukupna ocjena može biti izračunata ili bez ili sa sakrivenim stavkama. Ako su sakrivene stavke isključene, ukupna ocjena će biti različita od ukupne ocjene koju vidi predavač u izvještaju ocjenjivača, zato što predavač uvijek vidi ukupnu ocjenu za sve stavke, bez obzira jesu li one sakrivene ili ne. Ako su sakrivene stavke uključene u ukupnu ocjenu, studenti mogu da izračunaju ocjene za sakrivene stavke.';
$string['hidetotalshowexhiddenitems'] = 'Prikaži ukupne ocjene bez sakrivenih stavki';
$string['hidetotalshowinchiddenitems'] = 'Prikaži ukupne ocjene uključujući sakrivene stavke';
$string['hideverbose'] = 'Sakrij {$a->category}$a->itemmodule {$a->itemname}';
$string['highgradeascending'] = 'Sortiraj po visini ocjene, rastuće';
$string['highgradedescending'] = 'Sortiraj po visini ocjene, opadajuće';
$string['highgradeletter'] = 'Gornja granica';
$string['identifier'] = 'Identifikuj korisnika prema';
$string['idnumbers'] = 'ID brojevi';
$string['ignore'] = 'Ignoriraj';
$string['import'] = 'Unesi';
$string['importcsv'] = 'Unesi CSV';
$string['importcustom'] = 'Unesi kao korisnički definisane ishode (samo ovaj kurs)';
$string['importerror'] = 'Došlo je do greške, ova skripta nije pozvana sa pravim parametrima.';
$string['importfailed'] = 'Unos nije uspio';
$string['importfeedback'] = 'Unesi povratne informacije';
$string['importfile'] = 'Unesi datoteku';
$string['importfilemissing'] = 'Nijedna datoteka nije primljena, vratite se na formu i uvjerite se da ste proslijedili ispravnu datoteku.';
$string['importfrom'] = 'Unesi iz';
$string['importoutcomenofile'] = 'Postavljena datoteka je prazna ili oštećena. Molimo da utvrdite da je to ispravna datoteka. Problem je otkriven u redu {$a}; ovo je pokrenuto redovima sa podacima koji nisu imali kolona koliko u prvom (naslovnom) redu, ili ukoliko nedostaju naslovi kolona u unesenoj datoteci. Potražite u prenesenoj datoteci primjer ispravnih naslova.';
$string['importoutcomes'] = 'Unesi rezultate';
$string['importoutcomes_help'] = 'Rezultati učenja mogu biti uneseni iz CSV datoteke koja ima format kao i CSV datoteka za prenos rezultata učenja.';
$string['importoutcomesuccess'] = 'Unesen rezultat "{$a->name}" sa ID #{$a->id}';
$string['importplugins'] = 'Unesi dodatke';
$string['importpreview'] = 'Unesi prikaz';
$string['importsettings'] = 'Unesi podešavanja';
$string['importskippednomanagescale'] = 'Nemate privilegije za dodavanje nove skale za ocjenjivanje, tako da je rezultat "{$a}" izuzet jer je zahtijevao kreiranje nove skale';
$string['importskippedoutcome'] = 'Rezultat sa kraćim imenom "{$a}" već postoji u ovom kontekstu, onaj iz unesene datoteke je izuzet.';
$string['importstandard'] = 'Unesi kao standardne rezultate';
$string['importsuccess'] = 'Unos ocjena uspješan';
$string['importxml'] = 'Unesi XML';
$string['includescalesinaggregation'] = 'Uključi skale u sumarne podatke';
$string['includescalesinaggregation_help'] = 'Možete promijeniti da li se skale za ocjenjivanje uključuju kao brojevi u svim sumarnim podacima o ocjenama u svim dnevnicima i u svim kursevima. UPOZORENJE: Promjenom ovog podešavanja pokrenućete ponovno izračunavanje svih sumarnih polja';
$string['incorrectcourseid'] = 'ID broj kursa je netačan';
$string['incorrectcustomscale'] = '(Netačna korisnički definisana skala, molimo izmjenite.)';
$string['incorrectminmax'] = 'Minimalna vrijednost mora biti manja od maksimalne';
$string['inherit'] = 'Naslijeđeno';
$string['intersectioninfo'] = 'Student/Ocjena info';
$string['item'] = 'Stavka';
$string['iteminfo'] = 'Informacije o stavci';
$string['iteminfo_help'] = 'Ovo podešavanje obezbjeđuje prostor za unos informacija o stavci. Informacije se nigdje drugo ne prikazuju.';
$string['itemname'] = 'Ime stavke';
$string['itemnamehelp'] = 'Naziv ove stavke dobijen od modula.';
$string['items'] = 'Stavke';
$string['itemsedit'] = 'Izmjeni moguću ocjenu';
$string['keephigh'] = 'Zadrži najveću';
$string['keephigh_help'] = 'Ako je ova opcija podešena, čuvaće se samo X najviših ocjena, gde je X odabrana vrijednost za ovu opciju.';
$string['keymanager'] = 'Upravljanje ključevima';
$string['lessthanmin'] = 'Ocjena unesena za {$a->itemname} za korisnika {$a->username} je manja od minimalno dozvoljene';
$string['letter'] = 'Slovo';
$string['lettergrade'] = 'Slovna ocjena';
$string['lettergradenonnumber'] = 'Najniža i/ili najviša ocjena nisu bile numeričke za';
$string['letterpercentage'] = 'Slovo (procenat)';
$string['letterreal'] = 'Slovo (realna vrijednost)';
$string['letters'] = 'Slova';
$string['linkedactivity'] = 'Linkovana aktivnost';
$string['linkedactivity_help'] = 'Ovo podešavanje određuje aktivnost sa kojom je ovaj rezultat učenja povezan. Ovo se može koristiti za mjerenje postignuća studenata koja se ne procjenjuju pomoću ocjena aktivnosti.';
$string['linktoactivity'] = 'Link ka aktivnosti {$a->name}';
$string['lock'] = 'Zaključaj';
$string['locked'] = 'Zaključano';
$string['locked_help'] = 'Ako je označeno, ocjene su zaključane i više ne mogu biti automatski ažurirane od strane pripadajuće aktivnosti.';
$string['locktime'] = 'Zaključano nakon';
$string['locktimedate'] = 'Zaključaj nakon: {$a}';
$string['lockverbose'] = 'Zaključaj {$a->category}$a->itemmodule {$a->itemname}';
$string['lowest'] = 'Najniže';
$string['lowgradeletter'] = 'Donja granica';
$string['manualitem'] = 'Ručne stavke';
$string['mapfrom'] = 'Preslikaj iz';
$string['mappings'] = 'Preslikavanje mogućih ocjena';
$string['mapto'] = 'Preslikaj u';
$string['max'] = 'Najviše';
$string['maxgrade'] = 'Maksimalna ocjena';
$string['meanall'] = 'Sve ocjene';
$string['meangraded'] = 'Neprazne ocjene';
$string['meanselection'] = 'Ocjene odabrane za računanje prosjeka kolone';
$string['meanselection_help'] = 'Odaberite koji tip ocjena će biti uklljučen u kolonu sa prosjecima. Polja bez ocjena mogu biti ignorisana, ili računata kao 0 (podrazumijevano podešavanje)';
$string['median'] = 'Sredina';
$string['min'] = 'Najniže';
$string['missingscale'] = 'Skala za ocjenjivanje mora biti izabrana';
$string['mode'] = 'Mod';
$string['morethanmax'] = 'Ocjena unesena za {$a->itemname} za korisnika {$a->username} je veća od maksimalno dozvoljene';
$string['moveselectedto'] = 'Premjesti izabrane stavke u';
$string['movingelement'] = 'Pomjeranje {$a}';
$string['multfactor'] = 'Multiplikator';
$string['multfactor_help'] = 'Multiplikator je faktor kojim će sve ocjene za ovu stavku biti pomnožene, sa najvećom vrijednošću maksimalne ocjene. Na primjer, ako je multiplikator 2 a maksimalna ocjena 100, onda će sve ocjene manje od 50 biti pomnožene sa 2, a sve ocjene iznad 50 promijenjene u 100.';
$string['multfactorvalue'] = 'Multiplikatorna vrijednost za {$a}';
$string['mypreferences'] = 'Moje preference';
$string['myreportpreferences'] = 'Moj izvještaj - podešavanja';
$string['navmethod'] = 'Metod za navigaciju';
$string['neverdeletehistory'] = 'Nikad ne briši historiju';
$string['newcategory'] = 'Nova kategorija';
$string['newitem'] = 'Nova ocjena';
$string['newoutcomeitem'] = 'Novi rezultat';
$string['no'] = 'Ne';
$string['nocategories'] = 'Kategorije ocjena za ovaj kurs ne mogu biti dodane ili pronađene';
$string['nocategoryname'] = 'Nije dato ime kategorije';
$string['nocategoryview'] = 'Nema kategorije po kojoj bi se mogao izvršiti prikaz';
$string['nocourses'] = 'Još uvijek nema kurseva';
$string['noforce'] = 'Ne forsiraj podešavanja';
$string['nogradeletters'] = 'Nema podešenih slovnih ocjena';
$string['nogradesreturned'] = 'Nema dobijenih ocjena';
$string['noidnumber'] = 'Nema ID broja';
$string['nolettergrade'] = 'Nema slovne ocjene za';
$string['nomode'] = 'Nema';
$string['nonnumericweight'] = 'Dobijena je nenumerička vrijednost za';
$string['nonunlockableverbose'] = 'Ova ocjena ne može se otključati dok se ne otključa {$a->itemname}.';
$string['nonweightedpct'] = 'neponderisani %';
$string['nooutcome'] = 'Bez rezultata';
$string['nooutcomes'] = 'Stavke rezultata moraju biti povezane sa rezultatom kursa, ali nema rezultata za ovaj kurs. Da li biste željeli da dodate neki rezultat?';
$string['nopublish'] = 'Ne objavljivati';
$string['norolesdefined'] = 'Nisu definisane uloge u Administracija > Ocjene > Opšta podešavanja > Uloge koje se ocjenjuju';
$string['noscales'] = 'Rezultati moraju biti povezani sa skalom kursa ili globalnom skalom, ali nema nijedne. Želite li da dodate jednu?';
$string['noselectedcategories'] = 'nije izabrana nijedna kategorija.';
$string['noselecteditems'] = 'nije izabrana nijedna stavka.';
$string['notteachererror'] = 'Morate biti predavač da biste koristili ovu opciju.';
$string['nousersloaded'] = 'Nisu učitani korisnici';
$string['numberofgrades'] = 'Broj ocjena';
$string['onascaleof'] = 'na skali od {$a->grademin} do {$a->grademax}';
$string['operations'] = 'Operacije';
$string['options'] = 'Opcije';
$string['others'] = 'Drugo';
$string['outcome'] = 'Rezultat';
$string['outcomeassigntocourse'] = 'Dodijeli drugi rezultat ovom kursu';
$string['outcomecategory'] = 'Kreiraj rezultate u kategoriji';
$string['outcomecategorynew'] = 'Nova kategorija';
$string['outcomeconfirmdelete'] = 'Da li sigurno želite obrisati rezultat "{$a}"?';
$string['outcomecreate'] = 'Dodaj novi rezultat';
$string['outcomedelete'] = 'Izbriši rezultat';
$string['outcomefullname'] = 'Puno ime';
$string['outcome_help'] = 'Rezultat koji predstavlja ova stavka ocjenjivanja.';
$string['outcomeitem'] = 'Stavka rezultata';
$string['outcomeitemsedit'] = 'Dodaj stavku rezultata';
$string['outcomereport'] = 'Izvještaj rezultata';
$string['outcomes'] = 'Rezultati';
$string['outcomescourse'] = 'Rezultati korišteni u okviru kursa';
$string['outcomescoursecustom'] = 'Koriste se nestandardni rezultati (ne mogu se ukloniti)';
$string['outcomescoursenotused'] = 'Ne koriste se standardni rezultati';
$string['outcomescourseused'] = 'Koriste se standardni rezultati (ne mogu se ukloniti)';
$string['outcomescustom'] = 'Nestandardni rezultati';
$string['outcomeshortname'] = 'Kratki naziv';
$string['outcomesstandard'] = 'Standardni rezultati';
$string['outcomesstandardavailable'] = 'Raspoloživi standardni rezultati';
$string['outcomestandard'] = 'Standardni rezultat';
$string['outcomestandard_help'] = 'Standardni rezultat učenja je dostupan u svim kursevima na stranici.';
$string['overallaverage'] = 'Sveukupan prosjek';
$string['overridden'] = 'Odbačeno';
$string['overridden_help'] = 'Ako je označeno, ocjene ne mogu više da se mijenjaju unutar pripadajuće aktivnosti. Kada se ocjena mijenja unutar izvještaja ocjenjivača, polje za izmjenu ocjene je automatski označeno. Međutim, oznaka se može ukloniti kako bi se se dozvolilo da ocjena bude promijenjena preko pripadajuće aktivnosti.';
$string['overriddennotice'] = 'Vaša završna ocjena za ovu aktivnost je ručno podešena';
$string['overridesitedefaultgradedisplaytype'] = 'Poništi zadane vrijednosti na nivou stranice';
$string['overridesitedefaultgradedisplaytype_help'] = 'Ako je označeno, mogu se podešavati slovne ocjene i njihovi opsezi na nivou kursa, umjesto da se koriste zadana podešavanja na nivou stranice.';
$string['parentcategory'] = 'Nadređena kategorija';
$string['pctoftotalgrade'] = '% od ukupne ocjene';
$string['percent'] = 'Procenat';
$string['percentage'] = 'Procenat';
$string['percentageletter'] = 'Procenat (slovo)';
$string['percentagereal'] = 'Procenat (realna vrijednost)';
$string['percentascending'] = 'Sortiraj po procentima, rastuće';
$string['percentdescending'] = 'Sortiraj po procentima, opadajuće';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Pomak';
$string['plusfactor_help'] = 'Pomak je broj koji se dodaje svakoj ocjeni za ovu stavku, nakon primjene multiplikatora.';
$string['plusfactorvalue'] = 'Vrijednost pomaka za {$a}';
$string['points'] = 'bodova';
$string['pointsascending'] = 'Sortiraj po bodovima rastuće';
$string['pointsdescending'] = 'Sortiraj po bodovima opadajuće';
$string['positionfirst'] = 'Prvi';
$string['positionlast'] = 'Posljednji';
$string['preferences'] = 'Svojstva';
$string['prefgeneral'] = 'Opći';
$string['prefletters'] = 'Ocjene i ograničenja';
$string['prefrows'] = 'Specijalni redovi';
$string['prefshow'] = 'Sakrij/prikaži funkciju za promjenu stanja';
$string['previewrows'] = 'Pregled redova';
$string['profilereport'] = 'Izvještaj korisničkog profila';
$string['profilereport_help'] = 'Izvještaj o ocjenama koji se koristi na stranici sa profilom korisnika.';
$string['publishing'] = 'Objavljivanje';
$string['quickfeedback'] = 'Brza povratna informacija';
$string['quickgrading'] = 'Brzo ocjenjivanje';
$string['quickgrading_help'] = 'Ako je omogućeno, u situaciji kada je uključeno uređivanje, za svaku ocjenu se pojavljuje polje za unos teksta, što omogućava da istovremeno bude uređivano više ocjena. Kada se klikne na dugme za ažuriranje promjene su sačuvane i obilježene drugom bojom. Kada se ocjena uređuje u izvještaju ocjenjivača, vodite računa da se uključuje oznaka za izmjenu, što znači da ocjena više ne može da se mijenja unutar pripadajuće aktivnosti.';
$string['range'] = 'Opseg';
$string['rangedecimals'] = 'Opseg decimalnih mjesta';
$string['rangedecimals_help'] = 'Broj decimalnih mjesta za opseg koje treba prikazati.';
$string['rangesdecimalpoints'] = 'Decimale prikazane u opsezima';
$string['rangesdecimalpoints_help'] = 'Broj decimala za prikaz svakog tipa opsega, iznad kolone sa ocjenama. Ovo može biti promijenjeno za svaku stavku ocjenjivanja.';
$string['rangesdisplaytype'] = 'Tip prikaza sa opsezima';
$string['rangesdisplaytype_help'] = 'Ovo podešavanje određuje da li će opseg biti prikazan u formi realnih ocjena (brojeva) procenata odnosno slova, ili je vrsta prikaza za kategoriju odnosno stavku već određena (nasljeđena).';
$string['rank'] = 'Rang';
$string['rawpct'] = 'Neobrađeni %';
$string['real'] = 'Realni';
$string['realletter'] = 'Realna vrijednost (slovo)';
$string['realpercentage'] = 'Realna vrijednost (procenat)';
$string['recovergradesdefault'] = 'Povrati zadane ocjene';
$string['recovergradesdefault_help'] = 'Standardno, vraća stare ocjene kada ponovo upisujete korisnika na kurs.';
$string['regradeanyway'] = 'Ipak ponovo ocjenjivati';
$string['removeallcoursegrades'] = 'Obriši sve ocjene';
$string['removeallcourseitems'] = 'Obriši sve stavke i kategorije';
$string['report'] = 'Izvještaj';
$string['reportdefault'] = 'Zadani izvještaj ({$a})';
$string['reportplugins'] = 'Dodaci za izvještaj';
$string['reportsettings'] = 'Podešavanje izvještaja';
$string['reprintheaders'] = 'Ponovni ispis zaglavlja';
$string['respectingcurrentdata'] = 'ostavljajući trenutna podešavanja neizmijenjena';
$string['rowpreviewnum'] = 'Broj redova za pregled';
$string['savechanges'] = 'Sačuvaj promjene';
$string['savepreferences'] = 'Sačuvaj parametre';
$string['scaleconfirmdelete'] = 'Da li ste sigurni da želite da obrišete skalu "{$a}"?';
$string['scaledpct'] = 'Skalirani %';
$string['seeallcoursegrades'] = 'Pogledaj sve ocjene kursa';
$string['select'] = 'Izaberi {$a}';
$string['selectalloroneuser'] = 'Izaberi sve ili nijednog korisnika';
$string['selectauser'] = 'Izaberi korisnika';
$string['selectdestination'] = 'Izaberi odredište za {$a}';
$string['separator'] = 'Razdjelnik';
$string['sepcolon'] = 'Kolona';
$string['sepcomma'] = 'Zarez';
$string['sepsemicolon'] = 'tačka i zarez';
$string['septab'] = 'Tabulator';
$string['setcategories'] = 'Podesi kategorije';
$string['setcategorieserror'] = 'Prvo morate da podesite kategorije za Vaš kurs prije nego što im odredite težinske vrijednosti.';
$string['setgradeletters'] = 'Podesi slovne ocjene';
$string['setpreferences'] = 'Podesi parametre';
$string['setting'] = 'Postavke';
$string['settings'] = 'Postavke';
$string['setweights'] = 'Podesi težinske vrijednosti';
$string['showactivityicons'] = 'Prikaži ikone aktivnosti';
$string['showactivityicons_help'] = 'Prikaži ikonicu aktivnosti pored svake stavke za ocjenjivanje (u okviru ove aktivnosti) u izvještaju ocjenjivača.';
$string['showallhidden'] = 'Prikaži skrivene';
$string['showallstudents'] = 'Prikaži sve studente';
$string['showanalysisicon'] = 'Prikaži ikonicu za analizu ocjena';
$string['showanalysisicon_desc'] = 'Da li, standardno, prikazati ikonicu za analizu ocjena. Ako modul aktivnost to podržava, ikonica za analizu ocjena je povezana sa stranicom sa detaljnijim objašnjenjem ocjene i kako je ona dobijena.';
$string['showanalysisicon_help'] = 'Ako modul aktivnost to podržava, ikonica za analizu ocjena je povezana sa stranicom sa detaljnijim objašnjenjem ocjene i kako je ona dobijena.';
$string['showaverage'] = 'Prikaži prosjek';
$string['showaverage_help'] = 'Prikaži kolonu sa prosjecima? Studenti bi mogli da procijene ocjene drugih studenata ako se prosjek računa na osnovu manjeg broja ocjena. Prosjek je približan ukoliko zavisi od skrivenih stavki.';
$string['showaverages'] = 'Prikaži kolonu sa prosjecima';
$string['showaverages_help'] = 'Prikaži kolonu sa prosjecima u izvještaju ocjenjivača';
$string['showcalculations'] = 'Prikaži proračune';
$string['showcalculations_help'] = 'Da li prikazati ikonicu digitrona pored svake moguće ocjene i kategorije ocjenjivanja, kratak opis preko proračunatih ocjena i vizuelni indikator da je kolona proračunata.';
$string['showeyecons'] = 'Prikaži ikonice za prikaz/sakrivanje';
$string['showeyecons_help'] = 'Da li prikazati ikonicu prikaži/sakrij pored svake ocjene (čime se kontroliše da li će ih korisnik vidjeti).';
$string['showfeedback'] = 'Prikaži povratne informacije';
$string['showfeedback_help'] = 'Da li prikazati kolonu sa povratnim informacijama?';
$string['showgrade'] = 'Prikaži ocjene';
$string['showgrade_help'] = 'Da li prikazati kolonu sa ocjenama?';
$string['showgroups'] = 'Prikaži grupe';
$string['showhiddenitems'] = 'Prikaži sakrivene stavke';
$string['showhiddenitems_help'] = 'Da li su sakrivene stavke ocjena sakrivene u potpunosti ili su nazivi tih stavki vidljivi studentima? * Prikaži sakriveno - nazivi sakrivenih stavki su prikazani, ali ocjene studenata nisu * Sakriveno do - stavke su potpuno sakrivene do navedenog datuma nakon čega su u potpunosti vidljive. * Ne prikazuj - sakrivene stavke su u potpunosti sakrivene';
$string['showhiddenuntilonly'] = 'Prikaži samo skrivene do';
$string['showlettergrade'] = 'Prikaži slovne ocjene';
$string['showlettergrade_help'] = 'Da li prikazati kolonu sa slovnim ocjenama?';
$string['showlocks'] = 'Prikaži zaključavanja';
$string['showlocks_help'] = 'Da li prikazati ikonicu zaključaj/otključaj pored svake ocjene.';
$string['shownohidden'] = 'Ne prikazuj';
$string['shownooutcomes'] = 'Sakrij ishode';
$string['shownumberofgrades'] = 'Prikaži broj ocjena u prosjeku';
$string['shownumberofgrades_help'] = 'Prikazuje broj ocjena koje su sumirane pored svakog prosjeka, između zagrada. Primjer: 45 (34).';
$string['showonlyactiveenrol'] = 'Prikaži samo aktivne upise';
$string['showonlyactiveenrol_help'] = 'Ova postavka određuje da li će samo aktivno upisani korisnici biti vidljivi u izvještaju s ocjenama. Ako je uključeno suspendirani korisnici neće biti prikazani u izvještaju s ocjenama.';
$string['showpercentage'] = 'Prikaži postotak';
$string['showpercentage_help'] = 'Da li prikazati postotak vrijednost za svaku pojedinačnu stavku?';
$string['showquickfeedback'] = 'Prikaži brzu povratnu informaciju';
$string['showquickfeedback_help'] = 'Brza povratna informacija dodaje element za unos teksta u svaku ćeliju za ocjenu u izvještaj ocjenjivača, omogućavajući Vam da obavljate izmjene povratnih informacija za mnogo ocjena odjednom. Možete tada klinuti na dugme Ažuriraj da biste odradili ove promjene odjednom, umjesto jednu po jednu.';
$string['showrange'] = 'Prikaži opsege';
$string['showrange_help'] = 'Da li prikazati kolonu sa opsegom?';
$string['showranges'] = 'Prikaži opsege';
$string['showranges_help'] = 'Prikaži red sa opsegom mogućih ocjena za svaku od stavki u izvještaju ocjenjivača.';
$string['showrank'] = 'Prikaži rang';
$string['showrank_help'] = 'Da li prikazati poziciju studenta u odnosu na ostale učesnike za svaku pojedinačnu stavku?';
$string['showuserimage'] = 'Prikaži slike u korisničkim profilima';
$string['showuserimage_help'] = 'Da li prikazati sliku korisnika pored njegovog imena u izvještaju ocjenjivača';
$string['showverbose'] = 'Prikaži {$a->category}$a->itemmodule {$a->itemname}';
$string['showweight'] = 'Prikaži pondere';
$string['showweight_help'] = 'Da li prikazati kolonu sa ponderisanim ocjenama?';
$string['simpleview'] = 'Jednostavan prikaz';
$string['sitewide'] = 'Na cijeloj stranici';
$string['sort'] = 'sortiraj';
$string['sortasc'] = 'Sortiraj u rastući niz';
$string['sortbyfirstname'] = 'Sortiraj po imenu';
$string['sortbylastname'] = 'Sortiraj po prezimenu';
$string['sortdesc'] = 'Sortiraj u opadajućem nizu';
$string['standarddeviation'] = 'Standardno odstupanje';
$string['stats'] = 'Statistika';
$string['statslink'] = 'Statistika';
$string['student'] = 'Student';
$string['studentsperpage'] = 'Broj studenata po stranici';
$string['studentsperpage_help'] = 'Broj studenata prikazanih na svakoj stranici izvještaja ocjenjivača';
$string['studentsperpagereduced'] = 'Maksimalan broj studenata po stranici je smanjen sa {$a->originalstudentsperpage} na {$a->studentsperpage}. Razmislite o povećanju vrijednosti za PHP podešavanje max_input_vars from {$a->maxinputvars}.';
$string['subcategory'] = 'Normalna kategorija';
$string['submissions'] = 'Podnošenja';
$string['submittedon'] = 'Predano: {$a}';
$string['switchtofullview'] = 'Pređi na potpun prikaz';
$string['switchtosimpleview'] = 'Pređi na jednostavan prikaz';
$string['tabs'] = 'Tabovi';
$string['topcategory'] = 'Nadkategorija';
$string['total'] = 'Ukupno';
$string['totalweight100'] = 'Ukupna težinska vrijednost jednaka je 100';
$string['totalweightnot100'] = 'Ukupna težinska vrijednost nije jednaka 100';
$string['turnfeedbackoff'] = 'Isključi povratne informacije';
$string['turnfeedbackon'] = 'Uključi povratne informacije';
$string['typenone'] = 'Nijedan';
$string['typescale'] = 'Skala';
$string['typescale_help'] = 'Ovo podešavanje određuje skalu koja se koristi kada se ocjenjivanje vrši pomoću skala. Skala za ocjenjivanje aktivnosti se postavlja na stranici za podešavanje te aktivnosti.';
$string['typetext'] = 'Tekst';
$string['typevalue'] = 'Vrijednost';
$string['uncategorised'] = 'Nekategorisano';
$string['unchangedgrade'] = 'Ocjena je nepromijenjena';
$string['unenrolledusersinimport'] = 'Ovaj uvoz je uključio sljedeće ocjene za korisnike koji su trenutno upisani na ovom kursu: {$a}';
$string['unlimitedgrades'] = 'Neograničene ocjene';
$string['unlimitedgrades_help'] = 'Zadame ocjene su ograničene maksimalnom i minimalnom vrijednošću za jednu ocjenu. Uključivanjem ove opcije ukidaju se ove granice i omogućava se da ocjene od preko 100% budu direktno unesene u dnevnik. Preporučljivo je da se ovo podešavanje uključi u vrijeme smanjene aktivnosti, pošto će sve ocjene biti preračunate, što može izazvati velika opterećenja servera.';
$string['unlock'] = 'Otključaj';
$string['unlockverbose'] = 'Otključaj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Nekorišteno';
$string['updatedgradesonly'] = 'Prenesi samo nove ili ažurirane ocjene';
$string['uploadgrades'] = 'Pošalji ocjene';
$string['useadvanced'] = 'Koristi napredne opcije';
$string['usedcourses'] = 'Korišteni kursevi';
$string['usedgradeitem'] = 'Korištena stavka ocjenjivanja';
$string['usenooutcome'] = 'Bez ishoda';
$string['usenoscale'] = 'Bez skala';
$string['usepercent'] = 'Koristi postotke';
$string['user'] = 'Korisnik';
$string['userenrolmentsuspended'] = 'Upis korisnika je suspendovan';
$string['usergrade'] = 'Korisnik {$a->fullname} ({$a->useridnumber}) na stavci {$a->gradeidnumber}';
$string['userid'] = 'ID broj korisnika';
$string['userpreferences'] = 'Korisničke preferencije';
$string['useweighted'] = 'Koristi ponderisane vrijednosti';
$string['verbosescales'] = 'Detaljne skale';
$string['viewbygroup'] = 'Grupa';
$string['viewgrades'] = 'Pogledaj ocjene';
$string['warningexcludedsum'] = 'Upozorenje: isključivanje ocjena nije u skladu sa sumiranjem.';
$string['weight'] = 'težinska vrijednost';
$string['weightcourse'] = 'Koristi ponderisane ocjene za kurs';
$string['weightedascending'] = 'Sortiraj prema ponderisanom procentu - rastući niz';
$string['weighteddescending'] = 'Sortiraj prema ponderisanom procentu - opadajući niz';
$string['weightedpct'] = 'ponderisani %';
$string['weightedpctcontribution'] = 'doprinos ponderisanih % u ukupnoj ocjeni';
$string['weightorextracredit'] = 'Težinska vrijednost ili dodatni bod';
$string['weights'] = 'Težinske vrijednosti';
$string['weightsedit'] = 'Uredi težinske vrijednosti i dodatne bodove';
$string['weightuc'] = 'Težinska vrijednost';
$string['writinggradebookinfo'] = 'Zapisivanje podešavanja knjige ocjena';
$string['xml'] = 'XML';
$string['yes'] = 'Da';
$string['yourgrade'] = 'Vaša ocjena';
