<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   auth
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Dostupni dodaci za provjeru identiteta';
$string['alternatelogin'] = 'Ako ovdje unesete URL, biće korišten kao stranica za prijavu na ovaj sajt. Stranica bi trebala sadržavati formu sa akcijskom opcijom podešenom na <strong>\'{$a}\'</strong> i vraćanjem polja <strong>username</strong> i <strong>password</strong>.<br />Budite oprezni da ne biste unijeli pogrešan URL i time sami sebi onemogućili pristup sajtu.<br />Ostavite ovo podešavanje prazno da biste koristili zadanu stranicu za pristup sistemu.';
$string['alternateloginurl'] = 'Alternativna URL adresa za prijavu na sistem';
$string['auth_changepasswordhelp'] = 'Promjena pomoći za lozinku';
$string['auth_changepasswordhelp_expl'] = 'Prikaz pomoći za slučaj izgubljene lozinke korisnicima koji su izgubili svoju {$a} lozinku. To će biti prikazano ili isto kao ili umjesto <strong>URL-a za promjenu lozinke</strong> ili interne promjene Moodle lozinke.';
$string['auth_changepasswordurl'] = 'URL za promjenu lozinke';
$string['auth_changepasswordurl_expl'] = 'Specificirajte URL koji će se slati korisnicima koji izgube svoje {$a} lozinke. Podesite<strong>Koristiti standardnu stranicu za promjenu lozinke</strong> na <strong>Ne</strong>.';
$string['auth_changingemailaddress'] = 'Zatražili ste da staru e-mail adresu {$a->oldemail} promjenite u novu {$a->newemail}. Iz razloga bezbjednosti, šaljemo Vam e-mail poruku na novu adresu kako bi potvrdili da ona zaista pripada Vama. Vaša e-mail adresa biće ažurirana čim otvorite URL koji Vam je poslat u toj poruci.';
$string['auth_common_settings'] = 'Opća podešavanja';
$string['auth_data_mapping'] = 'Mapiranje podataka';
$string['authenticationoptions'] = 'Opcije za provjeru identiteta';
$string['auth_fieldlock'] = 'Zaključavanje vrijednosti';
$string['auth_fieldlock_expl'] = '<p><b>Zaključavanje vrijednosti:</b> Ako je omogućeno, spriječiće Moodle korisnike i administratore da direktno uređuju polje. Koristite ovu opciju ako održavate ove podatke u vanjskom autentifikacionom sistemu. </p>';
$string['auth_fieldlocks'] = 'Zaključavanje korisničkih polja';
$string['auth_fieldlocks_help'] = '<p>Možete zaključati polja sa korisničkim podacima. To je korisno za sajtove na kojima korisničke podatke ručno održavaju administratori uređivanjem korisničkih zapisa u bazi podataka ili postavljanjem podataka korištenjem opcije \'Postavljanje korisnika\'. Ako zaključavate polja koja su neophodna za rad Moodle sistema, provjerite da li ste, prilikom kreiranja korisničkih računa, popunili ta polja odgovarajućim podacima, jer se u suprotnom računi neće moći koristiti.</p><p>Podesite vrijednost za zaključavanje na \'Otključano ako je prazno\' da biste izbjegli navedeni problem.</p>';
$string['authinstructions'] = 'Ostavite ovo polje prazno ako želite da se korisnicima prikazuju zadane instrukcije za prijavu na sistem na naslovnoj strani. Ako želite da im ponudite neke posebne instrukcije unesite ih ovdje.';
$string['auth_invalidnewemailkey'] = 'Greška: ako pokušavate da potvrdite promjenu e-mail adrese, možda ste napravili grešku pri kopiranju URL adrese koju smo Vam poslali putem e-mail poruke. Molimo, kopirajte adresu i pokušajte ponovo.';
$string['auth_multiplehosts'] = 'Određivanje više domaćina ili adresa (npr. host1.com;host2.com;host3.com) ili (npr. xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_outofnewemailupdateattempts'] = 'Potrošili ste dozvoljeni broj pokušaja za promjenu e-mail adrese. Vaš zahtjev za promjenu je odbijen.';
$string['auth_passwordisexpired'] = 'Vaša lozinka je istekla. Da li želite da je promjenite sada?';
$string['auth_passwordwillexpire'] = 'Vaša lozinka ističe za {$a} dan/a. Da li želite da je promjenite sada?';
$string['auth_remove_delete'] = 'Potpuno brisanje internih podataka';
$string['auth_remove_keep'] = 'Zadržavanje internih podataka';
$string['auth_remove_suspend'] = 'Obustavljanje internih podataka';
$string['auth_remove_user'] = 'Odredite šta raditi sa unutrašnjim korisničkim računom za vrijeme masovne sinhronizacije kada je korisnik uklonjen od strane vanjskog izvora. Samo obustavljeni korisnici se automatski obnavljaju ako se ponovo pojavljuju u vanjskom izvoru.';
$string['auth_remove_user_key'] = 'Uklonjen vanjski korisnik';
$string['auth_sync_script'] = 'Skripta sinhronizacije krona';
$string['auth_updatelocal'] = 'Ažuriranje lokalnih podataka';
$string['auth_updatelocal_expl'] = '<p><b>Ažuriranje lokalnih podataka:</b> Ako je omogućeno, polje će biti ažurirano (koristi se eksterni auth) svaki put kada korisnik pristupi sistemu ili dođe do korisničke sinhronizacije. Polja za koja je podešeno lokalno ažuriranje bi trebala biti zaključana.</p>';
$string['auth_updateremote'] = 'Ažuriranje vanjskih podataka';
$string['auth_updateremote_expl'] = '<p><b>Ažuriranje vanjskih podataka:</b> Ako je omogućeno, vanjski auth će biti ažuriran pri ažuriranju zapisa o korisnicima. Polja bi trebala biti otključana da bi se dozvolile promjene.</p>';
$string['auth_updateremote_ldap'] = '<p><b>Napomene:</b> Ažuriranje vanjskih LDAP podataka zahtjeva da podesite povezivanje binddn i bindpw za bind-korisnika sa privilegijama korigovanja svih korisničkih zapisa. Ovo trenutno ne čuva više vrijednosne atribute i ukloniće dodatne vrijednosti nadogradnje.</p>';
$string['auth_user_create'] = 'Omogućiti kreiranje korisnika';
$string['auth_user_creation'] = 'Novi (anonimni) korisnici mogu napraviti korisničke račune na vanjskom izvoru za provjeru identiteta i izvršiti potvrdu putem e-mail adrese. Ako omogućite ovu opciju, konfigurišite i specifične opcije modula koje služe za kreiranje korisnika.';
$string['auth_usernameexists'] = 'Odabrano korisničko ime već postoji. Molimo izaberite drugo korisničko ime.';
$string['auto_add_remote_users'] = 'Automatsko dodavanje udaljenih korisnika';
$string['changepassword'] = 'URL za promjenu lozinke';
$string['changepasswordhelp'] = 'Ovdje možete navesti lokaciju na kojoj vaši korisnici mogu obnoviti ili promijeniti svoje korisničko ime/lozinku, u slučaju da su ih zaboravili. Ova opcija se može ponuditi korisnicima u vidu dugmeta na stranici za pristup sistemu, kao i na njihovoj korisničkoj stranici. Ako ostavite prazno polje, dugme neće biti prikazano.';
$string['chooseauthmethod'] = 'Izaberite način provjere identiteta';
$string['chooseauthmethod_help'] = 'Ovо podešavanje određuje način provjere identiteta koji se koristi kada se korisnik prijavljuje na sistem. Treba da odaberete samo dodatke za provjeru identiteta koji su uključeni, u suprotnom korisnici neće više moći da se prijave. Da biste blokirali buduće prijave nekog korisnika, odaberite \'Nema prijave\'.';
$string['createpasswordifneeded'] = 'Kreiranje lozinke ako je to potrebno';
$string['emailchangecancel'] = 'Poništi promjenu e-mail adrese';
$string['emailchangepending'] = 'Promjena na čekanju. Otvorite link koji Vam je poslan na {$a->preference_newemail}.';
$string['emailnowexists'] = 'E-mail adresa koju ste pokušali da dodijelite Vašem profilu je već dodijeljena drugom korisniku. Zato je Vaš zahtjev za promjenu e-mail adrese poništen, ali možete pokušati sa drugom adresom.';
$string['emailupdate'] = 'Ažuriranje e-mail adrese';
$string['emailupdatemessage'] = 'Dragi/a {$a->fullname}, Tražili ste promjenu svoje e-mail adrese za Vaš korisnički račun na {$a->site}. Molimo Vas da otvorite sljedeći URL u svom Web pretraživaču kako biste potvrdili ovu promjenu. {$a->url}';
$string['emailupdatesuccess'] = 'E-mail adresa korisnika <em>{$a->fullname}</em> je uspješno promijenjena u <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Potvrda ažuriranja e-mail adrese na {$a->site}';
$string['enterthenumbersyouhear'] = 'Unesite broj koji čujete';
$string['enterthewordsabove'] = 'Unesite riječ iznad';
$string['errormaxconsecutiveidentchars'] = 'Maksimalan broj istovjetnih karaktera zaredom koje mora sadržavati lozinka je: {$a}';
$string['errorminpassworddigits'] = 'Minimalan broj cifara koje lozinka mora sadržavati je: {$a}.';
$string['errorminpasswordlength'] = 'Minimalan broj karaktera koje lozinka mora sadržavati je: {$a}.';
$string['errorminpasswordlower'] = 'Minimalan broj malih slova koje lozinka mora sadržavati je: {$a}.';
$string['errorminpasswordnonalphanum'] = 'Minimalan broj karaktera koji nisu alfanumerički koje lozinka mora sadržavati je: {$a}.';
$string['errorminpasswordupper'] = 'Minimalan broj velikih slova koje lozinka mora sadržavati je: {$a}.';
$string['errorpasswordupdate'] = 'Greška u ažuriranju lozinke, lozinka nije promijenjena.';
$string['event_user_loggedin'] = 'Korisnik se prijavio';
$string['eventuserloggedinas'] = 'Korisnik je prijavljen kao drugi korisnik';
$string['forcechangepassword'] = 'Obavezna promjena lozinke';
$string['forcechangepasswordfirst_help'] = 'Obavezna promjena lozinke za sve korisnike pri njihovom prvom pristupu Moodle sistemu';
$string['forcechangepassword_help'] = 'Obavezna promjena lozinke za sve korisnike pri njihovom sljedećem pristupu Moodle sistemu';
$string['forgottenpassword'] = 'Ukoliko ovdje unesete URL adresu, ona će biti korištena za stranicu za obnavljanje zaboravljene lozinke, na ovom sajtu. Ovo je namjenjeno sajtovima na kojima se lozinkama, u potpunosti, upravlja izvan Moodlea. Ostavite ovo polje prazno da biste koristili uobičajeni način za obnavljanje lozinke.';
$string['forgottenpasswordurl'] = 'URL adresa za obnavljanje zaboravljene lozinke';
$string['getanaudiocaptcha'] = 'Dobijanje zvučnog CAPTCHA';
$string['getanimagecaptcha'] = 'Dobijanje CAPTCHA slike';
$string['getanothercaptcha'] = 'Dobijanje drugog CAPTCHA';
$string['guestloginbutton'] = 'Dugme za prijavu gostiju';
$string['incorrectpleasetryagain'] = 'Neispravno. Molimo pokušajte ponovo';
$string['infilefield'] = 'Polje zahtjevano u datoteci';
$string['informminpassworddigits'] = 'minimalan broj cifara: {$a}';
$string['informminpasswordlength'] = 'minimalan broj znakova: {$a}';
$string['informminpasswordlower'] = 'minimalan broj malih slova: {$a}';
$string['informminpasswordnonalphanum'] = 'minimalan broj nealfanumeričkih znakova: {$a}';
$string['informminpasswordupper'] = 'minimalan broj velikih slova: {$a}';
$string['informpasswordpolicy'] = 'Lozinka mora imati {$a}';
$string['instructions'] = 'Uputstva';
$string['internal'] = 'Interno';
$string['locked'] = 'Zaključano';
$string['md5'] = 'MD5 hash';
$string['nopasswordchange'] = 'Nije moguće promijeniti lozinku';
$string['nopasswordchangeforced'] = 'Niste u mogućnosti da nastavite dalje bez promjene korisničkog imena, međutim ne postoji raspoloživa stranica za promjenu. Molimo kontaktirajte Moodle administratora.';
$string['noprofileedit'] = 'Nije moguće uređivati profil';
$string['ntlmsso_attempting'] = 'Pokušava se SSO (Single Sign On) preko NTLM...';
$string['ntlmsso_failed'] = 'Automatsko prijavljivanje nije uspjelo, pokušajte sa običnom stranicom za prijavu...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO (jedinstvena prijava) nije uključenа.';
$string['passwordhandling'] = 'Upravljenje poljem lozinke';
$string['plaintext'] = 'Običan tekst';
$string['pluginnotenabled'] = 'Dodatak za provjeru identiteta \'{$a}\' nije osposobljen.';
$string['pluginnotinstalled'] = 'Dodatak za provjeru identiteta \'{$a}\' nije instaliran.';
$string['potentialidps'] = 'Prijavite se koristeći svoj račun na:';
$string['recaptcha'] = 'reCAPTCHA (ponovo)';
$string['recaptcha_help'] = 'CAPTCHA služi za spriječavanje zloupotrebe od strane automatiziranih programa. Samo unesite u okvir riječi koje vidite, redom kojim su napisane i odvojite ih razmakom. Ako niste sigurni koje su to riječi, možete da zatražite novi CAPTCHA ili da poslušate zvučni CAPTCHA.';
$string['selfregistration'] = 'Samoregistracija';
$string['selfregistration_help'] = 'Ako je odabran dodatak za provjeru identiteta, kao što je samostalna registracija pomoću e-mail adrese, onda će ovo omogućiti potencijalnim korisnicima da se sami registriraju i kreiraju korisničke račune. Ovo za posljedicu ima mogućnost da spameri kreiraju korisničke račune kako bi koristili forume, blog članke i slično za slanje neželjenih poruka. Kako biste izbjegli ovaj rizik, samostalna registracija treba da bude onemogućena ili ograničena pomoću podešavanja <em>Dozvoljeni domeni e-mail adrese</em>.';
$string['sha1'] = 'SHA-1 hash';
$string['showguestlogin'] = 'Možete sakriti ili prikazati dugme za prijavu gostiju na prijavnoj stranici.';
$string['stdchangepassword'] = 'Koristi standardnu stranicu za promjenu lozinke';
$string['stdchangepassword_expl'] = 'Ako eksterni sistem za provjeru identiteta dozvoljava promjenu lozinke iz Moodle sistema, uključite ga. Ovo podešavanje zaobilazi \'URL za promjenu lozinke\'.';
$string['stdchangepassword_explldap'] = 'Napomena: Preporučuje se da koristite LDAP prije nego SSL šifrovanje tunela (ldaps://) ako je LDAP server udaljen.';
$string['suspended'] = 'Suspendovani račun';
$string['suspended_help'] = 'Korisnici kojima je suspendovan račun ne mogu da se prijave na sistem ili da koriste web servise, niti im se šalju poruke sa sistema.';
$string['testsettings'] = 'Opcije teksta';
$string['testsettingsheading'] = 'Postavke provjere teksta - {$a}';
$string['unlocked'] = 'Otključano';
$string['unlockedifempty'] = 'Otključano ako je prazno';
$string['update_never'] = 'Nikad';
$string['update_oncreate'] = 'Pri kreiranju';
$string['update_onlogin'] = 'Pri svakom pristupu sistemu';
$string['update_onupdate'] = 'Pri ažuriranju';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ne podržava izabrani tip korisnika: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_activate() ne podržava izabrani tip korisnika (...još)';
