<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Pristup je odbijen';
$string['accounts'] = 'Računi';
$string['addcategory'] = 'Dodaj kategoriju';
$string['additionalhtml'] = 'Dodatni HTML';
$string['additionalhtml_desc'] = 'Ovo podešavanje vam dozvoljava da navedete HTML kôd koji želite da bude dodan na svaku stranicu. Možete postaviti HTML kôd koji će biti dodan unutar oznake HEAD za svaku stranicu, odmah nakon otvaranja ili neposredno prije zatvaranja oznake BODY.<br /> Na ovaj način možete imati prilagođeno zaglavlje ili podnožje za svaku stranicu ili možete dodati podršku za servise, poput Google Analytics, na jednostavan način, neovisno od teme koju ste odabrali.';
$string['additionalhtmlfooter'] = 'Prije nego što se zatvori BODY oznaka';
$string['additionalhtmlfooter_desc'] = 'Sadržaj koji ovdje upišete biće dodan na svaku stranicu neposredno prije nego što se zatvori body oznaka (</body>).';
$string['additionalhtmlhead'] = 'Unutar HEAD oznake';
$string['additionalhtmlhead_desc'] = 'Sadržaj koji ovdje upišete biće dodan na kraju HEAD oznake na svakoj stranici.';
$string['additionalhtml_heading'] = 'Dodatni HTML će biti dodan svakoj stranici';
$string['additionalhtmltopofbody'] = 'Kada se otvori BODY oznaka';
$string['additionalhtmltopofbody_desc'] = 'Sadržaj koji ovdje upišete biće dodan na svaku stranicu odmah nakon što se otvori body oznaka (<body>).';
$string['admincategory'] = 'Kategorija: {$a}';
$string['adminseesall'] = 'Administratori vide sve';
$string['adminseesallevents'] = 'Administratori vide sve događaje';
$string['adminseesownevents'] = 'Administratori su kao ostali korisnici';
$string['advancedfeatures'] = 'Napredna svojstva';
$string['allcountrycodes'] = 'Sve oznake zemalja';
$string['allowbeforeblock'] = 'Prvo će se obrađivati popis dopuštenih adresa';
$string['allowbeforeblockdesc'] = 'Zadano je da se popis blokiranih adresa prvo obrađuje, ako je ova opcija omogućena, popis dopuštenih IP adresa biće obrađen prije popisa blokiranih adresa';
$string['allowblockstodock'] = 'Dozvoliti fiksiranje blokova';
$string['allowcategorythemes'] = 'Dozvoli izbor grafičke teme na nivou kategorija';
$string['allowcoursethemes'] = 'Dozvoli izbor grafičke teme na nivou kurseva';
$string['allowediplist'] = 'Popis dopuštenih adresa';
$string['allowemailaddresses'] = 'Dozvoljene e-mail domene';
$string['allowframembedding'] = 'Dozvoli umetanje okvira';
$string['allowframembedding_help'] = 'Dozvoli umetanje ovog sajta u okvire vanjskih sajtova. Omogućavanje ove funkcije se ne preporučuje iz sigurnosnih razloga.';
$string['allowguestmymoodle'] = 'Dozvoli gostima pristup mojoj stranici';
$string['allowobjectembed'] = 'Dozvoli EMBED i OBJECT oznake';
$string['allowthemechangeonurl'] = 'Dozvoli promjenu grafičke teme u URL adresi';
$string['allowuserblockhiding'] = 'Dozvoli korisnicima da sakriju blokove';
$string['allowuserswitchrolestheycantassign'] = 'Dozvoli korisnicima koji nemaju mogućnost dodjeljivanja uloga da mijenjaju svoje uloge';
$string['allowuserthemes'] = 'Dozvoli korisnicima izbor grafičke teme';
$string['antivirus'] = 'Antivirus';
$string['appearance'] = 'Izgled';
$string['aspellpath'] = 'Putanja do alata aspell';
$string['authentication'] = 'Provjera identiteta';
$string['authpreventaccountcreation'] = 'Spriječi kreiranje računa prilikom provjere identiteta';
$string['authpreventaccountcreation_help'] = 'Prilikom provjere identiteta korisnika, na sajtu se automatski kreira račun, ukoliko on već ne postoji. Ako se za provjeru identiteta, koristi neka vanjska baza podataka, poput LDAP-a, a pri tome želite da dozvolite pristup sajtu samo korisnicima sa postojećim računom, onda treba uključiti ovu opciju. U tom slučaju, novi računi se kreiraju ručno ili putem opcije za postavljanje korisnika. Imajte u vidu da se ovo podešavanje ne primjenjuje na MNet provjeru identiteta.';
$string['authsettings'] = 'Upravljanje provjerom identiteta';
$string['autolang'] = 'Automatsko detektovanje jezika';
$string['autologinguests'] = 'Automatsko prijavljivanje gostiju';
$string['availablelicenses'] = 'Raspoložive licence';
$string['availableto'] = 'Dostupno';
$string['backgroundcolour'] = 'Transparentna boja';
$string['backups'] = 'Rezervne kopije';
$string['backup_shortname'] = 'Koristite naziv kursa u nazivu datoteke rezervne kopije';
$string['backup_shortnamehelp'] = 'Koristi ime kursa kao dio imena rezervne kopije.';
$string['badwordsconfig'] = 'Unesite svoj popis nepoželjnih riječi odvojenih zarezima.';
$string['badwordsdefault'] = 'Ukoliko je Vaš popis nepoželjnih riječi prazan, biće korišten zadani popis jezičkog paketa.';
$string['badwordslist'] = 'Popis definisanih nepoželjnih riječi';
$string['blockediplist'] = 'Popis blokiranih IP adresa';
$string['blockeditingmenu'] = 'Blokiraj menije za editovanje';
$string['blockeditingmenu_desc'] = 'Ako je uključeno, mnoge ikone za blokiranje editovanja će se prikazati u padajućem meniju. To smanjuje sadržaj na ekranu sakrivajući ikone dok ne budu potrebne.';
$string['blockinstances'] = 'Instance';
$string['blockmultiple'] = 'Višestruki';
$string['blockprotect'] = 'Zaštiti instance';
$string['blockprotect_help'] = 'Odabrane instance bloka će biti zaštićene od brisanja u kontekstu čitavog sajta. Ovo se prvenstveno koristi za zaštitu blokova za navigaciju i podešavanja koje je prilično teško ponovo prikazati ako se slučajno obrišu.';
$string['blocksettings'] = 'Upravljanje blokovima';
$string['blockunprotect'] = 'Ukloni zaštitu';
$string['bloglevel'] = 'Vidljivost bloga';
$string['bookmarkadded'] = 'Obilježivač je dodan.';
$string['bookmarkalreadyexists'] = 'Već ste obilježili ovu stranicu.';
$string['bookmarkdeleted'] = 'Obilježivač je obrisan.';
$string['bookmarkthispage'] = 'Obilježi ovu stranicu';
$string['cacheapplication'] = 'Cache aplikacije';
$string['cacheapplicationhelp'] = 'Ceche stavke su podijeljenje između svih korisnika i ističu zadanim ttl-om.';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'Cache Javascript i kompresija unapređuju učitavanje stranice. Preporučljivo je za zvanično aktivne Web lokacije. Programeri će vjerovatno željeti da onemoguće ovu osobinu.';
$string['cacherequest'] = 'Cache zahtjev';
$string['cacherequesthelp'] = 'Cache specifičan za korisnika koji ističe nakon sto je zahtjev završen. Dizajniran je da zamjeni područja za koje se koristi statična pohrana.';
$string['cachesession'] = 'Cache sesije';
$string['cachesessionhelp'] = 'Korisnički specifiran chache koji ističe nakon što korisnička sesija istekne. Dizajniran je da umanji \'bloat\' sesije.';
$string['cachesettings'] = 'Cache postavke';
$string['cachetext'] = 'Vrijeme trajanja tekst cache';
$string['caching'] = 'Caching';
$string['calendarexportsalt'] = 'Riječ za lozinku (salt) kod prijenosa kalendara';
$string['calendarsettings'] = 'Kalendar';
$string['calendar_weekend'] = 'Dani vikenda';
$string['cannotdeletemodfilter'] = 'Ne možete da reinstalirate filter \'{$a->filter}\' zato što je on dio modula \'{$a->module}';
$string['cannotuninstall'] = '{$a} ne može biti uklonjen.';
$string['cfgwwwrootslashwarning'] = 'Pogrešno ste definisali $CFG->wwwroot u vašoj config.php datoteci. Uključili ste karakter \'/\' na kraju. Uklonite ga, inače ćete dobijati čudne poruke o grešci poput sljedeće <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Pogrešno ste definisali $CFG->wwwroot u vašoj config.php datoteci. Adresa ne odgovara URL adresi koju koristite da biste pristupili ovoj stranici. Ispravite adresu, inače ćete dobijati čudne poruke o grešci poput sljedeće <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>';
$string['change'] = 'promjeni';
$string['checkboxno'] = 'Ne';
$string['checkboxyes'] = 'Da';
$string['choosefiletoedit'] = 'Odaberi datoteku za uređivanje';
$string['clamfailureonupload'] = 'Nakon neuspješnog izvršavanja clam antivirusnog alata';
$string['cleanup'] = 'Čišćenje';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'Greška, neispravna vrijednost "{$a->value}" za "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Neispravna vrijednost, molim pokušajte ponovo';
$string['clistatusdisabled'] = 'Status onemogućen';
$string['clistatusenabled'] = 'Status omogućen';
$string['clistatusenabledlater'] = 'satus: CLI mod održavanja će biti uključen na {$a}';
$string['clitypevalue'] = 'otkucaj vrijednost';
$string['clitypevaluedefault'] = 'otkucaj vrijednost, pritisni "Enter" da biste upotrebili zadanu vrijednost ({$a})';
$string['cliunknowoption'] = 'Neprepoznate opcije:
{$a}
Molimo iskoristite opciju za pomoć.';
$string['cliupgradefinished'] = 'Ažuriranje putem komandne linije je uspješno završeno.';
$string['cliupgradenoneed'] = 'Nije potrebna nadogradnja za instaliranu verziju {$}. U svakom slučaju hvala što ste došli !';
$string['cliyesnoprompt'] = 'otkucaj y (znači DA) ili n (znači NE)';
$string['commentsperpage'] = 'Broj komentara prikazanih po stranici';
$string['commonfiltersettings'] = 'Zajedničko podešavanje filtera';
$string['commonsettings'] = 'Opća podešavanja';
$string['componentinstalled'] = 'Komponenta je instalirana';
$string['computedfromlogs'] = 'Izračunato iz zapisa o aktivnostima od {$a}.';
$string['condifmodeditdefaults'] = 'Vrijednosti koje ovdje postavite biće zadana vrijednosti koje će se koristiti u podešavanjima aktivnosti prilikom kreiranja nove aktivnosti. Možete, također, da odredite koja će se podešavanja aktivnosti smatrati naprednim.';
$string['confeditorhidebuttons'] = 'Odaberite dugmad koja bi trebala biti skivena u HTML editoru.';
$string['configallcountrycodes'] = 'Ovo je spisak zemalja koje mogu biti odabrane na raznim mjestima, recimo u korisničkom profilu. Ako je spisak prazan (što je zadana vrijednost), koristiće se spisak iz countries.php koji je dio standardnog engleskog jezičkog paketa. Taj spisak je preuzet iz ISO 3166-1. U suprotnom potrebno je da navedete i dvoslovne oznake zemalja odvojene zarezima, npr. \'GB,FR,ES\'. Ako dodate nove, nestandardne oznake, morati ćete da ih dodate i u countries.php datoteku, kako engleskog, tako i Vašeg jezičkog paketа.';
$string['configallowassign'] = 'Možete dozvoliti ljudima koje imaju uloge navedene u prvoj koloni sa lijeve strane da drugim ljudima dodjeljuju neke od uloga u ostalim kolonama.';
$string['configallowblockstodock'] = 'Ako je ovo podešavanje omogućeno, a to izabrana tema podržava, korisnici mogu da odaberu da premještaju blokove u poseban dok (sa desne strane).';
$string['configallowcategorythemes'] = 'Ukoliko omogućite ovu opciju grafičke teme se mogu podešavati na nivou kategorija. To će uticati na sve podređene kategorije i kurseve koje već nemaju podešenu sopstvenu grafičku temu. UPOZORENjE: Omogućavanje izbora grafičke teme na nivou kategorija može uticati na performanse sistema.';
$string['configallowcoursethemes'] = 'Ukoliko omogućite ovu opciju, kursevima će biti dozvoljeno da podese vlastite grafičke teme. Grafičke teme na nivou kurseva imaju prednost u odnosu na sve ostale izbore tema (sajta, korisnika ili sesije).';
$string['configallowemailaddresses'] = 'Ukoliko želite da ograničite nove e-mail adrese na određene domene, navedite ih ovdje razdvojene razmacima. Svi ostali domeni biće odbijeni. Da biste dozvolili korištenje određenih poddomena dodajte odgovarajući domenu sa tačkom ispred. Na primjer: <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'Ako omogućeno, gostima će biti odobren pristup na \'Moju stranicu\', u suporotnom, gosti će biti preusmjereni na početnu stranicu.';
$string['configallowobjectembed'] = 'Kao zadana sigurnosna mjera, krajnjim korisnicima nije dozvoljeno umetanje multimedijalnih sadržaja (poput Flash animacija) unutar teksta eksplicitno korištenjem oznaka EMBED i OBJECT unutar HTML koda (iako je to i dalje moguće uraditi na sigurniji način putem mediaplugins filtera). Želite li ipak dozvoliti upotrebu ovih oznaka, uključite ovu opciju.';
$string['configallowoverride'] = 'Možete dozvoliti ljudima koje imaju uloge navedene u prvoj koloni sa lijeve strane da mjenjaju ovlaštenja uloga navedenih u preostalim kolonama.';
$string['configallowoverride2'] = 'Izaberite koje uloge se kojim ulogama iz lijeve kolone mogu promjeniti.<br /> Imajte na umu da ova podešavanja važe samo za one korisnike koji imaju dopuštene mogućnosti moodle/role:override ili moodle/role:safeoverride.';
$string['configallowswitch'] = 'Izaberite u koje uloge korisnik može preći, na osnovu onih uloga koje već posjeduje. Pored unosa u ovoj tabeli, korisnik također mora posjedovati ovlaštenje moodle/role:switchroles da bi mogao da promjeni ulogu.<br />Zapazite da je jedino moguće izmjeniti uloge koje imaju ovlaštenje moodle/course:view, a nemaju ovlaštenje moodle/site:doanything, pa su neke kolone ove tabele onemogućene.';
$string['configallowthemechangeonurl'] = 'Ako je ovo podešavanje omogućeno, grafička tema može da se promjeni dodavanjem <br />?theme=themename bilo kojoj Moodle URL adresi (npr: mymoodlesite.com/?theme=afterburner ) ili <br />&theme=themename bilo kojoj internoj Moodle URL adresi (npr: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Da li želite da korisnicima omogućite da sami skrivaju/prikazuju bočne blokove na ovom sajtu? Ovo svojstvo koristi Javascript i "kolačiće" kako bi se zapamtilo trenutno stanje blokova, i utiče jedino na izgled sajta pojedinačnog korisnika.';
$string['configallowuserswitchrolestheycantassign'] = 'Kao zadano podešavanje, zahtjeva se da korisnik ima ovlaštenje moodle/role:assign da bi mogao da promijeni uloge. Omogućavanjem ovog podešavanja ovdje, uklanja se ovaj zahtjev i za posljedicu ima da se pojavljuje padajući popis "Promijeni ulogu u", koji je određen samo podešavanjima u tabeli "Dozvoli dodjeljivanje uloga". Preporučuje se da podešavanja u tabeli "Dozvoli dodjeljivanje uloga" ne dozvoljavaju korisnicima da promijene ulogu u onu sa većim ovlaštenjima od postojeće.';
$string['configallowuserthemes'] = 'Ukoliko omogućite ovu opciju, korisnicima će biti dozvoljeno da sami podese grafičku temu po svojoj želji. Teme koje izaberu korisnici imaju prednost u odnosu na grafičku temu podešenu na nivou sajta (ali ne i u odnosu na grafičku temu podešenu na nivou kursa).';
$string['configallusersaresitestudents'] = 'Za aktivnosti na početnoj stranici sajta, da li se SVI korisnici smatraju studentima? Ukoliko je odgovor "Da", onda će svakom korisniku sa otvorenim računom biti dozvoljeno da kao student učestvuje u tim aktivnostima. Ukoliko je odgovor "Ne", onda će samo oni korisnici koji su upisani na najmanje jedan kurs moći da učestvuju u aktivnostima na početnoj strani. Samo administratori i posebno određeni predavači mogu da budu predavači za te aktivnosti.';
$string['configauthenticationplugins'] = 'Molimo odaberite dodatke za provjeru identiteta koje želite da koristite i poredajte ih u redosljedu smjenjivanja u slučaju neuspjeha. Samo registracijom će upravljati dodatak odabran u koloni \'Registracija\' (obično e-mail)';
$string['configautolang'] = 'Ukoliko zadani jezik na nivou sajt nije uključen, detektuj zadani jezik Web pretraživača.';
$string['configautologinguests'] = 'Da li bi posjetitelji sajta trebalo da budu automatski prijavljeni na sistem kao gosti kada ulaze na neki od kurseva koji dozvoljavaju pristup gostima?';
$string['configbloglevel'] = 'Ovo podešavanje vam dozvoljava da ograničite nivo do kojeg će biti vidljivi blogovi korisnika na ovom sajtu. Imajte u vidu da ovo određuje najširi kontekst ČITATELJA, a ne autora ili tip blog članka. Blogovi mogu biti i potpuno onemogućeni ako uopće ne želite da ih koristite.';
$string['configcachetext'] = 'Za obimnije sajtove, odnosno sajtove koje koriste tekstualne filtere ovo podešavanje može da ubrza rad. Kopije tekstova biće zadržane u svom obrađenom obliku u vremenskom intervalu koji ovdje odredite. Zadavanje premale vrijednosti bi moglo donekle usporiti rad, a zadavanje prevelike vrijednosti bi moglo rezultirati time da tekstovima treba previše vremena za osvježavanje (npr. s novim linkovima).';
$string['configcalendarcustomexport'] = 'Omogući prilagođeni vremenski okvir izvoza kalendara';
$string['configcalendarexportsalt'] = 'Nasumnični tekst se koristi za unaprijeđenje sigurnosti oznaka (tokena) autentičnosti koji se upotrebljavaju za prijenos kalendara. Vodite računa da su sve tekuće oznake (tokeni) neispravni ukoliko promijenite ovaj ovaj tekst ("hash salt")';
$string['configclamactlikevirus'] = 'Tretiraj datoteke kao viruse';
$string['configclamdonothing'] = 'Tretiraj datoteke normalno';
$string['configclamfailureonupload'] = 'Kako da se ponaša Clam AV, konfigurisan da skenira postavljene datoteke, kada zbog loše konfiguracije ili iz nekog nepoznatog razloga ne uspije da se pokrene? Ako izaberete opciju "Tretiraj datoteke kao viruse" datoteke će biti premiještene u "karantin" ili obrisane. Ukoliko izaberete opciju "Tretiraj datoteke normalno" datoteke će biti premeštene u odredišni direktorij na uobičajen način. U oba slučaja administrator će biti obaviješten da je Clam prijavio grešku prilikom starta. Ukoliko izaberete opciju "Tretiraj datoteke kao viruse", u slučaju da iz bilo kojeg razloga Clam ne bude pokrenut (obično zbog pogrešno podešene putanje do njega), SVE postavljene datoteke biće premještene u "karantin" ili obrisane. Budite oprezni sa ovim podešavanjem.';
$string['configconvertformat'] = 'Ako su <i>latex</i>, <i>dvips</i> i <i>convert</i> dostupni, slike se kreiraju korištenjem navedenog formata. Ako nisu, biće korišten mimeTeX i on će kreirati GIF slike.';
$string['configcookiehttponly'] = 'Omogućava novu karakteristiku PHP 5.2.0 - Web čitačima se zadaje da šalju kolačiće samo sa pravim http zahtjevima, kolačići ne bi trebalo da budu dostupni skript jezicima. Ovo ne podržavaju svi Web pretraživači i možda neće biti kompatibilno sa sadašnjim kodom. Pomaže da se spriječe neki tipovi XSS napada.';
$string['configcookiesecure'] = 'Ako server prihvata samo https konekcije, preporučljivo je omogućiti slanje sigurnih kolačića. Ako je podešavanje omogućeno, molimo, provjerite da web server ne prihvata http:// ili podesite stalno preusmjeravanje na https:// adresu. Kada <em>wwwroot</em> adresa ne počinje sa https:// ovo podešavanje se automatski isključuje.';
$string['configcountry'] = 'Ukoliko ovde podesite ime države, ono će biti izabrano kao zadano u novootvorenim korisničkim računima. Ostavite ovo polje prazno kako bi ste primorali korisnike da sami izaberu državu iz koje su.';
$string['configcourseoverviewfilesext'] = 'Spisak dozvoljenih, zarezima razdvojenih, ekstenzija datoteka rezimea kurseva.';
$string['configcourseoverviewfileslimit'] = 'Maksimalan broj datoteka koji se može priložiti uz rezime kursa.';
$string['configcourserequestnotify'] = 'Upišite korisničko ime korisnika koji će biti obaviješteni kada se pojavi zahtjev za pokretanje novog kursa.';
$string['configcourserequestnotify2'] = 'Korisnici koji će biti obaviješteni kada se pojavi zahtjev za pokretanje novog kursa. Ovde su navedeni samo korisnici koji mogu odobriti zahtjev za pokretanje kursa.';
$string['configcoursesperpage'] = 'Unesite broj kurseva koji će biti prikazan po stranici na popisu kurseva.';
$string['configcourseswithsummarieslimit'] = 'Najveći mogući broj kurseva koji je potrebno prikazati po stranici na popisu kurseva, prije prebacivanja na jednostavniji prikaz.';
$string['configcronclionly'] = 'Ukoliko je ovo uključeno, onda se kron skripta može pokrenuti samo iz komandne linije umjesto preko Weba. Ovo podešavanje ima prednost u odnosu na lozinku za kron.';
$string['configcronremotepassword'] = 'Ovo znači da se cron.php skripta ne može pokrenuti iz web pretraživača ako se ne obezbijedi lozinka, tako što će se upotrebiti sljedeći oblik URL adrese:<pre> http://site.example.com/admin/cron.php?password=opensesame</pre. Ukoliko se ovo ostavi prazno, lozinka nije potrebna.';
$string['configcurlcache'] = 'Vrijeme trajanja cURL cache, u sekundama';
$string['configcustommenuitems'] = 'Ovdje možete da konfigurišete vlastiti meni koji će se prikazivati u okviru grafičke teme. Svaki red se sastoji od teksta stavke u meniju, odgovarajuće URL adresu linka (opciono) i kratkog opisa stavke (opciono), koji su međusobno odvojeni vertikalnom crtom. Možete da odredite i strukturu menija koristeći crtice. Na primjer: <pre> Moodle zajednica|http://moodle.org -Moodle besplatna podrška|http://moodle.org/support -Moodle razvoj|http://moodle.org/development --Moodle bagovi|http://tracker.moodle.org --Moodle dokumenti|http://docs.moodle.org -Moodle vijesti|http://moodle.org/news Moodle kompanija -Moodle komercijalno hostovanje|http://moodle.com/hosting -Moodle komercijalna podrška|http://moodle.com/support </pre>';
$string['configdbsessions'] = 'Ako je omogućeno, ovo podešavanje će koristiti bazu podataka za pohranjivanje informacije o tekućim sesijama. Ovo je naročito korisno za velike/opterećene sajtove ili sajtove podignute na klasteru servera. Za većinu sajtova ovo podešavanje bi trebalo da bude onemogućeno tako da se umjesto baze podataka za informacije o sesijama koristi čvrsti disk servera. Imajte u vidu da će promjena ovog podešavanja prekinuti sesije svih trenutno aktivnih korisnika (uključujući i Vas). Ukoliko koristite MySQL provjerite da li je vrijednost za \'max_allowed_packet\' u my.cnf (ili my.ini) datoteci barem 4M.';
$string['configdebug'] = 'Ukoliko uključite ovu opciju onda će biti povećan broj izvještaja o greškama PHP-a (error_reporting). Ova opcija je korisna jedino onima koji razvijaju Moodle.';
$string['configdebugdisplay'] = 'Ako je ova opcija uključena, obaviještavanje o greškama će biti prosljeđeno na HTML stranicu. Ovo je praktično, ali generalno nije kompatibilno sa XHTML, JS, kolačićima i HTTP zaglavljem. Ako je isključeno, izlazne informacije biće prosljeđene u zapise vašeg servera, omogućavajući tako bolje uklanjanje grešaka. PHP podešavanje error_log kontroliše u koji zapis idu ove informacije.';
$string['configdebugpageinfo'] = 'Uključite ukoliko želite da se informacije o stranici prikazuju u njenom podnožju.';
$string['configdebugsmtp'] = 'Uključivanje detaljnih informacija o uklanjanju grešaka tokom slanja mailova SMTP serveru.';
$string['configdebugvalidators'] = 'Uključite ako u podnožju stranice želite imati linkove na vanjske servere za provjeru ispravnosti. Možda će biti potrebno da kreirate novog korisnika sa korisničkim imenom <em>w3cvalidator</em>, i omogućiti mu gostujući pristup. Ove izmjene mogu dozvoliti neovlašteni pristup serveru, ne uključujte na zvanično aktivnim Web lokacijama!';
$string['configdefaulthomepage'] = 'Ovo podešavanje određuje početnu stranicu za ulogovane korisnike';
$string['configdefaultrequestcategory'] = 'Kursevi koje zahtjevaju korisnici biće automatski smješteni u ovu kategoriju.';
$string['configdefaultrequestedcategory'] = 'Zadana kategorija za smještanje zahtjevanih kurseva, ukoliko su isti odobreni.';
$string['configdefaultuserroleid'] = 'Svim korisnicima, prijavljenim na sistem, biće date mogućnosti uloge koju ovdje navedete, na nivou sajta, kao DODATAK na eventualne druge uloge koje možda već imaju. Zadana je uloga autorizovanog korisnika. Imajte u vidu da ovo neće biti u suprotnosti sa drugim ulogama koje korisnici imaju, osim ako ne zabranite mogućnosti. Ovo samo osigurava da svi korisnici imaju sposobnosti koje nije moguće dodijeliti na nivou kursa (npr. pisanje blog članaka, uređivanje vlastitog kalendara itd.)';
$string['configdeleteincompleteusers'] = 'Po isteku ovog perioda, brišu se stari, nepotpuni nalozi.';
$string['configdeleteunconfirmed'] = 'Ukoliko koristite provjeru identiteta putem e-maila, ovo je vremenski rok unutar kojeg će biti prihvaćena potvrda od strane korisnika. Nakon tog perioda svi nepotvrđeni nalozi biće obrisani.';
$string['configdenyemailaddresses'] = 'Da biste onemogućili e-mail adrese sa određenih domena navedite ih ovdje na isti način. Svi drugi domeni biće prihvaćeni. Na primjer <strong>hotmail.com yahoo.co.uk neželjeni.domen.com</strong>';
$string['configdisableuserimages'] = 'Isključite mogućnost da korisnici mjenjaju slike u korisničkim profilima';
$string['configdisplayloginfailures'] = 'Prikaz izvještaja o prethodnim neuspješnim pristupima sistemu za izabrane korisnike.';
$string['configdndallowtextandlinks'] = 'Omogućite ili onemogućite postavljanje teksta i linkova, zajedno sa datotekama, pomoću opcije "prevuci i spusti". Imajte na umu da je prevlačenje teksta u Firefoxu ili između različitih web pretraživača nepouzdano i da kao posljedicu može imati da podaci ili tekst ne budu postavljeni.';
$string['configdocroot'] = 'Definiše putanju do Moodle dokumentacije. Možete je promjeniti ako želite da imate svoju prilagođenu online dokumentaciju. Međutim, ako to učinite, obezbijedite da putanje u Vašoj dokumenaciji budu u istom formatu kao što su na http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Ako ovo omogućite, linkovi do Moodle dokumentacije će biti prikazani u novom prozoru.';
$string['configeditordictionary'] = 'Ova vrijednost se koristi ako aspell nema rječnik za jezik korisnika.';
$string['configeditorfontlist'] = 'Izaberite fontove koji će se pojaviti u listi raspoloživih fontova pri korištenju editora.';
$string['configemailchangeconfirmation'] = 'Zatražiti korak potvrde putem e-maila kada korisnici izmjene svoju e-mail adresu u svom profilu.';
$string['configenableajax'] = 'Ovo podešavanje kontroliše korištenje AJAX-a na sajtu. AJAX je neophodan za određene funkcionalnosti kao što je opcija \'prevuci i spusti';
$string['configenableblogs'] = 'Ova opcija omogućava svim korisnicima stranice njihovu vlastitu blog stranicu.';
$string['configenablecalendarexport'] = 'Omogući prijenos ili prijavu na kalendare';
$string['configenablecomments'] = 'Omogući komentare';
$string['configenablecourserequests'] = 'Ovo će dozvoliti svakom korisniku da zahtjeva kreiranje kursa.';
$string['configenabledevicedetection'] = 'Omogućava detekciju mobilnih i pametnih telefona, tableta ili standardnih uređaja (stolni ili prenosivi računari, itd.) zbog primjene grafičkih tema i drugih funkcija.';
$string['configenablegroupmembersonly'] = 'Ako je ovo podešavanje omogućeno, pristup aktivnostima može biti ograničen samo na članove grupe. Ovo može da rezultira povećanim opterećenjem servera. Dodatno, kategorije u knjizi ocjena moraju biti podešene na odgovarajući način kako bi se osiguralo da te aktivnosti budu skrivene od onih koji nisu članovi grupe.';
$string['configenablemobilewebservice'] = 'Omogućite primjenu mobilnih servisa za zvaničnu Moodle aplikaciju ili druge aplikacije koji to zahtjevaju. Za više informacija pročitajte {$a}';
$string['configenablerssfeeds'] = 'Ako omogućena, omogućava RSS servis koji se generira iz različitih servisa na sajtu, kao što su blogovi, forumu i aktivnosti na bazi. RSS neophodno je, takođe, da njegovo korištenje omogućite u pojedinačnim modulima - idite na podešavanja modula u okviru administratorske konfiguracije.';
$string['configenablerssfeedsdisabled'] = 'RSS servis nije dostupan, zato što njegovo korištenje nije omogućeno na nivou cijelog sajta. Da bi ste omogućili korištenje RSS-a, idite na stranicu za podešavanja promjenljivih u okviru administratorske konfiguracije.';
$string['configenablerssfeedsdisabled2'] = 'Podrška za RSS izvor vijesti je isključena na nivou servera. Potrebno je da je prvo uključite na Administracija sajta/Server/RSS';
$string['configenablesafebrowserintegration'] = 'Ovo dodaje opciju "Zahtjev Safe Exam Browser" u polju "Sigurnost Web pretraživača" na obrascu za podešavanje kviza. Za više informacija pogledajte http://www.safeexambrowser.org/';
$string['configenablestats'] = 'Ako ovdje izaberete opciju "Da", cronjob vašeg Moodlea će obraditi zapise o aktivnostima i prikupiti neke statističke informacije. U zavisnosti od količine saobraćaja na Vašem sajtu to može prilično da potraje. Ako ovu opciju omogućite, moći ćete da vidite neke zanimljive grafikone i statističke izvještaje o svakom od vaših kurseva, ili pak na nivou cijelog sajta.';
$string['configenabletrusttext'] = 'Prema zadanim podešavanjima Moodle će uvijek temeljno prečistiti tekst koji dolazi od korisnika, kako bi uklonio eventualne zlonamjerne skriptove, multimedijalne i druge sadržaje koji bi mogli predstavljati sigurnosni rizik. Sistem "Pouzdanog sadržaja" (Trusted Content system) predstavlja način da pojedinim korisnicima, kojima vjerujete, dozvolite da dodaju i takve napredne sadržaje bez dodatne provjere. Da biste omogućili ovaj sistem prvo morate da uključite ovo podešavanje, a potom da odobrite dozvolu za "Pouzdani sadrža"j odgovarajućoj Moodle ulozi. Tekstovi koje kreiraju ili postavljaju takvi korisnici biće označeni kao pouzdani i neće biti podvrgnuti prečišćavanju prije prikaza.';
$string['configenablewebservices'] = 'Web servisi daju mogućnost drugim sistemima da se prijave na ovaj Moodle i izvode različite operacije. Zbog dodatne sigurnosti ovo svojstvo bi trebalo da bude isključeno, osim ako ne želite da ga stvarno koristite.';
$string['configenablewsdocumentation'] = 'Uključite automatsko generisanje dokumentacije o Web servisima. Korisnik može pristupiti vlastitoj dokumentaciji na svojoj stranici sigurnosnih ključeva {$a}. Stranica prikazuje dokumentaciju samo za dozvoljene protokole.';
$string['configerrorlevel'] = 'Odaberite nivo PHP upozorenja koja će Vam se prikazivati na ekranu. Postavka "Normal" je obično najbolji odabir.';
$string['configexportlookahead'] = 'Dana unaprijed za praćenje u toku izvoza';
$string['configexportlookback'] = 'Dana unazad za praćenje tokom izvoza';
$string['configextendedusernamechars'] = 'Uključite ovo podešavanje kako biste dozvolili studentima da upotrebljavaju sve znakove u svojim korisničikim imenima (napomena: ovo ne utiče na njihova prava imena). Zdana vrijednost je "netačno" što ograničava studente da koriste samo mala slova, brojeve, donju crtu (_), crticu (-), tačku (.) ili simbol "et" (@).';
$string['configextramemorylimit'] = 'Pojedini skriptovi kao što je pretraga, pravljenje rezervnih kopija ili kron zahtijevaju više memorije. Za velike sajtove postavite više vrijednosti.';
$string['configfilterall'] = 'Filtriranje svih stringova, uključujući naslove, nazive, navigacijske elemente i slično. Ovo je jedino korisno kod korištenja višejezičkog filtera, u suprotnom previše opterećuje server uz malu ili nikakvu korist.';
$string['configfiltermatchoneperpage'] = 'Filteri za automatsko linkovanje će generisati samo jedan link ka prvoj odgovarajućoj pojavi teksta pronađenoj na kompletnoj stranici. Sve ostale pojave se ignorišu.';
$string['configfiltermatchonepertext'] = 'Filteri za automatsko linkovanje će generisati samo jedan link ka prvoj odgovarajućoj pojavi teksta pronađenoj u svakoj od stavki teksta (npr. resursu, bloku) na stranici. Sve ostale pojave se ignorišu. Ovo podešavanje se ne uzima u obzir ako je podešavanje za jednu pojavu po stranici postavljeno na <i>da</i>.';
$string['configfilteruploadedfiles'] = 'Procesiranje svih postavljenih HTML i tekstualnih datoteka filterima prije njihovog prikazivanja, procesiranje samo postavljenih HTML datoteka ili bez procesiranja.';
$string['configforcelogin'] = 'Pod normalnim okolnostima, korisnici će moći da vide naslovnu stranu sajta i popis kurseva (ali ne i same kurseve) bez prethodnog prijavljivanja. Ukoliko želite da primorate ljude da se prijave prije nego što vide BILO ŠTA na sajtu, onda bi trebalo da omogućite ovo podešavanje.';
$string['configforceloginforprofiles'] = 'Ovo podešavanje primorava ljude da se na sistem prijave sa pravim računima (ne kao gosti) prije nego što budu u prilici da vide stranice sa korisničkim profilima. Ako ste onemogućili ovo podešavanje može se desiti da neki korisnici u svoje profile postavljaju reklame ili drugi neprikladan sadržaj, koji će onda biti vidljiv svima na Internetu.';
$string['configfrontpage'] = 'Gore izabrane stavke biće prikazane na naslovnoj stranici sajta.';
$string['configfrontpagecourselimit'] = 'Maksimalan broj kurseva';
$string['configfrontpagecourselimithelp'] = 'Maksimalan broj kurseva koji se prikazuje na naslovnoj stranici sajta u okviru spiska kurseva.';
$string['configfrontpageloggedin'] = 'Gore izabrane stavke biće prikazane na naslovnoj stranici sajta kada je korisnik prijavljen na sistem.';
$string['configfullnamedisplay'] = 'Ovo definiše način na koji će biti prikazano ime i prezime. Za većinu monojezičnih sajtova najefikasnije podešavanje je zadano "Ime + Prezime", ali možete da izaberete da potpuno sakrijete prezimena, ili da prepustite trenutnom jezičkom paketu da to sam izabere (neki jezici imaju različite konvencije).';
$string['configgeoipfile'] = 'Lokacija GeoIP City binarne datoteke. Ova datoteka nije dio Moodle distribucije i mora biti zasebno preuzeta sa <a href="http://www.maxmind.com/">MaxMinda</a>. Možete, ili da kupite komercijalnu verziju ili da koristite besplatnu verziju.<br />Preuzmite datoteku <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> i raspakujte je u "{$a}" direktoriju na svom serveru.';
$string['configgetremoteaddrconf'] = 'Ako je Vaš server iza povratnog (reverse) proxy, možete koristiti ovo podešavanje da podesite za koja HTTP zaglavlja se može vjerovati da sadrže udaljenu adresu. Zaglavlja se čitaju po redu, koristi se prvo dostupno.';
$string['configgradebookroles'] = 'Ova opcija Vam omogućava da kontrolišete ko se pojavljuje u evidenciji ocjena. Korisnici treba da imaju najmanje jednu od ovih uloga u kursu da bi bili prikazani u evidenciji ocjena tog kursa.';
$string['configgradeexport'] = 'Odaberite koji formati za prijenos knjige ocjena su Vaši primarni metodi za prijenos ocjena. Izabrani dodaci će onda postaviti i koristiti polje "last exported" za svaku ocjenu. Na primjer, ovo može kao rezultat dati prenesene ocjene označene kao "nove" ili "ažurirane". Ako niste sigurni šta želite da postignete ovim podešavanjima, slobodno ostavite sve opcije nepotvrđene.';
$string['confighiddenuserfields'] = 'Izaberite koja polja sa korisničkim informacijama želite da sakrijete od drugih korisnika koji nisu predavači na kursu ili administratori. Ovo će povećati privatnost korisnika. Držite CTRL tipku da biste izabrali više polja.';
$string['configidnumber'] = 'Ova postavka određuje (a) hoće li korisnici uopće biti pitani za ID broj, (b) hoće li korisnici biti pitani za ID broj, ali će navedeno polje moći ostaviti prazno ili (c) hoće li korisnicima unos u polje ID broj biti obavezan. Ako je ID broj unijet, isti se prikazuje u njihovom profilu.';
$string['configintro'] = 'Na ovoj stranici možete da navedete brojne konfiguracione promjenljive koje će pomoći da Moodle pravilno funkcionira na Vašem serveru. Ne brinite previše o tome - zadane vrijednosti obično su potpuno adekvatne. Kasnije se možete vratiti na ovu stranicu i promjeniti podešavanja prema potrebi.';
$string['configintroadmin'] = 'Na ovoj strani bi trebalo da konfigurišite Vaš glavni administratorski račun koji će imati potpunu kontrolu nad čitavim sajtom. Uvjerite se da ste računu dodijelili sigurno korisničko ime i lozinku, kao i ispravnu e-mail adresu. Kasnije možete kreirati dodatne administratorske račune.';
$string['configintrosite'] = 'Ova stranica vam omogućava da konfigurišete izgled naslovne stranice i naziv sajta. Uvijek se možete naknadno vratiti na ovu stranicu kako biste promjenili ova podešavanja, koristeći meni za administraciju.';
$string['configiplookup'] = 'Kada kliknete na IP adresu (poput. 34.12.222.93), na primjer u zapisima o aktivnostima, biće vam prikazana mapa sa najpribližnijom procjenom lokacije te IP adrese. Postoje različiti dodaci koje možete da izaberete za ovu funkciju, pri čemu svaki ima svoje prednosti i mane.';
$string['configkeeptagnamecase'] = 'Čekirajte ovo ako želite da imena oznaka (tagova) zadrže originalna velika i mala slova kako su ih unijeli kreatori';
$string['configlang'] = 'Izaberite zadani jezik za cijeli sajt. Korisnici mogu da promjene ovo podešavanje koristeći jezički meni ili podešavanje u okviru svog ličnog profila.';
$string['configlanglist'] = 'Ostavite ovu opciju praznom ako želite dati Vašim korisnicima pravo na odabir BILO KOJEG jezičkog paketa instaliranog na nivou Moodle sistema. Međutim, možete skratiti padajući jezički meni unošenjem željenih jezičkih kodova odvojenih zarezima. Primjer: en,de,fr,it';
$string['configlangmenu'] = 'Odaberite želite li prikazati padajući meni za odabir jezika interface na početnoj stranici, stranici za prijavljivanje na sistem, itd. Ovo podešavanje ne onemogućava korisnike u odabiru željenog jezika u njihovom ličnom profilu.';
$string['configlangstringcache'] = 'Sprema sve izraze jezika u kompajlirane datoteke u direktoriju za podatke. Ako prevodite Moodle ili vršite izmjene izraza u izvornom kodu Moodlea, onda ćete možda želiti da ovo isključite. Inače ostavite ga uključeno da vidite napredak u radu.';
$string['configlatinexcelexport'] = 'Odaberite kodiranje za prijenos Excel dokumenata.';
$string['configlocale'] = 'Odaberite lokalna podešavanja na nivou cijelog sajta, što će uticati na oblik prikaza i jezik na kojem se ispisuju datumi. Neophodno je da u okviru Vašeg operativnog sistema imate instaliranu podršku za odgovarajući jezik (npr. eng_US). Ako ne znate šta biste odabrali, ostavite ovo polje praznim.';
$string['configloginhttps'] = 'Uključivanjem ove postavke, Moodle će koristiti protokol HTTPS isključivo za stranicu prijave na sistem (login page), a nakon toga će se koristiti protokol HTTP, povećavajući time brzinu rada. OPREZ: ova postavka ZAHTJEVA da HTTPS bude omogućen i na vašem web serveru - ako HTTPS nije podešen na serveru, UKLJUČIVANJEM OVE POSTAVKE MOŽETE ONEMOGUĆITI PRISTUP Moodle sistemu SEBI I DRUGIMA!!';
$string['configloglifetime'] = 'Ovom postavkom možete zadati koliko dugo želite čuvati logove o korisničkoj aktivnosti. Logovi koji su stariji od zadanog roka će biti automatski obrisani. Dobro je čuvati logove što je duže moguće, u slučaju da vam zatrebaju, ali ako imate server sa većim brojem korisnika i/ili imate zbog toga probleme sa performansama, možda bi bilo bolje podesiti kraći period čuvanja logova. Vrijednosti manje od 30 dana nisu preporučene jer tada neće raditi statistika.';
$string['configlookahead'] = 'Koliko dana unaprijed će biti prikazano';
$string['configmaxbytes'] = 'Ovo podešavanje određuje maksimalnu veličinu postavljenih datoteka na nivou cijelog sajta. Vrijednosti ovog podešavanja su ograničene PHP podešavanjima post_max_size i upload_max_filesize, kao i Apache podešavanjem LimitRequestBody. Zauzvrat, maxbytes ograničava raspon veličina koje se mogu birati na nivou kursa ili modula. Ako izaberete opciju \'Ograničenje servera\' biti će korištena maksimalna vrijednost koju dozvoljava server.';
$string['configmaxconsecutiveidentchars'] = 'Lozinke ne smiju imati više od ovog broja uzastopnih identičnih znakova. Unesite 0 za onemogućavanje ove provjere.';
$string['configmaxeditingtime'] = 'Određuje količinu vremena koje korisnici imaju na raspolaganju za naknadano uređivanje forum poruka, komentara u rječnicima i sličnih operacija. Uobičajena vrijednost od 30 minuta i obično je zadovoljavajuća.';
$string['configmaxevents'] = 'Broj događaja za praćenje unaprijed';
$string['configmaxusersperpage'] = 'Maksimalan broj korisnika koji se prikazuje unutar birača korisnika za kurs, grupu, kohortu, veb servis itd.';
$string['configmessaging'] = 'Da li treba omogućiti sistem za razmjenu poruka između korisnika sajta?';
$string['configmessagingallowemailoverride'] = 'Dozvoli da se korisnicima obavještenja šalju na e-mail adresu različitu od one koja je navedena u njihovom profilu';
$string['configmessagingdeletereadnotificationsdelay'] = 'Obavještenja o pročitanim porukama mogu se obrisati kako bi se sačuvao prostor. Nakon koliko vremena poslije čitanja mogu biti obrisana?';
$string['configmessaginghidereadnotifications'] = 'Sakrij obavještenja o pročitanim porukama u vezi sa događajima kao što su poruke na forumima kada se pregleda historija poruka';
$string['configminpassworddigits'] = 'Lozinke moraju imati najmanje ovoliko brojeva.';
$string['configminpasswordlength'] = 'Lozinke moraju da sadrže najmanje ovoliko karaktera.';
$string['configminpasswordlower'] = 'Lozinke moraju da sadrže najmanje ovoliko malih slova.';
$string['configminpasswordnonalphanum'] = 'Lozinke moraju da sadrže najmanje ovoliko ne-alfanumeričkih karaktera.';
$string['configminpasswordupper'] = 'Lozinke moraju da sadrže najmanje ovoliko velikih slova.';
$string['configmobilecssurl'] = 'CSS datoteka koja omogućava uređivanje izgleda mobilne aplikaicje.';
$string['configmodchooserdefault'] = 'Da li bi \'izbornik za aktivnost\' trebao biti zadan korisnicima?';
$string['configmycoursesperpage'] = 'Maksimalan broj kurseva za prikaz na bilo kojem korisnikovom popisu kurseva';
$string['configmymoodleredirect'] = 'Ovo podešavanje čini obaveznim preusmjeravanje na /my pri pristupu sistemu svih korisnika osim administratora i mijenja postavku osnovnog nivoa sajta na /my';
$string['configmypagelocked'] = 'Ovo podešavanje spriječava da korisnici koji nisu administratori uređuju zadane stranice, poput naslovne stranice sajta.';
$string['confignavcourselimit'] = 'Ograničite broj kurseva koji će biti prikazan korisnicima u situaciji kada su ili nisu prijavljeni na sistem ili nisu upisani ni na jedan kurs.';
$string['confignavshowallcourses'] = 'Ako je ovo podešavanje omogućeno, studenti će vidjeti kurseve u bloku za navigaciju kako unutar grane \'Moji kursevi\', tako i unutar grane \'Kursevi\'. Kada je podešavanje onemogućeno, korisnici sa upisanim kursevima će vidjeti samo granu \'Moji kursevi\'.';
$string['confignavshowcategories'] = 'Prikaži kategorije kurseva u navigacionoj traci i u blokovima za navigaciju Ovo se ne odnosi na kurseve u koje je korisnik trenutno upisan, jer će kursevi, bez kategorija, biti navedeni u meniju pod Moji kursevi (mycourses).';
$string['confignotifyloginfailures'] = 'Ukoliko sistem registruje neuspješne pristupe, obavještenja o tome biće poslana elektronskom poštom. Ko bi trebao da vidi ta obavještenja?';
$string['confignotifyloginthreshold'] = 'Ukoliko je opcija za registrovanje neuspješnih pristupa aktivna, koliki je minimum pogrešnih pristupa po jednom korisniku odnosno jednoj IP adresi neophodan da bi obavještenje o tome bilo poslano?';
$string['confignotloggedinroleid'] = 'Korisnici koji nisu prijavljeni na sistem biće tretirani kao da im je ova uloga dodijeljena u kontekstu sajta. Skoro uvijek je uloga gosta ono što biste poželjeli za takve slučajeve, ali na ovaj način imate mogućnost da koristite uloge kreirane kao manje ili više restriktivne. Ipak, akcije kao što je slanje poruka na forume i tome slično zahtijevaju da korisnik propisno pristupi sistemu.';
$string['configopentogoogle'] = 'Ukoliko uključite ovo podešavanje, onda će Google-u biti omogućeno da ulazi na Vaš sajt kao gost. Osim toga ljudi koji na Vaš sajt budu dolazili posredstvom Google pretraga automatski će biti prijavljeni kao gosti. Napomena: Ovo omogućava pristup samo onim kursevima koji i inače dozvoljavaju pristup sa računom za gosta.';
$string['configoverride'] = 'Definisano u config.php datoteci';
$string['configpasswordpolicy'] = 'Uključivanje ove opcije će omogućiti da Moodle provjerava korisničke lozinke u skladu sa važećim pravilima za kreiranje lozinki. Koristite podešavanja ispod da biste specificirali svoja pravila (ona će biti ignorisana ako ovu opciju postavite na \'Ne\').';
$string['configpasswordresettime'] = 'Ovo određuje vreme koje korisnici imaju na raspolaganju kako bi potvrdili zahtev za resetovanje lozinke, pre nego što ono istekne. Obično je 30 minuta sasvim odgovarajuće vreme.';
$string['configpathtoclam'] = 'Putanja do Clam AV alata. Vjerovatno nešto poput /usr/bin/clamscan ili /usr/bin/clamdscan. Ovu vrijednost je potrebno unijeti da bi se koristio Clam AV.';
$string['configpathtodu'] = 'Putanja do "du". Vjerovatno nešto poput /usr/bin/du. Ako ovo unesete, stranice koje prikazuju sadržaj direktorija će raditi mnogo brže za direktorije sa mnogo datoteka.';
$string['configperfdebug'] = 'Ako ovo uključite, informacije o performansama biće prikazane u podnožju standardne grafičke teme';
$string['configprofileroles'] = 'Popis uloga koje su vidljive na korisničkim profilima i stranici sa popisom učesnika.';
$string['configprofilesforenrolledusersonly'] = 'Da bi se spriječila zloupotreba od strane spamera, polje za opis na stranici sa profilom, korisnika koji se još nisu upisali na kurs, je sakriveno. Novi korisnici moraju se upisati najmanje na jedan kurs prije nego što dodaju opis.';
$string['configprotectusernames'] = 'Po zadanim podešavanjima forget_password.php ne prikazuje nikakvu pomoć za pogađanje korisničkih imena ili e-mail adresa.';
$string['configproxybypass'] = 'Zarezima odvojeni popis (djelomičnih) naziva servera ili IP adresa koje mogu zaobići proxy (npr. 192.168., .domena.ba)';
$string['configproxyhost'] = 'Ukoliko <b>server</b> mora da koristi proxy računar (npr. "zaštitni zid") za pristup Internetu, unesite ovdje njegovu adresu i port. U suprotnom ostavite ovo polje prazno.';
$string['configproxypassword'] = 'Lozinka potrebna za pristup internetu putem proxy servera, ukoliko je to neophodno. Ostavite prazno ukoliko proxy server nije potreban (neophodna je PHP cURL ekstenzija)';
$string['configproxyport'] = 'Ako ovaj server mora da koristi proxy računar, navedite ovde proxy port.';
$string['configproxytype'] = 'Tip Web Proxy servera (PHP5 i cURL ekstenzija su neophodni za podršku za SOCKS5)';
$string['configproxyuser'] = 'Korisničko ime potrebno za pristup Internetu putem Proxy servera ukoliko je to neopohodno. Ostaviti prazno ukoliko Proxy nije potreban (neophodna je PHP cURL ekstenzija)';
$string['configquarantinedir'] = 'Ako želite da ClamAV smjesti zaražene datoteke u mapu karantene, istu zadajte ovdje. Nad istom web serveru mora imati ovlasti pisanja. Ako ovo ostavite praznim, ili ako zadate mapu koja ne postoji ili u koju ne može pisati, zaražene datoteke će biti obrisane. Nemojte upisivati kosu crtu (slash) na kraju.';
$string['configrecaptchaprivatekey'] = 'Niz znakova koji služi za komunikaciju između vašeg Moodle poslužitelja i recaptcha.net poslužitelja. Možete ga dobiti posjetite li http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Niz znakova koji se koristi za prikaz reCAPTCHA elementa na obrascu za prijavu. Stvaraju se na http://www.google.com/recaptcha';
$string['configrequestcategoryselection'] = 'Omogući izbor kategorije pilikom zahtjeva za izbor kursa.';
$string['configrequestedstudentname'] = 'Naziv za studenta u zahtjevanim kursevima';
$string['configrequestedstudentsname'] = 'Naziv za studente (množina) u zahtjevanim kursevima';
$string['configrequestedteachername'] = 'Naziv za predavača u zahtjevanim kursevima';
$string['configrequestedteachersname'] = 'Naziv za predavače (množina) u zahtjevanim kursevima';
$string['configrequiremodintro'] = 'Isključite ovu opciju ukoliko ne želite da primoravate korisnike da unose opis svake aktivnosti.';
$string['configrunclamavonupload'] = 'Ako je ova opcija omogućena, clam AV će biti korišten za provjeru svih postavljenih datoteka.';
$string['configrunclamonupload'] = 'Koristiti Clam AV pri postavljanju datoteka? Da bi ovo podešavanje uspješno radilo, morate navesti tačnu putanju do direktorija u kojem se nalazi Clam AV. (Clam AV je BESPLATNI antivirusni softver koji možete preuzeti sa http://www.clamav.net/)';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'Mail';
$string['configsectionmaintenance'] = 'Održavanje';
$string['configsectionmisc'] = 'Razno';
$string['configsectionoperatingsystem'] = 'Operativni sistem';
$string['configsectionpermissions'] = 'Dozvole';
$string['configsectionrequestedcourse'] = 'Zahtjevi za otvaranje novog kursa';
$string['configsectionsecurity'] = 'Sigurnost';
$string['configsectionstats'] = 'Statistika';
$string['configsectionuser'] = 'Korisnik';
$string['configsecureforms'] = 'Moodle može da koristi dodatni nivo sigurnosti kada prima podatke iz Web formi. Ukoliko je to omogućeno, onda se HTTP_REFERER promijenljiva Web pretraživača upoređuje sa trenutnom adresom forme. U veoma malom broju slučajeva to može prouzrokavati probleme ako korisnik upotrijebljava "zaštitni zid" (npr. Zonealarm) konfigurisan tako da uklanja HTTP_REFERER promjenljivu iz Web saobraćaja. Posljedica toga je tzv. "zaglavljivanje u formi". Ukoliko Vaši korisnici imaju problema, na primjer, sa stranicom za prijavu, možda ćete željeti da onemogućite ovo podešavanje, iako će to Vaš sajt učiniti daleko osjetljivijim na hakerske napade razbijanja lozinki grubom silom. Ukoliko ste u dilemi, omogućite ovu opciju.';
$string['configsessioncookie'] = 'Ova postavka prilagođava naziv cookie datoteke koju koriste Moodle sesije. Ovo je opcionalno, i jedino je korisno kako bi se lakše razlikovalo cookie datoteke kada postoji više od jedne instance Moodle-a na istome fizičkom sajtu.';
$string['configsessioncookiedomain'] = 'Ovo Vam dozvoljava da mijenjate domenu sa koje su Moodle cookies dostupni. To je korisno za razna prilagođavanja Moodlea (npr. dodaci za provjeru identiteta ili upis) koji moraju da dijele informacije o Moodle sesiji sa Web aplikacijom na drugom poddomenu. <strong>UPOZORENJE: toplo preporučujemo da ovo podešavanje ostavite prazno (zadana vrijednost) - neispravna vrijednost će spriječiti bilo kakvu prijavu na sajt.</strong>';
$string['configsessioncookiepath'] = 'Ako je potrebno da promjenite gde web pretraživači šalju Moodle cookies, možete promjeniti ovo podešavanje tako što ćete odredite poddirektorij svog web sajta. Inače, standardna vrijednost \'/\' trebalo bi da je sasvim prihvatljiva.';
$string['configsessiontimeout'] = 'Ukoliko su korisnici koji su prijavljeni na sajt, neaktivni duži vremenski period (ne učitavaju stranice), biće automatski odjavljeni (njihove sesije biće završene). Ova varijabla određuje koliki bi trebao biti taj vremenski period.';
$string['configshowcommentscount'] = 'Prikaži broj komentara. Biće potrebno izvršiti samo jedan upit više prilikom prikaza linka komentara.';
$string['configshowsiteparticipantslist'] = 'Svi ovi studenti i predavači na nivou sajta biće prikazani na popisu učesnika. Kome će biti dozvoljeno da vidi ovaj popis učesnika?';
$string['configsitedefaultlicense'] = 'Zadana licenca sajta';
$string['configsitedefaultlicensehelp'] = 'Zdana licenca za objavljivanje sadržaja na ovom sajtu';
$string['configsitemaxcategorydepth'] = 'Maksimalan broj podkategorija';
$string['configsitemaxcategorydepthhelp'] = 'Ovo određuje maksimalan broj podkategorija koji će biti prikazan.';
$string['configslasharguments'] = 'Datoteke (slike, postavljene datoteke i sl.) su dostupne pomoću skripte koja koristi tzv. slash argument. Ovaj metod omogućava da datoteke budu lakše cache-irane u web pretraživaču, proxy serverima itd. Nažalost, neki PHP serveri ne dozvoljavaju korištenje ovog metoda, tako da ukoliko imate problema da vidite postavljene datoteke ili slike (npr. slike korisnika), onda onemogućite ovo podešavanje.';
$string['configsmartpix'] = 'Ako se ova opcija uključi ikonice će učitavati PHP skriptu koji pretražuje trenutnu grafičku temu sajta, potom sve nadređene teme, i konačno Moodle /pix direktorij. Ovo smanjuje potrebu za čuvanjem duplikata slika unutar tema, ali i utiče na performanse sistema.';
$string['configstartwday'] = 'Dan kojim počinje radna sedmica';
$string['configstatsfirstrun'] = 'Ovo podešavanje određuje koliki vremenski interval se uzima u obzir pri obradi zapisa o aktivnostima, <b>prvi put</b> kada "cronjob" želi da procesira statističke podatke. Ako imate dosta saobraćaja i na dijeljenom ste serveru, vjerovatno nije dobra ideja da idete previše unazad, jer bi moglo biti potrebno previše vremena za izvršavanje procesa i ta bi aktivnost bila prilično zahtijevna za server. (Imajte i vidu da je za ovo podešavanje 1 mjesec = 28 dana. Na grafikonima i izvještajima koji se generišu 1 mjesec odgovara jednom kalendarskom mjesecu.)';
$string['configstatsmaxruntime'] = 'Procesiranje statističkih podataka može biti prilično intenzivno, pa koristite kombinaciju ovog i slijedećeg polja da specificirate kada će se ono izvršavati i koliko dugo će trajati.';
$string['configstatsmaxruntime2'] = 'Statistička obrada može biti prilično intezivna. Odredite maksimalno vrijeme koje se dopušta za prikupljanje statističkih podataka za jedan dan. Maksimalni broj dana koji se obrađuje u jednom izvršenju crona je 31.';
$string['configstatsmaxruntime3'] = 'Naznačite maksimalno dozvoljeno vrijeme za izračunavanje statistike za jedan dan. Imajte u vidu da procesiranje statističkih podataka može u velikoj mjeri opteretiti server. Maksimalna broj dana obrađenih u jednom kronu može biti naznačeno ispod.';
$string['configstatsruntimedays'] = 'Podesite maksimalni broj dana koji se obrađuje u svakom izvršavanju statistike. Kada je statistika ažurna, samo će jedan dan biti obrađivan, zato podesite ovu vrijednost prema opterećenju Vašeg servera, smanjujući je ako su potrebna kraća izvršavanja Cron-a.';
$string['configstatsruntimestart'] = 'U koje vrijeme bi trebalo da <b>započne</b> sa izvršavanjem cronjob koji precesira statističke podatke? Specificiranje različitih vremena je preporučljivo ukoliko postoji više Moodle stranica na istom serveru.';
$string['configstatsuserthreshold'] = 'Ovo podešavanje određuje minimalan broj upisanih korisnika, potreban da bi kurs bio uključen u statističko izračunavanje.';
$string['configstrictformsrequired'] = 'Ako je ovo podešavanje omogućeno, korisnicima neće biti dozvoljeno da unose razmak ili prelaz u novi red, ali samo unutar obaveznih polja u obrascima.';
$string['configstripalltitletags'] = 'Isključite ovo podešavanje da biste omogućili HTML oznake u imenima aktivnosti i resursa.';
$string['configsupportemail'] = 'Ova email adresa će se prikazivati korisnicima sajta kao ona na koju treba pisati kad im je potrebna neka opšta pomoć (na primjer kad novi korisnici kreiraju svoje račune). Ako se ne popuni ovo polje, onda takva korisna adresa neće biti dostupna.';
$string['configsupportname'] = 'Ovo je ime osobe/organizacije zadužene za pružanje opšte pomoći korisnicima putem e-maila ili Web sajta.';
$string['configsupportpage'] = 'Ova Web adresa će se prikazivati korisnicima sajta kao ona koju treba posjetiti u slučaju da im zatreba neka opšta pomoć (na primjer kad novi korisnici kreiraju svoje račune). Ako se ne popuni ovo polje, takav link neće biti dostupan.';
$string['configthemedesignermode'] = 'Uobičajeno je da se sve slike grafičke teme kao i CSS datoteke na duži vremenski period spremaju u web pretraživaču i na serveru, zbog brzine izvršavanja. Ako dizajnirate teme ili razvijate izvorni kôd, vjerovatno ćete željeti da uključiti ovaj režim rada kako bi ste izbegli da dobijate verzije iz cache. Upozorenje: Ovo će usporiti vaš sajt za sve korisnike! Alternativno, možete da resetujete cache ručno na stranici za izbor teme.';
$string['configthemelist'] = 'Ostavite ovo polje prazno da biste dozvolili upotrebu bilo koje grafičke teme. Ukoliko želite da skratite popis tema, ovdje možete da navedite popis njihovih naziva, razdvojenih zarezima (nemojte koristiti razmake!). Na primjer: standard,orangewhite.';
$string['configtimezone'] = 'Ovdje možete da podesite zadanu vremensku zonu. To je ZADANA vremenska zona, samo za prikaz datuma - svaki korisnik u okviru svog profila može da podesi vlastitu vremensku zonu. Opcija "Lokalno vrijeme servera" će kao zadanu vrijednost koristiti podešavanje operativnog sistema servera na kojem je instaliran Moodle. Ukoliko korisnik u svom profilu izabere opciju "Lokalno vrijeme servera" za njega će zadana vremenska zona biti ona koju ovdje podesite. Cron poslovi čije izvršavanje zavisi od doba dana će koristiti ovu vremensku zonu.';
$string['configuseblogassociations'] = 'Da li je potrebno da korisnici mogu da organizuju svoje blogove povezivanjem članaka sa kursevima i modulima kursa?';
$string['configuseexternalyui'] = 'Umjesto lokalnih datoteka, koristite online datoteke dostupne na Yahoo serverima. UPOZORENJE: Ovo zahtijeva Internet konekciju, ili AJAX uopće neće raditi na Vašem sajtu.';
$string['configuserquota'] = 'Maksimalan broj bajtova koje korisnik može da sačuva u svom prostoru za privatne datoteke. {$a->bytes} bajtova == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Ako je ovo podešavanje omogućeno, onda će se u navigaciji za stranice sajta, umjesto fraze \'Stranice sajta\', koristiti skraćeni naziv sajta.';
$string['configusetags'] = 'Da li treba omogućiti oznake (tagove) na čitavom sajtu?';
$string['configvariables'] = 'Promjenljive';
$string['configverifychangedemail'] = 'Omogući potvrdu promjenjenih e-mail adresa koji koristeći podešavanje za dozvoljene i zabranjene domene e-mail adresa. Ukoliko je ovo podešavanje isključeno ograničenje domena će biti korišteno samo prilikom kreiranja novih korisničkih računa.';
$string['configvisiblecourses'] = 'Normalno prikazuje kurseve koji su u skrivenim kategorijama.';
$string['configwarning'] = 'Pažljivo mijenjajte ove postavke - neobične vrijednosti mogu uzrokovati probleme.';
$string['configyuicomboloading'] = 'Ova opcija omogućava optimizaciju učitavanje kombinovanih datoteka YUI biblioteke. Ovo podešavanje treba da bude uključeno na produkcionim sajtovima zbog boljih performansi.';
$string['confirmation'] = 'Potvrda';
$string['confirmdeletecomments'] = 'Obrisati ćete komentare. Da li ste sigurni?';
$string['confirmed'] = 'Potvrđeno';
$string['convertformat'] = '<i>konvertuj</i> izlazni format';
$string['cookiehttponly'] = 'Samo http cookies';
$string['cookiesecure'] = 'Samo sigurni cookies';
$string['country'] = 'Zadana država';
$string['coursecontact'] = 'Menadžeri kurseva';
$string['coursecontact_desc'] = 'Ovo podešavanje vam omogućava kontrolu nad tome ko se pojavljuje pod opisom kursa. Korisnici trebaju da imaju najmanje jednu ulogu pod nekim kursem da bi im bilo omogućeno pojavljivanje pod opisom kursa.';
$string['courselistshortnames'] = 'Prikaži proširene nazive kurseva';
$string['courselistshortnames_desc'] = 'Prilikom prikazivanja popisa kurseva prikaži skraćeni, kao i pun naziv kursa.';
$string['coursemgmt'] = 'Dodaj/Uredi kurseve';
$string['courseoverview'] = 'Pregled kursa';
$string['courserequestnotify'] = 'Obavještenje o zahtjevu za pokretanje novog kursa';
$string['courserequestnotifyemail'] = 'Korisnik {$a->user} je zatražio/la novi kurs na {$a->link}';
$string['courserequests'] = 'Zahtjevi za pokretanje novog kursa';
$string['courserequestspending'] = 'Zahtjevi za pokretanje kurs na čekanju';
$string['courses'] = 'Kursevi';
$string['coursesperpage'] = 'Broj kurseva po stranici';
$string['courseswithsummarieslimit'] = 'Kursevi sa limitiranim sažetkom';
$string['creatornewroleid'] = 'Uloga kreatora u novim kursevima';
$string['creatornewroleid_help'] = 'Ukoliko korisnik već nema ovlaštenja da upravlja novim kursom, onda je automatski upisan koristeći ovu ulogu';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Pokretanje Crona isključivo preko komandne linije';
$string['cronerrorclionly'] = 'Žalim, internet pristup ovoj stranici je onemogućen od strane administratora.';
$string['cronerrorpassword'] = 'Žao nam je, niste unijeli ispravnu lozinku da biste pristupili ovoj stranici';
$string['cron_help'] = 'Cron.php pomaže nekim od Moodle modula u obavljanju zadataka u pravilnim vremenskim intervalima, kao što je slanje kopija novih poruka sa foruma putem e-maila. Potrebno je redovno pokretanje cron skripte, npr. na svakih 5 minuta.';
$string['cronremotepassword'] = 'Cron lozinka za udaljeni pristup';
$string['cronwarning'] = '<a href="cron.php">cron.php skripta za održavanje</a> nije pokretana bar u posljednjih 24 sata.';
$string['ctyperecommended'] = 'Instaliranje opcione PHP ekstenzije ctype se strogo preporučuje da bi se unapredilo funkcionisanje sajta, pogotovo ako Vaš sajt podržava ne-latinične jezike.';
$string['ctyperequired'] = 'PHP ekstenzije ctype je sada obavezna za Moodle, da bi se unapredilo funkcionisanje sajta i da bi se nudila višejezična kompatibilnost.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrecommended'] = 'Instaliranje opcione cURL biblioteke je vrlo preporučljivo, da bi se omogućilo korištenje funkcija za umrežavanje (Moodle Networking).';
$string['curlrequired'] = 'PHP ekstenzijа cURL sada je obavezna za Moodle zbog komunikacije sa Moodle repozitorijima.';
$string['curltimeoutkbitrate'] = 'Brzina protoka u bitovima koja se koristi prilikom izračunvanja cURL tajmauta (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Ovo podešavanje se koristi za izračunavanje odgovarajućeg tajm-auta kod velikih cURL zahtijeva. Kao dio ovog proračuna kreira se HTTP HEAD zahtjev kako bi se odredila veličina sadržaja. Postavljanjem ovog parametra na 0 onemogućava se kreiranje ovog zahtijeva.';
$string['currenttheme'] = 'Trenutna grafička tema';
$string['customcheck'] = 'Druge provjere';
$string['custommenu'] = 'Prilagođeni meni';
$string['custommenuitems'] = 'Stavke prilagođenog menija';
$string['datarootsecurityerror'] = '<p><strong>SIGURNOSNO UPOZORENJE!</strong></p><p>Vaša dataroot direktorij se nalazi na krivoj lokaciji i dostupna je putem weba. Ovo znači da su sve vaše privatne datoteke dostupne svima u svijetu, i da neke od njih mogu biti iskorištene od strane hakera kako bi neovlašteno pristupili Vašem serveru!</p> <p><em>MORATE</em> premjestiti dataroot direktorij ({$a}) na novu lokaciju koja nije unutar vaše javno dostupne web mape i potom promijeniti postavku <code>$CFG->dataroot</code> u vašoj config.php datoteci.</p>';
$string['datarootsecuritywarning'] = 'Konfiguracija vašeg sajta možda nije sigurna. Molimo provjerite da se vašoj osnovnoj mapi s podacima ({$a}) ne može pristupiti direktno preko weba.';
$string['dbmigrate'] = 'Migracija Moodle baze podataka';
$string['dbmigrateconnecerror'] = 'Nije moguće povezivanje na tu bazu podataka.';
$string['dbmigrateencodingerror'] = 'Navedena baza podataka ima kodiranje {$a} umjesto tražene UNICODE/UTF8.<br/>Odaberite neku drugu.';
$string['dbmigratepostgres'] = 'Čini se da koristite PostgreSQL kao server baze podataka. Da biste nastavili sa migracionim procesom morate ručno kreirati novu bazu sa kodiranjem "UNICODE"(PostgreSQL 7) ili "UTF8" (PostgreSQL 8) za čuvanje migriranih podataka. Molimo unesite podešavanja za povezivanje sa Vašom novom bazom podataka ispod da biste nastavili:';
$string['dbmigratewarning'] = 'Molimo provjerite jeste li napravili kopiju svoje Moodle baze podataka prije početka ovog postupka. Ako niste sigurni kako to učiniti, obratite se vašem administratoru. Vaš Moodle sistem će biti stavljen u stanje održavanja sistema nakon pokretanja procesa migracije';
$string['dbmigratewarning2'] = '<b>Upozorenje: Upravo ćete započeti proces migracije baze podataka. Molimo provjerite da li je napravljena rezervna kopija Vaše kompletne Moodle baze podataka.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Ova baza podataka migrirana je na novu UTF8 bazu, te se smatra zastarijelom. Molimo podesite Vašu config.php datoteku i koristite novu bazu podataka za ovu Moodle verziju.</font>';
$string['dbmigrationdupfailed'] = 'Dupliranje baze podataka nije uspjelo. Moguća greška do koje je došlo je:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Korištenje baze podataka za informacije o sesijama';
$string['debug'] = 'Otklanjanje grešaka u porukama';
$string['debugall'] = 'SVE: Prikaz svih razumljivih PHP poruka o greškama';
$string['debugdeveloper'] = 'RAZVOJNE: Prikaz dodatnih Moodle poruka o greškama i njihovom otklanjanju, namjenjenih samo onima koji razvijaju ovaj softver.';
$string['debugdisplay'] = 'Prikaži poruke o otklanjanju grešaka';
$string['debugging'] = 'Otklanjanje grešaka';
$string['debugminimal'] = 'MINIMALNO: Prikaz samo fatalnih grešaka';
$string['debugnone'] = 'BEZ OTKLANJANJA: Bez prikaza bilo kakvih grešaka ili upozorenja';
$string['debugnormal'] = 'NORMALNO: Prikaz grešaka, upozorenja i obavještenja';
$string['debugpageinfo'] = 'Prikaži informacijе o stranici';
$string['debugsmtp'] = 'Uklanjanje grešaka kod slanja e-mailova';
$string['debugstringids'] = 'Prikaži porijeklo jezičkih izraza';
$string['debugstringids_desc'] = 'Ova opcija je osmišljena kako bi  pomogla prevodiocima. Kada je ova opcija omogućena, ako URL adresi dodate parametar strings=1, to će prikazati jezičku datoteku i id stringa pored svakog stringa (izraza).';
$string['debugvalidators'] = 'Prikaži link ka servisima za provjeru validnosti';
$string['defaultcity'] = 'Zadani grad';
$string['defaultcity_help'] = 'Grad koji ovde unesete biće zadani grad za sve novootvorene korisničke račune.';
$string['defaultformatnotset'] = 'Greška prilikom određivanja formata kursa. Provjerite postavke.';
$string['defaulthomepage'] = 'Zadana početna stranica za korisnike';
$string['defaultrequestcategory'] = 'Zadana kategorija za kurs zahtjeve';
$string['defaultsettinginfo'] = 'Zadana vrijednost: {$a}';
$string['defaultuserroleid'] = 'Zadana uloga za sve korisnike';
$string['deleteincompleteusers'] = 'Brisanje nepotpunih korisnika poslije';
$string['deleteunconfirmed'] = 'Obriši nepotvrđene korisnike nakon';
$string['deleteuser'] = 'Brisanje korisnika';
$string['density'] = 'Gustina';
$string['denyemailaddresses'] = 'Nedozvoljene e-mail domene';
$string['development'] = 'Razvoj';
$string['devicedetectregex'] = 'Regularni izrazi za detekciju uređaja';
$string['devicedetectregex_desc'] = '<p>Standardno, Moodle može da detektira zadani tip uređaja (stolni i prenosivi računari itd.), mobilni uređaj (pametni telefoni, ručni računari) tablet (iPad, Android tableti) kao i starije tipove Web pretraživača (Internet Explorer 6 korisnici). Pomoću selektora grafičke teme moguće je za svaki od ovih tipova uređaja podesiti zasebna tema. Ovo podešavanje dozvoljava korištenje regularnih izraza koji omogućavaju detekciju dodatnih tipova uređaja (ovi imaju prednost u odnosu na zadane tipove).</p> <p>Na primjer, možete da unesete regularni izraz \'/(MIDP-1.0|Maemo|Windows CE)/\' za detekciju nekih najčešće korištenih telefona dodajte povratnu vrijednost \'featurephone\'. Ovo dodaje \'featurephone\' u selektor grafičke teme što će Vam omogućiti da dodate temu koja će se koristiti na ovim uređajima. Ostali telefoni će i dalje koristiti temu koja je izabrana za mobilne uređaje.</p>';
$string['devicedetectregexexpression'] = 'Regularni izrazi';
$string['devicedetectregexvalue'] = 'Povratna vrijednost';
$string['devicetype'] = 'Tip uređaja';
$string['disableuserimages'] = 'Isključi slike u korisničkom profilu';
$string['displayerrorswarning'] = 'Omogućavanje podešavanja u PHP-u <em>display_errors</em> nije preporučljivo kod zvaničnih sajtova, jer neke poruke o greškama mogu otkriti osjetljive informacije o vašem serveru.';
$string['displayloginfailures'] = 'Prikaz neuspješnih prijava za';
$string['dndallowtextandlinks'] = 'Postavljanje teksta/linkova pomoću opcije \'prevuci i spusti';
$string['docroot'] = 'Korijenski direktorij Moodle dokumentacije';
$string['doctonewwindow'] = 'Otvoriti u novom prozoru';
$string['download'] = 'Preuzmi';
$string['edithelpdocs'] = 'Uređivanje dokumenata pomoći';
$string['editingnoncorelangfile'] = 'Pokušavate da uredite prevod dodatka (dodatnog modula). Možete sačuvati prevod nezavisnih (3rd party) modula samo u svom lokalnom ( _local) folderu. Možda ćete željeti da premjestiti datoteku sa prevodom u jezički direktorij modula i/ili da ga pošaljete osobi koja održava dodatni modul.';
$string['editlang'] = '<b>Uređivanje</b>';
$string['editorbackgroundcolor'] = 'Pozadinska boja';
$string['editordictionary'] = 'Editor rječnika';
$string['editorfontfamily'] = 'Porodica fontova';
$string['editorfontlist'] = 'Popis fontova';
$string['editorfontsize'] = 'Veličina fonta';
$string['editorhidebuttons'] = 'Skrivene tipke';
$string['editorkillword'] = 'Filter Word formata';
$string['editorspelling'] = 'Editor pravopisa';
$string['editorspellinghelp'] = 'Uključi/isključi provjeru pravopisa. Kada je uključeno, <strong>aspell</strong> mora biti instaliran na serveru.';
$string['editstrings'] = 'Uređivanje riječi ili izraza';
$string['emailchangeconfirmation'] = 'Potvrda izmjene e-mail adrese';
$string['emoticonalt'] = 'Alternativni tekst';
$string['emoticoncomponent'] = 'Grafička komponenta emotikona';
$string['emoticonimagename'] = 'Naziv slike';
$string['emoticons'] = 'Emotikoni';
$string['emoticons_desc'] = 'Na ovoj stranici možete podesiti emotikone koji će se koristiti na Vašem sajtu. Kako bi uklonili red iz tabele pohranite obrazac sa praznim vrijednostima. Kako bi zadali novi emotikon, popunite polja u zadnjem praznom redu. Kako bi sve vrijednosti vratili na inicijalno zadane vrijednosti, kliknite na link prikazan gore. * Tekst (obvezno) - Ovaj tekst će biti zamijenjen sa slikom emotikona. Mora sadržavati barem 2 znaka. * Naziv slike (obvezno) - Slika emotikona bez ekstenzije, relativno u odnosu na pix mapu komponente. * Komponenta slike (obvezno) - Komponenta koja pruža ikonu. * Alternativni tekst (opcionalno) - Identifikator niza i komponente alternativnog teksta emotikona.';
$string['emoticonsreset'] = 'Resetuj podešavanja emotikona na zadane vrijednosti';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Prazno';
$string['enableajax'] = 'Uključi AJAX';
$string['enableblogs'] = 'Omogući blogove';
$string['enablecalendarexport'] = 'Omogući prijenos kalendara';
$string['enablecomments'] = 'Omogući komentare';
$string['enablecourserequests'] = 'Omogući slanje zahtijeva za pokretanje novih kurseva';
$string['enablecssoptimiser'] = 'Omogući optimizaciju CSS-a';
$string['enablecssoptimiser_desc'] = 'Kada je ova opcija omogućena CSS će prije spremanja biti pokrenut kroz proces optimizacije. Ovaj proces obrađuje CSS tako što uklanja duplikate pravila i stilova, kao i razmake koji se mogu ukloniti, i tako što ga reformatira. Molimo vas, imajte u vidu da uključivanje ove opcije u isto vrijeme kada je uključen i režim za dizajniranje tema, ima ozbiljne posljedice na performanse sistema, ali pomaže dizajnerima tema da kreiraju optimizovani CSS.';
$string['enabled'] = 'Omogućeno';
$string['enabledevicedetection'] = 'Omogućite detekciju uređaja';
$string['enablegravatar'] = 'Omogući Gravatar';
$string['enablegravatar_help'] = 'Kada je ova opcija omogućena Moodle će pokušati da preuzme sliku za profil sa Gravatara, ako korisnik nije postavio svoju sliku.';
$string['enablegroupmembersonly'] = 'Omogući samo članovima grupe';
$string['enablemobilewebservice'] = 'Omogućite web servise za mobilne uređaje';
$string['enablerecordcache'] = 'Uključi cache za zapis podataka';
$string['enablerssfeeds'] = 'Omogući RSS izvore vijesti';
$string['enablesafebrowserintegration'] = 'Omogući Safe Exam Browser integraciju';
$string['enablestats'] = 'Omogući statistiku';
$string['enabletgzbackups'] = 'Omogući novi format rezervne kopije';
$string['enabletgzbackups_desc'] = 'Ako je ova opcija omogućena, buduće rezervne kopije biće kreirane u novom komprimovanom formatu za .mbz datoteke (interno uskladištene kao .tar.gz datoteka). Ovo uklanja ograničenje veličine datoteke rezervne kopije od 4GB i može da unaprijedi performanse sistema. Proces restauracije rezervne kopije podržava oba formata, a razlika između njih treba da bude transparentna za korisnike.';
$string['enabletgzbackups_nozlib'] = 'PHP ekstenzija &lsquo;zlib&rsquo; nije dostupna. Novi format rezervne kopije počiva na ovoj ekstenziji i biće onemogućen sve dok zlib ne bude instaliran i omogućen.';
$string['enabletrusttext'] = 'Omogući pouzdani sadržaj';
$string['enablewebservices'] = 'Omogući Web servise';
$string['enablewsdocumentation'] = 'Dokumentacija Web servisa';
$string['enrolinstancedefaults'] = 'Zadane vrijednosti instance upisa';
$string['enrolinstancedefaults_desc'] = 'Zadana podešavanja upisa u novim kursevima';
$string['enrolmultipleusers'] = 'Upisati korisnike';
$string['environment'] = 'Okruženje';
$string['environmenterrortodo'] = 'Morate riješiti sve probleme okruženja (greške) navedene iznad prije nastavka instalacije ove Moodle verzije!';
$string['environmenterrorupgrade'] = 'UPOZORENJE: Trebate riješiti sve pronađene probleme okruženja (greške) prije nego što nastavite nadogradnju Moodlea. Prelaz na novu verziju bez ispravljanja pronađenih grešaka mogu dovesti do gubitka podataka. Da li ste sigurni da želite da nastavite nadogradnju?';
$string['environmentmustfixsetting'] = 'PHP podešavanje mora biti promijenjeno.';
$string['environmentok'] = 'Vaše serversko okruženje zadovoljava sve minimalne zahtijeve.';
$string['environmentrecommendcustomcheck'] = 'ukoliko ovaj test ne prođe, postoji mogućnost pojavljivanja potencijalnog problema.';
$string['environmentrecommendinstall'] = 'je preporučljivo instalirati/omogućiti da bi se dobili najbolji rezultati';
$string['environmentrecommendversion'] = 'zadana verzija je {$a->needed} a Vi trenutno koristite verziju {$a->current}';
$string['environmentrequirecustomcheck'] = 'Ovaj kviz mora proći';
$string['environmentrequireinstall'] = 'mora biti instaliran i omogućen';
$string['environmentrequireversion'] = 'neophodna verzija je {$a->needed} a Vi trenutno koristite verziju {$a->current}';
$string['environmentsettingok'] = 'detektovano je preporučeno podešavanje';
$string['environmentshouldfixsetting'] = 'PHP podešavanje bi trebalo biti promijenjeno.';
$string['environmentxmlerror'] = 'Greška u čitanju podataka okruženja ({$a->error_code})';
$string['errordeletingconfig'] = 'U toku brisanja konfiguracionog zapisa za dodatak \'{$a}\' pojavila se greška.';
$string['errorsetting'] = 'Nije moguće sačuvati podešavanje';
$string['errorwithsettings'] = 'Neka podešavanja nisu promijenjena zbog greške.';
$string['everyonewhocan'] = 'Svako ko može \'{$a}';
$string['exceptions'] = 'izuzeci';
$string['execpathnotallowed'] = 'Podešavanje izvršnih putanja u datoteci config.php je onemogućeno';
$string['experimental'] = 'Eksperimentalno';
$string['experimentalsettings'] = 'Eksperimentalna podešavanja';
$string['extendedusernamechars'] = 'Dozvoliti prošireni izbor karaktera u korisničkim imenima';
$string['extramemorylimit'] = 'Dodatno PHP memorijsko ograničenje.';
$string['fatalmagicquotesruntime'] = '<p>Uočena je ozbiljna konfiguracijska greška. Molimo vas, obavijestite administratora.</p><p> Kako bi funkcionisao pravilno Moodle zahtijeva da administrator promjeni PHP podešavanja.</p><p><code>magic_quotes_runtime</code> mora biti podešen na <code>off</code>.</p><p>Ovo podešavanje se može promjenti editovanjem <code>php.ini</code>datoteke, konfiguracijom Apache/IIS severa<br />ili <code>.htaccess</code> datoteke na serveru.</p>';
$string['fatalsessionautostart'] = '<p>Otkrivena je ozbiljna konfiguracijska greška. Molimo Vas da obavijestite administratora.</p><p> Kako bi funkcionisao pravilno Moodle zahtijeva da administrator promjeni PHP podešavanja.</p> <p><code>session.auto_start</code> mora biti podešen na <code>off</code>.</p> <p>Ovo podešavanje se može promjenti editovanjem <code>php.ini</code>datoteke, konfiguracijom Apache/IIS severa<br />ili <code>.htaccess</code> datoteke na serveru.</p>';
$string['filecreated'] = 'Kreirana je nova datoteka';
$string['filestoredin'] = 'Snimi datoteku u direktorij:';
$string['filestoredinhelp'] = 'Gdje će datoteka biti smještena';
$string['filterall'] = 'Filtriraj sve stringove';
$string['filtermatchoneperpage'] = 'Poklapanje filtera jednom po stranici';
$string['filtermatchonepertext'] = 'Poklapanje filtera jednom po tekstu';
$string['filters'] = 'Filteri';
$string['filtersettings'] = 'Upravljanje filterima';
$string['filtersettingsgeneral'] = 'Opća podešavanja filtera';
$string['filteruploadedfiles'] = 'Filtriraj postavljene datoteke';
$string['forcelogin'] = 'Obavezno prijavljivanje korisnika na sistem';
$string['forceloginforprofileimage'] = 'Korisnici se moraju prijaviti na sistem da bi mogli da vide slike korisnika';
$string['forceloginforprofileimage_help'] = 'Ako je ovo podešavanje omogućeno, korisnici moraju da budu prijavljeni na sistem kako bi mogli da vide slike drugih korisnika. U suprotnom vidjeti će zadanu sliku za korisnika u svim e-mail porukama.';
$string['forceloginforprofiles'] = 'Obavezno prijavljivanje korisnika za pregled profila';
$string['forcetimezone'] = 'Obavezna zadana vremenska zona';
$string['formatuninstallwithcourses'] = 'Postoji ukupno {$a->count} kurseva koji koriste  {$a->format}. Njihov format će biti promjenjen u {$a->defaultformat} (zadani format za stranicu). Postoji šansa da će neki podaci usko vezani za prijašnji format biti izbrisani. Da li želite da nastavite?';
$string['frontpage'] = 'Naslovna stranica';
$string['frontpagebackup'] = 'Rezervna kopija naslovne stranice';
$string['frontpagedefaultrole'] = 'Zadana uloga za naslovnu stranu';
$string['frontpagefilters'] = 'Filteri naslovne stranice';
$string['frontpageloggedin'] = 'Stavke na naslovnoj stranici kada je korisnik prijavljen na sistem';
$string['frontpageoverrides'] = 'Promjene ovlaštenja na naslovnoj stranici';
$string['frontpagequestions'] = 'Pitanja naslovne stranice';
$string['frontpagerestore'] = 'Restauracija naslovne stranice';
$string['frontpageroles'] = 'Uloge na naslovnoj stranici';
$string['frontpagesettings'] = 'Podešavanja naslovne stranice';
$string['fullnamedisplay'] = 'Format punog imena';
$string['fullnamedisplayprivate'] = 'Puno ime - privatno';
$string['gdrecommended'] = 'GD ekstenzija se koristi za konverziju slika; neke opcije, kao što su slike korisnika na stranici sa profilom neće biti dostupne ukoliko ova ekstenzija nedostaje.';
$string['gdrequired'] = 'Moodle sada zahtjeva GD ekstenziju za konverziju slika';
$string['generalsettings'] = 'Opća podešavanja';
$string['geoipfile'] = 'GeoIP city datoteka';
$string['getremoteaddrconf'] = 'Izvor zabilježene IP adrese';
$string['globalswarning'] = '<p><strong>SIGURONOSNO UPOZORENjE!</strong></p><p> Kako bi mogao da funkcioniše ispravno, Moodle zahtijeva <br />da napravite neke izmjene u vašim trenutnim PHP podešavanjima.<p/><p><em>Morate</em> da postavite <code>register_globals=off</code>.</p><p>Ovo podešavanje možete izmjeniti tako što ćete urediti vašu <code>php.ini</code> datoteku, konfiguraciju Apache/IIS Web servera<br /> ili <code>.htaccess</code> datoteku.</p>';
$string['googlemapkey3'] = 'Google Maps API V3 ključ';
$string['googlemapkey3_help'] = 'Potrebno je da unesete unikatni ključ da bi ste korstili Google mape za vizuelnu prezentaciju i pretragu IP adresa. Besplatan ključ možete zatražiti na saljedećoj stranici <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Idi na prvi izraz koji nedostaje';
$string['gradebook'] = 'Evidencija ocjena';
$string['gradebookroles'] = 'Uloge koje mogu biti ocjenjivane';
$string['gradeexport'] = 'Primarni načini za prenos ocjena';
$string['gravatardefaulturl'] = 'URL zadane slike Gravatar-a.';
$string['gravatardefaulturl_help'] = 'Gravatar zahtjeva zadanu sliku kako bi je prikazao ako nije u mogućnosti da prikaže sliku korisnika. Unesite puni URL prema slici. Ako ostavite ovu postavku praznu, Moodle će pokušati da pronađe najprikladniju sliku za stranicu koju gledate. Napomena: Gravatar također posjeduje kodove koje mozežete koristiti <a href="https://en.gravatar.com/site/implement/images/#default-image">generate default images</a>';
$string['groupenrolmentkeypolicy'] = 'Pravila za lozinku za upis u grupu';
$string['groupenrolmentkeypolicy_desc'] = 'Omogućavanje ove opcije će prisiliti Moodle na provjeru lozinke za upis grupe prema važećima pravilima o lozinkama.';
$string['guestroleid'] = 'Uloga za gosta';
$string['guestroleid_help'] = 'Ova uloga se automatski dodjeljuje gostu. Ona se dodjeljuje privremeno i neupisanim korisnicima koji pristupaju kursu preko dodatka za upis gostiju.';
$string['helpadminseesall'] = 'Da li administratori vide sve događaje iz kalendara ili samo one koje se odnose na njih?';
$string['helpcalendarcustomexport'] = 'Omogući opciju za prilagođeni vremenski okvir u izvozima kalendara. Prethodno moraju biti omogućeni izvozi kalendara, kako bi ova opcija bila moguća.';
$string['helpexportlookahead'] = 'Koliko dana unaprijed će kalendar tražiti dešavanja prilikom izvoza, za opciju prilagođenog izvoza?';
$string['helpexportlookback'] = 'Koliko dana unazad će kalendar tražiti dešavanja prilikom izvoza, za opciju prilagođenog izvoza?';
$string['helpforcetimezone'] = 'Možete dozvoliti korisnicima da sami izaberu vremensku zonu, ili ih primorati da koriste onu koju ste Vi izabrali.';
$string['helpshowicalsource'] = 'Ako je ova opcija omogućena, naziv pretplate i link biće prikazani za iCal-uvezene događaje.';
$string['helpsitemaintenance'] = 'Za nadogradnje i ostale poslove';
$string['helpstartofweek'] = 'Kojim danom započinje sedmica u kalendaru?';
$string['helpupcominglookahead'] = 'Koliko dana unapred će kalendar tražiti predstojeća dešavanja?';
$string['helpupcomingmaxevents'] = 'Koliko se (maksimalno) narednih događaja prikazuje korisnicima?';
$string['helpweekenddays'] = 'Koji dani u sedmici se smatraju vikendom i prikazuju u drugoj boji?';
$string['hiddenuserfields'] = 'Sakrivanje korisničkih polja';
$string['hidefromall'] = 'Sakrij od svih korisnika';
$string['hidefromnone'] = 'Ne sakrivati';
$string['hidefromstudents'] = 'Sakrij od studenata';
$string['htmleditor'] = 'HTML editor';
$string['htmleditorsettings'] = 'Podešavanja HTML editora';
$string['htmlsettings'] = 'HTML podešavanja';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP sigurnost';
$string['hubs'] = 'Čvorišni serveri';
$string['iconvrecommended'] = 'Instaliranje opcione ICONV biblioteke je vrlo preporučljivo u cilju unapređivanja performansi sajta, pogotovo ako vaš sajt podržava jezike koji ne koriste latinično pismo.';
$string['iconvrequired'] = 'Potrebno je instalirati ICONV ekstenziju.';
$string['ignore'] = 'Ignoriši';
$string['includemoduleuserdata'] = 'Uključujući podatke korisnika modula';
$string['incompatibleblocks'] = 'Nekompatibilni blokovi';
$string['installhijacked'] = 'Instalacija mora biti završena sa originalne IP adrese.';
$string['installsessionerror'] = 'Nije moguće započeti PHP sesiju. Molimo Vas da provjerite da li Vaš Web pretraživač prihvata cookies.';
$string['intlrecommended'] = 'Intl ekstenzija se koristi za unapređenje internacionalne podrške, kao što je sortiranje prema pravilima lokalnog jezika.';
$string['invalidsection'] = 'Neispravna sekcija';
$string['invaliduserchangeme'] = 'Korisničko ime "changeme" je rezervisano -- ne možete kreirati nalog sa tim imenom.';
$string['ipblocked'] = 'Ovaj sajt trenutno nije dostupan.';
$string['ipblocker'] = 'Bloker IP adresa';
$string['ipblockersyntax'] = 'Jedan zapis po redu. Valjani zapisi su ili pune IP adrese (npr. <b>192.168.10.1</b>), koje identificiraju pojedinačni server; ili djelimične adrese (npr. <b>192.168.</b>), koje označavaju sve računare čija IP adresa počinje tim brojevima; ili CIDR notaciju (npr. <b>231.54.211.0/20</b>); ili rang IP adresa (npr. <b>231.3.56.10-20</b>). Slovima napisane domene (npr. \'example.com\') nisu podržane. Prazne linije će biti zanemarene.';
$string['iplookup'] = 'Traženje IP adrese';
$string['iplookupgeoplugin'] = '<a href="http://www.geoplugin.com">geoPlugin</a> servis se trenutno koristi za pronalaženje geografskih informacija. Za preciznije rezultate predlažemo vam da instalirate lokalnu kopiju MaxMind GeoLite baze podataka.';
$string['iplookupinfo'] = 'Kako bi locirao IP adresu Moodle standardno koristi besplatan online NetGeo (The Internet Geographic Database) server. Nažalost, ova baza podatake se više ne održava pa se može desiti da dobijete <em>krajnje pogrešne</em> podatake. Preporučuje se da instalirate lokalnu kopiju besplatne GeoLite City baze podataka kompanije MaxMind.<br /> Pozicija IP adrese se prikazuje na jednostavnoj mapi ili korištenjem Google Maps. Napomena: da biste omogućili interaktivne mape neophodno je da imate Google nalog kao i da se prijavite za besplatan Google Maps API ključ.';
$string['iplookupmaxmindnote'] = 'Ovaj proizvod uključuje GeoLite podatke kreirane od strane MaxMind, koji je dostupan na <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Zadržati velika i mala slova oznaka (tagova)';
$string['lang'] = 'Zadani jezik';
$string['langcache'] = 'Spremanje jezičkog menija';
$string['langcache_desc'] = 'Spremi jezički meni. Ako je ovo podešavanje omogućeno, spisak dostupnih prevoda se sprema. Cache memorija se automatski osvježava kada instalirate ili obrišete jezički pakete pomoću ugrađenog alata za upravljanje jezičkim paketima. Ako ručno instalirate novi paket, morate da upotrebite naredbu "Obriši cijeli keš" kako biste osvježili spremljeni popis jezičkih paketa.';
$string['langlist'] = 'Jezici na jezičkom meniju';
$string['langmenu'] = 'Prikaz jezičkog menija';
$string['langpackwillbeupdated'] = 'Napomena: U toku nadogradnje Moodle će pokušati da ažurira vaše jezičke pakete.';
$string['langstringcache'] = 'Spremi sve jezičke stringove';
$string['languagesettings'] = 'Jezička podešavanja';
$string['latexpreamble'] = 'LaTeX preambula';
$string['latexsettings'] = 'Podešavanja LaTeX renderovanja';
$string['latinexcelexport'] = 'Excel kodiranje';
$string['legacyfilesaddallowed'] = 'Dozvoli dodavanje nasleđenim datotekama';
$string['legacyfilesaddallowed_help'] = 'Ako kurs ima stare naslijeđene datoteke, dozvolite da im budu dodate nove datoteke i direktorijumi.';
$string['legacyfilesinnewcourses'] = 'Naslijeđene datoteke kursa u novom kursu';
$string['legacyfilesinnewcourses_help'] = 'Kao zadana vrijednost, podešeno je da nasljeđene datoteke kursa budu dostupne samo u starim kursevime koji su nadograđeni na Moodle 2.0 verziju. Imajte na umu da pojedina svojstva, poput kreiranje i restauriranje rezervne kopije pojedinačnih aktivnosti nisu kompatibilni sa ovim podešavanjima.';
$string['licensesettings'] = 'Podešavanja licence';
$string['linkadmincategories'] = 'Prikaži administratorske kategorije kao linkove';
$string['linkadmincategories_help'] = 'Ako je ovo podešavanje omogućeno, kategorije, unutar administratorskog bloka za podešavanja, biće prikazane kao linkovi i povezane sa stranicama  odgovarajućih administratorskih kategorija.';
$string['loading'] = 'Učitavanje';
$string['localetext'] = 'Lokalni tekst na nivou sajta';
$string['localstringcustomization'] = 'Prilagođavanje stringova lokala';
$string['location'] = 'Lokacija';
$string['locationsettings'] = 'Podešavanja lokacije';
$string['locked'] = 'Zaključano';
$string['lockoutduration'] = 'Period u kom je nalog zaključan';
$string['lockoutduration_desc'] = 'Zaključani nalog se automatski otključava nakon što istekne ovaj vremenski period';
$string['lockoutemailbody'] = 'Vaš nalog sa korisničkim imenom {$a->username} na sajtu \'{$a->sitename}\' je zaključan nakon višestrukih neispravnih pokušaja prijave na sistem. Da biste otključali nalog odmah idite na sledeću adresu {$a->link} U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača. Ukoliko vam je potrebna tehnička pomoć, molimo vas da kontaktirate administratora, {$a->admin}';
$string['lockoutemailsubject'] = 'Vaš nalog na sajtu {$a} je zaključan';
$string['lockouterrorunlock'] = 'Dobavljena je neispravna informacija za otključavanje naloga.';
$string['lockoutthreshold'] = 'Prag zaključavanja naloga';
$string['lockoutthreshold_desc'] = 'Izaberite broj neuspješnih pokušaja prijave na sistem koji će dovesti do zaključavanja naloga. Ova funkcija može biti zloupotrebljena u napadima uskraćivanjem usluga (DoS - denial of service).';
$string['lockoutwindow'] = 'Vrijeme praćenja za zaključavanje naloga';
$string['lockoutwindow_desc'] = 'Vrijeme praćenja za prag zaključavanja – ukoliko nema neuspješnih pokušaja prijave na sistem brojač praga zaključavanja se resetuje nakon ovog vremenskog perioda.';
$string['log'] = 'Zapisi o aktivnostima';
$string['logguests'] = 'Bilježi pristupe gostiju';
$string['logguests_help'] = 'Ovo podešavanje omogućava bilježenje aktivnosti od strane gostiju, kao i korisnika koji nisu prijavljeni na sistem. Ako Vaš sajt ima veliki broj korisnika možda ćete željeti da isključite ovo podešavanje zbog boljih performansi. Preporučljivo je da ovo podešavanje držite uključeno na produkcionim sajtovima.';
$string['loginhttps'] = 'Koristiti HTTPS za pristupe sistemu';
$string['loginpageautofocus'] = 'Obrazac sa autofokusirajućim poljima na stranici za prijavljivanje';
$string['loginpageautofocus_help'] = 'Uključivanjem ove opcije povećava se upotrebljivost stranice za prijavljivanje, ali automatski fokusirajuća polja mogu predstavljati problem pristupačnosti svim korisnicima, naročito onima sa posebnim potrebama.';
$string['loginpasswordautocomplete'] = 'Spriječi automatsko popunjavanje lozinke na obrascu za prijavu na sistem.';
$string['loginpasswordautocomplete_help'] = 'Ukoliko je ovo podešavanje isključeno korisnici će moći da sačuvaju lozinku u svom web pretraživaču. Ako je podešavanje uključeno to će za posljedicu imati da Vaš sajt više neće slijediti XHTML striktna pravila za provjeru ispravnosti.';
$string['loglifetime'] = 'Čuvaj zapise o aktivnostima za posljednjih';
$string['longtimewarning'] = '<b>Molimo vas da uzmete u obzir da ovaj proces može potrajati</b>';
$string['maintenancemode'] = 'U režimu održavanja';
$string['maintenancemodeisscheduled'] = 'Sajt se prebacuje u režim održavanja za {$a} minut/a';
$string['maintfileopenerror'] = 'Greška pri otvaranju datoteka za održavanje!';
$string['maintinprogress'] = 'Održavanje je u toku...';
$string['manageformats'] = 'Upravljaj formatima kursa';
$string['manageformatsgotosettings'] = 'Zadani format može se promjenit u {$a}';
$string['managelang'] = '<b>Upravljanje</b>';
$string['managelicenses'] = 'Upravljanje licencama';
$string['manageqbehaviours'] = 'Upravljanje ponašanjima pitanja';
$string['manageqtypes'] = 'Upravljanje tipovima pitanja';
$string['maturity100'] = 'Beta verzija';
$string['maturity150'] = 'RC (Release candidate) verzija';
$string['maturity200'] = 'Stabilna verzija';
$string['maturity50'] = 'Alfa verzija';
$string['maturityallowunstable'] = 'Savjet: Možda ćete željeti da pokrenete ovu skriptu sa opcijom --allow-unstable option';
$string['maturitycoreinfo'] = 'Vaš sajt trenutno pokreće nestabilni "{$a}" razvojni kod';
$string['maturitycorewarning'] = 'Instalirati ćete ili nadograditi Moodle na verziju označenu kao "{$a}" koja se još ne smatra pogodnom za produkcioni sajt. Molimo provjerite da li stvarno to hoćete i da li koristite ispravnu provjeru Moodle izvornog koda.';
$string['maxbytes'] = 'Maksimalna veličina postavljene datoteke';
$string['maxconsecutiveidentchars'] = 'Redoslijedni identični karakteri';
$string['maxeditingtime'] = 'Maksimalno vrijeme za uređivanje poruka';
$string['maxusersperpage'] = 'Maksimalan broj korisnika po stranici';
$string['mbstringrecommended'] = 'Instaliranje opcione MBSTRING biblioteke je vrlo preporučljivo zbog unapređivanja performansi sajta, pogotovo ako vaš sajt podržava jezike koji ne koriste latinično pismo.';
$string['mediapluginavi'] = 'Omogući .avi filter';
$string['mediapluginflv'] = 'Omogući .flv filter';
$string['mediapluginimg'] = 'Omogući automatsko umetanje linkovanih slika';
$string['mediapluginmov'] = 'Omogući .mov filter';
$string['mediapluginmp3'] = 'Omogući .mp3 filter';
$string['mediapluginmpg'] = 'Omogući .mpg filter';
$string['mediapluginogg'] = 'Omogući .ogg filter';
$string['mediapluginogv'] = 'Omogući .ogv filter';
$string['mediapluginram'] = 'Omogući .ram filter';
$string['mediapluginrm'] = 'Omogući .rm filter';
$string['mediapluginrpm'] = 'Omogući .rpm filter';
$string['mediapluginswf'] = 'Omogući .swf filter';
$string['mediapluginswfnote'] = 'Kao zadanu mjeru sigurnosti, običnim korisnicima ne treba dozvoliti da ubacuju swf flash datoteke.';
$string['mediapluginwmv'] = 'Omogućiti .wmv filter';
$string['mediapluginyoutube'] = 'Omogući filter za YouTube linkove';
$string['messaging'] = 'Omogući sistem za razmjenu poruka';
$string['messagingallowemailoverride'] = 'Izmjena e-mail adrese za slanje obavještenja';
$string['messagingdeletereadnotificationsdelay'] = 'Obriši obavještenje o pročitanim porukama';
$string['messaginghidereadnotifications'] = 'Sakrij obavještenje o pročitanim porukama';
$string['minpassworddigits'] = 'Brojevi';
$string['minpasswordlength'] = 'Dužina lozinke';
$string['minpasswordlower'] = 'Mala slova';
$string['minpasswordnonalphanum'] = 'Ne-alfanumerički karakteri';
$string['minpasswordupper'] = 'Velika slova';
$string['misc'] = 'Razno';
$string['mnetrestore_extusers'] = '<strong>Napomena:</strong> Ova rezervna kopija sadrži udaljene korisničke račune iz odgovarajuće Moodle mreže. Ti računi će tokom ovog procesa takođe biti restaurirani.';
$string['mnetrestore_extusers_admin'] = '<strong>Napomena:</strong> Izgleda da je ova datoteka rezervne kopije kreirana na nekoj drugoj Moodle instalaciji i da sadrži korisničke račune udaljene Moodle Mreže. Proces restauracije će pokušati da uskladi hostove Moodle Mreže za sve korisnike. One korisnici, za koje to ne uspije, automatski će biti prebačeni na internu provjeru identiteta (umjesto mnet). Zapis o restauraciji će Vas informisati o tome.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Napomena:</strong> Ova rezervna kopija očigledno potiče sa neke druge Moodle instalacije i sadrži korisničke račune udaljene Moodle Mreže koji se možda neće ispravno restaurirati. Ova operacija nije podržana. Ako ste sigurni da je arhiva kreirana na ovoj Moodle instalaciji, ili možete da potvrdite da su svi potrebni hostovi u Vašoj Moodle mreži konfigurisani, možda ćete ipak željeti da pokušate restauraciju.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Napomena:</strong> Izgleda da je ova dadoteka rezervne kopije kreirana na nekoj drugoj Moodle instalaciji i da sadrži korisničke račune udaljene Moodle Mreže. Nije Vam dozvoljeno da izvršavate ovaj tip restauriranja. Kontaktirajte administratora ovog sajta ili, alternativno, restaurirajte ovaj kurs bez bilo kakve informacije o korisnicima (moduli, datoteke...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Udaljeni korisnik Moodle Mreže {$a->username} (koji dolazi sa {$a->mnethosturl}) prebačen je na lokalnog {$a->auth} autorizovanog korisnika.';
$string['mobile'] = 'Mobitel';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Zadani izbornik za aktivnosti';
$string['modeditdefaults'] = 'Zadana vrijednosti za podešavanja aktivnosti';
$string['modeditingmenu'] = 'Meniji za uređivanje aktivnosti';
$string['modeditingmenu_desc'] = 'Ako je ova opcija omogućena mnoge od ikona za uređivanje aktivnosti prikazanih kad se pregleda kurs sa uključenim uređivanjem biće prikazane u okviru padajućeg menija. Ovo redukuje sadržaj na ekranu pri uređivanju kursa sakrivajući ikone dok ne postanu potrebne.';
$string['modsettings'] = 'Upravljanje aktivnostima';
$string['modulesecurity'] = 'Sigurnost modula';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Insistirati na staroj višejezičkoj sintaksi: &lt;span&gt; bez class="multilang" i &lt;lang&gt;';
$string['mustenablestats'] = 'Statistika još nije omogućena na ovom sajtu.';
$string['mycoursesperpage'] = 'Broj kurseva';
$string['mydashboard'] = 'Zadana kontrolna tabla sistema';
$string['mymoodle'] = 'Moj Moodle';
$string['mymoodleredirect'] = 'Obavezno korištenje opcije Moj Moodle za sve korisnike';
$string['mypage'] = 'Zadana \'Moja stranica\' stranica';
$string['mypagelocked'] = 'Zaključaj zadanu stranicu';
$string['myprofile'] = 'Zadana stranica profila';
$string['mysql416bypassed'] = 'Međutim, ako Vaš sajt koristi iso-8859-1 (latin) jezike, možete da nastavite s korištenjem Vaše trenutno instalirane MySQL verzije 4.1.12 (ili više).';
$string['mysql416required'] = 'MySQL 4.1.16 je minimalna verzija potrebna za Moodle 1.6 da bi se garantiralo dalje konvertovanje svih podataka u UTF-8.';
$string['navadduserpostslinks'] = 'Dodaj linkove za prikaz korisničkih poruka';
$string['navadduserpostslinks_help'] = 'Ako je ovo podešavanje omogućeno, svakom korisniku će u bloku za navigaciju biti dodata dva linka, jedan za prikaz diskusija koje je korisnik započeo i drugi za prikaz poruka koje je postavio na forumima širom sajta ili na određenim kursevima.';
$string['navcourselimit'] = 'Broj kurseva';
$string['navigationupgrade'] = 'Ova nadogradnja uvodi dva nova bloka za navigaciju koji će zamijeniti sljedeće blokove: Administracija, Kursevi, Aktivnosti i Učesnici. Ako ste prethodno dodijelili neka posebna ovlaštenja u ovim blokovima, trebalo bi da provjerite da li se sve događa onako kako želite.';
$string['navshowallcourses'] = 'Prikaži sve kurseve';
$string['navshowcategories'] = 'Prikaži kategorije kurseva';
$string['navshowfrontpagemods'] = 'Prikaži aktivnosti na naslovnoj stranici sajta';
$string['navshowfrontpagemods_help'] = 'Ako je ovo podešavanje omogućeno, aktivnosti na naslovnoj stranici sajta biće prikazane u bloku za navigacije pod stavkom \'Stranice sajta\'.';
$string['navshowfullcoursenames'] = 'Prikaži puno ime kurseva';
$string['navshowmycoursecategories'] = 'Prikaži kategorije mojih kurseva';
$string['navshowmycoursecategories_help'] = 'Ako je ovo podešavanje omogućeno, kursevi će biti prikazani korisnicima u bloku za navigaciju pod stavkom \'Moji kursevi\', kao grane odgovarajućih kategorija.';
$string['navsortmycoursessort'] = 'Razvrstaj moje kurseve';
$string['navsortmycoursessort_help'] = 'Određuje koliko će kurseva biti prikazano unutar \'Moji kursevi\' navigacione grane. Kao zadano, \'sortorder\' će biti korišteno.';
$string['neverdeleteruns'] = 'Nikada ne brisati pokretanja';
$string['nobookmarksforuser'] = 'Nemate postavljenih obilježivača.';
$string['nodatabase'] = 'Nema baze podataka';
$string['nohttpsformobilewarning'] = 'Preporučuje se omogućavanje HTTPS protokola sa ispravnim certifikatom. Moodle će uvijek prvo pokušati da koristi sigurnu konekciju.';
$string['nomissingstrings'] = 'Nema nedostajućih izraza';
$string['nonewsettings'] = 'Nije dodano nijedno novo podešavanje tokom ovog ažuriranja.';
$string['nonexistentbookmark'] = 'Traženi obilježivač ne postoji.';
$string['noresults'] = 'Nema rezultata';
$string['noroles'] = 'Nema uloga';
$string['notifications'] = 'Obavještenja';
$string['notifyloginfailures'] = 'Poslati izvještaj o neuspješnim pristupima sistemu korisniku';
$string['notifyloginthreshold'] = 'Granična vrijednost za e-mail obavještenja';
$string['notloggedinroleid'] = 'Uloga za posjetioce';
$string['numberofmissingstrings'] = 'Broj nedostajućih izraza: {$a}';
$string['numberofstrings'] = 'Ukupan broj izraza: {$a->strings}<br />Nedostaje: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'Keširanje PHP koda operacije poboljšava performanse i snižava memorijske zahteve, OPcache dodatak je preporučen i u potpunosti podržan.';
$string['opensslrecommended'] = 'Instaliranje opcione OpenSSL biblioteke je preporučljivo -- ona omogućava korištenje funkcija za umrežavanje.';
$string['opentogoogle'] = 'Otvoren za Google';
$string['optionalmaintenancemessage'] = 'Opciona poruka u toku održavanja sistema';
$string['order1'] = 'Prvi';
$string['order2'] = 'Drugi';
$string['order3'] = 'Treći';
$string['order4'] = 'Četvrti';
$string['passwordpolicy'] = 'Pravilnik za kreiranje lozinke';
$string['passwordresettime'] = 'Maksimalno vreme za potvrdu zahteva za resetovanje lozinke.';
$string['pathconvert'] = 'Putanja <i>convert</i> binarne datoteke';
$string['pathdvips'] = 'Putanja <i>dvips</i> binarne datoteke';
$string['pathlatex'] = 'Putanja <i>latex</i> binarne datoteke';
$string['pathtoclam'] = 'clam AV putanja';
$string['pathtodot'] = 'Putanja do dot';
$string['pathtodot_help'] = 'Putanja do "dot". Vjerovatno, nešto poput /usr/bin/dot. Da biste mogli da generirate grafike iz DOT datoteka, morate imati instaliran dot izvršnu datoteku i podešenu ispravnu putanju do nje. Imajte na umu da se ovo koristi samo za tzv. "Profiling" (Development->Profiling) novu funkciju ugrađenu u Moodle, koja je u razvojnoj fazi.';
$string['pathtodu'] = 'Putanja do du alata';
$string['pathtopgdump'] = 'Putanja do pg_dump';
$string['pathtopgdumpdesc'] = 'Ovo je neophodno unijeti samo ako imate više od jednog pg_dumpa na svom sistemu (na primjer ako ste instalirali više od jedne verzije postgresqla)';
$string['pathtopgdumpinvalid'] = 'Putanja do pg_dump-a nije validna - ili je putanja pogrešna ili nije izvršiva';
$string['pathtopsql'] = 'Putanja do psql';
$string['pathtopsqldesc'] = 'Ovo je neophodno unijeti samo ako imate više od jednog psqla na svom sistemu (na primjer ako ste instalirali više od jedne verzije postgresqla)';
$string['pathtopsqlinvalid'] = 'Putanja do psql-a nije validna - ili je putanja pogrešna ili nije izvršiva';
$string['pcreunicodewarning'] = 'Strogo se preporučuje da koristite PCRE PHP ekstenziju koji je kompatibilna sa Unicode setom karaktera.';
$string['perfdebug'] = 'Informacije o izvršavanju';
$string['performance'] = 'Performanse';
$string['pgcluster'] = 'PostgreSQL klaster';
$string['pgclusterdescription'] = 'Parametar PostgreSQL verzije/klastera za operacije komandne linije. Ako imate samo jedan postgresql na svom sistemu ili niste sigurni šta ovo podešavanje predstavlja, ostavite polje prazno.';
$string['php50restricted'] = 'PHP 5.0.x ima više poznatih problema, molimo unapredite PHP na verzije 5.1.x ili instalirajte verziju 4.3.x odnosno 4.4.x';
$string['php533warning'] = 'Preporučuje se korištenje PHP 5.3.3 ili novije verzije';
$string['phpfloatproblem'] = 'Uočene je neočekivani problem u obradi PHP brojeva sa pokretnim zarezom - {$a}';
$string['pleaserefreshregistration'] = 'Vaš sajt je registrovan na moodle.org. Razmotrite mogućnost ažuriranja registracije, ukoliko je došlo do značajnih promjena od Vašeg posljednjeg ažuriranja, na {$a}';
$string['pleaseregister'] = 'Molimo registrujte Vaš sajt kako biste uklonili ovu poruku';
$string['plugin'] = 'Dodatak';
$string['plugins'] = 'Dodaci';
$string['pluginscheck'] = 'Provjera zavisnosti dodataka';
$string['pluginscheckfailed'] = 'Provjera zavisnosti nije uspjela za {$a->pluginslist}';
$string['pluginschecktodo'] = 'Morate riješiti sve zahtjeve dodataka prije nego što nastavite sa instalacijom ove verzije Moodle-a!';
$string['pluginsoverview'] = 'Pregled dodataka';
$string['pluginsoverviewsee'] = 'Za više informacija pogledajte stranicu <a href="{$a->url}">Pregled dodataka</a>.';
$string['profilecategory'] = 'Kategorija';
$string['profilecategoryname'] = 'Naziv kategorije (mora biti jedinstven)';
$string['profilecategorynamenotunique'] = 'Ovaj naziv kategorije već je u upotrebi';
$string['profilecommonsettings'] = 'Zajednička podešavanja';
$string['profileconfirmcategorydeletion'] = 'Postoje {$a}. polja u ovoj kategoriji koja mogu biti pomjerena u kategoriju iznad (ili ispod).<br />Da li želite da obrišete ovu kategoriju?';
$string['profileconfirmfielddeletion'] = 'Postoji {$a} korisničkih unosa za ovo polje koji trebaju biti obrisani.<br />Da li i dalje želite obrisati ovo polje?';
$string['profilecreatecategory'] = 'Kreiraj novu kategoriju profila';
$string['profilecreatefield'] = 'Kreiraj novo polje za profil:';
$string['profilecreatenewcategory'] = 'Kreiraj novu kategoriju';
$string['profilecreatenewfield'] = 'Kreiranje novog polja profila: &quot;{$a}&quot;';
$string['profiledefaultcategory'] = 'Ostala polja';
$string['profiledefaultchecked'] = 'Uključeno je zadano';
$string['profiledefaultdata'] = 'Zadana vrijednost';
$string['profiledeletecategory'] = 'Brisanje kategorije';
$string['profiledeletefield'] = 'Brisanje polja \'{$a}';
$string['profiledescription'] = 'Opis polja';
$string['profiledscript'] = 'Skripta je profilirana';
$string['profiledscriptview'] = 'Vidi informacije o profiliranju za ovu skriptu';
$string['profileeditcategory'] = 'Uređivanje kategorije: {$a}';
$string['profileeditfield'] = 'Uređivanje polja  profila: {$a}';
$string['profilefield'] = 'Polje profila';
$string['profilefieldcolumns'] = 'Kolone';
$string['profilefieldispassword'] = 'Da li je ovo polje za lozinku?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Za pretvaranje teksta u link, unesite URL koji sadrži $$, gdje će $$ biti zamijenjen tekstom. Na primjer, za pretvaranje Twitter ID-ja u link, upišite http://twitter.com/$$';
$string['profilefieldlinktarget'] = 'Adresa do koje vodi link';
$string['profilefieldmaxlength'] = 'Maksimalna dužina';
$string['profilefieldrows'] = 'Redova';
$string['profilefields'] = 'Polja profila korisnika';
$string['profilefieldsize'] = 'Veličina polja';
$string['profileforceunique'] = 'Da li podaci treba da budu jedinstveni?';
$string['profileinvaliddata'] = 'Neodgovarajuća vrijednost';
$string['profilelocked'] = 'Da li je ovo polje zaključano?';
$string['profilemenudefaultnotinoptions'] = 'Zadana vrijednost nije u popisu opcija.';
$string['profilemenunooptions'] = 'Bez opcija sa menijima';
$string['profilemenuoptions'] = 'Meni opcije (po jedna u liniji)';
$string['profilemenutoofewoptions'] = 'Morate ponuditi bar 2 mogućnosti';
$string['profilename'] = 'Naziv';
$string['profilenofieldsdefined'] = 'Nije definisano nijedno polje';
$string['profilerequired'] = 'Da li je ovo polje obavezno?';
$string['profileroles'] = 'Uloge vidljive u profilu';
$string['profilesforenrolledusersonly'] = 'Profili samo za korisnike upisane na kurs.';
$string['profileshortname'] = 'Skraćen naziv (mora biti jedinstven)';
$string['profileshortnamenotunique'] = 'Ovaj skraćen naziv se već koristi';
$string['profilesignup'] = 'Prikazati na stranici za prijavu?';
$string['profilespecificsettings'] = 'Specifična podešavanja';
$string['profilevisible'] = 'Kome je ovo polje vidljivo?';
$string['profilevisibleall'] = 'Vidljivo svima';
$string['profilevisible_help'] = '* Nije vidljivo - za lične podatke vidljive samo administratorima
* Vidljivo korisniku - za lične podatke vidljive samo administratorima i korisniku čiju su podaci
* Vidljivo svima';
$string['profilevisiblenone'] = 'Nije vidljivo';
$string['profilevisibleprivate'] = 'Vidljivo korisniku';
$string['profiling'] = 'Profilisanje';
$string['profilingallowall'] = 'Kontinuirano profilisanje';
$string['profilingallowall_help'] = 'Ako omogućite ovo podešavanje, onda, u bilo kom trenutku možete da koristite parametar PROFILEALL bilo gdje (PGC) kako biste omogućili profiliranje za sve izvršene skripte tokom trajanja Moodle sesije. Analogno tome, možete da koristite parametar PROFILEALLSTOP kako biste to zaustavili.';
$string['profilingallowme'] = 'Selektivno profiliranje';
$string['profilingallowme_help'] = 'Ako omogućite ovо podešavanje, onda, selektivno, možete da koristite parametar PROFILEME bilo gdje (PGC) i ta skripta će biti profilirana. Analogno tome, možete da koristite parametar DONTPROFILEME kako bi spriječili profiliranje.';
$string['profilingautofrec'] = 'Automatsko profiliranje';
$string['profilingautofrec_help'] = 'Konfiguriranjem ovog podešavanja, neki zahtjevi (nasumično odabrani, zasnovano na učestalosti određenoj kao 1 od XXX) biće odabrani i automatski profilirani, smještajući rezultate za dalju analizu. Imajte na umu da ovaj način profiliranja posmatra include/exclude podešavanja. Postavite vrijednost na 0 kako biste onemogućili automatsko profiliranje.';
$string['profilingenabled'] = 'Omogući profiliranje';
$string['profilingenabled_help'] = 'Ako omogućite ovu podešavanje, onda će profiliranje biti dostupno na ovom sajtu i moći ćete da odrediti njegovo ponašanje tako što ćete podesiti sljedeće opcije.';
$string['profilingexcluded'] = 'Isključi profiliranje';
$string['profilingexcluded_help'] = 'Popis URL adresa (odvojenih zarezima, apsolutnih, preskačući wwwroot, koje mogu biti pozvane) koje će biti izuzete od profiliranja definiranih u podešavanju \'Profiliraj ove\'.';
$string['profilingincluded'] = 'Profiliraj ove';
$string['profilingincluded_help'] = 'Popis URL adresa (odvojenih zarezima, apsolutnih, preskačući wwwroot, koje mogu biti pozvane) koje će biti automatski profilirane. Primjer:/index.php, /course/view.php. Također je prihvatljiva upotreba * džoker oznaka na bilo kojoj poziciji. Primjer: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Nastavi sa profiliranjem';
$string['profilinglifetime_help'] = 'Odredite koliko dugo želite da čuvate informacije o prethodnim pokretanjima profiliranja. Starije će periodično biti odstranjivana. Imajte u vidu da ovo isključuje bilo koje pokretanje profiliranja označeno kao "referentno pokretanje".';
$string['protectusernames'] = 'Zaštititi korisnička imena';
$string['proxybypass'] = 'Hostovi za zaobilaženje Proxy servera';
$string['proxyhost'] = 'Proxy domaćin';
$string['proxypassword'] = 'Lozinka za proxy server';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Tip Proxy servera';
$string['proxyuser'] = 'Korisničko ime za Proxy';
$string['purgecaches'] = 'Obriši sve zapise iz caches memorije';
$string['purgecachesconfirm'] = 'Moodle može da čuva u caches memoriji teme, Javascript, jezičke stringove, filtrirani tekst, RSS izvore vijesti i mnoge druge obrađene podataka. Brisanje caches memorije će obrisati te privremeno sačuvane podatke sa servera i time primorati Web pretraživač da ponovo preuzme podatke, tako da možete biti sigurni da gledate najnovije vrijednosti koje je proizveo trenutni kôd. Nema nikakve opasnosti u brisanju caches memorije, ali Vaš sajt može, na trenutak, biti sporiji, sve dok server i klijentski program ne generiraju nove informacije i ponovo ih smjeste u caches.';
$string['purgecachesfinished'] = 'Svi zapisi iz caches memorije su obrisani';
$string['qtyperqpwillberemoved'] = 'Tokom nadogradnje, RQP tipovi pitanja biće uklonjeni. Nećete koristiti ovaj tip pitanja, tako da ne očekujte probleme u vezi s tim.';
$string['qtyperqpwillberemovedanyway'] = 'Tokom nadogradnje biće uklonjen RQP tip pitanja. Kako imate neka RQP pitanja u svojoj bazi, preporučuje se da ponovo instalirate dodatak sa http://moodle.org/mod/data/view.php?d=13&amp;rid=797 prije nastavka nadogradnje da bi ona mogla i dalje nesmetano da se koriste.';
$string['quarantinedir'] = 'Karantinski direktorij';
$string['question'] = 'Pitanje';
$string['questionbehaviours'] = 'Ponašanja pitanja';
$string['questioncwqpfscheck'] = 'Jedno ili više \'nasumično izabranih\' pitanja u kvizu podešeno je da vrši odabir pitanja i iz kategorija dijeljenih i iz kategorija nedijeljenih pitanja. Detaljniji izvještaj pogledajte <a href="{$a->reporturl}">ovde</a>, ili potražite dodatne informacije u okviru stranica Moodle <a href="{$a->docsurl}">dokumentacije</a>.';
$string['questioncwqpfsok'] = 'Uredu. Nema \'nasumično izabranih\' pitanja u Vašim kvizovima koja su podešena tako da vrše odabir pitanja i iz kategorija dijeljenih i iz kategorija nedijeljenih pitanja.';
$string['questiontype'] = 'Tip pitanja';
$string['questiontypes'] = 'Tipovi pitanja';
$string['recaptchaprivatekey'] = 'ReCAPTCHA privatni ključ';
$string['recaptchapublickey'] = 'ReCAPTCHA javni ključ';
$string['register'] = 'Registrujte svoj sajt';
$string['registermoodleorg'] = 'Kada registrujete svoj sajt na {$a}';
$string['registermoodleorgli1'] = 'Bićete dodani na popis e-mail adresa za slanje važnih obavještenja kao što su sigurnosna upozorenja i informacije o novim izdanjima Moodlea.';
$string['registermoodleorgli2'] = 'Statistički podaci o vašem sajtu biće dodati statistici svijetske Moodle zajednice - {$a}.';
$string['registermoodleorgli3'] = 'Vaš sajt će takođe biti registrovan na Moodle.org Open Community Hub ({$a}), što omogućava korisnicima, sa ovlaštenjem za objavljivanje kurseva (standardno, to su samo korisnici sa ulogom menadžera) da objavljuju kurseve na MOOCH.';
$string['registerwithmoodleorg'] = 'Registracija na sajtu Moodle.org';
$string['registration'] = 'Registracija';
$string['registration_help'] = 'Registracija na Moodle.org se preporučuje iz više razloga - zbog dobijanja sigurnosnih upozorenja e-mailom, kako biste doprinijeli kako rastu Moodle zajednice, tako i preciznijoj statistici, kao i zbog mogućnosti dijeljenja kurseva na MOOCH.';
$string['registrationwarning'] = 'Vaš sajt još nije registrovan';
$string['releasenoteslink'] = 'Za informacije o ovoj verziji Moodlea, molimo pogledajte online <a target="_new" href="{$a}">Bilješke o izdanju</a>';
$string['rememberusername'] = 'Zapamti korisničko ime';
$string['rememberusername_desc'] = 'Omogućite ovu opciju ako želite da sačuvate permanentne "cookies" sa korisničkim imenima prilikom prijavljivanja korisnika na sistem. Permanentni "cookies" mogu da predstavljaju problem privatnosti ako se koriste bez dozvole.';
$string['reportsmanage'] = 'Upravljanje izvještajima';
$string['requestcategoryselection'] = 'Omogući izbor kategorija';
$string['requiredentrieschanged'] = 'strong>VAŽNO - OBVEZNO PROČITAJTE<br/>(Ovo upozorenje će biti prikazano samo pri ovoj nadogradnji)</strong><br/>Zbog rješavanja bug-a, ponašanje aktivnosti baze podataka koje koriste postavke \'Required entries\' i \'Required entries before viewing settings\' će biti promijenjene. Opširnije pojašnjenje možete pročitati na <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">forumu modula baze podataka</a>. Očekivano ponašanje i vrijednosti navedene postavke pogledajte na pripadajućoj stranici na <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>. <br/><br/>Ova promjena utiče na slijedeće baze podataka na vašem sistemu: (Sačuvajte sada ovaj popis i pregledajte te baze podataka nakon završetka nadogradnje kako bi se uvjerili da navedene aktivnosti i dalje rade na način na koji su predavači koji ih koriste i namjenili.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Zahtijevaj opis aktivnosti';
$string['requires'] = 'Neophodno';
$string['restorernewroleid'] = 'Uloga restauratora na kursevima';
$string['restorernewroleid_help'] = 'Ako korisnik već nema dozvolu da upravlja nedavno restaurisanim kursom, automatski će mu biti dodijeljena ova uloga i biće upisan na kurs ako je to potrebno. Izaberite "Ništa", ako ne želite da oni koji restauriraju kurseve budu u mogućnosti da upravljaju svakim restaurisanim kursom.';
$string['reverseproxy'] = 'Reverzni proxy';
$string['riskconfig'] = 'Korisnik može promijeniti postavke i uticati na funkcioniranje sajta';
$string['riskconfigshort'] = 'Konfiguracijski rizik';
$string['riskdataloss'] = 'Korisnici mogu uništiti veću količinu podataka ili informacija';
$string['riskdatalossshort'] = 'Rizik od gubitka podataka';
$string['riskmanagetrust'] = 'Korisnici bi mogli promjeniti postavke sigurnosti drugih korisnika';
$string['riskmanagetrustshort'] = 'Upravljanje dozvolama za pristup';
$string['riskpersonal'] = 'Korisnici bi mogli steći pristup privatnim informacijama drugih korisnika';
$string['riskpersonalshort'] = 'Rizik za privatnost';
$string['riskspam'] = 'Korisnici bi mogli slati neželjenu poštu korisnicima sajta ili drugim licima';
$string['riskspamshort'] = 'Rizik od neželjene pošte';
$string['riskxss'] = 'Korisnici bi mogli dodati datoteke i tekstove koji dozvoljavaju skriptovanje u okviru čitavog sajta (XSS)';
$string['riskxssshort'] = 'XSS rizik';
$string['roleswithexceptions'] = '{$a->roles}, sa {$a->exceptions}';
$string['rssglobaldisabled'] = 'Isključi na nivou servera';
$string['runclamavonupload'] = 'Koristiti clam AV za sve postavljene datoteke';
$string['save'] = 'Sačuvaj';
$string['savechanges'] = 'Sačuvaj promjene';
$string['search'] = 'Pretraga';
$string['searchinsettings'] = 'Traži u podešavanjima';
$string['searchresults'] = 'Rezultati pretrage';
$string['sectionerror'] = 'Greška sekcije!';
$string['secureforms'] = 'Koristi dodatne sigurnosne mjere na obrascima';
$string['security'] = 'Sigurnost';
$string['selectdevice'] = 'Izaberi uređaj';
$string['selecttheme'] = 'Izaberi grafičku temu za uređaj {$a}';
$string['server'] = 'server';
$string['serverchecks'] = 'Provjera servera';
$string['serverlimit'] = 'Ograničenje servera';
$string['sessionautostartwarning'] = '<p>Otkrivena je ozbiljna greška pri konfiguraciji, obavijestite administratora servera</p><p> Za ispravan rad, administrator treba promijeniti podešavanja PHP-a.</p> <p><code>session.auto_start</code> mora biti postavljeno na <code>off</code>.</p><p> Ova se postavka mijenja uređivanjem datoteke <code>php.ini</code>, Apache/IIS <br />konfiguracijom ili u datoteci <code>.htaccess</code> na serveru.</p>';
$string['sessioncookie'] = 'Prefiks "cookie"';
$string['sessioncookiedomain'] = '"Cookie" domen';
$string['sessioncookiepath'] = '"Cookie" putanja';
$string['sessionhandling'] = 'Upravljanje sesijama';
$string['sessiontimeout'] = 'Vrijeme isteka sesije';
$string['settingfileuploads'] = 'Postavljanje datoteka je neophodno za normalno funkcioniranje, omogućite ga u podešavanjima PHP-a.';
$string['settingmemorylimit'] = 'Nedovoljna memorija, molimo podesite veću vrijednost memorijskog ograničenja u PHP podešavanjima.';
$string['settingsafemode'] = 'Moodle nije u potpunosti kompatibilan sa sigurnim načinom rada (safe mod), tražite od administratora da ga isključi. Rad Moodle-a u sigurnom načinu rada nije podržan, očekujte razne probleme ako to nastavite činiti.';
$string['showcommentscount'] = 'Prikaži broj komentara';
$string['showdetails'] = 'Prikaži detalje';
$string['showuseridentity'] = 'Prikaži identitet korisnika';
$string['showuseridentity_desc'] = 'Prilikom izbora ili pretrage korisnika, kada se prikazuje popis korisnika, ova polja se mogu prikazati pored njihovih imena i prezimena. Polja će se prikazati samo onim korisnicima koji imaju mogućnost moodle/site:viewuseridentity capability, standardno, predavačima i menadžerima. (Ova opcija najviše ima smisla ako izaberete jedno ili dva polja koja su u vašoj instituciji obavezna).';
$string['simplexmlrequired'] = 'Moodle zahtijeva instaliranje SimpleXML PHP ekstenzije.';
$string['sitemaintenance'] = 'Sajt je trenutno nedostupan zbog održavanja i radova.';
$string['sitemaintenancemode'] = 'Režim održavanja sistema';
$string['sitemaintenanceoff'] = 'Održavanje sistema je završeno i sajt je ponovo u normalnom režimu rada';
$string['sitemaintenanceon'] = 'Vaš sajt je trenutno u režimu održavanja (samo administratori mogu da pristupe sajtu)';
$string['sitemaintenanceoncli'] = 'Vaš sajt je trenutno u CLI režimu održavanja. Internet pristup nije dozvoljen.';
$string['sitemaintenancewarning'] = 'Vaš sajt je trenutno u režimu održavanja (samo administratori mogu da pristupe sajtu). Da bi ste vratili sajt u normalan režim rada, <a href="maintenance.php"> isključite režim održavanja</a>.';
$string['sitemaintenancewarning2'] = 'Vaš sajt je trenutno u režimu održavanja (samo administratori mogu da se prijave na sistem). Da biste vratili ovaj sajt u normalan režnim rada, <a href="{$a}">isključite režim održavanja</a>.';
$string['sitepolicies'] = 'Pravilnici o korištenju sajta';
$string['sitepolicy'] = 'URL pravila sajta';
$string['sitepolicyguest'] = 'URL adresa pravilnika o ponašanju na sajtu za goste';
$string['sitepolicyguest_help'] = 'Ako imate pravilnik o ponašanju na sajtu koji svi gosti moraju da pročitaju i prihvate, ovde možete navesti URL adresu istog. U suprotnom ostavite ovo polje prazno. Ovo podešavanje može sadržati bilo koju javno dostupnu URL adresu. Napomena: pristup neprijavljenim korisnicima može biti onemogućen korištenjem podešavanja forcelogin.';
$string['sitepolicy_help'] = 'Ukoliko imate posebna pravila i uputstva za korištenje sajta koja korisnici moraju da pročitaju i da ih prihvate onda navedite URL strane na kojoj se nalaze pravila. U suprotnom ostavite ovo polje prazno. URL strane može biti bilo koji - pogodno mjesto može biti i datoteka na samom sajtu tj. http://yoursite/file.php/1/policy.html';
$string['sitesectionhelp'] = 'Ukoliko je ova opcija izabrana, tematska sekcija će biti prikazana na naslovnoj stranici sajta.';
$string['slasharguments'] = 'Koristiti slash argumente';
$string['smartpix'] = '"Pametna" pretraga slika';
$string['soaprecommended'] = 'Instalacija opcione soap ekstenzije je korisna za Web servise i neke dodatne module za Moodle.';
$string['sort_fullname'] = 'Ime i prezime';
$string['sort_idnumber'] = 'ID broj';
$string['sort_shortname'] = 'Korisničko ime';
$string['sort_sortorder'] = 'Redoslijed razvrstavanja';
$string['spellengine'] = 'Sistem za provjeru pravopisa';
$string['spelllanguagelist'] = 'Popis jezika za provjeru pravopisa';
$string['splrequired'] = 'Moodle zahtijeva instaliranje SPL PHP ekstenzije.';
$string['stats'] = 'Statistika';
$string['statsfirstrun'] = 'Maksimalni interval procesiranja';
$string['statsmaxruntime'] = 'Maksimalno vrijeme izvršavanja';
$string['statsmoodleorg'] = 'statistika';
$string['statsruntimedays'] = 'Dana za obradu';
$string['statsruntimestart'] = 'Izvršavanje u';
$string['statsuserthreshold'] = 'Granična vrijednost korisnika';
$string['stickyblocks'] = 'Fiksirani blokovi';
$string['stickyblockscourseview'] = 'Stranica kursa';
$string['stickyblocksduplicatenotice'] = 'Ako je bilo koji blok koji ovdje dodate već prisutan na nekoj konkretnoj stranici, biće prikazan i njegov duplikat.<br />Jedino što se fiksirani blok neće moći mijenjati, a duplikat još uvijek hoće.';
$string['stickyblocksmymoodle'] = 'Moj Moodle';
$string['stickyblockspagetype'] = 'Vrsta stranice za konfigurisanje';
$string['strictformsrequired'] = 'Striktna provjera obaveznih polja';
$string['stripalltitletags'] = 'Ukloni HTML oznake sa svih imena aktivnosti';
$string['supportcontact'] = 'Kontakt za podršku';
$string['supportemail'] = 'E-mail za podršku';
$string['supportname'] = 'Ime za podršku';
$string['supportpage'] = 'Web stranica za podršku';
$string['suspenduser'] = 'Suspenduj korisnički račun';
$string['switchlang'] = 'Promijeni lang direktorij';
$string['systempaths'] = 'Promjene u gornjoj tabeli se automatski čuvaju.';
$string['tablenosave'] = 'Promjene u gornjoj tabeli se automatski čuvaju.';
$string['tablesnosave'] = 'Promjene u gornjim tabelama se automatski čuvaju.';
$string['tabselectedtofront'] = 'U tabelama sa tabovima, da li bi red sa trenutno odabranim tabom trebalo da bude stavljen u prvi plan';
$string['tabselectedtofronttext'] = 'Pomjeriti izabrani red na početak';
$string['testsiteupgradewarning'] = 'Trenutno koristite test sajt {$a}; da biste ga ispravno nadogradili, upotijrebite interfejs sa komandom linijom';
$string['themedesignermode'] = 'Režim za dizajniranje teme';
$string['themelist'] = 'Popis grafičkih tema';
$string['themenoselected'] = 'Nijedna grafička tema nije izabrana';
$string['themeresetcaches'] = 'Obriši teme iz caches memorije';
$string['themeselect'] = 'Promijeni grafičku temu';
$string['themeselector'] = 'Selektor grafičke teme';
$string['themesettings'] = 'Podešavanja grafičkih tema';
$string['therewereerrors'] = 'Bilo je grešaka u vašim podacima';
$string['thirdpartylibrary'] = 'biblioteka';
$string['thirdpartylibrarylocation'] = 'Lokacija';
$string['thirdpartylibs'] = 'Nezavisne biblioteke';
$string['timezone'] = 'Zadana vremenska zona';
$string['timezoneforced'] = 'Ovo je administrator sajta proglasio obaveznim';
$string['timezoneisforcedto'] = 'Obavezna upotreba za sve korisnike';
$string['timezonenotforced'] = 'Korisnici mogu odabrati vlastitu vremensku zonu';
$string['tokenizerrecommended'] = 'Preporučuje se instalacija opcionog PHP Tokenizer dodatka radi poboljšavanja funkcionalnosti za umrežavanje.';
$string['tools'] = 'Administratorski alati';
$string['toolsmanage'] = 'Upravljanje administratorskim alatima';
$string['unattendedoperation'] = 'Automatska instalacija';
$string['unbookmarkthispage'] = 'Ukloni obilježivač sa ove stranice';
$string['unicoderecommended'] = 'Preporučljivo je smještanje vaših podataka u Unikod (UTF-8) standard. Nove instalacije biće izvršene nad bazama koji kao zadani karakter-set imaju podešen Unikod. Ukoliko vršite nadogradnju, potrebno je pokrenuti UTF-8 proces migracije (pogledati Admin stranicu).';
$string['unicoderequired'] = 'Potrebno je da sve vaše podatke smještate u Unikod formatu (UTF-8). Nove instalacije moraju biti primijenjene u bazama podataka koje imaju osnovni karakterni set namješten na Unikod. Ukoliko vršite nadogradnju, potrebno je pokrenuti UTF-8 proces migracije (pogledati Admin stranicu).';
$string['uninstallplugin'] = 'Reinstaliraj';
$string['unlockaccount'] = 'Otključaj nalog';
$string['unsettheme'] = 'Ukloni grafičku temu';
$string['unsupported'] = 'Nije podržano';
$string['unsuspenduser'] = 'Aktivirajte korisnički račun';
$string['updateaccounts'] = 'Ažuriranje postojećih računa';
$string['updateautocheck'] = 'Automatski provjeri dostupnost novih verzija';
$string['updateautocheck_desc'] = 'Ako je ovo podešavanje omogućeno, vaš sajt će automatski provjeravati da li su dostupne nove verzije kako osnovnog Moodle paketa, tako i svih dodataka. Ako postoje dostupne nove verzije, biće poslato obavještenje e-mailom administratorima sajta.';
$string['updateautodeploy'] = 'Uključi automatsku distribuciju zakrpi';
$string['updateautodeploy_desc'] = 'Ako je omogućeno, omogučit će automatsko skidanje i instalaciju posljednjih zakrpi sa Moodle adminstratorske stranice. Napomena: da bi ovo uspjelo. server moda imati dozvolu (CHMODE) da piše po folderima u kojima se nalazi instalacija Moodla. Ovo također, može predstavljati sigurnosni rizik.';
$string['updateavailable'] = 'Dostupna je novija verzija Moodlea!';
$string['updateavailabledetailslink'] = 'Za više informacija pogledajte {$a->url}';
$string['updateavailableforplugin'] = 'Dostupne su novije verzije za neke od vaših dodataka!';
$string['updateavailableinstall'] = 'Instaliraj ovu nadogradnju';
$string['updateavailable_moreinfo'] = 'Više informacija...';
$string['updateavailablenot'] = 'Koristite posljednju verziju Moodle-a';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Verzija {$a}';
$string['updatecomponent'] = 'Ažuriraj komponentu';
$string['updateminmaturity'] = 'Potrebna zrelost kôda';
$string['updateminmaturity_desc'] = 'Pošalji obavještenje o novim verzijama samo ako dostupni kôd ima, najmanje, izabrani nivo zrelosti. Nove verzije dodataka koje ne objavljuju zrelost svog kôda uvijek se prijavljuju, bez obzira na ovo podešavanje.';
$string['updatenotificationfooter'] = 'Vaš Moodle sajt {$a->siteurl} je konfigurisan da automatski provjerava da li su dostupne nove verzije programa. Ovu poruku ste dobili kao administrator sajta. Automatsku provjeru novih verzija možete da onemogućite u sekciji \'Administracija sajta\' unutar bloka \'Podešavanja\'. Način slanja ove poruke možete da prilagodite pomoću svog ličnog podešavanja za \'Razmjena poruka\' u sekciji \'Podešavanja mog profila\'.';
$string['updatenotifications'] = 'Obavještenja o novim verzijama';
$string['updatenotificationsubject'] = 'Dostupne su nove verzije za vaš Moodle sajt';
$string['updatenotifybuilds'] = 'Obavijesti o novim podverzijama';
$string['updatenotifybuilds_desc'] = 'Ako je ovo podešavanje omogućeno, onda će obavještenje o novoj verziji Moodle paketa biti poslano i u situacijama kada je dostupna nova podverzija za tekuću verziju programa. Podverzije (builds) predstavljaju kontinuirana poboljšanja date verzije Moodlea. Generalno, ova obavještenja se objavljuju svake sedmice. Ako je ovo podešavanje onemogućeno, obavještenje o novoj verziji će biti poslano samo kada se pojavi nova, unaprijeđena verzija. Ovo podešavanje ne utiče na provjeru novih verzija dodataka.';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 sadrži nekoliko sigurnosnih popravki za korisničke lozinke i rezervne kopije podataka kako bi se zaštitili korisnički podaci na vašem sajtu. Zbog toga neka od vaših podešavanja i ovlaštenja vezana za rezervne kopije podataka mogu biti promijenjena.<br /> Pogledajte <a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 release notes</a> za više detalja.</p>';
$string['upgrade197noticesubject'] = 'Sigurnosno obavještenje o nadogradnji Moodle 1.9.7 verzije';
$string['upgrade197salt'] = 'Da biste smanjili rizik od krađe šifri, strogo se preporučuje da podesite tzv. password salt.<br />Pogledajte <a href="{$a}" target="_blank">password salting documentation</a> za detaljnije informacije.';
$string['upgradeerror'] = 'Nepoznata greška u toku nadogradnje {$a->plugin} na verziju {$a->version}. Nije moguće nastaviti.';
$string['upgradeforumread'] = 'Moodle verziji 1.5 je dodana nova opcija za praćenje pročitanih/nepročitanih poruka u forumima. <br />Da biste mogli da koristite ovu opciju morate da <a href={$a}>ažurirate svoje tabele</a>.';
$string['upgradeforumreadinfo'] = 'Moodle verziji 1.5 je dodana nova opcija za praćenje pročitanih/nepročitanih poruka u forumima. Da biste mogli da koristite ovu opciju morate da ažurirate svoje tabele zajedno sa svim informacijama za postojeće poruke na forumima. U zavisnosti od veličine Vašeg sajta takva akcija može potrajati (i do nekoliko sati) i može opteretiti bazu podataka, tako da je najbolje da to obavite kada je server manje opterećen. Ipak, Vaš sajt će u toku osvežavanja biti u funkciji i korisnici neće biti time pogođeni. Kada jednom započnete ovaj proces pustite da se završi (ostavite otvoren prozor svog Web pretraživača). Ukoliko, ipak, zatvorite prozor: ne brinite, moći ćete ponovo da startujte proces.<br /><br />Da li želite da započnete proces ažuriranja?';
$string['upgradelogs'] = 'Zbog potpune fukcionalnosti, vaši stari zapisi o aktivnostima treba da budu nadograđeni. <a href="{$a}">Više informacija</a>';
$string['upgradelogsinfo'] = 'Nedavno su napravljene određene promjene u pogledu čuvanja izvještaja o aktivnostima. Da biste mogli da vidite sve svoje stare zapise, redom po aktivnostima, potrebno je da ih nadogradite. U zavisnosti od Vašeg sajta, to može da potraje (i do nekoliko sati) i da optereti bazu podataka za velike sajtove. Jednom kada započnete ovaj proces, potrebno je da ga pustite da se završi (tako što ćete prozor web pretraživača ostaviti otvoren). Ne brinite - dok se zapisi o aktivnostima nadograđuju, vaš sajt će i dalje raditi bez problema za ostale korisnike,.<br /><br />Da li želite sada da nadogradite zapise o aktivnostima?';
$string['upgradepluginsfirst'] = 'Morate da preuzmete i ručno instalirate nove verzije';
$string['upgradepluginsinfo'] = 'Nadogradnja dodataka';
$string['upgradepluginsinfo_help'] = 'Dostupne su nove verzije za neke od vaših dodataka. Moodle ih još uvijek ne ažurira automatski. Morate da preuzmete novu verziju dodatka i ručno je instalirate na svom serveru.';
$string['upgradesettings'] = 'Nova podešavanja';
$string['upgradesettingsintro'] = 'Dole navedena podešavanja su dodana tokom posljednje nadogradnje Moodlea. Napravite sve potrebne promjene zadanih vrijednosti i kliknite na dugme "Sačuvaj promjene" na dnu ove stranice.';
$string['upgradestalefiles'] = 'Otkrivene su izmiješane verzije Moodle pa nadogradnja ne može da se nastavi';
$string['upgradestalefilesinfo'] = 'Proces nadogradnje Moodlea je zaustavljen zato što su u Moodle direktoriju otkrivene PHP skripte iz najmanje dvije različite verzije Moodlea, što kasnije može da napravi velike probleme. Kako biste nastavili proces nadogradnje, morate prvo da osigurate da u Moodle direktoriju budu datoteke samo jedne verzije Moodlea. Da biste očistili Moodle direktoriju i riješili ovaj problem uradite sljedeće:
promjenite naziv tekućeg Moodle direktorija u "moodle_old" * kreirajte novi Moodle direktorij koji sadrži samo datoteke iz standardnog Moodle paketa, ili iz Moodle CVS odnosno GIT repozitorijima. * prebacite originalnu config.php datoteku iz starog, moodle_old, u novi Moodle direktorij. Kada završite opisanu proceduru, osvježite ovu stranicu kako biste nastavili proces nadogradnju Moodlea. Ovo upozorenje je često posljedica raspakivanja standardnog Moodle paketa u postojeći direktorij, u kojem se nalazi prethodna verzija Moodlea. Iako ovaj postupak ne stvara probleme prilikom manjih nadogradnji, nikako se ne savjetuje kada se rade velike nadogradnje Moodlea. Upozorenje, također, može da bude posljedica nepotpune provjere ili nadogradnje iz CVS odnosno GIT repozitorija, u kom slučaju ćete morati samo da sačekati da se operacija završi, eventualno pokrenete odgovarajuću komandu za čišćenje i ponovo pokušate operaciju. Više informacija možete naći u dokumentaciji o nadogradnji na <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Nadogradi Moodle bazu podataka sada';
$string['upgradesure'] = 'Vaše Moodle datoteke su izmjenjene, i namjeravate da automatski nadogradite svoj server na ovu verziju: <br /><br /> <strong>{$a}</strong> <br /><br /> Jednom kada ovo uradite ne možete se vratiti nazad. <br /><br /> Da li ste sigurni da želite da nadogradite server na ovu verziju?';
$string['upgradetimedout'] = 'Isteklo je vrijeme za ažuriranje, molimo započnite proces ažuriranja iznova.';
$string['upgradingdata'] = 'Ažuriranje podataka je u toku';
$string['upgradinglogs'] = 'Nadogradnja zapisa o aktivnostima je u toku';
$string['upgradingversion'] = 'Ažuriraj na novu verziju';
$string['upwards'] = 'nagore';
$string['useblogassociations'] = 'Omogući povezivanje';
$string['useexternalyui'] = 'Koristi YUI biblioteke na mreži';
$string['user'] = 'Korisnik';
$string['userbulk'] = 'Masovne akcije nad korisnicima';
$string['userlist'] = 'Pregled popisa korisnika';
$string['userpolicies'] = 'Pravila za korisnike';
$string['userpreference'] = 'Korisnička podešavanja';
$string['userquota'] = 'Korisnička kvota';
$string['users'] = 'Korisnici';
$string['usesitenameforsitepages'] = 'Koristite naziv sajta za stranice sajta';
$string['usetags'] = 'Omogući oznake (tagove)';
$string['validateerror'] = 'Ova vrijednost nije valjana:';
$string['verifychangedemail'] = 'Ograniči domene prilikom promijene e-mail adrese';
$string['warningcurrentsetting'] = 'Neispravna trenutna vrijednost: {$a}';
$string['warningiconvbuggy'] = 'Vaša verzija iconv biblioteke ne podržava //IGNORE modifikator. Trebalo bi da instalirate ekstenziju mbstring koja može, umesto iconv biblioteke, da se koristi za čišćenje stringova koji sadrže neispravne UTF-8 karaktere.';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Popuni sljedeće opcije ukoliko Moodle server ne može da pristupi Internetu direktno. Pristup Internetu je neophodan za preuzimanje podataka o okruženju, jezičkih paketa, RSS izvora vijesti, vremenskih zona itd.<br /><em>PHP cURL ekstenzija se preporučuje!!!.</em>';
$string['xmlrpcrecommended'] = 'xmlrpc ekstenzija je potrebna za komunikaciju s čvorištem, a korisna je i za Web servise, kao i za MNet.';
$string['yuicomboloading'] = 'YUI combo se učitava';
$string['ziprequired'] = 'PHP ekstenzija Zip sada je obavezna za Moodle, binarne info-ZIP datoteke i biblioteka PclZip više se ne koriste.';
