<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'pt_br', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Acesso negado';
$string['accounts'] = 'Contas';
$string['addcategory'] = 'Adicionar uma categoria';
$string['additionalhtml'] = 'HTML adicional';
$string['additionalhtml_desc'] = 'Estas configurações permitem você especificar o código HTML que você quer adicionar em cada página. Você pode definir o código HTML que será adicionado dentro da tag HEAD para a página, imediatamente depois da tag BODY ter sido aberta ou imediatamente antes da tag body ter sido fechada.<br />Este recurso permite que você adicione cabeçalhos ou rodapés personalizados em cada página, ou adicionar o suporte para serviços como Google Analytics muito facilmente e independente do seu tema selecionado.';
$string['additionalhtmlfooter'] = 'Antes da tag BODY ser fechada.';
$string['additionalhtmlfooter_desc'] = 'Este conteúdo será adicionado em cada página antes da tag body ser fechada.';
$string['additionalhtmlhead'] = 'Dentro da tag HEAD';
$string['additionalhtmlhead_desc'] = 'Este conteúdo será adicionado na parte inferior da tag HEAD de cada página.';
$string['additionalhtml_heading'] = 'Código HTML adicional a ser incluído em cada página.';
$string['additionalhtmltopofbody'] = 'Quando a tag BODY for aberta.';
$string['additionalhtmltopofbody_desc'] = 'Este conteúdo será adicionado em cada página imediatamente depois da tag body ser aberta.';
$string['admincategory'] = 'Categoria: {$a}';
$string['adminseesall'] = 'Administradores vêem todos';
$string['adminseesallevents'] = 'Os administradores podem ver todos os eventos';
$string['adminseesownevents'] = 'Os administradores são como os outros usuários';
$string['advancedfeatures'] = 'Opções avançadas';
$string['allcountrycodes'] = 'Todos os códigos de países';
$string['allowbeforeblock'] = 'A lista de permissões será processada primeiro';
$string['allowbeforeblockdesc'] = 'Por padrão, as entradas na lista de IPs bloqueados são processadas primeiro. Se essa opção for ativada, as entradas na lista de IPs permitidos são processadas antes da lista de bloqueados.';
$string['allowblockstodock'] = 'Permitir que os blocos usem o "dock"';
$string['allowcategorythemes'] = 'Permitir temas de categorias';
$string['allowcoursethemes'] = 'Permitir temas de cursos';
$string['allowediplist'] = 'Lista de IP permitidos';
$string['allowemailaddresses'] = 'Domínios de email autorizados';
$string['allowframembedding'] = 'Permitir incluir frames';
$string['allowframembedding_help'] = 'Permite a incorporação (embed) deste site em sites externos. Habilitar essa funcionalidade não é recomendado por razões de segurança.';
$string['allowguestmymoodle'] = 'Permitir acesso de convidado para minha pagina inicial';
$string['allowobjectembed'] = 'Permitir tags EMBED e OBJECT';
$string['allowthemechangeonurl'] = 'Permitir mudanças de tema na URL';
$string['allowuserblockhiding'] = 'Permitir que usuários ocultem blocos';
$string['allowuserswitchrolestheycantassign'] = 'Permitir que usuários sem a permissão de atribuir papel troquem de papel';
$string['allowuserthemes'] = 'Permitir que usuários escolham temas';
$string['antivirus'] = 'Anti-Virus';
$string['appearance'] = 'Aparência';
$string['aspellpath'] = 'Caminho do aspell';
$string['authentication'] = 'Autenticação';
$string['authpreventaccountcreation'] = 'Evitar criar contas quando autenticando';
$string['authpreventaccountcreation_help'] = 'Quando um usuário se autentica, uma conta no site é automaticamente criada caso ainda não exista. Se um banco de dados externo, como o LDAP, é usado para autenticação, mas você deseja restringir o acesso ao site somente para os usuários que já possuam conta,  então esta opção deverá ser ativada. Neste caso, novas contas terão de ser criadas manualmente ou por meio do recurso “upload de usuários”. Note que esta definição não se aplica a autenticação MNet.';
$string['authsettings'] = 'Gerenciar autenticação';
$string['autolang'] = 'Detecção automática de idioma';
$string['autologinguests'] = 'Fazer login automático de visitantes';
$string['availablelicenses'] = 'Licenças disponíveis';
$string['availableto'] = 'Disponível para';
$string['backgroundcolour'] = 'Cor transparente';
$string['backups'] = 'Backups';
$string['backup_shortname'] = 'Usar nome do curso como nome do arquivo de backup';
$string['backup_shortnamehelp'] = 'Use o nome do curso como parte do nome do arquivo de backup.';
$string['badwordsconfig'] = 'Inserir a sua lista de palavras a serem censuradas, separadas por vírgulas.';
$string['badwordsdefault'] = 'Se a lista personalizada estiver vazia, a lista predefinida do idioma correspondente será utilizada.';
$string['badwordslist'] = 'Lista personalizada de palavras censuradas';
$string['blockediplist'] = 'Lista de IP bloqueados';
$string['blockeditingmenu'] = 'Menu de edição de blocos';
$string['blockeditingmenu_desc'] = 'Se habilitado, muitos dos ícones de edição de blocos, mostrado quando a edição está ligada, serão exibidos como um menu de opções. Isso reduz a quantidade de recursos na tela ocultando os ícones até que eles sejam necessários.';
$string['blockinstances'] = 'Instâncias';
$string['blockmultiple'] = 'Múltiplos';
$string['blockprotect'] = 'Proteger instâncias';
$string['blockprotect_help'] = 'Se você bloquear um determinado tipo de bloco, então ninguém vai ser capaz de adicionar ou excluir instâncias. (Você pode, é claro, desbloquear novamente se você precisa editar casos.) Este se destina a proteger blocos, como a navegação e configurações que são muito difíceis de obter de volta se apagado acidentalmente.';
$string['blocksettings'] = 'Gerenciar Blocos';
$string['blockunprotect'] = 'Desprotegido';
$string['bloglevel'] = 'Visibilidade dos blogs';
$string['bookmarkadded'] = 'Marcador de página acrescentado';
$string['bookmarkalreadyexists'] = 'Você já marcou esta página';
$string['bookmarkdeleted'] = 'Marcador de página excluído';
$string['bookmarkthispage'] = 'Marcar esta página';
$string['cacheapplication'] = 'Cache da aplicação';
$string['cacheapplicationhelp'] = 'Itens em cache são compartilhados entre todos usuários e expirão por um tempo determinado ttl.';
$string['cachejs'] = 'Fazer cache do Javascript';
$string['cachejs_help'] = 'As operações de "caching" e compressão do Javascript melhoram muito a performance da carga de páginas. Isso é altamente recomendável para sites de produção. Desenvolvedores, no entanto, provavelmente preferirão desabilitar esta opção.
';
$string['cacherequest'] = 'Requisição cache';
$string['cacherequesthelp'] = 'Cache de usuário específico expira quando a requisição é concluída. Projetado para substituir áreas aonde nós estamos usando caches estáticos.';
$string['cachesession'] = 'Sessão cache';
$string['cachesessionhelp'] = 'Cache específico de usuário expira quando as requisições do usuário são finalizadas. Projetado para aliviar a tensão/sobrecarga na sessão.';
$string['cachesettings'] = 'Configurações de cache';
$string['cachetext'] = 'Duração da memorização temporária de textos';
$string['caching'] = 'Caching';
$string['calendarexportsalt'] = 'Sal para exportação do calendário';
$string['calendarsettings'] = 'Calendário';
$string['calendartype'] = 'Tipo de calendário';
$string['calendartype_desc'] = 'Escolha um tipo de calendário padrão para todo o site. Esta configuração pode ser substituída nas configurações do curso ou por usuários em seu perfil pessoal.';
$string['calendar_weekend'] = 'Dias de fim de semana';
$string['cannotdeletemodfilter'] = 'Você não pode desinstalar o \'{$a->filter}\' porque ele é parte do módulo \'{$a->module}\'.';
$string['cannotuninstall'] = '{$a} não pode ser desinstalado.';
$string['cfgwwwrootslashwarning'] = 'Você definiu $CFG->wwwroot incorretamente no seu arquivo config.php. Você incluiu um caracter \'/\' no final. Por favor remova-o, para que não ocorram erros estranhos como <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Você definiu $CFG->wwwroot incorretamente no seu arquivo config.php. Ela não confere com a URL usada para acessar essa página. Por favor corrija, para que não ocorram erros estranhos como <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'mudar';
$string['checkboxno'] = 'Não';
$string['checkboxyes'] = 'Sim';
$string['choosefiletoedit'] = 'Escolher o arquivo a ser editado';
$string['clamfailureonupload'] = 'Quando clam AV falhar';
$string['cleanup'] = 'Limpeza';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 's';
$string['cliincorrectvalueerror'] = 'Erro, valor incorreto "{$a->value}" para "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Valor incorreto, por favor tente novamente';
$string['clistatusdisabled'] = 'Estado: desabilitado';
$string['clistatusenabled'] = 'Estado: habilitado';
$string['clistatusenabledlater'] = 'status: modo de manutenção CLI será habilitado em {$a}';
$string['clitypevalue'] = 'Digite o valor';
$string['clitypevaluedefault'] = 'digite o valor, pressione Enter para utilizar o valor padrão ({$a})';
$string['cliunknowoption'] = 'Opções não reconhecidas:
  {$a}
Por favor use a opção --help.';
$string['cliupgradefinished'] = 'Atualização via linha de comando terminada com sucesso.';
$string['cliupgradenoneed'] = 'Não há necessidade de realização de atualização de versão para a versão instalada {$a}. Obrigado por nos visitar d equalquer maneira!';
$string['cliyesnoprompt'] = 'digite s (sim) ou n (não)';
$string['commentsperpage'] = 'Comentários apresentados por página';
$string['commonfiltersettings'] = 'Definições comuns de filtros';
$string['commonsettings'] = 'Parametrização padrão';
$string['componentinstalled'] = 'Componente instalado';
$string['computedfromlogs'] = 'Processados dos logs desde {$a}';
$string['condifmodeditdefaults'] = 'Valores padrão são utilizados nos formulários de configuração quando criando uma nova atividade ou recurso.';
$string['confeditorhidebuttons'] = 'Selecionar botões que devem ser escondidos no editor HTML';
$string['configallcountrycodes'] = 'Esta é a lista de países que podem ser selecionados em vários lugares, por exemplo, no perfil de um usuário. Se estiver em branco (o padrão), a lista do countries.php no pacote de idioma padrão Inglês será usada. Essa é a lista da ISO 3166-1. Caso contrário, você pode especificar uma lista de códigos separados por vírgulas, por exemplo, \'GB, FR,ES \'. Se você adicionar aqui novos códigos fora do padrão, você precisará adicioná-los ao countries.php em \'en\' e em seu próprio pacote de linguagem.';
$string['configallowassign'] = 'Você pode permitir que pessoas que têm os papés no lado esquerdo atribuam os papéis das colunas a outras pessoas.';
$string['configallowblockstodock'] = 'Se habilitado e suportado pelo tema escolhido, o usuário poderá optar por mover blocos para um dock especial';
$string['configallowcategorythemes'] = 'Habilitando esta opção, os temas poderão ser escolhidos a nível de categoria. Isso irá afetar todas as categorias e cursos filhos, a não ser que eles tenham seus próprios temas. AVISO: Habilitar temas de categorias pode afetar a performance.';
$string['configallowcoursethemes'] = 'Habilitando esta opção, os cursos podem ter seus próprios temas. Os temas do curso se sobrepõem a outras escolhas de tema (tema da plataforma, do usuário ou da sessão).';
$string['configallowemailaddresses'] = 'Para restringir todos os novos endereços de e-mail a domínios específicos, inclua a lista deles aqui, separados por espaços. Todos os outros domínios serão recusados. Para permitir subdomínios, inclua o domínio precedido por um ponto. Por exemplo <strong>faculdade.edu.br .gov.br</strong>';
$string['configallowguestmymoodle'] = 'Se ativo, os usuários poderão acessar o Meu Moodle, caso contrário, os usuários são redirecionados para a página inicial do site.';
$string['configallowobjectembed'] = 'Como medida padrão de segurança, os usuários em geral não podem incluir multimídia (como Flash) em seus textos usando os marcadores HTML EMBED e OBJECT (embora seja possível o procedimento seguro usando o filtro mediaplugins). Se você deseja permitir essas TAGs, então habilite esta opção.';
$string['configallowoverride'] = 'Voce pode permitir que os papéis do lado esquerdo sobreponham alguns dos papéis na coluna';
$string['configallowoverride2'] = 'Selecionar quais papéis podem ser sobrepostos por cada papel na coluna da esquerda.<br />Esta configuração é aplicada apenas aos usuários que tem as permissões moodle/role:override ou moodle/role:safeoverride.';
$string['configallowswitch'] = 'Selecione quais papéis um usuário pode assumir, com base nos papéis que eles já têm. Além de uma entrada nesta tabela, um usuário também deve ter a capability moodle/role:switchroles para poder mudar de papel.<br />Note que só é possível mudar para papéis que têm a capability moodle/course:view e que não têm a capability moodle/site:doanything, portanto algumas colunas desta tabela estão desabilitadas.';
$string['configallowthemechangeonurl'] = 'Se habilitado, o tema pode ser mudado acrescentando theme={nomedotema} a qualquer URL no Moodle.';
$string['configallowuserblockhiding'] = 'Permitir que os usuários escondam ou mostrem os blocos laterais deste site? Esta funcionalidade usa Javascript e cookies para lembrar que o estado de cada bloco afeta apenas o formato de visualização do próprio usuário.';
$string['configallowuserswitchrolestheycantassign'] = 'Por padrão, moodle/role:assign é necessário para que os usuários troquem de papel. Habilitar esta configuração remove esta necessidade e faz com que os papéis disponíveis no menu "Mudar papel para..." sejam determinadas apenas pelas configurações na tabela "Permitir atribuir papéis". É recomendado que as configurações da tabela "Permitir atribuir papéis" não permitam que um usuário mude para um papel com mais permissões que o atual.';
$string['configallowuserthemes'] = 'Se esta opção estiver habilitada, os usuários poderão escolher seus próprios temas. Os temas do usuário se sobrepõem aos da plataforma (mas não aos temas do curso).';
$string['configallusersaresitestudents'] = 'Em atividades da página inicial da instalação, todos os usuários devem ser considerados alunos? Se a resposta for "Sim", qualquer usuário cadastrado poderá participar como aluno nestas atividades. Se a resposta for "Não", só os usuários que já participam em pelo menos um curso poderão participar destas atividades. Apenas os administradores e os professores especialmente designados podem atuar como professores nestas atividades da página inicial.';
$string['configauthenticationplugins'] = 'Por favor escolha os plugins de autenticação que quer usar e organize-os na ordem para uso.';
$string['configautolang'] = 'Detectar linguagem a ser usada a partir da configuração do browser, se desabilitada usar o idioma predefinido.';
$string['configautologinguests'] = 'Os visitantes devem entrar como visitantes automaticamente quando entram em cursos com acesso livre?';
$string['configbloglevel'] = 'Esta opção permite a restrição do nível de acesso aos blogs deste site. Isto é aplicado ao contexto do usuário que ACESSA, mas não modifica as opções de autoria ou os tipos de texto publicados no blog. É possível também desabilitar totalmente o sistema de blogs do site.';
$string['configcachetext'] = 'Em instalações maiores, que usam filtros de texto, esta configuração pode aumentar a rapidez do processamento. Cópias dos textos serão mantidas durante o período definido aqui. Um período muito breve pode, de fato, aumentar o tempo de processamento, mas um período muito longo significa que os textos levarão mais tempo para serem atualizados (com novos links, por exemplo).';
$string['configcalendarcustomexport'] = 'Ativar exportação personalizada data de faixa do calendário';
$string['configcalendarexportsalt'] = 'Este texto aleatório é utilizado para aumentar a segurança dos tokens de autenticação utilizados para exportar os calendários. Por favor, note que todos os tokens atuais serão invalidados se você alterar este sal.';
$string['configclamactlikevirus'] = 'Tratar arquivos como vírus';
$string['configclamdonothing'] = 'Tratar arquivos como OK';
$string['configclamfailureonupload'] = 'Quando você configurar o Clam para varrer arquivos enviados, mas esta configuração estiver incorreta, ou falhar por qualquer motivo, o que deve ser feito? Se escolher \'Tratar os arquivos como virus\', eles serão transferidos para a área de quarentena ou serão apagados. Se escolher \'Aceitar estes arquivos sem restrições\', eles serão transferidos para o diretório de destino. De qualquer forma, os administradores receberão um aviso. Se escolher \'Tratar os arquivos como virus\' e por algum motivo o Clam não funcionar (devido a um caminho de acesso errado - pathtoclam), TODOS os arquivos que forem enviados serão transferidos para a área de quarentena ou serão apagados. Tome muito cuidado na escolha destas opções.';
$string['configconvertformat'] = 'Se <i>latex</i>, <i>dvips</i> e <i>convert</i> estiverem disponíveis, as imagens serão criadas utilizando o formato especificado. Caso contrário, o mimeTex será usado e criará imagens GIF.';
$string['configcookiehttponly'] = 'Habilita o novo aspecto do PHP 5.2.0 - navegadores são instruídos para mandar apenas cookies com verdadeiros pedidos http e os cookies não devem ser acessados por linguagens de script. Nem todos os navegadores suportam essa configuração, que pode não ser totalmente compatível com o código atual. Ajuda a prevenir alguns tipos de ataques XSS.';
$string['configcookiesecure'] = 'Se o servidor estiver aceitando apenas conexões https, recomenda-se habilitar o envio de cookies seguros. Se habilitado, favor certificar-se de que o servidor web não está aceitando \'http://\', ou então fazer com que haja um redirecionamento permanente para endereço \'https://\'. Quando o endereço <em>wwwroot</em> não iniciar com \'https://\', esta configuração é desabilitada automaticamente.';
$string['configcountry'] = 'O país definido aqui será o padrão para novas contas de usuários. Para forçar os usuários a escolher um país, deixe esta opção vazia.';
$string['configcourseoverviewfilesext'] = 'Lista das extensões de arquivos, separadas por vírgula, permitidas no sumário do curso .';
$string['configcourseoverviewfileslimit'] = 'O número máximo de arquivos que podem ser anexados ao sumário do curso.';
$string['configcourserequestnotify'] = 'Informe o usuário a ser notificado quando um novo curso for solicitado.';
$string['configcourserequestnotify2'] = 'Usuários que serão notificados quando um curso for solicitado. Apenas usuários que podem aprovar solicitações de curso são listados aqui.';
$string['configcoursesperpage'] = 'Digite o número de cursos a serem exibidos por página em uma lista de cursos.';
$string['configcourseswithsummarieslimit'] = 'O número máximo de cursos listados incluindo resumos antes de voltar para listagem simples.';
$string['configcronclionly'] = 'Se esta opção estiver habilitada o roteiro do cron só pode ser executado a partir da linha de comando e não pela web. Isto prevalece sobre a senha de cron configurada acima.';
$string['configcronremotepassword'] = 'Isto significa que o script cron.php não pode ser executado de um navegador sem fornecer a senha usando a seguinte forma de URL:<pre> http://site.example.com/admin/cron.php?password=opensesame
</pre>';
$string['configcurlcache'] = 'Tempo de vida (TTL) para o cache do cURL, em segundos';
$string['configcustommenuitems'] = 'Você pode configurar aqui um menu personalizado para ser mostrado pelos temas. Cada linha consiste de algum texto de menu, um URL para link (opcional) e um título de tooltip (opcional), separados por caracteres de pipe. Você pode especificar uma estrutura usando hífens. Por exemplo:
<pre>
Comunidade Moodle|http://moodle.org
-Suporte Moodle gratuito|http://moodle.org/support
-Desenvolvimento Moodle|http://moodle.org/development
--Moodle Docs|http://docs.moodle.org
--Moodle Tracker|http://tracker.moodle.org
-Notícias do Moodle|http://moodle.org/news
</ pre>';
$string['configdbsessions'] = 'Se habilitado, o Moodle irá utilizar o banco de dados para guardar informações sobre as sessões atuais. Perceba que mudar esta opção agora irá desconectar todos os usuários (incluindo você). Se você está utilizando o MySQL, por favor, tenha certeza que a configuração "max_allowed_packet" no arquivo my.cnf está definida com pelo menos 4M. Outros drivers de sessão podem ser configurados diretamente no config.php, veja o arquivo config-dist.php para mais informações. Esta opção desaparecerá se você especificar um driver diferente no arquivo config.php';
$string['configdebug'] = 'Esta opção aumenta a informação sobre erros de PHP, imprimindo mais advertências. Ela só é útil para desenvolvedores.';
$string['configdebugdisplay'] = 'Se esta opção for habilitada, o relatório de erro irá para página HTML. Isto é prático mas atrapalha XHTML, JS, cookies e cabeçalhos HTTP em geral. Se não habilitada, enviará a saída para os logs do seu servidor, permitindo um melhor debug. A configuração error_log_controls do PHP controla para qual log será enviado.';
$string['configdebugpageinfo'] = 'Habilite se você quiser informações sobre a página impressa no rodapé da página.';
$string['configdebugsmtp'] = 'Habilita informações detalhadas de depuração durante o envio de mensagens de email para o servidor SMTP.';
$string['configdebugvalidators'] = 'Habilite esta opção se você quiser ter links para servidores de validação externa no rodapé da página. Pode ser que você precise criar um novo usuário com "username"  <em>w3cvalidator</em> e permitir o acesso a visitantes. Estas alterações poderão resultar em acesso não autorizado ao servidor, não habilite em sites de produção!';
$string['configdefaulthomepage'] = 'Isto determina a página inicial para usuários autenticados';
$string['configdefaultrequestcategory'] = 'Cursos requisitados por usuários serão automaticamente colocados nesta categoria.';
$string['configdefaultrequestedcategory'] = 'Categoria padrão para novos cursos aprovados';
$string['configdefaultuserroleid'] = 'Todos os usuários autenticados terão as capabilities do papel especificado aqui, em nível global, em ADIÇÃO a quaisquer outros papéis que eles possuam. O padrão é o papel Autenticado (ou Visitante em versões mais antigas). Note que isso não causará conflito com os outros papéis do usuário, apenas permitirá que eles tenham privilégios que não podem ser atribuídos em nível de curso (ex: posts em blog, gerenciamento de calendário, etc)';
$string['configdeleteincompleteusers'] = 'Depois deste período as contas incompletas serão apagadas.';
$string['configdeleteunconfirmed'] = 'Se estiver utilizando autenticação por correio eletrônico, este é o período em que serão aceitas respostas dos usuários. Depois disto as contas antigas não confirmadas serão canceladas.';
$string['configdenyemailaddresses'] = 'Para recusar endereços de domínios específicos, inclua a lista deles aqui como a anterior. Todos os demais domínios serão aceitos. Para recusar subdomínios, adicione o domínio precedido por um ponto. Por exemplo <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Desativar a capacidade de usuários mudarem imagens de perfil de usuário.';
$string['configdisplayloginfailures'] = 'Isto mostra a informação sobre acessos mal sucedidos a usuários selecionados.';
$string['configdndallowtextandlinks'] = 'Habilita ou desabilita a funcionalidade de arrastar e soltar texto e links nas seções do curso. Note que arrastar e soltar texto no Firefox ou entre diferentes navegadores é pouco confiável e pode resultar em nenhum dado sendo enviado ou texto corrompido sendo enviado.';
$string['configdocroot'] = 'Define o caminho até o Moodle Docs. Você pode modificar este endereço se você quiser ter sua própria documentação online. Neste caso, certifique-se que os caminhos na sua documentação sequem o mesmo formato de http://docs.moodle.org. Se este campo for deixado em branco, nenhum link será exibido.';
$string['configdoctonewwindow'] = 'Se você habilitar isto, os links para o Moodle Docs serão mostrados uma nova janela.';
$string['configeditordictionary'] = 'Este valor será usado se o programa aspell não tiver dicionário para o idioma dos usuários.';
$string['configeditorfontlist'] = 'Selecionar as fontes de caracteres que devem aparecer na lista que desce no editor.';
$string['configemailchangeconfirmation'] = 'Exigir confirmação por email quando os usuários mudam o endereço email no perfil.';
$string['configenableajax'] = 'Esta configuração controla o uso de AJAX em todo o site. AJAX é necessário para algumas funcionalidades, tais como arrastar e soltar.';
$string['configenableblogs'] = 'Esta opção oferece a todos os usuários do site o seu próprio blog.';
$string['configenablecalendarexport'] = 'Habilitar exportação ou assinatura de calendários.';
$string['configenablecomments'] = 'Habilitar comentários';
$string['configenablecourserequests'] = 'Isto permite que qualquer usuário faça uma solicitação de criação de curso.';
$string['configenabledevicedetection'] = 'Habilitar a detecção de dispositivos móveis, smartphones, tablets ou computadores (computador de mesa, notebooks, etc.) para a aplicação de temas visuais e outros recursos.';
$string['configenablegroupmembersonly'] = 'Se habilitado, o acesso às atividades poderá ser restringido apenas aos membros do grupo. Isso pode resultar em um aumento da carga do servidor. Além disso, as categorias do livro de notas devem ser configuradas de maneira a assegurar que as atividades fiquem escondidas dos usuários que não sejam membros do grupo.';
$string['configenablemobilewebservice'] = 'Habilitar o serviço móvel para a aplicação Moodle oficial ou outro aplicativo que o solicite. Para mais informações, leia o {$a}';
$string['configenablerssfeeds'] = 'Se habilitado, alimentadores de RSS serão gerados em todas as sessões do site, como blogs, fóruns, atividades de banco de dados e glossários. Perceba que os alimentadores de RSS devem ser habilitados também no painel de configuração de cada módulo, que podem ser acessados na página de administração do site.';
$string['configenablerssfeedsdisabled'] = 'Não está disponível porque os alimentadores RSS estão desabilitados neste site. Para habilitá-los, vá à configuração de Variáveis dentro no painel de Administração.';
$string['configenablerssfeedsdisabled2'] = 'Feeds RSS estão desabilitados a nível de servidor. Você precisa habilitá-los primeiro em Servidor/RSS.';
$string['configenablesafebrowserintegration'] = 'Isto adiciona a opção "Exigir navegador Safe Exam" ao campo "Segurança do navegador" no formulário de configurações do quiz. Para mais informações, veja http://www.safeexambrowser.org';
$string['configenablestats'] = 'Escolhendo \'sim\', o cronjob de Moodle processa os logs e as estatísticas. Dependendo do tráfego do seu site, isto pode ser uma operação demorada. Esta opção permite a consulta de gráficos e estatísticas interessantes relativas a cada curso e ao site.';
$string['configenabletrusttext'] = 'Por padrão, o Moodle sempre tentará limpar os textos que vêm do usuário, para remover códigos indesejados, mídia, etc, que poderiam ser um risco de segurança. O sistema de Conteúdo Confiável é um modo de dar a usuários particulares a habilidade de incluir esses recursos mais avançados sem interferência por parte do site.
Para ativar esse sistema você precisa ativar essa configuração e então atribuir a permissão de Conteúdo Confiável a um papel específico. Textos criados e enviados por esses usuários serão marcados como confiáveis e não serão limpos antes da exibidos.';
$string['configenablewebservices'] = 'Serviços Web (Web Services) permitem que outros sistemas acessem este Moodle e executem operações. Para maior segurança, esta opção deve ser desabilitada a menos que você realmente esteja utilizando.';
$string['configenablewsdocumentation'] = 'Permite a geração automática de documentação de serviços web (Web Services). Um usuário pode acessar a sua própria documentação em sua página de chaves de segurança {$a}. Somente será mostrada a documentação para protocolos habilitados.';
$string['configerrorlevel'] = 'Escolha o nível de advertências do PHP a serem exibidas. A escolha mais comum é Normal.';
$string['configexportlookahead'] = 'Dias a considerar para frente durante a exportação';
$string['configexportlookback'] = 'Dias a considerar para trás durante a exportação';
$string['configextendedusernamechars'] = 'Habilite esta opção para permitir que os estudantes usem qualquer caractere no nome de usuário (isto não afeta seus nomes verdadeiros). O padrão é "falso", o que restringe o uso a caracteres alfanuméricos, underscore (_), hífen (-), ponto (.) ou arroba (@).';
$string['configextramemorylimit'] = 'Alguns scripts como a busca, backup/restauração e o cron necessitam de mais memória. Defina valores altos para grandes sites.';
$string['configfilterall'] = 'Filtra todas as expressões, inclusive cabeçalhos, títulos e barras de navegação. Esta opção é útil apenas quando o filtro multi-língua está ativado. Em outros casos irá simplesmente aumentar a carga de operações do sistema.';
$string['configfiltermatchoneperpage'] = 'Os filtros para criação automática de links se aplicam apenas à primeira expressão correspondente presente em uma página. Todas as outras são ignoradas.';
$string['configfiltermatchonepertext'] = 'Os filtros para criação automática de links se aplicam apenas à primeira expressão correspondente presente em cada item de texto (recurso, bloco) da página. Todas as outras são ignoradas. Esta configuração é ignorada quando a opção Um por Página é ativa.';
$string['configfilteruploadedfiles'] = 'Habilitar esta opção para que o Moodle filtre todos os arquivos com formato Texto e HTML antes de mostrá-los.';
$string['configforcelogin'] = 'Normalmente a página inicial da instalação e a lista de cursos (mas não os cursos) podem ser vistos por quem não se inscreveu como usuário. Para forçar as pessoas a se registrarem antes de poder navegar no site, esta opção deve ser habilitada.';
$string['configforceloginforprofiles'] = 'Habilitar esta opção para forçar as pessoas a fazerem o login com uma conta de usuário que não seja de visitante antes de poder ver os perfis de usuários. Normalmente esta opção está habilitada ("verdadeiro") para permitir que possíveis alunos se informem sobre os docentes de cada curso, e permitir o acesso aos dados pelos motores de busca.';
$string['configfrontpage'] = 'Os itens selecionados acima serão visualizados na página inicial do site.';
$string['configfrontpagecourselimit'] = 'Número máximo de cursos';
$string['configfrontpagecourselimithelp'] = 'Número máximo de cursos a serem exibidos na primeira página do site na listagem de cursos.';
$string['configfrontpageloggedin'] = 'O ítem selecionado acima será visualizado na página inicial depois do login dos usuários.';
$string['configfullnamedisplay'] = 'Isto define como serão mostrados os nomes completos.  O valor padrão, "idioma", deixa que a string "fullnamedisplay" do pacote de idioma em uso defina o formato. Alguns idiomas tem diferentes convenções para exibir os nomes.

Para a maior parte dos sites com um único idioma, a configuração mais eficiente é "firstname lastname", mas você pode querer esconder os últimos nomes por completo. Os valores que podem ser utilizados aqui são:  firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, e alternatename.';
$string['configgeoipfile'] = 'Caminho do arquivo binário de dados do GeoIP City. Ele não faz parte da distribuição do Moodle e pode ser obtido separadamento da <a href="http://www.maxmind.com/">MaxMind</a>.
Você pode comprar uma versão comercial ou usar a versão livre.<br /> É só baixar <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> e extrair no diretório "{$a}" do seu servidor.';
$string['configgetremoteaddrconf'] = 'Se o seu servidor estiver atrás de um proxy reverso, você pode usar esta configuração para especificar quais cabeçalhos HTTP contendo o endereço IP remoto são confiáveis. Os cabeçalhos são lidos em ordem, usando o primeiro disponível.';
$string['configgradebookroles'] = 'Esta configuração permite o controle do que é visível no quadro de avaliações. Os usuários devem ter um dos seguintes papéis no curso para que sejam incluídos no quadro de avaliações.';
$string['configgradeexport'] = 'Escolha quais formatos de exportação de quadro de avaliações são seus métodos principais para exportar notas. Plugins escolhidos irão configurar e usar um campo "último exportado" para cada nota. Por exemplo, isto pode resultar em registros exportados sendo identificados como "novo" ou "atualizado". Se você não está certo sobre isto, então deixe tudo em branco.';
$string['confighiddenuserfields'] = 'Selecione os campos de informação de usuários que você quer esconder de outros usuários que não professores/administradores. Isto aumenta a privacidade dos estudantes. Mantenha pressionada a tecla CTRL para selecionar multiplos campos.';
$string['configidnumber'] = 'Esta opção especifica se (a) Não será pedido um ID aos usuários, (b) Será pedido um ID aos usuários, mas eles podem deixar em branco, ou (c) Será pedido um ID e o campo não pode ser deixado em branco. O código ID é mostrado no Perfil do usuário.';
$string['configintro'] = 'Nesta página você pode especificar algumas variáveis de configuração que ajudam o Moodle a funcionar corretamente em seu servidor. Não se preocupe demasiadamente com isto, o padrão normalmente funciona bem e você pode voltar a esta página posteriormente para mudar as configurações.';
$string['configintroadmin'] = 'Nesta página deve ser configurada a conta do administrador principal, que tem controle completo sobre a instalação. Escolha nome e senha seguros e utilize um endereço de correio eletrônico válido. Mais tarde você pode criar outras contas de administrador.';
$string['configintrosite'] = 'Esta página permite que você configure a página inicial e o nome deste novo site. Você pode voltar aqui depois para alterar estar configurações utilizando os menus administrativos.';
$string['configiplookup'] = 'Quando você clica um endereço IP, como 34.12.222.93, nos logs, o mapa visualizado tenta adivinhar a localização do IP. Você pode escolher plugins com características diferentes entre eles para esta funcionalidade.';
$string['configkeeptagnamecase'] = 'Marcar esta opção se deseja que os nomes de tag mantenham o tamanho original fornecido pelos usuários quando os criaram.';
$string['configlang'] = 'Escolha um idioma padrão para todo o site. Os usuários podem sobrescrever esta configuração usando o menu de idiomas ou a configuração em seu perfil pessoal.';
$string['configlanglist'] = 'Deixe em branco para permitir que os usuários escolham qualquer idioma disponível em sua instalação do Moodle. Você pode restringir o menu de idiomas criando uma lista que separa os códigos da linguagens desejadas por vírgulas. Por exemplo: en,es_es,fr,it,pt_br,pt';
$string['configlangmenu'] = 'Escolha se o menu geral de idioma deve aparecer na página inicial, na página de login, etc. Isto não impede o usuário de escolher seu idioma preferido em seu perfil.';
$string['configlangstringcache'] = 'Fazer cache de todas as strings de idiomas em arquivos compilados no diretório de dados. Se você estiver traduzindo o Moodle ou alterando strings no código-fonte do Moodle você vai querer que isto esteja desligado. Caso contrário, deixe-a ativada para melhorar o desempenho.';
$string['configlatinexcelexport'] = 'Escolha a codificação dos relatórios em Excel.';
$string['configlocale'] = 'Escolha o \'locale\' da instalação - isto afeta o formato e o idioma das datas em todos os pacotes de idioma (apesar de os nomes dos dias no calendário não serem afetados). Você deve ter este \'locale\' instalado em seu sistema operacional (por exemplo, para linux en_US.UTF-8 ou  pt_BR.UTF-8). Na maior parte dos casos este campo deve ser deixado em branco.';
$string['configloginhttps'] = 'Se esta opção estiver habilitada, o Moodle utiliza uma conexão segura para a página de entrada (login seguro), e volta em seguida para a URL HTTP normal, para ter maior velocidade. CUIDADO: esta opção REQUER que o https esteja configurado em seu servidor. Se não estiver configurado VOCÊ CORRE O RISCO DE BLOQUEAR SEU PRÓPRIO ACESSO AO SITE.';
$string['configloglifetime'] = 'Isto define durante quanto tempo os logs das atividades dos usuários serão mantidos. Os logs que forem mais velhos que esta idade serão automaticamente excluídos. É melhor manter os logs tanto quanto possível, caso você precise deles, mas se você tem um servidor muito ocupado e está encontrando problemas de performance, então você pode querer diminuir o tempo de vida dos logs. Valores menores que 30 não são recomendados pois as estatísticas podem não funcionar corretamente.';
$string['configlookahead'] = 'Dias no futuro a considerar';
$string['configmaxbytes'] = 'Isto define o tamanho máximo que os arquivos enviados podem ter em todo o site. Esta configuração é limitada pelas configurações do PHP post_max_size e upload_max_filesize, e também pela configuração do Apache LimitRequestBody. Por sua vez, maxbytes limita o intervalo de valores que podem ser escolhidos no nível de curso ou módulo. Se "Limite do servidor" for escolhido, o valor máximo permitido pelo servidor será utilizado.';
$string['configmaxconsecutiveidentchars'] = 'As senhas não devem ter mais que este número de caracteres idênticos consecutivos. Use 0 para desconsiderar esta condição.';
$string['configmaxeditingtime'] = 'Especifica o tempo que os usuários tem para modificar as mensagens nos fóruns, feedbacks, etc. 30 minutos é um valor razoável.';
$string['configmaxevents'] = 'Eventos futuros considerados';
$string['configmaxusersperpage'] = 'O número máximo de usuários exibidos dentro do seletor de usuário em curso, grupo de coorte, webservice etc';
$string['configmessaging'] = 'O sistema de mensagens pessoais deve ser habilitado?';
$string['configmessagingallowemailoverride'] = 'Permite que usuários que encaminhem notificações de mensagens por email para outro email além do email que consta no perfil.';
$string['configmessagingdeletereadnotificationsdelay'] = 'Notificações já lidas podem ser excluídas para economizar espaço. Quanto tempo após a sua leitura uma notificação pode ser excluída?';
$string['configmessaginghidereadnotifications'] = 'Ocultar notificações já lidas de eventos tais como mensagens em foruns quando visualizando o histórico de mensagens.
';
$string['configminpassworddigits'] = 'Senhas devem ter no mínimo esta quantidade de dígitos.';
$string['configminpasswordlength'] = 'Senhas devem ter no mínimo esta quantidade de caracteres.';
$string['configminpasswordlower'] = 'Senhas devem ter no mínimo esta quantidade de caracteres minúsculos.';
$string['configminpasswordnonalphanum'] = 'Senhas devem ter no mínimo estes caracteres que não são alfa-numéricos';
$string['configminpasswordupper'] = 'Senhas devem ter no mínimo estas letras maiúsculas.';
$string['configmobilecssurl'] = 'Um arquivo CSS para customizar a interface do aplicativo movel';
$string['configmodchooserdefault'] = 'O seletor de atividades deve ser apresentado aos usuários por padrão?';
$string['configmycoursesperpage'] = 'Número máximo de cursos a ser mostrado em qualquer lista dos cursos de um usuário.';
$string['configmymoodleredirect'] = 'Esta opção força o redirecionamento para /my na hora do login para quem não é admin e substitui o aspecto do site principal por aquele do /my.';
$string['configmypagelocked'] = 'Esta configuração impede que a página padrão seja editada por usuários não  administradores.';
$string['confignavcourselimit'] = 'Limita o número de cursos mostrados para usuários não autenticados ou que não estejam inscritos em algum curso.';
$string['confignavshowallcourses'] = 'Esta configuração determina se os usuários inscritos em cursos podem ver a lista com todos os Cursos na navegação, ao invés de apenas os Cursos em que estão inscritos.';
$string['confignavshowcategories'] = 'Mostra categorias de cursos na barra de navegação e blocos de navegação. Isso não ocorre com os cursos em que o usuário está inscrito, esses ainda serão listados em Meus Cursos (mycourses) sem categorias.';
$string['confignotifyloginfailures'] = 'Se falhas de acesso forem registradas, podem ser enviados avisos por correio eletrônico. Quem deve receber estes avisos?';
$string['confignotifyloginthreshold'] = 'Se as notificações sobre falhas de acesso estiverem ativas, quantas tentativas frustradas de acesso de um mesmo usuário ou endereço IP devem ser contadas para gerar notificação?';
$string['confignotloggedinroleid'] = 'Usuários que não estão conectados ao site serão tratados como se tivessem este papel que lhes é concedido em âmbito local. Você deve preferir quase sempre que o usuário tenha papel de visitante, mas talvez você queira criar papéis que são menos ou mais restritivos. Com a criação de posts pode-se exigir que o usuário se autentique adequadamente.';
$string['configopentogoogle'] = 'Se habilitar esta opção, o Google poderá entrar neste site como \'visitante\'. Além disto, as pessoas que chegarem no site através de uma busca no Google, serão automaticamente registradas como \'visitantes\'. Note que o acesso será possível somente nos cursos que já permitem o acesso de visitantes.';
$string['configoverride'] = 'Definido no arquivo config.php';
$string['configpasswordpolicy'] = 'Ativar isto fará com que seu Moodle verifique senhas diante de uma política válida de senha. Use as configurações abaixo para especificar a sua política (elas serão ignoradas se você marcar "Não").';
$string['configpasswordresettime'] = 'Isso especifica a quantidade de tempo que as pessoas têm de validar um pedido de redefinição de senha antes que ela expire. Geralmente 30 minutos é um bom valor.';
$string['configpathtoclam'] = 'Caminho para o Clam AV. Provavelmente algo como /usr/local/bin/clamscan ou /usr/bin/clamdscan. Isto é necessário para que o Clam AV seja utilizado.';
$string['configpathtodu'] = 'Caminho para o du. Algo como /usr/bin/du. Configurando esta opção, as páginas que mostram conteúdos de diretórios serão mais velozes.';
$string['configperfdebug'] = 'Ativando esta opção, um indicador de performance será visualizado no fim da página no tema padrão.';
$string['configprofileroles'] = 'Lista dos papéis que ficarão visíveis nos perfis de usuário e na página de participação.';
$string['configprofilesforenrolledusersonly'] = 'Para previnir o mal uso por spammers, as descrições dos perfis de usuários que ainda não estão inscritos em nenhum curso são escondidas. Novos usuários devem se inscrever em pelo menos um curso para poderem adicionar uma descrição no perfil.';
$string['configprotectusernames'] = 'Por padrão, forget_password.php não exibe nenhuma dica que permitiria adivinhar "usernames" ou endereços de email.';
$string['configproxybypass'] = 'Lista separada por vírgulas (parcial) de hostnames ou endereços IP que devem ignorar o proxy (por exemplo, 192.168.,  .meudominio.com)';
$string['configproxyhost'] = 'Se este <b>servidor</b> precisar usar um proxy (por exemplo, um firewall) para acessar a Internet, indique o hostname do proxy aqui. Caso contrário, deixe em branco.';
$string['configproxypassword'] = 'Senha necessária para acessar internet através de proxy, se exigido. Deixar vazio caso não seja exigido (extensão PHP cURL exigida).';
$string['configproxyport'] = 'Se esse servidor precisa usar um computador de proxy, então forneça a porta proxy aqui.';
$string['configproxytype'] = 'Tipo de proxy web (PHP5 e a extensão cURL são necessários para suporte do SOCKS5)';
$string['configproxyuser'] = 'Usuário necessário para acessar a internet através de proxy, se exigido. Deixar vazio caso não seja exigido (extensão PHP cURL exigida)';
$string['configquarantinedir'] = 'Se você quer que o clam AV mova os arquivos infectados para um diretório de quarentena, informe-o aqui. Ele deve poder ser escrito pelo servidor web. Se você deixar isto em branco, ou informar um diretório que não existe ou que não possa ser escrito, arquivos infectados serão excluídos. Não inclua a barra final.';
$string['configrecaptchaprivatekey'] = 'Cadeia de caracteres usada para comunicação entre o servidor do seu Moodle e o servidor recaptcha.net. Obtenha uma para este site visitando http://google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Cadeia de caracteres usados para mostrar o elemento de reCAPTCHA no formulário de entrada. Gerado por http://google.com/recaptcha';
$string['configrequestcategoryselection'] = 'Permitir a escolha de uma categoria ao solicitar um curso.';
$string['configrequestedstudentname'] = 'Palavra para definir o estudante, usada em pedidos de cursos.';
$string['configrequestedstudentsname'] = 'Palavra para definir os estudantes, usada em pedidos de cursos.';
$string['configrequestedteachername'] = 'Palavra para definir o professor, usada em pedidos de cursos.';
$string['configrequestedteachersname'] = 'Palavra para definir os professores, usada em pedidos de cursos.';
$string['configrequiremodintro'] = 'Desabilite esta opção se você não quiser forçar os usuários a informar a descrição de cada atividade.';
$string['configrunclamavonupload'] = 'Se habilitado, Clam AV será usado para verificar os arquivos carregados no servidor.';
$string['configrunclamonupload'] = 'Executar o Clam AV quando forem enviados arquivos ao servidor? Deve ser dado o caminho correto em pathtoclam para que isto funcione. (Clam AV é um anti-virus gratuito que pode ser obtido em http://www.clamav.net/)';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'Mail';
$string['configsectionmaintenance'] = 'Manutenção';
$string['configsectionmisc'] = 'Miscelânea';
$string['configsectionoperatingsystem'] = 'Sistema operacional';
$string['configsectionpermissions'] = 'Permissões';
$string['configsectionrequestedcourse'] = 'Requisição de cursos';
$string['configsectionsecurity'] = 'Segurança';
$string['configsectionstats'] = 'Estatísticas';
$string['configsectionuser'] = 'Usuário';
$string['configsecureforms'] = 'O Moodle pode usar um nível de segurança extra quando aceita dados de um formulário HTML. Se esta opção estiver habilitada, a variável HTTP_REFERER do navegador é verificada em relação ao endereço atual do formulário. Em alguns poucos casos isto pode causar problemas se o usuário utilizar um firewall (por exemplo, Zonealarm) configurado para eliminar o HTTP_REFERER do tráfego na rede. O sintoma típico é o bloqueio do navegador na página de um formulário. Se seus usuários estão tendo problemas com a página de login, por exemplo, você pode querer desabilitar esta opção, embora isto possa deixar o seu site mais vulnerável a ataques relacionados a senhas. Em caso de dúvida escolha a opção \'Sim\'.';
$string['configsessioncookie'] = 'Esta opção personaliza o nome do \'cookie\' usado nas sessões deste Moodle. Isto é opcional e só é útil quando houver mais de uma instalação do Moodle no mesmo endereço.';
$string['configsessioncookiedomain'] = 'Isto permite que você altere o domínio do qual os cookies do Moodle estão disponíveis. Isto é útil para personalizações do Moodle (por exemplo, plugins de autenticação ou inscrição) que precisam compartilhar informações da sessão Moodle com uma aplicação web em outro sub-domínio. <strong>ATENÇÃO: é altamente recomendável deixar esta configuração com o valor padrão (vazio) - um valor incorreto pode impedir todos os logins ao site.</strong>';
$string['configsessioncookiepath'] = 'Se você precisar mudar o endereço de emissão dos Cookies de Moodle, indique o sub-diretório do seu site web. Em caso contrário, o padrão \'/\' deve ser adequado.';
$string['configsessiontimeout'] = 'Se as pessoas que fizeram o login neste site ficarem inativas por um longo tempo (sem navegar), serão automaticamente desconectadas (a sessão é terminada). Esta variável determina a duração deste período de tempo.';
$string['configshowcommentscount'] = 'Mostrar a quantidade de comentários, isto vai custar uma consulta extra quando mostrando links para comentários';
$string['configshowicalsource'] = 'Mostrar informações da fonte dos eventos do iCal.';
$string['configshowsiteparticipantslist'] = 'Todos os alunos e instrutores do site serão incluídos na lista de participantes. Quem pode consultar esta lista de participantes?';
$string['configsitedefaultlicense'] = 'Licença padrão do ambiente';
$string['configsitedefaultlicensehelp'] = 'A licença padrão para publicação de conteúdo neste site';
$string['configsitemaxcategorydepth'] = 'Profundidade máxima de categorias';
$string['configsitemaxcategorydepthhelp'] = 'Especifica a profundidade máxima de subcategorias a serem exibidas quando mostrar a lista de categorias ou lista de combinação. Categorias de níveis mais profundos irão aparecer como links e os usuários poderão expandi-las requisitando através de AJAX.';
$string['configslasharguments'] = 'Arquivos (imagens, uploads, etc) são fornecidos através de um script utilizando \'slash arguments\'. Este método facilita o cache por parte de navegadores, servidores proxy, etc. Infelizmente, alguns servidores PHP não permitem esse método, então se você tiver problemas visualizando arquivos enviados ou imagens (por exemplo, imagens de usuários), desabilite esta opção.';
$string['configsmartpix'] = 'Quando ativo, os ícones são mostrados através de um script PHP que busca no tema atual, depois nos níveis superiores da hierarquia, e então na pasta /pix do Moodle. Isso reduz a necessidade de duplicar arquivos de imagens dos temas, mas produz um custo um pouco maior de performance.';
$string['configstartwday'] = 'Início da semana';
$string['configstatsfirstrun'] = 'Isto define o período, em relação ao passado, que o processamento dos logs deve considerar a partir da primeira vez que o cronjob fizer esta operação. Se você tem muito tráfego e é hospedado em servidor compartilhado, evite incluir um longo período de tempo, porque isto pode demorar muito e consumir muitos recursos do servidor. (Observe que para esta opção 1 mês = 28 dias. Nos gráficos e relatórios gerados, 1 mês = 1 mês do calendário.)';
$string['configstatsmaxruntime'] = 'O processamento das estatísticas pode ser bastante intensivo, use este campo junto com o próximo para definir quando será executado e por quanto tempo.';
$string['configstatsmaxruntime2'] = 'O processamento das estatísticas pode ser bastante intensivo, especifique o tempo máximo que será permitido para a coleta de estatísticas de um dia. O número máximo de dias processados em uma execução do cron é 31.';
$string['configstatsmaxruntime3'] = 'Especifica o tempo máximo permitido para calcular as estatísticas para cada dia, tendo em mente que o processamento estatístico pode colocar uma grande carga sobre o servidor. O número máximo de dias transformados em um cron pode ser especificado abaixo.';
$string['configstatsruntimedays'] = 'Esta configuração especifica o número máximo de dias a serem processados em cada execução das estatísticas. Quando as estatísticas estiverem atualizadas, apenas um dia será processado, então ajuste este valor conforme a carga de seu servidor, reduzindo-o caso seja necessário encurtar as execuções do cron.';
$string['configstatsruntimestart'] = 'A que horas o cronjob que processa as estatísticas deve iniciar? É recomendável especificar tempos diferentes se você tiver múltiplos Moodles no mesmo servidor físico.';
$string['configstatsuserthreshold'] = 'Esta configuração define o número mínimo de usuários inscritos em um curso para ele ser incluído nos cálculos de estatísticas.';
$string['configstrictformsrequired'] = 'Se ativado, os usuários são impedidos de inserir espaço em branco ou quebra de linha em campos obrigatórios dos formulários.';
$string['configstripalltitletags'] = 'Desmarcar esta opção para permitir tags HTML nos nomes das atividades e dos recursos.';
$string['configsupportemail'] = 'Este endereço de email será publicado para que os usuários deste site possam recorrer quando precisarem de ajuda em geral (por exemplo, quando novos usuários criam suas próprias contas). Se este email for deixado em branco, então nenhum endereço de email de ajuda será fornecido.';
$string['configsupportname'] = 'Esse é o nome de uma pessoa ou outra entidade que oferece ajuda em geral através do email de suporte ou de um endereço web.';
$string['configsupportpage'] = 'Este endereço web será publicado para que os usuários deste site possam recorrer quando precisarem de ajuda em geral (por exemplo, quando novos usuários criam suas próprias contas). Se este endereço for deixado em branco, então nenhum link será fornecido.';
$string['configthemedesignermode'] = 'Normalmente, todas as imagens de temas e as folhas de estilo (CSS) são armazenados em cache nos navegadores e no servidor por um longo tempo bem, para melhorar o desempenho. Se você estiver criando temas ou desenvolvendo código, então provavelmente você querer esta configuração habilitada para não receber versões do cache. Atenção: isto irá tornar seu site mais lento para todos os usuários! Alternativamente, você também pode esvaziar os caches do tema manualmente a partir da página de seleção do tema.';
$string['configthemelist'] = 'Deixe em branco para permitir que qualquer tema válido seja usado. Se você quiser encurtar o menu de termas, você pode especificar uma lista  de nomes separados por vírgula aqui (Não utilize espaços!). Por exemplo: standard,orangewhite.';
$string['configtimezone'] = 'Você pode escolher aqui o fuso horário padrão para mostrar datas. Qualquer usuário pode definir sua opção de fuso horário em seu perfil. "Hora do Servidor" fará com que o Moodle escolha como padrão a hora do sistema operacional, mas "Hora do Servidor" no perfil do usuário fará com que seja usado o fuso horário padrão.';
$string['configuseblogassociations'] = 'Os usuários devem ser capazes de organizar seus blogs associando entradas com cursos e módulos de cursos?';
$string['configuseexternalyui'] = 'Ao invés de usar arquivos locais, usar aquivos online disponíveis nos servidores do Yahoo!. AVISO: Isto requer uma conexão com a Internet, ou o AJAX não irá funcionar em seu site. Esta configuração não é compatível com sites usando https.';
$string['configuserquota'] = 'Número máximo de bytes que um usuário pode armazenar em sua área privada de arquivos. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Se ativado, o nome curto do site será usado para as páginas do site na barra de navegação ao invés da string \'Páginas do site\' .';
$string['configusetags'] = 'Deve habilitar a funcionalidade de tags em todo o site?';
$string['configvariables'] = 'Variáveis';
$string['configverifychangedemail'] = 'Habilita a verificação de endereços de emails alterados utilizando as configurações de domínios autorizados e proibidos. Se esta configuração for desabilitada, esta restrição será aplicada apenas na criação de novos usuários';
$string['configvisiblecourses'] = 'Mostre cursos em categorias ocultas';
$string['configwarning'] = 'Tenha cuidado ao modificar estas configurações. Valores estranhos podem causar problemas.';
$string['configyuicomboloading'] = 'Esta opção permite a otimização da carga de arquivos para bibliotecas YUI. Essa configuração deve ser ativada em sites de produção por motivos de desempenho.';
$string['confirmation'] = 'Confirmação';
$string['confirmdeletecomments'] = 'Você está prestes a excluir comentários, tem certeza?';
$string['confirmed'] = 'Confirmado';
$string['convertformat'] = 'Formato de saída do <i>convert</i>';
$string['cookiehttponly'] = 'Somente http cookies';
$string['cookiesecure'] = 'Somente cookies seguros';
$string['country'] = 'País predefinido';
$string['coursecontact'] = 'Administradores de curso';
$string['coursecontact_desc'] = 'Esta opção permite que você controle quem aparece na descrição do curso. Usuários precisarão ter pelo menos um desses papéis em um curso para serem mostrados na descrição deste curso.';
$string['courselistshortnames'] = 'Mostrar os nomes de curso extendidos';
$string['courselistshortnames_desc'] = 'Se habilitado, os nomes dos cursos serão abreviados, ao invés de mostrar os nomes completos nas listas de cursos. Se necessário, os nomes dos percursos prolongados pode ser personalizado através da edição da string de idioma \'courseextendednamedisplay\' utilizando o recurso de personalização da linguagem.';
$string['coursemgmt'] = 'Gerenciar cursos e categorias';
$string['courseoverview'] = 'Sumário do curso';
$string['courserequestnotify'] = 'Aviso de solicitação de curso';
$string['courserequestnotifyemail'] = 'O usuário {$a->user} solicitou um novo curso em {$a->link}';
$string['courserequests'] = 'Solicitações de cursos';
$string['courserequestspending'] = 'Solicitações de cursos pendentes';
$string['courses'] = 'Cursos';
$string['coursesperpage'] = 'Cursos por página';
$string['courseswithsummarieslimit'] = 'Cursos com limite de resumos';
$string['creatornewroleid'] = 'Papel do criador em cursos novos';
$string['creatornewroleid_help'] = 'Se o usuário não tiver permissão para gerenciar o novo curso, o usuário é automaticamente inscrito com este perfil de usuàrio.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Execução do Cron somente pela linha de comando';
$string['cronerrorclionly'] = 'Desculpe, o acesso a essa página foi desativado pelo administrador.';
$string['cronerrorpassword'] = 'Desculpe, você não forneceu uma senha válida para acessar essa página.';
$string['cron_help'] = 'O script de manutenção cron.php permite que alguns módulos do Moodle executem tarefas em uma base regular, como por exemplo, no caso do envio de cópias de mensagens do fórum. Um mecanismo é necessário para executar o script periodicamente, por exemplo, a cada 5 minutos.';
$string['cronremotepassword'] = 'Senha do Cron para acesso remoto';
$string['cronwarning'] = 'O <a href="cron.php"> script de manutenção cron.php</a> não foi executado há mais de 24 horas.';
$string['ctyperecommended'] = 'Instalar a extensão ctype opcional do PHP para melhorar a performance do site, especialmente se são utilizados idiomas não latinos';
$string['ctyperequired'] = 'A extensão ctype do PHP é necessária para melhorar a performance e a compatibilidade com funcionalidades multilíngua.';
$string['curlcache'] = 'TTL do cache do cURL';
$string['curlrecommended'] = 'Instalar a biblioteca opcional cURL é altamente recomendável para permitir a ativação de Redes Moodle';
$string['curlrequired'] = 'A extensão  cURL PHP é agora requerida pelo Moodle, a fim de se comunicar com os repositórios Moodle.';
$string['curltimeoutkbitrate'] = 'Velocidade a utilizar nos cálculos de tempo limite do cURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Esta configuração é usada para calcular o limite de tempo apropriado durante grandes requisições do cURL. Como parte deste cálculo é realizado uma solitação HTTP HEAD para determinar o tamanho do conteúdo. Configurando esta opção com o valor 0 esta solicitação é desabilitada.';
$string['currenttheme'] = 'Tema corrente.';
$string['customcheck'] = 'Outras verificações';
$string['custommenu'] = 'Menu personalizado';
$string['custommenuitems'] = 'Ítens do menu personalizado';
$string['datarootsecurityerror'] = '<p><strong>AVISO DE SEGURANÇA!</strong></p><p>O seu diretório raiz dataroot está em uma posição errada acessível via web. Todo mundo pode acessar os arquivos e crackers podem obter acessos como administradores do site!</p>
<p><em>Mude</em> o diretório raiz dataroot ({$a}) para uma posição protegida e atualize a configuração de <code>$CFG->dataroot</code> no config.php .</p>';
$string['datarootsecuritywarning'] = 'A configuração do seu site pode não ser segura. Por favor, certifique-se de que o seu diretório dataroot ({$a}) não é diretamente acessível via web.';
$string['dbmigrate'] = 'Migração de Banco de Dados';
$string['dbmigrateconnecerror'] = 'Não foi possível fazer a conexão com a base de dados especificada.';
$string['dbmigrateencodingerror'] = 'A base de dados indicada usa a codificação {$a} em vez de UNICODE/UTF8.<br />Por favor modifique a configuração.';
$string['dbmigratepostgres'] = 'O sistema identificou PostgreSQL como servidor da base de dados. Para continuar a migração você precisa criar manualmente uma nova base de dados com codificação "UNICODE"(PostgreSQL 7) ou "UTF8" (PostgreSQL 8)para arquivar os dados da migração. Por favor escreva abaixo os dados de conexão à nova base de dados para continuar:';
$string['dbmigratewarning'] = 'Faça o backup da base de dados de Moodle antes de iniciar esta operação. Se você não sabe como fazer isto, peça ajuda para o administrador. Durante a migração dos dados o site estará em modalidade de manutenção.';
$string['dbmigratewarning2'] = '<b>Atenção: você está para iniciar o processo de migração da base de dados. Não continue sem verificar que a base de dados tenha sido totalmente salva em um backup.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Este banco de dados migrou para uma nova base de dados UTF8 e está superada. Edite o seu config.php e use a nova base de dados neste Moodle.</font>';
$string['dbmigrationdupfailed'] = 'A duplicação da base de dados faliu provavelmente com o seguinte erro:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Use o banco de dados para informações da sessão';
$string['debug'] = 'Mensagens de debug';
$string['debugall'] = 'TODAS: Mostrar todas as mensagens de debug do PHP';
$string['debugdeveloper'] = 'DESENVOLVEDOR: mensagens extras de debug do Moodle para desenvolvedores';
$string['debugdisplay'] = 'Mostre mensagens de debug';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'MÍNIMO: Mostrar apenas erros fatais.';
$string['debugnone'] = 'NENHUM: Não mostre erros ou alertas.';
$string['debugnormal'] = 'NORMAL: Mostrar erros, avisos e notícias';
$string['debugpageinfo'] = 'Mostrar informações da página';
$string['debugsmtp'] = 'Depurar envio de email';
$string['debugstringids'] = 'Mostrar origem das strings de idiomas.';
$string['debugstringids_desc'] = 'Esta opção foi projetada para ajudar os tradutores. Quando esta opção é habilitada, se você colocar o parâmetro "&strings=1" ao final da URL, ele irá mostrar o ID do string e o módulo de idioma ao lado de cada string de saída.';
$string['debugvalidators'] = 'Mostra links do validador';
$string['defaultcity'] = 'Cidade padrão';
$string['defaultcity_help'] = 'A cidade inserida aqui será a cidade padrão na criação de novas contas de usuários.';
$string['defaultformatnotset'] = 'Erro determinando o padrão de formato de curso. Por favor verifique as configurações do site.';
$string['defaulthomepage'] = 'Página inicial padrão para os usuários.';
$string['defaultrequestcategory'] = 'Categoria padrão para requisição de curso';
$string['defaultsettinginfo'] = 'Padrão: {$a}';
$string['defaultuserroleid'] = 'Papel padrão para todos usuários';
$string['deleteincompleteusers'] = 'Excluir usuários incompletos depois de';
$string['deleteunconfirmed'] = 'Excluir usuários não confirmados depois de';
$string['deleteuser'] = 'Excluir usuário';
$string['density'] = 'Densidade';
$string['denyemailaddresses'] = 'Domínios de emails proibidos';
$string['development'] = 'Desenvolvimento';
$string['devicedetectregex'] = 'Expressões regulares para detecção de dispositivos';
$string['devicedetectregex_desc'] = '<p>Por padrão, o Moodle pode detectar computadores (computadores de mesa, notebooks, etc.), dispositivos móveis (telefones e smartphones), tablets (iPads, tablets Android) e navegadores antigos (usuários do Internet Explorer 6). O seletor de temas pode ser usado para aplicar temas distintos para todos eles. Esta configuração permite que as expressões regulares adicionais que permitem a identificação do tipo de dispositivo (estas expressões regulares têm precedência sobre os tipos padrões).</p>
<p>Por exemplo, você pode entrar a expressão regular \'/(MIDP-1.0|Maemo|Windows CE)/\' para detectar alguns smartphones comuns e incluir o valor de retorno \'featurephone\'. Isto adiciona \'featurephone\' no seletor de temas que permite incluir um tema que seria usado nestes dispositivos. Os demais telefones continuariam a utilizar o tema definido para o tipo de dispositivo móvel.</p>';
$string['devicedetectregexexpression'] = 'Expressão regular';
$string['devicedetectregexvalue'] = 'Valor de retorno';
$string['devicetype'] = 'Tipo de dispositivo';
$string['disableuserimages'] = 'Desabilitar imagens de perfil de usuário';
$string['displayerrorswarning'] = 'Desabilitar a opção PHP <em>display_errors</em> para evitar que dados sensíveis sejam revelados. Isto serve apenas em sites de teste para revisão de código.';
$string['displayloginfailures'] = 'Mostrar falhas de login';
$string['dndallowtextandlinks'] = 'Upload arrastando e soltando textos/links';
$string['docroot'] = 'Diretório raiz do Moodle Docs';
$string['doctonewwindow'] = 'Abrir em uma nova janela';
$string['download'] = 'Download';
$string['edithelpdocs'] = 'Editar documentos de ajuda';
$string['editingnoncorelangfile'] = 'Você está tentando modificar a tradução de um complemento módulo/plugin. Você pode salvar uma tradução de módulos de terceiro apenas na sua pasta local. Você pode querer mover o arquivo com a tradução para o diretório de idiomas do módulo e/ou enviá-lo ao fornecedor do módulo do complemento.';
$string['editlang'] = '<b>Editar</b>';
$string['editorbackgroundcolor'] = 'Cor de fundo';
$string['editordictionary'] = 'Dicionário';
$string['editorfontfamily'] = 'Família da fonte';
$string['editorfontlist'] = 'Lista de fontes';
$string['editorfontsize'] = 'Tamanho da fonte';
$string['editorhidebuttons'] = 'Botões ocultos';
$string['editorkillword'] = 'Filtro de formatação Word';
$string['editorspelling'] = 'Editor de controle ortográfico';
$string['editorspellinghelp'] = 'Habilitar ou desabilitar o controle ortográfico. Funciona apenas se <strong>aspell</strong> for instalado no servidor.';
$string['editstrings'] = 'Editar as expressões';
$string['emailchangeconfirmation'] = 'Confirmação de mudança de email';
$string['emoticonalt'] = 'Texto alternativo';
$string['emoticoncomponent'] = 'Componente de imagem';
$string['emoticonimagename'] = 'Nome de imagem';
$string['emoticons'] = 'Emoticons';
$string['emoticons_desc'] = 'Este formulário define os emoticons (ou smileys) utilizados em seu site. Para remover uma linha da tabela, salve o formulário com um valor vazio em qualquer dos campos requeridos. Para registrar um novo emoticon, preencha os campos na última linha em branco. Para retornar todos os campos para valores padrão, siga o link acima.

* Texto (obrigatório) - Este texto será substituído com a imagem do emoticon. Deve ter pelo menos dois caracteres.
* Nome da imagem (necessário) - O nome do arquivo de imagem do emoticon, sem a extensão, relativo ao diretório do componente pix.
* Componente da imagem (obrigatório) - O componente que fornece o ícone.
* Texto alternativo (opcional) - Identificador da string e do componente do texto alternativo para o emoticon.';
$string['emoticonsreset'] = 'Retornar a configuração de emoticons para os valores padrão';
$string['emoticontext'] = 'Texto';
$string['emptysettingvalue'] = 'Vazio';
$string['enableajax'] = 'Habilitar AJAX';
$string['enableblogs'] = 'Ativar blogs';
$string['enablecalendarexport'] = 'Habilitar exportação do calendário';
$string['enablecomments'] = 'Habilitar comentários';
$string['enablecourserequests'] = 'Habilitar solicitação de curso';
$string['enablecssoptimiser'] = 'Habilitar otimizador de CSS';
$string['enablecssoptimiser_desc'] = 'Quando habilitado, o CSS passará por um processo de otimização antes de  entrar no cache. Esse processo de otimização do CSS remove regras e estilos duplicados, assim como espaços em branco e re-formatações. Note que habilitar esta opção ao mesmo tempo que o "Modo de desginer de tema" é péssimo para a performance, mas ajudará o designer do tema a criar CSS otimizados.';
$string['enabled'] = 'Habilitado';
$string['enabledevicedetection'] = 'Habilitar detecção de dispositivo';
$string['enablegravatar'] = 'Habilitar Gravatar';
$string['enablegravatar_help'] = 'Se habilitado, o Moodle tentará buscar uma foto do perfil do usuário do Gravatar caso o usuário não envie uma imagem.';
$string['enablegroupmembersonly'] = 'Habilitar apenas membros de grupo';
$string['enablemobilewebservice'] = 'Habilitar web service para dispositivos móveis';
$string['enablerecordcache'] = 'Habilitar memória temporária de gravação';
$string['enablerssfeeds'] = 'Habilitar alimentadores RSS';
$string['enablesafebrowserintegration'] = 'Habilitar integração com o Safe Exam Browser';
$string['enablestats'] = 'Habilitar estatísticas';
$string['enabletgzbackups'] = 'Ativar novo formato de backup';
$string['enabletgzbackups_desc'] = 'Se ativado, os backups futuros serão criados em um novo formato de compressão de arquivos de MBZ. (Armazenado internamente como um arquivo. tar.gz). Isso elimina a restrição de tamanho de backup de 4GB e pode melhorar o desempenho. Restore suporta ambos os formatos e que a diferença deve ser transparente para os usuários.';
$string['enabletgzbackups_nozlib'] = 'Extensão PHP \'zlib\' não está disponível. O novo formato de backup usa esta extensão e será desativado até que a zlib esteja instalada e ativada.';
$string['enabletrusttext'] = 'Habilitar conteúdo confiável';
$string['enablewebservices'] = 'Habilitar serviços web (web services)';
$string['enablewsdocumentation'] = 'Documentação de serviços web';
$string['enrolinstancedefaults'] = 'Padrões da instância de inscrição';
$string['enrolinstancedefaults_desc'] = 'Configurações padrão de inscrição em novos cursos.';
$string['enrolmultipleusers'] = 'Inscrever os usuários';
$string['environment'] = 'Ambiente';
$string['environmenterrortodo'] = 'Você deve resolver os problemas indicados acima antes de instalar esta versão de Moodle.';
$string['environmenterrorupgrade'] = 'Aviso: você deve solucionar todos os problemas (erros) de ambiente encontrados acima antes de proceder na atualização desta versão do Moodle! Atualizar sem consertar esses requisitos pode causar problemas como perda de dados. Você está certo de que quer continuar com a atualização?';
$string['environmentmustfixsetting'] = 'Configuração do PHP deve ser alterada.';
$string['environmentok'] = 'O ambiente do seu servidor reúne todos os requisitos mínimos.';
$string['environmentrecommendcustomcheck'] = 'Se esse teste falhar, será indício de um possível problema';
$string['environmentrecommendinstall'] = 'recomendado como instalado/habilitado';
$string['environmentrecommendversion'] = 'a versão {$a->needed} é recomendada e você está usando a versão {$a->current}';
$string['environmentrequirecustomcheck'] = 'Este teste deve funcionar';
$string['environmentrequireinstall'] = 'deve ser instalado e habilitado';
$string['environmentrequireversion'] = 'a versão {$a->needed} é necessária e você está usando a versão {$a->current}';
$string['environmentsettingok'] = 'configuração recomendada detectada';
$string['environmentshouldfixsetting'] = 'Configuração do PHP pode ser alterada.';
$string['environmentxmlerror'] = 'Erro de leitura dos dados do ambiente ({$a->error_code})';
$string['errordeletingconfig'] = 'Ocorreu um erro ao excluir os registros de configuração do plugin \'{$a}\'.';
$string['errorsetting'] = 'Configuração não foi salva:';
$string['errorwithsettings'] = 'Algumas configurações não mudaram devido a um erro.';
$string['everyonewhocan'] = 'Todos que podem "{$a}"';
$string['exceptions'] = 'exceções';
$string['execpathnotallowed'] = 'Definindo caminhos executáveis e locais desabilitados no config.php';
$string['experimental'] = 'Experimental';
$string['experimentalsettings'] = 'Configurações experimentais';
$string['extendedusernamechars'] = 'Permitir caracteres estendidos em "usernames"';
$string['extramemorylimit'] = 'Limite extra de memória para o PHP';
$string['fatalmagicquotesruntime'] = '<p>Erros graves de configuração foram detectados, por favor notifique o administrador do servidor.</p><p>Para funcionar adequadamente, o Moodle precisa que o administrador modifique as configurações do PHP.</p><p><code>magic_quotes_runtime</code> deve ser definido como <code>off</ code>.</p><p>Esta configuração é controlada editando <code>php.ini</ code>, a configuração do Apache/IIS<br/> ou o arquivo <code>.htaccess</code> no servidor.</p>';
$string['fatalsessionautostart'] = '<p>Erros graves de configuração foram detectados, por favor notifique o administrador do servidor.</p><p>Para funcionar adequadamente, o Moodle precisa que o administrador modifique as configurações do PHP.</p><p><code>session.auto_start</code> deve ser definido como <code>off</code>.</p><p>Esta configuração é controlada editando o <code>php.ini</code>, a configuração do Apache/IIS<br/> ou o arquivo <code>.htaccess</code> no servidor.</p>';
$string['filecreated'] = 'Novo arquivo criado';
$string['filestoredin'] = 'Salvar arquivo na pasta:';
$string['filestoredinhelp'] = 'Onde o arquivo será armazenado';
$string['filterall'] = 'Filtrar todas as expressões';
$string['filtermatchoneperpage'] = 'Uma única expressão por página';
$string['filtermatchonepertext'] = 'Uma única expressão por texto';
$string['filters'] = 'Filtros';
$string['filtersettings'] = 'Gerenciar filtros';
$string['filtersettingsgeneral'] = 'Configuração geral de filtros';
$string['filteruploadedfiles'] = 'Filtrar arquivos enviados ao servidor';
$string['forcelogin'] = 'Forçar usuários a autenticar';
$string['forceloginforprofileimage'] = 'Forçar usuários a autenticar para ver imagens de usuários';
$string['forceloginforprofileimage_help'] = 'Se ativado, os usuários devem fazer o login para ver imagens de perfil de usuário e a imagem de usuário padrão será usada em todos os e-mails de notificação.';
$string['forceloginforprofiles'] = 'Forçar usuários a autenticar para perfil';
$string['forcetimezone'] = 'Forçar fuso horário';
$string['formatuninstallwithcourses'] = 'Existem {$a->count} cursos utilizando {$a->format}. Este formato será modificado para {$a->defaultformat} (formato padrão para este site). Alguns dados formatos especificos';
$string['frontpage'] = 'Página principal';
$string['frontpagebackup'] = 'Backup da página principal';
$string['frontpagedefaultrole'] = 'Papel padrão da página principal';
$string['frontpagefilters'] = 'Filtros da página principal';
$string['frontpageloggedin'] = 'Itens da página principal quando logado';
$string['frontpageoverrides'] = 'Permissões da página inicial sobrescrevem';
$string['frontpagequestions'] = 'Questões da página principal';
$string['frontpagerestore'] = 'Restaurar a página principal';
$string['frontpageroles'] = 'Papéis da página principal';
$string['frontpagesettings'] = 'Configurações da página principal';
$string['fullnamedisplay'] = 'Formato de nome completo';
$string['fullnamedisplayprivate'] = 'Formato do nome completo - privado';
$string['gdrecommended'] = 'A extensão GD é utilizada para conversão de imagens, algumas coisas como as imagens do perfil dos usuários não estarão disponíveis caso GD não esteja instalado.';
$string['gdrequired'] = 'A extensão GD é obrigatória por Moodle para conversão de imagem.';
$string['generalsettings'] = 'Configurações gerais';
$string['geoipfile'] = 'Arquivo GeoIP city data';
$string['getremoteaddrconf'] = 'Origem dos endereços IP registrados nos logs';
$string['globalswarning'] = '<p><strong>Aviso de segurança</strong>: para operar propriamente, Moodle requer <br /> que você faça certas mudanças nas configurações atuais do seu PHP.<p/><p>Você <em>deve</em> ajustar<code>register_globals=off</code>.<p>Essa configuração é controlada editando a configuração de <code>php.ini</code>, Apache/IIS <br /> ou <code>.htaccess</code> file.</p>';
$string['googlemapkey3'] = 'Chave da API do Google Maps V3';
$string['googlemapkey3_help'] = 'Você precisa inserir uma chave especial para usar o Google Maps para a visualização do endereço IP de pesquisa. Você pode obter a chave gratuitamente em <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial # api_key</a>';
$string['gotofirst'] = 'Vá para a primeira expressão não traduzida';
$string['gradebook'] = 'Quadro de avaliações';
$string['gradebookroles'] = 'Papéis que são avaliados';
$string['gradeexport'] = 'Métodos de exportação da avaliação primária';
$string['gravatardefaulturl'] = 'URL da imagem padrão gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar precisa de uma imagem padrão para exibir se ele é incapaz de encontrar uma imagem para um determinado usuário. Fornecer uma URL completa de uma imagem. Se você deixar esta opção vazia, Moodle tentará usar a imagem padrão mais adequado para a página que você está vendo. Note-se também que Gravatar tem uma série de códigos que podem ser utilizados para <a href="https://en.gravatar.com/site/implement/images/#default-image">gerar imagens padrão</a> .';
$string['groupenrolmentkeypolicy'] = 'Política de chave para inscrição em grupo';
$string['groupenrolmentkeypolicy_desc'] = 'Habilitar esta opção fará com que o Moodle valide as chaves de inscrição em grupo contra uma política de senhas válida.';
$string['guestroleid'] = 'Papel para convidados';
$string['guestroleid_help'] = 'Este papel é atribuído automaticamente para o usuário convidado (guest). É também atribuído temporariamente a usuários não inscritos, que entram no curso através do plugin de inscrição de convidados. ';
$string['helpadminseesall'] = 'Os administradores devem ver todos os eventos do calendário ou apenas os seus próprios eventos?';
$string['helpcalendarcustomexport'] = 'Ativar opção de exportação de faixa customizada na exportação de calendário. Exportação de calendários precisam ser hablitadas antes que isso seja efetivo.';
$string['helpexportlookahead'] = 'Quantos dias no futuro é que o calendário de eventos durante a olhar para exportação para a opção de exportação personalizado?';
$string['helpexportlookback'] = 'Quantos dias no passado é que o calendário de eventos durante a olhar para exportação para a opção de exportação personalizada?';
$string['helpforcetimezone'] = 'Você pode permitir que os usuários selecionem seus fusos horários ou deseja forçar um único fuso horário para todos.';
$string['helpshowicalsource'] = 'Se habilitado, mostrará o nome de assinatura e o link ao importar os eventos do iCal.';
$string['helpsitemaintenance'] = 'Ativar durante a atualização ou manutenção do sistema.';
$string['helpstartofweek'] = 'Qual é o primeiro dia da semana no calendário?';
$string['helpupcominglookahead'] = 'Quantos dias consecutivos compõem o arco de tempo a ser considerado para a indicação dos Próximos Eventos?';
$string['helpupcomingmaxevents'] = 'Qual é o número máximo de eventos a serem mostrados ao usuário?';
$string['helpweekenddays'] = 'Quais dias da semana são considerados "fim de semana" e mostrados com cor diferente?';
$string['hiddenuserfields'] = 'Ocultar campos de usuários';
$string['hidefromall'] = 'Ocultar de todos os usuários';
$string['hidefromnone'] = 'Não ocultar';
$string['hidefromstudents'] = 'Ocultar dos estudantes';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Configurações do editor HTML';
$string['htmlsettings'] = 'Configurações HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Segurança HTTP';
$string['hubs'] = 'Hubs';
$string['iconvrecommended'] = 'Instalar a extensão ICONV é altamente recomendável para aumentar a performance do site, especialmente quando o site suporta o uso de idiomas não-latinos';
$string['iconvrequired'] = 'Instalar a extensão ICONV é obrigatório.';
$string['ignore'] = 'Ignorar';
$string['includemoduleuserdata'] = 'Incluir dados de usuário do módulo';
$string['incompatibleblocks'] = 'Blocos incompatíveis';
$string['installhijacked'] = 'Desculpe, mas a instalação deve ser concluída a partir do endereço IP original.';
$string['installsessionerror'] = 'A sessão PHP não pôde ser iniciada. Por favor verifique se o seu navegador aceita cookies.';
$string['intlrecommended'] = 'A extensão Intl é utilizada para melhorar o suporte à internacionalização, como a ordenação de informações de forma adequada.';
$string['invalidsection'] = 'Seção inválida';
$string['invaliduserchangeme'] = 'O usuário "changeme" é reservado - você não criar uma conta com ele.';
$string['ipblocked'] = 'Este site está indisponível no momento.';
$string['ipblocker'] = 'Bloqueador de IP';
$string['ipblockersyntax'] = 'Coloque cada entrada em uma linha. As entradas válidas são: o endereço IP completo (como <b>192.168.10.1</b>), que corresponde a um único host; ou endereço parcial (como <b>192.168.</b>) que corresponde a qualquer endereço começando com aqueles números; ou notação CIDR (como <b>231.54.211.0/20</b>); ou um intervalo de endereços IP (como <b>231.3.56.10-20</b>) onde o intervalo se aplica à última parte do endereço. Nomes de domínio textuais (como \'exemplo.com.br\') não são suportados. As linhas em branco serão ignoradas.';
$string['iplookup'] = 'Procurar endereço IP';
$string['iplookupgeoplugin'] = 'O serviço <a href="http://www.geoplugin.com">geoPlugin</a> está atualmente sendo usado para buscar informações geográficas. Para obter resultados mais precisos recomendamos a instalação de uma cópia local da base de dados MaxMind GeoLite.';
$string['iplookupinfo'] = 'Por padrão o Moodle usa o servidor NetGeo(The Internet Geographic Database) livre e disponível na internet para procurar pela localização de endereços IP, infelizmente este banco de dados não é mais mantido e pode retornar dados incorretos.
É recomendado instalar uma cópia local do banco de dados livre GeoLite City de MaxMind.<br/>
Localização de endereço IP é mostrado em mapas simples ou usando Google Maps. Observe que você precisa ter uma conta Google e se solicitar uma chave grátis da API Google Maps para habilitar mapas interativos.';
$string['iplookupmaxmindnote'] = 'Esse produto inclue dados GeoLite criados por MaxMind, disponível em <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Mantenha formato de letra do nome do rótulo';
$string['lang'] = 'Idioma predefinido';
$string['langcache'] = 'Memória temporária da lista de idiomas';
$string['langcache_desc'] = 'Cache o menu de idiomas. Se ativado, a lista de traduções disponíveis fica em cache. O cache é atualizado automaticamente quando você instalar ou excluir um pacote de idiomas através da ferramenta de gerenciamento de idiomas. Se você instaar um novo pacote de idiomas manualmente, você deverá utilizar o recurso de limpeza de todos os caches para atualizar a lista de idiomas disponíveis.';
$string['langlist'] = 'Idiomas presentes na lista';
$string['langmenu'] = 'Mostrar lista de idiomas';
$string['langpackwillbeupdated'] = 'NOTA: O Moodle tentará fazer download de atualizações de seus pacotes de idioma durante esta atualização.';
$string['langstringcache'] = 'Colocar todas as strings de idioma em cache ';
$string['languagesettings'] = 'Configurações de idiomas';
$string['latexpreamble'] = 'Preâmbulo LaTeX';
$string['latexsettings'] = 'Configurações do renderizador LaTeX';
$string['latinexcelexport'] = 'Codificação Excel';
$string['legacyfilesaddallowed'] = 'Permitir a adição de arquivos do curso legados';
$string['legacyfilesaddallowed_help'] = 'Se um curso tem arquivos do curso de legado, permitir que novos arquivos e pastas a serem adicionados a ele.';
$string['legacyfilesinnewcourses'] = 'Arquivos de cursos legados em novos cursos';
$string['legacyfilesinnewcourses_help'] = 'Por padrão, as áreas de arquivos de cursos legados estão disponíveis apenas em cursos atualizados. Por favor, observe que algumas coisas, como backup e restauração de uma única atividade, não são compatíveis com essa configuração.';
$string['licensesettings'] = 'Configurações de licenciamento';
$string['linkadmincategories'] = 'Link para categorias do admin';
$string['linkadmincategories_help'] = 'Caso habilitado categorias de configurações administrativas serão exibidas como links na navegação e irão levar para as páginas de categorias administrativas';
$string['loading'] = 'Carregando';
$string['localetext'] = 'locale do site';
$string['localstringcustomization'] = 'Edição de versão local';
$string['location'] = 'Local';
$string['locationsettings'] = 'Parametrização de local';
$string['locked'] = 'Travado';
$string['lockoutduration'] = 'Duração do bloqueio de conta';
$string['lockoutduration_desc'] = 'Contas bloqueadas são automaticamente desbloqueadas após este período.';
$string['lockoutemailbody'] = 'Sua conta com nome de usuário {$a->username} em &quot;{$a->sitename}&quot; foi bloqueada após várias tentativas de login inválidas.

Para desbloquear a conta, vá para o seguinte endereço

{$a->link}

Na maioria dos programas de e-mail, esta deve aparecer como um link azul que você pode simplesmente clicar. Se isso não funcionar, copie e cole o endereço na barra de endereços no topo da janela do seu navegador. Se precisar de ajuda, por favor, entre em contato com o administrador do site,

{$a->admin}';
$string['lockoutemailsubject'] = 'Sua conta no {$a} foi bloqueada';
$string['lockouterrorunlock'] = 'Informações de desbloqueio inválido conta fornecida.';
$string['lockoutthreshold'] = 'Limite de bloqueio de conta';
$string['lockoutthreshold_desc'] = 'Selecione o número de tentativas de login que resultam em bloqueio de conta. Este recurso pode ser abusado em ataques.';
$string['lockoutwindow'] = 'Conta janela de observação de bloqueio';
$string['lockoutwindow_desc'] = 'Tempo de observação para limite de bloqueio, se não houver tentativas fracassadas o contador limite é reposto após este tempo.';
$string['log'] = 'Logs';
$string['logguests'] = 'Registrar log de acesso de visitantes (guest)';
$string['logguests_help'] = 'Esta configuração permite o registro (log) de ações da conta de visitante (guest)  e usuários não autenticados. Sites muito utilizados  podem querer desativar este log por razões de desempenho. Recomenda-se manter esta opção habilitada nos sites de produção.';
$string['loginhttps'] = 'Use HTTPS para logins';
$string['loginpageautofocus'] = 'Focar automaticamente o formulário da página de login';
$string['loginpageautofocus_help'] = 'Ativar esta opção melhora a usabilidade da página de login, mas os campos com foco automatico podem causar problemas de  acessibilidade.';
$string['loginpasswordautocomplete'] = 'Evitar o preenchimento automático de senha no formulário de login';
$string['loginpasswordautocomplete_help'] = 'Se habilitado, usuários não terão a permissão para salvar a sua senha em seus navegadores.';
$string['loglifetime'] = 'Manter logs por';
$string['longtimewarning'] = '<b>Por favor, note que esse processo pode levar um longo tempo.</b>';
$string['maintenancemode'] = 'Em modo de manutenção';
$string['maintenancemodeisscheduled'] = 'O sites entrará em estado de manutenção em {$a}';
$string['maintfileopenerror'] = 'Erro de abertura dos arquivos de manutenção';
$string['maintinprogress'] = 'Progresso da manutenção...';
$string['manageformats'] = 'Gerenciar formatos de curso';
$string['manageformatsgotosettings'] = 'Formato padrão pode ser modificado em {$a}';
$string['managelang'] = '<b>Administrar</b>';
$string['managelicenses'] = 'Gerenciar licenças';
$string['manageqbehaviours'] = 'Gerenciar o comportamento das questões.';
$string['manageqtypes'] = 'Gerenciar tipos de questões';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Candidato a lançamento';
$string['maturity200'] = 'Versão estável';
$string['maturity50'] = 'Versão Alfa';
$string['maturityallowunstable'] = 'Dica: Você pode rodar esse script com a opção --allow-unstable';
$string['maturitycoreinfo'] = 'Seu site está atualmente rodando uma versão instável "{$a}" de desenvolvimento.';
$string['maturitycorewarning'] = 'A versão do Moodle que você está prestes a instalar ou atualizar contém código de desenvolvimento instável "{$a}" que não é adequada para uso em sites de maior porte em ambiente de produção. Se esta atualização não é o que você deseja, então você deve se certifidar que está atualizando a partir da distribuição STABLE do Moodle. Consulte o Moodle Docs para maiores detalhes.';
$string['maxbytes'] = 'Tamanho máximo de arquivo transmitido';
$string['maxconsecutiveidentchars'] = 'Caracteres consecutivos idênticos';
$string['maxeditingtime'] = 'Tempo máximo para editar postagens';
$string['maxusersperpage'] = 'Máximo de usuários por página';
$string['mbstringrecommended'] = 'A instalação da MBSTRING library é altamente recomendável para melhorar a performanse do site, especialmente se o seu site suporta idiomas não-latinos.';
$string['mediapluginavi'] = 'Ativar filtro .avi';
$string['mediapluginflv'] = 'Ativar filtro .flv';
$string['mediapluginimg'] = 'Habilitar "auto-embedding" de links para imagens';
$string['mediapluginmov'] = 'Ativar filtro .mov';
$string['mediapluginmp3'] = 'Ativar filtro .mp3';
$string['mediapluginmpg'] = 'Ativar filtro .mpg';
$string['mediapluginogg'] = 'Habilitar filtro .ogg';
$string['mediapluginogv'] = 'Habilitar filtro .ogv';
$string['mediapluginram'] = 'Ativar filtro .ram';
$string['mediapluginrm'] = 'Ativar filtro .rm';
$string['mediapluginrpm'] = 'Ativar filtro .rpm';
$string['mediapluginswf'] = 'Ativar filtro .swf';
$string['mediapluginswfnote'] = 'Como uma medida padrão de segurança, usuários normais não tem permissão para colocar arquivos swf de flash.';
$string['mediapluginwmv'] = 'Ativar filtro .wmv';
$string['mediapluginyoutube'] = 'Habilitar filtro de links ao YouTube';
$string['messaging'] = 'Habilitar sistema de mensagens';
$string['messagingallowemailoverride'] = 'Sobreescreve notificações por email';
$string['messagingdeletereadnotificationsdelay'] = 'Excluir notificações já lidas';
$string['messaginghidereadnotifications'] = 'Ocultar notificações já lidas';
$string['minpassworddigits'] = 'Números';
$string['minpasswordlength'] = 'Comprimento da senha';
$string['minpasswordlower'] = 'Letras minúsculas';
$string['minpasswordnonalphanum'] = 'Caracteres não alfanuméricos';
$string['minpasswordupper'] = 'Letras maiúsculas';
$string['misc'] = 'Diversidade';
$string['mnetrestore_extusers'] = '<strong>Nota:</strong> Este arquivo de backup contém contas de usuários remotos do Moodle em Rede';
$string['mnetrestore_extusers_admin'] = '<strong>Nota:</strong> Este arquivo de backup aparentemente foi gerado em outra instalaçao do Moodle e contém contas de usuários remotos da Rede Moodle. O processo de restauração tentará casar os hosts da Rede Moodle para todos os usuário criados. Aqueles que não casarem serão automaticamente alterados para autenticação interna (ao invés de mnet). O log da restauração vai informá-lo sobre isso.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Nota:</strong> Este arquivo de backup aparentemente foi gerado em outra instalação do Moodle e possui contas de usuários remotos da Rede Moodle que podem falhar ao retaurar. Esta operação não é aceita. Se você está certo de que este arquivo foi criado nesta instalação do Moodle, ou você pode assegurar que todos os hosts da Rede Moodle necessários estão configurados, você pode querer ainda tentar restaurá-los.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Nota:</strong> Este arquivo de backup aparentemente foi gerado em outra instalaçao do Moodle e contém contas de usuários remotos da Rede Moodle. Você não tem autorização para executar este tipo de restauração. Contate o administrador do site ou, alternativamente, restaurar este curso sem informações de usuários (módulos, arquivos...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Usuário da Rede Moodle Remota {$a->username} (proveniente de {$a->mnethosturl}) mudou para usuário ($a->auth} autenticado localmente.';
$string['mobile'] = 'Mobile';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Padrão para seletor de atividades';
$string['modeditdefaults'] = 'Valores padrão para configurações de atividade';
$string['modeditingmenu'] = 'Menus de edição de atividades';
$string['modeditingmenu_desc'] = 'Se habilitado, muitos dos ícones de edição de atividades, que são exibidos quando a edição está ligada, serão exibidos como um menu de poções. Isso reduz o conteúdo na tela ao editar um curso escondendo os ícones até que eles sejam necessários.';
$string['modsettings'] = 'Gerenciar atividades';
$string['modulesecurity'] = 'Módulo de segurança';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Forçar a sintaxe antiga de multi-idioma:&lt;span&gt; sem a classe="multilang" e &lt;lang&gt;';
$string['mustenablestats'] = 'As estatísticas ainda não foram habilitadas neste site.';
$string['mycoursesperpage'] = 'Número máximo de cursos';
$string['mydashboard'] = 'Painel de controle padrão do sistema';
$string['mymoodle'] = 'Minha página inicial';
$string['mymoodleredirect'] = 'Forçar usuários a usar Meu Moodle';
$string['mypage'] = 'Minha página inicial padrão';
$string['mypagelocked'] = 'Bloquear página padrão';
$string['myprofile'] = 'Página padrão de perfil';
$string['mysql416bypassed'] = 'Entretanto, se o seu site usa apenas idiomas iso-8859-1 (latin), você pode continuar a usar a sua base de dados atual MySQL 4.1.12 (ou superior).';
$string['mysql416required'] = 'MySQL 4.1.16 é a versão mínima necessária para a instalação do Moodle 1.6 de modo que os dados possam ser convertidos para UTF-8.';
$string['navadduserpostslinks'] = 'Adicionar links para exibir mensagens dos usuários';
$string['navadduserpostslinks_help'] = 'Se habilitado, dois links serão adicionados para cada usuário na navegação, um para ver as discussões que o usuário tenha iniciado e outro para as mensagens o usuário postou em fóruns  do site ou em cursos específicos.';
$string['navcourselimit'] = 'Limite de curso';
$string['navigationupgrade'] = 'Essa atualização introduz dois novos blocos de navegação que irão substituir os seguintes blocos: Administração, Cursos, Atividades e Participantes. Se você definiu alguma permissão especial nestes blocos, você deve se certificar de que tudo está se comportando como você gostaria.';
$string['navshowallcourses'] = 'Mostrar todos os cursos';
$string['navshowcategories'] = 'Mostrar categorias de cursos';
$string['navshowfrontpagemods'] = 'Mostrar atividades da página inicial na navegação';
$string['navshowfrontpagemods_help'] = 'Se habilitada, as atividades da página inicial serão exibidas na navegação sobre as páginas do site.';
$string['navshowfullcoursenames'] = 'Mostrar os nomes completos do curso';
$string['navshowfullcoursenames_help'] = 'Se habilitado, os nomes completos dos cursos serão exibidos na navegação ao invés do nome curto.';
$string['navshowmycoursecategories'] = 'Exibir categorias em Meus cursos';
$string['navshowmycoursecategories_help'] = 'Se habilitado, as categorias de curso serão exibidas em Meus cursos na navegação.';
$string['navsortmycoursessort'] = 'Classificar meus cursos';
$string['navsortmycoursessort_help'] = 'Isso determina se os cursos estão listados em Meus cursos de acordo com a ordem de classificação (ou seja, a ordem definida em Configurações > Administração do Site > Cursos > Adicionar / editar cursos) ou em ordem alfabética pelo ambiente do curso.';
$string['neverdeleteruns'] = 'Nunca excluir execuções';
$string['nobookmarksforuser'] = 'Você não tem nenhum marcador de página.';
$string['nodatabase'] = 'Sem banco de dados';
$string['nohttpsformobilewarning'] = 'É recomendado para habilitar o HTTP com um certificado válido. O ambiente Moodle irá sempre tentar utilizar uma conexão segura em primeiro lugar.';
$string['nomissingstrings'] = 'Não faltam expressões';
$string['nonewsettings'] = 'Nenhuma configuração nova foi adicionada durante esta atualização.';
$string['nonexistentbookmark'] = 'A marca de leitura que você solicitou não existe.';
$string['noresults'] = 'Nenhum resultado encontrado.';
$string['noroles'] = 'Sem papéis';
$string['notifications'] = 'Notificações';
$string['notifyloginfailures'] = 'Email de falhas de login';
$string['notifyloginthreshold'] = 'Limite de notificações por email';
$string['notloggedinroleid'] = 'Papel para visitantes';
$string['numberofmissingstrings'] = 'Número de expressões não traduzidas: {$a}';
$string['numberofstrings'] = 'Número total de expressões: {$a->strings}<br />Faltando: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'PHP cache opcode melhora o desempenho e reduz os requisitos de memória, extensão OPcache é recomendado e totalmente suportado.';
$string['opensslrecommended'] = 'É altamente recomendável a instalação da biblioteca OpenSSL, que é opcional, isto permite a funcionalidade Moodle em Rede.';
$string['opentogoogle'] = 'Aberto para o Google';
$string['optionalmaintenancemessage'] = 'Mensagem opcional de manutenção';
$string['order1'] = 'Primeiro';
$string['order2'] = 'Segundo';
$string['order3'] = 'Terceiro';
$string['order4'] = 'Quarto';
$string['passwordpolicy'] = 'Política de senhas';
$string['passwordresettime'] = 'O tempo máximo para validar o pedido de redefinição de senha';
$string['pathconvert'] = 'Caminho do binário <i>convert</i>';
$string['pathdvips'] = 'Caminho do binário <i>dvips</i>';
$string['pathlatex'] = 'Caminho do binário <i>latex</i>';
$string['pathtoclam'] = 'Caminho para clam AV';
$string['pathtodot'] = 'Caminho para o dot.';
$string['pathtodot_help'] = 'Caminho para dot. Provavelmente algo como /usr/bin/dot. Para ser possível gerar gráficos de arquivos DOT, você deve ter instalado o executável dot e apontá-lo aqui. Note que, por enquanto, isto só é usado pelos recursos de "profiling" (Desenvolvimento->Profiling) do Moodle.';
$string['pathtodu'] = 'Caminho para du';
$string['pathtopgdump'] = 'Caminho do pg_dump';
$string['pathtopgdumpdesc'] = 'Isto é necessário apenas se você tiver mais de um pg_dump no seu sistema (por exemplo, quando diversas versões de postgresql estão instaladas)';
$string['pathtopgdumpinvalid'] = 'Caminho do pg_dump não válido - caminho errado ou não executável';
$string['pathtopsql'] = 'Caminho do psql';
$string['pathtopsqldesc'] = 'Isto é necessário apenas se você tiver mais de um psql no seu sistema (por exemplo, quando diversas versões de postgresql estão instaladas)';
$string['pathtopsqlinvalid'] = 'Caminho do psql não válido - caminho errado ou não executável';
$string['pcreunicodewarning'] = 'è altamente recomendado a utilização PCRE PHP que é compatível com caracteres Unicode.';
$string['perfdebug'] = 'Informação de performance';
$string['performance'] = 'Performance';
$string['pgcluster'] = 'Cluster PostgreSQL';
$string['pgclusterdescription'] = 'PostgreSQL version/cluster parameter
for command line operations.
If you only have one postgresql
on your system or you are not
sure what this is, leave this blank.';
$string['php50restricted'] = 'O PHP 5.0.x apresenta muitos problemas conhecidos, faça o upgrade para a versão 5.1.x ou faça o downgrade para a versão 4.3.x ou 4.4.x';
$string['php533warning'] = 'Recomenda-se utilizar PHP 5.3.3 ou versões superiores.';
$string['phpfloatproblem'] = 'Foi detectado um erro inesperado ao manipular números de ponto flutuante no PHP...';
$string['pleaserefreshregistration'] = 'Seu site foi registrado em moodle.org, por favor, considere atualizar o registro se mudanças significativas ocorreram desde a última atualização em {$a}';
$string['pleaseregister'] = 'Por favor registre este site (em seguida este botão será removido)';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Plugins';
$string['pluginscheck'] = 'Verificação de dependência de plugins';
$string['pluginscheckfailed'] = 'A verificação de dependência falhou para {$a->pluginslist}';
$string['pluginschecktodo'] = 'Você deve resolver todas as requisições de plugin antes de prosseguir com a instalação esta versão do Moodle!';
$string['pluginsoverview'] = 'Visão geral dos Plugins';
$string['pluginsoverviewsee'] = 'Veja a página de <a href="{$a->url}">visão geral de plugins</a> para maiores detalhes';
$string['profilecategory'] = 'Categoria';
$string['profilecategoryname'] = 'Nome da categoria (deve ser único)';
$string['profilecategorynamenotunique'] = 'O nome desta categoria já foi utilizado';
$string['profilecommonsettings'] = 'Configurações comuns';
$string['profileconfirmcategorydeletion'] = 'Há {$a} campo(s) nessa categoria, que será(ão) movido(s) para a categoria acima (ou abaixo se estiver na categoria mais elevada).<br /> Você ainda deseja excluir essa categoria?';
$string['profileconfirmfielddeletion'] = 'Há {$a} registro(s) de usuários para este campo, que será(ão) excluído(s).<br /> Você ainda deseja excluir este campo?';
$string['profilecreatecategory'] = 'Criar uma nova categoria de perfil';
$string['profilecreatefield'] = 'Criar um novo campo de perfil:';
$string['profilecreatenewcategory'] = 'Criando uma nova categoria';
$string['profilecreatenewfield'] = 'Criando uma nova \'{$a}\' campo de perfil';
$string['profiledefaultcategory'] = 'Outros campos';
$string['profiledefaultchecked'] = 'Selecionado por padrão';
$string['profiledefaultdata'] = 'Valor padrão';
$string['profiledeletecategory'] = 'Removendo uma categoria';
$string['profiledeletefield'] = 'Removendo um campo \'{$a}\'';
$string['profiledescription'] = 'Descrição do campo';
$string['profiledscript'] = 'Este script foi colocado no Perfil.';
$string['profiledscriptview'] = 'Exibir informações de perfil para este script';
$string['profileeditcategory'] = 'Editando categoria: {$a}';
$string['profileeditfield'] = 'Editando campo do perfil:{$a}';
$string['profilefield'] = 'Campo de perfil';
$string['profilefieldcolumns'] = 'Colunas';
$string['profilefieldispassword'] = 'Este campo é de senha?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Para transformar o texto em um link, digite uma URL contendo $$, onde $$ será substituído pelo texto. Por exemplo, para transformar um ID do Twitter em um link, digite http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Destino do link';
$string['profilefieldmaxlength'] = 'Comprimento máximo';
$string['profilefieldrows'] = 'Colunas';
$string['profilefields'] = 'Campos de perfil do usuário';
$string['profilefieldsize'] = 'Tamanho de apresentação';
$string['profileforceunique'] = 'A informação deve ser única?';
$string['profileinvaliddata'] = 'Valor inválido';
$string['profilelocked'] = 'Este campo está trancado?';
$string['profilemenudefaultnotinoptions'] = 'O valor padrão não é uma das opções';
$string['profilemenunooptions'] = 'Nenhum menu de opções foi fornecido';
$string['profilemenuoptions'] = 'Menu de opções (um por linha)';
$string['profilemenutoofewoptions'] = 'Você deve fornecer pelo menos 2 opções';
$string['profilename'] = 'Nome';
$string['profilenofieldsdefined'] = 'Nenhum campo foi definido';
$string['profilerequired'] = 'Este campo é obrigatório?';
$string['profileroles'] = 'Papéis visíveis do perfil';
$string['profilesforenrolledusersonly'] = 'Perfís apenas para usuários inscritos';
$string['profileshortname'] = 'Nome breve (deve ser único)';
$string['profileshortnamenotunique'] = 'Este nome breve já está em uso.';
$string['profilesignup'] = 'Mostrar na página de cadastro?';
$string['profilespecificsettings'] = 'Configurações específicas';
$string['profilevisible'] = 'Quem pode ver este campo?';
$string['profilevisibleall'] = 'Visível para todos';
$string['profilevisible_help'] = '<p>Cada campo customizado do perfil pode ser configurado como: invisível, visível por todos ou sómente pelo usuário. A opção \'invisível\' pode ser útil ao administrador que deseja guardar dados privados dos usuários. A opção \'usuário\' pode ser útil em um campo que contém informações sensíveis, enquanto a opção \'todos\' pode ser usado para dados a serem compartilhados com outros usuários.</p>';
$string['profilevisiblenone'] = 'Não visível';
$string['profilevisibleprivate'] = 'Visível para o usuário';
$string['profiling'] = 'Agregação ao perfil.';
$string['profilingallowall'] = 'Agregação contínua ao perfil.';
$string['profilingallowall_help'] = 'Se você habilitar essa opção, então, a qualquer momento, você poderá usar o parâmetro PROFILEALL em qualquer lugar (PGC) para permitir a agregação de todos os scripts executados  durante a sessão Moodle aos perfis. Analogamente, você pode usar o parâmetro PROFILEALLSTOP para pará-lo.';
$string['profilingallowme'] = 'Agregação seletiva ao perfil';
$string['profilingallowme_help'] = 'Se você habilitar essa opção, então poderá, seletivamente, usar o parâmetro PROFILEME em qualquer lugar (PGC) e o script será agregado ao perfil. Analogamente, você pode usar o parâmetro DONTPROFILEME para evitar que isso aconteça.';
$string['profilingautofrec'] = 'Agregação automática ao perfil.';
$string['profilingautofrec_help'] = 'Ao utilizar essa definição, qualquer requisição (de forma aleatória, com base na frequencia especificada - 1 de XXX) será selecionada e automaticamente agregada ao perfil, ficando os resultados armazenados para análise posterior. Note que esta forma de agregação aos perfis segue as definições para inclusão/exclusão. Defina como 0 para desativar agregação automática aos perfis.';
$string['profilingenabled'] = 'Habilitar agregação aos perfis';
$string['profilingenabled_help'] = 'Se você habilitar essa opção, então a agregação aos perfis estará disponível neste site e você será capaz de definir seu comportamento através da configuração das opções a seguir.';
$string['profilingexcluded'] = 'Excluir agregação ao perfil';
$string['profilingexcluded_help'] = 'Lista de URLs a serem excluídas das que serão agregadas ao perfil, de acordo com a definição “Profile These” (separadas por vírgula, saltando wwwroot absoluto, que possam ser chamadas).';
$string['profilingimportprefix'] = 'Prefixo de importação de profiling';
$string['profilingimportprefix_desc'] = 'Para a detecção mais fácil, todas as execuções de profiling importados serão prefixados com o valor especificado aqui.';
$string['profilingincluded'] = 'Agregar estas ao perfil
';
$string['profilingincluded_help'] = 'Lista de URLs  que serão automaticamente agregadas ao perfil, de acordo com a definição (separadas por vírgula, saltando wwwroot absoluto, que possam ser chamadas).
Exemplos: /index.php, /course/view.php.
Também aceita a substituição de caracteres pelo * em qualquer posição. Exemplos: /mod/forum/ * , /mod/*/ view.php.
';
$string['profilinglifetime'] = 'Manter a agregação a perfis em execução';
$string['profilinglifetime_help'] = 'Especifica o tempo que se deseja manter informações sobre a execução de perfis antigos. As mais velhas serão excluidas periodicamente. Observe que isso exclui qualquer execução de perfis marcados como “execução de referência”.';
$string['protectusernames'] = 'Proteger "usernames"';
$string['proxybypass'] = 'Ignorar hosts proxy
';
$string['proxyhost'] = 'Servidor de Proxy';
$string['proxypassword'] = 'Senha de Proxy';
$string['proxyport'] = 'Porta de Proxy';
$string['proxytype'] = 'Tipo de Proxy';
$string['proxyuser'] = 'Usuário do Proxy';
$string['purgecaches'] = 'Excluir tudo que estiver em caches';
$string['purgecachesconfirm'] = 'O Moodle pode armazenar em cache temas, javascript, strings de idioma, textos filtrados, feeds RSS e muitas outras partes de dados calculados. Excluir esses caches irá apagar os dados do servidor e forçar os navegadores a buscar novamente os dados, de modo que você poderá ter certeza de estar vendo os valores mais atualizados produzidos pelo código atual. Não há nenhum perigo em apagar os caches, mas o seu site pode aparecer mais lento por um tempo até que o servidor e os clientes calculem novas informações e as enviem para o cache.';
$string['purgecachesfinished'] = 'Todos os dados armazenados em cache foram excluídos';
$string['qtyperqpwillberemoved'] = 'Durante a migração, o tipo de questão RQP será removido. Como você não estava usando este tipo de questão então não terá problemas.';
$string['qtyperqpwillberemovedanyway'] = 'Durante a migração, as questões do tipo RQP serão removidas. Você tem algumas questões RQP no seu banco de dados e elas não funcionarão a menos que você reinstale o código de http://moodle.org/mod/data/view.php?d=13&amp;rid=797 antes de continuar a migração.';
$string['quarantinedir'] = 'Diretório de quarentena';
$string['question'] = 'Questão';
$string['questionbehaviours'] = 'Comportamento de questão';
$string['questioncwqpfscheck'] = 'Uma ou mais questões aleatórias em uma quiz estão configuradas para selecionar questões de uma mistura de categorias de questões compartilhadas e não-compartilhadas. Há um relatório mais detalhado <a href="{$a->reporturl}">aqui</a> e veja a página Moodle Docs <a href="{$a->docsurl}">aqui</a>.';
$string['questioncwqpfsok'] = 'Certo. Não existe questões \'aleatórias\' em seus questionários que estão configuradas para selecionar categorias de questões que misturem compartilhadas e não compartilhadas.';
$string['questiontype'] = 'Tipo de questão';
$string['questiontypes'] = 'Tipos de questão';
$string['quizattemptsupgradedmessage'] = 'No Moodle 2.1, houve uma grande atualização para no módulo de perguntas. Foi possível adiar partes da atualização do banco de dados para serem executadas mais tarde. Antes de atualizar para o Moodle 2.7, essa atualização deve ser concluída.';
$string['recaptchaprivatekey'] = 'Chave privada ReCAPTCHA';
$string['recaptchapublickey'] = 'Chave pública ReCAPTCHA';
$string['register'] = 'Registre seu site';
$string['registermoodleorg'] = 'Quando você registrar seu site com {$a}';
$string['registermoodleorgli1'] = 'Você está adicionado a uma lista de baixo volume de notificações importantes, tais como alertas de segurança e novas versões do Moodle.';
$string['registermoodleorgli2'] = 'Estatísticas sobre o seu site serão adicionadas ao {$a} da comunidade Moodle em todo o mundo.';
$string['registermoodleorgli3'] = 'Seu site também é registrado com o Hub aberto da Comunidade Moodle.org  ({$a}), permitindo aos usuários a capacidade de cursos de publicação (por padrão, somente administradores) a opção de cursos de publicação para MOOCH.';
$string['registerwithmoodleorg'] = 'Registre-se em Moodle.org';
$string['registration'] = 'Registrar com o Moodle.org';
$string['registration_help'] = 'Registrar o seu site com Moodle.org é recomendado, a fim de receber notificações de alerta de segurança, contribuir com as <a href="http://moodle.org/stats">estatísticas de uso do Moodle</a> e ser capaz de compartilhar cursos on <a href="http://moodle.net/">Moodle.net</a> .';
$string['registrationwarning'] = 'Seu site ainda não está registrado.';
$string['releasenoteslink'] = 'Para obter informações sobre esta versão de Moodle, por favor visite a página <a target="_blank" href="{$a}">Notas sobre a Versão</a>';
$string['rememberusername'] = 'Lembrar usuário';
$string['rememberusername_desc'] = 'Habilite se você deseja armazenar cookies permanentes com "usernames" durante o login do mesmos. Cookies permanentes podem ser considerados um prolema de privacidade, se usados sem consentimento.';
$string['reportsmanage'] = 'Gerenciar relatórios';
$string['requestcategoryselection'] = 'Permitir a seleção da categoria';
$string['requiredentrieschanged'] = '<strong>IMPORTANTE – POR FAVOR LEIA<br/>(Este alerta somente será mostrado durante esta atualização)</strong><br/>Devido à correção de um erro, o comportamento das atividades de banco de dados que usam as definições  "Entradas requeridas” e “Entradas requeridas antes de ver as configurações" vai mudar. Uma explicação mais detalhada das mudanças pode ser lida no <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank"> fórum do módulo bando de dados</a>. O comportamento esperado para estas configuraçõespode também ser lido em <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>.
<br/><br/>Esta mudança afeta os seguintes bancos de dados de seu sistema: (Por favor, salve esta lista agora e, após a atualização, verifique se estas atividades ainda funcionam da forma pretendida pelos professores.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Exigir descrição da atividade';
$string['requires'] = 'Exige';
$string['restorernewroleid'] = 'Papel do usuário restaurador no curso';
$string['restorernewroleid_help'] = 'Se o usuário não tiver permissão para gerenciar o curso recém-restaurado, ele será inscrito automaticamente receberá este papel, se necessário. Selecione "Nenhum" se você não quer que os restauradores sejam capazes de gerenciar todos os cursos restaurados.';
$string['reverseproxy'] = 'Proxy reverso';
$string['riskconfig'] = 'Usuários podem mudar a configuração e comportamento do site';
$string['riskconfigshort'] = 'Risco da configuração';
$string['riskdataloss'] = 'Usuários podem destruir grandes quantidades de conteúdo ou informação';
$string['riskdatalossshort'] = 'Risco de perda de dados';
$string['riskmanagetrust'] = 'Usuários podem mudar configurações de segurança de outros usuários';
$string['riskmanagetrustshort'] = 'Gerenciar segurança';
$string['riskpersonal'] = 'Usuários podem ganhar acesso a informações privadas de outros usuários';
$string['riskpersonalshort'] = 'Risco de privacidade';
$string['riskspam'] = 'Usuários podem enviar "spam" para usuários do site ou para outros';
$string['riskspamshort'] = 'Risco spam';
$string['riskxss'] = 'Usuários podem adicionar arquivos e textos que permitem cross-site scripting (XSS)';
$string['riskxssshort'] = 'Risco de XSS';
$string['roleswithexceptions'] = '{$a->roles}, com {$a->exceptions}';
$string['rssglobaldisabled'] = 'Desabilitado no nível do servidor';
$string['runclamavonupload'] = 'Usar clam AV em envio de arquivos.';
$string['save'] = 'Salvar';
$string['savechanges'] = 'Salvar mudanças';
$string['search'] = 'Pesquisa';
$string['searchinsettings'] = 'Pesquisa em configurações';
$string['searchresults'] = 'Resultados da busca';
$string['sectionerror'] = 'Erro de sessão!';
$string['secureforms'] = 'Usar formulário adicional de segurança';
$string['security'] = 'Segurança';
$string['selectdevice'] = 'Selecione o dispositivo';
$string['selecttheme'] = 'Selecione o tema para o dispositivo {$a}';
$string['server'] = 'Servidor';
$string['serverchecks'] = 'Verificações do servidor';
$string['serverlimit'] = 'Limite do servidor';
$string['sessionautostartwarning'] = '<p>Foi detectado um erro grave de configuração, por favor informe ao administrador do servidor.</p> <p>Para funcionar adequadamente, o Moodle necessita que o administrador modifique as configurações do PHP.</p><p>
<code>session.auto_start</code> deve ser configurado para <code>off</code>.</p><p>Esta configuração é feita editando o <code>php.ini</code>, a configuração do Apache/IIS <br />ou o arquivo <code>.htaccess</code>no servidor.</p>
';
$string['sessioncookie'] = 'Prefixo do Cookie';
$string['sessioncookiedomain'] = 'Domínio do Cookie';
$string['sessioncookiepath'] = 'Caminho do Cookie';
$string['sessionhandling'] = 'Manipulação de sessão';
$string['sessiontimeout'] = 'Tempo limite';
$string['settingfileuploads'] = 'O upload de arquivos é necessário para o funcionamento normal, por favor ative-o na configuração do PHP.';
$string['settingmemorylimit'] = 'Foi detectada memória insuficiente, por favor, aumente o limite de memória nas configurações do PHP.';
$string['settingsafemode'] = 'O Moodle não é totalmente compatível com o "safe mode", por favor peça ao administrador do servidor para desligá-lo. Rodar o Moodle no modo seguro não é suportado, você corre o risco de encontrar vários problemas se fizer isso.';
$string['showcommentscount'] = 'Mostrar o número de comentários';
$string['showdetails'] = 'Mostrar detalhes';
$string['showuseridentity'] = 'Mostra a identidade do usuário';
$string['showuseridentity_desc'] = 'Ao selecionar ou pesquisar usuários, e também ao exibir listas de usuários, esses campos podem ser mostrados, além do nome completo. Os campos são exibidos apenas para usuários que têm habilitação “viewuseridentity” em nível de moodle / site, por padrão, professores e gestores. (Esta opção faz mais sentido se você escolher um ou dois campos que são obrigatórios na sua instituição.)';
$string['simplexmlrequired'] = 'A extensão SimpleXML para o PHP agora é obrigatória para o Moodle.';
$string['sitemaintenance'] = 'O sistema está em manutenção e não está disponível no momento.';
$string['sitemaintenancemode'] = 'Modo de manutenção';
$string['sitemaintenanceoff'] = 'O modo de manutenção foi desativado e o sistema está funcionando normalmente.';
$string['sitemaintenanceon'] = 'O sistema está em modo de manutenção (só os administradores podem entrar).';
$string['sitemaintenanceoncli'] = 'Seu site está em modo de manutenção CLI, nenhum acesso web é permitido.';
$string['sitemaintenancewarning'] = 'O sistema está atualmente em modo de manutenção (só os administradores podem entrar). Para retornar à operação normal, <a href="maintenance.php">desabilite o modo de manutenção</a>.';
$string['sitemaintenancewarning2'] = 'Seu site está em modo de manutenção (somente administradores podem se autenticar). Para retornar este site ao modo normal de operação, <a href="{$a}">desabilite o modo de manutenção</a>.';
$string['sitepolicies'] = 'Políticas do site';
$string['sitepolicy'] = 'URL do site de política';
$string['sitepolicyguest'] = 'URL de políticas do site para visitantes';
$string['sitepolicyguest_help'] = 'Se você tiver uma política de site que todos os visitantes devem visualizar e aceitar antes de utilizar este site, então especifique a URL para isso aqui, caso contrário, deixe este campo em branco. Essa configuração pode conter qualquer URL pública. Nota: o acesso de usuários não autenticados  pode ser impedido com a configuração “forcelogin”.';
$string['sitepolicy_help'] = 'Se você tiver um documento que define regras para o uso do site que todos os usuários tem que ler e aceitar antes de poder navegar, especifique a URL deste documento. Em caso contrário deixe em branco. A URL pode apontar para qualquer arquivo. O local ideal para pôr este arquivo é o diretório \'Arquivos do Site\'.';
$string['sitesectionhelp'] = 'Se selecionado, uma sessão tipo tópico será mostrada na primeira página do site.';
$string['slasharguments'] = 'Use argumentos com barra';
$string['smartpix'] = 'Pesquisa inteligente de pix';
$string['soaprecommended'] = 'Instalar a extensão opcional "soap" é útil para web services e alguns módulos "contrib".';
$string['sort_fullname'] = 'Curso nome completo';
$string['sort_idnumber'] = 'Número de identificação do curso';
$string['sort_shortname'] = 'Nome curto do curso';
$string['sort_sortorder'] = 'Ordem de classificação';
$string['spellengine'] = 'Mecanismo de verificação ortográfica';
$string['spelllanguagelist'] = 'Soletrar lista de idiomas';
$string['splrequired'] = 'A extensão SPL do PHP agora é necessária para o Moodle.';
$string['stats'] = 'Estatísticas';
$string['statsfirstrun'] = 'Intervalo máximo de processamento';
$string['statsmaxruntime'] = 'Máximo tempo de execução';
$string['statsmoodleorg'] = 'estatísticas';
$string['statsruntimedays'] = 'Dias a processar';
$string['statsruntimestart'] = 'Rodar em';
$string['statsuserthreshold'] = 'Limite de estatística para o usuário';
$string['stickyblocks'] = 'Blocos adesivos';
$string['stickyblockscourseview'] = 'Página do curso';
$string['stickyblocksduplicatenotice'] = 'Se os blocos que você acrescenta aqui já estão presentes em uma página específica, serão duplicados.<br />O bloco duplicado pode ser editado mas não é possível editar o bloco fixo.';
$string['stickyblocksmymoodle'] = 'Meu Moodle';
$string['stickyblockspagetype'] = 'Tipo de página a ser configurada';
$string['strictformsrequired'] = 'Validação estrita de campos obrigatórios';
$string['stripalltitletags'] = 'Remover tags HTML de todos os nomes das atividades';
$string['supportcontact'] = 'Contato para suporte técnico';
$string['supportemail'] = 'Email de suporte';
$string['supportname'] = 'Nome de suporte';
$string['supportpage'] = 'Página de suporte';
$string['suspenduser'] = 'Suspender conta de usuário';
$string['switchlang'] = 'Trocar diretório de idioma';
$string['systempaths'] = 'Caminhos do sistema';
$string['tablenosave'] = 'Mudanças na tabela acima são salvas automaticamente.';
$string['tablesnosave'] = 'Alterações nas tabelas acima são salvas automaticamente.';
$string['tabselectedtofront'] = 'Em tabelas com tabulação, a linha que foi selecionada deve estar na frente';
$string['tabselectedtofronttext'] = 'Trazer as colunas selecionadas para frente';
$string['testsiteupgradewarning'] = 'Você está usando o site de teste {$a}, para atualizá-lo usar corretamente a ferramenta de interface de linha de comando';
$string['themedesignermode'] = 'Modo de designer de tema
';
$string['themelist'] = 'Lista de temas';
$string['themenoselected'] = 'Nenhum tema selecionado';
$string['themeresetcaches'] = 'Limpar o cache de temas';
$string['themeselect'] = 'Trocar tema';
$string['themeselector'] = 'Seletor de tema';
$string['themesettings'] = 'Configurações de tema';
$string['therewereerrors'] = 'Os dados continham erros';
$string['thirdpartylibrary'] = 'Biblioteca';
$string['thirdpartylibrarylocation'] = 'Localização';
$string['thirdpartylibs'] = 'Bibliotecas de terceiros';
$string['timezone'] = 'Fuso-horário padrão';
$string['timezoneforced'] = 'Fuso horário fixado pelo administrador';
$string['timezoneisforcedto'] = 'Forçar todos os usuários a usar';
$string['timezonenotforced'] = 'O usuário pode escolher seu fuso horário';
$string['tokenizerrecommended'] = 'É recomendado instalar extensão Tokenizer do PHP, que é opcional, isto incrementa a funcionalidade do Moodle em Rede.';
$string['tools'] = 'Ferramentas administrativas';
$string['toolsmanage'] = 'Gerenciar ferramentas administrativas';
$string['unattendedoperation'] = 'Operação não realizada';
$string['unbookmarkthispage'] = 'Desmarcar esta página';
$string['unicoderecommended'] = 'É recomendado que todos os dados sejam armazenados em Unicode (UTF-8). Instalações novas devem ser construídas em banco de dados que tenham o seu conjunto de caracteres padrão em Unicode. Se você está migrando, você deverá executar o processo de migração para o UTF-8. (veja a página do Admin)';
$string['unicoderequired'] = 'É obrigatório que você guarde todos os seus dados no formato Unicode (UTF-8). Instalações novas devem ser construidas em banco de dados que tenham o seu conjunto de caracteres padrão em Unicode. Se você está migrando, você deverá executar o processo de migração para o UTF-8. (veja a página do Admin)';
$string['uninstallplugin'] = 'Desinstalar';
$string['unlockaccount'] = 'Desbloquear a conta';
$string['unsettheme'] = 'Tema não definido';
$string['unsupported'] = 'Não tem suporte';
$string['unsuspenduser'] = 'Ativar conta de usuário';
$string['updateaccounts'] = 'Atualizar contas existentes';
$string['updateautocheck'] = 'Verificar automaticamente novas atualizações';
$string['updateautocheck_desc'] = 'Se habilitada, seu site irá buscar automaticamente por atualizações disponíveis tanto do Moodle como dos plugins. Se houver uma nova ataulização, uma notificação será enviada aos administradores.';
$string['updateautodeploy'] = 'Habilitar implementação de atualizações';
$string['updateautodeploy_desc'] = 'Caso habilitado, você será capaz de baixar e instalar alterações disponíveis diretamente a partir da página Moodle de administração. Note que seus processos do servidor web devem possuir acesso de escrita nos diretórios da instalação do Moodle para funcionar. Isto pode ser visto como um potencial risco de segurança';
$string['updateavailable'] = 'Há uma nova versão do Moodle disponível!';
$string['updateavailabledetailslink'] = 'Veja {$a->url} para mais detalhes';
$string['updateavailableforplugin'] = 'Existe uma nova versão disponível para algum dos seus plugins!';
$string['updateavailableinstall'] = 'Instalar esta atualização';
$string['updateavailable_moreinfo'] = 'Mais informações...';
$string['updateavailablenot'] = 'Seu código do Moodle está atualizado!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versão {$a}';
$string['updatecomponent'] = 'Atualizar componente';
$string['updateminmaturity'] = 'Maturidade mínima do código';
$string['updateminmaturity_desc'] = 'Notificações a respeito de atualizações são enviadas somente se o código tiver a maturidade selecionada. Atualizações de plugins que não declaram a maturidade do código são sempre reportadas sem levar em conta esse dado.';
$string['updatenotificationfooter'] = 'Seu site Moodle {$a->siteurl} está configurado para verificar automaticamente por atualizações disponíveis. Você está recebendo esta mensagem como administrador desse site. Você pode desabilitar as verificações automáticas por atualizações disponíveis na administração do site. Você pode customizar o envio desta mensagem na seção de configuração do seu perfil.';
$string['updatenotifications'] = 'Notificações de atualização';
$string['updatenotificationsubject'] = 'Há atualizações disponíveis para seu site Moodle
({$a->siteurl})';
$string['updatenotifybuilds'] = 'Notificar sobre novas compilações';
$string['updatenotifybuilds_desc'] = 'Se habilitada, as atualizações disponíveis para o código do Moodle tambem serão reportadas quando uma nova compilação da versão atual estiver disponível. As compilações introduzem melhorias continuas em uma dada versão do Moodle e são liberadas semanalmente. Se desabilitada, as atualizações disponíveis somente serão reportadas quando houver uma nova versão do Moodle. As verificações de plugins não são afetadas por essa configuração.';
$string['upgrade197notice'] = '<p>O Moodle 1.9.7 contém várias atualizações de segurança relativas às senhas dos usuários e ao backup para proteger os dados dos usuário no seu site. Como resultado algumas das suas configurações e permissões relativas ao backup podem ter sido alteradas.<br />Veja as <a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">notas de lançamento do Moodle 1.9.7</a> para mais detalhes.</p>';
$string['upgrade197noticesubject'] = 'Avisos de atualizações de segurança do Moodle 1.9.7';
$string['upgrade197salt'] = 'Para reduzir o risco de roubo de senhas, é fortemente recomendado definir um "sal" para a senha.<br />Veja a <a href="{$a}" target="_blank">documentação sobre sal nas senhas</a> para mais detalhes.';
$string['upgradeerror'] = 'Erro desconhecido atualizando {$a->plugin} para a versão {$a->version}, não é possível prosseguir.';
$string['upgradeforumread'] = 'No Moodle 1.5 foi adicionada a possibilidade de monitorar as mensagens lidas/não lidas.<br />Para usar esta funcionalidade você precisa <a href="{$a}">atualizar as suas tabelas</a>';
$string['upgradeforumreadinfo'] = 'No Moodle 1.5 foi adicionada a possibilidade de monitorar as mensagens lidas/não lidas. Para usar esta funcionalidade, você precisa atualizar as tabelas que registram as informações das mensagens existentes. Dependendo do tamanho de sua instalação, isto pode tomar bastante tempo (horas) e pode exigir bastante do banco de dados, portanto é melhor fazê-lo num período de pouco uso. Enquanto isto a sua instalação continuará funcionando e os usuários não serão afetados. Uma vez iniciado este processo, permitir que seja concluído (mantenha a janela de seu navegador aberta). Se você interromper o processo fechando a janela, não se preocupe, você pode começar novamente.<br /><br />Quer iniciar o processo de atualização agora?';
$string['upgradelogs'] = 'Para o funcionamento completo os logs antigos tem que ser atualizados. <a href="{$a}">Mais informações</a>';
$string['upgradelogsinfo'] = 'Para que os logs antigos possam ser consultados em conexão com as atividades correspondentes, estes devem ser atualizados e arquivados segundo os novos parâmetros da aplicação. Se o seu site for muito grande este processo pode demorar algumas horas e sobrecarregar a base de dados. Não interrompa o processo, depois de iniciá-lo mantenha a janela do navegador aberta. Não se preocupe, os usuários poderão continuar a navegar no site durante este processo.<br /><br /> Você quer iniciar a atualização agora?';
$string['upgradepluginsfirst'] = 'Recomenda-se instalar todas as atualizações disponíveis primeiro';
$string['upgradepluginsinfo'] = 'Atualizando plugins';
$string['upgradepluginsinfo_help'] = 'Há atualizações disponíveis para alguns de seus plugins. Você deve instalar todos antes da atualização do banco de dados do Moodle. Se o seu site não suporta a instalação automática de atualizações, você tem que baixar e instalar novas versões do plugin no seu servidor manualmente.';
$string['upgradesettings'] = 'Novas configurações';
$string['upgradesettingsintro'] = 'A configuração mostrada abaixo foi adicionada durante a sua última migração do Moodle. Faça as alterações necessárias ao padrão e clique o botão &quot;Salvar Alterações&quot; no final desta página.';
$string['upgradestalefiles'] = 'Versões do Moodle misturadas detectadas, atualização não pode continuar';
$string['upgradestalefilesinfo'] = 'O processo de atualização do Moodle foi interrompido porque os scripts PHP de pelo menos duas versões principais foram detectados no diretório Moodle.

Isso pode causar sérios problemas mais tarde. Para continuar, você deve garantir que o diretório Moodle contenha apenas os arquivos de uma única versão do Moodle.

A maneira recomendada para limpar seu diretório Moodle é a seguinte:

* renomear o diretório atual do Moodle para "moodle_old"
* criar um novo diretório contendo apenas os arquivos obtidos via download de um pacote-padrão do Moodle, ou a partir do repositório Git do Moodle
* mover o config.php original e quaisquer plugins não-padrão do diretório "moodle_old" para o novo diretório.

Quando você tiver um diretório Moodle "limpo", atualize esta página para prosseguir com o processo de atualização.

Este aviso é frequentemente causado ao descompactar um pacote-padrão do Moodle sobre uma versão anterior. Enquanto isto é aceitável para pequenas atualizações, é fortemente não recomendada para grandes atualizações do Moodle.

Esta advertência também pode ser causada por um "checkout" ou operação de atualização incompleta do repositório Git: neste caso, aguarde a conclusão da operação, ou execute o comando apropriado de limpeza e repita a operação.

Você pode encontrar mais informações na documentação de atualização em <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Atualizar base de dados do Moodle agora';
$string['upgradesure'] = '<p> Seus arquivos do Moodle foram alterados, e você está prestes a atualizar automaticamente o seu servidor para esta versão: </p>
<p> <strong>{$a}</strong> </p>
<p> Uma vez que você fizer isso, você não pode voltar novamente. Por favor, note que este processo pode levar um longo tempo. </p>
<p> Você tem certeza de que deseja atualizar este servidor para esta versão? </p>';
$string['upgradetimedout'] = 'O tempo de atualização expirou, por favor, reinicie a operação.';
$string['upgradingdata'] = 'Atualizando os dados';
$string['upgradinglogs'] = 'Atualizando logs';
$string['upgradingversion'] = 'Atualizando para nova versão';
$string['upwards'] = 'para cima';
$string['useblogassociations'] = 'Habilitar associações';
$string['useexternalyui'] = 'Use bibliotecas YUI online
';
$string['user'] = 'Usuário';
$string['userbulk'] = 'Ações em lote sobre usuários';
$string['userlist'] = 'Mostrar lista de usuários';
$string['userpolicies'] = 'Políticas para usuários';
$string['userpreference'] = 'Preferências de usuário';
$string['userquota'] = 'Cota de usuário';
$string['users'] = 'Usuários';
$string['usesitenameforsitepages'] = 'Use nome do site para as páginas do site';
$string['usetags'] = 'Funcionalidade de habilitar rótulos';
$string['validateerror'] = 'Este valor não era válido:';
$string['verifychangedemail'] = 'Restringir domínios quando na alteração do endereço de email';
$string['warningcurrentsetting'] = 'Valor atual inválido: {$a}';
$string['warningiconvbuggy'] = 'Sua versão da biblioteca iconv não suporta o / / IGNORE modificador. Você deve instalar a extensão mbstring o que pode ser usado em vez de cordas de limpeza que contenham caracteres UTF-8 inválidos.';
$string['webproxy'] = 'Proxy web';
$string['webproxyinfo'] = 'Preencher as opções a seguir se o seu servidor Moodle não pode acessar a internet diretamente. O acesso à internet é necessário para o download dos dados do ambiente, pacotes de idiomas, RSS, fusos-horários, etc.<br /><em>A extensão PHP cURL é altamente recomendada.</em>';
$string['xmlrpcrecommended'] = 'Instalar a extensão opcional xmlrpc é útil para a funcionalidade Moodle Networking e necessária para a comunicação em hubs.';
$string['yuicomboloading'] = 'Carregamento do combo YUI';
$string['ziprequired'] = 'A extensão Zip do PHP é obrigatória. Binários infoZIP ou PclZip não são mais utilizados.';
$string['zlibenabled'] = 'zlib habilitada';
