<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'ja', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'アクセスコントロール';
$string['actionaftercorrectanswer'] = '正解後のアクション';
$string['actionaftercorrectanswer_help'] = '問題に正しく答えた後、ページの移動には3つのオプションがあります:

*通常 - レッスンパスに従います。
*未閲覧のページを表示する - ページがランダムに表示されます。同一ページが2度表示されることはありません。
*未解答のページを表示する - ページがランダムに表示されます。未解答の問題を含むページは再度表示されます。';
$string['actions'] = 'アクション';
$string['activitylink'] = '次の活動にリンクする';
$string['activitylink_help'] = '<p>ドロップダウンメニューには、このコースのすべての活動が含まれています。活動の1つが選択された場合、その活動へのリンクがレッスンの最後に表示されます。</p>';
$string['activitylinkname'] = '{$a} へ移動する';
$string['activityoverview'] = 'あなたには有効期限の到来したレッスンがあります。';
$string['addabranchtable'] = 'コンテンツページを追加する';
$string['addanendofbranch'] = '終了ブランチを追加する';
$string['addanewpage'] = '新しいページを追加する';
$string['addaquestionpage'] = '問題ページを追加する';
$string['addaquestionpagehere'] = '問題ページをここに追加する';
$string['addbranchtable'] = 'コンテンツページを追加する';
$string['addcluster'] = 'クラスタを追加する';
$string['addedabranchtable'] = 'コンテンツページが追加されました。';
$string['addedanendofbranch'] = '終了ブランチが追加されました。';
$string['addedaquestionpage'] = '問題ページが追加されました。';
$string['addedcluster'] = 'クラスタが追加されました。';
$string['addedendofcluster'] = '終了クラスタが追加されました。';
$string['addendofcluster'] = '終了クラスタを追加する';
$string['addpage'] = 'ページを追加する';
$string['anchortitle'] = 'メインコンテンツの開始';
$string['and'] = 'AND';
$string['answer'] = '答え/選択肢';
$string['answeredcorrectly'] = '正しく解答されました。';
$string['answersfornumerical'] = '数値問題に対する解答は最大値および最小値の範囲内に入る必要があります。';
$string['arrangebuttonshorizontally'] = 'コンテンツボタンを水平に配置しますか?';
$string['attempt'] = '受験: {$a}';
$string['attempts'] = '受験';
$string['attemptsdeleted'] = '受験結果が削除されました。';
$string['attemptsremaining'] = 'あなたには {$a} 回の受験回数が残っています。';
$string['available'] = '開始日時';
$string['averagescore'] = '平均評点';
$string['averagetime'] = '平均時間';
$string['branch'] = 'コンテンツ';
$string['branchtable'] = 'コンテンツ';
$string['cancel'] = 'キャンセル';
$string['cannotfindanswer'] = 'エラー: 答えが見つかりませんでした。';
$string['cannotfindattempt'] = 'エラー: 受験が見つかりませんでした。';
$string['cannotfindessay'] = 'エラー: 作文が見つかりませんでした。';
$string['cannotfindfirstgrade'] = 'エラー: 評点が見つかりませんでした。';
$string['cannotfindfirstpage'] = '最初のページが見つかりませんでした。';
$string['cannotfindgrade'] = '評定レコードが見つかりませんでした。';
$string['cannotfindnewestgrade'] = 'エラー: 最新の評点が見つかりませんでした。';
$string['cannotfindnextpage'] = 'レッスンバックアップ: 次のページが見つかりませんでした!';
$string['cannotfindpagerecord'] = '終了ブランチを追加する: ページレコードが見つかりませんでした。';
$string['cannotfindpages'] = 'レッスンページが見つかりませんでした。';
$string['cannotfindpagetitle'] = '削除の確認: ページタイトルが見つかりませんでした。';
$string['cannotfindpreattempt'] = '前回の受験レコードが見つかりませんでした!';
$string['cannotfindrecords'] = 'エラー: レッスンレコードが見つかりませんでした。';
$string['cannotfindtimer'] = 'エラー: lesson_timerレコードが見つかりませんでした。';
$string['cannotfinduser'] = 'エラー: ユーザが見つかりませんでした。';
$string['canretake'] = '{$a} の再受験を許可する';
$string['casesensitive'] = '正規表現を使用する';
$string['casesensitive_help'] = 'この設定を有効にした場合、解答の分析に正規表現を使用します。';
$string['checkbranchtable'] = 'コンテンツページを確認する';
$string['checkedthisone'] = 'チェックされました。';
$string['checknavigation'] = 'ナビゲーションを確認する';
$string['checkquestion'] = '問題を確認する';
$string['classstats'] = 'クラス統計';
$string['clicktodownload'] = 'ファイルをダウンロードするには、次のリンクをクリックしてください。';
$string['clicktopost'] = 'あなたの得点をハイスコアリストに登録するには、ここをクリックしてください。';
$string['cluster'] = 'クラスタ';
$string['clusterjump'] = 'クラスタ内の未閲覧の問題';
$string['clustertitle'] = 'クラスタ';
$string['collapsed'] = '折りたたむ';
$string['comments'] = 'あなたのコメント';
$string['completed'] = '完了';
$string['completederror'] = 'レッスンを完了する';
$string['completethefollowingconditions'] = '先へ進むには、<b>{$a}</b> レッスンの下記の状態を完了させる必要があります。';
$string['conditionsfordependency'] = '依存条件';
$string['configactionaftercorrectanswer'] = '正解後にとられるデフォルトのアクションです。';
$string['configmaxanswers'] = 'ページごとの答えの最大数のデフォルトです。';
$string['configmaxhighscores'] = '表示されるハイスコア数です。';
$string['configmediaclose'] = 'リンク済みメディアファイルに生成されるポップアップの一部に「ウィンドウを閉じる」ボタンを表示します。';
$string['configmediaheight'] = 'リンク済みメディアファイルに表示されるポップアップの高さを設定します。';
$string['configmediawidth'] = 'リンク済みメディアファイルに表示されるポップアップの幅を設定します。';
$string['configslideshowbgcolor'] = '有効にされた場合に使用されるスライドショーの背景色を設定します。';
$string['configslideshowheight'] = '有効にされた場合に使用されるスライドショーの高さを設定します。';
$string['configslideshowwidth'] = '有効にされた場合に使用されるスライドショーの幅を設定します。';
$string['confirmdelete'] = 'ページを削除する';
$string['confirmdeletionofthispage'] = '本当にこのページを削除してもよろしいですか?';
$string['congratulations'] = 'おめでとうございます - レッスンの最後に到達しました。';
$string['continue'] = '続ける';
$string['continuetoanswer'] = '続けて答えを変更します。';
$string['continuetonextpage'] = '続けて次のページに移動します。';
$string['correctanswerjump'] = '正解のジャンプ先';
$string['correctanswerscore'] = '正解の評点';
$string['correctresponse'] = '正解に対するレスポンス';
$string['createaquestionpage'] = '問題ページを作成する';
$string['credit'] = '承認';
$string['customscoring'] = 'カスタムスコア';
$string['customscoring_help'] = '<p>ここではそれそれの答えに評点を設定することができます。評点には、マイナスまたはプラスの値を使用することができます。インポートされた問題には、自動的に正解に1点、不正解に0点が割り当てられますが、インポートの後で変更することができます。</p>';
$string['deadline'] = '終了日時';
$string['defaultessayresponse'] = 'あなたの作文は、あなたの教師によって評定されます。';
$string['deleteallattempts'] = 'すべてのレッスン受験を削除する';
$string['deletedefaults'] = '{$a} x レッスンデフォルトを削除しました。';
$string['deletedpage'] = 'ページを削除しました';
$string['deleting'] = '削除中';
$string['deletingpage'] = 'ページの削除: {$a}';
$string['dependencyon'] = '依存対象';
$string['dependencyon_help'] = 'この設定により、現在のレッスンを同一コース内の別レッスンにおける学生の成績に依存させることができます。「利用時間」「完了」または「評点が上」のどのような組み合わせでも使用することができます。';
$string['description'] = '説明';
$string['detailedstats'] = '詳細統計';
$string['didnotanswerquestion'] = 'この問題に答えていません。';
$string['didnotreceivecredit'] = '承認なし';
$string['displaydefaultfeedback'] = 'デフォルトフィードバックを使用する';
$string['displaydefaultfeedback_help'] = '<p>「<strong>Yes</strong>」を選択すると、問題のレスポンスが見つからない場合、デフォルトレスポンスの「正解です」および「不正解です」が使用されます。</p>
<p>「<strong>No</strong>」を選択すると、 問題のレスポンスが見つからない場合、フィードバックは表示されません。レッスンを受験しているユーザは、自動的に次のレッスンページにリダイレクトされます。</p>';
$string['displayhighscores'] = 'ハイスコアを表示する';
$string['displayinleftmenu'] = '左メニューに表示しますか?';
$string['displayleftif'] = 'メニューを表示するための最小評点';
$string['displayleftif_help'] = 'この設定では左側メニューが表示される前に、学生が特定の評点を取得する必要があるかどうか設定します。これにより最初の受験でレッスンすべてを通すことを学生に強制します。要求される評点を取得した後、学生はレビューのために左側メニューを使用することができます。';
$string['displayleftmenu'] = '左メニューを表示する';
$string['displayleftmenu_help'] = '有効にした場合、ページ一覧が表示されます。';
$string['displayofgrade'] = '評点を表示する (学生のみ)';
$string['displayreview'] = '問題の再受験オプションを提供する';
$string['displayreview_help'] = '有効にした場合、問題が不正解のときに学生が評点なしで再受験する、またはレッスンを続けるオプションを提供します。';
$string['displayscorewithessays'] = '<p>自動評定によるあなたの評点は、{$a->tempmaxgrade} 点中 {$a->score} 点です。</p>
<p> 作文問題 {$a->essayquestions} が評定され、後日あなたの最終評点に追加されます。</p>
<p> 作文問題を除くあなたの現在の評点は、{$a->grade} 点中 {$a->score} 点です。</p>';
$string['displayscorewithoutessays'] = 'あなたの評点は、 {$a->score} ({$a->grade} 点中)です。';
$string['edit'] = '編集';
$string['editingquestionpage'] = '{$a} 問題ページの編集';
$string['editlessonsettings'] = 'レッスン設定を編集する';
$string['editpage'] = 'ページコンテンツを編集する';
$string['editpagecontent'] = 'ページコンテンツを編集する';
$string['email'] = 'メール';
$string['emailallgradedessays'] = 'すべての作文問題の評定結果を<br />メール送信する';
$string['emailgradedessays'] = '作文問題の評定結果をメール送信する';
$string['emailsuccess'] = 'メールが正常に送信されました。';
$string['emptypassword'] = 'パスワードは空白にできません。';
$string['endofbranch'] = '終了ブランチ';
$string['endofcluster'] = '終了クラスタ';
$string['endofclustertitle'] = '終了クラスタ';
$string['endoflesson'] = 'レッスン終了';
$string['enteredthis'] = '入力されました。';
$string['entername'] = 'ハイスコアリストのニックネームを入力してください。';
$string['enterpassword'] = 'パスワードを入力してください:';
$string['eolstudentoutoftime'] = 'お知らせ: このレッスンの制限時間が終了しました。制限時間終了後に答えた場合、解答内容はカウントされません。';
$string['eolstudentoutoftimenoanswers'] = 'あなたはどの問題にも解答していません。このレッスンのあなたの評点は、0点です。';
$string['essay'] = '作文問題';
$string['essayemailmessage'] = '<p>作文問題:<blockquote>{$a->question}</blockquote></p>
<p>あなたの解答:<blockquote><em>{$a->response}</em></blockquote></p>
<p>{$a->teacher} のコメント:<blockquote><em>{$a->comment}</em></blockquote></p>
<p>この作文問題の評点は {$a->earned} /{$a->outof} です。</p>
<p>あなたのレッスンの評点は {$a->newgrade}&#37; に変更されました。</p>';
$string['essayemailmessage2'] = '<p>作文問題:<blockquote>{$a->question}</blockquote></p>
<p>あなたの解答:<blockquote><em>{$a->response}</em></blockquote></p>
<p>評価者のコメント:<blockquote><em>{$a->comment}</em></blockquote></p>
<p>この作文問題の評点は {$a->earned} /{$a->outof} です。</p>
<p>あなたのレッスンの評点は {$a->newgrade}&#37; に変更されました。</p>';
$string['essayemailsubject'] = '{$a} 問題に対するあなたの評点';
$string['essays'] = '作文問題';
$string['essayscore'] = '作文問題の評点';
$string['fileformat'] = 'ファイルフォーマット';
$string['finish'] = '終了';
$string['firstanswershould'] = '最初の答えは「正しい」ページにジャンプしてください。';
$string['firstwrong'] = 'あなたの解答が正しくないため、残念ですが得点できませんでした。学ぶ楽しさのために再度解答しますか (得点はできません)?';
$string['flowcontrol'] = 'フローコントロール';
$string['full'] = '展開する';
$string['general'] = '一般設定';
$string['gotoendoflesson'] = 'レッスンの最後に移動する';
$string['grade'] = '評点';
$string['gradebetterthan'] = '評点が上 (&#37;)';
$string['gradebetterthanerror'] = '{$a} パーセントより多い評点が与えられています。';
$string['gradeessay'] = '作文問題の評定 (評定未了: {$a->notgradedcount} 件、送信未了 {$a->notsentcount} 件)';
$string['gradeis'] = '評点は {$a} です';
$string['gradeoptions'] = '評定オプション';
$string['handlingofretakes'] = '再受験の評定方法';
$string['handlingofretakes_help'] = '<p>学生がレッスンを再受験できる場合、このオプションを設定することにより、教師は評定ページでレッスンの評点を表示することができます。例えば、評定ページで最初および以降の受験の<b>評点平均</b>、または学生の受験の<b>最高評点</b>を評点として表示できます。</p>

<p>このオプションは、常に変更することができます。</p>';
$string['havenotgradedyet'] = '未評定';
$string['here'] = '　';
$string['highscore'] = '最高評点';
$string['highscores'] = 'ハイスコア';
$string['hightime'] = '最長時間';
$string['importcount'] = '{$a} の問題をインポート';
$string['importquestions'] = '問題をインポートする';
$string['importquestions_help'] = '<p>フォームを通してアップロードされた外部テキストファイルから問題をインポートすることができます。</p>

<p>下記のように多くのファイルフォーマットをサポートします:</p>

<h2>GIFTフォーマット</h2>
<div class="indent">
<p>GIFTは、テキストファイルからMoodle小テストに問題をインポートするための、最も統合的なインポートフォーマットです。GIFTは、教師が問題をテキストファイルで簡単に書くことができるよう設計されています。多肢選択問題、、○/×問題、記述問題、組み合わせ問題、数値問題、_____を挿入することで「穴埋め問題」をサポートします。様々なタイプの問題およびコメント、問題名、フィードバック、評点の加重割合を1つのテキストファイルに記述することができます。以下に例をあげます:</p>
<pre>
グラントの墓には誰が埋められていますか?{~グラント ~ジェファーソン =誰も埋められていない}

グラントはグラントの墓に {~埋められている =埋葬されている ~生きている} 。

グラントはグラントの墓に埋められている。{FALSE}

グラントの墓には誰が埋められていますか?{=誰も埋められていない =1人も埋められていない}

ユリシーズ S. グラントは、いつ生まれましたか?{#1822}
</pre>

<p class="moreinfo"><a href="help.php?file=formatgift.html&module=quiz">「GIFT」フォーマットの詳細情報</a></p>
</div>

<h2>Aikenフォーマット</h2>
<div class="indent">
<p>Aikenフォーマットは、人間が理解できるフォーマットで多肢選択問題を作成する非常にシンプルな方法です。次にフォーマットの例をあげます:</p>
<pre>
応急手当の目的は?
A. 命を救う、より深刻な怪我を防ぐ、健康を維持する
B. 怪我をした人に治療を提供する
C. より深刻な怪我を防ぐ
D. 助けを求めている被害者を支援する
ANSWER: A
</pre>

<p class="moreinfo"><a href="help.php?file=formataiken.html&module=quiz">「Aiken」フォーマットの詳細情報</a></p>
</div>

<h2>Missing Wordフォーマット</h2>
<div class="indent">
<p>このフォーマットは、多肢選択問題のみをサポートします。それぞれの答えはチルド (~) で分離され、正解の前には等号 (=) を付けます。次に例をあげます:</p>

<blockquote>私たちは、幼児のときに身体の部分を探索し始めるとすぐに、{=解剖学と生理学 ~反射学
~科学 ~実験}の生徒となります。ある意味、私たちは生涯生徒であり続けます。
</blockquote>

<p class="moreinfo"><a href="help.php?file=formatmissingword.html&module=quiz">「Missing Word」フォーマットの詳細情報</a></p>
</div>

<h2>AON</h2>
<div class="indent">
<p>これはMissing Wordフォーマットと同じですが、問題がインポートされた後、すべての記述式問題が組み合わせ問題に変換されます。</p>
<p>また、インポート時に多肢選択問題の答えがランダムにシャッフルされます。</p>
<p>多くの小テスト機能の開発を後援している機関にちなんで、フォーマットの名称が付けられました。</p>
</div>

<h2>Blackboard</h2>
<div class="indent">
<p>このモジュールは、Blackboardのエクスポート機能によって保存された問題をインポートすることができます。あなたのPHPに組み込まれたXML機能を利用します。</p>

<p class="moreinfo"><a href="help.php?file=formatblackboard.html&module=quiz">「Blackboard」フォーマットの詳細情報</a></p>
</div>

<h2>Course Test Manager</h2>
<div class="indent">
<p>このモジュールはCourse Test Manager test bankに保存された問題をインポートすることができます。
MoodleがWindowsで動作しているか、Linuxウェブサーバで動作しているかによって、Microsoft Accessデータベースに保存されているtest bankへのアクセス方法が異なります。</p>
<p>Windows環境では、他のデータインポートファイルと同じようにサーバにアップロードしてください。</p>
<p>Linux環境では、LinuxサーバのmoodleにXMLデータを転送するODBCソケットとCourse Test Manager test bankを入れたWindowsマシンを同じネットワークに設置する必要があります。</p>
<p>このインポートクラスを使用する前に、下記の詳細ヘルプをお読みください。</p>

<p class="moreinfo"><a href="help.php?file=formatctm.html&module=quiz">「CTM」フォーマットの詳細情報</a></p>
</div>

<h2>カスタム</h2>
<div class="indent">
<p>インポートしたいフォーマットがある場合は、/mod/quiz/format/custom.phpを編集することで独自にインプリメントすることができます。</p>

<p>新たに記述する必要のあるコードの量は非常に小さいものです - 与えられたテキストから1つの問題のみを解析できるコードです。</p>

<p class="moreinfo"><a href="help.php?file=formatcustom.html&module=quiz">「カスタム」フォーマットの詳細情報</a></p>
</div>

<p>WebCT、IMS QTIを含んだ新たなフォーマットがさらに追加されます。どのようなフォーマットでも、Moodleユーザが貢献することができます! </p>';
$string['insertedpage'] = 'ページが追加されました';
$string['invalidfile'] = '無効なファイル';
$string['invalidid'] = 'コースモジュールIDまたはレッスンIDがパスしていません。';
$string['invalidlessonid'] = 'レッスンIDが正しくありません。';
$string['invalidpageid'] = 'ページIDが正しくありません。';
$string['jump'] = 'ジャンプ';
$string['jumps'] = 'ジャンプ';
$string['jumps_help'] = 'それぞれの (問題の) 答えまたは (コンテンツページの) 説明はジャンプするリンク先を持ちます。ジャンプには「このページ」または「次のページ」のような相対ジャンプ、またはレッスン内の1ページを指定する絶対ジャンプがあります。';
$string['jumpsto'] = '<em>{$a}</em> にジャンプする';
$string['leftduringtimed'] = 'あなたは制限時間のあるレッスンを途中で終了しました。<br />レッスンを再スタートするには、「続ける」をクリックしてください。';
$string['leftduringtimednoretake'] = 'あなたは制限時間のあるレッスンを途中で終了しました。<br />レッスンを再受験または継続できません。';
$string['leftduringtimedsession'] = 'あなたは制限時間のあるレッスンを離れました。';
$string['lesson:addinstance'] = '新しいレッスンを追加する';
$string['lessonattempted'] = 'レッスン受験済み';
$string['lessonclosed'] = 'このレッスンは {$a} に終了します。';
$string['lessoncloses'] = 'レッスン終了';
$string['lessoncloseson'] = 'レッスン終了: {$a}';
$string['lesson:edit'] = 'レッスン活動を編集する';
$string['lessonformating'] = 'レッスンフォーマット';
$string['lesson:manage'] = 'レッスン活動を管理する';
$string['lessonmenu'] = 'レッスンメニュー';
$string['lessonnotready'] = 'このレッスンは、まだ受験することができません。あなたの {$a} に連絡してください。';
$string['lessonnotready2'] = 'このレッスンは、まだ受験することができません';
$string['lessonopen'] = 'このレッスンは {$a} に開始されます。';
$string['lessonopens'] = 'レッスン開始';
$string['lessonpagelinkingbroken'] = '最初のページが見つかりません。レッスンページのリンクが壊れているようです。管理者に連絡してください。';
$string['lessonstats'] = 'レッスン統計';
$string['linkedmedia'] = 'リンクメディア';
$string['loginfail'] = 'ログインに失敗しました、再度ログインしてください...';
$string['lowscore'] = '最低評点';
$string['lowtime'] = '最短時間';
$string['manualgrading'] = '作文問題の評定';
$string['matchesanswer'] = '正解';
$string['matching'] = '組み合わせ問題';
$string['matchingpair'] = '組み合わせペア {$a}';
$string['maxgrade'] = '最大評点';
$string['maxgrade_help'] = '<p>ここではレッスンで与えることのできる最大評点を設定します。評点の範囲は、0 から 100% です。この値はレッスン中、いつでも変更することができます。すべての変更は、評定ページおよび各種学生リストに即座に反映されます。評点にゼロが設定された場合、そのレッスンはどの評定ページにも表示されません。</p>';
$string['maxhighscores'] = 'ハイスコア表示件数';
$string['maximumnumberofanswersbranches'] = '答えの最大数';
$string['maximumnumberofanswersbranches_help'] = 'ここでは小テストで使用される解答の最大数を指定します。○/×問題のみ使用する場合、設定値として2を設定することができます。データではなく教師の見え方のみに影響するため、設定内容はいつでも変更することができます。';
$string['maximumnumberofattempts'] = '最大受験回数';
$string['maximumnumberofattempts_help'] = 'この設定ではそれぞれの問題に許可される最大受験回数を指定します。答えが繰り返し正しくない場合、最大受験回数に到達した時点で次のレッスンページが表示されます。';
$string['maximumnumberofattemptsreached'] = '最大受験回数に達しました - 次のページに移動しています。';
$string['maxtime'] = '制限時間 (分)';
$string['maxtimewarning'] = 'レッスン終了まで {$a} 分です。';
$string['mediaclose'] = '「ウィンドウを閉じる」ボタンを表示する:';
$string['mediafile'] = 'ファイルポップアップ';
$string['mediafile_help'] = '<p>ここではレッスンの最初に表示されるファイル (例: mp3ファイル) またはウェブページへのポップアップウィンドウを作成します。また、必要に応じてポップアップウィンドウを開くことができるよう、リンクはすべてのレッスンページに表示されます。</p>

<p>任意で「ウィンドウを閉じる」ボタンをポップアップの下部に表示することができます。同様に、ウィンドウの高さおよび幅を設定することができます。</p>

<p>サポートされた埋め込みファイルタイプ:</p>
    <ul>
        <li>MP3</li>
        <li>Media Player</li>
        <li>Quicktime</li>
        <li>Realmedia</li>
        <li>HTML</li>
        <li>Plain Text</li>
        <li>GIF</li>
        <li>JPEG</li>
        <li>PNG</li>
    </ul>
<p>    他のすべてのタイプのファイルには、デフォルトでダウンロード用のリンクが設定されます。</p>';
$string['mediafilepopup'] = '閲覧するにはここをクリックしてください。';
$string['mediaheight'] = 'ポップアップウィンドウ高:';
$string['mediawidth'] = 'ポップアップウィンドウ幅:';
$string['messageprovider:graded_essay'] = '作文評定通知';
$string['minimumnumberofquestions'] = '最小問題数';
$string['minimumnumberofquestions_help'] = 'ここでは活動の評定計算に使用する問題の最大数を指定します。レッスンが1つまたはそれ以上のコンテンツを含んでいる場合、問題の最大数はゼロに設定してください。

例えば、20に設定した場合、レッスンのオープニングページに次のようなテキストの追加をお勧めします: 「あなたはこのレッスンで少なくとも20問の問題を受験する必要があります。あなたが希望すればさらに問題を受験することができます。しかし、あなたが20問より少なく受験した場合、20問を受験したかのように計算されます」';
$string['missingname'] = 'ニックネームを入力してください。';
$string['modattempts'] = '学生のレビューを許可する';
$string['modattempts_help'] = '<p>ここでは解答内容を変更するため、学生がレッスンを後戻りすることができるようにします。</p>';
$string['modattemptsnoteacher'] = '学生レビューは学生のみに表示されます。';
$string['modulename'] = 'レッスン';
$string['modulename_help'] = 'レッスン活動において、教師は楽しくフレキシブルな方法でコンテンツおよび実践活動を提供することができます。教師は一連の線形のコンテンツパッケージまたは学習者に様々なパスまたはオプションを提供する教育活動のためにレッスンを使用することができます。どちらの場合でも、教師は参加を増やすこと、および多肢選択問題、組み合わせ問題、記述問題等の様々な問題を含むことで、理解を確かめることができます。学生の選択した答えおよび教師のレッスン開発により、学生を次のページに移動させる、、前のページに戻す、または完全に異なるパスにリダイレクトさせることができます。

レッスンは評定すること、評点を評定表に記録することができます。

レッスンは下記のように使用することができます:

* 新しいテーマに関する自主学習のため
* シナリオまたはシミュレーション/意思決定訓練のため
* 初期問題で答えられた内容により、一連の異なる試験問題を提供する差別化された試験対策として';
$string['modulenameplural'] = 'レッスン';
$string['move'] = 'ページを移動する';
$string['movedpage'] = 'ページを移動しました。';
$string['movepagehere'] = 'ページをここに移動する';
$string['moving'] = 'ページの移動: {$a}';
$string['multianswer'] = '複数解答';
$string['multianswer_help'] = '<p>いくつかの問題タイプではこのチェックボックスをチェックすることで有効にすることができるオプションがあります。問題タイプとオプションの意味は下記のとおりです.</p>

<ol>
<li><p><b>多肢選択問題</b> 多肢選択問題の変形版に<b>「多肢選択組合せ」</b>問題があります。問題オプションが選択された場合、学生には答えの中からすべての正解を選択することが求められます。学生に<i>いくつの</i>の正解があるのか知らせることも、知らせないこともできます。例えば、「下記の一覧の中から米国の大統領をあげなさい」という問題では正解の数を知らせないのに対して、「下記の一覧から米国の大統領を2人あげなさい」という問題では正解の数を知らせています。実際の正解数は<b>1</b>から選択肢の数まで設定することができます。(正解が1つの多肢選択組合せ問題は多肢選択問題と異なります。 前者は学生が1つ以上の答えを選択することができるのに対して、後者は選択することができません。)</p></li>

<li><p><b>記述問題</b> 記述問題には、2つの類似するシステムを使用することができます。デフォルトでは単純分析システムが使用され、オプションボックスがチェックされた場合、「正規表現」分析システムが使用されます。詳細は、レッスン問題タイプのヘルプファイルをご覧ください。</p></li>

<p>その他の問題では問題オプションを使用しません。</p>';
$string['multichoice'] = '多肢選択問題';
$string['multipleanswer'] = '複数解答';
$string['nameapproved'] = '名前が承認されました。';
$string['namereject'] = '申し訳ございません、あなたの名前はフィルタにより拒否されました。<br />別の名前をお使いください。';
$string['new'] = '新しい';
$string['nextpage'] = '次のページ';
$string['noanswer'] = '1つまたはそれ以上の問題が解答されていません。戻って解答を送信してください。';
$string['noattemptrecordsfound'] = '受験レコードが見つかりません: 評定なし';
$string['nobranchtablefound'] = 'コンテンツページが見つかりません。';
$string['nocommentyet'] = 'コメントはありません。';
$string['nocoursemods'] = '活動が見つかりません。';
$string['nocredit'] = '未承認';
$string['nodeadline'] = 'レッスン終了なし';
$string['noessayquestionsfound'] = 'このレッスンに作文問題はありません。';
$string['nohighscores'] = 'ハイスコアはありません。';
$string['nolessonattempts'] = 'このレッスンは受験されていません。';
$string['nooneansweredcorrectly'] = '正解者はいません。';
$string['nooneansweredthisquestion'] = 'この問題の解答者はいません。';
$string['noonecheckedthis'] = '未チェック';
$string['nooneenteredthis'] = '未入力';
$string['noonehasanswered'] = '作文問題に解答者はいません。';
$string['noretake'] = 'このレッスンは再受験できません。';
$string['normal'] = '通常 - レッスンパスに従う';
$string['notcompleted'] = '未了';
$string['notdefined'] = '未定義';
$string['nothighscore'] = 'あなたはトップ {$a} ハイスコアリストに入りませんでした。';
$string['notitle'] = 'タイトルなし';
$string['numberofcorrectanswers'] = '正解数: {$a}';
$string['numberofcorrectmatches'] = '正しいマッチ数: {$a}';
$string['numberofpagestoshow'] = 'ページの表示数';
$string['numberofpagestoshow_help'] = '<p>このパラメータは、フラッシュカードタイプのレッスンのみに使用されます。デフォルトの値はゼロで、レッスン内にすべてのページ/カードが表示されます。このパラメータにゼロ以外の値を設定すると、設定した値のページが表示されます。この値のページ/カードが表示された後、レッスンは最後まで到達したことになり、学生に評点が表示されます。</p>

<p>このパラメータを実際のページ数よりも大きく設定した場合、すべてのページが表示された後に、レッスンは最後まで到達したことになります。</p>';
$string['numberofpagesviewed'] = '解答済み問題数: {$a}';
$string['numberofpagesviewednotice'] = '解答済み問題数: {$a->nquestions}; (あなたは少なくとも {$a->minquestions} 問の問題に解答する必要があります)';
$string['numerical'] = '数値問題';
$string['ongoing'] = '進行中の評点を表示する';
$string['ongoingcustom'] = '現在、あなたの評点は {$a->currenthigh} 点中 {$a->score} 点です。';
$string['ongoing_help'] = '<p>この設定を「Yes」にすると、現時点で考えられる学生の合計評点が各ページに表示されます。例:  学生が評点5点の問題4問に答えて、1問が間違っている場合、表示される進行中の評点は、15/20点になります。</p>';
$string['ongoingnormal'] = 'あなたは {$a->viewed} 問中 {$a->correct} 問を正しく答えました。';
$string['onpostperpage'] = '1評点あたり1回のみ登録してください。';
$string['options'] = 'オプション';
$string['or'] = 'または';
$string['ordered'] = '整理済み';
$string['other'] = 'その他';
$string['outof'] = '{$a} 中';
$string['overview'] = '概要';
$string['overview_help'] = 'レッスンは多くのページおよび任意のコンテンツページにより構成されます。ページはいくつかのコンテンツを含み、通常、問題で終了します。ジャンプには「このページ」または「次のページ」のような相対ジャンプ、またはレッスン内の1ページを指定する絶対ジャンプがあります。ページコンテンツには例えば目次のように、レッスン内の他のページへの一連のリンクを含みます。';
$string['page'] = 'ページ: {$a}';
$string['pagecontents'] = 'ページコンテンツ';
$string['page-mod-lesson-edit'] = 'レッスンページを編集する';
$string['page-mod-lesson-view'] = 'レッスンページを表示またはプレビューする';
$string['page-mod-lesson-x'] = 'すべてのレッスンページ';
$string['pages'] = 'ページ';
$string['pagetitle'] = 'ページタイトル';
$string['password'] = 'パスワード';
$string['passwordprotectedlesson'] = '{$a} はパスワードで保護されたレッスンです。';
$string['pleasecheckoneanswer'] = '答えを選択してボタンをクリックしてください';
$string['pleasecheckoneormoreanswers'] = '1つ以上の答えを選択してボタンをクリックしてください';
$string['pleaseenteryouranswerinthebox'] = '答えを入力してボタンをクリックしてください';
$string['pleasematchtheabovepairs'] = '答えを選択してボタンをクリックしてください';
$string['pluginadministration'] = 'レッスン管理';
$string['pluginname'] = 'レッスン';
$string['pointsearned'] = '獲得点数';
$string['postprocesserror'] = '投稿処理中にエラーが発生しました!';
$string['postsuccess'] = '正常に投稿されました。';
$string['practice'] = '練習レッスン';
$string['practice_help'] = '<p>練習レッスンは、評定表には表示されません。</p>';
$string['preprocesserror'] = '前処理中にエラーが発生しました!';
$string['prerequisitelesson'] = '必修レッスン';
$string['preview'] = 'プレビュー';
$string['previewlesson'] = '{$a} のプレビュー';
$string['previouspage'] = '前のページ';
$string['processerror'] = '処理中にエラーが発生しました!';
$string['progressbar'] = 'プログレスバー';
$string['progressbar_help'] = '有効にした場合、レッスンページ最下部におおよその完了パーセンテージを表示したバーが表示されます。';
$string['progressbarteacherwarning'] = 'プログレスバーは {$a} に表示されません。';
$string['progressbarteacherwarning2'] = 'あなたはこのレッスンを編集できるため、プログレスバーは表示されません。';
$string['progresscompleted'] = 'あなたは {$a}% のレッスンを完了しました。';
$string['qtype'] = 'ページタイプ';
$string['question'] = '問題';
$string['questionoption'] = '問題';
$string['questiontype'] = '問題タイプ';
$string['randombranch'] = 'ランダムコンテンツページ';
$string['randompageinbranch'] = 'コンテンツページ内のランダム問題';
$string['rank'] = 'ランク';
$string['rawgrade'] = '評点詳細';
$string['receivedcredit'] = '承認クレジット';
$string['redisplaypage'] = '再表示';
$string['report'] = 'レポート';
$string['reports'] = 'レポート';
$string['response'] = 'レスポンス';
$string['retakesallowed'] = '再受験を許可する';
$string['retakesallowed_help'] = '<p>ここでは学生がレッスンを1回以上または1回のみ受験できるか設定します。教師は、学生が完全に理解すべき教材がレッスンに含まれることを決定できます。この場合、教材の繰り返し閲覧を許可すべきです。しかし、教材がテストのような性質を持っている場合、学生に再受験を許可してはいけません。</p>

<p>学生がレッスンの再受験を許可された場合、評定ページに表示される<b>評点</b>は、再受験の<b>平均</b>評点、またはレッスンの<b>最高</b>評点です。次のオプションでは、どちらの評定方法を使用するか選択します。</p>

<p><b>問題分析</b>では、常にレッスンの最初の受験内容を使用し、学生による再受験は無視されますので注意してください。</p>

<p>このオプションは、デフォルトで学生が再受験できない「No」に設定されています。 特別な事情がある場合のみ、このオプションを「Yes」にすることをお勧めします。</p>';
$string['returnto'] = '{$a} に戻る';
$string['returntocourse'] = 'コースに戻る';
$string['review'] = 'レビュー';
$string['reviewlesson'] = 'レッスンをレビューする';
$string['reviewquestionback'] = 'はい、もう一度受験します';
$string['reviewquestioncontinue'] = 'いいえ、次の問題に移動します';
$string['sanitycheckfailed'] = '正当性チェックが失敗しました: この受験は削除されました。';
$string['savechanges'] = '変更を保存する';
$string['savechangesandeol'] = 'すべての変更を保存してレッスンの最後に移動する。';
$string['savepage'] = 'ページを保存する';
$string['score'] = '評点';
$string['score_help'] = '評点はカスタムスコアが有効にされた場合にのみ使用されます。それぞれの答えには数字による評点 (プラスまたはマイナス) を与えることができます。';
$string['scores'] = '評点';
$string['secondpluswrong'] = 'もう一度受験しますか?';
$string['selectaqtype'] = '問題タイプを選択する';
$string['shortanswer'] = '記述問題';
$string['showanunansweredpage'] = '未解答のページを表示する';
$string['showanunseenpage'] = '未閲覧のページを表示する';
$string['singleanswer'] = '単一解答';
$string['skip'] = 'ナビゲーションをスキップする';
$string['slideshow'] = 'スライドショー';
$string['slideshowbgcolor'] = 'スライドショー背景色';
$string['slideshowheight'] = 'スライドショー高';
$string['slideshow_help'] = '<p>この設定を「Yes」にすると、固定した幅、高さ、独自の背景色のスライドショーとして、レッスンを表示することができます。コンテンツページの幅または高さが指定した範囲を超えた場合、CSSベースのスクロールバーが表示されます。問題は、スライドショーモードでは「除外」され、デフォルトでページ (ブランチテーブル) のみスライド表示されます。オプションが選択された場合、デフォルト言語のラベル付きボタン「次へ」および「戻る」ボタンが、ページの右端および左端に表示されます。他のボタンは、スライドショー下部中央に配置されます。</p>';
$string['slideshowwidth'] = 'スライドショー幅';
$string['startlesson'] = 'レッスンの開始';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname} さんの受験回数:  {$a->attempt}';
$string['studentname'] = '{$a} の氏名';
$string['studentoneminwarning'] = '警告: レッスンが終了するまでの残り時間が1分またはそれ以下です。';
$string['studentresponse'] = '{$a} のレスポンス';
$string['submit'] = '送信';
$string['submitname'] = 'ニックネームの送信';
$string['teacherjumpwarning'] = 'このレッスンでは、{$a->cluster} ジャンプまたは {$a->unseen} ジャンプが使用されています。これらのジャンプの代わりに「次のページ」へのジャンプが使用されます。これらのジャンプを確認するには、学生としてログインしてください。';
$string['teacherongoingwarning'] = '進行中の評点は、学生のみに表示されます。進行中のスコアをテストするには、学生としてログインしてください。';
$string['teachertimerwarning'] = 'タイマーは学生に対してのみ作動します。タイマーをテストするには、学生としてログインしてください。';
$string['thatsthecorrectanswer'] = '正解です。';
$string['thatsthewronganswer'] = '不正解です。';
$string['thefollowingpagesjumptothispage'] = '下記のページは、このページにジャンプします。';
$string['thispage'] = 'このページ';
$string['timeisup'] = '時間終了';
$string['timeremaining'] = '残り時間';
$string['timespenterror'] = '少なくともレッスンで {$a} 分の時間を使用してください。';
$string['timespentminutes'] = '利用時間 (分)';
$string['timetaken'] = '経過時間';
$string['topscorestitle'] = 'トップ {$a} ハイスコア';
$string['truefalse'] = '○/×問題';
$string['unabledtosavefile'] = 'あなたがアップロードしたファイルを保存することができませんでした。';
$string['unknownqtypesnotimported'] = '{$a} 件のサポートされない問題タイプがインポートされませんでした。';
$string['unseenpageinbranch'] = 'コンテンツページ内の未閲覧の問題';
$string['unsupportedqtype'] = 'サポートされていない問題タイプ ({$a}) です!';
$string['updatedpage'] = 'ページを更新しました';
$string['updatefailed'] = '更新が失敗しました。';
$string['usemaximum'] = '最大評点を使用する';
$string['usemean'] = '評点平均を使用する';
$string['usepassword'] = 'レッスンをパスワードで保護する';
$string['usepassword_help'] = '<p>「Yes」を選択すると、パスワードの入力なしでは、学生はレッスンにアクセスできません。</p>';
$string['viewgrades'] = '評点を表示する';
$string['viewhighscores'] = 'ハイスコアリストを表示する';
$string['viewreports'] = '{$a->student} の {$a->attempts} 件の受験を表示';
$string['viewreports2'] = '{$a} 件の受験を表示';
$string['welldone'] = 'よくできました!';
$string['whatdofirst'] = '最初に何をしますか?';
$string['wronganswerjump'] = '不正解のジャンプ先';
$string['wronganswerscore'] = '不正解の評点';
$string['wrongresponse'] = '不正解に対するレスポンス';
$string['xattempts'] = '{$a} 受験';
$string['youhaveseen'] = 'あなたはすでにこのレッスンを1ページ以上表示しました。<br />あなたが表示した最後のページから始めますか?';
$string['youmadehighscore'] = 'あなたはトップ {$a} ハイスコアリストに入りました。';
$string['youranswer'] = 'あなたの答え';
$string['yourcurrentgradeis'] = 'あなたの現在の評点は {$a} です。';
$string['yourcurrentgradeisoutof'] = 'あなたの現在の評点は {$a->total} 点中 {$a->grade} 点です。';
$string['youshouldview'] = '少なくとも {$a} 回解答してください。';
