<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'ja', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'アクセスが拒否されました。';
$string['accounts'] = 'アカウント';
$string['addcategory'] = 'カテゴリを追加する';
$string['additionalhtml'] = '追加HTML';
$string['additionalhtml_desc'] = 'これらの設定ではあなたがすべてのページに追加したいHTMLを指定することができます。あなたはページのHEADタグ内、BODYタグが開かれた直後、またはBODYタグが閉じられる直前にHTMLを設定することができます。<br />この設定により、すべてのページにカスタムヘッダおよびフッタを追加またはGoogle Analytics のようなサービスのサポートをあなたが選択したテーマから独立して簡単に追加することができます。';
$string['additionalhtmlfooter'] = 'BODYタグが閉じられる前';
$string['additionalhtmlfooter_desc'] = 'このコンテンツはすべてのページのBODYタグが閉じられる直前に追加されます。';
$string['additionalhtmlhead'] = 'HEADタグ内';
$string['additionalhtmlhead_desc'] = 'このコンテンツはすべてのページのHEADタグの最後に追加されます。';
$string['additionalhtml_heading'] = 'すべてのページに追加される追加HTMLです。';
$string['additionalhtmltopofbody'] = 'BODYタグが開かれた時';
$string['additionalhtmltopofbody_desc'] = 'このコンテンツはすべてのページのBODYタグが開かれた直後に追加されます。';
$string['admincategory'] = 'カテゴリ: {$a}';
$string['adminseesall'] = '管理者にすべてを表示する';
$string['adminseesallevents'] = '管理者にすべてのイベントを表示する';
$string['adminseesownevents'] = '管理者は他のユーザと同じ';
$string['advancedfeatures'] = '拡張機能';
$string['allcountrycodes'] = 'すべての国コード';
$string['allowbeforeblock'] = '最初に「許可されるIPアドレスリスト」を参照する';
$string['allowbeforeblockdesc'] = 'デフォルトでは「ブロックされるIPアドレスリスト」が最初に参照されます。このオプションが有効にされた場合、「ブロックされるIPアドレスリスト」の前に「許可されるIPアドレスリスト」が参照されます。';
$string['allowblockstodock'] = 'ブロックのドック使用を許可する';
$string['allowcategorythemes'] = 'カテゴリテーマを許可する';
$string['allowcoursethemes'] = 'コーステーマを許可する';
$string['allowediplist'] = '許可されるIPアドレスリスト';
$string['allowemailaddresses'] = '許可されるメールアドレスのドメイン';
$string['allowframembedding'] = 'フレーム内埋め込みを許可する';
$string['allowframembedding_help'] = 'このサイトが外部サイトのフレーム内に埋め込まれることを許可します。セキュリティ上の理由から、この機能を有効にすることはお勧めできません。';
$string['allowguestmymoodle'] = 'マイホームへのゲストアクセスを許可する';
$string['allowobjectembed'] = 'EMBEDおよびOBJECTタグを許可する';
$string['allowthemechangeonurl'] = 'テーマ変更URLを許可する';
$string['allowuserblockhiding'] = 'ユーザのブロック非表示を許可する';
$string['allowuserswitchrolestheycantassign'] = '「ユーザにロールを割り当てる」ケイパビリティのないユーザに対して、ロールのスイッチを許可する';
$string['allowuserthemes'] = 'ユーザテーマを許可する';
$string['antivirus'] = 'アンチウイルス';
$string['appearance'] = 'アピアランス';
$string['aspellpath'] = 'aspellのパス';
$string['authentication'] = '認証';
$string['authpreventaccountcreation'] = 'ユーザ認証時のアカウント作成を抑制する';
$string['authpreventaccountcreation_help'] = 'ユーザ認証時、まだユーザアカウントが存在しない場合は自動的に作成されます。LDAPのような外部データベースを認証に使用して、あなたが存在するアカウントのみにサイトアクセスを制限したい場合、このオプションを有効にしてください。新しいアカウントは手動で作成するか、ユーザアップロード機能を使用して作成する必要があります。この設定はMNet認証には適用されないことに留意してください。';
$string['authsettings'] = '認証管理';
$string['autolang'] = '言語の自動認識';
$string['autologinguests'] = 'ゲストのオートログイン';
$string['availablelicenses'] = '利用可能なライセンス';
$string['availableto'] = '利用可能';
$string['backgroundcolour'] = '透過色';
$string['backups'] = 'バックアップ';
$string['backup_shortname'] = 'バックアップファイル名にコース名を使用する';
$string['backup_shortnamehelp'] = 'コース名をバックアップファイル名の一部として使用します。';
$string['badwordsconfig'] = 'あなたの使用禁止用語をカンマで区切って入力してください。';
$string['badwordsdefault'] = 'カスタムリストが空白の場合、言語パックからデフォルトリストが使用されます。';
$string['badwordslist'] = 'カスタム使用禁止用語リスト';
$string['blockediplist'] = 'ブロックされるIPアドレスリスト';
$string['blockeditingmenu'] = 'ブロック編集メニュー';
$string['blockeditingmenu_desc'] = 'この設定を有効にした場合、編集モード時の多くのブロック編集アイコンをドロップダウンメニュー内に表示することができます。必要になるまでアイコンを隠すことで、画面上のコンテンツを減らします。';
$string['blockinstances'] = 'インスタンス';
$string['blockmultiple'] = '複数設置';
$string['blockprotect'] = 'インスタンスを保護する';
$string['blockprotect_help'] = 'あなたが特定のタイプのブロックをロックした場合、誰もインスタンスを追加または削除できなくなります (もちろん、あなたはできますが、インスタンス編集する場合はロック解除してください)。

これは主に間違って削除された場合に元に戻すことが難しいナビゲーションおよび設定ブロックを保護することを目的としています。';
$string['blocksettings'] = 'ブロック管理';
$string['blockunprotect'] = '保護を解除する';
$string['bloglevel'] = 'ブログ可視性';
$string['bookmarkadded'] = 'ブックマークが追加されました。';
$string['bookmarkalreadyexists'] = 'あなたはすでにこのページをブックマークしています。';
$string['bookmarkdeleted'] = 'ブックマークが解除されました。';
$string['bookmarkthispage'] = 'このページをブックマークする';
$string['cacheapplication'] = 'アプリケーションキャッシュ';
$string['cacheapplicationhelp'] = 'キャッシュアイテムはすべてのユーザで共有され、指定された生存時間 (TTL) で有効期限が切れます。';
$string['cachejs'] = 'Javaスクリプトをキャッシュする';
$string['cachejs_help'] = 'Javaスクリプトキャッシングおよび圧縮によりページ読み込みのパフォーマンスが大幅に向上します。実運用サイトでの適用を強くお勧めします。開発者は恐らくこの機能を無効にしても良いでしょう。';
$string['cacherequest'] = 'リクエストキャッシュ';
$string['cacherequesthelp'] = 'リクエスト完了時に有効期限が切れるユーザ固有のキャッシュです。私たちが使用している静的保存エリアの置換を目的とします。';
$string['cachesession'] = 'セッションキャッシュ';
$string['cachesessionhelp'] = 'ユーザ固有キャッシュはユーザセッション終了時に有効期限切れとなります。セッション負荷を軽減することを目的としています。';
$string['cachesettings'] = 'キャッシュ設定';
$string['cachetext'] = 'テキストキャッシュ保存時間';
$string['caching'] = 'キャッシング';
$string['calendarexportsalt'] = 'カレンダーエクスポートsalt';
$string['calendarsettings'] = 'カレンダー';
$string['calendartype'] = 'カレンダータイプ';
$string['calendartype_desc'] = 'サイト全体のカレンダータイプを選択してください。この設定はコース設定またはユーザ個人のプロファイルにてオーバーライドすることができます。';
$string['calendar_weekend'] = '週末日';
$string['cannotdeletemodfilter'] = '「 {$a->module} 」モジュールの一部のため、あなたは「 {$a->filter} 」をアンインストールできません。';
$string['cannotuninstall'] = '{$a} をアンインストールすることはできません。';
$string['cfgwwwrootslashwarning'] = 'あなたはconfig.phpファイルの$CFG->wwwrootを正しく定義していません。末尾に「/」文字が含まれています。「/」文字を取り除いてください。あなたが取り除かない場合、<a href="http://tracker.moodle.org/browse/MDL-11061">MDL-11061</a>のようなバグが発生する可能性があります。';
$string['cfgwwwrootwarning'] = 'あなたはconfig.phpファイルの$CFG->wwwrootを正しく定義していません。あなたがこのページにアクセスしているURLと合致しません。URLを修正してください。あなたが修正しない場合、<a href="http://tracker.moodle.org/browse/MDL-11061">MDL-11061</a>のようなバグが発生する可能性があります。';
$string['change'] = '変更';
$string['checkboxno'] = 'No';
$string['checkboxyes'] = 'Yes';
$string['choosefiletoedit'] = '編集するファイルを選択してください。';
$string['clamfailureonupload'] = 'ClamAVの障害時';
$string['cleanup'] = 'クリーンアップ';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'エラー: 「 {$a->option} 」の値「 {$a->value} 」が正しくありません。';
$string['cliincorrectvalueretry'] = '値が正しくありません、再度入力してください。';
$string['clistatusdisabled'] = 'ステータス: 無効';
$string['clistatusenabled'] = 'ステータス: 有効';
$string['clistatusenabledlater'] = 'ステータス: CLIメンテナンスモードは {$a} に有効にされます。';
$string['clitypevalue'] = '値を入力してください。';
$string['clitypevaluedefault'] = '値を入力してください。デフォルト値 ({$a}) を使用するにはEnterキーを押してください。';
$string['cliunknowoption'] = '不明なオプション:
{$a}
「--help」オプションを使用してください。';
$string['cliupgradefinished'] = 'コマンドラインによるアップグレードが正常に完了しました。';
$string['cliupgradenoneed'] = 'インストール済みバージョン {$a} をアップグレードする必要はありません。ありがとうございます!';
$string['cliyesnoprompt'] = 'y (yes) または n (no) を入力してください。';
$string['commentsperpage'] = '1ページあたりに表示するコメント数';
$string['commonfiltersettings'] = 'フィルタ共通設定';
$string['commonsettings'] = '共通設定';
$string['componentinstalled'] = 'コンポーネントがインストールされました。';
$string['computedfromlogs'] = '{$a} 以降のログより計算しています。';
$string['condifmodeditdefaults'] = 'デフォルト値は新しい活動またはリソースの作成時に設定フォームで使用されます。';
$string['confeditorhidebuttons'] = 'HTMLエディタ内で隠すボタンを選択してください。';
$string['configallcountrycodes'] = '例えばユーザプロファイルのように、これは多くの場所で選択することのできる国リストです。空白にした場合 (デフォルト)、標準英語言語パックのcountries.php内リストが使用されます。このリストはISO 3166-1から作成されています。そうでない場合、例えば「JA,GB,FR,ES」 のように、カンマ区切りのコードのリストを記述することができます。あなたが新しい非標準コードをここに入力した場合、「en」内のcontries.phpおよびあなたの言語パックに追加する必要があります。';
$string['configallowassign'] = 'あなたは左側に表示されているロールのユーザに対して、いくつかのカラムのロールを他のユーザに割り当てることができるようにします。';
$string['configallowblockstodock'] = 'この設定を有効にした場合、そして選択されたテーマによりサポートされている場合、ユーザはブロックを特別ドックに移動することができます。';
$string['configallowcategorythemes'] = 'この設定を有効にした場合、カテゴリに独自のテーマを設定することができます。独自テーマが設定されていない限り、これはすべての子カテゴリおよびコースに影響を及ぼします。警告: カテゴリテーマを有効にした場合、パフォーマンスに影響を及ぼします。';
$string['configallowcoursethemes'] = 'この設定を有効にした場合、コースに独自テーマを設定することができます。コーステーマは他のすべてのテーマ (サイト、ユーザまたはセッションテーマ) をオーバーライドします。';
$string['configallowemailaddresses'] = '新しいメールアドレスすべてを特定のドメインのみに制限したい場合、ここにスペースで区切って入力してください。他のドメインはすべて拒否されます。サブドメインを許可するには、先頭に「.」を付けたドメインを入力してください。例 <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'この設定を有効にした場合、ゲストがマイホームにアクセスできるようになります。そうでない場合、ゲストはサイトフロントページにリダイレクトされます。';
$string['configallowobjectembed'] = 'デフォルトのセキュリティ対策として、通常のユーザはマルチメディア (Flash等) をEMBEDおよびOBJECTタグでHTML内に埋め込むことは許可されていません (メディアプラグインフィルタを使用して安全に埋め込むことは可能です)。これらのタグの使用を許可したい場合、このオプションを有効にしてください。';
$string['configallowoverride'] = 'あなたは左側に表示されているロールのユーザに対して、いくつかのカラムのロールをオーバーライドできるようにすることができます。';
$string['configallowoverride2'] = '左側カラム内のロールでオーバライドできるロールを選択してください。<br />これらの設定はケイパビリティ「moodle/role:override」または「moodle/role:safeoverride」を持つユーザにのみ適用されることに留意してください。';
$string['configallowswitch'] = 'ユーザが持つロールを基に、どのロールにスイッチできるか選択してください。このテーブルのエントリに加えてロールをスイッチできるようにするには、ユーザがmoodle/role:switchrolesケイパビリティを持つ必要があります。<br />moodle/course:viewケイパビリティを持ち、moodle/site:doanythingケイパビリティを持たないロールにのみスイッチすることができるため、このテーブルのいくつかのカラムは無効にされていることに留意してください。';
$string['configallowthemechangeonurl'] = 'この設定を有効にした場合、MoodleのURLに下記いずれかを追加することにより、テーマを変更することができます。
<br />
?theme=themename (例: mymoodlesite.com/?theme=afterburner )
<<br />
&theme=themename (例: mymoodlesite.com/course/view.php?id=2&theme=afterburner )';
$string['configallowuserblockhiding'] = 'サイト全体において、ユーザにブロックの表示/非表示を許可しますか? 折りたたみ可能なブロックの状態を記憶するため、この機能はJavaスクリプトおよびクッキーを使用します。また、この設定はユーザ自身の閲覧にのみ影響します。';
$string['configallowuserswitchrolestheycantassign'] = 'デフォルトではmoodle/role:assignはロールをスイッチするユーザに必要です。この設定を有効にすることで、この必要条件を解除します。また、「ロールを切り替える ...」ドロップダウンメニューで利用できるロールは「ロールの割り当て許可」テーブルの設定でのみ決定されることになります。「ロールの割り当て許可」テーブルの設定ではユーザの既存ロールより多くのケイパビリティを持ったロールへの切り替えを許可しないことをお勧めします。';
$string['configallowuserthemes'] = 'この設定を有効にした場合、ユーザは自分のテーマを設定することができます。ユーザテーマはサイトテーマをオーバーライドします (コーステーマはオーバーライドされません)。';
$string['configallusersaresitestudents'] = 'サイトフロントページにある活動に関して、すべてのユーザを学生と考えてもよろしいですか? この設定を「Yes」にした場合、承認済みユーザアカウントのユーザは学生として、これらの活動に参加することができます。この設定を「No」にした場合、少なくとも1つのコースに登録しているユーザのみ、フロントページの活動に参加することができます。管理者および特別に割り当てられた教師のみ、これらのフロントページ活動に関して、教師として行動することができます。';
$string['configauthenticationplugins'] = 'あなたが使用したい認証プラグインを選択して、フェイルスルーの順に並べ替えてください。';
$string['configautolang'] = 'ブラウザの設定からデフォルト言語を認識します。この設定を有効にしない場合、サイトデフォルトが使用されます。';
$string['configautologinguests'] = '利用者がコースにゲストアクセスした場合、自動的にゲストとしてログインさせますか?';
$string['configbloglevel'] = 'ここではどのユーザブログをこのサイトで閲覧できるか、アクセスレベルを制限することができます。ここで設定するのは閲覧者に関する最大のコンテクストであり、投稿者またはブログ記事のタイプではないことに注意してください。不要な場合、ブログを完全に無効にすることもできます。';
$string['configcachetext'] = '規模の大きなサイト、またはテキストフィルタを使用しているサイトでは、この設定で処理速度を上げることができます。ここで指定された期間、処理に適した形でテキストのコピーが保持されます。この値を小さくしすぎると、処理速度を若干落とすことになります。しかし、大きすぎると (例えば新しいリンクを) リフレッシュするまでのテキスト保持期間が長くなります。';
$string['configcalendarcustomexport'] = 'カレンダーのカスタム日付幅エクスポートを有効にする';
$string['configcalendarexportsalt'] = 'このランダムテキストはカレンダーのエクスポート時に使用される認証トークンのセキュリティを改善するため使用されます。あなたがこのハッシュsaltを変更した場合、現在のトークンすべてが無効にされることに留意してください。';
$string['configclamactlikevirus'] = 'ファイルをウイルスとして扱う';
$string['configclamdonothing'] = 'ファイルをウイルス感染なしとして扱う';
$string['configclamfailureonupload'] = 'アップロードファイルをclamがスキャンするよう設定したとして、間違って設定されている、または不明な理由で動作しない場合、あなたはどのように処理しますか? 「ファイルをウイルスとして扱う」を選択した場合、感染ファイルは隔離用エリアに移動されるか、削除されます。「ファイルをウイルス感染なしとして扱う」を選択した場合、通常のファイルと同じように、指定したディレクトリに移動されます。どちらの場合でも、管理者にはclamに問題がある旨が通知されます。「ファイルをウイルスとして扱う」を選択してもclamが正常に動作しない場合 (一般的にclamに間違ったパスを指定)、アップロードされたすべてのファイルは指定された隔離用エリアに移動されるか、削除されます。この設定には注意してください。';
$string['configconvertformat'] = 'latex、dvipsおよびconvertが利用可能な場合、指定されたフォーマットを使用してイメージが作成されます。そうでない場合、mimeTeXによりGIFイメージが作成されます。';
$string['configcookiehttponly'] = 'PHP 5.2.0の新しい機能 - 「ブラウザが実HTTPリクエストのみ送信する」を有効にすることで、スクリプト言語からクッキーにアクセスできないようになります。この機能はすべてのブラウザでサポートされているわけではありません。また、現在のコードと完全な互換性はありません。いくつかのタイプのXSSアタックを防ぐためには有用です。';
$string['configcookiesecure'] = 'サーバがhttps接続のみ受け付ける場合、セキュアクッキーの送信を有効にすることをお勧めします。この設定を有効にした場合、ウェブサーバがhttp://を受け付けないこと、またはhttps://アドレスにパーマネントにリダイレクトされていることを確認してください。<em>wwwroot</em> アドレスがhttps://で始まらない場合、この設定は自動的に無効にされます。';
$string['configcountry'] = 'ここで国を設定した場合、新規ユーザアカウントの国のデフォルトとして選択されます。ユーザに自分で国を選ばせる場合、設定しないままにしてください。';
$string['configcourseoverviewfilesext'] = 'コース概要ファイルに許可する拡張子をカンマで区切って入力してください。';
$string['configcourseoverviewfileslimit'] = 'コース管理者がコース概要に添付することのできる最大ファイル数です。';
$string['configcourserequestnotify'] = '新しいコースがリクエストされた場合、通知されるユーザのユーザ名を入力してください。';
$string['configcourserequestnotify2'] = '新しいコースがリクエストされた場合、通知されるユーザです。コースリクエストを承認できるユーザのみ、ここに一覧表示されます。';
$string['configcoursesperpage'] = 'コース一覧の1ページあたりに表示するコース数を入力してください。';
$string['configcourseswithsummarieslimit'] = 'シンプルな一覧に戻る前、コース一覧に表示するコース概要を含むコースの最大数です。';
$string['configcronclionly'] = 'この設定を有効にした場合、ウェブ経由の代わりにコマンドラインでのみcronスクリプトを実行することができます。この設定は下記のcronパスワード設定をオーバーライドします。';
$string['configcronremotepassword'] = 'cronパスワードを設定した場合、下記の形式のURLを使用してcronパスワードを提供しない限り、ウェブブラウザからcron.phpを動作させることはできません。<pre>
http://site.example.com/admin/cron.php?password=opensesame
</pre>これが空白の場合、パスワードは要求されません。';
$string['configcurlcache'] = 'cURLキャッシュの有効期間 (Time-to-live) を秒で指定してください。';
$string['configcustommenuitems'] = 'あなたはテーマに表示されるカスタムメニューをここで設定することができます。それぞれの行はパイプ文字 (|) によって分離されたメニューテキスト、リンクURL (任意) およびツールチップタイトル (任意) により構成されます。あなたはハイフンを使用して構造を定義することもできます。例えば次のようになります:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';
$string['configdbsessions'] = 'この設定を有効にした場合、現在のセッション情報を保存するためにデータベースが使用されます。この設定を変更すると、(あなたも含めて) 現在のユーザがログアウトされことに留意してください。あなたがMySQLを使用している場合、my.cnf (またはmy.ini) の「max_allowed_packet」を少なくとも4Mにしてください。他のセッションドライバは直接config.phpで設定することができます。詳細はconfig-dist.phpをご覧ください。あなたがconfig.phpファイル内でセッションドライバを指定した場合、このオプションは非表示とされます。';
$string['configdebug'] = 'この設定を有効にした場合、PHPのerror_reportingが増加し、より多くの警告が表示されるようになります。これは開発者のみに便利な設定です。';
$string['configdebugdisplay'] = 'この設定を有効にした場合、エラー報告はHTMLページに表示されます。これは実際、役に立ちますが、一般的にXHTML、JS、cookiesおよびHTTPヘッダを壊します。この設定を無効にした場合、エラー報告はサーバログに記録され、デバッグしやすくなります。PHP設定のerror_logにて、どのログを記録するかコントロールできます。';
$string['configdebugpageinfo'] = 'この設定を有効にした場合、ページフッタにページ情報が表示されます。';
$string['configdebugsmtp'] = 'メールメッセージがSMTPサーバに送信される間、詳細デバッグ情報を表示します。';
$string['configdebugvalidators'] = 'この設定を有効にした場合、フッタに外部Validatorサーバのリンクが表示されます。あなたは新たなユーザ名「w3cvalidator」を作成して、ゲストアクセスを有効にする必要があります。これらの変更により、サーバに対して不正なアクセスを許可してしまうことになります。実運用サイトでは有効にしないでください!';
$string['configdefaulthomepage'] = 'ここではログインユーザのホームページを設定します。';
$string['configdefaultrequestcategory'] = 'ユーザからリクエストされたコースは自動的にこのカテゴリに配置されます。';
$string['configdefaultrequestedcategory'] = 'リクエストされたコースが承認された場合、コースが設置されるデフォルトカテゴリです。';
$string['configdefaultuserroleid'] = 'すべてのログインユーザにはそれぞれのユーザに与えられるロールに加えて、あなたがここで指定したケイパビリティを持つロールがサイトレベルで与えられます。デフォルトは認証済みユーザロールです。ここでの設定はユーザに与えられているロールと衝突することはなく、すべてのユーザにコースレベルで割り当てすることができないケイパビリティを割り当てます (例 ブログエントリの投稿、自分のカレンダーの管理等)。';
$string['configdeleteincompleteusers'] = 'この期間終了後、完全にセットアップされていない古いアカウントが削除されます。';
$string['configdeleteunconfirmed'] = 'メールによる認証を利用している場合、この値はユーザからの返答を受けつける期間を指します。この期間終了後、セットアップ未了の古いアカウントが削除されます。';
$string['configdenyemailaddresses'] = '特定ドメインから新しいメールアドレスを拒否したい場合、ここにスペースで区切って入力してください。他のドメインはすべて認められます。サブドメインを拒否するには設定値の先頭に「.」を追加してください。例  <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'ユーザがユーザプロファイルイメージを変更できないようにします。';
$string['configdisplayloginfailures'] = 'ここで選択したユーザに、前回のログイン失敗情報を表示します。';
$string['configdndallowtextandlinks'] = 'この設定を有効にした場合、コースへのテキスト、リンクおよびファイルのドラッグ＆ドロップを有効にします。Firefoxへのテキストのドラッグ、または異なるブラウザ間でのテキストのドラッグは信頼性に欠けます。結果として、データがアップロードされない、または文字化けしたテキストがアップロードされる可能性があることに留意してください。';
$string['configdocroot'] = 'それぞれのページのフッタに表示される「このページのMoodle Docs」に関して、文脈固有のMoodle Docsのパスを定義してください。このフィールドが空白のままにされた場合、リンクは表示されません。';
$string['configdoctonewwindow'] = 'この設定を有効にした場合、新しいウィンドウにMoodle Docsの内容が表示されます。';
$string['configeditordictionary'] = 'この値はAspellがユーザ言語の辞書を持っていない場合に使用されます。';
$string['configeditorfontlist'] = 'エディタのドロップダウンリストに表示されるフォントを選択してください。';
$string['configemailchangeconfirmation'] = 'ユーザがプロファイルでメールアドレスを変更した場合、メール確認ステップを求めます。';
$string['configenableajax'] = 'ここではサイト全体におけるAJAXの使用をコントロールします。AJAXはドラッグ＆ドロップ等、特定の機能に必要です。';
$string['configenableblogs'] = 'ここではサイトユーザすべてに独自のブログを提供します。';
$string['configenablecalendarexport'] = 'カレンダーのエクスポートまたは購読を有効にします。';
$string['configenablecomments'] = 'コメントを有効にします。';
$string['configenablecourserequests'] = 'すべてのユーザにコース作成のリクエストを許可します。';
$string['configenabledevicedetection'] = 'テーマおよび他の機能を適用するため、携帯電話、スマートフォン、タブレットまたはデフォルトデバイス (デスクトップPC、ノートPC等) の検出を有効にします。';
$string['configenablegroupmembersonly'] = 'この設定を有効にした場合、グループメンバーのみに活動へのアクセスを制限することができます。この設定により、あなたのサーバの負荷を増大させることになります。加えて活動を非グループメンバーより隠すため、評定表カテゴリを特別な方法でセットアップする必要があります。';
$string['configenablemobilewebservice'] = '公式Moodle appまたは他のappが要求するモバイルサービスを有効にします。詳細は {$a} をご覧ください。';
$string['configenablerssfeeds'] = 'このオプションを有効にした場合、ブログ、フォーラム、データベース活動および用語集を含むサイト全体の様々な機能によってRSSフィードが生成されます。特定のモジュールでRSSフィードを有効にする必要があることに留意してください。';
$string['configenablerssfeedsdisabled'] = 'サイトすべてにおいてRSSフィードが無効にされているため、利用できません。管理設定内の詳細設定にて、RSSフィードを利用可にすることができます。';
$string['configenablerssfeedsdisabled2'] = 'RSSフィードはサーバレベルで無効にされています。あなたは最初に「サーバ > RSS」にて、RSSを有効にする必要があります。';
$string['configenablesafebrowserintegration'] = 'この設定を有効にした場合、小テスト設定の「ブラウザセキュリティ」フィールドに「Safe Exam Browserの使用を必要とする」を追加します。詳細は、http://www.safeexambrowser.org/ をご覧ください。';
$string['configenablestats'] = 'この設定を有効にした場合、Moodleのcronジョブがログを処理して統計情報を集めます。あなたのサイトのトラフィックにより、しばらく時間がかかる場合があります。このオプションを有効にした場合、あなたのそれぞれのコースまたはサイト全体に関して、面白いグラフおよび統計データを閲覧することができます。';
$string['configenabletrusttext'] = 'デフォルトではMoodleは常にユーザによりアップロードされたセキュリティ上のリスクのある悪意を持ったスクリプト、メディア等をテキストを完全にクリーニングします。コンテンツ信頼システムでは特定のユーザによるコンテンツに対して、干渉しない拡張機能を適用することができます。このシステムを動作させるには最初にこの設定を有効にした後、個別のMoodleロールにコンテンツ信頼パーミッションを与える必要があります。このようなユーザにより作成またはアップロードされたテキストには信頼されている旨のマークが付けられ、表示前にクリーニングされることはありません。';
$string['configenablewebservices'] = 'ウェブサービスでは他のシステムがこのMoodleにログインして操作できるようにします。セキュリティのため、あなたが本当に使用したい場合以外、この機能を無効にしてください。';
$string['configenablewsdocumentation'] = 'ウェブサービスドキュメンテーションの自動生成を有効にします。ユーザは「セキュリティキー」ページにてドキュメンテーションにアクセスすることができます。有効にされたプロトコルのドキュメンテーションのみ表示されます。';
$string['configerrorlevel'] = '表示したいPHPの警告数を選択してください。通常はNormalが最良の選択です。';
$string['configexportlookahead'] = 'エクスポート中に考慮する将来の日数';
$string['configexportlookback'] = 'エクスポート中に考慮する過去の日数';
$string['configextendedusernamechars'] = 'この設定を有効にした場合、学生はユーザ名にどのような文字でも使用することができます (実際の名前には影響しません)。デフォルトは英数字小文字、アンダースコア (_)、ハイフン (-)、ピリオド (.) またはアットマーク (@) の使用を制限する「無効」です。';
$string['configextramemorylimit'] = 'サーチ、バックアップ/リストアまたはcronのようなスクリプトではさらなるメモリを必要とします。規模の大きなサイトでは設定値を上げてください。';
$string['configfilterall'] = 'ヘッダ、タイトル、ナビゲーションバー等を含むすべての文字をフィルタします。これは多言語フィルタを使用しているときに最も有用です。そうでない場合、あなたのサイトに単に負荷がかかるだけになります。';
$string['configfiltermatchoneperpage'] = 'オートリンクフィルタはページ全体で最初のテキストマッチングに該当した1つのテキストリンクのみ生成します。他のすべては無視されます。';
$string['configfiltermatchonepertext'] = 'オートリンクフィルタはそれぞれのアイテムのページテキスト (例 リソース、ブロック) で最初のテキストマッチングに該当した1つのテキストリンクのみ生成します。「1ページあたり1回フィルタマッチする」が有効にされている場合、この設定は無視されます。';
$string['configfilteruploadedfiles'] = '「すべてのファイル」はアップロードしたすべてのHTMLおよびテキストファイル、「HTMLファイルのみ」はアップロードしたHTMLファイルのみ、表示する前にフィルタをかけます。「なし」は全くフィルタをかけません。';
$string['configforcelogin'] = '通常、サイトおよびコース一覧 (コースではなく) のフロントページはサイトにログインせずに閲覧することができます。すべての操作の前にユーザにログインを強制したい場合、この設定を有効にしてください。';
$string['configforceloginforprofiles'] = 'この設定ではユーザプロファイルページの閲覧に関して、(ゲストではない) 実アカウントでのログインをユーザに強制します。この設定を無効にした場合、ユーザが広告 (スパム) を投稿、または他の不適切なコンテンツをプロファイルに投稿して、世界中から閲覧できる可能性があります。';
$string['configfrontpage'] = '上で選択したアイテムはサイトフロントページに表示されます。';
$string['configfrontpagecourselimit'] = '最大コース数';
$string['configfrontpagecourselimithelp'] = 'サイトフロントページのコース一覧に表示される最大コース数です。';
$string['configfrontpageloggedin'] = '上で選択したアイテムはユーザのログイン時にサイトフロントページに表示されます。';
$string['configfullnamedisplay'] = 'ここでは氏名がどのように表示されるか設定します。デフォルト値「language」のままにした場合、現在の言語パック内のストリング「fullnamedisplay」が決定します。いくつかの言語では異なる氏名表示の慣習があります。

単一言語を使用したほとんどのサイトでは「名 + 姓」を使用した方が良いでしょう。しかし、あなたは姓を完全に隠すこともできます。使用できるプレースホルダは次のとおりです:
firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, alternatename';
$string['configgeoipfile'] = 'GeoIP Cityバイナリデータファイルのロケーションです。このファイルはMoodleディストリビューションの一部ではなく、<a href="http://www.maxmind.com/">MaxMind</a>から個別に取得する必要があります。あなたは商用バージョンを購入、または無料バージョンを使用することができます。無料バージョンの場合、<a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> からダウンロードして、あなたのサーバの「 {$a} 」ディレクトリに解凍してください。';
$string['configgetremoteaddrconf'] = 'リバースプロクシの背後にサーバを設置している場合、あなたはリモートIPアドレスを含んだ信頼できるHTTPヘッダを指定することができます。ヘッダは順番に読まれ、最初の有効なヘッダが使用されます。';
$string['configgradebookroles'] = 'ここでは誰が評定表に表示されるか設定することができます。ユーザがコースの評定表で表示されるためには、これらの中から少なくとも１つのロールを割り当ててください。';
$string['configgradeexport'] = 'どの評定表エクスポートフォーマットをあなたの主要な評定表エクスポート方法にするか選択してください。選択されたフォーマットのプラグインが設定され、すべての評定の「最新エクスポート」フィールドに使用されます。例えば、エクスポートされたレコードは「新規」または「更新」レコードとして認識されます。この設定に関して自信を持てない場合、すべてをチェックしないままにしてください。';
$string['confighiddenuserfields'] = 'あなたがコース教師/管理者以外のユーザに隠したいユーザ情報フィールドを選択してください。この設定により、ユーザのプライバシーを強化することができます。複数フィールドを選択するにはCTRLキーを押したままにしてください。';
$string['configidnumber'] = 'このオプションでは次の内容を設定します。(a)ユーザがユーザIDの入力を求められない、(b)ユーザがユーザIDを空白にすることができる、(c)ユーザはユーザIDの入力を求められ、空白にできない。ユーザIDが入力された場合、ユーザのプロファイルに表示されます。';
$string['configintro'] = 'このページではあなたのサーバでMoodleが最適に動くための設定値を入力できます。設定値を過度に心配しないでください - 通常、デフォルト値で最適に動作するよう設定されています。いつでもこのページに戻って再度設定することができます。';
$string['configintroadmin'] = 'このページではサイトすべてを管理できる最高管理者アカウントを作成します。正しいメールアドレスおよび安全なユーザ名、パスワードを設定してください。あなたは後でさらに管理者アカウントを作成することができます。';
$string['configintrosite'] = 'このページではこの新しいサイトのフロントページおよびサイト名を設定します。管理メニューを使用することで、いつでもここに戻って、これらの設定を変更することができます。';
$string['configiplookup'] = 'あなたがログ等でIPアドレス (例 34.12.222.93) をクリックした場合、そのIPアドレスがどこから来たものなのか推量しやすいマップが表示されます。この機能にはあなたが選択できる異なるプラグインがあり、それぞれに利点と不利点があります。';
$string['configkeeptagnamecase'] = 'ユーザが入力したタグ名の大文字小文字を保持したい場合、この設定を有効にしてください。';
$string['configlang'] = 'サイト全体に適用されるデフォルト言語を選択してください。ユーザは言語設定メニューまたはパーソナルプロファイルにより、この設定をオーバーライドすることができます。';
$string['configlanglist'] = 'ここを空白にすることで、インストールしたMoodleのすべての言語をユーザが選択することができます。カンマで区切ることにより、言語メニューを短くすることができます。例: ja,en,es_es,fr,it';
$string['configlangmenu'] = '汎用の言語選択メニューをホームページ、ログインページ等に表示するかどうか選択してください。この設定はユーザプロファイルでユーザが表示言語を選択することに影響を及ぼしません。';
$string['configlangstringcache'] = 'すべての言語ファイルをデータディレクトリ内のコンパイル済みファイル内にキャッシュします。あなたがMoodleを翻訳またはMoodleソースコード内のストリングを変更している場合、無効にしてください。そうでない場合、パフォーマンスを向上させるため有効のままにしてください。';
$string['configlatinexcelexport'] = 'Excelエクスポートのエンコーディングを選択してください。';
$string['configlocale'] = 'サイト全体に適用されるロケールを選択してください - この設定はすべての言語パックの日付の書式および言語をオーバーライドします (カレンダーの曜日には影響しません)。あなたのオペレーティングシステムにロケールデータがインストールされている必要があります (例 linuxの場合、ja_JP.UTF-8、en_US.UTF-8、es_ES.UTF-8)。 ほとんどの場合、このフィールドは空白のままにしてください。';
$string['configloginhttps'] = 'この設定を有効にした場合、Moodleはログインページのみセキュアhttps接続 (セキュアログイン) を使用します。その後、一般的な速度を保つため、通常のhttp URLに戻ります。警告: この設定ではウェブサーバのhttpsを厳密に有効にする必要があります。httpsが有効ではない状態でこの設定を有効にした場合、あなたは自分のサイトから閉め出されることになります。';
$string['configloglifetime'] = 'ここではユーザの活動に関するログの保持期間を設定します。指定した値より古いログは自動的に削除されます。あなたが必要な場合、可能な限り長い間ログを保持することをお勧めしますが、アクセス数が多く、サーバのパフォーマンスに問題がある場合、ログの保持期間を短く設定してください。統計が正常に動作しないため、30以下の値はお勧めできません。';
$string['configlookahead'] = '直近イベント日';
$string['configmaxbytes'] = 'ここではサイト全体でアップロードできるファイルの最大サイズを設定します。この設定はPHP設定のpost_max_sizeおよびupload_max_filesize、同様にApache設定のLimitRequestBodyに制限されます。maxbytesはコースレベルまたはモジュールレベルで選択できるサイズの範囲を制限します。「サーバリミット」が選択された場合、サーバで設定された最大値が使用されます。';
$string['configmaxconsecutiveidentchars'] = 'パスワードにはこの値以上の連続した同一文字を使用することができません。このチェックを無効にするには、ゼロを指定してください。';
$string['configmaxeditingtime'] = 'ここではフォーラム投稿、用語集コメント等を編集可能な時間を設定します。通常、30分が適切な値です。';
$string['configmaxevents'] = '直近イベント数';
$string['configmaxusersperpage'] = 'コース、グループ、コーホート、ウェブサービス等において、ユーザセレクタに表示するユーザの最大数です。';
$string['configmessaging'] = 'サイトユーザ間でメッセージシステムを利用できるようにしますか?';
$string['configmessagingallowemailoverride'] = 'ユーザに対して、プロファイルに設定されたメールアドレス以外のメールアドレスへの通知メッセージ送信を許可します。';
$string['configmessagingdeletereadnotificationsdelay'] = 'スペースを空けるため、未読通知を削除することができます。どのくらいの期間の後、未読通知を削除しますか?';
$string['configmessaginghidereadnotifications'] = 'メッセージ履歴を閲覧する場合、フォーラム投稿のようなイベント未読通知を隠します。';
$string['configminpassworddigits'] = 'パスワードには少なくともここで設定した数の数字を使用する必要があります。';
$string['configminpasswordlength'] = 'パスワードは少なくともここで設定した長さである必要があります。';
$string['configminpasswordlower'] = 'パスワードには少なくともここで設定した数の小文字を使用する必要があります。';
$string['configminpasswordnonalphanum'] = 'パスワードには少なくともここで設定した数の非英数字を使用する必要があります。';
$string['configminpasswordupper'] = 'パスワードには少なくともここで設定した数の大文字を使用する必要があります。';
$string['configmobilecssurl'] = 'あなたのモバイルアプリインターフェースをカスタマイズするCSSファイルです。';
$string['configmodchooserdefault'] = 'デフォルトで活動チューザをユーザに表示しますか?';
$string['configmycoursesperpage'] = 'ユーザ自身のコース一覧に表示される最大コース数です。';
$string['configmymoodleredirect'] = 'この設定では管理者以外のユーザがログインした場合、強制的に「/my」へリダイレクトします。また、トップレベルのサイトナビゲーションを「/my」に置き換えます。';
$string['configmypagelocked'] = 'この設定により、非管理者からデフォルトページが編集されることを防ぎます。';
$string['confignavcourselimit'] = 'ここではユーザが未ログインまたはコースに登録されていない場合に表示されるコース数を制限します。';
$string['confignavshowallcourses'] = 'ここではコースに登録されているユーザがナビゲーション内にコース (すべてのコース一覧) およびマイコース (受講登録しているコース一覧) を閲覧できるかどうか決定します。';
$string['confignavshowcategories'] = 'ナビゲーションバーおよびナビゲーションブロックにコースカテゴリを表示します。この設定変更は現在ユーザが登録しているコースには反映されません。これらのコースでのナビゲーションバーおよびナビゲーションブロックはカテゴリなしのマイコース下に表示されます。';
$string['confignotifyloginfailures'] = 'ログイン失敗が記録された場合、メール通知を送信することができます。誰が通知を受け取りますか?';
$string['confignotifyloginthreshold'] = 'ログイン失敗通知が有効の場合、同一ユーザまたはIPアドレスで何回ログインに失敗した場合に通知を送信しますか?';
$string['confignotloggedinroleid'] = 'サイトにログインしていないユーザはサイトコンテクストに関して、このロールが割り当てられているかのように扱われます。ほとんどの場合、あなたがここで割り当てるロールは「ゲスト」で十分ですが、権限を減らしたロールまたはさらに制限されたロールを作成することもできます。それでもフォーラムへの投稿等はユーザが適切にログインする必要があります。';
$string['configopentogoogle'] = 'この設定を有効にした場合、Googleはあなたのサイトにゲストとして入ることができます。加えてGoogleが自動的に記録したデータを元に他の人がゲストとしてあなたのサイトにアクセスできます。これはすでにゲストアクセスを許可しているコースのみ、透過アクセスを提供することに留意してください。';
$string['configoverride'] = 'config.phpで設定済み';
$string['configpasswordpolicy'] = 'この設定を有効にした場合、パスワードポリシーを基にMoodleがユーザパスワードの妥当性をチェックします。あなたのポリシーを指定するため、下記設定を使用してください (この設定を無効にした場合、下記設定は無視されます)。';
$string['configpasswordresettime'] = 'この設定では有効期限切れ前にユーザがパスワードを確認する必要のある時間を指定します。通常、30分が適切な値です。';
$string['configpathtoclam'] = 'ClamAVのパスを指定してください。恐らく「/usr/bin/clamscan」または「/usr/bin/clamdscan」のようになります。あなたがclam AVを動作させるためには、clam AVのパスを指定する必要があります。';
$string['configpathtodu'] = 'duのパスを指定してください。恐らく「/usr/bin/du」のようになります。あなたがduのパスを設定した場合、多くのファイルを含んだディレクトリに関してディレクトリコンテンツを表示するページの表示速度がはるかに速くなります。';
$string['configperfdebug'] = 'この設定を有効にした場合、パフォーマンス情報がスタンダードテーマのフッタに表示されます。';
$string['configprofileroles'] = 'ユーザプロファイルおよび参加者ページにて閲覧可能なロールの一覧です。';
$string['configprofilesforenrolledusersonly'] = 'スパム送信者による乱用を避けるため、コースに受講登録されていないユーザに関するプロファイルの自己紹介欄が非表示にされます。プロファイルの自己紹介欄にコンテンツを追加するには、新しいユーザは少なくとも1つのコースに受講登録する必要があります。';
$string['configprotectusernames'] = 'デフォルトでは、forget_password.phpはユーザ名またはメールアドレスを推測できるヒントを表示しません。';
$string['configproxybypass'] = 'プロクシをバイパスする、ホスト名 (一部) またはIPアドレスのカンマ区切り一覧です (例 192.168., .mydomain.com)。';
$string['configproxyhost'] = '<b>サーバ</b>のインターネットアクセスにプロクシ (例 ファイアーウォール) が必要な場合、プロクシのホスト名を入力してください。必要でない場合、空白にしてください。';
$string['configproxypassword'] = 'プロクシ経由でインターネットにアクセスする必要がある場合、パスワードを入力してください。必要でない場合、空白にしてください (PHP cURL拡張モジュールが必要です)。';
$string['configproxyport'] = 'サーバがプロクシの使用を必要とする場合、ここにプロクシのポート番号を入力してください。';
$string['configproxytype'] = 'ウェブプロクシのタイプです (SOCKS5をサポートするには、PHP5およびcURL拡張モジュールが必要です)。';
$string['configproxyuser'] = 'プロクシ経由でインターネットにアクセスする必要がある場合、ユーザ名を入力してください。必要でない場合、空白にしてください (PHP cURL拡張モジュールが必要です)。';
$string['configquarantinedir'] = 'ClamAVによって感染ファイルを隔離用ディレクトリに移動させたい場合、そのディレクトリを入力してください。このディレクトリはウェブサーバより書き込みができるようにする必要があります。空白にした場合、または存在しないか、書き込み権がないディレクトリを指定した場合、感染ファイルは削除されます。末尾にスラッシュを付けないでください。';
$string['configrecaptchaprivatekey'] = 'あなたのMoodleサーバおよびrecaptcha.netサーバ間の通信に使用する文字列です。このサイト用に次のサイトから取得してください: http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'サインアップフォームでreCAPTCHA要素の表示時に使用される文字列です。http://www.google.com/recaptchaで生成されます。';
$string['configrequestcategoryselection'] = 'コースリクエスト時、カテゴリ選択を許可します。';
$string['configrequestedstudentname'] = 'リクエストされたコースで使用する学生 (単数) に対する呼称';
$string['configrequestedstudentsname'] = 'リクエストされたコースで使用する学生 (複数) に対する呼称';
$string['configrequestedteachername'] = 'リクエストされたコースで使用する教師 (単数) に対する呼称';
$string['configrequestedteachersname'] = 'リクエストされたコースで使用する教師 (複数) に対する呼称';
$string['configrequiremodintro'] = 'あなたがそれぞれのユーザに活動説明の入力を強制したくない場合、このオプションを無効にしてください。';
$string['configrunclamavonupload'] = 'この設定を有効にした場合、すべてのアップロードファイルをスキャンするためにClamAVが使用されます。';
$string['configrunclamonupload'] = 'ファイルアップロード時にclam AVを動作させますか? 正常に動作させるにはpathtoclamに正しいパスを入力する必要があります (ClamAVは次の場所で入手できる無料ウイルススキャナです: http://www.clamav.net/)。';
$string['configsectioninterface'] = 'インターフェース';
$string['configsectionmail'] = 'メール';
$string['configsectionmaintenance'] = 'メンテナンス';
$string['configsectionmisc'] = 'その他';
$string['configsectionoperatingsystem'] = 'オペレーティングシステム';
$string['configsectionpermissions'] = 'パーミッション';
$string['configsectionrequestedcourse'] = 'コースリクエスト';
$string['configsectionsecurity'] = 'セキュリティ';
$string['configsectionstats'] = '統計';
$string['configsectionuser'] = 'ユーザ';
$string['configsecureforms'] = 'フォームデータを受け入れる場合、Moodleでは追加的なレベルのセキュリティを使用することができます。この設定を有効にした場合、ブラウザのHTTP_REFERER変数とフォーム設置のアドレスが照合されます。 ユーザがファイアーウォール (例 Zonealarm) を使用してトラフィックからHTTP_REFERERを取除く設定をしている場合、まれに問題が生じる場合があります。 これはフォーム使用時に画面が「固まる」現象です。例えば、ユーザがログインページで問題を抱えている場合、この設定を無効にしてください。しかし、この設定ではあなたのサイトがブルートフォース・パスワードアタックに対して、無防備な状態になります。分からない場合、この設定を「Yes」のままにしてください。';
$string['configsessioncookie'] = 'ここではMoodleセッションで使用されるクッキーの名称をカスタマイズします。1つ以上のMoodleが同じウェブサイトで稼動している場合、クッキーが混乱するのを防ぐためだけに、この設定を任意でお使いください。';
$string['configsessioncookiedomain'] = 'ここではMoodleクッキーが利用できるドメインを変更します。これは別のサブドメインのウェブアプリケーションとMoodleセッションを共有する必要のある、特別なMoodle (例 認証または登録プラグイン) に有用です。<strong>警告: この設定をデフォルト (空) のままにすることを強くお勧めします - 正しくない値を設定することで、すべてのユーザがサイトにログインできなくなります。</strong>';
$string['configsessioncookiepath'] = 'ブラウザが送信するMoodleクッキーの場所を変更したい場合、ここでウェブサイトのサブディレクトリを指定することができます。変更しない場合、デフォルトの「/」を使用してください。';
$string['configsessiontimeout'] = 'このサイトにログインして長時間何もしない (ページを読み込まない) 場合、ユーザを自動的にログアウト (セッション終了) させます。この変数には、ログアウトさせるまでの時間を設定します。';
$string['configshowcommentscount'] = 'コメント総数を表示します。コメントリンクの表示時にさらに1つのクエリ実行による負荷がかかります。';
$string['configshowicalsource'] = 'iCalイベントのソース情報を表示する';
$string['configshowsiteparticipantslist'] = 'サイトすべての学生および教師がサイト参加者リストに表示されます。誰がこのサイト参加者リストを閲覧することができますか?';
$string['configsitedefaultlicense'] = 'デフォルトサイトライセンス';
$string['configsitedefaultlicensehelp'] = 'デフォルトライセンスはこのサイトのコンテンツを公開するため使用されます。';
$string['configsitemaxcategorydepth'] = '最大カテゴリ深度';
$string['configsitemaxcategorydepthhelp'] = 'ここではカテゴリまたはコンボリストの表示時に展開表示される子カテゴリの最大深度を設定します。深いレベルのカテゴリはリンクとして表示され、ユーザはAJAXリクエストにより展開することができます。';
$string['configslasharguments'] = 'ファイル (イメージ、アップロード等) はスラッシュを使ってスクリプト経由で受け渡されます。この方法により、簡単にブラウザ、プロクシ等にイメージを一時保存させることができます。いくつかのPHPサーバでは、この方法が取れない場合があります。アップロードされたファイルまたはイメージ (例 ユーザ画像) の表示に問題がある場合、この設定を無効にしてください。';
$string['configsmartpix'] = 'この設定を有効にした場合、PHPスクリプトが現在のテーマ、そしてすべてのテーマ、最後にMoodle/pixフォルダを検索して、アイコンを表示します。これにより、テーマ間の重複するイメージファイルを減らすことができますが、パフォーマンスにおいてわずかな負荷がかかります。';
$string['configstartwday'] = '週の始め';
$string['configstatsfirstrun'] = 'ここではcronジョブが<b>最初の</b>統計処理で、どのくらい過去にさかのぼるか指定します。トラフィックが多く、共有ホスティングを利用している場合、あまりにも過去にさかのぼることは良い考えではありません。統計処理は長時間を必要とし、リソースに過大な負荷がかかります (この設定では1ヵ月 = 28日となることに留意してください。グラフおよびレポートの生成には1ヶ月 = 1カレンダー月が使用されます)。';
$string['configstatsmaxruntime'] = '統計処理ではサーバに大きな負荷がかかる場合があります。このオプションおよび次のオプションの組み合わせで、「いつ」および「どのくらい」稼動させるか設定してください。';
$string['configstatsmaxruntime2'] = '統計処理ではサーバに大きな負荷がかかる場合があります。1日の統計データの収集で許可する最大時間を指定してください。1回のcron実行で処理できる最大日数は31です。';
$string['configstatsmaxruntime3'] = '1日のうち、統計の計算に許される最大時間を指定してください。統計処理はサーバに対して大きな負荷がかかることに留意してください。1つのcronで処理する最大日数は次の設定で指定することができます。';
$string['configstatsruntimedays'] = 'それぞれの統計処理で処理する最大日数を指定してください。統計が最新の場合、1日のみ処理されますので、あなたのサーバの負荷に応じて設定値を調整してください。cron実行間隔が短い場合、この値を小さくしてください。';
$string['configstatsruntimestart'] = '何時にcronジョブの統計処理を開始しますか? 1つのサーバに複数のMoodleが存在する場合、それぞれ異なる時間を指定することをお勧めします。';
$string['configstatsuserthreshold'] = 'この設定では統計計算に含まれるコースの登録ユーザ最少数を指定します。';
$string['configstrictformsrequired'] = 'フォームの必須フィールドにスペースまたは改行のみが入力された場合に受け付けないようにします。';
$string['configstripalltitletags'] = 'この設定を無効にした場合、活動およびリソース名にHTMLタグの使用を許可します。';
$string['configsupportemail'] = 'このメールアドレスは一般的なサポート (例えば、ユーザが自分の新しいアカウントを作成する) が必要な場合、このサイトのユーザに公開されます。この欄を空白のままにした場合、そのような有益なメールアドレスは提供されません。';
$string['configsupportname'] = 'これはサポートメールまたはウェブ経由で一般的なサポートを提供する人の名前または団体の名称です。';
$string['configsupportpage'] = 'このウェブアドレスは一般的なサポート (例えば、ユーザが自分の新しいアカウントを作成する) が必要な場合、このサイトのユーザに公開されます。この欄を空白のままにした場合、リンクは提供されません。';
$string['configthemedesignermode'] = '通常パフォーマンスのため、すべてのテーマイメージおよびスタイルシートは長期間ブラウザおよびサーバ内にキャッシュされます。あなたがテーマをデザインまたはコードを開発している場合、キャッシュされたバージョンを表示しないため、この設定を有効にしてください。警告: この設定により、あなたのサイトがすべてのユーザに対して遅くなります! 代わりに「テーマセレクタ」ページにて手動でテーマキャッシュをクリアすることができます。';
$string['configthemelist'] = '空白にした場合、すべてのテーマを使用することができます。テーマメニューを短くしたい場合、カンマで区切ったテーマ名を入力してください (テーマ名に空白を使用しないでください!)。例: standard,orangewhite';
$string['configtimezone'] = 'これは日付表示のためのデフォルトタイムゾーンです。それぞれのユーザはこの設定をプロファイルでオーバーライドすることができます。「サーバローカルタイム」はMoodleデフォルトをPHPのサーバ設定にします。しかし、ユーザプロファイルでの「サーバローカルタイム」はユーザデフォルトをこのタイムゾーン設定にします。あなたの地域固有のタイムゾーンを選択したタイムゾーンの更新をお勧めします。';
$string['configuseblogassociations'] = 'ユーザがブログエントリをコースおよびコースモジュールに関連付けることができるようにしますか?';
$string['configuseexternalyui'] = 'ローカルファイルを使用する代わりに、Yahooサーバで利用可能なオンラインファイルを使用します。警告: この設定にはインターネット接続が必要です。そうでない場合、あなたのサイトでAJAXは動作しません。この設定はhttpsを使用しているサイトには反映されません。';
$string['configuserquota'] = 'ユーザがプライベートファイルエリアに保存することのできる最大バイト数です。{$a->bytes} バイト == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'この設定を有効にした場合、「サイトページ」の代わりにサイト省略名がナビゲーションのサイトページノードに使われます。';
$string['configusetags'] = 'サイト全体でタグ機能を有効にしますか?';
$string['configvariables'] = '詳細設定';
$string['configverifychangedemail'] = '変更済みメールアドレスの確認に関して、「許可されるメールアドレスのドメイン」および「拒否されるメールアドレスのドメイン」設定を使用します。この設定が無効にした場合、新しいユーザ作成時のみ、ドメインが強制されます。';
$string['configvisiblecourses'] = '非表示のカテゴリ内に通常どおりコースを表示します。';
$string['configwarning'] = '慎重にこれらの設定を変更してください - 間違った設定はトラブルの原因となります。';
$string['configyuicomboloading'] = 'このオプションによりYUIライブラリの入出力共用ファイルの読み込みを最適化することができます。パフォーマンスの理由から、実運用サイトではこの設定を有効にしてください。';
$string['confirmation'] = '確認';
$string['confirmdeletecomments'] = '本当にコメントを削除してもよろしいですか?';
$string['confirmed'] = '確認済み';
$string['convertformat'] = '<i>convert</i> 出力フォーマット';
$string['cookiehttponly'] = 'HTTPクッキーのみ';
$string['cookiesecure'] = 'セキュアクッキーのみ';
$string['country'] = 'デフォルトの国';
$string['coursecontact'] = 'コース管理者';
$string['coursecontact_desc'] = 'ここでは誰がコース説明に表示されるか設定することができます。ユーザがコース説明に表示されるためには、これらの中から少なくとも１つのコースロールを割り当てる必要があります。';
$string['courselistshortnames'] = '拡張コース名をを表示する';
$string['courselistshortnames_desc'] = '有効にした場合、コース一覧においてコースフルネームに加えてコース省略名が表示されます。必要であれば、言語カスタマイゼーション機能を使用して「courseextendednamedisplay」言語ストリングを編集することで、拡張コース名をカスタマイズすることができます。';
$string['coursemgmt'] = 'コースおよびカテゴリを管理する';
$string['courseoverview'] = 'コース概要';
$string['courserequestnotify'] = 'コースリクエスト通知';
$string['courserequestnotifyemail'] = 'ユーザ {$a->user} が {$a->link} で新しいコースをリクエストしました。';
$string['courserequests'] = 'コースリクエスト';
$string['courserequestspending'] = '保留中のコースリクエスト';
$string['courses'] = 'コース';
$string['coursesperpage'] = '1ページあたりのコース数';
$string['courseswithsummarieslimit'] = 'コース概要を含むコースの制限';
$string['creatornewroleid'] = '新しいコースにおけるコース作成者のロール';
$string['creatornewroleid_help'] = 'ユーザに新しいコースを管理するパーミッションがない場合、このロールを使用して自動的に受講登録されます。';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'コマンドラインでのみcronを実行する';
$string['cronerrorclionly'] = '申し訳ございません、このページへのインターネットアクセスは管理者より無効にされています。';
$string['cronerrorpassword'] = '申し訳ございません、あなたにはこのページにアクセスするための有効なパスワードを提供していません。';
$string['cron_help'] = 'cron.phpメンテナンススクリプトは新しいフォーラム投稿のコピーをメール送信する等、スケジュールベースでMoodleモジュールによるタスク実行をサポートします。例えば5分ごとのようにスクリプトを定期的に実行させる仕組みが必要です。';
$string['cronremotepassword'] = 'リモートアクセスのcronパスワード';
$string['cronwarning'] = '<a href="cron.php">cron.phpメンテナンススクリプト</a>が少なくとも24時間稼動していません。';
$string['ctyperecommended'] = 'あなたのサイトが非ラテン言語をサポートしている場合、サイトパフォーマンスを改善するため、PHP ctype拡張モジュールのインストールを強くお勧めします。';
$string['ctyperequired'] = 'サイトパフォーマンスの改善および多言語サポートを提供するため、MoodleではPHP ctype拡張モジュールが必須です。';
$string['curlcache'] = 'cURLキャッシュTTL';
$string['curlrecommended'] = 'Moodleネットワーキング機能を有効にするため、cURLライブラリのインストールを強くお勧めします。';
$string['curlrequired'] = 'Moodleリポジトリと通信するため、MoodleではPHP cURL拡張モジュールが必須です。';
$string['curltimeoutkbitrate'] = 'cURLタイムアウト計算時のビットレート (Kbps)';
$string['curltimeoutkbitrate_help'] = 'この設定は大きなcURLリクエストの適切なタイムアウトを計算するために使用されます。この計算の一環として、コンテンツサイズを決定するためにHTTP HEADリクエストが作成されます。設定値をゼロにした場合、このリクエストの作成が無効にされます。';
$string['currenttheme'] = '現在のテーマ';
$string['customcheck'] = 'その他のチェック';
$string['custommenu'] = 'カスタムメニュー';
$string['custommenuitems'] = 'カスタムメニューアイテム';
$string['datarootsecurityerror'] = '<p><strong>セキュリティ警告!</strong></p><p>あなたのデータディレクトリは適切ではない場所にあるため、ウェブに晒されています。これはあなたの個人ファイルを世界中の誰でも利用でき、あなたのサイトに対してクラッカーが不正に管理アクセスできることを意味します!</p>
<p>あなたはデータディレクトリ ({$a}) を公開ウェブディレクトリ以外の新しい場所に移動すべきです。それに応じて、あなたのconfig.phpの「<code>$CFG->dataroot</code>」設定を変更してください。</p>';
$string['datarootsecuritywarning'] = 'あなたのサイト設定は安全ではない可能性があります。datarootディレクトリ ({$a}) がウェブから直接アクセスできないことを確認してください。';
$string['dbmigrate'] = 'Moodleデータベース移行';
$string['dbmigrateconnecerror'] = '指定されたデータベースに接続できませんでした。';
$string['dbmigrateencodingerror'] = '指定されたデータベースのエンコードは、必須のユニコード/UTF8とは異なり、{$a} となっています。<br />他のエンコードを指定してください。';
$string['dbmigratepostgres'] = 'あなたはデータベースサーバとして、PostgreSQLを使用しているようです。移行処理を続けるには、移行データを保存するため「ユニコード」 (PostgreSQL 7) または「UTF8」 (PostgreSQL 8) の新たなデータベースを手動で作成してください。続けるには、以下に新たなデータベース接続設定を入力してください:';
$string['dbmigratewarning'] = 'この処理を始める前に、Moodleデータベースをバックアップしたか確認してください。バックアップの方法が分からない場合、システム管理者にご連絡ください。移行プロセス開始後、あなたのMoodleサイトはメンテナンスモードに変更されます。';
$string['dbmigratewarning2'] = '<b>警告: あなたはデータベース移行処理を開始しようとしています。すべてのMoodleデータベースをバックアップしているか、確実に確認してください。</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">このデータベースは廃止され、新しいUTF8データベースに移行されました。このMoodleに新しいデータベースを使用するため、config.phpを編集してください。</font>';
$string['dbmigrationdupfailed'] = 'データベース重複エラー:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'セッション情報にデータベースを使用する';
$string['debug'] = 'デバッグメッセージ';
$string['debugall'] = 'ALL: すべての妥当なPHPデバッグメッセージを表示する';
$string['debugdeveloper'] = 'DEVELOPER: 開発者のための特別Moodleデバッグメッセージ';
$string['debugdisplay'] = 'デバックメッセージを表示する';
$string['debugging'] = 'デバッグ';
$string['debugminimal'] = 'MINIMAL: 致命的なエラーのみ表示する';
$string['debugnone'] = 'NONE: デバッグ情報を表示しない';
$string['debugnormal'] = 'NORMAL: エラー、警告および注意を表示する';
$string['debugpageinfo'] = 'ページ情報を表示する';
$string['debugsmtp'] = 'デバッグメール送信';
$string['debugstringids'] = '言語ストリングの原語を表示する';
$string['debugstringids_desc'] = 'このオプションは翻訳者の補助のために設計されました。このオプションが有効にされた場合、あなたがURLにパラメータ「strings=1」を追加することで、それぞれのストリングの横に言語ファイルおよびストリングIDが表示されます。';
$string['debugvalidators'] = 'Validatorリンクを表示する';
$string['defaultcity'] = 'デフォルトの都道府県';
$string['defaultcity_help'] = 'ここに入力した都道府県は新しいユーザアカウント作成時のデフォルトの都道府県となります。';
$string['defaultformatnotset'] = 'デフォルトコースフォーマットの決定時にエラーが発生しました。サイト設定を確認してください。';
$string['defaulthomepage'] = 'ユーザのデフォルトホームページ';
$string['defaultrequestcategory'] = 'コースリクエストのデフォルトカテゴリ';
$string['defaultsettinginfo'] = 'デフォルト: {$a}';
$string['defaultuserroleid'] = 'すべてのユーザのデフォルトロール';
$string['deleteincompleteusers'] = '不完全なユーザを削除する日数';
$string['deleteunconfirmed'] = 'セットアップ未了のユーザを削除する日数';
$string['deleteuser'] = 'ユーザを削除する';
$string['density'] = '密度';
$string['denyemailaddresses'] = '拒否されるメールアドレスのドメイン';
$string['development'] = '開発';
$string['devicedetectregex'] = 'デバイス検出正規表現';
$string['devicedetectregex_desc'] = '<p>デフォルトではMoodleはデフォルト (デスクトップPC、ラップトップ等)、モバイル (電話およびスモールハンドヘルドデバイス)、タブレット (iPad、Androidタブレット) およびレガシー (Internet Explorer 6ユーザ) のデバイスタイプを検出することができます。テーマセレクタはこれらすべてに異なるテーマを適用するために使用することができます。この設定では特別なデバイスタイプを検出するよう、正規表現を使用できます (これはデフォルトタイプに優先します)。</p>

<p>例えば、一般的に利用される多機能電話を検出するため、 \'/(MIDP-1.0|Maemo|Windows CE)/\' のような正規表現を入力して、戻り値に「featurephone」を設定することができます。この設定により、あなたがこれらのデバイスに使用されるテーマを追加できるよう、テーマセレクタに「featurephone」が追加されます。他の電話はモバイルデバイスタイプで選択されたテーマを使用します。</p>';
$string['devicedetectregexexpression'] = '正規表現';
$string['devicedetectregexvalue'] = '戻り値';
$string['devicetype'] = 'デバイスタイプ';
$string['disableuserimages'] = 'ユーザプロファイルイメージを無効にする';
$string['displayerrorswarning'] = 'いくつかのエラーメッセージではあなたのサーバに関する機密情報を公開する場合があるため、実運用サイトでのPHP設定「display_errors」の有効化はお勧めできません。';
$string['displayloginfailures'] = 'ログイン失敗を表示する';
$string['dndallowtextandlinks'] = 'テキストおよびリンクのドラッグ＆ドロップアップロード';
$string['docroot'] = 'Moodle Docsドキュメントルート';
$string['doctonewwindow'] = '新しいウィンドウで開く';
$string['download'] = 'ダウンロード';
$string['edithelpdocs'] = 'ヘルプドキュメントを編集する';
$string['editingnoncorelangfile'] = 'あなたはアドオンモジュール/プラグインの翻訳済み言語ファイルを修正しようとしています。あなたは、サードパーティの翻訳言語ファイルを_localフォルダのみに保存することができます。サードパーティの翻訳済み言語ファイルはモジュールの言語ディレクトリに移動するか、アドオンモジュールの管理者に送信してください。';
$string['editlang'] = '<b>編集</b>';
$string['editorbackgroundcolor'] = '背景色';
$string['editordictionary'] = 'エディタディレクトリ';
$string['editorfontfamily'] = 'フォントファミリ';
$string['editorfontlist'] = 'フォント一覧';
$string['editorfontsize'] = 'フォントサイズ';
$string['editorhidebuttons'] = 'ボタン非表示';
$string['editorkillword'] = 'ワードフォーマットフィルタ';
$string['editorspelling'] = 'エディタスペリング';
$string['editorspellinghelp'] = 'ここではスペルチェックをするかどうか設定します。この設定を有効にした場合、サーバに<strong>aspell</strong> をインストールする必要があります。';
$string['editstrings'] = '翻訳ストリングを編集する';
$string['emailchangeconfirmation'] = 'メール変更確認';
$string['emoticonalt'] = '代替テキスト';
$string['emoticoncomponent'] = 'イメージコンポーネント';
$string['emoticonimagename'] = 'イメージ名';
$string['emoticons'] = 'エモーティコン';
$string['emoticons_desc'] = 'このフォームではあなたのサイトで使用されるエモーティコン (またはスマイリー) を定義します。テーブルから行を削除するには、すべての必須フィールドを空白にして保存してください。新しいエモーティコンを追加するには、最後の空白行のフィールドに必要事項を入力してください。すべてのフィールドをデフォルト値にリセットするには、上記リンクをクリックしてください。

* テキスト (必須) - このテキストはエモーティコンイメージと置換されます。少なくとも半角2文字を入力してください。
* イメージ名 (必須) - コンポーネントpixフォルダ内のエモーティコンイメージファイル名 (拡張子なし) です。
* イメージコンポーネント (必須) - アイコンを提供するコンポーネントです。
* 代替テキスト (任意) - ストリング識別子およびエモーティコン代替テキストのコンポーネントです。';
$string['emoticonsreset'] = 'エモーティコン設定をデフォルト値にリセットする';
$string['emoticontext'] = 'テキスト';
$string['emptysettingvalue'] = '空';
$string['enableajax'] = 'AJAXを有効にする';
$string['enableblogs'] = 'ブログを有効にする';
$string['enablecalendarexport'] = 'カレンダーエクスポートを有効にする';
$string['enablecomments'] = 'コメントを有効にする';
$string['enablecourserequests'] = 'コースリクエストを有効にする';
$string['enablecssoptimiser'] = 'CSSオプティマイザを有効にする';
$string['enablecssoptimiser_desc'] = 'この設定を有効にした場合、キャッシュされる前にオプティマイザ処理経由でCSSが実行されます。オプティマイザ処理では削除可能なホワイトスペースを削除して再編成するのと同時に、重複ルールおよびスタイルを削除します。この設定をテーマデザイナモードと同時に有効にした場合、パフォーマンスが非常に落ちますが、テーマデザイナが最適化されたCSSを作成する手助けとなることに留意してください。';
$string['enabled'] = '有効';
$string['enabledevicedetection'] = 'デバイス検出を有効にする';
$string['enablegravatar'] = 'Gravatarを有効にする';
$string['enablegravatar_help'] = 'この設定を有効にした場合、ユーザのイメージがアップロードされていない場合にMoodleがGravatartからユーザ写真を取得します。';
$string['enablegroupmembersonly'] = '「グループメンバーのみ利用可」を有効にする';
$string['enablemobilewebservice'] = 'モバイルデバイスのウェブサービスを有効にする';
$string['enablerecordcache'] = 'レコードキャッシュを有効にする';
$string['enablerssfeeds'] = 'RSSフィードを有効にする';
$string['enablesafebrowserintegration'] = 'Safe Exam Browserインテグレーションを有効にする';
$string['enablestats'] = '統計を有効にする';
$string['enabletgzbackups'] = '新しいバックアップフォーマットを有効にする';
$string['enabletgzbackups_desc'] = 'この設定を有効にした場合、将来的なバックアップは新しい圧縮フォーマット.mbzファイルによって作成されます (内部的には.tar.gzファイルとして保存されます)。これは4GBのファイル制限を外し、パフォーマンスを改善することができます。リストアでは両方のフォーマットがサポートされます。また、違いはユーザに分かりやすいものとなります。';
$string['enabletgzbackups_nozlib'] = 'PHP拡張モジュール「zlib」を利用できません。新しいバックアップフォーマットはこのPHP拡張モジュールに依存しているため、zlibがインストールおよび有効にされるまで無効にされます。';
$string['enabletrusttext'] = 'コンテンツ信頼を有効にする';
$string['enablewebservices'] = 'ウェブサービスを有効にする';
$string['enablewsdocumentation'] = 'ウェブサービスドキュメンテーション';
$string['enrolinstancedefaults'] = '登録インスタンスデフォルト';
$string['enrolinstancedefaults_desc'] = '新しいコースのデフォルト登録設定';
$string['enrolmultipleusers'] = 'ユーザを受講登録する';
$string['environment'] = '動作環境';
$string['environmenterrortodo'] = 'このバージョンのMoodleをインストールする前に、発見された動作環境の問題 (エラー) を解消してください!';
$string['environmenterrorupgrade'] = 'このバージョンのMoodleをアップグレードする前に、発見された動作環境の問題 (エラー) を解消してください! これらの必要条件を修正せずにアップグレードした場合、データ喪失等の問題が生じる可能性があります。本当にアップグレードを続けてもよろしいですか?';
$string['environmentmustfixsetting'] = 'PHP設定を必ず変更してください。';
$string['environmentok'] = 'あなたのサーバ環境は最小限の必要条件すべてに合致します。';
$string['environmentrecommendcustomcheck'] = 'このテストに不適合の場合、潜在的な問題が存在することを意味します。';
$string['environmentrecommendinstall'] = '最適な動作のため、インストールおよび有効化してください。';
$string['environmentrecommendversion'] = 'バージョン {$a->needed} 以上を推奨します。あなたは現在 {$a->current} を使用しています。';
$string['environmentrequirecustomcheck'] = 'このテストにはパスする必要があります。';
$string['environmentrequireinstall'] = '必ずインストールおよび有効化してください。';
$string['environmentrequireversion'] = 'バージョン {$a->needed} 以上が必須です。あなたは現在 {$a->current} を使用しています。';
$string['environmentsettingok'] = '推奨設定が検出されました。';
$string['environmentshouldfixsetting'] = 'PHP設定を変更してください。';
$string['environmentxmlerror'] = '環境データ ({$a->error_code}) の読み込み中にエラーが発生しました。';
$string['errordeletingconfig'] = 'プラグイン「 {$a} 」の設定レコード削除中にエラーが発生しました。';
$string['errorsetting'] = '設定を保存できませんでした:';
$string['errorwithsettings'] = 'エラーが発生したため、いくつかの設定は変更されませんでした:';
$string['everyonewhocan'] = '「 {$a} 」ことができるユーザすべて';
$string['exceptions'] = '例外';
$string['execpathnotallowed'] = 'config.php内で実行およびローカルパスを無効に設定することができます。';
$string['experimental'] = '実験用';
$string['experimentalsettings'] = '実験用設定';
$string['extendedusernamechars'] = 'ユーザ名に拡張文字を許可する';
$string['extramemorylimit'] = '特別PHPメモリ制限';
$string['fatalmagicquotesruntime'] = '<p>深刻な設定エラーが見つかりました、サーバ管理者に報告してください。</p><p>適切に動作させるため、Moodleは管理者によるPHP設定変更を必要とします。</p><p><code>magic_quotes_runtime</code>を<code>off</code>にしてください。</p><p>この設定は<code>php.ini</code>、Apache/IIS <br />設定またはサーバの<code>.htaccess</code>ファイルの編集によりコントロールすることができます。</p>';
$string['fatalsessionautostart'] = '<p>深刻な設定エラーが見つかりました、サーバ管理者に報告してください。</p><p>適切に動作させるため、Moodleは管理者によるPHP設定変更を必要とします。</p><p><code>session.auto_start</code>を<code>off</code>にしてください。</p><p>この設定は<code>php.ini</code>、Apache/IIS <br />設定またはサーバの<code>.htaccess</code>ファイルの編集によりコントロールすることができます。</p>';
$string['filecreated'] = '新しいファイルが作成されました。';
$string['filestoredin'] = '言語ファイルを保存するフォルダ:';
$string['filestoredinhelp'] = '編集済み言語ファイルの保存';
$string['filterall'] = 'すべての文字をフィルタする';
$string['filtermatchoneperpage'] = '1ページあたり1回フィルタマッチする';
$string['filtermatchonepertext'] = 'テキストあたり1回フィルタマッチする';
$string['filters'] = 'フィルタ';
$string['filtersettings'] = 'フィルタ設定';
$string['filtersettingsgeneral'] = '一般フィルタ設定';
$string['filteruploadedfiles'] = 'アップロードファイルをフィルタする';
$string['forcelogin'] = 'ユーザにログインを強制する';
$string['forceloginforprofileimage'] = 'ユーザ写真の閲覧にユーザのログインを強制する';
$string['forceloginforprofileimage_help'] = 'この設定を有効にした場合、ユーザプロファイル写真の閲覧時にユーザはログインする必要があります。また、すべての通知メールにおいて、デフォルトのユーザ写真が使用されます。';
$string['forceloginforprofiles'] = 'プロファイル閲覧にユーザのログインを強制する';
$string['forcetimezone'] = 'タイムゾーンを強制する';
$string['formatuninstallwithcourses'] = '{$a->format} を使用しているコースが {$a->count} 件あります。これらのフォーマットは {$a->defaultformat} (このサイトのデフォルトフォーマット) に変更されます。いくつかのフォーマット特有のデータを喪失する場合があります。本当に処理を進めてもよろしいですか?';
$string['frontpage'] = 'フロントページ';
$string['frontpagebackup'] = 'フロントページバックアップ';
$string['frontpagedefaultrole'] = 'デフォルトのフロントページロール';
$string['frontpagefilters'] = 'フロントページフィルタ';
$string['frontpageloggedin'] = 'ログイン時のフロントページアイテム';
$string['frontpageoverrides'] = 'フロントページパーミッションのオーバーライド';
$string['frontpagequestions'] = 'フロントページ問題';
$string['frontpagerestore'] = 'フロントページリストア';
$string['frontpageroles'] = 'フロントページロール';
$string['frontpagesettings'] = 'フロントページ設定';
$string['fullnamedisplay'] = 'フルネームフォーマット';
$string['fullnamedisplayprivate'] = 'フルネームフォーマット - プライベート';
$string['gdrecommended'] = 'GD拡張モジュールはユーザプロファイルイメージ等のイメージ変換に使用されます。GD拡張モジュールが設定されない場合、この機能を利用できません。';
$string['gdrequired'] = '画像変換のため、MoodleではGD拡張モジュールが必要です。';
$string['generalsettings'] = '一般設定';
$string['geoipfile'] = 'GeoIP Cityデータファイル';
$string['getremoteaddrconf'] = '記録されるIPアドレスのソース';
$string['globalswarning'] = '<p><strong>セキュリティ警告</strong>: Moodleを適切に動作させるため、<br />あなたは、現在のPHP設定を変更する必要があります。<p/><p><code>register_globals=off</code>に設定してください。</p><p>この設定は、<code>php.ini</code>、Apache/IIS <br />設定、または<code>.htaccess</code>ファイルの編集により管理することができます。</p>';
$string['googlemapkey3'] = 'Google Maps API V3キー';
$string['googlemapkey3_help'] = 'あなたはIPアドレスのルックアップを視覚化するために利用するGoogle Mapsの特殊キーを入力する必要があります。あなたは<a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>より、キーを無償で取得することができます。';
$string['gotofirst'] = '最初の未翻訳ストリングに移動する';
$string['gradebook'] = '評定表';
$string['gradebookroles'] = '評定ロール';
$string['gradeexport'] = '主要な評定表エクスポート方法';
$string['gravatardefaulturl'] = 'GravatarデフォルトイメージURL';
$string['gravatardefaulturl_help'] = 'Gravatarではユーザの写真が見つからない場合に表示するデフォルトイメージが必要です。イメージの完全なURLを提供してください。この設定を空白にした場合、あなたが閲覧しているページに対して、Moodleは最も適切なデフォルトイメージの使用を試みます。Gravatarには<a href="https://en.gravatar.com/site/implement/images/#default-image">デフォルトイメージを生成するため</a>の多くのコードが含まれていることにも留意してください。';
$string['groupenrolmentkeypolicy'] = 'デフォルト登録キーポリシー';
$string['groupenrolmentkeypolicy_desc'] = 'この設定を有効にすることで、有効なパスワードポリシーに基づきMoodleがグループ登録キーをチェックするようにします。';
$string['guestroleid'] = 'ゲストのロール';
$string['guestroleid_help'] = 'このロールは自動的にゲストユーザに割り当てられます。また、パスワードなしで受講できるコースにゲスト登録プラグイン経由で入ったユーザに対しても一時的に割り当てられます。';
$string['helpadminseesall'] = '管理者はカレンダーイベントすべてを閲覧または自分自身のイベントとすることができますか?';
$string['helpcalendarcustomexport'] = 'カレンダーエクスポートに関して、カスタム日付幅エクスポートを有効にします。この設定を動作させるには、カレンダーエクスポートを有効にする必要があります。';
$string['helpexportlookahead'] = 'カスタムエクスポートオプションによるエクスポート中、イベントに関して、カレンダーは将来の日数を何日考慮しますか?';
$string['helpexportlookback'] = 'カスタムエクスポートオプションによるエクスポート中、イベントに関して、カレンダーは過去の日数を何日考慮しますか?';
$string['helpforcetimezone'] = 'あなたはユーザに独自のタイムゾーンを選択させることができます。または、すべてのユーザに対してタイムゾーンを強制します。';
$string['helpshowicalsource'] = 'このオプションを有効にした場合、iCalインポートイベントのiCal購読名およびリンクが表示されます。';
$string['helpsitemaintenance'] = 'アップグレードやその他の作業時に使用します。';
$string['helpstartofweek'] = '何曜日をカレンダーの週の始めとしますか?';
$string['helpupcominglookahead'] = '何日前のイベントをデフォルトで直近イベントとして表示しますか?';
$string['helpupcomingmaxevents'] = '直近イベントをデフォルトで最大何件ユーザに表示しますか?';
$string['helpweekenddays'] = '何曜日を「週末」として異なる色で表示しますか?';
$string['hiddenuserfields'] = 'ユーザフィールドを隠す';
$string['hidefromall'] = 'ユーザすべてに対して非表示にする';
$string['hidefromnone'] = '誰に対しても非表示にしない';
$string['hidefromstudents'] = '学生に対して非表示にする';
$string['htmleditor'] = 'HTMLエディタ';
$string['htmleditorsettings'] = 'HTMLエディタ設定';
$string['htmlsettings'] = 'HTML設定';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTPセキュリティ';
$string['hubs'] = 'ハブ';
$string['iconvrecommended'] = 'より良いパフォーマンスを得るため、ICONVライブラリのインストールを強くお勧めします。あなたのサイトが非ラテン言語をサポートしている場合、特にお勧めします。';
$string['iconvrequired'] = 'ICONV拡張モジュールのインストールが必須です。';
$string['ignore'] = '無視';
$string['includemoduleuserdata'] = 'モジュールユーザデータを含む';
$string['incompatibleblocks'] = '互換性がないブロック';
$string['installhijacked'] = '申し訳ございません、インストールはオリジナルのIPアドレスから完了する必要があります。';
$string['installsessionerror'] = 'PHPセッションを初期化できません、あなたのブラウザがクッキーを受け付けるかどうか確認してください。';
$string['intlrecommended'] = 'intl拡張モジュールの使用はロケールに関するソート等の国際化サポートを改善します。';
$string['invalidsection'] = 'セクションが正しくありません。';
$string['invaliduserchangeme'] = 'ユーザ名「changeme」は予約されています -- あなたはこのユーザ名のアカウントを作成することができません。';
$string['ipblocked'] = '現在、このサイトは利用できません。';
$string['ipblocker'] = 'IPブロッカー';
$string['ipblockersyntax'] = '1行に1エントリを入力してください。有効なエントリは単一ホストに合致する (<b>192.168.10.1</b>) のようなフルIPアドレス、指定されたIPアドレスで始まる (<b>192.168.</b>) のような部分的なアドレス、(<b>231.54.211.0/20</b>) のようなCIDR表記法、またはアドレスの最後の部分に適用される (<b>231.3.56.10-20</b>) のようなIPアドレスの範囲です。「example.com\'」のようなテキストドメインはサポートされません。空白行は無視されます。';
$string['iplookup'] = 'IPアドレスのルックアップ';
$string['iplookupgeoplugin'] = '現在、<a href="http://www.geoplugin.com">geoPlugin</a> は地理情報を取得するために使用されています。さらに正確な結果を取得するには、ローカルへのMaxMind GeoLiteデータベースのインストールをお勧めします。';
$string['iplookupinfo'] = 'IPアドレスのロケーションをルックアップするため、MoodleはフリーオンラインNetGeo (The Internet Geographic Database) サーバをデフォルトで利用します。残念ですが、このデータベースは今後メンテナンスされることはなく、「大幅に不正確」なデータを返します。MaxMindからフリーGeoLite Cityデータベースのローカルコピーをインストールすることをお勧めします。<br />IPアドレスのロケーションはシンプルマップまたはGoogle Mapsを利用して表示されます。インタラクティブマップを有効にするには、Googleアカウントを取得して、フリーGoogle Maps APIキーを適用する必要があることに留意してください。';
$string['iplookupmaxmindnote'] = 'この製品は<a href="http://www.maxmind.com/">http://www.maxmind.com/</a>で利用できるMaxMindによって作成されたGeoLiteデータを含みます。';
$string['keeptagnamecase'] = 'タグ名の大文字小文字を保持する';
$string['lang'] = 'デフォルト言語';
$string['langcache'] = '言語メニューをキャッシュする';
$string['langcache_desc'] = '言語メニューをキャッシュします。この設定を有効にした場合、利用可能な翻訳一覧がキャッシュされます。あなたがビルトインの言語パック管理ツール経由で言語パックをインストールまたは削除した場合、自動的にキャッシュが更新されます。あなたが手動で新しい言語パックをインストールした場合、すべてのキャッシュをクリアする機能を使って、キャッシュリストを更新する必要があります。';
$string['langlist'] = '言語メニューの言語';
$string['langmenu'] = '言語メニューを表示する';
$string['langpackwillbeupdated'] = '注意: アップグレード中、Moodleは現在の言語パックのアップグレードを試みます。';
$string['langstringcache'] = 'すべての言語ストリングをキャッシュする';
$string['languagesettings'] = '言語設定';
$string['latexpreamble'] = 'LaTeXプリアンブル';
$string['latexsettings'] = 'LaTeXレンダラ設定';
$string['latinexcelexport'] = 'Excelエンコーディング';
$string['legacyfilesaddallowed'] = 'レガシーコースファイルの追加を許可する';
$string['legacyfilesaddallowed_help'] = 'コースにレガシーコースファイルがある場合、そこに新しいファイルおよびフォルダの追加を許可します。';
$string['legacyfilesinnewcourses'] = '新しいコースのレガシーコースファイル';
$string['legacyfilesinnewcourses_help'] = 'デフォルトではレガシーコースファイルエリアはアップグレードされたコースでのみ使用することができます。活動のバックアップおよびリストアのようないくつかの機能に関して、この設定の互換性がないことに留意してください。';
$string['licensesettings'] = 'ライセンス設定';
$string['linkadmincategories'] = 'カテゴリ管理にリンクする';
$string['linkadmincategories_help'] = 'この設定を有効にした場合、カテゴリ管理設定がリンクとしてナビゲーションに表示されます。表示されたリンクにより、カテゴリ管理ページにアクセスすることができます。';
$string['loading'] = '読み込み';
$string['localetext'] = 'サイト全体のロケール';
$string['localstringcustomization'] = 'ローカルストリングのカスタマイズ';
$string['location'] = 'ロケーション';
$string['locationsettings'] = 'ロケーション設定';
$string['locked'] = 'ロック';
$string['lockoutduration'] = 'アカウントロックアウト持続時間';
$string['lockoutduration_desc'] = 'この時間の後、ロックアウトされたアカウントが自動的にロック解除されます。';
$string['lockoutemailbody'] = 'サーバ「 {$a->sitename} 」内のあなたのアカウント (ユーザ名: {$a->username}  )  は無効な複数回のログインによりロックアウトされました。

すぐにアカウントをロック解除するには、次のアドレスにアクセスしてください。

{$a->link}

ほとんどのメールプログラムでは、あなたがクリックできる青いリンクとして表示されているはずです。クリックできない場合、あなたのブラウザウインドウのアドレス欄にアドレスをコピー＆ペーストしてください。

分からない場合、サイト管理者 ( {$a->admin}) にご連絡ください。';
$string['lockoutemailsubject'] = '{$a} のあなたのアカウントはロックアウトされました。';
$string['lockouterrorunlock'] = '無効なアカウントロック解除情報が提供されました。';
$string['lockoutthreshold'] = 'アカウントロックアウト閾値';
$string['lockoutthreshold_desc'] = 'アカウントがロックアウトされるまでのログイン失敗回数を選択してください。この機能はサービス妨害攻撃により悪用される可能性があります。';
$string['lockoutwindow'] = 'アカウントロックアウト監視時間';
$string['lockoutwindow_desc'] = 'ロックアウト閾値の監視時間です。失敗ログインが発生しない場合、この時間の後、閾値カウンターはリセットされます。';
$string['log'] = 'ログ';
$string['logguests'] = 'ゲストアクセスを記録する';
$string['logguests_help'] = 'この設定ではゲストアクセスおよび未ログインユーザの行動を記録します。パフォーマンスの理由から、高負荷のサイトではこの設定を無効にした方が良いでしょう。実運用サイトではこの設定を有効のままにすることをお勧めします。';
$string['loginhttps'] = 'ログインにHTTPSを使用する';
$string['loginpageautofocus'] = 'ログインページフォームのオートフォーカス';
$string['loginpageautofocus_help'] = 'この設定を有効にした場合、ログインページのユーザビリティを改善します。しかし、フィールドにオートフォーカスさせる場合、アクセシビリティ問題に関して考慮した方が良いでしょう。';
$string['loginpasswordautocomplete'] = 'ログインフォームのパスワード自動補完を防ぐ';
$string['loginpasswordautocomplete_help'] = 'このオプションを有効にした場合、ユーザはブラウザにアカウントのパスワードを保存できないようになります。';
$string['loglifetime'] = 'ログの保存期間';
$string['longtimewarning'] = '<b>この処理には長時間がかかりますので注意してください。</b>';
$string['maintenancemode'] = 'メンテナンスモード';
$string['maintenancemodeisscheduled'] = 'サイトは {$a}  分でメンテナンスモードにスイッチします。';
$string['maintfileopenerror'] = 'メンテナンスファイルのオープン中にエラーが発生しました！';
$string['maintinprogress'] = 'メンテナンス処理中です ...';
$string['manageformats'] = 'コースフォーマット管理';
$string['manageformatsgotosettings'] = 'デフォルトフォーマットは {$a} で変更することができます。';
$string['managelang'] = '管理';
$string['managelicenses'] = 'ライセンス管理';
$string['manageqbehaviours'] = '問題動作管理';
$string['manageqtypes'] = '問題タイプ管理';
$string['maturity100'] = 'ベータ';
$string['maturity150'] = 'リリース候補版';
$string['maturity200'] = '安定版';
$string['maturity50'] = 'アルファ版';
$string['maturityallowunstable'] = 'ヒント: あなたは --allow-unstable オプションを付けて、このスクリプトを実行することができます。';
$string['maturitycoreinfo'] = '現在、あなたのサイトでは不安定な「 {$a} 」開発コードが動作しています。';
$string['maturitycorewarning'] = 'あなたは不安定な「 {$a} 」コードを含んだMoodleのバージョンを使ってインストールまたはアップグレードしようとしています。このバージョンはほとんどの実運用サイトに適していません。これがあなたの希望することではない場合、MoodleのSTABLEブランチコードを使って更新するようにしてください。詳細はMoodle Docsをご覧ください。';
$string['maxbytes'] = '最大アップロードファイルサイズ';
$string['maxconsecutiveidentchars'] = '連続した同一文字';
$string['maxeditingtime'] = '投稿を編集できる最大時間';
$string['maxusersperpage'] = '1ページあたりのユーザ数';
$string['mbstringrecommended'] = 'サイトパフォーマンスを改善するため、mbstringライブラリのインストールおよび稼動を強くお勧めします。あなたのサイトがラテン文字以外をサポートしている場合、特にお勧めします。';
$string['mediapluginavi'] = '.aviフィルタを有効にする';
$string['mediapluginflv'] = '.flvフィルタを有効にする';
$string['mediapluginimg'] = 'リンクイメージの自動埋め込みを有効にする';
$string['mediapluginmov'] = '.movフィルタを有効にする';
$string['mediapluginmp3'] = '.mp3フィルタを有効にする';
$string['mediapluginmpg'] = '.mpgフィルタを有効にする';
$string['mediapluginogg'] = '.oggフィルタを有効にする';
$string['mediapluginogv'] = 'ogvフィルタを有効にする';
$string['mediapluginram'] = '.ramフィルタを有効にする';
$string['mediapluginrm'] = '.rmフィルタを有効にする';
$string['mediapluginrpm'] = '.rpmフィルタを有効にする';
$string['mediapluginswf'] = '.swfフィルタを有効にする';
$string['mediapluginswfnote'] = 'デフォルトのセキュリティ対策として、通常のユーザがswfフラッシュファイルを埋め込むことは許可されていません。';
$string['mediapluginwmv'] = '.wmvフィルタを有効にする';
$string['mediapluginyoutube'] = 'YouTubeリンクフィルタを有効にする';
$string['messaging'] = 'メッセージングシステムを有効にする';
$string['messagingallowemailoverride'] = '通知メールのオーバーライド';
$string['messagingdeletereadnotificationsdelay'] = '未読通知を削除する';
$string['messaginghidereadnotifications'] = '未読通知を隠す';
$string['minpassworddigits'] = '数字';
$string['minpasswordlength'] = 'パスワード長';
$string['minpasswordlower'] = '小文字';
$string['minpasswordnonalphanum'] = '非英数字';
$string['minpasswordupper'] = '大文字';
$string['misc'] = 'その他';
$string['mnetrestore_extusers'] = '<strong>注意:</strong> このバックアップファイルは処理中にリストアされるMoodleネットワークユーザアカウントを含んでいます。';
$string['mnetrestore_extusers_admin'] = '<strong>注意:</strong> このバックアップファイルは他のMoodleで作成され、Moodleネットワークユーザアカウントを含んでるようです。リストア処理ではすべての作成済みユーザに対して、Moodleネットワークホストへの合致を試みます。合致しないユーザは (mnet認証の代わりに) 自動的に内部認証へ切り替えられます。あなたはこの処理に関する情報をリストアログで閲覧することができます。';
$string['mnetrestore_extusers_mismatch'] = '<strong>注意:</strong> このバックアップファイルは他のMoodleで作成され、リストアできないMoodleネットワークユーザアカウントを含んでいます。この処理はサポートされていません。バックアップファイルがこのMoodleでバックアップされたこと、または必要なすべてのMoodleネットワークホストが設定されていることをあなたが保証できる場合のみ、リストアを試みてください。';
$string['mnetrestore_extusers_noadmin'] = '<strong>注意:</strong> このバックアップファイルは他のMoodleで作成され、Moodleネットワークユーザアカウントを含んでいます。あなたはこのタイプのリストア処理の実行を許可されていません。サイト管理者に連絡するか、代わりにこのコースをユーザ情報なし (モジュール、ファイル ...) でリストアしてください。';
$string['mnetrestore_extusers_switchuserauth'] = 'リモートMoodleネットワークユーザ {$a->username} ({$a->mnethosturl}) がローカル {$a->auth} 認証済みユーザに切り替えられました。';
$string['mobile'] = 'モバイル';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = '活動チューザデフォルト';
$string['modeditdefaults'] = '活動設定のデフォルト値';
$string['modeditingmenu'] = '活動編集メニュー';
$string['modeditingmenu_desc'] = 'この設定を有効にした場合、編集モードのコース表示時に多くの活動編集アイコンをドロップダウンメニュー内に表示することができます。必要になるまでアイコンを隠すことで、コース編集時の画面上のコンテンツを減らします。';
$string['modsettings'] = '活動管理';
$string['modulesecurity'] = 'モジュールセキュリティ';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = '古いmultilangシンタックスを強制する: class="multilang" なしの &lt;span&gt; および &lt;lang&gt;';
$string['mustenablestats'] = 'このサイトでは統計が有効にされていません。';
$string['mycoursesperpage'] = 'コース数';
$string['mydashboard'] = 'システムデフォルダッシュボード';
$string['mymoodle'] = 'マイホーム';
$string['mymoodleredirect'] = 'ユーザにマイMoodleの使用を強制する';
$string['mypage'] = 'デフォルトマイホームページ';
$string['mypagelocked'] = 'デフォルトページをロックする';
$string['myprofile'] = 'デフォルトプロファイルページ';
$string['mysql416bypassed'] = 'あなたのサイトがiso-8859-1 (ラテン) 言語のみ使用している場合、現在インストールされている MySQL 4.1.12 (またはそれ以上) を使用することができます。';
$string['mysql416required'] = '将来すべてのデータをUTF-8に変換できるため、Moodle 1.6では、MySQL 4.1.16が要求される最低限のバージョンです。';
$string['navadduserpostslinks'] = 'ユーザ投稿閲覧のためのリンクを追加する';
$string['navadduserpostslinks_help'] = 'この設定を有効にした場合、それぞれのユーザに対して、2つのリンクがナビゲーション内に追加されます。1つはユーザが開始したディスカッションを閲覧するため、もう1つはサイト全体または特定のコース内フォーラムでユーザが投稿した内容を閲覧するためです。';
$string['navcourselimit'] = 'コース制限';
$string['navigationupgrade'] = 'このアップグレードでは次のブロックに替えて、新しい2つのナビゲーションブロックが導入されます: 管理、コース、活動および参加者。これらのブロックに特別なパーミッションを設定している場合、すべてがあなたの希望どおりに動作するか確認してください。';
$string['navshowallcourses'] = 'すべてのコースを表示する';
$string['navshowcategories'] = 'コースカテゴリを表示する';
$string['navshowfrontpagemods'] = 'ナビゲーションにフロントページ活動を表示する';
$string['navshowfrontpagemods_help'] = 'この設定を有効にした場合、サイトページ下のナビゲーションにフロントページ活動が表示されます。';
$string['navshowfullcoursenames'] = 'コースフルネームを表示する';
$string['navshowfullcoursenames_help'] = 'この設定を有効にした場合、ナビゲーションに省略名ではなくコースフルネームが使用されます。';
$string['navshowmycoursecategories'] = 'マイコースカテゴリを表示する';
$string['navshowmycoursecategories_help'] = 'この設定を有効にした場合、カテゴリ内にユーザのマイコースが表示されます。';
$string['navsortmycoursessort'] = 'マイコースを並べ替える';
$string['navsortmycoursessort_help'] = 'ここではコースがマイコース内に並べ替え順 (例 「管理 > サイト管理 > コース >  コースおよびカテゴリを管理する」で設定された順番) に従って表示されるか、アルファベット順で表示されるか決定します。';
$string['neverdeleteruns'] = '実行結果を削除しない';
$string['nobookmarksforuser'] = 'あなたのブックマークはありません。';
$string['nodatabase'] = 'データベースなし';
$string['nohttpsformobilewarning'] = '有効な証明書のHTTPSを有効にすることをお勧めします。Moodle appは常に最初にセキュアコネクションの使用を試みます。';
$string['nomissingstrings'] = '未翻訳ストリングはありません。';
$string['nonewsettings'] = 'このアップグレードで新しい設定は追加されませんでした。';
$string['nonexistentbookmark'] = 'あなたがリクエストしたブックマークは登録されていません。';
$string['noresults'] = '該当するデータは見つかりませんでした。';
$string['noroles'] = 'ロールなし';
$string['notifications'] = '通知';
$string['notifyloginfailures'] = 'ログイン失敗をメール通知する';
$string['notifyloginthreshold'] = 'メール通知の閾値';
$string['notloggedinroleid'] = 'ビジターのロール';
$string['numberofmissingstrings'] = '未翻訳ストリング数: {$a}';
$string['numberofstrings'] = '合計ストリング数: {$a->strings}<br />未翻訳数: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'PHP OPcacheキャッシングはパフォーマンスを改善して、必要メモリを減らします。OPcache拡張モジュールは推奨および完全にサポートされます。';
$string['opensslrecommended'] = 'Moodleネットワーキング機能を有効にするため、OpenSSLライブラリのインストールを強くお勧めします。';
$string['opentogoogle'] = 'Googleに公開する';
$string['optionalmaintenancemessage'] = '任意のメンテナンスメッセージ';
$string['order1'] = '1番目';
$string['order2'] = '2番目';
$string['order3'] = '3番目';
$string['order4'] = '4番目';
$string['passwordpolicy'] = 'パスワードポリシー';
$string['passwordresettime'] = 'パスワードリセットリクエスト確認の最大時間';
$string['pathconvert'] = '<i>convert</i>バイナリのパス';
$string['pathdvips'] = '<i>dvips</i>バイナリのパス';
$string['pathlatex'] = '<i>latex</i>バイナリのパス';
$string['pathtoclam'] = 'ClamAVパス';
$string['pathtodot'] = 'dotのパス';
$string['pathtodot_help'] = 'dotのパスを指定してください。恐らく、/usr/bin/dotのようになります。 DOTファイルからグラフィックを生成するには、あなたはdot実行ファイルをインストールした後、ここでパスを指定する必要があります。現在のところ、これはMoodleに組み込まれているプロファイリング機能 (開発 > プロファイリング) でのみ使用できることに留意してください。';
$string['pathtodu'] = 'duのパス';
$string['pathtopgdump'] = 'pg_dumpのパス';
$string['pathtopgdumpdesc'] = 'あなたのシステムに1つ以上のpg_dumpが存在する場合 (例 1つ以上のバージョンのpostgresqlがインストールされている場合) のみ入力する必要があります。';
$string['pathtopgdumpinvalid'] = 'pg_dumpのパスが正しくありません - パスが間違っているか、実行可能ではありません。';
$string['pathtopsql'] = 'psqlのパス';
$string['pathtopsqldesc'] = 'あなたのシステムに1つ以上のpsqlが存在する場合 (例 1つ以上のバージョンのpostgresqlがインストールされている場合) のみ入力する必要があります。';
$string['pathtopsqlinvalid'] = 'psqlのパスが正しくありません - パスが間違っているか、実行可能ではありません。';
$string['pcreunicodewarning'] = 'ユニコード文字への互換性のため、PCRE PHP拡張モジュールの使用を強くお勧めします。';
$string['perfdebug'] = 'パフォーマンス情報';
$string['performance'] = 'パフォーマンス';
$string['pgcluster'] = 'PostgreSQLクラスタ';
$string['pgclusterdescription'] = 'コマンドライン処理のためのPostgreSQLバージョン/クラスタパラメータです。あなたのシステムに1つのPostgreSQLのみある場合、またはこの設定が分からない場合、空白にしてください。';
$string['php50restricted'] = 'PHP 5.0.x には数多くの既知の問題があります。5.1.x にアップグレードするか、4.3.x または 4.4.x にダウングレードしてください。';
$string['php533warning'] = 'PHP 5.3.3およびそれ以上のバージョンを推奨します。';
$string['phpfloatproblem'] = 'PHP浮動数の処理に予期しない問題が発見されました - {$a}';
$string['pleaserefreshregistration'] = 'あなたのサイトがmoodle.orgに登録されました。最終更新日 {$a} 以降、あなたのサイトに大幅な変更があった場合、登録内容の更新をお考えください。';
$string['pleaseregister'] = 'このボタンを消すには、あなたのサイトを登録してください。';
$string['plugin'] = 'プラグイン';
$string['plugins'] = 'プラグイン';
$string['pluginscheck'] = 'プラグイン依存関係チェック';
$string['pluginscheckfailed'] = '{$a->pluginslist} の依存関係チェックに失敗しました。';
$string['pluginschecktodo'] = 'このMoodleバージョンをインストールする前に、あなたはすべてのプラグイン必要条件を解決する必要があります!';
$string['pluginsoverview'] = 'プラグイン概要';
$string['pluginsoverviewsee'] = '詳細は<a href="{$a->url}">プラグイン概要</a>ページをご覧ください。';
$string['profilecategory'] = 'カテゴリ';
$string['profilecategoryname'] = 'カテゴリ名 (ユニークにしてください)';
$string['profilecategorynamenotunique'] = 'このカテゴリ名はすでに使用されています。';
$string['profilecommonsettings'] = '共通設定';
$string['profileconfirmcategorydeletion'] = 'このカテゴリには上記 (トップカテゴリの場合は下記) カテゴリに移動される {$a} 個のフィールドが含まれています。<br />本当にこのカテゴリを削除してもよろしいですか?';
$string['profileconfirmfielddeletion'] = 'このフィールドには削除される {$a} 名のユーザレコードが含まれています。<br />本当にこのフィールドを削除してもよろしいですか?';
$string['profilecreatecategory'] = '新しいプロファイルカテゴリを作成する';
$string['profilecreatefield'] = '新しいプロファイルフィールドを作成する:';
$string['profilecreatenewcategory'] = '新しいカテゴリの作成';
$string['profilecreatenewfield'] = '新しいプロファイルフィールド「 {$a} 」の作成';
$string['profiledefaultcategory'] = '他のフィールド';
$string['profiledefaultchecked'] = 'デフォルトでチェックする';
$string['profiledefaultdata'] = 'デフォルト値';
$string['profiledeletecategory'] = 'カテゴリの削除';
$string['profiledeletefield'] = 'フィールド「 {$a} 」の削除';
$string['profiledescription'] = 'フィールド説明';
$string['profiledscript'] = 'このスクリプトはプロファイルされました。';
$string['profiledscriptview'] = 'このスクリプトのプロファイリング情報を表示する';
$string['profileeditcategory'] = 'カテゴリの編集: {$a}';
$string['profileeditfield'] = 'プロファイルフィールドの編集: {$a}';
$string['profilefield'] = 'プロファイルフィールド';
$string['profilefieldcolumns'] = '列';
$string['profilefieldispassword'] = 'これはパスワードフィールドですか?';
$string['profilefieldlink'] = 'リンク';
$string['profilefieldlink_help'] = 'テキストをリンクに変換するには、$$を含んだURLを入力してください。$$はテキストと置換されます。例えば、Twitter IDをリンクに変換したい場合、次のように入力してください: http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'リンクターゲット';
$string['profilefieldmaxlength'] = '最大長';
$string['profilefieldrows'] = '行';
$string['profilefields'] = 'ユーザプロファイルフィールド';
$string['profilefieldsize'] = '表示サイズ';
$string['profileforceunique'] = 'データがユニークである必要がありますか?';
$string['profileinvaliddata'] = '値が有効ではありません。';
$string['profilelocked'] = 'このフィールドをロックしますか?';
$string['profilemenudefaultnotinoptions'] = 'デフォルト値がオプションの1つではありません。';
$string['profilemenunooptions'] = 'メニューオプションを入力してください。';
$string['profilemenuoptions'] = 'メニューオプション (1行あたり１つ)';
$string['profilemenutoofewoptions'] = 'あなたは少なくとも2つのオプションを入力する必要があります。';
$string['profilename'] = '名称';
$string['profilenofieldsdefined'] = '定義されているフィールドはありません。';
$string['profilerequired'] = 'このフィールドは必須入力ですか?';
$string['profileroles'] = 'プロファイル可視ロール';
$string['profilesforenrolledusersonly'] = 'プロファイルを登録ユーザのみに表示する';
$string['profileshortname'] = '省略名 (ユニークにしてください)';
$string['profileshortnamenotunique'] = 'この省略名はすでに使用されています。';
$string['profilesignup'] = 'サインアップページに表示しますか?';
$string['profilespecificsettings'] = '詳細設定';
$string['profilevisible'] = 'このフィールドを誰に表示しますか?';
$string['profilevisibleall'] = 'すべての人に表示する';
$string['profilevisible_help'] = '* 非表示 - 管理者のみ閲覧することのできる個人情報です。
* ユーザに表示する - ユーザおよび管理者のみ閲覧することのできる個人情報です。
* すべての人に表示する';
$string['profilevisiblenone'] = '非表示';
$string['profilevisibleprivate'] = 'ユーザに表示する';
$string['profiling'] = 'プロファイリング';
$string['profilingallowall'] = '継続プロファイリング';
$string['profilingallowall_help'] = 'この設定を有効にした場合、あなたはいつでもどこでも (PGC) Moodleセッションにおける実行スクリプトすべてをプロファイリングするため、PROFILEALLパラメータを使用することができます。同様にスクリプトを停止するため、あなたはPROFILEALLSTOPパラメータを使用することもできます。';
$string['profilingallowme'] = '選択的プロファイリング';
$string['profilingallowme_help'] = 'この設定を有効にした場合、あなたは選択的にどこでも (PGC) Moodleセッションにおける実行スクリプトをプロファイリングするため、PROFILEMEパラメータを使用することができます。同様にプロファイリングの実行を回避するため、あなたはDONTPROFILEMEパラメータを使用することもできます。';
$string['profilingautofrec'] = '自動プロファイリング';
$string['profilingautofrec_help'] = 'このオプションを設定することで、いくつかのリクエスト (指定された頻度に基づいて - 1/ N) が選択されて、継続解析結果を保存するために自動的にプロファイルされます。このプロファイリングでは「組み込み/除外」設定を参照することに留意してください。ゼロを設定した場合、自動プロファイリングは無効にされます。';
$string['profilingenabled'] = 'プロファイリングを有効にする';
$string['profilingenabled_help'] = 'この設定を有効にした場合、このサイト内でプロファイリングを使用できるようになります。あなたは次のオプションでプロファイリングの動作を定義することができます。';
$string['profilingexcluded'] = 'プロファイリングを除外する';
$string['profilingexcluded_help'] = '「これらをプロファイルする」設定で定義されたプロファイリングからプロファイリングを除外するための (wwwrootを除いたカンマ区切りの実行可能な絶対パスの) URL一覧です。';
$string['profilingimportprefix'] = 'プロファイリングインポート接頭辞';
$string['profilingimportprefix_desc'] = '簡単に探すことができるよう、インポート済みプロファイリング実行すべてに対して、ここで指定した値の接頭辞が付加されます。';
$string['profilingincluded'] = 'これらをプロファイルする';
$string['profilingincluded_help'] = '自動的にプロファイルされる (wwwrootを除いたカンマ区切りの実行可能な絶対パスの) URL一覧です。例: /index.php, /course/view.php また、どのような場所であってもワイルドカード (*) を使用することができます。例:  /mod/forum/*, /mod/*/view.php';
$string['profilinglifetime'] = 'プロファイリング実行を保持する';
$string['profilinglifetime_help'] = 'あなたが古いプロファイリング実行を保持したい期間を指定してください。古いプロファイリングは定期的に削除されます。ここでは「参照実行」としてマークされたプロファイリングを除外することに留意してください。';
$string['protectusernames'] = 'ユーザ名を保護する';
$string['proxybypass'] = 'プロクシバイパスホスト';
$string['proxyhost'] = 'プロクシホスト';
$string['proxypassword'] = 'プロクシパスワード';
$string['proxyport'] = 'プロクシポート';
$string['proxytype'] = 'プロクシタイプ';
$string['proxyuser'] = 'プロクシユーザ名';
$string['purgecaches'] = 'すべてのキャッシュを削除する';
$string['purgecachesconfirm'] = 'Moodleではテーマ、javascript、言語ストリング、フィルタテキスト、RSSフィードおよび多くの計算データをキャッシュすることができます。キャッシュを削除することにより、あなたが現在のコードにより作成された最新データを閲覧できるよう、サーバからキャッシュデータが削除され、ブラウザによるデータ再取得が強制されます。キャッシュを削除することに危険性はありませんが、サーバおよびクライアントが新しい情報を計算してキャッシュするまで、あなたのサイトが若干遅くなります。';
$string['purgecachesfinished'] = 'すべてのキャッシュが削除されました。';
$string['qtyperqpwillberemoved'] = 'アップグレード中、RQP問題タイプは削除されます。あなたはこの問題タイプを使用していませんので、トラブルが発生することはありません。';
$string['qtyperqpwillberemovedanyway'] = 'アップグレード中、RQP問題タイプは削除されます。あなたのデータベース内にRQP問題タイプが登録されています。アップグレードを続ける前に、http://moodle.org/mod/data/view.php?d=13&amp;rid=797 から対応するプログラムをインストールしない場合、これらの問題は動作しなくなります。';
$string['quarantinedir'] = '隔離ディレクトリ';
$string['question'] = '問題';
$string['questionbehaviours'] = '問題動作';
$string['questioncwqpfscheck'] = '1つまたはそれ以上の小テストの「ランダム」問題が共有および非共有カテゴリから混在して選択されるように設定されています。詳細レポートは<a href="{$a->reporturl}">こちらを</a>ご覧ください。また、<a href="{$a->docsurl}">こちら</a>でMoodle Docsページをご覧ください。';
$string['questioncwqpfsok'] = '素晴らしい。あなたの小テストでは共有および非共有カテゴリから混在して選択されるように設定されている「ランダム」問題はありません。';
$string['questiontype'] = '問題タイプ';
$string['questiontypes'] = '問題タイプ';
$string['quizattemptsupgradedmessage'] = 'Moodle 2.1において、問題の大幅なアップグレードがありました。また、データベースアップグレードの一部を後で実行するよう、遅らせることができました。Moodle 2.7へアップグレードする前に、このアップグレードを完了する必要があります。';
$string['recaptchaprivatekey'] = 'reCAPTCHAプライベートキー';
$string['recaptchapublickey'] = 'reCAPTCHAパブリックキー';
$string['register'] = 'あなたのサイトを登録する';
$string['registermoodleorg'] = 'あなたのサイトを {$a} に登録する場合:';
$string['registermoodleorgli1'] = 'あなたはセキュリティ警告およびMoodleの新しいリリースを含む重要な情報が通知される発信数の少ないメーリングリストに追加されます。';
$string['registermoodleorgli2'] = 'あなたのサイト統計情報が世界規模のMoodleコミュニティの {$a} に追加されます。';
$string['registermoodleorgli3'] = 'あなたのサイトがMoodle.net ({$a}) にも登録されます。コース公開ケイパビリティの割り当てられたユーザ (デフォルトではマネージャのみ) はMoodle.netにコースを公開することができます。';
$string['registerwithmoodleorg'] = 'Moodle.orgに登録する';
$string['registration'] = '登録';
$string['registration_help'] = 'セキュリティ警告通知を受信するため、<a href="http://moodle.org/stats">Moodle利用統計</a>に貢献するため、また<a href="http://moodle.net/">Moodle.net</a>上のコースを共有できるようにするため、Moodle.orgへの登録をお勧めします。';
$string['registrationwarning'] = 'あなたのサイトはまだ登録されていません。';
$string['releasenoteslink'] = 'このバージョンのMoodleに関する詳細情報はオンライン<a target="_blank" href="{$a}">リリースノート</a>をご覧ください。';
$string['rememberusername'] = 'ユーザ名を記憶する';
$string['rememberusername_desc'] = 'ユーザログイン中、あなたがユーザ名を永続クッキーに保存したい場合、この設定を有効にしてください。同意なしに使用した場合、永続的クッキーはプライバシー問題であると考えられる可能性があります。';
$string['reportsmanage'] = 'レポートの管理';
$string['requestcategoryselection'] = 'カテゴリ選択を有効にする';
$string['requiredentrieschanged'] = '<strong>重要 - お読みください<br />(この警告メッセージはこのアップグレード中にのみ表示されます)。</strong><br />バグ修正のため、「必須エントリ数」および「閲覧前に必要な入力エントリ数」を使用しているデータベース活動の設定は変更されます。この変更に関する詳細は<a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">データベースモジュールフォーラム</a>でご覧いただけます。また、これらの設定に関する詳細は<a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>でご覧いただけます。<br /><br />この変更はあなたのシステムの以下のデータベースに影響します: (このリストを保存して、アップグレード後、教師が意図するように動作するか確認してください)<br /><strong>{$a->text}</strong><br />';
$string['requiremodintro'] = '活動説明を要求する';
$string['requires'] = '必要条件';
$string['restorernewroleid'] = 'リストア担当者のコース内でのロール';
$string['restorernewroleid_help'] = '新しくリストアされるコースを管理するためのパーミッションがすでに割り当てられていない場合、ユーザに対して自動的にこのロールが割り当てられます。同時に必要であればコースへ受講登録されます。あなたがリストア済みコースすべてを管理できるようにしたくない場合、「なし」を選択してください。';
$string['reverseproxy'] = 'リバースプロクシ';
$string['riskconfig'] = 'ユーザはサイト設定および動作を変更することができます。';
$string['riskconfigshort'] = '設定リスク';
$string['riskdataloss'] = 'ユーザは大量のコンテンツまたは情報を破壊することができます。';
$string['riskdatalossshort'] = 'データ喪失リスク';
$string['riskmanagetrust'] = 'ユーザは他のユーザの信頼度設定を変更することができます。';
$string['riskmanagetrustshort'] = '信頼度管理';
$string['riskpersonal'] = 'ユーザは他のユーザの個人情報にアクセスすることができます。';
$string['riskpersonalshort'] = 'プライバシーリスク';
$string['riskspam'] = 'ユーザはサイトユーザまたはそれ以外にスパムを送信することができます。';
$string['riskspamshort'] = 'スパムリスク';
$string['riskxss'] = 'ユーザはクロスサイトスクリプティング (XSS) を許すファイルおよびテキストを追加することができます。';
$string['riskxssshort'] = 'XSSリスク';
$string['roleswithexceptions'] = '{$a->roles} および {$a->exceptions}';
$string['rssglobaldisabled'] = 'サーバレベルで無効済み';
$string['runclamavonupload'] = 'アップロードファイルにClamAVを使用する';
$string['save'] = '保存';
$string['savechanges'] = '変更を保存する';
$string['search'] = '検索';
$string['searchinsettings'] = '設定検索';
$string['searchresults'] = '検索結果';
$string['sectionerror'] = 'セクションエラー!';
$string['secureforms'] = '追加的なフォームセキュリティを使用する';
$string['security'] = 'セキュリティ';
$string['selectdevice'] = 'デバイスを選択する';
$string['selecttheme'] = '{$a} デバイスのテーマを選択する';
$string['server'] = 'サーバ';
$string['serverchecks'] = 'サーバチェック';
$string['serverlimit'] = 'サーバリミット';
$string['sessionautostartwarning'] = '<p>深刻な設定エラーが検出されました。サーバ管理者に通知してください。</p><p>Moodleを適切に動作させるためには、PHPの設定変更を必要とします。</p><p><code>session.auto_start</code>を<code>off</code>にしてください。</p><p>この設定は<code>php.ini</code>、 Apache/IIS設定またはサーバの<code>.htaccess</code>ファイルを使用して管理することができます。</p>';
$string['sessioncookie'] = 'クッキー接頭辞';
$string['sessioncookiedomain'] = 'クッキードメイン';
$string['sessioncookiepath'] = 'クッキーパス';
$string['sessionhandling'] = 'セッションハンドリング';
$string['sessiontimeout'] = 'タイムアウト';
$string['settingfileuploads'] = 'ファイルアップロードは通常の操作に必要です。PHP設定で有効にしてください。';
$string['settingmemorylimit'] = 'メモリ不足が検出されました。PHP設定でメモリ制限を現在より高く設定してください。';
$string['settingsafemode'] = 'Moodleではセーフモードに完全な互換性はありません。サーバ管理者にセーフモードの無効化を依頼してください。セーフモードでのMoodleの動作はサポートされていません。Moodleをセーフモードで動作させる場合、様々な問題が発生する可能性があります。';
$string['showcommentscount'] = 'コメント総数を表示する';
$string['showdetails'] = '詳細を表示する';
$string['showuseridentity'] = '表示するユーザ固有情報';
$string['showuseridentity_desc'] = 'ユーザの選択および検索、またユーザ一覧を表示する場合、これらのフィールドはユーザのフルネームの横に表示されます。フィールドは「moodle/site:viewuseridentity」ケイパビリティを持ったユーザにのみ、デフォルトでは教師およびマネージャにのみ表示されます (あなたの組織で1つまたは2つのフィールドを必須入力にした場合、このオプションは最も意味をなします)。';
$string['simplexmlrequired'] = '現在、MoodleにはSimpleXML PHP拡張モジュールが必要です。';
$string['sitemaintenance'] = 'このサイトはメンテナンス中です。現在ご利用いただけません。';
$string['sitemaintenancemode'] = 'メンテナンスモード';
$string['sitemaintenanceoff'] = 'メンテナンスモードが解除されました。サイトは正常に動作しています。';
$string['sitemaintenanceon'] = 'あなたのサイトは現在メンテナンスモードで運用されています (管理者のみログインまたはサイトを利用することができます)。';
$string['sitemaintenanceoncli'] = '現在、あなたのサイトはCLIメンテナンスモードで運用されています。ウェブアクセスは許可されません。';
$string['sitemaintenancewarning'] = 'あなたのサイトは現在メンテナンスモードで運用されています (管理者のみログインできます)。通常運用に戻すには、<a href="maintenance.php">メンテナンスモードを解除してください</a>。';
$string['sitemaintenancewarning2'] = 'あなたのサイトは現在メンテナンスモードで運用されています (管理者のみログインできます)。通常運用に戻すには、<a href="{$a}">メンテナンスモードを解除してください</a>。';
$string['sitepolicies'] = 'サイトポリシー';
$string['sitepolicy'] = 'サイトポリシーURL';
$string['sitepolicyguest'] = 'ゲストのサイトポリシーURL';
$string['sitepolicyguest_help'] = 'すべてのゲストが閲覧および同意するサイトポリシーがある場合、ここにそのURLを指定してください。そうでない場合、このフィールドを空白のままにしてください。この設定にはどのようなパブリックURLでも入力することができます。注意: 未ログインユーザのアクセスは「ユーザのログインを強制する」設定により拒否されます。';
$string['sitepolicy_help'] = 'すべてのゲストが閲覧および同意するサイトポリシーがある場合、ここにそのURLを指定してください。そうでない場合、このフィールドを空白のままにしてください。この設定にはどのようなパブリックURLも入力することができます。';
$string['sitesectionhelp'] = '選択した場合、トピックセクションがサイトフロントページに表示されます。';
$string['slasharguments'] = 'スラッシュ引数を使用する';
$string['smartpix'] = 'スマートpixサーチ';
$string['soaprecommended'] = '任意のSOAP拡張モジュールをインストールすることは、ウェブサービスおよびいくつかのアドオンに有用です。';
$string['sort_fullname'] = '長いコース名';
$string['sort_idnumber'] = 'コースIDナンバー';
$string['sort_shortname'] = 'コース省略名';
$string['sort_sortorder'] = '並べ替え順';
$string['spellengine'] = 'スペルエンジン';
$string['spelllanguagelist'] = 'スペル言語リスト';
$string['splrequired'] = '現在、MoodleではSPL PHP拡張モジュールを必要とします。';
$string['stats'] = '統計';
$string['statsfirstrun'] = '最大処理間隔';
$string['statsmaxruntime'] = '最大実行時間';
$string['statsmoodleorg'] = '統計';
$string['statsruntimedays'] = '処理日数';
$string['statsruntimestart'] = '開始時刻';
$string['statsuserthreshold'] = 'ユーザ閾値';
$string['stickyblocks'] = 'スティッキーブロック';
$string['stickyblockscourseview'] = 'コースページ';
$string['stickyblocksduplicatenotice'] = 'あなたがここで追加するブロックがすでに特定のページに登録されている場合、ブロックが重複することになります。<br />この場合、スティッキーブロックのみ編集不可となりますが、重複したブロックは編集することができます。';
$string['stickyblocksmymoodle'] = 'マイMoodle';
$string['stickyblockspagetype'] = '設定するページタイプ';
$string['strictformsrequired'] = '必須フィールドの厳密な妥当性確認';
$string['stripalltitletags'] = 'すべての活動名からHTMLタグを取り除く';
$string['supportcontact'] = 'サポート連絡先';
$string['supportemail'] = 'サポートメール';
$string['supportname'] = 'サポート名';
$string['supportpage'] = 'サポートページ';
$string['suspenduser'] = 'ユーザアカウントを利用停止する';
$string['switchlang'] = '言語ディレクトリを切り替える';
$string['systempaths'] = 'システムパス';
$string['tablenosave'] = '上記テーブル内の変更は自動的に保存されます。';
$string['tablesnosave'] = '上記テーブル内の変更は自動的に保存されます。';
$string['tabselectedtofront'] = 'タブ付きテーブルにおいて、現在選択されているタブを最前部に表示します。';
$string['tabselectedtofronttext'] = '選択されたタブを最前部に表示する';
$string['testsiteupgradewarning'] = '現在、あなたは {$a} テストサイトを使用しています。適切にアップグレードするには、コマンドラインインターフェースツールを使用してください。';
$string['themedesignermode'] = 'テーマデザイナモード';
$string['themelist'] = 'テーマリスト';
$string['themenoselected'] = 'テーマが選択されていません。';
$string['themeresetcaches'] = 'テーマキャッシュをクリアする';
$string['themeselect'] = 'テーマを変更する';
$string['themeselector'] = 'テーマセレクタ';
$string['themesettings'] = 'テーマ設定';
$string['therewereerrors'] = 'あなたのデータにエラーがあります。';
$string['thirdpartylibrary'] = 'ライブラリ';
$string['thirdpartylibrarylocation'] = 'ロケーション';
$string['thirdpartylibs'] = 'サードパーティライブラリ';
$string['timezone'] = 'デフォルトタイムゾーン';
$string['timezoneforced'] = 'サイト管理者によって強制されています。';
$string['timezoneisforcedto'] = 'すべてのユーザに使用を強制する';
$string['timezonenotforced'] = 'ユーザは独自のタイムゾーンを使用できる';
$string['tokenizerrecommended'] = 'PHP Tokenizer拡張モジュールのインストールをお勧めします - Moodleネットーワーキングの機能性を改善します。';
$string['tools'] = '管理ツール';
$string['toolsmanage'] = '管理ツールの管理';
$string['unattendedoperation'] = '無人オペレーション';
$string['unbookmarkthispage'] = 'このページをブックマーク解除する';
$string['unicoderecommended'] = 'あなたのすべてのデータをユニコードフォーマット (UTF-8) で保存することをお勧めします。Moodleの新しいインストールはユニコードをデフォルトキャラクタにセットしたデータベースで実行してください。アップグレードの場合、UTF-8移行処理を実行してださい (詳細は管理ページをご覧ください)。';
$string['unicoderequired'] = 'あなたのすべてのデータをユニコードフォーマット (UTF-8) で保存する必要があります。Moodleの新しいインストールはユニコードをデフォルトキャラクタにセットしたデータベースで実行してください。アップグレードの場合、UTF-8移行処理を実行してださい (詳細は管理ページをご覧ください)。';
$string['uninstallplugin'] = 'アンインストール';
$string['unlockaccount'] = 'アカウントをロック解除する';
$string['unsettheme'] = 'テーマ設定を解除する';
$string['unsupported'] = '未サポート';
$string['unsuspenduser'] = 'ユーザアカウントを有効にする';
$string['updateaccounts'] = '既存のアカウントを更新する';
$string['updateautocheck'] = '利用可能な更新を自動チェックする';
$string['updateautocheck_desc'] = 'この設定を有効にした場合、あなたのサイトはMoodleコードおよびすべての追加プラグインの更新を自動的にチェックします。新しい更新が利用可能な場合、サイト管理者に通知が送信されます。';
$string['updateautodeploy'] = '更新適用を有効にする';
$string['updateautodeploy_desc'] = 'この設定を有効にした場合、あなたはMoodle管理ページから直接利用可能な更新をダウンロードおよびインストールすることができます。この処理を動作させるためには、あなたのウェブサーバプロセスがMoodleインストール済みフォルダに書き込み権を与えることが必要なことに留意してください。これは潜在的なセキュリティリスクになり得ます。';
$string['updateavailable'] = '利用可能な新しいバージョンのMoodleがあります!';
$string['updateavailabledetailslink'] = '詳細は {$a->url} をご覧ください。';
$string['updateavailableforplugin'] = 'あなたのプラグインに利用可能な新しいバージョンがあります!';
$string['updateavailableinstall'] = 'この更新をインストールする';
$string['updateavailable_moreinfo'] = '詳細情報 ...';
$string['updateavailablenot'] = 'あなたのMoodleコードは最新版です!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'バージョン {$a}';
$string['updatecomponent'] = 'コンポーネントを更新する';
$string['updateminmaturity'] = '要求されるコード完成度';
$string['updateminmaturity_desc'] = '少なくとも選択された完成度に達したコードがある場合、利用可能な更新に関して通知します。プラグインがコードの完成度を宣言していない場合、この設定にかかわらず常に報告されます。';
$string['updatenotificationfooter'] = 'あなたのMoodleサイト {$a->siteurl} では利用可能な更新を自動チェックするよう設定されています。あなたはサイト管理者としてメッセージを受信しています。管理ブロック内のサイト管理セクションにて、利用可能な更新の自動チェックを無効にすることができます。また、マイプロファイルセクション内のパーソナルメッセージング設定にて、このメッセージの配信に関してカスタマイズすることができます。';
$string['updatenotifications'] = '更新通知';
$string['updatenotificationsubject'] = 'Moodle更新利用可能 ({$a->siteurl})';
$string['updatenotifybuilds'] = '新しいビルドに関して通知する';
$string['updatenotifybuilds_desc'] = 'この設定を有効にした場合、現在のバージョンの新しいビルドに関して報告される時点で利用可能なMoodleコードの更新も報告されます。ビルドは既存のMoodleバージョンに関する継続的な改善です。通常、ビルドは毎週リリースされます。この設定を無効にした場合、高いバージョンのMoodleがリリースされた場合のみ、利用可能な更新が報告されます。プラグインのチェックはこの設定により影響を受けません。';
$string['upgrade197notice'] = '<p>あなたのサイトのユーザ情報を保護するため、Moodle 1.9.7にはユーザパスワードおよびバックアップに関して、数多くのセキュリティ上の修正が含まれます。結果として、あなたのバックアップに関する設定およびパーミッションが変更された可能性があります。<br />
詳細は<a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 release notes</a>をご覧ください。</p>';
$string['upgrade197noticesubject'] = 'Moodle 1.9.7アップグレードに関するセキュリティ通知';
$string['upgrade197salt'] = 'また、パスワード盗難のリスクを大幅に減らすため、パスワードSALTの設定を強くお勧めします。<br />詳細は、<a href="http://docs.moodle.org/en/Password_salting" target="_blank">Password saltingドキュメント</a>をご覧ください。';
$string['upgradeerror'] = '{$a->plugin} のバージョン {$a->version} へのバージョンアップに不明なエラーが発生したため継続できません。';
$string['upgradeforumread'] = 'Moodle1.5にはフォーラムの既読/未読記事を追跡する新しい機能が追加されました。<br />この機能を有効にするには、<a href="{$a}">あなたのテーブルをアップデート</a>する必要があります。';
$string['upgradeforumreadinfo'] = 'Moodle1.5ではフォーラムの既読/未読記事を追跡するための新しい機能が追加されました。この機能を有効にするには、投稿内容の未読管理を含むテーブルをアップデートする必要があります。あなたのサイトのサイズにより、この作業には長時間かかる場合があります。また、データベースに非常に負荷がかかる可能性がありますので、閑散期のアップデート作業をお勧めします。このアップデート期間中も、あなたのサイトは動作し続け、ユーザは影響を受けません。この処理を開始した場合、 (ブラウザを開いたままにして) 処理を終わらせてください。ウィンドウを閉じて処理を終わらせてしまった場合でも心配しないでください。アップデート処理を再開することができます。<br /><br />本当に今からアップデート処理を始めてもよろしいですか?';
$string['upgradelogs'] = '正常に動作させるためには、古いログのアップグレードが必要です。<a href="{$a}">詳細はこちら</a>';
$string['upgradelogsinfo'] = 'ログの保存方法に変更点があります。あなた活動ベースの古いログを閲覧できるようにするには、古いログをアップグレードする必要があります。サイトによってはアップグレード作業に長時間(例 数時間) を要し、規模が大きなサイトではデータベースに負荷がかかります。処理を開始した場合は終了するまでそのまま (ブラウザを開いたまま) にしてください。心配する必要はありません - ログが更新された後、あなたのサイトは正常に動作します。<br /><br />本当にログをアップグレードしてもよろしいですか?';
$string['upgradepluginsfirst'] = '最初に利用可能な更新のインストールをお勧めします。';
$string['upgradepluginsinfo'] = 'プラグインの更新';
$string['upgradepluginsinfo_help'] = 'あなたのプラグインに関して、利用可能な更新があります。あなたはMoodleデータベースのアップグレード前にそれらをインストールする必要があります。あなたのサイトが自動更新適用をサポートしていない場合、新しいプラグインバージョンをダウンロードして、あなたのサーバに手動でインストールする必要があります。';
$string['upgradesettings'] = '新しい設定';
$string['upgradesettingsintro'] = '以下に表示されている設定はあなたの直近のMoodleアップグレードで追加されました。必要に応じて変更内容をデフォルトに設定した後、このページ下部にある「変更を保存する」ボタンをクリックしてください。';
$string['upgradestalefiles'] = '混合したMoodleバージョンが検出されたため、アップグレードを続けることができません。';
$string['upgradestalefilesinfo'] = 'Moodleディレクトリ内に少なくとも過去2つのメジャーバージョンのMoodle PHPスクリプトが検出されたため、Moodleアップデート処理は中断されました。

後で重大な問題が発生する可能性があるため、あなたはMoodleディレクトリ内に単一バージョンのMoodleファイルのみ含まれていることを確認する必要があります。

下記の方法であなたのMoodleディレクトリから不要なファイルを取り除くことをお勧めします:

* 現在のMoodleディレクトリを「moodle_old」にリネームしてください。
* ダウンロードまたはMoodle Gitリポジトリから取得した標準Moodleパッケージのみを含む新しいMoodleディレクトリを作成してください。
* オリジナルのconfig.phpおよびすべての非標準プラグインを「moodle_old」ディレクトリから新しいMoodleディレクトリにコピーしてください。

Moodleディレクトリから不要なファイルを取り除いた後、Moodleアップデート処理を再開するため、このページをリフレッシュしてください。

しばしばこの警告は前のバージョンのMoodle上に標準パッケージを解凍したことにより発生します。マイナーアップグレードでは問題ありませんが、メジャーアップグレードの場合は決してお勧めできることではありません。

また、この警告はGITリポジトリからの不完全なチェックアウトまたはアップデート処理により発生することがあります。この場合、処理が完了するまで待つか、適切なクリーンアップコマンドを実行した後、処理を再試行してくだｓだい。

さらなる詳細情報は、「<a href="{$a}">{$a}</a>」のアップグレードドキュメンテーションにてご覧いただけます。';
$string['upgradestart'] = 'Moodleデータベースを更新する';
$string['upgradesure'] = '<p>あなたのMoodleファイルが更新されました。自動的にMoodleを下記バージョンにアップグレードしようとしています: </p>
<p><strong>{$a}</strong></p>
</p>一旦この処理を開始すると元に戻すことはできません。この処理には長時間を要することに留意してください。</p>
<p>本当にこのサーバのMoodleをこのバージョンにアップグレードしてもよろしいですか?</p>';
$string['upgradetimedout'] = 'アップグレードがタイムアウトしました。アップグレードをリスタートしてください。';
$string['upgradingdata'] = 'データのアップグレード';
$string['upgradinglogs'] = 'ログのアップグレード';
$string['upgradingversion'] = '新しいバージョンへのアップグレード';
$string['upwards'] = '以上';
$string['useblogassociations'] = '関連付けを有効にする';
$string['useexternalyui'] = 'オンラインYUI ライブラリを使用する';
$string['user'] = 'ユーザ';
$string['userbulk'] = 'バルクユーザ処理';
$string['userlist'] = 'ユーザ一覧を表示する';
$string['userpolicies'] = 'ユーザポリシー';
$string['userpreference'] = 'ユーザプリファレンス';
$string['userquota'] = 'ユーザクオータ';
$string['users'] = 'ユーザ';
$string['usesitenameforsitepages'] = 'サイトページにサイト名を使用する';
$string['usetags'] = 'タグ機能を有効にする';
$string['validateerror'] = 'この値は有効ではありません:';
$string['verifychangedemail'] = 'メールアドレスの変更時、ドメインを制限する';
$string['warningcurrentsetting'] = '無効な現在値: {$a}';
$string['warningiconvbuggy'] = 'あなたのバージョンのiconvライブラリはIGNORE modifierをサポートしていません。無効なUTF-8文字列を含むストリングをクリーニングするため、代わりにmbstring拡張モジュールをインストールする必要があります。';
$string['webproxy'] = 'ウェブプロクシ';
$string['webproxyinfo'] = 'あなたのMoodleサーバが直接インターネットに接続できない場合、以下のオプションに必要事項を入力してください。インターネットアクセスは環境データ、言語パック、RSSフィード、タイムゾーン等のダウンロードに必要です。<br />PHP cURL拡張モジュールの使用を強くお勧めします。';
$string['xmlrpcrecommended'] = 'xmlrpc拡張モジュールはハブコミュニケーションに必要です。また、ウェブサービスおよびMoodleネットワーキングに有用です。';
$string['yuicomboloading'] = 'YUI combo読み込み';
$string['ziprequired'] = 'MoodleではPHP Zip拡張モジュールが必須です。info-ZIPバイナリまたはPclZipライブラリは今後使用されません。';
$string['zlibenabled'] = 'zlib有効';
