<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   auth
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Razpoložljivi avtentikacijski vtičniki';
$string['alternatelogin'] = 'Če tu vnesete URL, bo uporabljen kot stran za prijavo v to spletno mesto. Stran mora vsebovati obrazec, ki ima nastavljeno lastnost <i>action</i> na <strong>\'{$a}\'</strong> in polji <strong>uporabniško ime</strong> ter <strong>geslo</strong>.<br />Bodite pozorni, da ne vnesete napačnega naslova URL, da se ne zaklenete iz tega spletnega mesta.<br />Pustite to nastavitev prazno za uporabo privzete prijavne strani.';
$string['alternateloginurl'] = 'Alternativni URL prijave';
$string['auth_changepasswordhelp'] = 'Pomoč za spreminjanje gesla';
$string['auth_changepasswordhelp_expl'] = 'Prikaz pomoči ob izgubljenem geslu uporabnikom, ki so izgubili svoje {$a} geslo. To bo prikazano bodisi poleg ali namesto <strong>URL spreminjanja gesla</strong> ali vgrajenega mehanizma spreminjanja gesla.';
$string['auth_changepasswordurl'] = 'URL za spremembo gesla';
$string['auth_changepasswordurl_expl'] = 'Navedite URL, kamor naj bodo napoteni uporabniki, ki so izgubili svoje {$a} geslo. Nastavite <strong>Uporabi običajno stran za spreminjanje gesla</strong> na <strong>Ne</strong>.';
$string['auth_changingemailaddress'] = 'Zahtevali ste spremembo e-poštnega naslova z {$a->oldemail} na {$a->newemail}. Zaradi varnostnih razlogov smo vam na nov e-poštni naslov poslali sporočilo, da potrdite, da je nov e-poštni naslov res vaš. Vaš e-poštni naslov bo spremenjen takoj, ko kliknete na URL povezavo v sporočilu.';
$string['auth_common_settings'] = 'Splošne nastavitve';
$string['auth_data_mapping'] = 'Povezovanje podatkov';
$string['authenticationoptions'] = 'Možnosti preverjanja pristnosti';
$string['auth_fieldlock'] = 'Zakleni vrednost';
$string['auth_fieldlock_expl'] = '<p><b>Zakleni vrednost:</b> Če je omogočeno, bo to preprečilo uporabnikom Moodle in skrbnikom neposredno urejanje tega polja. Uporabite to možnost, če vzdržujete te podatke v zunanjem sistemu preverjanja pristnosti. </p>';
$string['auth_fieldlocks'] = 'Zakleni uporabniška polja';
$string['auth_fieldlocks_help'] = '<p>Zaklenete lahko uporabniška podatkovna polja. To je uporabno za spletna mesta, kjer uporabniške podatke vzdržujejo skrbniki ročno z vnašanjem uporabniških zapisov ali nalaganjem z možnostjo \'Naloži uporabnike\'- Če zaklepate polja. ki jih Moodle zahteva, poskrbite, da bodo podatki ob ustvarjanju uporabniških računov ali računov uporabni.</p><p>Razmislite o nastavitvi načina zaklepanja na \'Odkleni prazno\' v izogib tem problemom.</p>';
$string['authinstructions'] = 'Tu lahko zagotovite navodila za vaše uporabnike, da bodo vedeli katero uporabniško ime in geslo naj uporabijo.  Besedilo, ki ga boste tu vnesli, se bo pojavilo na strani prijave.  Če boste pustili to prazno, ne bo prikazanih nobenih navodil.';
$string['auth_invalidnewemailkey'] = 'Napaka: če poskušate potrditi spremembo e-poštnega naslova, je mogoče prišlo do napake pri kopiranju URL naslova, ki ste ga dobili po e-pošti. Skopirajte naslov še enkrat in poskusite ponovno.';
$string['auth_multiplehosts'] = 'Določenih je več gostiteljev ALI naslovov (npr. host1.com;host2.com;host3.com) ali (npr. xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_outofnewemailupdateattempts'] = 'Porabili ste vse dovoljne poskuse posodobitve e-poštnega naslova. Vaša zahteva je bila preklicana.';
$string['auth_passwordisexpired'] = 'Vaše geslo je poteklo. Želite spremeniti svoje geslo zdaj?';
$string['auth_passwordwillexpire'] = 'Vaše geslo bo poteklo čez {$a} dni. Želite spremeniti svoje geslo zdaj?';
$string['auth_remove_delete'] = 'Pobriši lokalni račun';
$string['auth_remove_keep'] = 'Ohrani lokalni račun';
$string['auth_remove_suspend'] = 'Suspendiraj lokalni račun';
$string['auth_remove_user'] = 'Določite, kaj se zgodi z lokalnimi uporabniškimi računi v primeru, da je bil uporabnik izbrisan z zunanjega vira. Suspendirani uporabniki so avtomatično oživljeni, če se spet pojavijo v zunanjem viru.';
$string['auth_remove_user_key'] = 'Izbrisan zunanji uporabnik';
$string['auth_sync_script'] = 'Sinhronizacijski program Cron';
$string['auth_updatelocal'] = 'Posodobi lokalno';
$string['auth_updatelocal_expl'] = '<p><b>Posodobi lokalno:</b> Če je omogočeno, bo polje posodobljeno (iz zunanjega mehanizma) vsakič, ko se uporabnik prijavi ali se sinhronizirajo uporabniki. Polja nastavljena za lokalno posodobitev morajo biti zaklenjena.</p>';
$string['auth_updateremote'] = 'Posodobi zunanje';
$string['auth_updateremote_expl'] = '<p><b>Posodobi zunanje:</b> Če je omogočeno bo zunanji mehanizem posodobljen, ko bo posodobljen uporabniški zapis. Polja morajo biti odklenjena za možnost urejanja.</p>';
$string['auth_updateremote_ldap'] = '<p><b>Opomba:</b> Posodabljanje zunanjih LDAP podatkov zahteva nastavitev binddn in bindpw na uporabnika bind s pravicami urejanja vseh uporabniških zapisov. Trenutno ne ohranja lastnosti v zečimi vrednostmi in bo ob posodobitvi odstranilo dodatne vrednosti. </p>';
$string['auth_user_create'] = 'Omogoči ustvarjanje uporabnikov';
$string['auth_user_creation'] = 'Novi (anonimni) uporabniki lahko ustvarjajo uporabniške račune na zunanjem viru preverjanja pristnosti in so potrjeni prek e-pošte. Če to omogočite, konfigurirajte tudi specifične možnosti za posamezne module za ustvarjanje uporabnikov.';
$string['auth_usernameexists'] = 'Izbrano uporabniško ime že obstaja. Prosimo izberite novega.';
$string['auto_add_remote_users'] = 'Samodejno dodaj oddaljene uporabnike';
$string['changepassword'] = 'URL za spremembo gesla';
$string['changepasswordhelp'] = 'Tu lahko določite mesto, na katerem lahko vaši uporabniki ponovno pridobijo ali spremenijo svoje uporabniško ime ali geslo, če so ga pozabili. Uporabnikom bo prikazan gumb na prijavni strani in na njihovi uporabniški strani. Če pustite to prazno, gumb ne bo prikazan.';
$string['chooseauthmethod'] = 'Izberite način preverjanja pristnosti';
$string['chooseauthmethod_help'] = '<p>Ta meni vam omogoča spreminjanje načina preverjanja pristnosti za določenega uporabnika.</p>

<p>Zavedajte se, da je to zelo odvisno od načina preverjanja pristnosti, ki ste ga nastavili za spletno mesto in tega, kakšne nastavitve uporabljajo.</p>

<p>Z napačno spremembo tu lahko tej osebi preprečite prijavo ali celo popolnoma izbrišete njen račun. Prosimo, uporabljajte to možnost samo, če veste, kaj počnete.</p>';
$string['createpassword'] = 'Generiraj geslo in obvesti uporabnika';
$string['createpasswordifneeded'] = 'Ustvari geslo, če je potrebno';
$string['emailchangecancel'] = 'Prekliči spremembo e-poštnega naslova';
$string['emailchangepending'] = 'Sprememba v teku. Kliknite na URL povezavo, ki je bila poslana na naslov {$a->preference_newemail}.';
$string['emailnowexists'] = 'E-poštni naslov, ki ste ga želeli dodati svojemu profilu, je bil v času od vaše zahteve dodeljen drugemu. Vaša zahteva je bila zato preklicana. Lahko poskusite ponovno z novim naslovom.';
$string['emailupdate'] = 'Posodobi e-poštni naslov';
$string['emailupdatemessage'] = 'Spoštovani {$a->fullname},

zahtevali ste spremembo vašega e-poštnega naslova vašega uporabniškega računa na strežniku {$a->site}. Prosimo, da spodnjo povezavo odprete v vašem brskalniku in potrdite spremembo.

{$a->url}';
$string['emailupdatesuccess'] = 'E-poštni naslov uporabnika <em>{$a->fullname}</em> je bil uspešno posodobljen na <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Potrditev e-poštnega naslova na strežniku {$a->site}';
$string['enterthenumbersyouhear'] = 'Vnesite številke, ki jih slišite';
$string['enterthewordsabove'] = 'Vnesite besede zgoraj';
$string['errormaxconsecutiveidentchars'] = 'Gesla lahko imajo največ {$a} zaporednih enakih znakov.';
$string['errorminpassworddigits'] = 'Geslo mora imeti vsaj {$a} številk.';
$string['errorminpasswordlength'] = 'Geslo mora biti dolgo vsaj {$a} znakov.';
$string['errorminpasswordlower'] = 'Geslo mora imeti najmanj {$a} malih črk.';
$string['errorminpasswordnonalphanum'] = 'Geslo mora imeti vsaj {$a} znakov, ki niso črke ali številke.';
$string['errorminpasswordupper'] = 'Geslo mora imeti vsaj {$a} velikih črk.';
$string['errorpasswordupdate'] = 'Napaka pri zapisovanju novega gesla. Geslo ni spremenjeno';
$string['eventuserloggedinas'] = 'Uporabnik se je prijavil kot drug uporabnik';
$string['forcechangepassword'] = 'Vsili spremembo gesla';
$string['forcechangepasswordfirst_help'] = 'Prisili uporabnike v spremembo geslo ob njihovi prvi prijavi.';
$string['forcechangepassword_help'] = 'Prisili uporabnike v spremembo geslo ob njihovi naslednji prijavi.';
$string['forgottenpassword'] = 'Če vnesete URL naslov, bo uporabljen za pridobivanje izgubljenih gesel za ta strežnik. Funkcija je namenjena strežnikom, kjer so gesla hranjena zunaj Moodle. Pustite prazno za uporabo privzetega načina pridobivanja izgubljenih gesel.';
$string['forgottenpasswordurl'] = 'URL za pozabljeno geslo';
$string['getanaudiocaptcha'] = 'Nov zvočni CAPTCHA';
$string['getanimagecaptcha'] = 'Nov slikovni CAPTCHA';
$string['getanothercaptcha'] = 'Nov CAPTCHA';
$string['guestloginbutton'] = 'Gumb za prijavo gosta';
$string['incorrectpleasetryagain'] = 'Nepravilno. Prosimo, poskusite znova.';
$string['infilefield'] = 'Zahtevano polje v datoteki';
$string['informminpassworddigits'] = 'vsaj številk: {$a}';
$string['informminpasswordlength'] = 'vsaj znakov: {$a}';
$string['informminpasswordlower'] = 'vsaj malih črk: {$a}';
$string['informminpasswordnonalphanum'] = 'vsaj nealfanumeričnih znakov: {$a}';
$string['informminpasswordupper'] = 'vsaj velikih črk: {$a}';
$string['informpasswordpolicy'] = 'Geslo mora imeti {$a}';
$string['instructions'] = 'Navodila';
$string['internal'] = 'Interno';
$string['locked'] = 'Zaklenjeno';
$string['md5'] = 'Šifriranje MD5';
$string['nopasswordchange'] = 'Geslo ni mogoče spremeniti';
$string['nopasswordchangeforced'] = 'Za nadaljevanje morate spremeniti geslo, vendar pa ni na voljo strani, kjer bi to lahko naredili. Prosimo, stopite v stik z vašim Moodle administratorjem.';
$string['noprofileedit'] = 'Profila ni mogoče urejati';
$string['ntlmsso_attempting'] = 'Poskušam z enotno prijavo prek NTLM ...';
$string['ntlmsso_failed'] = 'Samodejna prijava ni uspela, poskusite prek običajne prijavne strani ...';
$string['ntlmsso_isdisabled'] = 'Enotna prjava NTLM ni omogočena.';
$string['passwordhandling'] = 'Obravnava polja za geslo';
$string['plaintext'] = 'Golo besedilo';
$string['pluginnotenabled'] = 'Vtičnik za avtentikacijo \'{$a}\' ni vključen.';
$string['pluginnotinstalled'] = 'Vtičnik za avtentikacijo \'{$a}\' ni nameščen.';
$string['potentialidps'] = 'Ali se običajno prijavite nekje drugje pred obiskom te strani? <br /> Izberite iz naslednjega seznama prijavo z vašega običajnega mesta:';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = '<h2>Opis</h2>
<p>Program "CAPTCHA" prek preverjanja prepoznavanja teksta ali zvoka preverja, če je na drugi strani človek ali računalnik. Sisteme CAPTCHA uporablja veliko spletnih mest za preprečevanje zlorabe s strani programov, ki ponavadi služijo pošiljanju neželjene pošte ali povezav. Ker programi ne znajo tako dobro prebrati popačenega teksta kot človek, so sistemi CAPTCHA dobra ovira takim programom. </p>

<h2>Navodila</h2>
<p>Prosimo, vnesite besede, ki jih vidite v polju CAPTCHA v pravilnem vrstnem redu in ločene s presledkom. To onemogoča zlorabo sistema s strani zlonamernih programov.</p>

<p>Če niste prepričani, katere besede so na sliki, vpišite najboljši približek ali pa kliknite na povezavo "Get another CAPTCHA" za tvorjenje nove slike.</p>

<p>Uporabniki s težavami vida lahko kliknejo na povezavo "Get an audio CAPTCHA". Slišali boste zaporedje številk, ki jih nato vnesete v polje.</p>';
$string['selfregistration'] = 'Samo-registracija';
$string['selfregistration_help'] = 'Izberite avtentikacijski vtičnik za samo-registracijo';
$string['sha1'] = 'SHA-1 hash';
$string['showguestlogin'] = 'Gumb za prijavo gosta na strani za prijavo lahko skrijete ali prikažete.';
$string['stdchangepassword'] = 'Uporabi standardno stran za spremembo gesla';
$string['stdchangepassword_expl'] = 'Če zunanji sistem preverjanja pristnosti dovoljuje spreminjanje gesel prek Moodle, preklopite to na Da. Ta nastavitev preglasi \'URL za spremembo gesla\'.';
$string['stdchangepassword_explldap'] = 'Opomba: Priporočeno je, da uporabljate LDAP prek SSL šifriranega tunela (ldaps://), če je strežnik LDAP oddaljen strežnik.';
$string['suspended'] = 'Začasno onemogočen račun';
$string['suspended_help'] = 'Uporabniki z začasno onemogočeni računi se ne morejo prijaviti ali uporabljati spletnih storitev. Odhodna sporočila bodo zavržena.';
$string['testsettings'] = 'Preskusi nastavitve';
$string['testsettingsheading'] = 'Preskusi avtentikacijske nastavitve - {$a}';
$string['unlocked'] = 'Odklenjeno';
$string['unlockedifempty'] = 'Odkleni prazno';
$string['update_never'] = 'Nikoli';
$string['update_oncreate'] = 'Ob ustvarjanju';
$string['update_onlogin'] = 'Ob vsaki prijavi';
$string['update_onupdate'] = 'Ob posodobitvi';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ne podpira izbranega tipa uporabnika: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() ne podpira izbranega tipa uporabnika (...še)';
