<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'eu', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Galdetegi hau aurreikus dezakezu, baina benetako saiakera baldin bada, blokeatu egin zaitzake honegatik:';
$string['action'] = 'Ekintza';
$string['activityoverview'] = 'Egin gabeko galdetegiak dituzu';
$string['adaptive'] = 'Egokitze modua';
$string['adaptive_help'] = 'Gaituz gero, galdetegiaren saiakera berean erantzun bat baino gehiago onartuko da galdera bakoitzerako. Horrela, adibidez, erantzun bat okertzat ematen bada, ikasleak saiakera berri bat egin ahal izango du. Dena den, "Penalizazioak ezarri" ezarpenaren arabera, penalizazioa ezarriko zaio saiakera oker bakoitzari.';
$string['addaquestion'] = 'Gehitu galdera bat...';
$string['addarandomquestion'] = 'Gehitu ausazko galdera bat...';
$string['addarandomquestion_help'] = 'Ausazko galdera bat gehituz gero, ausaz aukeratuko da galdera bat galdetegian hautatutako kategoriatik. Hau dela-eta, ikasle bakoitzari galdera desberdinak agertuko zaizkio, eta, galdetegiak saiakera bat baino gehiago onartzen badu, saiakera bakoitzak galdera desberdinak izan ditzake.';
$string['adddescriptionlabel'] = 'Gehitu deskribapena/etiketa';
$string['addingquestion'] = 'Galdera gehitzen';
$string['addingquestions'] = '<p>Orriaren alde honetan zure galderen datu-basea kudeatuko duzu. Galderak kategoriaka gordetzen dira antolaketa errazteko eta horrela gainera galdetegi batean baino gehiagotan erabil daitezke edo ikastaro ezberdinetan, \'argitaratu\' aukeratzen baduzu.</p>
<p>Kategoria bat aukeratu edo sortutakoan galderak sortu edo editatu ahal izango dituzu. Orri honen beste aldean agertzen diren galderetako bat aukera dezakezu zure galdetegira gehitzeko.</p>';
$string['addmoreoverallfeedbacks'] = 'Gehitu feedback-etarako {no} eremu gehiago';
$string['addnewgroupoverride'] = 'Gehitu talde-baliogabetzea';
$string['addnewpagesafterselected'] = 'Gehitu beste orri batzuk aukeratutako galderen ondoren';
$string['addnewquestionsqbank'] = 'Gehitu galderak kategoria honetara {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Gehitu erabiltzaile-baliogabetzea';
$string['addpagehere'] = 'Gehitu orria hemen';
$string['addquestion'] = 'Gehitu galdera';
$string['addquestions'] = 'Gehitu galderak';
$string['addquestionstoquiz'] = 'Gehitu galderak oraingo galdetegiari';
$string['addrandom'] = 'Gehitu ausazko {$a} galdera';
$string['addrandom1'] = '<< Gehitu';
$string['addrandom2'] = 'ausazko galderak';
$string['addrandomfromcategory'] = 'Gehitu ausazko galderak kategoria honetatik:';
$string['addrandomquestion'] = 'Gehitu ausazko galdera';
$string['addrandomquestiontoquiz'] = 'Gehitu ausazko galdera {$a} galdetegira';
$string['addselectedtoquiz'] = 'Gehitu galdetegira aukeratutakoak';
$string['addtoquiz'] = 'Gehitu galdetegira';
$string['affectedstudents'] = '{$a} eragindako';
$string['aftereachquestion'] = 'Galdera bakoitza gehitu ondoren';
$string['afternquestions'] = '{$a} galdera gehitu ondoren';
$string['age'] = 'adina';
$string['allattempts'] = 'Saiakera guztiak';
$string['allinone'] = 'Mugarik gabe';
$string['allowreview'] = 'Berrikusteko aukera';
$string['alreadysubmitted'] = 'Saiakera hau dagoeneko bidali duzula ematen du';
$string['alternativeunits'] = 'Ordezko unitateak';
$string['alwaysavailable'] = 'Beti eskuragarri';
$string['analysisoptions'] = 'Analisirako aukerak';
$string['analysistitle'] = 'elementuen analisirako taula';
$string['answer'] = 'Erantzuna';
$string['answered'] = 'Erantzuna emanda';
$string['answerhowmany'] = 'Erantzun bakarra edo anitzak?';
$string['answers'] = 'Erantzunak';
$string['answersingleno'] = 'Erantzun bat baino gehiago ahal da izan';
$string['answersingleyes'] = 'Erantzun bakarra';
$string['answertoolong'] = '{$a} lerrotik aurrera erantzuna luzeegi bihurtu da (gehienez 255 karakt.)';
$string['aon'] = 'AON formatua';
$string['areyousureremoveselected'] = 'Ziur al zaude aukeratutako galdera guztiak ezabatu nahi dituzula?';
$string['asshownoneditscreen'] = 'Edizio-pantailan erakusten den bezala';
$string['attempt'] = '{$a} saiakera';
$string['attemptalreadyclosed'] = 'Dagoeneko bukatu da saiakera hau.';
$string['attemptclosed'] = 'Saiakera ez da oraindik itxi.';
$string['attemptduration'] = 'Emandako denbora';
$string['attemptedon'] = 'Noiz saiatuta';
$string['attempterror'] = 'Ez duzu baimenik galdetegi hau egiten orain saiatzeko. Arrazoia: {$a}';
$string['attemptfirst'] = 'Lehen saiakera';
$string['attemptincomplete'] = '{$a}-(r)en saiakera hau ez da burutu';
$string['attemptlast'] = 'Azken saiakera';
$string['attemptnumber'] = 'Saiakera';
$string['attemptquiznow'] = 'Saiatu galdetegia egiten';
$string['attempts'] = 'Saiakerak';
$string['attemptsallowed'] = 'Baimendutako saiakerak';
$string['attemptsdeleted'] = 'Galdetegiaren saiakerak ezabatu dira';
$string['attemptselection'] = 'Aukeratu zenbat saiakera erabiltzaileko:';
$string['attemptsexist'] = 'Galdetegi hau baten bat saiatu da egiten';
$string['attemptsnum'] = 'Saiakerak: {$a}';
$string['attemptsnumthisgroup'] = 'Saiakerak: {$a->total} ({$a->group} talde honetan)';
$string['attemptsnumyourgroups'] = 'Saiakerak: {$a->total} ({$a->group} zure taldeetan)';
$string['attemptsonly'] = 'Saiakerak egin dituzten ikasleak  baino ez erakutsi';
$string['attemptstate'] = 'Egoera';
$string['attemptstillinprogress'] = 'Saiakera egiten ari da';
$string['attemptsunlimited'] = 'Saiakera-kopuru mugagabea';
$string['autosaveperiod'] = 'Automatikoki gordetzeko epea';
$string['autosaveperiod_desc'] = 'Ikasleen erantzunak automatikoki gorde daitezke hainbat minuturo galdetegia egin bitartean. Honek badu ondorio bat: erantzunak gordetzean handitu egiten du zerbitzariaren lana baina ikasleen lana galtzeko arriskua gutxitu egiten da.';
$string['back'] = 'Itzuli aurreko galderara';
$string['backtocourse'] = 'Itzuli ikastarora';
$string['backtoquestionlist'] = 'Itzuli galdera-zerrendara';
$string['backtoquiz'] = 'Itzuli galdetegiaren ediziora';
$string['basicideasofquiz'] = 'Galdetegiak sortzeko oinarrizko ideiak';
$string['bestgrade'] = 'Notarik onena';
$string['bothattempts'] = 'Saiakerak egin dituzten ikasleak eta egin ez dituztenak erakutsi';
$string['browsersecurity'] = 'Nabigatzailearen segurtasuna';
$string['browsersecurity_help'] = '"JavaScript segurtasuna duen pantaila osoko popup" aukera gaituta badago:

* Galdetegia soilik hasiko da ikaslearen nabigatzaileak JavaScript-a gaituta badauka
* Galdetegia pantaila osoko popup leihoan zabalduko da, eta ez du nabigazio-kontrolik izango
* Ahal den neurrian, ikasleei ez zaie utziko copy paste moduko laguntza tresnarik erabiltzea.';
$string['calculated'] = 'Kalkulatutakoa';
$string['calculatedquestion'] = 'Kalkulatutako Galdera ezin erabili ondorengo lerroan: {$a}. Galdera ez da kontuan hartuko.';
$string['cannotcreatepath'] = 'Ezin da ({$a}) ibilbidea sortu';
$string['cannoteditafterattempts'] = 'Ezin dituzu galderak gehitu edo ezabatu saiakerak egin baitira. ({$a})';
$string['cannotfindprevattempt'] = 'Ezin da lehenagoko saiakera aurkitu horretan oinarritzeko.';
$string['cannotfindquestionregard'] = 'Errorea berriz kalifikatzeko galderak lortzean!';
$string['cannotinsert'] = 'Ezin da galderarik txertatu';
$string['cannotinsertrandomquestion'] = 'Ezin da ausazko galdera berririk txertatu';
$string['cannotloadquestion'] = 'Ezin dira kargatu galderaren aukerak';
$string['cannotloadtypeinfo'] = 'Ezinezkoa da galdera-mota jakin honi buruzko informazioa kargatzea';
$string['cannotopen'] = 'Ezin da ({$a}) fitxategia esportatu';
$string['cannotrestore'] = 'Ezin dira galdera-saioak berreskuratu';
$string['cannotreviewopen'] = 'Ezin duzu saiakera hau berrikusi, oraindik irekita baitago.';
$string['cannotsavelayout'] = 'Ezin da diseinua gorde';
$string['cannotsavenumberofquestion'] = 'Ezin da gorde galdera-kopurua orriko';
$string['cannotsavequestion'] = 'Ezin da galdera-zerrenda gorde';
$string['cannotsetgrade'] = 'Ezin izan da galdetegirako gehienezko kalifikazio berria ezarri.';
$string['cannotsetsumgrades'] = 'Ezin izan da ezarri kalifikazioen batura';
$string['cannotstartgradesmismatch'] = 'Ezin da hasi saiakera galdetegian. Galdetegia konfiguratuta dago {$a->grade} arte, baina galdetegiak ez du kalifikazioa duen galderarik. Arazo hau \'Galdetegia editatu\' orrian zuzen daiteke.';
$string['cannotstartmissingquestion'] = 'Ezin da hasi galdetegi-saiakera. Galdetegiak existitzen ez den galdera bat dauka .';
$string['cannotstartnoquestions'] = 'Ezin da hasi saiakerarik galdetegi honetan. Galdetegia ez da oraindik prestatu; ez da galderarik gehitu.';
$string['cannotwrite'] = 'Ezin da esportatutako fitxategia idatzi ({$a})';
$string['caseno'] = 'Ez, letra larriak eta xeheak ez dira bereiziko';
$string['casesensitive'] = 'Letra larriak eta xeheak bereiziz';
$string['caseyes'] = 'Bai, letra larriak eta xeheak bereizi egingo dira';
$string['categories'] = 'Kategoriak';
$string['category'] = 'Kategoria';
$string['categoryadded'] = '\'{$a}\' kategoria gehituta';
$string['categorydeleted'] = '\'{$a}\' kategoria ezabatuta';
$string['categorynoedit'] = 'Ezin duzu editatu kategoria honetan: \'{$a}\'';
$string['categoryupdated'] = 'Kategoria hau arrakastaz eguneratua';
$string['close'] = 'Leihoa itxi';
$string['closebeforeopen'] = 'Galdetegia ezin izan da eguneratu: bukaera data hasiera data baino lehenagokoa da.';
$string['closed'] = 'Itxita';
$string['closepreview'] = 'Aurrebista itxi';
$string['closereview'] = 'Berrikusketa itxi';
$string['comment'] = 'Iruzkina';
$string['commentorgrade'] = 'Iruzkina egin edo kalifikazioa baliogabetu';
$string['comments'] = 'Iruzkinak';
$string['completedon'] = 'Noiz bukatua';
$string['configadaptive'] = 'Aukera honetan Bai ezarriz gero, ikasleak aukera izango du galdetegiaren saiakera berean galdera bati hainbat erantzun emateko.';
$string['configattemptsallowed'] = 'Ikasleek galdetegian egin dezaketen saiakera-kopuruaren muga';
$string['configdecimaldigits'] = 'Kalifikazioak erakustean azalduko diren dezimal kopurua.';
$string['configdecimalplaces'] = 'Galdetegiaren kalifikazioak erakustean azalduko diren dezimal kopurua.';
$string['configdecimalplacesquestion'] = 'Galdera bakoitzaren kalifikazioan erakutsi beharreko dezimal kopurua.';
$string['configdelay1'] = 'Denbora-tartea ezartzen baduzu, ikasleak tarte hori utzi beharko du lehen aldiz erantzun ondoren berriz erantzun ahal izateko.';
$string['configdelay1st2nd'] = 'Hemen denbora-tartea ezartzen baduzu, ikasleak ezin izango dio bigarren saiakerari ekin lehen saiakera bukatu duenetik denbora-tarte hori iragan arte.';
$string['configdelay2'] = 'Hemen denbora-tartea ezartzen baduzu, ikasleak itxaron egin beharko du hirugarren aldiz edo hortik aurrera erantzun ahal izateko.';
$string['configdelaylater'] = 'Hemen denbora-tartea ezartzen baduzu, ikasleak ezin izango du hirugarren, laugarren... saiakera aurreko saikera bukatu eta denbora-tarte hori iragar arte.';
$string['configeachattemptbuildsonthelast'] = 'Hainbat saiakera baimentzen bada, saiakera berri bakoitzak aurrekoaren emaitzak izango ditu.';
$string['configgrademethod'] = 'Hainbat saiakera baimentzen bada, zein metodo erabili beharko den galdetegian ikaslearen azken kalifikazioa kalkulatzeko.';
$string['configintro'] = 'Hemen ezartzen dituzun baloreek definituko dituzte ezarpenen formularioan erabiliko diren berezko baloreak galdetegi berria sortzen duzunean. Galdetegiaren zein ezarpen hartzen den aurreratutzat ere zehaz dezakezu.';
$string['configmaximumgrade'] = 'Galdetegiak izango duen lehenetsitako kalifikazioa.';
$string['confignavmethod'] = 'Nabigazio librean, galderak edozein ordenatan erantzun daitezke. Sekuentzialean, galderak ordena hertsian erantzun behar dira.';
$string['confignewpageevery'] = 'Galderak galdetegira gehitzeko unean, orri-jauziak sartuko dira hemen aukeratutakoaren arabera.';
$string['configoutcomesadvanced'] = 'Aukera hau gaituta badago, helburuak azalduko dira galdetegiaren edizio-formularioaren ezarpen aurreratuetan.';
$string['configpenaltyscheme'] = 'Egokitze-moduan erantzun okerrei ezarritako penalizazioa.';
$string['configpopup'] = 'Behartu saiakera popup leiho batean irekitzera, eta, galdetegiaren saiakeretan, JavaScript trikimailuen bidez, copy, paste eta antzeko ekintzen erabilera murriztu.';
$string['configrequirepassword'] = 'Ikasleek pasahitz hau idatzi behar dute galdetegiari erantzuten hasi hala izateko.';
$string['configrequiresubnet'] = 'Ikasleek ordenagailu hauetatik bakarrik erantzun diezaiokete galdetegiari.';
$string['configreviewoptions'] = 'Erabiltzaileek galdetegiaren berrikuspenean edo galdetegiaren txostenean ikus dezaketen informazioa kontrolatzen da aukera hauen bidez.';
$string['configshowblocks'] = 'Blokeak erakutsi galdetegiari erantzun bitartean';
$string['configshowuserpicture'] = 'Erakutsi erabiltzaileen irudia pantailan galdetegiari erantzun bitartean.';
$string['configshufflequestions'] = 'Aukera hau gaitzen baduzu, galderen ordena ausaz nahastuko da ikaslea galdetegiari erantzuten saiatzen den bakoitzean.';
$string['configshufflewithin'] = 'Hau gaituz gero, ikasleek saiakera bat egiten duen bakoitzean, galderen osagaiak ausaz nahastuko dira; kontuan izan galderaren ezarpenetan aukera berdinak gaituta egon behar duela.';
$string['configtimelimit'] = 'Berezko denbora-muga galdetegietarako minututan. 0-k ez dagoela mugarik adierazten du.';
$string['configtimelimitsec'] = 'Berezko denbora-muga galdetegietarako segundutan. 0-k ez dagoela mugarik adierazten du.';
$string['configurerandomquestion'] = 'Konfiguratu galdera';
$string['confirmclose'] = 'Behin saiakera itxitakoan ezingo duzu bertako erantzunetan aldaketarik egin.';
$string['confirmserverdelete'] = 'Ziur al zaude <b>{$a}</b> zerbitzaria zerrendatik kendu nahi duzula?';
$string['confirmstartattemptlimit'] = 'Baimendutako saiakera-kopurua: {$a}. Galdetegira sartzea saiakeratzat hartuko da. Jarraitu egin nahi al duzu?';
$string['confirmstartattempttimelimit'] = 'Galdetegi honek denbora muga du eta {$a} saiakera ezarri zaizkio. Galdetegira sartzea saiakeratzat hartuko da. Jarraitu egin nahi al duzu?';
$string['confirmstarttimelimit'] = 'Galdetegi honek denbora muga du. Ziur hasi egin nahi duzula?';
$string['connectionerror'] = 'Galdu egin da sarearen konexioa (Ez du berez gordeko)

Gorde idatziz azken minutuetan orri honetan egin dituzun erantzunak eta ondoren saiatu berriz konektatzen.

Konexioa berriz ezartzen denean, zure erantzunak gordetzeko modua izango da eta mezu hau desagertu egingo da.';
$string['connectionok'] = 'Berrezarri da sare-konexioa. Seguru jarrai dezakezu.';
$string['containercategorycreated'] = 'Beherago zehazten diren arrazoiengatik gunera bildu diren jatorrizko kategoria guztiak biltzeko sortu da kategoria hau.';
$string['continueattemptquiz'] = 'Jarraitu azken saiakerarekin';
$string['continuepreview'] = 'Jarraitu aurreko aurrebistarekin';
$string['copyingfrom'] = '\'{$a}\' galderaren kopia sortzen';
$string['copyingquestion'] = 'Galdera kopiatzen';
$string['correct'] = 'Zuzena';
$string['correctanswer'] = 'Erantzun zuzena';
$string['correctanswerformula'] = 'Erantzun zuzenerako formula';
$string['correctansweris'] = 'Erantzun zuzena: {$a}';
$string['correctanswerlength'] = 'Datu esanguratsuak';
$string['correctanswers'] = 'Erantzun zuzenak';
$string['correctanswershows'] = 'Erantzun zuzena erakusten du';
$string['corrresp'] = 'Erantzun zuzena';
$string['countdown'] = 'Denbora-muga';
$string['countdownfinished'] = 'Galdetegia ixtear dago: bidali erantzunak lehenbailehen!';
$string['countdowntenminutes'] = 'Galdetegia hamar minutu barru itxiko da.';
$string['coursetestmanager'] = 'Ikastaroa testatzeko kudeaketa-formatua';
$string['createcategoryandaddrandomquestion'] = 'Sortu kategoria eta gehitu ausazko galdera';
$string['createfirst'] = 'Lehenik erantzun laburreko zenbait galdera prestatu behar dituzu.';
$string['createmultiple'] = 'Gehitu ausazko galdera batzuk galdetegiari';
$string['createnewquestion'] = 'Galdera berria sortu';
$string['createquestionandadd'] = 'Galdera berria sortu eta galdetegira gehitu.';
$string['custom'] = 'Formatu pertsonalizatua';
$string['dataitemneed'] = 'Gutxienez item-multzoa gaineratu behar duzu galdera onargarri bat izateko';
$string['datasetdefinitions'] = 'Berriz erabiltzeko moduko datu-multzorako definizioak ondorengo kategoriarako: {$a}';
$string['datasetnumber'] = 'Zenbakia';
$string['daysavailable'] = 'Egun eskuragarriak';
$string['decimaldigits'] = 'Dezimal kopurua kalifikazioetan';
$string['decimalplaces'] = 'Hamartar-kopurua kalifikazioetan';
$string['decimalplaces_help'] = 'Saio bakoitzaren kalifikazioan zenbat puntu hamartar agertzea nahi duzun aukera dezakezu. Bakarrik hartuko da kontuan kalifikazioa erakusteko unean, ez ordea kalifikazioa databasean gordetzean edo barne kalkuloak egiterakoan. Eragiketa hauek zehaztasunez egingo dira.';
$string['decimalplacesquestion'] = 'Hamartar-kopurua galderen kalifikazioetan';
$string['decimalplacesquestion_help'] = 'Ezarpen honek zehazten du, galdera bakoitzaren kalifikazioetan, koma ondoren erakutsiko den digitu-kopurua.';
$string['decimalpoints'] = 'Puntu hamartarrak';
$string['default'] = 'Lehenetsia';
$string['defaultgrade'] = 'Aurrez ezarritako galdera-kalifikazioa';
$string['defaultinfo'] = 'Galderetarako lehenetsitako kategoria.';
$string['delay1'] = 'Lehen eta bigarren saiakeren arteko denbora-tartea';
$string['delay1st2nd'] = 'Behartutako denbora-tartea 1. eta 2. saiakeren artean.';
$string['delay1st2nd_help'] = '<p>Denbora-tartea ezartzen baduzu, ikasleak itxaron egin beharko du bigarren saiakera egin ahal izateko.</p>';
$string['delay2'] = 'Ondorengo saiakeren arteko denbora-tartea';
$string['delaylater'] = 'Behartutako denbora-tartea ondorengo saiakeren artean.';
$string['delaylater_help'] = '<p>Hemen denbora-tartea ezartzen baduzu, ikasleak itxaron egin beharko du hirugarren eta hurrengo saiakerak egin ahal izateko.</p>';
$string['deleteattemptcheck'] = 'Ziur al zaude erabat ezabatu nahi dituzula saiakerok?';
$string['deleteselected'] = 'Aukeratutakoa ezabatu';
$string['deletingquestionattempts'] = 'Galderaren saiakerak ezabatzen';
$string['description'] = 'Deskribapena';
$string['disabled'] = 'Desgaituta';
$string['displayoptions'] = 'Aukerak erakutsi';
$string['donotuseautosave'] = 'Ez erabili automatikoki gordetzea';
$string['download'] = 'Klikatu esportatutako kategoria-fitxategia deskargatzeko';
$string['downloadextra'] = '(fitxategia ikastaroko fitxategien eremuko backupdata/quiz karpetan ere gordetzen da)';
$string['duplicateresponse'] = 'Orain gutxi antzeko erantzun bat eman duzu eta, beraz, bidalketa hau ez da kontuan hartuko.';
$string['eachattemptbuildsonthelast'] = 'Saiakera bakoitza azkenengoan oinarritzen da';
$string['eachattemptbuildsonthelast_help'] = '<p>Saiakera bat baino gehiago baimentzen bada, eta <b>Bai</b> hautatzen bada, saiakera berri bakoitzean aurrekoaren emaitza agertuko da. Honek galderari erantzutea
ahalbidetzen du saiakera batzuk eginez.</p>
<p>Saiakera bakoitzean aurreko erantzuna ez erakusteko, <b>Ez</b> aukeratu behar duzu.</p>';
$string['editcategories'] = 'Kategoriak editatu';
$string['editcategory'] = 'Kategoria editatu';
$string['editcatquestions'] = 'Kategoriako galderak editatu';
$string['editingquestion'] = 'Galdera bat editatzen';
$string['editingquiz'] = 'Galdetegia editatzen';
$string['editingquiz_help'] = 'Galdetegia sortzean, honako hauek dira oinarrizko konzteptuak:

* Galdetegia, galderak dituena orri batean edo gehiagotan
* Galdera-bankua, galdera guztien kopiak gordetzen dituena, kategoriaka sailkatuta.
* Ausazko galderak: galdetegiari erantzuten dioten bakoitzean, ikasleei galdera ezberdinak agertzen zaizkie';
$string['editingquizx'] = 'Galdetegia editatzen: {$a}';
$string['editoverride'] = 'Editatu baliogabetzea';
$string['editqcats'] = 'Editatu galdera-kategoriak';
$string['editquestions'] = 'Galderak editatu';
$string['editquiz'] = 'Galdetegia editatu';
$string['editquizquestions'] = 'Editatu galdetegiko galderak';
$string['emailconfirmbody'] = 'Kaixo {$a->username},

Eskerrik asko \'{$a->coursename}\' ikastaroko \'{$a->quizname}\' galdetegiari erantzun izanagatik {$a->submissiontime} denbora-tartean.

Mezu honen bidez zure erantzunak jaso ditugula ziurtatu nahi dizugu.

Ondoko helbidean duzu galdetegia {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Eskerrik asko \'{$a->quizname}\' galdetegiari erantzun izanagatik';
$string['emailconfirmsubject'] = 'Bidalketaren berrespena: {$a->quizname}';
$string['emailnotifybody'] = 'Kaixo {$a->username},

{$a->studentname} -k \'{$a->quizname}\' ({$a->quizurl}) galdetegia osatu du \'{$a->coursename}\' ikastaroan

Saiakera hau hemen {$a->quizreviewurl} berrikusi ahal duzu.';
$string['emailnotifysmall'] = '{$a->studentname}-(e)k {$a->quizname} osatu du. Ikusi {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} -(e)k {$a->quizname} osatu du';
$string['emailoverduebody'] = '{$a->studentname} agurgarria,

Saiakera bat hasi zenuen \'{$a->coursename}\' ikastaroko \'{$a->quizname}\' galdetegian, baina ez duzu bidalketa egin. Bidalita egon beharko litzateke {$a->attemptduedate}-rako.

Oraindik bidali nahi baduzu, mesedez joan {$a->attemptsummaryurl}-ra eta klik egin bidalketa botoian. {$a->attemptgraceend} baino lehen egiten ez baduzu, zure saiakera ez da aintzat hartuko.';
$string['emailoverduesmall'] = 'Ez duzu bidali zure saiakera {$a->quizname} galdetegian. Oraindik bidali nahi baduzu, mesedez, joan {$a->attemptsummaryurl}-ra {$a->attemptgraceend} baino lehen.';
$string['emailoverduesubject'] = 'Epez kanpoko saiakera:  {$a->quizname}';
$string['empty'] = 'Hutsik';
$string['enabled'] = 'Gaituta';
$string['endtest'] = 'Amaitu saiakera...';
$string['erroraccessingreport'] = 'Ezin duzu txosten hau lortu';
$string['errorinquestion'] = 'Errorea galderan';
$string['errormissingquestion'] = 'Errorea: sistemak {$a} id-a duen galdera galdu du';
$string['errornotnumbers'] = 'Errorea: erantzunak zenbakitan eman behar dira';
$string['errorunexpectedevent'] = 'Espero ez zen errore-kodea ({$a->event}) aurkitu da {{$a->attemptid} saiakerako $a->questionid} galderan.';
$string['essay'] = 'Entsegua';
$string['essayquestions'] = 'Galderak';
$string['eventquizattemptabandoned'] = 'Galdetegi-saiakera bertan behera utzi da';
$string['eventquizattemptstarted'] = 'Galdetegi-saiakera hasi da';
$string['eventquizattemptsubmitted'] = 'Galdetegi-saiakera bidali da';
$string['eventquizattempttimelimitexceeded'] = 'Gainditu egin duzu galdetegiaren saiakeraren denbora-muga';
$string['everynquestions'] = '{$a} galderatik behin';
$string['everyquestion'] = 'Galdera bakoitzean';
$string['everythingon'] = 'Guztia hemen';
$string['export'] = 'Esportatu';
$string['exportcategory'] = 'kategoria esportatu';
$string['exporterror'] = 'Errorea gertatu da esportazio-prozesamenduan';
$string['exportingquestions'] = 'Fitxategiko galderak esportatzen ari dira';
$string['exportname'] = 'Fitxategiaren izena';
$string['exportquestions'] = 'Galderak fitxategi batera esportatu';
$string['extraattemptrestrictions'] = 'Aparteko murrizketak saiakeretarako';
$string['false'] = 'Gezurra';
$string['feedback'] = 'Feedbacka';
$string['feedbackerrorboundaryformat'] = 'Atzera-elikaduraren muga-kalifikazioa ehunekoa edo zenbakia izan behar du. {$a} mugan sartu den balorea ezin da onartu.';
$string['feedbackerrorboundaryoutofrange'] = 'Atzera-elikaduraren muga-kalifikazioak %0 eta %100en artean egon behar du. {$a} mugan sartu den muga ez dago horien artean.';
$string['feedbackerrorjunkinboundary'] = 'Atzera-elikaduraren muga-kalifikazioen atalak hutsunerik gabe bete behar dituzu.';
$string['feedbackerrorjunkinfeedback'] = 'Atzera-elikadura atalak hutsunerik gabe bete behar dituzu.';
$string['feedbackerrororder'] = 'Feedback-aren muga-kalifikazioek ordenatuta joan behar dute, altuenetik hasita. {$a} mugan sartutako balorea ez dago ordenan.';
$string['file'] = 'Fitxategia';
$string['fileformat'] = 'Fitxategiaren formatua';
$string['fillcorrect'] = 'Erantzun zuzena eman';
$string['filloutnumericalanswer'] = 'Gutxienez aukerako erantzun bat eta tolerantzia bat eman behar duzu. Lotutako lehen erantzuna puntuazioa ezartzeko eta feedback-erako erabiliko da. Bukaeran erantzunik gabeko feedback-en bat ematen baduzu beste erantzunekin lotu gabeko erantzunak eman dituzten ikasleei erakutsiko zaie.';
$string['filloutoneanswer'] = 'Gutxienez erantzun posible bat bete behar duzu.  Zuriz utzitako erantzunak ez dira erabiliko. \'*\' erabiliko da komodin gisa beste edozein karakterretarako. Bat datorren lehen erantzuna erabiliko da puntuazioa eta atzera elikadura zehazteko.';
$string['filloutthreequestions'] = 'Hiru galdera bete behar dituzu gutxienez, bakoitza bere erantzunarekin. Erantzun oker gehiago sortzeko erantzunaren eremua bete eta galdera hutsik utzi. Galdera eta erantzuna hutsik duten sarrerak ez dira kontuan hartuko.';
$string['fillouttwochoices'] = 'Gutxienez bi aukera bete behar dituzu. Hutsik utzitako erantzunak ez dira erabiliko.';
$string['finishattemptdots'] = 'Amaitu saiakera...';
$string['finishreview'] = 'Berrikusketa amaitu';
$string['forceregeneration'] = 'Birsorkuntza behartu';
$string['formatnotfound'] = 'Esportazio/inportazio {$a} formatua ez da aurkitzen';
$string['formatnotimplemented'] = 'Formatu hau ez da behar bezala inplementatu. Mesedez, bidali errore-mezua.';
$string['formulaerror'] = 'Erroreak formulan!';
$string['fractionsaddwrong'] = 'Aukeratu dituzun gradu positiboak gehituta ez da iristen %100ra. <br/>{$a}%ra soilik iristen da.<br/> Nahi al duzu atzera jo eta galdera hau egokitu?';
$string['fractionsnomax'] = 'Erantzunetako batek %100 izan beharko luke, horrela<br/>erantzun honentzat gehienezko nota lortzea posible izan dadin.<br/>Atzera bueltatu nahi duzu arazoa konpontzeko?';
$string['fromfile'] = 'fitxategi honetatik:';
$string['functiondisabledbysecuremode'] = 'Funtzionalitate hau une honetan desgaituta dago';
$string['generalfeedback'] = 'Feedback orokorra';
$string['generalfeedback_help'] = '<p>Galderen feedback orokorra galderari erantzun ondoren ikasleei
erakutsiko zaien testua da. Galdera-mota eta ikaslearen erantzunaren
araberako feedback-ean ez bezala, feedback orokorrean testu bera
erakutsiko zaie ikasle guztiei.</p>

<p>Ikasleei feedback orokorra noiz erakutsiko zaien kontrola dezakezu
"Berrikusteko aukera:"ko laukitxoan erabilita galdetegia editatzeko
formularioan.</p>

<p>Aztertzen ari zaren gaiari buruzko aurrezagutzak emateko erabil
dezakezu feedback orokorra. Edo informazio gehiago lortzeko estekaren bat
eskaintzeko, galderak ulertzen ez badituzte.</p>';
$string['graceperiod'] = 'Bidalketaren graziazko epea';
$string['graceperiod_desc'] = 'Epea iraungitzen denean egin beharrekoa  \'Bidalketa berrietarako graziazko epea eman baina ez onartu aldaketarik emandako erantzunetan\' aukeran ezarrita badago, emandako aparteko denborarako balio lehenetsia, segundutan.';
$string['graceperiod_help'] = 'Epea iraungitzen denean egin beharrekoa  \'Bidalketa berrietarako graziazko epea eman baina ez onartu aldaketarik emandako erantzunetan\' aukeran ezarrita badago, emandako aparteko denbora.';
$string['graceperiodmin'] = 'Bidalketa ixteko graziazko epea';
$string['graceperiodmin_desc'] = 'Arazo bat gerta daiteke galdetegia ixterakoan. Alde batetik, ikasleei utzi nahi diegu lanean azkeneko segundua arte eta kronometro bati esker, galdetegia automatikoki bidaliko da denbora agortzen denean. Beste aldetik, zerbitzarian gainkarga gerta daiteke eta denbora tarte bat beharko du erantzunak prozesatzeko. Beraz, denbora amaitu ondoren, erantzunak onartuko dira segundu-kopuru honetan eta zerbitzaria motela izateak ez dio inori kalte egingo. Dena dela, ikasleek tranpa egin lezakete eta segundu hauetan galdetegia bidali. Erabaki zenbateko tarte gehigarria emango duzun zure zerbitzariak galdetegietan emandako errendimenduaren baitan.';
$string['graceperiodtoosmall'] = 'Graziazko epeak {$a}-(e)k baino handiagoa izan behar du.';
$string['grade'] = 'Nota';
$string['gradeall'] = 'Dena kalifikatu';
$string['gradeaverage'] = 'Batez besteko kalifikazioa';
$string['gradeboundary'] = 'Gehienezko kalifikazioa';
$string['gradeessays'] = 'Entseguak kalifikatu';
$string['gradehighest'] = 'Notarik altuena';
$string['grademethod'] = 'Kalifikazio-metodoa';
$string['grademethod_help'] = 'Saiakera bat baino gehiago baimentzen bada, ikaslearen amaierako nota kalkulatzeko
modu batzuk daude saiakera bakoitzaren notak erabiliz.

* Kalifikaziorik altuena
* Batez besteko kalifikazioa
* Lehen kalifikazioa (gainerako saiakera guztiak ez dira kontuan hartzen)
* Azken kalifikazioa (gainerako saiakera guztiak ez dira kontuan hartzen)';
$string['gradesdeleted'] = 'Galdetegiaren kalifikazioak ezabatu dira';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Bidalketa honetarako puntuak: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Aurretiko kenketak eginda <strong>{$a->cur}/{$a->max}</strong> da honen emaitza.';
$string['gradingdetailspenalty'] = 'Bidalketa honek {$a}-ko kenketa ekarri du.';
$string['gradingdetailszeropenalty'] = 'Bidalketa honek ez dizu kenketarik ekarri.';
$string['gradingmethod'] = 'Kalifikazio-metodoa: {$a}';
$string['groupoverrides'] = 'Talde-baliogabetzeak';
$string['groupsnone'] = 'Ez dago talderik ikastaro honetan';
$string['guestsno'] = 'Barkatu, baina bisitariek ezin dituzte galdetegiak ikusi edo egin';
$string['hidebreaks'] = 'Ezkutatu orri-jauziak';
$string['hidereordertool'] = 'Berrantolaketarako tresna ezkutatu';
$string['history'] = 'Ebazpenen historiala:';
$string['howquestionsbehave_desc'] = 'Galderek galdetegietan duten jokaerarako lehenetsitako ezarpena.';
$string['imagedisplay'] = 'Erakutsi beharreko irudia';
$string['import'] = 'Inportatu';
$string['importcategory'] = 'kategoria inportatu';
$string['importerror'] = 'Errorea gertatu da inportazio-prozesamenduan';
$string['importfilearea'] = '...ikastaroaren fitxategietan dagoen fitxategi bat inportatu';
$string['importfileupload'] = 'Igotako fitxategitik inportatu';
$string['importfromthisfile'] = 'Fitxategi honetatik inportatu';
$string['import_help'] = 'Funtzionalitate honen bidez, galderak esporta eta inporta ditzakezu kanpoko fitxategien bitartez.

Zure fitxategiak ascii ez diren karaktereak baditu, UTF-8 kodifikazioa erabili beharko du. Arreta berezia eman Microsoft Office aplikazioekin sortutako fitxategiei, kodifikazio berezia erabili ohi dutenez, ez baitira ondo inportatuko.

Inportazio eta esportazio-formatuak pluginen bidez tratatzen dira. Moduluak eta pluginak izeneko datu-basean formatu gehiago egon daitezke.';
$string['importingquestions'] = 'Fitxategitik {$a} galdera inportatzen';
$string['importmax10error'] = 'Galderan errore bat dago. Ezin duzu hamar erantzun baino gehiago izan.';
$string['importmaxerror'] = 'Galderan errore bat dago. Erantzun gehiegi dago.';
$string['importquestions'] = 'Galderak fitxategi batetik inportatu';
$string['inactiveoverridehelp'] = '* Ikasleak ez du rol edo talde egokirik galdetegi honi erantzuteko';
$string['incorrect'] = 'Ez zuzena';
$string['indivresp'] = 'Elementu bakoitzari norberak emandako erantzunak';
$string['info'] = 'Informazioa';
$string['infoshort'] = 'i';
$string['inprogress'] = 'Ari da';
$string['introduction'] = 'Deskribapena';
$string['invalidattemptid'] = 'Saiakera ID hori ez dago';
$string['invalidcategory'] = 'Kategoriaren IDa baliogabea da';
$string['invalidnumericanswer'] = 'Zure erantzun bat ez da zenbaki onargarria';
$string['invalidnumerictolerance'] = 'Zure tolerantzia bat ez da zenbaki onargarria';
$string['invalidoverrideid'] = 'Baliogabetze id baliogabea';
$string['invalidquestionid'] = 'Galderaren id baliogabea';
$string['invalidquizid'] = 'Galdetegiaren ID baliogabea';
$string['invalidsource'] = 'Jatorria ez da onargarria';
$string['invalidsourcetype'] = 'Jatorri-mota ez onargarria';
$string['invalidstateid'] = 'Egoeraren id baliogabea';
$string['lastanswer'] = 'Zure azken erantzuna izan zen';
$string['layout'] = 'Diseinua';
$string['layoutasshown'] = 'Orriaren diseinua ikusten den bezala.';
$string['layoutasshownwithpages'] = 'Orriaren diseinua erakusten modukoa. <small>(Automatikoki orri berria {$a} galdera bakoitzeko.)</small>';
$string['layoutshuffledandpaged'] = 'Ausaz nahastutako galderak, orriko {$a} galderarekin.';
$string['layoutshuffledsinglepage'] = 'Ausaz nahastutako galderak, guztiak orri batean.';
$string['link'] = 'Esteka';
$string['listitems'] = 'Galdetegiaren elementuak zerrendatzen';
$string['literal'] = 'literal';
$string['loadingquestionsfailed'] = 'Kale egin du galderak kargatzean: {$a}';
$string['makecopy'] = 'Gorde galdera berri gisa';
$string['managetypes'] = 'Galdera eta zerbitzari-motak kudeatu';
$string['manualgrading'] = 'Kalifikazioa';
$string['mark'] = 'Bidali';
$string['markall'] = 'Orria bidali';
$string['marks'] = 'Puntuak';
$string['marks_help'] = 'Zenbakizko kalifikazioak galdera bakoitzerako eta saiakeraren kalifikazio orokorrerako.';
$string['match'] = 'Enuntziatuak lotu';
$string['matchanswer'] = 'Lotutako erantzuna';
$string['matchanswerno'] = 'Lotutako erantzuna {$a}';
$string['max'] = 'Gehienez';
$string['messageprovider:attempt_overdue'] = 'Abisatu zure galdetegiaren saiakera epez kanpo geratzen denean.';
$string['messageprovider:confirmation'] = 'Galdetegiari erantzun izanaren baieztapena';
$string['messageprovider:submission'] = 'Galdetegi-bidalketen jakinarazpena';
$string['min'] = 'Gutxienez';
$string['minutes'] = 'Minutu(ak)';
$string['missingcorrectanswer'] = 'Erantzun zuzena zehaztu behar';
$string['missingitemtypename'] = 'Izena falta da';
$string['missingquestion'] = 'Itxuraz, galdera hau dagoeneko ez da existitzen';
$string['modulename'] = 'Galdetegia';
$string['modulename_help'] = 'Galdetegiari esker, irakasleak hainbat motatako galderek (aukera anitzekoak, egia/gezurra, entzuntziatuak lotu,...) osatutako galdetegiak diseinatu eta pasatu ahal ditu.

Irakasleak galdetegian egin daitekeen saiakera-kopurua ezar dezake, galderak nahastuz edo galderak galdera-bankutik ausaz aukeratuz. Denbora muga bat ere ezar daiteke.

Ahalegin bakoitza automatikoki ebaluatzen da, entsegu motako galderak izan ezik, eta kalifikazioa kalifikazio-liburuan gordetzen da.

Irakasleak aukeran du iruzkinak egin eta erantzun zuzenak erakustea.

Galdetegiak erabil daitezke

* Ikastaroko azterketak egiteko
* Test txikien moduan irakurketa zereginetan edo klase-amaieretan
* Azterketarako entrenamendu bezala, aurreko azterketen galderak erabiliz
* Errendimenduaren berehalako feedbacka lortzeko
* Auto-ebaluaziorako';
$string['modulenameplural'] = 'Galdetegiak';
$string['moveselectedonpage'] = 'Aukeratutako galderak orri honetara mugitu: {$a}';
$string['multichoice'] = 'Aukera anitza';
$string['multipleanswers'] = 'Gutxienez erantzun bat aukeratu';
$string['multiplier'] = 'Biderkatzailea';
$string['mustbesubmittedby'] = 'Saiakera hau {$a}-(e)k bidali behar du.';
$string['name'] = 'Izena';
$string['navmethod'] = 'Nabigazio-metodoa';
$string['navmethod_free'] = 'Librea';
$string['navmethod_help'] = 'Nabigazio sekuentziala gaituta dagoenean ikasleek galdetegiaren ordena jarraitu behar dute, eta ezingo dute aurreko orrira itzuli edo hurrengora joan.';
$string['navmethod_seq'] = 'Sekuentziala';
$string['navnojswarning'] = 'Kontuz: esteka horrek ez ditu gordeko zure erantzunak. Erabili hurrengoa botoia orriaren beheko aldean.';
$string['neverallononepage'] = 'Inoiz ez, orri guztiak orri batean.';
$string['newattemptfail'] = 'Errorea: ezin izan da beste saiakera bat hasi galdetegian';
$string['newpage'] = 'Orri berria';
$string['newpageevery'] = 'Orri berria automatikoki hasi';
$string['newpage_help'] = '<p>Galdetegi luzeenetan zentzuzkoa izan daiteke galdetegia hainbat orritan jartzea, orri bakoitzeko galdera-kopurua mugatuta. Galdetegiari galderak gehitzerakoan, orri-jauziak jarriko dira, hemen
zehaztutakoaren arabera. Dena den, orri-jauziak eskuz alda daitezke gero, edizio-menuan.</p>';
$string['noanswers'] = 'Ez duzu erantzunik aukeratu!';
$string['noattempts'] = 'Galdetegi honetan ez da saiakerarik egin';
$string['noattemptsfound'] = 'Ez da saiakerarik aurkitu.';
$string['noattemptstoshow'] = 'Ez dago erakusteko saiakerarik';
$string['nocategory'] = 'Kategoria ez zuzena edo zehaztu gabea';
$string['noclose'] = 'Ez dago ixteko datarik';
$string['nocommentsyet'] = 'Oraindik ez dago iruzkinik';
$string['noconnection'] = 'Oraindik ez dago galdera hau prozesa dezakeen web-zerbitzuarekiko konexiorik. Mesedez, jarri harremanetan zure administratzailearekin.';
$string['nodataset'] = 'Ezer ez - ez da komodina';
$string['nodatasubmitted'] = 'Ez da daturik bidali.';
$string['noessayquestionsfound'] = 'Ez da aurkitu eskuz kalifikatutako galderarik';
$string['nogradewarning'] = 'Galdetegi honek ez du kalifikaziorik, beraz, ezin duzu ezarri kalifikazioen araberako feedbacka.';
$string['nomoreattempts'] = 'Ezin da saiakera gehiago egin';
$string['none'] = 'Bat ere ez';
$string['noopen'] = 'Ez dago zabaltzeko datarik';
$string['nooverridedata'] = 'Gutxienez, galdetegiaren ezarpen bat zuzendu behar duzu.';
$string['nopossibledatasets'] = 'Datu-multzo erabilgarririk ez';
$string['noquestionintext'] = 'Testuak ez du erantzundun galderarik';
$string['noquestions'] = 'Ez da galderarik gehitu oraindik';
$string['noquestionsfound'] = 'Ez da galderarik aurkitu';
$string['noquestionsinquiz'] = 'ez dago galderarik galdetegi honetan.';
$string['noquestionsnotinuse'] = 'Ausazko galdera hau ez da erabili, bere kategoria hutsik dago-eta.';
$string['noquestionsonpage'] = 'Orri hutsa';
$string['noresponse'] = 'Ebazpenik ez';
$string['noreview'] = 'Ez duzu galdetegi hau berrikusteko baimenik';
$string['noreviewattempt'] = 'Ez duzu saiakera hau berrikusteko baimenik.';
$string['noreviewshort'] = 'Ez dago baimenduta';
$string['noreviewuntil'] = '{$a} arte ez duzu galdetegi hau berrikusteko baimenik';
$string['noreviewuntilshort'] = 'Eskura: {$a}';
$string['noscript'] = 'JavaScripta gaituta egon behar aurrera jarraitzeko';
$string['notavailabletostudents'] = 'Oharra: zure ikasleek ezin dute eskuratu orain galdetegi hau';
$string['notenoughrandomquestions'] = 'Ez dago behar adina galdera {$a->category} kategorian {$a->name} ({$a->id}) galdera sortzeko.';
$string['notenoughsubquestions'] = 'Azpigaldera nahikorik ez duzu definitu!<br />Atzera joan nahi duzu arazoa konpontzeko?';
$string['notimedependentitems'] = 'Une honetan Galdetegia moduluak ez du onartzen denbora mugatuko itemik. Horren ordez, ezar ezazu galdetegi osorako denbora muga. Beste item bat aukeratu nahi duzu ala oraingoa erabili?';
$string['notyetgraded'] = 'Ez da oraindik kalifikatu';
$string['notyetviewed'] = 'Ez da oraindik ikusi';
$string['notyourattempt'] = 'Hau ez da zure saiakera!';
$string['noview'] = 'Identifikatutako erabiltzaileak ez du baimenik galdetegi hau ikusteko.';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} egin du {$a->attemptnum} saiakera';
$string['numattemptsmade'] = 'Galdetegiari erantzuteko {$a}  saiakera';
$string['numberabbr'] = '#';
$string['numerical'] = 'Zenbakizkoa';
$string['numquestionsx'] = 'Galderak: {$a}';
$string['oneminute'] = 'Minutu bat';
$string['onlyteachersexport'] = 'Irakasleek bakarrik esporta ditzakete galderak';
$string['onlyteachersimport'] = 'Edizio baimema duten irakasleek bakarrik inporta ditzakete galderak';
$string['onthispage'] = 'Orri hau';
$string['open'] = 'Erantzunik gabe';
$string['openclosedatesupdated'] = 'Galdetegia zabaltzeko eta ixteko datak eguneratuta';
$string['optional'] = 'aukerakoa';
$string['orderandpaging'] = 'Ordenatu eta orrikatu';
$string['orderandpaging_help'] = 'Galderen aldamenean dauden 10, 20, 30... zenbakiek galderen ordena adierazten dute. Zenbakiak hamarnaka igotzen dira, galdera berriak tartekatu behar badira, lekua izateko. Galderak berrantolatu behar badira, sakatu "Galderak berrantolatu" botoia.

Orri-jauziak ezartzeko galdera jakin baten ondoren, galderen aldamenean dauden karratutxoak markatu, eta klik egin "Gehitu beste orri batzuk aukeratutako galderen ondoren" botoian.

Galderak orri-kopuru jakin baten artean banatzeko, "Berriz orrikatu" botoian klikatu eta aukeratu orri bakoitzeko nahi den galdera-kopurua.';
$string['orderingquiz'] = 'Ordenatu eta orrikatu';
$string['orderingquizx'] = 'Ordenatu eta orrikatu: {$a}';
$string['outcomesadvanced'] = 'Helburuak ezarpen aurreratuak dira';
$string['outof'] = '{$a->grade} eta gehienez {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} eta gehienez {$a->maxgrade} (%{$a->percent})';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Feedback orokorra';
$string['overallfeedback_help'] = '<p>Feedback orokorra galdetegiaren saiakera bat osatu
ondoren ikasleari erakutsiko zaion testua da. Erakutsitako testua
ikasleak lortutako kalifikazioaren araberakoa izan daiteke.</p>

<p>Adibidez, hau sartzen baduzu:</p>

<p>Muga-kalifikazioa: 100%<br />
Feedback-a: Oso ondo<br />
Muga-kalifikazioa: 40%<br />
Feedback-a: Asteburu honetan birpasatu egin beharko duzu<br />
...<br />
Muga-kalifikazioa: 0%</p>

<p>%100 eta %40 arteko kalifikazioa lortzen duen ikasleak "Oso ondo"
mezua ikusiko du, eta %39,99 eta %0 arteko kalifikazioa lortzen duenak,
berriz, beste mezua ikusiko du. Horrela, muga-kalifikazioek kalifikazio-mailak
ezartzen dituzte, eta bakoitzaren feedback-katea dagokion mailako puntuazioetarako
erakutsiko da.</p>

<p>Muga-kalifikazioak ehunekotan ezar daitezke, "% 31.41%" adibidez, edo
zenbaki batekin, "7" adibidez. Zure galdetegiak 10ekoa bada, 7ko muga-kalifikazioak 10etik 7 edo gehiago esan nahi du.</p>';
$string['overdue'] = 'Atzeratuta';
$string['overduehandling'] = 'Epea iraungitzen denean';
$string['overduehandlingautoabandon'] = 'Saiakerak denbora agortu aurretik bidali behar dira; bestela, ez dira aintzat hartuko';
$string['overduehandlingautosubmit'] = 'Saiakera irekiak automatikoki bidaltzen dira denbora agortzean.';
$string['overduehandling_desc'] = 'Ikasle batek galdetegiari garaiz erantzuten ez badio, gertatu beharko litzatekeenerako lehenetsitako balioa.';
$string['overduehandlinggraceperiod'] = 'Hasitako saiakerak bidaltzeko epe gehigarria dago denbora bukatzean, baina epe horretan ezin da galdera gehiago erantzun';
$string['overduehandling_help'] = 'Ezarpen honek kontrolatzen du zer gertatzen den  ikasle batek bidalketa egitea lortzen ez badu denbora agortu aurretik. Momentu horretan ikaslea saiakeran lanean ari bada, atzerako kontaketa kronometroak automatikoki bidaliko du saiakera, baina ikaslea plataformatik atera bada, ezarpen honek kontrolatzen du zer gertatuko den.';
$string['overduemustbesubmittedby'] = 'Saiakera hau epez kanpo dago. Dagoeneko bidalita egon beharko luke. Galdetegia kalifikatua izatea nahi baduzu, {$a}-rako bidali behar duzu. Data horretarako bidaltzen ez baduzu bidaltzen, saiakera hau ez da aintzat hartuko.';
$string['override'] = 'Baliogabetu';
$string['overridedeletegroupsure'] = 'Ziur al zaude baliogabetze hau {$a} talderako ezabatu nahi duzula?';
$string['overridedeleteusersure'] = 'Ziur al zaude baliogabetze hau {$a} erabiltzailearentzat ezabatu nahi duzula?';
$string['overridegroup'] = 'Baliogabetu taldea';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Baliogabetzeak';
$string['overrideuser'] = 'Baliogabetu erabiltzailea';
$string['overrideusereventname'] = '{$a->quiz} - Baliogabetu';
$string['page-mod-quiz-attempt'] = 'Galdetegiaren saiakera-orria';
$string['page-mod-quiz-edit'] = 'Editatu galdetegiaren orria';
$string['page-mod-quiz-report'] = 'Edozein galdetegi-txosten orri';
$string['page-mod-quiz-review'] = 'Berrikusi galdetegiaren saiakera-orria';
$string['page-mod-quiz-summary'] = 'Galdetegiaren saiakeraren laburpen-orria';
$string['page-mod-quiz-view'] = 'Galdetegiaren informazio-orria';
$string['page-mod-quiz-x'] = 'Galdetegiaren edozein orri';
$string['pagesize'] = 'Orriaren tamaina';
$string['parent'] = 'Goragokoa';
$string['parentcategory'] = 'Goragoko kategoria';
$string['parsingquestions'] = 'Inportazio-fitxategiko galderak aztertzen';
$string['partiallycorrect'] = 'Zuzena zati batean';
$string['penalty'] = 'Penalizazioa';
$string['penaltyscheme'] = 'Penalizazioak ezarri';
$string['penaltyscheme_help'] = '<p>Galdetegia moldagarria bada eta ikasleak oker erantzuten badu, berriz saiatzeko aukera izango du. Kasu honetan, beharbada, erantzun oker bakoitzagatik zigorra ezarri nahiko duzu: galderaren azken puntuazioa jaistea, adibidez. Galdera bakoitzak bere zigorra du; penalizazio hori galdera idazten edo editatzen denean zehazten da.</p>

<p>Ezarpen horrek galdetegia moldagarrietan bakarrik du eragina.</p>';
$string['percentcorrect'] = 'Ehuneko zuzena';
$string['pleaseclose'] = 'Zure eskaria prozesatu da. Orain leihoa itxi dezakezu';
$string['pluginadministration'] = 'Galdetegiaren kudeaketa';
$string['pluginname'] = 'Galdetegia';
$string['popup'] = 'Erakutsi galdetegia modu seguruan';
$string['popupblockerwarning'] = 'Galdetegiaren zati hau modu seguruan dago eta horrek esan nahi du leiho seguru batean osatu behar duzula galdetegia. Mesedez, desaktibatu irekitzen diren leihoen blokeoa. Eskerrik asko.';
$string['popupnotice'] = 'Ikasleek galdetegi hau modu seguruan ikusiko dute';
$string['preprocesserror'] = 'Errorea gertatu da aurre-prozesamenduan!';
$string['preview'] = 'Aurreikusi';
$string['previewquestion'] = 'Galdera aurreikusi';
$string['previewquiz'] = '{$a} aurreikusi';
$string['previewquiznow'] = 'Galdetegia orain aurreikusi';
$string['previous'] = 'Aurreko egoera';
$string['publish'] = 'Argitaratu';
$string['publishedit'] = 'Argitaratzeko erabaki den ikastaroan baimena behar duzu izan kategoria honetan galderak editatu edo gehitzeko';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'izena';
$string['qti'] = 'IMS QTI formatua';
$string['qtypename'] = 'mota, izena';
$string['question'] = 'Galdera';
$string['questionbankcontents'] = 'Galdera-bankuaren edukiak';
$string['questionbankmanagement'] = 'Galdera-bankuaren kudeaketa';
$string['questionbehaviour'] = 'Galderen jokaera';
$string['questioncats'] = 'Galdera-kategoriak';
$string['questiondeleted'] = 'Galdera hau ezabatu egin da. Mesedez, jarri harremanetan irakaslearekin';
$string['questioninuse'] = '\'{$a->questionname}\' galdera oraintxe erabiltzen ari da hemen: <br />{$a->quiznames}<br /> Galdera ez da ezabatuko galdetegietatik baina bai kategoria-zerrendatik.';
$string['questionmissing'] = 'Saio honetarako galdera falta da';
$string['questionname'] = 'Galderaren izena';
$string['questionnonav'] = '<span class="accesshide">Galdera</span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informazioa </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = '{$a} galdera ez da aurkitu datu-basean.';
$string['questionorder'] = 'Galderaren ordena';
$string['questionposition'] = 'Posizio berria {$a} galderarentzat';
$string['questions'] = 'Galderak';
$string['questionsinclhidden'] = 'Galderak (ezkutukoak barne)';
$string['questionsinthisquiz'] = 'Galderak galdetegi honetan';
$string['questionsperpage'] = 'Galderak orriko';
$string['questionsperpageselected'] = 'Orri bakoitzeko galdera-kopurua finkatu da, beraz, orrikatzea finkatua dago. Ondorioz, orrikatze-kontrolak ezgaitu dira. {$a}-n alda dezakezu hau.';
$string['questionsperpagex'] = 'Galderak orriko: {$a}';
$string['questiontext'] = 'Galderaren testua';
$string['questiontextisempty'] = '[Galderaren testua hutsik]';
$string['questiontype'] = '{$a} motako galdera';
$string['questiontypesetupoptions'] = 'Galdera motetarako aukerak';
$string['quiz:addinstance'] = 'Gehitu beste galdetegi bat';
$string['quiz:attempt'] = 'Galdetegiei erantzun';
$string['quizavailable'] = 'Galdetegia eskuragarri egongo da {$a} arte';
$string['quizclose'] = 'Galdetegia itxi';
$string['quizclosed'] = 'Galdetegi hau {$a}(e)n itxi zen';
$string['quizcloses'] = 'Galdetegia itxiko da';
$string['quizcloseson'] = 'Galdetegi hau {$a} -n itxiko da';
$string['quiz:deleteattempts'] = 'Galdetegiaren saiakerak ezabatu';
$string['quiz:emailconfirmsubmission'] = 'Jaso e-postako berreste-mezua bidaltzean';
$string['quiz:emailnotifysubmission'] = 'Jaso e-postako jakinarazpen-mezua saiakera bat bidaltzen denean';
$string['quiz:emailwarnoverdue'] = 'Jakinarazpen-mezu bat jaso saiakera batek epea gainditzen duenean eta bidaltzera behartzen denean.';
$string['quiz:grade'] = 'Galdetegiak eskuz kalifikatu';
$string['quiz:ignoretimelimits'] = 'Galdetegien denbora-mugari jaramonik ez egin';
$string['quizisclosed'] = 'Galdetegi hau itxita dago';
$string['quizisclosedwillopen'] = 'Galdetegia itxita dago ({$a} datan zabalduko da)';
$string['quizisopen'] = 'Galdetegi hau zabalik dago';
$string['quizisopenwillclose'] = 'Galdetegia zabaldu (itxi {$a})';
$string['quiz:manage'] = 'Galdetegiak kudeatu ';
$string['quiz:manageoverrides'] = 'Kudeatu galdetegi-baliogabetzeak';
$string['quiznavigation'] = 'Galdetegiaren nabigazioa';
$string['quizopen'] = 'Galdetegia zabaldu';
$string['quizopenclose'] = 'Galdetegia zabaltzeko eta ixteko datak';
$string['quizopenclose_help'] = 'Ikasleek bakarrik has dezakete bere saiakera(k) zabaltze-unea baino beranduago eta bukatu behar dute itxiera-dataren ondoren.';
$string['quizopened'] = 'Galdetegi hau zabalik dago.';
$string['quizopenedon'] = 'Galdetegi hau {$a} datan zabalduko da';
$string['quizopens'] = 'Galdetegia zabalduko da';
$string['quizopenwillclose'] = 'Galdetegi hau zabalik dago, {$a} datan itxiko da';
$string['quizordernotrandom'] = 'Galdetegiaren ordena ez da ausazkoa';
$string['quizorderrandom'] = 'Galdetegiaren ordena ausazkoa da';
$string['quiz:preview'] = 'Aurreikusi galdetegiak';
$string['quiz:regrade'] = 'Berriz kalifikatu galdetegiaren saiakerak';
$string['quiz:reviewmyattempts'] = 'Berrikusi zeure saiakera';
$string['quizsettings'] = 'Galdetegiaren ezarpenak';
$string['quiztimer'] = 'Galdetegiaren kronometroa';
$string['quiz:view'] = 'Ikusi galdetegiaren informazioa';
$string['quiz:viewreports'] = 'Ikusi galdetegiaren txostenak';
$string['quizwillopen'] = 'Galdetegi hau zabalduko da ondoko datan: {$a}';
$string['random'] = 'Ausazko galdera';
$string['randomcreate'] = 'Ausazko galderak sortu';
$string['randomfromcategory'] = 'Ausazko galdera kategoria honetatik:';
$string['randomfromexistingcategory'] = 'Ausazko galdera existitzen den kategoria batetik';
$string['randomnosubcat'] = 'Galdera kategoria honetatik bakarrik, ez azpikategorietatik.';
$string['randomquestionusinganewcategory'] = 'Ausazko galdera kategiaria berria erabiliz';
$string['randomwithsubcat'] = 'Kategoria honetako galderak eta bere azpikategorietakoak.';
$string['readytosend'] = 'Galdetegi osoa bidaliko duzu nota ezartzeko.  Benetan jarraitu nahi duzu?';
$string['reattemptquiz'] = 'Saiatu berriro galdetegia egiten';
$string['recentlyaddedquestion'] = 'Duela gutxi gehitutako galderak';
$string['recurse'] = 'Gehitu galderak azpikategorietatik ere';
$string['regrade'] = 'Saiakera guztiei nota berriz kalkulatu';
$string['regradecomplete'] = 'Saiakera guztiei nota berriz kalkulatu zaie';
$string['regradecount'] = '{$a->attempt} saiakeratik {$a->changed} aldatu dira';
$string['regradedisplayexplanation'] = 'Birkalifikazioa egin bitartean aldatzen diren saiakerak galderak berikusteko leihorako esteka gisa agertzen dira';
$string['regradenotallowed'] = 'Ez duzu galdetegi hau berriz kalifikatzeko baimenik';
$string['regradingquestion'] = '"{$a}" birkalifikatzen';
$string['regradingquiz'] = '"{$a}" galdetegia berriz kalifikatzen';
$string['remove'] = 'Ezabatu';
$string['removeallquizattempts'] = 'Galdetegiari erantzuteko saiakera guztiak ezabatu';
$string['removeemptypage'] = 'Ezabatu hutsik dagoen orria';
$string['removeselected'] = 'Ezabatu aukeratutakoa';
$string['rename'] = 'Berrizendatu';
$string['renderingserverconnectfailed'] = '{$a} zerbitzariak ezin izan du RQP eskaria prozesatu. Ziurtatu URL-a zuzena dela.';
$string['reorderquestions'] = 'Berrantolatu galderak';
$string['reordertool'] = 'Berrantolaketarako tresna erakutsi';
$string['repaginate'] = 'Orriak berriz eratu orriko {$a} galderarekin';
$string['repaginatecommand'] = 'Berriz orrikatu';
$string['repaginatenow'] = 'Berriz orrikatu orain';
$string['replace'] = 'Ordezkatu';
$string['replacementoptions'] = 'Ordezkatzeko aukerak';
$string['report'] = 'Txostenak';
$string['reportanalysis'] = 'Itemen analisia';
$string['reportattemptsfrom'] = 'Noren saiakerak?';
$string['reportattemptsthatare'] = 'Honelako saiakerak';
$string['reportdisplayoptions'] = 'Erakutsi aukerak';
$string['reportfullstat'] = 'Estatistika zehatzak';
$string['reportmulti_percent'] = 'Ehuneko anitzak';
$string['reportmulti_q_x_student'] = 'Ikasle anitzeko aukerak';
$string['reportmulti_resp'] = 'Norberaren ebazpenak';
$string['reportmustselectstate'] = 'Gutxienez egoera bat aukeratu behar duzu.';
$string['reportnotfound'] = 'Txosten ezezaguna ({$a})';
$string['reportoverview'] = 'Ikuspegi orokorra';
$string['reportregrade'] = 'Saiakerak berriz kalifikatu';
$string['reportresponses'] = 'Zehaztutako ebazpenak';
$string['reports'] = 'Txostenak';
$string['reportshowonly'] = 'Erakutsi saiakerak baino ez';
$string['reportshowonlyfinished'] = 'Erakutsi gehienez amaitutako saiaketa bat erabiltzaileko  ({$a})';
$string['reportsimplestat'] = 'Estatistika oinarrizkoak';
$string['reportusersall'] = 'galdetegiari erantzuten saiatu diren erabiltzaile guztiak';
$string['reportuserswith'] = 'galdetegiari erantzuten saiatu diren matrikulatutako erabiltzaileak';
$string['reportuserswithorwithout'] = 'galdetegiari erantzuten saiatu diren eta saiatu ez diren  matrikulatutako erabiltzaileak';
$string['reportuserswithout'] = 'galdetegiari erantzuten saiatu ez diren matrikulatutako erabiltzaileak';
$string['reportwhattoinclude'] = 'Zer jaso behar du txosten honek?';
$string['requirepassword'] = 'Pasahitza eskatu';
$string['requirepassword_help'] = '<p>Aukerako eremua da.</p>

<p>Pasahitza gehitzen badugu, ikasleek hori bera idatzi beharko dute galdetegiari
erantzun ahal izateko.</p>';
$string['requiresubnet'] = 'Sare-helbidea eskatu';
$string['requiresubnet_help'] = '<p>Aukerako eremua da.</p>

<p>Galdetegia azpisare partikular batean bakarrik egon daiteke eskura, tokiko sare batean (LAN), adibidez; horretarako, IP helbideen zerrenda egin behar dugu, helbideak komekin banatuta.</p>

<p>Hori galdetegia babesteko eta ikasgela edo sare batetik bakarrik erantzuten dela bermatzeko erabil daiteke.</p>

<p>Adibidez:<b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>Hiru zenbaki-mota erabil ditzakegu (ezin ditugu testuan oinarritutako domeinuak erabili; adibidea.com, esaterako):</p>

<ol>
 <li>Ordenagailu bakar bati (edo Proxy) lotutako IP helbide osoak (adibidez: 192.168.10.1).</li>
 <li>Zenbaki horiekin hasten diren edozein sareri lotutako helbide partzialak (esaterako: 192.168).</li>
 <li>CIDR notazioa (adibidez: <b>231.54.211.0/20)</b> azpisareak zehatzago gaitzeko.</li>
</ol>

<p>Zuriuneak ez dira aintzat hartzen.</p>';
$string['response'] = 'Ebazpena';
$string['responses'] = 'Ebazpenak';
$string['results'] = 'Emaitzak';
$string['returnattempt'] = 'Itzuli saiakerara';
$string['reuseifpossible'] = 'Ezabatutakoa berriz erabili';
$string['reverttodefaults'] = 'Berezko galdetegira itzuli';
$string['review'] = 'Birpasatu';
$string['reviewafter'] = 'Utzi birpasatzen galdetegia itxi ondoren';
$string['reviewalways'] = 'Utzi birpasatzen edozein momentutan';
$string['reviewattempt'] = 'Saiakeraren berrikusketa';
$string['reviewbefore'] = 'Utzi birpasatzen galdetegia zabalik dagoela';
$string['reviewclosed'] = 'Galdetegia itxi ondoren';
$string['reviewduring'] = 'Saiakera egin bitartean';
$string['reviewimmediately'] = 'Saiakera bakoitzaren ondoren';
$string['reviewnever'] = 'Ez utzi sekula birpasatzen';
$string['reviewofattempt'] = '{$a} saiakeraren berrikusketa';
$string['reviewofpreview'] = 'Aurrebistaren berrikusketa';
$string['reviewopen'] = 'Beranduago, galdetegia irekita dagoen bitartean';
$string['reviewoptions'] = 'Ikasleek berrikus dezakete';
$string['reviewoptionsheading'] = 'Aukerak berrikusi';
$string['reviewoptionsheading_help'] = 'Aukera hauek kontrolatzen dute erabiltzaileek galdetegi baten saiakera bat berrikustean edo galdetegi baten txostenean ikus dezaketen informazioa.

**Saiakera egin bitartean** aukerak jokaera zehatz batzuetan bakarrik erabiltzen da, \'Interaktiboa hainbat saiakerarekin\' kasuan adibidez, saiakera egin bitartean feedback-ak erakusteko aukera dutelako.

**Saiakera bakoitzaren ondoren** aukerak \'Bidali dena eta bukatu\' sakatu ondorengo bi minutuetan soilik aplikatzen da.

**Beranduago, galdetegia irekita dagoen bitartean** aukerak aurrekoaren ondoren aplikatzen da, galdetegiaren itxiera data heldu arte.

**Galdetegia itxi ondoren** aukera galdetegiaren itxiera data igaro ondoren aplikatzen da. Galdetegiak ez badu itxiera-datarik egoera honetara ez da inoiz heltzen.';
$string['reviewoverallfeedback'] = 'Feedback orokorra';
$string['reviewoverallfeedback_help'] = 'Saiakeraren amaieran emandako feedbacka, ikasleak denera jasotako kalifikazio orokorraren araberakoa.';
$string['reviewresponse'] = 'Ebazpena berrikusi';
$string['reviewresponsetoq'] = 'Ebazpena berrikusi ({$a} galdera)';
$string['reviewthisattempt'] = 'Berrikusi zeure ebazpenak saiakera honetarako';
$string['rqp'] = 'Urrutiko galdera';
$string['rqps'] = 'Urrutiko galderak';
$string['sameasoverall'] = 'Kalifikazio orokorretan erabilitako bera';
$string['save'] = 'Gorde';
$string['saveandedit'] = 'Gorde aldaketak eta editatu galderak';
$string['saveattemptfailed'] = 'Kale egin du oraingo galdetegi-saiakera gordetzeak.';
$string['savedfromdeletedcourse'] = '"{$a}" ezabatuko ikastarotik gordeta';
$string['savegrades'] = 'Kalifikazioak gorde';
$string['savemyanswers'] = 'Gorde nire erantzunak';
$string['savenosubmit'] = 'Gorde bidali gabe';
$string['saveoverrideandstay'] = 'Gorde eta sartu beste baliogabetze bat';
$string['savequiz'] = 'Galdetegi osoa gorde';
$string['saving'] = 'Gordetzen';
$string['savingnewgradeforquestion'] = 'Kalifikazio berria gordetzen id {$a} galderarentzat.';
$string['savingnewmaximumgrade'] = 'Gehienezko kalifikazio berria gordetzen';
$string['score'] = 'Puntuazio gordina';
$string['scores'] = 'Puntuazioak';
$string['select'] = 'Aukeratu';
$string['selectall'] = 'Denak aukeratu';
$string['selectcategory'] = 'Kategoria aukeratu';
$string['selectedattempts'] = 'Aukeratutako saiakerak...';
$string['selectnone'] = 'Guztiak alde batera utzi';
$string['selectquestiontype'] = '-- Aukeratu galdera-mota --';
$string['serveradded'] = 'Zerbitzaria gehituta';
$string['serveridentifier'] = 'Identifikatzailea';
$string['serverinfo'] = 'Zerbitzariaren informazioa';
$string['servers'] = 'Zerbitzariak';
$string['serverurl'] = 'Zerbitzariaren URL-a';
$string['settingsoverrides'] = 'Baliogabetzeen ezarpenak';
$string['shortanswer'] = 'Erantzun laburra';
$string['show'] = 'Erakutsi';
$string['showall'] = 'Galdera guztiak orri batean erakutsi';
$string['showblocks'] = 'Blokeak erakutsi galdetegiari erantzun bitartean';
$string['showblocks_help'] = 'Baietz ipiniz gero, bloke normalak erakutsiko dira galdetegiari erantzun bitartean ';
$string['showbreaks'] = 'Orri-jauzia erakutsi';
$string['showcategorycontents'] = 'Erakutsi kategoriaren edukiak: {$a->arrow}';
$string['showcorrectanswer'] = 'Feedbackean erantzun zuzenak erakutsi?';
$string['showdetailedmarks'] = 'Notaren zehaztasunak erakutsi';
$string['showeachpage'] = 'Erakutsi orri bat aldi bakoitzean';
$string['showfeedback'] = 'Erantzun ondoren feedbacka ikusi nahi?';
$string['showinsecurepopup'] = 'Erabili popup leiho \'seguru\' bat saiakeretan';
$string['showlargeimage'] = 'Irudi handia';
$string['shownoattempts'] = 'Saiakerarik egin ez duten ikasleak erakutsi';
$string['shownoattemptsonly'] = 'Saiakerarik egin ez duten ikasleak baino ez erakutsi';
$string['shownoimage'] = 'Irudirik ez';
$string['showreport'] = 'Erakutsi txostena';
$string['showsmallimage'] = 'Irudi txikia';
$string['showteacherattempts'] = 'Erakutsi irakaslearen saiakerak';
$string['showuserpicture'] = 'Erakutsi erabiltzailearen irudia';
$string['showuserpicture_help'] = 'Gaituz gero, ikaslearen izena eta irudia erakutsiko dira pantailan saiakerak irauten duen bitartean, eta berrikuste-pantailan; horrela, zaindutako azterketa batean zehar, errazagoa izango da egiaztatzea ikaslea bere izenarekin sartu dela.';
$string['shuffle'] = 'Nahastu';
$string['shuffleanswers'] = 'Erantzunak nahastu';
$string['shuffledrandomly'] = 'Ausaz nahastuta';
$string['shufflequestions'] = 'Galderak nahastu';
$string['shufflequestionsselected'] = '"Galderak nahastu" aukera ezarri da, beraz, orriei dagozkien aukera batzuk ez daude gaituta. Nahasteko aukera aldatzeko, {$a}.';
$string['shufflewithin'] = 'Galderen barruan nahastu';
$string['shufflewithin_help'] = '<p>Aukera hau gaituz gero, ikasleak galdetegiari erantzuten dion bakoitzean, galdera bakoitzaren atalak ausaz nahastuko dira. Horretarako, jakina, galdetegiaren ezarpenetan erantzunak nahasteak ere gaituta egon behar du.</p>

<p>Helburua ikasleei elkarri kopiatzea zailago bihurtzea da.</p>

<p>Aukera hau hainbat atal dituzten gelderen kasuan baino ezin da aplikatu, aukera anitzekoetan eta enuntziatuak lotzekoetan, kasu. Lehenengo kasuan, erantzunen ordena nahastuko da egindako aukera &quot;Bai&quot; izan denean. Bigarrenean, erantzunak beti nahasten dira; ezarpen honek zehaztuko du galdera-erantzuna bikoteak ere nahastuko diren ala ez.</p>

<p>Aukera honek ez du ausazko galderekin zerikusirik.</p>';
$string['singleanswer'] = 'Aukeratu erantzun bat';
$string['sortage'] = 'Adinaren arabera ordenatu';
$string['sortalpha'] = 'Izenaren arabera ordenatu';
$string['sortquestionsbyx'] = 'Galderak honen arabera ordenatu: {$a}';
$string['sortsubmit'] = 'Galderak ordenatu';
$string['sorttypealpha'] = 'Motaren, izenaren arabera ordenatu';
$string['specificapathnotonquestion'] = 'Zehaztutako fitxategiaren bide-izena ez dago zehaztutako galderan';
$string['specificquestionnotonquiz'] = 'Zehaztutako galdera ez dago zehaztutako galdetegian';
$string['startagain'] = 'Hasi berriro';
$string['startattempt'] = 'Hasi saiakera';
$string['startedon'] = 'Noiz hasita';
$string['startnewpreview'] = 'Berriz saiatu';
$string['stateabandoned'] = 'Bidali gabeak';
$string['statefinished'] = 'Amaitutakoak';
$string['statefinisheddetails'] = '{$a} bidali da';
$string['stateinprogress'] = 'Egiten ari direnak';
$string['statenotloaded'] = '{$a} galderaren egoera ez da datu-basetik kargatu';
$string['stateoverdue'] = 'Atzeratutakoak';
$string['stateoverduedetails'] = '{$a}-(e)k bidali behar du.';
$string['status'] = 'Egoera';
$string['stoponerror'] = 'Gelditu errorea aurkitzean';
$string['submitallandfinish'] = 'Bidali dena eta bukatu';
$string['subneterror'] = 'Barkatu, baina galdetegi hau blokeatu egin da eta helbide jakin batzuetatik bakarrik egin daiteke. Une honetan zure ordenagailuak ez du baimenik galdetegi hau erabiltzeko.';
$string['subnetnotice'] = 'Galdetegi hau blokeatu egin da eta helbide jakin batzuetatik bakarrik egin daiteke. Zure ordenagailua ez dago baimendutako azpi-sarean. Irakasle gisa, aurreikusi egin al duzu, hala ere.';
$string['subplugintype_quiz'] = 'Txostena';
$string['subplugintype_quizaccess'] = 'Sartzeko araua';
$string['subplugintype_quizaccess_plural'] = 'Sartzeko arauak';
$string['subplugintype_quiz_plural'] = 'Txostenak';
$string['substitutedby'] = 'zerk ordezkatuko duen:';
$string['summaryofattempt'] = 'Saiakeren laburpena';
$string['summaryofattempts'] = 'Orain arteko zure saiakeren laburpena';
$string['temporaryblocked'] = 'Denbora tarte batez ez duzu <br /> galdetegia berriz egiten saiatzeko baimenik. Berriz egin ahal izango duzu:';
$string['theattempt'] = 'Saiakera';
$string['theattempt_help'] = 'Ea ikasleak saiakera berrikus dezakeen ala ez.';
$string['time'] = 'Denbora';
$string['timecompleted'] = 'Osatua';
$string['timedelay'] = 'Ezin duzu galdetegia egin oraindik ez delako igaro nahiko denbora berriz saiatzeko.';
$string['timeleft'] = 'Geratzen den denbora';
$string['timelimit'] = 'Denbora-muga';
$string['timelimitexeeded'] = 'Barkatu, baina denbora-muga gainditu duzu!';
$string['timelimit_help'] = 'Gaituz gero, denbora-muga galdetegiaren hasiera orrian ezartzen da eta atzerako kontaketa kronometroa erakusten da galdetegiaren nabigazio-blokean.';
$string['timelimitmin'] = 'Denbora-muga (minututan)';
$string['timelimitsec'] = 'Denbora-muga (segundutan)';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = 'Denbora amaitu egin da!';
$string['timetaken'] = 'Hartutako denbora';
$string['timing'] = 'Denbora-tartea';
$string['tofile'] = 'fitxategi honetara';
$string['tolerance'] = 'Tolerantzia';
$string['toomanyrandom'] = 'Beharrezko den galdera-kopurua kategoria honek duena baino handiagoa da.';
$string['top'] = 'Gora';
$string['totalmarksx'] = 'Kalifikazioak denera: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Denera {$a} galdera kategorian';
$string['true'] = 'Egia';
$string['truefalse'] = 'Egia/Gezurra';
$string['type'] = 'Mota';
$string['unfinished'] = 'zabalik';
$string['ungraded'] = 'Kalifikatu gabe';
$string['unit'] = 'Unitatea';
$string['unknowntype'] = 'Onartu gabeko galdera-mota {$a} lerroan. Galdera ez da kontuan izango.';
$string['unusedcategorydeleted'] = 'Kategoria hau ezabatu egin da ikastaroa ezabatuta bertako galderak ez zirelako jada erabiltzen.';
$string['updatesettings'] = 'Galdetegiaren ezarpenak eguneratu';
$string['updatingatttemptgrades'] = 'Saiakeren kalifikazioak eguneratzen.';
$string['updatingfinalgrades'] = 'Azken kalifikazioak eguneratzen.';
$string['updatingthegradebook'] = 'Kalifikazio-liburua eguneratzen.';
$string['upgradesure'] = '<div>Zehazki, Galdetegia modulua galdetegiaren tauletan aldaketa handia egingo du eta eguneraketa hau ez da oraindik nahikoa probatu. Jarraitu aurretik egin ezazu, mesedez, datu-basearen taulen segurtasun-kopia.<div>';
$string['upgradingquizattempts'] = 'Galdetegien saiakerak eguneratzen: {$a->done}/{$a->outof} galdetegi (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Galdetegi-saiakera oso zaharrak eguneratzen: {$a->done}/{$a->outof}';
$string['url'] = 'URL-a';
$string['usedcategorymoved'] = 'Kategoria hau gorde eta gunera eraman da. Izan ere, ikastaroa ezabatutakoan, zerbitzariaren beste galdetegi batean/batzuetan erabiltzen ari ziren galderak.';
$string['useroverrides'] = 'Erabiltzaile-baliogabetzeak';
$string['usersnone'] = 'Ez dago ikaslerik galdetegi honetarako sarbidea duenik';
$string['validate'] = 'Balidatu';
$string['viewallanswers'] = '{$a}(e)k osatutako galdetegiak ikusi';
$string['viewallreports'] = '{$a} saiakeren txostenak ikusi';
$string['viewed'] = 'Ikusia';
$string['warningmissingtype'] = '<p><b>Galdera hau oraindik ere zure Moodle-n instalatu ez den motakoa da.<br />Mesedez, adierazi zure kudeatzaileari.</b></p>';
$string['wheregrade'] = 'Non dago nire kalifikazioa?';
$string['wildcard'] = 'Komodina';
$string['windowclosing'] = 'Leiho hau hemendik gutxira itxiko da.';
$string['withsummary'] = 'laburpenaren estatistikekin';
$string['wronguse'] = 'Zuk ezin duzu orri hau horrela erabili';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Galdetegi honi erantzun baino lehen, ikastaro honetan matrikulatu behar duzu';
$string['yourfinalgradeis'] = 'Galdetegi honetan zure azken nota {$a} da.';
