<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'eu', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'instalatzeko zorian';
$string['action'] = 'Ekintza';
$string['actionchoice'] = 'Zer egin nahi duzu \'{$a}\' fitxategiarekin?';
$string['actions'] = 'Ekintzak';
$string['active'] = 'Aktiboa';
$string['activeusers'] = 'Erabiltzaile aktiboak';
$string['activities'] = 'Jarduerak';
$string['activities_help'] = 'Foroak, galdetegiak eta wikiak bezalako jarduerek aukera ematen dute ikastaroan eduki interaktiboak gehitzeko.';
$string['activity'] = 'Jarduera';
$string['activityclipboard'] = 'Jarduera hau mugitzen: {$a}';
$string['activityiscurrentlyhidden'] = 'Barkatu, jarduera hau ezkutuan dago';
$string['activitymodule'] = 'Jarduera-modulua';
$string['activitymodules'] = 'Jarduera-moduluak';
$string['activityreport'] = 'Jardueraren txostena';
$string['activityreports'] = 'Jardueraren txostenak';
$string['activityselect'] = 'Aukeratu jarduera hau beste norabait joateko';
$string['activitysince'] = 'Noiztik martxan: {$a}';
$string['activityweighted'] = 'Erabiltzaileen jardueraren txostenak';
$string['add'] = 'Gehitu';
$string['addactivity'] = 'Gehitu jarduera...';
$string['addactivitytosection'] = 'Gehitu jarduera bat \'{$a}\' atalean';
$string['addadmin'] = 'Kudeatzailea gehitu';
$string['addblock'] = 'Gehitu blokea';
$string['addcomment'] = 'Gehitu iruzkina...';
$string['addcountertousername'] = 'Sortu erabiltzailea erabiltzaile-izenari zenbakia gehituz';
$string['addcreator'] = 'Ikastaro-sortzailea gehitu';
$string['adddots'] = 'Gehitu...';
$string['added'] = '{$a} gehituta';
$string['addedrecip'] = 'Beste hartzaile bat gehituta: {$a}';
$string['addedrecips'] = 'Beste hartzaile batzuk gehituta:s {$a}';
$string['addedtogroup'] = 'Talde honetara gehituta: "{$a}"';
$string['addedtogroupnot'] = 'Talde honetara gehitu gabe: "{$a}"';
$string['addedtogroupnotenrolled'] = 'Talde honetara gehitu gabe: "{$a}"; izan ere, ikastaro honetan izena eman gabe dago.';
$string['addfilehere'] = 'Gehitu fitxategia(k) hemen';
$string['addinganew'] = '{$a} gehitzen';
$string['addinganewto'] = '{$a->what} gehitzen hona: {$a->to}';
$string['addingdatatoexisting'] = 'Datu berriak gehitzen';
$string['additionalnames'] = 'Beste izen batzuk';
$string['addlinkhere'] = 'Gehitu esteka hemen';
$string['addnewcategory'] = 'Gehitu beste kategoria bat';
$string['addnewcourse'] = 'Gehitu beste ikastaro bat';
$string['addnewuser'] = 'Gehitu beste erabiltzaile bat';
$string['addnousersrecip'] = 'Honetan sartu ez diren erabiltzaileak hartzaileen zerrendara gehitu: {$a}';
$string['addpagehere'] = 'Gehitu testua hemen';
$string['addresource'] = 'Gehitu baliabidea...';
$string['addresourceoractivity'] = 'Gehitu jarduera edo baliabidea';
$string['addresourcetosection'] = 'Gehitu baliabide bat \'{$a}\' atalean';
$string['address'] = 'Helbidea';
$string['addstudent'] = 'Gehitu ikaslea';
$string['addsubcategory'] = 'Gehitu azpikategoria';
$string['addteacher'] = 'Gehitu irakaslea';
$string['admin'] = 'Kudeatzailea';
$string['adminhelpaddnewuser'] = 'Beste erabiltzaile-kontu bat eskuz sortzeko';
$string['adminhelpassignadmins'] = 'Kudeatzaileek edozer egin dezakete eta noranahi joan';
$string['adminhelpassigncreators'] = 'Ikastaro-sortzaileek ikastaroak sortu ahal dituzte';
$string['adminhelpassignsiteroles'] = 'Gunerako definitutako rolak erabiltzaile jakinei aplikatu';
$string['adminhelpassignstudents'] = 'Ikastaro batera joan eta ikasleak gaineratu kudeaketa menutik';
$string['adminhelpauthentication'] = 'Barne erabiltzaile-kontuak erabil ditzakezu edo kanpoko datu-baseak';
$string['adminhelpbackup'] = 'Ezarri segurtasun-kopia automatikoak eta beren egutegia';
$string['adminhelpconfiguration'] = 'Erabaki web gunearen itxura eta ezarpenak';
$string['adminhelpconfigvariables'] = 'Ezarri web gunearen funtzionamendu orokorra baldintzatzen duten aldagaiak';
$string['adminhelpcourses'] = 'Zehaztu ikastaroak eta kategoriak eta esleitu ikasleak, editatu onarpenaren zain dauden ikastaroak';
$string['adminhelpeditorsettings'] = 'Ezarri HTML editorearen oinarrizko ezarpenak';
$string['adminhelpedituser'] = 'Ikusi erabiltzaile-kontuen zerrenda eta aldatu bat edo beste';
$string['adminhelpenvironment'] = 'Konprobatu zure zerbitzaria oraingo eta geroko instalaziorako baldintzetara egokituta dagoen';
$string['adminhelpfailurelogs'] = 'Ikusi huts egindako sarrerak';
$string['adminhelplanguage'] = 'Hizkuntza-ezaugarriak ikusi eta aldatzeko';
$string['adminhelplogs'] = 'Ikusi web gune honetako jarduera guztietan zer gertatu den';
$string['adminhelpmanageblocks'] = 'Kudeatu instalatutako blokeak eta beren ezaugarriak';
$string['adminhelpmanagedatabase'] = 'Sartu datu-basera zuzenean. Kontuz!';
$string['adminhelpmanagefilters'] = 'Aukeratu testu-iragazkiak eta beren ezaugarriak';
$string['adminhelpmanagemodules'] = 'Kudeatu instalatutako moduluak eta beren ezaugarriak';
$string['adminhelpmanageroles'] = 'Erabiltzaileei aplikatzeko moduko rolak sortu eta definitu';
$string['adminhelpmymoodle'] = '\'Nire Moodle\' blokeak erabiltzaileentzat konfiguratu';
$string['adminhelpreports'] = 'Irizpide ezberdinen araberako ikastaroen sailkapena';
$string['adminhelpsitefiles'] = 'Fitxategi orokorrak argitaratu edo kanpoko segurtasun-kopiak eguneratzeko';
$string['adminhelpsitesettings'] = 'Web gunearen lehen orriaren itxura erabaki';
$string['adminhelpstickyblocks'] = 'Bloke finkoak Moodle-ren bidez konfiguratu';
$string['adminhelpthemes'] = 'Web gune osoaren itxura erabaki';
$string['adminhelpuploadusers'] = 'Ekarri erabiltzaile berrien kontuak testu-fitxategi batetik';
$string['adminhelpusers'] = 'Definitu erabiltzaileak eta egiaztatzeko modua';
$string['adminhelpxmldbeditor'] = 'XMLDB fitxategiak editatzeko interfazea. Garatzaileentzat bakarrik.';
$string['administration'] = 'Kudeaketa';
$string['administrationsite'] = 'Gunearen kudeaketa';
$string['administrator'] = 'Kudeatzailea';
$string['administratordescription'] = 'Kudeatzaileek gunean edozer egin dezakete, baita ikastaro guztietan ere.';
$string['administrators'] = 'Kudeatzaileak';
$string['administratorsall'] = 'Kudeatzaile guztiak';
$string['administratorsandteachers'] = 'Kudeatzaileak eta irakasleak';
$string['advanced'] = 'Aurreratua';
$string['advancedfilter'] = 'Bilaketa aurreratua';
$string['advancedsettings'] = 'Bilaketa aurreratuaren ezarpenak';
$string['afterresource'] = '"{$a}" baliabidearen ondoren';
$string['aftersection'] = '"{$a}" atalaren ondoren';
$string['again'] = 'berriro';
$string['aimid'] = 'ID AIM';
$string['ajaxuse'] = 'AJAX eta Javascript';
$string['all'] = 'Guztia(k)';
$string['allactions'] = 'Ekintza guztiak';
$string['allactivities'] = 'Jarduera guztiak';
$string['allcategories'] = 'Kategoria guztiak';
$string['allchanges'] = 'Aldaketa guztiak';
$string['alldays'] = 'Orain arteko guztiak';
$string['allfieldsrequired'] = 'Eremu guztiak beharrezkoak dira';
$string['allfiles'] = 'Fitxategi guztiak';
$string['allgroups'] = 'Talde guztiak';
$string['alllogs'] = 'Agerraldi guztiak';
$string['allmods'] = '{$a} guztiak';
$string['allow'] = 'Baimendu';
$string['allowinternal'] = 'Barne-moduak ere baimendu';
$string['allownone'] = 'Bat ere ez onartu';
$string['allownot'] = 'Ez baimendu';
$string['allparticipants'] = 'Partaide guztiak';
$string['allteachers'] = 'Irakasle guztiak';
$string['alphanumerical'] = 'Alfabetoaren letrak eta zenbakiak, gidoia (-) eta puntua (.) besterik ezin da erabili';
$string['alreadyconfirmed'] = 'Erregistroa dagoeneko baieztatuta';
$string['alternatename'] = 'Ordezko izena';
$string['always'] = 'Beti';
$string['and'] = '{$a->one} eta {$a->two}';
$string['answer'] = 'Erantzun';
$string['any'] = 'Edozein';
$string['appearance'] = 'Itxura';
$string['approve'] = 'Onartu';
$string['areyousure'] = 'Ziur al zaude?';
$string['areyousuretorestorethis'] = 'Jarraitu nahi al duzu?';
$string['areyousuretorestorethisinfo'] = 'Geroago izango duzu aukera kopia hau ikastaro batean gaineratzeko edo ikastaro berri bat sortzeko';
$string['asc'] = 'Behetik gora';
$string['assessment'] = 'Ebaluazioa';
$string['assignadmins'] = 'Kudeatzaileak aukeratu';
$string['assigncreators'] = 'Sortzaileak aukeratu';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Ezarri gunerako rolak';
$string['authenticateduser'] = 'Autentifikatutako erabiltzailea';
$string['authenticateduserdescription'] = 'Autentifikatutako erabiltzaile guztiak';
$string['authentication'] = 'Autentifikazioa';
$string['authenticationplugins'] = 'Autentifikazio-pluginak';
$string['autosubscribe'] = 'Izen-emate automatikoa foroan';
$string['autosubscribeno'] = 'Ez: ez eman nire izena automatikoki foroetan.';
$string['autosubscribeyes'] = 'Bai: eman nire izena foroan, idazten baldin badut.';
$string['availability'] = 'Eskuragarritasuna';
$string['availablecourses'] = 'Eskura dauden ikastaroak';
$string['back'] = 'Atzera';
$string['backto'] = '{$a}-ra itzuli';
$string['backtocourselisting'] = 'Itzuli ikastaro-zerrendara';
$string['backtopageyouwereon'] = 'Itzuli aurretik zeunden orrira';
$string['backtoparticipants'] = 'Itzuli partaideen zerrendara';
$string['backup'] = 'Segurtasun-kopia';
$string['backupactivehelp'] = 'Erabaki segurtasun-kopiak automatikoki egingo diren ala ez';
$string['backupcancelled'] = 'Segurtasun-kopia ezeztatuta';
$string['backupcoursefileshelp'] = 'Aukeratuz gero, ikastaroetako fitxategiak segurtasun-kopia automatikoetan sartuko dira.';
$string['backupdate'] = 'Segurtasun-kopiaren data';
$string['backupdatenew'] = '&nbsp;{$a->TAG} orain {$a->weekday}, {$a->mday} {$a->month} {$a->year} da<br />';
$string['backupdateold'] = '{$a->TAG} lehen {$a->weekday}, {$a->mday} {$a->month} {$a->year} zen';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Segurtasun-kopiaren xehetasunak';
$string['backupexecuteathelp'] = 'Erabaki zein ordutan egingo diren segurtasun-kopia automatikoak';
$string['backupfailed'] = 'Ikastaro batzuk gorde gabe gelditu dira!';
$string['backupfilename'] = 'segurtasun-kopia';
$string['backupfinished'] = 'Segurtasun-kopia ondo egina';
$string['backupfromthissite'] = 'Segurtasun-kopia gune honetan egin al da?';
$string['backupgradebookhistoryhelp'] = 'Gaituta, kalifikazio-liburuen historia segurtasun-kopia automatikoetan sartuko da. Ohartu kalifikazioen historia ezin dela desgaitu zerbitzariaren ezerpenetan (disablegradehistory) funtzionatu ahal izateko';
$string['backupincludemoduleshelp'] = 'Erabaki ikastaroetako moduluak, erabiltzaileen datuekin edo horiek gabe, sartu nahi dituzun segurtasun-kopia automatikoetan.';
$string['backupincludemoduleuserdatahelp'] = 'Erabaki moduluen erabiltzaileen datuak sartu nahi dituzun segurtasun-kopia automatikoetan.';
$string['backupkeephelp'] = 'Arestiko zenbat segurtasun-kopia gorde nahi duzu ikastaro bakoitzeko? Zaharragoak ezabatu egingo dira.';
$string['backuplogdetailed'] = 'Segurtasun-kopiaren erregistro zehatza';
$string['backuploglaststatus'] = 'Azken segurtasun-kopiaren erregistroa';
$string['backupmissinguserinfoperms'] = 'Oharra: segurtasun-kopia honek erabiltzaile ez diren datuak ditu. Ariketa eta Tailerra jarduerak ez dira sartuko segurtasun-kopiak, modulu horiek ez baitira segurtasun-kopia mota honekin bateragarriak.';
$string['backupnext'] = 'Hurrengo segurtasun-kopia';
$string['backupnonisowarning'] = 'Kontuz: kopia hau Moodle bertsio ez Unicode (1.6aren aurretikoa) batetik dator. Kopiak ISO-8859-1 ez den edozein testu badu KALTETUA izan daiteke Moodle-ren Unicode bertsio honetara berreskuratzean. Begiratu <a href="http://docs.moodle.org/eu/FAQ_segurtasun-kopia_eta_berreskuratu">Segurtasun-kopia FAQ</a> segurtasun-kopia hau egoki egiteko informazio gehiago lortzeko.';
$string['backupnotyetrun'] = 'Segurtasun kopia automatikoa egiteke';
$string['backuporiginalname'] = 'Segurtasun-kopiaren izena';
$string['backuproleassignments'] = 'Rol hauetarako rol-esleipenen segurtasun-kopia';
$string['backupsavetohelp'] = 'Zein direktoriotan gorde nahi duzu segurtasun-kopia? Horren helbide osoa idatzi. (Ez idatzi ezer ikastaroari dagokion direktorioan gorde dadin)';
$string['backupsitefileshelp'] = 'Aukera hau eginda ikastaroetan erabilitako guneko fitxategiak automatizatutako segurtasun-kopietan sartuko dira.';
$string['backuptakealook'] = 'Mesedez, eman begiratu bat zure segurtasun-kopiaren erregistroei hemen: {$a}';
$string['backupuserfileshelp'] = 'Erabaki erabiltzaileen fitxategiak (profilaren irudiak, adibidez) segurtasun-kopia automatikoetan sartu behar diren ala ez.';
$string['backupversion'] = 'Segurtasun-kopiaren bertsioa';
$string['badges'] = 'Dominak';
$string['block'] = 'Blokea';
$string['blockconfiga'] = '{$a} blokea ezartzen';
$string['blockconfigbad'] = 'Bloke hau ez da egoki sortu eta, beraz, ezin ezarpenak ezarri.';
$string['blocks'] = 'Blokeak';
$string['blocksaddedit'] = 'Gehitu/editatu blokeak';
$string['blockseditoff'] = 'Blokeen edizioa desaktibatuta';
$string['blocksediton'] = 'Blokeen edizioa aktibatuta';
$string['blocksetup'] = 'Blokeko taulak sortzen';
$string['blocksuccess'] = '{$a} taulak egoki sortu dira.';
$string['brief'] = 'Laburra';
$string['bulkactions'] = 'Eragiketa masiboak';
$string['bulkactionselect'] = '{$a} eragiketa masiboaren aukeraketa';
$string['bulkmovecoursessuccess'] = '{$a->courses} ikastaroak ondo mugitu dira {$a->category} kategoriara';
$string['bycourseorder'] = 'Ikastaro-ordenaren arabera';
$string['byname'] = '{$a}-(r)en arabera';
$string['bypassed'] = 'Saihestua';
$string['cachecontrols'] = 'Cache-kontrolak';
$string['cancel'] = 'Utzi';
$string['cancelled'] = 'Bertan behera utzi da';
$string['categories'] = 'Ikastaro-kategoriak';
$string['categoriesandcoures'] = 'Ikastaro-kategoriak eta ikastaroak';
$string['category'] = 'Kategoria';
$string['categoryadded'] = '\'{$a}\' kategoria gehitu da';
$string['categorybulkaction'] = 'Eragiketa masiboak aukeratutako kategorietarako';
$string['categorycontents'] = 'Azpikategoriak eta ikastaroak';
$string['categorycurrentcontents'] = '{$a}-ren edukiak';
$string['categorydeleted'] = '\'{$a}\' kategoria ezabatu da';
$string['categoryduplicate'] = '\'{$a}\' izeneko kategoria badago dagoeneko!';
$string['categorymodifiedcancel'] = 'Kategoria aldatu egin da! Mesedez, bertan behera utzi eta saiatu berriz.';
$string['categoryname'] = 'Kategoriaren izena';
$string['categorysubcategoryof'] = '{$a->category} - {$a->parentcategory}-(r)en azpikategoria';
$string['categoryupdated'] = '\'{$a}\' kategoria eguneratu egin da';
$string['changedpassword'] = 'Aldatutako pasahitza';
$string['changepassword'] = 'Pasahitza aldatu';
$string['changesmadereallygoaway'] = 'Aldaketak egin dituzu. Ziur al zaude irten eta aldaketak galdu nahi dituzula?';
$string['changessaved'] = 'Aldaketak gordeta';
$string['check'] = 'Egiaztatu';
$string['checkall'] = 'Guztiak egiaztatu';
$string['checkingbackup'] = 'Segurtasun-kopia egiaztatzen';
$string['checkingcourse'] = 'Ikastaroa egiaztatzen';
$string['checkingforbbexport'] = 'Blackboard-erako esportazioa egiaztatzen';
$string['checkinginstances'] = 'Instantziak egiaztatzen';
$string['checkingsections'] = 'Atalak egiaztatzen';
$string['checklanguage'] = 'Egiaztatu hizkuntza';
$string['checknone'] = 'Ez egiaztatu ezer';
$string['childcoursenotfound'] = 'Bigarren mailako ikastarorik ez da aurkitu!';
$string['childcourses'] = 'Bigarren mailako ikastaroak';
$string['choose'] = 'Aukeratu';
$string['choosecourse'] = 'Aukeratu ikastaro bat';
$string['choosedots'] = 'Aukeratu...';
$string['chooselivelogs'] = 'Edo zer ari den orain gertatzen ikusi';
$string['chooselogs'] = 'Aukeratu noren eta noizko agerraldia ikusi nahi duzun';
$string['choosereportfilter'] = 'Aukeratu txostenerako iragazkia';
$string['choosetheme'] = 'Itxura aukeratu';
$string['chooseuser'] = 'Aukera ezazu erabiltzaile bat';
$string['city'] = 'Hiria/Herria';
$string['clambroken'] = 'Zure kudeatzaileak igotako fitxategien birusen ikuskaketa indarrean jarri da, baina zerbait gaizki konfiguratuta dago.<br />Fitxategia EZIN izan da igo. Zure kudeatzaileari mezua bidali zaio arazoa zuzen dezan.<br />Saia zaitez fitxategia beranduago igotzen, mesedez.';
$string['clamdeletedfile'] = 'Fitxategia ezabatuta';
$string['clamdeletedfilefailed'] = 'Fitxategia ezin da ezabatu';
$string['clamemailsubject'] = '{$a} :: Clam AV oharra';
$string['clamfailed'] = 'Clam AV ez da egikaritu. Akatsaren mezua {$a} da. Hau da Clam-en output-a:';
$string['clamlost'] = 'Moodle fitxategi bat kargatzean Clam egikaritzeko konfiguratuta dago, baina Clam AV bidea, {$a}, ez da egokia.';
$string['clamlostandactinglikevirus'] = 'Gainera, Moodle-ren konfigurazioa dela eta, Clam ez badabil, fitxategiak birustzat hartzen dira. Hori dela eta, ikasleek ezin dute fitxategirik igo arazoa konpondu ezean.';
$string['clammovedfile'] = 'Fitxategia zuk aukeratutako koarentena-direktoriora mugitu da eta orain hemen dago: {$a}';
$string['clammovedfilebasic'] = 'Fitxategia koarentena-direktoriora mugitu da.';
$string['clamquarantinedirfailed'] = 'Fitxategia ezin izan da mugitu zuk aukeratutako koarentena-direktoriora: {$a} . Hori zuzendu behar duzu fitxategiak infektatuta baleude ezabatu beharko lirateke eta.';
$string['clamunknownerror'] = 'Clam-en errore ezezaguna gertatu da.';
$string['cleaningtempdata'] = 'Behin behineko datuak (TEMP) ezabatzen';
$string['clear'] = 'Garbitu';
$string['clickhelpiconformoreinfo'] = '... jarraitu ...Sakatu laguntza-ikonoari artikulu osoa irakurtzeko.';
$string['clickhere'] = 'Sakatu hemen...';
$string['clicktochangeinbrackets'] = '{$a} (Klik egin aldatzeko)';
$string['clicktohideshow'] = 'Sakatu zabaltzeko edo tolesteko';
$string['closebuttontitle'] = 'Itxi';
$string['closewindow'] = 'Itxi leiho hau';
$string['collapse'] = 'Tolestu';
$string['collapseall'] = 'Tolestu guztia';
$string['collapsecategory'] = 'Tolestu {$a}';
$string['commentincontext'] = 'Bilatu iruzkin hau testuinguruan';
$string['comments'] = 'Iruzkinak';
$string['commentsnotenabled'] = 'Iruzkinak funtzioa ez dago gaituta';
$string['commentsrequirelogin'] = 'Identifikatu egin behar duzu iruzkinak ikusi ahal izateko';
$string['comparelanguage'] = 'Oraingo hizkuntza alderatu eta editatu';
$string['complete'] = 'Osoa';
$string['completereport'] = 'Txosten osoa';
$string['configuration'] = 'Ezarpenak';
$string['confirm'] = 'Baieztatu';
$string['confirmcheckfull'] = 'Erabat ziur al zaude {$a} baieztatu nahi duzula?';
$string['confirmcoursemove'] = 'Ziur al zaude  ({$a->course}) ikastaroa  ({$a->category}) kategoriara mugitu nahi duzula?';
$string['confirmed'] = 'Zure matrikulazioa berretsi da';
$string['confirmednot'] = 'Zure matrikulazioa oraindik baieztatu gabe';
$string['content'] = 'Edukia';
$string['continue'] = 'Jarraitu';
$string['continuetocourse'] = 'Sakatu hemen ikastaroan sartzeko';
$string['convertingwikitomarkdown'] = 'Wikia Markdown-era bihurtzen';
$string['cookiesenabled'] = 'Cookie-ak gaituta izan behar dituzu zure nabigatzailean';
$string['cookiesenabled_help'] = 'Gune honek bi "kuki" erabiltzen ditu:

Funtsezkoa saioarena da eta honen ohiko izena MoodleSession. Zure nabigatzaileari berau onartzen utzi behar diozu orritik orrira zerbitzua manten dadin. Plataformatik irtetean edo nabigatzailea ixtean kukia deuseztatu egingo da (nabigatzailean eta zerbitzarian).

Beste kukia zure erraztasunerako da eta honen izena MOODLEID. Nabigatzailean duzun erabiltzaile izena baino ez du gogoratzen. Berriz gunean sartzen zarenean zure izena automatikoki sortuko du erabiltzaile-izena eremuan (userid). Segurtasun handiagoa nahi baduzu ez erabili aukera hau, sartzen zaren bakoitzean eskuz sartu izena eta kitto.';
$string['cookiesnotenabled'] = 'Zoritxarrez, kukiak ez daude gaituta zure nabigatzailean';
$string['copy'] = 'kopiatu';
$string['copyasnoun'] = 'kopiatu';
$string['copyingcoursefiles'] = 'Ikastaroko fitxategiak kopiatzen';
$string['copyingsitefiles'] = 'Ikastaroan erabilitako guneko fitxategiak kopiatzen';
$string['copyinguserfiles'] = 'Erabiltzaileen fitxategiak kopiatzen';
$string['copyingzipfile'] = 'Zip-fitxategia kopiatzen';
$string['copyrightnotice'] = 'Copyright oharra';
$string['coresystem'] = 'Sistema';
$string['cost'] = 'Kostea';
$string['costdefault'] = 'Lehenetsitako kostea';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Herria';
$string['course'] = 'Ikastaroa';
$string['courseadministration'] = 'Ikastaroaren kudeaketa';
$string['courseapprovedemail'] = 'Zure ikastaro-eskaria, {$a->name}, onartu egin da eta zu {$a->teacher} izendatua izan zara. Zure ikastaro berrira sartzeko hona joan: {$a->url}';
$string['courseapprovedemail2'] = 'Zure ikastaro-eskaria,  {$a->name}, onartu egin da. Zure ikastaro berrira sartzeko hona joan: {$a->url}';
$string['courseapprovedfailed'] = 'Zure ikastaroa ez da onartutzat gorde!';
$string['courseapprovedsubject'] = 'Zure ikastaroa onartu da!';
$string['courseavailable'] = 'Ikastaro hau eskura dago ikasleentzat';
$string['courseavailablenot'] = 'Ikastaro hau ez dago eskura ikasleentzat';
$string['coursebackup'] = 'Ikastaroaren segurtasun-kopia';
$string['coursebulkaction'] = 'Eragiketa masiboak aukeratutako kategorietarako';
$string['coursecategories'] = 'Ikastaro-kategoriak';
$string['coursecategory'] = 'Ikastaro-kategoria';
$string['coursecategorydeleted'] = '{$a} ikastaro-kategoria ezabatuta';
$string['coursecategory_help'] = 'Ezarpen honek adierazten du zein kategoriatan agertuko den ikastaroa ikastaroen zerrendan.';
$string['coursecatmanagement'] = 'Ikastaro eta kategorien kudeaketa';
$string['coursecompletion'] = 'Ikastaro-osaketa';
$string['coursecompletions'] = 'Ikastaro-osaketak';
$string['coursecreators'] = 'Ikastaro-sortzailea';
$string['coursecreatorsdescription'] = 'Ikastaro sortzaileek ikastaro berriak sor ditzakete.';
$string['coursedeleted'] = '{$a} ikastaroa ezabatuta';
$string['coursedisplay'] = 'Ikastaroaren diseinua';
$string['coursedisplay_help'] = 'Aukera honek ezartzen du ikastaro osoa orri bakarrean erakusten den ala hainbat orritan banatzen den.';
$string['coursedisplay_multi'] = 'Erakutsi atal bat orriko';
$string['coursedisplay_single'] = 'Erakutsi atal guztiak orri bakar batean';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Ikastaroko fitxategiak';
$string['coursefilesedit'] = 'Editatu ikastaroko fitxategiak';
$string['coursefileswarning'] = 'Ez daude onartuta ikastaro-fitxategiak';
$string['coursefileswarning_help'] = 'Moodle 2.0-tik aurrera ikastaro-fitxategiak ez daude onartuta; mesedez, erabili kanpoko biltegiak bere ordez';
$string['courseformatdata'] = 'Ikastaro-formatuaren datuak';
$string['courseformatoptions'] = 'Formatu aukerak {$a}-(r)entzat';
$string['courseformats'] = 'Ikastaro-formatuak';
$string['courseformatudpate'] = 'Eguneratu formatua';
$string['coursegrades'] = 'Ikastaroaren kalifikazioak';
$string['coursehelpcategory'] = 'Kokatu ikastaroa ikastaroen zerrenda eta horrela erraztu egingo diezu ikasleei biltzeko lana.';
$string['coursehelpforce'] = 'Behartu ikastaroan taldekatze-modua ikastaroko edozein jarduetarako.';
$string['coursehelpformat'] = 'Ikastaroaren hasiera-orria formatu honetan erakutsiko da';
$string['coursehelphiddensections'] = 'Ikastaroko ezkutuko atalak ikasleei nola erakutsiko zaizkien.';
$string['coursehelpmaximumupload'] = 'Ikastaro honetara igo daitezkeen fitxategien gehienezko tamaina, gune mailako ezarpenak mugatzen du.';
$string['coursehelpnewsitemsnumber'] = 'Ikastaroaren hasiera-orrian agertuko diren azken berrien kopurua, eskuin aldeko bloke berrian. O ezarriz gero, blokea ez da agertu ere egingo.';
$string['coursehelpnumberweeks'] = 'Ikastaroaren hasiera-orria erakusteko aste/gai-kopurua (ikastaro-formatu batzuri bakarrik eragiten die).';
$string['coursehelpshowgrades'] = 'Gaitu kalifikazio-liburua erakustea. Ez du galerazten kalifikazioak jarduera bakoitzean ere agertzea.';
$string['coursehidden'] = 'Ikastaroa ez dago eskura ikasleentzat';
$string['courseinfo'] = 'Ikastaroaren informazioa';
$string['courselegacyfiles'] = 'Ikastaroko fitxategiak';
$string['courselegacyfiles_help'] = 'Ikastaroko fitxategien guneak eskaintzen du nolabaiteko bateragarritasuna Moodle 1.9 eta zaharragoekin. Gune honetako fitxategiak ikastaroko ikasleentzat eskuragarriak izango dira beti (nahiz estekatu ala ez), eta ezin da jakin non erabiltzen diren Moodle barruan.

Gune hau erabiltzen baduzu ikastaroko fitxategiak gordetzeko, pribatutasun eta segurtasun-arriskuak izan ditzakezu; halaber, gerta liteke fitxategiak galtzea babes-kopietan, ikastaroak inportatzerakoan eta edukiak partekatzerakoan edo berrerabiltzerakoan. Beraz, egiten ari zarena ondo ulertzen ez baduzu, ez da gomendagarria gune hau erabiltzea.';
$string['courselegacyfilesofcourse'] = 'Heredatutako ikastaroko fitxategiak: {$a}';
$string['coursemessage'] = 'Ikastaroko erabiltzaileei mezua';
$string['coursenotaccessible'] = 'Ikastaro honetan matrikulatutakoak bakarrik sar daitezke';
$string['courseoverview'] = 'Ikastaroaren ikuspegi orokorra';
$string['courseoverviewfiles'] = 'Ikastaroaren laburpeneko fitxategiak';
$string['courseoverviewfilesext'] = 'Ikastaroaren laburpeneko fitxategien luzapenak';
$string['courseoverviewfiles_help'] = 'Ikastaroko laburpenaren fitxategiak, irudiak esaterako, ikastaroen zerrendan erakusten dira laburpenarekin batera.';
$string['courseoverviewfileslimit'] = 'Ikastaroaren laburpeneko fitxategien muga';
$string['courseoverviewgraph'] = 'Ikastaroaren grafiko globala';
$string['courseprofiles'] = 'Ikastaro-profilak';
$string['coursereasonforrejecting'] = 'Ikastaro-eskaria ez onartzeko arrazoiak';
$string['coursereasonforrejectingemail'] = 'Hau e-postaz bidaliko zaio eskatzaileari';
$string['coursereject'] = 'Ez onartu ikastaro-eskaria';
$string['courserejected'] = 'Ikastaroa ez da onartu eta hala jakinarazi zaio eskatzaileari.';
$string['courserejectemail'] = 'Sentitzen dugu, baina eskatu duzun ikastaroa ez da onartu arrazoi honengatik:

{$a}';
$string['courserejectreason'] = 'Ikastaro hau ez onartzeko zure arrazoiak idatzi<br/>(eskatzaileari bidali egingo zaizkio)';
$string['courserejectsubject'] = 'Zure ikastaroa ez da onartu';
$string['coursereport'] = 'Ikastaroaren txostena';
$string['coursereports'] = 'Ikastaroaren txostenak';
$string['courserequest'] = 'Ikastaro-eskaria';
$string['courserequestdetails'] = 'Eskatzen ari zaren ikastaroaren xehetasunak';
$string['courserequestfailed'] = 'Zure ikastaro-eskaria arrazoi ezezagunengatik ezin izan da gorde';
$string['courserequestintro'] = 'Ikastaroa sortzeko eskaria egiteko formulario hau erabili.<br />Kudeatzaileek ikastaroa zergatik eskatzen duzun jakin dezaten<br />ahalik eta informazio gehien eman, mesedez.';
$string['courserequestreason'] = 'Ikastaroa eskatzeko arrazoiak';
$string['courserequestsuccess'] = 'Ikastaro-eskaria ondo gorde da. Gutxi barru e-postaz zure eskaera onartu den jakinaraziko zaizu.';
$string['courserequestsupport'] = 'Informazio lagungarria kudeatzaileak eskari hau ebaluatzeko';
$string['courserestore'] = 'Ikastaroa berreskuratu';
$string['courses'] = 'Ikastaroak';
$string['coursesectionsummaries'] = 'Ikastaro-atalen laburpenak';
$string['coursesettings'] = 'Ikastaroaren berezko ezarpenak';
$string['coursesmovedout'] = '{$a}-tik kanpora mugitutako ikastaroak';
$string['coursespending'] = 'Onarpenaren zain dauden ikastaroak';
$string['coursestart'] = 'Ikastaro-hasiera';
$string['coursesummary'] = 'Ikastaroaren laburpena';
$string['coursesummary_help'] = 'Ikastaroaren laburpena ikastaroen zerrendan erakusten da. Ikastaroen bilaketak laburpenen testuetan bilatzen du eta baita ikastaroen izenetan ere.';
$string['courseupdates'] = 'Ikastaroen eguneraketak';
$string['create'] = 'Sortu';
$string['createaccount'] = 'Nire kontu berria sortu';
$string['createcategory'] = 'Kategoria sortu';
$string['createfolder'] = 'Sortu karpeta hemen: {$a}';
$string['createnew'] = 'Sortu beste bat';
$string['createnewcategory'] = 'Sortu beste kategoria bat';
$string['createnewcourse'] = 'Sortu beste ikastaro bat';
$string['createnewsubcategory'] = 'Sortu beste azpikategoria bat';
$string['createsubcategoryof'] = 'Sortu {$a}-(r)en azpikategoria';
$string['createuser'] = 'Sortu erabiltzailea';
$string['createuserandpass'] = 'Aukeratu zure erabiltzaile-izena eta pasahitza';
$string['createziparchive'] = 'Zip-fitxategia sortu';
$string['creatingblocks'] = 'Blokeak sortzen';
$string['creatingblocksroles'] = 'Bloke mailako rol ezarpenak eta baliogabetzeak sortzen';
$string['creatingblogsinfo'] = 'Blogen informazioa sortzen';
$string['creatingcategoriesandquestions'] = 'Kategoriak eta galderak sortzen';
$string['creatingcoursemodules'] = 'Ikastaro-moduluak sortzen';
$string['creatingcourseroles'] = 'Ikastaro mailako rol ezarpenak eta baliogabetzeak sortzen';
$string['creatingevents'] = 'Ekitaldiak sortzen';
$string['creatinggradebook'] = 'Kalifikazio-liburua sortzen';
$string['creatinggroupings'] = 'Taldekatzeak sortzen';
$string['creatinggroupingsgroups'] = 'Taldeak taldekatzeetara gaineratzen';
$string['creatinggroups'] = 'Taldeak sortzen';
$string['creatinglogentries'] = 'Erregistro-sarrerak sortzen';
$string['creatingmessagesinfo'] = 'Informazio-mezuak sortzen';
$string['creatingmodroles'] = 'Modulu mailako rol ezarpenak eta baliogabetzeak sortzen';
$string['creatingnewcourse'] = 'Ikastaro berria sortzen';
$string['creatingrolesdefinitions'] = 'Rolen definizioak sortzen';
$string['creatingscales'] = 'Eskalak sortzen';
$string['creatingsections'] = 'Atalak sortzen';
$string['creatingtemporarystructures'] = 'Denbora-egiturak sortzen';
$string['creatinguserroles'] = 'Erabiltzaile mailako rol ezarpenak eta baliogabetzeak sortzen';
$string['creatingusers'] = 'Erabiltzaileak sortzen';
$string['creatingxmlfile'] = 'XML fitxategia sortzen';
$string['currency'] = 'Moneta';
$string['currentcourse'] = 'Oraingo ikastaroa';
$string['currentcourseadding'] = 'Datuak gehitzen ikastaro honetara';
$string['currentcoursedeleting'] = 'Oraingo ikastaroa ezabatzen lehenik';
$string['currentlanguage'] = 'Oraingo hizkuntza';
$string['currentlocaltime'] = 'bertako ordua';
$string['currentlyselectedusers'] = 'Aukeratutako erabiltzaileak';
$string['currentpicture'] = 'Oraingo argazkia';
$string['currentrelease'] = 'Oraingo bertsioaren inguruko informazioa';
$string['currentversion'] = 'Oraingo bertsioa';
$string['databasechecking'] = 'Moodle datu-basea bertsioberritzen {$a->oldversion}-(e)tik {$a->newversion}-(e)ra';
$string['databaseperformance'] = 'Datu-basearen errendimendua';
$string['databasesetup'] = 'Datu-basea ezartzen';
$string['databasesuccess'] = 'Datu-basea ondo eguneratu da';
$string['databaseupgradebackups'] = 'Segurtasun-kopiaren orain bertsioa {$a} da';
$string['databaseupgradeblocks'] = 'Blokeen bertsioa orain {$a} da';
$string['databaseupgradegroups'] = 'Taldeen bertsioa {$a} da orain';
$string['databaseupgradelocal'] = 'Datu-base lokalaren pertsonalizazio-bertsioa zera da: {$a}';
$string['databaseupgrades'] = 'Datu-basea eguneratzen';
$string['date'] = 'Data';
$string['datechanged'] = 'Data aldatuta';
$string['datemostrecentfirst'] = 'Data - berrienak lehenak';
$string['datemostrecentlast'] = 'Data - berrienak azkenak';
$string['day'] = 'egun(a)';
$string['days'] = 'egun';
$string['decodinginternallinks'] = 'Barneko estekak dekodifikatzen';
$string['default'] = 'Lehenetsitakoa';
$string['defaultcoursestudent'] = 'Ikaslea';
$string['defaultcoursestudentdescription'] = 'Ikasleek oro har ikastaro baten barruan baimen gutxi dute';
$string['defaultcoursestudents'] = 'Ikasleak';
$string['defaultcoursesummary'] = 'Paragrafo labur eta interesgarri bat idatzi ikastaroaren nondik norakoen azalpen labur gisa';
$string['defaultcourseteacher'] = 'Irakaslea';
$string['defaultcourseteacherdescription'] = 'Irakasleek edozer egin dezakete ikastaro batean, baita ikasleen jarduerak eta kalifikazioak aldatu ere.';
$string['defaultcourseteachers'] = 'Irakasleak';
$string['defaulteditor'] = 'Berezko editorea';
$string['delete'] = 'Ezabatu';
$string['deleteablock'] = 'Blokea ezabatu';
$string['deleteall'] = 'Dena ezabatu';
$string['deleteallcannotundo'] = 'Dena ezabatu - ezin da desegin';
$string['deleteallcomments'] = 'Iruzkin guztiak ezabatu';
$string['deleteallratings'] = 'Puntuazio guztiak ezabatu';
$string['deletecategory'] = 'Kategoria ezabatu: {$a}';
$string['deletecategorycheck'] = 'Ziur al zaude <b>\'{$a}\'</b> kategoria erabat ezabatu nahi duzula?<br />Honek goragoko kategoriara mugituko ditu ikastaroak, halakorik balego, edo Saski-naskira.';
$string['deletecategorycheck2'] = 'Kategoria hau ezabatzen baduzu, erabaki beharko duzu barruan dauden ikastaro eta azpikategoriekin zer egin';
$string['deletecategoryempty'] = 'Kategoria hau hutsik dago.';
$string['deletecheck'] = '{$a} ezabatu?';
$string['deletecheckfiles'] = 'Ziur al zaude fitxategi hauek ezabatu nahi dituzula?';
$string['deletecheckfull'] = 'Ziur al zaude {$a} guztiz ezabatu nahi duzula?';
$string['deletechecktype'] = 'Ziur al zaude {$a->type} ezabatu nahi duzula?';
$string['deletechecktypename'] = 'Ziur al zaude {$a->type} ezabatu nahi duzula?';
$string['deletecheckwarning'] = 'Fitxategi hauek ezabatu egingo dituzu';
$string['deletecomment'] = 'Iruzkin hau ezabatu';
$string['deletecompletely'] = 'Guztiz ezabatu';
$string['deletecourse'] = 'Ikastaro bat ezabatu';
$string['deletecoursecheck'] = 'Ziur al zaude ikastaro hau eta bere eduki guztiak guztiz ezabatu nahi dituzula?';
$string['deleted'] = 'Ezabatuta';
$string['deletedactivity'] = '{$a} ezabatuta';
$string['deletedcourse'] = '{$a} guztiz ezabatu da';
$string['deletednot'] = 'Ezin izan da {$a} ezabatu!';
$string['deletelogs'] = 'Agerraldiak ezabatu';
$string['deleteselected'] = 'Aukeratutakoa ezabatu';
$string['deleteselectedkey'] = 'Aukeratutako giltza ezabatu';
$string['deletingcourse'] = '{$a} ezabatzen';
$string['deletingexistingcoursedata'] = 'Ikastaroko datuak ezabatzen';
$string['deletingolddata'] = 'Datu zaharrak ezabatzen';
$string['department'] = 'Departamentua';
$string['desc'] = 'Goitik behera';
$string['description'] = 'Deskribapena';
$string['deselectall'] = 'Ez aukeratu bat ere';
$string['detailedless'] = 'Orokorrago';
$string['detailedmore'] = 'Zehatzago';
$string['directory'] = 'Direktorioa';
$string['disable'] = 'Ezgaitu';
$string['disabledcomments'] = 'Iruzkinak desgaituta daude';
$string['displayingfirst'] = 'Lehenengo {$a->count} {$a->things} erakutsita bakarrik';
$string['displayingrecords'] = '{$a} elementu erakusten';
$string['displayingusers'] = 'Ikasleak erakusten {$a->start}, lehena; {$a->end}, azkena';
$string['displayonpage'] = 'Orrian erakutsi';
$string['dndcourse'] = 'Ikastaro hau hartu eta eraman dezakezu ordena aldarazteko edo beste kategoria batera mugitzeko.';
$string['dndenabled_inbox'] = 'Fitxategiak gehitzeko, hartu eta eraman ahal dituzu.';
$string['dndnotsupported'] = 'Hartu eta eraman bidezko igoera ez da onartzen';
$string['dndnotsupported_help'] = 'Zure nabigatzaileak ez du onartzen hartu eta eraman bidezko igoera.<br />Aukera honek funtzionatzen du Chrome-ren, Firefox-en eta Safari-ren azken bertsio guztietan, baita ere Internet Explorer v10-etik gorakoetan.';
$string['dndnotsupported_insentence'] = '\'hartu eta eraman\' ez da onartzen';
$string['dnduploadwithoutcontent'] = 'Igotakoak ez du edukirik';
$string['dndworkingfile'] = 'Hartu eta eraman fitxategiak ikastaro-ataletara igotzeko';
$string['dndworkingfilelink'] = 'Hartu eta eraman fitxategiak edo estekak ikastaro-ataletara igotzeko';
$string['dndworkingfiletext'] = 'Hartu eta eraman fitxategiak edo testua ikastaro-ataletara igotzeko';
$string['dndworkingfiletextlink'] = 'Hartu eta eraman fitxategiak, testua edo estekak ikastaro-ataletara igotzeko';
$string['dndworkinglink'] = 'Hartu eta eraman estekak ikastaro-ataletara igotzeko';
$string['dndworkingtext'] = 'Hartu eta eraman testua ikastaro-ataletara igotzeko';
$string['dndworkingtextlink'] = 'Hartu eta eraman testua edo estekak ikastaro-ataletara igotzeko';
$string['documentation'] = 'Moodle-ren dokumentazioa';
$string['dontsortcategories'] = 'Ez ordenatu kategoriak';
$string['dontsortcourses'] = 'Ez ordenatu ikastaroak';
$string['down'] = 'Jaitsi';
$string['download'] = 'Jaitsi';
$string['downloadall'] = 'Jaitsi dena';
$string['downloadexcel'] = 'Excel-formatuan jaitsi';
$string['downloadfile'] = 'Fitxategia jaitsi';
$string['downloadods'] = 'ODS formatuan jaitsi';
$string['downloadtext'] = 'Testu-formatuan jaitsi';
$string['doyouagree'] = 'Baldintza hauek irakurri eta ulertu dituzu?';
$string['droptoupload'] = 'Fitxategiak igotzeko hona ekarri';
$string['duplicate'] = 'Bikoiztu';
$string['duplicateconfirm'] = 'Ziur al zaude {$a->modtype} bikoiztu nahi duzula \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Itzuli ikastarora';
$string['duplicatecontedit'] = 'Editatu kopia berria';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' ondo bikoiztu da';
$string['duplicatinga'] = 'Bikoizten: {$a}';
$string['edhelpaspellpath'] = 'Editorearen barruan ortografia-zuzentzailea erabiltzeko, <strong>aspell 0.50</strong> edo bertsio zaharragoa instalatuta izan behar duzu, eta aspell bikoitzaren bide egokia adierazi behar duzu. Unix/Linux sistemean bide hori <strong>/usr/bin/aspell</strong> izaten da, baina beste edozein izan liteke.';
$string['edhelpbgcolor'] = 'Edizio-eremuaren hondo-kolorea definitu.<br />Balio onargarriak #FFFFFF o \'white\' dira, adibidez';
$string['edhelpcleanword'] = 'Egokipen honek Wordeko formatu-iragazkia aktibatu edo desaktibatzen du.';
$string['edhelpenablespelling'] = 'Zuzenketa ortografikoa aktibatzen du. Indarrean dagoenean, <strong>aspell</strong>-ek zerbitzarian instalaturik izan behar du.';
$string['edhelpfontfamily'] = 'Hizki-familiaren ezaugarria familia generiko baten izenen edo eta hizki-izenen zerrenda da. Familiaren izenek kakotxez banatuta egon behar dute.';
$string['edhelpfontlist'] = 'Erabilitako hizki-motak editoreen menu kontestualean definitu.';
$string['edhelpfontsize'] = 'Hizki-motaren lehenetsitako tamaina aipatutako tamaina zehazten du. <br />Balore baliagarriak hauek izan daitezke, adibidez: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Editatu';
$string['edita'] = 'Editatu {$a}';
$string['editcategorysettings'] = 'Kategoria-ezarpenak editatu';
$string['editcategorythis'] = 'Editatu kategoria hau';
$string['editcoursesettings'] = 'Ikastaroaren ezarpenak editatu';
$string['editfiles'] = 'Fitxategiak editatu';
$string['editgroupprofile'] = 'Taldearen profila editatu';
$string['editinga'] = '{$a} editatzen';
$string['editingteachershort'] = 'Editorea';
$string['editlock'] = 'Ezarpen hau ezin da editatu!';
$string['editmyprofile'] = 'Profila editatu';
$string['editorbgcolor'] = 'Atzeko kolorea';
$string['editorcleanonpaste'] = 'Itsastean Wordeko HTMLa garbitu';
$string['editorcommonsettings'] = 'Ezarpen arruntak';
$string['editordefaultfont'] = 'Berezko letra-mota';
$string['editorenablespelling'] = 'Zuzentzaile ortografikoa aktibatu';
$string['editorfontlist'] = 'Hizki-moten zerrenda';
$string['editorfontsize'] = 'Berezko letra-tamaina';
$string['editorresettodefaults'] = 'Berezko ezarpenetara bueltatu';
$string['editorsettings'] = 'Editorearen ezarpenak';
$string['editorshortcutkeys'] = 'Editorearen laster-bideak';
$string['editsettings'] = 'Ezarpenak editatu';
$string['editsummary'] = 'Editatu laburpena';
$string['editthisactivity'] = 'Aktibitate hau editatu';
$string['editthiscategory'] = 'Editatu kategoria hau';
$string['edittitle'] = 'Editatu izenburua';
$string['edittitleinstructions'] = 'Sakatu esc teklari uzteko. Idatzi amaitzeko';
$string['edituser'] = 'Editatu erabiltzaile-kontuak';
$string['email'] = 'E-posta helbidea';
$string['emailactive'] = 'E-posta erabili ala ez';
$string['emailagain'] = 'E-posta (berriro)';
$string['emailalreadysent'] = 'Pasahitza berrezartzeko e-posta mezu bat bidali da jada. Mesedez begiratu zure e-posta.';
$string['emailcharset'] = 'E-postarako karaktere-multzoa';
$string['emailconfirm'] = 'Zure kontua berretsi';
$string['emailconfirmation'] = 'Kaixo {$a->firstname},

Kontu-eskaera bat jaso dugu \'{$a->sitename}\' gunean zure e-posta helbidetik.

Zure kontua berresteko, mesedez hurrengo helbide honetara joan:

{$a->link}

E-posta programa gehienetan goiko helbidea lotura urdin bat gisa agertu beharko litzateke eta zuk zuzenean klik egiteko aukera izan.

Ez bada horrela, helbidea kopiatu eta zure Web nabigatzailearen goikaldean dagoen helbide-barran itsasi.

Agur bero bat \'{$a->sitename}\' guneko kudeatzailearen partez.

{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: kontuaren baieztatzea';
$string['emailconfirmsent'] = '<p>E-posta mezu bat bidali dugu zure hurrengo helbide honetara: <b>{$a}</b></p>
   <p>Izena ematen amaitzeko argibide erraz batzuk ditu.</p>
   <p>Arazorik baduzu, jarri harremanetan kudeatzailearekin.</p>';
$string['emaildigest'] = 'Foroetako mezuak e-postaz nola jaso';
$string['emaildigestcomplete'] = 'Osoa (egunero e-posta mezu guztiekin)';
$string['emaildigestoff'] = 'Foroetako mezu bakoitzeko e-posta mezu bat jaso';
$string['emaildigestsubjects'] = 'Gaiak (egunero e-posta batean gaiak baino ez)';
$string['emaildisable'] = 'E-posta helbidea desgaituta dago';
$string['emaildisableclick'] = 'Sakatu hemen helbide honetara inongo e-postarik ez bidaltzeko';
$string['emaildisplay'] = 'E-posta erakutsi';
$string['emaildisplaycourse'] = 'Nire e-posta helbidea nire ikastaro-kideei soilik erakutsi';
$string['emaildisplayhidden'] = 'E-posta ezkutuan';
$string['emaildisplayno'] = 'Nire e-posta helbidea mundu guztiari ezkutatu';
$string['emaildisplayyes'] = 'Edonori nire e-posta helbidea ikusten utzi';
$string['emailenable'] = 'Erabili e-posta helbide hau';
$string['emailenableclick'] = 'Sakatu hemen helbide honetara e-postak bidali ahal izateko';
$string['emailexists'] = 'E-posta helbide hau erregistratzeko erabilita dago dagoeneko.';
$string['emailformat'] = 'E-postaren formatua';
$string['emailmustbereal'] = 'Oharra: zure e-posta helbideak benetakoa izan behar du';
$string['emailnotallowed'] = 'Domeinu hauetako e-posta helbideak ez dira onartzen ({$a})';
$string['emailnotfound'] = 'Ez da e-posta helbidea datu-basean aurkitu';
$string['emailonlyallowed'] = 'E-posta helbide hau ez da onartzen ({$a})';
$string['emailpasswordchangeinfo'] = 'Kaixo {$a->firstname},

Norbaitek (zeuk ziurrenik) zure \'{$a->sitename}\' konturako pasahitz berria eskatu du.

Zure pasahitza aldatzeko, jo helbide honetara:

{$a->link}

E-posta programa gehienetan, esteka urdina izango da lotura hau eta sakatu egin ahal izango diozu. Ez badabil,
helbidea kopiatu eta pegatu nabigatzailearen helbide barran.

Laguntza gehiago behar baduzu, mesedez jar zaitez harremanetan guneko kudeatzailerekin,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Kaixo {$a->firstname},

Norbaitek (zeuk ziurrenik) zure \'{$a->sitename}\' konturako pasahitz berria eskatu du.

Tamalez, gune honetako zure kontua kendu egin da eta ezin da berriz ezarri. Mesedez, jarri harremanetan gunearen kudeatzailearekin,
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Kaixo {$a->firstname},

Norbaitek (zeuk ziurrenik) zure \'{$a->sitename}\' konturako pasahitz berria eskatu du.

Tamalez pasahitzak ezin dira aldatu gune honetan. Mesedez, jarri harremanetan gunearen kudeatzailearekin,
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Pasahitzari buruzko informazioa aldatu';
$string['emailpasswordconfirmation'] = 'Kaixo, {$a->firstname}.

Zure konturako pasahitz berriaren eskaria jaso dugu \'{$a->sitename}\'.

Prozesua amaitu eta pasahitz berria e-postaz jaso ahal izateko,
helbide honetara jo, mesedez:

{$a->link}

E-posta aplikazio gehienetan aurreko
esteka urdinez azalduko da, gainean
klik egin dezazun.
Hala ez balitz, esteka ebaki eta zure
nabigatzailearen helbideen leihoan itsasi.

Bestelako laguntzarik behar izanez gero,
kudeatzailearekin harremanetan jarri, {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: pasahitz-aldaketaren baieztatzea';
$string['emailpasswordconfirmmaybesent'] = '<p>Erabiltzaile-izen edo helbide zuzena eman baduzu e-postaz mezua jaso behar izan duzu</p>
<p>Pasahitza-aldaketa baieztatu eta egiteko argibide errazak ditu. Arazorik bazenu, mesedez gunearen kudeatzailearekin  harremanetan jarri.</p>';
$string['emailpasswordconfirmsent'] = 'Zure helbidera mezu bat bidali dugu <b>{$a}</b>.
<br />Mezu honek pasahitza-aldaketa egin eta baieztatzeko argibide errazak ditu.
Arazorik bazenu, mesedez gunearen kudeatzailearekin harremanetan jarri.';
$string['emailpasswordsent'] = 'Mila esker pasahitz aldaketa baieztatzeagatik. Zure pasahitz berria kontu honetara bidali dizugu: <br /><b>{$a->email}</b>.<br />
Pasahitz berria automatikoki sortu da. Agian, <a href="{$a->link}">zure pasahitza aldatu</a> nahiko duzu eta gogoratzeko errazagoa den beste bat ezarri.';
$string['emailresetconfirmationsubject'] = '{$a}: pasahitza berrezartzeko eskaria';
$string['emptydragdropregion'] = 'lurraldea hutsik dago';
$string['enable'] = 'Gaitu';
$string['encryptedcode'] = 'Enkriptaturiko kodea';
$string['english'] = 'Ingelesa';
$string['enrolmentmethods'] = 'Matrikulazio-metodoak';
$string['entercourse'] = 'Ikastaro honetan sartzeko hemen egin klik';
$string['enteremail'] = 'Idatzi zure e-posta helbidea';
$string['enteremailaddress'] = 'Zeure helbide elektronikoa idatzi, mesedez zure pasahitza eguneratzeko. Pasahitz berria bidaliko dizugu.';
$string['enterusername'] = 'Idatzi zure erabiltzaile-izena';
$string['entries'] = 'Sarrerak';
$string['error'] = 'Errorea';
$string['errorcreatingactivity'] = 'Ezin izan da sortu \'{$a}\' zeregin berria';
$string['errorfiletoobig'] = 'Fitxategia {$a} byteko muga baino handiagoa da';
$string['errornouploadrepo'] = 'Gune honetan ez da gaitu fitxategiak igotzeko biltegirik';
$string['errorwhenconfirming'] = 'Ezin izan duzu kontua baieztatu ondorengo erroreagatik. Seguruenez hona ailegatzeko sakatu zenuen lotura edo esteka ez zegoen osorik.
Begiratu ondo jaso zenuen e-posta eta, kopiatu/itsasi erabiliz, lotura osoa ekarri nabigatzailearen helbide-barrara.';
$string['eventcontentviewed'] = 'Edukia ikusi da';
$string['eventcoursecategorydeleted'] = 'Kategoria ezabatu da';
$string['eventcoursecontentdeleted'] = 'Ikastaro-edukia ezabatu da';
$string['eventcoursecreated'] = 'Ikastaroa sortu da';
$string['eventcoursedeleted'] = 'Ikastaroa ezabatu da';
$string['eventcoursemodulecreated'] = 'Ikastaro-modulua sortu da';
$string['eventcoursemoduledeleted'] = 'Ikastaro-modulua ezabatu da';
$string['eventcoursemoduleupdated'] = 'Ikastaro-modulua eguneratu da';
$string['eventcourseresetended'] = 'Ikastaroaren berrabiaraztea amaitu da';
$string['eventcourseresetstarted'] = 'Ikastaroaren berrabiaraztea hasi da';
$string['eventcourserestored'] = 'Ikastaroa berreskuratu da';
$string['eventcoursesectionupdated'] = 'Ikastaroaren atalak eguneratu dira';
$string['eventcourseupdated'] = 'Ikastaroa eguneratu da';
$string['eventusercreated'] = 'Erabiltzailea sortu da';
$string['eventuserdeleted'] = 'Erabiltzailea ezabatu da';
$string['eventuserlistviewed'] = 'Erabiltzaile-zerrenda ikusi da';
$string['eventuserloggedout'] = 'Erabiltzaileak saioa amaitu du';
$string['eventuserprofileviewed'] = 'Erabiltzaile-profila ikusi da';
$string['eventuserupdated'] = 'Erabiltzailea eguneratu da';
$string['everybody'] = 'Denak';
$string['executeat'] = 'Noiz egikaritu:';
$string['existing'] = 'Badena';
$string['existingadmins'] = 'Dauden kudeatzaileak';
$string['existingcourse'] = 'Dauden ikastaroak';
$string['existingcourseadding'] = 'Ikastaroa badago, informazioa eransten';
$string['existingcoursedeleting'] = 'Ikastaroa badago, lehena ezabatzen';
$string['existingcreators'] = 'Sortzaileak badira';
$string['existingstudents'] = 'Izena emandako ikasleak';
$string['existingteachers'] = 'Dauden irakasleak';
$string['expand'] = 'Zabaldu';
$string['expandall'] = 'Zabaldu guztia';
$string['expandcategory'] = 'Zabaldu {$a}';
$string['explanation'] = 'Azalpena';
$string['extendenrol'] = 'Matrikulazioa luzatu (banakakoa)';
$string['extendperiod'] = 'Luzapen-epea';
$string['failedloginattempts'] = '{$a->attempts} azken sarreratik sarrera okerren kopurua';
$string['failedloginattemptsall'] = '{$a->attempts} sarrera okerrak kontu hauetarako: {$a->accounts}';
$string['feedback'] = 'Feedbacka';
$string['file'] = 'Fitxategia';
$string['fileexists'] = 'Dagoeneko badago {$a} izena duen fitxategi bat';
$string['filemissing'] = '{$a} falta da';
$string['files'] = 'Fitxategiak';
$string['filesanduploads'] = 'Fitxategiak eta igoerak';
$string['filesfolders'] = 'Fitxategiak/karpetak';
$string['filetoolarge'] = 'handiegia da igotzeko';
$string['fileuploadwithcontent'] = 'Fitxategi-igoerek ez lukete izan beharko eduki-parametroa';
$string['filloutallfields'] = 'Mesedez, bete formulario honetako eremu guztiak';
$string['filter'] = 'Iragazkia';
$string['findmorecourses'] = 'Bilatu ikastaro gehiago...';
$string['first'] = 'Lehena';
$string['firstaccess'] = 'Lehen sarrera';
$string['firstname'] = 'Izena';
$string['firstnamephonetic'] = 'Izena- fonetikoa';
$string['firstsiteaccess'] = 'Lehen sarrera gunera';
$string['firsttime'] = 'Hau al da zure lehen aldia hemen?';
$string['folder'] = 'Karpeta';
$string['folderclosed'] = 'Karpeta itxia';
$string['folderopened'] = 'Karpeta irekia';
$string['followingoptional'] = 'Hurrengo elementuak aukerazkoak dira';
$string['followingrequired'] = 'Hurrengo elementuak beharrezkoak dira';
$string['force'] = 'Behartu';
$string['forcelanguage'] = 'Behartu hizkuntza';
$string['forceno'] = 'Ez behartu';
$string['forcepasswordchange'] = 'Behartu pasahitza aldatzera';
$string['forcepasswordchangecheckfull'] = 'Ziur al zaude pasahitza aldatzea behartu nahi duzula {$a}-rentzat?';
$string['forcepasswordchange_help'] = 'Laukitxoa markatuta, erabiltzaileari pasahitza aldatzeko proposatuko zaio sartzen den hurrengoan.';
$string['forcepasswordchangenot'] = '{$a} ezin da behartu pasahitza aldatzera';
$string['forcepasswordchangenotice'] = 'Jarraitzeko zure pasahitza aldatu behar duzu.';
$string['forcetheme'] = 'Itxura behartu';
$string['forgotaccount'] = 'Pasahitza galdu duzu?';
$string['forgotten'] = 'Zure erabiltzaile-izena edo pasahitza ahaztu dituzu?';
$string['forgottenduplicate'] = 'E-posta helbide bera dute hainbat kontuk. Mesedez, erabili erabiltzaile-izena horren ordez.';
$string['forgotteninvalidurl'] = 'Pasahitzak ez du balio, URLa berrabiarazi';
$string['format'] = 'Formatua';
$string['format_help'] = 'Ikastaro-formatuak ikastaroaren hasiera-orriaren diseinua zehazten du.

* Jarduera bakarreko formatua - Jarduera edo baliabide bakarra erakusteko (galdetegi bat edo SCORM pakete bat adibidez) ikastaroaren orrian.
* Formatu irekia -  Formatu hau hasierako orrian agertzen den foro irekiari begira eginda dago.
* Gai-formatua - Ikastaroaren hasiera-orria gaika edo atalka dago antolatuta
* Aste-formatua - Ikastaroa asteka antolatuta dago, hasiera- eta amaiera-data zehatzak dituela.';
$string['formathtml'] = 'HTML formatua';
$string['formatmarkdown'] = 'Markdown formatua';
$string['formatplain'] = 'Testu laua';
$string['formattext'] = 'Moodle formatu automatikoa';
$string['formattexttype'] = 'Formatua eman';
$string['framesetinfo'] = 'Dokumentu honek hau du:';
$string['from'] = 'Noiztik';
$string['frontpagecategorycombo'] = 'Ikastaro eta kategorien zerrenda';
$string['frontpagecategorynames'] = 'Kategorien zerrenda';
$string['frontpagecourselist'] = 'Ikastaroen zerrenda';
$string['frontpagedescription'] = 'Hasiera-orriaren deskribapena';
$string['frontpagedescriptionhelp'] = 'Gunearen deskribapen hau hasiera-orrian agertu daiteke ikastaro/guneko laburpen-blokea erabilita edo hasiera-orrian gai bat gehituta.';
$string['frontpageenrolledcourselist'] = 'Matrikulatutako ikastaroak';
$string['frontpageformat'] = 'Hasiera-orriaren formatua';
$string['frontpageformatloggedin'] = 'Hasiera-orriaren formatua sartzean';
$string['frontpagenews'] = 'Azken albisteak erakutsi';
$string['frontpagesettings'] = 'Hasiera-orriaren ezarpenak';
$string['fulllistofcourses'] = 'Ikastaro guztiak';
$string['fullname'] = 'Izen osoa';
$string['fullnamecourse'] = 'Ikastaroaren izen osoa';
$string['fullnamecourse_help'] = 'Ikastaroaren izen osoa ikastaroko orri bakoitzaren goiko aldean eta ikastaroen zerrendan  erakutsiko da.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Erabiltzailearen izen osoa';
$string['fullprofile'] = 'Profil osoa';
$string['fullsitename'] = 'Gunearen izen osoa';
$string['functiondisabled'] = 'Hau ez dabil';
$string['general'] = 'Orokorra';
$string['geolocation'] = 'latitudea - longitudea';
$string['gettheselogs'] = 'Erregistro hauek lortu';
$string['go'] = 'Joan';
$string['gpl'] = 'Copyright (C) 1999tik aurrera  Martin Dougiamas  (http://moodle.com)

Programa hau doako softwarea da. Berriz banatu
edo eta alda dezakezu, beti ere GNU General Public License lizentziaren arabera, The Free Software Foundation-en argitalpenaren arabera; baita 2. bertsioaren edo ondorengo baten arabera ere.

Aplikazioa erabilgarria izango zaizulakoan banatzen da,
baina INOLAKO BERMERIK GABE; ezta MERKATAL-BANAKETA
edo ASMO PARTIKULAR BATEN EGOKITZAPENAren bermerik ere.

Informazio zehatzagoa izateko Moodle Lizentziaren informazio orria ikusi:
http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

Programa hau software librea da: banatu edota aldatu egin dezakezu Free Software Foundation-ek GNU Lizentzia Publiko Orokorra argitaratutako baldintzetan, edo Lizentziaren 3. bertsioaren, edo (zeuk aukeratu) beste edozein bertsioarenean.

Programa hau erabilgarri izateko helburuarekin banatzen da, baina INONGO BERMERIK GABE; ezta KOMERTZIALITU edo BESTE EDOZEIN HELBURU JAKINerako BERMERIK gabe ere.

Begiratu Moodle Lizentziaren informazio-orria zehaztasun gehiagorako: http://docs.moodle.org/eu/Lizentzia';
$string['gpllicense'] = 'GPL Lizentzia';
$string['grade'] = 'Kalifikazioa';
$string['grades'] = 'Kalifikazioak';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatarra</a> gaitu da gune honetan. Profilerako irudia igotzen ez baduzu, Moodle saiatuko da irudi bat kargatzen zure Gravatar-etik.';
$string['group'] = 'Taldea';
$string['groupadd'] = 'Talde berria gehitu';
$string['groupaddusers'] = 'Aukeratutakoa taldera gehitu';
$string['groupextendenrol'] = 'Guztientzako matrikulazioa zabaldu';
$string['groupfor'] = 'taldearentzat';
$string['groupinfo'] = 'Aukeratutako taldeari buruzko informazioa';
$string['groupinfoedit'] = 'Editatu taldearen ezaugarriak';
$string['groupinfomembers'] = 'Aukeratutako partaideei buruzko informazioa';
$string['groupinfopeople'] = 'Aukeratutako pertsonei buruzko informazioa';
$string['groupmembers'] = 'Tadekideak';
$string['groupmemberssee'] = 'Taldekideak erakutsi';
$string['groupmembersselected'] = 'Aukeratutako taldeko kideak';
$string['groupmode'] = 'Taldeak egin ala ez';
$string['groupmodeforce'] = 'Talde-modua behartu';
$string['groupmy'] = 'Nire taldea';
$string['groupnonmembers'] = 'Taldean ez daudenak';
$string['groupnotamember'] = 'Barkatu,  baina ez zara talde horretako kide';
$string['grouprandomassign'] = 'Talde guztiei ausaz egokitu';
$string['groupremove'] = 'Aukeratutako taldea ezabatu';
$string['groupremovemembers'] = 'Aukeratutako partaideak ezabatu';
$string['groups'] = 'Taldeak';
$string['groupsnone'] = 'Talderik ez';
$string['groupsseparate'] = 'Taldeek ezin elkar ikusi';
$string['groupsvisible'] = 'Taldeek elkar ikusten dute';
$string['guest'] = 'Bisitaria';
$string['guestdescription'] = 'Bisitariek oso baimen gutxi dute eta ezin dute ia inon idatzi.';
$string['guestskey'] = 'Giltzadun bisitariak onartu';
$string['guestsno'] = 'Bisitariei sarrera ukatu';
$string['guestsnotallowed'] = 'Barkatu, \'{$a}\' ikastaroak ez die bisitariei sartzen uzten.';
$string['guestsyes'] = 'Giltza gabeko bisitariak onartu';
$string['guestuser'] = 'Bisitaria';
$string['guestuserinfo'] = 'Erabiltzaile hau berezia da eta ikastaro batzuetan soilik begiratzera sartzea uzten die.';
$string['help'] = 'Laguntza';
$string['helpprefix2'] = 'Laguntza {$a}-rekin';
$string['helpwiththis'] = 'Laguntza honekin:';
$string['hiddenassign'] = 'Ezkutatu esleipena';
$string['hiddenfromstudents'] = 'Ezkutuan ikasleentzat';
$string['hiddensections'] = 'Ezkutuko atalak';
$string['hiddensectionscollapsed'] = 'Ezkutuko atalak laburtuta erakutsi';
$string['hiddensections_help'] = 'Ezarpen honek ikasleei ikastaroaren ezkutuko atalak ikasleei
modu kolapsatuan (astekako ikastaro batean oporrak adierazteko, adibidez) edo guztiz ezkuan erakutsiko zaizkien
zehazten du.';
$string['hiddensectionsinvisible'] = 'Ezkutuko atalak ez erakutsi inola ere';
$string['hide'] = 'Ezkutatu';
$string['hideadvancedsettings'] = 'Ezarpena aurreratuak ezkutatu';
$string['hidepicture'] = 'Ezkutatu irudia';
$string['hidesection'] = 'Ezkutatu {$a} atala';
$string['hidesettings'] = 'Ezarpenak ezkutatu';
$string['hideshowblocks'] = 'Ezkutatu edo erakutsi blokeak';
$string['hits'] = 'Agerraldiak';
$string['hitsoncourse'] = '{$a->coursename} ikastaroan {$a->username} -(e)k egindako agerraldiak';
$string['hitsoncoursetoday'] = 'Gaur {$a->coursename} ikastaroan {$a->username} -(e)k egindako agerraldiak';
$string['home'] = 'Hasiera';
$string['hour'] = 'ordu';
$string['hours'] = 'ordu(ak)';
$string['howtomakethemes'] = 'Itxura berriak nola egin';
$string['htmleditor'] = 'Erabili HTML editorea';
$string['htmleditoravailable'] = 'Richtext editorea eskuragarri dago';
$string['htmleditordisabled'] = 'Zure erabiltzaile profilean Richtext editorea desgaitu duzu';
$string['htmleditordisabledadmin'] = 'Kudeatzaileak Richtext editorea desgaitu du gune honetan';
$string['htmleditordisabledbrowser'] = 'Richtext editorea ez dago eskuragarri ez duzulako Internet Explorer 5.5 edo berriagorik erabiltzen';
$string['htmlfilesonly'] = 'HTML fitxategiak baino ez';
$string['htmlformat'] = 'HTML formatua';
$string['icon'] = 'Ikonoa';
$string['icqnumber'] = 'ICQ zenbakia';
$string['idnumber'] = 'ID zenbakia';
$string['idnumbercourse'] = 'Ikastaroaren ID zenbakia';
$string['idnumbercoursecategory'] = 'Kategoriaren ID zenbakia';
$string['idnumbercoursecategory_help'] = 'Ikastaro kategoriaren ID zenbakia bakarrik erabiltzen da kategoria parekatzeko kanpoko sistemetan, eta gunean ez da inon erakusten. Kategoriak kode ofiziala badu, hemen sar dezakezu; bestela, eremua hutsik utz dezakezu.';
$string['idnumbercourse_help'] = '<p>Ikastaro baten ID zenbakia ikastaro hori kanpo-sistema batekin erkatzen denean baino ez da erabiltzen - hau ez da inoiz Moodle barruan erakusten. Ikastaroak kode ofiziala baldin badu, hemen erabili, bestela zuri utzi.</p>';
$string['idnumbergroup'] = 'Taldearen ID zenbakia';
$string['idnumbergroup_help'] = 'Taldearen ID zenbakia bakarrik erabiltzen da taldea parekatzeko kanpoko sistemetan, eta gunean ez da inon erakusten. Taldeak kode ofiziala badu, hemen sar dezakezu; bestela, eremua hutsik utz dezakezu.';
$string['idnumbergrouping'] = 'Taldekatzearen ID zenbakia';
$string['idnumbergrouping_help'] = 'Taldekatzearen ID zenbakia bakarrik erabiltzen da taldekatzea parekatzeko kanpoko sistemetan, eta gunean ez da inon erakusten. Taldekatzeak kode ofiziala badu, hemen sar dezakezu; bestela, eremua hutsik utz dezakezu.';
$string['idnumbermod'] = 'ID zenbakia';
$string['idnumbermod_help'] = 'ID zenbaki bat ezarrita jarduera identifikatzeko modua izango duzu kalifikazioak kalkulatzeko orduan. Jarduera ez badago inongo kalifikazio-kalkulutan sartuta, ID zenbakiaren eremua hutsik utzi ahal da.
ID zenbakia kalifikazio-liburuko kalifikazioen kalkulua editatzeko orrian ere ezar daiteke, nahiz eta jarduera eguneratzeko orritik bakarrik editatu ahal den.';
$string['idnumbertaken'] = 'ID zenbaki hau dagoeneko erabilita dago';
$string['imagealt'] = 'Irudiaren deskribapena';
$string['import'] = 'Inportatu';
$string['importdata'] = 'Inportatu ikastaroko datuak';
$string['importdataexported'] = 'Ikastaroko datuak ondo esportatu dira.<br />Zure ikastarora inportatzen jarraitu.';
$string['importdatafinished'] = 'Inportazioa ondo burutua da! Segi zure ikastarora!';
$string['importdatafrom'] = 'Hemengo datuak inportatzeko ikastaroa aurkitu:';
$string['inactive'] = 'Indarge';
$string['include'] = 'Sartu';
$string['includeallusers'] = 'Erabiltzaile guztiak sartu';
$string['includecoursefiles'] = 'Ikastaroko fitxategiak sartu';
$string['includecourseusers'] = 'Ikastaroko erabiltzaileak sartu';
$string['included'] = 'Barne dago';
$string['includelogentries'] = 'Erregistro-sarrerak barne';
$string['includemodules'] = 'Moduluak sartu';
$string['includemoduleuserdata'] = 'Moduluaren erabiltzailearen datuak sartu';
$string['includeneededusers'] = 'Behar diren erabiltzaileak sartu';
$string['includenoneusers'] = 'Ez sartu erabiltzailerik';
$string['includeroleassignments'] = 'Rol-esleipenak barne ditu';
$string['includesitefiles'] = 'Ikastaro honetan erabilitako guneko fitxategiak sartu';
$string['includeuserfiles'] = 'Erabiltzaileen fitxategiak sartu';
$string['increasesections'] = 'Handitu atal-kopurua';
$string['info'] = 'Informazioa';
$string['institution'] = 'Erakundea';
$string['instudentview'] = 'ikaslearen ikuspegian';
$string['interests'] = 'Interesguneak';
$string['interestslist'] = 'Interesgune-zerrenda';
$string['interestslist_help'] = 'Idatzi zure intereseko gaiak komaz banatuta. Gai hauek etiketa formaz erakutsiko dira zure profil-orrian.';
$string['invalidemail'] = 'E-posta helbide baliogabea';
$string['invalidlogin'] = 'Saio-hasiera baliogabea, saiatu berriz, mesedez';
$string['invalidusername'] = 'Erabiltzaile-izenak karaktere alfanumerikoak, beheko gidoia (_), gidoia (-), puntua (.) eta a bildua (@) bakarrik izan ditzake.';
$string['invalidusernameupload'] = 'Erabiltzaile-izen baliogabea';
$string['ip_address'] = 'IP helbidea';
$string['jump'] = 'Joan';
$string['jumpto'] = 'Joan hona...';
$string['keep'] = 'Mantendu';
$string['keepsearching'] = 'Segi bilatzen';
$string['langltr'] = 'Hizkuntzaren norabidea ezkerretik eskumara';
$string['langrtl'] = 'Hizkuntzaren norabidea eskumatik ezkerrera';
$string['language'] = 'Hizkuntza';
$string['languagegood'] = 'Hizkuntza pakete hau egunean dago! :-)';
$string['last'] = 'Azkena';
$string['lastaccess'] = 'Azken sarrera';
$string['lastcourseaccess'] = 'Azken sarrera ikastarora';
$string['lastedited'] = 'Azken edizioa';
$string['lastlogin'] = 'Azken saio-hasiera';
$string['lastmodified'] = 'Azken aldaketa';
$string['lastname'] = 'Deitura';
$string['lastnamephonetic'] = 'Deitura - fonetikoa';
$string['lastsiteaccess'] = 'Azken sarrera gunera';
$string['lastyear'] = 'Azken urtea';
$string['latestlanguagepack'] = 'Bilatu hizkuntza-fitxategi berrienak moodle.org-en';
$string['layouttable'] = 'Eskema-taula';
$string['leavetokeep'] = 'Zurian utzi orain duzun pasahitza mantentzeko';
$string['legacythemeinuse'] = 'Gunea era bateragarrian erakutsiko zaizu zure nabigatzailea zaharregia delako.';
$string['license'] = 'Lizentzia';
$string['licenses'] = 'Lizentziak';
$string['liketologin'] = 'Erabiltzaile-kontuarekin sartu nahi al duzu orain?';
$string['list'] = 'Zerrendatu';
$string['listfiles'] = 'Fitxategien zerrenda  {$a}-(e)an';
$string['listofallpeople'] = 'Partaide guztien zerrenda';
$string['listofcourses'] = 'Ikastaroen zerrenda';
$string['loadinghelp'] = 'Kargatzen...';
$string['local'] = 'Lokala';
$string['localplugins'] = 'Plugin lokalak';
$string['localpluginsmanage'] = 'Plugin lokalak kudeatu';
$string['location'] = 'Kokapena';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = '{$a} barruan da';
$string['loggedinasguest'] = 'Bisitari gisa ari zara';
$string['loggedinnot'] = 'Ez zara oraindik sartu.';
$string['login'] = 'Sartu';
$string['loginalready'] = 'Honez gero sisteman zaude';
$string['loginas'] = 'Honela sartu';
$string['loginaspasswordexplain'] = '<p> "loginas password" berezia sartu behar duzu ezaugarri hau erabiltzeko.<br />Ez badakizu, galdetu zerbitzari-administratzaileari.</p>';
$string['login_failure_logs'] = 'Sarrera okerren agerraldiak';
$string['loginguest'] = 'Bisitari gisa sartu';
$string['loginsite'] = 'Gunean sartu';
$string['loginsteps'] = 'Kaixo!

Edozein ikastarotara sartzeko web-gune honetako erabiltzaile izan behar duzu
eta horretarako kontu bat sortu behar duzu.

Nola sortu kontu berria:
<ol>
<li>Sakatu lotura honetan <a href="{$a}">KONTU BERRIA</a> eta formularioa bete zure datuekin.</li>
<li>E-posta mezu bat bidaliko dugu berehala zure e-posta helbidera.</li>
<li>Mezua irakurri eta agertzen den loturan klik egin.</li>
<li>Zure kontua berretsi eta barruan izango zara.</li>
<li>Orduan, nahi duzun ikastaroa aukeratu.</li>
<li>"Partaide-giltza" bat eskatzen badizu, erabili matrikulatutakoan eman zizutena</li>
<li>Kontu berria sortutakoan, eta zenbait kasutan matrikula egindakoan, ikastarorako sarbidea izango duzu.</li>
<li>Hemendik aurrera zure erabiltzaile-izena eta pasahitza besterik ez dituzu sartu beharko hasiera orrian zeure ikastaroan parte hartzeko.</li>
</ol>';
$string['loginstepsnone'] = '<p>Kaixo!</p>
<p>Ikastaroetan sarrera-eskubide osoa izateko zuretzat kontu bat sortu beharko duzu.</p>
<p>Egin behar duzun guztia erabiltzaile izen eta pasahitz bat sortzea da eta
formulario honetan jartzea!</p>
<p>Beste inork aukeratu badu dagoeneko zure erabiltzaile izena, beste izen bat erabiliz saiatu beharko duzu.</p>';
$string['loginto'] = '{$a} gunean sartu';
$string['logout'] = 'Irten';
$string['logoutconfirm'] = 'Irten egin nahi al duzu benetan?';
$string['logs'] = 'Agerraldiak';
$string['logtoomanycourses'] = '[<a href="{$a->url}">gehiago</a> ]';
$string['logtoomanyusers'] = '[<a href="{$a->url}">gehiago</a> ]';
$string['lookback'] = 'Epea';
$string['mailadmins'] = 'Kudeatzaileei informatu';
$string['mailstudents'] = 'Ikasleei informatu';
$string['mailteachers'] = 'Irakasleei informatu';
$string['maincoursepage'] = 'Ikastaroaren hasiera-orria';
$string['makeafolder'] = 'Sortu karpeta';
$string['makeeditable'] = '\'{$a}\' web-zerbitzariak (Apache-k adibidez) editatzeko modukoa bihurtzen baduzu, fitxategi hau zuzenean editatu ahal izango duzu orri honetatik.';
$string['makethismyhome'] = 'Markatu hau nire berezko hasiera-orri gisa';
$string['manageblocks'] = 'Blokeak';
$string['managecategorythis'] = 'Kudeatu kategoria hau';
$string['managecourses'] = 'Ikastaroak kudeatu';
$string['managedatabase'] = 'Datu-basea';
$string['manageeditorfiles'] = 'Editoreak erabilitako fitxategiak kudeatu';
$string['managefilters'] = 'Iragazkiak';
$string['managemodules'] = 'Moduluak';
$string['manageroles'] = 'Rolak eta baimenak';
$string['markedthistopic'] = 'Gai hau oraingo gisa dago nabarmendua';
$string['markthistopic'] = 'Gai hau oraingoa gisa nabarmendu';
$string['matchingsearchandrole'] = '\'{$a->search}\' kointzidentziak eta  {$a->role}';
$string['maxfilesize'] = 'Gehienezko tamaina fitxategi berrietarako: {$a}';
$string['maxfilesreached'] = '{$a} fitxategi erantsi ahal diozu elementu honi gehienez';
$string['maximumchars'] = '{$a} karaktere gehienez';
$string['maximumgrade'] = 'Gehienezko kalifikazioa';
$string['maximumgradex'] = 'Gehienezko kalifikazioa: {$a}';
$string['maximumshort'] = 'Gehienez';
$string['maximumupload'] = 'Fitxategiak igotzeko gehienezko tamaina';
$string['maximumupload_help'] = 'Ezarpen honek ikastaro honetara igo daitezkeen fitxategien gehinezko tamaina zehazten du, kudeatzaileak ezarritako gunearen gehienezko tamainak mugatuta. Jarduera-modulu bakoitzean agertzen diren aldagaien tamaina ere muga daiteke.';
$string['maxnumberweeks'] = 'Gehienezko atal-kopurua';
$string['maxnumberweeks_desc'] = 'Atal-kopuruaren menu zabalgarriaren gehieneko balioa (bakarrik ikastaro formatu jakin batzuetan aplikatzen da).';
$string['maxnumcoursesincombo'] = 'Arakatu <a href="{$a->link}">{$a->numberofcourses} courses</a>.';
$string['maxsize'] = 'Gehienezko tamaina: {$a}';
$string['maxsizeandareasize'] = 'Fitxategi berrien gehieneko balio: {$a->size}, muga orokorra: {$a->areasize}';
$string['maxsizeandattachments'] = 'Gehienezko tamaina fitxategi berrietarako: {$a->size}, gehienezko eranskin-kopurua: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Fitxategi berrien gehieneko balioa: {$a->size}, gehieneko eranskin-kopurua: {$a->attachments}, muga orokorra: {$a->areasize}';
$string['memberincourse'] = 'Ikastaroko pertsonak';
$string['messagebody'] = 'Mezuaren gorputza';
$string['messagedselectedusers'] = 'Aukeratutako erabiltzaileei mezua bidali zaie eta hartzaileen zerrenda egokitu da.';
$string['messagedselectedusersfailed'] = 'Aukeratutako erabiltzaileei mezua bidaltzean zerbait gaizki joan da. Baliteke batzuek mezua jaso izana.';
$string['messageprovider:availableupdate'] = 'Eskuragarri dauden eguneraketen jakinarazpenak';
$string['messageprovider:backup'] = 'Segurtasun-kopien jakinarazpenak';
$string['messageprovider:badgecreatornotice'] = 'Domina-sortzailearen jakinarazpenak';
$string['messageprovider:badgerecipientnotice'] = 'Domina-jasotzailearen jakinarazpenak';
$string['messageprovider:courserequestapproved'] = 'Ikastaroa sortzeko eskariaren onarpen-jakinarazpena';
$string['messageprovider:courserequested'] = 'Ikastaroa sortzeko eskaria ukatzeko jakinarazpena';
$string['messageprovider:courserequestrejected'] = 'Ikastaroa sortzeko eskaria onartu ez izanaren jakinarazpena';
$string['messageprovider:errors'] = 'Errore larriak gunean';
$string['messageprovider:errors_help'] = 'Hauek errore garrantzitsuak dira eta kudeatzaileak hauen berri izan beharko luke.';
$string['messageprovider:instantmessage'] = 'Erabiltzaileen arteko mezu pertsonalak';
$string['messageprovider:instantmessage_help'] = 'Atal honek zehazten du zer gertatuko den guneko beste erabiltzaile batzuk zuri zuzenean bidalitako mezuekin.';
$string['messageprovider:notices'] = 'Errore arinei buruzko oharrak';
$string['messageprovider:notices_help'] = 'Kudeatzaile batek ikusi nahiko lituzkeen oharrak dira hauek.';
$string['messageselect'] = 'Erabiltzaile hau mezuaren hartzaile bezala aukeratu';
$string['messageselectadd'] = 'Mezua bidali';
$string['middlename'] = 'Bigarren izena';
$string['migratinggrades'] = 'Kalifikazioak migratzen';
$string['min'] = 'minutu';
$string['mins'] = 'minutu';
$string['minute'] = 'minutua';
$string['minutes'] = 'minutu';
$string['miscellaneous'] = 'Bestelakoak';
$string['missingcategory'] = 'Kategoria bat aukeratu behar duzu';
$string['missingcity'] = 'Hiria/Herria falta da';
$string['missingcountry'] = 'Herrialdea falta da';
$string['missingdescription'] = 'Deskribapena falta da';
$string['missingemail'] = 'E-posta helbidea falta da';
$string['missingfirstname'] = 'Izena falta da';
$string['missingfromdisk'] = 'Diskotik falta da';
$string['missingfullname'] = 'Izena eta deitura falta dira';
$string['missinglastname'] = 'Deitura falta da';
$string['missingname'] = 'Izena falta da';
$string['missingnewpassword'] = 'Pasahitz berria falta da';
$string['missingpassword'] = 'Pasahitza falta da';
$string['missingrecaptchachallengefield'] = 'reCAPTCHA falta da';
$string['missingreqreason'] = 'Arrazoia falta da';
$string['missingshortname'] = 'Izen laburra falta da';
$string['missingshortsitename'] = 'Gunearen izen laburra falta da';
$string['missingsitedescription'] = 'Gunearen deskribapena falta da';
$string['missingsitename'] = 'Gunearen izena falta da';
$string['missingstrings'] = 'Falta diren kateak egiaztatu';
$string['missingstudent'] = 'Zerbait aukeratu behar duzu';
$string['missingsummary'] = 'Laburpena falta da';
$string['missingteacher'] = 'Zerbait aukeratu behar duzu';
$string['missingurl'] = 'URLa falta da';
$string['missingusername'] = 'Erabiltzailearen izena falta da';
$string['modchooserdisable'] = 'Desaktibatu jarduera-hautatzailea';
$string['modchooserenable'] = 'Aktibatu jarduera-hautatzailea';
$string['moddoesnotsupporttype'] = '{$a->modname} moduluak ez ditu onartzen {$a->type} motako igoerak';
$string['modified'] = 'Aldatuta';
$string['moduleintro'] = 'Deskribapena';
$string['modulesetup'] = 'Moduluen taulak falta dira';
$string['modulesuccess'] = '{$a} taulak ondo ezarri dira';
$string['modulesused'] = 'Erabilitako moduluak';
$string['month'] = 'Hilabetea';
$string['months'] = 'Hilabeteak';
$string['moodledocs'] = 'Moodle Doc-ak';
$string['moodledocslink'] = 'Moodle Doc-ak orri honetarako';
$string['moodlerelease'] = 'Moodle-ren ezaugarriak';
$string['moodleversion'] = 'Moodle bertsioa';
$string['more'] = 'gehiago';
$string['morehelp'] = 'Laguntza gehiago';
$string['moreinformation'] = 'Informazio gehiago errore honi buruz';
$string['moreprofileinfoneeded'] = 'Mesedez, esaguzu gehiago zuri buruz';
$string['mostrecently'] = 'arestian';
$string['move'] = 'Mugitu';
$string['movecategoriessuccess'] = '{$a->count} kategoria(k) ondo mugitu d(ir)a \'{$a->to}\' kategoriara';
$string['movecategoriestotopsuccess'] = '{$a->count} kategoria(k) ondo mugitu d(ir)a goragoko mailara';
$string['movecategorycontentto'] = 'Mugitu hemen';
$string['movecategorysuccess'] = '\'{$a->moved}\' kategoria ondo mugitu da \'{$a->to}\' kategoriara';
$string['movecategoryto'] = 'Mugitu kategoria hona:';
$string['movecategorytotopsuccess'] = '\'{$a->moved}\' kategoria ondo mugitu da
goragoko mailara';
$string['movecontent'] = 'Mugitu {$a}';
$string['movecontentstoanothercategory'] = 'Edukiak beste kategoria batera mugitu';
$string['movecoursemodule'] = 'Mugitu baliabidea';
$string['movecoursesection'] = 'Mugitu atala';
$string['movecourseto'] = 'Mugitu ikastaroa hona:';
$string['movedown'] = 'Behera ekarri';
$string['movefilestohere'] = 'Fitxategiak hona mugitu';
$string['movefull'] = 'Mugitu {$a} hona';
$string['movehere'] = 'Mugitu hona';
$string['moveleft'] = 'Ezkerrera mugitu';
$string['moveright'] = 'Eskuinera mugitu';
$string['movesection'] = '{$a} atala mugitu';
$string['moveselectedcategoriesto'] = 'Mugitu aukeratutako kategoriak hona:';
$string['moveselectedcoursesto'] = 'Mugitu aukeratutako ikastaroak hona:';
$string['movetoanotherfolder'] = 'Mugitu beste karpeta batera';
$string['moveup'] = 'Gora eraman';
$string['msnid'] = 'ID MSN';
$string['mustchangepassword'] = 'Pasahitz berriak eta zaharrak ezberdin izan behar dute.';
$string['mustconfirm'] = 'Zure datuak berretsi behar dituzu';
$string['mycourses'] = 'Nire ikastaroak';
$string['myfiles'] = 'Nire fitxategi pribatuak';
$string['myfilesmanage'] = 'Nire fitxategi pribatuak kudeatu';
$string['myhome'] = 'Nire hasiera';
$string['mymoodledashboard'] = 'Nire Moodle-ren aginte-mahaia';
$string['myprofile'] = 'Nire profila';
$string['name'] = 'Izena';
$string['nameforlink'] = 'Zein izen eman nahi diozu esteka honi?';
$string['nameforpage'] = 'Izena';
$string['navigation'] = 'Nabigazioa';
$string['needed'] = 'Beharrezkoa';
$string['never'] = 'Inoiz ez';
$string['neverdeletelogs'] = 'Ez ezabatu inoiz agerraldiak';
$string['new'] = 'Berria';
$string['newaccount'] = 'Kontu berria';
$string['newcourse'] = 'Ikastaro berria';
$string['newpassword'] = 'Pasahitz berria';
$string['newpasswordfromlost'] = '<strong>OHARRA:</strong> <strong>Oraingo zure pasahitza</strong> bi mezuetatik <strong>bigarrengoan</strong> bidali zaizu galdutako pasahitzaren errekuperazio-prozesuan. Pantaila honekin jarraitu aurretik, pasahitza jaso duzula ziurtatu, mesedez.';
$string['newpassword_help'] = 'Utzi zuri oraingo pasahitza mantentzeko.';
$string['newpasswordtext'] = 'Kaixo {$a->firstname},

Zure kontuaren pasahitza \'{$a->sitename}\' gunean berezarri da eta behin behineko pasahitz berri bat ezarri dizugu.

Zure datu berriak ondorengoak dira:
erabiltzailea: {$a->username}
pasahitza: {$a->newpassword}

Pasahitza aldatu nahi baduzu, ondorengo helbidera joan:
{$a->link}

E-posta programa gehienetan goiko helbidea lotura urdin bat gisa agertu beharko litzateke eta zuk zuzenean klik egiteko aukera eman.
Horrela ez bada, helbidea kopiatu eta zure web nabigatzailearen goiko aldean dagoen helbide-barran itsasi.

Agur bero bat \'{$a->sitename}\' guneko kudeatzailearen partez,
{$a->signoff}';
$string['newpicture'] = 'Irudi berria';
$string['newpicture_help'] = 'Irudi berria gehitzeko, bilatu eta aukeratu irudia (JPG edo PNG formatuan) eta sakatu "Eguneratu profila"ri. Irudia alde batera kopiatuko da eta  100x100 pixeleko lauki batean sartuko da.';
$string['newsitem'] = 'berri bat';
$string['newsitems'] = 'berri';
$string['newsitemsnumber'] = 'Erakutsi beharreko albisteak';
$string['newsitemsnumber_help'] = 'Ezarpen honek ikastaroaren hasiera-orrian, azken berriak blokean zenbat berri agertuko diren zehazten du. "0 elementu" aukeratzen baduzu berrien kutxa ez da agertuko ere egingo.';
$string['newuser'] = 'Erabiltzaile berria';
$string['newusernewpasswordsubj'] = 'Erabiltzaile berriaren kontua';
$string['newusernewpasswordtext'] = 'Kaixo {$a->firstname},

Kontu berria ireki zaizu \'{$a->sitename}\'-(e)n eta behin behineko pasahitza ezarri zaizu.

Sartzeko informazioa hauxe duzu:
erabiltzailea: {$a->username}
pasahitza:{$a->newpassword}
(aldatu egin beharko duzu pasahitza lehen aldiz sartzen zarenean)

\'{$a->sitename}\' erabiltzen hasteko, sakatu {$a->link}

E-posta programa gehienetan, sakatu beharreko esteka urdina agertzen da. Ez bada horrela agertzen, kopiatu helbidea eta itsasi nabigatzailearen helbide-barran.

Jaso \'{$a->sitename}\' gunearen kudeatzailearen agur bero bat.

{$a->signoff}';
$string['newusers'] = 'Erabiltzaile berriak';
$string['newwindow'] = 'Leiho berria';
$string['next'] = 'Hurrengoa';
$string['nextsection'] = 'Hurrengo atala';
$string['no'] = 'Ez';
$string['noblockstoaddhere'] = 'Ez dago orri honetara gehi dezakezun blokerik.';
$string['nobody'] = 'Inor ez';
$string['nochange'] = 'Ez dago aldaketarik';
$string['nocomments'] = 'Iruzkinik ez';
$string['nocourses'] = 'Ez dago ikastarorik';
$string['nocoursesfound'] = '\'{$a}\' hitza duen ikastarorik ez dago';
$string['nocoursesyet'] = 'Ez dago ikastarorik kategoria honetan';
$string['nodstpresets'] = 'Kudeatzaileak Daylight Savings Time aukera ez du indarrean jarri';
$string['nofilesselected'] = 'Berreskuratzeko fitxategirik aukeratu gabe';
$string['nofilesyet'] = 'Ez da fitxategirik igo zure ikastarora oraindik';
$string['nograde'] = 'Kalifikaziorik ez';
$string['nohelpforactivityorresource'] = 'Une honetan ez dago baliabide edo jarduera horrekin lotutako laguntzarik';
$string['noimagesyet'] = 'Ez da irudirik igo zure ikastarora oraindik';
$string['nologsfound'] = 'Ez da erregistrorik aurkitu';
$string['nomatchingusers'] = 'Ez da \'{$a}\' erabiltzailerik aurkitu';
$string['nomorecourses'] = 'Ezin ikastaro gehiago aurkitu bilaketaren arabera';
$string['nomoreidnumber'] = 'ID zenbakirik ez da erabiltzen arazoak saihesteko';
$string['none'] = 'Bat ere ez';
$string['noneditingteacher'] = 'Edizio-baimenik gabeko irakaslea';
$string['noneditingteacherdescription'] = 'Editatzeko baimenik gabeko irakasleek ikastaroetan irakats dezakete eta ikasleak kalifikatu baina ezin dituzte jarduerak aldatu.';
$string['nonstandard'] = 'Ez-estandarra';
$string['nopendingcourses'] = 'Ez dago onartu gabeko ikastarorik';
$string['nopotentialadmins'] = 'Ez dago kudeatzaile posiblerik';
$string['nopotentialcreators'] = 'Ez dago ikastaro-sortzaile posiblerik';
$string['nopotentialstudents'] = 'Ez dago ikasle posiblerik';
$string['nopotentialteachers'] = 'Ez dago irakasle posiblerik';
$string['norecentactivity'] = 'Ez dago duela gutxiko aktibitaterik';
$string['noreplybouncemessage'] = '\'no-reply\' helbide batera erantzun duzu. Foro bateko mezuari erantzuten saiatu bazara, mesedez, erantzun {$a} foroa erabiliz.

Hau da zure mezuaren edukia:';
$string['noreplybouncesubject'] = '{$a} - hartzaileari itzulitako mezua.';
$string['noreplyname'] = 'Ez erantzun mezu honi';
$string['noresults'] = 'Emaitzarik ez';
$string['normal'] = 'Arrunta';
$string['normalfilter'] = 'Bilaketa arrunta';
$string['nosite'] = 'Ez da aurkitu gune mailako ikastarorik';
$string['nostudentsfound'] = 'Ez da {$a} aurkitu';
$string['nostudentsingroup'] = 'Ikaslerik ez oraindik talde honetan';
$string['nostudentsyet'] = 'Ez dago ikaslerik ikastaro honetan oraindik';
$string['nosuchemail'] = 'Ez dago horrelako e-posta helbiderik';
$string['notavailable'] = 'Ez dago eskura';
$string['noteachersyet'] = 'Ez dago irakaslerik ikastaro honetan oraindik';
$string['notenrolled'] = '{$a} ez da ikastaro honetako partaide.';
$string['notenrolledprofile'] = 'Profil hau ez da eskuragarria erabiltzailea ez baitago ikastaro honetan matrikulatuta.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Oharra:</strong> Segurtasun-kopia hau berreskuratzean datak aldatzeko aukera desgaitu da behar den baimena ez duzulako.';
$string['noteuserschangednonetocourse'] = 'Oharra: Erabiltzaileen datuak berrezarritakoan ikastaroetako erabiltzaileak ere berrezarri beharra dago (ekintza, fitxategi edo mezuetan). Konfigurazio hau zuretzat aldatu da.';
$string['nothingnew'] = 'Ez dago ezer berririk aurreko bisitatik';
$string['nothingtodisplay'] = 'Erakustekorik ez';
$string['notice'] = 'Abisua';
$string['noticenewerbackup'] = 'Ziurtasun-kopia Moodle-k prestatu du {$a->backuprelease} ({$a->backupversion}) eta instalatutako Moodle bertsioa baino berriagoa da {$a->serverrelease} ({$a->serverversion}). Honek arazoak sor litzake elkargarritasuna dela eta.';
$string['notifications'] = 'Jakinarazpenak';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Erabiltzailea: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Erregistro horiek ikusteko hona jo: {$a}';
$string['notifyloginfailuresmessagestart'] = '{$a} (e)n sarrera okerren zerrenda azken oharra bidali zitzaizunetik';
$string['notifyloginfailuressubject'] = '{$a} :: Sarrera okerren jakinarazpena';
$string['notincluded'] = 'Ez dago barne';
$string['notingroup'] = 'Barkatu, baina taldekide izan behar duzu jarduera hau ikusteko.';
$string['notpublic'] = 'Ez da publikoa!';
$string['nousersfound'] = 'Ez da erabiltzailerik aurkitu';
$string['nousersmatching'] = 'Ez da aurkitu \'{$a}\' duen erabiltzailerik';
$string['nousersyet'] = 'Ez dago erabiltzailerik oraindik';
$string['novalidcourses'] = 'Ez dago balio duen ikastarorik erakusteko';
$string['now'] = 'orain';
$string['numattempts'] = '{$a} sarrera-saiakera oker';
$string['numberofcourses'] = 'Ikastaro-kopurua';
$string['numberweeks'] = 'Atal-kopurua';
$string['numdays'] = '{$a} egun';
$string['numhours'] = '{$a} ordu';
$string['numletters'] = '{$a} letra';
$string['numminutes'] = '{$a} minutu';
$string['nummonths'] = '{$a} hilabete';
$string['numseconds'] = '{$a} segundu';
$string['numviews'] = '{$a} ikustaldi';
$string['numweeks'] = '{$a} aste';
$string['numwords'] = '{$a} hitz';
$string['numyears'] = '{$a} urte';
$string['ok'] = 'ONDO';
$string['oldpassword'] = 'Oraingo pasahitza';
$string['olduserdirectory'] = 'Erabiltzaileen direktorio ZAHARRA da hau eta dagoeneko ez da beharrezkoa. Lasai ezaba dezakezu. Dituen fitxategiak erabiltzaile direktorio BERRIAn kopiatu dira.';
$string['opentoguests'] = 'Bisitari-sarrera';
$string['optional'] = 'aukerakoa';
$string['options'] = 'aukerak';
$string['order'] = 'Ordena';
$string['originalpath'] = 'Jatorrizko bidea';
$string['orphanedactivitiesinsectionno'] = 'Jarduera umezurtzak ({$a} atala)';
$string['other'] = 'Beste';
$string['outline'] = 'Laburpena';
$string['outlinereport'] = 'Laburpen-txostena';
$string['page'] = 'Orria';
$string['pagea'] = '{$a} orria';
$string['pageheaderconfigablock'] = 'Blokea hemen konfiguratzen: {$a->fullname}';
$string['pagepath'] = 'Orriaren bidea';
$string['pageshouldredirect'] = 'Orri hau automatikoki birbideratu da. Ezer ateratzen ez bada, mesedez, erabili beheko esteka aurrera egiteko.';
$string['parentcategory'] = 'Goragoko kategoria';
$string['parentcoursenotfound'] = 'Goragoko ikastaroa ez da aurkitu!';
$string['parentfolder'] = 'Goragoko karpeta';
$string['participants'] = 'Partaideak';
$string['participantslist'] = 'Partaideen zerrenda';
$string['participationratio'] = 'Partaidetza-ratioa';
$string['participationreport'] = 'Partaidetza-txostena';
$string['password'] = 'Pasahitza';
$string['passwordchanged'] = 'Pasahitza aldatu da';
$string['passwordconfirmchange'] = 'Baieztatu pasahitzaren aldaketa';
$string['passwordextlink'] = 'Esteka honek galdutako pasahitza errekuperatzeko balio du eta Moodle-tik ateratzen behartzen zaitu.';
$string['passwordforgotten'] = 'Pasahitz ahaztua';
$string['passwordforgotteninstructions'] = 'Zure datuak lehenik erabiltzaileen datu-basean bilatu behar dira. Zure erabiltzaile-izena <strong>edo</strong> e-posta helbidea dagokion lekuan idatzi, mesedez. Biak idaztea ez da beharrezkoa.';
$string['passwordforgotteninstructions2'] = 'Zure pasahitza berritzeko, bidali zure erabiltzaile-izena edo zure e-posta helbidea. Datu-basean aurkitzen bazaitugu, e-posta bidaliko dizugu  zure e-posta helbidea, berriz sartzeko argibideekin.';
$string['passwordnohelp'] = 'Ezin izan da galdu duzun pasahitza aurkitu. Moodle-ren kudeatzailearekin harremanetan jarri, mesedez.';
$string['passwordrecovery'] = 'Bai, laguntza behar dut saioa hasteko';
$string['passwordsdiffer'] = 'Pasahitz hauek ez datoz bat';
$string['passwordsent'] = 'Pasahitza bidali da';
$string['passwordsenttext'] = '<p>E-posta mezu bat bidali da honako helbide honetara {$a->email}.</p>
<p><b>Mesedez begiratu zure e-posta pasahitz berria lortzeko</b></p>
<p>Pasahitz berria automatikoki sortu da eta agian <a href="{$a->link}">gogoratzeko errazagoa den batera aldatu</a> nahi duzu.</p>';
$string['passwordset'] = 'Zure pasahitza berrezarri da.';
$string['path'] = 'Bidea';
$string['pathnotexists'] = 'Zure zerbitzarian ez dago horrelako biderik!';
$string['pathslasherror'] = 'Bidea ezin da barraz amaitu!';
$string['paymentinstant'] = 'Ordaintzeko eta minutu gutxitan matrikulatzeko beheko botoia erabili, mesedez!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> amaitu gabe</small>)';
$string['paymentrequired'] = 'Ikastaro hau ordainpekoa da';
$string['payments'] = 'Ordainketak';
$string['paymentsorry'] = 'Mila esker ordainketarengatik! Zoritxarrez zure ordainketa ez da guztiz prozesatu, eta "{$a->fullname}" ikastaroan ez zaude matrikulaturik. Segundu batzuk barru berriz sartu, mesedez. Arazoekin jarraitzen baduzu {$a->teacher} irakaslearekin edo gunearen kudeatzailearekin harremanetan jarri';
$string['paymentthanks'] = 'Mila esker ordainketarengatik! Ikastaro honetan matrikulatuta zaude:<br />"{$a}"';
$string['pendingrequests'] = 'Onartu gabeko eskariak';
$string['periodending'] = 'Epe-amaiera ({$a})';
$string['perpage'] = 'Orriko';
$string['perpagea'] = 'Orriko: {$a}';
$string['personal'] = 'Pertsonala';
$string['personalprofile'] = 'Norberaren profila';
$string['phone'] = 'Telefonoa';
$string['phone2'] = 'Telefono mugikorra';
$string['phpinfo'] = 'PHP info';
$string['pictureof'] = '{$a}-ren irudia';
$string['pictureofuser'] = 'Erabiltzailearen irudia';
$string['pleaseclose'] = 'Mesedez, orain itxi leiho hau.';
$string['pleasesearchmore'] = 'Mesedez, bilatu berriz';
$string['pleaseusesearch'] = 'Mesedez, erabili bilaketa';
$string['plugin'] = 'Plugina';
$string['plugincheck'] = 'Pluginak aztertu';
$string['plugindeletefiles'] = '\'{$a->name}\' pluginarekin lotutako datu guztiak ezabatu egin dira datu-basetik. Berriz ere plugina instalatzea ekiditeko, zure zerbitzaritik ondorengo direktorioa ezabatu beharko zenuke: {$a->directory}';
$string['pluginsetup'] = 'Plugin-taulak zehazten';
$string['policyaccept'] = 'Ulertu dut eta ados nago';
$string['policyagree'] = 'Web gune honetan jarraitu aurretik baldintzekin ados egon behar duzu. Ados al zaude?';
$string['policyagreement'] = 'Gunearen baldintzen akordioa';
$string['policyagreementclick'] = 'Gunearen baldintzak irakurtzeko esteka';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Ireki fitxategia leiho berrian';
$string['popupwindowname'] = 'Popup leihoa';
$string['post'] = 'Mezua';
$string['posts'] = 'Mezuak';
$string['potentialadmins'] = 'Balizko kudeatzaileak';
$string['potentialcreators'] = 'Balizko ikastaro-sortzaileak';
$string['potentialstudents'] = 'Balizko ikasleak';
$string['potentialteachers'] = 'Balizko irakasleak';
$string['preferences'] = 'Aukerak';
$string['preferredlanguage'] = 'Lehenetsitako hizkuntza';
$string['preferredtheme'] = 'Lehenetsitako itxura';
$string['preprocessingbackupfile'] = 'Segurtasun-kopiaren fitxategia aurre-prozesatzen';
$string['prev'] = 'Aurrekoa';
$string['preview'] = 'Aurreikusi';
$string['previewhtml'] = 'HTML formatuaren aurrebista';
$string['previeworchoose'] = 'Aurreikusi edo itxura bat aukeratu';
$string['previous'] = 'Aurrekoa';
$string['previouslyselectedusers'] = 'Lehenago aukeratutako erabiltzaileak eta \'{$a}\'-rekin bat ez datozenak';
$string['previoussection'] = 'Aurreko atala';
$string['primaryadminsetup'] = 'Kudeatzailearen kontuaren ezarpenak';
$string['profile'] = 'Profila';
$string['profilenotshown'] = 'Profilaren deskribapena ez da erakutsiko harik eta pertsona hau gutxienez ikastaro batean matrikulatuta egon arte';
$string['publicprofile'] = 'Profil publikoa';
$string['publicsitefileswarning'] = 'Oharra: hemen kokatutako fitxategiak edonork ikus ditzake';
$string['publicsitefileswarning2'] = 'Oharra: Hemen kokatutako fitxategiak URL-a ezagutzen duen (edo bisita dezakeen) edonoren esku egongo dira. Segurtasunagatik, gomendagarria da segurtasun-kopiaren fitxategiak berreskuratu ondoren berehala ezabatzea.';
$string['publicsitefileswarning3'] = 'Oharra: Hemen kokatutako fitxategiak URL-a ezagutzen duen (edo bisita dezakeen) edonoren esku egongo dira. <br />Segurtasunagatik, segurtasun-kopiaren fitxategiak backupdata karpetan bakarrik gorde beharko lirateke.';
$string['publish'] = 'Argitaratu';
$string['question'] = 'Galdera';
$string['questionsinthequestionbank'] = 'Galderak galdera-bankuan';
$string['readinginfofrombackup'] = 'Informazioa irakurtzen segurtasun-kopiatik';
$string['readme'] = 'IrakHau';
$string['recentactivity'] = 'Duela gutxiko aktibitatea';
$string['recentactivityreport'] = 'Duela gutxiko aktibitatearen txosten osoa';
$string['recipientslist'] = 'Hartzaileen zerrenda';
$string['recreatedcategory'] = 'Berrezarritako kategoria {$a}';
$string['redirect'] = 'Berbideratu';
$string['reducesections'] = 'Txikitu atal-kopurua';
$string['refresh'] = 'Freskatu';
$string['refreshingevents'] = 'Ekitaldiak berriz kargatzen';
$string['registration'] = 'Moodle Erregistroa';
$string['registrationcontact'] = 'Publikoaren kontaktua';
$string['registrationcontactno'] = 'Ez, ez dut harreman-formulariorik gunearen zerrendan';
$string['registrationcontactyes'] = 'Bai, Moodle-ren formularioa nahi dut nirekin harremanetan jar daitezen';
$string['registrationemail'] = 'E-posta bidezko jakinarazpenak';
$string['registrationinfo'] = '<p>Orria honek zure webgunea moodle.org-en erregistratzea ahalbidetzen dizu.
Erregistroa doakoa da. Izango duzun etekina zure webgunea posta-zerrenda batean sartzea da, ohar garrantzitsu,
ziurtasun-gastiguak eta Moodle-ko eskaintzak jasotzeko.</p>
<p>Zure informazioa konfidentziala izango da, eta ez zaio inoiz inori salduko. Informazio hau biltzeko
arrazoi bakarra zu lagundu eta Moodle komunitatearen koadro estatistikoa sortzea da.</p>
<p>Nahi izanez gero, zure webgunearen izenburua, herria eta URLa idatz ditzakezu Moodle erabiltzen duten guneen zerrenda agertzeko.</p>
<p>Erregistro guztiak eskuz errebisatzen dira zerrendan azaldu aurretik, baina bertan daudenean (eta zure datuak zerrenda publikoan) formulario hau beteta edonoiz datuak alda ditzakezu.</p>';
$string['registrationinfotitle'] = 'Erregistroaren informazioa';
$string['registrationno'] = 'Ez dut e-postaz abisurik jaso nahi';
$string['registrationsend'] = 'Nire erregistro-informazioa moodle.org-era bidali';
$string['registrationyes'] = 'Bai, abisuak e-postaz bidal iezazkidazu';
$string['reject'] = 'Ez onartu';
$string['rejectdots'] = 'Ez onartu...';
$string['reload'] = 'Berriz kargatu';
$string['remoteappuser'] = 'Urrutiko {$a} erabiltzailea';
$string['remove'] = 'Kendu';
$string['removeadmin'] = 'Kudeatzailea kendu';
$string['removecreator'] = 'Ikastaro-sortzailea kendu';
$string['removestudent'] = 'Ikaslea kendu';
$string['removeteacher'] = 'Irakaslea kendu';
$string['rename'] = 'Berrizendatu';
$string['renamefileto'] = 'Berrizendatu <b>{$a}</b> honela:';
$string['report'] = 'Txostena';
$string['reports'] = 'Txostenak';
$string['repositories'] = 'Biltegiak';
$string['requestcourse'] = 'Ikastaro bat eskatu';
$string['requestedby'] = 'Honek eskatua:';
$string['requestedcourses'] = 'Eskatutako ikastaroak';
$string['requestreason'] = 'Ikastaroa eskatzeko arrazoia';
$string['required'] = 'Beharrezkoa';
$string['requirespayment'] = 'Ikastaro hau ordainpekoa da';
$string['reset'] = 'Berrabiarazi';
$string['resetcomponent'] = 'Osagaia';
$string['resetcourse'] = 'Berrabiarazi ikastaroa';
$string['resetinfo'] = 'Orri honek aukera ematen dizu ikastaroa erabiltzaile-datuz husteko, jarduerak eta beste zehaztasun batzuk mantenduta. Mesedez, egin kontu beheragoko itemak aukeratuta eta orri hau bidalita behin betiko ezabatuko dituzula ikastaro honetatik aukeratutako erabiltzaileen datuak.';
$string['resetnotimplemented'] = 'Berrabiaraztea ez dago inplementatuta';
$string['resetstartdate'] = 'Hasiera-data aldatu';
$string['resetstatus'] = 'Egoera';
$string['resettask'] = 'Ataza';
$string['resettodefaults'] = 'Berezko baloreetara ekarri';
$string['resortbyfullname'] = 'Izen osoaren arabera';
$string['resortbyidnumber'] = 'ID zenbakiaren arabera';
$string['resortbyshortname'] = 'Izen laburraren arabera';
$string['resortcourses'] = 'Ordenatu ikastaroak';
$string['resortsubcategoriesbyidnumber'] = 'Ordenatu azpikategoriak ID zenbakiaren arabera';
$string['resortsubcategoriesbyname'] = 'Ordenatu azpikategoriak izenaren arabera';
$string['resource'] = 'Baliabidea';
$string['resourcedisplayauto'] = 'Automatikoa';
$string['resourcedisplaydownload'] = 'Jaistera behartu';
$string['resourcedisplayembed'] = 'Enbotatu';
$string['resourcedisplayframe'] = 'Markoan';
$string['resourcedisplaynew'] = 'Leiho berria';
$string['resourcedisplayopen'] = 'Zabaldu';
$string['resourcedisplaypopup'] = 'Pop-up-ean';
$string['resources'] = 'Baliabideak';
$string['resources_help'] = 'Baliabideek ikastaroan ia edozein web-eduki txertatzea ahalbidetzen dute.';
$string['restore'] = 'Berreskuratu';
$string['restorecancelled'] = 'Berreskuraketa bertan behera';
$string['restorecannotassignroles'] = 'Berreskuratzeko rolek esleituta egon behar dute eta zuk ez duzu baimenik horretarako';
$string['restorecannotcreateorassignroles'] = 'Berreskuratzeko rolak sortu edo esleitu behar dira eta zuk ez duzu baimenik horretarako';
$string['restorecannotcreateuser'] = 'Berreskuratzeko \'{$a}\' erabiltzailea sortu behar da segurtasun-kopiaren fitxategitik eta zuk ez duzu horretarako baimenik';
$string['restorecannotoverrideperms'] = 'Berreskuratzeko baimenak anulatu behar dira eta zuk ez duzu horretarako baimenik';
$string['restorecoursenow'] = 'Berreskuratu ikastaroa orain!';
$string['restoredaccount'] = 'Berreskuratutako kontua';
$string['restoredaccountinfo'] = 'Kontu hau beste zerbitzari batetik inportatu zen eta pasahitza galdu egin da. Pasahitz berria e-postaz ezartzeko, mesedez sakatu "Jarraitu"ri';
$string['restorefinished'] = 'Berreskuraketa ondo egina';
$string['restoreto'] = 'Berreskuratu hona:';
$string['restoretositeadding'] = 'Kontuz: gunearen hasiera-orria berreskuratzear zaude, datuak gehituz!';
$string['restoretositedeleting'] = 'Kontuz: gunearen hasiera-orria berreskuratzear zaude, lehenagoko informazioa ezabatuz!';
$string['restoreuserconflict'] = '\'{$a}\' erabiltzailea segurtasun-kopiaren fitxategitik berreskuratzeak gatazka sortuko du';
$string['restoreuserinfofailed'] = 'Berreskuratze-prozesua eten egin da zuk ez duzulako erabiltzaileen datuak berreskuratzeko baimenik.';
$string['restoreusersprecheck'] = 'Erabiltzaile-datuak egiaztatzen';
$string['restoreusersprecheckerror'] = 'Erabiltzaile-datuak egiaztatzean arazoak atzeman dira';
$string['restricted'] = 'Baimena behar da';
$string['returningtosite'] = 'Izena emandako erabiltzaileak';
$string['returntooriginaluser'] = '{$a}-ra itzuli';
$string['revert'] = 'Lehengora itzuli';
$string['role'] = 'Rola';
$string['roleassignments'] = 'Rol-esleipenak';
$string['rolemappings'] = 'Rolen mapak';
$string['rolerenaming'] = 'Rolei izena aldatu';
$string['rolerenaming_help'] = '<p>
Ikastaroan erabiltzen diren rolei izena aldatzeko aukera emango dizu ezarpen honek. Adibidez, "Irakaslea"ri "Laguntzailea" edo "Tutorea" ipini nahi izango diozu. Erakusten den izena aldatzen da bakarrik, azpiko rol-baimenei ez die eragingo.
</p>

<p>
Rolaren izen berria ikastaroko partaideen orrian agertuko da eta ikastaroko gainontzeko tokietan. Izen berria kudeatzaileak ikastaroaren kudeatzaile-rola gisa aukeratutako bat bada, rolaren izen berria ikastaroen zerrendan ere agertuko da.
</p>';
$string['roles'] = 'Rolak';
$string['rss'] = 'RSS (jarioak)';
$string['rssarticles'] = 'RSS jario berrien kopurua';
$string['rsserror'] = 'Errorea jarioa irakurtzerakoan';
$string['rsserrorauth'] = 'Zure RSS estekak ez du autentifikazio-token baliagarririk.';
$string['rsserrorguest'] = 'Jario honek gonbidatu-sarbidea erabiltzen du datuetara iristeko, baina gonbidatuak ez du baimenik datuak irakurtzeko. Jario honen jatorrizko kokapenera joan (URL) erabiltzaile onargarri bat erabiliz eta RSS esteka berri bat lortu.';
$string['rsskeyshelp'] = 'Segurtasuna eta pribatutasuna bermatzeko, RSS jarioen URLek token berezi bat dute, nori bideratua den identifikatzeko. Horrela, beste erabiltzaileek ezin izango dute atzipenik RSS bidez sartu behar ez diren Moodle ataletara.</p><p>Token hau automatikoki sortzen da RSS jarioak sortzen duen atal batera sartzen zaren lehen aldian. Uste baduzu RSS jarioaren tokena norbaiten eskuetara iritsi dela, beste token bat eskatu dezakezu Esteka hemen berritu botoiaren bidez. Kontuan izan oraingo RSS jarioaren URLak ez duela gehiago balio.';
$string['rsstype'] = 'RSS jarioak jarduera honetan';
$string['saveandnext'] = 'Gorde eta erakutsi hurrengoa';
$string['savechanges'] = 'Aldaketak gorde';
$string['savechangesanddisplay'] = 'Gorde eta erakutsi';
$string['savechangesandreturntocourse'] = 'Gorde eta itzuli ikastarora';
$string['savecomment'] = 'Iruzkina gorde';
$string['savedat'] = 'Hemen gordeta:';
$string['savepreferences'] = 'Hobespenak gorde';
$string['saveto'] = 'Non gorde';
$string['scale'] = 'Eskala';
$string['scale_help'] = 'Eskalak jarduera bat burutzeko gaitasuna ebaluatu edo puntuatzeko bidea eskaintzen du. Balore-zerrenda ordenatuak definitzen du, negatibotik positibora eta komaz banatuta. Adibidez: "Gutxiegi, Erdipurdi, Nahiko, Ongi, Oso ongi, Bikain".';
$string['scales'] = 'Eskalak';
$string['scalescustom'] = 'Zeure eskalak';
$string['scalescustomcreate'] = 'Eskala gehitu';
$string['scalescustomno'] = 'Zeure eskalarik ez oraindik';
$string['scalesstandard'] = 'Eskala estandarrak';
$string['scalestandard'] = 'Eskala estandarra';
$string['scalestandard_help'] = 'Eskala estandarra gunean, ikastaro guztietan, erabil daiteke.';
$string['scalestip'] = 'Zeure eskalak sortzeko erabili "Eskalak..." lotura zure ikastaroaren kudeaketa-menuan.';
$string['scalestip2'] = 'Pertsonalizatutako eskalak sortzeko, klik egin ikastaroaren kudeaketa menuko Kalifikazioak estekan eta aukeratu Editatu, Eskalak';
$string['schedule'] = 'Egutegia';
$string['screenshot'] = 'Pantaila-argazkia';
$string['search'] = 'Bilatu';
$string['searchagain'] = 'Berriz bilatu';
$string['searchbyemail'] = 'Bilatu e-posta helbidearen arabera';
$string['searchbyusername'] = 'Bilatu erabiltzaile-izenaren arabera';
$string['searchcourses'] = 'Bilatu Ikastaroak';
$string['searchhelp'] = '<p>Hitz asko batera bila ditzakezu bilaketaren emaitzak zehatzago izateko honela:</p>
<ul>
<li>Hitz bat baino gehiago idaztekotan, bilatzaileak hitz horiek edonon dauzkaten emaitzak bilatuko ditu.</li>
<li>Hitz batzuk (+) ikurrak bananduta idatziz gero, hitz horiek guztiak orden berean duten emaitza guztiak erakutsiko dira.</li>
<li>Hitz batzuk (-) ikurrak bananduta idatziz gero, hitz horiek dauzkaten emaitzak baztertu egingo dira.</li>
</ul>';
$string['search_help'] = 'Testuko edozein tokitan hitz bat edo biko oinarrizko bilaketetarako, idatzi horiek tarte bat utzita. Bi karaktere baino gehiagoko hitz guztiak erabiltzen dira.

Bilaketa arurreraturako, sakatu bilatu botoiari bilaketarako kutxatxoan ezer idatzi gabe eta bilaketa aurreraturako formulariora joango zara.';
$string['searchoptions'] = 'Bilaketaren aukerak';
$string['searchresults'] = 'Bilaketaren emaitzak';
$string['sec'] = 'seg';
$string['seconds'] = 'segundu';
$string['secondstotime172800'] = '2 egun';
$string['secondstotime259200'] = '3 egun';
$string['secondstotime345600'] = '4 egun';
$string['secondstotime432000'] = '5 egun';
$string['secondstotime518400'] = '6 egun';
$string['secondstotime604800'] = 'astebete';
$string['secondstotime86400'] = 'egun bat';
$string['secretalreadyused'] = 'Pasahitza aldatzeko konfirmazio-esteka erabili egin da baina pasahitza ez da aldatu.';
$string['secs'] = 'segundu';
$string['section'] = 'Atala';
$string['sectionname'] = 'Atalaren izena';
$string['sections'] = 'Atalak';
$string['sectionusedefaultname'] = 'Erabili berezko atal-izena';
$string['seealsostats'] = 'Estatistikak ere ikusi';
$string['selctauser'] = 'Aukera ezazu erabiltzaile bat';
$string['select'] = 'Aukeratu';
$string['selectacategory'] = 'Mesedez, aukeratu kategoria bat';
$string['selectacountry'] = 'Herrialde bat aukeratu';
$string['selectacourse'] = 'Aukera ezazu ikastaro bat';
$string['selectacoursesite'] = 'Aukera ezazu ikastaro edo gune bat';
$string['selectagroup'] = 'Aukera ezazu talde bat';
$string['selectall'] = 'Aukeratu guztiak';
$string['selectamodule'] = 'Baliabide-moduluren bat aukeratu, mesedez';
$string['selectanaction'] = 'Aukera ezazu ekintza bat';
$string['selectanoptions'] = 'Hautatu aukera bat';
$string['selectaregion'] = 'Aukeratu lurralde bat';
$string['selectcategorysort'] = 'Zein kategoria ordenatu nahi duzu?';
$string['selectcategorysortby'] = 'Aukera nola ordenatu nahi dituzun kategoriak';
$string['selectcoursesortby'] = 'Aukeratu nola ordenatu nahi dituzun ikastaroak';
$string['selectdefault'] = 'Aukeratu berezkoa';
$string['selectedcategories'] = 'Aukeratuko kategoriak';
$string['selectedfile'] = 'Aukeratutako fitxategia';
$string['selectednowmove'] = '{$a} fitxategi aukeratu duzu mugitzeko. Zoaz orain nahi duzun karpetara eta sakatu \'Ekarri fitxategiak hona\'';
$string['selectfiles'] = 'Aukeratutako fitxategiak';
$string['selectmoduletoviewhelp'] = 'Aukera ezazu modulu bat horren laguntza ikusteko.

Klik bikoitza egin jarduera edo aktibitatearen izenean modu azkarrean gehitzeko.';
$string['selectnos'] = 'Akeratu \'Ez\' guztiak';
$string['selectperiod'] = 'Epea aukeratu';
$string['senddetails'] = 'Nire xehetasunak e-postaz bidali';
$string['separate'] = 'Bereizi';
$string['separateandconnected'] = 'Jakintza-bide banatuak eta elkar lotuak';
$string['servererror'] = 'Errorea gertatu da zerbitzariarekin komunikatzean';
$string['serverlocaltime'] = 'Zerbitzariaren ordu lokala';
$string['setcategorytheme'] = 'Kategoriaren itxura ezarri';
$string['setpassword'] = 'Ezarri pasahitza';
$string['settings'] = 'Ezarpenak';
$string['shortname'] = 'Izen laburra';
$string['shortnamecollisionwarning'] = '[*] = Izen labur hau beste ikastaro batean erabiltzen ari da, eta onartu baino lehen aldatu egin behar da';
$string['shortnamecourse'] = 'Ikastaroaren izen laburra';
$string['shortnamecourse_help'] = 'Ikastaroaren izen laburra nabigazioan erakusten da eta ikastaroaren e-posta mezuetako gaiaren lerroan erabiltzen da.';
$string['shortnametaken'] = 'Izen labur hau beste ikastaro batean erabili dute ({$a})';
$string['shortnameuser'] = 'Erabiltzailearen izen laburra';
$string['shortsitename'] = 'Gunearen izen laburra (adibidez hitz bakarra)';
$string['show'] = 'Erakutsi';
$string['showactions'] = 'Erakutsi ekintzak';
$string['showadvancedsettings'] = 'Erakutsi ezarpen aurreratuak';
$string['showall'] = 'Erakutsi denak: {$a}';
$string['showallcourses'] = 'Ikastaro guztiak erakutsi';
$string['showallusers'] = 'Erakutsi erabiltzaile guztiak';
$string['showblockcourse'] = 'Blokea duten ikastaroen zerrenda erakutsi';
$string['showcategory'] = 'Erakutsi {$a}';
$string['showcomments'] = 'Erakutsi/ezkutatu iruzkinak';
$string['showcommentsnonjs'] = 'Erakutsi iruzkinak';
$string['showdescription'] = 'Erakutsi deskribapena ikastaroaren orrian';
$string['showdescription_help'] = 'Gaituta goiko sarrera / deskribapena ikastaroaren hasiera-orrian agertuko da jarduera / baliabiderako estekaren azpian.';
$string['showgrades'] = 'Kalifikazioak ikasleei erakutsi';
$string['showgrades_help'] = 'Ikastaroko hainbat jardueratan ezar daitezke kalifikazioak. Ezarpen honek zehazten du ikasleak nola ikus dezakeen ikastaroko bere kalifikazio guztien zerrenda ikastaroko kudeaketa blokeko kalifikazioak estekaren bidez.';
$string['showingacourses'] = 'Ikastaro guztiak ({$a} ) erakusten ari dira';
$string['showingxofycourses'] = 'Ikastaroak erakusten {$a->start}-(e)tik {$a->end}-8e)ra. Denera {$a->total} ikastaro';
$string['showlistofcourses'] = 'Erakutsi ikastaro-zerrenda';
$string['showmodulecourse'] = 'Erakutsi jarduera duten ikastaroen zerrenda';
$string['showonly'] = 'Soilik erakutsi';
$string['showperpage'] = 'Erakutsi {$a} orrialdeko';
$string['showrecent'] = 'Erakutsi duela gutxiko aktibitatea';
$string['showreports'] = 'Agerraldien txostena erakutsi';
$string['showreports_help'] = 'Agerraldien txostena partaide bakoitzaren eskura dago eta ikastaroan izan duten partaidetza erakusten du. Izan duten ekarpenen zerrenda modukoa da, foroetan idatzitakoa edo bidalitako zereginak, eta sarbideak ere agertzen dira. Ezarpen honek adierazten du ikasleak bere agerraldien txostena ikus dezakeen profil-orritik.';
$string['showsettings'] = 'Ezarpenak erakutsi';
$string['showtheselogs'] = 'Agerraldi hauek erakutsi';
$string['showthishelpinlanguage'] = 'Erakutsi laguntza hizkuntza honetan: {$a}';
$string['since'] = 'Noiztik';
$string['sincelast'] = 'azkeneko sarreratik';
$string['site'] = 'Gunea';
$string['sitedefault'] = 'Guneko berezkoa';
$string['siteerrors'] = 'Guneko erroreak';
$string['sitefiles'] = 'Guneko fitxategiak';
$string['sitefilesused'] = 'Ikastaro honetan erabilitako guneko fitxategiak';
$string['sitehome'] = 'Gunearen hasiera';
$string['sitelegacyfiles'] = 'Guneko fitxategiak';
$string['sitelogs'] = 'Gunearen agerraldiak';
$string['sitemessage'] = 'Mezu-erabiltzaileak';
$string['sitenews'] = 'Gunearen berriak';
$string['sitepages'] = 'Gunearen orriak';
$string['sitepartlist'] = 'Ez dituzu partaide-zerrenda ikusteko behar diren baimenak';
$string['sitepartlist0'] = 'Partaideen zerrenda ikusteko, guneko irakaslea izan behar duzu';
$string['sitepartlist1'] = 'Partaideen zerrenda ikusteko, irakaslea izan behar duzu';
$string['sites'] = 'Guneak';
$string['sitesection'] = 'Gaiak jartzeko atal bat gehitu';
$string['sitesettings'] = 'Gunearen ezarpenak';
$string['siteteachers'] = 'Guneko irakasleak';
$string['size'] = 'Tamaina';
$string['sizeb'] = 'byte';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Alde batera utzia';
$string['skypeid'] = 'Skype-ren IDa';
$string['socialheadline'] = 'Foro irekia - azken gaiak';
$string['someallowguest'] = 'Ikastaro batzuetan bisitariak sar daitezke';
$string['someerrorswerefound'] = 'Daturen bat falta da edo ez da zuzena. Xehetasun gehiago:';
$string['sort'] = 'Ordenatu';
$string['sortby'] = 'Zeren arabera ordenatu';
$string['sortbyx'] = 'Ordenatu {$a}-ren arabera behetik gora';
$string['sortbyxreverse'] = 'Ordenatu {$a}-ren arabera goitik behera';
$string['sortcategoriesbyidnumber'] = 'Ordenatu kategoriak ID zenbakiaren arabera';
$string['sortcategoriesbyname'] = 'Ordenatu ikastaroak izenaren arabera';
$string['sortcoursesbyfullname'] = 'Ordenatu ikastaroak izen osoaren arabera';
$string['sortcoursesbyidnumber'] = 'Ordenatu ikastaroak ID zenbakiaren arabera';
$string['sortcoursesbyshortname'] = 'Ordenatu ikastaroak izen laburraren arabera';
$string['sorting'] = 'Ordenatzen';
$string['sourcerole'] = 'Jatorrizko rola';
$string['specifyname'] = 'Izena eman behar duzu derrigor.';
$string['standard'] = 'Estandarra';
$string['starpending'] = '([*] = ikastaroa onarpenaren zain dago)';
$string['startdate'] = 'Ikastaroaren hasiera-data';
$string['startdate_help'] = 'Ezarpen honek astekako ikastaroetan lehenbiziko astea zein izango den zehazten du. Era berean, ikastaroko jardueren agerraldiak noiztik aurrera izango diren eskura zehazten du.';
$string['startingfrom'] = 'Hasiera hemen:';
$string['startsignup'] = 'Kontu berri bat sortu';
$string['state'] = 'Estatua / Herrialdea';
$string['statistics'] = 'Estatistikak';
$string['statisticsgraph'] = 'Estatistiken grafikoa';
$string['stats'] = 'Estatistikak';
$string['statslogins'] = 'Sarrerak';
$string['statsmodedetailed'] = 'Ikuspen zehatza (erabiltzailea)';
$string['statsmodegeneral'] = 'Ikuspen orokorra';
$string['statsnodata'] = 'Ikastaro eta epe honetarako ez dago datu eskuragarririk.';
$string['statsnodatauser'] = 'Ikastaro, erabiltzaile eta epe honetarako ez dago datu eskuragarririk.';
$string['statsoff'] = 'Estatistikak ez daude orain gaituta';
$string['statsreads'] = 'Ikustaldiak';
$string['statsreport1'] = 'Sarrerak';
$string['statsreport10'] = 'Erabiltzailearen aktibitatea';
$string['statsreport11'] = 'Ikastaro aktiboenak';
$string['statsreport12'] = 'Ikastaro aktiboenak (neurtuak)';
$string['statsreport13'] = 'Partaidetza handieneko ikastaroak (matrikulazioak)';
$string['statsreport14'] = 'Partaidetza handieneko ikastaroak (sarrerak/mezuak)';
$string['statsreport2'] = 'Ikuspenak (rol guztiak)';
$string['statsreport3'] = 'Mezuak (rol guztiak)';
$string['statsreport4'] = 'Aktibitate osoa (rol guztiak)';
$string['statsreport5'] = 'Ikaslearen aktibitate osoa (ikustaldiak eta mezuak)';
$string['statsreport7'] = 'Erabiltzailearen aktibitatea (ikustaldiak eta mezuak)';
$string['statsreport8'] = 'Erabiltzailearen aktibitate osoa';
$string['statsreport9'] = 'Sarrerak (gune eta ikastaroa)';
$string['statsreportactivity'] = 'Aktibitate osoa (rol guztiak)';
$string['statsreportactivitybyrole'] = 'Aktibitate osoa (ikuspen eta mezuak)';
$string['statsreportforuser'] = 'norentzat';
$string['statsreportlogins'] = 'Sarrerak';
$string['statsreportreads'] = 'Ikustaldiak (rol guztiak)';
$string['statsreporttype'] = 'Txosten-mota';
$string['statsreportwrites'] = 'Mezuak (rol guztiak)';
$string['statsstudentactivity'] = 'Ikaslearen aktibitatea';
$string['statsstudentreads'] = 'Ikaslearen ikuspenak';
$string['statsstudentwrites'] = 'Ikaslearen mezuak';
$string['statsteacheractivity'] = 'Irakaslearen aktibitatea';
$string['statsteacherreads'] = 'Irakaslearen ikuspenak';
$string['statsteacherwrites'] = 'Irakaslearen mezuak';
$string['statstimeperiod'] = 'Denbora-epea - azkena:';
$string['statsuniquelogins'] = 'Sarrea bakarrak';
$string['statsuseractivity'] = 'Aktibitate osoa';
$string['statsuserlogins'] = 'Sarrerak';
$string['statsuserreads'] = 'Ikustaldiak';
$string['statsuserwrites'] = 'Mezuak';
$string['statswrites'] = 'Mezuak';
$string['status'] = 'Egoera';
$string['stringsnotset'] = 'Hurrengo kateak ez dira hemen definitu: {$a}';
$string['studentnotallowed'] = 'Barkatu ezin duzu ikastaro hau \'{$a}\' gisa sartu';
$string['students'] = 'Ikasleak';
$string['studentsandteachers'] = 'Ikasleak eta irakasleak';
$string['subcategories'] = 'Azpikategoriak';
$string['subcategory'] = 'Azpikategoria';
$string['subcategoryof'] = '{$a}-(r)en azpikategoria';
$string['submit'] = 'Bidali';
$string['success'] = 'Ondo!';
$string['summary'] = 'Laburpena';
$string['summary_help'] = 'Irakasgaia testu motz batean laburtzearen asmoa da ikasleak prestatzea irakasgai (edo aste) horretan egingo diren jardueretarako.';
$string['summaryof'] = '{$a}-ren laburpena';
$string['supplyinfo'] = 'Xehetasun gehiago';
$string['suspended'] = 'Kontua etenda';
$string['suspendedusers'] = 'Kontua etenda duten erabiltzaileak';
$string['switchdevicedefault'] = 'Aldatu itxura estandarrera';
$string['switchdevicerecommended'] = 'Zure gailurako gomendatzen den itxurara aldatu';
$string['switchrolereturn'] = 'Nire ohiko rolera itzuli';
$string['switchroleto'] = 'Aukeratu beste rol bat';
$string['tag'] = 'Etiketa';
$string['tagalready'] = 'Etiketa hori badago.';
$string['tagmanagement'] = 'Gehitu/ezabatu etiketak...';
$string['tags'] = 'Etiketak';
$string['targetrole'] = 'Helburu-rola';
$string['teacheronly'] = '{$a} -tzat bakarrik';
$string['teacherroles'] = '{$a} (r)en rolak';
$string['teachers'] = 'Irakasleak';
$string['textediting'] = 'Testu-editorea';
$string['texteditor'] = 'Web formulario estandarrak erabili';
$string['textformat'] = 'Testu arrunt formatua';
$string['thanks'] = 'Eskerrik asko';
$string['theme'] = 'Itxura';
$string['themes'] = 'Itxurak';
$string['themesaved'] = 'Itxura berria gordeta';
$string['therearecourses'] = '{$a} ikastaro dago';
$string['thereareno'] = '{$a}  ez dago ikastaro honetan';
$string['thiscategory'] = 'Kategoria hau';
$string['thiscategorycontains'] = 'Kategoria honek ondokoa du';
$string['time'] = 'Ordua';
$string['timezone'] = 'Ordu-zona';
$string['to'] = 'Noiz arte';
$string['tocreatenewaccount'] = 'Jauzi kontu berria sortzeko';
$string['today'] = 'Gaur';
$string['todaylogs'] = 'Gaurko agerraldiak';
$string['toeveryone'] = 'guztiei';
$string['toomanybounces'] = 'E-posta honetatik mezu asko bueltatu dira. Jarraitzeko <b>aldatu</b> behar duzu.';
$string['toomanytoshow'] = 'Erabiltzaile gehiegi daude erakusteko';
$string['toomanyusersmatchsearch'] = 'Erabiltzaile gehiegi-k ({$a->count}) dute \'{$a->search}\'';
$string['toomanyuserstoshow'] = '({$a}) erabiltzaile gehiegi erakusteko';
$string['toonly'] = 'Honi bakarrik: {$a}';
$string['top'] = 'Goragokoa';
$string['topic'] = 'Gaia';
$string['topichide'] = 'Ezkutatu gai hau hemendik: {$a}';
$string['topicoutline'] = 'Ikastaroaren edukia';
$string['topicshow'] = 'Gai hau honi erakutsi: {$a}';
$string['toplevelcategory'] = 'Goragoko kategoria';
$string['total'] = 'Guztira';
$string['totopofsection'] = '"{$a}" atalaren goiko aldean';
$string['trackforums'] = 'Foroen jarraipena';
$string['trackforumsno'] = 'Ez, ez egin ikusitako mezuen jarraipena';
$string['trackforumsyes'] = 'Bai, nabarmendu mezu berriak';
$string['trysearching'] = 'Guneko bilaketa egiten saiatu.';
$string['turneditingoff'] = 'Desaktibatu edizioa';
$string['turneditingon'] = 'Aktibatu edizioa';
$string['undecided'] = 'Erabaki gabe';
$string['unfinished'] = 'Amaitu gabe';
$string['unknowncategory'] = 'Kategoria ezezaguna';
$string['unknownerror'] = 'Errore ezezaguba';
$string['unlimited'] = 'Mugarik gabe';
$string['unpacking'] = '{$a} irekitzen';
$string['unsafepassword'] = 'Pasahitz ez ziurra - besteren bat erabili';
$string['untilcomplete'] = 'Osatu arte';
$string['unusedaccounts'] = '{$a} egun baino gehiagotan erabili ez diren kontuak automatikoki baja dira';
$string['unzip'] = 'Unzip';
$string['unzippingbackup'] = 'Segurtasun-kopia deskonprimatzen';
$string['up'] = 'Gora';
$string['update'] = 'Eguneratu';
$string['updated'] = '{$a} eguneratuta';
$string['updatemymoodleoff'] = 'Eten orri honen pertsonalizazioa';
$string['updatemymoodleon'] = 'Orri hau pertsonalizatu';
$string['updatemyprofile'] = 'Profila eguneratu';
$string['updatesevery'] = '{$a} segunduro eguneratzen da';
$string['updatethis'] = '{$a} eguneratu';
$string['updatethiscourse'] = 'Ikastaro hau eguneratu';
$string['updatinga'] = '{$a} eguneratzen';
$string['updatingain'] = '{$a->what} eguneratzen hemen: {$a->in}';
$string['upload'] = 'Igo';
$string['uploadafile'] = 'Fitxategia igo';
$string['uploadcantwrite'] = 'Errorea fitxategia diskoan idaztean';
$string['uploadedfile'] = 'Fitxategia ondo igo da';
$string['uploadedfileto'] = '{$a->file} fitxategia {$a->directory} direktoriora igota';
$string['uploadedfiletoobig'] = 'Barkatu, baina fitxategi hau handiegia da (gehienez {$a} izan dezake)';
$string['uploadextension'] = 'PHP luzapen batek fitxategia igotzea eten du';
$string['uploadfailednotrecovering'] = 'Errorea gertatu da igo nahi zenuen fitxategi honekin, {$a->name}.<br /> Hona hemen izandako arazoen log-a:<br />{$a->problem}<br />Not recovering.';
$string['uploadfilelog'] = '{$a} fitxategirako igoera-erregistroa';
$string['uploadformlimit'] = '{$a} fitxategiak formularioak ezartzen duen tamaina-muga gainditzen du';
$string['uploadlabel'] = 'Izenburua:';
$string['uploadlimitwithsize'] = '{$a->contextname}-(e)n igotzeko gehieneko tamaina: ({$a->displaysize})';
$string['uploadnewfile'] = 'Igo beste fitxategi bat';
$string['uploadnofilefound'] = 'Ez da fitxategirik aurkitu. Ziur zaude igotzeko bat aukeratu duzula?';
$string['uploadnotallowed'] = 'Ezin da fitxategirik igo';
$string['uploadnotempdir'] = 'Aldi baterako karpeta falta da';
$string['uploadoldfilesdeleted'] = 'Igoera-eremuko fitxategi zaharrak ezabatu dira';
$string['uploadpartialfile'] = 'Fitxategia ez da osorik igo';
$string['uploadproblem'] = 'Errore ezezagun bat gertatu da \'{$a}\' fitxategia igotzerakoan (handiegia agian?)';
$string['uploadrenamedchars'] = 'Fitxategiari izena aldatu diogu (lehen {$a->oldname} ;orain {$a->newname}) erabili ezin diren karaktereak zituelako.';
$string['uploadrenamedcollision'] = 'Fitxategiari izena aldatu diogu (lehen {$a->oldname} ; orain {$a->newname}) izenen arteko arazoa zegoelako.';
$string['uploadserverlimit'] = 'Igotako fitxategia handiegia zen';
$string['uploadthisfile'] = 'Fitxategi hau igo';
$string['url'] = 'URLa';
$string['used'] = 'Erabilia';
$string['usedinnplaces'] = '{$a} lekuetan erabilia';
$string['usemessageform'] = 'edo behealdeko formularioa erabili aukeratutako ikasleei mezua bidaltzeko';
$string['user'] = 'Erabiltzailea';
$string['userconfirmed'] = '{$a} baieztatuta';
$string['usercurrentsettings'] = 'Nire profilaren ezarpenak';
$string['userdata'] = 'Erabiltzailearen datuak';
$string['userdeleted'] = 'Erabiltzaile-kontu hau ezabatu da';
$string['userdescription'] = 'Aurkezpena';
$string['userdescription_help'] = 'Lauki honek aukera ematen dizu zuri buruzko eta gainontzekoek ikusi ahal izateko moduko testua sartzeko zure profil-orrian erakutsiko dena.';
$string['userdetails'] = 'Erabiltzaileen xehetasunak';
$string['userfiles'] = 'Erabiltzaileen fitxategiak';
$string['userlist'] = 'Erabiltzaileen zerrenda';
$string['username'] = 'Erabiltzaile-izena';
$string['usernameemailmatch'] = 'Erabiltzaile-izena eta e-posta helbidea ez dagozkie erabiltzaile berari';
$string['usernameexists'] = 'Erabiltzaile-izen hau badago aurretik, beste bat aukeratu';
$string['usernamelowercase'] = 'Letra xumeak bakarrik onartzen dira';
$string['usernamenotfound'] = 'Erabiltzaile-izena ez da datu-basean aurkitu';
$string['usernameoremail'] = 'Erabiltzaile-izena edo e-posta helbidea sartu';
$string['usernotconfirmed'] = 'Ezin {$a} baieztatu';
$string['userpic'] = 'Erabiltzailearen irudia';
$string['users'] = 'Erabiltzaileak';
$string['userselectorautoselectunique'] = 'Bilaketan erabiltzaile bakarra aurkitzen bada, aukeratu automatikoki';
$string['userselectorpreserveselected'] = 'Aukeratutako erabiltzaileak mantendu, bilaketarekin bat ez badatoz ere';
$string['userselectorsearchanywhere'] = 'Bilaketa-testua erakutsitako edozein atalekin bat baldin badator, aukeratu';
$string['usersnew'] = 'Erabiltzaile berriak';
$string['usersnoaccesssince'] = 'Epe hau baino lehenago sartu ez diren erabiltzaileak bilatu:';
$string['userswithfiles'] = 'Fitxategiak dituzten erabiltzaileak';
$string['useruploadtype'] = 'Erabiltzaileak igotze-mota: {$a}';
$string['userviewingsettings'] = '{$a}-rentzako profil-ezarpenak';
$string['userzones'] = 'Erabiltzaileen ordu-zonaldeak';
$string['usetheme'] = 'Erabili itxura';
$string['usingexistingcourse'] = 'Erabili dagoen ikastaroa';
$string['valuealreadyused'] = 'Balore hau dagoeneko erabili izan da.';
$string['version'] = 'Bertsioa';
$string['view'] = 'Ikusi';
$string['viewallcourses'] = 'Ikastaro guztiak ikusi';
$string['viewallcoursescategories'] = 'Ikastaro guztiak eta kategoriak ikusi';
$string['viewallsubcategories'] = 'Ikusi azpikategoria guztiak';
$string['viewfileinpopup'] = 'Fitxategia popup leihoan ikusi';
$string['viewing'] = 'Ikusten:';
$string['viewmore'] = 'Ikusi gehiago';
$string['viewprofile'] = 'Profila ikusi';
$string['views'] = 'Ikustaldiak';
$string['viewsolution'] = 'soluzioa ikusi';
$string['virusfound'] = 'Kontuz kudeatzaile! Clam AV-k {$a->user} erabiltzaileak {$a->course} ikastarora igotako fitxategian birusa aurkitu du. Hau da clamscan-en output-a:';
$string['virusfoundlater'] = 'Zuk {$a->date} egunean {$a->course} ikastarora igotako {$a->filename} izeneko fitxategiak birusa dauka. Hona hemen fitxategiarekin gertatutakoaren laburpena:

{$a->action}

Bidalitako lana bada, berriz bidali zure irakasleak ikus dezan.';
$string['virusfoundlateradmin'] = 'Kontuz kudeatzaile! {$a->date} egunean {$a->course} ikastarora {$a->filename} {$a->user} erabiltzaileak igotako fitxategi batek birusa dauka. Hona hemen fitxategiarekin gertatutakoaren laburpena:

{$a->action}

Erabiltzaileari ere jakinarazi egin zaio';
$string['virusfoundlateradminnolog'] = 'Kontuz kudeatzaile! Igotako {$a->filename} izeneko fitxategiak birusa dauka. Moodle-k ezin izan dio fitxategia igorleari itzuli.

Hona hemen fitxategiarekin gertatutakoaren laburpena:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: Birusa aurkitu egin da!';
$string['virusfounduser'] = 'Igotako fitxategia, {$a->filename}, antibirusak eskaneatu du eta birusa dauka. EZ da igo.';
$string['virusplaceholder'] = 'Igotako fitxategiak birusak zituen eta ez da igo. Erabiltzaileari jakinarazi zaio.';
$string['visible'] = 'Agerian jarri';
$string['visible_help'] = 'Ezarpen honek adierazten du ikastaroa nola agertuko den ikastaroen zerrendan. Irakasle eta kudeatzaileez aparte, erabiltzaileek ez dute baimenik ikastaroan sartzeko.';
$string['visibletostudents'] = '{$a}-(r)entzat agerian';
$string['warning'] = 'Kontuz';
$string['warningdeleteresource'] = 'Kontuz: baliabide batek {$a}-ri egiten dio erreferentzia. Baliabidea eguneratu nahi duzu?';
$string['webpage'] = 'Web-orria';
$string['week'] = 'Astea';
$string['weekhide'] = 'Aste hau {$a}-(r)i ezkutatu';
$string['weeklyoutline'] = 'Astea hitz bitan';
$string['weeks'] = 'asteak';
$string['weekshow'] = 'Aste hau {$a} (r)i erakutsi';
$string['welcometocourse'] = 'Ongi etorri {$a} gunera';
$string['welcometocoursetext'] = 'Ongi etorri {$a->coursename} ikastarora!

Nahi baduzu, zure erabiltzaile-profila
edita dezakezu beheko loturari sakatuta. Horrela geuk eta zure ikastarokideek zuri buruz gehiago jakingo dugu.

  {$a->profileurl}';
$string['whatforpage'] = 'Zer egin nahi duzu testuarekin?';
$string['whattocallzip'] = 'Nola izendatu nahi duzu zip fitxategia?';
$string['whattodo'] = 'Zer egin';
$string['windowclosing'] = 'Leiho hau automatikoki itxiko da. Horrela ez bada, itxi orain.';
$string['withchosenfiles'] = 'Aukeratutako fitxategiak';
$string['withdisablednote'] = '{$a} (desgaituta)';
$string['withoutuserdata'] = 'erabiltzaileen daturik gabe';
$string['withselectedusers'] = 'Aukeratutako erabiltzaileekin...';
$string['withselectedusers_help'] = '* Bidali mezua - Partaide bati edo gehiagori mezua bidaltzeko
* Gehitu oharra - Aukeratutako partaideari oharra gehitzeko
* Gehitu ohar bera - Ohar bera partaide bati baino gehiagori gehitzeko';
$string['withuserdata'] = 'Erabiltzaileen datuekin';
$string['wordforstudent'] = 'Ikaslea izendatzeko hitza';
$string['wordforstudenteg'] = 'Adibidez Ikaslea, Partaidea...';
$string['wordforstudents'] = 'Ikasleak izendatzeko hitza';
$string['wordforstudentseg'] = 'Adibidez, Ikasleak, Partaideak...';
$string['wordforteacher'] = 'Irakaslea izendatzeko hitza';
$string['wordforteachereg'] = 'Adibidez, Tutore, Irakasle, Laguntzaile...';
$string['wordforteachers'] = 'Irakasleak izendatzeko hitza';
$string['wordforteacherseg'] = 'Adibidez, Irakasleak, Tutoreak, Laguntzaileak...';
$string['writingblogsinfo'] = 'Blogen informazioa idazten';
$string['writingcategoriesandquestions'] = 'Kategoriak eta galderak idazten';
$string['writingcoursedata'] = 'Ikastaroaren informazioa idazten';
$string['writingeventsinfo'] = 'Ekitaldiaren informazioa idazten';
$string['writinggeneralinfo'] = 'Informazio orokorra idazten';
$string['writinggradebookinfo'] = 'Kalifikazio-liburuaren informazioa idazten';
$string['writinggroupingsgroupsinfo'] = 'Taldekatzeen eta taldeen informazioa idazten';
$string['writinggroupingsinfo'] = 'Taldekatzeen informazioa idazten';
$string['writinggroupsinfo'] = 'Taldeen informazioa idazten';
$string['writingheader'] = 'Izenburua idazten';
$string['writingloginfo'] = 'Erregistroen informazioa idazten';
$string['writingmessagesinfo'] = 'Mezuen informazioa idazten';
$string['writingmoduleinfo'] = 'Moduluaren informazioa idazten';
$string['writingscalesinfo'] = 'Eskalen informazioa idazten';
$string['writinguserinfo'] = 'Erabiltzaileen informazioa idazten';
$string['wrongpassword'] = 'Pasahitz desegokia erabiltzaile izen honentzat';
$string['yahooid'] = 'ID Yahoo';
$string['year'] = 'urtea';
$string['years'] = 'urte';
$string['yes'] = 'Bai';
$string['youareabouttocreatezip'] = 'Zip motako fitxategia sortzear zaude. Edukia:';
$string['youaregoingtorestorefrom'] = 'Berreskuratze-prozesua abiatzear zaude. Helburua:';
$string['youneedtoenrol'] = 'Ekintza hau burutzeko ikastaroan matrikulatuta egon behar duzu.';
$string['yourlastlogin'] = 'Zure azken saioa:';
$string['yourself'] = 'Zu zeu';
$string['yourteacher'] = 'zure {$a}';
$string['yourwordforx'] = 'Zure hitza \'{$a}\'-rako';
$string['zippingbackup'] = 'Segurtasun-kopia zipeatzen';
