<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'eu', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Sarrera ukatu egin zaizu';
$string['accounts'] = 'Kontuak';
$string['addcategory'] = 'Gehitu kategoria';
$string['additionalhtml'] = 'HTML osagarria';
$string['additionalhtmlfooter'] = 'GORPUTZA itxi baino lehen';
$string['additionalhtmlfooter_desc'] = 'Edukia orri bakoitzean gehituko da BODY etiketa itxi baino lehen.';
$string['additionalhtmlhead'] = 'Goiburuaren barruan';
$string['additionalhtmlhead_desc'] = 'Edukia orri bakoitzean gehituko da HEAD  etiketaren amaieran.';
$string['additionalhtml_heading'] = 'Orri bakoitzean gehitzen den HTML osagarria';
$string['additionalhtmltopofbody'] = 'BODY zabalik dagoenean';
$string['additionalhtmltopofbody_desc'] = 'Edukia orri bakoitzean gehituko da BODY etiketa irekitakoan.';
$string['admincategory'] = 'Kategoria: {$a}';
$string['adminseesall'] = 'Kudeatzaileek dena ikusten dute';
$string['adminseesallevents'] = 'Kudeatzaileek agerraldi guztiak ikusten dituzte';
$string['adminseesownevents'] = 'Kudeatzaileak gainerako erabiltzaileak bezalakoak dira';
$string['advancedfeatures'] = 'Funtzio aurreratuak';
$string['allcountrycodes'] = 'Herrialdeetako kode guztiak';
$string['allowbeforeblock'] = 'Baimendutako zerrenda prozesatuko da lehenik';
$string['allowbeforeblockdesc'] = 'Berez, lehenbizi blokeatutako IPen zerrenda prozesatuko da; aukera hau gaituz gero, baimendutako IP zerrenda lehenago prozesatuko da blokeatutako zerrenda baino.';
$string['allowblockstodock'] = 'Utzi blokeak ertzera eramaten';
$string['allowcategorythemes'] = 'Kategoriaren itxurak baimendu';
$string['allowcoursethemes'] = 'Ikastaroaren itxurak baimendu';
$string['allowediplist'] = 'Baimendutako IP zerrenda';
$string['allowemailaddresses'] = 'E-posta domeinuak baimendu';
$string['allowframembedding'] = 'Baimendu markoa enbotatzea';
$string['allowguestmymoodle'] = 'Baimendu bisitariei Nire Moodle-rako sarbidea';
$string['allowobjectembed'] = 'Baimendu EMBED eta OBJECT etiketak';
$string['allowthemechangeonurl'] = 'Itxurak URL-n aldatzea baimendu';
$string['allowuserblockhiding'] = 'Erabiltzaileei blokeak ezkutatzen utzi';
$string['allowuserswitchrolestheycantassign'] = 'Rolak ezartzeko gaitasuna ez duten erabiltzaileei rolak aldatzen utzi';
$string['allowuserthemes'] = 'Erabiltzailearen itxurak baimendu';
$string['antivirus'] = 'Antibirusa';
$string['appearance'] = 'Itxura';
$string['aspellpath'] = 'Aspell-erako bidea';
$string['authentication'] = 'Autentifikazioa';
$string['authpreventaccountcreation'] = 'Kontuen sorrera ekiditen du identifikatzean';
$string['authpreventaccountcreation_help'] = 'Erabiltzaile batek izena eman eta bere kontua oraindik ere ez badago, automatikoki sortuko da bat gunean. Izena emateko kanpoko datu-basea erabiltzen bada, LDAP esterako, baina aldez aurretik kontua duten erabiltzaileei baino ez bazaie gunean sartzen utzi nahi, gaitu egin behar da aukera hau. Kontu berriak eskuz sortu beharko dira edo erabiltzaileak igotzeko funtzioa erabilita. Kontuan izan ezarpen honek ez diola eragiten MNet izena emateko aukerari.';
$string['authsettings'] = 'Autentifikazioa kudeatu';
$string['autolang'] = 'Atzeman hizkuntza automatikoki';
$string['autologinguests'] = 'Bisitarientzako sarbide automatikoa';
$string['availablelicenses'] = 'Eskura dauden lizentziak';
$string['availableto'] = 'Eskuragarria honentzat';
$string['backgroundcolour'] = 'Kolore gardena';
$string['backups'] = 'Segurtasun-kopiak';
$string['backup_shortname'] = 'Erabili ikastaroaren izena segurtasun-kopiaren fitxategi-izenean';
$string['backup_shortnamehelp'] = 'Erabili ikastaroaren izena segurtasun-kopiaren fitxategiaren izen gisa';
$string['badwordsconfig'] = 'Zentsuratutako hitzen zerrenda idatzi, komaz banatuta';
$string['badwordsdefault'] = 'Zerrenda pertsonalizatua hutsik badago, berezko zerrenda erabiliko da.';
$string['badwordslist'] = 'Zentsuratutako hitzen zerrenda pertsonalizatua';
$string['blockediplist'] = 'Blokeatutako IP zerrenda';
$string['blockeditingmenu'] = 'Blokeak editatzeko menua';
$string['blockinstances'] = 'Instantziak';
$string['blockmultiple'] = 'Anitza';
$string['blockprotect'] = 'Babestu instantziak';
$string['blocksettings'] = 'Blokeak kudeatu';
$string['blockunprotect'] = 'Babesa kendu';
$string['bloglevel'] = 'Bloga ikusi';
$string['bookmarkadded'] = 'Laster-marka gehituta.';
$string['bookmarkalreadyexists'] = 'Orri hau markatua duzu dagoeneko';
$string['bookmarkdeleted'] = 'Laster-marka ezabatuta.';
$string['bookmarkthispage'] = 'Markatu orri hau';
$string['cacheapplication'] = 'Aplikazio-cachea';
$string['cacheapplicationhelp'] = 'Cachean gordetako elementuak erabiltzaile guztiekin partekatzen dira eta biziraupen jakin bat dute (ttl).';
$string['cachejs'] = 'Javascript-en cachea';
$string['cachejs_help'] = 'Cache-an gordetzeak eta Javascript bihurtzeak orria kargatzea izugarri hobetzen dute. Hau gomendagarria da lanean ari diren guneentzat. Garatzaileek ezarpen hau desgaitu nahiko dute, ziurrenik.';
$string['cacherequest'] = 'Eskatu cachea';
$string['cachesession'] = 'Saio-cachea';
$string['cachesettings'] = 'Cachearen ezarpenak';
$string['cachetext'] = 'Testuaren cachearen bizi-iraupena';
$string['caching'] = 'Cachean gordetzea';
$string['calendarexportsalt'] = 'Egutegia esportatzeko eraldaketa';
$string['calendarsettings'] = 'Egutegia';
$string['calendartype'] = 'Egutegi-mota';
$string['calendar_weekend'] = 'Asteburuko egunak';
$string['cannotdeletemodfilter'] = 'Ezin duzu \'{$a->filter}\' desinstalatu \'{$a->module}\' moduluaren zati bat baita.';
$string['cannotuninstall'] = '{$a} ezin da desinstalatu.';
$string['cfgwwwrootslashwarning'] = 'Ez duzu egoki definitu $CFG->wwwroot zure config.php fitxategian. Bukaeran \'/\' karakterea sartu duzu. Mesedez kendu, edo honelako bug baten mezua sortuko zaizu <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Ez duzu egoki definitu $CFG->wwwroot zure config.php fitxategian. Ez du adierazi orri honetarako sarbiderako erabiltzen ari zaren URLa. Mesedez zuzendu, edo honelako bug baten mezua sortuko zaizu <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'aldatu';
$string['checkboxno'] = 'Ez';
$string['checkboxyes'] = 'Bai';
$string['choosefiletoedit'] = 'Aukera ezazu fitxategi bat editatu ahal izateko';
$string['clamfailureonupload'] = 'Errorea clam AV clam-ean';
$string['cleanup'] = 'Garbiketa';
$string['clianswerno'] = 'e';
$string['cliansweryes'] = 'b';
$string['cliincorrectvalueerror'] = 'Errorea, "{$a->value}" balorea ez da egokia "{$a->option}"-rako';
$string['cliincorrectvalueretry'] = 'Balore ezegokia, mesedez saiatu berriz';
$string['clistatusdisabled'] = 'Egoera: desgaituta';
$string['clistatusenabled'] = 'Egoera: gaituta';
$string['clitypevalue'] = 'Sartu balorea';
$string['clitypevaluedefault'] = 'sartu balorea, sakatu Enter-i berezko balorea erabiltzeko ({$a})';
$string['cliunknowoption'] = 'Aukera ezezagunak:{$a}
Mesedez, erabili --laguntza aukera.';
$string['cliupgradefinished'] = 'Lerro komandoa egoki eguneratu da.';
$string['cliupgradenoneed'] = 'Ez da eguneraketarik behar instalatutako  {$a} bertsiorako.';
$string['cliyesnoprompt'] = 'idatzi b (bai esateko) edo e (ez esateko)';
$string['commentsperpage'] = 'Orriko erakutsiko diren iruzkinak';
$string['commonfiltersettings'] = 'Iragazkien ezarpen komunak';
$string['commonsettings'] = 'Ezarpen komunak';
$string['componentinstalled'] = 'Osagaia instalatuta';
$string['computedfromlogs'] = 'Log-etarako konputatua {$a}-tik';
$string['condifmodeditdefaults'] = 'Berezko baloreak jarduera edo baliabide berria sortzeko formularioaren ezarpenetan erabiliko dira.';
$string['confeditorhidebuttons'] = 'Aukeratu HTML editorean ezkutuan egongo diren botoiak';
$string['configallcountrycodes'] = 'Hainbat tokitan, erabiltzailearen profilean esaterako, aukeratzeko erabiliko den herrialdeen zerrenda da hau. Zuri utzita (berezkoa) Ingelesezko hizkuntza-pakete estandarreko countries.php fitxategiko zerrenda erabiliko da. ISo 3166-1-eko zerrenda da hau. Bestela, komaz banatuta zehaz dezakezu kodeen zerrenda, adibidez \'GB,FR,ES\'. Berririk gehitzen baduzu, kode ez estandarrak alegia, zure hizkuntza-paketeko countries.php fitxategira ere gehitu beharko dituzu.';
$string['configallowassign'] = 'Ezkerreko rolak dituztenei beste batzuei rolen zutabekoren bat ezartzen utzi';
$string['configallowblockstodock'] = 'Gaituz gero eta aukeratutako itxurak onartzen badu, erabiltzaileak blokeak bazterrera eraman ditzake.';
$string['configallowcategorythemes'] = 'Hau gaituta, itxurak kategoria mailan ezar daitezke. Honek beheragoko kategoria eta ikastaro guztiei eragingo die ez bazaie beste itxura bat propio ezarri. KONTUZ: Itxurak gaitzeak errendimenduari eragin ahal dio.';
$string['configallowcoursethemes'] = 'Aukera hau hartuz gero, ikastaroen itxura aldatu ahal izango da. Ikastaroen itxurak lehentasuna du beste itxurekiko (gunea, erabiltzailea edo saioa)';
$string['configallowemailaddresses'] = 'E-posta helbideak domeinu partikularretara murriztu nahi badituzu, zerrenda itzazu tarteek banatuta. Beste domeinu guztiak gaitzetsiko dira, adibidez, <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowobjectembed'] = 'Lehenetsitako segurtasun-neurri gisa, erabiltzaile arruntek ezingo dute HTML kodean multimedia-objekturik txertatu (adibidez, Flash) testuaren barruan EMBED eta OBJECT etiketen bidez (media-plugin iragazkiekin egiterik izango da, baina). Marka horiek onartzea nahi baduzu, aukera aktibatu.';
$string['configallowoverride'] = 'Zutabeetan agertzen diren rolak beste batzuei baliogabetzen utzi ahal diezu ezkerreko rolak dituztenei';
$string['configallowoverride2'] = 'Aukera ezazu zein rol baliogabetu ahal duen ezkerreko zutabeko rol bakoitzak.<br />Kontuan izan ezarpen hau moodle/role:override edo moodle/role:safeoverride gaitasunak baimenduta dituzten erabiltzaileei baino ezin zaiela aplikatu.';
$string['configallowthemechangeonurl'] = 'Gaituta, itxura aldatu egin daiteke edozein Moodle-ren URL-tatik itxura={themename} gehituta.';
$string['configallowuserblockhiding'] = 'Erabiltzaileek guneko aldeetako blokeak erakutsi eta ezkutatu ahal izatea nahi al duzu? Aukera honek Javascript eta kukiak erabiltzen ditu blokeen egoera gogoratzeko, eta erabiltzaileek informazioa nola ikusiko duten zehazten du.';
$string['configallowuserswitchrolestheycantassign'] = 'Berez, moodle/role:assign beharrezkoa da erabiltzaileek beste rol bat hartu ahal izateko. Ezarpen hau gaituta baldintza hori kendu egiten duzu eta ondorioz "Aukeratu beste rol bat" zabaltzen den menuan agertuko diren rolak "Baimendu rol esleipenak" taulan ezarritakoak bakarrik baldintzatuko du. Gomendagarria da "Baimendu rol esleipenak" taulako ezarpenek ez ematea erabiltzaileei duten rolak baino gaitasun handiagoa duen beste bat hartzeko aukera.';
$string['configallowuserthemes'] = 'Aukera hau aktibatzen baduzu, erabiltzaileek nahi duten itxura aukeratu ahal izango dute. Erabiltzailearen itxurak gunearenarekiko lehentasuna dauka (baina ez ikastaroarenarekiko)';
$string['configallusersaresitestudents'] = 'Web gunearen lehen orriko jarduerei dagokienez, erabiltzaile guztiak ikasletzat hartu behar al dira? Erantzuna "Bai" balitz, onartutako partaide guztiek jardueratan parte ahal izango lukete. Erantzuna "Ez" balitz, gutxienez ikastaro batean parte hartzen dutenek izango dute eskubide hori. Bakarrik horretarako esleitutako kudeatzaileek eta irakasleek lehen orriko jardueretan parte har dezakete.';
$string['configauthenticationplugins'] = 'Mesedez, aukera itzazu erabili nahi dituzun autentifikazio-pluginak eta jar itzazu ordenan.';
$string['configautolang'] = 'Lehenetsitako hizkuntza atzeman nabigatzailetik, gunearen berezko balore desgaitua erabiltzen bada.';
$string['configautologinguests'] = 'Bisitariei sarbidea onartzen duten ikastaroetara automatikoki sartzen utziko al zaie?';
$string['configbloglevel'] = 'Aukera honek gune honetan erabiltzaileen blogak ikusteko mailak murrizten utziko dizu. Kontuan izan ikusten dituenaren gehienezko testuingurua zehazten dela baina ez mezuak bidaltzen dituenarena eta ezta blogera bidalitako mezu-motena ere. Nahi izanez gero, blogak erabat desgaitu daitezke.';
$string['configcachetext'] = 'Gune handietan edo testu-filtroak erabiltzen dituztenetan, aukera honek abiadura handi dezake. Testuen kopiak prozesatutako moduan hemen adierazitako denbora epean gordeko dira. Egokitzapena oso txikia bada, prozesua motelduko da, baina oso handia bada testuen berrezarpenak gehiegi iraungo du (adibidez, esteka berriekin).';
$string['configcalendarexportsalt'] = 'Ausazko testu hau egutegiak esportzeko orduan erabilitako fitxen autentifikazioaren segurtasuna hobetzeko erabiltzen da. Kontuan izan fitxa guztiak indargabetuko direla eraldaketa hau aldatzen baduzu.';
$string['configclamactlikevirus'] = 'Fitxategiak birusak bailiren tratatu';
$string['configclamdonothing'] = 'Fitxategiak onak bailiren tratatu';
$string['configclamfailureonupload'] = 'Igotako fitxategiak eskaneatzeko clam konfiguratu baduzu, baina arrazoi ezezagunengatik oker balebil, zer egin beharko luke? \'Fitxategiak birus bailiren tratatu\' aukeratuz gero, fitxategi horiek koarentena-eremura eraman edo ezabatuko dira. \'Fitxategiak onak bailiren tratatu\' aukeratuz gero, fitxategiak helmugara eramango dira. Edozein kasutan, kudeatzaileek oharra jasoko dute clam-ek huts eginez gero. \'Fitxategiak birusak bailiren tratatu\' aukeratuko bazenu eta clam-ek huts egingo balu (normalean adierazitako bide okerrarengatik), igotako fitxategi GUZTIAK koarentena-eremura eraman edo ezabatuko dira. Kontuz ibili.';
$string['configconvertformat'] = 'If <i>latex</i>, <i>dvips</i> eta <i>convert</i> gaituta badaude, irudiak zehaztutako formatua erabilita sortuko dira. Bestela, mimeTeX erabiliko da eta GIF irudiak sortuko dira.';
$string['configcookiehttponly'] = 'PHP 5.2.0 funtzio berria gaitu - nabigatzaileei adierazten zaie benetako hppt-en eskariei bakarrik bidaltzeko \'cooki-a\'. Cooki-ak ez lirateke eskuratu behar scrpt hizkuntzetatik. Nabigatzaile guztiek ezin dute funtzio hau garatu eta agian ez da oraingo kodearekin bateragarri izango. Hainbat XSS erasori aurre egiten laguntzen du.';
$string['configcookiesecure'] = 'Zerbitzariak https konexioak bakarrik onartzen baditu, cooki seguruak bidaltzea gaitzea gomendatzen da. Aukera hau gaituta badago, ziurtatu, falborez, web-zerbitzariak ez duela onartzen http:// eta https:// helbideetarako behin betiko birzuzenketa ez duzula ezarri. <em>wwwroot</em> helbide bat https://-rekin hasten ez denean ezarpen hau automatikoki desgaitzen da.';
$string['configcountry'] = 'Herrialde bat aukeratuz gero, herrialde hori lehenetsitako balorea izango da kontu edo erabiltzaile  berrientzat. Erabiltzaileak herrialde bat aukeratzera behartzeko, aukera ez hartu.';
$string['configcourserequestnotify'] = 'Erabiltzailearen erabiltzaile-izena ikastaro berriaren eskaria egiten denerako';
$string['configcourserequestnotify2'] = 'Ikastaro-eskaria egiten denean jakinarazpena jasoko duten erabiltzaileak. Ikastaro-eskariak onar ditzaketen erabiltzaileak bakarrik agertuko dira zerrenda honetan.';
$string['configcoursesperpage'] = 'Ikastaro-zerrenda batean orriko zenbat ikastaro erakutsi behar den adierazi.';
$string['configcronclionly'] = 'Aukera hau gaituz gero, cron-aren script-a komando-lerro batetik baino ezingo da egikaritu, web bidez izan beharrean. Honek beheragoko ezarpena -cron-aren pasahitza- uzten du bertan behera.';
$string['configcronremotepassword'] = 'Honek esan nahi du cron.php script-a ezin dela web nabigatzaile batetik egikaritu pasahitza eman gabe, ondokoa bezalako URL motako formularioa erabiliz: <pre>http://site.example.com/admin/cron.php?password=opensesame
</pre>. Hutsik utziz gero, ez da pasahitzik behar.';
$string['configcurlcache'] = 'cURL cachearen biziraupena, segundutan.';
$string['configcustommenuitems'] = 'Pertsonalizatutako menua sor dezakezu zure Moodle gunearen goiko aldean erakusteko. Menu hau gaika antola daiteke eta horrela, lerro bakoitzak menuaren testu bat, URL esteka bat (aukerakoa) eta izenburuaren deskribapena (aukerakoa) hartzen ditu, lerro horizontal batek | banatuta (AltGr + 1) . Gidoiak erabilita, azpimenuen egitura sor daiteke. Adibidez:

<pre>
Moodle komunitatea|https://moodle.org
-Moodle komunitateko foroak|https://moodle.org/support
-Moodle garapena|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle-ren dokumentazio ofiziala
--Dokumentazioa eukaraz|http://docs.moodle.org/eu|Dokumentazioa euskaraz|de
Moodle.com|http://moodle.com/
</pre>';
$string['configdbsessions'] = 'Aukera hau hartuz gero, saioen informazioa metatzeko datu-basea erabiliko da. Hau bereziki erabilgarri suertatzen da gune handi edo zerbitzarien multzoetan (\'clusters\') bildutakoen kasuan. Kasu gehienetan zuriz utzi beharko litzateke horren ordez zerbitzariaren diskoa erabil dadin. Ohar zaitez honen aldaketa erabiltzaile guztiak deskonektatuko dituela, zeu ere barne.';
$string['configdebug'] = 'Aukera hau aktibatuz gero, PHP error_reporting indarrean jarriko da, eta gastigu gehiago jasoko duzu. Garatzaileentzat baino ez da erabilgarria.';
$string['configdebugdisplay'] = 'Aukera hau gaituz gero, erroreen txostena HTML orrira joango da. Praktikoa da baina, oro har, XHTML, JS, kukiak eta HTTP goiburuak apurtzen ditu. Aukera hau desgaituz gero, zerbitzariaren erregistroetara bidaliko da eta arazketa hobeto egingo da. PHpren error_log ezarpenak zein erregistrotara doan kontrolatzen du.';
$string['configdebugpageinfo'] = 'Gaitu orriaren informazioa orri-oinean inprimatzea nahi baduzu.';
$string['configdebugsmtp'] = 'SMTP zerbitzarira posta elektronikoak bidali bitartean, informazio zehatzeko garbiketa gaitzen du.';
$string['configdefaulthomepage'] = 'Honek zehazten du identifikatutako erabiltzaileentzako hasiera-orria ';
$string['configdefaultrequestcategory'] = 'Erabiltzaileek eskatutako ikastaroak kategoria honetan kokatuko dira automatikoki.';
$string['configdefaultrequestedcategory'] = 'Eskatutako ikastaroak barneratuko dituen lehenetsitako kategoria, onartuak izatekotan.';
$string['configdefaultuserroleid'] = 'Hemen, gune-mailan, zehazten duzun rolaren baimenak emango zaizkie autentifikatutako erabiltzaile guztiei, izan ditzaketen beste rolez GAIN. Berezko rola Bisitaria da. Honek ez du arazorik sortuko dituzten gainontzeko rolekin: erabiltzaile guztiek gunean zerbait erabilgarri egin dezaketela bakarrik ziurtatzen du (besteak beste, foroetan eztabaidak irakurri, baliabideak kontsultatu, e.a.)';
$string['configdeleteincompleteusers'] = 'Tarte honen ondoren, ezarri ez diren kontu zaharrak ezabatu egingo dira.';
$string['configdeleteunconfirmed'] = 'E-postan oinarritutako autentifikazioa erabiltzen ari bazara, hau da erabiltzaileek bidalitako erantzuna onartzeko denbora-epea. Horren ondoren, baieztatu gabeko kontu guztiak ezabatuko dira.';
$string['configdenyemailaddresses'] = 'Domeinu batzuen e-posta helbideak gaitzesteko, horien zerrenda hemen idatzi. Beste domeinu guztiak onartu egingo dira. Adibidez, <strong>hotmail.com euskalnet.net</strong>';
$string['configdisableuserimages'] = 'Erabiltzaileek beren profiletako irudiak aldatzeko aukera desgaitu.';
$string['configdisplayloginfailures'] = 'Aukera honek hautatutako erabiltzaileei huts egindako aurreko sarrerei buruzko informazioa erakusten die.';
$string['configdocroot'] = 'Moodle Doc-etarako bidea definitzen du. Aukera hau aldatu egin ahal duzu zeure on line dokumentazioa izan nahi baduzu. Dena dela, hori egiten baduzu, ziurtatu zure dokumentazioaren bideak http://docs.moodle.org -en formatu bera dutela.';
$string['configdoctonewwindow'] = 'Hau aukeratuz gero, Moodle Doc-etarako estekak leiho berrian erakutsiko dira.';
$string['configeditordictionary'] = 'Balore hau erabiliko da zuzentzaile ortografikoak erabiltzaileen hizkuntzako hiztegia ez baldin badu.';
$string['configeditorfontlist'] = 'Editoreari ateratzen zaion menuaren zerrendan agertuko diren letra-motak aukeratu.';
$string['configemailchangeconfirmation'] = 'Erabiltzaileek profiletan posta elektronikoaren helbidea aldatzen dutenean, beharrezko da baieztatzea.';
$string['configenableajax'] = 'Aukera honekin AJAX-en (Javascript-bezero/zerbitzari interfaz aurreratuak Javascript-a erabilita) erabilera kontrolatuko duzu gune osoan. Ezarpen hau gaituta erabiltzaileek aukera egin dezakete euren profiletan, bestela AJAX desgatituta dago guztientzat.';
$string['configenablecalendarexport'] = 'Gaitu egutegiak esportatzea eta harpidetzea.';
$string['configenablecomments'] = 'Iruzkinak gaitu';
$string['configenablecourserequests'] = 'Edozein erabiltzailek ikastaro bat sortzeko eska dezala ahalbidetzen du.';
$string['configenabledevicedetection'] = 'Ezarpen hau gaitzeak telefono mugikorrak, smartphone-ak, tabletak edo berezko gailuak (mahai-gaineko ordenagailuak, ordenagailu eramangarriak, e.a.)  atzematea baimentzen du, itxura edo beste ezaugarri batzuk aplikatu ahal izateko.';
$string['configenablegroupmembersonly'] = 'Gaituta, jardueratarako sarbidea taldekideentzat bakarrik dago mugatuta. Lan handiagoa eska diezaioke zerbitzariari. Gainera, kalifikazio-liburuko kategorietan nolabaiteko ezarpena beharko da jarduerak taldekide ez direnentzat ezkutuan geratuko direla ziurtatzeko.';
$string['configenablerssfeeds'] = 'Aukera honek RSS jarioetarako kanaletarako sarbidea ahalbidetzen du. Edozein aldaketa ikusteko moduluetan ere RSS jarioak aktibatu behar dira (Admin - Konfiguraziora joan).';
$string['configenablerssfeedsdisabled'] = 'Ez dago eskuragarri RSS kanalak gune osoan desaktibatuta daudelako. Aktibatzeko, Aldagaietara joan Admin - Konfigurazioan.';
$string['configenablerssfeedsdisabled2'] = 'RSS jarioak ez daude gaituta zerbitzarian. Lehenik eta behin gaitu egin behar duzu hau Zerbitzaria/RSS-n.';
$string['configenablestats'] = '\'Bai\' aukeratuz gero, Moodle-ko cronjoba erregistroak prozesatu eta estatistika batzuk bilduko ditu. Gunearen trafikoaren arabera, operazio hau luza daiteke. Aukera hau hartuz gero, zure ikastaroen grafiko eta estatistika interesgarri batzuk ikusi ahal izango dituzu, edo gune osoari buruzkoak.';
$string['configenabletrusttext'] = 'Berez, erabiltzaileek idatzitako testua sakon garbituko du Moodle-k segurtasunerako arrisku izan daitekeen edozein \'script\', media e.a. ezabatzeko. Eduki fidagarriaren sistemarekin zure konfiantza duten erabiltzaile jakinei edukietan ezaugarri aurreratu horiek sartzeko baimena ematen diezu, interferentziarik gabe. Sistema gaitzeko, ezarpen hau gaitu behar duzu lehenik eta ondoren eduki fidagarri baimena eman Moodle-ren rol zehatz bati. Erabiltzaile horiek sortu edo igotako testuak fidagarri gisa markatuko dira eta ez dira garbiketa prozesutik pasako erakutsi aurretik.';
$string['configenablewebservices'] = 'Web-zerbitzuak aukera ematen die beste sistema batzuei Moodle honetan identifikatu eta bertan eragiteko. Segurtasunerako, aukera hau desgaitu egin behar da benetan erabiltzen ari ez bazara.';
$string['configerrorlevel'] = 'Erakustea nahi duzun PHP ohar-kopurua aukeratu. Aukera onena \'Arrunta\' da.';
$string['configextendedusernamechars'] = 'Aukera honek ikasleek beren erabiltzaile-izenetan edozein karaktere erabiltzea ahalbidetzen du (honek benetako izenetan eraginik ez daukala ohar zaitez). Lehenetsikako balorea "false" da, erabiltzaile-izenen edukia hizki eta zenbakitara mugatzen duena.';
$string['configextramemorylimit'] = 'Bilatu, segurtasun-kopia/berreskuratu edo cron-ak bezalako script-ek memoria handiagoa behar dute. Gune handietarako ezarri balore handiagoak.';
$string['configfilterall'] = 'Kate guztiak iragazi, goiburu, izenburu, nabigazio-barrak, etab. barne direlarik. Hau bereziki erabilgarri suertatzen da eleanitz-iragazkiarekin; bestela, gunean karga handia ezarriko dugu etekin gutxi lortzeko.';
$string['configfiltermatchoneperpage'] = 'Esteka automatikoaren iragazkiek esteka bakarra sortuko dute orri osoan aurkituko den lehenengo testu-adibide egokiarekiko, beste guztia alde batera utziz.';
$string['configfiltermatchonepertext'] = 'Esteka automatikoaren iragazkiek esteka bakarra sortuko dute orriko testu-elementu bakoitzean (ad. baliabidea, blokea...) aurkituko den lehenengo testu-adibide egokiarekiko, beste guztia alde batera utziz. Ezarpen hau ez da kontuan hartuko orriko ezarpen bakarra <i>bai</i> baldin bada.';
$string['configfilteruploadedfiles'] = 'Aukera honek Moodle-k igotako HTML eta testu-fitxategi guztiak erakutsi aurretik iragazkiekin prozesatzea ahalbidetzen du.';
$string['configforcelogin'] = 'Normalean gunearen orri nagusia eta ikastaroen zerrenda (baina ikastaroak ez) edonork irakur ditzake bere erabiltzaile-izena eta pasahitza idatzi beharrik gabe. Bisitariek EZEIN EDUKIRIK ikusi aurretik gunera pasahitzez sartzera behartu nahi badituzu, aukera hau aktibatu beharko duzu.';
$string['configforceloginforprofiles'] = 'Aukera honek gunera kontu baliagarrien bidez sartzera behartzen du (bisitari gisa ez) erabiltzaile-profilen orria ikusi aurretik. Lehenetsitako balorea "false" da. Honela ikasleek ikastaroko irakasleak ikus ditzakete, baina bilaketa-motoreek ere egin dezakete.';
$string['configfrontpage'] = 'Aukeratutako elementuak gunearen hasiera-orrian erakutsiko dira.';
$string['configfrontpagecourselimit'] = 'Gehieneko ikastaro-kopurua';
$string['configfrontpagecourselimithelp'] = 'Ikastaroak zerrendatzean, gunearen hasiera-orrian erakutsiko den gehieneko ikastaro-kopurua.';
$string['configfrontpageloggedin'] = 'Aukeratutako elementuak gunearen hasiera-orrian erakutsiko dira erabiltzailea autentifikatzen denean.';
$string['configfullnamedisplay'] = 'Aukera honek izenak osorik erakustean nola ikusiko diren definitzen du. Hizkuntza bakarra erabiltzen duten gune gehienek lehenetsitako balorea mantentzea aholkatzen da: ("Izena + Deitura"), baina deitura ezkutatu, edo hizkuntzaren araberako izatea aukera dezakezu (hizkuntza batzuek horretarako arau ezberdinak dituzte eta).';
$string['configgeoipfile'] = 'GeoIP City fitxategi bitarraren kokapena. Fitxategi hau ez dator Moodle-ren pakete estandarrean eta aparte lortu behar da hemen: <a href="http://www.maxmind.com/">MaxMind</a>. Bertsio komertziala nahiz doakoa dituzu eskura. <br />Jaitsi hemendik <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> eta atera zure zerbitzariaren "{$a}" direktorioan.';
$string['configgetremoteaddrconf'] = 'Zure zerbitzaria \'reverse proxy\' baten atzean badago aukera hau erabil dezakezu urrutiko IP helbidea duten zein HTTP goibururekin fida daitekeen zehazteko. Goiburuak ordenean irakurriko dira eta eskura dagoen lehenengoa erabiliko da.';
$string['configgradebookroles'] = 'Ezarpen honek kalifikazio-liburuan nor agertuko den kontrolatzen utziko dizu. Erabiltzaileek hauetako rolen bat izan behar dute gutxienez ikastaro batean ikastaro horretako kalifikazio-liburuan agertzeko.';
$string['configgradeexport'] = 'Aukeratu kalifikazio-liburua esportatzeko zein formatu izango den kalifikazioak esportatzeko metodo nagusia. Aukeratutako lokailuek eremu bat (\'esporatutako azkenak\') erabiliko dute kalifikazio bakoitzerako. Adibidez, honen ondorioz esportatutako erregistroak "berriak" edo "eguneratuta" gisa identifikatuko dira. Hau nola egin ez badakizu, ez markatu ezer.';
$string['confighiddenuserfields'] = 'Ikasleen pribatutasuna handitzeko, irakasle eta kudeatzaileak ez diren ikastaroko erabiltzaileei zer erabiltzaile-eremuren informazioa ezkutatu nahi diezun aukeratu. CTRL sakatuta mantendu eremu batzuk aukeratzeko.';
$string['configidnumber'] = 'Aukera honek zehazten du ea (a) Erabiltzaileei ID zenbakia ez zaien eskatzen, (b) ID zenbakia eskatu, baina zuriz utz dezaketen edo (c) ID zenbakia eskatu eta ezin duten zuriz utzi. Baiezko kasuan, erabiltzailearen ID zenbakia bere profilean erakusten da.';
$string['configintro'] = 'Orri honetan Moodle-k zure zerbitzarian egokiro lan egiten laguntzen duten aldagai-kopuru bat zehatz dezakezu. Horrek ez zaitu gehiegi kezkatu behar: lehenetsitako baloreek ondo funtzionatuko dute eta, hala ere, orri honetara nahi duzunean itzul zaitezke ezarpenak aldatzeko.';
$string['configintroadmin'] = 'Orri honetan zure administratzaile nagusiaren kontua konfiguratu beharko zenuke -horrek gunearen erabateko kontrola emango baitizu-. Erabiltzaile-izen eta pasahitz seguruak erabiltzen dituzula ziur izan, baita zure e-posta helbidea baliagarria dela. Aurrerago administratzaile-kontu gehiago sortu ahal izango dituzu.';
$string['configintrosite'] = 'Orri honek orri nagusia konfiguratzen eta zure gune berriari izena ematen ahalbidetzen dizu. Beranduago itzul zaitezke zerbait aldatzera orri nagusiko \'Gunearen ezarpenak\' loturaren bidez.';
$string['configiplookup'] = 'IP helbidean sakatzen duzunean (adib. 34.12.222.93), erregistroetan bezalaxe, IP horren kokapen ahalik eta zehatzena emango dizu mapan. Hori egiteko, hainbat plugin daude eta aukeratu egin ahal duzu. Bakoitzak bere abantailak eta desabantailak ditu.';
$string['configkeeptagnamecase'] = 'Aukera ezazu hau etiken izenek jatorrizko \'casing\'-a mantentzea  nahi baduzu, sortu zuten erabiltzaileek sartutako bezala';
$string['configlang'] = 'Aukera ezazue gune osorako berezko hizkuntza. Erabiltzaileek baliogabe egin ahal izango dute ezarpen hau hizkuntza-menua edo euren profileko ezarpena erabilita. ';
$string['configlanglist'] = 'Erabiltzaileek Moodle-ren instalazioan dagoen edozein hizkuntza aukeratzeko hau zuriz utz dezakezu. Hala ere, menua laburbil daiteke kakotxez banandutako nahi dituzun hizkuntzen kodeen zerrenda idatziz. Adibidez, eu,fr,it,en,es';
$string['configlangmenu'] = 'Hizkuntza aukeratzeko menua orri nagusian, sarbidean, etab. erakutsi nahi duzun erabaki. Horrek ez du oztopatzen erabiltzaileek beren profilean nahi duten hizkuntza lehenesteko.';
$string['configlatinexcelexport'] = 'Kodifikazioa aukeratu Excel formatuko esportazioetarako.';
$string['configlocale'] = 'Gunearen kokapena aukeratu (honek hizkuntzaren formatan eta datetan eragina izango du). Datu horiek zure sistema eragilean ere instalatuta egon behar dute (ad., en_US.UTF-8 edo es_ES.UTF-8). Zalantzan bazaude, zuriz utzi.';
$string['configloginhttps'] = 'Aukera honek Moodle-ri sarbide orrian https konexio segurua erabilarazten dio (sarbide segurua ziurtatzen) URL http arruntera itzultzeko. KONTUZ: aukera honek https zure zerbitzarian indarrean egotea behar du. Bestela, ZU ZEU EZINGO ZARA GUNERA SARTU.';
$string['configloglifetime'] = 'Aukera honek zehazten du erabiltzaile bakoitzaren jarduera-erregistroak noiz arte gorde nahi dituzun. Aurreko erregistro guztiak ezabatuko dira. Hobe da epe luzean gordetzea (badaezpada behar dituzun) baina zerbitzaria oso lanpetuta balitz eta funtzionamendu arazoak baleude, epea laburtzea komenigarria izan liteke.';
$string['configlookahead'] = 'Aurreikusitako egunak';
$string['configmaxbytes'] = 'Aukera honek gunera igotako fitxategien gehienezko tamaina zehazten du. PHP upload_max_filesize eta LimitRequestBody Apache ezarpenek mugatzen dute. Beste aldetik, aukera honek ikastaro eta moduluetan hauta daitezkeen tamainen tartea ere mugatzen du.';
$string['configmaxconsecutiveidentchars'] = 'Pasahitzak ezin ditu jarrian zenbaki honek adierazten duen kopurua baino karaktere berdin gehiago izan. Erabili 0 hau ekiditeko.';
$string['configmaxeditingtime'] = 'Aukera honek zehazten du erabiltzaileen epea foroetara bidalitako mezuak editatzeko, egunkariaren feed-backa, etab. Normalean 30 minutu epe egokia izaten da.';
$string['configmaxevents'] = 'Aurreikusitako ekitaldiak';
$string['configmessaging'] = 'Guneko erabiltzaileen arteko mezularitza-sistema indarrean jarri nahi al duzu?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Irakurritako jakinarazpenak ezaba daitezke espazioa aurrezteko. Irakurri ondoren, zenbat denbora pasatu behar da ezabatzeko?';
$string['configmessaginghidereadnotifications'] = 'Mezuen historia ikusten ari zarenean, ezkutatu irakurritako jakinarazpenak, foroetako ekarpenak, adibidez.';
$string['configminpassworddigits'] = 'Pasahitzek gutxienez zenbaki-kopuru hau izan behar dute';
$string['configminpasswordlength'] = 'Pasahitzek gutxienez karaktere-kopuru hau izan behar dute';
$string['configminpasswordlower'] = 'Pasahitzek gutxienez letra xeheen kopuru hau izan behar dute.';
$string['configminpasswordnonalphanum'] = 'Pasahitzek gutxienez karaktere alfanumerikoen kopuru hau izan behar dute';
$string['configminpasswordupper'] = 'Pasahitzek gutxienez letra larrien kopuru hau izan behar dute.';
$string['configmycoursesperpage'] = 'Erabiltzaile baten ikastaroen zerrendan erakutsiko den gehienezko ikastaro kopurua.';
$string['configmymoodleredirect'] = 'Aukera honek kudeatzaileak ez direnak sartzean /my-ra eta /my daukan guneko goi mailako breadcrumbera joatera behartzen ditu';
$string['configmypagelocked'] = 'Ezarpen honek babestu egiten du berezko orria kudeatzaile ez den inork edita ez dezan';
$string['confignavcourselimit'] = 'Erabiltzaileari erakutsiko zaion ikastaro-kopurua identifikatu gabe dagoenean edo inongo ikastarotan matrikulatuta ez dagoenean.';
$string['confignavshowallcourses'] = 'Aukera honi esker guneko ikastaro guztiak nabigazio-barran azalduko dira beti.';
$string['confignavshowcategories'] = 'Ikastaro-kategoriak nabigazio-barran eta nabigazio-blokeetan erakutsi. Ikaslea matrikulatuta dagoen ikastaroetan ez du eraginik, eta horrela \'Nire ikastaroak\' zerrendan agertuko dira kategoriarik gabe.';
$string['confignotifyloginfailures'] = 'Sarbide saiakera okerrak erregistratu badira, e-posta oharrak bidal daitezke. Nork ikusiko ditu ohar horiek?';
$string['confignotifyloginthreshold'] = 'Sarbide saiakera okerren oharrak aktibatuta badaude, zenbat saiakera oker beharko da erabiltzaileari edo IP helbide bati oharra bidaltzeko?';
$string['confignotloggedinroleid'] = 'Gunean autentifikatu gabeko erabiltzaileak gunearen testuinguruan rol hau izango balute bezala arituko dira. \'Bisitaria\' zuk nahi duzuna da hemen, baina agian rol mugatzaileagoak sortu nahiko dituzu. Mezuak bidaltzea bezalako kontuek erabiltzailea behar bezala autentifika dadin eskatzen dute.';
$string['configopentogoogle'] = 'Aukera hau aktibatuz gero, Google gunera gonbidatu gisa sartu ahal izango da. Horrez gain, Google-ren bilaketaren bitartez gunera sartzen denak zuzenean gonbidatu gisa egingo du. Aukera honek sarrera zuzena soilik ematen du gonbidatuak onartzen dituzten ikastaroetara.';
$string['configoverride'] = 'config.php-n definituta';
$string['configpasswordpolicy'] = 'Aukera hau gaituz gero, Moodle-k erabiltzailearen pasahitzak alderatuko ditu pasahitzen baliozkotasunerako  espezifikazioekin. Erabil itzazu beheko ezarpenak espezifikazio horiek zehazteko (ez dira kontuan hartuko \'Ez\' aukeratuz gero).';
$string['configpathtoclam'] = 'Clam AVrako bidea. Seguru asko honako zerbait: /usr/bin/clamscan edo /usr/bin/clamdscan. Bide hau Clam AVk funtzionatzeko beharrezkoa da.';
$string['configpathtodu'] = 'Du-rako bidea. Seguru asko honako zerbait: /usr/bin/du. Hori idazten baduzu, direktorioaren edukia erakusten duten orriak askoz azkarrago egikarituko dira direktorioek fitxategi asko dauzkatenean.';
$string['configperfdebug'] = 'Aukera hau aktibatuz gero, itxura estandarreko oinean errendimenduaren informazioa azalduko da.';
$string['configprofileroles'] = 'Erabiltzaile-profiletan eta partaidetza-orrian ikusten den rol-zerrenda';
$string['configprofilesforenrolledusersonly'] = 'Spam sortzaileen gehiegikeriari aurre egiteko, inongo ikastarotan matrikula egin ez duten erabiltzaileen profilen deskribapenak ezkutatu egiten dira. Erabiltzaile berriek gutxienez ikastaro batean matrikulatu behar dute profilaren deskribapena gehitu ahal izateko.';
$string['configprotectusernames'] = 'Berez, forget_password.php-ek ez du ematen inongo zehaztasunik erabiltzaile izenak edo e-posta helbideak asmatzeko.';
$string['configproxybypass'] = 'Proxy-a ekidin beharko luketen ostalari-izen edo IP-en (zati) zerrenda, komaz banatuta (adib., 192.168., .niredomeinua.com)';
$string['configproxyhost'] = '<b>Zerbitzari</b> honek Internetera sartzeko proxy bat behar badu (ad., firewall bat), proxya eta portuaren zenbakia hemen idatzi. Bestela, zuriz utzi.';
$string['configproxypassword'] = 'Internetera proxy bidez sartzeko behar den pasahitza; horrela ez bada, utz ezazu hutsik (beharrezkoa da PHP cURL luzapena).';
$string['configproxyport'] = 'Zerbitzari honek proxy-ordenagailua behar badu, idatzi hemen proxyaren portua.';
$string['configproxytype'] = 'Web proxy mota (PHP5 eta cURL luzapena behar dira SOCKS5 euskarrirako)';
$string['configproxyuser'] = 'Internetera proxy-ren bidez sartzeko behar den erabiltzaile-izena; bestela, zuri utzi (PHP cURL luzapena behar da).';
$string['configquarantinedir'] = 'Clam AVk kutsatutako fitxategiak koarentena direktorio batera eramatea nahi baduzu, hemen idatzi. Direktorioak zerbitzarian idazketa-baimena izan behar du. Zuriz utzi, ez dagoen direktorio baten izena edo idazteko baimenik gabekoa zehaztekotan, kutsatutako fitxategiak ezabatuko dira. Azken barra ez sartu.';
$string['configrecaptchaprivatekey'] = 'Zure Moodle zerbitzariaren eta recaptcha.net zerbitzariaren arteko komunikazioa ezartzeko erabilitako karaktere-multzoa. Gune honetarakoa http://recaptcha.net-en lor dezakezu';
$string['configrecaptchapublickey'] = 'Izena emateko formularioan reCAPTCHA elementua erakusteko karaktere-multzoa. http://recaptcha.net guneak sortua';
$string['configrequestcategoryselection'] = 'Utzi kategoria aukeratzen ikastaro-eskaria egiten denean.';
$string['configrequestedstudentname'] = 'Eskatutako ikastaroetan \'ikaslea\' izendatzeko erabilitako hitza';
$string['configrequestedstudentsname'] = 'Eskatutako ikastaroetan  \'ikasleak\' izendatzeko erabilitako hitza';
$string['configrequestedteachername'] = 'Eskatutako ikastaroetan  \'irakaslea\' izendatzeko erabilitako hitza';
$string['configrequestedteachersname'] = 'Eskatutako ikastaroetan  \'irakasleak\' izendatzeko erabilitako hitza';
$string['configrequiremodintro'] = 'Aukera hau desgaitu, erabiltzaileek jarduera bakoitzean deskribapena idaztera behartu nahi ez badituzu.';
$string['configrunclamavonupload'] = 'Gaitzen denean, clam AV igotako fitxategi guztiak eskaneatzeko erabiliko da.';
$string['configrunclamonupload'] = 'Fitxategi bat igotzean clam AV egikaritu behar al da? Honek funtzionatzeko bide zuzena beharrezkoa da \'pathtoclam\'. (Clam AV http://www.clamav.net/ helbidetik jaitsi daitekeen doako antibirus bat da)';
$string['configsectioninterface'] = 'Interfazea';
$string['configsectionmail'] = 'Posta';
$string['configsectionmaintenance'] = 'Mantenua';
$string['configsectionmisc'] = 'Bestelakoak';
$string['configsectionoperatingsystem'] = 'Sistema eragilea';
$string['configsectionpermissions'] = 'Baimenak';
$string['configsectionrequestedcourse'] = 'Ikastaro-eskariak';
$string['configsectionsecurity'] = 'Segurtasuna';
$string['configsectionstats'] = 'Estatistikak';
$string['configsectionuser'] = 'Erabiltzailea';
$string['configsecureforms'] = 'Moodle-k segurtasun-maila altuagoa erabil dezake web formularioetako datuak onartzen dituenean. Aukera aktibatuz gero, nabigatzailearen HTTP_REFERER formularioaren helbidearekin konparatuko da. Honek oso kasu gutxitan emango ditu erroreak erabiltzaileak firewalla badauka (ad., ZoneAlarm) bere HTTP_REFERER web trafikotik aparte izateko. Sintoma formularioan \'trabatuta\' geratzea izaten da. Erabiltzaileek, esaterako, sarbide orrian arazorik izango balute, agian aukera hau desaktibatzea komeniko litzateke, gunea indar gordineko (brute force) erasoetara irekiago uzteko desabantailarekin. Zalantza kasuan, \'Bai\' aukera ezazu.';
$string['configsessioncookie'] = 'Aukera honek Moodle-ko saioetako kukiaren izena pertsonalizatzen du. Aukerazkoa da, eta praktikoa izaten da soilik zerbitzari berean Moodle-ko beste kopia bat egikaritzen ari denean kukiak nahas daitezkeelako.';
$string['configsessioncookiedomain'] = 'Honek Moodle cookiak hartuko diren domeinua aldatzeko aukera ematen dizu. Erabilgarria da Moodle saioaren informazioa beste azpidomeinu bateko web-aplikazio batekin sarean egotea eskatzen duten pertsonalizazioetarako (adib. autentifikazio edo matrikulatzeko pluginak). <strong>KONTUZ: erabat gomendatzen da ezarpen hau berez datorren bezala uztea (hutsik) - balio ez duen balore batek guneko sarbide guztiak galeraziko ditu.</strong>';
$string['configsessioncookiepath'] = 'Nabigatzaileek Moodle-ren kukiak bidaltzen dituzten lekua aldatu beharra baduzu, aukera hau alda dezakezu zure web-gunean azpidirektorio bat zehazteko. Bestela ondo ibiliko da berezko \'/\'.';
$string['configsessiontimeout'] = 'Gunean konektatutako erabiltzaileek epe luzean aktibitaterik ez badute (ad., ez badute orririk kargatzen), automatikoki deskonektatuko dira (ad., saioa amaituko da). Aldagai honek deskonektatu baino lehen pasa beharreko aktibitaterik gabeko epea zehazten du.';
$string['configshowcommentscount'] = 'Iruzkin-kopurua erakutsiz gero, beste kontsulta bat egin beharko da iruzkinetarako esteka erakusten denean';
$string['configshowicalsource'] = 'Erakutsi iturburuaren informazioa iCal ekitaldietarako';
$string['configshowsiteparticipantslist'] = 'Guneko ikasle eta irakasle guztiak partaideen zerrendan azalduko dira. Nork ikus dezake zerrenda hori?';
$string['configsitedefaultlicense'] = 'Gunearen berezko lizentzia';
$string['configsitedefaultlicensehelp'] = 'Gune honetan edukia argitaratzeko erabiliko den berezko lizentzia';
$string['configsitemaxcategorydepth'] = 'Gehienezko kategoria-mailak';
$string['configsitemaxcategorydepthhelp'] = 'Honek zehazten du gehienez zenbat azpiko kategoria erakutsiko den zerrenda moduan erakusteko garaian. Maila sakonagoetan dauden kategoriak esteka moduan agertuko dira eta erabiltzaileak zabaldu ahal izango ditu AJAX eskaeren bitartez.';
$string['configslasharguments'] = 'Fitxategiak (irudiak, igotakoak, etab.) \'slash arguments\' erabiltzen duen script baten bidez ematen dira (bigarren aukera hemen). Metodo honek fitxategiak nabigatzaileen, proxy zerbitzarien eta abarren cachean errazago sartzea ahalbidetzen du. Zoritxarrez, PHP zerbitzari batzuek ez dute metodo hau onartzen. Hori dela eta, igotako fitxategiak edo irudiak ikusteko arazorik bazenu (ad., erabiltzaileen argazkiak), lehengo aukera hautatu.';
$string['configsmartpix'] = 'Aktibatuta, lehenik oraingo itxura, ondoren goragoko itxura guztiak eta ondoren Moodle-ren /pix karpeta bilatzen duen PHP script baten bitartez emten dira ikonoak. Horrela, ez da beharrezkoa irudi-fitxategiak behin baino gehiagotan izatea itxuretan, baina errendimentua jaitsi egiten da pixka bat.';
$string['configstartwday'] = 'Astearen hasiera';
$string['configstatsfirstrun'] = 'Aukera honek zehazten du erregistroak noiztik prozesatu behar diren cronjobak estatistikak prozesatzen dituen <b>lehenengo aldian</b>. Guneak trafiko handia pairatzen badu eta zerbitzaria elkarbanatua bada, seguru asko laster hastea ez ideia ona izango, horrek luze joko duelako eta baliabide asko erabiliko direlako. (Aukera honetan hilabetea 28 egunen baliokidea dela ohartu. Sortutako grafiko eta txostenei dagokienez, aldiz, hilabetea egutegiko hilabetea da).';
$string['configstatsmaxruntime'] = 'Prozesamendu estatistikoa oso astuna izan daitekeenez, eremu hau hurrengoarekin elkartzea komenigarria da noiztik eta noiz arte martxan iraungo duen zehazteko.';
$string['configstatsmaxruntime2'] = 'Estatistika-datuen prozesamendua oso trinkoa izan daiteke. Zehaztu gehienez zenbat denbora utziko den eguneko estatistikak jasotzeko. Kronaren agikaritza batean prozesatutako gehienezko egun kopurura 31 da.';
$string['configstatsmaxruntime3'] = 'Zehaztu gehienez zenbat denbora utziko den eguneko estatistikak kalkulatzeko, kontuan izanda estatistika-datuen prozesamenduak gainkarga ezartzen diola zerbitzariari. Beherago zehaz daiteke kronean prozesatutako gehienezko egun kopurua.';
$string['configstatsruntimedays'] = 'Zehaztu estatistika-datuen azterketa bakoitzean prozesatutako gehienezko egun kopurua. Estatistikak eguneratuta daudenean egun bakarra prozesatuko da eta beraz  balore hau zure zerbitzariaren kargaren arabera doitu beharko duzu eta gutxitu krona sarriago egikaritu behar bada.';
$string['configstatsruntimestart'] = 'Noiz <b>hasiko da</b> lanean estatistikak prozesatzen dituen cronjoba? Mesedez, zehaztu une ezberdinak zerbitzari batean hainbat Moodle baldin badago.';
$string['configstatsuserthreshold'] = 'Ezarpen honek zehazten du gutxienez zenbat erabiltzaile izan behar dituen matrikulatuta ikastaro batek estatistiken kalkuluan sartzeko.';
$string['configstripalltitletags'] = 'Desmarkatu aukera hau HTML etiketa eta baliabide-izenetan baimentzeko.';
$string['configsupportemail'] = 'E-posta helbide hau guneko erabiltzaileei eskainiko zaie laguntza orokorra behar badute bertara jotzeko ( adibidez, erabitlzaile batek bere kontua sortzen duenean). Zuri utzita, ez da aipatutako laguntzarako helbiderik eskainiko.';
$string['configsupportname'] = 'Hau da e-posta edo web gune bidez laguntza orokorra eskaintzen duen  pertsona edo beste erakunde baten izena.';
$string['configsupportpage'] = 'E-posta helbide hau guneko erabiltzaileentzat argitaratuko da, laguntza orokorra behar dutenean erabiltzeko (adibidez, erabiltzaile berri batek bere kontua sortzen duenea). Hutsik utziz gero, ez da dagokion esteka agertuko.';
$string['configthemelist'] = 'Aukera hau zuriz utzi baliozko edozein itxuraren erabilera baimentzeko. Itxuren menua laburbildu nahi baduzu, kakotxez berezitako izenbururen zerrenda adieraz dezakezu (Ez utzi tarterik!). Adibidez: standard,orangewhite';
$string['configtimezone'] = 'Hemen lehenetsitako ordutegi-eremua erabaki dezakezu. Hauxe da LEHENETSITAKO ordutegi-eremu bakarra datak erakusteko -erabiltzaileek beren profiletan alda dezakete-. "Zerbitzariaren orduak" Moodle-k sistema eragilearen ordua lehenestea ekarriko du, baina aukera bera erabiltzailearen profilean hautatuz gero dagokion ordutegi-eremua ezarriko du.';
$string['configuseblogassociations'] = 'Aukera izan behar al dute erabiltzaileek euren blog-a antolatzeko sarrerak ikastaroekin eta ikastaro-moduluekin lotuta?';
$string['configuseexternalyui'] = 'Fitxategi lokalak erabili beharrean, erabili Yahoo&#145;s fitxategitatik eskuratzeko moduko on-line fitxategiak. KONTUZ: interneterako konexioa beharrezkoa da; bestela, AJAX ez da ibiliko zure gunean.';
$string['configuserquota'] = 'Erabiltzaileak bere fitxategi-pribatu eremuan gorde ahal duen gehinezko byte kopurua. {$a->bytes} byt == {$a->displaysize}';
$string['configusetags'] = 'Web gunean zehar etiketen funtzionalitatea gaitu nahi al duzu?';
$string['configvariables'] = 'Aldagaiak';
$string['configverifychangedemail'] = 'Baimendutako eta debekatutako e-posta elektronikorako domeinuak erabilita aldatutako e-posta helbideak konprobatzea gaitu. Gaitu gabe badago, erabiltzaile berriak sortzean bakarrik derrigortuko dira domeinuak.';
$string['configvisiblecourses'] = 'Oro har, ezkutuko kategorietako ikastaroak erakutsi';
$string['configwarning'] = 'Emaitza hauek aldatzerakoan kontuz ibili (balio bitxiek arazoak sor ditzakete).';
$string['confirmation'] = 'Baieztatzea';
$string['confirmdeletecomments'] = 'Iruzkinak ezabatzeko zorian zaude, ziur al zaude?';
$string['confirmed'] = 'Baieztatutakoak';
$string['convertformat'] = '<i>bihurtu</i> irteera-formatua';
$string['cookiehttponly'] = 'http kukiak baino ez';
$string['cookiesecure'] = 'Kuki seguruak baino ez';
$string['country'] = 'Lehenetsitako herrialdea';
$string['coursecontact'] = 'Ikastaro-kudeatzaileak';
$string['coursecontact_desc'] = 'Honek aukera ematen dizu ikastaroaren deskribapenean nor agertuko den kontrolatzeko. erabiltzaileek gutxienez hauetako rolen bat izan behar dute ikastaroan beronen deskribapenean agertzeko.';
$string['courselistshortnames'] = 'Erakutsi izen laburrak';
$string['coursemgmt'] = 'Kudeatu Ikastaroak eta kategoriak';
$string['courseoverview'] = 'Ikastaroaren ikuspegi orokorra';
$string['courserequestnotify'] = 'Ikastaro-eskariaren jakinarazpena';
$string['courserequestnotifyemail'] = '{$a->user} erabiltzaileak ikastaro-eskaria ehin du hemen {$a->link}';
$string['courserequests'] = 'Ikastaro-eskariak';
$string['courserequestspending'] = 'Onarpenaren zain dauden ikastaro-eskariak';
$string['courses'] = 'Ikastaroak';
$string['coursesperpage'] = 'Ikastaroak orriko';
$string['creatornewroleid'] = 'Sortzaileen rola ikastaro berrietan';
$string['cron'] = 'Cron-a';
$string['cronclionly'] = 'Komando bidezko bakarrik exekutatuko da krona';
$string['cronerrorclionly'] = 'Barkatu, baina orri honetarako sarbidea kudeatzaileak desgaitu du';
$string['cronerrorpassword'] = 'Barkatu, ez duzu baliozko pasahitza idatzi orri honetara sartzeko';
$string['cronremotepassword'] = 'Urrutiko sarbiderako cron-pasahitza';
$string['cronwarning'] = '<a href="cron.php">cron.php</a>ren mantenu scripta ez da azken 24 orduetan egikaritu. <br /><a href="../doc/?frame=install.html⊂=cron">Instalazioaren dokumentazioak</a> automatizatzeko modua adierazten du.';
$string['ctyperecommended'] = 'Gomendagarria da oso PHP ctype aukerako luzapena instalatzea gunearen errendimendua hobetzeko, batez ere guneak hizkuntza ez latindarrak baditu.';
$string['ctyperequired'] = 'Moodle-k orain PHP ctype luzapena behar du, gunearen errendimendua hobetzeko eta hizkuntz anitzeko bateragarritasuna eskaini ahal izateko.';
$string['curlcache'] = 'cURl cachea TTL';
$string['curlrecommended'] = 'Gomendagarria da oso cURl liburutegia instalatzea Moodle Sareak funtzionatzeko.';
$string['curlrequired'] = 'Moodle-k orain cURL PHP luzapena behar du, Moodle biltegiekin harremanetan jartzeko.';
$string['currenttheme'] = 'Oraingo itxura';
$string['customcheck'] = 'Beste konprobazio batzuk';
$string['custommenu'] = 'Pertsonalizatutako menua';
$string['custommenuitems'] = 'Pertsonalizatutako menuaren elementuak';
$string['datarootsecurityerror'] = '<p><strong>SEGURTASUN-ALERTA!</strong></p><p>Zure dataroot direktorioa ez dago ondo kokatuta eta agerian dago web-ean. Horrek esan nahi du zure fitxategi pribatuak edozeinek eskura ditzakeela eta horietako batzuk edozein cracker-ek erabil ditzake zure gunean baimenik gabe sartzeko!</p>
<p>Mugitu egin <em>behar</em> duzu dataroot direktorioa ({$a}) kokapen berri batera, zure web direktorio publikotik kanpo, eta ondorioz eguneratu <code>$CFG->dataroot</code> ezarpena zure config.php-en.</p>';
$string['datarootsecuritywarning'] = 'Zure gunearen konfigurazioa agian ez da segurua izango. Mesedez, ziurta ezazu zure sustrai-direktoriora ({$a}) ezin dela zuzenean web-etik heldu.';
$string['dbmigrate'] = 'Moodle-ko datu-baserako migrazioa';
$string['dbmigrateconnecerror'] = 'Ezin izan da zehaztutako datu-basera konektatu';
$string['dbmigrateencodingerror'] = 'Zehaztutako datu baseak {$a} kodifikazioa du UNICODE/UTF8-ren ordez.<br />Mesedez, zehaztu beste bat.';
$string['dbmigratepostgres'] = 'Badirudi datu-baseen zerbitzari gisa PostgreSQL erabiltzen ari zarela. Migrazio-prozesuan jarraitzeko "UNICODE"(PostgreSQL 7) edo "UTF8" (PostgreSQL 8) kodifikazioa duen datu-base berria sortu beharko duzu eskuz, migratutako datuak gordetzeko. Mesedez, jarraitzeko sartu datu-base berrirako konexiorako zehaztasunak:';
$string['dbmigratewarning'] = 'Mesedez, ziurtatu Moodle-ren datu-basearen kopia egin duzula prozedura honi hasiera eman baino lehen. Ez badakizu ziur nola egin, jarri harremanetan sistemaren kudeatzailearekin. Zure Moodle-gunea mantenu moduan jarriko da migrazio-prozesua hasten denean.';
$string['dbmigratewarning2'] = '<b>Kontuz: datu-basearen migrazio prozesua hastear zaude. Mesedez, ziurtatu Moodle-ren datu-base osoaren kopia egin dela.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000"> Datu-base hau UTF8 datu-base berrira migratu da. Mesedez, editatu config.php fitxategia eta erabili datu-base berria Moodle honekin.</font>';
$string['dbmigrationdupfailed'] = 'Datu-basearen duplikazioak kale egin du seguruenik akats honengatik: <font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Datu-basea erabili saioaren informaziorako';
$string['debug'] = 'Mezuak garbitu';
$string['debugall'] = 'DENAK: PHP garbiketa-mezu guztiak erakutsi';
$string['debugdeveloper'] = 'GARATZAILEA: garatzaileentzako Moodle garbiketa-mezu estrak';
$string['debugdisplay'] = 'Garbiketa-mezuak erakutsi';
$string['debugging'] = 'Arazketa';
$string['debugminimal'] = 'GUTXIENEKOA: erabateko akatsak bakarrik erakutsi';
$string['debugnone'] = 'BAT ERE EZ: ez erakutsi ez akatsik ez jakinarazpenik';
$string['debugnormal'] = 'NORMALA: akatsak, jakinarazpenak eta berriak erakutsi';
$string['debugpageinfo'] = 'Orriaren informazioa erakutsi';
$string['debugsmtp'] = 'e-posten bidalketa garbitu';
$string['debugstringids'] = 'Erakutsi hizkuntza-kateen jatorria';
$string['debugvalidators'] = 'Esteka balidatzaileak erakutsi';
$string['defaultcity'] = 'Berezko hiria';
$string['defaultcity_help'] = 'Hemen idatzitako hiria erabiltzaile-kontu berriak sortzean lehenetsitako hiria izango da.';
$string['defaulthomepage'] = 'Erabiltzaileen berezko hasiera-orria';
$string['defaultrequestcategory'] = 'Ikastaro-eskariek berez duten kategoria';
$string['defaultsettinginfo'] = 'Berezko balorea: {$a}';
$string['defaultuserroleid'] = 'Erabiltzaile guztiek berez duten rola';
$string['deleteincompleteusers'] = 'Osatu gabeko erabiltzaileak ezabatu tarte honen ondoren';
$string['deleteunconfirmed'] = 'Konfirmatu gabeko erabiltzaileak ezabatu honen ondoren:';
$string['deleteuser'] = 'Erabiltzailea ezabatu';
$string['density'] = 'Dentsitatea';
$string['denyemailaddresses'] = 'Debekatutako e-posta domeinuak';
$string['development'] = 'Garapena';
$string['devicedetectregexexpression'] = 'Adierazpen erregularra';
$string['devicedetectregexvalue'] = 'Itzulera-balioa';
$string['devicetype'] = 'Gailu-mota';
$string['disableuserimages'] = 'Erabiltzailearen profilaren irudiak desgaitu';
$string['displayerrorswarning'] = 'Ez da gomendatzen <em>erakutsi_erroreak</em> PHP ezarpena martxan ari diren guneetan gaitzea hainbat errore-mezuk zure zerbitzariaren inguruko oso informazio garrantzitsua erakutsi ahal dutelako.';
$string['displayloginfailures'] = 'Kale egindako sarrera-saiakera erakutsi';
$string['docroot'] = 'Moodle Doc-en iturburua';
$string['doctonewwindow'] = 'Ireki leiho berrian';
$string['download'] = 'Jaitsi';
$string['edithelpdocs'] = 'Editatu laguntza-dokumentuak';
$string['editingnoncorelangfile'] = 'Gaineratutako modulu/plugin baten itzulpena aldatzen ari zara saiatzen. Hirugarren zatiko moduluen itzulpena zure karpeta lokalean gorde dezakezu. Agian fitxategia eta itzulpena moduluaren lang karpetara mugitu nahiko duzu edota gaineratutako moduluaren mantentzaileari bidali.';
$string['editlang'] = '<b>Editatu</b>';
$string['editorbackgroundcolor'] = 'Azpiko kolorea';
$string['editordictionary'] = 'Editorearen hiztegia';
$string['editorfontfamily'] = 'Iturri-familia';
$string['editorfontlist'] = 'Iturri-zerrenda';
$string['editorfontsize'] = 'Iturri-tamaina';
$string['editorhidebuttons'] = 'Ezkutuko botoiak';
$string['editorkillword'] = 'Word formatuko iragazkia';
$string['editorspelling'] = 'Editorearen zuzentzailea';
$string['editorspellinghelp'] = 'Gaitu edo desgaitu ortografia-zuzentzailea. Gaituz gero <strong>aspell</strong>-k zerbitzarian instalatuta egon behar du.';
$string['editstrings'] = 'Hitzak edo esaldiak editatu';
$string['emailchangeconfirmation'] = 'E-posta aldaketa baieztatu';
$string['emoticonalt'] = 'Ordezko testua';
$string['emoticoncomponent'] = 'Irudiaren osagaia';
$string['emoticonimagename'] = 'Irudiaren izena';
$string['emoticons'] = 'Aurpegierak';
$string['emoticonsreset'] = 'Aurpegieren ezarpenak berezko baloreetara ekarri berriz';
$string['emoticontext'] = 'Testua';
$string['emptysettingvalue'] = 'Hutsik';
$string['enableajax'] = 'Gaitu AJAX';
$string['enableblogs'] = 'Gaitu blogak';
$string['enablecalendarexport'] = 'Egutegiaren esportazioa gaitu';
$string['enablecomments'] = 'Iruzkinak gaitu';
$string['enablecourserequests'] = 'Ikastaro-eskariak gaitu';
$string['enabled'] = 'Gaituta';
$string['enabledevicedetection'] = 'Gaitu gailua atzematea';
$string['enablegravatar'] = 'Gaitu Gravatar';
$string['enablegroupmembersonly'] = 'Gaitu taldeko partaideentzat bakarrik';
$string['enablemobilewebservice'] = 'Gaitu web-zerbitzuak gailu mugikorretarako';
$string['enablerecordcache'] = 'Erregistro-cachea gaitu';
$string['enablerssfeeds'] = 'RSS jarioak gaitu';
$string['enablesafebrowserintegration'] = 'Gaitu integrazioa Safe Exam Browser-ekin';
$string['enablestats'] = 'Estatistikak gaitu';
$string['enabletgzbackups'] = 'Gaitu segurtasun-kopietarako formatu berria';
$string['enabletrusttext'] = 'Eduki fidagarria gaitu';
$string['enablewebservices'] = 'Web-zerbitzuak gaitu';
$string['enablewsdocumentation'] = 'Web-zerbiztuen dokumentazioa';
$string['enrolinstancedefaults'] = 'Berezko matrikulaziorako instantzia';
$string['enrolinstancedefaults_desc'] = 'Berezko matrikulazio-ezarpenak ikastaro berrietan.';
$string['enrolmultipleusers'] = 'Matrikulatu erabiltzaileak ';
$string['environment'] = 'Ingurunea';
$string['environmenterrortodo'] = 'Moodle-ren bertsio hau instalatu aurretik goian aurkitutako inguru-arazo (errore) guztiak zuzendu behar dituzu.';
$string['environmenterrorupgrade'] = 'Kontuz: ingurune-arazo guztiak konpondu beharko zenituzke Moodle-ren bertsio hau eguneratzen hasi aurretik! Baldintza hau bete gabe egindako eguneraketak hainbat arazo sor dezakete, besteak beste datuak galtzea. Ziur al zaude eguneraketarekin aurrera egin nahi duzula?';
$string['environmentmustfixsetting'] = 'PHP ezarpenak aldatu egin behar dira.';
$string['environmentok'] = 'Zure zerbitzariaren inguruneak beharrezko eskakizunak betetzen ditu.';
$string['environmentrecommendcustomcheck'] = 'honek kale egiten badu, ustezko arazo bat dagoela adierazten du.';
$string['environmentrecommendinstall'] = 'gomendagarria da instalatuta eta gaituta egotea emaitza hobeak izateko.';
$string['environmentrecommendversion'] = '{$a->needed} bertsioa gomendatzen da eta zu {$a->current} ari zara egikaritzen';
$string['environmentrequirecustomcheck'] = 'test hau pasatu beharra dago';
$string['environmentrequireinstall'] = 'derrigorrezkoa da instalatuta eta gaituta izatea';
$string['environmentrequireversion'] = '{$a->needed} bertsioa beharrezkoa da eta zu {$a->current} ari zara egikaritzen';
$string['environmentsettingok'] = 'gomendatutako ezarpena aurkitu da';
$string['environmentshouldfixsetting'] = 'PHP ezarpenak aldatu egin beharko lirateke.';
$string['environmentxmlerror'] = 'Errorea inguruari buruzko informazioa irakurtzean ({$a->error_code})';
$string['errordeletingconfig'] = 'Errorea gertatu da  \'{$a}\' pluginerako konfigurazio-erregistroak ezabatzean.';
$string['errorsetting'] = 'Ezin izan da aukeratutakoa gorde:';
$string['errorwithsettings'] = 'Hainbat ezarpen ez dira gorde akats bat dela-eta.';
$string['everyonewhocan'] = '\'{$a}\' egin dezakeen edozein';
$string['exceptions'] = 'salbuespenak';
$string['experimental'] = 'Esperimentala';
$string['experimentalsettings'] = 'Ezarpen esperimentalak';
$string['extendedusernamechars'] = 'Karaktere zabalduak baimendu erabiltzaile-izenetan';
$string['extramemorylimit'] = 'Aparteko PHP memoriaren muga';
$string['fatalmagicquotesruntime'] = '<p>Konfigurazio-errore handia aurkitu da; mesedez, jakinarazi zerbitzariaren kudeatzaileari.</p><p> Moodle egoki aritzeko, kudeatzaileak PHP ezarpenak aldatu behar ditu.</p><p><code>magic_quotes_runtime</code> <code>off</code> ezarri behar da.</p><p>Ezarpena hau kontrolatzeko <code>php.ini</code> editatu behar da, Apache/IIS <br />konfigurazioa edo <code>.htaccess</code> fitxategia zerbitzarian.</p>';
$string['fatalsessionautostart'] = '<p>Konfirgurazio-errore larria aurkitu da; mesedez, jakinarazi zerbitzari-kudeatzaileari.</p><p> Ondo aritzeko, kudeatzaileak PHP ezarpenak aldatu behar ditu.</p><p><code>session.auto_start</code>-ek <code>off</code> ezarrita izan behar du.</p><p>This setting is controlled by editing <code>php.ini</code>, Apache/IIS <br />configuration or <code>.htaccess</code> file on the server.</p>';
$string['filecreated'] = 'Fitxategia sortu da';
$string['filestoredin'] = 'Gorde fitxategia ondoko karpetan:';
$string['filestoredinhelp'] = 'Fitxategia gordetzeko lekua';
$string['filterall'] = 'Kate guztiak iragazi';
$string['filtermatchoneperpage'] = 'Kointzidentziak orriko iragazi';
$string['filtermatchonepertext'] = 'Kointzidentziak testuko iragazi';
$string['filters'] = 'Iragazkiak';
$string['filtersettings'] = 'Kudeatu iragazkiak';
$string['filtersettingsgeneral'] = 'Iragazkien ezarpen orokorrak';
$string['filteruploadedfiles'] = 'Iragazi igotako fitxategiak';
$string['forcelogin'] = 'Behartu erabiltzaileak identifikatzera';
$string['forceloginforprofileimage'] = 'Behartu erabiltzaileak identifikatzera erabiltzaileen irudiak ikusteko';
$string['forceloginforprofiles'] = 'Behartu erabiltzaileak identifikatzera profilak ikusi ahal izateko';
$string['forcetimezone'] = 'Behartu ordutegi-eremua';
$string['frontpage'] = 'Hasiera-orria';
$string['frontpagebackup'] = 'Hasiera-orriaren segurtasun-kopia';
$string['frontpagedefaultrole'] = 'Hasiera-orriaren berezko rola';
$string['frontpagefilters'] = 'Hasiera-orriaren iragazkiak';
$string['frontpageloggedin'] = 'Hasiera-orriaren elementuak gunean sartzean';
$string['frontpageoverrides'] = 'Hasiera-orriaren baimenak baliogabetu';
$string['frontpagequestions'] = 'Hasiera-orriaren galderak';
$string['frontpagerestore'] = 'Hasiera-orria berreskuratu';
$string['frontpageroles'] = 'Hasiera-orriaren rolak';
$string['frontpagesettings'] = 'Hasiera-orriaren ezarpenak';
$string['fullnamedisplay'] = 'Izen osoaren formatua';
$string['fullnamedisplayprivate'] = 'Izen osoaren formatua - pribatua';
$string['gdrecommended'] = 'GD luzapena irudiak bihurtzeko erabiltzen da; hainbat funtzio, erabiltzailearen profileko irudiak, adibidez, ezin dira eskuratu hau falta bada.';
$string['generalsettings'] = 'Ezarpen orokorrak';
$string['geoipfile'] = 'GeoIP City datu-fitxategia';
$string['getremoteaddrconf'] = 'Erregistratutako IP helbideen iturburua';
$string['globalswarning'] = '<p><strong>SEGURTASUN-ALERTA!</strong></p><p> Egoki aritzeko, Moodle-k hainbat aldaketa <br />behar ditu zure PHP ezarpenetan.</p><p><code>register_globals=off</code> ezarri <em>behar</em> duzu.</p><p>Ezarpen hau zure <code>php.ini</code> editatuta kontrolatzen da, Apache/IIS <br />konfigurazioa edo <code>.htaccess</code> fitxategia.</p>';
$string['googlemapkey3'] = 'Google Maps API V3 rako giltza';
$string['gotofirst'] = 'Joan falta den lehenengo katera';
$string['gradebook'] = 'Kalifikazio-liburua';
$string['gradebookroles'] = 'Kalifikatutako rolak';
$string['gradeexport'] = 'Lehen mailako kalifikazioak esportatzeko metodoak';
$string['gravatardefaulturl'] = 'Gravatar-en berezko irudiaren URLa';
$string['groupenrolmentkeypolicy'] = 'Taldeen matrikulaziorako giltza-politika';
$string['guestroleid'] = 'Bisitarientzako rola';
$string['guestroleid_help'] = 'Rol hau automatikoki esleitzen zaio bisitariari. Aldi baterako esleitzen zaio matrikulatu gabeko erabiltzaileari ere, bisitaria matrikulatu plugina erabilita sartzen bada.';
$string['helpadminseesall'] = 'Kudeatzaileek egutegiaren ekitaldi guztiak ikus ditzakete edo dagozkienak soilik?';
$string['helpforcetimezone'] = 'Erabiltzaileek beren ordutegi-eremua aukeratzea baimendu edo guztientzat bera izatea erabaki dezakezu.';
$string['helpsitemaintenance'] = 'Eguneratze eta beste zereginetarako';
$string['helpstartofweek'] = 'Astea zein egunetan hasten da?';
$string['helpupcominglookahead'] = 'Zenbat egun hartu behar ditu kontuan egutegiak hurrengo ekitaldietako lehenetsitako balore gisa?';
$string['helpupcomingmaxevents'] = 'Gehienez hurrengo zenbat ekitaldi erakutsiko zaizkie erabiltzaileei?';
$string['helpweekenddays'] = 'Asteko zenbat egun \'asteburutzat\' hartu eta beste kolore batez erakutsiko dira?';
$string['hiddenuserfields'] = 'Erabiltzailearen eremuak ezkutatu';
$string['hidefromall'] = 'Erabiltzaile guztiei ezkutatu';
$string['hidefromnone'] = 'Ez ezkutatu inori';
$string['hidefromstudents'] = 'Ikasleei ezkutatu';
$string['htmleditor'] = 'HTML editorea';
$string['htmleditorsettings'] = 'HTML editorearen ezarpenak';
$string['htmlsettings'] = 'HTML ezarpenak';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP segurtasuna';
$string['hubs'] = 'Bilguneak';
$string['iconvrecommended'] = 'ICONV aukerako liburutegia instalatzea gomendagarria da  oso gunearen errendimendua hobetzeko, batez ere zure guneak latindarrak ez diren hizkuntzak erabiltzen baditu.';
$string['iconvrequired'] = 'ICONV luzapena instalatzea beharrezkoa da.';
$string['ignore'] = 'Baztertu';
$string['includemoduleuserdata'] = 'Moduluaren erabiltzailearen datuak sartu';
$string['incompatibleblocks'] = 'Bloke bateraezinak';
$string['installhijacked'] = 'Instalazioa jatorrizko IP helbidearekin bukatu behar da, barkatu.';
$string['installsessionerror'] = 'Ezin da PHP saiorik hasi; mesedez, ziurtatu zure nabigatzeileak cookiak onartzen dituela.';
$string['invalidsection'] = 'Atal ezegokia.';
$string['invaliduserchangeme'] = '"changeme" erabiltzaile-izena erreserbatuta dago: ezin da izen horrekin konturik sortu.';
$string['ipblocked'] = 'Gunea ez dago eskura une honetan.';
$string['ipblocker'] = 'IP blokeatzailea';
$string['iplookup'] = 'IP helbidea bilatu';
$string['iplookupinfo'] = 'Berez, Moodle-k NetGeo (The Internet Geographic Database) doako on-line zerbitzari erabiltzen du Ip helbideen kokapena bilatzeko. Tamalez, datu-base horren mantenua eten egin da eta emaitza <em>erabat okerrak</em> eman ditzake.
Gomendagarria da doako GeoLite City datu-basearen kopia lokala instalatzea MaxMind-etik.<br />
IP helbideen kokapena mapa erraz batean edo Google Maps erabilita erakusten da. Mesedez, ohartu mapa interaktiboak gaitzeko Google kontua behar duzula eta Google Maps API giltza doan aplikatu.';
$string['iplookupmaxmindnote'] = 'Produktu honek MaxMind-ek sortutako GeoLite datuak barne ditu eta hemendik eskura daitezke: <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Etiken izenek jatorrizko \'casing\'-a mantendu';
$string['lang'] = 'Berezko hizkuntza';
$string['langcache'] = 'Aldatu hizkuntza-menua';
$string['langlist'] = 'Hizkuntzak hizkuntza-menuan';
$string['langmenu'] = 'Erakutsi hizkuntza-menua';
$string['langpackwillbeupdated'] = 'OHARRA: Moodle une honetan aukeratutako hizkuntza-paketea eguneratzen saiatuko da.';
$string['langstringcache'] = 'Gorde cache-an hizkuntza-kate guztiak';
$string['languagesettings'] = 'Hizkuntza-ezarpenak';
$string['latexpreamble'] = 'LaTeX aitzinsolasa';
$string['latexsettings'] = 'LaTeX ezarpenak';
$string['latinexcelexport'] = 'Excel kodifikazioa';
$string['legacyfilesinnewcourses'] = 'Ikastaroko fitxategiak ikastaro berrietan';
$string['licensesettings'] = 'Lizentziaren ezarpenak';
$string['loading'] = 'Igotzen';
$string['localetext'] = 'Gunearen locale-a';
$string['localstringcustomization'] = 'Pertsonalizatu hizkuntza lokala';
$string['location'] = 'Kokapena';
$string['locationsettings'] = 'Kokapenaren ezarpenak';
$string['locked'] = 'Blokeatuta';
$string['log'] = 'Agerraldiak';
$string['logguests'] = 'Gonbidatuen sarbidearen erregistroa';
$string['loginhttps'] = 'Erabili HTTPS saioa hasteko';
$string['loglifetime'] = 'Mantendu erregistroak tarte honetan:';
$string['longtimewarning'] = '<b>Mesedez, kontuan hartu prozesu hau oso luzea izan daitekeela.</b>';
$string['maintenancemode'] = 'Mantenu-moduan';
$string['maintfileopenerror'] = 'Errorea mantenu-fitxategiak irekitzean';
$string['maintinprogress'] = 'Mantenua martxan...';
$string['manageformats'] = 'Kudeatu ikastaro-formatuak';
$string['manageformatsgotosettings'] = 'Berezko formatua izan da aldatu hemen: {$a}';
$string['managelang'] = 'Kudeatu';
$string['managelicenses'] = 'Lizentziak kudeatu';
$string['manageqbehaviours'] = 'Kudeatu galderen jokaerak';
$string['manageqtypes'] = 'Galdera-motak kudeatu';
$string['maturity100'] = 'Beta';
$string['maturity200'] = 'Bertsio egonkorra';
$string['maturity50'] = 'Alpha';
$string['maxbytes'] = 'Igotako fitxategiaren gehienezko tamaina';
$string['maxconsecutiveidentchars'] = 'Jarraian dauden karaktere berdinak';
$string['maxeditingtime'] = 'Mezuak editatzeko gehienezo denbora-tartea';
$string['maxusersperpage'] = 'Gehieneko erabiltzaileak orriko';
$string['mbstringrecommended'] = 'MBSTRING aukerako liburutegia instalatzea gomendagarria da  oso gunearen errendimendua hobetzeko, batez ere zure guneak latindarrak ez diren hizkuntzak erabiltzen baditu.';
$string['mediapluginavi'] = '.avi iragazkia gaitu';
$string['mediapluginflv'] = '.flv iragazkia gaitu';
$string['mediapluginimg'] = 'Gaitu estekatutako irudien auto-enbotatzea';
$string['mediapluginmov'] = '.mov iragazkia gaitu';
$string['mediapluginmp3'] = '.mp3 iragazkia gaitu';
$string['mediapluginmpg'] = '.mpg iragazkia gaitu';
$string['mediapluginogg'] = '.ogg iragazkia gaitu';
$string['mediapluginogv'] = '.ogv iragazkia gaitu';
$string['mediapluginram'] = '.ram iragazkia gaitu';
$string['mediapluginrm'] = '.rm iragazkia gaitu';
$string['mediapluginrpm'] = '.rpm iragazkia gaitu';
$string['mediapluginswf'] = '.swf iragazkia gaitu';
$string['mediapluginswfnote'] = 'Berezko segurtasun-neurri gisa, ez zaie uzten erabiltzaileei flash swf. fitxategirik sartzen';
$string['mediapluginwmv'] = '.wmv iragazkia gaitu';
$string['mediapluginyoutube'] = 'YouTube esteken iragazkia gaitu';
$string['messaging'] = 'Mezularitza-sistema gaitu';
$string['messagingdeletereadnotificationsdelay'] = 'Irakurritako jakinarazpenak ezabatu';
$string['messaginghidereadnotifications'] = 'Irakurritako jakinarazpenak ezkutatu';
$string['minpassworddigits'] = 'Digituak';
$string['minpasswordlength'] = 'Pasahitzaren luzera';
$string['minpasswordlower'] = 'Letra xeheak';
$string['minpasswordnonalphanum'] = 'Karaktere alfanumerikorik ez';
$string['minpasswordupper'] = 'Letra larriak';
$string['misc'] = 'Bestelakoak';
$string['mnetrestore_extusers'] = '<strong>Oharra:</strong> Segurtasun-kopia honek Moodle Sareko urrutiko erabiltzaile-kontuak ditu eta prozesuaren zati bezala berreskuratuko dira.';
$string['mnetrestore_extusers_admin'] = '<strong>Oharra:</strong> Segurtasun-kopia honek Moodle-ren instalazio ezberdin batean du iturburua antza eta Moodle Sareko urrutiko erabiltzaile-kontuak ditu. Berreskuratzeko prozesuan sortutako erabiltzaile guztien Moodle Sareko hostalariekin bat egiten saiatuko gara. Bat ez datozenak automatikoki bihurtuko dira barne-autentifikaziora (mnet-en ordez). Berreskuratzeko logek emango dizute horren berri.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Oharra:</strong> Segurtasun-kopia honek Moodle-ren instalazio ezberdin batean du iturburua antza eta berreskura ezin daitezkeen Moodle Sareko urrutiko erabiltzaile-kontuak ditu. Ezin da eragiketa hau burutu. Ziur bazaude Moodle instalazio honetan sortu dela, edo beharrezko diren Moodle Sareko hostalari guztiak konfiguratuta daudela ziur bazaude, berreskuratzen saia zaitezke.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Oharra:</strong> Segurtasun-kopia honek Moodle-ren instalazio ezberdin batean du iturburua eta Moodle Sareko urrutiko erabiltzaile-kontuak ditu. Zuk ez duzu berreskuratze-mota hau burutzeko baimenik. Jarri harremanetan guneko kudeatzailearekin edo, bestela, berreskuratu ikastaro hau erabiltzaileen informaziorik (moduluak, fitxategiak...) gabe.';
$string['mnetrestore_extusers_switchuserauth'] = '{$a->username} urrutiko Moodle Sareko erabiltzailea ({$a->mnethosturl}-tik datorrena) {$a->auth} lokalean autentifikatutako erabiltzaile bihurtu da.';
$string['mobile'] = 'Mugikorra';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Berez jarduera-hautatzailea';
$string['modeditdefaults'] = 'Berezko baloreak jardueren ezarpenetarako';
$string['modeditingmenu'] = 'Jarduera editatzeko menuak';
$string['modsettings'] = 'Jarduerak kudeatu';
$string['modulesecurity'] = 'Moduluaren segurtasuna';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Multi-hizkuntza sintaxi zaharra behartu: &lt;span&gt; ondokorik gabe class="multilang" and &lt;lang&gt;';
$string['mustenablestats'] = 'Estatistikak ez daude gaituta gune honetan.';
$string['mycoursesperpage'] = 'Ikastaro-kopurua';
$string['mydashboard'] = 'Sistemaren berezko aginte-mahaia';
$string['mymoodle'] = 'Nire hasiera';
$string['mymoodleredirect'] = 'Behartu erabiltzaileak Nire Moodle erabiltzera';
$string['mypage'] = 'Berezko Nire hasiera-orria';
$string['mypagelocked'] = 'Blokeatu lehenetsitako orria';
$string['myprofile'] = 'Berezko profil-orria';
$string['mysql416bypassed'] = 'Dena dela, zure guneak iso-8859-1 (latina) hizkuntzak BAKARRIK erabiltzen baditu zure oraingo MySQL 4.1.12 (edo hurrengoak) bertsioa erabiltzen jarrai dezakezu.';
$string['mysql416required'] = 'MySQL 4.1.12 da gutxienez eskatzen den bertsioa Moodle 1.6 erabiltzeko eta etorkizunean informazio guztia UTF-8 bihurtu ahal izango dela bermatzeko.';
$string['navadduserpostslinks'] = 'Gehitu estekak erabiltzailearen mezuak ikusteko';
$string['navcourselimit'] = 'Ikastaro-muga';
$string['navshowallcourses'] = 'Erakutsi ikastaro guztiak';
$string['navshowcategories'] = 'Erakutsi ikastaro-kategoriak';
$string['navshowfrontpagemods'] = 'Erakutsi hasiera-orriarem jarduerak nabigazioan';
$string['navshowfullcoursenames'] = 'Erakutsi ikastaroen izen osoak';
$string['navshowmycoursecategories'] = 'Erakutsi nire ikastaro-kategoriak';
$string['navsortmycoursessort'] = 'Ordenatu nire ikastaroak';
$string['nobookmarksforuser'] = 'Ez duzu inongo markarik.';
$string['nodatabase'] = 'Ez dago datu-baserik';
$string['nomissingstrings'] = 'Ez da katerik falta';
$string['nonewsettings'] = 'Eguneraketa honetan ez da ezarpen berririk egin.';
$string['nonexistentbookmark'] = 'Eskatutako laster-marka ez dago';
$string['noresults'] = 'Ez da emaitzarik aurkitu.';
$string['noroles'] = 'Ez dago rolik';
$string['notifications'] = 'Jakinarazpenak';
$string['notifyloginfailures'] = 'Kale egindako sarrerak e-postaz hona bidali:';
$string['notifyloginthreshold'] = 'E-posta bidezko jakinarazpenetarako sarbidea';
$string['notloggedinroleid'] = 'Gonbidatuen rola';
$string['numberofmissingstrings'] = 'Itzuli gabeko kateen kopurua: {$a}';
$string['numberofstrings'] = 'Kateak denera: {$a->strings}<br />Falta dira: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = 'Aukerako OpenSSL liburutegia oso da gomendagarria - Moode Sarearen funtzionamendua gaitzen du.';
$string['opentogoogle'] = 'Google-ri zabaldu';
$string['optionalmaintenancemessage'] = 'Mantenuari buruzko aukerazko mezua';
$string['order1'] = 'Lehena';
$string['order2'] = 'Bigarrena';
$string['order3'] = 'Hirugarrena';
$string['order4'] = 'Laugarrena';
$string['passwordpolicy'] = 'Pasahitzen politika';
$string['pathconvert'] = '<i>convert</i> bide bikoitia';
$string['pathdvips'] = '<i>dvips</i> bide bikoitia';
$string['pathlatex'] = '<i>latex</i> bide bikoitia';
$string['pathtoclam'] = 'clam AV-rako bidea';
$string['pathtodot'] = 'dot-erako bidea';
$string['pathtodu'] = 'du-rako bidea';
$string['pathtopgdump'] = 'pg_dump-erako bidea';
$string['pathtopgdumpdesc'] = 'Zure sisteman pg_dump bat baino gehiago badituzu bakarrik sartu behar duzu (adibidez, postgresql-ren bertsio bat baino gehiago badituzu instalatuta).';
$string['pathtopgdumpinvalid'] = 'pg_dump-erako bide ez egokia: ez da zuzena edo ezin da exekutatu.';
$string['pathtopsql'] = 'psql-rako bidea';
$string['pathtopsqldesc'] = 'Zure sisteman psql bat baino gehiago baduzu bakarrik da beharrezkoa hau (adibidez, postgresql-ren bertsio bat baino gehiago baduzu instalatuta).';
$string['pathtopsqlinvalid'] = 'psql-rako bideak ez du balio: akatsa du edo ezin da exekutatu.';
$string['perfdebug'] = 'Errendimendu-informazioa';
$string['performance'] = 'Errendimendua';
$string['pgcluster'] = 'PostgreSQL Clusterra';
$string['pgclusterdescription'] = 'Komando-lerro eragiketetarako PostgreSQL bertsio/clusterraren parametroa. Zure sisteman postgresql bakarra baduzu edo ez badakizu zer den hau, utzi zuri.';
$string['php50restricted'] = 'PHP 5.0.x-k hainbat arazo ezagun ditu; mesedez, eguneratu 5.1.x bertsiora edo erabili 4.3.x edo 4.4.x bertsioak.';
$string['php533warning'] = 'PHP 5.3.3 edo goragokoa gomendatzen da';
$string['pleaserefreshregistration'] = 'Zure gunean moodle.org-n erregistratu da. Mesedez, egunera ezazu erregistroa, {$a}-n egindako azken eguneratzetik hona aldaketa nabarmena izan bada.';
$string['pleaseregister'] = 'Botoi hau kentzeko zure gunea erregistratu, mesedez';
$string['plugin'] = 'Plugina';
$string['plugins'] = 'Pluginak';
$string['pluginsoverview'] = 'Pluginen ikuspegi orokorra';
$string['pluginsoverviewsee'] = 'Ikusi <a href="{$a->url}">pluginen ikuspegi orokorra</a> orria xehetasun gehiagotarako.';
$string['profilecategory'] = 'Kategoria';
$string['profilecategoryname'] = 'Kategoriaren izena (bakarra izan behar du)';
$string['profilecategorynamenotunique'] = 'Kategoria-izen hau dagoeneko erabiltzen ari da';
$string['profilecommonsettings'] = 'Ezarpen komunak';
$string['profileconfirmcategorydeletion'] = '{$a}
 eremu daude kategoria honetan eta goragoko kategorira eramango dira (edo beheragokora goragokoan badaude). <br/> Oraindik ere kategoria hau ezabatu egin nahi al duzu?';
$string['profileconfirmfielddeletion'] = '{$a} erabiltzaile-erregistro daude eremu honetarako eta ezabatu egingo dira. <br/> Oraindik ere eremu hau ezabatu egin nahi al duzu?';
$string['profilecreatecategory'] = 'Profil-kategoria berria sortu';
$string['profilecreatefield'] = 'Profilaren eremu berria sortu';
$string['profilecreatenewcategory'] = 'Kategoria berria sortzen';
$string['profilecreatenewfield'] = '"{$a}" profil-eremu berria sortzen';
$string['profiledefaultcategory'] = 'Beste eremu batzuk';
$string['profiledefaultchecked'] = 'Kontrolatua berez';
$string['profiledefaultdata'] = 'Berezko balorea';
$string['profiledeletecategory'] = 'Kategoria ezabatzen';
$string['profiledeletefield'] = '\'{$a}\' eremua ezabatzen';
$string['profiledescription'] = 'Eremuaren deskribapena';
$string['profileeditcategory'] = '{$a} kategoria editatzen';
$string['profileeditfield'] = '{$a} profil-eremua editatzen';
$string['profilefield'] = 'Profil-eremua';
$string['profilefieldcolumns'] = 'Zutabeak';
$string['profilefieldispassword'] = 'Pasahitzerako eremua al da hau?';
$string['profilefieldlink'] = 'Esteka';
$string['profilefieldlink_help'] = 'Testua esteka bihurtzeko, idatzi $$ duen URL-a, zeinetan $$ testuak ordezkatuko duen. Adibidez, Twitter ID bat esteka bihurtzeko, idatzi http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Estekaren helmuga';
$string['profilefieldmaxlength'] = 'Gehienezko luzera';
$string['profilefieldrows'] = 'Lerroak';
$string['profilefields'] = 'Erabiltzaile-profilaren eremuak';
$string['profilefieldsize'] = 'Tamaina erakutsi';
$string['profileforceunique'] = 'Datuak bakarrak izan behar al dira?';
$string['profileinvaliddata'] = 'Baloreak ez du balio';
$string['profilelocked'] = 'Eremu hau blokeatuta al dago?';
$string['profilemenudefaultnotinoptions'] = 'Berezko balorea ez dago aukeren artean';
$string['profilemenunooptions'] = 'Ez dago menu-aukerarik';
$string['profilemenuoptions'] = 'Menu-aukerak (bat lerroko)';
$string['profilemenutoofewoptions'] = 'Gutxienez bi aukera eman behar dituzu';
$string['profilename'] = 'Izena';
$string['profilenofieldsdefined'] = 'Ez dago definitutako eremurik';
$string['profilerequired'] = 'Beharrezkoa al da eremu hau?';
$string['profileroles'] = 'Ikus daitezkeen profilen rolak';
$string['profilesforenrolledusersonly'] = 'Profil hauek matrikulatutako erabiltzaileentzako bakarrik dira';
$string['profileshortname'] = 'Izen laburra (bakarra izan behar du)';
$string['profileshortnamenotunique'] = 'Izen labur hau dagoeneko erabiltzen ari da';
$string['profilesignup'] = 'Orria erakutsi behar da saioa hastean?';
$string['profilespecificsettings'] = 'Ezarpen espezifikoak';
$string['profilevisible'] = 'Zeinek ikus dezake eremu hau?';
$string['profilevisibleall'] = 'Edozeinek ikusteko modukoa';
$string['profilevisible_help'] = '*Inork ez ikusi - kudatzaileak bakarrik ikusteko datu pribatuetarako.
*\'Erabiltzaileak ikusi - kudeatzaileak eta erabiltzaileak bakarrik ikusteko datu pribatuetarako.
*Edonork ikusi';
$string['profilevisiblenone'] = 'Ez ikusteko modukoa';
$string['profilevisibleprivate'] = 'Erabiltzaileak ikusteko modukoa';
$string['profilingenabled'] = 'Gaitu profilak';
$string['profilingexcluded'] = 'Baztertu profilak';
$string['profilingimportprefix'] = 'Profilak inportatzeko aurrizkia';
$string['profilingincluded'] = 'Profil hauek';
$string['protectusernames'] = 'Erabiltzaile-izenak babestu';
$string['proxyhost'] = 'Proxy ostalaria';
$string['proxypassword'] = 'Proxy pasahitza';
$string['proxyport'] = 'Proxy portua';
$string['proxytype'] = 'Proxy mota';
$string['proxyuser'] = 'Proxy erabiltzaile-izena';
$string['purgecaches'] = 'Ezabatu cache guztiak';
$string['purgecachesconfirm'] = 'Moodle-k katxean gorde ditzake itxura, javascript, hizkuntza-kate, iragazitako testu, RSS jario eta beste datu asko. Datu horiek zerbitzarian arazteak bezeroen nabigatzaileak informazioa eguneratzera behartuko ditu eta ziurtatu egingo duzu, horrela, erabiltzaileek azken aldaketak dituen informazioa ikusiko dutela. Hau egiteak ez dakar inongo arriskurik, baina hasieran gunea makalago dabilela eman dezake, zerbitzariak eta bezeroek informazioa berriz eguneratu eta datuak katxean gorde arte.';
$string['purgecachesfinished'] = 'Cache guztiak ezabatu dira.';
$string['qtyperqpwillberemoved'] = 'Eguneratzean RQP motako galderak ezabatu egingo dira. Ez baduzu erabiltzen galdera-mota hori, ez duzu inongo arazorik izango.';
$string['qtyperqpwillberemovedanyway'] = 'Eguneratzean RQP motako galderak ezabatu egingo dira. Zure datu-basean badira hainbat RQP galdera eta eguneraketarekin jarraitu aurretik kodea http://moodle.org/mod/data/view.php?d=13&amp;rid=797-tik berrinstalatzen ez baduzu ez dute aurrerantzean funtzionatuko.';
$string['quarantinedir'] = 'Kuarentena-direktorioa';
$string['question'] = 'Galdera';
$string['questionbehaviours'] = 'Galderen jokaerak';
$string['questioncwqpfscheck'] = 'Galdetegi bateko \'ausazko\' galdera bat edo beste elkarbanatutako eta elkarbanatugabeko galdera-kategoria multzo batetik aukeratzeko ezarrita daude. Txosten zehatzagoa ikus dezakezu <a href="{$a->reporturl}">hemen</a>  eta Moodle Doc-etako orria  <a href="{$a->docsurl}">hemen</a>.';
$string['questioncwqpfsok'] = 'Ondo. Ez dago zure galdetegietan \'ausazko\' galdera bat edo beste elkarbanatutako eta elkarbanatugabeko galdera-kategoria multzo batetik aukeratzeko ezarrita.';
$string['questiontype'] = 'Galdera-mota';
$string['questiontypes'] = 'Galdera-motak';
$string['recaptchaprivatekey'] = 'ReCAPTCHA-rako gako pribatua';
$string['recaptchapublickey'] = 'ReCAPTCHA-rako gako publikoa';
$string['register'] = 'Erregistratu zure gunea';
$string['registerwithmoodleorg'] = 'Erregistratu Moodle.org-ren bidez';
$string['registration'] = 'Erregistroa';
$string['registrationwarning'] = 'Zure gunea oraindik ez dago erregistratuta.';
$string['releasenoteslink'] = 'Moodle-ren bertsio honi buruzko informazioa nahi baduzu, mesedez begiratu <a target="_new" href="{$a}">Bertsio oharrak</a>';
$string['rememberusername'] = 'Gogoratu erabiltzaile-izena';
$string['reportsmanage'] = 'Kudeatu txostenak';
$string['requestcategoryselection'] = 'Gaitu kategoria-aukeraketa';
$string['requiredentrieschanged'] = '<strong>GARRANTZIZKOA- MESEDEZ, IRAKURRI<br/>(Arreta-mezu hau eguneraketa honek irauten duen bitartean bakarrik erakutsiko da)</strong><br/> Bug baten konponketa dela-eta, \'Beharrezko sarrerak\' eta \'Beharrezko sarrerak ezarpenak ikusi aurretik\' erabiltzen dituzten datu-baseen jokabidea aldatu egingo da. Azalpen zehatzagoa ikus dezakezu <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">datu-basea moduluaren foroan</a>. Ezarpen hauen inguruan espero daitekeen jardueraz <a href="http://docs.moodle.org/eu/Datu-basea_moduluaren_ezaugarriak">Moodle Doc-etan</a> ere irakur daiteke. <br/><br/> Aldaketa honek ondorengo datu-baseei eragiten die zure sisteman: (Mesedez, gorde zerrenda hau orain eta eguneraketa egin ondoren aztertu jarduera hauek irakasleak nahi duen bezala funtzionatzen segitzen dutela).<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Jardueraren deskribapena beharrezkoa da';
$string['requires'] = 'Beharrezkoa';
$string['reverseproxy'] = 'Alderantzizko proxy-a';
$string['riskconfig'] = 'Erabiltzaileek gunearen konfigurazioa eta ezarpenak alda litzakete';
$string['riskconfigshort'] = 'Ezarpen-arriskua';
$string['riskdataloss'] = 'Erabiltzaileek eduki edo informazio atal asko desegin dezakete';
$string['riskdatalossshort'] = 'Datuak galtzeko arriskua';
$string['riskmanagetrust'] = 'Erabiltzaileek beste batzuen konfiantzazko ezarpenak alda litzakete';
$string['riskmanagetrustshort'] = 'Ezarpen fidagarriak kudeatu';
$string['riskpersonal'] = 'Erabiltzaileek beste erabiltzaile batzuen informazio pribatua lor lezakete.';
$string['riskpersonalshort'] = 'Pribatutasun-arriskuak';
$string['riskspam'] = 'Erabiltzaileek \'spam\'a bidal liezaiekete guneko erabiltzaileei edo beste batzuei';
$string['riskspamshort'] = 'Spam arriskua';
$string['riskxss'] = 'Erabiltzaileek gunean zeharreko \'scripting\'erako (XSS)aukera ematen duen fitxategi eta testuak gainera litzakete';
$string['riskxssshort'] = 'XSS arriskua';
$string['roleswithexceptions'] = '{$a->roles}, {$a->exceptions} -(ar)ekin';
$string['rssglobaldisabled'] = 'Desgaituta zerbitzariaren mailan';
$string['runclamavonupload'] = 'Igotako fitxategietan clam AV erabili';
$string['save'] = 'Gorde';
$string['savechanges'] = 'Aldaketak gorde';
$string['search'] = 'Bilatu';
$string['searchinsettings'] = 'Bilatu ezarpenetan';
$string['searchresults'] = 'Bilaketaren emaitzak';
$string['sectionerror'] = 'Errorea atalean!';
$string['secureforms'] = 'Erabili segurtasun-formulario gehigarria';
$string['security'] = 'Segurtasuna';
$string['selectdevice'] = 'Aukeratu gailua';
$string['selecttheme'] = 'Aukeratu itxura {$a} gailurako';
$string['server'] = 'Zerbitzaria';
$string['serverchecks'] = 'Zerbitzariaren egiaztatzeak';
$string['serverlimit'] = 'Zerbitzariaren muga';
$string['sessionautostartwarning'] = '<p>Ezarpenetan garrantzizko errorea aurkitu da. Mesedez, jakinarazi zerbitzariaren kudatzaileari.</p><p> Ondo aritzeko, Moodle-k beharrezkoa du kudeatzaileak  PHP ezarpenak aldatzea.</p><p><code>session.auto_start</code> -k honela behar du egon ezarrita: <code>off</code>.</p><p>Ezarpen hau <code>php.ini</code>, Apache/IIS <br />ezarpena edo <code>.htaccess</code> fitxategia zerbitzarian editatuta kontrolatzen da.</p>';
$string['sessioncookie'] = 'Cookiearen aurrizkia';
$string['sessioncookiedomain'] = 'Cookien domeinua';
$string['sessioncookiepath'] = 'Cookie-bidea';
$string['sessionhandling'] = 'Saioaren kudeaketa';
$string['sessiontimeout'] = 'Gehienezko denbora';
$string['settingfileuploads'] = 'Fitxategi-eguneraketa beharrezkoa da eragiketa normalerako; mesedez, gaitu hori PHP ezarpenetan.';
$string['settingmemorylimit'] = 'Memoria gutxiegi aurkitu da; mesedez, handitu memoriaren muga PHP ezarpenetan.';
$string['settingsafemode'] = 'Moodle ez da bateragarria modu seguruarekin; mesedez, eskatu kudeatzaileari itzaltzeko. Moodle modu seguruan aritzea ez da onartzen; hainbat arazo espero izatekoak dira.';
$string['showcommentscount'] = 'Erakutsi iruzkin-kopurua';
$string['showdetails'] = 'Xehetasunak erakutsi';
$string['showuseridentity'] = 'Erakutsi erabiltzailearen identitatea';
$string['simplexmlrequired'] = 'Moodle-k orain beharrezkoa du SimpleXML PHP luzapena';
$string['sitemaintenance'] = 'Gune hau mantenuan dago eta oraingoz ez da eskuragarria';
$string['sitemaintenancemode'] = 'Mantenu-modua';
$string['sitemaintenanceoff'] = 'Mantenu-modua ez dago indarrean eta gunea berriro normaltasunez funtzionatzen ari da';
$string['sitemaintenanceon'] = 'Gunea mantenu-moduan dago (sarbidea kudeatzaileek dute soilik).';
$string['sitemaintenancewarning'] = 'Gunea mantenu-moduan dago (sarbidea kudeatzaileek dute soilik). Berriro martxan jartzeko, <a href="maintenance.php">mantenu-modua desaktibatu</a>.';
$string['sitemaintenancewarning2'] = 'Zure gunea une honetan mantenu-moduan dago (kudeatzaileek baino ezin dute saioa hasi). Gune hau egoera normalera itzultzeko, <a href="{$a}">mantenu-modua desgaitu</a>.';
$string['sitepolicies'] = 'Gunearen politikak';
$string['sitepolicy'] = 'Gunearen politikaren URLa';
$string['sitepolicyguest'] = 'Bisitarientzako Gunearen politikaren URL-a';
$string['sitepolicyguest_help'] = 'Gunea erabili aurretik bisitari guztiek irakurri eta onartu beharreko guneko politika baduzu, idatzi hemen horren URL-a, besteal zuri utzi. Ezarpen honek edozein URL publiko izan dezake. Oharra: identifikatu gabekoen sarrera galerazi egin dezake forcelogin ezarpenak.';
$string['sitepolicy_help'] = 'Zure politikak erabiltzaile guztiek gunean parte hartu baino lehen zure baldintzak irakur ditzaten eskatzen badu, URLa hemen zehaztu; bestela, zuriz utzi. Ezarpen honek edozein URL publiko izan dezake. ';
$string['sitesectionhelp'] = 'Aukeratuz gero, atal bat erakutsiko da gunearen azalean.';
$string['slasharguments'] = 'Erabili "slash" argumentuak';
$string['smartpix'] = 'Bilatu smart pix';
$string['sort_fullname'] = 'Ikastaroaren izen osoa';
$string['sort_idnumber'] = 'Ikastaroaren ID zenbakia';
$string['sort_shortname'] = 'Ikastaroaren izen laburra';
$string['spellengine'] = 'Motor ortografikoa';
$string['spelllanguagelist'] = 'Hizkuntza-zerrenda';
$string['splrequired'] = 'Moodle-k orain SPL PHP luzapena beharrezkoa du.';
$string['stats'] = 'Estatistikak';
$string['statsfirstrun'] = 'Prozesamenduaren gehienezko tartea';
$string['statsmaxruntime'] = 'Exekutatzeko gehienezko denbora';
$string['statsmoodleorg'] = 'estatistikak';
$string['statsruntimedays'] = 'Prozesatzeko egunak';
$string['statsruntimestart'] = 'Hemen exekutatu';
$string['statsuserthreshold'] = 'Atalasea erabili';
$string['stickyblocks'] = 'Bloke finkoak';
$string['stickyblockscourseview'] = 'Ikastaroaren orria';
$string['stickyblocksduplicatenotice'] = 'Hemen gehitzen duzun edozein bloke orri jakin batean jadanik indarrean badago, emaitza kopia bikoiztua izango da.<br />gehitutako blokea ezingo da editatu, bikoiztutakoa editagarria izango den bitartean.';
$string['stickyblocksmymoodle'] = 'Nire Moodle';
$string['stickyblockspagetype'] = 'Konfiguratu beharreko orri-mota';
$string['stripalltitletags'] = 'HTML etiketak jarduera-izen guztietatik kendu';
$string['supportcontact'] = 'Laguntzarako kontaktua';
$string['supportemail'] = 'Laguntzarako e-posta';
$string['supportname'] = 'Laguntzarako izena';
$string['supportpage'] = 'Laguntzarako orria';
$string['suspenduser'] = 'Eten erabiltzailearen kontua';
$string['switchlang'] = 'Aldatu hizkuntzaren direktorioa';
$string['systempaths'] = 'Sistemaren ibilbideak';
$string['tablenosave'] = 'Goiko taulako aldaketak automatikoki gordetzen dira.';
$string['tablesnosave'] = 'Goiko tauletako aldaketak automatikoki gorde dira.';
$string['tabselectedtofront'] = 'Tabuladoreak dituzten tauletan, orain aukeratutako \'tag\' duen lerroak aurrean egon beharko luke';
$string['tabselectedtofronttext'] = 'Aukeratutako leihatila-ilada ipini lehengoa';
$string['themedesignermode'] = 'Itxurak diseinatzeko modua';
$string['themelist'] = 'Itxuren zerrenda';
$string['themenoselected'] = 'Ez da itxura aukeratu';
$string['themeresetcaches'] = 'Itxuren cache-ak garbitu';
$string['themeselect'] = 'Aldatu itxura';
$string['themeselector'] = 'Itxura-hautatzailea';
$string['themesettings'] = 'Itxuraren ezarpenak';
$string['therewereerrors'] = 'Zure datuetan erroreak daude';
$string['thirdpartylibrary'] = 'Liburutegia';
$string['thirdpartylibrarylocation'] = 'Kokapena';
$string['timezone'] = 'Berezko ordutegi-eremua';
$string['timezoneforced'] = 'Aukera hau gunearen administratzaileak behartu egin du';
$string['timezoneisforcedto'] = 'Erabiltzaile guztiak erabiltzera behartu';
$string['timezonenotforced'] = 'Erabiltzaileek ordutegi-eremua aukera dezakete';
$string['tokenizerrecommended'] = 'PHP Tokenizer aukerako luzapena instalatzea gomendagarria da - Moodle Sarearen funtzionamendua hobetzen du.';
$string['tools'] = 'Kudeaketarako tresnak';
$string['toolsmanage'] = 'Kudeatu kudeaketarako tresnak';
$string['unattendedoperation'] = 'Alde batera utzitako eragiketa';
$string['unbookmarkthispage'] = 'Desmarkatu orri hau';
$string['unicoderecommended'] = 'Datu guztiak Unicode (UTF-8)-n gordetzeko gomendatzen da. Instalazio berriak berez Unicode karaktere-multzoa duten datu-baseetan exekutatu beharko lirateke. Eguneraketa bat egiten ari bazara, UTF-8rako migrazio-prozesua egin beharko zenuke (begiratu horretarako Kudeaketa-orria)';
$string['unicoderequired'] = 'Datu guztiak Unicode (UTF-8)-n gorde behar dituzu. Instalazio berriak berez Unicode karaktere-multzoa duten datu-baseetan exekutatu beharko lirateke. Eguneraketa bat egiten ari bazara, UTF-8rako migrazio-prozesua egin beharko zenuke (begiratu horretarako Kudeaketa-orria)';
$string['uninstallplugin'] = 'Desinstalatu';
$string['unsupported'] = 'Onartu gabea';
$string['unsuspenduser'] = 'Aktibatu erabiltzailearen kontua';
$string['updateaccounts'] = 'Dauden kontuak eguneratu';
$string['updateavailable'] = 'Bada Moodle-ren bertsio berriago bat eskuragarri!';
$string['updateavailabledetailslink'] = 'Ikusi {$a->url} xehetasun gehiago izateko';
$string['updateavailableforplugin'] = 'Eskuragarri dago zure hainbat pluginen bertsio berriagoa!';
$string['updateavailableinstall'] = 'Instalatu eguneraketa hau';
$string['updateavailable_moreinfo'] = 'Informazio gehiago...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = '{$a} bertsioa';
$string['updatecomponent'] = 'Osagaia eguneratu';
$string['updatenotificationfooter'] = 'Zure {$a->siteurl} Moodle gunea eskuragarri dauden eguneraketak automatikoki aztertzeko dago konfiguratuta. Gunearen kudeatzaile gisa jasotzen duzu mezu hau. Eskuragarri dauden eguneraketak automatikoki aztertzea desgaitu egin dezakezu Ezarpenak blokeko Gunearen Kudeaketa atalean. Mezu honen bidalketa pertsonalizatu egin dezakezu zeure Nire profilaren ezarpenak ataleko Mezularitza ezarpenak erabilita.';
$string['updatenotifications'] = 'Eguneraketen jakinarazpenak';
$string['updatenotificationsubject'] = 'Eskuragarri daude Moodle-ren hainbat eguneraketa ({$a->siteurl})';
$string['upgrade197noticesubject'] = 'Moodle 1.9.7rako eguneraketaren segurtasun-albisteak';
$string['upgrade197salt'] = 'Zure pasahitza lapurtzeko arriskua gutxitzeko, benetan gomendatzen dizugu pasahitzaren eraldaketa ezartzea. <br />Begiratu<a href="{$a}" target="_blank">pasahitzaren eraldaketarako dokumentazioa</a> xehetasun gehiagotarako.';
$string['upgradeerror'] = 'Errore ezezaguna {$a->plugin} {$a->version} bertsiora eguneratzean, ezin da aurrera egin.';
$string['upgradeforumread'] = 'Moodle 1.5en foroetara bidalitako irakurritako eta irakurri gabeko mezuak bilatzeko funtzionalitate berria erantsi da.<br />Funtzionalitate hori erabiltzeko, <a href="{$a}">zure taulak eguneratu behar dituzu</a>.';
$string['upgradeforumreadinfo'] = 'Moodle 1.5en foroetara bidalitako irakurritako eta irakurri gabeko mezuak bilatzeko funtzionalitate berria erantsi da. Funtzionalitate hori erabiltzeko, zure taulak eguneratu behar dituzu mezuen informazio osoarekin. Gunearen tamainaren arabera, honek luze jo dezake (orduak) eta datu-basearen erabilera astuna ekarri. Hori dela eta, hobe da lasaitasun une batea egitea. Hala ere, eguneratzean zehar guneak martxan jarraituko du eta erabiltzaileak ez dira kaltetuko. Behin prozesua hasita, bukatzen utzi beharko zenuke (ad., nabigatzailearen leihoa irekita utzi). Hala ere, leihoa itxi eta prozesua eteten baduzu, ez zaitez kezkatu, beti ere berriro has zaitezke.<br /><br />Prozesua orain hasi nahi al duzu?';
$string['upgradelogs'] = 'Funtzionalitate osoa lortzeko, zure erregistro zaharrak eguneratu behar dira. <a href="{$a}">Informazio gehiago</a>';
$string['upgradelogsinfo'] = 'Duela gutxi erregistroak gordetzeko moduan aldaketak egin dira. Zure erregistro zaharrak jardueraren arabera sailkatuta ikusteko, erregistro horiek eguneratu behar dira. Tamainaren arabera prozesuak luze jo dezake (ad., ordu batzuk) datu-basean behin eta berriro kontsultako beharko baita. bukatzen utzi beharko zenuke (ad., nabigatzailearen leihoa irekita utzi). Hala ere, leihoa itxi eta prozesua eteten baduzu, ez zaitez kezkatu, beti ere berriro has zaitezke.<br /><br />Prozesua orain hasi nahi al duzu?';
$string['upgradepluginsinfo'] = 'Pluginak eguneratzen';
$string['upgradesettings'] = 'Ezarpen berriak';
$string['upgradesettingsintro'] = 'Beheragoko ezarpenak Moodle-ren azken eguneraketan gehitu ziren. Egin beharrezko aldaketak berezko baloreetan eta ondoren sakatu orriaren bukaerako &quot;Aldaketak gorde&quot; botoiari.';
$string['upgradestart'] = 'Eguneratu Moodle datu-basea orain';
$string['upgradesure'] = 'Moodle-ko zure fitxategiak aldatu dira, eta zure zerbitzaria bertsio honetara eguneratzear zaude:
<p><b>{$a}</b></p>
<p>Hori egin eta gero, ezingo duzu atzera jo.</p>
<p>Zerbitzari hau bertsio horretara eguneratu nahi duzula ziur al zaude?</p>';
$string['upgradetimedout'] = 'Bukatu da eguneraketarako denbora; mesedez, ekin berriz eguneraketari.';
$string['upgradingdata'] = 'Datuak eguneratzen';
$string['upgradinglogs'] = 'Erregistroak eguneratzen';
$string['upgradingversion'] = 'Bertsio berria eguneratzen';
$string['upwards'] = 'gora';
$string['useblogassociations'] = 'Asoziazioak gaitu';
$string['useexternalyui'] = 'YUI liburutegiak online erabili';
$string['user'] = 'Erabiltzailea';
$string['userbulk'] = 'Erabiltzaile-eragiketa masiboak';
$string['userlist'] = 'Erabiltzaileen zerrenda aztertu';
$string['userpolicies'] = 'Erabiltzailearen politikak';
$string['userpreference'] = 'Erabiltzailearen hobespena';
$string['userquota'] = 'Erabiltzailearen kuota';
$string['users'] = 'Erabiltzaileak';
$string['usesitenameforsitepages'] = 'Erabili gunearen izena guneko orrietarako';
$string['usetags'] = 'Etiketen funtzionalitatea gaitu';
$string['validateerror'] = 'Balore hau ez zen onargarria:';
$string['warningcurrentsetting'] = 'Orain balorea ez da baliozkoa: {$a}';
$string['webproxy'] = 'Web proxya';
$string['webproxyinfo'] = 'Ondoko aukerak bete zure Moodle zerbitzariak zuzenean interneterako sarbidea ez badu. Beharrezkoa da ingunearen datuak, hizkuntza-paketeak, RSS jarioak... jaitsi ahal izateko. <br /><em>Oso gomendagarria da PHP cURL luzapena.</em>\'*;';
$string['xmlrpcrecommended'] = 'xmlrpc luzapena beharrezkoa da hub komunikaziorako eta erabilgarria web zerbitzuetarako eta Moodle Sarea funtzionalitaterako.';
$string['yuicomboloading'] = 'YUI combo kargatzen';
$string['ziprequired'] = 'Moodle-k orain Zip PHP luzapena behar du. Dagoeneko ez dira info-ZIP bitarrak erabiltzen ezta PclZip liburutegia ere.';
$string['zlibenabled'] = 'zlib gaituta';
