<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'cy', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'ar fin cael ei osod';
$string['action'] = 'Gweithred';
$string['actionchoice'] = 'Beth ydych chi eisiau ei wneud gyda\'r ffeil \'{$a}\'?';
$string['actions'] = 'Gweithredoedd';
$string['active'] = 'Ar waith';
$string['activeusers'] = 'Defnyddwyr sydd ar waith';
$string['activities'] = 'Gweithgareddau';
$string['activities_help'] = 'Gweithgareddau megis fforymau, cwisiau a wicis, er mwyn ychwanegu cynnwys rhyngweithiol at y cwrs.';
$string['activity'] = 'Gweithgaredd';
$string['activityclipboard'] = 'Wrthi\'n symud y gweithgaredd hwn: {$a}';
$string['activityiscurrentlyhidden'] = 'Mae\'n flin gennyf, mae\'r gweithgaredd hwn wedi\'i guddio ar hyn o bryd';
$string['activitymodule'] = 'Modiwl gweithgaredd';
$string['activitymodules'] = 'Modiwlau gweithgaredd';
$string['activityreport'] = 'Adroddiad Gweithgaredd';
$string['activityreports'] = 'Adroddiadau ar weithgareddau';
$string['activityselect'] = 'Dewiswch y gweithgaredd hwn i\'w symud i rywle arall';
$string['activitysince'] = 'Gweithgaredd ers {$a}';
$string['activityweighted'] = 'Gweithgaredd fesul defnyddiwr';
$string['add'] = 'Ychwanegu';
$string['addactivity'] = 'Ychwanegu gweithgaredd...';
$string['addactivitytosection'] = 'Ychwanegu gweithgaredd at adran  \'{$a}\'';
$string['addadmin'] = 'Ychwanegu Gweinyddwr';
$string['addblock'] = 'Ychwanegu bloc';
$string['addcomment'] = 'Ychwanegu sylw';
$string['addcountertousername'] = 'Creu defnyddiwr drwy ychwanegu rhif at enw defnyddiwr';
$string['addcreator'] = 'Ychwanegu\'r person wnaeth greu\'r cwrs';
$string['adddots'] = 'Ychwanegu...';
$string['added'] = 'Wedi ychwanegu {$a}';
$string['addedrecip'] = 'Wedi ychwanegu {$a} derbynnydd newydd';
$string['addedrecips'] = 'Wedi ychwanegu {$a} derbynnydd newydd';
$string['addedtogroup'] = 'Wedi\'i ychwanegu at y grŵp {$a}';
$string['addedtogroupnot'] = 'Heb ei ychwanegu at y grŵp {$a}';
$string['addedtogroupnotenrolled'] = 'Heb ei ychwanegu at y grŵp {$a}, oherwydd nid yw wedi cofrestru ar y cwrs';
$string['addfilehere'] = 'Ychwanegu ffeil(iau) yma';
$string['addinganew'] = 'Wrthi\'n ychwanegu {$a} newydd';
$string['addinganewto'] = 'Wrthi\'n ychwanegu {$a->what} newydd i {$a->to}';
$string['addingdatatoexisting'] = 'Wrthi\'n ychwanegu data at yr hyn sydd eisoes yn bodoli';
$string['additionalnames'] = 'Enwau ychwanegol';
$string['addlinkhere'] = 'Ychwanegu dolen yma';
$string['addnewcategory'] = 'Ychwanegu categori newydd';
$string['addnewcourse'] = 'Ychwanegu cwrs newydd';
$string['addnewuser'] = 'Ychwanegu defnyddiwr newydd';
$string['addnousersrecip'] = 'Ychwanegu\'r defnyddwyr sydd heb fynd i mewn i\'r {$a} at y rhestr derbynnwyr';
$string['addpagehere'] = 'Ychwanegu testun yma';
$string['addresource'] = 'Ychwanegu adnodd...';
$string['addresourceoractivity'] = 'Ychwanegu gweithgaredd neu adnodd';
$string['addresourcetosection'] = 'Ychwanegu adnodd at adran \'{$a}\'';
$string['address'] = 'Cyfeiriad';
$string['addstudent'] = 'Ychwanegu myfyriwr';
$string['addsubcategory'] = 'Ychwanegu is-gategori';
$string['addteacher'] = 'Ychwanegu athro';
$string['admin'] = 'Gweinyddwr';
$string['adminhelpaddnewuser'] = 'I greu cyfrif defnyddiwr newydd â llaw';
$string['adminhelpassignadmins'] = 'Gall gweinyddwyr wneud unrhyw beth a mynd i unrhyw le ar y safle';
$string['adminhelpassigncreators'] = 'Gall crëwyr greu cyrsiau newydd';
$string['adminhelpassignsiteroles'] = 'Rhoi swyddogaethau safle diffiniedig i ddefnyddwyr penodol';
$string['adminhelpassignstudents'] = 'Mynd i mewn i gwrs ac ychwanegu myfyrwyr o\'r ddewislen weinyddu';
$string['adminhelpauthentication'] = 'Gallwch ddefnyddio cyfrifon defnyddwyr mewnol neu gronfeydd data allanol';
$string['adminhelpbackup'] = 'Ffurfweddu copïau wrth gefn a\'r hamserlen yn awtomatig';
$string['adminhelpconfiguration'] = 'Ffurfweddu sut mae\'r safle\'n edrych ac yn gweithio';
$string['adminhelpconfigvariables'] = 'Ffurfweddu\'r newidynnau sy\'n effeithio ar weithrediad cyffredinol y safle';
$string['adminhelpcourses'] = 'Diffinio cyrsiau a chategorïau, a neilltuo pobl iddynt, gan olygu cyrsiau sydd ar y gweill';
$string['adminhelpeditorsettings'] = 'Diffinio gosodiadau sylfaenol ar gyfer golygydd HTML';
$string['adminhelpedituser'] = 'Pori\'r rhestr o gyfrifon defnyddwyr a golygu unhryw rai ohonynt';
$string['adminhelpenvironment'] = 'Gwirio i weld sut mae eich gweinydd yn delio â gofynion gosodiadau ar hyn o bryd ac i\'r dyfodol';
$string['adminhelpfailurelogs'] = 'Pori\'r log o\'r holl gynigion aflwyddiannus i fewngofnodi';
$string['adminhelplanguage'] = 'Ar gyfer gwirio a golygu\'r pecyn iaith cyfredol';
$string['adminhelplogs'] = 'Pori logiau\'r holl weithgareddau ar y safle hwn';
$string['adminhelpmanageblocks'] = 'Rheoli\'r blociau a osodwyd a\'u gosodiadau';
$string['adminhelpmanagedatabase'] = 'Mynd i mewn i\'r gronfa ddata\'n uniongyrchol (byddwch yn ofalus!)';
$string['adminhelpmanagefilters'] = 'Dewis hidlyddion testun a\'r gosodiadau perthynnol';
$string['adminhelpmanagemodules'] = 'Rheoli modiwlau a osodwyd a\'u gosodiadau';
$string['adminhelpmanageroles'] = 'Creu a diffinio swyddogaethau y gellid eu rhoi i ddefnyddwyr';
$string['adminhelpmymoodle'] = 'Ffurfweddu blociau \'fy moodle\' ar gyfer defnyddwyr';
$string['adminhelpreports'] = 'Adroddiadau level safle';
$string['adminhelpsitefiles'] = 'Ar gyfer cyhoeddi ffeiliau cyffredinol neu lwytho i fyny copïau wrth gefn allanol';
$string['adminhelpsitesettings'] = 'Diffinio sut mae tudalen flaen y safle\'n edrych';
$string['adminhelpstickyblocks'] = 'Ffurfweddu blociau llydan gludiog moodle';
$string['adminhelpthemes'] = 'Dewis sut mae\'r safle\'n edrych (lliwiau, ffontiau ac ati)';
$string['adminhelpuploadusers'] = 'Mewngludo cyfrifon defnyddwyr newydd o ffeil destun';
$string['adminhelpusers'] = 'Diffino\'ch defnyddwyr a sefydlu\'r broses ddilysu';
$string['adminhelpxmldbeditor'] = 'Rhyngwyneb i olygu\'r ffeiliau XMLDB.  Ar gyfer datblygwyr yn unig.';
$string['administration'] = 'Gweinyddiaeth';
$string['administrationsite'] = 'Gweinyddiaeth safle';
$string['administrator'] = 'Gweinyddwr';
$string['administratordescription'] = 'Fel rheol, gall gweinyddwyr wneud unrhyw beth ar y safle, ym mhob cwrs';
$string['administrators'] = 'Gweinyddwyr';
$string['administratorsall'] = 'Pob gweinyddwr';
$string['administratorsandteachers'] = 'Gweinyddwyr ac athrawon';
$string['advanced'] = 'Uwch';
$string['advancedfilter'] = 'Chwiliad ar lefel uwch';
$string['advancedsettings'] = 'Mwy o osodiadau';
$string['afterresource'] = 'Ar ôl adnodd "{$a}"';
$string['aftersection'] = 'Ar ôl adran "{$a}"';
$string['again'] = 'eto';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX a Javascript';
$string['all'] = 'Pob Un';
$string['allactions'] = 'Pob gweithred';
$string['allactivities'] = 'Pob gweithgaredd';
$string['allcategories'] = 'Pob categori';
$string['allchanges'] = 'Pob newid';
$string['alldays'] = 'Pob diwrnod';
$string['allfieldsrequired'] = 'Mae angen pob maes';
$string['allfiles'] = 'Pob ffeil';
$string['allgroups'] = 'Pob grŵp';
$string['alllogs'] = 'Pob log';
$string['allmods'] = 'Pob un $a';
$string['allow'] = 'Caniatáu';
$string['allowinternal'] = 'Caniatáu dulliau mewnol hefyd';
$string['allownone'] = 'Peidio â chaniatáu yr un o\'r rhain';
$string['allownot'] = 'Peidio â chaniatau';
$string['allparticipants'] = 'Pob aelod';
$string['allteachers'] = 'Pob athro';
$string['alphanumerical'] = 'Dim ond llythrennau neu rifau alffaniwmerig, cysylltnod (-) neu atalnod llawn (.)';
$string['alreadyconfirmed'] = 'Wedi cadarnhau\'r cofrestriad eisoes';
$string['alternatename'] = 'Enw amgen';
$string['always'] = 'Bob tro';
$string['and'] = '{$a->one} a {$a->two}';
$string['answer'] = 'Ateb';
$string['any'] = 'Unrhyw un';
$string['appearance'] = 'Ymddangosiad';
$string['approve'] = 'Cymeradwyo';
$string['areyousuretorestorethis'] = 'Ydych chi am fwrw ymlaen?';
$string['areyousuretorestorethisinfo'] = 'Yn nes ymlaen yn y broses hon, bydd cyfle gennych i ychwanegu\'r copi wrth gefn hwn at gwrs sydd eisoes yn bodoli neu at gwrs hollol newydd.';
$string['asc'] = 'I Fyny';
$string['assessment'] = 'Asesiad';
$string['assignadmins'] = 'Neilltuo gweinyddwyr';
$string['assigncreators'] = 'Neilltuo crëwyr';
$string['assignedrolecount'] = '{$a->rôl}: {$a->cyfrif}';
$string['assignsiteroles'] = 'Neilltuo swyddogaethau safle cyfan';
$string['authenticateduser'] = 'Defnyddiwr dilys';
$string['authenticateduserdescription'] = 'Pob defnyddiwr sydd wedi mewngofnodi.';
$string['authentication'] = 'Dilysiad';
$string['authenticationplugins'] = 'Ategion dilysu';
$string['autosubscribe'] = 'Tanysgrifo\'n awtomatig i\'r fforwm';
$string['autosubscribeno'] = 'Na: nid wyf am danysgrifo\'n awtomatig i\'r fforymau';
$string['autosubscribeyes'] = 'Iawn: rwyf am danysgrifio i fforwm pan fyddaf yn postio neges arno';
$string['availability'] = 'Ar gael';
$string['availablecourses'] = 'Cyrsiau sydd ar gael';
$string['back'] = 'Yn ôl';
$string['backto'] = 'Yn ôl i {$a}';
$string['backtocourselisting'] = 'Yn ôl i restrau\'r cwrs';
$string['backtopageyouwereon'] = 'Yn ôl i\'r dudalen roeddech chi arni';
$string['backtoparticipants'] = 'Yn ôl i\'r rhestr o\'r cyfranwyr';
$string['backup'] = 'Copi wrth gefn';
$string['backupactivehelp'] = 'Dewis gwneud copi wrth gefn yn awtomatig neu beidio';
$string['backupcancelled'] = 'Wedi canslo\'r broses o greu copi wrth gefn';
$string['backupcoursefileshelp'] = 'Os caiff ei alluogi, caiff ffeiliau\'r cwrs eu cynnwys wrth wneud copïau wrth gefn yn awtomatig';
$string['backupdate'] = 'Dyddiad gwneud copi wrth gefn';
$string['backupdatenew'] = '&nbsp; {$a->TAG} nawr yn {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} oedd yn {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Manylion y copi wrth gefn';
$string['backupexecuteathelp'] = 'Dewisiwch pryd ddylai\'r broses o greu copi wrth gefn redeg yn awtomatig.';
$string['backupfailed'] = 'Nid yw rhai o\'ch cyrsiau wedi\'u cadw!!';
$string['backupfilename'] = 'copi wrth gefn';
$string['backupfinished'] = 'Wedi creu copi wrth gefn yn llwyddiannus';
$string['backupfromthissite'] = 'A wnaed copi wrth gefn ar y safle hwn?';
$string['backupgradebookhistoryhelp'] = 'Os yw wedi\'i alluogi, yna bydd hanes y llyfr graddau yn cael ei gynnwys wrth wneud y copïau wrth gefn awtomataidd. Cofiwch na ddylech analluogi hanes y llyfr graddau yng ngosodiadau\'r gweinydd (disablegradehistory) er mwyn i hyn weithio';
$string['backupincludemoduleshelp'] = 'Dewiswch a ydych chi am gynnwys modiwlau cwrs, gyda neu heb ddata defnyddwyr, wrth greu copïau wrth gefn yn awtomatig';
$string['backupincludemoduleuserdatahelp'] = 'Dewiswch a ydych chi am gynnwys data defnyddwyr modiwl wrth greu copïau wrth gefn yn awtomatig';
$string['backupkeephelp'] = 'Sawl copi wrth-gefn diweddar o bob cwrs hoffech chi eu cadw? (bydd hen rai\'n cael eu dileu\'n awtomatig)';
$string['backuplogdetailed'] = 'Log gweithredu manwl';
$string['backuploglaststatus'] = 'Log gweithredu diwethaf';
$string['backupmissinguserinfoperms'] = 'Nodyn: Nid yw\'r copi wrth gefn hwn yn cynnwys data defnyddiwr. Ni fydd gweithgareddau Ymarfer na Gweithdai yn cael eu cynnwys yn y copi wrth gefn oherwydd dydy\'r modiwlau hyn ddim yn gydnaws â\'r math hwn o gopi wrth gefn.';
$string['backupnext'] = 'Copi wrth gefn nesaf';
$string['backupnonisowarning'] = 'Rhybudd: mae\'r copi wrth gefn hwn yn deillio o fersiwn o Moodle heb Unicode (cyn 1.6). Os yw\'r copi wrth gefn hwn yn cynnwys unrhyw destun nad yw\'n ISO-8859-1 yna gallant droi\'n LLWGR os ceisiwch eu hagor yn y fersiwn Unicode hon o Moodle. Ewch i <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> am ragor o wybodaeth am sut i adfer y copi wrth gefn hwn yn gywir.';
$string['backupnotyetrun'] = 'Yn aros am wneud copi wrth gefn yn awtomatig';
$string['backuporiginalname'] = 'Enw\'r copi wrth gefn';
$string['backuproleassignments'] = 'Y swyddogaeth copi wrth gefn sydd wedi\'i neilltuo i\'r swyddogaethau hyn';
$string['backupsavetohelp'] = 'Y llwybr llawn i\'r cyfeiriadur lle\'r ydych am gadw\'r ffeiliau wrth gefn<br />(gadewch yn wag os ydych am eu cadw yng nghyfeiriadur diofyn y cwrs)';
$string['backupsitefileshelp'] = 'Os yw hwn wedi\'i alluogi, bydd ffeiliau safle sy\'n cael eu defnyddio mewn cyrsiau yn cael eu cynnwys wrth wneud copïau wrth gefn';
$string['backuptakealook'] = 'Tarwch olwg ar eich log o\'r copïau wrth gefn yn:
  {$a}';
$string['backupuserfileshelp'] = 'Dewiswch a ydych chi am gynnwys ffeiliau defnyddwyr (ee delweddau proffil) yn y broses o greu copi wrth gefn yn awtomatig';
$string['backupversion'] = 'Fersiwn y copi wrth gefn';
$string['badges'] = 'Bathodynnau';
$string['block'] = 'Bloc';
$string['blockconfiga'] = 'Ffurfweddu bloc {$a}';
$string['blockconfigbad'] = 'Nid yw\'r bloc wedi cael ei roi ar waith yn gywir felly nid yw\'n gallu darparu rhyngwyneb ffurfweddu.';
$string['blocks'] = 'Blociau';
$string['blocksaddedit'] = 'Ychwanegu/Golygu blociau';
$string['blockseditoff'] = 'Analluogi golygu blociau';
$string['blocksediton'] = 'Galluogi golygu blociau';
$string['blocksetup'] = 'Creu tablau bloc';
$string['blocksuccess'] = 'Ni osodwyd {$a} tabl yn gywir';
$string['brief'] = 'Cryno';
$string['bulkactions'] = 'Gweithredoedd Swmp';
$string['bulkactionselect'] = '{$a} dewisiad gweithred swmp';
$string['bulkmovecoursessuccess'] = 'Wedi llwyddo i symud {$a->cwrs} cwrs i {$a->gategori}';
$string['bycourseorder'] = 'Fesul trefn y cwrs';
$string['byname'] = 'erbyn {$a}';
$string['bypassed'] = 'Pasio Heibio';
$string['cachecontrols'] = 'Rheolyddion y storfa';
$string['cancel'] = 'Canslo';
$string['cancelled'] = 'Wedi Canslo';
$string['categories'] = 'Categoriau\'r cwrs';
$string['categoriesandcoures'] = 'Cyrsiau a chategorïau\'r cyrsiau';
$string['category'] = 'Categori';
$string['categoryadded'] = 'Wedi ychwanegu\'r categori \'{$a}\'';
$string['categorybulkaction'] = 'Gweithrediadau swmp ar gyfer y categorïau a ddewiswyd';
$string['categorycontents'] = 'Isgategorïau a chyrsiau';
$string['categorycurrentcontents'] = 'Cynnwys {$a}';
$string['categorydeleted'] = 'Wedi dileu\'r categori \'{$a}\'';
$string['categoryduplicate'] = 'Mae categori o\'r enw \'{$a}\' eisoes yn bodoli!';
$string['categorymodifiedcancel'] = 'Mae\'r categori wedi\'i addasu! Bydd angen i chi ganslo a rhoi cynnig arall arni.';
$string['categoryname'] = 'Enw\'r categori';
$string['categorysubcategoryof'] = '{$a->categori} - is-gategori {$a->categorirhiant}';
$string['categoryupdated'] = 'Wedi diweddaru\'r categori \'$a\'';
$string['changedpassword'] = 'Wedi newid cyfrinair';
$string['changepassword'] = 'Newid cyfrinair';
$string['changesmadereallygoaway'] = 'Rydych chi wedi gwneud newidiadau. Ydych chi\'n siŵr eich bod eisiau gadael a cholli eich newidiadau?';
$string['changessaved'] = 'Wedi cadw\'r newidiadau';
$string['check'] = 'Gwirio';
$string['checkall'] = 'Gwirio pob un';
$string['checkingbackup'] = 'Wrthi\'n gwirio\'r copi wrth gefn';
$string['checkingcourse'] = 'Wrthi\'n gwirio\'r cwrs';
$string['checkingforbbexport'] = 'Wrthi\'n chwilio am y ffeil BlackBoard a allgudwyd';
$string['checkinginstances'] = 'Wrthi\'n gwirio\'r niferoedd';
$string['checkingsections'] = 'Wrthi\'n gwirio\'r adrannau';
$string['checklanguage'] = 'Wrthi\'n gwirio\'r iaith';
$string['checknone'] = 'Gwirio dim';
$string['childcoursenotfound'] = 'Heb ddod o hyd i gwrs plentyn!';
$string['childcourses'] = 'Cyrsiau plant';
$string['choose'] = 'Dewis';
$string['choosecourse'] = 'Dewis cwrs';
$string['choosedots'] = 'Dewiswch...';
$string['chooselivelogs'] = 'Neu gwylio\'r gweithgareddau presennol';
$string['chooselogs'] = 'Dewis pa logiau yr ydych am eu gweld';
$string['choosereportfilter'] = 'Dewis hidlydd ar gyfer yr adroddiad';
$string['choosetheme'] = 'Dewis thema';
$string['chooseuser'] = 'Dewis defnyddiwr';
$string['city'] = 'Dinas/tref';
$string['clambroken'] = 'Mae eich gweinyddwr wedi dewis gwirio ffeiliau a lwythwyd i fyny am feirysau ond mae rhywbeth wedi mynd o\'i le.<br/> NI lwythwyd eich ffeil i fyny\'n llwyddiannus. Anfonwyd e-bost at eich gweinyddwr i\'w hysbysu am hyn i drwsio\'r broblem.<br/>Rhowch gynnig ar lwytho\'r ffeil i fyny eto\'n nes ymlaen.';
$string['clamdeletedfile'] = 'Wedi dileu\'r ffeil';
$string['clamdeletedfilefailed'] = 'Heb lwyddo i ddileu\'r ffeil';
$string['clamemailsubject'] = '{$a} :: hysbysiad Clam AV';
$string['clamfailed'] = 'Nid yw Clam AV wedi gallu rhedeg. Dyma\'r neges wall {$a}. Dyma\'r hyn a gynhyrchwyd gan Clam:';
$string['clamlost'] = 'Mae Moodle wedi\'i ffurfweddu i redeg clam wrth lwytho ffeil i fyny, ond nid yw\'r llwybr a roddwyd i Clam AV yn ddilys {$a}.';
$string['clamlostandactinglikevirus'] = 'Hefyd, mae moodle wedi\'i ffurfweddu i drin ffeiliau fel feirysau os nad yw clam yn gallu rhedeg. Mae hyn yn golygu na all yr un myfyriwr lwytho ffeil i fyny hyd nes y caiff hyn ei drwsio.';
$string['clammovedfile'] = 'Wedi symud y ffeil i\'ch cyfeiriadur cwarantin, y lleoliad newydd yw {$a}';
$string['clammovedfilebasic'] = 'Mae\'r ffeil wedi\'i symud i\'r cyfeirlyfr cwarantîn';
$string['clamquarantinedirfailed'] = 'Doedd dim modd symud y ffeil i\'ch cyfeiriadur cwarantîn, {$a}. Mae angen i chi drwsio hyn oherwydd caiff ffeiliau eu dileu os tybir bod feirws arnynt.';
$string['clamunknownerror'] = 'Mae Clam wedi dod ar draws gwall anhysbys.';
$string['cleaningtempdata'] = 'Glanhau\'r data dros dro';
$string['clear'] = 'Clirio';
$string['clickhelpiconformoreinfo'] = '... yn parhau ... Cliciwch yr eicon help i ddarllen yr erthygl gyfan';
$string['clickhere'] = 'Cliciwch yma ...';
$string['clicktochangeinbrackets'] = '{$a} (Cliciwch i newid)';
$string['clicktohideshow'] = 'Cliciwch i ehangu neu grebachu';
$string['closewindow'] = 'Cau\'r ffenstr hon';
$string['collapse'] = 'Cwympo';
$string['collapseall'] = 'Crebachu pob un';
$string['collapsecategory'] = 'Cwympo {$a}';
$string['commentincontext'] = 'Dod o hyd i\'r sylw hwn yn ei gyd-destun';
$string['comments'] = 'Sylwadau';
$string['commentsnotenabled'] = 'Dydy\'r nodwedd sylwadau ddim wedi\'i alluogi';
$string['commentsrequirelogin'] = 'Mae angen i chi fewngofnodi i weld y sylwadau';
$string['comparelanguage'] = 'Cymharu a golygu\'r iaith gyfredol';
$string['complete'] = 'Cwblhau';
$string['completereport'] = 'Cwblhau adroddiad';
$string['configuration'] = 'Ffurfweddiad';
$string['confirm'] = 'Cadarnhau';
$string['confirmcheckfull'] = 'Ydych chi\'n hollol siŵr eich bod am gadarnhau {$a} ?';
$string['confirmcoursemove'] = 'Ydych chi\'n siŵr eich bod am symud y cwrs hwn i ({$a->course}) i\'r categori hwn ({$a->category})?';
$string['confirmed'] = 'Wedi cadarnhau eich cofrestriad';
$string['confirmednot'] = 'Nid yw eich cofrestriad wedi\'i gadarnhau eto!';
$string['content'] = 'Cynnwys';
$string['continue'] = 'Bwrw ymlaen';
$string['continuetocourse'] = 'Cliciwch yma i fynd i mewn i\'ch cwrs';
$string['convertingwikitomarkdown'] = 'Trosi wiki i Markdown';
$string['cookiesenabled'] = 'Rhaid galluogi briwsion yn eich prowr.';
$string['cookiesenabled_help'] = 'Mae\'r safle hwn yn defnyddio dau gwci:

Yr un hanfodol yw cwci\'r sesiwn, a elwir yn MoodleSession fel arfer. Rhaid i chi ganiatáu\'r cwci hwn i mewn i\'ch porwr er mwyn cael dilyniant ac i sicrhau eich bod yn dal wedi mewngofnodi wrth fynd o un dudalen i\'r llall. Pan fyddwch yn allgofnodi neu\'n cau\'r porwr, bydd y cwci hwn yn cael ei ddinistrio (yn eich porwr ac ar y gweinydd). Mae\'r cwci arall er hwylustod yn unig, a elwir yn MOODLEID fel arfer neu rywbeth tebyg. Yr unig beth mae\'n ei wneud yw cofio eich enw defnyddiwr yn y porwr. Golyga hyn pan fyddwch yn dod yn ôl i\'r safle hwn, bydd y maes enw defnyddiwr ar y dudalen mewngofnodi eisoes wedi\'i lenwi ar eich cyfer. Mae\'n ddiogel i chi atal y cwci hwn - ond bydd rhaid i chi aildeipio eich enw defnyddiwr bob tro y byddwch yn mewngofnodi.';
$string['cookiesnotenabled'] = 'Yn anffodus, nid yw eich porwr yn galluogi briwsion ar hyn o bryd';
$string['copy'] = 'copïo';
$string['copyasnoun'] = 'copi';
$string['copyingcoursefiles'] = 'Wrthi\'n copïo ffeiliau cwrs';
$string['copyingsitefiles'] = 'Wrthi\'n copïo\'r ffeiliau safle sy\'n cael eu defnyddio yn y cwrs';
$string['copyinguserfiles'] = 'Wrthi\'n copïo ffeiliau defnyddwyr';
$string['copyingzipfile'] = 'Wrthi\'n copïo ffeil sip';
$string['copyrightnotice'] = 'Rhybudd Hawlfraint';
$string['coresystem'] = 'System graidd';
$string['cost'] = 'Cost';
$string['costdefault'] = 'Cost diofyn';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Gwlad';
$string['course'] = 'Cwrs';
$string['courseadministration'] = 'Gweinyddiaeth cwrs';
$string['courseapprovedemail'] = 'Mae eich dewis o gwrs, {$a->name}, wedi\'i gymeradwyo ac rydych nawr yn {$a->teacher}. I fynd i mewn i\'ch cwrs newydd, ewch i {$a->url}';
$string['courseapprovedemail2'] = 'Mae\'r cwrs y gwnaethoch gais amdano, {$a->name}, wedi cael ei gymeradwyo.  I fynd i\'ch cwrs newydd, ewch i {$a->url}';
$string['courseapprovedfailed'] = 'Heb lwyddo i gadw\'r cwrs fel un a gymeradwywyd!';
$string['courseapprovedsubject'] = 'Wedi cymeradwyo\'ch cwrs!';
$string['courseavailable'] = 'Mae\'r cwrs hwn ar gael i fyfyrwyr';
$string['courseavailablenot'] = 'Nid yw\'r cwrs hwn ar gael i fyfyrwyr';
$string['coursebackup'] = 'Copi wrth gefn o\'r cwrs';
$string['coursebulkaction'] = 'Gweithredoedd swmp ar gyfer y cyrsiau a ddewiswyd';
$string['coursecategories'] = 'Categorïau\'r Cwrs';
$string['coursecategory'] = 'Categori\'r cwrs';
$string['coursecategorydeleted'] = 'Wedi dileu categori\'r cwrs {$a}';
$string['coursecategory_help'] = 'Mae\'r gosodiad hwn yn pennu ym mha gategori fydd y cwrs yn ymddangos yn y rhestr cyrsiau.';
$string['coursecatmanagement'] = 'Rheoli cyrsiau a chategorïau';
$string['coursecompletion'] = 'Cwblhau\'r cwrs';
$string['coursecompletions'] = 'Cwblhau\'r cwrs';
$string['coursecreators'] = 'Crëwr y cwrs';
$string['coursecreatorsdescription'] = 'Gall crëwyr cyrsiau greu cyrsiau newydd.';
$string['coursedeleted'] = 'Wedi dileu\'r cwrs {$a}';
$string['coursedisplay'] = 'Cynllun y cwrs';
$string['coursedisplay_help'] = 'Mae\'r gosodiad hwn yn pennu a yw\'r cwrs cyfan yn cael ei ddangos ar un dudalen neu\'n cael ei rannu dros sawl tudalen.';
$string['coursedisplay_multi'] = 'Dangos un adran y dudalen';
$string['coursedisplay_single'] = 'Dangos pob adran ar un dudalen';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Hen ffeiliau cwrs';
$string['coursefilesedit'] = 'Golygu hen ffeiliau cwrs';
$string['coursefileswarning'] = 'Mae ffeiliau\'r cwrs wedi\'u hanghymeradwyo';
$string['coursefileswarning_help'] = 'Mae ffeilia\'r cwrs wedi\'u hanghymeradwyo ers Moodle 2.0. Ceisiwch ddefnyddio storfeydd allanol yn lle hynny gymaint ag sy\'n bosib.';
$string['courseformatdata'] = 'Data fformat y cwrs';
$string['courseformatoptions'] = 'Wrthi\'n fformatio\'r dewisiadau ar gyfer {$a}';
$string['courseformats'] = 'Fformatau\'r cwrs';
$string['courseformatudpate'] = 'Diweddaru\'r fformat';
$string['coursegrades'] = 'Graddau\'r cwrs';
$string['coursehelpcategory'] = 'Rhowch y cwrs ar y rhestr cyrsiau. Gallai hyn olygu bod myfyrwyr yn dod o hyd iddo\'n haws.';
$string['coursehelpforce'] = 'Gwneud modd y grŵp cwrs yn berthnasol i bob gweithgaredd yn y cwrs.';
$string['coursehelpformat'] = 'Bydd prif dudalen y cwrs yn ymddangos yn y fformat hwn.';
$string['coursehelphiddensections'] = 'Sut mae\'r adrannau cudd yn y cwrs yn cael eu dangos i\'r myfyrwyr.';
$string['coursehelpmaximumupload'] = 'Diffinio maint y ffeil fwyaf y gellir ei llwytho i fyny yn y cwrs hwn. Bydd y gosodiad ar gyfer y safle cyfan yn cyfyngu ar hyn.';
$string['coursehelpnewsitemsnumber'] = 'Nifer o eitemau diweddar o\'r fforwm newyddion sy\'n ymddangos yn y bloc newyddion diweddaraf ar dudalen y cwrs. Os yw wedi\'i osod i sero, ni fydd y bloc newyddion diweddaraf yn cael ei ddangos.';
$string['coursehelpnumberweeks'] = 'Nifer o adrannau yn y cwrs (yn berthnasol i rai fformatau cwrs yn unig).';
$string['coursehelpshowgrades'] = 'Galluogi\'r llyfr graddau i ymddangos. Nid yw\'n atal y graddau rhag cael eu harddangos yn y gweithgareddau unigol.';
$string['coursehidden'] = 'Nid yw\'r cwrs hwn ar gael i fyfyrwyr ar hyn o bryd';
$string['courseinfo'] = 'Gwyb. am Gwrs';
$string['courselegacyfiles'] = 'Hen ffeiliau cwrs';
$string['courselegacyfiles_help'] = 'Mae adran y ffeiliau cwrs yn darparu cydnawsedd am yn ôl gyda Moodle 1.9 a chynharach. Gall unrhyw un sy’n cymryd rhan yn y cwrs gael mynediad at bob ffeil yn yr adran hon ar bob amser (os ydych yn cysylltu iddyn nhw neu beidio) ac nid oes unrhyw ffordd o wybod lle mae unrhyw un o’r ffeiliau hyn yn cael eu defnyddio un Moodle.

Os ydych yn defnyddio’r adran hon i storio ffeiliau cwrs, gallwch fod yn agored i nifer o broblemau preifatrwydd a diogelwch, yn ogystal â ffeiliau’n mynd ar goll mewn copïau wrth gefn, mewngludo ffeiliau ac mae unrhyw gynnwys amser yn cael ei rannu neu ei ail-ddefnyddio. Mae felly yn argymelledig nad ydych yn defnyddio’r adran hon oni bai eich bod wir yn gwybod beth rydych chi’n ei wneud.';
$string['courselegacyfilesofcourse'] = 'Hen ffeiliau cyrsiau: {$a}';
$string['coursemessage'] = 'Anfonwch neges at ddefnyddwyr y cwrs';
$string['coursenotaccessible'] = 'Ni chaiff y cyhoedd fynd i mewn i\'r cwrs hwn';
$string['courseoverview'] = 'Trosolwg o\'r cwrs';
$string['courseoverviewfiles'] = 'Ffeiliau crynodeb y cwrs';
$string['courseoverviewfilesext'] = 'Estyniadau ffeiliau crynodeb y cwrs';
$string['courseoverviewfiles_help'] = 'Mae ffeiliau crynodeb y cwrs, fel delweddau, yn cael eu dangos yn y rhestr o gyrsiau ynghyd â\'r crynodeb.';
$string['courseoverviewfileslimit'] = 'Terfyn ffeiliau crynodeb y cwrs';
$string['courseoverviewgraph'] = 'Graff yn rhoi trosolwg o\'r cwrs';
$string['courseprofiles'] = 'Proffilau\'r cwrs';
$string['coursereasonforrejecting'] = 'Eich rhesymau dros wrthod y cais hwn';
$string['coursereasonforrejectingemail'] = 'Bydd hyn yn cael ei anfon dros e-bost at y sawl a wnaeth gais';
$string['coursereject'] = 'Gwrthod cais am gwrs';
$string['courserejected'] = 'Gwrthodwyd y cwrs a rhoddwyd gwybod i\'r sawl a wnaeth gais.';
$string['courserejectemail'] = 'Mae\'n flin gennyf, gwrthodwyd y cwrs y gwnaethoch gais iddo. Dyma\'r rheswm pam:
{$a}';
$string['courserejectreason'] = 'Amlinellwch eich rhesymau dros wrthod y cwrs hwn<br />(anfonir hwn drwy e-bost at y sawl a wnaeth gais)';
$string['courserejectsubject'] = 'Mae eich cwrs wedi cael ei wrthod';
$string['coursereport'] = 'Adroddiad cwrs';
$string['coursereports'] = 'Adroddiadau cwrs';
$string['courserequest'] = 'Cais am gwrs';
$string['courserequestdetails'] = 'Manylion y cwrs yr ydych yn gwneud cais iddo';
$string['courserequestfailed'] = 'Am ryw reswm, ni lwyddwyd i gadw eich cais am gwrs';
$string['courserequestintro'] = 'Defnyddiwch y ffurflen hon i greu cais ar gyfer cwrs.<br />Ceisiwch roi cymaint o wybodaeth ag sy\'n bosibl<br />fel bo\'r gweinyddwyr yn deall y rhesymau pam eich bod eisiau\'r cwrs hwn.';
$string['courserequestreason'] = 'Rhesymau dros fod eisiau\'r cwrs hwn';
$string['courserequestsuccess'] = 'Wedi llwyddo i gadw\'ch cais am gwrs.  Anfonir e-bost atoch cyn pen diwrnod neu ddau gyda\'r ateb';
$string['courserequestsupport'] = 'Gwybodaeth ategol i helpu\'r gweinyddwr i werthuso\'r cais hwn';
$string['courserestore'] = 'Adfer cwrs';
$string['courses'] = 'Cyrsiau';
$string['coursesectionsummaries'] = 'Crynodebau o adrannau\'r cwrs';
$string['coursesettings'] = 'Gosodiadau diofyn cwrs';
$string['coursesmovedout'] = 'Cyrsiau wedi\'u symud o {$a}';
$string['coursespending'] = 'Cyrsiau i\'w cymeradwyo';
$string['coursestart'] = 'Cwrs yn cychwyn';
$string['coursesummary'] = 'Crynodeb o\'r cwrs';
$string['coursesummary_help'] = 'Mae crynodeb y cwrs yn ymddangos yn y rhestr o gyrsiau. Wrth chwilio am gyrsiau, bydd yn chwilio drwy enwau cyrsiau a chryndeb y cwrs.';
$string['courseupdates'] = 'Diweddariadau\'r Cwrs';
$string['create'] = 'Creu';
$string['createaccount'] = 'Creu fy nghyfrif newydd';
$string['createcategory'] = 'Creu categori';
$string['createfolder'] = 'Creu ffolder yn {$a}';
$string['createnew'] = 'Creu o\'r newydd';
$string['createnewcategory'] = 'Creu categori newydd';
$string['createnewcourse'] = 'Creu cwrs newydd';
$string['createnewsubcategory'] = 'Creu is-gategori newydd';
$string['createsubcategoryof'] = 'Creu is-gategori {$a}';
$string['createuser'] = 'Creu defnyddiwr';
$string['createuserandpass'] = 'Dewiswch enw defnyddiwr a chyfrinair';
$string['createziparchive'] = 'Creu archif sip';
$string['creatingblocks'] = 'Wrthi\'n creu blociau';
$string['creatingblocksroles'] = 'Wrthi\'n creu proses hepgor a neilltuo swyddogaeth ar lefel bloc';
$string['creatingblogsinfo'] = 'Wrthi\'n creu gwybodaeth am flog';
$string['creatingcategoriesandquestions'] = 'Wrthi\'n creu categoriau a chwestiynau';
$string['creatingcoursemodules'] = 'Wrthi\'n creu modiwlau cwrs';
$string['creatingcourseroles'] = 'Wrthi\'n creu proses hepgor a neilltuo swyddogaeth ar lefel cwrs';
$string['creatingevents'] = 'Wrthi\'n creu digwyddiadau';
$string['creatinggradebook'] = 'Wrthi\'n creu llyfr graddau';
$string['creatinggroupings'] = 'Wrthi\'n creu grwpiau';
$string['creatinggroupingsgroups'] = 'Rhoi grwpiau mewn dosbarthiadau';
$string['creatinggroups'] = 'Wrthi\'n creu grwpiau';
$string['creatinglogentries'] = 'Wrthi\'n creu cofnodion log';
$string['creatingmessagesinfo'] = 'Wrthi\'n creu gwybodaeth negeseuon';
$string['creatingmodroles'] = 'Wrthi\'n creu proses hepgor a neilltuo swyddogaeth ar lefel modiwl';
$string['creatingnewcourse'] = 'Wrthi\'n creu cwrs newydd';
$string['creatingrolesdefinitions'] = 'Wrthi\'n creu diffiniadau o swyddogaethau';
$string['creatingscales'] = 'Wrthu\'n creu graddfeydd';
$string['creatingsections'] = 'Wrthi\'n creu adrannau';
$string['creatingtemporarystructures'] = 'Wrthi\'n creu strwythurau dros dro';
$string['creatinguserroles'] = 'Wrthi\'n creu proses hepgor a neilltuo swyddogaeth ar lefel defnyddiwr';
$string['creatingusers'] = 'Wrthi\'n creu defnyddwyr';
$string['creatingxmlfile'] = 'Wrthi\'n creu ffeil XML';
$string['currency'] = 'Math o Arian';
$string['currentcourse'] = 'Cwrs presennol';
$string['currentcourseadding'] = 'Cwrs presennol, wrthi\'n ychwanegu data ato';
$string['currentcoursedeleting'] = 'Cwrs cyfredol, wrthi\'n ei ddileu yn gyntaf';
$string['currentlanguage'] = 'Iaith ar hyn o bryd';
$string['currentlocaltime'] = 'yr amser lleol ar hyn o bryd';
$string['currentlyselectedusers'] = 'Defnyddwyr sydd wedi\'u dewis ar hyn o bryd';
$string['currentpicture'] = 'Llun presennol';
$string['currentrelease'] = 'Gwybodaeth am y fersiwn sydd wedi\'i rhyddhau ar hyn o bryd';
$string['currentversion'] = 'Fersiwn gyfredol';
$string['databasechecking'] = 'Uwchraddio cronfa ddata Moodle o\'r fersiwn {$a->oldversion} i {$a->newversion}';
$string['databaseperformance'] = 'Perfformiad y gronfa ddata';
$string['databasesetup'] = 'Creu cronfa ddata';
$string['databasesuccess'] = 'Wedi llwyddo i uwchraddio\'r gronfa ddata\'n llwyddiannus';
$string['databaseupgradebackups'] = 'Fersiwn wrth gefn: {$a}';
$string['databaseupgradeblocks'] = 'Fersiwn blociau: {$a}';
$string['databaseupgradegroups'] = 'Fersiwn grwpiau:  {$a}';
$string['databaseupgradelocal'] = 'Fersiwn bersonol o\'r gronfa ddata leol: {$a}';
$string['databaseupgrades'] = 'Wrthi\'n uwchraddio\'r gronfa ddata';
$string['date'] = 'Dyddiad';
$string['datechanged'] = 'Wedi newid y dyddiad';
$string['datemostrecentfirst'] = 'Dyddiad - y mwyaf diweddar yn gyntaf';
$string['datemostrecentlast'] = 'Dyddiad - mwyaf diweddar ddiwethaf';
$string['day'] = 'diwrnod';
$string['days'] = 'dyddiau';
$string['decodinginternallinks'] = 'Wrthi\'n datgodio dolenni mewnol';
$string['default'] = 'Diofyn';
$string['defaultcoursestudent'] = 'Myfyriwr';
$string['defaultcoursestudentdescription'] = 'Yn gyffredinol mae gan myfyrwyr lai o hawliau mewn cwrs.';
$string['defaultcoursestudents'] = 'Myfyrwyr';
$string['defaultcoursesummary'] = 'Ysgrifenwch baragraff cryno a diddorol i esbonio cynnwys y cwrs';
$string['defaultcourseteacher'] = 'Athro';
$string['defaultcourseteacherdescription'] = 'Gall athrawon wneud unrhyw beth mewn cwrs, gan gynnwys newid y gweithgareddau a graddio myfyrwyr.';
$string['defaultcourseteachers'] = 'Athrawon';
$string['defaulteditor'] = 'Golygydd diofyn';
$string['delete'] = 'Dileu';
$string['deleteablock'] = 'Dileu bloc';
$string['deleteall'] = 'Dileu pob un';
$string['deleteallcannotundo'] = 'Dileu pob un - ni ellir dadwneud hyn';
$string['deleteallcomments'] = 'Dileu pob sylw';
$string['deleteallratings'] = 'Dileu pob sgôr';
$string['deletecategory'] = 'Dileu\'r categori: {$a}';
$string['deletecategorycheck'] = 'Ydych chi\'n hollol siŵr eich bod am ddileu\'r categori <b>\'{$a}\'</b> yn llwyr?<br />Bydd gwneud hyn yn symud yr holl gyrsiau i\'r prif gategori os oes un, neu i\'r categori Amrywiol';
$string['deletecategorycheck2'] = 'Os byddwch chi\'n dileu\'r categori hwn, bydd angen i chi ddewis beth i\'w wneud gyda\'r cyrsiau a\'r is-gategorïau sydd ynddo.';
$string['deletecategoryempty'] = 'Mae\'r categori hwn yn wag.';
$string['deletecheck'] = 'Dileu {$a} ?';
$string['deletecheckfiles'] = 'Ydych chi\'n hollol siŵr eich bod am ddileu\'r ffeiliau hyn?';
$string['deletecheckfull'] = 'Ydych chi\'n hollol siŵr eich bod am ddileu {$a} yn llwyr?';
$string['deletechecktype'] = 'Ydych chi\'n siŵr eich bod am ddileu {$a->type}?';
$string['deletechecktypename'] = 'Ydych chi\'n siŵr eich bod am ddileu y {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Rydych chi ar fin dileu\'r ffeiliau hyn';
$string['deletecomment'] = 'Dileu\'r sylw hwn';
$string['deletecompletely'] = 'Dileu yn llwyr';
$string['deletecourse'] = 'Dileu cwrs';
$string['deletecoursecheck'] = 'Ydych chi\'n hollol siŵr eich bod am ddileu\'r cwrs a\'r holl ddata sydd ynddo?';
$string['deleted'] = 'Wedi\'i ddileu';
$string['deletedactivity'] = 'Wedi dileu {$a}';
$string['deletedcourse'] = 'Wedi dileu {$a} yn llwyr';
$string['deletednot'] = 'Heb lwyddo i ddileu {$a} !';
$string['deletelogs'] = 'Dileu\'r logiau';
$string['deleteselected'] = 'Dileu\'r dewis';
$string['deleteselectedkey'] = 'Dileu\'r allwedd a ddewiswyd';
$string['deletingcourse'] = 'Wrthi\'n dileu {$a}';
$string['deletingexistingcoursedata'] = 'Dileu\'r data sy\'n bodoli am y cwrs';
$string['deletingolddata'] = 'Dileu hen ddata';
$string['department'] = 'Adran';
$string['desc'] = 'I lawr';
$string['description'] = 'Disgrifiad';
$string['deselectall'] = 'Dad-dicio pob un';
$string['detailedless'] = 'Llai manwl';
$string['detailedmore'] = 'Mwy manwl';
$string['directory'] = 'Cyfeiriadur';
$string['disable'] = 'Analluogi';
$string['disabledcomments'] = 'Sylwadau wedi\'u hanalluogi';
$string['displayingfirst'] = 'Dim ond y {$a->count} {$a->things} cyntaf sy\'n cael eu dangos';
$string['displayingrecords'] = 'Dangos {$a} cofnod';
$string['displayingusers'] = 'Dangos defnyddwyr rhwng {$a->start} a {$a->end}';
$string['displayonpage'] = 'Dangos ar y dudalen';
$string['dndcourse'] = 'Gallwch lusgo a gollwng y cwrs';
$string['dndenabled_inbox'] = 'Gallwch lusgo a gollwng ffeiliau yma i\'w hychwanegu.';
$string['dndnotsupported'] = 'Does dim modd llwytho y llusgo a gollwng i fyny';
$string['dndnotsupported_help'] = 'Does dim modd i\'ch porwr lwytho y llusgo a gollwng i fyny.<br />Mae\'r nodwedd hon ar gael ym mhob fersiwn diweddar o Chrome, Firefox a Safari, yn ogystal ag Internet Explorer v10 ac uwch.';
$string['dndnotsupported_insentence'] = 'does dim modd llusgo a gollwng';
$string['dnduploadwithoutcontent'] = 'Does gan y lanlwythiad hwn ddim cynnwys';
$string['dndworkingfile'] = 'I lwytho\'r ffeiliau i fyny rhaid eu llusgo a gollwng i adrannau\'r cwrs';
$string['dndworkingfilelink'] = 'I lwytho\'r ffeiliau neu\'r dolenni i fyny rhaid eu llusgo a gollwng i adrannau\'r cwrs';
$string['dndworkingfiletext'] = 'I lwytho\'r ffeiliau neu destun i fyny rhaid eu llusgo a gollwng i adrannau\'r cwrs';
$string['dndworkingfiletextlink'] = 'I lwytho\'r ffeiliau, testun neu ddolenni i fyny rhaid eu llusgo a gollwng i adrannau\'r cwrs';
$string['dndworkinglink'] = 'I lwytho\'r dolenni i fyny rhaid eu llusgo a gollwng i adrannau\'r cwrs';
$string['dndworkingtext'] = 'I lwytho testun i fyny rhaid eu llusgo a gollwng i adrannau\'r cwrs';
$string['dndworkingtextlink'] = 'I lwytho tesun neu ddolenni i fyny rhaid eu llusgo a gollwng i adrannau\'r cwrs';
$string['documentation'] = 'Dogfennaeth Moodle';
$string['dontsortcategories'] = 'Peidiwch â threfnu categorïau';
$string['dontsortcourses'] = 'Peidiwch â threfnu cyrsiau';
$string['down'] = 'I lawr';
$string['download'] = 'Llwytho i lawr';
$string['downloadall'] = 'Llwytho\'r cyfan i lawr';
$string['downloadexcel'] = 'Llwytho i lawr mewn fformat Excel';
$string['downloadfile'] = 'Llwytho\'r ffeil i lawr';
$string['downloadods'] = 'Llwytho i lawr mewn fformat ODS';
$string['downloadtext'] = 'Llwytho i lawr mewn fformat testun';
$string['doyouagree'] = 'Ydych chi wedi darllen a deall yr amodau hyn?';
$string['droptoupload'] = 'Gollyngwch y ffeiliau yma i\'w llwytho i fyny';
$string['duplicate'] = 'Dyblygu';
$string['duplicateconfirm'] = 'Ydych chi\'n siŵr eich bod am ddyblygu {$a->modtype} \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Yn ôl i\'r cwrs';
$string['duplicatecontedit'] = 'Golygu\'r copi newydd';
$string['duplicatesuccess'] = 'Wedi llwyddo i ddyblygu {$a->modtype} \'{$a->modname}\'';
$string['duplicatinga'] = 'Wrthi\'n Dyblygu: {$a}';
$string['edhelpaspellpath'] = 'I wirio sillafu yn y golygydd, RHAID bod gennych <strong>aspell 0.50</strong>, neu fersiwn ddiweddarach, wedi\'i osod ar eich gweinydd a rhaid i chi roi\'r llwybr cywir at y ffeil ddeuaidd aspell. Ar systemau Unix/Linux, fel arfer y llwybr yw <strong>/usr/bin/aspell</strong>, ond gall fod yn llwybr arall.';
$string['edhelpbgcolor'] = 'Dewiswch liw cefndir ar gyfer yr ardal olygu.<br />Dyma\'r gwerthoedd dilys, er enghraifft: #FFFFFF neu wyn';
$string['edhelpcleanword'] = 'Mae\'r gosodiad hwn yn dewis defnyddio neu beidio â defnyddio hidlydd format penodol i Word.';
$string['edhelpenablespelling'] = 'Galluogi neu analluogi\'r gwirydd sillafu. I\'w alluogi, rhaid bod gennych <strong>aspell</strong> ar eich gweinydd. Yr ail werth yw\'r <strong>geiriadur diofyn</strong>. Defnyddir y gwerth hwn os nad oes gan aspell eiriadur ar gyfer iaith y defnyddwyr.';
$string['edhelpfontfamily'] = 'Rhestr o enwau teuluoedd o ffontiau a/neu enwau teuluoedd generig yw\'r briodwedd teulu o ffontiau. Rhaid gwahanu enwau teuluoedd gyda choma.';
$string['edhelpfontlist'] = 'Diffiniwch y ffontiau i\'w defnyddio ar y ddewislen olygu.';
$string['edhelpfontsize'] = 'Mae maint diofyn y llythennau yn pennu maint ffont. <br />Dyma enghreifftiau o werthoedd dilys:  canolig, mawr, llai, mwy, 10pt, 11px.';
$string['edit'] = 'Golygu ';
$string['edita'] = 'Golygu {$a}';
$string['editcategorysettings'] = 'Golygu gosodiadau\'r categori';
$string['editcategorythis'] = 'Golygu\'r categori hwn';
$string['editcoursesettings'] = 'Golgu gosodiadau\'r cwrs';
$string['editfiles'] = 'Golygu ffeiliau';
$string['editgroupprofile'] = 'Golygu proffil y grŵp';
$string['editinga'] = 'Wrthi\'n golygu {$a}';
$string['editingteachershort'] = 'Golygydd';
$string['editlock'] = 'Ni ellir newid y gwerth hwn!';
$string['editmyprofile'] = 'Golygu proffil';
$string['editorbgcolor'] = 'Lliw cefndir';
$string['editorcleanonpaste'] = 'Glanhau Word HTML wrth ludo';
$string['editorcommonsettings'] = 'Gosodiadau cyffredin';
$string['editordefaultfont'] = 'Ffont diofyn';
$string['editorenablespelling'] = 'Galluogi gwirio sillafu';
$string['editorfontlist'] = 'Rhestr ffontiau';
$string['editorfontsize'] = 'Maint diofyn ffont';
$string['editorresettodefaults'] = 'Ailosod i\'r gwerthoedd gwreiddiol';
$string['editorsettings'] = 'Gosodiadau\'r Golygydd';
$string['editorshortcutkeys'] = 'Bysellau hwylus y golygydd';
$string['editsettings'] = 'Golygu\'r gosodiadau';
$string['editsummary'] = 'Golygu\'r crynodeb';
$string['editthisactivity'] = 'Golygu\'r gweithgaredd hwn';
$string['editthiscategory'] = 'Golygu\'r categori hwn';
$string['edittitle'] = 'Golygu\'r teitl';
$string['edittitleinstructions'] = 'Escape i ganslo,
Enter ar ôl gorffen';
$string['edituser'] = 'Golygu cyfrifon defnyddwyr';
$string['email'] = 'Cyfeiriad e-bost';
$string['emailactive'] = 'E-bost wedi cael ei roi ar waith';
$string['emailagain'] = 'E-bost (eto)';
$string['emailalreadysent'] = 'Mae e-bost ailosod cyfrinair eisoes wedi cael ei anfon. Edrychwch ar eich e-byst.';
$string['emailcharset'] = 'Set nodau e-bost';
$string['emailconfirm'] = 'Cadarnhewch eich cyfrif';
$string['emailconfirmation'] = 'Helo {$a->firstname},

Gwnaethpwyd cais drwy eich cyfeiriad e-bost am gyfrif newydd yn \'{$a->sitename}\'.

I gadarnhau\'ch cyfrif newydd, ewch i\'r wefan hon:

{$a->link}

Yn y rhan fwyaf o raglenni e-bost, dylai hwn ymddangos fel dolen las y gellir clicio arni. Os nad yw\'n gweithio, yna gallwch dorri a gludo\'r cyfeiriad i\'r llinell cyfeiriadau ar frig ffenestr eich porwr gwe.

Os oes angen help arnoch, cysylltwch â gweinyddwr y safle,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: cadarnhau\'r cyfrif';
$string['emailconfirmsent'] = '<p>Anfonwyd e-bost i\'ch cyfeiriad <b>{$a}</b></p>
   <p>Mae\'n cynnwys cyfarwyddiadau syml i gwblhau\'ch cofrestriad.</p>
   <p>Os ydych yn parhau i gael trafferthion, yna cysylltwch â gweinyddwr y safle.</p>';
$string['emaildigest'] = 'Dewis Math o E-bost';
$string['emaildigestcomplete'] = 'Cyflawn (e-bost dyddiol gyda phob neges a bostiwyd)';
$string['emaildigest_help'] = 'Dyma\'r gosodiad crynodeb dyddiol y bydd fforymau yn ei ddefnyddio\'n ddiofyn.

* Dim crynodeb - byddwch yn cael un e-bost y neges fforwm;
* Crynodeb - negeseuon llawn - byddwch yn cael un e-bost crynodeb y dydd gyda chynnwys llawn pob neges fforwm;
* Crynodeb - pynciau\'n unig - byddwch yn cael un e-bost crynodeb y dydd yn cynnwys pwnc pob neges fforwm yn unig.

Gallwch hefyd ddewis gosodiadau gwahanol ar gyfer pob fforwm os ydych yn dymuno.';
$string['emaildigestoff'] = 'Heb eu crynhoi (e-bost am bob neges a bostiwyd ar bob fforwm)';
$string['emaildigestsubjects'] = 'Pynciau (e-bost dyddiol fesul pynciau\'n unig)';
$string['emaildisable'] = 'Mae\'r cyfeiriad e-bost hwn wedi\'i analluogi';
$string['emaildisableclick'] = 'Cliciwch yma i analluogi pob neges e-bost a anfonir i\'r cyfeiriad hwn';
$string['emaildisplay'] = 'Dangos E-bost';
$string['emaildisplaycourse'] = 'Dim ond gadael i aelodau eraill y cwrs weld fy nghyfeiriad e-bost';
$string['emaildisplayhidden'] = 'E-bost wedi cuddio';
$string['emaildisplayno'] = 'Cuddio fy nghyfeiriad e-bost rhag pawb';
$string['emaildisplayyes'] = 'Gadael i bawb weld fy nghyfeiriad e-bost';
$string['emailenable'] = 'Mae\'r cyfeiriad e-bost hwn wedi ei alluogi';
$string['emailenableclick'] = 'Cliciwch yma i ail-alluogi pob neges e-bost a anfonir i\'r cyfeiriad hwn';
$string['emailexists'] = 'Mae\'r cyfeiriad e-bost hwn eisoes wedi\'i gofrestru';
$string['emailformat'] = 'Fformat yr e-bost';
$string['emailmustbereal'] = 'Cofiwch: rhaid i\'ch cyfeiriad e-bost fod yn un go-iawn';
$string['emailnotallowed'] = 'Ni chaniateir cyfeiriadau e-bost o\'r parthau hyn ({$a})';
$string['emailnotfound'] = 'Heb ddod o hyd i\'r cyfeiriad e-bost yn y gronfa ddata';
$string['emailonlyallowed'] = 'Ni cheir defnyddio\'r cyfeiriad e-bost hwn({$a})';
$string['emailpasswordchangeinfo'] = 'Helo {$a->firstname},

Mae rhywun (chi fwy na thebyg) wedi gwneud cais am gyfrinair newydd i\'ch cyfrif ar \'{$a->sitename}\'.

I newid eich cyfrinair, ewch i\'r cyfeiriad hwn ar y we:

{$a->link}

Yn y rhan fwyaf o raglenni e-bost, dylai hwn ymddangos fel dolen las y gellir clicio arni. Os nad yw\'n gweithio, yna gallwch dorri a gludo\'r cyfeiriad i\'r llinell cyfeiriadau ar frig ffenestr eich porwr gwe.

Os oes angen help arnoch, cysylltwch â gweinyddwr y safle,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Helo {$a->firstname},

Mae rhywun (chi fwy na thebyg) wedi gwneud cais am gyfrinair newydd i\'ch cyfrif ar \'{$a->sitename}\'.

Yn anffodus, mae eich cyfrif ar y safle hwn wedi\'i analluogi ac ni ellir ei ailosod. Cysylltwch â gweinyddwr y safle,
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Helo {$a->firstname},

Mae rhywun (chi fwy na thebyg) wedi gwneud cais am gyfrinair newydd i\'ch cyfrif ar \'{$a->sitename}\'.

Yn anffodus, nid yw\'n bosib ailosod eich cyfrinair ar y safle hwn.  Cysylltwch â gweinyddwr y safle,
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Newid gwybodaeth cyfrinair';
$string['emailpasswordconfirmation'] = 'Helo {$a->firstname},

Mae rhywun (chi fwy na thebyg) wedi gwneud cais am gyfrinair newydd i\'ch cyfrif ar \'{$a->sitename}\'.

I gadarnhau hyn, ac i dderbyn y cyfrinair newydd drwy e-bost, ewch i\'r wefan:

{$a->link}

Yn y rhan fwyaf o raglenni e-bost, dylai hwn ymddangos fel dolen las y gellir clicio arni. Os nad yw\'n gweithio, yna gallwch dorri a gludo\'r cyfeiriad i\'r llinell cyfeiriadau ar frig ffenestr eich porwr gwe.

Os oes angen help arnoch, cysylltwch â gweinyddwr y safle,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Cadarnhu newid cyfrinair';
$string['emailpasswordconfirmmaybesent'] = '<p>Os roesoch chi enw defnyddiwr neu gyfeiriad cywir, yna dylech fod wedi derbyn e-bost.</p>
   <p>Mae\'n cynnwys cyfarwyddiadau syml i gadarnhau eich bod am newid cyfrinair a sut i wneud hynny.
Os ydych yn parhau i gael trafferth, cysylltwch â gweinyddwr y safle.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Nid oes gan y cyfrif defnyddiwr a wnaethoch ei ddefnyddio gyfeiriad e-bost a gofnodwyd.</p>
<p>Cysylltwch â gweinyddwr y safle.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Dydy manylion y defnyddiwr rydych wedi ei nodi ddim yn adnabod unrhyw gyfrifon defnyddwyr sydd eisoes yn bodoli.</p>
<p>Gwiriwch y wybodaeth a wnaethoch ei nodi, a rhowch gynnig arall arni.
Os ydych chi\'n parhau i gael trafferth, cysylltwch â gweinyddwr y safle.</p>';
$string['emailpasswordconfirmsent'] = 'Dylech chi fod wedi derbyn neges e-bost yn y cyfeiriad <b>{$a}</b>.
<br />Mae\'n cynnwys cyfarwyddiadau syml i gadarnhau eich bod am newid cyfrinair a sut i wneud hynny.
Os ydych yn parhau i gael trafferth, cysylltwch â gweinyddwr y safle.';
$string['emailpasswordsent'] = 'Diolch am gadarnhau bod eich cyfrinair wedi newid.
Anfonwyd e-bost yn cynnwys eich cyfrinair newydd i\'ch cyfeiriad <br /><b>{$a->email}</b>.<br />
Cynhyrchwyd y cyfrinair newydd yn awtomatig - mae\'n syniad i chi
<a href="{$a->link}"> newid eich cyfrinair</a> i rywbeth sy\'n haws ei gofio.';
$string['emailresetconfirmation'] = 'Helo {$a->firstname},

Mae cais i ailosod cyfrinair wedi cael ei wneud ar gyfer eich cyfrif \'{$a->username}\' yn {$a->sitename}.

I gadarnhau\'r cais hwn, ac i osod cyfrinair newydd ar gyfer eich cyfrif, ewch i\'r wefan ganlynol:

{$a->link}
(Mae\'r ddolen hon yn ddilys am {$a->resetminutes} o funudau o\'r amser y cafodd y cais ei wneud)

Os nad chi wnaeth y cais i ailosod cyfrinair, nid oes angen gwneud dim.

Os oes angen help arnoch chi, cysylltwch â gweinyddwr y safle
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Cais i ailosod cyfrinair';
$string['emailresetconfirmsent'] = 'Mae e-bost wedi cael ei anfon i\'ch cyfeiriad yn <b>{$a}</b>. <br />Mae\'n cynnwys cyfarwyddiadau hawdd i gadarnhau a chwblhau\'r broses newid cyfrinair.
Os ydych chi\'n parhau i gael trafferth, cysylltwch â gweinyddwr y safle.';
$string['emptydragdropregion'] = 'ardal wag';
$string['enable'] = 'Galluogi';
$string['encryptedcode'] = 'Cod wedi\'i amgryptio';
$string['english'] = 'Saesneg';
$string['enrolmentmethods'] = 'Dulliau cofrestru';
$string['entercourse'] = 'Cliciwch i fynd i mewn i\'r cwrs hwn';
$string['enteremail'] = 'Rhowch eich cyfeiriad e-bost';
$string['enteremailaddress'] = 'Rhowch eich cyfeiriad e-bost i ailosod eich cyfrinair ac fe anfonir eich cyfrinair newydd atoch drwy\'r e-bost.';
$string['enterusername'] = 'Rhowch eich enw defnyddiwr';
$string['entries'] = 'Cofnodion';
$string['error'] = 'Gwall';
$string['errorcreatingactivity'] = 'Does dim modd creu enghraifft o weithgarwch \'{$a}\'';
$string['errorfiletoobig'] = 'Mae\'r ffeil yn fwy na\'r cyfyngiad o {$a} beit';
$string['errornouploadrepo'] = 'Does dim ystorfa llwytho i fyny wedi\'i galluogi ar gyfer y safle hwn';
$string['errorwhenconfirming'] = 'Nid ydych chi wedi cael eich cadarnhau eto oherwydd digwyddodd gwall. Os gwnaethoch chi glicio ar ddolen mewn e-bost i gyrraedd y fan hon, sicrhewch nad oedd y llinell cyfeiriad yn eich e-bost wedi\'i thorri nac ynghlwm wrth unrhywbeth arall. Efallai y bydd rhaid i chi dorri a gludo er mwyn ailgreu\'r ddolen yn iawn.';
$string['eventcontentviewed'] = 'Wedi gweld y cynnwys';
$string['eventcoursecategorydeleted'] = 'Wedi dileu\'r categori';
$string['eventcoursecontentdeleted'] = 'Wedi dileu cynnwys y cwrs';
$string['eventcoursecreated'] = 'Wedi creu\'r cwrs';
$string['eventcoursedeleted'] = 'Wedi dileu\'r cwrs';
$string['eventcoursemodulecreated'] = 'Wedi creu modiwl y cwrs';
$string['eventcoursemoduledeleted'] = 'Wedi dileu modiwl y cwrs';
$string['eventcoursemoduleupdated'] = 'Wedi diweddaru modiwl y cwrs';
$string['eventcourseresetended'] = 'Wedi gorffen ailosod cwrs';
$string['eventcourseresetstarted'] = 'Wedi cychwyn ailosod cwrs';
$string['eventcourserestored'] = 'Wedi adfer y cwrs';
$string['eventcoursesectionupdated'] = 'Wedi diweddaru adran y cwrs';
$string['eventcourseupdated'] = 'Wedi diweddaru\'r cwrs';
$string['eventusercreated'] = 'Wedi creu defnyddiwr';
$string['eventuserdeleted'] = 'Wedi dileu\'r defnyddiwr';
$string['eventuserlistviewed'] = 'Wedi gweld y rhestr o ddefnyddwyr';
$string['eventuserloggedout'] = 'Mae\'r defnyddiwr wedi allgofnodi';
$string['eventuserprofileviewed'] = 'Wedi gweld proffil y defnyddiwr';
$string['eventuserupdated'] = 'Wedi diweddaru\'r defnyddiwr';
$string['everybody'] = 'Pawb';
$string['executeat'] = 'Gweithredu ar';
$string['existing'] = 'Presennol';
$string['existingadmins'] = 'Gweinyddwyr presennol';
$string['existingcourse'] = 'Cwrs presennol';
$string['existingcourseadding'] = 'Cwrs presennol, wrthi\'n ychwanegu data ato';
$string['existingcoursedeleting'] = 'Cwrs presennol, wrthi\'n ei ddileu yn gyntaf';
$string['existingcreators'] = 'Crewyr y cwrs presennol';
$string['existingstudents'] = 'Myfyrwyr sydd wedi\'u cofrestru';
$string['existingteachers'] = 'Athrawon presennol';
$string['expand'] = 'Ehangu';
$string['expandall'] = 'Ehangu\'r cyfan';
$string['expandcategory'] = 'Ehangu {$a}';
$string['explanation'] = 'Esboniad';
$string['extendenrol'] = 'Ymestyn cyfnod cofrestru (unigol)';
$string['extendperiod'] = 'Cyfnod estynedig';
$string['failedloginattempts'] = 'Ceisiwyd mewngofnodi {$a->attempts} gwaith yn aflwyddiannus ers i chi fewngofnodi diwethaf';
$string['failedloginattemptsall'] = 'Ceisiwyd mewngofnodi {$a->attempts} gwaith yn aflwyddiannus i {$a->accounts} cyfrif';
$string['feedback'] = 'Adborth';
$string['file'] = 'Ffeil';
$string['fileexists'] = 'Mae ffeil o\'r enw {$a} yn bod yn barod';
$string['filemissing'] = '{$a} ar goll';
$string['files'] = 'Ffeiliau';
$string['filesanduploads'] = 'Ffeiliau a lanlwythiadau';
$string['filesfolders'] = 'Ffeiliau/ffolderi';
$string['filetoolarge'] = 'yn rhy fawr i\'w lwytho i fyny';
$string['fileuploadwithcontent'] = 'Ni ddylai ffeiliau sydd wedi\'u llwytho i fyny gynnwys y paramedr cynnwys';
$string['filloutallfields'] = 'Llenwch bob maes yn y ffurflen hon';
$string['filter'] = 'Hidlo';
$string['findmorecourses'] = 'Chwilio am fwy o gyrsiau...';
$string['first'] = 'Cyntaf';
$string['firstaccess'] = 'Mynediad cyntaf';
$string['firstname'] = 'Enw cyntaf';
$string['firstnamephonetic'] = 'Enw cyntaf - ffonetig';
$string['firsttime'] = 'Ai dyma\'ch tro cyntaf yma?';
$string['folder'] = 'Ffolder';
$string['folderclosed'] = 'Ffolder wedi\'i chau';
$string['folderopened'] = 'Ffolder wedi\'i hagor';
$string['followingoptional'] = 'Nid oes rhaid llenwi\'r eitemau canlynol';
$string['followingrequired'] = 'Mae\'n rhaid llenwi\'r eitemau canlynol';
$string['for'] = 'Ar gyfer';
$string['force'] = 'Gorfodi';
$string['forcelanguage'] = 'Gorfodi iaith';
$string['forceno'] = 'Peidio â gorfodi';
$string['forcepasswordchange'] = 'Gorfodi i newid cyfrinair';
$string['forcepasswordchangecheckfull'] = 'Ydych chi\'n hollol siŵr eich bod am orfodi {$a} i newid cyfrinair?';
$string['forcepasswordchange_help'] = 'Os oes tic yn y blwch hwn, caiff y defnyddiwr ei annog i newid ei gyfrinair y tro nesaf y bydd yn mewngofnodi';
$string['forcepasswordchangenot'] = 'Wedi methu gorfodi {$a} i newid cyfriair';
$string['forcepasswordchangenotice'] = 'Rhaid i chi newid eich cyfrinair i fwrw ymlaen.';
$string['forcetheme'] = 'Gorfodi thema';
$string['forgotaccount'] = 'Ydych chi wedi anghofio\'ch cyfrinair?';
$string['forgotten'] = 'Ydych chi wedi anghofio\'ch enw defnyddiwr neu gyfrinair?';
$string['forgottenduplicate'] = 'Mae sawl cyfrif yn rhannu\'r cyfeiriad e-bost, rhowch eich enw defnyddiwr yn lle hynny';
$string['forgotteninvalidurl'] = 'Cyfrinair annilys, ailosod URL';
$string['format'] = 'Fformat';
$string['format_help'] = 'Mae fformat y cwrs yn pennu cynllun tudalen y cwrs. * Fformat SCORM - Ar gyfer arddangos pecyn SCORM yn adran gyntaf tudalen y cwrs (yn lle defnyddio\'r modiwl SCORM/AICC) * Fformat Cymdeithasol - Bydd fforwm yn ymddangos ar dudalen y cwrs * Fformat Pynciau - Mae tudalen y cwrs wedi\'i rhannu\'n bynciau * Fformat Wythnosol - Mae tudalen y cwrs wedi\'i rhannu\'n sesiynau wythnosol, gyda\'r wythnos gyntaf yn cychwyn ar y dyddiad mae\'r cwrs yn cychwyn';
$string['formathtml'] = 'Format HTML';
$string['formatmarkdown'] = 'Fformat Markdown';
$string['formatplain'] = 'Fformat testun plaen';
$string['formattext'] = 'Awto-fformat Moodle';
$string['formattexttype'] = 'Wrthi\'n Fformatio';
$string['framesetinfo'] = 'Mae\'r ddogfen set ffram yn cynnwys:';
$string['from'] = 'Gan';
$string['frontpagecategorycombo'] = 'Rhestr gyfun';
$string['frontpagecategorynames'] = 'Rhestr o\'r categoriau';
$string['frontpagecourselist'] = 'Rhestr o\'r cyrsiau';
$string['frontpagecoursesearch'] = 'Blwch chwilio cwrs';
$string['frontpagedescription'] = 'Crynodeb tudalen flaen';
$string['frontpagedescriptionhelp'] = 'Mae modd i’r crynodeb hwn gael ei ddangos ar y dudalen flaen trwy ddefnyddio bloc crynodeb y cwrs/safle neu trwy gynnwys adran testun ar y dudalen flaen.';
$string['frontpageenrolledcourselist'] = 'Cyrsiau rhestredig';
$string['frontpageformat'] = 'Fformat tudalen flaen';
$string['frontpageformatloggedin'] = 'Fformat tudalen flaen ar ôl mewngofnodi';
$string['frontpagenews'] = 'Eitemau newyddion';
$string['frontpagesettings'] = 'Gosodiadau\'r dudalen flaen';
$string['fulllistofcourses'] = 'Pob Cwrs';
$string['fullname'] = 'Enw llawn';
$string['fullnamecourse'] = 'Enw llawn';
$string['fullnamecourse_help'] = 'Bydd enw llawn y cwrs yn ymddangos ar frig pob tudalen yn y cwrs ac yn y rhestr cyrsiau.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Enw llawn';
$string['fullprofile'] = 'Proffil llawn';
$string['fullsitename'] = 'Enw llawn y safle';
$string['functiondisabled'] = 'Ni ellir defnyddio\'r swyddogaeth hon ar hyn o bryd';
$string['general'] = 'Cyffredinol';
$string['geolocation'] = 'lledred - hydred';
$string['gettheselogs'] = 'Mofyn y logiau hyn';
$string['go'] = 'Mynd';
$string['gpl'] = 'Hawlfraint (C) 1999 ymlaen  Martin Dougiamas  (http://moodle.com)

Mae\'r rhaglen hon yn feddalwedd am ddim; gallwch ei hailddosbarthu a/neu ei haddasu dan delerau Trwydded Gyhoeddus Gyffredinol y GNU fel a gyhoeddwyd gan y Sefydliad Meddalwedd am Ddim; naill ai fersiwn 2 o\'r Drwydded, neu
(os ydych yn dymuno) unrhyw fersiwn hwyrach.

Caiff y rhaglen hon ei dosbarthu gan obeithio y bydd yn ddefnyddiol,
ond HEB UNRHW WARANT; heb hyd yn oed warantiad ymhlyg sy\'n berthnasol i
WERTHADWYEDD nac ADDASRWYDD AT DDIBEN PENODOL.

Gweler gwybodaeth am Drwydded Moodle am y manylion llawn:
http://docs.moodle.org/en/License';
$string['gpl3'] = 'Hawlfraint (C) 1999 ymlaen  Martin Dougiamas  (http://moodle.com)
Mae\'r rhaglen hon yn feddalwedd am ddim; gallwch ei hailddosbarthu a/neu ei haddasu dan delerau Trwydded Gyhoeddus Gyffredinol y GNU fel a gyhoeddwyd gan y Sefydliad Meddalwedd am Ddim; naill ai fersiwn 3 o\'r Drwydded, neu
(os ydych yn dymuno) unrhyw fersiwn hwyrach.
Caiff y rhaglen hon ei dosbarthu gan obeithio y bydd yn ddefnyddiol,
ond HEB UNRHW WARANT; heb hyd yn oed warantiad ymhlyg sy\'n berthnasol i
WERTHADWYEDD nac ADDASRWYDD AT DDIBEN PENODOL.
Gweler gwybodaeth am Drwydded Moodle am y manylion llawn:
http://docs.moodle.org/en/License';
$string['gpllicense'] = 'Trwydded GPL';
$string['grade'] = 'Gradd';
$string['grades'] = 'Graddau';
$string['gravatarenabled'] = 'Mae <a href="http://www.gravatar.com/">Gravatar</a> wedi\'i alluogi ar gyfer y safle hwn. Os na wnewch chi lwytho llun proffil i fyny, bydd Moodle yn ceisio llwytho eich llun proffil o Gravatar.';
$string['group'] = 'Grŵp';
$string['groupadd'] = 'Ychwanegu grŵp newydd';
$string['groupaddusers'] = 'Ychwanegu\'r hyn a ddewiswyd at y grŵp';
$string['groupextendenrol'] = 'Ymestyn y cyfnod cofrestru (cyffredin)';
$string['groupfor'] = 'ar gyfer grŵp';
$string['groupinfo'] = 'Gwybodaeth am y grŵp a ddewiswyd';
$string['groupinfoedit'] = 'Golygu gosodiadau\'r grŵp';
$string['groupinfomembers'] = 'Gwybodaeth am yr aelodau a ddewiswyd';
$string['groupinfopeople'] = 'Gwybodaeth am y bobl a ddewiswyd';
$string['groupmembers'] = 'Aelodau\'r grŵp';
$string['groupmemberssee'] = 'Gweld aelodau\'r grŵp';
$string['groupmembersselected'] = 'Aelodau\'r grŵp a ddewiswyd';
$string['groupmode'] = 'Modd grŵp';
$string['groupmodeforce'] = 'Gorfodi\'r modd grŵp';
$string['groupmy'] = 'Fy ngrŵp i';
$string['groupnonmembers'] = 'Pobl nad ydynt mewn grŵp';
$string['groupnotamember'] = 'Mae\'n flin gennyf, nid ydych yn aelod o\'r grŵp hwn';
$string['grouprandomassign'] = 'Neilltuo\'r cwbl ar hap i grwpiau';
$string['groupremove'] = 'Tynnu\'r grŵp a ddewiswyd';
$string['groupremovemembers'] = 'Tynnu\'r aelodau a ddewiswyd';
$string['groups'] = 'Grwpiau';
$string['groupsnone'] = 'Dim grwpiau';
$string['groupsseparate'] = 'Grwpiau ar wahân';
$string['groupsvisible'] = 'Grwpiau gweledol';
$string['guest'] = 'Gwestai';
$string['guestdescription'] = 'Ychydig o freintiau sydd gan westeion ac ni allant roi testun i mewn yn unman fel arfer.';
$string['guestskey'] = 'Caniatáu ymwelwyr sydd ag allwedd';
$string['guestsno'] = 'Peidio â gadael ymwelwyr i mewn';
$string['guestsnotallowed'] = 'Mae\'n flin gennyf, nid yw \'{$a}\' yn gadael gwesteion i mewn.';
$string['guestsyes'] = 'Caniatáu ymwelwyr heb yr allwedd';
$string['guestuser'] = 'Gwestai';
$string['guestuserinfo'] = 'Mae\'r defnyddiwr hwn yn ddefnyddiwr arbennig sy\'n caniatáu mynediad darllen yn unig i rai cyrsiau.';
$string['help'] = 'Help';
$string['helpprefix2'] = 'Help gyda {$a}';
$string['helpwiththis'] = 'Help gyda hyn';
$string['hiddenassign'] = 'Aseiniad cudd';
$string['hiddenfromstudents'] = 'Wedi\'i guddio rhag myfyrwyr';
$string['hiddensections'] = 'Adrannau cudd';
$string['hiddensectionscollapsed'] = 'Adrannau cudd yn ymddangos wedi\'u cywasgu';
$string['hiddensections_help'] = 'Y gosodiad hwn sy\'n pennu a yw\'r adrannau cudd yn ymddangos wedi\'u crebachu (efallai ar gyfer cwrs gyda fformat wythnosol er mwyn dangos gwyliau) ynteu a ydynt yn cael eu cuddio\'n llwyr.';
$string['hiddensectionsinvisible'] = 'Mae\'r adrannau cudd wedi\'u cuddio\'n llwyr';
$string['hide'] = 'Cuddio';
$string['hideadvancedsettings'] = 'Cuddio mwy o osodiadau';
$string['hidepicture'] = 'Cuddio\'r Llun';
$string['hidesection'] = 'Cuddio\'r adran {$a}';
$string['hidesettings'] = 'Cuddio\'r gosodiadau';
$string['hideshowblocks'] = 'Cuddio neu ddangos blociau';
$string['hits'] = 'Ymweliadau';
$string['hitsoncourse'] = 'Nifer yr ymweliadau ar {$a->coursename} gan {$a->username}';
$string['hitsoncoursetoday'] = 'Ymweliadau heddiw ar {$a->coursename} gan {$a->username}';
$string['home'] = 'Hafan';
$string['hour'] = 'awr';
$string['hours'] = 'oriau';
$string['howtomakethemes'] = 'Sut i wneud themâu newydd';
$string['htmleditor'] = 'Defnyddio\'r golygydd HTML';
$string['htmleditoravailable'] = 'Mae\'r golygydd HTML ar gael';
$string['htmleditordisabled'] = 'Rydych chi wedi analluogi\'r golygydd HTML yn eich proffil defnyddiwr';
$string['htmleditordisabledadmin'] = 'Mae\'r gweinyddwr wedi analluogi\'r golygydd HTML ar y safle hwn';
$string['htmleditordisabledbrowser'] = 'Nid yw\'r golygydd HTML ar gael oherwydd nid yw eich porwr gwe yn  gydnaws';
$string['htmlfilesonly'] = 'Ffeiliau HTML yn unig';
$string['htmlformat'] = 'Fformat HTML hardd';
$string['icon'] = 'Eicon';
$string['icqnumber'] = 'Rhif ICQ';
$string['idnumber'] = 'Rhif Adnabod (ID)';
$string['idnumbercourse'] = 'Rhif ID y cwrs';
$string['idnumbercoursecategory'] = 'Rhif ID categori';
$string['idnumbercoursecategory_help'] = 'Caiff rhif ID categori cwrs ei ddefnyddio i baru\'r categori â systemau allanol ac ni chaiff ei ddangos yn unman ar y safle. Os oes gan y categori enw cod swyddogol, gallwch roi\'r enw hwnnw; fel arall gallwch adael y maes yn wag.';
$string['idnumbercourse_help'] = 'Dim ond wrth gyfateb y cwrs â systemau allanol y defnyddir rhif ID cwrs, ac nid yw\'n cael ei ddangos yn unman ar y safle. Os oes gan y cwrs god swyddogol, gellir ei nodi, ond fel arall gellir gadael y maes yn wag.';
$string['idnumbergroup'] = 'Rhif ID y grŵp';
$string['idnumbergroup_help'] = 'Dim ond wrth gyfateb y grŵp yn erbyn y system allanol y bydd rhif ID grŵp yn cael ei ddefnyddio ac nid yw’n cael ei ddangos yn unrhyw le arall ar y safle. Os oes gan y grŵp enw cod swyddogol efallai y bydd angen ei nodi, fel arall gallwch adael y maes yn wag.';
$string['idnumbergrouping'] = 'Rhif ID y dosbarthiad';
$string['idnumbergrouping_help'] = 'Dim ond wrth gyfateb y dosbarthiad yn erbyn y system allanol y bydd rhif ID y dosbarthiad yn cael ei ddefnyddio ac nid yw’n cael ei ddangos yn unrhyw le arall ar y safle. Os oes gan y dosbarthiad enw cod swyddogol efallai y bydd angen ei nodi, fel arall gallwch adael y maes yn wag.';
$string['idnumbermod'] = 'Rhif ID';
$string['idnumbermod_help'] = 'Mae gosod rhif ID yn ffordd o ddynodi\'r gweithgaredd at ddibenion cyfrifo graddau. Os nad yw\'r gweithgaredd wedi\'i gynnwys yn unrhyw gyfrifiad ar gyfer gradd, gellir gadael y maes rhif ID yn wag.

Gellir gosod y rhif ID yn y llyfr graddau hefyd, ond dim ond ar y dudalen gosodiadau gweithgareddau y gellir ei olygu.';
$string['idnumbertaken'] = 'Mae\'r rhif ID hwn eisoes yn cael ei ddefnyddio';
$string['imagealt'] = 'Disgrifiad o\'r llun';
$string['import'] = 'Mewngludo';
$string['importdata'] = 'Mewngludo data cwrs';
$string['importdataexported'] = 'Wedi allgludo data o\'r cwrs \'o\' yn llwyddiannus.<br /> Bwrw ymlaen i mewngludo i\'r cwrs \'i\'.';
$string['importdatafinished'] = 'Wedi gorffen mewngludo! Bwrw ymlaen i\'ch cwrs';
$string['importdatafrom'] = 'Chwilio am gwrs ar gyfer mewngludo data:';
$string['inactive'] = 'Anweithredol';
$string['include'] = 'Cynnwys';
$string['includeallusers'] = 'Cynnwys Pob Defnyddiwr';
$string['includecoursefiles'] = 'Cynnwys Ffeiliau\'r Cwrs';
$string['includecourseusers'] = 'Cynnwys Defnyddwyr y Cwrs';
$string['included'] = 'Yn gynwysedig';
$string['includelogentries'] = 'Cynnwys Cofnodion Log';
$string['includemodules'] = 'Cynnwys Modiwlau';
$string['includemoduleuserdata'] = 'Cynnwys data defnyddiwr y modiwl';
$string['includeneededusers'] = 'Cynnwys y Defnyddwyr sydd eu Hangen';
$string['includenoneusers'] = 'Cynnwys Dim Defnyddwyr';
$string['includeroleassignments'] = 'Cynnwys y swyddogaethau a neilltuwyd';
$string['includesitefiles'] = 'Cynnwys ffeiliau safle a ddefnyddir yn y cwrs hwn';
$string['includeuserfiles'] = 'Cynnwys Ffeiliau Defnyddiwr';
$string['increasesections'] = 'Cynyddu\'r nifer o adrannau';
$string['info'] = 'Gwybodaeth';
$string['institution'] = 'Sefydliad';
$string['instudentview'] = 'yng nghynllun myfyrwyr';
$string['interests'] = 'Diddordebau';
$string['interestslist'] = 'Rhestr diddordebau';
$string['interestslist_help'] = 'Rhowch eich diddordebau gan ddefnyddio coma i\'w gwahanu. Bydd eich diddordebau i\'w gweld ar eich tudalen broffil fel tagiau.';
$string['invalidemail'] = 'Cyfeiriad e-bost annilys';
$string['invalidlogin'] = 'Manylion mewngofnodi annilys, rhowch gynnig arall arni';
$string['invalidusername'] = 'Dim ond rhifau a llythrennau bach, tanlinell (_), cysylltnod (-), atalnod llawn (.) neu symbol @ y gellir eu cynnwys yn yr enw defnyddiwr';
$string['invalidusernameupload'] = 'Enw defnyddiwr annilys';
$string['ip_address'] = 'Cyfeiriad IP';
$string['jump'] = 'Neidio';
$string['jumpto'] = 'Neidio i...';
$string['keep'] = 'Dal ati';
$string['keepsearching'] = 'Dal ati i chwilio';
$string['langltr'] = 'Cyfeiriad iaith o\'r chwith-i\'r-dde';
$string['langrtl'] = 'Cyfeiriad iaith o\'r dde i\'r chwith';
$string['language'] = 'Iaith';
$string['languagegood'] = 'Mae\'r pecyn iaith hwn wedi ei ddiweddaru! :-)';
$string['last'] = 'Diwethaf';
$string['lastaccess'] = 'Mynediad diwethaf';
$string['lastedited'] = 'Golygwyd ddiwethaf';
$string['lastlogin'] = 'Mewngofnodwyd diwethaf';
$string['lastmodified'] = 'Diweddarwyd diwethaf';
$string['lastname'] = 'Cyfenw';
$string['lastnamephonetic'] = 'Cyfenw - ffonetig';
$string['lastyear'] = 'Y llynedd';
$string['latestlanguagepack'] = 'Chwilio am becyn iaith moodle.org mwy diweddar';
$string['layouttable'] = 'Tablau cynllun';
$string['leavetokeep'] = 'Gadewch yn wag i gadw\'r cyfrinair cyfredol';
$string['legacythemeinuse'] = 'Rydych yn gweld y safle hwn mewn modd cydnawsedd gan fod eich porwr yn rhy hen.';
$string['license'] = 'Trwydded';
$string['licenses'] = 'Trwyddedau';
$string['liketologin'] = 'Ydych chi am fewngofnodi nawr gyda chyfrif defnyddiwr llawn?';
$string['list'] = 'Rhestr';
$string['listfiles'] = 'Rhestr o\'r ffeiliau yn {$a}';
$string['listofallpeople'] = 'Rhestr o\'r holl bobl';
$string['listofcourses'] = 'Rhestr o gyrsiau';
$string['loadinghelp'] = 'Wrthi\'n llwytho...';
$string['local'] = 'Lleol';
$string['localplugins'] = 'Ategion lleol';
$string['localpluginsmanage'] = 'Rheoli\'r ategion lleol';
$string['location'] = 'Lleoliad';
$string['log_excel_date_format'] = 'bbbb mmmm d a:mm';
$string['loggedinas'] = 'Rydych chi wedi mewngofnodi fel {$a}';
$string['loggedinasguest'] = 'Rydych chi\'n westai ar hyn o bryd';
$string['loggedinnot'] = 'Nid ydych chi wedi mewngofnodi';
$string['login'] = 'Mewngofnodi';
$string['loginalready'] = 'Rydych chi eisoes wedi mewngofnodi';
$string['loginas'] = 'Mewngofnodi fel';
$string['loginaspasswordexplain'] = '<p>Rhaid i chi roi\'r "cyfrinair mewngofnodi fel ..." i ddefnyddio\'r nodwedd hon.<br />Os nad ydych chi\'n ei wybod, gofynnwch i weinyddwr eich gweinydd.</p>';
$string['login_failure_logs'] = 'Logiau methu mewngofnodi';
$string['loginguest'] = 'Mewngofnodi fel ymwelydd';
$string['loginsite'] = 'Mewngofnodi i\'r safle';
$string['loginsteps'] = 'Helo! I gael mynediad llawn i\'r cyrsiau bydd angen i chi gymryd
   munud neu ddau i greu cyfrif newydd i chi\'ch hun ar y wefan hon.
   Mae\'n bosib y bydd angen "allwedd cofrestru" arnoch i gofrestru am y tro cyntaf yn unig. Dyma\'r camau:
   <ol>
   <li>Llenwch eich manylion ar y ffurflen <a href="{$a}">Cyfrif Newydd</a>.</li>
   <li>Anfonir e-bost i\'ch cyfeiriad e-bost ar unwaith.</li>
   <li>Darllenwch yr e-bost a chlicio ar y ddolen i\'r we yn y neges.</li>
   <li>Caiff eich cyfrif ei gadarnhau a byddwch wedi mewngofnodi.</li>
   <li>Nawr, dewiswch y cwrs yr ydych am gymryd rhan ynddo.</li>
   <li>Os gofynnir i chi roi "allwedd cofrestru" - rhowch yr un
   a gawsoch gan eich athro. Bydd hyn yn eich "cofrestru" ar y cwrs.</li>
   <li>Nawr gallwch gael gweld y cwrs cyfan. O hyn ymlaen dim ond eich
   enw defnyddiwr a\'ch cyfriair personol fydd eu hangen arnoch (ar y ffurflen ar y dudalen hon)
   i fewngofnodi a chael gweld unrhyw gyrsiau yr ydych wedi cofrestru arnynt.</li>
   </ol>';
$string['loginstepsnone'] = '<p>Helo!</p>
<p>I gael mynediad llawn i\'ch cyrsiau bydd angen i chi greu cyfrif.</p>
<p>Yr oll sydd ei angen arnoch yw creu enw defnyddiwr a chyfrinair a\'u defnyddio ar y dudalen hon!</p>
<p>Os oes rhywun arall eisoes wedi bachu eich enw defnyddiwr bydd rhaid i chi roi cynnig arall arni gydag enw defnyddiwr arall.</p>';
$string['loginto'] = 'Mewngofnodi i {$a}';
$string['logout'] = 'Allgofnodi';
$string['logoutconfirm'] = 'Ydych chi\'n siŵr eich bod am allgofnodi?';
$string['logs'] = 'Logiau';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">more</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">more</a> ]';
$string['lookback'] = 'Edrych yn ôl';
$string['mailadmins'] = 'Hysbysu gweinyddwyr';
$string['mailstudents'] = 'Hysbysu myfyrwyr';
$string['mailteachers'] = 'Hysbysu athrawon';
$string['maincoursepage'] = 'Prif dudalen y cwrs';
$string['makeafolder'] = 'Creu ffolder';
$string['makeeditable'] = 'Os ydych chi\'n galluogi proses gweinydd y we (ee apache) i olygu \'{$a}\' yna gallech olygu\'r ffeil hon yn uniongyrchol o\'r dudalen hon';
$string['makethismyhome'] = 'Gwneud hon yn dudalen hafan diofyn';
$string['manageblocks'] = 'Blociau';
$string['managecategorythis'] = 'Rheoli\'r categori hwn';
$string['managecourses'] = 'Rheoli Cyrsiau';
$string['managedatabase'] = 'Cronfa ddata';
$string['manageeditorfiles'] = 'Rheoli ffeiliau sy\'n cael eu defnyddio gan y golygydd';
$string['managefilters'] = 'Ffilteri';
$string['managemodules'] = 'Modiwlau';
$string['manageroles'] = 'Swyddogaethau a chaniatadau';
$string['markedthistopic'] = 'Wedi lliwio\'r testun hwn fel y testun cyfredol';
$string['markthistopic'] = 'Lliwio\'r testun hwn fel y testun cyfredol';
$string['matchingsearchandrole'] = 'Wrthi\'n cyfateb \'{$a->search}\' a {$a->role}';
$string['maxareabytesreached'] = 'Mae\'r ffeil (neu gyfanswm maint sawl ffeil) yn fwy na\'r lle gwag sydd ar gael yn yr adran hon.';
$string['maxbytesforfile'] = 'Mae\'r ffeil (neu gyfanswm maint sawl ffeil) yn fwy na\'r lle gwag sydd ar gael yn yr adran hon.';
$string['maxfilesize'] = 'Maint mwyaf ar gyfer ffeiliau newydd: {$a}';
$string['maxfilesreached'] = 'Fe gewch chi atodi uchafswm o {$a} o ffeil(iau) at yr eitem hon';
$string['maximumchars'] = 'Nifer fwyaf o lythrennau: {$a}';
$string['maximumgrade'] = 'Gradd uchaf bosibl';
$string['maximumgradex'] = 'Gradd uchaf bosib: {$a}';
$string['maximumshort'] = 'Mwyaf';
$string['maximumupload'] = 'Maint mwyaf y gellir ei lwytho i fyny';
$string['maximumupload_help'] = 'Y gosodiad hwn sy\'n pennu maint mwyaf y ffeiliau y gellir eu llwytho i fyny i\'r cwrs, ond mae gosodiad y safle cyfan, a bennwyd gan y gweinyddwr, yn cyfyngu ar y maint hwn. Mae modiwlau Gweithgareddau hefyd yn cynnwys gosodiad ar gyfer maint mwyaf ffeiliau a bydd hynny\'n cyfyngu ymhellach ar faint y ffeil.';
$string['maxnumberweeks'] = 'Uchafswm y nifer o adrannau';
$string['maxnumberweeks_desc'] = 'Y gwerth mwyaf yng nghwymplen y nifer o adrannau (yn berthnasol i rai fformatau cwrs yn unig).';
$string['maxnumcoursesincombo'] = 'Pori <a href="{$a->link}">{$a->numberofcourses} cwrs</a>.';
$string['maxsize'] = 'Maint mwyaf: {$a}';
$string['maxsizeandareasize'] = 'Uchafswm maint ar gyfer ffeiliau newydd: {$a->size}, y terfyn cyffredinol: {$a->areasize}';
$string['maxsizeandattachments'] = 'Uchafswm maint ar gyfer ffeiliau newydd: {$a->size}, y nifer mwyaf o atodiadau: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Uchafswm maint ar gyfer ffeiliau newydd: {$a->size}, y nifer mwyaf o atodiadau: {$a->attachments}, y terfyn cyffredinol: {$a->areasize}';
$string['memberincourse'] = 'Pobl ar y cwrs';
$string['messagebody'] = 'Corff y neges';
$string['messagedselectedusers'] = 'Mae negeseuon wedi\'i gyrru i rai defnyddwyr ac mae\'r rhestr o dderbynwyr wedi\'i ailosod';
$string['messagedselectedusersfailed'] = 'Mi aeth rhywbeth o\'i le wrth yrru neges i ddefnyddwyr dewisol. Efallai bod rhai ohonynt wedi derbyn yr e-bost.';
$string['messageprovider:availableupdate'] = 'Hysbysiadau diweddariadau sydd ar gael';
$string['messageprovider:backup'] = 'Hysbysiadau copi wrth gefn';
$string['messageprovider:badgecreatornotice'] = 'Hysbysiadau crëwr bathodynnau';
$string['messageprovider:badgerecipientnotice'] = 'Hysbysiadau derbynnydd bathodynnau';
$string['messageprovider:courserequestapproved'] = 'Hysbysiad cymeradwyo cais i greu cwrs';
$string['messageprovider:courserequested'] = 'Hysbysiad cais i greu cwrs';
$string['messageprovider:courserequestrejected'] = 'Hysbysiad gwrthod cais i greu cwrs';
$string['messageprovider:errors'] = 'Gwallau pwysig yn y safle';
$string['messageprovider:errors_help'] = 'Mae\'r rhain yn wallau pwysig y dylai gweinyddwr wybod amdanynt.';
$string['messageprovider:instantmessage'] = 'Negeseuon personol rhwng defnyddwyr';
$string['messageprovider:instantmessage_help'] = 'Mae\'r adran hon yn ffurfweddu beth sy\'n digwydd i negeseuon sy\'n cael eu hanfon yn uniongyrchol atoch chi gan ddefnyddwyr eraill ar y safle hwn.';
$string['messageprovider:notices'] = 'Hysbysiadau am fân broblemau';
$string['messageprovider:notices_help'] = 'Mae\'r rhain yn hysbysiadau y gallai gweinyddwr fod â diddordeb ynddynt.';
$string['messageselect'] = 'Dewis y defnyddiwr hwn fel derbynnydd e-bost';
$string['messageselectadd'] = 'Ychwanegu / anfon neges';
$string['middlename'] = 'Enw canol';
$string['migratinggrades'] = 'Wrthi\'n mudo graddau';
$string['min'] = 'isaf';
$string['mins'] = 'munudau';
$string['minute'] = 'munud';
$string['minutes'] = 'munudau';
$string['miscellaneous'] = 'Amrywiol';
$string['missingcategory'] = 'Efallai bod angen i chi ddewis categori';
$string['missingcity'] = 'Dinas/tref ar goll';
$string['missingcountry'] = 'Gwlad ar goll';
$string['missingdescription'] = 'Disgrifiad ar goll';
$string['missingemail'] = 'Cyfeiriad e-bost ar goll';
$string['missingfirstname'] = 'Enw cyntaf ar goll';
$string['missingfromdisk'] = 'Ar goll o\'r ddisg';
$string['missingfullname'] = 'Enw llawn ar goll';
$string['missinglastname'] = 'Cyfenw ar goll';
$string['missingname'] = 'Enw ar goll';
$string['missingnewpassword'] = 'Cyfrinair newydd ar goll';
$string['missingpassword'] = 'Cyfrinair ar goll';
$string['missingrecaptchachallengefield'] = 'Maes sialens reCAPTCHA ar goll';
$string['missingreqreason'] = 'Rheswm ar goll';
$string['missingshortname'] = 'Enw byr ar goll';
$string['missingshortsitename'] = 'Enw byr y safle ar goll';
$string['missingsitedescription'] = 'Disgrifiad safle ar goll';
$string['missingsitename'] = 'Enw safle ar goll';
$string['missingstrings'] = 'Chwilio am eiriau neu frawddegau sydd heb eu cyfieithu';
$string['missingstudent'] = 'Rhaid dewis rhywbeth';
$string['missingsummary'] = 'Crynodeb ar goll';
$string['missingteacher'] = 'Mae\'n rhaid dewis rhywbeth';
$string['missingurl'] = 'URL ar goll';
$string['missingusername'] = 'Enw defnyddiwr ar goll';
$string['modchooserdisable'] = 'Dewiswr gweithgaredd wedi\'i ddiffodd';
$string['modchooserenable'] = 'Dewiswr gweithgaredd ymlaen';
$string['moddoesnotsupporttype'] = 'Dydy\'r modiwl {$a->modname} ddim yn cefnogi llwytho i fyny o fath {$a->type}';
$string['modified'] = 'Addaswyd';
$string['moduleintro'] = 'Disgrifiad';
$string['modulesetup'] = 'Gosod tablau modiwl';
$string['modulesuccess'] = 'Wedi gosod {$a} tabl yn iawn';
$string['modulesused'] = 'Modiwlau a ddefnyddiwyd';
$string['month'] = 'Mis';
$string['months'] = 'Misoedd';
$string['moodledocs'] = 'Dogfennau Moodle';
$string['moodledocslink'] = 'Dogfennau Moodle ar gyfer y dudalen hon';
$string['moodlerelease'] = 'Fersiwn Moodle';
$string['moodleversion'] = 'Fersiwn Moodle';
$string['more'] = 'mwy';
$string['morehelp'] = 'Mwy o help';
$string['moreinformation'] = 'Mwy o wybodaeth am y gwall hwn';
$string['moreprofileinfoneeded'] = 'Rhowch fwy o wybodaeth i ni amdanoch eich hun';
$string['mostrecently'] = 'mwyaf diweddar';
$string['move'] = 'Symud';
$string['movecategoriessuccess'] = 'Wedi llwyddo i symud {$a->count} o gategorïau i gategori \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Wedi llwyddo i symud {$a->count} o gategorïau i\'r lefel uchaf';
$string['movecategorycontentto'] = 'Symud i';
$string['movecategorysuccess'] = 'Wedi llwyddo i symud categori \'{$a->moved}\' i gategori \'{$a->to}\'';
$string['movecategoryto'] = 'Symud categori i:';
$string['movecategorytotopsuccess'] = 'Wedi llwyddo i symud categori \'{$a->moved}\' i\'r lefel uchaf';
$string['movecontent'] = 'Symud {$a}';
$string['movecontentstoanothercategory'] = 'Symud cynnwys i gategori arall';
$string['movecoursemodule'] = 'Symud adnodd';
$string['movecoursesection'] = 'Symud adran';
$string['movecourseto'] = 'Symud y cwrs i:';
$string['movedown'] = 'Symud i lawr';
$string['movefilestohere'] = 'Symud ffeiliau yma';
$string['movefull'] = 'Symud {$a} i\'r lleoliad hwn';
$string['movehere'] = 'Symud yma';
$string['moveleft'] = 'Symud i\'r chwith';
$string['moveright'] = 'Symud i\'r dde';
$string['movesection'] = 'Symud adran {$a}';
$string['moveselectedcategoriesto'] = 'Symud y categorïau a ddewiswyd i';
$string['moveselectedcoursesto'] = 'Symud y cyrsiau a ddewiswyd i...';
$string['movetoanotherfolder'] = 'Symud i ffolder arall';
$string['moveup'] = 'Symud i fyny';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Rhaid i\'r cyfrinair newydd fod yn wahanol i\'r un presennol';
$string['mustconfirm'] = 'Mae angen i chi gadarnhau eich manylion mewngofnodi';
$string['mycourses'] = 'Fy nghyrsiau';
$string['myfiles'] = 'Fy ffeiliau preifat';
$string['myfilesmanage'] = 'Rheoli fy ffeiliau preifat';
$string['myhome'] = 'Fy hafan';
$string['mymoodledashboard'] = 'Hysbysfwrdd Moodle Personol';
$string['myprofile'] = 'Fy mhroffil';
$string['name'] = 'Enw';
$string['nameforlink'] = 'Pa enw ydych chi eisiau ei roi i\'r ddolen hon?';
$string['nameforpage'] = 'Enw';
$string['navigation'] = 'Llywio';
$string['needed'] = 'Ei angen';
$string['never'] = 'Byth';
$string['neverdeletelogs'] = 'Peidiwch byth â dileu logiau';
$string['new'] = 'Newydd';
$string['newaccount'] = 'Cyfrif Newydd';
$string['newcourse'] = 'Cwrs newydd';
$string['newpassword'] = 'Cyfrinair newydd';
$string['newpasswordfromlost'] = '<strong>NODYN:</strong> Dylech fod wedi derbyn eich <strong>Cyfrinair Cyfredol</strong> yn yr <strong>ail</strong> e-bost a anfonwyd atoch fel rhan o\'r broses adfer cyfrinair coll. Gwnewch yn siŵr eich bod wedi derbyn eich cyfrinair newydd cyn bwrw ymlaen.';
$string['newpassword_help'] = 'Rhowch gyfrinair newydd neu gadewch yn wag i gadw\'r cyfrinair presennol.';
$string['newpasswordtext'] = 'Helo {$a->firstname},

Mae cyfrinair eich cyfrif yn \'{$a->sitename}\' wedi cael ei ailosod
a rhoddwyd cyfrinair newydd dros dro i chi.

Dyma\'ch gwybodaeth mewngofnodi newydd:
   enw defnyddiwr: {$a->username}
   cyfrinair: {$a->newpassword}

Ewch i\'r dudalen hon i newid eich cyfrinair:
   {$a->link}

Yn y rhan fwyaf o raglenni e-bost, dylai hwn ymddangos fel dolen las
y gallwch glicio arni. Os nad yw hynny\'n gweithio,
gallwch dorri a gludo\'r cyfeiriad i\'r llinell cyfeiriad
ar frig ffenestr eich porwr gwe.

Pob hwyl. Gweinyddwr \'{$a->sitename}\' ,
{$a->signoff}';
$string['newpicture'] = 'Llun newydd';
$string['newpicture_help'] = 'I ychwanegu llun newydd, dewiswch lun (mewn fformat JPG neu PNG) a chlicio "Diweddaru\'r proffil". Bydd y llun yn cael ei docio nes ei fod yn sgwâr 100x100 picsel.';
$string['newsitem'] = 'eitem newyddion';
$string['newsitems'] = 'eitemau newyddion';
$string['newsitemsnumber'] = 'Eitemau newyddion i\'w dangos';
$string['newsitemsnumber_help'] = 'Y gosodiad hwn sy\'n pennu faint o eitemau diweddar sy\'n ymddangos yn y bloc newyddion diweddaraf ar dudalen y cwrs. Os yw wedi\'i osod ar "0 eitem newyddion", ni fydd y bloc newyddion diweddaraf yn ymddangos.';
$string['newuser'] = 'Defnyddiwr newydd';
$string['newusernewpasswordsubj'] = 'Cyfrif defnyddiwr newydd';
$string['newusernewpasswordtext'] = 'Helo {$a->firstname},

Mae cyfrif newydd wedi\'i greu ar eich cyfer yn \'{$a->sitename}\'
ac rydych wedi cael cyfrinair newydd dros dro.

Dyma\'ch gwybodaeth mewngofnodi newydd:
   enw defnyddiwr: {$a->username}
   cyfrinair: {$a->newpassword}
             (bydd angen i chi newid eich cyfrinair
              pan fyddwch yn mewngofnodi am y tro cyntaf)

I ddechrau defnyddio \'{$a->sitename}\', dylech fewngofnodi yn
   {$a->link}

Yn y rhan fwyaf o raglenni e-bost, dylai hwn ymddangos fel dolen las
y gallwch glicio arni. Os nad yw hynny\'n gweithio,
gallwch dorri a gludo\'r cyfeiriad i\'r llinell cyfeiriad
ar frig ffenestr eich porwr gwe.

Pob hwyl. Gweinyddwr \'{$a->sitename}\',
{$a->signoff}';
$string['newusers'] = 'Defnyddwyr newydd';
$string['newwindow'] = 'ffenestr newydd';
$string['next'] = 'Nesaf';
$string['nextsection'] = 'Adran nesaf';
$string['no'] = 'Na';
$string['noblockstoaddhere'] = 'Does dim blociau y gallwch chi eu hychwanegu at y dudalen hon.';
$string['nobody'] = 'Neb';
$string['nochange'] = 'Dim newid';
$string['nocomments'] = 'Dim sylwadau';
$string['nocourses'] = 'Dim cyrsiau';
$string['nocoursesfound'] = 'Heb ddod o hyd i gyrsiau sy\'n cynnwys y geiriau {$a}';
$string['nocoursesyet'] = 'Dim cyrsiau yn y categori hwn';
$string['nodstpresets'] = 'Nid yw\'r gweinyddwr wedi galluogi Amser Arbed Golau Dydd.';
$string['nofilesselected'] = 'Nid oes unrhyw ffeiliau wedi eu dewis i\'w hadfer';
$string['nofilesyet'] = 'Nid oes ffeiliau wedi cael eu llwytho i fyny i\'ch cwrs eto';
$string['nograde'] = 'Dim gradd';
$string['nohelpforactivityorresource'] = 'Does dim help yn gysylltiedig â\'r adnodd neu\'r gweithgaredd ar hyn o bryd';
$string['noimagesyet'] = 'Nid oes delweddau wedi cael eu llwytho i fyny i\'ch cwrs eto';
$string['nologsfound'] = 'Heb ddod o hyd i\'r un log';
$string['nomatchingusers'] = 'Heb ddod o hyd i ddefnyddwyr sy\'n cyfateb i \'{$a}\'';
$string['nomorecourses'] = 'Heb ddod o hyd i ragor o gyrsiau sy\'n cyfateb';
$string['nomoreidnumber'] = 'Dim yn defnyddio rhif ID i osgoi gwrthdrawiad';
$string['none'] = 'Dim un';
$string['noneditingteacher'] = 'Athro sydd ddim yn golygu';
$string['noneditingteacherdescription'] = 'Gall athrawon sydd ddim yn golygu ddysgu ar gyrsiau a graddio myfyrwyr, ond ni allant newid gweithgareddau.';
$string['nonstandard'] = 'Ansafonol';
$string['nopendingcourses'] = 'Nid oes cyrsiau yn disgwyl i gael eu cymeradwyo';
$string['nopotentialadmins'] = 'Dim gweinyddwyr posibl';
$string['nopotentialcreators'] = 'Dim crëwyr cyrsiau posibl';
$string['nopotentialstudents'] = 'Dim myfyrwyr posibl';
$string['nopotentialteachers'] = 'Dim athrawon posibl';
$string['norecentactivity'] = 'Dim gweithgaredd diweddar';
$string['noreplybouncemessage'] = 'Rydych chi wedi anfon ateb i gyfeiriad e-bost sydd ddim yn derbyn ymatebion.  Os oeddech chi\'n ceisio ateb neges a bostiwyd ar fforwm yna ymatebwch gan ddefnyddio\'r fforwm {$a} .';
$string['noreplybouncesubject'] = '{$a} - ebost wedi\'i wrthod.';
$string['noreplyname'] = 'Peidiwch ag ymateb i\'r e-bost hwn';
$string['noresetrecord'] = 'Does dim cofnod o\'r cais ailosod hwnnw. Gwnewch gais ailosod cyfrinair newydd.';
$string['noresults'] = 'Dim canlyniadau';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Chwilio normal';
$string['nosite'] = 'Heb ddod o hyd i gwrs lefel-safle';
$string['nostudentsfound'] = 'Heb ddod o hyd i {$a}';
$string['nostudentsingroup'] = 'Nid oes myfyrwyr yn y grŵp hwn eto';
$string['nostudentsyet'] = 'Nid oes myfyrwyr wedi cofrestru ar y cwrs hwn eto';
$string['nosuchemail'] = 'Nid yw\'r cyfeiriad e-bost yn bodoli';
$string['notavailable'] = 'Nid yw ar gael';
$string['noteachersyet'] = 'Nid oes athrawon yn y cwrs hwn eto';
$string['notenrolled'] = 'Nid yw {$a} wedi cofrestru ar y cwrs hwn.';
$string['notenrolledprofile'] = 'Nid yw\'r proffil hwn ar gael oherwydd nad yw\'r defnyddiwr wedi cofrestru ar y cwrs.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Cofiwch:</strong> Mae\'r gallu i gyflwyno dyddiadau wrth adfer y copi wrth gefn hwn wedi\'i analluogi gan nad yw\'r caniatâd gofynnol gennych.';
$string['noteuserschangednonetocourse'] = 'Cofiwch: mae angen adfer defnyddwyr y cwrs wrth adfer data defnyddwyr (mewn gweithgareddau, ffeiliau neu negeseuon). Newidiwyd y gosodiad hwn i chi.';
$string['nothingnew'] = 'Dim byd newydd ers i chi fewngofnodi ddiwethaf';
$string['nothingtodisplay'] = 'Dim i\'w ddangos';
$string['notice'] = 'Hysbysiad';
$string['noticenewerbackup'] = 'Crewyd y ffeil wrth gefn hon gan  Moodle {$a->backuprelease} ({$a->backupversion}) sydd yn fersiwn mwy diweddar na\'r Moodle sydd gennych ar hyn o bryd {$a->serverrelease} ({$a->serverversion}). Gallai hyn achosi ychydig o ansefydlogrwydd oherwydd ni ellir gwarantu bod y ffeiliau wrth gefn yn gydnaws.';
$string['notifications'] = 'Hysbysiadau';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Defnyddiwr: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Gallwch weld y cofnodion hyn yn {$a}/course/log.php?id=1&chooselog=1&modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Dyma restr o\'r cynigion aflwyddiannus i fewngofnodi i {$a} ers i chi gael eich hysbysu diwethaf';
$string['notifyloginfailuressubject'] = '{$a} :: Hysbysiad am gynigion aflwyddiannus i fewngofnodi';
$string['notincluded'] = 'Heb ei gynnwys';
$string['notingroup'] = 'Mae\'n flin gennyf, ond mae\'n rhaid i chi fod yn aelod o grŵp i weld y gweithgaredd hwn.';
$string['notpublic'] = 'Ddim yn gyhoeddus!';
$string['nousersfound'] = 'Heb ddod o hyd i ddefnyddwyr';
$string['nousersmatching'] = 'Heb ddod o hyd i ddefnyddwyr sy\'n cyfateb i \'{$a}\'';
$string['nousersyet'] = 'Nid oes defnyddwyr eto';
$string['novalidcourses'] = 'Nid oes cyrsiau dilys i\'w dangos';
$string['now'] = 'nawr';
$string['numattempts'] = '{$a} cynnig aflwyddiannus i fewngofnodi';
$string['numberofcourses'] = 'Nifer y cyrsiau';
$string['numberweeks'] = 'Nifer yr wythnosau/testunau';
$string['numdays'] = '{$a} diwrnod';
$string['numhours'] = '{$a} awr';
$string['numletters'] = '{$a} llythyren';
$string['numminutes'] = '{$a} munud';
$string['nummonths'] = '{$a} mis';
$string['numseconds'] = '{$a} eiliad';
$string['numviews'] = '{$a} golwg';
$string['numweeks'] = '{$a} wythnos';
$string['numwords'] = '{$a} gair';
$string['numyears'] = '{$a} blwyddyn';
$string['ok'] = 'IAWN';
$string['oldpassword'] = 'Cyfrinair cyfredol';
$string['olduserdirectory'] = 'Yr HEN gyfeiriadur defnyddwyr yw hwn, ac nid oes ei angen bellach. Mae\'n ddiogel i chi ei ddileu. Mae\'r ffeiliau sydd ynddo wedi cael eu copïo i\'r cyfeiriadur defnyddwyr NEWYDD.';
$string['opentoguests'] = 'Mynediad i westai';
$string['optional'] = 'dewisol';
$string['options'] = 'dewisiadau';
$string['order'] = 'Trefn';
$string['originalpath'] = 'Llwybr gwreiddiol';
$string['orphanedactivitiesinsectionno'] = 'Gweithgareddau a amddifadwyd (adran {$a}';
$string['other'] = 'Arall';
$string['outline'] = 'Amlinelliad';
$string['outlinereport'] = 'Adroddiad amlinellol';
$string['page'] = 'Tudalen';
$string['pagea'] = 'Tudalen {$a}';
$string['pageheaderconfigablock'] = 'Ffurfweddu bloc yn %fullname%';
$string['pagepath'] = 'Llwybr tudalen';
$string['pageshouldredirect'] = 'Dylai\'r dudalen hon ailgyfeirio\'n awtomatig. Os nad oes dim yn digwydd, defnyddiwch y ddolen isod i fwrw ymlaen.';
$string['parentcategory'] = 'Categori rhiant';
$string['parentcoursenotfound'] = 'Heb ddod o hyd i\'r cwrs rhiant!';
$string['parentfolder'] = 'Ffolder rhiant';
$string['participants'] = 'Cyfranogwyr';
$string['participantslist'] = 'Rhestr cyfranogwyr';
$string['participationratio'] = 'Cyfradd cyfranogiad';
$string['participationreport'] = 'Adroddiad Cyfranogiad';
$string['password'] = 'Cyfrinair';
$string['passwordchanged'] = 'Mae\'r cyfrinair wedi ei newid';
$string['passwordconfirmchange'] = 'Cadarnhau newid cyfrinair';
$string['passwordextlink'] = 'Mae\'r ddolen ganlynol wedi ei chynnwys i\'ch helpu i adfer eich cyfrinair coll. Bydd hi\'n mynd â chi allan o Moodle.';
$string['passwordforgotten'] = 'Wedi anghofio\'r cyfrinair';
$string['passwordforgotteninstructions'] = 'Rhaid canfod eich manylion yn gyntaf ar gronfa ddata defnyddwyr. Rhowch  <strong>naill ai</strong> eich enw defnyddiwr neu\'ch cyfeiriad e-bost cofrestredig yn y blwch priodol. Nid oes rhaid i chi rhoi\'r ddau.';
$string['passwordforgotteninstructions2'] = 'I ailosod eich cyfrinair, rhowch eich enw defnyddiwr neu\'ch cyfeiriad e-bost isod. Os gallwn ddod o hyd i chi yn y gronfa ddata, bydden yn anfon e-bost i\'ch cyfeiriad e-bost, gyda chyfarwyddiadau ynghylch sut i gael mynediad eto.';
$string['passwordnohelp'] = 'Nid oes help ar gael i ddod o hyd i\'ch cyfrinair coll. Cysylltwch â\'ch gweinyddwr Moodle.';
$string['passwordrecovery'] = 'Iawn, helpwch fi i fewngofnodi';
$string['passwordsdiffer'] = 'Nid yw\'r cyfrineiriau hyn yn cyfateb';
$string['passwordsent'] = 'Anfonwyd y cyfrinair';
$string['passwordsenttext'] = '<p>Anfonwyd e-bost i\'ch cyfeiriad: {$a->email}.</p>
   <p><b>Ewch i\'ch blwch derbyn i weld yr e-bost sy\'n cynnwys eich cyfrinair newydd</b></p>
   <p>Cynhyrchwyd y cyfrinair yn awtomatig felly efallai byddwch am
   <a href="{$a->link}">ei newid i rywbeth cofiadwy</a>.</p>';
$string['passwordset'] = 'Mae eich cyfrinair wedi cael ei osod.';
$string['path'] = 'Llwybr';
$string['pathnotexists'] = 'Nid yw\'r llwybr yn bodoli yn eich gweinydd!';
$string['pathslasherror'] = 'Ni all llwybr orffen gyda slaes!!';
$string['paymentinstant'] = 'Defnyddiwch y botwn isod i dalu a byddwch wedi cofrestru cyn pen dim!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> yn disgwyl</small>)';
$string['paymentrequired'] = 'Mae angen talu i gael mynd i mewn i\'r cwrs hwn.';
$string['payments'] = 'Taliadau';
$string['paymentsorry'] = 'Diolch am eich taliad! Yn anffodus nid yw eich taliad wedi\'i brosesu a nid ydych wedi cael eich cofrestru ar y cwrs "{$a->fullname}". Rhowch gynnig ar fynd i mewn i\'r cwrs mewn munud neu ddwy. Os ydych yn cael mwy o drafferthion cystylltwch â; {$a->teacher} neu weinydd y safle';
$string['paymentthanks'] = 'Diolch am dalu!  Rydych chi nawr wedi eich cofrestru ar y cwrs:<br />"{$a}"';
$string['pendingrequests'] = 'Ceisiadau yn yr arfaeth';
$string['periodending'] = 'Cyfnod yn dod i ben ({$a})';
$string['perpage'] = 'Y dudalen';
$string['perpagea'] = 'Y dudalen: {$a}';
$string['personal'] = 'Personol';
$string['personalprofile'] = 'Proffil personol';
$string['phone'] = 'Ffôn';
$string['phone2'] = 'Ffôn symudol';
$string['phpinfo'] = 'Gwybodaeth PHP';
$string['pictureof'] = 'Llun o {$a}';
$string['pictureofuser'] = 'Llun defnyddiwr';
$string['pleaseclose'] = 'Caewch y ffenestr hon nawr.';
$string['pleasesearchmore'] = 'Chwilio rhagor';
$string['pleaseusesearch'] = 'Defnyddiwch yr adnodd chwilio';
$string['plugin'] = 'Ategyn';
$string['plugincheck'] = 'Gwirio ategion';
$string['plugindeletefiles'] = 'Mae\'r holl ddata a oedd yn gysylltiedig â\'r ategyn \'{$a->name}\' wedi\'i ddileu o\'r gronfa ddata. I atal yr ategyn rhag ailosod ei hun, dylech nawr ddileu\'r cyfeiriadur hwn oddi ar eich gweinydd: {$a->directory}';
$string['pluginsetup'] = 'Creu tablau ategion';
$string['policyaccept'] = 'Rwy\'n deall ac yn cytuno';
$string['policyagree'] = 'Rhaid i chi gytuno i\'r polisi er mwyn parhau i ddefnyddio\'r safle hwn. Ydych chi\'n cytuno?';
$string['policyagreement'] = 'Cytundeb polisi\'r safle';
$string['policyagreementclick'] = 'Dolen i gytundeb polisi\'r safle';
$string['popup'] = 'Ffenestr naid';
$string['popupwindow'] = 'Agor ffeil mewn ffenestr newydd';
$string['popupwindowname'] = 'Ffenestr naid';
$string['post'] = 'Neges';
$string['posts'] = 'Negeseuon a Bostiwyd';
$string['potentialadmins'] = 'Gweinyddwyr posibl';
$string['potentialcreators'] = 'Crëwyr cwrs posibl';
$string['potentialstudents'] = 'Myfyrwyr posibl';
$string['potentialteachers'] = 'Athrawon posibl';
$string['preferences'] = 'Hoff Ddewisiadau';
$string['preferredlanguage'] = 'Dewis iaith';
$string['preferredtheme'] = 'Dewis thema';
$string['preprocessingbackupfile'] = 'Wrthi\'n rhagbrosesu ffeil wrth gefn';
$string['prev'] = 'Blaenorol';
$string['preview'] = 'Rhagolwg';
$string['previewhtml'] = 'Rhagolwg fformat HTML';
$string['previeworchoose'] = 'Gweld rhagolwg neu ddewis thema';
$string['previous'] = 'Blaenorol';
$string['previouslyselectedusers'] = 'Dydy\'r defnyddwyr a ddewiswyd yn flaenorol ddim yn cyfateb i \'{$a}\'';
$string['previoussection'] = 'Adran flaenorol';
$string['primaryadminsetup'] = 'Creu cyfrif gweinyddwr';
$string['profile'] = 'Proffil';
$string['profilenotshown'] = 'Fydd y disgrifiad proffil hwn ddim yn ymddangos hyd nes bydd y person hwn wedi cofrestru ar o leiaf un cwrs.';
$string['publicprofile'] = 'Proffil cyhoeddus';
$string['publicsitefileswarning'] = 'Cofiwch: gall unrhywun weld y ffeiliau a osodir yma';
$string['publicsitefileswarning2'] = 'Nodyn: Gall unrhyw un sy\'n gwybod yr URL (neu sy\'n gallu ei ddyfalu) fynd i\'r ffeiliau a roddir yma. Am resymau diogelwch, rydym yn argymell bod unrhyw ffeiliau wrth gefn yn cael eu dileu yn syth ar ôl eu hadfer. ';
$string['publicsitefileswarning3'] = 'Nodyn: Gall unrhyw un sy\'n gwybod yr URL (neu sy\'n gallu ei ddyfalu) fynd i\'r ffeiliau a roddir yma. <br />Am resymau diogelwch, dylid cadw ffeiliau wrth gefn yn y ffolder diogel yn unig.';
$string['publish'] = 'Cyhoeddi';
$string['question'] = 'Cwestiwn';
$string['questionsinthequestionbank'] = 'Cwestiynau yn y banc cwestiynau';
$string['readinginfofrombackup'] = 'Darllen gwybodaeth o\'r copi wrth gefn';
$string['readme'] = 'DARLLEN FI';
$string['recentactivity'] = 'Gweithgareddau diweddar';
$string['recentactivityreport'] = 'Adroddiad llawn ar y gweithgareddau diweddar...';
$string['recipientslist'] = 'Rhestr o gyfranogwyr';
$string['recreatedcategory'] = 'Wedi ailgreu\'r categori {$a}';
$string['redirect'] = 'Ailgyfeirio';
$string['reducesections'] = 'Lleihau y nifer o adrannau';
$string['refresh'] = 'Adnewyddu';
$string['refreshingevents'] = 'Wrthi\'n adnewyddu digwyddiadau';
$string['registration'] = 'Cofrestru Moodle';
$string['registrationcontact'] = 'Cyswllt gan y cyhoedd';
$string['registrationcontactno'] = 'Na, nid wyf am gael ffurflen gysylltu yn rhestr y safle';
$string['registrationcontactyes'] = 'Iawn, darparu ffurflen fel y gall darpar ddefnyddwyr Moodle gysylltu â fi';
$string['registrationemail'] = 'Hysbysiadau e-bost';
$string['registrationinfo'] = '<p>Mae\'r dudalen hon yn gadael i chi gofrestru eich safle Moodle gyda  moodle.org. Mae cofrestru yn rhad ac am ddim.
Prif fantais cofrestru yw y byddwch yn cael eich ychwanegu at restr bostio
ar gyfer hysbysiadau pwysig megis hysbysiadau diogelwch a diweddariadau newydd o Moodle.</p>
<p>Cedwir eich gwybodaeth yn breifat yn ddiofyn, ac ni chaiff ei gwerthu na\'i phasio ymlaen i neb arall. Yr unig
   reswm dros gasglu\'r wybodaeth hon yw at ddibenion darparu cymorth ac i\'n helpu i lunio darlun ystadegol
   o gymuned gyfan Moodle.</p>
<p>Os ydych chi\'n dymuno, gallwch ychwanegu enw\'ch safle, gwlad ac URL i\'r rhestr gyhoeddus o Safleoedd Moodle.</p>
<p>Caiff pob cofrestriad newydd eu gwirio â llaw cyn y cânt eu hychwanegu at y rhestr. Ar ôl i chi gael eich ychwanegu gallwch ddiweddaru eich cofrestriad (a\'ch cofnod ar y rhestr gyhoeddus) unrhyw bryd drwy ailgyflwyno\'r ffurflen hon.</p>';
$string['registrationinfotitle'] = 'Gwybodaeth cofrestru';
$string['registrationno'] = 'Na, nid wyf am dderbyn e-bost';
$string['registrationsend'] = 'Anfon gwybodaeth cofrestru i moodle.org';
$string['registrationyes'] = 'Iawn, rhowch wybod i fi am faterion pwysig';
$string['reject'] = 'Gwrthod';
$string['rejectdots'] = 'Gwrthod...';
$string['reload'] = 'Ail-lwytho';
$string['remoteappuser'] = 'Defnyddiwr {$a} o Bell';
$string['remove'] = 'Tynnu';
$string['removeadmin'] = 'Tynnu gweinyddwr';
$string['removecreator'] = 'Tynnu crëwr y cwrs';
$string['removestudent'] = 'Tynnu myfyriwr';
$string['removeteacher'] = 'Tynnu athro';
$string['rename'] = 'Ailenwi';
$string['renamefileto'] = 'Ailenwi <b>{$a}</b> yn';
$string['report'] = 'Adroddiad';
$string['reports'] = 'Adroddiadau';
$string['repositories'] = 'Ystorfeydd';
$string['requestcourse'] = 'Cais am gwrs';
$string['requestedby'] = 'Cais gan';
$string['requestedcourses'] = 'Cyrsiau y gofynnwyd amdanynt';
$string['requestreason'] = 'Rheswm dros gais am gwrs';
$string['required'] = 'Angen';
$string['requirespayment'] = 'Mae angen talu ar gyfer mynd i mewn i\'r cwrs hwn';
$string['reset'] = 'Ailosod';
$string['resetcomponent'] = 'Cydran';
$string['resetcourse'] = 'Ailosod cwrs';
$string['resetinfo'] = 'Mae\'r dudalen hon yn gadael i chi gael gwared ar ddata defnyddwyr o gwrs, gan adael y gweithgareddau a\'r gosodiadau eraill.
Cofiwch, os ydych yn dewis yr eitemau isod ac anfon y dudalen hon byddwch yn dileu data\'r defnyddwyr a ddewiswyd o\'r cwrs hwn am byth!';
$string['resetnotimplemented'] = 'Heb ailosod';
$string['resetrecordexpired'] = 'Mae\'r ddolen ailosod cyfrinair a wnaethoch ei defnyddio yn fwy na {$a} o funudau o oed. Gwnewch gais newydd i ailosod cyfrinair.';
$string['resetstartdate'] = 'Ailosod dyddiad cychwyn';
$string['resetstatus'] = 'Statws';
$string['resettask'] = 'Tasg';
$string['resettodefaults'] = 'Ailosod y rhagosodiadau';
$string['resortbyfullname'] = 'Yn ôl enwllawn';
$string['resortbyidnumber'] = 'Yn ôl rhifid';
$string['resortbyshortname'] = 'Yn ôl enwbyr';
$string['resortcourses'] = 'Trefnu cyrsiau';
$string['resortsubcategoriesbyidnumber'] = 'Trefnu is-gategorïau yn ôl rhifid';
$string['resortsubcategoriesbyname'] = 'Trefnu is-gategorïau yn ôl enw';
$string['resource'] = 'Adnodd';
$string['resourcedisplayauto'] = 'Awtomatig';
$string['resourcedisplaydownload'] = 'Gorfodi llwytho i lawr';
$string['resourcedisplayembed'] = 'Gwreiddio';
$string['resourcedisplayframe'] = 'Yn y ffrâm';
$string['resourcedisplaynew'] = 'Ffenestr newydd';
$string['resourcedisplayopen'] = 'Agor';
$string['resourcedisplaypopup'] = 'Mewn ffenestr naid';
$string['resources'] = 'Adnodddau';
$string['resources_help'] = 'Mae\'r mathau o adnoddau yn eich galluogi i fewnosod bron unrhyw fath o gynnwys gwe i\'r cwrs.';
$string['restore'] = 'Adfer';
$string['restorecancelled'] = 'Adfer yr hyn a ddilëwyd';
$string['restorecannotassignroles'] = 'Mae\'r broses adfer am neilltuo swyddogaethau ond does gennych chi ddim hawl i wneud hynny';
$string['restorecannotcreateorassignroles'] = 'Mae\'r broses adfer am neilltuo neu greu swyddogaethau ond does gennych chi ddim hawl i wneud hynny';
$string['restorecannotcreateuser'] = 'Mae\'r broses adfer am greu defnyddiwr \'{$a}\' o\'r ffeil wrth gefn ond does gennych chi ddim hawl i wneud hynny';
$string['restorecannotoverrideperms'] = 'Mae\'r broses adfer am ddiystyrru hawliau ond does gennych chi ddim hawl i wneud hynny';
$string['restorecoursenow'] = 'Adfer y cwrs hwn nawr!';
$string['restoredaccount'] = 'Cyfrif wedi\'i adfer';
$string['restoredaccountinfo'] = 'Cafodd y cyfrif hwn ei fewngludo o weinydd arall ac mae\'r cyfrinair wedi\'i golli. I osod cyfrinair newydd drwy e-bost, cliciwch "Bwrw Ymlaen"';
$string['restorefinished'] = 'Wedi adfer yn llwyddiannus';
$string['restoreto'] = 'Adfer i';
$string['restoretositeadding'] = 'Rhybudd: Rydych chi ar fin adfer tudalen flaen y safle, gan ychwanegu data ati!';
$string['restoretositedeleting'] = 'Rhybudd: Rydych chi ar fin adfer tudalen flaen y safle, gan ddileu data oddi arni yn gyntaf!';
$string['restoreuserconflict'] = 'Bydd ceisio adfer y defnyddiwr \'{$a}\' o\'r ffeil wrth gefn yn achosi gwrthdaro';
$string['restoreuserinfofailed'] = 'Mae\'r broses adfer wedi stopio oherwydd does gennych chi ddim hawl i adfer data defnyddwyr.';
$string['restoreusersprecheck'] = 'Wrthi\'n gwirio data defnyddwyr';
$string['restoreusersprecheckerror'] = 'Wedi canfod rhai problemau wrth wirio data defnyddwyr';
$string['restricted'] = 'Wedi\'i wahardd';
$string['returningtosite'] = 'Mynd yn ôl i\'r wefan hon';
$string['returntooriginaluser'] = 'Mynd yn ôl i {$a}';
$string['revert'] = 'Troi\'n ôl';
$string['role'] = 'Swyddogaeth';
$string['roleassignments'] = 'Aseiniadau rôl';
$string['rolemappings'] = 'Mapio swyddogaeth';
$string['rolerenaming'] = 'Ailenwi swyddogaethau';
$string['rolerenaming_help'] = 'Mae\'r gosodiad hwn yn eich galluogi i newid enwau\'r swyddogaethau sy\'n cael eu defnyddio yn y cwrs. Dim ond yr enw sy\'n ymddangos sy\'n newid - dydy hyn ddim yn effeithio ar hawliau\'r swyddogaeth. Bydd enwau swyddogaeth newydd yn ymddangos ar dudalen cyfranogwyr y cwrs ac mewn llefydd eraill yn y cwrs. Os yw\'r swyddogaeth sy\'n cael ei newid yn swyddogaeth a ddewiswyd gan weinyddwr fel rheolwr cwrs, yna bydd yr enw swyddogaeth newydd hefyd yn ymddangos ar y rhestr cyrsiau. ';
$string['roles'] = 'Swyddogaethau';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Nifer yr erthyglau RSS diweddar';
$string['rsserror'] = 'Gwall wrth ddarllen data RSS';
$string['rsserrorauth'] = 'Dydy eich dolen RSS ddim yn cynnwys tocyn dilysu dilys.';
$string['rsserrorguest'] = 'Mae\'r crynodeb hwn yn defnyddio mynediad gwestai i gael gafael ar y data, ond does gan westai ddim hawl i ddarllen y data. ';
$string['rsskeyshelp'] = 'I sicrhau diogelwch a phreifatrwydd, mae URLs mewn crynodeb RSS yn cynnwys tocyn arbennig sy\'n nodi derbynwyr y neges. Mae hyn yn atal defnyddwyr eraill rhag cael mynediad at ardaloedd o Moodle drwy grynodebau RSS na ddylent fod yn agored iddynt.</p><p>Mae\'r tocyn hwn yn cael ei greu\'n awtomatig y tro cyntaf y byddwch yn mynd i ardal yn Moodle sy\'n cynhyrchu crynodeb RSS. Os ydych chi\'n poeni bod rhywun wedi camddefnyddio eich tocyn crynodeb RSS, gallwch wneud cais am un newydd drwy glicio\'r ddolen Ailosod yma. Cofiwch y byddwch wedyn yn colli URLs eich crynodeb RSS presennol.';
$string['rsstype'] = 'Porth RSS ar gyfer y gweithgaredd hwn';
$string['saveandnext'] = 'Cadw a dangos y nesaf';
$string['savechanges'] = 'Cadw\'r newidiadau';
$string['savechangesanddisplay'] = 'Cadw a dangos';
$string['savechangesandreturntocourse'] = 'Cadw a dychwelyd at y cwrs';
$string['savecomment'] = 'Cadw\'r sylw';
$string['savedat'] = 'Cadw yn:';
$string['savepreferences'] = 'Cadw\'r hoff ddewisiadau';
$string['saveto'] = 'Cadw yn';
$string['scale'] = 'Graddfa';
$string['scale_help'] = 'Mae graddfa yn darparu ffordd o werthuso neu raddio perfformiad mewn gweithgaredd. Caiff ei ddiffinio gan restr o werthoedd mewn trefn, yn amrywio o sylw negyddol i gadarnhaol, gyda chomas rhyngddynt, er enghraifft "Siomedig, Ddim yn ddigon da, Gweddol, Da, Da Iawn, Ardderchog!"';
$string['scales'] = 'Graddfeydd';
$string['scalescustom'] = 'Graddfeydd personol';
$string['scalescustomcreate'] = 'Ychwanegu graddfa newydd';
$string['scalescustomno'] = 'Nid oes graddfeydd personol wedi eu creu eto';
$string['scalesstandard'] = 'Graddfeydd safonol';
$string['scalestandard'] = 'Graddfa safonol';
$string['scalestandard_help'] = 'Mae graddfa safonol ar gael ar draws y safle cyfan, ar gyfer pob cwrs.';
$string['scalestip'] = 'I greu graddfeydd personol, defnyddiwch y ddolen \'Graddfeydd...\' yn eich dewislen gweinyddu cwrs.';
$string['scalestip2'] = 'I greu graddfeydd personol, cliciwch y ddolen Graddau yn newislen gweinyddu\'r cwrs, yna dewiswch Golygu, Graddfeydd.';
$string['schedule'] = 'Amserlen';
$string['screenshot'] = 'Ciplun o sgrin';
$string['search'] = 'Chwilio';
$string['searchagain'] = 'Chwilio eto';
$string['searchbyemail'] = 'Chwilio yn ôl cyfeiriad e-bost';
$string['searchbyusername'] = 'Chwilio yn ôl enw defnyddiwr';
$string['searchcourses'] = 'Chwilio\'r cyrsiau';
$string['searchhelp'] = 'Gallwch chwilio am fwy nag un gair ar y tro.<br /><br />gair : dod o hyd i\'r gair hwn yn rhywle yn y testun.<br />+gwair : dod o hyd i\'r union air sy\'n cyfateb yn unig.<br />-gair : peidio â chynnwys canlyniadau sy\'n cynnwys y gair hwn.';
$string['search_help'] = 'Wrth chwilio\'n syml am un neu fwy o eiriau yn rhywle yn y testun, teipiwch y geiriau gyda bylchau rhyngddynt. Byddwn yn chwillio am bob gair gyda mwy na dwy lythyren.

Os ydych am chwilio\'n fwy manwl, pwyswch y botwm chwilio heb deipio dim byd yn y blwch chwilio i gael mynediad at y ffurflen chwilio manwl.';
$string['searchoptions'] = 'Dewisiadau chwilio';
$string['searchresults'] = 'Canlyniadau chwilio';
$string['sec'] = 'eiliad';
$string['seconds'] = 'eiliadau';
$string['secondstotime172800'] = '2 ddiwrnod';
$string['secondstotime259200'] = '3 diwrnod';
$string['secondstotime345600'] = '4 diwrnod';
$string['secondstotime432000'] = '5 diwrnod';
$string['secondstotime518400'] = '6 diwrnod';
$string['secondstotime604800'] = '1 wythnos';
$string['secondstotime86400'] = '1 diwrnod';
$string['secretalreadyused'] = 'Roedd y ddolen i gadarnhau newid cyfrinair eisoes wedi\'i defnyddio. Ni newidwyd y cyfrinair.';
$string['secs'] = 'eiliadau';
$string['section'] = 'Adran';
$string['sectionname'] = 'Enw\'r adran';
$string['sections'] = 'Adrannau';
$string['sectionusedefaultname'] = 'Defnyddio enw adran diofyn';
$string['seealsostats'] = 'Gweler hefyd: ystadegau';
$string['selctauser'] = 'Dewiswch ddefnyddiwr';
$string['select'] = 'Dewis';
$string['selectacategory'] = 'Dewiswch gategori';
$string['selectacountry'] = 'Dewis gwlad';
$string['selectacourse'] = 'Dewiswch gwrs';
$string['selectacoursesite'] = 'Dewiswch gwrs neu safle';
$string['selectagroup'] = 'Dewiswch grŵp';
$string['selectall'] = 'Dewis pob un';
$string['selectamodule'] = 'Dewiswch fodiwl gweithgaredd';
$string['selectanaction'] = 'Dewiswch weithred';
$string['selectanoptions'] = 'Dewiswch ddewisiad';
$string['selectaregion'] = 'Dewiswch ranbarth';
$string['selectcategorysort'] = 'Pa gategorïau hoffech chi eu trefnu?';
$string['selectcategorysortby'] = 'Dewiswch sut hoffech chi drefnu categorïau';
$string['selectcoursesortby'] = 'Dewiswch sut hoffech chi drefnu cyrsiau';
$string['selectdefault'] = 'Dewis yr un diofyn';
$string['selectedcategories'] = 'Y categorïau a ddewiswyd';
$string['selectedfile'] = 'Ffeil a ddewiswyd';
$string['selectednowmove'] = 'Wedi dewis {$a} ffeil i\'w symud. Ewch i\'r man derbyn a chliciwch ar \'symud ffeiliau yma\'';
$string['selectfiles'] = 'Dewis ffeiliau';
$string['selectmoduletoviewhelp'] = 'Dewiswch weithgaredd neu adnodd i weld yr help.

Dwbl-gliciwch ar enw gweithgaredd neu adnodd i\'w ychwanegu\'n sydyn.';
$string['selectnos'] = 'Dewis \'na\' i bob un';
$string['selectperiod'] = 'Dewis cyfnod';
$string['senddetails'] = 'Anfon fy manylion drwy e-bost';
$string['separate'] = 'Ar wahân';
$string['separateandconnected'] = 'Ffyrdd o wybod Ar Wahân a Chysylltiedig';
$string['separateandconnectedinfo'] = 'Graddfa yn seiliedig ar theori gwybodaeth ar wahân a chysylltiedig. Mae\'r theori hon yn disgrifio dwy ffordd wahanol y gallwn werthuso a dysgu am yr hyn rydym yn ei weld a chlywed.<ul><li><strong> Mae dysgwyr ar wahân</strong> yn aros mor wrthrychol â phosib heb gynnwys teimladau nac emosiynau. Mewn trafodaeth â phobl eraill, maent yn dueddol o amddiffyn eu syniadau eu hunain, gan ddefnyddio rhesymeg i ganfod tyllau yn syniadau eu gwrthwynebwyr.';
$string['servererror'] = 'Doedd dim modd cysylltu â\'r gweinydd';
$string['serverlocaltime'] = 'Amser lleol y gweinydd';
$string['setcategorytheme'] = 'Gosod thema categori';
$string['setpassword'] = 'Gosod cyfrinair';
$string['setpasswordinstructions'] = 'Nodwch eich cyfrinair newydd a\'i ailadrodd isod, yna cliciwch ar "Gosod cyfrinair". <br />Bydd eich cyfrinair newydd yn cael ei gadw, a byddwch wedi mewngofnodi.';
$string['settings'] = 'Gosodiadau';
$string['shortname'] = 'Enw byr';
$string['shortnamecollisionwarning'] = '[*] = Mae\'r enw byr hwn eisoes yn cael ei ddefnyddio gan gwrs a bydd angen ei newid wrth ei gymeradwyo';
$string['shortnamecourse'] = 'Enw byr cwrs';
$string['shortnamecourse_help'] = 'Mae enw byr y cwrs yn ymddangos yn y bar llywio ac yn cael ei ddefnyddio yn llinell pwnc negeseuon e-bost y cwrs.';
$string['shortnametaken'] = 'Mae\'r enw byr eisoes yn cael ei ddefnyddio gan gwrs arall ({$a})';
$string['shortnameuser'] = 'Enw byr defnyddiwr';
$string['shortsitename'] = 'Enw byr ar gyfer safle (e.e. gair sengl)';
$string['show'] = 'Dangos';
$string['showactions'] = 'Dangos y gweithredoedd';
$string['showadvancedsettings'] = 'Dangos y gosodiadau uwch';
$string['showall'] = 'Dangos pob {$a}';
$string['showallcourses'] = 'Dangos pob cwrs';
$string['showallusers'] = 'Dangos pob defnyddiwr';
$string['showblockcourse'] = 'Dangos rhestr o\'r cyrsiau sy\'n cynnwys y bloc';
$string['showcategory'] = 'Dangos {$a}';
$string['showcomments'] = 'Dangos/cuddio sylwadau';
$string['showcommentsnonjs'] = 'Dangos sylwadau';
$string['showdescription'] = 'Dangos disgrifiad ar dudalen y cwrs';
$string['showdescription_help'] = 'Os yw wedi\'i alluogi, bydd y disgrifiad uchod yn cael ei ddangos ar dudalen y cwrs o dan y ddolen i\'r gweithgaredd neu\'r adnodd.';
$string['showgrades'] = 'Dangos llyfr graddau i fyfyrwyr';
$string['showgrades_help'] = 'Mae\'n bosib gosod graddau mewn sawl gweithgaredd yn y cwrs. Mae\'r gosodiad hwn yn pennu a all myfyriwr weld rhestr o\'i holl raddau ar y cwrs drwy ddolen graddau ym mloc gweinyddu\'r cwrs.';
$string['showingacourses'] = 'Dangos pob cwrs {$a}';
$string['showingxofycourses'] = 'Dangos cyrsiau o {$a->start} i {$a->end} o {$a->total} o gyrsiau';
$string['showlistofcourses'] = 'Dangos rhestr o\'r cyrsiau';
$string['showmodulecourse'] = 'Dangos rhestr o\'r cyrsiau sy\'n cynnwys gweithgaredd';
$string['showonly'] = 'Dim ond dangos';
$string['showperpage'] = 'Dangos {$a} ar bob tudalen';
$string['showrecent'] = 'Dangos gweithgaredd diweddar';
$string['showreports'] = 'Dangos adroddiadau gweithgaredd';
$string['showreports_help'] = 'Mae adroddiadau gweithgaredd ar gael ar gyfer pob cyfranogwr sy\'n dangos eu gwaith ar y cwrs. Yn ogystal â rhestr o\'u cyfraniadau, megis negeseuon ar fforymau neu waith a gyflwynwyd ar gyfer aseiniadau, mae\'r adroddiadau hyn hefyd yn cynnwys logiau mynediad. Mae\'r gosodiad hwn yn pennu a all myfyriwr weld ei adroddiadau gweithgarwch ei hun ar ei dudalen proffil.';
$string['showsettings'] = 'Dangos gosodiadau';
$string['showtheselogs'] = 'Dangos y logiau hyn';
$string['showthishelpinlanguage'] = 'Dangos yr help hwn yn yr iaith ganlynol:';
$string['since'] = 'Ers';
$string['sincelast'] = 'Ers mewngofnodi\'r tro diwethaf';
$string['site'] = 'Safle';
$string['sitedefault'] = 'Safle diofyn';
$string['siteerrors'] = 'Gwallau ar y safle';
$string['sitefiles'] = 'Ffeiliau\'r safle';
$string['sitefilesused'] = 'Ffeiliau safle sy\'n cael eu defnyddio yn y cwrs hwn';
$string['sitehome'] = 'Hafan y safle';
$string['sitelegacyfiles'] = 'Hen ffeiliau safle';
$string['sitelogs'] = 'Logiau\'r safle';
$string['sitemessage'] = 'Defnyddwyr negeseuon';
$string['sitenews'] = 'Newyddion safle';
$string['sitepages'] = 'Tudalennau safle';
$string['sitepartlist'] = 'Nid oes hawl gennych i weld rhestr cyfranogwyr';
$string['sitepartlist0'] = 'Mae\'n rhaid i chi fod yn athro safle i gael gweld rhestr cyfranogwyr y safle.';
$string['sitepartlist1'] = 'Rhaid i chi fod yn athro cyn y cewch weld rhestr y cyfranogwyr safle';
$string['sites'] = 'Safleoedd';
$string['sitesection'] = 'Cynnwys adran testun';
$string['sitesettings'] = 'Gosodiadau\'r safle';
$string['siteteachers'] = 'Athrawon y safle';
$string['size'] = 'Maint';
$string['sizeb'] = 'beitiau';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Symud ymlaen';
$string['skiptocategorylisting'] = 'Symud ymlaen i\'r rhestrau o gategorïau';
$string['skiptocoursedetails'] = 'Symud ymlaen i\'r wybodaeth fanwl am y cwrs';
$string['skiptocourselisting'] = 'Symud ymlaen i\'r rhestrau o gyrsiau';
$string['skypeid'] = 'ID Skype';
$string['socialheadline'] = 'Fforwm cymdeithasol - y testunau diweddaraf';
$string['someallowguest'] = 'Mae rhai cyrsiau yn caniatáu gwesteion i fynd i mewn';
$string['someerrorswerefound'] = 'Roedd peth gwybodaeth ar goll neu\'n anghywir. Edrychwch isod am fanylion.';
$string['sort'] = 'Trefnu';
$string['sortby'] = 'Trefnu yn ôl';
$string['sortbyx'] = 'Trefnu yn ôl  {$a} o\'r lleiaf i\'r mwyaf';
$string['sortbyxreverse'] = 'Trefnu yn ôl {$a} o\'r mwyaf i\'r lleiaf';
$string['sortcategoriesbyidnumber'] = 'Trefnu categorïau yn ôl rhif ID';
$string['sortcategoriesbyname'] = 'Trefnu categorïau yn ôl enw';
$string['sortcoursesbyfullname'] = 'Trefnu cyrsiau yn ôl enw llawn';
$string['sortcoursesbyidnumber'] = 'Trefnu cyrsiau yn ôl rhif ID';
$string['sortcoursesbyshortname'] = 'Trefnu cyrsiau yn ôl enw byr';
$string['sorting'] = 'Trefnu';
$string['sourcerole'] = 'Swyddogaeth ffynhonnell';
$string['specifyname'] = 'Rhaid i chi nodi enw.';
$string['standard'] = 'Safonol';
$string['starpending'] = '([*] = cwrs yn disgwyl i gael ei gymeradwyo)';
$string['startdate'] = 'Dyddiad dechrau\'r cwrs';
$string['startdate_help'] = 'Mae\'r gosodiad hwn yn pennu dechrau wythnos gyntaf cwrs mewn fformat wythnosol. Mae hefyd yn pennu\'r dyddiad cyntaf y bydd logiau ar gyfer gweithgareddau cwrs ar waith.';
$string['startingfrom'] = 'Yn dechrau o';
$string['startsignup'] = 'Creu cyfrif newydd';
$string['state'] = 'Talaith / Sir';
$string['statistics'] = 'Ystadegau';
$string['statisticsgraph'] = 'Graff ystadegau';
$string['stats'] = 'Ystadegau';
$string['statslogins'] = 'Mewngofnodi';
$string['statsmodedetailed'] = 'Golwg manwl (defnyddiwr)';
$string['statsmodegeneral'] = 'Golwg cyffredinol';
$string['statsnodata'] = 'Dim data ar gael ar gyfer y cyfuniad hwnnw o gyfnod cwrs ac amser';
$string['statsnodatauser'] = 'Dim data ar gael ar gyfer y cyfuniad hwnnw o gyfnod cwrs, defnyddiwr ac amser';
$string['statsoff'] = 'Nid yw\'r ystadegau wedi\'u galluogi ar hyn o bryd';
$string['statsreads'] = 'Golygfeydd';
$string['statsreport1'] = 'Mewngofnodi';
$string['statsreport10'] = 'Gweithgaredd defnyddiwr';
$string['statsreport11'] = 'Cyrsiau mwyaf gweothgar';
$string['statsreport12'] = 'Cyrsiau mwyaf gweithgar (pwysol)';
$string['statsreport13'] = 'Y cyrsiau mwyaf cyfranogol (cofrestriadau)';
$string['statsreport14'] = 'Y cyrsiau mwyaf cyfranogol (gweld/negeseuon)';
$string['statsreport2'] = 'Gweld (pob rôl)';
$string['statsreport3'] = 'Negeseuon (pob rôl)';
$string['statsreport4'] = 'Pob gweithgaredd (pob rôl)';
$string['statsreport5'] = 'Pob gweithgaredd (gweld a negeseuon)';
$string['statsreport7'] = 'Gweithgaredd defnyddwyr (gweld a negeseuon)';
$string['statsreport8'] = 'Holl weithgareddau defnyddwyr';
$string['statsreport9'] = 'Mewngofnodi (cwrs safle)';
$string['statsreportactivity'] = 'Pob gweithgaredd (pob rôl)';
$string['statsreportactivitybyrole'] = 'Pob gweithgaredd (gweld a negeseuon)';
$string['statsreportforuser'] = 'ar gyfer';
$string['statsreportlogins'] = 'Mewngofnodi';
$string['statsreportreads'] = 'Gweld (pob rôl)';
$string['statsreporttype'] = 'Math o adroddiad';
$string['statsreportwrites'] = 'Negeseuon (pob rôl)';
$string['statsstudentactivity'] = 'Gweithgaredd myfyrwyr';
$string['statsstudentreads'] = 'Gweld (gan fyfyrwyr)';
$string['statsstudentwrites'] = 'Negeseuon Myfyrwyr';
$string['statsteacheractivity'] = 'Gweithgaredd athro';
$string['statsteacherreads'] = 'Gweld (gan athro)';
$string['statsteacherwrites'] = 'Negeseuon Athro';
$string['statstimeperiod'] = 'Cyfnod amser - olaf:';
$string['statsuniquelogins'] = 'Mewngofnodi unigryw';
$string['statsuseractivity'] = 'Pob gweithgaredd';
$string['statsuserlogins'] = 'Mewngofnodi';
$string['statsuserreads'] = 'Gweld';
$string['statsuserwrites'] = 'Negeseuon';
$string['statswrites'] = 'Negeseuon';
$string['status'] = 'Statws';
$string['stringsnotset'] = 'Nid yw\'r llinynnau canlynol wedi cael eu diffinio yn {$a}';
$string['studentnotallowed'] = 'Mae\'n flin gennyf, ni chewch fynd i mewn i\'r cwrs fel \'{$a}\'';
$string['students'] = 'Myfyrwyr';
$string['studentsandteachers'] = 'Myfyrwyr ac athrawon';
$string['subcategories'] = 'Is-gategorïau';
$string['subcategory'] = 'Is-gategori';
$string['subcategoryof'] = 'Is-gategori {$a}';
$string['submit'] = 'Cyflwyno';
$string['success'] = 'Llwyddiant';
$string['summary'] = 'Crynodeb';
$string['summary_help'] = 'Crynodeb yw darn byr o destun i baratoi myfyrwyr ar gyfer y gweithgareddau yn y pwnc neu mewn wythnos. Bydd y testun yn ymddangos ar dudalen y cwrs dan enw\'r adran.';
$string['summaryof'] = 'Crynodeb o {$a}';
$string['supplyinfo'] = 'Mwy o fanylion';
$string['suspended'] = 'Wedi\'i atal';
$string['suspendedusers'] = 'Defnyddwyr wedi\'u hatal';
$string['switchdevicedefault'] = 'Newid i\'r thema safonol';
$string['switchdevicerecommended'] = 'Newid i\'r thema sy\'n cael ei hargymell ar gyfer eich dyfais';
$string['switchrolereturn'] = 'Dychwelyd i fy swyddogaeth arferol';
$string['switchroleto'] = 'Newid swyddogaeth i...';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Mae\'r tag hwn eisoes yn bodoli';
$string['tagmanagement'] = 'Ychwanegu/dileu tagiau...';
$string['tags'] = 'Tagiau';
$string['targetrole'] = 'Swyddogaeth darged';
$string['teacheronly'] = 'ar gyfer {$a} yn unig';
$string['teacherroles'] = 'swyddogaethau {$a}';
$string['teachers'] = 'Athrawon';
$string['textediting'] = 'Wrth olygu testun';
$string['texteditor'] = 'Defnyddio ffurflenni gwe safonol';
$string['textformat'] = 'Fformat testun plaen';
$string['thanks'] = 'Diolch';
$string['theme'] = 'Thema';
$string['themes'] = 'Themâu';
$string['themesaved'] = 'Wedi cadw\'r thema newydd';
$string['therearecourses'] = 'Mae {$a} o gyrsiau';
$string['thereareno'] = 'Does dim {$a} yn y cwrs hwn';
$string['thiscategory'] = 'Y categori hwn';
$string['thiscategorycontains'] = 'Mae\'r categori hwn yn cynnwys';
$string['time'] = 'Amser';
$string['timezone'] = 'Cylchfa amser';
$string['to'] = 'I';
$string['tocontent'] = 'I eitem "{$a}"';
$string['tocreatenewaccount'] = 'Hepgor i greu cyfrif newydd';
$string['today'] = 'Heddiw';
$string['todaylogs'] = 'Logiau heddiw';
$string['toeveryone'] = 'i bawb';
$string['toomanybounces'] = 'Mae\'r cyfeiriad e-bost hwn wedi ei wrthod gormod o weithiau. <b>Rhaid </b> i chi ei newid er mwyn bwrw ymlaen.';
$string['toomanytoshow'] = 'Mae gormod o ddefnyddwyr i\'w dangos';
$string['toomanyusersmatchsearch'] = 'Mae gormod o ddefnyddwyr ({$a->count}) yn cyfateb i \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Mae gormod o ddefnyddwyr ({$a}) i\'w dangos';
$string['toonly'] = 'i {$a} yn unig';
$string['top'] = 'Top';
$string['topic'] = 'Testun';
$string['topichide'] = 'Cuddio\'r testun hwn oddi wrth {$a}';
$string['topicoutline'] = 'Amlinelliad o\'r testun';
$string['topicshow'] = 'Dangos y testun hwn i {$a}';
$string['toplevelcategory'] = 'Categori lefel uchaf';
$string['total'] = 'Cyfanswm';
$string['totopofsection'] = 'I ben adran "{$a}"';
$string['trackforums'] = 'Tracio fforwm';
$string['trackforumsno'] = 'Na: peidio â chadw cofnod o negeseuon yr wyf wedi\'u gweld';
$string['trackforumsyes'] = 'Iawn: tynnu fy sylw at negeseuon newydd a bostiwyd';
$string['trysearching'] = 'Rhoi cynnig ar chwilio yn lle hynny';
$string['turneditingoff'] = 'Diffodd y broses olygu';
$string['turneditingon'] = 'Troi\'r broses olygu ymlaen';
$string['undecided'] = 'Heb benderfynu';
$string['unfinished'] = 'Heb ei gwblhau';
$string['unknowncategory'] = 'Categori anhysbys';
$string['unlimited'] = 'Heb derfyn';
$string['unpacking'] = 'Wrthi\'n dad-bacio {$a}';
$string['unsafepassword'] = 'Nid yw\'r cyfrinair yn ddiogel - rhowch gynnig ar un arall';
$string['untilcomplete'] = 'Hyd nes y bydd wedi\'i gwblhau';
$string['unusedaccounts'] = 'Bydd cyfrifon sydd heb eu defnyddio am fwy na {$a} diwrnod yn cael eu dad-gofrestru\'n awtomatig.';
$string['unzip'] = 'Dad-zipio';
$string['unzippingbackup'] = 'Dad-zipio copi wrth gefn';
$string['up'] = 'I Fyny';
$string['update'] = 'Diweddaru';
$string['updated'] = 'Wedi diweddaru {$a}';
$string['updatemymoodleoff'] = 'Stopiwch deilwra\'r dudalen hon';
$string['updatemymoodleon'] = 'Teilwra\'r dudalen hon';
$string['updatemyprofile'] = 'Diweddaru\'r proffil';
$string['updatesevery'] = 'Diweddaru bob {$a} eiliad';
$string['updatethis'] = 'Diweddaru {$a}';
$string['updatethiscourse'] = 'Diweddaru\'r cwrs hwn';
$string['updatinga'] = 'Wrthi\'n diweddaru: {$a}';
$string['updatingain'] = 'Wrthi\'n diweddaru {$a->what} yn {$a->in}';
$string['upload'] = 'Llwytho i fyny';
$string['uploadafile'] = 'Llwytho ffeil i fyny';
$string['uploadcantwrite'] = 'Heb lwyddo i ysgrifennu\'r ffeil ar ddisg';
$string['uploadedfile'] = 'Wedi llwytho ffeil i fyny\'n llwyddiannus';
$string['uploadedfileto'] = 'Wedi llwytho {$a->file} i {$a->directory}';
$string['uploadedfiletoobig'] = 'Mae\'n flin gennyf, ond mae\'r ffeil hon yn rhy fawr (y maint mwyaf yw {$a} beit)';
$string['uploadextension'] = 'Mae\'r broses llwytho ffeil i fyny wedi cael ei stopio gan estyniad PHP';
$string['uploadfailednotrecovering'] = 'Heb lwyddo i lwytho\'r ffeil i fyny, roedd yna broblem gydag un o\'r ffeiliau, {$a->name}.<br /> Dyma log o\'r problemau:<br />{$a->problem}<br /> Heb lwyddo i adfer.';
$string['uploadfilelog'] = 'Llwytho log i fyny ar gyfer ffeil {$a}';
$string['uploadformlimit'] = 'Mae\'r ffeil {$a} a lwythwyd i fyny yn fwy na\'r maint mwyaf a osodwyd gan y ffurflen';
$string['uploadlabel'] = 'Teitl:';
$string['uploadlimitwithsize'] = '{$a->contextname} upload limit ({$a->displaysize})';
$string['uploadnewfile'] = 'Llwytho ffeil newydd i fyny';
$string['uploadnofilefound'] = 'Heb ddod o hyd i ffeil - ydych chi\'n siŵr eich bod wedi dewis un i\'w llwytho i fyny?';
$string['uploadnotallowed'] = 'Ni ganiatier llwytho ffeiliau i fyny';
$string['uploadnotempdir'] = 'Ffolder dros dro ar goll';
$string['uploadoldfilesdeleted'] = 'Wedi dileu\'r hen ffeil(iau) yn yr adran llwytho i fyny';
$string['uploadpartialfile'] = 'Rhan o\'r ffeil yn unig sydd wedi\'i llwytho i fyny';
$string['uploadproblem'] = 'Cododd problem anhysbys wrth geisio llwytho\'r ffeil \'{$a}\' (efallai ei bod hi\'n rhy fawr?)';
$string['uploadrenamedchars'] = 'Wedi newid enw\'r ffeil o {$a->oldname} i {$a->newname} oherwydd bod ynddo nodau annilys.';
$string['uploadrenamedcollision'] = 'Wedi newid enw\'r ffeil o {$a->oldname} i {$a->newname} oherwydd gwrthdaro yn enw\'r ffeil.';
$string['uploadserverlimit'] = 'Mae\'r ffeil a lwythwyd i fyny yn fwy na\'r maint mwyaf a bennwyd gan y gweinydd';
$string['uploadthisfile'] = 'Llwytho\'r ffeil hon i fyny';
$string['url'] = 'URL';
$string['used'] = 'Wedi defnyddio';
$string['usedinnplaces'] = 'Wedi\'i ddefnyddio mewn {$a} man';
$string['usemessageform'] = 'neu defnyddiwch y ffurflen isod i anfon neges at y myfyrwyr a ddewiswyd';
$string['user'] = 'Defnyddiwr';
$string['userconfirmed'] = 'Wedi cadarnhau {$a}';
$string['usercurrentsettings'] = 'Fy ngosodiadau proffil';
$string['userdata'] = 'Data defnyddiwr';
$string['userdeleted'] = 'Mae\'r cyfrif defnyddiwr hwn wedi\'i ddileu';
$string['userdescription'] = 'Disgrifiad';
$string['userdescription_help'] = 'Mae\'r blwch hwn yn eich galluogi i ychwanegu rhywfaint o destun amdanoch eich hun a fydd yn ymddangos ar eich tudalen broffil i eraill ei weld.';
$string['userdetails'] = 'Manylion defnyddiwr';
$string['userfiles'] = 'Ffeiliau defnyddiwr';
$string['userlist'] = 'Rhestr defnyddwyr';
$string['username'] = 'Enw Defnyddiwr';
$string['usernameemailmatch'] = 'Nid yw\'r enw defnyddiwr a\'r cyfeirad e-bost yn cyfeirio at yr un defnyddiwr';
$string['usernameexists'] = 'Mae\'r enw defnyddiwr hwn yn bodoli eisioes, dewisiwch un gwahanol';
$string['usernamelowercase'] = 'Rhaid defnyddio llythrennau bach yn unig';
$string['usernamenotfound'] = 'Heb ddod o hyd i\'r enw defnyddiwr yn y gronfa ddata';
$string['usernameoremail'] = 'Rhowch enw defnyddiwr neu gyfeiriad e- bost';
$string['usernotconfirmed'] = 'Heb lwyddo i gadarnhau {$a}';
$string['userpic'] = 'Llun y defnyddiwr';
$string['users'] = 'Defnyddwyr';
$string['userselectorautoselectunique'] = 'Os mai dim ond un defnyddiwr sy\'n cyfateb, yna dylid dewis y defnyddiwr hwnnw\'n awtomatig.';
$string['userselectorpreserveselected'] = 'Cadw\'r defnyddwyr a ddewiswyd, hyd yn oed os nad ydyn nhw\'n cyfateb i\'r chwiliad mwyach';
$string['userselectorsearchanywhere'] = 'Cyfateb y testun y chwiliwyd amdano yn rhywle yn enw\'r defnyddiwr';
$string['usersnew'] = 'Defnyddwyr newydd';
$string['usersnoaccesssince'] = 'Anweithredol am fwy na';
$string['userswithfiles'] = 'Defnyddwyr gyda ffeiliau';
$string['useruploadtype'] = 'Dull o lwytho defnyddwyr i fyny: {$a}';
$string['userviewingsettings'] = 'Gosodiadau proffil ar gyfer {$a}';
$string['userzones'] = 'Parthau defnyddiwr';
$string['usetheme'] = 'Defnyddio thema';
$string['usingexistingcourse'] = 'Defnyddio cod sy\'n bodoli eisoes';
$string['valuealreadyused'] = 'Mae\'r gwerth hwn eisoes wedi cael ei ddefnyddio';
$string['version'] = 'Fersiwn';
$string['view'] = 'Gweld';
$string['viewallcourses'] = 'Gweld pob cwrs';
$string['viewallcoursescategories'] = 'Gweld pob cwrs a chategori';
$string['viewallsubcategories'] = 'Gweld pob is-gategori';
$string['viewfileinpopup'] = 'Gweld y ffeil mewn ffenestr naid';
$string['viewing'] = 'Gweld:';
$string['viewmore'] = 'Gweld mwy';
$string['viewprofile'] = 'Gweld proffil';
$string['views'] = 'Gweld';
$string['viewsolution'] = 'gweld yr ateb';
$string['virusfound'] = 'Weinyddwr! Mae Clam AV wedi dod o hyd i firws yn y ffeil a lwythwyd i fyny gan {$a->user} ar gyfer y cwrs {$a->course}. Dyma ganlyniad sgan y clam:';
$string['virusfoundlater'] = 'Sylwyd bod ffeil y gwnaethoch ei llwytho i fyny ar {$a->date} dan yr enw {$a->filename} ar gyfer y cwrs {$a->course} cynnwys firws. Dyma grynodeb o\'r hyn a ddigwyddodd i\'ch ffeil:

{$a->action}

Os mai gwaith i\'w gyflwyno oedd hwn, efallai eich bod am ei ailgflwyno fel y gall eich tiwtor ei ddarllen.';
$string['virusfoundlateradmin'] = 'Weinyddwr! Sylwyd bod ffeil a lwythwyd i fyny ar {$a->date} dan yr enw {$a->filename} ar gyfer y cwrs {$a->course} gan {$a->user} yn cynnwys firws. Dyma grynodeb o\'r hyn a ddigwyddodd i\'r ffeil:

{$a->action}

Rwyf wedi hysbysu\'r defnyddiwr hefyd.';
$string['virusfoundlateradminnolog'] = 'Weinyddwr! Sylwyd bod ffeil a lwythwyd i fyny dan yr enw {$a->filename} yn cynnwys firws. Nid oedd Moodle wedi gallu olrhain y ffeil hon yn ôl i\'r defnyddiwr a wnaeth ei llwytho i fyny\'n wreiddiol.

Dyma grynodeb o\' hyn a ddigwyddodd i\'r ffeil:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: Wedi dod o hyd i firws!';
$string['virusfounduser'] = 'Mae\'r ffeil y gwnaethoch ei llwytho i fyny, {$a->filename}, wedi cael ei sganio gan wiriwr firysau. Sylwyd bod firws ar y ffeil! NI wnaeth eich ffeil lwytho i fyny\'n llwyddiannus.';
$string['virusplaceholder'] = 'Sylwyd bod y ffeil hon a lwythwyd i fyny\'n cynnwys firws. Mae hi wedi cael ei symud neu ei dileu a rhoddwyd gwybod i\'r defnyddiwr.';
$string['visible'] = 'Gweladwy';
$string['visible_help'] = 'Mae\'r gosodiad hwn yn pennu a yw\'r cwrs yn ymddangos yn y rhestr cyrsiau. Ac eithio athrawon a gweinyddwyr, dydy defnyddwyr ddim yn cael mynd i mewn i\'r cwrs.';
$string['visibletostudents'] = 'Yn weladwy i {$a}';
$string['warning'] = 'Rhybudd';
$string['warningdeleteresource'] = 'Rhybudd: Cyfeiriwyd at {$a} mewn adnodd. Ydych chi am ddiweddaru\'r adnodd?';
$string['webpage'] = 'Tudalen we';
$string['week'] = 'Wythnos';
$string['weekhide'] = 'Cuddio\'r wythnos hon oddi wrth {$a}';
$string['weeklyoutline'] = 'Amlinelliad wythnosol';
$string['weeks'] = 'wythnos';
$string['weekshow'] = 'Dangos yr wythnos hon i {$a}';
$string['welcometocourse'] = 'Croeso i {$a}';
$string['welcometocoursetext'] = 'Croeso i {$a->coursename}!
Os nad ydych wedi gwneud eisoes, dylech olygu\'ch tudalen proffil fel y gallwn ddysgu mwy amdanoch:
  {$a->profileurl}';
$string['whatforlink'] = 'Beth ydych chi eisiau ei wneud gyda\'r ddolen?';
$string['whatforpage'] = 'Beth ydych chi eisiau ei wneud gyda\'r testun?';
$string['whattocallzip'] = 'Beth ydych chi eisiau galw\'r ffeil zip?';
$string['whattodo'] = 'Beth i\'w wneud';
$string['windowclosing'] = 'Dylai\'r ffenestr gau\'n awtomatig. Os nad yw hynny\'n digwydd, dylech ei chau nawr.';
$string['withchosenfiles'] = 'Gyda\'r ffeiliau a ddewiswyd';
$string['withdisablednote'] = '{$a} (wedi\'i analluogi)';
$string['withoutuserdata'] = 'heb ddata\'r defnyddwyr';
$string['withselectedusers'] = 'Gyda\'r defnyddwyr a ddewiswyd...';
$string['withselectedusers_help'] = '* Anfon neges - Anfon neges at fwy nag un cyfranogwr
* Ychwanegu nodyn newydd - Rhoi nodyn i gyfranogwr a ddewiswyd
* Ychwanegu nodyn cyffredin - Rhoi\'r un nodyn i fwy nag un cyfranogwr
* Estyniad i\'r cyfnod cofrestru (unigolyn) - Estyniad i\'r cyfnod y gall myfyrwyr a ddewiswyd gael mynediad at y cwrs, hyd yn oed os ydych wedi gosod cyfnod ar gyfer cofrestru
* Estyniad i\'r cyfnod cofrestru (cyffredin) - Estyniad o\'r un hyd i\'r cyfnod y gall mwy nag un myfyriwr gael mynediad at y cwrs.';
$string['withuserdata'] = 'gyda data defnyddwyr';
$string['wordforstudent'] = 'Eich gair ar gyfer Myfyriwr';
$string['wordforstudenteg'] = 'e.e. Myfyriwr, Cyfranogwr ayb';
$string['wordforstudents'] = 'Eich gair ar gyfer Myfyrwyr';
$string['wordforstudentseg'] = 'e.e. Myfyrwyr, Cyfranogwyr ayb';
$string['wordforteacher'] = 'Eich gair ar gyfer Athro';
$string['wordforteachereg'] = 'e.e. Athro, Tiwtor, Hyrwyddwr ayb';
$string['wordforteachers'] = 'Eich gair ar gyfer Athrawon';
$string['wordforteacherseg'] = 'e.e.Athrawon, Tiwtoriaid, Hwyluswyr ayb';
$string['writingblogsinfo'] = 'Gwybodaeth am ysgrifennu blogiau';
$string['writingcategoriesandquestions'] = 'Wrthi\'n ysgrifennu categorïau a chwestiynau';
$string['writingcoursedata'] = 'Wrthi\'n ysgrifennu data\'r cwrs';
$string['writingeventsinfo'] = 'Wrthi\'n ysgrifennu gwybodaeth am ddigwyddiadau';
$string['writinggeneralinfo'] = 'Wrthi\'n ysgrifennu gwybodaeth gyffredinol';
$string['writinggradebookinfo'] = 'Wrthi\'n ysgrifennu gwybodaeth am y llyfr graddau';
$string['writinggroupingsgroupsinfo'] = 'Gwybodaeth am ysgrifennu carfanau/grwpiau';
$string['writinggroupingsinfo'] = 'Wrthi\'n ysgrifennu gwybodaeth am drefn y grwpiau';
$string['writinggroupsinfo'] = 'Wrthi\'n ysgrifennu gwybodaeth am y grwpiau';
$string['writingheader'] = 'Wrthi\'n ysgrifennu pennawd';
$string['writingloginfo'] = 'Wrthi\'n ysgrifennu gwybodaeth log';
$string['writingmessagesinfo'] = 'Wrthi\'n ysgrifennu gwybodaeth am negeseuon';
$string['writingmoduleinfo'] = 'Wrthi\'n ysgrifennu gwybodaeth am fodiwlau';
$string['writingscalesinfo'] = 'Wrthi\'n ysgrifennu gwybodaeth am raddau';
$string['writinguserinfo'] = 'Wrthi\'n ysgrifennu gwybodaeth am ddefnyddwyr';
$string['wrongpassword'] = 'Cyfrinair anghywir ar gyfer yr enw defnyddiwr hwn';
$string['yahooid'] = 'ID Yahoo';
$string['year'] = 'blwyddyn';
$string['years'] = 'blynyddoedd';
$string['yes'] = 'Iawn';
$string['youareabouttocreatezip'] = 'Rydych chi ar fin creu ffeil zip yn cynnwys';
$string['youaregoingtorestorefrom'] = 'Rydych chi ar fin cychwyn y broses adfer ar gyfer';
$string['youneedtoenrol'] = 'Rhaid i chi gofrestru ar y cwrs hwn cyn gwneud hynny.';
$string['yourlastlogin'] = 'Y tro diwethaf i chi fewngofnodi oedd';
$string['yourself'] = 'eich hun';
$string['yourteacher'] = 'eich {$a}';
$string['yourwordforx'] = 'Eich gair am \'{$a}\'';
$string['zippingbackup'] = 'Wrthi\'n zipio copi wrth gefn';
