<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'cy', branch 'MOODLE_24_STABLE'
 *
 * @package   local_amos
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '<p>Byrfodd yw AMOS o \'Automated Manipulation Of Strings\'. Storfa ganolog o linynnau Moodle a\'u hanes yw AMOS. Mae\'n tracio llinynnau ychwanegol sy\'n cael eu hychwanegu at god Saesneg Moodle, yn casglu\'r cyfieithiadau, yn delio â\'r tasgau cyfieithu cyffredin ac yn cynhyrchu pecynnau iaith i\'w defnyddio ar weinyddion Moodle.</p> <p>Ewch i <a href="http://docs.moodle.org/en/AMOS">dogfennau AMOS</a> i gael rhagor o wybodaeth.</p>';
$string['amos'] = 'AMOS - offeryn cyfieithu Moodle';
$string['amos:commit'] = 'Cyflwyno\'r llinynnau a lwyfannwyd i\'r brif storfa';
$string['amos:execute'] = 'Gweithredu\'r AMOScript a roddwyd';
$string['amos:importfile'] = 'Mewngludo\'r llinynnau o\'r ffeil a lwythwyd i fyny';
$string['amos:manage'] = 'Rheoli\'r porth AMOS';
$string['amos:stage'] = 'Defnyddio offeryn cyfieithu AMOS a llwyfannu\'r llinynnau';
$string['amos:stash'] = 'Storio\'r llinynnau presennol a lwyfannwyd yn y boced barhaus';
$string['commitbutton'] = 'Cyflwyno';
$string['commitmessage'] = 'Cyflwyno\'r neges';
$string['commitstage'] = 'Cyflwyno\'r llinynnau a lwyfannwyd';
$string['commitstage_help'] = 'Storio\'r holl gyfieithiadau a lwyfannwyd yn storfa AMOS. Caiff y rhain eu tocio a\'u hail-leoli cyn eu cyflwyno. Dim ond llinynnau y gellir eu cyflwyno sy\'n cael eu storio. Mae hynny\'n golygu mai dim ond cyfieithiadau gyda lliw cefndir gwyrdd fydd yn cael eu storio. Bydd y llinynnau a lwyfannwyd yn cael eu clirio ar ôl eu cyflwyno.';
$string['committableall'] = 'pob iaith';
$string['committablenone'] = 'dim hawl i\'r un iaith - cysylltwch â\'ch rheolwr AMOS';
$string['componentsall'] = 'Y cyfan';
$string['componentsnone'] = 'Dim un';
$string['componentsstandard'] = 'Safonol';
$string['confirmaction'] = 'Does dim modd dadwneud hyn. Ydych chi\'n siŵr?';
$string['contribaccept'] = 'Derbyn';
$string['contribactions'] = 'Camau\'r cyfieithiadau a gyfrannwyd';
$string['contribactions_help'] = 'Yn dibynnu ar eich hawliau a\'r llif gwaith cyfraniadau, mae\'n bosib y bydd rhai o\'r camau hyn ar gael i chi: * Defnyddio - copïo\'r cyfieithiadau a gyfrannwyd i\'ch llwyfan terfynol. Dydy hwn ddim yn newid cofnod y cyfraniadau * Neilltuo i fi - penodwch eich hun fel neilltuwr cyfraniadau, hynny yw, y person sy\'n gyfrifol am adolygu ac integreiddio cyfraniadau * Tynnu enw - peidio penodi neb fel neilltuwr cyfraniadau * Dechrau\'r adolygiad - neilltuo\'r cyfraniad newydd i chi\'ch hun, newid ei statws i \'Wrthi\'n adolygu\' a chopïo\'r cyfieithiadau a gynigwyd i\'ch llwyfan terfynol chi * Derbyn - marcio bod y cyfraniad wedi\'i dderbyn * Gwrthod - marcio bod y cyfraniad wedi\'i wrthod. Dylech roi\'r rheswm yn y blwch sylwadau. Bydd y cyfrannwr yn cael neges e-bost pan fydd statws ei gyfraniad yn newid.';
$string['contribapply'] = 'Defnyddio';
$string['contribassignee'] = 'Neilltuwr';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'Neilltuo i fi';
$string['contribauthor'] = 'Awdur';
$string['contribclosedno'] = 'Cuddio\'r cyfraniadau sydd wedi\'u datrys';
$string['contribclosedyes'] = 'Dangos y cyfraniadau sydd wedi\'u datrys';
$string['contribcomponents'] = 'Cydrannau';
$string['contribid'] = 'ID';
$string['contribincomingnone'] = 'Dim cyfraniadau wedi dod i mewn';
$string['contribincomingsome'] = 'Cyfraniadau sy\'n dod i mewn ({$a})';
$string['contriblanguage'] = 'Iaith';
$string['contribreject'] = 'Gwrthod';
$string['contribresign'] = 'Tynnu enw';
$string['contribstaged'] = 'Cyfraniad ar lwyfan <a href="contrib.php?id={$a->id}">#{$a->id}</a> gan {$a->author}';
$string['contribstagedinfo'] = 'Cyfraniad wedi\'i lwyfannu';
$string['contribstagedinfo_help'] = 'Mae\'r llwyfan yn cynnwys llinynnau a gyfranwyd gan aelod o\'r gymuned. Dylai cynhalwyr y pecyn iaith eu hadolygu ac yna eu derbyn (os ydynt wedi\'u cyflwyno) neu eu Gwrthod (os na ellir eu cynnwys yn y pecyn iaith swyddogol am ryw reswm).';
$string['contribstartreview'] = 'Dechrau adolygu';
$string['contribstatus'] = 'Statws';
$string['contribstatus0'] = 'Newydd';
$string['contribstatus10'] = 'Wrthi\'n adolygu';
$string['contribstatus20'] = 'Wedi gwrthod';
$string['contribstatus30'] = 'Wedi derbyn';
$string['contribstatus_help'] = 'Mae llif gwaith cyfieithiadau a gynigwyd yn cynnwys y camau canlynol: * Newydd - mae\'r cyfraniad wedi\'i gynnig ond heb gael ei adolygu eto * Wrthi\'n adolygu - mae\'r cyfraniad wedi\'i neilltuo i berson sy\'n cynnal y pecyn iaith ac mae hwnnw wrthi\'n ei adolygu * Wedi gwrthod - mae\'r person sy\'n cynnal y pecyn iaith wedi gwrthod y cyfraniad ac wedi rhoi esboniad yn y blwch sylwadau * Wedi derbyn - mae\'r person sy\'n cynnal y pecyn iaith wedi derbyn y cyfraniad';
$string['contribstrings'] = 'Llinynnau';
$string['contribstringseq'] = '{$a->orig} newydd';
$string['contribstringsnone'] = '{$a->orig} (mae pob un eisoes wedi\'i gyfieithu yn y pecyn iaith)';
$string['contribstringssome'] = '{$a->orig} (mae gan {$a->same} ohonynt gyfieithiad mwy diweddar yn barod)';
$string['contribsubject'] = 'Pwnc';
$string['contribsubmittednone'] = 'Dim cyfraniadau wedi\'u cynnig';
$string['contribsubmittedsome'] = 'Eich cyfraniadau chi ({$a})';
$string['contribtimemodified'] = 'Wedi\'i addasu';
$string['contributions'] = 'Cyfraniadau';
$string['diff'] = 'Cymharu';
$string['diffaction'] = 'Os ydych yn canfod rhywbeth gwahanol';
$string['diffaction1'] = 'Llwyfannu\'r ddau gyfieithiad ar eu canghennau';
$string['diffaction2'] = 'Llwyfannu\'r cyfieithiad mwyaf diweddar ar y ddwy gangen.';
$string['diffmode'] = 'Llwyfannu\'r llinynnau os yw\'r:';
$string['diffmode1'] = 'Llinynnau Saesneg wedi\'u newid ond nid y cyfieithiadau';
$string['diffmode2'] = 'Llinynnau Saesneg heb newid ond bod y cyfieithiadau wedi';
$string['diffmode3'] = 'Llinynnau Saesneg neu\'r cyfieithiadau wedi newid (ond nid y ddau)';
$string['diffmode4'] = 'Llinynnau Saesneg a\'r cyfieithiadau wedi newid';
$string['diffprogress'] = 'Cymharu\'r canghennau a ddewiswyd';
$string['diffprogressdone'] = 'Wedi canfod {$a} gwahaniaeth';
$string['diffstaged'] = 'gwahaniaeth';
$string['diffstrings'] = 'Cymharu llinynnau mewn dwy gangen';
$string['diffstrings_help'] = 'Bydd hyn yn cymharu\'r holl linynnau yn y ddwy gangen a ddewiswyd. Os yw\'r llinynnau\'n wahanol ar y canghennau, bydd y ddwy fersiwn yn cael eu llwyfannu. Yna gallwch ddefnyddio\'r nodwedd "Golygu\'r llinynnau wedi\'u llwyfannu" i adolygu a thrwsio\'r newidiadau fel y bo angen.';
$string['diffversions'] = 'Fersiynau';
$string['emailacceptbody'] = 'Mae\'r person sy\'n cynnal y pecyn iaith {$a->assignee} wedi derbyn y cyfieithiadau a gynigwyd gennych #{$a->id} {$a->subject}.

Ewch i {$a->url} am ragor o fanylion.';
$string['emailacceptsubject'] = '[Cyfraniad AMOS] Wedi\'i dderbyn';
$string['emailcontributionbody'] = 'Mae {$a->author} wedi cynnig cyfieithiadau newydd #{$a->id} {$a->subject}.

Ewch i {$a->url} am ragor o fanylion.';
$string['emailcontributionsubject'] = '[Cyfraniad AMOS] Cyfieithiadau newydd wedi\'u cynnig';
$string['emailrejectbody'] = 'Mae\'r person sy\'n cynnal y pecyn iaith {$a->assignee} wedi gwrthod y cyfieithiadau a gynigwyd gennych #{$a->id} {$a->subject}.

Ewch i {$a->url} am ragor o fanylion.';
$string['emailrejectsubject'] = '[AMOS contribution] Wedi\'i wrthod';
$string['emailreviewbody'] = 'Mae\'r person sy\'n cynnal y pecyn iaith {$a->assignee} wedi dechrau adolygu eich cyfieithiad  #{$a->id} {$a->subject}.

Ewch i {$a->url} am ragor o fanylion.';
$string['emailreviewsubject'] = '[AMOS contribution] Wedi dechrau adolygu';
$string['err_exception'] = 'Gwall: {$a}';
$string['err_invalidlangcode'] = 'Cod iaith annilys';
$string['err_parser'] = 'Gwall dosrannu: {$a}';
$string['filtercmp'] = 'Cydrannau';
$string['filtercmp_desc'] = 'Dangos llinynnau\'r cydrannau hyn';
$string['filterlng'] = 'Ieithoedd';
$string['filterlng_desc'] = 'Dangos cyfieithiadau yn yr ieithoedd hyn';
$string['filtermis'] = 'Amrywiol';
$string['filtermis_desc'] = 'Amodau ychwanegol ar y llinynnau i\'w dangos';
$string['filtermisfglo'] = 'dim ond llinynnau lliw llwyd';
$string['filtermisfhlp'] = 'dim ond llinynnau help';
$string['filtermisfmis'] = 'dim ond llinynnau coll a hen linynnau';
$string['filtermisfstg'] = 'dim ond llinynnau wedi\'u llwyfannu';
$string['filtermisfwog'] = 'heb linynnau lliw llwyd';
$string['filtersid'] = 'Nod adnabod llinyn';
$string['filtersid_desc'] = 'Yr allwedd yn yr arae o linynnau';
$string['filtersidpartial'] = 'cyfateb yn rhannol';
$string['filtertxt'] = 'Is-linyn';
$string['filtertxtcasesensitive'] = 'llythrennau bach/mawr';
$string['filtertxt_desc'] = 'Rhaid i\'r llinyn gynnwys testun a nodwyd';
$string['filtertxtregex'] = 'myneg. rheol.';
$string['filterver'] = 'Fersiynau';
$string['filterver_desc'] = 'Dangos llinynnau o\'r fersiynau Moodle hyn';
$string['found'] = 'Wedi canfod: {$a->found} &nbsp;&nbsp;&nbsp; Ar goll: {$a->missing} ({$a->missingonpage})';
$string['foundinfo'] = 'Nifer y llinynnau sydd wedi dod i glawr';
$string['foundinfo_help'] = 'Mae hwn yn dangos cyfanswm nifer y rhesi yn nhabl y cyfieithydd, nifer y cyfieithiadau sydd ar goll a nifer y cyfieithiadau sydd ar goll yn y dudalen bresennol.';
$string['gotofirst'] = 'mynd i\'r dudalen gyntaf';
$string['gotoprevious'] = 'mynd i\'r dudalen flaenorol';
$string['greylisted'] = 'Llinynnau lliw llwyd';
$string['greylisted_help'] = 'Oherwydd hen fersiynau, mae\'n bosib y bydd pecyn iaith Moodle yn cynnwys llinynnau nad ydynt yn cael eu defnyddio mwyach ond nid ydynt wedi cael eu dileu eto. Mae\'r llinynnau hyn wedi\'u \'lliwio\'n llwyd\'. Ar ôl cadarnhau nad yw llinyn lliw llwyd yn cael ei ddefnyddio mwyach, caiff ei dynnu o\'r pecyn iaith.

Os ydych chi\'n sylwi ar linyn lliw llwyd sy\'n cael ei ddefnyddio yn Moodle o hyd, yna rhowch wybod i ni drwy anfon neges at y fforwm yn y cwrs Cyfieithu Moodle ar y safle hwn. Fel arall, gallwch arbed amser gwerthfawr drwy gyfieithu llinynnau sy\'n fwy tebygol o gael eu defnyddio yn Moodle ac anwybyddu llinynnau lliw llwyd.';
$string['greylistedwarning'] = 'llinyn wedi\'i liwio\'n llwyd';
$string['importfile'] = 'Mewngludo\'r llinynnau a gyfieithwyd o ffeil';
$string['importfile_help'] = 'Os ydych wedi cyfieithu eich llinynnau all-lein, yna gallwch eu llwyfannu drwy ddefnyddio\'r ffurflen hon.

* Rhaid i\'r ffeil fod yn ffeil ddiffinio llinynnau PHP Moodle ddilys. Edrychwch ar gyfeiriadur `/lang/en/` eich rhaglen Moodle am enghreifftiau.
* Rhaid i enw\'r ffeil gyfateb â diffiniad y llinynnau Saesneg ar gyfer y gydran dan sylw (fel `moodle.php`, `assignment.php` neu  `enrol_manual.php`).

Bydd pob llinyn a welir yn y ffeil yn cael ei lwyfannu ar gyfer y fersiwn a\'r iaith a ddewiswyd.';
$string['language'] = 'Iaith';
$string['languages'] = 'Ieithoedd';
$string['languagesall'] = 'Y cyfan';
$string['languagesnone'] = 'Dim';
$string['log'] = 'Log';
$string['logfilterbranch'] = 'Fersiynau';
$string['logfiltercommithash'] = 'git hash';
$string['logfiltercommitmsg'] = 'Cynnwys y neges gyflwyno';
$string['logfiltercommits'] = 'Hidlydd cyflwyno';
$string['logfiltercommittedafter'] = 'Wedi cyflwyno ar ôl';
$string['logfiltercommittedbefore'] = 'Wedi cyflwyno cyn';
$string['logfiltercomponent'] = 'Cydrannau';
$string['logfilterlang'] = 'Ieithoedd';
$string['logfiltershow'] = 'Dangos yr hyn a gyflwynwyd a\'r llinynnau wedi\'u hidlo';
$string['logfiltersource'] = 'Ffynhonnell';
$string['logfiltersourceamos'] = 'amos (cyfieithydd ar y we)';
$string['logfiltersourcebot'] = 'bot (gweithrediadau swmp a gyflawnwyd gan sgript)';
$string['logfiltersourcecommitscript'] = 'commitscript (AMOScript yn y neges gyflwyno)';
$string['logfiltersourcefixdrift'] = 'fixdrift (drifft AMOS-git wedi\'i drwsio)';
$string['logfiltersourcegit'] = 'git (drych git o god ffynhonnell Moodle a phecynnau 1.x)';
$string['logfiltersourcerevclean'] = 'revclean (proses langau gwrthdro)';
$string['logfilterstringid'] = 'Nod dynodi\'r llinyn';
$string['logfilterstrings'] = 'Hidlydd llinynnau';
$string['logfilterusergrp'] = 'Cyflwynydd';
$string['logfilterusergrpor'] = 'neu';
$string['maintainers'] = 'Cynhalwyr';
$string['markuptodate'] = 'Marcio\'r cyfieithiad fel un cywir';
$string['markuptodate_help'] = 'Mae AMOS yn credu bod y llinyn yn hen gan fod y fersiwn Saesneg wedi\'i addasu ar ôl cyfieithu\'r llinyn. Adolygwch y cyfieithiad. Os yw\'n gywir, rhowch dic yn y blwch. Fel arall, dylech olygu\'r cyfieithiad.';
$string['merge'] = 'Cyfuno';
$string['mergestrings'] = 'Cyfuno llinynnau o gangen arall';
$string['mergestrings_help'] = 'Bydd hyn yn dewis ac yn llwyfannu\'r holl linynnau o\'r gangen ffynhonnell sydd heb eu cyfieithu eto yn y gangen targed ac yn eu defnyddio. Gallwch ddefnyddio\'r offeryn hwn i gopïo llinyn wedi\'i gyfieithu i bob fersiwn arall o\'r pecyn. Dim ond y rheini sy\'n cynnal y pecyn iaith sy\'n gallu defnyddio\'r offeryn hwn.';
$string['newlanguage'] = 'Iaith newydd';
$string['nodiffs'] = 'Heb ganfod dim un gwahaniaeth';
$string['nofiletoimport'] = 'Dewiswch ffeil i fewngludo ohoni.';
$string['nologsfound'] = 'Heb ganfod llinyn. Newidiwch yr hidlyddion';
$string['nostringsfound'] = 'Heb ganfod llinyn';
$string['nostringsfoundonpage'] = 'Heb ganfod llinyn ar dudalen {$a}';
$string['nostringtoimport'] = 'Heb ganfod llinyn dilys yn y ffeil. Gwnewch yn siŵr bod enw\'r ffeil yn gywir a\'i bod wedi cael ei fformatio\'n briodol.';
$string['nothingtomerge'] = 'Dydy\'r gangen ffynhonnell ddim yn cynnwys unrhyw linynnau newydd sydd ar goll yn y gangen darged. Does dim byd i\'w gyfuno.';
$string['nothingtostage'] = 'Dydy\'r weithred heb ganfod llinyn y gellid ei lwyfannu.';
$string['numofcommitsabovelimit'] = 'Wedi canfod {$a->found} a gyflwynwyd sy\'n cyfateb i\'r hidlydd cyflwyno, gan ddefnyddio\'r {$a->limit} mwyaf diweddar';
$string['numofcommitsunderlimit'] = 'Wedi canfod {$a->found} a gyflwynwyd sy\'n cyfateb i\'r hidlydd cyflwyno';
$string['numofmatchingstrings'] = 'O\'r rheini, mae {$a->strings} newid yn y {$a->commits} a gyflwynwyd yn cyfateb â\'r hidlydd llinyn';
$string['outdatednotcommitted'] = 'Hen linyn';
$string['outdatednotcommitted_help'] = 'Mae AMOS yn credu bod y llinyn yn hen gan fod y fersiwn Saesneg wedi\'i newid ar ôl ei gyfieithu. Tarwch olwg dros y cyfieithiad.';
$string['outdatednotcommittedwarning'] = 'hen';
$string['ownstashactions'] = 'Gweithredoedd pocedu';
$string['ownstashactions_help'] = '* Defnyddio - copïo\'r llinynnau a gyfieithwyd o\'r boced i\'r llwyfan a gadael y boced heb ei newid. Os yw\'r llinyn ar y llwyfan yn barod, bydd y llinyn yn y boced yn ysgrifennu drosto. * Pop - symud y llinynnau a gyfieithwyd o\'r boced i\'r llwyfan terfynol a gollwng cynnwys y boced (hynny yw, Defnyddio a Gollwng). * Gollwng - taflu\'r llinynnau yn y boced i\'r neilltu. * Anfon - agor ffurflen ar gyfer anfon cynnwys y boced i\'r sawl sy\'n cynnal y pecyn iaith fel y gallant gynnwys eich cyfraniad yn y pecyn iaith swyddogol.';
$string['ownstashes'] = 'Eich pocedi';
$string['ownstashes_help'] = 'Dyma restr o\'ch holl bocedi.';
$string['ownstashesnone'] = 'Heb ganfod dim un o\'ch pocedi chi';
$string['permalink'] = 'dolen barhaol';
$string['placeholder'] = 'Dalfannau';
$string['placeholder_help'] = 'Datganiadau arbennig yw dalfannau megis `{$a}` neu `{$a->rhywbeth}` yn y llinyn. Bydd gwerth yn eu disodli pan fydd y llinyn yn cael ei argraffu. Mae\'n bwysig eu copïo\'n union fel ag y maent yn y llinyn gwreiddiol. Peidiwch â\'u cyfieithu na\'u newid o\'r chwith i\'r dde.';
$string['placeholderwarning'] = 'mae\'r llinyn yn cynnwys dalfan';
$string['pluginclasscore'] = 'Is-systemau craidd';
$string['pluginclassnonstandard'] = 'Ategion ansafonol';
$string['pluginclassstandard'] = 'Ategion safonol';
$string['pluginname'] = 'AMOS';
$string['presetcommitmessage'] = 'Mae {$a->author} wedi cyfrannu cyfieithiad #{$a->id}';
$string['presetcommitmessage2'] = 'Llinynnau a gyfunwyd ar goll o\'r gangen {$a->source} ar gyfer {$a->target}';
$string['presetcommitmessage3'] = 'Wrthi\'n trwsio\'r gwahaniaethau rhwng {$a->versiona} a {$a->versionb}';
$string['privileges'] = 'Eich breintiau';
$string['privilegesnone'] = 'Mae gennych fynediad darllen yn unig at wybodaeth gyhoeddus.';
$string['propagate'] = 'Lledaenu\'r cyfieithiadau';
$string['propagatednone'] = 'Heb ledaenu cyfieithiadau';
$string['propagatedsome'] = 'Wedi lledaenu {$a} cyfieithiad wedi\'u llwyfannu';
$string['propagate_help'] = 'Mae\'n bosib lledaenu cyfieithiadau wedi\'u llwyfannu i ganghennau a ddewiswyd. Mae AMOS yn ailedrych dros y rhestr o gyfieithiadau a lwyfannwyd ac yn ceisio eu defnyddio ar bob cangen targed a ddewiswyd. Does dim modd lledaenu os:

* yw fersiwn Saesneg gwreiddiol y llinyn yn wahanol ar y gangen ffynhonell a tharged,
* yw\'r llinyn wedi\'i lwyfannu sawl gwaith gyda chyfieithiad gwahanol';
$string['propagaterun'] = 'Lledaenu';
$string['requestactions'] = 'Gweithred';
$string['requestactions_help'] = '* Defnyddio - copïo\'r llinynnau a gyfieithwyd o\'r cais i dynnu i\'ch llwyfan. Os yw\'r llinyn eisoes ar y llwyfan terfynol, bydd y llinyn yn y boced yn ysgrifennu drosto. * Cuddio - yn rhwystro\'r cais i dynnu fel nad ydych yn ei weld mwyach.';
$string['savefilter'] = 'Cadw\'r gosodiadau hidlo';
$string['script'] = 'AMOScript';
$string['scriptexecute'] = 'Cyflawni a llwyfannu\'r canlyniad';
$string['script_help'] = 'Mae AMOScript yn gyfres o gyfarwyddiadau i gyflawni\'r broses o roi\'r llinynnau mewn storfa.';
$string['sourceversion'] = 'Fersiwn ffynhonnell';
$string['stage'] = 'Llwyfan';
$string['stageactions'] = 'Gweithredoedd llwyfannu';
$string['stageactions_help'] = '* Golygu\'r llinynnau a lwyfannwyd - addasu gosodiadau hidlo\'r cyfieithydd fel mai dim ond cyfieithiadau a lwyfannwyd sy\'n ymddangos. * Tocio\'r llinynnau na ellir eu llwyfannu - tynnu\'r holl gyfieithiadau oddi ar y llwyfan nad oes hawl gennych eu cyflwyno. Caiff y llwyfan ei docio\'n awtomatig cyn ei gyflwyno. * Ailosod - tynnu\'r holl gyfieithiadau oddi ar y llwyfan sydd naill ai ddim yn newid y cyfieithiad presennol neu sy\'n hŷn na\'r cyfieithiad mwyaf diweddar yn y storfa. Caiff y llwyfan ei ailosod yn awtomatig cyn ei gyflwyno. * Tynnu\'r cyfan oddi ar y llwyfan - mae hwn yn clirio\'r llwyfan a byddwch yn colli pob cyfieithiad sydd ar y llwyfan.';
$string['stageedit'] = 'Golygu\'r llinynnau a lwyfannwyd';
$string['stagelang'] = 'Iaith';
$string['stageoriginal'] = 'Gwreiddiol';
$string['stageprune'] = 'Tocio\'r llinynnau na ellir eu llwyfannu';
$string['stagerebase'] = 'Ailosod';
$string['stagestring'] = 'Llinyn';
$string['stagestringsnocommit'] = 'Mae {$a->staged} llinyn ar y llwyfan';
$string['stagestringsnone'] = 'Does dim un llinyn ar y llwyfan';
$string['stagestringssome'] = 'Mae {$a->staged} llinyn ar y llwyfan, gellir cyflwyno {$a->committable} ohonynt';
$string['stagesubmit'] = 'Anfon at y sawl sy\'n cynnal y pecyn iaith';
$string['stagetranslation'] = 'Cyfieithiad';
$string['stagetranslation_help'] = 'Mae\'n dangos y cyfieithiadau ar y llwyfan i\'w cyflwyno. Mae lliw cefndir y gell yn golygu: * Gwyrdd - rydych chi wedi ychwanegu cyfieithiad coll ac mae hawl gennych i\'w gyflwyno. * Melyn - rydych chi wedi newid llinyn ac mae hawl gennych i gyflwyno\'r newid. * Glas - rydych chi wedi newid y cyfieithiad neu wedi ychwanegu cyfieithiad coll, ond does dim hawl gennych i\'w gyflwyno i\'r iaith dan sylw. * Dim lliw - mae\'r cyfieithiad ar y llwyfan yr un peth â\'r un presennol felly ni fydd yn cael ei gyflwyno.';
$string['stageunstageall'] = 'Tynnu\'r cyfan oddi ar y llwyfan';
$string['stashactions'] = 'Gweithredoedd pocedu';
$string['stashactions_help'] = 'Mae\'r boced yn fraslun o\'r llwyfan presennol. Gellir anfon cynnwys pocedi at y sawl sy\'n cynnal y pecyn iaith er mwyn eu cynnwys yn y pecyn iaith.';
$string['stashapply'] = 'Defnyddio';
$string['stashautosave'] = 'Wedi cadw\'r boced wrth gefn yn awtomatig';
$string['stashautosave_help'] = 'Mae\'r boced yn cynnwys y braslun mwyaf diweddar o\'ch llwyfan. Gallwch ei ddefnyddio fel system wrth gefn, er enghraifft, os ydych yn tynnu\'r holl linynnau oddi ar y llwyfan yn ddamweiniol. Pwyswch \'Defnyddio\' i gopïo\'r holl linynnau yn y boced yn ôl i\'r llwyfan (bydd hyn yn ysgrifennu dros y llinyn os yw ar y llwyfan yn barod).';
$string['stashcomponents'] = '<span>Cydrannau:</span> {$a}';
$string['stashdrop'] = 'Gollwng';
$string['stashes'] = 'Pocedi';
$string['stashlanguages'] = '<span>Ieithoedd:</span> {$a}';
$string['stashpop'] = 'Pop';
$string['stashpush'] = 'Gwthio\'r holl linynnau a lwyfannwyd i boced newydd';
$string['stashstrings'] = '<span>Nifer y llinynnau:</span> {$a}';
$string['stashsubmit'] = 'Cyflwyno i gynhalwyr y pecyn iaith';
$string['stashsubmitdetails'] = 'Wrthi\'n cyflwyno manylion';
$string['stashsubmitmessage'] = 'Neges';
$string['stashsubmitsubject'] = 'Pwnc';
$string['stashtitle'] = 'Teitl y boced';
$string['stashtitledefault'] = 'WIP - {$a->time}';
$string['stringhistory'] = 'Hanes';
$string['strings'] = 'Llinynnau';
$string['submitting'] = 'Wrthi\'n cyflwyno cyfraniad';
$string['submitting_help'] = 'Bydd hyn yn anfon llinynnau a gyfieithwyd at gynhalwyr swyddogol y pecyn iaith. Byddant yn gallu rhoi eich gwaith ar eu llwyfan nhw a\'i gyflwyno\'n derfynol yn y pen draw. Dylech gynnwys neges iddynt yn disgrifio\'ch gwaith neu\'r  rheswm pam eich bod am weld eich gwaith yn y pecyn iaith.';
$string['targetversion'] = 'Fersiwn darged';
$string['translatorlang'] = 'Iaith';
$string['translatorlang_help'] = 'Mae hwn yn dangos cod yr iaith ar gyfer cyfieithu\'r llinyn. Cliciwch y ddolen <strong>+-</strong> i weld hanes llinell amser y llinyn.';
$string['translatororiginal'] = 'Gwreiddiol';
$string['translatororiginal_help'] = 'Mae hwn yn dangos Saesneg gwreiddiol y llinyn. Oddi tano, fe welwch ddolen i gyfieithu\'r llinyn yn awtomatig drwy Google Translate (os ydyw\'n gallu delio â\'r iaith ac oes yw Javascript wedi\'i alluogi ar eich porwr). Hefyd, efallai bod rhywfaint o wybodaeth ychwanegol ynghlwm, er enghraifft os yw\'r llinyn yn cynnwys dalfan.';
$string['translatorstring'] = 'Llinyn';
$string['translatorstring_help'] = 'Mae\'n dangos y gangen Moodle (fersiwn), nod adnabod y llinyn a\'r gydran y mae\'r llinyn yn perthyn iddo.';
$string['translatortool'] = 'Cyfieithydd';
$string['translatortranslation'] = 'Cyfieithu';
$string['translatortranslation_help'] = 'Cliciwch y gell er mwyn golygu\'r mewnbwn. Teipiwch y cyfieithiad a chliciwch y tu allan i\'r gell i roi\'r cyfieithiad ar y llwyfan. Dyma esboniadau o liwiau cefndir y gell:

* Gwyrdd - mae\'r llinyn eisoes wedi\'i gyfieithu ac rydych yn gallu newid y cyfieithiad a\'i gyflwyno.

* Melyn - mae\'n bosib cyflwyno\'r llinyn ond efallai ei fod yn hen gyfieithiad. Mae\'n bosib bod y fersiwn Saesneg wedi newid ers cyfieithu\'r llinyn.

* Coch - dydy\'r llinyn heb gael ei gyfieithu ac rydych chi\'n cael ei gyfieithu a\'i gyflwyno.

* Glas - rydych chi wedi newid y cyfieithiad ac mae nawr ar y llwyfan. Peidiwch ag anghofio cyflwyno\'r cyfieithiad cyn allgofnodi!

* Dim lliw - er eich bod yn gallu rhoi\'r cyfieithiad ar y llwyfan, does dim hawl gennych i\'w gyflwyno\'n derfynol i\'r pecyn iaith. Ond gallwch chi allgludo\'r llwyfan i ffeil.';
$string['typecontrib'] = 'Ategion nad ydynt yn safonol';
$string['typecore'] = 'Is-systemau craidd';
$string['typestandard'] = 'Ategion safonol';
$string['unstage'] = 'Tynnu oddi ar y llwyfan';
$string['unstageconfirm'] = 'Ydych chi\'n siŵr?';
$string['unstaging'] = 'Wrthi\'n tynnu oddi ar y llwyfan';
$string['version'] = 'Fersiwn';
