<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'cy', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Gweithgareddau';
$string['addcategory'] = 'Ychwanegu categori';
$string['addcategoryerror'] = 'Methu ychwanegu categori.';
$string['addexceptionerror'] = 'Digwyddodd gwall wrth ychwanegu eithriad at userid:gradeitem';
$string['addfeedback'] = 'Ychwanegu adborth';
$string['addgradeletter'] = 'Ychwanegu llythyren graddio';
$string['addidnumbers'] = 'Ychwanegu rhifau ID';
$string['additem'] = 'Ychwanegu eitem graddio';
$string['addoutcome'] = 'Ychwanegu deilliant';
$string['addoutcomeitem'] = 'Ychwanegu eitem deilliant';
$string['addscale'] = 'Ychwanegu graddfa';
$string['aggregateextracreditmean'] = 'Cymedr y graddau (gyda chredydau ychwanegol)';
$string['aggregatemax'] = 'Gradd uchaf';
$string['aggregatemean'] = 'Cymedr y graddau';
$string['aggregatemedian'] = 'Canolrif y graddau';
$string['aggregatemin'] = 'Gradd isaf';
$string['aggregatemode'] = 'Modd y graddau';
$string['aggregateonlygraded'] = 'Dim ond cyfuno graddau nad ydynt yn rhai gwag';
$string['aggregateonlygraded_help'] = 'Gradd sydd ar goll o\'r llyfr graddau yw gradd wag. Efallai ei bod ar goll gan fod aseiniad sydd wedi\'i gyflwyno heb gael gradd eto, neu gan fod cwis heb gael ei gwblhau ac yn y blaen.

Mae\'r gosodiad hwn yn pennu a yw graddau gwag yn cael eu hepgor o\'r broses gyfuno ynteu a ydynt yn cyfrif fel graddau minimal, er enghraifft 0 am aseiniad sy\'n cael gradd rhwng 0 a 100.';
$string['aggregateoutcomes'] = 'Cynnwys deilliannau wrth gyfuno';
$string['aggregateoutcomes_help'] = 'Os yw wedi\'i alluogi, caiff y deilliannau eu cynnwys wrth gyfuno. Gallai hyn arwain at gyfanswm annisgwyl ar gyfer y categori.';
$string['aggregatesonly'] = 'Graddau wedi\'u cyfuno yn unig';
$string['aggregatesubcats'] = 'Cyfuno gan gynnwys isgategorïau';
$string['aggregatesubcats_help'] = 'Mae\'r gosodiad hwn yn pennu a yw graddau yn yr isgategorïau yn cael eu cynnwys yn y broses gyfuno ai peidio.';
$string['aggregatesum'] = 'Swm y graddau';
$string['aggregateweightedmean'] = 'Cymedr pwysol y graddau';
$string['aggregateweightedmean2'] = 'Cymedr pwysol syml y graddau';
$string['aggregation'] = 'Cyfuno graddau';
$string['aggregationcoef'] = 'Cyfernod cyfuno';
$string['aggregationcoefextra'] = 'Credyd ychwanegol';
$string['aggregationcoefextra_help'] = 'Os yw\'r broses gyfuno yn golygu Swm graddau neu Gymedr pwysol syml a bod tic yn y blwch ticio credyd ychwanegol, ni fydd gradd uchaf bosib yr eitem graddio yn cael ei hychwanegu at radd uchaf bosib y categori, gan arwain at y posibilrwydd o gyrraedd y radd uchaf bosib (neu raddau dros yr uchaf posib os yw gweinyddwr y safle yn galluogi hynny) yn y categori heb fod â\'r radd uchaf bosib ym mhob eitem graddio.
Os yw\'r broses gyfuno yn arwain at Gymedr y graddau (gyda chredydau ychwanegol) a bod y credyd ychwanegol wedi\'i osod ar werth sy\'n fwy na sero, bydd y radd yn cael ei lluosi â\'r credyd ychwanegol cyn cael ei hychwanegu at y cyfanswm ar ôl cyfrifo\'r cymedr.';
$string['aggregationcoefextrasum'] = 'Credyd ychwanegol';
$string['aggregationcoefextrasum_help'] = 'Os oes tic yn y blwch ticio credyd ychwanegol, ni fydd gradd uchaf bosib yr eitem graddio yn cael ei hychwanegu at radd uchaf bosib y categori, gan arwain at y posibilrwydd o gyrraedd yr uchaf posib (neu raddau dros yr uchafswm os yw gweinyddwr y safle yn galluogi hynny) yn y categori heb fod â\'r radd uchaf bosib ym mhob eitem graddio.';
$string['aggregationcoefextraweight'] = 'Pwysau credyd ychwanegol';
$string['aggregationcoefextraweight_help'] = 'Os yw\'r pwysau credyd ychwanegol wedi\'i osod ar werth sy\'n fwy na sero, mae\'r radd yn gweithredu fel credyd ychwanegol yn ystod y broses gyfuno. Bydd y radd yn cael ei lluosi â\'r rhif cyn cael ei hychwanegu at y cyfanswm ar gyfer cyfrifo\'r cymedr.';
$string['aggregationcoefweight'] = 'Pwysau\'r eitem';
$string['aggregationcoefweight_help'] = 'Mae pwysau\'r eitem yn cael ei ddefnyddio wrth gyfuno\'r graddau ar gyfer categori er mwyn dylanwadu ar bwysigrwydd yr eitem o\'i chymharu ag eitemau graddio eraill yn yr un categori.';
$string['aggregation_help'] = 'Mae\'r broses gyfuno yn pennu sut mae graddau mewn categori yn cael eu cyfuno, megis
* Cymedr graddau - Swm yr holl raddau wedi\'i rannu â nifer y graddau
 * Canolrif y graddau - Y radd yn y canol pan fydd y graddau wedi\'u trefnu yn ôl maint
* Gradd isaf * Gradd uchaf * Modd graddau - Y radd sy\'n codi amlaf
* Swm y graddau - Swm y graddau i gyd, gan anwybyddu graddfeydd y graddau';
$string['aggregationposition'] = 'Lleoliad ar ôl cyfuno';
$string['aggregationposition_help'] = 'Mae\'r gosodiad hwn yn pennu a yw\'r colofnau ar gyfer cyfanswm y cwrs a\'r categori yn cael eu dangos ar ddechrau ynteu ddiwedd adroddiadau\'r llyfr graddau.';
$string['aggregationsvisible'] = 'Y dulliau cyfuno sydd ar gael';
$string['aggregationsvisiblehelp'] = 'Dewiswch pob math o gyfuno a ddylai fod ar gael. Daliwch y fysell Ctrl i lawr i ddewis mwy nag un eitem.';
$string['allgrades'] = 'Pob gradd yn ôl categori';
$string['allstudents'] = 'Pob Myfyriwr';
$string['allusers'] = 'Pob defnyddiwr';
$string['autosort'] = 'Awto drefnu';
$string['availableidnumbers'] = 'Rhifau ID sydd ar gael';
$string['average'] = 'Cyfartaledd';
$string['averagesdecimalpoints'] = 'Degolion yng nghyfartaleddau\'r colofnau';
$string['averagesdecimalpoints_help'] = 'Mae\'r gosodiad hwn yn pennu nifer y pwyntiau degol i\'w dangos ar gyfer pob cyfartaledd, neu a yw\'r gosodiad pwyntiau degol cyffredinol ar gyfer y categori neu\'r eitem graddio yn cael ei ddefnyddio (etifeddu).';
$string['averagesdisplaytype'] = 'Ffordd o ddangos cyfartaledd y colofnau';
$string['averagesdisplaytype_help'] = 'Mae\'r gosodiad hwn yn pennu a yw\'r cyfartaledd (cymedr) yn cael ei ddangos fel llythrennau, canrannau ynteu raddau real, ynteu a yw\'r ymddangosiad a ddefnyddir ar gyfer y categori neu\'r eitem graddio yn cael ei ddefnyddio (etifeddu).';
$string['backupwithoutgradebook'] = 'Nid yw\'r copi wrth gefn yn cynnwys ffurfweddiad Llyfr Graddau';
$string['badgrade'] = 'Mae\'r radd a ddarparwyd yn annilys';
$string['badlyformattedscale'] = 'Rhowch restr o werthoedd wedi\'u gwahanu gan gomas (mae angen dau werth o leiaf).';
$string['baduser'] = 'Mae\'r defnyddiwr a ddarparwyd yn annilys';
$string['bonuspoints'] = 'Pwyntiau Bonws';
$string['bulkcheckboxes'] = 'Blychau ticio torfol';
$string['calculatedgrade'] = 'Gradd a gyfrifwyd';
$string['calculation'] = 'Cyfrifiad';
$string['calculationadd'] = 'Ychwanegu cyfrifiad';
$string['calculationedit'] = 'Golygu cyfrifiad';
$string['calculation_help'] = 'Fformiwla a ddefnyddir i bennu graddau yw cyfrifiad gradd. Dylai\'r fformiwla gychwyn gyda symbol hafal (=) a gellir defnyddio gweithredyddion mathemategol cyffredin, megis \'max\', \'min\' a \'sum\'. Os dymunir, gellir cynnwys eitemau graddio eraill yn y cyfrifiad drwy deipio\'r rhifau ID mewn cromfachau sgwâr dwbl.';
$string['calculationsaved'] = 'Wedi cadw\'r cyfrifiad';
$string['calculationview'] = 'Gweld cyfrifiad';
$string['cannotaccessgroup'] = 'Yn anffodus, does dim modd cael mynediad at raddau\'r grŵp a ddewiswyd.';
$string['categories'] = 'Categorïau';
$string['categoriesanditems'] = 'Categorïau ac eitemau';
$string['categoriesedit'] = 'Golygu categorïau ac eitemau';
$string['category'] = 'Categori';
$string['categoryedit'] = 'Golygu categori';
$string['categoryname'] = 'Enw\'r categori';
$string['categorytotal'] = 'Cyfanswm y categori';
$string['categorytotalfull'] = 'Cyfanswm {$a->category}';
$string['categorytotalname'] = 'Enw cyfanswm categori';
$string['changedefaults'] = 'Newid dewisiadau diofyn';
$string['changereportdefaults'] = 'Newid dewisiadau adroddiadau diofyn';
$string['chooseaction'] = 'Dewis gweithred ...';
$string['choosecategory'] = 'Dewis categori';
$string['combo'] = 'Tabiau a Chwymplen';
$string['compact'] = 'Cywasgu';
$string['componentcontrolsvisibility'] = 'Y gosodiadau gweithgaredd sy\'n rheoli os yw\'r radd hon yn cael ei chuddio neu beidio.';
$string['contract'] = 'Lleihau categori';
$string['controls'] = 'Rheolyddion';
$string['courseavg'] = 'Cyfartaledd y cwrs';
$string['coursegradecategory'] = 'Categori graddau\'r cwrs';
$string['coursegradedisplaytype'] = 'Ffordd o ddangos graddau\'r cwrs';
$string['coursegradedisplayupdated'] = 'Mae ymddangosiad graddau\'r cwrs wedi\'i ddiweddaru.';
$string['coursegradesettings'] = 'Gosodiadau graddau\'r cwrs';
$string['coursename'] = 'Enw\'r cwrs';
$string['coursescales'] = 'Graddfeydd y cwrs';
$string['coursesettings'] = 'Gosodiadau\'r cwrs';
$string['coursesettingsexplanation'] = 'Mae gosodiadau\'r cwrs yn pennu sut mae pawb sydd yn y cwrs yn gweld y llyfr graddau.';
$string['coursetotal'] = 'Cyfanswm y cwrs';
$string['createcategory'] = 'Creu categori';
$string['createcategoryerror'] = 'Doedd dim modd creu categori newydd';
$string['creatinggradebooksettings'] = 'Wrthi\'n creu gosodiadau\'r Llyfr Graddau';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Cyfuno categori rhiant presennol';
$string['curveto'] = 'Crymu At';
$string['decimalpoints'] = 'Pwyntiau degol cyffredinol';
$string['decimalpoints_help'] = 'Mae\'r gosodiad hwn yn pennu nifer y pwyntiau degol i\'w dangos ar gyfer pob gradd. Nid yw\'n effeithio o gwbl ar y modd y cyfrifir graddau, sy\'n cael eu cyfrifo\'n fanwl i 5 lle degol.';
$string['default'] = 'Diofyn';
$string['defaultprev'] = 'Diofyn ({$a})';
$string['deletecategory'] = 'Dileu\'r Categori';
$string['disablegradehistory'] = 'Analluogi hanes graddau';
$string['disablegradehistory_help'] = 'Analluogi\'r broses o dracio hanes newidiadau mewn tablau sy\'n gysylltiedig â graddau. Gallai hyn gyflymu ychydig ar y gweinydd ac arbed lle yn y gronfa ddata.';
$string['displaylettergrade'] = 'Dangos Graddau Llythyren';
$string['displaypercent'] = 'Dangos Canrannau';
$string['displaypoints'] = 'Dangos Pwyntiau';
$string['displayweighted'] = 'Dangos Graddau Pwysol';
$string['dropdown'] = 'Cwymplen';
$string['droplow'] = 'Gollwng yr isaf';
$string['droplowestvalue'] = 'Gosod gwerth gollwng y radd isaf';
$string['droplow_help'] = 'Mae\'r gosodiad hwn yn ei gwneud yn bosib eithrio nifer benodol o\'r graddau isaf o\'r broses gyfuno.';
$string['dropped'] = 'Wedi\'u Gollwng';
$string['dropxlowest'] = 'Gollwng X Isaf';
$string['dropxlowestwarning'] = 'Cofiwch: Drwy ollwng y x isaf, bydd y graddio\'n cymryd bod pob eitem yn y categori o\'r un gwerth mewn pwyntiau. Os oes gwahaniaethau yng ngwerth y pwyntiau, efallai y ceir canlyniadau annisgwyl';
$string['duplicatescale'] = 'Dyblygu graddfa';
$string['edit'] = 'Golygu';
$string['editcalculation'] = 'Golygu\'r cyfrifiad';
$string['editcalculationverbose'] = 'Golygu\'r cyfrifiad ar gyfer {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Golygu adborth';
$string['editgrade'] = 'Golygu gradd';
$string['editgradeletters'] = 'Golygu llythrennau graddio';
$string['editoutcome'] = 'Golygu deilliant';
$string['editoutcomes'] = 'Golygu deilliannau';
$string['editscale'] = 'Golygu graddfa';
$string['edittree'] = 'Categorïau ac eitemau';
$string['editverbose'] = 'Golygu {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Galluogi AJAX';
$string['enableajax_help'] = 'Mae hwn yn ychwanegu haen o weithredoedd AJAX at yr adroddiad graddio, gan symleiddio a chyflymu gweithrediadau cyffredin. Mae\'n dibynnu ar a yw Javascript ymlaen ar lefel porwr y defnyddiwr.';
$string['enableoutcomes'] = 'Galluogi deilliannau';
$string['enableoutcomes_help'] = 'Mae cymorth ar gyfer Deilliannau (a elwir hefyd yn Gymwyseddau, Amcanion, Safonau neu Feini Prawf) yn golygu y gallwn raddio pethau gan ddefnyddio un neu ragor o\'r graddfeydd sydd ynghlwm wrth ddatganiadau amcanion. Mae galluogi amcanion yn gwneud graddio arbennig o\'r fath yn bosib drwy\'r safle i gyd.';
$string['encoding'] = 'Amgodio';
$string['errorcalculationnoequal'] = 'Mae\'n rhaid i\'r fformiwla gychwyn gyda symbol hafal (=1+2)';
$string['errorcalculationunknown'] = 'Fformiwla annilys';
$string['errorgradevaluenonnumeric'] = 'Wedi derbyn gwerth nad yw\'n rhif ar gyfer gradd isaf neu uchaf ar gyfer';
$string['errornocalculationallowed'] = 'Ni chaniateir cyfrifiadau ar gyfer yr eitem hon';
$string['errornocategorisedid'] = 'Doedd dim modd cael ID heb ei gategoreiddio!';
$string['errornocourse'] = 'Doedd dim modd cael gwybodaeth am y cwrs';
$string['errorreprintheadersnonnumeric'] = 'Wedi derbyn gwerth nad yw\'n rhif ar gyfer pennynnau ailargraffu';
$string['errorsavegrade'] = 'Yn anffodus, doedd dim modd cadw\'r radd.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Gwall wrth ddiweddaru\'r gosodiad "Dim ond cyfuno graddau nad ydynt yn rhai gwag" o\'r ID categori gradd {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Gwall wrth ddiweddaru\'r gosodiad "Cynnwys deilliannau wrth gyfuno" o\'r ID categori gradd {$a->id}';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'Gwall wrth ddiweddaru\'r gosodiad "Cyfuno gan gynnwys isgategorïau" o\'r ID categori gradd {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Gwall wrth ddiweddaru\'r ID categori gradd math o gyfuno {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Gwall wrth ddiweddaru cyfernod cyfuno (pwysau neu gredyd ychwanegol) yr ID eitem graddio {$a->id}';
$string['excluded'] = 'Eithriedig';
$string['excluded_help'] = 'Os oes tic, ni fydd y radd yn cael ei chynnwys mewn unrhyw broses gyfuno.';
$string['expand'] = 'Ymestyn y categori';
$string['export'] = 'Allgludo';
$string['exportalloutcomes'] = 'Allgludo pob deilliant';
$string['exportfeedback'] = 'Cynnwys adborth wrth allgludo';
$string['exportonlyactive'] = 'Eithrio defnyddwyr sydd wedi\'u hatal';
$string['exportonlyactive_help'] = 'Dim ond cynnwys myfyrwyr nad yw eu cyfnod cofrestru wedi cael ei atal yn y broses allgludo';
$string['exportplugins'] = 'Ategion allgludo';
$string['exportsettings'] = 'Gosodiadau allgludo';
$string['exportto'] = 'Allgludo i';
$string['extracreditvalue'] = 'Gwerth credyd ychwanegol ar gyfer {$a}';
$string['extracreditwarning'] = 'Cofiwch: Bydd rhoi credyd ychwanegol ar bob eitem mewn categori yn eu tynnu o\'r broses o gyfrifo\'r graddau. Gan na fydd cyfanswm pwyntiau';
$string['feedback'] = 'Adborth';
$string['feedbackadd'] = 'Ychwanegu adborth';
$string['feedbackedit'] = 'Golygu adborth';
$string['feedback_help'] = 'Mae\'r blwch hwn yn galluogi ychwanegu unrhyw sylwadau am y radd.';
$string['feedbacksaved'] = 'Wedi cadw\'r adborth';
$string['feedbackview'] = 'Gweld adborth';
$string['finalgrade'] = 'Gradd derfynol';
$string['finalgrade_help'] = 'Os oes tic yn y blwch a anwybyddwyd, gellir ychwanegu neu addasu gradd.';
$string['fixedstudents'] = 'Colofn myfyrwyr statig';
$string['fixedstudents_help'] = 'Mae\'n caniatáu i\'r graddau sgrolio\'n llorweddol heb golli golwg o\'r golofn myfyrwyr, drwy ei gwneud yn statig.';
$string['forceoff'] = 'Gorfodi: Diffodd';
$string['forceon'] = 'Gorfodi: Ymlaen';
$string['forelementtypes'] = 'ar gyfer y {$a} a ddewiswyd';
$string['forstudents'] = 'I Fyfyrwyr';
$string['full'] = 'Llawn';
$string['fullmode'] = 'Gwedd lawn';
$string['fullview'] = 'Gwedd lawn';
$string['generalsettings'] = 'Gosodiadau cyffredinol';
$string['grade'] = 'Gradd';
$string['gradeadministration'] = 'Gweinyddu\'r Modiwl Graddau';
$string['gradeanalysis'] = 'Dadansoddi graddau';
$string['gradebook'] = 'Llyfr Graddau';
$string['gradebookhiddenerror'] = 'Mae\'r llyfr graddau wedi\'i osod i guddio popeth rhag myfyrwyr.';
$string['gradebookhistories'] = 'Hanes graddau';
$string['gradeboundary'] = 'Ffin llythyren graddio';
$string['gradeboundary_help'] = 'Mae\'r gosodiad hwn yn pennu\'r ganran isaf ar gyfer neilltuo\'r llythyren graddio i raddau.';
$string['gradecategories'] = 'Categorïau gradd';
$string['gradecategory'] = 'Categori gradd';
$string['gradecategoryonmodform'] = 'Categori gradd';
$string['gradecategoryonmodform_help'] = 'Mae\'r gosodiad hwn yn rheoli\'r categori lle mae graddau\'r gweithgaredd hwn wedi\'u lleoli yn y llyfr gradd.';
$string['gradecategorysettings'] = 'Gosodiadau categori gradd';
$string['gradedisplay'] = 'Dangos graddau';
$string['gradedisplaytype'] = 'Ffordd o ddangos gradd';
$string['gradedisplaytype_help'] = 'Mae\'r gosodiad hwn yn pennu sut mae\'r graddau\'n cael eu dangos yn y graddiwr ac mewn adroddiadau defnyddwyr.

* Real - Graddau go iawn
* Canran
* Llythyren - Defnyddir llythrennau neu eiriau i gynrychioli ystod o raddau';
$string['gradedon'] = 'Wedi graddio: {$a}';
$string['gradeexport'] = 'Allgludo graddau';
$string['gradeexportcustomprofilefields'] = 'Meysydd proffil personol allgludo graddau';
$string['gradeexportcustomprofilefields_desc'] = 'Cynnwys y meysydd proffil personol hyn yn yr allgludo graddau, wedi\'u gwahanu gan gomas.';
$string['gradeexportdecimalpoints'] = 'Pwyntiau degol ar gyfer allgludo graddau';
$string['gradeexportdecimalpoints_desc'] = 'Nifer y pwyntiau degol i\'w dangos ar gyfer allgludo. Gellir anwybyddu hyn wrth allgludo.';
$string['gradeexportdisplaytype'] = 'Ffordd o ddangos allgludo graddau';
$string['gradeexportdisplaytype_desc'] = 'Gellir dangos graddau fel graddau real, fel canrannau (o ran graddau isaf a graddau uchaf posib) neu fel llythrennau (A, B, C ac yn y blaen...) yn ystod y broses allgludo. Gellir anwybyddu hyn wrth allgludo.';
$string['gradeexportuserprofilefields'] = 'Meysydd proffil defnyddiwr allgludo graddau';
$string['gradeexportuserprofilefields_desc'] = 'Cynnwys y meysydd proffil defnyddiwr hyn yn yr allgludo graddau, wedi\'u gwahanu gan gomas.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradehelp'] = 'Help gyda graddio';
$string['gradehistorylifetime'] = 'Cyfnod cadw hanes graddau';
$string['gradehistorylifetime_help'] = 'Mae hyn yn nodi am faint o amser rydych chi am gadw hanes newidiadau mewn tablau sy\'n gysylltiedig â graddau. Argymhellir eich bod yn cadw\'r cyfnod mor hir â phosib. Os byddwch chi\'n cael problemau gyda pherfformiad, neu os mai dim ond hyn a hyn o le sydd gennych yn eich cronfa ddata, dylech osod gwerth is.';
$string['gradeimport'] = 'Mewngludo graddau';
$string['gradeitem'] = 'Graddio Eitem';
$string['gradeitemaddusers'] = 'Eithrio o\'r Graddio';
$string['gradeitemadvanced'] = 'Mwy o Ddewisiadau ar gyfer eitemau graddio';
$string['gradeitemadvanced_help'] = 'Dewiswch bob elfen y dylai Mwy o Ddewisiadau fod yn berthnasol iddi wrth olygu eitemau graddio.';
$string['gradeitemislocked'] = 'Mae\'r gweithgaredd hwn wedi\'i gloi yn y llyfr graddau. Ni fydd newidiadau sy\'n cael eu gwneud i raddau yn y gweithgaredd hwn yn cael eu copïo i\'r llyfr graddau nes bydd wedi\'i ddad-gloi.';
$string['gradeitemlocked'] = 'Graddio wedi\'i gloi';
$string['gradeitemmembersselected'] = 'Wedi\'i Eithrio o\'r Graddio';
$string['gradeitemnonmembers'] = 'Wedi\'u cynnwys yn y Graddio';
$string['gradeitemremovemembers'] = 'Cynnwys yn y Graddio';
$string['gradeitems'] = 'Graddio Eitemau';
$string['gradeitemsettings'] = 'Gosodiadau eitemau graddio';
$string['gradeitemsinc'] = 'Eitemau graddio i\'w cynnwys';
$string['gradeletter'] = 'Llythyren Graddio';
$string['gradeletter_help'] = 'Mae llythrennau graddio yn llythrennau, A, B, C, ..., neu\'n eiriau, er enghraifft, Rhagoriaeth, Teilyngdod, Pasio, ..., a ddefnyddir i gynrychioli ystod o raddau.';
$string['gradeletternote'] = 'Er mwyn dileu llythyren graddio, gwagiwch unrhyw un o\'r<br /> tri blwch testun ar gyfer y llythyren honno, a chlicio cyflwyno.';
$string['gradeletters'] = 'Llythrennau graddio';
$string['gradelocked'] = 'Gradd wedi\'i chloi';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Gradd uchaf bosib';
$string['grademax_help'] = 'Mae\'r gosodiad hwn yn pennu\'r radd uchaf bosib wrth ddefnyddio gwerth. Caiff y radd uchaf ar gyfer eitem graddio sy\'n seiliedig ar weithgareddau ei phennu ar y dudalen gosodiadau gweithgaredd.';
$string['grademin'] = 'Gradd isaf bosib';
$string['grademin_help'] = 'Mae\'r gosodiad hwn yn pennu\'r radd isaf bosib wrth ddefnyddio gwerth fel math o radd.';
$string['gradeoutcomeitem'] = 'Eitem deilliant graddio';
$string['gradeoutcomes'] = 'Deilliannau';
$string['gradeoutcomescourses'] = 'Deilliannau\'r cwrs';
$string['gradepass'] = 'Gradd i basio';
$string['gradepass_help'] = 'Mae\'r gosodiad hwn yn pennu\'r radd isaf bosib sydd ei hangen i basio. Defnyddir y gwerth yn ystod y broses cwblhau cwrs a gweithgaredd, ac yn y llyfr graddau, lle mae graddau pasio yn wyrdd a graddau methu yn goch.';
$string['gradepreferences'] = 'Dewisiadau graddio';
$string['gradepreferenceshelp'] = 'Help Dewisiadau Graddio';
$string['gradepublishing'] = 'Galluogi cyhoeddi';
$string['gradepublishing_help'] = 'Galluogi cyhoeddi wrth allgludo a mewngludo: Gellir cael mynediad at raddau a allgludwyd drwy fynd i URL, heb orfod mewngofnodi ar safle Moodle. Gellir mewngludo graddau drwy fynd i URL o\'r fath (sy\'n golygu y gall safle Moodle fewngludo graddau a gyhoeddwyd gan safle arall). Yn ddiofyn, dim ond gweinyddwyr sy\'n cael defnyddio\'r nodwedd hon, dylech wneud yn siŵr bod y defnyddwyr yn gwybod am beryglon rhannu nodau tudalen, cyflymyddion llwytho, cyfyngiadau IP ac ati, cyn ychwanegu galluoedd gofynnol at eu swyddogaethau eraill.';
$string['gradereport'] = 'Adroddiad graddio';
$string['graderreport'] = 'Adroddiad graddau';
$string['grades'] = 'Graddau';
$string['gradesforuser'] = 'Graddau ar gyfer {$a->user}';
$string['gradesonly'] = 'Graddau yn unig';
$string['gradessettings'] = 'Gosodiadau graddio';
$string['gradetype'] = 'Math o radd';
$string['gradetype_help'] = 'Mae 4 math o radd:

* Dim un - Graddio ddim yn bosib
* Gwerth - Gwerth rhifol gydag uchafswm ac isafswm* Graddfa - Eitem ar restr
* Testun - Adborth yn unig
Dim ond gwerthoedd a graddfeydd y gellir eu cyfuno. Mae\'r math o radd a ddefnyddir ar gyfer eitem graddio sy\'n seiliedig ar weithgaredd yn cael ei osod ar y dudalen gosodiadau gweithgaredd.';
$string['gradeview'] = 'Gweld gradd';
$string['gradeweighthelp'] = 'Help pwysoli graddio';
$string['groupavg'] = 'Cyfartaledd y grŵp';
$string['hidden'] = 'Cudd';
$string['hiddenasdate'] = 'Dangos y dyddiad a gyflwynwyd ar gyfer graddau cudd';
$string['hiddenasdate_help'] = 'Os nad oes modd i\'r defnyddiwr weld graddau cudd, dylid dangos y dyddiad cyflwyno yn hytrach na \'-\'.';
$string['hidden_help'] = 'Os oes tic, caiff graddau eu cuddio rhag y myfyrwyr. Gellir gosod dyddiad \'cuddio tan\' os dymunir, i ryddhau graddau ar ôl i\'r broses raddio gael ei chwblhau.';
$string['hiddenuntil'] = 'Wedi\'u cuddio tan';
$string['hiddenuntildate'] = 'Wedi\'u cuddio tan: {$a}';
$string['hideadvanced'] = 'Cuddio Nodweddion Uwch';
$string['hideaverages'] = 'Cuddio\'r symiau cyfartalog';
$string['hidecalculations'] = 'Cuddio cyfrifiadau';
$string['hidecategory'] = 'Cudd';
$string['hideeyecons'] = 'Cuddio eiconau dangos/cuddio';
$string['hidefeedback'] = 'Cuddio adborth';
$string['hideforcedsettings'] = 'Cuddio gosodiadau a orfodwyd';
$string['hideforcedsettings_help'] = 'Peidio dangos gosodiadau a orfodwyd o ran graddio UI.';
$string['hidegroups'] = 'Cuddio grwpiau';
$string['hidelocks'] = 'Cuddio\'r rhai sydd wedi\'u cloi';
$string['hidenooutcomes'] = 'Dangos deilliannau';
$string['hidequickfeedback'] = 'Cuddio adborth cyflym';
$string['hideranges'] = 'Cuddio ystodau';
$string['hidetotalifhiddenitems'] = 'Cuddio cyfansymiau os ydynt yn cynnwys eitemau cudd';
$string['hidetotalifhiddenitems_help'] = 'Mae\'r gosodiad hwn yn dynodi a gaiff cyfansymiau sy\'n cynnwys eitemau graddio cudd eu dangos i fyfyrwyr ynteu a roddir cysylltnod (-) yn eu lle. Os cânt eu dangos, mae\'n bosib cyfrifo\'r cyfanswm naill ai gan gynnwys neu heb gynnwys yr eitemau cudd.
Os caiff yr eitemau cudd eu heithrio, bydd y cyfanswm yn wahanol i\'r cyfanswm a welir gan yr athro yn yr adroddiad graddau, gan fod yr athro bob amser yn gweld y cyfansymiau a gyfrifir o bob eitem, p\'un ai a ydynt wedi\'u cuddio ai peidio. Os caiff eitemau cudd eu cynnwys, mae\'n bosib y bydd modd i fyfyrwyr gyfrifo\'r eitemau cudd.';
$string['hidetotalshowexhiddenitems'] = 'Dangos cyfansymiau heb gynnwys eitemau cudd';
$string['hidetotalshowinchiddenitems'] = 'Dangos cyfansymiau gan gynnwys eitemau cudd';
$string['hideverbose'] = 'Cuddio {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Trefnu yn ôl gradd uchaf, esgynnol';
$string['highgradedescending'] = 'Trefnu yn ôl gradd uchaf, disgynnol';
$string['highgradeletter'] = 'Uchaf';
$string['identifier'] = 'Adnabod defnyddiwr yn ôl';
$string['idnumbers'] = 'Rhifau ID';
$string['import'] = 'Mewngludo';
$string['importcsv'] = 'Mewngludo CSV';
$string['importcustom'] = 'Mewngludo fel deilliannau personol (dim ond y cwrs hwn)';
$string['importerror'] = 'Digwyddodd gwall, ni chafodd y sgript hon ei galw gyda\'r paramedrau cywir.';
$string['importfailed'] = 'Wedi methu mewngludo';
$string['importfeedback'] = 'Adborth mewngludo';
$string['importfile'] = 'Mewngludo ffeil';
$string['importfilemissing'] = 'Heb gael ffeil, ewch yn ôl i\'r ffurflen a gwneud yn siŵr eich bod yn llwytho ffeil ddilys i fyny.';
$string['importfrom'] = 'Mewngludo o';
$string['importoutcomenofile'] = 'Mae\'r ffeil a lwythwyd i fyny naill ai\'n wag neu\'n llwgr. Cadarnhewch fod hon yn ffeil ddilys. Canfuwyd y broblem ar linell {$a}; bydd hyn yn digwydd os nad oes gan y llinellau data gynifer o golofnau â\'r llinell gyntaf (y pennyn) neu os oes penynnau disgwyliedig ar goll yn y ffeil a fewngludwyd. Edrychwch ar y ffeil a allgludwyd i weld enghraifft o ffeil gyda phennyn dilys.';
$string['importoutcomes'] = 'Mewngludo deilliannau';
$string['importoutcomes_help'] = 'Gellir mewngludo deilliannau drwy ffeil csv gyda fformat fel y ffeil csv allgludo amcanion.';
$string['importoutcomesuccess'] = 'Wedi mewngludo\'r deilliant "{$a->name}" gyda\'r ID #{$a->id}';
$string['importplugins'] = 'Ategion mewngludo';
$string['importpreview'] = 'Rhagolwg mewngludo';
$string['importsettings'] = 'Gosodiadau mewngludo';
$string['importskippednomanagescale'] = 'Does gennych chi ddim hawl i ychwanegu graddfa newydd, felly cafodd deilliant "{$a}" ei hepgor gan fod angen creu graddfa newydd ar ei gyfer';
$string['importskippedoutcome'] = 'Mae deilliant gyda\'r enw byr "{$a}" yn bodoli\'n barod yn y cyd-destun hwn, cafodd yr un yn y ffeil a fewngludwyd ei hepgor.';
$string['importstandard'] = 'Mewngludo fel deilliannau safonol';
$string['importsuccess'] = 'Wedi llwyddo i fewngludo graddau';
$string['importxml'] = 'Mewngludo XML';
$string['includescalesinaggregation'] = 'Cynnwys graddfeydd wrth gyfuno';
$string['includescalesinaggregation_help'] = 'Gallwch newid a ddylid cynnwys graddfeydd fel rhifau ym mhob gradd a gyfunir ym mhob llyfr graddau ym mhob cwrs. RHYBUDD: bydd newid y gosodiad hwn yn gorfodi ail-gyfrifo pob gradd a gyfunir.';
$string['incorrectcourseid'] = 'Roedd ID y cwrs yn anghywir';
$string['incorrectcustomscale'] = '(Graddfa bersonol anghywir, dylid ei newid.)';
$string['incorrectminmax'] = 'Mae\'n rhaid i\'r isafswm fod yn is na\'r uchafswm';
$string['inherit'] = 'Etifeddu';
$string['intersectioninfo'] = 'Gwybodaeth Myfyrwyr/Graddau';
$string['item'] = 'Eitem';
$string['iteminfo'] = 'Gwybodaeth am yr eitem';
$string['iteminfo_help'] = 'Mae\'r gosodiad hwn yn darparu lle ar gyfer rhoi gwybodaeth am yr eitem. Ni fydd yr wybodaeth yn cael ei dangos yn unrhyw le arall.';
$string['itemname'] = 'Enw\'r eitem';
$string['itemnamehelp'] = 'Enw\'r eitem hon, a gafodd ei gwthio i mewn gan y modiwl.';
$string['items'] = 'Eitemau';
$string['itemsedit'] = 'Golygu eitem graddio';
$string['keephigh'] = 'Cadw\'r uchaf';
$string['keephigh_help'] = 'Os yw wedi\'i osod, dim ond y X gradd uchaf y bydd yr opsiwn hwn yn eu cadw, gydag X yn cynrychioli\'r gwerth a ddewiswyd ar gyfer yr opsiwn hwn.';
$string['keymanager'] = 'Rheolwr allweddi';
$string['lessthanmin'] = 'Mae\'r radd a nodwyd ar gyfer {$a->itemname} ar gyfer {$a->username} yn llai na\'r isafswm a ganiateir';
$string['letter'] = 'Llythyren';
$string['lettergrade'] = 'Gradd Llythyren';
$string['lettergradenonnumber'] = 'Gradd Isaf a/neu Uchaf yn anrhifaidd ar gyfer';
$string['letterpercentage'] = 'Llythyren (canran)';
$string['letterreal'] = 'Llythyren (real)';
$string['letters'] = 'Llythrennau';
$string['linkedactivity'] = 'Gweithgaredd cyswllt';
$string['linkedactivity_help'] = 'Mae\'r gosodiad hwn yn nodi gweithgaredd y mae\'r deilliant hwn yn gysylltiedig ag ef. Gellir defnyddio hwn i fesur perfformiad myfyriwr ar feini prawf nad yw\'n cael eu hasesu gan radd y gweithgaredd.';
$string['linktoactivity'] = 'Dolen at y gweithgaredd {$a->name}';
$string['lock'] = 'Cloi';
$string['locked'] = 'Wedi cloi';
$string['locked_help'] = 'Os oes tic, ni fydd modd i raddau gael eu diweddaru\'n awtomatig gan y gweithgaredd cysylltiedig.';
$string['locktime'] = 'Cloi ar ôl';
$string['locktimedate'] = 'Wedi\'u cloi ar ôl: {$a}';
$string['lockverbose'] = 'Cloi {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Isaf';
$string['lowgradeletter'] = 'Isel';
$string['manualitem'] = 'Eitem wedi\'i chreu gennych chi';
$string['mapfrom'] = 'Mapio o';
$string['mappings'] = 'Mapio eitemau graddio';
$string['mapto'] = 'Mapio i';
$string['max'] = 'Uchaf';
$string['maxgrade'] = 'Uchafswm Gradd';
$string['meanall'] = 'Pob gradd';
$string['meangraded'] = 'Graddau nad ydynt yn wag';
$string['meanselection'] = 'Graddau wedi\'u dewis ar gyfer cyfartalion colofnau';
$string['meanselection_help'] = 'Mae\'r gosodiad hwn yn pennu a ddylai celloedd heb radd gael eu cynnwys wrth gyfrifo\'r cyfartaledd (cymedr) ar gyfer pob categori neu eitem graddio.';
$string['median'] = 'Canolrif';
$string['min'] = 'Isaf';
$string['missingscale'] = 'Mae\'n rhaid dewis graddfa';
$string['mode'] = 'Modd';
$string['morethanmax'] = 'Mae\'r radd a roddwyd ar gyfer {$a->itemname} ar gyfer {$a->username} yn fwy na\'r uchafswm a ganiateir';
$string['moveselectedto'] = 'Symud yr eitemau a ddewiswyd i';
$string['movingelement'] = 'Wrthi\'n symud {$a}';
$string['multfactor'] = 'Lluosogydd';
$string['multfactor_help'] = 'Y lluosogydd yw\'r ffactor y bydd pob gradd ar gyfer yr eitem graddio hon yn cael ei lluosi ag ef, gyda\'r radd uchaf bosib yn werth uchaf posib. Er enghraifft, os yw\'r lluosogydd yn 2 a\'r radd uchaf bosib yn 100, bydd pob gradd sy\'n llai na 50 yn cael ei lluosi gyda 2, a phob gradd 50 ac uwch yn cael ei newid i 100.';
$string['multfactorvalue'] = 'Gwerth y lluosogydd ar gyfer {$a}';
$string['mypreferences'] = 'Fy hoff ddewisiadau';
$string['myreportpreferences'] = 'Fy hoff ddewisiadau o ran adroddiadau';
$string['navmethod'] = 'Dull llywio';
$string['neverdeletehistory'] = 'Peidio byth â dileu hanes';
$string['newcategory'] = 'Categori newydd';
$string['newitem'] = 'Eitem graddio newydd';
$string['newoutcomeitem'] = 'Eitem deilliant newydd';
$string['no'] = 'Na';
$string['nocategories'] = 'Wedi methu ag ychwanegu na darganfod categorïau graddau ar gyfer y cwrs hwn';
$string['nocategoryname'] = 'Dim enw categori wedi ei roi.';
$string['nocategoryview'] = 'Dim categori i weld yn ei ôl';
$string['nocourses'] = 'Does dim cyrsiau eto';
$string['noforce'] = 'Peidio gorfodi';
$string['nogradeletters'] = 'Dim llythrennau graddio wedi\'u creu';
$string['nogradesreturned'] = 'Dim graddau wedi\'u dychwelyd';
$string['noidnumber'] = 'Dim rhif ID';
$string['nolettergrade'] = 'Dim gradd llythyren ar gyfer';
$string['nomode'] = 'Amherthnasol';
$string['nonnumericweight'] = 'Wedi derbyn gwerth anrhifaidd ar gyfer';
$string['nonunlockableverbose'] = 'Does dim modd dad-gloi\'r radd hon nes bod yr eitem {$a->itemname} wedi\'i dad-gloi.';
$string['nonweightedpct'] = '% heb ei bwysoli';
$string['nooutcome'] = 'Dim deilliant';
$string['nooutcomes'] = 'Mae\'n rhaid i eitemau\'r deilliannau fod wedi\'u cysylltu â deilliannau\'r cwrs, ond does dim deilliannau ar gyfer y cwrs hwn. Hoffech chi ychwanegu un?';
$string['nopublish'] = 'Peidio cyhoeddi';
$string['norolesdefined'] = 'Dim swyddogaethau wedi\'u diffinio yn Gweinyddiaeth > Graddau > Gosodiadau cyffredinol > Swyddogaethau wedi\'u graddio';
$string['noscales'] = 'Mae\'n rhaid i\'r deilliannau fod wedi\'u cysylltu â graddfa cwrs neu raddfa gyffredinol, ond does dim un. Hoffech chi ychwanegu un?';
$string['noselectedcategories'] = 'dim categorïau wedi\'u dewis.';
$string['noselecteditems'] = 'dim eitemau wedi\'u dewis.';
$string['notteachererror'] = 'Rhaid i chi fod yn athro/athrawes i ddefnyddio\'r nodwedd hon.';
$string['nousersloaded'] = 'Dim defnyddwyr wedi\'u llwytho';
$string['numberofgrades'] = 'Nifer y graddau';
$string['onascaleof'] = 'ar raddfa {$a->grademin} i {$a->grademax}';
$string['operations'] = 'Gweithrediadau';
$string['options'] = 'Opsiynau';
$string['outcome'] = 'Deilliant';
$string['outcomeassigntocourse'] = 'Neilltuo deilliant arall i\'r cwrs hwn';
$string['outcomecategory'] = 'Creu deilliannau yn y categori';
$string['outcomecategorynew'] = 'Categori newydd';
$string['outcomeconfirmdelete'] = 'Ydych chi\'n siŵr eich bod am ddileu\'r deilliant "{$a}"?';
$string['outcomecreate'] = 'Ychwanegu deilliant newydd';
$string['outcomedelete'] = 'Dileu deilliant';
$string['outcomefullname'] = 'Enw llawn';
$string['outcome_help'] = 'Mae\'r gosodiad hwn yn pennu\'r deilliant y bydd yr eitem graddio hon yn ei gynrychioli yn y llyfr graddau.';
$string['outcomeitem'] = 'Eitem deilliant';
$string['outcomeitemsedit'] = 'Golygu eitem deilliant';
$string['outcomereport'] = 'Adroddiad deilliannau';
$string['outcomes'] = 'Deilliannau';
$string['outcomescourse'] = 'Deilliannau a ddefnyddir mewn cwrs';
$string['outcomescoursecustom'] = 'Personol (peidio dileu)';
$string['outcomescoursenotused'] = 'Heb ddefnyddio safon';
$string['outcomescourseused'] = 'Wedi defnyddio safon (peidio dileu)';
$string['outcomescustom'] = 'Deilliannau personol';
$string['outcomeshortname'] = 'Enw byr';
$string['outcomesstandard'] = 'Deilliannau safonol';
$string['outcomesstandardavailable'] = 'Deilliannau safonol sydd ar gael';
$string['outcomestandard'] = 'Deilliant safonol';
$string['outcomestandard_help'] = 'Mae deilliant safonol ar gael ar gyfer y safle i gyd, ar gyfer pob cwrs.';
$string['overallaverage'] = 'Cyfartaledd cyffredinol';
$string['overridden'] = 'Anwybyddwyd';
$string['overridden_help'] = 'Os oes tic, ni fydd modd newid y radd o fewn y gweithgaredd cysylltiedig.
Pan fydd gradd yn cael ei golygu yn yr adroddiad graddio, bydd tic yn ymddangos yn awtomatig yn y blwch a gafodd ei anwybyddu. Fodd bynnag, gellir dad-dicio\'r blwch er mwyn caniatáu i\'r radd gael ei newid drwy\'r gweithgaredd cysylltiedig.';
$string['overriddennotice'] = 'Cafodd eich gradd derfynol o\'r gweithgaredd hwn ei haddasu â llaw.';
$string['overridesitedefaultgradedisplaytype'] = 'Anwybyddu dewisiadau diofyn y safle';
$string['overridesitedefaultgradedisplaytype_help'] = 'Os oes tic, gellir gosod llythrennau graddio a ffiniau ar gyfer y cwrs, yn hytrach na defnyddio dewisiadau diofyn y safle.';
$string['parentcategory'] = 'Categori rhiant';
$string['pctoftotalgrade'] = '% o gyfanswm gradd';
$string['percent'] = 'Canran';
$string['percentage'] = 'Canran';
$string['percentageletter'] = 'Canran (llythyren)';
$string['percentagereal'] = 'Canran (real)';
$string['percentascending'] = 'Trefnu yn ôl canran, esgynnol';
$string['percentdescending'] = 'Trefnu yn ôl canran, disgynnol';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Gwrthbwyso';
$string['plusfactor_help'] = 'Mae\'r rhif gwrthbwyso yn cael ei ychwanegu at bob gradd ar gyfer yr eitem graddio hon, ar ôl defnyddio\'r lluosogydd.';
$string['plusfactorvalue'] = 'Gwerth y rhif gwrthbwyso ar gyfer {$a}';
$string['points'] = 'pwyntiau';
$string['pointsascending'] = 'Trefnu yn ôl pwyntiau, esgynnol';
$string['pointsdescending'] = 'Trefnu yn ôl pwyntiau, disgynnol';
$string['positionfirst'] = 'Cyntaf';
$string['positionlast'] = 'Olaf';
$string['preferences'] = 'Dewisiadau';
$string['prefgeneral'] = 'Cyffredinol';
$string['prefletters'] = 'Llythrennau graddio a ffiniau';
$string['prefrows'] = 'Rhesi arbennig';
$string['prefshow'] = 'Dangos/cuddio toglau';
$string['previewrows'] = 'Rhagolwg o\'r rhesi';
$string['profilereport'] = 'Adroddiad proffil defnyddiwr';
$string['profilereport_help'] = 'Wedi defnyddio\'r adroddiad graddio ar dudalen proffil y defnyddiwr.';
$string['publishing'] = 'Cyhoeddi';
$string['quickfeedback'] = 'Adborth cyflym';
$string['quickgrading'] = 'Graddio cyflym';
$string['quickgrading_help'] = 'Os yw wedi\'i alluogi, pan fydd y swyddogaeth golygu ymlaen, bydd blwch mewnbynnu testun yn ymddangos ar gyfer pob gradd, gan ei gwneud yn bosib golygu nifer o raddau ar yr un pryd. Caiff newidiadau eu cadw a\'u hamlygu wrth glicio\'r botwm diweddaru. Pan fydd gradd yn cael ei golygu yn yr adroddiad graddio, bydd fflag anwybyddu yn cael ei osod, sy\'n golygu nad oes modd newid y radd o fewn y gweithgaredd cysylltiedig mwyach.';
$string['range'] = 'Ystod';
$string['rangedecimals'] = 'Ystod pwyntiau degol';
$string['rangedecimals_help'] = 'Nifer y pwyntiau degol i\'w dangos ar gyfer yr ystod.';
$string['rangesdecimalpoints'] = 'Dangos degolion mewn ystod';
$string['rangesdecimalpoints_help'] = 'Mae\'r gosodiad hwn yn pennu nifer y pwyntiau degol i\'w dangos ar gyfer pob ystod neu a yw\'r gosodiad pwyntiau degol cyffredinol ar gyfer yr eitem graddio neu\'r categori yn cael ei ddefnyddio (etifeddu).';
$string['rangesdisplaytype'] = 'Ymddangosiad yr ystod';
$string['rangesdisplaytype_help'] = 'Mae\'r gosodiad hwn yn pennu a yw\'r ystod yn cael ei dangos fel graddau real, canrannau ynteu lythrennau, neu a yw ymddangosiad y categori neu\'r eitem graddio yn cael ei ddefnyddio (etifeddu).';
$string['rank'] = 'Safle';
$string['rawpct'] = '% Crai';
$string['real'] = 'Real';
$string['realletter'] = 'Real (llythyren)';
$string['realpercentage'] = 'Real (canran)';
$string['recovergradesdefault'] = 'Adfer graddau\'n ddiofyn';
$string['recovergradesdefault_help'] = 'Adfer hen raddau yn ddiofyn wrth ailgofrestru defnyddiwr mewn cwrs.';
$string['regradeanyway'] = 'Ailraddio beth bynnag';
$string['removeallcoursegrades'] = 'Dileu pob gradd';
$string['removeallcourseitems'] = 'Dileu pob eitem a chategori';
$string['report'] = 'Adroddiad';
$string['reportdefault'] = 'Adroddiad diofyn ({$a})';
$string['reportplugins'] = 'Ategion adroddiadau';
$string['reportsettings'] = 'Gosodiadau adroddiadau';
$string['reprintheaders'] = 'Ailargraffu pennynnau';
$string['respectingcurrentdata'] = 'gadael y ffurfweddiad cyfredol heb ei newid';
$string['rowpreviewnum'] = 'Rhagolwg o\'r rhesi';
$string['savechanges'] = 'Cadw\'r Newidiadau';
$string['savepreferences'] = 'Cadw\'r Dewisiadau';
$string['scaleconfirmdelete'] = 'Ydych chi\'n siŵr eich bod am ddileu\'r raddfa "{$a}"?';
$string['scaledpct'] = '% wedi\'i Raddio';
$string['seeallcoursegrades'] = 'Gweld holl raddau\'r cwrs';
$string['select'] = 'Dewis {$a}';
$string['selectalloroneuser'] = 'Dewis pob defnyddiwr neu un defnyddiwr';
$string['selectauser'] = 'Dewis defnyddiwr';
$string['selectdestination'] = 'Dewis cyrchfan {$a}';
$string['separator'] = 'Gwahanydd';
$string['sepcolon'] = 'Colon';
$string['sepcomma'] = 'Coma';
$string['sepsemicolon'] = 'Hanner Colon';
$string['septab'] = 'Tab';
$string['setcategories'] = 'Gosod Categorïau';
$string['setcategorieserror'] = 'Rhaid i chi osod categorïau eich cwrs cyn y gallwch eu pwysoli.';
$string['setgradeletters'] = 'Gosod Llythrennau Graddio';
$string['setpreferences'] = 'Gosod Dewisiadau';
$string['setting'] = 'Gosodiad';
$string['settings'] = 'Gosodiadau';
$string['setweights'] = 'Gosod Pwysau';
$string['showactivityicons'] = 'Dangos eiconau ar gyfer gweithgareddau';
$string['showactivityicons_help'] = 'Os yw wedi\'i alluogi, bydd eiconau gweithgareddau yn cael eu dangos wrth ymyl enwau\'r gweithgareddau.';
$string['showallhidden'] = 'Dangos y rhai cudd';
$string['showallstudents'] = 'Dangos Pob Myfyriwr';
$string['showanalysisicon'] = 'Dangos eicon dadansoddi gradd';
$string['showanalysisicon_desc'] = 'A ddylid dangos yr eicon dadansoddi graddau yn ddiofyn. Os yw’r modiwl gweithgareddau yn ei gefnogi, mae\'r eicon dadansoddi graddau yn cysylltu â thudalen gydag eglurhad mwy manwl o\'r radd a sut y cafodd ei hennill.';
$string['showanalysisicon_help'] = 'Os yw’r modiwl gweithgareddau yn ei gefnogi, mae\'r eicon dadansoddi graddau yn cysylltu â thudalen gydag eglurhad mwy manwl o\'r radd a sut y cafodd ei hennill.';
$string['showaverage'] = 'Dangos cyfartaledd';
$string['showaverage_help'] = 'Dangos y golofn cyfartaledd? Mae\'n bosib y bydd modd i fyfyrwyr amcangyfrif graddau myfyrwyr eraill os yw\'r cyfartaledd yn cael ei gyfrifo o ddim ond ychydig o raddau. Am resymau perfformiad, brasamcan yw\'r cyfartaledd os yw\'n ddibynnol ar unrhyw eitemau cudd.';
$string['showaverages'] = 'Dangos cyfartalion y colofnau';
$string['showaverages_help'] = 'Os yw wedi\'i alluogi, bydd yr adroddiad graddio yn cynnwys rhes ychwanegol yn dangos y cyfartaledd (cymedr) ar gyfer pob eitem graddio a chategori.';
$string['showcalculations'] = 'Dangos cyfrifiadau';
$string['showcalculations_help'] = 'Os yw wedi\'i alluogi, pan fydd y swyddogaeth golygu ymlaen, bydd eicon cyfrifiannell yn cael ei ddangos ar gyfer pob categori ac eitem graddio, gydag awgrymiadau offer ynghylch eitemau a gyfrifir, a dangosydd gweledol sy\'n dangos bod colofn wedi\'i chyfrifo.';
$string['showeyecons'] = 'Dangos eiconau dangos/cuddio';
$string['showeyecons_help'] = 'Os yw wedi\'i alluogi, pan fydd y swyddogaeth golygu ymlaen, bydd eicon dangos/cuddio yn cael ei ddangos ar gyfer pob gradd er mwyn rheoli\'r modd y mae\'r myfyriwr yn ei weld.';
$string['showfeedback'] = 'Dangos adborth';
$string['showfeedback_help'] = 'Dangos y golofn adborth?';
$string['showgrade'] = 'Dangos graddau';
$string['showgrade_help'] = 'Dangos y golofn graddau?';
$string['showgroups'] = 'Dangos grwpiau';
$string['showhiddenitems'] = 'Dangos Eitemau Cudd';
$string['showhiddenitems_help'] = 'P\'un ai a yw\'r eitemau graddio cudd wedi\'u cuddio\'n llwyr ynteu a yw\'r myfyrwyr yn gallu gweld enwau\'r eitemau graddio cudd. * Dangos y rhai cudd - Mae enwau\'r eitemau graddio cudd yn cael eu dangos ond mae graddau\'r myfyrwyr yn cael eu cuddio * Dim ond wedi\'u cuddio tan - Mae\'r eitemau graddio gyda dyddiad "cuddio tan" yn gwbl gudd tan y dyddiad sydd wedi\'i bennu, a bydd yr eitem gyfan i\'w gweld ar ôl hynny * Peidio dangos - Mae\'r eitemau gradd cudd yn gwbl gudd';
$string['showhiddenuntilonly'] = 'Dim ond wedi\'u cuddio tan';
$string['showlettergrade'] = 'Dangos graddau llythyren';
$string['showlettergrade_help'] = 'Dangos y golofn graddau llythyren?';
$string['showlocks'] = 'Dangos y rhai sydd wedi\'u cloi';
$string['showlocks_help'] = 'Os yw wedi\'i alluogi, pan fydd y swyddogaeth golygu ymlaen, bydd eicon cloi/dad-gloi i\'w weld ar gyfer pob gradd er mwyn rheoli a oes modd i\'r gweithgaredd cysylltiedig ddiweddaru\'r radd yn awtomatig.';
$string['shownohidden'] = 'Peidio dangos';
$string['shownooutcomes'] = 'Cuddio deilliannau';
$string['shownumberofgrades'] = 'Dangos nifer y graddau a ddefnyddiwyd i gyfrifo cyfartaledd';
$string['shownumberofgrades_help'] = 'Os yw wedi\'i alluogi, bydd nifer y graddau a ddefnyddiwyd i gyfrifo\'r cyfartaledd (cymedr) yn cael ei ddangos mewn cromfachau ar ôl pob cyfartaledd.';
$string['showpercentage'] = 'Dangos canran';
$string['showpercentage_help'] = 'Dangos gwerth canran pob eitem graddio?';
$string['showquickfeedback'] = 'Dangos adborth cyflym';
$string['showquickfeedback_help'] = 'Os yw wedi\'i alluogi, pan mae\'r swyddogaeth golygu ymlaen, bydd blwch mewnbynnu testun gyda border dotiau yn ymddangos ar gyfer pob gradd, gan ei gwneud yn bosib golygu nifer o raddau ar yr un pryd. Caiff newidiadau eu cadw a\'u hamlygu wrth glicio ar y botwm diweddaru.
Pan fydd adborth yn cael ei olygu yn yr adroddiad graddau, bydd fflag anwybyddu yn cael ei osod, gan olygu nad oes modd newid yr adborth o fewn y gweithgaredd cysylltiedig mwyach.';
$string['showrange'] = 'Dangos ystod';
$string['showrange_help'] = 'Dangos y golofn ystod?';
$string['showranges'] = 'Dangos ystodau';
$string['showranges_help'] = 'Os yw wedi\'i alluogi, bydd yr adroddiad graddau yn cynnwys rhes ychwanegol yn dangos yr ystod ar gyfer pob categori ac eitem graddio.';
$string['showrank'] = 'Dangos safle';
$string['showrank_help'] = 'Dangos safle\'r myfyriwr mewn perthynas â gweddill y dosbarth ar gyfer pob eitem graddio?';
$string['showuserimage'] = 'Dangos delweddau proffil defnyddwyr';
$string['showuserimage_help'] = 'A ddylid dangos delwedd proffil y defnyddiwr wrth ymyl yr adroddiad graddau.';
$string['showverbose'] = 'Dangos {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Dangos pwysoliadau';
$string['showweight_help'] = 'Dangos y golofn pwysau gradd?';
$string['simpleview'] = 'Gwedd syml';
$string['sitewide'] = 'Drwy\'r safle i gyd';
$string['sort'] = 'trefnu';
$string['sortasc'] = 'Trefnu - o\'r dechrau i\'r diwedd';
$string['sortbyfirstname'] = 'Trefnu yn ôl Enw Cyntaf';
$string['sortbylastname'] = 'Trefnu yn ôl Cyfenw';
$string['sortdesc'] = 'Trefnu - o\'r diwedd i\'r dechrau';
$string['standarddeviation'] = 'Gwyriad Safonol';
$string['stats'] = 'Ystadegau';
$string['statslink'] = 'Ystadegau';
$string['student'] = 'Myfyriwr';
$string['studentsperpage'] = 'Myfyrwyr ar bob tudalen';
$string['studentsperpage_help'] = 'Mae\'r gosodiad hwn yn pennu nifer y myfyrwyr sy\'n cael eu dangos ar bob tudalen yn yr adroddiad graddau.';
$string['studentsperpagereduced'] = 'Lleihau nifer y myfyrwyr sy\'n cael eu dangos ar bob tudalen o {$a->originalstudentsperpage} i {$a->studentsperpage}. Ystyriwch gynyddu y gosodiad PHP max_input_vars o {$a->maxinputvars}.';
$string['subcategory'] = 'Categori normal';
$string['submissions'] = 'Cyflwyniadau';
$string['submittedon'] = 'Wedi cyflwyno: {$a}';
$string['switchtofullview'] = 'Newid i\'r wedd lawn';
$string['switchtosimpleview'] = 'Newid i\'r wedd syml';
$string['tabs'] = 'Tabiau';
$string['topcategory'] = 'Uwch gategori';
$string['total'] = 'Cyfanswm';
$string['totalweight100'] = 'Mae\'r cyfanswm pwysau yn hafal i 100';
$string['totalweightnot100'] = 'Nid yw\'r cyfanswm pwysau yn hafal i 100';
$string['turnfeedbackoff'] = 'Diffodd adborth';
$string['turnfeedbackon'] = 'Troi adborth ymlaen';
$string['typenone'] = 'Dim';
$string['typescale'] = 'Graddfa';
$string['typescale_help'] = 'Mae\'r gosodiad hwn yn pennu\'r raddfa a ddefnyddir wrth ddefnyddio\'r math o radd sy\'n berthnasol i\'r raddfa. Mae\'r raddfa ar gyfer eitem graddio sy\'n seiliedig ar weithgaredd yn cael ei gosod ar y dudalen gosodiadau gweithgaredd.';
$string['typetext'] = 'Testun';
$string['typevalue'] = 'Gwerth';
$string['uncategorised'] = 'Heb gategori';
$string['unchangedgrade'] = 'Gradd heb ei newid';
$string['unenrolledusersinimport'] = 'Roedd y broses fewngludo hon yn cynnwys y graddau dilynol ar gyfer defnyddwyr nad ydynt ar hyn o bryd wedi\'u cofrestru ar y cwrs hwn: {$a}';
$string['unlimitedgrades'] = 'Graddau diderfyn';
$string['unlimitedgrades_help'] = 'Yn ddiofyn, bydd graddau\'n cael eu cyfyngu gan werthoedd uchaf ac isaf posib yr eitem graddio. Bydd galluogi\'r gosodiad hwn yn dileu\'r cyfyngiad hwn, ac yn caniatáu i raddau sydd dros 100% gael eu hychwanegu\'n syth at y llyfr graddau. Argymhellir bod y gosodiad hwn yn cael ei alluogi mewn cyfnod tawel, gan y bydd angen ail-gyfrifo’r holl raddau, a allai arwain at dipyn o faich ar y gweinydd.';
$string['unlock'] = 'Dad-gloi';
$string['unlockverbose'] = 'Dad-gloi {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Heb ei ddefnyddio';
$string['updatedgradesonly'] = 'Allgludo graddau newydd neu rai a ddiweddarwyd yn unig';
$string['uploadgrades'] = 'Llwytho graddau i fyny';
$string['useadvanced'] = 'Defnyddio nodweddion uwch';
$string['usedcourses'] = 'Cyrsiau a ddefnyddiwyd';
$string['usedgradeitem'] = 'Eitem graddio a ddefnyddiwyd';
$string['usenooutcome'] = 'Peidio defnyddio deilliant';
$string['usenoscale'] = 'Peidio defnyddio graddfa';
$string['usepercent'] = 'Defnyddio Canran';
$string['user'] = 'Defnyddiwr';
$string['userenrolmentsuspended'] = 'Wedi atal cofrestriad defnyddiwr';
$string['usergrade'] = 'Defnyddiwr {$a->fullname} ({$a->useridnumber}) ar eitem {$a->gradeidnumber}';
$string['userpreferences'] = 'Dewisiadau defnyddiwr';
$string['useweighted'] = 'Defnyddio Pwysau';
$string['verbosescales'] = 'Graddfeydd cwmpasog';
$string['viewbygroup'] = 'Grŵp';
$string['viewgrades'] = 'Gweld y Graddau';
$string['warningexcludedsum'] = 'Rhybudd: nid yw eithrio graddau yn gydnaws â\'r cyfuno.';
$string['weight'] = 'pwysau';
$string['weightcourse'] = 'Defnyddio graddau wedi\'u pwysoli ar gyfer y cwrs';
$string['weightedascending'] = 'Trefnu yn ôl canran â phwysau, am i fyny';
$string['weighteddescending'] = 'Trefnu yn ôl canran â phwysau, am i lawr';
$string['weightedpct'] = '% â phwysau';
$string['weightedpctcontribution'] = 'cyfraniad % â phwysau';
$string['weightorextracredit'] = 'Pwysau neu gredyd ychwanegol';
$string['weights'] = 'Pwysau';
$string['weightsedit'] = 'Golygu pwysau a chredydau ychwanegol';
$string['weightuc'] = 'Pwysau';
$string['writinggradebookinfo'] = 'Wrthi\'n Ysgrifennu Gosodiadau\'r Llyfr Graddau';
$string['xml'] = 'XML';
$string['yes'] = 'Iawn';
$string['yourgrade'] = 'Eich gradd';
