<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'et', branch 'MOODLE_26_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Sa oled sisse loginud {$a}-na, sul on vaja välja logida enne kui logid sisse erineva kasutajana.';
$string['authnotexisting'] = 'Volituste pluginat ei eksisteeri';
$string['blockcannotconfig'] = 'See plokk ei toeta globaalset seadistust';
$string['blockcannotinistantiate'] = 'Probleem ploki objekti algväärtustamisel';
$string['blockdoesnotexist'] = 'Seda plokki ei eksisteemi';
$string['blockdoesnotexistonpage'] = 'See plokk (ID={$a->instanceid}) ei eksisteeri sellel lehel ({$a->url}).';
$string['blocknameconflict'] = 'Nimetamise konflikt: plokil {$a->name} on sama pealkiri eksisteeriva plokiga: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Kommentaari tagasisidestus lükkas tagasi kommentaari.';
$string['cannotaddcoursemodule'] = 'Ei saa lisada uut kursuse moodulit';
$string['cannotaddcoursemoduletosection'] = 'Ei saa lisada uut kursuse moodulit sellesse sektsiooni';
$string['cannotaddnewmodule'] = 'Ei saa lisada uut {$a} moodulit';
$string['cannotaddthisblocktype'] = 'Sa ei saa lisada {$a} plokki sellele lehele.';
$string['cannotassignrole'] = 'Ei saa määrata rolli kursusel';
$string['cannotassignrolehere'] = 'Sul ei ole lubatud määrata seda rolli (ID = {$a->roleid}) kontekstis ({$a->context})';
$string['cannotassignselfasparent'] = 'Ei saa määrata ennast vanemana!';
$string['cannotcallscript'] = 'Sa ei saa niimoodi seda skripti välja kutsuda';
$string['cannotcallusgetselecteduser'] = 'Sa ei saa kutsuda välja user_selector::get_selected_user kui mitmikvalik on tõene.';
$string['cannotcreatecategory'] = 'Kategooriat ei lisatud';
$string['cannotcreategroup'] = 'Viga grupi loomisel';
$string['cannotcreatelangdir'] = 'Ei saa luua lang kataloogi';
$string['cannotcreateorfindstructs'] = 'Viga otsimisel või loomisel sektsiooni struktuure selle kursuse jaoks';
$string['cannotcreatetempdir'] = 'Ei saa luua temp kataloogi';
$string['cannotcustomisefiltersblockuser'] = 'Sa ei saa kohandada filtrite seadeid kasutaja või ploki kontekstides.';
$string['cannotdeletecategorycourse'] = 'Kursuse \'{$a}\' kustutamine ebaõnnestus';
$string['cannotdeletecategoryquestions'] = 'Ei saa kustutada küsimusi kategooriast \'{$a}\'';
$string['cannotdeletecourse'] = 'Sul ei ole õigusi kustutada seda kursust';
$string['cannotdeletecustomfield'] = 'Viga kohandatud välja andmete kustutamisel';
$string['cannotdeletedir'] = 'Ei saa kustutada ({$a})';
$string['cannotdeletefile'] = 'Ei saa kustutada seda faili';
$string['cannotdeleterole'] = 'Ei saa kustutada, sest {$a}';
$string['cannotdeleterolewithid'] = 'Ei saa kustutada rolli ID\'ga {$a}';
$string['cannotdeletethisrole'] = 'Sa ei saa kustutada seda rolli, sest seda kasutab süsteem või see on viimane roll, administraatori võimekusega.';
$string['cannotdownloadcomponents'] = 'Ei saa alla tõmmata komponente.';
$string['cannotdownloadlanguageupdatelist'] = 'Ei saa alla tõmmata keelte uuenduste nimekirja saidilt download.moodle.org';
$string['cannotdownloadzipfile'] = 'Ei saa alla tõmmata ZIP faili.';
$string['cannoteditsiteform'] = 'Sa ei saa muuta saidi kursust kasutades seda vormi';
$string['cannotedityourprofile'] = 'Vabandust, sa ei saa muuta oma profiili';
$string['cannotfindcategory'] = 'Ei leia kategooria kirjet andmebaasist (ID={$a})';
$string['cannotfindcomponent'] = 'Ei leia komponenti.';
$string['cannotfindcourse'] = 'Ei leia kursust';
$string['cannotfindgradeitem'] = 'Ei leia grade_item';
$string['cannotfindteacher'] = 'Ei leia õpetajat';
$string['cannotfinduser'] = 'Ei leia kasutajat nimega "{$a}"';
$string['cannotgetcats'] = 'Ei saa kategooria kirjet';
$string['cannotgradeuser'] = 'Ei saa hinnata seda kasutajat';
$string['cannothaveparentcate'] = 'Kursuse kategooria ei saa omada vanemat!';
$string['cannotimport'] = 'Importimise viga';
$string['cannotimportformat'] = 'Vabandust, selle formaadi importimist veel ei toetata!';
$string['cannotimportgrade'] = 'Hinde impordi viga';
$string['cannotinsertgrade'] = 'EI saa sisestada hinnet ilma kursuse ID-ta!';
$string['cannotmailconfirm'] = 'Viga parooli muutmise kinnituse e-maili saatmisel';
$string['cannotmanualctrack'] = 'Tegevus ei paku käsitsi täidetuse jälgimist';
$string['cannotmapfield'] = 'Avastati seostamise kollisioon - kaks välja seostuvad sama hinde elemendiga {$a}';
$string['cannotmovecategory'] = 'Kategooria teisaldamine ei ole võimalik';
$string['cannotmovecourses'] = 'Kursuste teisaldamine praegusest kategooriast uude kategooriasse ei ole võimalik.';
$string['cannotmoverolewithid'] = 'Ei saa teisaldada rolli ID-ga {$a}';
$string['cannotopencsv'] = 'Ei saa avadaCSV-faili';
$string['cannotopenfile'] = 'Ei saa avada faili ({$a})';
$string['cannotopenforwrit'] = 'Kirjutamiseks avamine ebaõnnestus: {$a}';
$string['cannotopenzip'] = 'Sa ei saa avada ZIP-faili, võimalik, et ZIP-laienduse puuk 64-bitises operatsioonisüsteemis';
$string['cannotoverridebaserole'] = 'Ei saa ümber kehtestada baasrolli võimekusi';
$string['cannotoverriderolehere'] = 'Teil ei ole võimalik ümber kehtestada seda rolli (id = {$a->roleid}) kontekstis ({$a->context})';
$string['cannotreadfile'] = 'Ei saa lugeda faili ({$a})';
$string['cannotreadtmpfile'] = 'Viga ajutise faili lugemisel';
$string['cannotreaduploadfile'] = 'Ei saa lugeda üles laetud faili';
$string['cannotresetguestpwd'] = 'Külalise salasõna ei ole võimalik lähtestada';
$string['cannotresetmail'] = 'Viga parooli lähtestamisel ja sulle e-mailimisel';
$string['cannotrestore'] = 'Ilmnes viga ja ja taastamist ei saanud lõpetada!';
$string['cannotsavemd5file'] = 'Ei saa salvestada md5 faili.';
$string['cannotsavezipfile'] = 'Ei saa salvestada ZIP faili.';
$string['cannotservefile'] = 'Ei saa pakkuda faili -
serveri seadistuse probleem.';
$string['cannotsetparentforcatoritem'] = 'Ei saa seada kategooria või kursuse vanemat!';
$string['cannotsetpassword'] = 'Kasutaja salasõna salvestamine ebaõnnestus!';
$string['cannotshowhidecoursesincategory'] = 'Ei saa kuvada/peita kursusi kategoorias {$a}.';
$string['cannotunassigncap'] = 'Ei saa eemaldada ebasoovitavaid võimekusi {$a->cap} rollist {$a->role}';
$string['cannotunzipfile'] = 'Ei saa lahti pakkida faili.';
$string['cannotupdatemod'] = 'Ei saanud uuendada {$a}';
$string['cannotupdatepasswordonextauth'] = 'Ebaõnnestus parooli uuendamine välises autentimises: {$a}. Detailide saamiseks vaata serveri logisid.';
$string['cannotupdateprofile'] = 'Viga kasutajakirje uuendamisel';
$string['cannotupdateusermsgpref'] = 'Ei saa uuendada kasutaja teadete eelistusi';
$string['cannotupdateuseronexauth'] = 'Ebaõnnestus kasutaja andmete uuendamine välises autentimises: {$a}. Detailide saamiseks vaata serveri logisid.';
$string['cannotuploadfile'] = 'Viga üleslaetud faili töötlemisel';
$string['cannotusepage2'] = 'Vabandust, sa ei või kasutada seda lehte';
$string['cannotviewprofile'] = 'Sa ei saa vaadata selle kasutaja profiili.';
$string['cannotviewreport'] = 'Sa ei saa vaadata seda raportit';
$string['categoryerror'] = 'Kategooria viga';
$string['categorynamerequired'] = 'Kategooria nimi on nõutud';
$string['categorytoolong'] = 'Kategooria nimi liiga pikk';
$string['componentisuptodate'] = 'Komponent on ajakohane';
$string['confirmsesskeybad'] = 'Vabandame, aga sinu sessiooni võtit ei suudetud kinnitada selle tegevuse sooritamiseks. Selline turvalisuse vahend takistab tähtsate funktsioonide kogemata või pahatahtlikult käivitamist sinu nime alt. Palun tee kindlaks, kas sa tõesti soovisid käivitada seda funktsiooni.';
$string['couldnotassignrole'] = 'Tõsine, kuid teadmata viga tekkis, kui prooviti määrata Sinule rolli';
$string['coursedoesnotbelongtocategory'] = 'Kursus ei kuulu sellesse kategooriasse';
$string['coursegroupunknown'] = 'Rühmale {$a} vastavat kursust ei ole määratud';
$string['courseidnotfound'] = 'Kursuse ID ei eksisteeri';
$string['coursemisconf'] = 'Kursus on seadistamata';
$string['courserequestdisabled'] = 'Vabandust, kursuste taotlemine on välja lülitatud administraatori poolt';
$string['csvcolumnduplicates'] = 'Leitud dubleerivad veerud';
$string['csvemptyfile'] = 'CSV-fail on tühi';
$string['csvfewcolumns'] = 'Pole piisavalt veergusid, palun kontrolli eraldaja seadistust';
$string['csvinvalidcols'] = '<b>Vigane CSV-fail:</b> Esimene rida peab sisaldama "Header Fields" ja fail peab olema  <br />"Expanded Fields/Comma Separated" tüüpi<br />või<br /> "Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'Vigane CSV-fail - iga rida peab sisaldama 49 või 70 välja';
$string['csvloaderror'] = 'CSV-faili laadimisel tekkis viga!';
$string['csvweirdcolumns'] = 'Vigane CSV-formaat - veergude arg ei ole konstantne!';
$string['dbconnectionfailed'] = '<p>Viga: Andmebaasi ühendus ebaõnnestus</p> <p>On võimalik, et andmebaas on üle koormatud või ei tööta korralikult.</p> <p>Saidi administraator peaks kontrollima ka andmebaasi detaile, et nood oleksid korrektselt seadistatud failis config.php</p>';
$string['dbdriverproblem'] = '<p>Viga: leiti andmebaasi draiveri probleem</p> <p>Saidi administraator peaks kontrollima serveri seadistust</p><p>{$a}</p>';
$string['dbsessionhandlerproblem'] = 'Andmebaasiserveriga seansi loomine ebaõnnestus.<br /><br />Palun teavita serveri administraatorit.';
$string['dbsessionmysqlpacketsize'] = 'Tõsine seansi viga ilmnes.<br /><br />Palun teavita administraatorit, see probleem tõenäoliselt põhjustatud max_allowed_packet väiksest väärtusest MySQL seadistuses.';
$string['dbupdatefailed'] = 'Andmebaasi uuendamine ebaõnnestus';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" ei saa muuta. Leiti sõltuvus {$a->offendingtype} "{$a->offendingname}"\'ga';
$string['ddlexecuteerror'] = 'DDL SQL käivitamise viga';
$string['ddlfieldalreadyexists'] = 'Välja "{$a}" ei eksisteeri';
$string['ddlfieldnotexist'] = 'Välja "{$a->fieldname}" ei eksisteeri tabelis "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabel "{$a}" juba eksisteerib';
$string['ddltablenotexist'] = 'Tabelit "{$a}" ei eksisteeri';
$string['ddlunknownerror'] = 'Tundmatu DDL-teegi viga';
$string['ddlxmlfileerror'] = 'Leiti XML-andmebaasifaili vigu';
$string['ddsequenceerror'] = 'Vigane tabeli "{$a}" definitsioon; siin saab olla ainult üks automaatne veerg ja see peab olema defineeritud võtmena.';
$string['detectedbrokenplugin'] = 'Plugin "{$a}" on katkine või iganenud, mistõttu ei saa jätkata, vabandust.';
$string['dmlreadexception'] = 'Viga andmebaasist lugemisel';
$string['dmltransactionexception'] = 'Andmebaasi transaktsiooni viga';
$string['dmlwriteexception'] = 'Viga andmebaasi kirjutamisel';
$string['downgradedcore'] = 'VIGA!!! Kood, mida kasutad on VANEM kui versioon, millega tehti need andmebaasid!';
$string['downloadedfilecheckfailed'] = 'Alla laetud faili kontroll ebaõnnestus.';
$string['duplicatefieldname'] = 'Leiti korduv välja nimi "{$a}"';
$string['duplicateparaminsql'] = 'VIGA: päringus dubleeriv parameetri nimi';
$string['duplicateusername'] = 'Korduv kasutajanimi - kirje jäetakse vahele';
$string['error'] = 'Juhtus viga';
$string['errorcleaningdirectory'] = 'Viga kataloogi "{$a}" puhastamisel';
$string['errorcopyingfiles'] = 'Viga faili kopeerimisel';
$string['errorcreatingdirectory'] = 'Viga kataloogi "{$a}" loomisel';
$string['errorcreatingfile'] = 'Viga faili "{$a}" loomisel';
$string['errorfetchingrssfeed'] = 'Viga RSS sööte hankimisel';
$string['erroronline'] = 'Real {$a} tekkis viga';
$string['errorparsingxml'] = 'Viga XML-i parsimisel: {$a->errorstring} real {$a->errorline}, märk {$a->errorchar}';
$string['errorreadingfile'] = 'Viga faili "{$a}" lugemisel';
$string['errorsettinguserpref'] = 'Viga kasutaja eelistuse seadistamisel';
$string['errorunzippingfiles'] = 'Viga failide lahtipakkimisel';
$string['expiredkey'] = 'Aegunud võti';
$string['externalauthpassworderror'] = 'Mitte tühi parool väliseks autentimiseks';
$string['fieldrequired'] = '"{$a}" on kohustuslik väli';
$string['fileexists'] = 'Fail on juba olemas';
$string['filenotfound'] = 'Vabandame , soovitud faili ei leitud';
$string['filenotreadable'] = 'Fail ei ole loetav';
$string['filterdoesnothavelocalconfig'] = 'Filter {$a} ei luba kohalikku seadistust.';
$string['filternotenabled'] = 'Filter ei ole sisse lülitatud!';
$string['filternotinstalled'] = 'Filter {$a} ei ole praegu installeeritud';
$string['forumblockingtoomanyposts'] = 'You have exceeded the posting threshold set for this forum.';
$string['generalexceptionmessage'] = 'Ootamatus - {$a}';
$string['gradepubdisable'] = 'Hinde publitseerimine välja lülitatud';
$string['groupalready'] = 'Kasutaja kuulub juba rühma {$a}';
$string['groupexistforcourse'] = 'Grupp "{$a}" juba eksisteerib sellel kursusel';
$string['groupnotaddederror'] = 'Gruppi "{$a}" ei lisatud';
$string['groupunknown'] = 'Rühm {$a} ei ole määratud ühelegi kursusele';
$string['groupusernotmember'] = 'Kasutaja ei ole selle grupi liige';
$string['guestnoeditprofile'] = 'Külaline ei saa muuta nende profiili';
$string['guestnoeditprofileother'] = 'Külalise profiili ei muuta';
$string['guestsarenotallowed'] = 'Külalisele ei ole lubatud seda teha';
$string['hashpoolproblem'] = 'Mittesobiv laofaili sisu {$a}.';
$string['headersent'] = 'Päised juba saadetud';
$string['idnumbertaken'] = 'ID-number on kasutusel muul kursusel';
$string['idnumbertoolong'] = 'ID number on liiga pikk';
$string['importformatnotimplement'] = 'Vabandust, selle formaadi importimist veel ei toetata!';
$string['installproblem'] = 'Tavaliselt ei ole võimalik taastuda vigadest, mis ilmusid installeerimise ajal, sa pead looma uued andmebaasid või kasutama erinevat andmebaasi prefiksit, kui sa tahad uuesti installeerida';
$string['internalauthpassworderror'] = 'Parool puudu või vigane sisese autentimise parooli eeskiri';
$string['invalidaccess'] = 'Selle lehe poole pöördumine ei olnud korrektne';
$string['invalidaccessparameter'] = 'Vigane ligipääsu parameeter';
$string['invalidaction'] = 'Vigane tegevuse parameeter';
$string['invalidadminsettingname'] = 'Vigane admin\'i seade ({$a})';
$string['invalidargorconf'] = 'Ei antud kaasa korrektseid argumente või vale serveri seadistus';
$string['invalidarguments'] = 'Kaasa ei antud korrektseid argumente';
$string['invalidbulkenrolop'] = 'Vigahe hulgi registreerumise operatsiooni päring.';
$string['invalidcategory'] = 'Vigane kategooria';
$string['invalidcategoryid'] = 'Vigane kategooria id!';
$string['invalidcomment'] = 'Kommentaar on ebakorrektne';
$string['invalidcommentarea'] = 'Vigane kommentaari ala';
$string['invalidcommentid'] = 'Vigane kommentaari ID';
$string['invalidcommentitemid'] = 'Vigane kommentaari itemid';
$string['invalidcommentparam'] = 'Vigased kommentaari parameetrid';
$string['invalidcomponent'] = 'Vigane komponendi nimi';
$string['invalidconfirmdata'] = 'Vigased kinnitamise andmed';
$string['invalidcontext'] = 'Vigane kontekst';
$string['invalidcourse'] = 'Vigane kursus';
$string['invalidcourselevel'] = 'Vigane konteksti tase';
$string['invalidcoursemodule'] = 'Vigane kursuse mooduli ID';
$string['invalidcoursenameshort'] = 'Vigane kursuse lühinimi';
$string['invaliddata'] = 'Postitatud andmed on vigased';
$string['invaliddatarootpermissions'] = 'Vigased õigused avastati kataloogis $CFG->dataroot, administraatori on vaja probleemi lahendamiseks.';
$string['invaliddevicetype'] = 'Vigane seadme tüüp';
$string['invalidelementid'] = 'Vigane elemendi ID!';
$string['invalidentry'] = 'See ei ole korrektne sissekanne';
$string['invalidevent'] = 'Vigane sündmus';
$string['invalidfieldname'] = '"{$a}" ei ole korrektne failinimi';
$string['invalidfiletype'] = '"{$a}" ei ole sobilik failitüüp';
$string['invalidformdata'] = 'Vigased vormi andmed';
$string['invalidfunction'] = 'Vigane funktsioon';
$string['invalidgradeitemid'] = 'Vigane hinde elemendi ID';
$string['invalidgroupid'] = 'Spetsifitseeritud vigane grupi ID';
$string['invalidipformat'] = 'Vigane IP-aadressi formaat';
$string['invaliditemid'] = 'Vigane elemendi ID';
$string['invalidkey'] = 'Vigane võti';
$string['invalidlegacy'] = 'Vigane pärandrolli definitsioon tüübile: {$a}';
$string['invalidmd5'] = 'Vigane md5';
$string['invalidmode'] = 'Vigane laad ({$a})';
$string['invalidnum'] = 'Vigane numbriline väärtus';
$string['invalidnumkey'] = '$conditions massiiv paistab sisaldavat numbrilisi võtmeid, palun paranda programmikoodi!';
$string['invalidoutcome'] = 'Vigane tulemuse ID';
$string['invalidpagesize'] = 'Vigane lehe suurus';
$string['invalidpasswordpolicy'] = 'Vigane salasõna tingimus';
$string['invalidpaymentmethod'] = 'Vigane makse meetod: {$a}';
$string['invalidqueryparam'] = 'VIGA: vale päringu parameetrite arv. Eeldati {$a->expected}, saadi {$a->actual}.';
$string['invalidratingarea'] = 'Vigane hindamise
ala';
$string['invalidrecord'] = 'Ei leia andmekirjet andmebaasitabelist {$a}.';
$string['invalidrecordunknown'] = 'Ei leia andmekirjet andmebaasist.';
$string['invalidrequest'] = 'Vigane päring';
$string['invalidrole'] = 'Vigane roll';
$string['invalidroleid'] = 'Vigane rolli ID';
$string['invalidscaleid'] = 'Vigane skaala ID';
$string['invalidsection'] = 'Kursuse mooduli kirje sisaldab vigast sektsiooni';
$string['invalidsesskey'] = 'Esitati vigane seansivõti, vormi ei võetud vastu!';
$string['invalidshortname'] = 'See on vigane lühike kursuse nimi';
$string['invalidstatedetected'] = 'Midagi läks valesti: {$a}. Seda ei oleks pidanud mitte kunagi normaalselt juhtuma.';
$string['invalidurl'] = 'Vigane URL';
$string['invaliduser'] = 'Vigane kasutaja';
$string['invaliduserid'] = 'Vigane kasutaja id';
$string['invalidxmlfile'] = '"{$a}" ei ole korrektne XML-fail';
$string['iplookupfailed'] = 'Ei leia geo-infot IP-aadressi {$a} kohta';
$string['iplookupprivate'] = 'Ei saa kuvada otsingut privaatsele  IP-aadressile';
$string['ipmismatch'] = 'Kliendi ID-aadressi sobimatus';
$string['listcantmovedown'] = 'Ebaõnnestus elemendi nihutamine allapoole, see on selle partneri viimane';
$string['listcantmoveleft'] = 'Ebaõnnestus nihutada elementi vasakule, sest polnud vanemat';
$string['listcantmoveright'] = 'Ebaõnnestus nihutada elementi paremale, sest seal ei olnud partnerit, et teha ta selle järglaseks. Nihuta ta teise partneri alla ja siis sa saad nihutada seda paremale.';
$string['listcantmoveup'] = 'Ebaõnnestus nihutada elementi üles, kuna see on esimene oma partneritest';
$string['listnoitem'] = 'Elementi ei leitud';
$string['logfilenotavailable'] = 'Logisid ei ole kättesaadaval';
$string['loginasnoenrol'] = 'Sa ei saa kasutada registreeru või registreeru maha kui oled kursusel "Sisene kui" seansina';
$string['loginasonecourse'] = 'Te ei saa siseneda sellele kursusele.
<br /> Te peate lõpetama
"Sisene kui" seansi enne teisele kursusele sisenemist';
$string['maxbytes'] = 'Fail on suurem, kui maksimaalselt lubatud suurus.';
$string['messagingdisable'] = 'Sõnumivahetus on välja lülitatud siin saidil';
$string['mimetexisnotexist'] = 'Teie süsteem ei ole valmis mimeTeX
jaoks. Te peate allalaadima
vajalikud
programmid PHP_OS platform from <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a>, või soetama
C lähtekoodi saidilt <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>,
kompileerige see ja pange programmifail oma moodle/filter/tex/ kataloogi.';
$string['mimetexnotexecutable'] = 'Kohandatud mimetex ei ole käivitatav!';
$string['missingfield'] = 'Väli "{$a}" on puudu';
$string['missingkeyinsql'] = 'VIGA: päringus puudu parameeter "{$a}"';
$string['missing_moodle_backup_xml_file'] = 'Tagavarakoopias on puudu XML-fail: {$a}';
$string['missingparam'] = 'Nõutud parameeter ({$a}) oli puudu';
$string['missingparameter'] = 'Parameeter puudu';
$string['missingrequiredfield'] = 'Mõned nõutud väljad on puudu';
$string['missinguseranditemid'] = 'Puuduv userid ja itemid';
$string['mixedtypesqlparam'] = 'VIGA: segatud SQL-tüüpide parameetrid!!';
$string['mnetdisable'] = 'MNET on välja lülitatud';
$string['mnetlocal'] = 'Välised MNet kasutajad ei saa sisse logida lokaalselt';
$string['moduledisable'] = 'Moodul ({$a}) on välja lülitatud selle kursuse jaoks';
$string['moduledoesnotexist'] = 'Seda moodulit ei eksisteeri';
$string['modulemissingcode'] = 'Moodul {$a} on puudu, mille programmikoodi on vaja selle funktsiooni teostamiseks';
$string['movecategorynotpossible'] = 'Sa ei saa teisaldada kategooriat \'{$a}\' valitud kategooriasse.';
$string['multiplerecordsfound'] = 'Mitu kirjet leiti, ainult ühte oodati.';
$string['mustbeloggedin'] = 'Sa pead selle tegemiseks sisse logima';
$string['mustbeteacher'] = 'Selle lehe vaatamiseks pead olema õpetaja';
$string['myisamproblem'] = 'Andmebaasi tabelid on kasutamas MyISAM andmebaasi mootorit, see on soovitatav kasutada ACID ücompliant engine with full transaction support such as InnoDB.';
$string['needcopy'] = 'Sul on vaja enne midagi kopeerida!';
$string['needcoursecategroyid'] = 'Kursuse id või kategooria peab olema määratud';
$string['needphpext'] = 'Sul on vaja lisada {$a} toetus PHP-i paigaldusele';
$string['noadmins'] = 'Pole administraatoreid!';
$string['noblocks'] = 'Plokke ei leitud!';
$string['nocapabilitytousethisservice'] = 'Kasutajal ei ole vajalikku võimekust kasutamaks seda teenust';
$string['nocategorydelete'] = 'Kategooriat \'{$a}\' ei saa kustutada!';
$string['nocontext'] = 'Vabandust, aga see kursus ei ole sobiv kontekst';
$string['nodata'] = 'Pole andmeid';
$string['noexistingcategory'] = 'Pole eksisteerivat kategooriat';
$string['nofile'] = 'Faili ei ole määratletud';
$string['nofiltersenabled'] = 'Ühtegi filtrit pole sisse lülitatud.';
$string['nofolder'] = 'Päritud kataloogi ei eksisteeri';
$string['noformdesc'] = 'Ei leitud formslib vormi kirjelduse faili selle tegevuse jaoks.';
$string['noguest'] = 'Külalistel puudub siia ligipääs!';
$string['noinstances'] = 'Selles kursuses puuduvad {$a} isendid';
$string['nologinas'] = 'Sul ei ole lubatud selle kasutajana sisse logida';
$string['noparticipants'] = 'Ei leitud osalejaid sellele kursusele';
$string['nopermissions'] = 'Vabandust, kuid Sa ei oma selleks õigusi ({$a})';
$string['nopermissiontocomment'] = 'Sa ei saa lisada kommentaare';
$string['nopermissiontodelentry'] = 'Sa ei saa kustutada teiste kasutajate sissekandeid!';
$string['nopermissiontohide'] = 'Pole õigusi peitmiseks!';
$string['nopermissiontoimportact'] = 'Sul ei ole vajalikke õigusi importimaks tegevusi sellesse kursusesse';
$string['nopermissiontolock'] = 'Pole õigusi lukustamiseks!';
$string['nopermissiontoshow'] = 'Pole õigusi seda näha!';
$string['nopermissiontounlock'] = 'Pole õigusi lukust lahti teha!';
$string['nopermissiontoupdatecalendar'] = 'Vabandust, aga sul ei ole praegu õigusi uuendada kalendisündmust';
$string['nopermissiontoviewgrades'] = 'Ei saa vaadata hindeid.';
$string['nopermissiontoviewletergrade'] = 'Puudub õigus nägemaks tähelisi hindeid';
$string['nosite'] = 'Ei leia ülem-taseme kursust!';
$string['nostatstodisplay'] = 'V';
$string['notallowedtoupdateprefremotely'] = 'Sulle ei ole lubatud uuendada selle kasutaja eelistust väliselt';
$string['notavailable'] = 'See ei ole momendil saadaval';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Sa ei ole selle kursuse grupi liige';
$string['notownerofkey'] = 'Sa pole selle võtme omanik';
$string['nousers'] = 'Pole sellist kasutajat';
$string['onlyadmins'] = 'Ainult administraatorid saavada seda teha';
$string['onlyeditown'] = 'Sa saad muuta ainult iseenda andmeid';
$string['orderidnotfound'] = 'Tellimuse ID-d {$a} ei leitud';
$string['pagenotexist'] = 'Juhtus ebaharilik viga (prooviti jõuda leheni, mida ei eksisteeri)';
$string['pathdoesnotstartslash'] = 'Ei antud kaasa lubatavaid argumente, rada ei alga kaldkriipsuga!';
$string['pleasereport'] = 'Kui Sul on aega, siis palun anna meile teada, mida proovisid teha, mil viga tekkis:';
$string['pluginrequirementsnotmet'] = 'Plugin "{$a->pluginname}" ({$a->pluginversion}) ei saanud installeerida. Ta vajab uuemat Moodle versiooni (praegu kasutad versiooni {$a->currentmoodle}, Sa vajad versiooni {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p>Viga: andmebaasi tabeli prefiks ei saa olla tühi ({$a})</p> <p>Saidi administraator peab parandama selle probleemi.</p>';
$string['prefixtoolong'] = '<p>Viga: andmebaasi tabeli prefiks on liiga pikk ({$a->dbfamily})</p> <p>Saidi administraator peab parandama selle probleemi. Maksimaalne tabeliprefiksi pikkus  {$a->dbfamily}\'s on {$a->maxlength} märki.</p>';
$string['processingstops'] = 'Töötlemine lõpeb siin. Allesjäänud kirjeid ignoreeritakse.';
$string['redirecterrordetected'] = 'Avastati mitte toetatud ümber suunamine, skripti käivitamine katkestati';
$string['refoundto'] = 'Võib tagastada
{$a}-le';
$string['refoundtoorigi'] = 'Tagastatud algses koguses: {$a}';
$string['remotedownloaderror'] = 'Komponendi alla tõmbamine serverisse ebaõnnestus, palun kontrolli proksi seadeid, PHP cURL laiendus on tungivalt soovitatav.<br /><br />Sa pead tõmbama <a href="{$a->url}">{$a->url}</a> faili käsitsi, kopeerima selle "{$a->dest}" oma serveris ja pakkima lahti sinna.';
$string['remotedownloadnotallowed'] = 'Komponentide alla tõmbamine ei ole Sinu serverisse lubatud (sest allow_url_fopen keelatud).<br /><br />Sa pead tõmbama alla faili <a href="{$a->url}">{$a->url}</a> käsitsti, kopeerima "{$a->dest}" oma serveris ja sinna lahti pakkima.';
$string['reportnotavailable'] = 'Seda raporti tüüp on kättesaadav ainult saidi kursusele';
$string['requirecorrectaccess'] = 'Vigane URL või port.';
$string['requireloginerror'] = 'Kursus või tegevus pole ligipääsetav.';
$string['restore_path_element_missingmethod'] = 'Taastamise meetod {$a} on puudu. See peab olema defineeritud arendaja poolt.';
$string['restore_path_element_noobject'] = 'Restaureeritav objekt {$a} ei ole objekt.';
$string['restrictedcontextexception'] = 'Vabandust, välise funktsiooni käivitamine rikub konteksti piirangut.';
$string['restricteduser'] = 'Vabandust, kuid sinu kontol "{$a}" ei ole õigusi seda teha.';
$string['reverseproxyabused'] = 'Pöördproksi sisse lülitatud, serveri poole ei saa otse pöörduda, vabandust.<br />Palun võta ühendust serveri administraatoriga.';
$string['rpcerror'] = 'Ooops! Sinu MNET ühendus ebaõnnestus! Siin on veateade edastamiseks oma administraatorile: {$a}';
$string['scheduledbackupsdisabled'] = 'Plaanilised varundused on välja lülitatud serveri administraatori poolt';
$string['secretalreadyused'] = 'Parooli muutmise kinnitamise link oli juba kasutatud, parooli ei muudetud';
$string['sectionnotexist'] = 'Seda sektsiooni ei eksisteeri';
$string['sendmessage'] = 'Saada teade';
$string['sessioncookiesdisable'] = 'require_key_login() vigane kasutus - seansi küpsised peavad olema välja lülitatud!';
$string['sessiondiskfull'] = 'Seansside kogus on täis saanud. Ei ole võimalik sisse logida praegu.<br /><br />Palun teavita serveri administraatorit.';
$string['sessionerroruser'] = 'Sinu sessioon on aegunud. Palun sisene uuesti.';
$string['sessionipnomatch'] = 'Vabandame, aga sinu IP aadress on peale viimast sisenemist muutunud. Selline turvalisuse vahend takistab kräkkereid varastamast sinu identiteeti. Tavalised kasutajad ei tohiks seda teadet näha. Palun pöördu abi saamiseks õpikeskkonna administraatori poole.';
$string['sessionipnomatch2'] = 'Vabandust, aga su IP-aadress paistab olevat muutunud, mil sisse logisid. See on turvameede takistamaks kräkkeritel varastamaks su identiteeti, mil oled saidile sisse logitud. Sa võid näha seda viga, kui oled sisse logitud kasutades traadita võrke või kui rändled mööda erinevaid võrkusid. Palun küsi saidi administraatorilt rohkem abi.<br /><br />Kui soovid jätkata, siis vajuta F5 klahvi lehe värskendamiseks.';
$string['shortnametaken'] = 'Lühinimi on juba kasutusel ühe olemasoleva kursuse jaoks';
$string['socksnotsupported'] = 'SOCKS5 proksi ei ole toetatav PHP4-s';
$string['spellcheckernotconf'] = 'Õigekirjakontroll on konfigureerimata';
$string['sslonlyaccess'] = 'Turvakaalutluste tõttu on ainult HTTPS ühendused lubatud, vabandust.';
$string['statscatchupmode'] = 'Statistika on praegu tagantjärele töötlemise olekus. Seni on {$a->daysdone} päeva töödeldud ja {$a->dayspending} veel ootel. Kontrolli varsti uuesti!';
$string['statsdisable'] = 'Statistika ei ole lubatud.';
$string['statsnodata'] = 'Selle kursuse ja ajaperioodi kohta ei ole kättesaadavaid andmeid.';
$string['storedfilecannotcreatefiledirs'] = 'Ei saa luua kohalikku hoiustuse katalooge, palun kontrolli õigusi andmete juurkataloogis (dataroot) .';
$string['storedfilecannotread'] = 'Ei saa lugeda faili, sest kas faili ei eksisteeri või õiguste probleemid';
$string['storedfilenotcreated'] = 'Ei saa luua faili "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}/{$a->filepath}/{$a->filename}"';
$string['storedfileproblem'] = 'Tundmatu erand, seonduvalt kohalike failidega ({$a})';
$string['tagdisabled'] = 'Märksõnad on välja lülitatud!';
$string['targetdatabasenotempty'] = 'Sihtandmebaas ei ole tühi. Ülekanne katkestati ohutuse tagamiseks.';
$string['textconditionsnotallowed'] = 'Tekstiveergude võrdlemine ei ole lubatud. Palun kasuta oma päringus sql_compare_text().';
$string['TODO'] = 'VAJA TEHA (TODO)';
$string['tokengenerationfailed'] = 'Ei saa genereerida uut luba.';
$string['transactionvoid'] = 'Transaktsiooni ei saa tühistada, sest ta on juba tühistatud';
$string['unicodeupgradeerror'] = 'Vabandust, kuid Sinu andmebaas ei ole enam Unicodes, ja Moodle jooksev versioon ei ole võimeline Sinu andmebaasi migreerima unicode. Palun uuendage esimesena Moodle versioonile 1.7.x ja teostage Unicode migreerimine administraatori lehel. Pärast seda peaksid saama migreerida Moodle {$a}';
$string['unknowaction'] = 'Tundmatu tegevus!';
$string['unknowcategory'] = 'Kategooriat ei teata!';
$string['unknowcontext'] = 'See on tundmatu kontekst ({$a}) get_child_contexts\'s!';
$string['unknowformat'] = 'Ei teata formaati ({$a})';
$string['unknownbackupexporterror'] = 'Tundmatu viga valmistab infot importimiseks';
$string['unknownblockregion'] = 'Ploki regioon \'{$a}\' ei ole tunnustatud sellel lehel.';
$string['unknowncontext'] = 'See on tundmatu kontekst.';
$string['unknowncourse'] = 'Tundmatu kursus "{$a}"';
$string['unknowncourseidnumber'] = 'Tundmatu kursuse ID "{$a}"';
$string['unknowncourserequest'] = 'Tundmatu kursuse päring';
$string['unknowngroup'] = 'Tundmatu grupp "{$a}"';
$string['unknownmodulename'] = 'Tundmatu mooduli nimi vormile';
$string['unknownrole'] = 'Tundmatu roll "{$a}"';
$string['unknownsortcolumn'] = 'Tundmatu sorteerimise veerg {$a}';
$string['unknownuseraction'] = 'Sorry, I do not understand this user action.';
$string['unknownuserselector'] = 'Tundmatu kasutaja valija';
$string['unknoworder'] = 'Tundmatu järjestus';
$string['unknowparamtype'] = 'Tundmatu parameetri tüüp: {$a}';
$string['unknowquestiontype'] = 'Mitte toetatav küsimuse tüüp {$a}';
$string['unknowuploadaction'] = 'Viga: tundmatu üles laadimise tegevus ({$a})';
$string['unspecifycourseid'] = 'Sa pead andma kursuse ID, lühinime või ID-numbri';
$string['unsupportedstate'] = 'Toetamata täidetuse staatus';
$string['unsupportedwebserver'] = 'Veebiserveri tarkvara ({$a}) ei ole toetatav, vabandust.';
$string['upgraderequires19'] = 'Viga: Uus Moodle versioon oli installeeritud serverisse, kahjuks täiendust eelnevalt versioonilt ei ole toetatud.<br />Palun alguses uuenda viimase 1.9.x väljalaske versioonile. Sa saad samuti tagasi minna eelmise versiooni juurdse paigaldades tagasi algsed failid.';
$string['upgraderunning'] = 'Sait on uuendamisel, palun proovi hiljem uuesti.';
$string['useradmineditadmin'] = 'Ainult administraatoritel on lubatud muuta teiste administraatorite kontosid';
$string['useradminodelete'] = 'Administraatori kontot ei saa kustutada';
$string['userautherror'] = 'Tundmatu autentimisplugin';
$string['userauthunsupported'] = 'Autentimisplugin ei ole siin toetatud';
$string['useremailduplicate'] = 'Dubleeri aadress';
$string['usermustbemnet'] = 'Kasutajad MNET ligipääsukontrolli nimekirjas peavad olema välised MNET kasutajad';
$string['usernotaddederror'] = 'Kasutajat ei lisatud - viga';
$string['usernotaddedregistered'] = 'Kasutajat ei lisatud - selline kasutaja on juba olemas';
$string['usernotavailable'] = 'Selle kasutaja üksikasjad ei ole sinule nähtavad.';
$string['usernotdeletedadmin'] = 'Kasutajat ei kustutatud - ei saa kustutada administraatori kontosid';
$string['usernotdeletederror'] = 'Kasutajat ei kustutatud - viga';
$string['usernotdeletedmissing'] = 'Kasutajat ei kustutatud - ei leitud kasutajanime';
$string['usernotdeletedoff'] = 'Kasutajat ei kustutatud - kustutamine polnud lubatud';
$string['usernotincourse'] = 'See kasutaja ei ole sellel kursusel!';
$string['usernotrenamedadmin'] = 'Ei saa nimetada ümber admin\'i kontot';
$string['usernotrenamedexists'] = 'Kasutajat ei nimetatud ümber - uus kasutajanimi on juba kasutusel';
$string['usernotrenamedmissing'] = 'Kasutajat ei nimetatud ümber - ei leidnud vana kasutajanime';
$string['usernotrenamedoff'] = 'Kasutajat ei nimetatud ümber - pole lubatud';
$string['usernotupdatedadmin'] = 'Ei saa uuendada admin\'i kontot';
$string['usernotupdatederror'] = 'Kasutajat ei uuendatud - viga';
$string['usernotupdatednotexists'] = 'Kasutajat ei uuendatud - ei eksisteeri';
$string['userquotalimit'] = 'Sinu kasutatav ruum sai otsa.';
$string['userselectortoomany'] = 'user_selector sai rohkem kui üle valitud kasutaja, kuigi mitmikvalik oli väär.';
$string['wrongcall'] = 'See skript on välja kutsutud valesti';
$string['wrongdestpath'] = 'Vale sihtrada';
$string['wrongroleid'] = 'Vigane rolli ID';
$string['wrongsourcebase'] = 'Vale allika URL\'i baas.';
$string['wrongusernamepassword'] = 'Vale kasutaja/salasõna';
$string['wrongzipfilename'] = 'Vale ZIP failinimi';
$string['wwwrootmismatch'] = 'Lubamatu pöördus avastati, selle serveri poole peab olema pöördutud ainult läbi aadressi "{$a}", vabandust.<br />Palun teavita serveri administraatorit.';
$string['wwwrootslash'] = 'Avastati vigane $CFG->wwwroot failis config.php, see peab mitte sisaldama lõpus kaldkriipsu.<br />Palun teavita serveri administraatorit.';
$string['xmldberror'] = 'XMLDB viga!';
$string['youcannotdeletecategory'] = 'Sa ei saa kustutada kategooriat \'{$a}\', sest sa ei saa ei kustuda sisusid ega teisaldada mujale.';
