<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_ldap', language 'et', branch 'MOODLE_26_STABLE'
 *
 * @package   enrol_ldap
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignrole'] = 'Rolli \'{$a->role_shortname}\' määramine kasutajale \'{$a->user_username}\' kursuses \'{$a->course_shortname}\' (ID on {$a->course_id})';
$string['assignrolefailed'] = 'Rolli \'{$a->role_shortname}\' määramine kasutajale \'{$a->user_username}\' kursusel \'{$a->course_shortname}\' (id {$a->course_id}) ebaõnnestus';
$string['autocreate'] = 'Kursusi saab tekitada automaatselt, kui on olemas registreerumised kursustele, mida Moodle\'is veel ei eksisteeri.';
$string['autocreate_key'] = 'Loo automaatselt';
$string['autocreation_settings'] = 'Automaatse kursuse tekitamise seaded';
$string['bind_dn'] = 'Kui sa tahad kasutada bind-user\'it kasutajate otsimiseks, siis täpsusta valikud siin. Näiteks \'cn=ldapuser,ou=public,o=org\'';
$string['bind_pw'] = 'Salasõna bind-user tarvis';
$string['bind_pw_key'] = 'Salasõna';
$string['bind_settings'] = 'Blind seaded';
$string['cannotcreatecourse'] = 'Ei saa luu kursust: puudub nõudavad andmed LDAP-kirjest!';
$string['category'] = 'Automaatselt loodud kursuste kategooria';
$string['category_key'] = 'Kategooria';
$string['contexts'] = 'LDAP\'i kontekst';
$string['couldnotfinduser'] = 'Ei leia kasutajat \'{$a}\', jäetakse vahele';
$string['course_fullname'] = 'Valikuline: LDAP väli, kust saab täisnime';
$string['course_fullname_key'] = 'Täisnimi';
$string['course_idnumber'] = 'Märgi LDAP\'i unikaalne identifikaator, tavaliselt
<em>cn</em> või <em>uid</em>. Väärtused on soovitatav lukustada, kui kasutad automaatset kursuste loomist.';
$string['course_idnumber_key'] = 'ID-number';
$string['course_search_sub_key'] = 'Otsi alamsisusid';
$string['course_settings'] = 'Kursusele registreerumise seaded';
$string['course_shortname'] = 'Valikuline:  LDAP väli, kust saab lühinime.';
$string['course_shortname_key'] = 'Lühinimi';
$string['course_summary'] = 'Valikuline: LDAP väli , kust saab kokkuvõtte.';
$string['course_summary_key'] = 'Lühikokkuvõte';
$string['createnotcourseextid'] = 'Kasutaja registreerus mitte eksisteerivale kursusele \'{$a->courseextid}';
$string['editlock'] = 'Lukusta väärtus';
$string['enrolname'] = 'LDAP';
$string['explodegroupusertypenotsupported'] = 'ldap_explode_group() ei teoata valitud kasutajatüüpi: {$a}';
$string['extcourseidinvalid'] = 'Kursuse väline ID on vigane!';
$string['extremovedunenrol'] = 'Registreeri maha \'{$a->user_username}\' kursuselt \'{$a->course_shortname}\' (ID on {$a->course_id})';
$string['failed'] = 'Ebaõnnestunud';
$string['general_options'] = 'Üldised valikud';
$string['host_url'] = 'Täpsusta LDAP host URL formaadis, näiteks
\'ldap://ldap.myorg.com/\'
või \'ldaps://ldap.myorg.com/\'';
$string['host_url_key'] = 'Hosti URL';
$string['idnumber_attribute_key'] = 'ID-numbri atribuut';
$string['ldap_encoding'] = 'Määra kodeering, mida kasutatab LDAP-server. Kõige tõenäolisemalt utf-8, MS AD v2 kasutav vaikimisi platvormi kodeeringutm n.t. cp1252, cp1250, jne.';
$string['ldap_encoding_key'] = 'LDAP kodeering';
$string['memberattribute'] = 'LDAP\'i liikmete atribuut';
$string['objectclass'] = 'objectClass, mida kasutatakse kursuste otsimiseks. Tavaliselt \'posixGroup\'.';
$string['objectclass_key'] = 'Objekti klass';
$string['ok'] = 'OK!';
$string['phpldap_noextension'] = '<em>PHP LDAP-moodulit ei paista esinevat. Palun veendu, et see on installeeritud ja sisse lülitatud, kui soovid kasutada seda registreerumise pluginat.</em>';
$string['pluginname'] = 'LDAP registreerumised';
$string['pluginname_desc'] = '<p> Registreerumiste kontrollimiseks võid kasutada LDAP serverit.
Eeldatakse, et sinu LDAP puu sisaldab gruppe, mis vastavad kursustele ja igaühel neist gruppidest/kursustest on olemas liikmesisestused, mis vastavad õppijatele.</p>
<p>Eeldatakse, et LDAP\'is on kursused defineeritud kui grupid, kus igal grupil on liikmeväljad
(<em>member</em> või <em>memberUid</em>), mis sisaldavad unikaalset kasutaja identifikaatorit.</p>
<p>Et kasutada registreerumisel LDAP\'i, <strong>peavad</strong> kasutajad omama kehtivaid ID numbri välju. LDAP grupid peavad sisaldama ID numbrit kasutaja väljas selleks, et kasutaja saaks kursustele registreeruda.
Tavaliselt töötab süsteem hästi, kui sa juba kasutad LDAP\'iga autentimist.</p>
<p>Registreerumised uuendatakse, kui kasutaja siseneb õpikeskkonda. Registreerumiste sünkroniseerimiseks võid kasutada ka spetsiaalset skripti. Vaata  <em>enrol/ldap/enrol_ldap_sync.php</em>.</p> <p>Seda pistikut saab seadistada ka õpikeskkonda automaatselt uusi kursusi looma LDAP\'i lisatud uute gruppide järgi.</p>';
$string['pluginnotenabled'] = 'Plugin ei ole võimaldatud!';
$string['role_mapping_key'] = 'Seo rollid LDAP\'st';
$string['roles'] = 'Rolli sidumine';
$string['server_settings'] = 'LDAP serveri seaded';
$string['template'] = 'Valikuline: Automaatselt loodud kursused kopeerivad oma seaded mallkursuselt.';
$string['template_key'] = 'Mall';
$string['unassignrolefailed'] = 'Rolli \'{$a->role_shortname}\' eemaldamine kasutajalt \'{$a->user_username}\' kursusel \'{$a->course_shortname}\' (id {$a->course_id}) ebaõnnestus';
$string['updatelocal'] = 'Uuenda lokaalseid andmeid';
$string['user_attribute_key'] = 'ID-numbri atribuut';
$string['user_contexts_key'] = 'Kontekst';
$string['user_search_sub_key'] = 'Otsi alamkontekste';
$string['user_settings'] = 'Kasutaja otsimise seaded';
$string['user_type_key'] = 'Kasutaja tüüp';
$string['version'] = 'LDAP protokolli versioon, mida sinu server kasutab';
$string['version_key'] = 'Versioon';
