<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'zh_tw', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = '禁止進入';
$string['accounts'] = '帳戶';
$string['addcategory'] = '新增一類別';
$string['additionalhtml'] = '額外的HTML';
$string['additionalhtml_desc'] = '用此設定您可以指定一段HTML語法，它會被加入到每個頁面中。您可以把HTML語法加入到頁面的HEAD區段內，BODY標籤剛開始的地方，或BODY標籤結束之前。<br />使用這種方式，您可以在每個頁面內都加入自訂的頁首或頁尾，也可以方便地加入支援Google Analytics之類的服務，並且和您選擇的佈景主題完全無關。';
$string['additionalhtmlfooter'] = '在BODY結尾標籤前';
$string['additionalhtmlfooter_desc'] = '這些內容將被加入每個頁面，緊隨其後的是BODY的結尾標籤。';
$string['additionalhtmlhead'] = '在HEAD區段內';
$string['additionalhtmlhead_desc'] = '這些內容將加到每一頁面的HEAD區段末尾。';
$string['additionalhtml_heading'] = '在所有頁面加入額外的HTML。';
$string['additionalhtmltopofbody'] = '當BODY標籤開始時';
$string['additionalhtmltopofbody_desc'] = '這些內容將被加入到每個頁面，並緊接BODY開始的標籤後面。';
$string['admincategory'] = '類別：{$a}';
$string['adminseesall'] = '管理者可以看見全部';
$string['adminseesallevents'] = '管理者可以看見所有事件';
$string['adminseesownevents'] = '管理者和其它用戶一樣';
$string['advancedfeatures'] = '進階';
$string['allcountrycodes'] = '全部國碼';
$string['allowbeforeblock'] = '允許進入的清單將優先處理';
$string['allowbeforeblockdesc'] = '預設情況，禁止進入的IP清單會先被對應。如果啟用此選項，則允許進入的IP清單的處理會先於禁止進入清單。';
$string['allowblockstodock'] = '允許區塊使用靠泊區';
$string['allowcategorythemes'] = '允許課程分類佈景';
$string['allowcoursethemes'] = '允許自訂課程佈景';
$string['allowediplist'] = '允許進入的IP清單';
$string['allowemailaddresses'] = '允許的郵件網域名稱';
$string['allowframembedding'] = '允許嵌入頁框';
$string['allowframembedding_help'] = '允許本站被外面的網站以頁框方式嵌入。基於安全考量，不建議啟用此功能。';
$string['allowguestmymoodle'] = '允許訪客瀏覽我的首頁';
$string['allowobjectembed'] = '允許使用 EMBED 與 OBJECT 標籤';
$string['allowthemechangeonurl'] = '允許在URL中改變佈景';
$string['allowuserblockhiding'] = '允許用戶隱藏區塊';
$string['allowuserswitchrolestheycantassign'] = '允許沒有指派角色權限的用戶可以切換角色';
$string['allowuserthemes'] = '允許使用者自選佈景';
$string['antivirus'] = '防毒';
$string['appearance'] = '外觀';
$string['aspellpath'] = 'aspell的路徑';
$string['authentication'] = '身份認證';
$string['authpreventaccountcreation'] = '防止身份認證時建立帳號';
$string['authpreventaccountcreation_help'] = '當認證使用者在本站還沒有帳號時，會自動在本站建立帳號。如果使用外部資料庫（例如LDAP）做認證，但是您希望只允許在本站有帳號的使用者進入，那麼就啟用此選項。新帳號可以使用手工建立或者批次建立。注意，此設定不會影響MNet認證。';
$string['authsettings'] = '管理身份認證';
$string['autolang'] = '語言自動偵測';
$string['autologinguests'] = '自動登入為訪客';
$string['availablelicenses'] = '可選用的著作權授權方式';
$string['availableto'] = '可用到';
$string['backgroundcolour'] = '透明色';
$string['backups'] = '備份';
$string['backup_shortname'] = '在備份檔名中使用課程名稱';
$string['backup_shortnamehelp'] = '用課程名稱做為備份檔案名稱的一部分。';
$string['badwordsconfig'] = '輸入禁用詞語列表（用逗號,分隔）';
$string['badwordsdefault'] = '如果自訂清單是空的，將使用語言包所提供的預設清單。';
$string['badwordslist'] = '自訂禁用語清單';
$string['blockediplist'] = '封鎖的IP清單';
$string['blockeditingmenu'] = '區塊編輯選單';
$string['blockeditingmenu_desc'] = '若啟用，許多區塊編輯的小圖示將會顯示在一個下拉選單上。這設計會隱藏小圖示以減少螢幕上的內容，等到需要時才顯現。';
$string['blockinstances'] = '區塊';
$string['blockmultiple'] = '多個';
$string['blockprotect'] = '防止刪除';
$string['blockprotect_help'] = '被選擇的區塊不會在全站場合下被刪除。這主要用來保護導覽和設定區塊。如果它們被意外刪除，是很難找回來的。';
$string['blocksettings'] = '管理區塊';
$string['blockunprotect'] = '取消保護';
$string['bloglevel'] = '部落格可見性';
$string['bookmarkadded'] = '書籤已新增了';
$string['bookmarkalreadyexists'] = '您已經為此頁設定了書籤。';
$string['bookmarkdeleted'] = '書籤刪除了';
$string['bookmarkthispage'] = '將此頁加入書籤';
$string['cacheapplication'] = '應用程序快取';
$string['cacheapplicationhelp'] = '快取的項目在所有用戶中分享，並且訂定到期時間 TTL。';
$string['cachejs'] = '快取Javascript';
$string['cachejs_help'] = 'JavaScript的快取和壓縮能大大提高頁面的載入速度。我們強烈建議正式營運的網站使用它。開發者可能需要停用此功能。';
$string['cacherequest'] = '請求快取';
$string['cacherequesthelp'] = '當請求已經完成時，用戶指定的快取會過期。設計來取代我們用來做靜態儲存的區域。';
$string['cachesession'] = 'Session的快取';
$string['cachesessionhelp'] = '用戶特定的快取會在工作階段結束時候到期。設計 aleviate session bloat/strain.';
$string['cachesettings'] = '快取設定';
$string['cachetext'] = '文字快取生命期';
$string['caching'] = '快取';
$string['calendarexportsalt'] = '行事曆匯出的隨機種子';
$string['calendarsettings'] = '行事曆';
$string['calendartype'] = '日曆樣式。';
$string['calendartype_desc'] = '為整個網址選擇一個預設之日曆樣式。但是這個設定可能在使用者課程設定中，或是在使用者個人資料中會被覆蓋掉。';
$string['calendar_weekend'] = '週末';
$string['cannotdeletemodfilter'] = '您不能移除“{$a->filter}”，因為它是“{$a->module}”模組的一部分。';
$string['cannotuninstall'] = '{$a} 無法移除';
$string['cfgwwwrootslashwarning'] = '您的config.pho內的$CFG->wwwroot定義有誤。在字串尾端多了"/"字元，請您移除它。不然您會收到奇怪的錯誤訊息，如<a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>所報告的。';
$string['cfgwwwrootwarning'] = '您的config.pho內的$CFG->wwwroot定義有誤。和您現在存取的網址(URL)不同， 請更正它。不然您會收到奇怪的錯誤訊息，如<a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>所報告的。';
$string['change'] = '變更';
$string['checkboxno'] = '否';
$string['checkboxyes'] = '是';
$string['choosefiletoedit'] = '選擇要編輯的檔案';
$string['clamfailureonupload'] = 'Clam AV失敗時';
$string['cleanup'] = '清除';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = '錯誤，將“{$a->option}”的值設為“{$a->value}”是不正確的';
$string['cliincorrectvalueretry'] = '不正確值，請重試';
$string['clistatusdisabled'] = '狀態：取消';
$string['clistatusenabled'] = '狀態：啟用';
$string['clistatusenabledlater'] = '狀態: CLI 維護模式將會在 {$a} 啟用';
$string['clitypevalue'] = '輸入值';
$string['clitypevaluedefault'] = '輸入值，按回車使用預設值（{$a}）';
$string['cliunknowoption'] = '錯誤選項：{$a}請使用 --help 選項。';
$string['cliupgradefinished'] = '命令列升級成功地完成了。';
$string['cliupgradenoneed'] = '暫無針對{$a}版本的可用更新。無論如何，感謝您的蒞臨！';
$string['cliyesnoprompt'] = '輸入y（表示是）或n（表示否）';
$string['commentsperpage'] = '每頁可顯示的評論數';
$string['commonfiltersettings'] = '過濾器共同的設定';
$string['commonsettings'] = '共同的設定';
$string['componentinstalled'] = '元件已安裝';
$string['computedfromlogs'] = '從{$a}開始的日誌中計算得出';
$string['condifmodeditdefaults'] = '在此所設定的值將成為您建立新活動或資源時的預設值。您也可以指定哪些活動設定將被視為進階設定。';
$string['confeditorhidebuttons'] = '請選擇HTML編輯器中要隱藏的按鈕。';
$string['configallcountrycodes'] = '在很多地方都要使用這個國家/地區列表，例如用戶個人資料。如果留空（預設情況），那麼會使用標準英文語言包中的countries.php（它來自ISO 3166-1）。否則，您可以輸入用半形逗號分隔的代碼列表，例如“GB,FT,ES”。如果要加入新的非標準代碼，您必須先在en和您的語言包中加入它們。';
$string['configallowassign'] = '允許具備左側欄角色的人，可以指派直欄中的角色給其他人';
$string['configallowblockstodock'] = '如果啟用，且選用的佈景有支援，那麼用戶可以將區塊移動到一個特別的停靠欄中';
$string['configallowcategorythemes'] = '開啟這個選項，佈景可套用於類別層級。這將會影響所有子類別及類別中的課程。除非他們已被另外設定佈景。注意：開啟這個選項可能會影響系統效能。';
$string['configallowcoursethemes'] = '如果啟動，則每個課程可以設定自己的佈景。課程的佈景將覆蓋在其他位置(網站、用戶或活動)所設定的佈景。';
$string['configallowemailaddresses'] = '如果您希望限制新的電子郵件位址在一定的網域名稱中，可以將它們列出，允許的網域名稱以空格分隔。系統將會拒絕其他網域名稱的郵件信箱。例如<strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = '若啟用，訪客可以存取我的首頁，否則訪客會被重新導向這網站的首頁。';
$string['configallowobjectembed'] = '預設的安全考量，一般使用者是不能在網頁HTML中直接使用EMBED或OBJECT標籤來嵌入多媒體(如Falsh)的(雖然透過mediaplugins過濾器已經很安全)。如果您希望允許用戶可使用上述標籤，請開啟此選項。';
$string['configallowoverride'] = '允許具備左側欄角色的人，可以置換直欄中的某些角色';
$string['configallowoverride2'] = '在左側欄中選擇一個能被任何角色覆蓋取代的角色。<br />注意：這些設定僅適用於同時具有如下權限的用戶：moodle/role:override 或 moodle/role:safeoverride';
$string['configallowswitch'] = '基於用戶已經擁有的角色，選擇他可以變換到那些角色。除了在此表中設定外，還要賦予用戶moodle/role:switchroles權限。<br />注意，只能變換到有moodle/course:view權限，而沒有moodle/site:doanything權限的用戶。所以表中有些欄是禁止使用的。';
$string['configallowthemechangeonurl'] = '如果啟用，那麼可以用下面辦法改變佈景主題：<br />向任何 Moodle URL加入 ?theme=themename（例如：mymoodlesite.com/?theme=afterburner）或<br />向任何  Moodle 內部 URL加入 &theme=themename（例如：mymoodlesite.com/course/view.php?id=2&theme=afterburner）。';
$string['configallowuserblockhiding'] = '是否允許使用者隱藏或顯示網站中各頁面兩側的區塊？這個功能使用JavaScript和Cookie來記住每一個可摺疊區塊的狀態，它只會影響使用者自己的畫面。';
$string['configallowuserswitchrolestheycantassign'] = '預設情況下，指派角色(moodle/role:assign)需要用戶能變換角色。開啟這個設定會去掉這一限制，並僅用“允許角色指派”表格來確定“變換角色到”的下拉選單內容。<br />我們建議您，在“允許角色指派”表格中，不要允許用戶切換到權限比他們本身更高的角色。';
$string['configallowuserthemes'] = '如果您啟用，則使用者可以設定自己的佈景主題。使用者的佈景主題設定會覆蓋網站的佈景主題(但不會取代課程的)。';
$string['configallusersaresitestudents'] = '是否假定<strong>所有</strong>訪問網站首頁的用戶為學生。如果設定為是，則所有經過確認的用戶帳號都可以參加首頁上學生的活動。如果設定為否，則只有那些至少參加了一門課程學習的用戶才可以參加首頁上學生的活動。只有管理員和特別指定的教師才可以作為這些首頁活動的教師。';
$string['configauthenticationplugins'] = '請選擇要使用的認證外掛並且妥善安排，自動註冊功能將會透過註冊欄位選擇的外掛處理（通常是 email）。';
$string['configautolang'] = '如果關閉網站預設值，就會由瀏覽器的設定來偵測預設的語言。';
$string['configautologinguests'] = '當訪問者訪問時，是否自動以訪客(guest)身份登錄那些允許訪客(guest)進入的課程。';
$string['configbloglevel'] = '此設定讓你可以限制哪些層級的人可以檢視本網站用戶的部落格。要注意的是：設定的是<b>檢視者</b>的最大處境，而非發表者或部落格貼文類型。如果您不想要部落格，部落格也可以完全停用。';
$string['configcachetext'] = '對於較大的或者是開啟了文本過濾器的網站，這個設置可以提高速度。在一段時間之內，已經處理過的文本的副本將會被保留。如果將這個值設得太小會減慢相應速度，但設定得太大也會使文本刷新緩慢。';
$string['configcalendarcustomexport'] = '匯出行事曆時，可以自訂日期範圍';
$string['configcalendarexportsalt'] = '亂數文字用來改善行事曆匯出的認證安全性，請注意，如果您變更雜湊亂數(hash salt)，目前所有的tokens將成為無效的。';
$string['configclamactlikevirus'] = '檔案有病毒';
$string['configclamdonothing'] = '檔案沒問題';
$string['configclamfailureonupload'] = '如果您讓clam防毒軟體掃瞄上傳的檔案，但並未正確設定clam防毒軟體或它因某些未知原因而執行失敗了，那應該怎麼做？如果您選擇了「檔案有病毒」，那麼它們將會被轉移到隔離區或是被刪除。如果您選擇了「檔案沒問題」，那麼檔案將會如往常一樣被轉移到目標目錄中。無論選擇哪個，系統都會提醒管理員clam執行失敗了。如果您選擇「檔案有病毒」且由於某些原因clam執行失敗了(通常是因為您未能指定合法的pathtoclam值)，所有上傳的檔案將會被轉移到隔離區或者被刪除。使用這個設定要小心。';
$string['configconvertformat'] = '如果<i>latex</i>、<i>dvips</i> 和 <i>convert</i> 有效，將使用指定的格式建立影像。否則，將使用mimeTeX建立GIF影像。';
$string['configcookiehttponly'] = '使用新的PHP 5.2.0功能-瀏覽器只能用http要求來傳送cookie，不能用腳本語言傳送。不是所有的瀏覽器都支援此功能，此功能也可能與目前的程式碼不相容。此功能有助於防止部分XSS型式的攻擊。';
$string['configcookiesecure'] = '如果伺服器僅接受https連線，建議啟動安全cookies傳送。啟動時，請確認網站伺服器不能接受http://或設定重新導向至固定的https://位址。當 <em>wwwroot目錄</em>網址不是以https://開頭時，此設定自動關閉。';
$string['configcountry'] = '如果在此處設定一個國家或地區，則它將被用於使用者註冊時的預設值。如果要強制使用者自己選擇一個國家或地區，則保持此處為空白';
$string['configcourseoverviewfilesext'] = '顯示課程概覽時，允許使用的各種檔案類型(要以逗號分隔)。';
$string['configcourseoverviewfileslimit'] = '可以附加在課程摘要的檔案的最大數量。';
$string['configcourserequestnotify'] = '輸入當有新課程申請時，應通知的用戶名稱。';
$string['configcourserequestnotify2'] = '當有開課申請時，那些人會被通知？清單中僅列出有權核准申請的人。';
$string['configcoursesperpage'] = '輸入在課程列表上，每頁可顯示的課程數。';
$string['configcourseswithsummarieslimit'] = '在課程列表中，含有摘要時，可顯示的最大課程數，若超過將退回到較簡單的列表方式。';
$string['configcronclionly'] = '如果啟用，cron將只能在命令列中執行，不能經由web執行。此設定將置換下面的cron密碼設定。';
$string['configcronremotepassword'] = '這表示 cron.php 程式如果沒有提供密碼就不會執行，提供密碼的方式就像這樣：<pre> http://site.example.com/admin/cron.php?password=opensesame </pre>，保持空白表示不需要密碼。';
$string['configcurlcache'] = 'cURL快取有效時間，單位是秒。';
$string['configcustommenuitems'] = '您可以在此設定一個由主題顯示的自訂選單。每一行包含一些選單文字、一個網址連結(可選)、一個工具提示(可選)和語言代碼(可選，以指定語言顯示這行給用戶看)，用分節符號(|)隔開。您還可以使用連字符號來建構選單的結構。例如：
<pre>
Moodle社群|https://moodle.org
-Moodle免費支援|http://moodle.org/support
-Moodle開發|http://moodle.org/development
--Moodle跟蹤器|http://tracker.moodle.org
--Moodle檔案|http://docs.moodle.org
-Moodle新聞|http://moodle.org/news
Moodle公司
-Moodle商用虛擬主機http://moodle.com/hosting
-Moodle商用支援|http://moodle.com/support
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
</pre>';
$string['configdbsessions'] = '如果啟用，將會使用資料庫來儲存目前的session資訊。這對於那些大的/繁忙的網站或是在集群上建立的網站是很有用的。對於多數網站，此選項應當保持關閉，即使用伺服器硬碟儲存session資訊。注意改變這個設定將會強制退出所有目前線上的用戶（包括您）。如果你正在使用MySQL，請確認my.cnf (或my.ini)檔案內的\'max_allowed_packet\'至少要設為4M。
其他session硬碟可以直接在config.php 設定。參見config-dist.php 可取得更多訊息。若你在config.php 檔案上指定session 硬碟，這一選項會消失。';
$string['configdebug'] = '如果您打開這個選項，那麼PHP的錯誤報告會增加，頁面上會出現更多的警告信息。這只對開發人員有用。';
$string['configdebugdisplay'] = '如果啟用，錯誤報告會顯示在 HTML 頁面，這個功能雖然實用，但是可能會破壞 XHTML、JS、cookies 與 HTTP 頁首；如果關閉，表示會記錄在伺服器日誌檔案中，比較方便除錯。 PHP 的 error_log 設定控制那些日誌寫入到系統日誌中。';
$string['configdebugpageinfo'] = '如果您希望在頁尾顯示頁面資訊，就啟用此設定。';
$string['configdebugsmtp'] = '在寄送郵件到 SMTP 伺服器時啟用額外的偵錯資訊。';
$string['configdebugvalidators'] = '如果您希望頁面底端有到外部檢查器的鏈接，就啟用此項。您可能需要建立一個名為<em>w3cvalidator</em>的使用者，並賦予它訪客權限。這個改動可能會使某些人未經授權就能進入本站，所以不要在正式使用的網站上使用它。';
$string['configdefaulthomepage'] = '這裡決定已登入用戶的首頁';
$string['configdefaultrequestcategory'] = '用戶申請的課程將自動放入此類別中。';
$string['configdefaultrequestedcategory'] = '當課程申請核淮後，預設放到那個類別中。';
$string['configdefaultuserroleid'] = '所有登入的用戶會具有您在這裡指定的權限，加上他們本身已經擁有的。預設是一般用戶角色（舊版是訪客角色），這不會跟他們原有的角色產生衝突，只是確保所有用戶具有課程層級所沒有指派的權限（例如發表部落格、管理自己的行事曆等）。';
$string['configdeleteincompleteusers'] = '超過這個時限，設定不完整的舊帳號將被刪除。';
$string['configdeleteunconfirmed'] = '使用電子郵件認證註冊時，超過這個時限未認證的用戶將被刪除。';
$string['configdenyemailaddresses'] = '要拒絕某些網域名稱的電子郵件地址，請把他們列在這裡。系統會接受所有其它網域名稱的郵件。例如<strong>hotmail.com yahoo.co.uk</strong>';
$string['configdisableuserimages'] = '關閉用戶變更個人照片的能力。';
$string['configdisplayloginfailures'] = '向指定用戶顯示登入失敗的日誌。';
$string['configdndallowtextandlinks'] = '打開或關閉拖放文字、超連結或檔案到課程頁面功能。注意，拖放文字到 Firefox或在不同瀏覽器間拖放是不可靠的，可能導致上傳成空內容或混亂的文字。';
$string['configdocroot'] = '定義Moodle線上文件的路徑，以提供特定處境的文件。它會在每一頁的頁腳顯現\'本頁的Moodle線上文件\'連結。

如果您希望擁有您自己的的線上文件，您可以修改它。

然而，如果你做了變更，請確認您的文件中的路徑格式與 http://docs.moodle.org的相同。

若這欄位空白，將不會顯現連結。';
$string['configdoctonewwindow'] = '如果您啟動此項，Moodel文件的連結將顯示在新視窗中。';
$string['configeditordictionary'] = '如果 aspell 沒有用戶自己的字典時，這個值會將會使用。';
$string['configeditorfontlist'] = '選擇要出現在編輯器下拉選單中的字體。';
$string['configemailchangeconfirmation'] = '當用戶變更電子郵件信箱資料時，需要執行電子郵件確認的步驟。';
$string['configenableajax'] = '這個設定允許您控制網站的 AJAX (advanced client/server interfaces using Javascript) 使用，即使啟用這個項目用戶也可以在自己的設定中調整，不過停用就會套用到所有使用者。';
$string['configenableblogs'] = '此開關提供所有網站用戶擁有自己的部落格。';
$string['configenablecalendarexport'] = '啟用行事曆匯出或訂閱的功能。';
$string['configenablecomments'] = '啟用評論';
$string['configenablecourserequests'] = '啟用這個選項，允許任何人申請建立新課程。';
$string['configenabledevicedetection'] = '為佈景的選擇和其它功能啟用行動電話、智慧型手機、平板電腦和預設設備（桌上型、筆記型電腦等）檢測功能。';
$string['configenablegroupmembersonly'] = '如果啟用，將只有群組成員才能進入活動。這可能會加大伺服器的負荷。此外，成績單的分類必須經過特別的設定才能使活動對非群組成員隱藏。';
$string['configenablemobilewebservice'] = '為官方版的 Moodle APP或其他APP啟用行動服務(mobile service) 功能。更多資訊請參閱{$a}。';
$string['configenablerssfeeds'] = '這個選項啟用所有討論區的RSS摘要。您仍需啟用每一個討論區設定中的RSS摘要選項-請至系統管理下的模組設定。';
$string['configenablerssfeedsdisabled'] = '由於RSS摘要功能已經在網站後台關閉了，因此無法使用。要開啟它，請至網站管理選單的【進階】設定。';
$string['configenablerssfeedsdisabled2'] = 'RSS摘要功能已經在伺服器階層關閉了。您須在網站管理選單的【進階】設定中先啟動它們。';
$string['configenablesafebrowserintegration'] = '在測驗卷設定的表單中，新增“需要Safe Exam瀏覽器”到“瀏覽器安全性”的欄位。詳參 http://www.safeexambrowser.org/ 網站。';
$string['configenablestats'] = '如果您在此選擇“是”，Moodle將處理記錄及收集統計資料。根據您網路的流通量而定，可能會需要一些時間。如果您啟動此選項，您將可以看到關於您的每個課程或整個網站的有趣統計圖和統計資料。';
$string['configenabletrusttext'] = 'Moodle預設會過濾來自使用者的文字來移除可能存在安全風險的惡意程式碼、媒體檔案，可信任內容系統讓指定的使用者能夠在沒有干擾的情況下在內容中使用那些進階功能；您需要先啟用這個設定，接著將信任內容的權限授予給指定的 Moodle 角色，接著來自該角色使用者建立或上傳的內容將會標示為可信任的，在顯示前不會進行過濾。';
$string['configenablewebservices'] = '其它系統可以使用網絡服務登入到此 Moodle 並做各種操作。基於安全考量，您應該禁用這個功能，除非您真的要使用它。';
$string['configenablewsdocumentation'] = '啟用網絡服務文件自動生成。用戶可以在他的安全密鑰頁{$a}存取自己的文件。只會顯示已啟用的通訊協定檔案。';
$string['configerrorlevel'] = '選擇顯示的PHP警告數目。“正常”通常是最佳選擇。';
$string['configexportlookahead'] = '在匯出時，要包含未來幾天';
$string['configexportlookback'] = '在匯出時，要包含過去幾天';
$string['configextendedusernamechars'] = '啟用這個選項將允許學生在帳號名稱中使用任何字元(這並不會影響它們實際的名字)。預設值是“否”，限制帳號名稱只能使用小寫字母、數字、底線( _ )、橫線( - )、小數點( . )或( @ )。';
$string['configextramemorylimit'] = '某些程式（例如搜尋、備份/還原或排程）需要更多的記憶體。大的網站，請設定一個較高的值。';
$string['configfilterall'] = '過濾全部字元串，包括標頭、標題、導覽列等等。當使用多語言過濾時，這是非常有用的，否則它只會給您的系統帶來額外的負擔。';
$string['configfiltermatchoneperpage'] = '自動連結過濾器將只在整個網頁中的第一個相符的文字產生連結，其他的將被忽略。';
$string['configfiltermatchonepertext'] = '自動連結過濾器將在網頁中的每一項目中(如資源、區塊)的第一個相符的文字產生連結，其他的將被忽略。如果每頁一個的設定為<i>是</i>時，此設定會被忽略。';
$string['configfilteruploadedfiles'] = '使用該設置會讓Moodle在顯示上傳的HTML和文字前用過濾器處理他們。';
$string['configforcelogin'] = '正常來說，網站和課程列表的首頁(不包含課程)，並不需要使用者登入。如果您要強制使用者登入才能瀏覽，請啟用此功能。';
$string['configforceloginforprofiles'] = '啟用這個選項會強制訪問者在檢視用戶資訊頁面時必須以真實(非訪客)身份登入。如果您停用了該選項，那麼可能會有用戶在個人資料中發布廣告（垃圾資訊）或其他不雅的內容，這些全世界都可以看到。';
$string['configfrontpage'] = '上面選擇的項目會顯示在網站的首頁';
$string['configfrontpagecourselimit'] = '課程數量上限';
$string['configfrontpagecourselimithelp'] = '課程列表的站台首頁可顯示的課程數量上限';
$string['configfrontpageloggedin'] = '上面選擇的項目會在使用者登入時顯示於網站首頁。';
$string['configfullnamedisplay'] = '這定義了如何顯示名字。對於多數單一語言網站，最有效的設定是預設的「名 + 姓」，但也可以選擇隱藏姓或者讓當前的語言包來決定(某些語言有不同的名字顯示習俗)。';
$string['configgeoipfile'] = 'GeoIP City 二進位資料檔的位置。此檔不是Moodle發行，必須另外從<a href="http://www.maxmind.com/">MaxMind</a>取得。您可以購買商業版本或使用免費版本。<br />只要下載 <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a>然後解壓縮放至您的伺服器中的 "{$a}"目錄。';
$string['configgetremoteaddrconf'] = '如果您的伺服器在一個反向代理伺服器後，您可以設定此項以確定那一個 HTTP 標頭資訊包含了訪問者的 IP 地址。標頭資訊按順序讀入，第一條出現的將被使用。';
$string['configgradebookroles'] = '這個設定讓您可以控制顯示在成績單的人，要顯示在課程成績單的人需要在課程中擁有至少一個指定的角色。';
$string['configgradeexport'] = '選擇何種成績單匯出格式做為主要格式。被選用的外掛將設定和使用每個成績的“最後匯出”欄位。例如，已匯出的記錄可以被標記為“新的”或者“已更新的”。如果您不能確定該如何設定，就什麼都別選。';
$string['confighiddenuserfields'] = '選擇那些用戶資訊欄位要隱藏，除了課程的教師們/管理者可看見外。這可以加強對學生隱私的保護。要選擇多個欄位 時請按住CTRL鍵。';
$string['configidnumber'] = '這選項指定用戶是否(a)完全不要求ID編號，(b)會要求ID編號，但可留空白，(c)必須要ID編號，不能留空。如果輸入了用戶ID編號，它將顯示在用戶個人資料中。';
$string['configintro'] = '在此頁面中，您可以設定許多環境變數，它們可讓Moodle在您的伺服主機上運作的更好。不必太擔心—預設的設定值已經能讓系統很好地運作，而且您以後也可以再回到這裡改變這些設定值。';
$string['configintroadmin'] = '在這個頁面中，您可以設定您的主要管理員帳號，它可以完全控制網站。請確認您為它設定了一個安全的帳號和密碼以及一個合法的電子郵件信箱。您以後可以建立更多的管理員帳號。';
$string['configintrosite'] = '在此頁設定首頁和這個網站的名稱。您隨時可以使用首頁上的“首頁設定 ”連結返回到此頁，修改這些設定 。';
$string['configiplookup'] = '當您在記錄中點選了一個 IP 位址（例如 34.12.222.93），系統會顯示此 IP 的可能位置的地圖；有許多這樣功能的外掛可以選擇，它們各有優缺點。';
$string['configkeeptagnamecase'] = '如果您希望用戶輸入的標籤名稱保持原有的大小寫，請勾選此選項';
$string['configlang'] = '為整個網站選擇一種預設的語言。用戶可以利用語言選單或在他們的個人資料頁上的設定，來更換這個設定。';
$string['configlanglist'] = '此處留空將允許使用者從您所有已安裝的語言種類中任選一種。當然如果您要縮短語言選單，那麼可以在此填入語言代碼，以逗號(,)隔開。例如：zh_tw,ja,en,es_es,fr,it。';
$string['configlangmenu'] = '選擇要不要在主頁、登入頁顯示共用的語言選單。這並不影響用戶在他們的個人資料表中選擇自己偏愛的語言。';
$string['configlangstringcache'] = '將所有語言編譯後的字元串快取在資料目錄中。如果您正在翻譯Moodle，或在Moodle原始碼中編輯了字串，那麼您應該關閉此選項。否則，請打開它，來提升性能。';
$string['configlatinexcelexport'] = '選擇 Excel 匯出資料的編碼';
$string['configlocale'] = '選擇網站的地區設定——它會影響所有語言包對顯示日期的格式和語言。您的作業系統上必須安裝這種區域設定(例如 Linux裡的zh_TW.UTF-8或en_US.UTF-8)。大多數情況下，您可以把它留空。';
$string['configloginhttps'] = '啟用此選項會使 Moodle 在登入頁使用比較安全的https方法連接傳送資料(提供安全的登入)，然後在稍後改用正常的http連接以恢復到一般速度。<b>注意 </b>：此設定需要在web伺服器啟動https功能才可以使用，否則您自己可能會被鎖在站台之外，無法登入。';
$string['configloglifetime'] = '在此指定保存用戶活動日誌的時間長短。超出此時間段的日誌將被自動刪除。最好是將日誌保留盡量長的時間，萬一需要他們呢？但如果您的伺服器 非常繁忙且有性能方面的問題，您也許會希望減少保留日誌 的時間。不建議將天數設為小於30的值，因為這樣可能會讓統計功能出錯。';
$string['configlookahead'] = '向前查看天數';
$string['configmaxbytes'] = '限制整個網站內上傳檔案的最大容量。這個設定會受到PHP設定中post_max_size和upload_max_filesize，以及Apache設定中LimitRequestBody的影響。這個設定也會影響課程和模組中選擇檔案容量的範圍。如果選擇「伺服器限制」，將使用伺服器允許的最大值。';
$string['configmaxconsecutiveidentchars'] = '密碼中連續相同字元的個數不能超過此值。使用0會禁用這項檢查。';
$string['configmaxeditingtime'] = '此參數指定使用者在多長時間內可以重新修改討論區的張貼內容。通常30分鐘比較合適。';
$string['configmaxevents'] = '向前查找的事件數';
$string['configmaxusersperpage'] = '在課程、群組、校定班級群組、網路服務等的用戶選擇器上可顯示的最大用戶數';
$string['configmessaging'] = '是否啟用在網站用戶之間發送訊息的功能?';
$string['configmessagingallowemailoverride'] = '允許用戶將電子郵件通知發送到個人資料中的電子郵件地址之外的地址。';
$string['configmessagingdeletereadnotificationsdelay'] = '可以刪除已閱讀的通知，以節約空間。通知被閱讀多久後可以被刪除？';
$string['configmessaginghidereadnotifications'] = '當檢視訊息歷史時，隱藏討論區張貼之類事件的閱讀通知。';
$string['configminpassworddigits'] = '密碼中至少要包含多少個數字。';
$string['configminpasswordlength'] = '密碼中至少要包含多少個字元。';
$string['configminpasswordlower'] = '密碼中至少要包含多少小寫字母。';
$string['configminpasswordnonalphanum'] = '密碼中至少包含多少個非字母和數字的字元。';
$string['configminpasswordupper'] = '密碼至少要包含多少個大寫字母。';
$string['configmobilecssurl'] = '一個CSS檔案用來自訂您的行動裝置應用程式介面。';
$string['configmodchooserdefault'] = '是否在預設情況下將該活動選擇器顯示給用戶？';
$string['configmycoursesperpage'] = '在用戶自己的課程列表中，最多顯示幾門課程';
$string['configmymoodleredirect'] = '如果開啟，則當非管理員使用者登入時，直接跳轉到/my，並用/my替換掉網站首頁。';
$string['configmypagelocked'] = '此設定阻止任何非管理員用戶對預設頁面的編輯企圖';
$string['confignavcourselimit'] = '限制顯示給未登入或從未選課用戶的課程數。';
$string['confignavshowallcourses'] = '如果啟用，用戶在“我的課程”和“課程”中都可以看到他已選的課程。如果停用，有選課的用戶在導覽中將只能看到“我的課程”。如果用戶未登入或未加入任何課程，顯示的課程數仍然不會超過“課程限制（navcourselimit）”。';
$string['confignavshowcategories'] = '在導覽列和導覽版塊中顯示課程分類。學生已經選課的課程不受此設定影響，它們仍會被直接列在「我的課程」之下，與分類無關。';
$string['confignotifyloginfailures'] = '如果登入失敗的資料被記錄，可以透過E-mail將它們發送出去。誰應該收到這些通知呢？';
$string['confignotifyloginthreshold'] = '如果發送登入失敗的通知，對於一個使用者或是IP位址而言，多少次登入失敗之後發送通知呢？';
$string['confignotloggedinroleid'] = '沒有登入這個網站的用戶將會以這個角色在網站處境中活動。

通常\'訪客\'是最合適，不過您也許想要建立有更多或更少限制的角色。

至於像是發表文章等功能還是會要求用戶確實登入。';
$string['configopentogoogle'] = '如果使用該設定，Google將能夠以訪客的身份進入網站。通過Google搜索而來的訪問者也可以以訪客的身份登入網站。這個選項僅對允許訪客訪問的課程有效。';
$string['configoverride'] = '在config.php定義';
$string['configpasswordpolicy'] = '開啟此項，Moodle將檢查用戶密碼是否符合密碼使用規則。使用下方設定來指定您的密碼政策（如果您取消勾選，設定為“否”，那麼將忽略以下的密碼使用規則。）';
$string['configpasswordresettime'] = '在多少時間之內，用戶需要確認重設密碼的請求，否則就會過期失效。通常設為30分鐘。';
$string['configpathtoclam'] = 'Clam AV的路徑。通常是/usr/bin/clamscan或/usr/bin/clamdscan。設定了這個選項，Clam AV才能運行。';
$string['configpathtodu'] = '導向du。通常是 /usr/bin/du。如果您做此輸入, 對於含有大量檔案的目錄，此輸入可以加速顯示目錄內容網頁的速度.';
$string['configperfdebug'] = '如果您啟用這個功能，在標準佈景的頁尾處將出現效能的資訊。';
$string['configprofileroles'] = '在用戶個人資料和課程成員頁面可以看到的角色列表。';
$string['configprofilesforenrolledusersonly'] = '為了防止個人資訊被盜用，未加入任何課程的用戶簡介資料將是隱藏的。新用戶只有加入至少一門課程後，才可以增加個人簡介資料。';
$string['configprotectusernames'] = '預設forget_password.php 不會顯示任何提示。因它可能引起使用者名稱或電子郵件地址的猜測。';
$string['configproxybypass'] = '半形逗號分隔的主機或IP列表。進入它們時不使用代理（例如，192.168.,.mydomain.com）';
$string['configproxyhost'] = '如果此伺服主機是通過代理(防火牆)上網，那麼請填入代理的主機名和端口，否則留空。';
$string['configproxypassword'] = '若需要透過代理伺服器存取網際網路(PHP及cURL擴充套件需要)，請在這裡設定密碼，否則空白。';
$string['configproxyport'] = '如果這個主機需要使用代理伺服器，請在這裡指定代理主機的連接埠。';
$string['configproxytype'] = '網站代理伺服器型態(PHP5及 cURL 擴充套件支援SOCKS5時需要)';
$string['configproxyuser'] = '若需要透過代理伺服器存取網際網路(PHP及cURL擴充套件需要)，請在這裡設定使用者名稱，否則空白。';
$string['configquarantinedir'] = '如果您希望Clam AV把受感染的文件轉移到一個隔離目錄中，那麼請在此處指定它。這個目錄對於Web伺服主機必須是可寫的。如果您在此處留空或者填寫了一個不存在或無法訪問的目錄，受感染的文件將會被刪除。注意末尾不需要斜線。';
$string['configrecaptchaprivatekey'] = '您的Moodle伺服器和recaptcha伺服器溝通所使用的字串。可以由 http://www.google.com/recaptcha 網站取得。';
$string['configrecaptchapublickey'] = '用來顯示reCAPTCHA元件在登入的表單中的字串。由http://www.google.com/recaptcha 產生。';
$string['configrequestcategoryselection'] = '當申請開設課程時，允許選擇課程類別。';
$string['configrequestedstudentname'] = '在已申請課程中學生的稱謂';
$string['configrequestedstudentsname'] = '在已申請課程中學生的稱謂';
$string['configrequestedteachername'] = '在已申請課程中教師的稱謂';
$string['configrequestedteachersname'] = '在已申請課程中教師的稱謂';
$string['configrequiremodintro'] = '如果您不想強制要求用戶輸入每個活動的描述，就不要勾選此項。';
$string['configrunclamavonupload'] = '啟用時，clam AV會掃描所有上傳的檔案。';
$string['configrunclamonupload'] = '在上傳文件時運行Clam AV？您需要在pathtoclam中填寫了正確的路徑，此選項才能生效。(Clam AV是一個病毒掃瞄程序，它是自由軟體，可從 http://www.clamav.net/ 獲得。';
$string['configsectioninterface'] = '介面';
$string['configsectionmail'] = '郵件';
$string['configsectionmaintenance'] = '維護';
$string['configsectionmisc'] = '雜項';
$string['configsectionoperatingsystem'] = '作業系統';
$string['configsectionpermissions'] = '權限';
$string['configsectionrequestedcourse'] = '開課申請';
$string['configsectionsecurity'] = '安全';
$string['configsectionstats'] = '統計';
$string['configsectionuser'] = '用戶';
$string['configsecureforms'] = '當讀取表單的資料時，Moodle可以提供更多的安全等級。如果此選項被激活，系統將檢查瀏覽器的HTTP_REFERER變量是否與目前的表單相符。在一些極個別的情況下，這會帶來一些麻煩，譬如使用者使用防火牆(如Zonealarm)並設定了從Web資訊中刪除HTTP_REFERER的時候。其症狀是遇到表單就再也無法前進了。如果使用者在登入頁面上發生錯誤，或許您應當選在關閉這個選項，儘管這樣做會使您的網站進一步暴露在暴力密碼攻擊之下。如果不知道選什麼，那就讓它保留「是」吧。';
$string['configsessioncookie'] = '此選項用來設定Moodle連線所使用的cookie的名稱。這個選項是可選的，僅僅在一種情況下比較有用：一個網站上運行了多個Moodle的拷貝，要避免cookie發生混亂。';
$string['configsessioncookiedomain'] = '使用此選項可以設定 Moodle cookie 有效的網址。此選項對於定制 Moodle（如認證或選課外掛）非常有用，可以讓 Moodle 和另一子網址上的應用共享session資訊。<strong>警告：強烈建議您不要修改此選項——錯誤的設定將會導致包括管理員在內的所有人都無法登入。</strong>';
$string['configsessioncookiepath'] = '如果您需要修改瀏覽器送出Moodle cookes的地方，您可以修改這個選項將其指定為您網站的某個目錄。否則預設情況下會使用“/”。';
$string['configsessiontimeout'] = '如果使用者登入一段時間沒有動作(讀取網頁)，就會被自動登出(session被終止)，此變數可以設定此時間值。';
$string['configshowcommentscount'] = '顯示評論數量。它會在現實評論連結時增加一次資料庫查詢';
$string['configshowicalsource'] = '為 ical 事件顯示來源訊息';
$string['configshowsiteparticipantslist'] = '網站中所有的學生和教師將會被列在網站參與者列表中。誰可以查看這個列表呢?';
$string['configsitedefaultlicense'] = '預設的網站著作權授權方式';
$string['configsitedefaultlicensehelp'] = '在本站發布內容時，預設的著作權授權方式';
$string['configsitemaxcategorydepth'] = '最大類別層數';
$string['configsitemaxcategorydepthhelp'] = '這是指定在顯示類別或巨大清單時，最多可顯示幾層的子類別。

比較深層的類別將會以連結的形式出現，且用戶可以透過AJAX請求展開它們。';
$string['configslasharguments'] = '通過使用「斜線參數」(即這裡的第二選項)腳本來提供對文件(圖像、上傳的資料等)的訪問。該方法能讓文件更容易地緩存於網頁瀏覽器和代理伺服主機等。但有些PHP伺服主機不支持這種方法，所以如果您查看上傳的文件或圖像有點麻煩，請選擇第一個選項。';
$string['configsmartpix'] = '啟用這個項目時，圖示會由一個PHP程式提供，先是搜尋目前佈景、接著所有上層佈景、接著是Moodle /pix 資料夾，這樣一來會減少佈景中重複的圖片檔案，但是會犧牲一點效能。';
$string['configstartwday'] = '每週的開始';
$string['configstatsfirstrun'] = '在此指定<b>第一次</b>產生統計資料時，自動排程程式應處理多長期間的記錄檔。如果您的流量很大而且是在共用主機上，不建議您將時間設定的太長，那將會需要很長時間來執行而且耗費相當多的資源。（注意，在這個設定中， 1 個月 = 28 天，而圖表與報表中， 1 個月 = 該月實際天數）';
$string['configstatsmaxruntime'] = '處理統計資料可能造成沈重的負擔，所以透過此欄位與下一個欄位來設定何時執行以及執行多長時間。';
$string['configstatsmaxruntime2'] = '統計處理可能造成伺服器沈重的負擔，指定搜集一天統計資料所允許的最長時間。

在一次cron執行可處理的最大天數是31日。';
$string['configstatsmaxruntime3'] = '計算一天的統計資訊所能使用的最長時間。注意統計資訊的計算將會給伺服器帶來很高的負載，在一次 cron 執行中可計算最多幾天的統計資訊在下面設定。';
$string['configstatsruntimedays'] = '每次執行統計時，最多處理多少天的資料。一旦統計已經跟上日期，它只會處理一天的資料。

請根據伺服器的負載來調整這個值，如果需要較短的 cron 執行時間，可以減少它。';
$string['configstatsruntimestart'] = '自動排程程式cron要何時 <b>開始</b> 統計資料的處理？

如果一個伺服器上有多個Moodle網站，建議指定不同的時間。';
$string['configstatsuserthreshold'] = '如果您輸入 0 以外的數字，參與課程人數（學生＋教師）少於這個數量會直接被忽略。';
$string['configstrictformsrequired'] = '若啟用，會在表單上的必要欄位上防止用戶輸入一個空格或換行符號。';
$string['configstripalltitletags'] = '取消本設定，容許在活動和資源名稱中使用HTML標籤。';
$string['configsupportemail'] = '當此網站的使用者需要一般性的協助時(例如，當新使用者建立他們的帳號時)，此電子郵件位址將提供給他們。如果此郵件位址是空白的，則不提供。';
$string['configsupportname'] = '這是一個透過電子郵件或網址來提供一般性協助的人或其他團體的名字。';
$string['configsupportpage'] = '當此網站的使用者需要一般性的協助時(例如，當新使用者建立他們的帳號時)，此網址將提供給他們。如果此網址是空白的，則不提供。';
$string['configthemedesignermode'] = '正常情況下，所有的主題圖像和樣式表緩存在瀏覽器和服務器上很長一段時間，性能。如果你正在設計的主題或開發的代碼，那麼你可能要打開此模式，讓你不提供緩存的版本。警告：這將讓你的網站速度較慢的所有用戶！或者，您也可以從主題選擇頁面手動復位的主題緩存。';
$string['configthemelist'] = '此項留空白則用戶可以使用所有的合法主題風格。如果您希望讓可選的主題風格列表短一些，您可以在此指定一些。譬如: standard,orangewhite。';
$string['configtimezone'] = '您可以在此設定預設時區。這只是用於顯示日期的預設時區——每個用戶都可以設定他自己的時區。此處的「伺服主機時間」讓Moodle預設情況下直接使用伺服主機上作業系統的設定，而使用者個人設定中的「伺服主機時間」則表示預設情況下使用此處的設定。';
$string['configuseblogassociations'] = '用戶可以將部落格與課程或課程模組相關聯嗎？';
$string['configuseexternalyui'] = '使用Yahoo伺服器上的線上檔案，而不是本地檔案。警告：必須要能進入網際網路，否則您網站上的AJAX會失效。此設定與使用https的網站不相容。';
$string['configuserquota'] = '用戶可儲存使用的個人專用檔案區的容量配額。 {$a->bytes} 位元組 == {$a->displaysize}';
$string['configusesitenameforsitepages'] = '如果啟用，會用網站簡稱代替導覽中的“網站頁面”字元串';
$string['configusetags'] = '啟用跨全網站的標籤功能嗎?';
$string['configvariables'] = '變數';
$string['configverifychangedemail'] = '在修改電子郵件地址時，也對網域名稱進行限制。如果關閉此選項，則只有在建立用戶時，限制電子郵件地址的網域名稱。';
$string['configvisiblecourses'] = '正常顯示隱藏的類別中的課程';
$string['configwarning'] = '小心修改這些選項——不合法的值可能導致錯誤。';
$string['configyuicomboloading'] = '此選項可以用合併檔案的方式優化YUI函數的載入。為提升性能，正式服務的網站應該開啟這個選項。';
$string['confirmation'] = '確認';
$string['confirmdeletecomments'] = '您即將刪除評論，您確定嗎？';
$string['confirmed'] = '已確認';
$string['convertformat'] = '<i>convert</i> 輸出格式';
$string['cookiehttponly'] = '僅用http cookies';
$string['cookiesecure'] = '僅用安全的cookies';
$string['country'] = '預設的國家';
$string['coursecontact'] = '課程聯絡人';
$string['coursecontact_desc'] = '此設定允許您控制誰會出現在課程描述中。用戶必須至少是這些角色中之一，才能被顯示在該課程的課程描述中。';
$string['courselistshortnames'] = '顯示延伸的課程名稱';
$string['courselistshortnames_desc'] = '若啟用，在課程列表中會同時顯現課程全稱和簡稱。若需要，你可以使用自訂語言功能，藉由編輯  \'courseextendednamedisplay\' 語言字元串來自訂擴展的課程名稱。';
$string['coursemgmt'] = '管理課程和類別';
$string['courseoverview'] = '課程概況';
$string['courserequestnotify'] = '開課申請的通知';
$string['courserequestnotifyemail'] = '用戶 {$a->user} 申請開設一個新的課程於{$a->link}';
$string['courserequests'] = '開課申請';
$string['courserequestspending'] = '審核開課申請';
$string['courses'] = '課程';
$string['coursesperpage'] = '每頁可顯示課程數';
$string['courseswithsummarieslimit'] = '有摘要限制的課程';
$string['creatornewroleid'] = '在新課程中課程建立者的角色';
$string['creatornewroleid_help'] = '如果這用戶還沒有管理這新課程的權限，那麼該用戶就自動使用此角色選課。';
$string['cron'] = '排程工作';
$string['cronclionly'] = '只能從指令模式執行 Cron';
$string['cronerrorclionly'] = 'Sorry，網路存取這頁的權限已經被管理員停用！';
$string['cronerrorpassword'] = '抱歉，要進入這頁，您必須輸入一個密碼！';
$string['cron_help'] = 'cron.php維護程式幫助某些Moodle模組執行定時或週期任務，例如用email發出討論區新的貼文、定時的備份。此程式必須被定時執行，例如每5分鐘執行一次。';
$string['cronremotepassword'] = '遠端執行Cron的密碼';
$string['cronwarning'] = '這個<a href="cron.php">cron.php</a>維護程式，至少有24個小時沒有執行了。';
$string['ctyperecommended'] = '強烈建議您安裝ctype 的PHP 延伸套件，特別是，您的網站要支援非拉丁語系語言的話，可以改善網站效能。';
$string['ctyperequired'] = '為了改善網站效能與提供多種語言的相容性，現在 Moodle 需要安裝 ctype 的PHP 延伸套件。';
$string['curlcache'] = 'cURL快取TTL';
$string['curlrecommended'] = '建議安裝額外的 Curl 函式庫來啟用 Moodle 網路功能。';
$string['curlrequired'] = 'Moodle現在需要PHP的cURL延伸套件，為了能與Moodle的倉儲服務連線通訊。';
$string['curltimeoutkbitrate'] = '計算cURL逾時使用的傳輸速率（Kbps）';
$string['curltimeoutkbitrate_help'] = '此設定用來計算處理大cURL請求時的逾時時間。此計算的一部分會使用HTTP的HEAD請求獲得檔案大小。設為0則不會發出這個請求。';
$string['currenttheme'] = '目前佈景主題';
$string['customcheck'] = '其他檢查';
$string['custommenu'] = '自訂選單';
$string['custommenuitems'] = '自訂選單項目';
$string['datarootsecurityerror'] = '<p><strong>安全警告！</strong></p><p>您的資料目錄在錯誤的位置，它將會曝露在網際網路中，這意謂著您的所有私人檔案，全世界任何人都可讀取到，駭客可能因此獲得未授權的管理權限，並任意存取您的網站！</p><br /><p>您<em>必須</em>搬移資料目錄({$a})到一個新的位置，而不是在您公開的WEB網頁目錄中，並且更改 config.php檔案中的<code>$CFG->dataroot</code>設定值</p>';
$string['datarootsecuritywarning'] = '您的網站設定可能不安全，請確認您的資料根目錄({$a})無法直接透過網路存取。';
$string['dbmigrate'] = 'Moodle 資料庫轉移';
$string['dbmigrateconnecerror'] = '無法連接到指定的資料庫';
$string['dbmigrateencodingerror'] = '指定資料庫的編碼為 {$a}，而非指定的 UNICODE/UTF8。<br />請重新指定。';
$string['dbmigratepostgres'] = '您似乎是使用 PostgreSQL 資料庫。為了繼續轉移工作，您須手動建立一個以 "UNICODE"(PostgreSQL 7) 或 "UTF8" (PostgreSQL 8)編碼的資料庫來儲存轉移的資料。請在下面輸入您的新資料庫連線設定：';
$string['dbmigratewarning'] = '在開始這個動作前請確認您已經備份了 moodle 的資料庫，如果您不確定如何進行，請聯繫您的系統管理員。在開始轉換時，您的 Moodle 網站狀態會變更為維護模式。';
$string['dbmigratewarning2'] = '<b>注意：您即將進行資料庫轉移程序，請再次確認您已經完整備份 Moodle 資料庫了。</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">資料庫已經轉移至新的 UTF8 資料庫，請編輯您的 config.php 並使用新的資料庫。</font>';
$string['dbmigrationdupfailed'] = '資料庫複製時發生錯誤：<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = '使用資料庫儲存連線資訊';
$string['debug'] = '除錯訊息';
$string['debugall'] = '全部：顯示所有合理的 PHP 偵錯訊息';
$string['debugdeveloper'] = '開發者：為開發者保留的額外 Moodle除錯訊息';
$string['debugdisplay'] = '顯示除錯訊息';
$string['debugging'] = '除錯';
$string['debugminimal'] = '最小： 只顯示嚴重錯誤';
$string['debugnone'] = '無：不要顯示任何錯誤或警告';
$string['debugnormal'] = '一般：顯示錯誤、警告與提示';
$string['debugpageinfo'] = '顯示頁面資訊';
$string['debugsmtp'] = '郵件寄送過程偵錯';
$string['debugstringids'] = '顯示語言字元串來源';
$string['debugstringids_desc'] = '此選項對翻譯人員很有幫助。啟用後，如果在URL中加上參數strings=1，那麼每個輸出的字元串旁都會顯示語言檔案和字元串id。';
$string['debugvalidators'] = '顯示檢驗的連結';
$string['defaultcity'] = '預設城市';
$string['defaultcity_help'] = '在此輸入的城市將成為新建用戶的預設城市。';
$string['defaultformatnotset'] = '決定預設課程格式有錯誤，請檢查網站的設定。';
$string['defaulthomepage'] = '預設用戶的首頁';
$string['defaultrequestcategory'] = '申請課程的預設類別';
$string['defaultsettinginfo'] = '預設值：{$a}';
$string['defaultuserroleid'] = '所有使用者的預設角色';
$string['deleteincompleteusers'] = '在幾天之後刪除資料不完整的用戶';
$string['deleteunconfirmed'] = '在幾天之後刪除未確認的用戶';
$string['deleteuser'] = '刪除用戶';
$string['density'] = '密度';
$string['denyemailaddresses'] = '禁止的郵件網域名稱';
$string['development'] = '開發';
$string['devicedetectregex'] = '設備檢測的正規表示式';
$string['devicedetectregex_desc'] = '<p>預設情況，Moodle可以檢測的設備類型包括：預設（桌上型或筆記型電腦），行動（電話和小型手持裝置），平板（iPad、Android平板電腦）和傳統（Internet Explorer 6用戶）。佈景選擇器可以給它們分配不同的佈景主題。經由此設定，可以用正規表示式檢測其它類型的設備（這些設備的優先於預設類型）。</p><p>例如，您可以輸入正規表示式“/(MIDP-1.0|Maemo|Windows CE)/”和返回值“featurephone”來檢測 一些常見的特殊電話。佈景選擇器裡就會增加一個“featurephone”類型，您就可以設定給這些設備使用的佈景主題。其它電話仍會使用為行動設備選擇的佈景。</p>';
$string['devicedetectregexexpression'] = '正規表示式';
$string['devicedetectregexvalue'] = '返回值';
$string['devicetype'] = '設備類型';
$string['disableuserimages'] = '停用用戶個人照片';
$string['displayerrorswarning'] = '正式的伺服網站建議不要啟用 PHP 參數 <em>display_errors</em> 設定，因為有些錯誤訊息可能會暴露伺服器敏感危及安全的資訊。';
$string['displayloginfailures'] = '顯示登入失敗記錄給';
$string['dndallowtextandlinks'] = '拖放上傳文字/連結';
$string['docroot'] = 'Moodle Docs 文件根目錄';
$string['doctonewwindow'] = '開啟在新視窗';
$string['download'] = '下載';
$string['edithelpdocs'] = '編修輔助文件';
$string['editingnoncorelangfile'] = '您正嘗試調整一個外加模組/外掛程式的翻譯。您可以儲存第三方模組翻譯在您的本地資料夾。您可能想要移動已翻譯的檔案到模組語言目錄，並或者將它們送給第三方模組的維護者。';
$string['editlang'] = '<b>編輯</b>';
$string['editorbackgroundcolor'] = '背景顏色';
$string['editordictionary'] = '編輯器字典';
$string['editorfontfamily'] = '字型名稱';
$string['editorfontlist'] = '字型清單';
$string['editorfontsize'] = '字型大小';
$string['editorhidebuttons'] = '隱藏的按鈕';
$string['editorkillword'] = 'Word 格式過濾';
$string['editorspelling'] = '編輯器的拼字檢查';
$string['editorspellinghelp'] = '啟用或停用拼字檢查，伺服器上必須安裝 <strong>aspell</strong> 才能啟用。';
$string['editstrings'] = '編輯單字或片語';
$string['emailchangeconfirmation'] = '電子郵件變更確認';
$string['emoticonalt'] = '替代文字';
$string['emoticoncomponent'] = '圖片元件';
$string['emoticonimagename'] = '圖片名稱';
$string['emoticons'] = '表情符號';
$string['emoticons_desc'] = '這表單定義了用於你的網站的表情圖示。<br />
若要從這表格移除一列，把需要的欄位都改成空白值，再儲存表單即可。<br />
若要註冊一個新圖示，要在最下面的空白列填入所有欄位。<br />
若要重設所有欄位成為預設值，點選上方的鏈結。<br />
* 文字(必要) -- 放在文章中，用來叫出表情圖示的一連串符號，例如：8-)，它至少要有兩個字元。<br />
* 圖檔名稱(必要) --情緒圖像的檔名，不必加副檔名，放在component pix 資料夾中。<br />
* 圖像成分(必要) --提供圖標的元件。<br />
* 替代文字(選用) --表情圖示的替代文字的字串辨識器和元件。';
$string['emoticonsreset'] = '將表情符號重設為預設值';
$string['emoticontext'] = '文字';
$string['emptysettingvalue'] = '空白';
$string['enableajax'] = '啟用 AJAX';
$string['enableblogs'] = '啟用部落格';
$string['enablecalendarexport'] = '啟用行事曆匯出功能';
$string['enablecomments'] = '啟用評論功能';
$string['enablecourserequests'] = '啟用課程申請';
$string['enablecssoptimiser'] = '啟用CSS優化器';
$string['enablecssoptimiser_desc'] = '若啟用， CSS 在被放入快取之前會徹底跑一次最佳化過程。這最佳化程式會將 CSS 移除重複的規則和風格，還有可移除的空白空間，並重新格式化。當布景主題設計者模式表現很差時，同時開起這設定，將會幫助佈景主題設計者建立最佳化的 CSS。';
$string['enabled'] = '已經啟動';
$string['enabledevicedetection'] = '啟用裝置檢測';
$string['enablegravatar'] = '啟用Gravatar';
$string['enablegravatar_help'] = '啟用後，如果用戶未上傳個人照，Moodle會嘗試從Gravatar網站取得該用戶的個人照。';
$string['enablegroupmembersonly'] = '只有組內成員可用';
$string['enablemobilewebservice'] = '為行動裝置啟動網絡服務';
$string['enablerecordcache'] = '啟用資料錄快取';
$string['enablerssfeeds'] = '啟用RSS摘要';
$string['enablesafebrowserintegration'] = '啟用 Safe Exam Browser 的整合';
$string['enablestats'] = '啟用統計功能';
$string['enabletgzbackups'] = '啟用新的備份格式';
$string['enabletgzbackups_desc'] = '若啟用，未來的備份將為 .mbz 檔案(內部儲存為.tar .gz檔案)建立一新的壓縮格式。這將會移除備份檔不能超過4GB的限制，並可能增進效能。回存會支援兩種格式，且用戶不會察覺兩者的差異。';
$string['enabletgzbackups_nozlib'] = 'PHP擴展 &lsquo;zlib&rsquo;無法使用。這新的備份格式需要用到這擴展，且將會關閉，直到zilb安裝好並啟用。';
$string['enabletrusttext'] = '啟用信任的內容';
$string['enablewebservices'] = '啟用 Web 服務';
$string['enablewsdocumentation'] = 'Web 服務文件';
$string['enrolinstancedefaults'] = '選課方式預設值';
$string['enrolinstancedefaults_desc'] = '新建課程的預設選課設定。';
$string['enrolmultipleusers'] = '將這些用戶加入課程';
$string['environment'] = '環境';
$string['environmenterrortodo'] = '在開始安裝這個 Moodle 版本前，您必須修正上述所有環境問題（錯誤）！';
$string['environmenterrorupgrade'] = '警告：在升級這個 Moodle 的版本前，您需要解決上面找到的所有環境的問題（錯誤）！沒有修正這些問題就進行問題可能造成像是資料遺失等問題，您確定要繼續升級嗎？';
$string['environmentmustfixsetting'] = '必須修改PHP設定。';
$string['environmentok'] = '您的伺服器環境符合所有最低的需求。';
$string['environmentrecommendcustomcheck'] = '如果這個測試失敗，代表有一個潛在的問題';
$string['environmentrecommendinstall'] = '為了最佳效果，應該安裝並啟用';
$string['environmentrecommendversion'] = '建議版本為 {$a->needed} ，您目前版本為 {$a->current}';
$string['environmentrequirecustomcheck'] = '這個測試必須通過';
$string['environmentrequireinstall'] = '必須安裝並啟用';
$string['environmentrequireversion'] = '需求版本為{$a->needed}，而您目前版本為 {$a->current}';
$string['environmentsettingok'] = '檢測到建議設定';
$string['environmentshouldfixsetting'] = 'PHP設定應該修改。';
$string['environmentxmlerror'] = '讀取環境資料時發生錯誤 ({$a->error_code})';
$string['errordeletingconfig'] = '刪除外掛“{$a}”的設定記錄時出錯。';
$string['errorsetting'] = '無法儲存設定資料：';
$string['errorwithsettings'] = '無法更新一些設定，因為發生了這個錯誤：';
$string['everyonewhocan'] = '每一位可以\'{$a}\'的人';
$string['exceptions'] = '異常';
$string['execpathnotallowed'] = '在 config.php 檔設定的執行路徑已無法使用';
$string['experimental'] = '實驗性功能';
$string['experimentalsettings'] = '實驗性設定';
$string['extendedusernamechars'] = '帳號名稱允許使用延伸字元';
$string['extramemorylimit'] = '額外的 PHP 記憶體限制';
$string['fatalmagicquotesruntime'] = '<p>檢測到嚴重的設定錯誤，請通知伺服器管理員。</p><p>管理員必須修改PHP設定，才能讓Moodle正常執行。</p><p><code>magic_quotes_runtime</code>必須設為<code>off</code>。</p><p>修改伺服器上的<code>php.ini</code>, Apache/IIS <br />設定或<code>.htaccess</code>檔案可以控制此項設定。</p>';
$string['fatalsessionautostart'] = '<p>檢測到嚴重的設定錯誤，請通知伺服器管理員。</p> <p>管理員要更改PHP的設定，Moodle才能正常執行。</p> <p><code> session.auto_start </code>必須被設定為<code>off</code>。</p> <p>此設定使用編輯伺服器上<code>php.ini </code>、Apache/IIS的設定或<code>.htaccess </code>檔案來控制。</ p>';
$string['filecreated'] = '新檔案建立了';
$string['filestoredin'] = '儲存檔案到資料夾：';
$string['filestoredinhelp'] = '檔案儲存的位置';
$string['filterall'] = '過濾所有字串';
$string['filtermatchoneperpage'] = '過濾器在每頁只配對一次';
$string['filtermatchonepertext'] = '每篇文章只過濾一次';
$string['filters'] = '過濾';
$string['filtersettings'] = '過濾器設定';
$string['filtersettingsgeneral'] = '一般過瀘器設定';
$string['filteruploadedfiles'] = '過濾上傳的檔案';
$string['forcelogin'] = '強制用戶登入';
$string['forceloginforprofileimage'] = '用戶必須登入後才能查看個人照片';
$string['forceloginforprofileimage_help'] = '如果啟用，只有已登入用戶才能檢視用戶的個人照片，並且所有通知郵件都將使用這預設個人照片。';
$string['forceloginforprofiles'] = '強制用戶登入後才能檢視個人資料';
$string['forcetimezone'] = '強制使用預設時區';
$string['formatuninstallwithcourses'] = '這裡有{$a->count}個課程使用{$a->format}。他們的格式將會改成 {$a->defaultformat} (這一網站的預設格式)。某些格式指定的資料可能會遺失。您確定要繼續？';
$string['frontpage'] = '首頁';
$string['frontpagebackup'] = '首頁備份';
$string['frontpagedefaultrole'] = '首頁預設的角色';
$string['frontpagefilters'] = '首頁過濾';
$string['frontpageloggedin'] = '登入後首頁的項目';
$string['frontpageoverrides'] = '首頁權限置換';
$string['frontpagequestions'] = '首頁試題';
$string['frontpagerestore'] = '首頁還原';
$string['frontpageroles'] = '首頁角色';
$string['frontpagesettings'] = '首頁設定';
$string['fullnamedisplay'] = '完整名稱格式';
$string['fullnamedisplayprivate'] = '全名格式--私人';
$string['gdrecommended'] = 'GD 延伸套件用來做影像轉換，如果沒有安裝的話，將無法執行一些功能例如用戶個人簡介照片。';
$string['gdrequired'] = 'Moodle現在需要用到GD 擴展來進行圖像轉換';
$string['generalsettings'] = '一般設定';
$string['geoipfile'] = 'GeoIP 城市資料檔';
$string['getremoteaddrconf'] = '記錄的IP位址來源';
$string['globalswarning'] = '<p><strong>安全性警告</strong>: 為了正常運作，Moodle需要<br />您進行目前PHP設定的變更<p/><p>您 <em>務必</em>設定 <code>register_globals=off</code>.<p>此設定透過 <code>php.ini</code>, Apache/IIS <br />或<code>.htaccess</code> 檔案的編輯來設定。</p>';
$string['googlemapkey3'] = 'Google 地圖的 API V3 密鑰';
$string['googlemapkey3_help'] = '你需要輸入一特殊密鑰來使用Google 地圖進行視覺化尋找IP位址。您可以在 <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>免費取得密鑰。';
$string['gotofirst'] = '跳到第一個缺漏的字串';
$string['gradebook'] = '成績簿';
$string['gradebookroles'] = '列入成績簿的角色';
$string['gradeexport'] = '主要的成績匯出方式';
$string['gravatardefaulturl'] = 'Gravatar 預設圖像的網址';
$string['gravatardefaulturl_help'] = '如果不能夠對某用戶找到一張相片，Gravatar將需要一個預設的相片去展示。請對該相片提供一個完整的網址。如果您讓該選項為空白，那麼 Moodle 將會對於您當前瀏覽的頁面嘗試使用最合適的預設圖片。請注意 Gravatar 也有一段程式碼 <a href="https://en.gravatar.com/site/implement/images/#default-image"> 可以用於產生預設圖片。';
$string['groupenrolmentkeypolicy'] = '群組選課密鑰管理規則';
$string['groupenrolmentkeypolicy_desc'] = '啟動後，這將使Moodle以一個有效的密碼管理規則來檢查群組選課密鑰。';
$string['guestroleid'] = '訪客的角色';
$string['guestroleid_help'] = '此角色被自動分配給訪客用戶。它也被臨時分配給通過訪客選課外掛進入課程的未選課用戶。';
$string['helpadminseesall'] = '管理者可以看到所有行事曆或只有他們自己的行事曆?';
$string['helpcalendarcustomexport'] = '在匯出行事曆時，啟用自己訂定起迄日期的功能。您必須先啟用行事曆匯出功能，這才能發會作用。';
$string['helpexportlookahead'] = '在安照自訂選項匯出時，行事曆會往前幾天搜尋事件？';
$string['helpexportlookback'] = '在安照自訂選項匯出時，行事曆會往後幾天搜尋事件？';
$string['helpforcetimezone'] = '您可以允許用戶選擇他自己的時區或者讓所有用戶只能使用同一時區。';
$string['helpshowicalsource'] = '若你要顯示這 ical 設定的名稱，並連結到 ical 匯入的事件，請啟用這一設定。';
$string['helpsitemaintenance'] = '用於升級和其他需要的工作';
$string['helpstartofweek'] = '此日曆要以星期幾來當星期的第一天?';
$string['helpupcominglookahead'] = '此日曆預設要顯示未來幾天的行事?';
$string['helpupcomingmaxevents'] = '預設要顯示多少未來事件給使用者?';
$string['helpweekenddays'] = '那幾天視為一個星期的週末，將以不同顏色顯示?';
$string['hiddenuserfields'] = '隱藏使用者的欄位';
$string['hidefromall'] = '對所有使用者隱藏';
$string['hidefromnone'] = '不對任何人隱藏';
$string['hidefromstudents'] = '對學生隱藏';
$string['htmleditor'] = 'HTML 編輯器';
$string['htmleditorsettings'] = 'HTML編輯器設定';
$string['htmlsettings'] = 'HTML 設定';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP 安全性';
$string['hubs'] = '課程集散中心';
$string['iconvrecommended'] = '為了提昇網站效率，尤其您的網站支援非拉丁語系的情況下，建議您可以安裝額外的 ICONV 函式庫。';
$string['iconvrequired'] = 'ICONV延伸套件必須安裝。';
$string['ignore'] = '忽略';
$string['includemoduleuserdata'] = '包含模組使用者資料';
$string['incompatibleblocks'] = '不相容的區塊';
$string['installhijacked'] = '安裝必須完成從原來的IP地址，對不起。';
$string['installsessionerror'] = '無法初始化 PHP session，請確認您的瀏覽器接受 cookies。';
$string['intlrecommended'] = 'intl延伸套件可以增強國際化支持，例如符合區域習慣的排序。';
$string['invalidsection'] = '錯誤的區域';
$string['invaliduserchangeme'] = '帳號 “changeme”是保留的用戶名，您不能夠用來註冊。';
$string['ipblocked'] = '本站目前不能使用。';
$string['ipblocker'] = 'IP 封鎖器';
$string['ipblockersyntax'] = '每行只放一項。有效的項可以是完整的IP地址（例如<b>192.168.10.1</b>），它只與一個主機對應；也可以是部分地址（例如<b>192.168.</b>），它與任何用這些數字開頭的地址對應；也可以是CIDR符號（例如<b>231.54.211.0/20</b>）；還可以是一個IP地址範圍（例如<b>231.3.56.10-20</b>），指明地址最後一個數字的範圍。不支援網址（比如「example.com」）。空行會被忽略。';
$string['iplookup'] = 'IP 位址查詢';
$string['iplookupgeoplugin'] = '目前正在使用 <a href="http://www.geoplugin.com">geoPlugin</a> 服務來尋找地理資訊。為得到更準確的結果，我們建議在本地安裝 MaxMind GeoLite 資料庫。';
$string['iplookupinfo'] = '預設Moodle使用免費線上NetGeo(網際網路地理資料庫)伺服器來查詢IP位址的地理位置，不幸地此資料庫不再受維護而且可能回傳<em>錯誤</em>的資料。建議從MaxMind安裝本地的免費GeoLite City資料庫複本。<br />IP位址地理位置僅用簡單的地圖或使用Google Maps來顯示。請注意您需有Google帳號並申請免費的Google Maps API key來啟動互動式地圖。';
$string['iplookupmaxmindnote'] = '此產品包含由MaxMind建立的GeoLite資料，可從<a href="http://www.maxmind.com/">http://www.maxmind.com/</a>取得。';
$string['keeptagnamecase'] = '保留標籤名稱的大小寫';
$string['lang'] = '預設語言';
$string['langcache'] = '語言選單快取';
$string['langcache_desc'] = '快取語言選單。如果啟用快取語言選單，那麼可用的翻譯列表將會被快取。當您使用內置的語言包管理工具安裝或刪除語言包時，快取會自動更新。如果您手動安裝一個新的語言包時，您需要使用「清除快取」來更新已快取的語言包列表。';
$string['langlist'] = '語言選單中的語言項目';
$string['langmenu'] = '顯示語言選單';
$string['langpackwillbeupdated'] = '注意：在更新過程中，Moodle會嘗試更新您的語言包。您原有的語言資料夾將會被覆蓋。';
$string['langstringcache'] = '快取暫存所有語言字串';
$string['languagesettings'] = '語言設定';
$string['latexpreamble'] = 'LaTeX 前文';
$string['latexsettings'] = 'LaTeX 設定';
$string['latinexcelexport'] = 'Excel 檔案的編碼';
$string['legacyfilesaddallowed'] = '允許添加到繼承的課程檔案。';
$string['legacyfilesaddallowed_help'] = '若一個課程有繼承先前的檔案，允許添加新檔案和資料夾到它裡面。';
$string['legacyfilesinnewcourses'] = '新課程使用舊版課程檔案';
$string['legacyfilesinnewcourses_help'] = '預設情況下，舊版本課程檔案只在升級過來的課程中存在。請注意，某些功能，比如單個活動的備份/還原，和此設定不兼容。';
$string['licensesettings'] = '授權設定';
$string['linkadmincategories'] = '連結管理類別';
$string['linkadmincategories_help'] = '如果啟用，管理員設定分類連結會顯示在導覽中，導向管理分類頁面。';
$string['loading'] = '載入中';
$string['localetext'] = '網站語系';
$string['localstringcustomization'] = '自訂本地文字';
$string['location'] = '位置';
$string['locationsettings'] = '位置設定';
$string['locked'] = '被鎖住';
$string['lockoutduration'] = '帳戶封鎖期限';
$string['lockoutduration_desc'] = '被封鎖的帳戶在這一期限之後，會自動解封鎖。';
$string['lockoutemailbody'] = '您在\'{$a->sitename}\'以 {$a->username} 為名的帳號，在多次無效的登入動作之後，已經被封鎖了。

若要立刻解除這帳號的封鎖，請到下列網址

{$a->link}

在大多式的郵件程式，這網址是以藍色出現，而你可以點選它，但如果無效。
那就剪貼這網址到你的瀏覽器的頂端網址列上。

若你需要幫助，請聯絡網站管理員,
{$a->admin}';
$string['lockoutemailsubject'] = '你在{$a}的帳號被封鎖了';
$string['lockouterrorunlock'] = '提供的帳號封鎖資訊無效';
$string['lockoutthreshold'] = '帳號封鎖門檻';
$string['lockoutthreshold_desc'] = '指定在幾次登入之敗之後，該帳號將被封鎖。這一功能常被用於拒絕服務攻擊。';
$string['lockoutwindow'] = '帳戶封鎖狀況的觀察視窗';
$string['lockoutwindow_desc'] = '封鎖門檻的觀察時間。如果沒有失敗的嘗試，這一門檻計數器將會在這時間之後重設。';
$string['log'] = '日誌';
$string['logguests'] = '日誌包含訪客的訪問';
$string['logguests_help'] = '啟用此一設定將會逐一紀錄訪客帳號及未登入用戶的的動作。高負載的網站為了效能上的原因可能會想關閉這紀錄日誌檔的功能。在正式運作網站上，建議您保持啟用此設定。';
$string['loginhttps'] = '使用 HTTPS 登入';
$string['loginpageautofocus'] = '自動將游標移到登入表單';
$string['loginpageautofocus_help'] = '啟用此選項可以讓登入頁面更方便，但自動移動焦點可能會給無障礙進入帶來問題。';
$string['loginpasswordautocomplete'] = '防止登入表單自動儲存密碼功能';
$string['loginpasswordautocomplete_help'] = '關閉此選項，將允許用戶在瀏覽器中儲存他們的帳號密碼。打開此選項會使您的網站不再符合XHTML的嚴格驗證規則。';
$string['loglifetime'] = '日誌要保留幾天';
$string['longtimewarning'] = '<b>請注意，這個處理過程可能需要很長的一段時間。</b>';
$string['maintenancemode'] = '維護模式中';
$string['maintenancemodeisscheduled'] = '網站會在{$a}分鐘之後自動切入維護模式';
$string['maintfileopenerror'] = '開啟維護檔案時發生錯誤！';
$string['maintinprogress'] = '維護進行中';
$string['manageformats'] = '管理課程格式';
$string['manageformatsgotosettings'] = '預設格式可以在{$a}被更改';
$string['managelang'] = '管理';
$string['managelicenses'] = '管理著作權授權';
$string['manageqbehaviours'] = '管理答題互動方式';
$string['manageqtypes'] = '管理試題類型';
$string['maturity100'] = 'Beta測試版';
$string['maturity150'] = '候選發行版';
$string['maturity200'] = '穩定版';
$string['maturity50'] = 'Alpha測試版';
$string['maturityallowunstable'] = '提示：您可能需要使用 --allow-unstable 選項來執行這個腳本';
$string['maturitycoreinfo'] = '您的網站目前正執行不穩定的“{$a}”開發版程式碼。';
$string['maturitycorewarning'] = '您正要安裝或升級的Moodle版本包含不穩定的“{$a}”開發程式碼，它還不適合在正式網站使用。如果您不想這樣，請確認您正在從穩定分支的Moodle程式碼升級。請參閱Moodle文件了解更多細節。';
$string['maxbytes'] = '上傳檔案大小的最大值';
$string['maxconsecutiveidentchars'] = '連續相同字元數';
$string['maxeditingtime'] = '編輯張貼內容的最大時間';
$string['maxusersperpage'] = '每一頁可顯示的最大用戶數';
$string['mbstringrecommended'] = '為了提昇網站效率，建議您可以安裝額外的 MBSTRING 函式庫，特別是在您的網站使用非拉丁語系。';
$string['mediapluginavi'] = '啟用 .avi 過濾器';
$string['mediapluginflv'] = '啟用 .flv過濾器';
$string['mediapluginimg'] = '啟用連結的圖片自動嵌入';
$string['mediapluginmov'] = '啟用 .mov過濾器';
$string['mediapluginmp3'] = '啟用 .mp3 過濾器';
$string['mediapluginmpg'] = '啟用 .mpg 過濾器';
$string['mediapluginogg'] = '啟用 .ogg 過濾器';
$string['mediapluginogv'] = '啟用 .ogv 過濾器';
$string['mediapluginram'] = '啟用 .ram 過濾器';
$string['mediapluginrm'] = '啟用 .rm過濾器';
$string['mediapluginrpm'] = '啟用 .rpm 過濾器';
$string['mediapluginswf'] = '啟用 .swf 過濾器';
$string['mediapluginswfnote'] = '使用預設的安全性，一般使用者不允許嵌入swf的flash檔案。';
$string['mediapluginwmv'] = '啟用 .wmv 過濾器';
$string['mediapluginyoutube'] = '啟用 YouTube 連結網址的過濾器';
$string['messaging'] = '啟用傳訊系統';
$string['messagingallowemailoverride'] = '額外的電子郵件通知信箱';
$string['messagingdeletereadnotificationsdelay'] = '刪除閱讀提醒';
$string['messaginghidereadnotifications'] = '隱藏閱讀提醒';
$string['minpassworddigits'] = '密碼最少的數字數';
$string['minpasswordlength'] = '密碼最小長度';
$string['minpasswordlower'] = '密碼最少小寫字母數';
$string['minpasswordnonalphanum'] = '最少非阿拉伯數字字元';
$string['minpasswordupper'] = '最少大寫字母';
$string['misc'] = '雜項';
$string['mnetrestore_extusers'] = '<strong>注意：</strong>這個備份檔案包含了遠端網路使用者帳號，在還原時會是處理過程的一部分。';
$string['mnetrestore_extusers_admin'] = '<strong>注意：</strong>您選擇的備份檔案貌似是來自另一個Moodle系統，且檔案中包含遠端Moodle網絡用戶帳號。這還原過程將嘗試把所有已建立的用戶和Moodle網絡主機配對。所有不符合的帳號將自動切換為內部認證帳號（而不是mnet帳號）。還原日誌將會告知你詳情。';
$string['mnetrestore_extusers_mismatch'] = '<strong>注意：</strong> 這個備份檔案來自一個不同的MOODLE網站，而且包括遠端Moodle網路中的用戶帳號，這個還原可能無法成功。如果您確定它是在這一Moodle建立的備份檔案，或者您確定所有需要的Moodle網路主機已經設定完成，您才可以嘗試還原。';
$string['mnetrestore_extusers_noadmin'] = '<strong>注意：</strong>您選擇的備份檔案貌似是來自另一個Moodle，且檔案中包含遠端Moodle網路用戶帳號。您不可以進行這種還原。請聯繫網站管理員，或者以不帶任何用戶資訊（模組、檔案等）方式來還原這課程。';
$string['mnetrestore_extusers_switchuserauth'] = '遠端Moodle網路用戶{$a->username}(來自{$a->mnethosturl}) 切換到本地{$a->auth}認證用戶';
$string['mobile'] = '行動裝置';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = '預設的活動選擇器';
$string['modeditdefaults'] = '活動設定的預設值';
$string['modeditingmenu'] = '活動編輯選單';
$string['modeditingmenu_desc'] = '若啟用，在編輯課程時，許多活動編輯的小圖示將會顯示在一個下拉選單上。這設計會隱藏小圖示以減少螢幕上的內容，等到需要時才顯現。';
$string['modsettings'] = '管理活動';
$string['modulesecurity'] = '模組安全';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = '強制舊版的多語言語法：沒有 class="multilang" 的&lt;span&gt; 和 &lt;lang&gt;';
$string['mustenablestats'] = '本網站的統計功能還未被開啟。';
$string['mycoursesperpage'] = '課程數量';
$string['mydashboard'] = '系統預設儀表板';
$string['mymoodle'] = '我的首頁';
$string['mymoodleredirect'] = '強制用戶使用“我的Moodle”';
$string['mypage'] = '預設My Moodle頁';
$string['mypagelocked'] = '鎖住預設頁面';
$string['myprofile'] = '預設個人簡介頁';
$string['mysql416bypassed'] = '不過，若您的網站僅使用 iso-8859-1 (latin) 語言，您可以繼續使用目前安裝的 MySQL 4.1.12 (或以上的版本)。';
$string['mysql416required'] = 'Moodle 1.6 需要 MySQL 4.1.16以上的版本來確保未來所有資料都能夠轉換為 UTF-8 編碼。';
$string['navadduserpostslinks'] = '添加鏈結來檢視用戶的貼文';
$string['navadduserpostslinks_help'] = '若啟用，每一用戶的導覽方塊中都會加上兩個連結，指向用戶在全網站或特定課程的討論區發起的議題和發表的文章。';
$string['navcourselimit'] = '課程限制';
$string['navigationupgrade'] = '此次升級倒入了兩個新的導覽區塊來替換管理、課程、活動和課程參與者區塊。如果您已經為這些區塊設定了某些特殊的權限，那麼您應該檢查一下是否一切都按照您想要的方式運作。';
$string['navshowallcourses'] = '顯示全部課程';
$string['navshowcategories'] = '顯示課程類別';
$string['navshowfrontpagemods'] = '在導覽中顯示首頁活動';
$string['navshowfrontpagemods_help'] = '如果啟用，導覽區塊的「網站頁面」下會顯示首頁活動。';
$string['navshowfullcoursenames'] = '顯示課程完整名稱';
$string['navshowfullcoursenames_help'] = '若啟用，在導覽列的課程將會以完整名稱顯示，而不是用簡稱。';
$string['navshowmycoursecategories'] = '顯示我的課程類別';
$string['navshowmycoursecategories_help'] = '如果啟用，用戶“我的課程”中的課程會顯示在分類中。';
$string['navsortmycoursessort'] = '將我的課程排序';
$string['navsortmycoursessort_help'] = '這會決定顯示在我的課程清單上的課程是否要依據設定進行排序(設定>網站管理>課程>添加/編輯課程)或依照字母順序排序。';
$string['neverdeleteruns'] = '從不刪除執行';
$string['nobookmarksforuser'] = '您沒有任何的書籤。';
$string['nodatabase'] = '沒有資料庫';
$string['nohttpsformobilewarning'] = '建議啟用HTTPS並使用有效的憑證。Moodle應用總會先嘗試安全連線。';
$string['nomissingstrings'] = '沒有缺少的字串';
$string['nonewsettings'] = '此次升級沒有增加新的設定。';
$string['nonexistentbookmark'] = '您請求的書籤不存在。';
$string['noresults'] = '查無結果';
$string['noroles'] = '沒有角色';
$string['notifications'] = '通知';
$string['notifyloginfailures'] = '發送登入失敗的Email到';
$string['notifyloginthreshold'] = '郵件通知的門檻';
$string['notloggedinroleid'] = '訪客的角色';
$string['numberofmissingstrings'] = '缺少字串數：$a}';
$string['numberofstrings'] = '總共字串數：{$a->strings}<br/>缺少：{$a->missing}({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'PHP的opcode快取可以改進效率並降低記憶體的需求，本系統建議使用，並完全支援OPCache擴展，';
$string['opensslrecommended'] = '強烈建議您安裝 OpenSSL 函式庫，這樣才能夠使用 Moodle Networking功能';
$string['opentogoogle'] = '開放給 Google 搜尋';
$string['optionalmaintenancemessage'] = '可選的維護資訊';
$string['order1'] = '第一';
$string['order2'] = '第二';
$string['order3'] = '第三';
$string['order4'] = '第四';
$string['passwordpolicy'] = '密碼政策';
$string['passwordresettime'] = '在多久之內要驗證密碼的重設請求';
$string['pathconvert'] = '<i>convert</i> 指令路徑';
$string['pathdvips'] = '<i>dvips</i> 指令路徑';
$string['pathlatex'] = '<i>latex</i> 指令路徑';
$string['pathtoclam'] = 'clam AV 路徑';
$string['pathtodot'] = 'dot的路徑';
$string['pathtodot_help'] = 'dot的路徑。形式如/usr/bin/dot。您必須安裝dot並在這裡指向它，才能從DOT檔案生成圖片。注意，到目前為止，只有Moodle內建的剖析功能（開發->剖析）需要使用它。';
$string['pathtodu'] = 'du的路徑';
$string['pathtopgdump'] = 'pg_dump 指令路徑';
$string['pathtopgdumpdesc'] = '若系統中有一個以上的 pg_dump 執行檔，只需按下enter鍵（例如您安裝了一個版本以上的 postgresql ）';
$string['pathtopgdumpinvalid'] = 'pg_dump 路徑有誤 - 路徑錯誤或是無法執行';
$string['pathtopsql'] = 'psql的路徑';
$string['pathtopsqldesc'] = '若系統中有一個以上的 psql 執行檔，只需按下enter鍵（例如您安裝了一個版本以上的 postgresql ）';
$string['pathtopsqlinvalid'] = 'psql 路徑有誤 - 路徑錯誤或是無法執行';
$string['pcreunicodewarning'] = '我們強烈建議您使用兼容Unicode字符的的PCRE PHP擴展。';
$string['perfdebug'] = '效能資訊';
$string['performance'] = '效能';
$string['pgcluster'] = 'PostgreSQL叢集';
$string['pgclusterdescription'] = '命令列操作所需的 PostgreSQL 版本/叢集 參數，如果您在系統中只安裝一個 postgresql ，請保留空白。';
$string['php50restricted'] = 'PHP 5.0.x 有許多已知問題，請升級為 5.1.x 或降級為 4.3.x 或 4.4.x';
$string['php533warning'] = 'PHP 5.3.3及以上';
$string['phpfloatproblem'] = '在處理PHP浮點數-{$a}時，偵測到不可預期的問題。';
$string['pleaserefreshregistration'] = '您的網站已在Moodle.org登記。自從您上次的更新後，如果有重大的改變，請考慮在{$a}更新登記資料。';
$string['pleaseregister'] = '請註冊您的網站以移除此按鈕。';
$string['plugin'] = '外掛';
$string['plugins'] = '外掛';
$string['pluginscheck'] = '外掛模組的相依性檢查';
$string['pluginscheckfailed'] = '{$a->pluginslist}相依性檢查失敗';
$string['pluginschecktodo'] = '您必須先解決所有外掛的需求，然後再繼續安裝此版本的Moodle！';
$string['pluginsoverview'] = '外掛模組概況';
$string['pluginsoverviewsee'] = '請參閱<a href="{$a->url}">外掛模組概況</a>了解更多細節。';
$string['profilecategory'] = '類別';
$string['profilecategoryname'] = '類別名稱 (必須是唯一不重複)';
$string['profilecategorynamenotunique'] = '這類別名稱已經被使用了';
$string['profilecommonsettings'] = '共同的設定';
$string['profileconfirmcategorydeletion'] = '在這個類別有 {$a} 個欄位將移到上一層類別（或是在最上層類別之下）<br />您是否仍確定要刪除這個類別？';
$string['profileconfirmfielddeletion'] = '這個欄位有 {$a} 筆使用者資料將被刪除<br />您是否仍確定要刪除這個欄位？';
$string['profilecreatecategory'] = '建立一項新的個人資料分類';
$string['profilecreatefield'] = '建立一項新的個人資料分類';
$string['profilecreatenewcategory'] = '建立一個新的類別';
$string['profilecreatenewfield'] = '建立一項新的 &quot;{$a}&quot; 個人資料欄位';
$string['profiledefaultcategory'] = '其他欄位';
$string['profiledefaultchecked'] = '預設勾選';
$string['profiledefaultdata'] = '預設值';
$string['profiledeletecategory'] = '刪除一個分類';
$string['profiledeletefield'] = '刪除一個欄位';
$string['profiledescription'] = '欄位的描述說明';
$string['profiledscript'] = '這個腳本程式已經被剖析過';
$string['profiledscriptview'] = '查看此腳本程式的剖析資訊';
$string['profileeditcategory'] = '編輯類別：{$a}';
$string['profileeditfield'] = '編輯個人資料欄位：{$a}';
$string['profilefield'] = '個人資料欄位';
$string['profilefieldcolumns'] = '欄數';
$string['profilefieldispassword'] = '這是密碼欄位嗎？';
$string['profilefieldlink'] = '連結';
$string['profilefieldlink_help'] = '要將文字轉換成超連結，請輸入一個包含$$的網址，其中$$將被替換成文字。例如，要將一個Twitter的ID轉換成鏈接，請輸入：http://twitter.com/$$。';
$string['profilefieldlinktarget'] = '連結目標';
$string['profilefieldmaxlength'] = '最大的長度';
$string['profilefieldrows'] = '行';
$string['profilefields'] = '個人資料欄位';
$string['profilefieldsize'] = '顯示大小';
$string['profileforceunique'] = '此資料必須是唯一的(不能有重複)？';
$string['profileinvaliddata'] = '無效的值';
$string['profilelocked'] = '這個欄位要鎖住嗎?';
$string['profilemenudefaultnotinoptions'] = '這預設值不是選項之一';
$string['profilemenunooptions'] = '沒有提供選單的選項';
$string['profilemenuoptions'] = '選單的選項(每行一項)';
$string['profilemenutoofewoptions'] = '您必須提供至少兩個選項';
$string['profilename'] = '名稱';
$string['profilenofieldsdefined'] = '沒有定義欄位';
$string['profilerequired'] = '這個欄位是必填的嗎？';
$string['profileroles'] = '個人資料可見角色';
$string['profilesforenrolledusersonly'] = '已選課用戶的個人簡介';
$string['profileshortname'] = '簡稱(必須是唯一)';
$string['profileshortnamenotunique'] = '這個簡稱已經被使用了';
$string['profilesignup'] = '顯示在註冊的頁面上？';
$string['profilespecificsettings'] = '具體的設定';
$string['profilevisible'] = '誰可以看見這個欄位？';
$string['profilevisibleall'] = '每個人都可以看見';
$string['profilevisible_help'] = '* 不可見 - 只有管理員能查看的私人資料

* 用戶可見 - 只有管理員和用戶能查看的私人資料

* 所有人可見';
$string['profilevisiblenone'] = '不可見';
$string['profilevisibleprivate'] = '用戶可以看見';
$string['profiling'] = '剖析';
$string['profilingallowall'] = '持續剖析';
$string['profilingallowall_help'] = '如果啟用此設定，那麼在任何時候，您可以在任何地方使用PROFILEALL參數(PGC)來啟用對Moodle連線生命週期中執行的所有腳本程式的剖析。類似地，您可以使用PROFILEALLSTOP參數，將其停止。';
$string['profilingallowme'] = '選擇性剖析';
$string['profilingallowme_help'] = '如果啟用此設定，那麼您可以選擇性地在任何地方使用PROFILEME參數(PGC)，來剖析該腳本程式。類似地，您可以使用DONTPROFILEME參數，以防止分析發生。';
$string['profilingautofrec'] = '自動剖析';
$string['profilingautofrec_help'] = '藉著配置這一設定，一些請求(隨機地，基於指定的頻率(1/n))會被選出、自動剖析、儲存結果以待進一步分析。注意這種剖析方法會觀察包含/排除設定。將它設為0會關閉自動剖析。';
$string['profilingenabled'] = '啟用剖析';
$string['profilingenabled_help'] = '如果您啟用了這個設定，那麼剖析就是可使用的，然後您就可以使用設定下一個選項來定義它的行為。';
$string['profilingexcluded'] = '排除剖析';
$string['profilingexcluded_help'] = '符合“剖析這些”設定的定義，但不要被剖析的URL列表（逗號分隔，絕對路徑但不含wwwroot,callable）。';
$string['profilingimportprefix'] = '自動剖析匯入的前綴字';
$string['profilingimportprefix_desc'] = '為了更容易偵測，所有匯入的剖析檔案將會在前面加上這裡所指定的數值。';
$string['profilingincluded'] = '剖析這些';
$string['profilingincluded_help'] = '會被自動剖析的URL列表（逗號分隔，絕對路徑但不含wwwroot，callable）。例如： /index.php，/course/view.php。在任何位置都可以使用 * 星號萬用字元。例如：/mod/forum/*，/mod/*/view.php。';
$string['profilinglifetime'] = '保留剖析執行資料';
$string['profilinglifetime_help'] = '指定您想保留多久舊的剖析執行資訊。舊資料會被週期清理。注意，這不包含任意標記為「參考執行」的剖析執行資料。';
$string['protectusernames'] = '保護用戶姓名';
$string['proxybypass'] = '不使用Proxy的主機';
$string['proxyhost'] = 'Proxy 主機';
$string['proxypassword'] = 'Proxy密碼';
$string['proxyport'] = 'Proxy連接埠';
$string['proxytype'] = 'Proxy類型';
$string['proxyuser'] = 'Proxy用戶名稱';
$string['purgecaches'] = '清空所有快取';
$string['purgecachesconfirm'] = 'Moodle可以快取佈景主題、javascript、語言字串、已過濾的純文字、RSS摘要和許多其它已處理過的資料。清空這些快取會從伺服器刪除這些資料，並強制瀏覽器重新下載資料，因而使您能看到由目前語法生成的最新資料。清空快取並沒有危險，但在伺服器和客戶端還沒有處理完新資訊和快取好它們之前，您的網站可能會顯得有點兒慢。';
$string['purgecachesfinished'] = '所有快取都被清空了。';
$string['qtyperqpwillberemoved'] = '在更新期間，RQP問題類型將被移除。您不能再使用這種問題類型，這樣就不會遇到任何問題。';
$string['qtyperqpwillberemovedanyway'] = '在更新時，也將RQP問題移除。您的資料庫中有一些RQP問題存在，除非您在繼續更新前，重新安裝程式碼 http://moodle.org/mod/data/view.php?d=13&amp;rid=797，否則它會停止運作。';
$string['quarantinedir'] = '隔離目錄';
$string['question'] = '試題';
$string['questionbehaviours'] = '試題作答與計分方式';
$string['questioncwqpfscheck'] = '測驗中的一個或多個『隨機』試題來至於共享和非共享題型中。更多細節報表<a href="{$a->reporturl}">點選這裡</a>，或者<a href="{$a->docsurl}">參閱Moodle文件</a>。';
$string['questioncwqpfsok'] = '很好。在您的測驗卷中沒有任何的\'隨機\' 試題設定為從共用及非共用混合的題庫中選取出來。';
$string['questiontype'] = '題型';
$string['questiontypes'] = '題型';
$string['quizattemptsupgradedmessage'] = '在Moodle2.1試題有重大的升級，但有可能資料庫的升級並沒有趕上。在您升級到Moodle2.7之前，必須完成這個升級。';
$string['recaptchaprivatekey'] = 'ReCAPTCHA 私鑰';
$string['recaptchapublickey'] = 'ReCAPTCHA 公鑰';
$string['register'] = '註冊您的網站';
$string['registermoodleorg'] = '當您使用{$a}註冊您的網站';
$string['registermoodleorgli1'] = '為了您能得到重要的通知如安全警告和新版本的Moodle，您被加入到一個低量的郵件寄送清單中。';
$string['registermoodleorgli2'] = '關於您網站的統計資料將被加入到全球的 Moodle 社區{$a}裡。';
$string['registermoodleorgli3'] = '您的網站也在 Moodle.net ({$a})註冊了，它允許有發佈課程權限的用戶（預設為只有管理員）有發佈課程到Moodle.net 的選項。';
$string['registerwithmoodleorg'] = '向 Moodle.org 註冊';
$string['registration'] = '註冊';
$string['registration_help'] = '建議將你的網站在 Moodle.org 註冊，這樣才能收到安全性警告的通知，參與<a href="http://moodle.org/stats">Moodle 使用狀況統計</a>，以及在 <a href="http://moodle.net/">Moodle.net</a>上分享各種課程。';
$string['registrationwarning'] = '您的網站尚未註冊。';
$string['releasenoteslink'] = '想更多瞭解此版本的 Moodle，請參考<a target="_new" href="{$a}">發行備忘錄</a>。';
$string['rememberusername'] = '記住用戶名稱';
$string['rememberusername_desc'] = '如果想在用戶登入時用永久cookie 儲存用戶名稱，啟用此選項。如果未經用戶同意而使用永久 cookie，可能會引發隱私問題。';
$string['reportsmanage'] = '管理報表';
$string['requestcategoryselection'] = '啟用類別選擇';
$string['requiredentrieschanged'] = '<strong>重要：請閱讀<br/>（這條警告只會在升級過程中顯示）</strong><br/>為了修復一個bug，使用了「必須完成的條目數」和「查看前必須完成的條目數」的資料庫活動的設定將被更改。請查看<a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">資料庫模組討論區</a>瞭解更多細節。還可以在<a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle文件</a>中瞭解這些設定的功能。<br/><br/>這個修改影響您系統中的下列資料庫：（請馬上儲存此列表，並在升級結束後，檢查這些活動是否仍按照教師期望的方式工作。）<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = '需要活動的描述';
$string['requires'] = '必要';
$string['restorernewroleid'] = '操作還原的用戶在課程中的角色';
$string['restorernewroleid_help'] = '如果這用戶還沒有管理新還原課程的權限，那麼用戶會被自動選修課程並指派此角色。如果您不期望做還原的用戶能管理所有他還原的課程，就選擇「無」。';
$string['reverseproxy'] = '反向代理';
$string['riskconfig'] = '用戶能夠改變網站的設定和行為';
$string['riskconfigshort'] = '設定的風險';
$string['riskdataloss'] = '用戶能破壞大量內容或資訊';
$string['riskdatalossshort'] = '資料遺失的風險';
$string['riskmanagetrust'] = '用戶能夠改變其它用戶的信任設定';
$string['riskmanagetrustshort'] = '管理信任';
$string['riskpersonal'] = '用戶能夠存取其它用戶私人資訊';
$string['riskpersonalshort'] = '隱私的風險';
$string['riskspam'] = '用戶能夠發送垃圾廣告給站內用戶或其它人';
$string['riskspamshort'] = '垃圾資訊風險';
$string['riskxss'] = '用戶可以增加允許跨網站攻擊(XSS)的檔案和文字';
$string['riskxssshort'] = '跨網站攻擊程式的風險';
$string['roleswithexceptions'] = '{$a->roles}，有例外 {$a->exceptions}';
$string['rssglobaldisabled'] = '在伺服器層面禁用';
$string['runclamavonupload'] = '當上傳檔案時使用 clam AV 檢查';
$string['save'] = '儲存';
$string['savechanges'] = '儲存變更';
$string['search'] = '搜尋';
$string['searchinsettings'] = '在設定中搜尋';
$string['searchresults'] = '搜尋結果';
$string['sectionerror'] = '區段錯誤';
$string['secureforms'] = '使用額外的表單安全性';
$string['security'] = '安全';
$string['selectdevice'] = '選擇設備';
$string['selecttheme'] = '為{$a}設備選擇佈景';
$string['server'] = '主機';
$string['serverchecks'] = '伺服器檢查';
$string['serverlimit'] = '伺服器限制';
$string['sessionautostartwarning'] = '<p>檢測到嚴重的設定錯誤。請通知伺服器管理員。</p><p>為了Moodle的正確運作，需要管理員修改PHP設定。</p><p><code>session.auto_start</code>必須被設為<code>off</code>。</p><p>修改伺服器上的<code>php.ini</code>、 Apache/IIS<br />設定或<code>.htaccess</code>檔案可以設定它。</p>';
$string['sessioncookie'] = 'Cookie 的字首';
$string['sessioncookiedomain'] = 'Cookie 的網域';
$string['sessioncookiepath'] = 'Cookie 的路徑';
$string['sessionhandling'] = 'Session 處理';
$string['sessiontimeout'] = '逾時';
$string['settingfileuploads'] = '很多功能都需要使用檔案上傳功能，請在PHP設定中啟用這個功能。';
$string['settingmemorylimit'] = '記憶體不夠用，請在PHP設定中設定更高的記憶體限制。';
$string['settingsafemode'] = 'Moodle和安全模式不完全兼容。請讓伺服器管理員關閉安全模式。在安全模式下執行Moodle無法獲得支援。如果您堅持這麼做，那麼您將遭遇各種問題。';
$string['showcommentscount'] = '顯示評論數';
$string['showdetails'] = '顯示細節';
$string['showuseridentity'] = '顯示用戶身分';
$string['showuseridentity_desc'] = '當選擇或搜尋用戶，以及顯示用戶列表的時候，這些欄位可以和他們的完整姓名一起顯示。這些欄位只顯示給有moodle/site:viewuseridentity權限的用戶。預設下是教師和管理員。（選擇您的機構強制分配的欄位，例如學號或班級，會非常有用。）';
$string['simplexmlrequired'] = 'Moodle現在需要SimpleXML的PHP延伸套件.';
$string['sitemaintenance'] = '這個網站目前正在維護中，暫時不能使用。';
$string['sitemaintenancemode'] = '網站維護模式';
$string['sitemaintenanceoff'] = '維護模式已經關閉了，現在網站已經重新正常運行。';
$string['sitemaintenanceon'] = '您的網站目前處於維護模式(只有管理員可以登錄或使用網站)。';
$string['sitemaintenanceoncli'] = '你的網站現在處於CLI維護模式，不允許存取網頁。';
$string['sitemaintenancewarning'] = '您的網站目前處於維護模式（只有管理員可以登入）。要讓網站回到正常模式，請<a href="maintenance.php">關閉維護模式</a>。';
$string['sitemaintenancewarning2'] = '您的網站目前處於維護模式（只有管理員可以登入）。要讓網站回到正常模式，請<a href="{$a}">關閉維護模式</a>。';
$string['sitepolicies'] = '網站管理規則';
$string['sitepolicy'] = '網站管理規則網址';
$string['sitepolicyguest'] = '給訪客網站管理規則的網址';
$string['sitepolicyguest_help'] = '如果您有一份網站使用協議，並且需要所有訪客在使用此網站前閱讀並同意，那麼請在此指定它的網址，否則請留空。網址可以指向任何公開的地址。注意：如果設定了強制登入，那麼未登入用戶的存取會被拒絕。';
$string['sitepolicy_help'] = '如果您有一份網站使用協議，並且要求所有已註冊用戶在使用此網站前閱讀並同意，那麼請在此指定它的網址，否則請留空。這設定可以指向任何公開的網址。';
$string['sitesectionhelp'] = '選擇後，網站首頁會出現一個主題區。';
$string['slasharguments'] = '使用斜線參數';
$string['smartpix'] = '智慧搜尋小圖示';
$string['soaprecommended'] = '安裝選擇性的soap擴展，對於web services和某些外掛是有用的。';
$string['sort_fullname'] = '課程完整名稱';
$string['sort_idnumber'] = '課程辨識編號';
$string['sort_shortname'] = '課程簡稱';
$string['sort_sortorder'] = '排列順序';
$string['spellengine'] = '拼字檢查引擎';
$string['spelllanguagelist'] = '拼字檢查語言列表';
$string['splrequired'] = 'PHP的SPL延伸套件現在是執行Moodle的必備條件。';
$string['stats'] = '統計';
$string['statsfirstrun'] = '最長處理的時間間隔';
$string['statsmaxruntime'] = '最長執行時間';
$string['statsmoodleorg'] = '統計資料';
$string['statsruntimedays'] = '處理的天數';
$string['statsruntimestart'] = '執行於';
$string['statsuserthreshold'] = '用戶門檻';
$string['stickyblocks'] = '置頂區塊';
$string['stickyblockscourseview'] = '課程頁面';
$string['stickyblocksduplicatenotice'] = '如果您在這裡新增的區塊已經存在於同樣頁面，這會造成重複情形。<br />只有停駐的區塊不會被編輯，重複的項目還是會被修改。';
$string['stickyblocksmymoodle'] = '我的Moodle';
$string['stickyblockspagetype'] = '要設定的頁面類型';
$string['strictformsrequired'] = '嚴格的驗證必填欄位';
$string['stripalltitletags'] = '移除所有活動名稱中的HTML標籤';
$string['supportcontact'] = '支援聯絡';
$string['supportemail'] = '支援的電子郵件信箱';
$string['supportname'] = '支援的名稱';
$string['supportpage'] = '支援的頁面';
$string['suspenduser'] = '暫停用戶帳號';
$string['switchlang'] = '切換語言目錄';
$string['systempaths'] = '系統路徑';
$string['tablenosave'] = '在上面表格中所做的修改會被自動儲存。';
$string['tablesnosave'] = '在上面表格中所做的修改會被自動儲存。';
$string['tabselectedtofront'] = '在多頁籤的表格中，是否要將目前已選擇的頁籤放在前面？';
$string['tabselectedtofronttext'] = '將已選擇的頁籤列移到最前面';
$string['testsiteupgradewarning'] = '你現在是使用{$a}在測試網站，要將它升級，請使用指令行介面工具。';
$string['themedesignermode'] = '佈景設計師模式';
$string['themelist'] = '佈景清單';
$string['themenoselected'] = '未選擇佈景主題';
$string['themeresetcaches'] = '清除佈景暫存';
$string['themeselect'] = '更改佈景主題';
$string['themeselector'] = '佈景選擇';
$string['themesettings'] = '佈景設定';
$string['therewereerrors'] = '資料有錯誤';
$string['thirdpartylibrary'] = '程式庫';
$string['thirdpartylibrarylocation'] = '位置';
$string['thirdpartylibs'] = '第三方的程式庫';
$string['timezone'] = '預設時區';
$string['timezoneforced'] = '這是網站管理員規定必須這樣做';
$string['timezoneisforcedto'] = '強制所有用戶使用';
$string['timezonenotforced'] = '用戶可以選擇自己的時區';
$string['tokenizerrecommended'] = '建議安裝 PHP Tokenizer 外掛，它可以增進 Moodle 網路功能。';
$string['tools'] = '管理工具';
$string['toolsmanage'] = '設定管理工具';
$string['unattendedoperation'] = '自動化安裝';
$string['unbookmarkthispage'] = '移除這個頁面的書籤';
$string['unicoderecommended'] = '建議將所有資料儲存為萬國編碼(UTF-8)，新安裝的網站在存取資料庫時預設編碼都是萬國編碼，如果您正在進行升級，您應該執行 UTF-8 轉換程式（請參考管理首頁）';
$string['unicoderequired'] = '您必須將資料儲存為萬國編碼格式 (UTF-8)，新安裝的網站在存取資料庫時預設編碼都是萬國編碼，如果您正在進行升級，您應該執行 UTF-8 轉換程式（請參考管理首頁）';
$string['uninstallplugin'] = '移除';
$string['unlockaccount'] = '帳號解除封鎖';
$string['unsettheme'] = '取消佈景主題';
$string['unsupported'] = '不支援的';
$string['unsuspenduser'] = '啟動用戶帳號';
$string['updateaccounts'] = '更新現有帳號';
$string['updateautocheck'] = '自動檢查是否有更新的版本';
$string['updateautocheck_desc'] = '如果啟用，您的網站會自動檢查 Moodle 程式碼和所有外掛程式是否可更新。如果有新的更新版本可使用，會發送給網站管理員一個通知。';
$string['updateautodeploy'] = '啟用更新部署';
$string['updateautodeploy_desc'] = '若啟用，你將可以直接從Moodle管理頁面下載並安裝可用的更新。注意，你的伺服器處理必須有寫入Moodle安裝的資料夾的權限。這可以被視為一種安全性的潛在威脅。';
$string['updateavailable'] = '有一個新版本的 Moodle 可以更新！';
$string['updateavailabledetailslink'] = '去 {$a->url} 查看更多細節';
$string['updateavailableforplugin'] = '您的一些外掛有新版本可用！';
$string['updateavailableinstall'] = '安裝這一更新';
$string['updateavailable_moreinfo'] = '更多資訊...';
$string['updateavailablenot'] = '您的 Moodle 程式碼是最新的！';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = '版本 {$a}';
$string['updatecomponent'] = '更新元件';
$string['updateminmaturity'] = '程式碼成熟度需求';
$string['updateminmaturity_desc'] = '只有當可用語法至少達到選定的成熟度時，才通知有可用更新。不論此設定如何，沒有聲明語法成熟度的外掛總會被報告更新。';
$string['updatenotificationfooter'] = '您的 Moodle 的網站 {$a->siteurl} 設定為自動檢查可用的更新。做為網站管理員，您會收到此消息。您可以在網站設定版塊的管理部分裡禁用自動檢查可用更新。您可以在個人資料的設定部分裡的消息設定裡自訂此消息的發送方式。';
$string['updatenotifications'] = '更新通知';
$string['updatenotificationsubject'] = '有新的Moodle更新可用({$a->siteurl})';
$string['updatenotifybuilds'] = '有新版本時通知';
$string['updatenotifybuilds_desc'] = '如果啟用，當目前版本有新更新時，會報告 Moodle 語法有更新。更新是某個 Moodle 版本的持續改進。它們通常是每週發佈一次。如果停用，只有當更高版本的 Moodle 發佈時才會報告有可用的更新。外掛更新的檢查不受此設定影響。';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 包含一些用戶密碼和備份的安全修正，以保護網站中的用戶資料。因此您的一些設定和相關備份的權限可能被變更。 <br /><br />請參考<a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 release notes</a> 獲得詳細資訊。</p>';
$string['upgrade197noticesubject'] = 'Moodle 1.9.7 升級安全性提醒';
$string['upgrade197salt'] = '為減少密碼被偷竊的風險，強烈建議您設定一個密碼隨機種子.<br />詳細請參考 <a href="{$a}" target="_blank">password salting 文件</a>。';
$string['upgradeerror'] = '升級{$a->plugin}到版本{$a->version}時發生未知錯誤，無法繼續。';
$string['upgradeforumread'] = '在Moodle 1.5中增加了一項新的功能，它可以跟蹤討論區文章是否已經閱讀。<br />為了使用這個功能，您需要<a href="{$a}">升級您的資料庫表</a>。';
$string['upgradeforumreadinfo'] = '在Moodle 1.5中增加了一項新的功能，它可以追蹤討論區張貼的內容是否已經閱讀。為了使用這個功能，您需要升級您的資料表，為已經存在的討論區資料增加欄位。如果您的網站很大，這會花費很長的時間(數小時)，並且給資料庫伺服主機帶來很大負擔，因此最好在夜深人靜時再做這個工作。當然，在您的網站升級時，它還是可以繼續工作的，用戶不會受到任何影響。一旦您開始了這個工作，就必須讓它執行到結束(保持瀏覽器開啟著)。當然，如果您中途關閉了瀏覽器：不用擔心，重新開始就可以了。< br /><br />您現在要開始升級的程序嗎？';
$string['upgradelogs'] = '要獲得完整功能，您的舊日誌必須升級。<a href="{$a}">更多資訊</a>';
$string['upgradelogsinfo'] = '網站的變動記錄保存在日誌中.升級它以便查看最新的完整記錄。升級較大規模網站的日誌檔或許費時較長，耐心一些，升級過程中不要關閉瀏覽器--升級會順利的，它不會影響升級後使用者的使用<br /><br />您現在要升級日誌檔嗎?';
$string['upgradepluginsfirst'] = '建議您先安裝所有可用的更新。';
$string['upgradepluginsinfo'] = '更新外掛';
$string['upgradepluginsinfo_help'] = '您的某些外掛套件有更新版本。您應該在升級Moodle資料庫之前先安裝它們。
若您的網站不支援自動更新，您必須手動下載並在安裝新的外掛套件版本在您的伺服器上。';
$string['upgradesettings'] = '新設定';
$string['upgradesettingsintro'] = '下面顯示的設定項目是在剛剛升級 Moodle 後加入的，請做必要的調整後點選頁尾的&quot;儲存設定&quot;按鈕';
$string['upgradestalefiles'] = '檢測到混合Moodle的版本，無法繼續升級';
$string['upgradestalefilesinfo'] = 'Moodle 更新過程已暫停，因為在 Moodle 目錄內檢測到來自至少兩個 Moodle 主版本的 PHP 腳本。

這將可能引發重大問題。如果要繼續，您必須保證 Moodle 目錄只包含單一版本的 Moodle 檔案。

建議您採用如下方法清理您的 Moodle 目錄：

* 重命名目前的 Moodle 目錄為「moodle_old」

* 建立一個只包含來自標準 Moodle 下載軟體包、Moodle CVS 或 Git 倉儲的檔案的檔案夾

* 從「moodle_old」目錄移動 config.php 檔案和所有非標準外掛套件到新 Moodle 目錄

當您有了純淨的 Moodle 目錄，刷新頁面繼續 Moodle 更新執行程序。

這個警告通常是由解壓標準 Moodle 軟體包覆蓋到舊版本的 Moodle 所引發的。雖然這樣做小的升級是可以的，但是千萬不要用這方式進行主版本的升級。

這個警告也可能由使用 CVS、SVN 或 GIT 倉儲時的一次不完整的校驗或更新操作引發的。如果是這樣，您可能只需要等待操作完成，或者執行適當的清理命令並且重新執行原操作。

您可以在 <a href="{$a}">{$a}</a> 的升級檔案中找到更多資訊。';
$string['upgradestart'] = '現在升級Moodle資料庫';
$string['upgradesure'] = '<p>您的Moodle檔案已經被修改了，您將可自動升級您的伺服器到如下版本:</p>
<p><strong>{$a}</strong></p>
<p>一旦您執行了這個操作就無法再回到先前的版本了。請注意這個過程可能會花很長一段時間。</p>
<p>您確定要將伺服器升級到這個版本嗎？</p>';
$string['upgradetimedout'] = '升級過程逾時，請重新升級。';
$string['upgradingdata'] = '升級資料';
$string['upgradinglogs'] = '升級日誌中';
$string['upgradingversion'] = '正在升級到新版本';
$string['upwards'] = '以上';
$string['useblogassociations'] = '啟用關聯';
$string['useexternalyui'] = '使用線上YUI函數庫';
$string['user'] = '用戶';
$string['userbulk'] = '處理大量用戶';
$string['userlist'] = '瀏覽用戶清單';
$string['userpolicies'] = '用戶管理規則';
$string['userpreference'] = '用戶偏好設定';
$string['userquota'] = '用戶磁碟配額';
$string['users'] = '用戶';
$string['usesitenameforsitepages'] = '用網站名稱表示網站頁面';
$string['usetags'] = '啟用標籤功能';
$string['validateerror'] = '此值無效：';
$string['verifychangedemail'] = '當變更郵件信箱時也限制網域名稱';
$string['warningcurrentsetting'] = '目前的值無效：{$a}';
$string['warningiconvbuggy'] = '您的 iconv 庫不支援 //IGNORE 標識。您需要安裝 mbstring 延伸套件，來清理包含無效的 UTF-8 字元的字元串。';
$string['webproxy'] = 'Web 代理伺服器';
$string['webproxyinfo'] = '如果您的Moodle伺服器無法直接存取網際網路，請填寫下列選項。當下載環境資料、語言包、RSS摘要、時區等等，都需要存取網際網路。<br /><em>強烈建議PHP cURL延伸套件。</em>';
$string['xmlrpcrecommended'] = 'xmlrpc延伸套件對於hub伺服器通訊是必須要的，而且Web Service網站服務和Moodle Networking功能也會用到。';
$string['yuicomboloading'] = 'YUI組合載入中';
$string['ziprequired'] = 'Moodle現在需要Zip的PHP延伸套件，而info-ZIP和 PclZip函式庫已經不再被使用了。';
$string['zlibenabled'] = '已啟用 zlib';
