<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'sr_lt', branch 'MOODLE_24_STABLE'
 *
 * @package   local_amos
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '<p>AMOS je skraćenica za Automatizovanu manipulaciju stringovima (Automated Manipulation Of Strings). AMOS je centralni repozitorijum stringova za Moodle i njihove istorije. On prati dodavanje stringova na engleskom u programski kod Moodlea, prikuplja prevode, upravlja zajedničkim poslovima prevođenja i generiše jezičke pakete spremne za primenu na Moodle serverima.</p> <p>Više informacije pogledajte na stranici <a href="http://docs.moodle.org/en/AMOS">AMOS dokumentacija</a>.</p>';
$string['amos'] = 'AMOS - Moodle alat za prevođenje';
$string['amos:commit'] = 'Predaj radnu verziju prevedenih stringova u glavni repozitorijum';
$string['amos:execute'] = 'Izvrši dati AMOScript';
$string['amos:importfile'] = 'Uvezite stringove iz postavljene datoteke i prebacite ih u radnu verziju';
$string['amos:importstrings'] = 'Uvezite stringove (uključujući i engleske) direktno u glavni repozitorijum';
$string['amos:manage'] = 'Uredi AMOS portal';
$string['amos:stage'] = 'Koristi AMOS alat za prevođenje i unesi stringove u radnu verziju';
$string['amos:stash'] = 'Sačuvaj trenutnu radnu verziju u trajno sačuvane stringove';
$string['amos:usegoogle'] = 'Koristi Google servis za prevođenje';
$string['commitbutton'] = 'Predaj prevod i izbaci sve iz faze obrade';
$string['commitbutton2'] = 'Predaj prevod i ostavi stavke u fazi obrade';
$string['commitmessage'] = 'Poruka uz predati prevod';
$string['commitstage'] = 'Predaj radnu verziju prevedenih stringova';
$string['commitstage_help'] = 'Permanentno smešta sve prevedene stringove radne verzije u AMOS repozitorijum. Pre predaje automatski se uklanjaju stringovi koji se ne mogu predati kao i zastareli stringovi. Čuvaju se samo prevedeni stringovi koji se mogu predati. To znači da će biti predati samo oni stringovi koji su obeleženi zelenom bojom. Nakon predaje prevedenih stringova iz radne verzije se uklanjaju svi stringovi.';
$string['committableall'] = 'svi jezici';
$string['committablenone'] = 'nemate ovlašćenja ni nad jednim jezikom - molimo kontaktirajte AMOS administratora';
$string['componentsall'] = 'Sve';
$string['componentsenlarge'] = 'Uvećaj';
$string['componentsnone'] = 'Nijedna';
$string['componentsstandard'] = 'Standardne';
$string['confirmaction'] = 'Ova operacija se ne može poništiti. Jeste li sigurni?';
$string['contribaccept'] = 'Prihvati';
$string['contribactions'] = 'Akcije sa predatim prevodima';
$string['contribactions_help'] = 'Zavisno od vaših prava i toka obrade prevoda, na raspolaganju su vam sledeće akcije:

* Primeni - kopira u vašu radnu verziju sve prevedene stringove, ne menjajući ih
* Dodeli meni - postavlja vas kao osobu koja je odgovorna za pregled i integraciju poslatih prevoda
* Opozovi - ukida sve dodele  - prevod nikome nije dodeljen za pregled i proveru
* Započni pregled - dodeljuje vama nove prevode, podešava status na \'Na pregledu\' i kopira poslate prevode u vašu radnu verziju
* Prihvati - obeležava poslate prevode kao prihvaćene
* Odbij - obeležava poslate prevode kao odbijene. Molimo da u komentaru objasnite razloge odbijanja.

Prevodilac će biti obavešten e-poštom, kada dođe do promene statusa prevoda koje je poslao.';
$string['contribapply'] = 'Primeni';
$string['contribassignee'] = 'Zadužen/a';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'Dodeli meni';
$string['contribauthor'] = 'Autor';
$string['contribclosedno'] = 'Sakrij prihvaćene prevode';
$string['contribclosedyes'] = 'Prikaži prihvaćene prevode';
$string['contribcomponents'] = 'Komponente';
$string['contribid'] = 'Identifikator';
$string['contribincomingnone'] = 'Nema novih prevoda';
$string['contribincomingsome'] = 'Novi prevodi ({$a})';
$string['contriblanguage'] = 'Jezik';
$string['contribreject'] = 'Odbij';
$string['contribresign'] = 'Opozovi';
$string['contribstaged'] = 'Radna verzija prevoda <a href="contrib.php?id={$a->id}">#{$a->id}</a> autora: {$a->author}';
$string['contribstagedinfo'] = 'Radna verzija prevoda';
$string['contribstagedinfo_help'] = 'Radna verzija sadrži stringove koje su preveli članovi zajednice. Pretpostavlja se da su menadžeri jezičkih paketa pregledali prevode stringoga i potom im podesili im status na \'Prihvaćeno\' (ako su prevodi potvrđeni kao odgovarajući) ili \'Odbijeno\' (ako iz nekog razloga prevodi ne mogu da budu uključeni u zvanični jezički paket).';
$string['contribstartreview'] = 'Počni pregled';
$string['contribstatus'] = 'Status';
$string['contribstatus0'] = 'Novo';
$string['contribstatus10'] = 'Na pregledu';
$string['contribstatus20'] = 'Odbijeno';
$string['contribstatus30'] = 'Prihvaćeno';
$string['contribstatus_help'] = 'Tok obrade poslatih prevoda se sastoji od nekoliko stanja:

* Nov - prevedeni stringovi su poslati ali još nisu pregledani
* Na pregledu - prevedeni stringovi su dodeljeni menadžeru jezičkog paketa i prebačeni u radnu verziju radi pregleda
* Odbijen - menadžer jezičkog paketa je odbio poslate prevode i verovatno ostavio objašnjenje u komentaru
Prihvaćen - menadžer jezičkog paketa je prihvatio prevedene stringove';
$string['contribstrings'] = 'Stringovi';
$string['contribstringseq'] = 'novih stringova: {$a->orig}';
$string['contribstringsnone'] = '{$a->orig} (svi su već prevedeni u jezičкom paketu)';
$string['contribstringssome'] = '{$a->orig} (od kojih {$a->same} već ima noviji prevod)';
$string['contribsubject'] = 'Naslov';
$string['contribsubmittednone'] = 'Nema poslatih prevoda';
$string['contribsubmittedsome'] = 'Vaši prevodi ({$a})';
$string['contribtimemodified'] = 'Izmenjeno';
$string['contributions'] = 'Prevodi';
$string['creditscontact'] = 'Pošalji poruku';
$string['creditscontributors'] = 'Ostali saradnici';
$string['creditsmaintainedby'] = 'Održava';
$string['creditsnomaintainer'] = 'U ovo trenutku ne postoji menadžer jezičkog paketa. <a href="{$a->url}">Postanite jedan od njih!</a>';
$string['creditsthanks'] = 'Na ovoj stranici želimo da se zahvalimo svima koji su doprineli prevođenju Moodlea. Njihov rad je omogući da se Moodlea raširi svuda po svetu.';
$string['creditstitlelong'] = 'Menadžeri jezičkog paketa i saradnici';
$string['creditstitleshort'] = 'Zasluge';
$string['diff'] = 'Uporedi';
$string['diffaction'] = 'Ako je uočena razlika';
$string['diffaction1'] = 'Prebaci u radnu verziju oba prevoda njihovih grana';
$string['diffaction2'] = 'Prebaci u radnu verziju novije prevode obe grane';
$string['diffmode'] = 'Prebaci stringove u radnu verziju ako';
$string['diffmode1'] = 'Engleski stringovi su promenjeni ali ne i prevedeni';
$string['diffmode2'] = 'Engleski stringovi nisu promenjeni ali prevedeni jesu';
$string['diffmode3'] = 'Engleski ili prevedeni stringovi su promenjeni (ali ne i jedni i drugi)';
$string['diffmode4'] = 'I engleski ili prevedeni stringovi su promenjeni';
$string['diffprogress'] = 'Upoređivanje izabranih grana';
$string['diffprogressdone'] = 'Ukupan broj pronađenih razlika: {$a}';
$string['diffstaged'] = 'razlike';
$string['diffstrings'] = 'Uporedi stringove dve grane';
$string['diffstrings_help'] = 'Ovo će uporediti sve stringove dve izabrane grane. Ako postoji razlika u stringovima obe verzije će biti prebačene u radnu verziju. Nakon toga možete upotrebiti opciju "Uredi stringove radne verzije" kako biste pregledali i ispravili promene, prema potrebi.';
$string['diffversions'] = 'Verzije';
$string['emailacceptbody'] = 'Menadžer jezičkog paketa {$a->assignee} je prihvatio vaš prevod #{$a->id} {$a->subject}.

Za detaljnije informacije posetite {$a->url}';
$string['emailacceptsubject'] = '[AMOS prevod] Prihvaćeno';
$string['emailcontributionbody'] = 'Korisnik {$a->author} je predao novi prevod #{$a->id} {$a->subject}.

Za detaljnije informacije posetite: {$a->url}';
$string['emailcontributionsubject'] = '[AMOS prevod] Poslat je novi prevod';
$string['emailrejectbody'] = 'Menadžer jezičkog paketa {$a->assignee} je odbio Vaš prevod #{$a->id} {$a->subject}.

Za detaljnije informacije posetite {$a->url}';
$string['emailrejectsubject'] = '[AMOS prevod] Odbijeno';
$string['emailreviewbody'] = 'Menadžer jezičkog paketa {$a->assignee} je započeo pregled Vašeg prevoda #{$a->id} {$a->subject}.

Za detaljnije informacije posetite {$a->url}';
$string['emailreviewsubject'] = '[AMOS prevod] Pregled je započeo';
$string['err_exception'] = 'Greška: {$a}';
$string['err_invalidlangcode'] = 'Neispravan kôd jezika';
$string['err_parser'] = 'Greška prilikom parsiranja: {$a}';
$string['filtercmp'] = 'Komponente';
$string['filtercmp_desc'] = 'Prikaži stringove za ove komponente';
$string['filterlng'] = 'Jezici';
$string['filterlng_desc'] = 'Prikaži prevode za ove jezike';
$string['filtermis'] = 'Razno';
$string['filtermis_desc'] = 'Dodatni uslovi za prikaz stringova';
$string['filtermisfglo'] = 'samo nepotrebni stringovi';
$string['filtermisfhlp'] = 'samo stringovi pomoći';
$string['filtermisfmis'] = 'samo nedostajući i zastareli stringovi';
$string['filtermisfstg'] = 'samo stringovi iz radne verzije';
$string['filtermisfwog'] = 'bez nepotrebnih stringova';
$string['filtersid'] = 'Identifikator stringa';
$string['filtersid_desc'] = 'Ključ u nizu stringova';
$string['filtersidpartial'] = 'delimično poklapanje';
$string['filtertxt'] = 'Podstring';
$string['filtertxtcasesensitive'] = 'VELIKA i mala slova';
$string['filtertxt_desc'] = 'String mora da sadrži dati tekst';
$string['filtertxtregex'] = 'regularni izraz';
$string['filterver'] = 'Verzije';
$string['filterver_desc'] = 'Prikaži stringove iz ovih verzija Moodlea';
$string['found'] = 'Pronađeno: {$a->found} &nbsp;&nbsp;&nbsp; Nedostaje: {$a->missing} ({$a->missingonpage})';
$string['foundinfo'] = 'Broj pronađenih stringova';
$string['foundinfo_help'] = 'Prikazuje ukupan broj redova u tabeli prevoda, broj nedostajućih prevoda, kao i broj nedostajućih prevoda na tekućoj stranici';
$string['gotofirst'] = 'idi na prvu stranicu';
$string['gotoprevious'] = 'idi na prethodnu stranicu';
$string['greylisted'] = 'Nepotrebni stringovi';
$string['greylisted_help'] = 'Moodle jezički paket može da sadrži stringove koji nisu više u upotrebi, ali još uvek nisu obrisani. Ovi stringovi su označeni kao \'nepotrebni\' (\'greylisted\'). Jednom kada se potvrdi da se nepotrebni stringovi više ne koriste, biće uklonjeni iz jezičkog paketa.

Ukoliko uočite nepotreban string, koji se još uvek nalazi u Vašem jezičkom paketu Moodlea, molimо vas da nas o tome obavestite porukom na forumu u okviru kursa Translating Moodle, na ovom sajtu. Inače, uštedećete dragoceno vreme ako budete prevodili samo stringove koji se koriste, a ignorisati nepotrebne.';
$string['greylistedwarning'] = 'string je nepotreban';
$string['importfile'] = 'Uvezi prevedene stringove iz datoteke';
$string['importfile_help'] = 'Ukoliko ste svoje stringove preveli izvan AMOS-a pomoću ovog obrasca ih možete prebaciti u radnu verziju

* Datoteka mora biti ispravna Moodle PHP datoteka sa stringovima. Za primer pogledajte u direktorijum `/lang/en/` vaše Moodle instalacije.
*Ime datoteke mora da se podudara sa imenom iste datoteke sa stringovima engleskog jezičkog paketa za datu komponentu (npr. `moodle.php`, `assignment.php` ili `enrol_manual.php`).

Svi stringovi pronađeni u datoteci biće prebačeni u radnu verziju za izabranu verziju i jezik.

Višej PHP datoteka može biti obrađen odjednom ako ih spakujete u ZIP datoteku.';
$string['language'] = 'Jezik';
$string['languages'] = 'Jezici';
$string['languagesall'] = 'Svi';
$string['languagesnone'] = 'Nijedan';
$string['log'] = 'Zapis';
$string['logfilterbranch'] = 'Verzije';
$string['logfiltercommithash'] = 'git heš';
$string['logfiltercommitmsg'] = 'Poruka uz predati prevod sadrži';
$string['logfiltercommits'] = 'Filtriranje predatih stringova';
$string['logfiltercommittedafter'] = 'Potvrđeno posle';
$string['logfiltercommittedbefore'] = 'Potvrđeno pre';
$string['logfiltercomponent'] = 'Komponente';
$string['logfilterlang'] = 'Jezici';
$string['logfiltershow'] = 'Prikaži filtrirane potvrde i stringove';
$string['logfiltersource'] = 'Izvor';
$string['logfiltersourceamos'] = 'amos (Web alat za prevođenje)';
$string['logfiltersourceautomerge'] = 'automatsko spajanje (prevod kopirani iz druge grane)';
$string['logfiltersourcebot'] = 'bot (masivne operacije izvršene od strane skripta)';
$string['logfiltersourcecommitscript'] = 'commitscript (AMOScript u poruci prilikom predaje stringova)';
$string['logfiltersourcefixdrift'] = 'fixdrift (fixed AMOS-git drift)';
$string['logfiltersourcegit'] = 'git (git mirror Moodle izvornog kôda i 1.x paketa)';
$string['logfiltersourceimport'] = 'Uvezi (importovani stringovi za nestandardne dodatke)';
$string['logfiltersourcerevclean'] = 'revclean (obrnuti postupak čišćenja)';
$string['logfilterstringid'] = 'Identifikator stringa';
$string['logfilterstrings'] = 'Filter stringova';
$string['logfilterusergrp'] = 'Prevodilac';
$string['logfilterusergrpor'] = 'ili';
$string['maintainers'] = 'Menadžeri jezičkog paketa';
$string['markuptodate'] = 'Označavanje prevoda kao ažurnog';
$string['markuptodate_help'] = 'AMOS je otkrio da je ovaj string možda zastareo, pošto je engleska verzija izmenjena nakon što je string preveden. Pregledajte prevod i ukoliko smatrate da je ažuran kliknite na polje za potvrdu. U suprotnom, izmenite prevod.';
$string['merge'] = 'Integriši';
$string['mergestrings'] = 'Integriši stringove iz druge grane';
$string['mergestrings_help'] = 'Ovo će pokupiti sve stringove iz izvorne grane, koji još nisu prevedeni u ciljnoj grani i koriste se u njoj, a zatim ih prebaciti u radnu verziju. Ovu alatku možete koristiti kako biste kopirali prevedene stringove u sve druge verzije jezičkog paketa. Alatku mogu da koriste samo menadžeri jezičkih paketa.';
$string['newlanguage'] = 'Novi jezik';
$string['nodiffs'] = 'Nije pronađena nijedna razlika';
$string['nofiletoimport'] = 'Navedite datoteku za uvoz podataka.';
$string['nologsfound'] = 'Nijedan string nije pronađen, molimo promenite filtere';
$string['nostringsfound'] = 'Nijedan string nije pronađen';
$string['nostringsfoundonpage'] = 'Nijedan string nije pronađen na stranici {$a}';
$string['nostringtoimport'] = 'Nijedan ispravan string nije pronađen u datoteci. Proverite da li je ime datoteke ispravno i da li je pravilno formatirana.';
$string['nothingtomerge'] = 'Izvorna grana ne sadrži nijedan novi string koji bi nedostajao u ciljnoj grani. Nema stringova za integraciju.';
$string['nothingtostage'] = 'Operacija nije vratila nijedan string koji bi mogao da bude prebačen u radnu verziju';
$string['novalidzip'] = 'Nije moguće raspakovati ZIP datoteku';
$string['numofcommitsabovelimit'] = 'Pronađeno je {$a->found} predatih stringova koji se podudaraju sa filterom, koristeći {$a->limit} najnovijih';
$string['numofcommitsunderlimit'] = 'Pronađeno je {$a->found} predatih stringova koji se podudaraju sa filterom';
$string['numofmatchingstrings'] = 'U okviru ovoga, {$a->strings} izmene od {$a->commits} predatih stringova se podudara sa filterom stringova';
$string['outdatednotcommitted'] = 'Zastareli stringovi';
$string['outdatednotcommitted_help'] = 'AMOS je otkrio da je ovaj string možda zastareo, pošto je engleska verzija izmenjena nakon što je string preveden. Molimo, pregledajte prevod.';
$string['outdatednotcommittedwarning'] = 'zastarelo';
$string['ownstashactions'] = 'Akcije sa sačuvanim stringovima';
$string['ownstashactions_help'] = '* Primeni - kopira prevedene stringove iz sačuvanih stringova (stash) u radnu verziju (stage), ne menjajući pri tome  sačuvane strinove. Ako string već postoji u radnoj verziji, on će biti prepisan stringom koji se nalazi u sačuvanim stringovima.
* Primeni/Odbaci (Pop) - premešta prevedene stringove u radnu verziju i potpuno briše sve sačuvane stringovе (tj. istovremeno izvršava komande Primeni i Odbaci).
* Odbaci - odbacuje tj. briše sačuvane stringove.
* Pošalji - otvara obrazac za slanje sačuvanih stringova zvaničnim menadžerima  jezičkog paketa, tako da oni mogu da uključe Vaš prevod u zvanični jezički paket.';
$string['ownstashes'] = 'Vaši sačuvani stringovi';
$string['ownstashes_help'] = 'Ovo je spisak svih Vaših sačuvanih stringova';
$string['ownstashesnone'] = 'Nema Vaših sačuvanih stringova';
$string['permalink'] = 'permanentni link';
$string['placeholder'] = 'Varijable (rezervisana mesta)';
$string['placeholder_help'] = 'Varijable (rezervisana mesta) su specijalne oznake unutar stringa, poput `{$a}` ili `{$a->something}`. One se zamenjuju odgovarajućim vrednostima prilikom prikazivanja stringa.

Važno je da ove varijable budu kopirane tačno onako kako su navedene u originalnom, engleskom, stringu. Nemojte ih prevoditi niti menjati njihovu orijentaciju sleva-nadesno.';
$string['placeholderwarning'] = 'string sadrži promenljivu';
$string['pluginclasscore'] = 'Ključni podsistemi';
$string['pluginclassnonstandard'] = 'Nestandardni dodaci';
$string['pluginclassstandard'] = 'Standardni dodaci';
$string['pluginname'] = 'AMOS';
$string['presetcommitmessage'] = 'Prevod #{$a->id} autora: {$a->author}';
$string['presetcommitmessage2'] = 'Nedostajući stringovi iz {$a->source} su integrisani u {$a->target} granu';
$string['presetcommitmessage3'] = 'Ispravljanje razlika između {$a->versiona} i {$a->versionb}';
$string['privileges'] = 'Vaše privilegije';
$string['privilegesnone'] = 'Imate pravo samo da čitate javno dostupne informacije.';
$string['propagate'] = 'Propagiraj prevode';
$string['propagatednone'] = 'Nijedan prevod nije propagiran';
$string['propagatedsome'] = '{$a} prevoda radne verzije je propagirano';
$string['propagate_help'] = 'Prevodi radne verzije mogu da budu propagirani na izabrane grane jezičkog paketa. AMOS vrši iteraciju nad spiskom prevoda radne verzije i pokušava da ih primeni u svim izabranim granama. Propagacija nije moguća:

*ako  su engleski originali stringova različiti u izvornoj i odredišnoj grani jezičkog paketa
* ako je string ubačen u radnu verziju više puta sa različitim prevodom';
$string['propagaterun'] = 'Propagiraj';
$string['requestactions'] = 'Akcija';
$string['requestactions_help'] = '* Primeni - kopiraj prevedene stringove iz repozitorijuma (\'pull request\') u radnu verziju. Ako je string već u radnoj verziji, biće zamenjen kopijom iz sačuvanih stringova.
* Sakrij - blokira repozitorijum tako da Vam se on više neće prikazivati.';
$string['savefilter'] = 'Sačuvaj podešavanja filtera';
$string['script'] = 'AMOScript';
$string['scriptexecute'] = 'Izvrši i rezultat prebaci u radnu verziju';
$string['script_help'] = 'AMOScript predstavlja skup instrukcija koji se izvršava nad repozitorijumom stringova';
$string['sourceversion'] = 'Izvorna verzija';
$string['stage'] = 'Radna verzija';
$string['stageactions'] = 'Akcije sa radnom verzijom';
$string['stageactions_help'] = '* Uredi radnu verziju prevoda - menja podešavanja filtera prevoda tako da se prikazuju samo prevedeni stringovi radne verzije.
* Odbaci prevode koje se ne mogu predati - uklanja iz radne verzije sve prevedene stringove koje ne možete da predate. Pre predaje, iz radne verzije se automatski uklanjaju takvi stringovi.
* Ukloni zastarele prevode - uklanja iz radne verzije sve prevedene stringove koji, ili, ne menjaju tekući prevod, ili, su stariji od najnovijih prevoda u repozitorijumu.Pre predaje, iz radne verzije se automatski uklanjaju zastareli prevodi.
*Obriši sve prevode - uklanja iz radne verzije sve prevedene stringove';
$string['stageedit'] = 'Uredi stringove radne verzije';
$string['stagelang'] = 'Jezik';
$string['stageoriginal'] = 'Original';
$string['stageprune'] = 'Odbaci prevode koje se ne mogu predati';
$string['stagerebase'] = 'Ukloni zastarele prevode';
$string['stagestring'] = 'String';
$string['stagestringsnocommit'] = 'Broj prevedenih stringova u radnoj verziji: {$a->staged}';
$string['stagestringsnone'] = 'Nema prevedenih stringova u radnoj verziji';
$string['stagestringssome'] = 'Broj prevedenih stringova u radnoj verziji: {$a->staged}, od kojih {$a->committable} može biti predato';
$string['stagesubmit'] = 'Pošalji menadžeru jezičkog paketa';
$string['stagetranslation'] = 'Prevod';
$string['stagetranslation_help'] = 'Prikazuje prevedene stringove radne verzije koji će biti poslati. Boja pozadine ćelije znači:

* Zeleno - dodali ste prevod koji nedostaje i dozvoljeno Vam je da ga pošaljete.
* Žuto - izmenili ste string i dozvoljeno Vam je da pošaljete promene
* Plavo - promenili ste prevod ili dodali nedostajući ali Vam nije dozvoljeno da ih pošaljete u dati jezički paket.
* Bez boje - prevedeni string u radnoj verziji je isti kao već postojeći i zato neće biti poslat.';
$string['stageunstageall'] = 'Obriši sve prevode';
$string['stashactions'] = 'Akcije sa sačuvanim stringovima';
$string['stashactions_help'] = 'Deo AMOS-a \'Sačuvani stringovi\' (stash) predstavlja snimak tekuće radne verzije (stage). Sačuvani stringovi mogu biti poslati menadžeru zvaničnog jezičkog paketa za uključivanje u jezički paket.';
$string['stashapply'] = 'Primeni';
$string['stashautosave'] = 'Automatska rezervna kopija sačuvanih stringova';
$string['stashautosave_help'] = 'Ova kopija sačuvanih stringova (stash) sadrži najnoviji snimak radne verzije prevedenih stringova. Možete je koristiti kao rezervnu kopiju, npr. u slučaju kada greškom izgubite sve prevedene stringove radne verzije. Upotrebite komandu \'Primeni\' da biste kopirali sve sačuvane stringove u radnu verziju (ako u radnoj verziji već postoji prevod nekog stringa, on će biti zamenjen prevodom iz kopije sačuvanih stringova).';
$string['stashcomponents'] = '<span>Komponente:</span> {$a}';
$string['stashdrop'] = 'Odustani';
$string['stashes'] = 'Sačuvani stringovi';
$string['stashlanguages'] = '<span>Jezici:</span> {$a}';
$string['stashpop'] = 'Primeni/Odbaci (Pop)';
$string['stashpush'] = 'Prebaci sve stringove iz radne verzije među sačuvane stringove';
$string['stashstrings'] = '<span>Broj stringova:</span> {$a}';
$string['stashsubmit'] = 'Pošalji menadžeru jezičkog paketa';
$string['stashsubmitdetails'] = 'Detalji o poslatom prevodu';
$string['stashsubmitmessage'] = 'Poruka';
$string['stashsubmitsubject'] = 'Naslov';
$string['stashtitle'] = 'Naziv sačuvanih stringova';
$string['stashtitledefault'] = 'WIP - {$a->time}';
$string['stringhistory'] = 'Istorija';
$string['strings'] = 'Stringovi';
$string['submitting'] = 'Slanje prevoda';
$string['submitting_help'] = 'Ovo će prevedene stringove poslati zvaničnim menadžerima jezičkog paketa. Oni će moći Vaš prevod da prebace u svoje radne verzije, pregledaju ga i na kraju prihvate. Molimo da im prilikom slanja prevoda pošaljete i poruku u kojoj ćete opisati šta ste uradili i zašto biste želeli da stringovi koje ste preveli bude uključen u prevod.';
$string['targetversion'] = 'Ciljna verzija';
$string['translatorlang'] = 'Jezik';
$string['translatorlang_help'] = 'Prikazuje kod jezika na koji se string prevodi. Kliknite na znak (link) <strong>+-</strong>  kako biste videli istorijat prethodnih prevoda stringa.';
$string['translatororiginal'] = 'Original';
$string['translatororiginal_help'] = 'Prikazuje engleski original stringa. Ispod njega, možete da vidite link za prevod uz pomoć Google Translatora (pod uslovom da je jezik podržan i da je u vašem Web čitaču uključena pordrška za Javascript). Takođe, možete naći dodatne informacije, kao npr. da li string sadrži promenljivu (rezervisano mesto).';
$string['translatorstring'] = 'String';
$string['translatorstring_help'] = 'Prikazuje verziju Moodlea, identifikator stringa i komponentu kojoj taj string pripada.';
$string['translatortool'] = 'Alat za prevođenje';
$string['translatortranslation'] = 'Prevod';
$string['translatortranslation_help'] = 'Kliknite na ćeliju kako biste mogli da uređujete njen sadržaj. Unesite prevod i kliknite izvan ćelije da sačuvate prevod. Boja pozadine ćelije označava:

* Zeleno - string je već preveden, možete eventualno da izmenite prevod.
* Žuto - string je možda zastareo.. Engleska verzija je verovatno promenjena nakon što je string bio preveden.
* Crveno - string još nije preveden. * Plavo - promenili ste prevod i on je sada u radnoj verziji.
*Sivo - AMOS ne može da se koristi za prevod ovog stringa. Na primer, stringovi za Moodle  1.9 moraju da se uređuje samo preko CVS pristupa.

Menadžeri jezičkog paket mogu da vide mali crveni simbol u uglu ćelija čije sadržaje (prevode) mogu da potvrde.';
$string['typecontrib'] = 'Nestandardni dodaci';
$string['typecore'] = 'Ključni podsistemi';
$string['typestandard'] = 'Standardni dodaci';
$string['unstage'] = 'Ukloni iz radne verzije';
$string['unstageconfirm'] = 'Stvarno?';
$string['unstaging'] = 'Uklanjanje iz radne verzije';
$string['version'] = 'Verzija';
