<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   badges
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Akcije';
$string['activate'] = 'Omogući pristup';
$string['activatesuccess'] = 'Pristup bedževima je uspešno omogućen';
$string['addbadgecriteria'] = 'Dodaj kriterijum za bedž';
$string['addcourse'] = 'Dodaj kurseve';
$string['addcourse_help'] = 'Izaberite sve kurseve koji treba dodati u uslove za dobijanje ovog bedža. Držite taster CTRL da biste odabrali više kurseva.';
$string['addcriteria'] = 'Dodaj kriterijum';
$string['addcriteriatext'] = 'Da biste započeli dodavanje kriterijuma izaberite jednu od opcija iz padajućeg menija.';
$string['addtobackpack'] = 'Dodaj u album';
$string['adminonly'] = 'Ova stranica je ograničena samo na administratore sajta.';
$string['after'] = 'nakon datuma izdavanja.';
$string['aggregationmethod'] = 'Metod agregacije';
$string['all'] = 'Svi';
$string['allmethod'] = 'Svi izabrani uslovi si ispunjeni';
$string['allmethodactivity'] = 'Sve izabrani aktivnosti su završene';
$string['allmethodcourseset'] = 'Svi izabrani kursevi su završeni';
$string['allmethodmanual'] = 'Sve izabrane uloge dodeljuju bedž';
$string['allmethodprofile'] = 'Sva izabrana polja profila su kompletirana';
$string['allowcoursebadges'] = 'Omogući bedževe na kursu';
$string['allowcoursebadges_desc'] = 'Dozvolite da se bedževi kreiraju i dodeljuju u kontekstu kursa.';
$string['allowexternalbackpack'] = 'Omogući vezu sa spoljnim albumima';
$string['allowexternalbackpack_desc'] = 'Dozvolite korisnicima da podese vezu i prikažu bedževa sa svojih spoljnih albuma bedževa.

Napomena: Preporučuje se da ovu opciju ostavite isključenu ako veb sajtu ne može da se pristupi sa interneta (npr. zbog zaštitnog zida).';
$string['any'] = 'Bilo koja/e/i/u';
$string['anymethod'] = 'Bilo koji od izabranih uslova je ispunjen';
$string['anymethodactivity'] = 'Bilo koja od izabranih aktivnosti je završena';
$string['anymethodcourseset'] = 'Bilo koji od izabranih kurseva je završen';
$string['anymethodmanual'] = 'Bilo koja od izabranih uloga dodeljuje bedž';
$string['anymethodprofile'] = 'Bilo koje od izabranih polja profila je popunjeno.';
$string['attachment'] = 'Priloži bedž uz poruku';
$string['attachment_help'] = 'Ako je ova opcija omogućena, datoteka izdatog bedža biće priložena uz e-poruku dobitniku, kako bi on mogao da je preuzme. (da bi ova opcija mogla da se koristi, dodavanje datoteka uz e-poruke mora biti omogućeno u podešavanjima sajta – Administracija sajta > Dodaci > Izlazi poruka > Elektronska pošta).';
$string['award'] = 'Dodeli bedž';
$string['awardedtoyou'] = 'Bedževi izdati meni';
$string['awardoncron'] = 'Pristup bedžu je uspešno omogućen. Veliki broj korisnika može odmah osvojiti ovaj bedž. Da bi se osiguralo efikasno funkcionisanje sajta, biće potrebno neko vreme da ova akcija bude procesirana.';
$string['awards'] = 'Dobitnici bedža';
$string['backpackavailability'] = 'Provera eksternog bedža';
$string['backpackavailability_help'] = 'Kako bi dobitnici bedževa mogli da dokažu da su svoje bedževe dobili od vas, potrebno je da spoljni servis za album ima mogućnost pristupa vašem sajtu i proveri bedževa koje ste izdali.
Izgleda da vaš sajt trenutno nije dostupan, što znači da bedževi koje ste već izdali ili će tek biti izdati, ne mogu biti provereni.

**Zašto vidim ovu poruku?**

Postoji mogućnost da vaš zaštitni zid sprečava pristup korisnicima izvan vaše mreže, da je vaš sajt zaštićen lozinkom, ili da se sajt nalazi na računaru koji nije dostupan na internetu (kao što su lokalni računari koji služe za testiranje i razvoj).

**Da li ovo predstavlja problem?**

Ovaj problem treba rešiti na svakom produkcionom serveru/sajtu na kojem se planira izdavanje bedževa, inače dobitnici neće moći da dokažu da su dobili svoje bedževe od vas. Ako vaš sajt još nije aktivan, možete da kreirate i izdate probne bedževe dok je sajt dostupan, a pre nego što ga stavite u funkciju.

**Šta ako ne mogu čitav svoj sajt da učinim javno dostupnim?**

Jedina URL adresa koja je neophodna za proveru je [url-mog-sajta]/badges/assertion.php, tako da, ukoliko ste u mogućnosti da promenite podešavanja vašeg zaštitnog zida i omogućite pristup ovoj datoteci, provera bedževa će i dalje funkcionisati bez problema.';
$string['backpackbadges'] = 'Imate ukupno {$a->totalbadges} bedž(ev)a koji su prikazani u {$a->totalcollections} kolekcije/a, <a href="mybackpack.php">Promenite podešavanja albuma sa bedževima</a>.';
$string['backpackconnection'] = 'Veza sa albumom';
$string['backpackconnection_help'] = 'Ova stranica vam omogućava da podesite vezu sa spoljnim albumom bedževa. To dopušta da se na ovom sajtu prikažu spoljni bedževi, kao i da se bedževi ovde osvojeni prebace u vaš album.

Trenutno je podržan samo <a href="http://backpack.openbadges.org">Mozilla OpenBadges Backpack</a>. Potrebno je da otvorite nalog i prijavite se za album bedževa, pre nego što pokušate da podesite vezu sa njim na ovoj stranici.';
$string['backpackdetails'] = 'Podešavanja albuma bedževa';
$string['backpackemail'] = 'E-adresa';
$string['backpackemail_help'] = 'E-adresa povezana sa vašim albumom bedževa. Dok ste povezani, svi bedževi koji ste osvojili na ovom sajtu biće pridruženi uz ovu e-adresu.';
$string['backpackimport'] = 'Podešavanja za uvoz bedževa';
$string['backpackimport_help'] = 'Nakon što se veza sa albumom bedževa uspešno uspostavi, bedževi iz vašeg albuma mogu da se prikažu na stranici "Moji bedževi", kao i na stranici vašeg profila.

Ovde možete da izaberete kolekcije bedževa iz svog albuma koje želite da prikažete u svom profilu.';
$string['badgedetails'] = 'Podaci o bedžu';
$string['badgeimage'] = 'Slika';
$string['badgeimage_help'] = 'Ovo je slika koja će se koristiti kada se izda bedž.

Da biste dodali novu slike pronađite i izaberite sliku (u JPG ili PNG formatu), a zatim kliknite na "Sačuvaj promene". Slika će biti isečena u obliku kvadrata a njena veličina promenjena tako da odgovara zahtevima slike bedža.';
$string['badgeprivacysetting'] = 'Podešavanja privatnosti bedževa';
$string['badgeprivacysetting_help'] = 'Bedževi koje ste osvojili mogu biti prikazani na vašoj stranici profila. Ovo podešavanje vam omogućava da podesite vidljivost novoosvojenih bedževa.

Podešavanja privatnosti pojedinačnih bedževa i dalje možete da kontrolišete na svojoj stranici "Moji bedževi".';
$string['badgeprivacysetting_str'] = 'Automatski prikaži bedževe koje sam osvojio/la na stranici mog profila';
$string['badgesalt'] = 'Nasumični string (salt) za heširanje e-adresa dobitnika bedževa';
$string['badgesalt_desc'] = 'Korišćenje heš fukncije omogućava albumima da potvrde nosioce bedževa bez otkrivanja njihovih e-adresa. Ovo podešavanje treba da koristi samo brojeve i slova.

Napomena: Radi uspešne provere primalaca molimo izbegavajte izmene ovog podešavanja jednom kad ste počeli sa izdavanjem bedževa.';
$string['badgesdisabled'] = 'Bedževi nisu omogućeni na ovom sajtu';
$string['badgesearned'] = 'Broj osvojenih bedževa: {$a}';
$string['badgesettings'] = 'Podešavanja bedževa';
$string['badgestatus_0'] = 'Није доступан корисницима';
$string['badgestatus_1'] = 'Dostupan korisnicima';
$string['badgestatus_2'] = 'Nije dostupan korisnicima';
$string['badgestatus_3'] = 'Dostupan korisnicima';
$string['badgestatus_4'] = 'Arhiviran';
$string['badgestoearn'] = 'Broj dostupnih bedževa: {$a}';
$string['badgesview'] = 'Bedževi kursa';
$string['badgeurl'] = 'Link za izdati bedž';
$string['bawards'] = 'Dobitnici ({$a})';
$string['bcriteria'] = 'Kriterijum';
$string['bdetails'] = 'Uredi podatke';
$string['bmessage'] = 'Poruka';
$string['boverview'] = 'Pregled';
$string['bydate'] = 'završiti do';
$string['clearsettings'] = 'Ukloni podešavanja';
$string['completioninfo'] = 'Ovaj bedž je izdat za završetak:';
$string['completionnotenabled'] = 'Praćenje završetka nije omogućen za ovaj kurs, tako da on ne može biti uključen u kriterijume za dobijanje bedža.Praćenje završetka kursa može se omogućiti u podešavanjima kursa.';
$string['configenablebadges'] = 'Kada je omogućena, ova funkcija vam daje mogućnost da kreirate bedževe i da ih dodeljujete korisnicima sajta.';
$string['configuremessage'] = 'Poruka o bedžu';
$string['connect'] = 'Uspostavi vezu';
$string['connected'] = 'Veza uspostavljena';
$string['connecting'] = 'Povezivanje ...';
$string['contact'] = 'Kontakt';
$string['contact_help'] = 'E-adresa izdavača bedža.';
$string['copyof'] = 'Kopija {$a}';
$string['coursebadges'] = 'Bedževi';
$string['coursebadgesdisabled'] = 'Bedževi kursa nisu omogućeni na ovom sajtu.';
$string['coursecompletion'] = 'Studenti moraju da završe ovaj kurs.';
$string['create'] = 'Novi bedž';
$string['createbutton'] = 'Kreiraj bedž';
$string['creatorbody'] = '<p>{$a->user} je ispunio/la sve uslove i osvojio/la je bedž. Pogledajte izdati bedž na {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' je nagrađen/a!';
$string['criteria_0'] = 'Ovaj bedž se dodeljuje kada...';
$string['criteria_1'] = 'Završetak aktivnosti';
$string['criteria_1_help'] = 'Omogućava da bedž bude dodeljen korisnicima na osnovu završetka skupa aktivnosti u okviru kursa.';
$string['criteria_2'] = 'Ručno izdavanja od strane uloge';
$string['criteria_2_help'] = 'Omogućava da bedž bude ručno dodeljen korisnicima od strane korisnika sa odgovarajućom ulogom u okviru sajta ili kursa.';
$string['criteria_3'] = 'Društveno učešće';
$string['criteria_3_help'] = 'Društveno';
$string['criteria_4'] = 'Završetak kursa';
$string['criteria_4_help'] = 'Omogućava da bedž bude dodeljen korisnicima koji su završili kurs. Ovaj kriterijum može imati dodatne parametre, kao što su minimalna ocena i datum završetka kursa.';
$string['criteria_5'] = 'Završetak skupa kurseva';
$string['criteria_5_help'] = 'Omogućava da bedž bude dodeljen korisnicima koji su završili skup kurseva. Svaki kurs može imati dodatne parametre, kao što su minimalna ocena i datum završetka kursa.';
$string['criteria_6'] = 'Popunjavanje profila';
$string['criteria_6_help'] = 'Omogućava da bedž bude dodeljen korisnicima koji su popunili određena polja u svom profilu. Možete da izaberete standardna i prilagođena polja profila koja su dostupna korisnicima.';
$string['criteriacreated'] = 'Kriterijumi za bedž uspešno su kreirani';
$string['criteriadeleted'] = 'Kriterijumi za bedž uspešno su obrisani';
$string['criteria_descr'] = 'Studentima će ovaj bedž biti dodeljen kada ispune sledeći uslov:';
$string['criteria_descr_0'] = 'Studentima će ovaj bedž biti dodeljen kada ispune <strong>{$a}</strong> od navedenih uslova.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> od sledećih aktivnosti je završena:';
$string['criteria_descr_2'] = 'Ovaj bedž mora da bude dodeljen od strane korisnika koji ima <strong>{$a}</strong> od sledećih uloga:';
$string['criteria_descr_4'] = 'Studenti moraju da završe kurs';
$string['criteria_descr_5'] = '<strong>{$a}</strong> od sledećih kurseva mora da bude završen:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> od sledećih polja korisničkog profila mora da budu popunjena:';
$string['criteria_descr_bydate'] = 'do <em>{$a}</em>';
$string['criteria_descr_grade'] = 'sa minimalnom ocenom <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Završi <strong>{$a}</strong> od:';
$string['criteria_descr_short1'] = 'Završi <strong>{$a}</strong> od:';
$string['criteria_descr_short2'] = 'Bedž je dodelio <strong>{$a}</strong> od:';
$string['criteria_descr_short4'] = 'Završiti kurs';
$string['criteria_descr_short5'] = 'Završi <strong>{$a}</strong> od:';
$string['criteria_descr_short6'] = 'Završi <strong>{$a}</strong> od:';
$string['criteria_descr_single_1'] = 'Sledeća aktivnost mora biti završena:';
$string['criteria_descr_single_2'] = 'Ovaj bedž mora da dodeli korisnik sa sledećom ulogom:';
$string['criteria_descr_single_4'] = 'Studenti moraju da završe kurs';
$string['criteria_descr_single_5'] = 'Sledeći kurs mora da bude završen:';
$string['criteria_descr_single_6'] = 'Sledeći polje korisničkog profila mora da bude popunjeno:';
$string['criteria_descr_single_short1'] = 'Završiti:';
$string['criteria_descr_single_short2'] = 'Dodelio/la:';
$string['criteria_descr_single_short4'] = 'Završiti kurs';
$string['criteria_descr_single_short5'] = 'Završiti:';
$string['criteria_descr_single_short6'] = 'Završiti:';
$string['criteriasummary'] = 'Rezime kriterijuma';
$string['criteriaupdated'] = 'Kriterijumi za bedž uspešno su ažurirani';
$string['criterror'] = 'Trenutni parametri za izdavanje bedža';
$string['criterror_help'] = 'Ovaj skup polja prikazuje sve parametre koji su inicajlno dodati među uslove za ovaj bedž. Preporučuje se da isključite takve parametre kako bi osigurali da studenti mogu u budućnosti da dobiju ovaj bedž.';
$string['currentimage'] = 'Trenutna slika';
$string['currentstatus'] = 'Trenutni status:';
$string['dateawarded'] = 'Datum izdavanja';
$string['dateearned'] = 'Datum: {$a}';
$string['day'] = 'Dan(i)';
$string['deactivate'] = 'Onemogući pristup';
$string['deactivatesuccess'] = 'Pristup bedževima je uspešno onemogućen.';
$string['defaultissuercontact'] = 'Podrazumevani kontakt podaci o izdavaču bedža';
$string['defaultissuercontact_desc'] = 'E-adresa izdavača bedža.';
$string['defaultissuername'] = 'Podrazumevano ime/naziv izdavača bedža';
$string['defaultissuername_desc'] = 'Ime osobe nadležne za izdavanje bedževa.';
$string['delbadge'] = 'Obriši bedž';
$string['delconfirm'] = 'Da li ste sigurni da želite da obrišete \'{$a}\'?';
$string['delcritconfirm'] = 'Da li ste sigurni da želite da obrišete ovaj kriterijum?';
$string['delparamconfirm'] = 'Da li ste sigurni da želite da obrišete ovaj parametar?';
$string['description'] = 'Opis';
$string['disconnect'] = 'Prekini vezu';
$string['donotaward'] = 'Trenutno, ovaj bedž nije aktivan, tako da ne može biti dodeljen studentima. Ako želite da dodelite ovaj bedž aktivirajte njegov status.';
$string['editsettings'] = 'Uredi podešavanja';
$string['enablebadges'] = 'Omogući bedževe';
$string['error:backpackdatainvalid'] = 'Podaci dobijeni od albuma bedževa bili su neispravni';
$string['error:backpackemailnotfound'] = 'E-adresa \'{$a}\' nije povezana sa albumom bedževa. Potrebno je da <a href="http://backpack.openbadges.org">kreirate album</a> za taj nalog ili da se prijavite sa drugom e-adresom.';
$string['error:backpackloginfailed'] = 'Niste mogli biti povezani sa spoljnim albumom bedževa iz sledećeg razloga: {$a}';
$string['error:backpacknotavailable'] = 'Vaš sajt nije dostupan sa interneta, tako da nijedan bedž izdat na ovom sajtu ne može da bude proveren od strane spoljnih albuma bedževa.';
$string['error:backpackproblem'] = 'Došlo je do problema u povezivanju sa Vašim pružaocem usluga. Molimo pokušajte kasnije.';
$string['error:badjson'] = 'Pokušaj uspostavljanja veze je vratio neispravne podatke.';
$string['error:cannotact'] = 'Nije moguće aktivirati bedž.';
$string['error:cannotawardbadge'] = 'Nije moguće dodeliti bedž korisniku';
$string['error:clone'] = 'Nije moguće klonirati bedž.';
$string['error:connectionunknownreason'] = 'Povezivanje je bilo neuspešno iz nepoznatog razloga';
$string['error:duplicatename'] = 'Bedž sa takvim nazivom već postoji u sistemu';
$string['error:externalbadgedoesntexist'] = 'Bedž nije pronađen';
$string['error:guestuseraccess'] = 'Trenutno pristupate sistemu kao gost. Da biste videli bedževe potrebno ja da se prijavite pomoću svog korisničkog naloga..';
$string['error:invalidbadgeurl'] = 'Neispravan format URL adrese izdavača bedža.';
$string['error:invalidcriteriatype'] = 'Nevažeći tip kriterijum';
$string['error:invalidexpiredate'] = 'Datum isteka mora da bude u budućnosti.';
$string['error:invalidexpireperiod'] = 'Datum isteka ne može biti negativan ili jednak 0.';
$string['error:noactivities'] = 'Na ovom kursu ne postoje aktivnosti sa omogućenim kriterijumom za završetak.';
$string['error:noassertion'] = 'Od sistem za proveru identiteta Persona nije dobijena nikakva potvrda. Možda ste zatvorili okvir za dijalog pre nego što se proces prijavljivanja završio.';
$string['error:nocourses'] = 'Praćenje završetka kursa nije omogućeno ni za jedan od kurseva na ovom sajtu, tako da nema kursa koji bi mogao biti prikazan. Praćenje završetka kursa može se omogućiti u podešavanjima kursa.';
$string['error:nogroups'] = '<p>U vašem albumu nema dostupnih javnih kolekcija bedževa </p>
<p>Prikazane su samo javne kolekcije. <a href="http://backpack.openbadges.org">Posetite svoj album</a> kako biste kreirali javne kolekcije bedževa.</p>';
$string['error:nopermissiontoview'] = 'Nemate dozvolu da vidite dobitnike bedževa';
$string['error:nosuchbadge'] = 'Bedž sa id brojem {$a} ne postoji.';
$string['error:nosuchcourse'] = 'Upozorenje! Ova aktivnost više nije dostupna.';
$string['error:nosuchfield'] = 'Upozorenje! Ovo korisničko polje više nije dostupno.';
$string['error:nosuchmod'] = 'Upozorenje! Ova aktivnost više nije dostupna.';
$string['error:nosuchrole'] = 'Upozorenje! Ova uloga više nije dostupna.';
$string['error:nosuchuser'] = 'Korisnik sa ovom e-adresom nema nalog kod tekućeg provajdera albuma bedževa.';
$string['error:notifycoursedate'] = 'Upozorenje! Bedževi povezani sa  završetkom kursa i aktivnosti neće biti izdati do datuma početka kursa.';
$string['error:parameter'] = 'Upozorenje: Najmanje jedan parametar treba da bude izabran kako bi se obezbedio ispravan proces izdavanja bedževa.';
$string['error:personaneedsjs'] = 'Trenutno, Javascript je neophodan za povezivanje sa vašim albumom bedževa. Ako možete, omogućite Javascript i ponovo učitajte stranicu.';
$string['error:requesterror'] = 'Zahtev za uspostavu veze nije uspeo (kôd greške {$a}).';
$string['error:requesttimeout'] = 'Zahtev za uspostavu veze je istekao pre nego što je mogao da se završi.';
$string['error:save'] = 'Nije moguće sačuvati bedž.';
$string['error:userdeleted'] = '{$a->user} (Ovaj korisnik više ne postoji na sajtu {$a->site})';
$string['evidence'] = 'Dokaz';
$string['existingrecipients'] = 'Postojeći dobitnici bedža';
$string['expired'] = 'Isteklo';
$string['expiredate'] = 'Ovaj bedž ističe {$a}.';
$string['expireddate'] = 'Ovaj bedž je istekao {$a}.';
$string['expireperiod'] = 'Ovaj bedž ističe {$a} dan(a) nakon što je izdat.';
$string['expireperiodh'] = 'Ovaj bedž ističe {$a} čas(ov)a nakon što je izdat.';
$string['expireperiodm'] = 'Ovaj bedž ističe {$a} minut(a) nakon što je izdat.';
$string['expireperiods'] = 'Ovaj bedž ističe {$a} sekundu/e/i nakon što je izdat.';
$string['expirydate'] = 'Datum isteka';
$string['expirydate_help'] = 'Opciono, bedževi mogu isteći određenog datuma, ili se datum može izračunati na osnovu datuma kada je bedž izdat korisniku.';
$string['externalbadges'] = 'Moji bedževi sa drugih sajtova';
$string['externalbadges_help'] = 'Ovde su prikazani bedževi uz vaših spoljnih albuma.';
$string['externalbadgesp'] = 'Bedževi sa drugih sajtova';
$string['externalconnectto'] = 'Da biste prikazali spoljne bedževe potrebno je da <a href="{$a}">uspostavite vezu sa albumom</a>.';
$string['fixed'] = 'Fiksni datum';
$string['hidden'] = 'Skriveno';
$string['hiddenbadge'] = 'Nažalost, vlasnik bedža nije učinio ove informacije dostupnim.';
$string['issuancedetails'] = 'Bedž ističe';
$string['issuedbadge'] = 'Informacije o izdataom bedžu';
$string['issuerdetails'] = 'Podaci o izdavaču';
$string['issuername'] = 'Ime/naziv izdavača bedža';
$string['issuername_help'] = 'Ime osobe/naziv institucije nadležne za izdavanje bedževa.';
$string['issuerurl'] = 'URL adresa izdavača';
$string['localbadges'] = 'Moji bedževi sa veb sajta {$a}';
$string['localbadgesh'] = 'Moji bedževi sa ovoga sajta';
$string['localbadgesh_help'] = 'Svi bedževi u okviru ovog sajta, dobijeni na osnovu završetka kurseva i aktivnosti unutar kurseva, kao i ispunjavanjem drugih uslova.

Ovde možete upravljati svojim bedževima tako što ćete ih učiniti javnim ili privatnim za svoj stranicu profila.

Možete da preuzmete sve svoje bedževe ili svaki bedž zasebno, i sačuvate ih na svom kompjuteru. Preuzete bedževi možete da dodajete u svoje spoljne albume bedževa.';
$string['localbadgesp'] = 'Bedževi sa {$a}:';
$string['localconnectto'] = 'Da biste delili bedževe van ovog sajta potrebno je da <a href="{$a}">uspostavite vezu sa albumom</a>.';
$string['makeprivate'] = 'Učini privatnim';
$string['makepublic'] = 'Učini javnim';
$string['managebadges'] = 'Upravljanje bedževima';
$string['message'] = 'Telo poruke';
$string['messagebody'] = '<p>Dodeljen vam je bedž "%badgename%"!</p>
<p>Više informacija o ovom bedžu možete naći na %badgelink%.</p>
<p>Bedž možete preuzeti sa stranice {$a}.</p>';
$string['messagesubject'] = 'Čestitamo! Osvojili ste bedž!';
$string['method'] = 'Ovaj kriterijum je ispunjen kada...';
$string['mingrade'] = 'Neophodna je minimalna ocena';
$string['month'] = 'Mesec(i)';
$string['mybackpack'] = 'Podešavanja mog albuma bedževa';
$string['mybadges'] = 'Moji bedževi';
$string['never'] = 'Nikad';
$string['newbadge'] = 'Dodaj novi bedž';
$string['newimage'] = 'Nova slika';
$string['noawards'] = 'Ovaj bedž još niko nije dobio.';
$string['nobackpack'] = 'Ne postoji album bedževa koji je povezan sa ovim nalogom.<br/>';
$string['nobackpackbadges'] = 'Ne postoje bedževi u kolekciji koju ste izrabrali. <a href="mybackpack.php">Dodaj još kolekcija</a>.';
$string['nobackpackcollections'] = 'Nije izabrana nijedna kolekcija bedževa. <a href="mybackpack.php">Dodaj kolekcije</a>.';
$string['nobadges'] = 'Nema dostupnih bedževa';
$string['nocriteria'] = 'Kriterijumi za ovaj bedž još nisu podešeni';
$string['noexpiry'] = 'Ovaj bedž nema datum isteka';
$string['noparamstoadd'] = 'Nema dodatnih parametara dostupnih za dodavanje uslova za dobijanje ovog bedža';
$string['notacceptedrole'] = 'Vaša trenutna uloga se ne nalazi među ulogama koje mogu ručno da izdaju ovaj bedž.<br/>
Ako želite da vidite korisnike koji su već osvojili ovaj bedž , možete da posetite stranicu {$a}.';
$string['notconnected'] = 'Veza nije uspostavljena';
$string['nothingtoadd'] = 'Ne postoje dostupni kriterijumi za dodavanje.';
$string['notification'] = 'Obavesti kreatora bedža';
$string['notification_help'] = 'Ovo podešavanje upravlja obaveštenjima koja se šalju kreatorima bedževa kako bi znali da je bedž izdata.

Dostupne su sledeće opcije:

* **NIKAD** – Obaveštenja se ne šalju.

* **SVAKI PUT** – Obaveštenje se šalje svaki puta kada je bedž dodeljen.

* **DNEVNO** – Obaveštenje se šalje jednom dnevno.

* **SEDMIČNO** – Obaveštenje se šalje jednom sedmično.

* **MESEČNO** – Obaveštenje se šalje jednom mesečno.';
$string['notifydaily'] = 'Dnevno';
$string['notifyevery'] = 'Svaki put';
$string['notifymonthly'] = 'Mesečno';
$string['notifyweekly'] = 'Sedmično';
$string['numawards'] = 'Broj korisnika kojima je izdat ovaj bedž: <a href="{$a->link}">{$a->count}</a>..';
$string['numawardstat'] = 'Broj korisnika kojima je izdat ovaj bedž: {$a}';
$string['overallcrit'] = 'od izabranih kriterijuma su ispunjeni';
$string['personaconnection'] = 'Prijavite se sa svojom e-adresom';
$string['personaconnection_help'] = 'Persona je sistem koji vam omogućava da se identifikujete širom internete, pomoću adrese e-pošte koju koristite. Album Otvorenih Bedževa (Open Badges backpack) koristi sistem Persona kao sistem za prijavljivanje, tako da možete da povežete album koji vam je potreban sa Persona nalogom.

Za više informacija o sistemu Persona pogledajte na <a href="https://login.persona.org/about">https://login.persona.org/about</a>.';
$string['potentialrecipients'] = 'Potencijalni dobitnici bedževa';
$string['recipientdetails'] = 'Detalji o primaocu';
$string['recipientidentificationproblem'] = 'Nije moguće naći primaoca ovog bedža među postojećim korisnicima.';
$string['recipients'] = 'Dobitnici bedža';
$string['recipientvalidationproblem'] = 'Trenutni korisnik ne može biti potvrđen kao primalac ovog bedža.';
$string['relative'] = 'Relativni datum';
$string['requiredcourse'] = 'Najmanje jedan kurs treba dodati u kriterijum za skup kurseva.';
$string['reviewbadge'] = 'Promene u pristup bedžu';
$string['reviewconfirm'] = '<p>Ovo će učiniti da vaš bedž bude vidljiv korisnicima i omogućiti im da ga osvoje.</p>

<p>Postoji mogućnost da neki korisnici već ispunjavaju kriterijume za dobijanje ovog bedža. Njima će bedž biti dodeljen odmah nakon što ga učinite dostupnim.</p>

<p>Jednom kada je bedž dodeljen on će biti <strong>zaključan</strong> - određena podešavanja, uključujući kriterijume i vreme isteka, više neće moći da se menjaju.</p>

<p>Da li ste sigutni da želite da omogućite pristup bedžu \'{$a}\'?</p>';
$string['save'] = 'Sačuvaj';
$string['searchname'] = 'Pretraži po imenu';
$string['selectaward'] = 'Izaberite ulogu koju želite da koristite za dodeljivanje ovog bedža:';
$string['selectgroup_end'] = 'Prikazna se u samo javne kolekkcije. <a href="http://backpack.openbadges.org">Posetite svoj album</a> kako biste kreirali javne kolekcije bedževa.';
$string['selectgroup_start'] = 'Izaberite kolekcije bedževa iz svog albuma za prikaz na ovom sajtu:';
$string['selecting'] = 'Sa izabranim bedževima...';
$string['setup'] = 'Podesi vezu';
$string['signinwithyouremail'] = 'Prijavite se sa svojom e-adresom';
$string['sitebadges'] = 'Bedževi sajta';
$string['sitebadges_help'] = 'Bedževi na nivou sajta se mogu dodeliti korisnicima samo za aktivnosti koji su vezi sa sajtom. Ovo uključuje završetak skupa kurseva ili delova korisničkih profila. Bedževi sajta mogu se, takođe, ručno dodeliti od strane jednog korisnika drugom korisniku.

Bedževi za kurseve moraju da se kreiraju na nivou kursa. Bedževi kursa mogu da se pronađu pod Administracija kursa> Bedževi.';
$string['status'] = 'Status bedža';
$string['status_help'] = 'Status bedža određuje njegova ponašanje u sistemu

* **DOSTUPAN** – znači da korisnici mogu da zarade ovaj bedž. Dok je bedž dostupan korisnicima, kriterijum za njegovo dobijanje ne mogu da se menjaju.

* **NIJE DOSTUPAN** – znači da bedž nije dostupan korisnicima i da ne može biti dobijen ili ručno dodeljen. Ako ovaj bedž prethodno uopšte nije izdavan, kriterijumi za njegovo dobijanje mogu da se menjaju.

Jednom kada je bedž dodeljen barem jednom korisniku, on automatski postaje **ZAKLjUČAN**. Korisnici i dalje mogu dobijaju zaključane bedževe, ali kriterijumi za dobijanje tih bedževa više ne mogu da se menjaju. Ako želite da menjate podatke ili kriterijume zaključanog bedža, možete napraviti njegovu kopiju i uneti sve neophodne promene.

*Zašto zaključavamo bedževe?*

Želimo da se uverimo da su svi korisnici ispunili iste uslove za dobijanje bedža. Trenutno, nije moguće da se bedž opozove. Ukoliko bismo dozvolili da se uslovi za dobijanje bedža menjaju u svakom trenutku, to bi na kraju, najverovatnije, dovelo do toga da imamo korisnike koji su isti bedž dobili za ispunjavanje potpuno različitih uslova.';
$string['statusmessage_0'] = 'Ovaj bedž trenutno nije dostupan korisnicima. Omogućite pristuo ako želite da korisnici osvoje ovaj bedž.';
$string['statusmessage_1'] = 'Ovaj bedž je trenutno dostupan korisnicima. Onemogućite pristup kako biste napravili promene.';
$string['statusmessage_2'] = 'Ovaj bedž trenutno nije dostupan korisnicima. a njegovi kriterijum su zaključani. Omogućite pristup ako želite da korisnici osvoje ovaj bedž.';
$string['statusmessage_3'] = 'Ovaj bedž je trenutno dostupan korisnicima, a njegovi kriterijumi su zaključani.';
$string['statusmessage_4'] = 'Ovaj bedž je trenutno arhiviran.';
$string['subject'] = 'Tema poruke';
$string['variablesubstitution'] = 'Zamena promenljivih u porukama.';
$string['variablesubstitution_help'] = 'U poruku o bedžu, mogu da se ubace određene promenljive u temu i/ili telo poruke, tako da, kada se šalje poruka, promenljive budu zamenjene sa realnim vrednostima. Promenljive treba ubaciti u tekst tačno onako kako je dole prikazano. Mogu se koristiti sledeće promenljive:

%badgename%
: Ovo će biti zamenjeno punim nazivom bedža.

%username%
: Ovo će biti zamenjeno imenom i prezimenom dobitnika bedža.

%badgelink%
: Ovo će biti zamenjeno javnom URL adresom sa informacijama o izdatom bedžu.';
$string['viewbadge'] = 'Pogledaj izdate bedževe';
$string['visible'] = 'Vidljivo';
$string['warnexpired'] = '(Ovaj bedž je istekao!)';
$string['year'] = 'Godina(e)';
