<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assignment', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   assignment
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Imate zadatke na koje treba obratiti pažnju';
$string['addsubmission'] = 'Dodaj rad';
$string['allowdeleting'] = 'Dozvoli brisanje';
$string['allowdeleting_help'] = 'Ako je ova opcija omogućena, polaznici mogu da brišu postavljene datoteke u bilo kom trenutku, pre nego što predaju rad za ocenjivanje..';
$string['allowmaxfiles'] = 'Maksimalan broj postavljenih datoteka';
$string['allowmaxfiles_help'] = 'Maksimalan broj datoteka koji može biti postavljen. Kako se ovaj broj nigde ne prikazuje polaznicima, potrebno je da u opisu zadatka obavezno navedete ovaj broj, kako bi polaznici znali koliko datoteka mogu da postave.';
$string['allownotes'] = 'Dozvoli beleške';
$string['allownotes_help'] = 'Ako je ova opcija omogućena, polaznici će moći da unose beleške u za to predviđeno polje za unos teksta, slično kao kod zadatka tipa \'Onlajn tekst\'.';
$string['allowresubmit'] = 'Dozvoli ponovno predavanje rada';
$string['allowresubmit_help'] = 'Ako je ova opcija omogućena, polaznicima će biti dozvoljeno da ponovo predaju svoje radove nakon što su prethodne verzije već ocenjene (kako bi ih nastavnik ponovo ocenio).';
$string['alreadygraded'] = 'Vaš zadatak je već ocenjen i ponovno rešavanje zadatka nije dozvoljeno.';
$string['assignment:addinstance'] = 'Dodaj novi zadatak';
$string['assignmentdetails'] = 'Detalji zadatka';
$string['assignment:exportownsubmission'] = 'Izvoz sopstvenog rada';
$string['assignment:exportsubmission'] = 'Izvezi rad';
$string['assignment:grade'] = 'Oceni zadatak';
$string['assignmentmail'] = '{$a->teacher} je poslao/la povratne informacije na rad koji ste predali za zadatka \'{$a->assignment}\'.

Povratne informacije su pridružene vašem radu i možete ih pogledati na:

    {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->teacher} je poslao/la povratne informacije na rad koji ste predali za zadatka \'<i>{$a->assignment}</i>\'. </p>

</p>Povratne informacije možete pogledati pridružene vašem <a href="{$a->url}">radu</a>.</p>';
$string['assignmentmailsmall'] = '{$a->teacher} je poslao/la povratne informacije na rad koji ste predali za zadatka \'{$a->assignment}\'. Povratne informacije možete videti pridružene vašem radu.';
$string['assignmentname'] = 'Naziv zadatka';
$string['assignmentsubmission'] = 'Predati radovi';
$string['assignment:submit'] = 'Predaj zadatak';
$string['assignmenttype'] = 'Tip zadatka';
$string['assignment:view'] = 'Pregledaj zadatak';
$string['availabledate'] = 'Dostupan od';
$string['cannotdeletefiles'] = 'Došlo je do greške i datoteke se ne mogu obrisati.';
$string['cannotviewassignment'] = 'Ne možete pregledati ovaj zadatak';
$string['changegradewarning'] = 'Ovaj zadatak sadrži ocenjene predate radove pa promena ocene neće automatski ponovo izračunati postojeće ocene radova. Morate ponovo oceniti sve postojeće radove ako želite da promenite ocenu.';
$string['closedassignment'] = 'Ovaj zadatak je zatvoren, pošto je prošao krajnji rok za predaju.';
$string['comment'] = 'Komentar';
$string['commentinline'] = 'Komentar unutar zadatka';
$string['commentinline_help'] = 'Ako je ova opcija omogućena, predati tekst rada će, prilikom ocenjivanja, biti kopiran u polje za povratne informacije, kako bi nastavnik mogao lakše da ga komentariše (korišćenjem različite boje, na primer) ili da uređuje originalni tekst.';
$string['configitemstocount'] = 'Vrsta priloga koji će se priznavati kao radovi polaznika u onlajn zadacima.';
$string['configmaxbytes'] = 'Podrazumevana maksimalna veličina za sve zadatke na sajtu (vezano za ograničenje kursa i ostala lokalna podešavanja)';
$string['configshowrecentsubmissions'] = 'Svi mogu da vide obaveštenje o predatim radovima u izveštaju o skorašnjim aktivnostima.';
$string['confirmdeletefile'] = 'Da li ste potpuno sigurni da želite da obrišete ovu datoteku?<br /><strong>{$a}</strong>';
$string['coursemisconf'] = 'Kurs nije ispravno podešen';
$string['currentgrade'] = 'Trenutna ocena u knjizi ocena';
$string['deleteallsubmissions'] = 'Obriši sva predata radove';
$string['deletefilefailed'] = 'Brisanje datoteke nije uspelo.';
$string['description'] = 'Opis';
$string['downloadall'] = 'Preuzmi sve zadatke kao zip arhivu';
$string['draft'] = 'Nacrt';
$string['due'] = 'Rok za predaju zadatka';
$string['duedate'] = 'Krajnji rok';
$string['duedateno'] = 'Nema krajnjeg roka';
$string['early'] = '{$a} ranije';
$string['editmysubmission'] = 'Izmeni moj rad';
$string['editthesefiles'] = 'Uredi ove datoteke';
$string['editthisfile'] = 'Ažuriraj ovu datoteku';
$string['emailstudents'] = 'Slanje upozorenja polaznicima elektronskom poštom';
$string['emailteachermail'] = '{$a->username} je ažurirao/la svoj rad za zadatka \'{$a->assignment}\' u  {$a->timeupdated}

Rad je dostupno na sledećoj adresi:

{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} je ažurirao/la svoj rad za zadatak <i>\'{$a->assignment}\' u  {$a->timeupdated}</i> </p>
<p>Rad je <a href="{$a->url}">dostupan na sajtu</a>.</p>';
$string['emailteachers'] = 'Slanje upozorenja predavačima elektronskom poštom';
$string['emailteachers_help'] = 'Ako je ova opcija omogućena, kad god polaznik preda ili ažurira svoj rad, nastavnici će biti obavešteni elektronskom porukom.

Samo nastavnici koji mogu da ocenjuju konkretan zadatak će dobiti ovo obaveštenje. Tako na primer, ako se kurs realizuje za odvojene grupe, nastavnici zaduženi za konkretne grupe neće primati nikakva obaveštenja o polaznicima iz drugih grupa.';
$string['emptysubmission'] = 'Još uvek niste ništa predali';
$string['enablenotification'] = 'Pošalji obaveštenje';
$string['enablenotification_help'] = 'Ako je ova opcija omogućena polaznici će dobijati obaveštenje elektronskom poštom kada njihovi radovi bude ocenjeni.';
$string['errornosubmissions'] = 'Nema predatih radova za preuzimanje';
$string['existingfiledeleted'] = 'Postojeća datoteka je obrisana: {$a}';
$string['failedupdatefeedback'] = 'Ažuriranje povratnih informacija za korisnika {$a} nije uspelo.';
$string['feedback'] = 'Povratne informacije';
$string['feedbackfromteacher'] = 'Povratne informacije koje je poslao/la {$a}';
$string['feedbackupdated'] = 'Povratne informacije su ažurirane za {$a} korisnika';
$string['finalize'] = 'Spreči ažuriranje zadatka';
$string['finalizeerror'] = 'Došlo je do greške i taj rad nije moguće dovršiti';
$string['futureaassignment'] = 'Ovaj zadatak još uvek nije dostupan.';
$string['graded'] = 'Ocenjeno';
$string['guestnosubmit'] = 'Žao nam je, ali gostima nije dozvoljeno da predaju svoj rad. Morate se registrovati/prijaviti kao registrovani korisnik da biste predali svoj rad.';
$string['guestnoupload'] = 'Žao nam je, ali gostima nije dozvoljeno da postavljaju datoteke';
$string['helpoffline'] = '<p>Ovaj tip zadatka je koristan kada se radi izvan Moodlea. To može biti negde drugo na vebu ili u učionici.</p><p>Polaznici mogu da vide opis zadatka, ali ne mogu da postavljaju datoteke ili bilo šta drugo. Ocenjivanje funkcioniše potpuno normalno, i polaznici će dobiti obaveštenje o svojim ocenama.</p>';
$string['helponline'] = '<p>Ovaj tip zadatka traži od korisnika da napišu tekst koristeći običan editor teksta. Predavači mogu ne samo da ocenjuju zadatke, onlajn, već i da dodaju svoje komentare unutar samog teksta ili da ga menjaju.</p>
<p>(Ukoliko ste upoznati sa starijim verzijama Moodle sistema, setićete se da ovaj tip zadatka ima istu namenu koju je ranije imao stari modul Žurnal (Journal).)</p>';
$string['helpupload'] = '<p>Ovaj tip zadatka omogućava svakom polazniku da postavi jednu ili više datoteka (u bilo kom formatu).</p> <p>To mogu biti MS Word dokumenti, slike, arhivirani veb sajtovi ili bilo šta drugo što ste tražili od polaznika da predaju kao svoj rad.</p>
<p>Ovaj tip zadatka vam, takođe, dozvoljava  da postavite više datoteka za odgovore. Datoteke za odgovor mogu biti postavljene i pre predaje rada, što možete iskoristiti kako biste svakom polazniku dali da radi sa različitom datotekom.</p>
<p>Učesnici takođe mogu da unose svoje beleške koje opisuju predate datoteke, svoje napredovanje u radu na zadatku ili bilo kakve druge tekstualne informacije.</p>
<p>Polaznik mora ručno da završi predaju rada za ovaj tip zadatka. Možete pogledati trenutni status rada u bilo kom trenutku, pri čemu su nezavršeni zadaci označeni kao \'Nacrt\'. Svaki neocenjeni zadatak možete vratiti u status nacrta.</p>';
$string['helpuploadsingle'] = '<p>Ovaj tip zadatka omogućava svakom polazniku da postavi jednu datoteku (bilo kog tipa).</p> <p>To može biti MS Word dokument, slika, arhivirani veb sajt ili bilo šta drugo što ste tražili od polaznika da predaju kao svoj rad.</p>';
$string['hideintro'] = 'Sakrij opisa pre datuma kada zadatak postaje dostupan';
$string['hideintro_help'] = 'Ako je ova opcija omogućena, opis zadatka će biti sakriven sve do trenutka naznačenog u podešavanju "Dostupno od". Polaznici će, do tada, moći da vide samo naziv zadatka.';
$string['invalidassignment'] = 'Neispravan zadatak';
$string['invalidfileandsubmissionid'] = 'Nedostaje datoteka ili ID predatog rada';
$string['invalidid'] = 'Neispravan ID zadatka';
$string['invalidsubmissionid'] = 'Neispravan ID predatog rada';
$string['invalidtype'] = '.Neispravan tip zadatka';
$string['invaliduserid'] = 'Neispravan korisnički ID';
$string['itemstocount'] = 'Broj';
$string['lastgrade'] = 'Poslednja ocena';
$string['late'] = '{$a} kasnije';
$string['maximumgrade'] = 'Maksimalna ocena';
$string['maximumsize'] = 'Maksimalna veličina';
$string['maxpublishstate'] = 'Najduža dostupnost blog članka pre isteka roka';
$string['messageprovider:assignment_updates'] = 'Obaveštenja o zadatku (2.2)';
$string['modulename'] = 'Zadatak (2.2)';
$string['modulename_help'] = 'Modul \'Zadaci\' daje mogućnost nastavniku da odredi zadatak koji polaznici rešavaju ili u onlajn okruženju ili van njega. Nakon toga nastavnik može da oceni predate radove polaznika.';
$string['modulenameplural'] = 'Zadaci (2.2)';
$string['newsubmissions'] = 'Zadaci su predati';
$string['noassignments'] = 'Još uvek nema zadataka';
$string['noattempts'] = 'Niko nije predao rad za ovaj zadatak';
$string['noblogs'] = 'Nemate nijedan blog članak za predaju!';
$string['nofiles'] = 'Nijedna datoteka nije predata';
$string['nofilesyet'] = 'Nijedna datoteka još nije predata';
$string['nomoresubmissions'] = 'Dalja predaja radova nije dozvoljena';
$string['norequiregrading'] = 'Nema zadataka koji zahtevaju ocenjivanje';
$string['nosubmisson'] = 'Nijedan zadatak nije predat';
$string['notavailableyet'] = 'Žao nam je, ali ovaj zadatak još nije dostupan.<br />Uputstva za zadatak će biti prikazana na ovom mestu od dole navedenog datuma.';
$string['notes'] = 'Beleške';
$string['notesempty'] = 'Nema unosa';
$string['notesupdateerror'] = 'Greška pri ažuriranju beleški';
$string['notgradedyet'] = 'Još nije ocenjeno';
$string['notsubmittedyet'] = 'Još nije predato';
$string['onceassignmentsent'] = 'Jednom kada predate rad na ocenjivanje, više nećete moći da brišete ili dodajete datoteke. Da li želite da nastavite?';
$string['operation'] = 'Operacija';
$string['optionalsettings'] = 'Opciona podešavanja';
$string['overwritewarning'] = 'Upozorenje: ponovno postavljanje će ZAMENITI vaš prethodno predati rad';
$string['page-mod-assignment-submissions'] = 'Stranica modula \'Zadatak\' za predaju rada';
$string['page-mod-assignment-view'] = 'Glavna stranica modula \'Zadatak\'';
$string['page-mod-assignment-x'] = 'Bilo koja stranica modula \'Zadatak\'';
$string['pagesize'] = 'Broj predatih radova po stranici';
$string['pluginadministration'] = 'Administracija zadataka';
$string['pluginname'] = 'Zadatak (2.2)';
$string['popupinnewwindow'] = 'Otvori u iskačućem prozoru';
$string['preventlate'] = 'Spreči kašnjenje';
$string['quickgrade'] = 'Dozvoli brzo ocenjivanje';
$string['quickgrade_help'] = 'Ako je uključena ova opcija za brzo ocenjivanje, predavač može da oceni više radova na jednoj stranici. Dodajete ocene i komentare, a zatim kliknite na dugme "Sačuvaj sve moje povratne informacije" kako biste sačuvali sve promene na toj stranici.';
$string['requiregrading'] = 'Zahteva ocenjivanje';
$string['responsefiles'] = 'Datoteke sa odgovorima';
$string['reviewed'] = 'Pregledano';
$string['saveallfeedback'] = 'Sačuvaj sve moje povratne informacije';
$string['selectblog'] = 'Odaberite blog članak koji želite da predate';
$string['sendformarking'] = 'Pošalji na ocenjivanje';
$string['showrecentsubmissions'] = 'Prikaži skoro predate radove';
$string['submission'] = 'Predati rad';
$string['submissiondraft'] = 'Nacrt rada';
$string['submissionfeedback'] = 'Povratne informacije o radu';
$string['submissions'] = 'Predati radovi';
$string['submissionsaved'] = 'Vaše promene su sačuvane';
$string['submissionsnotgraded'] = 'Broj neocenjenih radova: {$a}';
$string['submitassignment'] = 'Predajte svoj rad koristeći ovaj obrazac';
$string['submitedformarking'] = 'Rad je već predat na ocenjivanje i ne može biti ažuriran';
$string['submitformarking'] = 'Finalna predaja rada na ocenjivanje';
$string['submitted'] = 'Predato';
$string['submittedfiles'] = 'Predate datoteke';
$string['subplugintype_assignment'] = 'Tip zadatka';
$string['subplugintype_assignment_plural'] = 'Tipovi zadataka';
$string['trackdrafts'] = 'Uključi dugme "Pošalji na ocenjivanje"';
$string['trackdrafts_help'] = 'Dugme "Pošalji na ocenjivanje" dozvoljava polaznicima da jave predavaču da su završili rad na zadatku. Predavač može izabrati da rad vrati u status nacrta (ako, na primer, poslati rad zahteva da se na njemu dodatno radi).';
$string['typeblog'] = 'Blog članak';
$string['typeoffline'] = 'Aktivnost van mreže (Offline)';
$string['typeonline'] = 'Onlajn tekst';
$string['typeupload'] = 'Napredno postavljanje datoteka';
$string['typeuploadsingle'] = 'Postavljanje datoteke';
$string['unfinalize'] = 'Vrati na status nacrta';
$string['unfinalizeerror'] = 'Došlo je do greške i taj rad noje moguće vratiti na verziju nacrta';
$string['unfinalize_help'] = 'Vraćanje u status nacrta omogućava polazniku da dalje ažurira svoj rad';
$string['unsupportedsubplugin'] = 'Tip zadatka \'{$a}\' trenutno nije podržan. Možete sačekati dok ne postane raspoloživ ili obrisati zadatak.';
$string['upgradenotification'] = 'Ova aktivnost se zasniva na starijoj verziji modula \'Zadatak\'';
$string['uploadafile'] = 'Postavi datoteku';
$string['uploadbadname'] = 'Naziv ove datoteke sadrži nedozvoljene znakove, pa ona nije mogla biti postavljena.';
$string['uploadedfiles'] = 'postavljene datoteke';
$string['uploaderror'] = 'Došlo je do greške prilikom pokušaja da se  datoteke sačuva na serveru';
$string['uploadfailnoupdate'] = 'Datoteke je  uspešno postavljena, ali nije bilo moguće zameniti vaš prethodno predati rad!';
$string['uploadfiles'] = 'Postavi datoteke';
$string['uploadfiletoobig'] = 'Žao nam je, ali ova datoteka je prevelika (dozvoljena veličina datoteke je {$a} bajta)';
$string['uploadnofilefound'] = 'Datoteka nije pronađena - da li ste sigurni da ste izabrali datoteku za postavljanje?';
$string['uploadnotregistered'] = 'Datoteke \'{$a}\' je uspešno postavljena, ali rad nije registrovan!';
$string['uploadsuccess'] = 'Datoteke \'{$a}\' je uspešno postavljena';
$string['usermisconf'] = 'Korisnik nije ispravno podešen';
$string['usernosubmit'] = 'Nažalost, nije vam dozvoljeno da predate rad';
$string['viewassignmentupgradetool'] = 'Pogledajte alatku za nadogradnju modula \'Zadatak\'';
$string['viewfeedback'] = 'Pogledajte ocene i povratne informacije';
$string['viewmysubmission'] = 'Pogledaj moj rad';
$string['viewsubmissions'] = 'Pogledaj {$a} predat(a)/predatih rad(a)/ova';
$string['yoursubmission'] = 'Vaš predati rad';
