<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Pristup je odbijen';
$string['accounts'] = 'Nalozi';
$string['addcategory'] = 'Dodaj kategoriju';
$string['additionalhtml'] = 'Dodatni HTML';
$string['additionalhtml_desc'] = 'Ovo podešavanje vam dozvoljava da navedete HTML kôd koji želite da bude dodat na svaku stranicu. Možete postaviti HTML kôd koji će biti dodat unutar oznake HEAD za svaku stranicu, odmah nakon otvaranja ili neposredno pre zatvaranja oznake BODY.<br /> Na ovaj način možete imati prilagođeno zaglavlje ili podnožje za svaku stranicu ili možete dodati podršku za servise, poput Google Analytics, na jednostavan način, nezavisno od teme koju ste izabrali.';
$string['additionalhtmlfooter'] = 'Pre nego što se zatvori BODY oznaka';
$string['additionalhtmlfooter_desc'] = 'Sadržaj koji ovde upišete biće dodat na svaku stranicu neposredno pre nego što se zatvori body oznaka (</body>).';
$string['additionalhtmlhead'] = 'Unutar HEAD oznake';
$string['additionalhtmlhead_desc'] = 'Sadržaj koji ovde upišete biće dodat na krau HEAD oznake na svakoj stranici.';
$string['additionalhtml_heading'] = 'Dodatni HTML koji se biti pridružen svakoj stranici.';
$string['additionalhtmltopofbody'] = 'Kada se otvori BODY oznaka';
$string['additionalhtmltopofbody_desc'] = 'Sadržaj koji ovde upišete biće dodat na svaku stranicu odmah nakon što se otvori body oznaka (<body>).';
$string['admincategory'] = 'Kategorija: {$a}';
$string['adminseesall'] = 'Administratori vide sve';
$string['adminseesallevents'] = 'Administratori vide sve događaje';
$string['adminseesownevents'] = 'Administratori su kao ostali korisnici';
$string['advancedfeatures'] = 'Napredna svojstva';
$string['allcountrycodes'] = 'Sve oznake zemalja';
$string['allowbeforeblock'] = 'Prvo će se obrađivati spisak dopuštenih adresa';
$string['allowbeforeblockdesc'] = 'Podrazumevano je da se spisak blokiranih adresa prvo obrađuje, ako je ova opcija omogućena, spisak dopuštenih IP adresa biće obrađen pre spiska blokiranih adresa.';
$string['allowblockstodock'] = 'Dozvoliti fiksiranje blokova';
$string['allowcategorythemes'] = 'Dozvoli izbor grafičke teme na nivou kategorija';
$string['allowcoursethemes'] = 'Dozvoli izbor grafičke teme na nivou kurseva';
$string['allowediplist'] = 'Spisak dopuštenih adresa';
$string['allowemailaddresses'] = 'Dozvoljeni domeni elektronske pošte';
$string['allowframembedding'] = 'Dozvoli umetanje okvira';
$string['allowframembedding_help'] = 'Dozvoli umetanje ovog sajta u okvire spoljnih sajtova. Omogućavanje ove funkcije se ne preporučuje iz bezbednosnih razloga.';
$string['allowguestmymoodle'] = 'Dozvolite gostima pristup stranici \'Moja početna stranica\'';
$string['allowobjectembed'] = 'Dozvoli EMBED i OBJECT oznake';
$string['allowthemechangeonurl'] = 'Dozvoli promenu grafičke teme u URL adresi';
$string['allowuserblockhiding'] = 'Dozvoli korisnicima da sakriju blokove';
$string['allowuserswitchrolestheycantassign'] = 'Dozvoli korisnicima koji nemaju mogućnost dodeljivanja uloga da menjaju svoje uloge';
$string['allowuserthemes'] = 'Dozvoli korisnicima izbor grafičke teme';
$string['antivirus'] = 'Antivirus';
$string['appearance'] = 'Izgled';
$string['aspellpath'] = 'Putanja do alata aspell';
$string['authentication'] = 'Provera identiteta';
$string['authpreventaccountcreation'] = 'Spreči kreiranje naloga prilikom provere identiteta';
$string['authpreventaccountcreation_help'] = 'Prilikom provere identiteta korisnika, na sajtu se automatski kreira nalog, ukoliko on već ne postoji. Ako se pak, za proveru identiteta, koristi neka spoljašnja baza podataka, poput LDAP-a, a pri tome želite da dozvolite pristup sajtu  samo korisnicima sa postojećim nalogom, onda treba uključiti ovu opciju. U tom slučaju, novi nalozi se kreiraju ručno ili putem opcije za postavljanje korisnika. Imajte u vidu da se ovo podešavanje ne primenjuje na MNet proveru identiteta.';
$string['authsettings'] = 'Upravljanje proverom identiteta';
$string['autolang'] = 'Automatsko detektovanje jezika';
$string['autologinguests'] = 'Automatsko prijavljivanje gostiju';
$string['availablelicenses'] = 'Raspoložive licence';
$string['availableto'] = 'Dostupno';
$string['backgroundcolour'] = 'Transparentna boja';
$string['backups'] = 'Rezervne kopije';
$string['backup_shortname'] = 'Koristite naziv kursa u nazivu datoteke rezervne kopije';
$string['backup_shortnamehelp'] = 'Koristite naziv kursa kao deo naziva datoteke rezervne kopije.';
$string['badwordsconfig'] = 'Unesite svoju listu ružnih reči odvojenih zarezima.';
$string['badwordsdefault'] = 'Ukoliko je Vaša lista ružnih reči prazna, biće korišćena podrazumevana lista jezičkog paketa.';
$string['badwordslist'] = 'Lista definisanih ružnih reči';
$string['blockediplist'] = 'Spisak blokiranih IP adresa';
$string['blockeditingmenu'] = 'Meniji za uređivanje blokova';
$string['blockeditingmenu_desc'] = 'Ako je ova opcija omogućena mnoge od ikona za uređivanje blokova prikazanih kad je uređivanje uključeno biće prikazane u okviru padajućeg menija. Ovo redukuje sadržaj na ekranu sakrivajući ikone dok ne postanu potrebne.';
$string['blockinstances'] = 'Instance';
$string['blockmultiple'] = 'Višestruki';
$string['blockprotect'] = 'Zaštiti instance';
$string['blockprotect_help'] = 'Ako zaključate određeni tip bloka, onda niko neće moći da dodaje ili briše instance tog blokova. (Blok možete, naravno,  ponovo da otključavate, ukoliko želite da uredite njegove instance)

Svrha ove opcije je da se zaštite blokovi kao što su \'Navigacija\' i \'Podešavanja \', koje je teško povratiti ako se greškom obrišu.';
$string['blocksettings'] = 'Upravljanje blokovima';
$string['blockunprotect'] = 'Ukloni zaštitu';
$string['bloglevel'] = 'Vidljivost bloga';
$string['bookmarkadded'] = 'Obeleživač je dodat.';
$string['bookmarkalreadyexists'] = 'Već ste obeležili ovu stranicu.';
$string['bookmarkdeleted'] = 'Obeleživač je obrisan.';
$string['bookmarkthispage'] = 'Obeleži ovu stranicu';
$string['cacheapplication'] = 'Keš aplikacije';
$string['cacheapplicationhelp'] = 'Keširane stavke se dele između svih korisnika i ističu nakon određenog perioda (ttl).';
$string['cachejs'] = 'Keširaj Javascript';
$string['cachejs_help'] = 'Keširanje Javascripta i kompresija u velikoj meri poboljšava učitavanje stranice. Veoma se preporučuje za produkcione sajtove. Programeri će verovatno želeti da onemoguće ovu funkciju.';
$string['cacherequest'] = 'Keš zahteva';
$string['cacherequesthelp'] = 'Poseban korisnički keš koji ističe nakon što je zahtev ispunjen. Namena mu je da zameni oblasti gde smo koristili statičko čuvanje podataka.';
$string['cachesession'] = 'Keš sesije';
$string['cachesessionhelp'] = 'Poseban korisnički keš koji ističe nakon što korisnik završi sesiju. Namena mu je da smanji uvećanje/opterećenje sesije.';
$string['cachesettings'] = 'Podešavanja keša';
$string['cachetext'] = 'Vreme trajanja keširanja teksta';
$string['caching'] = 'Keširanje';
$string['calendarexportsalt'] = 'Nasumični string (salt) za izvoz kalendara';
$string['calendarsettings'] = 'Kalendar';
$string['calendartype'] = 'Tip kalendara';
$string['calendartype_desc'] = 'Izabarite podrazumevani tip kalendara za čitav sajt. Ovo podešavanje može biti promenjeno u podešavanjima kursa ili od strane korisnika na njihovim stranicama profila.';
$string['calendar_weekend'] = 'Dani vikenda';
$string['cannotdeletemodfilter'] = 'Ne možete da deinstalirate  filter \'{$a->filter}\' zato šro je on deo modula \'{$a->module}\'';
$string['cannotuninstall'] = '{$a} nije moguće deinstalirati';
$string['cfgwwwrootslashwarning'] = 'Pogrešno ste definisali $CFG->wwwroot u vašoj config.php datoteci. Uključili ste karakter \'/\' na kraju. Uklonite ga, inače će te dobijati čudne poruke o grešci poput sledeće <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Pogrešno ste definisali $CFG->wwwroot u vašoj config.php datoteci. Adresa ne odgovara URL adresi koju koristite da biste pristupili ovoj stranici. Ispravite adresu, inače će te dobijati čudne poruke o grešci poput sledeće <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'promeni';
$string['checkboxno'] = 'Ne';
$string['checkboxyes'] = 'Da';
$string['choosefiletoedit'] = 'Odaberi datoteku za uređivanje';
$string['clamfailureonupload'] = 'Nakon neuspešnog izvršavanja clam antivirusnog alata';
$string['cleanup'] = 'Čišćenje';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'Greška, neispravna vrednost "{$a->value}" za "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Neispravna vrednos, molim pokušajte ponovo';
$string['clistatusdisabled'] = 'Status onemogućen';
$string['clistatusenabled'] = 'Status omogućen';
$string['clistatusenabledlater'] = 'status: CLI režim održavanja biće omogućen {$a}';
$string['clitypevalue'] = 'otkucaj vrednost';
$string['clitypevaluedefault'] = 'otkucaj vrednost, pritisni Enter da biste upotrebili podrazumevanu vrednost ({$a})';
$string['cliunknowoption'] = 'Neprepoznate opcije:
{$a}
Molimo iskoristite opciju za pomoć.';
$string['cliupgradefinished'] = 'Ažuriranje putem komande linije je uspešno završeno.';
$string['cliupgradenoneed'] = 'Nije potrebna nadogradnja za instaliranu verziju {$}. U svakom slučaju hvala što ste došli !';
$string['cliyesnoprompt'] = 'otkucaj y (znači da) ili n (znači ne)';
$string['commentsperpage'] = 'Broj komentara prikazanih po stranici';
$string['commonfiltersettings'] = 'Zajednička podešavanja filtera';
$string['commonsettings'] = 'Opšta podešavanja';
$string['componentinstalled'] = 'Komponenta je instalirana';
$string['computedfromlogs'] = 'Izračunato iz zapisa o aktivnostima od {$a}.';
$string['condifmodeditdefaults'] = 'Podrazumevane vrednosti se koriste u formama za podešavanje prilikom kreiranja nove aktivnosti ili resursa.';
$string['confeditorhidebuttons'] = 'Odaberite dugmad koja bi trebala biti skivena u HTML editoru.';
$string['configallcountrycodes'] = 'Ovo je spisak zemalja koje mogu biti odabrane na raznim mestima, recimo u korisničkom profilu. Ako je spisak prazan (što je podrazumevana vrednost), koristiće se spisak iz countries.php koji je deo standardnog engleskog jezičkog paketa. Taj spisak je preuzet iz ISO 3166-1. U suprotnome potrebno je da da navedete i dvoslovne oznake zemalja odvojene zarezima, npr. \'RS,GB,ES\'. Ako dodate nove, nestandardne oznake, moraćete da ih dodate i u countries.php datoteku, kako engleskog, tako i Vašeg jezičkog paketа.';
$string['configallowassign'] = 'Možete dozvoliti ljudima koje imaju uloge navedene u prvoj koloni sa leve strane da drugim ljudima dodeljuju neke od uloga u ostalim kolonama.';
$string['configallowblockstodock'] = 'Ako je ovo podešavanje omogućeno, a to izabrana tema podržava, korisnici mogu da odaberu da premeštaju blokove u poseban dok (sa desne strane).';
$string['configallowcategorythemes'] = 'Ukoliko omogućite ovu opciju grafičke teme se mogu podeševati na nivou kategorija. To će uticati na sve podređene kategorije i kurseve koje već nemaju podešenu sopstvenu grafičku temu. UPOZORENjE: Omogućavanje izbora grafičke teme na nivou kategorija može uticati na performanse sistema.';
$string['configallowcoursethemes'] = 'Ukoliko omogućite ovu opciju, kursevima će biti dozvoljeno da podese sopstvene grafičke teme. Grafičke teme na nivou kurseva imaju prvenstvo u odnosu na sve ostale izbore tema (sajta, korisnika ili sesije).';
$string['configallowemailaddresses'] = 'Ukoliko želite da ograničite nove elektronske adrese na određene domene, navedite ih ovde razdvojene razmacima. Svi ostali domeni biće odbijeni. Da biste dozvolili korišćenje određenih poddomena dodajte odgovarajući domen sa tačkom ispred. Na primer: <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'Ako je ova opcija omogućena gosti će moći da pristupe stranici \'Moja početna stranica\', u suprotnom biće preusmereni na naslovnu stranicu sajta.';
$string['configallowobjectembed'] = 'Kao podrazumevana bezbednosna mera, krajnjim korisnicima nije dozvoljeno umetanje multimedijalnih sadržaja (poput Flash animacija) unutar teksta eksplicitno korišćenjem oznaka EMBED i OBJECT unutar HTML koda (iako je to i dalje moguće izvesti na sigurniji način putem mediaplugins filtera). Želite li ipak dozvoliti upotrebu ovih oznaka, uključite ovu opciju.';
$string['configallowoverride'] = 'Možete dozvoliti ljudima koje imaju uloge navedene u prvoj koloni sa leve strane da menjaju ovlašćenja uloga
navedenih u preostalim kolonama.';
$string['configallowoverride2'] = 'Izaberite koje uloge se kojim ulogama iz leve kolone mogu promeniti.<br /> Zapazite da ova podešavanja važe samo za one korisnike koji imaju dopuštene mogućnosti moodle/role:override ili moodle/role:safeoverride.';
$string['configallowswitch'] = 'Izaberite u koje uloge korisnik može preći, na osnovu onih uloga koje već poseduje. Pored unosa u ovoj tabeli, korisnik takođe mora posedovati ovlašćenje moodle/role:switchroles da bi mogao da promeni ulogu.<br />Zapazite da je jedino moguće izmeniti uloge koje imaju ovlašćenje moodle/course:view, a nemaju ovlašćenje moodle/site:doanything, pa su neke kolone ove tabele onemogućene.';
$string['configallowthemechangeonurl'] = 'Ako je ovo podešavanje omogućeno, grafička tema može da se promeni dodavanjem <br />?theme=themename bilo kojoj Moodle URL adresi (npr: mymoodlesite.com/?theme=afterburner ) ili <br />&theme=themename bilo kojoj internoj Moodle URL adresi (npr: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Da li želite da korisnicima omogućite da sami  skrivaju/prikazuju bočne blokove na ovom sajtu? Ovo svojstvo koristi Java skript i "kolačiće" kako bi se zapamtilo trenutno stanje blokova, i utiče jedino na izgled sajta pojedinačnog korisnika.';
$string['configallowuserswitchrolestheycantassign'] = 'Kao podrazumevano podešavanje, zahteva se da korisnik ima ovlašćenje moodle/role:assign da bi mogao da menja uloge. Omogućavanjem ovog podešavanja ovde, uklanja se ovaj zahtev i za posledicu ima da se pojavljuje padajući spisak "Promeni ulogu u", koji je određen samo podešavanjima u tabeli "Dozvoli dodeljivanje uloga".
Preporučuje se da podešavanja u tabeli "Dozvoli dodeljivanje uloga" ne dozvoljavaju korisnicima da promene ulogu u onu sa većim ovlašćenjima od postojeće.';
$string['configallowuserthemes'] = 'Ukoliko omogućite ovu opciju, korisnicima će biti dozvoljeno da sami podese grafičku temu po svojoj želji. Teme koje izaberu korisnici imaju prednost u odnosu na grafičku temu podešenu na nivou sajta (ali ne i u odnosu na grafičku temu podešenu na nivou kursa).';
$string['configallusersaresitestudents'] = 'Za aktivnosti na početnoj stranici sajta, da li se SVI korisnici smatraju polaznicima? Ukoliko je odgovor "Da", onda će svakom korisniku sa otvorenim nalogom biti dozvoljeno da kao polaznik učestvuje u tim aktivnostima. Ukoliko je odgovor "Ne", onda će samo oni korisnici koji su upisani na najmanje jedan kurs moći da učestvuju u aktivnostima na početnoj strani. Samo administratori i posebno određeni predavači mogu da budu predavači za te aktivnosti.';
$string['configauthenticationplugins'] = 'Molimo odaberite dodatke za proveru identiteta koje želite da koristite i poređajte ih u redosledu smenjivanja u slučaju neuspeha. Samoregistracijom će upravljati dodatak odabran u koloni \'Registracija\' (obično \'e-pošta\')';
$string['configautolang'] = 'Ukoliko podrazumevani jezik na nivou sajt nije uključen, detektuj podrazumevani jezik Web čitača.';
$string['configautologinguests'] = 'Da li bi posetioci sajta trebalo da budu automatski prijavljeni na sistem kao gosti kada ulaze na neki od kurseva koji dozvoljavaju pristup gostima?';
$string['configbloglevel'] = 'Ovo podešavanje vam dozvoljava da ograničite nivo do kog će biti vidljivi blogovi korisnika na ovom sajtu. Imajte u vidu da ovo određuje najširi kontekst ČITAOCA, a ne autora ili tip blog članka. Blogovi mogu biti i potpuno onemogućeni ako uopšte ne želite da ih koristite.';
$string['configcachetext'] = 'Za obimnije sajtove, odnosno sajtove koje koriste tekstualne filtere ovo podešavanje može da ubrza rad. Kopije tekstova biće zadržane u svom obrađenom obliku u vremenskom intervalu koji ovde odredite. Zadavanje premale vrednosti bi moglo donekle usporiti rad, a zadavanje prevelike vrednosti bi moglo rezultirati time da tekstovima treba previše vremena za osvežavanje (npr. s novim linkovima).';
$string['configcalendarcustomexport'] = 'Omogući prilagođeni vremenski okvir izvoza kalendara';
$string['configcalendarexportsalt'] = 'Ovaj nasumični tekst se koristi za unapređenje bezbednosti tokena za proveru autentičnosti koji se koristi za izvoz kalendara. Imajte u vidu  da su svi tekući tokeni poništeni ukoliko promenite ovaj nasumični tekst ("hash salt")';
$string['configclamactlikevirus'] = 'Tretiraj datoteke kao viruse';
$string['configclamdonothing'] = 'Tretiraj datoteke normalno';
$string['configclamfailureonupload'] = 'Kako da se ponaša Clam AV, konfigurisan da skenira postavljene datoteke, kada zbog loše konfiguracije ili iz nekog nepoznatog razloga ne uspe da se pokrene? Ako izaberete opciju "Tretiraj datoteke kao viruse" datoteke će biti premeštene u "karantin" ili obrisane. Ukoliko izaberete opciju "Tretiraj datoteke normalno" datoteke će biti premeštene u odredišni direktorijum na uobičajen način. U oba slučaja administrator će biti obavešten da je Clam prijavio grešku prilikom startovanja. Ukoliko izaberete opciju "Tretiraj datoteke kao viruse", u slučaju da iz bilo kog razloga Clam ne bude pokrenut (obično zbog pogrešno podešene putanje do njega), SVE postavljene datoteke biće premeštene u "karantin" ili obrisane. Budite obazrivi sa ovim podešavanjem.';
$string['configconvertformat'] = 'Ako su <i>latex</i>, <i>dvips</i> i <i>convert</i> dostupni, slike se kreiraju korišćenjem navedenog formata. Ako nisu, biće korišćen mimeTeX i on će kreirati GIF slike.';
$string['configcookiehttponly'] = 'Omogućava novu karakteristiku PHP 5.2.0 - Web čitačima se zadaje da šalju kolačiće samo sa pravim http zahtevima, kolačići ne bi trebalo da budu dostupni skript jezicima. Ovo ne podržavaju svi Web čitači i možda neće biti kompatibilno sa sadašnjim kodom. Pomaže da se spreče neki tipovi XSS napada.';
$string['configcookiesecure'] = 'Ako server prihvata samo https konekcije, preporučljivo je omogućiti slanje bezbednih kolačića. Ako je podešavanje omogućeno, molimo, proverite da veb server ne prihvata http:// ili podesite stalno preusmeravanje na https:// adresu. Kada <em>wwwroot</em> adresa ne počinje sa https:// ovo podešavanje se automatski isključuje.';
$string['configcountry'] = 'Ukoliko ovde podesite ime države, ono će biti izabrano kao podrazumevano u novootvorenim korisničkim nalozima. Ostavite ovo polje prazno kako bi ste primorali korisnike da sami izaberu državu iz koje su.';
$string['configcourseoverviewfilesext'] = 'Spisak dozvoljenih, zarezima razdvojenih, ekstenzija datoteka rezimea kurseva.';
$string['configcourseoverviewfileslimit'] = 'Maksimalan broj datoteka koji se može priložiti uz rezime kursa.';
$string['configcourserequestnotify'] = 'Upišite korisničko ime korisnika koji će biti obavešteni kada se pojavi zahtev za pokretanje novog kursa.';
$string['configcourserequestnotify2'] = 'Korisnici koji će biti obavešteni kada se pojavi zahtev za pokretanje novog kursa. Ovde su navedeni samo korisnici koji mogu odobriti zahtev za pokretanje kursa.';
$string['configcoursesperpage'] = 'Unesite broj kurseva koji se na spisku kurseva prikazuje po jednoj stranici.';
$string['configcourseswithsummarieslimit'] = 'Maksimalan broj kurseva za prikazivanje na spisku kurseva, uključujući njihov rezimea, pre povratka na jednostavniji spisak kurseva (bez rezimea).';
$string['configcronclionly'] = 'Ukoliko je ovo uključeno, onda se kron skripta može pokrenuti samo iz komandne linije umesto preko Weba. Ovo podešavanje ima prednost u odnosu na lozinku za kron.';
$string['configcronremotepassword'] = 'Ovo znači da se cron.php skripta ne može pokrenuti iz veb čitača ako se ne obezbedi lozinka, tako što će se upotrebiti sledeći oblik URL adrese:<pre> http://site.example.com/admin/cron.php?password=opensesame</pre. Ukoliko se ovo ostavi prazno, lozinka nije potrebna.';
$string['configcurlcache'] = 'Vreme trajanja cURL keša, u sekundama';
$string['configcustommenuitems'] = 'Ovde možete da konfigurišete sopstveni meni koji će biti prikazan u okviru grafičke teme. Svaki red se sastoji od teksta stavke u meniju, odgovarajuće URL adrese linka (opciono), kratkog opisa stavke (opciono), kao i oznake jezika ili liste oznaka jezika, odvojenih zarezima, (opciono, za prikaz tog reda isključivo korisnicima navedenog jezika) koji su međusobno odvojeni vertikalnom crtom |. Možete da odredite i strukturu menija koristeći crtice. Na primer:
<pre>
Moodle zajednica|https|//moodle.org
-Moodle besplatna podrška|https://moodle.org/support
-Moodle razvoj|https://moodle.org/development
--Moodle dokumenti|https://docs.moodle.org
Moodle.com|http://moodle.com/
</pre>';
$string['configdbsessions'] = 'Ako je omogućeno, ovo podešavanje će koristiti bazu podataka za pohranjivanje informacije o tekućim sesijama. Imajte u vidu da:će promena ovog podešavanja prekinuti sesije svih trenutno aktivnih korisnika (uključujući i vas). Ukoliko koristite MySQL proverite da li je vrednost za \'max_allowed_packet\' u my.cnf (ili my.ini) datoteci  barem 4M. Drugi drajveri sesija mogu se direktno konfigurisati u config.php datoteci; za više informacija pogledajte datoteku config-dist.php. Ova opcija nestaje ako navedete drajver sesije u datoteci  config.php.';
$string['configdebug'] = 'Ukoliko uključite ovu opciju onda će biti povećan broj izvešataja o greškama PHP-a (error_reporting). Ova opcija je korisna jedino onima koji razvijaju Moodle.';
$string['configdebugdisplay'] = 'Ako je ova opcija uključena, obaveštavanje o greškama će biti prosleđeno na HTML stranicu. Ovo je praktično, ali generalno nije kompatibilno sa XHTML, JS, kolačićima i HTTP zaglavljem. Ako je isključeno, izlazne informacije biće prosleđene u zapise vašeg servera, omogućavajući tako bolje uklanjanje grešaka. PHP podešavanje error_log kontroliše u koji zapis idu ove informacije.';
$string['configdebugpageinfo'] = 'Uključite ukoliko želite da se informacije o stranici prikazuju u njenom podnožju.';
$string['configdebugsmtp'] = 'Uključite detaljne informacije za otklanjanje grešaka tokom slanja poruka e-pošte SMTP serveru.';
$string['configdebugvalidators'] = 'Uključite ako u podnožju stranice želite imati linkove na spoljne servere za proveru ispravnosti. Možda će biti potrebno da kreirate novog korisnika sa korisničkim imenom <em>w3cvalidator</em>, i omogućiti mu gostujući pristup. Ove izmene mogu dozvoliti neovlašćeni pristup serveru, ne uključujte na zvanično aktivnim Web lokacijama!';
$string['configdefaulthomepage'] = 'Ovo podešavanje određuje početnu stranicu za ulogovane korisnike';
$string['configdefaultrequestcategory'] = 'Kursevi koje zahtevaju korisnici biće automatski smešteni u ovu kategoriju.';
$string['configdefaultrequestedcategory'] = 'Podrazumevana kategorija za smeštanje zahtevanih kurseva, ukoliko su isti odobreni.';
$string['configdefaultuserroleid'] = 'Svim korisnicima, prijavljenim  na sistem, biće date mogućnosti uloge koju ovde navedete, na nivou sajta, kao DODATAK na eventualne druge uloge koje možda već imaju. Podrazumevana je uloga autorizovanog korisnika. Imajte u vidu da ovo neće biti u suprotnosti sa drugim ulogama koje korisnici imaju, osim ako ne zabranite mogućnosti.
Ovo samo osigurava da svi korisnici imaju sposobnosti koje nije moguće dodeliti na nivou kursa (npr. pisanje blog članaka, uređivanje sopstvenog kalendara itd.)';
$string['configdeleteincompleteusers'] = 'Po isteku ovog perioda, brišu se stari, nepotpuni nalozi.';
$string['configdeleteunconfirmed'] = 'Ukoliko koristite proveru identiteta putem elektronske pošte, ovo je vremenski rok unutar kog će biti prihvaćena potvrda od strane korisnika. Nakon tog perioda svi nepotvrđeni nalozi biće obrisani.';
$string['configdenyemailaddresses'] = 'Da biste onemogućili elektronske adrese sa određenih domena navedite ih ovde na isti način. Svi drugi domeni biće prihvaćeni. Na primer <strong>hotmail.com yahoo.co.uk neželjeni.domen.com</strong>';
$string['configdisableuserimages'] = 'Isključite mogućnost da korisnici menjaju slike u korisničkim profilima';
$string['configdisplayloginfailures'] = 'Ovo će izabranim korisnicima prikazati informacije o prethodnim neuspešnim pokušajima prijave na sistem.';
$string['configdndallowtextandlinks'] = 'Omogućite ili onemogućite postavljanje teksta i linkova, zajedno sa datotekama, pomoću opcije \'prevuci i spusti\'. Imajte na umu da je prevlačenje teksta u Fajerfoksu ili između različitih veb čitača nepouzdano i da kao posledicu može imati da podaci ili tekst ne budu postavljeni.';
$string['configdocroot'] = 'Дефинише путању до Moodle документације за пружање контекстуалне подршке путем линкова "Moodle документација за ову страницу" у подножју сваке стране. Ако се ово поље остави празно ти линкови се неће приказивати.';
$string['configdoctonewwindow'] = 'Ako ovo omogućite, linkovi do Moodle dokumentacije će biti prikazani u novom prozoru.';
$string['configeditordictionary'] = 'Ova vrednost se koristi ako aspell nema rečnik za jezik korisnika.';
$string['configeditorfontlist'] = 'Izaberite fontove koji će se pojaviti u listi raspoloživih fontova pri korišćenju editora.';
$string['configemailchangeconfirmation'] = 'Zatražiti korak potvrde putem e-pošte kada korisnici izmene svoju adresu e-pošte u svom profilu.';
$string['configenableajax'] = 'Ovo podešavanje kontroliše korišćenja AJAX-a na sajtu. AJAX je neophodan za neke funkcionalnosti kao što je prevlačenje sadržaja.';
$string['configenableblogs'] = 'Ovajj prekidač omogućava svim korisnicima sajta da koriste svoj blog';
$string['configenablecalendarexport'] = 'Omogući izvoz ili prijavu na kalendare';
$string['configenablecomments'] = 'Omogući komentare';
$string['configenablecourserequests'] = 'Ovo će dozvoliti svakom korisniku da zahteva kreiranje kursa.';
$string['configenabledevicedetection'] = 'Omogućava detekciju mobilnih i pametnih telefona, tableta ili standardnih uređaja (stoni ili prenosivi računari, itd.) zbog primene grafičkih tema i drugih funkcija.';
$string['configenablegroupmembersonly'] = 'Ako je ovo podešavanje omogućeno, pristup aktivnostima može biti ograničen samo na članove grupe. Ovo može da rezultira povećanim opterećenjem servera. Dodatno, kategorije u knjizi ocena moraju biti podešene na odgovarajući način kako bi se osiguralo da te aktivnosti budu sakrivene od onih koji nisu članovi grupe.';
$string['configenablemobilewebservice'] = 'Omogućite primenu mobilnih servisa za zvaničnu Moodle aplikaciju ili druge aplikacije koji to zahtevaju. Za više informacija pročitajte {$a}';
$string['configenablerssfeeds'] = 'Ova je opcija omogućena, RSS izvori će biti generisani na čitavom sajtu od strane različiti modula aktivnosti kao što su blogovi, forumi. baze podataka i rečnici. Imajte u vidu da RSS servis, takođe, treba da bude omogućen na nivou podešavanja pojedinačnog modula aktivnosti.';
$string['configenablerssfeedsdisabled'] = 'RSS servis nije dostupan, zato što njegovo korišćenje nije omogućeno na nivou celog sajta. Da bi ste omogućili korišćenje RSS-a, idite na stranicu za podešavanja promenljivih u okviru administratorske konfiguracije.';
$string['configenablerssfeedsdisabled2'] = 'Podrška za RSS izvor vesti je isključena na nivou servera. Potrebno je da je prvo uključite na Administracija sajta/Server/RSS';
$string['configenablesafebrowserintegration'] = 'Ovo dodaje opciju "Zahteva Safe Exam Browser" u polju "Sigurnost Web čitača" na obrascu za podešavanje testa. Za više informacija pogledajte http://www.safeexambrowser.org/';
$string['configenablestats'] = 'Ako ovde izaberete opciju "Da", cronjob vašeg Moodlea će obraditi zapise i prikupiti neke statističke informacije. U zavisnosti od količine saobraćaja na vašem sajtu to može potraje neko vreme. Ako ovu opciju omogućite, moći ćete da vidite neke zanimljive grafikone i statističke izveštaje o svakom od vaših kurseva, ili na nivou celog sajta.';
$string['configenabletrusttext'] = 'Prema podrazumevanim podešavanjima Moodle će uvek temeljno prečistiti tekst koji dolazi od korisnika, kako bi uklonio eventualne zlonamerne skriptove, multimedijalne i druge sadržaje koji bi mogli predstavljati bezbednosni rizik. Sistem Pouzdanog sadržaja (Trusted Content system) predstavlja način da pojedinim korisnicima, kojima verujete, dozvolite da dodaju i takve napredne sadržaje bez dodatne provere. Da biste omogućili ovaj sistem prvo morate da uključite ovo podešavanje, a potom da odobrite dozvolu za Pouzdani sadržaj odgovarajućoj Moodle ulozi. Tekstovi koje kreiraju ili postavljaju takvi korisnici biće označeni kao pouzdani i neće biti podvrgnuti prečišćavanju pre prikaza.';
$string['configenablewebservices'] = 'Web servisi daju mogućbost drugim sistemima da se prijave na ovaj Moodle i izvode različite operacije. Zbog dodatne bezbednosti ovo svojstvo bi trebalo da bude isključeno, osim ako ne želite da ga stvarno koristite.';
$string['configenablewsdocumentation'] = 'Uključite automatsko generisanje dokumentacije o Web servisima. Korisnik može pristupiti sopstvenoj dokumentaciji na svojoj stranici bezbednosnih ključeva {$a}. Stranica prikazuje dokumentaciju samo za dozvoljene protokole. ';
$string['configerrorlevel'] = 'Odaberite nivo PHP upozorenja koja će Vam se prikazivati na ekranu. Postavka Normal je obično najbolji odabir.';
$string['configexportlookahead'] = 'Dana unapred za praćenje u toku izvoza';
$string['configexportlookback'] = 'Dana unazad za praćenje tokom izvoza';
$string['configextendedusernamechars'] = 'Uključite ovo podešavanje kako biste dozvolili polaznicima da upotrebljavaju sve znakove u svojim korisničikim imenima (napomena: ovo ne utiče na njihova prava imena). Podrazumevana vrednost je "netačno" što ograničava polaznike da koriste samo mala slova, brojeve, donju crtu (_), crticu (-), tačku (.) ili simbol "et" (@).';
$string['configextramemorylimit'] = 'Pojedini skriptovi kao što je pretraga, pravljenje rezervnih kopija ili kron zahtevaju više memorije. Za velike sajtove postavite više vrednosti.';
$string['configfilterall'] = 'Filtriranje svih stringova, uključujući naslove, nazive, navigacijske elemente i slično. Ovo je jedino korisno kod korišćenja višejezičkog filtera, u suprotnom previše opterećuje server uz malu ili nikakvu korist.';
$string['configfiltermatchoneperpage'] = 'Filteri za automatsko linkovanje će generisati samo jedan link ka prvoj odgovarajućoj pojavi teksta pronađenoj na kompletnoj stranici. Sve ostale pojave se ignorišu.';
$string['configfiltermatchonepertext'] = 'Filteri za automatsko linkovanje će generisati samo jedan link ka prvoj odgovarajućoj pojavi teksta pronađenoj u svakoj od stavki teksta (npr. resursu, bloku) na stranici. Sve ostale pojave se ignorišu. Ovo podešavanje se ne uzima u obzir ako je podešavanje za jednu pojavu po stranici postavljeno na <i>da</i>.';
$string['configfilteruploadedfiles'] = 'Procesiranje svih postavljenih HTML i tekstualnih datoteka filterima pre njihovog prikazivanja, procesiranje samo postavljenih HTML datoteka ili bez procesiranja.';
$string['configforcelogin'] = 'Pod normalnim okolnostima, ljudi će moći da vide naslovnu stranu sajta i spisak kurseva (ali ne i same kurseve) bez prethodnog prijavljivanja. Ukoliko želite da primorate ljude da se prijave pre nego što vide BILO ŠTA na sajtu, onda bi trebalo da omogućite ovo podešavanje.';
$string['configforceloginforprofiles'] = 'Ovo podešavanje primorava ljude da se na sistem prijave sa pravim nalozima (ne kao gosti) pre nego što budu u prilici da vide stranice sa korisničkim profilima. Ako ste onemogućili ovo podešavanje može se desiti da neki korisnici u svoje profile postavljaju reklame ili drugi neprikladan sadržaj, koji će onda biti vidljiv svima na Internetu.';
$string['configfrontpage'] = 'Gore izabrane stavke biće prikazane na naslovnoj stranici sajta.';
$string['configfrontpagecourselimit'] = 'Maksimalan broj kurseva';
$string['configfrontpagecourselimithelp'] = 'Maksimalan broj kurseva koji se prikazuje na naslovnoj stranici sajta u okviru spiska kurseva.';
$string['configfrontpageloggedin'] = 'Gore izabrane stavke biće prikazane na naslovnoj stranici sajta kada je korisnik prijavljen na sistem.';
$string['configfullnamedisplay'] = 'Ovo definiše način na koji će biti prikazano ime i prezime. Podrazumevana vrednost, "language", ostavlja da vrednost stringa "fullnamedisplay" u tekućem jezičkom paketu odredi način prikaza. Pojedini jezici imaju različite konvencije za prikaz imena.

Za većinu monojezičnih sajtova najefikasnije podešavanje je  "Ime + Prezime", ali možete da izaberete da potpuno sakrijete prezimena. Oznake koje mogu da se koriste su: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, i alternatename.';
$string['configgeoipfile'] = 'Lokacija GeoIP City binarne datoteke. Ova datoteka nije deo Moodle distribucije i mora biti zasebno preuzeta sa <a href="http://www.maxmind.com/">MaxMind</a>. Možete, ili da kupite komercijalnu ili da koristite besplatnu verziju. Jednostavno preuzmite datoteku <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> i raspakujte je u direktorijum "{$a}" na svom serveru.';
$string['configgetremoteaddrconf'] = 'Ako je Vaš server iza povratnog (reverse) proksija, možete koristiti ovo podešavanje da podesite za koja HTTP zaglavlja se može verovati da sadrže udaljenu adresu. Zaglavlja se čitaju po redu, koristi se prvo dostupno.';
$string['configgradebookroles'] = 'Ova opcija Vam omogućava da kontrolišete ko se pojavljuje u evidenciji ocena. Korisnici treba da imaju najmanje jednu od ovih uloga u kursu da bi bili prikazani u evidenciji ocena tog kursa.';
$string['configgradeexport'] = 'Odaberite koji formati za izvoz knjige ocena su Vaši primarni metodi za izvoz ocena. Izabrani dodaci će onda postaviti i koristiti polje "last exported" za svaku ocenu. Na primer, ovo može kao rezultat dati izvezene ocene označene kao "nove" ili "ažurirane". Ako niste sigurni šta želite da postignete ovim podešavanjima, slobodno ostavite sve opcije nepotvrđene.';
$string['confighiddenuserfields'] = 'Izaberite koja polja sa korisničkim informacijama želite da sakrijete od drugih korisnika koji nisu predavači na kursu ili administratori. Ovo će povećati privatnost korisnika. Držite CTRL taster da biste izabrali više polja.';
$string['configidnumber'] = 'Ova postavka određuje (a) hoće li korisnici uopšte biti pitani za ID broj, (b) hoće li korisnici biti pitani za ID broj, ali će navedeno polje moći ostaviti prazno ili (c) hoće li korisnicima unos u polje ID broj biti obavezan. Ako je ID broj unet, isti se prikazuje u njihovom profilu.';
$string['configintro'] = 'Na ovoj stranici možete da navedete brojne konfiguracione promenljive koje će pomoći da Moodle pravilno funkcioniše na vašem serveru. Ne brinite previše o tome - podrazumevane vrednosti obično su potpuno adekvatne. Kasnije se možete vratiti na ovu stranicu i promeniti podešavanja prema potrebi.';
$string['configintroadmin'] = 'Na ovoj strani bi trebalo da konfigurišite Vaš glavni administratorski nalog koji će imati potpunu kontrolu nad čitavim sajtom. Uverite se da ste nalogu dodelili bezbedno korisničko ime i lozinku, kao i ispravnu elektronsku adresu. Kasnije možete kreirati dodatne administratorske naloge.';
$string['configintrosite'] = 'Ova stranica vam omogućava da konfigurišete izgled naslovne stranice i naziv sajta. Uvek se možete naknadno vratiti na ovu stranicu kako biste promenili ova podešavanja, koristeći meni za administraciju.';
$string['configiplookup'] = 'Kad kliknete na IP adresu (kao što je 34.12.222.93), na primer u izveštajima o aktivnostima, prikazuje Vam se mapa sa najboljom mogućom procenom stvarne lokacije tog IP-a. Ima više dodataka koje možete odabrati za ovu funkciju (svaki nudi neke prednosti, ali i dolazi s odrđenim manjkavostima, pa se korisniku prepušta konačni izbor).';
$string['configkeeptagnamecase'] = 'Čekirajte ovo ako želite da imena oznaka (tagova) zadrže originalna velika i mala slova kako su ih uneli kreatori';
$string['configlang'] = 'Izaberite podrazumevani jezik za ceo sajt. Korisnici mogu da promene ovo podešavanje koristeći jezički meni ili podešavanje u okviru svog ličnog profila.';
$string['configlanglist'] = 'Ostavite ovu opciju praznom ako želite dati Vašim korisnicima pravo na odabir BILO KOG jezičkog paketa instaliranog na nivou Moodle sistema. Međutim, možete skratiti padajući jezički meni unošenjem željenih jezičkih kodova odvojenih zarezima. Primer: en,sr,de,fr,it';
$string['configlangmenu'] = 'Odaberite želite li prikazati padajući meni za odabir jezika interfejsa na početnoj stranici, stranici za prijavljivanje na sistem, itd. Ovo podešavanje ne onemogućava korisnike u odabiru željenog jezika u njihovom ličnom profilu.';
$string['configlangstringcache'] = 'Kešira sve izraze jezika u kompajlirane datoteke u direktorijumu za podatke. Ako prevodite Moodle ili vršite izmene izraza u izvornom kodu Moodlea, onda ćete možda želeti da ovo isključite. Inače ostavite ga uključeno da vidite napredak u radu.';
$string['configlatinexcelexport'] = 'Odaberite kodiranje za izvoz Excel dokumenata.';
$string['configlocale'] = 'Odaberite lokalna podešavanja na nivou celog sajta, što će uticati na oblik prikaza i jezik na kojem se ispisuju datumi. Neophodno je da u okviru Vašeg operativnog sistema imate instaliranu podršku za  odgovarajući jezik (npr. eng_US ili sr). Ako ne znate šta biste odabrali, ostavite ovo polje praznim.';
$string['configloginhttps'] = 'Ukoliko uključite ovu opciju Moodle će koristiti bezbednu https konekciju samo za stranicu za pristup sajtu, a nakon toga će se vratiti na normalni http URL, povećavajući time brzinu rada. OPREZ: ovo podešavanje ZAHTEVA da https bude eksplicitno omogućen na Web serveru - ako nije MOŽETE DOĆI U SITUACIJU DA SAMI SEBI ONEMOGUĆITE PRISTUP SAJTU.';
$string['configloglifetime'] = 'Ovo podešavanje određuje koliko dugo želite da čuvate zapise o aktivnostima korisnika. Zapisi koji su stariji biće automatski obrisani. Najbolje je da zapise o aktivnostima čuvate što je moguće duže, u slučaju da vam zatrebaju, ali ukoliko imate jako opterećen server i ukoliko imate probleme sa njegovim performansama, možete skratiti vremenski period njihovog čuvanja. Vrednosti manje od 30 dana se ne preporučuju zato što statistika možda neće ispravno raditi.';
$string['configlookahead'] = 'Dana unapred za praćenje';
$string['configmaxbytes'] = 'Ovo podešavanje određuje maksimalnu veličinu postavljenih datoteka na nivou celog sajta. Vrednosti ovog podešavanja su ograničene PHP podešavanjima post_max_size i upload_max_filesize, kao i Apache podešavanjem LimitRequestBody. Zauzvrat, maxbytes ograničava opseg veličina koje se mogu birati na nivou kursa ili modula. Ako izaberete opciju \'Ograničenje servera\' biće korišćena maksimalna vrednost koju dozvoljava server.';
$string['configmaxconsecutiveidentchars'] = 'Lozinke ne smeju imati više od ovog broja istovetnih karaktera za redom. Upotrebite 0 kako biste isključili ovu opciju.';
$string['configmaxeditingtime'] = 'Određuje vreme koje korisnici imaju na raspolaganju za naknadno uređivanje poruka na forumima, komentara u rečnicima itd. Obično je 30 minuta sasvim dovoljno.';
$string['configmaxevents'] = 'Broj događaja za praćenje unapred';
$string['configmaxusersperpage'] = 'Maksimalan broj korisnika koji se prikazuje unutar birača korisnika za kurs, grupu, kohortu, veb servis itd.';
$string['configmessaging'] = 'Da li omogućiti korisnicima sajta korišćenje sistema za instant poruke?';
$string['configmessagingallowemailoverride'] = 'Dozvoli da se korisnicima obaveštenja šalju na adresu e-pošte različitu od one koja je navedena u njihovom profilu';
$string['configmessagingdeletereadnotificationsdelay'] = 'Obaveštenja o čitanju mogu se obrisati da se sačuva prostor. Nakon koliko vremena posle čitanja mogu biti obrisana?';
$string['configmessaginghidereadnotifications'] = 'Sakriti obaveštenja o čitanju u vezi sa događajima kao što su poruke na forumima kada se pregleda istorija poruka';
$string['configminpassworddigits'] = 'Lozinke moraju imati najmanje ovoliko brojeva.';
$string['configminpasswordlength'] = 'Lozinke moraju da sadrže najmanje ovoliko karaktera.';
$string['configminpasswordlower'] = 'Lozinke moraju da sadrže najmanje ovoliko malih slova.';
$string['configminpasswordnonalphanum'] = 'Lozinke moraju da sadrže najmanje ovoliko ne-alfanumeričkih karaktera.';
$string['configminpasswordupper'] = 'Lozinke moraju da sadrže najmanje ovoliko velikih slova.';
$string['configmobilecssurl'] = 'CSS datoteka za prilagođavanje interfejsa vaše mobilne aplikacije';
$string['configmodchooserdefault'] = 'Da li birač aktivnosti treba da bude prikazan korisniku';
$string['configmycoursesperpage'] = 'Maksimalan broj kurseva za prikaz na bilo kojoj korisnikovoj listi kurseva';
$string['configmymoodleredirect'] = 'Ovo podešavanje čini obaveznim preusmeravanje na /my pri pristupu sistemu svih korisnika osim administratora i menja postavku osnovnog nivoa sajta na /my';
$string['configmypagelocked'] = 'Ovo podešavanje sprečava da korisnici koji nisu administratori uređuju podrazumevane stranice, poput naslovne stranice sajta.';
$string['confignavcourselimit'] = 'Ogranilčite broj kurseva koji će biti prikazan korisnicima u situaciji kada ili nisu prijavljeni na sistem ili nisu upisani ni na jedan kurs.';
$string['confignavshowallcourses'] = 'Ovo podešavanje određuje da li korisnici, upisani na kurseve, mogu u bloku za navigaciju, pored stavke \'Moji kursevi\' (spisak kurseva na koje su upisani). da vide i stavku \'Kursevi\' (spisak svih kurseva).';
$string['confignavshowcategories'] = 'Prikaži kategorije kurseva u navigacionoj traci i u blokovima za navigaciju Ovo se ne odnosi na kurseve u koje je korisnik trenutno upisan, jer će kursevi, bez kategorija, biti navedeni u meniju pod Moji kursevi (mycourses).';
$string['confignotifyloginfailures'] = 'Ukoliko sistem registruje neuspešne pristupe, obaveštenja o tome biće poslata elektronskom poštom. Ko bi trebalo da vidi ta obaveštenja?';
$string['confignotifyloginthreshold'] = 'Ukoliko je opcija za registrovanje neuspešnih pristupa aktivna, koliki je minimum pogrešnih pristupa po jednom korisniku odnosno jednoj IP adresi neophodan da bi obaveštenje o tome bilo poslato?';
$string['confignotloggedinroleid'] = 'Korisnici koji nisu prijavljeni na sistem biće tretirani kao da im je ova uloga dodeljena u kontekstu sajta. Skoro uvek je uloga gosta ono što biste poželeli za takve slučajeve, ali na ovaj način imate mogućnost da koristite uloge kreirane kao manje ili više restriktivne. Ipak, akcije kao što je slanje poruka na forume i tome slično zahtevaju da korisnik propisno pristupi sistemu.';
$string['configopentogoogle'] = 'Ukoliko uključite ovo podešavanje, onda će Google-u biti omogućeno da ulazi na Vaš sajt kao gost. Osim toga ljudi koji na Vaš sajt budu dolazili posredstvom Google pretraga automatski će biti prijavljeni kao gosti. Napomena: ovo omogućava pristup samo onim kursevima koji i inače dozvoljavaju pristup sa nalogom za gosta.';
$string['configoverride'] = 'Definisano u config.php datoteci';
$string['configpasswordpolicy'] = 'Uključivanje ove opcije će omogućiti da Moodle proverava korisničke lozinke u skladu sa važećim pravilima za kreiranje lozinki. Koristite podešavanja ispod da biste specificirali svoja pravila (ona će biti ignorisana ako ovu opciju postavite na \'Ne\').';
$string['configpasswordresettime'] = 'Ovo određuje vreme koje korisnici imaju na raspolaganju kako bi potvrdili zahtev za resetovanje lozinke, pre nego što ono istekne. Obično je 30 minuta sasvim odgovarajuće vreme.';
$string['configpathtoclam'] = 'Putanja do Clam AV alata. Verovatno nešto poput /usr/bin/clamscan ili /usr/bin/clamdscan. Ovu vrednost je potrebno uneti da bi se koristio Clam AV.';
$string['configpathtodu'] = 'Putanja do du. Verovatno nešto poput /usr/bin/du. Ako ovo unesete, stranice koje prikazuju sadržaj direktorijuma će raditi mnogo brže za direktorijume sa mnogo datoteka.';
$string['configperfdebug'] = 'Ako ovo uključite, informacije o performansama biće prikazane u podnožju standardne grafičke teme';
$string['configprofileroles'] = 'Spisak uloga koje su vidljive na korisničkim profilima i stranici sa spiskom učesnika.';
$string['configprofilesforenrolledusersonly'] = 'Da bi se sprečila zloupotreba od strane spamera, polje za opis na stranici sa profilom korisnika, koji se još nisu upisali ni na jedan kurs, je sakriveno. Novi korisnici moraju da se upišu barem na jedan kurs kako bi mogli da dodaju opis.';
$string['configprotectusernames'] = 'Po podrazumevanim podešavanjima forget_password.php ne prikazuje nikakvu pomoć za pogađanje korisničkih imena ili adresa elektronske pošte.';
$string['configproxybypass'] = 'Spisak sa stavkama odvojenim zarezom (delova) imena servera domaćina ili IP adresa koje bi trebalo da premoste posrednički server (Proxy)(e.g., 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Ukoliko <b>server</b> mora da koristi proksi računar (npr. "zaštitni zid") za pristup Internetu, unesite ovde njegovu adresu i port. U suprotnom ostavite ovo polje prazno.';
$string['configproxypassword'] = 'Lozinka potrebna za pristup internetu putem proksi servera, ukoliko je to neophodno. Ostavite prazno ukoliko proksi server nije potreban (neophodna je PHP cURL ekstenzija)';
$string['configproxyport'] = 'Ako ovaj server mora da koristi proxy računar, navedite ovde proxy port.';
$string['configproxytype'] = 'Tip Web Proxy servera(PHP5 i cURL ekstentija su neophodni za podršku za SOCKS5)';
$string['configproxyuser'] = 'Korisničko ime potrebno za pristup Internetu putem Proxy servera ukoliko je to neopohodno. Ostaviti prazno ukoliko Proxy nije potreban (neophodna je PHP cURL ekstenzija)';
$string['configquarantinedir'] = 'Ukoliko želite da Clam AV premesti inficirane datoteke u karantin, upišite putanju do direktorijuma predviđenog za karantin. Veb serveru mora biti dozvoljen upis u ovaj direktorijum. Ako ostavite ovo polje prazno ili unesete direktorijum koji ne postoji ili ako se u njega ne može upisivati, inficirane datoteke biće obrisane. Nemojte staviti kosu crtu na kraju putanje.';
$string['configrecaptchaprivatekey'] = 'Niz znakova koji se koristi za komunikaciju između vašeg Moodle servera i recaptcha.net servera. Nabavite niz za ovaj Web sajt na http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Niz znakova koji se koristi za prikaz reCAPTCHA elementa na obrascu za prijavu. Niz generiše http://www.google.com/recaptcha';
$string['configrequestcategoryselection'] = 'Dozvoli izbor kategorije prilikom podnošenja zahteva za kurs.';
$string['configrequestedstudentname'] = 'Reč za polaznika koja se koristi u zahtevanim kursevima';
$string['configrequestedstudentsname'] = 'Reč za polaznike koja se koristi u zahtevanim kursevima';
$string['configrequestedteachername'] = 'Reč za predavača koja se koristi u zahtevanim kursevima';
$string['configrequestedteachersname'] = 'Reč za predavače koja se koristi u zahtevanim kursevima';
$string['configrequiremodintro'] = 'Isključite ovu opciju ukoliko ne želite da primoravate korisnike da unose opis svake aktivnosti.';
$string['configrunclamavonupload'] = 'Ako je ova opcija omogućena, clam AV će biti korišćen za proveru svih postavljenih datoteka.';
$string['configrunclamonupload'] = 'Koristiti Clam AV pri postavljanju datoteka? Da bi ovo  podešavanje uspešno radilo, morate navesti tačnu putanju do direktorijuma u kojem se nalazi Clam AV. (Clam AV je BESPLATNI antivirusni softver koji možete preuzeti sa http://www.clamav.net/)';
$string['configsectioninterface'] = 'Interfejs';
$string['configsectionmail'] = 'Pošta';
$string['configsectionmaintenance'] = 'Održavanje';
$string['configsectionmisc'] = 'Razno';
$string['configsectionoperatingsystem'] = 'Operativni sistem';
$string['configsectionpermissions'] = 'Dozvole';
$string['configsectionrequestedcourse'] = 'Zahtev za kursom';
$string['configsectionsecurity'] = 'Bezbednost';
$string['configsectionstats'] = 'Statistika';
$string['configsectionuser'] = 'Korisnik';
$string['configsecureforms'] = 'Moodle može da koristi dodatni nivo bezbednosti kada prima podatke iz Web formi. Ukoliko je to omogućeno, onda se HTTP_REFERER promenljiva Web čitača upoređuje sa tekućom adresom forme. U veoma malom broju slučajeva to može prouzrokavati probleme ako korisnik upotrebljava "zaštitni zid" (npr. Zonealarm) konfigurisan tako da uklanja HTTP_REFERER promenljivu iz Web saobraćaja. Posledica toga je tzv. "zaglavljivanje u formi". Ukoliko Vaši korisnici imaju problema, na primer, sa stranicom za prijavu, možda ćete želeti da onemogućite ovo podešavanje, iako će to Vaš sajt učiniti daleko osetljivijim na hakerske napade razbijanja lozinki grubom silom. Ukoliko ste u dilemi, omogućite ovu opciju.';
$string['configsessioncookie'] = 'Ovo podešavanje prilagođava ime "kolačića" za Moodle sesije. Podešavanje je opciono i korisno je samo da bi se izbegla mešanje "kolačića", u situaciji kada je u okviru istog Web sajta pokrenuto više od jedne kopije Moodlea.';
$string['configsessioncookiedomain'] = 'Ovo Vam dozvoljava da menjate domen sa kog su Moodle kolačići dostupni. To je korisno za razna prilagođavanja Moodlea (npr. dodaci za proveru identiteta ili upis) koji moraju da dele informacije o Moodle sesiji sa Web aplikacijom na drugom poddomenu. <strong>UPOZORENJE: toplo preporučujemo da ovo podešavanje ostavite prazno (podrazumevana vrednost) - neispravna vrednost će sprečiti bilo kakvu prijavu na sajt.</strong>';
$string['configsessioncookiepath'] = 'Ako je potrebno da promenite gde veb čitači šalju Moodle "kolačiće", možete promeniti ovo podešavanje tako što ćete odredite poddirektorijum svog veb sajta. Inače, standardna vrednost \'/\' trebalo bi da je sasvim prihvatljiva.';
$string['configsessiontimeout'] = 'Ukoliko su korisnici koji su prijavljeni na sajt, neaktivni duži vremenski period (ne učitavaju stranice), biće automatski odjavljeni (njihove sesije biće završene). Ova promenljiva određuje koliki bi trebao biti taj vremenski period.';
$string['configshowcommentscount'] = 'Prikaži broj komentara. Biće potrebno izvršiti samo jedan upit više prilikom prikaza linka komentara.';
$string['configshowicalsource'] = 'Prikaži izvorne informacije za ical događaje';
$string['configshowsiteparticipantslist'] = 'Svi ovi polaznici i predavači na nivou sajta biće prikazani na spisku učesnika. Kome će biti dozvoljeno da vidi ovaj spisak učesnika?';
$string['configsitedefaultlicense'] = 'Podrazumevana licenca sajta';
$string['configsitedefaultlicensehelp'] = 'Podrazumevana licenca za objavljivanje sadržaja na ovom sajtu';
$string['configsitemaxcategorydepth'] = 'Maksimalan broj potkategorija';
$string['configsitemaxcategorydepthhelp'] = 'Ovo određuje maksimalan broj potkategorija koji će se pojaviti kada se prikazuju kategorije ili kombinovana lista. Niži nivo kategorija će pojaviti kao linkovi koje će korisnik moći da proširi pomoću AJAX zahteva.';
$string['configslasharguments'] = 'Datoteke (slike, postavljene datoteke i sl.) su dostupne pomoću skripte koja koristi tzv. slash argument. Ovaj metod omogućava da datoteke budu lakše keširane u veb čitaču, proksi serverima itd. Nažalost, neki PHP serveri ne dozvoljavaju korišćenje ovog metoda, tako da ukoliko imate problema da vidite postavljene datoteke ili slike (npr. slike korisnika), onda onemogućite ovo podešavanje.';
$string['configsmartpix'] = 'Ako se ova opcija uključi ikonice će učitavati PHP skript koji pretražuje tekuću grafičku temu sajta, potom sve nadređene teme, i konačno Moodle /pix direktorijum. Ovo smanjuje potrebu za čuvanjem duplikata slika unutar tema, ali pomalo utiče na performanse sistema.';
$string['configstartwday'] = 'Dan kojim počinje radna nedelja';
$string['configstatsfirstrun'] = 'Ovo određuje koliki vremenski interval se uzima u obzir pri procesiranju izveštaja o aktivnostima <b>prvi put</b> kada cronjob želi da procesira statističke podatke. Ako imate dosta saobraćaja i na deljenom ste serveru, verovatno nije dobra ideja da idete previše unazad, jer bi moglo biti potrebno previše vremena za izvršavanje procesa i ta aktivnost bi bila prilično zahtevna za server. (Primetite da je za ovo podešavanje 1 mesec = 28 dana. Na grafikonima i izveštajima koji se generišu 1 mesec odgovara jednom kalendarskom mesecu.)';
$string['configstatsmaxruntime'] = 'Procesiranje statističkih podataka može biti prilično intenzivno, pa koristite kombinaciju ovog i sledećeg polja da specificirate kada će se ono izvršavati i koliko dugo će trajati.';
$string['configstatsmaxruntime2'] = 'Statistička obrada može biti prilično intezivna. Odredite maksimalno vreme koje se dopušta za prikupljanje statističkih podataka za jedan dan. Maksimalni broj dana koji se obrađuje u jednom izvršenju crona je 31.';
$string['configstatsmaxruntime3'] = 'Ovo određuje maksimalno dozvoljeno vreme za izračunavanje statistike za jedan dan. Imajte u vidu da procesiranje statističkih podataka može u velikoj meri opteretiti server. Maksimalna broj dana obrađenih u jednom kronu može biti dole određen.';
$string['configstatsruntimedays'] = 'Ovo određuje maksimalan broj dana koji se obrađuje prilikom svakog procesuiranja statistike. Kada je statistika ažurna, samo će se jedan dan obrađivati - zato podesite ovu vrednost zavisno od opterećenja vašeg servera, smanjujući je ako su potrebna kraća pokretanja crona.';
$string['configstatsruntimestart'] = 'U koje vreme treba da započne sa izvršavanjem cronjob koji procesira statističke podatke? Ukoliko na serveru ima više Moodle sajtova, preporučljivo je navesti različita vremena.';
$string['configstatsuserthreshold'] = 'Ovo podešavanje određuje minimalan broj upisanih korisnika, potreban da bi kurs bio uključen u statističko izračunavanje.';
$string['configstrictformsrequired'] = 'Ako je ovo podešavanje omogućeno, korisnicima neće biti dozvoljeno da unose razmak ili prelaz u novi red, ali samo unutar obaveznih polja u obrascima.';
$string['configstripalltitletags'] = 'Isključite ovo podešavanje da biste omogućili HTML oznake u imenima aktivnosti i resursa.';
$string['configsupportemail'] = 'Ova adresa elektronske pošte će se prikazivati korisnicima sajta kao ona na koju treba pisati kad im je potrebna neka opšta pomoć (na primer kad novi korisnici kreiraju svoje naloge). Ako se ne popuni ovo polje, onda takva korisna adresa neće biti dostupna.';
$string['configsupportname'] = 'Ovo je ime osobe/organizacije zadužene za pružanje opšte pomoći korisnicima putem elektronske pošte ili Web sajta.';
$string['configsupportpage'] = 'Ova Web adresa će se prikazivati korisnicima sajta kao ona koju treba posetiti u slučaju da im zatreba neka opšta pomoć (na primer kad novi korisnici kreiraju svoje naloge). Ako se ne popuni ovo polje, takav link neće biti dostupan.';
$string['configthemedesignermode'] = 'Uobičajeno je da se sve slike grafičke teme kao i CSS datoteke na duži vremenski period keširaju u veb čitaču i na serveru, zbog brzine izvršavanja. Ako dizajnirate teme ili razvijate izvorni kôd, verovatno ćete želite da uključiti ovaj režim rada kako bi ste izbegli da dobijate verzije iz keša. Upozorenje: ovo će usporiti vaš sajt za sve korisnike! Alternativno, možete da resetujete keš ručno na stranici za izbor teme.';
$string['configthemelist'] = 'Ostavite ovo polje prazno da biste dozvolili upotrebu bilo koje grafičke teme. Ukoliko želite da skratite listu tema, ovde možete da navedite spisak njihovih naziva, razdvojenih zarezima (nemojte koristiti razmake!).
Na primer: standard,orangewhite.';
$string['configtimezone'] = 'Ovo je podrazumevana vremenska zona za prikazivanje datuma - svaki korisnik može da promeni ovo podešavanje u svom profilu. "Vremenska zona servera" ovde podešena uslovi će da Moodle kao podrazumevanu vrednost koristi PHP podešavanje servera. Ukoliko korisnik u svom profilu izabere opciju "Vremenska zona servera" za njega će podrazumevana vremenska zona biti ona koju ovde podesite. Preporučuje se da ažurirate vremenske zone, a zatim izaberite vremensku zonu koja odgovara vašem regionu.';
$string['configuseblogassociations'] = 'Da li je potrebno da korisnici mogu da organizuju svoje blogove povezivanjem članaka sa kursevima i modulima kursa?';
$string['configuseexternalyui'] = 'Umesto lokalnih datoteka, koristite onlajn datoteke dostupne na Yahoo serverima. UPOZORENJE: Ovo zahteva Internt konekciju, ili AJAX uopšte neće raditi na Vašem sajtu.';
$string['configuserquota'] = 'Maksimalan broj bajtova koje korisnik može da sačuva u svom prostoru za privatne datoteke. {$a->bytes} bajtova == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Ako je ovo podešavanje omogućeno, onda će se u navigaciji za stranice sajta, umesto fraze \'Stranice sajta\', koristiti skraćeni naziv sajta.';
$string['configusetags'] = 'Da li treba omogućiti oznake (tagove) na čitavom sajtu?';
$string['configvariables'] = 'Promenljive';
$string['configverifychangedemail'] = 'Omogući potvrdu promenjenih e-adresa koji koristeći podešavanje za dozvoljene i zabranjene domene e-adresa. Ukoliko je ovo podešavanje isključeno ograničenje domena će biti korišćeno samo prilikom kreiranja novih korisničkih naloga.';
$string['configvisiblecourses'] = 'Normalno prikazuje kurseve koji su u skrivenim kategorijama.';
$string['configwarning'] = 'Budite oprezni pri menjanju ovih podešavanja - čudne vrednosti mogu izazvati probleme u radu.';
$string['configyuicomboloading'] = 'Ova opcija omogućava optimizaciju učitavanje kombinovanih datoteka YUI biblioteke. Ovo podešavanje treba da bude uključeno na produkcionim sajtovima zbog boljih performansi.';
$string['confirmation'] = 'Potvrda';
$string['confirmdeletecomments'] = 'Obrisaćete komentare. Da li ste sigurni?';
$string['confirmed'] = 'Potvrđeno';
$string['convertformat'] = '<i>konvertuj</i> izlazni format';
$string['cookiehttponly'] = 'Samo http kolačići';
$string['cookiesecure'] = 'Samo bezbedni kolačići';
$string['country'] = 'Podrazumevana država';
$string['coursecontact'] = 'Kurs - kontakt osobe';
$string['coursecontact_desc'] = 'Ovo podešavanje vam omogućava da odredite ko se pojavljuje na stranici sa opisom kursa. Korisnici moraju da imaju barem jednu od ovih uloga na kursu kako bi njihova imena bila prikazani pored opisa tog kursa.';
$string['courselistshortnames'] = 'Prikaži pune nazive kurseva';
$string['courselistshortnames_desc'] = 'Ako je ova opcija omogućena, na spisku kurseva će, pored punih naziva, biti prikazani i skraćeni nazivi kurseva. Ako je neophodno, prošireni nazivi kurseva se mogu prilagoditi uređivanjem jezičkog stringa \'courseextendednamedisplay\', koristeći mogućnost za prilagođavanje jezika.';
$string['coursemgmt'] = 'Upravljanje kursevima i kategorijama';
$string['courseoverview'] = 'Pregled kurseva';
$string['courserequestnotify'] = 'Obaveštenje o zahtevu za pokretanje novog kursa';
$string['courserequestnotifyemail'] = 'Korisnik {$a->user} je zatražio/la novi kurs na {$a->link}';
$string['courserequests'] = 'Zahtevi za pokretanje novog kursa';
$string['courserequestspending'] = 'Zahtevi za pokretanje kurs na čekanju';
$string['courses'] = 'Kursevi';
$string['coursesperpage'] = 'Kurseva po stranici';
$string['courseswithsummarieslimit'] = 'Broj kurseva sa rezimeom';
$string['creatornewroleid'] = 'Uloga kreatora u novim kursevima';
$string['creatornewroleid_help'] = 'Ukoliko korisnik već nema ovlašćenja da upravlja novim kursom, onda je automatski upisan koristeći ovu ulogu';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Pokretanje Crona isključivo preko komandne linije';
$string['cronerrorclionly'] = 'Žalim, internet pristup ovoj stranici je onemogućen od strane administratora.';
$string['cronerrorpassword'] = 'Žao nam je, niste uneli ispravnu lozinku da biste pristupili ovoj stranici';
$string['cron_help'] = 'Cron.php pomaže nekim od Moodle modula u obavljanju zadataka u pravilnim vremenskim  intervalima, kao što je slanje kopija novih poruka sa foruma putem e-pošte. Potrebno je redovno pokretanje cron skripte, npr. na svakih 5 minuta.';
$string['cronremotepassword'] = 'Cron lozinka za udaljeni pristup';
$string['cronwarning'] = '<a href="cron.php">cron.php skript za održavanje</a> nije pokretan najmanje poslednja 24 sata.';
$string['ctyperecommended'] = 'Instaliranje opcione PHP ekstenzije ctype se strogo preporučuje da bi se unapredilo funkcionisanje sajta, pogotovo ako Vaš sajt podržava ne-latinične jezike.';
$string['ctyperequired'] = 'PHP ekstenzije ctype je sada obavezna za Moodle, da bi se unapredilo funkcionisanje sajta i da bi se nudila višejezična kompatibilnost.';
$string['curlcache'] = 'cURL keš TTL';
$string['curlrecommended'] = 'Instaliranje opcione cURL biblioteke je vrlo preporučljivo, da bi se omogućilo korišćenje funkcija za umrežavanje (Moodle Networking).';
$string['curlrequired'] = 'PHP ekstenzijа cURL sada je obavezna za Moodle zbog komunikacije sa Moodle repozitorijumima.';
$string['curltimeoutkbitrate'] = 'Brzina protoka u bitovima koja se koristi prilikom izračunvanja cURL tajmauta (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Ovo podešavanje se koristi za izračunavanje odgovarajućeg tajm-auta kod velikih cURL zahteva. Kao deo ovog proračuna kreira se HTTP HEAD zahtev kako bi se odredila veličina sadržaja. Postavljanjem ovog parametra na 0 onemogućava se kreiranje ovog zahteva.';
$string['currenttheme'] = 'Trenutna grafička tema';
$string['customcheck'] = 'Druge provere';
$string['custommenu'] = 'Prilagođeni meni';
$string['custommenuitems'] = 'Stavke prilagođenog menija';
$string['datarootsecurityerror'] = '<p><strong>BEZBEDNOSNO UPOZORENjE!</strong></p><p>Vaš direktorijum sa podacima je na pogrešnom mestu i moguće mu je pristupiti sa veba. To znači da su sve vaše privatne datoteke dostupne svakome ko ima pristup internetu, pa neke od njih mogu iskoristiti zlonamerni korisnici kako bi dobili neautorizovan administratorski pristup vašem sajtu!</p>
<p><em>Morate</em> da premestite direktorijum sa podacima ({$a}) na novu lokaciju koja nije u okviru vašeg javnog veb direktorijuma, a potom da ažurirate <code>$CFG->dataroot</code> podešavanje u datoteci config.php u skladu sa načinjenim promenama.</p>';
$string['datarootsecuritywarning'] = 'Konfiguracija vašeg sajta možda nije bezbedna. Molimo proverite da li vaš direktorijum podataka ({$a}) nije direktno dostupan preko veba.';
$string['dbmigrate'] = 'Migracija Moodle baze podataka';
$string['dbmigrateconnecerror'] = 'Nije moguće uspostaviti vezu sa specificiranom bazom podataka.';
$string['dbmigrateencodingerror'] = 'Specificirana baza podataka ima kodiranje {$a}, a ne neophodno UNICODE/UTF8.<br />Molimo navedite drugu bazu.';
$string['dbmigratepostgres'] = 'Čini se da koristite PostgreSQL kao server baze podataka. Da biste nastavili sa migracionim procesom morate ručno kreirati novu bazu sa kodiranjem "UNICODE"(PostgreSQL 7) ili "UTF8" (PostgreSQL 8) za čuvanje migriranih podataka. Molimo unesite podešavanja za povezivanje sa Vašom novom bazom podataka ispod da biste nastavili:';
$string['dbmigratewarning'] = 'Pre nego što započnete ovu proceduru, molimo proverite da li ste napravili rezervnu kopiju svoje Moodle baze podataka. Ako niste sigurni kako da to uradite, kontaktirajte svog sistem administratora. Vaš Moodle sajt će biti stavljen u režim održavanja nakon što započnete proces migracije';
$string['dbmigratewarning2'] = '<b>Upozorenje: Upravo ćete započeti proces migracije baze podataka. Molimo proverite da li je napravljena rezervna kopija Vaše kompletne Moodle baze podataka.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Ova baza podataka migrirana je na novu UTF8 bazu, te se smatra zastarelom. Molimo podesite Vašu config.php datoteku i koristite novu bazu podataka za ovu Moodle verziju.</font>';
$string['dbmigrationdupfailed'] = 'Dupliranje baze podataka nije uspelo. Moguća greška  do koje je došlo je:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Korišćenje baze podataka za informacije o sesijama';
$string['debug'] = 'Poruke za otklanjanje grešaka';
$string['debugall'] = 'SVE: Prikaži sve razumljive PHP poruke o greškama';
$string['debugdeveloper'] = 'RAZVOJNE: Prikaži dodatne Moodle poruke o greškama, namenjene samo programeri';
$string['debugdisplay'] = 'Prikaži poruke za otklanjanje grešaka';
$string['debugging'] = 'Otklanjanje grešaka';
$string['debugminimal'] = 'MINIMALNO: Prikaži samo fatalne greške';
$string['debugnone'] = 'BEZ PORUKE: Ne prikazuj greške ili upozorenja';
$string['debugnormal'] = 'NORMALNO: Prikaži greške, upozorenja i obaveštenja';
$string['debugpageinfo'] = 'Prikaži informacijе o stranici';
$string['debugsmtp'] = 'Otklanjanje grešaka tokom slanja e-pošte';
$string['debugstringids'] = 'Prikaži poreklo jezičkih izraza';
$string['debugstringids_desc'] = 'Ova opcija je osmišljena kako bi  pomogla prevodiocima. Kada je ova opcija omogućena, ako URL adresi dodate parametar strings=1, to će prikazati jezičku datoteku i id stringa pored svakog stringa (izraza).';
$string['debugvalidators'] = 'Prikaži link ka servisima za proveru validnosti';
$string['defaultcity'] = 'Podrazumevani grad';
$string['defaultcity_help'] = 'Grad koji ovde unesete biće podrazumevani grad za sve novootvorene korisničke naloge.';
$string['defaultformatnotset'] = 'Greška prilikom određivanja podrazumevanog formata kursa. Proverite podešavanja sajta.';
$string['defaulthomepage'] = 'Podrazumavana početna stranica za korisnike';
$string['defaultrequestcategory'] = 'Podrazumevana kategorija za zahtevane kurseve';
$string['defaultsettinginfo'] = 'Podrazumevana vrednost: {$a}';
$string['defaultuserroleid'] = 'Podrazumevana uloga za sve korisnike';
$string['deleteincompleteusers'] = 'Obriši nepotpune korisničke naloge nakon';
$string['deleteunconfirmed'] = 'Obriši nepotvrđene korisnike nakon';
$string['deleteuser'] = 'Obriši korisnika';
$string['density'] = 'Gustina';
$string['denyemailaddresses'] = 'Nedozvoljeni domeni e-pošte';
$string['development'] = 'Razvoj';
$string['devicedetectregex'] = 'Regularni izrazi za detekciju uređaja';
$string['devicedetectregex_desc'] = '<p>Standardno, Moodle može da detektuje podrazumevani tip uređaja (stoni i prenosivi računari itd.), mobilni uređaj (pametni telefoni, ručni računari) tablet (iPad, Android tableti) kao i starije tipove Web čitača (Internet Explorer 6 korisnici). Pomoću selektora grafičke teme moguće je za svaki od ovih tipova uređaja podesiti zasebnu tema. Ovo podešavanje dozvoljava korišćenje regularnih izraza koji omogućavaju detekciju dodatnih tipova uređaja (ovi imaju prednost u odnosu na podrazumevane tipove).</p>
<p>Na primer, možete da unesete regularni izraz \'/(MIDP-1.0|Maemo|Windows CE)/\'  za detekciju nekih najčešće korišćenih telefona dodajte povratnu vrednost \'featurephone\'. Ovo dodaje \'featurephone\' u selektor grafičke teme što će vam omogućiti da dodate temu koja će se koristiti na ovim uređajima. Ostali telefoni će i dalje koristiti temu koja je izabrana za mobilne uređaje.</p>';
$string['devicedetectregexexpression'] = 'Regularni izrazi';
$string['devicedetectregexvalue'] = 'Povratna vrednost';
$string['devicetype'] = 'Tip uređaja';
$string['disableuserimages'] = 'Isključi slike u korisničkom profilu';
$string['displayerrorswarning'] = 'Omogućavanje podešavanja u PHP-u <em>display_errors</em> nije preporučljivo na produkcionim sajtovima, jer neke poruke o greškama mogu otkriti osetljive informacije o vašem serveru.';
$string['displayloginfailures'] = 'Prikaži neuspešne prijave';
$string['dndallowtextandlinks'] = 'Postavljanje teksta/linkova pomoću opcije \'prevuci i spusti\'';
$string['docroot'] = 'Korenski direktorijum Moodle dokumentacije';
$string['doctonewwindow'] = 'Otvoriti u novom prozoru';
$string['download'] = 'Preuzmi';
$string['edithelpdocs'] = 'Uređivanje dokumenata pomoći';
$string['editingnoncorelangfile'] = 'Pokušavate da uredite prevod dodatka (dodatnog modula). Možete sačuvati prevod nezavisnih (3rd party) modula samo u svom lokalnom ( _local) direktorijumu. Možda ćete želeti da premestiti datoteku sa prevodom u jezički direktorijum modula i/ili da ga pošaljete osobi koja održava dodatni modul.';
$string['editlang'] = '<b>Uređivanje</b>';
$string['editorbackgroundcolor'] = 'Boja pozadine';
$string['editordictionary'] = 'Editor rečnika';
$string['editorfontfamily'] = 'Familija fontova';
$string['editorfontlist'] = 'Spisak fontova';
$string['editorfontsize'] = 'Veličina fonta';
$string['editorhidebuttons'] = 'Skrivena dugmad';
$string['editorkillword'] = 'Filter Word formata';
$string['editorspelling'] = 'Editor pravopisa';
$string['editorspellinghelp'] = 'Uključi/isključi proveru pravopisa. Kada je uključeno, <strong>aspell</strong> mora biti instaliran na serveru.';
$string['editstrings'] = 'Uređivanje reči ili izraza';
$string['emailchangeconfirmation'] = 'Potvrda izmene adrese e-pošte';
$string['emoticonalt'] = 'Alternativni tekst';
$string['emoticoncomponent'] = 'Grafička komponenta emotikona';
$string['emoticonimagename'] = 'Naziv slike';
$string['emoticons'] = 'Emotikoni';
$string['emoticons_desc'] = 'Na ovoj stranici možete podesiti emotikone koji se koriste na vašem sajtu. Kako biste uklonili red iz tabele (odnosno neki emotikon) obrišite sadržaj bilo kog od zahtevanih polja i sačuvajte obrazac. Za dodavanje novog emotikona, popunite polja u poslednjem praznom redu. Za resetovanje svih polja na podrazumevane, početne vrednosti kliknite na gornji link.

* Tekst (obavezno) - ovaj tekst će biti zamenjen sa slikom emotikona. Mora sadržati bar 2 karaktera.
* Naziv slike (obavezno) - naziv datoteka sa slikom emotikona (bez ekstenzije), relativno u odnosu na pix direktorijum komponente.
* Grafička komponenta (obavezno) - komponenta koja obezbeđuje ikonicu.
* Alternativni tekst (opciono) - identifikator stringa i komponenta alternativnog teksta emotikona.';
$string['emoticonsreset'] = 'Resetuj podešavanja emotikona na podrazumevane vrednosti';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Prazno';
$string['enableajax'] = 'Uključi AJAX';
$string['enableblogs'] = 'Omogući blog';
$string['enablecalendarexport'] = 'Omogući izvoz kalendara';
$string['enablecomments'] = 'Omogući komentare';
$string['enablecourserequests'] = 'Omogući slanje zahteva za pokretanje novih kurseva';
$string['enablecssoptimiser'] = 'Omogući optimizaciju CSS-a';
$string['enablecssoptimiser_desc'] = 'Kada je ova opcija omogućena CSS će pre keširanja biti pokrenut kroz proces optimizacije. Ovaj proces obrađuje CSS tako što uklanja duplikate pravila i stilova, kao i razmake koji se mogu ukloniti, i tako što ga reformatira. Molimo vas, imajte u vidu da uključivanje ove opcije u isto vreme kada je uključen i režim za dizajniranje tema, ima ozbiljne posledice na performanse sistema, ali pomaže dizajnerima tema da kreiraju optimizovani CSS.';
$string['enabled'] = 'Omogućeno';
$string['enabledevicedetection'] = 'Omogućite detekciju uređaja';
$string['enablegravatar'] = 'Omogući Gravatar';
$string['enablegravatar_help'] = 'Kada je ova opcija omogućena Moodle će pokušati da preuzme sliku za profil sa Gravatara, ako korisnik nije postavio svoju sliku.';
$string['enablegroupmembersonly'] = 'Omogući samo članovima grupe';
$string['enablemobilewebservice'] = 'Omogućite veb servise za mobilne uređaje';
$string['enablerecordcache'] = 'Uključi keš za zapis podataka';
$string['enablerssfeeds'] = 'Omogući RSS izvore vesti';
$string['enablesafebrowserintegration'] = 'Omogući Safe Exam Browser integraciju';
$string['enablestats'] = 'Omogući statistiku';
$string['enabletgzbackups'] = 'Omogući novi format rezervne kopije';
$string['enabletgzbackups_desc'] = 'Ako je ova opcija omogućena, buduće rezervne kopije biće kreirane u novom komprimovanom formatu za .mbz datoteke (interno uskladištene kao .tar.gz datoteka). Ovo uklanja ograničenje veličine datoteke rezervne kopije od 4GB i može da unapredi performanse sistema. Proces restauracije rezervne kopije podržava oba formata, a razlika između njih treba da bude transparentna za korisnike.';
$string['enabletgzbackups_nozlib'] = 'PHP ekstenzija &lsquo;zlib&rsquo; nije dostupna. Novi format rezervne kopije počiva na ovoj ekstenziji i biće onemogućen sve dok  zlib ne bude instaliran i omogućen.';
$string['enabletrusttext'] = 'Omogući pouzdani sadržaj';
$string['enablewebservices'] = 'Omogući Web servise';
$string['enablewsdocumentation'] = 'Dokumentacija Web servisa';
$string['enrolinstancedefaults'] = 'Podrazumevane vrednosti instance upisa';
$string['enrolinstancedefaults_desc'] = 'Podrazumevana podešavanja upisa u novim kursevima';
$string['enrolmultipleusers'] = 'Upisati korisnike';
$string['environment'] = 'Okruženje';
$string['environmenterrortodo'] = 'Morate rešiti sve probleme okruženja (greške) navedene iznad pre nastavka instalacije ove Moodle verzije!';
$string['environmenterrorupgrade'] = 'UPOZORENJE: Trebate rešiti sve pronađene probleme okruženja (greške) pre nego što nastavite nadogradnju Mudlea. Prelaz na novu verziju bez ispravljanja pronađenih grešaka mogu dovesti do gubitka podataka. Da li ste sigurni da želite da nastavite nadogradnju?';
$string['environmentmustfixsetting'] = 'PHP podešavanje mora biti promenjeno.';
$string['environmentok'] = 'Vaše serversko okruženje zadovoljava sve minimalne zahteve.';
$string['environmentrecommendcustomcheck'] = 'ukoliko ovaj test ne prođe, postoji mogućnost pojavljivanja potencijalnog problema.';
$string['environmentrecommendinstall'] = 'je preporučljivo instalirati/omogućiti da bi se dobili najbolji rezultati';
$string['environmentrecommendversion'] = 'preporučena verzija je {$a->needed} a Vi trenutno koristite verziju {$a->current}';
$string['environmentrequirecustomcheck'] = 'Ovaj test mora proći';
$string['environmentrequireinstall'] = 'mora biti instaliran i omogućen';
$string['environmentrequireversion'] = 'neophodna verzija je {$a->needed} a Vi trenutno koristite verziju {$a->current}';
$string['environmentsettingok'] = 'detektovano je preporučeno podešavanje';
$string['environmentshouldfixsetting'] = 'PHP podešavanje bi trebalo biti promenjeno.';
$string['environmentxmlerror'] = 'Greška u čitanju podataka okruženja ({$a->error_code})';
$string['errordeletingconfig'] = 'U toku brisanja konfiguracionog zapisa za dodatak \'{$a}\' pojavila se greška.';
$string['errorsetting'] = 'Nije moguće sačuvati podešavanje';
$string['errorwithsettings'] = 'Neka podešavanja nisu promenjena zbog greške.';
$string['everyonewhocan'] = 'Svako ko može \'{$a}\'';
$string['exceptions'] = 'izuzeci';
$string['execpathnotallowed'] = 'Podešavanje izvršnih putanja u datoteci config.php je onemogućeno';
$string['experimental'] = 'Eksperimentalno';
$string['experimentalsettings'] = 'Eksperimentalna podešavanja';
$string['extendedusernamechars'] = 'Dozvoliti prošireni izbor karaktera u korisničkim imenima';
$string['extramemorylimit'] = 'Dodatno PHP memorijsko ograničenje.';
$string['fatalmagicquotesruntime'] = '<p>Uočena je ozbiljna konfiguraciona greška. Molimo vas, obavestite administratorea.</p><p> Kako bi funkcionisao pravilno Moodle zahteva da administrator promeni PHP podešavanja.</p><p><code>magic_quotes_runtime</code> mora biti podešen na <code>off</code>.</p><p>Ovo podešavanje se može promenti editovanjem <code>php.ini</code>datooteke, konfigutacojom Apache/IIS severa<br />ili <code>.htaccess</code> datoteke na serveru.</p>';
$string['fatalsessionautostart'] = '<p>Otkrivena je ozbiljna konfiguraciona greška. Molimo Vas da obavestite administratora.</p><p> Kako bi funkcionisao pravilno Moodle zahteva da administrator promeni PHP podešavanja.</p>
<p><code>session.auto_start</code> mora biti podešen na <code>off</code>.</p>
<p>Ovo podešavanje se može promenti editovanjem <code>php.ini</code>datoteke, konfiguracijom Apache/IIS severa<br />ili <code>.htaccess</code> datoteke na serveru.</p>';
$string['filecreated'] = 'Kreirana je nova datoteka';
$string['filestoredin'] = 'Snimi datoteku u direktorijum:';
$string['filestoredinhelp'] = 'Gde će datoteka biti smeštena';
$string['filterall'] = 'Filtriraj sve stringove';
$string['filtermatchoneperpage'] = 'Poklapanje filtera jednom po stranici';
$string['filtermatchonepertext'] = 'Poklapanje filtera jednom po tekstu';
$string['filters'] = 'Filteri';
$string['filtersettings'] = 'Upravljanje filterima';
$string['filtersettingsgeneral'] = 'Opšta podešavanja filtera';
$string['filteruploadedfiles'] = 'Filtriraj postavljene datoteke';
$string['forcelogin'] = 'Primoraj korisnike da se prijave na sistem';
$string['forceloginforprofileimage'] = 'Primoraj korisnike da se prijave na sistem da bi mogli da vide slike korisnika';
$string['forceloginforprofileimage_help'] = 'Ako je ovo podešavanje omogućeno, korisnici moraju da budu prijavljeni na sistem kako bi mogli da vide slike drugih korisnika. U suprotnom videće podrazumevanu sliku za korisnika u svim elektronskim porukama.';
$string['forceloginforprofiles'] = 'Primoraj korisnike da se prijave na sistem za profile';
$string['forcetimezone'] = 'Obavezna vremenska zona';
$string['formatuninstallwithcourses'] = 'Postoji/e {$a->count} kurs/a/eva koji koriste  {$a->format}. Format ovih kurseva biće promenjen u  {$a->defaultformat} (podrazumevani format za ovaj sajt). Neki podaci koji su specifični za pojedine formate mogu se izgubiti .Da li ste sigurni da želite da nastavite?';
$string['frontpage'] = 'Naslovna stranica';
$string['frontpagebackup'] = 'Rezervna kopija naslovne stranice';
$string['frontpagedefaultrole'] = 'Podrazumevana uloga za naslovnu stranicu';
$string['frontpagefilters'] = 'Filteri naslovne stranice';
$string['frontpageloggedin'] = 'Stavke na naslovnoj stranici kada je korisnik prijavljen na sistem';
$string['frontpageoverrides'] = 'Promene ovlašćenja na naslovnoj stranici';
$string['frontpagequestions'] = 'Pitanja naslovne stranice';
$string['frontpagerestore'] = 'Restauracija naslovne stranice';
$string['frontpageroles'] = 'Uloge na naslovnoj stranici';
$string['frontpagesettings'] = 'Podešavanja naslovne stranice';
$string['fullnamedisplay'] = 'Format punog imena';
$string['fullnamedisplayprivate'] = 'Format punog imena - privatno';
$string['gdrecommended'] = 'GD ekstenzija se koristi za konverziju slika; neke opcije, kao što su slike korisnika na stranici sa profilom neće biti dostupne ukoliko ova ekstenzija nedostaje.';
$string['gdrequired'] = 'Moodle sada zahteva GD ekstenziju za konverziju slika';
$string['generalsettings'] = 'Opšta podešavanja';
$string['geoipfile'] = 'GeoIP city datoteka';
$string['getremoteaddrconf'] = 'Izvor zabeležene IP adrese';
$string['globalswarning'] = '<p><strong>BEZBEDNOSNO UPOZERENjE!</strong></p><p> Kako bi mogao da funkcioniše ispravno, Moodle zahteva <br />da napravite neke izmene u vašim trenutnim PHP podešavanjima.<p/><p><em>Morate</em> da postavite <code>register_globals=off</code>.</p><p>Ovo podešavanje možete izmeniti tako što ćete urediti vašu <code>php.ini</code> datoteku, konfiguraciju Apache/IIS Web servera<br /> ili <code>.htaccess</code> datoteku.</p>';
$string['googlemapkey3'] = 'Google Maps API V3 ključ';
$string['googlemapkey3_help'] = 'Da biste koristili Google Maps za lociranje IP adrese potrebno je da unesete specijalni ključ. Ključ možete dobiti besplatno na <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Idi na prvi izraz koji nedostaje';
$string['gradebook'] = 'Evidencija ocena';
$string['gradebookroles'] = 'Ocene uloga';
$string['gradeexport'] = 'Primarni metodi za izvoz ocena';
$string['gravatardefaulturl'] = 'URL adresa podrazumevane Gravatar slike';
$string['gravatardefaulturl_help'] = 'Gravatar traži podrazumevanu sliku za prikazivanje, ukoliko nije u mogućnosti da pronađe sliku datog korisnika. Unesite punu URL adresu slike. Ako podešavanje ostavite prazno, Moodle će pokušati da upotrebi podrazumevanu sliku koja je najprikladnija za stranicu koju posmatrate. Imajte na umu da Gravatar ima niz kodova koji mogu da se koriste za <a href="https://en.gravatar.com/site/implement/images/#default-image"> generisanje podrazumevanih slika </a>.';
$string['groupenrolmentkeypolicy'] = 'Pravila za lozinku za upis u grupu';
$string['groupenrolmentkeypolicy_desc'] = 'Uključivanjem ove opcije Moodle će proveravti lozinke za upis u grupu prema važećim pravilima o lozinkama';
$string['guestroleid'] = 'Uloga za gosta';
$string['guestroleid_help'] = 'Ova uloga se automatski dodjeljuje gostu. Ona se dodeljuje privremeno i neupisanim korisnicima koji pristupaju kursu preko dodatka za upis gostiju.';
$string['helpadminseesall'] = 'Da li administratori vide sve događaje iz kalendara ili samo one koje se odnose na njih?';
$string['helpcalendarcustomexport'] = 'Omogući opciju za prilagođeni vremenski okvir u izvozima kalendara. Prethodno moraju biti omogućeni izvozi kalendara, kako bi ova opcija bila moguća.';
$string['helpexportlookahead'] = 'Koliko dana unapred će kalendar tražiti dešavanja prilikom izvoza, za opciju prilagođenog izvoza?';
$string['helpexportlookback'] = 'Koliko dana unazad će kalendar tražiti dešavanja prilikom izvoza, za opciju prilagođenog izvoza?';
$string['helpforcetimezone'] = 'Možete dozvoliti korisnicima da sami izaberu vremensku zonu, ili ih primorati da koriste onu koju ste Vi izabrali.';
$string['helpshowicalsource'] = 'Ako je ova opcija omogućena, naziv pretplate i link biće prikazani za iCal-uvezene događaje.';
$string['helpsitemaintenance'] = 'Za nadogradnje i ostale poslove održavanja sistema';
$string['helpstartofweek'] = 'Kojim danom započinje sedmica u kalendaru?';
$string['helpupcominglookahead'] = 'Koliko dana unapred će kalendar tražiti predstojeća dešavanja?';
$string['helpupcomingmaxevents'] = 'Koliko se (maksimalno) narednih događaja prikazuje korisnicima?';
$string['helpweekenddays'] = 'Koji dani u sedmici se smatraju vikendom i prikazuju u drugoj boji?';
$string['hiddenuserfields'] = 'Sakrivanje korisničkih polja';
$string['hidefromall'] = 'Sakrij od svih korisnika';
$string['hidefromnone'] = 'Ne sakrivati';
$string['hidefromstudents'] = 'Sakrij od polaznika';
$string['htmleditor'] = 'HTML editor';
$string['htmleditorsettings'] = 'Podešavanja HTML editora';
$string['htmlsettings'] = 'HTML podešavanja';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP bezbednost';
$string['hubs'] = 'Čvorišni serveri';
$string['iconvrecommended'] = 'Instaliranje opcione ICONV biblioteke je vrlo preporučljivo u cilju unapređivanja performansi sajta, pogotovo ako vaš sajt podržava jezike koji ne koriste latinično pismo.';
$string['iconvrequired'] = 'Potrebno je instalirati ICONV ekstenziju.';
$string['ignore'] = 'Ignoriši';
$string['includemoduleuserdata'] = 'Uključujući podatke korisnika modula';
$string['incompatibleblocks'] = 'Nekompatibilni blokovi';
$string['installhijacked'] = 'Instalacija mora biti završena sa originalne IP adrese.';
$string['installsessionerror'] = 'Nije moguće započeti PHP sesiju. Molimo Vas da proverite da li Vaš Web čitač prihvata kolačiće.';
$string['intlrecommended'] = 'Intl ekstenzija se koristi za unapređenje internacionalne podrške, kao što je sortiranje prema pravilima lokalnog jezika.';
$string['invalidsection'] = 'Neispravna sekcija';
$string['invaliduserchangeme'] = 'Korisničko ime "changeme" je rezervisano -- ne možete kreirati nalog sa tim imenom.';
$string['ipblocked'] = 'Ovaj sajt trenutno nije dostupan.';
$string['ipblocker'] = 'Bloker IP adresa';
$string['ipblockersyntax'] = 'Jedan zapis po jednom redu. Ispravni zapisi su ili pune IP adrese (npr. <b>192.168.10.1</b>), koje koje odgovaraju jednom serveru; ili delimične adrese (npr. <b>192.168.</b>), koje odgovaraju svi računarima čija IP adresa počinje tim brojevima; ili CIDR notacije (npr. <b>231.54.211.0/20</b>); ili rang IP adresa (npr. <b>231.3.56.10-20</b>) gde rang odgovara poslednjem delu adrese. Slovima napisani domeni (npr. \'example.com\') nisu podržani. Prazne linije biće zanemarene.';
$string['iplookup'] = 'Traženje IP adrese';
$string['iplookupgeoplugin'] = '<a href="http://www.geoplugin.com">geoPlugin</a> servis se trenutno koristi za pronalaženje geografskih informacija. Za preciznije rezultata predlažemo vam da instalirate lokalnu kopiju MaxMind GeoLite baze podataka.';
$string['iplookupinfo'] = 'Kako bi locirao IP adresu Moodle standardno koristi besplatan onlajn NetGeo (The Internet Geographic Database) server. Nažalost, ova baza podatakа se više ne održava pa se može desiti da dobijete <em>krajnje pogrešne</em> podatke.
Preporučuje se da instalirate lokalnu kopiju besplatne GeoLite City baze podataka kompanije MaxMind.<br />
Pozicija IP adrese se prikazuje na jednostavnoj mapi ili korišćenjem  Google Maps. Napomena: da biste omogućili interaktivne mape neophodno je da imate Google nalog kao i da se prijavite za besplatan Google Maps API ključ.';
$string['iplookupmaxmindnote'] = 'Ovaj proizvod uključuje GeoLite podatke kreirane od strane MaxMind, koji je dostupan na <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Zadržati velika i mala slova oznaka (tagova)';
$string['lang'] = 'Podrazumevani jezik';
$string['langcache'] = 'Keširanje jezičkog menija';
$string['langcache_desc'] = 'Keširaj jezički meni. Ako je ovo podešavanje omogućeno, spisak dostupnih prevoda se kešira. Keš memorija se automatski osvežava kada instalirate ili obrišete jezički pakete pomoću ugrađenog alata za upravljanje jezičkim paketima. Ako ručno instalirate novi paket, morate da upotrebite naredbu "Obriši ceo keš" kako biste osvežili keširanu listu jezičkih paketa.';
$string['langlist'] = 'Jezici na jezičkom meniju';
$string['langmenu'] = 'Prikaz jezičkog menija';
$string['langpackwillbeupdated'] = 'Napomena: U toku nadogradnje Moodle će pokušati da ažurira vaše jezičke pakete.';
$string['langstringcache'] = 'Keširaj sve jezičke stringove';
$string['languagesettings'] = 'Jezička podešavanja';
$string['latexpreamble'] = 'LaTeX preambula';
$string['latexsettings'] = 'Podešavanja LaTeX renderovanja';
$string['latinexcelexport'] = 'Excel kodiranje';
$string['legacyfilesaddallowed'] = 'Dozvoli dodavanje nasleđenim datotekama';
$string['legacyfilesaddallowed_help'] = 'Ako kurs ima stare nasleđene datoteke, dozvolite da im budu dodate nove datoteke i direktorijumi.';
$string['legacyfilesinnewcourses'] = 'Nasleđene datoteke kursa u novom kursu';
$string['legacyfilesinnewcourses_help'] = 'Standardno, prostori za nasleđene datoteke kurseva su dostupni samo u nadograđenim kursevima. Imajte u vidu da pojedina svojstva, poput kreiranja i restauriranja rezervne kopije nisu kompatibilne sa ovim podešavanjem.';
$string['licensesettings'] = 'Podešavanja licence';
$string['linkadmincategories'] = 'Prikaži administratorske kategorije kao linkove';
$string['linkadmincategories_help'] = 'Ako je ovo podešavanje omogućeno, kategorije, unutar administratorskog bloka za podešavanja, biće prikazane kao linkovi i povezane sa stranicama  odgovarajućih administratorskih kategorija.';
$string['loading'] = 'Učitavanje';
$string['localetext'] = 'Lokalni tekst na nivou sajta';
$string['localstringcustomization'] = 'Prilagođavanje stringova lokala';
$string['location'] = 'Lokacija';
$string['locationsettings'] = 'Podešavanja lokacije';
$string['locked'] = 'Zaključano';
$string['lockoutduration'] = 'Period u kom je nalog zaključan';
$string['lockoutduration_desc'] = 'Zaključani nalog se automatski otključava.nakon što istekne ovaj vremenski period';
$string['lockoutemailbody'] = 'Vaš nalog sa korisničkim imenom {$a->username} na sajtu \'{$a->sitename}\'
je zaključan nakon višestrukih neispravnih pokušaja prijave na sistem.

Da biste otključali nalog odmah idite na sledeću adresu

{$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Ukoliko vam je potrebna tehnička pomoć, molimo vas da kontaktirate administratora,
{$a->admin}';
$string['lockoutemailsubject'] = 'Vaš nalog na sajtu {$a} je zaključan';
$string['lockouterrorunlock'] = 'Dobavljena je neispravna informacija za otključavanje naloga.';
$string['lockoutthreshold'] = 'Prag zaključavanja naloga';
$string['lockoutthreshold_desc'] = 'Izaberite broj neuspešnih pokušaja prijave na sistem koji će dovesti do zaključavanja naloga. Ova funkcija može biti zloupotrebljena u napadima uskraćivanjem usluga (DoS - denial of service).';
$string['lockoutwindow'] = 'Vreme praćenja za zaključavanje naloga';
$string['lockoutwindow_desc'] = 'Vreme praćenja za prag zaključavanja – ukoliko nema neuspešnih pokušaja prijave na sistem brojač praga zaključavanja se resetuje nakon ovog vremenskog perioda.';
$string['log'] = 'Zapisi o aktivnostima';
$string['logguests'] = 'Beleži pristupe gostiju';
$string['logguests_help'] = 'Ovo podešavanje omogućava beleženje aktivnosti od strane gostiju, kao i korisnika koji nisu prijavljeni na sistem. Ako vaš sajt ima veliki broj korisnika možda ćete želeti da isključite ovo podešavanje zbog boljih performansi. Preporučljivo je da ovo podešavanje držite uključeno na produkcionim sajtovima.';
$string['loginhttps'] = 'Koristiti HTTPS za pristupe sistemu';
$string['loginpageautofocus'] = 'Obrazac sa autofokusirajućim poljima na stranici za prijavljivanje';
$string['loginpageautofocus_help'] = 'Uključivanjem ove opcije povećava se upotrebljivost stranice za prijavljivanje, ali automatski fokusirajuća polja mogu predstavljati problem pristupačnosti svim korisnicima, naročito onima sa posebnim potrebama.';
$string['loginpasswordautocomplete'] = 'Spreči automatsko popunjavanje lozinke na obrascu za prijavu na sistem.';
$string['loginpasswordautocomplete_help'] = 'Ukoliko je ovo podešavanje uključeno korisnici neće moći da sačuvaju lozinku u svom veb čitaču.';
$string['loglifetime'] = 'Čuvaj zapise o aktivnostima za poslednjih';
$string['longtimewarning'] = '<b>Molimo vas da uzmete u obzir da ovaj proces može potrajati</b>';
$string['maintenancemode'] = 'U režimu održavanja';
$string['maintenancemodeisscheduled'] = 'Sajt se prebacuje u režimu održavanja za {$a} minut/a';
$string['maintfileopenerror'] = 'Greška pri otvaranju datoteka za održavanje!';
$string['maintinprogress'] = 'Održavanje je u toku...';
$string['manageformats'] = 'Upravljanje formatima kursa';
$string['manageformatsgotosettings'] = 'Podrazumevani format može biti promenjen u {$a}';
$string['managelang'] = '<b>Upravljanje</b>';
$string['managelicenses'] = 'Upravljanje licencama';
$string['manageqbehaviours'] = 'Upravljanje ponašanjima pitanja';
$string['manageqtypes'] = 'Upravljanje tipovima pitanja';
$string['maturity100'] = 'Beta verzija';
$string['maturity150'] = 'RC (Release candidate) verzija';
$string['maturity200'] = 'Stabilna verzija';
$string['maturity50'] = 'Alfa verzija';
$string['maturityallowunstable'] = 'Savet: Možda ćete želeti da pokrenete ovu skriptu sa opcijom --allow-unstable option';
$string['maturitycoreinfo'] = 'Vaš sajt trenutno pokreće nestabilni "{$a}" razvojni kod';
$string['maturitycorewarning'] = 'Instaliraćete ili nadograditi Moodle na verziju označenu kao "{$a}" koja se još ne smatra pogodnom za produkcioni sajt. Molimo proverite da li stvarno to hoćete i da li koristite ispravnu proveru Moodle izvornog koda.';
$string['maxbytes'] = 'Maksimalna veličina postavljene datoteke';
$string['maxconsecutiveidentchars'] = 'Redosledni identični karakteri';
$string['maxeditingtime'] = 'Maksimalno vreme za uređivanje poruka';
$string['maxusersperpage'] = 'Maksimalan broj korisnika po stranici';
$string['mbstringrecommended'] = 'Instaliranje opcione MBSTRING biblioteke je vrlo preporučljivo zbog unapređivanja performansi sajta, pogotovo ako vaš sajt podržava jezike koji ne koriste latinično pismo.';
$string['mediapluginavi'] = 'Omogući .avi filter';
$string['mediapluginflv'] = 'Omogući .flv filter';
$string['mediapluginimg'] = 'Omogući automatsko umetanje linkovanih slika';
$string['mediapluginmov'] = 'Omogući .mov filter';
$string['mediapluginmp3'] = 'Omogući .mp3 filter';
$string['mediapluginmpg'] = 'Omogući .mpg filter';
$string['mediapluginogg'] = 'Omogući .ogg filter';
$string['mediapluginogv'] = 'Omogući .ogv filter';
$string['mediapluginram'] = 'Omogući .ram filter';
$string['mediapluginrm'] = 'Omogući .rm filter';
$string['mediapluginrpm'] = 'Omogući .rpm filter';
$string['mediapluginswf'] = 'Omogući .swf filter';
$string['mediapluginswfnote'] = 'Kao podrazumevanu meru bezbednosti, običnim korisnicima ne treba dozvoliti da umeću swf flash datoteke.';
$string['mediapluginwmv'] = 'Omogućiti .wmv filter';
$string['mediapluginyoutube'] = 'Omogući filte za YouTube linkove';
$string['messaging'] = 'Omogući sistem za razmenu poruka';
$string['messagingallowemailoverride'] = 'Izmena e-adrese za slanje obaveštenja';
$string['messagingdeletereadnotificationsdelay'] = 'Obriši obaveštenje o pročitanim porukama';
$string['messaginghidereadnotifications'] = 'Sakrij obaveštenje o pročitanim porukama';
$string['minpassworddigits'] = 'Brojevi';
$string['minpasswordlength'] = 'Dužina lozinke';
$string['minpasswordlower'] = 'Mala slova';
$string['minpasswordnonalphanum'] = 'Ne-alfanumerički karakteri';
$string['minpasswordupper'] = 'Velika slova';
$string['misc'] = 'Razno';
$string['mnetrestore_extusers'] = '<strong>Napomena:</strong> Ova rezervna kopija sadrži udaljene korisničke naloge iz odgovarajuće Moodle mreže. Ti nalozi će tokom ovog procesa takođe biti restaurirani.';
$string['mnetrestore_extusers_admin'] = '<strong>Napomena:</strong> Izgleda da je ova dadoteka rezervne kopije kreirana na nekoj drugoj Moodle instalaciji i da sadrži korisničke naloge udaljene Moodle Mreže. Proces restauracije će pokušati da uskladi hostove Moodle Mreže za sve korisnike. One korisnici, za koje to ne uspe, automatski će nbiti prebačeni na internu proveru identiteta (umesto mnet). Zapis o restauraciji će Vas inforisati o tome.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Napomena:</strong> Ova rezervna kopija očigledno potiče sa neke druge Moodle instalacije i sadrži korisničke naloge udaljene Moodle Mreže koji se možda neće istravno restaurirati. Ova operacija nije podržana. Ako ste sigurni da je arhiva kreirana na ovoj Moodle instalaciji, ili možete da potvrdite da su svi potrebni hostovi u Vašoj Moodle mreži  konfigurisani, možda ćete ipak želeti da pokušate restauraciju.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Napomena:</strong> Izgleda da je ova dadoteka rezervne kopije kreirana na nekoj drugoj Moodle instalaciji i da sadrži korisničke naloge udaljene Moodle Mreže. Nije Vam dozvoljeno da izvršavate ovaj tip restauriranja. Kontaktirajte administratora ovog sajta ili, alternativno, restaurirajte ovaj kurs bez bilo kakve informacije o korisnivima (moduli, datoteke...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Udaljeni korisnik Moodle Mreže {$a->username} (koji dolazi sa {$a->mnethosturl}) prebačen je na lokalnog {$a->auth} autorizovanog korisnika.';
$string['mobile'] = 'Mobilni';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Podrazumevani status birača aktivnosti';
$string['modeditdefaults'] = 'Podrazumevane vrednosti za podešavanja aktivnosti';
$string['modeditingmenu'] = 'Meniji za uređivanje aktivnosti';
$string['modeditingmenu_desc'] = 'Ako je ova opcija omogućena mnoge od ikona za uređivanje aktivnosti prikazanih kad se pregleda kurs sa uključenim uređivanjem biće prikazane u okviru padajućeg menija. Ovo redukuje sadržaj na ekranu pri uređivanju kursa sakrivajući ikone dok ne postanu potrebne.';
$string['modsettings'] = 'Upravljanje aktivnostima';
$string['modulesecurity'] = 'Bezbednost modula';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Insistirati na staroj višejezičkoj sintaksi: &lt;span&gt; bez class="multilang" i &lt;lang&gt;';
$string['mustenablestats'] = 'Statistika još nije omogućena na ovom sajtu.';
$string['mycoursesperpage'] = 'Broj kurseva';
$string['mydashboard'] = 'Podrazumevana kontrolna tabla sistema';
$string['mymoodle'] = 'Moja početna stranica';
$string['mymoodleredirect'] = 'Obavezno korišćenje opcije Moj Moodle za sve korisnike';
$string['mypage'] = 'Podrazumevana Moja početna stranica';
$string['mypagelocked'] = 'Zaključaj podrazumevanu stranicu';
$string['myprofile'] = 'Podrazumevana stranica profila';
$string['mysql416bypassed'] = 'Međutim, ako Vaš sajt koristi iso-8859-1 (latin) jezike, možete da nastavite s korišćenjem Vaše trenutno instalirane MySQL verzije 4.1.12 (ili više).';
$string['mysql416required'] = 'MySQL 4.1.16 je minimalna verzija potrebna za Moodle 1.6 da bi se garantovalo dalje konvertovanje svih podataka u UTF-8.';
$string['navadduserpostslinks'] = 'Dodaj linkove za prikaz korisničkih poruka';
$string['navadduserpostslinks_help'] = 'Ako je ovo podešavanje omogućeno, svakom korisniku će u bloku za navigaciju biti dodata dva linka, jedan za prikaz diskusija koje je korisnik započeo i drugi za prikaz poruka koje je postavio na forumima širom sajta ili na određenim kursevima.';
$string['navcourselimit'] = 'Broj kurseva';
$string['navigationupgrade'] = 'Ova nadogradnja uvodi dva nova bloka za navigaciju koji će zameniti sledeće blokove: Administracija, Kursevi, Aktivnosti i Učesnici. Ako ste prethodno dodelili neka posebna ovlašćenja u ovim blokovima, trebalo bi da proverite da li se sve događa onako kako želite.';
$string['navshowallcourses'] = 'Prikaži sve kurseve';
$string['navshowcategories'] = 'Prikaži kategorije kurseva';
$string['navshowfrontpagemods'] = 'Prikaži aktivnosti na naslovnoj stranici sajta';
$string['navshowfrontpagemods_help'] = 'Ako je ovo podešavanje omogućeno, aktivnosti na naslovnoj stranici sajta biće prikazane u bloku za navigacije pod stavkom \'Stranice sajta\'.';
$string['navshowfullcoursenames'] = 'Prikaži pune nazive kurseva';
$string['navshowfullcoursenames_help'] = 'Ako je uključeno u navigaciji će se koristiti puni nazivi kurseva umesto skraćenih.';
$string['navshowmycoursecategories'] = 'Prikaži kategorije mojih kurseva';
$string['navshowmycoursecategories_help'] = 'Ako je ovo podešavanje omogućeno, kursevi će biti prikazani korisnicima u bloku za navigaciju pod stavkom \'Moji kursevi\', kao grane odgovarajućih kategorija.';
$string['navsortmycoursessort'] = 'Sortiraj moje kurseve';
$string['navsortmycoursessort_help'] = 'Ovo određuje da li su kursevi unutar stavke \'Moji kursevi\', u bloku za navigaciju, poređani prema redosledu sortiranja (tj. redosledu koji je podešen u Administracija sajta > Kursevi > Upravljanje kursevima i kategorijama) ili alfabetski prema podešavanju kursa.';
$string['neverdeleteruns'] = 'Nikada ne briši pokretanja';
$string['nobookmarksforuser'] = 'Nemate postavljenih obeleživača.';
$string['nodatabase'] = 'Nema baze podataka';
$string['nohttpsformobilewarning'] = 'Preporučuje se da omogućite HTTPS protokol sa važećim sertifikatom. Moodle aplikacija će uvek prvo pokušati da koristi bezbednu konekciju.';
$string['nomissingstrings'] = 'Nema nedostajućih izraza';
$string['nonewsettings'] = 'Nije dodato nijedno novo podešavanje tokom ovog ažuriranja.';
$string['nonexistentbookmark'] = 'Traženi obeleživač ne postoji.';
$string['noresults'] = 'Nema rezultata';
$string['noroles'] = 'Nema uloga';
$string['notifications'] = 'Obaveštenja';
$string['notifyloginfailures'] = 'Poslati izveštaj o neuspešnim pristupima sistemu korisniku';
$string['notifyloginthreshold'] = 'Granična vrednost za obaveštenja e-poštom';
$string['notloggedinroleid'] = 'Uloga za posetioce';
$string['numberofmissingstrings'] = 'Broj nedostajućih izraza: {$a}';
$string['numberofstrings'] = 'Ukupan broj izraza: {$a->strings}<br />Nedostaje: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'Keširanje PHP koda operacije poboljšava performanse i snižava memorijske zahteve, OPcache dodatak je preporučen i u potpunosti podržan.';
$string['opensslrecommended'] = 'Instaliranje opcione OpenSSL biblioteke je vrlo preporučljivo -- ona omogućava korišćenje funkcija za umrežavanje.';
$string['opentogoogle'] = 'Otvoren za Google';
$string['optionalmaintenancemessage'] = 'Opciona poruka u toku održavanja sistema';
$string['order1'] = 'Prvi';
$string['order2'] = 'Drugi';
$string['order3'] = 'Treći';
$string['order4'] = 'Četvrti';
$string['passwordpolicy'] = 'Pravilnik za kreiranje lozinke';
$string['passwordresettime'] = 'Maksimalno vreme za potvrdu zahteva za resetovanje lozinke.';
$string['pathconvert'] = 'Putanja <i>convert</i> binarne datoteke';
$string['pathdvips'] = 'Putanja <i>dvips</i> binarne datoteke';
$string['pathlatex'] = 'Putanja <i>latex</i> binarne datoteke';
$string['pathtoclam'] = 'clam AV putanja';
$string['pathtodot'] = 'Putanja do dot';
$string['pathtodot_help'] = 'Putanja do dot. Verovatno, nešto poput /usr/bin/dot. Da biste mogli da generišete grafike iz DOT datoteka, morate imati instaliran dot izvršnu datoteku i podešenu ispravnu putanju do nje. Imajte na umu da se ovo koristi samo za tzv. "profajling" (Development->Profiling) novu funkciju ugrađenu u Moodle, koja je u razvojnoj fazi.';
$string['pathtodu'] = 'Putanja do du alata';
$string['pathtopgdump'] = 'Putanja do pg_dump';
$string['pathtopgdumpdesc'] = 'Ovo je neophodno uneti samo ako imate više od jednog pg_dumpa na svom sistemu (na primer ako ste instalirali više od jedne verzije postgresqla)';
$string['pathtopgdumpinvalid'] = 'Putanja do pg_dump-a nije validna - ili je putanja pogrešna ili nije izvršiva';
$string['pathtopsql'] = 'Putanja do psql';
$string['pathtopsqldesc'] = 'Ovo je neophodno uneti samo ako imate više od jednog psqla na svom sistemu (na primer ako ste instalirali više od jedne verzije postgresqla)';
$string['pathtopsqlinvalid'] = 'Putanja do psql-a nije validna - ili je putanja pogrešna ili nije izvršiva';
$string['pcreunicodewarning'] = 'Strogo se preporučuje da koristite PCRE PHP ekstenziju koji je kompatibilna sa Unicode setom karaktera.';
$string['perfdebug'] = 'Informacije o izvršavanju';
$string['performance'] = 'Performanse';
$string['pgcluster'] = 'PostgreSQL klaster';
$string['pgclusterdescription'] = 'Parametar PostgreSQL verzije/klastera za operacije komandne linije. Ako imate samo jedan postgresql na svom sistemu ili niste sigurni šta ovo podešavanje predstavlja, ostavite polje prazno.';
$string['php50restricted'] = 'PHP 5.0.x ima više poznatih problema, molimo unapredite PHP na verzije 5.1.x ili instalirajte verziju 4.3.x odnosno 4.4.x';
$string['php533warning'] = 'Preporučuje se korišćenje PHP 5.3.3 ili novije verzije';
$string['phpfloatproblem'] = 'Uočene je neočekivani problem u obradi PHP brojeva sa pokretnim zarezom - {$a}';
$string['pleaserefreshregistration'] = 'Vaš sajt je registrovan na moodle.org. Razmotrite mogućnost ažuriranja registracije, ukoliko je došlo do značajnih promena od Vašeg poslednjeg ažuriranja, na {$a}';
$string['pleaseregister'] = 'Molimo registrujte Vaš sajt kako biste uklonili ovu poruku';
$string['plugin'] = 'Dodatak';
$string['plugins'] = 'Dodaci';
$string['pluginscheck'] = 'Provera zavisnosti dodataka';
$string['pluginscheckfailed'] = 'Provera zavisnosti nije uspela za {$a->pluginslist}';
$string['pluginschecktodo'] = 'Morate rešiti sve zahteve dodataka pre nego što nastavite sa instalacijom ove verzije Moodlea!';
$string['pluginsoverview'] = 'Pregled dodataka';
$string['pluginsoverviewsee'] = 'Za više informacija pogledajte stranicu <a href="{$a->url}">Pregled dodataka</a>.';
$string['profilecategory'] = 'Kategorija';
$string['profilecategoryname'] = 'Naziv kategorije (mora biti jedinstven)';
$string['profilecategorynamenotunique'] = 'Ovaj naziv kategorije već je u upotrebi';
$string['profilecommonsettings'] = 'Zajednička podešavanja';
$string['profileconfirmcategorydeletion'] = 'Postoje {$a}. polja u ovoj kategoriji koja mogu biti pomerena u kategoriju iznad (ili ispod).<br />Da li želite da obrišete ovu kategoriju?';
$string['profileconfirmfielddeletion'] = 'Postoji {$a} korisničkih unosa za ovo polje koji trebaju biti obrisani.<br />Da li i dalje želite obrisati ovo polje?';
$string['profilecreatecategory'] = 'Kreiraj novu kategoriju profila';
$string['profilecreatefield'] = 'Kreiraj novo polje za profil:';
$string['profilecreatenewcategory'] = 'Kreiraj novu kategoriju';
$string['profilecreatenewfield'] = 'Kreiranje novog polja profila: &quot;{$a}&quot;';
$string['profiledefaultcategory'] = 'Ostala polja';
$string['profiledefaultchecked'] = 'Uključeno podrazumevano';
$string['profiledefaultdata'] = 'Podrazumevana vrednost';
$string['profiledeletecategory'] = 'Brisanje kategorije';
$string['profiledeletefield'] = 'Brisanje polja \'{$a}\'';
$string['profiledescription'] = 'Opis polja';
$string['profiledscript'] = 'Ovaj skript je profilisan';
$string['profiledscriptview'] = 'Vidi informacije o profilisanju za ovaj skript';
$string['profileeditcategory'] = 'Uređivanje kategorije: {$a}';
$string['profileeditfield'] = 'Uređivanje polja  profila: {$a}';
$string['profilefield'] = 'Polje profila';
$string['profilefieldcolumns'] = 'Kolone';
$string['profilefieldispassword'] = 'Da li je ovo polje za lozinku?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Za pretvaranje teksta u link, unesite URL koji sadrži $$, gde će $$ biti zamenjen tekstom. Na primer, za pretvaranje Twitter ID-ja u link, upišite http://twitter.com/$$';
$string['profilefieldlinktarget'] = 'Adresa do koje vodi link';
$string['profilefieldmaxlength'] = 'Maksimalna dužina';
$string['profilefieldrows'] = 'Redova';
$string['profilefields'] = 'Polja profila korisnika';
$string['profilefieldsize'] = 'Veličina polja';
$string['profileforceunique'] = 'Da li podaci treba da budu jedinstveni?';
$string['profileinvaliddata'] = 'Neodgovarajuća vrednost';
$string['profilelocked'] = 'Da li je ovo polje zaključano?';
$string['profilemenudefaultnotinoptions'] = 'Podrazumevana vrednost nije u listi opcija.';
$string['profilemenunooptions'] = 'Bez opcija sa menijima';
$string['profilemenuoptions'] = 'Meni opcije (po jedna u liniji)';
$string['profilemenutoofewoptions'] = 'Morate ponuditi bar 2 mogućnosti';
$string['profilename'] = 'Naziv';
$string['profilenofieldsdefined'] = 'Nije definisano nijedno polje';
$string['profilerequired'] = 'Da li je ovo polje obavezno?';
$string['profileroles'] = 'Uloge vidljive u profilu';
$string['profilesforenrolledusersonly'] = 'Profili samo za korisnike upisane na kurs.';
$string['profileshortname'] = 'Skraćen naziv (mora biti jedinstven)';
$string['profileshortnamenotunique'] = 'Ovaj skraćen naziv se već koristi';
$string['profilesignup'] = 'Prikazati na stranici za prijavu?';
$string['profilespecificsettings'] = 'Specifična podešavanja';
$string['profilevisible'] = 'Kome je ovo polje vidljivo?';
$string['profilevisibleall'] = 'Vidljivo svima';
$string['profilevisible_help'] = '* Nije vidljivo - za lične podatke vidljive samo administratorima
* Vidljivo korisniku - za lične podatke vidljive samo administratorima i korisniku čiju su podaci
* Vidljivo svima';
$string['profilevisiblenone'] = 'Nije vidljivo';
$string['profilevisibleprivate'] = 'Vidljivo korisniku';
$string['profiling'] = 'Profilisanje';
$string['profilingallowall'] = 'Kontinuirano profilisanje';
$string['profilingallowall_help'] = 'Ako omogućite ovo podešavanje, onda, u bilo kom trenutku možete da koristite parametar PROFILEALL bilo gde (PGC) kako biste omogućili profilisanje za sve izvršene skripte tokom trajanja Moodle sesije. Analogno tome, možete da koristite parametar PROFILEALLSTOP kako biste to zaustavili.';
$string['profilingallowme'] = 'Selektivno profilisanje';
$string['profilingallowme_help'] = 'Ako omogućite ovо podešavanje, onda, selektivno, možete da koristite parametar PROFILEME bilo gde (PGC) i taj skript će biti profilisan. Analogno tome, možete da koristite parametar DONTPROFILEME kako bi sprečili profilisanje.';
$string['profilingautofrec'] = 'Automatsko profilisanje';
$string['profilingautofrec_help'] = 'Konfigurisanjem ovog podešavanja, neki zahtevi (nasumično odabrani, zasnovano na učestalosti određenoj kao 1 od N) biće odabrani i automatski profilisani, smeštajući rezultate za dalju analizu. Imajte na umu da ovaj način profilisanja posmatra include/exclude podešavanja. Postavite vrednost na 0 kako biste onemogućili automatsko profilisanje.';
$string['profilingenabled'] = 'Omogući profilisanje';
$string['profilingenabled_help'] = 'Ako omogućite ovu podešavanje, onda će profilisanje biti dostupno na ovom sajtu i moći ćete da odrediti njegovo ponašanje tako što ćete podesiti sledeće opcije.';
$string['profilingexcluded'] = 'Isključi profilisanje';
$string['profilingexcluded_help'] = 'Spisak URL adresa (odvojenih zarezima, apsolutnih, preskačući wwwroot, koje mogu biti pozvane) koje će biti izuzete od profilisanja definisanog u podešavanju \'Profiliši ove\'.';
$string['profilingimportprefix'] = 'Prefiks za uvoz profilisanja';
$string['profilingimportprefix_desc'] = 'Radi lakšeg utvrđivanja, sva uvezena pokretanja profilisanja će dobiti prefikse sa vrednošću specificiranom ovde.';
$string['profilingincluded'] = 'Profiliši ove';
$string['profilingincluded_help'] = 'Spisak URL adresa (odvojenih zarezima, apsolutnih, preskačući wwwroot, koje mogu biti pozvane) koje će biti automatski profilisane. Primer:/index.php, /course/view.php. Takođe je prihvatljiva upotreba * džoker oznaka na bilo kojoj poziciji. Ptimer: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Nastavi sa profilisanjem';
$string['profilinglifetime_help'] = 'Odredite koliko dugo želite da čuvate informacije o prethodnim pokretanjima profilisanja. Starije će periodično biti odstranjivana. Imajte u vidu da ovo isključuje bilo koje pokretanje profilisanja označeno kao "referentno pokretanje".';
$string['protectusernames'] = 'Zaštititi korisnička imena';
$string['proxybypass'] = 'Hostovi za premošćenje Proxy servera';
$string['proxyhost'] = 'Proxy domaćin';
$string['proxypassword'] = 'Lozinka za proksi server';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Tip Proxy servera';
$string['proxyuser'] = 'Korisničko ime za Proxy';
$string['purgecaches'] = 'Obriši sve zapise iz keš memorije';
$string['purgecachesconfirm'] = 'Moodle može da čuva u keš memoriji teme, Javascript, jezičke stringove, filtrirani tekst, RSS izvore vesti i mnoge druge obrađene podataka. Brisanje keš memorije će obrisati te privremeno sačuvane podatke sa servera i time primorati Web čitač da ponovo preuzme podatke, tako da možete biti sigurni da gledate najnovije vrednosti koje je proizveo trenutni kôd. Nema nikakve opasnosti u brisanju keš memorije, ali Vaš sajt može, na trenutak, biti sporiji, sve dok server i klijentski program ne generišu nove informacije i ponovo ih smeste u keš.';
$string['purgecachesfinished'] = 'Svi zapisi iz keš memorije su obrisani';
$string['qtyperqpwillberemoved'] = 'Tokom nadogradnje, RQP tipovi pitanja biće uklonjeni. Nećete koristiti ovaj tip pitanja, tako da ne očekujte probleme u vezi s tim.';
$string['qtyperqpwillberemovedanyway'] = 'Tokom nadogradnje biće uklonjen RQP tip pitanja. Kako imate neka RQP pitanja u svojoj bazi, preporučuje se da ponovo instalirate dodatak sa http://moodle.org/mod/data/view.php?d=13&amp;rid=797 pre nastavka nadogradnje da bi ona mogla i dalje nesmetano da se koriste.';
$string['quarantinedir'] = 'Karantinski direktorijum';
$string['question'] = 'Pitanje';
$string['questionbehaviours'] = 'Ponašanja pitanja';
$string['questioncwqpfscheck'] = 'Jedno ili više \'nasumično izabranih\' pitanja u testu podešeno je da vrši odabir pitanja i iz kategorija deljenih i iz kategorija nedeljenih pitanja. Detaljniji izveštaj pogledajte <a href="{$a->reporturl}">ovde</a>, ili potražite dodatne informacije u okviru stranica Moodle <a href="{$a->docsurl}">dokumentacije</a>.';
$string['questioncwqpfsok'] = 'U redu. Nema \'nasumično izabranih\' pitanja u Vašim testovima koja su podešena tako da vrše odabir pitanja i iz kategorija deljenih i iz kategorija nedeljenih pitanja.';
$string['questiontype'] = 'Tip pitanja';
$string['questiontypes'] = 'Tipovi pitanja';
$string['quizattemptsupgradedmessage'] = 'U verziji Moodle 2.1 izvršen je velika nadogradnja onog  dela koji se odnosi na pitanja. Bilo je moguće da se deo nadogradnje baze podataka odloži i pokrene kasnije. Pre prelaska na verziju Moodle 2.7 ova nadogradnja mora da bude završena.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA privatni ključ';
$string['recaptchapublickey'] = 'ReCAPTCHA javni ključ';
$string['register'] = 'Registrujte svoj sajt';
$string['registermoodleorg'] = 'Kada registrujete svoj sajt na {$a}';
$string['registermoodleorgli1'] = 'Bićete dodati na listu e-pošte za slanje važnih obaveštenja kao što su bezbednosna upozorenja i informacije o novim izdanjima Moodlea.';
$string['registermoodleorgli2'] = 'Statistički podaci o vašem sajtu biće dodati statistici svetske Moodle zajednice - {$a}.';
$string['registermoodleorgli3'] = 'Vaš sajt će, takođe, biti registrovan na Moodle.net ({$a}), što korisnicima sa izdavačkim ovlašćenjem (standardno, to su samo menadžeri) omogućava da objavljuju kurseve na Moodle.net.';
$string['registerwithmoodleorg'] = 'Registracija na sajtu Moodle.org';
$string['registration'] = 'Registracija';
$string['registration_help'] = 'Registracija vašeg sajta na Moodle.org se preporučuje iz više razloga - zbog dobijanja bezbednosnih upozorenja e-poštom, zbog preciznije statistike na<a href="http://moodle.org/stats">Statistički podaci o korišćenju Moodlea</a> , kao i zbog mogućnosti deljenja kurseva na <a href="http://moodle.net/">Moodle.net</a>.';
$string['registrationwarning'] = 'Vaš sajt još nije registrovan';
$string['releasenoteslink'] = 'Za informacije o ovoj verziji Moodlea, molimo pogledajte onlajn <a target="_new" href="{$a}">Beleške o izdanju</a>';
$string['rememberusername'] = 'Zapamti korisničko ime';
$string['rememberusername_desc'] = 'Omogućite ovu opciju ako želite da sačuvate permanentne kolačiće sa korisničkim imenima prilikom prijavljivanja korisnika na sistem. Permanentni kolačići mogu da predstavljaju problem privatnosti ako se koriste bez saglasnosti.';
$string['reportsmanage'] = 'Upravljanje izveštajima';
$string['requestcategoryselection'] = 'Omogući izbor kategorija';
$string['requiredentrieschanged'] = '<strong>VAŽNO - MOLIMO PROČITAJTE<br/>(Ova poruka upozorenja biće prikazana samo u toku ove nadogradnje sistema)</strong><br/>Zbog ispravljanja bagova ponašanje aktivnosti baze podataka koje koriste podešavanja \'Zahtevani unosi\' i \'Zahtevani unosi pre pregledanja podešavanja\' biće promenjena. Detaljnije objašnjenje promena možete pročitati na <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">forumu o modulu Baza podataka</a>. O očekivanim promenama ponašanja ovih podešavanja, takođe, možete pročitati u okviru <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle dokumentacije</a>.
<br/><br/>Ova promena utiče na sledeće baze podataka u vašem sistemu: (Molimo vas da sada sačuvate ovaj spisak i, nakon završene nadogradnje sistema, proverite da li ove aktivnosti i dalje rade onako kako su to predavači planirali.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Zahtevaj opis aktivnosti';
$string['requires'] = 'Neophodno';
$string['restorernewroleid'] = 'Uloga restauratora na kursevima';
$string['restorernewroleid_help'] = 'Ako korisnik već nema dozvolu da upravlja nedavno restaurisanim kursom, automatski će mu biti dodeljena ova uloga i biće upisan na kurs ako je to potrebno. Izaberite "Ništa", ako ne želite da oni koji restauriraju kurseve budu  u mogućnosti da upravljaju svakim restaurisanim kursom.';
$string['reverseproxy'] = 'Reverzni proksi';
$string['riskconfig'] = 'Korisnici bi mogli promeniti konfiguraciju i ponašanje sajta';
$string['riskconfigshort'] = 'Konfiguracioni rizik';
$string['riskdataloss'] = 'Korisnici mogu da unište veliku količinu sadržaja ili informacija';
$string['riskdatalossshort'] = 'Rizik od gubitkka podataka';
$string['riskmanagetrust'] = 'Korisnici bi mogli promeniti sigurnosna podašavanja drugih korisnika';
$string['riskmanagetrustshort'] = 'Upravljanje dozvolama za pristup';
$string['riskpersonal'] = 'Korisnici bi mogli steći pristup privatnim informacijama drugih korisnika';
$string['riskpersonalshort'] = 'Rizik po privatnost';
$string['riskspam'] = 'Korisnici bi mogli slati neželjenu poštu korisnicima sajta ili drugim licima';
$string['riskspamshort'] = 'Rizik od neželjene e-pošte';
$string['riskxss'] = 'Korisnici bi mogli dodati datoteke i tekstove koji dozvoljavaju skriptovanje u okviru čitavog sajta (XSS)';
$string['riskxssshort'] = 'XSS rizik';
$string['roleswithexceptions'] = '{$a->roles}, sa {$a->exceptions}';
$string['rssglobaldisabled'] = 'Isključi na nivou servera';
$string['runclamavonupload'] = 'Koristiti clam AV za sve postavljene datoteke';
$string['save'] = 'Sačuvaj';
$string['savechanges'] = 'Sačuvaj promene';
$string['search'] = 'Pretraga';
$string['searchinsettings'] = 'Traži u podešavanjima';
$string['searchresults'] = 'Rezultati pretrage';
$string['sectionerror'] = 'Greška sekcije!';
$string['secureforms'] = 'Koristiti dodatne mere bezbednosti formulara';
$string['security'] = 'Bezbednost';
$string['selectdevice'] = 'Izaberi uređaj';
$string['selecttheme'] = 'Izaberi grafičku temu za uređaj {$a}';
$string['server'] = 'Server';
$string['serverchecks'] = 'Provere servera';
$string['serverlimit'] = 'Ograničenje servera';
$string['sessionautostartwarning'] = '<p>Otkrivena je ozbiljna greška pri konfiguraciji, molimo obavestite administratora servera</p><p> Za ispravan rad, administrator treba da promeni PHP podešavanja.</p> <p><code>session.auto_start</code> mora biti podešeno na <code>off</code>.</p><p> Ovo podešavanje može se promeniti uređivanjem <code>php.ini</code> datoteke, konfiguracije Apache/IIS Web servera<br />ili <code>.htaccess</code> datoteke na serveru.</p>';
$string['sessioncookie'] = 'Prefiks kolačića';
$string['sessioncookiedomain'] = 'Domen kolačića';
$string['sessioncookiepath'] = 'Putanja kolačića';
$string['sessionhandling'] = 'Upravljanje sesijama';
$string['sessiontimeout'] = 'Vreme isteka sesije';
$string['settingfileuploads'] = 'Za mormalno funkcionisnje neophodno je  ppostaljanje dadoteka. Molim Vas, dozvolite ovo u PHP konfiguracionoj datoteci.';
$string['settingmemorylimit'] = 'Uočena je nedostatak memorije. Molimo Vas da postavite veći limit za memoriju u PHP podešavaljima.';
$string['settingsafemode'] = 'Moodle nije u potpunosti kompatibilan sa bezbednim režimom. Zamolite administratora server da ga isključi. Pokretanj Moodlea u bezbednom režimu nije podržano, tako da ako to uradite možete očekivati različite probleme.';
$string['showcommentscount'] = 'Prikaži broj komentara';
$string['showdetails'] = 'Prikaži detalje';
$string['showuseridentity'] = 'Prikaži identitet korisnika';
$string['showuseridentity_desc'] = 'Prilikom izbora ili pretrage korisnika, kada se prikazuje spisak korisnika, ova polja se mogu prikazati pored njihovih imena i prezimena. Polja će se prikazati samo onim korisnicima koji imaju mogućnost moodle/site:viewuseridentity capability,  standardno, predavačima i menadžerima. (Ova opcija najviše ima smisla ako izaberete jedno ili dva polja koja su u vašoj instituciji obavezna).';
$string['simplexmlrequired'] = 'Moodle sada zahteva SimpleXML PHP ekstenziju.';
$string['sitemaintenance'] = 'Sajt je u fazi održavanja i trenutno nije dostupan';
$string['sitemaintenancemode'] = 'Režim održavanja sistema';
$string['sitemaintenanceoff'] = 'Održavanje sistema je završeno i sajt je ponovo u normalnom režimu rada';
$string['sitemaintenanceon'] = 'Vaš sajt je trenutno u režimu održavanja (samo administratori mogu da pristupe sajtu)';
$string['sitemaintenanceoncli'] = 'Vaš sajt je trenutno u CLI režimu održavanja. Internet pristup nije dozvoljen.';
$string['sitemaintenancewarning'] = 'Vaš sajt je trenutno u režimu održavanja (samo administratori mogu da pristupe sajtu). Da bi ste vratili sajt u normalan režim rada, <a href="maintenance.php"> isključite režim održavanja</a>.';
$string['sitemaintenancewarning2'] = 'Vaš sajt je trenutno u režimu održavanja (samo administratori mogu da se prijave na sistem). Da biste vratili ovaj sajt u normalan režnim rada, <a href="{$a}">isključite režim održavanja</a>.';
$string['sitepolicies'] = 'Pravila o korišćenju sajta';
$string['sitepolicy'] = 'URL pravila sajta';
$string['sitepolicyguest'] = 'URL adresa pravilnika o ponašanju na sajtu za goste';
$string['sitepolicyguest_help'] = 'Ako imate pravilnik o ponašanju na sajtu koji svi gosti moraju da pročitaju i prihvate, ovde možete navesti URL adresu istog. U suprotnom ostavite ovo polje prazno. Ovo podešavanje može sadržati bilo koju javno dostupnu URL adresu. Napomena: pristup neprijavljenim korisnicima može biti onemogućen korišćenjem podešavanja forcelogin.';
$string['sitepolicy_help'] = 'Ukoliko imate posebna pravila i uputstva za korišćenje sajta koja korisnici moraju da pročitaju  i da ih prihvate onda navedite URL strane na kojoj se nalaze pravila. U suprotnom ostavite ovo polje prazno. URL strane može biti bilo koji - pogodno mesto može biti i datoteka na samom sajtu tj. http://yoursite/file.php/1/policy.html';
$string['sitesectionhelp'] = 'Ukoliko je ovo podešavanje uključeno, tematska sekcija će biti prikazana na naslovnoj stranici sajta.';
$string['slasharguments'] = 'Koristiti slash argumente';
$string['smartpix'] = '"Pametna" pretraga slika';
$string['soaprecommended'] = 'Instaliranje opcione soap ekstenzije je korisno za veb servise i neke nestandardne dodatke za Moodle.';
$string['sort_fullname'] = 'Pun naziv kursa';
$string['sort_idnumber'] = 'ID broj  kursa';
$string['sort_shortname'] = 'Skraćeni naziv kursa';
$string['sort_sortorder'] = 'Redosled sortiranja';
$string['spellengine'] = 'Sistem za proveru pravopisa';
$string['spelllanguagelist'] = 'Spisak jezika za proveru pravopisa';
$string['splrequired'] = 'Moodle zahteva SPL PHP ekstenziju';
$string['stats'] = 'Statistika';
$string['statsfirstrun'] = 'Maksimalni interval procesiranja';
$string['statsmaxruntime'] = 'Maksimalno vreme izvršavanja';
$string['statsmoodleorg'] = 'statistika';
$string['statsruntimedays'] = 'Dana za obradu';
$string['statsruntimestart'] = 'Izvršavanje u';
$string['statsuserthreshold'] = 'Granična vrednost korisnika';
$string['stickyblocks'] = 'Fiksirani blokovi';
$string['stickyblockscourseview'] = 'Stranica kursa';
$string['stickyblocksduplicatenotice'] = 'Ako je bilo koji blok koji ovde dodate već prisutan na nekoj konkretnoj stranici, biće prikazan i njegov duplikat.<br />Jedino što se fiksirani blok neće moći menjati, a duplikat još uvek hoće.';
$string['stickyblocksmymoodle'] = 'Moj Moodle';
$string['stickyblockspagetype'] = 'Vrsta stranice za konfigurisanje';
$string['strictformsrequired'] = 'Striktna provera obaveznih polja';
$string['stripalltitletags'] = 'Ukloni HTML oznake sa svih imena aktivnosti';
$string['supportcontact'] = 'Kontakt za podršku';
$string['supportemail'] = 'Adresa e-pošte za podršku';
$string['supportname'] = 'Ime za podršku';
$string['supportpage'] = 'Web stranica za podršku';
$string['suspenduser'] = 'Suspenduj korisnički nalog';
$string['switchlang'] = 'Promeni lang direktorijum';
$string['systempaths'] = 'Sistemske putanje';
$string['tablenosave'] = 'Promene u gornjoj tabeli se automatski čuvaju.';
$string['tablesnosave'] = 'Promene u gornjim tabelama se automatski čuvaju.';
$string['tabselectedtofront'] = 'U tabelama sa tabovima, da li bi red sa trenutno odabranim tabom trebalo da bude stavljen u prvi plan';
$string['tabselectedtofronttext'] = 'Pomeriti izabrani red na početak';
$string['testsiteupgradewarning'] = 'Trenutno koristite test sajt {$a}; da biste ga ispravno nadogradili , upotrebite interfejs sa komandom linijom';
$string['themedesignermode'] = 'Režim za dizajniranje teme';
$string['themelist'] = 'Spisak grafičkih tema';
$string['themenoselected'] = 'Nijedna grafička tema nije izabrana';
$string['themeresetcaches'] = 'Obriši teme iz keš memorije';
$string['themeselect'] = 'Promeni grafičku temu';
$string['themeselector'] = 'Selektor grafičke teme';
$string['themesettings'] = 'Podešavanja grafičkih tema';
$string['therewereerrors'] = 'Bilo je grešaka u vašim podacima';
$string['thirdpartylibrary'] = 'Biblioteka';
$string['thirdpartylibrarylocation'] = 'Lokacija';
$string['thirdpartylibs'] = 'Nezavisne biblioteke';
$string['timezone'] = 'Podrazumevana vremenska zona';
$string['timezoneforced'] = 'Ovo je administrator sajta proglasio obaveznim';
$string['timezoneisforcedto'] = 'Obavezna upotreba za sve korisnike';
$string['timezonenotforced'] = 'Korisnici mogu odabrati sopstvenu vremensku zonu';
$string['tokenizerrecommended'] = 'Preporučuje se instalacija opcionog PHP Tokenizer dodatka radi poboljšavanja funkcionalnosti za umrežavanje.';
$string['tools'] = 'Administratorski alati';
$string['toolsmanage'] = 'Upravljanje administratorskim alatima';
$string['unattendedoperation'] = 'Automatska instalacija';
$string['unbookmarkthispage'] = 'Ukloni obeleživač sa ove stranice';
$string['unicoderecommended'] = 'Preporučljivo je smeštanje vaših podataka u Unikod (UTF-8) standard. Nove instalacije biće izvršene nad bazama koji kao podrazumevan karakter-set imaju podešen Unikod. Ukoliko vršite nadogradnju, potrebno je pokrenuti UTF-8 proces migracije (pogledati Admin stranu).';
$string['unicoderequired'] = 'Potrebno je da sve vaše podatke smeštate u Unikod formatu (UTF-8).Nove instalacije moraju biti primenjene u bazama podataka koje imaju osnovni karakterni set namešten na Unikod. Ukoliko vršite nadogradnju, potrebno je pokrenuti UTF-8 proces migracije (pogledati Admin stranu).';
$string['uninstallplugin'] = 'Deinstaliraj';
$string['unlockaccount'] = 'Otključaj nalog';
$string['unsettheme'] = 'Ukloni grafičku temu';
$string['unsupported'] = 'Nepodržano';
$string['unsuspenduser'] = 'Aktivirajte korisnički nalog';
$string['updateaccounts'] = 'Ažuriranje postojećih naloga';
$string['updateautocheck'] = 'Automatski proveri dostupnost novih verzija';
$string['updateautocheck_desc'] = 'Ako je ovo podešavanje omogućeno,  vaš sajt će automatski proveravati da li su dostupne nove verzije kako osnovnog Moodle paketa, tako i svih dodataka. Ako postoje dostupne nove verzije, biće poslato obaveštenje e-poštom administratorima sajta.';
$string['updateautodeploy'] = 'Omogući primenu ažuriranja';
$string['updateautodeploy_desc'] = 'Ako je ova opcija omogućena, moći ćete da ažurirate tj. instalirate nove verzije dodataka, direktno sa stranice za administraciju Moodlea. Imajte u vidu, da bi ovo moglo da funkcioniše vaš veb server mora da ima ovlašćenje za upisivanje unutar direktorijuma u kojem se nalazi Moodle instalacija. Ovo se može smatrati potencijalnim rizikom po bezbednost sistema.';
$string['updateavailable'] = 'Dostupna je novija verzija Moodlea!';
$string['updateavailabledetailslink'] = 'Za više informacija pogledajte {$a->url}';
$string['updateavailableforplugin'] = 'Dostupne su novije verzije za neke od vaših dodataka!';
$string['updateavailableinstall'] = 'Instaliraj novu verziju';
$string['updateavailable_moreinfo'] = 'Više informacija...';
$string['updateavailablenot'] = 'Koristite poslednju verziju Moodlea';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Verzija{$a}';
$string['updatecomponent'] = 'Ažuriraj komponentu';
$string['updateminmaturity'] = 'Potrebna zrelost kôda';
$string['updateminmaturity_desc'] = 'Pošalji obaveštenje o novim verzijama samo ako dostupni kôd ima, najmanje, izabrani nivo zrelosti. Nove verzije dodataka koje ne objavljuju zrelost svog kôda uvek se prijavljuju, bez obzira na ovo podešavanje.';
$string['updatenotificationfooter'] = 'Vaš Moodle sajt {$a->siteurl} je konfigurisan da automatski proverava da li su dostupne nove verzije programa. Ovu poruku ste dobili kao administrator sajta. Automatsku proveru novih verzija možete da onemogućite u sekciji \'Administracija sajta\' unutar bloka \'Administracija\'. Način slanja ove poruke možete da prilagodite pomoću svog ličnog podešavanja za \'Slanje poruka\' u sekciji \'Podešavanja mog profila\'.';
$string['updatenotifications'] = 'Obaveštenja o novim verzijama';
$string['updatenotificationsubject'] = 'Dostupne su nove verzije Moodlea ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Obavesti o novim podverzijama';
$string['updatenotifybuilds_desc'] = 'Ako je ovo podešavanje omogućeno,  onda će obaveštenje o novoj verziji Moodle paketa biti poslato i u situacijama kada je dostupna nova podverzija za tekuću verziju programa. Podverzije (builds) predstavljaju kontinuirana poboljšanja date verzije Moodlea. Generalno, ova obaveštenja se objavljuju svake nedelje. Ako je ovo podešavanje onemogućeno, obaveštenje o novoj verziji će biti poslato samo kada se pojavi nova, unapređena verzija. Ovo podešavanje ne utiče na proveru novih verzija dodataka.';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 sadrži nekoliko bezbednosnih popravki za korisničke lozinke i rezervne kopije podataka kako bi se zaštitili korisnički podaci na vašem sajtu. Zbog toga neka od vaših podešavanja i ovlašćenja vezana za rezervne kopije podataka mogu biti promenjena.<br /> Pogledajte <a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 release notes</a> za više detalja.</p>';
$string['upgrade197noticesubject'] = 'Sigurnosno obaveštenje o nadogradnji Moodle 1.9.7 verzije';
$string['upgrade197salt'] = 'Da biste smanjili rizik od krađe lozinki, strogo se preporučuje da podesite tzv. password salt.<br />Pogledajte <a href="{$a}" target="_blank">password salting documentation</a> za detaljnije informacije.';
$string['upgradeerror'] = 'Nepoznata greška u toku nadogradnje {$a->plugin} na verziju {$a->version}. Nije moguće nastaviti.';
$string['upgradeforumread'] = 'Moodle verziji 1.5 je dodata nova opcija za praćenje pročitanih/nepročitanih poruka u forumima. <br />Da biste mogli da koristite ovu opciju morate da <a href={$a}>ažurirate svoje tabele</a>.';
$string['upgradeforumreadinfo'] = 'Moodle verziji 1.5 je dodata nova opcija za praćenje pročitanih/nepročitanih poruka u forumima. Da biste mogli da koristite ovu opciju morate da ažurirate svoje tabele zajedno sa svim informacijama za postojeće poruke na forumima. U zavisnosti od veličine Vašeg sajta takva akcija može potrajati (i do nekoliko sati) i može opteretiti bazu podataka, tako da je najbolje da to obavite kada je server manje opterećen. Ipak, Vaš sajt će u toku osvežavanja biti u funkciji i korisnici neće biti time pogođeni. Kada jednom započnete ovaj proces pustite da se završi (ostavite otvoren prozor svog Web čitača). Ukoliko, ipak, zatvorite prozor: ne brinite, moći ćete ponovo da startujte proces.<br /><br />Da li želite da započnete proces ažuriranja?';
$string['upgradelogs'] = 'Zbog potpune fukcionalnosti, vaši stari zapisi o aktivnostima treba da budu nadograđeni. <a href="{$a}">Više informacija</a>';
$string['upgradelogsinfo'] = 'Nedavno su napravljene određene promene u načinu čuvanja zapisa o aktivnostima. Da biste mogli da vidite sve svoje stare zapise, redom po aktivnostima, potrebno je da ih nadogradite. U zavisnosti od vašeg sajta, to može da potraje (i do nekoliko sati) i da optereti bazu podataka za velike sajtove. Jednom kada započnete ovaj proces, potrebno je da ga pustite da se završi (tako što ćete prozor veb čitača ostaviti otvoren). Ne brinite - dok se zapisi o aktivnostima nadograđuju. vaš sajt će i dalje raditi bez problema za ostale korisnike,.<br /><br />Da li želite sada da nadogradite zapise o aktivnostima?';
$string['upgradepluginsfirst'] = 'Preporučuje se da se prvo instalira sve dostupne nove verzije';
$string['upgradepluginsinfo'] = 'Nadogradnja dodataka';
$string['upgradepluginsinfo_help'] = 'Postoje dostupne nove verzije za neke od vaših dodataka. Trebalo bi da ih sve instalirate pre nadogradnje Moodle baze podataka. Ako vaš sajt ne podržava automatsko ažuriranje, morate da preuzmete i ručno, na serveru, instalirate nove verzije dodataka.';
$string['upgradesettings'] = 'Nova podešavanja';
$string['upgradesettingsintro'] = 'Dole navedena podešavanja su dodata tokom poslednje nadogradnje Moodlea. Napravite sve potrebne promene podrazumevanih vrednosti i kliknite na dugme "Sačuvaj promene" na dnu ove stranice.';
$string['upgradestalefiles'] = 'Otkrivene su izmešane verzije Moodle pa nadogradnja ne može da se nastavi';
$string['upgradestalefilesinfo'] = 'Proces nadogradnje Moodlea je zaustavljen zato što su u Moodle direktorijumu otkrivene PHP skripte iz najmanje dve različite verzije Moodlea

Ovo kasnije može da napravi velike probleme. Kako biste nastavili proces nadogradnje, morate prvo da obezbedite da u Moodle direktorijumu budu datoteke samo jedne verzije Moodlea

Da biste očistili Moodle direktorijum i rešili ovaj problem uradite sledeće:

* promenite naziv tekućeg Moodle direktorijuma u "moodle_old"
* kreirajte novi Moodle direktorijum koji sadrži samo datoteke iz standardnog Moodle paketa, ili iz GIT repozitorijuma.
* prebacite originalnu config.php datoteku i sve nestandardne dodatke iz starog, ”moodle_old”, u novi Moodle direktorijum.

Kada završite opisanu proceduru, osvežite ovu stranicu kako biste nastavili proces nadogradnju Moodlea.

Ovo upozorenje je često posledica raspakivanja standardnog Moodle paketa u postojeći direktorijum, u kojem se nalazi prethodna verzija Moodlea. Iako ovaj postupak ne stvara probleme prilikom manjih nadogradnji, nikako se ne savetuje kada se rade velike nadogradnje Moodlea.

Upozorenje, takođe, može da bude posledica nepotpune provere ili nadogradnje iz GIT repozitorijuma, u kom slučaju ćete morati samo da sačekate da se operacija završi, eventualno pokrenete odgovarajuću komandu za čišćenje i ponovo pokušate operaciju.

Više informacija možete naći u dokumentaciji o nadogradnji na <a href=”{$a}">{$a}</a>';
$string['upgradestart'] = 'Nadogradi Moodle bazu podataka sada';
$string['upgradesure'] = '<p>Vaše Moodle datoteke su izmenjene, i nameravate da automatski nadogradite svoj server na ovu verziju:</p>
<p><strong>{$a}</strong></p>
<p>Jednom kada ovo uradite ne možete se vratiti nazad. Molimo uzmite u obzir i to da ovaj proces može da potraje.</p>
<p>Da li ste sigurni da želite da nadogradite server na ovu verziju?</p>';
$string['upgradetimedout'] = 'Isteklo je vreme za ažuriranje, molimo započnite proces ažuriranja iznova.';
$string['upgradingdata'] = 'Ažuriranje podataka je u toku';
$string['upgradinglogs'] = 'Nadogradnja zapisa o aktivnostima je u toku';
$string['upgradingversion'] = 'Ažuriraj na novu verziju';
$string['upwards'] = 'nagore';
$string['useblogassociations'] = 'Omogući povezivanje';
$string['useexternalyui'] = 'Koristi YUI biblioteke na mreži';
$string['user'] = 'Korisnik';
$string['userbulk'] = 'Masovne akcije nad korisnicima';
$string['userlist'] = 'Pregled spiska korisnika';
$string['userpolicies'] = 'Pravila za korisnike';
$string['userpreference'] = 'Korisnička podešavanja';
$string['userquota'] = 'Korisnička kvota';
$string['users'] = 'Korisnici';
$string['usesitenameforsitepages'] = 'Koristi naziv sajta za stranice sajta';
$string['usetags'] = 'Omogući oznake (tagove)';
$string['validateerror'] = 'Ova vrednost nije valjana:';
$string['verifychangedemail'] = 'Ograniči domene prilikom promene e-adrese';
$string['warningcurrentsetting'] = 'Neispravna trenutna vrednost: {$a}';
$string['warningiconvbuggy'] = 'Vaša verzija iconv biblioteke ne podržava //IGNORE modifikator. Trebalo bi da instalirate ekstenziju mbstring koja može, umesto iconv biblioteke, da se koristi za čišćenje stringova koji sadrže neispravne UTF-8 karaktere.';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Popuni sledeće opcije ukoliko Moodle server ne može da pristupi Internetu direktno. Pristup Internetu je neophodan za preuzimanje podataka o okruženju, jezičkih paketa, RSS izvora vesti, vremenskih zona itd.<br /><em>PHP cURL ekstenzija se preporučuje!!!.</em>';
$string['xmlrpcrecommended'] = 'xmlrpc ekstenzija je potrebna za komunikaciju s čvorištem, a korisna je i za Web servise, kao i za MNet.';
$string['yuicomboloading'] = 'YUI combo se učitava';
$string['ziprequired'] = 'PHP ekstenzija Zip sada je obavezna za Moodle, binarne info-ZIP datoteke i biblioteka PclZip više se ne koriste.';
$string['zlibenabled'] = 'zlib omogućen';
