<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   workshop
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aggregategrades'] = 'གནས་ཚད་ཚུ་ལོག་སྟེ་རྩིས་རྐྱབས།';
$string['aggregation'] = 'གནས་ཚད་སྤྱིར་བསྡོམས།';
$string['allocate'] = 'ཞུ་འབུལ་སྐལཝ་བྱིན།';
$string['allocatedetails'] = 'རེ་རེ་འདོད་: {$a->expected}<br />ཕུལ་ཡོད་པའི་: {$a->submitted}<br />ལུ་  སྤྲོད་: {$a->allocate}';
$string['allocation'] = 'ཞུ་འབུལ་སྐལཝ་བྱིན་ཡོདཔ།';
$string['allocationconfigured'] = 'སྐལཝ་བྱིན་ནི་རིམ་སྒྲིག་འབད་ཡི།';
$string['allocationdone'] = 'སྐལཝ་བྱིན་ཚར་ཡི།';
$string['allocationerror'] = 'སྐལཝ་བྱིན་ནི་མ་བཏུབ།';
$string['allsubmissions'] = 'ཞུ་འབུལ་ཆ་མཉམ།({$a})';
$string['alreadygraded'] = 'གནས་ཚད་བྱིན་ཚར་ཡི།';
$string['areaconclusion'] = 'མཇུག་བསྡུ་གི་ཚིག་ཡིག';
$string['areainstructauthors'] = 'ཞུ་འབུལ་དོན་ལུ་བཀོད་བྱ།';
$string['areainstructreviewers'] = 'དབྱེ་ཞིབ་ཀྱི་དོན་ལུ་བཀོད་བྱ།';
$string['areaoverallfeedbackattachment'] = 'བསམ་ལན་མཉམ་སྦྲགས་ཚུ་ཆ་མཉམ།';
$string['areaoverallfeedbackcontent'] = 'བསམ་ལན་ཚིག་ཡིག་་ཚུ་ཆ་མཉམ།';
$string['areasubmissionattachment'] = 'ཞུ་འབུལ་ཟུར་སྦྲག';
$string['areasubmissioncontent'] = 'ཞུ་འབུལ་ཚིག་ཡིག';
$string['assess'] = 'དབྱེ་ཞིབ།';
$string['assessedexample'] = 'ཞུ་འབུལ་དོན་ལུ་དབྱེ་ཞིབ་འབད་ཚར་ཚར་བའི་དཔེ།';
$string['assessedsubmission'] = 'དབྱེ་ཞིབ་འབད་ཚར་བའིཞུ་འབུལ།';
$string['assessingexample'] = 'ཞུ་འབུལ་དཔེ་དབྱེ་ཞིབ་འབད་དོ།';
$string['assessingsubmission'] = 'ཞུ་འབུལ་དབྱེ་ཞིབ་འབད་དོ།';
$string['assessment'] = 'དབྱེ་ཞིབ།';
$string['assessmentby'] = '<a href="{$a->url}">{$a->name}</a> ་གིས་';
$string['assessmentbyfullname'] = 'དབྱེ་ཞིབ་པ {$a}';
$string['assessmentbyyourself'] = 'ཁྱོད་ཀྱི་དབྱེ་ཞིབ།';
$string['assessmentdeleted'] = 'དབྱེ་ཞིབ་ཀྱི་སྐོར་ལས་ཟུན་ཡོད།';
$string['assessmentend'] = 'དབྱེ་ཞིབ་མཇུག';
$string['assessmentendbeforestart'] = 'དབྱེ་ཞིབ་འབད་དགོ་པའི་ཚེས་གྲངས་འདི་ དབྱེ་ཞིབ་ནམ་ལས་འགོ་བཙུགས་ནི་ཨིན་ན་གི་ཚེས་གྲངས་མ་བཟོ་ཚུན་ཚོད་མི་ཤེས།';
$string['assessmentenddatetime'] = 'དབྱེ་ཞིབ་འབད་ཚར་དགོ་པའི་ཚེས་གྲངས་འདི་: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '$aགི་དོན་ལུ་དབྱེ་ཞིབ་མཇུག';
$string['assessmentform'] = 'དབྱེ་ཞིབ་ཀྱི་འབྲི་ཤོག';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">དབྱེ་ཞིབ</a> of <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'དབྱེ་ཞིབ་ཀྱི་རྒྱབ་རྟེན།';
$string['assessmentreferenceconflict'] = 'དབྱེ་ཞིབ་ཀྱི་རྒྱབ་རྟེན་ལུ་དཔེ་བྱིན་ཡོད་མི་ཞུ་འབུལ་ དཔེ་འདི་དབྱེ་ཞིབ་འབད་མི་ཚུགས།';
$string['assessmentreferenceneeded'] = 'ཁྱོད་ཀྱི་རྒྱབ་རྟེན་བཏོན་ནིའི་དོན་ལུ་སྤྲོད་ཡོད་པའི་ཞུ་འབུལ་དཔེ་འདི་དབྱེ་ཞིབ་འབད་དགོ། \'འཕྲོ་མཐུད་\' ཨེབ་རྟ་འདི་ཨེབ་སྟེ་ལན་གསལ་དབྱེ་ཞིབ་འབད།';
$string['assessmentsettings'] = 'དབྱེ་ཞིབ་ཀྱི་གཞི་སྒྲིག།';
$string['assessmentstart'] = 'དབྱེ་ཞིབ་འགོ་བཙུགས།';
$string['assessmentstartdatetime'] = '{$a->daydatetime} ({$a->distanceday}་ལས་དབྱེ་ཞིབ་དོན་ལུ་ཁ་ཕྱེ།';
$string['assessmentstartevent'] = '{$a} (དབྱེ་ཞིབ་དོན་ལུ་ཁ་ཕྱེ་ཡོད)';
$string['assessmentweight'] = 'དབྱེ་ཞིབ་ཀྱི་ལྗིད་ཚད།';
$string['assignedassessments'] = 'ཞུ་འབུལ་སྦེ་ཡོད་པའི་ལན་གསལ་དབྱེ་ཞིབ།';
$string['assignedassessmentsnone'] = 'ཁྱོད་ལུ་ཞུ་འབུལ་སྦེ་ཡོད་པའི་ལན་གསལ་དབྱེ་ཞིབ་སྦེ་དགོཔ་མིན་འདུག';
$string['backtoeditform'] = 'ཞུན་དག་གི་འབྲི་ཤོག་ནང་ལོག';
$string['byfullname'] = '<a href="{$a->url}">{$a->name}</a>་གིས་';
$string['calculategradinggrades'] = 'དབྱེ་ཞིབ་ཀྱི་གནས་ཚད་རྩིས་བཏོན།';
$string['calculategradinggradesdetails'] = 'རེ་འདོད་: {$a->expected}<br />རྩིས་བཏོན་ཡོདཔ་: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'ཞུ་འབུལ་་ཀྱི་གནས་ཚད་རྩིས་བཏོན།';
$string['calculatesubmissiongradesdetails'] = 'རེ་འདོད་: {$a->expected}<br />རྩིས་བཏོན་ཡོདཔ་: {$a->calculated}';
$string['chooseuser'] = 'ལག་ལེན་པ་གདམ་ཁ་རྐྱབས།';
$string['clearaggregatedgrades'] = 'ཡོངས་བསྡོམས་ཀྱི་གནས་ཚད་ཚུ་ག་ར་མེདཔ་བཟོ།';
$string['clearaggregatedgradesconfirm'] = 'ཁྱོད་ཐད་རི་པ་རི་ཡོངས་བསྡོམས་ཀྱི་གནས་ཚད་ཚུ་ག་ར་ལན་ཞུ་འབུལ་དང་དབྱེ་ཞིབ་འབད་ནིའི་དོན་ལུ་བཏོན་གཏང་ནིའ་ཨིན་ན?';
$string['clearassessments'] = 'དབྱེ་ཞིབ་མེདཔ་བཟོ།';
$string['clearassessmentsconfirm'] = 'ཁྱོད་ཐད་རི་པ་རི་ཡོངས་བསྡོམས་ཀྱི་གནས་ཚད་ཚུ་ག་ར་བཏོན་གཏང་ནི་ཨིན་ན? ཁྱོད་ ཁྱོད་རང་གིས་གནས་ཚུལ་ཚུ་ལོག་ཐོབ་མི་ཚུགས བསྐྱར་ཞིབ་པ་ཚུ་གིས་ ཞུ་འབུལ་འབད་ཚར་མི་ཚུ་ལུ་དབྱེ་ཞིབ་ལོག་སྟེ་འབད་དགོ།';
$string['conclusion'] = 'མཇུག་བསྡུ།';
$string['configexamplesmode'] = 'ཞལ་འཛོམས་ནང་གི་སྔོན་སྒྲིག་དབྱེ་ཞིབ་ཐབས་ལམ་གྱི་དཔེ།';
$string['configgrade'] = 'ཞལ་འཛོམས་ནང་ཞུ་འབུལ་འབད་ནིའི་སྔོན་སྒྲིག་གནས་ཚད་མང་མཐའ་།';
$string['configgradedecimals'] = 'གནས་ཚད་གསལ་སྟོན་འབད་བའི་སྐབས་སུ་ སྔོན་སྒྲིག་འབད་ཡོད་པའི་decimal point་ཤུལ་ལས་ཀྱི་ཨང་གྲངས།';
$string['configgradinggrade'] = 'ཞལ་འཛོམས་ནང་ལུ་སྔོན་སྒྲིག་འབད་ཡོད་པའི་གནས་ཚད་མང་མཐའ།';
$string['configmaxbytes'] = 'སྔོན་སྒྲིག་འབད་ཡོད་པའི་ཡིག་སྣོད་མང་མཐའ་ཞལ་འཛོམས་ག་ར་གི་ས་སྒོ་ནང་ཞུ་འབུལའབད་་ནི་(subject to course limits and other local settings)';
$string['configstrategy'] = 'ཞལ་འཛོམས་ཀྱི་དོན་ལུ་སྔོན་སྒྲིག་གནས་ཚད་བརྟག་ཞིབ་ཀྱི་ལམ་ལུགས།';
$string['createsubmission'] = 'ཁྱོད་རའི་ལན་གསལ་འདི་ཞུ་འབུལ་ནིའི་དོན་ལུ་གྲ་འགྲིགས་འབད།';
$string['daysago'] = '{$a} ཉིམ་གཅིག་གི་ཧེ་མ་ལས།';
$string['daysleft'] = '{$a} འདས་པའི་ཉི་མ་ལས།';
$string['daystoday'] = 'ད་རེས།';
$string['daystomorrow'] = 'ནངས་པ།';
$string['daysyesterday'] = 'ཁ་ཙ།';
$string['deadlinesignored'] = 'དུས་ཚོད་བཀག་འཛིན་འདི་ཁྱོད་ལུ་མེད།';
$string['editassessmentform'] = 'ཞུན་དག་འབད་ཡོད་པའི་འབྲི་ཤོག';
$string['editassessmentformstrategy'] = 'ཞུན་དག་འབད་ཡོད་པའི་འབྲི་ཤོག({$a})';
$string['editingassessmentform'] = 'ཞུན་དག་འབད་ཡོད་པའི་འབྲི་ཤོག';
$string['editingsubmission'] = 'ཞུ་འབུལ་ཞུན་དག་འབད་དོ།';
$string['editsubmission'] = 'ཞུ་འབུལ་ཞུན་དག་འབད།';
$string['err_multiplesubmissions'] = 'ཨ་ནི་འབྲི་ཤོག་འདི་ཞུན་དག་འབད་བའི་བསྒང་ ཞུ་འབུལགཞན་མི་གཅིག་ཡང་སྲུང་བཞག་འབད་ད་ནུག ལག་ལེན་པ་ཚུ་གིས་ཞུ་འབུལ་སྣ་མང་འབད་མི་ཆོག';
$string['err_removegrademappings'] = 'ལག་ལེན་མ་འཐབ་པའི་གནས་ཚད་མཐུན་སྒྲིག་འབད་ནི་འདི་བཏོན་གཏང་མ་ཚུགས་པས།';
$string['evaluategradeswait'] = 'དབྱེ་ཞིབ་ཚུ་འབད་དེ་གནས་ཚད་བརྟག་ཞིབ་སྦེ་འབད་བའི་སྐུགས་ཚུ་མ་འབྱིན་ཚུན་ཚོད་སྒུག་གནང་ཞུ།';
$string['evaluation'] = 'བརྟག་ཞིབ་འབད་དོ།';
$string['evaluationmethod'] = 'བརྟག་ཞིབ་ཀྱི་ཐབས་ལམ་འབད་དོ།';
$string['evaluationsettings'] = 'བརྟག་ཞིབ་གཞི་སྒྲིག་འབད་དོ།';
$string['event_assessable_uploaded'] = 'ཞུ་འབུལ་གཅིག་སྐྱེལ་བཙུགས་འབད་ཡོད།';
$string['example'] = 'ཞུ་འབུལ་གྱི་དཔེ་';
$string['exampleadd'] = 'ཞུ་འབུལ་གྱི་དཔེ་བཙུགས།';
$string['exampleassess'] = 'ཞུ་འབུལ་གྱི་དཔེ་དབྱེ་ཞིབ་འབད།།';
$string['exampleassessments'] = 'ཞུ་འབུལ་གྱི་དཔེ་དབྱེ་ཞིབ་འབད་དགོཔ།';
$string['exampleassesstask'] = 'ལན་གསལ་གྱི་དཔེ་དབྱེ་ཞིབ་';
$string['exampleassesstaskdetails'] = 'རེ་འདོད: {$a->expected}<br />དབྱེ་ཞིབ་ཡོདཔ་: {$a->assessed}';
$string['examplecomparing'] = 'དབྱེ་ཞིབ་ཞུ་འབུལ་གྱི་དཔེ་ག་བསྡུར་་འབད་དོ།';
$string['exampledelete'] = 'དཔེ་གསད་གཏང་།';
$string['exampledeleteconfirm'] = 'ཁྱོད་ཐད་རི་པ་རི་འོག་ལས་མར་ཡོད་མི་གི་ཞུ་འབུལ་སྤྲོད་ཐངས་ཁྱི་དཔེ་ཚུ་གསད་གཏང་ནི་ཨིན་ན? \'འཕྲོ་མཐུད་\' ཨེབ་རྟ་འདི་ཨེབ་སྟེ་ཞུ་འབུལ་བཏོན་གཏང་།';
$string['exampleedit'] = 'དཔེ་ཞུན་དག་རྐྱབས།';
$string['exampleediting'] = 'དཔེ་ཞུན་དག་རྐྱབ་དོ།';
$string['exampleneedassessed'] = 'དང་པ་ར་ཁྱོད་ཀྱིས་དབྱེ་ཞིབ་འབད་ཐངས་ཀྱི་དཔེ་ཞུ་འབུལ་ཚུ་དབྱེ་ཞིབ་འབད་གོ།';
$string['exampleneedsubmission'] = 'ཁྱོད་ཀྱིས་ཁྱོད་རའི་ལཱ་ཚུ་སྤྲོད་དགོ་ དེ་ལས་དང་པ་ར་དཔེ་དབྱེ་ཞིབ་སྦེ་འབདཝ་ཞུ་འབུལ་ཚུ་སྤྲོག་དགོ།';
$string['examplesbeforeassessment'] = 'ཁྱོད་ཀྱིས་ཞུ་འབུལ་སྤྲོད་ཚར་བའི་ཤུལ་མ་ར་དཔེ་འདི་ཚུ་ཐོབ་ འདི་འབདཝ་ད་དབྱེ་ཞིབ་འདི་ཆ་རོགས་ཀྱིས་འབད་མ་ཚར་བའི་ཧེ་འབད་དགོ';
$string['examplesbeforesubmission'] = 'ཞུ་འབུལ་གྱི་དཔེ་འདི་དབྱེ་ཞིབ་འདི་ཆ་རོགས་ཀྱིས་འབད་མ་ཚར་བའི་ཧེ་འབད་དགོ';
$string['examplesmode'] = 'དབྱེ་ཞིབ་དཔེ་གི་ཐབས་ལམ།';
$string['examplesubmissions'] = 'ཞུ་འབུལ་དཔེ།';
$string['examplesvoluntary'] = 'ཞུ་འབུལ་དཔེ་སྤྲོད་ཀྱི་དབྱེ་ཞིབ་འདི་རང་གི་བློ་འདོད་ལྟར་དུ་འབད་ཆོག';
$string['feedbackauthor'] = 'རྩོམ་བྲིས་པ་ལུ་བསམ་ལེན།';
$string['feedbackauthorattachment'] = 'མཉམ་སྦྲགས།';
$string['feedbackby'] = '{$a} ་གིས་བསམ་ལེན།';
$string['feedbackreviewer'] = 'བསྐྱར་ཞིབ་པ་ལུ་བསམ་ལེན།';
$string['feedbacksettings'] = 'བསམ་ལེན';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'གནས་ཚད་བྱིན་ཡི།';
$string['gradecalculated'] = 'ལན་གསལ་གྱི་དོན་ལུ་གནས་ཚད་ཀྱི་རྩིས།';
$string['gradedecimals'] = 'གནས་ཚད་ཀྱི་ནང་ལུ་Decimal་གི་ས་སྒོ།';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'སྡེ་རིམ་:  {$a->max}་ལས་{$a->received}';
$string['gradeitemassessment'] = '{$a->workshopname} (དབྱེ་ཞིབ་)';
$string['gradeitemsubmission'] = '{$a->workshopname} (ཞུ་འབུལ་)';
$string['gradeover'] = 'ཞུ་འབུལ་ལུ་ གནས་ཚད་སྤྲོད་ནི་མེདཔ་གཏང་།';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'ཞལ་འཛོམས་གནས་ཚད་ཀྱི་སྙན་ཞུ།';
$string['gradinggrade'] = 'སྡེ་རིམ་ཕྱེ་དོ།';
$string['gradinggradecalculated'] = 'དབྱེ་ཞིབ་ཀྱི་དོན་རྩིས་བཏོན་ཡོད་པའི་གནས་ཚད།';
$string['gradinggradeof'] = 'དབྱེ་ཞིབ་ཀྱི་གནས་ཚད། {$a})';
$string['gradinggradeover'] = 'གནས་ཚད་དབྱེ་ཞིབ་མ་བཏུབ་བཟོ།';
$string['gradingsettings'] = 'གནས་ཚད་ཀྱི་གཞི་སྒྲིག';
$string['groupnoallowed'] = 'ཁྱོད་ཨ་ནི་ཞལ་འཛོམས་ནང་སྡེ་ཚན་ག་ན་ཡང་འཛུལ་སྤྱོད་འབད་མི་ཆོག་པས།';
$string['iamsure'] = 'ཨིན་ ང་ཐད་རི་པ་རི།';
$string['info'] = 'བརྡ་དོན།';
$string['instructauthors'] = 'ལན་གསལ་འབད་ནིའི་དོན་ལུ་བཀོད་བྱ།';
$string['instructreviewers'] = 'དབྱེ་ཞིབ་འབད་ནིའི་དོན་ལུ་བཀོད་བྱ།';
$string['introduction'] = 'ང་སྤྲོད།';
$string['latesubmissions'] = 'དུས་ཚོད་ཕྱི་སྤྲོད།';
$string['latesubmissionsallowed'] = 'དུས་ཚོད་ཕྱི་སྤྲོད་འབད་མི་ཆོག།';
$string['latesubmissions_desc'] = 'ཞག་དུས་ཐལ་ཚརཝ་ད་ལན་གསལ་འབད་ཆོག';
$string['modulename'] = 'ཝག་ཤོཔ།';
$string['modulenameplural'] = 'ཝག་ཤོཔ་ཚུ།';
$string['mysubmission'] = 'ངེ་གི་ལན་གསལ།';
$string['nattachments'] = 'ཞུ་འབུལ་མཉམ་སྦྲགས་ཚུའི་མང་མཐའ་ཨང་';
$string['noexamples'] = 'ཞལ་འཛོམས་འདི་ནང་ལུ་ད་ལྟོ་དཔེ་ཚུ་མིན་འདུག';
$string['noexamplesformready'] = 'ཁྱོད་ཀྱིས་ལན་གསལ་གྱི་དཔེ་མ་སྤྲོད་པའི་ཧེ་མ་དབྱེ་ཞིབ་ཀྱི་འགྲེལ་ད་བཤད་བརྐྱབ་དགོ';
$string['nogradeyet'] = 'ད་ལྟོ་གནས་ཚད་མིན་འདུག';
$string['nosubmissionfound'] = 'ལག་ལན་པ་འདི་གི་ལན་གསལ་མི་འདུག';
$string['nosubmissions'] = 'ཨ་ནི་ཞལ་འཛོམས་འདི་ནང་ལུ་ད་ལྟོ་ལན་གསལ་མིན་འདུག';
$string['notassessed'] = 'ད་ལྟོ་དབྱེ་ཞིབ་མ་འབད་བས།';
$string['nothingtoreview'] = 'བསྐྱར་ཞིབ་འབད་ནི་ག་ནི་ཡང་མིན་འདུག';
$string['notoverridden'] = 'མེད་མ་བཟོ་བས།';
$string['noworkshops'] = 'སློབ་ཚན་འདི་གི་ནང་ལུ་ཞལ་འཛོམས་མིན་འདུག';
$string['noyoursubmission'] = 'ཁྱོད་ཀྱིས་་ད་ལྟོ་ ཁྱོད་ཀྱི་ལཱ་ཚུ་མ་སྤྲོད་པས།';
$string['overallfeedback'] = 'བསམ་ལན་ ཚུ་ཆ་མཉམ།';
$string['page-mod-workshop-x'] = 'ག་འབད་རུང་མོ་ཌེལ་ཞལ་འཛོམས་ཀྱི་ཤོག་ལེབ།';
$string['participant'] = 'བཅའ་མར་གཏོགས་མི།';
$string['participantrevierof'] = 'བཅའ་མར་གཏོགས་མི་འདི་ བསྐྱར་ཞིབ་པ།';
$string['participantreviewedby'] = 'བཅའ་མར་གཏོགས་མི་འདི་ བསྐྱར་ཞིབ་';
$string['phaseassessment'] = 'དབྱེ་ཞིབ་ཀྱི་གོ་རིམ།';
$string['phaseclosed'] = 'བསྡམས་ཡོདཔ།';
$string['phaseevaluation'] = 'བརྟག་ཞིབ་ཀྱི་གནས་ཚད་གོ་རིམ།';
$string['phasesetup'] = 'གོ་རིམ་གཞི་བཙུགས།';
$string['phasesoverlap'] = 'སྤྲོད་ནི་གི་གོ་རིམ་དང་དབྱེ་ཞིབ་ཀྱི་གོ་རིམ་ཁ་ཐུག་བརྐྱབ་ནི་མི་འོང་།';
$string['phasesubmission'] = 'སྤྲོད་ནིའི་གོ་རིམ།';
$string['pluginadministration'] = 'ཞལ་འཛོམས་ཀྱི་བདག་སྐྱོང་པ།';
$string['pluginname'] = 'ཞལ་འཛོམས།';
$string['prepareexamples'] = 'སྤྲོད་ནིའི་་དཔེ་བཅའ་སྒྲིག་རྐྱབས།';
$string['previewassessmentform'] = 'སྔོན་ལྟ།';
$string['publishedsubmissions'] = 'ལན་གསལ་ཚུ་བཀྲམ་སྤེལ་འབད་ཡི།';
$string['publishsubmission'] = 'ལན་གསལ་བཀྲམ་སྤེལ།';
$string['reassess'] = 'ཡང་བསྐྱར་དབྱེ་ཞིབ།';
$string['receivedgrades'] = 'གནས་ཚད་ཐོབ་ཡོདཔ།';
$string['recentassessments'] = 'ཞལ་འཛོམས་ཀྱི་དབྱེ་ཞིབ།';
$string['recentsubmissions'] = 'ཞལ་འཛོམས་ཀྱི་རྩིས་སྤྲོད།';
$string['saveandclose'] = 'སྲུང་བཞག་སྟེ་བསྡམས།';
$string['saveandcontinue'] = 'སྲུང་མཞག་སྟེ་འཕྲོ་མཐུད་ཞུན་དག་འབད།';
$string['saveandpreview'] = 'སྲུང་བཞག་སྟེ་སྔོན་ལྟ་འབད།';
$string['selfassessmentdisabled'] = 'རང་བཞིན་གྱིས་དབྱེ་ཞིབ་འབད་ནི་ལྕོགས་མིན་བཟོ་ཡི།';
$string['showingperpage'] = '{$a}ཤོག་ལེབ་རེ་རེ་བཞིན་དུ་གི་ཐོ་སྟོན་ནི།';
$string['showingperpagechange'] = 'སོར།';
$string['someuserswosubmission'] = 'རྩོམ་བྲིས་པ་གཅིག་གིས་ལཱ་ད་ལྟོ་ཡང་ལཱ་མསྲོད་པར་འདུག';
$string['sortasc'] = 'ཕར་འཕེལ་གྱི་ལཱ།';
$string['sortdesc'] = 'མར་ཉམས་ཀྱི་ལཱ།';
$string['strategy'] = 'གནས་ཚད་ཀྱི་ལམ་ལུགས།';
$string['strategyhaschanged'] = 'འབྲི་ཤོག་འདི་ཞུན་དག་གི་དོན་ལུ་གོ་སྐབས་འབྱིན་ཡོདཔ་ལས་ གནས་ཚད་ཀྱི་ལམ་ལུགས་འདི་བསྒྱུར་བཅོས་ཡང་སོང་ནུག';
$string['submission'] = 'ཞུ་འབུལ།';
$string['submissionattachment'] = 'ཟུར་སྦྲགས།';
$string['submissionby'] = 'ཞུ་འབུལ། {$a}';
$string['submissioncontent'] = 'ཞུ་འབུལ་བའི་ནང་དོན།';
$string['submissionend'] = 'ཞུ་འབུལ་མཇུག';
$string['submissionendbeforestart'] = 'ཞུ་འབུལ་གྱི་མཇུག་ཚེས་འདི་གཏན་འཁེལ་བཟོ་མི་ཚུགས་ ཧེ་མ་འབུལ་ཚེས་འདི་འདི་མ་སླབ་ལས།';
$string['submissionenddatetime'] = 'ཞུ་འབུལ་མཇུག་ཚེས: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '$aགི་ཞུ་འབུལ་མཇུག';
$string['submissionendswitch'] = 'ཞུ་འབུལ་མཇུག་གི་ཚེས་གརངས་ལས་གོ་ིམ་གཉིས་པར་ནང་ལུ་སོང་།';
$string['submissiongrade'] = 'ཞུ་འབུལ་གྱི་གནས་ཚད།';
$string['submissiongradeof'] = 'ཞུ་འབུལ་གྱི་གནས་ཚད།{$a})';
$string['submissionsettings'] = 'ཞུ་འབུལ་གྱི་སྒྲིག་གཞི།';
$string['submissionstart'] = 'ཞུ་འབུལ་འགོ་བཙུགས།';
$string['submissionstartdatetime'] = 'ཞུ་་འབུལ་འགོ་བཙུགས།{$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '$aགི་དོན་ལུ་ཞུ་འབུལ་འགོ་བཙུགས།';
$string['submissiontitle'] = 'འགོ་མིང་།';
$string['subplugintype_workshopallocation'] = 'ཞུ་ལེན་སྤྲོད་ཡ་ཆོག་པའི་ཐབས་ལམ།';
$string['subplugintype_workshopallocation_plural'] = 'ཞུ་འབུལ་སྤྲོད་མ་ཆོག་པའི་ཐབས་ལམ་ཚུ།';
$string['subplugintype_workshopeval'] = '་གནས་ཚད་བརྟག་ཞིབ་ཀྱིཐབས་ལམ་།';
$string['subplugintype_workshopeval_plural'] = '་གནས་ཚད་བརྟག་ཞིབ་ཀྱིཐབས་ལམ་ཚུ';
$string['subplugintype_workshopform'] = 'གནས་ཚད་ཀྱི་ལམ་ལུགས།';
$string['subplugintype_workshopform_plural'] = 'གནས་ཚད་ཀྱི་ལམ་ལུགས་ཚུ།';
$string['switchingphase'] = 'གོ་རིམ་སོར་ནི།';
$string['switchphase'] = 'གོ་རིམ་སོར།';
$string['switchphase10info'] = 'ཁྱོད་ཞལ་འཛོམས་ཀྱི་གོ་རིམ་སོར་ནི་འབད་དོ་<strong>Setup phase</strong>.གོ་རིམ་འདི་ནང་ ལག་ལེན་པ་ཚུ་གིས་ཁོང་རའི་ཞུ་ལན་ཚུ་ནང་བསྒྱུར་བཅས་དང་དབྱེ་ཞིབ་འབད་མི་ཚུགས། སློབ་སྟོན་པ་ཚུ་གིས་གོ་རིམ་འདི་ལག་ལེན་འཐབ་སྟེ་ ཞལ་འཛོམས་ཀྱི་གཞི་སྒྲིག་སོར་ནི་དང་ གནས་ཚད་བསྒྱུར་བཅོས་འབད་ནི་ ཡང་ན་ དབྱེ་ཞིབ་ཀྱི་འབྲི་ཤོག་ཚུ།';
$string['switchphase20info'] = 'ཁྱོད་ཞལ་འཛོམས་ཀྱི་གོ་རིམ་སོར་ནི་འབད་དོ <strong>Submission phase</strong>. སློབ་ཕྲུག་ཚུ་གིས་གོ་རིམ་འདི་གི་སྐབས་ལུ་ཁོང་རའི་ལཱ་ཚུ་སྤྲོད་ཚུགས(within the submission access control dates, if set). སློབ་སྟོན་པ་ཚུ་གིས་ཡང་ཁོང་རང་ནང་དོ་བསྐྱབ་ཞིབ་འབད་ནིའི་གོ་སྐབས་འབྱིན་དགོ';
$string['switchphase30auto'] = 'ཞལ་འཛོམས་འདི་རང་བཞིན་གྱིས་དབྱེ་ཞིབ་ཀྱི་གོ་རིམ་ནང་ལུ་སོར་འགྱོ་འོང་། {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'ཁྱོད་ཞལ་འཛོམས་ཀྱི་གོ་རིམ་སོར་ནི་འབད་དོ<strong>Assessment phase</strong>.ཨ་ནི་གོ་རིམ་འདི་ནང་ བསྐྱར་ཞིབ་པ་ཚུ་གིས་ འབུལ་ཞུ་ཚུ་དབྱེ་ཞིབ་ནི་སྤྲོད་ཡོད་མི་དང་འཁྲིལ་ཏེ་འབད་ཆོག(within the assessment access control dates, if set).';
$string['switchphase40info'] = 'ཁྱོད་ཞལ་འཛོམས་ཀྱི་གོ་རིམ་སོར་ནི་འབད་དོ<strong>Grading evaluation phase</strong>.གོ་རིམ་འདི་ནང་ལུ་ ལག་ལེན་པ་ཚུ་གིས་ཁོང་རང་གི་ཞུ་འབུལ་དང་དབྱེ་ཞིབ་ཚུ་བསྒྱུར་བཅས་འབད་མི་ཚུགས། སློབ་སྟོན་པ་ཚུ་གིས་ གནས་ཚད་བརྟག་ཞིབ་ཀྱི་ལག་ཆས་ལག་ལེན་འཐབ་སྟེ་མཐའ་མཇུག་གི་གནས་ཚད་བཏོན་ཏེ་བསྐྱར་ཞིབ་པ་ཚུ་ལུ་བསམ་ལེན་སྤྲོད་ཚུགས།';
$string['switchphase50info'] = 'ཁྱོད་ཞལ་འཛོམས་ཀྱི་གོ་རིམ་སོར་ནི་འབད་དོ། འདི་གིས་རྩིས་བསྡོམས་བཏོན་ཡོད་པའི་ གནས་ཚད་ཚུ་ རྩིས་དེབ་མ་ཡིག་ནང་ལུ་འཐོན་འོང་། སློབ་ཕྲུག་ཚུ་གིས་ཁོང་རའི་ཞུ་འབུལ་དང་ དེ་ལུ་དབྱེ་ཞིབ་སྦེ་འབདཝ་ཚུ་ལྟ་ཚུགས།';
$string['taskassesspeers'] = 'ཆ་རོགས་དབྱེ་ཞིབ་འབད།';
$string['taskassesspeersdetails'] = 'total: {$a->total}<br />pending: {$a->todo}';
$string['taskassessself'] = 'ཁྱོད་རང་གིས་ རང་དབྱེ་ཞིབ་འབད།';
$string['taskconclusion'] = 'ལཱ་གི་མཇུག་བསྡུ་སྟོན།';
$string['taskinstructauthors'] = 'ཞུ་འབུལ་གྱི་བཀོད་བྱ་ཚུ་སྟོན།';
$string['taskinstructreviewers'] = 'ཞུ་འབུལ་གྱི་དབྱེ་ཞིབ་ཚུ་སྟོན།';
$string['taskintro'] = 'ཞལ་འཛོམས་ཀྱི་ངོ་སྤྲོད་གཞི་སྒྲིག་འབད།';
$string['tasksubmit'] = 'ཁྱོད་རའི་ལཱ་སྤྲོད།';
$string['toolbox'] = 'ཞལ་འཛོམས་ཀྱི་ལག་ཆས་སྒྲོམ།';
$string['undersetup'] = 'ཞལ་འཛོམས་འདི་ད་ལྟ་གཞི་སྒྲིག་འབད་དེ་ཡོད། གོ་རིམ་གཉིས་པ་ནང་མ་འགྱོ་ཚུན་ཚོད་སྒུག་སྡོད།';
$string['useexamples'] = 'དཔེ་ཚུ་ལག་ལེན་འཐབ།';
$string['useexamples_desc'] = 'དབྱེ་ཞིབ་སྦྱང་བ་འབད་ནིའི་དོན་ལས་དཔེ་འདི་ཚུ་ཞུ་འབུལ་འབད་དེ་ཡོད།';
$string['usepeerassessment'] = 'ཆ་རོགས་ཀྱི་དབྱེ་ཞིབ་ལག་ལེན་འཐབ།';
$string['usepeerassessment_desc'] = 'སློབ་ཕྲུག་ཚ་གིས་གཞ་ནམི་ཚུ་གི་ལཱ་དབྱེ་ཞིབ་འབད་ཆོག';
$string['userdatecreated'] = 'submitted on <span>{$a}</spa';
$string['userdatemodified'] = 'modified on <span>{$a}</span>';
$string['userplan'] = 'ཞལ་འཛོམས་ཀྱི་འཆར་བཀོད་པ།';
$string['useselfassessment'] = 'རང་གིས་ རང་ལུ་དབྱེ་ཞིབ་འབད་ནི་འདི་ལག་ལེན་འཐབ།';
$string['useselfassessment_desc'] = 'སློབ་ཕྲུག་ཚུ་རང་གིས་རང་ལུ་དབྱེ་ཞིབ་འབད་ཆོག';
$string['weightinfo'] = 'ལྗིད: {$a}';
$string['withoutsubmission'] = 'བསྐྱར་ཞིབ་པ་རང་གི་ཞུ་འབུལ་མེད་མི།';
$string['workshop:addinstance'] = 'ཞལ་འཛོམས་གསརཔ་གཅིག་བཙུགས།';
$string['workshop:allocate'] = 'བསྐྱར་ཞིབ་ཀྱི་དོན་ལུ་ཞུ་འབུལ་གྱི་གོ་སྐབས་འབྱིན།';
$string['workshop:editdimensions'] = 'དབྱེ་ཞིབ་ཀྱི་འབྲི་ཤོག་ཞུནདག་འབད།';
$string['workshop:ignoredeadlines'] = 'དུས་ཚོག་དབང་འཛིན་མེདཔ་བཟོ།';
$string['workshop:manageexamples'] = 'དཔེ་གི་ཞུ་འབུལ་འཛིན་སྐྱོང་འབད།';
$string['workshopname'] = 'ཞལ་འཛོམས་ཀྱི་མིང་།';
$string['workshop:overridegrades'] = 'གནས་ཚད་རྩིས་བཏོན་ཡོད་མི་ཚུ་ཆ་མེད་བཟོ།';
$string['workshop:peerassess'] = 'ཆ་རོགས་ཀྱི་དབྱེ་ཞིབ།';
$string['workshop:publishsubmissions'] = 'ཞུ་འབུལ་ཚུ་སྤར་བསྐྲུན།';
$string['workshop:submit'] = 'སྤྲོད།';
$string['workshop:switchphase'] = 'གོ་རིམ་སོར།';
$string['workshop:view'] = 'ཞལ་འཛོམས་ལུ་ལྟ།';
$string['workshop:viewallassessments'] = 'དབྱེ་ཞིབ་ག་ར་ལྟ།';
$string['workshop:viewallsubmissions'] = 'ཞུ་འབུལ་ག་ར་ལྟ།';
$string['workshop:viewauthornames'] = 'རྩོམ་བྲིས་པའི་མིང་ལྟ།';
$string['workshop:viewauthorpublished'] = 'ཞུ་འབུལ་སྤར་བསྐྲུན་འབད་ཚར་མི་ཚུ་གི་མིང་ལྟ།';
$string['workshop:viewpublishedsubmissions'] = 'ཞུ་འབུལ་སྤར་བསྐྲུན་འབད་ཚར་མི་ཚུ་ལྟ།';
$string['workshop:viewreviewernames'] = 'བསྐྱར་ཞིབ་པ་ཚུ་གི་མིང་ལྟ།';
$string['yourassessment'] = 'ཁྱོད་ཀྱི་དབྱེ་ཞིབ།';
$string['yourgrades'] = 'ཁྱོད་ཀྱི་གནས་ཚད།';
$string['yoursubmission'] = 'ཁྱོད་ཀྱི་ཞུ་འབུལ།';
