<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assignment', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   assignment
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'ཁྱོད་ལུ་ལས་འགུལ་དྲན་བཏོན་འབད་དགོ་འདུག།';
$string['addsubmission'] = 'ཞུ་འབུལ་ཁ་སྐོང་རྐྱབས།';
$string['allowdeleting'] = 'བཏོན་གཏང་ནི་ཆོག།';
$string['allowmaxfiles'] = 'ཡིག་སྣོད་སྐྱེལ་བཙུགས་འབད་ཡོད་པའི་ ཨང་མཐོ་ཤོས།';
$string['allownotes'] = 'དྲན་འཛིན་ཚུ་ བཀོད་ཆོག།';
$string['allowresubmit'] = 'ལོག་སྤྲོད་ ཆོག།';
$string['alreadygraded'] = 'ཁྱོད་རའི་ལས་འགུལ་འདི་ལུ་ སྐུགས་བྱིན་ཡོདཔ་ལས་ ལོག་ཞུ་འབུལ་སྤྲོད་མི་ཆོག།';
$string['assignment:addinstance'] = 'ལས་འགུས་གསརཔ་གཅིག་ཁ་སྐོང་རྐྱབས།';
$string['assignmentdetails'] = 'ལས་འགུལ་ཁ་གསལ།';
$string['assignment:exportownsubmission'] = 'རང་གི་ཞུ་འབུལ་ ཕྱིར་འདྲེན་འབད།';
$string['assignment:exportsubmission'] = 'ཞུ་འབུལ་ ཕྱིར་འདྲེན་འབད།';
$string['assignment:grade'] = 'ལས་འགུལ་ལུ་ སྐུགས་བྱིན།';
$string['assignmentmail'] = '{$a->teacher}་གིས་ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་ \'{$a->assignment}\' དོན་ལུ་བསམ་བཀོད་དག་པ་ཅིག་ བརྡ་འཕྲིན་འབད་བཀོད་ནུག། ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་གུར་ ཆན་བཏགས་ཡོདཔ་མཐོང་་: {$a->url}';
$string['assignmentmailhtml'] = '{$a->teacher}  གིས་ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་\'<i>{$a->assignment}</i>\'<br /><br />དོན་ལུ་བསམ་བཀོད་དག་པ་ཅིག་བརྡ་འཕྲིན་འབད་བཀོད་ནུག། དེ་ ཁྱོད་ཀྱིས་<a href="{$a->url}">ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་</a>གུར་ཆན་བཏགས་ཡོདཔ་མཐོང་་: {$a->url}';
$string['assignmentmailsmall'] = '{$a->teacher}་གིས་ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་ \'{$a->assignment}\' དོན་ལུ་བསམ་བཀོད་དག་པ་ཅིག་ བརྡ་འཕྲིན་འབད་བཀོད་ནུག། ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་གུར་ ཆན་བཏགས་ཡོདཔ་མཐོང་།';
$string['assignmentname'] = 'ལས་འགུལ་གྱི་མིང་།';
$string['assignmentsubmission'] = 'ལས་འགུལ་ཞུ་འབུལ་ཚུ།';
$string['assignment:submit'] = 'ལས་འགུལ་ སྤྲོད།';
$string['assignmenttype'] = 'ལས་འགུལ་དབྱེ་བ།';
$string['assignment:view'] = 'ལས་འགུལ་ ལྟ།';
$string['availabledate'] = 'ལས་་འཐོབ།';
$string['cannotdeletefiles'] = 'འཛོལ་བ་བྱུང་ཡོདཔ་ལས་ཡིག་སྣོད་ཚུ་ བཏོན་གཏང་མ་ཚུགས།';
$string['cannotviewassignment'] = 'ཁྱོད་ཀྱིས་ལས་འགུལ་འདི་ལྟ་ནི་མི་ཐོབ་པས།';
$string['changegradewarning'] = 'ལས་འགུལ་འདི་ཞུ་འབུལ་འབད་ཡོད་པའི་སྐུགས་བྱིན་ཚར་ཏེ་འདུག་ འདི་འབདཝ་ལས་གནས་ཚད་སོར་བ་གིས་ རང་བཞིན་གི་འབད་ད་ལྟོ་བྱིན་ཚར་ཡོད་པའི་སྐུགས་ཚད་ཚུ་་ལོག་རྩི་མི་བརྐྱབ།  ཁྱོད་སྐུགས་ཚད་སོར་དགོ་མནོ་བཅིན་ ད་ལྟོ་ཞུ་འབུལ་འབད་ཡོད་མི་ཚུ་ག་ར་སྐུགས་ཚད་ལོག་སྟེ་འབྱིན་དགོ།';
$string['closedassignment'] = 'སྤྲོད་ནི་གི་དུས་ཚད་དེ་ཐལ་སོངཔ་ལས་ ལས་འགུལ་དེ་བསྡམ་ཡོད།';
$string['comment'] = 'བསམ་བཀོད།';
$string['commentinline'] = 'བསམ་བཀོད་ གྱལ་རིམ་ནང་བཀོད།';
$string['configitemstocount'] = 'སློབ་ཕྲུག་གིས་གློག་ལམ་ཐོག་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་ཚུ་ནང་་ལུ་ དོན་ཚན་གྱི་དབྱེ་བ་ཚུ་ཚུད་དགོ།';
$string['configmaxbytes'] = 'ས་ཁོངས་ནང་ལུ་ཡོད་པའི་ལས་འགུལ་གེ་ར་གྱི་དོན་ལུ་ སྔོན་སྒྲིག་ལས་འགུལ་གི་ཚད ་མཐོ་ཤོས།(དོན་ཚན་ལས་སློབ་ཚན་ ཚད་ལྡན་དང་གཞན་མི་ཉེ་གནས་གཞི་སྒྲིག)';
$string['configshowrecentsubmissions'] = 'འཕྲལ་གྱི་སྦྱོང་ལཱ་སྙན་ཞུ་ཚུ་ནང་  ཞུ་འབུལ་གྱི་བརྡབསྐུལ་ གེ་ར་གིས་མཐོང་ཚུགས།';
$string['confirmdeletefile'] = '<br /><strong>{$a}</strong>ཡིག་སྣོད་བཏོན་གཏང་ནི་གུར་ ཁྱོད་ཀྱི་འཐད་རེ་བ་རེ་ཐག་ཆོད་ཅི་ག?';
$string['coursemisconf'] = 'སློབ་ཚན་འདི་རིམ་སྒྲིག་མ་འབད་བས།';
$string['currentgrade'] = 'ད་ལྟོ་གི་སྐུགས་འདི་ སྐུགས་ཤོག་གི་མ་དེབ་ནང་འདུག';
$string['deleteallsubmissions'] = 'ཞུ་འབུལ་ཚུ་ག་ར་ བཏོན་གཏང་།';
$string['deletefilefailed'] = 'ཡིག་སྣོད བཏོན་གཏང་ནི་འདི་འཐུས་ཤོར་བྱུང་ཡོད།';
$string['description'] = 'འགྲེལ་བཤད།';
$string['downloadall'] = 'ལས་འགུལ་ཚུ་ག་ར་ཡིག་སྣོད་ཛིབ་ནང་ཕབ་ལེན་འབད།';
$string['draft'] = 'ཟིན་བྲིས།';
$string['due'] = 'ལས་འགུལ་སྤྲོད་དགོ་པའི་ཞག་དུས།';
$string['duedate'] = 'སྤྲོད་ཚེས་།';
$string['duedateno'] = 'ཞག་དུས་ཀྱི་་ཚེས་གྲངས་ མིན་འདུག།';
$string['early'] = '{$a}སྔ་ཆའི།';
$string['editmysubmission'] = 'ངེ་གི་ཞུ་འབུལ་འདི་ཞུན་དག་རྐྱབ།';
$string['editthesefiles'] = 'ཡིག་སྣོད་འདི་ཚུ་ཞུན་དག་འབད།';
$string['editthisfile'] = 'ཡིག་སྣོད་འདི་ཚུ་དུས་མཐུན་བཟོ།';
$string['emailstudents'] = 'སློབ་ཕྲུག་ཚུ་ལུ་གློག་འཕྲིན་གྱི་དྲན་བརྡ།';
$string['emailteachermail'] = '{$a->username} གིས་ཁོང་གི་ལས་འགུལ་ཞུ་འབུ་འདི་ \'{$a->assignment}\' ལུ་{$a->timeupdated} ཨ་ནི་འདི་ལཱ་ལུ་ཡོད: {$a->url}';
$string['emailteachermailhtml'] = '{$a->username} གིས་ཁོང་གི་ལས་འགུལ་ཞུ་འབུ་འདི་ \'{$a->assignment}\' ལུ་{$a->timeupdated} ཨ་ནི་འདི་ལཱ་ལུ་ཡོད: {$a->url}';
$string['emailteachers'] = 'སློབ་དཔོན་ཚུ་ལུ་ གློག་འཕྲིན་གྱི་དྲན་བརྡ།';
$string['emptysubmission'] = 'ཁྱོད་ཀྱི་ད་ཚུན་ག་ནི་ཡང་མ་སྤྲོད་པས།';
$string['enablenotification'] = 'ཁྱབ་བསྒྲགས་གཏང་།';
$string['errornosubmissions'] = 'ཞུ་འབུལ་ཕབ་ལེན་འབད་དགོཔ་མིན་འདུག';
$string['existingfiledeleted'] = ':{$a}ནང་ཡོད་པའི་ཡིག་སྣོད་འདི་བཏོན་གཏང་ནུག';
$string['failedupdatefeedback'] = '{$a} ལག་ལེན་པ་ལུ་ཞུ་འབུལ་གྱི་བསམ་ལན་དུས་མཐུན་བཟོ་ནི་དེ་འཐུས་ཤོར་བྱུང་འདུག';
$string['feedback'] = 'བསམ་ལན།';
$string['feedbackfromteacher'] = '{$a} ལས་བསམ་ལན།';
$string['feedbackupdated'] = '{$a}  མི་ཚུ་གི་དོན་ལུ་ ཞུ་འབུལ་ཚུ་གི་བསམ་ལན་ དུས་མཐུན་བཟོ་ཡོདཔ།';
$string['finalize'] = 'ཞུ་འབུལ་དུས་མཐུན་བཟོ་ནི་བཀག་བཞག།';
$string['finalizeerror'] = '་འཛོལ་བ་བྱུང་ཡོདཔ་ལས་ ཞུ་འབུལ་དེ་གཏན་འཁེལ་འགྱོ་མ་ཚུགས།';
$string['futureaassignment'] = 'ཨ་ནི་ལས་འགུལ་དེ་ད་ལྟོ་ཐོབ་མི་ཚུགས།';
$string['graded'] = 'སྐུགས་བྱིན་ཡི།';
$string['guestnosubmit'] = 'མགྱོནམ་ཚུ དགོངམ་མ་ཁྲེལ་ ལས་འགུལ་སྤྲོད་མི་ཆོག། ཁྱོད་ཀྱིས་ལན་མ་བཙུགས་པའི་ཧེན་མར་ ནང་བསྐྱོད་འབད་ཡང་ན་ཐོ་བཀོདའབད་དགོ།';
$string['guestnoupload'] = 'མགྱོནམ་ཚུ་ དགོངམ་མ་ཁྲོས་སྐྱེལ་བཙུགས་འབད་མི་ཆོག།';
$string['helpoffline'] = '<p>མུ་ཌེལ་གྱི་ཕྱི་ཁ་ལས་ ལས་འགུལ་ལག་ལེན་འཐབ་ནི་འདི་ཕན་ཐོག་ཅན་ཅིག་ཨིན། འ་ནི་འདི་ཝེབ་ཚུ་ནང་ཡང་ན་ གདོང་སྐོར་ལས་འཐོབ་ཚུགས། </p> <p> སློབ་ཕྲུག་ཚུ་གིས་ ལས་འགུལ་གྱི་འགྲེལ་བཤད་མཐོང་ཚུགས། དེ་འབདཝ་ད་ ཡིག་སྣོད་སྐྱེལ་བཙུགས་དེ་ཚུ་ག་ནི་ཡང་འབད་མི་ཚུགས། རང་བཞིན་གྱི་སྐུགས་ཐོབ་ཐངས་དང་འཁྲིལ་ སློབ་ཕྲུག་ཚུ་གིས་ སྐུགས་འཐོབ་ཡོད་པའི་བརྡ་བསྐུལ་ཐོབ། </p>';
$string['helponline'] = '<p>ལག་ལེན་པ་ལུ་ ལས་འགུལ་འདི་གིས་ ཨ་རྟག་གི་ཞུན་དག་ལག་ཆས་ལག་ལེན་འཐབ་སྟེ ཚིག་ཡིག་ཞུན་དག་འབད་བཅུག་ནི། སློབ་དཔོན་ཚུ་གིས་ གློག་ལམ་ཐོག་ལུ་སྐུགས་བྱིན་ནི་དང་ མཐའ་ན་ནང་གི་གྱལ་རིམ་ནང་ ལྟ་སྟེ་བསམ་བཀོད་དང་ འགྱུར་བཅོས་འབད་ཚུགས།</p> <p>(གལ་སྲིད་ཁྱོད་ཀྱི་མུ་ཌེལ་ཐོན་རིམ་རྙིངམ་དང་གཅིག་ཁར་གོམས་འདྲིས་ཡོད་པ་ཅན་ ལས་འགུལ་དེ་ཡང་ མུ་ཌེལ་ གྱི་གསར་དེབ་འབད་དོ་བཟུམ་ལྕོགས་རང་འཐད།)</p>';
$string['helpupload'] = '<p>དེ་བཟུམ་གྱི་ལས་འགུལ་ གྱིས་བཅའ་མར་གཏོགས་མི་རེ་རེ་གིས་ རྩ་སྒྲིག་འབད་ཡོད་པའི་ཡིག་སྣོད་ མང་ཉུང་ག་དེ་འབད་ཨིན་རུང་སྐྱེལ་བཙུགས་འབད་ཆོག། དེ་གི་ཡང་མིང་ཚིག་གི་ལས་འབྱོར་འཕྲུལ་ཆས་ཀྱི་ཡིག་ཆ་ པར་དང་ཛིབ་ཝེབ་ ཚུ་ག་ཅི་ཨིན་རུང་ ཞུ་འབུལ་དོན་ལུ་ དྲི་དགོ། </p> <p>ཡིག་སྣོད་ཀྱི་ལན་སྣ་མང་གི་ཐོག་ལས་ སྐྱེལ་བཙུགས་ཡང་འབད་ཆོག། ལན་གྱི་ཡིག་སྣོད་ཡང་མ་སྤྲོད་པའི་ཧེན་མར་སྐྱེལ་བཙུགས་འབད་ཆོག།</p> <p> དེ་གི་བཅའ་མར་གཏོགས་མི་སོ་སོ་གིས་ཡིག་སྣོད་དང་འཁྲིལ་ ལཱ་འབད་ཚུགས། བཅའ་མར་གཏོགས་མི་འབད་རུང་རང་ སྤྲོད་ནིའི་ཡིག་སྣོད་ནང་ དྲན་འཛིན་གྱི་བཤད་པ་དང་ བརྡ་དོན་ཚིག་ག་ཅི་འབད་རུང་ གནས་ཚད་ཡར་འཕེལ་དང་འཁྲིལ་བཙུགས་དགོ། </p> <p>སྤྲོད་དགོ་པའི་ལས་འགུལ་དེ་ཚུ་ ལག་ཐོག་ལས་གཏན་འཁེལ་བཟོ་དགོ། ནམ་འབད་རུང་ཁྱོད་ཀྱིས་སྐབས་ཀྱི་གནས་ཚད་ཚུ་བསྐྱར་ཞིབ་འབད་དགོ། </p> <p>ལས་འགུལ་མ་ཚར་མི་ཚུ་ཟིན་བྲིས་བཟུམ་ཅིག་བཞག་ནི་ཨིན། སྐུགས་མ་བྱིན་པའི་ལས་འགུལ་ཚུ་རྒྱབ་ལོག་ལྟ་སྟེ་ ཟིན་བྲིས་ཀྱི་གནས་ཚད་ནང་བཀོད་ཚུགས།</p>';
$string['helpuploadsingle'] = '<p>ལས་འགུལ་འདི་གིས་ ལག་ལེན་པ་རེ་རེ་གིས་ཡིག་སྣོད་རྐྱང་པ་ག་ཅི་བཟུམ་ཨིན་རུང་ སྐྱེལ་བཙུགས་འབད་ཆོག།</p> <p>དེ་ཡང་ མིང་ཚིག་གི་ལས་འབྱོར་འཕྲུལ་ཆས་ཀྱི་ཡིག་ཆ་ པར་དང་ཛིབ་ཝེབ་ས་ཁོངས་ཚུ་ག་ཅི་རང་ཨིན་རུང་སྤྲོད་དགོ།</p>';
$string['hideintro'] = 'མཐོང་ཚུགས་པའི་སྤྱི་ཚེས་མ་བཏོན་པའི་ཧེན་མར་ འགྲེལ་བཤད་སྦ་བཞག།';
$string['invalidassignment'] = 'ལས་འགུལ་མ་བཏུབ།';
$string['invalidfileandsubmissionid'] = 'ཡིག་སྣོད་ ཡང་ན་ ཞུ་འབུལ་གྱི་ངོ་རྟགས་བྱང་ཡོདཔ།';
$string['invalidid'] = 'ལས་འགུལ་གྱི་ངོ་རྟགས་མ་བཏུབ།';
$string['invalidsubmissionid'] = 'ཞུ་འབུལ་གྱི་ངོ་རྟགས་མ་བཏུབ།';
$string['invalidtype'] = 'ལས་འགུལ་དབྱེ་བ་མ་བཏུབ།';
$string['invaliduserid'] = 'ལག་ལེན་པའི་ངོ་རྟགས་མ་བཏུབ།';
$string['itemstocount'] = 'གྱངས་ཁ་རྐྱབས།';
$string['lastgrade'] = 'མཐའ་མཇུག་གི་སྐུགས།';
$string['late'] = '{$a} ཕྱིས་ནུག།';
$string['maximumgrade'] = 'སྐུགས་མཐོ་ཤོས།';
$string['maximumsize'] = 'ཚད་མཐོ་ཤོས།';
$string['maxpublishstate'] = 'ཝེབ་དྲན་དེབ་ནང་ལུ་ཞག་དུས་མ་རེན་པའི་ཧེ་མ་ལས་་མཐོང་ཚུགས་པའི་མང་མཐའ།';
$string['messageprovider:assignment_updates'] = 'ལས་འགུལ་(2.2)གི་དྲན་བརྡ།';
$string['modulename'] = 'ལས་འགུལ།(2.2)';
$string['modulenameplural'] = 'ལས་འགུལ་ཚུ།(2.2)';
$string['newsubmissions'] = 'ལས་འགུལ་ཚུ་སྤྲོད་ཚར་ཡོད།';
$string['noassignments'] = 'ད་ཚུན་ལས་འགུལ་གཅིག་ཡང་མེད།';
$string['noattempts'] = 'ལས་འགུལ་འབྲི་ནི་ལུ་དཔའ་མ་བཅམ་པས།';
$string['noblogs'] = 'ཁྱོད་ལུ་ཝེབ་དྲན་དེབ་ནང་ལུ་བཙུགས་ནི་མིན་འདུག';
$string['nofiles'] = 'ཡིག་སྣོད་ཚུ་མ་སྤྲོད་པས།';
$string['nofilesyet'] = 'ད་ཚུན་ཡིག་སྣོད་ཚུ་མ་སྤྲོད་པས།';
$string['nomoresubmissions'] = 'ད་ལས་ཚུར་ ཞུ་འབུལ་ཚུ་མི་ཆོག།';
$string['norequiregrading'] = 'སྐུགས་འབྱི་དགོ་པའི་ལས་འགུལ་མིན་འདུག';
$string['nosubmisson'] = 'ལས་འགུལ་ཞུ་འབུལ་མ་འབད་བས།';
$string['notavailableyet'] = 'དགོངམ་མ་ཁྲེལ་ ད་ལྟོ་<br/>ལས་འགུལ་འདི་འཐོབ་ཚུགཔ་མིན་འདུག། ལས་འགུལ་གྱི་བཀོད་རྒྱ་ཚུ་ འོག་གི་སྤྱི་ཚེས་ལུ་མཐོང་ཚུགས།';
$string['notes'] = 'དྲན་འཛིན།';
$string['notesempty'] = 'འཛུལ་མི་ཆོག།';
$string['notesupdateerror'] = 'དྲན་འཛིན་སྐྱེལ་བཙུགས་འབདཝ་ད་འཛོལ་བ་འདུག།';
$string['notgradedyet'] = 'ད་ཚུན་སྐུགས་མ་བྱིན་པས།';
$string['notsubmittedyet'] = 'ད་ཚུན་མ་སྤྲོད་པས།';
$string['onceassignmentsent'] = 'ཚར་གཅིག་ལས་འགུལ་སྐུགས་ཀྱི་དོན་ལུ་གཏང་ཚར་ཞིནམ་ལས་ ཡིག་སྣོད་མཉམ་སྦྲག་གཏང་ནི་དང་ མེདཔ་བཏང་ནི་ཚུ་འབད་མི་ཚུགས། ཁྱོད་འཕྲོ་འཐུད་འབད་ནི་ཨིན་ན?';
$string['operation'] = 'བཀོལ་སྤྱོད།';
$string['optionalsettings'] = 'ལག་ལེན་པའི་གཞི་སྒྲིག';
$string['overwritewarning'] = 'ཉེན་བརྡ་ ལོག་སྐྱེལ་བཙུགས་འབད་མི་དེ་གིས་ ད་ལྟོ་ཞུ་འབུལ་འབད་ཡོད་མི་འདི་བརྗེ་སོར་འབད་འོང་།';
$string['page-mod-assignment-submissions'] = 'ལས་འགུལ་མུ་ཌེལ་ཞུ་འབུལ་གྱི་ཤོག་ལེབ།';
$string['page-mod-assignment-view'] = 'མུ་ཌེལ་ལས་འགུལ་གྱི་ཤོག་གུ་གཙོ་བོ།';
$string['page-mod-assignment-x'] = 'མུ་ཌེལ་གང་རུང་གི་ཤོག་ལེབ།';
$string['pagesize'] = 'ཞུ་འབུལ་ཚུ་ཤོག་ལེབ་རེ་སྦེ་བཏོན་ནི།';
$string['pluginadministration'] = 'ལས་འགུལ་བདག་སྐྱོང་།';
$string['pluginname'] = 'ལས་འགུལ་(2.2)';
$string['popupinnewwindow'] = 'གསལ་གཞི་ནང་ལུ་སྒོ་འཕྱེ།';
$string['preventlate'] = 'ཞུ་འབུལ་ཕྱིས་མི་ཚུ་ བཀག།';
$string['quickgrade'] = 'སྐུགས་མགྱོགས་པར་བྱིན་ཆོག།';
$string['requiregrading'] = 'སྐུགས་འབྱིན་དགོ་པས།';
$string['responsefiles'] = 'ལན་གྱི་ཡིག་སྣོད་ཚུ།';
$string['reviewed'] = 'བསྐྱར་ཞིབ་འབད་ཡོདཔ།';
$string['saveallfeedback'] = 'ངེའི་བསམ་ལན་གེ་ར་སྲུངས་།';
$string['selectblog'] = 'ཁྱོད་ཝེབ་དྲན་དེབ་ག་འདི་ནང་ཞུ་འབུལ་འབད་ནི་ཨིན་ན་གདམ་ཁ་རྐྱབས།';
$string['sendformarking'] = 'སྐུགས་ཀྱི་དོན་ལུ་གཏང་།';
$string['showrecentsubmissions'] = 'འཕྲལ་སྐབས་ཞུ་འབུལ་ཚུ་སྟོན།';
$string['submission'] = 'ཞུ་འབུལ།';
$string['submissiondraft'] = 'ཞུ་འབུལ་ཟིན་བྲིས་།';
$string['submissionfeedback'] = 'ཞུ་འབུལ་བསམ་ལན།';
$string['submissions'] = 'ཞུ་འབུལ།';
$string['submissionsaved'] = 'ཁྱོད་ཀྱིས་བསྒྱུར་བཅོས་འབད་ཡོད་མི་ཚུ་སྲུང་ནུག།';
$string['submissionsnotgraded'] = '{$a}ཞུ་འབུལ་་སྐུགས་མ་བྱིནམ།';
$string['submitassignment'] = 'ཁྱོད་ཀྱིས་ལས་འགུལ་འདི་བཀང་ཤོག་ལག་ལེན་འཐབ་ཐོག་ལས་སྤྲོད།';
$string['submitedformarking'] = 'ལས་འགུལ་འདི་སྐུགས་ཀྱི་དོན་ལུ་སྤྲོད་ཡོདཔ་ལས་ འདི་དུས་མཐུན་བཟོ་མི་ཚུགས།';
$string['submitformarking'] = 'ལས་འགུལ་འདི་སྐུགས་ཀྱི་དོན་ལུ་མཐའ་འཇུག་སྤྲོད་ནི།';
$string['submitted'] = 'སྤྲོད་ཡོདཔ།';
$string['submittedfiles'] = 'ཡིག་སྣོད་ཚུ་སྤྲོད་ཡོདཔ།';
$string['subplugintype_assignment'] = 'ལས་འགུལ་གྱི་དབྱེ་བ།';
$string['subplugintype_assignment_plural'] = 'ལས་འགུལ་གྱི་དབྱེ་བ་ཚུ།';
$string['trackdrafts'] = 'སྐུགས་ཀྱི་དོན་ལུ་གཏང་ནི་འདི་ལྕོགས་ཅན་བཟོ།';
$string['typeblog'] = 'ཝེབ་དྲན་དེབ་ནང་ལུ་བཙུགས།';
$string['typeoffline'] = 'གློག་ཐོག་མེད་པའི་ལཱ།';
$string['typeonline'] = 'གློག་ཐོག་ཚིག་ཡིག།';
$string['typeupload'] = 'ཡིག་སྣོད་སྐྱེལ་བཙུགས་རྒྱས་པ།';
$string['typeuploadsingle'] = 'ཡིག་སྣོད་རྐྱང་པ་སྐྱེལ་བཙུགས་འབད།';
$string['unfinalize'] = 'ཟིན་བྲིས་ལུ་རྒྱབ་ལོག་བཏང།';
$string['unfinalizeerror'] = 'འཛོལ་བ་བྱུང་ཡོདཔ་ལས་ ཞུ་འབུལ་འདི་ཟིན་བྲིས་ལུ་རྒྱབ་ལོག་བཏང་མ་ཚུགས།';
$string['unsupportedsubplugin'] = '\'{$a}\' གི་ལས་འགུལ་དབྱེ་བ་དེ་ངེས་ལེན་མིན་འདུག་ ཨ་ནི་ལས་འགུལ་དབྱེ་བ་དེ་ཐོབ་ཚུགས་མ་བཟོ་ཚུན་ ཡང་ན་བཏོན་མ་གཏང་ཚུན་འགུགས་དགོ་པས།';
$string['upgradenotification'] = 'སྦྱོང་ལཱ་འདི་མུ་ཌེལ་རྙིང་པའི་ལས་འགུལ་ལུ་གཞི་བཞག་འདུག';
$string['uploadafile'] = 'ཡིག་སྣོད་གཅིག་སྐྱེལ་བཙུགས་འབད།';
$string['uploadbadname'] = 'ཡིག་སྣོད་མིང་ནང་མ་བཏུབ་པའི་ཡིག་འབྲུ་ཚུ་ཡོདཔ་ལས་ སྐྱེལ་བཙུགས་འབད་མ་ཚུགས།';
$string['uploadedfiles'] = 'སྐྱེལ་བཙུགས་འབད་ཡོད་པའི་ ཡིག་སྣོད་ཚུ།';
$string['uploaderror'] = 'ཡིག་སྣོད་འདི་སར་བར་ནང་སྲུངམ་ད་འཛོལ་བ་བྱུང་འདུག';
$string['uploadfailnoupdate'] = 'ཡིག་སྣོད་སྐྱེལ་བཙུགས་འབད་མི་འདི་བཏུབ་པས་ དེ་འབདཝ་ད་ཁྱོད་ཀྱིས་ཞུ་འབུལ་དེ་དུས་མཐུན་བཟོ་མ་ཚུགས།';
$string['uploadfiles'] = 'ཡིག་སྣོད་ཚུ་སྐྱེལ་བཙུགས་འབད།';
$string['uploadfiletoobig'] = 'དགོངམ་མ་ཁྲེལ་ དེ་འབདཝ་ད་ཡིག་སྣོད་དེ་ཚད་ལས་སྦོམ་ནུག་(ཚད་འདི་ {$a} བཱའིཊིསི་ཨིན།)';
$string['uploadnofilefound'] = 'ཡིག་སྣོད་མ་མཐོང་ - ཁྱོད་ཀྱི་སྐྱེལ་བཙུགས་གདམ་ཁ་སྦེ་འབདཝ་འདི་ཐག་ཆོད་ཨིན་ན?';
$string['uploadnotregistered'] = '\'{$a}\'  སྐྱེལ་བཙུགས་འབད་མི་འདི་བཏུབ་པས་ དེ་འབདཝ་ད་ ཞུ་འབུལ་འདི་ཐོ་བཀོད་མ་འབད།';
$string['uploadsuccess'] = '\'{$a}\'མཐར་འཁྱོལ་སྦེ་སྐྱེལ་བཙུགས་འབད་ཡོད།';
$string['usermisconf'] = 'ལག་ལེན་པ་འདི་རིམ་སྒྲིག་མ་འབད།';
$string['usernosubmit'] = 'དགོངསམ་མ་ཁྲེལ་ཁྱོད་ ལས་འགུལ་ ཞུ་འབུལ་འབད་མི་ཆོག་པས།';
$string['viewassignmentupgradetool'] = 'ལས་འགུལ་ཡར་བསྐྱེད་ཀྱི་ལག་ཆས་ལྟ།';
$string['viewfeedback'] = 'ལས་འགུལ་གྱི་སྐུགས་དང་བསམ་ལན་ལྟ།';
$string['viewmysubmission'] = 'ངེ་གི་ཞུ་འབུལ་ལྟ།';
$string['viewsubmissions'] = '{$a}ལས་འགུལ་སྤྲོད་ཡོད་མི་འདི་ལྟ།';
$string['yoursubmission'] = 'ཁྱོད་ཀྱིས་ཞུ་འབུལ།';
