<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'འཛུལ་བསྐྱོད་འབད་ནི་ཁས་མི་ལེན་པས།';
$string['accounts'] = 'འཛུལ་ཐོ་ཚུ།';
$string['addcategory'] = 'དབྱེ་ཁག་ཁ་སྐོང་བཀོད།';
$string['additionalhtml'] = 'HTML ཁ་བསྐོང་།';
$string['additionalhtml_desc'] = 'གཞི་སྒྲིག་འདི་གིས་ཤོག་ལེབ་རེ་རེ་བཞིན་དུ་ལུ་HTMLགསལ་བཀོད་འབད་བཅུག་འོང་།
HEAD ངོ་རྟགས་ནང་ལུ་BODYགི་ངོ་རྟགས་དེ་སྒོ་འཕྱེཝ་ཅིག་དེ་འཕྲོད་ལས་སྒོ་མབསྡམ་ལས་HTMLདེ་HEAD ངོ་རྟགས་ནང་ལུ་བཙུགས་འོང་།.<br /> དེ་གིས་ཤོག་ལེབ་རེ་རེ་བཞིན་དུ་ལུ་ headers or footers ལག་ལེན་འཐབ་བཏུབ་བཟོ་འོང་། ཡང་ན་ Google Analytics གི་ཞབས་ཏོག་ཚུ་རང་དབང་གི་ཐོག་ལས་འཇམ་ཏོང་ཏོ་སྦེ་གཡོག་བཀོལ་ཚུགས།';
$string['additionalhtmlfooter'] = 'BODYའདི་སྒོ་མ་བསྡམ་པའི་ཧེ་མ།';
$string['additionalhtmlfooter_desc'] = 'ནང་ལུ་ཡོད་པའི་དོན་ཚན་ཚུ་ག་ར་ཤོག་ལེབ་རེ་རེ་བཞིན་དུ་ལུ་bodyགི་ངོ་རྟགས་འདི་སྒོ་མ་བསྡམ་པའི་ཧེས་མ་ལས་བཙུགས་འོང་།';
$string['additionalhtmlhead'] = 'HEAD གི་ནང་འཁོད་ལུ།';
$string['additionalhtmlhead_desc'] = 'ནང་ལུ་ཡོད་པའི་དོན་ཚན་ཚུ་ག་ར་འོག་ལུ་ཡོད་པའི་ཤོག་ལེབ་རེ་རེ་བཞིན་དུ་གི་HEAD ངོ་རྟགས་ནང་བཙུགས་འོང་།';
$string['additionalhtml_heading'] = 'ཤོག་ལེབ་རེ་རེ་བཞིན་དུ་ལུ་HTMLཧེང་ཀེ་བཀལ།';
$string['additionalhtmltopofbody'] = 'BODYདེ་སྒོ་འཕྱེ་བའི་སྐབས།';
$string['additionalhtmltopofbody_desc'] = 'body གི་ངོ་རྟགས་འདི་སྒོ་འཕྱེ་བའི་ཤུལ་དེ་འཕྲོ་ལས་ནང་ལུ་ཡོད་པའི་དོན་ཚན་ཚུ་ག་ར་ཤོག་ལེབ་རེ་རེ་བཞིན་དུ་ལུ་བཙུགས་ཏེ་་འོང་།';
$string['admincategory'] = 'དབྱེ་རིམ: {$a}';
$string['adminseesall'] = 'བདག་སྐྱོང་གེ་ར་ལྟ།';
$string['adminseesallevents'] = 'བདག་སྐྱོང་པ་ཚུ་གིས་བྱུང་ལས་གེ་ར་ལྟ།';
$string['adminseesownevents'] = 'བདག་སྐྱོང་པ་ཚུ་གེ་ར་ལག་ལེན་པ་གཞན་མི་བཟུམ།';
$string['advancedfeatures'] = 'གོང་འཕེལ་གྱི་ཆ་ཤས།';
$string['allcountrycodes'] = 'རྒྱལ་ཁབ་ག་ར་གི་གསང་ཨང་།';
$string['allowbeforeblock'] = 'འབད་ཆོག་པའི་ཐོ་ཚུ་བཡ་རིམ་ཧེ་མ་ནང་འབད།';
$string['allowbeforeblockdesc'] = 'རང་བཞིན་གྱིས་རང་ IPs ཐོ་ནང་ལུ་བཙུགས་ནི་བཀག་ཡོད་མི་ཚུ་ཧེ་མ་མཐུན་སྒྲིག་འབད་འོང་། ག་དེམ་ཅིག་སྦེ་གདམ་ཁ་འདི་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ IPs ཐོ་ནང་ལུ་བཙུགས་ཆོག་མི་ཚུ་
བཀག་སྟེ་ཡོད་པའི་ཐོ་ཚུ་གི་ཧེ་བཙུགས་འོང་།';
$string['allowblockstodock'] = 'དོས་སྟེགས་འདི་ལག་ལེན་འཐབ་སྟེ་བཀག་ཆ་འབད།';
$string['allowcategorythemes'] = 'བཀོད་རིས་ཤོག་ལེབ་དབྱེ་རིམ་འབད་ཆོག།';
$string['allowcoursethemes'] = 'སློབ་ཚན་གྱི་བཀོད་རིས་ཤོག་ལེབ་གདམ་ཆོག།';
$string['allowediplist'] = 'IP གི་ཐོ་བྱིན་ཡོད།';
$string['allowemailaddresses'] = 'གློག་འཕྲིན་ཌོ་མེན་ཆོགཔ།';
$string['allowframembedding'] = 'གཞི་ཁྲམ་གནས་འདྲེན་ཆོག';
$string['allowframembedding_help'] = 'བཟོ་ནི་ལུ་རྒྱབ་སྐྱོར་མེད།';
$string['allowguestmymoodle'] = 'ངིའི་གདོང་ཤོག་ལུ་ མགྱོནམོ་ཚུ་འཛུལ་སྤྱོད་འབད་ཆོག།';
$string['allowobjectembed'] = 'ངོ་རྟགས་ཡང་ཆོག།';
$string['allowthemechangeonurl'] = 'URL ནང་ལུ་བཀོད་རིས་ཤོག་ལེབ་སོར་ཆོག།';
$string['allowuserblockhiding'] = 'ལག་ལེན་པ་ཚུ་གིས་སྡེབ་ཚན་སྦ་ཆོག།';
$string['allowuserswitchrolestheycantassign'] = 'འགན་སྤྲོད་མེད་པའི་ལག་ལེན་པ་ཚུ་ལུ་ འགན་ཁྲིད་ཀྱི་རང་དབང་སོར་བསྒྱུར་བྱིན།';
$string['allowuserthemes'] = 'ལག་ལེན་པས་བཀོད་རིས་ཤོག་ལེབ་ཆོག།';
$string['antivirus'] = 'གནོད་ཆས་ཁ་གནོན།';
$string['appearance'] = 'འབྱུང་སྣང་།';
$string['aspellpath'] = 'ཨེས་པེལ་རྒྱུ་ལམ།';
$string['authentication'] = 'བདེན་བཤད།';
$string['authpreventaccountcreation'] = 'བདེན་བཤད་འབད་བའི་བསྒང་ རྩིས་ཐོ་བཟོ་ནི་བཀག་དགོ།';
$string['authpreventaccountcreation_help'] = 'ལག་ལེན་པ་ག་འབད་རུང་ཅིག་གིས་ བདེན་ཁུངས་ཟང་པ་ཅིན་ གནས་ཁོངས་ནང་མེད་རུང་ རྩིས་ཐོ་ཅིག་བཟོ་སྡོད་འོང།
བདེན་ཁུངས་ཟང་ནི་གི་དོན་ལུ་ ཕྱིའི་གནས་སྡུད་གཞི་མཛོད LDAP སོགས་ལག་ལེན་འཐབ་ དེ་ལས་ ལག་ལེན་པ་ཚུ་ལུ་ ད་ལྟོ་ཡོད་པའི་རྩིས་ཐོ་ནང་ལས་ ལག་ལེན་གོ་སྐབས་འདི་བཀག་འཛིན་འབད་དགོ་པའི་རེ་འདོད་ཡོད་པ་ཅིན་ ཨ་ནི་གདམ་ཁ་དེ་ ལྕོགས་ཅན་བཟོ་དགོ། དེའི་སྐབས་ རྩིས་ཐོ་གསརཔ་རང་ཤུགས་ཐོག་བཟོ་དགོ་ དེ་མེན་ ཡར་དྲེན་བཙུགས་ལག་ལེན་པའི་ཁྱད་གནད་ ཐོག་འབད་དགོ། དེ་འབདཝ་ད་ ཨ་ནི་ཁྱད་ཆོས་དེ་གིས་ MNet བདེན་ཁུངས་ཟང་་ལུ་ངེས་ལེན་མེདཔ་ཤེས་དགོ།';
$string['authsettings'] = 'བདེན་བཤད་འཛིན་སྐྱོང་།';
$string['autolang'] = 'སྐད་ཡིག་རང་བཞིན་སྐྱོན་འཛིན།';
$string['autologinguests'] = 'རང་བཞིན་ནང་བསྐྱོད་ཀྱི་མགྱོནམ།';
$string['availablelicenses'] = 'ཡོད་པའི་ཆོག་ཐམ།';
$string['availableto'] = 'ཡོད་པ།';
$string['backgroundcolour'] = 'ཚོས་གཞི་དྭངས་གསལ་ཅན།';
$string['backups'] = 'རྒྱབ་སྐྱོར།';
$string['backup_shortname'] = 'རྒྱབ་སྐྱོར་གྱི་ཡིག་སྣོད་མིང་ནང་ལུ་སློབ་ཚན་གྱི་མིང་ལག་ལེན་འཐབ།';
$string['backup_shortnamehelp'] = 'རྒྱབ་སྐྱོར་གྱི་ཡིག་སྣོད་མིང་གི་ཆ་ཤས་ནང་ལུ་སློབ་ཚན་གྱི་མིང་ལག་ལེན་འཐབ།';
$string['badwordsconfig'] = 'ཚིག་ངན་ཚུ་ བར་ཚག་གི་སོ་སོར་ཐོ་བཀོད།';
$string['badwordsdefault'] = 'གལ་སྲིད་སྲོལ་སྒྲིག་ཐོ་ཡིག་སྟོང་པ་འབདན་ སྐད་ཡིག་གི་སྦུང་ཚན་ལས་སྔོན་སྒྲིག་ཐོ་ཡིག་ལག་ལེན་འཐབ་ནི།';
$string['badwordslist'] = 'སྲོལ་སྒྲིག་ངན་པའི་ཚིག་ཐོ།';
$string['blockediplist'] = 'བཀག་ཆ་འབད་དེ་ཡོད་པའི IP གི་ཐོ།';
$string['blockeditingmenu'] = 'ཞུན་དག་དཀར་ཆ་ཚུ་བཀག་ཆ་འབད།';
$string['blockeditingmenu_desc'] = 'ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ མར་འབབ་གློག་རིམ་དཀར་ཆག་ནང་ཡོད་པའི་ བཀག་འཛིན་འབད་བའི་པར་རྟགས་མང་ཤོས་ཅིག་
ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ ཞུན་དག་འབད་བའི་སྐབས་ བཀག་འཛིན་འབད་བའི་པར་རྟགས་མང་ཤོས་ཅིག་ མར་འབབ་གློག་རིམ་དཀར་ཆག་ནང་དངོས་སྟོན་འབད་འོང་། འདི་གིས་ གདོང་ཤེལ་ནང་ཡོད་པའི་ གནད་དོན་མང་ཤོས་ཅིག་ དགོཔ་མ་འཐོན་ཚུན་གཡིབ་སྟེ་ ཉུང་སུ་བཟོཝ་ཨིན།';
$string['blockinstances'] = 'དཔེར་ན།';
$string['blockmultiple'] = 'སྣ་མང་།';
$string['blockprotect'] = 'ཉེན་སྐྱོབ་ཀྱི་དུས་སྐབས།';
$string['blockprotect_help'] = 'ག་དེམ་ཅིག་སྦེ་ཁྱོད་ཀྱིས་ བཀག་འཛིན་དབྱེ་རིམ་ཅིག་ ལྡེ་མིག་རྐྱབ་ད་པ་ཅིན་ ག་གིས་ཡང་ གནད་དོན་ཚུ་ ཁ་སྐོང་བཀོད་ནི་དང་ ཕྱིར་བཏོན་ནི་ཚུ་ འབད་མི་ཚུགས། (ཨིན་རུང་ ཁྱོད་ར་ཞུན་དག་ འབད་འདོད་ཡོད་པ་ཅིན་ ལྡེ་ཡིག་དེ་ཕྱེ་བཏུབ།) ཨ་ནི་གི་དམིགས་དོན་ངོ་མ་རང་ ལོག་ཐོབ་དཀའ་བའི་ཡིག་ཆ་ཚུ་ སྟེས་དབང་གིས་ ཕྱིར་བཏོན་གཏང་མི་ ལཱ་གྲུལ་དང་གནས་ཁོངས་ཚུ་ བསྲུང་ནིའི་དོན་ལུ་ཨིན།';
$string['blocksettings'] = 'སྡེབ་ཚན་འཛིན་སྐྱོང་།';
$string['blockunprotect'] = 'ཉེན་སྲུང་མེདཔ།';
$string['bloglevel'] = 'ཝེབ་དྲན་དེབ་མཐོང་གསལ།';
$string['bookmarkadded'] = 'སྡེབ་རྟགས་སྡོམ་ནི།';
$string['bookmarkalreadyexists'] = 'སྔོན་ལས་བཀལ་ཡོད་པའི་ཁྱོད་ཀྱི་སྡེབ་རྟགས་ཀྱི་ཤོག་ལེབ་འདི།';
$string['bookmarkdeleted'] = 'སྡེབ་རྟགས་བཏོན་ཚར་ཡོདཔ།';
$string['bookmarkthispage'] = 'སྡེབ་རྟགས་ཀྱི་ཤོག་ལེབ་འདི།';
$string['cacheapplication'] = 'གློག་རིམ་འདྲ་མཛོད།';
$string['cacheapplicationhelp'] = 'གློག་རིམ་འདྲ་མཛོད་ཀྱི་དངོས་པོ་ཚུ་ལག་ལེན་པ་ག་ར་ལུ་བགོ་བཤའ་བརྐྱབ་སྟེ་ དུས་ཡོལ་གཏན་འབེབས་བཟོཝ་ཨིན།';
$string['cachejs'] = 'འདྲ་མཛོད་ Javascript';
$string['cachejs_help'] = 'Javascript caching and compression ཟེར་མི་གིས་ ཤོག་ཁྲམ་ཡར་འདྲེན་གྱི་སྤུད་ཚད་ཡར་དྲགས་གཏངམ་ཨིནམ་ལས་ གནས་ཁོངས་བཟོ་སྐྲུན་པ་ཚུ་ལུ་ འདི་ལག་ལེན་དེ་རྒྱབ་སྣོན་འབདཝ་ཨིན། ཨིན་རུང་ བཟོ་སྐྲུན་པ་ཚུ་གིས་ཁྱད་གནད་འདི་ ལྕོགས་མིན་བཟོ་ནི་དང་བཟོ་འདོད་ཡང་འོང་།';
$string['cacherequest'] = 'འདྲ་མཛོད་ཞུ་བ།';
$string['cacherequesthelp'] = 'དམིགས་བསལ་གྱི་འདྲ་མཛོད་ལག་ལེན་གྱི་ཞུ་བ་འདིདུས་ཡོལ་འགྱོཝ་ད། ང་བཅས་ཀྱིས་རྟག་བརྟན་གྱི་མཛོད་ཁང་འདི་ལག་ལེན་འཐབ་སྟེ་ས་སྒོ་དེ་ཚབ་བཙུགས།';
$string['cachesession'] = 'སེ་ཤེན་འདྲ་མཛོད།';
$string['cachesessionhelp'] = 'དམིགས་བསལ་གྱི་འདྲ་མཛོད་སེ་ཤེན་རྫོགསཔ་ད་དུས་ཡོལ་འགྱོ་མི་དེ། སེ་ཤེན་རྩ་མེད་གཏང་ནིའི་དོན་ལུ་ཨིན།';
$string['cachesettings'] = 'འདྲ་མཛོད་གཞི་སྒྲིག';
$string['cachetext'] = 'ཚེ་གང་གི་འདྲ་མཛོད་ཚིག་ཡིག།';
$string['caching'] = 'འདྲ་མཛོད།';
$string['calendarexportsalt'] = 'ཟླ་ཐོ་ཕྱིར་འདྲེན་གྱི་སཱལཊ།';
$string['calendarsettings'] = 'ཟླ་ཐོ།';
$string['calendartype'] = 'ཟླ་ཐོ་དབྱེ་རྣམ';
$string['calendartype_desc'] = 'འཆར་སྒོ་ག་ར་གི་དོན་ལུ་ ཟླ་ཐོ་སྔ་སྒྲིག་དབྱེ་ཁ་དེ་ གདམ་ཁ་འབད། སློབ་མཚན་གཞི་སྒྲིག་ནང་གི་ ཨ་ནི་གཞི་སྒྲིག་དེ་ ལག་ལེན་པ་སོ་སོ་གིས་ རང་སོའི་ཐོ་དེབ་ནང་སྒྱུར་བཅོྱ་འབད་ཚུགས།';
$string['calendar_weekend'] = 'བདུན་མཐའ་ཉིནམ་ཚུ།';
$string['cannotdeletemodfilter'] = 'ཁྱོད་ཀྱིས་ \'{$a->filter}\' འདི་བཏོན་གཏང་མི་ཚུགས་ ག་ཅི་སྦོ་ཟེར་བ་ཅིན་ \'{$a->module}\'འདི་མོ་ཌེལ་གྱི་ཆ་ཤས་ཨིན།';
$string['cannotuninstall'] = '{$a} འདི་བཏོན་གཏང་མི་ཚུགས།';
$string['cfgwwwrootslashwarning'] = 'ཁྱོད་ཀྱི་ཡིག་སྣོད་ ཀཱོན་ཕིག་ཌོད་པི་ཨེཆ་པིནང་མ་འཛོལ་བ་མེདཔ་ངོས་འཛིན་འབད་ནུག་དེ་གི་བཀུག་ནི་དང་གཅིག་ཁར་རྟགས་མི་མཐུན་པས་ཁྱོད་ཤོག་ལེབ་འདི་འཛུལ་བསྐྱོད་ལག་ལེན་འཐབསྟེ་ཡོད། ཁྱོད་ཀྱི་བཅོ་ཁ་གནང་ད་དེ་མིན་རུང་ཁྱོད་ཀྱི་ཉམས་མྱོང་ཧ་ལས་སི་སི་གསང་ཉན་འཕྲུལ་ཆས་བཟུམ།';
$string['cfgwwwrootwarning'] = 'ཁྱོད་ཀྱི་ཡིག་སྣོད་ ཀཱོན་ཕིག་ཌོད་ ནང་མ་བདེནམ་སྦེ་ངོས་འཛིན་འབད་ནུག་ ཁྱོད་ཀྱི་མཇུག་བསྡུཝ་ད་ ཡིག་འབྲུ་ ཨེ་དེ་གི་གྲངས་སུ་བཙུགས་ནི། ཁྱོད་ཀྱིས་རྩ་བསྐྲད་གཏང་ད་ དེ་མིན་རུང་ཁྱོད་ཀྱི་ཉམས་མྱོང་ཧ་ལས་སི་སི་གསང་ཉན་འཕྲུལ་ཆས་བཟུམ།';
$string['change'] = 'བསྒྱུར་བཅོས།';
$string['checkboxno'] = 'མེན།';
$string['checkboxyes'] = 'ཨིན།';
$string['choosefiletoedit'] = 'ཡིག་སྣོད་གདམ་སྟེ་ཞུན་དག་འབད།';
$string['clamfailureonupload'] = 'ཀཱ་ལམ་ཨེ་ཝི་ལུ་འཐུས་ཤོར་བྱུང་ཡོདཔ།';
$string['cleanup'] = 'གཙང་དག་བཟོ་ནི།';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'ནོར་བ། "{$a->option}"དོན་ལུ་ འཛོལ་འཛོལ་བའི་གནས་ཚད "{$a->value}"';
$string['cliincorrectvalueretry'] = 'འཛོལ་འཛོལ་བའི་གནད་ཚད་ནང་འདུག སླར་རྩོལ།';
$string['clistatusdisabled'] = 'གནས་ཚད: ལྕོག་མེད་བཟོ་ཡོད།';
$string['clistatusenabled'] = 'གནས་ཚད: ལྕོག་ཅན་བཟོ་ཡོད།';
$string['clistatusenabledlater'] = 'གནས་རིམ: CLI སྲུང་སྐྱོང་དཔེ་ཚུལ་དེ{$a}་ནང་འབད་དུ་རུང་བའི་གནས་ཚད་ལུ་སྡོད་འོང་།';
$string['clitypevalue'] = 'གནས་ཚད་དབྱེ་བ།';
$string['clitypevaluedefault'] = 'གནས་ཚད་དབྱེ་བ། Enter ཨེབ་སྟེ་སྔོན་སྒྲིག་གི་ཨང་({$a})';
$string['cliunknowoption'] = 'ངོས་འཛིན་འབད་མ་ཚུགས་པའི་གདམ་ཁ་འདུག: {$a} གྲོགས་རམ་གྱི་གདམ་ཁ་འདི་ལག་ལེན་འཐབ་ད།';
$string['cliupgradefinished'] = 'བཀོད་ལམ་གནས་ཚད་ལེགས་ཤོམ་འབད་ཡར་དྲག་བཟོ་ཚར་ནུག';
$string['cliupgradenoneed'] = 'བཙུགས་ཏེ་ཡོད་པའི་འཐོན་རིམ་ནང་ལུ་ཡར་དྲག་བཟོ་དགོཔ་མིན་འདུག {$a}. ག་ཅི་ཨིན་རུང་འོང་མི་ལུ་བཀྲིན་ཆེ།';
$string['cliyesnoprompt'] = 'y ཟེར་འབྲི་བ་ཅིན་ཨིནཟེརཝ་དང་ n ཟེར་འབྲི་བ་ཅིན་མིན་)';
$string['commentsperpage'] = 'ཤོག་ལེབ་རེ་རེ་བཞིན་གྱི་བསམ་བཀོད་གསལ་བཏོན།';
$string['commonfiltersettings'] = 'སྤྱིར་བཏང་གཞི་སྒྲིག་བཙག་ཐངས།';
$string['commonsettings'] = 'ཐུན་མོང་གཞི་སྒྲིག།';
$string['componentinstalled'] = 'ཆ་ཤས་གཞི་བཙུག་འབད་ཡོདཔ།';
$string['computedfromlogs'] = 'དྲན་དེབ་{$a} ལས་ཚུར་གློག་རིག་གྲུབ།';
$string['condifmodeditdefaults'] = 'ཁྱོད་ཀྱིས་ནཱ་ལུ་གནས་ཚད་གཞི་སྒྲིག་འབད་དེ་ཡོད་པའི་སྔོན་སྒྲིག་འདི་ཚུ་སྦྱོང་ལཱ་གསརཔ་བཟོ་བའི་སྐབས་གི་ནང་ལག་ལེན་འཐབ་པའི་གཞི་སྒྲིག་ཨིན། ཁྱོད་ཀྱིས་གཞི་སྒྲིག་གཞན་ཡང་ སྦྱོང་ལཱ་ག་འདི་ཚུ་དྲག་ཤོ་ཨིན་ན་རིམ་སྒྲིག་འབད་ཚུགས།';
$string['confeditorhidebuttons'] = 'གསང་བའི་ཨེཆ་ཀྲི་ཨེམ་ཨེལ་ ཞིབ་འཚོལ་པ་ལས་ཨེབ་རྟ་གདམ་ཁ་རྐྱབ་དགོ།';
$string['configallcountrycodes'] = 'ཨ་ནི་འདི་རྒྱལ་ཁབ་ཚུ་གི་ཐོ་ས་གནས་སོ་སོ་ལས་གདམ་འཐུ་འབད་ཡོད་མི་ཚུ་ཨིན། དཔེ་འབད་བ་ཅིན། ལག་ལེན་པའི་གསལ་སྡུད་ནང་ལུ། ག་དེ་ཅིག་སྦེ་ས་སྟོང་ཨིན་པ་ཅིན་(སྔོན་སྒྲིག)རྒྱལ་ཁབ་ཚུ་གི་ཐོ། php ཟེར་ཨིང་ལིཤ་སྐད་ཡིག་ཚད་ལྡན་འདི་ལག་ལེན་འཐབ་ཨིན། ཨ་ཕི་དེ་ཐོ་ISO 3166-1. དེ་ཨིན། དེ་མིན་པ་ཅིན།ཁྱོད་ཀྱིས་ལྷོད་རྟགས་བཙུགས་ཏེ་ཨང་རྟགས་ཚུ་གསལ་བཀོད་འབད་ཚུགས། དཔེར་ན། \'GB,FR,ES\'. ག་དེ་ཅིག་འབད་ ཁྱོད་ཀྱིས་ ཨང་རྟགས་ཚད་ལྡན་མེདཔ་བཙུགས་པ་ཅིན་ ཁྱོད་ཀྱིས་འདི་ཚུ་རྒྱལ་ཁབ་ཚུ་ལུ་.php in \'en\' དང་ཁྱོད་ཀྱི་སྐད་ཡིག་སྡེ་ཚན་ནང་བཙུགས་དགོ།';
$string['configallowassign'] = 'ཁྱོད་ཀྱིས་ལས་འགན་ཡོད་པའི་ མི་ཚུ་གི་གཡོན་ཁ་ཐུག་འགན་སྤྲོད་འཛིན་པའི་ཀེར་ཐིག་དག་ཅིག་ལས་རྒྱུད་དེ་གཞན་མི་ལུ་ལས་འགན་སྤྲོད་ཆོག།';
$string['configallowblockstodock'] = 'གལ་སྲིད་ ལྕོགས་ཅན་བཟོ་སྟེ་ གདམ་འཐུ་ཅན་གྱི་བརྗོད་དོན་གྱིས་རྒྱབ་བསྣན་འབད་དེ་ཡོད་པ་ཅིན་ ལག་ལེན་པ་ཚུ་གིས་ སྡེབ་ཚན་དེ་དམིགས་བསལ་གྱི་འདྲ་མཛོད་ནང་ལུ་སྤོ་བཤུས་འབད་ནིའི་གདམ་ཁ་ཡོད།';
$string['configallowcategorythemes'] = 'ཁྱོད་ཀྱིས་འདི་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ བཀོད་རིས་ཤོག་ལེབ་ཆ་ཚན་དང་བཅས་དབྱེ་རིམ་དང་འཁྲིལ་ཏེ་ བཟོ་ཚུགས།དེ་གིས་ཁོང་རའི་དམིགས་བསལ་གྱི་བཀོད་རིས་ཤོག་ལེབ་ཆ་ཚན་ཅིག་ལུ་མ་གཏོགས་ ཨ་ལོ་ཡོངས་ཀྱི་ སློབ་ཚན་དབྱེ་རིམ་ ལུ་ཕན་གནོད་བྱུང་འོང་།ཉེན་བརྡ། ལྕོགས་གྲུབ་ཅན་གྱི་བཀོད་རིས་ཤོག་ལེབ་དབྱེ་རིམ་གྱིས་ལཱ་ལུ་ཡང་ཕན་གནོད་འབྱུང་ནིའི་ཉེན་ཁ་ཡོད།';
$string['configallowcoursethemes'] = 'ཁྱོད་ཀྱིས་འདི་ ལྕོགས་ཅན་བཟོ་བ་ཅིན་ དེ་ལས་སློབ་ཚན་ཚུ་གི་བཀོད་རིས་ཤོག་ལེབ་རང་གི་གཞི་སྒྲིག་འབད་ཆོག། སློབ་ཚན་བཀོད་རིས་ཤོག་ལེབ་ཀྱིས་ བཀོད་རིས་ཤོག་ལེབ་གདམ་ཁ་ (ས་ཁོངས་ ལག་ལེན་པ་ ཡང་ན་ ཐུན་ཚན་གྱིས་བཀོད་རིས་ཤོག་ལེབ་ཚུ།) གེ་ར་མེདཔ་གཏངམ་ཨིན།';
$string['configallowemailaddresses'] = 'ཁྱོད་ཀྱིས་དམིགས་བསལ་ ཌོ་མེན་ལུ་འགྱོ་བཏུབ་པའི་ གློག་འཕྲིན་ཁ་བྱང་གསརཔ་གེ་ར་ བཀག་དམ་འབད་དགོ་པ་ཅིན་ དེ་ལས་ས་སྟོང་སོ་སོ་བཞག་སྟེ་ཐོ་བཀོད། ཌོ་མེན་གཞན་མི་གེ་ར་དང་ལེན་སྤངམ་ཨིན། ཌོ་མེན་འོག་མ་གི་དོན་ལུ་ ཌོ་མེན་སྦོམ་ཤོས་ དེའི་གུར་ ཁ་སྐོང་རྐྱབ་ཆོག།\'.\'. eg <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'ལྕོགས་ཅན་བཟོ་བ་ཅིན་ མགྱོནམ་ཚུ་གིས་ངིའི་གདོང་ཤོག་ལུ་ བལྟ་ནིའི་གོ་སྐབས་ཡོད། དེ་མིན་པ་ཅིན་མགྱོནམ་ཚུ་ལོག་སྟེ་རང་ཤོག་ལེབ་དང་པ་ནང་གཏང་འོང་།';
$string['configallowobjectembed'] = 'སྔོན་སྒྲིག་སྲུང་སྐྱོབ་ཀྱི་དོན་ལས་ རང་བཞིན་ལག་ལེན་པ་ཚུ་ ཨེཆ་ཀྲི་ཨེམ་ཨེལ་ ནང་ཡོད་པའི་ཚིག་ཡིག་གཏན་འཁེལ་ཡོད་པའི་གནས་ཟུག་དང་ དངོས་པོའི་ངོ་རྟགས་ སྣ་མང་བརྡ་ལམ་ གནས་ཟུག་ཚུ་ལག་ལེན་འཐབ་མི་ཆོག། (ཕེལཱཤ་བཟུམ) (མི་ཌེ་ཡ་པལཱཀ་ཨིན་ གིས་ཚགས་མ་བཟུམ་སྦེ་ ལག་ལེན་འཐབ་ད་ཉེན་ཁག་མེདཔ་སྦེ་འབད་ནི)';
$string['configallowoverride'] = 'ཁྱོད་ཀྱིས་ལཱ་དང་ལྡན་པའི་མི་ཚུ་གིས་ གཡོན་ཁ་ཐུག་གི་ཀེར་ཐིག་ལཱ་ཡོད་མི་ཚུ་དབང་ཐག་ཆོད་ཆོག།';
$string['configallowoverride2'] = 'གཡོན་ཁ་ཐུག་དབང་ཐག་ཆོད་ཚར་ཡོད་པའི་ ཀེར་ཐིག་རེ་རེ་ལས་ ལཱ་ག་འདི་གདམ་འཐུ་འབད་ནི། སྒྲིགས་སྟངས་འདི་ མུ་ཌེལ་/རོ་ལོ་ཨོ་ཝར་རའིཊ་ ལྕོགས་གྲུབ་དང་ལྡན་པའི་ལག་ལེན་པ་ཚུ་རྐྱངམ་ཅིག་གི་དོན་ལུ་ ཐོ་བཀོད་འབད།';
$string['configallowswitch'] = 'ལག་ལེན་པ་འདི་ལུ་་ལས་འགན་ག་ཅི་ཡོད་མི་ལུ་གཞི་བཞག་སྟེ་གདམ་འཐུ་འབད་འོང་ག་གི་བརྗེ་སོར་འབད། དེ་གི་ཁ་བསྐོང་ལུ་ཐིག་ཁྲམ་དེ་ནང་འཛུལ་མི་དང་འཁྲིལ་ཏེ་ ལག་ལེན་པ་དེ་ལུ་མོ་ཌེལ/ལས་འགན་དགོ། ལག་ལེན་པ་དེ་གི་ལྕོགས་གྲུབ་དང་འཁྲིལ་ཏེ་ ལས་འགན་སོར།.<br />སེམས་ཁར་བཞག་ མོ་ཌེལ་ཡངན་ སློབ་ཚན་ཡོད་མི་ཚུ་ལུ་རྐྱངམ་ཅིག་གིས་ལས་འགན་སོར་ཆོག མོ་ཌེལ་ས་སྒོ་མེད་མི་ཚུ་ལུ་འཇོན་ཐང་བལྟ་ དེལས་་ག་ཅི་ལུ་ལྕོགས་གྲུབ་འདུག་ག་བལྟ་ དེ་ལས་ཐིག་ཁྲམ་ནང་ལུ་བཅད་ཐིག་དེ་ཚུ་མེདཔ་བཟོ།';
$string['configallowthemechangeonurl'] = 'ལྕོགས་ཅན་བཟོ་བ་ཅིན། བཀོད་རིས་ཤོག་ལེབ་འདི་:<br />?theme=themename to any Moodle URL (eg: mymoodlesite.com/?theme=afterburner ) or <br />&theme=themename to any internal Moodle URL (eg: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).གི་ཐོག་ལས་སོར་ཚུགས།';
$string['configallowuserblockhiding'] = 'ཁྱོད་ལུ་ས་ཁོངས་ཀྱི་སྡེ་རིམ་ རྒྱས་པ་འབད་ སྟོན་ནི་དང་/ སྦ་ཆོགཔ་འབད་དགོ་ནི་ཨིན་ན? དེ་གི་ཁྱད་རྣམ་འདི་ ཇ་བ་ཡིག་ཚུ་ དང་ཀུ་ཀིས་ ཚུ་གིས་སྡེ་རིམ་བལྟབ་བཏུབ་མི་རེ་རེ་གིས་ གནས་ལུགས་དཔྱད་རིག་གཏང་ཚུགས་ནི་དང་ ལག་ལེན་པའི་སྣང་ངོ་ལུ་ཕན་གནོད་བྱུང་འོང་།';
$string['configallowuserswitchrolestheycantassign'] = 'སྔོན་སྒྲིག་གི་འབད་ མུ་ཌེལ་རོ་ལོ་ཨེསའིན་ འདི་གློག་རྟའི་ལཱ་གི་དོན་ལུ་ ལག་ལེན་པ་ཚུ་ལུ་མཁོ་ཆེཝ་འདུག། ལྕོགས་ཅན་གཞི་སྒྲིག་ཀྱིས་ མཁོ་ཆེ་བོ་ཚུ་བཏོན་གཏངམ་ཨིན། དེ་ལས་འཐོབ་ཚུགས་པའི་ལཱ་གི་གྲུབ་འབྲས་ཚུ་ གཞི་སྒྲིག་་ཚུ་གི་འབད་མར་ཉམས་ནི་ལུ་གཏན་འབེབ་འགྱོཝ་ཨིན།';
$string['configallowuserthemes'] = 'ཁྱོད་ཀྱིས་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ ལག་ལེན་པ་ཚུ་གིས་ ཁོང་རའི་བློ་འདོད་དང་འཁྲིལ་ བཀོད་རིས་ཤོག་ལེབ་ ཆ་ཚན་ཅིག་སྒྲིག་ཚུགས། ལག་ལེན་པའི་བཀོད་རིས་ཤོག་ལེབ་ ཀྱིས་ས་ཁོངས་བཀོད་རིས་ཤོག་ལེབ་དབང་ཐག་ཆོད་ཚུགས། (དེ་འབདཝ་ད་ སློབ་ཚན་གྱི་བཀོད་རིས་ཤོག་ལེབ་འདི་མེན།)';
$string['configallusersaresitestudents'] = 'ལཱ་གི་དོན་ལུ་གདོང་ཤོག་གི་ས་ཁོངས་ ལག་ལེན་པ་གེ་ར་སློབ་ཕྲུག་གི་ཨིན་པའི་ཆ་འཇོག་ལུ་ཨིན་ན? ཁྱོད་ཀྱིས་ལན་ ལག་ལེན་པའི་/ཨིན་ཟེར་བ་ཅིན་/ ལག་ལེན་པའི་ཆ་འཇོག་གྲུབ་ཡོད་པའི་རྩིས་ཐོ་ཨིན་ཟེར་བ་ཅིན་ གཞན་མི་སྦྱོང་ལཱ་གི་དོན་ལུ་ སློབ་ཕྲུག་བཟུམ་འབད་ བཅའ་མར་གཏོགས་ཆོག། ཁྱོད་ཀྱིས་ལན་འདི་ /མེན་/ ཟེར་བ་ཅིན་ ལག་ལེན་པ་ཚུ་ཉུང་ཤོས་སློབ་ཚན་གཅིག་ནང་བཅའ་མར་གཏོགས་ཚར་ཚརཝ་དེ་ཚུ་གིས་ གདོང་ཤོག་གི་སྦྱོང་ལཱ་ཚུ་ལག་ལེན་འཐབ་ཆོག། དེ་ལས་བདག་སྐྱོང་དང་འགན་སྤྲོད་ཀྱི་སློབ་དཔོན་ཚུ་གིས་ གདོང་ཤོག་གི་སྦྱོང་ལཱ་ཚུ་ལག་ལེན་འཐབ་ཚུགས།';
$string['configauthenticationplugins'] = 'ཁྱོད་རའི་ལག་ལེན་བདེ་སྒྲིག་གི་ཐོག་ལས་ པ་ལག་ཨིན་ བདེན་བཤད་ འདི་འགོ་རིམ་ ཕེལ་ཐུརུ་ འབད་གདམ་འཐུ་འབད་གནང་།';
$string['configautolang'] = 'གལ་སྲིད་ས་ཁོངས་ལྕོགས་མིན་ཐལ་ཡོད་པའི་ལག་ལེན་འཐབ་པ་ཅིན། ཁ་སྐད་སྔོན་སྒྲིག་སྐྱོན་འཛིན་འདི་སྒྲིགས་སྟངས་བརྡ་འཚོལ་མི་ལས་བྱུངམ་ཨིན།';
$string['configautologinguests'] = 'ལྟ་བཤལ་པ་ཚུ་ནང་བསྐྱོད་འབད་བ་ཅིན་ མགྱོནམབཟུམ་འབད་ རང་བཞིན་གྱིས་སློབ་ཚན་འཛུལ་ཞུགས་འབདཝ་ད་ གཅིག་ཁར་མགྱོནམ་ནང་སྤྱོད་འབདཝ་ཨིན།';
$string['configbloglevel'] = 'གཞི་སྒྲིགས་དེ་གིས་ བཀག་འདམ་འབད་བ་ཅིན་ ལག་ལེན་པའི་སྡེ་རིམ་ག་འདི་ཨིན་ན་ས་ཁོངས་དེ་གིས་མཐོང་ཚུགས། གསལ་བྱང་དང་སྡེ་རིམ་གྱི་གནས་སྤྱོད་མེན་པར་ དམིགས་བསལ་གྱི་ཚིག་ཡིག་མཐོ་ཤོས་མཐོང་མི་དེ་ཐོ་བཀོད་དགོ། ཁྱོད་རང་ལུ་ཝེབ་དྲན་སྡེབ་འདི་མ་པ་ལས་མིན་དགོ་པ་ཅིན་ལྕོགས་མིན་བཟོ་བཏུབ།';
$string['configcachetext'] = 'ས་ཁོངས་རྒྱ་སྦོམ་འབད་རུང་ ཡིག་གཟུགས་ཀྱི་ཚགས་མའི་ས་ཁོངས་འབད་རུང་ དེ་གིས་སྒྲིགས་སྟངས་མགྱོགས་ཚད་ཡར་དྲག་འགྱོཝ་ཨིན། ཡིག་གཟུགས་འདྲ་བཤུས་ཚུ་གིས་ ལས་སྦྱོར་འབད་བའི་བཀང་ཤོག་འཐད་ཀར་དུ་ ནག་ཐིག་ཆགཔ་ཨིན། སྒྲིགས་སྟངས་རྒྱ་ཆུང་ཤོས་དེ་གིས་ ལཱ་ཨ་ཙི་མར་ཉམས་འགྱོཝ་ཨིན། དེ་འབདཝ་ད་སྒྲིགས་སྟངས་རྒྱ་ཆེ་ཤོས་དེ་གིས་ཡིག་གཟུགས་ཡང་སེལ་འབད་ནི་ལུ་དུས་ཡུན་རིངམ་འབད་འགོརཝ་ཨིན།';
$string['configcalendarcustomexport'] = 'ཟླ་ཐོ་ནང་ལས་ ཟླ་ཚད་འཆར་གཞི་གི་བར་ཚད་ རང་འདོད་བསྟར་སྤྱོད་ནི་ ལྕོགས་ཅན་བཟོ།';
$string['configcalendarexportsalt'] = 'ཚིག་ཡིག་ག་མནོ་འབད་མི་འདི་ བདེན་བཤད་ཉེན་སྲུང་ཡར་དྲག་གི་དོན་ལུ་ ཕྱིའི་ཟླ་ཐོ་ངོ་རྟགས་ཀྱི་དོན་ལུ་ལག་ལེན་འཐབ་འཐབ་ཨིན་པས། གལ་སྲིད་ཁྱོད་ཀྱིས་ཨང་རྟགས་སལཌ་ལུ་ འགྱུར་བ་ཅིན་ འཕྲལ་གྱི་ངོ་རྟགས་ཆ་མེད་གཏང་ཚར་མི་ཚུ་ ཟིན་བྲིས་འབད་གནང་།';
$string['configclamactlikevirus'] = 'ཡིག་སྣོད་ཚུ་གནོད་ཆས་བཟུམ་འབད་བརྩི་འཇོག་འབད།';
$string['configclamdonothing'] = 'ཡིག་སྣོད་བཏུབ་འབད་བརྩི་འཇོག་འབད།';
$string['configclamfailureonupload'] = 'གལ་སྲིད་ཁྱོད་ཀྱི་ རིག་སྒྲིག་ཕྱི་འགྱུར་ དང་ཞི་འཇམ་ཞིབ་ལྟ་དང་ལྡན་པའི་སྐྱེལ་བཙུགས་འབད་ཡོད་པ་ཅིན། དེ་ལས་རིམ་སྒྲིག་ཕྱི་འགྱུར་འཛོལ་བའི་སྒོ་ལས་ དང་རྒྱུ་མཚན་མ་ཤེས་པའི་སྒོ་ལས་ལཱ་ བཀོལཝ་ཨིན། བྱ་སྒྲིག་ག་དེ་སྦེ་འབད་དགོ? ཡིག་སྣོད་ཚུ་གནོད་ཆེན་བཟུམ་ ཟེར་མི་ཁྱོད་ཀྱིས་གདམ་འཐུ་འབད་བ་ཅིན་ ཟུར་རྟགས་ས་ཁོངས་ནང་ སྤོ་ཤུད་འབད་ནི་ཡང་ན་ བཏོན་གཏངམ་ཨིན། ཁྱོད་ཀྱིས་ ཡིག་སྣོད་བཏུབ་བཟུམ་བརྩི་འཇོག་འབད་མི་དེ་ གདམ་འཐུ་འབད་བ་ཅིན་ ཡིག་སྣོད་འདི་སྣོདཐོ་ག་ཨིནམ་འབད་འགྲོ་ཡུལ་ལུ་སྤོཝ་ཨིན། གཅིག་མིན་གཅིག་ བདག་སྐྱོང་གི་དྲན་བརྡ་ཞི་འཇམ་འཛོལ་བ་བྱུངམ་ཨིན།ཡིག་སྣོད་ཚུ་གནོད་ཆེན་བཟུམ་ཟེར་མི་ཁྱོད་ཀྱིས་གདམ་འཐུ་འབད་བ་ཅིན་ རྒྱུ་མཚན་དག་ཅིག་གིས་ཞི་འཇམ་ལཱ་བཀོལ་ནི་ལུ་འཛོལ་བ་བྱུངམ་ཨིན། (ཁྱོད་རང་ག་ཨིནམ་འབད་ གཞི་འགྲུལ་ལམ་འདི་ནུས་མེད་འབད་བཀོད་ཡོདཔ་ལས་བརྟེན་ཨིན་པས) ཡིག་སྣོད་ཚུ་སྐྱེལ་བཙུགས་འབད་ཚར་ཏེ་ཡོད་མི་ཚུ་ཟུར་བརྟག་ས་ཁོངས་ནང་ སྤོ་སོར་འབད་ནི་དང་ ཡངན་ མེདཔ་བཏང་ནི་ དེ་ཚུ་ སྒྲིག་སྟངས་འབདཝ་ད་གཅིག་ཁར་ བདག་འཛིན་འཐབ་དགོ།';
$string['configconvertformat'] = 'གལ་སྲིད་<i>latex</i>, <i>dvips</i> and <i>convert</i>ཚུ་ཡོད་པ་ཅིན་ དམིགས་བསལ་གྱི་སྒྲིགས་བཀོད་ལག་ལེན་འཐབ་སྟེ་གཟུགས་བརྙན་ཚུ་བཟོ་ཚུགས། དེ་མིན་པ་ཅིན། mimeTeX གཡོག་བཀོལ་ཏེ་GIFགཟུགས་བརྙན་བཟོ་ཚུགས།';
$string['configcookiehttponly'] = 'ཁྱད་ཆོས་དང་ལྡན་པའི་ལྕོགས་ཅན་ PHP 5.2.0 བརའུ་ཟར་ ་ཀུ་ཀིས་དང་ http ངོ་མ་ཚུ་ གསརཔ་མཉམ་ཅིག་གཏང་ནིའི་ཁ་བཀོད་འདི་ ཞུ་མི་རྐྱངམ་ཅིག་ལུ་ཨིན། ཀུ་ཀིས་འདི་ scripting གི་ཁ་སྐད་ཐོག་ལས་འཛུལ་སྤྱོད་འབད་ནི་མི་འོང། འདི་བརའུ་ཟར་ གེ་ར་ནང་རྒྱབ་སྐྱོར་མེདཔ་ཨིན་ དེ་མ་ཚད་ གནས་སྐབས་ཀྱི་མཐུན་འགྱུར་དམ་ཟབ་ཅན་དང་གཅིག་ཁར་ཡང་ མེདཔ་འོང་། དེ་གིས་XSS attacks.ལ་ལུ་ཅིག་སྔོན་བཀག་འབད་འོང་།';
$string['configcookiesecure'] = 'གལ་སྲིད་སར་བར་ གྱི་ཨེཆ་ཀྲི་ཀྲི་པི་མཐུད་ལམ་ རྐྱངམ་ཅིག་ དང་ལེན་འབད་བ་ཅིན་དེ་ མཐའ་བཙན་པའི་ ཀུ་ཀིས་ཚུ་ ལྕོགས་ཅན་འབད་གཏང་མི་འདི་ འོས་སྦྱོར་འབདཝ་ཨིན། གལ་སྲིད་ལྕོགས་ཅན་འབད་ཡར་སོང་པ་ཅིན་ འཐད་རེ་བ་རེ་མཛད་གནང་ ཝེབ་སར་བར་ འདི་ཨེཆ་ཀྲི་ཀྲི་པི་// ཡངན་ གཏན་ཀྱང་གཞི་སྒྲིག་འདི་ལོག་སྟེ་ ཨེཆ་ཀྲི་ཀྲི་པི་ཨེས་// ཁ་བྱང་ ནམ་<em>wwwroot</em> ཁ་བྱང་ཚུ་ ཨེཆ་ཀྲི་ཀྲི་པི་ཨེས://གཅིག་ཁར་འགོ་མ་བཙུགས་ཅིན་ འདི་གཞི་སྒྲིག་འདི་ རང་བཞིན་གྱིས་འགྱུར་མ་བཏུབ་གྱོཝ་ཨིན།';
$string['configcountry'] = 'གལ་སྲིད་ཁྱོད་ཀྱིས་རྒྱལ་ཁབ་གཞི་སྒྲིག་འདི་ཁར་འབད་བ་ཅིན་ དེ་ལས་རྒྱལ་ཁབ་འདི་སྔོན་སྒྲིག་རྩིས་ཐོ་ལག་ལེན་པ་གསརཔ་གི་གདམ་འཐུ་འབདཝ་ཨིན། ལག་ལེན་པ་ལུ་བང་བཙོང་གི་སྒོ་ལས་ རྒྱལ་ཁབ་གདམ་འཐུ་འབད་བཅུགཔ་ཨིན། གཞི་སྒྲིག་མེདན་བཞག་དགོ།';
$string['configcourseoverviewfilesext'] = 'འབད་སྤྱོད་ཆོག་པའི་སློབ་ཚན་གི་ཐོའི་ཡིག་གནས་རྒྱ་སྐྱེད་བཅུད་སྡུད་ཚུ།';
$string['configcourseoverviewfileslimit'] = 'སློབ་ཚན་བཅུད་སྡུད་དང་སྦྲགས་བཏུབ་པའི་ཡིག་གནས་ཀྱི་གྱངས་ཁ་མཐོ་ཤོས།';
$string['configcourserequestnotify'] = 'ལག་ལེན་པའི་དབྱེ་བ་ཡང་ལག་ལེན་པ་འདི་ སློབ་ཚན་གསརཔ་ལུ་ ཞུཝ་ད་ལུ་གསལ་བསྒྲགས་འབདཝ་ཨིན།';
$string['configcourserequestnotify2'] = 'སློབ་ཚན་ལུ་ཞུ་བ་འབདཝ་ད་ ལག་ལེན་པ་ གསལ་བསྒྲགས་ནང་ལུ་ག་ཚུདཔ་ཨིན་ན། ལག་ལེན་པ་སློབ་ཚན་ལུ་ གནང་བ་འཐོབ་མི་ཚུ་མིང་ཐོ་དེ་ཁར་ཡོད།';
$string['configcoursesperpage'] = 'སློབ་ཚན་གྱི་ཨང་བཙུགས་ནི་ཚུ་ ཤོག་གྲངས་རེ་རེ་ནང་སློབ་ཚན་གྱི་ཐོ་ནང་བཀྲམ་བཏོན་འབད།';
$string['configcourseswithsummarieslimit'] = 'སློབ་ཚན་གྱི་ཐོ་བཀོད་ནང་ལུ་གསལ་སྟོན་';
$string['configcronclionly'] = 'གལ་སྲིད་འདི་གཞི་སྒྲིག་འབད་བ་ཅིན་ དེ་འབད་བ་ཅིན་ ཀོརོན་ཡིག་ཚུགས་འདི་ རྐྱངམ་ཅིག་ ཝེབ་བརྒྱུད་དེ་ཡོད་པའི་ཚབ་ལུ་ བརྡ་བཀོད་ཀྱི་གྱལ་ལས་ གཡོག་བཀོལ་དགོ། འོག་ལུ་ཡོད་པའི་ཆེོག་ཡིག་ཀོརོན་འདི་མེདཔ་གཏངམ་ཨིན།';
$string['configcronremotepassword'] = 'དེ་གི་དོན་དག་འདི་ ཀོརོན་པི་ཨེཆ་པི་ཡིག་ཚུགས་ཝེབ་བརའུ་ཟར་ འདི་ འོག་ལུ་ཡོད་པའི་ཡུ་ཨར་ཨེལ་གྱི་རྣམ་པའི་ཆོག་ཡིག་འདི་བཀྲམ་སྤེལ་མ་འབད་མི་ལས་ གཡོག་བཀོལ་མི་ཚུགས།:<pre> http://site.example.com/admin/cron.php?ཆོག་ཡིག་ ཨོ་པཱན་སེ་སེམ།</pre>གལ་སྲིད་འདི་སྟོངམ་འབད་ལུས་པ་ཅིན་ ཆོག་ཡིག་འདི་དགོས་མཁོ་མེད།';
$string['configcurlcache'] = 'cURL འདྲ་མཛོད་སྡོད་ནིའི་དོན་ལུ་དུས་ཡུན་གྱི་སྐར་ཆ།';
$string['configcustommenuitems'] = 'ཁྱོད་ཀྱིས་གློག་རིམ་དཀར་ཆག་བཀོད་རིས་སྐོར་ལས་ཚོང་སྤྱོད་རིམ་སྒྲིག་འབད་ཚུགས། གྱལ་རེ་རེ་བཞིན་དུ་གིས་ཚོང་སྤྱོད་ཀྱི་ཡིག་ཚིག་ རྒྱུན་མཐུད་ཀྱི་URLདང་འཕྲུལ་ཆས་ཀྱི་བསླབ་བྱ་ཚུ་ཡིག་འབྲུ་གིས་སོ་སོ་འཕྱེ་སྟེ་ཡོད། ཁྱོད་ཀྱིས་-ལག་ལེན་འཐབ་སྟེ་བཟོ་བཀོད་གསལ་སྟོན་འབད་ཚུགས། དཔེར་ན། <pre> Moodle community|http://moodle.org -Moodle free support|http://moodle.org/support -Moodle development|http://moodle.org/development --Moodle Tracker|http://tracker.moodle.org --Moodle Docs|http://docs.moodle.org -Moodle News|http://moodle.org/news Moodle company -Moodle commercial hosting|http://moodle.com/hosting -Moodle commercial support|http://moodle.com/support </pre> བཟུམ་འབད།';
$string['configdbsessions'] = 'གལ་སྲིད་ལྕོགས་ཅན་དང་ལྡན་པ་ཅིན་ སྒྲིགས་སྟངས་འདི་གིས་ གནས་སྡུད་གཞི་རྟེན་ལག་ལེན་དེ་གི་འབད་འཕྲལ་གྱི་ལཱ་ཡུན་གྱི་ གོ་དོན་མཛོད་ཁང་སྐོར་ལས་ལག་ལེན་འཐབ་ཚུགས། འདི་དམིགས་བསལ་དུ་ ཆེ་བའི་དོན་ལུ་དང་ ཁོམ་མེད་ས་ཁོངས་དང་ ས་ཁོངས་སྡེ་ཚན་ སར་བར་ཚུ་ནང་ བཟོ་རྩིགས་འབད་ ལག་ལེན་འཐབ་ནི། ས་ཁོངས་མངམ་ནང་རང་ གཡོན་ཁ་ཐུག་གི་ནང་ ལྕོགས་མིན་འབད་ཐལ་དོ་བཟུམ་དང་ དེ་ཌྲིགས་འདི་ཚབ་ལུ་ལག་ལེན་འཐབ་ཡོདཔ་ཨིན། འཕྲལ་གྱི་ལག་ལེན་པ་ཚུ་ གཞི་སྒྲིགས་བསྒྱུར་ནི་དེ་གི་དྲན་དེབ་ཕྱི་ཁར་འབད་ནི་ལུ་དྲན་འཛིན་བཀོད། (ཁྱོད་དང་བཅས)གལ་སྲིད་ཁྱོད་ཀྱི་ ཨེམ་ཝའི་ཨེས་ཀུསའུ་ཨེལ་ འདི་ལག་ལེན་འཐབ་པ་ཅིན་ རང་གི་ སི་ཨེན་ཨེཕ ནང་འཕྲིན་ཚན་མཐོ་ཤོས་ལུ་འབད་ཆོག་པའི་གཏན་གཏན་མཛད་གནང་ (or my.ini) མཐའ་ན་ ཕོར་ཨེམ།';
$string['configdebug'] = 'གལ་སྲིད་ཁྱོད་ཀྱི་སྐོར་ཐེངས་དེ་ལུ་ འབབ་པ་ཅིན་ དེ་ལས་  PHP\'s འཛོལ་བའི་སྙན་ཞུ་འདི་ ཡར་འཕེལ་འགྱོཝ་ཨིན་ དེ་འབདཝ་ལས་ ཉེན་བརྡ མངམ་ཚུ་པར་བཏབ་ཨིན། དེ་གོང་འཕེལ་བཟོ་མི་རྐྱངམ་ཅིག་ལུ་ཕན་ཐོག་སྦོམ་ཡོད།';
$string['configdebugdisplay'] = 'ཆ་ཚན་ཨོན་བཞག་ འཛོལ་བའི་སྙན་ཞུ་ འདི་ HTML pageཤོག་གྲངས་ནང་འགྱོཝ་ཨིན། དེ་ལག་ལེན་ངོ་མ་ཨིན་ དེ་འབདཝ་ད་ XHTML, JS,  ཀུ་ཀིས་ དང་སྤྱིར་བཏང་HTTPམགོ་ཡིག་ནང་ཡོད་མི་ཚུ་ མེདཔ་ཐལཝ་ཨིན། ཆ་ཚན་ཨོཕ་བཞག་ དེ་གི་ སར་བར་དྲན་དེབ་ ཨའུཊ་པུཌ་བཟོ་བཏངམ་ཨིན། རྐྱེན་གསལ་ལེགས་ཤོམ་འབད་བཅུགཔ་ཨིན། དེ་་ PHPསྒྲིགས་སྟངས་འཛོལ་བའི་དྲན་དེབ་བཀག་འཛིན་ འབད་དེ་འགྱོཝ་ཨིན།';
$string['configdebugpageinfo'] = 'ལྕོགས་ཅན་བཟོ་ ག་དེམ་ཅིག་སྦེ་ ཁྱོད་ལུ་ཤོག་ལེབ་གི་སྙན་ཞུ་ཤོག་ལེབ་མགུ་ཏོ་ཁར་དགོ་པ་ཅིན།';
$string['configdebugsmtp'] = 'རྐྱེན་སེལ་ཚིག་མང་གི་ལྕོགས་ཅན་གྱི་སྙན་ཞུ་འདི་ གློག་འཕྲིན་བརྡ་བྱང་ ཨེས་ཨེམ་ཀྲི་པི་ སར་བར་ལུ་ གཏང་པའི་བསྒང་འབད་དགོ།';
$string['configdebugvalidators'] = 'ལྕོགགས་ཅན་བཟོ་ ག་དེ་ཅིག་སྦེ་ ཁྱོད་རང་ཕྱིའི་གདན་ཁུངས་ཡོད་པའི་རྒྱུན་མཐུད་ སར་བར་འདི་ཤོག་ལེབ་གྱི་མཇུག་ཤོག་ལུ་དགོ་པ་ཅིན། ལག་ལེན་པའི་མིང་དང་སྦྲག་ལག་ལེན་པ་གསརཔ་བཟོ་དགོ་<em>w3cvalidator</em>, འདི་ལས་མགྱོནམོ་གྱིས་ལྕོགས་ཅན་ཡོདཔ་བཟོ་དགོ། བསྒྱུར་བཅོས་དེས་གནང་བ་མེད་པའི་ལག་ལེན་པ་ཚུ་གིས་ཡང་སར་བར་ནང་འཛུལ་ཚུགས། བཟོ་སྐྲུན་གྱི་ས་སྒོ་ནང་ལྕོགས་ཅན་མ་བཟོ།';
$string['configdefaulthomepage'] = 'ཨ་ནི་འདི་གིས་ནང་བསྐྱོད་འབད་་ཡོད་པའི་ལག་ལེན་པ་ཚུ་གི་ གདོང་ཤོག གི་སྐོར་ལས་ཧ་དགོ།';
$string['configdefaultrequestcategory'] = 'སློབ་ཚན་གྱི་དོན་ལུ་ ལག་ལེན་པའི་གསོལཝ་བཏབ་མི་དེ་གིས་ རང་བཞིན་གྱི་དབྱེ་རིམ་ནང་སྡོད་ཚུགས།';
$string['configdefaultrequestedcategory'] = 'གལ་སྲིད་ཁོང་གི་ཆ་འཇོག་གྲུབ་པ་ཅིན་ སྔོན་ སྒྲིག་དབྱེ་རིམ་ སློབ་ཚན་གྱི་དོན་ལུ་ བཙུགས་ནི་ལུ་ ཁོང་གི་གསོལཝ་བཏབ་བཞིན་ ཚུད་དགོ།';
$string['configdefaultuserroleid'] = 'ལག་ལེན་པ་ལུ་ཡོད་པའི་སྡེ་རིམ་གེ་ར་གིས་ དམིགས་བསལ་གྱི་ལཱ་འགན་དང་ལྕོགས་གྲུབ་ཚུ་ ས་ཁོངས་ཀྱི་སྡེ་ཚན་ལུ་ བྱིནམ་ཨིན། ཡང་ཅིན་ཁོང་གིས་ལཱ་འགན་གཞན་ཚུ་རྩིས་བསྡོམས་བྱིན་བྱིནམ་འོང་། སྔོན་སྒྲིག་འདི་ལག་ལེན་པའི་ལཱ་འགན་བདེན་བཤད་འདི་ཨིན། (ཡང་ན་མགྱོནམ་གྱི་ལཱ་འགན་འདི་ཐོན་རིམ་རྙིངམ་ནང་ཨིན)དེ་གི་ ཁོང་ལུ་ཡོད་པའི་ལཱ་འགན་ དང་གཅིག་ཁར་མི་མཐུན་པ་མི་འབྱུང་ཟེར་ཐོ་བཀོད་འབད། དེ་ལག་ལེན་པའི་ལྕོགས་གྲུབ་ངེས་གཏན་བཟོ་མི་ཚུ་ དེ་ཚུ་སློབ་ཚན་གྱི་སྡེ་ཚན་ལུ་འགན་སྤྲོད་ཚུགས་ནི་གི་དོན་ལུ་མེན། (དཔེར་ན་ གནས་སྐྱོད་སྡེ་ཚན་བཙུགས་ནི་ རང་གི་ཟླ་ཐོ་བདེ་སྒྲིག་བཟོ་ནི)';
$string['configdeleteincompleteusers'] = 'ཐུན་ཚན་དེ་གི་ཤུལ་ལས་ གཞི་སྒྲིག་ཡོངས་རྫོགས་འབད་མ་ཚར་བའི་རྩིས་ཐོ་ཚུ་ མེདཔ་གཏང་ཡོདཔ་ཨིན།';
$string['configdeleteunconfirmed'] = 'གལ་སྲིད་ ཁྱོད་ཀྱིས་གློག་འཕྲིན་བདེན་བཤད་ཀྱི་སྒོ་ལས་ ལག་ལེན་འཐབ་པ་ཅིན་ ཐུན་ཚན་དེ་གི་ནང་འཁོད་ ཐོབ་པའི་ལན་འདི་ ལག་ལེན་པའི་ཁ་ཐུག་ལས་ ཆ་འཇོག་ཡོདཔ་ཨིན། ཐུན་ཚན་དེ་གི་ཤུལ་ལས་ གཏན་གཏན་མེད་པའི་རྩིས་ཐོ་ཚུ་མེདཔ་བཏངམ་ཨིན།';
$string['configdenyemailaddresses'] = 'དམིགས་བསལ་གྱི་དྲོ་མིན་ལས་ ཉན་མ་བཏུབ་པའི་གློག་འཕྲིན་ཁ་བྱང་ ཐོ་བཀོད་དེ་ཡོད་མི་ཚུ་ ལམ་ལུགས་གཅིག་འབད་ཨིན། གཞན་དྲོ་མིན་གེ་ར་གི་དང་ལེན་འབད་ཡོདཔ་ཨིན། ཉན་མ་བཏུབ་པའི་ ཡན་ལག་དྲོ་མིན་ དྲོ་མིན་སྦོམ་ཤོས་དང་གཅིག་ཁར་བསྡོམ་དགོ། དཔེར་ན ། <strong> hotmail.com yahoo.co.uk.live.com</strong>';
$string['configdisableuserimages'] = 'ལག་ལེན་པའི་ཡིག་སྣོད་ཀྱི་གཟུགས་བརྙན་སོར་ནིའི་དོན་ལུ་ ལག་ལེན་ལྕོགས་མིན་འདི་ ལྕོགས་ཅན་བཟོ་དགོ།';
$string['configdisplayloginfailures'] = 'དེ་གི་ཧེན་མའི་ནང་བསྐྱོད་མེདཔ་བཏང་ཡོད་མིའི་སྐོར་ལས་ ལག་ལེན་གདམ་འཐུ་འབད་ཡོད་མི་ལུ་ བརྡ་དོན་བཀྲམ་སྟོན་འབདཝ་ཨིན།';
$string['configdndallowtextandlinks'] = 'ལྕོགས་ཅན་དང་ལྕོགས་མིན་གྱི་ཐོག་ལས་ཚིག་ཡིག་ཚུ་འཐེན་ནི་དང་བཀོག་སྟེ་སློབ་ཚན་ཚུ་ཡིག་སྣོད་དང་ཅིག་ཁར་རྒྱུན་མཐུད་འབད་དེ་འབད་བ་་ཅིན། སེམས་ཁར་བཞག་དགོཔ་འདི་ ཚིག་ཡིག་ཚུ་འཐེན་ཏེ་Firefoxདང་ཡང་ བརའུ་སར་གཞན་མི་ཚུ་ནང་སྐྱེལ་བཙུགས་འབད་བ་ཅིན་ དེ་ཁུངས་བརྟན་མེདཔ་མ་ཟད་སྐྱེལ་བཙུགས་ཡང་འབད་མ་ཚུགས་པའི་ཉེན་ཁ་ཡོད། ཡང་ན་ཚིག་ཡིག་མེདཔ་ཐལ་ཐལཝ་ཚུ་སྐྱེལ་བཙུགས་ཡང་འབད་འོང་།';
$string['configdocroot'] = 'མུ་དྲེལ་དྲོག་སི་གི་ལམ་ལུ་ངོས་འཛིན་འབད། གལ་སྲིད་ཁྱོད་རའི་ལམ་ལུགས་དང་དང་བསྟུན་ གློག་ལམ་ཐོག་ཡིག་ཐོ་བཀོད་པ་ཅིན་ ཁྱོད་ཀྱི་སོར་དགོ། ག་དེ་འབད་ཨིན་རུང་ ཁྱོད་ཀྱི་གཏན་གཏན་འབད་ཕི་ལམ་ལུ་ ཡིག་ཐོ་བཀོད་ནི་ དེ་ རྩ་སྒྲིག་ལྕོག་འཐདཔ་སྦེ་འབད་དགོ། http://docs.moodle.org';
$string['configdoctonewwindow'] = 'ཁྱོད་ཀྱིས་དེ་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ དེ་ལས་འབྲེལ་བ་ཡོད་པའི་མུ་དྲེལ་དྲོགས་སི་ གི་ ཝིན་དྲོ་གསརཔ་ཅིག་སྟོན་འོང་།';
$string['configeditordictionary'] = 'ཡིག་གཟུགས་གདམ་འཐུ་འབད་ད་ དེ་གི་ཞུན་དག་པའི་ བཀོག་བཞག་པའི་ཐོ་ནང་ལུ་འབྱུང་དགོ།';
$string['configeditorfontlist'] = 'གལ་སྲིད་ ལག་ལེན་པ་ཚུ་ཁོང་རའི་ ཁ་སྐད་ཀྱི་དོན་ལུ་ ཨེས་པེལ་ལུ་ ཚིག་མཛོད་མེད་པ་ཅིན་ གནས་གོང་དེ་གི་ལག་ལེན་འཐབ།';
$string['configemailchangeconfirmation'] = 'ལག་ལེན་པ་ཚུ་ ཁོང་རའི་ཡིག་སྣོད་ནང་ཡོད་པའི་ གློག་འཕྲིན་ཁ་བྱང་གི་དོན་ལུ་ གློག་འཕྲིན་ཅིག་ངེས་དཔྱད་རིམ་པར་འབད་དགོ།';
$string['configenableajax'] = 'གཞི་སྒྲིག་འབད་ནི་དེ་གིས་ ཨེ་ཇེ་ཨེ་ཨེཀས་ ལག་ལེན་འཐབ་ནི་ལུ་ (མཐོ་རིམ་ཞབས་ཏོག་སྤྱོད་མི་ སར་བར་ངོས་འདྲ་བ་ ཇ་བ་ཨིས་ཀིརཔཀྲི་ལག་ལེན་འདབ་ནི) ས་ཁོངས་ཆ་མཉམ་ནང་ལས་མར་ ཚད་འཛིན་འབད་བཅུགཔ་ཨིན། གཞི་སྒྲིག་འབདཝ་ད་གཅིག་ཁར་ ལྕོག་ཅན་པའི་ལག་ལེན་པ་ཚུ་གིས་ གདམ་འཐུ་འབད་ཚུགས་ དེ་མིན་ ཨེ་ཇེ་ཨེ་ཨེཀསི་ འདི་གེ་ར་ལུ་གནོད་པའི་ལྕོགས་མིན་ལུ་ཐལཝ་ཨིན';
$string['configenableblogs'] = 'ཨེབ་རྟ་དེ་གིས་ ཝེབ་ལག་ལེན་པ་ཚུ་ག་ར་ རང་གི་ཝེབ་ནང་';
$string['configenablecalendarexport'] = 'སློབ་ཚན་ངོ་མའི་ཤོག་གྲངས་ངོ་མ་ ཞུན་དག་རྐྱབ་པའི་སྐབས་ལུ་ ཨེ་ཇེ་ཨེ་ཨེཀསི་ འདི་ལག་ལེན་འཐབ་ནི་མི་འོང་།';
$string['configenablecomments'] = 'བསམ་བཀོད་ལྕོགས་ཅན་བཟོ།';
$string['configenablecourserequests'] = 'དེ་གི་ལག་ལེན་པ་ག་ལུ་འབད་རུང་ སློབ་ཚན་གསར་བསྐྲུན་འབད་ནི་ལུ་ གསོལ་བཏབ་འབད་བཅུགཔ་ཨིན།';
$string['configenabledevicedetection'] = 'ལྕོགས་ཅན་བཟོ་mobiles, smartphones, tablets or default devices (desktop PCs, laptops, etc) ཚུ་ལག་ལེན་འཐབ་ནིའི་དོན་ལུ་ཁྱད་རྣམས་དང་བཀོད་རིས་ཤོག་ལེབ་བཟོ།';
$string['configenablegroupmembersonly'] = 'གལ་སྲིད་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ སྦྱོང་ལཱ་ནང་འཛུལ་སྤྱོད་དེ་སྡེ་ཚན་དེ་ནང་གི་འཐུས་མི་ཚུ་གིས་རྐྱངམ་ཅིག་འབད་ཚུགས། དེ་གིས་སར་བར་ལུ་ལྗིད་ཐེབ་འོང་ཉེན་ཡོད། འདི་གུ་ལུ་གནས་ཚད་ཀི་དེབ་ཀྱི་དབྱེ་ཁག་འདི་ཡང་གཞི་སྒྲིག་འབད་དེ་སྦྱོང་ལཱ་ག་ར་འཐུས་མི་མིན་པའི་སྡེ་ཚན་ཚུ་ལས་སྦ་བཞག་ཐབས་འབད་དོ།';
$string['configenablemobilewebservice'] = 'ལྕོགས་ཅན་བཟོ་ གཞུང་འབྲེལ་མོཌེལ་ mobile ཞབས་ཏོག་ ཡང་ན་ དེ་བསྟུན་གྱི་ཞུ་བ་ཚུ། ཁ་གསལ་གྱི་དོན་ལུ་ {$a}ལྷག།';
$string['configenablerssfeeds'] = 'གློག་རྟ་དེ་གི་ ཨར་ཨེས་ཨེས་ ལྕོགས་་ལུ་བཟོ་ནི་འདི་ ས་ཁོངས་གེ་ར་ལས་བྱུངམ་ཨིན་། གཞན་དེ་འབད་ལྟ་བ་ཅིན་ འགྱུར་བ་ག་ཅི་བཟུམ་ཡོད་རུང་རང་ ཁྱོད་ཀྱི་ཨར་ཨེས་ཨེས་འབྱུང་མི་ དེ་སྦྱོང་ཚན་རེ་རེ་ལུ་ཡང་ལྕོགས་ཅན་བཟོ་དགོ།';
$string['configenablerssfeedsdisabled'] = 'དེ་ཐོབ་ཆོག་ཆོག་མིན་འདུག་ ག་ཅི་འབད་ཟེརན་ ཨར་ཨེས་ཨེས་འབྱུང་མི་དེ་ཚུ་ ས་ཁོངས་གེ་ར་ནང་ལྕོགས་མིན་ཐལ་ཐལཝ་ཨིན་པས། དེ་ལུ་ལྕོགས་ཅན་བཟོ་ནི་འདི་ བདག་སྐྱོང་རིམ་སྒྲིག་གི་འོག་ལུ་ཡོད་པའི་ གཞི་སྒྲིག་འགྱུར་ཅན་ ལུ་འགྱོ་དགོ།';
$string['configenablerssfeedsdisabled2'] = 'RSS་འབྱུང་མི་ཚུ་ སར་བར་གྱི་གནས་རིམ་ནང་ལྕོགས་མིན་ཐལ་ཡོདཔ་ཨིན། དང་པ་རང་ཁྱོད་ཀྱིས་ཁོང་ཚུ་སར་བར་ནང་ལྕོགས་ཅན་བཟོ་དགོཔ་ཨིན།';
$string['configenablesafebrowserintegration'] = 'གདམ་ཁ་འདི་ ཁ་སྐོང་བཀལ་ ཉེན་སྲུང་བརའུ་ཟར་གྱི་དོན་ལུ་ ཆོས་རྒྱུགས་བརའུ་ཟར་སྲུང་ནིའི་དགོས་མཁོ་ རྩོད་གཞིའི་གཞི་སྒྲིག་གི་རྣམ་པ་ས་སྒོ་ལུ། ཨེཆ་ཀྲི་ཀྲི་པི་ལྟ://www.safeexambrowser.org/གོ་དོན་མངམ་གི་དོན་ལུ།';
$string['configenablestats'] = 'གལ་སྲིད་ཁྱོད་ཀྱི་ན་ལུ་ བཏུབ་ཟེར་བ་ཅིན། མུ་དྲེལ་ཀོརོན་ཇོབ་ དེ་གི་ལས་ལས་སྦྱོར་དྲནན་དེབ་དང་ ཚད་རྩིས་ཚུ་བསྡ྄་སྤུངས་འབད་ནི། དངུལ་གྱི་འགྲུལ་ལམ་ས་སྒོ་གི་དོན་ལུ་ བརྟེན་ཏེ་ དེ་གི་ཡུདཔ་ཐེངས་ཅིག་སྒོརཝ་ཨིན། གལ་སྲིད་ཁྱོད་ཀྱི་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ ཁྱོད་ཀྱི་སློབ་ཚན་རེ་རེ་གི་སྐཽར་ལས་ གརཕ་དང་ཚད་རྩིས་ སྤྲོ་བ་ཆེཏོག་ཏོ་མཐོང་ཚུགས་ ཡང་ན་ས་ཁོངས་ཝེའིདྲ་གཞི་རྩ།';
$string['configenabletrusttext'] = 'མུ་ཌེལ་སྔོན་སྒྲིག་དེ་གི་འབད་ དུས་ཨ་རྟག་རང་ ལག་ལེན་པ་ཚུ་གིས་འབད་ ཡིག་གཟུགས་གཙང་དག་རྒྱསཔ་སྦེ་འབད་ནི་ ལུ་ ཡིག་ཚུགས་གྱང་ཉེས་ཚུ་ག་དེ་འཇམ་འཇམ་བཏོན་གཏང་དགོ། བརྡ བརྒྱུད་ལ་སོགས་པ་ ཚུ་གིས་ ཉེན་སྲུང་འབད་ཚུགས། བློ་གཏད་ཚུགས་པའི་ ནང་དོན་ལམ་ལུགས་འདི་ དམིགས་བསལ་གྱི་ལག་ལེན་ལུ་བྱིན་ཐངས་དེ་ཡང་ ཁྱོད་ཀྱི་ལྕོགས་གྲུབ་ལུ་བློ་གཏད་དང་བཅས་ དེ་ཚུ་སྔ་གཡར་ཁྱད་རྣམ་ཚུ་ ཁོང་རའི་གོ་དོན་ ཚུ་བར་བཀྲོག་མེད་པར་ བློགཏད་ཚུགས། རིམ་ལུགས་ལྕོགས་ཅན་འདི་ལུ་ གཞི་སྒྲིག་འབད་དགོཔ་ཡོད། དེ་ལས་དམིགས་བསལ་གྱི་མུ་དྲིལ་གྱི་ལཱ་འགན་ལུ་ བློལ་གཏད་པའི་ནང་དོན་གནང་བ་གྲོགས་རམ་འབདཝ་ཨིན། ཡིག་ཚུགས་འདི་གསར་བསྐྲུན་འབད་ནི་དང་ སྐྱེལ་བཙུགས་འབད་ཡོདཔ་དང་ ལག་ལེན་པ་དེ་བཟུམ་གི་བློ་གཏད་ཚུགས་པའི་ངོ་རྟགས་བཟུམ་འབད་ གཙང་དག་མ་འབད་བའི་ཧེན་མར་བཀྲམ་སྟོན་འབད་མི་ཚུགས།';
$string['configenablewebservices'] = 'ཝེབ་ སར་བར་གྱིས་ལྕོགས་ཅན་བཟོ་སྟེ་ གཞན་མི་ལམ་ལུགས་ཚུ་ མོཌེལ་འདི་ནང་ལུ་ནང་བསྐྱོད་འབད་དེ་ལཱ་འབདཝ་ཨིན། ཉེན་སྲུང་ཧེང་བཀལ་འབད་ནིའི་དོན་ ཨ་ནི་ཁྱད་རྣམ་འདི་ལག་ལེན་ངོ་མ་་འཐབ་སྟེ་མེད་པ་ཅིན་ལྕོགས་མིན་བཟོ་བཞག་དགོ།';
$string['configenablewsdocumentation'] = 'ཝེབ་ གི་ཞབས་ཏོག་རང་བཞིན་གྱིས་བཟོ་ནིའི་དོན་སྟེ་ཡིག་ཆར་བཀོད་ནི་དོན་ལུ་ ལྕོགས་ཅན་བཟོ།
ལག་ལེན་པ་གཅིག་གིས་ཁོ་རའི་ཉེན་སྲུང་གི་ལྡེ་མིག་ཤོག་ལེབ{$a}.་གིས་ཁོ་རའི་ཡིག་ཆ་ནང་འཛུལ་སྤྱོད་འབད་ཚུགས། འདི་གིས་ཡིག་ཆ་ཚུ་འབྲེལ་བ་འབད་ནིའི་དོན་ལུ་རྐྱངམ་ཅིག་ལྕོགཧ་ཅན་བཟོ་འོང་།';
$string['configerrorlevel'] = 'ཨི༌ཨེཆ༌ཨི༌གི༌རྩིས༌ཐོ༌གདམ༌ཁ༌རྐྱབ༌ཉེན༌བརྡ༌དེ༌ཁྱོད༌ཀྱི༌བཀྲམ༌བཏོན༌འབད༌ཡོདཔ། སྤྱིར༌བཏང༌འདི༌རང་བཞིན་གྱི་གདམ་འཐུ་ཡང་དག་ཨིན།';
$string['configexportlookahead'] = 'ཕྱིར་སྐྱེད་ཀྱི་སྐབས་བལྟ་དགོ་པའི་ཉིན་གྲངས།';
$string['configexportlookback'] = 'ཕྱིར་སྐྱེད་ཀྱི་སྐབས་ ལོག་བལྟ་དགོ་པའི་ཉིན་གྲངས།';
$string['configextendedusernamechars'] = 'སློབ་ཕྲུག་ཚུ་གི་ཁོང་རའི་ལག་ལེན་པ་གི་མིང་ནང་གཞི་སྒྲིག་འདི་ལྕོགས་ཅན་ལུ་ ཡིག་འབྲུ་ག་འབད་རུང་ ལག་ལེན་འཐབ་ཆོགཔ་སྦེ་འབད་དགོ། (ཁོང་རའི་མིང་ངོ་མ་ལུ་ཕན་གནོད་ག་ནི་ཡང་མེད་མི་ཐོ་བཀོད)སྔོན་སྒྲིག་འདི་ རྫུན་མ་ ལག་ལེན་པའི་མིང་ཚུ་ ཨལ་ཕ་ནི་མི་རིག་ གི་ཡིག་འབྲུ་རྐྱངམ་ཅིག་ བཀག་འདམ་འབད་དགོ།';
$string['configextramemorylimit'] = 'ཡིག་གཟུགས་འདི་ཞིབ་འཚོལ་བཟུམ་ རྒྱབ་ཐག་ སོར་ཆུད་ཡང་ན་ ཀོརོན་ དྲན་ཚད་མངམ་དགོས་མཁོ་ཡོདཔ། གཞི་སྒྲིག་མཐོ་ཤོས་གནས་གོང་འདི་ ས་ཁོངས་ཆེ་བའི་དོན་ལུ།';
$string['configfilterall'] = 'ཡིག་རྒྱུན་ཚགས་མ་གེ་ར། མགོ་རྒྱན་དང་བཅས། མགོ་མིང་ འགྲུལ་བསྐྱོད་ དང་ཕྲ་རིང་ལ་སོགས་པ། ཁ་སྐད་སྣ་མང་ ཚགས་མ་ ལག་ལེན་འཐབ་ད་ལུ་ ཁག་ཆེཝ་སྦོམ་འབད་མཐོང་ཡི། དེ་མིན་པ་ཅིན་ དེ་གི་ས་ཁོངས་ཁེ་ཕན་ཨ་ཙི་ཐོབ་ནི་གི་དོན་ལུ་གསར་བསྐྲུན་ཐེབས་མངོན་གསལ་འབད་འོང།';
$string['configfiltermatchoneperpage'] = 'རང་བཞིན་གྱི་འབྲེལ་མཐུད་ཚགས་མ་ཚུ་གིས་ རྐྱང་པའི་འབྲེལ་ལམ་ལུ་ སྤེལ་ཏེ་མཉམ་སྒྲིག་ཡིག་གཟུགས་དང་པ་གི་དོན་ལུ་ དཔེར་ན་ ཤོག་གུ་རྫོགས་མི་ཅིག་ཐོབ་མི་བཟུམ། གཞན་མི་གེ་ར་སྣང་མེདཔ་ཐལ་ཡོདཔ།';
$string['configfiltermatchonepertext'] = 'རང་བཞིན་གྱི་ཚགས་མ་ལུ་འབྲེལ་བ་འཐུས་མི་དེ་གི་ རྐྱང་པ་འབྲེལ་བ་བཟོ་སྟོན་འབད་དེ་ དཔེར་ན་ཤོག་གུ་ནང་ འདྲ་མཉམ་དང་པའི་ཡིག་ཚུགས་ འདི་ (དཔེར་ན་ཡིག་ཚུགས་རེ་རེ་ དཔེར་ན་ ཐོན་ཁུངས་ སྡེབ་ཚན་ ) གཞན་མི་གེ་ར་སྣང་མེདཔ་ཐལ་ཡོདཔ། གལ་སྲིད་ཤོག་གུ་གཅིག་སྒྲིགས་སྟངས་འབད་བ་ཅིན་ གཞི་སྒྲིག་འདི་སྣང་མེདཔ་ཐལ་ཡོདཔ་ཨིན།<i>yes</i>.';
$string['configfilteruploadedfiles'] = 'ཨེཆ་ཀྲི་ཨེམ་ཨེལ་གྱི་ལས་སྦྱོར་གེ་ར་སྐྱེལ་བཙུགས་འབད་ཡོདཔ་དང་ ཡིག་གཟུགས་ཀྱི་ཡིག་སྣོད་ཚུ་ ཚགས་མ་དང་གཅིག་ཁར་ ཁོང་ལུ་བཀྲམ་སྟོན་མ་འབད་བའི་ཧེན་མར་། ཨེཆ་ཀྲི་ཨེམ་ཨེལ་ རྐྱངམ་ཅིག་སྐྱེལ་བཙུགས་འབད་ཡོདཔ་ ཡིག་སྣོད་ཚུ་ གེ་ར་གཅིག་ཡང་མེདཔ་འབད་འགྱོཝ་ཨིན།';
$string['configforcelogin'] = 'གདོང་ཤོག་ནང་ཡོད་པའི་ས་ཁོངས་དང་སློབ་ཚན་ཐོ་ཚུ་ རང་ོཞིན་གྱིས་ མི་དེ་ཚུ་གིས་་ས་ཁོངས་ནང་ནང་བསྐྱོད་མ་འབད་བར་ལྷག་ཚུགས། གལ་སྲིད་ཁྱོད་ཀྱི་མི་དེ་ཚུ་ ཁོང་གི་ག་ནི་ཡང་མ་འབད་བའི་ཧེན་མར་བང་ཅན་གྱི་ཐོག་ལས་ ནང་བསྐྱོད་འབད་བཅུག་པ་ཅིན་ སྟེ་དེ་ལས་ ཁྱོད་ཀྱི་གཞི་སྒྲིག་འདི་ལྕོགས་ཅན་བཟོ་ཚུགསཔ་སྦེ་འབད་དགོ།';
$string['configforceloginforprofiles'] = 'གཞི་སྒྲིག་འདི་ མི་ཚུ་ལུ་ བང་ཅན་གྱི་ཐོག་ལས་ ལག་ལེན་པའི་ཡིག་སྣོད་མ་མ་ཐོང་པའི་ཧེན་མར་ རྩིས་ཐོ་ངོ་མ་(མགྱོནམ་མེན་མི) བཟུམ་སྦེ་ནང་བསྐྱོད་ འབད་བཅུགཔ་ཨིན། གལ་སྲིད་གཞི་སྒྲིག་འདི་ལྕོགས་ཅན་འབད་ཚུགས་པ་ཅིན་ ཁྱོད་ཀྱི་ ལག་ལེན་པའི་ཁྱབ་བསྒྲགས་ གཏང་ཚུགསཔ་ཐོབ་ནི་འོང་ ཡང་ན་ ཡིག་སྣོད་ནང་ཡོད་པའི་ནང་དོན་འོས་མེད་གཞན་ཐོབ་ཚུགས་ནི་ཨིན། སྟེ་དེ་ལས་འབདན་ འཛམ་གླིང་ཡོངས་འབྲེལ་གྱི་མཐོང་ཚུགས།';
$string['configfrontpage'] = 'གོང་གི་རྣམ་གྲངས་གདམ་ཁ་རྐཡབ་མི་དེ་གི་ གདོང་ཤོག་གི་ས་ཁོངས་ནང་ བཀྲམ་སྟོན་འབད་ཡོདཔ་ཨིན།';
$string['configfrontpagecourselimit'] = 'སློབ་ཚན་གྲངས་ཁ་མཐོ་ཤོས།';
$string['configfrontpagecourselimithelp'] = 'གནས་ཁོངས་གི་གདོང་ཤོག་ནང་ དངོས་སྟོན་འབད་དགོ་པའི་ སློབ་ཚན་གི་གྱངས་ཁ་མཐོ་ཤོས།';
$string['configfrontpageloggedin'] = 'ལག་ལེན་པའི་ནང་བསྐྱོད་འབད་བའི་བསྒང་ གོང་གི་རྣམ་གྲངས་གདམ་ཁ་རྐྱབ་མི་དེ་གི་ གདོང་ཤོག་གི་ས་ཁོངས་ནང་ བཀྲམ་སྟོན་འབད་ཡོདཔ་ཨིན།';
$string['configfullnamedisplay'] = 'ཡོས་རྫོགས་བཀྲམ་སྟོན་འབད་བའི་བསྒང་ མིང་ཚུ་ག་དེ་འབད་འཐོན་ཡི་ག་ངེས་འཛིན་ཡི། སྐད་ཡིག་རྐྱང་པོ་ས་ཁོངས་ཀྱི་དོན་ལུ་ རངམ་སྒྲིག་གི་གཞི་སྒྲིག་འདི་ ནུས་ཤུགས་ཅན་ཅིག་ཨིན་ མགོ་མིང་ རུས་མིང་ ཁྱོད་ཀྱི་རུས་མིང་གེ་ར་གཅིག་ཁར་འབད་ གདམ་ཁ་རྐྱབ་སྟེ་ སབ་བཞག་རུང་ ཡང་ན་ འཕྲལ་གྱི་ཁ་སྐད་ཀྱི་སྦུང་ཚན་ལུ་ མཐའ་གཅད་ནི་ལུ་ བཀོག་བཞག་རུང་བཏུབ། ཁ་སྐད་དག་པ་ཅིག་ལུ་ གྲོས་འཛོམས་སོ་སོ་ཡོདཔ་ཨིན།';
$string['configgeoipfile'] = 'ཇི་ཨི་ཨོ་ཨའི་པི་ གི་གནས་ཁོངས་ཁྲོམ་གྱི་ ཟུང་ལྡན་གནས་སྡུད་ཡིག་སྣོད། ཡིག་སྣོད་འདི་ མུ་དྲེལ་བཀྲམ་སྤེལ་གྱི་ཆ་ཤས་ཅིག་མེན་ འོག་གི་ཚུ་ལས་ སོ་སོར་འབད་འཐོབ་དགོཔ་ཨིན།<ahref="http://www.maxmind.com/">MaxMind</a>.ཁྱོད་ཀྱི་ཚོང་འབྲེལ་གྱི་ཐོན་རིམ་ལས་ཉོ་ནི་དང་ཡང་ན་ ཐོན་རིམ་སྟོང་ན་འབད་ལག་ལེན་འཐབ་ནི།.<br />ཕབ་ལེན་འཇམ་སམ་<ahref="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz">http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> དང་ཕྱིར་འདོན་འབད་དི་་སར་བར་ནང་གི་"{$a}"སྣོད་ཐོ་ནང་བཞག།';
$string['configgetremoteaddrconf'] = 'གལ་སྲིད་ ཁྱོད་ཀྱི་སར་བར་འདི་ རིམ་ལོག་པོརོ་སི་ གི་རྒྱབ་ཁར་འབད་བ་ཅིན། ཁྱོད་ཀྱི་དམིགས་བསལ་གྱི་སྒྲིགས་སྟངས་ དེ་ཨེཆ་ཀྲི་ཀྲི་པི་ འགོ་འཛིན་དེ་གིས་ ཐག་རིང་གི་ཨའི་པི་ ཁ་བྱང་ལུ་བློ་གཏད་ཡོདཔ་སྦེ་འབད་དགོ། དེ་འགོ་འཛིན་དེ་ཚུ་རིམ་པ་བཞིན་ལྷག་ དང་པ་ལག་ལེན་འཐབ་མི་ཐོབ་ཆོག་ཆོག་འདི།';
$string['configgradebookroles'] = 'གཞི་སྒྲིག་དེ་གིས་ ཁྱོད་ཀྱི་སྡེ་དེབ་ནང་འབྱུང་མི་ཚུ་ལུ་ཚད་འཛིན་འབད་ཚུགས། ལག་ལེན་པ་དེ་ཚུ་མཐའ་ན་ཉུང་ཤོས་རང་ སློབ་ཚན་གྱི་ལཱ་འགན་གཅིག་སྡེ་དེབ་ནང་སྟོན་དགོ་མི་འདི་ སློབ་ཚན་གྱི་དོན་ལུ་ཨིན།';
$string['configgradeexport'] = 'ཁྱོད་ཀྱི་ གཞི་རིམ་ཐབས་ལམ་འདི་ ཕྱིར་འདྲེན་སྡེ་རིམ་གྱི་དོན་ལུ་ སྡེ་དེབ་ཕྱིར་འདྲེན་རྩ སྒྲིག་ག་དེ་ཨིན་གདམ་ཁ་རྐྱབ། ཨ་ལག་ཨིན་ གདམ་ཁ་རྐྱབ་མི་དེ་གིས་ གཞི་སྒྲིག་དང་ལག་ལེན་འཐབ་ནི་ ”མཇུག་ལུ་ཕྱིར་འདྲེན་གཏང་མི”ས་སྒོ་ནང་སྡེ་རིམ་གེ་ར་བཙུགས་ནིའི་དོན་ལུ། དཔེར་ན་ དེ་གི་ཕྱིར་འདྲེན་དྲན་ཐོ་འབད་བའི་བསྒང་གི་ངོ་རྟགས་ བཟུམ་འབྱུང་འོང་། “གསརཔ་"ཡང་“ དུས་མཐུན་བཟོ་ཚར་ཚརཝ”གལ་སྲིད་ཁྱོད་ཀྱི་དེ་གི་སྐོར་ལས་ གཏན་གཏན་མ་ཤེས་པ་ཅིན་ དེན་གེ་ར་ཞིབ་དཔྱད་མ་འབད་བར་བཀོག་བཞག།';
$string['confighiddenuserfields'] = 'ལག་ལེན་པའི་གོ་བརྡ ས་སྒོ་གདམ་འཐུ་འབད་ ཁྱོད་ཀྱི་བློ་འདོད་ལྟར་དུ་ སློབ་ཚན་སློབ་དཔོན་ཚུ་དང་བདག་སྐྱོང་ལས་ལོགས་སུ་ཀར་ཏེ་ ལག་ལེན་པ་གཞན་མི་ལས་སྦ་བཞག། དེ་གི་སློབ་ཕྲུག་ཚུ་གིས་ སྒེར་གཙང་ཡར་འཕར་འགྱོཝ་ཨིན་ ཚད་འཛིན་སྡེ་མིག་བཟུང་སྟེ་ སྣ མང་ས་སྒོ་གདམ་འཐུ་འབད།';
$string['configidnumber'] = 'གདམ་ཁ་འདི་ གསལ་བཀོད་འབད་ནི་ཨིན་རུང་འབད། (ཀ) ལག་ལེན་པ་ཚུ་གི་ གཞན་ག་ཅི་ཨིན་རུང་ མི་ཁུངས་ཨང་གྲངས་ དྲི་ནི་མེན། (ཁ) ལག་ལེན་པ་ཚུ་ གིས་མི་ཁུངས་ཨང་གྲངས་དྲི་ནི་ དེ་འབདཝ་ད་ སྟོངམ་འབད་བཀོག་བཞག་ ཡང་ན་ (ག)ལག་ལེན་ པའི་མི་ཁུངས་ཨང་གྲངས་དྲིས་ཡོད་ སྟོངམ་བཞག་མི་ཚུགས། གལ་སྲིིད་ལག་ལེན་པའི་མི་ཁུངས་ཨང་གྲངས་ ཁོང་རའི་ཡིག་སྣོད་ནང་ བཀྲམ་སྟོན་འབད་ཡོདཔ།';
$string['configintro'] = 'ཤོག་གྲངས་འདི་ཁར་ ཁྱོད་ཀྱི་རིམ་སྒྲིགས་ཀྱི་ཨང་གྲངས་སོ་སོ་དེ་གིས་ སར་བར་མུ་ཌེལ་གྱི་ལཱ་དེ་ཚུ་ཞུན་དག་སྦེ་འབད་ཚུགས། དེ་གི་སྐོར་ལས་ཚ་གྱང་སྦོམ་ལང་མི་དགོ་ མ་གཞི་སྔོན་སྒྲིག་དེ་གི་ལཱ་ལེགས་ཤོམ་དང་ ཁྱོད་ཀྱི་ཤུལ་ལས་ཤོག་གྲངས་དེ་ཁར་འོང་ནི་དང་ སྒྲིགས་སྟངས་དེ་ཚུ་སོར་དགོ།';
$string['configintroadmin'] = 'ཁྱོད་ཀྱི་ཤོག་གྲངས་འདི་ཁར་ཡོད་པའི་ རིམ་སྒྲིགས་འདི་ ཁྱོད་ཀྱི་བདག་སྐྱོང་ངོ་མ་ གི་རྩིས་ཐོ་ དེ་གི་ས་ཁོངས་ཆ་མཉམ་ཚད་འཛིན་འབད་ཚུགསཔ་སྦེ་འབད་དགོ། ཁྱོད་ཀྱི་མཐའ་ཙན་ཏོག་ཏོ་ཡོད་པའི་ ལག་ལེན་པའི་མིང་ དང་ཆོག་ཡིག་ དེ་མ་ཚད་ ནུས་ཅན་གློག་འཕྲིན་ཁ་བྱང་སྤྲོད་ཚུགཔ་འབད་གཏན་གཏན་བཟོ་དགོ། ཁྱོད་ཀྱི་ཤུལ་ལས་ བདག་སྐྱོང་གི་རྩིས་ཐོ་མངམ་སྦེ་གསར་བསྐྲུན་འབད་དགོ།';
$string['configintrosite'] = 'ཤོག་གྲངས་དེ་གིས་ ཁྱོད་ལུ་ གདོང་ཤོག་གི་ས་ཁོངས་གསརཔ་གི་མིང་རིམ་སྒྲིག་འབད་ཆོག། ཁྱོད་ཀྱིས་ཤུལ་ལས་དེ་ཁར་འོང་བཞིནམ་ལས་ དུས་ཚོད་ནམ་འབད་རུང་ བདག་སྐྱོང་གི་དཀར་ཆག་ལག་ལེན་འཐབ་སྟེ་སྐབས་ལུ་ སྒྲིག་སྟངས་སོར་ཚུགས།';
$string['configiplookup'] = 'མ་ཅིག་ཁྱོད་ཀྱིས་IP་ཁ་བྱང་ལུ་ཨེབ་གཏངམ་ད་ (དེ་བཟུམ་ ༣༤ .༡༢.༢༢༢.༩༣) དེ་བཟུམ་དྲན་དེབ་ནང་ ཁྱོད་ཀྱིས་ས་ཁྲ་སྟོན་མི་ནང་ སྔོན་ཤེས་ཡང་དག་ IPའདི་ས་ཁོངས་འདི་ག་སྟེ་གནས་གནསཔ་ཨིན་ན། དེ་ཁ་ལུ་པ་ལག་ཨིན་ཁག་སོ་སོར་གྱི་དོན་ལུ་ ཁྱོད་ཀྱི་གདམ་ཁ་ག་སྟེ་ལས་རྐྱབ་ནི་ཨིན་ན་ རེ་རེ་ལུ་ཕན་ཐོག་དང་གནོད་པ་ཚུ་ཡོདཔ་ཨིན།';
$string['configkeeptagnamecase'] = 'འདི་ཞིབ་དཔྱད་འབད་ གལ་སྲིད་ཁྱོད་ལུ་མིང་གི་ངོ་རྟགས་ ཤུབས་ངོ་མ་ནང་ ལག་ལེན་པ་དང་བཟོ་བསྐྲུན་པ་ཚུ་གི་བཙུགས་ཡོདཔ་བཟུམ་འབད།';
$string['configlang'] = 'ས་ཁོངས་ཧྲིལ་བུར་གྱི་དོན་ལུ་ རིམ་སྒྲིག་ཁ་སྐད་འདི་གདམ་ཁ་རྐྱབ། ལག་ལེན་པ་གིས་ཤུལ་ལས་གཞི་སྒྲིག་འདི་མེདཔ་གཏང་འོང་།';
$string['configlanglist'] = 'དེ་ཁར་སྟོངམ་བཞག་སྟེ་ ལག་ལེན་པས་ག་སྟེ་ལས་འབད་རུང་གཅིག་གདམ་ཁ་རྐྱབ་ དེ་ཡང་ཁྱོད་ལུ་མོ་ཌེལ་ གཞི་བཙུགས་འབད་ཡོད་མི་ཅིག། ག་དེ་འབད་རང་ཨིན་རུང་ ཁྱོད་ཀྱི་ཁ་སྐད་མཛོད་འདི་འཐུང་ཀུ་འབད་བཟོ་ དེ་ཡང་ཚག་བཙུགས་ཏེ་སོ་སོར་འབད་ ཁ་སྐད་ཀྱི་ཨང་རྟགས་འཁྱོད་དགོ་མི་དེ། དཔེར་ན་ en,es_es,fr,it';
$string['configlangmenu'] = 'གདོང་གི་ཤོག་ལེབ་གུར་ སྤྱིར་བཏང་ཁ་སྐད་ཀྱི་དམིགས་ཡུལ་དཀར་ཆག་བཀྲམ་སྟོན་འབད་ནི་ཨིན་ན་མེན་ གདམ་ཁ་རྐྱབ། ནང་བསྐྱོད་ལ་སོགས་པ། ཁོང་རའི་ལག་ལེན་པ་གི་ལྕོགས་གྲུབ་དང་འཁྲིལ་ ཁོང་རའི་ཡིག་སྣོད་ངོ་མ་ནང་ དགའ་གདམ་ཅན་གྱི་ཁ་སྐད་གཞི་སྒྲིག་འབད་མི་ལུ་ ཕན་གནོད་ག་ནི་ཡང་མེད།';
$string['configlangstringcache'] = 'ཡིག་རིགས་དང་ཡིག་སྣོད་ཕྱོགས་སྡེབ་ཚུ་ག་ར་གནས་སྡུད་སྣོད་དེབ་གློག་རིག་དྲན་མཛོད་ནང་ལུ་ཡོད། ག་དེ་ཅིག་སྦེ་ ཁྱོད་མོ་ཌེལ་སྐད་བསྒྱུར་འབད་བའམ་ མོ་ཌེལ་གྱི་གཞི་ཨང་སོར་བ་ཅིན་ ཁྱོ་ཀྱིས་ཨ་ནི་སོར་བསྒྱུར་མ་བཏུབ་བཟོ།་དེ་མིན་པ་ཅིན་ འདི་སོར་བསྒྱུར་བཏུབ་སྦེ་བཞག་སྟེ་བྱ་སྒོའི་ཁེ་ཕན་ལྟ།';
$string['configlatinexcelexport'] = 'Excel་ཕྱིར་འདྲེན་གྱི་དོན་ལུ་ ཨེན་ཀོ་དྲིང་གདམ་ཁ་རྐྱབས།';
$string['configlocale'] = 'ལོ་ཀོལ་གྱི་ས་ཁོངས་རྒྱ་ཆེ་གདམ་ཁ་རྐྱབ། དེ་གི་རྩ་སྒྲིག་དང་ཁ་སྐད་སྦུང་ཚན་གེ་ར་གི་དོན་ལུ་ ཡོད་མི་ཁ་སྐད་སྤྱི་ཚེས་ཚུ་མེདཔ་གཏངམ་ཨིན། (ཟླ་ཐོ་ནང་ཡོད་པའི་ཉིནམ་གྱི་མིང་ཚུ་ཕན་གནོད་ག་ནི་ཡང་མེདཔ་ཨིན་རུང་) ཁྱོད་ཀྱི་ ལོ་ཀོལ་གནས་སྡུད་འདི་ ཁྱོད་ཀྱི་བཀོལ་སྤྱོད་རིམ་ལུགས་ནང་གཞི་བཙུགས་འབད་ཡོདཔ་འབད་དགོ།';
$string['configloginhttps'] = 'ཨོན་ལུ་བསྒྱིར་ནི་ དེ་གི་མོ་ཌེལ་མཐའ་ཙན་བཟོ་ནི་ལུ་ལག་ལེན་འཐབ། ཨེཆ་ཀྲི་ཀྲི་པི་ གི་ནང་བསྐྱོད་ཀྱི་ཤོག་གུ་གུར་མཐུད་ལམ་འབད་ནི། ནང་བསྐྱོད་མཐའ་བཙན་བཟོ་ནི་བཀྲམ་ནི། དེ་ལས་ སྤྱིར་བཏང་མགྱོགས་ཚད་ཀྱི་དོན་ལུ་ སྤྱིར་བཏང་ཨེཆ་ཀྲི་ཀྲི་པི་ ཡུའོ་ཨར་ཨེལ་རྒྱབ་ལོག་ལྟ་ནིའི་དོན་ལུ། དྲནམ་བཏོན། དེ་གཞི་སྒྲིགས་་ དགོས་མཁོ་ཡོད་མི་ ཨེཆ་ཀྲི་ཀྲི་པི་དེ་ དམིགས་བསལ་གྱི་ཝེབ་སར་བར་ལུ་ལྕོགས་ཅན་བཟོ་དགོ།';
$string['configloglifetime'] = 'ལག་ལེན་པའི་ སྦྱོང་ལཱའི་སྐོར་ལས་དུས་ཚོད་རིང་འཐུང་འདི་ ཁྱོད་ཀྱི་དྲན་དེབ་ནང་བཞག། དྲན་དེབ་ཚུ་ དེ་ལས་རྙིངམ་ཨིནམ་ལས་ རང་བཞིན་གྱི་བཏོན་གཏང་ཡོདཔ་ཨིན། དྲན་དེབ་ནང་བཞག་ནི་འདི་ག་དེ་མགྱོགས་མགྱོགས་འབད་ནི་འདི་ལེགས་ཤོམ་ཨིན། ག་དེམ་ཅིག་ ཁྱོད་ལུ་ཁོང་དགོ་པ་ཅིན་ དེ་འབདཝ་ད་ལུ་ ཁྱོད་ལུ་ ཡོད་པའི་སར་བར་གནམ་མེད་ས་མེད་ཁོམ་མེད་ དང་ཉམས་མྱོང་གི་ལཱ་ལུ་ཤུགས་ དཀའ་ངལ་པ་ཅིན། དེ་ལས་ཁྱོད་ཀྱི་ དྲན་དེབ་དམའ་མི་དེ་ མི་ཚེ་ཅིག་དགོ་ནི་ཡང་འོང་། གནས་གོང་ ༣༠ ལས་དམའ་མི་ཚུ་ འོས་སྦྱོར་འབད་ཡོདཔ་ཨིན་ ག་ཅི་འབད་ཟེར་བ་ཅིན་ ཚད་རྩིས་གི་ལཱ་གཏན་གཏན་མ་འགྱོ་འོང།';
$string['configlookahead'] = 'ཉིནམ་ཚུ་ གདོང་ཕྱོགས་ལུ་ལྟ།';
$string['configmaxbytes'] = 'ཡིག་སྣོད་ས་ཁོངས་ཆ་མཉམ་ནང་ སྐྱེལ་བཙུགས་འབད་ཡོདཔ་དང་ཚད་སྦོམ་ཤོས་ གསལ་བཀོད་འབད་ནི་དང་ གཞི་སྒྲིག་འདི་ པི་ཨེཆ་པི་གི་ཚད་འབད་བཞག་ཡོད་པའི་ གཞི་སྒྲིག་གནས་བསྐྱོད་ཆེ་བའི་ཚད་ དང་སྐྱེལ་བཙུགས་ཆེ་བའི་ཡིག་སྣོད་ཚད་ དེ་དང་གཅིག་ཁར་ཨེཔེཆ་ གཞི་སྒྲིག་ ཚད་ཀྱི་གཞུང་ཞུ་བ་འབད་ཡོད་མི་དེ་ སྐོར་ཐེངས་ནང་ མེགས་བགདྲིས་ རིང་འཐུང་གི་ཚད་འདི་ སློབ་ཚན་དང་མེ་དྲིལ་གྱི་གནས་ཚད་ གདམ་ཁ་རྐྱབ༌ཚུགས། གལ༌སྲིད༌སར༌བར༌གྱི༌ཚད༌འདི༌གདམ༌ཁ༌རྐྱབ༌པ༌ཅིན༌སར༌བར༌དེ༌གི༌མཐོ༌ཤོས༌སར༌བར༌གིས༌ལག༌ལེན༌འཐབ༌ནི༌ཆོགཔ༌ཨིན།';
$string['configmaxconsecutiveidentchars'] = 'ཆོག་ཡིག་ལུ་གཅིག་གིས་ཤུལ་ད་གཅིག་ཅོག་ར་ཐདཔ་སྦེ་ཨང་ཡིག་ཚུ་མ་པ་ལས་འོང་ནི་མི་འོང་། ༠ ལག་ལེན་འཐབ་བཞིནམ་ད་ལྕོགས་མེད་བཟོ་དགོ།';
$string['configmaxeditingtime'] = 'རྩིས༌ཐོ༌གི༌དུས༌ཚོད གསལ་བཀོད་འབད་དེ་ མི་དེ་ཚུ་ལུ་ གནས་བསྐྱོད་གྲོས་གནས་ལུ་ ལོག་ཞུནདག་རྐྱབ༌ནི། ཚིག་ཐོ་བསམ་བཀོད་ལ་སོགས་པ། སྤྱིརབཏང་སྐར་མ་ ༣༠ འདི་གནས་གོང་ལེགས་ཤོམ་ཨིན།';
$string['configmaxevents'] = 'བྱུང་ལས་ཚུ་ མགོ་ལུ་ལྟ།';
$string['configmaxusersperpage'] = 'སློབ་ཚན་ནང་ ལག་ལེན་གདམ་འཐུ་ནང་འཁོད་ ལག་ལེན་པ་ཐོ་ཤོས་ གསལ་སྟོན་འབད་ཡོད་མི།';
$string['configmessaging'] = 'ས་ཁོངས་ཀྱི་ལག་ལེན་པ་དང་འཕྲིན་གཏོང་རིམ་ལུགས་ གཉིས་ལྕོགས་ཅན་བཟོ་དགོཔ་ཨིན་ན?';
$string['configmessagingallowemailoverride'] = 'ལག་ལེན་པ་ཚུ་ལུ་ གློག་འཕྲིན ་འཕྲིན་ཡིག་གི་ཁྱབ་བསྒྲགས་ཁོང་རའི་གསལ་སྡུད་ནང་ཡོད་པའི་གློག་འཕྲིན་ནང་ལུ་མིན་པ་གློག་འཕྲིན་གཞན་ནང་ལུ་ཡང་གཏང་ཅུགས།';
$string['configmessagingdeletereadnotificationsdelay'] = 'ས་སྒོ་མངམ་བཞག་ནི་གི་དོན་ལྷག་ཚར་བའི་ཁྱབ་བསྒྲགས་ཚུ་བཏོན་གཏང་། ཁྱབ་བསྒྲགས་འདི་ལྷག་སྟེ་དུས་ཡུན་ག་དེམ་ཅིག་ལས་བཏོན་གཏང་ཚུགས?';
$string['configmessaginghidereadnotifications'] = 'གློག་འཕྲིན་གྱི་ལོ་རྒྱུས་ཚུ་ལྟ་བའི་སྐབས་སུ་ ལྷག་ཚར་བའི་ཁྱབ་བསྒྲགས་ དཔེར་ན་ གྲོས་བསྡུར་དང་དུས་སྟོན་གྱི་སྐོར་བཟུམ་ཚུ་སྦ་བཞག།';
$string['configminpassworddigits'] = 'ཆོག་ཡིག་འདི་ལུ་ ཨང་ཡིག་ཉུང་ཤོས་རང་ མངམ་དེ་ཅིག་དགོཔ་ཨིན།';
$string['configminpasswordlength'] = 'ཆོག་ཡིག་འདི་ལུ་ཉུང་ཤོས་རང་ཡིག་འབྲུ་རིངམ་འདི་བཟུམ་ཅིག་དགོཔ་ཨིན།';
$string['configminpasswordlower'] = 'ཆོག་ཡིག་འདི་ལུ་ ཉུང་ཤོས་རང་ ཡིག་ཆུང་མགྱོགས་ཡིག་མངམ་དགོཔ་ཨིན།';
$string['configminpasswordnonalphanum'] = 'ཆོག་ཡིག་འདི་ལུ་ ཉོང་ཤོས་རང་ ཨལ་ཕ་ནུ་མི་རི་མིག་གི་ཡིག་འབྲུ་མེན་མི་དགོཔ་ཨིན།';
$string['configminpasswordupper'] = 'ཆོག་ཡིག་འདི་ལུ་ ཉུང་ཤོས་རང་ ཡིག་སྦོམ་མགྱོགས་ཡིག་མངམ་དགོཔ་ཨིན།';
$string['configmobilecssurl'] = 'ཁྱོད་རའི་འགྲུལ་འཕྲིན་གྱི་ཡིག་སྣོད་ཚུ་ངོས་འདྲ་འབད་ནིའི་དོན་ལུ་གོ་སྐབས་བཟོ།';
$string['configmodchooserdefault'] = 'སྦྱོང་ལཱ་གདམ་ཁ་འབད་མི་ཚུ་རང་བཞིན་གྱིས་ལག་ལེན་པ་ཚུ་ལུ་སྟོད་དགོ་ག?';
$string['configmycoursesperpage'] = 'སློབ་ཚན་གྱངས་ཁ་མཐོ་ཤོས་ཚུ་ ལག་ལེན་པ་ཁོང་རའི་སློབ་ཚན་ནང་ གི་ཐོ་བཀོད་བཀྲམ་སྟོན་འབད།';
$string['configmymoodleredirect'] = 'གཞི་སྒྲིག་འདི་ ངེས་སྤྱོད་འབད་ སྐོར་ཏེ་ རང་གི་ནང་བསྐྱོད་ནང་ བདག་སྐྱོང་མིན་མི་དང་ མགོ་ས་ཁོངས་ཀྱི་འགྲུལ་བསྐྱོད་གཅིག་ཁ་ཀྱི་ཚབ་ཀྱི་དོན་ལུ';
$string['configmypagelocked'] = 'གཞི་སྒྲིག་འདི་གིས་ བདག་སྐྱོང་མིན་མི་ཚུ་གིས་སྔོན་འཐོན་ཤོག་ལེབ་ནང་ཞུན་དག་འབད་ནི་ལས་བཀག་ཚུགས།';
$string['confignavcourselimit'] = 'སློབ་ཚན་གྱི་གྱང་ཁ་འདི་ལག་ལེན་པ་ཚུ་ནང་བསྐྱོད་མེད་པ་དང་ ཡང་ན་ སློབ་ཚན་ནང་འཛུལ་ཞུགས་མ་འབད་མི་ཚུ་ཚད་བཟུང་སྟེ་སྟོན།';
$string['confignavshowallcourses'] = 'ལྕོགས་ཅན་བཟོ་བ་ཅིན་ ལག་ལེན་པ་ཚུ་གིས་ཁོང་རང་འཛུལ་ཞུགས་འབད་ཡོད་པའི་ རང་གི་སློབ་ཚན་ཡན་ལག་དང་སློབ་ཚན་བཀོད་རིས་ཚུ་ལྟ་ཚུགས། ལྕོགས་མེད་བཟོ་བའི་སྐབས་ ལག་ལེན་པ་ཚུ་གིས་རང་གི་སློབ་ཚན་ཡན་ལག་གི་འགུལ་བསྐྱོད་རྐྱངམ་ཅིག་མཐོང་། སློབ་ཚན་གྱི་གྱང་ཁ་འདི་ད་རུང་ སློབ་ཚན་ཚད་འཛིན་གྱིས་ ཚད་བཟུང་གཞི་སྒྲིག་དེ་གིས་ལག་ལེན་པ་ཚུ་ནང་མ་འབད་བའི་སཀབས་དང་ ཡང་ན་ སློབ་ཚན་ནང་འཛུལ་ཞུག་མ་འབད་ཅ་ཅིན། "Course limit(navcourselimit)"';
$string['confignavshowcategories'] = 'སློབ་ཚན་གྱི་དབྱེ་རིམ་ཚུ་འགུལ་བསྐྱོད་ཀྱི་ནར་ལེབ་དང་འགུལ་བསྐྱོད་ཀྱི་བཀག་ཆ་ནང་སྟོན། ཨ་ནི་འདི་ ལག་ལེན་པ་ད་ལྟོ་སློབ་ཚན་ནང་འཛུལ་ཞུགས་འབད་ཡོད་མི་ཚུ་གིས་མི་མཐོང་། ཁོང་ཚུ་ད་ལྟོ་རང་གི་སློབ་ཚན་ཟེར་བའི་ཐོ་ནང་ལུ་དབྱེ་རིམ་མེད་པར་འོང་།';
$string['confignotifyloginfailures'] = 'གལ་སྲིད་ནང་བསྐྱོད་འཐུས་ཤོར་ འབྱུང་ཡོད་མི་དེ་ ཐོ་བཀོད་ཡོདཔ་འབད་བ་ཅིན་ གློག་འཕྲིན་བརྡ བསྐུལ་ཕྱི་ཁར་ཁར་གཏང་བཏུབ། བརྡ་བསྐུལ་འདི་ག་གི་ལྟ དགོཔ་སྨོ?';
$string['confignotifyloginthreshold'] = 'གལ་སྲིད་ བརྡ་བསྐུལ་འདི་ ནང་བསྐྱོད་འཐུས་ཤོར་གྱི་སྐོར་ལས་ ཤུགས་ལྡན་འབད་བ་ཅིན་ ནང་བྶྐྱོད་འཐུས་ཤོར་འབྱུང་ཡོད་མི་ལུ་ ལག་ལེན་པ་གཅིག་གི་སྨོ་ ཡང་ན་ ཨའི་པི་ཁ་བྱང་གཅིག་གི་འབད་ དཔའ་བཅམ་འབད་འབདཝ་སྨོ་ འདི་བརྡ བསྐུལ་འབད་བའི་ནུས་ཚད་ཨིན་ན?';
$string['confignotloggedinroleid'] = 'ལག་ལེན་པ་དེ་ཚུ་ ས་ཁོངས་ནང་ནང་བསྐྱོད་མ་འབད་མི་དེ་ཚུ་ གི་ གལ་སྲིད་ཁོང་གི་ས་ཁོང་གི་སྐབས་ཐོབ་དང་འཁྲིལ་ ཁོང་ལུ་ལཱ་འགན་སྤྲོདཔ་བཟུམ་མའི་ རྩིས་ཁུངས་འབད་ཡོདཔ་ཨིན། མགྱོནམ་ཚུ་ དུས་ཨ་རྟག་རང་ ནང་ལུ་དགོཔ་སྨོ། དེ་འབདཝ་ད་ལུ་ ཁྱོད་ཀྱི་ ལཱ་འགན་ལུ་གསར་བསྐྲུན་འབད་ ནི་འདི་ བཀག་འདམ་འབདནང་ལུ་ མངམ་ཨིན་རུང་ཉུངམ་ཨིན་རུང་དགོཔ་འོང་། དེ་འབད་ལྟཝ་ད་ལུ་ འགྲེམ་བསྐྱེལ་གསར་བསྐྲུན་ ད་ཚུན་ ལག་ལེན་པའི་ནང་བསྐྱོད་ཚུལ་ལྡན་འབད་ནིའི་དགོས་མཁོ་ཡོདཔ་བཟུམ་འདུག།';
$string['configopentogoogle'] = 'གལ་སྲིད་ ཁྱོད་ཀྱི་གཞི་སྒྲིག་འདི་ལྕོགས་ཅན་བཟུ་བ་ཅིན་ དེ་ལས་ གུ་གུལ་ དེ་གི་ཁྱོད་རའི་ས་ཁོངས་ནང་ མགྱོནམ་བཟུམ་འབད་ བཙུགས་ཆོགཔ་ཨིན། དེ་ལུ་བསྡོམ་པ་ཅིན་ མི་ཚུ་ཁྱོད་ཀྱི་ས་ཁོངས་ནང་འོང་པའི་སྐབས་ ཝའི་ གུ་གུལ་གྱི་ རང་བཞིན་གྱི་འཚོལ་ ཞིབ་འབད་དེ་ མགྱོནམ་བཟུམ་འབད་ ནང་བསྐྱོད་འབདཝ་ཨིན། སློབ་ཚན་ཚུ་ནང་འཛུལ་བསྐྱོད་འབད་ནི་དེ་ དྭངས་གསལ་གྱི་ཐོག་ལས་ རྐྱངམ༌ཅིག༌བྱིནམ༌ཨིན༌དེ༌མགྱོནམ༌རྐྱངམ༌ཅིག༌ལུ༌འཛུལ༌བསྐྱོད༌འབད༌ཆོགཔ༌འབད༌ཨིན།';
$string['configoverride'] = 'ཀོན༌ཕིག༌དྲོད༌པི༌ཨེཆ༌པི༌ནང༌ངེས༌འཛིན༌འབདཝ༌ཨིན།';
$string['configpasswordpolicy'] = 'སྐོར༌ཐེངས༌དེ༌གི༌མུ༌དྲིལ༌ལག༌ལེན༌པའི༌ཆོག༌ཡིག༌ཞིབ༌དཔྱད༌འབད༌ནི༌དང༌ཆ༌འཇོག༌ཡོད༌པའི༌ཆོག༌ཡིག༌སྲིད༌བྱུས། འོག༌ལུ༌ཡོད༌པའི༌གཞི༌སྒྲིག༌ལག༌ལེན༌འཐབ༌སྟེ༌སྲིད༌བྱུས༌གསལ༌བཀོད༌འབད༌དེ༌ལག༌ལེན༌འཐབ༌ནི༌ཨིན། (གལ༌སྲིད༌ཁྱོད༌ཀྱི༌གཞི༌སྒྲིག༌ལུ༌མེན༌ཟེར༌བ༌ཅིན༌ཁོང༌གི༌སྣང༌མེད༌འབད༌བཞགཔ༌ཨིན༌)';
$string['configpasswordresettime'] = 'མི་ཚུ་གིས་ ཆོག་ཡིག་སླར་བཅོས་གསོལ་འདེབས་འདི་ཆ་གནས་མ་རྫོགས་ཚུན་ ཚར་ག་དེམ་ཅིག་ཆ་འཇོག་འབད་དགོཔ་ཨིན་ན་འདི་གིས་སྟོནམ་ཨིན། ནམ་རྒྱུན་འབད་བ་ཅིན་ སྐར་མ་ ༣༠ དེ་དུས་ཚབ་ཚུལ་མཐུནམ་ཅིག་ཨིན།';
$string['configpathtoclam'] = 'པཱད༌ཀྲུ༌ཀཱའམ༌ཨེ༌བི།ཡང༌ན༌དེ༌བཟུམ༌འབད༌/usr/bin/clamscan or /usr/bin/clamdscan.ཁྱོད༌བཀོད༌རྒྱ༌དང༌འཁྲིལ༌ཀཱམ༌ ཨེ༌བི༌གི༌དོན༌ལུ༌གཡོག༌བཀོལཝ༌ཨིན།';
$string['configpathtodu'] = 'པཱདྲ༌ཀྲུ༌དྲུ།ཡང༌ན༌དེ༌བཟུམ༌འབད༌/usr/bin/du.གལ༌སྲིད༌ཁྱོད༌ཀྱི༌བཙུགས༌པ༌ཅིན༌ཤོག༌གུ༌དེ༌ཚུ༌གི༌ནང༌དོན༌འཕྲང༌སྟེ༌བཀྲམ༌སྟོན༌འབད༌ནི༌དང༌དེ༌གི༌ལཱ༌གཡོག༌མགྱོགས༌དྲག༌འབད༌ཡིག༌སྣོད༌ཚུ༌གི༌དོན༌ལུ༌འབད༌གནས༌ཐོ༌བཀོད༌དགོ།';
$string['configperfdebug'] = 'གལ༌སྲིད༌ཁྱོད༌ཀྱི༌སྐོར༌ཐེངས༌འདི༌ལུ༌ལྟ༌བ༌ཅིན༌ གོ་དོན་ལཱ་ཤུགས་དེ་གི་ གནས་ཚད་ཀྱི་ཕུཀྲུར་ གི་བརྗོད་དོན། པར་བཏབ་ཡོདཔ་ཨིན།';
$string['configprofileroles'] = 'ལག་ལེན་པའི་གསལ་སྡུད་དང་བཅའ་མར་གཏོགས་མི་གི་ཤོག་ལེབ་ནང་ལུ་མཐོང་ཚུགས་པའི་ལས་འགན་གྱི་ཐོ།';
$string['configprofilesforenrolledusersonly'] = 'ཨིས་པ་མར་གྱི་འབད་སྔོན་བཀག་ལག་ལེན་འགལ་བ་འབད་ནི་དང་ སློབ་ཚན་ག་ཅི་ན་ཡང་སྦ་ཡོད་པའི་ནང་ མིང་ཐོ་མ་བཀོད་པར་ཡོད་པའི་ ལག་ལེན་པ་ཚུ་གསལ་བསྡུད་རྒྱས་བཤད་འབད་ནི་ཨིནམ་དང། ཁོང་གི་གསལ་སྡུད་རྒྱས་བཤད་མ་བསྡོམ་པའི་ཧེན་མ་ ལག་ལེན་པ་གསརཔ་ཚུ་ གི་ཉུང་ཤོས་རང་ སློབ་ཚན་གཅིག་ནང་ མིང་ཐོ་བཀོད་དགོཔ་ཨིན།';
$string['configprotectusernames'] = 'རིམ་སྒྲིག་བརྗེད་མི་དེ་གི་ ཆོག་ཡིག་ .forget_password.php དེ་གིས་ལག་ལེན་པའི་མིང་དང་ གློག་འཕྲིན་པའི་ཁ་བྱང་གི་ཕོག་ཚོད་ལམ་སྟོན་རང་་གསལ་སྟོན་མི་འབད།';
$string['configproxybypass'] = 'ལྷོད་རྟགས་ཀྱིས་སོ་སོ་འཕྱེ་ཡོད་པའི་(partial) hostnames or IPs དེ་བཀོག་སྟེ་proxy (e.g., 192.168., .mydomain.com)';
$string['configproxyhost'] = 'གལ་སྲིད་ག་དེམ་ཅིག་འབད་<b>server</b>གློག་རིག་ པོརོག་སི་ལག་ལེན་འཐབ་དགོཔ་ཅིན་( དཔེར་ན་སྐྱོབ་གྱང་) གློག་རིང་ཡོངས་འབྲེལ་ལུ་འཛུལ་བསྐྱོད་འབད་བ་ཅིན་ དེ་ལས་འདི་ཁར་ལུ་ ཧོསདྲ་མིང་བྱིན་ནི་ དེ་མིན་པ་ཅིན་ སྟོངམ་བཞག་ད།';
$string['configproxypassword'] = 'གལ་སྲིད་ག་དེམ་ཅིག་འབད་གློག་རིག་ཡོངས་འབྲེལ་གྱི་འཛུལ་བསྐྱོད་འབད་ནིའི་ཆོག་ཡིག་ པོརོསི་གི་ཐོག་ལས་ དགོ་པ་ཅིན། གལ་སྲིད་མེད་པ་ཅིན་ སྟོངམ་ (པི་ཨེཆ་པི་སི་ཡུ་ཨར་ཨེལ་ རྒྱ་བསྐྱེད་དགོས་མཁོ་ཡོདཔ)';
$string['configproxyport'] = 'གལ་སྲིད་སར་བར་ལུ་པོརོ་གསི་གློག་རིག་ལག་ལེན་འཐབ་དགོ་པ་ཅིན་ འདི་ལུ་པོརོག་སི་འདྲེན་ལམ་བྱིན་དགོཔ་ཡོད།';
$string['configproxytype'] = 'ཝེབ་པོརོགསི་གི་དབྱེ་བ། (པི་ཨེཆ་པི་ ཕའིཡབ་ དང་རྒྱ་བསྐྱེད་དགོས་མཁོ་ སོགས་སོ་ཕའིཡབ་ཀྱི་དོན་ལུ་ རྒྱབ་སྐྱོར)';
$string['configproxyuser'] = 'ལག་ལེན་པའི་མིང་ཚུ་ གློག་རིང་ཡོངས་འབྲེལ་ནང་ པོརོག་སི་གི་ཐོག་ལས་ འཛུལ་བསྐྱོད་འབད་ནི་ཨིན་པ་ཅིན་ གལ་སྲིད་མེད་པ་ཅིན་ སྟོངམ་། (པི་ཨེཆ་པི་སི་ཡུ་ཨར་ཨེལ་ རྒྱ་བསྐྱེད་དགོས་མཁོ་ཡོདཔ)';
$string['configquarantinedir'] = 'གལ་སྲིད་ཁྱོད་ཀྱི་ཀའམ་ ཨེ་བི་ ལས་གནོད་པ་ཡོད་པའི་ཡིག་སྣོད་ གི་ ཟུར་རྟགས་ཀྱི་སྣོད་དེབའགྱོ་བ་ཅིན། དེ་ཁར་བཙུགས་ དེ་གི་ཝེབ་སར་བར་གྱི་འབྲི་ཚུགསཔ་འབད་དགོཔ་ཨིན། གལ་སྲིད་ཁྱོད་ཀྱི་སྟོངམ་བཞག་པ་ཅིན་ ཡང་ན་གལ་སྲིད་ མེད་པའི་ཡངན་འབྲི་མ་ཚུགསམི་ཅིག། ཁྱོད་ཀྱི་སྣོད་དེབ་ནང་བཙུགས་པ་ཅིན། གནོད་པ་ཡོད་པའི་ཡིག་སྣོད་ཚུ་གིས་མེདཔ་གཏང་ཡོདཔ་ཨིན། ཨིས་ལེཤ་རྗེས་ཤུལ་བཙུགས་མི་དེ་ གཅིག་ཁར་མ་བཙུགས།';
$string['configrecaptchaprivatekey'] = 'ཡིག་འབྲུ་ཚུ་གི་ཡིག་རྒྱུན་འདི་ སར་བར་གྱི་མུ་དྲིལ་དང་ རི་ཀེབ་ཅ་དྲོད་ནེདྲ་སར་བར་གཉིས་ཀྱི་བར་ན་ བརྡ་དོན་རྒྱུན་འབྲེལ་ ལག་ལེན་འཐབ་ནི།http://recaptcha.net ས་ཁོངས་འདི་ནང་གཅིག་ཐོབ་ནིའི་དོན་ལུ་དེ་ནང་ལུ་ལྟ་ད།';
$string['configrecaptchapublickey'] = 'ཡིག་འབྲུ་ཚུ་གི་ཡིག་རྒྱུན་འདི་ མིང་རྟགས་བཀོད་ཡོད་པའི་རྣམ་པ་ནང་རི་ཀེཔ་ཅ་རྒྱུ་རྫས་ བཀྲམ་སྟོན་འབདཝ་ཨིན། http://recaptcha.netདེ་གི་བཟོ་སྟོན་འབད་ཡོདཔ་ཨིན།';
$string['configrequestcategoryselection'] = 'སློབ་ཚན་ནང་འཛུལ་ཞུགས་ཀྱི་ཞུ་བ་ཕུལ་བའི་སྐབས་དབྱེ་རིམས་གདམ་ཁ་བརྐྱབ་བཅུག།';
$string['configrequestedstudentname'] = 'སློབ་ཚན་ནང་ཞུ་བ་འབད་ཡོད་པའི་ནང་ སློབ་ཕྲུག་ཚུ་གི་དོན་ལུ་ཚིག་ཡིག་ལག་ལེན་འཐབ་ཡོདཔ།';
$string['configrequestedstudentsname'] = 'སློབ་ཚན་ནང་ཞུ་བ་འབད་ཡོད་པའི་ནང་ སློབ་ཕྲུག་ཚུ་གི་དོན་ལུ་ཚིག་ཡིག་ལག་ལེན་འཐབ་ཡོདཔ།';
$string['configrequestedteachername'] = 'སློབ་ཚན་ནང་ཞུ་བ་འབད་ཡོད་པའི་ནང་ སློབ་དཔོན་ ཚུ་གི་དོན་ལུ་ཚིག་ཡིག་ལག་ལེན་འཐབ་ཡོདཔ།';
$string['configrequestedteachersname'] = 'སློབ་ཚན་ནང་ཞུ་བ་འབད་ཡོད་པའི་ནང་ སློབ་དཔོན་ཚུ་གི་དོན་ལུ་ཚིག་ཡིག་ལག་ལེན་འཐབ་ཡོདཔ།';
$string['configrequiremodintro'] = 'གལ་སྲིད་ཁྱོད་ཀྱིས་ལག་ལེན་པ་ཚུ་སྦྱོང་ལཱ་རེ་རེ་བཞིན་དུ་གི་འགྲེལ་བཤད་ནང་བང་བཙོང་སྟེ་བཙུགས་ནིའི་མིན་པ་ཅིན་དམ་ཁ་དེ་ལྕོགས་མིན་བཟོ།';
$string['configrunclamavonupload'] = 'ནམ་ལྕོགས་ཅན་བཟོ་ཡོདཔ་ ཀཱའམ་ཨ་བི་ དེ་གི་སྐྱེལ་བཙུགས་འབད་ཡོད་པའི་ཡིག་སྣོད་གེ་ར་ ཞིབ་ལྟ ལག་ལེན་འཐབ་དགོ།';
$string['configrunclamonupload'] = 'ལཱ་བཀོལ་བའི་ཀཱའམ་ཨེ་བི་ ཡིག་སྣོད་སྐྱེལ་བཙུགས་འབད་ཡོདཔ་ཨི་ན? ཁྱོད་ཀྱི་པའདྲ་ཀྲུ་ཀཱམ་ ནང་ལཱ་འབད་ནིའི་དོན་ལུ་ བཅོས་ཁ་རྐྱབ་དགོཔ་ཨིན། (ཀཱའམ་ཨེ་བི་འདི་ བར་སྟོང་གནོད་ཆེན་ འབད་མི་ཁྱོད་ཀྱི་ འདི་ཁ་ལས་ཐོབ་ཚུགས་http://www.clamav.net/)';
$string['configsectioninterface'] = 'ངོས་འདྲ་བ།';
$string['configsectionmail'] = 'ཡིག་འཕྲིན།';
$string['configsectionmaintenance'] = 'རྒྱུན་སྐྱོང་།';
$string['configsectionmisc'] = 'སྣ་ཚོགས';
$string['configsectionoperatingsystem'] = 'བཀོལ་སྤྱོད་རིམ་ལུགས།';
$string['configsectionpermissions'] = 'གནང་བ་ཚུ།';
$string['configsectionrequestedcourse'] = 'སློབ་ཚན་ ཞུ་བ་འབད་མི་ཚུ།';
$string['configsectionsecurity'] = 'སྲུང་སྐྱོབ།';
$string['configsectionstats'] = 'ཚད་རྩིས།';
$string['configsectionuser'] = 'ལག་ལེན་པ།';
$string['configsecureforms'] = 'ཝེབ་ཕོམ་ལས་ ཡོད་པའི་གནས་སྡུད་ཆ་འཇོག་འབད་བའི་བསྒང་ མུ་དྲིལ་དེ་གི་ ཉེན་སྲུང་གི་སྡེ་རིམ་བསྡོམ་རྩིས་འབད་ཚུགས། གལ་སྲིད་འདི་ལྕོགས་ཅན་འབད་ཚུགས་པ་ཅིན་ དེ་ལས་ བརའུ་ཟར་ གྱི་ཨེཆ་ཀྲི་ཀྲི་པི་ རི་ཕི་རེར་ འགྱུར་བ་འབད་ཚུགས་མི་དེ་ རྒྱབ་འགལ་འཕྲལ་གྱི་ཁ་བྱང་རྣམ་པ་འདི་ ཞིབ་དཔྱད་འབད་ཡོདཔ་ཨིན། གནད་དོན་ཆུང་ཀུ་ཅིག་ནང་འབད་བ་ཅིན་ དེ་གི་ དཀའ་ངལ་རྒྱུ་འདི་ གལ་སྲིད་ལག་ལེན་པའི་སྐྱོབ་གྱང་ལག་ལེན་འཐབ་པ་ཅིན་ (དཔེར་ན་ཛོ་ནས་ལམ)ཁོ་རའི་ཝེབ་འགྲུལ་ལམ་ ལས་གྱི་ཨེཆ་ཀྲི་ཀྲི་པི་ རི་ཕི་རེར་ རིམ་སྒྲིག་ལས་བཤུབ་ནི། ནད་བརྟག་ཚུ་ ཐོབ་ནི་ལུ་ རྣམ་པ་བཙུག་ནི། གལ་སྲིད་ལག་ལེན་པ་ཚུ་དཀའ་ངལ་འབྱུངམ་དང་གཅིག་ཁར་ ཤོག་གྲངས་ནང་བསྐྱོད་འབད་བ་ཅིན་ (དཔེར་ན)འདི་གཞི་སྒྲིག་འདི་ལྕོགས་ཅན་བཟོ་ནིའི་མནོ་བསམ་ཡོདཔ་འོང་། ས་ཁོངས་ནང་བུརུཀྲུ་ཕོརོསོ་ ཆོག་ཡིག་ དབང་གནོན་འབད་ནི་དགོ་འདོད་ཡོདཔ་འོང་། གལ་སྲིད་ དོགས་པ་ནང་ཡོད་པ་ཅིན་ འདི་སྒྲིག་ནི་ལུ་བཀོག་བཞག། བཏུབ།';
$string['configsessioncookie'] = 'མུ་དྲིལ་ གཡི་ལའ་ཡུན་གྱི་དོན་ལུ་ ཀུ་ཀིས་མིང་གི་ལག་ལེན་འཐབ་ནི་འདི་ གཞི་སྒྲིག་འདི་ སྲོལ་སྒྲིག་འབད། འདི་གདམ་ཁ་ཅན་ཅིག་ཨིན། ལག་ལེན་འཐབ་དགོཔ་འདི་ ཀུ་ཀིས་འདི་མགོ་རྨོངས་ཏེ་ཡོདཔ་ལས་ ཟུར་བཞག་དགོ་ ཝེབ་ས་ཁོངས་ནང་འཁོད་ནང་ མུ་དྲིལ་གྱི་འདྲ་གཅིགཔོ་འདི་ ལཱ་བཀོལཝ་ཨིན།';
$string['configsessioncookiedomain'] = 'དྲོ་མེན་འདི་བསྒྱུར་བཅོས་འབད་ཆོགཔ་མ་ཚད་ མུ་དྲིལ་ཀུ་ཀིས་ ཚུ་དེ་ཁར་ལས་ འཐོབ་ཆོག་ཆོག་ཡོདཔ་ཨིན། མུ་དྲིལ་ ལག་ལེན་འཐབ་ནི་གི་དོན་ལུ་ སྲོལ་སྒྲིག་འབདཝ་ཨིན། (དཔེར་ ན་བདེན་བཤད་ཡང་ན་ནང་བསྐྱོད་མིང་ཐོ་བཀོད་ནི)ཝེབ་གློག་རིམ་ དང་གཅིག་ཁར་ གློག་རིམ་ལུ་ གཞན་མི་སབ་དོ་མེན་ལུ་མུ་དྲིལ་བརྡ་དོན་དུས་ཡུན་རུབ་སྤྱོད་འབད་ནི། <strong>ཉེན་བརྡ། དེ་ལུ་འོས་སྦྱོར་སྦོམ་འབད་ཡོདཔ་ཨིན་ རིམ་སྒྲིག་ལུ་གཞི་སྒྲིག་བཞག་ཡོད་པ་ཅིན་ (སྟོངམ)གནས་གོང་ནོར་བཅོས་མ་འབད་མི་དེ་གི་ ས་ཁོངས་ཚུ་གི་ ནང་བསྐྱོད་གེ་ར་ སྔོན་བཀག་འབད་ནི།';
$string['configsessioncookiepath'] = 'གལ་སྲིད་ཁྱོད་ཀྱི་ བརའུ་ཟར་ དེ་བསྒྱུར་བཅོས་འབད་དེ་ མུ་དྲིལ་ཀུ་ཀིས་གཏང་པ་ཅིན། ཁཡོད་ཀྱི་གཞི་སྒྲིག་འདི་ བསྒྱུར་བཅོས་འབད་དེ་ས་ཁོངས་ཀྱི་ཡན་ལག་ཁ་བྱང་འདི་ གསལ་བཀོད་འབད། དེ་མིན་པ་ཅིན་ རིམ་སྒྲིག་འདི་ ལེགས་ཤོམ་ཨིན།';
$string['configsessiontimeout'] = 'གལ་སྲིད་མི་དེ་གི་ ས་ཁོངས་ཀྱི་ འདི་གི་ནང་བསྐྱོད་འབད་ཡོད་མི་ཚུ་ དུས་ཡུན་རིངམ་ལས་མེད་ཀྱི་དོན་ལུ་ (ཤོག་གྲངས་མངོན་གསལ་མ་འབད་བར)དེ་ལས་ རང་བཞིན་གྱི་ཕྱི་བསྐྱོད་འབད་ནི་དང་(ཁོང་གི་དུས་ཡུན་འདི་རྫོགས་ཡོད)འགྱུར་བཅོས་གསལ་བཀོད་འདི་ དུས་ཚོད་རིངམ་ག་དེ་ཅིག་གཏང་དགོཔ་འདུག།';
$string['configshowcommentscount'] = 'བསམ་བཀོད་འབད་ཡོད་པའི་གྱང་ཁ་སྟོན། ཨ་ནི་གིས་བསམ་བཀོད་ཀྱི་རྒྱུན་མཐུད་གསལ་སྟོན་འབད་བའི་སྐབས་དྲི་བ་ཧེང་བཀལ་ཅིག་འོང་།';
$string['configshowicalsource'] = 'iCal བྱ་སྒོ་གི་དོན་ལུ་ བརྡ་དོན་འབྱུང་ཁུངས་སྟོན།';
$string['configshowsiteparticipantslist'] = 'ས་ཁོངས་དེ་ཚུ་གི་སློབ་ཕྲུག་དང་ས་ཁོངས་སློབ་ཕྲུག་ཚུ་གི་ ས་ཁོངས་ནང་ཐོ་བཀོད་འབད་ཡོད་པའི་བཅའ་མར་གཏོགས་མི་ཐོ། ས་ཁོངས་ནང་བཅའ་མར་གཏོགས་མི་དེ་ག་གི་ལྟ ཆོགཔ་སྨོ།';
$string['configsitedefaultlicense'] = 'སྔ་སྒྲིག་ཆོག་ཐམ་གྱི་ས་སྒོ།';
$string['configsitedefaultlicensehelp'] = 'དཀར་ཆག་དཔེ་བསྐྲུན་འབད་ནི་སྔ་སྒྲིག་ཆོག་ཐམ་གྱི་ས་སྒོ།';
$string['configsitemaxcategorydepth'] = 'དབྱེ་རིམ་ཏིང་ཚད་མཐོ་ཤོས་ །';
$string['configsitemaxcategorydepthhelp'] = 'ཨ ནི་འདི་གིས་ ཨ ལོའི་གོ་བའི་་དབྱེ་་ཐོ་ཤོས་ གསལ་སྟོན་དབྱེ་ཁ་དང་ combo list༼སྡེབ་སྒྲིག་སྒྲོམ་བུ༽ ནང་གི་བཅུད་དོན་ངེས་འགྲེལ་འབདཝ་ཨིན། གཏིང་ཟབ་གནས་རིམ་གྱི་དབྱེ་ཁ་ཚུ་ འབྲེལ་མཐུན་སྦེ་དངོས་མཐོང་འབད་ཚུགས་ནི་དང་ ལག་ལེན་པ་དེ་གིས་ AJAX ཐོག་རྒྱ་སྐྱེད་འབད་ཚུགས།';
$string['configslasharguments'] = 'ཡིག་སྣོད་ཚུ་ ༼པར་ཚུ་ སྐྱེལ་བཙུགས་འབད་ཡོད་མི་ཚུ་ ལ་སོགས་པ༽དེ་ཚུ་ གཡོ་ཤད་འཐབ་རྩོད་ དེ་ཡི་གུ་ལག་ལེན་འཐབ་ནི་དེ་རྒྱུད་དེ་བྱིན་ཡོདཔ་ཨིན། ཐབས་དེ་གི་ཡིག་སྣོད་ཚུ་འདྲ་མཛོད་ནང་འཇམ་ཏོང་ཏོ་འབད་ ཝེབ་བརའུ་ཟར་ནང་ འབད་ཚུགས་ནི། པོརོཀསི་ སར་བར་ ལ་སོགས་པ། ཁ་རྗེ་མེད་པར་ པི་ཨེཆ་པི་སར་བར་ཚུ་གི་ ཐབས་ཤེས་ལག་ལེན་འཐབ་མ་ཆོགཔ་ཨིན། སྟེ་གལ་སྲིད་ཁྱོད་ལུ་ཡོད་པའི་ དཀའ་ངལ་མཐོང་སྣང་འདི་ ཡིག་སྣོད་འབད་རུང་པར་ཚུ་ སྐྱེལ་བཙུགས་འབད་ཡོདཔ་ཨིན། ༼དཔེར་ན་ལག་ལེན་པའི་པར་ཚུ༽ གཞི་སྒྲིག་འདི་ལྕོགས་ཅན་བཟོ་དགོ།';
$string['configsmartpix'] = 'འདི་དང་གཅིག་ཁར་ལུ་ ངོས་པར་དེ་ཚུ་ པི་ཨེཆ་པི་ཡིག་ཚུགས་གི་ཐོག་ལས་ བྱིན་ཏེ་ འཕྲལ་གྱི་བརྗོད་དོན་འཚོལ་ དགོ། དེ་ལས་ རྩ་ལག་བརྗོད་དོན་གེ་ར་ དེ་ལས་མུ་དྲིལ་ པིགསི་་སྣོད་འཛིན། པར་གྱི་ཡིག་སྣོད་ནང་འཁོད་ནང་ རྫུན་མ་དེ་ཚུ་མར་ཕབ་འབད་དགོ། དེ་འབདཝ་ད་ལུ་ ལཱ་ཤུགས་དུམ་དྲག་ཅིག་གླ་ཡོད།';
$string['configstartwday'] = 'མགོ་བཙུགས་ནིའི་ བདུན་ཕྲག་';
$string['configstatsfirstrun'] = 'ག་དེ་ཅིག་ཚུན་ཚོད་ གསལ་བབཀོད་འབད་ཡོད་པའི་དྲན་དེབ་ཚུ་ ལས་སྦྱོར་ནང་བཙུགས་དགོ། <b>the first time</b> ཚད་རྩིས་ལས་སྦྱོར་ལུ་ཀོརོན་ཇོབ་ དགོཔ་འབད་བཞག་ཡོད། གལ་སྲིད་ཁྱོད་ལུ་ རྒྱུན་འབྲེལ་ལེ་ཤ་ཡོད་མི་དེ་ཚུ་ རྩ་བའི་སྒོ་ལས་ རུབ་སྤྱོད་འབད་བ་ཅིན། ཧེན་མ་ལས་ལྟ བ་ཅིན་ དེ་ཚུ་ ཡང་ན་གནས་སྐབས་ལེགས་ཤོམ་མེདཔ་ཨིན་པས།ཧ་ལམ་འཐོན་ཁུངས་ཤུགས་ཆེ་དྲག་འབད་འཐོན་ནི་ལུ་ ལཱ་ལུ་དུས་ཡུན་ལེ་ཤ་འགོར་དོ་བཟུམ་འབད་འབྱུང་ཡི། (གཞི་སྒྲིག་འབད་ནི་ལུ་ དྲན་འཛིན་བཀོད་ ཟླཝ་ ༡ ཉིནམ་ ༢༨། ཚད་ཁྲམ་ཚུ་དང་ བཟོ་བཏོན་འབད་ ནིའི་སྙན་ ཞུ་ ཟླཝ་ ༡ ཟླ་ཐོ་ ༡ གི་ཟླཝ།)';
$string['configstatsmaxruntime'] = 'ཨིས་ཀྲེད་སི་ ལས་སྦྱོར་འབད་མི་དེ་གི་ ཧ་ལམ་ཤུགས་ཅན་འབད་ཡོདཔ་ཨིན། སྟེ་དེ་གི་ལཱ་བཀོལ་ནི་དང་ག་དེ་ཅིག་འགོརཝ་ཨི་ན་གི་དོན་ལུ་འབད་བའི་བསྒང་ ས་སྒོ་མཉམ་སྦྱོར་འབད་ལག་ལེན་འཐབ་ནི་དང་ ཤུལ་མམ་འདི་ གསལ་བཀོད་འབད།';
$string['configstatsmaxruntime2'] = 'ཨིས་ཀྲེད་སི་ ལས་སྦྱོར་འབད་མི་དེ་གི་ ཧ་ལམ་ཤུགས་ཅན་འབད་ཡོདཔ་ཨིན། ཉིནམ་གཅིག་གི་ཚད་རྩིས་ཚོགས་ནི་ དུས་ཚོད་ མཐོ་ཤོས་འབད་ཆོག་པའི་གསལ་བཀོད་བྱིན་ཡོད།ལས་སྦྱོར་འབད་ནིའི་དོན་ལུ་ ཉིན་གྲངས་མཐོ་ཤོས་གཅིགཔ་འདི་ ཀོརོན་ལག་ལེན་འཐབ་ནི་ ༣༡།';
$string['configstatsmaxruntime3'] = 'ཉིནམ་གཅིག་གི་དོན་ལུ་ དུས་ཚོད་མཐོ་ཤོས་གསལ་བཀོད་འབད་ཡོད་པའི་ ཚད་རྩིས་རྩིས་སྟོན་ཆོགཔ་ཨིན། ཨིས་ཀྲེདྲས་ བཟོ་སྦྱོར་དེ་གི་སར་བར་ནང་ལུ་ མངོན་གསལ་སྦོམ་འབད་བཙུགས་ནི་ལུ་ སེམས་ཁར་བཟོད་དགོ། ཉིན་གྲངས་མཐོ་ཤོས་དེ་བཟོ་སྦྱོར་འབད་ཡོདཔ་ལས་ ཀོརོན་གཅིག་གི་ འོག་ལུ་གསལ་བཀོད་འབད་ཡོདཔ་ཨིན།';
$string['configstatsruntimedays'] = 'གསལ་བཀོད་འབད་ཡོད་པའི་ ཉིན་གྲངས་མཐོ་ཤོས་ དེ་གི་ བཟོ་སབཡོར་འབད་ཡོད་མི་དེ་ ཨིས་ཀྲིདྲ་རེ་རེ་གི་ ལག་ལེན་འཐབ་ཨིན། ཨིས་ཀྲིདྲས་དེ་ཚུ་ ཀྲིག་ཀྲིག་ཡོད་པའི་སྐབས་ ཉིནམ་གཅིག་རྐྱངམ་ཅིག་གི་ བཟོ་སྦྱོར་འབད་ཡོདཔ་ཨིན། དེ་ལས་ གནས་གོང་བདེ་སྒྲིག་འབད་ནི་དེ་ གཙོ་བོ་སར་བར་མངོན་གསལ་འབད་ནི་ལུ་་རག་ལེགསཔ་ཨིན། གལ་སྲིད་ཀོརོན་ལག་ལེན་འཐབ་ནི་དེ་ འཐུང་ཀུ་འབད་དགོ་པ་ཅིན་ མར་ཕབ་འབད་དགོ།';
$string['configstatsruntimestart'] = 'ཀོརོན་ཇོབ་དེ་གི་ དུས་ཚོད་ག་དེམ་ཅིག་ལུ་ ཨིས་ཀརིདྲས་ལཱ་འབད་ནི་དང་ ལག་ལེན་འཐབ་དགོཔ་སྨོ་ <b>start</b>?གལ་སྲིད་ག་དེམཅིག་འབད་ མུ་དྲིལ་སྣ་མང་དེ་དངོས་ཅན་སར་བར་གཅིག་ནང་ཡོད་པ་ཅིན་ དུས་ཚོད་སོ་སོ་ཚུ་ གསལ་བཀོད་མཛད་གནང་།';
$string['configstatsuserthreshold'] = 'གལ་སྲིད་ཁྱོད་ཀྱིས་ ཀླ་སྐོར་མེན་མི་བཙུག་པ་ཅིན་ ཨང་ཡིག་མེད་མི་ གནས་གོང་སློབ་ཚན་མཐོ་རིམ་གྱི་དོན་ལུ་ འདི་ཁར་བཀོད་དེ་ཡོད། སློབ་ཚན་དང་གཅིག་ཁར་ ཨང་གྲངས་འདི་ལས་ཉུངམ་འབད་ ཐོ་བཀོད་འབད་དེ་ ལག་ལེན་པའི་ སྣང་མེད་འབད་བཞག་དགོ། (ལཱ་འགན་གེ་ར)';
$string['configstrictformsrequired'] = 'ལྕོགས་ཅན་བཟོ་བ་ཅིན། ལག་ལེན་པ་ཚུ་ ས་སྟོང་ཡང་ན་དགོས་མཁོ་ཡོད་པའི་གྱལ་རིམ་འབྲི་ཤོག་ཚུ་ནང་རྐྱངམ་ཅིག་མ་གཏོགས་འཛུལ་མིན་དགོཔ་བཟོ་འོང་།';
$string['configstripalltitletags'] = 'ཨེཆ་ཀྲི་ཨེམ་ཨེལ་ ངོ་རྟགགས་འདི་ ཞིབ་དཔྱད་མ་འབད་བའི་ སྦྱོང་ལཱ་དང་ཐོན་ཁུངས་གི་མིང་ནང་གཞི་སྒྲིག་འབད་ཆོག།';
$string['configsupportemail'] = 'ཨི་མེལ་ཁ་བྱང་འདི་གི་ དཔེ་བསྐྲུན་འབད་དེ་ ས་ཁོངས་དེ་གི་ལག་ལེན་པ་ཚུ་ གོང་གི་ཨི་མེལ་བཟུམ་སྦེ་ སཔྱིལ་བཏང་ཁོང་ལུ་ ཆ་རོགས་དགོ་པའི་བསྒང་ལུ་ (དཔེར་ན་ ལག་ལེན་པའི་གསརཔ་་ཚུ་ ཁོང་རའི་རའི་རྩིས་ཐོ་གསར་བསྐྲུན་འབད་བའི་བསྒང་)གལ་སྲིད་ཨི་མེལ་འདི་ སྟངམ་འབད་བཞག་ད་པ་ཅིན་ དེ་ལས་ ཨི་མེལ་ཁ་བཡང་ཚུ་གི་གྲོགས་རམ་བྱིན་ནི་ཚུ་མེད་པའི་དོན་ཨིན།';
$string['configsupportname'] = 'འ་ནི་འདི་ མི་གི་མིང་ཨིནམ་མ་ཚད་ ཡང་ན་ གཞན་མི་ངོ་བོ་འབད་ སྤྱིར་བཏང་གི་གྲོགས་རམ་རྒྱུད་དེ་ ཨི་མེལ་ཡང་ན་ཝེབ་ཁ་བྱང་ཚུ་བྱིན་ནི་ཨིན།';
$string['configsupportpage'] = 'ཨི་མེལ་ཁ་བྱང་འདི་གི་ དཔེ་བསྐྲུན་འབད་ཡོད་མི་དེ་ ས་ཁོངས་དེ་གི་ལག་ལེན་པ་ཚུ་ གོང་གི་ཨི་མེལ་བཟུམ་སྦེ་ སྤྱིར་བཏང་ཁོང་ལུ་ ཆ་རོགས་དགོ་པའི་བསྒང་ལུ་ (དཔེར་ན་ ལག་ལེན་པའི་གསརཔ་་ཚུ་ ཁོང་རའི་རའི་རྩིས་ཐོ་གསར་བསྐྲུན་འབད་བའི་བསྒང་)གལ་སྲིད་ཨི་མེལ་འདི་ སྟོངམ་འབད་བཞག་ད་པ་ཅིན་ དེ་ལས་ ཨི་མེལ་ཁ་བྱང་ཚུ་གི་འབྲེལ་མཐུད་ཀྱི་གྲོགས་རམ་བྱིན་ནི་ཚུ་མེད་པའི་དོན་ཨིན།';
$string['configthemedesignermode'] = 'སྤྱིར་བཏང་གིས་ བཀོད་རིས་ཤོག་ལེབ་ག་ར་ སྤར་དང་བཟོ་བཀོད་ཅན་གྱི་ཤོག་གུ་གློག་རིག་དྲན་འཛོད་
ཚུ་བྱ་སྒོའི་དོན་ལུ་བརའུ་ཟར་དང་སར་བར་ཚུ་ནང་ལུ་ཡུན་རིངམོ་འབད་སྡོད་འོང་། གལ་སྲིད་ཁྱོད་བཀོད་རིས་ཤོག་ལེབ་ལུ་བཟོ་བཀོད་འབདཝ་འདྲཝ་ཡང་ན་ ཨང་རྟགས་བཟོཝ་ཨིན་པ་ཅིན་ ཁྱོད་ཀྱིས་དེ་འགྱུར་བཏུབ་བཟོ་བ་ཅིན་གློག་རིག་དྲན་འཛོད་ཀྱི་ཕན་ཐོགས། ཉེན་བརྡ། ཨ་ནི་འདི་གིས་ལག་ལེན་པ་ཚུ་ག་ར་ལུ་མགྱོགས་ཚད་མར་ཕབ་འགྱོ་འོང་། གདམ་ཁ་གཅིག་འདི་ ཁྱོད་ཀྱིས་བཀོད་རིས་ཤོག་ལེབ་ནང་ལུ་རང་གློག་རིག་དྲན་འཛོད་དེ་ལག་པ་གིས་སྦེ་གཞི་སྒྲིག་བཀོད་རིས་ཤོག་ལེབ་གདམ་འཐུ་ནང་ལས་སྦེ་འབད་ཚུགས།';
$string['configthemelist'] = 'འདི་གར་སྟོངམ་བཞག་ནིའི་དོན་ལུ་ བརྗོད་དོན་གྱི་ནུས་ཅན་ག་ཅི་འབད་རུང་ ལག་ལེན་འཐབ་ཆོགཔ་ཨིན། གལ་སྲིད་ ཁྱོད་ཀྱི་བརྗོད་དོན་གྱི་དཀར་ཆག་ འཐུང་ཀུ་བཟོ་བ་ཅིན་ ཁྱོད་ཀྱིས་ ལྷོད་རྟགས་འདི་ མི་ཐོ་ལས་སོ་སོར་འབད་ འདི་ཁར་གསལ་བཀོད་འབད་དགོ། ༼བར་སྟོང་འདི་ལག་ལེན་མ་འཐབ༽ དཔེར་ན་ ཚད་ལྡན་ ཨོ་རནཇི་ ཝའིདྲ།';
$string['configtimezone'] = 'རིམ་སྒྲིག་གི་ཆུ་ཚོད་གླིང་སྡེ་ འདི་ཁར་གཞི་སྒྲིག་འབད་ སྤྱི་ཚེས་བཀྲམ་སྟོན་འབད་ནིའི་དོན་ལུ་ ཆུ་ཚོད་གླིང་སྡེ་རྐྱངམ་ཅིག་རིམ་སྒྲིག་འབདཝ་ཨིན། ཁོང་རའི་གསལ་སྡུད་ནང་ ཁོང་རའི་གཞི་སྒྲིག་འབད་དེ་ཡོད་མི་དེ་ ལག་ལེན་པ་རེ་རེ་གིས་ མེདཔ་གཏངམ་ཨིན།  "Server time" མོ་ཌེལ་རིམ་སྒྲིག་འབད་མི་དེ་གིས་ སར་བར་བཀོལ་སྤྱོད་་རིམ་ལུགས་གཞི་སྒྲིག་འབད་ཚུགས་དགོ། དེ་འབདཝ་ད་ལུ་ སར་བར་གཡི་དུས་ཚོད་ ལག་ལེན་གསལ་སྡུད་དེ་གིས་ ལག་ལེན་རིམ་སྒྲིག་དེ་གི་ ཆུ་ཚོད་གླིང་སྡེ་ གཞི་སྒྲིག་འབད་དགོ། ཀོརོ་ཇོབ་དེ་ ཆུ་ཚོད་དང་ ཉིནམ་རྐྱངམ་ཅིག་གི་ ཆུ་ཚོད་གླིང་སྡེ་ གཡོག་བཀོལ་ནི་ལུ་ རག་ལེགཔ་ཨིན།';
$string['configuseblogassociations'] = 'ལག་ལེན་པ་ཚུ་ ཁོང་རའི་ ཝེབ་དྲན་དེབ་ནང་ སློབ་ཚན་དང་སློབ་ཚན་གྱི་དོན་ཚན་ཚུ་སྒྲིག་བཀོད་ ཐོ་བཀོད་དང་འཁྲིལ་ཏེ་འབད་བཅུག་ནི་ཨིན་ན?';
$string['configuseexternalyui'] = 'མཐའ་འཁོར་ལུ་ཡོད་པའི་ཡིག་སྣོད་ཚུ་ལག་ལེན་འཐབ་བ་སྟི་
Yahoo‘s servers. ཡོངས་འབྲེལ་ནང་ཡོད་པའི་ཡིག་སྣོད་ཚུ་ལག་ལེན་འཐབ། ཉེན་བརྡ། དེ་གི་དོན་ཡོངས་འབྲེལ་གྱི་རྒྱུན་ལམ་དགོཔ། ཡང་ན་no AJAX གི་ཁྱོད་ཀྱི་ས་སྒོ་ནང་ལཱ་འབད་མི་བཏུབ། ཨ་ནི་གཞི་སྒྲིག་འདི་སྒྲིག་བཏུབ་པའི་ས་སྒོ་https.ལག་ལེན་འཐབ་སྟེ་གཞི་སྒྲིག་འབད་མི་བཏུབ།';
$string['configuserquota'] = 'ལག་ལེན་པ་ཚུ་གིས་ཁོང་རའི་སྒེར་གྱི་ཡིག་སྣོད་ས་སྒོ་ནང་མང་མཐའ་ར་{$a->bytes} bytes == {$a->displaysize}ཨིན།';
$string['configusesitenameforsitepages'] = 'གལ་སྲིད་ ལྕོགས་ཅན་བཟོ་བ་ཅིན་ ས་སྒོ་གི་ཤོག་ལེབ་འབྲེལ་མཐུན་བཟོ་ནིའི་དོན་་ལུ་ ས་སྒོ་གི་ཤོག་ལེབ་དེ་མིན་པ་
ས་སྒོ་གི་མིང་ཐུང་་འབྲེལ་མཐུན་དེ་ལག་ལེན་འཐབ་དགོ།';
$string['configusetags'] = 'ལས་འགན་ངོ་རྟགས་ཚུ་ ས་ཁོངས་ཡན་ཆད་ ལྕོགས་ཅན་བཟོ་དགོ་ག?';
$string['configvariables'] = 'འགྱུར་ཅན།';
$string['configverifychangedemail'] = 'བདེན་དཔྱད་ལྕོགས་ཅན་གྱི་ཨི་མེལ་ཁ་བྱང་ཚུ་ བསྒྱུར་བཅོས་འབད་ཡོདཔ་ལས་ དེ་ལག་ལེན་འཐབ་ཆོགཔ་དང་ ཨི་མེལ་གྱི་ཌྲོ་མེན་གཞི་སྒྲིག་ཁས་མི་ལེནམ་ཨིན། གལ་སྲིད་གཞི་སྒྲིག་འདི་ ལྕོགས་མིན་ཐལ་ཡོད་པ་ཅིན་ ལག་ལེན་པའི་གསར་བསྐྲུན་འབད་བའི་བསྒང་དྲོ་མིན་དེ་ཚུ་ བེད་སྤྱོད་གཏང་ནི་རྐྱངམ་ཅིག་ཐལ་ཡོདཔ་ཨིན།';
$string['configvisiblecourses'] = 'སྤྱིར་བཏང་སྡེ་རིམ་གྱི་སྦ་ནི་ནང་ལུ་ སློབ་ཚན་ཚུ་བཀྲམ་སྟོན་འབད།';
$string['configwarning'] = 'གཞི་སྒྲིག་ལེགས་བཅོས་འབད་ནི་དེ་ཁར་ དྲན་ཤེས་ཀྱི་སྒོ་ལས་ འབད་དགོ་ གནས་གོང་ཧ་མ་གོ་མི་དེ་གི་ དཀའ་ངལ་གྱི་རྒྱུ་མཚན་ཚུ་ ཤེས།';
$string['configyuicomboloading'] = 'YUI དཔེ་མཛོད་ཀྱི་དོན་ལུ་ ཨ་ནི་གདམ་ཁ་དེ་གིས་ བསྡོམས་ཏེ་ཡོད་མིའི་ཡིག་སྣོད་ཚུ་སྐྱེལ་བཙུགས་མངམ་འབད་ནི་ལུ་ལྕོགས་ཅན་བཟོ་འོང་། གྲུབ་འབྲས་འཐོན་ནིའི་དོན་ལུ་ གཞི་སྒྲིག་དེ་བཟོ་བསྐྲུན་གྱི་ས་སྒོ་ནང་ལྕོགས་ཅན་བཟོ་དགོ།';
$string['confirmation'] = 'ངེས་དཔྱད།';
$string['confirmdeletecomments'] = 'ཁྱོད་བསམ་བཀོད་ཚུ་བཏོན་གཏང་ནི་འབད་དོ་  ཐད་རི་པ་རི་བཏོན་གཏང་ནི་ཨིན་ན?';
$string['confirmed'] = 'ངེས་དཔྱད་འབད་ཡོད།';
$string['convertformat'] = '<i>convert</i> གྲུབ་འབྲས་སྒྲིག་བཀོད།';
$string['cookiehttponly'] = 'ཨེཆ་ཊི་ཊི་པི་ཀུ་ཀིས་ཙམ་ཅིག།';
$string['cookiesecure'] = 'མཐའ་བཙན་ཀུ་ཀིས་ཙམ་ཅིག།';
$string['country'] = 'སྔོན་སྒྲིག་ རྒྱལ་ཁབ།';
$string['coursecontact'] = 'སློབ་ཚན་ནང་བཅའ་མར་གཏོགས་ཡོད་མི་ཚུ་གི་ཐོ།';
$string['coursecontact_desc'] = 'གཞི་སྒྲིག་དེ་གིས་ སློབ་ཚན་གྱི་འགྲེལ་བཤད་ནང་ ག་ཐོ་ནང་ཡོད་ཀ་གི་བཀག་འཛིན་འབད་ཚུགས། ལག་ལེན་པ་ཚུ་ལུ་ག་དེ་འབད་རུང་ སློབ་ཚན་གྱི་འགྲེལ་བཤད་ནང་སྟོན་ནིའི་དོན་ལུ་ལས་འགན་གཅིག་འབག་སྟེ་འོང་དགོ།';
$string['courselistshortnames'] = 'སློབ་ཚན་གྱི་མིང་རྒྱ་སྐྱེད་བཏང་ཡོད་མི་ཚུའི་གསལ་སྟོན།';
$string['courselistshortnames_desc'] = 'སློབ་ཚན་གྱི་ཐོ་ཚུ་སྟོན་པའི་སྐབས་ ཡང་ན་ བདག་སྐྱོང་གི་མཐོང་བྱང་ནང་ལུ་གཞི་རྟེན་འབད་བའི་སྐབས་ སློབ་ཚན་གྱི་མིང་ མདོར་བསྡུ་དང་ཆ་ཚང་གཉིས་ཀ་ར་སྟོན། མ་གཞི་ ཁྱོད་ཀྱིས་གཞི་སྒྲིག་འདི་འགྱུར་བཏུབ་བཟོ། གསལ་སྟོན་དེ་གིས\'ཡིག་རྒྱུན་འདི་\'courseextendednamedisplay\'སྟོན་འོང་ འདི་འབདཝ་ལས་ཁྱོད་ཀྱིས་གསལ་སྟོན་འབད་ཡོད་མི་དང་འཁྲིལ་ཏེ་ སྐད་ཡིག་སྲོལ་སྒྲིག་འབད་ཚུགས།';
$string['coursemgmt'] = 'སློབ་ཚན་ཚུ་ ཁ་སྐོང་རྐྱབས/ཞུན་དག་འབད';
$string['courseoverview'] = 'སློབ་ཚན་ སྤྱི་མཐོང་།';
$string['courserequestnotify'] = 'སློབ་ཚན་གྱི་བརྡ་བསྐུལ་ཞུ་བ་འབད་ནི།';
$string['courserequestnotifyemail'] = 'ལག་ལེན་པ་{$a->user} ་གི་ {$a->link}་ལས་སློབ་ཚན་གསརཔ་ཞུ་བ་འབད་ཡོདཔ།';
$string['courserequests'] = 'སློབ་ཚན་ཞུ་བ་འབད་ནི།';
$string['courserequestspending'] = 'སློབ་ཚན་ཞུ་བ་ ཕར་བཤུད་འབད་ནི།';
$string['courses'] = 'སློབ་ཚན་ཚུ';
$string['coursesperpage'] = 'སློབ་ཚན་ཚུ་ ཤོག་ལེབ་རེ་རེ་བཞིན';
$string['courseswithsummarieslimit'] = 'སློབ་ཚན་བཅུད་བསྡུ་གི་ཚད་འཛིན་དང་གཅིག་ཁར།';
$string['creatornewroleid'] = 'སློབ་ཚན་གསརཔ་ཚུ་གི་ནང་ གསར་སྐྲུན་པ་གི་ལས་ལས་འགན།';
$string['creatornewroleid_help'] = 'ལག་ལེན་པ་དེ་ལན སློབ་ཚན་གསརཔ་ འཛིན་སྐོང་འབད་ནི་གི་ གནང་བ་མེད་པ་ཅིན་ ལག་ལེན་པ་དེ་ རང་བཞིན་གྱིས་ ཨ་ནི་ལག་ལེན་འཐབ་ནིའི་དོན་ལུ་ཐོ་བཀོད་འབད་ཡོདཔ་ཨིན།';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'བཀོད་ལམ་ལས་བརྒྱུད་དེ་ཙམ་ཅིག་ ཀོརཱོན་ལག་ལེན་འཐབ།';
$string['cronerrorclionly'] = 'དགོངསམ་མ་ཁྲེལ་ ཤོག་ལེབ་འདི་ལུ་ཨིན་ཊར་ནེཊི་འཛུལ་སྤྱོད་འབད་ནི་དེ་ བདག་སྐྱོང་པ་གི་ལྕོགས་མིན་བཟོ་ནུག།';
$string['cronerrorpassword'] = 'དགོངསམ་མ་ཁྲེལ་ ཁྱོད་ལུ་ཤོག་ལེབ་འདི་ལུ་འཛུལ་སྤྱོད་འབད་ནི་དོན་ལུ་ནུས་ཅན་ཆོག་ཡིག་བྱིན་ཏེ་མེད།';
$string['cron_help'] = 'cron.php རྒྱུན་སྐྱོང་ཡིག་གུ་གིས་ Moodle༌གི༌ཚད༌གཞི༌ཚུ༌དུས༌མཐུན༌བཟོ༌སྟེ༌ལཱ༌འབད༌ནིའི༌དོན༌ལུ༌དཔེར༌ན།གྲོས༌བསྡུར༌གསརཔ༌གི༌སྐོར༌ལས༌ཕྱིལ༌བཏང༌ཡོད༌པའི༌འདྲ།
དེ༌གི༌དོན༌ལུ༌སྐར༌ཆ༌ལྔ༌ལྔ༌༌རེ༌རེའི༌ནང༌ལུ༌ཨ༌རྟག༌ར༌ཡིག༌གུ༌འག྄ལ༌བསྐྱོད༌འབད༌ནིའི༌ཐབས༌ལམ༌དགོ།';
$string['cronremotepassword'] = 'ཐག་རིང་གི་འཛུལ་སྤྱོད་འབད་ནི་དོན་ལུ་ ཀོརཱོན་ཆོག་ཡིག།';
$string['cronwarning'] = 'The <a href="cron.php">ཀོརཱོན.པི་ཨེཆ་པི་རྒྱུན་སྐྱོང༌ཡིག་ཚུགས་</a>དེ་ ཉུང་མཐའ་ཆུ་ཚོད་༢༤་ གཡོག་མ་བཀོལ་བས།';
$string['ctyperecommended'] = 'གདམ་ཁ་ཅན་ པི་ཨེཆ་པི་སི་ཀྲའིཔ་ གཙུག་ནི་དེ་ བརྒྱ་བསྐྱེད་འབད་ནི་དེ་ རྒྱ་ཆེ་དྲག་འབད་ འོས་སྦྱོར་འབད་ཡོད་མི་དེ་ ས་ཁོངས་ལཱ་ཤུགས་དང་འཁྲིལ་ཡར་དྲག་འབད་ནི་དང་ དམིགས་བསལ་དུ་ གལ་སྲིད་ཁྱོད་ཀྱི་ ས་ཁོངས་འདི་ ལ་ཀྲིན་དང་མ་འཁྲིལ་བའི་ ཁ་སྐད་ཚུ་ལུ་རྒྱབ་སྐྱོར་འབད་བ་ཅིན་ཨིན།';
$string['ctyperequired'] = 'སི་ཀྲའིཔ་པི་ཨེཆ་པི་འདི་ ད་ལྟོ་རྒྱ་བསྐྱེད་འབད་ནི་འདི་ མུ་དྲིལ་གྱི་དགོས་མཁོ་ཡོདཔ་ཨིན། ལཱ་ཤུགས་ས་ཁོངས་ཡར་དྲག་དང་འཁྲིལ་ འབད་ནི་དང་ སྐད་སྣ སྨྲ་བའི་མཐུན་འགྱྲུར་འབད་ནི་ལུ་བྱིན་དགོཔ་ཨིན།';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrecommended'] = 'cURLདཔེ༌མཛོད༌གདམ༌ཁ༌བཙུགས༌དགོཔ༌འདི༌ Moodle གཅིག༌འབྲེལ༌འབད༌བཏུབ༌བཟོ༌ནིའི༌དོན༌ལུ༌ཁག༌ཆེ༌ཤོ༌ཅིག༌སྦེ༌བརྩི༌དགོ།';
$string['curlrequired'] = 'cURL PHPརྒྱ༌བསྐྱེད༌དེ༌Moodleབང༌མཛོད༌དང༌མཉམ༌ཅིག༌རྒྱུན༌འབྲེལ༌འབད༌ནིའི༌དོན༌ལུ༌དགོ།';
$string['curltimeoutkbitrate'] = 'cURL timeouts (Kbps)གི༌སྐོར༌ལས༌རྩིས༌བརྐྱབ༌པའི༌སྐབས༌སུ༌Bitrateགཡོག༌བཀོལ།';
$string['curltimeoutkbitrate_help'] = 'གཞི༌སྒྲིག༌དེ༌cURLམངམ༌དགོ༌པའི༌སྐབས༌ལུ༌༌འོས༌འབབ༌ལྡན༌པའི༌ཕྱི༌བསྐྱོད༌ཀྱི༌དུས༌ཚོད༌ལག༌ལེན༌འཐབ༌ཞིནམ༌ད༌དེ༌གི༌ཡན༌ལག༌གི༌སྦོམ༌ཚད༌རྩིས༌བཟུམ༌ཅིག༌སྦེ༌HTTP HEAD དེའི༌༌ནང༌འཁོད༌ཡོད༌ཐོ༌ཀྱི༌སྐོར༌ལས༌ཧ༌གོཝ༌བཟོཝ༌ཨིན།
༠༌ལུ༌གཞི༌སྒྲིག༌འབད༌བ༌ཅིན༌ལཱ༌འབད༌ནི༌དེ༌ལྕོགས༌མིན༌བཟོ༌འོང༌།';
$string['currenttheme'] = 'ད༌ལྟ༌གི༌བཀོད༌རིས༌ཤོག༌ལེབ།';
$string['customcheck'] = 'ཞིབ་དཔྱད་གཞན་མི་ཚུ།';
$string['custommenu'] = 'དཀར༌ཆག༌ཚོང༌སྤྱོད།';
$string['custommenuitems'] = 'དཀར༌ཆག༌ཚོང༌སྤྱོད༌ཀྱི༌ཅ༌ཆས།';
$string['datarootsecurityerror'] = '<p><strong>,སྲུང་སྐྱོབ་ཀྱི་ཉེན་བརྡ་!</strong></p><p> ཁྱོད་ཀྱི་གནས་སྡུད་གཞི་རྟེན་ སྣོད་སྡེབ་འདི་ གནས་ཁོངས་འཛོལ་བ་འདི་ནང་ ཝེབ་ནང་ལུ་ཕྱི་ཁར་བཏོན་ཡོདཔ་ཨིན། དེ་གི་དོན་དག་འདི་ ཁྱོད་ཀྱི་སྒེར་གྱི་ཡིག་སྣོད་འདི་ འཛམ་གླིང་འདི་ནང་ག་གི་ཡང་ཐོབ་ཆོག་ཆོགཔ་འབད་ཡོདཔ་ཨིན། ལ་ལོ་ཅིག་གིས་ཡང་ ཆོག་ཡིག་མེད་པའི་བདག་སྐྱོང་གིས་ ས་ཁོངས་ནང་འཛུལ་བསྐྱོད་འབད་ནི་ནང་ དྲག་ཤུགས་ཐོབ་ནི་ལུ་ ལག་ལེན་འཐབ་ཚུགས།</p><p>You<em>must</em> གནས་སྡུད་གཞི་རྟེན་སྣོད་དེབ་འདི་ ({$a})གནས་ཁོངས་གསརཔ་ཅིག་ནང་ མི་ཚུ་ཝེབ་ཀྱི་སྣེད་དེབ་ནང་འཁོད་ དུས་མཐུན་བཟོ་ནི་དང་ <code>$CFG->dataroot</code> འདི་ལུ་ གཞི་སྒྲིག་འབད་ནི་འདི་ལུ་ config.php accordingly.</p>';
$string['datarootsecuritywarning'] = 'ཁྱོད་ཀྱི་ས་ཁོངས་ནང་གི་རིམ་སྒྲིག་དེ་གི་ མཐའ་ཙད་མ་བཟོ་འོང་། ཁྱོད་ཀྱི་གནད་སྡུད་རྩ་བའི་སྣོད་ཐོ་འདི་ ཝེབ་རྒྱུད་དེ་ འཐད་ཀར་དུ་ འཛུལ་བསྐྱོད་མེདཔ་པས་ གཏན་གཏན་བཟོ་དགོ། {$a}';
$string['dbmigrate'] = 'མུ་དྲིལ་ གནས་སྡུད་གཞི་རྟེན་གཞི་སྤོ་ནི།';
$string['dbmigrateconnecerror'] = 'གནས་སྡུད་གཞི་རྟེན་གསལ་བཀོད་འབད་ཡོད་མི་ལུ་ འབྲེལ་མཐུད་འབད་མ་ཚུགས།';
$string['dbmigrateencodingerror'] = 'གནས་སྡུད་གཞི་རྟེན་དེ་དགོས་མཁོ་ཡོད་མི་འདི་ལས་ ཨིན་ཀོ་དྲིང་ {$a} གསལ་བཀོད་འབད་ཡོདཔ་ལས་ UNICODE/UTF8.<br />གཞན་མི་ཡང་གསལ་བཀོད་འབད་གནང་།';
$string['dbmigratepostgres'] = 'གནས་སྡུད་གཞི་རྟེན་སར་བར་བཟུམ་འབད་ དེ་ལུ་ལྟཝ་ད་ལུ་ ཁྱོད་ཀྱི་ པོསིདྲི་གྱིར་ ཨེས་ཀིའུལ་ཨེལ་ ལག་ལེན་འཐབ་དོ་བཟུམ་མཐོང་མས། ལས་སྦྱོར་གཞི་སྤོ་ནི་ལུ་ འཕྲོ་འཐུད་དེ་ ཁྱོད་ཀྱི་ ལག་ཐོག་ལས་ གནས་སྡུད་གཞི་རྟེན་ དང་གཅིག་ཁར་ཨིན་ཀོ་དྲིང་ གསར་བསྐྲུན་འབད་དགོ། "UNICODE" (PostgreSQL 7) or "UTF8" (PostgreSQL 8) གནས་སྡུད་མཛོད་ནང་གཞི་སྤོ་ཡོདཔ་ལས་ ཁྱོད་ཀྱིས་གནས་སྡུད་གཞི་རྟེན་ གསརཔ་བཙུགས་ཏེ་ འོག་ལུ་ཡོད་པའི་ལུ་འབྲེལ་མཐུད་འབད་དེ་ འཕྲོ་འཐུད་གཞི་སྒྲིག་འབད།';
$string['dbmigratewarning'] = 'ཁྱོད་ཀྱི་མུ་དྲིལ་གྱི་གནས་སྡུད་གཞི་རྟེན་འདི་ རྒྱབ་སྐྱོར་འབད་ཚར་ཡོདཔ་ལས་ འགོ་རིམ་འདི་འགོ་མ་བཙུགས་པའི་ཧེན་མ་ལས་ ཁྱོད་ཀྱིས་ངེས་བདེན་འབད་གནང་། གལ་སྲིད་ཁྱོད་རང་ ག་དེསྦེ་འབད་ནི་ཨིན་ན་ངེས་བདེན་མ་ཤེས་པ་ཅིན་ ཁྱོད་ཀྱིས་བདག་སྐྱོང་རིམ་ལུགས་ལུ་འབྲེལ་མཐུད་འབད་གནང་། ཁྱོད་ཀྱི་མུ་དྲིལ་ས་ཁོངས་དེ་གི་ རྒྱུན་སྐྱོང་ཐབས་ལམ་གྱི་འོག་ལུ་བཙུགས་ཏེ་ ཁྱོད་ཀྱི་འགོ་བཙུགས་པའི་ཤུལ་ལས་ལས་སྦྱོར་གཞི་སྤོ་དགོ།';
$string['dbmigratewarning2'] = '<b>ཉེན་བརྡ ཁྱོད་ཀྱི་ གནས་སྡུད་གཞི་རྟེན་ལས་སྦྱོར་འདི་འགོ་བཙུགས་རནམ་ད་ལུ་ ཁྱོད་ཀྱི་མུ་དྲིལ་གནས་སྡུད་གཞི་རྟེན་ཧྲིལ་བུ་འབད་ རྒྱབ་སྐྱོར་ཡོདཔ་ཨིནམ་ ངེས་བདེན་ཨིནམ་སྦེ་འབད་དགོ།';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">གནས་སྡུད་གཞི་རྟེན་འདི་ གཞི་སྤོ་ཡོདཔ་ལས་ཡུ་ཀྲི་ཨེཕ་8 གནས་སྡུད་གཞི་རྟེན་དང་ངོས་ལེན་མེདཔ་ཨིན།config.phpལུ་ཞིབ་དཔྱད་འབད་གནང་ དང་ གནས་སྡུད་གཞི་རྟེན་གསརཔ་མུལ་དྲིལ་འདི་གི་དོན་ལུ་ ལག་ལེན་འཐབ་དགོ།';
$string['dbmigrationdupfailed'] = 'གནས་སྡུད་གཞི་རྟེན་འདྲ་བཟོ་འཐུས་ཤོར་དང་གཅིག་ཁར་ འཛོལ་བ་བྱུང་སྲིད་:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'ལཱ་ཡུན་བརྡ་དོན་གྱི་དོན་ལུ་གནས་སྡུད་གཞི་རྟེན་ ལག་ལེན་འཐབ།';
$string['debug'] = 'འཕྲིན་དོན་ཚུ་ རྐྱེན་སེལ་འབད།';
$string['debugall'] = 'ཆ་མཉམ:ཁུངས་ལྡན་པི་ཨེཆ་པི་འཕྲིན་དོན་ཚུ་ རྐྱེན་སེལ་འབད།';
$string['debugdeveloper'] = 'བཟོ་མི:བཟོ་མི་ཚུ་གི་དོན་ལུ་ཐེབས་མུ་ཌེལ་གྱི་རྐྱེན་སེལ་འཕྲིན་དོན་ཚུ།';
$string['debugdisplay'] = 'རྐྱེན་སེལ་འཕྲིན་དོན་ཚུ་སྟོན།';
$string['debugging'] = 'རྐྱེན་སེལ་འབད་དོ།';
$string['debugminimal'] = 'ཉུང་ཤོས:འཚུབ་ཆེན་འཛོལ་བ་ཚུ་ཙམ་ཅིག་སྟོན།';
$string['debugnone'] = 'ཅི་མེད:འཛོལ་བ་ཡང་ན་ཉེན་བརྡ་ཚུ་ག་ཅིག་ཡང་མསྟོན།';
$string['debugnormal'] = 'སྤྱིར་བཏང་:འཛོལ་བ་ ཉེན་བརྡ་ཡང་ན་བརྡ་བསྐུལ་ཚུ་སྟོན།';
$string['debugpageinfo'] = 'ཤོག༌ལེབ༌ཀྱི༌སྐོར༌ལས༌སྟོན།';
$string['debugsmtp'] = 'གློག་འཕྲིན་གཏང་ནི་ རྐྱེན་སེལ།';
$string['debugstringids'] = 'སྐད༌ཡིག༌རྒྱུན༌མཐུད༌ཀྱི༌འབྱུང༌ཁུངས༌སྟོན།';
$string['debugstringids_desc'] = 'གདམ༌ཁ༌འདི༌སྐད༌བསྒྱུར༌པ༌ཚུ༌ལུ༌རོགས༌རམ༌འབད༌ནིའི༌དོན༌ལུ༌བཟོ༌བཀོད༌སྦེ༌འབདཝ༌ཨིན།གདམ༌ཁ༌དེ༌ལྕོགས༌ཅན༌བཟོ༌བའི་སྐབས་ སྐད་ཡིག་རྒྱུན་མཐུད་ཀྱི་=1 to a request URL, འབད་བའི་སྐབས་དེ་གིས་སྐད་ཡིག་ཡིག་སྣོད་དང་རྒྱུན་མཐུད་ཀྱི་ངོ་རྟགས་རེ་རེ་བཞིན་དུ་ཕྱི་བསྐྱོད་འབད་ཡོད་མི་ཚུ་རེ་རེ་བཞིན་དུ་སྟོན་འོང་།';
$string['debugvalidators'] = 'བདེན་ཁུངས་སྟོན་མིའི་རྒྱུན་མཐུད་སྟོན།';
$string['defaultcity'] = 'གློག་རིག་གྲོང་སྡེ།';
$string['defaultcity_help'] = 'ནཱ་བཙུགས་ཏེ་ཡོད་པའི་་དེ་ ལག་ལེན་པ་གསརཔ་གི་རྩིས་ཐོ་གི་སྔོན་སྒྲིག་་ཁྲོམ་སྡེ་ཨིན།';
$string['defaultformatnotset'] = 'ནོར་འཁྲུལ་བལྟ་ནིའི་སྔོན་སྒྲིག་སློབ་ཚན་འབྲི་ཤོག
ས་སྒོ་ནང་གི་གཞི་སྒྲིག་བརྟགས་དཔཡད་འབད།';
$string['defaulthomepage'] = 'ལག་ལེན་པའི་སྔོན་སྒྲིགས་གདོང་ཤོག';
$string['defaultrequestcategory'] = 'སློབ་ཚན་ཞུ་བ་ཚུ་གི་ སྔོན་སྒྲིག་དབྱེ་རིམ།';
$string['defaultsettinginfo'] = 'སྔོན་སྒྲིག་:{$a}';
$string['defaultuserroleid'] = 'ལག་ལེན་པ་ཚུ་ཆ་མཉམ་་གི་དོན་ལུ་ སྔོན་སྒྲིག་ལས་འགན།';
$string['deleteincompleteusers'] = 'ཤུལ་ལས་ ཆ་མ་ཚང་པའི་ལག་ལེན་པ་ཚུ་བཏོན་གཏང་།';
$string['deleteunconfirmed'] = 'ཤུལ་ལས་ ཆ་ཚང་སྦེ་གཞི་སྒྲིག་འབད་ཡོད་པའི་ལག་ལེན་པ་ཚུ་བཏོན་མ་གཏང་།';
$string['deleteuser'] = 'ལག་ལེན་པ་སྟོན་བཏང་།';
$string['density'] = 'སྟུག་ཚད།';
$string['denyemailaddresses'] = 'ཁས་མི་ལེན་པའི་གློག་འཕྲིན་ཌོ་མེན་ཚུ།';
$string['development'] = 'ཡར་བསྐྱེད།';
$string['devicedetectregex'] = 'དུས་རྒྱུན་དངོས་ཆས་བརྟགས་ཞིབ་ཀྱི་བསམ་བརྗོད།';
$string['devicedetectregex_desc'] = '<p>By default, Moodle can detect devices of the type default (desktop PCs, laptops, etc), mobile (phones and small hand held devices), tablet (iPads, Android tablets) and legacy (Internet Explorer 6 users). བཀོད་རིས་ཤོག་ལེབ་གདམ་འཐུ་དེ་ལག་ལེན་འཐབ་སྟེ་ དེ་ཚུ་ག་ར་ལུ་སོ་སོ་འབད་བཀོད་རིས་ཤོག་ལེབ་ལག་ལེན་འཐབ་བཟོ་བཏུབ། གཞི་སྒྲིག་འདི་གིས་བཀོད་རིས་ཤོག་ལེབ་གུར་དངོས་ཆས་སྐོར་དུས་རྒྱུན་གྱི་བསམ་བརྗོད(these take precedence over the default types).</p> <p>For example, you could enter the regular expression \'/(MIDP-1.0|Maemo|Windows CE)/\' to detect some commonly used feature phones add the return value \'featurephone\'. This adds \'featurephone\' on the theme selector that would allow you to add a theme that would be used on these devices. Other phones would still use the theme selected for the mobile device type.</p>་';
$string['devicedetectregexexpression'] = 'དུས་རྒྱུན་གྱི་བསམ་བརྗོད།';
$string['devicedetectregexvalue'] = 'སླར་ལོག་གི་ཁཡད་བཅུད།';
$string['devicetype'] = 'དངོས་ཆས་དབྱེ་བ།';
$string['disableuserimages'] = 'ལྕོགས་མིན་ལག་ལེན་པའི་ གསལ་སྡུད་གཟུགས་བརྙན།';
$string['displayerrorswarning'] = '་PHPགཞི་སྒྲིག་འདི་ལྕོགས་ཅན་བཟོ་ནི་དེ་<em>display_errors</em> ཐོན་འབརས་ས་ཁོངས་ནང་ལུ་འོས་སྦྱོར་མེདཔ་ཨིན་པས་ ག་ཅི་འབད་ཟེར་བ་ཅིན་ ཁྱོད་ཀྱི་སར་བར་གྱི་སྐོར་ལས་ འཛོལ་བ་བྱུང་ཡོད་པའི་འཕྲིན་དོན་ལ་ལོ་ཅིག་ ཕྱིར་གསལ་ཚོར་ཅན་བརྡ་དོན་ལུ་འགྱུར་ནི་ཨིན་པས།';
$string['displayloginfailures'] = 'ལུ་ནང་བསྐྱོད་འཐུས་ཤོར་ཚུ་སྟོན།';
$string['dndallowtextandlinks'] = 'ཚིག་ཡིག་/རྒྱུན་འཐུད་སྐྱེལ་བཙུགས་འབད་ནིའིའ་དོན་ལུ་འཐེན་ཏེ་བཀོག';
$string['docroot'] = 'མུ་ཊེལ་ཌོཀས་ཡིག་ཆ་གི་རྩ་བ།';
$string['doctonewwindow'] = 'ཝིན་ཌོ་གསར་པ་ནང་ཁ་ཕྱེ།';
$string['download'] = 'ཕབ་ལེན།';
$string['edithelpdocs'] = 'གྲོགས་རམ་ཡིག་ཆ་ཚུ་ཞུན་དག་འབད།';
$string['editingnoncorelangfile'] = 'ཁྱོད་ཀྱི་མུ་དྲིལ་/ནང་བསྐྱོད་ལུ་ཁ་སྐོང་བཀལ་ནི་ལུ་ སྐད་བསྒྱུར་འབད་ནི་ལུ་ ལེགས་བཅོས་དང་ འབད་རྩོལ་བསྐྱེད་དགོ། ཁྱོད་ཀྱི་མུ་དྲིལ་སྡེ་ཚོགས་གསུམ་པ་ སྐད་འགྱུར་འབད་ནི་དེ་ ཉེ་གནས་སྣོད་འཛིན་རྐྱངམ་ཅིག་ནང་ཨིན། ཡང་ན་ཁྱོད་ཀྱི་ཡིག་སྣོད་སྐད་འགྱུར་ དེ་ མུ་དྲིལ་ཁ་སྐད་སྣོད་ཐོ་ནང་ སྤོ་ནི་འོང་ ཡང་ན་ མུ་དརིལ་ཁ་སྐོང༌གི༌ལེགས་བཅོས་པ་ལུ་སྐྱེལ༌གཏང༌།';
$string['editlang'] = 'b>ཞུན་དག</b>';
$string['editorbackgroundcolor'] = 'རྒྱབ་གཞི་ཚོས་གཞི།';
$string['editordictionary'] = 'ཞུན་དགཔ་གི་ ཚིག་མཛོད།';
$string['editorfontfamily'] = 'ཡིག་གཟུགས་ རིགས་ཚན།';
$string['editorfontlist'] = 'ཡིག་གཟུགས་ ཐོ་བཀོད།';
$string['editorfontsize'] = 'ཡིག་གཟུགས་ ཚད།';
$string['editorhidebuttons'] = 'གསང་བའི་ ཨེབ་རྟ།';
$string['editorkillword'] = 'མིང་ཚིག་རྩ་སྒྲིག་ ཚགས་མ།';
$string['editorspelling'] = 'ཞུན་དགཔ་གི་ ཡིག་སྡེབ།';
$string['editorspellinghelp'] = 'ཡིག་སྡེབ་ཞིབ་དཔྱད་ ལྕོགས་ཅན/ལྕོགས་མིན་ བཟོ། ལྕོགས་ཅན་བཟོ་ད་<strong>ཨེ་ཨིསི་པེལ་</strong>འདི་སར་བར་ནང་གཞི་བཙུགས་འབད་ཡོདཔ་སྦེ་དགོ།';
$string['editstrings'] = 'ཚིག་ཡང་ན་ཚིག་ཚན་ཚུ་ ཞུན་དག་འབད།';
$string['emailchangeconfirmation'] = 'གློག་འཕྲིན་བསྒྱུར་བཅོས་འབད་བའི་ ངེས་དཔྱད།';
$string['emoticonalt'] = 'ཚིག་ཡིག་གཞན་མི།';
$string['emoticoncomponent'] = 'གཟུགས་བརྙན་གྱི་ཆ་ཤས།';
$string['emoticonimagename'] = 'གཟུགས་བརྙན་གྱི་མིང།';
$string['emoticons'] = 'གདོང་ཚབ་ཚུ།';
$string['emoticons_desc'] = 'ཨ་ནི་བྲི་ཤོག་འདི་གིས་གདོང་ཚབ་ཚུ་ཁྱོད་ཀྱི་ས་སྒོ་ནང་འགྲེལ་བཤད་འབདཝ་ཨིན། ཐིག་ཁྲམ་ནང་ལས་ཕར་ཚུར་གྱི་གྲལ་ཐིག་བཏོན་གཏང་ནིའི་དོན་ལུ་ འབྲི་ཤོག་འདི་ཡིག་གུ་མེད་པའི་ཤོག་ལེབ་ས་སྟོང་གཅིག་གི་ནང་ལུ་རང་ག་ཏེ་དགོས་མཁོ་ཡོད་པའི་ས་སྒོ་ནང་save འབད་བ་ཅིན་བཏུབ། གདོང་ཚབ་ཚུ་ཐོ་བཀོད་འབད་ནིའི་དོན་ལུ་ མཇུག་ཤོག་ན་ངཡོད་པའི་ཤོག་སྟོང་འདི་བཀང་། ས་ཁོང་ག་ར་སྔོན་སྒྲིག་འབད་ནིའི་དོན་ལུ་གཞི་སྒྲིག་འདི་ལྟག་ལུ་ཡོད་པའི་རྒྱུན་མཐུད་བཟུམ་འབད།* Text (required) - ཚིག་ཡིག་འདི་ཚུ་གདོང་ཚབ་སྤར་ཚུ་གིས་ཚབ་འཛུལ་ཏེ་བཏོན་
གཏང་འོང་། འདི་ཡིག་གཟུགས་ཉུང་མཐའ་ར་གཉིས་དགོ།
* Image name (required) - The emoticon image file name without the extension, relative to the component pix folder. * Image component (required) - The component providing the icon. * Alternative text (optional) - String identifier and component of the alternative text of the emoticon.';
$string['emoticonsreset'] = 'སྔོན་སྒྲིག་གནས་ཚད་ནང་ལུ་གདོང་ཚབ་ཚུ་གཞི་སྒྲིག་འབད།';
$string['emoticontext'] = 'ཚིག་ཡིག།';
$string['emptysettingvalue'] = 'སྟོངམ།';
$string['enableajax'] = 'ཨེ་ཇགས་ ལྕོགས་ཅན་བཟོ།';
$string['enableblogs'] = 'ཝེབ་དྲན་དེབ་ ལྕོགས་ཅན་བཟོ།';
$string['enablecalendarexport'] = 'ཟླ་ཐོ་ཕྱིར་འདྲེན་འབད་ནི་ ལྕོགས་ཅན་བཟོ།';
$string['enablecomments'] = 'བསམ་བཀོད་འབད་ནི་ལྕོགས་ཅན་བཟོ།';
$string['enablecourserequests'] = 'སློབ་ཚན་ཞུ་བ་འབད་ནི་ ལྕོགས་ཅན་བཟོ།';
$string['enablecssoptimiser'] = 'CSS optimiserལྕོགས་ཅན་བཟོ།';
$string['enablecssoptimiser_desc'] = 'ལྕོགས་ཅན་བཟོ་བའི་སྐབས་ CSS འདྲ་མཛོད་ནང་མ་ལྷོད་པའི་ཧེ་མ་ལཱ་རིམ་ག་དེ་མང་མང་འབདཝ་ཨིན། མང་ཆེ་བའི་ལཱ་རིམ་CSSདེ་གིས་བཟོ་དང་ལམ་ལུགས་རྫུན་མ་ཚུ་བཏོན་གཏངམ་ཨིན། དེ་གི་མ་ཚད་ ས་སྟོང་དཀརཔོ་ཡོད་མི་དང་རྩ་སྒྲིག་བསྒྱུར་བཅོས་ཚུ་ཡང་འབདཝ་ཨིན། སེམས་ཁར་བཞག་ ཨ་ནི་འགྱུར་བཏུབ་ཚུ་ག་ར་ཅིག་ཁར་བཟོ་བཀོད་ཀྱི་གནས་སྟངས་ནང་འབད་ལཱ་འབད་བ་ཅིན་ནུཧ་ཤུགས་མི་འཐོན་ འདི་འབདཝ་ད་CSS.ལུ་དེ་ཕན་པ་ཡོད།';
$string['enabled'] = 'ལྕོགས་ཅན་བཟོ་ཡོདཔ།';
$string['enabledevicedetection'] = 'དངོས་ཆས་བརྟགས་དཔྱད་དོན་ལུ་ ལྕོགས་ཅན་བཟོ།';
$string['enablegravatar'] = 'Gravatar ལྕོགས་ཅན་བཟོ།';
$string['enablegravatar_help'] = 'Moodle ལྕོགས་ཅན་བཟོ་བའི་སྐབས་ ལག་ལེན་པའི་གསལ་སྡུད་སྤར་འདི་སྐྱེལ་བཙུགས་འབད་དེ་མེད་པ་ཅིན་Gravatar  ནང་ལས་འབག་འོང་།';
$string['enablegroupmembersonly'] = 'སྡེ་ཚན་གྱི་འཐུས་མི་ཚུ་རྐྱངམ་ཅིག་ ལྕོགས་ཅན་བཟོ།';
$string['enablemobilewebservice'] = 'ཝེབ་སར་བར་གྱིས་འགྲུལ་འཕྲིན་ཅ་ཆས་ལུ་བཏུབ་སྦེ་
ལྕོགས་ཅན་བཟོ།།';
$string['enablerecordcache'] = 'དྲན་ཐོ་འདྲ་མཛོད་ ལྕོགས་ཅན་བཟོ།';
$string['enablerssfeeds'] = 'ཨར་ཨེསི་ཨེསི་མཁོ་སྤྲོད་འབད་ནི་ཚུ་ ལྕོགས་ཅན་བཟོ།';
$string['enablesafebrowserintegration'] = 'ཉེནམེད་ཆོས་རྒྱུགས་བརའུ་ཟར་མཉམ་སྒྲིལ་ ལྕོགས་ཅན་བཟོ།';
$string['enablestats'] = 'ཚད་རྩིས་ ལྕོགས་ཅན་བཟོ།';
$string['enabletgzbackups'] = 'རྒྱབ་སྣོན་བཟོ་བཀོད་དང་འབྲི་བཀོད་ ལྕོགས་ཅན་བཟོ།';
$string['enabletgzbackups_desc'] = 'ཆོག་ལྡེ་འཕྱེ་སྟེ་ཡོད་པ་ཅིན་ མ་འོངས་པའི་གྲབ་ཉར་ཚུ་ བསྡུ་སྒྲིག་རྣམ་བཞག་ནང་ mbz files (internally stored as a .tar.gz file).སྦེ་སྲོག་བཞག་་བཟོ་སྡོད་འོང་། ཨ་ནི་དེ་གིས་ ་མི་གྲབ་ཉར4GB འབད་བཀག་ཚད་དེ་མེདཔ་བཟོཝ་ཨིན་ དེ་བཞིན་ གཤིས་ནུས་དེ་ ཡར་དྲག་གཏངམ་ཨིན། སླར་ལོག་གསོ་འཇོག་འབད་མི་དེ་གིས་ ལག་ལེན་པ་ཚུ་ལུ་ སྒྲིག་བཀོད་དང་ ཁྱད་པར་གཉིས་ཆ་རང་ གདངས་གསལ་སྦེ་སྡོད་བཅུགཔ་ཨིན།';
$string['enabletrusttext'] = '་གཏད་ཅན་གྱི་ནང་དོན་ ལྕོགས་ཅན་བཟོ།';
$string['enablewebservices'] = 'ཝེབ་གི་ཞབས་ཏོག་ ལྕོགས་ཅན་བཟོ།';
$string['enablewsdocumentation'] = 'ཝེབ་ཞབས་ཏོག་གི་ཡིག་ཆ་བཞག།';
$string['enrolinstancedefaults'] = 'སྔོན་སྒྲིག་ཐོ་བཀོད་འབད་ས།';
$string['enrolinstancedefaults_desc'] = 'སློབ་ཚན་གསར་པའི་ནང་ལུ་ སྔོན་སྒྲིག་འཛུལ་ཞུགས།';
$string['enrolmultipleusers'] = 'ལག་ལེན་པ་ཚུ་ འཛུལ་ཞུགས་འབད།';
$string['environment'] = 'གནས་སྟངས།';
$string['environmenterrortodo'] = 'འ་ནི་མུ་ཌེལ་ཐོན་རིམ་འདི་འཕྲོ་མཐུད་དི་གཞི་བཙུགས་མ་འབད་བའི་ཧེ་མ་ ཁྱོད་ཀྱི་གོང་གི་གནས་སྟངས་ཀྱི་དཀའ་ངལ་(འཛོལ་བ་)་ཚུ་སེལ་དགོ།!';
$string['environmenterrorupgrade'] = 'ཉེན་བརྡ:འ་ནི་མུ་ཌེལ་ཐོན་རིམ་འདི་འཕྲོ་མཐུད་དི་གཞི་བཙུགས་མ་འབད་བའི་ཧེ་མ་ ཁྱོད་ཀྱི་གོང་གི་གནས་སྟངས་ཀྱི་དཀའ་ངལ་(འཛོལ་བ་)་ཚུ་སེལ་དགོ།!དགོས་མཁོ་འདི་ཚུ་མ་བཅོ་བ་ཡར་བསྐྱེད་འབད་བ་ཅིན་ རྒྱུ་རྐྱེན་ གནས་སྡུད་བྱང་སྟོར་འདི་བཟུམ་འབྱུང་འོང་། ཡར་བསྐྱེད་འཕྲོ་མཐུད་ནི་ ངེས་གཏན་ཨིན་ན?';
$string['environmentmustfixsetting'] = 'PHP གཞི་སྒྲིག་དེ་སོར་དགོ་པས།';
$string['environmentok'] = 'ཁྱོད་ཀྱི་ སར་བར་གནས་སྟངས་ཀྱི་ཉུང་མཐའ་དགོས་མཁོ་ཆ་མཉམ་ཚང་ཡོད།';
$string['environmentrecommendcustomcheck'] = 'འ་ནི་བརྟག་ཞིབ་ཀྱི་འཐུས་ཤོར་བྱུང་པ་ཅིན་ དཀའ་ངལ་ཡོད་པའི་བརྡ་སྟོན་ཨིན།';
$string['environmentrecommendinstall'] = 'གྲུབ་འབྲས་ལེགས་ཤོས་ཀྱི་དོན་ལུ་གཞི་བཙུགས་འབད་དི་ལྕོགས་ཅན་བཟོ་དགོ།';
$string['environmentrecommendversion'] = 'ཐོན་རིམ་ {$a->needed}་འདི་འོས་སྦྱོར་ཡོདཔ་ལས་ ཁྱོད་ཀྱི་{$a->current}་གཡོག་བཀོལ་བའི་བསྒང་ཡོད།';
$string['environmentrequirecustomcheck'] = 'བརྟག་ཞིབ་འདི་མཐར་འཁྱོལ་དགོ།';
$string['environmentrequireinstall'] = 'གཞི་བཙུགས་འབད་དི་ལྕོགས་ཅན་བཟོ་དགོ།';
$string['environmentrequireversion'] = 'ཐོན་རིམ་  {$a->needed}དགོས་མཁོ་ཡོདཔ་ལས་ ཁྱོད་ཀྱི་ {$a->current}གཡོག་བཀོལ་བའི་བསྒང་ཡོད།';
$string['environmentsettingok'] = 'གཞི་སྒྲིག་འབད་དགོཔ་འཐོན་འདུག།';
$string['environmentshouldfixsetting'] = 'PHP གཞི་སྒྲིག་འདི་སོར་དགོ་པས།';
$string['environmentxmlerror'] = 'མཐའ་འཁོར་གནས་སྡུད་ལྷག་པའི་བསྒང་ འཛོལ་བ་འབྱུང་ཡོད།({$a->error_code})';
$string['errordeletingconfig'] = 'ནོར་བ་འཐོན་ཡོད་ རིམ་སྒྲིག་ཐོ་བཀོད་ཀྱི་བསད་པའི་བསྒང་\'{$a}\'.';
$string['errorsetting'] = 'གཞི་སྒྲིག་ སྲུངས་མ་ཚུགས།';
$string['errorwithsettings'] = 'གཞི་སྒྲིག་ལ་ལོ་ཅིག་ འཛོལ་བ་བྱུང་ཡོདཔ་ལས་བསྒྱུར་བཅོས་འབད་མ་བཏུབ།';
$string['everyonewhocan'] = 'གེ་ར་ ག་གི་འབད་ཚུགསཔ་ \'{$a}';
$string['exceptions'] = 'བསྟུན་མ་དགོ་མི།';
$string['execpathnotallowed'] = 'config.php གྱི་དོན་ལས་ གཞི་སྒྲིག་བསྟར་སྤྱོད་འབད་ནི་གི་ལམ་འདི་ ལྕོགས་མིན་བཟོ་ཡོདཔ།';
$string['experimental'] = 'མོ་བཏབ་ཀྱི།';
$string['experimentalsettings'] = 'གཞི་སྒྲིག་མོ་བཏབ།';
$string['extendedusernamechars'] = 'ལག་ལེན་པའི་མིང་ནང་རྒྱ་བསྐྱེད་ཅན་གྱི་ཡིག་འབྲུ་ཚུ་བཙུག་ཆོག།';
$string['extramemorylimit'] = 'པི་ཨེཆ་པི་དྲན་ཚད་ཐེབས་ཀྱི་ཚད།';
$string['fatalmagicquotesruntime'] = 'རིམ་སྒྲིག་  <p> ནང་ལུ་འཛོལ་བ་ཚབས་ཆེན་ཅིག་བྱུང་ཡོདཔ་ལས་  ཞིབ་འཇུག་པའི་བདག་སྐྱོང་པ་ལུ་ དྲན་སྐུལ་འབད་གནང་། </p><p> ལེགས་ཤོམ་སྦེ་ལཱ་འབད་ཐབས་ལུ་ Moodle འདི་ ཞིབ་འཇུག་པའི་བདག་སྐྱོང་པ་གིས་ PHP གཞི་སྒྲིག་དེ་ཚུ་ སོར་དགོ།';
$string['fatalsessionautostart'] = '</p><p><code>session.auto_start</code> དེ་ <code>off</code>.</p><p> ལུ་སྒྱུར་བཅོས་འབད་དགོ། ཨ་ནི་གཞི་སྒྲིག་དེ་ <code>php.ini</code>, Apache/IIS <br />configuration or <code>.htaccess</code> file on the server.</p> ཞུན་དག་འབད་མི་གིས་ དམ་འཛིན་འབདཝ་ཨིན།';
$string['filecreated'] = 'ཡིག་སྣོད་གསཡཔ་ གསར་བསྐྲུན་འབད་ཡོད།';
$string['filestoredin'] = 'ཡིག་སྣོད་འདི་སྣོད་འཛིན་ནང་སྲུངས།';
$string['filestoredinhelp'] = 'ཡིག་སྣོད་དེ་ག་སྟེ་བསྲུང་བཞག་ན།';
$string['filterall'] = 'ཡིག་རྒྱུན་ཚུ་ཆ་མཉམ་བཙགས།';
$string['filtermatchoneperpage'] = 'མཐུན་སྒྲིག་འདི་ཚར་གཅིག་ཤོད་ལེབ་རེ་རེ་འབད་བཙགས།';
$string['filtermatchonepertext'] = 'མཐུན་སྒྲིག་འདི་ཚར་གཅིག་ཚིག་ཡིག་རེ་རེ་འབད་བཙགས།';
$string['filters'] = 'ཚགས་མ།';
$string['filtersettings'] = 'ཚགས་མ་ཚུ་ འཛིན་སྐྱོང་འབད།';
$string['filtersettingsgeneral'] = 'ཡོངས་ཁྱབ་ ཚགས་མའི་གཞི་སྒྲིག་ཚུ།';
$string['filteruploadedfiles'] = 'སྐྱེལ་བཙུགས་འབད་ཡོད་པའི་ཡིག་སྣོད་ བཙགས།';
$string['forcelogin'] = 'ལག་ལེན་པ་ཚུ་ལུ་ནང་བསྐྱོད་ འབད་བཅུག།';
$string['forceloginforprofileimage'] = 'ལག་ལེན་པ་ཚུ་ལུ་ ལག་ལེན་པ་ཚུ་གི་སྤར་ལྟ་ནིའི་དོན་ལུ་བང་བཙོང་སྟེ་ནང་བསྐྱོད་འབད་བཅུག';
$string['forceloginforprofileimage_help'] = 'ལྕོགས་ཅན་བཟོ་བ་ཅིན་ ལག་ལེན་པ་ཚུ་གིས་ལག་ལེན་པའི་གསལ་སྡུད་དང་སྤར་ཚུ་དང་་སྔོན་སྒྲིག་ཡོད་པའི་ལག་ལེན་པའི་སྤར་དེ་ཚུ་གློག་འཕྲིན་གྱི་ཁྱབ་བསྒྲགས་ནང་་ལག་ལེན་འཐབ་འོང་།';
$string['forceloginforprofiles'] = 'ལག་ལེན་པ་ཚུ་ལུ་གསལ་སྡུད་ཀྱི་དོན་ལུ་ནང་བསྐྱོད་ འབད་བཅུག།';
$string['forcetimezone'] = 'སྔོན་སྒྲིག་ཆུ་ཚོད་གླིང་སྡེ་ བཞག།';
$string['formatuninstallwithcourses'] = 'ནཱ་ལུ་ {$a->count} ལག་ལེན་སློབ་ཚན་ {$a->format}. ཁོང་གི་སྒྲིག་བཀོད་དེ་སོར་ཏེ་ {$a->defaultformat} (སྔོན་སྒྲིག་ས་སྒོ་གི་སྒྲིག་བཀོད). དམིགས་བསལ་གྱི་སྒྲིག་བཀོད་གནས་སྡུད་ལ་ལུ་ཅིག་བྱང་འོང་། ཁྱོད་ཐད་རི་པ་རི་འདི་འབད་ནི་ཨིན་ན?';
$string['frontpage'] = 'གདོང་ ཤོག།';
$string['frontpagebackup'] = 'གདོང་ ཤོག་རྒྱབ་ཐག།';
$string['frontpagedefaultrole'] = 'སྔོན་སྒྲིག་ གདོང་ཤོག་གི་ལས་འགན།';
$string['frontpagefilters'] = 'གདོང་ཤོག་གི་ཚགས་མ།';
$string['frontpageloggedin'] = 'ནང་བསྐྱོད་འབད་ཚར་བའི་་བསྒང་གི་ གདོང་ཤོག་གི་རྣམ་གྲངས་ཚུ།';
$string['frontpageoverrides'] = 'གདོང་ཤོག་གུར་བསྒྱུར་བཅོས་འབད་ནིའི་དབང་ཚད་བཀག་ཆ།';
$string['frontpagequestions'] = 'གདོང་ཤོག་གི་ དྲི་བ་ཚུ།';
$string['frontpagerestore'] = 'གདོང་ཤོག་གི་ སོར་ཆུད།';
$string['frontpageroles'] = 'གདོང་ཤོག་གི་ ལས་འགན་ཚུ།';
$string['frontpagesettings'] = 'གདོང་ཤོག་གི་ གཞི་སྒྲིག་ཚུ།';
$string['fullnamedisplay'] = 'མིང་ཆ་ཚང་ རྩ་སྒྲིག།';
$string['fullnamedisplayprivate'] = 'མིང་ཧྲི་བུ་གི་ འབྲི་བཀོད - སྒེརདབང་།';
$string['gdrecommended'] = 'GD རྒྱ་བསྐྱེད་འདི་ གཟུགས་བརྙན་གྱི་གཞི་བསྒྱུར་ལག་ལེན་འཐབ་ཡོདཔ་ གལ་སྲིད་བརླག་སྟོར་ཞུགས་པ་ཅིན་ ཁྱད་ཆོས་ལ་ལོ་ཅིག་ ལག་ལེན་པའི་གསལ་སྡུད་བཟུམ་མའི་གཟུགས་བརྙན་དེ་གི་ ཐོབ་ཆོག་ཆོག་མི་འོང་།';
$string['gdrequired'] = 'པར་བསྒྱུར་བཅོས་ཀྱི་དོན་ལུ་ Moodle ལུ་ GD རྒྱ་སྐྱེད་དེ་དགོ།';
$string['generalsettings'] = 'ཡོངས་ཁྱབ་ གཞི་སྒྲིག་ཚུ།';
$string['geoipfile'] = 'ཇིབོ་ཨའི་པི་སི་ཊི་ གནས་སྡུད་ཡིག་སྣོད།';
$string['getremoteaddrconf'] = 'ནང་བསྐྱོད་ཨའི་པི་ ཁ་བྱང་གི་འབྱུང་ཁུངས།';
$string['globalswarning'] = '<p><strong>སྲུང་སྐྱོབ་ཉེན་བརྡ་ </strong>: ཚུལ་ལྡན་འབད་གཡོག་བཀོལ་ནི་ མུ་དྲིལ་དགོས་མཁོ་ཡོད་མི་ཚུ་<br />དེ་ཁྱོད་ཀྱི་ འཕྲལ་གྱི་པི་ཨེཆ་པི་གཞི་སྒྲིག་ལུ་ངེས་བདེན་བསྒྱུར་བཅོས་འབད་དགོ།.<p/><p>ཁྱོད་<em>དགོཔ་</em> གཞི་སྒྲིག་<code>register_globals=off</code>>.</p><p> གཞི་སྒྲིག་དེ་ཚུ་ ཁྱོད་ཀྱི་ཞིབ་དཔྱད་དེ་གི་ཚད་འཛིན་འབད་ཡོདཔ་<code>php.ཨའི་ཨེན་ཨའི་</code>,ཨེ་པེཆ/ཨའི་ཨའི་ཨེས་ <br />རིམ་སྒྲིག་འབད་ཡང་ན་ <code>.ཨེཆ་ཀྲི་འཛུལ་བསྐྱོད་</code> ཡིག་སྣོད.</p>';
$string['googlemapkey3'] = 'Google Maps API V3 ལྡེ་མིག';
$string['googlemapkey3_help'] = 'ཁྱོད་ཀྱིས་Google Maps for IP address lookup visualizationདམིགས་བསལ་གྱི་ལྡེ་མིག་གཅིག་ལག་ལེན་འཐབ་དགོ། ཁྱོད་ཀྱིས་ལྡེ་མིག་དེ་རིན་མེད་སྟོང་པ་སྦེ་<a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>ལས་འཐོབ་ཚུགས།';
$string['gotofirst'] = 'བརླག་སྟོར་ཞུགས་པའི་ཡིག་རྒྱུན་དང་པ་ལུ་ འགྱོ།';
$string['gradebook'] = 'སྐུགས་ཀྱི་ ཀི་དེབ།';
$string['gradebookroles'] = 'སྐུགས་བྱིན་ཡོད་པའི་ ལས་འགན་ཚུ།';
$string['gradeexport'] = 'ཞི་རིམ་སྐུག་ཕྱིར་འདྲེན་འབད་ནིའི་ཐབས་ལམ་ཚུ།';
$string['gravatardefaulturl'] = 'Gravatar སྔ་སྒྲིག་པར་ག་གི  URL';
$string['gravatardefaulturl_help'] = 'Gravatar ལུ་སྔོན་སྒྲིག་གི་སྤར་གཅིག་གསལ་སྟོན་འབད་གོ་ ག་དེམ་ཅིག་འབད་ལག་ལེན་པ་གིས་སྤར་མ་འཐོབ་པ་ཅིན། སྤར་གྱི་དོན་ལུ་URLཆ་ཚང་གོཅིག་སྤྲོད།གལ་སྲིད་ཁྱོད་ཀྱིས་གཞི་སྒྲིག་དེ་སྟོངམ་སྦེ་བཞག་པ་ཅིན་ Moodleགིས་སྔོན་སྒྲིག་གི་སྤར་ག་འོས་ཅན་གཅིག་ཁྱོད་ཀྱིས་ལྟ་མའི་ཤོག་ལེབ་གུར་སྟོན་འོང་། སེམས་ཁར་བཞག་Gravatar ལུ་ལག་ལེན་འཐབ་བཏུབ་པའི་codes ལེ་ཤ་ར་<a href="https://en.gravatar.com/site/implement/images/#default-image">generate default images</a>.ཡོད།';
$string['groupenrolmentkeypolicy'] = 'སྡེ་ཚན་འཛུལ་ཞུགས་ཀྱི་ལམ་ལུགས།';
$string['groupenrolmentkeypolicy_desc'] = 'ཨ་ནི་དེ ་བསྒྱུར་བཏུབ་བཟོ་བའི་བསྒང་ལས་Moodle སྡེ་ཚན་དབྱེ་ཞིབ་ནང་འཛུལ་ཞུགས་ཀྱི་དོན་ལུ་ཁུག་གཏུག་གི་ཆོག་ཡིག་ལམ་ལུགས་ཐོབ།';
$string['guestroleid'] = 'མགྱོནམ་གྱི་ ལས་འགན།';
$string['guestroleid_help'] = 'ཨ་ནི་ལས་འགན་འདི་རང་བཞིན་གྱིས་མགྱོནམ་སྦེ་ལག་ལེན་འཐབ་མི་ལུ་ཨིན། གཞན་ཡང་ གནས་སྐབས་ཅིག་གི་དོན་ལུ་མགྱོནམ་སྦེ་སློབ་ཚན་ནང་ལུ་འཛུལ་ཞུགས་འབད་དེ་ཡོད་མི་via guest enrolment plugin.ཚུ་གི་དོན་ལུ་ཡང་ཨིན།';
$string['helpadminseesall'] = 'བདག་སྐྱོང་གི་ཟླ་ཐོ་ནང་ཡོད་པའི་བྱུང་ལས་གེ་ར་བལྟ་ད་ ཡང་ན་ གོང་གི་དེ་ཚུ་ཁོང་ལུ་ འཇུག་སྤྱོད་འབད་ནི་ཨིན་ན?';
$string['helpcalendarcustomexport'] = 'ཟླ་ཐོ་ནང་ལུ་  ཟླ་ཚད་འཆར་གཞི་གི་བར་ཚད་ རང་འདོད་བསྟར་སྤྱོད་ནི་གི་ཕྲིར་སྐྱེད་དེ་ ལྕོགས་ཅན་བཟོ། ཟླ་ཐོ་ཕྱིར་སྐྱེད་དེ་ ཨ་ནི་ལག་ལེན་ནུས་པ་ཅན་མ་འགྱོཝ་ལས་ ལྕོགས་ཅན་བཟོ་དགོ།';
$string['helpexportlookahead'] = 'རང་འདོད་བསྟར་ཕྱིར་སྐྱེད་འབད་བའི་སྐབས་ ཟླ་ཐོ་དེ་གིས་ མ་འོངས་པ་ལུ་ ཉིན་གྲངས་ ག་དེ་ཅིག་རྒྱབ་སྐྱོར་འབདཝ་སྨོ།';
$string['helpexportlookback'] = 'རང་འདོད་བསྟར་ཕྱིར་སྐྱེད་འབད་བའི་སྐབས་ ཟླ་ཐོ་དེ་གིས་ འབས་པའི་དུས་ལུ་ ཉིན་གྲངས་ ག་དེ་ཅིག་རྒྱབ་སྐྱོར་འབད་ཡི།';
$string['helpforcetimezone'] = 'ཁྱོད་ཀྱི་ལག་ལེན་པ་རེ་རེ་གི་འབད་ ཁོང་རའི་ཆུ་ཚོད་གླིང་སྡེ་གདམ་འཐུ་ འབད་དེ་ལག་ལེན་འཐབ་ཆོག། ཡང་ན་ གེ་་ར་གི་དོན་ལུ་ བང་ཅན་གྱི་ཆུ་ཚོད་གླིང་སྡེ་ལུ་གདམ་འཐུ་འབད་ཆོག།';
$string['helpshowicalsource'] = 'ག་དེམ་ཅིག་འབད་ ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ མངགས་རིགས་གི་མིང་དང་ འབྲེལ་མཐུད་དེ་ iCal ནང་སྐྱེད་ནང་ དངོས་སྟོན་འབད་སྡོད་འོང་།';
$string['helpsitemaintenance'] = 'ཡར་བསྐྱེད་དང་གཞན་མི་ལཱ་གི་དོན་ལུ་';
$string['helpstartofweek'] = 'ཟླ་ཐོ་དེ་ནང་བདུན་ཕྲག་ གཟའ་ག་འདི་གི་འགོ་བཙུགས་སྨོ?';
$string['helpupcominglookahead'] = 'རིམ་སྒྲིག་དེ་གི་ མ་འོངས་པ་ནང་ཉིནམ་ག་དེམ་ཅིག་གི་ ཟླ་ཐོ ཤུལ་ལས་འོང་ནིའི་བྱུང་ལས་བལྟ་ ནིའི་དོན་ལུ་ འབད་དགོཔ་སྨོ?';
$string['helpupcomingmaxevents'] = 'ག་དེམ་ཅིག་ (མཐོ་ཤོས)ཤུལ་ལས་འོང་ནིའི་བྱུང་ལས་དེ་ཚུ་ ལག་ལེན་པའི་རིམ་སྒྲིག་དི་འཁྲིལ་བཏོན་ཡི་ག?';
$string['helpweekenddays'] = 'བདུན་ཕྲག་གི་ཉིནམ་ག་ཅི་ཚུ་ བརྩི་འཇོག་འབད་དོ་བཟུམ་ བདུན་མཐའ་ ནང་དང་ཚོས་གཞི་མ་འདྲཝ་གཅིག་ཁར་བཏོན་ནི་ཨིན་ན?';
$string['hiddenuserfields'] = 'ལག་ལེན་པའི་ས་སྒོ་ཚུ་ སྦ།';
$string['hidefromall'] = 'ལག་ལེན་པ་ཆ་མཉམ་ལས་ སྦ།';
$string['hidefromnone'] = 'མི་ག་ཡང་མེདཔ་ལས་ སྦ།';
$string['hidefromstudents'] = 'སློབ་ཕྲུག་ཚུ་ལས་ སྦ།';
$string['htmleditor'] = 'HTMLཞུན་དགཔ།';
$string['htmleditorsettings'] = 'HTML ཞུན་དག་གཞི་སྒྲིག།';
$string['htmlsettings'] = 'ཨེཆ་ཊི་ཨེམ་ཨེལ་ གཞི་སྒྲིག';
$string['http'] = 'ཨེཆ་ཊི་ཊི་པི།';
$string['httpsecurity'] = 'ཨེཆ་ཊི་ཊི་པི་ སྲུང་སྐྱོབ།';
$string['hubs'] = 'ལྟེ་བ།';
$string['iconvrecommended'] = 'དམིགས་བསལ་དུ་ གལ་སྲིད་ས་ཁོངས་དེ་ ལ་ཀྲིན་ཁ་སྐད་མེད་མི་ལུ་རྒྱབ་སྐྱོར་འབད་བ་ཅིན། གདམ་ཁ་ཅན་གྱི་གཞི་བཙུགས་འབད་ནི་ ཨའི་སི་ཨོ་ཨེན་བི་ འདི་འོས་སྦྱོར་སྦོམ་འབད་ས་ཁོངས་ལཱ་ཤུགས་ཡར་དྲག་དང་འཁྲིལཝ་ད་ལུ་ལའ་འབད་ནི།';
$string['iconvrequired'] = 'ཨཡེ་སི་ཨོ་ཨེན་ཝི་ གཞི་བཙུགས་འབད་ནིའི་ རྒྱ་བསྐྱེད་དགོས་མཁོ་ཡོདཔ་དགོ་འབད།';
$string['ignore'] = 'སྣང་མེད་བཞག';
$string['includemoduleuserdata'] = 'ཚད་གཞི་ལག་ལེན་པའི་གནས་སྡུད་ གྲངས་སུ་བཙུགས།';
$string['incompatibleblocks'] = 'མི་མཐུན་པའི་ སྡེབ་ཚན་ཚུ།';
$string['installhijacked'] = 'དགོངམ་མ་འཁྲེལ། བཙུག་སྒྲིག་འབད་ནི་འདི་IP ཁ་བྱང་ངོ་མ་ནང་ལས་ར་འབད་དགོ།';
$string['installsessionerror'] = 'PHP session ལཱ་འབད་མི་བཏུབ་པས་ ཁྱོད་གྱི་བརའི་ཟར་གིས་ cookies ངོས་ལེན་འབད་དགོ་འབད།';
$string['intlrecommended'] = 'མགོ་ཐོག་གི་རྒྱ་བསྐྱེད་ལག་ལེན་འཐབ་མི་འདི་འཛམ་གླིང་རྒྱལ་སྤྱིའི་རོགས་རམ་ དཔེར་ན་locale aware sorting་ཚུ་ཐོབ་ནིའི་དོན་ལུ་ཨིན།';
$string['invalidsection'] = 'ནུས་པ་མེད་པའི་ དབྱེ་ཚན།';
$string['invaliduserchangeme'] = 'ལག་ལེན་པའི་མིང་"changeme"་འདི་ཟུར་གསོག་འབད་ཡོད།-- འདི་གི་ཐོག་ལས་ ཁྱོད་ཀྱི་ རྩིས་ཐོ་གསར་བསྐྲུན་འབད་མི་ཚུགས།';
$string['ipblocked'] = 'ནཱ་གི་ས་སྒོ་ནང་ད་ལྟོ་ལཱ་འབད་མི་བཏུབ་པས།';
$string['ipblocker'] = 'IP བཀག་མི།';
$string['ipblockersyntax'] = 'འཛུལ་ཞུགས་འབད་མི་ཚུ་ག་ར་གྱལ་ཅིག་གི་ནང་བཙུགས།. ཁུང་གཏུག་གི་འཛུལ་ཞུགས་འབད་མི་ཚུ་IP ཁ་བྱང་ག་ར་འབད་མི་ (དཔེར་ན་ <b>192.168.10.1</b>) སྦེ་གནསཔ་གཅིག་དང་མཐུན་སྒྲིག་ཡོད་མི་དང་ཡང་ན་ཁ་བྱང་ཨ་ཙི་སྒྲིག་མི་ (དཔེར་ན་ <b>192.168.</b>) ཁ་བཡང་ག་འབད་རུང་ཨང་ཡིག་ཨ་ཕི་ཚུ་དང་མཐུན་མི་ཡང་ན་ CIDR notation (དཔེར་ན། <b>231.54.211.0/20</b>); ཡང་ན་  IP ཁ་བྱང་གི་ཚད་ (དཔེར་ན་ <b>231.3.56.10-20</b>) སྦེ་མཇུག་གི་ཁ་བཡང་གི་ཚད་ལུ་ལྷོད་མི་ ཚིག་ཡིག་གིས་དབང་ཆ་ཡོད་པའི་མིང་ (དཔེར་ན་ \'example.com\') ཚུ་གྱབ་སྐྱོར་ཡོད། གྱལ་ས་སྟོང་ཡོད་མི་ཚུ་ལྟ་ནི་མེད།.';
$string['iplookup'] = 'ཨའི་པི་ཁ་བྱང་ བལྟ་བ།';
$string['iplookupgeoplugin'] = '<a href="http://www.geoplugin.com">geoPlugin</a> service is currently being used to look up geographical information. For more accurate results we recommend installing a local copy of the MaxMind GeoLite database.';
$string['iplookupinfo'] = 'མ་སྒྲིག་དེ་གི་ མུ་དྲིལ་ལག་ལེན་འདི་ བར་སྟོང་གློག་ལམ་ཐོག་ལུ་ ནེཀྲི་ཇིཨོ་ (ཨིན་ཀྲར་ནེདྲ་ ས་ཆའི་རིགས་ཀྱི་གནས་སྡུད་གཞི་རྟེན)སར་བར་གྱི་ ཉེ་གནས་ཀྱི་བལྟ་བ་ ཨའི་ཁ་བྱང་ཚུ་ གནས་སྡུད་གཞི་རྟེན་འདི་ ཁ་རྗེ་མེདཔ་ལས་བརྟེན་ རྒྱུན་སྐྱོང་གནམ་མེད་ས་མེད་མ་འབདཝ་ལས་ ལོག་ཡང་ན་ འོང་ནི་འོང་ <em>ཝེལདྲ་ལི་ མ་བདེནམ་འབད་ </em>གནས་སྡུད། མེཀས་མའིནདྲ་ལས་འོང་བའི་ བར་སྟོང་ཇིཨོ་ལེའིདྲ་ གྲོང་སྡེའི་གནས་སྡུད་གཞི་རྟེན་ ཉེ་གནས་འདྲ་བཤུས་གཞི་བཙུགས་འབད་ནི་ལུ་ འོས་སྦྱོར་འབད་ཡོདཔ་ཨིན།.<br /> ཨའི་པི་ ཁ་བྱང་གནས་ཁོངས་འདི་ འཇམ་སམ་ས་ཁར་ཡང་ན་ གུ་གུལ་མེཔ་ཚུ་ལུ་ བཀྲམ་སྟོན་འབད་ཡོདཔ་ཨིན། ཁྱོད་ལུ་ཡོད་པའི་ གུ་གུལ་རྩིས་ཐོ་དང་ བར་སྟོང་གུ་གུལ་ས་ཁྲ་ཨེ་པི་ཨའི་ལུ་འཇུག་སྤྱོད་འབད་ནིའི་དོན་ལུ་ ཨེ་པི་ཨའི་སྡེ་མིག་ ལུ་ ས་ཁྲ་ལུ་འབྲེལ་མཐུད་འབད་ནིའི་ལྕོགས་ཅན་བཟོ་དགོཔ་ཨིན།';
$string['iplookupmaxmindnote'] = 'ཐོན་སྐྱེད་འདི་ ཇཱིའོ་ལཡེཊ་ གནས་སྡུད་ མཱེསི་མཡེཌི་གི་གསར་བསྐྲུན་འབད་ཡོད་པའི་གྲངས་སུ་བཙུགས་ནི་ <a href="http://www.maxmind.com/">http://www.maxmind.com/</a> འདི་ལས་འཐོབ་ཚུགས།';
$string['keeptagnamecase'] = 'ངོ་རྟགས་མིང་ཤུབས་ བདག་འཛིན་སྦེ་བཞག།';
$string['lang'] = 'སྔོན་སྒྲིག་ སྐད་ཡིག།';
$string['langcache'] = 'སྐད་ཡིག་དཀར་ཆག་ འདྲ་མཛོད་འབད།';
$string['langcache_desc'] = 'སྐད་ཡིག་གི་གློག་རིམ་དཀར་ཆག་ཚུ་དྲན་མཛོད་ནང་བཙུགས། གས་སྲིད་ལྕོགས་ཅན་བཟོ་བ་ཅིན་་སྐད་བསྒྱུ་འབད་ཡོད་པའི་ཐོ་ཚུ་དྲན་མཛོད་འབད་ཚུགས། དྲན་མཛོད་འདི་གི་རང་བཞིན་གྱིས་ ཁྱོད་ཀྱིས་སྐད་ཡིག་བཏོན་བཙུགས་འབད་བ་ཅིན་དེའི་སྐབས་ལོག་བསྐྱར་ལོག་འབད་འོང་།';
$string['langlist'] = 'སྐད་ཡིག་དཀར་ཆག་གུ་ལུ་ སྐད་ཡིག་ཚུ།';
$string['langmenu'] = 'སྐད་ཡིག་དཀར་ཆག་སྟོན།';
$string['langpackwillbeupdated'] = 'སྐད་བསྒྱུར་པ་ཚུ་ལུ་དྲན་གསོ་:ཡར་བསྐྱེད་འབད་བའི་བསྒང་མུ་ཌེལ་འདི་གིས་ཁྱོད་རའི་སྐད་ཡིག་སྦུང་ཚན་དུས་མཐུན་བཟོ་ནི་ལུ་འབད་རྩོལ་བསྐྱེད་འོང་། ཁྱོད་རའི་ལེགས་བཅོས་ཚུ་ ཉེ་གནས་མིན་པའི་སྐད་ཡིག་སྣོད་འཛིན་ནང་ཚབ་སྲུངས་འབད་ཡོདཔ་ཨིན།';
$string['langstringcache'] = 'སྐད་ཡིག་ག་ར་རྒྱུན་རིམ་དྲན་མཛོད་ནང་བཞག';
$string['languagesettings'] = 'སྐད་ཡིག་ གཞི་སྒྲིག་ཚུ།';
$string['latexpreamble'] = 'ལེ་ཊེགསི་གི་ གཞི་དོན།';
$string['latexsettings'] = 'ལེ་ཊེགསི་ལྷག་སྟོན་པ་གི་ གཞི་སྒྲིག།';
$string['latinexcelexport'] = 'ཨེགསི་སེལ་ ཨིན་ཀོ་ཌིང་།';
$string['legacyfilesaddallowed'] = 'སློབ་ཚན་མཛད་ཤུལ་ཐོ་དེབ་ ནང་ཁ་སྐོང་འབད་བཅུག';
$string['legacyfilesaddallowed_help'] = 'ག་དེམ་ཅིག་སྦེ་ སློབ་ཚན་ནང་ མཛད་ཤུལ་ཐོ་དེབ་ཡོད་པ་ཅིན་ ཡིག་རིགས་དང་ཡིག་སྣོད་ ཚུ་ཁ་སྐོང་འབད་བཅུག';
$string['legacyfilesinnewcourses'] = 'སློབ་ཚན་གསར་པའི་ནང་ལུ་ཤུལ་ལས་ཐོབ་པའི་སློབ་ཚན་གྱི་ཡིག་སྣོད།';
$string['legacyfilesinnewcourses_help'] = 'སྔོན་སྒྲིག་གིས་ ཤུལ་ལས་དོབ་པའི་སློབ་ཚན་ཡིག་སྣོད་ས་ཁོང་ཚུ་ལེགས་བཅས་འབད་ཡོད་པའི་སློབ་ཚན་ཚུ་ནང་རྐྱངམ་ཅིག་ལས་ཐོབ། གཞི་སྒྲིག་འདི་ནང་ལུ་ སྦྱོང་ལཱ་གཅིག་འབད་མི་དང་རྒྱབ་བསྣན་ བསྐྱར་གསོ་འབད་ནིའི་ལཱ་དང་ལས་རིམ་ཚུ་འདི་ནང་ལུ་མེད།';
$string['licensesettings'] = 'ཆོག་ཐམ་གྱི་གཞི་སྒྲིག';
$string['linkadmincategories'] = 'བདག་སྐྱོང་རྒྱུད་མཐུད་ཀྱི་དབྱེ་རིམ།';
$string['linkadmincategories_help'] = 'གལ་སྲིད་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ གཞི་སྒྲིག་དབྱེ་རིམ་འདི་གིས་ རྒྱུན་མཐུད་སྦེ་བདག་སྐྱོང་གི་དབྱེ་རིམ་ས་སྒོ་ནང་ལུ་གསལ་སྟོན་འབད་འོང་།';
$string['loading'] = 'སྐྱེལ་བཙུགས་འབད་དོ།';
$string['localetext'] = 'ས་ཁོངས་ཡོངས་ཀྱི་ ལོ་ཀེལ།';
$string['localstringcustomization'] = 'ཉེ་གནས་ཡིག་རྒྱུན་སྲོལ་སྒྲིག་འབད་ནི།';
$string['location'] = 'གནས་ཁོངས་';
$string['locationsettings'] = 'གནས་ཁོངས་ གཞི་སྒྲིག་ཚུ།';
$string['locked'] = 'བཀག་ཡོད་པ།';
$string['lockoutduration'] = 'རྩིས་ཐོ་ ལྡེ་བསྡམ་གི་དུས་ཚོད།';
$string['lockoutduration_desc'] = 'ལྡེ་བསྡམ་རྩིས་ཐོ་དེ་ དུས་ཡུན་དེ་གི་ཤུལ་ལས་རང་བཞིན་གྱིས་ ཕྱེ་སྡོད་འོང་།';
$string['lockoutemailbody'] = 'འབྲེལ་སྤྱོད་ \'{$a->sitename}\' ནང་ཡོད་མི་ ཁྱོད་ཀྱི་རྩི་ཐོ {$a->username} འཛོལ་ཞུགས་མང་རབས་ཅིག་འབད་བའི་ཤུལ་ ལྡེ་བསྡམ་འབད་དེ་ཡོད། འདི་འཕྲོ་ལས་ ལྡེ་བསྡམ་ཕྱེ་ནི་གི་དོན་ལུ་  {$a->link} འཛུལ་གནང་། ལས་རིམ་མང་ཤོས་ཅིག་ནང་ འབྲེལ་འཐུད་དེ་ ཧོནམོ་སྦེ་དངོས་སྟོན་འབད་ཡོདཔ་ཨིན། དེ་གུ་ཨེབ་ནི་རྐྱངམ་ཅིག་ཨིན། ག་དེམ་ཅིག་སྦེ་ འདི་གིས་མ་བཏུབ་པ་ཅིན་ ཁ་བྱང་དེ་འ་  ཁྱོད་རའི་གློག་རིག་འཚོལ་གཞི་གི་ མགུ་ལུ་ཡོད་ ཁ་བྱང་འཚོལ་སའི་ཐིག་སྒྲོམ་ནང་ དྲ་བཤུད་འབད། ག་དེམ་ཅིག་སྦེ་རོགས་རམ་དགོ་པ་ཅིན་ {$a->admin} བདག་སྐྱོང་པ་དང་ཅིག་ཁར་འབྲེལ་བ་འབད།';
$string['lockoutemailsubject'] = '{$a}ནང་ཡོད་པའི་་ཁྱོད་ཀྱི་རྩི་ཐོ་དེ་ ལྡེ་བསྡམ་འདུག';
$string['lockouterrorunlock'] = 'མ་བཏུབ་པའི་ ལྡེ་ཕྱི་གི་ བརྡ་དོན་སྤྲོད་ནུག';
$string['lockoutthreshold'] = 'རྩི་ཐོ་ ལྡེ་བསྡམ་སྒོ་ཐེམ། རྩི་ཐོ་ ལྡེ་བསྡམ་འཛུལ་སྒོ།';
$string['lockoutthreshold_desc'] = 'ཚར་ག་དེམ་ཅིག་མིན་པའི་ཐོག་ལས་ ནང་ན་འཛུལ་ནི་གིས་ དཔའ་བཅམ་སྟེ་ལྡེ་བསྡམ་སོང་ཡི་ག་ གདམ་ཁ་རྐྱབས། ཞབས་ཏོག་ཁས་མ་ལེན་མི་དེ་ ཁྱད་གནད་དེ་ ལོག་སྤྱོད་འབད་ཡོདཔ་ལས་ཨིན།';
$string['lockoutwindow'] = 'རྩི་ཐོ་ལྡེ་བསྡམ་ བལྟ་རྟོགས་ སྒོ་ཆ།';
$string['lockoutwindow_desc'] = 'སྒོ་ཞུགས་ལྡེ་བསྡམ་ བལྟ་རྟོགས་ཀྱི་དུས་ཡུན། ག་དེམ་ཅིག་སྦེ་མཐར་ཕྱིན་མེན་པའི་ དཔའ་བཅམ་སྟེ་མེད་པ་ཅིན་ སྒོ་ཞུགས་འབྲེལ་ངོ་དེ་ དུས་ཡུན་དེ་གི་ཤུལ་ལས་ སླར་ལོག་བཅོས་སྡོད་འོང་།';
$string['log'] = 'དྲན་དེབ་ཚུ།';
$string['logguests'] = 'མགྱོནམོ་འོང་པའི་དྲན་དེབ།';
$string['logguests_help'] = 'གཞི་སྒྲིག་འདི་གིས་ ནང་བསྐྱོད་ཡོད་པའི་ལག་ལེན་པ་ཚུ་མིན་པ་མགྱོནམ་ཚུ་ལུ་ལྕོགས་ཅན་བཟོ་འོང་། གལ་གནད་ཅན་གྱི་ས་སྒོ་ཚུ་གིས་ཨ་ནི་ས་སྒོ་འདི་ལག་ལེན་ལེགས་སྤྱོད་འབད་ཚུགས་པའི་དོན་ལུ་ལྕོགས་མིན་བཟོ་བཞགཔ་ཨིན། བཟོ་བསྐྲུན་གྱི་ས་སྒོ་ནང་ཨིན་པ་ཅིན་ལྕོགས་ཅན་བཟོ་བཞགཔ་དྲག།';
$string['loginhttps'] = 'ནང་བསྐྱོད་ཚུ་གི་དོན་ལུ་ཨེཆ་ཊི་ཊི་པི་ཚུ་་ལག་ལེན་འཐབ།';
$string['loginpageautofocus'] = 'ནང་བསྐྱོད་རང་བཞིན་གྱིས་དམིགས་གཏད་ཤོག་ལེབ་ཀྱི་སྒྲིག་བཀོད།';
$string['loginpageautofocus_help'] = 'ལྕོགས་ཅན་བཟོ་ནི་འདི་གིས་ ནང་བསྐྱོད་ཤོག་ལེབ་གྱི་ལག་ལེན་ཡར་རྒྱས་འགྱོ་འོང་།་ དེ་འབདཝ་ད་ རང་བཞིན་གྱིས་དམིགས་གཏད་འདི་ཐོབ་ག་མི་ཐོབ་ཀྱི་བསམ་བློ་གཏང་དགོ་པས།';
$string['loginpasswordautocomplete'] = 'ནང་བསྐྱོད་ཡོད་པའི་སྐབས་ ཆོག་ཡིག་རང་བཞིན་གྱིས་རྫོགས་ནི་ལས་བཀག་འཛིན་ཡབད་དགོ།';
$string['loginpasswordautocomplete_help'] = 'བསྒྱུར་མི་བཏུབ་ཡོད་ནི་འདི་གིས་ ལག་ལེན་པ་ཚུ་ཁོང་རའི་ཆོག་ཡིག་ ཁོང་རའི་བརའུ་སར་ནང་ལུ་སྲུང་བཞག་འོང་། གཞི་སྒྲིག་འདི་སོར་བ་ཅིན་ ཁྱོད་ཀྱི་ས་སྒོ་འདི་གིས་XHTML གི་ཁུངབ་གཏུགས་ཁྲིམས་ལུག་དང་མ་འཁྲིལཔ་འགྱོཝ་ཨིན།';
$string['loglifetime'] = 'དོན་ལུ་དྲན་དེབ་ཚུ་བཞག།';
$string['longtimewarning'] = 'b>དྲན་འཛིན་ འ་ནི་ལས་སྦྱོར་གྱི་ཡུན་རིངམ་འགོར་འོང་།</b>';
$string['maintenancemode'] = 'རྒྱུན་སྐྱོང་ཐབས་ལམ་ནང།';
$string['maintenancemodeisscheduled'] = 'གནས་ཁོངས་དེ་ རྒྱུན་སྐྱོང་གི་དོན་ལུ་ སྐར་ཆ་ {$a} ནང་ལུ་ ཤི་ཡལ་སྟེ་སྒྱུར་བཅོས་འབད་འོང་།';
$string['maintfileopenerror'] = 'རྒྱུན་སྐྱོང་ཡིག་སྣོད་ཚུ་ཁ་ཕྱེ་བའི་བསྒང་ འཛོལ་འདུག།';
$string['maintinprogress'] = 'རྒྱུན་སྐྱོང་འདི་འབད་བའི་བསྒང་ཨིན།..';
$string['manageformats'] = 'སློབ་ཚན་གྱི་སྒྲིག་བཀོད་འཛིན་སྐྱོང་འབད།';
$string['manageformatsgotosettings'] = 'སྔོན་སྒྲིག་གི་སྒྲིག་བཀད་འདི་{$a}ནང་སོར་ཚུགས།';
$string['managelang'] = 'འཛིན་སྐྱོང་འབད།';
$string['managelicenses'] = 'ཆོག་ཐམ་འཛིན་སྐྱོང་འབད།';
$string['manageqbehaviours'] = 'དྲི་བ་གི་གཞི་ཚུ་འཛིན་སྐྱོང་འབད།';
$string['manageqtypes'] = 'དྲི་བ་གི་དབྱེ་ཁ་ཚུ་འཛིན་སྐྱོང་འབད།';
$string['maturity100'] = 'ཡིག་རིག་གཉིས་པ།';
$string['maturity150'] = 'མི་ངོ་གཏང་།';
$string['maturity200'] = 'ཐོན་རིམ་རྩ་བརྟན།';
$string['maturity50'] = 'ཡིག་རིག་དང་པ།';
$string['maturityallowunstable'] = 'བརྡ་མཚོན། ཁྱོད་ཀྱིས་ཡིག་གུ་འདི་རྩ་བརྟན་མེད་པའི་གདམ་ཀ་གི་ཐོག་ལས་འཛིན་སྐྱོང་འབད་ད།';
$string['maturitycoreinfo'] = 'ཁྱོད་ཀྱི་ས་སྒོ་འདི་ད་ལྟོ་རྩ་བརྟན་མེད་པའི་འཛིན་སྐྱོང་"{$a}" གོང་འཕེལ་གསང་རྟགས་ནང་ལུ་འདུག།';
$string['maturitycorewarning'] = 'ཁྱོད་ཀྱིས་བཙུགས་ནི་ཨིན་པའི་ཐོན་རིམ་རྩ་བརྟན་མེད་མི་ བཟོ་བསྐྲུན་གྱི་ས་སྒོ་ནང་ལག་ལེན་འཐབ་ནི་ལུ་བྱ་སྟབས་བདེ་ཏོག་ཏོ་མེད་མི་"{$a}" development code དེ་ཁྱོད་ལུ་མུན་དགོ་པ་ཅིན་ ཁྱོད་ཀྱིས་ཐད་རི་པ་རི་ ཡར་བསྐྱེད་འདི་རྩ་བརྟན་ཡོད་པའི་Moodle གསང་རྟགས་ནང་ལས་བཟོ་དགོ། ཁ་གསལ་གྱི་དོན་ལུ་Moodle ཡིག་ཆ་ཚུ་ནང་ལྟ།';
$string['maxbytes'] = 'སྐྱེལ་བཙུགས་འབད་ཡོད་པའི་ཡིག་སྣོད་ཚད་ཀྱི་ མང་མཐའ།';
$string['maxconsecutiveidentchars'] = 'ཅོག་གཅིགཔ་སྦེའབྱེལཝ་འབྱེལ་ས་ཀྱི་ཡིག་འབྲུ།';
$string['maxeditingtime'] = 'གནས་བསྐྱོད་ཞུན་དག་འབད་ནི་དོན་ལུ་ཆུ་ཚོད་མང་མཐའ།';
$string['maxusersperpage'] = 'ལག་ལེན་པ་མཐོ་ཤོས་ཀྱི་ གནས་ཤོག';
$string['mbstringrecommended'] = 'གཞི་བཙུགས་འབད་ནི་དོན་ལུ་ གདམ་ཁ་ཅན་གྱི་ ཨེམ་བི་ཨིས་ཊིང་ དཔེ་མཛོད་འདི་ ས་ཁོངས་ཀྱི་ལཱ་ཤུགས་ལེགས་བཟོ་ བྱེ་བྲག་ཏུ་ཁྱོད་རའི་ས་ཁོངས་འདི་གིས་ ལེ་ཊིན་མིན་པའི་སྐད་ཡིག་རྒྱབ་སྐྱོར་ཚུ་ ཧ་ཅང་གིས་ངོ་སྦྱོར་འབད་ནི།';
$string['mediapluginavi'] = 'ཨེ་བིཧི་ཨའེ་ ཚགས་མ་ ལྕོགས་ཅན་བཟོ།';
$string['mediapluginflv'] = 'ཨེཕ་ཨེལ་བིཧི་ ཚགས་མ་ ལྕོགས་ཅན་བཟོ།';
$string['mediapluginimg'] = 'རྒྱུན་མཐུད་ཡོད་པའི་རང་བཞིན་ཅན་གྱི་གཟུགས་བརྙན་ལྕོགས་ཅན་བཟོ།';
$string['mediapluginmov'] = 'ཨེམ་ཨོ་བིཧི་ཚགས་མ་ ལྕོགས་ཅན་བཟོ།';
$string['mediapluginmp3'] = 'ཨེམ་པི་ཐིརི་ ཚགས་མ་ ལྕོགས་ཅན་བཟོ།';
$string['mediapluginmpg'] = 'ཨེམ་པི་ཇི་ ཚགས་མ་ ལྕོགས་ཅན་བཟོ།';
$string['mediapluginogg'] = '.ogg ཚགས་མ་ལྕོགས་ཅན་བཟོ།';
$string['mediapluginogv'] = '.ogv ཚགས་མ་ལྕོགས་ཅན་བཟོ།';
$string['mediapluginram'] = '.ram ཚགས་མ་ ལྕོགས་ཅན་བཟོ།';
$string['mediapluginrm'] = '.rm ཚགས་མ་ ལྕོགས་ཅན་བཟོ།';
$string['mediapluginrpm'] = '.rpm ཚགས་མ་ ལྕོགས་ཅན་བཟོ།';
$string['mediapluginswf'] = '.swf ཚགས་མ་ལྕོགས་ཅན་བཟོ།';
$string['mediapluginswfnote'] = 'སྔོན་སྒྲིག་སྲུང་སྐྱོབ་འཇལ་ནི་བཟུམ་སྦེ་ སྤྱིར་བཏང་ལག་ལེན་པ་ཚུ་ ཨེསི་ཌ་བུ་ལུ་ཨེཕ་རིབ་སྟོན་ཡིག་སྣོད་ཚུ་གནས་འདྲེན་འབད་མི་ཆོག';
$string['mediapluginwmv'] = 'གྲབལུ་ཨེམ་བིཧི་ ཚགས་མ་ ལྕོགས་ཅན་བཟོ།';
$string['mediapluginyoutube'] = 'YouTubeའབྲེལ་ལ་མཚགས་མ་ ལྕོགས་ཅན་བཟོ།';
$string['messaging'] = 'འཕྲིན་གཏོང་རིམ་ལུགས་ ལྕོགས་ཅན་བཟོ།';
$string['messagingallowemailoverride'] = 'གློག་འཕྲིན་ཁྱབ་བསྒྲགས་མེདཔ་བཟོ།';
$string['messagingdeletereadnotificationsdelay'] = 'ལྷག་ཚར་བའི་ཁྱབསསྒྲགས་ཚུ་བཏོག་གཏང་།';
$string['messaginghidereadnotifications'] = 'ལྷག་ཚར་བའི་ཁྱབ་བསྒྲགས་ཚུ་སྦ་བཞག་།';
$string['minpassworddigits'] = 'ཨང་ཡིག།';
$string['minpasswordlength'] = 'ཆོག་ཡིག་ རིང་ཚད།';
$string['minpasswordlower'] = 'ཡིག་ཆུང་།';
$string['minpasswordnonalphanum'] = 'ཀ་ཁ་ཨང་ཡིག་མེན་པའི་ ཡིག་འབྲུ་ཚུ།';
$string['minpasswordupper'] = 'ཆེ་ཡིག།';
$string['misc'] = 'སྣ་ཚོགས།';
$string['mnetrestore_extusers'] = '<strong>དྲན་དགོཔ་:</strong> འ་ནི་རྒྱབ་ཐག་ཡིག་སྣོད་ནང་ན་ རྒྱང་རིང་མུ་ཌུལ་ཡོངས་འབྲེལ་ ལག་ལེན་པའི་རྩིས་ཐོ་ཚུ་ ལས་སྦྱོར་སྦེ་སོར་ཆུད་འབད་ཡོད།';
$string['mnetrestore_extusers_admin'] = '<strong>དྲན་དགོཔ:</strong> འ་ནི་རྒྱབ་ཐག་ཡིག་སྣོད་འདི་མུ་ཌུལ་གཞན་མི་ནང་ལས་གཞི་བཙུགས་འབད་དེ་འོང་འོངམ་བཟུམ་དང་ རྒྱང་རིང་མུ་ཌུལ་ཡོངས་འབྲེལ་ ལག་ལེན་པའི་རྩིས་ཐོ་ནང་ན་ཡོད། བསྐྱར་གསོ་ལས་སྦྱོར་འདི་གིས་ གསར་བསྐྲུན་འབད་ཡོད་པའི་ལག་ལེན་པ་ཚུ་ལུ་མུ་ཌུལ་ཡོངས་འབྲེལ་གནད་མཛོད་དང་མཐུན་སྒྲིག་འབད་ནི་ལུ་འབད་རྩོལ་བསྐྱེད་འོང་། མཐུན་སྒྲིག་མེད་མི་ཚུ་ རང་བཞིན་གྱིས་ནང་འཁོད་བདེན་བཤད་རྗེས་སོར་འབད་འོང་(ཨེམ་ཎེཊ་དང་པའི་ཚབ་མ་)འདི་གིས་སྐོར་ལས་དྲན་དེབ་བསྐྱར་གསོ་འདི་གིས་བརྡ་སླབ་འོང་།';
$string['mnetrestore_extusers_mismatch'] = '<strong>དྲན་དགོཔ་:</strong>རྒྱབ་ཐག་ཡིག་སྣོད་འདི་ མུ་ཌུལ་གཞི་བཙུགས་གཞན་མི་ལས་ གསལ་རི་རི་འགོ་བཙུགས་ནི་དང་ རྒྱང་རིང་མུ་ཌུལ་ཡོངས་འབྲེལ་ལག་ལེན་པའི་རྩིས་ཐོ་ནང་ན་སོར་ཆུད་འབད་ནི་འདི་འཐུས་ཤོར་འོང་། འདི་ལག་ལེན་འདི་རྒྱབ་སྐྱོར་མེད། ཁྱོད་ཀྱི་མུ་ཌུལ་གཞི་བཙུགས་འབད་མི་འདི་གསར་བསྐྲུན་འབད་ཡོདཔ་ངེས་ཅན་ཨིན་པ་ཅིན་ ཡང་ ཁྱོད་ཀྱི་མུ་ཌུལ་ཡོངས་འབྲེལ་རྩ་བོ་ ཧོསཊི་ ཚུ་རིམ་སྒྲིག་འབད་དགོ་མི་ཚུ་ ངེས་གཏན་བཟོ་དགོ་ ཁྱོད་ཀྱི་ད་ལྟོ་ཡང་སོར་ཆུད་འབད་ནིའི་འབད་རྩོལ་བསྐྱེད།';
$string['mnetrestore_extusers_noadmin'] = '<སྒྲིང་སྒྲིང་>དྲན་འཛིན་:</སྒྲིང་སྒྲིང་>རྒྱབ་ཐག་ཡིག་སྣོད་དེ་ཚུ་ལུ་ ལྟཝ་ད་ མུ་དྲིལ་མ་འདྲཝ་ཚུ་གཞི་བཙུགས་འབད་ནི་དང་ ནང་ན་ཡོད་པའི་ཐག་རིང་གི་མུ་དྲིལ་ ཡོངས་འབྲེལ་ ལག་ལེན་པའི་རྩིས་ཐོ་ཚུ་ནང་ལས་འོངམ་བཟུམ་མཐོངམ་མས། ལོག་ཁྱོད་ཀྱིས་སོར་ཆུད་འབད་དེ་ ལག་ལེན་འཐབ་མི་ཆོག། ས་ཁོངས་ཀྱི་བདག་སྐྱོང་པ་དང་འབྲེལ་བ་འབད་ ཡང་ན་ ཐབས་གཞན་གཞན་གྱི་ཐོག་ལས་ སློབ་ཚན་འདི་ ལག་ལེན་པའི་བརྡ་དོན་མེད་པར་ སོར་ཆུད་འབད། (མུ་དྲིལ་ ཡིག་སྣོད་ཚུ་)';
$string['mnetrestore_extusers_switchuserauth'] = 'རྒྱང་རིང་མུ་ཌུལ་ཡངོས་འབྲེལ་ལག་ལེན་པ་{$a->username}({$a->mnethosturl})་འདི་ལས་འོང་) ཉེ་གནས་སོར་བསྒྱུར་ལུ་ {$a->auth}  བདེན་བཤད་ལག་ལེན་པ།';
$string['mobile'] = 'འགྲུལ་འཕྲིན།';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'སྔོན་སྒྲིག་གདམ་འཐུ་གི་སྦྱོང་ལཱ།';
$string['modeditdefaults'] = 'སྔོན་སྒྲིག་གནས་ཚད་ཀྱི་སྦྱོང་ལཱ་གཞི་སྒྲིག།';
$string['modeditingmenu'] = 'བྱེད་ལས་ཞུན་དག་གི་གློག་རིམ་དཀར་ཆག';
$string['modeditingmenu_desc'] = 'ག་དེམ་ཅི་འབད་ ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ བྱེད་ལས་ཞུན་དག་གི་པར་རྟགས་ སློབ་ཚན་ཞུན་དག་ནུས་པ་ཅནསྦེ་ཡོད་པའི་སྐབས་ ཡོད་མི་ཚུ་ མར་གཞོལ་གློག་རིག་དཀར་ཆ་ ནང་གསལ་སྟོན་འབད་འོང། ཨ་ནི་དེ་གིས་ གདོང་ཤེལ་ནང་ཡོད་པའི་ ཡོད་ཆ་ཚུ་གཡིབ་སྟེ་ མ་དགོཔ་ཚུན་ཉུང་སུ་བཟོ་བཞགཔ་ཨིན།';
$string['modsettings'] = 'ལཱ་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['modulesecurity'] = 'ཚད་གཞི་ སྲུང་སྐྱོབ།';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'སྐད་ཡིག་སྣ་མང་ཚིག་སྦྱོར་རྙིངམ་འབད་བཅུག་:&lt;span&gt; དབྱེ་རིག་མེདཔ་སྦེ་="multilang" དང་ &lt;lang&gt;';
$string['mustenablestats'] = 'སི་ཊེཊིསི་ད་ཚུན་ས་ཁོངས་འདི་ན་ལྕོགས་ཅན་མིན་འདུག';
$string['mycoursesperpage'] = 'སློབ་ཚན་ཚུ་གི་མང་མཐའ་ ཨང་།';
$string['mydashboard'] = 'སྔོན་སྒྲིག་ལམ་ལུགས་dashboard';
$string['mymoodle'] = 'ངིའི་གདོང་ཤོག་';
$string['mymoodleredirect'] = 'ལག་ལེན་པ་ཚི་ལུ་ ངིའི་མུ་ཌེལ་ལག་ལེན་འཐབ་བཅུག།';
$string['mypage'] = 'ངེའི་མོ་ཌེལ་ཤོག་ལེབ་སྔོན་སྒྲིག།';
$string['mypagelocked'] = 'སྔོན་སྒྲིག་ཤོག་ལེབ་ལྡེ་མིག་རྐྱབས།';
$string['myprofile'] = 'སྔོན་སྒྲིག་གསལ་སྡུད་ཤོག་ལེབ།';
$string['mysql416bypassed'] = 'ག་དེ་སྦེ་རུང་ ཁྱོད་རའི་ས་ཁོངས་འདི་ ཨཡེ་ཨེསི་ཨོ་ -8859-1 (ལེ་ཀྲིན་)སྐད་ཡིག་རྐྱངམ་ཅིག་ ཁྱོད་ཀྱི་ད་ལྟོ་གཞི་བཙུགས་འབད་བའི་ མཱའི་ཨེསི་ཀིའུ་ཨེལ་ 4.1.12 ནང་ཁྱོད་ཀྱི་འཕྲོད་མཐུད་སྦེ་ལག་ལེན་འཐབ་(ཡང་ན་ མཐོ་མི་)';
$string['mysql416required'] = 'ངི་གི་ཨེས་ ཀིའུ་ཨེལ་ ༤.༡.༡༦འདི་ མུ་དྲིལ་གཡི་དོན་ལུ་ ཐོན་རིམ་ཉུང་ཤོས་དགོས་མཁོ་ཡོདཔ་ལས་ ༡.༦ཉེན་ལེན་དང་འཁྲིལཝ་ད་ལུ་ དེ་ཁར་ཡོད་པའི་ གནས་སྡུད་གེ་ར་ གི་གཞི་བསྒྱུར་འབད་ཡོདཔ་ལས་ཤུལ་མའི་ ཡུ་ཀྲི་ཨེཕ་ ༨ལུ་འབད།';
$string['navadduserpostslinks'] = 'ལག་ལེན་ཡིག་གུ་ལྟ་ནིའི་དོན་ལུ་རྒྱུན་འཐུད་བཙུགས།';
$string['navadduserpostslinks_help'] = 'ལྕོགས་ཅན་བཟོ་བ་ཅིན་འབྲེལ་ལམ་གཉིས་འདི་བསྡོམས་ཏེ་ལག་ལེན་འཐབ་མི་རེ་རེ་ལུ་འགྲུལ་བསྐྱོད་འབད་ཞིནམ་ད་ བསམ་འཆར་ དང་གྲོས་བསྡུར་ཚུ་ག་ར་ས་སྒོ་ག་ཏེ་ལས་ཡང་ན་ དམིགས་བསལ་གྱི་སློབ་ཚན་ཚུ་ནང་མཐོང་ཚུགས།';
$string['navcourselimit'] = 'ཆོས་ཚན་ཚད་འཛིན།';
$string['navigationupgrade'] = 'ཨ་ནི་ཡར་བསྐྱེད་འདི་གིས་འགྲུལ་བསྐྱོད་བཀག་འཛིན་གསརཔ་གཉིས་ངོས་ལེན་འབད་དེ་བཀག་འཛིན་འབད་འོང་། བདག་སྐྱོང་། སློབ་ཚན། སྦྱོང་ལཱ་དང་བཅའ་མར་གཏོགས་མི་ཚུ། ག་དེམ་ཅིག་འབད་ཁྱོད་ཀྱིས་དམིགས་བསལ་གྱིས་བཀག་འཛིན་གཞི་སྒྲིག་གནང་བ་བཟོ་ཡོད་པ་ཅིན་ ག་ར་ཀྲིག་ཀྲི་སྦེ་ཡོད་མི་གཏན་འཁེལ་བཟོ་དགོ།';
$string['navshowallcourses'] = 'སློབ་ཚན་ག་ར་སྟོན།';
$string['navshowcategories'] = 'སློབ་ཚན་གྱི་དབྱེ་རིམ་ཚུ་སྟོན།';
$string['navshowfrontpagemods'] = 'འགྲུལ་བསྐྱོད་ནང་ལུ་གདོང་ཤོག་གི་སྦྱོང་ལཱ་ཚུ་སྟོན།';
$string['navshowfrontpagemods_help'] = 'ལྕོགས་ཅན་བཟོ་བ་ཅིན་ གདོང་ཤོག་གི་སྦྱོང་ལཱ་འདི་འགྲུལ་བསྐྱོད་ཀྱི་འོག་གི་ས་སྒོ་ནང་སྟོན་འོང་།';
$string['navshowfullcoursenames'] = 'སློབ་ཚན་གྱི་མིང་ ཆ་ཚང་སྟོན།';
$string['navshowfullcoursenames_help'] = 'ག་དེམ་ཅིག་སྦེ་ ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ འགུལ་སྐྱོད་ནང་ཡོད་པའི་མིང་ཚུ་ བསྡུ་ཡིག་ནང་མེན་པར་ ཆ་ཚང་སྦེ་གསལ་སྟོན་འབད་འོང་།';
$string['navshowmycoursecategories'] = 'ངེ་གི་སློབ་ཚན་གི་དབྱེ་རིམ་སྟོན།';
$string['navshowmycoursecategories_help'] = 'གལ་སྲིད་སློབ་ཚན་ནང་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ ངེ་གི་སློབ་ཚན་ཆ་ཤས་ཚུ་དབྱེ་རིམ་ནང་ཧྟོན་འོང།';
$string['navsortmycoursessort'] = 'ངེའི་སློབ་ཚན་ཚུ་བསལ་འཐུ་འབད།';
$string['navsortmycoursessort_help'] = 'ཨ་ནི་དེ་གིས་ གོ་རིམ་བསྟར་གཞི་སྒྲིག་འབད་ནིའི་དོན་ལུ་ སློབ་ཚན་ཚུ་ ངེའི་སློབ་ཚན་འོག་ལུ་ཐོ་བཀོད་ཡོད་མེད་གཏན་འབེབས་འབདཝ་ཨིན།(གོ་རིམ་དེ་ཡང་ གནས་ཁོངས་བདག་སྐྱོང་ནང་ལུ་ >སློབ་ཚན >སློབ་ཚན་དང་དབྱེ་ཁག་ འཛིན་སྐྱོང) ཡང་ན་ སློབ་ཚན་ གནས་ལུགས་དང་འཁྲིལ ཀ་རྟགས་བསྟར་དུ།';
$string['neverdeleteruns'] = 'རྒྱུ་ལམ་ཚུ་མ་པ་ལས་བཏོན་མ་གཏང་།';
$string['nobookmarksforuser'] = 'ཁྱོད་ཀྱི་དེབ་རྟགས་ཚུ་ཅི་ཡང་མེད།';
$string['nodatabase'] = 'གནས་སྡུན་བང་མཛོད་མིན་འདུག';
$string['nohttpsformobilewarning'] = 'HTTPS ལག་ཁྱེར་ངོ་མ་གོཅིག་གིས་འབད་ལྕོགས་ཅན་བཟོ་དགོ་པའི་གྲོས་འབུལ་ཡོད། The Moodle app གིས་དུས་རྒྱུན་ཉེན་སྲུང་ཡོད་པའི་རྒྱུན་ལམ་ལུ་འཐུད་འོང་།';
$string['nomissingstrings'] = 'ཡིག་རྒྱུན་ཚུ་བརླག་སྟོར་ཞུགསཔ་མིན་འདུག།';
$string['nonewsettings'] = 'ཡར་བསྐྱེད་འབད་པའི་བསྒང་ གཞི་སྒྲིག་གསརཔ་གཅིག་ཡང་ཁ་སྐོང་རྐྱབས་པས།';
$string['nonexistentbookmark'] = 'ཁྱོད་ཀྱི་ཞུ་བ་འབད་ཡོད་པའི་དེབ་རྟགས་དི་མིན་འདུག།';
$string['noresults'] = 'གྲུབ་འབྲས་ཚུ་ མ་ཐོབ།';
$string['noroles'] = 'ལས་འགན་མིན་འདུག';
$string['notifications'] = 'བརྡ་བསྐུལ་ཚུ།';
$string['notifyloginfailures'] = 'ལུ་ནང་བསྐྱོད་འཐུས་ཤོར་གློག་འཕྲིན་བཏང་།';
$string['notifyloginthreshold'] = 'གློག་འཕྲིན་བརྡ་བསྐུལ་ཚུ་གི་དོན་ལུ་ཐེརེཤ་ཧཱོལ།';
$string['notloggedinroleid'] = 'ལྟ་སྐོར་པ་ཚུ་གི་དོན་ལུ་ ལས་འགན།';
$string['numberofmissingstrings'] = 'ཡིག་རྒྱུན་ཚུ་བརླག་སྟོར་ཞུགས་པའི་ཨང་:{$a}';
$string['numberofstrings'] = 'ཡིག་རྒྱུན་ཚུ་གི་་ཨང་བསྡོམས་:{$a->strings}<br />བརླག་སྟོར་ཞུགསཔ་:{$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = 'གདམ་ཁ་ཅན་གྱི་ ཨོ་པིན་ཨེསི་ཨེསི་ དཔེ་མཛོད་གཞི་བཙུགས་འབད་ནི་འདི་གནམ་མེད་ས་མེད་སྦེ་ ཧ་ཅང་གིས་འོས་སྦྱོར་འབདཝ་ཨིན་--འདི་གིས་མུ་ཌུལ་ཡོངས་འབྲེལ་འབད་ནིའི་ལས་འགན་ལྕོགས་ཅན་བཟོཝ་ཨིན།';
$string['opentogoogle'] = 'གུ་གུལ་ལུ་ ཁ་ཕྱེ།';
$string['optionalmaintenancemessage'] = 'རྒྱུན་སྐྱོང་འཕྲིན་ དོན་གདམ་ཁ་ཅན།';
$string['order1'] = 'དང་པ།';
$string['order2'] = 'གཉིས་པ';
$string['order3'] = 'གསུམ་པ།';
$string['order4'] = 'བཞི་པ།';
$string['passwordpolicy'] = 'ཆོག་ཡིག་ སྲིད་བྱུས།';
$string['passwordresettime'] = 'ཆོག་ཡིག་སླར་བཅོས་གཏན་འབེབས་གསོལ་འདེབསཀྱི་ དུས་ཡུན་མཐོ་ཤོས།';
$string['pathconvert'] = 'ཟུང་ལྡན་<i>གཞི་བསྒྱུར་འབད་ནི་</i>གི་འགྲུལ་ལམ།';
$string['pathdvips'] = 'ཌི་བིཧིཔས་<i>ཟུང་ལྡན་</i>གྱི་འགྲུལ་ལམ།';
$string['pathlatex'] = 'ལེ་ཊེགསི་<i>ཟུང་ལྡན་</i>གྱི་འགྲུལ་ལམ།';
$string['pathtoclam'] = 'ཀེལེམ ཨེ་ཝི་གི་ འགྲུལ་ལམ།';
$string['pathtodot'] = 'ཚག་གི་ལམ།';
$string['pathtodot_help'] = 'ཚག་གི་ལམ། གཅིག་འབདན་ usr/bin/dot བཟུམ་ཅིག DOT ཚིག་སྣོད་ལས་ རི་མོའི་ཐིག་ཁྲམ་བཟོབསྐྲུན་གྱི་དོན་ལུ་ ཁྱོད་ཀྱི་ནང་ལུ་ ལག་ལེན་འཐབ་བཏུབ་པའི་ dot གཞི་བཙུགས་འབད་ཡོད་དགོཔ་དང་ དེ་གིས་ཨ་ནི་ནང་ལུ་ སྟོན་དཔག་འབད་དགོ། སྐབས་ཐོག་ལུ་ ཨ་ནི་འདི་ ཁྱད་མིང་ཁྱད་རྣམ་ (Development->Profiling) Moodle ནང་བཟོ་ཡོད་མི་གིས་ལག་ལེན་འཐབ་ཨིནམ་ཤེས་དགོ';
$string['pathtodu'] = 'དྲིཡུ་ལུ་འགྱོ་ནི་ འགྲུལ་ལམ།';
$string['pathtopgdump'] = 'pg_dumpལུ་འགྱོ་ནི་ འགྲུལ་ལམ།';
$string['pathtopgdumpdesc'] = 'ཁྱོད་རའི་རིམ་ལུགས་གཅིག་ལས་ལྷག་པའི་ pg_dump ཉེར་མཁོ་ཡོད་པ་ཅིན་རྐྱངམ་ཅིག་ བཙུགས་ནི་ (དཔེར་ན་ པོའོས་གཱེརེཤ་ ཀིའུ་ཨེལ་ གཅིག་ལས་ལྷག་ཐོན་རིམ་གཞི་བཙུགས་འབད་བཅིན། )';
$string['pathtopgdumpinvalid'] = 'pg_dump - དྲམཔ་-ལུ་ནུས་མེད་འགྲུལ་ལམ་ ཕྱི་འགྱུར་དང་ཡང་ན་ལག་ལེན་འཐབ་མ་བཏུབ་པའི་ལམ་ གཉིས་ལས་གཅིག';
$string['pathtopsql'] = 'པི་ཨེསི་ཀིའུ་ཨེལ་ལུ་འགྱོ་ནི་ འགྲུལ་ལམ།';
$string['pathtopsqldesc'] = 'ཁྱོད་རའི་རིམ་ལུགས་གཅིག་ལས་ལྷག་པའི་ པི་ཨེས་ཀིའུ་ཨེལ་ ཉེར་མཁོ་ཡོད་པ་ཅིན་རྐྱངམ་ཅིག་ བཙུགས་ནི་ (དཔེར་ན་ པོའོས་གཱེརེཤ་ ཀིའུ་ཨེལ་ གཅིག་ལས་ལྷག་ཐོན་རིམ་གཞི་བཙུགས་འབད་བཅིན། )';
$string['pathtopsqlinvalid'] = 'པི་ཨེསི་ཀིའུ་ཨེལ་ལུ་ནུས་མེད་འགྲུལ་ལམ་ - ཕྱི་འགྱུར་ཡང་ན་ལག་ལེན་འཐབ་མ་བཏུབ་པའི་ལམ་ གཉིས་ལས་གཅིག';
$string['pcreunicodewarning'] = 'Unicode གི་ཡིག་གཟུགས་དང་མཐུན་པའི་PCRE PHP རྒྱ་བསྐྱེད་ལག་ལེན་འཐབ་དགོཔ་ངེས་བདེན།';
$string['perfdebug'] = 'ལཱ་ཤུགས་ཀྱི་ བརྡ་དོན།';
$string['performance'] = 'ལཱ་ཤུས།';
$string['pgcluster'] = 'པོས་གཱེ་རི་ཨེསི་ཨོ་ཨེལ་ ཕྱོགས་སྡེ།';
$string['pgclusterdescription'] = 'པོསཀྲ་གིརི་ ཨེས་ཀུའི་ཨེལ་ ཐོན་རིམ་ ཕྱོགས་སྡེབ་ ཚད་གཞི་གི་དོན་ལུ་ བརྡ་བཀོད་གཡལ་འདི་བཀོལ་སྤྱོད་འབདཝ་ཨིན། གལ་སྲིད་ཁྱོད་ལུ་རིམ་ལུགས་ལུ་ པོསཀྲ་གིརི་ ཨེས་ཀུའི་ཨེལ་ གཅིག་རྐྱངམ་ཅིག་འབད་བ་ཅིན་ཡང་ན་ འདི་ཁྱོད་ལུ་ངེས་བདེན་མིན་འདུག་ འདི་སྟོངམ་བཞག།';
$string['php50restricted'] = 'PHP 5.0.x ལུ་བྱ་དཀའ་ངལ་ལེ་ཤ་འདུག 5.1.x རྒྱ་བསྐྱེད་འབད་ ཡང་ན་4.3.x or 4.4.x ལུ་མར་ཕབ་འབད།';
$string['php533warning'] = 'PHP 5.3.3 ལས་ཡར་སྟབས་དགོཔ་ཁག་ཆེ།';
$string['phpfloatproblem'] = 'པི་ཨེཆ་པི་ ལྡིང་བའི་ཨང་ - {$a} ལེགས་སྐྱོང་འཐབ་ད་ རེ་བ་མེདཔའི་དཀའ་ངལ་ སྐྱོན་འཛིན་འབྱུང་ནུག';
$string['pleaserefreshregistration'] = 'ཁྱོད་ཀྱི་ས་ཁོངས་འདི་ moodle.org གི་ཐོག་ལས་ཐོ་འཀོད་འབད་ཡོདཔ་ལས་ གལ་སྲིད་ཧེ་མམ་གི་དུས་མཐུན་བཟོ་བའི་ཚུར་ལས་རྩ་ཅན་བསྒྱུར་བཅོས་འབྱུང་ཡོད་པ་ཅིན་ {$a}་གུ་ལུ་ཐོ་བཀོད་དུས་མཐུན་བཟོ་ནི་ཆ་འཇོག་གནང་།';
$string['pleaseregister'] = 'ཨེབ་རྟ་འདི་རྩ་བསྐྲད་གཏང་ནི་དོན་ལུ་ ཁྱོད་རའི་ས་ཁོངས་འདི་ཐོ་འཀོད་འབད་གནང་།';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Plugins';
$string['pluginscheck'] = 'རྟེན་དགོ་པའི་དབྱེ་ཞིབ་Plugin';
$string['pluginscheckfailed'] = '{$a->pluginslist} རྟེན་དགོ་པའི་དབྱེ་ཞིབ་མ་བཏུབ།';
$string['pluginschecktodo'] = 'Moodle ཐོན་རིམ་དེ་གཞི་བཙུགས་མ་འབད་བའི་ཧེ་མ pluginགི་དགོས་མཁོ་ཚུ་ག་ར་ཀྲིག་ཀྲི་བཟོ་དགོ།';
$string['pluginsoverview'] = 'Plugins སྤྱིར་བཏང་གི་མཐོང་སྣང་།';
$string['pluginsoverviewsee'] = 'ལྟ <a href="{$a->url}">plugins སྤྱིར་བཏང་གི་མཐོང་སྣང་།</a> ལྟ་ ཁ་གསལ་ཤེས་ནིའི་དོན་ལུ།';
$string['profilecategory'] = 'དབྱེ་རིམ།';
$string['profilecategoryname'] = 'དབྱེ་རིམ་གྱི་མིང་།(མཐུན་མོང་མ་ཡིན་པ་དགོ།)';
$string['profilecategorynamenotunique'] = 'དབྱེ་རིམ་གྱི་མིང་འདི་ཧེ་མ་ལས་རང་ལག་ལེན་འཐབ་ཡོད།';
$string['profilecommonsettings'] = 'མཐུན་མོང་ གཞི་སྒྲིག་ཚུ།';
$string['profileconfirmcategorydeletion'] = 'དབྱེ་རིམ་འདི་ན་ {$a} གི་ས་སྒོ་ ལྟག་གི་དབྱེ་རིམ་ནང་སྤོ་ནི་དོན་ལུ་འདུག་ (ཡང་ན་ འོག་ལུ་ དབྱེ་རིམ་མགོ་ལུ་ཨིནམ་པ་ཅིན་ <br/> ཁྱོད་ད་ལྟོ་ཡང་དབྱེ་རིམ་རྩ་བསྐྲད་གཏང་ནིའི་རེ་སྨོན་ཡོད་ག?';
$string['profileconfirmfielddeletion'] = '{$a} རྩ་བསྐྲད་གཏང་ནིའི་ས་སྒོ་འདི་ན་ལག་ལེན་པའི་དྲན་ཐོ་ཚུ་འདུག <br/>ཁྱོད་ད་ལྟོ་ཡང་ས་སྒོ་འདི་རྩ་བསྐྲད་གཏང་ནིའི་རེ་སྨོན་ཡོད་ག?';
$string['profilecreatecategory'] = 'གསལ་སྡུད་དབྱེ་རིམ་གསརཔ་ཅིག་ གསར་བསྐྲུན་འབད།';
$string['profilecreatefield'] = 'གསལ་སྡུད་ས་སྒོ་གསརཔ་ཅིག་ གསར་བསྐྲུན་འབད།';
$string['profilecreatenewcategory'] = 'བྱེ་རིམ་གསརཔ་ཅིག་ གསར་བསྐྲུན་འབད་དོ།';
$string['profilecreatenewfield'] = 'གསལ་སྡུད་ས་སྒོ་གསརཔ་\'{$a}\'ཅིག་ གསར་བསྐྲུན་འབད།';
$string['profiledefaultcategory'] = 'གཞན་ ས་སྒོ་ཚུ།';
$string['profiledefaultchecked'] = 'སྔོན་སྒྲིག་གི་སྦེ་ ཞིབ་དཔྱད་འབད་ཡོདཔ།';
$string['profiledefaultdata'] = 'སྔོན་སྒྲིག་ གནས་གོང་།';
$string['profiledeletecategory'] = 'དབྱེ་རིམ་ཅིག་ བཏོན་གཏང་དོ།';
$string['profiledeletefield'] = 'ས་སྒོ་{$a} བཏོན་གཏང་དོ།';
$string['profiledescription'] = 'ས་སྒོ་དེ་གི་ འགྲེལ་བཤད།';
$string['profiledscript'] = 'ཡིག་གུ་འདི་གསལ་སྡུད་འབད་ཡི།';
$string['profiledscriptview'] = 'ཡིག་གུ་འདིག་གི་དོན་ལུ་གནས་སྡུད་གནས་ཚུལ་ནང་ལྟ།';
$string['profileeditcategory'] = 'བྱེ་རིམ་{$a}་ཞུན་དག་འབད་དོ།';
$string['profileeditfield'] = 'གསལ་སྡུད་ས་སྒོ་:{$a}་ཞུན་དག་འབད་དོ།';
$string['profilefield'] = 'གསལ་སྡུད་ས་སྒོ།';
$string['profilefieldcolumns'] = 'ཀེར་ཐིག་ཚུ།';
$string['profilefieldispassword'] = 'འདི་ཆོག་ཡིག་ས་སྒོ་ཅིག་ཨིན་ན?';
$string['profilefieldlink'] = 'འབྲེལ་ལམ།';
$string['profilefieldlink_help'] = 'ཚིག་ཡིག་འབྲེལ་ལམ་ནང་ལུ་བསྒྱུར་བཅོས་འབད་ནིའི་དོན་ལུ་ URL $$,་ཡོད་མི་ནང་འཛུལ། $$ དེ་ཚིག་ཡིག་གིས་འབད་སོར་གཏང་འོང་། དཔེར་ན། witter གི་ངོ་རྟགས་འབྲེལ་ལམ་ནང་ལུ་བསྒྱུརནིའི་དོན་ལུ་ http://twitter.com/$$.ནང་འཛུལ།';
$string['profilefieldlinktarget'] = 'འབྲེལ་ལམ་གྱི་ཕྱོགས།';
$string['profilefieldmaxlength'] = 'རིང་ཚད་ མང་མཐའ།';
$string['profilefieldrows'] = 'གྲལ་ཐིག་ཚུ།';
$string['profilefields'] = 'ལག་ལེན་པ་གི་ གསལ་སྡུད་ས་སྒོ་ཚུ།';
$string['profilefieldsize'] = 'ཚད་ བཀྲམ་སྟོན།';
$string['profileforceunique'] = 'གནས་སྡུད་དེ་མཐུན་མོང་མ་ཡིན་པ་སྦེ་དགོཔ་ཨིན་ན?';
$string['profileinvaliddata'] = 'ནུས་མེད་ གནས་གོང་།';
$string['profilelocked'] = 'ས་སྒོ་འདི་བསྡམ་བཞག་བཞགཔ་ཨིན་ན?';
$string['profilemenudefaultnotinoptions'] = 'སྔོན་སྒྲིག་གནས་གོང་དེ་གདམ་ཁ་ཚུའི་གྱལ་ལས་ གཅིག་མེན།';
$string['profilemenunooptions'] = 'དཀར་ཆག་གི་གདམ་ཁ་ཚུ་བཀྲམ་སྤེལ་འབད་མིན་འདུག།';
$string['profilemenuoptions'] = 'དཀར་ཆག་གི་གདམ་ཁ་ཚུ།(one per line)';
$string['profilemenutoofewoptions'] = 'ཁྱོད་ཀྱི་གདམ་ཁ་ཉུང་མཐའ་༢་བྱིན་དགོ།';
$string['profilename'] = 'མིང་།';
$string['profilenofieldsdefined'] = 'ས་སྒོ་ཚུ་ངེས་འཛིན་མ་འབད་བས།';
$string['profilerequired'] = 'ས་སྒོ་འདི་དགོས་མཁོ་ཡོད་ག?';
$string['profileroles'] = 'གསལ་སྡུད་ཀྱི་ལས་འགན་དངོས་གསལ།';
$string['profilesforenrolledusersonly'] = 'གསལ་སྡུད་ཚུ་ ཐོ་བཀོད་འབད་ཡོད་པའི་ལག་ལེན་པ་ཚུ་ལུ་ཙམ་ཅིག།';
$string['profileshortname'] = 'མིང་ཐུང་ཀུ་(མཐུན་མོང་མ་ཡིན་པ་དགོ།)';
$string['profileshortnamenotunique'] = 'མིང་ཐུང་ཀུ་འདི་ཧེ་མ་ལས་རང་ལག་ལེན་འཐབ་ཡོད།';
$string['profilesignup'] = 'འཛུལ་ཐོ་བཀོད་ནའི་ཤོག་ལེབ་གུར་སྟོན།';
$string['profilespecificsettings'] = 'དམིགས་བསལ་ གཞི་སྒྲིག་ཚུ།';
$string['profilevisible'] = 'ག་ཟེར་མི་འདི་འ་ནི་ས་སྒོ་ལུ་མཐོང་ཚུགསཔ།';
$string['profilevisibleall'] = 'མི་ག་ར་གིས་ མཐོང་ཚུགས།';
$string['profilevisible_help'] = 'མི་མཐོང་བའི་ བདག་སྐྱོང་པ་རྐྱངམ་ཅིག་གིས་མབལྟ་ཚུགས་པའི་ སྒེར་གྱི་ཡིག་ཆ་ཚུ། ལག་ལེན་པ་རྐྱངམ་ཅིག་གིས་མཐོང་ཚུགས་མི་ བདག་སྐྱོང་པ་དང་ ལག་ལེན་པ་རྐྱངམ་ཅིག་གིས་ བལྟ་ཚུགས་མི། གེ་ར་གིས་མཐོང་ཚུགས་མི།';
$string['profilevisiblenone'] = 'མཐོང་མི་ཚུགས།';
$string['profilevisibleprivate'] = 'ལག་ལེན་པ་ཚ་གིས་ མཐོང་ཚུགས།';
$string['profiling'] = 'གསལ་སྡུད་འབད་བའི་བསྒང་།';
$string['profilingallowall'] = 'འཕྲོ་མཐུད་དེ་གསལ་སྡུད་འབད་བའི་བསྒང་།';
$string['profilingallowall_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ ནམ་རང་འབད་རུང་ ག་སྟེ་འབད་རུང་ (PGC) PROFILEALL ཚད་གཞི་དེ་ ལག་ལེན་འཐབ་བཏུབ་པའི་ ཡིག་རྒྱུགས་ Moodle གི་ཚེའི་ནམ་དུས་ལུ་ ལག་ལེན་འཐབ་བཏུབ། བརྡ་རྟགས་རིམ་སྟོན་བཞིན་དུ་ PROFILEALLSTOP དེ་ཡང་ བཀག་ནིའི་དོན་ལུ་ལག་ལེན་འཐབ་ཚུགས།';
$string['profilingallowme'] = 'གདམ་འཐུ་ཅན་གྱི་གསལ་སྡུད།';
$string['profilingallowme_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ གདམ་ཁའི་ཐོག་ PROFILEME ཚད་གཞི དེ་ག་སྟེ་ཡང་  (PGC) ལག་ལེན་འཐབ་བཏུབ། དེ་སྦེ་འབེ་བ་ཅིན་ བཅུད་བསྡུས་ཡིག་ཁྱད་དེ་ཡང་འབྱུང་འོང། བརྡ་རྟགས་རིམ་སྟོན་བཞིན་དུ ཁྱོད་ཀྱིས་ བཀད་ནིའི་དོན་ལུ་ DONTPROFILEME དེ་ལག་ལེན་འཐབ་ཚུགས།';
$string['profilingautofrec'] = 'རང་བཞིན་གྱིས་གསལ་སྡུད་འབད་ནི།';
$string['profilingautofrec_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་རིམ་སྒྲིག་འབད་བ་ཅིན་ གསོལ་འདེབས་ལ་ལུ་ཅིག་ (རིམ་བྲལ་ག་ཚུདསྦེ་ སྔར་བཀོད་སྒྲ་རླབས་ལམ་བསྟར་དུ་ 1 of N) ཚུ་རང་བཞིན་གྱིས་ སྒྲུབ་འབྲས་བསྲུང་ནི་དང་ དབྱེ་དཔྱད་ཀྱི་དོན་་ལུ་ གསལ་སྡུད་འབད་སྡོད་འོང། ཨ་ནི་བཟུམ་མའི་གསལ་སྡུད་དེ་གིས་ ཁོངས་སུ་བསྡུ་ནི་དང་མི་བསྡུ་ནིའི་ གཞི་སྒྲིག་ བལྟ་རྟོགས་འབདཝ་ཨིན། རང་བཞིན་གྱིས་ལྕོགས་མིན་བཟོ་ནིའི་དོན་ལུ་ 0 ལུ་གཞི་སྒྲིག་འབད།';
$string['profilingenabled'] = 'གསལ་སྡུད་འབད་བཏུབ་བཟོ།';
$string['profilingenabled_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ གསལ་སྡུད་དེ་ ཁོངས་གནས་དེ་ནང་ཡོདཔ་འགྱོ་འོང་། དེ་གིས་ཁྱོད་ཀྱིས་ ཤུལ་མ་གི་གདམ་ཁ་རིམ་སྒྲིག་འབད་བའི་ཐོག་ ཁོ་གི་བྱ་སྤྱོད་སོགས་མངགས་ཚུགས།';
$string['profilingexcluded'] = 'གསལ་སྡུད་འབད་ནི་འདི་གྲལ་མ་བཙུགས།';
$string['profilingexcluded_help'] = '(comma separated, absolute skipping wwwroot, callable) གི་URLsཚུ་ གསལ་བསྡུད་ལས་ "གསལ་བསྡུད་དེ་ཚུ" ཟེར་བའི་གཞི་སྒྲིག་ལས་ གྲངས་སུ་མི་བཙུགས་ནི་སྦེ་བཀག་འཛིན་འབདཝ་ཨིན།';
$string['profilingimportprefix'] = 'གསལ་བསྡུད་ ནང་སྐྱོད་འབད་བའི་སྔོན་ཚིག';
$string['profilingimportprefix_desc'] = 'རྟོགས་པ་དང་བདའ་ཟུནའཇམ་ནིའི་དོན་ལུ་ ནང་སྐྱོད་གསལ་བསྡུད་དེ་ཚུ་ ་ནཱ་ལུ་བཀོད་ཡོད་མི་གནས་ཐངདང་ཅིག་ཁར་སྔོན་ཚིག་སྦེ་སྤྱོད་ནི་ཨིན།';
$string['profilingincluded'] = 'ཨ་ནི་འདི་ཚུ་གསལ་སྡུད་འབད།';
$string['profilingincluded_help'] = '(comma separated, absolute skipping wwwroot, callable) URLs that will be automatically profiled. Examples: /index.php, /course/view.php. Also accepts the * wildchar at any position. Examples: /mod/forum/*, /mod/*/view.php. པའི་ཐོ།';
$string['profilinglifetime'] = 'གསལ་སྡུད་འདི་རྒྱུ་ལམ་ནང་བཞག།';
$string['profilinglifetime_help'] = 'གསལ་བསྡུད་རྙིངམ་གི་ གནས་ཚུལ་ཚུ་ག་དེ་ཅིག་ཚུན་བཞག་ནི་ཨིན་ན་གི་དུས་ཚོད་བཀོད། རྙིངམ་དེ་ཚུ་དུས་མཚམས་ལུ་ མར་ཕབ་དང་ཕྱིར་བཏོན་གཏང་ནི་ཨིན། དེ་འབདཝ་ད་ དེ་ཚུ་ \'reference run\' ཟེར་ཡོད་མི་དེ་ དེ་ཁར་གྲལ་གཏོགས་ཨིནམ་ཤེས་དགོ';
$string['protectusernames'] = 'ལག་ལེན་པ་ཚུ་གི་མིང་ ཉེན་སྐྱོབ་འབད།';
$string['proxybypass'] = 'Proxyལས་བརྒྱུད་མི་དགོ་པའི་གནས།';
$string['proxyhost'] = 'པོརོ་སི་ ཧོསཊི།';
$string['proxypassword'] = 'པོརོ་སི་ ཆོག་ཡིག།';
$string['proxyport'] = 'པོརོ་སི་ འདྲེན་ལམ།';
$string['proxytype'] = 'པོརོ་སི་ དབྱེ་བ།';
$string['proxyuser'] = 'པོརོ་སི་ ལག་ལེན་པའི་མིང།';
$string['purgecaches'] = 'གློག་རིག་དྲན་མཛོད་ནང་ལས་ག་ར་བཏོན་གཏང་།';
$string['purgecachesconfirm'] = 'Moodle གིས་བཀོད་རིས་ཤོག་ལེབ་དྲན་མཛོད་ནང་ལུ་ ཇ་བ་ཡིག་གུ་ སྐད་ཡིག་རྒྱུན་མཐུད་ ཚགས་བཙགས་འབད་ཡོད་པའི་ཚིག་ཡིག་ ཨང་ཨེས་དང་སྣ་མང་གི་གནས་སྡུད་ཚུ། Purging་འབད་བ་ཅིན་དེ་གིས་སར་བར་ནང་ཡོད་པའི་གནས་སྡུད་ཚུ་བཏོན་གཏང་སྟེ་ བརའུ་སར་རུ་ལུ་ལོག་སྟེ་འབག་འོང་བཅུག་པ་ཅིན། ཁྱོད་ལུ་ད་ལྟོ་ཡོད་པའི་གསང་་ཡིག་འདི་གིས་ལཱ་ལེགས་ཤོམ་འབད་ཡོདཔ་ཧ་གོ། འདི་འབདཝ་ལས་གློག་རིག་དྲན་འཛོད་ནང་ལས་བཏོན་གཏང་ནའི་ཉེན་ཁ་མེ། འདི་འབདཝ་ད་ཁྱོད་ཀྱི་ས་སྒོ་ནང་ལུ་ སར་བར་དང་ལག་ལེན་པ་གཉིས་ཀྱི་བར་ན་གནས་ཚུལ་གསརཔ་ཚུ་གློག་རིག་དྲན་མཛོད་ནང་མ་བཙུགས་ཚུན་ཚོད་ཡོངས་འབྲེལ་འདི་གི་ཤུགས་ཚད་ཉུང་སུ་ཅིག་འགྱོ་འོང་ག་མི་ཤེས།';
$string['purgecachesfinished'] = 'དྲན་མཛོད་ཚུ་ག་ར་བཏོན་གཏང་ཡི།';
$string['qtyperqpwillberemoved'] = 'ཡར་བསྐྱེད་འབད་བའི་བསྒང་ ཨར་ཀིའུ་གི་དྲི་བའི་དབྱེ་བ་འདི་རྩ་བསྐྲད་གཏང་འོང་། ཁྱོད་ཀྱིས་དྲི་བའི་དབྱེ་བ་ཚུ་ལག་ལེན་མི་འཐབ་སྦེ་ འདི་འབད་ནི་འདི་གིས་ ཁྱོད་ཀྱིས་ དཀའ་ངལ་ག་ནི་ཡང་མྱོང་མི་དགོས།';
$string['qtyperqpwillberemovedanyway'] = 'ཡར་བསྐྱེད་འབད་བའི་བསྒང་ ཨར་ཀིའུ་པི་ དྲི་བ་སྡེ་རིམ་དེ་གི་ བཏོན་གཏང་ཡོདཔ། ཁྱོད་ལུ་ཡོད་པའི་ཨར་ཀིའུ་པི་དག་པ་ཅིག་ གནས་སྡུད་གཞི་རྟེན་ནང་ཡོད་པའི་དྲི་བ་ཚུ་ དང་དེ་གིས་ ལོག་གཞི་བཙུགས་ཨང་རྟགས་ལས་ མ་འབད་ཚུན་ཚོད་ ལཱ་གཡོག་འབད་ནི་དེ་ བཀག་འོང་། http://moodle. org/mod/data/view.php?d=13&amp;rid=797 ཡར་བསྐྱེད་འཕྲོ་འཐུད་འབད་བའི་བསྒང་གི་ཧེན་མར།';
$string['quarantinedir'] = 'ཟུར་བརྟག་ སྣོད་ཐོ།';
$string['question'] = 'དྲི་བ།';
$string['questionbehaviours'] = 'དྲི་བཀོད།';
$string['questioncwqpfscheck'] = 'རིག་བསྡུར་ནང་ བསྲེ་སྦྱོར་ལས་རུབ་སྤྱོད་འབད་ཡོདཔ་དང་མེད་པའི་དྲི་བ་གི་དབྱེ་རིམ་ཚུ་ ལས་དྲི་པ་ཚུ་སེལ་འཐུ་འབད་ནི་སྦེ་ \'གང་འབྱུང་\'དྲི་བ་གཅིག་ཡང་ན་ལེ་ཤ་ཚུ་གཞི་སྒྲིག་འབད་ཡོད། རྒྱས་བཤད་སྙན་ཞུ་ལེ་ཤ་ཡོད་<a href="{$a->reporturl}">ན་ལུ་ </a>དང་མུ་ཌེལ་དྲོགས་ཤོག་ལེབ་ནང་བལྟ<a href="{$a->docsurl}">ན་ལུ</a>.';
$string['questioncwqpfsok'] = 'ལེགས་སོ། རུབ་སྤྱོད་འབད་ཡོདཔ་དང་མེད་པའི་དྲི་བ་གི་དབྱེ་རིམ་ཚུ་གི་བསྲེ་སྦྱོར་ལས་སེལ་འཐུ་འབད་བའི་དྲི་བ་ཚུ་གཞི་སྒྲིག་འབད་ཡོད་པའི་ རིག་བསྡུར་ཚུ་ནང་\'གང་འབྱུང་\'དྲི་བ་ཚུ་མིན་འདུག།';
$string['questiontype'] = 'དྲི་བའི་དབྱེ་བ།';
$string['questiontypes'] = 'དྲི་བའི་དབྱེ་བ་ཚུ།';
$string['quizattemptsupgradedmessage'] = 'Moodle 2.1 ནང་ལུ་ ཡར་དྲག་གལ་གནད་ཅན་དང་སྦོམ་ཤོས་ཅིག་ དྲི་བའི་ནང་འབད་དགོཔ་འཐོན་ཡི། ཨ ནི་འདི་གིས་ གཞི་གྲངས་མཛོད་ཀྱི་ཆ་ཤས་ཚུ་ཡར་དྲག་བཟོ་སྟེ་ འབད་སྤྱོད་འབད་ནི་ལུ་ཡུན་འགྱངས་འབད་ནུས་པའི་འོས་འབབ་འདུག Moodle 2.7ལུ་ཡར་དྲག་མ་འབད་བའི་ཧེ་མ་ ཨ་ནི་ཡར་དྲག་་དེ་མཇུག་བསྡུ་དགོ';
$string['recaptchaprivatekey'] = 'རི་ཀེབ་ཅ་ སྒེར་གྱི་ལྡེ་མིག';
$string['recaptchapublickey'] = 'རི་ཀེབ་ཅ་ མི་མང་ལྡེ་མིག';
$string['register'] = 'ཁྱོད་རའི་ས་ཁོངས་འདི་ཐོ་བཀོད་འབད།';
$string['registermoodleorg'] = 'ཁྱོད་ཀྱི་ས་ཁོང་འདི་{$a}དང་སྦྲག་ཐོ་བཀོད་འབདཝ་ད།';
$string['registermoodleorgli1'] = 'ཁྱོད་ལུ་གལ་ཅན་གྱི་གྱབ་བསྒྲགས་ དཔེ་འབད་བ་ཅིན་ ཉེན་སྐྱོབ་ཀྱི་ཉན་བརྡ་དང་ Moodle་གསརཔ་ཐོན་མི་ཚུ་གི་སྐོར་ལས་ ཡིག་གུ་འོང་ནིའི་ཐོ་འདི་ཤུགས་ཆུང་གི་ནང་ལུ་ཚུད་དེ་འདུག།';
$string['registermoodleorgli2'] = 'ཁྱོད་ས་ཁོང་གི་སྐོར་ལསརྩིས་དཔྱད་འདི་{$a}ལས་འབད་འཛམ་གླིང་རྒྱལ་སྤྱི་མི་སྡེའི་གརངས་སུ་བཙུགས་འོང་།';
$string['registermoodleorgli3'] = 'ཁྱོད་ཀྱི་ས་ཁོང་འདི་ཡང་ Moodle.org Open Community Hub ({$a}), དང་མཉམ་དུ་ཐོ་བཀོད་འབད་ཡི། དེ་གིས་འབད་ MOOCH གི་གདམ་ཁ་སྤར་བསྐྲུན་སློབ་ཚན་ཚུ་སྔོན་སྒྲིག་འཛིན་སྐྱོང་གི་ཐོག་ལས་འབད་ལག་ལེན་འཐབ་ཚུགས་པའི་ནུས་པ་ཡོད།';
$string['registerwithmoodleorg'] = 'Moodle.org་དང་་གཅིག་ཁར་ཐོ་བཀོད་འབད།';
$string['registration'] = 'ཐོ་བཀོད།';
$string['registration_help'] = 'Moodle.org དང་ཅིག་ཁར་ཐོ་བཀོད་འབད་དགོ་པའི་རྒྱབ་སྣོན་ངོ་སྦྱོར་དེ་ སྲུང་སྐྱོབ་དྲན་ཤེས་ཀྱི་བརྡ་བྱིན་ནི་དང་ <a href="http://moodle.org/stats">Moodle usage statistics</a> ལུ་ཕན་འདེབས་འབད་ནི་དེ་ལས་  <a href="http://moodle.net/">Moodle.net</a> ཁར་སློབ་ཚན་ཚུ་སྤེལ་ཚུགས་བཟོ་ནིའི་དོན་ལས་ཨིན།';
$string['registrationwarning'] = 'ཁྱོད་ཀྱི་ས་ཁོང་འདི་ད་ལྟ་ཐོ་བཀོད་མ་འབད་བས།';
$string['releasenoteslink'] = 'ཨ་ནི་ཐོན་རིམ་འདི་གི་Moodleགི་སྐོར་ལས་ online <a target="_blank" href="{$a}">Release Notes</a>ནང་ལུ་ལྟ།';
$string['rememberusername'] = 'ལག་ལེན་པའི་མིང་སེམས་ཁར་བཞག།';
$string['rememberusername_desc'] = 'ལྕོགས་ཅན་བཟོ་ ག་དེམ་ཅིག་སྦེ་ཁྱོད་ནང་བསྐྱོད་འབད་བའི་སྐབས་སུ་ལག་ལེན་པའི་མིང་དང་མཉམ་ཅིག་ ཀུ་ཀིས་གཏན་འཇགས་འབད་བཙུགས་ནི་ཨིན་པ་ཅིན། གཏན་འཇགས་ཀུ་ཀིས་འདི་ཚུ་གནང་བ་མེད་པར་ལག་ལེན་འཐབ་པ་ཅིན་སྟབས་མ་བདེཝ་འཐོན་འོང་།';
$string['reportsmanage'] = 'སྙན་ཞུ་འཛིན་སྐྱོག་འབད།';
$string['requestcategoryselection'] = 'དབྱེ་རིམ་གྱི་གདམ་ཁ་ལྕོགས་ཅན་བཟོ།';
$string['requiredentrieschanged'] = '<strong>གལ་ཅན་ - ལྷག་གནང་<br/>(This warning message will only be displayed during this upgrade)</strong><br/>སྐྱོན་སེལ་བ་ལས་བརྟེན, གནས་སྡུད་གྱི་དྲན་མཛོད་ནང་འཛུལ་དགོ་ དེ་འབདཝ་ད་ གཞི་སྒྲིག་མ་འབད་བའི་ཧེ་མ་ལས་ལྟ་ནི་འདི་གིས་གཞི་སྒྲིག་སོར་འགྱོ་འོང་། སོར་འགྱོ་མི་འདི་གི་སྐོར་ལས་ཁ་གསལ་འདི་ on <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">the database module forum</a>. གཞི་སྒྲིག་འདི་གི་སྐོར་ལས་ཁ་གསལ་འདི་ནང་ལུ་ལྷག་ཚུགས <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>. <br/><br/>ཨ་ནི་སོར་མི་འདི་གིས་འོག་གི་གནས་སྡུད་དྲན་མཛོད་ཀྱི་ལམ་ལུགས་ནང་གནོད་འོང་། : (ཨ་ནི་ཐོ་འདི་ད་ལྟོ་དང་རྒྱ་བསྐྱེད་འབད་ཚརཝ་ད་སྲུང་བཞག, ཞིབ་དཔྱད་འབད་དེ་ལྟ་ སྦྱོང་ལཱ་འདི་སློབ་སྟོན་པའི་བསམ་བློ་དང་འཁྲིལ་འགྱོ་དས་ག་ མིན་འདུག.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'སྦྱོང་ལཱ་གི་འགྲེལ་བཤད་དགོ།';
$string['requires'] = 'དགོ།';
$string['restorernewroleid'] = 'སློབ་ཚན་ནི་ལུ་ལས་འགན་ལོག་གཞི་བཙུགས་འབད།';
$string['restorernewroleid_help'] = 'ལག་ལེན་དེ་ལུ་ བསྐྱར་གསོ་འབད་བའི་ སློབ་ཚན་དེ་འཛིན་སྐྱོང་འབད་ནིའི་གནང་བ་མེད་པ་ཅིན་ ལག་ལེན་པ་དེ་རང་བཞིན་གྱིས་ ལས་འགན་འདི་སྤྲོདཔ་ཨིན་ དེ་ལས་དགོཔ་ཡོད་པ་ཅིན་ ཐོ་བཀོད་ཡང་འབདཝ་ཨིན། སློ་ཚན་བསྐྱར་གསོ་འབད་མི་ཚུ་གིས་ བསྐྱར་གསོ་འབད་བའི་སློབ་ཚན་ཚུ་འཛིན་སྐྱོང་འབད་བཅུག་དགོ་མནོ་བའི་དང་འདོད་མེད་པ་ཅིན་ "ཅི་ཡང་མེནམ" ཟེར་མི་འདི་ གདམ་ཁ་འབད།';
$string['reverseproxy'] = 'པོརོ་སི་ རིམ་ལོག།';
$string['riskconfig'] = 'ལག་ལེན་པ་ཚུ་ ས་ཁོངས་གི་རིམ་སྒྲིག་དང་སྤྱོད་ལམ་བསྒྱུར་བཅོས་འབད་ཚུགས།';
$string['riskconfigshort'] = 'རིམ་སྒྲིག་གི་ ཉེན་ཁ།';
$string['riskdataloss'] = 'ལག་ལེན་པ་གིས་ནང་དོན་ ཡང་ན་ གནས་ཚུལ་ ལེ་ཤ་མེད་བཟོ་འོང་།';
$string['riskdatalossshort'] = 'གནས་སྡུད་བང་ནིའི་ཉེན་ཁ་ཡོད།';
$string['riskmanagetrust'] = 'ལག་ལེན་པ་ཚུ་ གཞན་ཚུ་གི་བློ་གཏད་གཞི་སྒྲིག་ཚུ་བསྒྱུར་བཅོས་འབད་ཚུགས།';
$string['riskmanagetrustshort'] = 'བློ་གཏད་ཚུ་ འཛིན་སྐྱོང་འབད།';
$string['riskpersonal'] = 'ལག་ལེན་པ་ཚུ་གི་ གཞན་ལག་ལེན་པ་ཚུ་གི་སྒེར་གྱི་བརྡ་དོན་ནང་འཛུལ་སྤྱོད་འབད་ནི་ཐོབ་ཚུགས།';
$string['riskpersonalshort'] = 'སྒེར་གཙང་གི་ ཉེན་ཁ།';
$string['riskspam'] = 'ལག་ལེན་པ་ཚུ་གི་ ས་ཁོངས་ཀྱི་ལག་ལེན་པ་ཡང་ན་གཞན་མི་ཚུ་ལུ་ལི་སི་པམ་སྐྱེལ་ཚུགས།';
$string['riskspamshort'] = 'སི་པམ་ ཉེན་ཁ།';
$string['riskxss'] = 'ལག་ལེན་པ་ཚུ་གིས་ཡིག་སྣོད་དང་ཚིག་ཡིག་cross-site scripting (XSS)འབད་ཆོགཔ་འདི་འབད་ཅིན།';
$string['riskxssshort'] = 'ཨེགས་ཨེས་ཨེས་ ཉེན་ཁ།';
$string['roleswithexceptions'] = '$a->roles}, with {$a->exceptions}';
$string['rssglobaldisabled'] = 'སར་བར་གྱི་གནས་རིམ་ལུ་ལྕོགས་མིན་ཐལ་ཡོད།';
$string['runclamavonupload'] = 'སྐྱེལ་བཙུགས་འབད་ཡོད་པའི་ཡིག་སྣོད་ཚུ་ལུ་ཀེལེམ་ཨེ་ཝི་ལག་ལེན་འཐབ';
$string['save'] = 'སྲུང་།';
$string['savechanges'] = 'བསྒྱུར་བཅོས་ཚུ་ སྲུངས།';
$string['search'] = 'འཚོལ་ཞིབ།';
$string['searchinsettings'] = 'གཞི་སྒྲིག་ཚུ་ན་ འཚོལ་ཞིབ་འབད།';
$string['searchresults'] = 'འཚོལ་ཞིབ་ཀྱི་ གྲུབ་འབྲས་ཚུ།';
$string['sectionerror'] = 'དབྱེ་ཚན་ འཛོལ་བ།!';
$string['secureforms'] = 'ཁ༌སྐོང༌འབྲི་ཤོག༌སྲུང་སྐྱོབ༌ལག༌ལེན༌འཐབ།';
$string['security'] = 'སྲུང་སྐྱོབ།';
$string['selectdevice'] = 'དངོས་ཆས་གདམ་ཁ་རྐྱབས།';
$string['selecttheme'] = 'དངོས་ཆས་ཀྱི་དོན་ལུ་བཀོད་རིས་ཤོག་ལེབ་གདམ་འཐུ་འབད་{$a}';
$string['server'] = 'སར་བར།';
$string['serverchecks'] = 'སར་བར་ ཞིབ་དཔྱད་འབད་ནི་ཚུ།';
$string['serverlimit'] = 'སར་བར་ ཚད།';
$string['sessionautostartwarning'] = '<p>རིམ་སྒྲིག་གི་ནོར་འཁྲུལ་སྦོམ་མཐོང་ཡི་ སར་བར་གྱི་བདག་སྐྱོང་པ་ལུ་སྙན་ཞུ་ཕུལ་ .</p><p> ལེགས་ཤོམ་འབད་གཡོག་བཀོལ་ནིའི་དོན་ལུ་  Moodle  དེ་ལུ་བདག་སྐྱོང་གིས་ PHP གཞི་སྒྲིག་སོར་དགོ་པས་.</p>p>code>session.auto_start</code> must be set to <code>off</code>.</p><p>Tཨ་ནི་གཞི་སྒྲིག་འདི་ཞུན་དག་གིས་དབང་ཆ་བཟུང་སྟེ་ཡོད་<code>php.ini</code>, Apache/IIS <br />configuration or <code>.htaccess</code> file on the server.</p>';
$string['sessioncookie'] = 'ཀུ་ཀི་ སྔོན་ཚིག།';
$string['sessioncookiedomain'] = 'ཀུ་ཀི་ ཌོ་མེན།';
$string['sessioncookiepath'] = 'ཀུ་ཀི་ འགྲུལ་ལམ།';
$string['sessionhandling'] = 'ལཱ་ཡུན་ ལེགས་སྐྱོང་འཐབ་པ།';
$string['sessiontimeout'] = 'ངལ་མཚམས།';
$string['settingfileuploads'] = 'ཡིག་སྣོད་སྐྱེབ་བཙུགས་འབད་ནི་འདི་སྤྱིར་བཏང་གི་ལག་ལེན་འཐབ་ནིའི་དོན་ལུ་དགོ ཨ་ནི་འདི་PHPརིམ་སྒྲིག་ནང་ལུ་ལྕོགས་ཅན་བཟོ།';
$string['settingmemorylimit'] = 'དྲན་ཚད་མ་ལངམ་པའི་ཚོར་བ་བྱུང་ཡི། PHP གཞི་སྒྲིག་ནང་ལུ་དྲན་ཚད་མངམ་ཡོདཔ་བཟོ།';
$string['settingsafemode'] = 'Moodle འདི་ག་ར་མཐུན་སྒྲིག་འབད་མིན་འདུག་ བར་སར་བདག་སྐྱོང་པ་ལུ་བསྒྱུར་བ་བཏུབ་བཟོ་ཟེར་སླབ། Moodle རྒྱུ་ལམ་ལེགས་ཤོམ་ཡོད་པའི་རྒྱབ་གནོན་མིན་འདུག་ དེ་འབདཝ་ལས་སྟབས་མ་བདེཝ་ལེ་ཤ་འཐོན་ངས་ཡོད།';
$string['showcommentscount'] = 'བསམ་བཀོད་འབད་ཡོད་པའི་གཡང་ཁ་སྟོན།';
$string['showdetails'] = 'འགྲེལ་བཤད་ཁ་གསལ་སྟོན།';
$string['showuseridentity'] = 'ལག་ལེན་འཔི་ངོ་རྟགས་སྟོན།';
$string['showuseridentity_desc'] = 'ལག་ལེན་པ་ཚུ་འཚོལ་ཞིབ་དང་གདམ་ཁ་འབད་བའི་སྐབས་དང་ ལག་ལེན་པ་ཚུ་གི་ཐོ་གསལ་སྟོན་འབད་བའི་དུས་སུ་ ཨ་ནི་ས་སྒོ་འདི་ཁོང་རའི་མིང་དང་གཅིག་ཁར་སྟོན་འོང་ག་མི་ཤེས། ས་སྒོ་འདི་ལག་ལེན་པ་ མོ་ཌེལ་ཡོད་མི་ཚུ་རྐྱངམ་ཅིག་ལུ་སྟོནམ་ཨིན། moodle/site:viewuseridentity capability; སྔོན་སྒྲིག་སློབ་སྟོན་པ་དང་འཛིན་སྐྱོང་པ་ཚུ་ལུ། ཨ་ནི་གདམ་ཁ་འདི་ དོན་ལྡན་འགྱོ་འོང་ ག་དེམ་ཅིག་འབད་ ཁྱོད་ཀྱིས་ཁྱོད་ཀྱི་སློབ་སྦྱོང་སྤེལ་ཁང་ནང་་མ་པ་ལས་འབག་དགོ་པའི་དོན་ཚན་གཉིས་གདམ་འཐུ་འབད་བ་ཅིན།';
$string['simplexmlrequired'] = 'སིམ་པལ་ཨེགསི་ཨེམ་ཨེལ་པི་ཨེཆ་པི་གི་དེ་ ད་ལྟོ་མུ་ཌེལ་ལུ་དགོས་མཁོ་ཡོདཔ་ཨིན།';
$string['sitemaintenance'] = 'ས་ཁོངས་དེ་རྒྱུན་སྐྱོང་འབད་བའི་བསྒང་ཡོདཔ་ལས་ ད་ལྟོ་འཐོབ་མི་ཚུགས་པས།';
$string['sitemaintenancemode'] = 'རྒྱུན་སྐྱོང་ གནས་ཐངས།';
$string['sitemaintenanceoff'] = 'རྒྱུན་སྐྱོང་ གནས་ཐངས་དེ་ལྕོགས་མིན་ཐལ་ཡོདཔ་ལས་ ས་ཁོངས་དེ་ལོག་སྤྱིར་བཏང་འབད་གཡོག་བཀོལ་བའི་བསྒང་།';
$string['sitemaintenanceon'] = 'ཁྱོད་ཀྱི་ས་ཁོངས་འདི་ད་ལྟོ་རྒྱུན་སྐྱོང་ ཐབས་ལམ་ནང་ཡོད།(བདག་སྐྱོང་ཙམ་ཅིག་གི་ས་ཁོངས་དེ་ན་ནང་བསྐྱོད་ཡང་ན་ལག་ལེན་འཐབ་ཚེགས།)';
$string['sitemaintenanceoncli'] = 'ཁྱོད་ཀྱིས་གནས་ཁོངས་དེ་ རྒྱུན་སྐྱོང་འབད་བའི་བསྒང་ཡོདཔ་ལས་ ཡོངས་འབྲེལ་སྤྱོད་དབང་མེད།';
$string['sitemaintenancewarning'] = 'ཁྱོད་ཀྱི་ས་ཁོངས་འདི་ད་ལྟོ་རྒྱུན་སྐྱོང་ ཐབས་ལམ་ནང་ཡོད།(བདག་སྐྱོང་ཙམ་ཅིག་གི་ནང་བསྐྱོད་འབད་ཆོག།)ས་ཁོངས་འདི་སྤྱིར་བཏང་བཀོལ་སྤྱོད་ལུ་ སླར་ལོག་འབད་ནི་དོན་ལུ་<a href="maintenance.php">རྒྱུན་སྐྱོང་ ཐབས་ལམ་ལྕོགས་མིན་བཟོ།';
$string['sitemaintenancewarning2'] = 'ཨ་ནི་ས་སྒོ་འདི་ད་ལྟོ་ཉམས་བཅོས་འབད་བའི་བསྐང་ཨིན། (བདག་སྐྱོང་པ་ཚུ་རྐྱངམ་ཅིག་ནང་བསྐྱོད་འབད) ཨ་ནི་ས་སྒོ་འདི་ལོག་སྤྱིར་བཏང་ག་ཨིནམ་སྦེ་སྤྱོད་བཏུབ་བཟོ་ནིའི་དོན་ལུ<a href="{$a}">ཉམས་བཅས་ཀྱི་ལཱ་ལྕོགས་མིན་བཟོ</a>.་';
$string['sitepolicies'] = 'ས་ཁོངས་ སྲིད་བྱུས་ཚུ།';
$string['sitepolicy'] = 'ས་ཁོངས་སྲིད་བྱུས་ཀྱི་ ཡུ་ཨར་ཨེལ།';
$string['sitepolicyguest'] = 'མགྱོནམ་ཚུ་གི་ས་སྒོ་ནང་གི་URL སྲིད་བྱུས།';
$string['sitepolicyguest_help'] = 'ས་སྒོ་འདི་ལག་ལེན་མ་འཐབ་པའི་ཧེ་ གལ་སྲིད་མགྱོནམ་ཚུ་གི་དོན་ས་སྒོ་འདིའི་ནང་ལུ་མ་འཛུལ་བའི་ཧེ་མ་ལས་ལྟ་སྟེ་ཁས་ལེན་འབད་དགོ་པའི་སྲིད་བྱུས་ཅིག་ཡོད་པ་ཅིན། URL དེ་ནཱ་ལུ་གསལ་བཀོད་འབད། དེ་མིན་པ་ཅིན་ས་སྒོ་འདི་ས་སྟོང་བཞག གཞི་སྒྲིག་འདི་ནང་ལུ་མི་དམང་གི་URL འོང་སྲིད། Note: access of not-logged-in users may be prevented with forcelogin setting.';
$string['sitepolicy_help'] = 'ས་སྒོ་འདི་ལག་ལེན་མ་འཐབ་པའི་ཧེ་ གལ་སྲིད་མགྱོནམ་ཚུ་གི་དོན་ས་སྒོ་འདིའི་ནང་ལུ་མ་འཛུལ་བའི་ཧེ་མ་ལས་ལྟ་སྟེ་ཁས་ལེན་འབད་དགོ་པའི་སྲིད་བྱུས་ཅིག་ཡོད་པ་ཅིན། URL དེ་ནཱ་ལུ་གསལ་བཀོད་འབད། དེ་མིན་པ་ཅིན་ས་སྒོ་འདི་ས་སྟོང་བཞག གཞི་སྒྲིག་འདི་ནང་ལུ་མི་དམང་གི་URL འོང་སྲིད།';
$string['sitesectionhelp'] = 'གལ་སྲིད་སེལ་འཐུ་གྲུབ་པ་ཅིན་ ས་ཁོངས་དེ་གི་གདོང་ཤོག་གུ་ལུ་གནད་དོན་དབྱེ་ཚན་ཅིག་བཀྲམ་སྟོན་འབད་འོང་།';
$string['slasharguments'] = 'གཡོ་ཤད་སྒྲུབ་རྟགས་ཚུ་ ལག་ལེན་འཐབ།';
$string['smartpix'] = 'སྤུར་བསྒྱིར་དྲགས་པར་ འཚོལ་ཞིབ།';
$string['soaprecommended'] = 'གདམ་ཁའི་soap extensionགཞི་བཙུགས་འབད་ནི་དེ་ ཁྱོད་ཀྱི་ ཡོངས་འབྲེལ་ཞབས་ཏོག་དང་ add-on་ལ་ལལུ་ཅིག་ལུ་ཕན་པ་ཡོད།';
$string['sort_fullname'] = 'སློབ་ཚན་གྱི་མིང་ཆ་ཚང།';
$string['sort_idnumber'] = 'སློབ་ཚན་གྱི་ངོ་རྟགས་ཨང་།';
$string['sort_shortname'] = 'སློབ་ཚན་གྱི་མིང་ བསྡུས་པ།';
$string['sort_sortorder'] = 'བསལ་བའི་གོ་རིམ།';
$string['spellengine'] = 'སྡེབ་འཕྲུལ་ངོ་མ།';
$string['spelllanguagelist'] = 'སྐད་སྡེབ་ཐོ།';
$string['splrequired'] = 'SPL PHP གི་རྒྱ་བསྐྱེད་འདི་ད་Moodle.གི་དོན་ལུ་དགོ་པས།';
$string['stats'] = 'ཚད་རྩིས།';
$string['statsfirstrun'] = 'བཟོ་སྦྱོར་གྱི་བར་མཚམས་ མང་མཐའ།';
$string['statsmaxruntime'] = 'རཱན་ཊའིམ་ མང་མཐའ།';
$string['statsmoodleorg'] = 'གནས་སྡུད་རིག་པ།';
$string['statsruntimedays'] = 'ལས་སྦྱོར་འབད་ནི་གི་ ཉིན་གྲངས།';
$string['statsruntimestart'] = 'ལུ་ གཡོག་བཀོལ།';
$string['statsuserthreshold'] = 'ལག་ལེན་པའི་ ཐེརེཤ་ཧཱོལ།';
$string['stickyblocks'] = 'རྩི་ཅན་ སྡེབ་ཚན།';
$string['stickyblockscourseview'] = 'སློབ་ཚན་གྱི་ ཤོག་ལེབ།';
$string['stickyblocksduplicatenotice'] = 'གལ་སྲིད་ཁྱོད་ཀྱི་ནཱ་ལུ་ ཁ་སྐོང་རྐྱབས་མི་སྡེབ་ཚན་ག་ཅི་འབད་རུང་ ཧེ་མ་ལས་རང་བྱེ་བྲག་ཤོག་ལེབ་ནང་ ཡོད་པ་ཅིན་ འདི་གི་རྫུན་མ་སྦེ་གྲུབ་འབྲས་འབྱུང་འོང་།<br />ཁབ་གཟེར་བཏབ་པའི་སྡེབ་ཚན་ ཙམ་ཅིག་ཞུན་དག་འབད་མི་བཏུབ་ རྫུན་མ་dདེ་ད་ལྟོ་ཡང་ཅིག་ཞུན་དག་འབད་མི་བཏུབ།';
$string['stickyblocksmymoodle'] = 'ངེའི་མོ་ཌེལ།';
$string['stickyblockspagetype'] = 'ཤོག་ལེབ་དབྱེ་བ་ཏར་རིམ་སྒྲིག་འབད།';
$string['strictformsrequired'] = 'དགོ་མཁོ་ཆེ་བའི་དོན་ལུ་དམ་ཟབ་ཀྱི་གཏན་འབེབ།';
$string['stripalltitletags'] = 'ལཱ་གིས་མིང་ཆ་མཉམ་ལས་ཨེཆ་ཊི་ཨེམ་ཨེལ་ངོ་རྟགས་ཚུ་རྩ་བསྐྲད་གཏང་།';
$string['supportcontact'] = 'རྒྱབ་གནོན་གྱི་འབྲེལ་བ།';
$string['supportemail'] = 'གློག་འཕྲིན་རྒྱབ་སྐྱོར།';
$string['supportname'] = 'མིང་རྒྱབ་སྐྱོར།';
$string['supportpage'] = 'ཤོག་ལེབ་རྒྱབ་སྐྱོར།';
$string['suspenduser'] = 'རྩིས་ཐོ་ཕར་བཤུད་བརྐྱབ།';
$string['switchlang'] = 'ལེང་སྣོད་ཐོ་སོར་བསྒྱུར་འབད།';
$string['systempaths'] = 'རིམ་ལུགས་འགྲུལ་ལམ་ཚུ།';
$string['tablenosave'] = 'ཡར་ལྟག་ལུ་ཐིག་ཁྲམ་ནང་སོར་ཡོད་མི་ཚུ་རང་བཞིན་གྱིས་སྲུང་བཞག་ཡི།';
$string['tablesnosave'] = 'ཡར་ལྟག་ལུ་ཐིག་ཁྲམ་ནང་སོར་ཡོད་མི་ཚུ་རང་བཞིན་གྱིས་སྲུང་བཞག་ཡི།';
$string['tabselectedtofront'] = 'མཆོང་ལྡེ་ཡོད་པའི་ཐིག་ཁྲམ་ཚུ་གུ་ ད་ལྟོ་སེལ་འཐུ་གྲུབ་པའི་མཆོང་ལྡེ་';
$string['tabselectedtofronttext'] = 'སེལ་འཐུ་གྲུབ་པའི་མཆོང་ལྡེ་གྲལ་ཐིག་འདི་ གདོང་ཁ་ལུ་འབག་ཤོག།';
$string['testsiteupgradewarning'] = 'ཁྱོད་ད་ལྟོ་{$a} བརྟག་ཞིབ་གནས་ཁོངས་ལག་ལེན་འཐབ་དོ། གནས་ཁོངསཡར་བསྐྱེད་ཀྱི་ལེགས་ཤོམ་གཏང་ནིའི་དོན་ལུ་ བཀོད་རྒྱ་གྱལ་རིམ་མཐུད་ཁའི་ལག་ཆ འདི་ལག་ལེན་འཐབ།';
$string['themedesignermode'] = 'བཀོད་རིས་ཤོག་ལེམ་བཟོ་བཀོད་འབད་བའི་བསྒང་།';
$string['themelist'] = 'བཀོད་རིས་ཤོག་ལེབ་ཀྱི་ ཐོ་བཀོད།';
$string['themenoselected'] = 'བཀོད་རིས་ཤོག་ལེབ་གདམ་འཐུ་མ་འབད་བས།';
$string['themeresetcaches'] = 'བཀོད་རིས་ཤོག་ལེབ་ཀྱི་དྲན་མཛོད་དེ་ཧིང་སངས་ས་བཟོ།';
$string['themeselect'] = 'བཀོད་རིས་ཤོག་ལེབ་སོར།';
$string['themeselector'] = 'བཀོད་རིས་ཤོག་ལེབ་ སེལ་བྱེདཔ།';
$string['themesettings'] = 'བཀོད་རིས་ཤོག་ལེབ་ཀྱི་ གཞི་སྒྲིག་ཚུ།';
$string['therewereerrors'] = 'ཁྱོད་ཀྱི་གནས་སྡུད་ནང་འཛོལ་བ་ཚུ་འདུག།';
$string['thirdpartylibrary'] = 'མཛོད།';
$string['thirdpartylibrarylocation'] = 'ས་ཁོངས།';
$string['thirdpartylibs'] = 'རྩ་བོ་གསུམ་པའི་མཛོད།';
$string['timezone'] = 'སྔོན་སྒྲིག་ ཆུ་ཚོད་གླིང་སྡེ།';
$string['timezoneforced'] = 'འདི་ ས་ཁོངས་ཀྱི་བདག་སྐྱོང་པ་གི་ བང་ཅན་འབད་ཡོང།';
$string['timezoneisforcedto'] = 'ལག་ལེན་པ་ཆ་མཉམ་ལུ་ ལག་ལེན་འཐབ་བཅུག།';
$string['timezonenotforced'] = 'ལག་ལེན་གྱི་ཁོ་རའི་ཆུ་ཚོད་གླིང་སྡེ་གདམ་ཆོག།';
$string['tokenizerrecommended'] = 'གདམ་ཁ་ཅན་གྱི་པི་ཨེཆ་པི་ངོ་རྟགས་སྐྱེལ་མི་རྒྱ་བསྐྱེད་གཞི་བཙུགས་འབད་ནི་དེ་འོས་སྦྱོར་ཡོད་--མུ་ཌེལ་ཡོངས་འབྲེལ་བཟོ་ནི་ལས་འགན་འདི་ ཡར་དྲག་བཟོ་འོང་།';
$string['tools'] = 'བདག་སྐྱོང་གི་ལག་ཆ།';
$string['toolsmanage'] = 'བདག་སྐྱོང་གི་ལག་ཆ་ཚུ་འཛིན་སྐྱོང་འབད།';
$string['unattendedoperation'] = 'བདག་འཛིན་མ་འབད་བའི་ བཀོལ་སྤྱོད།';
$string['unbookmarkthispage'] = 'ཤོག་ལེབ་འདི་ལས་ དེབ་རྟགས་སྟོན་བཏང་།';
$string['unicoderecommended'] = 'ཁྱོད་རའི་གནས་སྡུད་ཚུ་གེ་ར་ཡུ་ནི་ཀོཌི་(ཡུ་ཊི་ཨེཕ་-༨་)་ནང་གསོག་འཇོག་འབད་ནི་འོས་སྦྱོར་ཡོད། ཡུ་ནི་ཀོཌི་འབད་བཞག་པའི་སྔོན་སྒྲིག་ཡིག་འབྲུ་ཡོད་པའི་གནས་སྡུད་གཞི་རྟེན་ནང་ལུ་ གསརཔ་གཞི་བཙུགས་འབད་ནི་ཚུ་འབད་དགོ། གལ་སྲིད་ཡར་བསྐྱེད་འབད་བ་ཅིན་ ཁྱོད་ཀྱི་ ཡུ་ཊི་ཨེཕ་-༨་གཞིས་སྤོ་ནིའི་ལས་སྦྱོར་འདི་གཡོག་གཀོལ་དགོ།';
$string['unicoderequired'] = 'ཁྱོད་རའི་གནས་སྡུད་ཚུ་གེ་ར་ཡུ་ནི་ཀོཌི་རྩ་སྒྲིག་(ཡུ་ཊི་ཨེཕ་-༨་)་ནང་གསོག་འཇོག་འབད་ནི་དགོས་མཁོ་ཡོད། ཡུ་ནི་ཀོཌི་འབད་བཞག་པའི་སྔོན་སྒྲིག་ཡིག་འབྲུ་ཡོད་པའི་གནས་སྡུད་གཞི་རྟེན་ནང་ལུ་ གསརཔ་གཞི་བཙུགས་འབད་ནི་ཚུ་འབད་དགོ། གལ་སྲིད་ཡར་བསྐྱེད་འབད་བ་ཅིན་ ཁྱོད་ཀྱི་ ཡུ་ཊི་ཨེཕ་-༨་གཞིས་སྤོ་ནིའི་ལས་སྦྱོར་འདི་གཡོག་གཀོལ་དགོ།(བདག་སྐྱོང་གི་ཤོག་ལེབ་དེ་བལྟ།)';
$string['uninstallplugin'] = 'གཞི་བཙུགས་ཤོལ་ནི།';
$string['unlockaccount'] = 'རྩིས་ཕྱེ།';
$string['unsettheme'] = 'བཀོད་རིས་ཤོག་ལེབ་གཞི་སྒྲིག་ཤོལ་ནི།';
$string['unsupported'] = 'རྒྱབ་སྐྱོར་མེད་པའི།';
$string['unsuspenduser'] = 'ལག་ལེན་པའི་རྩིས་ཐོ་སྤྱོད་བཏུབ་བཟོ།';
$string['updateaccounts'] = 'ཡོད་བཞིན་པའི་རྩིས་ཐོ་ཚུ་ དུས་མཐུན་བཟོ།';
$string['updateautocheck'] = 'རང་བཞིན་གྱིས་ རྒྱ་བསྐྱེད་འབད་ནིའི་';
$string['updateautocheck_desc'] = 'ལྕོགས་ཅན་བཟོ་བ་ཅིན། ཁྱོད་ཀྱི་ས་སྒོ་ནང་plugins ཐེབ་བཙུགས་ཡོད་མི་ག་ར་དང་ Moodle དང་གསང་ཡིག་གཉིས་ཆ་ར་ རང་བཞིན་གྱིས་དུས་མཐུན་བཟོ་འོང་། ག་དེམ་ཅིག་འབད་ དུས་མཐུན་བཟོ་ནི་གསརཔ་རེ་མཐོན་པ་ཅིན་ ས་སྒ་གི་བདག་སྐྱོ་པ་ལུ་གནས་ཚུལ་ཁྱབ་སྤེལ་འབད་འོང་།';
$string['updateautodeploy'] = 'ལྕོགས་ཅན་བཟོ་སྟེ་ དུས་མཐུན་བཀྲམ་བཙུགས་འབད།';
$string['updateautodeploy_desc'] = 'ལྕོགས་ཅན་བཟོ་བ་ཅིན་ ཁྱོད་ཀྱིས་དུས་མཐུན་བཟོ་ནིའི་ཡོད་མི་ཚུ་བདག་སྐྱོང་གི་མོ་ཌེལ་ཤོག་ལེབ་ནང་ལས་ཕབ་ལེན་འབད་་དེ་གཞི་བཙུགས་འབད་ཚུགས། ཨིན་རུང་ཁྱོད་ཀྱི་སེམས་ཁ་ག་ཅི་བཞག་དགོ་ཟེར་བ་ཅིན་ ཁྱོད་ཀྱི་ཝེབ་ སར་བར་འདི་ནང་ལུ་འབྲི་ནིའི་གོ་སྐབས་ཡོད་པའི་ཡིག་སྣོད་དང་སྦྲག་ མོ་ཌེལ་གཞི་བཙུགས་འབད་ནིའི་ལཱ་ཚུ་ཡང་འབད་བཏུབ་སྦེ་དགོ། འདི་འབདཝ་ད་ ཨ་ཕི་འདི་ཉེན་སྲུང་འབད་ནི་ལུ་ཉེན་ཁ་ཡོདཔ་ཅིག་ཡང་ཨིན།';
$string['updateavailable'] = 'མོ་ཌེལ་གྱི་ཐོན་རིམ་གསརཔ་གཅིག་དུས་མཐུན་བཟོ་ནིའི་དོན་ལུ་འདུག།';
$string['updateavailabledetailslink'] = 'ཁ་གསལ་ཤེས་ནིའི་དོན་ལུ་ {$a->url} ནང་ལྟ།';
$string['updateavailableforplugin'] = 'ཁྱོད་ཀྱི་pluginsལ་ལུ་ཅིག་ནང་ཐོན་རིམ་གསརཔ་དུས་མཐུན་བཟོ་ནིའི་དོན་ལུ་འདུག།';
$string['updateavailableinstall'] = 'ཨ་ནི་གཞི་བཙུགས་འདི་དུས་མཐུན་བཟོ།';
$string['updateavailable_moreinfo'] = 'གནས་ཚུལ་ཁ་གསལ་་་་';
$string['updateavailablenot'] = 'ཁྱོད་ཀྱི་མོ་ཌེལ་གསང་ཡིག་འདི་དུས་མཐུན་འདུག';
$string['updateavailable_release'] = 'མོ་ཌེལ{$a}';
$string['updateavailable_version'] = 'ཐོན་རིམ་{$a}';
$string['updatecomponent'] = 'ཆ་ཤས་ དུས་མཐུན་བཟོ།';
$string['updateminmaturity'] = 'གསང་ཡིག་གྱི་དུས་སྨིན་དགོ་པས།';
$string['updateminmaturity_desc'] = 'གསང་ཡིག་དུས་མཐུན་བཟོ་ནིའི་ཡོད་ལུགས་ཀྱི་སྐོར་ལས་དྲན་བསྐུལ་འདི་ དུས་མཐུན་བཟོ་ནིའི་གསང་ཡིག་ནང་ལུ་དུས་སྨིན་གྱི་ཚད་ཅིག་ཡོད་པ་ཅིན་རྐྱངམ་ཅིག་ཐོབ། གཞི་སྒྲིག་འདི་ནང་གསང་ཡིག་དུས་སྨིན་གྱི་ཚད་ཅིག་མེད་མི་ཚུ་ལུ་ pluginsའདི་དུས་མཐུན་བཟོ་མི་ཚུགས།';
$string['updatenotificationfooter'] = 'ཁྱོད་ཀྱི་Moodle གནས་ཁོངས་ {$a->siteurl} དེ་རང་བཞིན་གྱིས་ དུས་མཐུན་བཟོ་ནིའི་དོན་ལུ་རིམ་སྒྲིག་འབད་དེ་ཡོད། ཁྱོད་གནས་ཁོངས་ཀྱི་འཛིན་སྐྱོང་པ་འབདཝ་ལས་ བརྡ་འཕྲིན་འདི་ཐོབ་ཨིན། འཛིན་སྐྱོང་ས་ཁོངས་ནང་ལུ་ རང་བཞིན་གྱིས་ དུས་མཐུན་བཟོ་ནི་འདི་ ལྕོགས་མིན་བཟོ་བཏུབ། ཁྱོད་ཀྱིས་ "ངེའི་གསལ་བསྡུད་སྲོལ་བཙུགས་སྡེ་ཚན" ལས་ ཁྱོད་རའི་བརྡ་འཕྲིན་སྲོལ་བཙུགས་རྒྱུད་བརྡ་འཕྲིན་གཏོང་ལེན་\'འབད་ནི་དེ་ སྒེར་དབང་བཟོ་བཏུབ།';
$string['updatenotifications'] = 'ཁྱབ་བསྒྲགས་དུ་མཐུན་བཟོ།';
$string['updatenotificationsubject'] = 'མོ་ཌེལ་དུས་མཐུན་བཟོ་ནིའི་ཐོབ({$a->siteurl})ནང་།';
$string['updatenotifybuilds'] = 'གསར་བསྐྲུན་འབད་ཡོད་པའི་སྐོར་ལས་དྲན་བརྡ་འབད།';
$string['updatenotifybuilds_desc'] = 'ལྕོགས་ཅན་བཟོ་བ་ཅིན་ དུས་མཐུན་བཟོ་ནི་ཡོད་པའི་མོ་ཌེལ་གྱི་གསང་ཡིག་འདི་ཡང་ ད་ལྟ་གི་ཐོན་དེབ་གསརཔ་འདི་དང་དྲན་བརྡ་གཟུགས་གཞི་གསརཔ་ཚུ་ག་ར་ཐོབ། གཟུགས་གཞི་འདི་ཚུ་ཧེ་མ་ལས་ཡོད་པའི་མོ་ཌེལ་ནང་ལུ་རིམ་པ་བཞིན་དུ་འབད་ཡར་རྒྱས་བཟོ་ཡོད་མི་ཚུན་ཨིན། འདི་ཚུ་སྤྱིར་བཏང་གིས་བདུན་རིམ་བཞིན་དུ་འཐོན་འོང་། གལ་སྲིད་ལྕོགས་མིན་བཟོ་བ་ཅིན་་དུས་མཐུན་བཟོ་ནི་ཡོད་པའི་དྲན་བརྡ་འདི་མོ་ཌེལ་ཐོན་རིམ་སྦོམ་སྦེ་འོངམ་ད་རྐྱངམ་ཅིག་འབད་འོང་། གཞི་སྒྲིག་འདི་གིས་plugins འབད་བའི་སྐབས་ལུ་བཀོད་རིས་ཤོག་ལེབ་ནང་ལུ་གནོད་པ་མི་འོང་།';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 འདི་ནང་ལག་ལེན་པ་ཚུ་གི་ཆོག་ཡིག་དང་རྒྱབ་བསྣོན་འབད་ཚུགས་པའི་་ཉེན་སྲུང་འབད་ནི་གནས་སྡུད་ཚུ་ག་ར་ས་སྒོ་འདི་ནང་འོང་། འདི་འབདཝ་ལས་ ཁྱོད་ཀྱི་རྒྱབ་གནོན་འབད་ནི་དང་གཞི་སྒྲིག་ གནང་བ་ཚུ་ལ་ལུ་ཅིག་སོར་འགྱོ་འགྱོཝ་འོང་། <br /> See the <a href="http://docs.moodle.org/dev/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 release notes</a> for full details.</p>';
$string['upgrade197noticesubject'] = 'མུ་ཌོལ་ ༡.༩.༧་ཡར་བསྐྱེད་ཀྱི་སྲུང་སྐྱོབ་ བརྡ་བསྐུལ་ཚུ།';
$string['upgrade197salt'] = 'ཆོག་ཡིག་ཨར་རྐུན་ཉེན་ཁ་མར་ཕབ་འབད་ནི་དོན་ལུ་ ཁྱོད་ཀྱི་ཆོག་ཡིག་སོལཌ་འོས་སྦྱོར་སྦོམ་འབད་སྒྲིག།<br />རྒྱས་བཤད་ཀྱི་དོན་ལུ་<a href="{$a}" target="_blank">ཆོག་ཡིག་སོལཌ་ཏྲིང་ ཡིག་ཐོག་བཀོད་དེ་</a>བལྟ་ད།';
$string['upgradeforumread'] = 'ལྷག་མི་/མ་ལྷག་མི་གྲོས་གནས་བསྐྱོད་ཚུ་རྗེས་འཚོལ་བལྟ་ནི་ལུ་ མུ་ཌེལ་ ༡.༥་ ནང་ལུ་ཁྱད་རྣམ་གསརཔ་གཅིག་ཁ་སྐོང་རྐྱབས་ཡོད།<br />ཁྱོད་ཀྱི་ ལས་འགན་འདི་ལག་ལེན་འཐབ་ནི་དོན་ལུ་ <a href="{$a}">ཁྱོད་རའི་ཐིག་ཁྲམ་ཚུ་ དུས་མཐུན་བཟོ།</a>.';
$string['upgradeforumreadinfo'] = 'ལྷག་མི་/མ་ལྷག་མི་གྲོས་གནས་བསྐྱོད་ཚུ་རྗེས་འཚོལ་བལྟ་ནི་ལུ་ མུ་ཌེལ་ ༡.༥་ ནང་ལུ་ཁྱད་རྣམ་གསརཔ་གཅིག་ཁ་སྐོང་རྐྱབས་ཡོད། ཁྱོད་ཀྱི་ ལས་འགན་འདི་ལག་ལེན་འཐབ་ནི་དོན་ལུ་ ཡོད་བཞིན་པའི་གནས་བསྐྱོད་ཚུ་གི་རྗེས་འཚོལ་བརྡ་དོན་ཆ་མཉམ་ཡོད་པའི་ ཁྱོད་རའི་ཐིག་ཁྲམ་ཚུ་ དུས་མཐུན་བཟོ། འདི་གི་ཁྱོད་རའི་ས་ཁོངས་སྦོམ་ཆུང་ལུ་བརྟེན་ཏེ་ ཡུན་རིང་(ཆུ་ཚོད་ཚུ་)སྒོར་ནི་དང་ གནས་སྡུད་གཞི་རྟེན་ལུ་ཧ་ལམ་གར་དྲགས་འབྱུང་འོང་ འདི་འབད་ལས་དུས་ཡུན་ཙག་ཏོག་ཏོ་གི་སྐབས་སུ་འབདཝ་དྲག། ག་དེ་སྦེ་ཨིན་རུང་ ཡར་བསྐྱེད་ཀྱི་སྐབས་སུ་ཁྱོད་རའི་ས་ཁོངས་འདི་འཕྲོ་མཐུད་དེ་ལཱ་འབད་ཡོདཔ་ ལག་ལེན་པ་ཚུ་ལུ་གནོད་སྐྱོན་མི་བྱུང་། ཁྱོད་ཀྱི་ ཚར་གཅིག་ལས་སྦྱོར་འདི་འགོ་བཙུགས་ཚརཝ་ད་ མཇུག་བསྡུ་བཅུག། (ཁྱོད་རའི་བརའུ་ཟར་གྱི་ཝིན་ཌོ་འདི་ ཁ་ཕྱེ་བཞག།) ག་དེ་སྦེ་ཨིན་རུང་ ཁྱོད་ཀྱི་ ཝིན་ཌོ་ཁ་བསྡམས་སྦེ་ལས་སྦྱོར་དེ་བཀག་བཞག་པ་ཅིན་:ཚ་གྱང་མ་ལང་ ཁྱོད་ཀྱི་ལོག་འགོ་བཙུགས་བཏུབ།<br /><br />ཁྱོད་ཀྱི་ ད་ལྟོ་ལས་སྦྱོར་དེ་ཡར་བསྐྱེད་འབད་ནི་འགོ་བཙུགས་ནི་ཨིན་ན?';
$string['upgradelogs'] = 'ཆ་ཚང་ལས་འགན་གི་དོན་ལུ་ ཁྱོད་རའི་དྲན་དེབ་རྒསཔ་ཚུ་ཡར་བསྐྱེད་འབད་དགོཔ་འདུག།<a href="{$a}">བརྡ་དོན་ མངམ།</a>';
$string['upgradelogsinfo'] = 'དྲན་དེབ་ཚུ་བསྲུང་བཞག་ནི་ལམ་ལུགས་ནང་ འཕྲལ་ཁམ་ཅིག་ཁར་བསྒྱུར་བཅོས་ཚུ་དག་པ་ཅིག་བཟོ་ནུག། རེ་རེ་གི་གཞི་རྩ་ལུ་ཡོད་པའི་དྲན་དེབ་རྙིངམ་ཚུ་ཆ་མཉམ་ལྟ་ཚུགས་ནི་དོན་ལུ་ དྲན་དེབ་རྙིངམ་ཚུ་ཡར་བསྐྱེད་འབད་དགོཔ་ཨུན། འདི་གི་ཁྱོད་རའི་ས་ཁོངས་བསྟུན་ཏེ་ ཡུན་རིང་(དཔེར་ན་ ཆུ་ཚོད་ལེ་ཤ་)སྒོར་ནི་དང་ ས་ཁོངས་སྦོམ་གི་གནས་སྡུད་གཞི་རྟེན་ལུ་ཧ་ལམ་གར་དྲགས་འབྱུང་འོང་། ཁྱོད་ཀྱི་ ཚར་གཅིག་ལས་སྦྱོར་འདི་འགོ་བཙུགས་ཚརཝ་ད་ (བརའུ་ཟར་གྱི་ཝིན་ཌོ་འདི་ ཁ་ཕྱེ་བཞག་སྦེ་)མཇུག་བསྡུ་བཅུག། ཚ་གྱང་མ་ལང་ དྲན་དེབ་ཚུ་ཡར་བསྐྱེད་འབད་བའི་བསྒང་ ཁྱོད་ཀྱི་ས་ཁོངས་འདི་མི་གཞན་ལུ་ལཱ་ལེགས་ཤོམ་འབད་བཏུབ། <br /><br />ཁྱོད་ཀྱི་དྲན་དེབ་ཚུ་དུས་མཐུན་བཟོ་ནི་ཨིན་ན?';
$string['upgradepluginsfirst'] = 'དུས་མཐུན་བཟོ་སྲོལ་ཡོད་མི་གེ་ར་ གཞི་བཙུགས་འབད་དགོ་པའི་རྒྱབ་སྣོན་ངོ་སྦྱོར་འབདཝ་ཨིན།';
$string['upgradepluginsinfo'] = 'plugins དུས་མཐུན་བཟོ་དོ།';
$string['upgradepluginsinfo_help'] = 'ཁྱོད་ཀྱི་plugins ལ་ལུ་ཅིག་གི་དོན་ལས་ དུས་མཐུན་བཟོ་ནིའི་དོན་ལས་ཐོབ་དབང་ཡོད། དེ་ཚུ་གེ་ར་ Moodle database ཡར་དྲག་མ་བཟོ་བའི་ཧེ་མ་འབད་དགོ ཁྱོད་ཀྱི་གནས་ཁོངས་དེ་གིས་ རང་བཞིན་ཡར་དྲག་བཟོ་ནི་ལུ་རྒྱབ་སྐྱོར་མེད་པ་ཅིན་ plugin ཐོན་རིམ་གསརཔ་དེ་ ཁྱོད་རང་གིས་ ཕབ་ལེན་འབད་དེ་ གཞི་བཙུགས་འབད་དགོ';
$string['upgradesettings'] = 'གཞི་སྒྲིག་གསརཔ་ཚུ།';
$string['upgradesettingsintro'] = 'ག་ལུ་སྟོན་ཡོད་པའི་གཞི་སྒྲིག་དེ་ཚུ་ Moodle ་ཡར་བསྐྱེད་འབད་བའི་སྐབས་སུ་ ཁ་སྐོང་རྐྱབས་ཡོད། སྔོན་སྒྲིག་ཚུ་ལུ་ཉེར་མཁོ་བའི་བསྒྱུར་བཅོས་ག་ཅི་འབད་རུང༌བཟོ་བཞིནམ་ལས་ ཤོག་ལེབ་འདི་གི་མཇུག་ལུ་ཡོད་པའི་&quot;སྲུངས་ བསྒྱུར་བཅོས་ཚུ&quot;ཨེབ་རྟ་དེ་ ཨེབ་གཏང་།';
$string['upgradestalefiles'] = 'བླ་བསྲེས་ཡོད་པའི་Moodle་ཐོན་རིམ་བདའ་ཟུན་ནུག་ དུས་མཐུན་བཟོ་ནི་འཕྲོ་མཐུད་མི་ཚུགས་པས།';
$string['upgradestalefilesinfo'] = 'མོ་ཌེལ་དུས་མཐུན་བཟོ་ནི་ལཱ་འདི་བར་བཀག་འབད་ནུག་ ག་ཅི་འབད་ཟེར་བ་ཅིན་ ཉུང་མཐའ་མོ་ཌེལ་ཐོན་རིམ་གཉིས་ནང་ལས་ཀྱི་PHP ཡིག་གུ་ཚུ་སྣོད་དེབ་ནང་ལུ་བདའ་ཟུན་ནུག ཨ་ནི་འདི་གིས་ཤུལ་མ་སྟབས་མ་བདེཝ་སྦོམ་འཐོན་འོང་ འདི་འབདཝ་ལས་འཕྲོ་མཐུད་ནི་གི་དོན་ལུ་ མོ་ཌེལ་གྱི་སྣོད་དེབ་ནང་ལུ་ ཡིག་སྣོད་ཚུ་མོ་ཌེལ་གཅིག་རྐྱངམ་ཅིག་གི་ནང་ལུ་ཡོདཔ་བཟོ་དགོ། ཁྱོད་ཀྱིས་མོ་ཌེལ་གྱི་སྣོད་དེབ་ཧིང་སངས་ས་བཟོ་ནིའི་དོན་ལུ་འོག་ལུ་ཡོད་པའི་ཐབས་ལམ་འདི་ལག་ལེན་འཐབ་དགོ་: * ད་ལྟོ་ཡོད་པའི་མོ་ཌེལ་གྱི་སྣོད་དེབ་དེ་ལུ་མི་གསརཔ་ཅིག་བཏགས་ "moodle_old" *མོ་ཌེལ་གསརཔ་གི་སྣོད་དེ་གཅིག་ སྤུས་ཚད་ཅན་གྱི་མོཌེལ་སྡེབ་ཚན་དང་ཡང་ཅིན་མོ་ཌེལCVS or GIT repositories * move the original config.php file and any non-standard plugins from the "moodle_old" སྣོད་དེབ་ནང་ལས་མོཌེལ་གསར་པའི་སྣོད་དེབ་ནང་ལུ་ཧིང་སངས་ས་ཡོད་མི་འདི་ནང་ལུ་སྤོ་བཤུས་འབད། འདི་ལས་ ཨ་ནི་ཤོག་ལེབ་འདི་ཁ་གསོ་ཞིནམ་ད་ མོ་ཌེལ་དུས་མཐུན་བཟོ་བཅུག་དགོ ཨ་ནི་ཉེན་བརྡ་འདི་ ཧེ་མ་ལས་ཡོད་པའི་མོ་ཌེལ་འདི་གི་ཐོག་ཁ་ལུ་སྤུས་ཚད་ལྡན་པའི་མོ་དེལ་དེབ་གསརཔ་ཅིག་ཁ་འའཕྱེཝ་ད་འབདཝ་ཨིན། འདི་མ་གཞི་དུས་མཐུནཆུང་ཀུ་རེ་བཟོ་ནིའི་དོན་ལུ་བཏུབ་ཨིན་རུང་ མོ་ཌེལ་དུས་མཐུན་སྦོམ་བཟོ་ནིའི་དོན་ལུ་ལེགས་ཤོམ་མིན། ཉེན་བརྡ་འདི་གཞན་ཡང་ CVS, SVN or GIT repository,ནང་ལས་བཏོན་ནི་ཚུ་ག་ར་མ་རྫོགསཔ་དང་ཡང་ན་ དུས་མཐུན་བཟོ་ནི་ཀྲིག་ཀྲི་མ་འགྱོ་བའི་ཧྐབས་ལུ་འོངམ་ཨིན། འདི་གི་སྐབས་སུ་ ཁྱོད་ཀྱིས་གློག་རིག་ལས་སྦྱོར་འབད་མ་ཚར་ཚུན་ཚོད་ལུ་སྒུག་དགོ་ ཡང་ཅིན་ ཕྱག་ནིའི་བཀོད་བྱ་འདི་ལོག་འབྱིན་ཏེ་
གློག་རིག་ལས་སྦྱོར་ལོག་འབད་བཅུག་དགོ དེ་གི་སྐོར་ལས་ཁ་གསལ་འདི་ དུས་མཐུན་བཟོ་ནིའི་ཡིག་ཆས་<a href="{$a}">{$a}</a>ནང་ལས་ཐོབ།';
$string['upgradestart'] = 'གནས་སྡུད་དྲན་མཛོད་ཀྱི་མོ་ཌེལ་ ད་ལྟོ་ར་དུས་མཐུན་བཟོ།';
$string['upgradesure'] = 'མུ་ཌེལ་ཡིག་སྣོད་ཚུ་བསྒྱུར་བཅོས་འབད་ཡོད། ཁྱོད་ཀྱི་་སར་བར་འདི་འ་ནི་ཐོན་རིམ་:<br /><br /> rong>{$a}</strong> ལུ་རང་བཞིན་གྱིས་ཡར་བསྐྱེད་འབད་ནི་འབད་དོ། <br /><br />འདི་ཚར་གཅིག་འབད་ཚར་བ་ཅིན་ ལོག་སྟེ་འགྱོ་མི་ཚུགས།<br /><br /> <br /><br />དྲན་འཛིན་འབད་གནང ལས་སྦྱོར་འདི་གི་དུས་ཡུན་མངམ་སྒོར་འོང་།<br /><br /> ཁྱོད་ཀྱི་ སར་བར་འདི་འ་ནི་ཐོན་རིམ་ལུ་ཡར་བསྐྱེད་བཏང་ནི་ངེས་གཏན་ཨིན་ན?';
$string['upgradetimedout'] = 'དུས་མཐུན་བཟོ་ནིའི་དུས་ཚོད་རྫོགས་སོང་ནུག དུས་མཐུན་བཟོ་འདི་ལོག་འགོ་བཙུགས་དགོ་པས།';
$string['upgradingdata'] = 'གནས་སྡུད་ ཡར་བསྐྱེད་བཏང་དོ།';
$string['upgradinglogs'] = 'དྲན་དེབ་ཚུ་ ཡར་བསྐྱེད་བཏང་དོ།';
$string['upgradingversion'] = 'ཐོན་རིམ་གསར་པའི་ནང་ལུ་ དུས་མཐུན་བཟོ་དོ།';
$string['upwards'] = 'ཡར་ཕྱོགས།';
$string['useblogassociations'] = 'འབྲེལ་གནད་ཚུ་ལྕོགས་ཅན་བཟོ།';
$string['useexternalyui'] = 'ཡོངས་འབྲེལ་གྱི་YUI དེ་མཛོད་ཚུ་ལག་ལེན་འཐབ།';
$string['user'] = 'ལག་ལེན་པ།';
$string['userbulk'] = 'ལག་ལེནཔ་སྦུང་ཚད་ཅན་གྱི་ བྱ་བ་ཚུ།';
$string['userlist'] = 'ལག་ལེནཔ་ཚུ་གིས་ཐོ་བཀོད་ བརྡ་འཚོལ་འབད།';
$string['userpolicies'] = 'ལག་ལེན་པའི་སྲིད་བྱུས་ཚུ།';
$string['userpreference'] = 'ལག་ལེན་པའི་གདམ་ཁ།';
$string['userquota'] = 'ལག་ལུན་པའི་ཐོབ་ཐངས།';
$string['users'] = 'ལག་ལེན་པ་ཚུ།';
$string['usesitenameforsitepages'] = 'ས་སྒོ་ནང་ལུ་ས་སྒོ་གི་མིང་ལག་ལེན་འཐབ།';
$string['usetags'] = 'ངོ་རྟགས་ཚུ་གིས་ལས་འགན་ལྕོགས་ཅན་བཟོ་ཡོདཔ།';
$string['validateerror'] = 'འདི་བེ་ལུ་དེ་ནུས་མེད།';
$string['verifychangedemail'] = 'གློག་འཕྲིན་བསྒྱུར་བཅོས་འབདཝ་ད་ ཌོ་མེན་ཚུ་བཀག་དམ་འབད';
$string['warningcurrentsetting'] = 'ནུས་མེད་ འཕྲལ་གྱི་གནས་གོང་:{$a}';
$string['warningiconvbuggy'] = 'ཁྱོད་ཀྱི་ཐོན་རིམ་པར་རྟགས་འདི་གིས་
//IGNORE modifier. ལུ་རྒྱབ་སྐྱོར་མི་འབད་བས། ཁྱོད་ཀྱིས་UTF-8 ཡིག་གུ་ལུ་ལག་ལེན་འཐབ་མ་བཏུབ་པའི་ mbstring extension གཞི་བཙུགས་འབད་དགོ་པས།';
$string['webproxy'] = 'ཝེབ་པོརོ་སི།';
$string['webproxyinfo'] = 'གལ་སྲིད་ཁྱོད་ཀྱི་མུ་ཌེལ་སར་བར་གྱི་ཐད་ཀར་དུ་ཨིན་ཊར་ནེཊི་འཛུལ་སྤྱོད་འབད་མ་ཚུགས་པ་ཅིན་འོག་གི་གདམ་ཁ་ཚུ་ནང་བཀང་། ཨིན་ཊར་ནེཊི་འཛུལ་སྤྱོད་འབད་ནི་འདི་ གནས་སྟངས་གནས་སྡུད་ སྐད་ཡིག་སྦུང་ཚན་ ཨར་ཨེསི་ཨེསི་མཁོ་སྤྲོད་འབད་ནི་ཚུ་ ཆུ་ཚོད་གླིང་སྡེ་ལ་སོགས་པ་ཚུ་ ཕབ་ལེན་གྱི་དོན་ལུ་དགོས་མཁོ་ཡོདཔ་ཨིན། <br /><em>པི་ཨེཆ་པི་ཀུརལ་རྒྱ་བསྐྱེད་འདི་ཧ་ཅང་གིས་འོས་སྦྱོར་འབད་ཡོདཔ་ཨིན།</em>';
$string['xmlrpcrecommended'] = 'གདམ་ཁ་ཅན་གྱི་ཨེགསི་ཨེམ་ཨེལ་ཨར་པིསི་རྒྱ་བསྐྱེད་དེ་གཞི་བཙུགས་འབད་བ་ཅིན་མུ་ཌེལ་ཡོངས་འབྲེལ་བཟོ་ནི་ལས་འགན་ལུ་ཕན་ཐོགས་ཅན་ཅིག་ཨིན།';
$string['yuicomboloading'] = 'YUI combo སྐྱེལ་བཙུགས་འབད་དོ།';
$string['ziprequired'] = 'ཛིཔ་པི་ཨེཆ་པི་རྒྱ་བསྐྱེད་དེ་ད་ལྟོ་མོ་ཌེལ་ལུ་དགོས་མཁོ་ཡོད བརྡ་དོན་ཛིཔ་ཟུང་ལྡན་ཚུ་ཡང་ན་པི་སི་ཨེལ་ཛིཔ་དཔེ་མཛོད་དེ་ཚུ་ལག་ལེན་འཐབ་ནི་མེད།';
$string['zlibenabled'] = 'zlib ལྕོགས་ཅན་བཟོ་ཡོདཔ།';
